package edu.northwestern.at.utils.xml;

/*  Please see the license information at the end of this file. */

import java.util.*;
import java.io.*;
import java.net.*;

import edu.northwestern.at.utils.*;

/** XML tag classifier for TEI XML.
 */

public class TEITagClassifier extends XMLTagClassifier
{
    /** Create TEI tag class.
     */

    public TEITagClassifier()
    {
        super();
                                //  TEI soft tags.
        setSoftTags
        (
            "abbr add address author c corr date emph " +
            "foreign gap g hi l lb location mentioned milestone money name num " +
            "organization orig pb pc person q quote reg rs sb sic soCalled " +
            "sub sup term time title unclear w" ,
            true
        );
                                //  TEI jump tags.
        setJumpTags
        (
            "bibl figdesc figDesc figure footnote note ref tailnote" ,
            true
        );
                                //  TEI main/side tags.

        setTagClass( "front" , "front" , true );
        setTagClass( "back" , "back" , true );

        setTagClass
        (
            "side" ,
            "bibl castGroup castItem castList figdesc figDesc figure " +
            "head headnote note ref role roledesc roleDesc speaker " +
            "stage tailnote trailer" ,
            true
        );
    }

    /** Is tag side text?
     *
     *  @param  tag     The XML tag.
     *
     *  @return         True if tag is side text.
     */

    public boolean isSideTextTag( String tag )
    {
        String tagClass = getTagClass( tag );

        return ( tagClass != null ) && ( tagClass.equals( "side" ) );
    }
}

/*
Copyright (c) 2008, 2013 by Northwestern University.
All rights reserved.

Developed by:
   Academic and Research Technologies
   Northwestern University
   http://www.it.northwestern.edu/about/departments/at/

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal with the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimers.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimers in the documentation and/or other materials provided
      with the distribution.

    * Neither the names of Academic and Research Technologies,
      Northwestern University, nor the names of its contributors may be
      used to endorse or promote products derived from this Software
      without specific prior written permission.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.
*/



