package edu.northwestern.at.morphadorner.corpuslinguistics.namestandardizer;

/*  Please see the license information at the end of this file. */

import java.io.*;
import java.net.*;
import java.util.*;

import edu.northwestern.at.utils.*;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.*;

/** Interface for a Name Standardizer.
 */

public interface NameStandardizer
{
    /** Load names from a file.
     *
     *  @param  properNamesFileName     File containing proper names data.
     */

    public void loadNames( String properNamesFileName )
        throws IOException;

    /** Load names from a collection of names.
     *
     *  @param  properNamesCollection   Collection containing proper names.
     */

    public void loadNames( Collection<String> properNamesCollection );

    /** Load names from a lexicon.
     *
     *  @param  lexicon     The lexicon from which to load names.
     */

    public void loadNamesFromLexicon( Lexicon lexicon )
        throws IOException;

    /** Return number of names.
     *
     *  @return     Number of names known to standardizer.
     */

    public int getNumberOfNames();

    /** Check if we should not standardize a name.
     *
     *  @param  properName  Name to check.
     *
     *  @return             True to avoid standardizing name.
     *
     *  <p>
     *  Names that are initials or contain periods are not standardized
     *  by default.
     *  </p>
     */

    public boolean dontStandardize( String properName );

    /** Preprocess proper name.
     *
     *  @param  properName  Proper name to preprocess before standardization.
     *
     *  @return             Preprocessed proper name, ready for standardization.
     */

    public String preprocessProperName( String properName );

    /** Returns standard proper name given a proper name.
     *
     *  @param  properName  The proper name.
     *
     *  @return             The standard proper name.
     */

     public String standardizeProperName( String properName );
}

/*
Copyright (c) 2008, 2013 by Northwestern University.
All rights reserved.

Developed by:
   Academic and Research Technologies
   Northwestern University
   http://www.it.northwestern.edu/about/departments/at/

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal with the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimers.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimers in the documentation and/or other materials provided
      with the distribution.

    * Neither the names of Academic and Research Technologies,
      Northwestern University, nor the names of its contributors may be
      used to endorse or promote products derived from this Software
      without specific prior written permission.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.
*/



