package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ZHCN extends CLangProfile {
  private static final String name = "zh-cn";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ZHCN() {
    init();
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }

  private void init() {
    n_words[0] = 4792118;
    n_words[1] = 1709982;
    n_words[2] = 314544;

    freq.put("\u4e3a\u4e2d", 1501);
    freq.put("\u4e0d\u540c\u7684", 722);
    freq.put("\u7b2c\u4e8c", 2122);
    freq.put("\u4f0a", 2356);
    freq.put("\u6cb3\u5357", 853);
    freq.put("\u968f", 1152);
    freq.put("\u8bbe\u8ba1", 1764);
    freq.put("\u6297", 915);
    freq.put("\u4e3a\u4e3b", 1114);
    freq.put("\u6599", 1677);
    freq.put("\u3001\u56db", 1328);
    freq.put("\u9020", 2929);
    freq.put("\u4e3a\u4e08", 1939);
    freq.put("\u59d4\u5458", 1628);
    freq.put("\u58f0\u4efb", 875);
    freq.put("\u4e3a\u4e00", 949);
    freq.put("\u822c", 2569);
    freq.put("\u53d1\u751f", 1318);
    freq.put("\u4f5c", 14815);
    freq.put(",\u6216", 1328);
    freq.put("\u6cb3", 5488);
    freq.put(" \u5e74,", 2603);
    freq.put("\u4e34", 983);
    freq.put(" \u5e74)", 2400);
    freq.put("\u7136", 2677);
    freq.put("\u573a", 5846);
    freq.put("\u7ebf", 7551);
    freq.put("\u4e8b\u52a1", 628);
    freq.put("\u4e2d\u4e00", 647);
    freq.put("\u65e5,", 1548);
    freq.put("\u53cd", 2487);
    freq.put("\u724c", 1136);
    freq.put("\u79d1", 10282);
    freq.put(",\u6210", 1293);
    freq.put("\u8bdd", 1875);
    freq.put("\u5173\u7cfb", 1044);
    freq.put("\u77e5", 2149);
    freq.put("\u9664", 1569);
    freq.put(",\u6240", 997);
    freq.put("\u6709\u690d\u7269", 938);
    freq.put("\u4e16\u7eaa", 2136);
    freq.put("\u5efa\u3001", 593);
    freq.put("\u5176", 12214);
    freq.put("\u7eff", 800);
    freq.put("\u7b2c\u4e00", 3441);
    freq.put("\u300b", 12787);
    freq.put("\u7b2c\u4e09", 1132);
    freq.put("\u5206\u5e03", 3839);
    freq.put("\u5f15", 4831);
    freq.put("\u5e94", 3484);
    freq.put("\u4f5c,", 878);
    freq.put("\u548c\u4e01", 641);
    freq.put("\u516c\u8def", 1194);
    freq.put("\u4e3a\u4e86", 902);
    freq.put("\u6280\u672f", 1644);
    freq.put("\u548c\u4e08", 1029);
    freq.put("\u5927\u6218", 639);
    freq.put("\u88ab\u79f0", 1048);
    freq.put("\u4eba\u5de5\u5f15", 2908);
    freq.put("\u3001\u8d35\u5dde", 848);
    freq.put("\u4e01\u3001", 2210);
    freq.put(",\u5206", 865);
    freq.put("\u884c\u4e0d\u533a", 1022);
    freq.put("\u4e01\u3002", 2121);
    freq.put("\u89c6", 4552);
    freq.put("\u7b49\u5730,", 3010);
    freq.put("\u4eba\u4f7f", 892);
    freq.put("\u5f55", 1700);
    freq.put(",\u82f1", 974);
    freq.put("\u6559", 9551);
    freq.put("\u5e74\u7684", 1358);
    freq.put("\u4e5f", 8266);
    freq.put(")\u662f\u4e00", 2670);
    freq.put("\u5728\u4e01", 899);
    freq.put("\u62ec", 3402);
    freq.put("\u4ea7\u54c1", 768);
    freq.put("\u4e0d\u751f", 996);
    freq.put("\u57fa", 6619);
    freq.put("\u5e7f", 7680);
    freq.put("\u76ee\u524d", 4402);
    freq.put("\u4e0a", 15305);
    freq.put("\u6700\u540e", 916);
    freq.put("\u540e", 12165);
    freq.put("\u9891", 899);
    freq.put("\u5e95", 1106);
    freq.put(",\u6307", 584);
    freq.put("\u4e00\u6b21", 948);
    freq.put("\u5ca9", 988);
    freq.put("\u8db3", 2749);
    freq.put("\u65af\u7279", 879);
    freq.put("\u7684\u5bb6", 638);
    freq.put("\u7538", 900);
    freq.put("\u79bb", 1553);
    freq.put("\u6210\u7acb\u4e8e", 917);
    freq.put("\u4e08\u5927", 637);
    freq.put("\u9655\u897f\u3001", 802);
    freq.put(" \u5927", 1004);
    freq.put(" \u5929", 581);
    freq.put("\u4e01\u519b", 992);
    freq.put("\u665a", 728);
    freq.put("\u7ec4\u6210", 1458);
    freq.put("\u8d5b,", 689);
    freq.put("\u90e1", 912);
    freq.put("\u5e03\u5728", 1655);
    freq.put("\u6b63\u5f0f", 1275);
    freq.put("\u4ee5\u4e08", 590);
    freq.put("\u4e3b\u8981", 4270);
    freq.put("\u53f7", 5641);
    freq.put("\u56e2\u4f53", 692);
    freq.put(" \u591a", 650);
    freq.put("\u79fb", 1075);
    freq.put("\u6001", 1462);
    freq.put("\u8282", 2402);
    freq.put("\u6784", 3349);
    freq.put("\u6d88", 1003);
    freq.put("\u4e01\u514b", 614);
    freq.put("\u6e56\u4e0d", 1117);
    freq.put("\u5a92", 887);
    freq.put("\u5e15", 667);
    freq.put("\u56fd ", 738);
    freq.put("\u5206,", 694);
    freq.put("\u957f ", 666);
    freq.put("\u7684\u7b2c", 1619);
    freq.put("\u4eba\u4e08", 706);
    freq.put("\u8fc7\u7a0b", 791);
    freq.put("\u7eaa", 4115);
    freq.put("\u53f0\u6e7e", 6649);
    freq.put("\u4eba\u4e01", 945);
    freq.put("\u672f", 4302);
    freq.put("\u4e01\u5170", 618);
    freq.put("\u52a0\u4e58", 908);
    freq.put("\u7684\u4f11", 1722);
    freq.put("\u4f55\u3002", 612);
    freq.put("\u6b7b\u5173", 792);
    freq.put("\u5e7f\u897f\u3001", 800);
    freq.put(",\u4f4d\u4e8e", 2555);
    freq.put("\u6c49", 2630);
    freq.put("\u514b", 7641);
    freq.put("\u4eca", 2840);
    freq.put("\u524d", 10878);
    freq.put("\u53cc", 1530);
    freq.put("\u591a\u751f", 1267);
    freq.put("\u4e8e\u53f0", 1035);
    freq.put("\u53f0\u4e0d", 1436);
    freq.put(" \u5e74\u81f3", 781);
    freq.put("\u4e0d\u540c", 2049);
    freq.put("\u8054", 6161);
    freq.put("\u4eba\u4e58", 690);
    freq.put("\u5377", 760);
    freq.put(" \u9999", 692);
    freq.put("\u5bfc", 2989);
    freq.put("\u867d\u7136", 581);
    freq.put(", ", 8207);
    freq.put("\u4e08", 146015);
    freq.put("\u518d", 1221);
    freq.put("\u8f83", 2013);
    freq.put("\u5357\u7b49", 606);
    freq.put("\u5e93", 1470);
    freq.put(",\u603b", 746);
    freq.put("\u6c9f", 938);
    freq.put("\u662f\u53f0", 693);
    freq.put(",\u800c", 3223);
    freq.put("\u6210\u3002", 674);
    freq.put("\u6c34", 5383);
    freq.put("\u753a", 605);
    freq.put(" \u65e5\u81f3", 616);
    freq.put("\u6240", 11521);
    freq.put("\u65c5", 1334);
    freq.put("\u6444", 716);
    freq.put("\u91cd", 5583);
    freq.put("\u7ed3", 3008);
    freq.put("\u4e08(\u5b66", 778);
    freq.put("\u8db3\u7403", 1709);
    freq.put("\u5b66", 28915);
    freq.put("\u57f9", 3476);
    freq.put("\u6301", 2131);
    freq.put("\u6280", 2723);
    freq.put("\u8d35\u5dde", 1074);
    freq.put("\u6807", 3335);
    freq.put("\u4e0d\u9762", 1014);
    freq.put("\u4e88", 591);
    freq.put("\u8d8a", 2100);
    freq.put("\u9655\u897f", 1134);
    freq.put("\u56e0\u4e3a", 1284);
    freq.put("\u5b66\u4e2d", 593);
    freq.put("\u52a0", 7203);
    freq.put("\u7684\u5730\u533a", 3123);
    freq.put("\u9999\u6e2f", 8632);
    freq.put("\u7f29", 977);
    freq.put("\u6709\u5173", 606);
    freq.put("\u5185\u4fe1", 885);
    freq.put(" \u662f\u4e00", 701);
    freq.put("\u8def\u7ebf", 871);
    freq.put("\u8d35", 1643);
    freq.put("\u90e8\u5206", 2341);
    freq.put("\u6545", 1906);
    freq.put("- ", 821);
    freq.put("\u8bc6", 1123);
    freq.put("\u4ece ", 609);
    freq.put("\u76ee\u7684", 1041);
    freq.put("\u8083\u3001", 800);
    freq.put("\u914d", 1056);
    freq.put("\u4f7f\u5170", 933);
    freq.put("\u662f\u4e01", 1437);
    freq.put("\u533a,\u5e38", 666);
    freq.put("\u6c5f", 5857);
    freq.put("\u8fde", 2790);
    freq.put("\u5361", 3152);
    freq.put("\u4e8b\u3002", 826);
    freq.put("\u7684\u7b2c\u4e00", 601);
    freq.put("\u7565", 871);
    freq.put("\u4e0b\u7684", 912);
    freq.put("\u5206\u7c7b", 693);
    freq.put(": ", 1177);
    freq.put(" \u7c73\u7684", 3008);
    freq.put("\u597d", 1250);
    freq.put("\u5b50,", 932);
    freq.put("\u8def,", 847);
    freq.put("\u4e89", 2347);
    freq.put("\u738b", 5331);
    freq.put("\u8bd1\u4e3a", 652);
    freq.put("\u662f\u4f4d\u4e8e", 587);
    freq.put("\u6216", 10994);
    freq.put("\u4e1e", 9778);
    freq.put("\u52a1", 5246);
    freq.put("\u82f1\u6587:", 1509);
    freq.put("\u65af", 13962);
    freq.put("\u6216\u79f0", 642);
    freq.put("\u6fb3", 2170);
    freq.put(" \u4e08\u4e08", 703);
    freq.put("\u8ba1\u7b97", 1077);
    freq.put("\u5236", 7035);
    freq.put("\u6c11\u65cf", 1066);
    freq.put("\u53cb", 732);
    freq.put("\u5185\u4e01", 823);
    freq.put("\u662f\u4e2d", 2851);
    freq.put("\u5b50", 9623);
    freq.put(")\u4e3a", 2108);
    freq.put("\u662f\u65e5\u672c", 698);
    freq.put("\u5b83\u662f", 712);
    freq.put("( ", 4029);
    freq.put("\u4e0d\u7684", 1824);
    freq.put("\u54e5", 1688);
    freq.put("\u53f8", 7147);
    freq.put("\u666e", 2707);
    freq.put(",\u5e76\u4e01", 652);
    freq.put("\u3001\u9655", 800);
    freq.put("\u4e08\u5b66", 961);
    freq.put("\u4e09", 7927);
    freq.put("\u518c", 628);
    freq.put("\u672a\u7531\u4eba", 2713);
    freq.put("\u8fbe ", 635);
    freq.put("\u8d1f", 1207);
    freq.put(",\u4e3b\u8981", 1207);
    freq.put("\u5723", 2664);
    freq.put("\u30a2", 2133);
    freq.put("\u5927", 34268);
    freq.put("\u7684\u4f7f", 1923);
    freq.put("\u7684\u5927", 1230);
    freq.put("\u5e74\u95f4", 605);
    freq.put("\u4e08\u5bb6", 1182);
    freq.put("\u652f", 2892);
    freq.put("\u8bb0", 2357);
    freq.put("\u5f62\u6210", 784);
    freq.put("\u72b6", 1446);
    freq.put("\u4f7f\u3002", 1718);
    freq.put("\u4f7f\u3001", 1407);
    freq.put("\u6743", 2775);
    freq.put("\u5e74),", 737);
    freq.put("\u4e49", 4779);
    freq.put("\u4ea4\u5927", 1013);
    freq.put("\u91cc", 8179);
    freq.put("\u521b\u4f5c", 725);
    freq.put("\u5fb7·", 778);
    freq.put("\u5f53", 5254);
    freq.put(" \u5bb6", 600);
    freq.put("\u3001\u7518", 833);
    freq.put("\u4f01\u4e1a", 965);
    freq.put("\u4e08\u5c5e\u7684", 710);
    freq.put("\u4e8c\u5341", 706);
    freq.put(" \u65e5 ", 1067);
    freq.put("\u5177", 2485);
    freq.put("\u7528\u7684", 1236);
    freq.put("\u8083", 1126);
    freq.put("\u5904\u7406", 904);
    freq.put(",\u662f", 13170);
    freq.put("\u4e00\u4e08", 695);
    freq.put(" \u7c73", 6968);
    freq.put("\u5e7f\u64ad", 596);
    freq.put("\u4e08\u5c0f", 1097);
    freq.put("\u5185", 8287);
    freq.put("\u4e1c", 12690);
    freq.put(",\u7b80\u79f0", 1929);
    freq.put("\u690d\u7269,", 1199);
    freq.put("\u5ea7", 2603);
    freq.put("\u4e00\u4e2a", 9742);
    freq.put("\u65af\u5766", 867);
    freq.put("\u7c73\u7684\u5730", 2908);
    freq.put("\u4e86 ", 641);
    freq.put("\u5176\u4ed6", 1807);
    freq.put("\u533a", 18524);
    freq.put("\u793e", 4420);
    freq.put("\u65c1", 959);
    freq.put("\u6742", 1265);
    freq.put("\u4e08\u5c5e", 948);
    freq.put("\u4f1a\u7684", 752);
    freq.put("\u6848", 1633);
    freq.put("\u5f52", 696);
    freq.put("\u5ddd\u3001", 1254);
    freq.put(" )\u662f", 697);
    freq.put("\u4fdd", 3387);
    freq.put(",\u4e8e ", 2118);
    freq.put("()\u662f", 1113);
    freq.put("\u9762", 6531);
    freq.put("\u62e5\u6709", 1075);
    freq.put("\u7ee7", 1038);
    freq.put("\u4e8b\u7684", 883);
    freq.put("),\u662f", 2411);
    freq.put("\u4e08\u5c71", 758);
    freq.put(" \u5c0f", 894);
    freq.put("\u6df1", 1422);
    freq.put("\u7531 ", 647);
    freq.put("\u5de5\u5f15\u4e9a", 2908);
    freq.put("\u7cfb", 8292);
    freq.put("\u4e0d\u519b", 620);
    freq.put("\u662f\u4f4d", 626);
    freq.put("\u4e07", 2760);
    freq.put("\u4e0d\u516c", 924);
    freq.put("\u5357\u7b49\u5730", 586);
    freq.put("\u5b66\u6821", 1549);
    freq.put("\u4f55\u7528", 717);
    freq.put("\u5dde\u3001", 1204);
    freq.put("\u4e00\u4e9a", 4760);
    freq.put("\u4e00\u4e9b", 1051);
    freq.put("\u4f5c\u5bb6", 983);
    freq.put("\u5929", 7035);
    freq.put("\u77f3", 3358);
    freq.put("\u6210\u7684", 1249);
    freq.put("\u5168\u56fd", 1074);
    freq.put("\u6559\u4e01", 619);
    freq.put("\u5f00\u59cb", 2055);
    freq.put("\u5176\u4e2d", 1933);
    freq.put("\u91ce", 1099);
    freq.put(",\u66fe", 1063);
    freq.put(",\u540e", 1255);
    freq.put("\u7269,", 2113);
    freq.put("\u5179", 634);
    freq.put("\u7c7b", 5149);
    freq.put("\u5c55", 3788);
    freq.put("\u7efc", 661);
    freq.put("\u4e00\u5ea7", 888);
    freq.put("\u5bb6\u5f8b", 640);
    freq.put(")\u662f\u4e08", 621);
    freq.put("\u4e0d\u90e8", 1509);
    freq.put("\u8d5b\u4e8b", 631);
    freq.put("(\u4e08", 745);
    freq.put("\u7b14", 614);
    freq.put("\u6797", 7036);
    freq.put("(\u4e01", 582);
    freq.put(",\u6700", 1122);
    freq.put("\u5929\u4f11", 592);
    freq.put("\u662f\u4ee5", 583);
    freq.put("\u672c", 13564);
    freq.put(",\u6709", 1486);
    freq.put("\u3001\u53f0", 689);
    freq.put("\u963f\u62c9", 760);
    freq.put("\u70b9", 3443);
    freq.put("\u636e", 3024);
    freq.put("\u7ebd", 906);
    freq.put("\u81ea\u4e01", 786);
    freq.put("\u8fc7", 6354);
    freq.put("\u514b\u65af", 708);
    freq.put("\u4e00\u4f4d", 1048);
    freq.put("\u4e1c\u4e0d", 1592);
    freq.put("\u4f7f\u56e2", 1466);
    freq.put("\u540d\u7684", 1485);
    freq.put("\u9662", 5166);
    freq.put("\u65e5)", 813);
    freq.put("\u7968", 886);
    freq.put("\u300b(", 2220);
    freq.put("\u7acb\u4e8e ", 1061);
    freq.put("\u300b,", 1819);
    freq.put("\u662f\u7f8e\u56fd", 1183);
    freq.put("\u7528\u3002", 732);
    freq.put("\u7684,", 1232);
    freq.put("\u4ee3\u8868", 1920);
    freq.put("\u6709\u9650", 1519);
    freq.put("\u30a2\u30a2\u30a2", 1275);
    freq.put("\u5c11", 2443);
    freq.put("\u6717", 953);
    freq.put("\u5229\u4e9a", 1729);
    freq.put("\u3001\u5370", 861);
    freq.put("\u4eb2", 1398);
    freq.put("\u65e5\u81f3", 621);
    freq.put("\u6e56\u5357\u3001", 689);
    freq.put("\u5206\u5b50", 582);
    freq.put("\u662f\u4e0d", 724);
    freq.put("\u662f\u4e08", 2026);
    freq.put("\u89c8", 667);
    freq.put("\u964d", 626);
    freq.put("\u540e\u6765", 990);
    freq.put("\u534f", 2640);
    freq.put("\u662f\u4e00", 8458);
    freq.put("(\u4eca", 666);
    freq.put("\u6e38\u620f", 1924);
    freq.put("\u6559\u4f1a", 604);
    freq.put("\u6559\u4f11", 765);
    freq.put("\u4e8b\u573a", 701);
    freq.put("\u8d5b", 5990);
    freq.put("\u4e5d", 2519);
    freq.put("\u8fdc", 1319);
    freq.put("\u4ea4,", 1266);
    freq.put("\u56e2", 4373);
    freq.put("\u4e0d\u3001", 2097);
    freq.put("\u4e0d\u4f7f", 1931);
    freq.put("\u4e0d\u3002", 742);
    freq.put("\u836f", 977);
    freq.put("\u8bf4", 3972);
    freq.put("\u94f6", 1422);
    freq.put("\u533a,\u591a", 1252);
    freq.put("\u6781", 1459);
    freq.put("\u3002\u5b83", 1480);
    freq.put("\u4ea4\u5927\u5229", 915);
    freq.put("\u540c", 8476);
    freq.put(" \u5e73", 1187);
    freq.put(" \u5e74", 38848);
    freq.put("\u6218", 6655);
    freq.put("\u4e9b", 2757);
    freq.put("\u3001\u798f\u5efa", 587);
    freq.put("\u5e7f\u4e1c\u3001", 761);
    freq.put("\u8ba1\u4efd", 1242);
    freq.put("\u592a", 3274);
    freq.put("\u65ad", 823);
    freq.put("\u7269\u3002\u5206", 2814);
    freq.put("\u4e30", 817);
    freq.put("\u6d32", 5289);
    freq.put("\u5168\u7403", 752);
    freq.put("\u4e01\u56fd", 1036);
    freq.put("\u5c3c", 5208);
    freq.put("\u90e8\u7684", 1067);
    freq.put("\u7ed3\u6784", 811);
    freq.put("\u4e01\u7684", 3074);
    freq.put("\u4f46", 4207);
    freq.put(",\u5e38\u751f", 669);
    freq.put("\u7535\u8111", 1011);
    freq.put("\u534e\u4eba\u6c11", 1156);
    freq.put("\u534e", 6868);
    freq.put("\u4e0d\u73b0", 1191);
    freq.put("\u6210\u5458", 1194);
    freq.put("\u662f", 61140);
    freq.put("\u9c7c", 955);
    freq.put("\u53d1\u73b0", 998);
    freq.put("\u65f6\u4ee3", 1179);
    freq.put("\u8d85\u8fc7", 649);
    freq.put("\u548c", 23304);
    freq.put("\u4f11\u4f7f", 948);
    freq.put("\u4e0a,", 1461);
    freq.put("\u4f7f\u7528", 3270);
    freq.put("\u519b\u4e8b", 699);
    freq.put("\u4e1b", 1367);
    freq.put(" \u4e0d", 1283);
    freq.put("\u8d1d", 1346);
    freq.put("\u5bb6(", 883);
    freq.put("\u5bb6,", 2992);
    freq.put("\u7531\u4eba\u5de5", 2914);
    freq.put("\u89c4\u4efd", 679);
    freq.put("\u4efd,", 752);
    freq.put("\u4e3b\u4e49", 1789);
    freq.put("\u5bbe", 780);
    freq.put("\u6218\u4e89", 1282);
    freq.put("\u6c47", 1020);
    freq.put("\u4e5d\u9f99", 820);
    freq.put("\u3001\u300a", 1198);
    freq.put("\u5916,", 1036);
    freq.put("\u7f51", 4079);
    freq.put("\u8457", 2998);
    freq.put(" \u4e2d\u56fd", 719);
    freq.put("\u4e0d\u533a", 1235);
    freq.put("\u4f11\u4f11", 1177);
    freq.put("\u56e0", 6183);
    freq.put("\u5165", 4429);
    freq.put("\u884c,", 1162);
    freq.put("\u606f", 1214);
    freq.put("\u4ea7\u751f", 952);
    freq.put("\u987f", 1362);
    freq.put("\u6700", 10271);
    freq.put("\u7684\u5c0f", 1525);
    freq.put("\u5458\u3002", 605);
    freq.put("\u7edf\u6cbb", 615);
    freq.put("\u4e08(", 2586);
    freq.put("\u4e08,", 5165);
    freq.put("\u4f9b", 2204);
    freq.put("\u5e26", 2534);
    freq.put("\u300b\u3001\u300a", 946);
    freq.put("\u7f57\u9a6c", 1148);
    freq.put("\u64ad", 2492);
    freq.put("\u9636", 1080);
    freq.put("\u4e4b\u95f4\u7684", 629);
    freq.put("\u4f55\u7684", 1007);
    freq.put("\u6570\u636e", 868);
    freq.put("\u6740", 947);
    freq.put("\u60c5", 1949);
    freq.put("\u4e2d\u534e\u6c11", 1237);
    freq.put("\u54cd", 1404);
    freq.put("\u4e9a\u3001", 1600);
    freq.put("\u4e9a\u3002", 687);
    freq.put("\u9ed1", 1900);
    freq.put("\u8fdb", 5216);
    freq.put("\u4e2d\u4f7f", 2667);
    freq.put(",\u76ee\u524d", 3438);
    freq.put("\u53e3", 4422);
    freq.put(",\u6545", 644);
    freq.put("\u4e08\u4e8b", 642);
    freq.put(" (", 2857);
    freq.put(" )", 2917);
    freq.put(" ,", 8290);
    freq.put("\u8482", 676);
    freq.put("\u4ed6\u7684", 941);
    freq.put("\u4e86", 8577);
    freq.put("\u540d", 20347);
    freq.put("\u82f1\u4e9a:", 1340);
    freq.put("\u751f,", 616);
    freq.put("\u5730\u4e0d", 1517);
    freq.put("\u7ea6", 5717);
    freq.put("\u3001\u6c5f\u897f", 640);
    freq.put("\u8349\u5730", 757);
    freq.put("\u57f9\u3002", 2913);
    freq.put("\u6587\u5b66", 1074);
    freq.put("\u96b6", 660);
    freq.put("\u4f7f\u7406", 2624);
    freq.put("\u95f4", 8313);
    freq.put("\u4efd\u5e74", 663);
    freq.put("\u56e0\u6b64", 1473);
    freq.put("\u534a\u5c9b", 715);
    freq.put("\u95f4,", 1121);
    freq.put("\u8ba4\u4e3a", 1515);
    freq.put("\u59d4", 2437);
    freq.put("\u7ecf\u6d4e", 1788);
    freq.put(" \u516c\u91cc", 1220);
    freq.put("\u4f11\u4e01", 1348);
    freq.put("\u4e01\u5730", 630);
    freq.put("\u3001\u5c71\u5761", 669);
    freq.put("\u7279", 10095);
    freq.put("\u4f11\u4e08", 1574);
    freq.put("\u8981", 8323);
    freq.put("\u4e3a\u662f", 626);
    freq.put("\u5458,", 1310);
    freq.put(",\u53f0\u6e7e", 584);
    freq.put("\u4e08\u300b", 600);
    freq.put(" \u5e74\u5728", 695);
    freq.put("\u4e08\u3002", 2119);
    freq.put("\u4f1a", 16875);
    freq.put(",\u591a\u751f", 1256);
    freq.put("\u88ab", 7905);
    freq.put("\u8bad", 622);
    freq.put("\u4e00\u822c", 2436);
    freq.put("\u4e08\u4e08\u4e01", 631);
    freq.put("\u90bb", 1194);
    freq.put("\u5f3a", 1613);
    freq.put("\u89c1", 2171);
    freq.put("\u4e00\u6240", 719);
    freq.put("\u4e9a(", 751);
    freq.put("\u3001\u5e7f\u897f", 861);
    freq.put("\u7ecf", 8789);
    freq.put("\u7684\u4e00\u90e8", 774);
    freq.put("\u91d1", 5677);
    freq.put("\u5f0f,", 710);
    freq.put("\u4e9a:", 3961);
    freq.put(" \u3002", 4044);
    freq.put(" \u3001", 2042);
    freq.put(" \u300a", 2860);
    freq.put("\u5468", 2010);
    freq.put("\u8c03", 1492);
    freq.put("\u73ed\u4e01", 801);
    freq.put("\u5728\u53f0", 652);
    freq.put("\u9a8c", 1104);
    freq.put("\u62c9\u4e01", 1110);
    freq.put("\u5dde\u4e8b", 599);
    freq.put("\u661f", 4368);
    freq.put("\u5ba2", 2272);
    freq.put(",\u5357", 723);
    freq.put("\u56fd\u3001", 813);
    freq.put("\u6e2f", 10900);
    freq.put("\u5b9a\u7684", 781);
    freq.put("\u3002\u7531", 929);
    freq.put("\u5cb8", 1431);
    freq.put("\u963f", 4439);
    freq.put("\u573a,", 659);
    freq.put("\u5e74\u5728", 775);
    freq.put("\u662f\u6307", 1893);
    freq.put("\u53c2\u4e0e", 744);
    freq.put("\u540c\u65f6", 1360);
    freq.put("\u534e\u6c11\u56fd", 1215);
    freq.put("\u4e4b\u4e00\u3002", 1753);
    freq.put("\u5b66\u540d:", 3527);
    freq.put(",\u4e00", 2351);
    freq.put("\u5267", 3129);
    freq.put("\u63d0\u4f9b", 1571);
    freq.put(",\u4e01", 4254);
    freq.put("\u83f2", 926);
    freq.put("\u66f4", 2085);
    freq.put("\u7684\u7279", 1539);
    freq.put("\u6210\u7acb", 2637);
    freq.put("\u9001", 619);
    freq.put(",\u56e0\u6b64", 1152);
    freq.put(" \u516c", 1819);
    freq.put("\u539f\u540d", 724);
    freq.put("\u5c5e\u4e8e", 2022);
    freq.put("\u6c99", 2368);
    freq.put("\u4fc4\u7f57", 1205);
    freq.put("\u4e1a", 8072);
    freq.put("\u4e71,", 730);
    freq.put("\u6b27\u6d32", 1589);
    freq.put("\u7528", 13911);
    freq.put("\u7acb\u4e8e", 1279);
    freq.put("\u4f53,", 607);
    freq.put("\u6e90\u4e8e", 655);
    freq.put("\u3002\u6b64", 760);
    freq.put(",\u6b64", 660);
    freq.put("\u4ec5", 1129);
    freq.put("\u5357\u3001", 2847);
    freq.put("\u59cb", 3351);
    freq.put("\u4e08\u514b", 1016);
    freq.put("\u5e74,", 3020);
    freq.put("\u4e58\u6c5f", 1087);
    freq.put("\u8bd7", 967);
    freq.put("\u57fa\u4e01\u6559", 662);
    freq.put("\u5929\u4e3b\u6559", 743);
    freq.put("\u7684\u53d1", 604);
    freq.put("\u8fd9\u4e2a", 1485);
    freq.put("\u53d1\u5c55", 2345);
    freq.put("\u963f\u4e9a", 611);
    freq.put("\u91cc,", 1518);
    freq.put("\u4e08\u5176", 691);
    freq.put("\u5c71\u897f", 700);
    freq.put("\u8272", 3575);
    freq.put("\u9876", 716);
    freq.put("\u5404\u4e9a", 724);
    freq.put("\u51fb", 1569);
    freq.put("\u5c31\u662f", 947);
    freq.put("\u63d0\u4e0d", 749);
    freq.put("\u6e05", 2634);
    freq.put("\u6307", 5889);
    freq.put("\u5f0f", 6888);
    freq.put("\u4eba\u6c11\u5171", 1261);
    freq.put("\u4f5c\u7684", 824);
    freq.put("\u4e9a", 46408);
    freq.put("\u671f", 7068);
    freq.put("\u5bb6\u3001", 1079);
    freq.put("\u5bb6\u3002", 1319);
    freq.put("\u7fa4", 2218);
    freq.put("\u4e8b\u4ea4", 1241);
    freq.put("\u4f2f", 2492);
    freq.put("\u5357\u90e8", 1207);
    freq.put("\u6fb3\u95e8", 921);
    freq.put("\u4efd\u3001", 719);
    freq.put("\u5e38\u751f", 724);
    freq.put("\u94c1\u5bb6", 726);
    freq.put(" \u5e74\u7684", 914);
    freq.put("\u5e7f\u897f", 1228);
    freq.put("\u5728\u4e2d\u56fd", 1180);
    freq.put(",\u8be5", 1018);
    freq.put("\u4e45", 747);
    freq.put("\u4fc4", 2213);
    freq.put("\u4f7f\u7a76", 2862);
    freq.put("\u5bcc", 1265);
    freq.put("\u4f11 ", 1064);
    freq.put("\u8fd9\u4e9b", 921);
    freq.put("\u8fd9\u4e9a", 795);
    freq.put("\u9655", 1187);
    freq.put("\u7f8e\u56fd", 6262);
    freq.put("\u8fd0\u52a8", 2493);
    freq.put("\u884c\u3002", 771);
    freq.put("\u4e01\u5927", 616);
    freq.put("\u95e8", 4685);
    freq.put("(\u82f1", 2411);
    freq.put("\u8f6f", 1659);
    freq.put(",\u4e3a\u4e2d", 658);
    freq.put("\u738b\u671d", 657);
    freq.put("\u517b", 660);
    freq.put("\u5efa", 8867);
    freq.put("\u8a00", 2970);
    freq.put("\u8d85", 1907);
    freq.put("\u4ee5\u53ca\u4e2d", 2006);
    freq.put(",\u4e71", 593);
    freq.put("\u540d\u79f0", 1365);
    freq.put("\u5f80", 1560);
    freq.put("\u5305\u62ec", 3325);
    freq.put("\u56fd\u7684\u7279", 945);
    freq.put("\u683d\u57f9\u3002", 2912);
    freq.put("\u83b1", 1327);
    freq.put("\u8230", 942);
    freq.put("\u5e38", 6171);
    freq.put("\u4f5c\u7528", 691);
    freq.put("\u8bc1", 1510);
    freq.put("\u7acb", 9651);
    freq.put("\u4e2d,\u76ee", 813);
    freq.put("\u53d1", 12789);
    freq.put(",\u7528", 638);
    freq.put("\u8fd9", 6952);
    freq.put("\u4e58", 28571);
    freq.put("\u300b\u3001", 1065);
    freq.put(" \u5206", 744);
    freq.put("\u97e9", 1018);
    freq.put("\u5668", 3296);
    freq.put("\u8f6e", 727);
    freq.put(" \u6708 ", 10460);
    freq.put("\u7528,", 772);
    freq.put("\u6559\u80b2", 1765);
    freq.put("\u4e03", 1693);
    freq.put("\u6982", 864);
    freq.put("\u7684\u300a", 764);
    freq.put("\u6709", 24992);
    freq.put("\u7a0b", 4573);
    freq.put("\u53c8\u8bd1", 658);
    freq.put("\u590d", 1700);
    freq.put(",\u88ab", 862);
    freq.put("\u5c0f", 25275);
    freq.put("\u7f8e", 10457);
    freq.put("\u7c73,", 928);
    freq.put("\u5c0f\u8bf4", 1496);
    freq.put("\u8fdb\u884c", 2271);
    freq.put("\u53a6", 614);
    freq.put("\u3002\u5728", 1915);
    freq.put("\u3001\u5c71", 2033);
    freq.put("\u4e9a\u7684", 1008);
    freq.put("\u6700\u5927\u7684", 950);
    freq.put("\u5bb6", 33525);
    freq.put("\u5f39", 947);
    freq.put("\u4e1a,", 586);
    freq.put("\u82f1\u6587", 2834);
    freq.put("\u89c2", 2303);
    freq.put("\u3001\u4e58\u6c5f", 625);
    freq.put(",\u662f\u4e2d", 1286);
    freq.put("\u8857", 2230);
    freq.put("\u80dc", 1031);
    freq.put("\u7531\u4e8e", 1683);
    freq.put(",\u662f\u4e00", 2180);
    freq.put("\u4e0d,", 1460);
    freq.put("\u4e0d\u5f0f", 1110);
    freq.put("\u7531\u4eba", 3013);
    freq.put("\u4ea4\u3002", 780);
    freq.put("\u5355\u4f4d", 907);
    freq.put("\u4ea4\u901a", 1010);
    freq.put("\u751f\u7269", 1143);
    freq.put("\u5f79", 939);
    freq.put("\u4e58\u4e08", 920);
    freq.put(",\u53f0", 750);
    freq.put("\u6708", 15728);
    freq.put("\u4e58\u4e00", 737);
    freq.put("\u4e58\u4e01", 814);
    freq.put("\u4e58\u4e1b", 864);
    freq.put("\u9700\u8981", 625);
    freq.put("\u4f18", 845);
    freq.put("\u81ea ", 728);
    freq.put("\u4e4b\u4e00", 4710);
    freq.put("\u897f\u4e9a", 1199);
    freq.put("\u56fd\u7684", 3079);
    freq.put("\u5728", 35727);
    freq.put("\u690d\u7269\u3002", 2891);
    freq.put("\u82b1", 3115);
    freq.put("\u6295\u8d44", 588);
    freq.put("\u53bb", 1176);
    freq.put("\u81f3 ", 5691);
    freq.put(",\u751f\u957f", 2942);
    freq.put("\u897f\u4efd", 1008);
    freq.put("\u7684\u91cd", 753);
    freq.put("\u8d44", 4130);
    freq.put(",\u4ee5\u53ca", 1003);
    freq.put("\u5883\u5185", 659);
    freq.put("\u4ed9", 673);
    freq.put(",\u897f", 833);
    freq.put("\u8def", 9754);
    freq.put("\u4e0b,", 946);
    freq.put("\u82f1", 9686);
    freq.put("\u7b80\u79f0", 3399);
    freq.put("\u6574", 1497);
    freq.put("\u7a76", 2923);
    freq.put("\u90fd", 5243);
    freq.put("\u767e", 1846);
    freq.put("\u5740", 719);
    freq.put("\u4e16\u754c", 3851);
    freq.put(" \u53f0", 812);
    freq.put(" \u53f7", 1564);
    freq.put("\u3001\u56db\u5ddd", 1251);
    freq.put("\u7c73\u81f3 ", 2743);
    freq.put("\u73b0\u4ee3", 899);
    freq.put(",\u4eba", 883);
    freq.put("\u3001\u6e56\u5357", 720);
    freq.put("\u4e8e\u9999", 923);
    freq.put("\u897f\u4e0d", 1211);
    freq.put("\u80b2", 2953);
    freq.put("\u901a\u5e38", 1655);
    freq.put("\u533b", 1928);
    freq.put("\u96be", 627);
    freq.put("\u4e2d\u6587", 1113);
    freq.put("\u754c", 6597);
    freq.put("\u91cf", 3834);
    freq.put("\u4f5c\u54c1", 1438);
    freq.put("\u8fd8", 1606);
    freq.put("\u7167", 1002);
    freq.put("\u9669", 710);
    freq.put("\u662f ", 2352);
    freq.put(",\u4e8e", 2786);
    freq.put(") ", 1194);
    freq.put("\u7269\u3002", 3636);
    freq.put("\u957f", 12428);
    freq.put("\u56fe", 2777);
    freq.put("\u1100\u1161", 589);
    freq.put(",\u4e2d", 1697);
    freq.put("\u5e0c", 2317);
    freq.put("\u6708,", 734);
    freq.put("\u4e08\u7403", 620);
    freq.put(",\u4e3a", 3616);
    freq.put(",\u4e3b", 1658);
    freq.put("\u89c6\u53f0", 583);
    freq.put("\u6982\u5ff5", 628);
    freq.put("\u6700\u5927", 1527);
    freq.put("\u5c71\u8c37", 602);
    freq.put("\u9526", 662);
    freq.put(",\u4e0e", 1258);
    freq.put(",\u4e0d", 2776);
    freq.put(",\u4e08", 5138);
    freq.put("\u0430", 705);
    freq.put("\u534f\u4f1a", 1039);
    freq.put("\u5eb7", 1164);
    freq.put(",\u4e1c", 861);
    freq.put("\u52bf", 871);
    freq.put("\u76ee,", 621);
    freq.put("\u65af(", 605);
    freq.put("\u8457\u540d", 1735);
    freq.put("(\u82f1\u4e9a", 1020);
    freq.put("\u7ea6 ", 1747);
    freq.put("\u9752", 2398);
    freq.put("\u79d1\u5b66", 1716);
    freq.put("\u5f62", 4076);
    freq.put("\u4ea4\u7684", 754);
    freq.put(" \u540d", 675);
    freq.put("\u7684\u56fd", 1201);
    freq.put("\u5de5\u4e1a", 864);
    freq.put(",\u4e5f", 3256);
    freq.put("\u76f4\u63a5", 612);
    freq.put("\u5236\u4f5c", 1175);
    freq.put("\u7528\u4e8e", 1226);
    freq.put(",\u4e58", 1464);
    freq.put("(\u82f1\u6587", 1335);
    freq.put(",\u4ea6", 1195);
    freq.put(",\u4ea4", 917);
    freq.put("\u671f\u95f4", 1013);
    freq.put("\u8109", 651);
    freq.put("\u65f6,", 1279);
    freq.put("\u9ad8\u4e01", 607);
    freq.put("-", 1381);
    freq.put("\u4e08\u548c", 636);
    freq.put("\u671d", 3840);
    freq.put("\u4e01\u5c5e", 1251);
    freq.put("\u9664\u4e86", 587);
    freq.put("\u4eac", 3333);
    freq.put("\u4f7f,", 2980);
    freq.put("\u4f7f(", 777);
    freq.put("\u5206\u522b", 959);
    freq.put(",\u6240\u4ee5", 699);
    freq.put("\u5927\u4e08", 869);
    freq.put("\u6d41", 4509);
    freq.put(",\u4ee5", 3498);
    freq.put("\u8981\u7684", 1104);
    freq.put("\u9879\u76ee", 737);
    freq.put("\u5c4b", 1097);
    freq.put("\u6c5f\u897f\u3001", 618);
    freq.put("\u534e\u4eba", 1471);
    freq.put("\u5355", 3024);
    freq.put(",\u4efd", 844);
    freq.put("\u5c1a\u672a", 2839);
    freq.put("\u4e08\u4e9a", 1470);
    freq.put("\u90e8", 14531);
    freq.put("\u53ea", 2126);
    freq.put("\u4eec", 2426);
    freq.put(" \u548c", 850);
    freq.put(",\u4ed6", 1341);
    freq.put("\u3002\u5176", 1173);
    freq.put("\u540d:", 4034);
    freq.put("\u6545\u4e8b", 840);
    freq.put("\u6797\u4e0b", 866);
    freq.put(",", 211761);
    freq.put("\u6797\u4e08", 747);
    freq.put("\u8005", 7418);
    freq.put("\u7d20", 1524);
    freq.put("\u7684\u4efd", 596);
    freq.put("\u5b83\u4eec", 581);
    freq.put("\u6797\u4e2d", 937);
    freq.put("\u4f4d\u4e8e", 6910);
    freq.put("\u57fa\u7840", 690);
    freq.put("\u8baf", 1488);
    freq.put("\u5de5\u4f5c", 1348);
    freq.put("\u5fb7", 8327);
    freq.put(",\u4f11", 1379);
    freq.put("\u53bf", 5347);
    freq.put("\u65e5\u5728", 675);
    freq.put("\u3001\u5b89", 622);
    freq.put("\u8d8a\u5357", 953);
    freq.put("\u7cfb\u4f7f", 1617);
    freq.put(",\u4f7f", 1942);
    freq.put(",\u4f46", 3353);
    freq.put("\u4e00\u6761", 1013);
    freq.put("\u7ae5", 907);
    freq.put("\u53ca\u4e2d\u56fd", 2044);
    freq.put("\u5168", 7377);
    freq.put(",\u4f4d", 2756);
    freq.put("\u8f6c", 1925);
    freq.put("\u6570", 7124);
    freq.put("\u81f3", 9855);
    freq.put("\u4e3e\u884c", 1293);
    freq.put("\u540d,", 804);
    freq.put("\u95fb", 1352);
    freq.put("\u7a7a", 3846);
    freq.put("\u56fd", 50445);
    freq.put("\u7b49,", 840);
    freq.put("\u6cfd", 750);
    freq.put("\u5411", 3047);
    freq.put("\u4f17", 1421);
    freq.put("\u4e8e\u9999\u6e2f", 916);
    freq.put("\u679c", 2196);
    freq.put("\u7ea2", 1720);
    freq.put("\u56fd\u6c11", 1000);
    freq.put("\u4e8e\u7f8e", 614);
    freq.put("\u53ca\u5176", 661);
    freq.put("\u4e2d", 47239);
    freq.put("\u753b", 2451);
    freq.put("\u7684\u5730", 4246);
    freq.put("\u4f1a,", 853);
    freq.put("\u4f1a(", 981);
    freq.put("\u8bc4", 1093);
    freq.put("\u5927\u4f7f", 1012);
    freq.put("\u98ce", 2500);
    freq.put(",\u4e2d\u56fd", 911);
    freq.put("\u9646\u7684", 3096);
    freq.put("\u751f\u957f", 4500);
    freq.put("\u8d27", 901);
    freq.put("\u4e13\u8f91", 636);
    freq.put("\u5ea6", 6769);
    freq.put("\u4e8b,", 1473);
    freq.put("\u66f2", 2749);
    freq.put("\u4e15\u4e08", 949);
    freq.put(")\u662f", 10848);
    freq.put("\u9879", 2377);
    freq.put("\u767d", 2529);
    freq.put("\u5fb7\u4e9a", 680);
    freq.put(",\u8fd9", 1581);
    freq.put("\u5c81", 688);
    freq.put("\u82f1\u4e9a", 2018);
    freq.put("\u4e3a ", 5249);
    freq.put("\u5c71\u4e1c", 748);
    freq.put("\u81ea\u6cbb", 726);
    freq.put("\u5171\u6709", 696);
    freq.put("\u751f\u7684", 842);
    freq.put("\u79f0\u4e3a ", 1204);
    freq.put("\u7d22", 1233);
    freq.put("\u8eab", 2869);
    freq.put("\u3002\u73b0", 602);
    freq.put("\u793a", 1536);
    freq.put("\u814a", 1076);
    freq.put("\u54c1,", 659);
    freq.put("\u9650", 2379);
    freq.put("\u4e0d\u5bb6", 1629);
    freq.put("\u7403\u961f", 888);
    freq.put("\u4e01\u5e97", 632);
    freq.put("\u957f\u4e8e\u4e0d", 2913);
    freq.put("\u4e8e\u5c71", 605);
    freq.put("\u95f4\u7684", 1117);
    freq.put(" \u963f", 664);
    freq.put("\u6c5f\u3001", 1010);
    freq.put("\u5766", 1302);
    freq.put("\u6b66", 2208);
    freq.put("\u5bf9", 7380);
    freq.put("\u534e\u6c11", 1238);
    freq.put("\u547c", 663);
    freq.put("\u4f01", 1149);
    freq.put("\u7684\u540d", 795);
    freq.put("\u548c ", 1051);
    freq.put("\u7ecf\u8425", 801);
    freq.put("\u592a\u5e73", 714);
    freq.put("\u8f96", 1462);
    freq.put("\u4e00\u822c\u751f", 684);
    freq.put("\u7535\u89c6", 2674);
    freq.put("\u4e08\u7684", 3617);
    freq.put(" \u56fd", 713);
    freq.put("\u5e7f\u4e1c", 1877);
    freq.put("\u30a2\u30a2", 1643);
    freq.put("\u7b2c ", 1806);
    freq.put("\u52a8", 10155);
    freq.put("\u8d2d", 664);
    freq.put("\u8bae", 3045);
    freq.put("\u4f55,", 1182);
    freq.put("\u524d\u5c1a", 2725);
    freq.put("\u8349", 3994);
    freq.put("\u76ee\u524d\u5c1a", 2723);
    freq.put("\u591a\u751f\u957f", 627);
    freq.put("\u7ea6\u4e08", 612);
    freq.put("\u5f00\u53d1", 1428);
    freq.put("\u79f0,", 606);
    freq.put("\u4e8e\u4e0d\u62d4", 2931);
    freq.put("\u5965", 3388);
    freq.put(" \u7684", 2781);
    freq.put("\u5e7f\u4e58", 652);
    freq.put("\u767b", 1073);
    freq.put("\u82cf\u8054", 584);
    freq.put("\u6587", 14966);
    freq.put("\u5f8b", 1732);
    freq.put("\u798f", 3324);
    freq.put("\u56fd\u4eba", 990);
    freq.put("\u4e16", 9256);
    freq.put("\u4e0a\u7684", 1685);
    freq.put("\u7279\u6709", 1087);
    freq.put("\u5f20", 2153);
    freq.put("\u5ba3", 1095);
    freq.put("\u5bb6\u7684", 1013);
    freq.put("\u52a9", 1407);
    freq.put("\u884c\u4e3a", 642);
    freq.put("\u4e08\u5730", 713);
    freq.put("\u53f7,", 798);
    freq.put("\u957f\u4e8e", 3283);
    freq.put("\u4efd\u56f4", 818);
    freq.put("\u6c42", 1033);
    freq.put("\u62c9", 7109);
    freq.put(" \u5728", 1140);
    freq.put("\u4ee5 ", 631);
    freq.put("\u3001\u798f", 680);
    freq.put("\u76d1", 811);
    freq.put("\u6e56", 3858);
    freq.put("\u84dd", 701);
    freq.put("\u5bb6\u56fd", 1673);
    freq.put("\u884c\u7684", 1255);
    freq.put("\u5c0f\u4e08", 990);
    freq.put(" ,\u662f", 1072);
    freq.put("\u6770", 812);
    freq.put("\u6210,", 1007);
    freq.put("\u5e76", 7400);
    freq.put("\u987a", 631);
    freq.put("\u65f6\u671f", 1763);
    freq.put("\u4e01", 117148);
    freq.put("\u3002\u5206", 2961);
    freq.put("\u884c\u4e0d", 2204);
    freq.put("\u822a\u7a7a", 1141);
    freq.put("\u4eba ", 623);
    freq.put(",\u53c8\u540d", 585);
    freq.put("\u671b", 1007);
    freq.put("\u611f", 998);
    freq.put("\u4e71", 17692);
    freq.put("\u5229", 8681);
    freq.put("\u975e\u6d32", 689);
    freq.put("\u4e2d\u534e\u4eba", 1156);
    freq.put("\u56fd\u4e01", 732);
    freq.put("\u90e8,", 1121);
    freq.put("\u751f\u5728", 746);
    freq.put("\u56fd\u4e0d", 1345);
    freq.put("\u7ed3\u4e01", 584);
    freq.put("\u7684\u7535", 996);
    freq.put("\u56fd\u4e08", 695);
    freq.put("\u6587\u5316", 2111);
    freq.put("\u89c4", 2234);
    freq.put("\u4e58\u6c5f\u3001", 593);
    freq.put("\u4e01)", 1039);
    freq.put("\u4e9a\u8a00", 1720);
    freq.put("\u4e01,", 4237);
    freq.put("\u4ed6", 7464);
    freq.put("\u6700\u9ad8", 965);
    freq.put("\u7269", 13958);
    freq.put("\u81f4", 1313);
    freq.put("\u5ef6", 769);
    freq.put("\u547d", 2331);
    freq.put("\u7269\u7406", 701);
    freq.put("\u901a\u8fc7", 1270);
    freq.put("\u6c11\u56fd", 1569);
    freq.put("\u798f\u5efa", 1133);
    freq.put("\u5b9d", 999);
    freq.put("\u533a,", 4940);
    freq.put("\u603b\u7edf", 750);
    freq.put("\u79f0\u4e3a", 4237);
    freq.put("\u4e3a\u4e2d\u56fd", 948);
    freq.put("\u0438", 659);
    freq.put("\u673a", 7949);
    freq.put("\u662f\u4e00\u4e9a", 2252);
    freq.put("\u6d3e", 1913);
    freq.put("\u9762\u79ef", 1528);
    freq.put("\u5458", 7153);
    freq.put("\u7edf\u7684", 590);
    freq.put("\u7edf", 6645);
    freq.put("\u8457\u540d\u7684", 779);
    freq.put("\u6362", 868);
    freq.put("\u67e5", 1580);
    freq.put("\u7684\u4e3b\u8981", 669);
    freq.put(",\u524d", 662);
    freq.put("\u73ed", 1750);
    freq.put("\u4f11\u5982", 834);
    freq.put("\u5ff5", 1709);
    freq.put("\u5e74", 47488);
    freq.put("\u4e01·", 957);
    freq.put("(\u5b66", 3658);
    freq.put("\u3002\u5206\u5e03", 2922);
    freq.put("\u7403", 6996);
    freq.put("\u5382", 831);
    freq.put("\u7684", 145656);
    freq.put("\u9986", 2371);
    freq.put("\u662f\u4e00\u4e2a", 2236);
    freq.put("\u5206\u4e01", 674);
    freq.put("\u961f,", 590);
    freq.put("\u4e94", 3431);
    freq.put("\u5927\u5229", 1318);
    freq.put("\u4eba,", 2362);
    freq.put("\u4e08\u3001", 2959);
    freq.put("\u5206\u4e3a", 837);
    freq.put("\u5177\u6709", 1055);
    freq.put("\u5931", 939);
    freq.put("\u53cd\u5e94", 687);
    freq.put("\u6237", 1297);
    freq.put("\u6539", 3194);
    freq.put("\u7684\u57fa", 581);
    freq.put("\u52a8\u753b", 653);
    freq.put("\u53c2", 2872);
    freq.put("\u514d", 623);
    freq.put("\u6d41\u884c", 630);
    freq.put("\u6bd2", 762);
    freq.put("\u4f55", 21331);
    freq.put("\u4e4b\u95f4", 1601);
    freq.put("\u7559", 781);
    freq.put("\u57ce", 5315);
    freq.put("\u5dde", 7529);
    freq.put("\u4e01 ", 1901);
    freq.put("\u6765", 9550);
    freq.put("\u7279\u6709\u690d", 935);
    freq.put("\u3001\u5370\u5ea6", 793);
    freq.put("\u706b", 1816);
    freq.put("\u6700\u65e9", 864);
    freq.put("\u72ec", 1820);
    freq.put("\u5e74\u81f3 ", 713);
    freq.put("\u95ee", 1446);
    freq.put("\u83b7\u5f97", 1131);
    freq.put("\u58f0", 4998);
    freq.put("\u7c73", 9738);
    freq.put("\u5370\u5ea6", 2180);
    freq.put("\u7ef4", 3625);
    freq.put("\u63a7\u5236", 687);
    freq.put("\u5143 ", 583);
    freq.put("\u751f\u957f\u5728", 1097);
    freq.put("\u6f14", 3628);
    freq.put("\u7518", 1358);
    freq.put("\u5c5e\u7684", 3366);
    freq.put("\u5b9e\u9645", 605);
    freq.put("\u80a1", 1262);
    freq.put(",\u53ef", 1101);
    freq.put(",\u5305", 1287);
    freq.put("\u7acb\u7684", 1250);
    freq.put("\u8d28", 2689);
    freq.put("\u4e2a", 19411);
    freq.put("\u4f5c\u4e3a", 1517);
    freq.put("\u4e4b\u540e", 1285);
    freq.put("\u83b7", 2004);
    freq.put(",\u53c8\u79f0", 1386);
    freq.put("\u4f55\u80fd", 734);
    freq.put("\u5316\u7684", 604);
    freq.put("\u7bc7", 721);
    freq.put("\u4e2d,", 3371);
    freq.put("\u4e3a\u4e01", 953);
    freq.put(",\u5373", 1029);
    freq.put("\u53d7", 2511);
    freq.put("\u73b0\u5728", 1080);
    freq.put("\u5c5e", 10137);
    freq.put("\u8d44\u8baf", 628);
    freq.put("\u9009\u4e3e", 733);
    freq.put("\u5730\u533a,", 3536);
    freq.put("\u7ebf,", 677);
    freq.put("\u7fa4\u5c9b", 661);
    freq.put("\u65f6\u95f4", 1469);
    freq.put("\u667a", 818);
    freq.put("\u5761", 2693);
    freq.put("\u3001", 80590);
    freq.put("\u4e9a,", 1453);
    freq.put("\u9886", 2926);
    freq.put("\u4f1a ", 652);
    freq.put("),\u53c8", 980);
    freq.put("\u6811", 1023);
    freq.put("\u5c0f\u90fd", 652);
    freq.put("\u4e15", 15196);
    freq.put(",\u73b0", 1341);
    freq.put("\u670d\u52a1", 2010);
    freq.put("\u6625", 892);
    freq.put("\u6b27", 2758);
    freq.put("\u4e00\u5bb6", 830);
    freq.put("\u66fe\u7ecf", 583);
    freq.put(",\u539f", 1270);
    freq.put("\u9645", 4272);
    freq.put("\u8bcd", 2012);
    freq.put("\u6240\u6709", 1061);
    freq.put("\u73af\u5883", 892);
    freq.put("\u5357", 15302);
    freq.put("\u540e,", 2099);
    freq.put(" \u5e74\u4ee3", 1447);
    freq.put("\u516b", 1932);
    freq.put("\u8bbe\u7acb", 673);
    freq.put(",\u53c8", 2947);
    freq.put("\u79f0", 17001);
    freq.put("\u79f0 ", 1447);
    freq.put("\u65e5\u81f3 ", 606);
    freq.put("\u4e3b\u6559", 1120);
    freq.put("\u4f7f", 59599);
    freq.put("\u5404", 3613);
    freq.put("\u9650\u516c", 1343);
    freq.put("\u4e8e ", 10544);
    freq.put("\u5e08", 2671);
    freq.put("\u800c", 9496);
    freq.put("\u3002", 93258);
    freq.put("\u6c14", 1964);
    freq.put("\u5316", 7453);
    freq.put("\u7f8e\u6d32", 847);
    freq.put("\u7528\u6765", 773);
    freq.put("\u3001\u4e91\u5357", 1182);
    freq.put("\u6bd5\u4e1a", 667);
    freq.put(",\u300a", 690);
    freq.put("\u7eb3", 2534);
    freq.put("\u53ea\u6709", 591);
    freq.put("·", 11798);
    freq.put(",\u901a", 884);
    freq.put("\u538b", 796);
    freq.put("\u56fd\u738b", 741);
    freq.put("\u57fa\u672c", 664);
    freq.put("\u5185,", 588);
    freq.put("\u75c5", 1344);
    freq.put("\u4eba\u5de5", 3099);
    freq.put(" \u4e16\u7eaa", 1447);
    freq.put("\u804c", 2157);
    freq.put("\u674e", 1577);
    freq.put("\u8bd1", 3205);
    freq.put("\u5171\u548c\u56fd", 1949);
    freq.put("\u662f\u9999", 1732);
    freq.put(",\u9999\u6e2f", 708);
    freq.put("\u3002\u8fd9", 1769);
    freq.put("\u524d\u5c1a\u672a", 2719);
    freq.put("\u5927\u90e8", 622);
    freq.put("\u65e5", 21151);
    freq.put("\u65e9\u671f", 592);
    freq.put("\u8b66", 737);
    freq.put("\u8f66\u7ad9", 2410);
    freq.put("\u5386\u4f7f", 2363);
    freq.put("\u524d ", 886);
    freq.put("\u89d2\u8272", 608);
    freq.put(")", 53342);
    freq.put("\u4e13", 3303);
    freq.put("\u9ad8\u901f", 865);
    freq.put("\u5c1a\u672a\u7531", 2713);
    freq.put(":)", 4083);
    freq.put(",\u5728 ", 658);
    freq.put("\u522b", 3560);
    freq.put("\u542f", 817);
    freq.put("\u9633", 2041);
    freq.put("\u7c73\u7684", 3087);
    freq.put("\u8fbe", 4214);
    freq.put("\u5341", 5342);
    freq.put("\u5bc6", 1755);
    freq.put("\u7ec8", 1135);
    freq.put("\u624b", 3277);
    freq.put("\u95ee\u9898", 913);
    freq.put("\u89d2", 3015);
    freq.put("\u53ca\u4e08", 729);
    freq.put("\u9057", 895);
    freq.put("\u53d6", 2479);
    freq.put("\u76d8", 598);
    freq.put("\u533a,\u4e00", 689);
    freq.put("\u516d", 2119);
    freq.put("\u53ca\u4e2d", 2186);
    freq.put("\u5e73", 5989);
    freq.put(" \u5e73\u4e0d", 1027);
    freq.put("\u5236\u9020", 737);
    freq.put("\u9002", 644);
    freq.put("(", 53630);
    freq.put("\u8f93", 1210);
    freq.put("\u5b58\u5728", 833);
    freq.put("\u3001\u65e5", 634);
    freq.put("\u6bd4\u8d5b", 1111);
    freq.put("\u94f6\u884c", 879);
    freq.put("\u800c\u6210", 666);
    freq.put("\u6708 ", 10522);
    freq.put("\u4e3e", 3076);
    freq.put(" \u3001 ", 1160);
    freq.put("\u3042", 2229);
    freq.put("\u5c4a", 1515);
    freq.put("\u3042\u3042\u3042", 1321);
    freq.put("\u65cf", 3701);
    freq.put(",\u5176", 3552);
    freq.put("\u3002\u4ed6", 1369);
    freq.put(",\u5171", 756);
    freq.put("\u62d4 ", 3155);
    freq.put("\u5c5e(", 1286);
    freq.put("\u8f68", 655);
    freq.put("\u70ed", 1483);
    freq.put("\u516c", 17034);
    freq.put("\u8bfb", 946);
    freq.put("\u697c", 1695);
    freq.put("\u6e7e", 8336);
    freq.put("\u7684\u690d", 2910);
    freq.put("\u3002\u4e01", 940);
    freq.put("\u5907", 1259);
    freq.put("\u516c\u91cc,", 1108);
    freq.put("\u3002\u4e08", 1034);
    freq.put("\u4e58\u7684", 934);
    freq.put("\u4f7f ", 1090);
    freq.put("\u8425", 2531);
    freq.put("\u6e29", 1133);
    freq.put("\u4f55\u6210", 650);
    freq.put("\u5b66(", 696);
    freq.put("\u683d", 2997);
    freq.put("\u4e08\u5b50", 859);
    freq.put("\u672a\u7531", 2714);
    freq.put("\u4f53", 8040);
    freq.put(",\u5168", 1258);
    freq.put("\u4eba\u7c7b", 940);
    freq.put("\u3002\u4e58", 742);
    freq.put("\u536b", 1639);
    freq.put("\u76ee", 9318);
    freq.put("\u7684\u897f", 629);
    freq.put("\u5df4", 5253);
    freq.put("\u65af·", 1031);
    freq.put("\u6709 ", 2350);
    freq.put("\u6b7b", 6678);
    freq.put("\u751f\u957f\u4e8e", 3254);
    freq.put("\u5385", 672);
    freq.put("\u4e00", 51232);
    freq.put("()", 3758);
    freq.put("\u7684\u4e9a", 598);
    freq.put("(,", 1176);
    freq.put("\u5199", 2568);
    freq.put("\u5c9b", 4996);
    freq.put("\u671f\u7684", 814);
    freq.put("\u63a5", 3776);
    freq.put("\u4ea7", 5405);
    freq.put("\u7684\u4ea4", 1075);
    freq.put("\u540e\u7684", 584);
    freq.put("\u5927\u7684", 1819);
    freq.put("\u7684\u4eba", 1919);
    freq.put("\u6536", 1975);
    freq.put("\u6cbb", 5001);
    freq.put("\u8fbd", 711);
    freq.put("\u4e3c", 1241);
    freq.put("\u662f\u7f8e", 1276);
    freq.put("\u7ec7", 2183);
    freq.put("\u300b\u4e2d", 595);
    freq.put("\u81ea\u7531", 876);
    freq.put("\u8d39", 1407);
    freq.put("\u8bd5", 1000);
    freq.put("\u535a", 1783);
    freq.put("\u795e", 3463);
    freq.put("\u53c2\u52a0", 688);
    freq.put("\u7c73\u81f3", 2745);
    freq.put("\u8868", 5479);
    freq.put("\u7f51\u7edc", 1319);
    freq.put("\u5b66\u540d", 3799);
    freq.put("\u7f72", 901);
    freq.put("\u3001\u5e7f", 1717);
    freq.put("\u6765\u7684", 817);
    freq.put("\u7684\u4e0d", 2462);
    freq.put("\u5305", 4823);
    freq.put("\u7684\u4e08", 5079);
    freq.put("\u670d", 2639);
    freq.put("\u620f", 2673);
    freq.put("\u7684\u4e01", 3401);
    freq.put("\u4f7f\u672c", 654);
    freq.put("\u9ec4", 2293);
    freq.put("\u7684\u4e2d", 1197);
    freq.put("\u62a4", 1665);
    freq.put("\u673a\u6784", 1217);
    freq.put("\u542b", 1431);
    freq.put("\u4e4b\u4e00,", 2267);
    freq.put("\u7684\u4e3b", 1363);
    freq.put("\u6c11\u4e3b", 899);
    freq.put(",\u56e0", 2416);
    freq.put(",\u76ee", 3648);
    freq.put("),", 14139);
    freq.put("\u7684\u4e58", 866);
    freq.put("\u7edc", 1469);
    freq.put("\u4ea4\u4e0d", 722);
    freq.put(" \u65e5\u5728", 655);
    freq.put("\u5e1d\u56fd", 1098);
    freq.put("\u53ef\u4ee5", 2687);
    freq.put("\u526f", 860);
    freq.put("\u5927\u9646", 4400);
    freq.put("\u65f6", 14785);
    freq.put("\u8f7d", 1404);
    freq.put("\u662f\u65e5", 749);
    freq.put("\u7684\u4e71", 628);
    freq.put("\u9500", 827);
    freq.put("\u5c06", 4225);
    freq.put("\u4e00,", 2377);
    freq.put("\u4e2d\u5b66", 1267);
    freq.put("\u62a5", 2620);
    freq.put("\u4fa7", 721);
    freq.put("\u5bf9\u4e8e", 704);
    freq.put("\u6a2a", 631);
    freq.put("\u73af", 2438);
    freq.put("\u9762\u79ef ", 773);
    freq.put("\u94c1", 4586);
    freq.put("\u5408\u4f5c", 595);
    freq.put("\u683d\u57f9", 2968);
    freq.put("\u5b83\u7684", 633);
    freq.put("\u5728\u4e2d", 1500);
    freq.put("\u7edd", 650);
    freq.put("\u5bdf", 855);
    freq.put("\u62e5", 1168);
    freq.put("\u56ed", 2775);
    freq.put("\u4e01\u65af", 907);
    freq.put("\u5728\u4e08", 1143);
    freq.put("\u5e72", 1556);
    freq.put("\u5728\u4e0d", 766);
    freq.put(",\u5728", 4524);
    freq.put("\u827a", 2269);
    freq.put("\u4efd", 14596);
    freq.put("\u4e2d\u56fd\u5927", 3854);
    freq.put("\u6c11", 10950);
    freq.put("\u5e73\u4e0d", 1296);
    freq.put("\u4e01\u6559", 806);
    freq.put("\u5fb7\u56fd", 1532);
    freq.put("\u5e1d", 2672);
    freq.put("\u589e", 971);
    freq.put("\u7f29\u5199", 612);
    freq.put("\u751f\u6d3b", 843);
    freq.put("\u5c31", 2894);
    freq.put("\u79d1\u6280", 622);
    freq.put("\u6d3b", 2831);
    freq.put("\u4e3d", 1041);
    freq.put("\u897f\u3001", 2735);
    freq.put("\u76f4", 3003);
    freq.put("\u5143", 4144);
    freq.put("\u827a\u672f", 1217);
    freq.put("\u9886\u57df", 706);
    freq.put("\u7684\u4f5c", 618);
    freq.put("\u6bd4", 4805);
    freq.put("\u7684\u4f55", 678);
    freq.put("\u98de", 1436);
    freq.put("\u65e0", 3416);
    freq.put("\u5c71", 12651);
    freq.put("\u6587\u4f7f", 804);
    freq.put("\u5973", 3642);
    freq.put("\u4ea4\u4f11", 767);
    freq.put("\u4e08\u4e1e", 767);
    freq.put("\u5b89", 5174);
    freq.put("\u4e08\u4e15", 925);
    freq.put("\u8f91", 1374);
    freq.put("\u751f\u4e8e", 2477);
    freq.put("\u4e08\u4e08", 10643);
    freq.put(" \u4e71", 770);
    freq.put("\u5185\u4e01\u4f7f", 615);
    freq.put("\u4e08\u4e0d", 1018);
    freq.put("\u5218", 669);
    freq.put("\u4e08\u4e00", 1128);
    freq.put("\u4e08\u4e01", 6021);
    freq.put("\u4e08\u4e3a", 629);
    freq.put("\u6620", 608);
    freq.put("\u7518\u8083\u3001", 797);
    freq.put("\u4f26", 1894);
    freq.put("\u8ba9", 773);
    freq.put(" \u4e4b", 647);
    freq.put(",\u540c", 895);
    freq.put("\u6709\u65f6", 593);
    freq.put("\u7834", 649);
    freq.put("\u4e01\u4f7f\u3001", 641);
    freq.put("\u4e08\u4e2d", 605);
    freq.put("\u751f\u4ea7", 971);
    freq.put(" \u4e58", 758);
    freq.put("\u7684\u4e00\u4e9a", 1477);
    freq.put("\u6b3e", 923);
    freq.put("\u4e08\u4e58", 1009);
    freq.put(" \u4e2a", 2399);
    freq.put("\u7ad9\u3002", 627);
    freq.put(" \u4e2d", 1862);
    freq.put("\u8fd1", 3105);
    freq.put("\u4e08\u4e4b", 694);
    freq.put("\u897f\u73ed", 773);
    freq.put("\u521b\u7acb", 811);
    freq.put("\u515a", 2412);
    freq.put("\u5ddd", 3028);
    freq.put("\u98df", 1377);
    freq.put("\u3002\u8be5", 1506);
    freq.put(" \u4e00", 646);
    freq.put(" \u4e01", 3946);
    freq.put(" \u4e07", 1431);
    freq.put("\u8f66", 6585);
    freq.put("\u5b66,", 1273);
    freq.put(" \u4e08", 5741);
    freq.put("\u4e08\u4e71", 1342);
    freq.put("\u82f1\u56fd", 2374);
    freq.put("\u5c9b\u3001", 590);
    freq.put("\u4eba\u6c11", 2356);
    freq.put("\u7ea7", 4065);
    freq.put(" \u4e16", 1671);
    freq.put(" \u4e15", 929);
    freq.put("\u4efb", 5559);
    freq.put("\u5e74 ", 13993);
    freq.put("\u4f46\u662f", 741);
    freq.put("\u7701", 5247);
    freq.put("\u7b97", 1987);
    freq.put("\u4f53\u80b2", 809);
    freq.put("\u7684\u4e00\u4e2a", 3092);
    freq.put("\u4f11", 48239);
    freq.put("\u6e90", 3031);
    freq.put("\u957f\u5728", 1116);
    freq.put("\u822c\u751f", 684);
    freq.put("\u9c9c", 1464);
    freq.put("\u5730,", 4149);
    freq.put("\u5b9e", 4032);
    freq.put("\u59d4\u5458\u4f1a", 1211);
    freq.put(",),", 1007);
    freq.put("\u67b6", 926);
    freq.put("\u4e3b", 15497);
    freq.put("\u6e56\u4e0d\u3001", 763);
    freq.put("\u4e08\u4ea4", 632);
    freq.put("\u8bbe", 6237);
    freq.put("\u7b49", 12322);
    freq.put("\u5f53\u65f6", 1404);
    freq.put(" \u4eba", 2100);
    freq.put("\u5b66\u4f7f", 616);
    freq.put("\u4e3b\u5e2d", 689);
    freq.put("\u6761", 3385);
    freq.put("\u3001 ", 2429);
    freq.put("\u53c8\u540d", 874);
    freq.put("\u4e9a\u683d\u57f9", 2910);
    freq.put("\u56db\u5ddd\u3001", 1228);
    freq.put("\u897f\u5357", 748);
    freq.put("\u4e01\u662f", 769);
    freq.put("\u5f71", 4410);
    freq.put("\u3001\u6e56\u4e0d", 767);
    freq.put("\u5df2", 3013);
    freq.put("\u63a8\u4e0d", 777);
    freq.put(" \u4e9a", 733);
    freq.put("\u4f11(", 899);
    freq.put("\u4f11,", 2609);
    freq.put("\u9700", 1195);
    freq.put("\u5b66\u5bb6", 1872);
    freq.put(" \u7c73\u81f3", 2742);
    freq.put("\u4e08\u4f11", 1776);
    freq.put("\u8f66\u7ad9,", 720);
    freq.put("\u4e91", 2725);
    freq.put(",\u7531", 3911);
    freq.put("\u901a", 7604);
    freq.put(" \u4f7f", 1450);
    freq.put("\u5927\u9646\u7684", 3080);
    freq.put("\u6c5f\u897f", 972);
    freq.put("\u793e\u4f1a", 2250);
    freq.put("\u5df4\u4e58", 819);
    freq.put("\u5c3c\u4e9a", 1342);
    freq.put(" \u4f4d", 590);
    freq.put("\u4e0d\u62d4", 3372);
    freq.put("\u5934", 2350);
    freq.put("\u4e50", 5294);
    freq.put(" \u4f55", 732);
    freq.put(",\u751f", 3542);
    freq.put("\u5bb6\u4e9a", 645);
    freq.put("\u7740", 1639);
    freq.put(",\u4e00\u822c", 1217);
    freq.put("\u4e24\u4e2a", 961);
    freq.put("\u56fd\u56fd", 1280);
    freq.put("\u5357\u4e0d", 934);
    freq.put("\u6d3b\u52a8", 1238);
    freq.put("\u4e08\u4f7f", 1087);
    freq.put("\u4efb\u4f55", 656);
    freq.put("\u4e66", 4419);
    freq.put("\u4e2d\u592e", 1281);
    freq.put("\u4e9a ", 1478);
    freq.put("\u5c71\u5761", 1678);
    freq.put(" \u4f11", 920);
    freq.put("\u4e08\u4e08,", 642);
    freq.put("\u4e08\u8f66", 720);
    freq.put("\u6c11\u5171", 1266);
    freq.put("\u5e7f\u573a", 674);
    freq.put("\u5e86", 953);
    freq.put("\u4e0a\u4e0d", 1488);
    freq.put("\u52a8\u7269", 1359);
    freq.put("\u53ef", 7699);
    freq.put("\u5219", 3203);
    freq.put(";", 5849);
    freq.put("\u5bb6\u4e01", 849);
    freq.put("\u4e3e\u529e", 651);
    freq.put("\u4ea6", 2742);
    freq.put("\u5bb6\u4e08", 713);
    freq.put("\u5e74\u81f3", 809);
    freq.put("\u4e0d\u516c\u91cc", 767);
    freq.put("\u5343", 1226);
    freq.put("\u8054\u5408", 1420);
    freq.put("\u7ec6", 1259);
    freq.put("\u5730,\u751f", 2896);
    freq.put("\u4e8e\u65e5", 763);
    freq.put("\u4e9a\u4e01", 910);
    freq.put("\u8fd0", 6417);
    freq.put("\u76d6", 717);
    freq.put("\u53d8", 2770);
    freq.put("\u5f71\u54cd", 1080);
    freq.put("\u7ade", 659);
    freq.put("\u8363", 690);
    freq.put("\u5c0f\u7684", 1375);
    freq.put("\u56fd\u9645", 3114);
    freq.put("\u9875", 780);
    freq.put("\u7684\u690d\u7269", 2905);
    freq.put("\u6279", 885);
    freq.put("\u8f7b", 756);
    freq.put("\u4e9a·", 946);
    freq.put("\u897f", 17559);
    freq.put("\u4e1c\u5357", 852);
    freq.put("\u6807\u4f55", 1254);
    freq.put("\u5e74(", 1135);
    freq.put(" \u9999\u6e2f", 632);
    freq.put("\u5408", 7745);
    freq.put("\u5e74)", 2514);
    freq.put("\u5929\u4e3b", 779);
    freq.put("\u6709\u9650\u516c", 1342);
    freq.put("\u5458\u4f1a", 1240);
    freq.put("\u5916", 5857);
    freq.put("\u4e71\u4e08", 1142);
    freq.put(":", 15751);
    freq.put("\u4e01\u5c5e(", 793);
    freq.put("\u4e24", 4794);
    freq.put("\u4e91\u5357", 1737);
    freq.put("\u6240\u4ee5", 844);
    freq.put("\u8428", 1866);
    freq.put("\u672a", 4221);
    freq.put("\u7535\u5f71", 2044);
    freq.put("\u79ef ", 789);
    freq.put("\u4e9a\u4f7f", 601);
    freq.put("\u9634", 725);
    freq.put("\u4e08 ", 2639);
    freq.put("\u7b97\u673a", 592);
    freq.put("\u653e", 2159);
    freq.put("\u79c1", 738);
    freq.put("\u7840", 692);
    freq.put("\u6bcd", 1743);
    freq.put("\u6d4e", 2241);
    freq.put("\u3001\u4e91", 1236);
    freq.put("\u5956", 2274);
    freq.put("\u5b89\u4e01", 901);
    freq.put("\u548c\u56fd", 2085);
    freq.put("\u6b62", 1051);
    freq.put("\u5de5\u7a0b", 1106);
    freq.put("\u65e9", 2138);
    freq.put("\u9a6c", 7083);
    freq.put("\u4e1b\u4e2d", 711);
    freq.put("\u4e0d\u62d4 ", 3152);
    freq.put("\u3001\u4eba", 909);
    freq.put("\u7f05", 631);
    freq.put("\u9488", 594);
    freq.put("\u8111", 1283);
    freq.put("\u56fd\u5927", 4205);
    freq.put("\u6392", 1222);
    freq.put("\u4e91\u5357\u3001", 1087);
    freq.put("\u3001\u6e56", 1562);
    freq.put("\u3001\u4e58", 1367);
    freq.put("\u7b49\u3002", 1256);
    freq.put("\u961f", 3990);
    freq.put("\u4ea4", 20817);
    freq.put("\u53c8\u79f0", 2280);
    freq.put("\u4e08·", 660);
    freq.put("\u7acb,", 948);
    freq.put("\u4e2d\u56fd", 13581);
    freq.put("\u603b", 5550);
    freq.put("\u5e74\u4ee3", 1820);
    freq.put("\u3001\u4e01", 2633);
    freq.put("\u4e2d\u7684", 2873);
    freq.put("\u7ec4", 5795);
    freq.put("\u7247", 2527);
    freq.put("\u3001\u4e08", 4209);
    freq.put("\u3001\u4e0d", 1336);
    freq.put("\u3001\u7518\u8083", 804);
    freq.put("\u5e74( ", 710);
    freq.put("\u897f\u90e8", 624);
    freq.put("\u4ee4", 1161);
    freq.put("\u6267", 1062);
    freq.put("\u7f57\u65af", 1403);
    freq.put("\u6ca1\u6709", 1287);
    freq.put("\u3001\u4e2d", 959);
    freq.put("\u8054\u4f11", 1568);
    freq.put("\u5171", 7134);
    freq.put("\u897f\u73ed\u4e01", 773);
    freq.put("\u533a\u57df", 737);
    freq.put("(\u5b66\u540d", 3651);
    freq.put("\u56f4", 1767);
    freq.put("\u5730\u533a\u7684", 687);
    freq.put("\u7ebf\u7684", 727);
    freq.put("\u5bb6 ", 943);
    freq.put("\u5904,", 614);
    freq.put(",\u7b2c", 777);
    freq.put("\u5b97", 2085);
    freq.put("\u519b", 7136);
    freq.put("\u8bb8\u591a", 1084);
    freq.put("\u63a7", 1211);
    freq.put("\u4eba\u7684", 1301);
    freq.put("\u8f6f\u4ea4", 1060);
    freq.put("\u7b2c", 11099);
    freq.put("\u6cb9", 1041);
    freq.put("\u79d1\u4e08", 1055);
    freq.put("\u4e3a", 43069);
    freq.put("\u043e", 642);
    freq.put("\u7ad9(", 605);
    freq.put("\u4e9a\u4e08", 1056);
    freq.put("\u7ad9,", 1417);
    freq.put("\u6b4c", 2416);
    freq.put("\u57df", 2609);
    freq.put("\u4f1a\u8bae", 766);
    freq.put("\u57ce\u4e8b", 1744);
    freq.put("\u4ee5", 21926);
    freq.put("\u5170", 5551);
    freq.put("\u7801", 1376);
    freq.put("\u5409", 2174);
    freq.put("\u5730\u3001", 838);
    freq.put("\u521d", 2398);
    freq.put("\u571f", 2149);
    freq.put("\u6821", 3605);
    freq.put("\u8d23", 1208);
    freq.put("\u4e25", 592);
    freq.put(",\u5b83", 1417);
    freq.put(",\u7b80", 2029);
    freq.put("\u533a\u7684", 1567);
    freq.put("\u592b", 2315);
    freq.put("\u5b66\u751f", 932);
    freq.put("\u51b0", 646);
    freq.put("\u4eba", 38353);
    freq.put("\u4e01\u897f", 582);
    freq.put("\u8d35\u5dde\u3001", 836);
    freq.put("\u5347", 971);
    freq.put("\u4f4f", 1250);
    freq.put("\u3001\u4f11", 601);
    freq.put("\u5927\u5b66", 4751);
    freq.put("\u82cf", 3117);
    freq.put("\u4e9a\u4e9a", 814);
    freq.put("\u5206\u5e03\u5728", 1639);
    freq.put("\u8ba1\u7b97\u673a", 592);
    freq.put("\u5e76\u4e01", 847);
    freq.put("\u5e03\u4e8e", 1877);
    freq.put("\u4e08\u81f3", 636);
    freq.put("\u4f11\u3001", 1110);
    freq.put("\u4f11\u3002", 1293);
    freq.put("\u6bd5", 833);
    freq.put("\u5b81", 1619);
    freq.put("\u7279\u522b", 1034);
    freq.put("\u56fd\u5bb6", 4191);
    freq.put("\u4e58,", 704);
    freq.put("\u6839\u636e", 1261);
    freq.put("\u81ea\u7136", 791);
    freq.put("\u52a0\u4e58\u5927", 716);
    freq.put("\u56db\u5ddd", 1896);
    freq.put("\u6210", 16718);
    freq.put("\u6709\u7684", 742);
    freq.put("\u9f99", 3881);
    freq.put("\u529b", 4944);
    freq.put("\u949f", 734);
    freq.put("\u8ba1", 5438);
    freq.put("\u4f4d\u4e8e\u9999", 588);
    freq.put("\u4e2d\u56fd\u7684", 1325);
    freq.put("\u5230", 6365);
    freq.put("\u5b66\u7684", 914);
    freq.put("\u5434", 771);
    freq.put("\u8fb9", 2785);
    freq.put("\u6e38", 3622);
    freq.put("\u3001\u9655\u897f", 793);
    freq.put("\u300b ", 659);
    freq.put("\u9648", 1215);
    freq.put("\u884c", 14959);
    freq.put("\u4f4e", 1173);
    freq.put("\u7b56", 957);
    freq.put("\u505c", 661);
    freq.put("\u5b97\u6559", 606);
    freq.put("\u975e", 3368);
    freq.put("\u4ee3", 10675);
    freq.put("\u7f6e", 1765);
    freq.put("\u3001\u6cb3", 1285);
    freq.put(" \u6216", 968);
    freq.put("\u6765\u81ea", 905);
    freq.put("\u4e9a\u6d32", 979);
    freq.put("\u677e", 1118);
    freq.put("\u5e03", 7549);
    freq.put("\u5982", 3936);
    freq.put("\u5386", 4017);
    freq.put("\u690d", 5185);
    freq.put("\u7a7a\u95f4", 581);
    freq.put("\u6613", 1898);
    freq.put(" \u82f1", 812);
    freq.put("\u521b", 4231);
    freq.put("\u3001\u6c5f", 1104);
    freq.put("\u6b21", 4906);
    freq.put("\u8d25", 623);
    freq.put("\u8054\u8d5b", 872);
    freq.put("\u5730\u533a", 6955);
    freq.put("\u7684 ", 3036);
    freq.put("\u5230 ", 1169);
    freq.put("\u51b2", 743);
    freq.put("\u7535", 10706);
    freq.put("\u6837", 1395);
    freq.put("\u7518\u8083", 1053);
    freq.put("\u6216\u8005", 862);
    freq.put("\u5b66\u9662", 1919);
    freq.put("\u6709\u690d", 939);
    freq.put("\u6216 ", 819);
    freq.put("\u53f8(", 706);
    freq.put("\u53f8,", 904);
    freq.put("\u4e00\u90e8", 1591);
    freq.put("\u8bf4,", 693);
    freq.put("\u53ef\u80fd", 964);
    freq.put("\u4e0d\u4f11", 658);
    freq.put("\u52a8,", 770);
    freq.put("\u7406\u8bba", 1071);
    freq.put("\u7a81", 730);
    freq.put(",\u5927", 803);
    freq.put("\u3001\u5e7f\u4e1c", 743);
    freq.put("\u5206", 15267);
    freq.put("\u6700\u4e08", 683);
    freq.put("\u4e0e", 14330);
    freq.put("\u5e99", 584);
    freq.put("\u7f18", 1067);
    freq.put("\u739b", 789);
    freq.put("\u5c1a", 3502);
    freq.put("\u9a6c\u6765", 712);
    freq.put("\u6728", 1876);
    freq.put("\u5bab", 1054);
    freq.put("\u91cd\u8981", 1745);
    freq.put(",\u591a", 1573);
    freq.put("\u663e", 972);
    freq.put("\u4e0d\u4ea4", 3736);
    freq.put("\u4e0d\u4eac", 1465);
    freq.put("\u97f3\u4e50", 1761);
    freq.put("\u4e08\u8349", 591);
    freq.put("\u7684\u4e00", 9462);
    freq.put("\u4e1c\u3001", 1223);
    freq.put("\u7ed9", 1157);
    freq.put("\u5728 ", 4342);
    freq.put("\u3002\u7531\u4e8e", 637);
    freq.put("\u6768", 679);
    freq.put("\u57fa\u4e01", 1219);
    freq.put("\u4e0d\u4e8b", 949);
    freq.put("\u4ee3\u7684", 607);
    freq.put("\u5370", 3243);
    freq.put("\u97f3", 4816);
    freq.put("\u80fd", 5645);
    freq.put("\u56fd\u7acb", 626);
    freq.put("\u5a01", 2129);
    freq.put("\u7b80", 4298);
    freq.put("\u4e8c\u6b21", 594);
    freq.put("\u671d\u9c9c", 1221);
    freq.put("\u4e8e", 42781);
    freq.put("\u6211", 858);
    freq.put("\u5e94\u7528", 955);
    freq.put("\u5df2\u7ecf", 808);
    freq.put("\u519c", 1200);
    freq.put("\u751f", 19204);
    freq.put("\u540c\u7684", 919);
    freq.put(",\u5982", 965);
    freq.put("\u516c\u56ed", 1063);
    freq.put("\u7231", 2167);
    freq.put("\u73b0", 8430);
    freq.put("\u4f20\u7edf", 899);
    freq.put(",\u9999", 721);
    freq.put("\u9521", 594);
    freq.put("\u5c45", 1947);
    freq.put("\u5185\u7684", 698);
    freq.put("\u4ece", 3822);
    freq.put("\u63d0", 4221);
    freq.put(")\u3001", 2880);
    freq.put(")\u3002", 3713);
    freq.put("\u56de", 1392);
    freq.put("\u4e0d\u4e01", 1361);
    freq.put("\u4e0d\u4e0d", 1140);
    freq.put("\u4e0d\u4e08", 1417);
    freq.put("\u53f0", 13293);
    freq.put("\u3001\u8d35", 865);
    freq.put("\u56fd\u5927\u9646", 3832);
    freq.put("\u66fe", 3299);
    freq.put("\u4e00\u3002", 1805);
    freq.put("\u5883", 2254);
    freq.put("\u5f02", 925);
    freq.put("\u4e8e\u4e2d", 1731);
    freq.put("\u7687", 2205);
    freq.put("\u6210\u4e3a", 2403);
    freq.put("\u7535\u5b50", 1067);
    freq.put("\u524d\u8eab", 709);
    freq.put("\u5e97", 1431);
    freq.put("\u9999", 9519);
    freq.put(",\u4e5f\u662f", 1477);
    freq.put(",\u5e38", 1051);
    freq.put("\u4e8e\u4e08", 1169);
    freq.put("\u4e8e\u4e0d", 3550);
    freq.put("\u4e8e\u4e01", 1020);
    freq.put("\u5a92\u4f53", 593);
    freq.put("\u4e58\u5927", 1199);
    freq.put("\u592e", 1321);
    freq.put("\u516c\u5171", 779);
    freq.put("\u6838", 1380);
    freq.put("\u516c\u53f8,", 865);
    freq.put("\u516c\u53f8(", 690);
    freq.put("\u5c40", 2483);
    freq.put("\u5546", 3626);
    freq.put("\u5546\u4e1a", 792);
    freq.put("\u534a", 2037);
    freq.put("\u300b\u662f", 802);
    freq.put("\u4e4c", 1217);
    freq.put("\u4eba\u53e3", 1818);
    freq.put(",\u5e76", 4017);
    freq.put("\u4e1c\u7701", 644);
    freq.put(",\u5176\u4e2d", 943);
    freq.put("\u8be5", 4765);
    freq.put("·\u4e01", 954);
    freq.put("·\u4e08", 771);
    freq.put("\u5ea6\u3001", 646);
    freq.put("\u4ef7", 1006);
    freq.put("\u7eaa\u5ff5", 701);
    freq.put("\u516c\u91cc", 2086);
    freq.put("\u4e8c", 6378);
    freq.put("\u6c5f\u82cf", 807);
    freq.put("\u533b\u5b66", 647);
    freq.put("\u9898", 1997);
    freq.put("\u540d\u4f7f", 755);
    freq.put("\u5b9a", 6314);
    freq.put("\u7684\u662f", 1254);
    freq.put("\u5316\u5b66", 839);
    freq.put("\u4ee5\u53ca", 5720);
    freq.put("\u4f4d,", 691);
    freq.put("\u4f7f\u4f11", 784);
    freq.put("\u7531", 17497);
    freq.put("\u5b66\u3001", 1095);
    freq.put("\u8bba", 3372);
    freq.put("\u623f", 1033);
    freq.put("\u5174", 1795);
    freq.put(" \u65e5,", 1367);
    freq.put(" \u65e5)", 775);
    freq.put("\u5149", 2911);
    freq.put("\u4f11\u753b", 658);
    freq.put("\u53ca", 17913);
    freq.put("\u4f4d", 13424);
    freq.put("\u5e73\u4e0d\u516c", 791);
    freq.put("\u62d4", 3550);
    freq.put("\u6e56\u5357", 1294);
    freq.put("\u5305\u542b", 732);
    freq.put("\u662f\u5728", 1454);
    freq.put(",\u7ecf", 598);
    freq.put("\u7cfb\u7edf", 2897);
    freq.put("\u4fdd\u62a4", 898);
    freq.put("\u8bfa", 1644);
    freq.put("\u53ca ", 757);
    freq.put("\u627f", 1002);
    freq.put("\u9c81", 1516);
    freq.put("\u7406", 9553);
    freq.put("\u4e2d\u534e", 3016);
    freq.put("\u6295", 1684);
    freq.put("\u5206\u5e03\u4e8e", 1823);
    freq.put("\u5f97", 4936);
    freq.put("\u5171\u540c", 711);
    freq.put("\u539f", 6718);
    freq.put("\u6ca1", 1471);
    freq.put("\u822a", 2316);
    freq.put(",)", 1561);
    freq.put("\u7530", 1994);
    freq.put("\u51b3", 1729);
    freq.put("\u9632", 1166);
    freq.put("\u5f15\u4e9a\u683d", 2908);
    freq.put("\u547d\u540d", 845);
    freq.put("\u7cfb,", 584);
    freq.put("\u65e5\u672c", 5547);
    freq.put("\u5148", 2098);
    freq.put("\u4ecd", 888);
    freq.put("\u65af\u4e01", 803);
    freq.put("\u6cb3\u4e0d", 810);
    freq.put("\u4f7f\u4ee3", 599);
    freq.put(")\u7684", 2201);
    freq.put("\u5e7f\u5dde", 765);
    freq.put("\u89e3", 2300);
    freq.put("\u6b64", 5466);
    freq.put("\u6210\u4f55", 673);
    freq.put("e\u0301", 695);
    freq.put("\u7eed", 1408);
    freq.put("\u786e", 1094);
    freq.put(" ),", 840);
    freq.put(",\u5f53", 886);
    freq.put("\u5de5\u5f15", 2908);
    freq.put("(),", 1527);
    freq.put("\u53d1\u884c", 1130);
    freq.put("\u540d\u3002", 910);
    freq.put(" \u65e5", 10844);
    freq.put("\u9009", 3181);
    freq.put("\u7ec4\u7ec7", 2012);
    freq.put("\u4e0d", 69712);
    freq.put("\u7684\u6700", 739);
    freq.put("\u4f7f\u4e2d", 607);
    freq.put("\u671f,", 613);
    freq.put("\u300a\u4e08", 900);
    freq.put("\u90fd\u662f", 704);
    freq.put("\u5171\u548c", 2100);
    freq.put("\u3002 ", 4085);
    freq.put("\u8ba4", 2753);
    freq.put(",\u7f8e", 598);
    freq.put("\u5e2d", 1225);
    freq.put("\u4f7f\u4e0a", 903);
    freq.put("\u4f7f\u4e08", 1433);
    freq.put("\u6839", 2240);
    freq.put("\u8d1f\u8d23", 846);
    freq.put("\u4fc4\u7f57\u65af", 1205);
    freq.put("\u4f7f\u4e01", 935);
    freq.put(":,", 733);
    freq.put("\u4eba\u7269", 960);
    freq.put("\u5df4\u4f7f", 874);
    freq.put("\u6d4b", 1385);
    freq.put("\u65e5 ", 1181);
    freq.put("\u662f\u9999\u6e2f", 1721);
    freq.put("\u6709\u4e08", 634);
    freq.put("\u7f57", 6436);
    freq.put("\u6709\u4e00", 1032);
    freq.put("\u4e3a\u53f0", 739);
    freq.put("\u540d\u4e3a", 1425);
    freq.put("\u8c61", 1888);
    freq.put("\u5173", 4776);
    freq.put("\u7b49\u5730", 3350);
    freq.put("\u867d", 721);
    freq.put("\u4e8e\u65e5\u672c", 718);
    freq.put("\u5b9a\u4e49", 596);
    freq.put("\u3042\u3042", 1707);
    freq.put("\u5706", 692);
    freq.put("\u4e8b", 19248);
    freq.put("\u4eba\u95fb", 930);
    freq.put("\u521b\u529e", 644);
    freq.put("\u5229\u7528", 693);
    freq.put("\u7f16", 2591);
    freq.put("\u591a", 11036);
    freq.put("\u8d22", 832);
    freq.put(",\u5c0f", 789);
    freq.put("\u6587:", 2387);
    freq.put("\u9650\u516c\u53f8", 1342);
    freq.put("\u52b3", 804);
    freq.put("\u51b5", 701);
    freq.put("\u4e08\u662f", 785);
    freq.put("\u65bd", 1293);
    freq.put("\u4e2d\u3001", 800);
    freq.put("\u90e8\u4efd", 779);
    freq.put("\u8fc7 ", 590);
    freq.put(" \u662f", 2568);
    freq.put("\u4fe1\u606f", 699);
    freq.put("\u5de5", 9317);
    freq.put("\u56db", 5911);
    freq.put("\u4e01\u4e9a", 2029);
    freq.put("\u4fe1", 7840);
    freq.put("\u4e60", 841);
    freq.put("\u5c0f,", 1060);
    freq.put("\u5f15\u4e9a", 2921);
    freq.put("\u843d", 1487);
    freq.put("\u88ab\u79f0\u4e3a", 866);
    freq.put("\u5e0c\u814a", 1007);
    freq.put("\u5efa\u4e01", 1787);
    freq.put("\u4e5f\u662f", 2441);
    freq.put("\u4e8e\u53f0\u6e7e", 746);
    freq.put("\u3001\u897f", 1056);
    freq.put(",\u5c5e", 841);
    freq.put("\u7684\u7279\u6709", 970);
    freq.put("\u9884", 942);
    freq.put("\u4e0b", 7962);
    freq.put("\u690d\u7269", 4924);
    freq.put("\u4e01\u4e58", 875);
    freq.put(",\u4ece", 880);
    freq.put("\u901f", 2166);
    freq.put("\u4e0e\u4e08", 673);
    freq.put("\u5f62\u5f0f", 842);
    freq.put("\u4e01\u4e71", 789);
    freq.put("\u8c37", 1826);
    freq.put("\u4e01(", 1706);
    freq.put("\u56fd,", 704);
    freq.put("\u516c\u53f8", 6085);
    freq.put("\u4e01\u4e01", 3673);
    freq.put("\u8005,", 759);
    freq.put("\u4e01\u4e08", 5202);
    freq.put("\u4e4b", 17358);
    freq.put("\u91ca", 634);
    freq.put("\u4e01\u4e0d", 1113);
    freq.put("\u6751", 1739);
    freq.put("\u6253", 1400);
    freq.put("\u9ad8", 8988);
    freq.put("\u4e08\u79d1", 1509);
    freq.put("\u5efa\u4e8e", 690);
    freq.put("\u65f6\u7684", 619);
    freq.put(":)\u4e3a", 1432);
    freq.put("\u81ea", 8792);
    freq.put("\u5c5e\u7684\u690d", 2824);
    freq.put("\u662f\u7531", 1948);
    freq.put("\u5f00", 7255);
    freq.put("\u5b83", 4574);
    freq.put("\u4e8e\u4e2d\u56fd", 1363);
    freq.put("\u5904", 4116);
    freq.put("\u300a", 12801);
    freq.put("\u72ec\u7acb", 1054);
    freq.put("\u4e01\u8fd1", 677);
    freq.put(" \u5e74 ", 13492);
    freq.put("\u4ea1", 667);
    freq.put("\u4f20", 4668);
    freq.put("\u5cad", 590);
    freq.put("\u533a\u3001", 855);
    freq.put("\u533a\u3002", 806);
    freq.put("\u5730", 26817);
    freq.put("\u6570\u5b66", 761);
    freq.put("\u91cd\u8981\u7684", 693);
    freq.put(":)\u662f", 1905);
    freq.put("\u540d:)", 3257);
    freq.put("\u5c42", 1590);
    freq.put("\u4e2a\u4eba", 1067);
    freq.put("\u9646", 5534);
    freq.put("\u7684\u3002", 902);
    freq.put(",\u5305\u62ec", 1127);
    freq.put(")\u548c", 952);
    freq.put("\u4e5f\u6709", 715);
    freq.put("\u8d44\u6599", 726);
    freq.put("\u7ad9", 6147);
    freq.put("\u5b58", 2538);
    freq.put("\u955c", 635);
    freq.put("\u662f\u4e2d\u56fd", 2142);
    freq.put("\u6ee1", 827);
    freq.put("\u4f7f\u7684", 2300);
    freq.put("\u65e7", 1079);
    freq.put(" \u6708", 13702);
    freq.put("\u79ef", 2267);
    freq.put("\u4e9a\u683d", 2911);
    freq.put("\u4f11\u7684", 1686);
    freq.put("\u827e", 805);
    freq.put("\u54c1", 4389);
    freq.put("\u6c11\u5171\u548c", 1261);
    freq.put("\u662f\u53f0\u6e7e", 602);
    freq.put("\u4e08\u6797", 809);
    freq.put("\u4e01\u4f5c", 779);
    freq.put("\u529e", 2818);
    freq.put("\u4e01\u6587", 660);
    freq.put("\u63a8", 2158);
    freq.put("\u4eba\u3002", 1182);
    freq.put("\u8bb8", 1740);
    freq.put("\u4f55\u4e01", 623);
    freq.put("\u8fde\u63a5", 661);
    freq.put("\u4e01\u4f7f", 3178);
    freq.put("\u7406\u5b66", 1070);
    freq.put("\u9547", 2371);
    freq.put("\u53c8", 5333);
    freq.put("\u4e01\u4f11", 2172);
    freq.put("\u4e0d\u6cbb", 1654);
    freq.put("\u52de", 1639);
    freq.put("\u4e61", 1808);
    freq.put("\u6b63", 4102);
    freq.put("\u6ce2", 2738);
    freq.put("\u6865", 1371);
    freq.put("\u6269", 636);
    freq.put("\u8282\u76ee", 923);
    freq.put("\u5efa\u7acb", 1106);
    freq.put("\u4ed6\u4eec", 991);
    freq.put("\u94c1\u8def", 1902);
    freq.put("\u5373", 2844);
    freq.put("\u7075", 903);
    freq.put("\u8d77", 4293);
    freq.put("\u8bf8", 678);
  }

}

