package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class TL extends CLangProfile {
  private static final String name = "tl";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public TL() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2110634;
    n_words[1] = 2489828;
    n_words[2] = 1864789;

    freq.put(" th", 440);
    freq.put("aug", 319);
    freq.put("aun", 478);
    freq.put(" Gu", 254);
    freq.put(" Gr", 1130);
    freq.put(" Ge", 219);
    freq.put(" Ga", 496);
    freq.put(" Go", 283);
    freq.put(" Gi", 361);
    freq.put("upo", 374);
    freq.put("Gu", 257);
    freq.put("Gr", 1131);
    freq.put("upa", 766);
    freq.put("Ge", 222);
    freq.put("Ga", 499);
    freq.put("Go", 284);
    freq.put("Gi", 363);
    freq.put("a\u0304", 268);
    freq.put(" ka", 12843);
    freq.put("me ", 332);
    freq.put(" ki", 1772);
    freq.put(" ko", 1618);
    freq.put(" kl", 1518);
    freq.put("Ce", 320);
    freq.put(" ku", 1926);
    freq.put("nel", 268);
    freq.put("kuy", 222);
    freq.put("kun", 1182);
    freq.put("kum", 367);
    freq.put("ain", 942);
    freq.put("net", 328);
    freq.put("ak ", 1818);
    freq.put("ner", 635);
    freq.put("nes", 773);
    freq.put("med", 215);
    freq.put("men", 704);
    freq.put("met", 267);
    freq.put("mes", 455);
    freq.put("mer", 827);
    freq.put("gli", 561);
    freq.put("gla", 763);
    freq.put("k", 54159);
    freq.put("gle", 2258);
    freq.put("aku", 295);
    freq.put("akt", 378);
    freq.put("aki", 2053);
    freq.put("akh", 385);
    freq.put("ako", 347);
    freq.put("akl", 349);
    freq.put("aka", 4840);
    freq.put("Kon", 276);
    freq.put("bri", 332);
    freq.put("bre", 1519);
    freq.put("bra", 317);
    freq.put("m ", 2592);
    freq.put("er ", 1701);
    freq.put("ni ", 1903);
    freq.put("Sta", 256);
    freq.put("V", 1273);
    freq.put("iv", 697);
    freq.put("me", 3130);
    freq.put("mg", 9391);
    freq.put("ma", 23630);
    freq.put("mb", 3361);
    freq.put("mm", 511);
    freq.put("mo", 2915);
    freq.put("mi", 5214);
    freq.put("ril", 614);
    freq.put("mu", 4995);
    freq.put("ere", 336);
    freq.put("tna", 387);
    freq.put("era", 1743);
    freq.put("erb", 250);
    freq.put("erm", 213);
    freq.put("ern", 685);
    freq.put("ero", 994);
    freq.put("eri", 1261);
    freq.put("Le", 701);
    freq.put("io", 2262);
    freq.put("La", 1279);
    freq.put("Lo", 364);
    freq.put("la ", 7051);
    freq.put("Li", 502);
    freq.put("Abr", 300);
    freq.put("Lu", 1605);
    freq.put("uan", 1897);
    freq.put("Kab", 349);
    freq.put("enc", 265);
    freq.put("Kag", 252);
    freq.put("ene", 540);
    freq.put("eng", 2031);
    freq.put("hon", 897);
    freq.put("hol", 219);
    freq.put("Kan", 214);
    freq.put("Kal", 869);
    freq.put("Kas", 598);
    freq.put("Kar", 312);
    freq.put("ens", 1983);
    freq.put("ent", 2381);
    freq.put("Kat", 442);
    freq.put("A", 19564);
    freq.put("lam", 1407);
    freq.put("lan", 8966);
    freq.put("lah", 600);
    freq.put("lak", 2054);
    freq.put("lad", 618);
    freq.put("lag", 1451);
    freq.put("laa", 472);
    freq.put("lab", 1035);
    freq.put("lay", 1014);
    freq.put("lat", 1650);
    freq.put("law", 4043);
    freq.put("lap", 417);
    freq.put("lar", 1484);
    freq.put("las", 3731);
    freq.put("en ", 605);
    freq.put("Ale", 251);
    freq.put("Alt", 229);
    freq.put(" Hu", 696);
    freq.put(" Hi", 657);
    freq.put(" Ho", 300);
    freq.put(" Ha", 926);
    freq.put("uwa", 445);
    freq.put(" He", 600);
    freq.put("ima", 551);
    freq.put("imb", 583);
    freq.put("ime", 284);
    freq.put("imi", 396);
    freq.put("imo", 757);
    freq.put("imp", 821);
    freq.put("imu", 413);
    freq.put(" ga", 1201);
    freq.put("Hil", 266);
    freq.put("uon", 264);
    freq.put(" Va", 226);
    freq.put(" Vi", 396);
    freq.put("im ", 631);
    freq.put("l", 93919);
    freq.put("uo ", 439);
    freq.put("mbo", 357);
    freq.put("nt ", 493);
    freq.put("rt", 2397);
    freq.put("ru", 1218);
    freq.put("gon", 726);
    freq.put("rp", 226);
    freq.put("rr", 466);
    freq.put("rs", 1459);
    freq.put("ry", 2421);
    freq.put("rd", 981);
    freq.put("re", 7270);
    freq.put("rg", 616);
    freq.put("ra", 14328);
    freq.put("rb", 496);
    freq.put("rc", 435);
    freq.put("rl", 534);
    freq.put("rm", 690);
    freq.put("rn", 1128);
    freq.put("is ", 1468);
    freq.put("ri", 11065);
    freq.put("gos", 419);
    freq.put("gor", 456);
    freq.put("nia", 263);
    freq.put("ntr", 369);
    freq.put("ntu", 218);
    freq.put("nti", 1113);
    freq.put("W", 1008);
    freq.put("nta", 1619);
    freq.put("nte", 1041);
    freq.put("isy", 1436);
    freq.put("ate", 772);
    freq.put("ata", 9859);
    freq.put("ato", 908);
    freq.put("atl", 420);
    freq.put("go ", 1131);
    freq.put("ath", 277);
    freq.put("ist", 2727);
    freq.put("isi", 1179);
    freq.put("ish", 487);
    freq.put("r ", 5313);
    freq.put("ism", 492);
    freq.put("isa", 12350);
    freq.put("ise", 486);
    freq.put("nis", 952);
    freq.put("tem", 511);
    freq.put("tor", 922);
    freq.put("ton", 2028);
    freq.put("tol", 467);
    freq.put("tom", 241);
    freq.put(" le", 482);
    freq.put("B", 7360);
    freq.put("gya", 341);
    freq.put(" lo", 567);
    freq.put(" li", 1169);
    freq.put(" lu", 1621);
    freq.put("Set", 224);
    freq.put("ktu", 302);
    freq.put("i\u0301", 225);
    freq.put("kto", 418);
    freq.put("to ", 7587);
    freq.put("rag", 342);
    freq.put("rad", 734);
    freq.put("rab", 295);
    freq.put("raa", 290);
    freq.put("ran", 3019);
    freq.put("ral", 1710);
    freq.put("ram", 928);
    freq.put("ty ", 596);
    freq.put("ose", 518);
    freq.put("lba", 235);
    freq.put("raw", 1292);
    freq.put("rat", 708);
    freq.put("ras", 562);
    freq.put("rap", 411);
    freq.put("Asy", 352);
    freq.put("on ", 10511);
    freq.put("Qu", 349);
    freq.put("ra ", 2777);
    freq.put("tye", 228);
    freq.put("y", 61992);
    freq.put("sub", 226);
    freq.put("Ito", 837);
    freq.put("don", 511);
    freq.put("m", 59846);
    freq.put("Ita", 502);
    freq.put("sun", 606);
    freq.put("dor", 701);
    freq.put("dos", 801);
    freq.put("\u4e00\u4e00", 311);
    freq.put("sul", 377);
    freq.put(" Wa", 224);
    freq.put("d ", 6470);
    freq.put(" Wi", 299);
    freq.put("sto", 847);
    freq.put("Bib", 239);
    freq.put("kul", 1301);
    freq.put("ba ", 1007);
    freq.put("do", 3993);
    freq.put("di", 5171);
    freq.put("de", 3129);
    freq.put("da", 7330);
    freq.put("dy", 626);
    freq.put("X", 334);
    freq.put("dt", 243);
    freq.put("du", 1243);
    freq.put("dr", 607);
    freq.put("eme", 244);
    freq.put("baw", 340);
    freq.put("bat", 1046);
    freq.put("bar", 318);
    freq.put("bas", 870);
    freq.put("emb", 1031);
    freq.put("emo", 250);
    freq.put("emi", 251);
    freq.put("bay", 2496);
    freq.put("bag", 1029);
    freq.put("bae", 247);
    freq.put("bab", 1067);
    freq.put("emp", 247);
    freq.put("ban", 3506);
    freq.put("bal", 915);
    freq.put("bak", 379);
    freq.put("bah", 2518);
    freq.put("w ", 2307);
    freq.put("nut", 274);
    freq.put("nus", 223);
    freq.put("Per", 237);
    freq.put("nun", 621);
    freq.put("nul", 380);
    freq.put("num", 251);
    freq.put("oma", 662);
    freq.put("nub", 254);
    freq.put("mut", 297);
    freq.put("il ", 1019);
    freq.put("co ", 247);
    freq.put("iro", 325);
    freq.put("ira", 1126);
    freq.put("mun", 975);
    freq.put("ire", 294);
    freq.put("we", 663);
    freq.put("wa", 7331);
    freq.put("wo", 282);
    freq.put(" Ir", 258);
    freq.put(" Is", 900);
    freq.put(" It", 1471);
    freq.put("wi", 4192);
    freq.put(" Ik", 389);
    freq.put("ws", 238);
    freq.put(" Im", 284);
    freq.put(" In", 3092);
    freq.put("unt", 520);
    freq.put("han", 3970);
    freq.put("ila", 8566);
    freq.put("ilo", 675);
    freq.put("ill", 466);
    freq.put("ili", 6551);
    freq.put("una", 2530);
    freq.put("und", 796);
    freq.put("ung", 3950);
    freq.put("uni", 882);
    freq.put("com", 405);
    freq.put("ily", 587);
    freq.put(" me", 432);
    freq.put(" mg", 9378);
    freq.put(" ma", 12562);
    freq.put(" mo", 343);
    freq.put(" mi", 835);
    freq.put(" mu", 2405);
    freq.put("sah", 246);
    freq.put("hag", 932);
    freq.put("san", 13859);
    freq.put("ggi", 233);
    freq.put("C ", 400);
    freq.put("pro", 666);
    freq.put("pri", 362);
    freq.put("Ch", 481);
    freq.put("Co", 1457);
    freq.put("Ca", 1287);
    freq.put("ais", 377);
    freq.put("n", 268000);
    freq.put("ail", 347);
    freq.put("gna", 429);
    freq.put("aig", 364);
    freq.put("sla", 213);
    freq.put("iy", 6303);
    freq.put("iz", 356);
    freq.put("Nag", 476);
    freq.put("ip", 8303);
    freq.put("is", 21654);
    freq.put("ir", 2572);
    freq.put("iu", 510);
    freq.put("it", 15297);
    freq.put("iw", 1139);
    freq.put("Za", 253);
    freq.put("ii", 644);
    freq.put("ih", 1209);
    freq.put("ik", 10689);
    freq.put("ld ", 260);
    freq.put("im", 4535);
    freq.put("il", 18574);
    freq.put("Nat", 309);
    freq.put("in", 32448);
    freq.put("ia", 4281);
    freq.put("ic", 2306);
    freq.put("ki ", 400);
    freq.put("ie", 1122);
    freq.put("id", 2936);
    freq.put("ig", 7316);
    freq.put("if", 239);
    freq.put("Ika", 371);
    freq.put("th ", 280);
    freq.put("nik", 402);
    freq.put("nin", 947);
    freq.put("nil", 1831);
    freq.put("nim", 327);
    freq.put("nib", 262);
    freq.put("kip", 244);
    freq.put("nid", 488);
    freq.put("kit", 510);
    freq.put("kik", 335);
    freq.put("niy", 508);
    freq.put("kin", 1435);
    freq.put("kil", 1497);
    freq.put("Y", 471);
    freq.put("i ", 12212);
    freq.put("niv", 230);
    freq.put("niw", 515);
    freq.put("nit", 1670);
    freq.put("mil", 657);
    freq.put("Va", 226);
    freq.put("Vi", 399);
    freq.put("epu", 270);
    freq.put("the", 612);
    freq.put("tha", 237);
    freq.put("yem", 924);
    freq.put("yen", 248);
    freq.put("yea", 322);
    freq.put("yeg", 287);
    freq.put("op ", 492);
    freq.put("hah", 296);
    freq.put("eli", 929);
    freq.put("hal", 1546);
    freq.put("ham", 439);
    freq.put("ell", 447);
    freq.put("hab", 327);
    freq.put("ela", 487);
    freq.put("ele", 614);
    freq.put("hay", 2401);
    freq.put("har", 726);
    freq.put("has", 418);
    freq.put("hat", 613);
    freq.put("opu", 1605);
    freq.put("D", 3787);
    freq.put("rna", 412);
    freq.put("Tre", 501);
    freq.put("rne", 221);
    freq.put("ope", 331);
    freq.put("opo", 245);
    freq.put("opi", 377);
    freq.put("ha ", 509);
    freq.put("el ", 1262);
    freq.put("Ara", 274);
    freq.put("ola", 327);
    freq.put("ole", 828);
    freq.put(" Ju", 282);
    freq.put("oli", 798);
    freq.put("oll", 560);
    freq.put("olo", 1158);
    freq.put(" Jo", 502);
    freq.put(" Ja", 583);
    freq.put("umu", 925);
    freq.put("ich", 298);
    freq.put("ump", 364);
    freq.put("ica", 454);
    freq.put("ob ", 490);
    freq.put("Leo", 280);
    freq.put("Hi", 663);
    freq.put("uma", 1769);
    freq.put("Ho", 302);
    freq.put("umb", 268);
    freq.put("Ha", 926);
    freq.put("umi", 469);
    freq.put("ict", 361);
    freq.put("ol ", 1113);
    freq.put("pla", 312);
    freq.put("ic ", 391);
    freq.put("o", 112013);
    freq.put("um ", 503);
    freq.put("oby", 351);
    freq.put("aha", 5905);
    freq.put("sod", 1704);
    freq.put("ppi", 245);
    freq.put("ahi", 1712);
    freq.put("aho", 893);
    freq.put("son", 453);
    freq.put("ahu", 567);
    freq.put("mbr", 990);
    freq.put("wan", 2646);
    freq.put("git", 1186);
    freq.put("gis", 283);
    freq.put("wag", 936);
    freq.put("gin", 2170);
    freq.put("gil", 253);
    freq.put("war", 240);
    freq.put("so ", 2182);
    freq.put("Z", 463);
    freq.put("ura", 1051);
    freq.put("wa ", 1340);
    freq.put("gi ", 930);
    freq.put("Siy", 420);
    freq.put("u\u0308d", 216);
    freq.put("kha", 550);
    freq.put("Sil", 411);
    freq.put("ni", 11322);
    freq.put("nl", 1083);
    freq.put("tiy", 331);
    freq.put("nn", 491);
    freq.put("no", 9894);
    freq.put("tit", 772);
    freq.put("na", 50921);
    freq.put("nc", 944);
    freq.put("nd", 5861);
    freq.put("ne", 3717);
    freq.put("tir", 721);
    freq.put("ng", 124226);
    freq.put("til", 777);
    freq.put("ny", 2397);
    freq.put("tin", 3062);
    freq.put("tio", 1023);
    freq.put("tik", 1397);
    freq.put("tid", 407);
    freq.put("ns", 5167);
    freq.put("nt", 6347);
    freq.put("nu", 2551);
    freq.put("tib", 304);
    freq.put(" ni", 3203);
    freq.put("E", 3422);
    freq.put(" no", 3658);
    freq.put(" na", 26725);
    freq.put(" ne", 259);
    freq.put(" ng", 29501);
    freq.put("Si ", 2472);
    freq.put("n ", 41545);
    freq.put("rk ", 265);
    freq.put("ti ", 555);
    freq.put("rol", 389);
    freq.put("ron", 875);
    freq.put("Tsi", 277);
    freq.put("rod", 249);
    freq.put("ost", 571);
    freq.put("osi", 296);
    freq.put("oso", 256);
    freq.put("rop", 486);
    freq.put("lla", 492);
    freq.put("ros", 487);
    freq.put("rot", 255);
    freq.put("lle", 760);
    freq.put("ver", 481);
    freq.put("di ", 862);
    freq.put("ert", 284);
    freq.put("ro ", 2000);
    freq.put("os ", 2497);
    freq.put("ll ", 320);
    freq.put("din", 1025);
    freq.put("gui", 242);
    freq.put("ers", 877);
    freq.put("dia", 320);
    freq.put("gum", 355);
    freq.put("gul", 619);
    freq.put("gus", 319);
    freq.put("p", 56795);
    freq.put("Tag", 668);
    freq.put("diy", 230);
    freq.put("ve ", 253);
    freq.put("dit", 243);
    freq.put("He", 607);
    freq.put("der", 377);
    freq.put("dis", 689);
    freq.put("Rey", 251);
    freq.put("Rep", 257);
    freq.put("ery", 584);
    freq.put("Gre", 522);
    freq.put("Gri", 303);
    freq.put("Que", 246);
    freq.put("bo ", 562);
    freq.put("mp", 3371);
    freq.put("Me", 527);
    freq.put("Ma", 4128);
    freq.put("Mo", 519);
    freq.put("Mi", 786);
    freq.put("Mu", 386);
    freq.put("ngg", 1999);
    freq.put("or ", 1386);
    freq.put("eka", 275);
    freq.put("ngl", 2579);
    freq.put("bol", 310);
    freq.put("bon", 590);
    freq.put("ekt", 395);
    freq.put("eks", 315);
    freq.put("ipa", 894);
    freq.put("ngh", 357);
    freq.put("ipi", 5953);
    freq.put("ipo", 219);
    freq.put("ipp", 279);
    freq.put("ayo", 1284);
    freq.put("ayn", 676);
    freq.put("ngu", 1141);
    freq.put(" Ki", 335);
    freq.put("aya", 7316);
    freq.put(" Ko", 738);
    freq.put("ayb", 228);
    freq.put(" Kr", 232);
    freq.put(" Ku", 269);
    freq.put("ayu", 244);
    freq.put("ca ", 245);
    freq.put("ays", 426);
    freq.put("ayr", 437);
    freq.put("ip ", 377);
    freq.put("ngr", 246);
    freq.put("F", 1488);
    freq.put("oon", 4273);
    freq.put("ook", 406);
    freq.put("ibi", 852);
    freq.put("uly", 233);
    freq.put("ibl", 298);
    freq.put("ibo", 539);
    freq.put("iba", 1373);
    freq.put("ay ", 22870);
    freq.put("ult", 291);
    freq.put("ulu", 1033);
    freq.put("uli", 710);
    freq.put("can", 254);
    freq.put("ula", 6857);
    freq.put("obe", 281);
    freq.put("Min", 268);
    freq.put(" of", 748);
    freq.put("ma ", 1406);
    freq.put("spa", 238);
    freq.put(" or", 499);
    freq.put("spe", 263);
    freq.put(" op", 300);
    freq.put("nyo", 656);
    freq.put("s ", 20143);
    freq.put("map", 283);
    freq.put("mas", 904);
    freq.put("mar", 866);
    freq.put("mat", 2454);
    freq.put("ena", 338);
    freq.put("may", 4380);
    freq.put("aon", 1107);
    freq.put(" o ", 6532);
    freq.put("maa", 656);
    freq.put("mab", 485);
    freq.put("mad", 287);
    freq.put("mag", 1774);
    freq.put("mai", 353);
    freq.put("end", 702);
    freq.put("mak", 856);
    freq.put("mam", 1144);
    freq.put("mal", 1856);
    freq.put("man", 4514);
    freq.put("sy", 6204);
    freq.put("ss", 697);
    freq.put("sp", 948);
    freq.put("su", 2916);
    freq.put("st", 7061);
    freq.put("q", 542);
    freq.put("si", 9719);
    freq.put("sh", 1082);
    freq.put("so", 5456);
    freq.put("gha", 696);
    freq.put("sm", 643);
    freq.put("sl", 357);
    freq.put("sc", 415);
    freq.put("sa", 50153);
    freq.put("se", 6243);
    freq.put("no ", 3206);
    freq.put("Re", 1018);
    freq.put("Jam", 280);
    freq.put("Ra", 347);
    freq.put("Ro", 908);
    freq.put("Ri", 307);
    freq.put("gta", 876);
    freq.put(" ag", 287);
    freq.put(" ak", 588);
    freq.put(" al", 688);
    freq.put(" an", 11487);
    freq.put("gen", 305);
    freq.put(" ap", 351);
    freq.put(" ar", 1782);
    freq.put(" as", 396);
    freq.put(" at", 8491);
    freq.put(" aw", 224);
    freq.put(" ay", 15608);
    freq.put("nom", 260);
    freq.put("non", 1292);
    freq.put("noo", 3554);
    freq.put("nod", 444);
    freq.put("mba", 1424);
    freq.put("ng ", 107416);
    freq.put("nsy", 292);
    freq.put("gba", 311);
    freq.put("em", 2892);
    freq.put("el", 4423);
    freq.put("eo", 1328);
    freq.put("en", 9846);
    freq.put("ei", 449);
    freq.put("eh", 1900);
    freq.put("ek", 1455);
    freq.put("ee", 503);
    freq.put("ed", 1334);
    freq.put("eg", 2092);
    freq.put("ea", 1899);
    freq.put("ec", 685);
    freq.put("eb", 1161);
    freq.put("ey", 804);
    freq.put("ex", 243);
    freq.put("ez", 509);
    freq.put("eu", 223);
    freq.put("et", 2497);
    freq.put("ew", 354);
    freq.put("ev", 449);
    freq.put("ep", 1032);
    freq.put("es", 7771);
    freq.put("er", 9807);
    freq.put("Jos", 222);
    freq.put("bli", 613);
    freq.put("bla", 330);
    freq.put("G", 3274);
    freq.put("ory", 303);
    freq.put("ort", 603);
    freq.put("e ", 10545);
    freq.put("oro", 293);
    freq.put("orm", 244);
    freq.put("ork", 236);
    freq.put("ori", 875);
    freq.put("org", 297);
    freq.put("ord", 364);
    freq.put("ore", 565);
    freq.put("ora", 483);
    freq.put("Apr", 218);
    freq.put("yun", 445);
    freq.put("oni", 381);
    freq.put("ono", 505);
    freq.put("ona", 1108);
    freq.put("ong", 14203);
    freq.put("ond", 258);
    freq.put("one", 582);
    freq.put("ony", 253);
    freq.put("ons", 429);
    freq.put("ont", 363);
    freq.put("ial", 214);
    freq.put("ian", 1841);
    freq.put("uku", 387);
    freq.put("uko", 610);
    freq.put("uka", 453);
    freq.put("hul", 550);
    freq.put("hum", 213);
    freq.put("x ", 270);
    freq.put(" Za", 253);
    freq.put("wat", 242);
    freq.put("ia ", 1668);
    freq.put("r", 58943);
    freq.put("and", 2377);
    freq.put("ane", 370);
    freq.put("ang", 54220);
    freq.put("ana", 5631);
    freq.put("sam", 846);
    freq.put("anc", 342);
    freq.put("anl", 847);
    freq.put("sab", 432);
    freq.put("saa", 543);
    freq.put("ano", 2033);
    freq.put("sag", 340);
    freq.put("ani", 2704);
    freq.put("ant", 1925);
    freq.put("anu", 622);
    freq.put("say", 842);
    freq.put("ans", 2023);
    freq.put("sas", 644);
    freq.put("sar", 588);
    freq.put("sap", 373);
    freq.put("any", 1534);
    freq.put("Do", 225);
    freq.put("Phi", 298);
    freq.put("Di", 1582);
    freq.put("De", 356);
    freq.put("zon", 372);
    freq.put("Da", 1003);
    freq.put("gko", 362);
    freq.put("gka", 2797);
    freq.put("an ", 25875);
    freq.put("iwa", 1084);
    freq.put("sa ", 29066);
    freq.put("uya", 331);
    freq.put(" ye", 394);
    freq.put(" Le", 698);
    freq.put(" La", 1273);
    freq.put(" Lo", 362);
    freq.put(" Li", 486);
    freq.put(" Lu", 1602);
    freq.put("nlu", 471);
    freq.put("nla", 384);
    freq.put("ge ", 872);
    freq.put("ss ", 216);
    freq.put("ses", 480);
    freq.put("Wa", 226);
    freq.put("iti", 1834);
    freq.put("Wi", 302);
    freq.put("BN ", 257);
    freq.put(" pr", 891);
    freq.put(" pu", 1239);
    freq.put("H", 3508);
    freq.put(" pa", 17344);
    freq.put(" pe", 850);
    freq.put(" pi", 2508);
    freq.put(" po", 2264);
    freq.put("dya", 287);
    freq.put(" pl", 235);
    freq.put("ute", 297);
    freq.put("lum", 601);
    freq.put("uto", 373);
    freq.put("rma", 307);
    freq.put("oob", 454);
    freq.put("tur", 814);
    freq.put("tut", 349);
    freq.put("tuk", 407);
    freq.put("tul", 834);
    freq.put("tum", 594);
    freq.put("tun", 595);
    freq.put("tub", 614);
    freq.put("ja", 305);
    freq.put(" be", 279);
    freq.put(" ba", 6398);
    freq.put(" bl", 303);
    freq.put(" bo", 263);
    freq.put(" bi", 3286);
    freq.put(" bu", 1574);
    freq.put("s", 113569);
    freq.put("por", 477);
    freq.put("pos", 639);
    freq.put("pop", 1613);
    freq.put("pon", 910);
    freq.put("pol", 471);
    freq.put("mog", 636);
    freq.put("po ", 494);
    freq.put("mpe", 729);
    freq.put("ive", 465);
    freq.put("pap", 964);
    freq.put(" Me", 525);
    freq.put("par", 2056);
    freq.put("pas", 473);
    freq.put("pat", 1511);
    freq.put(" Ma", 4113);
    freq.put("pay", 244);
    freq.put(" Mo", 516);
    freq.put(" Mi", 784);
    freq.put(" Mu", 380);
    freq.put("pab", 282);
    freq.put("pag", 5944);
    freq.put("pah", 588);
    freq.put("I ", 336);
    freq.put("pak", 582);
    freq.put("pal", 1553);
    freq.put("pam", 2183);
    freq.put("pan", 7375);
    freq.put("I", 8185);
    freq.put("Mar", 952);
    freq.put("nag", 3410);
    freq.put("Is", 900);
    freq.put("Ir", 258);
    freq.put("It", 1478);
    freq.put("pa ", 793);
    freq.put("Ik", 390);
    freq.put("Im", 288);
    freq.put("Il", 402);
    freq.put("In", 3099);
    freq.put("\u4e00", 621);
    freq.put("am ", 867);
    freq.put("gda", 265);
    freq.put("gdi", 448);
    freq.put("nam", 1069);
    freq.put("tim", 775);
    freq.put("ot ", 787);
    freq.put("ami", 2241);
    freq.put("amo", 399);
    freq.put("ama", 6244);
    freq.put("amb", 1287);
    freq.put("ame", 660);
    freq.put("mot", 220);
    freq.put("mon", 703);
    freq.put("amp", 1054);
    freq.put("ib", 3763);
    freq.put("tig", 242);
    freq.put("Pil", 4628);
    freq.put("Pin", 243);
    freq.put("t", 84874);
    freq.put("Man", 377);
    freq.put("sen", 3264);
    freq.put("New", 234);
    freq.put(" co", 595);
    freq.put(" ca", 215);
    freq.put("o ", 35938);
    freq.put("oo", 5633);
    freq.put("on", 28949);
    freq.put("aca", 217);
    freq.put("ol", 5417);
    freq.put("ok", 1666);
    freq.put("oi", 423);
    freq.put("oh", 829);
    freq.put("og", 2491);
    freq.put("of", 922);
    freq.put("od", 3388);
    freq.put("oc", 711);
    freq.put("ob", 1692);
    freq.put("oa", 467);
    freq.put("ngo", 322);
    freq.put("oy", 1082);
    freq.put("ow", 489);
    freq.put("ov", 562);
    freq.put("ou", 1121);
    freq.put("ot", 1896);
    freq.put("os", 4877);
    freq.put("or", 6366);
    freq.put("op", 3555);
    freq.put("Ni", 284);
    freq.put("No", 859);
    freq.put("Na", 1605);
    freq.put("Ne", 669);
    freq.put("Adi", 220);
    freq.put("log", 979);
    freq.put("her", 391);
    freq.put("loh", 474);
    freq.put("lon", 1346);
    freq.put("loo", 506);
    freq.put("lor", 222);
    freq.put("los", 411);
    freq.put("hen", 301);
    freq.put("ehi", 1394);
    freq.put("N ", 411);
    freq.put("J", 1743);
    freq.put("na ", 22155);
    freq.put("Ab", 447);
    freq.put("e", 64572);
    freq.put(" su", 1227);
    freq.put("lo ", 1738);
    freq.put("Ag", 601);
    freq.put("as ", 8041);
    freq.put("he ", 726);
    freq.put("wak", 321);
    freq.put("aa", 5389);
    freq.put("ac", 1440);
    freq.put("Est", 484);
    freq.put("ae", 824);
    freq.put("ad", 5449);
    freq.put("ag", 22898);
    freq.put("ai", 3152);
    freq.put("ah", 9461);
    freq.put("ak", 11317);
    freq.put("am", 13495);
    freq.put("al", 29791);
    freq.put("ao", 3807);
    freq.put("an", 101085);
    freq.put("ap", 8378);
    freq.put("as", 20781);
    freq.put("ar", 16773);
    freq.put("au", 1712);
    freq.put("at", 29146);
    freq.put("aw", 10001);
    freq.put("av", 702);
    freq.put("ay", 33855);
    freq.put("az", 285);
    freq.put("yon", 8581);
    freq.put("ige", 351);
    freq.put("igd", 340);
    freq.put("iga", 3450);
    freq.put("Lat", 224);
    freq.put("igm", 226);
    freq.put("yos", 430);
    freq.put("igi", 608);
    freq.put("a ", 94136);
    freq.put("at ", 11450);
    freq.put("yo ", 2106);
    freq.put("u", 56864);
    freq.put("ig ", 1084);
    freq.put("alo", 1422);
    freq.put("all", 403);
    freq.put("alm", 256);
    freq.put("ali", 4268);
    freq.put("ale", 940);
    freq.put("alb", 295);
    freq.put("ala", 15201);
    freq.put("gt", 1399);
    freq.put("aly", 681);
    freq.put("gs", 3014);
    freq.put("alu", 885);
    freq.put("Fil", 231);
    freq.put("gr", 1126);
    freq.put("smo", 455);
    freq.put("ty", 936);
    freq.put("tw", 245);
    freq.put("tt", 423);
    freq.put("tu", 5349);
    freq.put("tr", 2947);
    freq.put("ts", 639);
    freq.put("tn", 494);
    freq.put("to", 12113);
    freq.put("tl", 670);
    freq.put("th", 1499);
    freq.put("ti", 12280);
    freq.put("te", 5598);
    freq.put("ta", 23206);
    freq.put("edi", 305);
    freq.put("mpa", 1165);
    freq.put("mpo", 376);
    freq.put("al ", 4667);
    freq.put("mpi", 405);
    freq.put("mpu", 307);
    freq.put("gy", 549);
    freq.put("ius", 321);
    freq.put("uwe", 288);
    freq.put(" Ni", 283);
    freq.put("gg", 2300);
    freq.put("pre", 283);
    freq.put("ro", 6522);
    freq.put(" No", 856);
    freq.put(" Na", 1601);
    freq.put(" Ne", 660);
    freq.put("ge", 1642);
    freq.put("rk", 708);
    freq.put("t ", 17794);
    freq.put("gb", 804);
    freq.put("tel", 392);
    freq.put("ga", 29192);
    freq.put("ten", 352);
    freq.put("pun", 775);
    freq.put("osa", 225);
    freq.put("ter", 1925);
    freq.put("tes", 226);
    freq.put("aba", 5223);
    freq.put("gl", 3792);
    freq.put("abe", 285);
    freq.put("abi", 1848);
    freq.put("sum", 409);
    freq.put(" Ag", 601);
    freq.put("suk", 222);
    freq.put("abo", 410);
    freq.put("sus", 423);
    freq.put("abu", 558);
    freq.put("te ", 1421);
    freq.put("K", 5752);
    freq.put("pua", 1158);
    freq.put(" re", 1237);
    freq.put("gga", 1607);
    freq.put("pub", 334);
    freq.put(" ri", 835);
    freq.put("Su\u0308d", 214);
    freq.put(" wi", 495);
    freq.put(" Ar", 684);
    freq.put("nto", 1170);
    freq.put("Nob", 295);
    freq.put("Uni", 749);
    freq.put("S ", 239);
    freq.put("asi", 1053);
    freq.put("eyn", 227);
    freq.put("de ", 630);
    freq.put("Su", 844);
    freq.put("St", 601);
    freq.put("Si", 3949);
    freq.put("Sh", 296);
    freq.put("So", 479);
    freq.put("Sc", 225);
    freq.put("Sa", 2369);
    freq.put("Se", 751);
    freq.put("a\u0301", 213);
    freq.put("ey ", 259);
    freq.put("kla", 2111);
    freq.put(" di", 1938);
    freq.put(" de", 1318);
    freq.put("des", 307);
    freq.put(" da", 2205);
    freq.put("dek", 245);
    freq.put("del", 555);
    freq.put("den", 404);
    freq.put("v", 3263);
    freq.put("Ind", 341);
    freq.put(" du", 359);
    freq.put("Ing", 2213);
    freq.put("f ", 892);
    freq.put("lal", 5124);
    freq.put("ati", 3674);
    freq.put("ryo", 1185);
    freq.put("Al", 957);
    freq.put("rya", 408);
    freq.put("atu", 1238);
    freq.put("Su\u0308", 216);
    freq.put("fa", 228);
    freq.put("fe", 234);
    freq.put("fi", 306);
    freq.put("fo", 309);
    freq.put("a", 433329);
    freq.put("ry ", 568);
    freq.put("ne ", 832);
    freq.put("ego", 798);
    freq.put("ega", 369);
    freq.put("ege", 495);
    freq.put("oy ", 861);
    freq.put("itn", 327);
    freq.put("ito", 5794);
    freq.put("ce ", 518);
    freq.put("y ", 26266);
    freq.put("ite", 522);
    freq.put("ita", 2453);
    freq.put("ok ", 961);
    freq.put("ity", 376);
    freq.put("itu", 365);
    freq.put(" Ol", 245);
    freq.put(" Ok", 212);
    freq.put("paa", 836);
    freq.put(" Or", 329);
    freq.put("Bat", 317);
    freq.put("yo", 11759);
    freq.put("yn", 980);
    freq.put("ya", 16851);
    freq.put("yb", 251);
    freq.put("ye", 2458);
    freq.put("L", 4772);
    freq.put("it ", 3154);
    freq.put("Bay", 1488);
    freq.put("Bag", 274);
    freq.put("Ban", 328);
    freq.put("ys", 635);
    freq.put("yr", 507);
    freq.put("yu", 966);
    freq.put("yt", 264);
    freq.put("yni", 658);
    freq.put("yna", 235);
    freq.put("dig", 691);
    freq.put("Ene", 272);
    freq.put("Eng", 311);
    freq.put("gun", 828);
    freq.put(" si", 4160);
    freq.put(" so", 365);
    freq.put(" sa", 28976);
    freq.put(" se", 2207);
    freq.put("pul", 2278);
    freq.put(" Ab", 444);
    freq.put(" Ad", 338);
    freq.put("asu", 540);
    freq.put("ast", 1119);
    freq.put("mmu", 273);
    freq.put("asy", 2814);
    freq.put(" Ak", 280);
    freq.put(" Al", 957);
    freq.put(" Am", 732);
    freq.put(" An", 10945);
    freq.put(" Ap", 381);
    freq.put("asa", 4127);
    freq.put(" As", 625);
    freq.put(" Au", 300);
    freq.put("ase", 1923);
    freq.put("put", 222);
    freq.put(" Ay", 1524);
    freq.put(" s ", 272);
    freq.put("aso", 401);
    freq.put("Em", 287);
    freq.put("En", 687);
    freq.put("omp", 399);
    freq.put("kon", 1105);
    freq.put("lyo", 437);
    freq.put("w", 15439);
    freq.put("Eu", 252);
    freq.put("Es", 754);
    freq.put("Imp", 228);
    freq.put(" el", 218);
    freq.put(" em", 253);
    freq.put("kom", 504);
    freq.put("kol", 972);
    freq.put(" ek", 212);
    freq.put("Hu", 700);
    freq.put("gpa", 814);
    freq.put("koy", 367);
    freq.put("kop", 294);
    freq.put(" es", 477);
    freq.put("gpu", 1231);
    freq.put("nce", 344);
    freq.put("ste", 723);
    freq.put("dti", 217);
    freq.put("b", 36938);
    freq.put("aaa", 370);
    freq.put("sta", 2233);
    freq.put("aal", 228);
    freq.put("aan", 2340);
    freq.put("sti", 1338);
    freq.put("aas", 476);
    freq.put("aar", 1310);
    freq.put("ka ", 4085);
    freq.put("lid", 294);
    freq.put("k ", 4018);
    freq.put(" la", 4719);
    freq.put("lib", 291);
    freq.put("lic", 224);
    freq.put("lil", 346);
    freq.put("lim", 971);
    freq.put("lin", 1820);
    freq.put("lih", 227);
    freq.put("lii", 293);
    freq.put("lik", 1738);
    freq.put("lit", 1575);
    freq.put("lip", 5499);
    freq.put("lis", 938);
    freq.put("liy", 225);
    freq.put("kab", 2686);
    freq.put("kaa", 306);
    freq.put("kag", 306);
    freq.put("kad", 618);
    freq.put("kak", 1114);
    freq.put("kai", 697);
    freq.put("kah", 780);
    freq.put("M", 7066);
    freq.put("kan", 3294);
    freq.put("kam", 987);
    freq.put("kal", 2502);
    freq.put("kas", 2326);
    freq.put("kar", 1361);
    freq.put("kap", 1524);
    freq.put("kau", 481);
    freq.put("kat", 4082);
    freq.put("Isa", 506);
    freq.put("kb", 240);
    freq.put("ka", 28062);
    freq.put("li ", 620);
    freq.put("ke", 653);
    freq.put("ki", 5108);
    freq.put("kh", 660);
    freq.put("ko", 5455);
    freq.put("kl", 2445);
    freq.put("ks", 1102);
    freq.put("kr", 397);
    freq.put("ku", 3832);
    freq.put("kt", 1232);
    freq.put("ky", 234);
    freq.put("rte", 436);
    freq.put("ugn", 288);
    freq.put("uga", 1124);
    freq.put("rti", 1012);
    freq.put("hi ", 256);
    freq.put("Hap", 403);
    freq.put("Ju", 288);
    freq.put("Jo", 504);
    freq.put("ien", 313);
    freq.put("Ja", 583);
    freq.put("hip", 233);
    freq.put("hit", 252);
    freq.put("hiy", 1822);
    freq.put("hig", 262);
    freq.put("hil", 1124);
    freq.put("him", 317);
    freq.put("hin", 2102);
    freq.put("ko ", 1504);
    freq.put("x", 703);
    freq.put(" Be", 553);
    freq.put("Ago", 307);
    freq.put("ars", 347);
    freq.put(" Ba", 3213);
    freq.put("ser", 748);
    freq.put("ary", 1252);
    freq.put(" Bo", 624);
    freq.put(" Bi", 731);
    freq.put(" Bu", 508);
    freq.put("ara", 6094);
    freq.put("arc", 218);
    freq.put("ard", 406);
    freq.put("are", 434);
    freq.put(" Br", 411);
    freq.put("ari", 2740);
    freq.put("ark", 258);
    freq.put("arl", 281);
    freq.put("aro", 928);
    freq.put("mo ", 604);
    freq.put("iks", 322);
    freq.put("str", 1197);
    freq.put("iku", 803);
    freq.put("ue ", 245);
    freq.put("ar ", 1507);
    freq.put("ika", 5845);
    freq.put("se ", 703);
    freq.put("iki", 665);
    freq.put("iko", 1955);
    freq.put(" Pr", 781);
    freq.put("c", 9968);
    freq.put(" Pu", 319);
    freq.put(" Pa", 3220);
    freq.put(" Pe", 751);
    freq.put(" Pi", 5194);
    freq.put(" Ph", 516);
    freq.put(" Po", 510);
    freq.put("ga ", 10893);
    freq.put("pr", 1443);
    freq.put("pp", 386);
    freq.put("duk", 249);
    freq.put("dul", 227);
    freq.put("pt", 257);
    freq.put("pu", 5533);
    freq.put("py", 238);
    freq.put("pa", 25955);
    freq.put("nau", 287);
    freq.put("pe", 2826);
    freq.put("ph", 416);
    freq.put("pi", 11096);
    freq.put("po", 5042);
    freq.put("pl", 758);
    freq.put("gay", 1184);
    freq.put("gaw", 951);
    freq.put(" tu", 1581);
    freq.put("gat", 1029);
    freq.put("gas", 721);
    freq.put(" tr", 542);
    freq.put("N", 4375);
    freq.put("gan", 8911);
    freq.put("gam", 1160);
    freq.put("gal", 2016);
    freq.put(" ti", 1513);
    freq.put("gah", 212);
    freq.put("gag", 358);
    freq.put(" te", 623);
    freq.put(" ta", 3807);
    freq.put("iye", 538);
    freq.put("sak", 534);
    freq.put("iya", 3692);
    freq.put("iyo", 1973);
    freq.put("tip", 230);
    freq.put("p ", 2357);
    freq.put("riy", 449);
    freq.put("rit", 895);
    freq.put("ris", 641);
    freq.put("rin", 2120);
    freq.put("Tim", 465);
    freq.put("Tin", 234);
    freq.put("rik", 932);
    freq.put("rig", 228);
    freq.put("rie", 322);
    freq.put("ric", 296);
    freq.put("ria", 1493);
    freq.put("sya", 1319);
    freq.put("tis", 888);
    freq.put("sye", 492);
    freq.put("Ilo", 317);
    freq.put("syo", 3972);
    freq.put("lig", 604);
    freq.put("syu", 310);
    freq.put("Com", 233);
    freq.put("Col", 584);
    freq.put("ri ", 1883);
    freq.put("lia", 495);
    freq.put("gsu", 217);
    freq.put("gsa", 661);
    freq.put("gsi", 395);
    freq.put("do ", 1342);
    freq.put("gso", 1676);
    freq.put("wig", 2597);
    freq.put("bi ", 266);
    freq.put("ohi", 487);
    freq.put("amu", 411);
    freq.put("rga", 250);
    freq.put("sal", 1402);
    freq.put("bin", 1170);
    freq.put("bil", 2673);
    freq.put("Ol", 246);
    freq.put("Ok", 212);
    freq.put("big", 1028);
    freq.put("bid", 220);
    freq.put("bib", 346);
    freq.put("bit", 236);
    freq.put("bis", 856);
    freq.put("Dis", 592);
    freq.put("d", 29955);
    freq.put("wit", 490);
    freq.put("b ", 919);
    freq.put("gp", 2172);
    freq.put(" Qu", 347);
    freq.put("per", 1160);
    freq.put("pel", 619);
    freq.put("id ", 624);
    freq.put("be", 1655);
    freq.put("ba", 16262);
    freq.put("bl", 1265);
    freq.put("bo", 2508);
    freq.put("bi", 7420);
    freq.put("O", 1801);
    freq.put("bu", 3483);
    freq.put(" Ka", 3625);
    freq.put("br", 2325);
    freq.put("rus", 239);
    freq.put("rup", 247);
    freq.put("by", 545);
    freq.put("Rom", 461);
    freq.put("ido", 754);
    freq.put("ide", 429);
    freq.put("ida", 693);
    freq.put("nsi", 398);
    freq.put("nso", 1561);
    freq.put("nsa", 1639);
    freq.put(" up", 417);
    freq.put("nse", 338);
    freq.put(" ur", 1186);
    freq.put(" um", 236);
    freq.put(" un", 787);
    freq.put("nst", 288);
    freq.put("kay", 687);
    freq.put("u ", 1011);
    freq.put(" Ch", 477);
    freq.put(" Co", 1435);
    freq.put("ns ", 315);
    freq.put(" Ca", 1275);
    freq.put(" Ce", 318);
    freq.put("cia", 252);
    freq.put("uta", 417);
    freq.put("uy", 540);
    freq.put("uz", 222);
    freq.put("uu", 278);
    freq.put("ut", 2718);
    freq.put("uw", 938);
    freq.put("uti", 335);
    freq.put("up", 1559);
    freq.put("us", 3997);
    freq.put("ur", 4663);
    freq.put("um", 4571);
    freq.put("ul", 10829);
    freq.put("uo", 841);
    freq.put("un", 11124);
    freq.put("ui", 867);
    freq.put("uh", 1222);
    freq.put("uk", 2223);
    freq.put("utu", 829);
    freq.put("ue", 1048);
    freq.put("ud", 744);
    freq.put("ug", 2281);
    freq.put("z", 2158);
    freq.put("ua", 2314);
    freq.put("uc", 353);
    freq.put("ub", 2276);
    freq.put("Tu", 257);
    freq.put("Tr", 725);
    freq.put("Ts", 305);
    freq.put("To", 291);
    freq.put("lya", 1073);
    freq.put("Th", 568);
    freq.put("Ti", 1025);
    freq.put("Te", 370);
    freq.put("Ta", 1438);
    freq.put("nab", 490);
    freq.put("A ", 369);
    freq.put(" gu", 642);
    freq.put(" gr", 273);
    freq.put("Mat", 220);
    freq.put("nad", 394);
    freq.put("May", 1105);
    freq.put("nak", 3214);
    freq.put("nah", 1201);
    freq.put("nai", 343);
    freq.put("nan", 5284);
    freq.put("nao", 281);
    freq.put("nal", 1987);
    freq.put("ag ", 2962);
    freq.put("nar", 667);
    freq.put("nas", 5521);
    freq.put("nap", 1249);
    freq.put("gre", 308);
    freq.put("naw", 416);
    freq.put("nat", 2025);
    freq.put("gra", 396);
    freq.put("nay", 628);
    freq.put("Mal", 287);
    freq.put(" gi", 1221);
    freq.put("ago", 873);
    freq.put("agm", 409);
    freq.put("agl", 815);
    freq.put("agk", 1800);
    freq.put("Ad", 339);
    freq.put("agi", 2389);
    freq.put("agh", 599);
    freq.put("agg", 261);
    freq.put("Ak", 282);
    freq.put("agd", 421);
    freq.put("Am", 736);
    freq.put("agb", 737);
    freq.put("aga", 6180);
    freq.put("An", 10961);
    freq.put("Ap", 381);
    freq.put("As", 627);
    freq.put("Ar", 695);
    freq.put("Au", 300);
    freq.put("Ay", 1525);
    freq.put("agu", 765);
    freq.put("agt", 890);
    freq.put("ags", 1175);
    freq.put("agp", 2086);
    freq.put(" b", 12249);
    freq.put(" c", 1285);
    freq.put("gu", 3141);
    freq.put(" a", 41230);
    freq.put(" f", 514);
    freq.put(" g", 3652);
    freq.put(" d", 6208);
    freq.put(" e", 1886);
    freq.put(" k", 20018);
    freq.put(" h", 4923);
    freq.put(" i", 23816);
    freq.put(" n", 63523);
    freq.put(" o", 8411);
    freq.put(" l", 8609);
    freq.put(" m", 26008);
    freq.put(" r", 2505);
    freq.put(" s", 37805);
    freq.put(" p", 25524);
    freq.put("gd", 846);
    freq.put(" v", 245);
    freq.put(" w", 1107);
    freq.put(" t", 9124);
    freq.put(" u", 3275);
    freq.put("go", 3120);
    freq.put("gn", 612);
    freq.put("gm", 735);
    freq.put(" y", 708);
    freq.put("gk", 3515);
    freq.put("gi", 5586);
    freq.put("gh", 1271);
    freq.put(" B", 6692);
    freq.put(" C", 4389);
    freq.put(" A", 18851);
    freq.put(" F", 1372);
    freq.put(" G", 3134);
    freq.put(" D", 3532);
    freq.put(" E", 3171);
    freq.put(" J", 1713);
    freq.put(" K", 5573);
    freq.put(" H", 3377);
    freq.put(" I", 7706);
    freq.put(" N", 3834);
    freq.put(" O", 1616);
    freq.put(" L", 4623);
    freq.put(" M", 6813);
    freq.put(" R", 2927);
    freq.put(" S", 10261);
    freq.put(" P", 11641);
    freq.put(" Q", 408);
    freq.put(" V", 1041);
    freq.put(" W", 933);
    freq.put(" T", 5149);
    freq.put(" U", 1379);
    freq.put(" Z", 430);
    freq.put(" X", 260);
    freq.put(" Y", 427);
    freq.put("Nor", 372);
    freq.put("ed ", 364);
    freq.put("P", 11919);
    freq.put("g ", 113439);
    freq.put("tri", 838);
    freq.put("tro", 879);
    freq.put("tra", 868);
    freq.put("us ", 1413);
    freq.put("le ", 657);
    freq.put("zo", 453);
    freq.put("za", 466);
    freq.put("ibe", 241);
    freq.put("uez", 255);
    freq.put("ode", 251);
    freq.put("rd ", 279);
    freq.put("ulo", 1229);
    freq.put("lea", 415);
    freq.put("leg", 553);
    freq.put("leh", 645);
    freq.put("z ", 468);
    freq.put("lem", 360);
    freq.put("len", 771);
    freq.put("les", 2603);
    freq.put("od ", 2512);
    freq.put("cti", 321);
    freq.put(" Do", 218);
    freq.put(" Di", 1559);
    freq.put(" De", 354);
    freq.put("wik", 476);
    freq.put(" Da", 1001);
    freq.put("apu", 525);
    freq.put("api", 926);
    freq.put("apo", 968);
    freq.put("apa", 4168);
    freq.put("cha", 297);
    freq.put("Fr", 271);
    freq.put("che", 214);
    freq.put("usa", 537);
    freq.put("Hul", 231);
    freq.put("ao ", 2560);
    freq.put("usi", 309);
    freq.put("The", 357);
    freq.put("usu", 363);
    freq.put("ust", 456);
    freq.put("Fe", 231);
    freq.put("Fi", 327);
    freq.put("usy", 243);
    freq.put("iit", 294);
    freq.put("om", 3049);
    freq.put("ap ", 1248);
    freq.put("ch ", 248);
    freq.put("f", 2669);
    freq.put(" Re", 1013);
    freq.put(" Ra", 342);
    freq.put(" Ro", 902);
    freq.put(" Ri", 307);
    freq.put("tat", 2169);
    freq.put("taw", 1462);
    freq.put("tap", 454);
    freq.put("tar", 426);
    freq.put("tas", 1294);
    freq.put("tay", 910);
    freq.put("tad", 729);
    freq.put("tag", 2356);
    freq.put("taa", 516);
    freq.put("tab", 313);
    freq.put("tal", 1825);
    freq.put("tam", 283);
    freq.put("tan", 3973);
    freq.put("tao", 2928);
    freq.put("tak", 378);
    freq.put("sis", 871);
    freq.put("sip", 588);
    freq.put("sit", 454);
    freq.put("siy", 1352);
    freq.put("sia", 279);
    freq.put("sig", 229);
    freq.put("sid", 252);
    freq.put("sik", 667);
    freq.put("sin", 2020);
    freq.put("sim", 530);
    freq.put("sil", 886);
    freq.put("Q", 420);
    freq.put("ta ", 2620);
    freq.put("si ", 909);
    freq.put("Ayo", 1506);
    freq.put("da ", 1215);
    freq.put("ld", 536);
    freq.put("le", 7298);
    freq.put("lb", 521);
    freq.put("la", 41710);
    freq.put("lo", 7059);
    freq.put("ll", 2040);
    freq.put("lm", 376);
    freq.put("li", 16771);
    freq.put("lt", 766);
    freq.put("lu", 4808);
    freq.put("ls", 232);
    freq.put("lp", 216);
    freq.put("bye", 332);
    freq.put("ly", 1884);
    freq.put("dad", 487);
    freq.put("dag", 294);
    freq.put("daa", 229);
    freq.put("dal", 1278);
    freq.put("Car", 262);
    freq.put("dan", 716);
    freq.put("dah", 789);
    freq.put("dai", 337);
    freq.put("dat", 526);
    freq.put("dar", 615);
    freq.put("ema", 617);
    freq.put("nya", 1473);
    freq.put("Pra", 302);
    freq.put("San", 795);
    freq.put("l ", 8749);
    freq.put("Sal", 320);
    freq.put("Pro", 250);
    freq.put(" hu", 502);
    freq.put(" hi", 1628);
    freq.put(" ha", 2342);
    freq.put(" he", 266);
    freq.put("oun", 298);
    freq.put("rer", 338);
    freq.put("res", 909);
    freq.put("reh", 760);
    freq.put("ren", 823);
    freq.put("rel", 229);
    freq.put("rea", 358);
    freq.put("reg", 609);
    freq.put("u\u0308dt", 214);
    freq.put("g", 178562);
    freq.put("uha", 936);
    freq.put("re ", 1785);
    freq.put("lto", 257);
    freq.put("u\u0308", 252);
    freq.put("rs ", 234);
    freq.put("ihi", 488);
    freq.put("mah", 1161);
    freq.put("art", 1318);
    freq.put("iha", 656);
    freq.put("og ", 1738);
    freq.put(" St", 567);
    freq.put(" Su", 840);
    freq.put(" Sh", 292);
    freq.put(" Si", 3946);
    freq.put(" So", 478);
    freq.put(" Sc", 224);
    freq.put(" Sa", 2358);
    freq.put(" Se", 748);
    freq.put("Ka", 3627);
    freq.put("rso", 362);
    freq.put("rsi", 370);
    freq.put("Ki", 336);
    freq.put("Ko", 739);
    freq.put("ogr", 242);
    freq.put("Kr", 232);
    freq.put("R", 3177);
    freq.put("Ku", 269);
    freq.put("bel", 279);
    freq.put("ik ", 530);
    freq.put("ber", 655);
    freq.put("Par", 288);
    freq.put("Pas", 236);
    freq.put("Pag", 236);
    freq.put("Pal", 436);
    freq.put("Pam", 480);
    freq.put("Pan", 1029);
    freq.put("aw ", 1870);
    freq.put("sk", 592);
    freq.put("mik", 544);
    freq.put("ur ", 441);
    freq.put("ck ", 232);
    freq.put(" Su\u0308", 216);
    freq.put("min", 1128);
    freq.put("mis", 408);
    freq.put("mit", 1305);
    freq.put(" Em", 287);
    freq.put(" En", 683);
    freq.put("awi", 3261);
    freq.put("st ", 395);
    freq.put(" Eu", 251);
    freq.put("awa", 4711);
    freq.put(" Es", 753);
    freq.put("ure", 277);
    freq.put("mus", 340);
    freq.put("uro", 457);
    freq.put("uri", 1726);
    freq.put("hn", 275);
    freq.put("ho", 2024);
    freq.put("ksy", 373);
    freq.put("nge", 218);
    freq.put("ha", 12797);
    freq.put("nga", 5141);
    freq.put("iri", 318);
    freq.put(" ip", 821);
    freq.put(" is", 12317);
    freq.put(" it", 4118);
    freq.put("ngi", 702);
    freq.put("ngk", 1509);
    freq.put("sh ", 511);
    freq.put("ae ", 378);
    freq.put(" ik", 2724);
    freq.put(" il", 559);
    freq.put(" im", 295);
    freq.put(" in", 1205);
    freq.put("ngs", 1763);
    freq.put(" ib", 1270);
    freq.put("ksi", 218);
    freq.put("mga", 9380);
    freq.put("mul", 2510);
    freq.put("qu", 482);
    freq.put(" wa", 403);
    freq.put("h", 28813);
    freq.put("gbi", 301);
    freq.put("shi", 267);
    freq.put("Pr", 784);
    freq.put("Pu", 319);
    freq.put("C", 4965);
    freq.put("Pa", 3232);
    freq.put("ebr", 372);
    freq.put("Pe", 753);
    freq.put("Ph", 519);
    freq.put("Pi", 5199);
    freq.put("Po", 515);
    freq.put("lup", 252);
    freq.put("lur", 429);
    freq.put("lus", 323);
    freq.put("lut", 234);
    freq.put("ome", 348);
    freq.put("\u0627", 230);
    freq.put("et ", 365);
    freq.put("lug", 603);
    freq.put("luk", 293);
    freq.put("omi", 484);
    freq.put("lun", 1075);
    freq.put(" aa", 479);
    freq.put("omo", 218);
    freq.put("S", 10977);
    freq.put("omm", 343);
    freq.put("etr", 240);
    freq.put("Zam", 212);
    freq.put("ety", 252);
    freq.put("eta", 377);
    freq.put(" Il", 402);
    freq.put("eti", 227);
    freq.put("tlo", 414);
    freq.put("eto", 217);
    freq.put("ck", 419);
    freq.put("ci", 1114);
    freq.put("ch", 1408);
    freq.put("co", 1527);
    freq.put("cc", 244);
    freq.put("ca", 1369);
    freq.put("ce", 1134);
    freq.put("ab", 8765);
    freq.put("cr", 267);
    freq.put("cu", 348);
    freq.put("ct", 832);
    freq.put("yar", 349);
    freq.put("yal", 500);
    freq.put("yan", 8889);
    freq.put("yag", 346);
    freq.put("oto", 243);
    freq.put("ota", 234);
    freq.put("c ", 679);
    freq.put("uin", 299);
    freq.put("unu", 378);
    freq.put("Ang", 10467);
    freq.put("e\u0301", 238);
    freq.put("ysa", 370);
    freq.put("uny", 224);
    freq.put("ya ", 5481);
    freq.put("va", 717);
    freq.put(" Fr", 268);
    freq.put("ve", 1065);
    freq.put("vi", 929);
    freq.put("vo", 293);
    freq.put(" Fe", 229);
    freq.put("avi", 292);
    freq.put(" Fi", 324);
    freq.put("io ", 525);
    freq.put("of ", 743);
    freq.put("pis", 517);
    freq.put("dam", 364);
    freq.put("ion", 1384);
    freq.put("Sa ", 539);
    freq.put("i", 161924);
    freq.put(" Tu", 256);
    freq.put(" Ts", 304);
    freq.put(" Tr", 725);
    freq.put(" To", 289);
    freq.put(" Ti", 1025);
    freq.put(" Th", 565);
    freq.put(" Te", 369);
    freq.put("uno", 1281);
    freq.put(" Ta", 1427);
    freq.put("BC", 219);
    freq.put("BN", 257);
    freq.put("Be", 555);
    freq.put("Ba", 3221);
    freq.put("gma", 404);
    freq.put("Bo", 628);
    freq.put("Bi", 744);
    freq.put("Bu", 508);
    freq.put("ade", 215);
    freq.put("Br", 412);
    freq.put("ada", 1065);
    freq.put("ado", 1685);
    freq.put("gmu", 288);
    freq.put("adi", 344);
    freq.put("T", 5401);
    freq.put("Sam", 277);
    freq.put("ad ", 1547);
    freq.put("roo", 656);
    freq.put("Sur", 412);
    freq.put("est", 873);
    freq.put("ess", 243);
    freq.put("esp", 220);
    freq.put("nd ", 696);
    freq.put("esy", 238);
    freq.put("eso", 216);
    freq.put(" t ", 331);
    freq.put("esi", 397);
    freq.put("Un", 1045);
    freq.put("ndi", 1104);
    freq.put("ndo", 855);
    freq.put("nda", 2122);
    freq.put("nde", 357);
    freq.put("es ", 4679);
    freq.put("ndu", 336);
    freq.put("ea ", 269);
    freq.put("h ", 1453);
    freq.put("ubo", 309);
    freq.put("yro", 432);
    freq.put("Ame", 579);
    freq.put("hy", 251);
    freq.put("ean", 218);
    freq.put("hr", 229);
    freq.put("but", 324);
    freq.put("hu", 1485);
    freq.put("buh", 438);
    freq.put("hi", 7425);
    freq.put("bun", 360);
    freq.put("buo", 641);
    freq.put("bul", 259);
    freq.put("bum", 222);
    freq.put("eap", 318);
    freq.put("ear", 435);
    freq.put("he", 2166);
    freq.put("va ", 222);
    freq.put("j", 824);
    freq.put("pik", 487);
    freq.put("pil", 381);
    freq.put("pin", 8127);
    freq.put("int", 735);
    freq.put("inu", 1256);
    freq.put("ins", 494);
    freq.put("ino", 1637);
    freq.put("ini", 1991);
    freq.put("ind", 1253);
    freq.put("ine", 925);
    freq.put("ing", 7215);
    freq.put("pit", 481);
    freq.put("ina", 12544);
    freq.put("Or", 329);
    freq.put("wal", 851);
    freq.put("eo ", 676);
    freq.put(" Un", 1043);
    freq.put("Lun", 1069);
    freq.put("ubu", 535);
    freq.put("ubr", 217);
    freq.put("pi ", 308);
    freq.put("gar", 389);
    freq.put("U", 1449);
    freq.put("uba", 263);
    freq.put("ubl", 385);
    freq.put("gap", 698);
    freq.put("in ", 3710);
    freq.put("ubi", 307);
  }
  
}

