package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class SV extends CLangProfile {
  private static final String name = "sv";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public SV() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 31862602;
    n_words[1] = 36956776;
    n_words[2] = 26222440;

    freq.put(" ka\u0308", 11926);
    freq.put(" ko\u0308", 4010);
    freq.put("sch", 5874);
    freq.put("aug", 8539);
    freq.put("xte", 5064);
    freq.put("aur", 3255);
    freq.put("pte", 14474);
    freq.put(" Gu", 8675);
    freq.put(" Gr", 10670);
    freq.put("Joh", 8659);
    freq.put(" Ge", 7551);
    freq.put(" Ga", 6575);
    freq.put(" Go", 5001);
    freq.put("to\u0308r", 12969);
    freq.put("Gu", 8716);
    freq.put("Gr", 10737);
    freq.put("sjo\u0308", 6673);
    freq.put("Ge", 7613);
    freq.put("Ga", 6615);
    freq.put("Go", 5035);
    freq.put("Ca", 15038);
    freq.put("sja\u0308", 3770);
    freq.put(" ka", 33444);
    freq.put("me ", 3701);
    freq.put(" ke", 3269);
    freq.put(" ki", 4333);
    freq.put(" ko", 48113);
    freq.put(" kl", 6892);
    freq.put(" km", 5693);
    freq.put(" kr", 12841);
    freq.put(" kv", 5049);
    freq.put(" ku", 9406);
    freq.put(" ky", 7530);
    freq.put("nen", 21817);
    freq.put("nel", 8830);
    freq.put("neh", 3788);
    freq.put("ned", 3616);
    freq.put("neb", 3747);
    freq.put("mne", 9027);
    freq.put("kun", 6039);
    freq.put("ain", 4963);
    freq.put("net", 14471);
    freq.put("ner", 30394);
    freq.put("nes", 10240);
    freq.put("sli", 3748);
    freq.put(" Go\u0308", 6518);
    freq.put("med", 67946);
    freq.put("orr", 11303);
    freq.put("men", 33082);
    freq.put("lss", 5166);
    freq.put("ors", 16477);
    freq.put("met", 18659);
    freq.put("mes", 8746);
    freq.put("mer", 42686);
    freq.put("Go\u0308", 6526);
    freq.put("a\u0308pp", 6344);
    freq.put("gla", 6605);
    freq.put("k", 981769);
    freq.put("roc", 6434);
    freq.put("ne ", 14860);
    freq.put("akt", 15324);
    freq.put("dri", 7974);
    freq.put("orm", 13532);
    freq.put("dro", 7925);
    freq.put("dra", 24350);
    freq.put("aka", 4483);
    freq.put(" yt", 3626);
    freq.put("ake", 4072);
    freq.put("sso", 16553);
    freq.put("ix", 3284);
    freq.put("bru", 13260);
    freq.put("bro", 7219);
    freq.put("o\u0308r ", 72432);
    freq.put("bri", 10671);
    freq.put("lma", 4184);
    freq.put("bre", 3338);
    freq.put("bra", 3701);
    freq.put("ena\u0308", 3549);
    freq.put("m ", 249455);
    freq.put("a\u0308ld", 3913);
    freq.put("dni", 12167);
    freq.put("a\u0308ll", 14085);
    freq.put("er ", 284777);
    freq.put("a\u0308lv", 4078);
    freq.put("ni ", 11042);
    freq.put("o\u0308rs", 34131);
    freq.put("Ste", 4189);
    freq.put("Sta", 8398);
    freq.put("Sto", 17434);
    freq.put("o\u0308rb", 6194);
    freq.put("o\u0308ra", 7478);
    freq.put("nkt", 4581);
    freq.put("o\u0308rf", 10182);
    freq.put("Str", 3346);
    freq.put("V", 48264);
    freq.put("o\u0308rk", 3758);
    freq.put("o\u0308rj", 5505);
    freq.put("me", 195253);
    freq.put("md", 3318);
    freq.put("mg", 3435);
    freq.put("mf", 8701);
    freq.put("ma", 128458);
    freq.put("err", 9816);
    freq.put("mb", 42798);
    freq.put("mm", 63704);
    freq.put("ml", 20883);
    freq.put("mo", 40002);
    freq.put("mn", 28583);
    freq.put("mi", 57579);
    freq.put("mh", 5236);
    freq.put("mk", 4460);
    freq.put("mu", 35770);
    freq.put("mt", 14449);
    freq.put("erf", 4436);
    freq.put("erg", 20456);
    freq.put("tna", 3229);
    freq.put("mp", 23791);
    freq.put("ms", 22455);
    freq.put("mr", 10561);
    freq.put("erl", 7951);
    freq.put("erm", 7787);
    freq.put("ern", 40094);
    freq.put("ero", 5248);
    freq.put("my", 8276);
    freq.put("eri", 65274);
    freq.put("erk", 19481);
    freq.put("ygg", 9192);
    freq.put("Le", 10243);
    freq.put("La", 13793);
    freq.put("Lo", 9958);
    freq.put("Lin", 4919);
    freq.put("uar", 18907);
    freq.put("la ", 37263);
    freq.put("Li", 14030);
    freq.put("Lu", 7481);
    freq.put("ena", 11883);
    freq.put("enb", 3805);
    freq.put("end", 16477);
    freq.put("ene", 8729);
    freq.put("a\u030all", 6899);
    freq.put("eng", 9041);
    freq.put("hon", 3609);
    freq.put("eni", 7932);
    freq.put("hol", 17007);
    freq.put("enn", 10256);
    freq.put("Kal", 4090);
    freq.put("Kar", 6529);
    freq.put("enr", 3651);
    freq.put("ens", 78815);
    freq.put("ent", 44100);
    freq.put("sse", 11502);
    freq.put("A", 101184);
    freq.put("lam", 3972);
    freq.put("lan", 79933);
    freq.put("lad", 21513);
    freq.put("lag", 21635);
    freq.put("lac", 3318);
    freq.put("fat", 13524);
    freq.put("O\u0308", 9894);
    freq.put("lat", 17536);
    freq.put("ovi", 7790);
    freq.put("lti", 5165);
    freq.put("lar", 35655);
    freq.put("las", 17797);
    freq.put("ma\u030a", 14078);
    freq.put("ma\u0308", 17850);
    freq.put("Alb", 3593);
    freq.put("mo\u0308", 6674);
    freq.put(" Hu", 4927);
    freq.put(" Hi", 4166);
    freq.put("oni", 7172);
    freq.put(" Ho", 12906);
    freq.put(" Ha", 34254);
    freq.put(" He", 15951);
    freq.put("fis", 3388);
    freq.put("ro\u0308", 18726);
    freq.put("ime", 3935);
    freq.put("ta\u0308v", 5108);
    freq.put("ra\u0308", 38698);
    freq.put("ra\u030a", 61767);
    freq.put(" ga", 6755);
    freq.put("fik", 3556);
    freq.put("fin", 14513);
    freq.put("fil", 11844);
    freq.put(" Va", 8077);
    freq.put("ona", 12877);
    freq.put(" Ve", 4954);
    freq.put(" Vi", 10865);
    freq.put("ma\u030al", 5318);
    freq.put("SA ", 9788);
    freq.put("one", 32789);
    freq.put("l", 1576016);
    freq.put("nt ", 21290);
    freq.put("nio", 3817);
    freq.put("rt", 88500);
    freq.put("ru", 68780);
    freq.put("rv", 15260);
    freq.put("gon", 4582);
    freq.put("rp", 8643);
    freq.put("rr", 35803);
    freq.put("rs", 138379);
    freq.put("dst", 6539);
    freq.put("ry", 24021);
    freq.put("rd", 70096);
    freq.put("re", 276377);
    freq.put("rf", 20073);
    freq.put("rg", 57899);
    freq.put("ra", 275879);
    freq.put("rb", 28710);
    freq.put("rc", 6855);
    freq.put("rl", 42446);
    freq.put("rm", 33875);
    freq.put("rn", 86552);
    freq.put("is ", 19720);
    freq.put("rh", 9656);
    freq.put("ri", 267243);
    freq.put("rj", 9549);
    freq.put("gor", 4044);
    freq.put("nty", 4644);
    freq.put("nia", 3660);
    freq.put(" Va\u0308", 9600);
    freq.put("ntr", 13553);
    freq.put("a\u0308c", 6371);
    freq.put("nti", 10623);
    freq.put("W", 29206);
    freq.put("nta", 12228);
    freq.put("nte", 31914);
    freq.put("ate", 21603);
    freq.put("ata", 7543);
    freq.put("iss", 12117);
    freq.put("ato", 8615);
    freq.put("ist", 54624);
    freq.put("isk", 74955);
    freq.put("isi", 5287);
    freq.put("ish", 4776);
    freq.put("r ", 824959);
    freq.put("ats", 14038);
    freq.put("ism", 4171);
    freq.put("aj ", 9347);
    freq.put("isa", 8098);
    freq.put("ise", 7902);
    freq.put("ra\u0308d", 4698);
    freq.put("nhe", 3391);
    freq.put("o\u0308st", 10660);
    freq.put("Y", 8819);
    freq.put("nis", 23117);
    freq.put("tem", 18447);
    freq.put("tor", 39112);
    freq.put("o\u0308pi", 3748);
    freq.put(" Sh", 4450);
    freq.put("ton", 13637);
    freq.put("nit", 5715);
    freq.put("tol", 5901);
    freq.put("tom", 4310);
    freq.put("tob", 9412);
    freq.put("toc", 13127);
    freq.put("kt ", 28682);
    freq.put("tog", 4722);
    freq.put("tod", 3739);
    freq.put(" le", 9968);
    freq.put("B", 88354);
    freq.put("a\u0308ck", 6350);
    freq.put(" la", 18204);
    freq.put(" lo", 3574);
    freq.put(" li", 23241);
    freq.put("Ve", 4995);
    freq.put("kto", 12389);
    freq.put("kti", 15289);
    freq.put("mst", 8336);
    freq.put("kte", 14929);
    freq.put("to ", 4895);
    freq.put("kta", 4658);
    freq.put("raf", 9108);
    freq.put("rag", 4677);
    freq.put("rad", 32041);
    freq.put("rab", 3374);
    freq.put("ran", 40758);
    freq.put("ral", 14704);
    freq.put("ram", 18971);
    freq.put("ty ", 8321);
    freq.put("rak", 6953);
    freq.put("rav", 4107);
    freq.put("rat", 27144);
    freq.put("rar", 16692);
    freq.put("ras", 12995);
    freq.put("va\u0308s", 8080);
    freq.put("on ", 79327);
    freq.put(" la\u030a", 10106);
    freq.put(" la\u0308", 20032);
    freq.put("ra ", 70040);
    freq.put("tyd", 4220);
    freq.put("y", 232177);
    freq.put(" O\u0308s", 5280);
    freq.put("typ", 3540);
    freq.put("tyr", 3920);
    freq.put("tys", 8073);
    freq.put("tse", 5043);
    freq.put("don", 6243);
    freq.put("dom", 6715);
    freq.put("m", 1015154);
    freq.put("a\u0308mn", 7168);
    freq.put("a\u0308ms", 3895);
    freq.put("dor", 6126);
    freq.put(" We", 4953);
    freq.put("ma\u0308n", 8000);
    freq.put(" Wa", 7296);
    freq.put("kus", 3478);
    freq.put("d ", 342945);
    freq.put(" Wi", 9211);
    freq.put("e\u0301n", 3279);
    freq.put("ma\u0308s", 4442);
    freq.put("oci", 4767);
    freq.put("och", 189597);
    freq.put("ock", 32660);
    freq.put("em ", 8949);
    freq.put("kul", 5875);
    freq.put("hri", 3262);
    freq.put("dn", 14977);
    freq.put("do", 35107);
    freq.put("dl", 16308);
    freq.put("dm", 5988);
    freq.put("dj", 7587);
    freq.put("dk", 3943);
    freq.put("dh", 3483);
    freq.put("di", 70271);
    freq.put("df", 3528);
    freq.put("dg", 4171);
    freq.put("dd", 77303);
    freq.put("de", 463243);
    freq.put("db", 6093);
    freq.put("da", 116179);
    freq.put("dy", 5840);
    freq.put("dv", 9506);
    freq.put("X", 3563);
    freq.put("dt", 3864);
    freq.put("du", 15217);
    freq.put("dr", 50264);
    freq.put("ds", 66886);
    freq.put("eme", 8121);
    freq.put("bar", 10200);
    freq.put("bas", 6749);
    freq.put("emb", 26969);
    freq.put("emm", 3946);
    freq.put("emo", 6706);
    freq.put("emi", 7410);
    freq.put("emp", 5979);
    freq.put("ban", 15887);
    freq.put("om ", 168644);
    freq.put("w ", 8904);
    freq.put("Pet", 3811);
    freq.put("nus", 4249);
    freq.put("Per", 3613);
    freq.put("num", 3857);
    freq.put(" I ", 6565);
    freq.put("nua", 9868);
    freq.put("il ", 15253);
    freq.put("un ", 12274);
    freq.put("irk", 5584);
    freq.put("mel", 15875);
    freq.put("mun", 18113);
    freq.put("ire", 6030);
    freq.put("omb", 3421);
    freq.put("we", 6979);
    freq.put("wa", 8836);
    freq.put("omk", 3355);
    freq.put("da\u0308", 13148);
    freq.put(" Is", 3740);
    freq.put("wi", 3916);
    freq.put("oms", 4749);
    freq.put("omr", 7897);
    freq.put("omp", 5523);
    freq.put(" In", 13126);
    freq.put("do\u0308", 42849);
    freq.put("eln", 6244);
    freq.put("gge", 11686);
    freq.put("ild", 15424);
    freq.put("ile", 4047);
    freq.put("unt", 7357);
    freq.put("ell", 67565);
    freq.put("ila", 3896);
    freq.put("ilo", 5583);
    freq.put("ill", 91188);
    freq.put("ilm", 10451);
    freq.put("ilj", 12364);
    freq.put("ilk", 6078);
    freq.put("ili", 8683);
    freq.put("und", 51074);
    freq.put("ils", 3516);
    freq.put("va\u0308g", 7022);
    freq.put("ung", 19464);
    freq.put("ir ", 3453);
    freq.put("gga", 4221);
    freq.put("unk", 5142);
    freq.put("unn", 5336);
    freq.put("va\u0308n", 13490);
    freq.put(" me", 100026);
    freq.put(" ma", 40584);
    freq.put(" mo", 16924);
    freq.put(" mi", 15594);
    freq.put(" mu", 11845);
    freq.put("ele", 19021);
    freq.put(" my", 5673);
    freq.put("san", 6209);
    freq.put("fra", 14521);
    freq.put("rga", 9150);
    freq.put("fri", 9705);
    freq.put("C ", 5688);
    freq.put("a\u0308r ", 211888);
    freq.put("pro", 27839);
    freq.put("gli", 6286);
    freq.put("dsk", 11908);
    freq.put("TV ", 4653);
    freq.put("pru", 4841);
    freq.put("Ch", 12336);
    freq.put("Co", 16319);
    freq.put("Cl", 3705);
    freq.put("slu", 6612);
    freq.put("a\u0308rs", 4830);
    freq.put("Ce", 3786);
    freq.put("n", 2605268);
    freq.put("a\u0308rk", 4071);
    freq.put("gna", 6982);
    freq.put("a\u0308rm", 4235);
    freq.put("a\u0308rl", 8853);
    freq.put("a\u0308rn", 6279);
    freq.put("a\u0308ra", 8245);
    freq.put("sle", 3801);
    freq.put("gni", 3551);
    freq.put("a\u0308re", 3225);
    freq.put("a\u0308rd", 6093);
    freq.put(" ma\u0308", 6492);
    freq.put(" ma\u030a", 7724);
    freq.put("iz", 3965);
    freq.put("ip", 11363);
    freq.put("is", 203197);
    freq.put("ir", 29485);
    freq.put("iu", 7188);
    freq.put("it", 107910);
    freq.put("iv", 58134);
    freq.put("ii", 3814);
    freq.put("ik", 122112);
    freq.put("ld ", 9319);
    freq.put("im", 21187);
    freq.put("il", 185111);
    freq.put("io", 82024);
    freq.put("in", 352330);
    freq.put("ia", 49113);
    freq.put("ic", 45251);
    freq.put("ib", 12524);
    freq.put("ie", 80770);
    freq.put("id", 81847);
    freq.put("ig", 122539);
    freq.put("if", 22472);
    freq.put("V ", 6654);
    freq.put("a\u0308nd", 34964);
    freq.put("a\u0308ng", 10799);
    freq.put("fra\u030a", 39311);
    freq.put("fra\u0308", 4616);
    freq.put("a\u0308nn", 6181);
    freq.put("a\u0308ns", 11234);
    freq.put("th ", 6931);
    freq.put("a\u0308n", 82390);
    freq.put("nik", 4407);
    freq.put("a\u0308l", 34618);
    freq.put("a\u0308m", 18322);
    freq.put("nin", 62497);
    freq.put("a\u0308k", 15670);
    freq.put("kis", 6751);
    freq.put("a\u0308g", 24196);
    freq.put("a\u0308d", 8120);
    freq.put("Sve", 19151);
    freq.put("kiv", 4415);
    freq.put("nie", 10939);
    freq.put("kin", 6276);
    freq.put("a\u0308x", 8215);
    freq.put("kil", 7942);
    freq.put("a\u0308v", 21618);
    freq.put("i ", 355245);
    freq.put("a\u0308t", 25342);
    freq.put("a\u0308r", 272645);
    freq.put("a\u0308s", 34864);
    freq.put("a\u0308p", 6744);
    freq.put("mil", 15426);
    freq.put("Va", 8115);
    freq.put("a\u0308n ", 11102);
    freq.put("Vi", 10913);
    freq.put("ept", 9611);
    freq.put("min", 18579);
    freq.put("epr", 4795);
    freq.put("epp", 4218);
    freq.put("sla\u0308", 13781);
    freq.put("the", 7679);
    freq.put("rn ", 13803);
    freq.put("op ", 3482);
    freq.put("eli", 7809);
    freq.put("hal", 5140);
    freq.put("ham", 7622);
    freq.put("han", 27562);
    freq.put("ela", 36480);
    freq.put("had", 5793);
    freq.put("Or", 4779);
    freq.put("els", 32415);
    freq.put("har", 31426);
    freq.put("hav", 3856);
    freq.put("rni", 4580);
    freq.put("opp", 7590);
    freq.put("D", 81614);
    freq.put("rna", 45582);
    freq.put("rne", 7715);
    freq.put("ope", 5756);
    freq.put("opa", 4338);
    freq.put("ko\u0308p", 4602);
    freq.put("vis", 16981);
    freq.put("ha ", 4594);
    freq.put("el ", 33296);
    freq.put("ola", 11528);
    freq.put("ole", 5201);
    freq.put(" Ju", 4056);
    freq.put("oli", 25700);
    freq.put("olk", 10298);
    freq.put("oll", 18015);
    freq.put("olm", 16608);
    freq.put("olo", 12711);
    freq.put(" Jo", 14976);
    freq.put("ols", 3442);
    freq.put(" Je", 5254);
    freq.put("oly", 3210);
    freq.put(" Ja", 10108);
    freq.put("ick", 11163);
    freq.put("thu", 4634);
    freq.put("ici", 4587);
    freq.put("ich", 7049);
    freq.put("for", 23834);
    freq.put("jo\u0308r", 3329);
    freq.put("ica", 5181);
    freq.put("ice", 6107);
    freq.put("Hu", 4943);
    freq.put("ume", 9374);
    freq.put("Hi", 4225);
    freq.put("Go\u0308t", 5300);
    freq.put("umb", 4012);
    freq.put("fol", 8477);
    freq.put("Ha", 34281);
    freq.put("He", 15981);
    freq.put("ol ", 3524);
    freq.put("pla", 14119);
    freq.put("ic ", 4032);
    freq.put("o", 1513455);
    freq.put("um ", 17518);
    freq.put("va\u030a ", 7032);
    freq.put("soc", 6710);
    freq.put("ppe", 13206);
    freq.put("mbe", 28393);
    freq.put("som", 124363);
    freq.put("son", 32242);
    freq.put("pps", 6631);
    freq.put("sor", 7813);
    freq.put("ppt", 7044);
    freq.put("giv", 6533);
    freq.put("git", 4157);
    freq.put("gis", 8031);
    freq.put("a\u0308st", 24789);
    freq.put("na\u0308", 22292);
    freq.put("na\u030a", 6703);
    freq.put("gif", 3672);
    freq.put("gic", 3318);
    freq.put("gio", 4718);
    freq.put("gin", 4809);
    freq.put("mt ", 8137);
    freq.put("no\u0308", 3871);
    freq.put("pp ", 11986);
    freq.put("A\u030a", 5245);
    freq.put("So\u0308d", 3244);
    freq.put(" na\u030a", 5590);
    freq.put(" na\u0308", 11487);
    freq.put("Z", 5647);
    freq.put("ura", 3453);
    freq.put("O\u0308s", 5286);
    freq.put("gi ", 4509);
    freq.put("nno", 3272);
    freq.put("uro", 7154);
    freq.put("nni", 10650);
    freq.put("nne", 21868);
    freq.put("nna", 22185);
    freq.put("uri", 5728);
    freq.put(" Li", 13966);
    freq.put("kho", 12716);
    freq.put("nns", 9117);
    freq.put("nke", 3380);
    freq.put("nh", 9404);
    freq.put("ni", 141019);
    freq.put("nj", 5464);
    freq.put("nk", 26276);
    freq.put("nl", 21248);
    freq.put("nm", 4189);
    freq.put("nn", 76927);
    freq.put("no", 73752);
    freq.put("tit", 6965);
    freq.put("na", 190258);
    freq.put("nb", 8963);
    freq.put("nc", 14129);
    freq.put("nd", 274187);
    freq.put("ne", 121340);
    freq.put("nf", 12519);
    freq.put("ng", 233628);
    freq.put("til", 75428);
    freq.put("ny", 12036);
    freq.put("tin", 14073);
    freq.put("tio", 41843);
    freq.put("tik", 17763);
    freq.put("tid", 19952);
    freq.put("tie", 6576);
    freq.put("nr", 8077);
    freq.put("ns", 230163);
    freq.put("nt", 115132);
    freq.put("nu", 26246);
    freq.put("nv", 25830);
    freq.put("tic", 3207);
    freq.put("fot", 7918);
    freq.put("E", 57703);
    freq.put(" no", 24830);
    freq.put("kva", 4810);
    freq.put(" na", 17184);
    freq.put(" ne", 4922);
    freq.put("nn ", 5037);
    freq.put(" ny", 4446);
    freq.put("skt", 14119);
    freq.put(" nu", 5991);
    freq.put("n ", 932062);
    freq.put("Wil", 4251);
    freq.put("mme", 13993);
    freq.put("nkr", 3354);
    freq.put("fa\u0308", 10915);
    freq.put("ti ", 13119);
    freq.put("rol", 8031);
    freq.put("o\u0308re", 25188);
    freq.put("ron", 11508);
    freq.put("lls", 18041);
    freq.put("oss", 3221);
    freq.put("o\u0308rd", 7646);
    freq.put("rod", 8744);
    freq.put("ost", 8837);
    freq.put("rof", 6006);
    freq.put("rog", 7715);
    freq.put("osi", 3701);
    freq.put("lli", 11251);
    freq.put("llh", 4880);
    freq.put("ela\u0308", 5847);
    freq.put("rop", 10007);
    freq.put("ror", 5868);
    freq.put("ros", 5853);
    freq.put("rot", 10704);
    freq.put("rov", 7683);
    freq.put("vet", 10570);
    freq.put("ver", 61891);
    freq.put("Dan", 4412);
    freq.put("ysk", 15364);
    freq.put("vec", 5468);
    freq.put("ven", 64039);
    freq.put("vem", 8723);
    freq.put("Ho", 12929);
    freq.put("ert", 13225);
    freq.put("ro ", 5673);
    freq.put("erv", 5509);
    freq.put("va\u030an", 8847);
    freq.put("os ", 9800);
    freq.put("ll ", 78820);
    freq.put("din", 7458);
    freq.put("dio", 6335);
    freq.put("die", 4951);
    freq.put("ers", 49047);
    freq.put("dia", 4497);
    freq.put("gus", 10096);
    freq.put("p", 544314);
    freq.put("ve ", 6856);
    freq.put("dit", 3226);
    freq.put("der", 69482);
    freq.put("dis", 13125);
    freq.put("M ", 4536);
    freq.put(" Yo", 5022);
    freq.put("Gra", 3275);
    freq.put("ere", 6711);
    freq.put("era", 63522);
    freq.put("Me", 11631);
    freq.put("ngd", 5985);
    freq.put("rua", 8438);
    freq.put("Ma", 32867);
    freq.put("erb", 6250);
    freq.put("Mo", 11964);
    freq.put("yde", 3835);
    freq.put("Mi", 11197);
    freq.put("Mu", 4647);
    freq.put("Ind", 4121);
    freq.put("eko", 7026);
    freq.put("dec", 9237);
    freq.put("eki", 3784);
    freq.put("erh", 4470);
    freq.put("bor", 13470);
    freq.put("bok", 5630);
    freq.put("bol", 12338);
    freq.put("ekt", 14604);
    freq.put("a\u030al", 17121);
    freq.put("a\u030an", 81191);
    freq.put("a\u030ak", 8868);
    freq.put("a\u030ae", 3379);
    freq.put("a\u030ad", 24022);
    freq.put("a\u030ag", 13520);
    freq.put("a\u030at", 17902);
    freq.put("a\u030av", 3406);
    freq.put("a\u030as", 6794);
    freq.put("a\u030ar", 43331);
    freq.put("ngt", 3834);
    freq.put(" Ka", 19203);
    freq.put(" Ke", 4195);
    freq.put(" Ki", 6438);
    freq.put(" Ko", 8252);
    freq.put(" Kr", 7023);
    freq.put(" Ku", 4598);
    freq.put("ca ", 4920);
    freq.put("ngr", 3616);
    freq.put("F", 65307);
    freq.put("a\u030a ", 92466);
    freq.put("Ber", 6424);
    freq.put("fly", 6056);
    freq.put("ibl", 3325);
    freq.put("so\u0308", 12206);
    freq.put("ult", 6645);
    freq.put("uli", 10267);
    freq.put("flo", 3656);
    freq.put("fle", 7024);
    freq.put("sa\u030a", 23262);
    freq.put("sa\u0308", 22008);
    freq.put("ges", 7614);
    freq.put(" ol", 7701);
    freq.put(" om", 30114);
    freq.put(" ok", 9806);
    freq.put("ger", 32986);
    freq.put(" of", 14077);
    freq.put("spr", 13840);
    freq.put(" oc", 192923);
    freq.put("ma ", 10795);
    freq.put("spo", 4913);
    freq.put("spa", 4154);
    freq.put(" or", 14441);
    freq.put("spe", 39400);
    freq.put("sst", 3551);
    freq.put("s ", 365755);
    freq.put("mas", 5427);
    freq.put("mar", 31731);
    freq.put("mat", 14610);
    freq.put("use", 6334);
    freq.put("sni", 4681);
    freq.put("maj", 9292);
    freq.put("mal", 5574);
    freq.put("man", 40392);
    freq.put("sy", 19796);
    freq.put("ss", 78482);
    freq.put("sr", 7516);
    freq.put("sp", 69363);
    freq.put("sv", 52306);
    freq.put("su", 13835);
    freq.put("st", 354837);
    freq.put("q", 5367);
    freq.put("sj", 15800);
    freq.put("si", 100666);
    freq.put("sh", 21233);
    freq.put("so", 182040);
    freq.put("sn", 10814);
    freq.put("sm", 23482);
    freq.put("sl", 47405);
    freq.put("sc", 12968);
    freq.put("sb", 15311);
    freq.put("sa", 104819);
    freq.put("sg", 4215);
    freq.put("sf", 11899);
    freq.put("se", 125434);
    freq.put("sd", 11605);
    freq.put("Ru", 3598);
    freq.put("lse", 12155);
    freq.put("lsa", 4733);
    freq.put("tts", 5893);
    freq.put("ttr", 3221);
    freq.put("no ", 3529);
    freq.put("ppa", 4036);
    freq.put("Re", 10230);
    freq.put("lst", 11990);
    freq.put("Ra", 8269);
    freq.put("tta", 33856);
    freq.put("Ro", 13031);
    freq.put("Ri", 6924);
    freq.put("tte", 27085);
    freq.put(" ad", 5086);
    freq.put("ssa", 10371);
    freq.put(" ak", 3619);
    freq.put(" al", 18398);
    freq.put(" am", 17761);
    freq.put(" an", 46161);
    freq.put(" ap", 9654);
    freq.put(" ar", 19850);
    freq.put(" at", 35597);
    freq.put(" au", 10184);
    freq.put(" av", 131499);
    freq.put("gel", 15568);
    freq.put("nom", 26142);
    freq.put("ls ", 8684);
    freq.put("rla\u0308", 3700);
    freq.put("ng ", 83505);
    freq.put("o\u0308ve", 12758);
    freq.put("ppl", 4401);
    freq.put("nor", 19884);
    freq.put("gt ", 15114);
    freq.put("em", 80183);
    freq.put("el", 240548);
    freq.put("eo", 14539);
    freq.put("en", 790036);
    freq.put("ei", 17866);
    freq.put("eh", 9823);
    freq.put("ek", 41076);
    freq.put("ej", 4317);
    freq.put("ee", 11526);
    freq.put("ed", 130488);
    freq.put("eg", 38958);
    freq.put("ef", 28657);
    freq.put("ea", 25581);
    freq.put("rl ", 5718);
    freq.put("ec", 33642);
    freq.put("eb", 31218);
    freq.put("ey", 12032);
    freq.put("ex", 20287);
    freq.put("eu", 8550);
    freq.put("et", 324009);
    freq.put("ew", 8421);
    freq.put("ev", 26002);
    freq.put("ep", 29857);
    freq.put("es", 162582);
    freq.put("er", 632238);
    freq.put("o\u0308d ", 37381);
    freq.put("bli", 9670);
    freq.put("ble", 7136);
    freq.put("bla", 13299);
    freq.put("rli", 7045);
    freq.put("tja\u0308", 4558);
    freq.put("G", 58568);
    freq.put("rle", 4342);
    freq.put("rld", 8530);
    freq.put("ort", 28485);
    freq.put("lms", 5047);
    freq.put("rla", 6287);
    freq.put("e ", 392431);
    freq.put("orn", 10771);
    freq.put("dig", 14250);
    freq.put("ork", 5444);
    freq.put("ori", 16030);
    freq.put("org", 22560);
    freq.put("ord", 31398);
    freq.put("ore", 8252);
    freq.put("lme", 6188);
    freq.put("ora", 9653);
    freq.put("o\u0308dr", 4070);
    freq.put("o\u0308de", 6673);
    freq.put("o\u0308dd", 63162);
    freq.put("pra\u030a", 5570);
    freq.put("xi", 4781);
    freq.put("ono", 6812);
    freq.put("xa", 4078);
    freq.put("ong", 8629);
    freq.put("ond", 7866);
    freq.put("xe", 8556);
    freq.put("ons", 23539);
    freq.put("xt", 11670);
    freq.put("Eur", 4760);
    freq.put("ial", 7807);
    freq.put("ian", 12040);
    freq.put("ukt", 5611);
    freq.put("en ", 561421);
    freq.put("hum", 3706);
    freq.put("x ", 11441);
    freq.put("huv", 8614);
    freq.put("hus", 7589);
    freq.put("ia ", 17620);
    freq.put("r", 2700083);
    freq.put("mra\u030a", 8280);
    freq.put("and", 127973);
    freq.put("ane", 7517);
    freq.put("anf", 3613);
    freq.put("ang", 11657);
    freq.put("ana", 13418);
    freq.put("sam", 44053);
    freq.put("anc", 5238);
    freq.put("anl", 8379);
    freq.put("ann", 22378);
    freq.put("ano", 4964);
    freq.put("pri", 16288);
    freq.put("ani", 15707);
    freq.put("ank", 9321);
    freq.put("ant", 22398);
    freq.put("anu", 13080);
    freq.put("anv", 11075);
    freq.put("ans", 71523);
    freq.put("sar", 8127);
    freq.put("sat", 10892);
    freq.put("Do", 5286);
    freq.put("Di", 6082);
    freq.put("De", 40359);
    freq.put("Da", 13315);
    freq.put("mot", 12947);
    freq.put("an ", 132556);
    freq.put("sa ", 10458);
    freq.put(" Le", 10167);
    freq.put(" La", 13680);
    freq.put(" Lo", 9918);
    freq.put("D ", 3210);
    freq.put(" Lu", 7453);
    freq.put("nla", 5932);
    freq.put("ge ", 21010);
    freq.put("nli", 10002);
    freq.put("ss ", 9668);
    freq.put("We", 4981);
    freq.put("Wa", 7328);
    freq.put("Wo", 3225);
    freq.put("iti", 20829);
    freq.put("lub", 5423);
    freq.put("Wi", 9262);
    freq.put("\u0430", 4143);
    freq.put(" a\u0308l", 3304);
    freq.put(" ps", 3376);
    freq.put(" pr", 32472);
    freq.put(" pu", 3945);
    freq.put("get", 15734);
    freq.put("H", 85820);
    freq.put("jo\u0308", 13694);
    freq.put("ssp", 3681);
    freq.put("ssl", 3516);
    freq.put(" pa", 12607);
    freq.put("ssi", 9151);
    freq.put(" pe", 10275);
    freq.put("ja\u0308", 20365);
    freq.put(" po", 22401);
    freq.put("gen", 70552);
    freq.put(" pl", 6656);
    freq.put(" ba\u030a", 3785);
    freq.put(" bo\u0308", 6965);
    freq.put("dva\u0308", 3688);
    freq.put("uti", 3815);
    freq.put("kel", 5730);
    freq.put("lni", 4907);
    freq.put("rme", 6990);
    freq.put("j ", 14814);
    freq.put("ta\u030ar", 5717);
    freq.put("cir", 4840);
    freq.put("ytt", 4640);
    freq.put("fo\u0308d", 63483);
    freq.put("rko", 6401);
    freq.put("utv", 5038);
    freq.put("fo\u0308r", 137814);
    freq.put("yta", 3770);
    freq.put("utt", 3405);
    freq.put("ju", 37966);
    freq.put("tur", 14907);
    freq.put("ra\u0308m", 4496);
    freq.put("rm ", 4966);
    freq.put("jo", 14819);
    freq.put(" pa\u030a", 64716);
    freq.put("je", 24984);
    freq.put("tud", 5778);
    freq.put("ja", 31220);
    freq.put(" be", 42377);
    freq.put("vud", 9343);
    freq.put("ra\u0308n", 8989);
    freq.put(" ba", 19765);
    freq.put(" bl", 19693);
    freq.put(" bo", 12025);
    freq.put(" bi", 15445);
    freq.put("P ", 3714);
    freq.put("s", 2008119);
    freq.put("rki", 4271);
    freq.put("ra\u0308k", 4195);
    freq.put(" br", 16393);
    freq.put(" by", 8036);
    freq.put("tun", 3943);
    freq.put("por", 8039);
    freq.put("pos", 4574);
    freq.put("pop", 3841);
    freq.put("pol", 17194);
    freq.put("fic", 5656);
    freq.put("ln ", 4441);
    freq.put("eis", 3601);
    freq.put("la\u0308r", 4866);
    freq.put("lyg", 4277);
    freq.put("a\u030ago", 4233);
    freq.put("ein", 4280);
    freq.put("ive", 20061);
    freq.put("iva", 11600);
    freq.put("ivi", 7901);
    freq.put("tni", 11444);
    freq.put("okt", 9964);
    freq.put(" Me", 11596);
    freq.put("par", 19834);
    freq.put("pas", 4154);
    freq.put(" Ma", 32732);
    freq.put(" Mo", 11908);
    freq.put(" Mi", 11127);
    freq.put(" Mu", 4615);
    freq.put("I ", 11291);
    freq.put("cem", 8851);
    freq.put("pan", 9819);
    freq.put("ga\u030ar", 10145);
    freq.put("ma\u030an", 4648);
    freq.put("iv ", 6421);
    freq.put("I", 53417);
    freq.put("yd", 14899);
    freq.put("II", 4483);
    freq.put("gru", 20067);
    freq.put("it ", 10727);
    freq.put("niv", 6000);
    freq.put("ga\u030an", 6463);
    freq.put("Is", 3759);
    freq.put("pa ", 4951);
    freq.put("In", 13186);
    freq.put("tiv", 14860);
    freq.put("\u4e00", 3570);
    freq.put("am ", 15544);
    freq.put("a\u0308xt", 6157);
    freq.put("ka\u0308n", 11729);
    freq.put("ro\u0308m", 5410);
    freq.put("ro\u0308r", 3335);
    freq.put("gde", 4040);
    freq.put("tva\u030a", 7001);
    freq.put("va\u0308", 52142);
    freq.put("nam", 15523);
    freq.put("Eri", 4081);
    freq.put(" ge", 16400);
    freq.put("ami", 11713);
    freq.put("amh", 4267);
    freq.put("amm", 21193);
    freq.put("aml", 16952);
    freq.put("amo", 3480);
    freq.put("amn", 18156);
    freq.put("ama", 6369);
    freq.put("mor", 4951);
    freq.put("amb", 4074);
    freq.put("ame", 25638);
    freq.put("amf", 3558);
    freq.put("mok", 4020);
    freq.put("pa\u030a ", 62169);
    freq.put("mon", 5448);
    freq.put("amp", 5088);
    freq.put("amt", 9744);
    freq.put("Upp", 4062);
    freq.put("mod", 5091);
    freq.put("tig", 8660);
    freq.put("tia", 4024);
    freq.put("gjo", 3575);
    freq.put("t", 2130744);
    freq.put(" gi", 5926);
    freq.put("ho\u0308g", 7787);
    freq.put("tve", 6253);
    freq.put("New", 5646);
    freq.put("ho\u0308r", 6448);
    freq.put(" ci", 5961);
    freq.put("o\u0308te", 5512);
    freq.put(" ce", 5878);
    freq.put("dda", 3257);
    freq.put("dde", 6028);
    freq.put("mpi", 3263);
    freq.put("kvi", 3264);
    freq.put("oo", 9810);
    freq.put("on", 206933);
    freq.put("om", 258987);
    freq.put("ol", 124858);
    freq.put("ok", 32662);
    freq.put("oj", 3321);
    freq.put("ace", 4160);
    freq.put("oh", 11968);
    freq.put("ack", 8031);
    freq.put("of", 28837);
    freq.put("oe", 5372);
    freq.put("ach", 4677);
    freq.put("oc", 231970);
    freq.put("ob", 24414);
    freq.put("oa", 7955);
    freq.put("ow", 7736);
    freq.put("ov", 30611);
    freq.put("ou", 23986);
    freq.put("ot", 63544);
    freq.put("os", 44373);
    freq.put("or", 224835);
    freq.put("op", 33718);
    freq.put("Ni", 7405);
    freq.put("No", 15326);
    freq.put("Na", 8237);
    freq.put("Ne", 10761);
    freq.put("Ny", 3435);
    freq.put("het", 17433);
    freq.put("log", 11812);
    freq.put("her", 10299);
    freq.put("lom", 6295);
    freq.put("lor", 5534);
    freq.put("los", 3900);
    freq.put("lot", 3451);
    freq.put("hel", 8034);
    freq.put("hem", 4216);
    freq.put("hen", 4180);
    freq.put("J", 41709);
    freq.put("jun", 10738);
    freq.put("jul", 9684);
    freq.put("jur", 5620);
    freq.put("rja", 6006);
    freq.put("as ", 45411);
    freq.put("he ", 12764);
    freq.put("aa", 3218);
    freq.put("ac", 25353);
    freq.put("ab", 17368);
    freq.put("ae", 7341);
    freq.put("ad", 157516);
    freq.put("USA", 9498);
    freq.put("af", 19685);
    freq.put("Hon", 4948);
    freq.put("ah", 8954);
    freq.put("ak", 38031);
    freq.put("aj", 13462);
    freq.put("am", 154793);
    freq.put("al", 200396);
    freq.put("an", 490452);
    freq.put("ap", 42925);
    freq.put("as", 105952);
    freq.put("ar", 493878);
    freq.put("au", 25162);
    freq.put("at", 219537);
    freq.put("aw", 3514);
    freq.put("av", 157525);
    freq.put("ay", 9160);
    freq.put("ax", 4752);
    freq.put("az", 4871);
    freq.put("igt", 12741);
    freq.put("igg", 9635);
    freq.put("ige", 28072);
    freq.put("iga", 25749);
    freq.put("igi", 4197);
    freq.put("igh", 9261);
    freq.put("a ", 475159);
    freq.put("ja\u0308l", 6437);
    freq.put("at ", 35834);
    freq.put("u", 641405);
    freq.put("ig ", 23812);
    freq.put("ja\u0308r", 7781);
    freq.put("alo", 3365);
    freq.put("all", 37991);
    freq.put("alm", 9277);
    freq.put("alk", 5184);
    freq.put("ali", 21293);
    freq.put("ald", 6403);
    freq.put("ale", 25866);
    freq.put("alb", 12779);
    freq.put("ala", 19113);
    freq.put("mni", 3641);
    freq.put("gt", 19887);
    freq.put("alv", 3571);
    freq.put("gs", 51929);
    freq.put("alt", 10698);
    freq.put("Fin", 4121);
    freq.put("als", 5130);
    freq.put("gr", 63119);
    freq.put("ots", 4197);
    freq.put("edd", 3460);
    freq.put("ty", 33055);
    freq.put("tv", 19150);
    freq.put("da\u0308r", 12388);
    freq.put("tt", 213949);
    freq.put("tu", 36176);
    freq.put("tr", 105466);
    freq.put("ts", 67257);
    freq.put("tn", 19214);
    freq.put("to", 108377);
    freq.put("tl", 17707);
    freq.put("tm", 5831);
    freq.put("tj", 8416);
    freq.put("tk", 5397);
    freq.put("th", 27907);
    freq.put("ti", 267169);
    freq.put("tf", 8472);
    freq.put("\u0438", 3560);
    freq.put("te", 298793);
    freq.put("tb", 14691);
    freq.put("ta", 250228);
    freq.put("And", 5658);
    freq.put(" ro\u0308", 4188);
    freq.put("ta\u0308l", 6340);
    freq.put("far", 5867);
    freq.put("mpo", 3301);
    freq.put("al ", 27066);
    freq.put("llv", 5128);
    freq.put(" ra\u0308", 4287);
    freq.put("gy", 3273);
    freq.put("fal", 3610);
    freq.put("fam", 7188);
    freq.put("mn ", 9157);
    freq.put("ta\u0308r", 4618);
    freq.put("ius", 3596);
    freq.put("llt", 8125);
    freq.put("sme", 3479);
    freq.put(" Ni", 7391);
    freq.put("gg", 27749);
    freq.put("pre", 11182);
    freq.put("ro", 113836);
    freq.put(" No", 15289);
    freq.put("gf", 3700);
    freq.put(" Na", 8152);
    freq.put(" Ne", 10698);
    freq.put("ge", 171880);
    freq.put(" Ny", 3423);
    freq.put("sma", 7643);
    freq.put("rk", 70077);
    freq.put("rbu", 4396);
    freq.put("t ", 541739);
    freq.put("lln", 3548);
    freq.put("ass", 11560);
    freq.put("tek", 5853);
    freq.put("tel", 9950);
    freq.put("ga", 96208);
    freq.put("ten", 56126);
    freq.put("teb", 4880);
    freq.put("tec", 5494);
    freq.put("tex", 3539);
    freq.put("osa", 3703);
    freq.put("ter", 115723);
    freq.put("tes", 9480);
    freq.put("tet", 22695);
    freq.put("lla", 46043);
    freq.put("gl", 17131);
    freq.put("rma", 11324);
    freq.put("to\u0308", 15637);
    freq.put("ose", 3675);
    freq.put("lle", 53525);
    freq.put("ha\u030al", 7111);
    freq.put("ta\u0308", 25279);
    freq.put("ta\u030a", 13823);
    freq.put("ba\u0308", 6295);
    freq.put(" ru", 4704);
    freq.put("te ", 29236);
    freq.put("K", 67803);
    freq.put(" ry", 5559);
    freq.put(" re", 30692);
    freq.put(" ra", 6370);
    freq.put("pub", 4680);
    freq.put(" ro", 9439);
    freq.put("ggn", 3889);
    freq.put(" ri", 11458);
    freq.put("rbe", 10058);
    freq.put("oma", 9422);
    freq.put("ev ", 6530);
    freq.put("lke", 7097);
    freq.put("nto", 5785);
    freq.put("vid", 23789);
    freq.put("rks", 6561);
    freq.put("vik", 5560);
    freq.put("vin", 14334);
    freq.put("vil", 12065);
    freq.put("rke", 8992);
    freq.put("rka", 21148);
    freq.put("vit", 5788);
    freq.put("S ", 6544);
    freq.put(" s ", 6480);
    freq.put("a\u030at ", 4155);
    freq.put("de ", 113906);
    freq.put("Sy", 4319);
    freq.put("fo\u0308", 204508);
    freq.put(" a\u0308n", 4390);
    freq.put("Sp", 7173);
    freq.put("Sv", 20759);
    freq.put("Su", 6305);
    freq.put("St", 38584);
    freq.put("Sk", 9057);
    freq.put("Si", 8063);
    freq.put("Sh", 4489);
    freq.put("So", 11179);
    freq.put("fa\u030a", 5419);
    freq.put("Sc", 5830);
    freq.put("Sa", 15777);
    freq.put("avs", 7927);
    freq.put("Se", 8850);
    freq.put(" do", 7611);
    freq.put("ey ", 7588);
    freq.put("a\u0308kt", 7912);
    freq.put("kla", 15409);
    freq.put(" di", 13002);
    freq.put(" de", 166176);
    freq.put("des", 48453);
    freq.put("det", 49713);
    freq.put("kli", 6794);
    freq.put(" da", 13590);
    freq.put("klu", 5282);
    freq.put("del", 42235);
    freq.put("dem", 7457);
    freq.put("den", 110439);
    freq.put("v", 702277);
    freq.put("a\u0308kn", 3856);
    freq.put(" Fe", 3308);
    freq.put("SA", 10320);
    freq.put("o\u0308gs", 4071);
    freq.put(" dr", 6511);
    freq.put("avi", 4830);
    freq.put("f ", 20176);
    freq.put("ati", 48093);
    freq.put("slo", 3319);
    freq.put("att", 63033);
    freq.put(" Fl", 4322);
    freq.put("atu", 6856);
    freq.put("rys", 4892);
    freq.put("Tys", 3259);
    freq.put("fr", 73976);
    freq.put("ft", 39725);
    freq.put("fu", 7874);
    freq.put("fy", 6327);
    freq.put("So\u0308", 3933);
    freq.put("fa", 41395);
    freq.put("fe", 29350);
    freq.put("ff", 12688);
    freq.put("fi", 46296);
    freq.put("fj", 3473);
    freq.put("fl", 21495);
    freq.put("fo", 44582);
    freq.put("a", 2769748);
    freq.put("egr", 5273);
    freq.put(" da\u030a", 6671);
    freq.put(" da\u0308", 12563);
    freq.put("ry ", 6473);
    freq.put("egi", 9515);
    freq.put("ds ", 21182);
    freq.put("o\u0308", 429328);
    freq.put(" do\u0308", 38312);
    freq.put("ege", 11795);
    freq.put("ce ", 7249);
    freq.put("y ", 50286);
    freq.put("ite", 17827);
    freq.put(" so\u0308", 6783);
    freq.put("uvu", 9284);
    freq.put("ita", 12733);
    freq.put("ok ", 3568);
    freq.put("ity", 3491);
    freq.put("itt", 20776);
    freq.put("itu", 3337);
    freq.put(" sa\u0308", 12510);
    freq.put(" sa\u030a", 14446);
    freq.put(" Ol", 4952);
    freq.put(" Or", 4762);
    freq.put("yk", 5316);
    freq.put("okr", 4246);
    freq.put("ym", 10053);
    freq.put("yl", 9018);
    freq.put("yn", 12472);
    freq.put("ya", 7829);
    freq.put("cen", 9841);
    freq.put("yc", 9359);
    freq.put("L", 68342);
    freq.put("yg", 18262);
    freq.put("yf", 3366);
    freq.put("oka", 3360);
    freq.put("oke", 3223);
    freq.put("cer", 9280);
    freq.put("yp", 6499);
    freq.put("ys", 34208);
    freq.put("yr", 23125);
    freq.put("yt", 14189);
    freq.put("ift", 11636);
    freq.put("tro", 12216);
    freq.put(" sy", 11768);
    freq.put("Eng", 3595);
    freq.put(" sp", 27636);
    freq.put(" sv", 36306);
    freq.put(" st", 66122);
    freq.put(" su", 3592);
    freq.put(" sj", 9848);
    freq.put(" sk", 41581);
    freq.put(" si", 31916);
    freq.put(" so", 132908);
    freq.put(" sl", 17774);
    freq.put(" sm", 3812);
    freq.put(" sa", 28037);
    freq.put(" se", 37040);
    freq.put("fta", 8409);
    freq.put("dag", 13716);
    freq.put("fte", 17736);
    freq.put("da\u030a ", 5689);
    freq.put("En ", 5663);
    freq.put(" el", 30240);
    freq.put(" Ad", 3934);
    freq.put("ast", 21648);
    freq.put("mmu", 16790);
    freq.put(" Al", 15206);
    freq.put(" Am", 3890);
    freq.put(" An", 15211);
    freq.put(" Ar", 9902);
    freq.put(" As", 4526);
    freq.put(" Au", 4688);
    freq.put("ase", 5556);
    freq.put("sla", 13504);
    freq.put("ask", 3632);
    freq.put("st ", 46043);
    freq.put("asi", 5423);
    freq.put("mma", 26822);
    freq.put("El", 5544);
    freq.put("En", 12408);
    freq.put("Ed", 3462);
    freq.put("ft ", 9311);
    freq.put("w", 38244);
    freq.put("Eu", 5433);
    freq.put(" a\u0308v", 12511);
    freq.put(" a\u0308r", 187240);
    freq.put("Er", 5959);
    freq.put("Fra", 6710);
    freq.put("Fre", 3915);
    freq.put("sa\u030an", 9241);
    freq.put("jer", 3396);
    freq.put(" en", 197679);
    freq.put("kom", 35824);
    freq.put("kol", 9820);
    freq.put("kon", 20182);
    freq.put(" ef", 10304);
    freq.put(" eg", 6206);
    freq.put(" ex", 7709);
    freq.put(" et", 57787);
    freq.put("kor", 12173);
    freq.put("jen", 6427);
    freq.put("kot", 3776);
    freq.put("odu", 7243);
    freq.put("sa\u030a ", 8428);
    freq.put("nce", 6161);
    freq.put("ste", 53976);
    freq.put("b", 426497);
    freq.put("sta", 88293);
    freq.put("ka\u030a", 10126);
    freq.put("ka\u0308", 17405);
    freq.put("rk ", 11840);
    freq.put("stn", 5297);
    freq.put("sto", 24174);
    freq.put(" e ", 3326);
    freq.put("sti", 35352);
    freq.put("stu", 7051);
    freq.put("je ", 5239);
    freq.put("ko\u0308", 11089);
    freq.put("str", 43893);
    freq.put("sty", 3941);
    freq.put("ka ", 105354);
    freq.put("a\u030ade", 18255);
    freq.put("o\u0308n ", 5859);
    freq.put("lie", 9952);
    freq.put("k ", 153527);
    freq.put("lia", 6013);
    freq.put("lic", 4558);
    freq.put("lin", 35763);
    freq.put("eft", 11252);
    freq.put("lik", 14533);
    freq.put("lit", 24473);
    freq.put("liv", 5593);
    freq.put("efo", 3657);
    freq.put("oft", 6611);
    freq.put("kad", 6591);
    freq.put("M", 88836);
    freq.put("kan", 45226);
    freq.put("kam", 3425);
    freq.put("kal", 21132);
    freq.put("kas", 4078);
    freq.put("kar", 20696);
    freq.put("kap", 15909);
    freq.put("kat", 7694);
    freq.put("The", 8834);
    freq.put("rom", 7155);
    freq.put("sta\u0308", 10967);
    freq.put("sta\u030a", 11548);
    freq.put("ka", 235170);
    freq.put("exe", 4418);
    freq.put("li ", 11521);
    freq.put("ke", 98699);
    freq.put("Va\u0308", 9609);
    freq.put("ki", 37850);
    freq.put("kh", 15721);
    freq.put("ko", 98732);
    freq.put("kn", 24158);
    freq.put("km", 8676);
    freq.put("kl", 32687);
    freq.put("ks", 31609);
    freq.put("kr", 52042);
    freq.put("ext", 4721);
    freq.put("kv", 10463);
    freq.put("ku", 21062);
    freq.put("kt", 90094);
    freq.put("ky", 14497);
    freq.put("rte", 14318);
    freq.put("rta", 8444);
    freq.put("Han", 20213);
    freq.put("rti", 15874);
    freq.put("rth", 3501);
    freq.put("rts", 3730);
    freq.put("Har", 3270);
    freq.put("ugu", 9934);
    freq.put("Ju", 4068);
    freq.put("ies", 3414);
    freq.put("ier", 11523);
    freq.put("iet", 8507);
    freq.put("Jo", 15004);
    freq.put("iel", 7300);
    freq.put("ien", 33298);
    freq.put("Je", 5266);
    freq.put("Ja", 10130);
    freq.put("his", 5950);
    freq.put("rt ", 25088);
    freq.put("hin", 3839);
    freq.put("rfa", 11243);
    freq.put("x", 48501);
    freq.put(" Be", 16738);
    freq.put("arr", 8387);
    freq.put("ars", 21054);
    freq.put("art", 35107);
    freq.put("ser", 32108);
    freq.put("sep", 9935);
    freq.put(" Bl", 4680);
    freq.put(" Bo", 13888);
    freq.put(" Bi", 5612);
    freq.put(" Bu", 5515);
    freq.put("ara", 27724);
    freq.put("arb", 9854);
    freq.put("ik ", 16104);
    freq.put("ard", 11975);
    freq.put("are", 94208);
    freq.put(" Br", 13201);
    freq.put("ari", 37821);
    freq.put("ark", 16487);
    freq.put("arl", 13544);
    freq.put("arm", 4137);
    freq.put("arn", 18125);
    freq.put("aro", 4452);
    freq.put("ses", 3294);
    freq.put(" a\u030at", 5457);
    freq.put("ms ", 6348);
    freq.put(" a\u030ar", 16994);
    freq.put("iks", 9950);
    freq.put("ikt", 12966);
    freq.put("upp", 32257);
    freq.put("ar ", 171511);
    freq.put("ika", 38088);
    freq.put("ike", 30688);
    freq.put("se ", 11017);
    freq.put("Ba", 14125);
    freq.put(" Pr", 8806);
    freq.put("c", 439610);
    freq.put("O\u0308st", 5201);
    freq.put(" Pa", 14488);
    freq.put(" Pe", 11321);
    freq.put(" Pi", 4113);
    freq.put(" Po", 7530);
    freq.put("lbu", 12650);
    freq.put("tgi", 4603);
    freq.put("ga ", 26894);
    freq.put("pr", 69684);
    freq.put("ps", 16974);
    freq.put("pp", 63825);
    freq.put("pt", 22670);
    freq.put("pu", 12367);
    freq.put("duc", 4844);
    freq.put("pa", 50445);
    freq.put("pg", 3698);
    freq.put("pe", 96760);
    freq.put("ph", 7115);
    freq.put("pi", 19978);
    freq.put("pn", 3697);
    freq.put("po", 41753);
    freq.put("pl", 23211);
    freq.put("nri", 3216);
    freq.put(" ty", 10671);
    freq.put(" tv", 8751);
    freq.put(" tu", 4474);
    freq.put("gat", 4458);
    freq.put("gas", 5062);
    freq.put(" tr", 20781);
    freq.put("N", 55651);
    freq.put(" to", 9251);
    freq.put("gan", 12485);
    freq.put(" ti", 85531);
    freq.put(" th", 7205);
    freq.put(" te", 14430);
    freq.put(" ta", 17457);
    freq.put("lba", 3463);
    freq.put("sak", 4471);
    freq.put("mla", 4634);
    freq.put(" fo\u0308", 177054);
    freq.put("mli", 14006);
    freq.put("p ", 30112);
    freq.put(" fa\u030a", 4608);
    freq.put(" fa\u0308", 3840);
    freq.put("fun", 3567);
    freq.put("riv", 11699);
    freq.put("rit", 18193);
    freq.put("ris", 26661);
    freq.put("rin", 29008);
    freq.put("rio", 4391);
    freq.put("ril", 11007);
    freq.put("rim", 3215);
    freq.put("rik", 49805);
    freq.put("rif", 3813);
    freq.put("rig", 24904);
    freq.put("rid", 7589);
    freq.put("rie", 22621);
    freq.put("ric", 6800);
    freq.put("ria", 11330);
    freq.put("gs ", 13333);
    freq.put("pa\u030a", 66737);
    freq.put("ohn", 3565);
    freq.put("sa\u0308t", 7762);
    freq.put("Va\u0308s", 5464);
    freq.put("psa", 5456);
    freq.put("Cou", 3952);
    freq.put("tis", 30207);
    freq.put("syd", 3945);
    freq.put("sys", 5192);
    freq.put("lig", 48482);
    freq.put(" ta\u0308", 6373);
    freq.put("ri ", 24498);
    freq.put(" fr", 64090);
    freq.put(" fu", 4697);
    freq.put("gst", 6826);
    freq.put("kni", 12636);
    freq.put(" fy", 5095);
    freq.put("ew ", 5717);
    freq.put("fa\u0308l", 3203);
    freq.put("kna", 9166);
    freq.put(" fa", 16157);
    freq.put("fa\u0308r", 6347);
    freq.put(" fe", 13408);
    freq.put(" fi", 26001);
    freq.put("gsk", 4034);
    freq.put("gsm", 3229);
    freq.put(" fl", 15697);
    freq.put(" fo", 25076);
    freq.put("lda", 11000);
    freq.put("lde", 11008);
    freq.put("sju", 4204);
    freq.put("lds", 6297);
    freq.put("ldr", 3289);
    freq.put("rgs", 6893);
    freq.put("\u043e", 3458);
    freq.put("sal", 8723);
    freq.put("rge", 9457);
    freq.put("rgi", 4148);
    freq.put(" De", 40274);
    freq.put("bin", 3462);
    freq.put("ba\u030a", 4938);
    freq.put("bil", 16029);
    freq.put("Ol", 4960);
    freq.put("lis", 16271);
    freq.put("bo\u0308", 8648);
    freq.put("ha\u0308r", 4070);
    freq.put("Yor", 3342);
    freq.put("bis", 3915);
    freq.put("d", 1393951);
    freq.put("lja", 3349);
    freq.put("so\u0308d", 5258);
    freq.put("lje", 9323);
    freq.put("rg ", 18322);
    freq.put("elt", 6933);
    freq.put("bo\u0308r", 6225);
    freq.put("b ", 9647);
    freq.put("pet", 5946);
    freq.put("per", 22100);
    freq.put("pel", 41073);
    freq.put("pen", 15225);
    freq.put("id ", 28142);
    freq.put("be", 121628);
    freq.put("run", 19578);
    freq.put("ba", 47465);
    freq.put("bb", 11237);
    freq.put("rum", 7564);
    freq.put("bl", 35898);
    freq.put("bo", 47200);
    freq.put("bi", 33086);
    freq.put("O", 30870);
    freq.put("bu", 29326);
    freq.put("br", 42376);
    freq.put("rus", 3564);
    freq.put("rup", 12524);
    freq.put("by", 19363);
    freq.put("che", 9375);
    freq.put("a\u0308", 562602);
    freq.put("idr", 4877);
    freq.put("ids", 4482);
    freq.put("idn", 3610);
    freq.put("idi", 9977);
    freq.put("ide", 12497);
    freq.put("ida", 10207);
    freq.put("nsi", 5055);
    freq.put("nsk", 92387);
    freq.put("nsl", 4609);
    freq.put(" ut", 38370);
    freq.put("nsa", 6209);
    freq.put(" up", 19177);
    freq.put("nse", 13545);
    freq.put(" ur", 7073);
    freq.put("tif", 5408);
    freq.put(" un", 29257);
    freq.put("nsp", 4485);
    freq.put("nss", 4316);
    freq.put("nst", 23393);
    freq.put("ut ", 10089);
    freq.put("ra\u030ak", 6071);
    freq.put("gra\u0308", 4757);
    freq.put(" ga\u030a", 6683);
    freq.put("ra\u030an", 39221);
    freq.put("u ", 12792);
    freq.put("fes", 6198);
    freq.put(" Ch", 12294);
    freq.put(" Co", 16148);
    freq.put(" Cl", 3646);
    freq.put("ns ", 54594);
    freq.put(" Ca", 14547);
    freq.put(" Ce", 3768);
    freq.put("sde", 3304);
    freq.put("sda", 5839);
    freq.put("ra\u0308t", 6983);
    freq.put("cia", 6069);
    freq.put("uta", 8659);
    freq.put("a\u030a", 315734);
    freq.put("utg", 8418);
    freq.put("cie", 3837);
    freq.put("ute", 6086);
    freq.put("ut", 71499);
    freq.put("sva\u0308", 4118);
    freq.put("uv", 14989);
    freq.put("up", 38948);
    freq.put("us", 77613);
    freq.put("ur", 68778);
    freq.put("um", 42001);
    freq.put("ul", 41627);
    freq.put("un", 129135);
    freq.put("ui", 6645);
    freq.put("uk", 16033);
    freq.put("ue", 11748);
    freq.put("ud", 29487);
    freq.put("ug", 17372);
    freq.put("z", 28076);
    freq.put("ua", 23575);
    freq.put("uc", 9950);
    freq.put("ub", 16763);
    freq.put("la\u0308g", 9136);
    freq.put("Ty", 4282);
    freq.put("la\u0308k", 8254);
    freq.put("Tu", 3610);
    freq.put("Tr", 7442);
    freq.put("la\u0308n", 20491);
    freq.put("To", 8743);
    freq.put("la\u0308p", 5670);
    freq.put("dre", 6617);
    freq.put("Th", 13440);
    freq.put("Ti", 6372);
    freq.put("Te", 8278);
    freq.put("Ta", 5863);
    freq.put("A ", 15096);
    freq.put(" gu", 3989);
    freq.put(" gr", 27602);
    freq.put("nad", 14500);
    freq.put("TV", 4696);
    freq.put("nan", 10186);
    freq.put("sto\u0308", 8124);
    freq.put("nal", 16599);
    freq.put("ag ", 17369);
    freq.put("nar", 23024);
    freq.put("nas", 10608);
    freq.put("gre", 14703);
    freq.put("nat", 21915);
    freq.put("gra", 18317);
    freq.put("Mal", 3953);
    freq.put("Man", 3676);
    freq.put("agn", 5084);
    freq.put("na ", 68634);
    freq.put("e", 3122256);
    freq.put("Ad", 3948);
    freq.put("age", 18047);
    freq.put("sve", 36524);
    freq.put("Am", 3905);
    freq.put("Al", 15279);
    freq.put("aga", 8161);
    freq.put("An", 15253);
    freq.put("ruk", 6602);
    freq.put("As", 4625);
    freq.put("Ar", 9978);
    freq.put("Au", 4696);
    freq.put("ags", 6901);
    freq.put("a\u0308tt", 18556);
    freq.put(" b", 150256);
    freq.put(" c", 22076);
    freq.put("gu", 21320);
    freq.put(" a", 307677);
    freq.put(" f", 359134);
    freq.put(" g", 79790);
    freq.put(" d", 271388);
    freq.put(" e", 324754);
    freq.put(" j", 42422);
    freq.put(" k", 154387);
    freq.put(" h", 123124);
    freq.put(" i", 363557);
    freq.put(" n", 78082);
    freq.put(" o", 280066);
    freq.put(" l", 92862);
    freq.put(" m", 210837);
    freq.put(" r", 78305);
    freq.put(" s", 494735);
    freq.put(" p", 161981);
    freq.put("gd", 12439);
    freq.put(" v", 181674);
    freq.put("gb", 3970);
    freq.put(" t", 189989);
    freq.put(" u", 95544);
    freq.put("go", 20646);
    freq.put("gn", 17191);
    freq.put(" y", 5622);
    freq.put("gj", 3942);
    freq.put("gi", 45303);
    freq.put("gh", 13879);
    freq.put(" B", 82669);
    freq.put(" C", 63320);
    freq.put(" A", 84049);
    freq.put(" F", 59275);
    freq.put(" G", 56022);
    freq.put(" D", 77148);
    freq.put(" E", 54653);
    freq.put(" J", 40952);
    freq.put(" K", 63008);
    freq.put(" H", 83187);
    freq.put(" I", 43524);
    freq.put(" N", 52283);
    freq.put(" O", 27251);
    freq.put(" L", 64682);
    freq.put(" M", 82331);
    freq.put(" R", 51071);
    freq.put(" S", 163518);
    freq.put(" P", 59385);
    freq.put(" V", 40400);
    freq.put(" W", 28309);
    freq.put(" T", 68207);
    freq.put(" U", 30253);
    freq.put(" Z", 5389);
    freq.put(" Y", 8451);
    freq.put("lkr", 4019);
    freq.put("Nor", 12355);
    freq.put("vli", 3664);
    freq.put("ch ", 194706);
    freq.put("ed ", 60806);
    freq.put("P", 64540);
    freq.put("g ", 162227);
    freq.put("tri", 14508);
    freq.put("evi", 3537);
    freq.put("a\u030att", 4014);
    freq.put("tra", 36819);
    freq.put("eva", 3607);
    freq.put("us ", 21399);
    freq.put("tre", 12611);
    freq.put("eve", 6119);
    freq.put("try", 3989);
    freq.put("a\u030ate", 4737);
    freq.put("tru", 8774);
    freq.put("le ", 15487);
    freq.put("go\u0308", 7789);
    freq.put("zi", 3697);
    freq.put(" a\u0308", 214016);
    freq.put(" a\u030a", 25155);
    freq.put("rre", 7456);
    freq.put("za", 3995);
    freq.put("rra", 8312);
    freq.put("ay ", 3818);
    freq.put("ga\u030a", 19638);
    freq.put(" o\u0308", 25267);
    freq.put("ode", 11255);
    freq.put(" Re", 10191);
    freq.put(" A\u030a", 5217);
    freq.put("yck", 8174);
    freq.put(" O\u0308", 9837);
    freq.put("rd ", 16211);
    freq.put("enh", 4318);
    freq.put("led", 11323);
    freq.put("ull", 6732);
    freq.put("obe", 13311);
    freq.put("lek", 6522);
    freq.put("z ", 7095);
    freq.put("lem", 6956);
    freq.put("len", 25248);
    freq.put("rr ", 4068);
    freq.put("ler", 49986);
    freq.put("les", 8492);
    freq.put("let", 19531);
    freq.put("lev", 10258);
    freq.put("od ", 6498);
    freq.put("rds", 5163);
    freq.put("ha\u0308l", 3201);
    freq.put("tra\u0308", 9790);
    freq.put("rde", 19138);
    freq.put("nva\u0308", 12582);
    freq.put("rda", 6312);
    freq.put("rdn", 3815);
    freq.put("rdi", 6203);
    freq.put("tro\u0308", 5020);
    freq.put(" Do", 5127);
    freq.put(" Di", 6045);
    freq.put("apr", 9022);
    freq.put("app", 4146);
    freq.put(" Da", 13258);
    freq.put("apa", 8845);
    freq.put("ape", 7645);
    freq.put("cha", 5427);
    freq.put("Fr", 15828);
    freq.put("feb", 8379);
    freq.put(" va\u0308", 22816);
    freq.put("chi", 3577);
    freq.put("usi", 13675);
    freq.put("Fa", 6453);
    freq.put("ust", 23739);
    freq.put("fer", 3302);
    freq.put("Fe", 3321);
    freq.put("Fi", 8854);
    freq.put("Fl", 4338);
    freq.put("ra\u030ad", 11141);
    freq.put("Fo", 6429);
    freq.put("ove", 12742);
    freq.put("ap ", 4055);
    freq.put("ndl", 5881);
    freq.put(" Ru", 3585);
    freq.put("oi", 5452);
    freq.put("f", 573497);
    freq.put("do\u0308d", 37434);
    freq.put("F ", 4011);
    freq.put("og", 35630);
    freq.put(" Ra", 8225);
    freq.put(" Ro", 12950);
    freq.put(" Ri", 6904);
    freq.put("tat", 22284);
    freq.put("tav", 3738);
    freq.put("od", 38865);
    freq.put("tar", 38387);
    freq.put("tas", 6110);
    freq.put("tad", 34944);
    freq.put("tag", 10048);
    freq.put("eno", 10317);
    freq.put("kyr", 9176);
    freq.put("tal", 35934);
    freq.put("tam", 3270);
    freq.put("tan", 25694);
    freq.put(" va", 97104);
    freq.put(" ve", 11661);
    freq.put("afi", 4365);
    freq.put("Yo", 5029);
    freq.put("sit", 12645);
    freq.put(" vi", 43226);
    freq.put("aff", 3221);
    freq.put("sig", 10296);
    freq.put("sie", 4171);
    freq.put("sid", 6241);
    freq.put("aft", 3394);
    freq.put("sio", 10464);
    freq.put("sin", 20425);
    freq.put("kro", 5638);
    freq.put("sis", 10405);
    freq.put("ta ", 57380);
    freq.put("dd ", 64224);
    freq.put("Fo\u0308", 6773);
    freq.put("af ", 3707);
    freq.put("da ", 24533);
    freq.put("lf", 10995);
    freq.put("lg", 7505);
    freq.put("ld", 48550);
    freq.put("le", 171301);
    freq.put("lb", 23488);
    freq.put("tsk", 5040);
    freq.put("la", 251597);
    freq.put("ln", 12525);
    freq.put("lo", 57125);
    freq.put("ll", 251645);
    freq.put("lm", 43916);
    freq.put("lj", 22122);
    freq.put("lk", 26056);
    freq.put("lh", 8848);
    freq.put("li", 194145);
    freq.put("lv", 21024);
    freq.put("lt", 40778);
    freq.put("lu", 27907);
    freq.put("ls", 70931);
    freq.put("lp", 6851);
    freq.put("byg", 8032);
    freq.put("tst", 3437);
    freq.put("ly", 18029);
    freq.put("dad", 11525);
    freq.put("a\u0308ga", 3677);
    freq.put("a\u0308gg", 3687);
    freq.put("a\u0308ge", 8468);
    freq.put("dal", 5199);
    freq.put("Car", 7211);
    freq.put("dan", 22463);
    freq.put("la\u030an", 4645);
    freq.put("dat", 8203);
    freq.put("sik", 13865);
    freq.put("la\u030at", 5580);
    freq.put("dar", 13228);
    freq.put("das", 4305);
    freq.put("Fo\u0308r", 6368);
    freq.put("ema", 5588);
    freq.put("San", 4701);
    freq.put("l ", 174554);
    freq.put("Pro", 3506);
    freq.put(" hu", 13035);
    freq.put(" hi", 6661);
    freq.put(" ho", 7645);
    freq.put(" ha", 54753);
    freq.put(" he", 14640);
    freq.put("oun", 6352);
    freq.put("our", 5919);
    freq.put("la\u0308", 54929);
    freq.put("la\u030a", 14272);
    freq.put("rer", 8988);
    freq.put("res", 20396);
    freq.put("rep", 9910);
    freq.put("rev", 5759);
    freq.put("ret", 18000);
    freq.put("lo\u0308", 8782);
    freq.put("rek", 11220);
    freq.put("lt ", 15274);
    freq.put("ren", 33831);
    freq.put("rel", 8037);
    freq.put("rem", 4053);
    freq.put("rea", 6436);
    freq.put("reg", 14934);
    freq.put("red", 13615);
    freq.put("ece", 9407);
    freq.put("eck", 13530);
    freq.put("eci", 3498);
    freq.put("ie ", 9770);
    freq.put("lod", 5577);
    freq.put("g", 796472);
    freq.put(" ho\u0308", 10368);
    freq.put("nfo\u0308", 4263);
    freq.put("lta", 4364);
    freq.put("lte", 4556);
    freq.put("yra", 3515);
    freq.put("re ", 105451);
    freq.put("u\u0308", 3814);
    freq.put(" ha\u0308", 8278);
    freq.put("K ", 4256);
    freq.put("rs ", 30266);
    freq.put("set", 6663);
    freq.put(" Ba", 14044);
    freq.put("og ", 7992);
    freq.put(" Sy", 4310);
    freq.put(" Sp", 7111);
    freq.put(" Sv", 20662);
    freq.put("nda", 25018);
    freq.put(" St", 38280);
    freq.put(" Su", 6295);
    freq.put(" Sk", 9040);
    freq.put(" o\u0308s", 4997);
    freq.put(" Si", 8029);
    freq.put(" So", 11126);
    freq.put(" o\u0308v", 12751);
    freq.put(" Sc", 5776);
    freq.put(" Sa", 15732);
    freq.put(" Se", 8798);
    freq.put("uds", 4702);
    freq.put("Ka", 19254);
    freq.put("rso", 8438);
    freq.put("rsi", 7847);
    freq.put("Ke", 4271);
    freq.put("rsk", 18149);
    freq.put("sfo\u0308", 5604);
    freq.put("rse", 4696);
    freq.put("Ki", 6491);
    freq.put("ka\u030ad", 7525);
    freq.put("Ko", 8264);
    freq.put("rsa", 13567);
    freq.put("ogr", 10374);
    freq.put("Kr", 7039);
    freq.put("R", 54519);
    freq.put("ogi", 6891);
    freq.put("Ku", 4607);
    freq.put("ude", 4661);
    freq.put("rst", 26007);
    freq.put("udi", 4906);
    freq.put("rsp", 7925);
    freq.put("udo", 3784);
    freq.put("rss", 3568);
    freq.put("ben", 7083);
    freq.put("bel", 10187);
    freq.put("beg", 3230);
    freq.put("sed", 10233);
    freq.put("ber", 59590);
    freq.put("bes", 11143);
    freq.put("bet", 17916);
    freq.put("Par", 5960);
    freq.put("sen", 30980);
    freq.put("sk", 296865);
    freq.put("sel", 3990);
    freq.put("ur ", 12946);
    freq.put("ck ", 16616);
    freq.put("ghe", 6517);
    freq.put(" So\u0308", 3929);
    freq.put("hr", 6279);
    freq.put("mis", 6696);
    freq.put("mit", 4808);
    freq.put(" El", 5523);
    freq.put(" En", 12351);
    freq.put(" Ed", 3453);
    freq.put(" Eu", 5425);
    freq.put("ny ", 3572);
    freq.put(" Er", 5935);
    freq.put("ttn", 5259);
    freq.put("cke", 18899);
    freq.put("ure", 6299);
    freq.put("urg", 5379);
    freq.put("cka", 6286);
    freq.put("mus", 13621);
    freq.put("ckl", 6273);
    freq.put("urn", 5209);
    freq.put("ckn", 5609);
    freq.put("ckh", 12838);
    freq.put("cks", 6976);
    freq.put("urs", 7342);
    freq.put("hn", 5105);
    freq.put("hl", 4048);
    freq.put("Cha", 4718);
    freq.put("ibe", 3733);
    freq.put("eda", 22012);
    freq.put("nge", 55986);
    freq.put("nga", 25508);
    freq.put("ngl", 9266);
    freq.put(" is", 5201);
    freq.put("jan", 14542);
    freq.put("ksd", 4444);
    freq.put("ksa", 5304);
    freq.put(" in", 71154);
    freq.put("ngs", 25507);
    freq.put(" id", 4924);
    freq.put("lsk", 12154);
    freq.put("tbo", 6832);
    freq.put("a\u0308vl", 6172);
    freq.put("qu", 3576);
    freq.put("a\u0308ve", 13254);
    freq.put("h", 549646);
    freq.put("tti", 9635);
    freq.put("ks ", 3388);
    freq.put(" i ", 270663);
    freq.put("shi", 4912);
    freq.put("ja ", 4918);
    freq.put("sho", 4590);
    freq.put("Pr", 8839);
    freq.put("ebo", 7090);
    freq.put("C", 71198);
    freq.put("ke ", 13529);
    freq.put("Pa", 14568);
    freq.put("ebr", 11024);
    freq.put("Pe", 11351);
    freq.put("ede", 13539);
    freq.put("Pi", 4124);
    freq.put("Po", 7593);
    freq.put("nga\u030a", 3281);
    freq.put("dla", 5392);
    freq.put("lut", 8771);
    freq.put("ome", 9673);
    freq.put("dle", 5138);
    freq.put("dli", 4421);
    freq.put("ksa\u030a", 3945);
    freq.put("et ", 167149);
    freq.put("a\u030ar ", 24938);
    freq.put("omi", 4970);
    freq.put("lun", 3206);
    freq.put("ken", 19496);
    freq.put("jor", 7802);
    freq.put("da\u030a", 7895);
    freq.put("S", 183432);
    freq.put("omm", 30299);
    freq.put("key", 3901);
    freq.put("dju", 3500);
    freq.put("ket", 13180);
    freq.put("kes", 3520);
    freq.put("ker", 29895);
    freq.put("etr", 3912);
    freq.put("ets", 17582);
    freq.put("ett", 72343);
    freq.put("ety", 4212);
    freq.put("a\u030ard", 7005);
    freq.put("a\u030are", 4622);
    freq.put("tla", 6760);
    freq.put("eta", 15891);
    freq.put("ete", 27600);
    freq.put("tli", 6668);
    freq.put("eti", 4494);
    freq.put("uts", 5227);
    freq.put("ck", 84782);
    freq.put("ci", 26831);
    freq.put("ch", 224513);
    freq.put("co", 13763);
    freq.put("va\u030a", 20606);
    freq.put("Her", 3363);
    freq.put(" Fo\u0308", 6755);
    freq.put("ot ", 11261);
    freq.put("ca", 14258);
    freq.put("rva", 5265);
    freq.put("ce", 44300);
    freq.put("edi", 6332);
    freq.put("uce", 4932);
    freq.put("Hel", 4484);
    freq.put("cu", 4292);
    freq.put("ct", 5938);
    freq.put("a\u030ana", 9220);
    freq.put("ag", 71089);
    freq.put("a\u030ang", 25948);
    freq.put("bbe", 3314);
    freq.put("ai", 14768);
    freq.put("rvi", 3304);
    freq.put("oto", 5671);
    freq.put("ota", 4879);
    freq.put("otb", 6812);
    freq.put("c ", 6962);
    freq.put("ote", 5241);
    freq.put("oha", 5651);
    freq.put("va\u0308r", 10896);
    freq.put("ins", 22420);
    freq.put("ott", 18376);
    freq.put("a\u030an ", 40117);
    freq.put("na\u0308m", 4493);
    freq.put("ndr", 19487);
    freq.put("e\u0301", 11827);
    freq.put("edl", 4748);
    freq.put("va\u0308x", 7295);
    freq.put("na\u0308s", 3945);
    freq.put("na\u0308r", 11567);
    freq.put("ya ", 3709);
    freq.put("yst", 7068);
    freq.put("va", 154942);
    freq.put(" Fr", 15807);
    freq.put("vd", 3502);
    freq.put("ve", 165060);
    freq.put("vi", 89468);
    freq.put("vl", 8639);
    freq.put("vn", 4095);
    freq.put("vo", 9064);
    freq.put(" Fa", 6390);
    freq.put("vr", 3344);
    freq.put("vs", 16546);
    freq.put("vt", 4439);
    freq.put("vu", 11778);
    freq.put(" Fi", 8815);
    freq.put("ave", 5436);
    freq.put("ava", 3381);
    freq.put(" Fo", 6382);
    freq.put("io ", 6788);
    freq.put("of ", 8033);
    freq.put("pis", 3811);
    freq.put("edr", 4279);
    freq.put("dam", 6624);
    freq.put("une", 3661);
    freq.put("v ", 145502);
    freq.put(" TV", 4398);
    freq.put("ion", 60198);
    freq.put("uni", 16744);
    freq.put("av ", 125744);
    freq.put("ont", 10940);
    freq.put("off", 4118);
    freq.put(" Ty", 4268);
    freq.put("ofe", 5148);
    freq.put("i", 1975038);
    freq.put(" Tu", 3571);
    freq.put(" Tr", 7389);
    freq.put(" To", 8642);
    freq.put(" Ti", 6347);
    freq.put(" Th", 13403);
    freq.put(" Te", 8213);
    freq.put(" Ta", 5840);
    freq.put("xem", 4510);
    freq.put("mpe", 6539);
    freq.put("nov", 9987);
    freq.put("sku", 3455);
    freq.put("Be", 16801);
    freq.put("tt ", 116227);
    freq.put("ads", 8986);
    freq.put("skr", 17282);
    freq.put("Bl", 4691);
    freq.put("Bo", 13961);
    freq.put("sky", 3403);
    freq.put("Bi", 5634);
    freq.put("ske", 8526);
    freq.put("Bu", 5535);
    freq.put("ade", 78504);
    freq.put("ska", 106537);
    freq.put("Br", 13255);
    freq.put("ada", 3703);
    freq.put("skl", 5724);
    freq.put("sko", 16207);
    freq.put("adm", 3257);
    freq.put("ski", 13633);
    freq.put("adi", 7918);
    freq.put(" mo\u0308", 3254);
    freq.put("T", 73345);
    freq.put("B ", 3976);
    freq.put("sk ", 90513);
    freq.put("ad ", 44388);
    freq.put("ts ", 26900);
    freq.put("mfo\u0308", 3853);
    freq.put("est", 29943);
    freq.put("ess", 19229);
    freq.put("esp", 9596);
    freq.put("nd ", 63041);
    freq.put("ska\u030a", 7923);
    freq.put("ese", 7369);
    freq.put("esk", 4221);
    freq.put("esi", 7482);
    freq.put("Up", 4420);
    freq.put("o\u0308m ", 3264);
    freq.put("lho\u0308", 4242);
    freq.put("vs ", 5015);
    freq.put("nva\u030a", 8371);
    freq.put("Un", 6136);
    freq.put("ndi", 11752);
    freq.put("Sch", 3849);
    freq.put("ndo", 7016);
    freq.put(" ju", 20755);
    freq.put("nde", 95443);
    freq.put("US", 9839);
    freq.put(" jo", 4366);
    freq.put("kri", 26131);
    freq.put("by ", 6960);
    freq.put("es ", 68641);
    freq.put("nds", 29703);
    freq.put("kra", 8741);
    freq.put(" ja", 13806);
    freq.put("kre", 6291);
    freq.put("o\u0308d", 115283);
    freq.put("o\u0308g", 10789);
    freq.put("ea ", 3260);
    freq.put("o\u0308j", 4231);
    freq.put("o\u0308k", 5353);
    freq.put("o\u0308l", 7954);
    freq.put("o\u0308m", 7511);
    freq.put("o\u0308n", 13721);
    freq.put("o\u0308p", 9470);
    freq.put("o\u0308r", 194602);
    freq.put("o\u0308s", 15048);
    freq.put("o\u0308t", 11908);
    freq.put("o\u0308v", 17529);
    freq.put("go\u0308r", 5454);
    freq.put("De ", 4186);
    freq.put("h ", 210556);
    freq.put("yrk", 11273);
    freq.put("van", 15891);
    freq.put("val", 12123);
    freq.put("na\u030ag", 4585);
    freq.put("tg", 11122);
    freq.put("var", 99905);
    freq.put("vat", 6662);
    freq.put("o\u0308 ", 8541);
    freq.put("hy", 3755);
    freq.put("ean", 3203);
    freq.put("bur", 4739);
    freq.put("Det", 11763);
    freq.put("ht", 5130);
    freq.put("hu", 27638);
    freq.put("hj", 3586);
    freq.put("hi", 28029);
    freq.put("bun", 4581);
    freq.put("ho", 40609);
    freq.put("Den", 16516);
    freq.put("bum", 12276);
    freq.put("ha", 96551);
    freq.put("eat", 4659);
    freq.put("he", 67749);
    freq.put("dmi", 3679);
    freq.put("va ", 9694);
    freq.put("j", 171593);
    freq.put("lve", 7060);
    freq.put("lva", 3742);
    freq.put("rri", 6493);
    freq.put("pin", 6560);
    freq.put("int", 17796);
    freq.put("inv", 10239);
    freq.put(" US", 9725);
    freq.put("inl", 6319);
    freq.put("lm ", 18320);
    freq.put("inn", 24862);
    freq.put("ino", 16003);
    freq.put("ini", 12277);
    freq.put("ink", 4368);
    freq.put("ind", 16350);
    freq.put("ine", 12860);
    freq.put("inf", 4654);
    freq.put("ing", 135978);
    freq.put("ina", 18896);
    freq.put(" Up", 4407);
    freq.put(" Un", 6118);
    freq.put("or ", 33039);
    freq.put("sva", 8262);
    freq.put("ho\u0308", 19038);
    freq.put("gar", 34878);
    freq.put("U", 32439);
    freq.put("ubb", 6201);
    freq.put("ubl", 5383);
    freq.put("in ", 36372);
    freq.put("Mar", 11224);
    freq.put("ha\u0308", 12770);
    freq.put("ha\u030a", 8698);
    freq.put("eor", 5154);
    freq.put("o ", 47987);
  }
  
}

