package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class SQ extends CLangProfile {
  private static final String name = "sq";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public SQ() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 1760559;
    n_words[1] = 2076420;
    n_words[2] = 1518161;

    freq.put(" ke\u0308", 1907);
    freq.put("up ", 226);
    freq.put("aut", 366);
    freq.put("iu ", 213);
    freq.put(" Gu", 204);
    freq.put(" Gr", 579);
    freq.put("til", 200);
    freq.put("ejt", 732);
    freq.put(" Ga", 321);
    freq.put(" Go", 206);
    freq.put(" Gj", 1228);
    freq.put("Gu", 206);
    freq.put("Gr", 581);
    freq.put("upi", 325);
    freq.put("e\u0308", 138684);
    freq.put("Ga", 322);
    freq.put("Go", 208);
    freq.put("upt", 364);
    freq.put("Gj", 1228);
    freq.put(" ka", 3973);
    freq.put("me ", 7511);
    freq.put(" ke", 222);
    freq.put(" ki", 698);
    freq.put(" ko", 4104);
    freq.put(" kl", 275);
    freq.put(" km", 370);
    freq.put(" kr", 2025);
    freq.put(" ku", 2373);
    freq.put(" ky", 232);
    freq.put("nen", 1014);
    freq.put("kut", 329);
    freq.put("kus", 201);
    freq.put("kur", 1434);
    freq.put("kup", 473);
    freq.put("kun", 397);
    freq.put("kul", 958);
    freq.put("nez", 219);
    freq.put("nev", 297);
    freq.put("kuf", 336);
    freq.put("net", 653);
    freq.put("ak ", 563);
    freq.put("ner", 340);
    freq.put("nes", 253);
    freq.put("kua", 615);
    freq.put("med", 203);
    freq.put("mel", 355);
    freq.put("men", 1333);
    freq.put("met", 1333);
    freq.put("mev", 393);
    freq.put("mes", 776);
    freq.put("mer", 1044);
    freq.put("dry", 602);
    freq.put("gli", 277);
    freq.put("lmi", 262);
    freq.put("aks", 181);
    freq.put("k", 46937);
    freq.put("\u30a2\u30a2\u30a2", 185);
    freq.put("aku", 485);
    freq.put("akt", 1546);
    freq.put("dri", 384);
    freq.put("aki", 184);
    freq.put("ako", 591);
    freq.put("dro", 361);
    freq.put("dra", 292);
    freq.put("aka", 205);
    freq.put("dre", 608);
    freq.put("der", 1468);
    freq.put("ake", 288);
    freq.put("ku ", 990);
    freq.put("tu", 7405);
    freq.put("Kom", 428);
    freq.put("Kon", 248);
    freq.put("ori", 2679);
    freq.put("bri", 501);
    freq.put("tia", 238);
    freq.put("Kos", 1014);
    freq.put("Kor", 248);
    freq.put("bra", 276);
    freq.put("m ", 4929);
    freq.put("e\u0308rs", 761);
    freq.put("ene\u0308", 512);
    freq.put("er ", 1621);
    freq.put("ni ", 1941);
    freq.put("Sta", 228);
    freq.put("rip", 239);
    freq.put("V", 1916);
    freq.put("ove\u0308", 1008);
    freq.put("iv", 2165);
    freq.put("me", 13242);
    freq.put("xha", 211);
    freq.put("ma", 6825);
    freq.put("ltu", 283);
    freq.put("err", 624);
    freq.put("mb", 3911);
    freq.put("mo", 2299);
    freq.put("mi", 11206);
    freq.put("mj", 687);
    freq.put("mu", 2606);
    freq.put("mt", 825);
    freq.put("erg", 266);
    freq.put("mp", 1128);
    freq.put("ms", 189);
    freq.put("mr", 960);
    freq.put("erm", 871);
    freq.put("ern", 432);
    freq.put("ero", 390);
    freq.put("eri", 4116);
    freq.put("Lig", 189);
    freq.put("La", 432);
    freq.put("Lo", 267);
    freq.put("uar", 4550);
    freq.put("la ", 1588);
    freq.put("Li", 756);
    freq.put("Lu", 465);
    freq.put("ual", 287);
    freq.put("uan", 427);
    freq.put("ena", 430);
    freq.put("enc", 779);
    freq.put("end", 3296);
    freq.put("ene", 497);
    freq.put("eni", 647);
    freq.put("enj", 342);
    freq.put("Kal", 215);
    freq.put("Kar", 206);
    freq.put("ens", 203);
    freq.put("hor", 539);
    freq.put("hoq", 360);
    freq.put("e\u0308rt", 763);
    freq.put("A", 5867);
    freq.put("lam", 463);
    freq.put("lan", 809);
    freq.put("faq", 704);
    freq.put("mpj", 180);
    freq.put("ova", 484);
    freq.put("ove", 273);
    freq.put("lat", 987);
    freq.put("ua ", 660);
    freq.put("lav", 342);
    freq.put(" C\u0327m", 287);
    freq.put("lar", 790);
    freq.put("las", 448);
    freq.put("en ", 3312);
    freq.put("Ka ", 178);
    freq.put("me\u0308", 7228);
    freq.put("ere\u0308", 1553);
    freq.put("zan", 199);
    freq.put(" e\u0308s", 7645);
    freq.put(" Hi", 261);
    freq.put(" Ho", 278);
    freq.put("zet", 248);
    freq.put(" Ha", 528);
    freq.put(" He", 302);
    freq.put("zak", 278);
    freq.put("ima", 293);
    freq.put("fis", 186);
    freq.put("ime", 1522);
    freq.put("fit", 614);
    freq.put("imi", 5114);
    freq.put("imo", 407);
    freq.put("imt", 634);
    freq.put("fik", 505);
    freq.put("fin", 217);
    freq.put("fil", 1245);
    freq.put("re\u0308", 7665);
    freq.put(" Va", 291);
    freq.put("ze ", 310);
    freq.put(" Ve", 411);
    freq.put(" Vi", 293);
    freq.put("nte\u0308", 218);
    freq.put("pju", 181);
    freq.put("one", 812);
    freq.put("im ", 2164);
    freq.put("den", 513);
    freq.put("l", 52723);
    freq.put("ise\u0308", 2854);
    freq.put("hqi", 3061);
    freq.put("nt ", 562);
    freq.put("rt", 4337);
    freq.put("ru", 3266);
    freq.put(" zo", 209);
    freq.put("gon", 186);
    freq.put("rp", 488);
    freq.put("rq", 210);
    freq.put("rr", 4311);
    freq.put("rs", 2938);
    freq.put("ime\u0308", 180);
    freq.put(" za", 245);
    freq.put("ry", 2015);
    freq.put(" zb", 179);
    freq.put("rd", 2048);
    freq.put("re", 16088);
    freq.put("rf", 941);
    freq.put("rg", 2062);
    freq.put(" zy", 211);
    freq.put("ra", 14927);
    freq.put("rb", 1536);
    freq.put("ajo", 282);
    freq.put("rl", 428);
    freq.put("aja", 239);
    freq.put("rn", 818);
    freq.put("is ", 537);
    freq.put("rh", 205);
    freq.put("ri", 20960);
    freq.put("gos", 180);
    freq.put("gor", 539);
    freq.put("nia", 391);
    freq.put("ntr", 261);
    freq.put("nti", 1877);
    freq.put("W", 518);
    freq.put("nta", 460);
    freq.put("nte", 1912);
    freq.put("ate", 982);
    freq.put("ata", 707);
    freq.put("ato", 1090);
    freq.put("ist", 3511);
    freq.put("isi", 327);
    freq.put("ish", 5381);
    freq.put("atr", 379);
    freq.put("aj ", 1938);
    freq.put("isa", 571);
    freq.put(" Sp", 261);
    freq.put("ise", 279);
    freq.put("aty", 276);
    freq.put("ukt", 232);
    freq.put("nis", 1563);
    freq.put("oqe\u0308", 260);
    freq.put("e\u0308he", 440);
    freq.put("ale\u0308", 446);
    freq.put("tor", 3712);
    freq.put("eqi", 478);
    freq.put("tok", 323);
    freq.put("toh", 424);
    freq.put("ton", 869);
    freq.put("tol", 198);
    freq.put("tom", 222);
    freq.put("kt ", 208);
    freq.put(" le", 585);
    freq.put("B", 4180);
    freq.put(" la", 1142);
    freq.put(" lo", 338);
    freq.put(" ll", 324);
    freq.put(" li", 3581);
    freq.put(" lu", 944);
    freq.put("Ser", 197);
    freq.put("ktu", 532);
    freq.put("ktr", 411);
    freq.put("kto", 809);
    freq.put("kth", 196);
    freq.put("kti", 608);
    freq.put("kte", 440);
    freq.put("to ", 593);
    freq.put("raf", 580);
    freq.put("rad", 1584);
    freq.put("rab", 220);
    freq.put("ran", 2020);
    freq.put("ths", 192);
    freq.put("ral", 554);
    freq.put("ram", 546);
    freq.put("raj", 258);
    freq.put("rak", 530);
    freq.put("rah", 340);
    freq.put("rav", 877);
    freq.put("rat", 1584);
    freq.put("ras", 547);
    freq.put("rap", 224);
    freq.put("raq", 331);
    freq.put("e\u0308rd", 700);
    freq.put("\u30a2", 259);
    freq.put("do ", 585);
    freq.put("rse", 194);
    freq.put("on ", 2800);
    freq.put("ra ", 3887);
    freq.put("qyt", 799);
    freq.put(" le\u0308", 638);
    freq.put("y", 8479);
    freq.put("Qe", 273);
    freq.put("za ", 311);
    freq.put("tyr", 784);
    freq.put("abe", 271);
    freq.put("dok", 214);
    freq.put("don", 593);
    freq.put("dom", 180);
    freq.put("m", 56721);
    freq.put("dod", 448);
    freq.put("Ita", 196);
    freq.put("dor", 1271);
    freq.put("dos", 301);
    freq.put("d ", 2270);
    freq.put(" Wi", 198);
    freq.put("je\u0308 ", 6765);
    freq.put("udh", 352);
    freq.put("oci", 316);
    freq.put("em ", 322);
    freq.put("hro", 441);
    freq.put("ire\u0308", 662);
    freq.put("sur", 369);
    freq.put("do", 4139);
    freq.put("dm", 281);
    freq.put("dj", 1045);
    freq.put("dh", 17111);
    freq.put("di", 8348);
    freq.put("de", 5126);
    freq.put("je\u0308r", 345);
    freq.put("da", 2581);
    freq.put("dy", 756);
    freq.put("X", 569);
    freq.put("du", 2130);
    freq.put("dr", 2528);
    freq.put("ds", 204);
    freq.put("eme", 707);
    freq.put("bar", 627);
    freq.put("bas", 738);
    freq.put("emb", 225);
    freq.put("emo", 232);
    freq.put("baz", 296);
    freq.put("ile\u0308", 642);
    freq.put("emr", 507);
    freq.put("ban", 768);
    freq.put("une\u0308", 434);
    freq.put("baj", 338);
    freq.put("koh", 623);
    freq.put("w ", 197);
    freq.put("Per", 268);
    freq.put("num", 496);
    freq.put("nuk", 387);
    freq.put("qe\u0308s", 313);
    freq.put("qe\u0308r", 295);
    freq.put("nua", 315);
    freq.put("il ", 230);
    freq.put("mur", 234);
    freq.put("muz", 308);
    freq.put("un ", 316);
    freq.put("iri", 583);
    freq.put("mua", 310);
    freq.put("iro", 194);
    freq.put("ira", 796);
    freq.put("mun", 1237);
    freq.put("ire", 227);
    freq.put("omb", 682);
    freq.put("C", 1638);
    freq.put("de\u0308", 2976);
    freq.put("wa", 196);
    freq.put("omi", 782);
    freq.put(" Is", 478);
    freq.put(" It", 205);
    freq.put("omp", 538);
    freq.put(" In", 442);
    freq.put("kom", 1483);
    freq.put("ile", 229);
    freq.put("ell", 702);
    freq.put("ila", 1202);
    freq.put("ilo", 291);
    freq.put("ill", 1867);
    freq.put("ilm", 536);
    freq.put("ilj", 319);
    freq.put("eme\u0308", 345);
    freq.put("ili", 1491);
    freq.put("una", 206);
    freq.put("und", 1633);
    freq.put("ir ", 232);
    freq.put("uni", 521);
    freq.put(" me", 6491);
    freq.put(" ma", 2979);
    freq.put(" mb", 1927);
    freq.put("saj", 699);
    freq.put(" mo", 751);
    freq.put(" mi", 1023);
    freq.put(" mj", 371);
    freq.put(" mu", 1092);
    freq.put("ic\u0327", 252);
    freq.put("san", 214);
    freq.put("fra", 187);
    freq.put("dhe\u0308", 1093);
    freq.put("fri", 223);
    freq.put("C ", 177);
    freq.put("mbu", 225);
    freq.put("ai ", 361);
    freq.put("Ch", 193);
    freq.put("Co", 247);
    freq.put("Ca", 335);
    freq.put("n", 113931);
    freq.put("the\u0308", 407);
    freq.put("sla", 211);
    freq.put("pe\u0308r", 8954);
    freq.put("pe\u0308s", 324);
    freq.put("iz", 2757);
    freq.put("rtu", 307);
    freq.put("iq", 788);
    freq.put("ip", 5685);
    freq.put("is", 14282);
    freq.put("ir", 3308);
    freq.put("iu", 865);
    freq.put("it", 23622);
    freq.put(" me\u0308", 4730);
    freq.put("ih", 920);
    freq.put("ik", 8974);
    freq.put("ij", 2183);
    freq.put("im", 10832);
    freq.put("il", 7041);
    freq.put("io", 3678);
    freq.put("in", 18975);
    freq.put("ia", 5265);
    freq.put("ic", 1580);
    freq.put("ib", 803);
    freq.put("ie", 1546);
    freq.put("id", 1902);
    freq.put("ig", 1500);
    freq.put("if", 611);
    freq.put("dhj", 875);
    freq.put("dhi", 1463);
    freq.put("dhe", 12079);
    freq.put("dha", 308);
    freq.put("dhu", 653);
    freq.put("th ", 586);
    freq.put("nik", 917);
    freq.put("nin", 724);
    freq.put("nim", 624);
    freq.put("kis", 422);
    freq.put("nic", 209);
    freq.put("kip", 221);
    freq.put("nie", 218);
    freq.put("niz", 506);
    freq.put("pe\u0308 ", 222);
    freq.put("kin", 237);
    freq.put("kim", 794);
    freq.put("Y", 251);
    freq.put("i ", 33796);
    freq.put("niv", 445);
    freq.put("nit", 1162);
    freq.put("Va", 291);
    freq.put("Ve", 412);
    freq.put("sme", 323);
    freq.put("Vi", 295);
    freq.put("thu", 272);
    freq.put("epu", 459);
    freq.put("epr", 500);
    freq.put("dh ", 431);
    freq.put("tho", 197);
    freq.put("thi", 467);
    freq.put("the", 828);
    freq.put("epe", 182);
    freq.put("tha", 760);
    freq.put("vic", 177);
    freq.put("yeq", 202);
    freq.put("yes", 421);
    freq.put("yer", 268);
    freq.put("ice\u0308", 252);
    freq.put("eli", 682);
    freq.put("ham", 267);
    freq.put("han", 292);
    freq.put("ela", 426);
    freq.put("ele", 1238);
    freq.put("hap", 354);
    freq.put("har", 380);
    freq.put("has", 365);
    freq.put("hat", 909);
    freq.put("ume\u0308", 772);
    freq.put("elu", 266);
    freq.put("opu", 565);
    freq.put("D", 2951);
    freq.put("rne", 248);
    freq.put("ope", 206);
    freq.put("jyr", 194);
    freq.put("opo", 219);
    freq.put("opi", 438);
    freq.put("sma", 252);
    freq.put("Art", 179);
    freq.put("vis", 321);
    freq.put("ha ", 1068);
    freq.put("el ", 689);
    freq.put("vdi", 416);
    freq.put("ola", 251);
    freq.put("zim", 386);
    freq.put("ole", 276);
    freq.put(" Ju", 322);
    freq.put("oli", 1087);
    freq.put("oll", 1071);
    freq.put("olo", 874);
    freq.put(" Jo", 291);
    freq.put(" Je", 182);
    freq.put(" Ja", 384);
    freq.put("bre", 593);
    freq.put("ele\u0308", 206);
    freq.put("ici", 344);
    freq.put("ich", 192);
    freq.put("for", 1268);
    freq.put("umr", 331);
    freq.put("ica", 291);
    freq.put("ume", 412);
    freq.put("Hi", 261);
    freq.put("uma", 183);
    freq.put("Ho", 278);
    freq.put("umb", 309);
    freq.put("Ha", 528);
    freq.put("umi", 458);
    freq.put("He", 303);
    freq.put("ol ", 185);
    freq.put(" Xh", 218);
    freq.put("hsh", 200);
    freq.put("pla", 231);
    freq.put("plo", 258);
    freq.put("ope\u0308", 263);
    freq.put("obe", 363);
    freq.put("o", 70925);
    freq.put("zua", 506);
    freq.put("mbl", 257);
    freq.put("mbi", 849);
    freq.put("mbe", 401);
    freq.put("ahi", 215);
    freq.put("mba", 779);
    freq.put("son", 618);
    freq.put("sor", 814);
    freq.put("sot", 202);
    freq.put("sov", 1143);
    freq.put("b ", 407);
    freq.put("mbr", 294);
    freq.put("tem", 772);
    freq.put("ne\u0308", 24491);
    freq.put("gim", 207);
    freq.put("iq ", 474);
    freq.put(" ne\u0308", 16417);
    freq.put("ohe\u0308", 394);
    freq.put("Z", 898);
    freq.put("azh", 332);
    freq.put("azi", 334);
    freq.put("aze", 285);
    freq.put("mta", 664);
    freq.put("mbe\u0308", 676);
    freq.put("E\u0308sh", 295);
    freq.put("qit", 232);
    freq.put("qip", 2962);
    freq.put("qis", 408);
    freq.put("ni", 9080);
    freq.put("nj", 10024);
    freq.put("nk", 623);
    freq.put("nn", 299);
    freq.put("no", 2581);
    freq.put("tit", 3342);
    freq.put("na", 4803);
    freq.put("tiv", 962);
    freq.put("nc", 1647);
    freq.put("nd", 14065);
    freq.put("ne", 6011);
    freq.put("nf", 360);
    freq.put("ng", 8085);
    freq.put("nx", 351);
    freq.put("ny", 268);
    freq.put("tin", 4094);
    freq.put("tio", 325);
    freq.put("tij", 916);
    freq.put("tik", 1967);
    freq.put("ns", 1390);
    freq.put("nt", 6015);
    freq.put("nu", 1486);
    freq.put(" ni", 252);
    freq.put(" nj", 8261);
    freq.put("E", 2593);
    freq.put(" no", 407);
    freq.put(" na", 398);
    freq.put(" ne", 1135);
    freq.put(" nd", 3078);
    freq.put(" ng", 5742);
    freq.put(" nu", 833);
    freq.put("aze\u0308", 204);
    freq.put("n ", 21363);
    freq.put("rk ", 231);
    freq.put("ti ", 2991);
    freq.put("nxh", 177);
    freq.put("roh", 382);
    freq.put("roi", 191);
    freq.put("roj", 419);
    freq.put("rok", 233);
    freq.put("rol", 305);
    freq.put("rom", 357);
    freq.put("ron", 1148);
    freq.put("lls", 213);
    freq.put("roc", 243);
    freq.put("hte\u0308", 9010);
    freq.put("ost", 299);
    freq.put("rof", 239);
    freq.put("rog", 307);
    freq.put("osh", 522);
    freq.put("lli", 2212);
    freq.put("llo", 1314);
    freq.put("oso", 1152);
    freq.put("rop", 794);
    freq.put("ror", 1129);
    freq.put("ros", 215);
    freq.put("rot", 314);
    freq.put("rov", 207);
    freq.put("vet", 682);
    freq.put("ver", 1289);
    freq.put("vep", 456);
    freq.put("di ", 1814);
    freq.put("ven", 1374);
    freq.put("vel", 341);
    freq.put(" do", 799);
    freq.put("ro ", 340);
    freq.put("os ", 591);
    freq.put("ll ", 881);
    freq.put("dim", 1054);
    freq.put("din", 518);
    freq.put("dio", 362);
    freq.put("eke\u0308", 226);
    freq.put("dik", 388);
    freq.put("ers", 1252);
    freq.put("dia", 304);
    freq.put("gul", 267);
    freq.put("gus", 310);
    freq.put("p", 40169);
    freq.put("ve ", 7283);
    freq.put("dit", 1503);
    freq.put(" de", 1917);
    freq.put("dis", 945);
    freq.put("hte", 3639);
    freq.put("hta", 810);
    freq.put("ufi", 398);
    freq.put("Rep", 364);
    freq.put("htj", 309);
    freq.put("hti", 611);
    freq.put("lle\u0308", 931);
    freq.put("htu", 748);
    freq.put("Gre", 313);
    freq.put("htr", 565);
    freq.put("ke\u0308 ", 735);
    freq.put("hty", 181);
    freq.put("ere", 548);
    freq.put("ek ", 360);
    freq.put("vec\u0327", 250);
    freq.put("era", 1561);
    freq.put("Me", 757);
    freq.put("rua", 870);
    freq.put("Ma", 1783);
    freq.put("erb", 418);
    freq.put("ht ", 2187);
    freq.put("ke\u0308t", 1025);
    freq.put("Mo", 476);
    freq.put("Mi", 743);
    freq.put("ke\u0308s", 1506);
    freq.put("ke\u0308r", 189);
    freq.put("Mu", 398);
    freq.put("ke\u0308n", 763);
    freq.put("O", 1229);
    freq.put(" du", 817);
    freq.put("eko", 404);
    freq.put("ekn", 209);
    freq.put("eki", 248);
    freq.put("bot", 888);
    freq.put("eka", 189);
    freq.put("bol", 404);
    freq.put("eku", 676);
    freq.put("ekt", 1016);
    freq.put("eks", 618);
    freq.put("ipa", 1258);
    freq.put("uzi", 400);
    freq.put("ipe", 572);
    freq.put("jar", 261);
    freq.put("ipi", 226);
    freq.put("Le", 440);
    freq.put("ipt", 1558);
    freq.put("sh ", 1239);
    freq.put(" Ka", 1328);
    freq.put("ngu", 279);
    freq.put(" Kj", 278);
    freq.put(" Ki", 237);
    freq.put(" Ko", 2406);
    freq.put(" Kr", 523);
    freq.put("rve", 228);
    freq.put(" Ku", 622);
    freq.put("ca ", 491);
    freq.put("ip ", 230);
    freq.put("ngr", 213);
    freq.put("F", 3211);
    freq.put("Ber", 210);
    freq.put("Evr", 427);
    freq.put("cav", 177);
    freq.put("ult", 579);
    freq.put("se\u0308", 6850);
    freq.put("uli", 199);
    freq.put("ull", 1873);
    freq.put("ibr", 249);
    freq.put("ula", 307);
    freq.put("sje", 269);
    freq.put("one\u0308", 412);
    freq.put("Min", 180);
    freq.put(" of", 214);
    freq.put("ipe\u0308", 1386);
    freq.put("ma ", 556);
    freq.put("spo", 232);
    freq.put(" or", 779);
    freq.put(" os", 1270);
    freq.put(" Ke\u0308", 300);
    freq.put("s ", 14264);
    freq.put("mas", 295);
    freq.put("mar", 852);
    freq.put("mat", 1185);
    freq.put("rm", 3136);
    freq.put("Fja", 191);
    freq.put("ky ", 230);
    freq.put("mad", 655);
    freq.put("mak", 224);
    freq.put("maj", 406);
    freq.put("mal", 684);
    freq.put("man", 1367);
    freq.put("sy", 189);
    freq.put("ss", 508);
    freq.put("sq", 194);
    freq.put("sp", 784);
    freq.put("sv", 254);
    freq.put("su", 1269);
    freq.put("st", 7650);
    freq.put("q", 14863);
    freq.put("sj", 384);
    freq.put("si", 11685);
    freq.put("sh", 35309);
    freq.put("so", 3394);
    freq.put("sn", 215);
    freq.put("sm", 700);
    freq.put("sl", 488);
    freq.put("sc", 195);
    freq.put("sa", 3279);
    freq.put("se", 5448);
    freq.put("Ru", 267);
    freq.put("ro", 7859);
    freq.put("Rr", 230);
    freq.put("ec\u0327", 454);
    freq.put("no ", 251);
    freq.put("lsi", 217);
    freq.put("Re", 810);
    freq.put("Ra", 365);
    freq.put("Ro", 386);
    freq.put("Ri", 264);
    freq.put(" ad", 323);
    freq.put("e\u0308mb", 216);
    freq.put(" af", 314);
    freq.put("jin", 428);
    freq.put(" ai", 237);
    freq.put(" aj", 220);
    freq.put("jim", 228);
    freq.put(" al", 253);
    freq.put("jik", 319);
    freq.put("e\u0308mi", 309);
    freq.put("\u03b1", 259);
    freq.put(" ar", 1194);
    freq.put(" as", 478);
    freq.put(" at", 742);
    freq.put(" au", 397);
    freq.put("ent", 2477);
    freq.put("tja", 349);
    freq.put("Shq", 1268);
    freq.put("non", 199);
    freq.put("Sht", 446);
    freq.put("C\u0327", 673);
    freq.put("ert", 290);
    freq.put("ore\u0308", 1117);
    freq.put("sht", 17551);
    freq.put("nov", 244);
    freq.put("Shk", 524);
    freq.put("nor", 452);
    freq.put(" a ", 180);
    freq.put("ji ", 371);
    freq.put("e\u0308m ", 968);
    freq.put("em", 3767);
    freq.put("el", 4768);
    freq.put("eo", 855);
    freq.put("en", 13277);
    freq.put("ei", 482);
    freq.put("eh", 617);
    freq.put("ek", 4482);
    freq.put("ej", 2627);
    freq.put("ed", 3466);
    freq.put("eg", 2448);
    freq.put("ef", 474);
    freq.put("ea", 970);
    freq.put("ec", 617);
    freq.put("eb", 315);
    freq.put("ex", 233);
    freq.put("ez", 1764);
    freq.put("eu", 592);
    freq.put("et", 19558);
    freq.put("ew", 200);
    freq.put("ev", 3916);
    freq.put("eq", 1060);
    freq.put("ep", 1848);
    freq.put("es", 10616);
    freq.put("er", 15019);
    freq.put("eja", 234);
    freq.put(" E\u0308s", 295);
    freq.put("bli", 768);
    freq.put("ble", 244);
    freq.put("G", 3160);
    freq.put("ort", 629);
    freq.put("oru", 235);
    freq.put("orr", 382);
    freq.put("e ", 72317);
    freq.put(" i ", 9701);
    freq.put("orm", 1202);
    freq.put("shi", 1551);
    freq.put("org", 551);
    freq.put("ord", 255);
    freq.put("ore", 3570);
    freq.put("orc", 230);
    freq.put("ora", 318);
    freq.put("shk", 3709);
    freq.put("ej ", 1063);
    freq.put("vje", 622);
    freq.put("onj", 684);
    freq.put("xh", 647);
    freq.put("oni", 2539);
    freq.put("ono", 475);
    freq.put("ona", 1138);
    freq.put("ond", 187);
    freq.put("ane\u0308", 3784);
    freq.put("ons", 340);
    freq.put("zat", 320);
    freq.put("ont", 1418);
    freq.put("ial", 691);
    freq.put("ian", 1176);
    freq.put("uku", 221);
    freq.put("ve\u0308s", 631);
    freq.put("uke", 519);
    freq.put("hua", 438);
    freq.put("hul", 218);
    freq.put("hum", 1047);
    freq.put("x ", 256);
    freq.put("da ", 488);
    freq.put("hur", 1522);
    freq.put("ia ", 2790);
    freq.put("r", 123043);
    freq.put("ve\u0308 ", 592);
    freq.put("uk ", 422);
    freq.put("and", 1227);
    freq.put("ane", 1253);
    freq.put("ang", 643);
    freq.put("pra", 544);
    freq.put("ana", 956);
    freq.put("anc", 511);
    freq.put("pro", 1746);
    freq.put("ano", 603);
    freq.put("pri", 797);
    freq.put("ani", 2814);
    freq.put("anj", 226);
    freq.put("ant", 917);
    freq.put("le\u0308n", 745);
    freq.put("ans", 360);
    freq.put("sat", 207);
    freq.put("Do", 262);
    freq.put("rmi", 261);
    freq.put("Dh", 185);
    freq.put("Di", 445);
    freq.put("zoh", 205);
    freq.put("De", 624);
    freq.put("zon", 428);
    freq.put("Da", 377);
    freq.put("Du", 229);
    freq.put("Dr", 303);
    freq.put("an ", 2721);
    freq.put("sa ", 1426);
    freq.put(" Le", 440);
    freq.put(" La", 426);
    freq.put(" Lo", 267);
    freq.put(" Li", 748);
    freq.put(" Lu", 464);
    freq.put("mri", 623);
    freq.put("mra", 263);
    freq.put("rme\u0308", 369);
    freq.put("dy ", 376);
    freq.put("aqi", 214);
    freq.put("iti", 3696);
    freq.put("Wi", 200);
    freq.put("yte\u0308", 280);
    freq.put("jte\u0308", 442);
    freq.put("ser", 504);
    freq.put(" pr", 3527);
    freq.put(" pu", 708);
    freq.put("dyt", 203);
    freq.put("H", 1921);
    freq.put(" pa", 4231);
    freq.put(" pe", 1738);
    freq.put("je\u0308", 8682);
    freq.put("sse", 192);
    freq.put(" pj", 1282);
    freq.put(" pi", 398);
    freq.put(" po", 2196);
    freq.put(" pl", 373);
    freq.put("zhv", 458);
    freq.put(" be\u0308", 626);
    freq.put("uti", 207);
    freq.put("rmu", 349);
    freq.put("cio", 782);
    freq.put("uto", 619);
    freq.put("rmb", 202);
    freq.put("rma", 1098);
    freq.put("rme", 349);
    freq.put("tu ", 717);
    freq.put("cil", 2535);
    freq.put("j ", 4723);
    freq.put("rmo", 182);
    freq.put("e\u0308l ", 264);
    freq.put("jtu", 499);
    freq.put("jti", 303);
    freq.put("jtj", 180);
    freq.put("yte", 900);
    freq.put("jta", 181);
    freq.put("tur", 3146);
    freq.put("jy", 374);
    freq.put("jt", 2182);
    freq.put("ju", 2055);
    freq.put("jv", 200);
    freq.put("jr", 203);
    freq.put("js", 193);
    freq.put("jm", 201);
    freq.put("jn", 989);
    freq.put("jo", 2391);
    freq.put("tul", 217);
    freq.put("ji", 4180);
    freq.put(" pe\u0308", 7156);
    freq.put("je", 13383);
    freq.put("tud", 541);
    freq.put("ja", 7433);
    freq.put(" be", 279);
    freq.put("z", 11328);
    freq.put(" ba", 1617);
    freq.put("e\u0308ll", 356);
    freq.put(" bo", 1013);
    freq.put(" bi", 487);
    freq.put(" bu", 403);
    freq.put("fiz", 441);
    freq.put("s", 94347);
    freq.put(" br", 668);
    freq.put("jt ", 307);
    freq.put("hvi", 461);
    freq.put("poz", 244);
    freq.put("por", 810);
    freq.put("pos", 377);
    freq.put("pop", 489);
    freq.put("pon", 243);
    freq.put("pol", 674);
    freq.put("tua", 1367);
    freq.put("ge\u0308t", 303);
    freq.put("tue", 838);
    freq.put("ge\u0308l", 243);
    freq.put("po ", 983);
    freq.put("htm", 182);
    freq.put("uje\u0308", 192);
    freq.put("ge\u0308 ", 240);
    freq.put("ive", 1169);
    freq.put("iva", 248);
    freq.put("pje", 1425);
    freq.put("te\u0308m", 288);
    freq.put("ivi", 385);
    freq.put("oi ", 722);
    freq.put("te\u0308v", 188);
    freq.put("te\u0308t", 229);
    freq.put("te\u0308r", 1782);
    freq.put("te\u0308s", 1610);
    freq.put("te\u0308p", 239);
    freq.put("oku", 205);
    freq.put("Bas", 348);
    freq.put(" Me", 757);
    freq.put("par", 1922);
    freq.put("pas", 2622);
    freq.put("pat", 286);
    freq.put(" Ma", 1780);
    freq.put(" Mo", 474);
    freq.put(" Mi", 739);
    freq.put(" Mu", 395);
    freq.put("I ", 544);
    freq.put("pak", 267);
    freq.put("pan", 389);
    freq.put("e\u0308su", 202);
    freq.put("iv ", 257);
    freq.put("te\u0308 ", 32538);
    freq.put("I", 3066);
    freq.put("II", 206);
    freq.put("gru", 420);
    freq.put("eth", 892);
    freq.put("she\u0308", 1713);
    freq.put("ujt", 177);
    freq.put("Is", 481);
    freq.put("It", 205);
    freq.put("pa ", 427);
    freq.put("In", 443);
    freq.put(" qu", 416);
    freq.put(" qy", 665);
    freq.put("ch", 654);
    freq.put(" qe", 1420);
    freq.put("mpo", 182);
    freq.put("eze\u0308", 244);
    freq.put("tis", 395);
    freq.put("e\u0308se", 300);
    freq.put("tim", 1479);
    freq.put("de\u0308 ", 206);
    freq.put("e\u0308sa", 205);
    freq.put("ami", 877);
    freq.put("ama", 345);
    freq.put("mor", 732);
    freq.put("amb", 181);
    freq.put("ame", 814);
    freq.put("mon", 405);
    freq.put("amp", 346);
    freq.put("amu", 220);
    freq.put("le\u0308v", 248);
    freq.put("de\u0308r", 1831);
    freq.put("de\u0308s", 713);
    freq.put("gjy", 338);
    freq.put("e\u0308si", 2416);
    freq.put("gju", 704);
    freq.put("e\u0308sh", 8836);
    freq.put("t", 143796);
    freq.put("gji", 3096);
    freq.put("gje", 2061);
    freq.put("gja", 1196);
    freq.put("ezu", 183);
    freq.put("ate\u0308", 1708);
    freq.put("ezo", 208);
    freq.put("ezi", 227);
    freq.put("eze", 303);
    freq.put(" qe\u0308", 3732);
    freq.put("eza", 184);
    freq.put(" ci", 2530);
    freq.put("\u30a2\u30a2", 222);
    freq.put(" ca", 214);
    freq.put("o ", 4990);
    freq.put("ame\u0308", 284);
    freq.put("mpi", 353);
    freq.put("zit", 331);
    freq.put("qi ", 290);
    freq.put("ez ", 343);
    freq.put("ce\u0308 ", 308);
    freq.put("oo", 285);
    freq.put("on", 11462);
    freq.put("om", 4147);
    freq.put("ol", 4317);
    freq.put("ok", 1665);
    freq.put("oj", 2100);
    freq.put("oi", 918);
    freq.put("km ", 346);
    freq.put("og", 2207);
    freq.put("of", 894);
    freq.put("aci", 658);
    freq.put("od", 2400);
    freq.put("oc", 773);
    freq.put("ob", 841);
    freq.put("oa", 235);
    freq.put("gje\u0308", 270);
    freq.put("ov", 2272);
    freq.put("ou", 371);
    freq.put("ot", 2941);
    freq.put("os", 4887);
    freq.put("or", 15900);
    freq.put("oq", 456);
    freq.put("op", 2168);
    freq.put("Ni", 232);
    freq.put("bje", 222);
    freq.put("No", 435);
    freq.put("Na", 320);
    freq.put("Nd", 207);
    freq.put("Ne", 392);
    freq.put("ur ", 4520);
    freq.put("het", 2896);
    freq.put("heq", 210);
    freq.put("her", 715);
    freq.put("hes", 233);
    freq.put("loj", 558);
    freq.put("loi", 197);
    freq.put("lon", 395);
    freq.put("lor", 960);
    freq.put("lot", 202);
    freq.put("hel", 179);
    freq.put("hem", 522);
    freq.put("hen", 1147);
    freq.put("hej", 224);
    freq.put("hek", 391);
    freq.put("jua", 282);
    freq.put("jug", 449);
    freq.put("juh", 823);
    freq.put("J", 1447);
    freq.put("na ", 1164);
    freq.put("rje", 742);
    freq.put("jut", 199);
    freq.put("fsh", 1041);
    freq.put("as ", 2094);
    freq.put("he ", 11876);
    freq.put("re\u0308t", 460);
    freq.put("ac", 1088);
    freq.put("Ne\u0308", 821);
    freq.put("ae", 194);
    freq.put("ad", 3850);
    freq.put("ag", 1063);
    freq.put("af", 1439);
    freq.put("ai", 935);
    freq.put("ah", 884);
    freq.put("ak", 4327);
    freq.put("aj", 4288);
    freq.put("am", 3780);
    freq.put("al", 8585);
    freq.put("re\u0308z", 253);
    freq.put("an", 16760);
    freq.put("aq", 1562);
    freq.put("ap", 2172);
    freq.put("as", 8047);
    freq.put("ar", 20865);
    freq.put("au", 845);
    freq.put("at", 11806);
    freq.put("av", 2909);
    freq.put("ay", 236);
    freq.put("ohu", 860);
    freq.put("re\u0308n", 1295);
    freq.put("az", 1629);
    freq.put("igu", 244);
    freq.put("iga", 202);
    freq.put("igj", 563);
    freq.put("e\u0308s ", 6600);
    freq.put("a ", 28448);
    freq.put("rv", 415);
    freq.put("re\u0308 ", 3679);
    freq.put(" zh", 535);
    freq.put("at ", 2869);
    freq.put("u", 51367);
    freq.put(" zg", 360);
    freq.put("pto", 261);
    freq.put("alo", 479);
    freq.put("all", 1341);
    freq.put("pti", 317);
    freq.put("ali", 1967);
    freq.put("ajt", 819);
    freq.put("ale", 1756);
    freq.put("pta", 1447);
    freq.put("ala", 461);
    freq.put("eda", 183);
    freq.put("rre\u0308", 463);
    freq.put("alt", 205);
    freq.put("Fil", 198);
    freq.put("gr", 2543);
    freq.put("zmi", 236);
    freq.put("ty", 1124);
    freq.put("tt", 246);
    freq.put("ze\u0308", 930);
    freq.put("tr", 5518);
    freq.put("ts", 310);
    freq.put("to", 7414);
    freq.put("tm", 513);
    freq.put("tj", 1903);
    freq.put("th", 4122);
    freq.put("ti", 17731);
    freq.put("te", 16922);
    freq.put("tb", 272);
    freq.put("edh", 1894);
    freq.put("ta", 11255);
    freq.put("edi", 471);
    freq.put("rod", 677);
    freq.put("E\u0308", 504);
    freq.put("rc", 625);
    freq.put("be\u0308h", 244);
    freq.put("iud", 180);
    freq.put("al ", 1170);
    freq.put("edo", 295);
    freq.put("be\u0308t", 491);
    freq.put("fak", 216);
    freq.put("llu", 548);
    freq.put("be\u0308r", 688);
    freq.put("fam", 375);
    freq.put("iut", 194);
    freq.put(" re\u0308", 271);
    freq.put(" Ni", 229);
    freq.put("pre", 1386);
    freq.put(" Nj", 246);
    freq.put(" No", 435);
    freq.put(" Na", 320);
    freq.put(" Ne", 390);
    freq.put(" Nd", 206);
    freq.put("rj", 983);
    freq.put("ec\u0327a", 298);
    freq.put("rk", 1734);
    freq.put("t ", 30601);
    freq.put("tek", 589);
    freq.put("tel", 426);
    freq.put("ga", 7640);
    freq.put("ten", 475);
    freq.put("go", 1368);
    freq.put("ter", 1775);
    freq.put("tes", 527);
    freq.put("tet", 4737);
    freq.put("lla", 1048);
    freq.put("tev", 1136);
    freq.put("aba", 207);
    freq.put("sue", 178);
    freq.put(" Af", 185);
    freq.put("sua", 229);
    freq.put("ose", 1363);
    freq.put("te\u0308", 37539);
    freq.put(" ru", 213);
    freq.put("rbi", 290);
    freq.put(" rr", 1833);
    freq.put("te ", 5516);
    freq.put("K", 6663);
    freq.put("uhe\u0308", 641);
    freq.put(" re", 1537);
    freq.put("c\u0327an", 218);
    freq.put(" ra", 1563);
    freq.put("pub", 598);
    freq.put(" ro", 441);
    freq.put(" ri", 358);
    freq.put("Ne\u0308 ", 708);
    freq.put(" Ne\u0308", 821);
    freq.put(" Ar", 624);
    freq.put("rku", 392);
    freq.put("Ky ", 207);
    freq.put("nto", 514);
    freq.put("vin", 191);
    freq.put("vil", 586);
    freq.put("rke", 238);
    freq.put("Aut", 217);
    freq.put("vit", 3504);
    freq.put("viz", 481);
    freq.put("rko", 294);
    freq.put("rki", 195);
    freq.put("e\u0308n ", 3829);
    freq.put("te\u0308n", 440);
    freq.put("de ", 479);
    freq.put("Sp", 262);
    freq.put("Su", 265);
    freq.put("St", 538);
    freq.put("Sk", 218);
    freq.put("Si", 523);
    freq.put("Sh", 3256);
    freq.put("So", 375);
    freq.put("Sa", 579);
    freq.put("fe\u0308", 409);
    freq.put("Se", 537);
    freq.put("Pe\u0308r", 406);
    freq.put("kla", 195);
    freq.put(" di", 2033);
    freq.put(" dh", 10408);
    freq.put("e\u0308ng", 554);
    freq.put("e\u0308nd", 1225);
    freq.put("des", 314);
    freq.put("det", 819);
    freq.put(" da", 481);
    freq.put("e\u0308na", 195);
    freq.put("ege\u0308", 220);
    freq.put("dek", 243);
    freq.put("del", 210);
    freq.put("dem", 246);
    freq.put(" dy", 651);
    freq.put("v", 25346);
    freq.put("e\u0308nt", 362);
    freq.put(" dr", 678);
    freq.put("deg", 199);
    freq.put("f ", 429);
    freq.put("ati", 2851);
    freq.put("rye", 967);
    freq.put(" Fl", 194);
    freq.put("atu", 362);
    freq.put("r ", 22499);
    freq.put("jih", 193);
    freq.put("rys", 615);
    freq.put("fr", 816);
    freq.put("fs", 1052);
    freq.put("ft", 1033);
    freq.put("fu", 1400);
    freq.put("fa", 1842);
    freq.put("fe", 1185);
    freq.put("fi", 3904);
    freq.put("fj", 347);
    freq.put("fl", 382);
    freq.put("fo", 1696);
    freq.put("a", 127255);
    freq.put("us ", 390);
    freq.put(" de\u0308", 296);
    freq.put("e\u0308ne\u0308", 345);
    freq.put("hke\u0308", 454);
    freq.put("egu", 355);
    freq.put("egj", 763);
    freq.put("ego", 445);
    freq.put("hfa", 178);
    freq.put("ega", 205);
    freq.put("ito", 557);
    freq.put("itj", 291);
    freq.put("ith", 1252);
    freq.put("ce ", 197);
    freq.put("y ", 1757);
    freq.put("ite", 1604);
    freq.put("ita", 1245);
    freq.put(" se\u0308", 2396);
    freq.put("itu", 2464);
    freq.put("e\u0308 ", 85317);
    freq.put("fte\u0308", 453);
    freq.put("uhe", 480);
    freq.put("ym", 190);
    freq.put("yl", 202);
    freq.put("yn", 208);
    freq.put("ye", 1323);
    freq.put("L", 2905);
    freq.put("it ", 11180);
    freq.put("oka", 403);
    freq.put("ces", 191);
    freq.put("yp", 187);
    freq.put("ys", 927);
    freq.put("yr", 1681);
    freq.put("yt", 1297);
    freq.put("e\u0308d", 282);
    freq.put("e\u0308j", 261);
    freq.put("e\u0308h", 461);
    freq.put("e\u0308n", 7250);
    freq.put("e\u0308m", 1771);
    freq.put("e\u0308l", 747);
    freq.put("e\u0308s", 19082);
    freq.put("e\u0308r", 16534);
    freq.put("e\u0308p", 625);
    freq.put("e\u0308v", 1509);
    freq.put("e\u0308t", 3696);
    freq.put("e\u0308z", 648);
    freq.put("ifi", 230);
    freq.put("ite\u0308", 896);
    freq.put(" sp", 362);
    freq.put(" st", 879);
    freq.put(" su", 385);
    freq.put(" sk", 290);
    freq.put(" sh", 10305);
    freq.put(" si", 4496);
    freq.put(" so", 432);
    freq.put(" sa", 775);
    freq.put(" se", 1591);
    freq.put("iza", 492);
    freq.put("gur", 313);
    freq.put("izi", 684);
    freq.put("E ", 302);
    freq.put("izo", 367);
    freq.put("izu", 355);
    freq.put("pul", 588);
    freq.put(" el", 514);
    freq.put("pun", 526);
    freq.put("asu", 211);
    freq.put("ast", 1173);
    freq.put(" Ai", 327);
    freq.put(" Aj", 202);
    freq.put(" Al", 605);
    freq.put(" Am", 329);
    freq.put(" An", 631);
    freq.put("asa", 351);
    freq.put(" At", 239);
    freq.put(" Au", 417);
    freq.put("Uni", 285);
    freq.put("asi", 536);
    freq.put("ash", 2587);
    freq.put("El", 231);
    freq.put("kon", 2239);
    freq.put("diq", 424);
    freq.put("w", 760);
    freq.put("Ev", 475);
    freq.put("Fra", 312);
    freq.put("zi", 2576);
    freq.put("jer", 1714);
    freq.put("jes", 2300);
    freq.put(" en", 262);
    freq.put("jev", 418);
    freq.put("kol", 575);
    freq.put("jet", 2586);
    freq.put(" ek", 723);
    freq.put(" ed", 1307);
    freq.put("kod", 386);
    freq.put("jed", 481);
    freq.put("ze", 1031);
    freq.put(" et", 343);
    freq.put("jek", 498);
    freq.put("kos", 230);
    freq.put("kor", 588);
    freq.put("jen", 1698);
    freq.put("jeo", 227);
    freq.put("jel", 290);
    freq.put("kov", 192);
    freq.put("odu", 227);
    freq.put("nci", 280);
    freq.put("rra", 326);
    freq.put("nca", 359);
    freq.put("nce", 340);
    freq.put("ste", 1041);
    freq.put("Xh", 218);
    freq.put("b", 16462);
    freq.put("sta", 1312);
    freq.put("ke\u0308", 4598);
    freq.put("ko ", 239);
    freq.put("sto", 730);
    freq.put(" e ", 17735);
    freq.put("sti", 1254);
    freq.put("stu", 543);
    freq.put("je ", 2467);
    freq.put("str", 1367);
    freq.put(" es", 291);
    freq.put("ka ", 2506);
    freq.put("e\u0308ve", 1277);
    freq.put("me\u0308n", 311);
    freq.put("lid", 353);
    freq.put("k ", 3634);
    freq.put("lia", 455);
    freq.put(" em", 840);
    freq.put("ste\u0308", 596);
    freq.put("lim", 1223);
    freq.put("lin", 3413);
    freq.put("lio", 179);
    freq.put("lik", 872);
    freq.put("lit", 1752);
    freq.put("lir", 324);
    freq.put("lis", 1010);
    freq.put("zyr", 215);
    freq.put("liz", 412);
    freq.put("kak", 195);
    freq.put("M", 4987);
    freq.put("kan", 1846);
    freq.put("kam", 249);
    freq.put("kal", 946);
    freq.put("kas", 189);
    freq.put("kar", 404);
    freq.put("Ish", 253);
    freq.put("kat", 718);
    freq.put("The", 241);
    freq.put("ka", 7856);
    freq.put("li ", 2003);
    freq.put("ke", 4651);
    freq.put("kj", 232);
    freq.put("ki", 2183);
    freq.put("ko", 7127);
    freq.put("kn", 219);
    freq.put("km", 406);
    freq.put("kl", 551);
    freq.put("ks", 1435);
    freq.put("kr", 3597);
    freq.put("ku", 6445);
    freq.put("kt", 3378);
    freq.put("ky", 261);
    freq.put("rte", 551);
    freq.put("rta", 523);
    freq.put("rto", 212);
    freq.put("rti", 1091);
    freq.put("rth", 191);
    freq.put("hi ", 531);
    freq.put("oje", 249);
    freq.put("oja", 193);
    freq.put("ojn", 599);
    freq.put("are\u0308", 1850);
    freq.put("oke\u0308", 307);
    freq.put("Ju", 322);
    freq.put("ier", 413);
    freq.put("Jo", 291);
    freq.put("iel", 198);
    freq.put("ien", 214);
    freq.put("Je", 182);
    freq.put("Ja", 385);
    freq.put("me\u0308r", 628);
    freq.put("hir", 335);
    freq.put("his", 436);
    freq.put("hit", 1517);
    freq.put("rt ", 743);
    freq.put("ug ", 248);
    freq.put("oj ", 252);
    freq.put("ike\u0308", 1269);
    freq.put("hil", 181);
    freq.put("him", 565);
    freq.put("hin", 747);
    freq.put("rfs", 234);
    freq.put("ne ", 2694);
    freq.put("rfa", 431);
    freq.put(" Pe\u0308", 415);
    freq.put("ie ", 357);
    freq.put(" Be", 668);
    freq.put("arr", 782);
    freq.put("ars", 590);
    freq.put(" Ba", 1069);
    freq.put("aru", 212);
    freq.put("For", 238);
    freq.put("ze\u0308 ", 417);
    freq.put(" Bo", 497);
    freq.put(" Bi", 243);
    freq.put("rte\u0308", 586);
    freq.put(" Bu", 397);
    freq.put("ara", 2483);
    freq.put("ik ", 1689);
    freq.put("ard", 768);
    freq.put("are", 2127);
    freq.put("arg", 323);
    freq.put("ari", 2009);
    freq.put("arj", 231);
    freq.put("ark", 631);
    freq.put("arl", 201);
    freq.put("arm", 193);
    freq.put("aro", 307);
    freq.put("iku", 640);
    freq.put("ikt", 220);
    freq.put("ar ", 6112);
    freq.put("ika", 1647);
    freq.put("ike", 2366);
    freq.put("se ", 3292);
    freq.put("iki", 386);
    freq.put("ozi", 268);
    freq.put("iko", 537);
    freq.put(" Pr", 996);
    freq.put("c", 10479);
    freq.put(" Pu", 185);
    freq.put(" Pa", 1054);
    freq.put("les", 310);
    freq.put(" Pe", 612);
    freq.put(" Pi", 181);
    freq.put(" Po", 615);
    freq.put("xhi", 228);
    freq.put(" t ", 287);
    freq.put("pr", 4557);
    freq.put("ps", 322);
    freq.put("duk", 778);
    freq.put("pt", 2183);
    freq.put("pu", 2168);
    freq.put("dua", 191);
    freq.put("pa", 6781);
    freq.put("pe", 3763);
    freq.put("pj", 1679);
    freq.put("dur", 609);
    freq.put("pi", 2577);
    freq.put("po", 4293);
    freq.put("pl", 799);
    freq.put("gaz", 249);
    freq.put(" ty", 371);
    freq.put(" tu", 272);
    freq.put("gat", 279);
    freq.put(" tr", 1582);
    freq.put("N", 3399);
    freq.put(" to", 411);
    freq.put("gan", 669);
    freq.put(" tj", 633);
    freq.put(" ti", 1065);
    freq.put(" th", 1109);
    freq.put(" te", 3252);
    freq.put(" ta", 476);
    freq.put("lba", 191);
    freq.put("fut", 207);
    freq.put("fus", 270);
    freq.put("p ", 820);
    freq.put("fun", 698);
    freq.put("e\u0308pe\u0308", 198);
    freq.put("vog", 268);
    freq.put("riz", 365);
    freq.put("riv", 179);
    freq.put("rit", 2857);
    freq.put("riu", 462);
    freq.put("ris", 2678);
    freq.put("Tir", 480);
    freq.put("rin", 1760);
    freq.put("rio", 403);
    freq.put("ril", 452);
    freq.put("rim", 1881);
    freq.put("rij", 533);
    freq.put("rik", 1578);
    freq.put("rih", 296);
    freq.put("rig", 343);
    freq.put("rie", 292);
    freq.put("ria", 1506);
    freq.put("ng ", 438);
    freq.put("qar", 179);
    freq.put("mos", 301);
    freq.put("pe\u0308", 9674);
    freq.put("lig", 270);
    freq.put(" te\u0308", 19747);
    freq.put("ri ", 4362);
    freq.put(" fs", 638);
    freq.put(" fr", 355);
    freq.put(" fu", 1154);
    freq.put("lib", 286);
    freq.put("lic", 188);
    freq.put(" fa", 908);
    freq.put(" fe", 444);
    freq.put(" fi", 2335);
    freq.put("e\u0308pi", 229);
    freq.put(" fj", 334);
    freq.put(" fl", 312);
    freq.put(" fo", 1164);
    freq.put("bi ", 668);
    freq.put("hje", 1227);
    freq.put("ije\u0308", 223);
    freq.put("c\u0327e\u0308", 180);
    freq.put("Ai ", 287);
    freq.put("rga", 634);
    freq.put("rgj", 700);
    freq.put("bin", 241);
    freq.put("bim", 300);
    freq.put("be\u0308", 2042);
    freq.put("bis", 202);
    freq.put("d", 50009);
    freq.put("lja", 178);
    freq.put("lje", 416);
    freq.put("rg ", 266);
    freq.put(" ga", 620);
    freq.put("am ", 292);
    freq.put("iju", 269);
    freq.put("ohe", 1613);
    freq.put("ija", 200);
    freq.put("c\u0327e", 269);
    freq.put("ije", 259);
    freq.put("c\u0327a", 442);
    freq.put("c\u0327m", 262);
    freq.put("c\u0327i", 247);
    freq.put("pet", 184);
    freq.put("per", 1941);
    freq.put("pes", 328);
    freq.put(" Qe", 273);
    freq.put("be", 1978);
    freq.put("ba", 3411);
    freq.put("bl", 1253);
    freq.put("bo", 1748);
    freq.put("Bot", 188);
    freq.put("bi", 2183);
    freq.put("bj", 242);
    freq.put("rue", 227);
    freq.put("ij ", 910);
    freq.put("bu", 1107);
    freq.put("br", 1628);
    freq.put("c\u0327 ", 230);
    freq.put("rur", 358);
    freq.put("rus", 297);
    freq.put("rup", 598);
    freq.put("uft", 506);
    freq.put("nce\u0308", 386);
    freq.put("idh", 520);
    freq.put("idi", 290);
    freq.put("ide", 545);
    freq.put("pe ", 427);
    freq.put("nsi", 197);
    freq.put(" us", 358);
    freq.put(" uj", 303);
    freq.put("nst", 368);
    freq.put("ut ", 820);
    freq.put("ci ", 188);
    freq.put("Nob", 257);
    freq.put("u ", 4144);
    freq.put("Fe", 366);
    freq.put(" Ch", 191);
    freq.put(" Co", 245);
    freq.put(" Ca", 327);
    freq.put("aqe", 844);
    freq.put(" u ", 1417);
    freq.put("aqj", 186);
    freq.put("utb", 206);
    freq.put("cia", 487);
    freq.put(" Ky", 226);
    freq.put("uz", 609);
    freq.put("ut", 2692);
    freq.put("uv", 188);
    freq.put("uq", 312);
    freq.put("up", 1314);
    freq.put("us", 3067);
    freq.put("ur", 9836);
    freq.put("um", 2889);
    freq.put("ul", 3717);
    freq.put("un", 3916);
    freq.put("ui", 282);
    freq.put("uh", 1399);
    freq.put("uk", 1866);
    freq.put("uj", 950);
    freq.put("ue", 2301);
    freq.put("ud", 1227);
    freq.put("ug", 1106);
    freq.put("uf", 993);
    freq.put("ua", 6884);
    freq.put("uc", 369);
    freq.put("ub", 1079);
    freq.put("Tu", 198);
    freq.put("Tr", 315);
    freq.put("To", 375);
    freq.put("Th", 341);
    freq.put("Ti", 609);
    freq.put("Te", 638);
    freq.put("Ta", 357);
    freq.put("Maq", 235);
    freq.put("A ", 555);
    freq.put(" gu", 290);
    freq.put(" gr", 1301);
    freq.put("nal", 768);
    freq.put("nar", 589);
    freq.put("nas", 219);
    freq.put("gre", 682);
    freq.put("nav", 195);
    freq.put("Mad", 210);
    freq.put("nat", 905);
    freq.put("gra", 1045);
    freq.put("e\u0308so", 446);
    freq.put(" gj", 3833);
    freq.put("Mal", 292);
    freq.put("gri", 269);
    freq.put("ovi", 292);
    freq.put("ago", 189);
    freq.put("ge", 656);
    freq.put("e", 167179);
    freq.put("agj", 197);
    freq.put("Af", 186);
    freq.put("Ai", 327);
    freq.put("Aj", 203);
    freq.put("Am", 331);
    freq.put("Al", 611);
    freq.put("An", 632);
    freq.put("Ar", 625);
    freq.put("Au", 418);
    freq.put("At", 240);
    freq.put(" b", 5231);
    freq.put(" c", 3040);
    freq.put("gu", 1606);
    freq.put(" a", 8088);
    freq.put(" f", 7928);
    freq.put(" g", 6344);
    freq.put(" d", 18386);
    freq.put(" e", 22497);
    freq.put(" j", 4180);
    freq.put(" k", 16392);
    freq.put(" h", 2298);
    freq.put(" i", 13440);
    freq.put(" n", 36778);
    freq.put(" o", 2746);
    freq.put(" l", 7602);
    freq.put(" m", 19599);
    freq.put(" r", 6234);
    freq.put(" s", 22399);
    freq.put(" p", 21985);
    freq.put(" q", 6524);
    freq.put(" v", 9770);
    freq.put(" t", 29267);
    freq.put(" u", 2660);
    freq.put(" z", 2178);
    freq.put("ugo", 283);
    freq.put("gl", 638);
    freq.put("gj", 7884);
    freq.put("gi", 492);
    freq.put(" B", 3697);
    freq.put(" C", 1374);
    freq.put(" A", 5029);
    freq.put(" F", 3007);
    freq.put(" G", 2987);
    freq.put(" D", 2696);
    freq.put(" E", 2074);
    freq.put(" J", 1246);
    freq.put(" K", 6396);
    freq.put(" H", 1660);
    freq.put(" I", 2018);
    freq.put(" N", 2979);
    freq.put(" O", 928);
    freq.put(" L", 2729);
    freq.put(" M", 4746);
    freq.put(" R", 2508);
    freq.put(" S", 7145);
    freq.put(" P", 4598);
    freq.put(" Q", 712);
    freq.put(" V", 1621);
    freq.put(" W", 483);
    freq.put(" T", 3065);
    freq.put(" U", 882);
    freq.put(" Z", 866);
    freq.put(" X", 455);
    freq.put(" Y", 222);
    freq.put("tme", 342);
    freq.put("P", 4792);
    freq.put("g ", 1263);
    freq.put("tri", 1729);
    freq.put("evi", 375);
    freq.put("tro", 732);
    freq.put("tra", 1541);
    freq.put(" Rr", 230);
    freq.put("tre", 747);
    freq.put("eve", 3023);
    freq.put("tru", 612);
    freq.put("le ", 1504);
    freq.put("zm", 366);
    freq.put("zo", 1184);
    freq.put("zh", 1019);
    freq.put(" c\u0327", 814);
    freq.put("zj", 202);
    freq.put(" e\u0308", 7724);
    freq.put("rre", 1446);
    freq.put("zg", 391);
    freq.put("za", 1391);
    freq.put("zb", 204);
    freq.put("odh", 931);
    freq.put("odi", 416);
    freq.put("zy", 222);
    freq.put("zu", 773);
    freq.put("rru", 264);
    freq.put("ge\u0308", 1191);
    freq.put("ode", 218);
    freq.put("ues", 1871);
    freq.put("cak", 266);
    freq.put(" C\u0327", 648);
    freq.put(" E\u0308", 309);
    freq.put("me\u0308s", 389);
    freq.put("rd ", 234);
    freq.put("hkr", 988);
    freq.put("lek", 623);
    freq.put("z ", 666);
    freq.put("lem", 300);
    freq.put("len", 674);
    freq.put("hku", 970);
    freq.put("ler", 367);
    freq.put("hki", 188);
    freq.put("let", 699);
    freq.put("hko", 663);
    freq.put("lev", 346);
    freq.put("lez", 179);
    freq.put("hka", 488);
    freq.put("hke", 445);
    freq.put("me\u0308 ", 5423);
    freq.put("rdo", 695);
    freq.put("rdi", 283);
    freq.put("rdh", 548);
    freq.put(" Do", 261);
    freq.put(" Di", 443);
    freq.put(" Dh", 185);
    freq.put(" De", 621);
    freq.put(" Da", 377);
    freq.put("apo", 1058);
    freq.put(" Du", 229);
    freq.put("apa", 246);
    freq.put(" Dr", 303);
    freq.put("Fr", 441);
    freq.put("zis", 248);
    freq.put("afe\u0308", 206);
    freq.put(" ve\u0308", 300);
    freq.put("usi", 271);
    freq.put("ush", 1610);
    freq.put("Fa", 366);
    freq.put("ust", 434);
    freq.put("fer", 357);
    freq.put("fes", 283);
    freq.put("Fi", 584);
    freq.put("Fj", 196);
    freq.put(" c\u0327m", 240);
    freq.put("Fl", 194);
    freq.put("zik", 591);
    freq.put("Fo", 342);
    freq.put("ndj", 868);
    freq.put(" Ru", 266);
    freq.put("f", 14736);
    freq.put("oh", 3303);
    freq.put(" Re", 809);
    freq.put("nda", 1141);
    freq.put(" Ra", 364);
    freq.put("zi ", 247);
    freq.put(" Ro", 384);
    freq.put(" Ri", 264);
    freq.put("oe", 253);
    freq.put("tat", 899);
    freq.put("tav", 260);
    freq.put("tar", 4736);
    freq.put("tas", 209);
    freq.put("ape\u0308", 205);
    freq.put("eno", 271);
    freq.put("tal", 816);
    freq.put("tan", 685);
    freq.put("taj", 547);
    freq.put(" va", 567);
    freq.put("sir", 214);
    freq.put("c\u0327mi", 226);
    freq.put("sip", 1484);
    freq.put(" ve", 3244);
    freq.put(" vd", 524);
    freq.put("sit", 1207);
    freq.put(" vi", 3777);
    freq.put(" vj", 545);
    freq.put(" vl", 199);
    freq.put(" vo", 419);
    freq.put("spe", 251);
    freq.put("sia", 412);
    freq.put("e\u0308to", 188);
    freq.put("sid", 277);
    freq.put("aft", 183);
    freq.put("le\u0308t", 262);
    freq.put("sio", 712);
    freq.put("sin", 587);
    freq.put("sim", 613);
    freq.put("oz", 751);
    freq.put("sis", 1576);
    freq.put("Q", 766);
    freq.put("ta ", 2326);
    freq.put("je\u0308s", 1000);
    freq.put("afi", 534);
    freq.put("mje", 546);
    freq.put("ndr", 1255);
    freq.put("ndu", 806);
    freq.put("le\u0308 ", 644);
    freq.put("si ", 3797);
    freq.put("e\u0308dh", 247);
    freq.put("Nj", 248);
    freq.put("he\u0308 ", 1014);
    freq.put("lg", 209);
    freq.put("ld", 260);
    freq.put("le", 5962);
    freq.put("lb", 400);
    freq.put("la", 6555);
    freq.put("lo", 4348);
    freq.put("ll", 8126);
    freq.put("lm", 750);
    freq.put("lj", 608);
    freq.put("lk", 295);
    freq.put("li", 13297);
    freq.put("lt", 1030);
    freq.put("lu", 2680);
    freq.put("ls", 381);
    freq.put("e\u0308r ", 5836);
    freq.put("ly", 235);
    freq.put("dal", 409);
    freq.put("he\u0308s", 946);
    freq.put("dan", 203);
    freq.put("dat", 201);
    freq.put("sik", 262);
    freq.put("he\u0308n", 1076);
    freq.put("dar", 567);
    freq.put("he\u0308m", 639);
    freq.put("ema", 440);
    freq.put("Pre", 232);
    freq.put("c\u0327", 2147);
    freq.put("e\u0308rr", 212);
    freq.put("le\u0308r", 206);
    freq.put("Pro", 243);
    freq.put("Pri", 459);
    freq.put("eu ", 239);
    freq.put(" hu", 257);
    freq.put("le\u0308s", 678);
    freq.put("e\u0308rk", 679);
    freq.put(" hi", 627);
    freq.put("e\u0308ri", 1847);
    freq.put(" ho", 209);
    freq.put("e\u0308ro", 630);
    freq.put("e\u0308rm", 698);
    freq.put("e\u0308rb", 763);
    freq.put(" ha", 507);
    freq.put("e\u0308ra", 457);
    freq.put("e\u0308rf", 795);
    freq.put("e\u0308rg", 545);
    freq.put(" he", 538);
    freq.put("emi", 771);
    freq.put("jne\u0308", 775);
    freq.put("rez", 402);
    freq.put("res", 1012);
    freq.put("req", 525);
    freq.put("rev", 322);
    freq.put("le\u0308", 3066);
    freq.put("ret", 2035);
    freq.put("rej", 1398);
    freq.put("rek", 369);
    freq.put("reh", 210);
    freq.put("ren", 1060);
    freq.put("rem", 230);
    freq.put("rea", 282);
    freq.put("reg", 1272);
    freq.put("toj", 273);
    freq.put("Kjo", 277);
    freq.put("eci", 308);
    freq.put("qua", 358);
    freq.put("x", 1327);
    freq.put("quh", 192);
    freq.put("log", 828);
    freq.put("E\u0308s", 295);
    freq.put("g", 26110);
    freq.put("uha", 223);
    freq.put("e\u0308re\u0308", 456);
    freq.put("re ", 5892);
    freq.put("rs ", 444);
    freq.put("set", 189);
    freq.put("art", 1488);
    freq.put("ihe", 650);
    freq.put("be ", 208);
    freq.put(" St", 520);
    freq.put(" Su", 263);
    freq.put(" Sk", 217);
    freq.put(" Sh", 3248);
    freq.put(" Si", 519);
    freq.put(" So", 373);
    freq.put(" Sa", 578);
    freq.put(" Se", 536);
    freq.put("Ka", 1334);
    freq.put("rso", 384);
    freq.put("rsh", 704);
    freq.put("rsi", 760);
    freq.put("Kj", 278);
    freq.put("Ki", 240);
    freq.put("Ko", 2407);
    freq.put("rsa", 288);
    freq.put("ogr", 753);
    freq.put("Kr", 523);
    freq.put("R", 2957);
    freq.put("Ku", 625);
    freq.put("ogj", 624);
    freq.put("Ky", 228);
    freq.put("udi", 562);
    freq.put("bel", 434);
    freq.put("ure\u0308", 434);
    freq.put("ber", 314);
    freq.put("bet", 408);
    freq.put("Par", 336);
    freq.put("Pas", 194);
    freq.put(" Br", 498);
    freq.put("sen", 315);
    freq.put("sk", 843);
    freq.put("mik", 541);
    freq.put("mij", 213);
    freq.put("mim", 764);
    freq.put("mil", 488);
    freq.put("min", 2761);
    freq.put("oje\u0308", 384);
    freq.put("hr", 608);
    freq.put("mis", 535);
    freq.put("mir", 472);
    freq.put("mit", 2427);
    freq.put(" El", 231);
    freq.put("Gju", 218);
    freq.put("BA ", 261);
    freq.put("Ke\u0308", 300);
    freq.put("ute", 336);
    freq.put("oge\u0308", 224);
    freq.put("st ", 714);
    freq.put(" Ev", 475);
    freq.put("ure", 247);
    freq.put("urg", 207);
    freq.put("ura", 1239);
    freq.put("mi ", 2352);
    freq.put("fja", 339);
    freq.put("uro", 455);
    freq.put("uri", 1038);
    freq.put("urt", 615);
    freq.put("urr", 247);
    freq.put("rja", 228);
    freq.put("tj ", 257);
    freq.put("Gji", 334);
    freq.put("Pe\u0308", 415);
    freq.put("nge", 207);
    freq.put("ha", 4203);
    freq.put("nga", 5420);
    freq.put("ngl", 339);
    freq.put("jat", 998);
    freq.put(" is", 1788);
    freq.put(" it", 245);
    freq.put("jas", 292);
    freq.put("ngj", 549);
    freq.put("jan", 2402);
    freq.put("q ", 809);
    freq.put("jal", 704);
    freq.put("jak", 272);
    freq.put(" in", 1156);
    freq.put("fe\u0308r", 208);
    freq.put("he", 19006);
    freq.put("ksi", 671);
    freq.put("uaj", 694);
    freq.put("tbo", 238);
    freq.put("mul", 232);
    freq.put("shp", 846);
    freq.put("shq", 1997);
    freq.put("shr", 422);
    freq.put("qu", 769);
    freq.put("shu", 1255);
    freq.put("qy", 921);
    freq.put("h", 74009);
    freq.put("qa", 297);
    freq.put("sha", 1190);
    freq.put("qe", 2941);
    freq.put("she", 1082);
    freq.put("shf", 232);
    freq.put("qi", 4293);
    freq.put("ete\u0308", 2083);
    freq.put("qj", 229);
    freq.put("shm", 1425);
    freq.put("ja ", 2116);
    freq.put("sho", 753);
    freq.put("Pr", 997);
    freq.put("Pu", 185);
    freq.put("oma", 638);
    freq.put("ke ", 3158);
    freq.put("jo ", 859);
    freq.put("Pa", 1058);
    freq.put("Pe", 613);
    freq.put("ede", 284);
    freq.put("Pi", 181);
    freq.put("Po", 615);
    freq.put("ome", 460);
    freq.put("nge\u0308", 383);
    freq.put("lua", 941);
    freq.put("et ", 8412);
    freq.put("lue", 177);
    freq.put("luf", 367);
    freq.put("se\u0308m", 198);
    freq.put("se\u0308n", 372);
    freq.put("lum", 373);
    freq.put("ken", 688);
    freq.put("qe\u0308 ", 3460);
    freq.put("omo", 183);
    freq.put("S", 7666);
    freq.put("joh", 964);
    freq.put("ket", 291);
    freq.put("vro", 528);
    freq.put("jon", 213);
    freq.put("etr", 567);
    freq.put("etu", 501);
    freq.put("eta", 1185);
    freq.put("se\u0308 ", 5936);
    freq.put("ete", 1425);
    freq.put("etj", 331);
    freq.put("qe\u0308", 4381);
    freq.put("eti", 2581);
    freq.put("eto", 1111);
    freq.put("ck", 313);
    freq.put("ci", 4788);
    freq.put(" ak", 811);
    freq.put("co", 479);
    freq.put("omu", 542);
    freq.put("ot ", 268);
    freq.put("ca", 1358);
    freq.put("ve\u0308", 1622);
    freq.put("re\u0308v", 444);
    freq.put("ce", 1081);
    freq.put(" am", 508);
    freq.put("ab", 980);
    freq.put(" an", 1204);
    freq.put(" ap", 925);
    freq.put("Jug", 202);
    freq.put("re\u0308s", 1368);
    freq.put("jit", 1409);
    freq.put("pia", 517);
    freq.put("dje", 856);
    freq.put("\u03bf", 279);
    freq.put("jis", 586);
    freq.put("oti", 443);
    freq.put("oto", 318);
    freq.put("ota", 201);
    freq.put("c ", 318);
    freq.put("ote", 245);
    freq.put("tje", 1286);
    freq.put("hme", 1293);
    freq.put("otu", 316);
    freq.put("ysh", 673);
    freq.put("ce\u0308s", 254);
    freq.put("rbe", 317);
    freq.put("rba", 177);
    freq.put("ce\u0308", 728);
    freq.put("va", 1908);
    freq.put(" Fr", 441);
    freq.put("vd", 565);
    freq.put("ve", 12217);
    freq.put("nom", 633);
    freq.put("vi", 5977);
    freq.put("vj", 627);
    freq.put("vl", 237);
    freq.put("vo", 819);
    freq.put(" Fa", 359);
    freq.put("vr", 700);
    freq.put(" Fe", 366);
    freq.put("avi", 245);
    freq.put(" Fi", 583);
    freq.put("ave", 2116);
    freq.put(" Fj", 187);
    freq.put("ava", 276);
    freq.put(" Fo", 338);
    freq.put("io ", 303);
    freq.put("of ", 206);
    freq.put("he\u0308r", 431);
    freq.put("zgj", 372);
    freq.put("e\u0308ti", 364);
    freq.put("v ", 372);
    freq.put("ote\u0308", 804);
    freq.put("ior", 219);
    freq.put("ion", 2522);
    freq.put("ofe", 213);
    freq.put("i", 153617);
    freq.put(" Tu", 194);
    freq.put(" Tr", 311);
    freq.put(" To", 373);
    freq.put("rbe\u0308", 484);
    freq.put(" Ti", 608);
    freq.put(" Th", 340);
    freq.put(" Te", 634);
    freq.put(" Ta", 356);
    freq.put("BA", 277);
    freq.put("nje\u0308", 7204);
    freq.put("Be", 668);
    freq.put("Ba", 1072);
    freq.put("Bo", 499);
    freq.put("Bi", 247);
    freq.put("ske", 209);
    freq.put("Bu", 398);
    freq.put("ade", 333);
    freq.put("Br", 503);
    freq.put("ada", 241);
    freq.put("adm", 223);
    freq.put("ese\u0308", 1317);
    freq.put("adh", 1978);
    freq.put("adi", 505);
    freq.put("T", 3497);
    freq.put("nde\u0308", 2245);
    freq.put("l ", 3714);
    freq.put("e\u0308te\u0308", 434);
    freq.put("e\u0308rp", 333);
    freq.put("nja", 288);
    freq.put("qed", 256);
    freq.put("nje", 980);
    freq.put("nji", 251);
    freq.put("njo", 1016);
    freq.put("qen", 825);
    freq.put("qer", 357);
    freq.put("qet", 282);
    freq.put("qev", 185);
    freq.put("esv", 178);
    freq.put("est", 534);
    freq.put("nd ", 1287);
    freq.put("ese", 746);
    freq.put("iso", 211);
    freq.put("esa", 635);
    freq.put("eso", 355);
    freq.put("esm", 180);
    freq.put("ga ", 5443);
    freq.put("e\u0308t ", 1589);
    freq.put("esi", 1453);
    freq.put("esh", 1754);
    freq.put("qe ", 553);
    freq.put("lle", 383);
    freq.put("Un", 312);
    freq.put("ndi", 3173);
    freq.put("kry", 877);
    freq.put("ndo", 1605);
    freq.put(" ju", 582);
    freq.put("nde", 1242);
    freq.put("kru", 297);
    freq.put(" jo", 218);
    freq.put("kri", 1336);
    freq.put("kro", 261);
    freq.put("es ", 2822);
    freq.put(" je", 756);
    freq.put("ne\u0308t", 322);
    freq.put("C\u0327m", 287);
    freq.put("kra", 414);
    freq.put(" ja", 2600);
    freq.put("e\u0308ta", 971);
    freq.put("kre", 377);
    freq.put("C\u0327mi", 287);
    freq.put("ine\u0308", 1756);
    freq.put("sve", 238);
    freq.put("h ", 2770);
    freq.put("val", 324);
    freq.put("yra", 227);
    freq.put("Ame", 229);
    freq.put("yre", 469);
    freq.put("var", 488);
    freq.put("yrt", 226);
    freq.put("rca", 229);
    freq.put("hy", 320);
    freq.put("ean", 206);
    freq.put("bur", 304);
    freq.put("hs", 268);
    freq.put("hp", 932);
    freq.put("hq", 3267);
    freq.put("hv", 498);
    freq.put("ht", 18411);
    freq.put("hu", 3735);
    freq.put("hj", 1397);
    freq.put("hk", 4243);
    freq.put("hi", 5167);
    freq.put("hn", 261);
    freq.put("ho", 1827);
    freq.put("bul", 254);
    freq.put("hm", 1740);
    freq.put("Gje", 385);
    freq.put("hf", 238);
    freq.put("eat", 241);
    freq.put("Gja", 201);
    freq.put("rrj", 335);
    freq.put("dmi", 238);
    freq.put("va ", 428);
    freq.put("j", 47732);
    freq.put("rri", 1024);
    freq.put("ne\u0308 ", 21951);
    freq.put("pik", 379);
    freq.put("pin", 244);
    freq.put("pio", 290);
    freq.put("int", 466);
    freq.put("inu", 257);
    freq.put("ins", 260);
    freq.put("lm ", 208);
    freq.put("ino", 317);
    freq.put("ini", 1146);
    freq.put("inj", 211);
    freq.put("ind", 2986);
    freq.put("ine", 1441);
    freq.put("inf", 213);
    freq.put("ing", 422);
    freq.put("pit", 346);
    freq.put("ina", 1004);
    freq.put("yre\u0308", 392);
    freq.put("hpr", 194);
    freq.put(" Un", 311);
    freq.put("or ", 3887);
    freq.put("hpe", 278);
    freq.put("pi ", 351);
    freq.put("ne\u0308n", 960);
    freq.put("gar", 602);
    freq.put("he\u0308", 4530);
    freq.put("ne\u0308s", 866);
    freq.put("U", 1057);
    freq.put("ubl", 681);
    freq.put("in ", 7905);
    freq.put("Mar", 396);
    freq.put("izm", 294);
    freq.put("eog", 217);
    freq.put("eor", 217);
  }
  
}

