package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class SK extends CLangProfile {
  private static final String name = "sk";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public SK() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 5274251;
    n_words[1] = 6043345;
    n_words[2] = 4170145;

    freq.put("hy\u0301 ", 549);
    freq.put("y\u0301ch", 17568);
    freq.put("l\u030c ", 1691);
    freq.put("va\u0308z", 626);
    freq.put("oma\u0301", 669);
    freq.put("ti\u0301v", 2085);
    freq.put("e\u0301ri", 720);
    freq.put("aur", 606);
    freq.put("aut", 1518);
    freq.put("ti\u0301n", 557);
    freq.put(" Gr", 1147);
    freq.put("l\u030cov", 2803);
    freq.put("l\u030cs", 1492);
    freq.put("l\u030cu", 1677);
    freq.put("ajm", 1012);
    freq.put("l\u030ck", 2350);
    freq.put("l\u030cm", 577);
    freq.put("l\u030cn", 1481);
    freq.put("l\u030co", 3506);
    freq.put("l\u030ca", 5647);
    freq.put("upn", 539);
    freq.put("aku\u0301", 915);
    freq.put("rea", 838);
    freq.put("Gr", 1156);
    freq.put("upi", 2474);
    freq.put("upe", 584);
    freq.put("Za\u0301", 884);
    freq.put("zdr", 695);
    freq.put("ti\u0301 ", 1453);
    freq.put("Ge", 866);
    freq.put("zdi", 837);
    freq.put("Ga", 734);
    freq.put("dra\u0301", 560);
    freq.put("li\u0301n", 914);
    freq.put(" ka", 3354);
    freq.put("me ", 2180);
    freq.put(" ke", 682);
    freq.put("z\u030cov", 702);
    freq.put(" kn", 595);
    freq.put(" ko", 7181);
    freq.put(" kl", 1191);
    freq.put(" km", 3854);
    freq.put(" kr", 5176);
    freq.put(" kv", 711);
    freq.put(" kt", 14067);
    freq.put(" ku", 1362);
    freq.put("l\u0301z\u030ck", 983);
    freq.put("di\u0301 ", 1492);
    freq.put("nem", 1523);
    freq.put("nej", 10418);
    freq.put("neh", 1387);
    freq.put("kut", 584);
    freq.put("nec", 565);
    freq.put("kup", 2670);
    freq.put("kum", 749);
    freq.put("kul", 1450);
    freq.put("nez", 594);
    freq.put("kuj", 582);
    freq.put("ers", 1662);
    freq.put("net", 1021);
    freq.put("a\u0301ro", 2670);
    freq.put("ner", 1759);
    freq.put("nes", 1971);
    freq.put("nep", 832);
    freq.put("med", 3229);
    freq.put(" k ", 1516);
    freq.put("i\u0301ck", 596);
    freq.put("i\u0301ci", 652);
    freq.put("i\u0301ch", 1516);
    freq.put("mel", 722);
    freq.put("men", 7980);
    freq.put("ors", 1188);
    freq.put("s\u030cov", 613);
    freq.put(" si", 1947);
    freq.put("mes", 5087);
    freq.put("mer", 6360);
    freq.put("gli", 887);
    freq.put("oro", 4190);
    freq.put("Ze", 702);
    freq.put("k", 216062);
    freq.put("dru", 2904);
    freq.put("Za", 604);
    freq.put("ne ", 14236);
    freq.put("akt", 2087);
    freq.put("zdi\u0301", 688);
    freq.put("ako", 5403);
    freq.put("dro", 1109);
    freq.put("dra", 864);
    freq.put("aka", 544);
    freq.put("dre", 621);
    freq.put("ake", 675);
    freq.put("ku ", 12244);
    freq.put("bro", 596);
    freq.put("bri", 844);
    freq.put("bre", 863);
    freq.put("bra", 2640);
    freq.put("dne", 4630);
    freq.put("ena\u0301", 3253);
    freq.put("dna", 890);
    freq.put("m ", 45126);
    freq.put("ene\u0301", 2633);
    freq.put("dno", 4328);
    freq.put("voc", 735);
    freq.put("dni", 563);
    freq.put("eni\u0301", 1974);
    freq.put("zmy", 578);
    freq.put("er ", 5579);
    freq.put("si\u0301d", 652);
    freq.put("ys\u030cs\u030c", 666);
    freq.put("eny\u0301", 3926);
    freq.put(" dl\u0301", 994);
    freq.put("nka", 1319);
    freq.put("Sta", 811);
    freq.put("nko", 836);
    freq.put("Je ", 3173);
    freq.put("ova\u0301", 4125);
    freq.put("Str", 817);
    freq.put("V", 8838);
    freq.put("nky", 647);
    freq.put("ove\u0301", 3486);
    freq.put("me", 31227);
    freq.put(" mo\u0302", 637);
    freq.put("erv", 1342);
    freq.put("ma", 12807);
    freq.put("mb", 3559);
    freq.put("mm", 559);
    freq.put("ml", 855);
    freq.put("mo", 13618);
    freq.put("mn", 3217);
    freq.put("mi", 19191);
    freq.put("vov", 1480);
    freq.put("erz", 959);
    freq.put("mu", 6601);
    freq.put("ere", 1934);
    freq.put("erg", 805);
    freq.put("mp", 2180);
    freq.put("ms", 1427);
    freq.put("erm", 1031);
    freq.put("ern", 3749);
    freq.put("ero", 3934);
    freq.put("my", 3831);
    freq.put("eri", 5783);
    freq.put("rik", 952);
    freq.put("Le", 1477);
    freq.put("La", 1055);
    freq.put("Lo", 964);
    freq.put("o\u0301gi", 1295);
    freq.put("la ", 7993);
    freq.put("Li", 1427);
    freq.put("ov ", 17465);
    freq.put("Lu", 551);
    freq.put("ena", 1245);
    freq.put("hod", 4341);
    freq.put("ib", 2309);
    freq.put("end", 639);
    freq.put("ene", 3296);
    freq.put("dni\u0301", 530);
    freq.put("eni", 7601);
    freq.put("hol", 1107);
    freq.put("hom", 770);
    freq.put("dne\u0301", 1797);
    freq.put("hok", 654);
    freq.put("enn", 1593);
    freq.put("eno", 3633);
    freq.put("hov", 3246);
    freq.put("Kar", 601);
    freq.put("ens", 6528);
    freq.put("hor", 2878);
    freq.put("hos", 535);
    freq.put("m2", 561);
    freq.put("dny\u0301", 2826);
    freq.put("dl\u0301z\u030c", 1131);
    freq.put("A", 10071);
    freq.put("ovs", 2190);
    freq.put("lan", 3456);
    freq.put("ec\u030cn", 971);
    freq.put("laj", 540);
    freq.put("lad", 4725);
    freq.put("ovc", 817);
    freq.put("ova", 12599);
    freq.put("II ", 663);
    freq.put("ove", 10952);
    freq.put("lat", 2521);
    freq.put("lav", 3631);
    freq.put("ovi", 5011);
    freq.put("ovn", 3441);
    freq.put("ovo", 4172);
    freq.put("jma\u0308", 776);
    freq.put("las", 3716);
    freq.put("en ", 3989);
    freq.put("ma\u0308", 1078);
    freq.put("ma\u0301", 4691);
    freq.put(" c\u030ca", 4766);
    freq.put("ho ", 17722);
    freq.put("l\u030com", 604);
    freq.put("mi\u0301", 2439);
    freq.put(" c\u030co", 669);
    freq.put("me\u0301", 722);
    freq.put(" c\u030ci", 2100);
    freq.put("ri\u0301k", 630);
    freq.put("mo\u0302", 731);
    freq.put(" Ge", 865);
    freq.put("tna\u0301", 587);
    freq.put("era\u0301", 1903);
    freq.put("vou", 852);
    freq.put("ri\u0301 ", 1490);
    freq.put(" V ", 1733);
    freq.put("ra\u0301c", 1499);
    freq.put("onk", 548);
    freq.put("ra\u0301n", 812);
    freq.put(" Hr", 606);
    freq.put("ra\u0301l", 1811);
    freq.put(" Ga", 726);
    freq.put("zen", 1178);
    freq.put("ri\u0301p", 667);
    freq.put("zem", 2639);
    freq.put("zer", 667);
    freq.put("ra\u0301t", 1564);
    freq.put("oni", 1442);
    freq.put(" Ho", 1810);
    freq.put("pra\u0301", 2352);
    freq.put(" Ha", 1115);
    freq.put(" He", 1127);
    freq.put("u\u0301ca", 1146);
    freq.put("ro\u0302", 641);
    freq.put("aju\u0301", 4186);
    freq.put("ime", 618);
    freq.put("ro\u0301", 1912);
    freq.put("imi", 618);
    freq.put("ry\u0301", 5792);
    freq.put(" za\u0301", 4976);
    freq.put("ru\u0301", 2323);
    freq.put("el\u030cn", 732);
    freq.put("fic", 1396);
    freq.put("ra\u0301", 15217);
    freq.put("onc", 866);
    freq.put("ri\u0301", 8465);
    freq.put("fin", 689);
    freq.put("re\u0301", 5591);
    freq.put("fil", 2159);
    freq.put(" Va", 861);
    freq.put(" Ve", 1359);
    freq.put("ra\u0301 ", 3488);
    freq.put(" Vi", 989);
    freq.put("SA ", 809);
    freq.put(" Vo", 610);
    freq.put("ane\u0301", 3292);
    freq.put("toc\u030c", 963);
    freq.put(" Vy", 655);
    freq.put("im ", 540);
    freq.put("osk", 702);
    freq.put("ati\u0301", 1130);
    freq.put("l", 181843);
    freq.put("c\u030ces", 715);
    freq.put("ons", 933);
    freq.put("cka\u0301", 2980);
    freq.put("rt", 4523);
    freq.put("ru", 10434);
    freq.put("rv", 5009);
    freq.put(" zn", 2605);
    freq.put("rp", 1158);
    freq.put("rr", 843);
    freq.put("rs", 6494);
    freq.put(" ze", 560);
    freq.put(" zd", 916);
    freq.put("dst", 1631);
    freq.put("ajs", 1164);
    freq.put(" za", 7013);
    freq.put("ry", 3916);
    freq.put("rz", 1417);
    freq.put("rd", 2875);
    freq.put("re", 40029);
    freq.put("rf", 643);
    freq.put("rg", 3525);
    freq.put("ra", 41482);
    freq.put("ajn", 753);
    freq.put("rc", 3598);
    freq.put("rl", 1127);
    freq.put("rm", 4664);
    freq.put("rn", 10561);
    freq.put("gov", 534);
    freq.put("rh", 695);
    freq.put("ri", 34707);
    freq.put("rk", 2824);
    freq.put("ntr", 1488);
    freq.put("ntu", 602);
    freq.put("ied", 1764);
    freq.put("nti", 2074);
    freq.put("zde", 597);
    freq.put("W", 2331);
    freq.put("nta", 1252);
    freq.put("nte", 2106);
    freq.put("ate", 5705);
    freq.put("a\u0301zo", 1232);
    freq.put("atn", 905);
    freq.put("ato", 2184);
    freq.put("atk", 1336);
    freq.put("ist", 5989);
    freq.put("isk", 1618);
    freq.put("atr", 1680);
    freq.put("i\u0301to", 1670);
    freq.put("isl", 1645);
    freq.put("aj ", 3272);
    freq.put("i\u0301ta", 936);
    freq.put(" Sp", 1448);
    freq.put("a\u0301zv", 643);
    freq.put("cu\u0301z", 960);
    freq.put("ua\u0301r", 767);
    freq.put("la\u0301 ", 591);
    freq.put("osa", 791);
    freq.put("nis", 1117);
    freq.put("ry\u0301c", 1417);
    freq.put("tem", 1660);
    freq.put("tor", 19018);
    freq.put("tos", 575);
    freq.put("top", 560);
    freq.put("tov", 6017);
    freq.put("tou", 572);
    freq.put("tok", 6341);
    freq.put("xis", 565);
    freq.put("ton", 1192);
    freq.put("tol", 1656);
    freq.put("tom", 2788);
    freq.put("toc", 600);
    freq.put("c\u030cel\u030c", 579);
    freq.put("kt ", 843);
    freq.put(" le", 2787);
    freq.put("B", 10822);
    freq.put(" la", 1441);
    freq.put("y\u0301va", 1701);
    freq.put(" lo", 1116);
    freq.put(" li", 2051);
    freq.put("la\u0301c", 551);
    freq.put("la\u0301t", 631);
    freq.put("vyv", 562);
    freq.put("la\u0301v", 675);
    freq.put("i\u0301c ", 720);
    freq.put("la\u0301r", 543);
    freq.put("z\u030ci", 6988);
    freq.put("nta\u0301", 825);
    freq.put("i\u0301", 50255);
    freq.put("ktr", 1255);
    freq.put("aly\u0301", 759);
    freq.put("kti", 779);
    freq.put("za\u0301k", 1752);
    freq.put("to ", 9348);
    freq.put("raf", 1089);
    freq.put("rad", 3121);
    freq.put("lbu", 1038);
    freq.put("rac", 1364);
    freq.put("ran", 7562);
    freq.put("s\u030ci\u0301 ", 1009);
    freq.put(" Bu", 806);
    freq.put("ram", 1814);
    freq.put("raj", 2984);
    freq.put("rak", 1723);
    freq.put("rav", 4611);
    freq.put("rat", 3414);
    freq.put("ras", 1183);
    freq.put("raz", 2538);
    freq.put("do ", 3088);
    freq.put("rs\u030c", 1164);
    freq.put("nt ", 1523);
    freq.put("on ", 2680);
    freq.put("nen", 2040);
    freq.put("s\u030ci\u0301m", 570);
    freq.put(" la\u0301", 612);
    freq.put("c\u030cen", 2971);
    freq.put("u\u0301zs", 928);
    freq.put("s\u030ci\u0301c", 1062);
    freq.put(" fi", 2971);
    freq.put("za ", 3910);
    freq.put("rc\u030c", 1607);
    freq.put("s\u030ci\u0301r", 654);
    freq.put("typ", 873);
    freq.put("bsa", 802);
    freq.put("dok", 1204);
    freq.put("dol", 1125);
    freq.put("dom", 1779);
    freq.put("dob", 3335);
    freq.put("m", 157226);
    freq.put("noz\u030c", 749);
    freq.put("kti\u0301", 857);
    freq.put("dor", 670);
    freq.put("dos", 1422);
    freq.put("dop", 717);
    freq.put("dov", 3715);
    freq.put("ne\u0301 ", 10505);
    freq.put("e\u0301r", 2157);
    freq.put("e\u0301t", 1878);
    freq.put("d ", 13711);
    freq.put(" Wi", 780);
    freq.put("e\u0301h", 11280);
    freq.put("e\u0301m", 3465);
    freq.put("e\u0301n", 937);
    freq.put("e\u0301c", 848);
    freq.put("ke\u0301 ", 4451);
    freq.put("e\u0301d", 556);
    freq.put("ac\u030ci", 550);
    freq.put("och", 5397);
    freq.put("ock", 745);
    freq.put("em ", 1276);
    freq.put("ac\u030co", 893);
    freq.put("ac\u030cn", 1506);
    freq.put("ac\u030ce", 897);
    freq.put("hro", 776);
    freq.put("abs", 539);
    freq.put("ba ", 1862);
    freq.put(" u\u0301z", 1992);
    freq.put("hra", 2720);
    freq.put(" u\u0301s", 674);
    freq.put("dn", 17745);
    freq.put("do", 19760);
    freq.put("dl", 3720);
    freq.put("dm", 1805);
    freq.put("dk", 1536);
    freq.put("di", 12919);
    freq.put("ma\u0308 ", 776);
    freq.put("de", 19219);
    freq.put("db", 1133);
    freq.put("dc", 900);
    freq.put("da", 10163);
    freq.put("nev", 549);
    freq.put("l\u0301z\u030c", 1136);
    freq.put("ke\u0301h", 4205);
    freq.put("dz", 7413);
    freq.put("dy", 3861);
    freq.put("dv", 2815);
    freq.put("e\u0301 ", 23043);
    freq.put("du", 5115);
    freq.put("dr", 7033);
    freq.put("ds", 3840);
    freq.put("dp", 1210);
    freq.put("eme", 4087);
    freq.put("ak ", 1606);
    freq.put("ema", 956);
    freq.put("emb", 1776);
    freq.put("emo", 708);
    freq.put("emi", 2282);
    freq.put("z\u030ci\u0301v", 1856);
    freq.put("ban", 633);
    freq.put("bal", 748);
    freq.put("om ", 22923);
    freq.put("iz\u030c", 1338);
    freq.put("nut", 1486);
    freq.put("is\u030c", 1309);
    freq.put("oma", 1179);
    freq.put("it\u030c", 1158);
    freq.put("a\u0308c\u030c", 1548);
    freq.put("mec", 1667);
    freq.put("il ", 2232);
    freq.put("nic\u030c", 860);
    freq.put("i\u0301sl", 936);
    freq.put("iro", 841);
    freq.put("Rus", 613);
    freq.put("mun", 908);
    freq.put("hra\u0301", 1069);
    freq.put("y\u0301zn", 1190);
    freq.put("i\u0301sa", 578);
    freq.put("we", 537);
    freq.put("di\u0301", 2091);
    freq.put("wa", 909);
    freq.put("omi", 1538);
    freq.put("omo", 2048);
    freq.put("omn", 567);
    freq.put("wi", 924);
    freq.put("da\u0301", 2384);
    freq.put("cky\u0301", 6183);
    freq.put("dy\u0301", 547);
    freq.put(" In", 1544);
    freq.put("eln", 1067);
    freq.put("do\u0302", 739);
    freq.put("nu ", 2533);
    freq.put("cou", 843);
    freq.put("ell", 742);
    freq.put("ila", 1287);
    freq.put("iln", 537);
    freq.put("ilo", 2707);
    freq.put("ill", 858);
    freq.put("ilm", 766);
    freq.put("ili", 1886);
    freq.put("u\u0301di", 539);
    freq.put("mu ", 3156);
    freq.put("uni", 1311);
    freq.put("unk", 1091);
    freq.put("com", 638);
    freq.put("a\u0301ln", 5252);
    freq.put("zt\u030ca", 609);
    freq.put(" ma", 5130);
    freq.put("o\u0301n ", 764);
    freq.put("ane", 1786);
    freq.put("io\u0301", 1393);
    freq.put(" mo", 3923);
    freq.put(" mi", 3009);
    freq.put("dl\u030c", 1507);
    freq.put(" mu", 967);
    freq.put("sah", 1086);
    freq.put("ii\u0301", 1342);
    freq.put("ia\u0301", 2685);
    freq.put(" my", 693);
    freq.put("san", 671);
    freq.put("fra", 1611);
    freq.put("na\u0301s", 953);
    freq.put("C ", 1204);
    freq.put("pro", 5879);
    freq.put(" u\u0301c\u030c", 553);
    freq.put("ona\u0301", 934);
    freq.put(" m ", 975);
    freq.put("ii\u0301 ", 1338);
    freq.put("o\u0301no", 796);
    freq.put("dsk", 1498);
    freq.put("sad", 597);
    freq.put("Ch", 1551);
    freq.put("Co", 1488);
    freq.put("slu", 716);
    freq.put("Ca", 1126);
    freq.put("Ce", 608);
    freq.put("n", 323513);
    freq.put("slo", 4792);
    freq.put("sle", 1956);
    freq.put("sla", 2054);
    freq.put("Nac", 597);
    freq.put("iz", 4693);
    freq.put(" ma\u0301", 2179);
    freq.put("ip", 2091);
    freq.put("is", 15561);
    freq.put("ir", 3821);
    freq.put("iu", 3712);
    freq.put("it", 16315);
    freq.put("a\u0308 ", 797);
    freq.put("iv", 6007);
    freq.put("ii", 2337);
    freq.put("ih", 1011);
    freq.put("ik", 11705);
    freq.put("ij", 1891);
    freq.put("im", 4228);
    freq.put("il", 11847);
    freq.put("io", 5948);
    freq.put("in", 30878);
    freq.put("ia", 31792);
    freq.put("ic", 28125);
    freq.put("ki ", 721);
    freq.put("ie", 44145);
    freq.put("id", 6006);
    freq.put("ig", 2598);
    freq.put("if", 1907);
    freq.put("V ", 2449);
    freq.put("uje", 4632);
    freq.put("z\u030csk", 553);
    freq.put("nik", 3242);
    freq.put("nin", 802);
    freq.put("nic", 3941);
    freq.put("nia", 4773);
    freq.put("nie", 10761);
    freq.put("niz", 1417);
    freq.put("a\u0308z", 636);
    freq.put("i ", 37987);
    freq.put("a\u0308t", 901);
    freq.put("niv", 740);
    freq.put("nit", 919);
    freq.put("niu", 577);
    freq.put("Va", 862);
    freq.put("Ve", 1362);
    freq.put("Vi", 1001);
    freq.put("ept", 842);
    freq.put("epu", 784);
    freq.put("epr", 993);
    freq.put("Vo", 610);
    freq.put("epo", 608);
    freq.put("epl", 609);
    freq.put("Vy", 658);
    freq.put("epa", 610);
    freq.put("ri\u0301m", 628);
    freq.put("oli\u0301", 768);
    freq.put("olo\u0301", 1594);
    freq.put("elk", 666);
    freq.put("eli", 2168);
    freq.put("hal", 560);
    freq.put("elo", 1876);
    freq.put("han", 1109);
    freq.put("ela", 1378);
    freq.put("ele", 4527);
    freq.put("zos", 869);
    freq.put("els", 755);
    freq.put("har", 1373);
    freq.put("rni", 769);
    freq.put("rno", 1434);
    freq.put("D", 6323);
    freq.put("opr", 1001);
    freq.put("rna", 1377);
    freq.put("rne", 2865);
    freq.put("ope", 1090);
    freq.put("rny", 1014);
    freq.put("opa", 913);
    freq.put("opo", 1188);
    freq.put("opi", 803);
    freq.put("c\u030cuj", 916);
    freq.put("ha ", 1403);
    freq.put("el ", 2590);
    freq.put(" d\u030ca", 573);
    freq.put("ola", 3491);
    freq.put("ole", 1539);
    freq.put(" Ju", 970);
    freq.put("oli", 3155);
    freq.put("olk", 708);
    freq.put("oln", 999);
    freq.put("olo", 6182);
    freq.put(" Jo", 992);
    freq.put("olu", 1129);
    freq.put(" Je", 4569);
    freq.put("oly", 771);
    freq.put(" Ja", 1224);
    freq.put("ick", 16621);
    freq.put("ici", 1650);
    freq.put("ich", 3629);
    freq.put("bny\u0301", 856);
    freq.put("Hr", 608);
    freq.put("ns\u030c", 1355);
    freq.put("ica", 2319);
    freq.put("i\u0301pa", 543);
    freq.put("yko", 908);
    freq.put("ice", 1897);
    freq.put("rio", 767);
    freq.put("Ho", 1814);
    freq.put("umb", 576);
    freq.put("Ha", 1121);
    freq.put("He", 1131);
    freq.put("ol ", 4900);
    freq.put("rne\u0301", 631);
    freq.put("nc\u030c", 1255);
    freq.put("ply", 661);
    freq.put("ple", 978);
    freq.put("rny\u0301", 683);
    freq.put("plo", 927);
    freq.put("pln", 576);
    freq.put("obn", 2229);
    freq.put("obo", 1131);
    freq.put("obl", 2050);
    freq.put("obj", 2245);
    freq.put("obi", 1583);
    freq.put("obd", 699);
    freq.put("obe", 3213);
    freq.put("obc", 1130);
    freq.put("o", 480147);
    freq.put("oba", 663);
    freq.put("um ", 2635);
    freq.put("oby", 2302);
    freq.put("zuj", 707);
    freq.put("obr", 1755);
    freq.put("obs", 891);
    freq.put("soc", 946);
    freq.put("sob", 2176);
    freq.put("mbe", 991);
    freq.put("sok", 687);
    freq.put("a\u0301no", 783);
    freq.put("aho", 724);
    freq.put("son", 682);
    freq.put("ahr", 640);
    freq.put("i\u0301n ", 1967);
    freq.put("nny\u0301", 1960);
    freq.put("tu\u0301d", 552);
    freq.put("a\u0301ns", 810);
    freq.put("mbr", 959);
    freq.put("ne\u0301", 16353);
    freq.put("art", 1675);
    freq.put("git", 547);
    freq.put("ni\u0301", 8389);
    freq.put("az ", 763);
    freq.put("na\u0301", 21179);
    freq.put("nu\u0301", 2094);
    freq.put("gic", 1619);
    freq.put("ny\u0301", 22118);
    freq.put("gia", 694);
    freq.put("no\u0301", 730);
    freq.put("so ", 1147);
    freq.put("a\u0301n ", 994);
    freq.put(" na\u0301", 5061);
    freq.put("ed\u030c", 654);
    freq.put("Z", 3853);
    freq.put("ry\u0301 ", 3747);
    freq.put("azo", 539);
    freq.put("su\u0301c\u030c", 1671);
    freq.put("aze", 872);
    freq.put("azy", 1600);
    freq.put("i\u0301ro", 535);
    freq.put("chy", 636);
    freq.put("nno", 871);
    freq.put("t\u030co", 1542);
    freq.put("nne", 1300);
    freq.put("t\u030ca", 2465);
    freq.put(" Li", 1420);
    freq.put("ni", 32826);
    freq.put("nk", 4794);
    freq.put("gio\u0301", 559);
    freq.put("pre", 12441);
    freq.put("nn", 5955);
    freq.put("no", 31919);
    freq.put("tit", 878);
    freq.put("na", 48626);
    freq.put("tiv", 708);
    freq.put("nc", 6297);
    freq.put("nd", 6014);
    freq.put("ne", 40950);
    freq.put("nf", 1138);
    freq.put("ng", 5209);
    freq.put("ny", 10740);
    freq.put("nz", 946);
    freq.put("tio", 893);
    freq.put("tik", 2033);
    freq.put("tie", 2901);
    freq.put("tif", 575);
    freq.put("ns", 14480);
    freq.put("nt", 13652);
    freq.put("nu", 6191);
    freq.put("tic", 5672);
    freq.put(" ni", 2558);
    freq.put("E", 4459);
    freq.put(" no", 2104);
    freq.put("kva", 670);
    freq.put(" na", 26193);
    freq.put(" ne", 6825);
    freq.put("t\u030c ", 9577);
    freq.put("tec", 925);
    freq.put("ovy\u0301", 6197);
    freq.put("aze\u0301", 596);
    freq.put("for", 2552);
    freq.put("n ", 17290);
    freq.put("va\u0308c\u030c", 1491);
    freq.put("hl\u030ca", 877);
    freq.put("azy\u0301", 599);
    freq.put("rk ", 572);
    freq.put("ti ", 7610);
    freq.put("vzd", 855);
    freq.put("roj", 1677);
    freq.put("rok", 6707);
    freq.put("rol", 693);
    freq.put("rom", 3824);
    freq.put("ron", 1914);
    freq.put("osp", 667);
    freq.put("rob", 1537);
    freq.put("roc", 1978);
    freq.put("rod", 4794);
    freq.put("ost", 12819);
    freq.put("d\u030ca", 1413);
    freq.put("rog", 1008);
    freq.put("osi", 598);
    freq.put("roz", 4727);
    freq.put("osl", 1521);
    freq.put("oso", 997);
    freq.put("rop", 884);
    freq.put("ros", 1960);
    freq.put("rot", 1344);
    freq.put("rou", 580);
    freq.put("rov", 10282);
    freq.put("ume", 1559);
    freq.put("vet", 2834);
    freq.put("ver", 4560);
    freq.put("ves", 693);
    freq.put("vez", 833);
    freq.put("ved", 2502);
    freq.put("jvo", 598);
    freq.put("yva", 1437);
    freq.put("ven", 6559);
    freq.put("vel", 598);
    freq.put("vej", 3167);
    freq.put("vek", 1439);
    freq.put(" do", 7552);
    freq.put("Ma\u0301", 761);
    freq.put(" dn", 677);
    freq.put("ro ", 773);
    freq.put("d\u030c ", 922);
    freq.put("os ", 1011);
    freq.put("din", 1669);
    freq.put("dio", 707);
    freq.put("o\u0301r", 1755);
    freq.put("o\u0301p", 1200);
    freq.put("dia", 1795);
    freq.put("eka\u0301", 616);
    freq.put("dic", 713);
    freq.put("gus", 545);
    freq.put("p", 133920);
    freq.put("o\u0301n", 3191);
    freq.put("o\u0301m", 1121);
    freq.put(" c\u030ci\u0301", 1229);
    freq.put("div", 859);
    freq.put("pec", 635);
    freq.put("o\u0301g", 1873);
    freq.put("der", 1566);
    freq.put("o\u0301d", 1271);
    freq.put("ruk", 768);
    freq.put("ez\u030ci", 1187);
    freq.put("tne", 1495);
    freq.put("u\u0301to", 587);
    freq.put("rum", 558);
    freq.put("ek ", 1552);
    freq.put("bo ", 9920);
    freq.put("l\u030csk", 1094);
    freq.put("rva", 761);
    freq.put("jva\u0308", 876);
    freq.put("Me", 2050);
    freq.put("Ma", 4427);
    freq.put("io\u0301n", 1128);
    freq.put("Mo", 1742);
    freq.put("Mi", 1818);
    freq.put("yda", 835);
    freq.put("ez\u030c ", 1107);
    freq.put("O", 4702);
    freq.put("it\u030c ", 1130);
    freq.put("tno", 1220);
    freq.put("eko", 1708);
    freq.put("dec", 966);
    freq.put("bor", 1466);
    freq.put("era", 3225);
    freq.put("bov", 774);
    freq.put("ngl", 1479);
    freq.put("boj", 571);
    freq.put("bol", 6856);
    freq.put("eku", 666);
    freq.put("ekt", 4312);
    freq.put("bod", 650);
    freq.put("st\u030c", 7157);
    freq.put("pla", 2526);
    freq.put("spo\u0302", 638);
    freq.put("ost\u030c", 3922);
    freq.put(" Ka", 2166);
    freq.put(" Ko", 2060);
    freq.put(" Kr", 1440);
    freq.put("te\u0301m", 1500);
    freq.put("msk", 1141);
    freq.put("rve", 789);
    freq.put("ca ", 4873);
    freq.put("kyc", 690);
    freq.put("F", 4516);
    freq.put("ma ", 1882);
    freq.put("su\u0301", 8148);
    freq.put("zna\u0301", 1803);
    freq.put("ibl", 710);
    freq.put("roc\u030c", 900);
    freq.put("vel\u030c", 1567);
    freq.put("ult", 1375);
    freq.put("se\u0301", 733);
    freq.put("uli", 689);
    freq.put("ulo", 557);
    freq.put("si\u0301", 1587);
    freq.put("sa\u0301", 670);
    freq.put("te\u0301 ", 1097);
    freq.put("pol\u030c", 636);
    freq.put(" ok", 5647);
    freq.put(" of", 678);
    freq.put("Mic", 549);
    freq.put(" ob", 11824);
    freq.put(" oc", 805);
    freq.put("spi", 721);
    freq.put(" oz", 1525);
    freq.put("spo", 4892);
    freq.put("za\u0301v", 683);
    freq.put(" ot", 721);
    freq.put(" or", 1845);
    freq.put(" os", 2878);
    freq.put(" op", 1633);
    freq.put("ny ", 7794);
    freq.put("ru\u0301 ", 1621);
    freq.put("n\u030cu", 845);
    freq.put("n\u030co", 1237);
    freq.put("nym", 950);
    freq.put("nyc", 1783);
    freq.put("n\u030ca", 1527);
    freq.put("sne", 932);
    freq.put("mat", 2750);
    freq.put("sno", 764);
    freq.put("ky ", 10576);
    freq.put("a\u0301me", 834);
    freq.put(" o ", 2049);
    freq.put("a\u0301my", 668);
    freq.put("enc", 1378);
    freq.put("u\u0301c\u030ca", 1833);
    freq.put("mag", 530);
    freq.put("dna\u0301", 1325);
    freq.put("maj", 736);
    freq.put("mal", 1423);
    freq.put("man", 1923);
    freq.put("sy", 3565);
    freq.put("zi\u0301", 915);
    freq.put("zne", 607);
    freq.put("ss", 1524);
    freq.put("zni", 1787);
    freq.put("sp", 10573);
    freq.put("sv", 4018);
    freq.put("su", 4004);
    freq.put("st", 58751);
    freq.put("sk", 44161);
    freq.put("si", 7301);
    freq.put("sh", 654);
    freq.put("so", 10148);
    freq.put("sn", 3377);
    freq.put("sm", 2199);
    freq.put("sl", 11132);
    freq.put("sc", 2214);
    freq.put("sa", 16525);
    freq.put("ula\u0301", 681);
    freq.put("sf", 608);
    freq.put("se", 10443);
    freq.put("Ru", 1051);
    freq.put("enk", 694);
    freq.put(" pe", 1662);
    freq.put("pi\u0301s", 996);
    freq.put("ea\u0301", 715);
    freq.put("lsk", 1225);
    freq.put("Re", 1050);
    freq.put("tu\u0301r", 2064);
    freq.put("Ra", 1481);
    freq.put("Ro", 1422);
    freq.put("Ri", 640);
    freq.put("eo\u0301", 677);
    freq.put("o\u0302zn", 583);
    freq.put(" ab", 764);
    freq.put("jin", 1578);
    freq.put("geo", 632);
    freq.put(" aj", 2712);
    freq.put(" ak", 5587);
    freq.put(" al", 12145);
    freq.put(" am", 1765);
    freq.put(" an", 2592);
    freq.put(" ap", 672);
    freq.put(" ar", 1452);
    freq.put(" as", 1460);
    freq.put(" at", 917);
    freq.put(" au", 1810);
    freq.put("ent", 6824);
    freq.put("nom", 6261);
    freq.put("ory\u0301", 4753);
    freq.put("noh", 590);
    freq.put("is ", 1825);
    freq.put("ert", 777);
    freq.put("ori\u0301", 947);
    freq.put("R ", 612);
    freq.put("ore\u0301", 3735);
    freq.put("not", 1866);
    freq.put("nou", 2761);
    freq.put("nov", 6617);
    freq.put("ze\u0301", 647);
    freq.put("nor", 620);
    freq.put("nos", 7269);
    freq.put(" a ", 25661);
    freq.put("zac\u030c", 716);
    freq.put("ji ", 665);
    freq.put("a\u0301ci", 4745);
    freq.put("a\u0301ch", 1879);
    freq.put("eru", 692);
    freq.put("em", 14359);
    freq.put("el", 18740);
    freq.put("eo", 3559);
    freq.put("en", 52359);
    freq.put("ei", 1554);
    freq.put("eh", 6797);
    freq.put("ek", 12213);
    freq.put("ej", 29432);
    freq.put("ee", 903);
    freq.put("ed", 25726);
    freq.put("eg", 2721);
    freq.put("ef", 1680);
    freq.put("ea", 2540);
    freq.put("ec", 10112);
    freq.put("eb", 13761);
    freq.put("ey", 664);
    freq.put("ex", 2935);
    freq.put("ez", 6532);
    freq.put("eu", 1904);
    freq.put("et", 17096);
    freq.put("ew", 678);
    freq.put("ev", 7688);
    freq.put("ep", 6024);
    freq.put("es", 24526);
    freq.put("er", 36633);
    freq.put("ejo", 597);
    freq.put("skl", 733);
    freq.put("eja", 658);
    freq.put("bli", 1892);
    freq.put("bla", 1662);
    freq.put("G", 4726);
    freq.put("ory", 689);
    freq.put("ort", 1007);
    freq.put("oru", 1061);
    freq.put("e ", 118531);
    freq.put("orn", 2464);
    freq.put("dpo", 810);
    freq.put("orm", 2535);
    freq.put("y\u0301s\u030c", 544);
    freq.put("ork", 577);
    freq.put("ori", 3545);
    freq.put("org", 1589);
    freq.put("ord", 568);
    freq.put("ore", 3404);
    freq.put("ora", 1870);
    freq.put("m2 ", 561);
    freq.put("ej ", 24245);
    freq.put(" ce", 3110);
    freq.put("zan", 554);
    freq.put("u\u0301ce", 1226);
    freq.put("zal", 1158);
    freq.put("xi", 1668);
    freq.put("hu ", 2863);
    freq.put("ana\u0301", 2114);
    freq.put("ri\u0301t", 1609);
    freq.put("ebe", 670);
    freq.put("pri\u0301", 5030);
    freq.put("ani\u0301", 1813);
    freq.put("ona", 1883);
    freq.put("u\u0301ci", 2715);
    freq.put("ond", 761);
    freq.put("one", 891);
    freq.put("ma\u0301 ", 1849);
    freq.put("any\u0301", 3599);
    freq.put("zar", 737);
    freq.put("xt", 831);
    freq.put("Eur", 843);
    freq.put("iam", 1045);
    freq.put("ial", 965);
    freq.put("ian", 2212);
    freq.put("iad", 1663);
    freq.put("ukt", 726);
    freq.put("gie", 653);
    freq.put("iac", 3458);
    freq.put("iat", 1943);
    freq.put(" az\u030c", 955);
    freq.put("iar", 1167);
    freq.put("hud", 1122);
    freq.put(" c\u030ce", 1631);
    freq.put(" Ze", 700);
    freq.put("x ", 1187);
    freq.put(" Za", 604);
    freq.put("huj", 767);
    freq.put("ma\u0301c", 652);
    freq.put("ma\u0301l", 594);
    freq.put("c\u030cas", 7534);
    freq.put("ia ", 16846);
    freq.put("rzi", 638);
    freq.put(" c\u030cl", 1364);
    freq.put("r", 287939);
    freq.put(" S\u030ct", 611);
    freq.put("c\u030cia", 1892);
    freq.put("zsk", 1303);
    freq.put("and", 2251);
    freq.put("a\u0301lo", 634);
    freq.put("ang", 1885);
    freq.put("pra", 4417);
    freq.put("ana", 1968);
    freq.put("sam", 778);
    freq.put("anc", 2108);
    freq.put("ann", 2369);
    freq.put("ano", 1953);
    freq.put("es\u030c", 1638);
    freq.put("ani", 9481);
    freq.put("ank", 901);
    freq.put("ant", 2498);
    freq.put("anu", 914);
    freq.put("ez\u030c", 4352);
    freq.put("y\u0301 ", 29957);
    freq.put("ans", 3130);
    freq.put("ono\u0301", 542);
    freq.put("any", 631);
    freq.put("Do", 1311);
    freq.put("en\u030c", 1574);
    freq.put("zof", 1473);
    freq.put("Di", 711);
    freq.put("lna", 768);
    freq.put("De", 1168);
    freq.put("ejs\u030c", 2097);
    freq.put("Da", 900);
    freq.put("zor", 857);
    freq.put("2", 567);
    freq.put("\u0435", 558);
    freq.put("zov", 2409);
    freq.put("y\u0301v", 2338);
    freq.put("an ", 2683);
    freq.put("pr ", 604);
    freq.put("y\u0301s", 969);
    freq.put("y\u0301r", 1274);
    freq.put("sa ", 11522);
    freq.put(" Za\u0301", 880);
    freq.put("a\u0301l ", 697);
    freq.put("y\u0301z", 1464);
    freq.put("el\u030c", 8588);
    freq.put("y\u0301c", 17590);
    freq.put("y\u0301m", 8307);
    freq.put("y\u0301k", 611);
    freq.put("ec\u030c", 2428);
    freq.put(" Le", 1473);
    freq.put(" La", 1046);
    freq.put(" Lo", 960);
    freq.put("tne\u0301", 1110);
    freq.put("D ", 632);
    freq.put(" Lu", 549);
    freq.put("oc\u030ca", 775);
    freq.put("axi", 588);
    freq.put("lny\u0301", 723);
    freq.put(" su\u0301", 8023);
    freq.put("tka", 2298);
    freq.put("tko", 851);
    freq.put("s\u030ci\u0301", 3431);
    freq.put("rma\u0301", 1093);
    freq.put("lne\u0301", 534);
    freq.put("dy ", 3344);
    freq.put("tky", 1006);
    freq.put("iti", 1519);
    freq.put("Wi", 788);
    freq.put("a\u0301bo", 552);
    freq.put("\u0430", 792);
    freq.put(" ps", 641);
    freq.put(" pr", 34757);
    freq.put("ju\u0301", 8749);
    freq.put("H", 6933);
    freq.put("ji\u0301", 607);
    freq.put(" pa", 3109);
    freq.put("S\u030ct", 611);
    freq.put(" pi", 764);
    freq.put(" po", 28142);
    freq.put("gen", 1449);
    freq.put(" pl", 3456);
    freq.put("ra\u0301v", 2279);
    freq.put("ute", 592);
    freq.put("oc\u030ce", 1143);
    freq.put("o\u0301", 12207);
    freq.put("poc\u030c", 2131);
    freq.put(" by\u0301", 593);
    freq.put("s\u030ca", 1343);
    freq.put("uti", 837);
    freq.put("s\u030ce", 3604);
    freq.put("s\u030c ", 574);
    freq.put("s\u030ci", 5749);
    freq.put("s\u030ck", 1726);
    freq.put(" si\u0301", 744);
    freq.put("s\u030co", 1393);
    freq.put("s\u030cn", 1118);
    freq.put("s\u030cp", 1178);
    freq.put("lno", 1179);
    freq.put("rma", 1073);
    freq.put("s\u030ct", 7288);
    freq.put("lne", 3312);
    freq.put("tky\u0301", 805);
    freq.put("j ", 28903);
    freq.put("rmo", 565);
    freq.put("vu ", 969);
    freq.put("ytv", 779);
    freq.put("tur", 912);
    freq.put("e\u0301ck", 749);
    freq.put("ciu", 1018);
    freq.put(" po\u0302", 1710);
    freq.put("tup", 1550);
    freq.put("ju", 2887);
    freq.put("jv", 2323);
    freq.put("js", 2102);
    freq.put("jm", 1649);
    freq.put("jn", 2178);
    freq.put("jo", 2645);
    freq.put("ji", 2876);
    freq.put("jk", 595);
    freq.put("je", 54049);
    freq.put("ja", 8703);
    freq.put(" pi\u0301", 654);
    freq.put(" be", 1234);
    freq.put(" ba", 944);
    freq.put(" bl", 568);
    freq.put(" bo", 7806);
    freq.put(" bi", 1273);
    freq.put("P ", 647);
    freq.put(" bu", 1277);
    freq.put("s", 230794);
    freq.put("tve", 851);
    freq.put(" br", 1360);
    freq.put(" by", 978);
    freq.put("hvi", 1289);
    freq.put("poz", 1867);
    freq.put("iva\u0301", 562);
    freq.put("pov", 2089);
    freq.put("pot", 3320);
    freq.put("pou", 1725);
    freq.put("hve", 833);
    freq.put("pos", 2178);
    freq.put("pop", 662);
    freq.put("pon", 991);
    freq.put("pol", 5900);
    freq.put("pom", 1667);
    freq.put("poj", 1973);
    freq.put("imo", 583);
    freq.put("ni\u0301 ", 2500);
    freq.put("pod", 5807);
    freq.put("poc", 543);
    freq.put("spr", 1629);
    freq.put(" Ma\u0301", 761);
    freq.put(" s\u030ck", 769);
    freq.put("u\u0301ry", 632);
    freq.put(" s\u030cp", 1040);
    freq.put("az\u030c ", 1038);
    freq.put("u\u0301ra", 899);
    freq.put("n\u030c", 4992);
    freq.put("ni\u0301c", 1168);
    freq.put("fik", 1059);
    freq.put("yzi", 807);
    freq.put("ni\u0301m", 1698);
    freq.put("ni\u0301k", 2268);
    freq.put("po ", 2974);
    freq.put("uju\u0301", 3483);
    freq.put("az\u030cd", 650);
    freq.put("s\u030cs\u030c", 674);
    freq.put("ive", 1126);
    freq.put("e\u0301tk", 856);
    freq.put("vuj", 550);
    freq.put("ivo", 1530);
    freq.put("ivi", 709);
    freq.put("okr", 4784);
    freq.put("oku", 4912);
    freq.put("okt", 536);
    freq.put(" Me", 2047);
    freq.put("par", 1586);
    freq.put("pat", 1317);
    freq.put(" Ma", 4398);
    freq.put(" Mo", 1735);
    freq.put(" Mi", 1809);
    freq.put("jc\u030c", 568);
    freq.put("pad", 2850);
    freq.put("l\u030cad", 1602);
    freq.put("uho", 1552);
    freq.put("I ", 1477);
    freq.put("pal", 635);
    freq.put("pan", 1020);
    freq.put("cel", 1592);
    freq.put("nac", 1381);
    freq.put("I", 5526);
    freq.put("yd", 1380);
    freq.put("js\u030c", 2481);
    freq.put("sed", 553);
    freq.put("pa ", 715);
    freq.put("l\u030ca ", 2178);
    freq.put("uhu", 583);
    freq.put("In", 1551);
    freq.put("oke", 803);
    freq.put("uz\u030ci", 784);
    freq.put("a\u0301c", 7329);
    freq.put("a\u0301b", 1278);
    freq.put("a\u0301d", 5449);
    freq.put("am ", 1578);
    freq.put("a\u0301k", 2947);
    freq.put("a\u0301j", 1169);
    freq.put("a\u0301m", 3217);
    freq.put("a\u0301l", 8570);
    freq.put("a\u0301n", 4821);
    freq.put("a\u0301p", 2703);
    freq.put("a\u0301s", 2422);
    freq.put("a\u0301r", 8087);
    freq.put("a\u0301t", 6184);
    freq.put("a\u0301v", 6149);
    freq.put("va\u0308", 2642);
    freq.put("a\u0301z", 2921);
    freq.put("tva\u0301", 863);
    freq.put("i\u0301m ", 3028);
    freq.put("tin", 2110);
    freq.put("c\u030ci ", 954);
    freq.put("loz\u030c", 1837);
    freq.put("ami", 3340);
    freq.put("a\u0301 ", 30384);
    freq.put("amo", 1677);
    freq.put("amn", 620);
    freq.put("ama", 959);
    freq.put("por", 2069);
    freq.put(" ga", 535);
    freq.put("ame", 3786);
    freq.put("mov", 2255);
    freq.put("i\u0301ms", 589);
    freq.put("loc\u030c", 1880);
    freq.put("mon", 943);
    freq.put("mom", 711);
    freq.put("moc", 890);
    freq.put("juz\u030c", 746);
    freq.put("mod", 1086);
    freq.put("y\u0301mi", 2162);
    freq.put("zlo", 1388);
    freq.put("oc\u030ci\u0301", 1245);
    freq.put("tia", 1542);
    freq.put("km2", 548);
    freq.put("c\u030cs\u030ci", 967);
    freq.put("pok", 841);
    freq.put("as\u030c", 705);
    freq.put("Nem", 547);
    freq.put("at\u030c", 2167);
    freq.put("poh", 1271);
    freq.put("uto", 2154);
    freq.put("tvo", 4048);
    freq.put("ezd", 2253);
    freq.put("eze", 538);
    freq.put("tva", 2149);
    freq.put("az\u030c", 3807);
    freq.put(" ch", 2700);
    freq.put("ac ", 550);
    freq.put("vzn", 1177);
    freq.put("o ", 72538);
    freq.put(" z\u030ci", 2499);
    freq.put("Mes", 567);
    freq.put("uch", 1187);
    freq.put(" z\u030ce", 1412);
    freq.put("ty ", 3084);
    freq.put("zit", 695);
    freq.put("sel", 864);
    freq.put("ez ", 733);
    freq.put("al\u030c", 716);
    freq.put("oo", 910);
    freq.put("on", 18042);
    freq.put("aca", 545);
    freq.put("ol", 27522);
    freq.put("ok", 25444);
    freq.put("oj", 9152);
    freq.put("ace", 1242);
    freq.put("km ", 3082);
    freq.put("og", 4545);
    freq.put("of", 3569);
    freq.put("oe", 798);
    freq.put("ach", 4201);
    freq.put("aco", 855);
    freq.put("ob", 22771);
    freq.put("ad\u030c", 870);
    freq.put("oz", 12370);
    freq.put("ow", 1410);
    freq.put("ov", 73503);
    freq.put("ou", 15818);
    freq.put("ot", 13213);
    freq.put("os", 25341);
    freq.put("or", 43666);
    freq.put("op", 7814);
    freq.put("a\u0301s\u030c", 773);
    freq.put("Ni", 925);
    freq.put("ju ", 598);
    freq.put("bja", 1624);
    freq.put("No", 1174);
    freq.put("Na", 2123);
    freq.put("Ne", 1824);
    freq.put("ku\u0301 ", 741);
    freq.put("rvy\u0301", 709);
    freq.put("a\u0301z\u030c", 617);
    freq.put("log", 1964);
    freq.put("her", 779);
    freq.put("ni ", 1003);
    freq.put("lok", 542);
    freq.put("loh", 1318);
    freq.put("lon", 552);
    freq.put("lom", 1766);
    freq.put("los", 1486);
    freq.put("lov", 10431);
    freq.put("loz", 1479);
    freq.put("hem", 744);
    freq.put("ku\u0301s", 915);
    freq.put("moz\u030c", 865);
    freq.put(" sv", 3511);
    freq.put("juh", 1174);
    freq.put("J", 8422);
    freq.put("dvo", 1617);
    freq.put("se\u0301r", 579);
    freq.put(" su", 1035);
    freq.put("a\u0301l\u030c", 830);
    freq.put("lo ", 4534);
    freq.put("ha\u0301d", 2792);
    freq.put("a\u0301c\u030c", 817);
    freq.put("ity\u0301", 663);
    freq.put("he ", 1247);
    freq.put("oc\u030c", 7254);
    freq.put("ab", 3624);
    freq.put("ae", 1120);
    freq.put("ad", 20535);
    freq.put("ag", 2783);
    freq.put("af", 1683);
    freq.put("ai", 1980);
    freq.put("ah", 4710);
    freq.put("ak", 14537);
    freq.put("aj", 18129);
    freq.put("am", 14227);
    freq.put("al", 32605);
    freq.put("ao", 743);
    freq.put("an", 46975);
    freq.put("ap", 5241);
    freq.put("as", 19402);
    freq.put("ar", 21528);
    freq.put("Hor", 544);
    freq.put("at", 24996);
    freq.put("av", 19342);
    freq.put("ay", 741);
    freq.put("ax", 910);
    freq.put("az", 7180);
    freq.put(" he", 772);
    freq.put("ohr", 721);
    freq.put("z\u030cen", 2262);
    freq.put("by\u0301v", 889);
    freq.put("c\u030cin", 1952);
    freq.put("vzt\u030c", 595);
    freq.put("ol\u030c", 2603);
    freq.put("ota", 944);
    freq.put("Au", 625);
    freq.put("c\u030co ", 704);
    freq.put("a ", 144799);
    freq.put("ve\u0301 ", 2772);
    freq.put(" zl", 1104);
    freq.put(" zo", 2693);
    freq.put("u\u0301st", 1144);
    freq.put("at ", 1606);
    freq.put("c\u030cov", 1446);
    freq.put("os\u030c", 1310);
    freq.put("oz\u030c", 4892);
    freq.put("u", 141151);
    freq.put("Bra", 1002);
    freq.put("u\u0301sk", 784);
    freq.put("alo", 3047);
    freq.put("a\u0301rs", 742);
    freq.put("sch", 1140);
    freq.put("ali", 4506);
    freq.put("iu ", 2243);
    freq.put("pte", 802);
    freq.put("ale", 12669);
    freq.put("alb", 970);
    freq.put("ala", 2255);
    freq.put("a\u0301ra", 896);
    freq.put("eda", 1823);
    freq.put("z\u030ci\u0301", 3206);
    freq.put("mno", 1169);
    freq.put("a\u0301rn", 1647);
    freq.put("gr", 4226);
    freq.put("hy ", 1193);
    freq.put("tz", 568);
    freq.put("ty", 4889);
    freq.put("tv", 9012);
    freq.put("tt", 1333);
    freq.put("tu", 8639);
    freq.put("tr", 24800);
    freq.put("ts", 3310);
    freq.put("zme", 835);
    freq.put("tn", 7740);
    freq.put("to", 52129);
    freq.put("tl", 2323);
    freq.put("tm", 1030);
    freq.put("tk", 5618);
    freq.put("th", 2145);
    freq.put("ti", 28975);
    freq.put("\u0438", 615);
    freq.put("tu ", 3234);
    freq.put("te", 28885);
    freq.put("ta", 24342);
    freq.put(" ro\u0302", 570);
    freq.put("edi", 1893);
    freq.put("ium", 775);
    freq.put("rb", 1553);
    freq.put("far", 539);
    freq.put("edn", 6191);
    freq.put("mpl", 621);
    freq.put("al ", 3190);
    freq.put("za\u0301", 7603);
    freq.put("a\u0301r ", 1209);
    freq.put(" ra\u0301", 581);
    freq.put("gy", 705);
    freq.put(" ri\u0301", 775);
    freq.put("yso", 679);
    freq.put("ius", 597);
    freq.put("edm", 627);
    freq.put("sme", 1025);
    freq.put(" Ni", 923);
    freq.put("hyb", 690);
    freq.put("ro", 47621);
    freq.put(" No", 1171);
    freq.put("zy\u0301", 682);
    freq.put(" Na", 2120);
    freq.put("ysl", 1049);
    freq.put(" Ne", 1808);
    freq.put("ge", 3887);
    freq.put("zy\u0301v", 664);
    freq.put("vy\u0301v", 564);
    freq.put(" zr", 719);
    freq.put("t ", 11585);
    freq.put("tej", 1310);
    freq.put("tek", 1233);
    freq.put("tel", 2263);
    freq.put("ga", 3383);
    freq.put("ten", 2822);
    freq.put("z\u030cs", 1011);
    freq.put("ted", 826);
    freq.put("z\u030cu", 918);
    freq.put("ala\u0301", 536);
    freq.put("tex", 545);
    freq.put("go", 2083);
    freq.put("z\u030ck", 1609);
    freq.put("z\u030cn", 3570);
    freq.put("z\u030co", 977);
    freq.put("tep", 676);
    freq.put("z\u030ca", 964);
    freq.put("ter", 5642);
    freq.put("z\u030cd", 912);
    freq.put("z\u030ce", 5249);
    freq.put("o\u0302z\u030c", 785);
    freq.put("ty\u0301", 3031);
    freq.put("tu\u0301", 3411);
    freq.put("to\u0301", 2119);
    freq.put("ez\u030ci\u0301", 971);
    freq.put("ti\u0301", 5214);
    freq.put("lle", 613);
    freq.put("te\u0301", 3643);
    freq.put("ta\u0301", 7149);
    freq.put(" ru", 986);
    freq.put("lko", 992);
    freq.put("te ", 3202);
    freq.put("K", 8631);
    freq.put(" re", 5038);
    freq.put(" ra", 2110);
    freq.put("pub", 965);
    freq.put("z\u030c ", 2893);
    freq.put(" ro", 13226);
    freq.put(" ri", 1768);
    freq.put("s\u030c", 30141);
    freq.put("ol\u030cs", 926);
    freq.put("su ", 2117);
    freq.put(" Na\u0301", 657);
    freq.put("yst", 2333);
    freq.put("vic", 742);
    freq.put("via", 1774);
    freq.put("ny\u0301c", 6239);
    freq.put("vid", 1528);
    freq.put("vie", 3018);
    freq.put("ny\u0301m", 3498);
    freq.put("vin", 2530);
    freq.put("vil", 1662);
    freq.put("vis", 1230);
    freq.put(" Fr", 1186);
    freq.put("ky\u0301c", 4322);
    freq.put("rka", 749);
    freq.put("vit", 1615);
    freq.put("ky\u0301m", 2061);
    freq.put("S ", 1036);
    freq.put(" s ", 5627);
    freq.put("ve", 29704);
    freq.put("c\u030cny\u0301", 1760);
    freq.put("c\u030cne\u0301", 1259);
    freq.put("avu", 898);
    freq.put("de ", 4522);
    freq.put("c\u030cna\u0301", 722);
    freq.put("ro\u0302z", 582);
    freq.put("vec", 641);
    freq.put("vi ", 826);
    freq.put("ny\u0301 ", 12353);
    freq.put("Sp", 1454);
    freq.put("Sv", 647);
    freq.put("Su", 614);
    freq.put("St", 2440);
    freq.put("Si", 786);
    freq.put("So", 1120);
    freq.put("Sl", 3359);
    freq.put("Sc", 541);
    freq.put("Sa", 1654);
    freq.put("avs", 622);
    freq.put("Se", 1430);
    freq.put("a\u0301", 98447);
    freq.put("S\u030c", 1929);
    freq.put(" dl", 624);
    freq.put("kla", 4718);
    freq.put(" di", 2885);
    freq.put("dep", 553);
    freq.put(" de", 4244);
    freq.put("ata", 1116);
    freq.put("avn", 2304);
    freq.put(" da", 904);
    freq.put("dej", 622);
    freq.put("avo", 3114);
    freq.put("del", 1924);
    freq.put("den", 5230);
    freq.put("v", 227972);
    freq.put(" dv", 1786);
    freq.put(" du", 557);
    freq.put("n\u030cuj", 774);
    freq.put(" dr", 3425);
    freq.put("avi", 3514);
    freq.put(" z ", 7975);
    freq.put("f ", 1519);
    freq.put("vy", 11079);
    freq.put("st\u030co", 1256);
    freq.put("po\u0302v", 1057);
    freq.put("ati", 5001);
    freq.put("po\u0302s", 1202);
    freq.put("o\u0302z", 595);
    freq.put("o\u0302v", 1382);
    freq.put("o\u0302r", 598);
    freq.put("o\u0302s", 1461);
    freq.put("vla", 1346);
    freq.put("lam", 627);
    freq.put("c\u030cno", 1723);
    freq.put("r ", 14190);
    freq.put("c\u030cne", 1110);
    freq.put("fr", 2471);
    freq.put("ft", 581);
    freq.put("fu", 1355);
    freq.put("fy", 881);
    freq.put("pri", 8032);
    freq.put("rc\u030ce", 541);
    freq.put("fa", 1707);
    freq.put("fe", 2493);
    freq.put("tel\u030c", 4587);
    freq.put("st\u030c ", 5294);
    freq.put("fi", 7159);
    freq.put("fo", 3584);
    freq.put("a", 438168);
    freq.put("us ", 3503);
    freq.put("ry ", 2619);
    freq.put("egi", 891);
    freq.put("zik", 680);
    freq.put(" do\u0302", 541);
    freq.put("itn", 565);
    freq.put("ito", 1341);
    freq.put("ka\u0301 ", 7010);
    freq.put("uh ", 722);
    freq.put("ce ", 4495);
    freq.put("y ", 38794);
    freq.put("ite", 3279);
    freq.put("ita", 1760);
    freq.put("ok ", 6372);
    freq.put("uz\u030cn", 1127);
    freq.put("ity", 888);
    freq.put("itu", 927);
    freq.put("its", 591);
    freq.put("iza\u0301", 1011);
    freq.put("ol\u030cn", 609);
    freq.put(" Ob", 929);
    freq.put("nto", 1924);
    freq.put(" Or", 774);
    freq.put("ka\u0301c", 693);
    freq.put("yh", 649);
    freq.put("yk", 2457);
    freq.put("yj", 557);
    freq.put("ym", 2723);
    freq.put("yl", 992);
    freq.put("yn", 1959);
    freq.put("cen", 1906);
    freq.put("yc", 3925);
    freq.put("yb", 1209);
    freq.put("L", 6128);
    freq.put("it ", 625);
    freq.put("ka\u0301l", 578);
    freq.put("oka", 1003);
    freq.put("yz", 1332);
    freq.put("ces", 1333);
    freq.put("cer", 678);
    freq.put("yp", 2058);
    freq.put("ys", 5625);
    freq.put("yr", 1431);
    freq.put("yt", 2758);
    freq.put("oko", 5187);
    freq.put("yv", 2400);
    freq.put("tro", 6109);
    freq.put("Rak", 660);
    freq.put("die", 2214);
    freq.put("ifi", 1055);
    freq.put(" sy", 2275);
    freq.put("ite\u0301", 878);
    freq.put(" sp", 8017);
    freq.put("c\u030c", 43571);
    freq.put(" st", 8244);
    freq.put("ita\u0301", 857);
    freq.put(" sk", 5136);
    freq.put("as ", 1458);
    freq.put(" so", 2515);
    freq.put(" sl", 4314);
    freq.put(" sm", 780);
    freq.put(" sc", 711);
    freq.put(" sa", 11939);
    freq.put("prv", 2306);
    freq.put(" se", 4266);
    freq.put("i\u0301ka", 561);
    freq.put("i\u0301ko", 789);
    freq.put("i\u0301ns", 810);
    freq.put("izm", 1796);
    freq.put("izo", 825);
    freq.put("liz\u030c", 568);
    freq.put("ky\u0301 ", 7646);
    freq.put("ve ", 3005);
    freq.put("ast", 8626);
    freq.put("lic\u030c", 614);
    freq.put("l\u030cud", 1147);
    freq.put(" Al", 1528);
    freq.put(" Am", 651);
    freq.put(" An", 1497);
    freq.put(" Ar", 1172);
    freq.put(" Au", 624);
    freq.put("yc\u030c", 534);
    freq.put("asi", 1254);
    freq.put("aso", 888);
    freq.put("asn", 1265);
    freq.put("omp", 910);
    freq.put("i\u0301k ", 1507);
    freq.put("c\u030ci\u0301t", 911);
    freq.put(" ek", 582);
    freq.put("c\u030ci\u0301s", 890);
    freq.put("oz\u030ci", 948);
    freq.put("oz\u030cn", 749);
    freq.put("w", 4336);
    freq.put("Eu", 967);
    freq.put("oc\u030ci", 806);
    freq.put("dis", 1227);
    freq.put("oz\u030ce", 1844);
    freq.put("le ", 3820);
    freq.put("Fra", 832);
    freq.put("ody", 570);
    freq.put("C\u030c", 2146);
    freq.put("o\u0302vo", 1350);
    freq.put(" el", 1140);
    freq.put(" en", 822);
    freq.put("kom", 7319);
    freq.put("kol", 2625);
    freq.put("kon", 5151);
    freq.put("koc", 987);
    freq.put("odp", 783);
    freq.put("koz", 582);
    freq.put(" ex", 1042);
    freq.put("jed", 5235);
    freq.put("jej", 1018);
    freq.put("jek", 1206);
    freq.put("kos", 1132);
    freq.put("kor", 769);
    freq.put("jen", 1683);
    freq.put("jem", 636);
    freq.put("omu", 756);
    freq.put("ys\u030c", 1686);
    freq.put("vni\u0301", 633);
    freq.put("d\u030cal", 723);
    freq.put("vne\u0301", 1199);
    freq.put("odu", 1909);
    freq.put("nci", 2449);
    freq.put("Slo", 2603);
    freq.put("odv", 550);
    freq.put("kop", 788);
    freq.put("vny\u0301", 1142);
    freq.put("jeh", 1159);
    freq.put("ste", 3353);
    freq.put("ka\u0301", 9527);
    freq.put("b", 79948);
    freq.put("s\u030cet", 1217);
    freq.put("kou", 1936);
    freq.put("ke\u0301", 8895);
    freq.put("sto", 7431);
    freq.put("sti", 10473);
    freq.put("ko\u0301", 650);
    freq.put("stu", 2162);
    freq.put("je ", 42288);
    freq.put("str", 11165);
    freq.put("ko\u0302", 554);
    freq.put("ku\u0301", 2339);
    freq.put("kov", 7957);
    freq.put("va\u0301 ", 4679);
    freq.put("ky\u0301", 14124);
    freq.put("s\u030cen", 585);
    freq.put("ka ", 13070);
    freq.put("odn", 6582);
    freq.put("la\u0301n", 627);
    freq.put("zyk", 1455);
    freq.put("oda", 688);
    freq.put("lie", 1755);
    freq.put("k ", 16704);
    freq.put("lia", 1970);
    freq.put("lic", 2198);
    freq.put("lin", 2535);
    freq.put("lik", 1405);
    freq.put("lit", 2952);
    freq.put("la\u0301d", 794);
    freq.put("liv", 1148);
    freq.put("2 ", 565);
    freq.put("lis", 1429);
    freq.put("liz", 1155);
    freq.put("ncu\u0301", 959);
    freq.put("vna", 1235);
    freq.put("vno", 1530);
    freq.put("M", 12887);
    freq.put("kan", 1054);
    freq.put("kam", 835);
    freq.put("jsk", 1191);
    freq.put("jst", 719);
    freq.put("kar", 683);
    freq.put("ast\u030c", 2479);
    freq.put("kat", 1398);
    freq.put("The", 619);
    freq.put("vny", 872);
    freq.put("kc", 1532);
    freq.put("ka", 21392);
    freq.put("li ", 2968);
    freq.put("sta\u0301", 1256);
    freq.put("ke", 14025);
    freq.put("sti\u0301", 1337);
    freq.put("ki", 2025);
    freq.put("ko", 41039);
    freq.put("kn", 913);
    freq.put("km", 4376);
    freq.put("kl", 6886);
    freq.put("kr", 12909);
    freq.put("ext", 753);
    freq.put("kv", 1473);
    freq.put("ku", 19211);
    freq.put("kt", 22417);
    freq.put("ky", 12637);
    freq.put("ojv", 611);
    freq.put("c\u030ci\u0301", 3126);
    freq.put("rto", 675);
    freq.put("nco", 652);
    freq.put("rti", 742);
    freq.put("ra\u0301l\u030c", 818);
    freq.put("oje", 2846);
    freq.put("re\u0301h", 740);
    freq.put("oja", 533);
    freq.put("ojn", 974);
    freq.put("ojo", 1042);
    freq.put("mi\u0301 ", 997);
    freq.put("ugu", 540);
    freq.put("oji", 587);
    freq.put("iez", 1705);
    freq.put("Ju", 970);
    freq.put("ies", 2613);
    freq.put("ier", 2554);
    freq.put("iet", 1590);
    freq.put("iev", 722);
    freq.put("ieh", 899);
    freq.put("iek", 2897);
    freq.put("Jo", 995);
    freq.put("iem", 1362);
    freq.put("iel", 2995);
    freq.put("a\u0301h", 1148);
    freq.put("Je", 4572);
    freq.put("Ja", 1230);
    freq.put("his", 874);
    freq.put("hit", 630);
    freq.put("rt ", 585);
    freq.put("i\u0301na", 690);
    freq.put("ika\u0301", 1538);
    freq.put("oj ", 736);
    freq.put("re\u0301 ", 3238);
    freq.put("sta", 10107);
    freq.put("ym ", 918);
    freq.put("ko ", 9276);
    freq.put("x", 5807);
    freq.put("stn", 2428);
    freq.put("c\u030ce", 6035);
    freq.put("sev", 1936);
    freq.put("ars", 1457);
    freq.put("c\u030ca", 9218);
    freq.put("ser", 859);
    freq.put("sep", 711);
    freq.put("c\u030cl", 1517);
    freq.put(" Bo", 1848);
    freq.put("c\u030cn", 7371);
    freq.put(" Bi", 821);
    freq.put("leb", 10035);
    freq.put("c\u030ck", 1668);
    freq.put("c\u030cu", 1013);
    freq.put("ara", 2212);
    freq.put("arc", 1318);
    freq.put("ard", 1508);
    freq.put("are", 1302);
    freq.put(" Br", 2086);
    freq.put("ari", 2403);
    freq.put("a\u0301pa", 2237);
    freq.put("aro", 2009);
    freq.put("zko", 574);
    freq.put("stv", 3596);
    freq.put("vla\u0301", 818);
    freq.put("kto", 15825);
    freq.put("ns\u030ct", 824);
    freq.put("lej", 738);
    freq.put("lek", 1883);
    freq.put("c\u030c ", 1105);
    freq.put("iku", 1353);
    freq.put("iky", 1322);
    freq.put("sts", 614);
    freq.put("ar ", 1338);
    freq.put("ika", 2006);
    freq.put("ike", 783);
    freq.put("se ", 2313);
    freq.put("vol\u030c", 584);
    freq.put("iko", 1475);
    freq.put("ikl", 600);
    freq.put(" Pr", 3280);
    freq.put("c", 129399);
    freq.put("rof", 585);
    freq.put(" Pa", 2173);
    freq.put("vys\u030c", 1099);
    freq.put("oc", 9865);
    freq.put(" Pe", 1292);
    freq.put(" Pi", 684);
    freq.put(" Po", 4736);
    freq.put(" Pl", 565);
    freq.put("y\u0301m ", 5866);
    freq.put("lex", 642);
    freq.put("ria\u0301", 846);
    freq.put("pr", 41771);
    freq.put("ps", 1762);
    freq.put("duk", 644);
    freq.put("pt", 2178);
    freq.put("pu", 2861);
    freq.put("py", 785);
    freq.put("pa", 10171);
    freq.put("pe", 7850);
    freq.put("vaz\u030c", 892);
    freq.put("ph", 797);
    freq.put("pi", 7377);
    freq.put("pn", 1091);
    freq.put("po", 39723);
    freq.put("pl", 7248);
    freq.put(" ty", 876);
    freq.put(" tv", 1722);
    freq.put(" tu", 1188);
    freq.put(" tr", 3662);
    freq.put("N", 7988);
    freq.put(" to", 6094);
    freq.put("gan", 1363);
    freq.put("gal", 592);
    freq.put("iec\u030c", 555);
    freq.put(" ti", 1601);
    freq.put(" th", 647);
    freq.put(" te", 5857);
    freq.put("sko", 6875);
    freq.put(" ta", 2281);
    freq.put("iel\u030c", 575);
    freq.put("du ", 2083);
    freq.put("p ", 1992);
    freq.put("fun", 734);
    freq.put("eke", 577);
    freq.put("vod", 4147);
    freq.put("c\u030cs\u030c", 1550);
    freq.put("no\u0301m", 573);
    freq.put("psk", 735);
    freq.put("vol", 995);
    freq.put("vom", 1769);
    freq.put("rit", 1644);
    freq.put("ris", 1567);
    freq.put("voj", 3988);
    freq.put("rin", 1063);
    freq.put("ars\u030c", 738);
    freq.put("ril", 574);
    freq.put("rim", 561);
    freq.put("eka", 784);
    freq.put("vor", 3219);
    freq.put("vos", 2079);
    freq.put("rig", 582);
    freq.put("rid", 872);
    freq.put("rie", 6455);
    freq.put("rib", 817);
    freq.put("ric", 4203);
    freq.put("ria", 5593);
    freq.put("po\u0302", 2385);
    freq.put("a\u0301st", 705);
    freq.put("mos", 887);
    freq.put("vy ", 2098);
    freq.put("pa\u0301", 1327);
    freq.put("mor", 1939);
    freq.put("spe", 1357);
    freq.put("ac", 10837);
    freq.put("pi\u0301", 1372);
    freq.put(" ty\u0301", 674);
    freq.put("vo ", 5058);
    freq.put("tis", 1709);
    freq.put("syn", 543);
    freq.put("sys", 1453);
    freq.put("mot", 1139);
    freq.put("ri ", 3554);
    freq.put("vyr", 543);
    freq.put("vys", 1291);
    freq.put(" fr", 1747);
    freq.put(" fu", 1061);
    freq.put("vyt", 825);
    freq.put("kni", 537);
    freq.put(" fy", 712);
    freq.put(" fa", 975);
    freq.put(" fe", 960);
    freq.put("vyd", 936);
    freq.put("y", 75446);
    freq.put(" fo", 1624);
    freq.put(" uz\u030c", 616);
    freq.put("c\u030cle", 748);
    freq.put("c\u030clo", 565);
    freq.put("O ", 889);
    freq.put("uc\u030c", 1098);
    freq.put("na\u0301c", 533);
    freq.put("na\u0301l", 1168);
    freq.put("na\u0301m", 1836);
    freq.put("na\u0301r", 2386);
    freq.put("rga", 1225);
    freq.put("na\u0301v", 764);
    freq.put("rge", 623);
    freq.put("na\u0301z", 1745);
    freq.put("rgi", 554);
    freq.put("l\u0301", 1392);
    freq.put("t\u030cah", 745);
    freq.put("bil", 932);
    freq.put("ba\u0301", 980);
    freq.put("bi\u0301", 670);
    freq.put("bie", 1078);
    freq.put("Ob", 931);
    freq.put("bia", 583);
    freq.put("by\u0301", 960);
    freq.put("Or", 779);
    freq.put("na\u0301 ", 9951);
    freq.put("uz\u030c", 5423);
    freq.put("d", 146397);
    freq.put("Ma\u0301 ", 570);
    freq.put("us\u030c", 1188);
    freq.put("apo", 817);
    freq.put("b ", 2037);
    freq.put("ru ", 1693);
    freq.put("vne", 2233);
    freq.put("e\u0301ho", 11278);
    freq.put("zo ", 1433);
    freq.put("ra ", 5741);
    freq.put("pev", 859);
    freq.put("per", 2191);
    freq.put("pel", 545);
    freq.put("pen", 751);
    freq.put("t", 244072);
    freq.put("bd", 823);
    freq.put("be", 9106);
    freq.put("ruh", 2733);
    freq.put("ba", 5147);
    freq.put("bc", 1208);
    freq.put("bl", 4818);
    freq.put("bn", 3071);
    freq.put("bo", 22917);
    freq.put("bi", 5066);
    freq.put("bj", 2626);
    freq.put("nac\u030c", 2104);
    freq.put("bu", 4959);
    freq.put("Bol", 718);
    freq.put("br", 6137);
    freq.put("bs", 2133);
    freq.put("rus", 1271);
    freq.put("kal", 813);
    freq.put("by", 4846);
    freq.put("che", 1676);
    freq.put("lny", 1606);
    freq.put("t\u030c", 13944);
    freq.put("a\u0308", 4507);
    freq.put("idl", 708);
    freq.put("t\u030cou", 1264);
    freq.put("ide", 1943);
    freq.put("pe ", 579);
    freq.put("dza", 3109);
    freq.put("ida", 634);
    freq.put("nsk", 12019);
    freq.put("tuj", 829);
    freq.put("usk", 1487);
    freq.put(" ur", 1335);
    freq.put(" us", 808);
    freq.put(" um", 1379);
    freq.put(" un", 575);
    freq.put("nst", 911);
    freq.put("ci ", 4101);
    freq.put("at\u030c ", 1963);
    freq.put("ne\u0301t", 1209);
    freq.put("u ", 50841);
    freq.put("gre\u0301", 723);
    freq.put(" Ch", 1547);
    freq.put(" Co", 1476);
    freq.put(" Ca", 1107);
    freq.put(" Ce", 603);
    freq.put("tru", 1300);
    freq.put("t\u030caz\u030c", 646);
    freq.put("l\u030cko", 705);
    freq.put("cic", 1003);
    freq.put("cia", 4155);
    freq.put("ktu\u0301", 719);
    freq.put("cie", 3755);
    freq.put("uz", 979);
    freq.put("exi", 778);
    freq.put("ut", 6390);
    freq.put("cii", 806);
    freq.put("uv", 941);
    freq.put("cio", 1122);
    freq.put("up", 5983);
    freq.put("us", 8894);
    freq.put("ur", 8100);
    freq.put("um", 6737);
    freq.put("ul", 5494);
    freq.put("un", 5022);
    freq.put("ui", 653);
    freq.put("uh", 4698);
    freq.put("uk", 2909);
    freq.put("uj", 8555);
    freq.put("ue", 827);
    freq.put("ud", 5636);
    freq.put("ug", 1127);
    freq.put("z", 92877);
    freq.put("ua", 850);
    freq.put("uc", 2067);
    freq.put("ub", 3487);
    freq.put("Tu", 851);
    freq.put("Tr", 1334);
    freq.put("d\u030c", 2808);
    freq.put("ste\u0301", 1586);
    freq.put("To", 1259);
    freq.put("vot", 802);
    freq.put("Th", 927);
    freq.put("Ti", 635);
    freq.put("Te", 1474);
    freq.put("Ta", 1216);
    freq.put("A ", 1884);
    freq.put("Mar", 1239);
    freq.put(" gr", 1776);
    freq.put("nad", 1643);
    freq.put("naj", 5055);
    freq.put("nak", 996);
    freq.put("nan", 1218);
    freq.put("nal", 1254);
    freq.put("nam", 2854);
    freq.put("nar", 576);
    freq.put("nas", 648);
    freq.put("nap", 1468);
    freq.put(" ge", 918);
    freq.put("nav", 578);
    freq.put("nat", 1148);
    freq.put("gra", 2234);
    freq.put("naz", 679);
    freq.put("ze\u0301m", 590);
    freq.put("Mal", 724);
    freq.put("z\u030ce ", 2141);
    freq.put("l\u030cky\u0301", 597);
    freq.put(" ci", 1436);
    freq.put("dl\u030ca", 1494);
    freq.put("zaj", 992);
    freq.put("svo", 1166);
    freq.put("cia\u0301", 1302);
    freq.put("e", 441234);
    freq.put("sve", 2116);
    freq.put("Am", 652);
    freq.put("Al", 1539);
    freq.put("cii\u0301", 762);
    freq.put("An", 1498);
    freq.put("ahu", 1045);
    freq.put("lu ", 1579);
    freq.put("Ar", 1181);
    freq.put("s\u030cko", 920);
    freq.put("ly\u0301 ", 669);
    freq.put("u\u0301", 38043);
    freq.put("ua\u0301", 1391);
    freq.put(" b", 16567);
    freq.put(" c", 8497);
    freq.put("gu", 2013);
    freq.put(" a", 59730);
    freq.put(" f", 10527);
    freq.put(" g", 4634);
    freq.put(" d", 25382);
    freq.put(" e", 6213);
    freq.put(" j", 50814);
    freq.put(" k", 41715);
    freq.put(" h", 15481);
    freq.put(" i", 8376);
    freq.put(" n", 43761);
    freq.put(" o", 37444);
    freq.put(" l", 8693);
    freq.put(" m", 31843);
    freq.put(" r", 25827);
    freq.put(" s", 70586);
    freq.put(" p", 76912);
    freq.put(" v", 69047);
    freq.put(" t", 26154);
    freq.put(" u", 8583);
    freq.put(" z", 33097);
    freq.put("gn", 1011);
    freq.put("gm", 704);
    freq.put("gl", 1862);
    freq.put("gi", 5874);
    freq.put("gh", 727);
    freq.put(" B", 10746);
    freq.put(" C", 6977);
    freq.put(" A", 10024);
    freq.put(" F", 4466);
    freq.put(" G", 4666);
    freq.put(" D", 6268);
    freq.put(" E", 4439);
    freq.put(" J", 8409);
    freq.put(" K", 8577);
    freq.put(" H", 6876);
    freq.put(" I", 5508);
    freq.put(" N", 7962);
    freq.put(" O", 4629);
    freq.put(" L", 6098);
    freq.put(" M", 12833);
    freq.put(" R", 6787);
    freq.put(" S", 17653);
    freq.put(" P", 14620);
    freq.put(" V", 8804);
    freq.put(" W", 2297);
    freq.put(" T", 8683);
    freq.put(" U", 2760);
    freq.put(" Z", 3841);
    freq.put("Nov", 633);
    freq.put("rc\u030ci", 735);
    freq.put("ch ", 28988);
    freq.put("ed ", 1409);
    freq.put("oza\u0301", 729);
    freq.put("Vel\u030c", 631);
    freq.put("kci", 1471);
    freq.put("P", 14691);
    freq.put("g ", 2452);
    freq.put("tri", 3765);
    freq.put("evi", 600);
    freq.put("evn", 668);
    freq.put("evo", 552);
    freq.put("tra", 5412);
    freq.put("eva", 786);
    freq.put("s\u030cta\u0301", 2185);
    freq.put("tre", 4383);
    freq.put("eve", 2813);
    freq.put("Spo", 812);
    freq.put("nu\u0301 ", 1355);
    freq.put("ri\u0301s", 711);
    freq.put("zl", 2181);
    freq.put("zm", 4191);
    freq.put("zn", 10586);
    freq.put("zo", 9017);
    freq.put("zh", 1017);
    freq.put("zi", 7079);
    freq.put("zk", 1321);
    freq.put("zd", 5109);
    freq.put("ze", 5890);
    freq.put("odr", 641);
    freq.put("ods", 1082);
    freq.put("za", 12274);
    freq.put("zb", 854);
    freq.put("n\u030cov", 688);
    freq.put("odi", 1507);
    freq.put("zy", 2080);
    freq.put("ga\u0301", 620);
    freq.put("odo", 2687);
    freq.put(" u\u0301", 5607);
    freq.put("zu", 1736);
    freq.put("zv", 3082);
    freq.put("zp", 940);
    freq.put("ode", 2380);
    freq.put("zr", 1156);
    freq.put("zs", 1637);
    freq.put(" vs\u030c", 1583);
    freq.put("iz\u030cn", 609);
    freq.put("bdo", 679);
    freq.put("re\u0301c", 806);
    freq.put("ych", 3717);
    freq.put("rd ", 682);
    freq.put("oci", 1231);
    freq.put("ozd", 725);
    freq.put("lec", 545);
    freq.put("led", 1215);
    freq.put("c\u030cka", 799);
    freq.put("ozn", 2417);
    freq.put("ozo", 2454);
    freq.put("ozl", 939);
    freq.put("ozm", 884);
    freq.put("z ", 10294);
    freq.put("len", 3929);
    freq.put("ler", 562);
    freq.put("les", 1366);
    freq.put("let", 1210);
    freq.put("od ", 5680);
    freq.put("lez", 532);
    freq.put(" zm", 1324);
    freq.put("tri\u0301", 632);
    freq.put("z\u030ci\u0301 ", 1158);
    freq.put("tra\u0301", 1603);
    freq.put("eva\u0301", 647);
    freq.put("tac\u030c", 896);
    freq.put(" Do", 1293);
    freq.put(" S\u030c", 1929);
    freq.put(" s\u030c", 8376);
    freq.put(" Di", 709);
    freq.put("apr", 1545);
    freq.put("oce", 1370);
    freq.put(" De", 1164);
    freq.put(" Da", 898);
    freq.put("a\u0301vn", 1077);
    freq.put("a\u0301vi", 600);
    freq.put(" z\u030c", 4854);
    freq.put("a\u0301va", 2985);
    freq.put(" Z\u030c", 833);
    freq.put("cha", 2180);
    freq.put("Fr", 1190);
    freq.put(" va\u0308", 714);
    freq.put("chi", 1393);
    freq.put("chl", 672);
    freq.put("chn", 823);
    freq.put("cho", 6193);
    freq.put("Fa", 561);
    freq.put("chr", 824);
    freq.put("ust", 1684);
    freq.put("chu", 807);
    freq.put("zt\u030c", 610);
    freq.put("zin", 1015);
    freq.put("Fi", 588);
    freq.put("ruz\u030c", 608);
    freq.put(" vy\u0301", 6398);
    freq.put(" od", 6282);
    freq.put("\u043e", 715);
    freq.put("a\u0308c\u030cs\u030c", 1545);
    freq.put("ien", 1741);
    freq.put("om", 35081);
    freq.put("ral", 930);
    freq.put("za\u0301c", 1029);
    freq.put("dze", 584);
    freq.put(" l\u030c", 2475);
    freq.put("i\u0301zk", 541);
    freq.put(" Ru", 1047);
    freq.put("el\u030c ", 1241);
    freq.put("oi", 991);
    freq.put("f", 24135);
    freq.put("ac\u030cu", 636);
    freq.put("oh", 6762);
    freq.put(" d\u030c", 577);
    freq.put(" C\u030c", 2146);
    freq.put(" c\u030c", 11970);
    freq.put(" Re", 1042);
    freq.put("dzi", 3041);
    freq.put(" Ra", 1479);
    freq.put("zi ", 1861);
    freq.put(" Ro", 1415);
    freq.put(" Ri", 640);
    freq.put("aci", 1802);
    freq.put("tat", 1770);
    freq.put("tav", 3617);
    freq.put("od", 30890);
    freq.put("tar", 2723);
    freq.put("tas", 556);
    freq.put("ic\u030cn", 889);
    freq.put("ac\u030c", 5846);
    freq.put("ne\u0301h", 4120);
    freq.put("oc\u030cn", 2672);
    freq.put("tad", 583);
    freq.put("C\u030ce", 1109);
    freq.put("oa", 684);
    freq.put("tal", 2000);
    freq.put("tan", 2795);
    freq.put("ly ", 1425);
    freq.put("tak", 1277);
    freq.put(" va", 859);
    freq.put("cha\u0301", 3113);
    freq.put(" ve", 5421);
    freq.put("afi", 807);
    freq.put(" vi", 1930);
    freq.put("a\u0301dz", 3180);
    freq.put(" vl", 2079);
    freq.put(" vo", 6181);
    freq.put(" vn", 537);
    freq.put("sia", 1333);
    freq.put(" vr", 1254);
    freq.put("za\u0301p", 1954);
    freq.put("sie", 988);
    freq.put(" vy", 7755);
    freq.put("rva\u0301", 821);
    freq.put(" vz", 3164);
    freq.put("o\u0302", 6119);
    freq.put("el\u030cs", 559);
    freq.put("odl\u030c", 1432);
    freq.put("ia\u0301l", 1808);
    freq.put("el\u030ca", 1087);
    freq.put("ta ", 5658);
    freq.put("el\u030ck", 1782);
    freq.put("ro\u0301p", 1084);
    freq.put("el\u030cm", 560);
    freq.put("lez\u030c", 1031);
    freq.put("el\u030co", 2345);
    freq.put(" v ", 29073);
    freq.put("kra", 3230);
    freq.put("s\u030cta", 1049);
    freq.put("l\u030cav", 960);
    freq.put("s\u030cti", 599);
    freq.put("si ", 1248);
    freq.put("s\u030ctr", 907);
    freq.put("u\u0301l", 805);
    freq.put("u\u0301n", 866);
    freq.put("ske\u0301", 3823);
    freq.put("u\u0301h", 1142);
    freq.put("u\u0301d", 1600);
    freq.put("bje", 988);
    freq.put("u\u0301b", 634);
    freq.put("u\u0301c", 5635);
    freq.put("u\u0301z", 3206);
    freq.put("u\u0301t", 1527);
    freq.put("u\u0301v", 565);
    freq.put("u\u0301p", 696);
    freq.put("u\u0301r", 2901);
    freq.put("u\u0301s", 2474);
    freq.put("ld", 1271);
    freq.put("le", 30292);
    freq.put("lb", 1616);
    freq.put("tsk", 2708);
    freq.put("la", 30632);
    freq.put("ln", 9477);
    freq.put("lo", 31336);
    freq.put("ll", 2885);
    freq.put("lm", 1360);
    freq.put("lk", 2208);
    freq.put("lh", 1065);
    freq.put("li", 23938);
    freq.put("lt", 2514);
    freq.put("lu", 4726);
    freq.put("ls", 1845);
    freq.put("ly", 3287);
    freq.put("na ", 25237);
    freq.put("tny\u0301", 1463);
    freq.put("dal", 718);
    freq.put("dan", 1747);
    freq.put("u\u0301 ", 11007);
    freq.put("daj", 777);
    freq.put("dat", 690);
    freq.put("Pre", 892);
    freq.put("s ", 19518);
    freq.put("l ", 16112);
    freq.put("nfo", 594);
    freq.put(" hr", 2464);
    freq.put("Pro", 592);
    freq.put(" hv", 1179);
    freq.put(" hu", 1376);
    freq.put(" hi", 1068);
    freq.put(" ho", 3959);
    freq.put(" hm", 698);
    freq.put(" hl", 2110);
    freq.put(" ha", 599);
    freq.put("sil", 824);
    freq.put("by ", 1911);
    freq.put("su\u0301h", 1058);
    freq.put("ec ", 2815);
    freq.put("urc\u030c", 1357);
    freq.put("met", 2730);
    freq.put("mar", 970);
    freq.put("en\u030c ", 963);
    freq.put("su\u0301s", 702);
    freq.put("h ", 31639);
    freq.put("hla", 2518);
    freq.put("Pol\u030c", 669);
    freq.put("la\u0301", 5471);
    freq.put("res", 5921);
    freq.put("Tur", 593);
    freq.put("li\u0301", 2945);
    freq.put("rev", 1170);
    freq.put("ret", 2145);
    freq.put("le\u0301", 1049);
    freq.put("rej", 1959);
    freq.put("rek", 894);
    freq.put("reh", 593);
    freq.put("ren", 3464);
    freq.put("lo\u0301", 2004);
    freq.put("rel", 975);
    freq.put("rem", 1118);
    freq.put("reb", 974);
    freq.put("rec", 1162);
    freq.put("ly\u0301", 1452);
    freq.put("lu\u0301", 1099);
    freq.put("reg", 962);
    freq.put("red", 6538);
    freq.put("ece", 694);
    freq.put("ecn", 583);
    freq.put("su\u0301 ", 2895);
    freq.put("ou ", 11758);
    freq.put("eck", 2662);
    freq.put("eci", 648);
    freq.put("ech", 1905);
    freq.put("ie ", 19237);
    freq.put("g", 31408);
    freq.put("ono", 1770);
    freq.put("re ", 5558);
    freq.put("Z\u030c", 835);
    freq.put("ta\u0301t", 2299);
    freq.put(" Be", 1433);
    freq.put("ta\u0301v", 759);
    freq.put("ta\u0301r", 638);
    freq.put("rs ", 542);
    freq.put("ta\u0301c", 584);
    freq.put("ta\u0301l", 1075);
    freq.put(" Ba", 1854);
    freq.put("be ", 819);
    freq.put("w ", 706);
    freq.put(" Sv", 647);
    freq.put("nda", 660);
    freq.put(" St", 2410);
    freq.put(" Su", 611);
    freq.put(" Si", 774);
    freq.put(" So", 1114);
    freq.put(" Sl", 3357);
    freq.put(" Sc", 533);
    freq.put(" Sa", 1649);
    freq.put("c\u030co", 2826);
    freq.put(" Se", 1428);
    freq.put("Ka", 2174);
    freq.put("ii ", 2231);
    freq.put("rsk", 3778);
    freq.put("c\u030ci", 6991);
    freq.put("Ko", 2065);
    freq.put("zna", 5129);
    freq.put("ogr", 1539);
    freq.put("Kr", 1442);
    freq.put("R", 6826);
    freq.put("ogi", 1853);
    freq.put("eho", 5071);
    freq.put("rst", 1039);
    freq.put("mo\u0302z\u030c", 675);
    freq.put("u\u0301ze", 2017);
    freq.put("lo\u0301g", 1712);
    freq.put("udo", 1777);
    freq.put("u\u0301c\u030c", 2819);
    freq.put("ben", 812);
    freq.put("c\u030ct", 541);
    freq.put("bec", 1805);
    freq.put("cke\u0301", 4043);
    freq.put("bez", 962);
    freq.put("ik ", 1390);
    freq.put("uro\u0301", 1104);
    freq.put("ber", 2830);
    freq.put("y\u0301", 65120);
    freq.put("Par", 649);
    freq.put("da\u0301 ", 670);
    freq.put("ouz\u030c", 1757);
    freq.put("sen", 856);
    freq.put("ark", 750);
    freq.put("rez\u030c", 722);
    freq.put("mil", 710);
    freq.put("min", 2367);
    freq.put("mia", 681);
    freq.put("mic", 1764);
    freq.put("mie", 3132);
    freq.put("hr", 6312);
    freq.put("mit", 579);
    freq.put("da\u0301v", 586);
    freq.put("st ", 1149);
    freq.put(" Eu", 965);
    freq.put("n\u030c ", 1274);
    freq.put("cke", 2891);
    freq.put("mus", 1219);
    freq.put("u\u0301hv", 785);
    freq.put("mi ", 7759);
    freq.put("cko", 2082);
    freq.put("uro", 616);
    freq.put("uri", 613);
    freq.put("Pod", 721);
    freq.put("cky", 1826);
    freq.put("ty\u0301 ", 1101);
    freq.put(" zv", 1435);
    freq.put("hm", 1007);
    freq.put("z\u030civ", 1147);
    freq.put("z\u030cit", 1013);
    freq.put("z\u030cij", 593);
    freq.put("z\u030cin", 599);
    freq.put("z\u030cil", 543);
    freq.put("da ", 3499);
    freq.put("z\u030cia", 1434);
    freq.put("nge", 617);
    freq.put("jaz", 1897);
    freq.put("jav", 2393);
    freq.put("vs\u030ce", 1630);
    freq.put("jan", 692);
    freq.put("ae ", 616);
    freq.put(" in", 4275);
    freq.put("jad", 617);
    freq.put(" ic", 916);
    freq.put(" id", 930);
    freq.put("l\u030c", 19160);
    freq.put("ty\u0301c", 709);
    freq.put("no ", 2111);
    freq.put("ty\u0301m", 683);
    freq.put("ude", 572);
    freq.put("ng ", 1176);
    freq.put("h", 115571);
    freq.put("a\u0301ko", 904);
    freq.put("a\u0301kl", 1321);
    freq.put("s\u030cie", 2695);
    freq.put("s\u030cia", 856);
    freq.put("ja ", 1196);
    freq.put("z\u030c", 30532);
    freq.put("Pr", 3288);
    freq.put("vs\u030c", 2161);
    freq.put("jne", 544);
    freq.put(" s\u030ct", 4899);
    freq.put("ebo", 10260);
    freq.put("C", 7078);
    freq.put("ke ", 2633);
    freq.put("Pa", 2196);
    freq.put("ebr", 822);
    freq.put("Pe", 1293);
    freq.put("ede", 2996);
    freq.put("Pi", 686);
    freq.put("Po", 4755);
    freq.put("Pl", 567);
    freq.put("dla", 715);
    freq.put("ome", 2634);
    freq.put("dli", 698);
    freq.put("dlh", 673);
    freq.put("dlo", 1153);
    freq.put("et ", 1437);
    freq.put("C\u030ces", 624);
    freq.put("ta\u0301 ", 794);
    freq.put("kej", 7958);
    freq.put("jov", 1599);
    freq.put("keh", 993);
    freq.put("ked", 587);
    freq.put("vrc", 1038);
    freq.put("S", 17764);
    freq.put("edk", 836);
    freq.put("jom", 624);
    freq.put("etr", 1705);
    freq.put("ets", 539);
    freq.put("sov", 2280);
    freq.put("byv", 1443);
    freq.put("tla", 755);
    freq.put("eta", 1992);
    freq.put("ete", 2049);
    freq.put("etk", 1257);
    freq.put("tli", 832);
    freq.put("eti", 2038);
    freq.put("etn", 619);
    freq.put("eto", 2278);
    freq.put("ck", 22292);
    freq.put("va\u0301", 7870);
    freq.put("ci", 21044);
    freq.put("ch", 49042);
    freq.put("co", 4858);
    freq.put("cn", 1009);
    freq.put("ve\u0301", 4595);
    freq.put("ca", 6242);
    freq.put("vi\u0301", 1466);
    freq.put("ce", 12657);
    freq.put("oho", 1731);
    freq.put("vy\u0301", 14470);
    freq.put("cu", 1353);
    freq.put("ct", 1197);
    freq.put("eo\u0301r", 603);
    freq.put("rvk", 581);
    freq.put("Na\u0301", 658);
    freq.put("ve\u0301h", 1297);
    freq.put("vy\u0301 ", 3640);
    freq.put("oti", 1114);
    freq.put("otk", 570);
    freq.put("otn", 953);
    freq.put("oto", 4368);
    freq.put("n\u030ca ", 821);
    freq.put("rvo", 671);
    freq.put("c ", 5075);
    freq.put("edo", 1996);
    freq.put("ote", 984);
    freq.put("oha", 677);
    freq.put("otr", 702);
    freq.put("c\u030cit", 761);
    freq.put("otv", 654);
    freq.put("lli", 641);
    freq.put("vy\u0301z", 1213);
    freq.put("ndr", 573);
    freq.put("e\u0301", 45424);
    freq.put("cov", 2204);
    freq.put("vy\u0301r", 1121);
    freq.put("vy\u0301s", 904);
    freq.put("emi\u0301", 1248);
    freq.put("vy\u0301m", 1096);
    freq.put("au", 4063);
    freq.put("eur", 694);
    freq.put("vy\u0301c", 4086);
    freq.put("ohy", 806);
    freq.put("va", 30715);
    freq.put("vc", 1194);
    freq.put("avy", 1063);
    freq.put("ci\u0301", 1219);
    freq.put("vi", 16426);
    freq.put("vk", 1421);
    freq.put("vl", 2565);
    freq.put("uz\u030ci\u0301", 1835);
    freq.put("vn", 10339);
    freq.put("vo", 27546);
    freq.put(" Fa", 559);
    freq.put("cu\u0301", 1023);
    freq.put("vr", 2972);
    freq.put("vs", 3111);
    freq.put("vu", 2054);
    freq.put("ohu", 747);
    freq.put(" Fi", 580);
    freq.put("ave", 2415);
    freq.put("vz", 3443);
    freq.put("ava", 2084);
    freq.put("of ", 750);
    freq.put("pis", 1414);
    freq.put("Zem", 545);
    freq.put("va\u0301c", 643);
    freq.put("ju\u0301c", 4607);
    freq.put("e\u0301mu", 984);
    freq.put("va\u0301r", 636);
    freq.put("ic\u030c", 3422);
    freq.put("v ", 48812);
    freq.put("eds", 867);
    freq.put("iov", 556);
    freq.put("iou", 1025);
    freq.put("ion", 1878);
    freq.put("av ", 719);
    freq.put("e\u0301m ", 887);
    freq.put("ont", 1301);
    freq.put("i", 290888);
    freq.put(" Tu", 845);
    freq.put("ofi", 1501);
    freq.put(" Tr", 1332);
    freq.put("ju\u0301 ", 3234);
    freq.put(" To", 1247);
    freq.put(" Ti", 628);
    freq.put(" Th", 921);
    freq.put(" Te", 1468);
    freq.put(" Ta", 1213);
    freq.put("o\u0302z\u030ce", 563);
    freq.put("hl\u030c", 938);
    freq.put("i\u0301dl", 750);
    freq.put(" me", 12179);
    freq.put("iva", 615);
    freq.put("sku", 6994);
    freq.put("Be", 1438);
    freq.put("adu", 813);
    freq.put("adr", 867);
    freq.put("Ba", 1863);
    freq.put("a\u0301t ", 1099);
    freq.put("skr", 1088);
    freq.put("Bo", 1866);
    freq.put("sky", 4413);
    freq.put("Bi", 824);
    freq.put("vat\u030c", 944);
    freq.put("ske", 5984);
    freq.put("Bu", 812);
    freq.put("ade", 3266);
    freq.put("ska", 3470);
    freq.put("Br", 2094);
    freq.put("ada", 1861);
    freq.put("adn", 3195);
    freq.put("ado", 1644);
    freq.put("adl", 645);
    freq.put("ora\u0301", 2973);
    freq.put("ski", 627);
    freq.put(" mn", 871);
    freq.put("adi", 1835);
    freq.put("o\u0301ps", 667);
    freq.put("oru\u0301", 1676);
    freq.put("T", 8739);
    freq.put("fyz", 775);
    freq.put("a\u0301te", 733);
    freq.put(" ju\u0301", 829);
    freq.put("a\u0301tn", 563);
    freq.put("a\u0301to", 1594);
    freq.put("a\u0301tk", 775);
    freq.put("i\u0301va", 2087);
    freq.put("a\u0301tu", 553);
    freq.put("ad ", 2628);
    freq.put("ltu\u0301", 839);
    freq.put("dl\u0301", 1132);
    freq.put("kra\u0301", 1832);
    freq.put("i\u0301vn", 1999);
    freq.put("o\u0301ri", 1260);
    freq.put("vst", 887);
    freq.put("nce", 985);
    freq.put("edz", 3180);
    freq.put("vsk", 2197);
    freq.put("o\u0302so", 1218);
    freq.put("esu", 1559);
    freq.put("est", 8782);
    freq.put("esp", 670);
    freq.put("sky\u0301", 5535);
    freq.put("nd ", 984);
    freq.put("sku\u0301", 704);
    freq.put("ese", 2018);
    freq.put("ska\u0301", 3010);
    freq.put("iso", 851);
    freq.put("esa", 609);
    freq.put("ada\u0301", 567);
    freq.put("eso", 1170);
    freq.put("esn", 932);
    freq.put("esk", 2173);
    freq.put("esi", 987);
    freq.put("z\u030cno", 718);
    freq.put("z\u030cne", 1488);
    freq.put("ndi", 836);
    freq.put("y\u0301ro", 660);
    freq.put("i\u0301s\u030c", 617);
    freq.put("ndo", 698);
    freq.put(" ju", 2279);
    freq.put("iez\u030c", 1149);
    freq.put("nde", 718);
    freq.put("y\u0301ra", 532);
    freq.put("edy", 1130);
    freq.put("kri", 597);
    freq.put("kro", 679);
    freq.put("es ", 3178);
    freq.put(" je", 43951);
    freq.put("i\u0301z\u030c", 736);
    freq.put(" ja", 3535);
    freq.put("kre", 4381);
    freq.put("iny\u0301", 615);
    freq.put("duc", 748);
    freq.put("owi", 541);
    freq.put("ine\u0301", 635);
    freq.put("my ", 1946);
    freq.put("bu ", 703);
    freq.put("ina\u0301", 2028);
    freq.put("vaj", 1282);
    freq.put(" C\u030ce", 1108);
    freq.put("van", 10444);
    freq.put("val", 2956);
    freq.put("vac", 763);
    freq.put("isc", 586);
    freq.put("rch", 2256);
    freq.put("js\u030ci", 1295);
    freq.put("var", 1669);
    freq.put("a\u0301l\u030co", 612);
    freq.put("vat", 3033);
    freq.put("hy", 2860);
    freq.put("eob", 637);
    freq.put("bur", 546);
    freq.put("hv", 2290);
    freq.put("ht", 1214);
    freq.put("hu", 6079);
    freq.put("hi", 3695);
    freq.put("hn", 2117);
    freq.put("ho", 33938);
    freq.put("hl", 4308);
    freq.put("bum", 1025);
    freq.put("ha", 6720);
    freq.put("bud", 728);
    freq.put("he", 5122);
    freq.put("dmi", 940);
    freq.put("va ", 7123);
    freq.put("j", 124158);
    freq.put("ajv", 1703);
    freq.put("iny", 3026);
    freq.put("pin", 2362);
    freq.put("int", 1331);
    freq.put("inu", 1322);
    freq.put("mys", 1196);
    freq.put("pie", 636);
    freq.put("ins", 1181);
    freq.put("inn", 1036);
    freq.put("ino", 2279);
    freq.put("ini", 1596);
    freq.put("ink", 652);
    freq.put("ind", 914);
    freq.put("ine", 3297);
    freq.put("inf", 730);
    freq.put("ing", 1758);
    freq.put("pit", 610);
    freq.put("ina", 4033);
    freq.put("inc", 1687);
    freq.put("i\u0301 ", 13762);
    freq.put("zvy", 552);
    freq.put("js\u030ci\u0301", 951);
    freq.put("or ", 2600);
    freq.put("rez", 1012);
    freq.put("hy\u0301", 981);
    freq.put("he\u0301", 650);
    freq.put("U", 2767);
    freq.put("ubl", 1069);
    freq.put("aji", 1734);
    freq.put("ha\u0301", 3987);
    freq.put("in ", 1617);
    freq.put("i\u0301d", 1198);
    freq.put("i\u0301c", 3944);
    freq.put("i\u0301m", 4401);
    freq.put("i\u0301l", 827);
    freq.put("i\u0301n", 4699);
    freq.put(" l\u030cu", 1198);
    freq.put("i\u0301k", 3632);
    freq.put("eol", 809);
    freq.put("zmu", 1473);
    freq.put("i\u0301t", 2918);
    freq.put("i\u0301v", 4551);
    freq.put("hnu", 694);
    freq.put("i\u0301p", 1003);
    freq.put("i\u0301s", 3116);
    freq.put("i\u0301r", 2051);
    freq.put(" l\u030ca", 1263);
    freq.put("rep", 1499);
    freq.put("i\u0301z", 1142);
  }
  
}

