package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class SCO extends CLangProfile {
  private static final String name = "sco";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public SCO() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 59263;
    n_words[1] = 74556;
    n_words[2] = 57324;

    freq.put("gai", 31);
    freq.put("all", 26);
    freq.put("gae", 87);
    freq.put("alk", 3);
    freq.put("auc", 25);
    freq.put("aub", 3);
    freq.put("aud", 17);
    freq.put("aug", 7);
    freq.put("auf", 10);
    freq.put("auk", 35);
    freq.put("aum", 8);
    freq.put("aul", 75);
    freq.put("up ", 62);
    freq.put("aun", 101);
    freq.put("aup", 4);
    freq.put("xte", 4);
    freq.put("aur", 65);
    freq.put("aut", 4);
    freq.put(" Gu", 14);
    freq.put(" Gr", 4);
    freq.put("Joh", 12);
    freq.put(" Ga", 21);
    freq.put(" Go", 17);
    freq.put(" Gi", 19);
    freq.put("upo", 29);
    freq.put("Gu", 14);
    freq.put("Gr", 4);
    freq.put("Ga", 21);
    freq.put("xt ", 6);
    freq.put("Go", 17);
    freq.put("ups", 5);
    freq.put("Gi", 19);
    freq.put("me ", 147);
    freq.put(" ke", 88);
    freq.put(" ki", 45);
    freq.put(" kn", 10);
    freq.put(" ky", 8);
    freq.put("wd ", 7);
    freq.put("nei", 12);
    freq.put("ned", 7);
    freq.put("nee", 23);
    freq.put("nec", 5);
    freq.put("nea", 10);
    freq.put("new", 5);
    freq.put("net", 33);
    freq.put("ak ", 64);
    freq.put("ner", 24);
    freq.put("nes", 25);
    freq.put("mee", 23);
    freq.put("med", 8);
    freq.put("mea", 4);
    freq.put("meb", 9);
    freq.put("mel", 5);
    freq.put("men", 31);
    freq.put("ors", 18);
    freq.put("met", 6);
    freq.put("mes", 13);
    freq.put("aid", 81);
    freq.put("mey", 4);
    freq.put("ee ", 102);
    freq.put("dry", 4);
    freq.put(" yi", 3);
    freq.put("wde", 11);
    freq.put("glo", 11);
    freq.put("aks", 7);
    freq.put(" ya", 10);
    freq.put("k", 879);
    freq.put("dru", 10);
    freq.put(" ye", 196);
    freq.put("ne ", 158);
    freq.put("dri", 13);
    freq.put("aki", 5);
    freq.put("orm", 4);
    freq.put(" Is", 7);
    freq.put("dra", 8);
    freq.put("dre", 15);
    freq.put("ake", 5);
    freq.put("nk ", 26);
    freq.put("bru", 3);
    freq.put("bro", 11);
    freq.put(" It", 30);
    freq.put("bri", 20);
    freq.put("bre", 15);
    freq.put("bra", 38);
    freq.put("dne", 3);
    freq.put("dna", 53);
    freq.put("m ", 230);
    freq.put("aus", 18);
    freq.put("er ", 501);
    freq.put("Sta", 3);
    freq.put("nki", 11);
    freq.put("nkl", 3);
    freq.put("nks", 7);
    freq.put("nky", 3);
    freq.put("me", 291);
    freq.put("Til", 4);
    freq.put("erv", 12);
    freq.put("erw", 6);
    freq.put("ma", 381);
    freq.put("err", 10);
    freq.put("mb", 6);
    freq.put("mm", 38);
    freq.put("ml", 11);
    freq.put("mo", 66);
    freq.put("mn", 4);
    freq.put("mi", 80);
    freq.put("ery", 3);
    freq.put("mu", 58);
    freq.put("mt", 5);
    freq.put("erg", 26);
    freq.put("tna", 4);
    freq.put("mp", 22);
    freq.put("ms", 30);
    freq.put("erc", 3);
    freq.put("erl", 5);
    freq.put("erm", 4);
    freq.put("ern", 9);
    freq.put("ero", 3);
    freq.put("my", 28);
    freq.put("eri", 25);
    freq.put("erk", 8);
    freq.put("La", 9);
    freq.put("Lo", 11);
    freq.put("uar", 3);
    freq.put("uat", 4);
    freq.put("Li", 11);
    freq.put("Abu", 3);
    freq.put("ena", 3);
    freq.put("enc", 13);
    freq.put("end", 25);
    freq.put("hoc", 29);
    freq.put("eng", 44);
    freq.put("hon", 50);
    freq.put("hoo", 26);
    freq.put("hol", 7);
    freq.put("enn", 7);
    freq.put("eno", 3);
    freq.put("hov", 5);
    freq.put("how", 9);
    freq.put("hot", 3);
    freq.put("hou", 46);
    freq.put("hor", 11);
    freq.put("hos", 5);
    freq.put("A", 422);
    freq.put("lam", 5);
    freq.put("lan", 75);
    freq.put("lai", 48);
    freq.put("lad", 18);
    freq.put("lae", 21);
    freq.put("lac", 47);
    freq.put("lay", 21);
    freq.put("ove", 7);
    freq.put("lat", 29);
    freq.put("lau", 16);
    freq.put("lav", 7);
    freq.put("law", 15);
    freq.put("lap", 3);
    freq.put("lti", 5);
    freq.put("las", 27);
    freq.put("en ", 233);
    freq.put("ho ", 8);
    freq.put("zed", 3);
    freq.put("lt ", 40);
    freq.put(" Hi", 21);
    freq.put(" Ho", 8);
    freq.put(" Ha", 17);
    freq.put("wun", 4);
    freq.put(" He", 76);
    freq.put("fir", 16);
    freq.put("fis", 14);
    freq.put("His", 12);
    freq.put("ime", 15);
    freq.put("cli", 7);
    freq.put("fit", 13);
    freq.put("cle", 31);
    freq.put("imm", 8);
    freq.put("iml", 4);
    freq.put("imp", 7);
    freq.put("ims", 9);
    freq.put("Hie", 3);
    freq.put("fie", 12);
    freq.put("Hil", 3);
    freq.put("ze ", 6);
    freq.put("one", 10);
    freq.put("im ", 125);
    freq.put("l", 2165);
    freq.put("cy ", 4);
    freq.put("nt ", 129);
    freq.put("rt", 111);
    freq.put("ru", 69);
    freq.put("rv", 13);
    freq.put("rw", 6);
    freq.put("rp", 13);
    freq.put("rr", 28);
    freq.put("rs", 158);
    freq.put("ry", 53);
    freq.put("rd", 109);
    freq.put("re", 520);
    freq.put("rg", 43);
    freq.put("ra", 286);
    freq.put("smi", 3);
    freq.put("rc", 44);
    freq.put("gou", 6);
    freq.put("got", 7);
    freq.put("gow", 20);
    freq.put("is ", 452);
    freq.put("ri", 217);
    freq.put("sma", 4);
    freq.put("rk", 60);
    freq.put("nty", 9);
    freq.put("nts", 9);
    freq.put("ntr", 18);
    freq.put("nti", 57);
    freq.put("nth", 4);
    freq.put("ntl", 5);
    freq.put("W", 134);
    freq.put("nta", 17);
    freq.put("nie", 38);
    freq.put("nte", 17);
    freq.put("ate", 34);
    freq.put("atc", 6);
    freq.put("iss", 33);
    freq.put("isu", 7);
    freq.put("ist", 73);
    freq.put("isk", 4);
    freq.put("atw", 4);
    freq.put("isi", 3);
    freq.put("ish", 29);
    freq.put("r ", 1122);
    freq.put("isn", 13);
    freq.put("isc", 6);
    freq.put("ise", 14);
    freq.put("Dul", 5);
    freq.put("on ", 245);
    freq.put("nis", 21);
    freq.put("Man", 8);
    freq.put("tor", 12);
    freq.put("tow", 5);
    freq.put("tou", 7);
    freq.put("ton", 11);
    freq.put("nit", 14);
    freq.put("toc", 4);
    freq.put(" le", 64);
    freq.put("B", 90);
    freq.put(" la", 180);
    freq.put(" lo", 30);
    freq.put(" ll", 46);
    freq.put(" li", 118);
    freq.put("tee", 20);
    freq.put(" lu", 22);
    freq.put("See", 3);
    freq.put("to ", 14);
    freq.put("raf", 5);
    freq.put("rag", 3);
    freq.put("rad", 7);
    freq.put("rae", 59);
    freq.put("rac", 16);
    freq.put("ran", 30);
    freq.put("ral", 5);
    freq.put("ram", 6);
    freq.put("ty ", 28);
    freq.put("rak", 5);
    freq.put("rai", 32);
    freq.put("rav", 9);
    freq.put("raw", 39);
    freq.put("rat", 11);
    freq.put("rau", 12);
    freq.put("rar", 3);
    freq.put("ras", 4);
    freq.put("rap", 6);
    freq.put("bs ", 3);
    freq.put("rax", 7);
    freq.put("ray", 17);
    freq.put("Syn", 50);
    freq.put("It ", 26);
    freq.put("Sou", 22);
    freq.put("hun", 9);
    freq.put("lp ", 8);
    freq.put("ra ", 10);
    freq.put("y", 1152);
    freq.put("doo", 20);
    freq.put("dom", 3);
    freq.put("doc", 3);
    freq.put("m", 1258);
    freq.put("As ", 21);
    freq.put("lpi", 3);
    freq.put("Its", 3);
    freq.put("dou", 36);
    freq.put(" We", 22);
    freq.put(" Wa", 4);
    freq.put(" Wo", 3);
    freq.put("d ", 959);
    freq.put(" Wi", 55);
    freq.put("och", 67);
    freq.put("ock", 34);
    freq.put("em ", 8);
    freq.put("hro", 23);
    freq.put("hri", 10);
    freq.put("hre", 21);
    freq.put("hra", 9);
    freq.put("sur", 10);
    freq.put("dn", 56);
    freq.put("do", 76);
    freq.put("dl", 28);
    freq.put("dm", 22);
    freq.put("di", 121);
    freq.put("df", 9);
    freq.put("dg", 9);
    freq.put("dd", 59);
    freq.put("de", 229);
    freq.put("da", 130);
    freq.put("dy", 53);
    freq.put("dv", 3);
    freq.put("dw", 9);
    freq.put("du", 17);
    freq.put("dr", 53);
    freq.put("ds", 70);
    freq.put("eme", 7);
    freq.put("bat", 5);
    freq.put("bau", 11);
    freq.put("bar", 8);
    freq.put("emn", 3);
    freq.put("bad", 6);
    freq.put("bac", 36);
    freq.put("ban", 11);
    freq.put("bai", 38);
    freq.put("om ", 8);
    freq.put("w ", 205);
    freq.put("Eft", 3);
    freq.put("Per", 3);
    freq.put(" I ", 13);
    freq.put("il ", 118);
    freq.put("irs", 35);
    freq.put("irt", 27);
    freq.put("un ", 105);
    freq.put("iri", 11);
    freq.put("irk", 31);
    freq.put("irl", 14);
    freq.put("irm", 10);
    freq.put("irn", 26);
    freq.put("ird", 74);
    freq.put("ire", 6);
    freq.put("irg", 3);
    freq.put("wf", 7);
    freq.put("we", 251);
    freq.put("wd", 20);
    freq.put("wb", 5);
    freq.put("wa", 306);
    freq.put("wo", 6);
    freq.put("wn", 18);
    freq.put("wm", 5);
    freq.put("wl", 3);
    freq.put("wk", 29);
    freq.put("wi", 550);
    freq.put("wh", 146);
    freq.put("wu", 19);
    freq.put("wt", 10);
    freq.put(" Il", 4);
    freq.put("wr", 35);
    freq.put(" In", 19);
    freq.put("wp", 12);
    freq.put("wth", 8);
    freq.put("wy", 7);
    freq.put("ild", 5);
    freq.put("ile", 28);
    freq.put("cou", 56);
    freq.put("ell", 58);
    freq.put("ila", 4);
    freq.put("ill", 114);
    freq.put("ilk", 12);
    freq.put("ili", 5);
    freq.put("coa", 7);
    freq.put("ilt", 5);
    freq.put("unc", 15);
    freq.put("und", 70);
    freq.put("ils", 4);
    freq.put("ung", 18);
    freq.put("ir ", 171);
    freq.put("unk", 5);
    freq.put("com", 48);
    freq.put("col", 5);
    freq.put("coo", 4);
    freq.put("ily", 3);
    freq.put("and", 57);
    freq.put(" ma", 320);
    freq.put(" mo", 57);
    freq.put(" mi", 52);
    freq.put(" mu", 56);
    freq.put(" my", 27);
    freq.put("fra", 36);
    freq.put("fre", 8);
    freq.put("Gan", 17);
    freq.put("ggi", 20);
    freq.put("fri", 6);
    freq.put("sal", 4);
    freq.put("ely", 6);
    freq.put("pro", 7);
    freq.put(" m ", 20);
    freq.put("saf", 3);
    freq.put("elp", 11);
    freq.put("Ch", 10);
    freq.put("Co", 20);
    freq.put("Cl", 5);
    freq.put("ait", 59);
    freq.put("Ca", 10);
    freq.put("aiv", 4);
    freq.put("ais", 16);
    freq.put("air", 259);
    freq.put("aim", 38);
    freq.put("ail", 27);
    freq.put("ain", 49);
    freq.put("aik", 7);
    freq.put("Cr", 4);
    freq.put("aig", 10);
    freq.put("sla", 8);
    freq.put("aic", 7);
    freq.put("wfu", 6);
    freq.put("ix", 3);
    freq.put("iz", 3);
    freq.put("Nae", 3);
    freq.put("ip", 27);
    freq.put("is", 638);
    freq.put("ir", 427);
    freq.put("it", 577);
    freq.put("iv", 59);
    freq.put("ik", 73);
    freq.put("im", 173);
    freq.put("il", 312);
    freq.put("io", 26);
    freq.put("in", 916);
    freq.put("ia", 12);
    freq.put("ic", 175);
    freq.put("ib", 11);
    freq.put("ie", 331);
    freq.put("id", 305);
    freq.put("ig", 44);
    freq.put("if", 124);
    freq.put("ep ", 24);
    freq.put("th ", 43);
    freq.put("Na ", 5);
    freq.put("nin", 37);
    freq.put("dro", 3);
    freq.put("kis", 6);
    freq.put("kir", 20);
    freq.put("kit", 42);
    freq.put("kin", 63);
    freq.put("kil", 3);
    freq.put("Y", 24);
    freq.put("i ", 147);
    freq.put("nip", 3);
    freq.put("niv", 9);
    freq.put("kie", 32);
    freq.put("mil", 16);
    freq.put("thy", 14);
    freq.put("thu", 3);
    freq.put("ths", 5);
    freq.put("eps", 5);
    freq.put("tho", 94);
    freq.put("thl", 10);
    freq.put("thi", 90);
    freq.put("epi", 10);
    freq.put("thf", 17);
    freq.put("the", 1112);
    freq.put("epe", 6);
    freq.put("tha", 423);
    freq.put("yel", 4);
    freq.put("yea", 14);
    freq.put("rn ", 53);
    freq.put("yed", 8);
    freq.put("yer", 28);
    freq.put("yet", 8);
    freq.put("hai", 100);
    freq.put("hal", 6);
    freq.put("ham", 20);
    freq.put("han", 125);
    freq.put("bir", 10);
    freq.put("ela", 7);
    freq.put("had", 5);
    freq.put("hae", 113);
    freq.put("eld", 29);
    freq.put("ele", 4);
    freq.put("hay", 65);
    freq.put("n", 4394);
    freq.put("Say", 3);
    freq.put("hap", 12);
    freq.put("els", 9);
    freq.put("har", 129);
    freq.put("has", 4);
    freq.put("hat", 186);
    freq.put("hau", 80);
    freq.put("elt", 30);
    freq.put("haw", 15);
    freq.put("rni", 24);
    freq.put("D", 28);
    freq.put("ye ", 197);
    freq.put("rne", 3);
    freq.put("Aul", 8);
    freq.put("ope", 7);
    freq.put("rns", 8);
    freq.put("rnt", 4);
    freq.put("ha ", 5);
    freq.put("el ", 85);
    freq.put("ywe", 7);
    freq.put("Are", 4);
    freq.put("hs ", 9);
    freq.put("ole", 11);
    freq.put(" Ju", 3);
    freq.put("oli", 5);
    freq.put("oll", 14);
    freq.put(" Jo", 13);
    freq.put("ols", 4);
    freq.put(" Ja", 29);
    freq.put("ick", 31);
    freq.put("fou", 15);
    freq.put("ich", 104);
    freq.put("yke", 4);
    freq.put("icl", 4);
    freq.put("ice", 9);
    freq.put("ume", 8);
    freq.put("Hi", 21);
    freq.put("uma", 5);
    freq.put("Ho", 8);
    freq.put("fol", 8);
    freq.put("Ha", 17);
    freq.put("He", 76);
    freq.put("chs", 4);
    freq.put("whi", 73);
    freq.put("ple", 20);
    freq.put("pla", 28);
    freq.put("plo", 4);
    freq.put("emp", 7);
    freq.put("cht", 166);
    freq.put("ic ", 17);
    freq.put("o", 2484);
    freq.put("um ", 17);
    freq.put("awk", 4);
    freq.put("thr", 54);
    freq.put("sod", 4);
    freq.put("ppe", 14);
    freq.put("mbe", 4);
    freq.put("ppi", 17);
    freq.put("ahi", 6);
    freq.put("som", 33);
    freq.put("sol", 4);
    freq.put("soo", 5);
    freq.put("son", 11);
    freq.put("sor", 5);
    freq.put("Fer", 28);
    freq.put("giv", 3);
    freq.put("art", 23);
    freq.put("git", 15);
    freq.put("gis", 4);
    freq.put("gir", 3);
    freq.put("wai", 4);
    freq.put("wad", 51);
    freq.put("ew ", 27);
    freq.put("gie", 39);
    freq.put("waw", 12);
    freq.put("gin", 67);
    freq.put("wau", 14);
    freq.put("wat", 25);
    freq.put("was", 17);
    freq.put("war", 49);
    freq.put("cke", 10);
    freq.put("low", 16);
    freq.put("wmi", 3);
    freq.put(" La", 9);
    freq.put("wa ", 48);
    freq.put("nni", 28);
    freq.put("nne", 21);
    freq.put("nna", 44);
    freq.put("D ", 3);
    freq.put("nny", 17);
    freq.put("Sin", 3);
    freq.put("nke", 7);
    freq.put("fs ", 3);
    freq.put("ni", 153);
    freq.put("nk", 59);
    freq.put("nl", 11);
    freq.put("nn", 114);
    freq.put("no", 99);
    freq.put("tit", 49);
    freq.put("na", 225);
    freq.put("nb", 6);
    freq.put("nc", 74);
    freq.put("nd", 260);
    freq.put("ne", 320);
    freq.put("nf", 9);
    freq.put("ng", 319);
    freq.put("til", 119);
    freq.put("ny", 71);
    freq.put("nz", 3);
    freq.put("tio", 11);
    freq.put("tie", 24);
    freq.put("ns", 93);
    freq.put("nt", 270);
    freq.put("nu", 4);
    freq.put("nw", 3);
    freq.put(" ni", 40);
    freq.put("E", 8);
    freq.put("urr", 6);
    freq.put(" no", 92);
    freq.put(" na", 82);
    freq.put(" ne", 55);
    freq.put("squ", 5);
    freq.put("fow", 31);
    freq.put("Wif", 3);
    freq.put("for", 135);
    freq.put("n ", 2261);
    freq.put("Win", 7);
    freq.put("Wil", 5);
    freq.put("mme", 24);
    freq.put("So", 25);
    freq.put("lly", 7);
    freq.put("ron", 5);
    freq.put("roo", 25);
    freq.put("lls", 8);
    freq.put("roa", 8);
    freq.put("oss", 4);
    freq.put("roc", 12);
    freq.put("rod", 37);
    freq.put("ost", 4);
    freq.put("rog", 3);
    freq.put("lli", 8);
    freq.put("llo", 8);
    freq.put("lla", 17);
    freq.put("ros", 3);
    freq.put("ose", 27);
    freq.put("rou", 26);
    freq.put("lle", 16);
    freq.put("row", 10);
    freq.put("ver", 39);
    freq.put("ves", 6);
    freq.put("gea", 7);
    freq.put("ved", 5);
    freq.put("vee", 4);
    freq.put("ven", 19);
    freq.put("ert", 45);
    freq.put("ey ", 54);
    freq.put("ro ", 7);
    freq.put("umm", 14);
    freq.put("erp", 3);
    freq.put("ll ", 190);
    freq.put("By ", 6);
    freq.put("din", 35);
    freq.put("gue", 9);
    freq.put("gud", 5);
    freq.put("did", 20);
    freq.put("die", 25);
    freq.put("gui", 45);
    freq.put("ers", 76);
    freq.put("gus", 28);
    freq.put("p", 657);
    freq.put("ve ", 41);
    freq.put("dit", 19);
    freq.put("der", 27);
    freq.put("dis", 11);
    freq.put("hte", 6);
    freq.put("M ", 5);
    freq.put(" Yo", 7);
    freq.put("htl", 3);
    freq.put(" Ye", 16);
    freq.put("hti", 5);
    freq.put("Gre", 3);
    freq.put("hts", 3);
    freq.put("dev", 4);
    freq.put("hty", 6);
    freq.put("ere", 38);
    freq.put("ek ", 12);
    freq.put("Me", 3);
    freq.put("Ma", 32);
    freq.put("erb", 5);
    freq.put("ht ", 162);
    freq.put("Mo", 4);
    freq.put("Mi", 3);
    freq.put("Bou", 3);
    freq.put("gle", 24);
    freq.put("uff", 4);
    freq.put("Mr", 22);
    freq.put("eki", 10);
    freq.put("Mil", 3);
    freq.put("bor", 3);
    freq.put("bot", 14);
    freq.put("bou", 6);
    freq.put("dee", 16);
    freq.put("bon", 15);
    freq.put("boo", 32);
    freq.put("flu", 5);
    freq.put("bod", 37);
    freq.put("bog", 4);
    freq.put("uzl", 3);
    freq.put("ard", 4);
    freq.put("oo ", 3);
    freq.put("ipe", 4);
    freq.put("Be ", 3);
    freq.put("ips", 7);
    freq.put("ipp", 7);
    freq.put(" Ke", 6);
    freq.put("aye", 52);
    freq.put(" Ki", 3);
    freq.put("ul ", 5);
    freq.put("ays", 94);
    freq.put("ood", 9);
    freq.put("ip ", 9);
    freq.put("ngr", 5);
    freq.put("F", 105);
    freq.put("oom", 8);
    freq.put("ool", 6);
    freq.put("oon", 32);
    freq.put("oot", 79);
    freq.put("oop", 4);
    freq.put("oos", 18);
    freq.put("oor", 51);
    freq.put("Abo", 4);
    freq.put("ibl", 3);
    freq.put("cas", 21);
    freq.put("car", 13);
    freq.put("caw", 7);
    freq.put("ay ", 141);
    freq.put("cau", 38);
    freq.put("cat", 6);
    freq.put("fli", 3);
    freq.put("cai", 8);
    freq.put("uli", 23);
    freq.put("can", 62);
    freq.put("cam", 37);
    freq.put("cal", 4);
    freq.put("fla", 5);
    freq.put("fle", 58);
    freq.put("uld", 79);
    freq.put("ule", 5);
    freq.put(" on", 130);
    freq.put("spy", 3);
    freq.put("kyn", 6);
    freq.put("ger", 15);
    freq.put(" of", 4);
    freq.put("kya", 3);
    freq.put("spu", 4);
    freq.put("kye", 3);
    freq.put("ma ", 44);
    freq.put(" ox", 3);
    freq.put("spa", 15);
    freq.put(" ou", 4);
    freq.put(" or", 53);
    freq.put("spe", 33);
    freq.put("Whe", 5);
    freq.put("Wha", 27);
    freq.put("Whi", 17);
    freq.put("nyt", 4);
    freq.put("idm", 21);
    freq.put("gh ", 3);
    freq.put("sst", 5);
    freq.put("s ", 1628);
    freq.put("mas", 4);
    freq.put("sne", 8);
    freq.put("mau", 57);
    freq.put("maw", 6);
    freq.put("sna", 19);
    freq.put("ky ", 4);
    freq.put(" o ", 191);
    freq.put("mac", 4);
    freq.put("mae", 6);
    freq.put("mad", 12);
    freq.put("mai", 59);
    freq.put("mak", 29);
    freq.put("ene", 4);
    freq.put("ght", 12);
    freq.put("sy", 31);
    freq.put("ss", 110);
    freq.put("sq", 5);
    freq.put("sp", 60);
    freq.put("sw", 26);
    freq.put(" pa", 33);
    freq.put("su", 34);
    freq.put("st", 420);
    freq.put("q", 27);
    freq.put("Fai", 4);
    freq.put("si", 135);
    freq.put("sh", 252);
    freq.put("so", 75);
    freq.put("sn", 28);
    freq.put("sm", 10);
    freq.put("sl", 31);
    freq.put("sc", 41);
    freq.put("sa", 305);
    freq.put("se", 288);
    freq.put("Cha", 3);
    freq.put("tty", 4);
    freq.put("lse", 3);
    freq.put("no ", 34);
    freq.put("Jan", 29);
    freq.put("Chr", 5);
    freq.put("tto", 3);
    freq.put("ttl", 16);
    freq.put("Ro", 4);
    freq.put("Ri", 3);
    freq.put("tte", 40);
    freq.put(" ab", 39);
    freq.put(" ac", 13);
    freq.put(" ad", 3);
    freq.put(" ae", 14);
    freq.put(" af", 43);
    freq.put(" ag", 21);
    freq.put(" ah", 6);
    freq.put(" ai", 38);
    freq.put(" al", 16);
    freq.put(" am", 9);
    freq.put(" an", 702);
    freq.put(" ap", 11);
    freq.put(" ar", 27);
    freq.put(" as", 84);
    freq.put(" at", 57);
    freq.put(" au", 47);
    freq.put(" aw", 152);
    freq.put(" ay", 48);
    freq.put("gel", 4);
    freq.put("ls ", 22);
    freq.put("noc", 5);
    freq.put("Sha", 3);
    freq.put("She", 22);
    freq.put("qu", 27);
    freq.put("tt ", 3);
    freq.put("nor", 13);
    freq.put("shu", 8);
    freq.put(" a ", 372);
    freq.put(" wo", 5);
    freq.put("sou", 9);
    freq.put("em", 35);
    freq.put("el", 252);
    freq.put("eo", 47);
    freq.put("en", 472);
    freq.put("ei", 167);
    freq.put("eh", 3);
    freq.put("ek", 30);
    freq.put("ee", 524);
    freq.put("ed", 295);
    freq.put("eg", 51);
    freq.put("ef", 46);
    freq.put("ea", 265);
    freq.put("ec", 44);
    freq.put("eb", 22);
    freq.put("ey", 69);
    freq.put("ex", 10);
    freq.put("ez", 8);
    freq.put("eu", 101);
    freq.put("et", 164);
    freq.put("ew", 43);
    freq.put("ev", 23);
    freq.put("ep", 53);
    freq.put("es", 334);
    freq.put("er", 795);
    freq.put("bly", 6);
    freq.put("blu", 10);
    freq.put("Kee", 5);
    freq.put("blo", 7);
    freq.put(" wu", 12);
    freq.put("bli", 8);
    freq.put("ble", 31);
    freq.put("bla", 44);
    freq.put("she", 116);
    freq.put("nic", 25);
    freq.put("rli", 8);
    freq.put("G", 78);
    freq.put("wan", 62);
    freq.put("rle", 4);
    freq.put("rld", 3);
    freq.put("ort", 11);
    freq.put("oru", 5);
    freq.put("orr", 5);
    freq.put("e ", 3991);
    freq.put("orp", 7);
    freq.put("orn", 41);
    freq.put("wal", 16);
    freq.put("rly", 13);
    freq.put("ori", 3);
    freq.put("org", 7);
    freq.put("ord", 11);
    freq.put("ore", 47);
    freq.put("orb", 7);
    freq.put("ora", 3);
    freq.put("aen", 3);
    freq.put("oni", 3);
    freq.put("onn", 16);
    freq.put("onc", 5);
    freq.put("onf", 3);
    freq.put("ong", 6);
    freq.put("ond", 24);
    freq.put("xe", 3);
    freq.put("ony", 46);
    freq.put("ons", 12);
    freq.put("xp", 5);
    freq.put("xt", 12);
    freq.put(" yo", 59);
    freq.put("yie", 4);
    freq.put("ial", 3);
    freq.put("ian", 4);
    freq.put("yin", 7);
    freq.put("uks", 8);
    freq.put("uki", 61);
    freq.put("uke", 9);
    freq.put("hum", 5);
    freq.put("x ", 10);
    freq.put("hui", 10);
    freq.put("hur", 39);
    freq.put("mt ", 5);
    freq.put("r", 3203);
    freq.put("uk ", 57);
    freq.put("sak", 3);
    freq.put("ane", 102);
    freq.put("sai", 82);
    freq.put("ang", 156);
    freq.put("pra", 14);
    freq.put("san", 9);
    freq.put("sam", 7);
    freq.put("anc", 28);
    freq.put("ann", 36);
    freq.put("pri", 9);
    freq.put("ani", 9);
    freq.put("sae", 63);
    freq.put("ank", 22);
    freq.put("ant", 86);
    freq.put("uy ", 4);
    freq.put("say", 92);
    freq.put("sax", 3);
    freq.put("ans", 20);
    freq.put("sar", 4);
    freq.put("saw", 7);
    freq.put("sau", 10);
    freq.put("sat", 12);
    freq.put("Di", 3);
    freq.put("De", 6);
    freq.put("Da", 6);
    freq.put("ax ", 5);
    freq.put("Du", 7);
    freq.put("Dr", 3);
    freq.put("ts ", 49);
    freq.put("an ", 894);
    freq.put("dle", 17);
    freq.put("axt", 3);
    freq.put(" Lo", 11);
    freq.put(" Li", 11);
    freq.put("neu", 4);
    freq.put("axe", 3);
    freq.put("Wea", 3);
    freq.put("Wee", 7);
    freq.put("ge ", 14);
    freq.put("nle", 8);
    freq.put("dy ", 49);
    freq.put("ss ", 48);
    freq.put("We", 22);
    freq.put("Wa", 4);
    freq.put("Wo", 3);
    freq.put("ce ", 70);
    freq.put("Wi", 55);
    freq.put("Wh", 49);
    freq.put(" pr", 43);
    freq.put("We ", 11);
    freq.put(" pu", 22);
    freq.put("get", 19);
    freq.put("H", 124);
    freq.put("gey", 6);
    freq.put("ssl", 3);
    freq.put("sso", 3);
    freq.put("ssi", 24);
    freq.put(" pe", 25);
    freq.put("ged", 5);
    freq.put("sse", 24);
    freq.put(" pi", 32);
    freq.put(" po", 24);
    freq.put(" pl", 44);
    freq.put("Tim", 6);
    freq.put("lum", 4);
    freq.put("rms", 4);
    freq.put("Ba ", 12);
    freq.put("wui", 11);
    freq.put("uts", 3);
    freq.put("uve", 10);
    freq.put("wum", 4);
    freq.put("yth", 11);
    freq.put("yte", 5);
    freq.put("utt", 3);
    freq.put("uns", 6);
    freq.put("ju", 19);
    freq.put("tur", 14);
    freq.put("tui", 36);
    freq.put("rm ", 12);
    freq.put("jo", 6);
    freq.put("Lik", 6);
    freq.put("ja", 7);
    freq.put(" be", 205);
    freq.put("z", 22);
    freq.put(" ba", 108);
    freq.put(" bl", 79);
    freq.put(" bo", 69);
    freq.put(" bi", 64);
    freq.put(" bu", 120);
    freq.put("s", 3545);
    freq.put(" br", 87);
    freq.put(" by", 39);
    freq.put("Aw ", 12);
    freq.put("pow", 4);
    freq.put("pou", 6);
    freq.put("por", 3);
    freq.put("pos", 6);
    freq.put("cla", 27);
    freq.put("pon", 30);
    freq.put("poo", 6);
    freq.put("Bur", 3);
    freq.put("Bus", 3);
    freq.put("But", 39);
    freq.put("po ", 3);
    freq.put("eis", 17);
    freq.put("eir", 33);
    freq.put("eiv", 14);
    freq.put("fin", 11);
    freq.put("eic", 16);
    freq.put("eid", 54);
    freq.put("eik", 5);
    freq.put("eil", 14);
    freq.put("ein", 11);
    freq.put("ive", 52);
    freq.put("ivi", 3);
    freq.put("wp ", 5);
    freq.put(" Me", 3);
    freq.put("par", 5);
    freq.put("pas", 5);
    freq.put("pat", 3);
    freq.put(" Ma", 32);
    freq.put("paw", 3);
    freq.put(" Mo", 4);
    freq.put(" Mi", 3);
    freq.put("pac", 3);
    freq.put(" Mr", 22);
    freq.put("cen", 7);
    freq.put("pai", 19);
    freq.put("pak", 7);
    freq.put("pan", 3);
    freq.put("iv ", 4);
    freq.put("I", 74);
    freq.put("gru", 22);
    freq.put("wpi", 3);
    freq.put("tli", 5);
    freq.put(" M ", 5);
    freq.put("Owe", 4);
    freq.put("Is", 7);
    freq.put("Wi ", 38);
    freq.put("It", 30);
    freq.put("Il", 4);
    freq.put("In", 19);
    freq.put(" qu", 18);
    freq.put("am ", 39);
    freq.put("ps ", 25);
    freq.put("uid", 100);
    freq.put("nam", 9);
    freq.put("tim", 15);
    freq.put("tin", 46);
    freq.put("ot ", 61);
    freq.put("gre", 25);
    freq.put("ff ", 18);
    freq.put("ami", 10);
    freq.put("amm", 9);
    freq.put("amo", 3);
    freq.put("ama", 9);
    freq.put("mor", 27);
    freq.put(" ga", 240);
    freq.put("ame", 40);
    freq.put("mou", 5);
    freq.put("uif", 3);
    freq.put("mon", 24);
    freq.put("gro", 9);
    freq.put("amp", 5);
    freq.put("ams", 5);
    freq.put("amt", 3);
    freq.put("zle", 3);
    freq.put("tia", 4);
    freq.put("t", 4925);
    freq.put("wbo", 3);
    freq.put("gri", 4);
    freq.put("eze", 8);
    freq.put(" ch", 53);
    freq.put(" co", 153);
    freq.put(" cl", 66);
    freq.put(" ca", 168);
    freq.put(" ce", 3);
    freq.put("ddi", 10);
    freq.put(" cr", 48);
    freq.put("uch", 28);
    freq.put("dde", 41);
    freq.put(" cu", 9);
    freq.put("oo", 215);
    freq.put("on", 398);
    freq.put("aca", 10);
    freq.put("ol", 37);
    freq.put("ok", 3);
    freq.put("ace", 35);
    freq.put("oh", 13);
    freq.put("og", 8);
    freq.put("of", 6);
    freq.put("oe", 4);
    freq.put("od", 111);
    freq.put("oc", 104);
    freq.put("ob", 6);
    freq.put("oa", 25);
    freq.put("oy", 7);
    freq.put("ox", 5);
    freq.put("ow", 155);
    freq.put("ov", 9);
    freq.put("ou", 413);
    freq.put("ot", 110);
    freq.put("os", 40);
    freq.put("or", 404);
    freq.put("op", 11);
    freq.put("No", 29);
    freq.put("Na", 9);
    freq.put("het", 7);
    freq.put("loc", 19);
    freq.put("loa", 4);
    freq.put("her", 274);
    freq.put("hes", 9);
    freq.put("hey", 8);
    freq.put("lor", 3);
    freq.put("hee", 24);
    freq.put("heg", 10);
    freq.put("hea", 21);
    freq.put("lou", 16);
    freq.put("hel", 22);
    freq.put("hem", 4);
    freq.put("hen", 15);
    freq.put("heo", 38);
    freq.put("hei", 40);
    freq.put("jui", 18);
    freq.put("na ", 120);
    freq.put("lo ", 8);
    freq.put("as ", 99);
    freq.put("he ", 1515);
    freq.put("ac", 147);
    freq.put("ab", 65);
    freq.put("ae", 769);
    freq.put("ad", 135);
    freq.put("ag", 37);
    freq.put("af", 58);
    freq.put("ai", 560);
    freq.put("ah", 7);
    freq.put("ak", 86);
    freq.put("am", 129);
    freq.put("al", 102);
    freq.put("an", 1418);
    freq.put("ap", 78);
    freq.put("as", 215);
    freq.put("ar", 401);
    freq.put("au", 373);
    freq.put("at", 424);
    freq.put("aw", 279);
    freq.put("av", 36);
    freq.put("ay", 297);
    freq.put("ax", 11);
    freq.put("yon", 8);
    freq.put("igs", 7);
    freq.put("ngu", 7);
    freq.put("igg", 7);
    freq.put("ign", 4);
    freq.put("you", 53);
    freq.put("Hou", 5);
    freq.put("igi", 3);
    freq.put("igh", 8);
    freq.put("a ", 669);
    freq.put("at ", 328);
    freq.put("u", 1858);
    freq.put("ig ", 9);
    freq.put("sco", 4);
    freq.put("sch", 6);
    freq.put("mp ", 7);
    freq.put("ali", 7);
    freq.put("ale", 19);
    freq.put("sca", 11);
    freq.put("ala", 6);
    freq.put("scu", 3);
    freq.put("gs", 39);
    freq.put("alt", 4);
    freq.put("als", 3);
    freq.put("scr", 15);
    freq.put("hy ", 16);
    freq.put("ws ", 18);
    freq.put("edd", 6);
    freq.put("ty", 34);
    freq.put("tw", 35);
    freq.put("tt", 87);
    freq.put("tu", 56);
    freq.put("tr", 118);
    freq.put("ts", 50);
    freq.put("tn", 5);
    freq.put("to", 61);
    freq.put("tl", 55);
    freq.put("uiv", 7);
    freq.put("th", 1865);
    freq.put("ti", 283);
    freq.put("te", 260);
    freq.put("tb", 3);
    freq.put("tc", 19);
    freq.put("ta", 389);
    freq.put("mpe", 9);
    freq.put("rb", 14);
    freq.put("far", 3);
    freq.put("fas", 21);
    freq.put("faw", 6);
    freq.put("al ", 27);
    freq.put("fau", 13);
    freq.put("rl", 38);
    freq.put("fai", 37);
    freq.put("rm", 21);
    freq.put("mn ", 3);
    freq.put("fac", 13);
    freq.put("llt", 3);
    freq.put("rn", 98);
    freq.put("fae", 16);
    freq.put("gg", 25);
    freq.put("pre", 15);
    freq.put("ro", 148);
    freq.put(" No", 29);
    freq.put("eds", 13);
    freq.put(" Na", 9);
    freq.put("Gie", 4);
    freq.put("hyn", 4);
    freq.put("wst", 4);
    freq.put("t ", 1575);
    freq.put("tei", 5);
    freq.put("nby", 3);
    freq.put("tel", 26);
    freq.put("ga", 264);
    freq.put("ten", 32);
    freq.put(" Ab", 7);
    freq.put("tey", 7);
    freq.put("gn", 6);
    freq.put("ter", 103);
    freq.put("tes", 7);
    freq.put("teu", 9);
    freq.put("aba", 7);
    freq.put("abb", 3);
    freq.put("gl", 39);
    freq.put("abe", 3);
    freq.put("sun", 15);
    freq.put("abl", 14);
    freq.put("abo", 28);
    freq.put("abu", 6);
    freq.put(" ru", 8);
    freq.put("te ", 43);
    freq.put("K", 10);
    freq.put(" ry", 3);
    freq.put(" re", 60);
    freq.put(" ra", 56);
    freq.put(" ro", 74);
    freq.put(" ri", 52);
    freq.put("vic", 5);
    freq.put("nto", 4);
    freq.put("rks", 6);
    freq.put("vin", 9);
    freq.put("rky", 3);
    freq.put("vil", 6);
    freq.put("vis", 3);
    freq.put("lka", 9);
    freq.put(" s ", 194);
    freq.put("twa", 26);
    freq.put("eye", 4);
    freq.put("twe", 6);
    freq.put("twi", 3);
    freq.put(" d ", 24);
    freq.put("mui", 22);
    freq.put("de ", 58);
    freq.put("In ", 17);
    freq.put("Sy", 50);
    freq.put("Su", 26);
    freq.put("St", 5);
    freq.put("Si", 8);
    freq.put("Sh", 27);
    freq.put("rk ", 42);
    freq.put("Sa", 27);
    freq.put("Se", 6);
    freq.put(" do", 70);
    freq.put("kle", 44);
    freq.put(" di", 59);
    freq.put(" de", 63);
    freq.put("des", 12);
    freq.put(" da", 114);
    freq.put("dei", 21);
    freq.put("del", 4);
    freq.put("den", 71);
    freq.put("v", 180);
    freq.put(" dw", 5);
    freq.put("dea", 8);
    freq.put(" du", 17);
    freq.put(" dr", 46);
    freq.put("f ", 64);
    freq.put("ath", 14);
    freq.put("ave", 22);
    freq.put("ati", 7);
    freq.put("wks", 3);
    freq.put("oys", 3);
    freq.put("att", 19);
    freq.put("ava", 6);
    freq.put("eg ", 3);
    freq.put("ats", 6);
    freq.put("fr", 53);
    freq.put("fs", 3);
    freq.put("ft", 47);
    freq.put("fu", 34);
    freq.put("dow", 8);
    freq.put("fa", 118);
    freq.put("fe", 155);
    freq.put("ff", 26);
    freq.put("fi", 72);
    freq.put("fl", 75);
    freq.put("fo", 193);
    freq.put("a", 6303);
    freq.put("egs", 6);
    freq.put("ry ", 44);
    freq.put("egi", 22);
    freq.put("ego", 5);
    freq.put("ds ", 67);
    freq.put("hfa", 15);
    freq.put("egg", 8);
    freq.put("ege", 3);
    freq.put("oy ", 3);
    freq.put("itn", 3);
    freq.put("Och", 33);
    freq.put("ith", 129);
    freq.put("iti", 7);
    freq.put("y ", 528);
    freq.put("ite", 15);
    freq.put("itc", 8);
    freq.put("ffi", 3);
    freq.put("ity", 6);
    freq.put("itt", 33);
    freq.put("itu", 4);
    freq.put("its", 8);
    freq.put(" On", 7);
    freq.put(" Oo", 6);
    freq.put("wre", 14);
    freq.put("wra", 5);
    freq.put(" Oc", 33);
    freq.put("wri", 13);
    freq.put("if ", 14);
    freq.put(" Ow", 4);
    freq.put(" Or", 13);
    freq.put("yi", 13);
    freq.put("yk", 4);
    freq.put("yl", 9);
    freq.put("yo", 62);
    freq.put("yn", 106);
    freq.put("ya", 13);
    freq.put("rwi", 4);
    freq.put("yc", 4);
    freq.put("ye", 260);
    freq.put("L", 33);
    freq.put("it ", 351);
    freq.put("ces", 8);
    freq.put("dig", 3);
    freq.put("I ", 13);
    freq.put("ys", 101);
    freq.put("yr", 3);
    freq.put("yt", 16);
    freq.put("yw", 7);
    freq.put("sle", 21);
    freq.put("ift", 10);
    freq.put("ynd", 21);
    freq.put("yne", 80);
    freq.put("yng", 3);
    freq.put(" O ", 22);
    freq.put("ife", 97);
    freq.put("man", 148);
    freq.put(" A ", 176);
    freq.put(" sy", 26);
    freq.put(" sp", 55);
    freq.put(" sq", 5);
    freq.put(" sw", 22);
    freq.put(" st", 205);
    freq.put(" su", 26);
    freq.put(" sk", 11);
    freq.put(" sh", 190);
    freq.put(" si", 88);
    freq.put(" sn", 15);
    freq.put(" so", 54);
    freq.put(" sl", 25);
    freq.put(" sm", 8);
    freq.put(" sc", 35);
    freq.put(" sa", 299);
    freq.put(" se", 120);
    freq.put("Tae", 29);
    freq.put("E ", 4);
    freq.put("fte", 21);
    freq.put("ass", 27);
    freq.put("pun", 3);
    freq.put(" Ad", 4);
    freq.put("pui", 15);
    freq.put(" Af", 3);
    freq.put("ast", 57);
    freq.put(" Ah", 3);
    freq.put(" wy", 3);
    freq.put(" Am", 6);
    freq.put(" An", 155);
    freq.put("mml", 6);
    freq.put(" Ar", 4);
    freq.put(" As", 21);
    freq.put(" At", 7);
    freq.put(" Au", 9);
    freq.put("ase", 11);
    freq.put(" Aw", 13);
    freq.put("ask", 3);
    freq.put(" Ay", 7);
    freq.put("asi", 4);
    freq.put("ash", 10);
    freq.put("mma", 5);
    freq.put("pur", 6);
    freq.put("Ef", 3);
    freq.put("ft ", 19);
    freq.put("w", 1674);
    freq.put("zl", 3);
    freq.put("Fra", 13);
    freq.put("Clo", 4);
    freq.put("Fre", 3);
    freq.put(" el", 9);
    freq.put(" en", 30);
    freq.put("st ", 113);
    freq.put(" ei", 4);
    freq.put(" ee", 14);
    freq.put(" ef", 17);
    freq.put(" ea", 11);
    freq.put(" ex", 4);
    freq.put("ued", 6);
    freq.put(" et", 8);
    freq.put("dfa", 6);
    freq.put(" er", 14);
    freq.put(" es", 5);
    freq.put("ncy", 4);
    freq.put("nch", 10);
    freq.put("ncl", 3);
    freq.put("nco", 8);
    freq.put("nca", 3);
    freq.put("nce", 43);
    freq.put("ste", 56);
    freq.put("b", 940);
    freq.put("sta", 72);
    freq.put("stl", 26);
    freq.put("sto", 19);
    freq.put(" e ", 17);
    freq.put("sti", 42);
    freq.put("stu", 36);
    freq.put("str", 44);
    freq.put("sts", 4);
    freq.put("sty", 3);
    freq.put("ka ", 9);
    freq.put("At ", 6);
    freq.put("God", 16);
    freq.put("lie", 39);
    freq.put("lif", 8);
    freq.put("k ", 354);
    freq.put("lic", 12);
    freq.put("lil", 3);
    freq.put("lim", 3);
    freq.put("lin", 32);
    freq.put("eft", 22);
    freq.put("efu", 4);
    freq.put("lik", 54);
    freq.put("lit", 10);
    freq.put("lip", 5);
    freq.put("ues", 6);
    freq.put("lis", 29);
    freq.put("uer", 7);
    freq.put("le ", 167);
    freq.put("M", 73);
    freq.put("Thr", 4);
    freq.put("Tho", 9);
    freq.put("The", 134);
    freq.put("Ise", 6);
    freq.put("ka", 15);
    freq.put("ke", 181);
    freq.put("ki", 171);
    freq.put("kn", 13);
    freq.put("kl", 45);
    freq.put("ks", 53);
    freq.put("ext", 6);
    freq.put("kw", 4);
    freq.put("exp", 4);
    freq.put("ef ", 16);
    freq.put("ky", 18);
    freq.put("rte", 8);
    freq.put("ugh", 6);
    freq.put("Hal", 4);
    freq.put("Han", 3);
    freq.put("ugg", 4);
    freq.put("rth", 10);
    freq.put("uge", 5);
    freq.put("Hag", 4);
    freq.put("To ", 4);
    freq.put("Ju", 3);
    freq.put("ies", 58);
    freq.put("iet", 3);
    freq.put("iev", 7);
    freq.put("iei", 3);
    freq.put("Jo", 13);
    freq.put("iel", 30);
    freq.put("ien", 14);
    freq.put("ied", 21);
    freq.put("ief", 17);
    freq.put("hip", 8);
    freq.put("hir", 10);
    freq.put("his", 190);
    freq.put("hit", 63);
    freq.put("rt ", 82);
    freq.put("hiv", 5);
    freq.put("hic", 3);
    freq.put("hie", 17);
    freq.put("hil", 33);
    freq.put("him", 98);
    freq.put("hin", 94);
    freq.put("cru", 5);
    freq.put("oxt", 3);
    freq.put("cry", 3);
    freq.put("cra", 14);
    freq.put("cre", 21);
    freq.put("ie ", 172);
    freq.put("cri", 15);
    freq.put("cro", 8);
    freq.put(" Be", 12);
    freq.put("Fou", 3);
    freq.put("arr", 7);
    freq.put("set", 4);
    freq.put(" Ba", 16);
    freq.put("ser", 21);
    freq.put("For", 34);
    freq.put("ary", 19);
    freq.put(" Bo", 4);
    freq.put(" Bi", 4);
    freq.put("sey", 3);
    freq.put(" Bu", 45);
    freq.put("see", 66);
    freq.put("sed", 14);
    freq.put("sec", 5);
    freq.put("are", 174);
    freq.put("sea", 29);
    freq.put("arg", 5);
    freq.put("sen", 5);
    freq.put("sel", 46);
    freq.put(" By", 6);
    freq.put("arm", 3);
    freq.put("sei", 8);
    freq.put("lee", 40);
    freq.put("Ye ", 14);
    freq.put("wor", 4);
    freq.put("use", 21);
    freq.put("ue ", 18);
    freq.put("ar ", 86);
    freq.put("ike", 48);
    freq.put("se ", 65);
    freq.put("leo", 8);
    freq.put("Ba", 16);
    freq.put("c", 1265);
    freq.put(" Pa", 16);
    freq.put(" Pe", 4);
    freq.put(" Po", 4);
    freq.put("wen", 4);
    freq.put("lex", 3);
    freq.put(" t ", 19);
    freq.put("pr", 47);
    freq.put("ps", 28);
    freq.put("pp", 35);
    freq.put("dun", 11);
    freq.put("pu", 26);
    freq.put("swa", 7);
    freq.put("py", 6);
    freq.put("swe", 11);
    freq.put("pa", 53);
    freq.put("nau", 3);
    freq.put("fu ", 18);
    freq.put("pe", 121);
    freq.put("pi", 72);
    freq.put("swu", 7);
    freq.put("po", 61);
    freq.put("pl", 53);
    freq.put(" tw", 28);
    freq.put(" tu", 10);
    freq.put("gat", 38);
    freq.put(" tr", 46);
    freq.put("N", 42);
    freq.put(" to", 30);
    freq.put("gan", 61);
    freq.put(" ti", 108);
    freq.put(" th", 1641);
    freq.put(" te", 49);
    freq.put("gab", 5);
    freq.put(" ta", 292);
    freq.put("fur", 9);
    freq.put("mle", 7);
    freq.put("mli", 3);
    freq.put("p ", 149);
    freq.put("fun", 3);
    freq.put("sy ", 3);
    freq.put("riv", 7);
    freq.put("rit", 22);
    freq.put("ris", 12);
    freq.put("rip", 7);
    freq.put("rin", 64);
    freq.put("rio", 6);
    freq.put("rim", 3);
    freq.put("rif", 6);
    freq.put("rig", 7);
    freq.put("rid", 8);
    freq.put("rie", 33);
    freq.put("ric", 38);
    freq.put("ng ", 238);
    freq.put("ewi", 3);
    freq.put("ewa", 3);
    freq.put("gs ", 31);
    freq.put("ews", 4);
    freq.put("ohn", 12);
    freq.put("Cop", 6);
    freq.put("dge", 8);
    freq.put("syn", 27);
    freq.put("lig", 12);
    freq.put("Com", 8);
    freq.put(" fr", 53);
    freq.put(" fu", 15);
    freq.put("kni", 3);
    freq.put("eks", 5);
    freq.put("kne", 6);
    freq.put("kna", 3);
    freq.put(" fa", 94);
    freq.put(" fe", 49);
    freq.put(" fi", 65);
    freq.put("moo", 5);
    freq.put(" fl", 73);
    freq.put(" fo", 164);
    freq.put("O ", 22);
    freq.put("ldr", 3);
    freq.put("cut", 3);
    freq.put("rgu", 25);
    freq.put("rga", 6);
    freq.put("rge", 6);
    freq.put("win", 48);
    freq.put("app", 26);
    freq.put("rgo", 3);
    freq.put("Oo", 6);
    freq.put("On", 7);
    freq.put("ld ", 101);
    freq.put("big", 3);
    freq.put("bid", 7);
    freq.put("bie", 15);
    freq.put("Oc", 33);
    freq.put("bic", 3);
    freq.put("Ow", 4);
    freq.put("bit", 25);
    freq.put("gr", 89);
    freq.put("Or", 13);
    freq.put("d", 1936);
    freq.put("eez", 8);
    freq.put("eet", 37);
    freq.put("eev", 8);
    freq.put("eep", 43);
    freq.put("ees", 31);
    freq.put("eer", 18);
    freq.put("eem", 10);
    freq.put("eel", 50);
    freq.put("een", 135);
    freq.put("eek", 30);
    freq.put("eed", 27);
    freq.put("eeg", 11);
    freq.put("b ", 6);
    freq.put("uf ", 10);
    freq.put("aed", 139);
    freq.put("pet", 3);
    freq.put("pew", 3);
    freq.put("per", 19);
    freq.put("pes", 3);
    freq.put("pen", 18);
    freq.put("pei", 13);
    freq.put("pee", 12);
    freq.put("cei", 3);
    freq.put("pea", 19);
    freq.put("id ", 175);
    freq.put("pec", 5);
    freq.put("be", 228);
    freq.put("rui", 7);
    freq.put("run", 25);
    freq.put("ba", 122);
    freq.put("bb", 15);
    freq.put("rum", 17);
    freq.put("bl", 106);
    freq.put("bo", 117);
    freq.put("bi", 71);
    freq.put("O", 88);
    freq.put("rue", 11);
    freq.put("bu", 135);
    freq.put("br", 87);
    freq.put("bs", 3);
    freq.put("rus", 5);
    freq.put("by", 50);
    freq.put("che", 60);
    freq.put("idy", 3);
    freq.put("idw", 4);
    freq.put("Rob", 3);
    freq.put("ids", 5);
    freq.put("idn", 18);
    freq.put("idl", 18);
    freq.put("yle", 5);
    freq.put("idi", 3);
    freq.put("wi ", 106);
    freq.put("idd", 3);
    freq.put("ide", 44);
    freq.put("pe ", 22);
    freq.put("ida", 3);
    freq.put("nsi", 7);
    freq.put("wn ", 13);
    freq.put(" up", 88);
    freq.put("nse", 18);
    freq.put(" us", 19);
    freq.put(" un", 29);
    freq.put(" ui", 3);
    freq.put("cho", 6);
    freq.put("nst", 3);
    freq.put("nsw", 4);
    freq.put("ut ", 134);
    freq.put("i", 4386);
    freq.put("ust", 7);
    freq.put("Tha", 66);
    freq.put("Oor", 4);
    freq.put("uss", 3);
    freq.put("u ", 144);
    freq.put("fes", 14);
    freq.put(" Ch", 10);
    freq.put(" Co", 20);
    freq.put(" Cl", 5);
    freq.put("ns ", 56);
    freq.put(" Ca", 10);
    freq.put("chy", 3);
    freq.put(" Cr", 4);
    freq.put("wny", 3);
    freq.put("Fle", 6);
    freq.put("mse", 9);
    freq.put("uy", 5);
    freq.put("uz", 3);
    freq.put("ut", 153);
    freq.put("uth", 8);
    freq.put("uv", 11);
    freq.put("up", 99);
    freq.put("us", 108);
    freq.put("ur", 203);
    freq.put("um", 58);
    freq.put("ul", 120);
    freq.put("uo", 3);
    freq.put("un", 271);
    freq.put("ui", 245);
    freq.put("uk", 136);
    freq.put("ue", 49);
    freq.put("ud", 116);
    freq.put("ug", 22);
    freq.put("uf", 14);
    freq.put("ua", 15);
    freq.put("uc", 72);
    freq.put("ub", 4);
    freq.put("lyt", 7);
    freq.put("Tw", 3);
    freq.put("Tr", 3);
    freq.put("To", 6);
    freq.put("Th", 215);
    freq.put("Ti", 12);
    freq.put("Te", 9);
    freq.put("lyi", 3);
    freq.put("Ta", 33);
    freq.put("A ", 176);
    freq.put(" gu", 56);
    freq.put(" gr", 81);
    freq.put("tic", 10);
    freq.put("nae", 41);
    freq.put("nak", 3);
    freq.put("nai", 15);
    freq.put("nan", 11);
    freq.put("nal", 12);
    freq.put("gry", 3);
    freq.put("vou", 3);
    freq.put(" ge", 31);
    freq.put("naw", 7);
    freq.put("gra", 26);
    freq.put("Mai", 7);
    freq.put(" go", 32);
    freq.put(" gl", 26);
    freq.put(" gi", 64);
    freq.put("ddy", 3);
    freq.put("ly ", 48);
    freq.put("ago", 3);
    freq.put("ge", 74);
    freq.put("Ab", 7);
    freq.put("e", 7908);
    freq.put("Ad", 4);
    freq.put("agi", 7);
    freq.put("Af", 3);
    freq.put("agg", 5);
    freq.put("Ah", 3);
    freq.put("age", 4);
    freq.put("Am", 6);
    freq.put("aga", 13);
    freq.put("An", 155);
    freq.put("Ma ", 12);
    freq.put("As", 21);
    freq.put("Ar", 4);
    freq.put("Au", 9);
    freq.put("At", 7);
    freq.put("Aw", 13);
    freq.put("Ay", 7);
    freq.put(" b", 771);
    freq.put(" c", 500);
    freq.put("gu", 93);
    freq.put(" a", 1705);
    freq.put(" f", 515);
    freq.put(" g", 534);
    freq.put(" d", 401);
    freq.put(" e", 140);
    freq.put(" j", 31);
    freq.put(" k", 152);
    freq.put(" h", 1153);
    freq.put(" i", 405);
    freq.put(" n", 271);
    freq.put(" o", 507);
    freq.put(" l", 463);
    freq.put(" m", 647);
    freq.put(" r", 256);
    freq.put(" s", 1378);
    freq.put(" p", 225);
    freq.put(" q", 18);
    freq.put(" v", 23);
    freq.put(" w", 1084);
    freq.put(" t", 2223);
    freq.put(" u", 140);
    freq.put("go", 43);
    freq.put("Gin", 15);
    freq.put("gm", 3);
    freq.put(" y", 268);
    freq.put("gi", 135);
    freq.put("gh", 15);
    freq.put(" B", 90);
    freq.put(" C", 50);
    freq.put(" A", 422);
    freq.put(" F", 105);
    freq.put(" G", 78);
    freq.put(" D", 28);
    freq.put(" E", 8);
    freq.put(" J", 47);
    freq.put(" K", 10);
    freq.put(" H", 124);
    freq.put(" I", 74);
    freq.put(" N", 42);
    freq.put(" O", 88);
    freq.put(" L", 33);
    freq.put(" M", 73);
    freq.put(" R", 14);
    freq.put(" S", 184);
    freq.put(" P", 28);
    freq.put(" W", 134);
    freq.put(" T", 285);
    freq.put(" U", 5);
    freq.put("Nou", 23);
    freq.put(" Y", 24);
    freq.put("Nor", 4);
    freq.put("ed ", 260);
    freq.put("P", 28);
    freq.put(" Wh", 49);
    freq.put("g ", 255);
    freq.put("tri", 22);
    freq.put("evi", 8);
    freq.put("tro", 3);
    freq.put("tra", 49);
    freq.put("us ", 61);
    freq.put("tre", 31);
    freq.put("eve", 14);
    freq.put("lk ", 7);
    freq.put("try", 6);
    freq.put("tru", 5);
    freq.put("rro", 3);
    freq.put("ody", 35);
    freq.put("zi", 5);
    freq.put("rri", 3);
    freq.put("uee", 7);
    freq.put("ze", 11);
    freq.put("rre", 4);
    freq.put("rra", 10);
    freq.put("uir", 39);
    freq.put("odi", 3);
    freq.put("ult", 3);
    freq.put("rry", 3);
    freq.put("odd", 39);
    freq.put("ode", 5);
    freq.put("odf", 7);
    freq.put("odg", 4);
    freq.put("rd ", 66);
    freq.put("lea", 38);
    freq.put("led", 7);
    freq.put("flo", 4);
    freq.put("lef", 4);
    freq.put("leg", 7);
    freq.put("lei", 12);
    freq.put("lem", 5);
    freq.put("len", 12);
    freq.put("rr ", 5);
    freq.put("ler", 20);
    freq.put("les", 50);
    freq.put("let", 5);
    freq.put("leu", 72);
    freq.put("lew", 13);
    freq.put("od ", 16);
    freq.put("ley", 8);
    freq.put("eni", 28);
    freq.put("rds", 16);
    freq.put("rde", 11);
    freq.put("rdl", 4);
    freq.put("ms ", 16);
    freq.put("rdi", 8);
    freq.put("cti", 7);
    freq.put("Or ", 13);
    freq.put("wif", 87);
    freq.put("wie", 5);
    freq.put("wic", 6);
    freq.put(" Di", 3);
    freq.put(" oo", 64);
    freq.put("aps", 8);
    freq.put(" De", 6);
    freq.put("wil", 35);
    freq.put(" Da", 6);
    freq.put("wit", 11);
    freq.put("wis", 232);
    freq.put("wir", 18);
    freq.put(" Du", 7);
    freq.put(" Dr", 3);
    freq.put("ape", 17);
    freq.put("cha", 35);
    freq.put("Fr", 17);
    freq.put("fee", 11);
    freq.put("fec", 8);
    freq.put("fea", 13);
    freq.put("chi", 26);
    freq.put("fel", 10);
    freq.put("usk", 7);
    freq.put("ush", 3);
    freq.put("Fa", 6);
    freq.put("zie", 4);
    freq.put("fer", 5);
    freq.put("Fe", 29);
    freq.put("Fi", 5);
    freq.put("Fl", 7);
    freq.put("Fo", 38);
    freq.put("Gud", 4);
    freq.put("Gui", 10);
    freq.put("om", 106);
    freq.put(" oc", 11);
    freq.put("ap ", 23);
    freq.put("ch ", 87);
    freq.put("oi", 3);
    freq.put("fe ", 86);
    freq.put("f", 843);
    freq.put("Ja", 29);
    freq.put("ack", 83);
    freq.put(" Ro", 4);
    freq.put(" Ri", 3);
    freq.put("tat", 6);
    freq.put("tau", 21);
    freq.put("ach", 15);
    freq.put("tap", 24);
    freq.put("tar", 8);
    freq.put("tae", 255);
    freq.put("tab", 7);
    freq.put(" ow", 42);
    freq.put("tal", 5);
    freq.put("tam", 4);
    freq.put("tan", 20);
    freq.put("Mr ", 22);
    freq.put("tai", 11);
    freq.put("tak", 22);
    freq.put("afo", 23);
    freq.put(" ve", 9);
    freq.put("Yo", 7);
    freq.put("sit", 21);
    freq.put(" vi", 7);
    freq.put("On ", 6);
    freq.put("Ye", 16);
    freq.put("sic", 24);
    freq.put("dwa", 3);
    freq.put("sig", 4);
    freq.put("sie", 25);
    freq.put("sid", 22);
    freq.put("aft", 12);
    freq.put("dwi", 4);
    freq.put("sin", 22);
    freq.put("sim", 4);
    freq.put("sil", 7);
    freq.put(" v ", 3);
    freq.put("aff", 21);
    freq.put("ens", 18);
    freq.put("nyw", 7);
    freq.put("Twa", 3);
    freq.put("ny ", 54);
    freq.put("ld", 117);
    freq.put("le", 481);
    freq.put("euk", 96);
    freq.put("la", 337);
    freq.put("lo", 86);
    freq.put("ll", 263);
    freq.put("ent", 80);
    freq.put("lk", 18);
    freq.put("li", 212);
    freq.put("lt", 49);
    freq.put("lu", 41);
    freq.put("ls", 30);
    freq.put("lp", 11);
    freq.put("ea ", 22);
    freq.put("bin", 6);
    freq.put("ly", 59);
    freq.put("dae", 46);
    freq.put("daf", 4);
    freq.put("dac", 5);
    freq.put("dam", 5);
    freq.put("dan", 3);
    freq.put("Ay ", 7);
    freq.put("dau", 11);
    freq.put("daw", 3);
    freq.put("Can", 3);
    freq.put("day", 46);
    freq.put("San", 3);
    freq.put("l ", 429);
    freq.put(" hu", 50);
    freq.put(" hi", 289);
    freq.put(" ho", 54);
    freq.put(" ha", 223);
    freq.put("Saw", 4);
    freq.put("by ", 44);
    freq.put("ouk", 4);
    freq.put("oui", 3);
    freq.put("oun", 59);
    freq.put("oum", 8);
    freq.put("oul", 25);
    freq.put("ouc", 3);
    freq.put("oue", 13);
    freq.put("oud", 84);
    freq.put("ouz", 3);
    freq.put("mar", 3);
    freq.put("wes", 4);
    freq.put("ous", 19);
    freq.put("our", 42);
    freq.put("hle", 10);
    freq.put("oup", 3);
    freq.put("out", 15);
    freq.put("rer", 5);
    freq.put("res", 18);
    freq.put("rep", 5);
    freq.put("rew", 8);
    freq.put("ret", 4);
    freq.put("rei", 21);
    freq.put("ren", 18);
    freq.put("wer", 64);
    freq.put("rel", 9);
    freq.put("rem", 3);
    freq.put("rec", 5);
    freq.put("rea", 43);
    freq.put("red", 9);
    freq.put("ree", 92);
    freq.put("ece", 3);
    freq.put("eca", 4);
    freq.put("eco", 4);
    freq.put("ou ", 123);
    freq.put("eck", 10);
    freq.put("ech", 12);
    freq.put("qua", 12);
    freq.put("ect", 5);
    freq.put("que", 7);
    freq.put("ecr", 3);
    freq.put("x", 31);
    freq.put("qui", 5);
    freq.put("quo", 3);
    freq.put("g", 1092);
    freq.put("lte", 3);
    freq.put("re ", 263);
    freq.put("rs ", 92);
    freq.put("loo", 9);
    freq.put("ud ", 73);
    freq.put("ars", 22);
    freq.put("ses", 15);
    freq.put("aru", 3);
    freq.put(" Sy", 50);
    freq.put("los", 4);
    freq.put("be ", 91);
    freq.put("nda", 11);
    freq.put(" St", 5);
    freq.put(" Su", 26);
    freq.put("clo", 9);
    freq.put(" Sh", 27);
    freq.put(" Si", 8);
    freq.put(" So", 25);
    freq.put(" Sa", 27);
    freq.put("mer", 35);
    freq.put(" Se", 6);
    freq.put("uds", 5);
    freq.put("rso", 4);
    freq.put("Ke", 6);
    freq.put("rse", 28);
    freq.put("Ki", 3);
    freq.put("ogl", 3);
    freq.put("R", 14);
    freq.put("too", 5);
    freq.put("ude", 10);
    freq.put("rst", 20);
    freq.put("udn", 23);
    freq.put("vie", 6);
    freq.put("bei", 3);
    freq.put("ben", 13);
    freq.put("bel", 11);
    freq.put("bec", 6);
    freq.put("bea", 7);
    freq.put("beg", 15);
    freq.put("bed", 18);
    freq.put("bee", 16);
    freq.put("ik ", 21);
    freq.put("ber", 10);
    freq.put("bes", 11);
    freq.put("bew", 4);
    freq.put("bet", 6);
    freq.put("beu", 11);
    freq.put("Pap", 15);
    freq.put("hy", 20);
    freq.put("ari", 6);
    freq.put("aw ", 158);
    freq.put("sk", 26);
    freq.put("ark", 16);
    freq.put("ur ", 92);
    freq.put("ck ", 98);
    freq.put("min", 22);
    freq.put("arl", 17);
    freq.put("mic", 11);
    freq.put("mid", 3);
    freq.put("ums", 9);
    freq.put("bur", 8);
    freq.put("arn", 8);
    freq.put("bus", 8);
    freq.put("mis", 8);
    freq.put("mir", 9);
    freq.put("mit", 8);
    freq.put("whe", 8);
    freq.put("J", 47);
    freq.put("wha", 63);
    freq.put(" Ef", 3);
    freq.put("awt", 8);
    freq.put("aws", 14);
    freq.put("awr", 13);
    freq.put("ead", 26);
    freq.put("awn", 13);
    freq.put("awm", 4);
    freq.put("pyl", 3);
    freq.put("but", 88);
    freq.put("awi", 6);
    freq.put("awf", 6);
    freq.put("awe", 8);
    freq.put("awb", 5);
    freq.put("awa", 24);
    freq.put("urd", 18);
    freq.put("ure", 10);
    freq.put("urc", 38);
    freq.put("ckl", 42);
    freq.put("urn", 14);
    freq.put("cki", 19);
    freq.put("urk", 4);
    freq.put("urt", 4);
    freq.put("bui", 12);
    freq.put("cks", 15);
    freq.put("urs", 6);
    freq.put("nge", 14);
    freq.put("ear", 112);
    freq.put("co ", 8);
    freq.put("ngl", 6);
    freq.put(" is", 27);
    freq.put(" it", 134);
    freq.put("ngi", 16);
    freq.put(" iv", 4);
    freq.put("sh ", 26);
    freq.put("ae ", 571);
    freq.put(" il", 18);
    freq.put(" in", 209);
    freq.put("ngs", 22);
    freq.put("eav", 10);
    freq.put(" if", 10);
    freq.put("muc", 32);
    freq.put("aes", 28);
    freq.put(" we", 145);
    freq.put("sht", 12);
    freq.put("aet", 10);
    freq.put(" wa", 237);
    freq.put("h", 4156);
    freq.put("tti", 21);
    freq.put(" wh", 141);
    freq.put(" wi", 522);
    freq.put("sha", 27);
    freq.put("aeb", 5);
    freq.put(" wr", 19);
    freq.put("ks ", 46);
    freq.put("aei", 5);
    freq.put("shi", 23);
    freq.put("sho", 38);
    freq.put("ebe", 3);
    freq.put("ebb", 8);
    freq.put("ebo", 7);
    freq.put("C", 50);
    freq.put("ke ", 48);
    freq.put("Pa", 16);
    freq.put("Pe", 4);
    freq.put("Po", 4);
    freq.put("ome", 78);
    freq.put("luv", 9);
    freq.put("et ", 88);
    freq.put("lue", 7);
    freq.put("lug", 5);
    freq.put("lui", 11);
    freq.put("dly", 9);
    freq.put("omi", 8);
    freq.put("lun", 3);
    freq.put("ken", 35);
    freq.put("kem", 4);
    freq.put("kel", 9);
    freq.put("joy", 3);
    freq.put("kee", 55);
    freq.put("S", 184);
    freq.put("omm", 5);
    freq.put("key", 4);
    freq.put("ket", 5);
    freq.put("kes", 5);
    freq.put("ker", 14);
    freq.put("ets", 7);
    freq.put("ett", 20);
    freq.put("tly", 5);
    freq.put("ety", 4);
    freq.put("etc", 3);
    freq.put("tla", 3);
    freq.put("tle", 42);
    freq.put("ws", 25);
    freq.put("eth", 21);
    freq.put("eti", 15);
    freq.put("ck", 200);
    freq.put("ci", 6);
    freq.put("ch", 388);
    freq.put("co", 175);
    freq.put("Her", 13);
    freq.put("cl", 74);
    freq.put("cc", 3);
    freq.put("ca", 202);
    freq.put("rva", 8);
    freq.put("ce", 101);
    freq.put("Lor", 7);
    freq.put("cy", 4);
    freq.put("cr", 66);
    freq.put("uck", 42);
    freq.put("rpl", 4);
    freq.put("cu", 14);
    freq.put("ct", 11);
    freq.put("bbl", 4);
    freq.put("An ", 131);
    freq.put("bbe", 8);
    freq.put("ys ", 98);
    freq.put("yam", 7);
    freq.put("yai", 6);
    freq.put("rvi", 4);
    freq.put("oth", 17);
    freq.put("c ", 17);
    freq.put("uil", 6);
    freq.put("rp ", 6);
    freq.put("cor", 22);
    freq.put("He ", 57);
    freq.put("unt", 15);
    freq.put("otr", 4);
    freq.put("uin", 29);
    freq.put("ott", 12);
    freq.put("And", 19);
    freq.put("rby", 4);
    freq.put("Anc", 3);
    freq.put("uis", 29);
    freq.put("rbl", 3);
    freq.put("uit", 30);
    freq.put("va", 14);
    freq.put(" Fr", 17);
    freq.put("ve", 118);
    freq.put("vi", 33);
    freq.put("myn", 15);
    freq.put("vo", 4);
    freq.put(" Fa", 6);
    freq.put("pip", 3);
    freq.put(" Fe", 29);
    freq.put("avi", 6);
    freq.put(" Fi", 5);
    freq.put("vy", 3);
    freq.put("You", 7);
    freq.put(" Fl", 7);
    freq.put(" Fo", 38);
    freq.put("of ", 4);
    freq.put("coc", 5);
    freq.put("v ", 8);
    freq.put("wk ", 22);
    freq.put("iou", 9);
    freq.put("ion", 16);
    freq.put("ont", 20);
    freq.put(" Tw", 3);
    freq.put("unl", 10);
    freq.put(" Tr", 3);
    freq.put(" To", 6);
    freq.put("unn", 15);
    freq.put(" Ti", 12);
    freq.put(" Th", 215);
    freq.put(" Te", 9);
    freq.put("con", 16);
    freq.put(" Ta", 33);
    freq.put("xed", 3);
    freq.put(" me", 115);
    freq.put("tch", 19);
    freq.put("nou", 40);
    freq.put("adv", 3);
    freq.put("Be", 12);
    freq.put("wea", 34);
    freq.put("ads", 13);
    freq.put("wee", 68);
    freq.put("wed", 10);
    freq.put("wei", 10);
    freq.put("Bo", 4);
    freq.put("sky", 3);
    freq.put("Bi", 4);
    freq.put("ske", 5);
    freq.put("Bu", 45);
    freq.put("add", 7);
    freq.put("ade", 21);
    freq.put("adn", 10);
    freq.put("wey", 22);
    freq.put("ski", 11);
    freq.put("By", 6);
    freq.put("adi", 14);
    freq.put("T", 285);
    freq.put("we ", 32);
    freq.put("sk ", 5);
    freq.put("ad ", 61);
    freq.put("Sau", 4);
    freq.put("Sui", 25);
    freq.put("Sae", 11);
    freq.put("est", 37);
    freq.put("ess", 43);
    freq.put("esp", 3);
    freq.put("nd ", 176);
    freq.put("nfu", 3);
    freq.put("ese", 5);
    freq.put("eso", 6);
    freq.put("esh", 16);
    freq.put("dui", 3);
    freq.put("Up", 3);
    freq.put("ndi", 18);
    freq.put("ndl", 3);
    freq.put(" ju", 19);
    freq.put("nde", 19);
    freq.put("ndy", 3);
    freq.put(" jo", 6);
    freq.put(" he", 536);
    freq.put("es ", 214);
    freq.put("nds", 14);
    freq.put(" ja", 6);
    freq.put("own", 5);
    freq.put("owi", 5);
    freq.put("owk", 25);
    freq.put("owe", 65);
    freq.put("owd", 20);
    freq.put("Afo", 3);
    freq.put("h ", 164);
    freq.put("owp", 11);
    freq.put("ows", 7);
    freq.put("owr", 3);
    freq.put("vai", 4);
    freq.put("van", 8);
    freq.put("Ama", 5);
    freq.put("rch", 40);
    freq.put("eak", 12);
    freq.put("buy", 5);
    freq.put("eam", 7);
    freq.put("eal", 11);
    freq.put("ean", 10);
    freq.put("hr", 63);
    freq.put("hs", 9);
    freq.put("eac", 4);
    freq.put("eab", 6);
    freq.put("ow ", 8);
    freq.put("ht", 190);
    freq.put("hu", 66);
    freq.put("hi", 527);
    freq.put("hn", 12);
    freq.put("ho", 206);
    freq.put("hl", 12);
    freq.put("bum", 3);
    freq.put("buc", 6);
    freq.put("eas", 14);
    freq.put("ha", 874);
    freq.put("hf", 17);
    freq.put("eat", 27);
    freq.put("he", 1996);
    freq.put("dma", 21);
    freq.put("j", 34);
    freq.put("Tee", 6);
    freq.put("pin", 22);
    freq.put("int", 65);
    freq.put("pic", 6);
    freq.put("pie", 3);
    freq.put("ins", 29);
    freq.put("inn", 34);
    freq.put("ini", 11);
    freq.put("ink", 32);
    freq.put("ind", 43);
    freq.put("ine", 19);
    freq.put("inf", 3);
    freq.put("ing", 91);
    freq.put("pit", 35);
    freq.put("ina", 11);
    freq.put("inb", 3);
    freq.put("inc", 10);
    freq.put("hn ", 5);
    freq.put("oan", 4);
    freq.put("oam", 5);
    freq.put(" Up", 3);
    freq.put("oat", 10);
    freq.put("or ", 230);
    freq.put("gau", 23);
    freq.put("gar", 16);
    freq.put("U", 5);
    freq.put("uba", 3);
    freq.put("my ", 13);
    freq.put("in ", 552);
    freq.put("eoc", 8);
    freq.put("eon", 39);
    freq.put("hnn", 5);
    freq.put("o ", 287);
  }
  
}

