package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class PL extends CLangProfile {
  private static final String name = "pl";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public PL() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 44927968;
    n_words[1] = 50956492;
    n_words[2] = 36530760;

    freq.put("aln", 38047);
    freq.put("sco", 24974);
    freq.put("me\u0328", 6084);
    freq.put("sch", 21250);
    freq.put("auk", 5346);
    freq.put("Kos\u0301", 5328);
    freq.put("mi ", 36519);
    freq.put("aut", 8273);
    freq.put("G ", 10044);
    freq.put(" Gr", 14678);
    freq.put("\u0142ec", 8332);
    freq.put("ajm", 4898);
    freq.put("o\u0142a", 8333);
    freq.put(" Ge", 5971);
    freq.put("GC", 12708);
    freq.put(" Ga", 8827);
    freq.put("ra ", 38610);
    freq.put(" Go", 7898);
    freq.put(" Gm", 6328);
    freq.put("Gr", 14758);
    freq.put("upa", 5160);
    freq.put("Ge", 6043);
    freq.put("Ga", 8896);
    freq.put("upy", 9651);
    freq.put("Go", 7919);
    freq.put("Gm", 6336);
    freq.put(" ka", 27845);
    freq.put("za ", 37664);
    freq.put("me ", 5269);
    freq.put(" ki", 9981);
    freq.put(" ko", 64410);
    freq.put(" kl", 10638);
    freq.put(" km", 9336);
    freq.put(" kr", 29471);
    freq.put(" ks", 6999);
    freq.put(" kw", 7071);
    freq.put(" kt", 33550);
    freq.put(" ku", 10205);
    freq.put("a\u0328tk", 5004);
    freq.put("je\u0328 ", 5820);
    freq.put("osz", 15296);
    freq.put("nem", 5441);
    freq.put("nej", 47963);
    freq.put("nek", 13069);
    freq.put("neg", 51936);
    freq.put("ka\u0328 ", 14644);
    freq.put("kul", 5213);
    freq.put("kuj", 7417);
    freq.put("cz\u0142", 5966);
    freq.put("net", 21971);
    freq.put("ak ", 12839);
    freq.put("ner", 9906);
    freq.put("nes", 4536);
    freq.put("\u0141", 9157);
    freq.put(" Go\u0301", 8232);
    freq.put("men", 33777);
    freq.put("je\u0328z", 8303);
    freq.put("ors", 22187);
    freq.put("met", 12557);
    freq.put("mer", 18450);
    freq.put("cze\u0328", 22437);
    freq.put("Go\u0301", 8233);
    freq.put("k", 1483844);
    freq.put("dru", 8195);
    freq.put("Za", 17995);
    freq.put("ne ", 77120);
    freq.put("akt", 18470);
    freq.put("aki", 8717);
    freq.put("ako", 21085);
    freq.put("dro", 12893);
    freq.put("akc", 4640);
    freq.put("aka", 5857);
    freq.put("ku ", 72509);
    freq.put("Jes", 5251);
    freq.put("brz", 9909);
    freq.put("bry", 5366);
    freq.put("Kon", 5190);
    freq.put("bro", 10887);
    freq.put("bra", 11568);
    freq.put("e\u0328st", 6004);
    freq.put("dne", 6153);
    freq.put("dna", 7598);
    freq.put("m ", 343638);
    freq.put("dno", 17791);
    freq.put("dni", 85396);
    freq.put("oz\u0307e", 6845);
    freq.put("er ", 34400);
    freq.put("o\u0301z\u0307n", 6877);
    freq.put("dny", 5925);
    freq.put("ni ", 23063);
    freq.put("nka", 8221);
    freq.put("nkc", 4543);
    freq.put("Sta", 19220);
    freq.put("nki", 7495);
    freq.put("o\u0142e", 8524);
    freq.put("jmu", 7356);
    freq.put("z\u0307e ", 16017);
    freq.put("nku", 6543);
    freq.put("Str", 5084);
    freq.put("V", 29111);
    freq.put("o\u0142u", 20038);
    freq.put("me", 89660);
    freq.put("eru", 5751);
    freq.put("erw", 27139);
    freq.put("ma", 121066);
    freq.put("mc", 10115);
    freq.put("mb", 17385);
    freq.put("mm", 6313);
    freq.put("mo", 86555);
    freq.put("mn", 11655);
    freq.put("mi", 333776);
    freq.put("ery", 23381);
    freq.put("erz", 21989);
    freq.put("mu", 41658);
    freq.put("ere", 16329);
    freq.put("erg", 8537);
    freq.put("mp", 24445);
    freq.put("ms", 11588);
    freq.put("erc", 5702);
    freq.put("erm", 6952);
    freq.put("ern", 18633);
    freq.put("ero", 30451);
    freq.put("my", 18150);
    freq.put("eri", 17872);
    freq.put("Le", 13922);
    freq.put("La", 13916);
    freq.put("Lo", 10236);
    freq.put("la ", 29248);
    freq.put("Li", 15420);
    freq.put("czk", 8277);
    freq.put("Lu", 9458);
    freq.put("czn", 94844);
    freq.put("czo", 18714);
    freq.put("cza", 38835);
    freq.put("cze", 61835);
    freq.put("ena", 8388);
    freq.put("hod", 42292);
    freq.put("ib", 17573);
    freq.put("end", 7106);
    freq.put("ene", 12261);
    freq.put("eni", 82488);
    freq.put("hol", 4719);
    freq.put("enk", 5319);
    freq.put("enn", 11782);
    freq.put("eno", 4952);
    freq.put("Kar", 5182);
    freq.put("ens", 6693);
    freq.put("hor", 6372);
    freq.put("no\u0301w", 11177);
    freq.put("A", 113161);
    freq.put("lam", 5773);
    freq.put("lan", 38327);
    freq.put("L ", 4866);
    freq.put("lak", 7036);
    freq.put("lac", 9698);
    freq.put("II ", 13664);
    freq.put("lat", 37023);
    freq.put("z\u0307ni", 7269);
    freq.put("cz ", 10143);
    freq.put("mpi", 5561);
    freq.put("lar", 10967);
    freq.put("las", 14320);
    freq.put("en ", 29550);
    freq.put("akz\u0307", 7374);
    freq.put("mo\u0301", 8836);
    freq.put("zeb", 5093);
    freq.put("zec", 34126);
    freq.put("zeg", 13280);
    freq.put("zed", 16305);
    freq.put("zej", 12005);
    freq.put("zek", 13631);
    freq.put("zen", 40191);
    freq.put("zel", 6475);
    freq.put("zem", 9711);
    freq.put("zer", 16763);
    freq.put("zes", 26033);
    freq.put(" Hi", 5632);
    freq.put("zam", 9131);
    freq.put(" Ho", 9424);
    freq.put("zew", 14699);
    freq.put("zez", 38687);
    freq.put("zaj", 18917);
    freq.put(" Ha", 11737);
    freq.put(" He", 11280);
    freq.put("ono", 16680);
    freq.put("ro\u0301", 58140);
    freq.put("imi", 11049);
    freq.put("imp", 4698);
    freq.put("fia", 9588);
    freq.put("fik", 6148);
    freq.put("fil", 7378);
    freq.put("ze ", 43444);
    freq.put("\u0142", 591480);
    freq.put("dem", 8020);
    freq.put(" Vi", 4980);
    freq.put("wsc", 10075);
    freq.put("im ", 137877);
    freq.put("osk", 7450);
    freq.put("den", 21584);
    freq.put("zwa", 16748);
    freq.put("l", 1140017);
    freq.put("zwy", 6194);
    freq.put("okr", 39604);
    freq.put("wsk", 48535);
    freq.put("dyc", 5708);
    freq.put("oku", 40113);
    freq.put("nii", 15486);
    freq.put("zaw", 17852);
    freq.put("nt ", 17005);
    freq.put(" zm", 8262);
    freq.put("ru", 79284);
    freq.put(" zo", 12577);
    freq.put("rw", 35761);
    freq.put("rp", 13436);
    freq.put("at ", 32096);
    freq.put("rs", 83617);
    freq.put(" ze", 19904);
    freq.put(" zd", 5616);
    freq.put("dst", 8461);
    freq.put(" za", 89284);
    freq.put("aju", 12289);
    freq.put("rz", 330244);
    freq.put(" zb", 9872);
    freq.put("rd", 33902);
    freq.put("re", 197175);
    freq.put("rf", 5604);
    freq.put("rg", 38504);
    freq.put("ra", 338168);
    freq.put("rb", 12273);
    freq.put("ajo", 5413);
    freq.put("rl", 14366);
    freq.put("aja", 6999);
    freq.put(" zw", 23230);
    freq.put("is ", 13674);
    freq.put("ajd", 19542);
    freq.put("aje", 5093);
    freq.put("gos", 5577);
    freq.put("rk", 29749);
    freq.put("nty", 9827);
    freq.put("ntr", 10458);
    freq.put("ntu", 6194);
    freq.put("ied", 28632);
    freq.put("W", 122172);
    freq.put("nta", 17677);
    freq.put("nte", 16419);
    freq.put("isz", 10261);
    freq.put("ate", 18972);
    freq.put("ata", 29924);
    freq.put("ato", 27910);
    freq.put("rz ", 14438);
    freq.put(" z ", 107756);
    freq.put("ist", 59047);
    freq.put("isk", 17265);
    freq.put("isi", 4518);
    freq.put("atu", 20800);
    freq.put("atr", 8063);
    freq.put("aj ", 9008);
    freq.put("isa", 8456);
    freq.put(" Sp", 6969);
    freq.put("aty", 21623);
    freq.put("Y", 5329);
    freq.put("osa", 8380);
    freq.put("nis", 21291);
    freq.put("\u0142k", 15386);
    freq.put("tem", 19837);
    freq.put("zen\u0301", 5484);
    freq.put("\u0142u", 50120);
    freq.put("tor", 34275);
    freq.put("tos", 10191);
    freq.put("top", 9511);
    freq.put("pis", 14610);
    freq.put("tow", 38410);
    freq.put("tok", 8683);
    freq.put("toi", 15874);
    freq.put("ton", 10929);
    freq.put("tol", 14627);
    freq.put("tom", 6513);
    freq.put("z\u0307en", 5078);
    freq.put("zes\u0301", 12448);
    freq.put(" le", 15807);
    freq.put("B", 112599);
    freq.put(" la", 36395);
    freq.put(" lo", 7327);
    freq.put(" li", 34396);
    freq.put(" lu", 42219);
    freq.put("a\u0328sk", 8772);
    freq.put("kty", 11231);
    freq.put("ktu", 7021);
    freq.put("ktr", 5362);
    freq.put("kto", 8566);
    freq.put("uka", 4715);
    freq.put("Vi", 5052);
    freq.put("kte", 5141);
    freq.put("to ", 54716);
    freq.put("raf", 17050);
    freq.put("rad", 12311);
    freq.put("rab", 9860);
    freq.put("rac", 33149);
    freq.put("ran", 52894);
    freq.put("ral", 18585);
    freq.put("ram", 15553);
    freq.put("raj", 22570);
    freq.put("rak", 14728);
    freq.put("ose", 9237);
    freq.put("rai", 5724);
    freq.put("raw", 21807);
    freq.put("rat", 14245);
    freq.put("ras", 7862);
    freq.put("an\u0301 ", 4989);
    freq.put("raz", 29604);
    freq.put("s\u0301c\u0301 ", 40186);
    freq.put("do ", 56353);
    freq.put("en\u0301s", 10006);
    freq.put("on ", 32944);
    freq.put("tyl", 6759);
    freq.put("tym", 7939);
    freq.put("tyn", 8462);
    freq.put("an\u0301s", 33252);
    freq.put("bsz", 5466);
    freq.put("tyk", 20395);
    freq.put("bst", 6710);
    freq.put("re\u0328", 14692);
    freq.put("tyc", 48848);
    freq.put("ra\u0328", 23256);
    freq.put("an\u0301c", 7994);
    freq.put("tyt", 6677);
    freq.put("tyw", 7322);
    freq.put("typ", 6891);
    freq.put("aja\u0328", 56423);
    freq.put("tys", 5969);
    freq.put("dok", 4665);
    freq.put("en\u0301 ", 8305);
    freq.put("dol", 8096);
    freq.put("dom", 7183);
    freq.put("dob", 7583);
    freq.put("m", 1150421);
    freq.put("kto\u0301", 37445);
    freq.put("doz", 5829);
    freq.put("dor", 6162);
    freq.put("dos", 5363);
    freq.put("dow", 41632);
    freq.put("a\u0142 ", 24279);
    freq.put(" We", 8391);
    freq.put("rsz", 11669);
    freq.put(" Wa", 15970);
    freq.put(" Wo", 12135);
    freq.put("d ", 139962);
    freq.put(" Wi", 28155);
    freq.put(" Ws", 4674);
    freq.put(" Wy", 14786);
    freq.put("oci", 8093);
    freq.put("och", 19137);
    freq.put("ock", 7255);
    freq.put("em ", 73512);
    freq.put("ocn", 14524);
    freq.put("do\u0301w", 6742);
    freq.put("sto", 55229);
    freq.put("oce", 7209);
    freq.put("zak", 6986);
    freq.put("ocz", 25360);
    freq.put("ba ", 9607);
    freq.put("ztw", 56537);
    freq.put("hra", 5522);
    freq.put("\u0142ug", 11020);
    freq.put("\u0142ud", 14450);
    freq.put("dn", 125390);
    freq.put("do", 162506);
    freq.put("dl", 41406);
    freq.put("dm", 14590);
    freq.put("dk", 20908);
    freq.put(" W ", 13679);
    freq.put("di", 38677);
    freq.put("dd", 7144);
    freq.put("de", 106238);
    freq.put("db", 7638);
    freq.put("dc", 10689);
    freq.put("da", 129820);
    freq.put("wo\u0301", 72388);
    freq.put("dy", 56165);
    freq.put("dw", 18508);
    freq.put("du", 56828);
    freq.put("dr", 43512);
    freq.put("ds", 17240);
    freq.put("dp", 5891);
    freq.put("eme", 7011);
    freq.put("n\u0301 ", 16610);
    freq.put("bar", 9707);
    freq.put("emc", 9224);
    freq.put("emo", 5689);
    freq.put("az\u0301d", 4510);
    freq.put("la\u0328s", 7826);
    freq.put("uch", 15770);
    freq.put("\u0142u ", 9627);
    freq.put("om ", 7335);
    freq.put("iz\u0307", 7681);
    freq.put("w ", 734288);
    freq.put(" I ", 4633);
    freq.put("go ", 160963);
    freq.put("muz", 6245);
    freq.put("co ", 6133);
    freq.put("nie\u0328", 6603);
    freq.put("ira", 6326);
    freq.put("i\u0142", 21358);
    freq.put("in\u0301", 19637);
    freq.put("muj", 8914);
    freq.put("pni", 8916);
    freq.put("we", 125766);
    freq.put("wc", 28885);
    freq.put("wa", 271461);
    freq.put("wo", 213117);
    freq.put("wn", 80692);
    freq.put("omi", 22956);
    freq.put("wk", 11864);
    freq.put("wi", 428233);
    freq.put("wu", 6452);
    freq.put("omp", 9870);
    freq.put("ws", 100565);
    freq.put("wr", 13531);
    freq.put(" In", 12303);
    freq.put("wz", 9495);
    freq.put("wy", 175884);
    freq.put("ie\u0328", 123546);
    freq.put("ell", 8172);
    freq.put("cow", 30428);
    freq.put("ilo", 5237);
    freq.put("ill", 10795);
    freq.put("ilm", 5161);
    freq.put("ili", 7909);
    freq.put(" II", 9642);
    freq.put("und", 6279);
    freq.put("mu ", 12663);
    freq.put("uni", 8824);
    freq.put("unk", 16732);
    freq.put("ia\u0328", 60315);
    freq.put(" me", 15598);
    freq.put(" ma", 52176);
    freq.put("kwi", 7243);
    freq.put("io\u0301", 8421);
    freq.put(" mo", 21735);
    freq.put(" mi", 86248);
    freq.put(" mu", 9539);
    freq.put("san", 8261);
    freq.put("fra", 5853);
    freq.put("sam", 12218);
    freq.put("\u0142uz\u0307", 7054);
    freq.put("rga", 13673);
    freq.put("C ", 19133);
    freq.put("pro", 44748);
    freq.put("wa\u0328 ", 9465);
    freq.put("drz", 4777);
    freq.put("dz\u0301", 5330);
    freq.put("mcz", 8811);
    freq.put("zio", 8015);
    freq.put("sad", 8969);
    freq.put("Ci", 4668);
    freq.put("Ch", 21362);
    freq.put("Co", 11705);
    freq.put("anu", 7044);
    freq.put("Ca", 12445);
    freq.put("d\u0142", 15854);
    freq.put("Ce", 7894);
    freq.put("n", 2529442);
    freq.put("Cz", 10287);
    freq.put("ain", 11213);
    freq.put("gni", 4919);
    freq.put("z\u0301ni", 4961);
    freq.put("iz", 35250);
    freq.put("a\u0142a", 29091);
    freq.put("ip", 17035);
    freq.put("is", 139600);
    freq.put("ir", 31982);
    freq.put("iu", 39428);
    freq.put("it", 68750);
    freq.put("iw", 23202);
    freq.put("iv", 6169);
    freq.put("ii", 58678);
    freq.put("ik", 74901);
    freq.put("ij", 14562);
    freq.put("im", 169852);
    freq.put("il", 54561);
    freq.put("io", 133204);
    freq.put("in", 280897);
    freq.put("ia", 315115);
    freq.put("ic", 201937);
    freq.put("ki ", 116429);
    freq.put("ie", 1136068);
    freq.put("id", 59864);
    freq.put("ig", 21890);
    freq.put("if", 5037);
    freq.put("V ", 6364);
    freq.put("wa\u0328", 11216);
    freq.put("o\u0301ln", 9187);
    freq.put("we\u0328", 7097);
    freq.put("nik", 44866);
    freq.put("Od", 7399);
    freq.put("nin", 5902);
    freq.put("nio", 33347);
    freq.put("nim", 8023);
    freq.put("VI", 4920);
    freq.put("nia", 115515);
    freq.put("nie", 303754);
    freq.put("niz", 10946);
    freq.put("dra", 4842);
    freq.put("kim", 128411);
    freq.put("kic", 24931);
    freq.put("i ", 569208);
    freq.put("a\u0142o", 22494);
    freq.put("kie", 126958);
    freq.put("niu", 18651);
    freq.put("w\u0142", 15632);
    freq.put("\u0142a\u0328c", 7474);
    freq.put("epu", 5035);
    freq.put("epr", 8058);
    freq.put("the", 6053);
    freq.put("cza\u0328", 12269);
    freq.put("epa", 15408);
    freq.put("y\u0142y", 6907);
    freq.put("wcz", 7095);
    freq.put("wa\u0142", 10230);
    freq.put("na\u0328 ", 19254);
    freq.put("y\u0142a", 8647);
    freq.put("e\u0142", 15052);
    freq.put("elk", 19485);
    freq.put("eli", 15142);
    freq.put("eln", 10771);
    freq.put("elo", 10644);
    freq.put("han", 8170);
    freq.put("e\u0328 ", 96973);
    freq.put("ela", 11200);
    freq.put("ele", 25422);
    freq.put("els", 11724);
    freq.put("har", 13309);
    freq.put("elu", 7577);
    freq.put("opu", 5185);
    freq.put("rni", 18640);
    freq.put("rno", 5279);
    freq.put("D", 76546);
    freq.put("opr", 8595);
    freq.put("rna", 10748);
    freq.put("rne", 9659);
    freq.put("ope", 10070);
    freq.put("rny", 6200);
    freq.put("opa", 11132);
    freq.put("y\u0142 ", 11114);
    freq.put("S\u0301", 15543);
    freq.put("S\u0142o", 18142);
    freq.put("e\u0328k", 11873);
    freq.put("ha ", 5601);
    freq.put("e\u0328c", 19527);
    freq.put("e\u0328b", 8256);
    freq.put("e\u0328d", 32895);
    freq.put("e\u0328g", 11685);
    freq.put("e\u0328z", 11858);
    freq.put("ywa", 26508);
    freq.put("e\u0328p", 16514);
    freq.put("e\u0328s", 9306);
    freq.put("e\u0328t", 22906);
    freq.put("ywi", 7128);
    freq.put("ola", 10017);
    freq.put("a\u0328", 370153);
    freq.put("ole", 26115);
    freq.put("oli", 42609);
    freq.put("zch", 5824);
    freq.put("oln", 14866);
    freq.put("olo", 22365);
    freq.put(" Jo", 8117);
    freq.put("ols", 92465);
    freq.put("olu", 5605);
    freq.put(" Je", 18244);
    freq.put("an ", 25897);
    freq.put(" Ja", 16067);
    freq.put("zcz", 25210);
    freq.put("ick", 18455);
    freq.put("icj", 4509);
    freq.put("ici", 5695);
    freq.put("ich", 42480);
    freq.put("for", 16996);
    freq.put("ica", 18194);
    freq.put("yko", 9261);
    freq.put("ice", 16432);
    freq.put("cny", 4546);
    freq.put("ume", 5036);
    freq.put("icz", 59703);
    freq.put("icy", 13868);
    freq.put("Hi", 5668);
    freq.put("Ho", 9461);
    freq.put("Ha", 11794);
    freq.put("umi", 4996);
    freq.put("He", 11337);
    freq.put("na\u0328", 21831);
    freq.put("ne\u0328", 6037);
    freq.put("ple", 4628);
    freq.put("pla", 21906);
    freq.put("ywn", 5067);
    freq.put("obn", 4740);
    freq.put("obo", 8696);
    freq.put("obl", 4516);
    freq.put("yk ", 13655);
    freq.put("pi\u0142", 8661);
    freq.put("ic ", 6481);
    freq.put("o", 3537464);
    freq.put("s\u0301la\u0328", 5357);
    freq.put("um ", 20351);
    freq.put("oby", 5467);
    freq.put("zuj", 5309);
    freq.put("obr", 12863);
    freq.put("obs", 6969);
    freq.put("sob", 7483);
    freq.put("g\u0142o", 21325);
    freq.put("sok", 5885);
    freq.put("son", 7183);
    freq.put("sow", 15205);
    freq.put("opo", 27225);
    freq.put("wan", 92067);
    freq.put("wal", 11772);
    freq.put("waj", 5843);
    freq.put("s\u0142u", 9392);
    freq.put("az ", 24099);
    freq.put("wad", 9110);
    freq.put("wac", 6719);
    freq.put("gie", 12191);
    freq.put("s\u0142a", 11498);
    freq.put("gic", 6767);
    freq.put("gia", 4982);
    freq.put("gio", 21748);
    freq.put("no\u0301", 11750);
    freq.put("s\u0142o", 8768);
    freq.put("gii", 7756);
    freq.put("n\u0301", 123462);
    freq.put("ra\u0328z\u0307", 16283);
    freq.put("e\u0328s\u0301", 18258);
    freq.put("Z", 57656);
    freq.put("azo", 11989);
    freq.put("aza", 4626);
    freq.put("azd", 9097);
    freq.put("wa ", 75032);
    freq.put("azy", 7482);
    freq.put("e\u0328z\u0307", 7758);
    freq.put("gi ", 9182);
    freq.put("azu", 9191);
    freq.put("azw", 14194);
    freq.put("nni", 6637);
    freq.put("o\u0142o", 72193);
    freq.put("kor", 8298);
    freq.put("nne", 10038);
    freq.put("nna", 4663);
    freq.put("g\u0142o\u0301", 21438);
    freq.put("Sie", 4994);
    freq.put("s\u0301li", 5074);
    freq.put("ni", 692138);
    freq.put("nk", 45573);
    freq.put("nn", 38516);
    freq.put("no", 152706);
    freq.put("na", 529472);
    freq.put("nb", 5437);
    freq.put("nc", 75955);
    freq.put("nd", 63112);
    freq.put("ne", 249253);
    freq.put("nf", 7374);
    freq.put("ng", 54651);
    freq.put("ny", 249928);
    freq.put("tin", 4571);
    freq.put("tio", 8819);
    freq.put("nr", 4954);
    freq.put("ns", 36134);
    freq.put("nt", 96712);
    freq.put("nu", 23194);
    freq.put(" ni", 54044);
    freq.put("E", 48349);
    freq.put(" no", 11764);
    freq.put(" na", 181345);
    freq.put("yka", 23821);
    freq.put("mun", 5245);
    freq.put("ia\u0328g", 20115);
    freq.put("nko", 6939);
    freq.put("Wie", 13213);
    freq.put("n ", 138864);
    freq.put("yki", 7812);
    freq.put("roi", 15518);
    freq.put("roj", 6342);
    freq.put("rok", 41872);
    freq.put("rol", 7056);
    freq.put("rom", 11621);
    freq.put("ron", 23271);
    freq.put("osp", 5848);
    freq.put("rob", 7374);
    freq.put("roc", 14309);
    freq.put("rod", 59324);
    freq.put("iba\u0328", 4979);
    freq.put("rog", 11103);
    freq.put("osi", 14132);
    freq.put("roz", 22873);
    freq.put("oso", 13740);
    freq.put("rop", 15650);
    freq.put("lla", 5033);
    freq.put("ros", 15610);
    freq.put("rot", 7718);
    freq.put("lle", 8878);
    freq.put("row", 46481);
    freq.put("gu ", 24037);
    freq.put("ver", 4892);
    freq.put("zu ", 8060);
    freq.put("cne", 4800);
    freq.put(" do", 83523);
    freq.put("Go\u0301r", 8184);
    freq.put("ho\u0301d", 6854);
    freq.put("e\u0328pu", 8551);
    freq.put("ro ", 7330);
    freq.put("erp", 6669);
    freq.put("ll ", 4740);
    freq.put("dio", 7032);
    freq.put("ca\u0328 ", 7445);
    freq.put("o\u0301r", 65730);
    freq.put("ers", 24326);
    freq.put("o\u0301w", 161116);
    freq.put("dia", 9387);
    freq.put("p", 1082020);
    freq.put("z\u0307a\u0328", 12050);
    freq.put("o\u0301l", 16369);
    freq.put("o\u0301c", 5492);
    freq.put("o\u0301b", 6381);
    freq.put("ict", 6284);
    freq.put("der", 13407);
    freq.put("o\u0301d", 78413);
    freq.put("M ", 4990);
    freq.put("ruk", 5290);
    freq.put("oso\u0301", 4510);
    freq.put("cni", 7419);
    freq.put("nac", 26022);
    freq.put("Gra", 4795);
    freq.put("sa\u0328", 9617);
    freq.put("dzi", 114188);
    freq.put("ek ", 37209);
    freq.put("o\u0301\u0142n", 14744);
    freq.put("era", 33404);
    freq.put("Me", 12645);
    freq.put("Ma", 41474);
    freq.put("erb", 5967);
    freq.put("Mo", 18522);
    freq.put("Mi", 29200);
    freq.put("rug", 6274);
    freq.put("Mu", 5320);
    freq.put(" dw", 10226);
    freq.put("rud", 6357);
    freq.put("s\u0142", 33435);
    freq.put("eko", 5980);
    freq.put("eki", 4817);
    freq.put("dzk", 13570);
    freq.put("bor", 8274);
    freq.put("eka", 10766);
    freq.put("bow", 6707);
    freq.put("o\u0301\u0142 ", 8476);
    freq.put("ma\u0142", 6431);
    freq.put("eku", 6941);
    freq.put("ekt", 18859);
    freq.put("eks", 10430);
    freq.put("ipc", 5025);
    freq.put("z\u0307u", 6315);
    freq.put("z\u0307s", 5910);
    freq.put("spo\u0301", 13799);
    freq.put("z\u0307y", 40208);
    freq.put("z\u0307e", 31935);
    freq.put("uzy", 7699);
    freq.put("\u0142a ", 38802);
    freq.put("z\u0307a", 27767);
    freq.put("z\u0307n", 19632);
    freq.put("z\u0307o", 72896);
    freq.put(" Ka", 25219);
    freq.put(" Ki", 5713);
    freq.put(" Ko", 31759);
    freq.put(" Kr", 17816);
    freq.put("msk", 7954);
    freq.put("ult", 6004);
    freq.put(" Ku", 5884);
    freq.put("ca ", 84053);
    freq.put("Mon", 4650);
    freq.put("\u0142aw", 16966);
    freq.put("\u0142as", 4900);
    freq.put("F", 59499);
    freq.put("ma ", 13583);
    freq.put("\u0142ad", 27517);
    freq.put("\u0142ac", 9469);
    freq.put("z\u0307 ", 20942);
    freq.put("\u0142an", 5477);
    freq.put("o\u0301\u0142", 34199);
    freq.put("dzo", 7609);
    freq.put("o\u0301z\u0307", 8608);
    freq.put("so\u0301", 9957);
    freq.put("obi", 10703);
    freq.put("yjn", 27661);
    freq.put("yjs", 11565);
    freq.put("cac", 4624);
    freq.put("ula", 8673);
    freq.put(" on", 4611);
    freq.put("obe", 11907);
    freq.put(" ok", 44273);
    freq.put(" of", 7838);
    freq.put(" og", 5234);
    freq.put(" od", 78508);
    freq.put("Mie", 5310);
    freq.put("e\u0328s\u0301c", 13317);
    freq.put("spi", 8532);
    freq.put(" oz", 4712);
    freq.put(" ci", 24028);
    freq.put("spo", 28928);
    freq.put(" ot", 4775);
    freq.put(" or", 30563);
    freq.put(" os", 21891);
    freq.put(" op", 16859);
    freq.put("nym", 35914);
    freq.put("nyc", 66044);
    freq.put("s ", 109715);
    freq.put("mas", 6086);
    freq.put("mar", 13792);
    freq.put("mat", 15538);
    freq.put("maz", 13085);
    freq.put(" o ", 18463);
    freq.put("mac", 9833);
    freq.put("enc", 29197);
    freq.put("s\u0301", 279181);
    freq.put("maj", 8752);
    freq.put("mal", 6141);
    freq.put("ryk", 17536);
    freq.put("sz", 185716);
    freq.put("sy", 40789);
    freq.put("ide", 5884);
    freq.put("zne", 31393);
    freq.put("ss", 16223);
    freq.put("zni", 17047);
    freq.put("sp", 72745);
    freq.put("sw", 7100);
    freq.put("dyn", 9974);
    freq.put("su", 26228);
    freq.put("st", 440956);
    freq.put("sk", 362869);
    freq.put("sj", 10343);
    freq.put("si", 154595);
    freq.put("sh", 8501);
    freq.put("so", 57024);
    freq.put("sn", 10482);
    freq.put("sm", 8241);
    freq.put("sl", 4597);
    freq.put("sc", 108490);
    freq.put("sa", 75170);
    freq.put("yli", 7761);
    freq.put("se", 50637);
    freq.put("Ru", 5061);
    freq.put("rza\u0328", 15714);
    freq.put("ia\u0328z", 16848);
    freq.put("lsc", 50391);
    freq.put("so\u0301w", 5741);
    freq.put("no ", 23520);
    freq.put("lsk", 52175);
    freq.put("Rz", 5267);
    freq.put("ia\u0142", 33757);
    freq.put("Jan", 4677);
    freq.put("Re", 17869);
    freq.put("Ra", 13392);
    freq.put("z\u0307aj", 15742);
    freq.put("Ro", 19242);
    freq.put("rze\u0328", 9880);
    freq.put("s\u0301r", 30296);
    freq.put("o\u0301r ", 5776);
    freq.put("s\u0301w", 24072);
    freq.put("how", 11191);
    freq.put("\u0142o\u0301w", 28362);
    freq.put(" al", 15945);
    freq.put(" am", 10571);
    freq.put(" an", 21235);
    freq.put("s\u0301c", 92180);
    freq.put(" ar", 12965);
    freq.put(" as", 16623);
    freq.put(" au", 9619);
    freq.put("ent", 47936);
    freq.put("gel", 5153);
    freq.put("s\u0301n", 19502);
    freq.put("s\u0301l", 22153);
    freq.put("S\u0301wi", 8845);
    freq.put("uz\u0307y", 12473);
    freq.put("oro\u0301", 5598);
    freq.put("noc", 23507);
    freq.put("ert", 7815);
    freq.put("ryw", 7519);
    freq.put("ia\u0328 ", 10996);
    freq.put("now", 33236);
    freq.put("nor", 4839);
    freq.put("nos", 13706);
    freq.put(" a ", 33564);
    freq.put("o\u0301ra", 6553);
    freq.put("ji ", 74801);
    freq.put("o\u0301re", 15215);
    freq.put("o\u0301rn", 8319);
    freq.put("s\u0301 ", 45778);
    freq.put("h", 558914);
    freq.put("o\u0301ry", 15904);
    freq.put("em", 150465);
    freq.put("el", 150281);
    freq.put("eo", 16834);
    freq.put("en", 264211);
    freq.put("ei", 21799);
    freq.put("ek", 109837);
    freq.put("ej", 291522);
    freq.put("ee", 8458);
    freq.put("ed", 135395);
    freq.put("eg", 232853);
    freq.put("ef", 12705);
    freq.put("ea", 22981);
    freq.put("ec", 208980);
    freq.put("eb", 20189);
    freq.put("ey", 6513);
    freq.put("ez", 85170);
    freq.put("eu", 15671);
    freq.put("et", 92062);
    freq.put("ew", 111327);
    freq.put("ev", 5608);
    freq.put("ep", 45340);
    freq.put("es", 172911);
    freq.put("er", 319668);
    freq.put("ejm", 7156);
    freq.put("ejo", 11481);
    freq.put("mo\u0301w", 5303);
    freq.put("eje", 7376);
    freq.put("z\u0307sz", 5421);
    freq.put("bli", 16339);
    freq.put("os ", 8863);
    freq.put("ejs", 51321);
    freq.put("nic", 58316);
    freq.put("orz", 34348);
    freq.put("G", 97533);
    freq.put("ory", 13310);
    freq.put("ort", 15205);
    freq.put("oru", 7711);
    freq.put("rla", 5043);
    freq.put("e ", 876959);
    freq.put("orn", 6157);
    freq.put("oro", 17951);
    freq.put("orm", 16889);
    freq.put("ork", 4605);
    freq.put("ori", 12364);
    freq.put("org", 11803);
    freq.put("ord", 8495);
    freq.put("ore", 9264);
    freq.put("orc", 4621);
    freq.put("ora", 31522);
    freq.put("ej ", 196844);
    freq.put("zan", 18287);
    freq.put("onk", 6206);
    freq.put("zal", 7485);
    freq.put("oni", 52759);
    freq.put("onn", 4626);
    freq.put("ie\u0328 ", 65182);
    freq.put("ona", 86386);
    freq.put("zac", 28997);
    freq.put("ond", 4877);
    freq.put("one", 29526);
    freq.put("ony", 38958);
    freq.put("\u0142no", 15191);
    freq.put("ano\u0301", 4796);
    freq.put("ons", 8848);
    freq.put("zar", 15092);
    freq.put("zas", 21035);
    freq.put("ont", 10876);
    freq.put("Eur", 7453);
    freq.put("iam", 4548);
    freq.put("ial", 8076);
    freq.put("ian", 22005);
    freq.put("iaj", 4940);
    freq.put("iad", 9916);
    freq.put("iac", 9488);
    freq.put("uko", 7594);
    freq.put("iaz", 7546);
    freq.put("iat", 20282);
    freq.put("ias", 25407);
    freq.put("iar", 9378);
    freq.put("ie\u0328d", 13216);
    freq.put("ie\u0328c", 10576);
    freq.put("x ", 7519);
    freq.put(" Za", 17851);
    freq.put("ie\u0328k", 9725);
    freq.put("ebi", 5142);
    freq.put("e\u0328ks", 6674);
    freq.put("ie\u0328t", 12440);
    freq.put("s\u0301c\u0301", 40444);
    freq.put("rze", 166268);
    freq.put("wat", 12396);
    freq.put("rzc", 6541);
    freq.put("rza", 14480);
    freq.put("rzo", 14189);
    freq.put("ia ", 151774);
    freq.put("war", 32065);
    freq.put("r", 2204575);
    freq.put("nos\u0301", 21837);
    freq.put("lni", 16273);
    freq.put("rzy", 76075);
    freq.put("and", 28542);
    freq.put("ane", 52267);
    freq.put("ang", 21057);
    freq.put("pra", 25179);
    freq.put("ana", 52659);
    freq.put("c\u0301", 60605);
    freq.put("anc", 30280);
    freq.put("ann", 5995);
    freq.put("ano", 19191);
    freq.put("ani", 105534);
    freq.put("ank", 9718);
    freq.put("ant", 15544);
    freq.put("ez\u0307", 40953);
    freq.put("wna", 7537);
    freq.put("ry ", 30832);
    freq.put("ans", 10106);
    freq.put("sar", 4951);
    freq.put("any", 57351);
    freq.put("prz", 116916);
    freq.put("Do", 17200);
    freq.put("Di", 5692);
    freq.put("en\u0301", 19329);
    freq.put("De", 9899);
    freq.put("zon", 31868);
    freq.put("Da", 8795);
    freq.put("wca", 6919);
    freq.put("zos", 17618);
    freq.put("\u0435", 5223);
    freq.put("es\u0301", 75573);
    freq.put("zow", 26765);
    freq.put("wch", 7307);
    freq.put("Du", 4576);
    freq.put("Dr", 5145);
    freq.put("iwe", 4858);
    freq.put("wni", 31749);
    freq.put("Wys", 5223);
    freq.put("eja\u0328", 6188);
    freq.put("sa ", 26422);
    freq.put("iwi", 4661);
    freq.put(" Le", 13833);
    freq.put(" La", 13845);
    freq.put(" Lo", 10195);
    freq.put(" Li", 15290);
    freq.put(" Lu", 9428);
    freq.put("tka", 9207);
    freq.put("tko", 7816);
    freq.put("tki", 10465);
    freq.put("s\u0301ni", 16799);
    freq.put("dy ", 20176);
    freq.put("We", 8452);
    freq.put("Wa", 16039);
    freq.put("Wo", 12341);
    freq.put("lub", 38824);
    freq.put("Wi", 28290);
    freq.put("\u0430", 9102);
    freq.put("Ws", 4692);
    freq.put("po\u0142", 82723);
    freq.put("Wy", 14854);
    freq.put(" pr", 169964);
    freq.put("ko\u0142", 12944);
    freq.put(" pu", 7297);
    freq.put("H", 50582);
    freq.put("dys", 5848);
    freq.put(" pa", 50520);
    freq.put("go\u0301r", 7545);
    freq.put(" pe", 8239);
    freq.put(" pi", 36353);
    freq.put(" po", 329900);
    freq.put("gen", 12957);
    freq.put(" pl", 22703);
    freq.put("W ", 15791);
    freq.put("z\u0301dz", 4969);
    freq.put("o\u0301", 396123);
    freq.put("die", 6315);
    freq.put("ez\u0307a\u0328", 8181);
    freq.put("lny", 18798);
    freq.put("cin", 7038);
    freq.put("lno", 13692);
    freq.put("rma", 13967);
    freq.put("pan\u0301", 7582);
    freq.put("lne", 15681);
    freq.put("uja\u0328", 40031);
    freq.put("rmi", 12636);
    freq.put("j ", 229252);
    freq.put("yty", 7484);
    freq.put("ytu", 9487);
    freq.put("yto", 6663);
    freq.put("ciw", 5743);
    freq.put("yte", 4862);
    freq.put("yta", 5297);
    freq.put(" po\u0301", 15190);
    freq.put("\u0142oz\u0307", 68106);
    freq.put("ciu", 5042);
    freq.put("ju", 20103);
    freq.put("tur", 19565);
    freq.put("jw", 6916);
    freq.put("js", 79998);
    freq.put("jm", 12943);
    freq.put("jn", 43747);
    freq.put("jo", 26898);
    freq.put("ji", 76024);
    freq.put("tun", 9184);
    freq.put("jd", 20070);
    freq.put("je", 192771);
    freq.put("Kra", 7526);
    freq.put("ja", 94283);
    freq.put("jc", 7619);
    freq.put(" be", 7689);
    freq.put("\u0142os\u0301", 19952);
    freq.put(" ba", 14299);
    freq.put(" bo", 7340);
    freq.put(" bi", 14788);
    freq.put("P ", 7412);
    freq.put(" bu", 7038);
    freq.put("s", 1819258);
    freq.put("usz", 14475);
    freq.put(" br", 13094);
    freq.put("dko", 7298);
    freq.put(" by", 20334);
    freq.put("ez\u0307y", 7778);
    freq.put("poz", 13437);
    freq.put("pow", 94565);
    freq.put("pot", 7235);
    freq.put("por", 15922);
    freq.put("pos", 20600);
    freq.put("pop", 9036);
    freq.put("pon", 6930);
    freq.put("pol", 56274);
    freq.put("pom", 22714);
    freq.put("poj", 4594);
    freq.put("pok", 5372);
    freq.put("pod", 44935);
    freq.put("poc", 15903);
    freq.put("fic", 8573);
    freq.put("wsz", 18473);
    freq.put("zpo", 4827);
    freq.put("s\u0301ro", 7633);
    freq.put("ala", 17506);
    freq.put("s\u0301re", 20628);
    freq.put("ez\u0307 ", 13347);
    freq.put("po ", 9878);
    freq.put("wrz", 6674);
    freq.put(" p\u0142", 9284);
    freq.put("e\u0328dz", 16930);
    freq.put("e\u0328du", 4976);
    freq.put("ein", 6239);
    freq.put("nny", 11159);
    freq.put("gwi", 7275);
    freq.put("ac\u0301 ", 7866);
    freq.put("ja\u0328c", 92228);
    freq.put("rwc", 4554);
    freq.put("\u0142o ", 21533);
    freq.put("Bar", 4693);
    freq.put(" Me", 12575);
    freq.put("par", 31402);
    freq.put("pas", 19500);
    freq.put(" Ma", 41192);
    freq.put(" Mo", 18451);
    freq.put(" Mi", 29080);
    freq.put(" Mu", 5268);
    freq.put("pac", 4930);
    freq.put("pad", 8610);
    freq.put("ja\u0328", 114675);
    freq.put("pal", 4646);
    freq.put("ykl", 4610);
    freq.put("pan", 7407);
    freq.put("cel", 7686);
    freq.put("A ", 12056);
    freq.put("I", 84977);
    freq.put("\u0142os", 9246);
    freq.put("\u0142ow", 21447);
    freq.put("II", 18254);
    freq.put("ja\u0328 ", 20069);
    freq.put("gru", 20718);
    freq.put("\u0142on", 8256);
    freq.put("rwo", 5268);
    freq.put("\u0142od", 6015);
    freq.put("lki", 9010);
    freq.put("js\u0301", 4511);
    freq.put("\u0142on\u0301", 16090);
    freq.put("pa ", 7030);
    freq.put("rws", 10740);
    freq.put("In", 12447);
    freq.put("uje", 18646);
    freq.put("uja", 4953);
    freq.put("i\u0142k", 7468);
    freq.put("am ", 8178);
    freq.put("o\u0301b ", 4595);
    freq.put("nam", 4778);
    freq.put("cez", 4969);
    freq.put("oko", 19282);
    freq.put("ami", 37349);
    freq.put("amo", 13297);
    freq.put("zwi", 19757);
    freq.put("ama", 9031);
    freq.put("mor", 22691);
    freq.put("gra", 31694);
    freq.put("ame", 32849);
    freq.put("mon", 7419);
    freq.put("gro", 9171);
    freq.put("moc", 8677);
    freq.put("amp", 4556);
    freq.put(" S\u0301w", 8979);
    freq.put("mod", 4841);
    freq.put("d\u0142u", 9193);
    freq.put("Pie", 5284);
    freq.put("t", 1619824);
    freq.put("oz\u0307o", 65228);
    freq.put("uto", 11126);
    freq.put("ezi", 7185);
    freq.put("ezj", 6360);
    freq.put("eze", 8964);
    freq.put("az\u0301", 5844);
    freq.put("az\u0307", 13250);
    freq.put("yd", 32633);
    freq.put(" ch", 18489);
    freq.put("ac ", 5802);
    freq.put("an\u0301", 46393);
    freq.put(" ca", 5242);
    freq.put("n\u0301c", 31072);
    freq.put(" ce", 14033);
    freq.put(" cz", 55270);
    freq.put(" cy", 4833);
    freq.put("as\u0301", 6694);
    freq.put("rpn", 4743);
    freq.put("n\u0301s", 75332);
    freq.put("ez ", 38609);
    freq.put("oo", 8474);
    freq.put("on", 318937);
    freq.put("om", 108472);
    freq.put("ol", 232069);
    freq.put("ok", 137945);
    freq.put("oj", 102542);
    freq.put("oi", 39360);
    freq.put("oh", 7680);
    freq.put("ack", 10335);
    freq.put("acj", 42190);
    freq.put("aci", 10932);
    freq.put("ach", 91172);
    freq.put("oc", 101234);
    freq.put("ob", 82692);
    freq.put("oa", 8273);
    freq.put("wo\u0301r", 6020);
    freq.put("odc", 6738);
    freq.put("oz", 62053);
    freq.put("ow", 537395);
    freq.put("acz", 24570);
    freq.put("acy", 17521);
    freq.put("ot", 70221);
    freq.put("os", 163642);
    freq.put("or", 254276);
    freq.put("op", 86592);
    freq.put("Ni", 19737);
    freq.put("ju ", 15477);
    freq.put("No", 17077);
    freq.put("Na", 24418);
    freq.put("Ne", 7072);
    freq.put("log", 15244);
    freq.put("her", 6722);
    freq.put("lok", 4711);
    freq.put("lon", 16670);
    freq.put("NG", 5663);
    freq.put("low", 11925);
    freq.put("lot", 5895);
    freq.put("moz\u0307", 6857);
    freq.put("J", 54373);
    freq.put(" ak", 7205);
    freq.put("uli", 7259);
    freq.put("k\u0142a", 22407);
    freq.put("as ", 15649);
    freq.put("he ", 11732);
    freq.put("s\u0301ci", 91962);
    freq.put("ac", 219676);
    freq.put("ab", 34080);
    freq.put("ae", 10185);
    freq.put("ad", 149992);
    freq.put("ag", 38473);
    freq.put("af", 22452);
    freq.put("ai", 24623);
    freq.put("ah", 5887);
    freq.put("ak", 99776);
    freq.put("aj", 148717);
    freq.put("am", 123297);
    freq.put("al", 185695);
    freq.put("an", 453452);
    freq.put("ap", 33608);
    freq.put("as", 161357);
    freq.put("ar", 314898);
    freq.put("au", 36829);
    freq.put("at", 193861);
    freq.put("aw", 119971);
    freq.put("av", 7852);
    freq.put("ay", 6838);
    freq.put("az", 93181);
    freq.put("z\u0307a\u0328c", 10258);
    freq.put("rt", 71318);
    freq.put("po\u0301l", 4883);
    freq.put("GC ", 12479);
    freq.put("je\u0328", 19551);
    freq.put("on\u0301", 26624);
    freq.put("o\u0142", 121062);
    freq.put(" zn", 26389);
    freq.put("os\u0301", 108251);
    freq.put(" zi", 4717);
    freq.put("rr", 8977);
    freq.put("oz\u0307", 86148);
    freq.put("u", 1069834);
    freq.put("god", 4635);
    freq.put("Bra", 4520);
    freq.put(" s\u0301r", 24528);
    freq.put("alo", 8151);
    freq.put("all", 6281);
    freq.put(" s\u0301w", 19258);
    freq.put("os\u0301c\u0301", 33539);
    freq.put("ali", 35299);
    freq.put("sce", 55140);
    freq.put("iu ", 24955);
    freq.put("ale", 28164);
    freq.put("alb", 10365);
    freq.put("ry", 128901);
    freq.put("mni", 5567);
    freq.put("eda", 5582);
    freq.put("ajw", 6681);
    freq.put("gr", 81461);
    freq.put("zmi", 5909);
    freq.put("tz", 6072);
    freq.put("ty", 157784);
    freq.put("tw", 127984);
    freq.put("tt", 12443);
    freq.put("tu", 85903);
    freq.put("tr", 134088);
    freq.put("ts", 8380);
    freq.put("tn", 41685);
    freq.put("to", 228890);
    freq.put("tl", 10672);
    freq.put("tk", 33051);
    freq.put("th", 19993);
    freq.put("ti", 40445);
    freq.put("\u0438", 6265);
    freq.put("tu ", 25361);
    freq.put("te", 190777);
    freq.put("z\u0307yn", 4577);
    freq.put("ta", 271329);
    freq.put("ium", 6118);
    freq.put(" ro\u0301", 17486);
    freq.put("edn", 51333);
    freq.put("rc", 41834);
    freq.put(" NG", 5574);
    freq.put("ost", 51897);
    freq.put("edl", 5574);
    freq.put("rm", 40806);
    freq.put("ius", 4598);
    freq.put("rn", 56890);
    freq.put(" Ni", 19681);
    freq.put("pre", 13822);
    freq.put("ro", 332963);
    freq.put(" No", 17025);
    freq.put("eds", 6095);
    freq.put(" Na", 24184);
    freq.put("zm ", 5171);
    freq.put(" Ne", 6981);
    freq.put("ge", 34328);
    freq.put("ri", 79907);
    freq.put("wsp", 8605);
    freq.put("z\u0307yw", 6989);
    freq.put("wst", 10921);
    freq.put("S\u0142", 20200);
    freq.put("gor", 5388);
    freq.put("t ", 152714);
    freq.put("tej", 7771);
    freq.put("tek", 9091);
    freq.put("tel", 10074);
    freq.put("ga", 71454);
    freq.put("ten", 10208);
    freq.put("tec", 7568);
    freq.put("teg", 14724);
    freq.put("go", 201815);
    freq.put(" r ", 7257);
    freq.put("ter", 68917);
    freq.put("o\u0301wk", 5666);
    freq.put("edy", 9486);
    freq.put("o\u0301wn", 37744);
    freq.put("abi", 5944);
    freq.put("to\u0301", 52700);
    freq.put("abs", 7005);
    freq.put("zo\u0301", 6325);
    freq.put(" ru", 4802);
    freq.put("lko", 12509);
    freq.put("te ", 12262);
    freq.put("K", 109538);
    freq.put(" ry", 6135);
    freq.put(" rz", 19343);
    freq.put(" re", 46718);
    freq.put(" ra", 15542);
    freq.put("pub", 6917);
    freq.put("eg\u0142", 18236);
    freq.put(" ro", 89060);
    freq.put("su ", 8612);
    freq.put("oma", 14351);
    freq.put("o\u0301w ", 112668);
    freq.put(" wi", 85470);
    freq.put(" Ar", 11761);
    freq.put("nto", 7930);
    freq.put("put", 4642);
    freq.put("rka", 6181);
    freq.put("S ", 11205);
    freq.put("rki", 6506);
    freq.put("twa", 27679);
    freq.put("twi", 61091);
    freq.put("two", 26167);
    freq.put("de ", 15481);
    freq.put("Sz", 17267);
    freq.put("Sy", 6237);
    freq.put("te\u0328", 19569);
    freq.put("Sp", 7038);
    freq.put("Su", 6926);
    freq.put("St", 34755);
    freq.put("Sk", 5337);
    freq.put("z\u0307on", 68291);
    freq.put("Si", 11311);
    freq.put("So", 10398);
    freq.put("Sc", 7388);
    freq.put("Sa", 22530);
    freq.put("ta\u0328", 4964);
    freq.put("Se", 13365);
    freq.put("a\u0301", 5335);
    freq.put(" dn", 7531);
    freq.put("os\u0301c", 57589);
    freq.put(" dl", 8990);
    freq.put("kla", 7237);
    freq.put(" di", 6649);
    freq.put("dep", 15043);
    freq.put(" de", 38500);
    freq.put("os\u0301l", 6671);
    freq.put(" da", 17665);
    freq.put("klu", 5529);
    freq.put("dek", 8141);
    freq.put("del", 4853);
    freq.put(" dz", 27524);
    freq.put(" dy", 8440);
    freq.put("v", 42704);
    freq.put("jdu", 17294);
    freq.put(" du", 6950);
    freq.put(" dr", 18598);
    freq.put("atk", 6138);
    freq.put("f ", 12810);
    freq.put("co\u0301", 12082);
    freq.put("ati", 9455);
    freq.put("ryn", 5422);
    freq.put("zny", 34365);
    freq.put("rym", 6312);
    freq.put("PGC", 4549);
    freq.put("ryb", 4752);
    freq.put("ryc", 13818);
    freq.put("two\u0301", 5271);
    freq.put("yzn", 5243);
    freq.put("r ", 119247);
    freq.put("ryt", 14172);
    freq.put("a\u0328z\u0307a", 15191);
    freq.put("rys", 7800);
    freq.put("fr", 12808);
    freq.put("fu", 7503);
    freq.put("Dol", 5831);
    freq.put("fa", 15386);
    freq.put("fe", 16025);
    freq.put("fi", 50271);
    freq.put("fo", 23920);
    freq.put("a", 3833729);
    freq.put("e\u0328zy", 9477);
    freq.put("egu", 4666);
    freq.put("egi", 24719);
    freq.put("ego", 161252);
    freq.put("o\u0308", 4590);
    freq.put("ega", 9608);
    freq.put("ito", 6446);
    freq.put("ce ", 116313);
    freq.put("y ", 457874);
    freq.put("ite", 12873);
    freq.put("ita", 8740);
    freq.put("ok ", 8415);
    freq.put("kos\u0301", 9426);
    freq.put("ity", 14838);
    freq.put("ste\u0328", 16122);
    freq.put(" Ol", 5468);
    freq.put(" Od", 7369);
    freq.put(" Ob", 6845);
    freq.put("pca", 4745);
    freq.put(" Or", 5834);
    freq.put(" Os", 6455);
    freq.put("ceg", 6128);
    freq.put("rwa", 7707);
    freq.put("yk", 74193);
    freq.put("yj", 45803);
    freq.put("ym", 103256);
    freq.put("yl", 20573);
    freq.put("yn", 66941);
    freq.put("cen", 13171);
    freq.put("yc", 219665);
    freq.put("yb", 20679);
    freq.put("L", 74803);
    freq.put("yg", 10175);
    freq.put("yf", 6219);
    freq.put("oka", 12522);
    freq.put("kz\u0307e", 7372);
    freq.put("yz", 12669);
    freq.put("ces", 6923);
    freq.put("cer", 7119);
    freq.put("I ", 22055);
    freq.put("oki", 5566);
    freq.put("yp", 20913);
    freq.put("ys", 92766);
    freq.put("yr", 14041);
    freq.put("yt", 47612);
    freq.put("yw", 52492);
    freq.put("Rad", 5296);
    freq.put("yno", 4822);
    freq.put("yni", 13954);
    freq.put("yna", 17425);
    freq.put("man", 12874);
    freq.put("c\u0301 ", 59245);
    freq.put(" sz", 26144);
    freq.put(" sy", 14406);
    freq.put("ka\u0328", 16568);
    freq.put("NGC", 5540);
    freq.put(" sp", 31645);
    freq.put("pu ", 5270);
    freq.put(" sw", 5466);
    freq.put(" st", 72132);
    freq.put(" su", 7093);
    freq.put(" sk", 26716);
    freq.put(" si", 84234);
    freq.put("o\u0301d ", 10612);
    freq.put(" so", 11139);
    freq.put("ke\u0328", 4736);
    freq.put(" sa", 14213);
    freq.put(" se", 14117);
    freq.put("iza", 9287);
    freq.put("o\u0301j", 5872);
    freq.put("izm", 4986);
    freq.put("izo", 6649);
    freq.put("trz", 32044);
    freq.put("izy", 4891);
    freq.put("o\u0301dz", 62547);
    freq.put("k\u0142", 24507);
    freq.put("oid", 31094);
    freq.put("puj", 8407);
    freq.put("ast", 57235);
    freq.put("asz", 13814);
    freq.put("asy", 6947);
    freq.put(" Al", 15025);
    freq.put(" Am", 7370);
    freq.put(" An", 13699);
    freq.put("asa", 22529);
    freq.put(" Au", 8090);
    freq.put("ask", 9308);
    freq.put("Uni", 6296);
    freq.put("asi", 8550);
    freq.put("aso", 5103);
    freq.put("kol", 18048);
    freq.put("zji", 8382);
    freq.put("kan\u0301", 16086);
    freq.put("tru", 11588);
    freq.put("zja", 5084);
    freq.put("w", 2322567);
    freq.put("Eu", 8774);
    freq.put("kz\u0307", 7374);
    freq.put("le ", 27634);
    freq.put("Fra", 21145);
    freq.put("ody", 9005);
    freq.put("odz", 61637);
    freq.put(" el", 9782);
    freq.put("jes", 38109);
    freq.put("kok", 4910);
    freq.put("kom", 18077);
    freq.put("jew", 58578);
    freq.put("kon", 28370);
    freq.put("X ", 6678);
    freq.put("odp", 5300);
    freq.put("jeg", 6331);
    freq.put("jed", 34575);
    freq.put("a\u0328zk", 9275);
    freq.put("jej", 4751);
    freq.put("kop", 10012);
    freq.put("kos", 4831);
    freq.put("\u043a", 5011);
    freq.put("jen", 6642);
    freq.put("a\u0328za", 4528);
    freq.put("kow", 64383);
    freq.put("omu", 5636);
    freq.put("ods", 5690);
    freq.put("odu", 13447);
    freq.put("nci", 16716);
    freq.put("ncj", 34860);
    freq.put("yz\u0307", 9849);
    freq.put("toc", 7538);
    freq.put("co\u0301w", 11188);
    freq.put("ste", 40839);
    freq.put("b", 467514);
    freq.put("sta", 110434);
    freq.put("ko ", 39683);
    freq.put("stn", 10874);
    freq.put("y\u0142", 33312);
    freq.put("yn\u0301", 8163);
    freq.put("stk", 11925);
    freq.put("ko\u0301", 27850);
    freq.put("stu", 7827);
    freq.put("ys\u0301", 4897);
    freq.put("stw", 35135);
    freq.put("str", 55283);
    freq.put("sty", 30683);
    freq.put("ka ", 110422);
    freq.put("zyk", 17972);
    freq.put("oda", 13640);
    freq.put("s\u0301wi", 21339);
    freq.put("k ", 111343);
    freq.put("lia", 7515);
    freq.put("lic", 38891);
    freq.put("udn", 21514);
    freq.put("lim", 6337);
    freq.put("lin", 28801);
    freq.put("lii", 5868);
    freq.put("Nie", 14925);
    freq.put("lit", 23937);
    freq.put("liw", 7216);
    freq.put("lip", 7716);
    freq.put("lis", 17192);
    freq.put(" s\u0142", 12543);
    freq.put("liz", 9545);
    freq.put("wyb", 6431);
    freq.put("kac", 12564);
    freq.put("jsc", 28565);
    freq.put("M", 131493);
    freq.put("kan", 15572);
    freq.put("kam", 6459);
    freq.put("jsk", 40065);
    freq.put("kar", 21380);
    freq.put("kat", 10533);
    freq.put("kaz", 5339);
    freq.put("The", 5470);
    freq.put("wym", 21711);
    freq.put("jsz", 8170);
    freq.put("kc", 19574);
    freq.put("ka", 229229);
    freq.put("li ", 18475);
    freq.put("ke", 10550);
    freq.put("ki", 412466);
    freq.put("nan", 15192);
    freq.put("ko", 241820);
    freq.put("km", 9933);
    freq.put("kl", 22672);
    freq.put("ks", 37081);
    freq.put("kr", 97482);
    freq.put("kw", 12402);
    freq.put("ku", 103176);
    freq.put("kt", 82034);
    freq.put("yn ", 8183);
    freq.put("on\u0301c", 21153);
    freq.put(" sa\u0328", 8630);
    freq.put("rte", 6255);
    freq.put("ugi", 6634);
    freq.put("rta", 19705);
    freq.put("ojs", 6215);
    freq.put("rto", 10205);
    freq.put("rti", 6031);
    freq.put("p\u0142", 15785);
    freq.put("oje", 68149);
    freq.put("p\u0142y", 9060);
    freq.put("ojn", 8775);
    freq.put("rty", 7882);
    freq.put("yms", 4916);
    freq.put("ies", 27602);
    freq.put("ier", 72550);
    freq.put("iet", 14221);
    freq.put("iew", 12649);
    freq.put("nce", 9629);
    freq.put("iek", 15875);
    freq.put("Jo", 8139);
    freq.put("iem", 53337);
    freq.put("iel", 59211);
    freq.put("ien", 34053);
    freq.put("ymi", 14584);
    freq.put("Je", 18291);
    freq.put("iec", 108952);
    freq.put("Ja", 16186);
    freq.put("ieg", 53169);
    freq.put("iko\u0301", 5855);
    freq.put("his", 8897);
    freq.put("rt ", 8136);
    freq.put("ym ", 69059);
    freq.put("x", 13069);
    freq.put("zur", 6895);
    freq.put(" Be", 12343);
    freq.put("ars", 25559);
    freq.put("art", 41017);
    freq.put("aru", 4729);
    freq.put("ary", 12822);
    freq.put("arz", 32133);
    freq.put(" Bi", 14133);
    freq.put("sti", 7248);
    freq.put(" Bu", 9050);
    freq.put("ara", 29532);
    freq.put("arc", 24556);
    freq.put("ard", 17168);
    freq.put("are", 9332);
    freq.put(" Br", 16331);
    freq.put("ari", 18485);
    freq.put("ark", 13034);
    freq.put("arl", 5792);
    freq.put("arm", 8931);
    freq.put("arn", 16904);
    freq.put("aro", 21478);
    freq.put("zko", 15029);
    freq.put("zki", 16987);
    freq.put("wow", 8334);
    freq.put("al ", 15001);
    freq.put("je ", 30364);
    freq.put("wor", 17209);
    freq.put("wol", 5953);
    freq.put("woj", 77026);
    freq.put("wod", 23078);
    freq.put("lej", 10577);
    freq.put("ar ", 9731);
    freq.put("ika", 22144);
    freq.put(" PG", 4658);
    freq.put("se ", 4707);
    freq.put("iki", 9122);
    freq.put("yda", 15003);
    freq.put("iko", 7564);
    freq.put(" Pr", 25548);
    freq.put("c", 1792078);
    freq.put(" Pu", 5949);
    freq.put("wed", 4775);
    freq.put("zka", 12896);
    freq.put(" Pa", 33893);
    freq.put(" Pe", 7708);
    freq.put(" Pi", 15394);
    freq.put(" Po", 99137);
    freq.put("wo ", 32774);
    freq.put("ies\u0301", 51901);
    freq.put("lbu", 8442);
    freq.put("War", 8050);
    freq.put("opi", 9321);
    freq.put("ga ", 14947);
    freq.put("pr", 207712);
    freq.put("ps", 10578);
    freq.put("duj", 19180);
    freq.put("duk", 7030);
    freq.put("iez\u0307", 14661);
    freq.put("pt", 9892);
    freq.put("pu", 38310);
    freq.put("py", 18332);
    freq.put("pc", 8415);
    freq.put("pa", 107114);
    freq.put("nau", 6824);
    freq.put("pe", 42396);
    freq.put("ewo\u0301", 56727);
    freq.put("ph", 5594);
    freq.put("pi", 86460);
    freq.put("pn", 11150);
    freq.put("n\u0301co\u0301", 5655);
    freq.put("pl", 33619);
    freq.put(" ty", 20926);
    freq.put(" tw", 5981);
    freq.put("ty ", 25638);
    freq.put(" tu", 7399);
    freq.put("gat", 9377);
    freq.put(" tr", 22707);
    freq.put("N", 86269);
    freq.put(" to", 40581);
    freq.put("gan", 14815);
    freq.put("gal", 8113);
    freq.put("gaj", 4881);
    freq.put(" th", 4944);
    freq.put(" te", 42334);
    freq.put(" ta", 20050);
    freq.put("du ", 16409);
    freq.put("czy", 47263);
    freq.put("p ", 18753);
    freq.put("fun", 4925);
    freq.put("z\u0301n", 6441);
    freq.put("sy ", 5848);
    freq.put("wos\u0301", 26886);
    freq.put("z\u0301d", 5042);
    freq.put("ba\u0328 ", 6293);
    freq.put("riu", 5278);
    freq.put("a\u0328gu", 15768);
    freq.put("rin", 4886);
    freq.put("rii", 14143);
    freq.put("rie", 5586);
    freq.put("ric", 4906);
    freq.put("ria", 19003);
    freq.put("po\u0301", 31075);
    freq.put("ewi", 12221);
    freq.put("ewo", 9270);
    freq.put("ewn", 8260);
    freq.put("ewa", 5038);
    freq.put("n\u0301ce", 15534);
    freq.put("n\u0301cz", 4853);
    freq.put("ews", 7573);
    freq.put("gw", 10035);
    freq.put("mow", 13205);
    freq.put("syn", 5333);
    freq.put("sys", 6083);
    freq.put(" fr", 6875);
    freq.put(" fu", 5153);
    freq.put("ew ", 5885);
    freq.put("kle", 4640);
    freq.put(" fa", 6215);
    freq.put(" fi", 17828);
    freq.put(" fo", 9292);
    freq.put(" uz\u0307", 7103);
    freq.put("cia\u0328", 23459);
    freq.put("O ", 4778);
    freq.put("lik", 8729);
    freq.put("cus", 4654);
    freq.put("wia", 38637);
    freq.put("\u043e", 7740);
    freq.put("win", 12633);
    freq.put("rgi", 6819);
    freq.put("bio", 14193);
    freq.put("Ol", 5489);
    freq.put("a\u0142e", 8027);
    freq.put("bie", 21077);
    freq.put("Ob", 6870);
    freq.put("bia", 7547);
    freq.put("bo\u0301", 4844);
    freq.put("a\u0142y", 11839);
    freq.put("Os", 6465);
    freq.put("Or", 5855);
    freq.put("u\u0142", 11203);
    freq.put("uz\u0307", 24054);
    freq.put("d", 1304112);
    freq.put("rg ", 8389);
    freq.put("oz\u0307y", 4895);
    freq.put("z\u0301", 20372);
    freq.put("ii ", 57658);
    freq.put("ijs", 6419);
    freq.put("b ", 46793);
    freq.put("ru ", 8305);
    freq.put("ld ", 4729);
    freq.put(" g\u0142", 25015);
    freq.put("z\u0307yc", 6860);
    freq.put("cej", 5254);
    freq.put("\u0142ka", 8122);
    freq.put("kad", 5909);
    freq.put("per", 13425);
    freq.put("wiz", 5342);
    freq.put("pej", 4544);
    freq.put("tni", 28308);
    freq.put("id ", 16421);
    freq.put("pec", 4830);
    freq.put("be", 48450);
    freq.put("run", 6993);
    freq.put("ba", 43868);
    freq.put("rum", 5890);
    freq.put("bl", 23444);
    freq.put("ruc", 5354);
    freq.put("bn", 8407);
    freq.put("bo", 39861);
    freq.put("bi", 69531);
    freq.put("O", 63924);
    freq.put("bu", 41705);
    freq.put("br", 47012);
    freq.put("bs", 19604);
    freq.put("rus", 7391);
    freq.put("rup", 16289);
    freq.put("kal", 9168);
    freq.put("by", 41730);
    freq.put("Ros", 4617);
    freq.put("ida", 21189);
    freq.put(" ut", 8073);
    freq.put(" ur", 32556);
    freq.put(" us", 6046);
    freq.put(" ul", 5488);
    freq.put(" uk", 7357);
    freq.put("nst", 10393);
    freq.put("ci ", 63750);
    freq.put("zie", 58529);
    freq.put("u ", 285894);
    freq.put("g\u0142", 47489);
    freq.put(" Ch", 21239);
    freq.put(" Ci", 4561);
    freq.put(" Co", 11557);
    freq.put("wne", 21421);
    freq.put("ns ", 4556);
    freq.put("lka", 5102);
    freq.put(" Ca", 12220);
    freq.put("wno", 4837);
    freq.put(" Ce", 7873);
    freq.put(" Cz", 10255);
    freq.put("zin", 14757);
    freq.put(" s\u0301", 51887);
    freq.put("wny", 9160);
    freq.put("cia", 18501);
    freq.put("os\u0142", 6618);
    freq.put("cie", 119729);
    freq.put("uz", 15301);
    freq.put("ut", 47463);
    freq.put("uw", 4835);
    freq.put("cio", 9246);
    freq.put("up", 30095);
    freq.put("us", 71220);
    freq.put("ur", 117881);
    freq.put("um", 45758);
    freq.put("ul", 35319);
    freq.put("un", 53367);
    freq.put("ui", 5984);
    freq.put("utw", 6376);
    freq.put("uk", 36207);
    freq.put("uj", 65669);
    freq.put("ue", 10441);
    freq.put("ud", 56663);
    freq.put("ug", 25222);
    freq.put("z", 1828688);
    freq.put("ua", 10045);
    freq.put("go\u0301l", 4564);
    freq.put("uc", 35683);
    freq.put("ub", 63557);
    freq.put(" \u0142a", 6906);
    freq.put("Tu", 5606);
    freq.put("Tr", 10180);
    freq.put("To", 9177);
    freq.put("Th", 7956);
    freq.put("Te", 9915);
    freq.put("Ta", 10132);
    freq.put(" gw", 7366);
    freq.put("Mar", 15306);
    freq.put(" gr", 42165);
    freq.put("nag", 7300);
    freq.put("nad", 18221);
    freq.put("naj", 37748);
    freq.put("nak", 5404);
    freq.put("grz", 5388);
    freq.put("nal", 20391);
    freq.put("gry", 6845);
    freq.put("nar", 14632);
    freq.put("nas", 8986);
    freq.put("nap", 5117);
    freq.put(" ge", 6292);
    freq.put("naw", 6217);
    freq.put("nat", 12135);
    freq.put(" ga", 16786);
    freq.put("naz", 14802);
    freq.put(" go", 8008);
    freq.put(" gm", 81906);
    freq.put("be\u0328", 5925);
    freq.put("a\u0142", 115023);
    freq.put(" co", 7528);
    freq.put("ago", 6833);
    freq.put("na ", 315412);
    freq.put("e", 3541226);
    freq.put("Am", 7571);
    freq.put("Al", 15057);
    freq.put("aga", 5833);
    freq.put("An", 13752);
    freq.put("Ar", 11839);
    freq.put("Au", 8116);
    freq.put("nd ", 10560);
    freq.put("agr", 6880);
    freq.put(" b", 95754);
    freq.put(" c", 133679);
    freq.put("gu", 37274);
    freq.put(" a", 148427);
    freq.put(" f", 50076);
    freq.put(" g", 203060);
    freq.put(" d", 243257);
    freq.put(" e", 37159);
    freq.put(" j", 136928);
    freq.put(" k", 213385);
    freq.put(" h", 33638);
    freq.put(" i", 177645);
    freq.put(" n", 260999);
    freq.put(" o", 286725);
    freq.put(" l", 139321);
    freq.put(" m", 204189);
    freq.put(" r", 209751);
    freq.put(" s", 339763);
    freq.put(" p", 661390);
    freq.put("gd", 5266);
    freq.put(" w", 969288);
    freq.put(" t", 172994);
    freq.put(" u", 97002);
    freq.put(" z", 321847);
    freq.put("gn", 13137);
    freq.put("gm", 84581);
    freq.put("gl", 15240);
    freq.put("gi", 77017);
    freq.put("gh", 5124);
    freq.put(" B", 105665);
    freq.put(" C", 84648);
    freq.put(" A", 95983);
    freq.put(" F", 55238);
    freq.put(" G", 73890);
    freq.put(" D", 70098);
    freq.put(" E", 42554);
    freq.put(" J", 52915);
    freq.put(" K", 104698);
    freq.put(" H", 47495);
    freq.put(" I", 52640);
    freq.put(" N", 80062);
    freq.put(" O", 56243);
    freq.put(" L", 69035);
    freq.put(" M", 123296);
    freq.put(" R", 76715);
    freq.put(" S", 182443);
    freq.put(" P", 214389);
    freq.put(" V", 20154);
    freq.put(" W", 115231);
    freq.put(" T", 64394);
    freq.put(" U", 30651);
    freq.put(" Z", 55304);
    freq.put(" X", 11746);
    freq.put("Now", 7712);
    freq.put("Nor", 6043);
    freq.put("es\u0301 ", 42823);
    freq.put("ch ", 250098);
    freq.put("ed ", 7038);
    freq.put("z\u0307y ", 9032);
    freq.put("kcj", 11696);
    freq.put("P", 225853);
    freq.put("g ", 46202);
    freq.put("tri", 6420);
    freq.put("rtu", 4870);
    freq.put("wia\u0328", 20802);
    freq.put("zdo", 9053);
    freq.put("tro", 23044);
    freq.put("tra", 36373);
    freq.put("us ", 13666);
    freq.put("tre", 5469);
    freq.put("try", 9123);
    freq.put("es\u0301n", 12795);
    freq.put("es\u0301l", 8074);
    freq.put("esi", 11275);
    freq.put("es\u0301c", 9065);
    freq.put("wie\u0328", 20120);
    freq.put("zl", 6622);
    freq.put("zm", 18594);
    freq.put("zn", 149848);
    freq.put("zo", 93735);
    freq.put("go\u0301", 15509);
    freq.put("zi", 142936);
    freq.put("zj", 15781);
    freq.put("zk", 54785);
    freq.put("zd", 18869);
    freq.put("ze", 326759);
    freq.put("odr", 4605);
    freq.put("zg", 11821);
    freq.put("za", 220009);
    freq.put("zb", 26540);
    freq.put("zc", 34117);
    freq.put("odk", 11049);
    freq.put("odl", 22987);
    freq.put("zy", 216261);
    freq.put("odn", 35244);
    freq.put("odo", 21990);
    freq.put("zt", 75735);
    freq.put("zu", 31373);
    freq.put("odb", 6509);
    freq.put("zw", 54934);
    freq.put("zp", 13878);
    freq.put("ode", 8229);
    freq.put("zr", 6357);
    freq.put("ycz", 50193);
    freq.put("yck", 5423);
    freq.put("ycj", 6652);
    freq.put("yci", 10363);
    freq.put("ych", 133947);
    freq.put("rd ", 6953);
    freq.put("ta\u0142", 27215);
    freq.put("yce", 6751);
    freq.put("lec", 7985);
    freq.put("ozb", 6448);
    freq.put("leg", 25572);
    freq.put("ozn", 9119);
    freq.put("sie\u0328", 66198);
    freq.put("lek", 14961);
    freq.put("z ", 208589);
    freq.put("lem", 11032);
    freq.put("len", 14544);
    freq.put("ro\u0301z\u0307", 7313);
    freq.put("ozw", 5341);
    freq.put("ler", 6678);
    freq.put("les", 10216);
    freq.put("let", 6569);
    freq.put("sia\u0328", 6562);
    freq.put("lew", 7878);
    freq.put("od ", 47389);
    freq.put("ozy", 6621);
    freq.put("ctw", 8655);
    freq.put("gow", 8194);
    freq.put("rdz", 8372);
    freq.put("sa\u0328 ", 7387);
    freq.put("ze\u0328s\u0301", 17553);
    freq.put(" Do", 16986);
    freq.put("wie", 266248);
    freq.put("wid", 6688);
    freq.put("wic", 20177);
    freq.put(" Di", 5639);
    freq.put("zta", 5990);
    freq.put(" De", 9843);
    freq.put(" Da", 8706);
    freq.put("api", 8704);
    freq.put("wis", 10022);
    freq.put("apo", 6161);
    freq.put("w\u0142a", 9785);
    freq.put(" Z\u0307", 6158);
    freq.put(" Du", 4568);
    freq.put(" Dr", 5105);
    freq.put(" z\u0307", 19337);
    freq.put(" \u0142", 17467);
    freq.put("cha", 21398);
    freq.put("Fr", 25795);
    freq.put(" \u0141", 9064);
    freq.put("che", 16574);
    freq.put("chi", 12341);
    freq.put("usk", 8960);
    freq.put("chn", 12122);
    freq.put("cho", 63783);
    freq.put("chr", 6017);
    freq.put("iej", 135012);
    freq.put("zib", 8100);
    freq.put("Fe", 4746);
    freq.put("zia", 21275);
    freq.put(" S\u0301", 15346);
    freq.put("Fi", 6166);
    freq.put("spr", 6284);
    freq.put("Fo", 4852);
    freq.put("dza", 11866);
    freq.put("wi ", 5607);
    freq.put(" ob", 36134);
    freq.put("dze", 17343);
    freq.put("wo\u0301d", 59175);
    freq.put(" Ru", 5052);
    freq.put("ac\u0301", 8134);
    freq.put("f", 154643);
    freq.put("km ", 8293);
    freq.put(" Rz", 5260);
    freq.put(" Re", 17774);
    freq.put("og", 59938);
    freq.put(" Ra", 13288);
    freq.put("zi ", 13438);
    freq.put("of", 20662);
    freq.put(" Ro", 19091);
    freq.put("oe", 4808);
    freq.put("tat", 11340);
    freq.put("od", 293823);
    freq.put("tar", 27950);
    freq.put("\u0440", 5358);
    freq.put("n\u0301st", 9625);
    freq.put("tad", 4771);
    freq.put("n\u0301sk", 65260);
    freq.put("tac", 30341);
    freq.put("tal", 13415);
    freq.put("tam", 18213);
    freq.put("tan", 40782);
    freq.put("Mis", 5057);
    freq.put("tak", 16147);
    freq.put("ba\u0328", 7905);
    freq.put("afi", 15590);
    freq.put("po\u0301\u0142", 22236);
    freq.put("z\u0142", 13341);
    freq.put("spe", 6485);
    freq.put("sia", 7216);
    freq.put("cho\u0301", 9144);
    freq.put("sie", 37561);
    freq.put("sin", 6607);
    freq.put("dzt", 56173);
    freq.put("ro\u0301l", 5670);
    freq.put("ze\u0328d", 7177);
    freq.put("y", 1372315);
    freq.put("ro\u0301d", 6783);
    freq.put("dzy", 15488);
    freq.put("ta ", 47407);
    freq.put("ze\u0328s", 4784);
    freq.put("ov", 6489);
    freq.put("ro\u0301w", 28327);
    freq.put("lez\u0307", 15711);
    freq.put("ou", 18871);
    freq.put("ndr", 6665);
    freq.put("za\u0328", 41404);
    freq.put("zo\u0301w", 5144);
    freq.put("si ", 6951);
    freq.put("ze\u0328", 35066);
    freq.put("dz", 249442);
    freq.put("Z\u0307", 6256);
    freq.put(" Bo", 15194);
    freq.put("jny", 19293);
    freq.put("Gmi", 6178);
    freq.put("jna", 5939);
    freq.put("own", 11322);
    freq.put("jne", 11196);
    freq.put("X", 17841);
    freq.put(" S\u0142", 20157);
    freq.put("lg", 4525);
    freq.put("ld", 11857);
    freq.put("le", 182455);
    freq.put("lb", 16636);
    freq.put("lc", 6468);
    freq.put("la", 173548);
    freq.put("ln", 79071);
    freq.put("lo", 81679);
    freq.put("ll", 32626);
    freq.put("lm", 9683);
    freq.put("lk", 31238);
    freq.put("li", 209435);
    freq.put("lt", 13727);
    freq.put("lu", 76951);
    freq.put("ls", 113022);
    freq.put("ndi", 8916);
    freq.put("\u0142a\u0328", 10057);
    freq.put("dal", 5635);
    freq.put("dan", 24834);
    freq.put("daj", 6034);
    freq.put("daw", 15145);
    freq.put("dar", 8045);
    freq.put("ema", 7081);
    freq.put("\u0142e\u0328", 5560);
    freq.put("Sai", 4713);
    freq.put("l ", 52041);
    freq.put(" hr", 4991);
    freq.put("Pro", 6911);
    freq.put(" hi", 10476);
    freq.put(" ha", 5671);
    freq.put(" he", 5463);
    freq.put("Prz", 9834);
    freq.put("ec ", 12319);
    freq.put("emi", 25674);
    freq.put("min\u0301", 6040);
    freq.put("by ", 10708);
    freq.put("rez", 11929);
    freq.put("ko\u0301w", 24138);
    freq.put("res", 16392);
    freq.put("rep", 5124);
    freq.put("ret", 5375);
    freq.put("rej", 11845);
    freq.put("rek", 5432);
    freq.put("ren", 18517);
    freq.put("wer", 9502);
    freq.put("rem", 8867);
    freq.put("rec", 6681);
    freq.put("rea", 6346);
    freq.put("reg", 27968);
    freq.put("red", 24223);
    freq.put("ece", 7263);
    freq.put("ecn", 7076);
    freq.put("eck", 33379);
    freq.put("ecj", 5624);
    freq.put("eci", 73659);
    freq.put("ech", 31282);
    freq.put("mie\u0328", 17160);
    freq.put("ect", 5183);
    freq.put("ie ", 425948);
    freq.put("Po\u0142", 4889);
    freq.put("ecz", 26497);
    freq.put("zap", 6541);
    freq.put("g", 760584);
    freq.put("yn\u0301s", 6994);
    freq.put("re ", 17858);
    freq.put("u\u0308", 5350);
    freq.put("cy ", 54622);
    freq.put(" Ba", 23126);
    freq.put("by\u0142", 19691);
    freq.put("ser", 11407);
    freq.put(" Sz", 17219);
    freq.put("\u0142e", 22223);
    freq.put(" Sy", 6223);
    freq.put("\u0142a", 119873);
    freq.put("\u0142c", 7515);
    freq.put("\u0142n", 20167);
    freq.put("\u0142o", 189649);
    freq.put(" St", 33766);
    freq.put(" Su", 6907);
    freq.put("\u0142t", 4875);
    freq.put(" Sk", 5318);
    freq.put(" Si", 11239);
    freq.put(" So", 10324);
    freq.put(" Sc", 7241);
    freq.put(" Sa", 22468);
    freq.put("\u0142y", 40224);
    freq.put(" Se", 13251);
    freq.put("Ka", 25307);
    freq.put("la\u0328", 12242);
    freq.put("rsk", 40769);
    freq.put("udz", 6914);
    freq.put("Ki", 5813);
    freq.put("Ko", 31811);
    freq.put("zna", 56249);
    freq.put("ogr", 14773);
    freq.put("cyc", 12366);
    freq.put("Kr", 17850);
    freq.put("ogo", 4557);
    freq.put("R", 87715);
    freq.put("ogi", 15434);
    freq.put("Ku", 5947);
    freq.put("rst", 9077);
    freq.put("cyj", 21911);
    freq.put("oga", 7462);
    freq.put("udo", 10709);
    freq.put("cym", 5360);
    freq.put("le\u0328", 5780);
    freq.put("\u0142 ", 59292);
    freq.put("bel", 6901);
    freq.put("bec", 8656);
    freq.put("bez", 6239);
    freq.put("ik ", 16857);
    freq.put("lna", 11882);
    freq.put("ber", 14109);
    freq.put("z\u0307", 255164);
    freq.put("res\u0301", 7847);
    freq.put("Par", 14525);
    freq.put("zno", 5266);
    freq.put("in\u0301s", 18739);
    freq.put("e\u0328", 271422);
    freq.put("sen", 9224);
    freq.put("py ", 16720);
    freq.put("aw ", 7482);
    freq.put("ur ", 29893);
    freq.put("el ", 16434);
    freq.put("min", 109517);
    freq.put("mia", 35513);
    freq.put("mic", 8508);
    freq.put("mie", 85656);
    freq.put("hr", 17682);
    freq.put("\u0142o\u0301", 33659);
    freq.put("to\u0301w", 16736);
    freq.put("mis", 7482);
    freq.put("to\u0301r", 35547);
    freq.put("mit", 5081);
    freq.put("aws", 12931);
    freq.put("ogo\u0301", 4810);
    freq.put("awo", 12547);
    freq.put("awn", 15933);
    freq.put("ute", 10402);
    freq.put("awi", 30734);
    freq.put("st ", 49786);
    freq.put(" Eu", 8764);
    freq.put("ny ", 143123);
    freq.put("awa", 20666);
    freq.put("ure", 5261);
    freq.put("urg", 10533);
    freq.put("cka", 9993);
    freq.put("ura", 9619);
    freq.put("Pow", 4846);
    freq.put("uro", 16796);
    freq.put("cki", 56501);
    freq.put("Pol", 63410);
    freq.put("urs", 7537);
    freq.put("Pod", 4669);
    freq.put("ury", 7673);
    freq.put("urz", 9377);
    freq.put("szk", 19152);
    freq.put("szo", 8648);
    freq.put("Cha", 6684);
    freq.put("szc", 22167);
    freq.put("sza", 29086);
    freq.put("sze", 30322);
    freq.put("dby", 5063);
    freq.put("szy", 32568);
    freq.put("da ", 43439);
    freq.put("szp", 5112);
    freq.put("szt", 14601);
    freq.put("nge", 9484);
    freq.put(" w ", 591873);
    freq.put("jaw", 9057);
    freq.put(" is", 7255);
    freq.put("ngi", 4912);
    freq.put("ksz", 11351);
    freq.put("ae ", 4965);
    freq.put("jal", 7148);
    freq.put(" im", 8378);
    freq.put(" in", 25684);
    freq.put("ksi", 5778);
    freq.put("sz ", 5749);
    freq.put(" we", 29944);
    freq.put("ng ", 20546);
    freq.put(" wc", 10065);
    freq.put(" wa", 17275);
    freq.put(" wo", 81271);
    freq.put("ca\u0328", 8049);
    freq.put("ire", 4546);
    freq.put(" wr", 10056);
    freq.put(" ws", 27715);
    freq.put(" i ", 123913);
    freq.put(" wz", 8136);
    freq.put("ja ", 38334);
    freq.put(" wy", 79384);
    freq.put("Pr", 25703);
    freq.put("Pu", 5975);
    freq.put("C", 110974);
    freq.put("Pa", 34023);
    freq.put("Pe", 7756);
    freq.put("ede", 12015);
    freq.put("Pi", 15484);
    freq.put("Po", 99382);
    freq.put("dla", 14281);
    freq.put("lut", 5364);
    freq.put("ome", 9149);
    freq.put("dle", 22301);
    freq.put("et ", 10917);
    freq.put("lud", 5047);
    freq.put("PG", 5183);
    freq.put("a\u0328dz", 6409);
    freq.put("zy\u0142", 4808);
    freq.put("jow", 13446);
    freq.put("omo", 23578);
    freq.put("S", 204600);
    freq.put("cje\u0328", 4623);
    freq.put("zbi", 11943);
    freq.put(" ad", 8368);
    freq.put("jon", 8504);
    freq.put("etr", 10559);
    freq.put("te\u0328p", 15379);
    freq.put("ety", 8345);
    freq.put("lu ", 15294);
    freq.put("za\u0328d", 13275);
    freq.put("eta", 10069);
    freq.put("tle", 5081);
    freq.put("etn", 9079);
    freq.put("eto", 22583);
    freq.put("ck", 80920);
    freq.put("cj", 115414);
    freq.put("ci", 275500);
    freq.put("ch", 414464);
    freq.put("co", 51690);
    freq.put("cn", 22110);
    freq.put("Her", 4920);
    freq.put("za\u0142", 9317);
    freq.put("ca", 105725);
    freq.put("ucz", 7047);
    freq.put("ce", 179393);
    freq.put("cz", 335815);
    freq.put("cy", 107837);
    freq.put(" z\u0307y", 7572);
    freq.put("dza\u0328", 8566);
    freq.put("cu", 14533);
    freq.put("ct", 15111);
    freq.put("taw", 14561);
    freq.put(" z\u0307e", 5562);
    freq.put("do\u0301", 7283);
    freq.put("nu ", 12191);
    freq.put(" w\u0142", 13150);
    freq.put("otn", 8681);
    freq.put("oto", 11888);
    freq.put("ota", 6378);
    freq.put("c ", 34764);
    freq.put("ote", 7310);
    freq.put("oty", 9500);
    freq.put("e\u0328ci", 10430);
    freq.put("otr", 5518);
    freq.put("ysk", 11600);
    freq.put("lli", 5642);
    freq.put("yso", 5982);
    freq.put("e\u0301", 11522);
    freq.put("ysz", 7085);
    freq.put("ysp", 7012);
    freq.put("yst", 44231);
    freq.put("va", 7846);
    freq.put(" Fr", 25744);
    freq.put("ve", 14040);
    freq.put("nom", 6299);
    freq.put("wka", 4779);
    freq.put("vi", 10565);
    freq.put(" Fe", 4580);
    freq.put(" Fi", 5918);
    freq.put(" Fo", 4786);
    freq.put("io ", 7198);
    freq.put("of ", 6324);
    freq.put("cji", 61836);
    freq.put("zy ", 52536);
    freq.put("zgr", 4705);
    freq.put("cja", 35582);
    freq.put("wy ", 42246);
    freq.put("kra\u0328", 16281);
    freq.put("une", 6969);
    freq.put("iow", 26535);
    freq.put("iot", 6025);
    freq.put("ios", 6430);
    freq.put("ior", 18228);
    freq.put("iop", 4645);
    freq.put("ion", 48352);
    freq.put("zyd", 4698);
    freq.put("wys", 19278);
    freq.put("zyc", 26077);
    freq.put("i", 3732766);
    freq.put(" Tu", 5482);
    freq.put("ofi", 6001);
    freq.put("zyj", 5225);
    freq.put(" Tr", 10135);
    freq.put(" To", 9099);
    freq.put("zyw", 7464);
    freq.put("wyd", 14033);
    freq.put("wyc", 28770);
    freq.put("zys", 27664);
    freq.put(" Th", 7821);
    freq.put("wyn", 5788);
    freq.put(" Te", 9806);
    freq.put("S\u0301w", 8984);
    freq.put("wyk", 10398);
    freq.put(" Ta", 10078);
    freq.put("onu", 6969);
    freq.put("sku", 9283);
    freq.put("Be", 12406);
    freq.put("gmi", 81864);
    freq.put("weg", 17678);
    freq.put("Ba", 23485);
    freq.put("skr", 5762);
    freq.put("wej", 33041);
    freq.put("Bo", 15278);
    freq.put("adz", 20389);
    freq.put("Bi", 14211);
    freq.put("ady", 8896);
    freq.put("Bu", 9080);
    freq.put("ade", 12127);
    freq.put("ska", 44791);
    freq.put("Br", 16403);
    freq.put("ada", 31955);
    freq.put("ado", 9262);
    freq.put("sko", 33991);
    freq.put("adm", 7603);
    freq.put("ski", 241685);
    freq.put("adi", 7361);
    freq.put("T", 71466);
    freq.put("we ", 41958);
    freq.put("B ", 5264);
    freq.put("owa\u0328", 6832);
    freq.put("kro\u0301", 6396);
    freq.put("sk ", 6051);
    freq.put("ad ", 24951);
    freq.put("a ", 1141880);
    freq.put("\u0142y ", 21321);
    freq.put("edz", 17029);
    freq.put("za\u0328 ", 5842);
    freq.put("est", 61386);
    freq.put("esp", 11621);
    freq.put("a\u0328d", 23612);
    freq.put("a\u0328g", 22092);
    freq.put("ust", 14884);
    freq.put("esz", 24722);
    freq.put("a\u0328c", 135745);
    freq.put("ien\u0301", 7511);
    freq.put("esa", 4705);
    freq.put("a\u0328z", 17763);
    freq.put("eso", 4594);
    freq.put("a\u0328t", 12097);
    freq.put("esk", 6857);
    freq.put(" j ", 15130);
    freq.put("a\u0328s", 12009);
    freq.put("Un", 7211);
    freq.put("dcz", 6407);
    freq.put("krz", 7284);
    freq.put("za\u0328c", 15081);
    freq.put("kry", 8710);
    freq.put("Sch", 5152);
    freq.put("ndo", 5824);
    freq.put("nda", 6965);
    freq.put("nde", 9089);
    freq.put("a\u0328 ", 117382);
    freq.put("ndy", 5147);
    freq.put("kro", 6037);
    freq.put("za\u0328t", 4518);
    freq.put("es ", 24102);
    freq.put(" je", 81709);
    freq.put("kra", 24036);
    freq.put(" ja", 24161);
    freq.put("kre", 18070);
    freq.put("owo", 53873);
    freq.put("da\u0328", 5425);
    freq.put("owi", 138750);
    freq.put("owe", 69144);
    freq.put("\u0142yw", 5534);
    freq.put("owa", 124010);
    freq.put("owc", 6201);
    freq.put("owy", 75588);
    freq.put("sk\u0142", 11877);
    freq.put("h ", 260015);
    freq.put("jak", 18567);
    freq.put("ows", 40460);
    freq.put("zyn", 18487);
    freq.put("rcz", 7138);
    freq.put("rch", 9881);
    freq.put("rci", 7329);
    freq.put("rce", 4547);
    freq.put("rca", 6614);
    freq.put("hy", 6565);
    freq.put("bur", 11294);
    freq.put("ht", 5694);
    freq.put("hu", 10241);
    freq.put("hi", 35646);
    freq.put("hn", 15999);
    freq.put("ho", 81700);
    freq.put("bum", 8181);
    freq.put("tyj", 4614);
    freq.put("ha", 50953);
    freq.put("bud", 9663);
    freq.put("he", 43730);
    freq.put("zyl", 5653);
    freq.put("a\u0328ce", 25280);
    freq.put("a\u0328ca", 47593);
    freq.put("dmi", 12552);
    freq.put("j", 965827);
    freq.put("po", 424408);
    freq.put("a\u0328cz", 8602);
    freq.put("a\u0328cy", 47223);
    freq.put("zym", 15419);
    freq.put("kre\u0328", 7083);
    freq.put(" je\u0328", 8026);
    freq.put("iny", 19314);
    freq.put("pio", 5728);
    freq.put("int", 11381);
    freq.put("pie", 29091);
    freq.put("ins", 5688);
    freq.put("inn", 9746);
    freq.put("ino", 8623);
    freq.put("ub ", 30727);
    freq.put("ini", 80940);
    freq.put("ind", 7280);
    freq.put("ine", 11157);
    freq.put("pir", 4743);
    freq.put("ing", 19340);
    freq.put("ina", 57100);
    freq.put("inc", 8772);
    freq.put("a\u0328z\u0307", 21246);
    freq.put(" Un", 6885);
    freq.put("or ", 15758);
    freq.put("z\u0142o", 10911);
    freq.put("\u043d", 5938);
    freq.put("ho\u0301", 9384);
    freq.put("gar", 6319);
    freq.put("ube", 7781);
    freq.put("U", 33818);
    freq.put("ubl", 8802);
    freq.put("my ", 8132);
    freq.put("in ", 24060);
    freq.put("hni", 9648);
    freq.put("o ", 461084);
  }
  
}

