package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class PA extends CLangProfile {
  private static final String name = "pa";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public PA() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 112478;
    n_words[1] = 136533;
    n_words[2] = 89577;

    freq.put("\u0a1c\u0a3c\u0a3f", 88);
    freq.put("\u0a1c\u0a3c\u0a3e", 33);
    freq.put("\u0a71\u0a17", 23);
    freq.put("\u0a71\u0a16", 185);
    freq.put("\u0a71\u0a1b", 18);
    freq.put("\u0a39\u0a3e", 329);
    freq.put("\u0a71\u0a1c", 30);
    freq.put("\u0a71\u0a1f", 28);
    freq.put("\u0a1c\u0a3c\u0a2e", 12);
    freq.put("\u0a48\u0964 ", 755);
    freq.put("\u0a3c\u0a4d\u0a30", 22);
    freq.put("\u0a71\u0a15", 286);
    freq.put("\u0a1c", 2041);
    freq.put("\u0a2c\u0a30\u0a3e", 15);
    freq.put("\u0a71\u0a32", 52);
    freq.put("\u0a71\u0a38", 22);
    freq.put("\u0a71\u0a21", 45);
    freq.put("\u0a71\u0a20", 21);
    freq.put("\u0a71\u0a22", 13);
    freq.put("\u0a71\u0a25", 25);
    freq.put("\u0a71\u0a24", 172);
    freq.put("\u0a71\u0a27", 49);
    freq.put("\u0a71\u0a26", 25);
    freq.put("\u0a30\u0a1a ", 44);
    freq.put(" \u0a69\u0a66", 25);
    freq.put(" \u0a69\u0a67", 16);
    freq.put("\u0a71\u0a1a", 879);
    freq.put("\u0a06\u0a28 ", 22);
    freq.put("\u0a5c", 191);
    freq.put("\u0a39\u0a40 ", 112);
    freq.put("\u0a1c\u0a30", 27);
    freq.put("\u0a18 ", 72);
    freq.put("\u0a28\u0a3e ", 113);
    freq.put("\u0a1c\u0a3c\u0a40", 72);
    freq.put(" \u0a30\u0a71", 19);
    freq.put("\u0a07", 2053);
    freq.put("\u0a28\u0a40 ", 107);
    freq.put("\u0a23\u0a3f", 62);
    freq.put("\u0a23\u0a3e", 137);
    freq.put("\u0a0f\u0a2b ", 13);
    freq.put("\u0a09\u0a71", 56);
    freq.put("\u0a67\u0a6b", 17);
    freq.put("\u0a3f\u0a38 ", 72);
    freq.put("\u0a6f ", 52);
    freq.put(" \u0a30\u0a42", 37);
    freq.put(" \u0a30\u0a41", 23);
    freq.put(" \u0a30\u0a47", 12);
    freq.put(" \u0a30\u0a4b", 38);
    freq.put("\u0a23\u0a15", 72);
    freq.put("\u0a47", 3761);
    freq.put(" \u0a30\u0a39", 56);
    freq.put(" \u0a30\u0a38", 75);
    freq.put(" \u0a30\u0a3f", 33);
    freq.put(" \u0a30\u0a3e", 142);
    freq.put("mer", 15);
    freq.put("\u0a08\u0a21\u0a30", 15);
    freq.put("\u0a09\u0a02", 46);
    freq.put("\u0a09\u0a39", 56);
    freq.put("\u0a09\u0a38", 76);
    freq.put("\u0a2b ", 31);
    freq.put(" \u0a30\u0a1a", 14);
    freq.put("k", 37);
    freq.put("\u0a23\u0a40", 85);
    freq.put("\u0a23\u0a47", 53);
    freq.put("ne ", 14);
    freq.put("\u0a09\u0a28", 51);
    freq.put("\u0a09\u0a2a", 26);
    freq.put("\u0a09\u0a23", 28);
    freq.put("\u0a09\u0a24", 19);
    freq.put("\u0a09\u0a26", 21);
    freq.put("\u0a17\u0a24 ", 30);
    freq.put("\u0a71\u0a16\u0a40", 14);
    freq.put("\u0a3f\u0a15\u0a38", 14);
    freq.put("\u0a2f\u0a4b", 27);
    freq.put(" \u0a08 ", 16);
    freq.put("\u0a06\u0a26\u0a3f", 12);
    freq.put("\u0a06\u0a26\u0a3e", 18);
    freq.put("m ", 58);
    freq.put("\u0a2e\u0a47\u0a02", 24);
    freq.put("\u0a4b\u0a0f ", 45);
    freq.put("\u0a23\u0a40 ", 69);
    freq.put("\u0a32", 4004);
    freq.put("er ", 48);
    freq.put("\u0a35\u0a3e ", 26);
    freq.put("\u0a2c\u0a26 ", 20);
    freq.put("\u0a15\u0a71", 19);
    freq.put("\u0a09\u0a38 ", 51);
    freq.put("\u0a3e\u0a02\u0a26", 190);
    freq.put("me", 42);
    freq.put("\u0a15\u0a3f ", 66);
    freq.put("ma", 17);
    freq.put("mb", 17);
    freq.put("mi", 19);
    freq.put("\u0a71\u0a16\u0a23", 15);
    freq.put("mu", 48);
    freq.put("\u0a71\u0a16\u0a3e", 16);
    freq.put("mp", 27);
    freq.put("\u0a71\u0a16\u0a30", 18);
    freq.put("\u0a70\u0a24 ", 18);
    freq.put("\u0a38\u0a3f\u0a06", 13);
    freq.put("\u0a3f\u0a71", 1026);
    freq.put("\u0a3f\u0a70", 258);
    freq.put("\u0a38\u0a3f\u0a16", 14);
    freq.put("\u0a38\u0a3f\u0a15", 33);
    freq.put("\u0a30\u0a2e ", 38);
    freq.put("\u0a38\u0a3f\u0a1f", 36);
    freq.put("\u0a05\u0a30\u0a25", 18);
    freq.put("\u0a1d", 61);
    freq.put("\u0a38\u0a3f\u0a27", 13);
    freq.put("\u0a2e\u0a08 ", 41);
    freq.put("\u0a2b\u0a41\u0a1f", 13);
    freq.put("\u0a2b\u0a30", 17);
    freq.put("\u0a3f\u0a25\u0a3f", 27);
    freq.put("\u0a38\u0a3f\u0a30", 19);
    freq.put("A", 52);
    freq.put("L ", 13);
    freq.put("\u0a3f\u0a38", 263);
    freq.put("\u0a3f\u0a35", 98);
    freq.put("\u0a3f\u0a32", 265);
    freq.put("\u0a3f\u0a30", 130);
    freq.put("\u0a3f\u0a2e", 51);
    freq.put("\u0a40\u0a06\u0a02", 178);
    freq.put("\u0a3f\u0a2a", 16);
    freq.put("\u0a3f\u0a28", 1162);
    freq.put("\u0a3f\u0a27", 20);
    freq.put("\u0a3f\u0a26", 23);
    freq.put("\u0a3f\u0a25", 45);
    freq.put("\u0a3f\u0a24", 204);
    freq.put("\u0a3f\u0a23", 20);
    freq.put("\u0a3f\u0a21", 14);
    freq.put("\u0a02\u0a21", 36);
    freq.put("en ", 20);
    freq.put("\u0a3f\u0a1c", 25);
    freq.put("\u0a3f\u0a1a", 202);
    freq.put("\u0a3f\u0a17", 45);
    freq.put("\u0a3f\u0a16", 72);
    freq.put("\u0a3f\u0a15", 215);
    freq.put("\u0a1a ", 1074);
    freq.put("\u0a3f\u0a0a", 33);
    freq.put("\u0a38\u0a3f\u0a70", 78);
    freq.put("\u0a38\u0a3f\u0a71", 77);
    freq.put("\u0a07\u0a28\u0a4d", 18);
    freq.put("\u0a3f\u0a05", 43);
    freq.put("\u0a05\u0a1c\u0a3f", 15);
    freq.put("\u0a10\u0a17\u0a30", 22);
    freq.put("\u0a30\u0a28\u0a3e", 16);
    freq.put("\u0a35\u0a47", 119);
    freq.put("\u0a35\u0a40", 154);
    freq.put("\u0a35\u0a71", 108);
    freq.put("\u0a35\u0a70", 62);
    freq.put("\u0a30", 5772);
    freq.put("\u0a3e\u0a08 ", 117);
    freq.put("\u0a47 ", 2940);
    freq.put("\u0a06\u0a30 ", 21);
    freq.put("\u0a35\u0a16", 19);
    freq.put("\u0a35\u0a3f", 1234);
    freq.put("\u0a35\u0a3e", 1015);
    freq.put("\u0a2d ", 31);
    freq.put("\u0a42\u0a2a ", 25);
    freq.put("l", 256);
    freq.put("\u0a35\u0a32", 39);
    freq.put(" \u0a68\u0a6b", 13);
    freq.put("\u0a70", 2555);
    freq.put(" \u0a68\u0a69", 13);
    freq.put(" \u0a68\u0a68", 14);
    freq.put(" \u0a68\u0a6f", 17);
    freq.put("\u0a2a\u0a71\u0a1b", 12);
    freq.put(" \u0a68\u0a6d", 12);
    freq.put(" \u0a68\u0a6c", 12);
    freq.put("\u0a41\u0a1d ", 21);
    freq.put("\u0a35\u0a27", 14);
    freq.put(" \u0a68\u0a67", 14);
    freq.put(" \u0a68\u0a66", 53);
    freq.put("\u0a24\u0a3f\u0a39", 21);
    freq.put("\u0a47\u0a21\u0a3e", 24);
    freq.put(" \u0a2f\u0a3e", 23);
    freq.put("\u0a35\u0a30\u0a17", 12);
    freq.put("\u0a21\u0a30\u0a3e", 13);
    freq.put("\u0a1b", 70);
    freq.put("\u0a38\u0a40 ", 89);
    freq.put("rt", 24);
    freq.put("\u0a3e\u0a23", 249);
    freq.put("\u0a02\u0a26\u0a47", 20);
    freq.put("at ", 19);
    freq.put("rs", 22);
    freq.put("ry", 21);
    freq.put("\u0a24\u0a3f\u0a15", 18);
    freq.put("rd", 17);
    freq.put("re", 47);
    freq.put("ra", 24);
    freq.put("ro", 42);
    freq.put("\u0a24\u0a3f\u0a06", 30);
    freq.put("ri", 64);
    freq.put("\u0a02\u0a26\u0a30", 14);
    freq.put("\u0a30\u0a42 ", 145);
    freq.put("W", 18);
    freq.put("nte", 17);
    freq.put("\u0a02\u0a26\u0a3e", 168);
    freq.put("\u0a3e\u0a2c ", 99);
    freq.put("\u0a40\u0a02 ", 52);
    freq.put(" \u0a2f\u0a42", 72);
    freq.put("ati", 17);
    freq.put("r ", 72);
    freq.put("\u0a06", 1270);
    freq.put("\u0a23\u0a15\u0a3e", 14);
    freq.put("\u0a15\u0a30 ", 44);
    freq.put("\u0a1a\u0a28\u0a3e", 19);
    freq.put("\u0a15\u0a24", 65);
    freq.put("\u0a3e\u0a08", 221);
    freq.put("\u0a3e\u0a32 ", 1369);
    freq.put("B", 35);
    freq.put("\u0a17\u0a0f", 21);
    freq.put("\u0a38\u0a3e\u0a07", 73);
    freq.put("\u0a1a\u0a3e\u0a30", 34);
    freq.put("\u0a3e\u0a02", 1630);
    freq.put("\u0a38\u0a3e\u0a28", 18);
    freq.put("\u0a38\u0a3e\u0a30", 46);
    freq.put("\u0a70 ", 328);
    freq.put("\u0a38\u0a3e\u0a32", 1144);
    freq.put("\u0a38\u0a3e\u0a39", 90);
    freq.put("\u0a4d\u0a30", 834);
    freq.put("\u0a27\u0a30", 65);
    freq.put("\u0a27\u0a3f", 28);
    freq.put("\u0a27\u0a3e", 77);
    freq.put("ty ", 13);
    freq.put("\u0a2d\u0a3e\u0a38", 44);
    freq.put("\u0a1f\u0a4d\u0a30", 17);
    freq.put("\u0a2d\u0a3e\u0a30", 147);
    freq.put(" \u0a1a\u0a71", 12);
    freq.put(" \u0a1a\u0a70", 37);
    freq.put("\u0a2d\u0a3e\u0a08", 15);
    freq.put("\u0a40\u0a05\u0a2e", 40);
    freq.put("\u0a2e\u0a28\u0a41", 16);
    freq.put("\u0a2e\u0a28\u0a40", 13);
    freq.put("\u0a2f\u0a3e", 37);
    freq.put("\u0a40\u0a05\u0a24", 34);
    freq.put(" \u0a1a\u0a41", 16);
    freq.put(" \u0a1a\u0a40", 38);
    freq.put("\u0a3e\u0a23\u0a3e", 22);
    freq.put("\u0a3e\u0a23\u0a3f", 27);
    freq.put("\u0a48\u0a15\u0a1f", 16);
    freq.put("\u0a70\u0a25 ", 14);
    freq.put("\u0a2d\u0a3e\u0a17", 17);
    freq.put("\u0a3e\u0a23\u0a40", 40);
    freq.put("\u0a3e\u0a23\u0a42", 104);
    freq.put(" \u0a1a\u0a3f", 16);
    freq.put(" \u0a1a\u0a3e", 51);
    freq.put("\u0a4b\u0a32 ", 12);
    freq.put(" \u0a1a\u0a32", 15);
    freq.put("\u0a21\u0a32 ", 18);
    freq.put("m", 260);
    freq.put("\u0a35\u0a3e\u0a32", 96);
    freq.put("\u0a71", 1924);
    freq.put("\u0a27\u0a40", 16);
    freq.put("\u0a41\u0a06\u0a30", 46);
    freq.put("\u0a68\u0a66\u0a66", 38);
    freq.put(" \u0a1c\u0a70", 39);
    freq.put("d ", 98);
    freq.put("\u0a07\u0a25\u0a47", 16);
    freq.put("\u0a35\u0a71\u0a1c", 17);
    freq.put("\u0a17\u0a30\u0a47", 16);
    freq.put("\u0a17\u0a30\u0a40", 415);
    freq.put("\u0a48\u0a17\u0a30", 366);
    freq.put("\u0a35\u0a71\u0a16", 25);
    freq.put("\u0a35\u0a71\u0a21", 34);
    freq.put(" \u0a1c\u0a47", 15);
    freq.put(" \u0a1c\u0a42", 37);
    freq.put(" \u0a1c\u0a41", 64);
    freq.put(" \u0a1c\u0a40", 148);
    freq.put("\u0a08 ", 351);
    freq.put("\u0a35\u0a71\u0a32", 20);
    freq.put(" \u0a1c\u0a4b", 96);
    freq.put(" \u0a1c\u0a30", 13);
    freq.put(" \u0a1c\u0a3f", 159);
    freq.put(" \u0a1c\u0a3e", 364);
    freq.put(" \u0a1c\u0a3c", 109);
    freq.put("\u0a1c\u0a41\u0a32", 54);
    freq.put("da", 20);
    freq.put("\u0a30\u0a47\u0a17", 15);
    freq.put("\u0a2c\u0a40\u0a1c", 26);
    freq.put("\u0a3e\u0a5c", 27);
    freq.put("\u0a30\u0a47\u0a1c", 79);
    freq.put(" \u0a1c\u0a28", 89);
    freq.put("\u0a17\u0a30\u0a3e", 30);
    freq.put("\u0a26\u0a4b\u0a02", 17);
    freq.put("\u0a1f\u0a28 ", 17);
    freq.put("\u0a2e\u0a40 ", 18);
    freq.put("\u0a26\u0a71", 14);
    freq.put("\u0a30\u0a1c ", 32);
    freq.put("\u0a1c\u0a3e\u0a2c", 125);
    freq.put("\u0a1c\u0a3e\u0a24", 13);
    freq.put("\u0a32\u0a48\u0a02", 19);
    freq.put("\u0a3f\u0a28 ", 1101);
    freq.put("\u0a1f", 625);
    freq.put("\u0a38\u0a3c ", 84);
    freq.put("\u0a28\u0a2e ", 32);
    freq.put("\u0a4b\u0a2e\u0a28", 25);
    freq.put("\u0a07\u0a25", 21);
    freq.put("\u0a26\u0a40", 615);
    freq.put("\u0a26\u0a41", 90);
    freq.put("\u0a26\u0a42", 48);
    freq.put("\u0a47\u0964", 14);
    freq.put("\u0a26\u0a47", 1613);
    freq.put("\u0a26\u0a4b", 54);
    freq.put("\u0a1c\u0a3e\u0a02", 231);
    freq.put("\u0a16\u0a23 ", 24);
    freq.put("C", 59);
    freq.put("\u0a40\u0a06", 241);
    freq.put("wa", 12);
    freq.put("\u0a40\u0a05", 117);
    freq.put("wo", 13);
    freq.put("\u0a21\u0a40 ", 25);
    freq.put("\u0a26\u0a3e", 1748);
    freq.put("\u0a26\u0a3f", 1225);
    freq.put("\u0a70\u0a2a\u0a3f", 40);
    freq.put("\u0a40\u0a17", 18);
    freq.put(" In", 28);
    freq.put("\u0a40\u0a15", 136);
    freq.put("\u0a26\u0a28", 53);
    freq.put("\u0a40\u0a1f", 47);
    freq.put("\u0a40\u0a1c", 44);
    freq.put("\u0a3f\u0a70\u0a17", 49);
    freq.put("\u0a40\u0a26", 20);
    freq.put("\u0a40\u0a24", 114);
    freq.put("\u0a40\u0a2a", 396);
    freq.put("\u0a40\u0a28", 92);
    freq.put("\u0a40\u0a2e", 70);
    freq.put("\u0a3c\u0a2c\u0a26", 26);
    freq.put("\u0a40\u0a2c", 34);
    freq.put("\u0a40\u0a32", 39);
    freq.put("\u0a40\u0a30", 67);
    freq.put("mu ", 47);
    freq.put("\u0a40\u0a35", 67);
    freq.put("\u0a40\u0a38", 29);
    freq.put("com", 13);
    freq.put("and", 32);
    freq.put(" \u0a32\u0a71", 19);
    freq.put("\u0a0a", 48);
    freq.put("\u0a15\u0a47\u0a38", 12);
    freq.put("\u0a24\u0a4b ", 20);
    freq.put("\u0a3c\u0a3e\u0a02", 36);
    freq.put("\u0a3c\u0a3e\u0a39", 32);
    freq.put(" \u0a32\u0a47", 15);
    freq.put(" \u0a32\u0a40", 380);
    freq.put(" \u0a32\u0a48", 20);
    freq.put("\u0a1c\u0a4b ", 82);
    freq.put("\u0a47\u0a30 ", 12);
    freq.put(" \u0a32\u0a3f", 55);
    freq.put(" \u0a32\u0a3e", 29);
    freq.put("\u0a24 ", 537);
    freq.put(" \u0a32\u0a17", 21);
    freq.put("\u0a28\u0a41", 33);
    freq.put("Co", 14);
    freq.put("\u0a07\u0a39 ", 527);
    freq.put("n", 492);
    freq.put("\u0a23\u0a42", 108);
    freq.put("\u0a26\u0a47 ", 1528);
    freq.put(" \u0a32\u0a08", 76);
    freq.put(" \u0a24\u0a4c", 38);
    freq.put(" \u0a24\u0a4b", 497);
    freq.put("\u0a3f\u0a15\u0a3e", 29);
    freq.put(" \u0a24\u0a47", 160);
    freq.put("is", 39);
    freq.put("ir", 14);
    freq.put("iu", 27);
    freq.put("it", 46);
    freq.put("\u0a2f\u0a41", 14);
    freq.put("\u0a3e\u0a02\u0a24", 20);
    freq.put("\u0a40\u0a24\u0a3e", 41);
    freq.put("\u0a3e\u0a02\u0a38", 16);
    freq.put("\u0a09\u0a02\u0a26", 22);
    freq.put("io", 41);
    freq.put("in", 129);
    freq.put("ia", 36);
    freq.put("ic", 60);
    freq.put("ie", 22);
    freq.put("id", 13);
    freq.put("ig", 20);
    freq.put("\u0a28\u0a3f", 163);
    freq.put("\u0a15\u0a5c", 15);
    freq.put("\u0a15\u0a4d", 37);
    freq.put("\u0a15\u0a4c", 24);
    freq.put("\u0a35", 3164);
    freq.put("\u0a15\u0a48", 22);
    freq.put("\u0a15\u0a4b", 104);
    freq.put("\u0a15\u0a47", 135);
    freq.put("\u0a15\u0a41", 80);
    freq.put("\u0a15\u0a40", 517);
    freq.put(" \u0a24\u0a71", 66);
    freq.put("\u0a15\u0a42", 15);
    freq.put("\u0a70\u0a26 ", 43);
    freq.put("\u0a15\u0a3f", 322);
    freq.put("\u0a15\u0a3e", 323);
    freq.put("\u0a15\u0a39", 19);
    freq.put("\u0a15\u0a38", 64);
    freq.put("\u0a15\u0a35", 12);
    freq.put("\u0a15\u0a30", 232);
    freq.put("\u0a15\u0a32", 439);
    freq.put("\u0a15\u0a2e", 20);
    freq.put("\u0a15\u0a28", 33);
    freq.put("i ", 27);
    freq.put(" \u0a24\u0a15", 27);
    freq.put("\u0a15\u0a26", 33);
    freq.put("\u0a07\u0a06\u0964", 31);
    freq.put("\u0a71\u0a1c\u0a4b", 16);
    freq.put("\u0a15\u0a1f", 31);
    freq.put("\u0a6e ", 73);
    freq.put("thu", 15);
    freq.put("\u0a40\u0a24\u0a40", 42);
    freq.put(" \u0a24\u0a3f", 24);
    freq.put(" \u0a24\u0a3e", 41);
    freq.put("\u0a15\u0a08", 21);
    freq.put(" \u0a67 ", 21);
    freq.put("the", 71);
    freq.put(" \u0a24\u0a30", 31);
    freq.put("\u0a08", 490);
    freq.put("\u0a1c\u0a40\u0a35", 20);
    freq.put("\u0a25\u0a3f", 46);
    freq.put("\u0a25\u0a3e", 70);
    freq.put("\u0a47\u0a1c\u0a40", 27);
    freq.put("\u0a1d ", 29);
    freq.put("\u0a1c\u0a40\u0a05", 19);
    freq.put("\u0a15\u0a4b ", 15);
    freq.put("\u0a32\u0a4b\u0a15", 25);
    freq.put("\u0a32\u0a4b\u0a17", 23);
    freq.put("D", 18);
    freq.put("\u0a2a\u0a42\u0a30", 40);
    freq.put("\u0a48", 2081);
    freq.put("\u0a17\u0a23\u0a3f", 17);
    freq.put("\u0a24\u0a3e ", 184);
    freq.put("\u0a32\u0a4b\u0a02", 20);
    freq.put("\u0a47\u0a1c\u0a3c", 73);
    freq.put("\u0a25\u0a4b", 13);
    freq.put("\u0a40\u0a2e ", 51);
    freq.put("\u0a25\u0a47", 53);
    freq.put("\u0a67\u0a6d ", 15);
    freq.put("\u0a25\u0a40", 15);
    freq.put(" \u0a1b\u0a4b", 14);
    freq.put("\u0a32\u0a4b\u0a2e", 22);
    freq.put("\u0a24\u0a70\u0a2c", 41);
    freq.put("\u0a2c\u0a23\u0a3e", 43);
    freq.put("an ", 23);
    freq.put("\u0a3f\u0a70\u0a21", 45);
    freq.put("for", 13);
    freq.put("\u0a21\u0a3e ", 35);
    freq.put("umb", 16);
    freq.put("ics", 14);
    freq.put("\u0a41\u0a23 ", 18);
    freq.put("\u0a70\u0a1c ", 22);
    freq.put("\u0a3f\u0a2c", 77);
    freq.put("\u0a02\u0a17 ", 18);
    freq.put("\u0a3e\u0a1c ", 52);
    freq.put("\u0a2d\u0a17\u0a24", 25);
    freq.put(" \u0a67\u0a69", 12);
    freq.put("\u0a42\u0a28 ", 35);
    freq.put("ic ", 12);
    freq.put("\u0a39\u0a30\u0a3f", 36);
    freq.put("o", 398);
    freq.put("\u0a4b\u0a2e\u0a40", 24);
    freq.put("um ", 31);
    freq.put("\u0a21\u0a47 ", 21);
    freq.put("\u0a41\u0a32\u0a40", 15);
    freq.put("\u0a1a\u0a15", 12);
    freq.put("b ", 18);
    freq.put("\u0a3f ", 127);
    freq.put("\u0a39\u0a4b ", 30);
    freq.put("\u0a3f\u0a1a\u0a3e", 17);
    freq.put("mb ", 14);
    freq.put("\u0a39\u0a48\u0964", 922);
    freq.put("\u0a68\u0a6a", 14);
    freq.put("\u0a68\u0a6b", 14);
    freq.put("\u0a68\u0a68", 14);
    freq.put("\u0a68\u0a69", 13);
    freq.put("\u0a68\u0a6e", 15);
    freq.put("\u0a68\u0a6f", 17);
    freq.put("\u0a68\u0a6c", 13);
    freq.put("\u0a68\u0a6d", 13);
    freq.put("\u0a68\u0a66", 53);
    freq.put("\u0a68\u0a67", 14);
    freq.put("\u0a41\u0a32\u0a3e", 52);
    freq.put("\u0a40\u0a15\u0a3e", 45);
    freq.put("\u0a3f\u0a24\u0a40", 12);
    freq.put("\u0a38\u0a30\u0a40", 12);
    freq.put("\u0a40\u0a15\u0a32", 22);
    freq.put("\u0a17\u0a08", 32);
    freq.put("\u0a40\u0a15\u0a28", 13);
    freq.put("ni", 32);
    freq.put("\u0a17\u0a24", 41);
    freq.put("\u0a07\u0a38 ", 693);
    freq.put("\u0a40\u0964", 87);
    freq.put("na", 37);
    freq.put("nc", 21);
    freq.put("nd", 68);
    freq.put("ne", 28);
    freq.put("ng", 50);
    freq.put("tio", 34);
    freq.put("\u0a17\u0a32", 25);
    freq.put("\u0a17\u0a30", 511);
    freq.put("\u0a17\u0a3f", 132);
    freq.put("\u0a17\u0a3e", 75);
    freq.put("ns", 26);
    freq.put("nt", 47);
    freq.put("\u0a3e\u0a30 ", 238);
    freq.put("\u0a17\u0a38", 65);
    freq.put("\u0a17\u0a47", 24);
    freq.put("E", 20);
    freq.put("\u0a17\u0a42", 16);
    freq.put("\u0a17\u0a41", 197);
    freq.put("\u0a17\u0a40", 24);
    freq.put("\u0a17\u0a4d", 505);
    freq.put("\u0a17\u0a4b", 52);
    freq.put("\u0a1a\u0a4b\u0a02", 38);
    freq.put("\u0a40\u0964 ", 55);
    freq.put("\u0a08\u0a06\u0a02", 13);
    freq.put("\u0a38\u0a30\u0a15", 13);
    freq.put("n ", 137);
    freq.put("\u0a3f\u0a70\u0a18", 68);
    freq.put("\u0a1a\u0a32", 24);
    freq.put("\u0a2d\u0a40 ", 15);
    freq.put("\u0a47\u0a17", 24);
    freq.put("\u0a1a\u0a40\u0a28", 33);
    freq.put("\u0a47\u0a15", 12);
    freq.put("\u0a2d\u0a40", 18);
    freq.put("\u0a70\u0a27 ", 16);
    freq.put("\u0a47\u0a1f", 14);
    freq.put("\u0a2d\u0a4c", 12);
    freq.put("\u0a3e\u0a08\u0a1f", 14);
    freq.put("\u0a30\u0a28 ", 81);
    freq.put("\u0a47\u0a02", 94);
    freq.put("\u0a47\u0a35", 52);
    freq.put("\u0a47\u0a32", 44);
    freq.put("\u0a47\u0a30", 47);
    freq.put("\u0a2c", 2031);
    freq.put("\u0a47\u0a38", 109);
    freq.put("\u0a47\u0a26", 53);
    freq.put("\u0a47\u0a24", 52);
    freq.put("\u0a3e\u0a08\u0a21", 27);
    freq.put("\u0a47\u0a21", 47);
    freq.put(" \u0a68 ", 19);
    freq.put("\u0a3e\u0a08\u0a28", 29);
    freq.put("\u0a47\u0a28", 27);
    freq.put("\u0a2d\u0a17", 29);
    freq.put("\u0a06\u0a30\u0a3e", 46);
    freq.put("\u0a3f\u0a1f\u0a40", 38);
    freq.put("ers", 16);
    freq.put("\u0a6c", 69);
    freq.put("p", 124);
    freq.put("\u0a2d\u0a30", 22);
    freq.put("\u0a07\u0a71\u0a15", 245);
    freq.put("\u0a2d\u0a3e", 256);
    freq.put("\u0a35 ", 71);
    freq.put(" \u0a05\u0a28", 20);
    freq.put("\u0a3e\u0a2c\u0a40", 48);
    freq.put("\u0a28\u0a3f\u0a15", 18);
    freq.put("\u0a30\u0a70\u0a25", 15);
    freq.put("\u0a28\u0a3f\u0a06", 24);
    freq.put("\u0a17", 2047);
    freq.put("\u0a28\u0a41\u0a71", 16);
    freq.put("\u0a28\u0a3f\u0a35", 62);
    freq.put("\u0a67\u0a6c ", 14);
    freq.put("\u0a47\u0a26\u0a28", 48);
    freq.put("\u0a41\u0a70\u0a26", 474);
    freq.put("\u0a38\u0a40\u0a05", 29);
    freq.put("Ma", 13);
    freq.put("ht ", 12);
    freq.put("\u0a28\u0a41\u0a38", 12);
    freq.put("\u0a3e\u0a2c\u0a15", 377);
    freq.put("\u0a30\u0a42\u0a2a", 26);
    freq.put("\u0a32\u0a71\u0a17", 14);
    freq.put("\u0a30\u0a25 ", 20);
    freq.put("\u0a3e\u0a2c\u0a32", 23);
    freq.put("\u0a26\u0a30\u0a3f", 26);
    freq.put("\u0a3e\u0a2c\u0a3e", 23);
    freq.put("\u0a02", 2880);
    freq.put(" \u0a17\u0a23", 16);
    freq.put("\u0a15\u0a30\u0a28", 55);
    freq.put("\u0a15\u0a30\u0a26", 41);
    freq.put(" \u0a09\u0a71", 56);
    freq.put(" \u0a17\u0a30", 23);
    freq.put("\u0a23\u0a15 ", 58);
    freq.put(" \u0a17\u0a3f", 86);
    freq.put("\u0a1c\u0a27\u0a3e", 12);
    freq.put("\u0a3e\u0a32\u0a3e", 46);
    freq.put(" \u0a17\u0a0f", 21);
    freq.put(" \u0a17\u0a08", 32);
    freq.put("\u0a15\u0a30\u0a15", 17);
    freq.put("\u0a3f\u0a32\u0a47", 38);
    freq.put(" \u0a09\u0a38", 69);
    freq.put(" \u0a09\u0a39", 51);
    freq.put("\u0a42", 1115);
    freq.put("\u0a70\u0a16", 19);
    freq.put("\u0a70\u0a17", 218);
    freq.put("F", 29);
    freq.put("\u0a70\u0a18", 85);
    freq.put("\u0a70\u0a1f", 22);
    freq.put("\u0a70\u0a1c", 177);
    freq.put(" \u0a09\u0a28", 48);
    freq.put(" \u0a09\u0a2a", 25);
    freq.put("\u0a3e\u0a32\u0a40", 54);
    freq.put(" \u0a09\u0a24", 19);
    freq.put("\u0a27\u0a3e\u0a02", 14);
    freq.put("\u0a38\u0a3e ", 23);
    freq.put("\u0a15\u0a30\u0a4b", 16);
    freq.put(" \u0a17\u0a41", 188);
    freq.put("\u0a70\u0a38", 52);
    freq.put(" \u0a17\u0a4d", 436);
    freq.put(" \u0a17\u0a4b", 35);
    freq.put("\u0a15\u0a30\u0a40", 18);
    freq.put("\u0a70\u0a21", 502);
    freq.put("\u0a70\u0a26", 618);
    freq.put("\u0a70\u0a27", 36);
    freq.put("\u0a70\u0a24", 85);
    freq.put("\u0a70\u0a25", 18);
    freq.put("\u0a70\u0a2a", 49);
    freq.put("\u0a70\u0a28", 45);
    freq.put("\u0a70\u0a2e", 32);
    freq.put("\u0a70\u0a2c", 155);
    freq.put("\u0a15\u0a3e\u0a02", 22);
    freq.put("\u0a15\u0a1f ", 14);
    freq.put("\u0a16\u0a3c\u0a38", 29);
    freq.put(" of", 43);
    freq.put("ter", 25);
    freq.put("\u0a27 ", 64);
    freq.put("\u0a5c\u0a47 ", 18);
    freq.put("\u0a30\u0a26\u0a3e", 42);
    freq.put("\u0a3e\u0a23 ", 28);
    freq.put("\u0a15\u0a3e\u0a2c", 25);
    freq.put("\u0a15\u0a3e\u0a30", 103);
    freq.put("\ufffd", 48);
    freq.put("\u0a15\u0a3e\u0a32", 30);
    freq.put("\u0a3f\u0a35\u0a47", 63);
    freq.put("\u0a15\u0a3e\u0a38", 23);
    freq.put("\u0a68\u0a66 ", 14);
    freq.put("\u0a4b\u0a32\u0a40", 19);
    freq.put("s ", 155);
    freq.put("\u0a30\u0a38\u0a3f", 50);
    freq.put("\u0a30\u0a38\u0a3e", 69);
    freq.put("\u0a30\u0a38\u0a3c", 34);
    freq.put(" \u0a1a ", 20);
    freq.put("\u0a41\u0a38\u0a3c", 14);
    freq.put("\u0a68\u0a68 ", 14);
    freq.put("\u0a1c\u0a47 ", 27);
    freq.put("ght", 14);
    freq.put("\u0a30\u0a26\u0a40", 16);
    freq.put("\u0a30\u0a26\u0a47", 29);
    freq.put("\u0a6d", 58);
    freq.put("st", 52);
    freq.put("\u0a1f\u0a3e\u0a02", 13);
    freq.put("si", 30);
    freq.put("sh", 12);
    freq.put("\u0a15\u0a4c\u0a2e", 15);
    freq.put("se", 26);
    freq.put("\u0a4d\u0a39 ", 21);
    freq.put("\u0a3f\u0a2e\u0a28", 20);
    freq.put("\u0a1c\u0a3c ", 52);
    freq.put("\u0a21\u0a26", 12);
    freq.put(" am", 51);
    freq.put(" an", 24);
    freq.put("\u0a48\u0964\u0a07", 14);
    freq.put("ent", 21);
    freq.put("\u0a2c\u0a30 ", 175);
    freq.put("\u0a39\u0a40\u0a02", 44);
    freq.put("\u0a40", 4636);
    freq.put("\u0a41\u0a71\u0a16", 54);
    freq.put("\u0a42\u0a2c\u0a30", 34);
    freq.put("\u0a70\u0a28 ", 21);
    freq.put("\u0a17\u0a38\u0a24", 63);
    freq.put("\u0a28\u0a3e\u0a02", 88);
    freq.put("\u0a09\u0a71\u0a24", 40);
    freq.put("\u0a47\u0a35\u0a3e", 19);
    freq.put("\u0a4c\u0a30 ", 34);
    freq.put(" a ", 18);
    freq.put("\u0a28\u0a3e\u0a32", 179);
    freq.put("\u0a28\u0a3e\u0a35", 16);
    freq.put("\u0a39\u0a40\u0a28", 13);
    freq.put("\u0a2e\u0a30\u0a40", 43);
    freq.put("\u0a39\u0a40\u0a30", 14);
    freq.put(" \u0a69 ", 14);
    freq.put("\u0a28\u0a3e\u0a28", 32);
    freq.put("\u0964\u0a07\u0a38", 14);
    freq.put("\u0a28\u0a3e\u0a2e", 38);
    freq.put("em", 14);
    freq.put("el", 41);
    freq.put("\u0a2b\u0a41", 23);
    freq.put("en", 68);
    freq.put("ei", 12);
    freq.put("\u0a2a\u0a48\u0a26", 15);
    freq.put("ee", 14);
    freq.put("ed", 45);
    freq.put("\u0a23 ", 217);
    freq.put("ea", 30);
    freq.put("ec", 17);
    freq.put("\u0a32\u0a70\u0a21", 379);
    freq.put("et", 19);
    freq.put("ev", 13);
    freq.put("\u0a1c\u0a26\u0a4b", 15);
    freq.put("er", 114);
    freq.put("\u0a3f\u0a39", 111);
    freq.put(" \u0a16\u0a47", 84);
    freq.put("\u0a3f\u0a38\u0a24", 34);
    freq.put("\u0a30\u0a35\u0a30", 37);
    freq.put("\u0a2b", 303);
    freq.put("\u0a28\u0a40\u0a06", 32);
    freq.put("\u0a28\u0a40\u0a05", 13);
    freq.put("\u0a3f\u0a38\u0a3c", 57);
    freq.put("\u0a3f\u0a38\u0a3e", 23);
    freq.put("\u0a21\u0a3f", 29);
    freq.put("\u0a21\u0a3e", 86);
    freq.put("\u0a28\u0a40\u0a15", 15);
    freq.put("G", 23);
    freq.put("\u0a3f\u0a38\u0a47", 29);
    freq.put("e ", 169);
    freq.put("\u0a26\u0a41\u0a06", 48);
    freq.put(" \u0a16\u0a3c", 15);
    freq.put(" \u0a16\u0a3f", 13);
    freq.put(" \u0a16\u0a3e", 28);
    freq.put("\u0a6b", 77);
    freq.put("\u0a67\u0a6f ", 14);
    freq.put("\u0a2b\u0a32", 16);
    freq.put("\u0a26\u0a41\u0a28", 24);
    freq.put("\u0a40\u0a30 ", 33);
    freq.put("\u0a2b\u0a3f", 21);
    freq.put("\u0a2b\u0a3e", 21);
    freq.put("\u0a2b\u0a3c", 106);
    freq.put("\u0a2e\u0a47 ", 12);
    freq.put(" \u0a2a\u0a71", 30);
    freq.put("ona", 13);
    freq.put(" \u0a38\u0a26", 12);
    freq.put("\u0a16", 660);
    freq.put("ons", 12);
    freq.put("\u0a27\u0a3f\u0a06", 15);
    freq.put("\u0a48\u0a32 ", 41);
    freq.put("\u0a35\u0a30\u0a24", 32);
    freq.put("\u0a3c\u0a41\u0a30", 27);
    freq.put("\u0a09", 422);
    freq.put("\u0a35\u0a30\u0a38", 36);
    freq.put("\u0a35\u0a16 ", 12);
    freq.put("\u0a30\u0a25", 37);
    freq.put("\u0a3f\u0a1f", 58);
    freq.put("\u0a3f\u0a06", 517);
    freq.put("\u0a2c\u0a3e ", 22);
    freq.put("\u0a35\u0a3e\u0a28", 14);
    freq.put("hum", 14);
    freq.put("on ", 41);
    freq.put("\u0a35\u0a30\u0a40", 76);
    freq.put("\u0a35\u0a3e\u0a30", 49);
    freq.put("\u0a38\u0a15\u0a26", 19);
    freq.put("\u0a07\u0a15 ", 86);
    freq.put("\u0a35\u0a3e\u0a38", 13);
    freq.put("\u0a35\u0a3e\u0a02", 742);
    freq.put("\u0a15\u0a3f\u0a24", 57);
    freq.put("\u0a71\u0a16 ", 91);
    freq.put("ia ", 20);
    freq.put("\u0a70\u0a24\u0a30", 46);
    freq.put("\u0a15\u0a3f\u0a32", 58);
    freq.put("r", 400);
    freq.put("\u0a15\u0a3f\u0a39", 19);
    freq.put("\u0a15\u0a3f\u0a38", 74);
    freq.put("\u0a1a\u0a4c", 23);
    freq.put("\u0a1a\u0a4b", 42);
    freq.put("\u0a1a\u0a47", 17);
    freq.put("\u0a1a\u0a40", 48);
    freq.put("\u0a1a\u0a41", 16);
    freq.put(" \u0a2c\u0a70", 15);
    freq.put("\u0a05\u0a30 ", 17);
    freq.put(" \u0a2c\u0a47", 15);
    freq.put("\u0a15\u0a4d\u0a30", 37);
    freq.put(" \u0a2c\u0a41", 18);
    freq.put(" \u0a2c\u0a40", 32);
    freq.put(" \u0a2c\u0a4d", 13);
    freq.put(" \u0a2c\u0a4b", 36);
    freq.put("\u0a3c\u0a30\u0a35", 39);
    freq.put("\u0a1a\u0a70", 38);
    freq.put("\u0a1a\u0a71", 12);
    freq.put("\u0a41", 1825);
    freq.put("\u0a3f\u0a70\u0a26", 69);
    freq.put(" \u0a2c\u0a23", 71);
    freq.put("\u0a3f\u0a09", 16);
    freq.put(" \u0a2c\u0a28", 14);
    freq.put(" \u0a2c\u0a32", 14);
    freq.put(" \u0a2c\u0a30", 25);
    freq.put(" \u0a2c\u0a3f", 25);
    freq.put(" \u0a2c\u0a3e", 492);
    freq.put(" \u0a2c\u0a39", 34);
    freq.put("\u0a38\u0a40\u0964", 71);
    freq.put("\u0a1a\u0a28", 19);
    freq.put("\u0a32\u0a41", 15);
    freq.put("\u0a40\u0a06 ", 53);
    freq.put("\u0a1a\u0a3e", 99);
    freq.put("\u0a1a\u0a3f", 28);
    freq.put("\u0a16\u0a3e\u0a02", 21);
    freq.put("\u0a69\u0a67 ", 18);
    freq.put("\u0a1a\u0a30", 32);
    freq.put("\u0a68\u0a67 ", 14);
    freq.put("\u0a70\u0a38\u0a3e", 14);
    freq.put("\u0a30\u0a39\u0a3f", 56);
    freq.put("\u0a24\u0a30\u0a40", 36);
    freq.put("\u0a25 ", 48);
    freq.put("\u0a68\u0a69 ", 13);
    freq.put("\u0a15\u0a4b\u0a08", 24);
    freq.put(" \u0a2e\u0a70", 56);
    freq.put("\u0a70\u0a38\u0a25", 15);
    freq.put("\u0a1c\u0a40 ", 155);
    freq.put(" \u0a2e\u0a48", 37);
    freq.put(" \u0a2e\u0a4b", 24);
    freq.put(" \u0a2e\u0a4c", 17);
    freq.put("\u0a47\u0a02 ", 52);
    freq.put(" \u0a2e\u0a41", 481);
    freq.put(" \u0a2e\u0a40", 19);
    freq.put("\u0a2c\u0a47 ", 13);
    freq.put("\u0a2a\u0a70\u0a1c", 152);
    freq.put(" \u0a6b", 29);
    freq.put("\u0a35\u0a40 ", 125);
    freq.put(" \u0a2e\u0a28", 31);
    freq.put("\u0a24\u0a3e\u0a30", 18);
    freq.put("H", 31);
    freq.put(" \u0a2e\u0a24", 12);
    freq.put(" \u0a2e\u0a39", 95);
    freq.put(" \u0a2e\u0a38", 25);
    freq.put(" \u0a2e\u0a3f", 97);
    freq.put(" \u0a2e\u0a3e", 131);
    freq.put("\u0a24\u0a3e\u0a2c", 383);
    freq.put("\u0a24\u0a3e\u0a28", 49);
    freq.put(" \u0a2e\u0a08", 37);
    freq.put("\u0a42\u0a70 ", 327);
    freq.put("\u0a6c ", 50);
    freq.put("\u0a06\u0a2c", 13);
    freq.put("\u0a06\u0a2e", 24);
    freq.put("\u0a24\u0a3e\u0a02", 61);
    freq.put("\u0a30\u0a39\u0a47", 17);
    freq.put("\u0a2e\u0a41\u0a24", 380);
    freq.put("\u0a42\u0a28\u0a40", 19);
    freq.put("\u0a35\u0a48", 22);
    freq.put("\u0a47\u0a24\u0a40", 16);
    freq.put("\u0a21\u0a3e\u0a02", 31);
    freq.put("\u0a07\u0a06 ", 100);
    freq.put("\u0a70\u0a1c\u0a40", 16);
    freq.put("\u0a2f", 188);
    freq.put("\u0a2e\u0a41\u0a16", 14);
    freq.put("\u0a2e\u0a41\u0a15", 29);
    freq.put(" \u0a6a ", 15);
    freq.put("\u0a17\u0a4b\u0a2c", 26);
    freq.put("\u0a3e\u0a1c\u0a3c", 17);
    freq.put("\u0a3e\u0a1c\u0a3e", 13);
    freq.put("\u0a2e\u0a41\u0a71", 38);
    freq.put("\u0a3e\u0a1c\u0a27", 12);
    freq.put("\u0a70\u0a1c\u0a3e", 127);
    freq.put("\u0a5c ", 44);
    freq.put("\u0a5c\u0a3e ", 14);
    freq.put("\u0a47\u0a24\u0a30", 23);
    freq.put("z", 13);
    freq.put("\u0a1c\u0a42", 46);
    freq.put("\u0a6f", 96);
    freq.put("s", 328);
    freq.put("\u0a42\u0a28\u0a3f", 14);
    freq.put("\u0a05\u0a15\u0a24", 41);
    freq.put("\u0a1a\u0a4c\u0a02", 12);
    freq.put("\u0a38\u0a42\u0a30", 32);
    freq.put("\u0a38\u0a42\u0a2c", 12);
    freq.put("\u0a68 ", 59);
    freq.put("\u0a1a", 1522);
    freq.put("\u0a2c\u0a4b\u0a32", 29);
    freq.put("\u0a05\u0a15", 61);
    freq.put("\u0a2a\u0a39\u0a3f", 45);
    freq.put("\u0a48\u0a02\u0a21", 21);
    freq.put("\u0a06\u0a35\u0a3e", 13);
    freq.put("\u0a67\u0a6e ", 12);
    freq.put("\u0a17\u0a0f ", 15);
    freq.put("\u0a39\u0a4b\u0a23", 23);
    freq.put("\u0a18\u0a30 ", 13);
    freq.put("\u0a2a\u0a71", 37);
    freq.put("\u0a39\u0a4b\u0a30", 25);
    freq.put("\u0a3f\u0a1a ", 162);
    freq.put("\u0a39\u0a4b\u0a07", 70);
    freq.put("\u0a3f\u0a35\u0a3e", 13);
    freq.put("\u0a39\u0a4b\u0a08", 20);
    freq.put("\u0a39\u0a4b\u0a0f", 48);
    freq.put("\u0a4b\u0a02 ", 614);
    freq.put("\u0a08\u0964", 12);
    freq.put("\u0a05", 1321);
    freq.put("Th", 15);
    freq.put("\u0a3e\u0a30\u0a1a", 41);
    freq.put("\u0a3e\u0a30\u0a15", 16);
    freq.put("ym", 13);
    freq.put("\u0a40\u0a15 ", 34);
    freq.put("\u0a07\u0a38\u0a26", 16);
    freq.put("\u0a3e\u0a30\u0a3e", 51);
    freq.put(" Ma", 13);
    freq.put("\u0a17 ", 162);
    freq.put("il", 21);
    freq.put("\u0a48\u0a26\u0a3e", 18);
    freq.put("\u0a39\u0a30 ", 16);
    freq.put("\u0a71\u0a15 ", 255);
    freq.put("\u0a3e\u0a30\u0a28", 27);
    freq.put("\u0a15\u0a70", 48);
    freq.put("\u0a3e\u0a30\u0a24", 101);
    freq.put("\u0a17\u0a26", 22);
    freq.put("I", 60);
    freq.put(" \u0a2f", 133);
    freq.put("\u0a05\u0a2e\u0a30", 51);
    freq.put("\u0a17\u0a23", 22);
    freq.put("\u0a3e\u0a30\u0a47", 39);
    freq.put("\u0a3e\u0a30\u0a40", 54);
    freq.put("\u0a3f\u0a24 ", 82);
    freq.put("\u0a32\u0a4d\u0a39", 16);
    freq.put("In", 29);
    freq.put("\u0a0f\u0a32 ", 13);
    freq.put("\u0a08\u0a1f", 14);
    freq.put("am ", 12);
    freq.put("\u0a39\u0a48 ", 423);
    freq.put(" \u0a2d\u0a30", 19);
    freq.put("\u0a18", 134);
    freq.put(" \u0a2d\u0a3e", 230);
    freq.put("\u0a08\u0a06", 13);
    freq.put("\u0a26\u0a3e ", 1619);
    freq.put("\u0a16\u0a40 ", 31);
    freq.put("\u0a16\u0a3f\u0a06", 40);
    freq.put(" \u0a2d\u0a17", 25);
    freq.put("\u0a69\u0a66 ", 23);
    freq.put("\u0a08\u0a21", 27);
    freq.put("\u0a1f\u0a30\u0a40", 23);
    freq.put("\u0a2e\u0a40\u0a1f", 34);
    freq.put("\u0a26\u0a4b ", 25);
    freq.put("ce", 32);
    freq.put("\u0a47\u0a21\u0a26", 12);
    freq.put("\u0a3e\u0a09\u0a02", 14);
    freq.put(" \u0a06", 274);
    freq.put("\u0a13 ", 12);
    freq.put("amu", 47);
    freq.put("\u0a35\u0a38", 16);
    freq.put("\u0a24\u0a47 ", 613);
    freq.put(" \u0a2d\u0a40", 16);
    freq.put("\u0a30\u0a47 ", 75);
    freq.put(" \u0a2d\u0a4c", 12);
    freq.put("\u0a06\u0a23\u0a3e", 27);
    freq.put("\u0a2c\u0a40 ", 78);
    freq.put("t", 467);
    freq.put("\u0a0f\u0964 ", 23);
    freq.put("\u0a3e\u0a09\u0a23", 23);
    freq.put("\u0a17\u0a30 ", 22);
    freq.put("\u0a38\u0a3c\u0a3f", 19);
    freq.put("\u0a38\u0a3c\u0a3e", 149);
    freq.put("\u0a3f\u0a28\u0a3e", 26);
    freq.put("\u0a38\u0a3c\u0a39", 65);
    freq.put("\u0a06\u0a2e ", 19);
    freq.put("\u0a38\u0a3c\u0a30", 12);
    freq.put("\u0a38\u0a3c\u0a2c", 26);
    freq.put("\u0a38\u0a3c\u0a28", 37);
    freq.put("\u0a38\u0a3c\u0a24", 17);
    freq.put("\u0a6a ", 44);
    freq.put("\u0a1c\u0a3e ", 63);
    freq.put("\u0a38\u0a3c\u0a1f", 21);
    freq.put(" co", 22);
    freq.put(" \u0a68\u0a6a", 14);
    freq.put("\u0a38\u0a3c\u0a16", 29);
    freq.put("\u0a25\u0a3e\u0a02", 13);
    freq.put("o ", 26);
    freq.put("\u0a07\u0a70\u0a1f", 13);
    freq.put("\u0a1b\u0a2e", 12);
    freq.put("\u0a35\u0a28", 21);
    freq.put(" \u0a6b ", 15);
    freq.put("\u0a26 ", 171);
    freq.put("\u0a2a\u0a32", 21);
    freq.put("\u0a1b\u0a4b", 17);
    freq.put("on", 91);
    freq.put("\u0a40 ", 2902);
    freq.put("ol", 28);
    freq.put("of", 44);
    freq.put("\u0a42\u0a26", 14);
    freq.put("\u0a21\u0a40\u0a05", 12);
    freq.put("\u0a3f\u0a28\u0a4d", 12);
    freq.put("\u0a38\u0a3c\u0a4d", 23);
    freq.put("\u0a30\u0a71\u0a16", 17);
    freq.put("\u0a38\u0a3c\u0a47", 16);
    freq.put("ou", 18);
    freq.put("\u0a3f\u0a28\u0a47", 13);
    freq.put("os", 19);
    freq.put("or", 54);
    freq.put("\u0a38\u0a3c\u0a41", 34);
    freq.put("\u0a38\u0a3c\u0a40", 30);
    freq.put("\u0a15\u0a47 ", 100);
    freq.put("\u0a38\u0a2e", 81);
    freq.put("\u0a1c\u0a4b\u0a02", 19);
    freq.put("\u0a24\u0a70", 44);
    freq.put("\u0a24\u0a71", 67);
    freq.put("\u0a24\u0a4c", 43);
    freq.put("\u0a17\u0a5c", 29);
    freq.put("\u0a24\u0a4b", 518);
    freq.put("\u0a24\u0a47", 631);
    freq.put("\u0a38\u0a2d", 32);
    freq.put("\u0a24\u0a42", 46);
    freq.put("\u0a24\u0a40", 231);
    freq.put("\u0a38\u0a2e\u0a3e", 24);
    freq.put("\u0a24\u0a4b\u0a02", 485);
    freq.put("\u0a3c\u0a3e ", 51);
    freq.put("\u0a24\u0a2e", 27);
    freq.put("\u0a24\u0a2a", 13);
    freq.put("\u0a24\u0a28", 20);
    freq.put("\u0a24\u0a24", 12);
    freq.put("\u0a24\u0a3e", 728);
    freq.put("\u0a24\u0a3f", 96);
    freq.put("\u0a38\u0a2e\u0a47", 23);
    freq.put("\u0a3c\u0a16\u0a3c", 29);
    freq.put(" \u0a18\u0a30", 13);
    freq.put("\u0a24\u0a32", 37);
    freq.put("\u0a28\u0a42\u0a70", 329);
    freq.put("\u0a24\u0a30", 186);
    freq.put("\u0a26\u0a47\u0a38", 44);
    freq.put("\u0a26\u0a47\u0a35", 25);
    freq.put("\u0a6e", 92);
    freq.put("\u0a2a\u0a23\u0a47", 34);
    freq.put("he ", 69);
    freq.put("\u0a40\u0a32 ", 18);
    freq.put("\u0a67\u0a69 ", 12);
    freq.put("\u0a2a\u0a23\u0a40", 15);
    freq.put("\u0a24\u0a15", 48);
    freq.put("ac", 18);
    freq.put("ab", 12);
    freq.put("ad", 16);
    freq.put("ai", 16);
    freq.put("\u0a3e\u0a02 ", 1353);
    freq.put("am", 68);
    freq.put("al", 54);
    freq.put("an", 97);
    freq.put("as", 29);
    freq.put("ar", 52);
    freq.put("at", 58);
    freq.put("\u0a3f\u0a15 ", 134);
    freq.put("\u0a4d\u0a30\u0a26", 16);
    freq.put("\u0a70\u0a26\u0a40", 31);
    freq.put("\u0a70\u0a26\u0a47", 65);
    freq.put("\u0a4d\u0a30\u0a2e", 14);
    freq.put(" \u0a67\u0a66", 19);
    freq.put(" \u0a67\u0a67", 13);
    freq.put("\u0a4d\u0a30\u0a3e", 30);
    freq.put("\u0a4d\u0a30\u0a3f", 60);
    freq.put(" \u0a67\u0a6c", 17);
    freq.put(" \u0a67\u0a6d", 16);
    freq.put(" \u0a67\u0a6a", 15);
    freq.put(" \u0a67\u0a6b", 16);
    freq.put("\u0a4d\u0a30\u0a38", 16);
    freq.put("\u0a4d\u0a30\u0a39", 30);
    freq.put("\u0a4d\u0a30\u0a47", 90);
    freq.put("\u0a2a\u0a3e\u0a08", 14);
    freq.put("\u0a3f\u0a24\u0a3e", 77);
    freq.put("\u0a4d\u0a30\u0a40", 65);
    freq.put("\u0a4d\u0a30\u0a4b", 27);
    freq.put("\u0a4d\u0a30\u0a48", 416);
    freq.put("\u0a70\u0a26\u0a30", 40);
    freq.put("\u0a02\u0a26\u0a40", 34);
    freq.put("\u0a09\u0a28\u0a4d", 43);
    freq.put("\u0a21\u0a30 ", 388);
    freq.put("\u0a15 ", 1139);
    freq.put("\u0a70\u0a26\u0a3e", 409);
    freq.put("\u0a39\u0a47 ", 27);
    freq.put("u", 236);
    freq.put("\u0a4d\u0a30\u0a70", 13);
    freq.put("\u0a2b\u0a3c\u0a30", 40);
    freq.put("\u0a47\u0a16", 36);
    freq.put("\u0a26\u0a42\u0a1c", 16);
    freq.put("\u0a67\u0a67", 14);
    freq.put("\u0a67\u0a66", 19);
    freq.put("\u0a47\u0a32 ", 13);
    freq.put("\u0a67\u0a6f", 42);
    freq.put("\u0a67\u0a6e", 24);
    freq.put("\u0a67\u0a6d", 17);
    freq.put("\u0a67\u0a6c", 17);
    freq.put(" \u0a05\u0a70", 217);
    freq.put(" \u0a05\u0a71", 34);
    freq.put("\u0a67\u0a69", 12);
    freq.put("\u0a67\u0a68", 18);
    freq.put("\u0a10\u0a17", 22);
    freq.put("ty", 14);
    freq.put(" \u0a13\u0a32", 31);
    freq.put("\u0a26\u0a42\u0a38", 12);
    freq.put("tr", 30);
    freq.put("ts", 12);
    freq.put("to", 25);
    freq.put("th", 116);
    freq.put("ti", 67);
    freq.put("te", 65);
    freq.put("\u0a3c", 1111);
    freq.put("ta", 28);
    freq.put(" \u0a05\u0a2e", 64);
    freq.put("\u0a47\u0a1c", 108);
    freq.put("ium", 27);
    freq.put(" \u0a05\u0a2a", 47);
    freq.put(" \u0a05\u0a24", 411);
    freq.put(" \u0a05\u0a27", 17);
    freq.put("al ", 27);
    freq.put("mpi", 14);
    freq.put(" \u0a05\u0a38", 17);
    freq.put(" \u0a05\u0a30", 39);
    freq.put("\u0a28\u0a47 ", 143);
    freq.put("is ", 22);
    freq.put("\u0a42 ", 303);
    freq.put("\u0a71\u0a25\u0a47", 12);
    freq.put("ge", 13);
    freq.put(" \u0a05\u0a1c", 33);
    freq.put("\u0a3e\u0a26 ", 29);
    freq.put(" \u0a05\u0a15", 54);
    freq.put(" \u0a05\u0a17", 67);
    freq.put("t ", 72);
    freq.put("\u0a3f\u0a06\u0a32", 13);
    freq.put("\u0a3f\u0a06\u0a30", 28);
    freq.put("\u0a3f\u0a06\u0a35", 14);
    freq.put("\u0a3f\u0a06\u0a38", 12);
    freq.put("ted", 14);
    freq.put("\u0a3f\u0a06\u0a23", 31);
    freq.put("\u0a3f\u0a06\u0a26", 20);
    freq.put("\u0a3f\u0a32\u0a40", 21);
    freq.put("\u0a2b\u0a4d\u0a30", 14);
    freq.put("\u0a3f\u0a06\u0a28", 47);
    freq.put("\u0a4d\u0a39", 146);
    freq.put("\u0a70\u0a21\u0a30", 381);
    freq.put("\u0a70\u0a21\u0a32", 14);
    freq.put("\u0a27", 297);
    freq.put("\u0a24\u0a40 ", 175);
    freq.put("\u0a2c\u0a32", 53);
    freq.put("\u0a70\u0a21\u0a3e", 15);
    freq.put("\u0a3f\u0a06\u0a02", 76);
    freq.put("\u0a66\u0a6e ", 24);
    freq.put("\u0a3e\u0a07\u0a32", 17);
    freq.put("\u0a1a\u0a32\u0a3e", 12);
    freq.put("\u0a09\u0a23 ", 23);
    freq.put("\u0a70\u0a21\u0a40", 26);
    freq.put("\u0a3e\u0a07\u0a23", 62);
    freq.put("\u0a05\u0a70\u0a26", 15);
    freq.put("\u0a05\u0a70\u0a24", 31);
    freq.put("\u0a47\u0a35 ", 19);
    freq.put("\u0a67", 273);
    freq.put("\u0a05\u0a70\u0a17", 91);
    freq.put("\u0a05\u0a70\u0a15", 65);
    freq.put("\u0a3e\u0a07\u0a06", 59);
    freq.put("\u0a2c\u0a70\u0a27", 25);
    freq.put(" \u0964", 190);
    freq.put(" \u0a6c ", 12);
    freq.put("\u0a3e\u0a15\u0a40", 370);
    freq.put("\u0a32\u0a47 ", 121);
    freq.put("\u0a3e ", 2802);
    freq.put("\u0a38\u0a70", 167);
    freq.put("\u0a3c\u0a30", 65);
    freq.put(" \u0a0f ", 29);
    freq.put("\u0a15\u0a38 ", 17);
    freq.put("\u0a3c\u0a3f", 116);
    freq.put("\u0a71\u0a1b\u0a2e", 12);
    freq.put("\u0a26\u0a30 ", 34);
    freq.put("\u0a1f\u0a2c\u0a3e", 13);
    freq.put("\u0a3e\u0a15\u0a3f", 34);
    freq.put("v", 42);
    freq.put("Ind", 16);
    freq.put("\u0a38\u0a2d ", 25);
    freq.put("\u0a26\u0a3f\u0a28", 1097);
    freq.put("\u0a38\u0a47", 97);
    freq.put("f ", 44);
    freq.put("\u0a2c\u0a15", 380);
    freq.put("\u0a2c\u0a26", 46);
    freq.put("\u0a26\u0a3f\u0a06", 31);
    freq.put("\u0a6b ", 50);
    freq.put("\u0a2c\u0a23", 71);
    freq.put("\u0a70\u0a17\u0a30", 20);
    freq.put("\u0a70\u0a17\u0a3e", 15);
    freq.put("\u0a30\u0a3e ", 103);
    freq.put("\u0a26\u0a30", 129);
    freq.put("\u0a1f\u0a3e\u0a07", 14);
    freq.put("\u0a2c\u0a28", 25);
    freq.put("\u0a67\u0a68 ", 16);
    freq.put("\u0a2c\u0a30", 215);
    freq.put("\u0a2c\u0a3e", 578);
    freq.put("\u0a2c\u0a3f", 55);
    freq.put("\u0a2c\u0a39", 34);
    freq.put("\u0a2c\u0a47", 32);
    freq.put("\u0a4b\u0a2a ", 15);
    freq.put("\u0a2c\u0a40", 120);
    freq.put("\u0a2c\u0a41", 20);
    freq.put("\u0a2c\u0a4d", 15);
    freq.put("\u0a2c\u0a4b", 46);
    freq.put("\u0a2c\u0a48", 14);
    freq.put(" \u0a68\u0a6e", 14);
    freq.put("\u0a26\u0a3f\u0a71", 27);
    freq.put("fi", 14);
    freq.put("\u0a70\u0a17\u0a4d", 60);
    freq.put("\u0a38\u0a4d\u0a30", 19);
    freq.put("fo", 16);
    freq.put("a", 561);
    freq.put("cs ", 14);
    freq.put("ry ", 17);
    freq.put("\u0a17\u0a3e\u0a02", 14);
    freq.put("\u0a07\u0a23\u0a15", 56);
    freq.put("\u0a2c\u0a70", 44);
    freq.put("\u0a41\u0a30 ", 13);
    freq.put("\u0a32\u0a23 ", 22);
    freq.put(" \u0a67", 210);
    freq.put("ce ", 16);
    freq.put(" \u0a6a", 26);
    freq.put("y ", 61);
    freq.put(" \u0a68", 195);
    freq.put(" \u0a69", 56);
    freq.put(" \u0a6e", 15);
    freq.put(" \u0a6f", 19);
    freq.put(" \u0a6c", 17);
    freq.put(" \u0a6d", 14);
    freq.put("\u0a10", 62);
    freq.put(" Ol", 12);
    freq.put("\u0a3e\u0964", 27);
    freq.put("\u0a2a\u0a24 ", 12);
    freq.put("\u0a05\u0a15\u0a3e", 15);
    freq.put(" \u0a22", 16);
    freq.put(" \u0a21", 55);
    freq.put(" \u0a26", 4245);
    freq.put(" \u0a27", 86);
    freq.put(" \u0a24", 951);
    freq.put(" \u0a25", 21);
    freq.put(" \u0a2a", 1056);
    freq.put(" \u0a2b", 184);
    freq.put(" \u0a28", 1023);
    freq.put(" \u0a2e", 1134);
    freq.put("L", 38);
    freq.put(" \u0a2c", 868);
    freq.put(" \u0a2d", 339);
    freq.put(" \u0a32", 715);
    freq.put(" \u0a30", 498);
    freq.put(" \u0a35", 2408);
    freq.put("\u0a25\u0a3e\u0a28", 18);
    freq.put(" \u0a38", 2699);
    freq.put(" \u0a39", 2872);
    freq.put("\u0a1f\u0a30 ", 67);
    freq.put(" \u0a07", 1749);
    freq.put(" \u0a05", 1094);
    freq.put(" \u0a08", 30);
    freq.put(" \u0a09", 313);
    freq.put(" \u0a0f", 119);
    freq.put(" \u0a13", 47);
    freq.put(" \u0a10", 59);
    freq.put(" \u0a16", 182);
    freq.put(" \u0a17", 918);
    freq.put(" \u0a15", 1460);
    freq.put(" \u0a1a", 259);
    freq.put(" \u0a1b", 39);
    freq.put(" \u0a18", 42);
    freq.put(" \u0a1f", 112);
    freq.put(" \u0a1c", 1208);
    freq.put(" \u0a1d", 16);
    freq.put("\u0a38\u0a2a", 32);
    freq.put("\u0a38\u0a2b", 15);
    freq.put("\u0a38\u0a28", 101);
    freq.put("\u0a3f\u0a30 ", 73);
    freq.put("\u0a38\u0a2c", 22);
    freq.put("\u0a38\u0a24 ", 69);
    freq.put("\u0a38\u0a26", 49);
    freq.put("\u0a38\u0a24", 207);
    freq.put("dia", 15);
    freq.put("\u0a38\u0a38", 15);
    freq.put("\u0a38\u0a39", 12);
    freq.put("\u0a38\u0a3e", 1477);
    freq.put("\u0a38\u0a3f", 313);
    freq.put("\u0a38\u0a3c", 623);
    freq.put("\u0a38\u0a32", 51);
    freq.put(" \u0a28\u0a42", 313);
    freq.put("\u0a38\u0a30", 94);
    freq.put(" \u0a28\u0a47", 127);
    freq.put("\u0a38\u0a35", 19);
    freq.put("\u0a17\u0a40 ", 17);
    freq.put("\u0a38\u0a47 ", 56);
    freq.put("\u0a41\u0a38", 47);
    freq.put("\u0a30 ", 1488);
    freq.put("\u0a38\u0a1f", 58);
    freq.put("\u0a28\u0a15\u0a38", 15);
    freq.put("\u0a2e\u0a3e ", 32);
    freq.put("\u0a42\u0a30\u0a2c", 14);
    freq.put("as ", 15);
    freq.put("\u0a4b\u0a07", 77);
    freq.put(" s ", 16);
    freq.put("\u0a38\u0a71", 26);
    freq.put("\u0a2d\u0a3f", 14);
    freq.put("\u0a68\u0a6c ", 13);
    freq.put("\u0a16 ", 140);
    freq.put("\u0a38\u0a4b", 30);
    freq.put(" \u0a28\u0a39", 38);
    freq.put(" \u0a28\u0a3f", 106);
    freq.put(" \u0a28\u0a3e", 302);
    freq.put("\u0a38\u0a4d", 26);
    freq.put("\u0a38\u0a42", 66);
    freq.put("\u0a38\u0a40", 222);
    freq.put("\u0a38\u0a41", 43);
    freq.put("\u0a06\u0a28\u0a40", 21);
    freq.put(" \u0a28\u0a35", 51);
    freq.put("w", 71);
    freq.put("\u0a42\u0a30\u0a1c", 24);
    freq.put("\u0a2b\u0a4d", 15);
    freq.put("\u0a4b\u0a23", 30);
    freq.put("\u0a4b\u0a21", 13);
    freq.put("\u0a4b\u0a08", 46);
    freq.put("\u0a4b\u0a27", 14);
    freq.put("\u0a35\u0a28 ", 15);
    freq.put("\u0a4b\u0a24", 20);
    freq.put("\u0a4b\u0a2a", 22);
    freq.put("\u0a4b\u0a28", 32);
    freq.put("\u0a4b\u0a2e", 61);
    freq.put("\u0a4b\u0a2c", 36);
    freq.put("\u0a4b\u0a32", 71);
    freq.put("\u0a4b\u0a30", 92);
    freq.put("\u0a4b\u0a35", 23);
    freq.put("\u0a4b\u0a39", 24);
    freq.put("\u0a4b\u0a38", 21);
    freq.put("\u0a4b\u0a02", 617);
    freq.put("st ", 12);
    freq.put("\u0a6d ", 49);
    freq.put("\u0a26", 5926);
    freq.put("\u0a16\u0a47", 111);
    freq.put("\u0a4b\u0a0f", 51);
    freq.put("\u0a4b\u0a17", 55);
    freq.put("\u0a4b\u0a15", 33);
    freq.put("\u0a4b\u0a1a", 14);
    freq.put("\u0a4b\u0a1f", 27);
    freq.put("\u0a4b\u0a1c", 32);
    freq.put("\u0a16\u0a4b", 29);
    freq.put(" \u0a6d ", 13);
    freq.put("\u0a26\u0a3e\u0a28", 17);
    freq.put("\u0a07\u0a71", 255);
    freq.put("\u0a26\u0a3e\u0a30", 26);
    freq.put("nce", 16);
    freq.put("\u0a26\u0a3e\u0a38", 19);
    freq.put("b", 81);
    freq.put("\u0a26\u0a3e\u0a02", 14);
    freq.put("\u0a66", 200);
    freq.put("\u0a17\u0a4d\u0a30", 502);
    freq.put("\u0a70\u0a16\u0a3f", 16);
    freq.put("str", 14);
    freq.put("\u0a39\u0a40", 203);
    freq.put("\u0a4b\u0a5c", 31);
    freq.put("\u0a2c\u0a3f\u0a70", 25);
    freq.put("\u0a38\u0a30 ", 20);
    freq.put("\u0a15\u0a26\u0a40", 15);
    freq.put("\u0a2a\u0a3f\u0a0a", 14);
    freq.put("\u0a3e\u0a28\u0a3e", 31);
    freq.put("\u0a38\u0a3e\u0a02", 13);
    freq.put("\u0a4b\u0a5c ", 16);
    freq.put("\u0a2a\u0a3f\u0a15", 29);
    freq.put("\u0a3e\u0a28\u0a15", 26);
    freq.put("\u0a23\u0a42 ", 105);
    freq.put("k ", 17);
    freq.put("\u0a2a\u0a3f\u0a24", 20);
    freq.put("\u0a3c\u0a47", 19);
    freq.put("\u0a2c\u0a4d\u0a30", 15);
    freq.put("\u0a17\u0a3f\u0a06", 104);
    freq.put("\u0a1f ", 103);
    freq.put("\u0a17\u0a08 ", 25);
    freq.put("\u0a38\u0a1f ", 13);
    freq.put("\u0a07\u0a32\u0a3e", 16);
    freq.put("\u0a3c\u0a41", 43);
    freq.put("M", 47);
    freq.put("\u0a3f\u0a06\u0964", 22);
    freq.put("\u0a69 ", 43);
    freq.put("\u0a3c\u0a4d", 25);
    freq.put("\u0a28\u0a4d\u0a39", 75);
    freq.put("\u0a2a\u0a4d\u0a30", 176);
    freq.put("\u0a39\u0a71\u0a26", 12);
    freq.put("\u0a05 ", 12);
    freq.put("\u0a2a\u0a3f\u0a70", 41);
    freq.put("\u0a3c\u0a1f\u0a30", 18);
    freq.put("\u0a3e\u0a28\u0a40", 48);
    freq.put("\u0a67\u0a6b ", 13);
    freq.put("\u0a3e\u0a2e\u0a3f", 15);
    freq.put("\u0a2f\u0a4b\u0a17", 18);
    freq.put("\u0a06\u0a2a ", 24);
    freq.put("\u0a30\u0a3f", 221);
    freq.put("\u0a15\u0a24\u0a42", 34);
    freq.put("\u0a66\u0a66\u0a6e", 24);
    freq.put("\u0a15\u0a24\u0a40", 13);
    freq.put("ymp", 12);
    freq.put("\u0a28\u0a38\u0a70", 13);
    freq.put("\u0a32 ", 1735);
    freq.put("\u0a2c\u0a39\u0a41", 25);
    freq.put("\u0a30\u0a40\u0a38", 12);
    freq.put("\u0a1f\u0a3f\u0a06", 13);
    freq.put("\u0a32\u0a3e ", 163);
    freq.put("\u0a30\u0a40\u0a2c", 18);
    freq.put("\u0a30\u0a40\u0a15", 94);
    freq.put("\u0a30\u0a2e", 236);
    freq.put("\u0a3f\u0a39\u0a3e", 91);
    freq.put("\u0a71\u0a1a\u0a4b", 29);
    freq.put("\u0a30\u0a40\u0a06", 20);
    freq.put("\u0a71\u0a1a ", 827);
    freq.put("x", 19);
    freq.put("\u0a42\u0a32 ", 22);
    freq.put("\u0a24\u0a15\u0a28", 13);
    freq.put(" \u0a07\u0a70", 25);
    freq.put(" \u0a07\u0a71", 255);
    freq.put("\u0a26\u0a40\u0a06", 75);
    freq.put(" \u0a15\u0a08", 21);
    freq.put("\u0a15\u0a32\u0a3e", 14);
    freq.put("\u0a38\u0a70\u0a16", 18);
    freq.put(" \u0a15\u0a3e", 86);
    freq.put(" \u0a15\u0a3f", 260);
    freq.put(" \u0a15\u0a39", 19);
    freq.put("\u0a38\u0a70\u0a2c", 52);
    freq.put(" \u0a15\u0a30", 183);
    freq.put(" \u0a15\u0a32", 399);
    freq.put("\u0a38\u0a70\u0a24", 12);
    freq.put("\u0a38\u0a70\u0a38", 37);
    freq.put("\u0a2f\u0a42", 73);
    freq.put("\u0a2f\u0a3e ", 16);
    freq.put("\u0a42\u0a32\u0a40", 19);
    freq.put("\u0a15\u0a32\u0a1a", 23);
    freq.put(" \u0a07\u0a32", 20);
    freq.put("\u0a05\u0a24\u0a47", 407);
    freq.put(" \u0a07\u0a38", 723);
    freq.put(" \u0a07\u0a39", 533);
    freq.put(" \u0a15\u0a4c", 24);
    freq.put(" \u0a15\u0a4d", 23);
    freq.put(" \u0a07\u0a24", 23);
    freq.put(" \u0a07\u0a25", 21);
    freq.put("\u0a15\u0a32\u0a70", 379);
    freq.put(" \u0a15\u0a4b", 64);
    freq.put("\u0a15\u0a40\u0a24", 87);
    freq.put(" \u0a15\u0a47", 73);
    freq.put(" \u0a15\u0a40", 109);
    freq.put(" \u0a15\u0a41", 68);
    freq.put(" \u0a07\u0a28", 39);
    freq.put("\u0a30\u0a42", 205);
    freq.put("c", 194);
    freq.put(" \u0a07\u0a15", 94);
    freq.put("\u0a30\u0a15 ", 18);
    freq.put("\u0a3e\u0a24 ", 23);
    freq.put("\u0a48 ", 444);
    freq.put(" \u0a39\u0a48", 1352);
    freq.put(" \u0a39\u0a4b", 233);
    freq.put("\u0a39\u0a3e\u0a38", 57);
    freq.put("\u0a35\u0a3f\u0a26", 16);
    freq.put(" \u0a39\u0a40", 66);
    freq.put(" \u0a39\u0a41", 491);
    freq.put("\u0a39\u0a3e\u0a30", 25);
    freq.put("\u0a09\u0a39\u0a28", 12);
    freq.put("\u0a39\u0a3e\u0a32", 13);
    freq.put(" \u0a39\u0a47", 15);
    freq.put("\u0a1c\u0a47", 38);
    freq.put("\u0a39\u0a3e\u0a28", 18);
    freq.put("\u0a1c\u0a40", 234);
    freq.put("\u0a1c\u0a41", 64);
    freq.put("\u0a39\u0a71", 25);
    freq.put("\u0a39\u0a70", 15);
    freq.put("\u0a35\u0a3f\u0a38", 21);
    freq.put("\u0a68\u0a6d ", 13);
    freq.put("\u0a1c\u0a4b", 120);
    freq.put("\u0a28\u0964", 476);
    freq.put("\u0a30\u0a24\u0a3f", 15);
    freq.put("\u0a30\u0a24\u0a3e", 15);
    freq.put("\u0a39\u0a4b", 237);
    freq.put("\u0a05\u0a26 ", 27);
    freq.put("\u0a39\u0a4c", 13);
    freq.put("\u0a1c\u0a70", 41);
    freq.put("\u0a2e ", 350);
    freq.put("\u0964\u0a07", 25);
    freq.put("\u0a2a", 1926);
    freq.put("\u0a08\u0a28", 32);
    freq.put("\u0a39\u0a47", 48);
    freq.put("\u0a39\u0a3e\u0a08", 26);
    freq.put("\u0a35\u0a3f\u0a16", 22);
    freq.put("\u0a35\u0a3f\u0a15", 13);
    freq.put("pe", 18);
    freq.put("\u0a35\u0a3f\u0a1a", 200);
    freq.put("pi", 19);
    freq.put("po", 12);
    freq.put("\u0a39\u0a3e\u0a02", 94);
    freq.put("\u0a39\u0a28", 550);
    freq.put("\u0a39\u0a2e", 13);
    freq.put("\u0a1a\u0a30\u0a32", 20);
    freq.put("N", 37);
    freq.put("\u0a35\u0a3f\u0a71", 870);
    freq.put("\u0a16\u0a23", 34);
    freq.put(" \u0a15\u0a70", 44);
    freq.put("\u0a39\u0a3f", 360);
    freq.put(" th", 90);
    freq.put("\u0a3e\u0a05\u0a26", 30);
    freq.put("\u0a39\u0a30", 67);
    freq.put("\u0a39\u0a32", 14);
    freq.put("\u0a38\u0a25", 50);
    freq.put("\u0a30\u0a24\u0a40", 63);
    freq.put(" \u0a39\u0a28", 519);
    freq.put("\u0a1c\u0a32", 16);
    freq.put("\u0a15\u0a28 ", 15);
    freq.put("\u0a1c\u0a3e", 547);
    freq.put("\u0a1c\u0a3f", 213);
    freq.put("\u0a1c\u0a3c", 304);
    freq.put("\u0a6a", 62);
    freq.put("\u0a1c\u0a26", 23);
    freq.put("\u0a1c\u0a27", 12);
    freq.put(" \u0a39\u0a3e", 41);
    freq.put(" \u0a39\u0a3f", 46);
    freq.put(" \u0a39\u0a30", 55);
    freq.put("Oly", 12);
    freq.put("\u0a1c\u0a28", 116);
    freq.put("\u0a3f\u0a71\u0a27", 18);
    freq.put("\u0a41\u0a28\u0a40", 20);
    freq.put("\u0a3f\u0a71\u0a24", 44);
    freq.put("\u0a17\u0a5c\u0a4d", 19);
    freq.put(" \u0a6e ", 14);
    freq.put("\u0a02\u0a15", 18);
    freq.put("\u0a02\u0a17", 31);
    freq.put("\u0a15", 3798);
    freq.put("\u0a4b\u0a08 ", 39);
    freq.put("rig", 16);
    freq.put("\u0a02\u0a1f", 25);
    freq.put(" \u0a2b\u0a3e", 12);
    freq.put(" \u0a2b\u0a3f", 18);
    freq.put(" \u0a2b\u0a3c", 66);
    freq.put("\u0a02\u0a24", 24);
    freq.put("\u0a41 ", 14);
    freq.put("\u0a02\u0a26", 244);
    freq.put("\u0a3e\u0a38 ", 54);
    freq.put("\u0a23\u0a3e ", 86);
    freq.put("\u0a3e\u0a23\u0a15", 12);
    freq.put("\u0a3f\u0a71\u0a16", 61);
    freq.put("\u0a02\u0a38", 30);
    freq.put("\u0a3f\u0a71\u0a1a", 863);
    freq.put("\u0a71\u0a27 ", 29);
    freq.put("\u0a15\u0a3e ", 68);
    freq.put("\u0a2e\u0a28\u0a47", 20);
    freq.put("\u0a66\u0a66", 66);
    freq.put("\u0a40\u0a05\u0a28", 27);
    freq.put("\u0a1a\u0a3e\u0a08", 23);
    freq.put("\u0a66\u0a6e", 25);
    freq.put("\u0a1a\u0a3e\u0a32", 16);
    freq.put(" \u0a2b\u0a41", 20);
    freq.put(" \u0a2b\u0a4d", 14);
    freq.put("\u0a32\u0a47", 163);
    freq.put("y", 106);
    freq.put("\u0a27\u0a3e\u0a28", 15);
    freq.put("\u0a41\u0a28\u0a3f", 12);
    freq.put("\u0a68\u0a6a ", 13);
    freq.put("\u0a06\u0a02", 297);
    freq.put("\u0a28\u0a70", 12);
    freq.put("\u0a68\u0a6b ", 14);
    freq.put("\u0a71\u0a24\u0a47", 24);
    freq.put("\u0a28", 4410);
    freq.put("\u0a28\u0a4b", 19);
    freq.put("\u0a28\u0a48", 12);
    freq.put("\u0a28\u0a4d", 89);
    freq.put("\u0a28\u0a42", 341);
    freq.put("\u0a28\u0a40", 200);
    freq.put("\u0a32\u0a4b", 133);
    freq.put("\u0a28\u0a47", 196);
    freq.put("\u0a67\u0a6a ", 14);
    freq.put("\u0a20 ", 22);
    freq.put("ld ", 18);
    freq.put("\u0a28\u0a3e", 539);
    freq.put("\u0a30\u0a32 ", 24);
    freq.put("\u0a28\u0a32", 14);
    freq.put("\u0a35\u0a47\u0a02", 22);
    freq.put("\u0a28\u0a30", 14);
    freq.put("\u0a1c\u0a17", 13);
    freq.put("\u0a28\u0a35", 102);
    freq.put("\u0a28\u0a2e", 39);
    freq.put("\u0a71\u0a24\u0a30", 42);
    freq.put("\u0a71\u0a24\u0a3e", 19);
    freq.put("\u0a28\u0a21", 15);
    freq.put("\u0a28\u0a26", 13);
    freq.put("\u0a28\u0a24", 17);
    freq.put("d", 221);
    freq.put("\u0a28\u0a1c", 12);
    freq.put("\u0a68", 239);
    freq.put("\u0a35\u0a47\u0a26", 48);
    freq.put("\u0a28\u0a15", 44);
    freq.put("\u0a32\u0a17\u0a3e", 13);
    freq.put(" \u0a06\u0a30", 19);
    freq.put("\u0a32\u0a40\u0a05", 22);
    freq.put("\u0a32\u0a40\u0a06", 17);
    freq.put("\u0a39\u0a3f\u0a70", 31);
    freq.put("\u0a13", 66);
    freq.put("\u0a40\u0a1f\u0a30", 38);
    freq.put("\u0a41\u0a24 ", 26);
    freq.put(" \u0a06\u0a26", 14);
    freq.put(" \u0a06\u0a2a", 76);
    freq.put(" \u0a06\u0a2c", 12);
    freq.put(" \u0a06\u0a2e", 22);
    freq.put("\u0a15\u0a41\u0a1d", 20);
    freq.put("\u0a39\u0a28 ", 79);
    freq.put("\u0a32\u0a40\u0a2a", 371);
    freq.put("\u0a06 ", 416);
    freq.put("\u0a32\u0a40\u0a35", 25);
    freq.put("\u0a47\u0a17\u0a30", 13);
    freq.put(" \u0a06\u0a09", 20);
    freq.put("be", 16);
    freq.put("\u0a39\u0a3f\u0a38", 19);
    freq.put("\u0a15\u0a41\u0a71", 13);
    freq.put("\u0a2a\u0a30 ", 49);
    freq.put("\u0a28\u0964 ", 77);
    freq.put("\u0a39\u0a3f\u0a32", 50);
    freq.put("O", 37);
    freq.put("\u0a39\u0a3f\u0a30", 60);
    freq.put("\u0a39\u0a3f\u0a2c", 75);
    freq.put("\u0a39\u0a3f\u0a28", 24);
    freq.put("\u0a39\u0a3f\u0a24", 27);
    freq.put("\u0a35\u0a30", 201);
    freq.put("\u0a02\u0964", 15);
    freq.put("\u0a3e\u0a17 ", 23);
    freq.put("\u0a02\u0a1f ", 12);
    freq.put("\u0a40\u0a38\u0a1f", 12);
    freq.put(" \u0a2a\u0a5c", 16);
    freq.put("\u0a2c\u0a32 ", 16);
    freq.put("\u0a3f\u0a32 ", 25);
    freq.put(" \u0a2a\u0a4d", 133);
    freq.put("\u0a21\u0a30", 410);
    freq.put("\u0a30\u0a35\u0a3e", 29);
    freq.put("\u0a21\u0a32", 20);
    freq.put(" \u0a38\u0a1f", 13);
    freq.put(" \u0a2a\u0a48", 40);
    freq.put(" \u0a2a\u0a4b", 18);
    freq.put(" \u0a2a\u0a47", 13);
    freq.put(" \u0a2a\u0a41", 69);
    freq.put(" \u0a2a\u0a40", 18);
    freq.put(" \u0a38\u0a15", 45);
    freq.put(" \u0a2a\u0a42", 34);
    freq.put(" \u0a38\u0a2a", 16);
    freq.put(" \u0a38\u0a28", 75);
    freq.put(" \u0a38\u0a2e", 69);
    freq.put(" \u0a38\u0a2d", 32);
    freq.put(" \u0a38\u0a2c", 19);
    freq.put("\u0a24\u0a30\u0a3e", 24);
    freq.put("\u0a70\u0a15 ", 58);
    freq.put(" \u0a2a\u0a70", 163);
    freq.put(" \u0a38\u0a25", 20);
    freq.put(" \u0a38\u0a24", 61);
    freq.put(" \u0a38\u0a3f", 210);
    freq.put(" \u0a38\u0a3e", 1296);
    freq.put(" \u0a38\u0a3c", 257);
    freq.put(" \u0a38\u0a30", 55);
    freq.put("u ", 55);
    freq.put("\u0a3e", 10004);
    freq.put(" \u0a38\u0a4b", 27);
    freq.put(" \u0a2a\u0a1f", 13);
    freq.put(" Co", 14);
    freq.put(" \u0a38\u0a4d", 21);
    freq.put("ns ", 12);
    freq.put(" \u0a38\u0a42", 56);
    freq.put(" \u0a38\u0a41", 40);
    freq.put(" \u0a38\u0a40", 135);
    freq.put(" \u0a38\u0a47", 33);
    freq.put("\u0a0f ", 114);
    freq.put("\u0a1c\u0a28 ", 22);
    freq.put("\u0a21\u0a40", 68);
    freq.put(" \u0a2a\u0a3f", 76);
    freq.put(" \u0a2a\u0a3e", 125);
    freq.put(" \u0a2a\u0a39", 57);
    freq.put("\u0a21\u0a47", 30);
    freq.put("ut", 16);
    freq.put(" \u0a2a\u0a30", 200);
    freq.put("us", 14);
    freq.put("ur", 21);
    freq.put("um", 56);
    freq.put("\u0a30\u0a4b ", 14);
    freq.put("un", 15);
    freq.put(" \u0a38\u0a71", 24);
    freq.put(" \u0a38\u0a70", 107);
    freq.put("ua", 16);
    freq.put("\u0a06\u0964 ", 38);
    freq.put("\u0a2a\u0a70", 164);
    freq.put("\u0a39\u0a41\u0a70", 468);
    freq.put("\u0a3c ", 152);
    freq.put("lym", 12);
    freq.put("\u0a2a\u0a5c", 21);
    freq.put("\u0a68\u0a6e ", 15);
    freq.put("\u0a38\u0a28 ", 38);
    freq.put("\u0a40\u0a1c\u0a3f", 21);
    freq.put("\u0a70\u0a15", 75);
    freq.put("\u0a3e\u0a28\u0a47", 13);
    freq.put("\u0a2a\u0a4d", 176);
    freq.put("\u0a2a\u0a48", 44);
    freq.put("\u0a2a\u0a4b", 22);
    freq.put("\u0a2a\u0a47", 23);
    freq.put("\u0a2a\u0a40", 37);
    freq.put("\u0a2a\u0a41", 90);
    freq.put("\u0a2a\u0a42", 52);
    freq.put("\u0a2a\u0a3e", 168);
    freq.put("\u0a2a\u0a3f", 130);
    freq.put("\u0a2a\u0a38", 12);
    freq.put("\u0a2a\u0a39", 57);
    freq.put("\u0a2a\u0a30", 222);
    freq.put("\u0a05\u0a24 ", 35);
    freq.put(" \u0a6f ", 15);
    freq.put("\u0a2a\u0a28", 15);
    freq.put("\u0a2a\u0a24", 28);
    freq.put("\u0a39\u0a41\u0a24", 24);
    freq.put("\u0a16\u0a4b\u0a02", 14);
    freq.put("\u0a39\u0a41\u0a23", 12);
    freq.put("\u0a2a\u0a23", 56);
    freq.put("\u0a2a\u0a1f", 24);
    freq.put("e", 655);
    freq.put("\u0a69", 93);
    freq.put("\u0a3e\u0a39 ", 17);
    freq.put("\u0a27\u0a3e\u0a30", 30);
    freq.put("\u0a3c\u0a28 ", 23);
    freq.put("\u0a47\u0a38\u0a3c", 80);
    freq.put("\u0a41\u0a1f\u0a2c", 13);
    freq.put("\u0a71\u0a26 ", 13);
    freq.put(" b", 21);
    freq.put(" c", 34);
    freq.put(" a", 133);
    freq.put(" f", 30);
    freq.put(" d", 21);
    freq.put(" e", 15);
    freq.put(" h", 17);
    freq.put(" i", 57);
    freq.put(" o", 57);
    freq.put(" m", 24);
    freq.put(" r", 16);
    freq.put(" s", 54);
    freq.put(" p", 41);
    freq.put(" w", 40);
    freq.put(" t", 120);
    freq.put("go", 13);
    freq.put("gh", 19);
    freq.put(" B", 32);
    freq.put(" C", 54);
    freq.put(" A", 46);
    freq.put(" F", 17);
    freq.put(" G", 21);
    freq.put(" D", 15);
    freq.put(" E", 17);
    freq.put("\u0a3e\u0a32\u0a47", 56);
    freq.put(" H", 25);
    freq.put(" I", 54);
    freq.put(" N", 32);
    freq.put(" O", 31);
    freq.put(" L", 21);
    freq.put(" M", 43);
    freq.put(" R", 22);
    freq.put(" S", 47);
    freq.put(" P", 44);
    freq.put(" W", 15);
    freq.put(" T", 36);
    freq.put("\u0a26\u0a40 ", 510);
    freq.put("ed ", 32);
    freq.put("\u0a15\u0a70\u0a2a", 19);
    freq.put("\u0a2f\u0a42\u0a28", 34);
    freq.put("\u0a4c", 206);
    freq.put("\u0a25\u0a3e ", 23);
    freq.put("P", 47);
    freq.put("g ", 34);
    freq.put("\u0a2f\u0a42\u0a32", 19);
    freq.put("\u0a2f\u0a42\u0a30", 14);
    freq.put(" \u0a0f\u0964", 18);
    freq.put("\u0a2e\u0a48\u0a28", 17);
    freq.put("\u0a30\u0a21 ", 23);
    freq.put("\u0a38\u0a32\u0a3e", 21);
    freq.put("\u0a4b\u0a15 ", 20);
    freq.put("\u0a16\u0a40", 35);
    freq.put("\u0a30\u0a16", 17);
    freq.put("\u0a30\u0a17", 45);
    freq.put("\u0a30\u0a15", 76);
    freq.put("\u0a30\u0a1a", 72);
    freq.put("\u0a38 ", 997);
    freq.put("\u0a32\u0a2e ", 13);
    freq.put("\u0a30\u0a1f", 18);
    freq.put("\u0a30\u0a1c", 81);
    freq.put("\u0a06\u0a09\u0a02", 16);
    freq.put("\u0a67\u0a67 ", 12);
    freq.put("\u0a02\u0a21 ", 22);
    freq.put("\u0a38\u0a24\u0a3e", 54);
    freq.put("\u0a40\u0a28 ", 57);
    freq.put("\u0a4c\u0a02 ", 41);
    freq.put("\u0a2e\u0a3e\u0a02", 39);
    freq.put("\u0a30\u0a32", 37);
    freq.put("\u0a28\u0a15 ", 14);
    freq.put("\u0a30\u0a35", 92);
    freq.put("\u0a30\u0a38", 179);
    freq.put("\u0a30\u0a39", 94);
    freq.put("\u0a30\u0a3e", 502);
    freq.put("\u0a2e\u0a3e\u0a32", 18);
    freq.put("\u0a2e\u0a3e\u0a30", 62);
    freq.put("\u0a30\u0a23", 36);
    freq.put("\u0a30\u0a21", 28);
    freq.put("\u0a30\u0a26", 131);
    freq.put("\u0a30\u0a24", 198);
    freq.put("\u0a2e\u0a3e\u0a28", 46);
    freq.put("\u0a30\u0a2a", 20);
    freq.put("\u0a30\u0a2b", 22);
    freq.put("\u0a30\u0a28", 116);
    freq.put("\u0a2e\u0a3e\u0a24", 26);
    freq.put("\u0a2e\u0a3e\u0a23", 116);
    freq.put("\u0a30\u0a2c", 46);
    freq.put("\u0a42\u0a30 ", 25);
    freq.put("\u0a3e\u0a35\u0a3e", 47);
    freq.put("\u0a30\u0a40", 839);
    freq.put("\u0a30\u0a41", 36);
    freq.put("\u0a30\u0a47", 213);
    freq.put("\u0a38\u0a24\u0a70", 39);
    freq.put("\u0a30\u0a4b", 128);
    freq.put("\u0a30\u0a48", 428);
    freq.put("\u0a3e\u0a35\u0a32", 13);
    freq.put("\u0a30\u0a4d", 22);
    freq.put("\u0a30\u0a70", 40);
    freq.put("\u0a30\u0a71", 21);
    freq.put("\u0a16\u0a24", 12);
    freq.put("\u0a16\u0a26", 15);
    freq.put("\u0a16\u0a30", 32);
    freq.put("\u0a48\u0a28 ", 18);
    freq.put("\u0a16\u0a3c", 60);
    freq.put("cti", 12);
    freq.put("\u0a16\u0a3e", 81);
    freq.put("\u0a16\u0a3f", 54);
    freq.put("\u0a4b ", 213);
    freq.put("\u0a4b\u0a17\u0a30", 27);
    freq.put("\u0a23\u0a3f\u0a06", 40);
    freq.put("\u0a22", 42);
    freq.put("\u0a2a\u0a5c\u0a4d", 12);
    freq.put("\u0a26\u0a28 ", 52);
    freq.put(" \u0a10\u0a17", 22);
    freq.put("\u0a70\u0a2c\u0a30", 125);
    freq.put("\u0a4b\u0a23 ", 17);
    freq.put("om", 42);
    freq.put("\u0a40\u0a2e\u0a3e", 12);
    freq.put("\u0a23\u0a3f\u0a24", 17);
    freq.put("f", 103);
    freq.put("\u0a3e\u0a24\u0a3e", 27);
    freq.put("\u0a48\u0a32", 73);
    freq.put("\u0a30\u0a17 ", 14);
    freq.put("\u0a2d\u0a3e\u0a35", 14);
    freq.put("\u0a06\u0a02 ", 277);
    freq.put("\u0a3e\u0a28 ", 155);
    freq.put("\u0a69\u0a67", 18);
    freq.put("\u0a69\u0a66", 26);
    freq.put("\u0a1f\u0a3f", 29);
    freq.put("\u0a1f\u0a3e", 78);
    freq.put(" \u0a1c\u0a26", 19);
    freq.put("di", 36);
    freq.put("\u0a48\u0a28", 38);
    freq.put("\u0a1f\u0a30", 121);
    freq.put("\u0a1f\u0a2c", 13);
    freq.put("\u0a13\u0a32", 31);
    freq.put("\u0a05\u0a71", 34);
    freq.put("\u0a05\u0a70", 220);
    freq.put("\u0a4c\u0a24", 23);
    freq.put("de", 37);
    freq.put("\u0a05\u0a28 ", 34);
    freq.put("\u0a30\u0a3f\u0a06", 72);
    freq.put("\u0a4d", 1046);
    freq.put("ow", 13);
    freq.put("\u0a1f\u0a4d", 17);
    freq.put("\u0a07\u0a32 ", 16);
    freq.put("\u0a48\u0a23", 13);
    freq.put("\u0a38\u0a1f\u0a3e", 14);
    freq.put("\u0a05\u0a17", 69);
    freq.put("\u0a30\u0a3f\u0a15", 21);
    freq.put("\u0a1f\u0a40", 130);
    freq.put("\u0a05\u0a2e", 113);
    freq.put("\u0a4c\u0a02", 47);
    freq.put("\u0a05\u0a28", 55);
    freq.put("\u0a68\u0a6f ", 16);
    freq.put("\u0a3c\u0a38\u0a40", 29);
    freq.put("\u0a05\u0a24", 454);
    freq.put("\u0a30\u0a3f\u0a24", 27);
    freq.put("\u0a05\u0a26", 42);
    freq.put("\u0a05\u0a38", 23);
    freq.put("\u0a30\u0a3f\u0a38", 18);
    freq.put("\u0a30\u0a3f\u0a39", 15);
    freq.put("\u0a4c\u0a1c", 14);
    freq.put("\u0a05\u0a30", 63);
    freq.put("\u0a05\u0a32", 18);
    freq.put("\u0a2d", 430);
    freq.put("\u0a21\u0a26\u0a40", 12);
    freq.put("\u0a28\u0a35\u0a30", 42);
    freq.put("\u0a3e\u0a26\u0a40", 22);
    freq.put("\u0a2e\u0a39\u0a40", 13);
    freq.put("\u0a20", 69);
    freq.put("ld", 21);
    freq.put("le", 33);
    freq.put("la", 31);
    freq.put("\u0a5c\u0a3e", 29);
    freq.put("lo", 16);
    freq.put("ll", 20);
    freq.put("li", 35);
    freq.put("\u0a05\u0a17\u0a38", 63);
    freq.put("\u0a42\u0a70", 335);
    freq.put("ly", 15);
    freq.put("\u0a42\u0a06", 13);
    freq.put("\u0a1f\u0a28", 25);
    freq.put("\u0a5c\u0a47", 20);
    freq.put("\u0a28\u0a35\u0a70", 36);
    freq.put("\u0964 ", 1125);
    freq.put("\u0a5c\u0a40", 29);
    freq.put("\u0a67 ", 77);
    freq.put("\u0a42\u0a1c", 17);
    freq.put("\u0a5c\u0a4d", 38);
    freq.put("\u0a35\u0a70\u0a2c", 36);
    freq.put("\u0a2e\u0a39\u0a3e", 43);
    freq.put("\u0a2e\u0a39\u0a3f", 32);
    freq.put("l ", 48);
    freq.put("\u0a42\u0a2c", 50);
    freq.put("\u0a3e\u0a26\u0a3e", 19);
    freq.put("\u0a42\u0a28", 78);
    freq.put("\u0a42\u0a2a", 31);
    freq.put("\u0a35\u0a70\u0a21", 19);
    freq.put("\u0a42\u0a30", 124);
    freq.put("\u0a42\u0a32", 53);
    freq.put("\u0a1c\u0a70\u0a17", 15);
    freq.put("\u0a28\u0a47\u0a02", 14);
    freq.put("\u0a17\u0a41\u0a30", 167);
    freq.put("\u0a24\u0a40\u0a06", 19);
    freq.put("\u0a4d ", 22);
    freq.put("\u0a5c\u0a40 ", 26);
    freq.put("\u0a3f\u0a06 ", 232);
    freq.put("\u0a30\u0a48\u0a17", 367);
    freq.put("\u0a30\u0a48\u0a15", 12);
    freq.put("\u0a2e\u0a28 ", 35);
    freq.put("\u0a05\u0a2a\u0a4d", 39);
    freq.put("\u0a07\u0a24\u0a3f", 19);
    freq.put("\u0a70\u0a21 ", 46);
    freq.put("\u0a4c\u0a2e", 17);
    freq.put("\u0a30\u0a48\u0a32", 39);
    freq.put("\u0a2e\u0a70\u0a28", 14);
    freq.put("\u0a2d\u0a4c\u0a24", 12);
    freq.put("\u0a4b", 1676);
    freq.put("\u0a2e\u0a70\u0a21", 22);
    freq.put("\u0a2c\u0a15 ", 378);
    freq.put("\u0a67\u0a66 ", 14);
    freq.put("g", 125);
    freq.put("\u0a05\u0a1c", 34);
    freq.put("\u0a1c\u0a42\u0a28", 35);
    freq.put("re ", 16);
    freq.put("\u0a38\u0a15", 73);
    freq.put("\u0a3e\u0a38", 245);
    freq.put("\u0a3e\u0a39", 169);
    freq.put("\u0a4c\u0a30", 50);
    freq.put("\u0a24\u0a71\u0a15", 12);
    freq.put("\u0a3e\u0a30", 660);
    freq.put("\u0a3e\u0a32", 1569);
    freq.put("rs ", 13);
    freq.put("\u0a3e\u0a35", 109);
    freq.put("\u0a3e\u0a28", 318);
    freq.put("\u0a1f\u0a47", 26);
    freq.put("\u0a3e\u0a2a", 44);
    freq.put("\u0a3e\u0a2c", 594);
    freq.put("\u0a3e\u0a2e", 104);
    freq.put("\u0a3e\u0a21", 16);
    freq.put("\u0a2e", 2207);
    freq.put("\u0a3e\u0a24", 101);
    freq.put("\u0a3e\u0a26", 96);
    freq.put("\u0a3e\u0a27", 15);
    freq.put("\u0a3e\u0a1a", 13);
    freq.put("\u0a3e\u0a1c", 126);
    freq.put(" \u0a0f\u0a2b", 13);
    freq.put(" \u0a0f\u0a28", 15);
    freq.put("\u0a07\u0a70", 32);
    freq.put("\u0a15\u0a38\u0a3c", 26);
    freq.put("\u0a71\u0a21\u0a3e", 23);
    freq.put("\u0a1c\u0a3f\u0a2e", 22);
    freq.put("\u0a3e\u0a15", 443);
    freq.put("\u0a3e\u0a16", 18);
    freq.put("\u0a3e\u0a17", 63);
    freq.put("\u0a1c\u0a3f\u0a32", 12);
    freq.put("\u0a3e\u0a09", 53);
    freq.put(" \u0a0f\u0a38", 15);
    freq.put("\u0a1c\u0a3f\u0a38", 70);
    freq.put("\u0a1c\u0a3f\u0a39", 19);
    freq.put(" \u0a0f\u0a32", 14);
    freq.put("\u0a3e\u0a05", 32);
    freq.put("\u0a3e\u0a07", 185);
    freq.put("\u0a30\u0a26\u0a41", 28);
    freq.put("\u0a07\u0a15", 101);
    freq.put("\u0a2e\u0a3f", 154);
    freq.put("\u0a3c\u0a3f\u0a32", 75);
    freq.put("\u0a07\u0a06", 135);
    freq.put("R", 24);
    freq.put("\u0a3c\u0a3f\u0a06", 14);
    freq.put("\u0a07\u0a32", 37);
    freq.put("\u0a05\u0a2a", 47);
    freq.put("\u0a07\u0a39", 542);
    freq.put("\u0a07\u0a38", 741);
    freq.put("\u0a1c\u0a3f\u0a70", 30);
    freq.put("\u0a07\u0a24", 25);
    freq.put("\u0a07\u0a23", 62);
    freq.put("\u0a30\u0a2c\u0a40", 20);
    freq.put("\u0a05\u0a27", 17);
    freq.put("\u0a07\u0a28", 48);
    freq.put("\u0a28\u0a39\u0a40", 36);
    freq.put("\u0a26\u0a3f ", 15);
    freq.put("\u0a1f\u0a3e ", 22);
    freq.put("\u0a30\u0a3e\u0a02", 87);
    freq.put("\u0a3f\u0a2c ", 69);
    freq.put("\u0a38\u0a38 ", 13);
    freq.put("\u0a30\u0a3e\u0a1c", 89);
    freq.put("\u0a41\u0a30\u0a42", 142);
    freq.put("\u0a21", 853);
    freq.put("\u0a30\u0a3e\u0a28", 31);
    freq.put("\u0a1c\u0a3e\u0a26", 21);
    freq.put("\u0a30\u0a3e\u0a2c", 13);
    freq.put("\u0a2c ", 211);
    freq.put("\u0a30\u0a3e\u0a2e", 35);
    freq.put("\u0a30\u0a3e\u0a23", 19);
    freq.put("\u0a30\u0a3e\u0a39", 24);
    freq.put("\u0a30\u0a3e\u0a38", 25);
    freq.put("\u0a1c\u0a3e\u0a23", 55);
    freq.put("\u0a70\u0a17 ", 69);
    freq.put("\u0a2e\u0a41", 499);
    freq.put("\u0a3f\u0a0a\u0a1f", 14);
    freq.put("\u0a1a\u0a70\u0a26", 21);
    freq.put("\u0a30\u0a3e\u0a35", 14);
    freq.put("\u0a05\u0a2e ", 45);
    freq.put("\u0a17\u0a3e ", 22);
    freq.put("\u0a2e\u0a47", 59);
    freq.put("\u0a41\u0a30\u0a38", 21);
    freq.put("\u0a41\u0a30\u0a3e", 23);
    freq.put("\u0a67\u0a6a", 15);
    freq.put("\u0a24\u0a4c\u0a30", 15);
    freq.put("\u0a41\u0a30\u0a26", 34);
    freq.put(" \u0a35\u0a3e", 793);
    freq.put(" \u0a35\u0a3f", 1204);
    freq.put(" \u0a35\u0a38", 13);
    freq.put("\u0a24\u0a38", 17);
    freq.put("\u0a25\u0a3f\u0a39", 26);
    freq.put(" \u0a35\u0a30", 63);
    freq.put("\u0a25\u0a3f\u0a24", 12);
    freq.put(" \u0a35\u0a27", 14);
    freq.put("\u0a24\u0a71\u0a24", 53);
    freq.put("\u0a24\u0a35", 19);
    freq.put("\u0a24", 3377);
    freq.put(" \u0a35\u0a16", 19);
    freq.put(" is", 12);
    freq.put("\u0a40\u0a35\u0a30", 32);
    freq.put(" \u0964 ", 128);
    freq.put("\u0a40\u0a35\u0a28", 13);
    freq.put(" in", 40);
    freq.put("\u0a71\u0a24 ", 62);
    freq.put(" \u0a35\u0a70", 18);
    freq.put(" \u0a35\u0a71", 108);
    freq.put("\u0a32\u0a47\u0a16", 15);
    freq.put("\u0a28 ", 1907);
    freq.put("\u0a4b\u0a2c\u0a3f", 25);
    freq.put("ng ", 24);
    freq.put("h", 252);
    freq.put("\u0a35\u0a47 ", 16);
    freq.put(" \u0a35\u0a48", 16);
    freq.put("\u0a3f", 5178);
    freq.put(" \u0a35\u0a47", 12);
    freq.put(" \u0a35\u0a40", 103);
    freq.put("\u0a40\u0a02", 64);
    freq.put("\u0a06\u0a16", 12);
    freq.put("\u0a41\u0a24\u0a3e", 380);
    freq.put("\u0a26\u0a32", 21);
    freq.put("\u0a0f", 233);
    freq.put(" \u0a06 ", 21);
    freq.put("Ol", 12);
    freq.put("\u0a06\u0a07", 12);
    freq.put("\u0a06\u0a09", 22);
    freq.put("\u0a06\u0a30", 95);
    freq.put("\u0a32\u0a40 ", 116);
    freq.put("\u0a06\u0a32", 16);
    freq.put("\u0a35\u0a32 ", 18);
    freq.put("\u0a06\u0a35", 17);
    freq.put(" \u0a27\u0a30", 56);
    freq.put("\u0a06\u0a38", 22);
    freq.put("\u0a08\u0a28\u0a3e", 22);
    freq.put("\u0a32\u0a3f\u0a16", 25);
    freq.put("\u0a26\u0a38", 57);
    freq.put("\u0a06\u0a23", 33);
    freq.put("\u0a39\u0a28\u0a3e", 25);
    freq.put("\u0a06\u0a26", 35);
    freq.put("\u0a06\u0a28", 54);
    freq.put("\u0a3e\u0964 ", 18);
    freq.put("\u0a06\u0a2a", 78);
    freq.put("\u0a3f\u0a16\u0a3e", 19);
    freq.put("\u0a32\u0a3f\u0a06", 33);
    freq.put("\u0a3f\u0a16\u0a47", 23);
    freq.put("\u0a2a\u0a30\u0a2e", 113);
    freq.put("S", 55);
    freq.put("\u0a39\u0a3f ", 31);
    freq.put("\u0a3e\u0a17\u0a30", 20);
    freq.put(" \u0a15\u0a48", 22);
    freq.put("\u0a30\u0a23 ", 20);
    freq.put("ck", 12);
    freq.put("\u0a21 ", 132);
    freq.put("ch", 22);
    freq.put("co", 29);
    freq.put("\u0a3f\u0a32\u0a26", 12);
    freq.put("ca", 15);
    freq.put("\u0a30\u0a4b\u0a5c", 12);
    freq.put("\u0a3f\u0a32\u0a3e", 83);
    freq.put("\u0a1b\u0a4b\u0a1f", 13);
    freq.put("\u0a0a\u0a1f", 14);
    freq.put("\u0a38\u0a26\u0a3e", 17);
    freq.put("cs", 14);
    freq.put("\u0a25\u0a47 ", 48);
    freq.put("\u0a40\u0a2a ", 375);
    freq.put("ct", 18);
    freq.put("\u0a41\u0a06", 59);
    freq.put("\u0a24\u0a30 ", 83);
    freq.put("\u0a1c\u0a28\u0a35", 39);
    freq.put("\u0a0f\u0a2b", 13);
    freq.put("\u0a0f\u0a28", 15);
    freq.put("c ", 16);
    freq.put("\u0a30\u0a4b\u0a1c", 15);
    freq.put("\u0a1c\u0a28\u0a38", 13);
    freq.put("\u0a2a\u0a3e\u0a15", 32);
    freq.put("\u0a0f\u0a38", 17);
    freq.put("\u0a1c\u0a28\u0a2e", 32);
    freq.put("\u0a40\u0a24 ", 15);
    freq.put("\u0a0f\u0a32", 14);
    freq.put("\u0a2a\u0a3e\u0a23", 18);
    freq.put("\u0a42\u0a38", 23);
    freq.put("\u0a3f\u0a32\u0a4d", 13);
    freq.put("\u0a3f\u0a32\u0a4b", 46);
    freq.put("\u0a38\u0a26\u0a40", 15);
    freq.put("\u0a38\u0a26\u0a47", 13);
    freq.put("\u0a5c\u0a4d\u0a39", 37);
    freq.put("\u0a2a\u0a3e\u0a30", 18);
    freq.put("\u0a2a\u0a3e\u0a38", 19);
    freq.put("\u0a30\u0a4b\u0a2e", 30);
    freq.put("\u0a2c\u0a3e\u0a2c", 12);
    freq.put("\u0a3c\u0a35", 12);
    freq.put("ve", 29);
    freq.put("\u0a15\u0a08 ", 21);
    freq.put("\u0a3c\u0a3e", 203);
    freq.put("\u0a16\u0a47 ", 23);
    freq.put("\u0a3e\u0a39\u0a40", 40);
    freq.put("\u0a2c\u0a3e\u0a26", 22);
    freq.put("\u0a3c\u0a38", 37);
    freq.put("\u0a3c\u0a39", 70);
    freq.put("\u0a3c\u0a24", 27);
    freq.put("\u0a3c\u0a2e", 21);
    freq.put("\u0a3c\u0a2c", 33);
    freq.put("\u0a2c\u0a3e\u0a30", 32);
    freq.put("\u0a3c\u0a28", 40);
    freq.put("\u0a2c\u0a3e\u0a32", 27);
    freq.put("\u0a3c\u0a16", 29);
    freq.put("of ", 41);
    freq.put("\u0a25", 271);
    freq.put("\u0a2c\u0a3e\u0a08", 14);
    freq.put("\u0a2c\u0a3e\u0a05", 27);
    freq.put("\u0a3c\u0a1f", 24);
    freq.put("\u0a2c\u0a3e\u0a15", 372);
    freq.put("\u0a48\u0964", 922);
    freq.put("\u0a38\u0a28\u0a42", 15);
    freq.put("\u0a1c\u0a70\u0a24", 20);
    freq.put("\u0a4b\u0a07\u0a06", 71);
    freq.put("\u0a2c\u0a32\u0a3e", 20);
    freq.put("ion", 36);
    freq.put("\u0a2a ", 461);
    freq.put("\u0a1f\u0a40\u0a2e", 54);
    freq.put("\u0a47\u0a38 ", 12);
    freq.put("i", 537);
    freq.put("\u0a3e\u0a5c\u0a40", 12);
    freq.put("\u0a3e\u0a39\u0a3f", 88);
    freq.put("\u0a3c\u0a40", 109);
    freq.put(" Th", 15);
    freq.put("\u0a32\u0a08 ", 78);
    freq.put("\u0a70\u0a18 ", 71);
    freq.put("\u0a3c\u0a4b", 16);
    freq.put("\u0a3c\u0a48", 21);
    freq.put("\u0a32\u0a15", 25);
    freq.put("\u0a3f\u0a17\u0a3f", 35);
    freq.put("\u0a32\u0a17", 28);
    freq.put("\u0a06\u0a2a\u0a23", 51);
    freq.put("\u0a0f\u0964", 33);
    freq.put("\u0a32\u0a1a", 23);
    freq.put(" \u0a26\u0a41", 51);
    freq.put(" \u0a26\u0a40", 419);
    freq.put(" \u0a26\u0a42", 37);
    freq.put(" \u0a26\u0a47", 1425);
    freq.put(" \u0a26\u0a4b", 31);
    freq.put("\u0a32\u0a08", 79);
    freq.put("\u0a3e\u0a2e ", 62);
    freq.put(" \u0a26\u0a71", 14);
    freq.put("\u0a32\u0a35", 25);
    freq.put("\u0a32\u0a3e", 368);
    freq.put("\u0a32\u0a3f", 106);
    freq.put("\u0a32\u0a39", 12);
    freq.put("\u0a32\u0a24", 16);
    freq.put("\u0a32\u0a26", 24);
    freq.put("\u0a32\u0a23", 25);
    freq.put("\u0a32\u0a2c", 13);
    freq.put("\u0a38", 5034);
    freq.put("\u0a32\u0a2e", 25);
    freq.put("\u0a32\u0a5c", 14);
    freq.put("\u0a28\u0a47\u0a1c", 20);
    freq.put("\u0a32\u0a3e\u0a35", 16);
    freq.put(" \u0a67\u0a6e", 24);
    freq.put("\u0a30\u0a40 ", 651);
    freq.put("\u0a32\u0a40", 580);
    freq.put("T", 45);
    freq.put(" \u0a67\u0a6f", 41);
    freq.put("\u0a32\u0a4d", 24);
    freq.put("\u0a32\u0a48", 43);
    freq.put("\u0a66\u0a66 ", 21);
    freq.put(" \u0a26\u0a30", 56);
    freq.put("\u0a32\u0a70", 416);
    freq.put("\u0a32\u0a71", 23);
    freq.put(" \u0a26\u0a38", 54);
    freq.put(" \u0a26\u0a3f", 1171);
    freq.put(" \u0a26\u0a3e", 950);
    freq.put("\u0a32\u0a3e\u0a08", 52);
    freq.put(" \u0a67\u0a68", 16);
    freq.put("\u0a23\u0a47 ", 51);
    freq.put("\u0a32\u0a3e\u0a02", 56);
    freq.put("igh", 12);
    freq.put("a ", 87);
    freq.put("\u0a24\u0a15 ", 19);
    freq.put("\u0a30\u0a15\u0a47", 20);
    freq.put("\u0a3e\u0a24\u0a40", 12);
    freq.put("\u0a23", 777);
    freq.put("nd ", 32);
    freq.put("\u0a26\u0a38\u0a70", 39);
    freq.put("\u0a1c\u0a48", 24);
    freq.put("pr", 12);
    freq.put("\u0a48\u0a1f", 17);
    freq.put("\u0a39\u0a48", 1355);
    freq.put("\u0a2e\u0a3f\u0a15", 21);
    freq.put("\u0a48\u0a17", 377);
    freq.put("\u0a2a\u0a41\u0a30", 63);
    freq.put("\u0a48\u0a15", 39);
    freq.put("\u0a48\u0a02", 49);
    freq.put("\u0a38\u0a25\u0a3e", 37);
    freq.put("\u0a38\u0a25\u0a3f", 13);
    freq.put("\u0a18\u0a30", 19);
    freq.put("\u0a15\u0a40 ", 396);
    freq.put("ndi", 15);
    freq.put("\u0a48\u0a38", 23);
    freq.put("\u0a2e\u0a3f\u0a38", 19);
    freq.put("\u0a38\u0a28\u0964", 37);
    freq.put("\u0a16\u0a47\u0a24", 37);
    freq.put("\u0a3e\u0a24\u0a30", 17);
    freq.put("\u0a48\u0a30", 17);
    freq.put("\u0a16\u0a47\u0a21", 37);
    freq.put("\u0a2e\u0a3f\u0a32", 41);
    freq.put("\u0a39\u0a41", 520);
    freq.put("\u0a30\u0a15\u0a3e", 23);
    freq.put("\u0a1f\u0a40 ", 57);
    freq.put("es ", 28);
    freq.put("\u0a2e\u0a3f\u0a25", 28);
    freq.put("\u0a41\u0a15\u0a3e", 27);
    freq.put("\u0a48\u0a26", 24);
    freq.put("\u0a3c\u0a40 ", 81);
    freq.put("\u0a2e\u0a08", 41);
    freq.put("\u0a71\u0a32 ", 23);
    freq.put("\u0a39\u0a42", 17);
    freq.put("\u0a09\u0a39 ", 40);
    freq.put("\u0a15\u0a28\u0a40", 13);
    freq.put(" \u0a1f\u0a30", 13);
    freq.put("\u0a2e\u0a1c", 12);
    freq.put("\u0a32\u0a1a\u0a30", 23);
    freq.put("h ", 33);
    freq.put("\u0a39\u0a3e ", 59);
    freq.put("\u0a2e\u0a15", 17);
    freq.put("\u0a2e\u0a28", 98);
    freq.put("\u0a24\u0a42\u0a2c", 34);
    freq.put("\u0a2e\u0a24", 30);
    freq.put("\u0a2e\u0a26", 18);
    freq.put("\u0a2e\u0a38", 29);
    freq.put("\u0a2e\u0a39", 96);
    freq.put("\u0a2e\u0a3e", 391);
    freq.put("\u0a05\u0a28\u0a41", 13);
    freq.put("\u0a2e\u0a30", 69);
    freq.put("\u0a35\u0a3f\u0a17", 34);
    freq.put("\u0a2e\u0a32", 18);
    freq.put("\u0a30\u0a24 ", 82);
    freq.put("\u0a2e\u0a48", 49);
    freq.put("\u0a2e\u0a4b", 28);
    freq.put("\u0a2e\u0a4c", 19);
    freq.put("\u0a2e\u0a4d", 15);
    freq.put("\u0a2e\u0a40", 82);
    freq.put("\u0a39 ", 633);
    freq.put("\u0a2e\u0a42", 19);
    freq.put("ht", 18);
    freq.put("hu", 17);
    freq.put("\u0a4b\u0a30 ", 44);
    freq.put("hi", 29);
    freq.put("ho", 16);
    freq.put("ha", 27);
    freq.put("he", 95);
    freq.put("\u0a24\u0a4c\u0a02", 25);
    freq.put("\u0964", 1840);
    freq.put("\u0a4d\u0a39\u0a3e", 96);
    freq.put("j", 16);
    freq.put("\u0a28\u0a38", 36);
    freq.put(" \u0a32\u0a4b", 37);
    freq.put("\u0a1c ", 145);
    freq.put("\u0a2e\u0a70", 60);
    freq.put("\u0a2e\u0a71", 15);
    freq.put(" \u0a1f\u0a40", 56);
    freq.put("\u0a23\u0a3e\u0a07", 20);
    freq.put("\u0a30\u0a2e\u0a3e", 139);
    freq.put("pic", 12);
    freq.put("\u0a66 ", 87);
    freq.put("\u0a30\u0a2e\u0a28", 15);
    freq.put("\u0a28\u0a39", 40);
    freq.put("\u0a41\u0a15", 56);
    freq.put("\u0a41\u0a16", 20);
    freq.put("ine", 16);
    freq.put("ing", 33);
    freq.put("\u0a41\u0a1d", 24);
    freq.put("\u0a41\u0a1c", 22);
    freq.put("\u0a41\u0a1f", 25);
    freq.put("\u0a41\u0a23", 26);
    freq.put("\u0a32\u0a70\u0a2a", 29);
    freq.put("\u0a02 ", 2409);
    freq.put("\u0a41\u0a24", 412);
    freq.put("\u0a41\u0a26", 13);
    freq.put("\u0a41\u0a28", 42);
    freq.put("\u0a41\u0a2e", 18);
    freq.put("\u0a41\u0a30", 279);
    freq.put("\u0a41\u0a32", 97);
    freq.put("es", 53);
    freq.put("\u0a39", 4455);
    freq.put("\u0a3e\u0a38\u0a3c", 82);
    freq.put("\u0a3e\u0a38\u0a3f", 34);
    freq.put("\u0a3e\u0a38\u0a47", 16);
    freq.put("\u0a13\u0a32\u0a70", 29);
    freq.put("U", 14);
    freq.put("\u0a3c\u0a39\u0a3f", 50);
    freq.put("in ", 38);
    freq.put("\u0a27\u0a30\u0a2e", 31);
    freq.put("\u0a27\u0a30\u0a24", 22);
    freq.put("\u0a39\u0a28\u0964", 438);
    freq.put("\u0a41\u0a71", 117);
    freq.put("\u0a41\u0a70", 490);
    freq.put("\u0a1a\u0a3e ", 12);
    freq.put("\u0a06\u0964", 54);
  }
  
}

