package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class NO extends CLangProfile {
  private static final String name = "no";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public NO() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 20399254;
    n_words[1] = 23799460;
    n_words[2] = 17069273;

    freq.put("aug", 3319);
    freq.put("øre", 10636);
    freq.put("lt ", 21046);
    freq.put("aut", 2096);
    freq.put("ørt", 2899);
    freq.put("pte", 2999);
    freq.put("ørs", 12878);
    freq.put(" Gu", 4458);
    freq.put(" Gr", 7534);
    freq.put("Joh", 2414);
    freq.put(" Ge", 3655);
    freq.put(" Ga", 4247);
    freq.put(" Go", 2524);
    freq.put("Gu", 4480);
    freq.put("Gr", 7570);
    freq.put("ør ", 13261);
    freq.put("Ge", 3683);
    freq.put("red", 9285);
    freq.put("Ga", 4272);
    freq.put("Go", 2542);
    freq.put("vær", 6865);
    freq.put("upp", 6292);
    freq.put(" ka", 20700);
    freq.put("me ", 8290);
    freq.put("ød ", 7105);
    freq.put(" kj", 12239);
    freq.put(" ki", 10103);
    freq.put(" ko", 42531);
    freq.put(" kl", 4277);
    freq.put(" km", 9490);
    freq.put(" kr", 10076);
    freq.put(" kv", 4363);
    freq.put(" ku", 8567);
    freq.put("nen", 27435);
    freq.put("nel", 12450);
    freq.put("ned", 4860);
    freq.put("kur", 2362);
    freq.put("kun", 5248);
    freq.put("slo", 6037);
    freq.put("ørø", 2134);
    freq.put("net", 21165);
    freq.put("ak ", 2688);
    freq.put("ner", 33385);
    freq.put("nes", 25627);
    freq.put("sli", 3561);
    freq.put("med", 37095);
    freq.put("øde", 3134);
    freq.put("orr", 3175);
    freq.put("men", 33002);
    freq.put("ors", 26414);
    freq.put("met", 13813);
    freq.put("ødt", 21901);
    freq.put("mes", 7734);
    freq.put("mer", 33081);
    freq.put(" Un", 4794);
    freq.put("aks", 3242);
    freq.put("gla", 3596);
    freq.put("k", 716879);
    freq.put("gle", 2190);
    freq.put("ne ", 72733);
    freq.put("akt", 7856);
    freq.put("akk", 3187);
    freq.put("orm", 10647);
    freq.put("sjo", 34525);
    freq.put("dra", 3627);
    freq.put("dre", 18932);
    freq.put("ake", 6088);
    freq.put("sje", 5058);
    freq.put("Kom", 2130);
    freq.put("Kon", 2546);
    freq.put("bru", 13492);
    freq.put("bri", 5623);
    freq.put("bre", 4128);
    freq.put("bra", 2313);
    freq.put("m ", 148254);
    freq.put("dni", 2776);
    freq.put("vol", 2228);
    freq.put("er ", 431766);
    freq.put("ni ", 4401);
    freq.put("Ste", 2680);
    freq.put("Sta", 5059);
    freq.put("Sto", 5079);
    freq.put("nkr", 4191);
    freq.put("Str", 2300);
    freq.put("V", 29381);
    freq.put("me", 153343);
    freq.put("eru", 2639);
    freq.put("erv", 4618);
    freq.put("mf", 5780);
    freq.put("ma", 52812);
    freq.put("ltu", 2394);
    freq.put("err", 6355);
    freq.put("mb", 14541);
    freq.put("mm", 59754);
    freq.put("ml", 5863);
    freq.put("mo", 24316);
    freq.put("mn", 2923);
    freq.put("mi", 35740);
    freq.put("mk", 2245);
    freq.put("mu", 35413);
    freq.put("mt", 8238);
    freq.put("erf", 5751);
    freq.put("erg", 11340);
    freq.put("mp", 15073);
    freq.put("ms", 13233);
    freq.put("mr", 8156);
    freq.put("erl", 6414);
    freq.put("erm", 4003);
    freq.put("ern", 17742);
    freq.put("ero", 2745);
    freq.put("my", 4118);
    freq.put("eri", 32585);
    freq.put("erk", 15694);
    freq.put("ygg", 10777);
    freq.put("Le", 5322);
    freq.put("La", 9531);
    freq.put("Lo", 6840);
    freq.put("uar", 4525);
    freq.put("la ", 5793);
    freq.put("Li", 8435);
    freq.put("Lu", 3278);
    freq.put("uan", 2334);
    freq.put("ena", 2893);
    freq.put("end", 24201);
    freq.put("ene", 43923);
    freq.put("enf", 4002);
    freq.put("eng", 13869);
    freq.put("enh", 3807);
    freq.put("eni", 5336);
    freq.put("hol", 9462);
    freq.put("enk", 3130);
    freq.put("enn", 18704);
    freq.put("a\u030ale", 2191);
    freq.put("hov", 6717);
    freq.put("Kar", 2117);
    freq.put("ens", 38448);
    freq.put("ent", 42518);
    freq.put("m2", 2226);
    freq.put("A", 51244);
    freq.put("lan", 58009);
    freq.put("L ", 8381);
    freq.put("lad", 2570);
    freq.put("lag", 17793);
    freq.put("fat", 5769);
    freq.put("ove", 25154);
    freq.put("lat", 7640);
    freq.put("lav", 2641);
    freq.put("ovi", 8837);
    freq.put("lar", 3088);
    freq.put("las", 9906);
    freq.put("ma\u030a", 7691);
    freq.put("a\u030al ", 2493);
    freq.put("mø", 2258);
    freq.put(" Hu", 4096);
    freq.put(" Hi", 2663);
    freq.put("oni", 5288);
    freq.put(" Ho", 7447);
    freq.put(" Ha", 15503);
    freq.put(" He", 10039);
    freq.put("fir", 2657);
    freq.put("fis", 4937);
    freq.put("jør", 5841);
    freq.put("ime", 2903);
    freq.put("rø", 14616);
    freq.put("ra\u030a", 14698);
    freq.put("jøe", 2169);
    freq.put(" ga", 9278);
    freq.put("fik", 2963);
    freq.put("fin", 6087);
    freq.put("fil", 5351);
    freq.put(" Va", 4882);
    freq.put(" Ve", 9942);
    freq.put(" Vi", 7397);
    freq.put("ma\u030al", 4336);
    freq.put("SA ", 4753);
    freq.put("sjø", 3410);
    freq.put("oks", 3517);
    freq.put("im ", 2951);
    freq.put("den", 73325);
    freq.put("l", 1037936);
    freq.put("\u0441", 2244);
    freq.put("nt ", 24653);
    freq.put("tør", 7504);
    freq.put("rt", 82606);
    freq.put("ru", 50990);
    freq.put("rv", 11610);
    freq.put("gv", 2904);
    freq.put("rp", 5076);
    freq.put("rr", 19009);
    freq.put("rs", 78883);
    freq.put("dst", 4471);
    freq.put("ry", 11156);
    freq.put("rd", 66008);
    freq.put("re", 256059);
    freq.put("rf", 12509);
    freq.put("rg", 35522);
    freq.put("ra", 128776);
    freq.put("rb", 18116);
    freq.put("rc", 4262);
    freq.put("rl", 20062);
    freq.put("rm", 21775);
    freq.put("rn", 31836);
    freq.put("is ", 12915);
    freq.put("rh", 6919);
    freq.put("ri", 132605);
    freq.put("sma", 2688);
    freq.put("rk", 47716);
    freq.put("nty", 8509);
    freq.put("Sve", 3734);
    freq.put("ntr", 8273);
    freq.put("nti", 5299);
    freq.put("ntl", 2516);
    freq.put("W", 15084);
    freq.put("nta", 6663);
    freq.put("nte", 28676);
    freq.put("ate", 21584);
    freq.put("øst", 12196);
    freq.put("ata", 4831);
    freq.put("iss", 5696);
    freq.put("ato", 4866);
    freq.put("Vin", 2983);
    freq.put("ist", 35845);
    freq.put("isk", 51560);
    freq.put("isj", 4819);
    freq.put("isi", 4522);
    freq.put("atu", 5294);
    freq.put("r ", 604948);
    freq.put("ats", 2979);
    freq.put("ism", 2335);
    freq.put("isa", 4298);
    freq.put("ise", 12425);
    freq.put("nhe", 2871);
    freq.put("ukt", 5470);
    freq.put("tei", 3878);
    freq.put("on ", 35130);
    freq.put("nis", 15475);
    freq.put("tem", 9786);
    freq.put("tor", 21379);
    freq.put("tok", 6614);
    freq.put("ton", 7030);
    freq.put("tol", 4307);
    freq.put("tob", 2085);
    freq.put("kt ", 12793);
    freq.put(" le", 11218);
    freq.put("B", 53160);
    freq.put(" la", 25410);
    freq.put(" lo", 3520);
    freq.put(" li", 27765);
    freq.put(" lu", 2098);
    freq.put("Ve", 9972);
    freq.put("ktu", 4360);
    freq.put("i\u0301", 2375);
    freq.put("kto", 3659);
    freq.put("kti", 6575);
    freq.put("mst", 3459);
    freq.put("kte", 10988);
    freq.put("to ", 8546);
    freq.put("raf", 12560);
    freq.put("rag", 2711);
    freq.put("rad", 5981);
    freq.put("lbu", 3945);
    freq.put("\u4e09", 3026);
    freq.put("ral", 8750);
    freq.put("ram", 7456);
    freq.put("ty ", 11596);
    freq.put("rak", 4191);
    freq.put("rav", 3015);
    freq.put("rat", 9184);
    freq.put("ras", 7043);
    freq.put("ypr", 2466);
    freq.put("ype", 2571);
    freq.put("x ", 3406);
    freq.put(" la\u0308", 2565);
    freq.put("ra ", 37023);
    freq.put("y", 203712);
    freq.put("typ", 2478);
    freq.put("tyr", 5657);
    freq.put(" lø", 2099);
    freq.put("tse", 4787);
    freq.put("don", 4573);
    freq.put("dom", 4754);
    freq.put("m", 608425);
    freq.put("ogn", 3334);
    freq.put(" We", 2962);
    freq.put(" Wa", 4211);
    freq.put("d ", 150657);
    freq.put(" Wi", 3744);
    freq.put("oge", 2102);
    freq.put("ock", 4853);
    freq.put("em ", 6695);
    freq.put("kul", 5655);
    freq.put("dn", 4555);
    freq.put("do", 17360);
    freq.put("dl", 19375);
    freq.put("dm", 5071);
    freq.put("dk", 3004);
    freq.put("dh", 3225);
    freq.put("di", 40822);
    freq.put("df", 2274);
    freq.put("dd", 13784);
    freq.put("de", 299418);
    freq.put("db", 3584);
    freq.put("da", 47371);
    freq.put("dy", 4144);
    freq.put("dv", 5679);
    freq.put("X", 3613);
    freq.put("dt", 33464);
    freq.put("du", 13333);
    freq.put("dr", 31419);
    freq.put("ds", 31560);
    freq.put("eme", 6179);
    freq.put("lds", 2282);
    freq.put("bar", 6636);
    freq.put("bas", 4309);
    freq.put("emb", 7048);
    freq.put("emm", 4042);
    freq.put("emo", 2614);
    freq.put("emi", 3720);
    freq.put("emp", 3266);
    freq.put("ems", 2210);
    freq.put("ban", 9995);
    freq.put("bal", 7414);
    freq.put("bak", 3210);
    freq.put("om ", 107366);
    freq.put("w ", 4541);
    freq.put(" I ", 6572);
    freq.put("nua", 2135);
    freq.put("il ", 45404);
    freq.put("un ", 3708);
    freq.put("co ", 2205);
    freq.put("irk", 9296);
    freq.put("mel", 15249);
    freq.put("Rus", 2959);
    freq.put("mun", 25496);
    freq.put("ire", 7035);
    freq.put("omb", 2444);
    freq.put("we", 2854);
    freq.put("omf", 2921);
    freq.put("wa", 4985);
    freq.put("omi", 3410);
    freq.put(" Is", 2884);
    freq.put("wi", 2306);
    freq.put("oms", 5919);
    freq.put("omr", 6915);
    freq.put("omp", 3178);
    freq.put(" In", 7378);
    freq.put("Ø", 5129);
    freq.put("elo", 2842);
    freq.put("gge", 29980);
    freq.put("ild", 3649);
    freq.put("ile", 4123);
    freq.put("unt", 9250);
    freq.put("ell", 56973);
    freq.put("ilo", 2911);
    freq.put("ill", 23109);
    freq.put("ilm", 4862);
    freq.put("ilk", 2217);
    freq.put("ilh", 3403);
    freq.put("ili", 8732);
    freq.put("ilt", 4137);
    freq.put("und", 31193);
    freq.put("ils", 3090);
    freq.put("ung", 4670);
    freq.put("ir ", 6919);
    freq.put("uni", 6920);
    freq.put("unk", 3135);
    freq.put("unn", 14136);
    freq.put(" me", 70036);
    freq.put(" ma", 17890);
    freq.put(" mo", 13920);
    freq.put(" mi", 10095);
    freq.put(" mu", 6899);
    freq.put("ele", 18548);
    freq.put(" my", 2654);
    freq.put("san", 6993);
    freq.put("fra", 35021);
    freq.put("fre", 5013);
    freq.put("rga", 6400);
    freq.put("fri", 6048);
    freq.put("C ", 3097);
    freq.put("gn ", 3125);
    freq.put("ai ", 3427);
    freq.put("sso", 3173);
    freq.put("dsk", 5623);
    freq.put("Ch", 7594);
    freq.put("Co", 15888);
    freq.put("anu", 3347);
    freq.put("slu", 2332);
    freq.put("Ca", 9043);
    freq.put("n", 1640496);
    freq.put("ain", 3128);
    freq.put("elt", 17365);
    freq.put("gne", 11554);
    freq.put("sle", 4538);
    freq.put("gni", 2494);
    freq.put("sla", 9825);
    freq.put(" ma\u030a", 3587);
    freq.put("ip", 8856);
    freq.put("is", 145060);
    freq.put("ir", 32357);
    freq.put("iu", 3847);
    freq.put("it", 66902);
    freq.put("iv", 28029);
    freq.put("ii", 2629);
    freq.put("ik", 79231);
    freq.put("ij", 2484);
    freq.put("im", 14324);
    freq.put("il", 114997);
    freq.put("io", 25793);
    freq.put("in", 224355);
    freq.put("ia", 42013);
    freq.put("ic", 16512);
    freq.put("ib", 6764);
    freq.put("ie", 49167);
    freq.put("id", 53829);
    freq.put("ig", 91825);
    freq.put("if", 12391);
    freq.put("V ", 2848);
    freq.put("dri", 5473);
    freq.put("th ", 3609);
    freq.put("a\u0308n", 3083);
    freq.put("nik", 2124);
    freq.put("nin", 25664);
    freq.put("kis", 2484);
    freq.put("kir", 5305);
    freq.put("kip", 2377);
    freq.put("kin", 8354);
    freq.put("kil", 3815);
    freq.put("Y", 5384);
    freq.put("i ", 283647);
    freq.put("niv", 5311);
    freq.put("nit", 2397);
    freq.put("mil", 8071);
    freq.put("Va", 4893);
    freq.put("a\u0308n ", 2530);
    freq.put("Vi", 7414);
    freq.put("ept", 2696);
    freq.put("epu", 5041);
    freq.put("epr", 2644);
    freq.put("the", 4578);
    freq.put("epa", 2788);
    freq.put("yen", 9116);
    freq.put("rn ", 5061);
    freq.put("yer", 2533);
    freq.put("eli", 14582);
    freq.put("hal", 3654);
    freq.put("ham", 3082);
    freq.put("han", 12460);
    freq.put("Os", 6058);
    freq.put("ela", 6680);
    freq.put("had", 4958);
    freq.put("elg", 2392);
    freq.put("eld", 5215);
    freq.put("Or", 3270);
    freq.put("els", 37467);
    freq.put("har", 25645);
    freq.put("elv", 10426);
    freq.put("hav", 6160);
    freq.put("opp", 20548);
    freq.put("D", 67298);
    freq.put("Tro", 3352);
    freq.put("ye ", 2367);
    freq.put("rna", 5941);
    freq.put("rne", 13070);
    freq.put("ope", 3654);
    freq.put("opa", 2135);
    freq.put("vis", 10758);
    freq.put("ha ", 2473);
    freq.put("el ", 17607);
    freq.put("ola", 2381);
    freq.put("old", 10833);
    freq.put("ole", 9725);
    freq.put(" Ju", 2284);
    freq.put("oli", 8827);
    freq.put("olk", 9387);
    freq.put("oll", 6799);
    freq.put("olm", 2556);
    freq.put("olo", 8072);
    freq.put(" Jo", 5426);
    freq.put("ols", 3475);
    freq.put(" Je", 2895);
    freq.put("oly", 3133);
    freq.put(" Ja", 4943);
    freq.put("fot", 5733);
    freq.put("ich", 3831);
    freq.put("for", 85448);
    freq.put("ykk", 3634);
    freq.put("ica", 2979);
    freq.put("Hu", 4099);
    freq.put("ume", 4177);
    freq.put("Hi", 2665);
    freq.put("Ho", 7455);
    freq.put("fol", 6844);
    freq.put("Ha", 15522);
    freq.put("He", 10062);
    freq.put("ol ", 2411);
    freq.put(" Xi", 2228);
    freq.put("sa ", 2445);
    freq.put("pla", 9218);
    freq.put("obl", 2263);
    freq.put("obe", 3133);
    freq.put("o", 1106000);
    freq.put("um ", 8855);
    freq.put("ppe", 9671);
    freq.put("mbe", 7011);
    freq.put("som", 85971);
    freq.put("sol", 2063);
    freq.put("son", 9679);
    freq.put("ppr", 5964);
    freq.put("sor", 2986);
    freq.put("git", 6162);
    freq.put("gis", 5345);
    freq.put("na\u030a", 4464);
    freq.put("næ", 4051);
    freq.put("nø", 2380);
    freq.put("gio", 4769);
    freq.put("gin", 2581);
    freq.put("mt ", 3487);
    freq.put("pp ", 3799);
    freq.put("A\u030a", 2838);
    freq.put(" na\u030a", 3726);
    freq.put(" næ", 2896);
    freq.put("Z", 4254);
    freq.put("gi ", 3980);
    freq.put("nno", 3889);
    freq.put("nnl", 4919);
    freq.put("nnk", 2501);
    freq.put("nni", 5129);
    freq.put("kor", 5874);
    freq.put("nne", 42931);
    freq.put("nnb", 5914);
    freq.put("nna", 2105);
    freq.put("nns", 7691);
    freq.put("nke", 3676);
    freq.put("nh", 6700);
    freq.put("ni", 70736);
    freq.put("nj", 3359);
    freq.put("nk", 18937);
    freq.put("nl", 14559);
    freq.put("nm", 3689);
    freq.put("nn", 98330);
    freq.put("no", 52873);
    freq.put("tit", 4010);
    freq.put("na", 63523);
    freq.put("nb", 10179);
    freq.put("nc", 6842);
    freq.put("nd", 155382);
    freq.put("ne", 210727);
    freq.put("nf", 8666);
    freq.put("ng", 145804);
    freq.put("til", 54443);
    freq.put("ny", 13664);
    freq.put("tin", 10509);
    freq.put("tio", 5365);
    freq.put("tik", 6372);
    freq.put("tid", 14688);
    freq.put("tie", 3348);
    freq.put("nr", 3026);
    freq.put("ns", 124075);
    freq.put("nt", 92694);
    freq.put("nu", 7442);
    freq.put("nv", 3459);
    freq.put("E", 31132);
    freq.put(" no", 33974);
    freq.put("kva", 2672);
    freq.put(" na", 12532);
    freq.put(" ne", 7120);
    freq.put("nn ", 14981);
    freq.put(" ny", 3021);
    freq.put("n ", 508629);
    freq.put("mme", 31877);
    freq.put("Sør", 3934);
    freq.put("rk ", 15343);
    freq.put("ti ", 4056);
    freq.put("rol", 4308);
    freq.put("rom", 6997);
    freq.put("ron", 6959);
    freq.put("lls", 3758);
    freq.put("oss", 3129);
    freq.put("rod", 9193);
    freq.put("ost", 4414);
    freq.put("rof", 2729);
    freq.put("rog", 4064);
    freq.put("osi", 2968);
    freq.put("lli", 10408);
    freq.put("llo", 12212);
    freq.put("rop", 5525);
    freq.put("lla", 5878);
    freq.put("ros", 5462);
    freq.put("ose", 3901);
    freq.put("rov", 9073);
    freq.put("vet", 7953);
    freq.put("ver", 56905);
    freq.put("ves", 12440);
    freq.put("Dan", 2408);
    freq.put("di ", 2586);
    freq.put("veg", 2114);
    freq.put("ved", 23018);
    freq.put("ven", 15144);
    freq.put("vel", 5384);
    freq.put("vem", 2207);
    freq.put("vei", 7599);
    freq.put(" do", 2621);
    freq.put("ey ", 3642);
    freq.put("ro ", 3052);
    freq.put(" Øs", 2807);
    freq.put("os ", 5236);
    freq.put("ll ", 17353);
    freq.put("din", 4634);
    freq.put("dio", 3152);
    freq.put("die", 2789);
    freq.put("ers", 27995);
    freq.put("dia", 3579);
    freq.put("gus", 2418);
    freq.put("p", 350711);
    freq.put("ve ", 6401);
    freq.put("der", 53613);
    freq.put("dis", 11321);
    freq.put("M ", 2289);
    freq.put(" Yo", 2085);
    freq.put("erd", 9568);
    freq.put("ere", 60500);
    freq.put("era", 10673);
    freq.put("Me", 7383);
    freq.put("ngd", 4050);
    freq.put("rua", 2277);
    freq.put("Ma", 15908);
    freq.put("erb", 3057);
    freq.put("kst", 5101);
    freq.put("Mo", 8218);
    freq.put("yde", 4954);
    freq.put("Mi", 7116);
    freq.put("Mu", 2812);
    freq.put("ekn", 2204);
    freq.put("ekk", 7221);
    freq.put("erh", 2771);
    freq.put("bor", 4144);
    freq.put("bok", 3234);
    freq.put("ekt", 15683);
    freq.put("eks", 10659);
    freq.put("ekr", 3313);
    freq.put("tne", 2955);
    freq.put("a\u030al", 6435);
    freq.put("a\u030an", 3530);
    freq.put("a\u030ak", 4798);
    freq.put("a\u030ae", 2573);
    freq.put("a\u030ad", 11397);
    freq.put("ipp", 2048);
    freq.put("ygd", 2788);
    freq.put("Wi", 3769);
    freq.put("a\u030at", 7047);
    freq.put("a\u030ap", 3244);
    freq.put("a\u030as", 2737);
    freq.put("a\u030ar", 24111);
    freq.put("jan", 3394);
    freq.put(" Ka", 7550);
    freq.put(" Ke", 2113);
    freq.put(" Ki", 8813);
    freq.put(" Ko", 7880);
    freq.put(" Kr", 5128);
    freq.put(" Ku", 2108);
    freq.put("ca ", 4720);
    freq.put("øve", 6392);
    freq.put("ngr", 2861);
    freq.put("F", 46085);
    freq.put("a\u030a ", 86331);
    freq.put("ma ", 3762);
    freq.put("Ber", 4934);
    freq.put("a\u0308", 7866);
    freq.put("fly", 4535);
    freq.put("sø", 16304);
    freq.put("ibe", 2226);
    freq.put("ult", 4324);
    freq.put("uli", 4543);
    freq.put("ull", 5554);
    freq.put("fle", 5300);
    freq.put("sa\u030a", 13214);
    freq.put("ms ", 2196);
    freq.put(" ol", 3868);
    freq.put(" om", 17822);
    freq.put(" ok", 2382);
    freq.put("ger", 52848);
    freq.put(" of", 9223);
    freq.put(" og", 141787);
    freq.put("spr", 5617);
    freq.put(" ob", 2162);
    freq.put("rdø", 2401);
    freq.put("spi", 12660);
    freq.put("spo", 8496);
    freq.put(" ov", 11878);
    freq.put("spa", 2392);
    freq.put(" or", 7497);
    freq.put("spe", 5862);
    freq.put(" op", 17267);
    freq.put("ære", 8422);
    freq.put("nyt", 4280);
    freq.put("nyi", 3711);
    freq.put("ært", 3809);
    freq.put("s ", 146195);
    freq.put("mas", 4336);
    freq.put("mar", 11919);
    freq.put("mat", 5209);
    freq.put("use", 8793);
    freq.put("mai", 2118);
    freq.put("mal", 3128);
    freq.put("man", 16587);
    freq.put("sy", 11979);
    freq.put("ær ", 4620);
    freq.put("ss", 49933);
    freq.put("sr", 4235);
    freq.put("sp", 37365);
    freq.put("sv", 19448);
    freq.put("su", 13370);
    freq.put("st", 245546);
    freq.put("q", 3203);
    freq.put("sj", 47719);
    freq.put("si", 74309);
    freq.put("sh", 13228);
    freq.put("so", 108796);
    freq.put("sn", 6441);
    freq.put("sm", 11084);
    freq.put("sl", 28878);
    freq.put("sc", 5435);
    freq.put("sb", 10119);
    freq.put("sa", 44310);
    freq.put("sg", 2307);
    freq.put("sf", 8108);
    freq.put("se", 148118);
    freq.put("sd", 5831);
    freq.put("Ru", 4355);
    freq.put("lse", 19815);
    freq.put("ssk", 3059);
    freq.put("tts", 8940);
    freq.put("no ", 2847);
    freq.put("lsk", 13894);
    freq.put("Re", 6477);
    freq.put("lst", 8591);
    freq.put("Ra", 4607);
    freq.put("tta", 2344);
    freq.put("Ro", 9292);
    freq.put("Ri", 4763);
    freq.put("tte", 44536);
    freq.put(" ad", 3981);
    freq.put("ssa", 2824);
    freq.put(" ak", 3076);
    freq.put(" al", 9858);
    freq.put(" am", 9313);
    freq.put(" an", 19228);
    freq.put(" ap", 2222);
    freq.put(" ar", 13091);
    freq.put(" at", 7530);
    freq.put(" au", 3693);
    freq.put(" av", 89135);
    freq.put("gel", 10922);
    freq.put("nom", 6845);
    freq.put("tje", 3021);
    freq.put("ls ", 2559);
    freq.put("noe", 3540);
    freq.put("ert", 31938);
    freq.put("kke", 25288);
    freq.put("ng ", 54251);
    freq.put("nov", 2911);
    freq.put("ppl", 2678);
    freq.put("nor", 29131);
    freq.put("gt ", 5657);
    freq.put("em", 46141);
    freq.put("el", 199057);
    freq.put("eo", 9834);
    freq.put("en", 582197);
    freq.put("ei", 44782);
    freq.put("eh", 7528);
    freq.put("ek", 50272);
    freq.put("ee", 8701);
    freq.put("ed", 108322);
    freq.put("eg", 49132);
    freq.put("ef", 18320);
    freq.put("ea", 17194);
    freq.put("ec", 4860);
    freq.put("eb", 16045);
    freq.put("ey", 5833);
    freq.put("ex", 3115);
    freq.put("eu", 5509);
    freq.put("et", 320684);
    freq.put("ew", 4011);
    freq.put("ev", 23237);
    freq.put("ep", 20746);
    freq.put("es", 146652);
    freq.put("er", 695279);
    freq.put("blo", 2551);
    freq.put("bli", 12888);
    freq.put("ble", 31774);
    freq.put("bla", 6396);
    freq.put("rli", 7449);
    freq.put("G", 30699);
    freq.put("rle", 2859);
    freq.put("ort", 20720);
    freq.put("rla", 5982);
    freq.put("e ", 500246);
    freq.put("orn", 3102);
    freq.put("orl", 2445);
    freq.put("dig", 4896);
    freq.put("ork", 4146);
    freq.put("ori", 9530);
    freq.put("orf", 4509);
    freq.put("org", 16810);
    freq.put("ord", 42679);
    freq.put("ore", 13522);
    freq.put("orb", 6069);
    freq.put("lme", 3805);
    freq.put("ora", 3709);
    freq.put("nia", 6220);
    freq.put("pra\u030a", 2961);
    freq.put("xi", 3017);
    freq.put("ono", 3591);
    freq.put("mor", 2125);
    freq.put("tøv", 4228);
    freq.put("ona", 9739);
    freq.put("døs", 2243);
    freq.put("ong", 10465);
    freq.put("ond", 6224);
    freq.put("one", 22668);
    freq.put("ons", 14426);
    freq.put("død", 8337);
    freq.put("ont", 6196);
    freq.put("Eur", 2192);
    freq.put("ial", 4669);
    freq.put("ian", 8957);
    freq.put("yin", 3851);
    freq.put("uks", 4735);
    freq.put("uke", 5765);
    freq.put("en ", 368973);
    freq.put("hun", 2960);
    freq.put("hus", 4616);
    freq.put("ia ", 20599);
    freq.put("r", 1753294);
    freq.put("mra\u030a", 7270);
    freq.put("and", 71633);
    freq.put("ane", 10156);
    freq.put("ang", 34028);
    freq.put("ana", 7215);
    freq.put("sam", 15315);
    freq.put("anc", 2796);
    freq.put("anl", 5003);
    freq.put("ann", 21260);
    freq.put("ano", 2720);
    freq.put("pri", 10360);
    freq.put("ani", 10694);
    freq.put("ank", 5395);
    freq.put("ant", 16537);
    freq.put("øya", 3991);
    freq.put("øye", 5083);
    freq.put("ans", 34997);
    freq.put("sas", 3809);
    freq.put("sat", 4359);
    freq.put("Do", 3375);
    freq.put("Di", 3865);
    freq.put("j ", 2796);
    freq.put("De", 44977);
    freq.put("Da", 7415);
    freq.put("2", 2235);
    freq.put("\u0435", 3204);
    freq.put("Dr", 2174);
    freq.put("an ", 35027);
    freq.put(" dø", 7855);
    freq.put("øy ", 5016);
    freq.put(" Le", 5267);
    freq.put(" La", 9489);
    freq.put(" Lo", 6813);
    freq.put(" Li", 8383);
    freq.put(" Lu", 3268);
    freq.put("nla", 6112);
    freq.put("ge ", 33172);
    freq.put("nle", 2679);
    freq.put("nli", 4969);
    freq.put("Sko", 2364);
    freq.put("ss ", 6097);
    freq.put("We", 2978);
    freq.put("Wa", 4239);
    freq.put("iti", 9684);
    freq.put("lub", 3807);
    freq.put("Fyl", 2572);
    freq.put("øke", 2125);
    freq.put("\u0430", 4944);
    freq.put("ges", 4527);
    freq.put(" pr", 27989);
    freq.put("jø", 13856);
    freq.put(" pu", 2169);
    freq.put("get", 10089);
    freq.put("H", 46630);
    freq.put("ssl", 2943);
    freq.put(" pa", 7750);
    freq.put("ssi", 8369);
    freq.put(" pe", 8091);
    freq.put("sse", 15330);
    freq.put(" pi", 4926);
    freq.put(" po", 9080);
    freq.put("gen", 31946);
    freq.put(" pl", 5274);
    freq.put(" ba\u030a", 2550);
    freq.put("W ", 3224);
    freq.put("o\u0301", 2058);
    freq.put("kjø", 3238);
    freq.put("øk", 5634);
    freq.put("øn", 8821);
    freq.put("øl", 4965);
    freq.put("øm", 4740);
    freq.put("ød", 34288);
    freq.put("øe", 2478);
    freq.put("øy", 21642);
    freq.put("rme", 6882);
    freq.put("ør", 54354);
    freq.put("øs", 14419);
    freq.put("øp", 5028);
    freq.put("øv", 7903);
    freq.put("itt", 16474);
    freq.put("øt", 3062);
    freq.put("uts", 3096);
    freq.put("ytt", 5943);
    freq.put("rko", 2612);
    freq.put("utv", 4169);
    freq.put("yte", 2764);
    freq.put("tur", 14995);
    freq.put("utt", 5236);
    freq.put("ju", 8303);
    freq.put("ø ", 2765);
    freq.put("tus", 2293);
    freq.put("rm ", 3363);
    freq.put("jo", 49289);
    freq.put("ji", 3380);
    freq.put(" pa\u030a", 53815);
    freq.put("je", 54644);
    freq.put("tud", 2813);
    freq.put("ja", 10997);
    freq.put(" be", 29509);
    freq.put("z", 18142);
    freq.put(" ba", 13278);
    freq.put("kje", 16281);
    freq.put(" bl", 40680);
    freq.put(" bo", 6968);
    freq.put(" bi", 6342);
    freq.put(" bu", 2338);
    freq.put("s", 1268259);
    freq.put("Kri", 2217);
    freq.put(" br", 16487);
    freq.put(" by", 21015);
    freq.put("tun", 2106);
    freq.put("hvo", 3807);
    freq.put("hve", 2835);
    freq.put("pol", 7076);
    freq.put("lys", 2102);
    freq.put("ei ", 7806);
    freq.put("eis", 4556);
    freq.put("eie", 6921);
    freq.put("eid", 6829);
    freq.put("eim", 2591);
    freq.put("ein", 6378);
    freq.put("ive", 13599);
    freq.put("iva", 2856);
    freq.put("ivi", 3570);
    freq.put("Bar", 2295);
    freq.put("okt", 2231);
    freq.put(" Me", 7355);
    freq.put("par", 10024);
    freq.put("pas", 4090);
    freq.put(" Ma", 15819);
    freq.put(" Mo", 8183);
    freq.put(" Mi", 7093);
    freq.put(" Mu", 2787);
    freq.put("I ", 9052);
    freq.put("pan", 5764);
    freq.put("ga\u030ar", 7228);
    freq.put("iv ", 3591);
    freq.put("I", 28485);
    freq.put("yd", 10423);
    freq.put("gru", 12215);
    freq.put("it ", 2143);
    freq.put("ds ", 5042);
    freq.put("Is", 2952);
    freq.put("Ir", 2049);
    freq.put("pa ", 2052);
    freq.put("In", 7421);
    freq.put("tiv", 7883);
    freq.put("am ", 5629);
    freq.put("gde", 3615);
    freq.put("tis", 16494);
    freq.put("okk", 3118);
    freq.put("va\u030a", 3732);
    freq.put(" ge", 3067);
    freq.put("ami", 6970);
    freq.put("amm", 13306);
    freq.put("aml", 4533);
    freq.put("ama", 4584);
    freq.put("por", 10569);
    freq.put("amb", 2328);
    freq.put("ame", 12312);
    freq.put("mot", 10268);
    freq.put("mon", 3257);
    freq.put("amp", 3404);
    freq.put("amt", 3120);
    freq.put("mod", 2416);
    freq.put("tig", 5426);
    freq.put("røn", 4125);
    freq.put("tia", 3220);
    freq.put("røy", 2397);
    freq.put("km2", 2186);
    freq.put("røs", 2166);
    freq.put(" gi", 4943);
    freq.put("tvi", 4656);
    freq.put("tve", 8575);
    freq.put("New", 2594);
    freq.put(" ca", 3932);
    freq.put("o ", 38269);
    freq.put("dde", 9644);
    freq.put("nma", 2510);
    freq.put("kvi", 3664);
    freq.put("oo", 5024);
    freq.put("on", 123342);
    freq.put("om", 188777);
    freq.put("ol", 75500);
    freq.put("ok", 27219);
    freq.put("oi", 3014);
    freq.put("oh", 4581);
    freq.put("ølg", 2438);
    freq.put("of", 17045);
    freq.put("oe", 7618);
    freq.put("ach", 2606);
    freq.put("oc", 8436);
    freq.put("ob", 11128);
    freq.put("oa", 3647);
    freq.put("sek", 3507);
    freq.put("oy", 2125);
    freq.put("ow", 4407);
    freq.put("ov", 41178);
    freq.put("ou", 20519);
    freq.put("ot", 32564);
    freq.put("os", 28900);
    freq.put("or", 234371);
    freq.put("op", 34634);
    freq.put("Ni", 3496);
    freq.put("No", 20842);
    freq.put("Na", 6162);
    freq.put("Ne", 6662);
    freq.put("het", 10209);
    freq.put("log", 6983);
    freq.put("her", 5545);
    freq.put("lok", 3826);
    freq.put("lon", 2509);
    freq.put("lom", 14627);
    freq.put("los", 2313);
    freq.put("\u0432", 2674);
    freq.put("lov", 2717);
    freq.put("eha", 2568);
    freq.put("hel", 5939);
    freq.put("hen", 7004);
    freq.put("hei", 3009);
    freq.put("J", 19280);
    freq.put("jul", 2456);
    freq.put("lo ", 5941);
    freq.put("as ", 8910);
    freq.put("he ", 6327);
    freq.put("aa", 2792);
    freq.put("ac", 9777);
    freq.put("ab", 12532);
    freq.put("ae", 7154);
    freq.put("ad", 37337);
    freq.put("ag", 40280);
    freq.put("af", 16520);
    freq.put("ai", 12693);
    freq.put("ah", 4661);
    freq.put("ak", 30193);
    freq.put("aj", 2677);
    freq.put("am", 63029);
    freq.put("al", 135078);
    freq.put("ao", 2477);
    freq.put("an", 267240);
    freq.put("ap", 29140);
    freq.put("as", 69325);
    freq.put("ar", 172213);
    freq.put("au", 14940);
    freq.put("at", 91048);
    freq.put("av", 121888);
    freq.put("ay", 5287);
    freq.put("az", 2995);
    freq.put("Lan", 3221);
    freq.put("igs", 3095);
    freq.put("igg", 17522);
    freq.put("ige", 27059);
    freq.put("iga", 2145);
    freq.put("ign", 3006);
    freq.put("igi", 2075);
    freq.put("igh", 5558);
    freq.put("a ", 140249);
    freq.put("at ", 12379);
    freq.put("u", 407647);
    freq.put("ig ", 24484);
    freq.put("all", 28689);
    freq.put("sch", 2395);
    freq.put("tni", 6514);
    freq.put("ali", 12960);
    freq.put("alg", 3345);
    freq.put("ald", 4724);
    freq.put("ale", 19089);
    freq.put("alb", 4116);
    freq.put("ala", 6862);
    freq.put("gt", 8325);
    freq.put("alv", 2901);
    freq.put("gs", 33529);
    freq.put("alt", 13338);
    freq.put("Fin", 2794);
    freq.put("als", 4480);
    freq.put("gr", 39232);
    freq.put("ty", 27626);
    freq.put("tv", 14967);
    freq.put("tt", 93499);
    freq.put("tu", 28284);
    freq.put("tr", 65044);
    freq.put("ts", 42441);
    freq.put("tn", 11784);
    freq.put("to", 63371);
    freq.put("tl", 16216);
    freq.put("tm", 2957);
    freq.put("tj", 4066);
    freq.put("tk", 2587);
    freq.put("th", 14355);
    freq.put("ti", 143857);
    freq.put("tf", 6385);
    freq.put("\u0438", 3772);
    freq.put("td", 2594);
    freq.put("te", 283104);
    freq.put("tb", 9067);
    freq.put("ta", 95087);
    freq.put("ysk", 7598);
    freq.put("edi", 4356);
    freq.put("far", 3333);
    freq.put("al ", 22413);
    freq.put("mpi", 3576);
    freq.put("gy", 3318);
    freq.put("fal", 2369);
    freq.put("fam", 3942);
    freq.put("ruk", 11189);
    freq.put("sme", 3758);
    freq.put(" Ni", 3491);
    freq.put("gg", 35921);
    freq.put("pre", 12096);
    freq.put("ro", 69758);
    freq.put(" No", 20722);
    freq.put("eds", 6107);
    freq.put(" Na", 6059);
    freq.put(" Ne", 6630);
    freq.put("ge", 149531);
    freq.put("rbu", 2376);
    freq.put("t ", 465642);
    freq.put("ass", 12223);
    freq.put("nby", 5798);
    freq.put("tek", 5962);
    freq.put("tel", 9339);
    freq.put("ga", 32513);
    freq.put("ten", 44932);
    freq.put("ted", 11925);
    freq.put("teg", 7791);
    freq.put("gg ", 2739);
    freq.put("ter", 82933);
    freq.put("tes", 6700);
    freq.put("tet", 33199);
    freq.put("ømm", 2930);
    freq.put("rma", 5722);
    freq.put("tø", 14974);
    freq.put("sun", 2773);
    freq.put("abl", 2978);
    freq.put("sut", 4111);
    freq.put("lle", 65120);
    freq.put("ta\u030a", 6348);
    freq.put(" ru", 9067);
    freq.put("lkn", 2938);
    freq.put("te ", 58351);
    freq.put("K", 42898);
    freq.put(" re", 25505);
    freq.put(" ra", 3039);
    freq.put("pub", 5466);
    freq.put(" ro", 6266);
    freq.put(" ri", 2962);
    freq.put("a\u0300", 2467);
    freq.put("oma", 5119);
    freq.put("lke", 16528);
    freq.put("nto", 3515);
    freq.put("vid", 3526);
    freq.put("rks", 2379);
    freq.put("vik", 8483);
    freq.put("vin", 16505);
    freq.put("vil", 4773);
    freq.put("vir", 2566);
    freq.put("rke", 16934);
    freq.put("rka", 2079);
    freq.put("vit", 4787);
    freq.put("Uni", 3264);
    freq.put("S ", 4165);
    freq.put("rki", 3108);
    freq.put("vh", 2078);
    freq.put("de ", 60427);
    freq.put("Sy", 2174);
    freq.put("fø", 39544);
    freq.put("Sp", 4048);
    freq.put("Sv", 4781);
    freq.put("Su", 4159);
    freq.put("St", 18668);
    freq.put("Sk", 6894);
    freq.put("Si", 5113);
    freq.put("Sh", 4054);
    freq.put("So", 11528);
    freq.put("Sl", 2066);
    freq.put("Sc", 2844);
    freq.put("Sa", 11798);
    freq.put("Se", 7511);
    freq.put("a\u0301", 3631);
    freq.put("kle", 4386);
    freq.put("kla", 6195);
    freq.put(" di", 7830);
    freq.put(" de", 122624);
    freq.put("des", 6374);
    freq.put("det", 47571);
    freq.put("kli", 3140);
    freq.put(" da", 14064);
    freq.put("klu", 3574);
    freq.put("dek", 2450);
    freq.put("del", 41297);
    freq.put("dem", 4267);
    freq.put(" dy", 2072);
    freq.put("v", 434834);
    freq.put("Ind", 2121);
    freq.put(" Fe", 2724);
    freq.put(" dr", 4255);
    freq.put("lhø", 2797);
    freq.put("pro", 23686);
    freq.put("f ", 9303);
    freq.put("ati", 14442);
    freq.put("ryk", 2399);
    freq.put("att", 15952);
    freq.put("ava", 2465);
    freq.put("ish", 2413);
    freq.put("eg ", 6746);
    freq.put("Tys", 2479);
    freq.put("fr", 47803);
    freq.put("Sø", 4628);
    freq.put("ft", 23386);
    freq.put("fu", 8120);
    freq.put("fy", 8788);
    freq.put("fa", 23302);
    freq.put("fe", 26099);
    freq.put("ff", 8428);
    freq.put("fi", 25866);
    freq.put("fj", 12532);
    freq.put("fl", 14388);
    freq.put("fo", 101580);
    freq.put("a", 1296256);
    freq.put("egr", 3736);
    freq.put("ry ", 3420);
    freq.put("egi", 7310);
    freq.put("egn", 9280);
    freq.put("o\u0308", 5464);
    freq.put("egg", 4893);
    freq.put("ege", 7883);
    freq.put(" sø", 12596);
    freq.put("ce ", 3774);
    freq.put("y ", 43971);
    freq.put("ite", 15976);
    freq.put("ita", 7242);
    freq.put("ok ", 7509);
    freq.put("ffi", 2131);
    freq.put("ity", 2756);
    freq.put("ffe", 3959);
    freq.put("itu", 2594);
    freq.put("its", 2537);
    freq.put(" sa\u030a", 2458);
    freq.put(" Ol", 2367);
    freq.put(" Or", 3262);
    freq.put(" Os", 5937);
    freq.put(" Op", 2481);
    freq.put("yi", 4209);
    freq.put("yk", 8767);
    freq.put("ym", 5956);
    freq.put("yl", 14093);
    freq.put("yn", 9715);
    freq.put("ya", 7947);
    freq.put("ye", 16616);
    freq.put("L", 37752);
    freq.put("yg", 16794);
    freq.put("oka", 3954);
    freq.put("yp", 7213);
    freq.put("ys", 21183);
    freq.put("yr", 13910);
    freq.put("yt", 13580);
    freq.put("ift", 6890);
    freq.put("tro", 7380);
    freq.put(" sy", 5687);
    freq.put("Eng", 3095);
    freq.put("lv ", 4083);
    freq.put(" sp", 19430);
    freq.put(" sv", 7377);
    freq.put(" st", 43167);
    freq.put(" su", 2425);
    freq.put(" sj", 3216);
    freq.put(" sk", 21745);
    freq.put("\u4e13", 2738);
    freq.put(" si", 17713);
    freq.put(" so", 87507);
    freq.put(" sl", 7113);
    freq.put(" sa", 19419);
    freq.put(" se", 29156);
    freq.put("ftv", 7006);
    freq.put("fte", 8757);
    freq.put("En ", 4024);
    freq.put(" el", 30282);
    freq.put("ast", 9209);
    freq.put("mmu", 24025);
    freq.put("sby", 2166);
    freq.put(" Al", 7546);
    freq.put(" Am", 2962);
    freq.put(" An", 7665);
    freq.put(" Ar", 6669);
    freq.put(" As", 2828);
    freq.put(" Au", 3596);
    freq.put("ase", 4616);
    freq.put("sbe", 2623);
    freq.put("ask", 2682);
    freq.put("asj", 20288);
    freq.put("asi", 5334);
    freq.put(" ei", 4836);
    freq.put("El", 2986);
    freq.put("En", 8728);
    freq.put("pa\u030a ", 52716);
    freq.put("kon", 13827);
    freq.put("ft ", 3864);
    freq.put("w", 19861);
    freq.put("Eu", 2611);
    freq.put("Et", 2524);
    freq.put("Fra", 3815);
    freq.put("dt ", 28714);
    freq.put("Fre", 2185);
    freq.put("jer", 9769);
    freq.put(" en", 123670);
    freq.put("kom", 31756);
    freq.put("kol", 9129);
    freq.put(" ek", 4165);
    freq.put(" eg", 3293);
    freq.put(" et", 63825);
    freq.put("jek", 2468);
    freq.put("\u043a", 2313);
    freq.put("jen", 18638);
    freq.put("kot", 2092);
    freq.put(" er", 153435);
    freq.put("jem", 3205);
    freq.put("ær", 24440);
    freq.put("odu", 8565);
    freq.put("sa\u030a ", 11194);
    freq.put("nce", 2258);
    freq.put("ste", 66334);
    freq.put("stf", 2230);
    freq.put("Xi", 2231);
    freq.put("sta", 38189);
    freq.put("stl", 6400);
    freq.put("stn", 2344);
    freq.put("sto", 16688);
    freq.put("sti", 20167);
    freq.put("dte", 2377);
    freq.put("stu", 3784);
    freq.put("je ", 3919);
    freq.put("jel", 9659);
    freq.put("str", 25344);
    freq.put("sty", 4151);
    freq.put("ønn", 3150);
    freq.put("ka ", 6242);
    freq.put("a\u030ade", 9646);
    freq.put("tfo", 3043);
    freq.put("lie", 7273);
    freq.put("k ", 129587);
    freq.put("lia", 5498);
    freq.put("lin", 18549);
    freq.put("lik", 12256);
    freq.put("lit", 14639);
    freq.put("efi", 2051);
    freq.put("liv", 2248);
    freq.put("2 ", 2226);
    freq.put("Kin", 6314);
    freq.put("lir", 3649);
    freq.put("efo", 4434);
    freq.put("efe", 4659);
    freq.put("vne", 6818);
    freq.put("oft", 3759);
    freq.put("Øst", 2801);
    freq.put("M", 50816);
    freq.put("kan", 20091);
    freq.put("kam", 2092);
    freq.put("kal", 14105);
    freq.put("kas", 2638);
    freq.put("kar", 4133);
    freq.put("kap", 17702);
    freq.put("kat", 3942);
    freq.put("The", 4012);
    freq.put("sta\u030a", 5531);
    freq.put("ka", 75120);
    freq.put("li ", 4167);
    freq.put("ke", 149522);
    freq.put("kk", 42089);
    freq.put("kj", 21128);
    freq.put("ki", 30043);
    freq.put("kh", 3599);
    freq.put("ko", 71373);
    freq.put("kn", 9496);
    freq.put("km", 10210);
    freq.put("kl", 19159);
    freq.put("ks", 31928);
    freq.put("kr", 37123);
    freq.put("kv", 7398);
    freq.put("ku", 18940);
    freq.put("kt", 45246);
    freq.put("ky", 6546);
    freq.put("stø", 6651);
    freq.put("rte", 20285);
    freq.put("rta", 2228);
    freq.put("Han", 5694);
    freq.put("ugl", 2152);
    freq.put("rti", 8810);
    freq.put("rts", 5729);
    freq.put("Har", 2577);
    freq.put("ugu", 2387);
    freq.put("ymp", 3267);
    freq.put("Ju", 2288);
    freq.put("ies", 2351);
    freq.put("ier", 7794);
    freq.put("iet", 4979);
    freq.put("Jo", 5435);
    freq.put("iel", 5273);
    freq.put("ien", 17663);
    freq.put("Je", 2911);
    freq.put("Ja", 4954);
    freq.put("his", 4361);
    freq.put("rt ", 35053);
    freq.put("b", 291896);
    freq.put("hin", 2784);
    freq.put("rfa", 4418);
    freq.put("ie ", 7138);
    freq.put(" Be", 11852);
    freq.put("arr", 4082);
    freq.put("ars", 6026);
    freq.put(" Ba", 9272);
    freq.put("ser", 35054);
    freq.put("For", 3758);
    freq.put("sep", 3173);
    freq.put(" Bl", 2409);
    freq.put(" Bo", 6415);
    freq.put(" Bi", 3097);
    freq.put(" Bu", 3840);
    freq.put("ara", 7138);
    freq.put("arb", 5329);
    freq.put("ik ", 6168);
    freq.put("ard", 7601);
    freq.put("are", 11421);
    freq.put(" Br", 7392);
    freq.put("Fol", 3808);
    freq.put("ari", 9703);
    freq.put("sem", 4309);
    freq.put("ark", 12605);
    freq.put(" By", 3181);
    freq.put("arm", 4027);
    freq.put("arn", 4304);
    freq.put("ses", 4849);
    freq.put(" a\u030ar", 6691);
    freq.put("ønd", 2352);
    freq.put("iks", 3390);
    freq.put("ikt", 9421);
    freq.put("ue ", 2256);
    freq.put("ar ", 65150);
    freq.put("ika", 14540);
    freq.put("ike", 13916);
    freq.put("se ", 19672);
    freq.put("ikk", 22590);
    freq.put("ikl", 3957);
    freq.put(" Pr", 5244);
    freq.put("c", 77603);
    freq.put(" a\u030a ", 15026);
    freq.put(" Pa", 8187);
    freq.put(" Pe", 5104);
    freq.put("ø", 174400);
    freq.put(" Pi", 2406);
    freq.put(" Po", 5205);
    freq.put("tgi", 4175);
    freq.put("ga ", 3023);
    freq.put("pr", 51296);
    freq.put("ps", 7773);
    freq.put("pp", 34390);
    freq.put("duk", 4468);
    freq.put("pt", 7260);
    freq.put("pu", 11071);
    freq.put("vn ", 5466);
    freq.put("ran", 19588);
    freq.put("pa", 27179);
    freq.put("pe", 55903);
    freq.put("ph", 3721);
    freq.put("pi", 29184);
    freq.put("pn", 2118);
    freq.put("po", 25761);
    freq.put("pl", 13813);
    freq.put(" ty", 6900);
    freq.put(" tu", 3382);
    freq.put("gat", 3035);
    freq.put("gas", 3030);
    freq.put(" tr", 14296);
    freq.put("N", 44173);
    freq.put(" to", 9228);
    freq.put("gan", 11800);
    freq.put("gam", 2397);
    freq.put("gal", 2375);
    freq.put(" ti", 62638);
    freq.put(" th", 2455);
    freq.put(" te", 14306);
    freq.put(" ta", 8589);
    freq.put("lba", 2444);
    freq.put("sak", 3680);
    freq.put("mle", 3222);
    freq.put(" fø", 33238);
    freq.put("p ", 18651);
    freq.put("gsa\u030a", 9706);
    freq.put("fun", 3666);
    freq.put("skj", 4074);
    freq.put("eke", 3082);
    freq.put("riv", 5194);
    freq.put("rit", 8311);
    freq.put("ris", 17487);
    freq.put("vok", 2535);
    freq.put("rin", 21593);
    freq.put("rio", 3486);
    freq.put("ril", 2995);
    freq.put("rim", 2649);
    freq.put("rik", 24390);
    freq.put("vor", 4361);
    freq.put("rif", 3440);
    freq.put("rig", 8523);
    freq.put("rid", 3352);
    freq.put("rie", 12327);
    freq.put("ric", 2697);
    freq.put("ria", 5352);
    freq.put("gs ", 3264);
    freq.put("pa\u030a", 54079);
    freq.put("Cou", 8345);
    freq.put("syk", 3044);
    freq.put("syn", 2627);
    freq.put("sys", 2439);
    freq.put("lig", 60844);
    freq.put("ri ", 3980);
    freq.put(" fr", 43218);
    freq.put(" fu", 3699);
    freq.put("gst", 4516);
    freq.put("kni", 5015);
    freq.put(" fy", 7547);
    freq.put("ew ", 2555);
    freq.put("Som", 4932);
    freq.put(" fa", 9591);
    freq.put(" fe", 8817);
    freq.put("kny", 2137);
    freq.put(" fi", 13808);
    freq.put(" fj", 6013);
    freq.put(" fl", 9728);
    freq.put(" fo", 78205);
    freq.put("lde", 10166);
    freq.put("hje", 2935);
    freq.put("sør", 11014);
    freq.put("\u043e", 4246);
    freq.put("sal", 2138);
    freq.put("rge", 14583);
    freq.put("rgi", 2280);
    freq.put(" De", 44915);
    freq.put("bin", 5018);
    freq.put("ba\u030a", 3627);
    freq.put("bil", 4902);
    freq.put("Ol", 2369);
    freq.put("lis", 9353);
    freq.put("ngt", 2215);
    freq.put("bø", 2634);
    freq.put("bis", 3511);
    freq.put("Op", 2483);
    freq.put("d", 751947);
    freq.put("lje", 2230);
    freq.put("rg ", 6581);
    freq.put("een", 2210);
    freq.put("b ", 4101);
    freq.put("ld ", 6657);
    freq.put("pet", 8954);
    freq.put("per", 17920);
    freq.put("pes", 3294);
    freq.put("pel", 3770);
    freq.put("pen", 10042);
    freq.put("ape", 8916);
    freq.put("id ", 6821);
    freq.put("t", 1430364);
    freq.put("be", 63706);
    freq.put("run", 12301);
    freq.put("ba", 35656);
    freq.put("bb", 5548);
    freq.put("rum", 4066);
    freq.put("bl", 54931);
    freq.put("bo", 17004);
    freq.put("bi", 19197);
    freq.put("O", 29040);
    freq.put("bu", 14609);
    freq.put("oen", 3787);
    freq.put("br", 29081);
    freq.put("rus", 6418);
    freq.put("rup", 6154);
    freq.put("by", 34947);
    freq.put("gje", 8413);
    freq.put("Rom", 2726);
    freq.put("idr", 3478);
    freq.put("ids", 3533);
    freq.put("idl", 8890);
    freq.put("MW ", 2903);
    freq.put("Osl", 4630);
    freq.put("chi", 2081);
    freq.put("idd", 2770);
    freq.put("ide", 18687);
    freq.put("pe ", 5528);
    freq.put("ylk", 9083);
    freq.put("ida", 3822);
    freq.put("nsi", 3034);
    freq.put("nsj", 2053);
    freq.put("nsk", 39260);
    freq.put("nsl", 2182);
    freq.put(" ut", 27318);
    freq.put("nsa", 2994);
    freq.put("nse", 21534);
    freq.put("tif", 3581);
    freq.put(" un", 21502);
    freq.put("nsp", 2257);
    freq.put("nss", 3014);
    freq.put("nst", 14726);
    freq.put("ut ", 5919);
    freq.put("ra\u030ak", 3246);
    freq.put(" ga\u030a", 5771);
    freq.put("uss", 8811);
    freq.put("tys", 4599);
    freq.put("u ", 10252);
    freq.put("fes", 3648);
    freq.put(" Ch", 7563);
    freq.put(" Co", 15800);
    freq.put("løp", 3837);
    freq.put("ns ", 20153);
    freq.put(" Ca", 8810);
    freq.put("sda", 2876);
    freq.put("a\u030a", 157055);
    freq.put("utg", 6539);
    freq.put("ute", 5272);
    freq.put("ut", 47498);
    freq.put("up", 9818);
    freq.put("us", 50014);
    freq.put("ur", 41090);
    freq.put("um", 19336);
    freq.put("ul", 26959);
    freq.put("un", 102304);
    freq.put("ui", 4966);
    freq.put("uk", 21664);
    freq.put("ue", 11327);
    freq.put("ud", 11995);
    freq.put("ug", 10093);
    freq.put("uf", 3039);
    freq.put("ua", 11212);
    freq.put("uc", 2853);
    freq.put("ub", 13117);
    freq.put("Ty", 3546);
    freq.put("Tr", 8937);
    freq.put("la\u0308n", 2721);
    freq.put("To", 6250);
    freq.put("Th", 6517);
    freq.put("Ti", 3470);
    freq.put("lym", 3245);
    freq.put("Te", 5634);
    freq.put("Ta", 4262);
    freq.put("A ", 7964);
    freq.put(" gu", 2109);
    freq.put(" gr", 19932);
    freq.put("nad", 2448);
    freq.put("nan", 2828);
    freq.put("nal", 12130);
    freq.put("ag ", 10292);
    freq.put("nar", 2470);
    freq.put("nas", 7061);
    freq.put("gre", 14854);
    freq.put("nav", 9346);
    freq.put("nat", 5154);
    freq.put("gra", 9273);
    freq.put(" gj", 7272);
    freq.put("Man", 2484);
    freq.put("ly ", 2856);
    freq.put("na ", 15576);
    freq.put("e", 2892960);
    freq.put("svi", 2603);
    freq.put("dve", 3394);
    freq.put("age", 11424);
    freq.put("sve", 9604);
    freq.put("Am", 2967);
    freq.put("Al", 7567);
    freq.put("aga", 2271);
    freq.put("An", 7679);
    freq.put("As", 3221);
    freq.put("Ar", 6717);
    freq.put("Au", 3599);
    freq.put("utø", 4075);
    freq.put("agt", 4288);
    freq.put(" b", 141242);
    freq.put(" c", 8452);
    freq.put("gu", 9872);
    freq.put(" a", 164625);
    freq.put(" f", 217023);
    freq.put(" g", 55928);
    freq.put(" d", 163994);
    freq.put(" e", 389283);
    freq.put(" j", 14786);
    freq.put(" k", 126841);
    freq.put(" h", 91447);
    freq.put(" i", 286253);
    freq.put(" n", 66294);
    freq.put(" o", 215607);
    freq.put(" l", 79574);
    freq.put(" m", 127350);
    freq.put(" r", 49569);
    freq.put(" s", 286186);
    freq.put(" p", 120765);
    freq.put("gd", 9301);
    freq.put(" v", 100006);
    freq.put(" t", 125598);
    freq.put(" u", 55940);
    freq.put("go", 8838);
    freq.put("gn", 19968);
    freq.put("gl", 10219);
    freq.put("gj", 12645);
    freq.put("gi", 33050);
    freq.put("gh", 8862);
    freq.put(" B", 52872);
    freq.put(" C", 42604);
    freq.put(" A", 51010);
    freq.put(" F", 45901);
    freq.put(" G", 30503);
    freq.put(" D", 67077);
    freq.put(" E", 31023);
    freq.put(" J", 19242);
    freq.put(" K", 42735);
    freq.put(" H", 46471);
    freq.put(" I", 28413);
    freq.put(" N", 43960);
    freq.put(" O", 28901);
    freq.put(" L", 37540);
    freq.put(" M", 50591);
    freq.put(" R", 33770);
    freq.put(" S", 97781);
    freq.put(" P", 33276);
    freq.put(" Q", 2713);
    freq.put(" V", 29296);
    freq.put(" W", 14969);
    freq.put(" T", 46489);
    freq.put(" U", 16274);
    freq.put(" Z", 4215);
    freq.put(" X", 3570);
    freq.put(" Y", 5370);
    freq.put("Nor", 18501);
    freq.put("ch ", 3122);
    freq.put("ed ", 55809);
    freq.put("P", 33476);
    freq.put("g ", 242136);
    freq.put("tri", 10126);
    freq.put("evi", 2446);
    freq.put("a\u030att", 3275);
    freq.put("tra", 17913);
    freq.put("eva", 2230);
    freq.put("us ", 10711);
    freq.put("tre", 18842);
    freq.put("eve", 11454);
    freq.put("try", 2883);
    freq.put("min", 11788);
    freq.put("tru", 4763);
    freq.put("le ", 57070);
    freq.put("rri", 3179);
    freq.put(" a\u030a", 24460);
    freq.put("rre", 7643);
    freq.put("za", 2150);
    freq.put("rra", 4011);
    freq.put("ay ", 2288);
    freq.put("ga\u030a", 9251);
    freq.put(" ø", 14695);
    freq.put("ode", 7882);
    freq.put("ues", 2288);
    freq.put(" A\u030a", 2834);
    freq.put("rd ", 17240);
    freq.put(" Ø", 5122);
    freq.put("led", 5805);
    freq.put("leg", 6026);
    freq.put("lei", 2319);
    freq.put("lek", 9666);
    freq.put("z ", 3331);
    freq.put("lem", 5548);
    freq.put("len", 25387);
    freq.put("ler", 55284);
    freq.put("les", 12321);
    freq.put("let", 13065);
    freq.put("lev", 4182);
    freq.put("od ", 2196);
    freq.put("rdv", 2179);
    freq.put("rds", 3327);
    freq.put("rde", 19629);
    freq.put("rda", 5684);
    freq.put("nær", 3936);
    freq.put("rdl", 3552);
    freq.put("ule", 2555);
    freq.put("rdi", 4958);
    freq.put(" Do", 3289);
    freq.put("Ves", 3148);
    freq.put(" Di", 3846);
    freq.put("app", 2255);
    freq.put(" Da", 7402);
    freq.put("apa", 4754);
    freq.put(" Dr", 2166);
    freq.put("Vei", 2618);
    freq.put("cha", 2322);
    freq.put("Fr", 8731);
    freq.put("che", 4052);
    freq.put(" væ", 4635);
    freq.put("fen", 2692);
    freq.put("Fy", 2932);
    freq.put("fel", 4217);
    freq.put("fem", 2188);
    freq.put("fek", 3989);
    freq.put("usi", 6124);
    freq.put("Fa", 3197);
    freq.put("ust", 8108);
    freq.put("fer", 4921);
    freq.put("Fe", 2733);
    freq.put("Fi", 5958);
    freq.put("Fj", 2610);
    freq.put("Fl", 2786);
    freq.put("ra\u030ad", 8908);
    freq.put("Fo", 9701);
    freq.put("ap ", 5392);
    freq.put(" Ru", 4349);
    freq.put("gjø", 2529);
    freq.put("f", 354544);
    freq.put("km ", 7242);
    freq.put(" Re", 6462);
    freq.put("og", 163889);
    freq.put(" Ra", 4586);
    freq.put(" Ro", 9267);
    freq.put(" Ri", 4754);
    freq.put("tat", 16792);
    freq.put("tav", 2813);
    freq.put("od", 26153);
    freq.put("tar", 7233);
    freq.put("\u0440", 2932);
    freq.put("tad", 7590);
    freq.put("kys", 2223);
    freq.put("tab", 3588);
    freq.put("tal", 21730);
    freq.put("tam", 2411);
    freq.put("tan", 11218);
    freq.put("tak", 2812);
    freq.put(" va", 41741);
    freq.put(" ve", 33600);
    freq.put("afi", 2584);
    freq.put("Yo", 2095);
    freq.put("sit", 9775);
    freq.put(" vi", 14710);
    freq.put(" vo", 3210);
    freq.put("sia", 4578);
    freq.put("sie", 4330);
    freq.put("sid", 8350);
    freq.put("aft", 9172);
    freq.put("sin", 9850);
    freq.put("sis", 16636);
    freq.put("Q", 2727);
    freq.put("ta ", 8154);
    freq.put("ndr", 12413);
    freq.put("æ", 27321);
    freq.put("da ", 8120);
    freq.put("lf", 6606);
    freq.put("lg", 10977);
    freq.put("ld", 27006);
    freq.put("le", 206454);
    freq.put("lb", 9872);
    freq.put("tsk", 2860);
    freq.put("la", 117768);
    freq.put("lo", 47607);
    freq.put("ll", 125327);
    freq.put("lm", 11687);
    freq.put("lj", 4011);
    freq.put("lk", 27090);
    freq.put("lh", 5181);
    freq.put("li", 148110);
    freq.put("lv", 17299);
    freq.put("føl", 2302);
    freq.put("lt", 42371);
    freq.put("lu", 16394);
    freq.put("ls", 54920);
    freq.put("lp", 4961);
    freq.put("byg", 13374);
    freq.put("byd", 2738);
    freq.put("bye", 5451);
    freq.put("ly", 13905);
    freq.put("dag", 6176);
    freq.put("dal", 11372);
    freq.put("Car", 2172);
    freq.put("dan", 8876);
    freq.put("dat", 3189);
    freq.put("sik", 9289);
    freq.put("dar", 2553);
    freq.put("ema", 3872);
    freq.put("San", 3826);
    freq.put("l ", 114552);
    freq.put("nfo", 4282);
    freq.put("Pro", 2168);
    freq.put(" hv", 8245);
    freq.put(" hu", 4249);
    freq.put(" hj", 2877);
    freq.put(" hi", 3888);
    freq.put(" ho", 10427);
    freq.put(" ha", 40329);
    freq.put(" he", 11962);
    freq.put("oun", 9480);
    freq.put("our", 3311);
    freq.put("by ", 8318);
    freq.put("læ", 3598);
    freq.put("la\u0308", 2860);
    freq.put("la\u030a", 4732);
    freq.put("rer", 20318);
    freq.put("res", 20361);
    freq.put("rep", 8966);
    freq.put("rev", 6468);
    freq.put("ret", 27902);
    freq.put("rek", 8172);
    freq.put("rei", 3228);
    freq.put("ren", 35981);
    freq.put("rel", 4778);
    freq.put("rem", 5839);
    freq.put("rea", 5698);
    freq.put("ref", 5778);
    freq.put("reg", 12569);
    freq.put("lø", 8427);
    freq.put("ree", 2115);
    freq.put("x", 10440);
    freq.put(" hø", 6629);
    freq.put("g", 680290);
    freq.put("lta", 2646);
    freq.put("lte", 5587);
    freq.put("re ", 73979);
    freq.put("lto", 5869);
    freq.put("u\u0308", 2355);
    freq.put("rs ", 8675);
    freq.put("ud ", 2293);
    freq.put("set", 9508);
    freq.put("art", 19222);
    freq.put("og ", 134463);
    freq.put(" Sy", 2169);
    freq.put("hør", 3562);
    freq.put(" Sp", 4034);
    freq.put(" Sv", 4778);
    freq.put("nda", 5748);
    freq.put(" St", 18500);
    freq.put(" Su", 4150);
    freq.put(" Sk", 6885);
    freq.put(" Sh", 4026);
    freq.put(" Si", 5095);
    freq.put(" So", 11504);
    freq.put(" Sl", 2061);
    freq.put(" Sc", 2823);
    freq.put(" Sa", 11773);
    freq.put(" Se", 7484);
    freq.put("Ka", 7574);
    freq.put("rso", 5206);
    freq.put("rsi", 6764);
    freq.put("Ke", 2144);
    freq.put("rsk", 24627);
    freq.put("rse", 3955);
    freq.put("Ki", 8846);
    freq.put("Ko", 7893);
    freq.put("ogs", 10014);
    freq.put("ogr", 5237);
    freq.put("Kr", 5137);
    freq.put("R", 33889);
    freq.put("ogi", 5246);
    freq.put("Ku", 2113);
    freq.put("ude", 2985);
    freq.put("rst", 17535);
    freq.put("udi", 2221);
    freq.put("høy", 5492);
    freq.put("seg", 6362);
    freq.put("bei", 5432);
    freq.put("ben", 4646);
    freq.put("bel", 3914);
    freq.put("beg", 3804);
    freq.put("ber", 17512);
    freq.put("bes", 8730);
    freq.put("bev", 2185);
    freq.put("bet", 9507);
    freq.put("Par", 3554);
    freq.put("sen", 41736);
    freq.put("sk", 191864);
    freq.put(" Sø", 4627);
    freq.put("sel", 10690);
    freq.put("ur ", 5709);
    freq.put("ck ", 3691);
    freq.put("ghe", 4290);
    freq.put("arl", 3706);
    freq.put("mid", 4108);
    freq.put("øpe", 2597);
    freq.put("hr", 3491);
    freq.put("mis", 4562);
    freq.put(" El", 2979);
    freq.put(" En", 8708);
    freq.put("hv", 8983);
    freq.put("sfo", 2877);
    freq.put("st ", 39863);
    freq.put(" Et", 2521);
    freq.put(" Eu", 2608);
    freq.put("cke", 2693);
    freq.put("ure", 6307);
    freq.put("urg", 2892);
    freq.put("fjo", 6945);
    freq.put("mus", 6700);
    freq.put("urn", 3039);
    freq.put("uro", 3768);
    freq.put("uri", 2750);
    freq.put("fje", 5241);
    freq.put("urr", 2556);
    freq.put("hn", 2241);
    freq.put("Cha", 2366);
    freq.put("lær", 3470);
    freq.put("eda", 3620);
    freq.put("nge", 45140);
    freq.put("nga", 2868);
    freq.put("ngl", 4160);
    freq.put(" is", 2212);
    freq.put("ngi", 2137);
    freq.put("kse", 4519);
    freq.put("ae ", 2689);
    freq.put(" ik", 4460);
    freq.put(" in", 34065);
    freq.put("ngs", 15959);
    freq.put("ksi", 2580);
    freq.put("ksj", 6623);
    freq.put("tba", 6294);
    freq.put("qu", 2140);
    freq.put("h", 226424);
    freq.put("tti", 2906);
    freq.put("sha", 2088);
    freq.put("ks ", 3032);
    freq.put(" i ", 237285);
    freq.put("shi", 3201);
    freq.put("m2 ", 2219);
    freq.put("Pr", 5274);
    freq.put("ebe", 2240);
    freq.put("eba", 2196);
    freq.put("C", 43132);
    freq.put("ke ", 65844);
    freq.put("Pa", 8226);
    freq.put("ebr", 3393);
    freq.put("Pe", 5166);
    freq.put("ede", 17856);
    freq.put("Pi", 2410);
    freq.put("Po", 5247);
    freq.put("dla", 2367);
    freq.put("lut", 2852);
    freq.put("ome", 6397);
    freq.put("dle", 5037);
    freq.put("dli", 11521);
    freq.put("kk ", 10113);
    freq.put("et ", 226950);
    freq.put("a\u030ar ", 14295);
    freq.put("\u043b", 2294);
    freq.put("ken", 15267);
    freq.put("jor", 11663);
    freq.put("kel", 6677);
    freq.put("S", 98250);
    freq.put("omm", 37033);
    freq.put("ket", 9398);
    freq.put("kes", 10195);
    freq.put("ker", 29257);
    freq.put("jon", 34428);
    freq.put("etr", 2759);
    freq.put("ets", 9941);
    freq.put("ett", 37893);
    freq.put("ety", 3237);
    freq.put("a\u030ard", 2572);
    freq.put("a\u030are", 3629);
    freq.put("tla", 4715);
    freq.put("eta", 7185);
    freq.put("tle", 2120);
    freq.put("ete", 19743);
    freq.put("tli", 7658);
    freq.put("eti", 2646);
    freq.put("etn", 3543);
    freq.put("ck", 10053);
    freq.put("ci", 6056);
    freq.put("ch", 18251);
    freq.put("co", 8095);
    freq.put("dø", 14496);
    freq.put("væ", 7493);
    freq.put("ot ", 7999);
    freq.put("ca", 10711);
    freq.put("Lon", 2680);
    freq.put("rva", 2898);
    freq.put("ce", 8996);
    freq.put("byp", 2127);
    freq.put("Hel", 2604);
    freq.put("før", 14702);
    freq.put("cu", 2103);
    freq.put("ct", 3488);
    freq.put("rve", 4784);
    freq.put("llk", 3343);
    freq.put("bbe", 3093);
    freq.put("rvi", 2442);
    freq.put("OL ", 7076);
    freq.put("oto", 3139);
    freq.put("otb", 5531);
    freq.put("c ", 3649);
    freq.put("ote", 3613);
    freq.put("lge", 4495);
    freq.put("uns", 3775);
    freq.put("fød", 22348);
    freq.put("ots", 2202);
    freq.put("ott", 4146);
    freq.put("tst", 7808);
    freq.put("And", 2152);
    freq.put("tsu", 3903);
    freq.put("e\u0301", 5770);
    freq.put("edl", 3176);
    freq.put("rbi", 3863);
    freq.put("rbe", 5664);
    freq.put("ya ", 4898);
    freq.put("yst", 6626);
    freq.put("va", 71132);
    freq.put(" Fr", 8721);
    freq.put("vd", 3441);
    freq.put("ve", 142305);
    freq.put(" Fy", 2931);
    freq.put("vi", 56505);
    freq.put("vn", 14394);
    freq.put("vo", 12525);
    freq.put(" Fa", 3178);
    freq.put("avn", 11841);
    freq.put("vs", 5579);
    freq.put("vt", 2733);
    freq.put("avi", 3695);
    freq.put(" Fi", 5928);
    freq.put("ave", 7468);
    freq.put(" Fj", 2609);
    freq.put(" Fl", 2776);
    freq.put(" Fo", 9668);
    freq.put("io ", 2961);
    freq.put("of ", 4012);
    freq.put("pis", 4864);
    freq.put("tas", 5433);
    freq.put("edr", 4047);
    freq.put("une", 22585);
    freq.put("v ", 99425);
    freq.put("ion", 14718);
    freq.put("Øs", 2809);
    freq.put("iod", 2244);
    freq.put("av ", 85297);
    freq.put("off", 4398);
    freq.put(" Ty", 3541);
    freq.put("ofe", 2299);
    freq.put("i", 1317183);
    freq.put(" Tr", 8905);
    freq.put(" To", 6181);
    freq.put(" Ti", 3455);
    freq.put(" Th", 6493);
    freq.put(" Te", 5588);
    freq.put(" Ta", 4246);
    freq.put("mfa", 2204);
    freq.put("mpe", 4413);
    freq.put("sku", 3651);
    freq.put("Be", 11885);
    freq.put("tt ", 26597);
    freq.put("Ba", 9331);
    freq.put("skr", 10481);
    freq.put("Bl", 2411);
    freq.put("Bo", 6452);
    freq.put("sky", 2874);
    freq.put("Bi", 3113);
    freq.put("ske", 46720);
    freq.put("Bu", 3866);
    freq.put("add", 5083);
    freq.put("ade", 7303);
    freq.put("ska", 22269);
    freq.put("Br", 7415);
    freq.put("ada", 2399);
    freq.put("skl", 2812);
    freq.put("sko", 10936);
    freq.put("adm", 2981);
    freq.put("ski", 8246);
    freq.put("By", 3184);
    freq.put("adi", 6411);
    freq.put("fyl", 7035);
    freq.put("T", 46770);
    freq.put("sk ", 75137);
    freq.put("ad ", 7446);
    freq.put("ts ", 7521);
    freq.put("esv", 2859);
    freq.put("est", 46619);
    freq.put("ess", 8652);
    freq.put("esp", 3357);
    freq.put("nd ", 38901);
    freq.put("ese", 10631);
    freq.put("eso", 2351);
    freq.put("esk", 8307);
    freq.put("esi", 10382);
    freq.put("\u4e4b", 2379);
    freq.put("Un", 4807);
    freq.put("ndi", 6968);
    freq.put("ndl", 2779);
    freq.put("ndo", 5458);
    freq.put(" ju", 4702);
    freq.put("nde", 56337);
    freq.put(" jo", 2540);
    freq.put("kri", 13226);
    freq.put("kro", 2450);
    freq.put("es ", 40484);
    freq.put("nds", 12659);
    freq.put("kra", 11143);
    freq.put(" ja", 4722);
    freq.put("ndt", 4870);
    freq.put("kre", 8431);
    freq.put("De ", 3390);
    freq.put("h ", 12462);
    freq.put("yrk", 2373);
    freq.put("van", 11534);
    freq.put("val", 6677);
    freq.put("yre", 3443);
    freq.put("tg", 7470);
    freq.put("var", 40025);
    freq.put("vat", 3521);
    freq.put("hy", 2076);
    freq.put("eal", 3627);
    freq.put("bur", 2443);
    freq.put("Det", 18734);
    freq.put("ht", 2318);
    freq.put("hu", 13547);
    freq.put("hj", 3760);
    freq.put("hi", 16514);
    freq.put("bun", 2536);
    freq.put("ho", 28328);
    freq.put("Den", 19203);
    freq.put("bum", 3444);
    freq.put("ha", 66151);
    freq.put("eat", 2589);
    freq.put("he", 44416);
    freq.put("dus", 5910);
    freq.put("yr ", 3697);
    freq.put("dmi", 3335);
    freq.put("va ", 5156);
    freq.put("j", 148253);
    freq.put("lve", 4358);
    freq.put("lva", 3696);
    freq.put("pil", 11406);
    freq.put("iny", 3773);
    freq.put("pin", 7171);
    freq.put("int", 10160);
    freq.put("ins", 19112);
    freq.put("lm ", 3452);
    freq.put("inn", 35697);
    freq.put("ino", 2582);
    freq.put("ini", 7560);
    freq.put("ink", 2146);
    freq.put("ind", 10332);
    freq.put("ine", 16471);
    freq.put("ing", 71844);
    freq.put("ina", 14021);
    freq.put("ta\u030ar", 3969);
    freq.put(" øy", 4235);
    freq.put("or ", 56677);
    freq.put(" øs", 6280);
    freq.put("\u043d", 2997);
    freq.put("hø", 10888);
    freq.put("sva", 4458);
    freq.put("gar", 3339);
    freq.put("U", 16316);
    freq.put("ubb", 3409);
    freq.put("ubl", 5816);
    freq.put("in ", 20575);
    freq.put("Mar", 5164);
    freq.put("eol", 2061);
    freq.put("eor", 2578);
    freq.put("sst", 2689);
  }
  
}

