package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class NL extends CLangProfile {
  private static final String name = "nl";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public NL() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 56157687;
    n_words[1] = 65372177;
    n_words[2] = 47614417;

    freq.put("sco", 5845);
    freq.put("nwo", 81256);
    freq.put("aug", 10264);
    freq.put("o\u0302", 9257);
    freq.put("aut", 12900);
    freq.put("pte", 13585);
    freq.put(" Gu", 7630);
    freq.put(" Gr", 28204);
    freq.put(" Ge", 21536);
    freq.put(" Ga", 13216);
    freq.put(" Go", 11879);
    freq.put(" Gi", 5928);
    freq.put("au ", 9748);
    freq.put("Gu", 7667);
    freq.put("Gr", 28322);
    freq.put("e\u0308", 58538);
    freq.put("Ge", 21620);
    freq.put("Ga", 13267);
    freq.put("Go", 11925);
    freq.put("Gi", 5965);
    freq.put(" ka", 34673);
    freq.put("me ", 20464);
    freq.put(" ke", 15418);
    freq.put(" ki", 8773);
    freq.put(" ko", 24113);
    freq.put(" kl", 14578);
    freq.put(" km", 25898);
    freq.put(" kr", 8283);
    freq.put("Ce", 10546);
    freq.put(" ku", 10447);
    freq.put("n", 5174765);
    freq.put("nen", 38308);
    freq.put("nel", 9354);
    freq.put("nem", 7134);
    freq.put("nee", 12320);
    freq.put("kun", 16374);
    freq.put("ain", 18706);
    freq.put("net", 10080);
    freq.put("ak ", 11574);
    freq.put("ner", 92669);
    freq.put("nes", 17246);
    freq.put("mee", 138208);
    freq.put("dep", 43953);
    freq.put("mel", 11918);
    freq.put("men", 146532);
    freq.put("mei", 13406);
    freq.put("ors", 16087);
    freq.put("met", 69732);
    freq.put("mes", 6603);
    freq.put("mer", 72670);
    freq.put("ee ", 19989);
    freq.put("Zi", 6830);
    freq.put("aks", 6554);
    freq.put("Ze", 12835);
    freq.put("k", 957853);
    freq.put("ne ", 58920);
    freq.put("akt", 91851);
    freq.put("dri", 17764);
    freq.put("orm", 37127);
    freq.put("dro", 6043);
    freq.put("dra", 19458);
    freq.put("Zu", 10609);
    freq.put("Zw", 13009);
    freq.put("ake", 12657);
    freq.put("sje", 10417);
    freq.put("nk ", 5831);
    freq.put("sso", 6523);
    freq.put("bru", 26538);
    freq.put("bro", 7591);
    freq.put("bri", 6013);
    freq.put("bre", 7181);
    freq.put("bra", 10008);
    freq.put("m ", 155936);
    freq.put("vol", 30369);
    freq.put("er ", 333095);
    freq.put("ni ", 14308);
    freq.put("Sta", 16762);
    freq.put("kst", 6852);
    freq.put("nkr", 6212);
    freq.put("V", 96433);
    freq.put("me", 492457);
    freq.put("md", 19425);
    freq.put("erv", 34773);
    freq.put("erw", 12350);
    freq.put("ma", 206926);
    freq.put("err", 17024);
    freq.put("mb", 60844);
    freq.put("mm", 32963);
    freq.put("mo", 56705);
    freq.put("mi", 91034);
    freq.put("erz", 13202);
    freq.put("mu", 25483);
    freq.put("ere", 86052);
    freq.put("erg", 28574);
    freq.put("era", 27762);
    freq.put("erb", 15858);
    freq.put("erl", 61155);
    freq.put("erm", 20928);
    freq.put("ern", 29282);
    freq.put("ero", 16315);
    freq.put("my", 6479);
    freq.put("eri", 98353);
    freq.put("erk", 43542);
    freq.put("Le", 21847);
    freq.put("Nat", 6561);
    freq.put("La", 31976);
    freq.put("Lo", 28450);
    freq.put("uar", 23535);
    freq.put("la ", 16552);
    freq.put("Li", 19176);
    freq.put("Lu", 12150);
    freq.put("ena", 20359);
    freq.put("enb", 15906);
    freq.put("hoe", 5979);
    freq.put("end", 77370);
    freq.put("ene", 28524);
    freq.put("eng", 11580);
    freq.put("enh", 7989);
    freq.put("hoo", 29440);
    freq.put("hol", 9679);
    freq.put("enk", 9463);
    freq.put("enl", 7298);
    freq.put("enn", 18048);
    freq.put("eno", 20895);
    freq.put("enr", 11987);
    freq.put("hou", 16715);
    freq.put("hor", 9181);
    freq.put("m2", 22643);
    freq.put("sse", 83731);
    freq.put("A", 221658);
    freq.put("lan", 133760);
    freq.put("lai", 7568);
    freq.put("lak", 20347);
    freq.put("lad", 5854);
    freq.put("lag", 14890);
    freq.put("ost", 29293);
    freq.put("laa", 121868);
    freq.put("lac", 19544);
    freq.put("II ", 7320);
    freq.put("ove", 41666);
    freq.put("lat", 13164);
    freq.put("ovi", 34676);
    freq.put("lar", 5948);
    freq.put("las", 13782);
    freq.put("en ", 1373884);
    freq.put("Alp", 5725);
    freq.put("zee", 6519);
    freq.put("lt ", 100197);
    freq.put("zen", 14435);
    freq.put(" Hu", 6795);
    freq.put(" Hi", 30725);
    freq.put("oni", 32623);
    freq.put(" Ho", 26988);
    freq.put("zet", 5935);
    freq.put(" Ha", 29997);
    freq.put(" He", 95105);
    freq.put("ima", 5906);
    freq.put("ime", 7803);
    freq.put("ssa", 7327);
    freq.put("fic", 10500);
    freq.put(" ga", 6353);
    freq.put("fie", 5840);
    freq.put("clu", 9316);
    freq.put("Hij", 21364);
    freq.put("re\u0301", 7748);
    freq.put("fil", 14418);
    freq.put(" Va", 15750);
    freq.put("ze ", 24809);
    freq.put(" Ve", 22303);
    freq.put(" Vi", 16318);
    freq.put(" Vl", 8585);
    freq.put(" Vo", 12506);
    freq.put("im ", 7764);
    freq.put("l", 2174413);
    freq.put("nt ", 140657);
    freq.put("rt", 187734);
    freq.put("ru", 73560);
    freq.put("rv", 44462);
    freq.put("gon", 7132);
    freq.put("rp", 27084);
    freq.put("rr", 71892);
    freq.put("rs", 228779);
    freq.put(" ze", 21870);
    freq.put("dst", 15322);
    freq.put(" za", 9390);
    freq.put("ry", 14720);
    freq.put("rz", 20638);
    freq.put("rd", 257870);
    freq.put("re", 392586);
    freq.put("rf", 11818);
    freq.put("rg", 84498);
    freq.put("ra", 285112);
    freq.put("rb", 33548);
    freq.put("rc", 25722);
    freq.put("rl", 117376);
    freq.put("rm", 70366);
    freq.put("rn", 60686);
    freq.put("is ", 431822);
    freq.put("rh", 16037);
    freq.put("ri", 419079);
    freq.put("rk", 74650);
    freq.put("nty", 25239);
    freq.put("nts", 8743);
    freq.put("ntr", 16443);
    freq.put("ntw", 10449);
    freq.put("nti", 22690);
    freq.put("W", 76478);
    freq.put("nta", 19603);
    freq.put("nie", 28378);
    freq.put("nte", 152583);
    freq.put("ate", 41676);
    freq.put("ata", 7505);
    freq.put("iss", 57247);
    freq.put("ato", 8717);
    freq.put("ath", 9399);
    freq.put("ati", 71342);
    freq.put("att", 6300);
    freq.put("atu", 9691);
    freq.put("r ", 577062);
    freq.put("ats", 113866);
    freq.put("isc", 89426);
    freq.put("isa", 6882);
    freq.put("ise", 13845);
    freq.put("Dui", 29012);
    freq.put("nha", 5738);
    freq.put("i ", 117137);
    freq.put("tem", 61681);
    freq.put("tor", 20776);
    freq.put("Cen", 7181);
    freq.put("tow", 6284);
    freq.put("tot", 36145);
    freq.put("ton", 34234);
    freq.put("tob", 10290);
    freq.put("kt ", 89985);
    freq.put("toe", 15554);
    freq.put(" le", 24338);
    freq.put("B", 178586);
    freq.put(" la", 36262);
    freq.put(" lo", 6645);
    freq.put(" li", 33990);
    freq.put("i\u0301", 7570);
    freq.put("kto", 10642);
    freq.put("kte", 24985);
    freq.put("to ", 11397);
    freq.put("thu", 8037);
    freq.put("rag", 7326);
    freq.put("rad", 10061);
    freq.put("lbu", 9341);
    freq.put("rac", 17496);
    freq.put("raa", 43729);
    freq.put("ran", 87841);
    freq.put("ral", 17891);
    freq.put("ram", 11943);
    freq.put("ty ", 41728);
    freq.put("ose", 6693);
    freq.put("rat", 17581);
    freq.put("ras", 7988);
    freq.put("do ", 6228);
    freq.put("on ", 90823);
    freq.put("ra ", 17662);
    freq.put("y", 211813);
    freq.put("ogr", 8544);
    freq.put("tse", 38669);
    freq.put("don", 8072);
    freq.put("doo", 63254);
    freq.put("dom", 7397);
    freq.put("doc", 6254);
    freq.put("m", 1301830);
    freq.put("Ita", 15181);
    freq.put("dor", 15099);
    freq.put("lpe", 6305);
    freq.put(" We", 22829);
    freq.put(" Wa", 15180);
    freq.put(" Wo", 6660);
    freq.put("ude", 20442);
    freq.put("d ", 427738);
    freq.put(" Wi", 21285);
    freq.put("oge", 15686);
    freq.put("e\u0301n", 13925);
    freq.put("och", 15236);
    freq.put("ock", 8061);
    freq.put("em ", 17335);
    freq.put("e\u0301n ", 8357);
    freq.put("sto", 24680);
    freq.put("hri", 17051);
    freq.put("hre", 7796);
    freq.put("do", 126396);
    freq.put("dk", 6604);
    freq.put("dh", 8510);
    freq.put("di", 281697);
    freq.put("dg", 6934);
    freq.put("dd", 20989);
    freq.put("de", 1265409);
    freq.put("da", 122637);
    freq.put("e\u0301 ", 8856);
    freq.put("dt", 42741);
    freq.put("du", 30903);
    freq.put("dr", 53877);
    freq.put("ds", 99321);
    freq.put("eme", 213429);
    freq.put("emd", 11991);
    freq.put("ema", 13115);
    freq.put("bas", 9398);
    freq.put("emb", 35339);
    freq.put("emi", 9436);
    freq.put("Rij", 7380);
    freq.put("baa", 7632);
    freq.put("ban", 15026);
    freq.put("bal", 21186);
    freq.put("om ", 28845);
    freq.put("w ", 28312);
    freq.put("Per", 5867);
    freq.put("e\u0301e\u0301", 7636);
    freq.put("num", 6116);
    freq.put("nua", 11671);
    freq.put("il ", 19641);
    freq.put("muz", 8520);
    freq.put("un ", 7353);
    freq.put("co ", 6846);
    freq.put("Rus", 11905);
    freq.put("ire", 19679);
    freq.put("omb", 6304);
    freq.put("we", 181101);
    freq.put("wd", 6545);
    freq.put("wa", 155603);
    freq.put("wo", 161887);
    freq.put("wn", 7387);
    freq.put("omi", 12146);
    freq.put(" Is", 5895);
    freq.put(" It", 15839);
    freq.put("wi", 58960);
    freq.put("oms", 11302);
    freq.put("omp", 15805);
    freq.put("ws", 8197);
    freq.put(" In", 31514);
    freq.put("omt", 12605);
    freq.put("elo", 7411);
    freq.put("gge", 6516);
    freq.put("ild", 8065);
    freq.put("ile", 5842);
    freq.put("unt", 32613);
    freq.put("han", 20214);
    freq.put("ila", 17614);
    freq.put("ilo", 7646);
    freq.put("ill", 44186);
    freq.put("ilm", 12944);
    freq.put("ili", 39663);
    freq.put(" II", 6497);
    freq.put("und", 14286);
    freq.put("ir ", 7395);
    freq.put("uni", 16955);
    freq.put("com", 22591);
    freq.put("con", 15186);
    freq.put("kwa", 5842);
    freq.put(" me", 105531);
    freq.put(" ma", 109683);
    freq.put("had", 6694);
    freq.put(" mo", 19517);
    freq.put(" mi", 19475);
    freq.put(" mu", 11657);
    freq.put("ie\u0308", 52728);
    freq.put("rga", 14305);
    freq.put("C ", 12680);
    freq.put("pro", 59321);
    freq.put("nie\u0308", 12014);
    freq.put("Ci", 5986);
    freq.put("Ch", 35435);
    freq.put("Co", 57452);
    freq.put("Cl", 7287);
    freq.put("Ca", 38690);
    freq.put("ais", 6111);
    freq.put("air", 10562);
    freq.put("ail", 5969);
    freq.put("gna", 8227);
    freq.put("gne", 9405);
    freq.put("Cr", 6279);
    freq.put("sla", 28873);
    freq.put("Cu", 5824);
    freq.put("ix", 5720);
    freq.put("iz", 17029);
    freq.put("ip", 26974);
    freq.put("is", 722822);
    freq.put("ir", 54494);
    freq.put("iu", 13498);
    freq.put("it", 333187);
    freq.put("iw", 8456);
    freq.put("iv", 35131);
    freq.put("ik", 93516);
    freq.put("ij", 364327);
    freq.put("im", 40230);
    freq.put("il", 169468);
    freq.put("io", 144997);
    freq.put("in", 879621);
    freq.put("ia", 95834);
    freq.put("opp", 20304);
    freq.put("ic", 175476);
    freq.put("ki ", 12463);
    freq.put("jk ", 66346);
    freq.put("id", 125660);
    freq.put("ig", 142126);
    freq.put("if", 16130);
    freq.put("V ", 6513);
    freq.put("ep ", 11271);
    freq.put("th ", 11037);
    freq.put("nin", 21782);
    freq.put("nic", 7027);
    freq.put("nia", 7786);
    freq.put("nig", 15471);
    freq.put("jks", 11628);
    freq.put("kin", 23405);
    freq.put("Y", 11382);
    freq.put("jke", 29064);
    freq.put("niv", 5902);
    freq.put("mil", 24349);
    freq.put("Va", 15790);
    freq.put("Ve", 22438);
    freq.put("Vi", 16383);
    freq.put("ept", 12657);
    freq.put("Vl", 8595);
    freq.put("Vo", 12732);
    freq.put("tho", 11376);
    freq.put("the", 28515);
    freq.put("epe", 6552);
    freq.put("tha", 9247);
    freq.put("epa", 50447);
    freq.put("dse", 26450);
    freq.put("rn ", 7785);
    freq.put("op ", 79508);
    freq.put("zoo", 6798);
    freq.put("elk", 7255);
    freq.put("eli", 59882);
    freq.put("hal", 11321);
    freq.put("ham", 9052);
    freq.put("ell", 29565);
    freq.put("haa", 16281);
    freq.put("ela", 20546);
    freq.put("elf", 9763);
    freq.put("elg", 17311);
    freq.put("eld", 60315);
    freq.put("ele", 68456);
    freq.put("hap", 31501);
    freq.put("els", 48151);
    freq.put("har", 17692);
    freq.put("elt", 76311);
    freq.put("rni", 6410);
    freq.put("rno", 7457);
    freq.put("D", 295391);
    freq.put("rna", 17955);
    freq.put("rne", 14489);
    freq.put("ope", 17398);
    freq.put("opg", 12331);
    freq.put("vis", 16850);
    freq.put("el ", 169543);
    freq.put("i\u0308", 7308);
    freq.put("ola", 5947);
    freq.put("old", 6867);
    freq.put("ole", 13281);
    freq.put("olg", 11475);
    freq.put(" Ju", 6264);
    freq.put("oli", 23091);
    freq.put("olk", 19645);
    freq.put("oll", 13695);
    freq.put("olo", 16700);
    freq.put(" Jo", 19317);
    freq.put("ols", 13292);
    freq.put(" Je", 8879);
    freq.put(" Ja", 19556);
    freq.put("rg ", 25954);
    freq.put("ici", 9264);
    freq.put("ich", 59319);
    freq.put("ico", 6343);
    freq.put("for", 15464);
    freq.put("ica", 19828);
    freq.put("ice", 15194);
    freq.put("Hu", 6810);
    freq.put("Hi", 30742);
    freq.put("Ho", 27037);
    freq.put("umb", 6654);
    freq.put("Ha", 30031);
    freq.put("icu", 11018);
    freq.put("ict", 38543);
    freq.put("ol ", 12318);
    freq.put("ple", 6523);
    freq.put("pla", 118636);
    freq.put("obe", 14031);
    freq.put("o", 3044475);
    freq.put("um ", 25713);
    freq.put("zui", 10334);
    freq.put("ppe", 30477);
    freq.put("mbe", 34190);
    freq.put("soo", 14382);
    freq.put("son", 16537);
    freq.put("ne\u0301", 6017);
    freq.put("gis", 18136);
    freq.put("waa", 29854);
    freq.put("gie", 9618);
    freq.put("gio", 63608);
    freq.put("gin", 20458);
    freq.put("mt ", 13658);
    freq.put("wat", 9640);
    freq.put("was", 80249);
    freq.put("war", 13183);
    freq.put("Een", 16908);
    freq.put("Z", 56681);
    freq.put("nni", 9362);
    freq.put("nne", 42144);
    freq.put("nna", 5969);
    freq.put("Sin", 5858);
    freq.put("nke", 14949);
    freq.put("nh", 15116);
    freq.put("ni", 168878);
    freq.put("nk", 43137);
    freq.put("nl", 16899);
    freq.put("nm", 6930);
    freq.put("nn", 67675);
    freq.put("no", 95599);
    freq.put("tit", 9886);
    freq.put("na", 201890);
    freq.put("nb", 21559);
    freq.put("nc", 69092);
    freq.put("nd", 473575);
    freq.put("ne", 270200);
    freq.put("nf", 9979);
    freq.put("ng", 259192);
    freq.put("ny", 9083);
    freq.put("nz", 11234);
    freq.put("tio", 32273);
    freq.put("tij", 29417);
    freq.put("tie", 72965);
    freq.put("nr", 14733);
    freq.put("ns", 284103);
    freq.put("nt", 435391);
    freq.put("nu", 31030);
    freq.put("nv", 13925);
    freq.put("nw", 88548);
    freq.put(" ni", 13445);
    freq.put("E", 101171);
    freq.put(" no", 28282);
    freq.put(" na", 55514);
    freq.put(" ne", 8341);
    freq.put(" nu", 5724);
    freq.put("n ", 2543334);
    freq.put("Wil", 9135);
    freq.put("rk ", 23012);
    freq.put("Tsj", 8380);
    freq.put("rom", 9424);
    freq.put("ron", 74395);
    freq.put("roo", 21289);
    freq.put("roc", 11802);
    freq.put("rod", 10405);
    freq.put("roe", 27621);
    freq.put("rog", 7078);
    freq.put("lli", 22272);
    freq.put("llo", 6485);
    freq.put("rop", 13868);
    freq.put("lla", 18593);
    freq.put("ros", 6652);
    freq.put("rot", 12676);
    freq.put("rou", 11473);
    freq.put("rov", 34172);
    freq.put("ver", 131519);
    freq.put("di ", 6337);
    freq.put("vee", 14817);
    freq.put("ven", 47801);
    freq.put("vel", 12213);
    freq.put("vem", 9979);
    freq.put("jve", 8311);
    freq.put("ert", 36463);
    freq.put("ey ", 9860);
    freq.put("ro ", 8067);
    freq.put("erp", 10525);
    freq.put("ll ", 9099);
    freq.put("nla", 8754);
    freq.put("din", 21044);
    freq.put("dio", 7262);
    freq.put("die", 85548);
    freq.put("ers", 189637);
    freq.put("dia", 8442);
    freq.put("dic", 13497);
    freq.put("gus", 11645);
    freq.put("p", 897097);
    freq.put("ve ", 13676);
    freq.put("dit", 10793);
    freq.put("He", 95269);
    freq.put("der", 192741);
    freq.put("dis", 79203);
    freq.put("hte", 21726);
    freq.put(" Yo", 6266);
    freq.put("hti", 8381);
    freq.put("hth", 9745);
    freq.put("hts", 6548);
    freq.put("Gra", 6848);
    freq.put("Gro", 9812);
    freq.put("Gri", 6704);
    freq.put("erd", 117197);
    freq.put("mt", 19679);
    freq.put("ek ", 28609);
    freq.put("mp", 51654);
    freq.put("Me", 24563);
    freq.put("rua", 9937);
    freq.put("Ma", 59234);
    freq.put("ms", 35581);
    freq.put("ht ", 49854);
    freq.put("Mo", 28002);
    freq.put("Mi", 26609);
    freq.put("bi", 87840);
    freq.put("Mu", 7133);
    freq.put("oek", 14333);
    freq.put("die\u0308", 7942);
    freq.put("erh", 11977);
    freq.put("bor", 10260);
    freq.put("bou", 11481);
    freq.put("dee", 111320);
    freq.put("bon", 5829);
    freq.put("ekt", 9522);
    freq.put("eks", 13762);
    freq.put("boe", 8360);
    freq.put("oem", 15572);
    freq.put("oel", 8698);
    freq.put("jan", 13106);
    freq.put(" Ka", 21414);
    freq.put(" Ke", 10042);
    freq.put("Vla", 7545);
    freq.put(" Ki", 7899);
    freq.put(" Ko", 15401);
    freq.put(" Kr", 9517);
    freq.put("ca ", 12312);
    freq.put("ood", 7845);
    freq.put("oog", 15636);
    freq.put("oof", 13207);
    freq.put("ngr", 7754);
    freq.put("Bel", 16135);
    freq.put("F", 127232);
    freq.put("oom", 10898);
    freq.put("ool", 15370);
    freq.put("oon", 17563);
    freq.put("ooi", 6071);
    freq.put("ook", 25159);
    freq.put("ma ", 13279);
    freq.put("oot", 15244);
    freq.put("oop", 6797);
    freq.put("oos", 12524);
    freq.put("oor", 222103);
    freq.put("Ber", 10327);
    freq.put("a\u0308", 6605);
    freq.put("car", 7029);
    freq.put("ay ", 8013);
    freq.put("ult", 7652);
    freq.put("cat", 5698);
    freq.put("uli", 14819);
    freq.put("ula", 6204);
    freq.put("ms ", 12121);
    freq.put(" on", 84624);
    freq.put(" oo", 33765);
    freq.put(" om", 21439);
    freq.put(" ok", 9997);
    freq.put("ger", 43727);
    freq.put(" of", 50488);
    freq.put("spr", 14426);
    freq.put("Mid", 7429);
    freq.put("spi", 6360);
    freq.put("spo", 12356);
    freq.put(" ov", 18421);
    freq.put(" ou", 7125);
    freq.put(" or", 11383);
    freq.put("spe", 34342);
    freq.put(" op", 114061);
    freq.put("gez", 31827);
    freq.put("s ", 1176543);
    freq.put("mar", 12201);
    freq.put("mat", 12974);
    freq.put("use", 7901);
    freq.put("maa", 102890);
    freq.put("enc", 8130);
    freq.put("mal", 14307);
    freq.put("man", 28303);
    freq.put("sz", 5928);
    freq.put("sy", 14252);
    freq.put("ss", 138251);
    freq.put("sr", 6378);
    freq.put("sp", 74738);
    freq.put("sw", 6865);
    freq.put("sv", 9064);
    freq.put("su", 28639);
    freq.put("st", 562933);
    freq.put("q", 14380);
    freq.put("sj", 16338);
    freq.put("si", 98258);
    freq.put("sh", 26990);
    freq.put("so", 59040);
    freq.put("sn", 9526);
    freq.put("sm", 15035);
    freq.put("sl", 43368);
    freq.put("sc", 205927);
    freq.put("sb", 15979);
    freq.put("sa", 44187);
    freq.put("sg", 6293);
    freq.put("se", 425364);
    freq.put("sd", 20593);
    freq.put("Ru", 16114);
    freq.put("lse", 20318);
    freq.put("gee", 9960);
    freq.put("Chi", 8065);
    freq.put("no ", 10798);
    freq.put("Re", 17106);
    freq.put("lst", 25217);
    freq.put("Ra", 12538);
    freq.put("Ro", 32707);
    freq.put("Rh", 6524);
    freq.put("Ri", 17272);
    freq.put("tte", 25599);
    freq.put(" aa", 54537);
    freq.put(" ac", 15329);
    freq.put(" af", 19870);
    freq.put("geo", 6626);
    freq.put(" al", 65830);
    freq.put(" an", 19082);
    freq.put(" ap", 11762);
    freq.put(" ar", 47665);
    freq.put("ens", 81592);
    freq.put(" au", 17140);
    freq.put("ent", 262064);
    freq.put("gel", 56245);
    freq.put("nom", 9568);
    freq.put("noo", 19104);
    freq.put("ls ", 61450);
    freq.put("noe", 11549);
    freq.put("enw", 7353);
    freq.put("kke", 14372);
    freq.put("ng ", 100478);
    freq.put("nov", 12875);
    freq.put("gt ", 25727);
    freq.put("h", 1157193);
    freq.put("em", 320296);
    freq.put("el", 605553);
    freq.put("eo", 27881);
    freq.put("en", 2016971);
    freq.put("ei", 156611);
    freq.put("eh", 28491);
    freq.put("ek", 125240);
    freq.put("ee", 952339);
    freq.put("ed", 198243);
    freq.put("eg", 168269);
    freq.put("ef", 50847);
    freq.put("ea", 48028);
    freq.put("ec", 86712);
    freq.put("eb", 81350);
    freq.put("ey", 15758);
    freq.put("ex", 17157);
    freq.put("ez", 66338);
    freq.put("eu", 69138);
    freq.put("et", 590121);
    freq.put("ew", 31588);
    freq.put("ev", 102331);
    freq.put("ep", 103855);
    freq.put("es", 318427);
    freq.put("er", 1223846);
    freq.put("bli", 10301);
    freq.put("os ", 12938);
    freq.put("Joh", 7769);
    freq.put("bla", 6463);
    freq.put("rlo", 10187);
    freq.put("rli", 43352);
    freq.put("G", 105530);
    freq.put("rle", 10232);
    freq.put("ort", 47654);
    freq.put("rla", 47955);
    freq.put("e ", 2100607);
    freq.put("orp", 13450);
    freq.put("orn", 13425);
    freq.put("orl", 12130);
    freq.put("dig", 22881);
    freq.put("ork", 12244);
    freq.put("ori", 18821);
    freq.put("org", 20784);
    freq.put("ord", 94351);
    freq.put("ore", 21033);
    freq.put("ora", 14333);
    freq.put("zan", 8216);
    freq.put("xi", 7194);
    freq.put("onn", 9985);
    freq.put("ono", 10092);
    freq.put("ona", 29547);
    freq.put("ong", 27845);
    freq.put("ond", 144852);
    freq.put("one", 97393);
    freq.put("ons", 14560);
    freq.put("ont", 39227);
    freq.put("Eur", 9786);
    freq.put("ial", 9076);
    freq.put("ian", 13694);
    freq.put("iaa", 21077);
    freq.put("iat", 6807);
    freq.put(" Zi", 6778);
    freq.put(" Ze", 12821);
    freq.put("hum", 5764);
    freq.put("x ", 20927);
    freq.put("hui", 10622);
    freq.put("ebi", 14653);
    freq.put(" Zu", 10598);
    freq.put(" Zw", 13007);
    freq.put("ia ", 31791);
    freq.put("r", 3420928);
    freq.put("and", 178626);
    freq.put("ane", 9267);
    freq.put("ang", 46635);
    freq.put("ana", 20565);
    freq.put("sam", 7637);
    freq.put("anc", 16651);
    freq.put("ann", 16248);
    freq.put("ano", 8039);
    freq.put("pri", 21984);
    freq.put("ani", 27973);
    freq.put("ank", 15316);
    freq.put("ant", 55265);
    freq.put("anu", 16559);
    freq.put("ans", 143853);
    freq.put("sat", 5699);
    freq.put("Do", 13572);
    freq.put("zoe", 7835);
    freq.put("Di", 16644);
    freq.put("De", 198026);
    freq.put("zon", 12147);
    freq.put("Da", 14497);
    freq.put("2", 22665);
    freq.put("\u0435", 6745);
    freq.put("Du", 33850);
    freq.put("Dr", 5649);
    freq.put("an ", 555423);
    freq.put("iwo", 7073);
    freq.put(" Le", 21646);
    freq.put(" La", 31862);
    freq.put(" Lo", 28411);
    freq.put(" Li", 18941);
    freq.put(" Lu", 12123);
    freq.put("Wes", 9343);
    freq.put("Wer", 5760);
    freq.put("ge ", 59115);
    freq.put("We", 22896);
    freq.put("Wa", 15248);
    freq.put("Wo", 6733);
    freq.put("ce ", 27218);
    freq.put("lub", 9599);
    freq.put("Wi", 21345);
    freq.put("\u0430", 10448);
    freq.put("itg", 14085);
    freq.put("ges", 41787);
    freq.put(" pr", 57908);
    freq.put("gep", 6253);
    freq.put("gew", 8731);
    freq.put("gev", 26798);
    freq.put("get", 5657);
    freq.put("H", 199830);
    freq.put("geb", 49406);
    freq.put(" pa", 24621);
    freq.put("ssi", 25931);
    freq.put("zel", 8377);
    freq.put(" pe", 20368);
    freq.put("ged", 10354);
    freq.put("gek", 5735);
    freq.put("geh", 10722);
    freq.put(" po", 21982);
    freq.put("gen", 119618);
    freq.put("gem", 117467);
    freq.put(" pl", 113070);
    freq.put("ute", 13524);
    freq.put("o\u0301", 9442);
    freq.put("uto", 6696);
    freq.put("rma", 25601);
    freq.put("rme", 14051);
    freq.put("j ", 85100);
    freq.put("itt", 7963);
    freq.put("nis", 35078);
    freq.put("rko", 8091);
    freq.put("tur", 6970);
    freq.put("ju", 22953);
    freq.put("jv", 11516);
    freq.put("tus", 27504);
    freq.put("tuu", 41013);
    freq.put("js", 16655);
    freq.put("jn", 70736);
    freq.put("jo", 13034);
    freq.put("jk", 115620);
    freq.put("jd", 31240);
    freq.put("je", 41083);
    freq.put("jf", 10910);
    freq.put("tud", 6157);
    freq.put("ja", 41826);
    freq.put(" be", 166033);
    freq.put(" ba", 14963);
    freq.put(" bl", 6588);
    freq.put(" bo", 19486);
    freq.put(" bi", 41311);
    freq.put("rm ", 8899);
    freq.put(" bu", 9669);
    freq.put("s", 3058116);
    freq.put(" br", 10013);
    freq.put("por", 10136);
    freq.put("pon", 6968);
    freq.put("poo", 7190);
    freq.put("pol", 16543);
    freq.put("ei ", 13562);
    freq.put("eis", 7935);
    freq.put("eit", 10871);
    freq.put("eiz", 7508);
    freq.put("eid", 39967);
    freq.put("eig", 6260);
    freq.put("eil", 21113);
    freq.put("ein", 30892);
    freq.put("ive", 12826);
    freq.put("Ti", 10118);
    freq.put("ivi", 15930);
    freq.put("Bar", 6393);
    freq.put("rwe", 7689);
    freq.put(" Me", 24479);
    freq.put("par", 65094);
    freq.put(" Ma", 59034);
    freq.put(" Mo", 27929);
    freq.put(" Mi", 26529);
    freq.put(" Mu", 7091);
    freq.put("rwi", 6024);
    freq.put("I ", 14576);
    freq.put("cem", 10124);
    freq.put("pan", 11481);
    freq.put("see", 12427);
    freq.put("I", 105198);
    freq.put("II", 10036);
    freq.put("naa", 50268);
    freq.put("oiw", 7018);
    freq.put("gaa", 11487);
    freq.put("ois", 5765);
    freq.put("oir", 6590);
    freq.put("Is", 5913);
    freq.put("It", 15844);
    freq.put("In", 31628);
    freq.put("ck", 28358);
    freq.put("am ", 47277);
    freq.put("gde", 10792);
    freq.put("uid", 29632);
    freq.put("nam", 19197);
    freq.put("tin", 21180);
    freq.put(" ge", 303157);
    freq.put("ami", 28047);
    freq.put("amm", 8429);
    freq.put("ama", 9230);
    freq.put("amb", 6788);
    freq.put("ame", 31772);
    freq.put("gd ", 7871);
    freq.put("mon", 14109);
    freq.put(" go", 7687);
    freq.put("amp", 20053);
    freq.put("ams", 9681);
    freq.put("ib", 14735);
    freq.put("moe", 5824);
    freq.put("tig", 17350);
    freq.put("km2", 22590);
    freq.put("ie", 477304);
    freq.put("gri", 8059);
    freq.put("Ned", 43974);
    freq.put("ezi", 32218);
    freq.put("eze", 22604);
    freq.put(" ch", 6021);
    freq.put(" ci", 15694);
    freq.put(" co", 32521);
    freq.put(" ca", 7354);
    freq.put("uik", 15052);
    freq.put(" ce", 11923);
    freq.put("uch", 9124);
    freq.put("dde", 16386);
    freq.put("mpi", 18269);
    freq.put("oo", 370075);
    freq.put("on", 522696);
    freq.put("om", 159575);
    freq.put("ol", 157894);
    freq.put("ok", 52068);
    freq.put("ace", 13447);
    freq.put("oh", 14048);
    freq.put("og", 70046);
    freq.put("of", 83411);
    freq.put("oe", 163750);
    freq.put("ach", 45489);
    freq.put("oc", 46361);
    freq.put("ob", 29747);
    freq.put("oa", 14423);
    freq.put("oz", 6517);
    freq.put("oy", 5912);
    freq.put("act", 17739);
    freq.put("ow", 27555);
    freq.put("ov", 88551);
    freq.put("ou", 131520);
    freq.put("ot", 108603);
    freq.put("os", 81239);
    freq.put("or", 483257);
    freq.put("op", 166634);
    freq.put("Ni", 14152);
    freq.put("No", 27858);
    freq.put("Na", 17889);
    freq.put("Ne", 59633);
    freq.put("het", 305470);
    freq.put("log", 16741);
    freq.put("her", 18043);
    freq.put("loe", 7778);
    freq.put("lon", 9738);
    freq.put("loo", 10759);
    freq.put("lom", 7994);
    freq.put("lor", 5860);
    freq.put("hee", 28005);
    freq.put("hel", 11001);
    freq.put("hem", 8872);
    freq.put("hen", 9035);
    freq.put("hei", 31175);
    freq.put("J", 61744);
    freq.put("jun", 10013);
    freq.put("jul", 9669);
    freq.put("lo ", 6322);
    freq.put("as ", 104628);
    freq.put("he ", 78504);
    freq.put("aa", 662152);
    freq.put("ac", 99694);
    freq.put("ab", 30531);
    freq.put("ae", 23635);
    freq.put("ad", 102907);
    freq.put("ag", 85506);
    freq.put("af", 47867);
    freq.put("Hon", 6999);
    freq.put("ah", 10878);
    freq.put("Hol", 6098);
    freq.put("aj", 7035);
    freq.put("am", 172784);
    freq.put("al", 362702);
    freq.put("an", 1131186);
    freq.put("ap", 71362);
    freq.put("as", 187038);
    freq.put("ar", 458993);
    freq.put("au", 65384);
    freq.put("at", 401880);
    freq.put("aw", 6737);
    freq.put("av", 29958);
    freq.put("ay", 18941);
    freq.put("az", 12546);
    freq.put("Lan", 8583);
    freq.put("igt", 11964);
    freq.put("ige", 49060);
    freq.put("igd", 11510);
    freq.put("ota", 7234);
    freq.put("ign", 9284);
    freq.put("igi", 9202);
    freq.put("igh", 9499);
    freq.put("a ", 223995);
    freq.put(" zo", 26839);
    freq.put("rw", 18490);
    freq.put(" zi", 55419);
    freq.put("at ", 119635);
    freq.put("u", 1226136);
    freq.put("Bri", 11166);
    freq.put("ig ", 26250);
    freq.put("uit", 185570);
    freq.put("Bra", 7962);
    freq.put("all", 30537);
    freq.put("sch", 188901);
    freq.put("ali", 53705);
    freq.put("ald", 14462);
    freq.put("ale", 38623);
    freq.put("alb", 11148);
    freq.put("alc", 5747);
    freq.put("ala", 12213);
    freq.put("gt", 35908);
    freq.put("alv", 6355);
    freq.put("gs", 36659);
    freq.put("alt", 35976);
    freq.put("uw ", 14870);
    freq.put("als", 49851);
    freq.put("gr", 72480);
    freq.put("ots", 8865);
    freq.put("tz", 8930);
    freq.put("ty", 46646);
    freq.put("tv", 9249);
    freq.put("tw", 33429);
    freq.put("tt", 45242);
    freq.put("tu", 100531);
    freq.put("tr", 144811);
    freq.put("ts", 211260);
    freq.put("to", 174226);
    freq.put("tl", 14300);
    freq.put("tm", 7826);
    freq.put("tj", 6074);
    freq.put("tk", 6386);
    freq.put("th", 76245);
    freq.put("ti", 257739);
    freq.put("\u0438", 8389);
    freq.put("te", 770637);
    freq.put("tb", 23716);
    freq.put("ta", 261366);
    freq.put("edi", 16531);
    freq.put("ium", 6105);
    freq.put("mpo", 7375);
    freq.put("al ", 74743);
    freq.put("edo", 6698);
    freq.put(" zu", 11699);
    freq.put("fam", 16628);
    freq.put("sme", 5826);
    freq.put("uwe", 13657);
    freq.put("uwd", 6413);
    freq.put(" Ni", 14127);
    freq.put("gg", 9680);
    freq.put("pre", 14246);
    freq.put("ro", 286166);
    freq.put(" No", 27810);
    freq.put("eds", 11135);
    freq.put(" Na", 17815);
    freq.put(" Ne", 59527);
    freq.put("ge", 622849);
    freq.put("dsc", 11185);
    freq.put("t ", 1445388);
    freq.put("tei", 13819);
    freq.put("tek", 11255);
    freq.put("tel", 112278);
    freq.put("ga", 53344);
    freq.put("ten", 116036);
    freq.put("ted", 9251);
    freq.put("tee", 16372);
    freq.put("nbu", 5898);
    freq.put("teg", 10988);
    freq.put("go", 35093);
    freq.put("ter", 133625);
    freq.put("tes", 8744);
    freq.put("teu", 8413);
    freq.put("nbe", 7893);
    freq.put("abe", 6263);
    freq.put("abi", 6431);
    freq.put("sus", 9037);
    freq.put("lle", 62567);
    freq.put("md ", 13491);
    freq.put(" ru", 5958);
    freq.put("te ", 245946);
    freq.put("K", 84088);
    freq.put(" re", 91305);
    freq.put("Noo", 11547);
    freq.put(" ra", 8521);
    freq.put("pub", 6405);
    freq.put(" ro", 16553);
    freq.put(" ri", 13940);
    freq.put("oma", 10713);
    freq.put("lki", 11362);
    freq.put("nto", 19506);
    freq.put("vie", 14100);
    freq.put("vin", 41497);
    freq.put("vil", 13878);
    freq.put("rke", 15492);
    freq.put("S ", 6945);
    freq.put(" s ", 10712);
    freq.put("twe", 21595);
    freq.put("twi", 6118);
    freq.put("jd ", 7717);
    freq.put("de ", 684651);
    freq.put("In ", 14751);
    freq.put("Sp", 19561);
    freq.put("Su", 9985);
    freq.put("St", 35202);
    freq.put("Si", 16384);
    freq.put("Sh", 6081);
    freq.put("So", 16434);
    freq.put("Sl", 6946);
    freq.put("Sc", 16133);
    freq.put("Sa", 42083);
    freq.put("Se", 15433);
    freq.put("a\u0301", 12476);
    freq.put("kle", 13907);
    freq.put("dez", 10434);
    freq.put("kla", 8538);
    freq.put(" di", 128156);
    freq.put("jde", 16692);
    freq.put(" de", 740739);
    freq.put("des", 13390);
    freq.put(" da", 51374);
    freq.put("del", 33701);
    freq.put("den", 135340);
    freq.put("v", 1136367);
    freq.put("Ind", 7590);
    freq.put(" du", 9386);
    freq.put("dec", 12054);
    freq.put(" dr", 11539);
    freq.put("f ", 90198);
    freq.put("ist", 78828);
    freq.put("isi", 11995);
    freq.put("ish", 6473);
    freq.put("eg ", 11274);
    freq.put("fr", 11929);
    freq.put("fs", 14314);
    freq.put("ft", 32454);
    freq.put("fu", 6506);
    freq.put("rmo", 6164);
    freq.put("fa", 30179);
    freq.put("fd", 18426);
    freq.put("fe", 38002);
    freq.put("ff", 17069);
    freq.put("fg", 6573);
    freq.put("fi", 41042);
    freq.put("fl", 6356);
    freq.put("fo", 24009);
    freq.put("a", 4428747);
    freq.put("ry ", 9896);
    freq.put("egi", 74199);
    freq.put("ego", 6580);
    freq.put("ds ", 31717);
    freq.put("o\u0308", 12215);
    freq.put("ege", 50512);
    freq.put("iti", 26080);
    freq.put("y ", 100628);
    freq.put("ite", 28930);
    freq.put("ita", 16110);
    freq.put("ok ", 26496);
    freq.put("ffi", 6818);
    freq.put("ity", 14389);
    freq.put("ffe", 6190);
    freq.put("its", 47572);
    freq.put(" Oo", 13036);
    freq.put(" Ol", 9537);
    freq.put("e\u0308 ", 43502);
    freq.put("paa", 13416);
    freq.put(" Or", 9466);
    freq.put(" Op", 6330);
    freq.put("ym", 12848);
    freq.put("yl", 8352);
    freq.put("cea", 6367);
    freq.put("yn", 9021);
    freq.put("ya", 8170);
    freq.put("cen", 17525);
    freq.put("yc", 6275);
    freq.put("ye", 6127);
    freq.put("L", 124657);
    freq.put("it ", 148319);
    freq.put("ces", 6110);
    freq.put("yp", 6946);
    freq.put("ys", 18578);
    freq.put("yr", 9415);
    freq.put(" sy", 6615);
    freq.put("Eng", 13833);
    freq.put(" sp", 31376);
    freq.put(" st", 111138);
    freq.put(" su", 9964);
    freq.put(" si", 12277);
    freq.put(" so", 18785);
    freq.put(" sl", 6445);
    freq.put(" sc", 26028);
    freq.put(" sa", 9420);
    freq.put(" se", 22896);
    freq.put("ize", 7008);
    freq.put("ass", 19856);
    freq.put("ast", 27312);
    freq.put(" Al", 28811);
    freq.put(" Am", 55975);
    freq.put(" An", 22679);
    freq.put(" Ar", 23451);
    freq.put(" Au", 12111);
    freq.put("ase", 7343);
    freq.put("mme", 17999);
    freq.put("Uni", 5818);
    freq.put("asi", 6239);
    freq.put("mma", 6643);
    freq.put("El", 7917);
    freq.put("En", 17423);
    freq.put("Ee", 19326);
    freq.put("ft ", 25649);
    freq.put("w", 618312);
    freq.put("Eu", 11420);
    freq.put("Er", 8327);
    freq.put("le ", 71663);
    freq.put("Fra", 63542);
    freq.put("ie\u0308 ", 43280);
    freq.put(" el", 9897);
    freq.put(" en", 320059);
    freq.put("kom", 21374);
    freq.put(" ei", 19716);
    freq.put("kon", 7670);
    freq.put(" ee", 469095);
    freq.put("dt ", 39781);
    freq.put("lie\u0308", 7455);
    freq.put("jec", 10400);
    freq.put(" et", 7087);
    freq.put("kor", 8329);
    freq.put(" er", 11018);
    freq.put("ods", 9122);
    freq.put("Zwe", 6862);
    freq.put("odu", 7865);
    freq.put("nch", 8196);
    freq.put("nci", 34445);
    freq.put("nce", 13701);
    freq.put("aad", 5831);
    freq.put("aag", 19367);
    freq.put("b", 675678);
    freq.put("sta", 134037);
    freq.put("aam", 28835);
    freq.put("aal", 41110);
    freq.put("aan", 153725);
    freq.put(" e ", 8358);
    freq.put("sti", 36773);
    freq.put("aak", 81870);
    freq.put("aat", 183677);
    freq.put("je ", 16212);
    freq.put("aas", 6793);
    freq.put("aar", 125046);
    freq.put("ka ", 11569);
    freq.put("js ", 7214);
    freq.put("sh ", 6367);
    freq.put("lie", 40870);
    freq.put("Ze ", 6085);
    freq.put("k ", 193827);
    freq.put("lia", 22468);
    freq.put("lic", 12334);
    freq.put("lin", 41169);
    freq.put("eft", 21131);
    freq.put("lij", 95486);
    freq.put("lit", 19124);
    freq.put("2 ", 22661);
    freq.put("lis", 19817);
    freq.put("rol", 11209);
    freq.put("kaa", 47537);
    freq.put("pec", 7014);
    freq.put("M", 162943);
    freq.put("kan", 26234);
    freq.put("kam", 11248);
    freq.put("jst", 5685);
    freq.put("rha", 6318);
    freq.put("The", 11210);
    freq.put("ka", 118671);
    freq.put("li ", 13675);
    freq.put("ke", 182363);
    freq.put("kk", 20620);
    freq.put("ki", 53710);
    freq.put("kh", 5862);
    freq.put("ko", 60158);
    freq.put("kn", 6593);
    freq.put("km", 27830);
    freq.put("kl", 29172);
    freq.put("ks", 46927);
    freq.put("kr", 23259);
    freq.put("kw", 7713);
    freq.put("ku", 22530);
    freq.put("kt", 131352);
    freq.put("ef ", 10385);
    freq.put("rte", 64198);
    freq.put("rta", 7455);
    freq.put("\u4e00", 6916);
    freq.put("rto", 9036);
    freq.put("rti", 18904);
    freq.put("rth", 8072);
    freq.put("rts", 6565);
    freq.put("ugu", 11498);
    freq.put("ymp", 7552);
    freq.put("Ju", 6270);
    freq.put("ies", 24371);
    freq.put("ier", 48258);
    freq.put("ieu", 11845);
    freq.put("iet", 21274);
    freq.put("iev", 7556);
    freq.put("iek", 35699);
    freq.put("Jo", 19365);
    freq.put("iem", 5824);
    freq.put("iel", 12150);
    freq.put("ien", 50882);
    freq.put("Je", 8912);
    freq.put("ied", 23758);
    freq.put("ief", 9097);
    freq.put("his", 12860);
    freq.put("rt ", 52830);
    freq.put("ste", 153650);
    freq.put("aaf", 9902);
    freq.put("hie", 14941);
    freq.put("hij", 15137);
    freq.put("okt", 10174);
    freq.put("hil", 13952);
    freq.put("hin", 11368);
    freq.put("ie ", 201388);
    freq.put(" Be", 44588);
    freq.put("arr", 46599);
    freq.put("ars", 14646);
    freq.put("art", 89778);
    freq.put("ser", 23257);
    freq.put("sep", 12185);
    freq.put(" Bl", 5783);
    freq.put(" Bo", 26752);
    freq.put(" Bi", 11811);
    freq.put(" Bu", 10803);
    freq.put("ara", 15993);
    freq.put("arb", 9145);
    freq.put("arc", 10579);
    freq.put("ard", 36005);
    freq.put("are", 27820);
    freq.put(" Br", 34502);
    freq.put("ari", 63150);
    freq.put("sem", 40984);
    freq.put("ark", 11271);
    freq.put("arl", 11777);
    freq.put("arm", 7787);
    freq.put("arn", 8226);
    freq.put("aro", 16161);
    freq.put("stu", 49771);
    freq.put("wor", 46676);
    freq.put("woo", 12376);
    freq.put("won", 83488);
    freq.put("woi", 6978);
    freq.put("wod", 7070);
    freq.put("str", 76216);
    freq.put("ikt", 10786);
    freq.put("uur", 48711);
    freq.put("ar ", 70080);
    freq.put("ika", 50912);
    freq.put("ike", 6423);
    freq.put("se ", 245903);
    freq.put("ikk", 7357);
    freq.put(" Pr", 15952);
    freq.put("c", 885504);
    freq.put(" Pa", 35403);
    freq.put(" Pe", 16009);
    freq.put(" Pi", 14002);
    freq.put(" Po", 29977);
    freq.put("wen", 7541);
    freq.put("tge", 17358);
    freq.put("pr", 99751);
    freq.put("ps", 14478);
    freq.put("pp", 39364);
    freq.put("pt", 24055);
    freq.put("pu", 20157);
    freq.put("duc", 8131);
    freq.put("pa", 116725);
    freq.put("pg", 12730);
    freq.put("pe", 152921);
    freq.put("ph", 12783);
    freq.put("pi", 48220);
    freq.put("po", 60048);
    freq.put("pl", 132966);
    freq.put("nri", 8599);
    freq.put("rdt", 29462);
    freq.put(" tw", 15968);
    freq.put(" tu", 14723);
    freq.put("wet", 5976);
    freq.put(" tr", 11805);
    freq.put("N", 137196);
    freq.put(" to", 58623);
    freq.put("gan", 14683);
    freq.put(" ti", 18789);
    freq.put(" th", 14839);
    freq.put(" te", 138599);
    freq.put(" ta", 9836);
    freq.put("p ", 141470);
    freq.put("Oly", 6017);
    freq.put("eke", 48960);
    freq.put("voe", 25269);
    freq.put("riv", 7770);
    freq.put("rit", 17759);
    freq.put("voo", 92340);
    freq.put("ris", 26171);
    freq.put("rip", 6607);
    freq.put("rin", 39022);
    freq.put("rio", 7162);
    freq.put("ril", 12296);
    freq.put("rij", 60217);
    freq.put("rik", 53920);
    freq.put("vor", 15339);
    freq.put("rig", 10543);
    freq.put("rid", 8288);
    freq.put("rie", 42534);
    freq.put("ric", 60714);
    freq.put("ria", 15453);
    freq.put("ewo", 5810);
    freq.put("ewe", 9375);
    freq.put("Cor", 5822);
    freq.put("Cou", 26493);
    freq.put("tis", 23784);
    freq.put(" do", 72769);
    freq.put("lig", 34482);
    freq.put("Com", 7136);
    freq.put("ri ", 27658);
    freq.put("Con", 6541);
    freq.put("gst", 8398);
    freq.put("ew ", 6999);
    freq.put(" fa", 15977);
    freq.put(" fe", 12855);
    freq.put("gsd", 8056);
    freq.put(" fi", 16445);
    freq.put(" fo", 5946);
    freq.put("lde", 29685);
    freq.put("uzi", 9073);
    freq.put("cus", 11312);
    freq.put("\u043e", 8805);
    freq.put("rge", 20743);
    freq.put("rgi", 6243);
    freq.put("app", 11428);
    freq.put("bin", 13224);
    freq.put("Ol", 9544);
    freq.put("bij", 36202);
    freq.put("bie", 17101);
    freq.put("ngt", 6149);
    freq.put("e\u0301e\u0301n", 7621);
    freq.put("bis", 7734);
    freq.put("Op", 6344);
    freq.put("d", 2549536);
    freq.put("eeu", 10006);
    freq.put("eet", 5732);
    freq.put("ees", 22270);
    freq.put("eer", 87604);
    freq.put("eem", 7130);
    freq.put("eel", 149087);
    freq.put("ai", 53889);
    freq.put("een", 586471);
    freq.put("eek", 11355);
    freq.put("eed", 19633);
    freq.put("eef", 23903);
    freq.put("ijs", 16040);
    freq.put("b ", 17772);
    freq.put("ijv", 11367);
    freq.put("ld ", 39055);
    freq.put("ijd", 30969);
    freq.put("ije", 8022);
    freq.put("ijf", 10866);
    freq.put("ijk", 115115);
    freq.put("ijn", 70104);
    freq.put("per", 54393);
    freq.put("pes", 8975);
    freq.put("pel", 26450);
    freq.put("pen", 27399);
    freq.put("pee", 13839);
    freq.put("id ", 39722);
    freq.put("t", 3691802);
    freq.put("be", 276525);
    freq.put("rui", 23623);
    freq.put("ba", 76157);
    freq.put("bb", 9494);
    freq.put("rum", 7291);
    freq.put("bl", 25851);
    freq.put("oer", 17651);
    freq.put("bo", 58794);
    freq.put("Bou", 5646);
    freq.put("O", 83395);
    freq.put("oet", 21912);
    freq.put("ij ", 80452);
    freq.put("bu", 44669);
    freq.put("oen", 24849);
    freq.put("br", 58403);
    freq.put("bs", 5841);
    freq.put("rus", 7171);
    freq.put("oeg", 10025);
    freq.put("von", 6589);
    freq.put("oed", 12901);
    freq.put("Rom", 5676);
    freq.put("idi", 13237);
    freq.put("idd", 13665);
    freq.put("ide", 28170);
    freq.put("pe ", 6304);
    freq.put("ida", 12788);
    freq.put("wn ", 6464);
    freq.put("mst", 14316);
    freq.put("nsc", 14189);
    freq.put("nse", 133099);
    freq.put(" ui", 144553);
    freq.put("nst", 31383);
    freq.put("nsu", 9180);
    freq.put("ut ", 6738);
    freq.put("ust", 24814);
    freq.put("Oos", 10737);
    freq.put("uss", 30621);
    freq.put("u ", 30645);
    freq.put("zic", 12949);
    freq.put(" Ch", 35359);
    freq.put(" Ci", 5893);
    freq.put(" Co", 57213);
    freq.put(" Cl", 7183);
    freq.put("ns ", 66627);
    freq.put(" Ca", 38284);
    freq.put(" Ce", 10523);
    freq.put(" Cr", 6209);
    freq.put("sdi", 9330);
    freq.put(" Cu", 5704);
    freq.put("cia", 10705);
    freq.put("fde", 6413);
    freq.put("ux", 8237);
    freq.put("cie", 34119);
    freq.put("uz", 15014);
    freq.put("uu", 52115);
    freq.put("ut", 46184);
    freq.put("uw", 44437);
    freq.put("uv", 7894);
    freq.put("up", 10064);
    freq.put("us", 143221);
    freq.put("ur", 165500);
    freq.put("um", 51805);
    freq.put("ul", 55545);
    freq.put("un", 100952);
    freq.put("ui", 271759);
    freq.put("uk", 10265);
    freq.put("cit", 10702);
    freq.put("ue", 25713);
    freq.put("ud", 45500);
    freq.put("ug", 30034);
    freq.put("z", 331215);
    freq.put("ua", 33926);
    freq.put("uc", 29841);
    freq.put("ub", 30475);
    freq.put("Tu", 6976);
    freq.put("Tr", 10760);
    freq.put("Ts", 9146);
    freq.put("To", 14361);
    freq.put("Th", 19966);
    freq.put("New", 6417);
    freq.put("lym", 7416);
    freq.put("Te", 13194);
    freq.put("Ta", 10688);
    freq.put("A ", 9463);
    freq.put("Mar", 24247);
    freq.put(" gr", 38760);
    freq.put("tic", 17261);
    freq.put("nad", 6211);
    freq.put("nan", 5995);
    freq.put("nal", 19401);
    freq.put("ag ", 18180);
    freq.put("gre", 7606);
    freq.put("nat", 22785);
    freq.put("gra", 24600);
    freq.put("gro", 30942);
    freq.put("Man", 6806);
    freq.put("Zui", 9741);
    freq.put("agn", 7735);
    freq.put("na ", 37268);
    freq.put("e", 9521882);
    freq.put("age", 22392);
    freq.put("Am", 55987);
    freq.put("Al", 28901);
    freq.put("An", 22709);
    freq.put("Ar", 23539);
    freq.put("Au", 12206);
    freq.put("agt", 10140);
    freq.put(" b", 268848);
    freq.put(" c", 85027);
    freq.put("gu", 24589);
    freq.put(" a", 271750);
    freq.put(" f", 60480);
    freq.put(" g", 362770);
    freq.put(" d", 1022256);
    freq.put(" e", 865604);
    freq.put(" j", 55299);
    freq.put(" k", 151715);
    freq.put(" h", 429647);
    freq.put(" i", 863484);
    freq.put(" n", 113728);
    freq.put(" o", 359305);
    freq.put(" l", 108039);
    freq.put(" m", 271385);
    freq.put(" r", 136806);
    freq.put(" s", 272741);
    freq.put(" p", 253369);
    freq.put("gd", 23906);
    freq.put(" v", 736662);
    freq.put(" w", 287907);
    freq.put(" t", 287237);
    freq.put(" u", 151127);
    freq.put(" z", 129440);
    freq.put("gn", 22691);
    freq.put("gl", 11647);
    freq.put("gi", 125274);
    freq.put("gh", 17920);
    freq.put(" B", 171895);
    freq.put(" C", 177462);
    freq.put(" A", 209281);
    freq.put(" F", 122253);
    freq.put(" G", 98641);
    freq.put(" D", 289943);
    freq.put(" E", 96010);
    freq.put(" J", 58839);
    freq.put(" K", 80686);
    freq.put(" H", 197094);
    freq.put(" I", 88140);
    freq.put(" N", 131673);
    freq.put(" O", 75874);
    freq.put(" L", 120300);
    freq.put(" M", 156963);
    freq.put(" R", 108525);
    freq.put(" S", 205129);
    freq.put(" P", 136936);
    freq.put(" V", 87489);
    freq.put(" W", 74232);
    freq.put(" T", 105528);
    freq.put(" U", 20421);
    freq.put(" Z", 55679);
    freq.put(" Y", 11046);
    freq.put("lks", 5894);
    freq.put("Nor", 10502);
    freq.put("vli", 6207);
    freq.put("ch ", 51967);
    freq.put("ed ", 30096);
    freq.put("vla", 21113);
    freq.put("P", 145276);
    freq.put("g ", 209248);
    freq.put("tri", 58554);
    freq.put("evi", 14484);
    freq.put("tro", 22667);
    freq.put("evo", 21109);
    freq.put("tra", 31398);
    freq.put("eva", 7494);
    freq.put("us ", 63461);
    freq.put("tre", 20553);
    freq.put("eve", 54896);
    freq.put("Spa", 11230);
    freq.put("tru", 9236);
    freq.put("rro", 41654);
    freq.put("zo", 49094);
    freq.put("zi", 116688);
    freq.put("rri", 6371);
    freq.put("ze", 78298);
    freq.put("rre", 14498);
    freq.put(" e\u0301", 7785);
    freq.put("za", 31109);
    freq.put("doe", 8162);
    freq.put("zu", 15798);
    freq.put("ode", 16327);
    freq.put("med", 7669);
    freq.put("ct ", 40340);
    freq.put("rd ", 94954);
    freq.put("lec", 6605);
    freq.put("led", 8570);
    freq.put("lee", 17156);
    freq.put("leg", 19493);
    freq.put("lei", 20020);
    freq.put("z ", 13752);
    freq.put("lem", 10140);
    freq.put("len", 59840);
    freq.put("ler", 20832);
    freq.put("les", 15192);
    freq.put("let", 7945);
    freq.put("lev", 15162);
    freq.put("od ", 7190);
    freq.put("eni", 29460);
    freq.put("rde", 80930);
    freq.put("cte", 10141);
    freq.put("rda", 12870);
    freq.put("rdo", 6848);
    freq.put("ule", 6125);
    freq.put("rdi", 16416);
    freq.put("cti", 18928);
    freq.put(" Do", 13329);
    freq.put("Ver", 12912);
    freq.put(" Di", 16596);
    freq.put("apr", 10161);
    freq.put("win", 7741);
    freq.put(" De", 197691);
    freq.put("wij", 18720);
    freq.put(" Da", 14480);
    freq.put("wit", 7604);
    freq.put(" Du", 33818);
    freq.put("apa", 7428);
    freq.put("cha", 49925);
    freq.put("Fr", 73223);
    freq.put("feb", 9777);
    freq.put("che", 90373);
    freq.put("fen", 6207);
    freq.put("chi", 44310);
    freq.put("usi", 5945);
    freq.put("cho", 18169);
    freq.put("Fa", 6211);
    freq.put("chr", 21384);
    freq.put("zie", 38234);
    freq.put("cht", 101737);
    freq.put("Fe", 6923);
    freq.put("Fi", 11740);
    freq.put("zij", 41913);
    freq.put("Fo", 9924);
    freq.put("ue ", 5767);
    freq.put("ap ", 25134);
    freq.put(" Ru", 16099);
    freq.put("oi", 33928);
    freq.put("f", 358313);
    freq.put("Ja", 19607);
    freq.put(" Re", 17067);
    freq.put("nda", 12836);
    freq.put(" Ra", 12376);
    freq.put(" Ro", 32636);
    freq.put(" Ri", 17238);
    freq.put(" Rh", 6521);
    freq.put("tat", 25594);
    freq.put("od", 56125);
    freq.put("tar", 9576);
    freq.put("\u0440", 6363);
    freq.put("tad", 33209);
    freq.put("taa", 79421);
    freq.put("tal", 42563);
    freq.put("tan", 24920);
    freq.put("tai", 6439);
    freq.put(" va", 481040);
    freq.put(" ve", 76969);
    freq.put("Yo", 6270);
    freq.put("sit", 8909);
    freq.put(" vi", 22015);
    freq.put(" vl", 9586);
    freq.put(" vo", 131543);
    freq.put(" vr", 12217);
    freq.put("sig", 6448);
    freq.put("sie", 18702);
    freq.put("dwe", 6219);
    freq.put("sin", 18433);
    freq.put("afs", 8757);
    freq.put("sis", 17171);
    freq.put("ta ", 14225);
    freq.put("af ", 10774);
    freq.put("jns", 7518);
    freq.put("da ", 11415);
    freq.put("dw", 10868);
    freq.put("lf", 20122);
    freq.put("lg", 36498);
    freq.put("ld", 95337);
    freq.put("le", 302236);
    freq.put("lb", 22338);
    freq.put("lc", 8500);
    freq.put("la", 398196);
    freq.put("lo", 99408);
    freq.put("ll", 128927);
    freq.put("lm", 24809);
    freq.put("lk", 34257);
    freq.put("lh", 5934);
    freq.put("li", 338485);
    freq.put("lv", 15042);
    freq.put("lt", 126691);
    freq.put("lu", 37402);
    freq.put("ls", 119057);
    freq.put("lp", 13038);
    freq.put("euw", 17939);
    freq.put("ly", 17100);
    freq.put("dae", 7793);
    freq.put("dag", 8773);
    freq.put("daa", 13978);
    freq.put("Car", 7946);
    freq.put("dan", 11068);
    freq.put("dat", 38507);
    freq.put("jn ", 50205);
    freq.put("Cal", 8797);
    freq.put("bar", 8019);
    freq.put("Sai", 9817);
    freq.put("San", 8826);
    freq.put("l ", 299819);
    freq.put(" hu", 11200);
    freq.put(" hi", 19625);
    freq.put(" ho", 31679);
    freq.put(" ha", 22481);
    freq.put(" he", 342958);
    freq.put("oun", 29232);
    freq.put("oud", 23948);
    freq.put("wes", 10367);
    freq.put("ous", 5891);
    freq.put("our", 16621);
    freq.put("ouw", 19904);
    freq.put("out", 8877);
    freq.put("res", 26172);
    freq.put("rev", 8098);
    freq.put("ret", 8087);
    freq.put("rek", 7399);
    freq.put("rei", 15261);
    freq.put("ren", 91873);
    freq.put("wer", 76690);
    freq.put("rel", 18716);
    freq.put("rec", 16838);
    freq.put("rea", 7679);
    freq.put("reg", 76191);
    freq.put("red", 11064);
    freq.put("ree", 20672);
    freq.put("ece", 11419);
    freq.put("lf ", 5640);
    freq.put("eco", 6380);
    freq.put("ou ", 6777);
    freq.put("eci", 6720);
    freq.put("ech", 31918);
    freq.put("ect", 16877);
    freq.put("que", 5834);
    freq.put("x", 48411);
    freq.put("g", 1325585);
    freq.put("lte", 6994);
    freq.put("re ", 58121);
    freq.put("u\u0308", 12035);
    freq.put("pge", 11800);
    freq.put("rs ", 114967);
    freq.put(" Ba", 28861);
    freq.put("og ", 18782);
    freq.put("los", 5784);
    freq.put(" Sp", 19500);
    freq.put(" St", 34839);
    freq.put(" Su", 9973);
    freq.put(" Sh", 6028);
    freq.put(" Si", 16291);
    freq.put(" So", 16378);
    freq.put(" Sl", 6935);
    freq.put(" Sc", 16056);
    freq.put(" Sa", 42032);
    freq.put(" Se", 15382);
    freq.put("Ka", 21546);
    freq.put("rso", 10142);
    freq.put("rsi", 7125);
    freq.put("Ke", 10121);
    freq.put("rse", 16920);
    freq.put("Ki", 7967);
    freq.put("Ko", 15418);
    freq.put("rsc", 16580);
    freq.put("Kr", 9527);
    freq.put("R", 114676);
    freq.put("ogi", 8951);
    freq.put("eho", 15902);
    freq.put("rst", 29072);
    freq.put("udi", 6485);
    freq.put("rsp", 13174);
    freq.put("bek", 19147);
    freq.put("beh", 12808);
    freq.put("ben", 9807);
    freq.put("bel", 14825);
    freq.put("beg", 7886);
    freq.put("bed", 18175);
    freq.put("bee", 12385);
    freq.put("ik ", 10619);
    freq.put("ber", 72483);
    freq.put("bes", 52050);
    freq.put("bev", 17462);
    freq.put("bet", 13589);
    freq.put("Par", 11966);
    freq.put("sen", 46205);
    freq.put("sk", 33909);
    freq.put("sel", 17905);
    freq.put("ur ", 31687);
    freq.put("ck ", 10471);
    freq.put("min", 20688);
    freq.put("mie", 5852);
    freq.put("mid", 8678);
    freq.put("mig", 6106);
    freq.put("hr", 30422);
    freq.put("sei", 5692);
    freq.put("mis", 8333);
    freq.put("mit", 6248);
    freq.put(" El", 7895);
    freq.put(" En", 17358);
    freq.put(" Ee", 19260);
    freq.put("st ", 68174);
    freq.put(" Eu", 11409);
    freq.put("ny ", 6026);
    freq.put(" Er", 8309);
    freq.put("ure", 14305);
    freq.put("urg", 25394);
    freq.put("url", 29792);
    freq.put("uro", 10683);
    freq.put("uri", 10844);
    freq.put("urt", 8342);
    freq.put("Poo", 9123);
    freq.put("Cha", 14656);
    freq.put("eda", 9229);
    freq.put("nge", 85205);
    freq.put("nga", 9441);
    freq.put(" is", 385652);
    freq.put("jar", 7927);
    freq.put("kse", 13533);
    freq.put("ae ", 14725);
    freq.put("Mon", 9837);
    freq.put(" in", 468125);
    freq.put("ngs", 24028);
    freq.put("Oo", 13070);
    freq.put("jaa", 10547);
    freq.put("tba", 18995);
    freq.put(" we", 90321);
    freq.put("qu", 12987);
    freq.put(" wa", 118659);
    freq.put(" wo", 59080);
    freq.put(" wi", 19128);
    freq.put("ks ", 13043);
    freq.put("shi", 8681);
    freq.put("m2 ", 22639);
    freq.put("Pr", 15997);
    freq.put("ebe", 6342);
    freq.put("eba", 5684);
    freq.put("ebo", 12775);
    freq.put("C", 193400);
    freq.put("ke ", 43164);
    freq.put("Pa", 35566);
    freq.put("ebr", 30709);
    freq.put("Pe", 17479);
    freq.put("ede", 93412);
    freq.put("Pi", 14013);
    freq.put("Po", 30054);
    freq.put("ome", 31512);
    freq.put("et ", 468269);
    freq.put("lip", 6344);
    freq.put("ken", 67439);
    freq.put("kel", 22383);
    freq.put("kee", 5719);
    freq.put("S", 218863);
    freq.put("omm", 12297);
    freq.put("vro", 6819);
    freq.put("ker", 29057);
    freq.put("etr", 9667);
    freq.put("ets", 6968);
    freq.put("ett", 13669);
    freq.put("e\u0300", 10784);
    freq.put("etb", 16830);
    freq.put("eta", 11379);
    freq.put("tle", 5983);
    freq.put("ete", 33498);
    freq.put("eth", 6048);
    freq.put("eti", 8945);
    freq.put("Het", 68660);
    freq.put("ci", 82756);
    freq.put("ch", 396490);
    freq.put("co", 70369);
    freq.put("Her", 7011);
    freq.put("cl", 14976);
    freq.put("ot ", 44568);
    freq.put("ca", 46321);
    freq.put("rva", 8120);
    freq.put("ce", 87968);
    freq.put("tsc", 8839);
    freq.put("rpe", 6605);
    freq.put("cr", 11311);
    freq.put("cu", 23421);
    freq.put("ct", 84409);
    freq.put("rve", 6455);
    freq.put("bbe", 6915);
    freq.put("ys ", 5784);
    freq.put(" e\u0301e\u0301", 7588);
    freq.put("ak", 138064);
    freq.put("oth", 6889);
    freq.put("lgi", 13560);
    freq.put("oto", 6753);
    freq.put("rvo", 6709);
    freq.put("c ", 16305);
    freq.put("ote", 16152);
    freq.put("lge", 14115);
    freq.put("rp ", 10130);
    freq.put("uns", 8285);
    freq.put("rvl", 18128);
    freq.put("ott", 8284);
    freq.put("tst", 17796);
    freq.put("e\u0301", 54151);
    freq.put("uis", 15533);
    freq.put("Ant", 6487);
    freq.put("rbi", 10377);
    freq.put("rbe", 8163);
    freq.put("eur", 21284);
    freq.put("yst", 6749);
    freq.put("va", 525240);
    freq.put(" Fr", 73181);
    freq.put("ve", 243007);
    freq.put("vi", 112804);
    freq.put("vl", 34784);
    freq.put("vo", 180923);
    freq.put(" Fa", 6133);
    freq.put("vr", 17131);
    freq.put(" Fe", 6899);
    freq.put("avi", 8222);
    freq.put(" Fi", 11695);
    freq.put("ave", 10618);
    freq.put(" Fo", 9883);
    freq.put("io ", 71745);
    freq.put("of ", 51317);
    freq.put("pis", 8712);
    freq.put("edr", 18455);
    freq.put("dam", 12288);
    freq.put("v ", 8380);
    freq.put("ion", 45782);
    freq.put("ioe", 9616);
    freq.put("off", 7132);
    freq.put("ofd", 11478);
    freq.put("i", 4146613);
    freq.put(" Tu", 6926);
    freq.put(" Ts", 9134);
    freq.put(" Tr", 10698);
    freq.put(" To", 14233);
    freq.put(" Ti", 10088);
    freq.put(" Th", 19903);
    freq.put(" Te", 13125);
    freq.put(" Ta", 10649);
    freq.put("mpe", 6753);
    freq.put("Be", 44722);
    freq.put("weg", 14286);
    freq.put("Ba", 28977);
    freq.put("wee", 29661);
    freq.put("Bl", 5807);
    freq.put("Bo", 26862);
    freq.put("Bi", 11873);
    freq.put("wel", 18559);
    freq.put("ske", 6724);
    freq.put("Bu", 10850);
    freq.put("ade", 19021);
    freq.put("Br", 34564);
    freq.put("ada", 5737);
    freq.put("ski", 9665);
    freq.put("adi", 11143);
    freq.put("T", 111990);
    freq.put("ad ", 41911);
    freq.put("oep", 14118);
    freq.put("ts ", 120548);
    freq.put("est", 111009);
    freq.put("ess", 14653);
    freq.put("esp", 11543);
    freq.put("nd ", 125333);
    freq.put("ese", 16953);
    freq.put("esc", 18281);
    freq.put("esl", 15451);
    freq.put("esi", 12100);
    freq.put("dui", 6443);
    freq.put("Un", 6926);
    freq.put("ndi", 65506);
    freq.put("Sch", 12674);
    freq.put("ndo", 10563);
    freq.put(" ju", 21208);
    freq.put("nde", 170234);
    freq.put("kri", 8432);
    freq.put("es ", 93024);
    freq.put("rug", 6639);
    freq.put("nds", 53318);
    freq.put("ndr", 9897);
    freq.put(" ja", 26885);
    freq.put("own", 6969);
    freq.put("De ", 168413);
    freq.put("h ", 79224);
    freq.put("van", 455616);
    freq.put("val", 33641);
    freq.put("vaa", 8390);
    freq.put("Ame", 44932);
    freq.put("rch", 10326);
    freq.put("tg", 20068);
    freq.put("Ams", 6535);
    freq.put("vat", 5892);
    freq.put("Dez", 5967);
    freq.put("bur", 21107);
    freq.put("ht", 107458);
    freq.put("hu", 34327);
    freq.put("hi", 99792);
    freq.put("hn", 9649);
    freq.put("ho", 105347);
    freq.put("bum", 8070);
    freq.put("ha", 140501);
    freq.put("eau", 7092);
    freq.put("Dee", 6161);
    freq.put("he", 517783);
    freq.put("j", 487381);
    freq.put("lve", 5791);
    freq.put("pij", 6479);
    freq.put("pio", 11106);
    freq.put("int", 30127);
    freq.put("inw", 77340);
    freq.put("ins", 19772);
    freq.put("lm ", 10134);
    freq.put("inn", 14337);
    freq.put("ino", 8487);
    freq.put("ub ", 8370);
    freq.put("ini", 14846);
    freq.put("ink", 10381);
    freq.put("ind", 41153);
    freq.put("ine", 33694);
    freq.put("ing", 150853);
    freq.put("ina", 22287);
    freq.put("Or", 9483);
    freq.put("inc", 33586);
    freq.put("oal", 5868);
    freq.put(" Un", 6865);
    freq.put("or ", 123656);
    freq.put("\u043d", 6323);
    freq.put("U", 22509);
    freq.put("ubl", 7698);
    freq.put("in ", 405294);
    freq.put("eor", 9695);
    freq.put("o ", 155926);
  }
  
}

