package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class MT extends CLangProfile {
  private static final String name = "mt";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public MT() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 295877;
    n_words[1] = 352145;
    n_words[2] = 290551;

    freq.put("G\u0307ur", 9);
    freq.put("G\u0307un", 82);
    freq.put("\u03b7\u03bc", 3);
    freq.put("G\u0307ud", 3);
    freq.put("e\u0301ry", 3);
    freq.put("IX ", 6);
    freq.put("e\u0301ri", 14);
    freq.put("xta", 5);
    freq.put("e\u0301ra", 3);
    freq.put("xti", 4);
    freq.put("C\u0307 ", 3);
    freq.put("e ", 1044);
    freq.put("xa ", 30);
    freq.put("k", 6729);
    freq.put("C\u0307i", 37);
    freq.put("C\u0307e", 23);
    freq.put("G\u0307uz\u0307", 11);
    freq.put("dne", 4);
    freq.put("dna", 7);
    freq.put("dni", 387);
    freq.put("dnu", 3);
    freq.put("tx ", 12);
    freq.put("jmi", 5);
    freq.put("ajf", 12);
    freq.put("Le", 203);
    freq.put("Lb", 9);
    freq.put("La", 209);
    freq.put("Lo", 67);
    freq.put("Lj", 4);
    freq.put("Lh", 13);
    freq.put("Li", 133);
    freq.put("Lv", 23);
    freq.put("Lu", 69);
    freq.put("Ly", 6);
    freq.put("hoc", 10);
    freq.put("hon", 18);
    freq.put("hol", 28);
    freq.put("hom", 201);
    freq.put("\u03b1\u0301", 9);
    freq.put("hoi", 6);
    freq.put("hot", 60);
    freq.put("hou", 3);
    freq.put("hor", 7);
    freq.put("hop", 3);
    freq.put("hi", 760);
    freq.put("A", 980);
    freq.put("\u0421", 3);
    freq.put("\u0645", 18);
    freq.put("L ", 276);
    freq.put("\u03bf\u03c2 ", 9);
    freq.put("tqa", 5);
    freq.put("u\u0304", 5);
    freq.put("zan", 9);
    freq.put("\u0126az\u0307", 13);
    freq.put("Eul", 3);
    freq.put("fir", 68);
    freq.put("fis", 452);
    freq.put("ro\u0308", 5);
    freq.put("fit", 85);
    freq.put("ro\u0301", 6);
    freq.put("fiz", 3);
    freq.put("fix", 32);
    freq.put("fif", 3);
    freq.put("fig", 28);
    freq.put("fid", 70);
    freq.put("fie", 26);
    freq.put("fij", 20);
    freq.put("fik", 254);
    freq.put("Hij", 20);
    freq.put("fin", 101);
    freq.put("re\u0301", 10);
    freq.put("fil", 923);
    freq.put("fim", 18);
    freq.put(" Va", 62);
    freq.put(" Ve", 40);
    freq.put("au ", 3);
    freq.put(" Vi", 49);
    freq.put("Eua", 8);
    freq.put(" Vj", 21);
    freq.put("upl", 3);
    freq.put(" Vo", 5);
    freq.put(" Vu", 3);
    freq.put("unc\u0307", 5);
    freq.put("Hi ", 16);
    freq.put("fi ", 110);
    freq.put("woo", 3);
    freq.put("zaw", 9);
    freq.put("rt", 593);
    freq.put("ru", 1565);
    freq.put("rv", 67);
    freq.put("rw", 15);
    freq.put("rp", 167);
    freq.put("rq", 18);
    freq.put("rr", 290);
    freq.put("rs", 380);
    freq.put("smu", 24);
    freq.put("rx", 13);
    freq.put("ry", 74);
    freq.put("rz", 82);
    freq.put("rd", 579);
    freq.put("re", 1094);
    freq.put("rf", 131);
    freq.put("rg", 183);
    freq.put("ra", 2437);
    freq.put("rb", 214);
    freq.put("rc", 95);
    freq.put("rl", 104);
    freq.put("rm", 361);
    freq.put("rn", 266);
    freq.put("ro", 1129);
    freq.put("rh", 16);
    freq.put("ri", 2756);
    freq.put("sma", 13);
    freq.put("rk", 161);
    freq.put("Z\u0307v", 17);
    freq.put("Z\u0307a", 10);
    freq.put("Z\u0307g", 13);
    freq.put("Z\u0307e", 22);
    freq.put("Z\u0307o", 19);
    freq.put("atf", 4);
    freq.put("ate", 97);
    freq.put("Z\u0307g\u0127", 13);
    freq.put("ata", 353);
    freq.put("ato", 37);
    freq.put("atl", 9);
    freq.put("atm", 5);
    freq.put("ath", 72);
    freq.put("ati", 630);
    freq.put("atv", 10);
    freq.put("att", 399);
    freq.put("atu", 154);
    freq.put("r ", 2171);
    freq.put("ats", 7);
    freq.put("ds ", 10);
    freq.put("Duk", 3);
    freq.put("Dum", 10);
    freq.put("Dun", 12);
    freq.put("\u0126as", 4);
    freq.put("Dub", 4);
    freq.put("Dug", 42);
    freq.put("\u0126al", 14);
    freq.put("\u0126am", 9);
    freq.put("\u0126af", 7);
    freq.put("\u0126ad", 8);
    freq.put("Cef", 4);
    freq.put("xie", 9);
    freq.put("xij", 12);
    freq.put("xim", 17);
    freq.put("fiz\u0307", 33);
    freq.put("xip", 7);
    freq.put("nz ", 8);
    freq.put("xit", 5);
    freq.put("xix", 4);
    freq.put("z\u0307at", 163);
    freq.put("fic\u0307", 68);
    freq.put("xi ", 114);
    freq.put("nzu", 20);
    freq.put("Sof", 3);
    freq.put("i\u0301", 12);
    freq.put("nza", 162);
    freq.put("nze", 4);
    freq.put("nzj", 67);
    freq.put("nzi", 34);
    freq.put("nzo", 4);
    freq.put("hud", 13);
    freq.put("Qaw", 5);
    freq.put("oqs", 8);
    freq.put("oqr", 3);
    freq.put("oqq", 3);
    freq.put("WK ", 4);
    freq.put("oqg", 4);
    freq.put("Qad", 5);
    freq.put("Qab", 9);
    freq.put("Qam", 3);
    freq.put("Son", 9);
    freq.put("Ass", 29);
    freq.put("\u30a2", 3);
    freq.put("Ast", 5);
    freq.put("rz\u0307", 20);
    freq.put("Asj", 53);
    freq.put("Sot", 8);
    freq.put("Sov", 14);
    freq.put("nel", 16);
    freq.put("oq ", 10);
    freq.put("z\u0307fi", 3);
    freq.put("rc\u0307", 42);
    freq.put("knu", 3);
    freq.put("r\u0127", 13);
    freq.put("rg\u0307", 52);
    freq.put("lpi", 7);
    freq.put("neg", 15);
    freq.put("lpa", 4);
    freq.put("ne\u0301 ", 3);
    freq.put("\u0127ba", 36);
    freq.put("\u0127\u0127i", 4);
    freq.put("\u0127bi", 8);
    freq.put("\u0127bu", 18);
    freq.put("X", 115);
    freq.put("Lju", 3);
    freq.put("Riv", 7);
    freq.put("Rit", 5);
    freq.put("Rin", 10);
    freq.put("Rio", 6);
    freq.put("Rif", 10);
    freq.put("e\u0127\u0127", 19);
    freq.put("Ric", 5);
    freq.put("meg", 11);
    freq.put("wt ", 12);
    freq.put("irx", 6);
    freq.put("irq", 11);
    freq.put("irr", 68);
    freq.put("irt", 12);
    freq.put("iru", 15);
    freq.put("irv", 3);
    freq.put("irw", 3);
    freq.put("iri", 47);
    freq.put("irj", 13);
    freq.put("irk", 16);
    freq.put("irm", 8);
    freq.put("iro", 13);
    freq.put("ira", 108);
    freq.put("irb", 6);
    freq.put("irc", 3);
    freq.put("ire", 104);
    freq.put("irg", 5);
    freq.put("wtu", 22);
    freq.put("wto", 19);
    freq.put("ir ", 271);
    freq.put("and", 312);
    freq.put("fra", 178);
    freq.put("fre", 18);
    freq.put("fri", 44);
    freq.put("fro", 37);
    freq.put("e\u0127u", 17);
    freq.put("e\u0127t", 5);
    freq.put("e\u0127o", 47);
    freq.put("fru", 57);
    freq.put("e\u0127b", 3);
    freq.put("e\u0127a", 25);
    freq.put("ann", 156);
    freq.put("e\u0127e", 192);
    freq.put("e\u0127d", 9);
    freq.put("ank", 28);
    freq.put("ant", 399);
    freq.put("G\u0307wa", 22);
    freq.put("anw", 6);
    freq.put("e\u0127 ", 8);
    freq.put("bil", 171);
    freq.put("jk ", 7);
    freq.put("dho", 25);
    freq.put("dhi", 4);
    freq.put("dhe", 12);
    freq.put("dha", 34);
    freq.put("dhr", 5);
    freq.put("\u0441", 5);
    freq.put("bie", 191);
    freq.put("Nat", 9);
    freq.put("jku", 36);
    freq.put("tz ", 5);
    freq.put("jko", 11);
    freq.put("qwa", 22);
    freq.put("bia", 3);
    freq.put("ng\u0307a", 5);
    freq.put("ng\u0307e", 10);
    freq.put("ng\u0307i", 39);
    freq.put("ng\u0307l", 9);
    freq.put("irg\u0307", 5);
    freq.put("ir\u0127", 10);
    freq.put("olo\u0300", 3);
    freq.put("bit", 42);
    freq.put("hai", 4);
    freq.put("hak", 5);
    freq.put("hal", 25);
    freq.put("ham", 10);
    freq.put("han", 36);
    freq.put("hab", 10);
    freq.put("hac", 3);
    freq.put("had", 6);
    freq.put("hae", 10);
    freq.put("haf", 5);
    freq.put("hag", 5);
    freq.put("bni", 43);
    freq.put("har", 108);
    freq.put("has", 3);
    freq.put("hat", 10);
    freq.put("bne", 5);
    freq.put("haw", 8);
    freq.put("ha ", 345);
    freq.put("soc\u0307", 36);
    freq.put("bn ", 3);
    freq.put("uez", 3);
    freq.put("\u03b5\u0301\u03bb", 3);
    freq.put("ola", 297);
    freq.put("old", 21);
    freq.put("ole", 45);
    freq.put("olf", 11);
    freq.put("oli", 234);
    freq.put("olj", 23);
    freq.put("olk", 5);
    freq.put("oll", 317);
    freq.put("olm", 7);
    freq.put("olo", 193);
    freq.put("olp", 5);
    freq.put("olq", 9);
    freq.put("ols", 4);
    freq.put("olt", 4);
    freq.put("olu", 49);
    freq.put("olv", 13);
    freq.put("oly", 18);
    freq.put("olz", 3);
    freq.put("fot", 5);
    freq.put("ump", 15);
    freq.put("for", 103);
    freq.put("fos", 61);
    freq.put("z\u0307em", 11);
    freq.put("ume", 18);
    freq.put("uma", 274);
    freq.put("umb", 15);
    freq.put("fol", 6);
    freq.put("fon", 14);
    freq.put("umn", 4);
    freq.put("umi", 141);
    freq.put("umh", 21);
    freq.put("ol ", 221);
    freq.put(" Xj", 17);
    freq.put(" Xi", 5);
    freq.put(" Xo", 3);
    freq.put(" Xl", 25);
    freq.put(" Xb", 4);
    freq.put(" Xa", 7);
    freq.put(" Xe", 24);
    freq.put("Sig\u0307", 4);
    freq.put("o", 11568);
    freq.put("fo ", 3);
    freq.put("um ", 193);
    freq.put("mbl", 3);
    freq.put("soc", 13);
    freq.put("mbo", 13);
    freq.put("mbi", 7);
    freq.put("mbj", 20);
    freq.put("sof", 30);
    freq.put("Fen", 27);
    freq.put("Fel", 3);
    freq.put("som", 4);
    freq.put("sol", 42);
    freq.put("son", 77);
    freq.put("sop", 7);
    freq.put("sos", 5);
    freq.put("sor", 25);
    freq.put("Fer", 9);
    freq.put("Fes", 42);
    freq.put("sov", 8);
    freq.put("mbu", 7);
    freq.put("mbr", 212);
    freq.put("so ", 5);
    freq.put("\u03c3", 8);
    freq.put("mb ", 14);
    freq.put("azi", 18);
    freq.put("azj", 40);
    freq.put("azz", 558);
    freq.put("Sis", 16);
    freq.put("qil", 4);
    freq.put("qij", 6);
    freq.put("qie", 79);
    freq.put("qif", 6);
    freq.put("d\u0127l", 5);
    freq.put(" Lj", 3);
    freq.put("Sig", 3);
    freq.put("Sie", 3);
    freq.put("Sid", 5);
    freq.put("qiq", 10);
    freq.put("Sin", 7);
    freq.put("qis", 6);
    freq.put("Sil", 9);
    freq.put("o\u0300", 10);
    freq.put("nx ", 3);
    freq.put("\u0641", 4);
    freq.put("E", 578);
    freq.put("tec", 7);
    freq.put("\u03b9\u0301\u03b1 ", 3);
    freq.put("u\u030a", 3);
    freq.put("nxa", 3);
    freq.put("osp", 7);
    freq.put("oss", 207);
    freq.put("osr", 9);
    freq.put("ost", 286);
    freq.put("osi", 29);
    freq.put("osk", 9);
    freq.put("oso", 26);
    freq.put("osn", 3);
    freq.put("osa", 9);
    freq.put("osc", 59);
    freq.put("ose", 14);
    freq.put("osf", 25);
    freq.put("vew", 4);
    freq.put("vet", 4);
    freq.put("ver", 159);
    freq.put("ves", 4);
    freq.put("vez", 6);
    freq.put("ved", 9);
    freq.put("Ta ", 9);
    freq.put("ven", 47);
    freq.put("vel", 47);
    freq.put("vem", 54);
    freq.put("afj", 3);
    freq.put("Me\u0301", 12);
    freq.put("os ", 42);
    freq.put("Tap", 3);
    freq.put("Tar", 7);
    freq.put("Tas", 8);
    freq.put("Taz", 45);
    freq.put("Z\u0307ve", 5);
    freq.put("ve ", 24);
    freq.put("Tal", 81);
    freq.put("Tan", 4);
    freq.put("Taj", 3);
    freq.put("Z\u0307vi", 12);
    freq.put("bd", 97);
    freq.put("M ", 6);
    freq.put("\u0127li", 21);
    freq.put("\u0127lo", 6);
    freq.put("\u0127la", 25);
    freq.put("\u0127le", 5);
    freq.put("s\u0127", 20);
    freq.put("\u0127lu", 12);
    freq.put("Me", 211);
    freq.put("ydo", 19);
    freq.put("Ma", 913);
    freq.put("Mo", 85);
    freq.put("Mi", 192);
    freq.put("Mu", 41);
    freq.put("Mq", 3);
    freq.put("uff", 38);
    freq.put("Ms", 3);
    freq.put("My", 19);
    freq.put("\u05de", 4);
    freq.put("ugi", 10);
    freq.put("Kbi", 7);
    freq.put("z\u0307v", 33);
    freq.put("z\u0307w", 25);
    freq.put("ipa", 54);
    freq.put("z\u0307r", 9);
    freq.put("ipe", 52);
    freq.put("ipj", 6);
    freq.put("ipi", 13);
    freq.put("ipl", 14);
    freq.put("z\u0307f", 3);
    freq.put("z\u0307g", 84);
    freq.put("ipp", 68);
    freq.put("z\u0307e", 280);
    freq.put("z\u0307b", 7);
    freq.put("ipu", 3);
    freq.put("z\u0307n", 10);
    freq.put("z\u0307o", 42);
    freq.put("z\u0307l", 28);
    freq.put("z\u0307m", 149);
    freq.put("z\u0307j", 107);
    freq.put("z\u0307i", 395);
    freq.put("yga", 5);
    freq.put("te\u0301r", 3);
    freq.put("ip ", 18);
    freq.put("z\u0307 ", 381);
    freq.put("su\u0302", 3);
    freq.put("su\u0300", 19);
    freq.put("ov ", 7);
    freq.put("veg\u0307", 6);
    freq.put("Ic\u0307 ", 5);
    freq.put("z\u0307e\u0300", 6);
    freq.put("s ", 2215);
    freq.put("ue\u0302\u0309", 5);
    freq.put("sz", 4);
    freq.put("sy", 8);
    freq.put("ss", 1567);
    freq.put("sr", 42);
    freq.put("sq", 27);
    freq.put("sp", 450);
    freq.put("sw", 37);
    freq.put("su", 681);
    freq.put("st", 1984);
    freq.put("sk", 226);
    freq.put("sj", 193);
    freq.put("si", 1402);
    freq.put("sh", 37);
    freq.put("so", 603);
    freq.put("sn", 58);
    freq.put("sm", 48);
    freq.put("sl", 42);
    freq.put("sc", 111);
    freq.put("sb", 40);
    freq.put("sa", 601);
    freq.put("sg", 10);
    freq.put("sf", 100);
    freq.put("se", 822);
    freq.put("sd", 5);
    freq.put("ttr", 52);
    freq.put("ttq", 3);
    freq.put("ttw", 21);
    freq.put("ttu", 162);
    freq.put("tti", 265);
    freq.put("tto", 418);
    freq.put("Kam", 46);
    freq.put("ttm", 3);
    freq.put("tta", 315);
    freq.put("tte", 116);
    freq.put(" z\u0307w", 7);
    freq.put(" z\u0307v", 13);
    freq.put("jid", 45);
    freq.put("jie", 440);
    freq.put("jib", 17);
    freq.put("jin", 262);
    freq.put("jil", 17);
    freq.put("jim", 15);
    freq.put("jij", 16);
    freq.put("jik", 48);
    freq.put(" z\u0307g", 67);
    freq.put(" z\u0307f", 3);
    freq.put(" z\u0307e", 67);
    freq.put("jir", 36);
    freq.put("jis", 122);
    freq.put(" z\u0307a", 12);
    freq.put(" z\u0307o", 19);
    freq.put(" z\u0307m", 55);
    freq.put(" z\u0307i", 5);
    freq.put("tt ", 180);
    freq.put("onc\u0307", 7);
    freq.put("n\u0127a", 40);
    freq.put("ji ", 115);
    freq.put(" z\u0307 ", 15);
    freq.put("iSt", 5);
    freq.put("Jos", 9);
    freq.put("blu", 4);
    freq.put("blo", 10);
    freq.put("bli", 134);
    freq.put("Joh", 23);
    freq.put("bla", 35);
    freq.put("Jon", 3);
    freq.put("sag\u0307", 5);
    freq.put("sa\u0127", 30);
    freq.put("sac\u0307", 10);
    freq.put("bl ", 127);
    freq.put("onj", 46);
    freq.put("onk", 4);
    freq.put("oni", 826);
    freq.put("onn", 21);
    freq.put("ono", 98);
    freq.put("onc", 4);
    freq.put("ona", 395);
    freq.put("onf", 14);
    freq.put("ong", 75);
    freq.put("ond", 83);
    freq.put("one", 31);
    freq.put("onz", 5);
    freq.put("ony", 4);
    freq.put("ons", 72);
    freq.put("onv", 10);
    freq.put("onw", 7);
    freq.put("ont", 244);
    freq.put("onu", 16);
    freq.put("rz ", 5);
    freq.put(" z\u0307z\u0307", 3);
    freq.put("uko", 130);
    freq.put("ukl", 4);
    freq.put("jiz\u0307", 122);
    freq.put("uka", 17);
    freq.put(" Zi", 3);
    freq.put(" Ze", 9);
    freq.put("on ", 286);
    freq.put(" Za", 7);
    freq.put("jic\u0307", 4);
    freq.put("rze", 4);
    freq.put("rza", 4);
    freq.put("jig\u0307", 86);
    freq.put("rzj", 6);
    freq.put("rzi", 4);
    freq.put("rzu", 56);
    freq.put("sak", 9);
    freq.put("saj", 13);
    freq.put("san", 27);
    freq.put("sam", 26);
    freq.put("sal", 78);
    freq.put("sac", 4);
    freq.put("sab", 114);
    freq.put("sag", 3);
    freq.put("saf", 3);
    freq.put("sax", 4);
    freq.put("sas", 5);
    freq.put("sar", 91);
    freq.put("saq", 6);
    freq.put("sav", 4);
    freq.put("sat", 19);
    freq.put("zok", 4);
    freq.put("zon", 7);
    freq.put("zop", 4);
    freq.put("ax ", 138);
    freq.put("sa ", 139);
    freq.put("zo ", 4);
    freq.put("axx", 30);
    freq.put("xia", 3);
    freq.put("\u0627\u0644", 11);
    freq.put("axi", 9);
    freq.put("axl", 4);
    freq.put("qot", 10);
    freq.put("qos", 11);
    freq.put(" Cr", 17);
    freq.put("Ska", 3);
    freq.put("Sko", 15);
    freq.put("xma", 10);
    freq.put("vid", 6);
    freq.put("Cyn", 6);
    freq.put("fa\u0300 ", 4);
    freq.put("o\u0127\u0127", 9);
    freq.put("ux", 113);
    freq.put("c\u0307c\u0307", 128);
    freq.put("uz", 67);
    freq.put("Tim", 12);
    freq.put("uq", 220);
    freq.put("up", 436);
    freq.put("ur", 936);
    freq.put("z\u0307ba", 3);
    freq.put("um", 746);
    freq.put(" b ", 205);
    freq.put("Aww", 49);
    freq.put("Aws", 49);
    freq.put("vkl", 3);
    freq.put("Awi", 14);
    freq.put("Awa", 10);
    freq.put("cit", 40);
    freq.put(" be", 254);
    freq.put(" bd", 32);
    freq.put("kja", 25);
    freq.put(" ba", 182);
    freq.put(" bb", 9);
    freq.put(" bl", 158);
    freq.put("\u0126el", 6);
    freq.put(" bn", 27);
    freq.put(" bi", 591);
    freq.put(" bu", 8);
    freq.put("s", 11369);
    freq.put("Kri", 26);
    freq.put("\u0126er", 6);
    freq.put("Tch", 3);
    freq.put(" br", 10);
    freq.put("c\u0307a", 55);
    freq.put("o\u0127x", 10);
    freq.put("c\u0307e", 459);
    freq.put("c\u0307k", 4);
    freq.put("c\u0307j", 158);
    freq.put("c\u0307i", 688);
    freq.put("c\u0307l", 3);
    freq.put("o\u0127l", 5);
    freq.put("o\u0127o", 14);
    freq.put("c\u0307u", 7);
    freq.put("c\u0307t", 3);
    freq.put("\u0632", 5);
    freq.put("\u0127ni", 6);
    freq.put("c\u0307 ", 98);
    freq.put("Lva", 23);
    freq.put("fih", 47);
    freq.put("ive", 121);
    freq.put("iva", 120);
    freq.put("ivo", 75);
    freq.put("ivi", 130);
    freq.put("ivj", 3);
    freq.put("vuk", 6);
    freq.put("ivv", 4);
    freq.put(" b\u0127", 386);
    freq.put("Awz\u0307", 5);
    freq.put("\u03b4", 4);
    freq.put("iv ", 71);
    freq.put("I", 1285);
    freq.put("Iz\u0307v", 11);
    freq.put("Iz\u0307r", 9);
    freq.put("Iz\u0307d", 3);
    freq.put("Iz\u0307l", 12);
    freq.put("\u0628\u0646", 3);
    freq.put("Iz\u0307 ", 13);
    freq.put(" gl", 7);
    freq.put("o", 3);
    freq.put("Myl", 5);
    freq.put("Myo", 11);
    freq.put(" gi", 6);
    freq.put("ezz", 60);
    freq.put("ezi", 7);
    freq.put("ezj", 12);
    freq.put("tvj", 10);
    freq.put("eza", 4);
    freq.put("dds", 8);
    freq.put("ddu", 28);
    freq.put("ddi", 89);
    freq.put("ddo", 7);
    freq.put("dda", 25);
    freq.put("dde", 48);
    freq.put("ag\u0307", 137);
    freq.put("a\u0127", 547);
    freq.put("ez ", 9);
    freq.put("acc", 7);
    freq.put("aca", 3);
    freq.put("ace", 19);
    freq.put("ack", 9);
    freq.put("ac\u0307", 265);
    freq.put("ach", 28);
    freq.put("aco", 17);
    freq.put("acr", 57);
    freq.put("act", 11);
    freq.put("dd ", 24);
    freq.put("Nh", 10);
    freq.put("Ni", 43);
    freq.put("bje", 15);
    freq.put("ac\u0327", 5);
    freq.put("No", 118);
    freq.put("uil", 3);
    freq.put("Na", 84);
    freq.put("Ne", 68);
    freq.put("bju", 5);
    freq.put("\u0629 ", 5);
    freq.put("Nu", 9);
    freq.put("hev", 3);
    freq.put("her", 387);
    freq.put("hes", 4);
    freq.put("hed", 6);
    freq.put("\u0432", 8);
    freq.put("hea", 4);
    freq.put("heb", 12);
    freq.put("hec", 23);
    freq.put("hel", 13);
    freq.put("hem", 73);
    freq.put("hen", 29);
    freq.put("hei", 6);
    freq.put("hek", 39);
    freq.put("N ", 9);
    freq.put("he ", 48);
    freq.put("aa", 9);
    freq.put("ac", 174);
    freq.put("ab", 528);
    freq.put("ae", 464);
    freq.put("ad", 608);
    freq.put("ag", 1012);
    freq.put("af", 225);
    freq.put("ai", 63);
    freq.put("ah", 53);
    freq.put("Hol", 5);
    freq.put("aj", 529);
    freq.put("am", 1722);
    freq.put("al", 4958);
    freq.put("ao", 20);
    freq.put("Hoi", 6);
    freq.put("aq", 326);
    freq.put("ap", 319);
    freq.put("as", 1177);
    freq.put("ar", 3008);
    freq.put("au", 97);
    freq.put("at", 2554);
    freq.put("aw", 440);
    freq.put("av", 100);
    freq.put("ay", 28);
    freq.put("ax", 219);
    freq.put("az", 626);
    freq.put("rx ", 6);
    freq.put("a ", 13038);
    freq.put("at ", 709);
    freq.put("rxa", 4);
    freq.put("jg\u0127", 44);
    freq.put("Fir", 6);
    freq.put("Fis", 4);
    freq.put("sco", 22);
    freq.put("sci", 3);
    freq.put("sch", 15);
    freq.put("Fit", 4);
    freq.put("sce", 56);
    freq.put("sca", 11);
    freq.put("mni", 16);
    freq.put(" a", 938);
    freq.put("Fie", 3);
    freq.put("scu", 3);
    freq.put("Fih", 5);
    freq.put("Fin", 12);
    freq.put("mne", 6);
    freq.put("Fil", 66);
    freq.put("tz", 8);
    freq.put("tx", 14);
    freq.put("\u0127ud", 35);
    freq.put("tv", 12);
    freq.put("tw", 210);
    freq.put("tt", 1547);
    freq.put("tu", 745);
    freq.put("tr", 672);
    freq.put("ts", 37);
    freq.put("tp", 5);
    freq.put("\u0127ul", 13);
    freq.put("tn", 57);
    freq.put("to", 918);
    freq.put("tl", 147);
    freq.put("tm", 60);
    freq.put("tj", 34);
    freq.put("tk", 53);
    freq.put("th", 383);
    freq.put("\u0127ut", 5);
    freq.put("tf", 55);
    freq.put("tg", 43);
    freq.put("Eas", 3);
    freq.put("te", 1001);
    freq.put("tb", 228);
    freq.put("tc", 4);
    freq.put("ta", 7637);
    freq.put("smi", 9);
    freq.put("Fi ", 9);
    freq.put("\u0127u ", 183);
    freq.put("vic\u0307", 9);
    freq.put("rj", 362);
    freq.put("dsa", 13);
    freq.put("t ", 3805);
    freq.put("Smu", 4);
    freq.put("xot", 3);
    freq.put("xor", 3);
    freq.put("xog", 38);
    freq.put("te\u0301", 4);
    freq.put("xon", 10);
    freq.put("xol", 3);
    freq.put("ta\u0300", 137);
    freq.put("vic", 7);
    freq.put("via", 8);
    freq.put("Aud", 3);
    freq.put("Aug", 5);
    freq.put("vie", 8);
    freq.put("vii", 4);
    freq.put("vin", 36);
    freq.put("Fiz\u0307", 5);
    freq.put("vim", 26);
    freq.put("vir", 5);
    freq.put("vis", 67);
    freq.put("Aus", 9);
    freq.put("Aut", 3);
    freq.put("vit", 26);
    freq.put("viz", 30);
    freq.put("z\u0307la", 25);
    freq.put(" d ", 41);
    freq.put("xut", 5);
    freq.put("vi ", 54);
    freq.put(" do", 17);
    freq.put("kle", 8);
    freq.put(" dj", 6);
    freq.put(" di", 394);
    freq.put(" dg", 8);
    freq.put(" de", 233);
    freq.put("klo", 4);
    freq.put("kli", 37);
    freq.put(" da", 340);
    freq.put("klu", 121);
    freq.put("waz", 7);
    freq.put(" dw", 44);
    freq.put("t\u0127", 18);
    freq.put(" du", 6);
    freq.put(" ds", 5);
    freq.put(" dr", 60);
    freq.put("g\u0307wi", 3);
    freq.put("\u0127ha", 54);
    freq.put("atr", 61);
    freq.put("\u0127ho", 55);
    freq.put("itn", 3);
    freq.put("ito", 39);
    freq.put("itl", 25);
    freq.put("itj", 3);
    freq.put("itk", 17);
    freq.put("ith", 41);
    freq.put("iti", 141);
    freq.put("itf", 5);
    freq.put("ite", 61);
    freq.put("itb", 34);
    freq.put("ita", 218);
    freq.put("itz", 3);
    freq.put("ity", 5);
    freq.put("itw", 29);
    freq.put("itt", 220);
    freq.put("itu", 108);
    freq.put("itr", 26);
    freq.put("its", 3);
    freq.put("itq", 10);
    freq.put("wre", 4);
    freq.put("wra", 5);
    freq.put("wro", 146);
    freq.put("jez\u0307", 13);
    freq.put(" Mq", 3);
    freq.put("it ", 400);
    freq.put("og\u0307e", 60);
    freq.put("ht", 28);
    freq.put("og\u0307i", 90);
    freq.put("je\u0127", 4);
    freq.put(" A ", 10);
    freq.put("eg\u0307j", 34);
    freq.put("eg\u0307a", 3);
    freq.put("ita\u0300", 86);
    freq.put("\u0627\u0654", 4);
    freq.put("ftu", 5);
    freq.put("ftw", 4);
    freq.put("Dut", 4);
    freq.put("\u062d\u0645\u062f", 4);
    freq.put("fte", 4);
    freq.put("fti", 15);
    freq.put(" Aa", 3);
    freq.put(" Ab", 15);
    freq.put(" Ac", 13);
    freq.put(" Ad", 10);
    freq.put(" Af", 58);
    freq.put(" Ag", 8);
    freq.put("eg\u0307 ", 26);
    freq.put(" Aj", 8);
    freq.put(" Ak", 6);
    freq.put(" Al", 94);
    freq.put(" Am", 151);
    freq.put(" An", 92);
    freq.put(" Ap", 61);
    freq.put(" Ar", 109);
    freq.put(" As", 91);
    freq.put(" At", 31);
    freq.put(" Au", 24);
    freq.put(" Av", 13);
    freq.put(" Aw", 129);
    freq.put(" Az", 6);
    freq.put("ft ", 13);
    freq.put("\u03b3\u03bf\u03c2", 4);
    freq.put("w", 4011);
    freq.put("Fra", 172);
    freq.put("Fre", 4);
    freq.put("Fri", 13);
    freq.put("xin", 15);
    freq.put("jer", 82);
    freq.put("jes", 15);
    freq.put("jev", 5);
    freq.put("jew", 370);
    freq.put("jet", 60);
    freq.put("jez", 3);
    freq.put("jeb", 12);
    freq.put("xis", 3);
    freq.put("jef", 5);
    freq.put("jeg", 6);
    freq.put("jed", 23);
    freq.put("jek", 21);
    freq.put("\u043a", 6);
    freq.put("jen", 144);
    freq.put("jel", 12);
    freq.put("jem", 16);
    freq.put("\u3042", 7);
    freq.put("je ", 15);
    freq.put("aas", 4);
    freq.put("bho", 10);
    freq.put(" A\u0127", 10);
    freq.put("bha", 6);
    freq.put("ng\u0127", 54);
    freq.put("Is ", 37);
    freq.put("c\u0307c\u0307 ", 14);
    freq.put("ex ", 198);
    freq.put("Bla", 7);
    freq.put("eg\u0307g\u0307", 14);
    freq.put("Isq", 10);
    freq.put("Isp", 8);
    freq.put("M", 1503);
    freq.put("Ist", 39);
    freq.put("Isk", 4);
    freq.put("c\u0307c\u0307i", 7);
    freq.put("Isl", 11);
    freq.put("c\u0307c\u0307e", 55);
    freq.put("Isa", 3);
    freq.put(" Az\u0307", 10);
    freq.put("Isf", 34);
    freq.put("a\u0302", 4);
    freq.put("exa", 6);
    freq.put("exi", 5);
    freq.put("ext", 3);
    freq.put("exx", 60);
    freq.put("ojt", 4);
    freq.put("Hal", 15);
    freq.put("Ham", 3);
    freq.put("Han", 8);
    freq.put("ugl", 3);
    freq.put("Hab", 5);
    freq.put("uge", 3);
    freq.put("ojd", 4);
    freq.put("ojo", 3);
    freq.put("Har", 4);
    freq.put("ojj", 11);
    freq.put("ugu", 6);
    freq.put("c\u0307u ", 4);
    freq.put("rf ", 15);
    freq.put("oj ", 8);
    freq.put("rfu", 29);
    freq.put("rfa", 26);
    freq.put("rfe", 7);
    freq.put("rfj", 21);
    freq.put("rfi", 28);
    freq.put("cro", 86);
    freq.put("sew", 13);
    freq.put("Fou", 7);
    freq.put("set", 36);
    freq.put("ses", 15);
    freq.put("ser", 107);
    freq.put("For", 9);
    freq.put("sep", 19);
    freq.put("Soc\u0307", 15);
    freq.put("seg", 10);
    freq.put("sef", 3);
    freq.put("sed", 11);
    freq.put("sec", 4);
    freq.put("seb", 40);
    freq.put("sea", 5);
    freq.put("seo", 3);
    freq.put("sen", 158);
    freq.put("Fon", 13);
    freq.put("Foo", 32);
    freq.put("sek", 74);
    freq.put("sej", 84);
    freq.put("seh", 23);
    freq.put("\u0127wa", 3);
    freq.put("zka", 3);
    freq.put("ue ", 54);
    freq.put("se ", 39);
    freq.put("lex", 6);
    freq.put("xaq", 4);
    freq.put("xar", 39);
    freq.put("xat", 5);
    freq.put("tiv", 207);
    freq.put("xah", 23);
    freq.put("xan", 22);
    freq.put("xad", 16);
    freq.put("xag", 3);
    freq.put("nri", 6);
    freq.put("ug\u0127", 9);
    freq.put("Ola", 14);
    freq.put("mla", 13);
    freq.put("mle", 5);
    freq.put("Oli", 18);
    freq.put("mli", 6);
    freq.put("mlu", 12);
    freq.put("u\u0300", 49);
    freq.put("vol", 38);
    freq.put("von", 12);
    freq.put("voj", 4);
    freq.put("vot", 7);
    freq.put("vor", 73);
    freq.put("aml", 13);
    freq.put("z\u0307ni", 3);
    freq.put("tir", 41);
    freq.put("z\u0307na", 5);
    freq.put(" f ", 334);
    freq.put("vo ", 5);
    freq.put("A\u0127\u0127", 3);
    freq.put("se\u0127", 15);
    freq.put(" fq", 3);
    freq.put("kno", 4);
    freq.put(" fr", 27);
    freq.put(" fu", 363);
    freq.put(" ft", 18);
    freq.put("kni", 12);
    freq.put("kne", 3);
    freq.put("Sol", 11);
    freq.put("kna", 3);
    freq.put(" fa", 384);
    freq.put("Sor", 5);
    freq.put(" fe", 172);
    freq.put(" fd", 7);
    freq.put(" ff", 8);
    freq.put(" fi", 1780);
    freq.put(" fj", 5);
    freq.put("\u0126in", 5);
    freq.put(" fl", 851);
    freq.put(" fo", 125);
    freq.put(" fn", 24);
    freq.put("O ", 9);
    freq.put("uc\u0307", 53);
    freq.put("u\u0127", 76);
    freq.put("ug\u0307", 29);
    freq.put("\u0127ja", 30);
    freq.put("Om", 7);
    freq.put("Ol", 35);
    freq.put("Oc", 64);
    freq.put("Ot", 58);
    freq.put("Os", 11);
    freq.put("bu\u0300", 26);
    freq.put("Op", 37);
    freq.put("uz\u0307", 202);
    freq.put("d", 6281);
    freq.put("Kha", 3);
    freq.put(" Dz", 3);
    freq.put("b ", 660);
    freq.put("iju", 16);
    freq.put("ija", 800);
    freq.put("ije", 7);
    freq.put("iji", 379);
    freq.put("Vel", 3);
    freq.put("ijo", 39);
    freq.put("g\u0307u ", 35);
    freq.put("ag\u0127", 501);
    freq.put("Xje", 16);
    freq.put("be", 469);
    freq.put("bg", 18);
    freq.put("ba", 751);
    freq.put("bb", 311);
    freq.put("bl", 330);
    freq.put("bn", 53);
    freq.put("bo", 359);
    freq.put("bh", 18);
    freq.put("bi", 931);
    freq.put("bj", 48);
    freq.put("bt", 14);
    freq.put("bu", 225);
    freq.put("bw", 5);
    freq.put("bq", 18);
    freq.put("br", 410);
    freq.put("bs", 15);
    freq.put("by", 8);
    freq.put("Fu", 71);
    freq.put("g\u0307ud", 3);
    freq.put("oz\u0307l", 6);
    freq.put("g\u0307un", 57);
    freq.put("g\u0307ur", 65);
    freq.put(" C ", 3);
    freq.put("ci ", 12);
    freq.put("Oc\u0307", 21);
    freq.put("tig", 10);
    freq.put("\u0636", 3);
    freq.put("u ", 5203);
    freq.put("Fe", 98);
    freq.put(" Ch", 51);
    freq.put(" Ci", 11);
    freq.put(" Co", 68);
    freq.put(" Cl", 20);
    freq.put(" Ca", 153);
    freq.put(" Ce", 10);
    freq.put(" Cy", 6);
    freq.put("Fi", 118);
    freq.put("uE", 3);
    freq.put("\u03b3\u03bf", 5);
    freq.put("zil", 3);
    freq.put(" Cu", 17);
    freq.put("cia", 14);
    freq.put("cif", 3);
    freq.put("cie", 5);
    freq.put("cid", 4);
    freq.put("ut", 469);
    freq.put("uw", 756);
    freq.put("uv", 11);
    freq.put("cio", 6);
    freq.put("cin", 23);
    freq.put("us", 575);
    freq.put("cil", 7);
    freq.put("cis", 6);
    freq.put("ul", 526);
    freq.put("uo", 8);
    freq.put("un", 869);
    freq.put("ui", 31);
    freq.put("uh", 31);
    freq.put("uk", 161);
    freq.put("uj", 5);
    freq.put("ue", 95);
    freq.put("ud", 211);
    freq.put("ug", 117);
    freq.put("uf", 299);
    freq.put("ua", 43);
    freq.put("uc", 60);
    freq.put("ub", 257);
    freq.put("b\u0127", 410);
    freq.put("tic", 12);
    freq.put("\u03b8", 5);
    freq.put("lph", 130);
    freq.put("bz\u0307", 5);
    freq.put("ago", 155);
    freq.put("agn", 14);
    freq.put("agm", 3);
    freq.put("agi", 25);
    freq.put("agh", 3);
    freq.put("agg", 5);
    freq.put("age", 12);
    freq.put("aga", 13);
    freq.put("cio\u0301", 4);
    freq.put("agu", 261);
    freq.put("agr", 14);
    freq.put("B\u0127a", 8);
    freq.put("Jin", 3);
    freq.put("o ", 392);
    freq.put("ev ", 8);
    freq.put("wa ", 863);
    freq.put("sg\u0127", 7);
    freq.put("tri", 203);
    freq.put("evi", 21);
    freq.put("evj", 5);
    freq.put("tro", 76);
    freq.put("evo", 6);
    freq.put("tra", 237);
    freq.put("eva", 13);
    freq.put("tre", 20);
    freq.put("eve", 16);
    freq.put(" G\u0307d", 7);
    freq.put("tru", 133);
    freq.put("le ", 50);
    freq.put("uel", 9);
    freq.put("odr", 9);
    freq.put("odu", 54);
    freq.put("odi", 41);
    freq.put("odj", 7);
    freq.put("odn", 3);
    freq.put("odo", 32);
    freq.put("oda", 8);
    freq.put("uev", 6);
    freq.put("odd", 11);
    freq.put("ode", 31);
    freq.put("ues", 9);
    freq.put("uer", 7);
    freq.put("ct ", 4);
    freq.put("rd ", 55);
    freq.put("lea", 15);
    freq.put("leb", 22);
    freq.put("lec", 3);
    freq.put("led", 55);
    freq.put("lef", 15);
    freq.put("leg", 19);
    freq.put("lei", 6);
    freq.put("lej", 73);
    freq.put("lek", 11);
    freq.put("lem", 45);
    freq.put("len", 100);
    freq.put("leo", 11);
    freq.put("lep", 34);
    freq.put("ler", 40);
    freq.put("les", 98);
    freq.put("let", 142);
    freq.put("lev", 13);
    freq.put("lew", 12);
    freq.put("od ", 48);
    freq.put("ley", 3);
    freq.put("lez", 18);
    freq.put("rdu", 8);
    freq.put("rds", 7);
    freq.put("cty", 5);
    freq.put("rde", 11);
    freq.put("cte", 18);
    freq.put("rda", 17);
    freq.put("cta", 5);
    freq.put("rdo", 22);
    freq.put("rdn", 382);
    freq.put("rdi", 72);
    freq.put("sup", 239);
    freq.put("Ukr", 8);
    freq.put("zid", 6);
    freq.put("zie", 5);
    freq.put("zia", 4);
    freq.put("zin", 3);
    freq.put("\u0127qu", 15);
    freq.put("zij", 20);
    freq.put("\u043e", 10);
    freq.put("zi ", 50);
    freq.put("oz ", 3);
    freq.put("leg\u0307", 20);
    freq.put("\u03bc", 10);
    freq.put("oz", 43);
    freq.put("Q", 64);
    freq.put("ro\u0301w", 4);
    freq.put("lez\u0307", 3);
    freq.put("rog\u0307", 22);
    freq.put("mja", 6);
    freq.put("mji", 3);
    freq.put("mju", 6);
    freq.put("dja", 87);
    freq.put("Z\u0307", 86);
    freq.put("VI ", 6);
    freq.put("Sa ", 4);
    freq.put("e\u0302\u0309", 9);
    freq.put("lza", 6);
    freq.put("Saj", 4);
    freq.put("San", 118);
    freq.put("G\u0307di", 7);
    freq.put("Sal", 14);
    freq.put(" hr", 3);
    freq.put(" hu", 1066);
    freq.put("dje", 6);
    freq.put(" hi", 486);
    freq.put("\u0126ol", 3);
    freq.put("Sar", 12);
    freq.put(" ha", 25);
    freq.put("Sap", 3);
    freq.put("Saw", 4);
    freq.put("Sav", 4);
    freq.put(" he", 73);
    freq.put("Sat", 5);
    freq.put(" Eg\u0307", 13);
    freq.put("nc\u0327o", 6);
    freq.put("\u03c1\u03b1", 3);
    freq.put("\u03c1\u03b9", 3);
    freq.put("\u03c1\u03bf", 6);
    freq.put("Qor", 7);
    freq.put("Rib", 3);
    freq.put("\u05ea", 5);
    freq.put("umu", 5);
    freq.put("\u03b9\u0301\u03b1", 3);
    freq.put("G\u0307a", 15);
    freq.put("G\u0307g", 5);
    freq.put("G\u0307d", 7);
    freq.put("G\u0307e", 112);
    freq.put("G\u0307i", 13);
    freq.put("G\u0307n", 5);
    freq.put("G\u0307o", 22);
    freq.put("G\u0307l", 3);
    freq.put("G\u0307r", 3);
    freq.put("G\u0307w", 22);
    freq.put("G\u0307u", 107);
    freq.put("toi", 20);
    freq.put("iha", 31);
    freq.put("Sa\u0127", 7);
    freq.put("Xlo", 21);
    freq.put("Xle", 4);
    freq.put("ih ", 35);
    freq.put("lly", 4);
    freq.put("djo", 5);
    freq.put("g\u0307g\u0307 ", 23);
    freq.put("\u0127", 4531);
    freq.put(" El", 37);
    freq.put(" Em", 10);
    freq.put(" En", 23);
    freq.put(" Eo", 8);
    freq.put(" Ei", 10);
    freq.put(" Ek", 7);
    freq.put(" Ed", 16);
    freq.put(" Ea", 4);
    freq.put(" Eb", 8);
    freq.put(" Ex", 3);
    freq.put(" Et", 8);
    freq.put(" Eu", 198);
    freq.put(" Ev", 6);
    freq.put(" Ew", 159);
    freq.put(" Ep", 3);
    freq.put(" Er", 23);
    freq.put(" Es", 16);
    freq.put("g\u0307g\u0307e", 28);
    freq.put("g\u0307g\u0307a", 6);
    freq.put("ckl", 4);
    freq.put("g\u0307g\u0307o", 4);
    freq.put("cki", 4);
    freq.put("g\u0307g\u0307j", 4);
    freq.put("g\u0307g\u0307u", 4);
    freq.put("cks", 4);
    freq.put("g\u0307 ", 148);
    freq.put("uc\u0307i", 11);
    freq.put("lg\u0127", 13);
    freq.put("jaz", 19);
    freq.put("jav", 5);
    freq.put("jaw", 8);
    freq.put("jat", 65);
    freq.put("jar", 71);
    freq.put("jas", 4);
    freq.put("jaq", 17);
    freq.put("jan", 254);
    freq.put("ae ", 381);
    freq.put("jal", 273);
    freq.put("jam", 31);
    freq.put("jak", 18);
    freq.put("jaf", 8);
    freq.put("jag", 36);
    freq.put("jad", 9);
    freq.put("jab", 6);
    freq.put("g\u0307a", 61);
    freq.put("g\u0307b", 29);
    freq.put("g\u0307e", 665);
    freq.put("g\u0307d", 13);
    freq.put("g\u0307g", 5);
    freq.put("g\u0307i", 459);
    freq.put("g\u0307j", 77);
    freq.put("g\u0307l", 16);
    freq.put("g\u0307o", 24);
    freq.put("g\u0307n", 24);
    freq.put("O\u0301", 3);
    freq.put("g\u0307r", 53);
    freq.put("g\u0307u", 164);
    freq.put("g\u0307t", 3);
    freq.put("g\u0307w", 4);
    freq.put("h", 3948);
    freq.put("eta\u0300", 27);
    freq.put("ael", 21);
    freq.put("ja ", 2068);
    freq.put("aen", 25);
    freq.put("Pr", 200);
    freq.put("Ps", 4);
    freq.put("qtu", 3);
    freq.put("Pt", 4);
    freq.put("Pu", 27);
    freq.put("oma", 57);
    freq.put("bte", 7);
    freq.put("Pa", 356);
    freq.put("bta", 4);
    freq.put("qta", 4);
    freq.put("Pj", 3);
    freq.put("Ph", 32);
    freq.put("Pi", 76);
    freq.put("Po", 104);
    freq.put("Pl", 13);
    freq.put("ome", 59);
    freq.put("\u0627", 32);
    freq.put("et ", 900);
    freq.put("omi", 66);
    freq.put("P ", 13);
    freq.put("qt ", 22);
    freq.put("tsk", 4);
    freq.put("etr", 61);
    freq.put("ets", 4);
    freq.put("etw", 11);
    freq.put("ett", 388);
    freq.put("etu", 11);
    freq.put("etx", 3);
    freq.put("tsi", 6);
    freq.put("tla", 33);
    freq.put("eta", 184);
    freq.put("etg", 3);
    freq.put("tle", 36);
    freq.put("ete", 19);
    freq.put("eth", 11);
    freq.put("eti", 76);
    freq.put("etn", 16);
    freq.put("eto", 24);
    freq.put("ck", 50);
    freq.put("ci", 131);
    freq.put("ch", 296);
    freq.put("co", 113);
    freq.put("Her", 13);
    freq.put("cl", 11);
    freq.put("cc", 22);
    freq.put("lj", 730);
    freq.put("ca", 101);
    freq.put("ce", 136);
    freq.put("cd", 9);
    freq.put("cz", 5);
    freq.put("cy", 17);
    freq.put("uca", 6);
    freq.put("cr", 93);
    freq.put("cq", 4);
    freq.put("uck", 3);
    freq.put("Hei", 3);
    freq.put("cu", 66);
    freq.put("ct", 79);
    freq.put("Ger", 4);
    freq.put("z\u0307ul", 14);
    freq.put("z\u0307un", 3);
    freq.put("z\u0307ur", 6);
    freq.put("Gej", 3);
    freq.put("Geo", 9);
    freq.put("Gen", 4);
    freq.put("rb ", 5);
    freq.put("lga", 8);
    freq.put("jac\u0307", 4);
    freq.put("z\u0307u ", 17);
    freq.put("rbu", 8);
    freq.put("rbt", 6);
    freq.put("rbo", 4);
    freq.put("rbj", 14);
    freq.put("rbi", 63);
    freq.put("rbg", 10);
    freq.put("ja\u0127", 61);
    freq.put("rbe", 8);
    freq.put("eur", 7);
    freq.put("rba", 94);
    freq.put("jag\u0307", 4);
    freq.put("va", 308);
    freq.put("vd", 7);
    freq.put("ve", 367);
    freq.put("vi", 442);
    freq.put("vj", 55);
    freq.put("ph ", 4);
    freq.put("vl", 4);
    freq.put("vn", 3);
    freq.put("vo", 144);
    freq.put("vr", 11);
    freq.put("vs", 7);
    freq.put("vu", 33);
    freq.put("vv", 26);
    freq.put("of ", 53);
    freq.put("\u0127su", 6);
    freq.put("\u0127sb", 3);
    freq.put("\u0127si", 12);
    freq.put("v ", 91);
    freq.put("phi", 171);
    freq.put("pho", 12);
    freq.put("unf", 4);
    freq.put("yon", 11);
    freq.put("pha", 99);
    freq.put("\u0435\u0308", 4);
    freq.put("phy", 7);
    freq.put("ofa", 91);
    freq.put("off", 13);
    freq.put("ofe", 33);
    freq.put("ofi", 15);
    freq.put("ofo", 4);
    freq.put("ofr", 5);
    freq.put("ofs", 48);
    freq.put("oft", 14);
    freq.put("xel", 4);
    freq.put("xem", 7);
    freq.put("xen", 18);
    freq.put("xej", 38);
    freq.put("xet", 4);
    freq.put("xew", 4);
    freq.put("igg", 4);
    freq.put("wea", 7);
    freq.put("wed", 15);
    freq.put("wen", 28);
    freq.put("wem", 11);
    freq.put("wel", 166);
    freq.put("wer", 53);
    freq.put("wew", 3);
    freq.put("wet", 32);
    freq.put("nve", 25);
    freq.put("yov", 3);
    freq.put("nvo", 9);
    freq.put("nvi", 3);
    freq.put("mho", 23);
    freq.put("we ", 7);
    freq.put(" g\u0307d", 12);
    freq.put(" g\u0307e", 524);
    freq.put(" g\u0307g", 3);
    freq.put(" g\u0307i", 92);
    freq.put(" g\u0307l", 6);
    freq.put(" g\u0307n", 5);
    freq.put("mha", 6);
    freq.put(" g\u0307r", 47);
    freq.put(" g\u0307u", 69);
    freq.put(" g\u0307w", 4);
    freq.put("mhu", 59);
    freq.put("inz\u0307", 7);
    freq.put("vsk", 7);
    freq.put("z\u0307ju", 5);
    freq.put("z\u0307jo", 68);
    freq.put("z\u0307ja", 14);
    freq.put("z\u0307je", 18);
    freq.put("lle", 112);
    freq.put("\u043b\u0438", 3);
    freq.put("Sas", 3);
    freq.put("in\u0127", 36);
    freq.put("ing\u0307", 21);
    freq.put("Sco", 3);
    freq.put("Sci", 3);
    freq.put("Sch", 17);
    freq.put(" ju", 34);
    freq.put(" jt", 7);
    freq.put(" jw", 9);
    freq.put("Sca", 6);
    freq.put(" js", 28);
    freq.put(" jr", 4);
    freq.put(" jm", 9);
    freq.put(" jo", 29);
    freq.put("kri", 39);
    freq.put(" ji", 674);
    freq.put("kro", 13);
    freq.put(" jk", 44);
    freq.put("inc\u0307", 48);
    freq.put(" je", 428);
    freq.put(" jd", 3);
    freq.put(" jg", 42);
    freq.put(" jf", 14);
    freq.put(" ja", 90);
    freq.put("kre", 7);
    freq.put(" g\u0307g\u0307", 3);
    freq.put("yro", 11);
    freq.put("yra", 18);
    freq.put("Kle", 4);
    freq.put("Kla", 25);
    freq.put("inz", 3);
    freq.put("int", 431);
    freq.put("inu", 67);
    freq.put("inv", 23);
    freq.put("inq", 27);
    freq.put("ins", 137);
    freq.put("inl", 10);
    freq.put("inn", 331);
    freq.put("ino", 37);
    freq.put("inh", 59);
    freq.put("ini", 223);
    freq.put("inj", 181);
    freq.put("ink", 65);
    freq.put("ind", 53);
    freq.put("ine", 150);
    freq.put("inf", 243);
    freq.put("ing", 210);
    freq.put("ina", 336);
    freq.put("inb", 14);
    freq.put("inc", 18);
    freq.put("eo ", 8);
    freq.put(" j\u0127", 10);
    freq.put(" jg\u0307", 4);
    freq.put("DA ", 3);
    freq.put("U", 190);
    freq.put("in ", 725);
    freq.put("eog", 12);
    freq.put("eok", 3);
    freq.put("e\u0302", 5);
    freq.put("eon", 13);
    freq.put("eol", 21);
    freq.put("eor", 35);
    freq.put("eop", 12);
    freq.put("wx ", 4);
    freq.put("eot", 23);
    freq.put(" \u02c8", 5);
    freq.put("le\u0301", 4);
    freq.put("erc\u0307", 14);
    freq.put("\u03b5\u0301", 7);
    freq.put("a\u0303o ", 4);
    freq.put("erg\u0307", 18);
    freq.put("lo\u0300", 3);
    freq.put("ald", 9);
    freq.put(" Gv", 9);
    freq.put(" Gw", 24);
    freq.put(" Gu", 24);
    freq.put(" Gr", 182);
    freq.put("Tun", 7);
    freq.put("alc", 4);
    freq.put("\u03bf\u0301\u03c2 ", 3);
    freq.put(" Ge", 23);
    freq.put(" Ga", 51);
    freq.put(" Go", 18);
    freq.put(" Gl", 8);
    freq.put(" Gi", 29);
    freq.put("erz\u0307", 19);
    freq.put("baz\u0307", 52);
    freq.put("a\u0304", 17);
    freq.put("la\u0127", 9);
    freq.put("lag\u0307", 13);
    freq.put("e\u0300 ", 9);
    freq.put("alt", 386);
    freq.put("lac\u0307", 181);
    freq.put("\u062f", 10);
    freq.put("ak ", 35);
    freq.put("Sim", 16);
    freq.put("e\u0300r", 3);
    freq.put("e\u0300s", 4);
    freq.put("laz\u0307", 3);
    freq.put("Cr", 17);
    freq.put("gli", 83);
    freq.put("glo", 7);
    freq.put("aks", 39);
    freq.put("gla", 7);
    freq.put("aku", 11);
    freq.put("akt", 123);
    freq.put("akk", 63);
    freq.put("aki", 10);
    freq.put("a\u0301in", 3);
    freq.put("ako", 11);
    freq.put("akn", 4);
    freq.put("akm", 4);
    freq.put("akl", 160);
    freq.put("akb", 27);
    freq.put("aka", 3);
    freq.put("ake", 20);
    freq.put("nk ", 8);
    freq.put("bru", 279);
    freq.put("bro", 10);
    freq.put(" G\u0127", 113);
    freq.put("Jea", 6);
    freq.put("bri", 65);
    freq.put("bre", 12);
    freq.put("bra", 41);
    freq.put("er ", 328);
    freq.put("io\u0301 ", 5);
    freq.put("nka", 7);
    freq.put("nke", 18);
    freq.put("iu", 54);
    freq.put(" Gz\u0307", 13);
    freq.put("nkl", 35);
    freq.put("nko", 7);
    freq.put("nkr", 3);
    freq.put("nku", 7);
    freq.put("nkw", 7);
    freq.put("z\u0307gu", 4);
    freq.put("tmo", 5);
    freq.put("ert", 67);
    freq.put("eru", 492);
    freq.put("erv", 50);
    freq.put("mba", 13);
    freq.put("erp", 16);
    freq.put("err", 88);
    freq.put("ers", 161);
    freq.put("ik", 1688);
    freq.put("erz", 8);
    freq.put("erd", 20);
    freq.put("ere", 84);
    freq.put("erf", 34);
    freq.put("erg", 31);
    freq.put("tna", 26);
    freq.put("era", 210);
    freq.put("erb", 109);
    freq.put("erc", 47);
    freq.put("erl", 19);
    freq.put("erm", 155);
    freq.put("ern", 159);
    freq.put("ero", 141);
    freq.put("erh", 5);
    freq.put("eri", 1016);
    freq.put("erj", 56);
    freq.put("erk", 24);
    freq.put("Abb", 3);
    freq.put("Abd", 4);
    freq.put("Abe", 3);
    freq.put("uar", 12);
    freq.put("la ", 665);
    freq.put("ia", 845);
    freq.put("uam", 3);
    freq.put("uan", 8);
    freq.put("ic", 208);
    freq.put("ki ", 76);
    freq.put("oz\u0307i", 62);
    freq.put("i\u0304", 6);
    freq.put("z\u0307wa", 4);
    freq.put("z\u0307we", 11);
    freq.put("lam", 55);
    freq.put("lan", 143);
    freq.put("lah", 4);
    freq.put("lai", 4);
    freq.put("laj", 9);
    freq.put("lak", 6);
    freq.put("lad", 9);
    freq.put("lae", 26);
    freq.put("lag", 319);
    freq.put("lab", 42);
    freq.put("lac", 15);
    freq.put("lay", 4);
    freq.put("laz", 65);
    freq.put("lat", 167);
    freq.put("lau", 9);
    freq.put("lav", 9);
    freq.put("law", 11);
    freq.put("laq", 15);
    freq.put("lar", 77);
    freq.put("las", 622);
    freq.put("zec", 4);
    freq.put("zen", 4);
    freq.put("zer", 19);
    freq.put("\u03c4\u03c1", 5);
    freq.put("zet", 8);
    freq.put("zez", 3);
    freq.put("pjo", 79);
    freq.put("\u0142", 7);
    freq.put("pji", 14);
    freq.put("c\u0307en", 218);
    freq.put("pje", 11);
    freq.put("pja", 197);
    freq.put("pju", 35);
    freq.put("l", 21695);
    freq.put("iho", 7);
    freq.put("\u0301", 6);
    freq.put("nt ", 717);
    freq.put("\u20ac", 8);
    freq.put("wgu", 3);
    freq.put("nty", 4);
    freq.put("ntx", 6);
    freq.put("ntz", 3);
    freq.put("ntr", 114);
    freq.put("ntu", 64);
    freq.put("ntw", 8);
    freq.put("nti", 741);
    freq.put("nth", 8);
    freq.put("Az\u0307j", 7);
    freq.put("ntl", 21);
    freq.put("nto", 26);
    freq.put("nta", 496);
    freq.put("nte", 195);
    freq.put("Ugo", 3);
    freq.put("c\u0307es", 48);
    freq.put(" l ", 1859);
    freq.put("kib", 3);
    freq.put("kif", 102);
    freq.put(" le", 100);
    freq.put("B", 510);
    freq.put(" la", 110);
    freq.put(" lo", 92);
    freq.put(" ll", 9);
    freq.put(" li", 1441);
    freq.put(" lv", 4);
    freq.put(" lu", 18);
    freq.put("tef", 4);
    freq.put("Set", 62);
    freq.put("Ser", 28);
    freq.put("ktu", 12);
    freq.put("Seg", 3);
    freq.put("Sed", 5);
    freq.put("kti", 27);
    freq.put("Sea", 5);
    freq.put("kte", 7);
    freq.put("Sem", 3);
    freq.put("Sel", 3);
    freq.put("Sek", 13);
    freq.put("kta", 201);
    freq.put("ter", 318);
    freq.put("\u03bf\u0301\u03c2", 3);
    freq.put("ypt", 7);
    freq.put("\u03c0", 7);
    freq.put("Qu", 13);
    freq.put(" Fn", 6);
    freq.put("Kni", 43);
    freq.put("Qa", 28);
    freq.put("Qo", 7);
    freq.put("Gz\u0307e", 5);
    freq.put("g\u0127u", 150);
    freq.put("g\u0127t", 20);
    freq.put("g\u0127q", 10);
    freq.put("g\u0127r", 245);
    freq.put("d ", 1159);
    freq.put("g\u0127e", 97);
    freq.put("g\u0127d", 15);
    freq.put("g\u0127a", 881);
    freq.put("g\u0127b", 50);
    freq.put("g\u0127m", 64);
    freq.put("g\u0127l", 40);
    freq.put("g\u0127o", 131);
    freq.put("g\u0127n", 5);
    freq.put("g\u0127i", 107);
    freq.put("g\u0127h", 101);
    freq.put("hry", 3);
    freq.put("em ", 252);
    freq.put("hru", 10);
    freq.put("udn", 4);
    freq.put("hri", 7);
    freq.put("hre", 4);
    freq.put("hra", 9);
    freq.put("dn", 402);
    freq.put("do", 219);
    freq.put("dl", 17);
    freq.put("dm", 23);
    freq.put("dj", 159);
    freq.put("dk", 3);
    freq.put("dh", 81);
    freq.put("di", 1076);
    freq.put("df", 4);
    freq.put("dg", 15);
    freq.put("dd", 236);
    freq.put("de", 989);
    freq.put("dc", 7);
    freq.put("da", 1186);
    freq.put("g\u0127 ", 18);
    freq.put("dx", 7);
    freq.put("dy", 8);
    freq.put("dw", 119);
    freq.put("dt", 4);
    freq.put("du", 325);
    freq.put("dr", 189);
    freq.put("ds", 31);
    freq.put("eme", 48);
    freq.put("aiz\u0307", 3);
    freq.put("emg", 3);
    freq.put("ema", 151);
    freq.put("emb", 211);
    freq.put("emm", 190);
    freq.put("emo", 35);
    freq.put("emi", 99);
    freq.put("emj", 13);
    freq.put("emp", 40);
    freq.put("emx", 18);
    freq.put("w ", 632);
    freq.put("nig\u0307", 3);
    freq.put(" I ", 13);
    freq.put("nic\u0307", 33);
    freq.put("il ", 2246);
    freq.put("hro\u0308", 5);
    freq.put("co ", 29);
    freq.put(" Ix", 9);
    freq.put("we", 330);
    freq.put("wd", 41);
    freq.put("wa", 1446);
    freq.put("de\u0301", 4);
    freq.put(" Ip", 3);
    freq.put("wn", 125);
    freq.put("wm", 4);
    freq.put(" Is", 156);
    freq.put(" It", 125);
    freq.put("Sam", 3);
    freq.put("wi", 557);
    freq.put("wh", 11);
    freq.put("ww", 248);
    freq.put("wu", 4);
    freq.put(" Ik", 4);
    freq.put(" Il", 487);
    freq.put(" Im", 57);
    freq.put(" In", 204);
    freq.put(" Io", 5);
    freq.put(" Ib", 4);
    freq.put(" Id", 27);
    freq.put("wy", 4);
    freq.put("wx", 4);
    freq.put("ilf", 3);
    freq.put("ilg", 11);
    freq.put("ild", 7);
    freq.put("ile", 31);
    freq.put("cou", 15);
    freq.put("ila", 69);
    freq.put("ilo", 54);
    freq.put("ill", 617);
    freq.put("ilm", 33);
    freq.put("ilj", 472);
    freq.put("ilh", 23);
    freq.put("ili", 131);
    freq.put("ilw", 7);
    freq.put("ilt", 40);
    freq.put("ilu", 47);
    freq.put("ils", 12);
    freq.put("cog", 3);
    freq.put("coi", 5);
    freq.put("com", 4);
    freq.put("col", 14);
    freq.put("con", 16);
    freq.put("d\u0127", 7);
    freq.put("Sab", 6);
    freq.put("G\u0307nu", 5);
    freq.put("ai ", 11);
    freq.put("\u0642", 3);
    freq.put("ais", 4);
    freq.put("ail", 7);
    freq.put("gna", 13);
    freq.put("aii", 3);
    freq.put("aik", 4);
    freq.put("aig", 3);
    freq.put("aia", 11);
    freq.put("gno", 7);
    freq.put("w\u0127", 5);
    freq.put("wg\u0307", 70);
    freq.put("ni ", 1361);
    freq.put("il\u0127", 5);
    freq.put("wc\u0307", 4);
    freq.put(" Ic\u0307", 5);
    freq.put("ep ", 6);
    freq.put("th ", 26);
    freq.put("nij", 217);
    freq.put("nik", 85);
    freq.put("nii", 11);
    freq.put(" Iz\u0307", 49);
    freq.put("nio", 22);
    freq.put("nil", 4);
    freq.put("nim", 47);
    freq.put("nib", 4);
    freq.put("nic", 19);
    freq.put("nia", 50);
    freq.put("nif", 20);
    freq.put("nig", 6);
    freq.put("nid", 49);
    freq.put("nie", 119);
    freq.put("niz", 39);
    freq.put("nix", 6);
    freq.put("Y", 22);
    freq.put("nis", 198);
    freq.put("wz\u0307", 29);
    freq.put("niv", 55);
    freq.put("nit", 117);
    freq.put("ck ", 29);
    freq.put("e\u0302\u0309n", 5);
    freq.put("ept", 4);
    freq.put("epu", 106);
    freq.put("epr", 5);
    freq.put("thr", 7);
    freq.put("epp", 17);
    freq.put("tho", 36);
    freq.put("epo", 91);
    freq.put("thl", 3);
    freq.put("eph", 18);
    freq.put("epi", 14);
    freq.put("the", 266);
    freq.put("epe", 6);
    freq.put("tha", 16);
    freq.put("epa", 8);
    freq.put(" G\u0307o", 22);
    freq.put("rn ", 45);
    freq.put(" G\u0307n", 5);
    freq.put(" G\u0307l", 3);
    freq.put(" G\u0307r", 3);
    freq.put("Gas", 4);
    freq.put("Gar", 3);
    freq.put("Gan", 7);
    freq.put("Gal", 17);
    freq.put("Gaf", 4);
    freq.put("Gad", 4);
    freq.put("Gab", 5);
    freq.put("Tri", 29);
    freq.put("rni", 39);
    freq.put("rno", 32);
    freq.put("Tro", 14);
    freq.put("Tra", 39);
    freq.put("rna", 121);
    freq.put("rne", 21);
    freq.put("lco", 3);
    freq.put("quc\u0307", 3);
    freq.put("rnu", 4);
    freq.put("lci", 3);
    freq.put("wa\u0127", 83);
    freq.put("i\u0300nh", 4);
    freq.put("Ewk", 3);
    freq.put(" n\u0127", 6);
    freq.put("Ewr", 143);
    freq.put("Eww", 12);
    freq.put("zcz", 3);
    freq.put("Lea", 46);
    freq.put("Lec", 3);
    freq.put("Lee", 6);
    freq.put("Leg", 4);
    freq.put("Lej", 3);
    freq.put("ob ", 47);
    freq.put("Leo", 12);
    freq.put("Lep", 106);
    freq.put("Les", 6);
    freq.put("Let", 4);
    freq.put("plu", 22);
    freq.put("ple", 46);
    freq.put("pla", 200);
    freq.put("plo", 11);
    freq.put("pli", 66);
    freq.put("Le ", 3);
    freq.put("obo", 12);
    freq.put("obl", 11);
    freq.put("nc\u0307e", 12);
    freq.put("obi", 9);
    freq.put("nc\u0307i", 78);
    freq.put("nc\u0307j", 22);
    freq.put("obe", 14);
    freq.put("obb", 10);
    freq.put("oba", 16);
    freq.put("obr", 3);
    freq.put("obs", 3);
    freq.put("Cus", 3);
    freq.put("Cur", 9);
    freq.put("wan", 47);
    freq.put("wal", 99);
    freq.put("wag", 4);
    freq.put("wad", 31);
    freq.put("Vje", 21);
    freq.put("way", 3);
    freq.put("wat", 4);
    freq.put("was", 17);
    freq.put("war", 214);
    freq.put("waq", 58);
    freq.put("cke", 5);
    freq.put(" X ", 3);
    freq.put("g\u0307be", 4);
    freq.put("g\u0307bo", 15);
    freq.put("g\u0307bu", 9);
    freq.put("mta", 3);
    freq.put("u\u0308r", 3);
    freq.put(" n ", 16);
    freq.put("Tie", 24);
    freq.put(" ni", 61);
    freq.put(" nh", 27);
    freq.put(" nk", 5);
    freq.put(" no", 66);
    freq.put(" na", 205);
    freq.put(" nb", 4);
    freq.put(" ne", 33);
    freq.put(" ng", 13);
    freq.put("\u0259", 3);
    freq.put(" ns", 5);
    freq.put(" nu", 56);
    freq.put(" nt", 10);
    freq.put("FC ", 17);
    freq.put("umr", 38);
    freq.put("\u0127z\u0307u", 6);
    freq.put("gu ", 41);
    freq.put("o\u0301 ", 5);
    freq.put("umm", 18);
    freq.put("alc\u0307", 4);
    freq.put("gua", 5);
    freq.put("gue", 53);
    freq.put("o\u0301w", 5);
    freq.put("gul", 10);
    freq.put("gus", 214);
    freq.put("p", 4992);
    freq.put("o\u0301n", 4);
    freq.put("hte", 7);
    freq.put("\u03bf\u03bd", 4);
    freq.put("nac", 4);
    freq.put("ek ", 93);
    freq.put("\u0433", 3);
    freq.put("e\u0300re", 3);
    freq.put("ht ", 15);
    freq.put("G\u0307en", 15);
    freq.put("Xbi", 3);
    freq.put("eko", 31);
    freq.put("ekn", 9);
    freq.put("ekl", 86);
    freq.put("ekk", 74);
    freq.put("eka", 4);
    freq.put("Sk", 22);
    freq.put(" ip", 23);
    freq.put("Mor", 12);
    freq.put("ekw", 24);
    freq.put("eku", 30);
    freq.put("ekt", 5);
    freq.put("eks", 7);
    freq.put("uza", 4);
    freq.put("uzz", 59);
    freq.put(" Kb", 8);
    freq.put(" Ka", 217);
    freq.put(" Ke", 19);
    freq.put("ib ", 84);
    freq.put(" Kh", 3);
    freq.put(" Ki", 36);
    freq.put(" Kn", 43);
    freq.put(" Ko", 78);
    freq.put(" Kl", 32);
    freq.put(" Kr", 47);
    freq.put("Moh", 3);
    freq.put(" Kt", 6);
    freq.put(" Ku", 41);
    freq.put("ksa", 5);
    freq.put("ca ", 27);
    freq.put("Mon", 36);
    freq.put("F", 716);
    freq.put("\u064a", 18);
    freq.put("kso", 39);
    freq.put("ibi", 7);
    freq.put(" K ", 4);
    freq.put("ibl", 16);
    freq.put("ibn", 18);
    freq.put("ibo", 4);
    freq.put("cas", 14);
    freq.put("iba", 20);
    freq.put("ibb", 44);
    freq.put("ibd", 13);
    freq.put("ibe", 28);
    freq.put("cau", 7);
    freq.put("ibg", 4);
    freq.put("G\u0307er", 69);
    freq.put("cal", 3);
    freq.put("ibq", 12);
    freq.put("ibr", 12);
    freq.put("G\u0307es", 20);
    freq.put("ibu", 29);
    freq.put("ibw", 4);
    freq.put("lo\u0300 ", 3);
    freq.put("ao ", 10);
    freq.put("spr", 12);
    freq.put("spi", 57);
    freq.put("spj", 8);
    freq.put("spl", 7);
    freq.put("dxi", 7);
    freq.put("spo", 57);
    freq.put("spa", 14);
    freq.put("spe", 289);
    freq.put(" Ko\u0308", 3);
    freq.put("use", 14);
    freq.put("sp ", 4);
    freq.put("ght", 12);
    freq.put("ghu", 3);
    freq.put("ibu\u0300", 26);
    freq.put("gha", 16);
    freq.put("gho", 5);
    freq.put("ghi", 17);
    freq.put("Ru", 115);
    freq.put("Che", 9);
    freq.put("Chi", 7);
    freq.put("no ", 44);
    freq.put("Fed", 15);
    freq.put("Cho", 3);
    freq.put("Jan", 48);
    freq.put("Re", 129);
    freq.put("Chr", 6);
    freq.put("Jam", 5);
    freq.put("Ra", 39);
    freq.put("Ro", 56);
    freq.put("Rh", 13);
    freq.put("Ri", 51);
    freq.put("\u03b1", 30);
    freq.put("\u05b5", 4);
    freq.put("sok", 3);
    freq.put("nol", 74);
    freq.put("nom", 53);
    freq.put("non", 14);
    freq.put("noi", 6);
    freq.put("nod", 12);
    freq.put("nof", 23);
    freq.put("nog", 4);
    freq.put("tjo", 10);
    freq.put("noc", 7);
    freq.put("nox", 8);
    freq.put("not", 22);
    freq.put("nou", 30);
    freq.put("nov", 4);
    freq.put("nop", 3);
    freq.put("nor", 30);
    freq.put("nos", 5);
    freq.put("r\u0127u", 10);
    freq.put("z\u0307z\u0307l", 3);
    freq.put("sou", 3);
    freq.put("z\u0307z\u0307e", 10);
    freq.put("sot", 338);
    freq.put("em", 1068);
    freq.put("el", 1598);
    freq.put("eo", 132);
    freq.put("en", 3582);
    freq.put("ei", 53);
    freq.put("eh", 50);
    freq.put("ek", 367);
    freq.put("ej", 707);
    freq.put("ee", 29);
    freq.put("ed", 761);
    freq.put("eg", 415);
    freq.put("ef", 116);
    freq.put("ea", 347);
    freq.put("rl ", 6);
    freq.put("ec", 94);
    freq.put("eb", 433);
    freq.put("ey", 16);
    freq.put("ex", 278);
    freq.put("ez", 96);
    freq.put("eu", 28);
    freq.put("et", 1743);
    freq.put("ew", 814);
    freq.put("ev", 73);
    freq.put("eq", 64);
    freq.put("ep", 276);
    freq.put("es", 1147);
    freq.put("er", 3385);
    freq.put("\u0633", 6);
    freq.put(" \u0127g\u0307", 6);
    freq.put("rlo", 6);
    freq.put("rli", 12);
    freq.put("rle", 11);
    freq.put("rld", 3);
    freq.put("lms", 7);
    freq.put("rla", 60);
    freq.put("lmu", 9);
    freq.put("lmi", 3);
    freq.put("rly", 3);
    freq.put("lma", 76);
    freq.put("lme", 80);
    freq.put("Szc", 3);
    freq.put("aeo", 29);
    freq.put("usk", 4);
    freq.put("xj", 91);
    freq.put("xk", 4);
    freq.put("xh", 15);
    freq.put("xi", 198);
    freq.put("xo", 59);
    freq.put("xl", 8);
    freq.put("xm", 10);
    freq.put("xb", 6);
    freq.put("xa", 146);
    freq.put("xf", 3);
    freq.put("xe", 88);
    freq.put("Sa\u0303", 4);
    freq.put("xx", 140);
    freq.put("zaz", 24);
    freq.put("xr", 14);
    freq.put("Eut", 112);
    freq.put("zat", 41);
    freq.put("zar", 8);
    freq.put("xt", 14);
    freq.put("xu", 32);
    freq.put("yid", 5);
    freq.put("yin", 8);
    freq.put("x ", 648);
    freq.put("za ", 222);
    freq.put("tec\u0307", 33);
    freq.put("sug\u0307", 6);
    freq.put(" \u0645\u062d", 4);
    freq.put("\u0435\u0308\u0432", 3);
    freq.put("Pe", 46);
    freq.put("ez\u0307", 318);
    freq.put("Pho", 18);
    freq.put("Pha", 6);
    freq.put("Phy", 4);
    freq.put("e\u0127", 331);
    freq.put("egl", 4);
    freq.put("eg\u0307", 108);
    freq.put(" \u0127u", 8);
    freq.put(" \u0127r", 5);
    freq.put(" \u0127s", 13);
    freq.put("ec\u0307", 331);
    freq.put("mru", 36);
    freq.put(" \u0127x", 3);
    freq.put("\u062f ", 5);
    freq.put(" \u0127d", 14);
    freq.put(" \u0127e", 6);
    freq.put(" \u0127b", 3);
    freq.put("mri", 12);
    freq.put("Uca", 3);
    freq.put(" \u0127a", 436);
    freq.put(" \u0127n", 6);
    freq.put(" \u0127o", 16);
    freq.put(" \u0127l", 7);
    freq.put(" \u0127m", 7);
    freq.put("mra", 7);
    freq.put(" \u0127i", 26);
    freq.put("\u1100\u1161", 3);
    freq.put("Och", 60);
    freq.put("Wei", 3);
    freq.put("Wel", 3);
    freq.put("Wes", 7);
    freq.put("\u03b5", 7);
    freq.put(" ps", 3);
    freq.put(" pr", 294);
    freq.put(" pp", 16);
    freq.put(" pu", 53);
    freq.put("G\u0307lo", 3);
    freq.put(" px", 9);
    freq.put(" pa", 326);
    freq.put(" pe", 119);
    freq.put(" pj", 45);
    freq.put(" pi", 102);
    freq.put(" ph", 3);
    freq.put(" po", 257);
    freq.put(" pl", 234);
    freq.put("vu ", 6);
    freq.put("jtu", 5);
    freq.put("jti", 5);
    freq.put("yth", 3);
    freq.put("jte", 3);
    freq.put("jta", 11);
    freq.put("Kru", 5);
    freq.put(" Om", 7);
    freq.put("Kro", 15);
    freq.put("gwe", 19);
    freq.put("gwa", 60);
    freq.put("vul", 12);
    freq.put("gwi", 41);
    freq.put("vra", 9);
    freq.put("\u03b1 ", 9);
    freq.put("jt ", 10);
    freq.put("hvi", 3);
    freq.put("Sir", 48);
    freq.put(" Me\u0301", 12);
    freq.put("ei ", 3);
    freq.put("eip", 4);
    freq.put("eis", 5);
    freq.put("eir", 5);
    freq.put("tlu", 23);
    freq.put("CO ", 3);
    freq.put("eid", 4);
    freq.put("eim", 3);
    freq.put("ein", 18);
    freq.put("Img\u0307", 3);
    freq.put("uxa", 13);
    freq.put("uxi", 8);
    freq.put(" Me", 211);
    freq.put(" Ma", 912);
    freq.put(" Mo", 85);
    freq.put(" Mi", 192);
    freq.put(" Mu", 41);
    freq.put("Id ", 21);
    freq.put(" Ms", 3);
    freq.put(" My", 19);
    freq.put("ux ", 90);
    freq.put("tli", 54);
    freq.put("cco", 4);
    freq.put("cci", 12);
    freq.put("cch", 3);
    freq.put("z\u0307ik", 52);
    freq.put("g\u0307g\u0307", 91);
    freq.put("a\u0301i", 3);
    freq.put("am ", 78);
    freq.put("ps ", 9);
    freq.put("a\u0301n", 5);
    freq.put("ami", 439);
    freq.put("psi", 4);
    freq.put("amm", 608);
    freq.put("pso", 12);
    freq.put("amo", 7);
    freq.put("ama", 56);
    freq.put("amb", 33);
    freq.put("ame", 293);
    freq.put("amy", 13);
    freq.put("amp", 107);
    freq.put("ams", 8);
    freq.put("amr", 16);
    freq.put("amu", 46);
    freq.put("log\u0307", 92);
    freq.put("t", 21626);
    freq.put("Hem", 8);
    freq.put("Hen", 3);
    freq.put("Ios", 3);
    freq.put("uci", 42);
    freq.put("uch", 4);
    freq.put("\u02c8", 11);
    freq.put("nma", 3);
    freq.put("sra", 33);
    freq.put("sri", 3);
    freq.put("sru", 5);
    freq.put("Ade", 5);
    freq.put("z\u0307ic\u0307", 12);
    freq.put("loc", 8);
    freq.put("loa", 11);
    freq.put("lof", 3);
    freq.put("log", 85);
    freq.put("lod", 5);
    freq.put("lok", 75);
    freq.put("lon", 40);
    freq.put("loo", 3);
    freq.put("lol", 7);
    freq.put("lom", 30);
    freq.put("lor", 33);
    freq.put("los", 37);
    freq.put("lop", 32);
    freq.put("loq", 8);
    freq.put("lov", 14);
    freq.put("low", 5);
    freq.put("lot", 7);
    freq.put("lox", 8);
    freq.put("rju", 89);
    freq.put("\u0646", 8);
    freq.put("J", 183);
    freq.put("\u03c3\u03c4", 6);
    freq.put("Tne", 3);
    freq.put("rje", 31);
    freq.put("rja", 200);
    freq.put("rjo", 20);
    freq.put("rji", 21);
    freq.put("lo ", 39);
    freq.put("\u03b1\u03bd", 3);
    freq.put("Win", 6);
    freq.put(" sn", 48);
    freq.put("Est", 8);
    freq.put("Esp", 6);
    freq.put(" sb", 7);
    freq.put("Lam", 5);
    freq.put("Lan", 9);
    freq.put(" sa", 229);
    freq.put("yoh", 7);
    freq.put("Lad", 7);
    freq.put("G\u0307or", 8);
    freq.put("Lag", 83);
    freq.put("Lab", 16);
    freq.put("Lat", 46);
    freq.put("Lau", 7);
    freq.put("Law", 4);
    freq.put("Lap", 3);
    freq.put("yor", 3);
    freq.put("c ", 33);
    freq.put("La ", 18);
    freq.put("Bro", 10);
    freq.put(" ic\u0307", 18);
    freq.put("Bri", 16);
    freq.put("Bre", 4);
    freq.put("Bra", 34);
    freq.put("\u062d\u0645", 5);
    freq.put("mp ", 3);
    freq.put("Pja", 3);
    freq.put("z\u0307z\u0307", 22);
    freq.put("mpe", 61);
    freq.put("mpa", 24);
    freq.put("mpo", 76);
    freq.put("mpl", 44);
    freq.put("mpj", 111);
    freq.put("mph", 3);
    freq.put("mpi", 20);
    freq.put("mpt", 4);
    freq.put("mpu", 8);
    freq.put("mpr", 13);
    freq.put("mps", 11);
    freq.put("ass", 718);
    freq.put(" r ", 39);
    freq.put("eg\u0127", 196);
    freq.put(" ru", 49);
    freq.put(" rt", 4);
    freq.put(" rw", 6);
    freq.put(" rq", 3);
    freq.put(" rr", 12);
    freq.put(" re", 264);
    freq.put(" rd", 3);
    freq.put(" ra", 151);
    freq.put(" ro", 18);
    freq.put(" rn", 5);
    freq.put(" ri", 86);
    freq.put("s\u030c", 4);
    freq.put("yst", 4);
    freq.put("jra", 9);
    freq.put("jri", 3);
    freq.put("ask", 7);
    freq.put("jru", 10);
    freq.put("S ", 15);
    freq.put("G\u0307", 316);
    freq.put("kaz\u0307", 12);
    freq.put("Sz", 5);
    freq.put("Sy", 30);
    freq.put("vk", 3);
    freq.put("jr ", 16);
    freq.put("Sr", 3);
    freq.put("Sq", 14);
    freq.put("Sp", 60);
    freq.put("Su", 37);
    freq.put("St", 76);
    freq.put("fa\u0300", 4);
    freq.put("Si", 118);
    freq.put("Sh", 15);
    freq.put("So", 67);
    freq.put("Kti", 6);
    freq.put("Sm", 6);
    freq.put("Sl", 30);
    freq.put("Sc", 30);
    freq.put("Sa", 194);
    freq.put("Se", 140);
    freq.put("wls", 12);
    freq.put("f ", 773);
    freq.put("mn", 24);
    freq.put("eg ", 40);
    freq.put(" rc\u0307", 4);
    freq.put("fq", 3);
    freq.put("fr", 334);
    freq.put("fs", 61);
    freq.put("ft", 42);
    freq.put("fu", 476);
    freq.put("\u03bf\u0301", 6);
    freq.put("fa", 662);
    freq.put("fd", 8);
    freq.put("fe", 787);
    freq.put("ff", 183);
    freq.put("fg", 10);
    freq.put("fh", 8);
    freq.put("fi", 2350);
    freq.put("fj", 33);
    freq.put("fk", 8);
    freq.put("fl", 891);
    freq.put("fn", 137);
    freq.put("fo", 198);
    freq.put("a", 36814);
    freq.put("egr", 17);
    freq.put("egw", 8);
    freq.put("wle", 24);
    freq.put("egi", 13);
    freq.put("egh", 15);
    freq.put("ego", 65);
    freq.put("o\u0308", 13);
    freq.put("ega", 47);
    freq.put("egg", 4);
    freq.put("ege", 3);
    freq.put("ce ", 25);
    freq.put("y ", 107);
    freq.put("ffu", 34);
    freq.put("ffr", 4);
    freq.put("ffo", 12);
    freq.put("uvj", 3);
    freq.put("ffi", 63);
    freq.put("ffe", 36);
    freq.put("ffa", 23);
    freq.put(" Ol", 35);
    freq.put("st\u0127", 3);
    freq.put(" Oc", 64);
    freq.put("if ", 117);
    freq.put(" Ot", 58);
    freq.put(" Or", 54);
    freq.put(" Os", 11);
    freq.put(" Op", 37);
    freq.put("yi", 15);
    freq.put("yk", 3);
    freq.put("ym", 6);
    freq.put("yl", 84);
    freq.put("yo", 31);
    freq.put("yn", 30);
    freq.put("ya", 12);
    freq.put("cen", 14);
    freq.put("yc", 47);
    freq.put("cel", 60);
    freq.put("ye", 9);
    freq.put("yd", 24);
    freq.put("yg", 9);
    freq.put("rwo", 8);
    freq.put("ces", 13);
    freq.put("cer", 3);
    freq.put("cep", 6);
    freq.put("yp", 12);
    freq.put("ys", 30);
    freq.put("yr", 32);
    freq.put("yu", 4);
    freq.put("yt", 6);
    freq.put("yw", 4);
    freq.put("ff ", 8);
    freq.put("ift", 4);
    freq.put("ifr", 55);
    freq.put("ifs", 12);
    freq.put(" O ", 3);
    freq.put("ife", 401);
    freq.put("iff", 69);
    freq.put("ifa", 9);
    freq.put("ifl", 8);
    freq.put("ifo", 14);
    freq.put("ifh", 3);
    freq.put("ifi", 272);
    freq.put("ifk", 8);
    freq.put("Enc", 3);
    freq.put("Ene", 5);
    freq.put("Eng", 4);
    freq.put("pu ", 10);
    freq.put("Enr", 4);
    freq.put("as ", 228);
    freq.put("Eny", 3);
    freq.put("kac\u0307", 4);
    freq.put("liz\u0307", 80);
    freq.put("pul", 17);
    freq.put("pun", 43);
    freq.put("asp", 12);
    freq.put("ast", 86);
    freq.put("asy", 3);
    freq.put("pub", 79);
    freq.put("lic\u0307", 28);
    freq.put("asc", 4);
    freq.put("asb", 8);
    freq.put("asa", 31);
    freq.put("asf", 4);
    freq.put("ase", 15);
    freq.put("put", 13);
    freq.put("asj", 14);
    freq.put("asi", 28);
    freq.put("ash", 10);
    freq.put("pur", 4);
    freq.put("pus", 51);
    freq.put("lig\u0307", 29);
    freq.put(" F ", 26);
    freq.put("e\u0301de\u0301", 4);
    freq.put("Tak", 20);
    freq.put("Imm", 6);
    freq.put("Cla", 6);
    freq.put("Imq", 4);
    freq.put("Imp", 28);
    freq.put("Ims", 3);
    freq.put("Imt", 3);
    freq.put("nc ", 3);
    freq.put("Clu", 11);
    freq.put("st ", 158);
    freq.put("ncy", 4);
    freq.put("tfo", 4);
    freq.put("tfi", 39);
    freq.put(" Oc\u0307", 21);
    freq.put("nct", 3);
    freq.put("\u064e", 4);
    freq.put("nch", 21);
    freq.put("nci", 13);
    freq.put("nck", 6);
    freq.put("nco", 5);
    freq.put("nca", 8);
    freq.put("nce", 28);
    freq.put("ste", 168);
    freq.put("stg", 14);
    freq.put("sta", 565);
    freq.put("stl", 9);
    freq.put("stm", 6);
    freq.put("sto", 141);
    freq.put("sth", 20);
    freq.put("sti", 578);
    freq.put("stj", 26);
    freq.put("stu", 77);
    freq.put("stw", 3);
    freq.put("str", 208);
    freq.put("Gol", 3);
    freq.put("ka ", 595);
    freq.put("Ajr", 5);
    freq.put("Gor", 3);
    freq.put("lid", 107);
    freq.put("Nik", 9);
    freq.put("lif", 45);
    freq.put("lig", 20);
    freq.put("Nin", 4);
    freq.put("lia", 195);
    freq.put("lib", 16);
    freq.put("lic", 5);
    freq.put("lil", 77);
    freq.put("Nic", 7);
    freq.put("lin", 205);
    freq.put("lio", 10);
    freq.put("lih", 10);
    freq.put("Nig", 4);
    freq.put("lij", 41);
    freq.put("lik", 151);
    freq.put("lit", 177);
    freq.put("liu", 3);
    freq.put("liv", 44);
    freq.put("lip", 11);
    freq.put("liq", 3);
    freq.put("lir", 20);
    freq.put("lis", 72);
    freq.put("Nis", 14);
    freq.put("lix", 7);
    freq.put("liz", 26);
    freq.put("rhy", 4);
    freq.put("kab", 9);
    freq.put("Thy", 15);
    freq.put("kad", 8);
    freq.put("tfa", 11);
    freq.put("kan", 190);
    freq.put("kam", 103);
    freq.put("kal", 77);
    freq.put("kar", 93);
    freq.put("kap", 69);
    freq.put("kaw", 19);
    freq.put("rho", 3);
    freq.put("kat", 120);
    freq.put("rha", 8);
    freq.put("kaz", 92);
    freq.put("The", 180);
    freq.put("li ", 2058);
    freq.put("qbi", 3);
    freq.put("\u0127er", 14);
    freq.put("su\u0300 ", 19);
    freq.put("\u0127et", 19);
    freq.put("\u0127ex", 8);
    freq.put("\u0127ed", 246);
    freq.put(" t\u0127", 12);
    freq.put("\u0127en", 3);
    freq.put("\u0127el", 10);
    freq.put("ymp", 4);
    freq.put("ox ", 8);
    freq.put("a\u0303", 4);
    freq.put("oxx", 10);
    freq.put("oxr", 11);
    freq.put("x", 1481);
    freq.put("wot", 6);
    freq.put("wov", 3);
    freq.put("wor", 12);
    freq.put("wol", 8);
    freq.put("Ple", 3);
    freq.put("\u0637", 3);
    freq.put("adr", 40);
    freq.put("g\u0307di", 13);
    freq.put("Wan", 9);
    freq.put("Wal", 6);
    freq.put("Gon", 6);
    freq.put("gme", 4);
    freq.put("Wat", 3);
    freq.put("War", 11);
    freq.put(" t ", 197);
    freq.put("ydr", 3);
    freq.put(" \u20ac ", 8);
    freq.put(" tw", 132);
    freq.put(" tu", 32);
    freq.put("ada", 28);
    freq.put(" tr", 112);
    freq.put(" tq", 9);
    freq.put("N", 343);
    freq.put(" to", 29);
    freq.put(" tn", 25);
    freq.put(" tm", 45);
    freq.put(" tl", 67);
    freq.put(" tk", 32);
    freq.put(" ti", 653);
    freq.put(" th", 28);
    freq.put(" tg", 23);
    freq.put(" tf", 46);
    freq.put(" te", 158);
    freq.put(" tb", 6);
    freq.put(" ta", 4807);
    freq.put("sfo", 8);
    freq.put("gs ", 5);
    freq.put("lie", 205);
    freq.put("FA ", 39);
    freq.put("lim", 90);
    freq.put("bog", 10);
    freq.put("z\u0307u", 43);
    freq.put("\u0628\u0646 ", 3);
    freq.put("rwi", 7);
    freq.put("\u03b9", 17);
    freq.put("ee ", 9);
    freq.put(" g\u0307a", 11);
    freq.put("ipr", 10);
    freq.put("eev", 3);
    freq.put("z\u0307d", 31);
    freq.put("een", 8);
    freq.put("ru ", 983);
    freq.put("z\u0307a", 337);
    freq.put("ac\u0307 ", 16);
    freq.put(" Qu", 13);
    freq.put("A\u0127", 10);
    freq.put(" Qa", 28);
    freq.put("id ", 220);
    freq.put(" Qo", 7);
    freq.put("ruh", 3);
    freq.put("run", 22);
    freq.put("rum", 16);
    freq.put("rub", 5);
    freq.put("ruc", 3);
    freq.put("ruf", 243);
    freq.put("rug", 6);
    freq.put("ruz", 6);
    freq.put("rux", 51);
    freq.put("ac\u0307l", 3);
    freq.put("rus", 26);
    freq.put("rup", 116);
    freq.put("ruv", 3);
    freq.put("rut", 27);
    freq.put("na\u0127", 25);
    freq.put("idw", 3);
    freq.put("idu", 97);
    freq.put("idr", 16);
    freq.put("idn", 6);
    freq.put("ido", 19);
    freq.put("idl", 10);
    freq.put("idm", 4);
    freq.put("idj", 5);
    freq.put("idh", 17);
    freq.put("idi", 65);
    freq.put("idf", 3);
    freq.put("idd", 59);
    freq.put("ide", 302);
    freq.put("Az\u0307", 10);
    freq.put("ida", 303);
    freq.put("Eli", 7);
    freq.put("Ell", 8);
    freq.put("Ele", 15);
    freq.put("kut", 11);
    freq.put("ut ", 41);
    freq.put("aqt", 25);
    freq.put("aqw", 22);
    freq.put("tul", 54);
    freq.put("aqs", 69);
    freq.put("El ", 3);
    freq.put("aqd", 16);
    freq.put("aqg", 13);
    freq.put("aqf", 4);
    freq.put("aqa", 49);
    freq.put("aqb", 4);
    freq.put("aql", 5);
    freq.put("fda", 8);
    freq.put("uta", 32);
    freq.put("ute", 17);
    freq.put("uth", 116);
    freq.put("uti", 20);
    freq.put("uto", 11);
    freq.put("utr", 4);
    freq.put("uts", 8);
    freq.put("utt", 72);
    freq.put("utu", 4);
    freq.put("rg\u0307 ", 7);
    freq.put("\u03bc\u03b1", 4);
    freq.put("Tw", 8);
    freq.put("rug\u0307", 4);
    freq.put("Tr", 86);
    freq.put("ru\u0127", 36);
    freq.put("Tn", 4);
    freq.put("To", 22);
    freq.put("Tl", 3);
    freq.put("Th", 203);
    freq.put("Ti", 59);
    freq.put("Te", 32);
    freq.put("Tc", 3);
    freq.put("Ta", 192);
    freq.put("nab", 3);
    freq.put("ruc\u0307", 3);
    freq.put("nad", 8);
    freq.put("nae", 109);
    freq.put("nak", 7);
    freq.put("nan", 43);
    freq.put("nal", 267);
    freq.put("nam", 19);
    freq.put("nar", 103);
    freq.put("nas", 4);
    freq.put("nav", 4);
    freq.put("naw", 8);
    freq.put("nat", 231);
    freq.put("naz", 141);
    freq.put("id\u0127", 7);
    freq.put("nax", 23);
    freq.put("rg\u0307e", 12);
    freq.put("rg\u0307a", 3);
    freq.put("rg\u0307n", 8);
    freq.put("rg\u0307j", 3);
    freq.put("rg\u0307i", 14);
    freq.put("rg\u0307u", 4);
    freq.put("ruz\u0307", 4);
    freq.put("T ", 10);
    freq.put("Aa", 3);
    freq.put("na ", 730);
    freq.put("Ab", 15);
    freq.put("e", 19812);
    freq.put("Ad", 10);
    freq.put("Ag", 8);
    freq.put("Af", 58);
    freq.put("Ai", 4);
    freq.put("Ak", 6);
    freq.put("Aj", 8);
    freq.put("Am", 151);
    freq.put("Al", 95);
    freq.put("An", 92);
    freq.put("Ap", 61);
    freq.put("As", 91);
    freq.put("Ar", 109);
    freq.put("Au", 24);
    freq.put("At", 31);
    freq.put("Aw", 130);
    freq.put("Av", 13);
    freq.put("ohy", 17);
    freq.put("u\u0301", 4);
    freq.put("gw", 122);
    freq.put("gv", 22);
    freq.put("gu", 371);
    freq.put("gt", 4);
    freq.put("gs", 6);
    freq.put("gr", 236);
    freq.put("gy", 11);
    freq.put("gg", 22);
    freq.put("ge", 94);
    freq.put("gd", 3);
    freq.put("ga", 267);
    freq.put("Gio", 13);
    freq.put("gn", 26);
    freq.put("gm", 7);
    freq.put("gl", 98);
    freq.put("gi", 153);
    freq.put("gh", 60);
    freq.put("lko", 5);
    freq.put("Nof", 25);
    freq.put("lke", 38);
    freq.put("ig\u0307g\u0307", 16);
    freq.put("Nob", 5);
    freq.put("lka", 19);
    freq.put("Not", 6);
    freq.put("Nov", 55);
    freq.put("lku", 8);
    freq.put("\u03bd", 14);
    freq.put("lks", 4);
    freq.put("Nor", 18);
    freq.put("g ", 166);
    freq.put("hi ", 164);
    freq.put("No ", 3);
    freq.put("Spi", 3);
    freq.put("Spo", 4);
    freq.put("Spa", 51);
    freq.put("\u03be", 4);
    freq.put("zm", 3);
    freq.put("zo", 27);
    freq.put("zi", 99);
    freq.put("zj", 857);
    freq.put("zk", 6);
    freq.put("ze", 53);
    freq.put("zg", 3);
    freq.put("za", 318);
    freq.put("zc", 4);
    freq.put("zz", 925);
    freq.put("zu", 81);
    freq.put("diz\u0307", 43);
    freq.put("yct", 35);
    freq.put("ych", 4);
    freq.put("yco", 3);
    freq.put("ycl", 3);
    freq.put("ull", 85);
    freq.put("oza", 5);
    freq.put("ozj", 13);
    freq.put("su\u0302r", 3);
    freq.put("ozz", 16);
    freq.put("\u03c3\u03c4\u03c1", 4);
    freq.put("iep", 6);
    freq.put("wie", 306);
    freq.put("wid", 19);
    freq.put("wic", 3);
    freq.put("win", 10);
    freq.put("gz\u0307", 57);
    freq.put("wik", 8);
    freq.put("wij", 8);
    freq.put("wiv", 11);
    freq.put("wit", 14);
    freq.put("wis", 83);
    freq.put("wir", 4);
    freq.put("wix", 6);
    freq.put("ig\u0307 ", 9);
    freq.put("Ji", 13);
    freq.put("wi ", 33);
    freq.put("g\u0127", 1944);
    freq.put("pic\u0307", 32);
    freq.put("ig\u0307o", 4);
    freq.put("ig\u0307i", 120);
    freq.put("ig\u0307j", 20);
    freq.put("ig\u0307e", 9);
    freq.put("ig\u0307a", 14);
    freq.put("g\u0307ju", 53);
    freq.put("ig\u0307b", 28);
    freq.put("g\u0307jo", 10);
    freq.put("ig\u0307u", 26);
    freq.put("g\u0307ja", 14);
    freq.put("ig\u0307r", 4);
    freq.put("duc\u0307", 12);
    freq.put(" va", 32);
    freq.put(" ve", 37);
    freq.put(" vi", 37);
    freq.put(" vj", 4);
    freq.put(" vo", 32);
    freq.put(" vu", 13);
    freq.put("kra", 35);
    freq.put("\u0644 ", 3);
    freq.put("tg\u0127", 40);
    freq.put("jna", 7);
    freq.put("Bi\u0300n", 4);
    freq.put("jne", 3);
    freq.put("jni", 5);
    freq.put("\u0628", 12);
    freq.put("jn ", 302);
    freq.put("c\u0327", 13);
    freq.put("hlo", 3);
    freq.put("mar", 284);
    freq.put("hle", 3);
    freq.put(" \u0628\u0646", 3);
    freq.put("Uro", 6);
    freq.put("ecc", 3);
    freq.put("eca", 3);
    freq.put("eco", 6);
    freq.put("ecl", 3);
    freq.put("eci", 7);
    freq.put("ech", 47);
    freq.put("\u02d0", 5);
    freq.put("ecu", 4);
    freq.put("ect", 11);
    freq.put(" C\u0307i", 37);
    freq.put("ecr", 5);
    freq.put(" C\u0307e", 23);
    freq.put("rs ", 55);
    freq.put("arr", 78);
    freq.put("aru", 30);
    freq.put(" Sz", 5);
    freq.put(" Sy", 30);
    freq.put(" Sr", 3);
    freq.put(" Sp", 59);
    freq.put(" Sq", 14);
    freq.put(" St", 70);
    freq.put(" Su", 37);
    freq.put(" Sk", 22);
    freq.put(" Sh", 15);
    freq.put(" Si", 118);
    freq.put(" So", 66);
    freq.put(" Sl", 30);
    freq.put(" Sm", 6);
    freq.put(" Sc", 30);
    freq.put(" Sa", 194);
    freq.put("\u03c1\u03bf\u03bd", 3);
    freq.put(" Se", 140);
    freq.put("rso", 10);
    freq.put("rsi", 68);
    freq.put("rsj", 6);
    freq.put("rse", 14);
    freq.put("rsa", 30);
    freq.put("cyc", 3);
    freq.put("R", 419);
    freq.put("rsu", 187);
    freq.put("cyo", 9);
    freq.put("cyn", 3);
    freq.put("bej", 120);
    freq.put("ben", 12);
    freq.put("bel", 180);
    freq.put("DUc", 3);
    freq.put("bed", 24);
    freq.put("uro\u0301", 4);
    freq.put("ber", 86);
    freq.put("bes", 4);
    freq.put("z\u0307", 1995);
    freq.put("bet", 24);
    freq.put("a\u0303o", 4);
    freq.put("aw ", 129);
    freq.put("ur ", 258);
    freq.put("i\u0300n", 4);
    freq.put("bur", 42);
    freq.put(" Sa\u0303", 4);
    freq.put("asl", 5);
    freq.put("\u0645\u062f ", 4);
    freq.put("aww", 25);
    freq.put("awt", 34);
    freq.put("awr", 8);
    freq.put("awn", 115);
    freq.put("awl", 18);
    freq.put("awk", 38);
    freq.put("awi", 5);
    freq.put("awh", 8);
    freq.put("awd", 35);
    freq.put("urd", 37);
    freq.put("ure", 13);
    freq.put("fji", 5);
    freq.put("urg", 28);
    freq.put("ura", 186);
    freq.put("i\u0300 ", 4);
    freq.put("urc", 3);
    freq.put("urm", 36);
    freq.put("fja", 6);
    freq.put("uro", 81);
    freq.put("uri", 160);
    freq.put("urj", 14);
    freq.put("urk", 10);
    freq.put("urt", 11);
    freq.put("uru", 12);
    freq.put("urr", 4);
    freq.put("urs", 18);
    freq.put("bun", 7);
    freq.put("fju", 21);
    freq.put("\u0127az\u0307", 12);
    freq.put("bul", 7);
    freq.put("nge", 34);
    freq.put("nga", 15);
    freq.put("ngl", 71);
    freq.put("iz\u0307z\u0307", 16);
    freq.put("ngo", 55);
    freq.put("ngh", 3);
    freq.put("ngi", 62);
    freq.put("sh ", 5);
    freq.put("ngu", 19);
    freq.put("ngw", 87);
    freq.put("ngr", 5);
    freq.put("Pla", 4);
    freq.put("tbu", 4);
    freq.put("tbi", 15);
    freq.put("tbo", 146);
    freq.put("\u0127a\u0127", 7);
    freq.put("tbe", 8);
    freq.put("\u0127ag\u0307", 8);
    freq.put("ng ", 93);
    freq.put("shv", 3);
    freq.put("z\u0307an", 6);
    freq.put("sha", 4);
    freq.put("oc\u0307e", 24);
    freq.put("oc\u0307i", 3);
    freq.put("shi", 9);
    freq.put("oc\u0307j", 52);
    freq.put("sho", 8);
    freq.put("ke ", 14);
    freq.put("lup", 21);
    freq.put("luq", 8);
    freq.put("lur", 46);
    freq.put("lus", 25);
    freq.put("lut", 13);
    freq.put("luw", 21);
    freq.put("luz", 17);
    freq.put("lub", 13);
    freq.put("lud", 32);
    freq.put("luf", 7);
    freq.put("lug", 17);
    freq.put("luh", 3);
    freq.put("\u043b", 9);
    freq.put("lul", 11);
    freq.put("lum", 49);
    freq.put("lun", 14);
    freq.put("keo", 3);
    freq.put("jif", 40);
    freq.put("kem", 88);
    freq.put("kel", 103);
    freq.put("kek", 4);
    freq.put("kej", 25);
    freq.put("dju", 54);
    freq.put("kes", 13);
    freq.put("ker", 7);
    freq.put("lu ", 231);
    freq.put("qfi", 4);
    freq.put("qfe", 12);
    freq.put("qfa", 6);
    freq.put("mg\u0127", 14);
    freq.put("Log", 14);
    freq.put("\u0127ax", 61);
    freq.put("\u0127aw", 35);
    freq.put("\u0127at", 89);
    freq.put("Lon", 14);
    freq.put("\u0127ar", 253);
    freq.put("\u0127aq", 25);
    freq.put("Lor", 7);
    freq.put("Los", 5);
    freq.put("\u0127am", 77);
    freq.put("\u0127al", 808);
    freq.put("Lov", 3);
    freq.put("Low", 4);
    freq.put("Lou", 11);
    freq.put("\u0127af", 102);
    freq.put("oc\u0307c\u0307", 4);
    freq.put("\u0127ad", 105);
    freq.put("\u0127ab", 77);
    freq.put("iz\u0307v", 9);
    freq.put("iz\u0307w", 3);
    freq.put("iz\u0307u", 23);
    freq.put("jit", 24);
    freq.put("iz\u0307g", 17);
    freq.put("iz\u0307d", 28);
    freq.put("iz\u0307e", 9);
    freq.put("iz\u0307b", 3);
    freq.put("iz\u0307a", 64);
    freq.put("iz\u0307n", 3);
    freq.put("iz\u0307o", 16);
    freq.put("iz\u0307l", 3);
    freq.put("iz\u0307m", 78);
    freq.put("iz\u0307j", 66);
    freq.put("iz\u0307i", 101);
    freq.put("oth", 50);
    freq.put("oti", 37);
    freq.put("jip", 30);
    freq.put("otn", 7);
    freq.put("oto", 97);
    freq.put("ota", 54);
    freq.put("otb", 40);
    freq.put("ote", 23);
    freq.put("dji", 7);
    freq.put("otr", 6);
    freq.put("ott", 397);
    freq.put("\u0127a ", 142);
    freq.put("And", 23);
    freq.put("Ang", 6);
    freq.put("Ana", 7);
    freq.put("Ann", 10);
    freq.put("Ant", 30);
    freq.put("jix", 9);
    freq.put("iz\u0307 ", 266);
    freq.put("ya ", 6);
    freq.put("wko", 61);
    freq.put("wka", 4);
    freq.put("\u0126a", 62);
    freq.put("\u0126e", 12);
    freq.put("\u0126i", 6);
    freq.put("You", 4);
    freq.put("Yor", 8);
    freq.put("\u0126o", 6);
    freq.put("luz\u0307", 9);
    freq.put("i\u0127 ", 15);
    freq.put("wk ", 39);
    freq.put("\u0126 ", 3);
    freq.put("\u05d0", 4);
    freq.put("Sha", 8);
    freq.put("i", 33644);
    freq.put("i\u0127a", 6);
    freq.put("\u3042\u3042", 5);
    freq.put(" xj", 87);
    freq.put(" xi", 82);
    freq.put(" xh", 13);
    freq.put(" xo", 47);
    freq.put("Ba", 116);
    freq.put(" xm", 10);
    freq.put(" xl", 4);
    freq.put("Bl", 8);
    freq.put("z\u0307a ", 120);
    freq.put(" xa", 56);
    freq.put("Bo", 64);
    freq.put("Bh", 3);
    freq.put("Bi", 53);
    freq.put(" xe", 41);
    freq.put("Bu", 42);
    freq.put("Br", 67);
    freq.put(" xt", 7);
    freq.put("xlo", 8);
    freq.put("B ", 11);
    freq.put(" x ", 26);
    freq.put("jlu", 3);
    freq.put("jla", 10);
    freq.put("jli", 4);
    freq.put("U ", 10);
    freq.put("Bi\u0300", 4);
    freq.put("swi", 5);
    freq.put("dui", 3);
    freq.put("Ur", 9);
    freq.put("Un", 116);
    freq.put("jl ", 6);
    freq.put("Uk", 8);
    freq.put("Ug", 4);
    freq.put("Uf", 4);
    freq.put("Uc", 3);
    freq.put("dum", 27);
    freq.put("swa", 16);
    freq.put("ea ", 142);
    freq.put("h ", 148);
    freq.put("gz\u0307i", 25);
    freq.put("gz\u0307e", 32);
    freq.put("eak", 3);
    freq.put("hy", 86);
    freq.put("eal", 32);
    freq.put("ean", 52);
    freq.put("hr", 42);
    freq.put("hs", 4);
    freq.put("eae", 6);
    freq.put("eag", 47);
    freq.put("hu", 1211);
    freq.put("eaz", 3);
    freq.put("hn", 20);
    freq.put("ho", 347);
    freq.put("hl", 6);
    freq.put("hm", 5);
    freq.put("eas", 6);
    freq.put("ear", 18);
    freq.put("ph", 296);
    freq.put("hd", 5);
    freq.put("he", 655);
    freq.put("dma", 6);
    freq.put("pi", 340);
    freq.put("dmi", 5);
    freq.put("dmu", 9);
    freq.put("c\u0307ja", 126);
    freq.put("c\u0307je", 14);
    freq.put("c\u0307ji", 6);
    freq.put("c\u0307jo", 3);
    freq.put("Gve", 9);
    freq.put("c\u0307ju", 9);
    freq.put("Or", 54);
    freq.put("hn ", 12);
    freq.put(" Ur", 9);
    freq.put(" Un", 116);
    freq.put(" Uk", 8);
    freq.put(" Uf", 4);
    freq.put(" Ug", 4);
    freq.put("he\u0301", 4);
    freq.put("rqa", 5);
    freq.put("rqi", 10);
    freq.put("hne", 4);
    freq.put("\u0644\u0628", 3);
    freq.put("auc", 40);
    freq.put("aud", 9);
    freq.put("aul", 19);
    freq.put("up ", 4);
    freq.put("aus", 12);
    freq.put("aur", 7);
    freq.put("aut", 3);
    freq.put("ble", 19);
    freq.put("upo", 13);
    freq.put("Sa\u0303o", 4);
    freq.put("upj", 144);
    freq.put("upi", 3);
    freq.put("upe", 102);
    freq.put("fha", 5);
    freq.put("upa", 34);
    freq.put("fhu", 3);
    freq.put("upr", 3);
    freq.put("upp", 127);
    freq.put("me ", 12);
    freq.put("u\u0127 ", 36);
    freq.put("orz", 8);
    freq.put("nen", 136);
    freq.put("neo", 5);
    freq.put("Pun", 16);
    freq.put("nem", 11);
    freq.put("nej", 22);
    freq.put("G", 502);
    freq.put("nei", 3);
    freq.put("Pue", 3);
    freq.put("ned", 5);
    freq.put("neb", 5);
    freq.put("nea", 9);
    freq.put("nez", 3);
    freq.put("nex", 7);
    freq.put("ney", 5);
    freq.put("new", 6);
    freq.put("net", 181);
    freq.put("ner", 463);
    freq.put("nes", 21);
    freq.put("Kaz\u0307", 3);
    freq.put("med", 40);
    freq.put("\u0443", 4);
    freq.put("u\u0127h", 6);
    freq.put("mem", 52);
    freq.put("mel", 57);
    freq.put("u\u0127a", 4);
    freq.put("men", 449);
    freq.put("mek", 7);
    freq.put("mej", 6);
    freq.put("met", 112);
    freq.put("mew", 26);
    freq.put("meq", 33);
    freq.put("mes", 53);
    freq.put("mer", 199);
    freq.put("mex", 53);
    freq.put("u\u0127u", 28);
    freq.put("mez", 28);
    freq.put("oro", 35);
    freq.put("dru", 14);
    freq.put("orl", 4);
    freq.put("ne ", 56);
    freq.put("sju", 17);
    freq.put("dri", 35);
    freq.put("orm", 113);
    freq.put("sjo", 45);
    freq.put("dro", 22);
    freq.put("dra", 100);
    freq.put("sja", 131);
    freq.put("dre", 13);
    freq.put("ork", 31);
    freq.put("z\u0307ep", 5);
    freq.put("z\u0307er", 23);
    freq.put("z\u0307es", 3);
    freq.put("orh", 4);
    freq.put("z\u0307ew", 71);
    freq.put("orf", 85);
    freq.put("\u0127n", 16);
    freq.put("z\u0307ej", 42);
    freq.put("z\u0307ek", 4);
    freq.put("z\u0307el", 21);
    freq.put("ord", 400);
    freq.put("z\u0307en", 93);
    freq.put("\u0127l", 70);
    freq.put("Il ", 468);
    freq.put("orb", 8);
    freq.put("Tit", 8);
    freq.put("lwa", 13);
    freq.put("A\u0301", 3);
    freq.put("Ste", 7);
    freq.put("qde", 11);
    freq.put("Sta", 45);
    freq.put("qda", 13);
    freq.put("Sto", 6);
    freq.put("Stu", 4);
    freq.put("qdu", 4);
    freq.put("Tir", 4);
    freq.put("Str", 12);
    freq.put("V", 188);
    freq.put("j\u0127i", 4);
    freq.put("j\u0127o", 4);
    freq.put("j\u0127a", 22);
    freq.put("xhu", 12);
    freq.put("j\u0127u", 17);
    freq.put("Lie", 40);
    freq.put("me\u0127", 6);
    freq.put("Lig", 6);
    freq.put("Lib", 14);
    freq.put("Lim", 4);
    freq.put("Lin", 17);
    freq.put("Lit", 19);
    freq.put("mg\u0307i", 4);
    freq.put("Liv", 4);
    freq.put("Lip", 3);
    freq.put("Lis", 5);
    freq.put("Lix", 4);
    freq.put("Tif", 3);
    freq.put("Rhy", 13);
    freq.put("rie", 173);
    freq.put("Kan", 16);
    freq.put("Al ", 6);
    freq.put("Kal", 22);
    freq.put("Kas", 3);
    freq.put("Kar", 44);
    freq.put("nez\u0307", 25);
    freq.put("Kap", 12);
    freq.put("Kav", 4);
    freq.put("Kat", 66);
    freq.put("ovr", 9);
    freq.put("ovs", 7);
    freq.put("Li ", 3);
    freq.put("ovu", 4);
    freq.put("ova", 36);
    freq.put("ovd", 7);
    freq.put("ove", 85);
    freq.put("ovj", 14);
    freq.put("mez\u0307", 3);
    freq.put("ovi", 121);
    freq.put("All", 25);
    freq.put("Ali", 5);
    freq.put("Alf", 10);
    freq.put("ne\u0127", 5);
    freq.put("Ale", 12);
    freq.put("Alb", 16);
    freq.put("Ala", 4);
    freq.put("Alt", 7);
    freq.put("mx ", 29);
    freq.put("\u03c1", 17);
    freq.put("g\u0307na", 5);
    freq.put("mxu", 3);
    freq.put("g\u0307ni", 14);
    freq.put("g\u0307nu", 5);
    freq.put("mxi", 4);
    freq.put("jj\u0127", 7);
    freq.put("Wor", 4);
    freq.put("Wol", 6);
    freq.put(" zo", 4);
    freq.put(" zg", 3);
    freq.put("xu ", 22);
    freq.put("is ", 703);
    freq.put("\u0643", 3);
    freq.put("Eg\u0307i", 11);
    freq.put("iss", 346);
    freq.put("isr", 17);
    freq.put("isq", 15);
    freq.put("isp", 64);
    freq.put("isw", 15);
    freq.put("ist", 767);
    freq.put("isk", 76);
    freq.put("isj", 52);
    freq.put("isi", 121);
    freq.put("ish", 8);
    freq.put("iso", 8);
    freq.put("ism", 25);
    freq.put("isl", 7);
    freq.put("isc", 6);
    freq.put("isb", 14);
    freq.put("isa", 30);
    freq.put("isg", 4);
    freq.put("isf", 31);
    freq.put("ise", 115);
    freq.put("Eur", 71);
    freq.put("jju", 72);
    freq.put("jji", 212);
    freq.put("jje", 99);
    freq.put("jja", 162);
    freq.put("gyr", 9);
    freq.put("ty ", 13);
    freq.put("a\u0304f", 3);
    freq.put("do ", 29);
    freq.put("a\u0304r", 3);
    freq.put("tyl", 6);
    freq.put("lc\u0307i", 3);
    freq.put(" \u03c0", 4);
    freq.put("dok", 5);
    freq.put("don", 28);
    freq.put("dol", 28);
    freq.put("dom", 15);
    freq.put("dob", 9);
    freq.put("\u03b3\u03b1", 3);
    freq.put("m", 10789);
    freq.put("\u03b3\u03b5", 3);
    freq.put("doe", 3);
    freq.put("dor", 29);
    freq.put("dos", 3);
    freq.put("doq", 3);
    freq.put("dov", 12);
    freq.put("dow", 5);
    freq.put("dot", 46);
    freq.put(" We", 18);
    freq.put(" Wa", 37);
    freq.put(" Wo", 12);
    freq.put("c\u0307li", 3);
    freq.put(" Wh", 3);
    freq.put(" Wi", 72);
    freq.put("\u062c", 4);
    freq.put("ba ", 257);
    freq.put("\u0627\u0644\u0628", 3);
    freq.put(" ag\u0307", 6);
    freq.put("bat", 41);
    freq.put("\u03bf\u03bd ", 3);
    freq.put("bar", 140);
    freq.put("bas", 9);
    freq.put("baq", 45);
    freq.put("bax", 6);
    freq.put("bag", 5);
    freq.put("bab", 10);
    freq.put("bac", 4);
    freq.put("ban", 36);
    freq.put("bal", 50);
    freq.put("baj", 9);
    freq.put("bah", 3);
    freq.put("om ", 221);
    freq.put("iz\u0307", 708);
    freq.put("Rum", 68);
    freq.put("Rub", 3);
    freq.put("un ", 223);
    freq.put("Rus", 36);
    freq.put("omb", 11);
    freq.put("C", 374);
    freq.put("ec\u0307j", 24);
    freq.put("ec\u0307i", 288);
    freq.put("ec\u0307e", 7);
    freq.put("omo", 162);
    freq.put("omn", 3);
    freq.put("omm", 26);
    freq.put("omp", 103);
    freq.put("omw", 3);
    freq.put("omu", 72);
    freq.put("ig\u0307", 256);
    freq.put("omy", 17);
    freq.put("omx", 9);
    freq.put("z\u0307g\u0127", 77);
    freq.put("i\u0127", 23);
    freq.put("uns", 15);
    freq.put("unt", 74);
    freq.put("unu", 31);
    freq.put("unx", 4);
    freq.put("unz", 42);
    freq.put("una", 50);
    freq.put("ic\u0307", 413);
    freq.put("unc", 5);
    freq.put("und", 54);
    freq.put("une", 63);
    freq.put("fna", 111);
    freq.put("ung", 11);
    freq.put("uni", 172);
    freq.put("unj", 83);
    freq.put("unk", 8);
    freq.put("fni", 26);
    freq.put("uno", 22);
    freq.put("o\u0301n ", 4);
    freq.put("io\u0301", 8);
    freq.put("ie\u0300", 4);
    freq.put("\u0627\u0631", 5);
    freq.put("C ", 30);
    freq.put("ba\u0127", 69);
    freq.put("wda", 5);
    freq.put("ag\u0307 ", 3);
    freq.put("Ci", 11);
    freq.put("Ch", 51);
    freq.put("Co", 68);
    freq.put("Cl", 20);
    freq.put("slu", 3);
    freq.put("Ca", 154);
    freq.put("Ce", 10);
    freq.put("Cy", 6);
    freq.put("slo", 6);
    freq.put("sli", 8);
    freq.put("wdi", 3);
    freq.put("sle", 8);
    freq.put("sla", 16);
    freq.put("Cu", 17);
    freq.put("iy", 4);
    freq.put("ix", 189);
    freq.put("iz", 263);
    freq.put("Nag", 3);
    freq.put("iq", 30);
    freq.put("ip", 246);
    freq.put("is", 2434);
    freq.put("ir", 735);
    freq.put("Nan", 5);
    freq.put("it", 1487);
    freq.put("iv", 526);
    freq.put("ii", 54);
    freq.put("ih", 73);
    freq.put("Nap", 18);
    freq.put("ij", 1247);
    freq.put("im", 816);
    freq.put("il", 3822);
    freq.put("io", 243);
    freq.put("in", 3462);
    freq.put("Naz", 37);
    freq.put("Nax", 4);
    freq.put("ib", 328);
    freq.put("ie", 3131);
    freq.put("id", 1140);
    freq.put("ig", 155);
    freq.put("if", 976);
    freq.put("V ", 10);
    freq.put("ec\u0307c\u0307", 10);
    freq.put("lqu", 3);
    freq.put("iS", 6);
    freq.put("lqi", 7);
    freq.put("kis", 37);
    freq.put("kir", 13);
    freq.put("kip", 4);
    freq.put("kiv", 6);
    freq.put("kit", 81);
    freq.put("s\u0127i", 8);
    freq.put("kij", 28);
    freq.put("kin", 13);
    freq.put("kim", 27);
    freq.put("kil", 18);
    freq.put("s\u0127a", 9);
    freq.put("i ", 8050);
    freq.put("qju", 34);
    freq.put("kie", 660);
    freq.put("xje", 88);
    freq.put("Va", 62);
    freq.put("Ve", 40);
    freq.put("Vi", 49);
    freq.put("Vj", 21);
    freq.put("Vo", 5);
    freq.put("Vu", 3);
    freq.put("op ", 9);
    freq.put("eus", 11);
    freq.put("\u0645\u062d\u0645", 4);
    freq.put("opt", 11);
    freq.put("opu", 17);
    freq.put("opp", 10);
    freq.put("opr", 23);
    freq.put("ops", 11);
    freq.put("ope", 129);
    freq.put("opa", 66);
    freq.put("opl", 17);
    freq.put("opo", 212);
    freq.put("oph", 4);
    freq.put("opi", 35);
    freq.put("opj", 13);
    freq.put("Ars", 5);
    freq.put("Art", 37);
    freq.put("Ara", 11);
    freq.put("Arc", 9);
    freq.put("Arg", 13);
    freq.put("vdi", 7);
    freq.put("Ari", 5);
    freq.put("Arm", 8);
    freq.put("Tup", 22);
    freq.put("wwe", 130);
    freq.put("wwa", 50);
    freq.put("wwi", 65);
    freq.put("\u0645\u062d", 4);
    freq.put("ain", 11);
    freq.put("\u0645\u062f", 4);
    freq.put("Kor", 15);
    freq.put("zu ", 56);
    freq.put("g\u0307li", 8);
    freq.put("g\u0307lu", 7);
    freq.put("\u0127mi", 8);
    freq.put("\u0127ml", 9);
    freq.put("\u0127ma", 20);
    freq.put("\u0127me", 25);
    freq.put("zun", 20);
    freq.put("\u0127mu", 25);
    freq.put("Arc\u0307", 8);
    freq.put("i\u02d0", 3);
    freq.put("Arg\u0307", 5);
    freq.put("iq ", 16);
    freq.put("Z", 23);
    freq.put("iqu", 5);
    freq.put("iqs", 3);
    freq.put("iqi", 3);
    freq.put("iqa", 3);
    freq.put("fs ", 15);
    freq.put("axa", 34);
    freq.put("nki", 21);
    freq.put("fsa", 8);
    freq.put("Wie", 6);
    freq.put("fsi", 26);
    freq.put("Wil", 16);
    freq.put("Wik", 37);
    freq.put("Wis", 3);
    freq.put("fsu", 11);
    freq.put("Me\u0301r", 12);
    freq.put("\u03b1\u0301 ", 3);
    freq.put("di ", 130);
    freq.put("zab", 3);
    freq.put("Ix ", 9);
    freq.put("dil", 7);
    freq.put("dim", 6);
    freq.put("din", 179);
    freq.put("dio", 14);
    freq.put(" Z\u0307v", 16);
    freq.put("dij", 27);
    freq.put("dik", 70);
    freq.put("did", 92);
    freq.put("die", 92);
    freq.put("dif", 34);
    freq.put("dia", 21);
    freq.put(" Z\u0307a", 10);
    freq.put("dix", 11);
    freq.put(" Z\u0307g", 13);
    freq.put("diz", 58);
    freq.put(" Z\u0307e", 22);
    freq.put("dit", 30);
    freq.put("diu", 3);
    freq.put("div", 58);
    freq.put("dip", 39);
    freq.put(" Z\u0307o", 19);
    freq.put("dir", 32);
    freq.put("dis", 94);
    freq.put("Gru", 23);
    freq.put(" Yo", 13);
    freq.put(" Ya", 5);
    freq.put("ery", 3);
    freq.put("mag\u0307", 16);
    freq.put("Gre", 53);
    freq.put("ma\u0127", 21);
    freq.put("Gra", 35);
    freq.put("Gro", 11);
    freq.put("Gri", 59);
    freq.put("tne", 13);
    freq.put("\u03b2", 6);
    freq.put("DS ", 3);
    freq.put("tni", 17);
    freq.put("bor", 43);
    freq.put("bos", 92);
    freq.put("bot", 18);
    freq.put("ac\u0307i", 29);
    freq.put("bol", 163);
    freq.put("bom", 4);
    freq.put("bon", 12);
    freq.put("boo", 3);
    freq.put("bod", 6);
    freq.put("\u0127de", 11);
    freq.put("oo ", 4);
    freq.put("dic\u0307", 12);
    freq.put("rz\u0307j", 13);
    freq.put("rz\u0307e", 5);
    freq.put("aye", 4);
    freq.put("aya", 3);
    freq.put("dig\u0307", 15);
    freq.put("ac\u0307e", 201);
    freq.put("fl ", 790);
    freq.put("ul ", 72);
    freq.put("Bej", 10);
    freq.put("ood", 4);
    freq.put("Ben", 9);
    freq.put("Bel", 51);
    freq.put("ool", 9);
    freq.put("oon", 9);
    freq.put("ook", 3);
    freq.put("oot", 36);
    freq.put("t\u0127a", 17);
    freq.put("oor", 5);
    freq.put("Ber", 42);
    freq.put(" \u03b3", 5);
    freq.put("flu", 26);
    freq.put("ay ", 11);
    freq.put("ult", 73);
    freq.put("ulu", 42);
    freq.put("fli", 52);
    freq.put("ulk", 11);
    freq.put("uli", 33);
    freq.put("ulo", 12);
    freq.put("flo", 12);
    freq.put("ulm", 6);
    freq.put("fla", 8);
    freq.put("ula", 100);
    freq.put("fle", 3);
    freq.put("ulg", 8);
    freq.put("uld", 3);
    freq.put("ule", 6);
    freq.put("ma ", 767);
    freq.put("h\u0323", 3);
    freq.put("nya", 4);
    freq.put("maq", 20);
    freq.put("mas", 31);
    freq.put("sne", 3);
    freq.put("mat", 206);
    freq.put("maw", 27);
    freq.put("sna", 5);
    freq.put("wde", 23);
    freq.put("max", 4);
    freq.put("maz", 17);
    freq.put("sni", 48);
    freq.put("z\u0307wi", 9);
    freq.put("mad", 76);
    freq.put("mag", 281);
    freq.put("mak", 5);
    freq.put("maj", 11);
    freq.put("mam", 372);
    freq.put("mal", 346);
    freq.put("man", 245);
    freq.put("q", 1303);
    freq.put("Edw", 5);
    freq.put("Edu", 7);
    freq.put("ny ", 11);
    freq.put("lsa", 4);
    freq.put("lsn", 4);
    freq.put("z\u0307aw", 12);
    freq.put("z\u0307aq", 8);
    freq.put("z\u0307ar", 5);
    freq.put("lsi", 22);
    freq.put("z\u0307am", 10);
    freq.put("lst", 4);
    freq.put("z\u0307ak", 3);
    freq.put("z\u0307ag", 3);
    freq.put("kk ", 111);
    freq.put("z\u0307ab", 3);
    freq.put(" ab", 32);
    freq.put(" ac", 3);
    freq.put(" ad", 23);
    freq.put(" af", 19);
    freq.put(" ag", 8);
    freq.put(" aj", 6);
    freq.put(" ak", 162);
    freq.put(" al", 59);
    freq.put(" am", 35);
    freq.put(" an", 108);
    freq.put(" ap", 24);
    freq.put(" aq", 23);
    freq.put(" ar", 132);
    freq.put(" as", 43);
    freq.put(" at", 75);
    freq.put("\u0434", 3);
    freq.put(" av", 29);
    freq.put(" aw", 33);
    freq.put(" az", 7);
    freq.put("ls ", 21);
    freq.put("kku", 27);
    freq.put("kkw", 10);
    freq.put("kkr", 4);
    freq.put("kkl", 28);
    freq.put("kko", 72);
    freq.put("qha", 5);
    freq.put("kki", 13);
    freq.put("She", 3);
    freq.put("kkj", 7);
    freq.put("kke", 4);
    freq.put("kka", 60);
    freq.put(" a ", 4);
    freq.put("\u03bf\u03c2", 9);
    freq.put("\u0127oz\u0307", 3);
    freq.put("aq ", 62);
    freq.put("Lut", 4);
    freq.put("Luc", 3);
    freq.put("Lud", 4);
    freq.put("\u0127 ", 173);
    freq.put("Lul", 48);
    freq.put("or ", 112);
    freq.put("Ken", 3);
    freq.put("Kel", 5);
    freq.put("Ker", 4);
    freq.put("\u0127w", 6);
    freq.put("\u0127u", 248);
    freq.put("\u0127t", 94);
    freq.put("\u0127s", 24);
    freq.put("\u0127r", 448);
    freq.put("\u0127q", 17);
    freq.put("ory", 18);
    freq.put("orv", 6);
    freq.put("ort", 125);
    freq.put("oru", 43);
    freq.put("orr", 36);
    freq.put("ors", 30);
    freq.put("orp", 145);
    freq.put("\u0127x", 16);
    freq.put("orn", 14);
    freq.put("\u0127f", 4);
    freq.put("\u0127e", 308);
    freq.put("\u0127d", 136);
    freq.put("orj", 110);
    freq.put("\u0127b", 65);
    freq.put("\u0127a", 2183);
    freq.put("ori", 253);
    freq.put("\u0127o", 218);
    freq.put("org", 95);
    freq.put("\u0127m", 87);
    freq.put("ore", 44);
    freq.put("\u0127k", 5);
    freq.put("\u0127j", 30);
    freq.put("\u0127i", 157);
    freq.put("\u0127h", 109);
    freq.put("Apr", 48);
    freq.put("App", 10);
    freq.put("Ke ", 4);
    freq.put("Apo", 3);
    freq.put("o\u0308di", 5);
    freq.put("vja", 40);
    freq.put("vje", 12);
    freq.put("ua ", 9);
    freq.put("Ott", 58);
    freq.put(" ac\u0307", 8);
    freq.put("g\u0307ra", 10);
    freq.put("g\u0307ri", 43);
    freq.put("\u0127om", 7);
    freq.put("\u0127ol", 63);
    freq.put(" a\u0127", 91);
    freq.put("\u0127od", 26);
    freq.put("\u0127ob", 46);
    freq.put("\u0127ox", 11);
    freq.put("\u0127ot", 3);
    freq.put("\u0127or", 56);
    freq.put("\u0127\u0127", 98);
    freq.put("\u0127g\u0307", 7);
    freq.put("aqq", 52);
    freq.put("org\u0307", 15);
    freq.put("Do", 26);
    freq.put("Dm", 3);
    freq.put("Dj", 3);
    freq.put("Di", 313);
    freq.put("De", 63);
    freq.put("Da", 170);
    freq.put("Dz", 3);
    freq.put("Du", 83);
    freq.put("Dr", 9);
    freq.put("\u0127z\u0307", 10);
    freq.put("D ", 10);
    freq.put("ge ", 13);
    freq.put("We", 19);
    freq.put("Wa", 37);
    freq.put("Wo", 12);
    freq.put("Wi", 73);
    freq.put("Wh", 3);
    freq.put("\u0430", 16);
    freq.put("ges", 3);
    freq.put("ger", 25);
    freq.put("ged", 20);
    freq.put("gen", 15);
    freq.put("gel", 7);
    freq.put("o\u0301", 23);
    freq.put("tu ", 94);
    freq.put("j ", 96);
    freq.put("jf ", 9);
    freq.put("tup", 4);
    freq.put("tur", 340);
    freq.put("tuz", 13);
    freq.put("tus", 11);
    freq.put("jt", 35);
    freq.put("ju", 737);
    freq.put("jv", 3);
    freq.put("jw", 10);
    freq.put("tut", 5);
    freq.put("jq", 4);
    freq.put("jr", 39);
    freq.put("js", 35);
    freq.put("jl", 26);
    freq.put("jm", 11);
    freq.put("jn", 321);
    freq.put("clo", 3);
    freq.put("jh", 4);
    freq.put("ji", 1454);
    freq.put("jj", 553);
    freq.put("jk", 62);
    freq.put("jd", 14);
    freq.put("je", 811);
    freq.put("jf", 27);
    freq.put("jg", 45);
    freq.put("tud", 52);
    freq.put("ja", 2968);
    freq.put("jb", 5);
    freq.put("tug", 5);
    freq.put("jfi", 12);
    freq.put("jfa", 4);
    freq.put("pag\u0307", 7);
    freq.put("jo", 1155);
    freq.put("cle", 6);
    freq.put("ue\u0302\u0309n", 4);
    freq.put("tum", 4);
    freq.put("qs ", 34);
    freq.put("tun", 12);
    freq.put("ez\u0307w", 12);
    freq.put("ez\u0307j", 9);
    freq.put("z\u0307eg", 5);
    freq.put("ez\u0307i", 49);
    freq.put("ez\u0307m", 11);
    freq.put("ez\u0307a", 106);
    freq.put("tub", 97);
    freq.put("ez\u0307e", 122);
    freq.put("pac\u0307", 9);
    freq.put("cqu", 3);
    freq.put("qsa", 8);
    freq.put("Tu", 50);
    freq.put("E\u0301", 3);
    freq.put("qsi", 4);
    freq.put("qsm", 13);
    freq.put("Ts", 6);
    freq.put("qsu", 18);
    freq.put("qst", 4);
    freq.put("ez\u0307 ", 6);
    freq.put(" bo", 126);
    freq.put("ze ", 3);
    freq.put("oi ", 15);
    freq.put("j\u0127", 48);
    freq.put("jg\u0307", 12);
    freq.put("tu\u0127", 5);

    init2();
  }
  private static void init2() {
    
    freq.put("pap", 3);
    freq.put("par", 214);
    freq.put("pas", 9);
    freq.put("pat", 44);
    freq.put("pau", 3);
    freq.put("paw", 6);
    freq.put("ulj", 61);
    freq.put("paz", 13);
    freq.put(" bq", 5);
    freq.put("paj", 116);
    freq.put("pak", 3);
    freq.put("pal", 31);
    freq.put("pan", 89);
    freq.put("nz\u0307a", 5);
    freq.put("nz\u0307e", 3);
    freq.put("oii", 3);
    freq.put("A ", 61);
    freq.put("nz\u0307i", 7);
    freq.put("oid", 42);
    freq.put("oic", 3);
    freq.put("ois", 6);
    freq.put("bg\u0127", 18);
    freq.put("pa ", 115);
    freq.put("uji", 3);
    freq.put("ro\u0308d", 5);
    freq.put("C\u0307", 64);
    freq.put("ug\u0307 ", 13);
    freq.put("mo ", 20);
    freq.put("ac\u0307c\u0307", 12);
    freq.put("\u02c8k", 3);
    freq.put("buj", 3);
    freq.put("moz", 9);
    freq.put("mos", 16);
    freq.put("mor", 227);
    freq.put("mop", 4);
    freq.put("mov", 26);
    freq.put("mot", 12);
    freq.put("mok", 16);
    freq.put("ug\u0307j", 4);
    freq.put("mon", 63);
    freq.put("mom", 3);
    freq.put("mol", 9);
    freq.put("ug\u0307a", 4);
    freq.put("mob", 3);
    freq.put("o\u0127r", 183);
    freq.put("mog", 9);
    freq.put("mod", 52);
    freq.put("Ebr", 5);
    freq.put("Neo", 6);
    freq.put("Nec", 5);
    freq.put("New", 19);
    freq.put("Net", 11);
    freq.put("Ner", 3);
    freq.put("Nes", 17);
    freq.put("Med", 13);
    freq.put(" ch", 5);
    freq.put(" co", 14);
    freq.put("kma", 5);
    freq.put("Mem", 5);
    freq.put("Mel", 13);
    freq.put("Men", 6);
    freq.put("Mek", 3);
    freq.put("Mej", 72);
    freq.put("\u0127i\u0127", 8);
    freq.put("Met", 69);
    freq.put("Mes", 10);
    freq.put("Mer", 13);
    freq.put(" cr", 4);
    freq.put(" cu", 5);
    freq.put("\u0447", 5);
    freq.put("Dri", 5);
    freq.put("km ", 15);
    freq.put(" c ", 4);
    freq.put("jg\u0307i", 9);
    freq.put("ug\u0307g\u0307", 6);
    freq.put("mo\u0127", 11);
    freq.put("\u0127na", 9);
    freq.put("Ac", 13);
    freq.put("Avo", 3);
    freq.put("Avi", 6);
    freq.put("\u05dc", 3);
    freq.put("Az", 6);
    freq.put("\u0127ir", 47);
    freq.put("\u0127ix", 32);
    freq.put("\u0127ie", 9);
    freq.put("\u0127id", 22);
    freq.put("u", 12627);
    freq.put("\u0127in", 29);
    freq.put("\u0127ij", 3);
    freq.put("Van", 3);
    freq.put("Val", 38);
    freq.put("AF ", 7);
    freq.put("Giu", 10);
    freq.put("dec\u0307", 6);
    freq.put("Var", 7);
    freq.put("Vas", 3);
    freq.put("Vat", 9);
    freq.put("Gir", 3);
    freq.put("hy ", 4);
    freq.put("ws ", 8);
    freq.put("ajk", 11);
    freq.put("\u0438", 17);
    freq.put("ium", 21);
    freq.put("iud", 3);
    freq.put("iup", 3);
    freq.put("ius", 23);
    freq.put("akr", 6);
    freq.put("dez\u0307", 11);
    freq.put("hyi", 3);
    freq.put("hyl", 42);
    freq.put("hyn", 16);
    freq.put("hyr", 13);
    freq.put("hys", 3);
    freq.put("wst", 51);
    freq.put("u\u0300 ", 49);
    freq.put("go", 389);
    freq.put("g\u0307", 1841);
    freq.put("aba", 51);
    freq.put("abb", 120);
    freq.put("abe", 52);
    freq.put("abh", 3);
    freq.put("abi", 81);
    freq.put("abj", 3);
    freq.put("abl", 9);
    freq.put("abo", 15);
    freq.put("\u0430 ", 5);
    freq.put("abs", 4);
    freq.put("abt", 6);
    freq.put("abu", 36);
    freq.put("ggr", 4);
    freq.put("K", 559);
    freq.put("c\u0327ao", 5);
    freq.put("ggi", 7);
    freq.put("ab ", 119);
    freq.put("a\u0300", 150);
    freq.put("twa", 81);
    freq.put("twe", 40);
    freq.put("twi", 80);
    freq.put("two", 9);
    freq.put("de ", 86);
    freq.put("dex", 23);
    freq.put("ey ", 15);
    freq.put("jdo", 3);
    freq.put("dep", 10);
    freq.put("der", 87);
    freq.put("des", 56);
    freq.put("det", 26);
    freq.put("dew", 18);
    freq.put("deh", 9);
    freq.put("dej", 24);
    freq.put("dek", 3);
    freq.put("del", 201);
    freq.put("dem", 117);
    freq.put("den", 181);
    freq.put("deo", 4);
    freq.put("dea", 69);
    freq.put("deb", 21);
    freq.put("dec", 3);
    freq.put("ded", 7);
    freq.put("def", 20);
    freq.put("deg", 4);
    freq.put("rac\u0307", 6);
    freq.put("ryc", 35);
    freq.put("rys", 4);
    freq.put("az\u0307 ", 47);
    freq.put("qqf", 16);
    freq.put("qqa", 18);
    freq.put("Dom", 8);
    freq.put("qqi", 7);
    freq.put("qqu", 11);
    freq.put("Dor", 3);
    freq.put("az\u0307w", 3);
    freq.put("ry ", 23);
    freq.put("az\u0307m", 5);
    freq.put("az\u0307j", 3);
    freq.put("az\u0307i", 69);
    freq.put("az\u0307e", 9);
    freq.put("az\u0307a", 35);
    freq.put("uh ", 20);
    freq.put("ok ", 18);
    freq.put(" ez\u0307", 116);
    freq.put("oks", 3);
    freq.put("Bau", 3);
    freq.put("oku", 7);
    freq.put("Bas", 12);
    freq.put(" ec\u0307", 11);
    freq.put("oka", 26);
    freq.put("pai", 13);
    freq.put("Ban", 14);
    freq.put("okk", 60);
    freq.put("okj", 4);
    freq.put("okl", 157);
    freq.put("oko", 19);
    freq.put("Bai", 3);
    freq.put("ko\u0127", 9);
    freq.put("wic\u0307", 9);
    freq.put("tuz\u0307", 41);
    freq.put("mm ", 162);
    freq.put("\u0127t ", 57);
    freq.put("Ome", 4);
    freq.put("E ", 16);
    freq.put("mmx", 3);
    freq.put("sbu", 12);
    freq.put("mmu", 18);
    freq.put("mmo", 17);
    freq.put("sba", 12);
    freq.put("mmi", 433);
    freq.put("sbe", 8);
    freq.put("mme", 43);
    freq.put("Uni", 65);
    freq.put("Unj", 38);
    freq.put("sbi", 5);
    freq.put("mma", 248);
    freq.put("Fni", 6);
    freq.put("Em", 10);
    freq.put("El", 37);
    freq.put("Eo", 8);
    freq.put("En", 23);
    freq.put("Ei", 10);
    freq.put("Ek", 7);
    freq.put("Ed", 16);
    freq.put("Ea", 4);
    freq.put("zja", 65);
    freq.put("Eb", 8);
    freq.put("\u0127tu", 8);
    freq.put("Eu", 198);
    freq.put("Et", 8);
    freq.put("Ew", 159);
    freq.put("Ev", 6);
    freq.put("Ep", 3);
    freq.put("Es", 16);
    freq.put("Er", 23);
    freq.put("Ba\u0127", 22);
    freq.put(" el", 64);
    freq.put(" em", 16);
    freq.put(" en", 29);
    freq.put("kom", 155);
    freq.put("kol", 366);
    freq.put(" ek", 45);
    freq.put(" ed", 41);
    freq.put(" ef", 7);
    freq.put("kob", 7);
    freq.put("kod", 6);
    freq.put(" eb", 45);
    freq.put("G\u0307ap", 12);
    freq.put("koz", 3);
    freq.put(" ex", 4);
    freq.put(" ez", 3);
    freq.put(" et", 16);
    freq.put("kop", 26);
    freq.put("kos", 25);
    freq.put(" ew", 144);
    freq.put(" ep", 11);
    freq.put(" eq", 12);
    freq.put(" er", 97);
    freq.put(" es", 305);
    freq.put("Baz\u0307", 9);
    freq.put("qlu", 3);
    freq.put("tob", 5);
    freq.put("Slo", 10);
    freq.put("Sli", 18);
    freq.put("qli", 3);
    freq.put("Xj", 17);
    freq.put("b", 5187);
    freq.put("Xo", 3);
    freq.put("Xl", 25);
    freq.put("Xb", 4);
    freq.put("ko ", 13);
    freq.put("Xa", 7);
    freq.put("Xe", 24);
    freq.put("k ", 455);
    freq.put("Eg\u0307", 13);
    freq.put("Kin", 5);
    freq.put("Kim", 6);
    freq.put("Kil", 4);
    freq.put("Kie", 17);
    freq.put("Ate", 8);
    freq.put("Atl", 9);
    freq.put("Ath", 3);
    freq.put("Att", 9);
    freq.put("kb", 130);
    freq.put("ka", 1401);
    freq.put("kf", 3);
    freq.put("ke", 273);
    freq.put("kk", 336);
    freq.put("kj", 27);
    freq.put("ki", 1076);
    freq.put("kh", 8);
    freq.put("ko", 994);
    freq.put("kn", 25);
    freq.put("km", 24);
    freq.put("kl", 788);
    freq.put("ks", 70);
    freq.put("kr", 94);
    freq.put("kw", 142);
    freq.put("ku", 620);
    freq.put("kt", 248);
    freq.put("ky", 3);
    freq.put("z\u0307mu", 54);
    freq.put(" Bi\u0300", 4);
    freq.put("fug\u0307", 4);
    freq.put("Opo", 35);
    freq.put("fuz\u0307", 3);
    freq.put("\u0127ku", 3);
    freq.put("G\u0127a", 110);
    freq.put(" Be", 121);
    freq.put(" Ba", 116);
    freq.put("dg\u0127", 9);
    freq.put(" Bl", 8);
    freq.put(" Bo", 64);
    freq.put(" Bn", 3);
    freq.put(" Bi", 52);
    freq.put(" Bh", 3);
    freq.put(" Bu", 42);
    freq.put("ik ", 52);
    freq.put(" Br", 67);
    freq.put("\u03ba", 5);
    freq.put("Seb", 3);
    freq.put("iks", 8);
    freq.put("ikr", 9);
    freq.put("ikw", 8);
    freq.put(" B ", 10);
    freq.put("iku", 268);
    freq.put("ikt", 93);
    freq.put("z ", 83);
    freq.put("ikb", 47);
    freq.put("ika", 881);
    freq.put("ike", 17);
    freq.put("Sen", 7);
    freq.put("ikk", 115);
    freq.put("ikj", 14);
    freq.put("iki", 96);
    freq.put("iko", 55);
    freq.put("ikl", 19);
    freq.put("ewg\u0307", 67);
    freq.put("lbu", 6);
    freq.put("ga ", 43);
    freq.put("\u4e09", 4);
    freq.put("fu ", 61);
    freq.put("gaz", 14);
    freq.put("gat", 18);
    freq.put("gas", 10);
    freq.put("gar", 22);
    freq.put("gan", 108);
    freq.put("gal", 37);
    freq.put("rav", 9);
    freq.put("fut", 111);
    freq.put("fur", 38);
    freq.put("fuq", 184);
    freq.put("w\u0127u", 3);
    freq.put("fug", 3);
    freq.put("fun", 64);
    freq.put("lbe", 5);
    freq.put("sy ", 3);
    freq.put("Irl", 39);
    freq.put("Ira", 8);
    freq.put("ewk", 4);
    freq.put("ewi", 8);
    freq.put("ewn", 5);
    freq.put("ewl", 26);
    freq.put("bs ", 12);
    freq.put("ewg", 3);
    freq.put("tqi", 14);
    freq.put("ewd", 6);
    freq.put("\u03c9", 4);
    freq.put("ews", 5);
    freq.put("ewr", 5);
    freq.put("ewq", 3);
    freq.put("eww", 160);
    freq.put("ewt", 21);
    freq.put(" B\u0127", 8);
    freq.put("dge", 3);
    freq.put("cea", 7);
    freq.put("Ir ", 30);
    freq.put("ew ", 492);
    freq.put("y", 477);
    freq.put("jbi", 3);
    freq.put("lda", 18);
    freq.put("lde", 15);
    freq.put("ldo", 13);
    freq.put("bi ", 121);
    freq.put("lds", 3);
    freq.put("cus", 7);
    freq.put("rgu", 24);
    freq.put("rgy", 9);
    freq.put("rga", 85);
    freq.put("rge", 6);
    freq.put("rgi", 10);
    freq.put("cul", 51);
    freq.put("rgo", 5);
    freq.put("bin", 46);
    freq.put("bio", 7);
    freq.put("Din", 139);
    freq.put("ld ", 12);
    freq.put("bij", 35);
    freq.put("bik", 7);
    freq.put("bih", 6);
    freq.put("bii", 4);
    freq.put("Did", 61);
    freq.put("Die", 5);
    freq.put("bid", 61);
    freq.put("Dig", 3);
    freq.put("bib", 16);
    freq.put("Dia", 8);
    freq.put("Dib", 3);
    freq.put("Dic", 5);
    freq.put("AL ", 3);
    freq.put("bix", 5);
    freq.put("biv", 18);
    freq.put("Div", 29);
    freq.put("bir", 55);
    freq.put("bis", 105);
    freq.put("Dir", 3);
    freq.put("Dis", 6);
    freq.put("rg ", 19);
    freq.put("uf ", 169);
    freq.put("c\u0327a", 7);
    freq.put("c\u0327o", 6);
    freq.put("pet", 48);
    freq.put(" gz\u0307", 57);
    freq.put("pew", 24);
    freq.put("per", 271);
    freq.put("pes", 5);
    freq.put("pel", 16);
    freq.put("pen", 56);
    freq.put("pej", 31);
    freq.put("ped", 11);
    freq.put("ape", 8);
    freq.put("pea", 61);
    freq.put("ufh", 5);
    freq.put("ufi", 18);
    freq.put("ufa", 69);
    freq.put("Bor", 18);
    freq.put("Bos", 3);
    freq.put("oew", 3);
    freq.put("Bou", 4);
    freq.put("O", 312);
    freq.put("oet", 24);
    freq.put("Bol", 8);
    freq.put("oen", 3);
    freq.put("Bon", 10);
    freq.put("oel", 20);
    freq.put("usc", 7);
    freq.put("Mac\u0307", 6);
    freq.put("\u03c2 ", 16);
    freq.put("a\u0308", 3);
    freq.put(" g\u0127", 738);
    freq.put("pe ", 13);
    freq.put("nsh", 3);
    freq.put("nsi", 91);
    freq.put("nsj", 3);
    freq.put("nsk", 6);
    freq.put("nsl", 4);
    freq.put("nso", 12);
    freq.put("nsa", 97);
    freq.put("nse", 35);
    freq.put("Fl ", 27);
    freq.put("nst", 25);
    freq.put("nsu", 13);
    freq.put("bic\u0307", 18);
    freq.put("Dic\u0307", 42);
    freq.put("mki", 54);
    freq.put("ust", 30);
    freq.put("uss", 48);
    freq.put("ns ", 50);
    freq.put("Fli", 7);
    freq.put("biz\u0307", 12);
    freq.put("Flo", 14);
    freq.put("rg\u0127", 23);
    freq.put("lyd", 18);
    freq.put("lym", 3);
    freq.put(" gv", 20);
    freq.put(" gw", 17);
    freq.put("Mas", 7);
    freq.put("Mar", 145);
    freq.put(" gr", 140);
    freq.put("Mat", 18);
    freq.put("az\u0307", 177);
    freq.put("Maa", 4);
    freq.put(" gg", 3);
    freq.put("Mac", 57);
    freq.put(" ge", 25);
    freq.put("Mad", 20);
    freq.put("Mag", 23);
    freq.put(" ga", 16);
    freq.put("Mai", 3);
    freq.put(" go", 22);
    freq.put("Mak", 3);
    freq.put("Maj", 8);
    freq.put("Mam", 173);
    freq.put("Mal", 368);
    freq.put(" gh", 11);
    freq.put("Man", 64);
    freq.put("Boz\u0307", 4);
    freq.put("oez\u0307", 13);
    freq.put("ly ", 8);
    freq.put("pec\u0307", 256);
    freq.put("mik", 61);
    freq.put("Ma ", 3);
    freq.put(" b", 2002);
    freq.put(" c", 43);
    freq.put(" ca", 9);
    freq.put(" f", 4102);
    freq.put(" g", 1065);
    freq.put(" d", 1177);
    freq.put(" e", 986);
    freq.put(" j", 1439);
    freq.put(" k", 2332);
    freq.put(" h", 1657);
    freq.put(" i", 3361);
    freq.put(" n", 517);
    freq.put(" o", 826);
    freq.put(" l", 3640);
    freq.put(" m", 3448);
    freq.put(" r", 647);
    freq.put(" s", 2074);
    freq.put(" p", 1462);
    freq.put(" q", 354);
    freq.put(" v", 157);
    freq.put(" w", 522);
    freq.put(" t", 6419);
    freq.put(" u", 2017);
    freq.put(" z", 14);
    freq.put(" x", 379);
    freq.put(" y", 4);
    freq.put(" B", 508);
    freq.put(" C", 372);
    freq.put(" A", 979);
    freq.put(" F", 714);
    freq.put(" G", 502);
    freq.put(" D", 684);
    freq.put(" E", 575);
    freq.put(" J", 183);
    freq.put(" K", 556);
    freq.put(" H", 262);
    freq.put(" I", 1284);
    freq.put(" N", 343);
    freq.put(" O", 312);
    freq.put(" L", 1004);
    freq.put(" M", 1502);
    freq.put(" R", 417);
    freq.put(" S", 863);
    freq.put(" P", 874);
    freq.put(" Q", 64);
    freq.put(" V", 188);
    freq.put(" W", 149);
    freq.put(" T", 678);
    freq.put(" U", 188);
    freq.put(" Z", 23);
    freq.put(" X", 115);
    freq.put(" Y", 22);
    freq.put("vla", 3);
    freq.put("Azz", 3);
    freq.put("z\u0307or", 8);
    freq.put("z\u0307od", 3);
    freq.put("u\u0302", 4);
    freq.put("z\u0307on", 12);
    freq.put("z\u0307oo", 6);
    freq.put("z\u0307ol", 6);
    freq.put("z\u0307om", 4);
    freq.put("c\u0307ik", 5);
    freq.put(" A\u0301", 3);
    freq.put("Ory", 22);
    freq.put("Ort", 4);
    freq.put(" E\u0301", 3);
    freq.put(" O\u0301", 3);
    freq.put("Ori", 3);
    freq.put("Org", 3);
    freq.put("Ord", 15);
    freq.put("oci", 10);
    freq.put("ora", 57);
    freq.put("ock", 11);
    freq.put(" o", 3);
    freq.put("g\u0307t ", 3);
    freq.put("rez\u0307", 104);
    freq.put("c\u0307if", 11);
    freq.put("bu\u0300 ", 26);
    freq.put(" Do", 26);
    freq.put(" Dm", 3);
    freq.put("Ver", 14);
    freq.put(" Dj", 3);
    freq.put(" Di", 313);
    freq.put("oce", 8);
    freq.put(" De", 63);
    freq.put(" Da", 169);
    freq.put("ii ", 7);
    freq.put("ta\u0300 ", 137);
    freq.put("Ven", 20);
    freq.put(" Z\u0307", 84);
    freq.put(" Du", 83);
    freq.put(" Dr", 9);
    freq.put(" z\u0307", 271);
    freq.put("cha", 22);
    freq.put("Fr", 193);
    freq.put("che", 51);
    freq.put("chi", 43);
    freq.put("afa\u0300", 3);
    freq.put("chn", 4);
    freq.put("cho", 86);
    freq.put("Fa", 34);
    freq.put("chr", 7);
    freq.put("cht", 11);
    freq.put("chu", 12);
    freq.put("chy", 21);
    freq.put("Fj", 5);
    freq.put("Fl", 50);
    freq.put("Fn", 6);
    freq.put("Fo", 74);
    freq.put(" G\u0307", 316);
    freq.put(" g\u0307", 793);
    freq.put(" \u0126", 95);
    freq.put(" \u0127", 563);
    freq.put(" D ", 5);
    freq.put("iid", 27);
    freq.put("iin", 19);
    freq.put("ch ", 29);
    freq.put("f", 6973);
    freq.put(" C\u0307", 64);
    freq.put(" c\u0307", 142);
    freq.put("oct", 3);
    freq.put("F ", 39);
    freq.put("aci", 17);
    freq.put("wz\u0307i", 5);
    freq.put("afn", 110);
    freq.put("afi", 30);
    freq.put("Yo", 13);
    freq.put("Ya", 5);
    freq.put("wz\u0307a", 24);
    freq.put("aff", 33);
    freq.put("afa", 10);
    freq.put("wg\u0307 ", 60);
    freq.put("afu", 9);
    freq.put("QK ", 8);
    freq.put("Im\u0127", 5);
    freq.put("\u05e8", 4);
    freq.put("af ", 22);
    freq.put("wg\u0307a", 3);
    freq.put("wg\u0307t", 3);
    freq.put("da ", 369);
    freq.put("qra", 4);
    freq.put("og\u0127", 153);
    freq.put("lf", 85);
    freq.put("lg", 25);
    freq.put("ld", 68);
    freq.put("le", 821);
    freq.put("lb", 48);
    freq.put("lc", 10);
    freq.put("la", 2485);
    freq.put("lo", 552);
    freq.put("ll", 1651);
    freq.put("lm", 187);
    freq.put("\u0432\u0438", 3);
    freq.put("lk", 77);
    freq.put("lh", 113);
    freq.put("li", 3742);
    freq.put("lv", 55);
    freq.put("lw", 14);
    freq.put("lt", 645);
    freq.put("lu", 541);
    freq.put("ls", 64);
    freq.put("lp", 145);
    freq.put("qri", 51);
    freq.put("lz", 10);
    freq.put("lx", 4);
    freq.put("ly", 34);
    freq.put("dad", 3);
    freq.put("dae", 256);
    freq.put("daf", 4);
    freq.put("dac", 6);
    freq.put("dal", 29);
    freq.put("dam", 17);
    freq.put("dan", 134);
    freq.put("dah", 3);
    freq.put("dai", 3);
    freq.put("dak", 27);
    freq.put("dat", 62);
    freq.put("daw", 86);
    freq.put("\u05d5", 5);
    freq.put("daq", 44);
    freq.put("dar", 115);
    freq.put("das", 6);
    freq.put("daz", 7);
    freq.put("qof", 21);
    freq.put("l ", 9522);
    freq.put("ts ", 17);
    freq.put("lfg", 3);
    freq.put("lfa", 13);
    freq.put("lfo", 7);
    freq.put("lfi", 36);
    freq.put("lfu", 3);
    freq.put("qu ", 25);
    freq.put("Oc\u0307e", 19);
    freq.put("lfr", 6);
    freq.put("rez", 9);
    freq.put("rex", 11);
    freq.put("rey", 4);
    freq.put("la\u0301", 3);
    freq.put("rer", 21);
    freq.put("res", 127);
    freq.put("rep", 7);
    freq.put("rev", 6);
    freq.put("rew", 5);
    freq.put("ret", 84);
    freq.put("reu", 5);
    freq.put("rej", 10);
    freq.put("rek", 28);
    freq.put("rei", 3);
    freq.put("ren", 141);
    freq.put("miz\u0307", 24);
    freq.put("rel", 110);
    freq.put("rem", 62);
    freq.put("reb", 63);
    freq.put("rec", 12);
    freq.put("Tub", 5);
    freq.put("rea", 46);
    freq.put("ref", 38);
    freq.put("reg", 49);
    freq.put("red", 22);
    freq.put("ree", 9);
    freq.put("mic\u0307", 12);
    freq.put("lf ", 16);
    freq.put("que", 14);
    freq.put("qud", 16);
    freq.put("qui", 5);
    freq.put("bwi", 4);
    freq.put("mig\u0307", 13);
    freq.put("uha", 9);
    freq.put("re ", 51);
    freq.put("Pac\u0307", 7);
    freq.put("da\u0127", 9);
    freq.put("ud ", 49);
    freq.put("udu", 9);
    freq.put("ogu", 11);
    freq.put("lc\u0307", 4);
    freq.put("ogr", 36);
    freq.put("ogl", 10);
    freq.put("ogo", 3);
    freq.put("uda", 25);
    freq.put("ogi", 3);
    freq.put("ogh", 3);
    freq.put("udd", 10);
    freq.put("ude", 11);
    freq.put("udj", 45);
    freq.put("ogg", 4);
    freq.put("udi", 48);
    freq.put("oga", 14);
    freq.put("udo", 6);
    freq.put("l\u0127", 7);
    freq.put("lg\u0307", 18);
    freq.put("\u0631\u0627", 5);
    freq.put("Pap", 40);
    freq.put("Par", 93);
    freq.put("Pat", 20);
    freq.put("Pau", 51);
    freq.put("Paw", 13);
    freq.put("Pab", 3);
    freq.put("nqa", 38);
    freq.put("Pad", 7);
    freq.put("Pae", 3);
    freq.put("Pag", 7);
    freq.put("Paj", 12);
    freq.put("Pak", 3);
    freq.put("Pal", 52);
    freq.put("Pan", 35);
    freq.put("Pao", 5);
    freq.put(" G\u0307a", 15);
    freq.put("mij", 78);
    freq.put(" G\u0307g", 5);
    freq.put("mil", 984);
    freq.put(" G\u0307e", 112);
    freq.put("min", 529);
    freq.put("mia", 3);
    freq.put(" G\u0307i", 13);
    freq.put("mib", 19);
    freq.put("mie", 177);
    freq.put("mid", 24);
    freq.put("mig", 4);
    freq.put("mif", 430);
    freq.put("mix", 8);
    freq.put(" G\u0307w", 22);
    freq.put(" G\u0307u", 107);
    freq.put("mis", 92);
    freq.put("mir", 31);
    freq.put("mit", 88);
    freq.put("sfu", 18);
    freq.put("rec\u0307", 21);
    freq.put("sfi", 3);
    freq.put("sfe", 70);
    freq.put(" \u03bc", 3);
    freq.put("mi ", 197);
    freq.put(" \u0391", 3);
    freq.put("reg\u0307", 41);
    freq.put(" \u039c", 4);
    freq.put(" iS", 6);
    freq.put("Z\u0307ab", 4);
    freq.put("Z\u0307am", 3);
    freq.put(" ix", 37);
    freq.put("Moz", 4);
    freq.put("ksw", 4);
    freq.put("G\u0307eo", 4);
    freq.put("Mos", 13);
    freq.put(" iq", 7);
    freq.put(" ir", 124);
    freq.put(" is", 573);
    freq.put(" it", 176);
    freq.put(" iv", 3);
    freq.put("kse", 3);
    freq.put(" ij", 6);
    freq.put(" ik", 209);
    freq.put(" il", 1113);
    freq.put(" im", 202);
    freq.put(" in", 540);
    freq.put("Mol", 6);
    freq.put(" ib", 29);
    freq.put("ksi", 3);
    freq.put(" ie", 45);
    freq.put(" if", 12);
    freq.put("Mod", 3);
    freq.put(" \u0421", 3);
    freq.put("ks ", 10);
    freq.put("wg", 6);
    freq.put("wo", 33);
    freq.put("z\u0307i ", 134);
    freq.put(" Ir", 80);
    freq.put("wl", 65);
    freq.put("wk", 108);
    freq.put("S", 870);
    freq.put("z\u0307it", 29);
    freq.put("z\u0307iv", 9);
    freq.put("z\u0307ir", 38);
    freq.put("z\u0307is", 26);
    freq.put("e\u0300", 20);
    freq.put("z\u0307iz", 32);
    freq.put("z\u0307id", 3);
    freq.put("wt", 57);
    freq.put("z\u0307ib", 7);
    freq.put("z\u0307il", 17);
    freq.put("ws", 63);
    freq.put("z\u0307in", 12);
    freq.put("z\u0307ij", 20);
    freq.put("wr", 157);
    freq.put("niz\u0307", 130);
    freq.put("ohn", 12);
    freq.put("BU ", 6);
    freq.put("uid", 6);
    freq.put(" iz\u0307", 84);
    freq.put("ys ", 19);
    freq.put("Hon", 3);
    freq.put(" If", 3);
    freq.put("ak", 518);
    freq.put("OL ", 4);
    freq.put("Hom", 4);
    freq.put("cop", 6);
    freq.put("oha", 18);
    freq.put("cor", 5);
    freq.put("an", 2847);
    freq.put("yso", 3);
    freq.put("uis", 8);
    freq.put("\u0631 ", 5);
    freq.put(" ig\u0307", 5);
    freq.put(" i\u0127", 6);
    freq.put(" Fr", 192);
    freq.put(" Fu", 71);
    freq.put(" Fa", 34);
    freq.put(" Fe", 98);
    freq.put(" Fi", 117);
    freq.put(" Fj", 5);
    freq.put(" Fl", 50);
    freq.put(" Fo", 74);
    freq.put("io ", 36);
    freq.put("cob", 5);
    freq.put("wy ", 3);
    freq.put(" \u05de", 4);
    freq.put("iov", 9);
    freq.put("iot", 7);
    freq.put("ios", 10);
    freq.put("ior", 13);
    freq.put("ion", 134);
    freq.put("iom", 6);
    freq.put("iol", 5);
    freq.put("ioi", 5);
    freq.put("iod", 3);
    freq.put("ioc", 3);
    freq.put("\u0127ti", 24);
    freq.put(" id", 134);
    freq.put("Cam", 10);
    freq.put("bug\u0307", 13);
    freq.put("adw", 61);
    freq.put("adu", 21);
    freq.put("c\u0327oi", 5);
    freq.put(" \u0645", 8);
    freq.put("esu\u0300", 19);
    freq.put("kwi", 24);
    freq.put("add", 104);
    freq.put("ade", 42);
    freq.put("adc", 7);
    freq.put("g\u0127z\u0307", 8);
    freq.put("ado", 28);
    freq.put("adm", 5);
    freq.put("adj", 20);
    freq.put("adh", 9);
    freq.put("adi", 68);
    freq.put("u\u0302r", 3);
    freq.put("Hyd", 3);
    freq.put(" \u0627", 13);
    freq.put(" \u0628", 4);
    freq.put(" \u062c", 3);
    freq.put("Hyr", 5);
    freq.put("\u0632\u064a", 3);
    freq.put("xx ", 8);
    freq.put("ad ", 169);
    freq.put("Z\u0307ej", 3);
    freq.put("nja", 294);
    freq.put("nje", 5);
    freq.put("nji", 38);
    freq.put("njo", 76);
    freq.put("g\u0307g\u0307i", 22);
    freq.put("piz\u0307", 3);
    freq.put("nju", 138);
    freq.put("esu", 6);
    freq.put("est", 511);
    freq.put("ess", 193);
    freq.put("tmu", 6);
    freq.put("esp", 42);
    freq.put("esg", 4);
    freq.put("tma", 4);
    freq.put("ese", 10);
    freq.put("lta\u0300", 14);
    freq.put("esc", 16);
    freq.put("tme", 10);
    freq.put("esa", 8);
    freq.put("eso", 23);
    freq.put("tmi", 35);
    freq.put("esk", 25);
    freq.put("esi", 45);
    freq.put("esh", 4);
    freq.put("dca", 6);
    freq.put("go ", 26);
    freq.put("Het", 3);
    freq.put("es ", 234);
    freq.put("\u4e09 ", 3);
    freq.put("Twa", 3);
    freq.put("Twi", 4);
    freq.put("\u03b9\u0301", 6);
    freq.put("De ", 5);
    freq.put("bu ", 92);
    freq.put("rct", 3);
    freq.put("rcu", 40);
    freq.put("rco", 8);
    freq.put("rch", 21);
    freq.put("rci", 5);
    freq.put("rck", 5);
    freq.put("rce", 5);
    freq.put("rca", 3);
    freq.put("buz", 7);
    freq.put("Dep", 7);
    freq.put("Der", 12);
    freq.put("Des", 3);
    freq.put("but", 33);
    freq.put("Deh", 5);
    freq.put("Del", 4);
    freq.put("Dem", 8);
    freq.put("Den", 7);
    freq.put("bum", 5);
    freq.put("bub", 5);
    freq.put("Dea", 4);
    freq.put("j", 8487);
    freq.put("a\u0127r", 13);
    freq.put("rc ", 3);
    freq.put("pij", 7);
    freq.put("pik", 52);
    freq.put("pil", 12);
    freq.put("pim", 17);
    freq.put("pin", 20);
    freq.put("pio", 4);
    freq.put("pic", 4);
    freq.put("pid", 7);
    freq.put("pie", 9);
    freq.put("pig", 5);
    freq.put("ub ", 21);
    freq.put("pir", 15);
    freq.put("pis", 13);
    freq.put("pit", 105);
    freq.put("oad", 9);
    freq.put("oac", 3);
    freq.put("oan", 4);
    freq.put("oam", 11);
    freq.put("oat", 8);
    freq.put("oar", 4);
    freq.put("oaz", 8);
    freq.put("\u02be", 3);
    freq.put("ubu", 9);
    freq.put("ubr", 46);
    freq.put("Acd", 9);
    freq.put("pi ", 31);
    freq.put("ube", 45);
    freq.put("uba", 26);
    freq.put("ubb", 79);
    freq.put("ubl", 13);
    freq.put("ubo", 5);
    freq.put("ubi", 11);
    freq.put("z\u0307ve", 7);
    freq.put("z\u0307vi", 25);
    freq.put("nwe", 12);
    freq.put("nwa", 10);
    freq.put("m\u0127", 12);
    freq.put("mg\u0307", 7);
    freq.put("mwa", 8);
    freq.put("mwe", 22);
    freq.put("G ", 5);
    freq.put("mwi", 27);
    freq.put("mwo", 3);
    freq.put("\u0644", 22);
    freq.put("\u05d9", 6);
    freq.put("Gw", 24);
    freq.put("Gv", 9);
    freq.put("Gu", 24);
    freq.put("\u0127ru", 240);
    freq.put("Gr", 182);
    freq.put("Gz\u0307i", 8);
    freq.put("Ge", 23);
    freq.put("\u0127re", 5);
    freq.put("Ga", 51);
    freq.put("\u0127ra", 189);
    freq.put("Go", 18);
    freq.put("\u0127ro", 5);
    freq.put("Gl", 8);
    freq.put("Gi", 29);
    freq.put("\u0127ri", 9);
    freq.put(" kb", 53);
    freq.put(" ka", 298);
    freq.put(" ke", 108);
    freq.put(" kk", 21);
    freq.put("ken", 10);
    freq.put(" ki", 800);
    freq.put(" kn", 8);
    freq.put(" ko", 486);
    freq.put(" kl", 280);
    freq.put(" km", 18);
    freq.put(" kr", 11);
    freq.put("awz\u0307", 9);
    freq.put(" kw", 70);
    freq.put(" kt", 21);
    freq.put(" ku", 153);
    freq.put("n", 16230);
    freq.put("ag\u0307e", 12);
    freq.put("ag\u0307a", 5);
    freq.put("kuz", 6);
    freq.put("ag\u0307n", 9);
    freq.put("ag\u0307i", 18);
    freq.put("kur", 32);
    freq.put("kup", 10);
    freq.put("ag\u0307u", 54);
    freq.put("kun", 113);
    freq.put("kum", 38);
    freq.put("kul", 144);
    freq.put("viz\u0307", 55);
    freq.put("G\u0307ga", 5);
    freq.put("\u03c2", 16);
    freq.put("tiu", 3);
    freq.put("eng\u0307", 20);
    freq.put("Zi", 3);
    freq.put("Ze", 9);
    freq.put("ty", 24);
    freq.put("Za", 7);
    freq.put("wdx", 7);
    freq.put("ku ", 256);
    freq.put("uz\u0307e\u0300", 6);
    freq.put("\u0127uh", 5);
    freq.put("Kom", 18);
    freq.put("Kol", 7);
    freq.put("Kon", 23);
    freq.put("Kos", 7);
    freq.put("tq", 22);
    freq.put("m ", 1083);
    freq.put("ene\u0301", 3);
    freq.put("\u03b9\u03c3", 3);
    freq.put("G\u0127", 113);
    freq.put("ti", 3730);
    freq.put("\u03b9\u03ba", 4);
    freq.put("me", 1150);
    freq.put("md", 4);
    freq.put("mg", 17);
    freq.put("mf", 9);
    freq.put("ma", 2739);
    freq.put("g", 4065);
    freq.put("mb", 291);
    freq.put("mm", 927);
    freq.put("ml", 36);
    freq.put("mo", 483);
    freq.put("Gz\u0307", 13);
    freq.put("mi", 2785);
    freq.put("mh", 91);
    freq.put("mk", 57);
    freq.put("mj", 15);
    freq.put("mu", 380);
    freq.put("mt", 6);
    freq.put("mw", 60);
    freq.put("mq", 22);
    freq.put("mp", 379);
    freq.put("ms", 68);
    freq.put("mr", 57);
    freq.put("my", 33);
    freq.put("mx", 38);
    freq.put("uz\u0307j", 5);
    freq.put("uz\u0307i", 58);
    freq.put("uz\u0307a", 85);
    freq.put("uz\u0307e", 10);
    freq.put("uz\u0307u", 7);
    freq.put("ena", 164);
    freq.put("enb", 43);
    freq.put("enc", 6);
    freq.put("end", 123);
    freq.put("ene", 647);
    freq.put("eng", 8);
    freq.put("eni", 182);
    freq.put("enj", 65);
    freq.put("enk", 3);
    freq.put("enl", 3);
    freq.put("enn", 28);
    freq.put("eno", 38);
    freq.put("ens", 59);
    freq.put("ent", 1191);
    freq.put("enu", 103);
    freq.put("enz", 139);
    freq.put("uz\u0307 ", 30);
    freq.put("II ", 42);
    freq.put("en ", 742);
    freq.put("ag\u0307g\u0307", 33);
    freq.put(" Hy", 11);
    freq.put(" Hr", 3);
    freq.put(" Hu", 96);
    freq.put(" Hi", 40);
    freq.put(" Ho", 22);
    freq.put(" Ha", 50);
    freq.put(" He", 37);
    freq.put("ima", 78);
    freq.put("imb", 13);
    freq.put("ime", 93);
    freq.put("img", 3);
    freq.put("imf", 3);
    freq.put("imi", 110);
    freq.put("imh", 8);
    freq.put("imk", 55);
    freq.put("imm", 55);
    freq.put("iml", 5);
    freq.put("imo", 84);
    freq.put("imn", 4);
    freq.put("imq", 8);
    freq.put("imp", 76);
    freq.put("ims", 27);
    freq.put("imu", 13);
    freq.put("imw", 45);
    freq.put("imx", 8);
    freq.put("im ", 118);
    freq.put("tog\u0307", 41);
    freq.put("\u064a ", 5);
    freq.put("to\u0127", 3);
    freq.put(" z\u0307b", 4);
    freq.put("nin", 93);
    freq.put("raz\u0307", 15);
    freq.put("\u03c4", 14);
    freq.put("gom", 131);
    freq.put("gol", 67);
    freq.put("gon", 55);
    freq.put("goi", 6);
    freq.put("ajr", 23);
    freq.put("ajs", 5);
    freq.put("ajt", 11);
    freq.put("aji", 45);
    freq.put("ajj", 306);
    freq.put("SI ", 4);
    freq.put("ajl", 13);
    freq.put("ajn", 47);
    freq.put("goz", 8);
    freq.put("aja", 18);
    freq.put("gow", 18);
    freq.put("gov", 12);
    freq.put("ajd", 7);
    freq.put("gos", 11);
    freq.put("gor", 43);
    freq.put("ra\u0127", 30);
    freq.put("rag\u0307", 14);
    freq.put("\u03b9 ", 3);
    freq.put("ied", 122);
    freq.put("W", 151);
    freq.put("Vic", 10);
    freq.put("Vie", 4);
    freq.put("Vin", 8);
    freq.put("i\u0300", 10);
    freq.put("Vil", 6);
    freq.put("Vir", 4);
    freq.put("Vit", 5);
    freq.put("aj ", 17);
    freq.put("be ", 5);
    freq.put("nhe", 8);
    freq.put("rac\u0327", 5);
    freq.put("nha", 67);
    freq.put("nho", 18);
    freq.put("nhi", 3);
    freq.put("nhu", 17);
    freq.put("tor", 194);
    freq.put("tos", 21);
    freq.put("tov", 4);
    freq.put("tow", 3);
    freq.put("tot", 21);
    freq.put("tok", 161);
    freq.put("eqj", 34);
    freq.put("ton", 115);
    freq.put("too", 9);
    freq.put("tol", 107);
    freq.put("tom", 22);
    freq.put("eqa", 4);
    freq.put("toc", 3);
    freq.put("tof", 97);
    freq.put("eqd", 10);
    freq.put("tod", 24);
    freq.put("eqf", 4);
    freq.put("Fut", 33);
    freq.put("Fur", 3);
    freq.put("nh ", 8);
    freq.put("Fuq", 23);
    freq.put("Fun", 8);
    freq.put("img\u0307", 3);
    freq.put("im\u0127", 3);
    freq.put("eq ", 5);
    freq.put("to ", 42);
    freq.put("thu", 15);
    freq.put("raf", 35);
    freq.put("rag", 10);
    freq.put("rad", 59);
    freq.put("rae", 14);
    freq.put("rab", 60);
    freq.put("rac", 40);
    freq.put("ran", 221);
    freq.put("Vic\u0307", 4);
    freq.put("ral", 185);
    freq.put("ram", 87);
    freq.put("raj", 37);
    freq.put("rak", 173);
    freq.put("rah", 4);
    freq.put("rai", 7);
    freq.put("lba", 17);
    freq.put("raw", 54);
    freq.put("rat", 218);
    freq.put("rar", 88);
    freq.put("ras", 37);
    freq.put("rap", 83);
    freq.put("raq", 12);
    freq.put("lbi", 4);
    freq.put("raz", 78);
    freq.put("rax", 9);
    freq.put("It ", 75);
    freq.put("Syl", 25);
    freq.put("goz\u0307", 6);
    freq.put("thi", 5);
    freq.put("ra ", 843);
    freq.put("lb ", 13);
    freq.put("Ita", 50);
    freq.put("e\u0301r", 24);
    freq.put("\u064a\u0644", 5);
    freq.put("e\u0301e", 3);
    freq.put("e\u0301d", 4);
    freq.put("Bin", 6);
    freq.put("Bil", 14);
    freq.put("oco", 3);
    freq.put("oca", 9);
    freq.put("occ", 7);
    freq.put("Bie", 3);
    freq.put("Bib", 11);
    freq.put("abr", 25);
    freq.put("ocy", 13);
    freq.put("Bir", 10);
    freq.put("Bis", 4);
    freq.put("\u0440", 10);
    freq.put(" m\u0127", 4);
    freq.put("Aar", 3);
    freq.put("e\u0301 ", 13);
    freq.put("a\u0127\u0127", 67);
    freq.put("o\u0300 ", 5);
    freq.put("bea", 4);
    freq.put("nux", 3);
    freq.put("Pet", 8);
    freq.put("nut", 19);
    freq.put("nur", 25);
    freq.put("nus", 39);
    freq.put("Per", 18);
    freq.put("nuq", 3);
    freq.put("nun", 16);
    freq.put("Pen", 12);
    freq.put("num", 42);
    freq.put("nuk", 4);
    freq.put("nuh", 4);
    freq.put("nue", 6);
    freq.put("nub", 4);
    freq.put("mut", 12);
    freq.put("mus", 15);
    freq.put("mur", 16);
    freq.put("Uff", 4);
    freq.put("mud", 5);
    freq.put("mum", 4);
    freq.put("mul", 33);
    freq.put("mun", 120);
    freq.put("nu ", 196);
    freq.put("bew", 5);
    freq.put("mu ", 119);
    freq.put("kwa", 98);
    freq.put(" me", 269);
    freq.put(" mf", 3);
    freq.put(" mg", 11);
    freq.put("kwe", 13);
    freq.put(" ma", 1507);
    freq.put(" ml", 4);
    freq.put(" mm", 21);
    freq.put(" mn", 9);
    freq.put(" mo", 138);
    freq.put(" mh", 59);
    freq.put(" mi", 1264);
    freq.put("kwo", 7);
    freq.put(" mu", 78);
    freq.put(" mw", 10);
    freq.put(" mp", 5);
    freq.put(" mq", 10);
    freq.put(" ms", 19);
    freq.put("Z\u0307eb", 13);
    freq.put("a\u0127n", 3);
    freq.put("a\u0127m", 14);
    freq.put("a\u0127l", 9);
    freq.put("a\u0127k", 5);
    freq.put("a\u0127j", 29);
    freq.put("a\u0127d", 96);
    freq.put("a\u0127b", 8);
    freq.put("a\u0127a", 143);
    freq.put("Biz\u0307", 4);
    freq.put("waz\u0307", 9);
    freq.put("G\u0307il", 6);
    freq.put("a\u0127t", 59);
    freq.put("a\u0127s", 11);
    freq.put("G\u0307ie", 3);
    freq.put("a\u0127q", 3);
    freq.put(" m ", 25);
    freq.put("xxu", 7);
    freq.put("Cry", 6);
    freq.put("xxa", 17);
    freq.put("xxe", 34);
    freq.put("Cre", 3);
    freq.put("xxi", 74);
    freq.put("Cro", 4);
    freq.put("a\u0127 ", 77);
    freq.put("nuz\u0307", 5);
    freq.put("muz\u0307", 50);
    freq.put("\u062d", 6);
    freq.put("vvj", 3);
    freq.put("vvi", 3);
    freq.put("vve", 16);
    freq.put("vva", 3);
    freq.put("i\u0304 ", 3);
    freq.put(" g\u0307o", 16);
    freq.put("Xag", 4);
    freq.put("elj", 5);
    freq.put("eli", 133);
    freq.put("elo", 15);
    freq.put("ell", 197);
    freq.put("elm", 50);
    freq.put("elb", 5);
    freq.put("elc", 4);
    freq.put("ela", 159);
    freq.put("elf", 57);
    freq.put("elg", 3);
    freq.put("eld", 24);
    freq.put("ele", 200);
    freq.put("lch", 3);
    freq.put("els", 16);
    freq.put("elp", 131);
    freq.put("elw", 4);
    freq.put("elt", 131);
    freq.put("elu", 17);
    freq.put("D", 687);
    freq.put("vil", 87);
    freq.put("el ", 431);
    freq.put("ywo", 3);
    freq.put(" Ju", 36);
    freq.put(" Jo", 42);
    freq.put(" Ji", 13);
    freq.put(" Je", 18);
    freq.put(" Ja", 67);
    freq.put("ick", 14);
    freq.put("ici", 13);
    freq.put("Hy", 11);
    freq.put("ico", 23);
    freq.put("Hr", 3);
    freq.put("ica", 31);
    freq.put("ice", 13);
    freq.put("Hu", 96);
    freq.put("Hi", 40);
    freq.put("nz\u0307", 19);
    freq.put("Ho", 22);
    freq.put("icr", 23);
    freq.put("Ha", 50);
    freq.put("icu", 9);
    freq.put("He", 37);
    freq.put("nc\u0307", 114);
    freq.put("tic\u0307", 45);
    freq.put("ng\u0307", 66);
    freq.put("ic ", 14);
    freq.put("\u064a\u0644 ", 3);
    freq.put("n\u0127", 43);
    freq.put("tig\u0307", 30);
    freq.put("ppa", 41);
    freq.put("aha", 30);
    freq.put("ppe", 19);
    freq.put("ppj", 5);
    freq.put("ppi", 22);
    freq.put("ppo", 31);
    freq.put("aho", 4);
    freq.put("ppl", 19);
    freq.put("ppr", 100);
    freq.put("ppu", 18);
    freq.put("ne\u0301", 5);
    freq.put("git", 3);
    freq.put("gis", 4);
    freq.put("nc\u0327", 7);
    freq.put("gie", 7);
    freq.put("gid", 29);
    freq.put("gia", 11);
    freq.put("gio", 11);
    freq.put("gin", 28);
    freq.put("gil", 21);
    freq.put("ah ", 10);
    freq.put("pp ", 104);
    freq.put("a\u0301n ", 4);
    freq.put("Vol", 3);
    freq.put("elg\u0307", 11);
    freq.put("c\u0307am", 3);
    freq.put("c\u0307ar", 5);
    freq.put("c\u0307aw", 8);
    freq.put("gi ", 29);
    freq.put("urn", 52);
    freq.put("nno", 8);
    freq.put("nni", 60);
    freq.put("nnh", 21);
    freq.put("nne", 16);
    freq.put("nnb", 6);
    freq.put("nna", 90);
    freq.put("nnw", 6);
    freq.put("nnu", 20);
    freq.put("sq ", 3);
    freq.put("nh", 121);
    freq.put("ni", 2697);
    freq.put("nj", 551);
    freq.put("nk", 116);
    freq.put("nl", 16);
    freq.put("nm", 3);
    freq.put("nn", 558);
    freq.put("no", 348);
    freq.put("tit", 149);
    freq.put("na", 1745);
    freq.put("nb", 69);
    freq.put("nc", 94);
    freq.put("nd", 740);
    freq.put("ne", 1057);
    freq.put("nf", 270);
    freq.put("ng", 502);
    freq.put("nx", 7);
    freq.put("ny", 16);
    freq.put("nz", 300);
    freq.put("tio", 55);
    freq.put("tii", 7);
    freq.put("tij", 88);
    freq.put("tik", 344);
    freq.put("tid", 31);
    freq.put("nq", 41);
    freq.put("nr", 10);
    freq.put("ns", 342);
    freq.put("nt", 2411);
    freq.put("nu", 369);
    freq.put("nv", 38);
    freq.put("nw", 22);
    freq.put("tiz\u0307", 5);
    freq.put("z\u0307e\u0300 ", 6);
    freq.put("nn ", 327);
    freq.put("ich", 54);
    freq.put("sqo", 20);
    freq.put("n ", 3524);
    freq.put("urz", 3);
    freq.put("ti ", 1299);
    freq.put("roh", 10);
    freq.put("roi", 6);
    freq.put("m\u0127a", 11);
    freq.put("rok", 19);
    freq.put("rol", 91);
    freq.put("rom", 70);
    freq.put("ron", 73);
    freq.put("roo", 5);
    freq.put("lls", 6);
    freq.put("roa", 24);
    freq.put("rob", 29);
    freq.put("roc", 13);
    freq.put("rod", 49);
    freq.put("roe", 5);
    freq.put("llu", 73);
    freq.put("llt", 3);
    freq.put("roz", 5);
    freq.put("llh", 76);
    freq.put("llo", 33);
    freq.put("llm", 14);
    freq.put("rop", 218);
    freq.put("llb", 4);
    freq.put("lla", 127);
    freq.put("ros", 87);
    freq.put("rot", 59);
    freq.put("rou", 5);
    freq.put("rov", 96);
    freq.put("row", 4);
    freq.put("bqa", 12);
    freq.put("Dan", 116);
    freq.put("bqi", 5);
    freq.put("Daw", 29);
    freq.put("Dar", 5);
    freq.put("Das", 8);
    freq.put("Day", 5);
    freq.put("ro ", 41);
    freq.put("Cin", 3);
    freq.put("Cit", 3);
    freq.put("ll ", 1050);
    freq.put("kla", 618);
    freq.put("ict", 10);
    freq.put(" dd", 19);
    freq.put("jda", 5);
    freq.put("Rep", 54);
    freq.put("Ren", 22);
    freq.put("Reb", 3);
    freq.put("Rec", 4);
    freq.put("Rea", 6);
    freq.put("Ref", 4);
    freq.put("Reg", 7);
    freq.put("Red", 3);
    freq.put("b\u0127a", 397);
    freq.put("b\u0127e", 3);
    freq.put("Qua", 3);
    freq.put("b\u0127u", 7);
    freq.put("Agi", 3);
    freq.put(" o\u0127", 190);
    freq.put(" og\u0307", 13);
    freq.put("Re ", 4);
    freq.put("Ang\u0307", 4);
    freq.put(" oc\u0307", 8);
    freq.put("z\u0307ra", 9);
    freq.put("ð", 4);
    freq.put("ngt", 3);
    freq.put("g\u0307ab", 13);
    freq.put(" \u0126a", 62);
    freq.put(" \u0126e", 12);
    freq.put("msi", 10);
    freq.put("g\u0307ar", 17);
    freq.put(" \u0126i", 6);
    freq.put("mse", 41);
    freq.put(" \u0126o", 6);
    freq.put("Eva", 5);
    freq.put("nek", 47);
    freq.put("roc\u0307", 16);
    freq.put("g\u0307a ", 26);
    freq.put(" \u0126 ", 3);
    freq.put("ms ", 9);
    freq.put(" on", 8);
    freq.put("Mik", 15);
    freq.put(" om", 6);
    freq.put("Mim", 4);
    freq.put(" ok", 5);
    freq.put("Mio", 8);
    freq.put("Min", 60);
    freq.put(" of", 33);
    freq.put(" og", 19);
    freq.put("Mic", 38);
    freq.put(" ob", 5);
    freq.put("Mid", 3);
    freq.put("Mif", 7);
    freq.put("Mix", 3);
    freq.put("Miz", 5);
    freq.put("Mis", 9);
    freq.put("Mir", 5);
    freq.put(" or", 359);
    freq.put("\u039c", 4);
    freq.put(" op", 149);
    freq.put(" oq", 6);
    freq.put("s\u0301", 4);
    freq.put("Reg\u0307", 14);
    freq.put("de\u0301r", 4);
    freq.put("tba", 55);
    freq.put("gto", 3);
    freq.put("qq", 59);
    freq.put("\u0648", 9);
    freq.put("qr", 58);
    freq.put("sht", 3);
    freq.put("ryp", 6);
    freq.put("a\u0300 ", 146);
    freq.put("anz\u0307", 9);
    freq.put("Don", 8);
    freq.put("mim", 4);
    freq.put("ejl", 13);
    freq.put("ejn", 271);
    freq.put("ejo", 3);
    freq.put("eji", 5);
    freq.put("ejj", 233);
    freq.put("ejk", 5);
    freq.put("eje", 30);
    freq.put("ejg", 3);
    freq.put("eja", 12);
    freq.put("ejb", 3);
    freq.put("ic\u0307e", 69);
    freq.put("ejt", 13);
    freq.put("ic\u0307j", 39);
    freq.put("ic\u0307i", 201);
    freq.put("ejr", 7);
    freq.put("ang\u0307", 19);
    freq.put("\u03c6", 3);
    freq.put("Z\u0307on", 15);
    freq.put("c\u0307a ", 25);
    freq.put("\u025b", 3);
    freq.put("ej ", 68);
    freq.put("anc\u0307", 51);
    freq.put("ic\u0307 ", 44);
    freq.put("jwa", 7);
    freq.put("jwe", 3);
    freq.put("anc\u0327", 6);
    freq.put("hu ", 265);
    freq.put("\u0127\u0127 ", 17);
    freq.put("iam", 8);
    freq.put("ial", 6);
    freq.put("ian", 46);
    freq.put("\u20ac ", 8);
    freq.put("iae", 5);
    freq.put("iac", 3);
    freq.put("iaz", 3);
    freq.put("iat", 14);
    freq.put("iar", 5);
    freq.put("\u0127\u0127u", 3);
    freq.put("\u0127\u0127t", 5);
    freq.put("hua", 5);
    freq.put("hum", 170);
    freq.put("\u0127\u0127e", 5);
    freq.put("huw", 681);
    freq.put("\u0127\u0127a", 63);
    freq.put("hur", 20);
    freq.put("hus", 8);
    freq.put("hux", 45);
    freq.put("ia ", 743);
    freq.put("\u0646 ", 6);
    freq.put("r", 15492);
    freq.put("pre", 187);
    freq.put("ane", 39);
    freq.put("ang", 78);
    freq.put("pra", 13);
    freq.put("ana", 179);
    freq.put("anc", 36);
    freq.put("anl", 3);
    freq.put("anm", 3);
    freq.put("pro", 216);
    freq.put("ano", 26);
    freq.put("pri", 123);
    freq.put("ani", 420);
    freq.put("anj", 131);
    freq.put("prj", 10);
    freq.put("pru", 8);
    freq.put("anu", 46);
    freq.put("\u0442", 3);
    freq.put("anq", 8);
    freq.put("ans", 41);
    freq.put("anz", 110);
    freq.put(" L ", 261);
    freq.put("\u0435", 11);
    freq.put("an ", 732);
    freq.put("ic\u0307c\u0307", 58);
    freq.put(" Le", 203);
    freq.put(" Lb", 9);
    freq.put(" La", 209);
    freq.put(" Lo", 66);
    freq.put("ej\u0127", 30);
    freq.put("ejg\u0307", 6);
    freq.put(" Li", 133);
    freq.put(" Lh", 13);
    freq.put(" Lv", 23);
    freq.put(" Lu", 69);
    freq.put(" Ly", 6);
    freq.put("poz\u0307", 59);
    freq.put("tke", 15);
    freq.put("tka", 3);
    freq.put("tko", 8);
    freq.put("tki", 3);
    freq.put("nla", 13);
    freq.put("tku", 24);
    freq.put("dy ", 5);
    freq.put("ss ", 200);
    freq.put("\u0447 ", 3);
    freq.put("ssu", 269);
    freq.put("H", 262);
    freq.put("ssw", 6);
    freq.put("ssr", 8);
    freq.put("ssl", 6);
    freq.put("sso", 47);
    freq.put("ssi", 739);
    freq.put("ssj", 61);
    freq.put("sse", 143);
    freq.put("ssa", 84);
    freq.put("pog\u0307", 5);
    freq.put("rmu", 8);
    freq.put("Ic\u0307", 5);
    freq.put("rma", 204);
    freq.put("rme", 47);
    freq.put("eb ", 121);
    freq.put("rmi", 60);
    freq.put("rmo", 27);
    freq.put("rml", 5);
    freq.put("c\u0307at", 8);
    freq.put("rm ", 8);
    freq.put("Iz\u0307", 49);
    freq.put("og\u0307 ", 5);
    freq.put("pot", 9);
    freq.put("por", 172);
    freq.put("pos", 256);
    freq.put("pop", 69);
    freq.put("pon", 41);
    freq.put("poo", 3);
    freq.put("pol", 145);
    freq.put("pok", 3);
    freq.put("poe", 33);
    freq.put("Bur", 3);
    freq.put("Buh", 3);
    freq.put("Bun", 18);
    freq.put("Bul", 7);
    freq.put("Bud", 4);
    freq.put("po ", 4);
    freq.put("mqa", 22);
    freq.put("\u0127x ", 3);
    freq.put(" \u03b3\u03b5", 3);
    freq.put("okr", 22);
    freq.put("Bar", 24);
    freq.put("\u0438\u0301", 3);
    freq.put("g\u0307ga", 3);
    freq.put("\u0431", 4);
    freq.put("I ", 70);
    freq.put("\u0127xo", 10);
    freq.put("Etj", 4);
    freq.put("tix", 5);
    freq.put("Ix", 9);
    freq.put("tiz", 26);
    freq.put("Ip", 3);
    freq.put("Is", 156);
    freq.put("Ir", 80);
    freq.put("It", 125);
    freq.put("Ik", 4);
    freq.put("Im", 57);
    freq.put("Il", 488);
    freq.put("Io", 5);
    freq.put("In", 204);
    freq.put("Ib", 4);
    freq.put("Id", 27);
    freq.put("If", 3);
    freq.put(" qr", 51);
    freq.put(" qt", 5);
    freq.put(" qu", 11);
    freq.put("tip", 38);
    freq.put(" qa", 157);
    freq.put(" qe", 29);
    freq.put(" qi", 64);
    freq.put("tis", 118);
    freq.put("Bal", 10);
    freq.put(" qo", 24);
    freq.put("til", 45);
    freq.put("Bam", 6);
    freq.put("tim", 140);
    freq.put("tin", 616);
    freq.put("ot ", 25);
    freq.put("uc\u0307c\u0307", 30);
    freq.put("\u0127as", 24);
    freq.put("Lol", 3);
    freq.put("tie", 262);
    freq.put("tif", 121);
    freq.put("juz\u0307", 38);
    freq.put("Pij", 8);
    freq.put("Pik", 21);
    freq.put("Pin", 6);
    freq.put("\u0127an", 138);
    freq.put("Pia", 3);
    freq.put("Pic", 6);
    freq.put("Pie", 19);
    freq.put("tia", 13);
    freq.put("tib", 16);
    freq.put("\u0127ak", 5);
    freq.put("Pis", 3);
    freq.put("Pit", 3);
    freq.put("oz\u0307n", 4);
    freq.put("\u0127aj", 215);
    freq.put("Kur", 10);
    freq.put("Kum", 9);
    freq.put("Kul", 7);
    freq.put("Kub", 7);
    freq.put("gve", 22);
    freq.put("C\u0307in", 24);
    freq.put("C\u0307il", 4);
    freq.put("C\u0307ip", 6);
    freq.put("bbj", 10);
    freq.put("oo", 73);
    freq.put("on", 2254);
    freq.put("om", 816);
    freq.put("ol", 1487);
    freq.put("ok", 324);
    freq.put("oj", 38);
    freq.put("oi", 77);
    freq.put("oh", 52);
    freq.put("og", 242);
    freq.put("of", 280);
    freq.put("oe", 73);
    freq.put("od", 252);
    freq.put("oc", 71);
    freq.put("ob", 129);
    freq.put("oa", 52);
    freq.put("ig\u0127", 6);
    freq.put("o\u0302", 4);
    freq.put("oy", 7);
    freq.put("ox", 30);
    freq.put("ow", 56);
    freq.put("ov", 294);
    freq.put("ou", 99);
    freq.put("ot", 744);
    freq.put("os", 732);
    freq.put("or", 1794);
    freq.put("oq", 30);
    freq.put("op", 559);
    freq.put("eg\u0307i", 29);
    freq.put("ju ", 485);
    freq.put(" nq", 4);
    freq.put("bba", 73);
    freq.put("ehu", 3);
    freq.put("ehr", 6);
    freq.put("\u03b3", 15);
    freq.put("ehe", 33);
    freq.put("jub", 4);
    freq.put("jug", 3);
    freq.put("jud", 5);
    freq.put("uc\u0307u", 6);
    freq.put("jun", 93);
    freq.put("UE ", 8);
    freq.put("jum", 26);
    freq.put("jur", 26);
    freq.put("jus", 31);
    freq.put("uc\u0307j", 4);
    freq.put("jut", 19);
    freq.put("juz", 3);
    freq.put("bbr", 7);
    freq.put("\u4e01", 3);
    freq.put("rva", 30);
    freq.put("oc\u0307", 83);
    freq.put("rve", 9);
    freq.put("rvk", 3);
    freq.put("rvi", 21);
    freq.put("igw", 4);
    freq.put("igu", 35);
    freq.put("igs", 3);
    freq.put("igr", 16);
    freq.put("o\u0127", 227);
    freq.put("og\u0307", 175);
    freq.put("\u0631", 18);
    freq.put("iga", 32);
    freq.put("igo", 10);
    freq.put("ign", 7);
    freq.put("igm", 4);
    freq.put("igi", 11);
    freq.put("igh", 15);
    freq.put("\u0127g\u0307i", 6);
    freq.put("Xem", 11);
    freq.put("Xen", 4);
    freq.put("oz\u0307", 76);
    freq.put("Xer", 4);
    freq.put("ig ", 6);
    freq.put("pto", 14);
    freq.put("alo", 12);
    freq.put("all", 385);
    freq.put("alm", 75);
    freq.put("alj", 165);
    freq.put("alk", 58);
    freq.put("alh", 10);
    freq.put("ali", 1044);
    freq.put("pte", 10);
    freq.put("ale", 98);
    freq.put("alb", 18);
    freq.put("roj", 26);
    freq.put("pta", 7);
    freq.put("ala", 437);
    freq.put("alz", 5);
    freq.put("alv", 10);
    freq.put("fa ", 96);
    freq.put("alu", 24);
    freq.put("als", 4);
    freq.put("alp", 6);
    freq.put("alq", 4);
    freq.put("far", 23);
    freq.put("fas", 7);
    freq.put("fav", 3);
    freq.put("fat", 23);
    freq.put("faj", 8);
    freq.put("fak", 14);
    freq.put("uwi", 10);
    freq.put("fai", 4);
    freq.put("fan", 3);
    freq.put("rof", 39);
    freq.put("fal", 11);
    freq.put("fam", 431);
    freq.put("fac", 3);
    freq.put("uwa", 725);
    freq.put("rog", 26);
    freq.put("uwe", 20);
    freq.put("fae", 4);
    freq.put(" Ni", 43);
    freq.put(" Nh", 10);
    freq.put("c\u0307em", 53);
    freq.put("c\u0307el", 47);
    freq.put("c\u0307ej", 3);
    freq.put(" No", 118);
    freq.put(" Na", 84);
    freq.put("c\u0307ed", 11);
    freq.put(" Ne", 68);
    freq.put("lli", 145);
    freq.put("c\u0307ea", 26);
    freq.put("c\u0307et", 7);
    freq.put(" Nu", 9);
    freq.put("c\u0307er", 36);
    freq.put("c\u0307ep", 3);
    freq.put("teh", 3);
    freq.put("tei", 13);
    freq.put("tej", 22);
    freq.put("tek", 11);
    freq.put("tel", 51);
    freq.put("tem", 176);
    freq.put("ten", 75);
    freq.put("teo", 24);
    freq.put("tea", 13);
    freq.put("teb", 19);
    freq.put("l\u0127a", 5);
    freq.put("ted", 13);
    freq.put("nbu", 30);
    freq.put("teg", 12);
    freq.put("tex", 3);
    freq.put("nbi", 9);
    freq.put("nbh", 9);
    freq.put("nbn", 3);
    freq.put("tep", 3);
    freq.put("nba", 8);
    freq.put("tes", 111);
    freq.put("tet", 19);
    freq.put("ror", 86);
    freq.put("tev", 6);
    freq.put("tew", 7);
    freq.put("suf", 11);
    freq.put("sud", 7);
    freq.put("sub", 17);
    freq.put("sun", 28);
    freq.put("sum", 187);
    freq.put("sul", 11);
    freq.put("suw", 4);
    freq.put("sut", 4);
    freq.put("sus", 3);
    freq.put("sur", 38);
    freq.put(" Ai", 4);
    freq.put("te ", 34);
    freq.put("Eom", 5);
    freq.put("nb ", 7);
    freq.put("\u4e01 ", 3);
    freq.put("su ", 96);
    freq.put("o\u0301w ", 3);
    freq.put("rkt", 3);
    freq.put("rku", 13);
    freq.put("rks", 4);
    freq.put("Tor", 11);
    freq.put("Ung", 11);
    freq.put("Tot", 4);
    freq.put("rke", 11);
    freq.put("rka", 39);
    freq.put("rko", 6);
    freq.put("rki", 40);
    freq.put("fac\u0307", 11);
    freq.put("\u03b7", 6);
    freq.put("In ", 10);
    freq.put("zjo", 749);
    freq.put("faz\u0307", 13);
    freq.put("\u0127ta", 5);
    freq.put("rk ", 43);
    freq.put("a\u0301", 17);
    freq.put("zji", 3);
    freq.put("Int", 29);
    freq.put("Inv", 3);
    freq.put("Ins", 8);
    freq.put("Inn", 7);
    freq.put("Ini", 4);
    freq.put("v", 1504);
    freq.put("Ind", 51);
    freq.put("Inf", 6);
    freq.put("Ing", 78);
    freq.put("Inc", 5);
    freq.put("c\u0307", 1612);
    freq.put("tez\u0307", 14);
    freq.put("Ex", 3);
    freq.put("Gli", 4);
    freq.put("uqh", 6);
    freq.put("Gla", 4);
    freq.put("suc\u0307", 27);
    freq.put("te\u0127", 4);
    freq.put("\u03bd ", 6);
    freq.put("zju", 38);
    freq.put("lhe", 11);
    freq.put("\u0633 ", 3);
    freq.put("Nha", 9);
    freq.put("lha", 83);
    freq.put("lho", 16);
    freq.put("u\u0302ra", 3);
    freq.put("lhi", 3);
    freq.put("jiv", 3);
    freq.put(" su\u0302", 3);
    freq.put("Z\u0307ew", 4);
    freq.put("g\u0307es", 4);
    freq.put("g\u0307er", 20);
    freq.put("g\u0307et", 36);
    freq.put("g\u0307ew", 55);
    freq.put("g\u0307eb", 22);
    freq.put("g\u0307ej", 26);
    freq.put("g\u0307em", 3);
    freq.put("g\u0307el", 13);
    freq.put("g\u0307eo", 13);
    freq.put("g\u0307en", 468);
    freq.put("Erw", 3);
    freq.put("\u03bd\u03bf", 3);
    freq.put("L", 1007);
    freq.put("Era", 3);
    freq.put("Ern", 5);
    freq.put("Eri", 5);
    freq.put("Raf", 6);
    freq.put("Rad", 3);
    freq.put("yno", 6);
    freq.put("Rab", 15);
    freq.put("ync", 17);
    freq.put("Lbi", 9);
    freq.put("Mus", 11);
    freq.put("Mur", 4);
    freq.put(" ss", 20);
    freq.put(" sp", 304);
    freq.put(" sw", 6);
    freq.put(" st", 158);
    freq.put(" su", 160);
    freq.put(" sk", 72);
    freq.put(" si", 157);
    freq.put("Mua", 3);
    freq.put(" so", 414);
    freq.put(" sm", 4);
    freq.put("G\u0307ov", 11);
    freq.put(" sc", 5);
    freq.put("Mun", 7);
    freq.put(" sf", 6);
    freq.put(" se", 399);
    freq.put("iza", 7);
    freq.put("gur", 40);
    freq.put("izi", 9);
    freq.put("izj", 9);
    freq.put("wl ", 14);
    freq.put("izz", 228);
    freq.put("G\u0307o ", 3);
    freq.put(" s ", 60);
    freq.put("iz ", 6);
    freq.put("og\u0307g\u0307", 18);
    freq.put("kon", 300);
    freq.put("wlu", 7);
    freq.put("wli", 8);
    freq.put("X ", 10);
    freq.put("Ra\u0127", 3);
    freq.put("Rag\u0307", 3);
    freq.put("bja", 27);
    freq.put("\u3042\u3042\u3042", 3);
    freq.put(" ev", 14);
    freq.put("kor", 52);
    freq.put("kot", 8);
    freq.put("Nun", 3);
    freq.put("kow", 6);
    freq.put("kov", 8);
    freq.put("Muz\u0307", 5);
    freq.put("efu", 7);
    freq.put("efi", 23);
    freq.put("\u0639", 4);
    freq.put("efa", 4);
    freq.put("efe", 33);
    freq.put("eff", 12);
    freq.put("efg", 3);
    freq.put("jse", 9);
    freq.put("jsa", 5);
    freq.put("jso", 3);
    freq.put("jsi", 17);
    freq.put("Mu\u0127", 3);
    freq.put(" s\u0127", 19);
    freq.put("Zea", 4);
    freq.put("ef ", 29);
    freq.put("rte", 45);
    freq.put("cde", 9);
    freq.put("rta", 64);
    freq.put("rto", 18);
    freq.put("rti", 275);
    freq.put("rth", 15);
    freq.put("rtu", 22);
    freq.put("rts", 9);
    freq.put("rtr", 11);
    freq.put("rty", 3);
    freq.put("iex", 153);
    freq.put("ieq", 14);
    freq.put("Ju", 36);
    freq.put("ies", 54);
    freq.put("ier", 127);
    freq.put("iet", 652);
    freq.put("iew", 6);
    freq.put("iev", 7);
    freq.put("ieh", 6);
    freq.put("iek", 43);
    freq.put("Jo", 42);
    freq.put("iem", 75);
    freq.put("iel", 153);
    freq.put("ien", 919);
    freq.put("Je", 18);
    freq.put("iec", 7);
    freq.put("ieb", 132);
    freq.put("Ja", 67);
    freq.put("ieg", 249);
    freq.put("ief", 7);
    freq.put("hip", 4);
    freq.put("hir", 10);
    freq.put("his", 16);
    freq.put("rt ", 118);
    freq.put("hia", 98);
    freq.put("Xi", 5);
    freq.put("hid", 42);
    freq.put("hie", 9);
    freq.put("hij", 331);
    freq.put("hil", 7);
    freq.put("him", 32);
    freq.put("hin", 37);
    freq.put("\u05e1", 3);
    freq.put("ie ", 72);
    freq.put("arp", 3);
    freq.put("riz\u0307", 30);
    freq.put("ars", 162);
    freq.put("art", 331);
    freq.put("rta\u0300", 7);
    freq.put("arv", 4);
    freq.put("arx", 6);
    freq.put("ary", 8);
    freq.put("arz", 63);
    freq.put("ara", 245);
    freq.put("arb", 85);
    freq.put("arc", 33);
    freq.put("ard", 100);
    freq.put("are", 76);
    freq.put("arf", 11);
    freq.put("arg", 8);
    freq.put("arh", 6);
    freq.put("ari", 247);
    freq.put("arj", 155);
    freq.put("ark", 74);
    freq.put("arl", 42);
    freq.put("arm", 39);
    freq.put("arn", 29);
    freq.put("aro", 51);
    freq.put("al ", 2190);
    freq.put("Be", 122);
    freq.put("Fax", 3);
    freq.put("ar ", 1095);
    freq.put("ri\u0127", 3);
    freq.put("fga", 4);
    freq.put("rig\u0307", 47);
    freq.put(" Ps", 4);
    freq.put(" Pr", 197);
    freq.put("c", 1170);
    freq.put(" Pu", 27);
    freq.put(" Pt", 4);
    freq.put(" Pa", 355);
    freq.put("ric\u0307", 55);
    freq.put(" Pe", 46);
    freq.put(" Pj", 3);
    freq.put(" Pi", 76);
    freq.put(" Ph", 32);
    freq.put(" Po", 104);
    freq.put("Bn", 3);
    freq.put(" Pl", 13);
    freq.put("lg\u0307j", 9);
    freq.put("lg\u0307e", 4);
    freq.put("duE", 3);
    freq.put("pr", 559);
    freq.put("ps", 28);
    freq.put("pp", 359);
    freq.put("duk", 8);
    freq.put("dul", 13);
    freq.put("iez\u0307", 9);
    freq.put("pt", 35);
    freq.put("pu", 220);
    freq.put("pz", 3);
    freq.put("dua", 5);
    freq.put("px", 9);
    freq.put("swe", 16);
    freq.put(" o ", 3);
    freq.put("dug", 3);
    freq.put("dux", 5);
    freq.put("duz", 9);
    freq.put("pa", 677);
    freq.put("pe", 794);
    freq.put("pj", 336);
    freq.put("Fan", 3);
    freq.put("dur", 6);
    freq.put("dus", 12);
    freq.put("dut", 10);
    freq.put("po", 804);
    freq.put("pl", 346);
    freq.put("Emi", 5);
    freq.put("Fac", 3);
    freq.put("du ", 201);
    freq.put("p ", 179);
    freq.put("ieg\u0307", 19);
    freq.put("ie\u0127", 295);
    freq.put("riz", 21);
    freq.put("rix", 10);
    freq.put("riv", 33);
    freq.put("rit", 94);
    freq.put("riu", 21);
    freq.put("ris", 105);
    freq.put("rip", 4);
    freq.put("riq", 5);
    freq.put("rin", 112);
    freq.put("rio", 17);
    freq.put("ril", 56);
    freq.put("rim", 81);
    freq.put("rij", 128);
    freq.put("rik", 199);
    freq.put("rii", 17);
    freq.put("rif", 17);
    freq.put("rig", 28);
    freq.put("rid", 162);
    freq.put("fg\u0127", 5);
    freq.put("rib", 110);
    freq.put("ric", 65);
    freq.put("ria", 370);
    freq.put("qat", 18);
    freq.put("qaw", 19);
    freq.put("qaq", 6);
    freq.put("qas", 84);
    freq.put("qar", 45);
    freq.put("qax", 3);
    freq.put("qad", 47);
    freq.put("qaf", 11);
    freq.put("qab", 36);
    freq.put("qam", 11);
    freq.put("qal", 29);
    freq.put("Sqa", 14);
    freq.put("qan", 5);
    freq.put("qaj", 5);
    freq.put("Cos", 3);
    freq.put("Cor", 12);
    freq.put("Cou", 4);
    freq.put("Ill", 8);
    freq.put("Ilj", 3);
    freq.put("Ili", 4);
    freq.put("arg\u0307", 7);
    freq.put("Coc", 6);
    freq.put("Ils", 3);
    freq.put("Com", 15);
    freq.put("Col", 3);
    freq.put("ri ", 787);
    freq.put("Con", 19);
    freq.put("qa ", 24);
    freq.put("arc\u0307", 11);
    freq.put(" uz\u0307", 30);
    freq.put("Que\u0302\u0309", 4);
    freq.put("\u044c", 3);
    freq.put(" u\u0127", 27);
    freq.put("lji", 34);
    freq.put("ljo", 3);
    freq.put("lja", 587);
    freq.put("ac\u0327a", 5);
    freq.put("lju", 103);
    freq.put("zz ", 42);
    freq.put("\u0127du", 13);
    freq.put("zzu", 3);
    freq.put("zzo", 6);
    freq.put("\u0127da", 93);
    freq.put("zzj", 709);
    freq.put("zzi", 16);
    freq.put("\u0127di", 11);
    freq.put("zze", 28);
    freq.put("\u0127dm", 6);
    freq.put("zza", 121);
    freq.put("ylv", 25);
    freq.put("ylu", 5);
    freq.put("Rom", 28);
    freq.put("Rob", 7);
    freq.put("Rod", 6);
    freq.put("yle", 4);
    freq.put("yla", 41);
    freq.put("ylo", 8);
    freq.put("Ros", 6);
    freq.put("Row", 3);
    freq.put("wn ", 84);
    freq.put(" ut", 4);
    freq.put("c\u0307c\u0307j", 10);
    freq.put(" ur", 10);
    freq.put(" ul", 5);
    freq.put(" um", 24);
    freq.put(" un", 67);
    freq.put("Msi", 3);
    freq.put(" uk", 130);
    freq.put(" uf", 33);
    freq.put("ixi", 5);
    freq.put("ixb", 5);
    freq.put("c\u0307c\u0307a", 41);
    freq.put("ixa", 10);
    freq.put("ixx", 38);
    freq.put("ixr", 3);
    freq.put("ixu", 16);
    freq.put("wnd", 36);
    freq.put("z\u0307mi", 84);
    freq.put("exe", 4);
    freq.put(" u ", 1681);
    freq.put("ix ", 101);
    freq.put("msa", 6);
    freq.put("z\u0307ma", 9);
    freq.put("z", 2475);
    freq.put("gru", 80);
    freq.put("gre", 13);
    freq.put("gra", 106);
    freq.put("gro", 12);
    freq.put("gri", 25);
    freq.put("C\u0307ek", 5);
    freq.put("C\u0307en", 16);
    freq.put("eda", 34);
    freq.put("edd", 32);
    freq.put("ede", 117);
    freq.put("edj", 34);
    freq.put("edi", 93);
    freq.put("edo", 9);
    freq.put("edm", 4);
    freq.put("edr", 8);
    freq.put("edu", 14);
    freq.put("ugo", 63);
    freq.put("FF ", 4);
    freq.put("\u0126", 95);
    freq.put("uga", 13);
    freq.put("ed ", 411);
    freq.put("jqa", 4);
    freq.put("P", 876);
    freq.put("c\u0307iz\u0307", 58);
    freq.put("car", 6);
    freq.put("rro", 11);
    freq.put("rri", 45);
    freq.put("taz\u0307", 24);
    freq.put("rre", 61);
    freq.put("rra", 143);
    freq.put("cav", 6);
    freq.put("\u0629", 5);
    freq.put("rry", 5);
    freq.put("rru", 11);
    freq.put("cat", 11);
    freq.put("bde", 16);
    freq.put("bda", 51);
    freq.put("bdi", 26);
    freq.put("cze", 3);
    freq.put("can", 20);
    freq.put(" \u20ac", 8);
    freq.put("rr ", 10);
    freq.put("ta\u0127", 77);
    freq.put("tag\u0307", 49);
    freq.put("sig\u0307", 19);
    freq.put("tac\u0307", 14);
    freq.put("apr", 40);
    freq.put("app", 107);
    freq.put("apt", 6);
    freq.put("apu", 10);
    freq.put("e\u0302\u0309ng", 5);
    freq.put("api", 58);
    freq.put("apo", 6);
    freq.put("apl", 8);
    freq.put("wil", 40);
    freq.put("apa", 53);
    freq.put("Mil", 29);
    freq.put("sio\u0301", 3);
    freq.put("fed", 15);
    freq.put("Hug", 4);
    freq.put("lq", 16);
    freq.put("usa", 22);
    freq.put("fen", 35);
    freq.put("Hum", 16);
    freq.put("fel", 65);
    freq.put("fem", 7);
    freq.put("fej", 77);
    freq.put("usi", 6);
    freq.put("ush", 3);
    freq.put("few", 4);
    freq.put("fet", 33);
    freq.put("Huw", 44);
    freq.put("fer", 477);
    freq.put("fes", 62);
    freq.put("Hus", 3);
    freq.put("c\u0307i ", 414);
    freq.put("fez", 6);
    freq.put("Gua", 3);
    freq.put("Gue", 7);
    freq.put("o ", 3);
    freq.put("Gui", 3);
    freq.put("Gus", 3);
    freq.put("ap ", 17);
    freq.put("px ", 9);
    freq.put(" Ru", 115);
    freq.put("Hu ", 25);
    freq.put("fe ", 5);
    freq.put("us ", 426);
    freq.put("c\u0307is", 21);
    freq.put("c\u0307ir", 11);
    freq.put("c\u0307ip", 63);
    freq.put(" Ry", 3);
    freq.put("c\u0307iv", 18);
    freq.put("c\u0307it", 21);
    freq.put(" Re", 128);
    freq.put("c\u0307ij", 6);
    freq.put(" Ra", 39);
    freq.put("c\u0307in", 23);
    freq.put("c\u0307im", 5);
    freq.put("c\u0307il", 14);
    freq.put(" Ro", 55);
    freq.put(" Ri", 51);
    freq.put(" Rh", 13);
    freq.put("c\u0307ie", 8);
    freq.put("c\u0307id", 4);
    freq.put("tat", 647);
    freq.put("tav", 10);
    freq.put("taw", 25);
    freq.put("tap", 5);
    freq.put("taq", 33);
    freq.put("tar", 362);
    freq.put("tas", 153);
    freq.put("ie\u0300r", 3);
    freq.put("tax", 85);
    freq.put("taz", 32);
    freq.put("tad", 122);
    freq.put("taf", 10);
    freq.put("tag", 144);
    freq.put("tab", 35);
    freq.put("tac", 4);
    freq.put("tal", 1771);
    freq.put("tam", 115);
    freq.put("tan", 322);
    freq.put("tai", 5);
    freq.put("taj", 52);
    freq.put("tak", 33);
    freq.put("sis", 97);
    freq.put("sir", 74);
    freq.put("siv", 11);
    freq.put("sit", 93);
    freq.put(" os", 13);
    freq.put("sic", 7);
    freq.put("sib", 30);
    freq.put("sia", 17);
    freq.put("dwa", 109);
    freq.put("sig", 9);
    freq.put("sif", 97);
    freq.put("sie", 58);
    freq.put("sid", 59);
    freq.put("sik", 24);
    freq.put("sij", 19);
    freq.put("dwi", 6);
    freq.put("sio", 57);
    freq.put("sin", 87);
    freq.put("sim", 30);
    freq.put("sil", 16);
    freq.put("ta ", 3503);
    freq.put("si ", 588);
    freq.put("kbi", 38);
    freq.put("kba", 87);
    freq.put("\u0391", 3);
    freq.put("o\u0308d", 5);
    freq.put("kbu", 3);
    freq.put("g\u0307iz\u0307", 6);
    freq.put("cto", 32);
    freq.put("gh ", 3);
    freq.put("wq", 4);
    freq.put("Ibn", 3);
    freq.put("Cas", 12);
    freq.put("Car", 46);
    freq.put("Cap", 25);
    freq.put("Cat", 7);
    freq.put("Can", 4);
    freq.put("g\u0307ic\u0307", 7);
    freq.put("Cal", 12);
    freq.put("\u03c4\u03c1\u03bf", 4);
    freq.put("Caf", 3);
    freq.put("Cae", 24);
    freq.put("Pre", 80);
    freq.put("nfe", 17);
    freq.put("nfa", 3);
    freq.put("nfo", 17);
    freq.put("Pro", 78);
    freq.put("nfl", 29);
    freq.put("Pri", 36);
    freq.put("nfi", 16);
    freq.put("Pru", 4);
    freq.put("nfu", 5);
    freq.put("cti", 12);
    freq.put("nfr", 181);
    freq.put("lte\u0301", 3);
    freq.put("oui", 9);
    freq.put("oun", 9);
    freq.put("oul", 26);
    freq.put("ouc", 3);
    freq.put("oua", 3);
    freq.put("mg\u0307a", 3);
    freq.put("ous", 5);
    freq.put("our", 20);
    freq.put("oup", 3);
    freq.put("out", 9);
    freq.put("lt ", 135);
    freq.put("aol", 6);
    freq.put("ou ", 5);
    freq.put("ltu", 44);
    freq.put("lta", 202);
    freq.put("lte", 26);
    freq.put("lti", 206);
    freq.put("lth", 8);
    freq.put("lto", 3);
    freq.put("u\u0308", 5);
    freq.put("utb", 142);
    freq.put("K ", 19);
    freq.put("vig", 4);
    freq.put("\u0142a", 4);
    freq.put("g\u0307iz", 5);
    freq.put("g\u0307it", 17);
    freq.put("Fos", 11);
    freq.put("g\u0307is", 26);
    freq.put("g\u0307ir", 4);
    freq.put("g\u0307im", 5);
    freq.put("g\u0307il", 3);
    freq.put("g\u0307in", 58);
    freq.put("g\u0307ik", 17);
    freq.put("g\u0307ij", 94);
    freq.put("g\u0307ie", 97);
    freq.put("\u03bb", 13);
    freq.put("g\u0307if", 10);
    freq.put("g\u0307ib", 12);
    freq.put("Kb", 8);
    freq.put("Ka", 218);
    freq.put("Ke", 19);
    freq.put("Ki", 36);
    freq.put("Kh", 3);
    freq.put("Ko", 78);
    freq.put("Kn", 43);
    freq.put("Kl", 32);
    freq.put("Kr", 47);
    freq.put("\u0127fi", 3);
    freq.put("Ku", 41);
    freq.put("Kt", 6);
    freq.put("qg\u0127", 17);
    freq.put("g\u0307i ", 94);
    freq.put("sem", 135);
    freq.put("sel", 19);
    freq.put("xri", 13);
    freq.put("hv", 4);
    freq.put("who", 7);
    freq.put("Ko\u0308", 3);
    freq.put("Poz", 3);
    freq.put("Pot", 3);
    freq.put("Por", 14);
    freq.put("Pop", 6);
    freq.put("Pon", 3);
    freq.put("Pol", 45);
    freq.put("Pom", 3);
    freq.put("Poe", 20);
    freq.put("Cha", 23);
    freq.put(" c\u0307c\u0307", 13);
    freq.put("ha", 601);
    freq.put("eat", 31);
    freq.put("q ", 310);
    freq.put("Ry", 3);
    freq.put("B\u0127", 8);
    freq.put("\u0254", 5);
    freq.put("Mqa", 3);
    freq.put("qs", 82);
    freq.put(" we", 8);
    freq.put("qu", 68);
    freq.put("qt", 30);
    freq.put("qw", 22);
    freq.put(" wa", 198);
    freq.put(" wk", 61);
    freq.put(" wi", 231);
    freq.put("qa", 345);
    freq.put("qb", 7);
    freq.put("qe", 33);
    freq.put("qd", 28);
    freq.put("qg", 18);
    freq.put("qf", 24);
    freq.put("qi", 116);
    freq.put("qh", 7);
    freq.put("qj", 34);
    freq.put("qm", 3);
    freq.put("ql", 8);
    freq.put("qo", 46);
    freq.put("Jak", 3);
    freq.put("ebd", 45);
    freq.put("ebe", 23);
    freq.put("ebg", 4);
    freq.put("eba", 49);
    freq.put("ebb", 45);
    freq.put("ebl", 9);
    freq.put("ebo", 4);
    freq.put("ebi", 3);
    freq.put("jo ", 8);
    freq.put("ebu", 20);
    freq.put("ebr", 85);
    freq.put("eby", 5);
    freq.put("dla", 5);
    freq.put("dle", 3);
    freq.put("dli", 7);
    freq.put("Jac", 7);
    freq.put("rc\u0307e", 8);
    freq.put("rc\u0307i", 27);
    freq.put("rc\u0307j", 4);
    freq.put("jop", 6);
    freq.put("joq", 5);
    freq.put("jor", 9);
    freq.put("jos", 5);
    freq.put("jot", 4);
    freq.put(" \u0627\u0644", 11);
    freq.put("jod", 26);
    freq.put("jok", 10);
    freq.put("jol", 63);
    freq.put("jon", 999);
    freq.put("\u0430\u0440", 3);
    freq.put("rc\u0307 ", 3);
    freq.put("Zar", 3);
    freq.put("rpr", 9);
    freq.put("rpe", 3);
    freq.put("rpi", 4);
    freq.put("rph", 133);
    freq.put("rpo", 7);
    freq.put("bbo", 6);
    freq.put(" w\u0127", 3);
    freq.put(" c\u0307 ", 11);
    freq.put("bbl", 107);
    freq.put("Jug", 9);
    freq.put("bbi", 51);
    freq.put("bbe", 5);
    freq.put("Jun", 4);
    freq.put("Jul", 5);
    freq.put("Jum", 16);
    freq.put("tog", 16);
    freq.put("bbu", 20);
    freq.put("bbs", 7);
    freq.put("g\u0307om", 3);
    freq.put("\u03bf", 27);
    freq.put("rp ", 8);
    freq.put(" c\u0307a", 12);
    freq.put(" c\u0307e", 61);
    freq.put("e\u0301", 59);
    freq.put(" c\u0307k", 4);
    freq.put(" c\u0307i", 36);
    freq.put("bb ", 23);
    freq.put(" wz\u0307", 15);
    freq.put("tja", 23);
    freq.put("avu", 7);
    freq.put("avv", 19);
    freq.put("avl", 3);
    freq.put("e\u0304", 6);
    freq.put("avo", 12);
    freq.put("avi", 21);
    freq.put("avj", 12);
    freq.put("jo\u0127", 10);
    freq.put("ave", 3);
    freq.put("ava", 20);
    freq.put("fki", 8);
    freq.put("uqa", 3);
    freq.put("uqq", 3);
    freq.put("Gwe", 23);
    freq.put("eb\u0127", 18);
    freq.put(" Tw", 8);
    freq.put("uq ", 206);
    freq.put(" Tu", 48);
    freq.put(" Ts", 6);
    freq.put(" Tr", 86);
    freq.put(" To", 22);
    freq.put(" Tn", 4);
    freq.put(" Tl", 3);
    freq.put(" Ti", 59);
    freq.put(" Th", 203);
    freq.put("c\u0307ke", 4);
    freq.put(" Te", 32);
    freq.put(" Tc", 3);
    freq.put(" Ta", 192);
    freq.put("mfa", 7);
    freq.put("tch", 3);
    freq.put("sku", 26);
    freq.put("skw", 20);
    freq.put("skr", 25);
    freq.put("Far", 3);
    freq.put("ske", 20);
    freq.put("ska", 25);
    freq.put("Fal", 3);
    freq.put("Fam", 7);
    freq.put("skl", 5);
    freq.put("sko", 72);
    freq.put("ski", 16);
    freq.put("Fad", 3);
    freq.put("Eis", 3);
    freq.put("T", 680);
    freq.put("Ein", 3);
    freq.put("owc\u0307", 4);
    freq.put("vag\u0307", 3);
    freq.put("sk ", 13);
    freq.put("Sud", 5);
    freq.put("qed", 18);
    freq.put("qeg", 11);
    freq.put("Sun", 4);
    freq.put("Sum", 3);
    freq.put("Sul", 3);
    freq.put("Sur", 6);
    freq.put("Sup", 10);
    freq.put("nd ", 104);
    freq.put("ndi", 112);
    freq.put("ndh", 49);
    freq.put("ndj", 40);
    freq.put("ndo", 40);
    freq.put("nda", 177);
    freq.put("nde", 97);
    freq.put("nds", 5);
    freq.put("ndr", 47);
    freq.put("ndu", 58);
    freq.put("owl", 21);
    freq.put("own", 4);
    freq.put("owi", 5);
    freq.put("owe", 6);
    freq.put("o\u0308n", 4);
    freq.put("Tur", 13);
    freq.put("ows", 7);
    freq.put("vak", 7);
    freq.put("van", 56);
    freq.put("val", 82);
    freq.put("vam", 7);
    freq.put("Ama", 4);
    freq.put("Amb", 5);
    freq.put("Ame", 142);
    freq.put("vag", 5);
    freq.put("vad", 5);
    freq.put("vaz", 3);
    freq.put("var", 33);
    freq.put("Aff", 3);
    freq.put("vat", 22);
    freq.put("ow ", 5);
    freq.put("z\u0307da", 26);
    freq.put("z\u0307di", 5);
    freq.put("Tel", 4);
    freq.put("Tem", 6);
    freq.put("va ", 77);
    freq.put("lve", 6);
    freq.put("lva", 15);
    freq.put("Ter", 10);
    freq.put("lvi", 33);
    freq.put("g\u0307od", 3);
    freq.put("mys", 15);
    freq.put("myi", 10);
    freq.put("lm ", 9);
    freq.put("g\u0307or", 8);
    freq.put("myg", 5);
    freq.put("i\u0301 ", 5);
    freq.put("Afr", 52);
    freq.put("\u043d", 6);
    freq.put("g\u0307o ", 5);
    freq.put("Lhu", 13);
  }
  
}

