package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class MS extends CLangProfile {
  private static final String name = "ms";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public MS() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 8074753;
    n_words[1] = 9381487;
    n_words[2] = 7891301;

    freq.put("pre", 663);
    freq.put("aln", 492);
    freq.put("Ked", 783);
    freq.put(" ti", 5407);
    freq.put("mny", 568);
    freq.put("nun", 1462);
    freq.put("ße ", 87);
    freq.put("sco", 283);
    freq.put("eja", 2806);
    freq.put("MA ", 87);
    freq.put("nwa", 109);
    freq.put(" G ", 103);
    freq.put("tug", 473);
    freq.put("sch", 553);
    freq.put("aua", 793);
    freq.put("Tuh", 175);
    freq.put("auc", 85);
    freq.put("aub", 89);
    freq.put("aue", 165);
    freq.put("Okt", 487);
    freq.put("efo", 203);
    freq.put("auf", 124);
    freq.put("auh", 298);
    freq.put("auk", 81);
    freq.put("aum", 504);
    freq.put("blo", 96);
    freq.put("up ", 964);
    freq.put("TV ", 585);
    freq.put("aup", 666);
    freq.put("aus", 360);
    freq.put("aur", 353);
    freq.put("aut", 4080);
    freq.put("G ", 398);
    freq.put("tai", 2173);
    freq.put("ren", 2521);
    freq.put("pte", 935);
    freq.put("uru", 5838);
    freq.put(" Gu", 1933);
    freq.put(" Gr", 1994);
    freq.put("\u0644", 805);
    freq.put("nul", 732);
    freq.put("sca", 245);
    freq.put("ska", 1853);
    freq.put("ble", 283);
    freq.put(" Ge", 1684);
    freq.put(" Ga", 1910);
    freq.put("\u05d9", 86);
    freq.put(" Go", 899);
    freq.put(" Gl", 218);
    freq.put("ala", 69871);
    freq.put(" Gh", 173);
    freq.put(" Gi", 642);
    freq.put("au ", 15214);
    freq.put("Gu", 1935);
    freq.put("Gr", 2002);
    freq.put("upi", 131);
    freq.put("bla", 135);
    freq.put("e\u0308", 593);
    freq.put("aiz", 292);
    freq.put("upa", 36302);
    freq.put("Ge", 1691);
    freq.put("Ga", 1915);
    freq.put("slu", 163);
    freq.put("Go", 908);
    freq.put("ens", 1346);
    freq.put("Gl", 218);
    freq.put("aiw", 1231);
    freq.put("Gi", 647);
    freq.put("Gh", 173);
    freq.put("a\u0304", 412);
    freq.put(" ka", 14437);
    freq.put("olk", 89);
    freq.put("cce", 280);
    freq.put(" ke", 34954);
    freq.put("loi", 125);
    freq.put(" kh", 806);
    freq.put(" ki", 2905);
    freq.put("NO ", 270);
    freq.put(" ko", 7504);
    freq.put(" kl", 234);
    freq.put(" km", 1352);
    freq.put(" kr", 296);
    freq.put("alv", 310);
    freq.put("ife", 181);
    freq.put("ais", 498);
    freq.put(" ku", 3370);
    freq.put("pim", 153);
    freq.put("rli", 1376);
    freq.put("air", 1407);
    freq.put("fa ", 136);
    freq.put("Pul", 1812);
    freq.put("neo", 158);
    freq.put("Pun", 218);
    freq.put("nem", 406);
    freq.put("nek", 199);
    freq.put("ail", 1086);
    freq.put("Pue", 122);
    freq.put("ned", 91);
    freq.put("kut", 2151);
    freq.put("kus", 252);
    freq.put("kur", 1183);
    freq.put("\u062f", 337);
    freq.put("Puc", 123);
    freq.put("kun", 678);
    freq.put("kum", 2053);
    freq.put("gna", 169);
    freq.put("nez", 159);
    freq.put("alp", 100);
    freq.put("kui", 193);
    freq.put("ney", 393);
    freq.put("Put", 1136);
    freq.put("ße", 95);
    freq.put("ak ", 31786);
    freq.put(" lu", 1062);
    freq.put("nes", 9659);
    freq.put("Pur", 154);
    freq.put("Pus", 493);
    freq.put("mee", 451);
    freq.put("dep", 132);
    freq.put("\u0443", 83);
    freq.put("\u03c2", 105);
    freq.put("mec", 162);
    freq.put("ws ", 263);
    freq.put("e\u0300r", 124);
    freq.put("orr", 678);
    freq.put("uak", 209);
    freq.put("gne", 632);
    freq.put("mek", 226);
    freq.put("ors", 277);
    freq.put("zur", 484);
    freq.put("met", 1241);
    freq.put("mew", 781);
    freq.put("mes", 766);
    freq.put("aid", 269);
    freq.put("aud", 602);
    freq.put("gli", 352);
    freq.put("aky", 793);
    freq.put("Zo", 133);
    freq.put("Zi", 166);
    freq.put("glo", 121);
    freq.put("aks", 1768);
    freq.put("Ze", 342);
    freq.put("k", 282587);
    freq.put("roc", 332);
    freq.put("akw", 163);
    freq.put("\u30a2\u30a2\u30a2", 393);
    freq.put("aku", 1710);
    freq.put("akt", 1506);
    freq.put("akk", 560);
    freq.put("aki", 2473);
    freq.put("akh", 1543);
    freq.put("ako", 830);
    freq.put("akn", 464);
    freq.put("akm", 163);
    freq.put("akl", 477);
    freq.put("dra", 600);
    freq.put("Zu", 270);
    freq.put("aka", 43030);
    freq.put("dre", 255);
    freq.put("der", 2200);
    freq.put("ake", 622);
    freq.put("ku ", 3568);
    freq.put("Jer", 4043);
    freq.put("iy", 922);
    freq.put("Jep", 1274);
    freq.put("Kom", 706);
    freq.put("Kol", 252);
    freq.put("Kon", 712);
    freq.put("bru", 584);
    freq.put("Kob", 83);
    freq.put("kub", 97);
    freq.put("aul", 410);
    freq.put("bro", 107);
    freq.put("orf", 206);
    freq.put("Jea", 98);
    freq.put("bri", 257);
    freq.put("lma", 261);
    freq.put("bre", 165);
    freq.put("Kor", 569);
    freq.put("Jen", 531);
    freq.put("Kot", 1614);
    freq.put("Jel", 140);
    freq.put("o\u0304 ", 90);
    freq.put("m ", 42736);
    freq.put("Rho\u0302", 457);
    freq.put("orw", 94);
    freq.put("iq", 398);
    freq.put("er ", 9482);
    freq.put("ip", 10779);
    freq.put("ni ", 12040);
    freq.put("Ste", 575);
    freq.put("Nai", 85);
    freq.put("Sta", 593);
    freq.put("iu", 2005);
    freq.put("Sto", 152);
    freq.put("nyi", 1836);
    freq.put("Stu", 188);
    freq.put("osp", 283);
    freq.put("rip", 4424);
    freq.put("Str", 327);
    freq.put("V", 4890);
    freq.put("Nam", 1815);
    freq.put("Eas", 113);
    freq.put("me", 75198);
    freq.put("ii", 592);
    freq.put("erv", 184);
    freq.put("mf", 114);
    freq.put("ma", 65762);
    freq.put("dn ", 127);
    freq.put("err", 623);
    freq.put("mb", 18534);
    freq.put("mm", 2305);
    freq.put("ml", 733);
    freq.put("mo", 4147);
    freq.put("mn", 744);
    freq.put("mi", 11715);
    freq.put("ery", 101);
    freq.put("mk", 292);
    freq.put("mu", 20069);
    freq.put("mt", 113);
    freq.put("erf", 289);
    freq.put("erg", 1984);
    freq.put("tna", 265);
    freq.put("mp", 19625);
    freq.put("ms", 473);
    freq.put("mr", 122);
    freq.put("erl", 22148);
    freq.put("im", 21680);
    freq.put("ern", 3919);
    freq.put("ero", 1667);
    freq.put("my", 327);
    freq.put("eri", 15969);
    freq.put("erj", 2346);
    freq.put("erk", 5331);
    freq.put("uay", 140);
    freq.put("Aba", 147);
    freq.put("Abb", 90);
    freq.put("Le", 2149);
    freq.put("Abd", 1143);
    freq.put("io", 6266);
    freq.put("Lib", 174);
    freq.put("La", 11882);
    freq.put("Lo", 3499);
    freq.put("Abj", 137);
    freq.put("uar", 5742);
    freq.put("la ", 8163);
    freq.put("uat", 3203);
    freq.put("Li", 1937);
    freq.put("Lit", 120);
    freq.put("ia", 71186);
    freq.put("Liv", 87);
    freq.put("Lu", 2055);
    freq.put("uam", 156);
    freq.put("Abu", 317);
    freq.put("rig", 839);
    freq.put("uac", 88);
    freq.put("rid", 481);
    freq.put("Ly", 128);
    freq.put("Kab", 4567);
    freq.put("enb", 1340);
    freq.put("ki ", 4083);
    freq.put("end", 7875);
    freq.put("ene", 3392);
    freq.put("Kad", 192);
    freq.put("Kak", 93);
    freq.put("Kaj", 109);
    freq.put("i\u0304", 194);
    freq.put("hom", 180);
    freq.put("Kan", 1394);
    freq.put("Al ", 922);
    freq.put("Kal", 3891);
    freq.put("Kas", 307);
    freq.put("Kar", 941);
    freq.put("hot", 110);
    freq.put("Kap", 368);
    freq.put("Kaw", 364);
    freq.put("hos", 188);
    freq.put("Jin", 94);
    freq.put("m2", 560);
    freq.put("sse", 728);
    freq.put("Kaz", 84);
    freq.put("Kay", 157);
    freq.put("Rhe", 239);
    freq.put("ula", 12934);
    freq.put("A", 33896);
    freq.put("lam", 20229);
    freq.put("lan", 17980);
    freq.put("iub", 115);
    freq.put("\u0645", 542);
    freq.put("lai", 4507);
    freq.put("L ", 509);
    freq.put("lak", 3883);
    freq.put("lad", 420);
    freq.put("laf", 100);
    freq.put("lag", 1649);
    freq.put("nua", 1039);
    freq.put("laa", 247);
    freq.put("lab", 751);
    freq.put("lac", 351);
    freq.put("ova", 317);
    freq.put("II ", 729);
    freq.put("laz", 215);
    freq.put("ove", 2144);
    freq.put("lat", 9127);
    freq.put("occ", 131);
    freq.put("lav", 163);
    freq.put("ovi", 3651);
    freq.put("lap", 6088);
    freq.put("iel", 330);
    freq.put("so ", 382);
    freq.put("las", 2647);
    freq.put("en ", 13321);
    freq.put("Alo", 177);
    freq.put("All", 368);
    freq.put("Alm", 117);
    freq.put("ho ", 208);
    freq.put("Ali", 409);
    freq.put("Alg", 101);
    freq.put("u\u0304", 189);
    freq.put("Ale", 191);
    freq.put("Alb", 985);
    freq.put("pub", 846);
    freq.put("Ala", 509);
    freq.put("lou", 94);
    freq.put("mpu", 8478);
    freq.put("mpr", 185);
    freq.put("Alt", 207);
    freq.put("Alu", 88);
    freq.put("Alp", 987);
    freq.put(" V ", 104);
    freq.put(" Hy", 123);
    freq.put("ngu", 2703);
    freq.put("lt ", 289);
    freq.put("fam", 394);
    freq.put("zen", 271);
    freq.put(" Hu", 2023);
    freq.put("zer", 331);
    freq.put(" Hi", 2274);
    freq.put("oni", 1220);
    freq.put(" Ho", 2089);
    freq.put("sho", 148);
    freq.put("tus", 1028);
    freq.put("onn", 659);
    freq.put(" Ha", 4690);
    freq.put("uwa", 153);
    freq.put(" He", 1102);
    freq.put("ono", 1193);
    freq.put("ima", 6615);
    freq.put("fis", 84);
    freq.put("Hir", 81);
    freq.put("His", 108);
    freq.put("Hit", 715);
    freq.put("dur", 258);
    freq.put("imi", 887);
    freq.put("cle", 147);
    freq.put("imo", 347);
    freq.put("imn", 174);
    freq.put("ssa", 1040);
    freq.put("imp", 1571);
    freq.put("fia", 152);
    freq.put("Hid", 126);
    freq.put(" ga", 1706);
    freq.put("Hig", 156);
    freq.put("fik", 1106);
    freq.put("Hij", 131);
    freq.put("Hik", 136);
    freq.put("Hil", 325);
    freq.put("re\u0301", 209);
    freq.put("Hin", 334);
    freq.put("\u03c1", 83);
    freq.put("ze ", 110);
    freq.put("ona", 2279);
    freq.put(" Ve", 610);
    freq.put("hya", 165);
    freq.put(" Vi", 1221);
    freq.put("SA ", 131);
    freq.put("zia", 91);
    freq.put(" Vo", 1699);
    freq.put("ong", 5686);
    freq.put("oks", 233);
    freq.put("udk", 154);
    freq.put(" H ", 142);
    freq.put("im ", 3199);
    freq.put("des", 4618);
    freq.put("Bha", 303);
    freq.put("l", 322914);
    freq.put("nic", 456);
    freq.put(" go", 642);
    freq.put("fi ", 402);
    freq.put("cy ", 279);
    freq.put("gri", 124);
    freq.put("lka", 1572);
    freq.put("\u0301", 146);
    freq.put("deo", 515);
    freq.put("woo", 89);
    freq.put("sya", 1661);
    freq.put("Wor", 178);
    freq.put("oku", 358);
    freq.put("bra", 750);
    freq.put("Won", 85);
    freq.put("kue", 85);
    freq.put("eum", 158);
    freq.put("mbo", 1368);
    freq.put("nt ", 2047);
    freq.put("SS ", 126);
    freq.put("nio", 219);
    freq.put("rt", 16822);
    freq.put("ru", 47839);
    freq.put("rv", 432);
    freq.put("rw", 832);
    freq.put("rp", 3350);
    freq.put("rr", 2104);
    freq.put("rs", 8875);
    freq.put("zar", 263);
    freq.put("gog", 193);
    freq.put("til", 1110);
    freq.put(" za", 721);
    freq.put("ry", 2374);
    freq.put("rz", 381);
    freq.put("rd", 8278);
    freq.put("re", 18314);
    freq.put("rf", 712);
    freq.put("rg", 8124);
    freq.put("ajl", 518);
    freq.put("ra", 108362);
    freq.put("rb", 22662);
    freq.put("rc", 2216);
    freq.put("rl", 23672);
    freq.put("rm", 10746);
    freq.put("rn", 7372);
    freq.put("ro", 15649);
    freq.put("rh", 2483);
    freq.put("ri", 56760);
    freq.put("rj", 2659);
    freq.put("rk", 11585);
    freq.put("nty", 389);
    freq.put("\u0643", 121);
    freq.put("nia", 3904);
    freq.put("ial", 13523);
    freq.put("nts", 152);
    freq.put("ntr", 493);
    freq.put("ntu", 9594);
    freq.put("nti", 4527);
    freq.put("nth", 267);
    freq.put("mbi", 2016);
    freq.put("W", 6762);
    freq.put("nta", 14735);
    freq.put("yia", 421);
    freq.put("kit", 2779);
    freq.put("nte", 5062);
    freq.put("deb", 180);
    freq.put("pny", 87);
    freq.put("Vic", 157);
    freq.put("atd", 105);
    freq.put("ate", 9872);
    freq.put("lec", 148);
    freq.put("Vie", 298);
    freq.put("atn", 277);
    freq.put("ato", 1267);
    freq.put("atl", 166);
    freq.put("atm", 81);
    freq.put("atk", 1026);
    freq.put("Vil", 217);
    freq.put("ati", 6436);
    freq.put("Vir", 90);
    freq.put("Vis", 137);
    freq.put("att", 488);
    freq.put("atu", 11913);
    freq.put("r ", 54659);
    freq.put("ats", 175);
    freq.put("ism", 665);
    freq.put("isl", 386);
    freq.put("aj ", 128);
    freq.put("aca", 1070);
    freq.put("isa", 2790);
    freq.put(" Sp", 492);
    freq.put("ise", 2265);
    freq.put("uhr", 221);
    freq.put("Swi", 148);
    freq.put("oko", 2518);
    freq.put("zam", 678);
    freq.put("nha", 170);
    freq.put("Dun", 670);
    freq.put(" l ", 89);
    freq.put("oky", 119);
    freq.put("Dua", 114);
    freq.put("Swe", 223);
    freq.put("pir", 975);
    freq.put("yik", 137);
    freq.put("osa", 542);
    freq.put("kib", 224);
    freq.put("Dur", 174);
    freq.put("Dus", 152);
    freq.put("nip", 112);
    freq.put("me ", 1188);
    freq.put("xic", 389);
    freq.put(" gi", 259);
    freq.put("\u043a\u0430", 100);
    freq.put("tor", 1363);
    freq.put("Cen", 218);
    freq.put("Cem", 85);
    freq.put("tov", 117);
    freq.put("tow", 94);
    freq.put("tot", 99);
    freq.put("BB ", 113);
    freq.put("tok", 501);
    freq.put("toh", 336);
    freq.put("toi", 105);
    freq.put("ton", 1740);
    freq.put("Cer", 238);
    freq.put("tol", 501);
    freq.put("tom", 534);
    freq.put("tob", 555);
    freq.put("raß", 86);
    freq.put("dik", 7651);
    freq.put(" le", 4083);
    freq.put("B", 36297);
    freq.put("gya", 453);
    freq.put(" lo", 1081);
    freq.put(" Sm", 87);
    freq.put("mbe", 4139);
    freq.put(" li", 1439);
    freq.put("zak", 354);
    freq.put("laj", 805);
    freq.put("RM ", 2481);
    freq.put(" fu", 221);
    freq.put("fil", 3257);
    freq.put("uke", 89);
    freq.put("ee ", 526);
    freq.put("Set", 535);
    freq.put("Ses", 148);
    freq.put("Ser", 1397);
    freq.put("Sep", 1336);
    freq.put("ktu", 771);
    freq.put("i\u0301", 159);
    freq.put("to ", 1901);
    freq.put("ktr", 757);
    freq.put("Seg", 241);
    freq.put("See", 220);
    freq.put("Sed", 118);
    freq.put("Sec", 184);
    freq.put("Seb", 744);
    freq.put("Sea", 113);
    freq.put("Seo", 93);
    freq.put("Sen", 771);
    freq.put("Sem", 1319);
    freq.put("Sel", 5561);
    freq.put("Sek", 1892);
    freq.put("Sej", 326);
    freq.put("Sei", 202);
    freq.put("raf", 913);
    freq.put("hud", 233);
    freq.put("rad", 1746);
    freq.put("epu", 3262);
    freq.put("rab", 2634);
    freq.put("rac", 391);
    freq.put("yas", 133);
    freq.put("raa", 1169);
    freq.put("\u4e09", 343);
    freq.put("ral", 1707);
    freq.put("ram", 3117);
    freq.put("raj", 2760);
    freq.put("rak", 4425);
    freq.put("rah", 13007);
    freq.put("rai", 1892);
    freq.put("rav", 203);
    freq.put("raw", 990);
    freq.put("rat", 7211);
    freq.put("rau", 320);
    freq.put("rar", 213);
    freq.put("ras", 4078);
    freq.put("rap", 1559);
    freq.put("raq", 133);
    freq.put("ipi", 916);
    freq.put("rsh", 121);
    freq.put("kna", 192);
    freq.put("raz", 756);
    freq.put("ter", 49142);
    freq.put("ray", 1762);
    freq.put("Ass", 149);
    freq.put(" fa", 1094);
    freq.put("Sya", 1981);
    freq.put("\u30a2", 682);
    freq.put("Sye", 220);
    freq.put("Ast", 233);
    freq.put("do ", 591);
    freq.put("udu", 2586);
    freq.put("thm", 261);
    freq.put("ddi", 484);
    freq.put("a\u0304n", 100);
    freq.put("Sys", 90);
    freq.put("Syr", 106);
    freq.put("Asa", 432);
    freq.put("ogt", 141);
    freq.put(" fe", 189);
    freq.put("Asi", 970);
    freq.put("Ash", 102);
    freq.put("hun", 7536);
    freq.put("nen", 1045);
    freq.put("uju", 2959);
    freq.put("Qu", 662);
    freq.put("thi", 258);
    freq.put("ra ", 25300);
    freq.put("oft", 130);
    freq.put("osg", 503);
    freq.put("Sov", 188);
    freq.put("nel", 1414);
    freq.put("Qa", 209);
    freq.put("gsi", 463);
    freq.put("sud", 961);
    freq.put("bsi", 118);
    freq.put("Qi", 91);
    freq.put("ogr", 689);
    freq.put("sub", 558);
    freq.put("dok", 339);
    freq.put("upu", 963);
    freq.put("don", 9812);
    freq.put("dol", 193);
    freq.put("dom", 753);
    freq.put("nei", 292);
    freq.put("m", 264030);
    freq.put("Ita", 1073);
    freq.put("ogn", 241);
    freq.put("sun", 1377);
    freq.put("dor", 515);
    freq.put("dos", 301);
    freq.put("lpe", 958);
    freq.put("epa", 7540);
    freq.put("dow", 266);
    freq.put("lpa", 103);
    freq.put(" We", 1105);
    freq.put("udd", 449);
    freq.put(" Wa", 2483);
    freq.put(" Wo", 453);
    freq.put("e\u0301r", 118);
    freq.put("d ", 17846);
    freq.put(" Wi", 2169);
    freq.put("rst", 183);
    freq.put("pka", 268);
    freq.put("e\u0301m", 402);
    freq.put("eal", 407);
    freq.put("e\u0301n", 144);
    freq.put("yem", 89);
    freq.put("suh", 294);
    freq.put("e\u0301e", 141);
    freq.put("ih ", 4063);
    freq.put("rta", 6444);
    freq.put("Bin", 573);
    freq.put("Bio", 85);
    freq.put("Bil", 164);
    freq.put("ruk", 474);
    freq.put("em ", 6452);
    freq.put("oco", 179);
    freq.put("hru", 143);
    freq.put("Bid", 98);
    freq.put("sto", 598);
    freq.put("oce", 85);
    freq.put("\u062c", 123);
    freq.put("Bia", 120);
    freq.put("Fo", 867);
    freq.put("hro", 130);
    freq.put("kul", 690);
    freq.put("hri", 265);
    freq.put("ba ", 1121);
    freq.put("ngr", 216);
    freq.put("hre", 90);
    freq.put("kuk", 537);
    freq.put("Bit", 82);
    freq.put("Bir", 213);
    freq.put("Bis", 119);
    freq.put("sur", 1688);
    freq.put("dn", 327);
    freq.put("\u0440", 170);
    freq.put("dl", 344);
    freq.put("dm", 900);
    freq.put("dk", 453);
    freq.put("dh", 461);
    freq.put("di", 100113);
    freq.put("Lui", 82);
    freq.put("dg", 528);
    freq.put("dd", 794);
    freq.put("de", 23626);
    freq.put("db", 909);
    freq.put("dc", 103);
    freq.put("da", 137597);
    freq.put("kug", 115);
    freq.put("tis", 1131);
    freq.put("dz", 256);
    freq.put("ke\u0301m", 368);
    freq.put("dy", 480);
    freq.put("dv", 115);
    freq.put("e\u0301 ", 327);
    freq.put("dt", 171);
    freq.put("du", 14415);
    freq.put("dr", 1709);
    freq.put("ds", 769);
    freq.put(" Ke", 11588);
    freq.put("eme", 4035);
    freq.put("baw", 1427);
    freq.put("bat", 5257);
    freq.put("bau", 218);
    freq.put("bar", 5076);
    freq.put("bas", 903);
    freq.put("bap", 179);
    freq.put("emb", 9560);
    freq.put("Riv", 156);
    freq.put("ner", 1969);
    freq.put("emo", 659);
    freq.put("emi", 3299);
    freq.put("uis", 395);
    freq.put("bay", 335);
    freq.put("PA ", 297);
    freq.put("Rio", 130);
    freq.put("bad", 1572);
    freq.put("bab", 844);
    freq.put("bac", 413);
    freq.put("baa", 211);
    freq.put("ban", 31880);
    freq.put("Rid", 172);
    freq.put("baj", 91);
    freq.put("Ric", 211);
    freq.put("bah", 10190);
    freq.put("Ria", 192);
    freq.put("ggu", 2160);
    freq.put("ua ", 4778);
    freq.put("om ", 1649);
    freq.put("AB ", 193);
    freq.put("w ", 1480);
    freq.put("Pet", 530);
    freq.put("gug", 107);
    freq.put("nut", 397);
    freq.put("nur", 346);
    freq.put("nus", 1343);
    freq.put("Per", 10202);
    freq.put("Pes", 304);
    freq.put("Pel", 589);
    freq.put("Pem", 974);
    freq.put("Pen", 3021);
    freq.put("num", 373);
    freq.put("nuk", 445);
    freq.put("Pej", 89);
    freq.put("Pek", 281);
    freq.put("Ped", 98);
    freq.put("nug", 514);
    freq.put("oma", 1160);
    freq.put("Peg", 132);
    freq.put("nub", 164);
    freq.put("ks ", 713);
    freq.put("mut", 295);
    freq.put("il ", 5677);
    freq.put("Rum", 183);
    freq.put("uso", 135);
    freq.put("eac", 114);
    freq.put("iru", 594);
    freq.put("muz", 686);
    freq.put("un ", 15688);
    freq.put("iri", 4503);
    freq.put("irk", 679);
    freq.put("irl", 158);
    freq.put("irm", 96);
    freq.put("irn", 148);
    freq.put("iro", 343);
    freq.put("rnk", 114);
    freq.put("Rus", 662);
    freq.put("irc", 278);
    freq.put("ird", 90);
    freq.put("ire", 1729);
    freq.put("muk", 990);
    freq.put("irg", 93);
    freq.put("omb", 1378);
    freq.put("we", 3150);
    freq.put("men", 19175);
    freq.put("zah", 203);
    freq.put("wa", 23770);
    freq.put("wo", 532);
    freq.put("wn", 252);
    freq.put(" Ir", 730);
    freq.put(" Is", 3629);
    freq.put(" It", 1183);
    freq.put("Sam", 586);
    freq.put("wi", 8007);
    freq.put("ww", 150);
    freq.put("\u0631\u0629", 90);
    freq.put("wu", 517);
    freq.put(" Ik", 259);
    freq.put("ws", 319);
    freq.put(" Im", 670);
    freq.put(" In", 13399);
    freq.put(" Ia", 4449);
    freq.put("isb", 98);
    freq.put(" Ic", 100);
    freq.put(" Id", 208);
    freq.put("nu ", 1047);
    freq.put("elo", 901);
    freq.put("ema", 5467);
    freq.put("ild", 212);
    freq.put("ile", 5293);
    freq.put("cou", 214);
    freq.put("han", 12119);
    freq.put("ila", 13068);
    freq.put("ilo", 508);
    freq.put("ill", 1539);
    freq.put("ilm", 266);
    freq.put("ilk", 662);
    freq.put("ilh", 97);
    freq.put("ili", 5625);
    freq.put("ade", 739);
    freq.put("ilu", 254);
    freq.put("und", 1844);
    freq.put("kol", 2649);
    freq.put("haa", 110);
    freq.put("ir ", 5942);
    freq.put("gga", 7632);
    freq.put("unj", 444);
    freq.put("unk", 553);
    freq.put("com", 238);
    freq.put("col", 233);
    freq.put("unn", 144);
    freq.put("ily", 94);
    freq.put("kwa", 145);
    freq.put(" me", 61077);
    freq.put(" ma", 9348);
    freq.put("ead", 560);
    freq.put("stm", 167);
    freq.put("elf", 99);
    freq.put(" mo", 1128);
    freq.put(" mi", 1388);
    freq.put("adb", 874);
    freq.put("ie\u0300", 101);
    freq.put("koo", 92);
    freq.put("eld", 531);
    freq.put("hag", 2675);
    freq.put("ggo", 583);
    freq.put("san", 12183);
    freq.put("fra", 229);
    freq.put("eag", 133);
    freq.put("sam", 2727);
    freq.put("fre", 154);
    freq.put("hay", 446);
    freq.put("ggi", 2148);
    freq.put("fri", 738);
    freq.put("C ", 1235);
    freq.put("mbu", 3564);
    freq.put("bni", 142);
    freq.put("sac", 82);
    freq.put("AS ", 389);
    freq.put("sab", 137);
    freq.put("uja", 272);
    freq.put("uve", 119);
    freq.put("Sdn", 124);
    freq.put("ai ", 18726);
    freq.put("rge", 1062);
    freq.put("rhi", 196);
    freq.put("\u0642", 139);
    freq.put(" m ", 97);
    freq.put("Uth", 159);
    freq.put("sso", 702);
    freq.put("saf", 204);
    freq.put("wed", 219);
    freq.put("Cre", 111);
    freq.put("sad", 132);
    freq.put("Cro", 154);
    freq.put("Ci", 1462);
    freq.put("Ch", 3522);
    freq.put("Co", 2781);
    freq.put("uhk", 782);
    freq.put("Cl", 327);
    freq.put("ait", 2354);
    freq.put("Ca", 2733);
    freq.put("gny", 427);
    freq.put("BC ", 165);
    freq.put("aip", 152);
    freq.put("Ce", 818);
    freq.put("n", 737214);
    freq.put("aim", 441);
    freq.put("Cz", 168);
    freq.put("Cy", 178);
    freq.put("ain", 8906);
    freq.put("sli", 668);
    freq.put("aik", 1144);
    freq.put("aij", 188);
    freq.put("Cr", 469);
    freq.put("gni", 98);
    freq.put("aia", 983);
    freq.put("sla", 2463);
    freq.put("Cu", 422);
    freq.put("aib", 213);
    freq.put("Nab", 285);
    freq.put("ix", 314);
    freq.put("iz", 1664);
    freq.put("Nag", 142);
    freq.put("rtu", 2053);
    freq.put("bio", 260);
    freq.put("Naj", 112);
    freq.put("Nak", 108);
    freq.put("is", 34419);
    freq.put("ir", 20180);
    freq.put("Nan", 583);
    freq.put("it", 31463);
    freq.put("iw", 1960);
    freq.put("Za", 844);
    freq.put("Nar", 191);
    freq.put("Nas", 509);
    freq.put("ik", 34589);
    freq.put("ij", 1917);
    freq.put("Nav", 84);
    freq.put("il", 33625);
    freq.put("Nat", 234);
    freq.put("in", 69236);
    freq.put("Naz", 81);
    freq.put("bij", 157);
    freq.put("ic", 6147);
    freq.put("ib", 7125);
    freq.put("ie", 5178);
    freq.put("id", 12680);
    freq.put("ig", 7857);
    freq.put("if", 3795);
    freq.put("V ", 895);
    freq.put("dri", 381);
    freq.put("riv", 103);
    freq.put("Afg", 103);
    freq.put("rnm", 315);
    freq.put("dhi", 87);
    freq.put("\u062d", 205);
    freq.put("dha", 216);
    freq.put("Ika", 175);
    freq.put("sji", 1115);
    freq.put("sau", 293);
    freq.put("ye ", 102);
    freq.put("ep ", 352);
    freq.put("th ", 1378);
    freq.put("\u0441", 230);
    freq.put("nik", 1402);
    freq.put("kiy", 103);
    freq.put("nin", 1570);
    freq.put("dro", 350);
    freq.put("nil", 494);
    freq.put("nim", 789);
    freq.put("kis", 850);
    freq.put("bib", 110);
    freq.put("kip", 238);
    freq.put("nig", 119);
    freq.put("nid", 172);
    freq.put("Ob", 148);
    freq.put("tz ", 139);
    freq.put("niy", 199);
    freq.put("kin", 1562);
    freq.put("kim", 1100);
    freq.put("kil", 906);
    freq.put("Y", 3291);
    freq.put("i ", 164203);
    freq.put("kia", 289);
    freq.put("Dic", 128);
    freq.put("niv", 669);
    freq.put("nit", 1992);
    freq.put("niu", 157);
    freq.put("Va", 902);
    freq.put("Ve", 612);
    freq.put("sme", 415);
    freq.put("Vi", 1229);
    freq.put("ept", 643);
    freq.put(" L ", 153);
    freq.put("thr", 109);
    freq.put("epp", 83);
    freq.put("Vo", 1700);
    freq.put("o\u0302ne", 474);
    freq.put("epo", 201);
    freq.put("ll ", 825);
    freq.put("eph", 179);
    freq.put("epi", 447);
    freq.put("the", 1215);
    freq.put("epe", 2484);
    freq.put("tha", 367);
    freq.put("Co\u0302", 450);
    freq.put("nk ", 304);
    freq.put("gkr", 129);
    freq.put("nya", 20158);
    freq.put("yel", 428);
    freq.put("yen", 1160);
    freq.put("gku", 1265);
    freq.put("rn ", 1339);
    freq.put("yed", 369);
    freq.put("nci", 4468);
    freq.put(" D ", 146);
    freq.put("via", 591);
    freq.put("op ", 434);
    freq.put("lmu", 271);
    freq.put("St ", 234);
    freq.put("yer", 661);
    freq.put("bit", 3310);
    freq.put("hah", 683);
    freq.put("hai", 1915);
    freq.put("haj", 358);
    freq.put("hak", 893);
    freq.put("hal", 1601);
    freq.put("ham", 2871);
    freq.put("Gay", 116);
    freq.put("elm", 87);
    freq.put("elb", 797);
    freq.put("Os", 257);
    freq.put("hab", 563);
    freq.put("ela", 24547);
    freq.put("had", 1334);
    freq.put("Gar", 385);
    freq.put("haf", 92);
    freq.put("bis", 253);
    freq.put("Gan", 153);
    freq.put("Gam", 239);
    freq.put("Gal", 238);
    freq.put("Gaj", 170);
    freq.put("\u0647 ", 83);
    freq.put("hap", 427);
    freq.put("els", 167);
    freq.put("har", 6324);
    freq.put("Gad", 110);
    freq.put("hat", 1258);
    freq.put("Gab", 156);
    freq.put("elt", 96);
    freq.put("haw", 466);
    freq.put("Tri", 323);
    freq.put("opu", 974);
    freq.put("rni", 698);
    freq.put("rno", 175);
    freq.put("D", 19572);
    freq.put("Tro", 148);
    freq.put("ops", 100);
    freq.put("Tra", 341);
    freq.put("emu", 2900);
    freq.put("rna", 2876);
    freq.put("Tre", 155);
    freq.put("rnf", 173);
    freq.put("rne", 905);
    freq.put("sku", 127);
    freq.put("ope", 851);
    freq.put("rny", 606);
    freq.put("opa", 651);
    freq.put("opl", 109);
    freq.put("ub ", 287);
    freq.put("opo", 452);
    freq.put("oph", 272);
    freq.put("opi", 468);
    freq.put("sma", 631);
    freq.put("vir", 115);
    freq.put("mir", 325);
    freq.put("Art", 249);
    freq.put("rke", 2263);
    freq.put("ha ", 1152);
    freq.put("gke", 128);
    freq.put("el ", 2913);
    freq.put("sk ", 160);
    freq.put("tro", 1657);
    freq.put("mit", 382);
    freq.put("Ara", 1408);
    freq.put("Ard", 238);
    freq.put("Are", 112);
    freq.put("Arg", 299);
    freq.put("Ari", 140);
    freq.put("bn ", 236);
    freq.put("Arm", 211);
    freq.put("rka", 6421);
    freq.put("ola", 3886);
    freq.put("old", 231);
    freq.put("dus", 523);
    freq.put("MP ", 115);
    freq.put(" Ju", 2140);
    freq.put("oli", 2647);
    freq.put(" X ", 203);
    freq.put("oll", 548);
    freq.put("olo", 2453);
    freq.put(" Jo", 1631);
    freq.put("ols", 765);
    freq.put(" Ji", 422);
    freq.put("olu", 604);
    freq.put(" Je", 6459);
    freq.put(" Ja", 4925);
    freq.put("ick", 394);
    freq.put("rg ", 2166);
    freq.put("Leb", 345);
    freq.put("Hy", 124);
    freq.put("ico", 699);
    freq.put("Lee", 107);
    freq.put("for", 1053);
    freq.put("tei", 1032);
    freq.put("ica", 1361);
    freq.put("mu ", 410);
    freq.put("Lem", 434);
    freq.put("Len", 99);
    freq.put("Hu", 2027);
    freq.put("Lep", 84);
    freq.put("Hi", 2278);
    freq.put("uma", 2885);
    freq.put("Ho", 2093);
    freq.put("umb", 3220);
    freq.put("ics", 105);
    freq.put("icr", 152);
    freq.put("\u0627\u0646 ", 99);
    freq.put("Ha", 4713);
    freq.put("umi", 1006);
    freq.put("icu", 180);
    freq.put("He", 1106);
    freq.put("ol ", 1539);
    freq.put("sa ", 16822);
    freq.put("hsi", 131);
    freq.put(" fl", 155);
    freq.put("ril", 887);
    freq.put("ple", 359);
    freq.put("pla", 686);
    freq.put("eed", 132);
    freq.put("plo", 124);
    freq.put(" J ", 133);
    freq.put("pli", 230);
    freq.put("Le ", 130);
    freq.put("obo", 201);
    freq.put("obl", 99);
    freq.put("obj", 270);
    freq.put("eat", 650);
    freq.put("obi", 241);
    freq.put("ic ", 717);
    freq.put("o", 176914);
    freq.put("oba", 366);
    freq.put("um ", 5354);
    freq.put("zue", 132);
    freq.put("own", 225);
    freq.put("meg", 240);
    freq.put("H ", 344);
    freq.put("lm ", 121);
    freq.put("okt", 111);
    freq.put("soa", 82);
    freq.put("Fed", 85);
    freq.put("aha", 18129);
    freq.put("Feb", 550);
    freq.put("chu", 185);
    freq.put("kh ", 421);
    freq.put("ahe", 94);
    freq.put("yid", 111);
    freq.put("ahk", 975);
    freq.put("Fel", 252);
    freq.put("ahi", 2365);
    freq.put("ahn", 440);
    freq.put("sol", 388);
    freq.put("ahl", 1517);
    freq.put("ahm", 450);
    freq.put("ahr", 292);
    freq.put("ahs", 174);
    freq.put("sos", 286);
    freq.put("igo", 173);
    freq.put("Fer", 162);
    freq.put("ahw", 146);
    freq.put("ahu", 8672);
    freq.put("IV ", 93);
    freq.put("ahy", 162);
    freq.put(" Ev", 109);
    freq.put("mbr", 177);
    freq.put("ole", 11812);
    freq.put("tem", 4640);
    freq.put("ne\u0301", 180);
    freq.put("giu", 105);
    freq.put("git", 589);
    freq.put("gis", 912);
    freq.put("gir", 419);
    freq.put("wai", 624);
    freq.put("wah", 1233);
    freq.put("az ", 156);
    freq.put("wab", 269);
    freq.put("gig", 81);
    freq.put("gic", 109);
    freq.put(" Er", 725);
    freq.put("gia", 2714);
    freq.put("gio", 226);
    freq.put("gin", 1308);
    freq.put("gim", 123);
    freq.put("gil", 557);
    freq.put("gik", 836);
    freq.put("iq ", 87);
    freq.put("ten", 10423);
    freq.put("khi", 1569);
    freq.put(" Se", 15446);
    freq.put("ah ", 102722);
    freq.put("\u0442", 130);
    freq.put("ure", 519);
    freq.put("mb ", 646);
    freq.put("low", 135);
    freq.put("nke", 98);
    freq.put("deg", 127);
    freq.put("Z", 1931);
    freq.put("dka", 218);
    freq.put("azh", 86);
    freq.put("azi", 1065);
    freq.put("Vol", 89);
    freq.put("aza", 605);
    freq.put("urc", 329);
    freq.put("aze", 259);
    freq.put("wa ", 2659);
    freq.put("mmi", 85);
    freq.put("Vor", 961);
    freq.put("Vos", 513);
    freq.put("olt", 108);
    freq.put("rej", 223);
    freq.put("urn", 367);
    freq.put("Sis", 302);
    freq.put("Sir", 341);
    freq.put("rif", 442);
    freq.put("Sip", 89);
    freq.put("u\u0308r", 122);
    freq.put("nni", 227);
    freq.put("Sit", 261);
    freq.put("aun", 617);
    freq.put("nne", 1190);
    freq.put("kht", 143);
    freq.put("khu", 413);
    freq.put("nna", 293);
    freq.put("uri", 1172);
    freq.put("u\u0308g", 114);
    freq.put("u\u0308d", 115);
    freq.put("khl", 192);
    freq.put(" Li", 1930);
    freq.put("Sie", 82);
    freq.put("Sid", 166);
    freq.put("Sik", 106);
    freq.put("kha", 646);
    freq.put("khb", 203);
    freq.put("urk", 876);
    freq.put("Sin", 1116);
    freq.put("Sim", 492);
    freq.put("Sil", 414);
    freq.put("nh", 406);
    freq.put("ni", 30289);
    freq.put("nj", 7927);
    freq.put("nk", 2659);
    freq.put("nl", 387);
    freq.put("nm", 699);
    freq.put("nn", 4359);
    freq.put("no", 5581);
    freq.put("tit", 1049);
    freq.put("na", 48153);
    freq.put("nb", 1690);
    freq.put("nc", 10083);
    freq.put("nd", 46633);
    freq.put("ne", 28218);
    freq.put("nf", 758);
    freq.put("ng", 182026);
    freq.put("zik", 1108);
    freq.put("ny", 25233);
    freq.put("nz", 372);
    freq.put("\u0627\u0644", 473);
    freq.put("tih", 1384);
    freq.put("reh", 132);
    freq.put("np", 780);
    freq.put("tie", 154);
    freq.put("nr", 1326);
    freq.put("ns", 10123);
    freq.put("nt", 38718);
    freq.put("nu", 8816);
    freq.put("nv", 296);
    freq.put("nw", 221);
    freq.put("\u0641", 123);
    freq.put("fot", 84);
    freq.put("E", 5893);
    freq.put("urr", 119);
    freq.put("\u30a2\u30a2", 532);
    freq.put(" na", 3187);
    freq.put("put", 1968);
    freq.put("urs", 201);
    freq.put("Idr", 97);
    freq.put("ici", 517);
    freq.put("nn ", 167);
    freq.put(" ny", 301);
    freq.put("ich", 943);
    freq.put("tec", 87);
    freq.put("rei", 890);
    freq.put("\u0259", 85);
    freq.put("taw", 490);
    freq.put(" nu", 298);
    freq.put("ump", 3501);
    freq.put("n ", 280458);
    freq.put("Win", 285);
    freq.put("Wil", 1358);
    freq.put("Wik", 155);
    freq.put("Wit", 159);
    freq.put("kho", 147);
    freq.put("fsw", 151);
    freq.put("rk ", 625);
    freq.put("ti ", 8689);
    freq.put("nku", 327);
    freq.put("roh", 152);
    freq.put("roi", 110);
    freq.put("roj", 312);
    freq.put("rok", 385);
    freq.put("rol", 484);
    freq.put("rom", 519);
    freq.put("ron", 1956);
    freq.put("roo", 126);
    freq.put("lls", 96);
    freq.put("roa", 181);
    freq.put("rob", 171);
    freq.put("o\u0308rd", 174);
    freq.put("rod", 471);
    freq.put("roe", 206);
    freq.put("rof", 362);
    freq.put("rog", 606);
    freq.put("osi", 886);
    freq.put("osh", 144);
    freq.put("osk", 108);
    freq.put("llo", 405);
    freq.put("ice", 662);
    freq.put("oso", 466);
    freq.put("rop", 1379);
    freq.put("ror", 104);
    freq.put("Leo", 109);
    freq.put("rot", 661);
    freq.put("rou", 319);
    freq.put("rov", 4057);
    freq.put("row", 385);
    freq.put("Aqu", 111);
    freq.put("Dae", 1400);
    freq.put("vet", 142);
    freq.put("Dag", 88);
    freq.put("ver", 1914);
    freq.put("ves", 180);
    freq.put("pem", 3764);
    freq.put("Dal", 1240);
    freq.put("Dam", 225);
    freq.put("Dan", 256);
    freq.put("tka", 3394);
    freq.put("Dah", 132);
    freq.put("Dai", 144);
    freq.put("lly", 170);
    freq.put("rel", 624);
    freq.put("Dat", 1195);
    freq.put("Dau", 165);
    freq.put("Dav", 161);
    freq.put("Les", 206);
    freq.put("\u0634", 82);
    freq.put("Dar", 1495);
    freq.put("Das", 103);
    freq.put("ven", 1162);
    freq.put("vel", 571);
    freq.put("vem", 496);
    freq.put("Day", 273);
    freq.put("oid", 154);
    freq.put(" do", 472);
    freq.put("ey ", 956);
    freq.put("ro ", 1007);
    freq.put("hul", 645);
    freq.put("Cin", 942);
    freq.put("Cir", 82);
    freq.put("erw", 586);
    freq.put("Cit", 148);
    freq.put("erp", 1899);
    freq.put("gla", 485);
    freq.put("fon", 311);
    freq.put("Tat", 100);
    freq.put("Tau", 110);
    freq.put("gua", 691);
    freq.put("Taw", 155);
    freq.put("Tap", 195);
    freq.put("dii", 332);
    freq.put("Tar", 410);
    freq.put("Tas", 214);
    freq.put("guk", 111);
    freq.put("die", 663);
    freq.put("gui", 166);
    freq.put("ers", 7669);
    freq.put("gun", 5744);
    freq.put("gum", 149);
    freq.put("gul", 272);
    freq.put("gus", 381);
    freq.put("p", 194581);
    freq.put("umk", 95);
    freq.put("Tab", 349);
    freq.put("gut", 128);
    freq.put("Kun", 284);
    freq.put("Tam", 976);
    freq.put("Tan", 1919);
    freq.put("ict", 304);
    freq.put("Tah", 219);
    freq.put("Tai", 272);
    freq.put("Taj", 110);
    freq.put("Tak", 203);
    freq.put("ruj", 1475);
    freq.put("hte", 100);
    freq.put("klo", 121);
    freq.put("M ", 4357);
    freq.put("hta", 151);
    freq.put("be", 37633);
    freq.put("Res", 223);
    freq.put("Rep", 799);
    freq.put("Rev", 110);
    freq.put(" Ye", 195);
    freq.put("Rek", 84);
    freq.put("uk ", 13558);
    freq.put("Gre", 1162);
    freq.put("Ren", 489);
    freq.put("erz", 234);
    freq.put("Gra", 462);
    freq.put("Gro", 225);
    freq.put("dew", 286);
    freq.put(" Yu", 587);
    freq.put("Red", 114);
    freq.put("erd", 5231);
    freq.put("Qur", 321);
    freq.put("rul", 804);
    freq.put("klu", 484);
    freq.put("ek ", 1904);
    freq.put("rub", 489);
    freq.put("Que", 146);
    freq.put("ruc", 88);
    freq.put("e\u0300re", 118);
    freq.put("bn", 513);
    freq.put("era", 31612);
    freq.put("Me", 9475);
    freq.put("ngd", 572);
    freq.put("bo", 5898);
    freq.put("Ma", 21779);
    freq.put("erb", 21481);
    freq.put("Mc", 109);
    freq.put("ht ", 578);
    freq.put("ruf", 342);
    freq.put("Mo", 3221);
    freq.put("erc", 938);
    freq.put("Mi", 2501);
    freq.put("Aga", 333);
    freq.put("Bou", 267);
    freq.put("Mu", 4039);
    freq.put("gle", 434);
    freq.put("O", 4712);
    freq.put("erm", 8575);
    freq.put("Agu", 275);
    freq.put("My", 256);
    freq.put(" du", 2752);
    freq.put("or ", 5219);
    freq.put("ksp", 152);
    freq.put("eko", 2990);
    freq.put("ekn", 672);
    freq.put("ugi", 310);
    freq.put("dec", 284);
    freq.put("eki", 1159);
    freq.put(" ok", 83);
    freq.put("erh", 2054);
    freq.put("bor", 733);
    freq.put("bot", 679);
    freq.put("bou", 178);
    freq.put("eka", 5600);
    freq.put("boh", 101);
    freq.put("ngl", 959);
    freq.put("boj", 88);
    freq.put("bok", 140);
    freq.put("bol", 2635);
    freq.put("bom", 143);
    freq.put("bon", 529);
    freq.put("jaw", 545);
    freq.put("eku", 1531);
    freq.put("ekt", 1163);
    freq.put("eks", 1079);
    freq.put("ngn", 355);
    freq.put("tne", 114);
    freq.put("ugh", 152);
    freq.put("ard", 1182);
    freq.put("ipa", 5888);
    freq.put("Bon", 245);
    freq.put("ipe", 1538);
    freq.put(" it", 1237);
    freq.put("bs", 314);
    freq.put("ipo", 113);
    freq.put("ipl", 145);
    freq.put("ngi", 2924);
    freq.put("ips", 84);
    freq.put("ipp", 136);
    freq.put("Lig", 184);
    freq.put("ngj", 195);
    freq.put("ipt", 701);
    freq.put("ipu", 557);
    freq.put("ngk", 8614);
    freq.put("rup", 29747);
    freq.put("ugo", 103);
    freq.put("Lia", 116);
    freq.put("zi ", 161);
    freq.put("kse", 201);
    freq.put("ayo", 257);
    freq.put(" Ka", 14783);
    freq.put("ayi", 95);
    freq.put(" Kg", 139);
    freq.put("ae ", 779);
    freq.put("aye", 177);
    freq.put(" Kh", 876);
    freq.put(" Ki", 2005);
    freq.put("aya", 15557);
    freq.put(" Ko", 4376);
    freq.put(" Kl", 380);
    freq.put(" Kr", 939);
    freq.put("Ogo", 658);
    freq.put("Uda", 328);
    freq.put("zza", 91);
    freq.put("Abi", 121);
    freq.put("ayu", 2352);
    freq.put("ksa", 750);
    freq.put("ent", 11262);
    freq.put("ca ", 950);
    freq.put("Lin", 364);
    freq.put("ays", 11200);
    freq.put("jak", 1017);
    freq.put("Bek", 161);
    freq.put("ip ", 575);
    freq.put("Bei", 136);
    freq.put("Ben", 734);
    freq.put(" in", 10019);
    freq.put("Bel", 2825);
    freq.put("F", 8324);
    freq.put("Beb", 103);
    freq.put("ool", 149);
    freq.put("Bea", 159);
    freq.put("ook", 216);
    freq.put("ma ", 13530);
    freq.put("oot", 168);
    freq.put(" ia", 15199);
    freq.put("Ber", 2024);
    freq.put("Bes", 855);
    freq.put(" ib", 1091);
    freq.put("Bet", 145);
    freq.put("Rom", 673);
    freq.put("ibi", 920);
    freq.put("cay", 362);
    freq.put("uly", 87);
    freq.put("ibl", 93);
    freq.put("ibn", 261);
    freq.put("ibo", 150);
    freq.put("cas", 256);
    freq.put("car", 3573);
    freq.put("ibb", 83);
    freq.put("cap", 475);
    freq.put("ay ", 1141);
    freq.put("cau", 90);
    freq.put("cat", 393);
    freq.put("cak", 355);
    freq.put("fli", 95);
    freq.put("cai", 202);
    freq.put("cah", 474);
    freq.put("can", 1363);
    freq.put("cam", 7892);
    freq.put("cal", 653);
    freq.put("cac", 97);
    freq.put("cab", 306);
    freq.put("ibr", 155);
    freq.put("jaa", 1731);
    freq.put("ibu", 1830);
    freq.put("cad", 172);
    freq.put(" on", 137);
    freq.put("va ", 432);
    freq.put("Mik", 122);
    freq.put("idu", 1218);
    freq.put("kyo", 126);
    freq.put("Mil", 498);
    freq.put("Min", 689);
    freq.put(" of", 1351);
    freq.put("dil", 2398);
    freq.put("Mic", 276);
    freq.put("uan", 6824);
    freq.put(" ob", 344);
    freq.put("Mid", 149);
    freq.put("spi", 326);
    freq.put("spo", 247);
    freq.put("spa", 153);
    freq.put("Mis", 255);
    freq.put("Mir", 149);
    freq.put(" or", 3496);
    freq.put("Mit", 90);
    freq.put(" op", 389);
    freq.put("ido", 222);
    freq.put("Pyr", 101);
    freq.put("rvi", 143);
    freq.put("nyu", 376);
    freq.put("kro", 241);
    freq.put("gh ", 228);
    freq.put("nyo", 518);
    freq.put("arj", 275);
    freq.put("mel", 2698);
    freq.put("yll", 91);
    freq.put("s ", 44138);
    freq.put("oss", 236);
    freq.put("naa", 932);
    freq.put("map", 110);
    freq.put("mas", 5847);
    freq.put("sne", 275);
    freq.put("mau", 220);
    freq.put("din", 2811);
    freq.put("ena", 10322);
    freq.put("one", 9980);
    freq.put("upe", 318);
    freq.put("ky ", 133);
    freq.put("sni", 143);
    freq.put("maa", 523);
    freq.put(" co", 867);
    freq.put("mac", 144);
    freq.put("enc", 2582);
    freq.put("aos", 96);
    freq.put("mad", 1643);
    freq.put("mag", 284);
    freq.put("ylo", 98);
    freq.put(" oc", 95);
    freq.put("neg", 5789);
    freq.put("mak", 2827);
    freq.put("maj", 1120);
    freq.put("mam", 694);
    freq.put("mal", 1537);
    freq.put("sny", 1578);
    freq.put("ght", 623);
    freq.put("ghu", 271);
    freq.put("sy", 3492);
    freq.put("ide", 1853);
    freq.put("ss", 3665);
    freq.put("sr", 496);
    freq.put("sp", 2237);
    freq.put("sw", 1296);
    freq.put("gea", 90);
    freq.put("su", 13746);
    freq.put("st", 16805);
    freq.put("q", 1773);
    freq.put("sj", 1138);
    freq.put("si", 55053);
    freq.put("sh", 2942);
    freq.put("so", 3953);
    freq.put("sn", 2184);
    freq.put("sm", 1932);
    freq.put("sl", 3506);
    freq.put("sc", 1307);
    freq.put("sb", 776);
    freq.put("sa", 62323);
    freq.put("sg", 539);
    freq.put("sf", 360);
    freq.put("se", 78194);
    freq.put("sd", 136);
    freq.put("Ru", 1209);
    freq.put("enk", 219);
    freq.put("Che", 558);
    freq.put("Jay", 337);
    freq.put("Chi", 1206);
    freq.put("ttp", 95);
    freq.put("Jar", 133);
    freq.put("Cho", 141);
    freq.put("Jan", 881);
    freq.put("Re", 2654);
    freq.put("Chr", 187);
    freq.put("Jam", 523);
    freq.put("tto", 116);
    freq.put("Ra", 4724);
    freq.put("ttl", 217);
    freq.put("dem", 474);
    freq.put("\u4e18", 125);
    freq.put("tta", 304);
    freq.put("Ro", 2065);
    freq.put("Jab", 343);
    freq.put("Jac", 170);
    freq.put("tte", 701);
    freq.put("sod", 99);
    freq.put("Rhi", 1420);
    freq.put("jid", 1157);
    freq.put(" ac", 279);
    freq.put("jib", 155);
    freq.put("ppe", 181);
    freq.put("TP ", 81);
    freq.put("jin", 516);
    freq.put(" ai", 662);
    freq.put("jil", 131);
    freq.put(" ak", 2442);
    freq.put(" al", 2643);
    freq.put("jik", 249);
    freq.put(" an", 6006);
    freq.put("gto", 99);
    freq.put("\u03b1", 136);
    freq.put(" ar", 1148);
    freq.put(" as", 1761);
    freq.put("jir", 304);
    freq.put("jis", 137);
    freq.put(" aw", 789);
    freq.put(" ay", 339);
    freq.put("gel", 1459);
    freq.put("dij", 600);
    freq.put("enu", 2960);
    freq.put("nol", 621);
    freq.put("nom", 1343);
    freq.put("non", 340);
    freq.put("usa", 3092);
    freq.put("noh", 123);
    freq.put("Kau", 151);
    freq.put("ls ", 210);
    freq.put("\u0648", 473);
    freq.put("uge", 603);
    freq.put("Kat", 284);
    freq.put("sle", 93);
    freq.put("mba", 6501);
    freq.put("Sha", 998);
    freq.put(" we", 290);
    freq.put("R ", 526);
    freq.put("She", 230);
    freq.put("eny", 4231);
    freq.put("not", 257);
    freq.put("Shi", 244);
    freq.put("nov", 416);
    freq.put(" us", 324);
    freq.put("kka", 941);
    freq.put("enz", 142);
    freq.put("nor", 470);
    freq.put("Sho", 202);
    freq.put(" a ", 258);
    freq.put("per", 20160);
    freq.put("ji ", 1240);
    freq.put("sop", 111);
    freq.put("eru", 33986);
    freq.put("tti", 139);
    freq.put("sor", 696);
    freq.put("did", 1487);
    freq.put("uba", 1808);
    freq.put("ony", 334);
    freq.put("mem", 9158);
    freq.put("fen", 164);
    freq.put("em", 39155);
    freq.put("el", 48944);
    freq.put("eo", 5366);
    freq.put("en", 99039);
    freq.put("ei", 5276);
    freq.put("eh", 14770);
    freq.put("ek", 16873);
    freq.put("ej", 6455);
    freq.put("Ru\u0308", 119);
    freq.put("ed", 9261);
    freq.put("eg", 12184);
    freq.put("ef", 868);
    freq.put("ea", 5087);
    freq.put("rl ", 182);
    freq.put("ec", 13590);
    freq.put("eb", 49697);
    freq.put("Lua", 151);
    freq.put("Lub", 167);
    freq.put("Luc", 91);
    freq.put("ey", 1335);
    freq.put("ex", 782);
    freq.put("ez", 1091);
    freq.put("eu", 1721);
    freq.put("ft", 567);
    freq.put("ew", 3500);
    freq.put("ev", 2199);
    freq.put("eq", 83);
    freq.put("ep", 15359);
    freq.put("es", 39797);
    freq.put("er", 193978);
    freq.put("Ken", 331);
    freq.put("Kem", 873);
    freq.put("Jos", 163);
    freq.put("Kej", 260);
    freq.put("gaj", 331);
    freq.put("eje", 2245);
    freq.put("Su\u0308", 116);
    freq.put("Kec", 1697);
    freq.put("Keb", 1923);
    freq.put("Kea", 187);
    freq.put("nsu", 721);
    freq.put("\u0633", 358);
    freq.put("bli", 991);
    freq.put("dif", 84);
    freq.put("os ", 2032);
    freq.put("Joh", 1111);
    freq.put("eju", 647);
    freq.put("Ket", 677);
    freq.put("Kes", 641);
    freq.put("Ker", 1245);
    freq.put("Kep", 862);
    freq.put("rlo", 176);
    freq.put("gai", 9563);
    freq.put("tif", 1686);
    freq.put("G", 10072);
    freq.put("ory", 594);
    freq.put("rle", 19283);
    freq.put("rld", 143);
    freq.put("ort", 1677);
    freq.put("oru", 170);
    freq.put("rla", 1739);
    freq.put("e ", 34293);
    freq.put("orp", 1180);
    freq.put("orn", 616);
    freq.put(" i ", 105);
    freq.put("orl", 178);
    freq.put("dig", 2704);
    freq.put("ork", 389);
    freq.put("ori", 1675);
    freq.put("rlu", 660);
    freq.put("org", 773);
    freq.put("ord", 1125);
    freq.put("ore", 1134);
    freq.put("orb", 185);
    freq.put("orc", 95);
    freq.put("ora", 7028);
    freq.put("cem", 134);
    freq.put("gah", 4102);
    freq.put("Apr", 696);
    freq.put("ume", 429);
    freq.put("yus", 82);
    freq.put("yur", 228);
    freq.put("ej ", 300);
    freq.put("Api", 115);
    freq.put("yum", 99);
    freq.put("lla", 1553);
    freq.put("yun", 210);
    freq.put("yua", 148);
    freq.put("Apa", 124);
    freq.put(" ce", 822);
    freq.put("\u064a ", 156);
    freq.put("ski", 268);
    freq.put("onj", 101);
    freq.put("onk", 139);
    freq.put("zal", 148);
    freq.put("xi", 565);
    freq.put("hu ", 365);
    freq.put("xo", 133);
    freq.put("lfo", 84);
    freq.put("onc", 169);
    freq.put("xa", 185);
    freq.put("onf", 186);
    freq.put("rgu", 308);
    freq.put("ond", 1093);
    freq.put("xe", 102);
    freq.put("Yam", 136);
    freq.put("Yan", 424);
    freq.put("Yah", 251);
    freq.put("lau", 5752);
    freq.put("ons", 1416);
    freq.put("onv", 152);
    freq.put("xt", 102);
    freq.put("Eur", 130);
    freq.put("iam", 821);
    freq.put("IM ", 85);
    freq.put("ian", 10128);
    freq.put("iai", 1585);
    freq.put("iah", 796);
    freq.put("iak", 522);
    freq.put("yim", 134);
    freq.put("iad", 926);
    freq.put("iag", 345);
    freq.put("yin", 165);
    freq.put("iaa", 121);
    freq.put("dib", 2542);
    freq.put("iac", 153);
    freq.put("ovo", 102);
    freq.put("uko", 385);
    freq.put("ukn", 323);
    freq.put("ukl", 355);
    freq.put("ukk", 353);
    freq.put("lar", 2085);
    freq.put("uki", 2400);
    freq.put("ukh", 102);
    freq.put("iau", 2147);
    freq.put("iat", 661);
    freq.put("iaw", 324);
    freq.put("Dou", 90);
    freq.put("iap", 745);
    freq.put("ias", 2287);
    freq.put("iar", 1823);
    freq.put("Co\u0302t", 448);
    freq.put(" Zo", 131);
    freq.put("ebo", 229);
    freq.put(" Zi", 163);
    freq.put("hua", 247);
    freq.put("hub", 485);
    freq.put(" Ze", 341);
    freq.put("hum", 860);
    freq.put("x ", 1392);
    freq.put("dic", 635);
    freq.put(" Za", 841);
    freq.put("hui", 194);
    freq.put("huj", 251);
    freq.put("huk", 240);
    freq.put("hut", 907);
    freq.put("hup", 170);
    freq.put("hur", 599);
    freq.put("hus", 555);
    freq.put(" Zu", 270);
    freq.put(" ya", 44378);
    freq.put("wau", 86);
    freq.put("wat", 2105);
    freq.put("yi ", 1148);
    freq.put("rzo", 153);
    freq.put("ho\u0302n", 460);
    freq.put("ia ", 33962);
    freq.put("war", 2035);
    freq.put("\u0646 ", 270);
    freq.put("r", 438412);
    freq.put("nie", 150);
    freq.put("ehe", 137);
    freq.put(" \u30a2\u30a2", 100);
    freq.put("ost", 425);
    freq.put("and", 21721);
    freq.put("ane", 1046);
    freq.put("sai", 2187);
    freq.put("ang", 113274);
    freq.put("pra", 188);
    freq.put("ana", 12204);
    freq.put("anb", 114);
    freq.put("anc", 5840);
    freq.put("anl", 96);
    freq.put("anm", 135);
    freq.put("ann", 2528);
    freq.put("ano", 698);
    freq.put("pri", 989);
    freq.put("ani", 5398);
    freq.put("anj", 3436);
    freq.put("ank", 1191);
    freq.put("ant", 12519);
    freq.put("anu", 3170);
    freq.put("say", 288);
    freq.put("anp", 517);
    freq.put("ry ", 1503);
    freq.put("ans", 983);
    freq.put("sas", 1598);
    freq.put("sar", 5174);
    freq.put("sap", 108);
    freq.put("saw", 965);
    freq.put("any", 7283);
    freq.put("anz", 119);
    freq.put("sat", 8021);
    freq.put("Do", 1267);
    freq.put("Phi", 161);
    freq.put("rmi", 310);
    freq.put("Dh", 92);
    freq.put("Di", 4070);
    freq.put("sew", 140);
    freq.put("De", 3041);
    freq.put("Eck", 180);
    freq.put("zon", 176);
    freq.put("Da", 7113);
    freq.put("gki", 641);
    freq.put("ax ", 100);
    freq.put("2", 570);
    freq.put("\u0435", 192);
    freq.put("wer", 159);
    freq.put("gko", 307);
    freq.put("gka", 6162);
    freq.put("tny", 365);
    freq.put("vas", 121);
    freq.put("Du", 1497);
    freq.put("Dr", 1224);
    freq.put("ts ", 530);
    freq.put(" Ca", 2706);
    freq.put("an ", 229755);
    freq.put("iwa", 1799);
    freq.put("tiu", 167);
    freq.put("egl", 90);
    freq.put("udo", 102);
    freq.put("uya", 163);
    freq.put("uih", 107);
    freq.put("net", 1133);
    freq.put("\u4e59", 83);
    freq.put(" Ce", 812);
    freq.put("pec", 204);
    freq.put(" Le", 2143);
    freq.put(" ag", 1211);
    freq.put("dle", 103);
    freq.put(" La", 11856);
    freq.put("uss", 842);
    freq.put(" Lo", 3490);
    freq.put("\u0633\u0648", 84);
    freq.put("D ", 620);
    freq.put("\u062f ", 141);
    freq.put("wia", 82);
    freq.put("\u0627\u0646", 141);
    freq.put(" Lu", 2053);
    freq.put(" Cy", 178);
    freq.put("tze", 150);
    freq.put("neu", 163);
    freq.put(" Ly", 128);
    freq.put("\u1100\u1161", 342);
    freq.put("SI ", 111);
    freq.put("kas", 2281);
    freq.put("fes", 299);
    freq.put("zec", 167);
    freq.put("Wei", 137);
    freq.put("Wes", 721);
    freq.put("ch ", 1178);
    freq.put("ge ", 840);
    freq.put("lay", 19664);
    freq.put("dy ", 371);
    freq.put("ss ", 420);
    freq.put("Lim", 361);
    freq.put("We", 1119);
    freq.put("Ula", 82);
    freq.put("uh ", 2913);
    freq.put("Wa", 2486);
    freq.put("lua", 5030);
    freq.put("Wo", 465);
    freq.put("iti", 5204);
    freq.put("lub", 115);
    freq.put("Wi", 2174);
    freq.put("Wh", 136);
    freq.put("sou", 89);
    freq.put("\u0430", 416);
    freq.put("dio", 830);
    freq.put("nsb", 162);
    freq.put("yle", 84);
    freq.put("lud", 118);
    freq.put("pti", 180);
    freq.put("BN ", 115);
    freq.put("ino", 771);
    freq.put("ges", 802);
    freq.put(" pr", 3226);
    freq.put(" pu", 2878);
    freq.put("get", 640);
    freq.put("H", 13017);
    freq.put(" px", 487);
    freq.put("ere", 4833);
    freq.put("yal", 266);
    freq.put("geb", 235);
    freq.put(" pa", 17415);
    freq.put("uta", 5785);
    freq.put("ssi", 559);
    freq.put(" pe", 36568);
    freq.put("ged", 153);
    freq.put("gek", 139);
    freq.put("dit", 5839);
    freq.put(" pi", 1442);
    freq.put(" po", 3206);
    freq.put("gen", 3765);
    freq.put("RI ", 158);
    freq.put(" pl", 444);
    freq.put("luk", 1418);
    freq.put("ng ", 99565);
    freq.put("W ", 157);
    freq.put("ute", 2173);
    freq.put("lum", 2206);
    freq.put("sum", 580);
    freq.put("iqu", 224);
    freq.put("o\u0301", 201);
    freq.put("idz", 82);
    freq.put("diu", 557);
    freq.put("ix ", 251);
    freq.put("uti", 1850);
    freq.put("lny", 581);
    freq.put("rmu", 1254);
    freq.put(" \u0627\u0644", 410);
    freq.put("cio", 99);
    freq.put("kem", 2040);
    freq.put("cin", 441);
    freq.put("rma", 7923);
    freq.put("div", 279);
    freq.put("rme", 289);
    freq.put("tu ", 13080);
    freq.put("fol", 96);
    freq.put("cil", 1184);
    freq.put("j ", 686);
    freq.put("rmo", 257);
    freq.put("cis", 3697);
    freq.put("nis", 5362);
    freq.put("cir", 431);
    freq.put("its", 183);
    freq.put("cip", 618);
    freq.put("yti", 119);
    freq.put("rko", 237);
    freq.put("fo\u0308r", 174);
    freq.put("Awa", 270);
    freq.put("civ", 87);
    freq.put("nka", 1483);
    freq.put("fir", 98);
    freq.put("ked", 1408);
    freq.put("utt", 161);
    freq.put("\u0647", 177);
    freq.put("uns", 519);
    freq.put("tup", 264);
    freq.put("ju", 11519);
    freq.put("tur", 2470);
    freq.put("gi ", 7590);
    freq.put("tut", 762);
    freq.put("ro\u0308", 281);
    freq.put("jr", 154);
    freq.put("uth", 367);
    freq.put("jl", 522);
    freq.put("dip", 2297);
    freq.put("rm ", 579);
    freq.put("jo", 1281);
    freq.put("tul", 1448);
    freq.put("ji", 4809);
    freq.put("tun", 1428);
    freq.put("je", 4970);
    freq.put("tub", 1391);
    freq.put("Kra", 141);
    freq.put("nsi", 4092);
    freq.put("ja", 22803);
    freq.put("Kre", 356);
    freq.put(" be", 24484);
    freq.put("tuh", 346);
    freq.put("ros", 1224);
    freq.put("uf", 806);
    freq.put(" ba", 24359);
    freq.put("wel", 124);
    freq.put("uka", 5655);
    freq.put(" bl", 104);
    freq.put(" bo", 2914);
    freq.put(" bi", 4229);
    freq.put("P ", 1043);
    freq.put(" bu", 4711);
    freq.put("fiz", 345);
    freq.put("s", 303833);
    freq.put("Kri", 351);
    freq.put("iv", 2344);
    freq.put("o\u0308e ", 241);
    freq.put(" br", 115);
    freq.put("tum", 1714);
    freq.put("nno", 98);
    freq.put("uci", 281);
    freq.put("unu", 1520);
    freq.put("yon", 283);
    freq.put("yn ", 94);
    freq.put("pot", 165);
    freq.put("pou", 100);
    freq.put("por", 689);
    freq.put("dir", 2791);
    freq.put("pop", 931);
    freq.put("ue ", 523);
    freq.put("pon", 661);
    freq.put("kew", 229);
    freq.put("pol", 1646);
    freq.put("pom", 970);
    freq.put("pok", 948);
    freq.put("poh", 486);
    freq.put("tua", 2911);
    freq.put("oon", 251);
    freq.put("tib", 138);
    freq.put("fic", 314);
    freq.put("Bur", 1072);
    freq.put("kes", 1492);
    freq.put("dis", 3174);
    freq.put("But", 135);
    freq.put("tue", 190);
    freq.put("ih", 7528);
    freq.put("Buk", 2249);
    freq.put("iur", 92);
    freq.put("Bun", 442);
    freq.put("Bul", 563);
    freq.put("Bum", 345);
    freq.put("imu", 5422);
    freq.put("Bua", 152);
    freq.put("Bud", 212);
    freq.put("Aer", 103);
    freq.put("ets", 101);
    freq.put("E\u0301", 92);
    freq.put(" e ", 109);
    freq.put("fie", 153);
    freq.put("lle", 1246);
    freq.put("sky", 86);
    freq.put("odu", 321);
    freq.put("dkr", 218);
    freq.put("tno", 94);
    freq.put("po ", 181);
    freq.put("eis", 698);
    freq.put("eir", 227);
    freq.put("rgi", 456);
    freq.put("Sib", 139);
    freq.put("fin", 217);
    freq.put("etu", 1742);
    freq.put("Sia", 209);
    freq.put("leu", 205);
    freq.put("eic", 82);
    freq.put("eid", 126);
    freq.put("eif", 187);
    freq.put("eik", 182);
    freq.put("eij", 135);
    freq.put("eim", 272);
    freq.put("eil", 160);
    freq.put("ein", 1673);
    freq.put("ive", 1052);
    freq.put("\u1100\u1161\u1100\u1161", 229);
    freq.put("iva", 248);
    freq.put("yh", 122);
    freq.put("tio", 1887);
    freq.put("seg", 534);
    freq.put("Ti", 5675);
    freq.put("ivi", 886);
    freq.put("oi ", 269);
    freq.put("ced", 146);
    freq.put("Bar", 4153);
    freq.put("suk", 2918);
    freq.put("Bas", 494);
    freq.put("pap", 231);
    freq.put(" Me", 9466);
    freq.put("par", 2140);
    freq.put("pas", 2802);
    freq.put("pat", 12545);
    freq.put(" Ma", 21745);
    freq.put(" Mc", 109);
    freq.put("pay", 722);
    freq.put(" Mo", 3210);
    freq.put(" Mi", 2499);
    freq.put("khe", 118);
    freq.put("\u0431", 106);
    freq.put(" Mu", 4029);
    freq.put("pab", 507);
    freq.put("pac", 225);
    freq.put("pad", 20739);
    freq.put("pag", 366);
    freq.put("pah", 868);
    freq.put("I ", 1850);
    freq.put("web", 258);
    freq.put("pak", 30609);
    freq.put("pal", 3287);
    freq.put(" My", 254);
    freq.put("pan", 16670);
    freq.put("oin", 141);
    freq.put("cel", 216);
    freq.put("tle", 246);
    freq.put("see", 90);
    freq.put("nac", 196);
    freq.put("I", 28961);
    freq.put("ete", 2221);
    freq.put(" \u30a2", 106);
    freq.put("yd", 229);
    freq.put(" gu", 802);
    freq.put("it ", 3986);
    freq.put("ux ", 226);
    freq.put(" gr", 258);
    freq.put("gaa", 525);
    freq.put("ceh", 1264);
    freq.put("ois", 234);
    freq.put("oir", 1071);
    freq.put("nag", 573);
    freq.put("oka", 760);
    freq.put(" M ", 391);
    freq.put("ccu", 84);
    freq.put("Ip", 196);
    freq.put("Is", 3633);
    freq.put("Ir", 732);
    freq.put("It", 1183);
    freq.put("eto", 293);
    freq.put("pa ", 2327);
    freq.put("naj", 140);
    freq.put("Ik", 260);
    freq.put("cet", 263);
    freq.put("Im", 670);
    freq.put("Il", 316);
    freq.put("In", 13413);
    freq.put("Ia", 4453);
    freq.put("ces", 635);
    freq.put("Ic", 100);
    freq.put("Ib", 1386);
    freq.put("Id", 210);
    freq.put("cer", 686);
    freq.put("ngg", 14541);
    freq.put("sec", 1466);
    freq.put("nai", 809);
    freq.put("ro\u0308e", 241);
    freq.put("am ", 24035);
    freq.put("ps ", 173);
    freq.put("vid", 769);
    freq.put("ucu", 163);
    freq.put("tiq", 113);
    freq.put("oki", 234);
    freq.put("uct", 124);
    freq.put("tir", 325);
    freq.put("mpo", 1192);
    freq.put("uid", 135);
    freq.put("rgo", 543);
    freq.put("nam", 4608);
    freq.put("ys", 11634);
    freq.put("gdo", 544);
    freq.put("unc", 664);
    freq.put("nar", 1813);
    freq.put("yr", 594);
    freq.put("tim", 2572);
    freq.put("nap", 273);
    freq.put("Bak", 335);
    freq.put("ot ", 726);
    freq.put(" ge", 3276);
    freq.put("son", 1077);
    freq.put("co ", 813);
    freq.put("ff ", 196);
    freq.put("\u0628\u0646", 82);
    freq.put("sea", 187);
    freq.put("naw", 275);
    freq.put("ami", 1889);
    freq.put("amk", 171);
    freq.put("psi", 179);
    freq.put("amm", 801);
    freq.put("aml", 124);
    freq.put("amo", 344);
    freq.put("amn", 175);
    freq.put("ama", 27062);
    freq.put("mor", 397);
    freq.put("amb", 3055);
    freq.put("ame", 1030);
    freq.put("kua", 1683);
    freq.put("mou", 108);
    freq.put("pos", 307);
    freq.put("mok", 188);
    freq.put("tid", 1658);
    freq.put(" ab", 756);
    freq.put("mon", 1281);
    freq.put("gro", 268);
    freq.put("amp", 5004);
    freq.put("ams", 199);
    freq.put("foo", 101);
    freq.put("amu", 780);
    freq.put(" gl", 145);
    freq.put("ß", 112);
    freq.put("mod", 652);
    freq.put("rpa", 577);
    freq.put("\u0441\u043a", 92);
    freq.put("Pil", 423);
    freq.put("Pin", 1148);
    freq.put("Pia", 318);
    freq.put("Pic", 109);
    freq.put("Pie", 157);
    freq.put("tia", 2252);
    freq.put("t", 354175);
    freq.put("lic", 650);
    freq.put("Mya", 98);
    freq.put("ucc", 281);
    freq.put("seo", 3063);
    freq.put("Pis", 85);
    freq.put("gja", 188);
    freq.put(" ni", 525);
    freq.put("oor", 392);
    freq.put("htt", 96);
    freq.put("uca", 268);
    freq.put("Neg", 1871);
    freq.put("Kut", 677);
    freq.put("Kus", 108);
    freq.put("Kur", 232);
    freq.put("Bhd", 125);
    freq.put("omp", 2047);
    freq.put("cs", 129);
    freq.put("Kum", 474);
    freq.put("Kul", 245);
    freq.put("Kui", 101);
    freq.put("sen", 3081);
    freq.put("Dr ", 339);
    freq.put("Net", 159);
    freq.put("Neu", 122);
    freq.put("Kuc", 105);
    freq.put("Kub", 239);
    freq.put("Kua", 1867);
    freq.put("Med", 514);
    freq.put("Meg", 95);
    freq.put("ac ", 681);
    freq.put(" no", 914);
    freq.put("Mec", 896);
    freq.put("Raw", 128);
    freq.put("Mem", 236);
    freq.put("Mel", 2611);
    freq.put("Men", 2125);
    freq.put("Mei", 562);
    freq.put("iff", 148);
    freq.put("Mek", 105);
    freq.put("o ", 11973);
    freq.put("ve ", 410);
    freq.put("Met", 202);
    freq.put("kmu", 121);
    freq.put("ddh", 97);
    freq.put("rpo", 1155);
    freq.put("Mes", 469);
    freq.put("Mer", 1020);
    freq.put("ksu", 782);
    freq.put("uch", 381);
    freq.put("nsy", 119);
    freq.put("Mex", 375);
    freq.put("ifa", 630);
    freq.put("lej", 185);
    freq.put("yt", 295);
    freq.put(" ne", 5519);
    freq.put("tda", 113);
    freq.put("dwa", 87);
    freq.put("nme", 425);
    freq.put("nma", 233);
    freq.put("Dra", 745);
    freq.put("oro", 810);
    freq.put("ez ", 176);
    freq.put("oo", 1785);
    freq.put("on", 34226);
    freq.put("om", 14310);
    freq.put("ol", 25149);
    freq.put("ok", 8406);
    freq.put("oj", 754);
    freq.put("oi", 2136);
    freq.put("oh", 4267);
    freq.put("og", 4180);
    freq.put("of", 2166);
    freq.put("oe", 721);
    freq.put("od", 3040);
    freq.put("oc", 1646);
    freq.put("ob", 2206);
    freq.put("oa", 966);
    freq.put("ngo", 1514);
    freq.put("diw", 190);
    freq.put("oz", 259);
    freq.put("oy", 682);
    freq.put("ox", 186);
    freq.put("ow", 1588);
    freq.put("ov", 6595);
    freq.put("ou", 3897);
    freq.put("ot", 8011);
    freq.put("os", 7149);
    freq.put("or", 25529);
    freq.put("op", 4862);
    freq.put("Adv", 82);
    freq.put("Ni", 961);
    freq.put("bje", 424);
    freq.put("ys ", 580);
    freq.put("naf", 114);
    freq.put("bja", 244);
    freq.put("No", 2652);
    freq.put("uil", 237);
    freq.put("Na", 4580);
    freq.put("man", 17867);
    freq.put("Ne", 3358);
    freq.put("Ng", 163);
    freq.put("Ny", 154);
    freq.put("yya", 320);
    freq.put("bba", 131);
    freq.put("orm", 1207);
    freq.put("Ada", 244);
    freq.put("\u0629 ", 254);
    freq.put("yar", 4015);
    freq.put("Nu", 712);
    freq.put("jai", 194);
    freq.put("Adi", 102);
    freq.put("het", 112);
    freq.put("loc", 124);
    freq.put("log", 1685);
    freq.put("her", 867);
    freq.put("hes", 177);
    freq.put("lok", 357);
    freq.put("loh", 134);
    freq.put("Mur", 403);
    freq.put("lon", 1793);
    freq.put("lom", 1385);
    freq.put("lor", 590);
    freq.put("hee", 103);
    freq.put("lop", 336);
    freq.put("\u0432", 121);
    freq.put("lov", 170);
    freq.put("Zul", 114);
    freq.put("heb", 90);
    freq.put("eha", 360);
    freq.put("hel", 428);
    freq.put("hem", 241);
    freq.put("hen", 757);
    freq.put("wam", 340);
    freq.put("hei", 620);
    freq.put("aß", 86);
    freq.put("hek", 90);
    freq.put("rju", 506);
    freq.put("jua", 1342);
    freq.put("jug", 3370);
    freq.put("jud", 682);
    freq.put("\u0646", 527);
    freq.put("N ", 1325);
    freq.put("juk", 2111);
    freq.put("juh", 227);
    freq.put("J", 16075);
    freq.put("jun", 1303);
    freq.put("na ", 10713);
    freq.put("jul", 111);
    freq.put("jum", 727);
    freq.put("jur", 705);
    freq.put("rje", 230);
    freq.put("jut", 411);
    freq.put("Ae", 197);
    freq.put(" su", 5235);
    freq.put("vi ", 88);
    freq.put("lo ", 657);
    freq.put("sik", 1183);
    freq.put("agi", 6470);
    freq.put(" sk", 326);
    freq.put("yaa", 759);
    freq.put("mat", 13126);
    freq.put("agh", 136);
    freq.put("Kg ", 138);
    freq.put("nea", 314);
    freq.put(" si", 4360);
    freq.put("he ", 2354);
    freq.put("Gem", 153);
    freq.put("eh ", 12714);
    freq.put("wak", 1437);
    freq.put("Mua", 519);
    freq.put("age", 668);
    freq.put("aa", 11612);
    freq.put("ac", 4688);
    freq.put("ab", 20825);
    freq.put("ae", 8470);
    freq.put("ad", 56503);
    freq.put("ag", 21007);
    freq.put("af", 2405);
    freq.put("Hon", 251);
    freq.put("ah", 136447);
    freq.put("Hol", 986);
    freq.put("aj", 9650);
    freq.put("am", 64984);
    freq.put("al", 109743);
    freq.put("ao", 666);
    freq.put("an", 422498);
    freq.put("aq", 379);
    freq.put("ap", 27642);
    freq.put("as", 52637);
    freq.put("Hou", 88);
    freq.put("au", 24752);
    freq.put("Hos", 142);
    freq.put("aw", 17249);
    freq.put("av", 1840);
    freq.put("ay", 31162);
    freq.put("ax", 268);
    freq.put("az", 2511);
    freq.put(" he", 560);
    freq.put("nki", 218);
    freq.put("Lal", 252);
    freq.put("Lam", 637);
    freq.put("Lan", 870);
    freq.put("Lao", 109);
    freq.put("Lah", 252);
    freq.put(" Af", 829);
    freq.put("Lak", 332);
    freq.put("Lad", 118);
    freq.put("thu", 783);
    freq.put("e\u0301es", 91);
    freq.put("IC ", 92);
    freq.put("oul", 186);
    freq.put("Lab", 297);
    freq.put("\u0631", 545);
    freq.put("noi", 90);
    freq.put("ige", 492);
    freq.put("Lay", 85);
    freq.put("iga", 1804);
    freq.put("ota", 4428);
    freq.put("Lat", 437);
    freq.put("Lau", 1422);
    freq.put("Law", 147);
    freq.put("Lap", 5633);
    freq.put("sih", 825);
    freq.put("Lar", 140);
    freq.put("Las", 115);
    freq.put("ubj", 123);
    freq.put("a ", 210782);
    freq.put("lga", 143);
    freq.put("may", 121);
    freq.put("gol", 750);
    freq.put("hwe", 84);
    freq.put("Jak", 191);
    freq.put("\u0627\u0654", 90);
    freq.put("hwa", 232);
    freq.put("gon", 466);
    freq.put("uga", 3887);
    freq.put("ohn", 385);
    freq.put("sio", 1252);
    freq.put("ldi", 123);
    freq.put("uzi", 987);
    freq.put("at ", 26256);
    freq.put("mud", 1128);
    freq.put("Bru", 298);
    freq.put("La ", 382);
    freq.put("mpi", 2087);
    freq.put("yo ", 269);
    freq.put("Bro", 237);
    freq.put("u", 382193);
    freq.put("Bri", 839);
    freq.put("ig ", 949);
    freq.put("uit", 287);
    freq.put("Bre", 159);
    freq.put("Bra", 1009);
    freq.put("Fir", 84);
    freq.put("alo", 978);
    freq.put("all", 932);
    freq.put("alm", 207);
    freq.put("Van", 91);
    freq.put("alk", 853);
    freq.put("Val", 299);
    freq.put("ali", 15559);
    freq.put("alg", 121);
    freq.put("ald", 621);
    freq.put("ale", 1649);
    freq.put("alb", 641);
    freq.put("alc", 93);
    freq.put("pta", 664);
    freq.put("aju", 766);
    freq.put("yeb", 310);
    freq.put("gt", 306);
    freq.put("ndu", 4122);
    freq.put("Fie", 111);
    freq.put("Var", 384);
    freq.put("gs", 5117);
    freq.put("alt", 434);
    freq.put("alu", 2781);
    freq.put("Fin", 201);
    freq.put("als", 328);
    freq.put("Fil", 1891);
    freq.put("Gir", 155);
    freq.put("smo", 84);
    freq.put("ree", 677);
    freq.put("tz", 380);
    freq.put("ty", 1373);
    freq.put("tv", 82);
    freq.put("tw", 249);
    freq.put("tt", 1895);
    freq.put("tu", 37333);
    freq.put("tr", 7210);
    freq.put("ts", 1145);
    freq.put("tp", 463);
    freq.put("tn", 1031);
    freq.put("to", 8847);
    freq.put("tl", 983);
    freq.put("tm", 404);
    freq.put("tk", 3583);
    freq.put("th", 4853);
    freq.put("ti", 36996);
    freq.put("tf", 106);
    freq.put("\u0438", 251);
    freq.put("td", 166);
    freq.put("te", 79676);
    freq.put("tb", 138);
    freq.put("tc", 212);
    freq.put("ta", 118349);
    freq.put("edi", 2073);
    freq.put("ium", 973);
    freq.put("iul", 90);
    freq.put("mpa", 5954);
    freq.put("far", 311);
    freq.put("fas", 143);
    freq.put("mpl", 253);
    freq.put("ajo", 353);
    freq.put("ysi", 10703);
    freq.put("al ", 13357);
    freq.put("edo", 329);
    freq.put("fak", 149);
    freq.put("fah", 482);
    freq.put("fai", 192);
    freq.put("fan", 307);
    freq.put("gy", 603);
    freq.put("fal", 282);
    freq.put("aja", 6197);
    freq.put("ngs", 4906);
    freq.put("ius", 385);
    freq.put("akr", 316);
    freq.put("sfe", 203);
    freq.put("ert", 10703);
    freq.put(" Ni", 955);
    freq.put("gg", 14722);
    freq.put("elu", 8313);
    freq.put("is ", 15255);
    freq.put(" No", 2649);
    freq.put(" Na", 4572);
    freq.put("dsb", 197);
    freq.put(" Ne", 3341);
    freq.put("ge", 16197);
    freq.put(" Ng", 163);
    freq.put("\u30a2\u30a2 ", 119);
    freq.put(" Ny", 144);
    freq.put("gd", 604);
    freq.put("gos", 757);
    freq.put("gor", 1882);
    freq.put(" Nu", 712);
    freq.put("rbu", 880);
    freq.put("t ", 48210);
    freq.put("osl", 105);
    freq.put("teh", 223);
    freq.put("pul", 4553);
    freq.put("tek", 974);
    freq.put("tel", 4483);
    freq.put("ga", 76046);
    freq.put("re\u0301n", 87);
    freq.put("teo", 252);
    freq.put("tea", 171);
    freq.put("teb", 211);
    freq.put("edu", 1494);
    freq.put("ted", 825);
    freq.put(" au", 286);
    freq.put("nbu", 1352);
    freq.put("teg", 559);
    freq.put("go", 5967);
    freq.put(" Ac", 1559);
    freq.put("ulo", 336);
    freq.put("tep", 379);
    freq.put(" Ad", 700);
    freq.put("nba", 120);
    freq.put("tes", 1074);
    freq.put("tet", 1024);
    freq.put("gm", 169);
    freq.put("nbe", 130);
    freq.put("uas", 2848);
    freq.put("aba", 7456);
    freq.put("Gil", 114);
    freq.put("suc", 350);
    freq.put("abe", 538);
    freq.put("sua", 2264);
    freq.put("\u0631 ", 108);
    freq.put("abi", 1679);
    freq.put("abj", 107);
    freq.put("abk", 443);
    freq.put("abl", 125);
    freq.put("abo", 245);
    freq.put("mmu", 120);
    freq.put("abr", 124);
    freq.put("sut", 148);
    freq.put("sus", 1037);
    freq.put("abu", 7287);
    freq.put("te\u0301", 82);
    freq.put("xon", 87);
    freq.put("osf", 111);
    freq.put(" Aj", 96);
    freq.put(" ru", 967);
    freq.put("ggr", 373);
    freq.put("te ", 3845);
    freq.put(" Al", 5334);
    freq.put("K", 40946);
    freq.put("smi", 706);
    freq.put("pua", 664);
    freq.put(" re", 1765);
    freq.put("Noo", 205);
    freq.put(" ra", 4498);
    freq.put(" An", 3440);
    freq.put("mul", 2530);
    freq.put(" ro", 601);
    freq.put(" ri", 882);
    freq.put("ab ", 2395);
    freq.put(" Ap", 1093);
    freq.put("\u0645 ", 108);
    freq.put("Una", 261);
    freq.put("Su\u0308d", 110);
    freq.put("uts", 114);
    freq.put("lki", 104);
    freq.put(" Ar", 3152);
    freq.put("sti", 3901);
    freq.put("sba", 93);
    freq.put("udw", 165);
    freq.put(" At", 566);
    freq.put("yst", 183);
    freq.put("oad", 171);
    freq.put("umu", 874);
    freq.put("rku", 436);
    freq.put("zha", 131);
    freq.put("wuj", 426);
    freq.put(" Av", 216);
    freq.put("jra", 136);
    freq.put("Yon", 245);
    freq.put("Tor", 170);
    freq.put("di ", 54108);
    freq.put("sbe", 123);
    freq.put("vin", 3415);
    freq.put("Tow", 90);
    freq.put("vil", 492);
    freq.put("Tou", 95);
    freq.put("Toj", 142);
    freq.put("Tok", 365);
    freq.put("Aus", 928);
    freq.put("Ton", 166);
    freq.put("Aut", 127);
    freq.put("Tol", 171);
    freq.put("Tom", 154);
    freq.put("Tob", 83);
    freq.put("S ", 1438);
    freq.put("rkh", 746);
    freq.put(" Az", 1109);
    freq.put("ear", 468);
    freq.put("ksi", 749);
    freq.put("mma", 792);
    freq.put("ull", 522);
    freq.put("two", 138);
    freq.put("ov ", 225);
    freq.put(" d ", 615);
    freq.put("mme", 1112);
    freq.put("mui", 219);
    freq.put("ejo", 362);
    freq.put("pur", 2588);
    freq.put("nji", 842);
    freq.put("de ", 2083);
    freq.put("pus", 1163);
    freq.put("iz ", 428);
    freq.put("Sy", 2644);
    freq.put("fo\u0308", 176);
    freq.put("uno", 217);
    freq.put("Sr", 539);
    freq.put("Sp", 508);
    freq.put("Sw", 424);
    freq.put("isy", 1010);
    freq.put("Su", 9154);
    freq.put("St", 2134);
    freq.put("Sk", 239);
    freq.put("cro", 203);
    freq.put("Si", 4011);
    freq.put("Sh", 1862);
    freq.put("So", 1552);
    freq.put("Sm", 89);
    freq.put("Sl", 322);
    freq.put("Sc", 1468);
    freq.put("NG ", 89);
    freq.put("Sa", 7125);
    freq.put("umn", 298);
    freq.put("Nov", 710);
    freq.put("Se", 15468);
    freq.put("Sd", 126);
    freq.put("a\u0301", 238);
    freq.put("kle", 1198);
    freq.put("kla", 510);
    freq.put(" di", 83692);
    freq.put("ngt", 156);
    freq.put("Int", 557);
    freq.put(" de", 14986);
    freq.put("ata", 35618);
    freq.put("kli", 164);
    freq.put(" da", 59600);
    freq.put("Ins", 318);
    freq.put("iss", 300);
    freq.put("dek", 1033);
    freq.put("del", 494);
    freq.put("Ini", 272);
    freq.put("den", 10314);
    freq.put("v", 16909);
    freq.put("Ind", 10245);
    freq.put("dea", 352);
    freq.put("Inf", 85);
    freq.put("Ing", 1603);
    freq.put("ded", 138);
    freq.put(" dr", 364);
    freq.put("def", 91);
    freq.put("avi", 800);
    freq.put("rua", 1248);
    freq.put("Do ", 123);
    freq.put("ed ", 1818);
    freq.put("pro", 2699);
    freq.put("go ", 689);
    freq.put("f ", 4203);
    freq.put("way", 450);
    freq.put("lal", 1588);
    freq.put("ath", 634);
    freq.put("ave", 328);
    freq.put("pai", 927);
    freq.put("ist", 4387);
    freq.put("tni", 159);
    freq.put("ob ", 122);
    freq.put("isk", 246);
    freq.put("tiw", 247);
    freq.put("o\u0302t", 453);
    freq.put("slo", 101);
    freq.put("isi", 4078);
    freq.put("ava", 423);
    freq.put("o\u0302n", 487);
    freq.put("ish", 1001);
    freq.put("opt", 304);
    freq.put("atr", 347);
    freq.put("chw", 84);
    freq.put("eg ", 84);
    freq.put("nye", 1690);
    freq.put("oya", 277);
    freq.put("isn", 315);
    freq.put("fr", 1213);
    freq.put("fs", 278);
    freq.put("Don", 404);
    freq.put("fu", 556);
    freq.put("Dol", 113);
    freq.put("Glo", 89);
    freq.put("our", 774);
    freq.put("Akt", 218);
    freq.put("unt", 6686);
    freq.put("fa", 3015);
    freq.put("fe", 1363);
    freq.put("ff", 772);
    freq.put("fg", 113);
    freq.put("rin", 4389);
    freq.put("fi", 6374);
    freq.put("Aka", 166);
    freq.put("fk", 164);
    freq.put("fl", 433);
    freq.put("fo", 1845);
    freq.put("a", 1572499);
    freq.put("kor", 487);
    freq.put("lha", 114);
    freq.put("egr", 182);
    freq.put("usn", 368);
    freq.put("cs ", 109);
    freq.put("egu", 379);
    freq.put("ne ", 4670);
    freq.put("egi", 1125);
    freq.put("ego", 878);
    freq.put("ds ", 392);
    freq.put("o\u0308", 608);
    freq.put("usk", 402);
    freq.put("ega", 5716);
    freq.put("CA ", 82);
    freq.put("ege", 3600);
    freq.put("oy ", 167);
    freq.put("ito", 856);
    freq.put("itk", 2435);
    freq.put("ith", 286);
    freq.put("ce ", 1976);
    freq.put("y ", 7880);
    freq.put("rug", 133);
    freq.put("ite", 4203);
    freq.put("lah", 41764);
    freq.put("ita", 6918);
    freq.put("ok ", 3077);
    freq.put("yok", 119);
    freq.put("itz", 235);
    freq.put("ffi", 302);
    freq.put("ity", 553);
    freq.put("itt", 386);
    freq.put("itu", 5709);
    freq.put("itr", 182);
    freq.put("Oct", 88);
    freq.put("ffa", 97);
    freq.put(" On", 249);
    freq.put(" Ol", 489);
    freq.put("e\u0308 ", 295);
    freq.put("but", 1884);
    freq.put(" Ok", 544);
    freq.put(" Of", 98);
    freq.put(" Og", 727);
    freq.put(" Ob", 147);
    freq.put(" Oc", 198);
    freq.put("nto", 1247);
    freq.put("ckl", 1007);
    freq.put("if ", 1278);
    freq.put("tp ", 97);
    freq.put("lya", 87);
    freq.put("tli", 157);
    freq.put(" Ot", 149);
    freq.put(" Ou", 112);
    freq.put(" Or", 704);
    freq.put(" Os", 256);
    freq.put(" Op", 210);
    freq.put("yi", 2320);
    freq.put("Baw", 87);
    freq.put("Bat", 1275);
    freq.put("Bau", 97);
    freq.put("ym", 262);
    freq.put("yl", 472);
    freq.put("yo", 1324);
    freq.put("yn", 309);
    freq.put("ya", 87677);
    freq.put("cen", 347);
    freq.put("yc", 226);
    freq.put("yb", 95);
    freq.put("ye", 3480);
    freq.put("L", 22330);
    freq.put("yg", 94);
    freq.put("Bay", 277);
    freq.put("yy", 396);
    freq.put("Bag", 475);
    freq.put("Bad", 566);
    freq.put("yz", 105);
    freq.put("Bab", 232);
    freq.put("Bac", 93);
    freq.put("cep", 121);
    freq.put("Ban", 3541);
    freq.put("yp", 206);
    freq.put("Bal", 892);
    freq.put("Ero", 494);
    freq.put("yu", 3240);
    freq.put("Eri", 93);
    freq.put("Bah", 1958);
    freq.put("Bai", 201);
    freq.put("Rad", 225);
    freq.put("Rab", 140);
    freq.put("gue", 251);
    freq.put("ifs", 152);
    freq.put("Ran", 504);
    freq.put("Ram", 356);
    freq.put("Raj", 807);
    freq.put("Rak", 486);
    freq.put("Rah", 353);
    freq.put("Rai", 103);
    freq.put("e\u0308r", 184);
    freq.put("Rat", 181);
    freq.put("Ras", 224);
    freq.put("Rap", 81);
    freq.put("ifo", 215);
    freq.put("Raz", 189);
    freq.put("ifi", 877);
    freq.put("Ray", 672);
    freq.put(" A ", 513);
    freq.put("Mut", 94);
    freq.put(" sy", 970);
    freq.put("Mus", 909);
    freq.put("Eng", 424);
    freq.put(" sp", 1202);
    freq.put("pu ", 412);
    freq.put(" sw", 110);
    freq.put(" st", 1611);
    freq.put("Muz", 273);
    freq.put("Mud", 234);
    freq.put(" sh", 165);
    freq.put("as ", 9010);
    freq.put("Ent", 129);
    freq.put(" so", 731);
    freq.put("Mul", 257);
    freq.put("uda", 2440);
    freq.put("Mun", 209);
    freq.put("Muh", 672);
    freq.put("Muk", 242);
    freq.put(" se", 65781);
    freq.put("ukt", 432);
    freq.put("iza", 490);
    freq.put("Oma", 141);
    freq.put("ize", 101);
    freq.put("\u3042\u3042\u3042", 113);
    freq.put("gur", 850);
    freq.put("izi", 398);
    freq.put("tt ", 153);
    freq.put("E ", 430);
    freq.put("fta", 174);
    freq.put("fte", 85);
    freq.put("sid", 1093);
    freq.put("ass", 961);
    freq.put("asr", 128);
    freq.put(" Ab", 2084);
    freq.put("asp", 182);
    freq.put("Unt", 117);
    freq.put(" Ae", 195);
    freq.put("asu", 2536);
    freq.put("ast", 2146);
    freq.put(" Ah", 1001);
    freq.put(" Ai", 808);
    freq.put("asy", 799);
    freq.put(" Ak", 734);
    freq.put("o\u0304", 211);
    freq.put(" Am", 3390);
    freq.put("\u044f", 98);
    freq.put("asc", 171);
    freq.put("Tal", 221);
    freq.put("asa", 23237);
    freq.put(" As", 2194);
    freq.put("Und", 396);
    freq.put(" Au", 1348);
    freq.put("ase", 633);
    freq.put(" Aw", 291);
    freq.put("bun", 2518);
    freq.put("Uni", 1237);
    freq.put("asi", 8187);
    freq.put("ash", 536);
    freq.put("aso", 149);
    freq.put("asn", 586);
    freq.put("asm", 720);
    freq.put("asl", 278);
    freq.put("Em", 828);
    freq.put("El", 547);
    freq.put("En", 930);
    freq.put("Ei", 91);
    freq.put("Eh", 94);
    freq.put("Ek", 289);
    freq.put(" F ", 213);
    freq.put("Ed", 294);
    freq.put(" ek", 760);
    freq.put("Ea", 212);
    freq.put("Ec", 309);
    freq.put("som", 96);
    freq.put("ft ", 199);
    freq.put("Ex", 177);
    freq.put("w", 38651);
    freq.put("tos", 314);
    freq.put("Eu", 254);
    freq.put("Et", 118);
    freq.put("Ev", 110);
    freq.put("top", 201);
    freq.put("Es", 290);
    freq.put("Er", 726);
    freq.put("Ima", 490);
    freq.put("rro", 201);
    freq.put("Fra", 351);
    freq.put("dt ", 116);
    freq.put("Fre", 163);
    freq.put("uel", 282);
    freq.put("Fri", 170);
    freq.put("Cla", 127);
    freq.put(" el", 748);
    freq.put("Imp", 84);
    freq.put("ude", 159);
    freq.put("uen", 605);
    freq.put("bul", 1177);
    freq.put("ur ", 9875);
    freq.put("pea", 108);
    freq.put("osc", 127);
    freq.put("jer", 102);
    freq.put("koh", 327);
    freq.put("kok", 1924);
    freq.put("kom", 4887);
    freq.put("aa ", 82);
    freq.put("jet", 96);
    freq.put("kon", 2602);
    freq.put(" ed", 217);
    freq.put("X ", 350);
    freq.put(" Yo", 978);
    freq.put("kod", 435);
    freq.put("okr", 214);
    freq.put("imb", 1113);
    freq.put(" Ya", 1240);
    freq.put(" et", 757);
    freq.put("jek", 688);
    freq.put("kos", 215);
    freq.put("\u043a", 214);
    freq.put("jen", 3319);
    freq.put("kot", 1484);
    freq.put("jel", 278);
    freq.put("jem", 250);
    freq.put("ncy", 259);
    freq.put("\u3042", 296);
    freq.put("mer", 37899);
    freq.put("oho", 915);
    freq.put("AP ", 166);
    freq.put("ncu", 421);
    freq.put("mua", 910);
    freq.put("ime", 2177);
    freq.put("nch", 449);
    freq.put("eli", 4806);
    freq.put("Slo", 108);
    freq.put("rra", 913);
    freq.put("kop", 296);
    freq.put("Sle", 97);
    freq.put("oyo", 90);
    freq.put("nce", 1649);
    freq.put("ste", 4462);
    freq.put("b", 199729);
    freq.put("sta", 2889);
    freq.put("ko ", 261);
    freq.put("ke\u0301", 379);
    freq.put("aan", 10415);
    freq.put("Nur", 239);
    freq.put("Nus", 207);
    freq.put("pek", 821);
    freq.put("Nun", 101);
    freq.put("aat", 274);
    freq.put("Rei", 85);
    freq.put("stp", 330);
    freq.put(" er", 382);
    freq.put("str", 2762);
    freq.put("aar", 216);
    freq.put("kov", 81);
    freq.put("Cze", 166);
    freq.put("mun", 5382);
    freq.put("Gol", 142);
    freq.put("Gon", 110);
    freq.put("rry", 211);
    freq.put("puk", 143);
    freq.put("sh ", 916);
    freq.put("God", 87);
    freq.put("\u0648\u0631", 123);
    freq.put("Rem", 165);
    freq.put(" Co\u0302", 450);
    freq.put("oda", 299);
    freq.put("Gor", 139);
    freq.put("lid", 486);
    freq.put("Nik", 104);
    freq.put("lif", 337);
    freq.put("k ", 62478);
    freq.put("Nin", 95);
    freq.put(" la", 15380);
    freq.put(" em", 632);
    freq.put("kny", 1047);
    freq.put("Kis", 136);
    freq.put("Nic", 169);
    freq.put("lin", 3503);
    freq.put("ell", 1081);
    freq.put("eft", 107);
    freq.put("Nig", 91);
    freq.put("Kit", 181);
    freq.put("lit", 3181);
    freq.put("efi", 144);
    freq.put("liv", 116);
    freq.put("2 ", 569);
    freq.put("Kin", 961);
    freq.put("Kim", 88);
    freq.put("Kil", 86);
    freq.put("\u0639", 180);
    freq.put("cci", 124);
    freq.put("nuh", 642);
    freq.put("efe", 130);
    freq.put("liz", 154);
    freq.put("Kid", 196);
    freq.put("kac", 140);
    freq.put("kab", 1684);
    freq.put("kaa", 721);
    freq.put("utn", 101);
    freq.put(" fi", 3762);
    freq.put("kae", 207);
    freq.put("Ata", 113);
    freq.put("kak", 575);
    freq.put("Isr", 240);
    freq.put("Atl", 206);
    freq.put("kah", 502);
    freq.put("M", 42865);
    freq.put("kan", 65462);
    freq.put("kam", 1403);
    freq.put("Ist", 853);
    freq.put("Isk", 108);
    freq.put("kar", 4772);
    freq.put("kap", 1840);
    freq.put("kaw", 5261);
    freq.put("Ism", 235);
    freq.put("Isl", 1820);
    freq.put("rha", 1676);
    freq.put("Isa", 108);
    freq.put("rhe", 129);
    freq.put("Tha", 659);
    freq.put("kb", 86);
    freq.put("ka", 108120);
    freq.put("a\u0302", 119);
    freq.put("li ", 9076);
    freq.put("ke", 44562);
    freq.put("exa", 138);
    freq.put("kk", 1128);
    freq.put("ki", 14104);
    freq.put("kh", 3991);
    freq.put("ko", 15955);
    freq.put("kn", 2015);
    freq.put("km", 1674);
    freq.put("kl", 2495);
    freq.put("ks", 3853);
    freq.put("kr", 1887);
    freq.put("kp", 103);
    freq.put("kw", 208);
    freq.put("ku", 13823);
    freq.put("kt", 4143);
    freq.put("ef ", 96);
    freq.put("ky", 1117);
    freq.put("yhu", 83);
    freq.put("une", 463);
    freq.put("ib ", 619);
    freq.put("rte", 1378);
    freq.put("Hai", 91);
    freq.put("Haj", 534);
    freq.put("Hak", 118);
    freq.put("Hal", 335);
    freq.put("Ham", 347);
    freq.put("Han", 529);
    freq.put("Hab", 110);
    freq.put("rtn", 93);
    freq.put("Had", 169);
    freq.put("rth", 768);
    freq.put("sup", 206);
    freq.put("hi ", 1051);
    freq.put("rbo", 304);
    freq.put("oje", 321);
    freq.put("rts", 116);
    freq.put("nca", 2247);
    freq.put("ojo", 198);
    freq.put("Har", 1041);
    freq.put("Has", 393);
    freq.put("Hat", 137);
    freq.put("Hau", 497);
    freq.put("ugu", 316);
    freq.put("Haw", 106);
    freq.put("ymp", 86);
    freq.put("uai", 435);
    freq.put(" Be", 7481);
    freq.put("Ju", 2146);
    freq.put("ies", 1302);
    freq.put("ier", 702);
    freq.put("ieu", 98);
    freq.put("iet", 538);
    freq.put("lun", 825);
    freq.put("Ope", 136);
    freq.put("Jo", 1642);
    freq.put("Ji", 423);
    freq.put("ien", 485);
    freq.put("Je", 6467);
    freq.put("sil", 1595);
    freq.put(" en", 1147);
    freq.put("Ja", 4941);
    freq.put("hip", 145);
    freq.put("hir", 2908);
    freq.put("his", 190);
    freq.put("hit", 603);
    freq.put("rt ", 1334);
    freq.put("ose", 885);
    freq.put("she", 167);
    freq.put(" K ", 99);
    freq.put("dmi", 140);
    freq.put("bo ", 233);
    freq.put("hib", 221);
    freq.put("hic", 143);
    freq.put("hid", 1769);
    freq.put("hie", 97);
    freq.put("hij", 260);
    freq.put("hik", 165);
    freq.put("hil", 602);
    freq.put("him", 801);
    freq.put("hin", 4765);
    freq.put(" \u1100\u1161", 110);
    freq.put("lea", 321);
    freq.put("rfu", 133);
    freq.put("utu", 1541);
    freq.put("rfa", 107);
    freq.put("hae", 147);
    freq.put("cre", 115);
    freq.put("x", 2864);
    freq.put("rfi", 182);
    freq.put("ifk", 145);
    freq.put("J ", 232);
    freq.put("elg", 122);
    freq.put("Umu", 153);
    freq.put("Ago", 91);
    freq.put("arr", 588);
    freq.put("ars", 575);
    freq.put("art", 3752);
    freq.put("aru", 4058);
    freq.put("For", 435);
    freq.put("sep", 2892);
    freq.put("ary", 969);
    freq.put(" Bo", 2041);
    freq.put(" Bi", 1723);
    freq.put(" Bh", 473);
    freq.put("lot", 172);
    freq.put("aah", 88);
    freq.put(" Bu", 5571);
    freq.put("ara", 39644);
    freq.put("arb", 558);
    freq.put("arc", 474);
    freq.put("Uma", 96);
    freq.put("are", 909);
    freq.put("arf", 134);
    freq.put("arg", 2527);
    freq.put("arh", 224);
    freq.put("ari", 23309);
    freq.put("Fon", 180);
    freq.put("ark", 4152);
    freq.put("arl", 1083);
    freq.put("arm", 521);
    freq.put("arn", 2199);
    freq.put("aro", 691);
    freq.put("mo ", 213);
    freq.put("stu", 237);
    freq.put("leg", 545);
    freq.put("use", 449);
    freq.put("nza", 129);
    freq.put("wor", 251);
    freq.put("mos", 294);
    freq.put("ses", 2265);
    freq.put(" P ", 266);
    freq.put("oke", 184);
    freq.put("Pla", 316);
    freq.put("dut", 214);
    freq.put("ele", 4153);
    freq.put("ms ", 187);
    freq.put("Age", 96);
    freq.put("law", 2684);
    freq.put("kti", 1117);
    freq.put("iks", 241);
    freq.put("ikr", 147);
    freq.put(" B ", 222);
    freq.put("iku", 1306);
    freq.put("ikt", 166);
    freq.put("lel", 468);
    freq.put("lem", 5627);
    freq.put("ar ", 23228);
    freq.put("ika", 13080);
    freq.put("fgh", 100);
    freq.put("ike", 4994);
    freq.put("se ", 1244);
    freq.put("ikk", 91);
    freq.put("iki", 2641);
    freq.put("ikh", 399);
    freq.put("iko", 560);
    freq.put("ikn", 492);
    freq.put("ikl", 232);
    freq.put("yat", 1718);
    freq.put(" Pr", 5024);
    freq.put("c", 52318);
    freq.put(" Pu", 4397);
    freq.put(" Py", 149);
    freq.put("skr", 273);
    freq.put("kta", 496);
    freq.put("tph", 309);
    freq.put("Far", 151);
    freq.put(" Pa", 11353);
    freq.put(" Pe", 16557);
    freq.put("igu", 2207);
    freq.put(" Pi", 2601);
    freq.put(" Ph", 397);
    freq.put(" Po", 3822);
    freq.put("wei", 92);
    freq.put(" Pl", 428);
    freq.put("Wan", 460);
    freq.put("Wal", 495);
    freq.put("Wak", 137);
    freq.put("Wah", 96);
    freq.put("adz", 85);
    freq.put("yu ", 2215);
    freq.put("lew", 115);
    freq.put("od ", 778);
    freq.put("ka ", 8387);
    freq.put("nat", 2102);
    freq.put("lbu", 792);
    freq.put(" Aq", 140);
    freq.put("Wat", 152);
    freq.put("Was", 81);
    freq.put("War", 783);
    freq.put("ga ", 11059);
    freq.put("pr", 4620);
    freq.put("ps", 516);
    freq.put("pp", 606);
    freq.put("duk", 2609);
    freq.put("dul", 1503);
    freq.put("pt", 2000);
    freq.put("pu", 18990);
    freq.put("swa", 407);
    freq.put("dua", 2723);
    freq.put("px", 487);
    freq.put("py", 85);
    freq.put("dud", 2109);
    freq.put("ei ", 1170);
    freq.put("tiv", 497);
    freq.put("geo", 235);
    freq.put("ran", 31080);
    freq.put("pa", 95395);
    freq.put("nau", 433);
    freq.put("rwa", 662);
    freq.put("pe", 46877);
    freq.put("dup", 672);
    freq.put("pk", 282);
    freq.put("ph", 1253);
    freq.put("pi", 8396);
    freq.put("pn", 114);
    freq.put("po", 7399);
    freq.put("pl", 1464);
    freq.put("pm", 86);
    freq.put("Fal", 106);
    freq.put("gay", 288);
    freq.put("ctu", 131);
    freq.put("gaw", 574);
    freq.put("ty ", 1209);
    freq.put(" tu", 2924);
    freq.put("gat", 1264);
    freq.put("Emi", 118);
    freq.put(" tr", 1008);
    freq.put("nre", 1118);
    freq.put("N", 13239);
    freq.put(" to", 641);
    freq.put("gan", 31725);
    freq.put("gam", 2696);
    freq.put("gal", 2392);
    freq.put("gak", 392);
    freq.put("Emp", 510);
    freq.put(" Om", 175);
    freq.put(" th", 1478);
    freq.put("gag", 159);
    freq.put(" te", 46306);
    freq.put("gad", 225);
    freq.put("gac", 87);
    freq.put("gab", 488);
    freq.put(" ta", 11300);
    freq.put("gu ", 1642);
    freq.put("sak", 765);
    freq.put("gtu", 144);
    freq.put("iya", 450);
    freq.put("du ", 1066);
    freq.put("Oli", 227);
    freq.put("tip", 149);
    freq.put("gem", 770);
    freq.put("TM ", 239);
    freq.put("p ", 5732);
    freq.put("fun", 317);
    freq.put("lbe", 124);
    freq.put("iyy", 293);
    freq.put("eke", 565);
    freq.put("vic", 160);
    freq.put("sy ", 170);
    freq.put("riz", 119);
    freq.put("rix", 133);
    freq.put("Tit", 106);
    freq.put("hba", 248);
    freq.put("rit", 2934);
    freq.put("riu", 208);
    freq.put("ris", 4313);
    freq.put("Tir", 130);
    freq.put("vok", 203);
    freq.put("cec", 129);
    freq.put("Tim", 3943);
    freq.put("Tin", 840);
    freq.put("rim", 859);
    freq.put("rik", 7517);
    freq.put("rih", 81);
    freq.put("Tid", 104);
    freq.put("Ira", 444);
    freq.put("exi", 402);
    freq.put("Tig", 175);
    freq.put("rib", 675);
    freq.put("Ire", 182);
    freq.put("rpu", 377);
    freq.put("ria", 3082);
    freq.put("rde", 1385);
    freq.put("ewi", 120);
    freq.put("ewa", 2199);
    freq.put("nay", 387);
    freq.put("gs ", 118);
    freq.put("ews", 100);
    freq.put("sah", 1841);
    freq.put("ewu", 103);
    freq.put("Cos", 83);
    freq.put("Cor", 310);
    freq.put("Cou", 501);
    freq.put("uro", 302);
    freq.put("sye", 1001);
    freq.put("dge", 491);
    freq.put("syi", 154);
    freq.put("syh", 85);
    freq.put("cea", 276);
    freq.put("Ili", 91);
    freq.put("Coc", 102);
    freq.put("lig", 376);
    freq.put("uto", 578);
    freq.put("syu", 126);
    freq.put("syt", 127);
    freq.put("FA ", 123);
    freq.put("mot", 314);
    freq.put("Com", 467);
    freq.put("Col", 444);
    freq.put("ri ", 22851);
    freq.put("Con", 500);
    freq.put("kno", 375);
    freq.put(" fr", 306);
    freq.put("gsu", 450);
    freq.put("ex ", 120);
    freq.put("kni", 375);
    freq.put("ew ", 783);
    freq.put("Som", 81);
    freq.put("Sol", 221);
    freq.put("Son", 251);
    freq.put("gsa", 3814);
    freq.put("lil", 385);
    freq.put("Sos", 91);
    freq.put("Sou", 282);
    freq.put("Kir", 134);
    freq.put("y", 121423);
    freq.put("RC ", 114);
    freq.put("gsl", 154);
    freq.put(" fo", 731);
    freq.put("wig", 1003);
    freq.put("lda", 235);
    freq.put("lio", 243);
    freq.put("lde", 213);
    freq.put("ldk", 204);
    freq.put("lih", 1595);
    freq.put(" Ay", 309);
    freq.put("mol", 218);
    freq.put("Di ", 495);
    freq.put("oke\u0301", 372);
    freq.put("bi ", 755);
    freq.put("O ", 757);
    freq.put("ldr", 97);
    freq.put("lik", 3976);
    freq.put("oo ", 109);
    freq.put("cut", 119);
    freq.put("cus", 161);
    freq.put("cur", 169);
    freq.put("cup", 101);
    freq.put("rga", 3299);
    freq.put("sal", 6322);
    freq.put("cub", 107);
    freq.put("cua", 246);
    freq.put("cun", 117);
    freq.put("cum", 151);
    freq.put("cul", 407);
    freq.put("cuk", 241);
    freq.put(" De", 3032);
    freq.put("kma", 107);
    freq.put("Dil", 85);
    freq.put("On", 254);
    freq.put("Din", 297);
    freq.put("Ol", 491);
    freq.put("Ok", 544);
    freq.put("lir", 917);
    freq.put("bih", 1923);
    freq.put("Og", 727);
    freq.put("Of", 107);
    freq.put("bid", 732);
    freq.put("Dig", 111);
    freq.put("Oc", 198);
    freq.put("Dia", 606);
    freq.put("Dib", 90);
    freq.put("Air", 528);
    freq.put("gge", 1788);
    freq.put(" Da", 7101);
    freq.put("Dit", 98);
    freq.put("Ou", 112);
    freq.put("Ot", 149);
    freq.put("gr", 2072);
    freq.put("Or", 706);
    freq.put("Dir", 367);
    freq.put("Dis", 1199);
    freq.put("d", 316152);
    freq.put("fel", 156);
    freq.put("eet", 128);
    freq.put("ppi", 85);
    freq.put(" \u4e09", 99);
    freq.put("dun", 2327);
    freq.put("eer", 155);
    freq.put("eem", 212);
    freq.put("eel", 102);
    freq.put("ohd", 380);
    freq.put("een", 939);
    freq.put("eek", 338);
    freq.put("cu ", 125);
    freq.put("Kha", 610);
    freq.put("Ru\u0308g", 112);
    freq.put("eec", 90);
    freq.put("ii ", 168);
    freq.put("ijr", 146);
    freq.put("b ", 4501);
    freq.put("iju", 223);
    freq.put("uf ", 428);
    freq.put("ru ", 2865);
    freq.put("saa", 2288);
    freq.put("ija", 979);
    freq.put("ld ", 768);
    freq.put("on ", 7262);
    freq.put("iji", 355);
    freq.put("tuj", 696);
    freq.put("oe ", 208);
    freq.put("was", 5549);
    freq.put("rf ", 161);
    freq.put("vol", 481);
    freq.put(" Qu", 659);
    freq.put("pet", 458);
    freq.put("kad", 826);
    freq.put("pep", 189);
    freq.put("ak", 88368);
    freq.put("pes", 2868);
    freq.put("pel", 2806);
    freq.put(" Qa", 209);
    freq.put("pen", 13849);
    freq.put("tik", 4794);
    freq.put("pej", 473);
    freq.put("kaj", 351);
    freq.put("ped", 430);
    freq.put(" Qi", 91);
    freq.put("uku", 3080);
    freq.put("peg", 272);
    freq.put("kai", 1379);
    freq.put("id ", 2411);
    freq.put("km2", 556);
    freq.put("bd", 1187);
    freq.put("Boy", 81);
    freq.put("ruh", 1229);
    freq.put("rui", 92);
    freq.put("run", 3036);
    freq.put("ba", 73332);
    freq.put("bb", 374);
    freq.put("rum", 1098);
    freq.put("bl", 1565);
    freq.put("rhu", 353);
    freq.put("Bor", 302);
    freq.put("Bos", 100);
    freq.put("Bot", 109);
    freq.put("bi", 16194);
    freq.put("bj", 669);
    freq.put("bk", 504);
    freq.put("bt", 124);
    freq.put("bu", 54229);
    freq.put("oei", 98);
    freq.put("ruy", 112);
    freq.put("Bol", 345);
    freq.put("oen", 92);
    freq.put("br", 1904);
    freq.put("Boo", 88);
    freq.put("rus", 2650);
    freq.put("rwo", 83);
    freq.put("kal", 3979);
    freq.put("wit", 297);
    freq.put("by", 357);
    freq.put("rut", 1552);
    freq.put("che", 1276);
    freq.put("Tho", 125);
    freq.put("lge", 136);
    freq.put("\u03c2 ", 105);
    freq.put("a\u0308", 134);
    freq.put("Rob", 171);
    freq.put("Roc", 116);
    freq.put("idr", 191);
    freq.put("AC ", 83);
    freq.put("Roy", 88);
    freq.put("idm", 710);
    freq.put("idi", 1336);
    freq.put("idg", 114);
    freq.put("idd", 108);
    freq.put("Ros", 222);
    freq.put("Rot", 215);
    freq.put("Rou", 105);
    freq.put("ida", 4190);
    freq.put("nsh", 129);
    freq.put("rio", 461);
    freq.put("wn ", 203);
    freq.put("nsk", 184);
    freq.put("kau", 601);
    freq.put("nsn", 707);
    freq.put("nso", 443);
    freq.put(" ut", 1972);
    freq.put("nsa", 240);
    freq.put(" C ", 269);
    freq.put("kat", 7066);
    freq.put(" up", 118);
    freq.put("nse", 539);
    freq.put(" ur", 128);
    freq.put("Ele", 136);
    freq.put(" ul", 360);
    freq.put(" um", 752);
    freq.put(" un", 7312);
    freq.put("aq ", 213);
    freq.put(" uk", 109);
    freq.put(" ud", 384);
    freq.put("ush", 174);
    freq.put("nst", 1059);
    freq.put("The", 1090);
    freq.put(" ub", 143);
    freq.put("gro\u0308", 241);
    freq.put("ut ", 7583);
    freq.put("ci ", 407);
    freq.put("nje", 264);
    freq.put("mka", 269);
    freq.put("\u4e26", 163);
    freq.put("tig", 1070);
    freq.put("lti", 290);
    freq.put("ust", 2174);
    freq.put("ezu", 133);
    freq.put("cht", 142);
    freq.put("u ", 48453);
    freq.put(" R ", 136);
    freq.put(" Ch", 3498);
    freq.put(" Ci", 1452);
    freq.put("\u30a2 ", 125);
    freq.put(" Co", 2741);
    freq.put(" Cl", 318);
    freq.put("ns ", 1395);
    freq.put("njo", 126);
    freq.put("El ", 142);
    freq.put(" Ku", 4698);
    freq.put("Ulu", 237);
    freq.put(" Cz", 168);
    freq.put("tru", 429);
    freq.put("Zea", 181);
    freq.put("Flo", 106);
    freq.put("chy", 82);
    freq.put(" Cr", 466);
    freq.put("Kup", 104);
    freq.put("Fle", 177);
    freq.put("ul ", 3175);
    freq.put("zan", 280);
    freq.put(" Cu", 414);
    freq.put("cia", 390);
    freq.put(" Ky", 121);
    freq.put("uy", 326);
    freq.put("ux", 309);
    freq.put("cie", 186);
    freq.put("uz", 1379);
    freq.put("uu", 95);
    freq.put("ut", 20841);
    freq.put("uw", 287);
    freq.put("uv", 269);
    freq.put("uq", 123);
    freq.put("up", 38959);
    freq.put("us", 17527);
    freq.put("ur", 29560);
    freq.put("um", 18481);
    freq.put("ul", 24992);
    freq.put("uo", 172);
    freq.put("un", 56650);
    freq.put("ui", 3189);
    freq.put("uh", 8031);
    freq.put("uk", 26920);
    freq.put("uj", 3571);
    freq.put("ue", 2226);
    freq.put("ud", 9184);
    freq.put("ug", 5578);
    freq.put("z", 11534);
    freq.put("ua", 55927);
    freq.put("uc", 1791);
    freq.put("ub", 6360);
    freq.put("nla", 231);
    freq.put("nju", 1774);
    freq.put("ood", 234);
    freq.put("Tu", 2321);
    freq.put("Tr", 1038);
    freq.put("Ts", 110);
    freq.put("To", 1817);
    freq.put("sul", 629);
    freq.put("Th", 2070);
    freq.put("New", 731);
    freq.put("lym", 81);
    freq.put("Te", 14128);
    freq.put("Ta", 5699);
    freq.put("nab", 295);
    freq.put("A ", 1902);
    freq.put("Mas", 1315);
    freq.put("Mar", 2036);
    freq.put("Mau", 200);
    freq.put("Mat", 615);
    freq.put("nad", 1121);
    freq.put("urd", 90);
    freq.put("May", 201);
    freq.put("nak", 4741);
    freq.put("nah", 2523);
    freq.put("Maz", 85);
    freq.put("nan", 8824);
    freq.put("nal", 5652);
    freq.put("eza", 588);
    freq.put("u\u0308ge", 111);
    freq.put("nas", 1399);
    freq.put("Mac", 771);
    freq.put("gre", 287);
    freq.put("Mad", 347);
    freq.put("Mag", 286);
    freq.put("gra", 1121);
    freq.put("Mai", 531);
    freq.put("Mah", 703);
    freq.put("Mak", 620);
    freq.put("Maj", 610);
    freq.put("Mam", 120);
    freq.put("Mal", 11656);
    freq.put("Man", 1319);
    freq.put("kir", 1682);
    freq.put("\u064a", 643);
    freq.put("pau", 127);
    freq.put(" Wh", 135);
    freq.put("aen", 91);
    freq.put(" ch", 277);
    freq.put("yaw", 106);
    freq.put(" ci", 740);
    freq.put("ly ", 453);
    freq.put("lis", 3844);
    freq.put("Zui", 82);
    freq.put("T ", 567);
    freq.put("Edi", 123);
    freq.put("ago", 378);
    freq.put("agn", 508);
    freq.put("Ac", 1560);
    freq.put("Ab", 2089);
    freq.put("e", 658563);
    freq.put("Ad", 704);
    freq.put("Ag", 889);
    freq.put("Af", 831);
    freq.put("Ai", 809);
    freq.put("Ah", 1002);
    freq.put("Ak", 735);
    freq.put("Aj", 96);
    freq.put("Am", 3400);
    freq.put("Al", 5346);
    freq.put("aga", 10764);
    freq.put("An", 3447);
    freq.put("Aq", 140);
    freq.put("Ap", 1094);
    freq.put("As", 2214);
    freq.put("Ar", 3162);
    freq.put("Au", 1348);
    freq.put("At", 570);
    freq.put("Aw", 291);
    freq.put("Av", 219);
    freq.put("Ay", 310);
    freq.put("agu", 1752);
    freq.put("Az", 1110);
    freq.put(" b", 61081);
    freq.put(" c", 5105);
    freq.put("gu", 11142);
    freq.put(" a", 48871);
    freq.put(" f", 6534);
    freq.put(" g", 7177);
    freq.put(" d", 162664);
    freq.put(" e", 5363);
    freq.put(" j", 11345);
    freq.put(" k", 65931);
    freq.put(" h", 12749);
    freq.put(" i", 30341);
    freq.put(" n", 10921);
    freq.put(" o", 15254);
    freq.put(" l", 23228);
    freq.put(" m", 77479);
    freq.put(" r", 8778);
    freq.put(" s", 95750);
    freq.put(" p", 65928);
    freq.put(" q", 106);
    freq.put(" v", 1459);
    freq.put(" w", 8735);
    freq.put(" t", 69161);
    freq.put(" u", 11761);
    freq.put(" z", 926);
    freq.put("gn", 1513);
    freq.put(" x", 98);
    freq.put(" y", 44531);
    freq.put("gk", 8707);
    freq.put("gj", 210);
    freq.put("gi", 15794);
    freq.put("gh", 2760);
    freq.put(" B", 36217);
    freq.put(" C", 14046);
    freq.put(" A", 33790);
    freq.put(" F", 8281);
    freq.put(" G", 9989);
    freq.put(" D", 19485);
    freq.put(" E", 5868);
    freq.put(" J", 16031);
    freq.put(" K", 40896);
    freq.put(" H", 12965);
    freq.put(" I", 28925);
    freq.put(" N", 13195);
    freq.put(" O", 4683);
    freq.put(" L", 22273);
    freq.put(" M", 42791);
    freq.put(" R", 17319);
    freq.put(" S", 49556);
    freq.put(" P", 46450);
    freq.put(" Q", 1053);
    freq.put(" V", 4864);
    freq.put(" W", 6726);
    freq.put(" T", 33952);
    freq.put(" U", 8167);
    freq.put(" Z", 1920);
    freq.put("mil", 3082);
    freq.put(" X", 518);
    freq.put(" Y", 3279);
    freq.put("\u03bd", 86);
    freq.put("rto", 428);
    freq.put("Nor", 1237);
    freq.put("tme", 175);
    freq.put("rag", 489);
    freq.put("Azi", 185);
    freq.put(" ep", 143);
    freq.put("pe ", 281);
    freq.put("rti", 3790);
    freq.put("rie", 868);
    freq.put("Aze", 184);
    freq.put("P", 46573);
    freq.put("ulg", 85);
    freq.put("tho", 286);
    freq.put(" N ", 147);
    freq.put("g ", 103343);
    freq.put("pun", 6347);
    freq.put("Azu", 461);
    freq.put("tri", 1776);
    freq.put("evi", 1067);
    freq.put("lst", 756);
    freq.put("evo", 467);
    freq.put("tra", 2815);
    freq.put("eva", 165);
    freq.put("us ", 4638);
    freq.put("tre", 416);
    freq.put("eve", 355);
    freq.put("ebi", 2395);
    freq.put("Spi", 83);
    freq.put("ziu", 148);
    freq.put("oge", 265);
    freq.put(" Rh", 2165);
    freq.put("Spa", 92);
    freq.put(" cu", 456);
    freq.put("rae", 299);
    freq.put("Spe", 180);
    freq.put("zl", 139);
    freq.put("zm", 124);
    freq.put("zn", 118);
    freq.put("zo", 647);
    freq.put("zh", 286);
    freq.put("zi", 2979);
    freq.put("rri", 312);
    freq.put("ze", 1129);
    freq.put("rre", 320);
    freq.put("oja", 137);
    freq.put("za", 3097);
    freq.put("zb", 112);
    freq.put("ibe", 991);
    freq.put("odi", 278);
    freq.put("mia", 690);
    freq.put("ult", 1554);
    freq.put("zz", 209);
    freq.put("odo", 173);
    freq.put("zu", 864);
    freq.put("ulu", 2906);
    freq.put("Bla", 207);
    freq.put("ode", 810);
    freq.put("ues", 185);
    freq.put("uer", 235);
    freq.put(" Re", 2651);
    freq.put("eng", 28628);
    freq.put("ulk", 198);
    freq.put("rty", 170);
    freq.put("med", 795);
    freq.put(" E\u0301", 91);
    freq.put("fat", 355);
    freq.put("bdu", 982);
    freq.put("cit", 186);
    freq.put("ct ", 200);
    freq.put("rd ", 938);
    freq.put("Ori", 90);
    freq.put("rho", 81);
    freq.put("utr", 336);
    freq.put("kay", 507);
    freq.put("Ora", 305);
    freq.put("oci", 139);
    freq.put("leb", 2160);
    freq.put("enh", 146);
    freq.put("led", 158);
    freq.put("flo", 92);
    freq.put("lef", 234);
    freq.put("och", 315);
    freq.put("leh", 11245);
    freq.put("got", 513);
    freq.put("Yus", 150);
    freq.put("lek", 1317);
    freq.put("z ", 1327);
    freq.put("\u1100\u1161 ", 113);
    freq.put("len", 2626);
    freq.put("leo", 109);
    freq.put("lep", 1429);
    freq.put("ler", 519);

    init2();
  }
  private static void init2() {
    
    freq.put("les", 2125);
    freq.put("let", 19322);
    freq.put("hko", 119);
    freq.put("lev", 943);
    freq.put("Yun", 286);
    freq.put("ogy", 484);
    freq.put("ley", 274);
    freq.put("kup", 264);
    freq.put("hka", 1860);
    freq.put("rdu", 156);
    freq.put("eni", 4899);
    freq.put("rdw", 115);
    freq.put("Aha", 85);
    freq.put("bd ", 101);
    freq.put("rds", 117);
    freq.put("nco", 417);
    freq.put("rdy", 187);
    freq.put("Ahl", 397);
    freq.put("Ahm", 452);
    freq.put("gl", 1474);
    freq.put("oca", 188);
    freq.put("rda", 3685);
    freq.put("kud", 134);
    freq.put("uhi", 252);
    freq.put("rdo", 180);
    freq.put("cto", 255);
    freq.put("rdi", 1361);
    freq.put("cti", 335);
    freq.put("enj", 3357);
    freq.put(" Do", 1228);
    freq.put("xan", 91);
    freq.put("Ver", 240);
    freq.put("gov", 355);
    freq.put(" Di", 4059);
    freq.put(" Dh", 92);
    freq.put("win", 269);
    freq.put("app", 137);
    freq.put("wil", 5229);
    freq.put(" ol", 9058);
    freq.put("apt", 214);
    freq.put("apu", 1299);
    freq.put("apk", 212);
    freq.put("aph", 119);
    freq.put("api", 1939);
    freq.put("apo", 341);
    freq.put("apl", 112);
    freq.put(" zo", 121);
    freq.put("Ven", 208);
    freq.put(" Du", 1487);
    freq.put("apa", 19852);
    freq.put("sge", 511);
    freq.put(" Dr", 1222);
    freq.put("ape", 224);
    freq.put("zaa", 88);
    freq.put("cha", 755);
    freq.put("Fr", 767);
    freq.put(" \u1100\u1161\u1100\u1161", 103);
    freq.put("Fu", 334);
    freq.put("Hub", 115);
    freq.put("Hul", 888);
    freq.put("chi", 1006);
    freq.put("Hun", 189);
    freq.put("\u062a", 219);
    freq.put("chl", 916);
    freq.put("lba", 1538);
    freq.put("usi", 3335);
    freq.put("cho", 416);
    freq.put("Hut", 228);
    freq.put("Fa", 1374);
    freq.put("usu", 1400);
    freq.put("iej", 108);
    freq.put("fer", 388);
    freq.put("Fe", 1229);
    freq.put("ura", 6397);
    freq.put("Hus", 197);
    freq.put("zin", 101);
    freq.put("Fi", 2562);
    freq.put("zil", 726);
    freq.put("zim", 257);
    freq.put("Fl", 397);
    freq.put("kya", 786);
    freq.put("\u043e", 231);
    freq.put("acc", 89);
    freq.put("Gua", 329);
    freq.put("wi ", 588);
    freq.put("Gui", 240);
    freq.put("Gun", 810);
    freq.put("Gul", 81);
    freq.put("Gur", 224);
    freq.put("sra", 377);
    freq.put("enm", 121);
    freq.put("ap ", 2995);
    freq.put("px ", 483);
    freq.put("rja", 1818);
    freq.put("iik", 146);
    freq.put("za ", 754);
    freq.put(" Ru", 1202);
    freq.put("ace", 635);
    freq.put("fe ", 96);
    freq.put("f", 21309);
    freq.put("hra", 480);
    freq.put("km ", 794);
    freq.put("ied", 208);
    freq.put("F ", 465);
    freq.put("ack", 348);
    freq.put(" Ra", 4674);
    freq.put("ric", 726);
    freq.put("enn", 571);
    freq.put(" Ro", 2055);
    freq.put(" Ri", 1308);
    freq.put("aci", 257);
    freq.put("SM ", 492);
    freq.put("tat", 797);
    freq.put("tau", 9325);
    freq.put("ach", 779);
    freq.put("tap", 1660);
    freq.put("tar", 10465);
    freq.put("do", 13268);
    freq.put("ie\u0300r", 83);
    freq.put("aco", 144);
    freq.put("tay", 304);
    freq.put(" ca", 1681);
    freq.put("tad", 1206);
    freq.put("taf", 141);
    freq.put("tag", 153);
    freq.put("dia", 6402);
    freq.put("eno", 673);
    freq.put("tab", 947);
    freq.put("tac", 174);
    freq.put("tal", 2397);
    freq.put("tam", 5004);
    freq.put("sed", 838);
    freq.put("ebs", 109);
    freq.put(" ot", 94);
    freq.put("taj", 254);
    freq.put("tak", 21498);
    freq.put(" va", 145);
    freq.put("sir", 1920);
    freq.put("sip", 1088);
    freq.put(" ve", 377);
    freq.put("afi", 651);
    freq.put("Yo", 982);
    freq.put("sit", 1085);
    freq.put("Ya", 1244);
    freq.put("tah", 9752);
    freq.put("aff", 132);
    freq.put("Ye", 197);
    freq.put("afa", 559);
    freq.put(" vo", 304);
    freq.put("spe", 1275);
    freq.put("sic", 184);
    freq.put("sib", 161);
    freq.put("sia", 23942);
    freq.put("enp", 206);
    freq.put("sig", 163);
    freq.put("sif", 646);
    freq.put("sie", 915);
    freq.put("dwe", 130);
    freq.put("aft", 225);
    freq.put("dwi", 284);
    freq.put("Yu", 587);
    freq.put("sin", 2640);
    freq.put("sim", 1250);
    freq.put("o\u0302", 979);
    freq.put("Eko", 134);
    freq.put("sis", 2215);
    freq.put("acu", 251);
    freq.put("mah", 1764);
    freq.put("act", 193);
    freq.put("npa", 520);
    freq.put("Kai", 155);
    freq.put("Q", 1060);
    freq.put("ta ", 10995);
    freq.put("mi ", 2729);
    freq.put("ung", 15003);
    freq.put("ne\u0301e", 98);
    freq.put("Eks", 136);
    freq.put("ndr", 524);
    freq.put("siu", 88);
    freq.put("hia", 286);
    freq.put("Y ", 91);
    freq.put("af ", 525);
    freq.put("enr", 1199);
    freq.put(" vi", 594);
    freq.put("si ", 12617);
    freq.put("ger", 6793);
    freq.put("TO ", 91);
    freq.put("usl", 307);
    freq.put("da ", 27370);
    freq.put("Aye", 93);
    freq.put("Aya", 126);
    freq.put("ju ", 351);
    freq.put("ndi", 3985);
    freq.put("haz", 127);
    freq.put("dw", 512);
    freq.put("lf", 422);
    freq.put("lg", 478);
    freq.put("ld", 1859);
    freq.put("le", 52683);
    freq.put("lb", 2609);
    freq.put("lc", 220);
    freq.put("la", 150999);
    freq.put("ln", 692);
    freq.put("\u0628", 378);
    freq.put("ll", 5253);
    freq.put("lm", 890);
    freq.put("lj", 112);
    freq.put("lk", 1910);
    freq.put("lh", 268);
    freq.put("li", 41181);
    freq.put("lv", 509);
    freq.put("lw", 82);
    freq.put("lt", 2503);
    freq.put("lu", 18399);
    freq.put("ls", 1529);
    freq.put("lp", 1203);
    freq.put("bin", 2755);
    freq.put("eut", 155);
    freq.put("e\u0308r ", 162);
    freq.put("tsu", 260);
    freq.put("lz", 145);
    freq.put("eup", 121);
    freq.put("eus", 217);
    freq.put("ly", 913);
    freq.put("dad", 217);
    freq.put("dae", 5534);
    freq.put("e\u0302\u0309", 84);
    freq.put("dag", 474);
    freq.put("wir", 85);
    freq.put("daa", 403);
    freq.put("Ibn", 142);
    freq.put("Cas", 261);
    freq.put("Car", 564);
    freq.put("dan", 33544);
    freq.put("Cap", 134);
    freq.put("dah", 2813);
    freq.put("dai", 362);
    freq.put("mej", 156);
    freq.put("Cat", 148);
    freq.put("dat", 1149);
    freq.put("dau", 298);
    freq.put("daw", 132);
    freq.put("dap", 4274);
    freq.put("Can", 269);
    freq.put("Cam", 344);
    freq.put("Cal", 547);
    freq.put("Cab", 88);
    freq.put("Ibr", 373);
    freq.put("Ibu", 746);
    freq.put("Pre", 620);
    freq.put("Sai", 1025);
    freq.put("Sah", 128);
    freq.put("Pra", 231);
    freq.put("San", 1065);
    freq.put("c\u0327", 161);
    freq.put("Sal", 707);
    freq.put("nfo", 133);
    freq.put("Sab", 832);
    freq.put("Pro", 3699);
    freq.put("nfl", 104);
    freq.put("Pri", 366);
    freq.put("eu ", 111);
    freq.put(" hu", 1664);
    freq.put("Say", 155);
    freq.put("bil", 2147);
    freq.put("Sas", 105);
    freq.put("Sar", 891);
    freq.put(" ha", 7358);
    freq.put("afs", 96);
    freq.put("Sau", 314);
    freq.put("Sat", 343);
    freq.put("lie", 274);
    freq.put("oui", 99);
    freq.put("rki", 661);
    freq.put("oun", 730);
    freq.put("npl", 189);
    freq.put("hlu", 168);
    freq.put("oug", 180);
    freq.put("bim", 123);
    freq.put("mar", 1635);
    freq.put("hli", 1784);
    freq.put("ous", 420);
    freq.put("pam", 148);
    freq.put("hle", 884);
    freq.put("oup", 135);
    freq.put("bu ", 2368);
    freq.put("hla", 260);
    freq.put("out", 586);
    freq.put("rez", 84);
    freq.put("Rin", 102);
    freq.put("rey", 120);
    freq.put("bag", 10103);
    freq.put("rer", 249);
    freq.put("res", 2048);
    freq.put("Tur", 534);
    freq.put("sna", 139);
    freq.put("rev", 326);
    freq.put("rew", 103);
    freq.put("ret", 1067);
    freq.put("reu", 161);
    freq.put("Jem", 105);
    freq.put("rek", 2078);
    freq.put("Tuj", 92);
    freq.put("cra", 101);
    freq.put("Tul", 101);
    freq.put("Tum", 183);
    freq.put("Tun", 599);
    freq.put("rem", 580);
    freq.put("reb", 133);
    freq.put("Tua", 360);
    freq.put("rea", 1054);
    freq.put("reg", 650);
    freq.put("red", 517);
    freq.put("emp", 6552);
    freq.put("lob", 141);
    freq.put("ece", 504);
    freq.put("maz", 97);
    freq.put("lf ", 112);
    freq.put("eca", 9518);
    freq.put("eco", 162);
    freq.put("ou ", 243);
    freq.put("eck", 1080);
    freq.put("eci", 1191);
    freq.put("ech", 443);
    freq.put("qua", 138);
    freq.put("ecu", 162);
    freq.put("ect", 304);
    freq.put("que", 442);
    freq.put("Gha", 143);
    freq.put("nny", 2270);
    freq.put("ie ", 1007);
    freq.put("qui", 261);
    freq.put("toc", 160);
    freq.put("bal", 1621);
    freq.put("u\u0308dl", 82);
    freq.put("hd ", 532);
    freq.put("g", 267175);
    freq.put("uha", 3353);
    freq.put("ask", 1160);
    freq.put("Ipo", 169);
    freq.put("bak", 943);
    freq.put("nfo\u0308", 173);
    freq.put("lta", 1323);
    freq.put("lte", 276);
    freq.put("lia", 4614);
    freq.put("re ", 3550);
    freq.put("bai", 843);
    freq.put("lto", 86);
    freq.put("u\u0308", 561);
    freq.put("set", 1888);
    freq.put("\u1100\u1161\u1100\u1161\u1100\u1161", 123);
    freq.put("arp", 171);
    freq.put("K ", 459);
    freq.put("uli", 2651);
    freq.put("uhn", 192);
    freq.put("asj", 1090);
    freq.put("rs ", 614);
    freq.put("seu", 109);
    freq.put("ihu", 86);
    freq.put("sof", 189);
    freq.put("mai", 2470);
    freq.put("ud ", 1277);
    freq.put("ihi", 368);
    freq.put("lib", 614);
    freq.put(" Ba", 14981);
    freq.put("iha", 2790);
    freq.put("og ", 188);
    freq.put("ser", 3709);
    freq.put("has", 7477);
    freq.put(" Sy", 2644);
    freq.put("ao ", 367);
    freq.put("arv", 121);
    freq.put("los", 237);
    freq.put(" Sr", 539);
    freq.put("be ", 164);
    freq.put(" Sw", 421);
    freq.put(" St", 2094);
    freq.put(" Su", 9144);
    freq.put("UN ", 205);
    freq.put(" Sk", 238);
    freq.put(" Sh", 1855);
    freq.put(" Si", 3998);
    freq.put(" So", 1545);
    freq.put(" Sl", 322);
    freq.put(" Bl", 487);
    freq.put(" Sc", 1446);
    freq.put(" Sa", 7117);
    freq.put(" Sd", 126);
    freq.put("hea", 136);
    freq.put("Ka", 14796);
    freq.put("rso", 232);
    freq.put("Kg", 139);
    freq.put("rsi", 2063);
    freq.put("Ke", 11600);
    freq.put("rsk", 111);
    freq.put("ogu", 135);
    freq.put("rse", 3167);
    freq.put("Ki", 2010);
    freq.put("Kh", 882);
    freq.put("Ko", 4380);
    freq.put("rsa", 1745);
    freq.put("rsb", 121);
    freq.put("Kl", 380);
    freq.put("Kr", 939);
    freq.put("ogo", 280);
    freq.put("R", 17401);
    freq.put("ogi", 1196);
    freq.put("udg", 308);
    freq.put("Ku", 4706);
    freq.put("rce", 252);
    freq.put(" Fl", 395);
    freq.put("rsu", 233);
    freq.put("Ky", 121);
    freq.put("udi", 1380);
    freq.put("oga", 366);
    freq.put("hau", 162);
    freq.put("lim", 5664);
    freq.put("vie", 296);
    freq.put("bek", 999);
    freq.put("ben", 3312);
    freq.put("bel", 3864);
    freq.put("beb", 1241);
    freq.put("sok", 132);
    freq.put("bea", 94);
    freq.put("beg", 153);
    freq.put("ehk", 131);
    freq.put("bez", 543);
    freq.put(" sa", 14469);
    freq.put("AL ", 81);
    freq.put("ik ", 10067);
    freq.put("\u0631\u0627", 86);
    freq.put(" Ru\u0308", 119);
    freq.put("ber", 24299);
    freq.put("bes", 2425);
    freq.put(" S ", 208);
    freq.put("ehi", 1102);
    freq.put("bet", 286);
    freq.put("seb", 39199);
    freq.put("Pap", 263);
    freq.put("Par", 2423);
    freq.put("Pas", 1115);
    freq.put("Pat", 250);
    freq.put("Pau", 192);
    freq.put("Pav", 366);
    freq.put("Pay", 578);
    freq.put(" Br", 2580);
    freq.put(" E ", 101);
    freq.put(" I ", 473);
    freq.put("wan", 4391);
    freq.put("Pad", 1577);
    freq.put("e\u0301ne\u0301", 87);
    freq.put("Pag", 90);
    freq.put("Pah", 601);
    freq.put("le ", 2220);
    freq.put("Pak", 472);
    freq.put("Pal", 1707);
    freq.put("Pam", 171);
    freq.put("Pan", 1375);
    freq.put("aw ", 128);
    freq.put("sk", 3092);
    freq.put("mik", 768);
    freq.put("sel", 4711);
    freq.put("obe", 749);
    freq.put("ck ", 760);
    freq.put(" Su\u0308", 116);
    freq.put("min", 2074);
    freq.put("\u0629", 256);
    freq.put(" By", 81);
    freq.put("mic", 168);
    freq.put("mid", 185);
    freq.put("mig", 85);
    freq.put("sej", 3739);
    freq.put("bur", 3331);
    freq.put("sei", 253);
    freq.put("bus", 270);
    freq.put("mis", 572);
    freq.put("seh", 881);
    freq.put("bup", 5795);
    freq.put("bic", 100);
    freq.put("gha", 1099);
    freq.put(" El", 545);
    freq.put(" Em", 827);
    freq.put(" En", 922);
    freq.put(" Eh", 94);
    freq.put(" Ei", 91);
    freq.put(" Ek", 289);
    freq.put(" Ed", 292);
    freq.put(" Ea", 212);
    freq.put(" Ec", 309);
    freq.put("pto", 107);
    freq.put(" Ex", 176);
    freq.put("ht", 1165);
    freq.put("awi", 616);
    freq.put("st ", 1090);
    freq.put(" Et", 117);
    freq.put(" Eu", 253);
    freq.put("awe", 1878);
    freq.put("hu", 13402);
    freq.put("ny ", 576);
    freq.put("awa", 14399);
    freq.put(" Es", 289);
    freq.put("cke", 401);
    freq.put("\u1100\u1161\u1100\u1161 ", 106);
    freq.put("lee", 98);
    freq.put("urg", 2337);
    freq.put("taa", 959);
    freq.put("mus", 917);
    freq.put("urb", 296);
    freq.put("buk", 2032);
    freq.put("kto", 892);
    freq.put("Pow", 89);
    freq.put("Pot", 126);
    freq.put("mur", 5500);
    freq.put("Por", 490);
    freq.put("Pos", 316);
    freq.put("Pop", 197);
    freq.put("ghi", 183);
    freq.put("Pon", 245);
    freq.put(" is", 1283);
    freq.put("Pol", 629);
    freq.put("Pok", 1401);
    freq.put("cks", 91);
    freq.put("mla", 599);
    freq.put("hn", 1231);
    freq.put("bia", 1988);
    freq.put("ury", 103);
    freq.put("ho", 3729);
    freq.put("dbi", 867);
    freq.put(" am", 705);
    freq.put("Den", 384);
    freq.put("Cha", 1124);
    freq.put("bum", 1048);
    freq.put("ksy", 183);
    freq.put("uah", 28489);
    freq.put("eda", 2175);
    freq.put("nge", 2966);
    freq.put("bua", 29593);
    freq.put("urt", 279);
    freq.put("nga", 40112);
    freq.put("jay", 698);
    freq.put("Mos", 127);
    freq.put("Mor", 550);
    freq.put("jat", 469);
    freq.put("jau", 469);
    freq.put("jar", 2821);
    freq.put("jas", 271);
    freq.put("Mou", 293);
    freq.put("Mot", 160);
    freq.put("jan", 2215);
    freq.put("q ", 402);
    freq.put("jal", 1171);
    freq.put("Moh", 709);
    freq.put("jaj", 319);
    freq.put("Mon", 755);
    freq.put("jah", 1005);
    freq.put("Jaw", 691);
    freq.put("jag", 216);
    freq.put("jad", 2581);
    freq.put("jab", 2775);
    freq.put("Mod", 145);
    freq.put("oto", 989);
    freq.put("no ", 1002);
    freq.put("bud", 788);
    freq.put("Ia ", 4390);
    freq.put("lsa", 202);
    freq.put("mum", 892);
    freq.put("uhu", 184);
    freq.put("ule", 183);
    freq.put("ira", 5164);
    freq.put("lei", 110);
    freq.put("\u044f ", 83);
    freq.put("liu", 162);
    freq.put("aer", 6596);
    freq.put("qu", 886);
    freq.put(" wa", 2574);
    freq.put("h", 223514);
    freq.put("nda", 19923);
    freq.put("Jal", 1059);
    freq.put(" wi", 5410);
    freq.put("qa", 200);
    freq.put("sha", 523);
    freq.put(" wu", 266);
    freq.put("Om", 176);
    freq.put("aed", 290);
    freq.put("bir", 1273);
    freq.put("Kam", 1464);
    freq.put("qi", 117);
    freq.put("shi", 687);
    freq.put("m2 ", 559);
    freq.put("ael", 376);
    freq.put("ja ", 3286);
    freq.put("Chu", 173);
    freq.put("Pr", 5037);
    freq.put("ebe", 4137);
    freq.put("eba", 11892);
    freq.put("Pu", 4399);
    freq.put("ual", 2564);
    freq.put("Py", 150);
    freq.put("vis", 1097);
    freq.put("C", 14172);
    freq.put("ke ", 4792);
    freq.put("jo ", 323);
    freq.put("ebu", 29935);
    freq.put("Pa", 11390);
    freq.put("yol", 401);
    freq.put("ebr", 729);
    freq.put("Pe", 16586);
    freq.put("ede", 990);
    freq.put("Ph", 402);
    freq.put("Pi", 2607);
    freq.put("Po", 3845);
    freq.put("Pl", 433);
    freq.put("lve", 96);
    freq.put("lur", 2937);
    freq.put("lus", 1161);
    freq.put("lut", 262);
    freq.put("ome", 1328);
    freq.put("\u0627", 1272);
    freq.put("gub", 432);
    freq.put("Rh", 2165);
    freq.put("dli", 128);
    freq.put("Ri", 1317);
    freq.put("mim", 282);
    freq.put(" Ip", 196);
    freq.put("et ", 3047);
    freq.put("luc", 152);
    freq.put("sot", 113);
    freq.put("lue", 130);
    freq.put("luh", 485);
    freq.put("lui", 805);
    freq.put("\u043b", 171);
    freq.put("lip", 802);
    freq.put("lul", 249);
    freq.put("omi", 1343);
    freq.put("rpi", 203);
    freq.put("ken", 4505);
    freq.put("jor", 354);
    freq.put("kel", 6287);
    freq.put("kek", 487);
    freq.put("kej", 496);
    freq.put("keh", 350);
    freq.put("keg", 389);
    freq.put("omo", 486);
    freq.put("kee", 288);
    freq.put("Sri", 518);
    freq.put("kec", 7220);
    freq.put("keb", 1435);
    freq.put("kea", 516);
    freq.put("\u0631\u0629 ", 90);
    freq.put("S", 49712);
    freq.put("eun", 154);
    freq.put("omm", 1191);
    freq.put("key", 94);
    freq.put("joh", 284);
    freq.put(" ad", 16501);
    freq.put("keu", 171);
    freq.put("ket", 2676);
    freq.put("jol", 87);
    freq.put("ker", 4473);
    freq.put("jon", 105);
    freq.put("kep", 5037);
    freq.put("etr", 602);
    freq.put(" ik", 452);
    freq.put("Zam", 306);
    freq.put("etw", 105);
    freq.put("ett", 299);
    freq.put("Zai", 220);
    freq.put("e\u0300", 291);
    freq.put("llu", 129);
    freq.put("jia", 666);
    freq.put("waj", 117);
    freq.put("aße", 85);
    freq.put("lu ", 2269);
    freq.put(" ah", 1386);
    freq.put("tla", 512);
    freq.put("eta", 22591);
    freq.put("ote", 516);
    freq.put("lo", 8490);
    freq.put(" Il", 313);
    freq.put("eth", 196);
    freq.put("eti", 3058);
    freq.put("etn", 374);
    freq.put(" aj", 154);
    freq.put(" il", 277);
    freq.put("ck", 2599);
    freq.put("\u4e01", 209);
    freq.put("ci", 8015);
    freq.put("ch", 6428);
    freq.put("co", 3401);
    freq.put("omu", 3500);
    freq.put("Her", 410);
    freq.put("cl", 364);
    freq.put("cc", 744);
    freq.put("Lok", 116);
    freq.put("ca", 17842);
    freq.put("Loi", 929);
    freq.put("Lon", 654);
    freq.put("rva", 107);
    freq.put("ce", 6430);
    freq.put("Lom", 266);
    freq.put("Lor", 631);
    freq.put("Los", 104);
    freq.put("cy", 378);
    freq.put("Est", 118);
    freq.put("rpe", 834);
    freq.put("Hea", 82);
    freq.put("Lot", 137);
    freq.put("Lou", 140);
    freq.put("Hel", 170);
    freq.put("cr", 524);
    freq.put("Hen", 128);
    freq.put("uck", 113);
    freq.put(" Ib", 1384);
    freq.put("cu", 2092);
    freq.put("ct", 1148);
    freq.put("Ger", 418);
    freq.put("vit", 347);
    freq.put("Jua", 218);
    freq.put("rve", 148);
    freq.put("iba", 1857);
    freq.put("ock", 424);
    freq.put("bbe", 102);
    freq.put("nop", 117);
    freq.put("Jun", 707);
    freq.put("yap", 186);
    freq.put("Jul", 729);
    freq.put("Jum", 163);
    freq.put("yam", 513);
    freq.put("ai", 38299);
    freq.put("yan", 47012);
    freq.put("yai", 2092);
    freq.put("yah", 7404);
    freq.put("yak", 3202);
    freq.put("pia", 417);
    freq.put(" at", 10219);
    freq.put("Geo", 314);
    freq.put("Gen", 396);
    freq.put("\u03bf", 114);
    freq.put("Gel", 192);
    freq.put("oth", 207);
    freq.put("oti", 361);
    freq.put("lgi", 113);
    freq.put("otl", 114);
    freq.put("otn", 85);
    freq.put("cop", 111);
    freq.put("hmu", 111);
    freq.put("AM ", 100);
    freq.put("c ", 1819);
    freq.put("cos", 92);
    freq.put("oha", 945);
    freq.put("urh", 114);
    freq.put("cor", 311);
    freq.put("hmi", 93);
    freq.put("hme", 81);
    freq.put("uin", 352);
    freq.put("ott", 294);
    freq.put("hma", 998);
    freq.put("cot", 159);
    freq.put("And", 339);
    freq.put("lli", 666);
    freq.put("Ang", 606);
    freq.put("Ana", 284);
    freq.put("e\u0301", 1443);
    freq.put("Ann", 89);
    freq.put("Ani", 107);
    freq.put("Ant", 1304);
    freq.put("Anu", 311);
    freq.put("tuk", 8612);
    freq.put("ar", 111647);
    freq.put("rbi", 3232);
    freq.put("uny", 2843);
    freq.put("uad", 168);
    freq.put("Hor", 109);
    freq.put("rbe", 1672);
    freq.put("eur", 163);
    freq.put("ya ", 19984);
    freq.put("rba", 16478);
    freq.put("at", 94936);
    freq.put("Dip", 183);
    freq.put("va", 1988);
    freq.put(" Fr", 765);
    freq.put(" Fu", 333);
    freq.put("ve", 5122);
    freq.put("Yog", 442);
    freq.put("vi", 7596);
    freq.put("ink", 392);
    freq.put("daf", 161);
    freq.put("vo", 1142);
    freq.put(" Fa", 1363);
    freq.put("vr", 113);
    freq.put("avo", 84);
    freq.put(" Fe", 1224);
    freq.put("vu", 82);
    freq.put(" Fi", 2557);
    freq.put("vy", 83);
    freq.put("Yor", 143);
    freq.put(" Fo", 858);
    freq.put("io ", 1306);
    freq.put("of ", 1293);
    freq.put("pis", 530);
    freq.put("tas", 2227);
    freq.put("RA ", 106);
    freq.put("edr", 119);
    freq.put("una", 5768);
    freq.put("fka", 157);
    freq.put("tud", 425);
    freq.put("vo ", 146);
    freq.put("e\u0301mo", 374);
    freq.put("dal", 29698);
    freq.put("kso", 141);
    freq.put("sem", 4327);
    freq.put("dam", 453);
    freq.put("ziz", 173);
    freq.put(" T ", 97);
    freq.put("v ", 487);
    freq.put("phi", 165);
    freq.put("hon", 510);
    freq.put("pho", 147);
    freq.put(" ap", 1132);
    freq.put("yre\u0301", 84);
    freq.put("pha", 505);
    freq.put("iot", 81);
    freq.put("ios", 146);
    freq.put("ior", 170);
    freq.put("phe", 134);
    freq.put("iop", 132);
    freq.put("ion", 3684);
    freq.put("phy", 98);
    freq.put("iol", 260);
    freq.put("dih", 643);
    freq.put("uni", 4206);
    freq.put("igs", 159);
    freq.put("dak", 3335);
    freq.put("igr", 98);
    freq.put("hoo", 173);
    freq.put("ont", 1746);
    freq.put("off", 261);
    freq.put("ofe", 269);
    freq.put("i", 560632);
    freq.put("uml", 587);
    freq.put(" Tu", 2312);
    freq.put("ofi", 103);
    freq.put(" Ts", 110);
    freq.put(" Tr", 1030);
    freq.put("sbu", 405);
    freq.put(" id", 186);
    freq.put(" To", 1798);
    freq.put("zog", 154);
    freq.put(" Ti", 5667);
    freq.put(" Th", 2050);
    freq.put("kki", 112);
    freq.put(" Te", 14107);
    freq.put("con", 891);
    freq.put(" Ta", 5685);
    freq.put("hol", 201);
    freq.put("onu", 81);
    freq.put("isu", 481);
    freq.put("Lag", 398);
    freq.put("dar", 25178);
    freq.put("\u3042\u3042", 178);
    freq.put("umo", 90);
    freq.put(" im", 275);
    freq.put("das", 913);
    freq.put("tch", 182);
    freq.put("mpe", 1217);
    freq.put(" Va", 900);
    freq.put(" Us", 180);
    freq.put("lex", 130);
    freq.put("Faz", 217);
    freq.put("Be", 7488);
    freq.put("adu", 655);
    freq.put("adr", 137);
    freq.put("Ba", 15003);
    freq.put(" \u0645", 146);
    freq.put("Bl", 490);
    freq.put("Fas", 81);
    freq.put("gma", 83);
    freq.put("Bo", 2057);
    freq.put("Bh", 473);
    freq.put("Bi", 1727);
    freq.put("Fat", 132);
    freq.put("day", 1071);
    freq.put("wes", 1940);
    freq.put("Bu", 5575);
    freq.put("add", 126);
    freq.put("Fai", 104);
    freq.put("Fan", 166);
    freq.put("Br", 2582);
    freq.put("ada", 44005);
    freq.put("ado", 684);
    freq.put("sko", 166);
    freq.put("adm", 127);
    freq.put(" s ", 516);
    freq.put("By", 81);
    freq.put("adh", 132);
    freq.put("adi", 4970);
    freq.put("Sak", 152);
    freq.put(" \u0627", 503);
    freq.put(" \u0628", 135);
    freq.put(" Ag", 886);
    freq.put("nfe", 134);
    freq.put(" \u0633", 132);
    freq.put("nve", 165);
    freq.put("T", 34101);
    freq.put("ign", 291);
    freq.put("Sao", 85);
    freq.put("ngh", 1384);
    freq.put("tic", 397);
    freq.put("nvi", 88);
    freq.put("we ", 145);
    freq.put("B ", 922);
    freq.put("l ", 29072);
    freq.put(" mu", 4333);
    freq.put("oh ", 1421);
    freq.put("igi", 732);
    freq.put("ad ", 3530);
    freq.put("igh", 815);
    freq.put("Saa", 187);
    freq.put("nja", 4869);
    freq.put("Sud", 110);
    freq.put("Sub", 100);
    freq.put("Sua", 114);
    freq.put("ui ", 1412);
    freq.put("Sun", 2363);
    freq.put("Sum", 1496);
    freq.put("Sul", 3001);
    freq.put("Suk", 631);
    freq.put("rec", 165);
    freq.put("Sus", 89);
    freq.put("Sur", 638);
    freq.put("X", 535);
    freq.put("Sup", 214);
    freq.put("jli", 517);
    freq.put("U ", 260);
    freq.put("su ", 534);
    freq.put("esw", 856);
    freq.put("esu", 1224);
    freq.put("est", 2090);
    freq.put("ess", 1053);
    freq.put("esp", 92);
    freq.put("nd ", 4902);
    freq.put("hwi", 126);
    freq.put(" hi", 2680);
    freq.put("esy", 124);
    freq.put("tma", 120);
    freq.put("ese", 3188);
    freq.put("esc", 110);
    freq.put("iso", 280);
    freq.put("esa", 9499);
    freq.put("eso", 358);
    freq.put(" ho", 310);
    freq.put("esl", 106);
    freq.put("esk", 117);
    freq.put("esi", 13843);
    freq.put("esh", 228);
    freq.put("swi", 860);
    freq.put("Uz", 98);
    freq.put("Ut", 2903);
    freq.put("\u4e4b", 243);
    freq.put("Up", 83);
    freq.put("Us", 180);
    freq.put("Ur", 241);
    freq.put("Um", 385);
    freq.put("Ul", 440);
    freq.put("Un", 2182);
    freq.put("Uk", 86);
    freq.put("Ud", 348);
    freq.put("Ub", 107);
    freq.put("sek", 3390);
    freq.put("jam", 827);
    freq.put("Sco", 163);
    freq.put("eb ", 216);
    freq.put("Sch", 1149);
    freq.put("ndo", 10238);
    freq.put(" ju", 4534);
    freq.put("nde", 2188);
    freq.put("nos", 240);
    freq.put("kri", 758);
    freq.put(" ji", 417);
    freq.put("by ", 195);
    freq.put("es ", 6607);
    freq.put(" je", 1297);
    freq.put("\u4e09 ", 110);
    freq.put("nds", 418);
    freq.put("kra", 370);
    freq.put(" ja", 4995);
    freq.put("o\u0302te", 452);
    freq.put("kre", 451);
    freq.put("duc", 125);
    freq.put("owi", 119);
    freq.put("o\u0308e", 242);
    freq.put("owe", 160);
    freq.put("ea ", 1116);
    freq.put("owa", 312);
    freq.put("hou", 148);
    freq.put("o\u0308r", 194);
    freq.put("rya", 582);
    freq.put("my ", 225);
    freq.put("De ", 309);
    freq.put("h ", 128258);
    freq.put("ows", 189);
    freq.put("Ami", 153);
    freq.put("yri", 256);
    freq.put("AN ", 625);
    freq.put("ubo", 151);
    freq.put("van", 369);
    freq.put("val", 198);
    freq.put("Ama", 359);
    freq.put("rcu", 188);
    freq.put("hor", 1332);
    freq.put("Ame", 2205);
    freq.put("isc", 471);
    freq.put("vad", 278);
    freq.put("ee", 2807);
    freq.put("rco", 88);
    freq.put("rch", 578);
    freq.put("rci", 124);
    freq.put("var", 225);
    freq.put("Amp", 255);
    freq.put("Amu", 131);
    freq.put("rca", 846);
    freq.put("vat", 140);
    freq.put("eak", 120);
    freq.put("hy", 546);
    freq.put("eam", 160);
    freq.put("Kla", 249);
    freq.put("ean", 542);
    freq.put("hr", 1238);
    freq.put("hs", 425);
    freq.put("Der", 103);
    freq.put("Des", 621);
    freq.put("eae", 222);
    freq.put("hw", 450);
    freq.put("Dev", 116);
    freq.put("Dew", 569);
    freq.put("hk", 2033);
    freq.put("buh", 3221);
    freq.put("hi", 14383);
    freq.put("Del", 214);
    freq.put("Dem", 195);
    freq.put("hl", 3211);
    freq.put("hm", 1374);
    freq.put("hb", 328);
    freq.put("Dea", 94);
    freq.put("eas", 200);
    freq.put("ha", 43380);
    freq.put("eau", 189);
    freq.put("KR ", 83);
    freq.put("hd", 641);
    freq.put("he", 6433);
    freq.put("dma", 725);
    freq.put("Tek", 246);
    freq.put("Tel", 885);
    freq.put("Tem", 412);
    freq.put("Ten", 4201);
    freq.put("Teo", 86);
    freq.put("Tea", 82);
    freq.put("Teb", 161);
    freq.put("j", 47182);
    freq.put("ow ", 425);
    freq.put("lva", 321);
    freq.put("Lud", 173);
    freq.put("Ter", 7545);
    freq.put("Tet", 82);
    freq.put("pih", 341);
    freq.put("pik", 502);
    freq.put("pil", 749);
    freq.put("iny", 1962);
    freq.put("pin", 1830);
    freq.put("pio", 81);
    freq.put("int", 4295);
    freq.put("inu", 307);
    freq.put("pic", 128);
    freq.put("pid", 110);
    freq.put("rud", 184);
    freq.put("ins", 5288);
    freq.put("inl", 149);
    freq.put("inm", 85);
    freq.put("inn", 244);
    freq.put("Uta", 2604);
    freq.put("inh", 91);
    freq.put("ini", 10223);
    freq.put("inj", 440);
    freq.put("et", 34806);
    freq.put("ind", 2963);
    freq.put("ine", 3802);
    freq.put("inf", 140);
    freq.put("ing", 16551);
    freq.put("pit", 518);
    freq.put("ina", 9402);
    freq.put("inb", 149);
    freq.put("inc", 592);
    freq.put("wal", 2126);
    freq.put("hn ", 373);
    freq.put("eo ", 687);
    freq.put(" Uz", 98);
    freq.put(" Ut", 2902);
    freq.put("oan", 123);
    freq.put("bka", 467);
    freq.put("oal", 112);
    freq.put(" Up", 83);
    freq.put(" Ur", 240);
    freq.put("Lum", 953);
    freq.put(" Ul", 439);
    freq.put(" Um", 384);
    freq.put(" Un", 2175);
    freq.put("Afr", 636);
    freq.put("dim", 977);
    freq.put(" Uk", 86);
    freq.put(" Ud", 348);
    freq.put("rgk", 87);
    freq.put("\u043d", 181);
    freq.put("gau", 156);
    freq.put(" Ub", 106);
    freq.put("ubu", 2193);
    freq.put("Aca", 95);
    freq.put("DA ", 144);
    freq.put("Ace", 1263);
    freq.put("pi ", 1888);
    freq.put("gas", 1063);
    freq.put("ho\u0302", 463);
    freq.put("gar", 7736);
    freq.put("ube", 118);
    freq.put("Kel", 1647);
    freq.put("U", 8179);
    freq.put("ufa", 96);
    freq.put("ubl", 997);
    freq.put("aji", 1471);
    freq.put("Op", 211);
    freq.put("gap", 1128);
    freq.put("in ", 11178);
    freq.put("ubi", 233);
    freq.put("tan", 37185);
    freq.put("eog", 153);
    freq.put("Dom", 132);
    freq.put("oa ", 251);
    freq.put("uji", 209);
    freq.put("eon", 238);
    freq.put("olf", 106);
    freq.put("eol", 252);
    freq.put("eor", 3629);
    freq.put("eop", 100);
    freq.put("tin", 5400);
    freq.put("hny", 592);
    freq.put("rep", 182);
    freq.put("MS ", 96);
  }
  
}

