package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ML extends CLangProfile {
  private static final String name = "ml";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ML() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 1303092;
    n_words[1] = 1392078;
    n_words[2] = 987774;

    freq.put("\u0d28\u0d7d", 278);
    freq.put(" \u0d35", 10435);
    freq.put("\u0d41\u0d33\u0d02", 204);
    freq.put(" \u0d2d\u0d30", 361);
    freq.put("\u0d7c\u0d37\u0d24", 185);
    freq.put(" \u0d2d\u0d3e", 1188);
    freq.put("\u0d1e", 4086);
    freq.put("\u0d2e ", 394);
    freq.put("\u0d28\u0d47\u0d3e", 770);
    freq.put("\u0d28\u0d4d", 30257);
    freq.put("\u0d2d\u0d15\u0d4d", 141);
    freq.put("\u0d28\u0d40", 1069);
    freq.put("\u0d2f\u0d2a\u0d4d", 1110);
    freq.put("\u0d28\u0d46", 1274);
    freq.put("\u0d28\u0d47", 692);
    freq.put("\u0d38\u0d47\u0d3e\u0d2b", 142);
    freq.put("\u0d28\u0d38", 256);
    freq.put("\u0d1f\u0d4d\u0d30", 721);
    freq.put("\u0d28\u0d3e", 4964);
    freq.put("\u0d28\u0d3f", 6348);
    freq.put("\u0d28\u0d32", 133);
    freq.put("\u0d28\u0d31", 327);
    freq.put("\u0d47\u0d3e\u0d21\u0d4d", 151);
    freq.put("\u0d1a\u0d2f", 168);
    freq.put("\u0d28\u0d2a", 369);
    freq.put("\u0d2f\u0d38\u0d4d", 188);
    freq.put("\u0d28\u0d28", 662);
    freq.put("\u0d28\u0d2e", 1154);
    freq.put("\u0d28\u0d2f", 493);
    freq.put("\u0d2e\u0d4d\u0d2f", 161);
    freq.put("\u0d2a\u0d47\u0d30", 707);
    freq.put("\u0d36\u0d47\u0d37", 320);
    freq.put("\u0d36\u0d47\u0d30", 218);
    freq.put("\u0d41\u0d33\u0d4d", 2528);
    freq.put("\u0d28\u0d19", 658);
    freq.put("\u0d26\u0d47\u0d39", 453);
    freq.put(" \u0d2d\u0d42", 280);
    freq.put("\u0d26\u0d47\u0d35", 242);
    freq.put("\u0d26\u0d47\u0d36", 1461);
    freq.put("\u0d1f\u0d4d\u0d1f", 5142);
    freq.put("\u0d28\u0d17", 483);
    freq.put("\u0d46\u0d3e\u0d32", 199);
    freq.put("\u0d46\u0d3e\u0d33", 210);
    freq.put("\u0d46\u0d3e\u0d28", 285);
    freq.put("\u0d46\u0d3e\u0d24", 283);
    freq.put("\u0d1f\u0d3e\u0d15", 287);
    freq.put("\u0d24\u0d30\u0d02", 239);
    freq.put("\u0d09", 3287);
    freq.put("\u0d17\u0d19\u0d4d", 342);
    freq.put("n", 3585);
    freq.put("\u0d1e\u0d3e\u0d31", 228);
    freq.put("G", 214);
    freq.put("\u0d4d\u0d27\u0d24", 135);
    freq.put("p ", 313);
    freq.put("\u0d30\u0d3f\u0d7d", 376);
    freq.put(" \u0d7d ", 540);
    freq.put("\u0d28\u0d3f ", 376);
    freq.put("\u0d4d\u0d27\u0d3f", 284);
    freq.put("\u0d4d\u0d27\u0d3e", 165);
    freq.put("\u0d28\u0d41 ", 3729);
    freq.put("\u0d38\u0d28\u0d4d", 155);
    freq.put("\u0d30\u0d3f\u0d1f", 191);
    freq.put("\u0d30\u0d3f\u0d1a", 602);
    freq.put("\u0d4d\u0d1f\u0d46", 178);
    freq.put("\u0d37\u0d4d ", 469);
    freq.put(" \u0d18", 145);
    freq.put("\u0d30\u0d3f\u0d2f", 788);
    freq.put("\u0d30\u0d3f\u0d2a", 260);
    freq.put("\u0d30\u0d3f\u0d28", 226);
    freq.put("k", 455);
    freq.put("\u0d30\u0d3f\u0d38", 279);
    freq.put("\u0d4d\u0d33\u0d24", 321);
    freq.put("\u0d30\u0d3f\u0d32", 203);
    freq.put("\u0d3f\u0d2e\u0d3e", 267);
    freq.put(" \u0d17\u0d23", 178);
    freq.put(" \u0d09\u0d7e", 449);
    freq.put("\u0d4d\u0d1f\u0d23", 266);
    freq.put("\u0d08", 1751);
    freq.put("\u0d15\u0d47 ", 146);
    freq.put("\u0d3f\u0d7d", 7943);
    freq.put("\u0d4d\u0d1f\u0d24", 365);
    freq.put("\u0d4d\u0d1f\u0d3f", 1743);
    freq.put("\u0d4d\u0d1f\u0d3e", 1065);
    freq.put("\u0d28\u0d46\u0d2f", 183);
    freq.put(" \u0d17\u0d3e", 220);
    freq.put("\u0d3f\u0d7b", 555);
    freq.put("\u0d4d\u0d1f\u0d31", 139);
    freq.put("\u0d15\u0d34\u0d3f", 190);
    freq.put("\u0d32\u0d46\u0d3e\u0d28", 171);
    freq.put("\u0d30\u0d02\u0d17", 221);
    freq.put("m ", 405);
    freq.put("\u0d4d\u0d1f\u0d02", 148);
    freq.put("\u0d38\u0d02", 2540);
    freq.put("er ", 252);
    freq.put(" \u0d07\u0d28", 1407);
    freq.put("\u0d41\u0d24\u0d3f", 335);
    freq.put("\u0d2a\u0d1f\u0d3f", 267);
    freq.put("\u0d24\u0d3f\u0d30", 1091);
    freq.put("\u0d2e\u0d31\u0d4d", 307);
    freq.put("\u0d32\u0d42\u0d1f", 241);
    freq.put("\u0d38\u0d02\u0d38", 658);
    freq.put("\u0d38\u0d02\u0d35", 186);
    freq.put("\u0d48", 2243);
    freq.put(" \u0d09\u0d33", 175);
    freq.put("\u0d38\u0d02\u0d2d", 157);
    freq.put("\u0d38\u0d02\u0d2c", 143);
    freq.put(" \u0d09\u0d2a", 1087);
    freq.put(" \u0d09\u0d2f", 159);
    freq.put(" \u0d09\u0d23", 345);
    freq.put(" \u0d09\u0d24", 324);
    freq.put(" \u0d09\u0d26", 192);
    freq.put("me", 225);
    freq.put("\u0d28\u0d41", 7416);
    freq.put("ma", 277);
    freq.put("\u0d38\u0d02\u0d18", 223);
    freq.put("\u0d4d\u0d1f\u0d4d", 2062);
    freq.put("mb", 320);
    freq.put("\u0d35\u0d47\u0d23", 171);
    freq.put("\u0d38\u0d02\u0d17", 292);
    freq.put("\u0d38\u0d02\u0d16", 216);
    freq.put("mi", 137);
    freq.put("\u0d35\u0d47\u0d26", 193);
    freq.put(" \u0d07\u0d1f", 294);
    freq.put("\u0d2a\u0d3e\u0d7c", 143);
    freq.put("\u0d35\u0d47\u0d37", 140);
    freq.put("\u0d25\u0d2e\u0d3e", 131);
    freq.put("\u0d35\u0d24\u0d4d", 265);
    freq.put("\u0d2f\u0d4d", 2647);
    freq.put("\u0d2f\u0d47\u0d3e", 2076);
    freq.put("io", 368);
    freq.put("\u0d4d\u0d31\u0d4d", 2584);
    freq.put("\u0d2f\u0d47", 524);
    freq.put("\u0d2f\u0d46", 576);
    freq.put("in", 824);
    freq.put("\u0d2f\u0d42", 920);
    freq.put("\u0d2f\u0d41", 6606);
    freq.put("\u0d40\u0d2f", 989);
    freq.put("\u0d46\u0d3e\u0d1f", 319);
    freq.put("\u0d38\u0d3f ", 306);
    freq.put("\u0d40\u0d30", 476);
    freq.put("\u0d41\u0d23", 1220);
    freq.put("\u0d33", 18695);
    freq.put("\u0d40\u0d31", 467);
    freq.put("ent", 145);
    freq.put("\u0d32\u0d40\u0d37", 334);
    freq.put("\u0d35\u0d32\u0d3f", 422);
    freq.put("\u0d33\u0d2e", 142);
    freq.put("A", 497);
    freq.put("\u0d3f\u0d38\u0d4d", 1202);
    freq.put("\u0d7a ", 614);
    freq.put("\u0d1f\u0d41\u0d35", 240);
    freq.put("\u0d07\u0d1f", 298);
    freq.put("\u0d28\u0d4d\u0d24", 3077);
    freq.put("\u0d7e\u0d2a", 377);
    freq.put("\u0d2f\u0d19", 585);
    freq.put("\u0d2f\u0d15", 899);
    freq.put("\u0d28\u0d35", 539);
    freq.put("\u0d40\u0d38", 331);
    freq.put("\u0d2f\u0d2f", 1033);
    freq.put("\u0d2f\u0d2e", 1442);
    freq.put(" \u0d0e\u0d32", 187);
    freq.put("\u0d2f\u0d2a", 1289);
    freq.put("\u0d2f\u0d28", 858);
    freq.put("\u0d2f\u0d24", 3000);
    freq.put("\u0d7e\u0d15", 618);
    freq.put("\u0d32\u0d4d\u0d2f", 139);
    freq.put("\u0d34\u0d41\u0d24", 366);
    freq.put("\u0d2f\u0d3e", 6131);
    freq.put("\u0d43\u0d36", 256);
    freq.put("\u0d40\u0d30\u0d24", 159);
    freq.put("\u0d2f\u0d35", 498);
    freq.put("\u0d33\u0d24", 1504);
    freq.put("\u0d2f\u0d32", 155);
    freq.put("\u0d2c\u0d4d", 1417);
    freq.put("\u0d7c\u0d23", 557);
    freq.put("\u0d47\u0d3e ", 1249);
    freq.put("\u0d35\u0d3f\u0d27", 550);
    freq.put("\u0d35\u0d3f\u0d26", 293);
    freq.put("\u0d35\u0d3f\u0d24", 325);
    freq.put("\u0d35\u0d3f\u0d28", 462);
    freq.put("\u0d35\u0d3f\u0d2f", 254);
    freq.put("\u0d35\u0d3f\u0d2d", 320);
    freq.put("\u0d35\u0d3f\u0d33", 304);
    freq.put("\u0d35\u0d3f\u0d32", 388);
    freq.put("\u0d35\u0d3f\u0d37", 250);
    freq.put("\u0d35\u0d3f\u0d36", 604);
    freq.put("\u0d35\u0d3f\u0d35", 377);
    freq.put("\u0d35\u0d3f\u0d38", 175);
    freq.put(" \u0d2e\u0d47\u0d3e", 137);
    freq.put("\u0d4d\u0d28\u0d4d", 1214);
    freq.put("\u0d41\u0d30", 1360);
    freq.put(" \u0d2e\u0d41", 1582);
    freq.put(" \u0d2e\u0d40", 223);
    freq.put(" \u0d2e\u0d42", 522);
    freq.put("\u0d4d\u0d28\u0d42", 143);
    freq.put(" \u0d2e\u0d47", 380);
    freq.put(" \u0d2e\u0d46", 288);
    freq.put("\u0d28\u0d24", 3826);
    freq.put("\u0d35\u0d3f\u0d15", 518);
    freq.put("\u0d41\u0d2e\u0d4d", 328);
    freq.put("\u0d13\u0d2b\u0d4d", 164);
    freq.put("\u0d35\u0d3f\u0d1a", 163);
    freq.put("\u0d35\u0d3f\u0d1f", 354);
    freq.put("\u0d2a\u0d28\u0d3f", 191);
    freq.put("\u0d06\u0d15", 235);
    freq.put(" \u0d2e\u0d28", 430);
    freq.put("\u0d2e\u0d24\u0d4d", 656);
    freq.put(" \u0d2e\u0d23", 230);
    freq.put("\u0d46\u0d3e", 2828);
    freq.put("\u0d2a\u0d28\u0d4d", 169);
    freq.put("\u0d32\u0d2d\u0d3f", 141);
    freq.put("\u0d1a\u0d41 ", 503);
    freq.put(" \u0d2e\u0d26", 178);
    freq.put(" \u0d2e\u0d39", 339);
    freq.put("\u0d4d\u0d28\u0d3f", 970);
    freq.put("\u0d7c\u0d15", 724);
    freq.put(" \u0d2e\u0d3f", 342);
    freq.put(" \u0d2e\u0d3e", 1333);
    freq.put("\u0d39\u0d02 ", 356);
    freq.put(" \u0d2e\u0d30", 285);
    freq.put(" \u0d2e\u0d32", 1061);
    freq.put("\u0d3e\u0d2f ", 2610);
    freq.put("\u0d40\u0d31\u0d4d", 411);
    freq.put("\u0d35\u0d3f\u0d7d", 193);
    freq.put("\u0d28\u0d1f", 732);
    freq.put("\u0d19\u0d7e ", 1356);
    freq.put("\u0d2a\u0d3e\u0d24", 301);
    freq.put("l", 2378);
    freq.put("\u0d05\u0d24\u0d3f", 433);
    freq.put("\u0d02\u0d15", 276);
    freq.put("\u0d2e\u0d2a\u0d1e", 718);
    freq.put("\u0d4d\u0d26\u0d41", 211);
    freq.put("\u0d30\u0d2e\u0d3e", 1123);
    freq.put("\u0d46\u0d3e\u0d30", 233);
    freq.put("\u0d46\u0d2f\u0d3e", 471);
    freq.put("\u0d46\u0d2f\u0d3f", 161);
    freq.put("\u0d40\u0d15\u0d30", 447);
    freq.put("\u0d4d\u0d26\u0d4d", 530);
    freq.put("\u0d24\u0d24\u0d4d", 650);
    freq.put("\u0d28\u0d15", 609);
    freq.put("rt", 139);
    freq.put("\u0d3f\u0d39", 196);
    freq.put("\u0d7c\u0d17\u0d4d", 232);
    freq.put("\u0d3f\u0d02\u0d17", 155);
    freq.put("\u0d3f\u0d38", 1623);
    freq.put("ry", 142);
    freq.put("re", 445);
    freq.put("\u0d35", 29294);
    freq.put("ra", 513);
    freq.put("ro", 259);
    freq.put("ri", 601);
    freq.put("\u0d38\u0d24", 207);
    freq.put("\u0d28\u0d02", 1457);
    freq.put("\u0d3f\u0d30", 3940);
    freq.put("\u0d41\u0d02 ", 8335);
    freq.put("\u0d2f\u0d28\u0d3e", 300);
    freq.put("\u0d36\u0d38", 408);
    freq.put("ati", 208);
    freq.put("\u0d40\u0d15\u0d4d", 294);
    freq.put("r ", 518);
    freq.put("\u0d46\u0d2f\u0d41", 744);
    freq.put("\u0d30\u0d2e\u0d41", 245);
    freq.put("\u0d46\u0d2f\u0d4d", 1600);
    freq.put("\u0d46\u0d3e\u0d23", 430);
    freq.put("\u0d17\u0d2e\u0d3e", 450);
    freq.put("\u0d4d\u0d26\u0d3f", 192);
    freq.put("\u0d36\u0d24", 359);
    freq.put("\u0d36\u0d28", 174);
    freq.put("on ", 337);
    freq.put("\u0d3f\u0d32 ", 173);
    freq.put("\u0d36\u0d2f", 135);
    freq.put("\u0d36\u0d30", 163);
    freq.put("\u0d25\u0d3f\u0d24", 865);
    freq.put("\u0d3e\u0d36\u0d3f", 190);
    freq.put("\u0d36\u0d3e", 1071);
    freq.put("\u0d1a\u0d15\u0d4d", 148);
    freq.put("\u0d15\u0d33\u0d46", 330);
    freq.put("\u0d36\u0d02", 401);
    freq.put("\u0d15\u0d33\u0d41", 895);
    freq.put("\u0d0e\u0d28", 4361);
    freq.put("\u0d3f\u0d1f\u0d15", 167);
    freq.put("\u0d15\u0d25\u0d3e", 145);
    freq.put("\u0d32 ", 970);
    freq.put("\u0d34", 3384);
    freq.put("\u0d36\u0d19", 339);
    freq.put("\u0d36\u0d19\u0d4d", 338);
    freq.put("\u0d16 ", 135);
    freq.put("B", 279);
    freq.put("\u0d15\u0d46 ", 257);
    freq.put("\u0d47\u0d15\u0d4d", 437);
    freq.put("\u0d24\u0d3e\u0d02", 142);
    freq.put("\u0d4d\u0d1e\u0d3e", 395);
    freq.put("\u0d2c\u0d28", 358);
    freq.put("\u0d15\u0d33\u0d3f", 1388);
    freq.put("\u0d15\u0d33\u0d3e", 321);
    freq.put("\u0d28\u0d47\u0d24", 186);
    freq.put("\u0d36\u0d40", 345);
    freq.put("\u0d28\u0d47\u0d1f", 136);
    freq.put("\u0d36\u0d42", 214);
    freq.put("\u0d3f\u0d1f\u0d46", 160);
    freq.put("\u0d36\u0d47", 646);
    freq.put("\u0d3f\u0d1f\u0d4d", 804);
    freq.put("\u0d2e\u0d40\u0d31", 381);
    freq.put("\u0d36\u0d4d", 1951);
    freq.put("\u0d46\u0d32\u0d4d", 138);
    freq.put("\u0d46\u0d3e\u0d33\u0d4d", 135);
    freq.put("\u0d3f\u0d15", 9608);
    freq.put(" \u0d38\u0d47\u0d3e", 248);
    freq.put("\u0d42\u0d28\u0d4d", 269);
    freq.put("\u0d7c\u0d1c", 233);
    freq.put("\u0d15\u0d41\u0d31", 545);
    freq.put("\u0d15\u0d41\u0d33", 420);
    freq.put("\u0d15\u0d41\u0d35", 161);
    freq.put("\u0d15\u0d41\u0d28", 3755);
    freq.put("\u0d02\u0d16", 254);
    freq.put(" \u0d38\u0d48", 131);
    freq.put("\u0d34\u0d15\u0d4d", 419);
    freq.put("\u0d15\u0d41\u0d2e", 280);
    freq.put("\u0d02\u0d18", 229);
    freq.put("\u0d1f", 30378);
    freq.put("\u0d15\u0d41\u0d1f", 502);
    freq.put("\u0d35\u0d46\u0d2f", 137);
    freq.put("\u0d1c\u0d4d ", 184);
    freq.put("\u0d02\u0d2d", 344);
    freq.put("\u0d15\u0d41\u0d15", 537);
    freq.put("\u0d1a\u0d3e", 2146);
    freq.put("\u0d47\u0d3e\u0d2e\u0d40", 259);
    freq.put("\u0d02\u0d35", 207);
    freq.put("\u0d02\u0d36", 210);
    freq.put("hum", 268);
    freq.put("\u0d35\u0d46\u0d33", 233);
    freq.put("\u0d02\u0d38", 820);
    freq.put(" \u0d38\u0d41", 414);
    freq.put("\u0d36\u0d3f", 810);
    freq.put("\u0d32\u0d41\u0d02", 1211);
    freq.put("\u0d32\u0d41\u0d15", 166);
    freq.put("\u0d41\u0d7b", 211);
    freq.put("\u0d26\u0d4d ", 330);
    freq.put("\u0d1a\u0d30", 413);
    freq.put("m", 1762);
    freq.put("\u0d41\u0d7c", 254);
    freq.put("\u0d30\u0d15\u0d3e", 407);
    freq.put("\u0d32\u0d41\u0d33", 500);
    freq.put("\u0d23\u0d41\u0d4d", 155);
    freq.put("\u0d02\u0d16\u0d4d", 225);
    freq.put("\u0d02\u0d2c\u0d7c", 289);
    freq.put("\u0d06", 4557);
    freq.put("d ", 539);
    freq.put("\u0d4d\u0d27\u0d2e", 162);
    freq.put("\u0d35\u0d32", 693);
    freq.put("\u0d7c\u0d26\u0d4d", 196);
    freq.put("\u0d09\u0d2a\u0d2f", 669);
    freq.put("\u0d46", 27110);
    freq.put("de", 246);
    freq.put("\u0d07\u0d35", 544);
    freq.put("da", 131);
    freq.put("\u0d02\u0d2c\u0d24", 191);
    freq.put("\u0d32\u0d3e ", 171);
    freq.put("\u0d07\u0d32", 190);
    freq.put("\u0d07\u0d30", 190);
    freq.put("\ufffd", 641);
    freq.put("\u0d4d\u0d25", 3459);
    freq.put("\u0d4d\u0d24", 22771);
    freq.put("\u0d4d\u0d27", 1930);
    freq.put("\u0d4d\u0d26", 2047);
    freq.put("\u0d4d\u0d21", 591);
    freq.put("\u0d34\u0d3f\u0d2f", 159);
    freq.put("\u0d4d\u0d23", 1196);
    freq.put("w ", 236);
    freq.put("\u0d2b\u0d47\u0d3e", 209);
    freq.put("\u0d4d\u0d2c", 173);
    freq.put("\u0d4d\u0d2f", 11234);
    freq.put("\u0d4d\u0d2e", 2196);
    freq.put("\u0d4d\u0d28", 18960);
    freq.put("\u0d3f\u0d2f\u0d7b", 295);
    freq.put("\u0d4d\u0d2a", 9300);
    freq.put("\u0d4d\u0d35", 2298);
    freq.put("\u0d4d\u0d37", 2226);
    freq.put("\u0d4d\u0d36", 389);
    freq.put("\u0d4d\u0d31", 10182);
    freq.put("\u0d4d\u0d30", 16053);
    freq.put("\u0d4d\u0d33", 3597);
    freq.put("\u0d4d\u0d32", 4477);
    freq.put("\u0d38\u0d30", 276);
    freq.put("\u0d07\u0d38", 231);
    freq.put("\u0d4d\u0d38", 1373);
    freq.put("\u0d3e\u0d30\u0d02", 468);
    freq.put("\u0d3e\u0d30\u0d3f", 539);
    freq.put("\u0d3e\u0d30\u0d3e", 454);
    freq.put("\u0d31\u0d3e\u0d23", 337);
    freq.put("\u0d1f\u0d41\u0d02", 382);
    freq.put("\u0d1f\u0d2f\u0d3f", 180);
    freq.put("\u0d31", 22910);
    freq.put("\u0d3f\u0d2f\u0d47", 145);
    freq.put("\u0d3f\u0d2f\u0d46", 180);
    freq.put("\u0d3f\u0d2f\u0d41", 1173);
    freq.put("\u0d3e\u0d30\u0d28", 265);
    freq.put("\u0d3e\u0d30\u0d24", 490);
    freq.put("\u0d4d\u0d1f", 9563);
    freq.put("\u0d4d\u0d1e", 1123);
    freq.put("\u0d4d\u0d19", 6013);
    freq.put("\u0d3f\u0d2f\u0d47\u0d3e", 318);
    freq.put("\u0d34\u0d3f\u0d15", 261);
    freq.put("C", 430);
    freq.put("\u0d27\u0d4d\u0d2f", 502);
    freq.put("\u0d3f\u0d2f\u0d3f", 1237);
    freq.put("\u0d3f\u0d2f\u0d3e", 1791);
    freq.put("\u0d3e\u0d30\u0d4d", 247);
    freq.put("\u0d3f\u0d2f\u0d24", 291);
    freq.put("\u0d4d\u0d27\u0d4d", 347);
    freq.put(" In", 137);
    freq.put("\u0d2a\u0d02 ", 271);
    freq.put("\u0d3f\u0d2f\u0d2f", 135);
    freq.put("\u0d3f\u0d2f\u0d2e", 337);
    freq.put("\u0d3e\u0d30\u0d41", 187);
    freq.put("\u0d3f\u0d2f\u0d28", 152);
    freq.put("\u0d3f\u0d2f\u0d2a", 914);
    freq.put("\u0d15\u0d7e ", 1360);
    freq.put("\u0d38\u0d47\u0d3e", 402);
    freq.put("\u0d2e\u0d42\u0d39", 169);
    freq.put("\u0d38\u0d4d", 11156);
    freq.put("\u0d38\u0d42", 414);
    freq.put("\u0d2e\u0d42\u0d32", 253);
    freq.put("\u0d38\u0d40", 147);
    freq.put("\u0d38\u0d41", 655);
    freq.put("\u0d38\u0d46", 370);
    freq.put("\u0d38\u0d47", 205);
    freq.put("\u0d2b\u0d32", 133);
    freq.put("\u0d2e\u0d42\u0d28", 234);
    freq.put("\u0d3f\u0d2f\u0d02", 136);
    freq.put("\u0d2b\u0d3f", 226);
    freq.put(" \u0d39\u0d48", 162);
    freq.put("\u0d15\u0d7d", 282);
    freq.put("\u0d37\u0d28", 151);
    freq.put("\u0d35\u0d7c ", 251);
    freq.put("\u0d30\u0d3f\u0d15", 1867);
    freq.put("\u0d30", 47335);
    freq.put("\u0d3e\u0d32 ", 148);
    freq.put("\u0d35\u0d34\u0d3f", 162);
    freq.put("\u0d7b\u0d38", 353);
    freq.put("\u0d1f\u0d3f ", 838);
    freq.put("\u0d47\u0d37\u0d7b", 136);
    freq.put("\u0d35\u0d02\u0d36", 155);
    freq.put("\u0d36\u0d3e\u0d32", 131);
    freq.put("\u0d47\u0d23\u0d4d", 180);
    freq.put("\u0d36\u0d3e\u0d38", 704);
    freq.put(" \u0d39\u0d3e", 165);
    freq.put(" \u0d39\u0d3f", 383);
    freq.put("\u0d0e\u0d38\u0d4d", 144);
    freq.put("\u0d30\u0d3f\u0d24", 358);
    freq.put("\u0d31\u0d41 ", 169);
    freq.put("\u0d1f\u0d41\u0d15", 629);
    freq.put("\u0d3f\u0d7c", 824);
    freq.put("\u0d7c\u0d1a\u0d4d", 198);
    freq.put("\u0d24\u0d3f\u0d32", 2687);
    freq.put("is", 392);
    freq.put("\u0d24\u0d3f\u0d31", 164);
    freq.put("it", 348);
    freq.put("\u0d2f\u0d3e\u0d15", 148);
    freq.put("\u0d24\u0d3f\u0d2a", 216);
    freq.put("\u0d24\u0d3f\u0d28", 3912);
    freq.put("\u0d32\u0d2e\u0d3e", 175);
    freq.put("\u0d2b\u0d4d\u0d31", 145);
    freq.put("\u0d2b\u0d4d\u0d30", 256);
    freq.put("ia", 297);
    freq.put("ic", 457);
    freq.put("ie", 161);
    freq.put("id", 145);
    freq.put("ig", 259);
    freq.put("\u0d35\u0d3e\u0d15", 237);
    freq.put("\u0d46\u0d28\u0d4d", 699);
    freq.put("\u0d2f\u0d28\u0d4d", 328);
    freq.put("\u0d2f\u0d3e\u0d38", 209);
    freq.put("\u0d1f\u0d41\u0d33", 178);
    freq.put("\u0d2f\u0d3e\u0d33", 680);
    freq.put("\u0d41\u0d23\u0d4d", 1051);
    freq.put("\u0d24\u0d3f\u0d15", 867);
    freq.put("\u0d2f\u0d3e\u0d2a", 286);
    freq.put("\u0d2f\u0d3e\u0d28", 412);
    freq.put("\u0d1f\u0d41\u0d24", 820);
    freq.put("\u0d1f\u0d41\u0d23", 196);
    freq.put("\u0d2f\u0d3e\u0d2f", 924);
    freq.put("\u0d2f\u0d3e\u0d23", 2227);
    freq.put("\u0d3e\u0d1c\u0d4d", 625);
    freq.put("\u0d1f\u0d41\u0d2a", 172);
    freq.put("\u0d1f\u0d41\u0d28", 1925);
    freq.put("\u0d24\u0d3f\u0d7c", 138);
    freq.put("\u0d24\u0d3f\u0d7d", 2321);
    freq.put("\u0d3f\u0d37", 679);
    freq.put("\u0d3f\u0d36", 915);
    freq.put("\u0d3f\u0d35", 1776);
    freq.put("\u0d3f\u0d34", 585);
    freq.put("\u0d3f\u0d33", 544);
    freq.put("\u0d3f\u0d32", 11613);
    freq.put("\u0d3f\u0d31", 959);
    freq.put("\u0d3e\u0d1c\u0d3e", 164);
    freq.put("\u0d3f\u0d2f", 9237);
    freq.put("\u0d3f\u0d2e", 977);
    freq.put("\u0d28\u0d1f\u0d24", 237);
    freq.put("\u0d3f\u0d2a", 1879);
    freq.put("\u0d3f\u0d28", 8501);
    freq.put("\u0d3f\u0d27", 718);
    freq.put("i ", 213);
    freq.put("\u0d3f\u0d24", 4094);
    freq.put("\u0d3f\u0d23", 277);
    freq.put("\u0d28\u0d1f\u0d28", 157);
    freq.put("\u0d3f\u0d1f", 1697);
    freq.put("\u0d3f\u0d1e", 391);
    freq.put("\u0d3f\u0d1c", 257);
    freq.put("\u0d3f\u0d1a", 3441);
    freq.put("\u0d3f\u0d19", 411);
    freq.put("\u0d3f\u0d17", 248);
    freq.put("\u0d24\u0d02 ", 428);
    freq.put("\u0d38\u0d24\u0d4d", 172);
    freq.put(" \u0d2b\u0d4d", 175);
    freq.put(" \u0d2d", 2376);
    freq.put("\u0d09\u0d24\u0d4d", 318);
    freq.put("\u0d48 ", 191);
    freq.put("\u0d3f\u0d02", 358);
    freq.put("\u0d1a\u0d47\u0d30", 187);
    freq.put("\u0d24\u0d2a\u0d41", 179);
    freq.put("\u0d17\u0d02", 303);
    freq.put("\u0d4d\u0d1f\u0d2f", 169);
    freq.put("\u0d2a\u0d46\u0d30", 170);
    freq.put("\u0d24\u0d2a\u0d4d", 226);
    freq.put("\u0d3e\u0d7b ", 875);
    freq.put("\u0d30\u0d46 ", 495);
    freq.put("\u0d7c\u0d15\u0d4d", 684);
    freq.put("\u0d37\u0d3e", 253);
    freq.put("\u0d32", 30821);
    freq.put("\u0d2a\u0d46\u0d1f", 3183);
    freq.put("\u0d31\u0d2f\u0d41", 379);
    freq.put("\u0d48\u0d31\u0d4d", 167);
    freq.put("\u0d16\u0d4d\u0d2f", 445);
    freq.put("D", 213);
    freq.put("\u0d23\u0d4d ", 9312);
    freq.put("\u0d28\u0d7d\u0d15", 242);
    freq.put("\u0d02\u0d17", 1698);
    freq.put("\u0d31\u0d41", 1385);
    freq.put("\u0d38\u0d7c\u0d15", 222);
    freq.put("\u0d1f\u0d46 ", 2958);
    freq.put("\u0d2f\u0d3f ", 2287);
    freq.put("\u0d21\u0d3f ", 135);
    freq.put("\u0d46\u0d3e\u0d28\u0d4d", 268);
    freq.put("\u0d23\u0d15\u0d4d", 248);
    freq.put("www", 169);
    freq.put("\u0d31\u0d47", 484);
    freq.put("\u0d31\u0d46", 3559);
    freq.put("\u0d30\u0d02\u0d2d", 134);
    freq.put("\u0d15\u0d3e", 6054);
    freq.put("\u0d05\u0d15", 377);
    freq.put("\u0d30\u0d3e\u0d1c", 994);
    freq.put("\u0d32\u0d3f ", 304);
    freq.put("\u0d30\u0d3e\u0d17", 175);
    freq.put("\u0d07\u0d26", 201);
    freq.put("thu", 262);
    freq.put("\u0d3e\u0d23\u0d2a", 194);
    freq.put("\u0d3e\u0d31\u0d41", 256);
    freq.put("\u0d30\u0d3e\u0d2f", 317);
    freq.put("\u0d30\u0d3e\u0d2e", 1573);
    freq.put("\u0d31\u0d4d", 6646);
    freq.put("\u0d30\u0d3e\u0d23", 212);
    freq.put("\u0d30\u0d3e\u0d24", 212);
    freq.put("\u0d30\u0d3e\u0d27", 160);
    freq.put("\u0d3e\u0d31\u0d4d", 497);
    freq.put("\u0d2e\u0d7b ", 173);
    freq.put("\u0d2f\u0d15\u0d3e", 146);
    freq.put("\u0d3e\u0d23\u0d3f", 500);
    freq.put("\u0d30\u0d3e\u0d33", 187);
    freq.put("\u0d30\u0d3e\u0d35", 195);
    freq.put("\u0d30\u0d3e\u0d37", 322);
    freq.put("\u0d30\u0d3e\u0d36", 159);
    freq.put("\u0d3e\u0d23\u0d4d", 9070);
    freq.put("\u0d2f\u0d15\u0d4d", 335);
    freq.put("\u0d3e\u0d23\u0d41", 455);
    freq.put("\u0d15\u0d30", 1697);
    freq.put("\u0d24\u0d46\u0d2f", 178);
    freq.put("ww ", 169);
    freq.put("\u0d07\u0d24", 1342);
    freq.put("\u0d3e\u0d31\u0d3f", 215);
    freq.put("\u0d24\u0d46\u0d15", 351);
    freq.put("o", 3390);
    freq.put("\u0d15\u0d43\u0d37", 204);
    freq.put("\u0d23\u0d2a\u0d4d", 245);
    freq.put("\u0d2e\u0d30\u0d23", 133);
    freq.put("\u0d3e\u0d15", 2271);
    freq.put("\u0d15\u0d43\u0d24", 542);
    freq.put("\u0d23\u0d2f", 165);
    freq.put("\u0d1c", 7532);
    freq.put("\u0d23\u0d2e", 522);
    freq.put("\u0d35\u0d48\u0d26", 160);
    freq.put("\u0d39\u0d48", 165);
    freq.put("\u0d39\u0d47\u0d3e", 192);
    freq.put("\u0d15\u0d26", 149);
    freq.put("\u0d39\u0d4d", 425);
    freq.put("\u0d38\u0d19", 187);
    freq.put("\u0d46\u0d7b", 139);
    freq.put("\u0d46\u0d7c", 168);
    freq.put("\u0d46\u0d7d", 155);
    freq.put("\u0d30\u0d1a", 317);
    freq.put("\u0d30\u0d19", 807);
    freq.put("\u0d46\u0d15", 672);
    freq.put("\u0d09\u0d2a", 1088);
    freq.put("\u0d46\u0d19", 501);
    freq.put("mb ", 256);
    freq.put("\u0d39\u0d24", 306);
    freq.put("\u0d35\u0d7b ", 161);
    freq.put("\u0d05\u0d35\u0d38", 151);
    freq.put("\u0d39\u0d3f", 1080);
    freq.put("\u0d39\u0d3e", 862);
    freq.put("\u0d39\u0d30", 199);
    freq.put("\u0d46\u0d30", 246);
    freq.put("\u0d46\u0d31", 681);
    freq.put("\u0d46\u0d32", 319);
    freq.put("\u0d46\u0d33", 276);
    freq.put("\u0d31\u0d3f ", 343);
    freq.put("\u0d46\u0d38", 158);
    freq.put("\u0d1a\u0d4d ", 831);
    freq.put("\u0d39\u0d02", 374);
    freq.put("\u0d46\u0d24", 287);
    freq.put("\u0d35\u0d33\u0d30", 299);
    freq.put("\u0d3e\u0d33 ", 284);
    freq.put("\u0d33\u0d24\u0d4d", 1319);
    freq.put("\u0d46\u0d2a", 232);
    freq.put("\u0d46\u0d2c", 161);
    freq.put("\u0d46\u0d2e", 160);
    freq.put("\u0d19\u0d33\u0d3e", 313);
    freq.put("\u0d36\u0d3f\u0d15", 160);
    freq.put("\u0d12\u0d30", 4108);
    freq.put("\u0d07", 5473);
    freq.put("\u0d3e\u0d7b", 1060);
    freq.put("\u0d31\u0d15", 237);
    freq.put("\u0d15\u0d42\u0d1f", 756);
    freq.put("\u0d12\u0d28", 344);
    freq.put("ni", 239);
    freq.put("\u0d4d\u0d2a\u0d46", 2946);
    freq.put("\u0d3e\u0d28\u0d2e", 615);
    freq.put("\u0d4d\u0d2a\u0d41", 822);
    freq.put(" \u0d2c\u0d41", 137);
    freq.put("no", 135);
    freq.put("\u0d17\u0d40\u0d24", 286);
    freq.put("\u0d32\u0d2f\u0d41", 182);
    freq.put(" \u0d2c\u0d4d", 675);
    freq.put("nc", 163);
    freq.put(" \u0d2c\u0d47\u0d3e", 172);
    freq.put("ne", 310);
    freq.put("ng", 305);
    freq.put("\u0d05\u0d7c", 208);
    freq.put("\u0d2d\u0d4d\u0d2f", 155);
    freq.put("tio", 259);
    freq.put("\u0d4d\u0d38\u0d4d", 542);
    freq.put("\u0d30\u0d23\u0d2e", 149);
    freq.put("\u0d36\u0d3f\u0d2f", 152);
    freq.put("nt", 385);
    freq.put("\u0d4d\u0d2a\u0d24", 250);
    freq.put("ur", 239);
    freq.put("E", 274);
    freq.put("\u0d47", 13547);
    freq.put("\u0d2e\u0d26\u0d4d", 277);
    freq.put("\u0d2c\u0d7c ", 418);
    freq.put("\u0d4d\u0d2a\u0d28", 256);
    freq.put(" \u0d2c\u0d28", 199);
    freq.put("\u0d05\u0d1f", 473);
    freq.put("\u0d32\u0d19\u0d4d", 374);
    freq.put("\u0d4d\u0d2a\u0d30", 163);
    freq.put("\u0d4d\u0d2a\u0d31", 240);
    freq.put("\u0d32\u0d2f\u0d3e", 752);
    freq.put("\u0d32\u0d2f\u0d3f", 1550);
    freq.put(" \u0d2c\u0d3f", 227);
    freq.put(" \u0d2c\u0d3e", 363);
    freq.put("\u0d4d\u0d2a\u0d3e", 674);
    freq.put("\u0d4d\u0d2a\u0d3f", 1252);
    freq.put("\u0d39\u0d4d\u0d2e", 132);
    freq.put("\u0d05\u0d2d", 217);
    freq.put("\u0d05\u0d2f", 178);
    freq.put("\u0d05\u0d2e", 421);
    freq.put("\u0d05\u0d28", 675);
    freq.put("\u0d05\u0d2a", 189);
    freq.put("n ", 864);
    freq.put("\u0d05\u0d24", 670);
    freq.put("\u0d05\u0d27", 210);
    freq.put("\u0d05\u0d26", 350);
    freq.put("\u0d05\u0d23", 160);
    freq.put("\u0d05\u0d38", 137);
    freq.put("\u0d05\u0d35", 661);
    freq.put("\u0d05\u0d31", 909);
    freq.put("\u0d05\u0d30", 181);
    freq.put("\u0d05\u0d32", 395);
    freq.put("\u0d30\u0d3e", 5614);
    freq.put("\u0d4d\u0d1f\u0d7c", 257);
    freq.put("\u0d3e\u0d32\u0d15", 339);
    freq.put("\u0d1f\u0d3f\u0d7d", 160);
    freq.put("\u0d3e\u0d32\u0d02", 169);
    freq.put("\u0d35\u0d7c\u0d37", 372);
    freq.put("\u0d3e\u0d32\u0d3f", 392);
    freq.put("\u0d3e\u0d32\u0d3e", 156);
    freq.put("\u0d28\u0d31\u0d3f", 301);
    freq.put("\u0d24\u0d47\u0d3e\u0d1f", 190);
    freq.put("\u0d2e", 32874);
    freq.put("\u0d2d\u0d4d", 194);
    freq.put("\u0d3e\u0d32\u0d2f", 259);
    freq.put("\u0d35\u0d7c\u0d17", 216);
    freq.put("\u0d3e\u0d32\u0d24", 252);
    freq.put("\u0d4d\u0d1f\u0d47\u0d3e", 261);
    freq.put("\u0d1f\u0d3f\u0d2f", 767);
    freq.put("\u0d3e\u0d28\u0d02", 570);
    freq.put("\u0d3f\u0d2d\u0d3e", 320);
    freq.put("\u0d1f\u0d3f\u0d30", 215);
    freq.put("\u0d1f\u0d3f\u0d32", 180);
    freq.put("\u0d3e\u0d32\u0d42", 542);
    freq.put("\u0d3e\u0d32\u0d41", 158);
    freq.put("\u0d1f\u0d3f\u0d38", 180);
    freq.put("\u0d32\u0d1a\u0d4d", 445);
    freq.put(" \u0d17\u0d41", 264);
    freq.put("\u0d1f\u0d3f\u0d15", 477);
    freq.put("p", 1477);
    freq.put("\u0d35\u0d02 ", 264);
    freq.put("\u0d1f\u0d3f\u0d1e", 226);
    freq.put("\u0d4d\u0d1f\u0d41", 1302);
    freq.put("\u0d1f\u0d3f\u0d1a", 133);
    freq.put(" \u0d06\u0d31", 135);
    freq.put(" \u0d06\u0d30", 244);
    freq.put(" \u0d06\u0d32", 221);
    freq.put(" \u0d06\u0d35", 187);
    freq.put("\u0d2b\u0d4d ", 323);
    freq.put(" \u0d06\u0d38", 220);
    freq.put("\u0d23\u0d4d\u0d23", 973);
    freq.put("\u0d23\u0d4d\u0d21", 544);
    freq.put(" \u0d17\u0d47\u0d3e", 177);
    freq.put(" \u0d06\u0d23", 724);
    freq.put("htt", 234);
    freq.put(" \u0d06\u0d27", 137);
    freq.put(" \u0d06\u0d26", 541);
    freq.put("\u0d19", 13504);
    freq.put(" \u0d06\u0d28", 214);
    freq.put("\u0d24\u0d3f ", 1445);
    freq.put("\u0d2d\u0d3e\u0d35", 201);
    freq.put(" \u0d06\u0d2f", 406);
    freq.put("\u0d2d\u0d3e\u0d37", 528);
    freq.put(" \u0d06\u0d15", 232);
    freq.put("\u0d7d\u0d15\u0d4d", 256);
    freq.put("\u0d35\u0d3e\u0d7c", 151);
    freq.put("\u0d47\u0d3e\u0d2a\u0d4d", 223);
    freq.put("\u0d23\u0d4d\u0d1f", 3469);
    freq.put(" \u0d06\u0d02", 188);
    freq.put("\u0d1f\u0d41 ", 337);
    freq.put("\u0d41\u0d38\u0d4d", 374);
    freq.put("\u0d47\u0d3e\u0d38\u0d4d", 247);
    freq.put("ht ", 197);
    freq.put("\u0d33\u0d41\u0d02", 648);
    freq.put("\u0d48\u0d15", 178);
    freq.put("\u0d07\u0d02\u0d17", 366);
    freq.put("\u0d02\u0d2c", 834);
    freq.put("\u0d33\u0d41\u0d1f", 947);
    freq.put("\u0d3f ", 10063);
    freq.put("\u0d1f\u0d41\u0d2e", 147);
    freq.put("\u0d48\u0d38", 157);
    freq.put("\u0d17\u0d4d ", 228);
    freq.put("\u0d48\u0d31", 197);
    freq.put("\u0d2a\u0d1e\u0d4d", 1398);
    freq.put("\u0d48\u0d35", 271);
    freq.put("\u0d48\u0d28", 296);
    freq.put("\u0d31\u0d2f", 625);
    freq.put("\u0d48\u0d26", 208);
    freq.put("\u0d36\u0d4d\u0d1a", 178);
    freq.put("\u0d18", 772);
    freq.put("\u0d36\u0d4d\u0d2f", 219);
    freq.put("\u0d2a\u0d47\u0d3e\u0d7e", 223);
    freq.put("\u0d46\u0d2a\u0d4d", 220);
    freq.put("\u0d15 ", 1483);
    freq.put("\u0d4d\u0d31\u0d35", 566);
    freq.put("\u0d36\u0d4d\u0d36", 386);
    freq.put("\u0d36\u0d4d\u0d35", 377);
    freq.put("\u0d36\u0d4d\u0d30", 558);
    freq.put("F", 167);
    freq.put("\u0d0e\u0d28\u0d4d", 4356);
    freq.put("\u0d17\u0d23\u0d3f", 159);
    freq.put("\u0d12\u0d30\u0d41", 3867);
    freq.put("\u0d32\u0d3e\u0d2f", 359);
    freq.put("\u0d32\u0d3e\u0d2e", 187);
    freq.put("\u0d32\u0d3e\u0d23", 736);
    freq.put("\u0d32\u0d3e\u0d24", 169);
    freq.put("\u0d34\u0d4d ", 251);
    freq.put("\u0d2a\u0d47\u0d3e\u0d32", 201);
    freq.put("\u0d30\u0d7b", 214);
    freq.put("\u0d32\u0d3e\u0d02", 153);
    freq.put("\u0d23\u0d41", 765);
    freq.put("\u0d4d ", 30096);
    freq.put(" of", 235);
    freq.put("\u0d34\u0d3f ", 137);
    freq.put("\u0d19\u0d33\u0d46", 405);
    freq.put("\u0d2f\u0d4d\u0d15", 431);
    freq.put("\u0d3e\u0d7c\u0d15", 154);
    freq.put("ttp", 234);
    freq.put("\u0d2f\u0d4d\u0d24", 319);
    freq.put("\u0d2f\u0d4d\u0d2f", 1468);
    freq.put("\u0d05\u0d02\u0d17", 150);
    freq.put("s ", 1099);
    freq.put("\u0d7c\u0d24\u0d4d", 1697);
    freq.put("\u0d43", 1848);
    freq.put(" px", 215);
    freq.put("\u0d7c\u0d2a\u0d4d", 202);
    freq.put("\u0d3f\u0d2f ", 1562);
    freq.put("\u0d07\u0d28\u0d4d", 1364);
    freq.put("\u0d35\u0d3e\u0d2f", 334);
    freq.put("ght", 209);
    freq.put("\u0d31\u0d2a\u0d4d", 145);
    freq.put("ss", 146);
    freq.put("st", 355);
    freq.put("si", 227);
    freq.put("\u0d25\u0d35\u0d3e", 438);
    freq.put("\u0d19\u0d4d", 7589);
    freq.put("\u0d28\u0d2f\u0d3f", 167);
    freq.put("se", 201);
    freq.put("\u0d15\u0d28\u0d41", 217);
    freq.put("\u0d15\u0d28\u0d4d", 204);
    freq.put("\u0d31\u0d02 ", 319);
    freq.put(" \u0d08 ", 1593);
    freq.put("\u0d47\u0d3e\u0d17\u0d3f", 791);
    freq.put(" an", 158);
    freq.put("\u0d2f\u0d7c", 416);
    freq.put("\u0d2f\u0d7b", 1031);
    freq.put("\u0d31\u0d3f\u0d7d", 141);
    freq.put("\u0d06\u0d2f\u0d3f", 224);
    freq.put("\u0d1a\u0d4d\u0d1a", 4631);
    freq.put("\u0d31\u0d3f\u0d15", 201);
    freq.put("\u0d3e\u0d33\u0d02", 134);
    freq.put("\u0d31\u0d3f\u0d1a", 232);
    freq.put("\u0d4d\u0d32\u0d47", 201);
    freq.put("\u0d3e\u0d33\u0d3f", 252);
    freq.put("\u0d31\u0d3f\u0d2f", 1715);
    freq.put("\u0d4d\u0d32\u0d40", 428);
    freq.put("\u0d47\u0d3e\u0d17\u0d4d", 169);
    freq.put("\u0d31\u0d3f\u0d28", 263);
    freq.put("\u0d46 ", 14490);
    freq.put("\u0d31\u0d3f\u0d32", 158);
    freq.put("\u0d17\u0d4d\u0d32", 445);
    freq.put("\u0d15\u0d28\u0d3e", 221);
    freq.put("\u0d37\u0d7b ", 245);
    freq.put("\u0d4d\u0d31\u0d3e", 444);
    freq.put("\u0d3e\u0d33\u0d24", 153);
    freq.put("em", 159);
    freq.put("el", 240);
    freq.put("en", 424);
    freq.put("\u0d05", 8089);
    freq.put("\u0d1f\u0d3e\u0d2f", 281);
    freq.put("ed", 311);
    freq.put("ea", 262);
    freq.put(" \u0d07\u0d7b", 148);
    freq.put("ec", 168);
    freq.put("\u0d0e\u0d38", 156);
    freq.put("et", 186);
    freq.put("\u0d0e\u0d32", 190);
    freq.put("\u0d0e\u0d34", 295);
    freq.put("es", 424);
    freq.put("er", 794);
    freq.put("\u0d2d\u0d35", 280);
    freq.put(" \u0d15\u0d3e", 1855);
    freq.put(" \u0d15\u0d3f", 865);
    freq.put("\u0d47\u0d3e\u0d7a ", 165);
    freq.put("\u0d2e\u0d4d\u0d30", 188);
    freq.put(" ww", 169);
    freq.put(" \u0d15\u0d34", 213);
    freq.put(" \u0d15\u0d35", 234);
    freq.put("\u0d0e\u0d02", 136);
    freq.put(" \u0d15\u0d30", 347);
    freq.put("\u0d2a\u0d1f\u0d4d", 440);
    freq.put("\u0d40\u0d2f ", 378);
    freq.put(" \u0d15\u0d33", 233);
    freq.put(" \u0d15\u0d2e", 372);
    freq.put(" \u0d15\u0d28", 144);
    freq.put("\u0d0e\u0d1f", 140);
    freq.put("\u0d2e\u0d4d\u0d2e", 1128);
    freq.put(" \u0d15\u0d25", 180);
    freq.put("\u0d24\u0d4d\u0d30", 4088);
    freq.put("\u0d2e\u0d4d\u0d2a", 1717);
    freq.put(" \u0d15\u0d23", 816);
    freq.put(" \u0d07\u0d35", 544);
    freq.put(" \u0d07\u0d32", 190);
    freq.put(" \u0d07\u0d30", 190);
    freq.put("e ", 1341);
    freq.put(" \u0d07\u0d38", 230);
    freq.put("\u0d2f\u0d02", 1280);
    freq.put(" \u0d07\u0d26", 201);
    freq.put(" \u0d15\u0d4d", 1197);
    freq.put(" \u0d07\u0d24", 1342);
    freq.put(" \u0d15\u0d48", 147);
    freq.put(" \u0d15\u0d46\u0d3e", 822);
    freq.put(" \u0d15\u0d47\u0d3e", 957);
    freq.put(" \u0d15\u0d46", 231);
    freq.put(" \u0d15\u0d47", 1543);
    freq.put(" \u0d15\u0d40", 159);
    freq.put(" \u0d15\u0d41", 1227);
    freq.put(" \u0d15\u0d42", 693);
    freq.put(" \u0d15\u0d43", 254);
    freq.put(" \u0d15\u0d7c", 226);
    freq.put("\u0d39\u0d24\u0d4d", 297);
    freq.put("\u0d48\u0d15\u0d4d", 133);
    freq.put("\u0d32\u0d42\u0d15", 546);
    freq.put("\u0d38\u0d1e\u0d4d", 150);
    freq.put(" \u0d07\u0d02", 372);
    freq.put("\u0d41\u0d2e\u0d41", 219);
    freq.put("\u0d05\u0d25\u0d35", 448);
    freq.put(" \u0d38\u0d02", 1809);
    freq.put(" \u0d2a\u0d4d", 4372);
    freq.put("\u0d23\u0d3f", 1469);
    freq.put("\u0d35\u0d3f", 6428);
    freq.put(" \u0d2a\u0d47\u0d3e", 463);
    freq.put(" \u0d2a\u0d46\u0d3e", 392);
    freq.put("\u0d4d\u0d30\u0d02", 725);
    freq.put(" \u0d2a\u0d47", 780);
    freq.put(" \u0d2a\u0d46", 480);
    freq.put(" \u0d2a\u0d41", 1278);
    freq.put(" \u0d2a\u0d42", 332);
    freq.put(" \u0d38\u0d2e", 812);
    freq.put(" \u0d38\u0d2d", 212);
    freq.put("\u0d2f\u0d3f\u0d7d", 1778);
    freq.put("\u0d07\u0d7b", 149);
    freq.put("\u0d30\u0d46\u0d2f", 158);
    freq.put("\u0d23\u0d3e", 642);
    freq.put(" \u0d38\u0d39", 208);
    freq.put(" \u0d38\u0d38", 221);
    freq.put(" \u0d38\u0d3f", 733);
    freq.put(" \u0d38\u0d3e", 1185);
    freq.put("\u0d2f\u0d3f\u0d15", 256);
    freq.put(" \u0d2a\u0d1f", 612);
    freq.put(" \u0d2a\u0d1e", 607);
    freq.put("\u0d24\u0d3e\u0d30", 239);
    freq.put(" \u0d38\u0d4d", 2807);
    freq.put("\u0d24\u0d3e\u0d32", 576);
    freq.put(" \u0d2a\u0d15", 257);
    freq.put(" \u0d38\u0d42", 331);
    freq.put("x ", 258);
    freq.put(" \u0d38\u0d46", 318);
    freq.put("\u0d24\u0d4d\u0d35", 330);
    freq.put("\u0d2d\u0d3e", 2218);
    freq.put("\u0d07\u0d02", 373);
    freq.put("\u0d24\u0d3e\u0d23", 917);
    freq.put("\u0d24\u0d3e\u0d2f", 301);
    freq.put("\u0d24\u0d3e\u0d28", 186);
    freq.put("\u0d4d\u0d37\u0d23", 214);
    freq.put(" \u0d2a\u0d3f", 660);
    freq.put(" \u0d2a\u0d3e", 1107);
    freq.put("\u0d2f\u0d3f\u0d30", 1399);
    freq.put("\u0d2f\u0d3f\u0d32", 2744);
    freq.put(" \u0d2a\u0d34", 174);
    freq.put(" \u0d2a\u0d31", 573);
    freq.put(" \u0d2a\u0d30", 747);
    freq.put(" \u0d2a\u0d32", 234);
    freq.put("\u0d2f\u0d42\u0d1f", 261);
    freq.put("r", 3549);
    freq.put(" \u0d2a\u0d28", 151);
    freq.put(" \u0d38\u0d7c", 371);
    freq.put("\u0d21\u0d3f\u0d2f", 165);
    freq.put(" \u0d2a\u0d24", 547);
    freq.put("\u0d41\u0d2e\u0d3e", 1413);
    freq.put(" \u0d2a\u0d26", 316);
    freq.put("\u0d1f\u0d46\u0d2f", 346);
    freq.put(" \u0d2a\u0d23", 151);
    freq.put("\u0d07\u0d28", 1412);
    freq.put("and", 176);
    freq.put("\u0d15\u0d7c", 533);
    freq.put("\u0d24\u0d28\u0d4d", 625);
    freq.put("\u0d15\u0d7e", 1615);
    freq.put("\u0d2d\u0d30", 449);
    freq.put("\u0d15\u0d7b", 533);
    freq.put("\u0d4d\u0d30 ", 614);
    freq.put("\u0d36\u0d40\u0d2f", 288);
    freq.put("\u0d4d\u0d37\u0d24", 297);
    freq.put("\u0d32\u0d3f\u0d28", 217);
    freq.put("\u0d32\u0d3f\u0d2a", 166);
    freq.put("\u0d3e\u0d1f\u0d3f", 272);
    freq.put("\u0d7b\u0d38\u0d4d", 171);
    freq.put("\u0d32\u0d3f\u0d2f", 569);
    freq.put("\u0d2f\u0d3f", 9140);
    freq.put("\u0d39\u0d2e", 212);
    freq.put("\u0d32\u0d3f\u0d15", 373);
    freq.put("\u0d2f", 48687);
    freq.put("\u0d15\u0d7b ", 521);
    freq.put("\u0d15\u0d4d", 21779);
    freq.put("\u0d15\u0d48", 174);
    freq.put("\u0d15\u0d47\u0d3e", 1765);
    freq.put("\u0d15\u0d46\u0d3e", 1243);
    freq.put("\u0d3e\u0d1f\u0d15", 206);
    freq.put("\u0d15\u0d47", 2116);
    freq.put("\u0d15\u0d46", 542);
    freq.put("\u0d15\u0d41", 7634);
    freq.put("\u0d15\u0d40", 288);
    freq.put("\u0d15\u0d43", 756);
    freq.put("\u0d15\u0d42", 1037);
    freq.put("\u0d4d\u0d30\u0d26", 820);
    freq.put("\u0d15\u0d3f", 3548);
    freq.put("\u0d15\u0d46\u0d3e\u0d33", 171);
    freq.put("an ", 167);
    freq.put("\u0d15\u0d38", 257);
    freq.put("\u0d4d\u0d30\u0d27", 583);
    freq.put("\u0d15\u0d35", 506);
    freq.put("\u0d15\u0d34", 243);
    freq.put("\u0d2f\u0d38", 303);
    freq.put("\u0d15\u0d31", 301);
    freq.put("\u0d24\u0d28\u0d02", 152);
    freq.put("\u0d15\u0d33", 3150);
    freq.put("\u0d15\u0d32", 863);
    freq.put("\u0d15\u0d2f", 816);
    freq.put("\u0d15\u0d2e", 989);
    freq.put("\u0d15\u0d28", 747);
    freq.put("\u0d35\u0d1f\u0d15", 415);
    freq.put("\u0d15\u0d2a", 759);
    freq.put("\u0d15\u0d25", 303);
    freq.put("\u0d15\u0d24", 663);
    freq.put("\u0d46\u0d1f", 3862);
    freq.put("\u0d24\u0d46 ", 1217);
    freq.put("\u0d15\u0d23", 938);
    freq.put("\u0d30\u0d2a\u0d4d", 252);
    freq.put("\u0d3e\u0d1f\u0d4d", 1178);
    freq.put("\u0d15\u0d1f", 577);
    freq.put("\u0d15\u0d19", 196);
    freq.put("\u0d15\u0d15", 230);
    freq.put("\u0d05\u0d2e\u0d47", 219);
    freq.put("\u0d3e\u0d1f\u0d41", 187);
    freq.put("\u0d24\u0d28\u0d3e", 181);
    freq.put("\u0d2f\u0d31", 218);
    freq.put("\u0d4d\u0d30\u0d2f", 207);
    freq.put("\u0d2f\u0d30", 304);
    freq.put("\u0d15\u0d02", 672);
    freq.put("\u0d15\u0d47\u0d28", 314);
    freq.put("\u0d42\u0d2e\u0d3f", 187);
    freq.put("\u0d2d\u0d30\u0d23", 352);
    freq.put("\u0d4d\u0d30\u0d2a", 199);
    freq.put("\u0d4d\u0d1f ", 817);
    freq.put("\u0d30\u0d02 ", 1921);
    freq.put("\u0d16", 1936);
    freq.put("\u0d28\u0d46 ", 631);
    freq.put("\u0d15\u0d47\u0d30", 1281);
    freq.put("\u0d32\u0d47\u0d2f", 136);
    freq.put("\u0d32\u0d47\u0d15", 222);
    freq.put("\u0d26\u0d41", 403);
    freq.put("\u0d32\u0d47\u0d1c", 143);
    freq.put("\u0d42\u0d1f\u0d41", 168);
    freq.put("\u0d26\u0d3e\u0d2f", 132);
    freq.put("H", 218);
    freq.put("\u0d17\u0d3f\u0d1a", 235);
    freq.put("\u0d26\u0d48", 141);
    freq.put("\u0d42\u0d1f\u0d46", 257);
    freq.put("\u0d38\u0d02 ", 495);
    freq.put("\u0d31\u0d1e\u0d4d", 136);
    freq.put("\u0d15\u0d30\u0d3f", 544);
    freq.put("\u0d38\u0d3f\u0d38", 131);
    freq.put("\u0d05\u0d24\u0d4d", 146);
    freq.put("\u0d4d\u0d30\u0d39", 203);
    freq.put("\u0d35\u0d33", 556);
    freq.put("\u0d35\u0d48", 359);
    freq.put("\u0d05\u0d27\u0d3f", 169);
    freq.put("\u0d41\u0d28\u0d4d", 10068);
    freq.put(" \u0d28\u0d47\u0d3e", 233);
    freq.put("\u0d32\u0d23\u0d4d", 140);
    freq.put("\u0d47\u0d30\u0d3f", 960);
    freq.put("\u0d15\u0d46\u0d3e\u0d32", 162);
    freq.put(" \u0d28\u0d4d", 326);
    freq.put(" \u0d28\u0d42", 265);
    freq.put("\u0d4d\u0d30\u0d1c", 175);
    freq.put(" \u0d28\u0d40", 290);
    freq.put(" \u0d28\u0d47", 376);
    freq.put(" \u0d28\u0d46", 227);
    freq.put("\u0d47\u0d30\u0d33", 1271);
    freq.put("\u0d38\u0d3f\u0d26", 345);
    freq.put("\u0d24\u0d32\u0d38", 164);
    freq.put("\u0d4d\u0d30\u0d24", 1256);
    freq.put("\u0d41\u0d34 ", 240);
    freq.put(" \u0d28\u0d7d", 229);
    freq.put("\u0d24\u0d3f\u0d2f", 1314);
    freq.put("\u0d38\u0d3f\u0d2f", 151);
    freq.put("\u0d4d\u0d30\u0d41", 156);
    freq.put("\u0d38\u0d3f\u0d2a", 159);
    freq.put("\u0d38\u0d3f\u0d28", 374);
    freq.put("\u0d4d\u0d30\u0d36", 364);
    freq.put("\u0d4d\u0d30\u0d35", 914);
    freq.put("\u0d38\u0d3f\u0d32", 142);
    freq.put("\u0d4d\u0d30\u0d30", 148);
    freq.put("\u0d2f\u0d3f\u0d1f", 223);
    freq.put("\u0d4d\u0d30\u0d3e", 2390);
    freq.put("\u0d4d\u0d30\u0d3f", 1522);
    freq.put(" \u0d36\u0d3f", 199);
    freq.put(" \u0d36\u0d3e", 428);
    freq.put("\u0d41", 58406);
    freq.put("\u0d4d\u0d30\u0d47", 194);
    freq.put("\u0d1f\u0d19\u0d4d", 577);
    freq.put(" \u0d28\u0d1f", 599);
    freq.put(" \u0d36\u0d47", 181);
    freq.put("\u0d35\u0d7c", 1764);
    freq.put(" \u0d28\u0d17", 396);
    freq.put(" \u0d36\u0d4d", 451);
    freq.put("\u0d4d\u0d30\u0d47\u0d3e", 492);
    freq.put(" \u0d28\u0d15", 244);
    freq.put("\u0d46\u0d28", 785);
    freq.put("\u0d7e ", 3523);
    freq.put(" \u0d28\u0d3f", 2688);
    freq.put(" \u0d28\u0d3e", 1197);
    freq.put("\u0d4d\u0d2e\u0d3e", 586);
    freq.put("\u0d4d\u0d2e\u0d3f", 445);
    freq.put("\u0d47\u0d30\u0d41", 255);
    freq.put(" \u0d28\u0d35", 174);
    freq.put("\u0d3e\u0d7e ", 197);
    freq.put("\u0d4d\u0d28\u0d46", 265);
    freq.put("s", 2723);
    freq.put("\u0d26\u0d24", 182);
    freq.put("\u0d46\u0d2f", 3291);
    freq.put(" \u0d28\u0d26", 211);
    freq.put("\u0d4d\u0d2e\u0d26", 157);
    freq.put("\u0d3e\u0d2e\u0d3f", 294);
    freq.put("\u0d3e\u0d2e\u0d3e", 133);
    freq.put("\u0d2e\u0d02", 543);
    freq.put("\u0d1a\u0d3f\u0d1f", 172);
    freq.put("\u0d3e\u0d2e\u0d2e", 268);
    freq.put("\u0d21\u0d32", 261);
    freq.put("\u0d3e\u0d2e\u0d2a", 768);
    freq.put("\u0d3e\u0d2e\u0d24", 404);
    freq.put("\u0d2e\u0d15", 266);
    freq.put("\u0d21\u0d3f", 791);
    freq.put("\u0d21\u0d3e", 142);
    freq.put("\u0d1a\u0d3f\u0d30", 413);
    freq.put("\u0d1a\u0d3f\u0d31", 138);
    freq.put("\u0d1a\u0d3f\u0d32", 197);
    freq.put("\u0d2e\u0d2e", 375);
    freq.put("\u0d2e\u0d2f", 404);
    freq.put("\u0d2e\u0d23", 590);
    freq.put("\u0d2e\u0d24", 1028);
    freq.put("\u0d2e\u0d26", 367);
    freq.put("\u0d2e\u0d27", 161);
    freq.put("\u0d2e\u0d38", 322);
    freq.put("\u0d2e\u0d39", 381);
    freq.put("\u0d1a\u0d3f\u0d24", 936);
    freq.put("\u0d26\u0d2e", 198);
    freq.put("\u0d2e\u0d3e", 10411);
    freq.put("\u0d2e\u0d3f", 2147);
    freq.put("\u0d1a\u0d3f\u0d28", 169);
    freq.put("\u0d2e\u0d31", 466);
    freq.put("\u0d1a\u0d3f\u0d2a", 139);
    freq.put("\u0d3e\u0d2e\u0d02", 286);
    freq.put("\u0d2e\u0d48", 144);
    freq.put("\u0d40", 8295);
    freq.put("\u0d2e\u0d46\u0d3e", 134);
    freq.put("\u0d2e\u0d47\u0d3e", 397);
    freq.put("\u0d2e\u0d4d", 3221);
    freq.put("\u0d2e\u0d40", 726);
    freq.put("\u0d2e\u0d41", 3097);
    freq.put("\u0d2e\u0d42", 870);
    freq.put("\u0d2e\u0d46", 621);
    freq.put("\u0d2e\u0d47", 980);
    freq.put("\u0d1f\u0d4d ", 2684);
    freq.put("\u0d7c\u0d28\u0d4d", 390);
    freq.put("\u0d21\u0d46", 175);
    freq.put("\u0d21\u0d47\u0d3e", 225);
    freq.put("\u0d31\u0d24\u0d4d", 391);
    freq.put("\u0d21\u0d4d", 914);
    freq.put("\u0d24\u0d2e\u0d4d", 155);
    freq.put("\u0d3e\u0d2e\u0d4d", 413);
    freq.put("\u0d2e\u0d7b", 182);
    freq.put("\u0d2e\u0d7c", 179);
    freq.put("\u0d47\u0d3e\u0d34\u0d3f", 212);
    freq.put("\u0d28\u0d3f\u0d15", 437);
    freq.put("\u0d28\u0d3f\u0d1a", 204);
    freq.put("\u0d2f ", 5708);
    freq.put("\u0d28\u0d3f\u0d35", 495);
    freq.put("\u0d28\u0d3f\u0d32", 691);
    freq.put("\u0d28\u0d3f\u0d30", 355);
    freq.put("\u0d28\u0d3f\u0d31", 179);
    freq.put("il", 179);
    freq.put("\u0d23\u0d24\u0d4d", 429);
    freq.put("\u0d2b", 2123);
    freq.put("\u0d2c\u0d24\u0d4d", 224);
    freq.put("\u0d07\u0d24\u0d3f", 553);
    freq.put("\u0d41\u0d35\u0d3f", 444);
    freq.put("\u0d28\u0d3f\u0d2e", 172);
    freq.put("\u0d28\u0d3f\u0d2f", 759);
    freq.put("\u0d4d\u0d28\u0d24", 3020);
    freq.put("\u0d28\u0d3f\u0d28", 1060);
    freq.put("\u0d28\u0d41\u0d2e", 332);
    freq.put("I", 415);
    freq.put(" \u0d2e\u0d24", 278);
    freq.put("\u0d28\u0d41\u0d38", 192);
    freq.put("\u0d37\u0d4d\u0d2f", 741);
    freq.put("\u0d24 ", 1303);
    freq.put("\u0d3f\u0d33\u0d3f", 317);
    freq.put("\u0d37\u0d4d\u0d23", 218);
    freq.put("\u0d28\u0d41\u0d33", 311);
    freq.put("\u0d28\u0d41\u0d35", 212);
    freq.put("\u0d42\u0d30\u0d3f", 182);
    freq.put("\u0d28\u0d41\u0d37", 303);
    freq.put("\u0d4d\u0d28\u0d3e", 1196);
    freq.put(" th", 549);
    freq.put("\u0d37\u0d4d\u0d1f", 557);
    freq.put(" \u0d12\u0d30", 4105);
    freq.put("\u0d28\u0d3f\u0d7c", 607);
    freq.put("\u0d28\u0d3f\u0d7d", 228);
    freq.put("\u0d30\u0d3f ", 963);
    freq.put("\u0d41\u0d28\u0d3f", 282);
    freq.put("\u0d24\u0d3f\u0d1a", 316);
    freq.put("\u0d4d\u0d37\u0d4d", 138);
    freq.put("In", 142);
    freq.put(" \u0d12\u0d28", 341);
    freq.put("\u0d32\u0d15", 1101);
    freq.put("\u0d25\u0d2f", 152);
    freq.put("\u0d02", 26623);
    freq.put("\u0d27\u0d40\u0d15", 138);
    freq.put("\u0d32\u0d19", 375);
    freq.put("\u0d35\u0d28\u0d28", 179);
    freq.put(" \u0d05\u0d7c", 208);
    freq.put(" \u0d2e\u0d31", 395);
    freq.put("\u0d25\u0d3f", 968);
    freq.put("\u0d25\u0d3e", 1753);
    freq.put("\u0d32\u0d02", 722);
    freq.put("\u0d25\u0d35", 455);
    freq.put("\u0d3f\u0d32\u0d35", 146);
    freq.put("\u0d28\u0d42\u0d31", 277);
    freq.put("\u0d25\u0d32", 260);
    freq.put("\u0d32\u0d35", 344);
    freq.put("\u0d4d\u0d28\u0d35", 135);
    freq.put("\u0d31\u0d46 ", 3202);
    freq.put("\u0d32\u0d3e", 2706);
    freq.put("\u0d32\u0d3f", 2464);
    freq.put("\u0d32\u0d38", 248);
    freq.put("\u0d25\u0d02", 170);
    freq.put("\u0d32\u0d24", 808);
    freq.put(" \u0d13\u0d2b", 177);
    freq.put("\u0d1c\u0d28\u0d41", 148);
    freq.put("\u0d32\u0d23", 143);
    freq.put("\u0d32\u0d2d", 229);
    freq.put("\u0d1c\u0d28\u0d4d", 153);
    freq.put("\u0d32\u0d2f", 2792);
    freq.put("\u0d32\u0d28", 318);
    freq.put("\u0d32\u0d2a", 453);
    freq.put(" \u0d05\u0d2d", 214);
    freq.put(" \u0d05\u0d2e", 420);
    freq.put(" \u0d05\u0d2f", 173);
    freq.put(" \u0d05\u0d28", 672);
    freq.put(" \u0d05\u0d2a", 189);
    freq.put(" \u0d05\u0d24", 659);
    freq.put(" \u0d05\u0d25", 462);
    freq.put(" \u0d05\u0d26", 348);
    freq.put(" \u0d05\u0d27", 209);
    freq.put("\u0d7c\u0d35\u0d4d", 178);
    freq.put(" \u0d05\u0d23", 160);
    freq.put("\u0d28\u0d42\u0d7c", 159);
    freq.put("\u0d32\u0d46", 5253);
    freq.put("\u0d32\u0d47", 789);
    freq.put(" \u0d05\u0d38", 137);
    freq.put("\u0d32\u0d41", 2355);
    freq.put("\u0d32\u0d42", 979);
    freq.put(" \u0d05\u0d35", 660);
    freq.put(" \u0d05\u0d30", 179);
    freq.put(" \u0d05\u0d31", 908);
    freq.put(" \u0d05\u0d32", 394);
    freq.put("\u0d1c\u0d28\u0d28", 254);
    freq.put("\u0d3f\u0d32\u0d4d", 2038);
    freq.put("\u0d30\u0d1e\u0d4d", 146);
    freq.put("\u0d46\u0d1f\u0d41", 2359);
    freq.put("\u0d1f\u0d28\u0d4d", 213);
    freq.put("\u0d3f\u0d32\u0d46", 4614);
    freq.put("\u0d3f\u0d32\u0d47", 330);
    freq.put("\u0d35\u0d28\u0d4d", 355);
    freq.put("\u0d3f\u0d32\u0d42", 238);
    freq.put(" \u0d05\u0d02", 186);
    freq.put("\u0d3f\u0d32\u0d41", 1762);
    freq.put("\u0d2d\u0d3f\u0d1a", 159);
    freq.put(" \u0d05\u0d1f", 472);
    freq.put("t", 4207);
    freq.put("\u0d35\u0d34", 173);
    freq.put(" \u0d05\u0d15", 377);
    freq.put("\u0d36\u0d38\u0d4d", 398);
    freq.put("\u0d26\u0d3f\u0d2f", 235);
    freq.put("\u0d26\u0d3f\u0d28", 206);
    freq.put("\u0d26\u0d3f\u0d35", 229);
    freq.put("\u0d1c\u0d4d\u0d1c", 187);
    freq.put("\u0d1e\u0d4d", 2940);
    freq.put("\u0d1c\u0d4d\u0d1e", 320);
    freq.put("\u0d15\u0d41 ", 269);
    freq.put("\u0d23\u0d41 ", 234);
    freq.put("\u0d02 ", 21178);
    freq.put(" co", 199);
    freq.put("\u0d1c\u0d4d\u0d2f", 739);
    freq.put("\u0d2d", 5198);
    freq.put("o ", 216);
    freq.put("\u0d26\u0d3f\u0d15", 158);
    freq.put("\u0d05\u0d26\u0d4d", 338);
    freq.put("\u0d42\u0d30", 435);
    freq.put("\u0d15\u0d24\u0d4d", 528);
    freq.put("\u0d35\u0d28", 931);
    freq.put("\u0d2e\u0d28", 817);
    freq.put("\u0d26\u0d4d\u0d35", 180);
    freq.put("\u0d2e\u0d2a", 831);
    freq.put("\u0d26\u0d4d\u0d30", 848);
    freq.put("\u0d47\u0d3e\u0d2b\u0d4d", 143);
    freq.put("\u0d26\u0d4d\u0d2f", 1112);
    freq.put("\u0d4d\u0d15\u0d7d", 212);
    freq.put("\u0d26\u0d4d\u0d26", 733);
    freq.put("\u0d26\u0d4d\u0d27", 1337);
    freq.put("\u0d05\u0d02", 186);
    freq.put("on", 664);
    freq.put("om", 259);
    freq.put("ol", 194);
    freq.put("\u0d1e\u0d3e", 426);
    freq.put("of", 259);
    freq.put("\u0d38\u0d30\u0d3f", 133);
    freq.put("\u0d2e\u0d23\u0d4d", 363);
    freq.put("\u0d28\u0d24\u0d3e", 252);
    freq.put("ou", 163);
    freq.put("\u0d2a\u0d2f\u0d47\u0d3e", 768);
    freq.put("or", 514);
    freq.put("op", 135);
    freq.put("\u0d47\u0d3e\u0d23", 319);
    freq.put("\u0d47\u0d3e\u0d21", 324);
    freq.put("\u0d35\u0d3f ", 249);
    freq.put("\u0d1f\u0d15\u0d4d", 856);
    freq.put("\u0d47\u0d3e\u0d24", 321);
    freq.put("\u0d47\u0d3e\u0d2b", 177);
    freq.put("\u0d47\u0d3e\u0d2a", 434);
    freq.put("\u0d47\u0d3e\u0d28", 149);
    freq.put("\u0d47\u0d3e\u0d2f", 198);
    freq.put("\u0d47\u0d3e\u0d2e", 554);
    freq.put("\u0d47\u0d3e\u0d2c", 223);
    freq.put("\u0d47\u0d3e\u0d33", 566);
    freq.put("\u0d47\u0d3e\u0d32", 414);
    freq.put("\u0d47\u0d3e\u0d31", 240);
    freq.put("\u0d47\u0d3e\u0d30", 171);
    freq.put("\u0d47\u0d3e\u0d37", 199);
    freq.put("\u0d30\u0d28\u0d3e", 222);
    freq.put("\u0d47\u0d3e\u0d35", 275);
    freq.put("\u0d47\u0d3e\u0d34", 323);
    freq.put("\u0d2f\u0d2f\u0d3f", 607);
    freq.put("\u0d47\u0d3e\u0d38", 481);
    freq.put("\u0d24\u0d4d", 29067);
    freq.put("\u0d24\u0d46\u0d3e", 210);
    freq.put("\u0d24\u0d47\u0d3e", 646);
    freq.put("\u0d24\u0d46", 2173);
    freq.put("\u0d24\u0d47", 368);
    freq.put("\u0d4d\u0d26\u0d47", 658);
    freq.put("\u0d24\u0d42", 222);
    freq.put("\u0d2c", 5674);
    freq.put("\u0d24\u0d40", 783);
    freq.put("\u0d24\u0d41", 3776);
    freq.put("\u0d3e\u0d2f\u0d4d", 163);
    freq.put("\u0d2f\u0d19\u0d4d", 581);
    freq.put("\u0d47\u0d3e\u0d17", 1263);
    freq.put("\u0d47\u0d3e\u0d15", 1283);
    freq.put("\u0d2a\u0d46\u0d3e\u0d24", 227);
    freq.put("\u0d47\u0d3e\u0d1f", 1348);
    freq.put("\u0d3e\u0d2f\u0d41", 463);
    freq.put("\u0d47\u0d3e\u0d1c", 148);
    freq.put("\u0d24\u0d2e", 1061);
    freq.put("\u0d24\u0d2f", 396);
    freq.put("\u0d3e\u0d2f\u0d3e", 181);
    freq.put("\u0d3e\u0d2f\u0d3f", 3609);
    freq.put("\u0d24\u0d2a", 458);
    freq.put("\u0d24\u0d28", 1444);
    freq.put("\u0d24\u0d24", 746);
    freq.put("\u0d4d\u0d28 ", 5898);
    freq.put("\u0d7c\u0d1f\u0d4d", 250);
    freq.put("\u0d24\u0d3e", 3666);
    freq.put("\u0d2e\u0d30", 545);
    freq.put("\u0d31\u0d46\u0d2f", 243);
    freq.put("\u0d37\u0d02 ", 301);
    freq.put("\u0d3e\u0d2f\u0d24", 1564);
    freq.put("\u0d47\u0d3e\u0d7a", 268);
    freq.put("\u0d24\u0d35", 316);
    freq.put("\u0d24\u0d32", 712);
    freq.put("\u0d47\u0d3e\u0d7e", 398);
    freq.put("\u0d24\u0d30", 903);
    freq.put("\u0d36\u0d42\u0d7c", 174);
    freq.put("\u0d2f\u0d2f\u0d41", 269);
    freq.put("\u0d30\u0d28\u0d4d", 347);
    freq.put("\u0d3e\u0d19\u0d4d", 227);
    freq.put("\u0d3e\u0d2f\u0d15", 210);
    freq.put("\u0d24\u0d02", 452);
    freq.put("\u0d05\u0d25", 462);
    freq.put("he ", 334);
    freq.put("\u0d24\u0d19", 173);
    freq.put("\u0d15", 65976);
    freq.put("\u0d24\u0d2e\u0d3f", 248);
    freq.put("\u0d24\u0d2e\u0d3e", 549);
    freq.put("\u0d25\u0d3e\u0d2a", 368);
    freq.put("ac", 198);
    freq.put("ad", 149);
    freq.put("am", 238);
    freq.put("al", 614);
    freq.put("an", 747);
    freq.put("as", 248);
    freq.put("ar", 530);
    freq.put("at", 600);
    freq.put("\u0d17", 10132);
    freq.put("\u0d2a\u0d3f\u0d1a", 417);
    freq.put("\u0d17\u0d19", 344);
    freq.put("\u0d17\u0d24", 782);
    freq.put("\u0d17\u0d23", 317);
    freq.put("\u0d17\u0d2e", 519);
    freq.put("\u0d47\u0d3e\u0d39", 213);
    freq.put("\u0d17\u0d35", 220);
    freq.put("\u0d17\u0d32", 182);
    freq.put("\u0d17\u0d30", 457);
    freq.put("\u0d17\u0d3f", 1014);
    freq.put("\u0d17\u0d3e", 550);
    freq.put("\u0d47\u0d3e\u0d15\u0d24", 185);
    freq.put("\u0d28\u0d2e\u0d3e", 873);
    freq.put("a ", 674);
    freq.put("c ", 161);
    freq.put("\u0d17\u0d41", 368);
    freq.put("\u0d17\u0d40", 392);
    freq.put("\u0d17\u0d4d", 3272);
    freq.put("\u0d2e\u0d32", 1243);
    freq.put("\u0d17\u0d47\u0d3e", 498);
    freq.put("\u0d4d\u0d31\u0d3f", 828);
    freq.put("\u0d47\u0d3e\u0d15\u0d4d", 696);
    freq.put("\u0d57", 469);
    freq.put("\u0d46\u0d3e\u0d23\u0d4d", 419);
    freq.put("\u0d4d\u0d2f\u0d3e", 1524);
    freq.put("\u0d25\u0d02 ", 166);
    freq.put("\u0d41\u0d02\u0d2c", 279);
    freq.put("\u0d15\u0d2a\u0d4d", 708);
    freq.put("u", 1770);
    freq.put("\u0d3e\u0d15\u0d4d", 1414);
    freq.put("\u0d7c ", 4755);
    freq.put("\u0d09\u0d7e\u0d2a", 337);
    freq.put("\u0d47\u0d36\u0d24", 140);
    freq.put("\u0d3e\u0d15\u0d41", 356);
    freq.put("\u0d35\u0d15\u0d4d", 151);
    freq.put("\u0d47\u0d36\u0d3f", 194);
    freq.put(" \u0d26\u0d47", 508);
    freq.put(" \u0d26\u0d4d", 241);
    freq.put("\u0d28 ", 6972);
    freq.put("\u0d38\u0d42\u0d1a", 143);
    freq.put("\u0d47\u0d36\u0d02", 258);
    freq.put("tt", 296);
    freq.put("tr", 153);
    freq.put("tp", 241);
    freq.put("\u0d1c\u0d3f\u0d32", 1519);
    freq.put("to", 263);
    freq.put("\u0d47\u0d36\u0d19", 199);
    freq.put("th", 747);
    freq.put("ti", 568);
    freq.put("\u0d4d\u0d28\u0d31", 289);
    freq.put("te", 463);
    freq.put("\u0d3e", 63951);
    freq.put("\u0d7c\u0d36", 261);
    freq.put("\u0d7c\u0d37", 608);
    freq.put("\u0d3f\u0d2a\u0d4d", 1405);
    freq.put(" \u0d26\u0d15", 157);
    freq.put("\u0d1a\u0d30\u0d3f", 346);
    freq.put("\u0d39\u0d3e\u0d30", 204);
    freq.put("al ", 246);
    freq.put("\u0d15\u0d30\u0d23", 329);
    freq.put("\u0d7c\u0d26", 256);
    freq.put("\u0d7c\u0d24", 1751);
    freq.put("\u0d35\u0d7c\u0d24", 599);
    freq.put("\u0d7c\u0d21", 239);
    freq.put("\u0d7c\u0d2e", 803);
    freq.put("\u0d0e", 6292);
    freq.put("\u0d2a\u0d3e\u0d1f", 326);
    freq.put("\u0d7c\u0d28", 493);
    freq.put("\u0d7c\u0d17", 447);
    freq.put("\u0d35\u0d15\u0d3e", 131);
    freq.put("\u0d2a\u0d3e\u0d26", 161);
    freq.put("\u0d47\u0d36\u0d4d", 174);
    freq.put("\u0d7c\u0d1f", 256);
    freq.put("\u0d47\u0d36\u0d40", 282);
    freq.put("\u0d7c\u0d1a", 209);
    freq.put(" \u0d26\u0d3f", 368);
    freq.put("\u0d2a\u0d3e\u0d32", 480);
    freq.put("\u0d41\u0d2a\u0d4d", 479);
    freq.put("t ", 716);
    freq.put("\u0d7e", 4761);
    freq.put("ter", 154);
    freq.put("\u0d3f\u0d7d ", 7420);
    freq.put("\u0d38\u0d3f\u0d15", 356);
    freq.put("\u0d2c\u0d4d\u0d30", 460);
    freq.put("\u0d2c\u0d4d\u0d32", 277);
    freq.put("\u0d2c\u0d4d\u0d33", 167);
    freq.put("\u0d30\u0d38\u0d4d", 464);
    freq.put("\u0d26\u0d7c\u0d36", 140);
    freq.put("\u0d1f ", 916);
    freq.put("\u0d30\u0d38\u0d3f", 277);
    freq.put("\u0d41\u0d4d ", 338);
    freq.put("K", 134);
    freq.put(" ri", 189);
    freq.put("\u0d1a\u0d3e\u0d30", 301);
    freq.put("\u0d02\u0d35\u0d3f", 172);
    freq.put("\u0d30\u0d26\u0d47", 627);
    freq.put("\u0d1a\u0d3e\u0d2f", 1294);
    freq.put("\u0d3e\u0d38", 2241);
    freq.put("\u0d3e\u0d39", 589);
    freq.put("\u0d3e\u0d30", 3963);
    freq.put("\u0d3e\u0d31", 1288);
    freq.put("\u0d3e\u0d32", 2916);
    freq.put("\u0d3e\u0d33", 1241);
    freq.put("\u0d3e\u0d34", 297);
    freq.put("\u0d3e\u0d35", 1901);
    freq.put("\u0d3e\u0d36", 745);
    freq.put("\u0d3e\u0d37", 985);
    freq.put("\u0d3e\u0d28", 5014);
    freq.put("\u0d31\u0d40", 135);
    freq.put("\u0d3e\u0d2a", 1119);
    freq.put("\u0d3e\u0d2c", 224);
    freq.put("\u0d3e\u0d2d", 193);
    freq.put("\u0d3e\u0d2e", 3387);
    freq.put("\u0d3e\u0d2f", 9472);
    freq.put("\u0d31\u0d47\u0d3e", 534);
    freq.put("\u0d3e\u0d23", 10704);
    freq.put("\u0d3e\u0d24", 1928);
    freq.put("\u0d38\u0d19\u0d4d", 186);
    freq.put("\u0d3e\u0d26", 754);
    freq.put("\u0d3e\u0d27", 756);
    freq.put("\u0d3e\u0d19", 229);
    freq.put("\u0d3e\u0d1a", 293);
    freq.put("\u0d3e\u0d1c", 1079);
    freq.put("\u0d1f\u0d19", 583);
    freq.put("\u0d3e\u0d1f", 2078);
    freq.put("\u0d4d\u0d33\u0d3f", 382);
    freq.put("\u0d28", 73400);
    freq.put("\u0d3f\u0d31\u0d4d", 420);
    freq.put("\u0d2e\u0d47\u0d16", 168);
    freq.put("\u0d3e\u0d16", 155);
    freq.put("\u0d3e\u0d17", 1285);
    freq.put("\u0d06\u0d38\u0d4d", 173);
    freq.put("\u0d3f\u0d27\u0d3e", 325);
    freq.put("\u0d3e\u0d02", 1111);
    freq.put("\u0d15\u0d3f ", 452);
    freq.put("\u0d1f\u0d15", 1208);
    freq.put("\u0d35\u0d3e ", 463);
    freq.put("\u0d32\u0d47\u0d3e\u0d15", 643);
    freq.put("\u0d36\u0d02 ", 392);
    freq.put("\u0d3e\u0d7c", 1852);
    freq.put("\u0d3e\u0d7d", 616);
    freq.put("\u0d3e\u0d7e", 251);
    freq.put("\u0d31\u0d19", 256);
    freq.put("\u0d2c\u0d28\u0d4d", 340);
    freq.put("\u0d31\u0d1e", 137);
    freq.put("\u0d31\u0d02", 434);
    freq.put("\u0d31\u0d31", 173);
    freq.put("\u0d31\u0d35", 704);
    freq.put("\u0d31\u0d3f", 3562);
    freq.put("\u0d31\u0d3e", 1047);
    freq.put("\u0d3e\u0d7c ", 676);
    freq.put("\u0d31\u0d23", 147);
    freq.put("\u0d31\u0d24", 394);
    freq.put("v", 415);
    freq.put("\u0d32\u0d47\u0d3e\u0d2e", 256);
    freq.put("\u0d31\u0d2a", 149);
    freq.put("\u0d3f\u0d26", 770);
    freq.put("\u0d31\u0d2c", 175);
    freq.put("\u0d3f\u0d31\u0d19", 160);
    freq.put("\u0d31\u0d2e", 259);
    freq.put("\u0d2e\u0d3e\u0d15", 397);
    freq.put("\u0d3e\u0d02 ", 756);
    freq.put("\u0d33\u0d4d\u0d33", 3418);
    freq.put("f ", 272);
    freq.put("\u0d13", 760);
    freq.put("\u0d15\u0d7d ", 221);
    freq.put("\u0d47\u0d3e\u0d26\u0d4d", 147);
    freq.put("\u0d47\u0d24\u0d4d", 452);
    freq.put("\u0d2e\u0d3e\u0d38", 192);
    freq.put("\u0d2e\u0d3e\u0d32", 167);
    freq.put("\u0d2e\u0d3e\u0d31", 260);
    freq.put("\u0d2e\u0d3e\u0d30", 358);
    freq.put("\u0d2e\u0d3e\u0d2f", 3224);
    freq.put("\u0d2e\u0d3e\u0d28", 490);
    freq.put("\u0d30\u0d2e\u0d4d", 132);
    freq.put("\u0d4d\u0d32\u0d46", 193);
    freq.put("\u0d2e\u0d3e\u0d24", 372);
    freq.put("\u0d2e\u0d3e\u0d23", 3756);
    freq.put("\u0d33\u0d30\u0d46", 204);
    freq.put("\u0d4d\u0d32\u0d3e", 703);
    freq.put("\u0d4d\u0d32\u0d3f", 325);
    freq.put("\u0d2a\u0d30\u0d2e", 221);
    freq.put("\u0d38\u0d4d ", 1944);
    freq.put("\u0d2c\u0d24", 225);
    freq.put("\u0d1f\u0d3f\u0d28", 182);
    freq.put("\u0d26 ", 154);
    freq.put("\u0d4d\u0d32\u0d2f", 1398);
    freq.put("\u0d2a\u0d30\u0d3f", 493);
    freq.put("\u0d2a\u0d30\u0d3e", 131);
    freq.put("\u0d30\u0d42\u0d2a", 574);
    freq.put("a", 5004);
    freq.put("\u0d2e\u0d3e\u0d7c", 420);
    freq.put("\u0d40\u0d37\u0d4d", 363);
    freq.put("\u0d47\u0d24\u0d3e", 159);
    freq.put("\u0d4d\u0d31\u0d41", 446);
    freq.put("\u0d2a\u0d31\u0d2f", 460);
    freq.put(" \u0d35\u0d3e", 826);
    freq.put(" \u0d35\u0d3f", 3041);
    freq.put(" \u0d35\u0d38", 228);
    freq.put("\u0d42\u0d1f\u0d4d", 482);
    freq.put("\u0d4d\u0d31\u0d47", 221);
    freq.put("\u0d4d\u0d31\u0d46", 3192);
    freq.put(" \u0d35\u0d34", 131);
    freq.put("y ", 432);
    freq.put("\u0d07\u0d26\u0d4d", 200);
    freq.put(" \u0d35\u0d30", 613);
    freq.put(" \u0d35\u0d32", 423);
    freq.put(" \u0d35\u0d33", 462);
    freq.put("\u0d35\u0d4d", 1715);
    freq.put(" \u0d35\u0d2f", 153);
    freq.put(" \u0d35\u0d28", 287);
    freq.put("\u0d28\u0d3f\u0d38", 191);
    freq.put("\u0d35\u0d47\u0d3e", 132);
    freq.put("\u0d35\u0d47", 1138);
    freq.put("\u0d35\u0d46", 830);
    freq.put("\u0d35\u0d41", 2019);
    freq.put("\u0d35\u0d40", 487);
    freq.put("\u0d35\u0d43", 226);
    freq.put("\u0d1f\u0d2f", 443);
    freq.put("\u0d47\u0d31\u0d4d", 263);
    freq.put(" \u0d35\u0d1f", 443);
    freq.put("\u0d35\u0d7b", 194);
    freq.put(" \u0d35\u0d15", 168);
    freq.put("\u0d2a", 39149);
    freq.put("\u0d2f\u0d47\u0d3e ", 322);
    freq.put("\u0d05\u0d28\u0d41", 271);
    freq.put("\u0d42\u0d7c", 1703);
    freq.put("\u0d05\u0d28\u0d4d", 287);
    freq.put("\u0d4d\u0d31\u0d7c", 497);
    freq.put(" \u0d35\u0d7c", 592);
    freq.put("\u0d35\u0d1f", 524);
    freq.put("\u0d4d\u0d31\u0d02", 197);
    freq.put("\u0d35\u0d1a", 214);
    freq.put("\u0d35\u0d15", 573);
    freq.put("\u0d24\u0d40\u0d30", 189);
    freq.put("L", 186);
    freq.put("\u0d13\u0d2b", 177);
    freq.put("\u0d42\u0d15", 744);
    freq.put("\u0d36\u0d2e", 220);
    freq.put("\u0d42\u0d1f", 1342);
    freq.put("\u0d42\u0d1a", 155);
    freq.put("\u0d35\u0d02", 540);
    freq.put("\u0d42\u0d24", 256);
    freq.put("\u0d41\u0d15 ", 185);
    freq.put("\u0d2d\u0d42\u0d2e", 198);
    freq.put("\u0d35\u0d3e", 3225);
    freq.put("\u0d35\u0d39", 163);
    freq.put("\u0d35\u0d38", 973);
    freq.put("\u0d38\u0d3e\u0d27", 303);
    freq.put("\u0d42\u0d23", 183);
    freq.put("\u0d38\u0d3e\u0d28", 195);
    freq.put("\u0d42\u0d2e", 233);
    freq.put("\u0d35\u0d36", 269);
    freq.put("\u0d42\u0d28", 329);
    freq.put("\u0d35\u0d30", 1681);
    freq.put("\u0d42\u0d2a", 660);
    freq.put("\u0d38\u0d3e\u0d2e", 424);
    freq.put("\u0d4d\u0d31\u0d31", 147);
    freq.put(" \u0d35\u0d4d", 771);
    freq.put("\u0d35\u0d2f", 976);
    freq.put("\u0d35\u0d2e", 167);
    freq.put(" \u0d35\u0d48", 304);
    freq.put("\u0d42\u0d31", 506);
    freq.put("\u0d42\u0d32", 403);
    freq.put("\u0d42\u0d1f\u0d3f", 333);
    freq.put("\u0d38\u0d3e\u0d39", 254);
    freq.put("\u0d35\u0d24", 706);
    freq.put(" \u0d35\u0d46", 601);
    freq.put(" \u0d35\u0d47", 548);
    freq.put(" \u0d35\u0d40", 201);
    freq.put("\u0d42\u0d39", 200);
    freq.put("\u0d35\u0d23", 138);
    freq.put(" \u0d35\u0d43", 131);
    freq.put("\u0d4d\u0d2f\u0d19", 413);
    freq.put("\u0d2f\u0d41\u0d24", 144);
    freq.put("\u0d2f\u0d41\u0d2e", 248);
    freq.put("\u0d30\u0d33 ", 241);
    freq.put("\u0d4d\u0d2f\u0d15", 572);
    freq.put("\u0d2f\u0d41\u0d28", 1398);
    freq.put("\u0d41\u0d1f\u0d47", 141);
    freq.put("\u0d41\u0d1f\u0d46", 2766);
    freq.put("\u0d2f\u0d41\u0d33", 358);
    freq.put("\u0d2a\u0d3f\u0d15", 595);
    freq.put("\u0d41\u0d1f\u0d41", 255);
    freq.put("\u0d1e\u0d4d\u0d1e", 800);
    freq.put("\u0d4d\u0d2f\u0d02", 593);
    freq.put("\u0d41\u0d1f\u0d4d", 263);
    freq.put("\u0d1e\u0d4d\u0d1a", 1999);
    freq.put("\u0d4d\u0d2f\u0d38", 193);
    freq.put("\u0d2f\u0d41\u0d02", 2125);
    freq.put("\u0d2a\u0d3f\u0d28", 279);
    freq.put("\u0d4d\u0d2f\u0d30", 146);
    freq.put("\u0d46\u0d24\u0d4d", 201);
    freq.put("\u0d4d\u0d2f\u0d35", 286);
    freq.put("\u0d4d\u0d28\u0d40", 591);
    freq.put("\u0d4d\u0d2f\u0d2a", 213);
    freq.put("\u0d4d\u0d2f\u0d28", 356);
    freq.put("\u0d4d\u0d2f\u0d2f", 869);
    freq.put("\u0d4d\u0d2f\u0d2e", 802);
    freq.put("\u0d2f\u0d41\u0d1f", 1638);
    freq.put("\u0d7d\u0d2a", 280);
    freq.put("\u0d15\u0d40\u0d34", 158);
    freq.put("\u0d4d\u0d2f\u0d24", 846);
    freq.put("\u0d7e\u0d15\u0d4d", 604);
    freq.put("\u0d41\u0d1f\u0d19", 281);
    freq.put("\u0d4d\u0d2f\u0d47\u0d3e", 256);
    freq.put("\u0d30\u0d27\u0d3e", 578);
    freq.put("\u0d4d\u0d2f\u0d42", 574);
    freq.put("\u0d4d\u0d2f\u0d41", 1251);
    freq.put("\u0d4d\u0d2f\u0d47", 240);
    freq.put("\u0d4d\u0d2f\u0d7b", 654);
    freq.put("\u0d24\u0d41 ", 412);
    freq.put("\u0d2a\u0d4d\u0d30", 5359);
    freq.put("\u0d2a\u0d4d\u0d31", 162);
    freq.put("\u0d1f\u0d4d", 8736);
    freq.put("\u0d2a\u0d4d\u0d2a", 6916);
    freq.put("\u0d26\u0d02 ", 215);
    freq.put("\u0d2a\u0d4d\u0d2f", 278);
    freq.put("w", 903);
    freq.put("\u0d2e\u0d32\u0d2a", 135);
    freq.put("\u0d14", 217);
    freq.put("\u0d1f\u0d46", 3674);
    freq.put("\u0d2e\u0d32\u0d2f", 732);
    freq.put("\u0d17\u0d38", 163);
    freq.put("\u0d3f\u0d26\u0d4d", 640);
    freq.put("\u0d7d\u0d15", 534);
    freq.put("\u0d37\u0d4d\u0d20", 143);
    freq.put("\u0d28\u0d3e\u0d7d", 247);
    freq.put("\u0d07\u0d24\u0d4d", 627);
    freq.put("\u0d15\u0d3e\u0d7b", 202);
    freq.put("\u0d26\u0d15\u0d4d", 161);
    freq.put("\u0d36\u0d15", 161);
    freq.put("\u0d4d\u0d28\u0d41", 4523);
    freq.put("\u0d28\u0d3e\u0d1f", 633);
    freq.put("\u0d16\u0d4d", 518);
    freq.put("\u0d24\u0d7d ", 385);
    freq.put("b", 935);
    freq.put("\u0d2f\u0d7c ", 285);
    freq.put("\u0d28\u0d3e\u0d23", 1039);
    freq.put(" \u0d1f\u0d46", 156);
    freq.put("\u0d28\u0d41\u0d02", 1607);
    freq.put("\u0d28\u0d3e\u0d2f", 1102);
    freq.put("\u0d28\u0d3e\u0d2e", 420);
    freq.put("\u0d35\u0d4d\u0d35", 236);
    freq.put("\u0d27\u0d3f", 1094);
    freq.put("\u0d27\u0d3e", 1533);
    freq.put("\u0d4d\u0d15\u0d1f", 170);
    freq.put("\u0d34\u0d15", 439);
    freq.put("\u0d2d\u0d3e\u0d30", 363);
    freq.put("\u0d27\u0d24", 175);
    freq.put("\u0d4d\u0d15\u0d02", 167);
    freq.put("\u0d27\u0d2e", 209);
    freq.put("\u0d3f\u0d30\u0d3e", 141);
    freq.put("\u0d3f\u0d30\u0d3f", 844);
    freq.put("\u0d27\u0d28", 255);
    freq.put("\u0d34\u0d3f", 934);
    freq.put("\u0d4d\u0d15\u0d31", 207);
    freq.put("\u0d4d\u0d15\u0d30", 378);
    freq.put("\u0d40\u0d38\u0d4d", 201);
    freq.put("tp ", 236);
    freq.put("\u0d4d\u0d15\u0d3f", 2121);
    freq.put("\u0d4d\u0d15\u0d3e", 2470);
    freq.put("\u0d34\u0d2f", 224);
    freq.put("\u0d2a\u0d15\u0d30", 152);
    freq.put("\u0d15\u0d4d ", 1892);
    freq.put("\u0d3e\u0d7d ", 543);
    freq.put("\u0d4d\u0d15\u0d2f", 184);
    freq.put("\u0d35\u0d38\u0d4d", 414);
    freq.put("\u0d3f", 86416);
    freq.put("\u0d4d\u0d15\u0d2a", 570);
    freq.put("\u0d1f\u0d7c ", 247);
    freq.put("\u0d2e\u0d3f\u0d1a", 154);
    freq.put("\u0d35\u0d38\u0d3e", 210);
    freq.put("\u0d2e\u0d3f\u0d15", 467);
    freq.put("M", 384);
    freq.put("\u0d28\u0d02 ", 1340);
    freq.put("\u0d2a\u0d15\u0d4d", 254);
    freq.put("\u0d40\u0d24", 716);
    freq.put("\u0d4d\u0d15\u0d47", 378);
    freq.put("\u0d34\u0d4d", 515);
    freq.put("\u0d4d\u0d15\u0d41", 5270);
    freq.put("\u0d4d\u0d15\u0d43", 134);
    freq.put("\u0d4d\u0d15\u0d42", 155);
    freq.put("\u0d4d\u0d15\u0d4d", 1983);
    freq.put("\u0d32\u0d46\u0d2f", 139);
    freq.put("\u0d2c\u0d7c", 483);
    freq.put("\u0d4d\u0d15\u0d47\u0d3e", 591);
    freq.put("\u0d34\u0d41", 589);
    freq.put("\u0d24\u0d40\u0d7c", 152);
    freq.put("\u0d3f\u0d30\u0d41", 2143);
    freq.put("\u0d2e\u0d3f\u0d34", 237);
    freq.put("\u0d32\u0d46\u0d19", 175);
    freq.put("\u0d2e\u0d3f\u0d32", 152);
    freq.put("\u0d28\u0d41\u0d15", 143);
    freq.put("\u0d2e\u0d3f\u0d2f", 208);
    freq.put("\u0d2e\u0d3f\u0d28", 134);
    freq.put("\u0d27\u0d41", 167);
    freq.put("\u0d27\u0d40", 204);
    freq.put("\u0d27\u0d4d", 613);
    freq.put("\u0d25\u0d2e", 194);
    freq.put("\u0d32\u0d35\u0d3f", 164);
    freq.put("\u0d30\u0d24\u0d3f", 352);
    freq.put("\u0d1f\u0d24\u0d4d", 622);
    freq.put("\u0d26", 11612);
    freq.put("\u0d3f\u0d1a\u0d46", 253);
    freq.put("\u0d43\u0d36\u0d4d", 191);
    freq.put("\u0d28\u0d2a\u0d4d", 274);
    freq.put("\u0d3f\u0d1a\u0d4d", 3119);
    freq.put("\u0d41\u0d15\u0d7e", 669);
    freq.put("\u0d7e\u0d2a\u0d4d", 365);
    freq.put("\u093e", 135);
    freq.put("\u0d36\u0d41", 222);
    freq.put("\u0d30\u0d36\u0d38", 300);
    freq.put("\u0d15\u0d3e\u0d38", 134);
    freq.put("\u0d30\u0d24\u0d4d", 1578);
    freq.put("\u0d28\u0d3e\u0d32", 249);
    freq.put("\u0d32\u0d1a", 462);
    freq.put("\u0d30\u0d24\u0d40", 156);
    freq.put("\u0d3f\u0d32\u0d3e", 907);
    freq.put("\u0d3f\u0d32\u0d3f", 195);
    freq.put("\u0d3f\u0d21", 255);
    freq.put("\u0d17\u0d24\u0d4d", 599);
    freq.put("\u0d47\u0d3e\u0d1f\u0d4d", 908);
    freq.put("x", 345);
    freq.put("\u0d2d\u0d3e\u0d17", 860);
    freq.put("\u0d3f\u0d24\u0d4d", 1980);
    freq.put("\u0d4d\u0d19\u0d3f", 542);
    freq.put("\u0d4d\u0d19\u0d3e", 169);
    freq.put("\u0d4d\u0d19\u0d33", 3056);
    freq.put("\u0d15\u0d2e\u0d3e", 395);
    freq.put("\u0d4d\u0d19\u0d28", 152);
    freq.put("\u0d06\u0d02", 188);
    freq.put("\u0d06\u0d30", 244);
    freq.put("\u0d06\u0d31", 138);
    freq.put("\u0d06\u0d32", 222);
    freq.put("\u0d06\u0d35", 187);
    freq.put("\u0d06\u0d38", 222);
    freq.put("\u0d06\u0d23", 726);
    freq.put("\u0d06\u0d26", 541);
    freq.put("\u0d06\u0d27", 137);
    freq.put("\u0d06\u0d28", 248);
    freq.put("\u0d06\u0d2f", 406);
    freq.put("\u0d4d\u0d19\u0d7e", 1597);
    freq.put("\u0d37\u0d24\u0d4d", 575);
    freq.put("\u0d35\u0d41\u0d02", 1320);
    freq.put("c", 1838);
    freq.put("\u0d3f\u0d24\u0d2e", 146);
    freq.put("\u0d31\u0d35\u0d41", 574);
    freq.put("\u0d4d\u0d19\u0d4d", 141);
    freq.put("\u0d3e\u0d39\u0d3f", 294);
    freq.put("\u0d3f\u0d24\u0d3e", 203);
    freq.put("\u0d35\u0d41\u0d2e", 350);
    freq.put("\u0d15\u0d2e\u0d4d", 385);
    freq.put("\u0d15\u0d47\u0d3e\u0d1f", 568);
    freq.put("\u0d47\u0d3e\u0d24\u0d4d", 164);
    freq.put("\u0d30\u0d15\u0d4d", 477);
    freq.put("\u0d1c\u0d40\u0d35", 507);
    freq.put("\u0d4d\u0d30\u0d19", 393);
    freq.put("\u0d15\u0d30 ", 204);
    freq.put("\u0d10", 333);
    freq.put("\u0d26\u0d3f ", 217);
    freq.put(" \u0d7d", 544);
    freq.put("\u0d33\u0d47\u0d3e\u0d15", 168);
    freq.put("\u0d40\u0d35\u0d3f", 408);
    freq.put("px", 216);
    freq.put("\u0d15\u0d47\u0d3e\u0d34", 224);
    freq.put("\u0d2a\u0d24\u0d3f", 293);
    freq.put(" \u0d32\u0d46", 167);
    freq.put("pe", 169);
    freq.put("\u0d08 ", 1594);
    freq.put(" \u0d32\u0d47\u0d3e", 543);
    freq.put("\u0d2a\u0d24\u0d4d", 765);
    freq.put(" \u0d21", 822);
    freq.put(" \u0d26", 2030);
    freq.put(" \u0d27", 248);
    freq.put(" \u0d24", 5869);
    freq.put(" \u0d2a", 15081);
    freq.put(" \u0d2b", 858);
    freq.put(" \u0d28", 8054);
    freq.put(" \u0d32\u0d3e", 299);
    freq.put(" \u0d2e", 9063);
    freq.put(" \u0d2f", 1000);
    freq.put(" \u0d2c", 2531);
    freq.put("N", 219);
    freq.put(" \u0d32", 2034);
    freq.put("\u0d2e\u0d2e\u0d3e", 310);
    freq.put(" \u0d30", 2887);
    freq.put(" \u0d31", 942);
    freq.put(" \u0d36", 1879);
    freq.put(" \u0d37", 238);
    freq.put("\u0d30\u0d40\u0d24", 277);
    freq.put(" \u0d32\u0d2d", 180);
    freq.put("\u0d33\u0d3e\u0d2f", 311);
    freq.put(" \u0d38", 10862);
    freq.put(" \u0d39", 1263);
    freq.put("\u0d30\u0d40\u0d2f", 292);
    freq.put("\u0d32\u0d2e", 351);
    freq.put("\u0d23\u0d3f ", 174);
    freq.put(" \u0d06", 4494);
    freq.put(" \u0d07", 5444);
    freq.put("\u0d30\u0d40\u0d15", 374);
    freq.put(" \u0d05", 8029);
    freq.put(" \u0d08", 1746);
    freq.put(" \u0d09", 3278);
    freq.put(" \u0d0e", 6248);
    freq.put(" \u0d0f", 1397);
    freq.put(" \u0d12", 4983);
    freq.put(" \u0d13", 757);
    freq.put(" \u0d10", 325);
    freq.put("\u0d15\u0d41\u0d2a", 182);
    freq.put(" \u0d16", 305);
    freq.put(" \u0d17", 2980);
    freq.put(" \u0d14", 215);
    freq.put(" \u0d15", 14030);
    freq.put(" \u0d1a", 4988);
    freq.put("di", 309);
    freq.put(" \u0d1f", 631);
    freq.put(" \u0d1c", 4225);
    freq.put("\u0d1a\u0d4d", 5556);
    freq.put(" \u0d24\u0d4d", 183);
    freq.put("\u0d41\u0d02", 8705);
    freq.put("\u0d46\u0d3e\u0d30\u0d41", 147);
    freq.put(" \u0d24\u0d46", 531);
    freq.put("\u0d1a\u0d46", 2298);
    freq.put("\u0d1a\u0d47", 581);
    freq.put(" \u0d24\u0d43", 268);
    freq.put("\u0d1a\u0d41", 1255);
    freq.put(" \u0d24\u0d41", 591);
    freq.put(" \u0d24\u0d40", 297);
    freq.put("\u0d2d\u0d3f\u0d28", 146);
    freq.put("\u0d41\u0d15", 4108);
    freq.put("\u0d41\u0d17", 147);
    freq.put("\u0d41\u0d16", 381);
    freq.put("rig", 195);
    freq.put("\u0d35\u0d4d\u0d2f", 986);
    freq.put("\u0d41\u0d1f", 4050);
    freq.put("\u0d30\u0d7b ", 203);
    freq.put("\u0d41\u0d24", 2652);
    freq.put("\u0d09\u0d23\u0d4d", 335);
    freq.put("\u0d41\u0d26", 692);
    freq.put("\u0d41\u0d28", 10596);
    freq.put("\u0d41\u0d2a", 1108);
    freq.put("\u0d41\u0d2d", 196);
    freq.put("\u0d41\u0d2e", 2460);
    freq.put("\u0d41\u0d31", 1425);
    freq.put("\u0d1c\u0d28\u0d3f", 202);
    freq.put("\u0d41\u0d33", 2978);
    freq.put("\u0d41\u0d32", 285);
    freq.put("\u0d41\u0d35", 2148);
    freq.put("\u0d41\u0d34", 501);
    freq.put("\u0d41\u0d37", 436);
    freq.put("\u0d41\u0d36", 133);
    freq.put("\u0d41\u0d39", 134);
    freq.put("\u0d41\u0d38", 641);
    freq.put("\u0d33\u0d46 ", 475);
    freq.put("\u0d41\u0d24\u0d7d", 371);
    freq.put("\u0d41\u0d4d", 339);
    freq.put("\u0d1a\u0d15", 269);
    freq.put("\u0d3e\u0d17\u0d19", 167);
    freq.put("\u0d3e\u0d17\u0d24", 387);
    freq.put(" \u0d24\u0d2e", 355);
    freq.put("\u0d38\u0d2d\u0d2f", 152);
    freq.put("\u0d1a\u0d28", 269);
    freq.put("\u0d4d\u0d15\u0d33", 257);
    freq.put(" \u0d24\u0d28", 303);
    freq.put("\u0d1a\u0d24", 464);
    freq.put("\u0d3e\u0d17\u0d2e", 334);
    freq.put("\u0d1a\u0d32\u0d1a", 426);
    freq.put("\u0d18\u0d1f\u0d28", 192);
    freq.put(" \u0d24\u0d3f", 720);
    freq.put(" \u0d24\u0d3e", 982);
    freq.put("\u0d38\u0d2d\u0d3e", 174);
    freq.put("\u0d1a\u0d3f", 2735);
    freq.put("\u0d30\u0d4d ", 145);
    freq.put("\u0d41\u0d24\u0d41", 171);
    freq.put("y", 840);
    freq.put("\u0d32\u0d40", 583);
    freq.put("\u0d7b", 6054);
    freq.put("\u0d41\u0d24\u0d4d", 1223);
    freq.put("\u0d41\u0d7d", 137);
    freq.put(" \u0d24\u0d32", 366);
    freq.put("\u0d1a\u0d32", 494);
    freq.put(" \u0d24\u0d30", 169);
    freq.put("\u0d2f\u0d47\u0d15", 178);
    freq.put("\u0d33\u0d3f ", 445);
    freq.put("\u0d12", 5000);
    freq.put("\u0d32\u0d4d", 3649);
    freq.put("\u0d4d\u0d30\u0d2e", 1061);
    freq.put("\u0d4d\u0d21\u0d32", 230);
    freq.put("\u0d32\u0d48", 193);
    freq.put("\u0d28\u0d19\u0d4d", 656);
    freq.put("\u0d38\u0d2e\u0d3e", 200);
    freq.put("\u0d32\u0d46\u0d3e", 242);
    freq.put("\u0d32\u0d47\u0d3e", 1419);
    freq.put("\u0d46\u0d3e\u0d32\u0d4d", 164);
    freq.put("\u0d28\u0d17\u0d30", 403);
    freq.put("\u0d19\u0d4d\u0d15", 1271);
    freq.put("\u0d19\u0d4d\u0d19", 6013);
    freq.put("\u0d4d\u0d24\u0d47", 231);
    freq.put("\u0d38\u0d2e\u0d41", 201);
    freq.put("\u0d32\u0d24\u0d4d", 725);
    freq.put("\u0d3f\u0d32\u0d46\u0d3e", 225);
    freq.put("\u0d0f\u0d31\u0d4d", 547);
    freq.put("\u0d38\u0d2e\u0d4d", 174);
    freq.put("\u0d3f\u0d32\u0d47\u0d3e", 400);
    freq.put("\u0d15\u0d41\u0d02", 421);
    freq.put("d", 1581);
    freq.put("\u0d7c\u0d1c\u0d4d", 166);
    freq.put("\u0d46\u0d1f\u0d4d", 1283);
    freq.put("\u0d1a", 18270);
    freq.put("\u0d23\u0d2a", 319);
    freq.put("\u0d42\u0d31\u0d4d", 264);
    freq.put("b ", 294);
    freq.put("\u0d3f\u0d15\u0d3e", 247);
    freq.put("\u0d30\u0d15", 1280);
    freq.put("\u0d3f\u0d15\u0d33", 716);
    freq.put("\u0d3e\u0d28\u0d3f", 583);
    freq.put("\u0d3e\u0d28\u0d3e", 214);
    freq.put("\u0d30\u0d1e", 148);
    freq.put("\u0d30\u0d1c", 211);
    freq.put("\u0d23\u0d24", 458);
    freq.put("\u0d30\u0d02", 2337);
    freq.put("\u0d3e\u0d28\u0d24", 448);
    freq.put("\u0d7b ", 4719);
    freq.put("\u0d19\u0d33\u0d3f", 1296);
    freq.put("\u0d3f\u0d15\u0d2e", 181);
    freq.put("\u0d36\u0d2e\u0d3e", 164);
    freq.put(" \u0d17\u0d4d", 1743);
    freq.put("\u0d23\u0d35", 186);
    freq.put("\u0d3e\u0d28\u0d2a", 155);
    freq.put("\u0d31\u0d41\u0d15", 338);
    freq.put("\u0d30\u0d33", 1305);
    freq.put("\u0d30\u0d30", 176);
    freq.put("\u0d30\u0d36", 457);
    freq.put("\u0d30\u0d35", 1227);
    freq.put("\u0d23\u0d02", 729);
    freq.put("\u0d30\u0d38", 985);
    freq.put("\u0d30\u0d39", 238);
    freq.put("\u0d3e\u0d28\u0d19", 199);
    freq.put("\u0d30\u0d3f", 6901);
    freq.put("\u0d30\u0d23", 1938);
    freq.put("\u0d23\u0d19", 272);
    freq.put("\u0d30\u0d26", 892);
    freq.put("\u0d30\u0d27", 593);
    freq.put("\u0d30\u0d24", 2444);
    freq.put("\u0d31\u0d41\u0d02", 178);
    freq.put("\u0d30\u0d2a", 409);
    freq.put("\u0d3f\u0d15\u0d02", 150);
    freq.put("\u0d30\u0d28", 771);
    freq.put("\u0d30\u0d2e", 2024);
    freq.put("\u0d30\u0d2f", 465);
    freq.put("\u0d23\u0d15", 349);
    freq.put("\u0d7c\u0d2e\u0d4d", 559);
    freq.put("\u0d3f\u0d15\u0d7e", 430);
    freq.put("\u0d1f\u0d47\u0d2f", 132);
    freq.put("O", 182);
    freq.put("\u0d4d\u0d30\u0d28", 361);
    freq.put("\u0d30\u0d42", 693);
    freq.put("\u0d30\u0d40", 1446);
    freq.put("\u0d30\u0d41", 8550);
    freq.put("\u0d30\u0d46", 725);
    freq.put("\u0d30\u0d47", 448);
    freq.put("\u0d2c\u0d3e", 585);
    freq.put("\u0d30\u0d47\u0d3e", 818);
    freq.put("\u0d30\u0d4d", 755);
    freq.put("\u0d23\u0d4d", 14451);
    freq.put("\u0d23\u0d42", 306);
    freq.put("\u0d19\u0d33\u0d41", 891);
    freq.put("\u0d32\u0d4d\u0d2a", 290);
    freq.put("\u0d4d\u0d15\u0d46", 229);
    freq.put("\u0d3e\u0d28\u0d41", 295);
    freq.put("\u0d3f\u0d15\u0d4d", 6093);
    freq.put("\u0d3e\u0d28\u0d4d", 803);
    freq.put("\u0d31\u0d4d ", 1265);
    freq.put("\u0d30\u0d23 ", 296);
    freq.put("\u0d7d", 11771);
    freq.put("\u0d15\u0d32\u0d3e", 228);
    freq.put("\u0d2f\u0d02 ", 1215);
    freq.put("\u0d31\u0d19\u0d4d", 254);
    freq.put("\u0d12\u0d28\u0d4d", 342);
    freq.put(" \u0d0f\u0d15", 259);
    freq.put("\u0d07\u0d35\u0d3f", 189);
    freq.put("\u0d32\u0d02 ", 658);
    freq.put("\u0d47 ", 611);
    freq.put("\u0d4d\u0d15\u0d46\u0d3e", 183);
    freq.put(" \u0d0f\u0d31", 601);
    freq.put("\u0d15\u0d46\u0d3e\u0d1f", 175);
    freq.put("\u0d0f\u0d15\u0d26", 134);
    freq.put("\u0d42\u0d23\u0d3f", 149);
    freq.put("\u0d4d\u0d1a ", 729);
    freq.put("\u0d2e\u0d39\u0d3e", 304);
    freq.put("\u0d3f\u0d36\u0d47", 137);
    freq.put("us", 255);
    freq.put("\u0d3f\u0d36\u0d4d", 421);
    freq.put("um", 390);
    freq.put("ul", 150);
    freq.put("\u0d30\u0d1c\u0d4d", 131);
    freq.put("\u0d15\u0d46\u0d3e\u0d23", 402);
    freq.put("\u0d24\u0d4d ", 4999);
    freq.put("\u0d30\u0d41\u0d35", 555);
    freq.put("\u0d41\u0d35\u0d28", 251);
    freq.put("\u0d41\u0d35\u0d30", 355);
    freq.put("\u0d30\u0d41\u0d24", 325);
    freq.put("\u0d4d\u0d15\u0d7b", 384);
    freq.put("Th", 138);
    freq.put("\u0d30\u0d41\u0d28", 2242);
    freq.put("\u0d46\u0d19\u0d4d", 500);
    freq.put("\u0d37\u0d7b", 274);
    freq.put("\u0d30\u0d41\u0d2e", 189);
    freq.put("\u0d41\u0d35\u0d3e", 341);
    freq.put("\u0d37\u0d47", 485);
    freq.put("\u0d30\u0d41\u0d15", 338);
    freq.put("\u0d27", 5371);
    freq.put("\u0d47\u0d37\u0d4d", 132);
    freq.put("\u0d37\u0d4d", 2365);
    freq.put("\u0d30\u0d41\u0d1f", 311);
    freq.put("\u0d30\u0d41\u0d02", 137);
    freq.put("\u0d15\u0d4d\u0d24", 515);
    freq.put("\u0d2e\u0d19", 200);
    freq.put("\u0d37\u0d24", 605);
    freq.put("\u0d37\u0d23", 462);
    freq.put("\u0d37\u0d2f", 312);
    freq.put("\u0d37\u0d2e", 135);
    freq.put("\u0d2a\u0d41\u0d34", 384);
    freq.put("\u0d2a\u0d41\u0d30", 764);
    freq.put("\u0d2a\u0d41\u0d31", 547);
    freq.put("\u0d37\u0d30", 160);
    freq.put("\u0d37\u0d3f", 1059);
    freq.put("\u0d7d\u0d2a\u0d4d", 210);
    freq.put("\u0d2a\u0d41\u0d24", 214);
    freq.put("\u0d40 ", 761);
    freq.put("e", 5009);
    freq.put("\u0d37\u0d02", 305);
    freq.put("\u0d47\u0d37\u0d02", 140);
    freq.put("\u0d2a\u0d33\u0d4d", 185);
    freq.put("\u0d2a\u0d41\u0d15", 146);
    freq.put("\u0d37\u0d15", 240);
    freq.put("\u0d4d\u0d33\u0d47\u0d3e", 174);
    freq.put("\u0d47\u0d3e\u0d7e ", 349);
    freq.put("\u0d2f\u0d2e\u0d3e", 807);
    freq.put("\u0d33 ", 2840);
    freq.put("\u0d28\u0d4d ", 1964);
    freq.put("\u0d4d\u0d33\u0d41", 150);
    freq.put(" b", 205);
    freq.put(" c", 370);
    freq.put(" a", 486);
    freq.put(" f", 185);
    freq.put(" d", 151);
    freq.put(" e", 167);
    freq.put(" h", 314);
    freq.put(" i", 345);
    freq.put(" n", 149);
    freq.put(" o", 399);
    freq.put(" m", 228);
    freq.put(" r", 294);
    freq.put(" s", 377);
    freq.put(" p", 446);
    freq.put("\u0d39\u0d3e\u0d2f", 132);
    freq.put("\u0d2e\u0d47\u0d30", 234);
    freq.put(" w", 308);
    freq.put(" t", 707);
    freq.put("gh", 231);
    freq.put(" B", 247);
    freq.put(" C", 358);
    freq.put(" A", 386);
    freq.put(" F", 135);
    freq.put(" G", 193);
    freq.put(" D", 163);
    freq.put(" E", 193);
    freq.put(" H", 179);
    freq.put(" I", 298);
    freq.put(" N", 154);
    freq.put(" O", 131);
    freq.put(" L", 160);
    freq.put(" M", 333);
    freq.put(" R", 193);
    freq.put(" S", 374);
    freq.put(" P", 342);
    freq.put(" T", 265);
    freq.put("\u0d2a\u0d19\u0d4d", 155);
    freq.put("\u0d4d\u0d30\u0d38", 612);
    freq.put("ed ", 198);
    freq.put("P", 401);
    freq.put("\u0d23\u0d3f\u0d15", 268);
    freq.put("g ", 236);
    freq.put("\u0d19\u0d7e\u0d15", 243);
    freq.put("\u0d4d\u0d24\u0d2e", 327);
    freq.put("\u0d23\u0d3f\u0d24", 465);
    freq.put("us ", 153);
    freq.put("\u0d23\u0d3f\u0d2f", 184);
    freq.put("\u0d15\u0d30\u0d41", 191);
    freq.put("\u0d35\u0d43\u0d24", 136);
    freq.put("\u0d1f\u0d02 ", 259);
    freq.put("le ", 135);
    freq.put("\u0d0e\u0d32\u0d4d", 166);
    freq.put("\u0d47\u0d3e\u0d33\u0d3f", 145);
    freq.put("\u0d3f\u0d34\u0d15", 306);
    freq.put("\u0d15\u0d3e\u0d15", 163);
    freq.put("\u0d15\u0d3e\u0d1f", 474);
    freq.put("\u0d41 ", 10222);
    freq.put("\u0d15\u0d3e\u0d23", 507);
    freq.put("\u0d09\u0d7e", 449);
    freq.put("\u0d15\u0d3e\u0d28", 330);
    freq.put("\u0d15\u0d3e\u0d2f", 240);
    freq.put("\u0d15\u0d3e\u0d30", 1466);
    freq.put("\u0d33\u0d46\u0d2f", 186);
    freq.put("\u0d15\u0d3e\u0d32", 744);
    freq.put("\u0d15\u0d3e\u0d35", 233);
    freq.put("\u0d15\u0d3e\u0d36", 316);
    freq.put("\u0d39", 4850);
    freq.put(" \u0d15\u0d32", 418);
    freq.put("\u0d3f\u0d2d", 450);
    freq.put("\u0d24\u0d19\u0d4d", 171);
    freq.put("\u0d3f\u0d34\u0d4d", 206);
    freq.put("\u0d46\u0d15\u0d4d", 658);
    freq.put("\u0d4d\u0d24\u0d30", 440);
    freq.put("umb", 269);
    freq.put("\u0d16\u0d28", 135);
    freq.put("\u0d09\u0d33", 177);
    freq.put("\u0d1a ", 753);
    freq.put("\u0d1a\u0d46\u0d31", 399);
    freq.put("\u0d16\u0d30", 135);
    freq.put("\u0d16\u0d32", 214);
    freq.put("\u0d2f\u0d35\u0d38", 141);
    freq.put("\u0d09\u0d2f", 159);
    freq.put("\u0d09\u0d23", 345);
    freq.put("\u0d30\u0d4d\u0d2f", 585);
    freq.put("\u0d15\u0d3e\u0d7c", 351);
    freq.put("\u0d09\u0d24", 324);
    freq.put("\u0d23\u0d42\u0d7c", 281);
    freq.put("\u0d09\u0d26", 193);
    freq.put("\u0d4d\u0d24\u0d47\u0d3e", 380);
    freq.put("\u0d4d\u0d32\u0d47\u0d3e", 274);
    freq.put("\u0d4d\u0d24\u0d4d", 4115);
    freq.put("\u0d4d\u0d24\u0d42", 145);
    freq.put("\u0d4d\u0d24\u0d40", 242);
    freq.put("\u0d4d\u0d24\u0d41", 1834);
    freq.put("\u0d4d\u0d24\u0d46", 1346);
    freq.put("\u0d42\u0d7c ", 1389);
    freq.put("\u0d1c\u0d42", 197);
    freq.put("\u0d1c\u0d40", 561);
    freq.put("\u0d1c\u0d41", 186);
    freq.put("\u0d47\u0d7c\u0d28", 202);
    freq.put("\u0d05\u0d2d\u0d3f", 173);
    freq.put("\u0d1c\u0d4d", 1493);
    freq.put("\u0d1c\u0d47\u0d3e", 210);
    freq.put("\u0d43\u0d15", 135);
    freq.put("\u0d43\u0d24", 879);
    freq.put("\u0d38", 25595);
    freq.put("\u0d2e\u0d02 ", 430);
    freq.put("\u0d43\u0d37", 287);
    freq.put("\u0d38 ", 133);
    freq.put("\u0d4d\u0d24\u0d02", 182);
    freq.put("\u0d2a\u0d42\u0d7c", 310);
    freq.put("px ", 213);
    freq.put("\u0d0f\u0d31", 601);
    freq.put("\u0d4d\u0d24\u0d15", 337);
    freq.put("\u0d4d\u0d24\u0d2a", 248);
    freq.put("\u0d41\u0d26\u0d4d", 545);
    freq.put("\u0d4d\u0d24\u0d28", 539);
    freq.put("\u0d1c\u0d32", 137);
    freq.put("f", 703);
    freq.put("\u0d1c\u0d3e", 371);
    freq.put("\u0d1c\u0d3f", 2005);
    freq.put("\u0d4d\u0d24\u0d24", 221);
    freq.put("\u0d4d\u0d24\u0d3e", 1357);
    freq.put("\u0d4d\u0d24\u0d3f", 9289);
    freq.put("\u0d1c\u0d2f", 163);
    freq.put("\u0d0f\u0d15", 259);
    freq.put("\u0d1c\u0d28", 1163);
    freq.put("\u0d4d\u0d24\u0d35", 158);
    freq.put("\u0d2a\u0d7c", 146);
    freq.put("\u0d7c\u0d23\u0d4d", 319);
    freq.put("\u0d4d\u0d30\u0d40", 856);
    freq.put("\u0d23", 22285);
    freq.put("\u0d3e\u0d35\u0d4d", 303);
    freq.put("\u0d1a\u0d47\u0d7c", 314);
    freq.put("\u0d28\u0d26\u0d3f", 238);
    freq.put("\u0d46\u0d31\u0d4d", 191);
    freq.put("\u0d23\u0d02 ", 720);
    freq.put("\u0d3e\u0d27\u0d3e", 281);
    freq.put("\u0d3e\u0d27\u0d3f", 232);
    freq.put("\u0d3e\u0d35\u0d41", 302);
    freq.put("\u0d2a\u0d4d", 13660);
    freq.put("\u0d2a\u0d46\u0d3e", 466);
    freq.put("\u0d2a\u0d47\u0d3e", 1036);
    freq.put("\u0d2a\u0d46", 3528);
    freq.put("\u0d2a\u0d47", 973);
    freq.put("\u0d2a\u0d40", 178);
    freq.put("\u0d2a\u0d41", 2667);
    freq.put("\u0d28\u0d28\u0d4d", 309);
    freq.put("\u0d2a\u0d3e", 2340);
    freq.put("\u0d2a\u0d3f", 2507);
    freq.put("\u0d2a\u0d34", 198);
    freq.put("\u0d2a\u0d30", 1220);
    freq.put("\u0d2a\u0d31", 902);
    freq.put("\u0d2a\u0d32", 318);
    freq.put("\u0d2a\u0d33", 198);
    freq.put("\u0d3e\u0d35\u0d3e", 229);
    freq.put("\u0d3e\u0d35\u0d3f", 316);
    freq.put("\u0d2a\u0d2e", 183);
    freq.put("\u0d2a\u0d2f", 870);
    freq.put("\u0d2a\u0d28", 675);
    freq.put("\u0d46\u0d31\u0d3f", 225);
    freq.put("\u0d4d\u0d32\u0d42", 138);
    freq.put("\u0d2a\u0d24", 1182);
    freq.put("\u0d2a\u0d26", 488);
    freq.put("\u0d2a\u0d23", 230);
    freq.put("\u0d2a\u0d1e", 1399);
    freq.put("\u0d2a\u0d1f", 805);
    freq.put("\u0d2a\u0d19", 155);
    freq.put("\u0d3f\u0d24 ", 164);
    freq.put("\u0d2a\u0d15", 675);
    freq.put("\u0d28\u0d28\u0d02", 232);
    freq.put("\u0d09\u0d33\u0d4d", 169);
    freq.put("\u0d47\u0d16\u0d32", 167);
    freq.put("\u0d0e\u0d34\u0d41", 292);
    freq.put("\u0d2a\u0d02", 293);
    freq.put("\u0d47\u0d16", 487);
    freq.put("\u0d47\u0d15", 651);
    freq.put("\u0d46\u0d31\u0d41", 216);
    freq.put("\u0d47\u0d1f", 244);
    freq.put("\u0d47\u0d1c", 272);
    freq.put("\u0d3e\u0d2a\u0d3f", 311);
    freq.put("\u0d30\u0d35\u0d3e", 158);
    freq.put("\u0d3e\u0d2a\u0d28", 156);
    freq.put("\u0d47\u0d3e\u0d26", 305);
    freq.put("\u0d47\u0d37", 809);
    freq.put("\u0d47\u0d36", 1652);
    freq.put("\u0d47\u0d35", 391);
    freq.put("le", 352);
    freq.put("\u0d47\u0d32", 220);
    freq.put("\u0d47\u0d31", 444);
    freq.put("la", 410);
    freq.put("lo", 176);
    freq.put("ll", 179);
    freq.put("\u0d47\u0d39", 481);
    freq.put("li", 349);
    freq.put("\u0d47\u0d26", 234);
    freq.put("\u0d15\u0d2f\u0d41", 359);
    freq.put("\u0d47\u0d24", 832);
    freq.put("\u0d47\u0d23", 267);
    freq.put(" \u0d1c\u0d42", 195);
    freq.put(" \u0d1c\u0d40", 407);
    freq.put("\u0d47\u0d2f", 868);
    freq.put("\u0d4d\u0d1a\u0d4d", 847);
    freq.put(" \u0d1c\u0d4d", 148);
    freq.put(" \u0d1c\u0d47\u0d3e", 204);
    freq.put("\u0d47\u0d28", 623);
    freq.put("\u0d15\u0d3e\u0d31", 154);
    freq.put(" \u0d1c\u0d3f", 1596);
    freq.put("\u0d4d\u0d1a\u0d3e", 1705);
    freq.put("\u0d4d\u0d1a\u0d3f", 1394);
    freq.put("\u0d15\u0d2f\u0d3f", 197);
    freq.put("\u0d15\u0d2f\u0d3e", 132);
    freq.put("\u0d30\u0d35\u0d7c", 501);
    freq.put(" \u0d1c\u0d28", 950);
    freq.put("l ", 444);
    freq.put("\u0d47\u0d7c", 559);
    freq.put("\u0d30\u0d35\u0d41", 183);
    freq.put(" ht", 204);
    freq.put("\u0d24\u0d7d", 420);
    freq.put("\u0d43\u0d37\u0d4d", 193);
    freq.put("\u0d2a\u0d42", 626);
    freq.put("\u0d24\u0d43\u0d36", 187);
    freq.put("\u0d7a", 871);
    freq.put("\u0d4d\u0d24 ", 630);
    freq.put("\u0d3e\u0d2a\u0d4d", 231);
    freq.put("\u0d24\u0d4d\u0d24", 16443);
    freq.put("\u0d24\u0d4d\u0d25", 385);
    freq.put("\u0d3e\u0d38\u0d02", 149);
    freq.put("\u0d24\u0d4d\u0d2e", 171);
    freq.put("\u0d24\u0d4d\u0d2f", 2047);
    freq.put("\u0d30\u0d41 ", 4025);
    freq.put("\u0d23\u0d3e\u0d15", 136);
    freq.put("\u0d06\u0d26\u0d4d", 407);
    freq.put("\u0d30\u0d19\u0d4d", 806);
    freq.put("\u0d33\u0d4d", 3452);
    freq.put("\u0d24\u0d4d\u0d38", 249);
    freq.put("\u0d23\u0d3e\u0d1f", 139);
    freq.put("\u0d33\u0d41", 2116);
    freq.put("\u0d33\u0d47", 165);
    freq.put("h ", 190);
    freq.put("\u0d4d\u0d33 ", 2181);
    freq.put("\u0d25", 4613);
    freq.put("\u0d3e\u0d38\u0d2e", 136);
    freq.put("\u0d27\u0d2e\u0d3e", 139);
    freq.put("\u0d4d\u0d2a\u0d42", 178);
    freq.put("\u0d47\u0d28\u0d4d", 408);
    freq.put("\u0d3e\u0d38\u0d3f", 297);
    freq.put("\u0d40\u0d7c", 319);
    freq.put("\u0d37 ", 141);
    freq.put("\u0d3e\u0d38\u0d4d", 1047);
    freq.put("\u0d07\u0d38\u0d4d", 226);
    freq.put(" \u0d0e\u0d02", 133);
    freq.put("\u0d33\u0d15", 192);
    freq.put(" \u0d0e\u0d1f", 138);
    freq.put("\u0d40\u0d15", 980);
    freq.put("\u0d33\u0d02", 676);
    freq.put("\u0d40\u0d1f", 157);
    freq.put("\u0d32\u0d4d\u0d32", 3043);
    freq.put(" \u0d0e\u0d28", 4353);
    freq.put("\u0d33\u0d3f", 4155);
    freq.put("\u0d33\u0d3e", 873);
    freq.put("g", 1106);
    freq.put("\u0d40\u0d2a", 245);
    freq.put("\u0d15\u0d19\u0d4d", 196);
    freq.put("\u0d40\u0d28", 303);
    freq.put("\u0d33\u0d30", 321);
    freq.put("\u0d28\u0d4d\u0d31", 3777);
    freq.put("\u0d33\u0d35", 247);
    freq.put("\u0d40\u0d32", 186);
    freq.put(" \u0d0e\u0d38", 137);
    freq.put("\u0d28\u0d4d\u0d2e", 414);
    freq.put("\u0d28\u0d4d\u0d2f", 476);
    freq.put("\u0d28\u0d4d\u0d28", 18547);
    freq.put("\u0d40\u0d37", 499);
    freq.put("\u0d40\u0d34", 170);
    freq.put("\u0d40\u0d35", 642);
    freq.put(" \u0d0e\u0d31", 154);
    freq.put("\u0d28\u0d4d\u0d25", 210);
    freq.put("\u0d28\u0d4d\u0d26", 1121);
    freq.put("\u0d28\u0d4d\u0d27", 586);
    freq.put(" \u0d0e\u0d34", 295);
    freq.put("\u0d15\u0d7e\u0d15", 240);
    freq.put("\u0d33\u0d3f\u0d32", 1194);
    freq.put("\u0d4d\u0d35\u0d30", 172);
    freq.put("\u0d4d\u0d35\u0d3e", 520);
    freq.put("\u0d38\u0d28", 236);
    freq.put("\u0d24\u0d43", 441);
    freq.put("\u0d4d\u0d35\u0d24", 242);
    freq.put("\u0d38\u0d2e", 1136);
    freq.put("\u0d4d\u0d35\u0d2f", 160);
    freq.put("\u0d33\u0d3f\u0d2f", 253);
    freq.put("\u0d4d\u0d20", 162);
    freq.put("\u0d05\u0d1f\u0d3f", 235);
    freq.put("\u0d33\u0d3f\u0d15", 406);
    freq.put("\u0d24", 67027);
    freq.put("\u0d38\u0d2d", 457);
    freq.put("\u0d48\u0d26\u0d4d", 158);
    freq.put("\u0d4d\u0d25\u0d32", 260);
    freq.put("\u0d33\u0d3f\u0d7d", 1372);
    freq.put("\u0d7c\u0d2a", 232);
    freq.put("\u0d41\u0d37\u0d4d", 354);
    freq.put("R", 240);
    freq.put("\u0d2b\u0d4d", 882);
    freq.put("\u0d4d\u0d25\u0d3f", 931);
    freq.put("\u0d38\u0d38", 365);
    freq.put("\u0d19\u0d4d ", 236);
    freq.put("\u0d38\u0d39", 227);
    freq.put("\u0d4d\u0d35\u0d40", 179);
    freq.put("\u0d38\u0d48", 220);
    freq.put("\u0d38\u0d3e", 1870);
    freq.put(" \u0d31\u0d47\u0d3e", 225);
    freq.put("\u0d38\u0d3f", 2539);
    freq.put("\u0d05\u0d15\u0d4d", 233);
    freq.put("\u0d7b\u0d31", 218);
    freq.put("\u0d23 ", 661);
    freq.put("\u0d0f", 1399);
    freq.put("\u0d7b\u0d21", 203);
    freq.put("\u0d3e\u0d24\u0d4d", 940);
    freq.put("\u0d3e\u0d28 ", 514);
    freq.put("\u0d30\u0d23\u0d4d", 518);
    freq.put("\u0d7b\u0d2a", 166);
    freq.put("\u0d3f\u0d15 ", 723);
    freq.put("\u0d4d\u0d23\u0d3e", 141);
    freq.put("\u0d30 ", 1278);
    freq.put("\u0d38\u0d35", 164);
    freq.put("\u0d4d\u0d2a\u0d47\u0d3e", 426);
    freq.put("\u0d28\u0d15\u0d4d", 345);
    freq.put("\u0d4d\u0d23\u0d42", 295);
    freq.put("\u0d2f\u0d4d ", 274);
    freq.put("\u0d30\u0d23\u0d02", 295);
    freq.put("\u0d36\u0d24\u0d4d", 307);
    freq.put("\u0d3e\u0d24\u0d3f", 141);
    freq.put("\u0d24\u0d3f", 15367);
    freq.put("\u0d31\u0d4d\u0d31", 5132);
    freq.put("\u0d05\u0d31\u0d2c", 149);
    freq.put("\u0d3e\u0d24\u0d28", 248);
    freq.put("\u0d02\u0d38\u0d4d", 701);
    freq.put("\u0d30\u0d23\u0d24", 177);
    freq.put("\u0d2d\u0d42", 412);
    freq.put("\u0d27\u0d3f\u0d15", 430);
    freq.put("\u0d3e ", 1411);
    freq.put("\u0d31\u0d15\u0d4d", 177);
    freq.put("\u0d4d\u0d15", 17340);
    freq.put("\u0d4d\u0d17", 330);
    freq.put("\u0d35\u0d30\u0d3f", 311);
    freq.put("\u0d27\u0d3f\u0d2f", 166);
    freq.put("\u0d3e\u0d30\u0d2e", 247);
    freq.put(" in", 230);
    freq.put("\u0d36", 8287);
    freq.put("\u0d38\u0d1e", 150);
    freq.put("\u0d47\u0d3e\u0d7c", 445);
    freq.put("\u0d35\u0d3e\u0d23", 177);
    freq.put("\u0d35\u0d3e\u0d24", 177);
    freq.put("\u0d30\u0d47\u0d3e\u0d17", 204);
    freq.put("\u0d35\u0d3e\u0d26", 195);
    freq.put("\u0d35\u0d30\u0d46", 305);
    freq.put("\u0d17\u0d4d\u0d17", 220);
    freq.put("\u0d35\u0d30\u0d41", 524);
    freq.put("\u0d2d\u0d15", 205);
    freq.put("\u0d4d\u0d37\u0d3f", 552);
    freq.put("\u0d18\u0d1f", 411);
    freq.put("\u0d4d\u0d1c", 323);
    freq.put("\u0d35\u0d3e\u0d38", 359);
    freq.put("ng ", 163);
    freq.put("h", 2313);
    freq.put("\u0d2d\u0d2f", 191);
    freq.put("\u0d17\u0d4d\u0d30", 2123);
    freq.put("\u0d47\u0d2f\u0d41", 430);
    freq.put("\u0d3e\u0d7c\u0d21", 136);
    freq.put("\u0d31 ", 307);
    freq.put("\u0d32\u0d47\u0d3e ", 133);
    freq.put("\u0d3e\u0d7c\u0d24", 251);
    freq.put("\u0d05\u0d32\u0d4d", 193);
    freq.put("\u0d2d\u0d3f", 475);
    freq.put("\u0d4d\u0d1a", 6932);
    freq.put("\u0d4d\u0d37\u0d30", 156);
    freq.put("\u0d47\u0d39\u0d02", 278);
    freq.put("\u0d26\u0d7c", 205);
    freq.put("\u0d40\u0d24\u0d3f", 299);
    freq.put("\u0d41\u0d31\u0d02", 199);
    freq.put("\u0d21", 3439);
    freq.put("\u0d47\u0d39\u0d24", 162);
    freq.put("\u0627", 186);
    freq.put("\u0d24\u0d1f", 148);
    freq.put("\u0d41\u0d31\u0d3f", 322);
    freq.put("\u0d26\u0d40", 159);
    freq.put("\u0d41\u0d31\u0d24", 245);
    freq.put("\u0d46\u0d2c\u0d4d", 146);
    freq.put("\u0d2f\u0d24\u0d4d", 2606);
    freq.put("\u0d2e\u0d19\u0d4d", 199);
    freq.put("\u0d17\u0d3f\u0d15", 587);
    freq.put("\u0d26\u0d4d", 4614);
    freq.put("\u0d26\u0d30", 150);
    freq.put("\u0d30\u0d2f\u0d3f", 142);
    freq.put("\u0d38\u0d4d\u0d2f", 395);
    freq.put("\u0d38\u0d4d\u0d2a", 221);
    freq.put("\u0d2f\u0d24\u0d3f", 155);
    freq.put("\u0d38\u0d4d\u0d24", 2267);
    freq.put("\u0d38\u0d4d\u0d25", 2863);
    freq.put("\u0d19\u0d7e", 1604);
    freq.put("\u0d26\u0d3e", 495);
    freq.put("\u0d26\u0d3f", 1290);
    freq.put("S", 493);
    freq.put("\u0d38\u0d4d\u0d38", 397);
    freq.put("\u0d41\u0d31\u0d4d", 170);
    freq.put("\u0d38\u0d4d\u0d35", 855);
    freq.put("\u0d4d\u0d32 ", 256);
    freq.put("\u0d38\u0d4d\u0d31", 846);
    freq.put("\u0d38\u0d4d\u0d32", 281);
    freq.put("\u0d24\u0d3e\u0d35", 406);
    freq.put("ww", 338);
    freq.put("\u0d24\u0d15", 671);
    freq.put("\u0d26\u0d15", 185);
    freq.put("\u0d47\u0d30", 2800);
    freq.put(" \u0d2f\u0d42", 213);
    freq.put(" \u0d2f\u0d41", 294);
    freq.put("\u0d26\u0d02", 233);
    freq.put("\u0d4d\u0d37\u0d47", 452);
    freq.put("\u0d42\u0d15\u0d4d", 727);
    freq.put("\u0d38\u0d4d\u0d15", 623);
    freq.put("\u0d32\u0d2a\u0d4d", 395);
    freq.put("\u0d38\u0d38\u0d4d", 334);
    freq.put("ci", 170);
    freq.put("ch", 206);
    freq.put("co", 290);
    freq.put("\u0d38\u0d7c", 564);
    freq.put("ca", 205);
    freq.put("ce", 229);
    freq.put("na", 310);
    freq.put("\u0d15\u0d02 ", 627);
    freq.put("\u0d47\u0d38", 147);
    freq.put("ct", 158);
    freq.put("\u0d20", 364);
    freq.put("\u0d3f\u0d1e\u0d4d", 388);
    freq.put("\u0d28\u0d24\u0d3f", 539);
    freq.put("\u0d3e\u0d37\u0d4d", 369);
    freq.put("\u0d46\u0d33\u0d4d", 180);
    freq.put("\u0d4d\u0d1a\u0d47", 162);
    freq.put("\u0d4d\u0d1a\u0d41", 944);
    freq.put("\u0d2f\u0d46 ", 323);
    freq.put("\u0d3e\u0d37\u0d2f", 224);
    freq.put("\u0d15\u0d35\u0d3f", 299);
    freq.put("\u0d42", 8137);
    freq.put("\u0d28\u0d24\u0d41", 269);
    freq.put("\u0d25\u0d3e\u0d28", 1185);
    freq.put("\u0d28\u0d24\u0d4d", 2604);
    freq.put("\u0d23\u0d19\u0d4d", 272);
    freq.put("nd", 424);
    freq.put("\u0d31\u0d7c ", 428);
    freq.put("\u0d1a\u0d24\u0d4d", 271);
    freq.put("\u0d7c\u0d21\u0d4d", 135);
    freq.put("\u0d33\u0d02 ", 631);
    freq.put("\u0d2e\u0d41\u0d23", 204);
    freq.put("\u0d3f\u0d28\u0d3e", 453);
    freq.put("\u0d3f\u0d28\u0d3f", 378);
    freq.put("\u0d2e\u0d41\u0d26", 221);
    freq.put("ve", 190);
    freq.put("\u0d2e\u0d41\u0d24", 397);
    freq.put("\u0d32\u0d15\u0d4d", 585);
    freq.put("\u0d43\u0d24\u0d4d", 357);
    freq.put("\u0d2e\u0d41\u0d28", 161);
    freq.put("\u0d2e\u0d41\u0d33", 608);
    freq.put("\u0d2e\u0d41\u0d38", 161);
    freq.put("\u0d1f\u0d02", 274);
    freq.put("\u0d1f\u0d3f", 3790);
    freq.put("\u0d1f\u0d3e", 1306);
    freq.put("of ", 224);
    freq.put("\u0d24\u0d40\u0d2f", 195);
    freq.put("\u0d3f\u0d7d\u0d2a", 165);
    freq.put("\u0d1f\u0d35", 181);
    freq.put("\u0d1f\u0d32", 163);
    freq.put("\u0d1f\u0d31", 140);
    freq.put("\u0d02\u0d17\u0d40", 301);
    freq.put("\u0d1f\u0d2e", 180);
    freq.put("\u0d2e\u0d41\u0d16", 353);
    freq.put("\u0d1f\u0d2a", 165);
    freq.put("\u0d2e\u0d41\u0d15", 147);
    freq.put("\u0d2c\u0d4d ", 189);
    freq.put("\u0d2c\u0d3f", 709);
    freq.put("\u0d1f\u0d24", 795);
    freq.put("\u0d1f\u0d23", 268);
    freq.put("\u0d02\u0d17\u0d4d", 542);
    freq.put("\u0d02\u0d17\u0d32", 153);
    freq.put("\u0d31\u0d7c", 523);
    freq.put("\u0d2c\u0d41", 258);
    freq.put("\u0d47\u0d3e", 12821);
    freq.put("\u0d3f\u0d24\u0d3f", 938);
    freq.put("\u0d2c\u0d47\u0d3e", 333);
    freq.put("\u0d2c\u0d48", 150);
    freq.put("ion", 318);
    freq.put("\u0d2c\u0d3f ", 170);
    freq.put("\u0d1f\u0d47\u0d3e", 357);
    freq.put("\u0d1f\u0d47", 223);
    freq.put("\u0d2e\u0d41\u0d7b", 206);
    freq.put("\u0d1f\u0d41", 5165);
    freq.put("\u0d1f\u0d40", 186);
    freq.put("\u0d4d\u0d1a\u0d24", 372);
    freq.put("\u0d1f\u0d7c", 374);
    freq.put("i", 4303);
    freq.put("\u0d15\u0d32\u0d4d", 194);
    freq.put("\u0d3f\u0d28\u0d4d", 5173);
    freq.put("\u0d3f\u0d28\u0d47\u0d3e", 212);
    freq.put("\u0d32\u0d15\u0d33", 209);
    freq.put("\u0d3f\u0d28\u0d46", 479);
    freq.put("\u0d43\u0d24\u0d3f", 272);
    freq.put("\u0d3f\u0d28\u0d41", 1055);
    freq.put("\u0d4d\u0d2a\u0d4d", 921);
    freq.put("\u0d35\u0d2f\u0d41", 170);
    freq.put("\u0d7d ", 10227);
    freq.put("\u0d3f\u0d35\u0d7c", 154);
    freq.put("the", 302);
    freq.put("\u0d3f\u0d7b ", 265);
    freq.put("\u0d15\u0d3f\u0d7d", 695);
    freq.put("\u0d37\u0d47\u0d24", 398);
    freq.put("\u0d05\u0d31\u0d3f", 618);
    freq.put("\u0d27\u0d3e\u0d28", 997);
    freq.put("\u0d46\u0d3e\u0d1f\u0d4d", 150);
    freq.put("\u0d35\u0d2f\u0d02", 133);
    freq.put("\u0d27\u0d3e\u0d30", 358);
    freq.put("T", 348);
    freq.put("\u0d15\u0d3f\u0d1f", 299);
    freq.put("\u0d3f\u0d35\u0d38", 160);
    freq.put("\u0d3f\u0d35\u0d3f", 329);
    freq.put("\u0d3f\u0d35\u0d3e", 178);
    freq.put("\u0d7c", 12870);
    freq.put("\u0d23\u0d2e\u0d3e", 331);
    freq.put("\u0d3f\u0d35\u0d30", 215);
    freq.put("\u0d15\u0d3f\u0d2f", 350);
    freq.put("\u0d35\u0d2f\u0d3e", 176);
    freq.put("\u0d28\u0d47\u0d3e\u0d35", 149);
    freq.put("\u0d15\u0d3f\u0d32", 839);
    freq.put("\u0d3f\u0d35\u0d2f", 235);
    freq.put("\u0d17\u0d02 ", 252);
    freq.put("\u0d15\u0d3f\u0d34", 329);
    freq.put("igh", 217);
    freq.put("\u0d15\u0d4d\u0d15", 14730);
    freq.put("\u0d2f\u0d7b ", 979);
    freq.put("\u0d15\u0d4d\u0d1f", 264);
    freq.put("\u0d28\u0d40 ", 509);
    freq.put("\u0d35\u0d4d ", 420);
    freq.put("\u0d27 ", 268);
    freq.put("\u0d41\u0d30\u0d41", 345);
    freq.put("\u0d28\u0d42", 483);
    freq.put("\u0d4d\u0d38\u0d3f", 291);
    freq.put("\u0d15\u0d4d\u0d37", 2208);
    freq.put("\u0d2e\u0d28\u0d41", 281);
    freq.put("\u0d15\u0d4d\u0d30", 1063);
    freq.put("\u0d15\u0d4d\u0d32", 147);
    freq.put("\u0d2e\u0d28\u0d4d", 204);
    freq.put("nd ", 168);
    freq.put("\u0d46\u0d3e\u0d24\u0d41", 218);
    freq.put("\u0d15\u0d4d\u0d38", 418);
    freq.put(" \u0d30\u0d42", 379);
    freq.put(" \u0d30\u0d40", 168);
    freq.put("\u0d4d\u0d15 ", 209);
    freq.put("\u0d4d\u0d36\u0d47", 205);
    freq.put("\u0d15\u0d4d\u0d2f", 293);
    freq.put("\u0d34 ", 264);
    freq.put("\u0d4d", 186908);
    freq.put(" \u0d30\u0d3e", 1161);
    freq.put(" \u0d30\u0d23", 452);
    freq.put("\u0d32\u0d46 ", 4757);
    freq.put("\u0d41\u0d30\u0d02", 260);
    freq.put("\u0d17\u0d3e\u0d28", 207);
    freq.put("\u0d41\u0d30\u0d3e", 293);
    freq.put("\u0d3e\u0d30\u0d23", 361);
    freq.put(" \u0d30\u0d1a", 157);
    freq.put("es ", 231);
    freq.put("\u0d2e\u0d3f ", 226);
    freq.put("\u0d31\u0d2c\u0d3f", 132);
    freq.put("\u0d2f\u0d47\u0d3e\u0d17", 971);
    freq.put("\u0d4d\u0d25\u0d02", 135);
    freq.put("\u0d4d\u0d30\u0d15", 715);
    freq.put("\u0d41\u0d15\u0d46\u0d3e", 132);
    freq.put("\u0d41\u0d15\u0d4d", 824);
    freq.put(" \u0d15\u0d1f", 337);
    freq.put("\u0d37\u0d3f\u0d15", 304);
    freq.put("\u0d1f\u0d3e\u0d2e", 153);
    freq.put("\u0d3e\u0d26\u0d4d", 187);
    freq.put("\u0d19\u0d28", 154);
    freq.put("\u0d37\u0d3f\u0d2f", 170);
    freq.put("\u0d24\u0d41\u0d1f", 444);
    freq.put("\u0d4d\u0d25\u0d2e", 153);
    freq.put("ns", 149);
    freq.put("\u0d37\u0d3f\u0d23", 161);
    freq.put("\u0d19\u0d3f", 552);
    freq.put("\u0d19\u0d3e", 172);
    freq.put("\u0d19\u0d33", 3065);
    freq.put("\u0d4d\u0d25\u0d3e", 1534);
    freq.put(" \u0d21\u0d3f", 290);
    freq.put("\u0d32\u0d38\u0d4d", 209);
    freq.put("\u0d33\u0d47\u0d3e", 309);
    freq.put("ht", 515);
    freq.put("hu", 298);
    freq.put("hi", 201);
    freq.put("\u0d3e\u0d34\u0d4d", 134);
    freq.put("ha", 244);
    freq.put("\u0d26\u0d47", 2169);
    freq.put("he", 539);
    freq.put("\u0d3f\u0d37\u0d4d", 341);
    freq.put("\u0d7c\u0d35", 450);
    freq.put("\u0d42 ", 136);
    freq.put("\u0d1f\u0d28", 619);
    freq.put("\u0d3e\u0d26\u0d3f", 179);
    freq.put("\u0d41\u0d15\u0d2f", 410);
    freq.put("\u0d41\u0d15\u0d33", 1051);
    freq.put("\u0d06\u0d23\u0d4d", 627);
    freq.put("\u0d21\u0d4d ", 679);
    freq.put("\u0d35 ", 552);
    freq.put("\u0d41\u0d15\u0d3f", 165);
    freq.put("\u0d41\u0d15\u0d3e", 227);
    freq.put("\u0d15\u0d23\u0d15", 160);
    freq.put("\u0d1a\u0d46\u0d1f", 173);
    freq.put("\u0d30\u0d33\u0d24", 906);
    freq.put("\u0d30\u0d40\u0d30", 138);
    freq.put("\u0d0e\u0d31", 155);
    freq.put("ing", 193);
    freq.put("\u0d2a\u0d3f ", 248);
    freq.put("\u0d15\u0d31\u0d4d", 169);
    freq.put(" \u0d1a\u0d47", 382);
    freq.put(" \u0d1a\u0d46", 1896);
    freq.put(" \u0d1a\u0d41", 295);
    freq.put("\u0d33\u0d46", 751);
    freq.put("\u0d19\u0d3f\u0d2f", 431);
    freq.put("\u0d1a\u0d46\u0d2f", 1441);
    freq.put("\u0d37", 7585);
    freq.put("\u0d4d\u0d2f ", 889);
    freq.put(" \u0d32\u0d3f", 203);
    freq.put("\u0d2b\u0d46", 137);
    freq.put("\u0d7b\u0d31\u0d46", 142);
    freq.put("\u0d24\u0d41\u0d02", 420);
    freq.put("\u0d26\u0d24\u0d4d", 171);
    freq.put("\u0d2e\u0d46\u0d28", 220);
    freq.put("\u0d28\u0d26", 293);
    freq.put("\u0d24\u0d41\u0d15", 619);
    freq.put(" \u0d1a\u0d3f", 892);
    freq.put(" \u0d1a\u0d3e", 241);
    freq.put("\u0d39\u0d3f\u0d28", 258);
    freq.put("\u0d15\u0d23\u0d4d", 651);
    freq.put("\u0d39\u0d3f\u0d24", 291);
    freq.put("in ", 185);
    freq.put(" \u0d1a\u0d30", 212);
    freq.put(" \u0d1a\u0d32", 414);
    freq.put("\u0d3f\u0d19\u0d4d", 403);
    freq.put("\u0d3f\u0d7c\u0d24", 148);
    freq.put("ta", 278);
    freq.put("\u0d24\u0d41\u0d2e", 302);
    freq.put("\u0d24\u0d41\u0d28", 334);
    freq.put("\u0d3f\u0d7c\u0d2e", 366);
    freq.put("\u0d24\u0d41\u0d35", 386);
    freq.put("\u0d24\u0d41\u0d33", 199);
    freq.put("\u0d2a\u0d4d ", 643);
    freq.put("\u0d33\u0d3e\u0d23", 384);
  }
  
}

