package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class MK extends CLangProfile {
  private static final String name = "mk";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public MK() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2810075;
    n_words[1] = 3234074;
    n_words[2] = 2357835;

    freq.put("\u0431\u043b\u0438", 2035);
    freq.put("\u0440\u043d\u0430", 1303);
    freq.put("\u0440\u043d\u043e", 847);
    freq.put("\u0431\u043b\u0430", 981);
    freq.put("\u0440\u043d\u0438", 1032);
    freq.put("\u043e\u043f\u0441", 733);
    freq.put("\u043e\u043f\u0458", 624);
    freq.put("\u0418", 3549);
    freq.put("\u0444\u0435\u0432", 335);
    freq.put("\u043f\u0448\u0442", 1492);
    freq.put("\u0420\u0443", 528);
    freq.put(" \u043c\u0435", 2789);
    freq.put(" \u043c\u0430", 4441);
    freq.put("\u0448 ", 868);
    freq.put(" \u043c\u043d", 729);
    freq.put(" \u043c\u0438", 1057);
    freq.put("\u043f\u043e\u043a", 698);
    freq.put("\u043f\u043e\u043b", 2038);
    freq.put("\u043f\u043e\u043f", 440);
    freq.put("\u043f\u043e\u043c", 1198);
    freq.put("\u043f\u043e\u043d", 487);
    freq.put("\u043f\u043e\u0432", 1628);
    freq.put("\u043f\u043e\u0433", 377);
    freq.put("\u043f\u043e\u0437", 1786);
    freq.put("\u0435\u0440 ", 2117);
    freq.put("\u043f\u043e\u0435", 340);
    freq.put("\u0447\u0435 ", 342);
    freq.put("\u043f\u043e\u0442", 1782);
    freq.put("\u043e\u043f\u0440", 349);
    freq.put("\u043f\u043e\u0440", 1847);
    freq.put("\u043f\u043e\u0441", 2237);
    freq.put("\u043f\u043e\u0447", 860);
    freq.put("\u043f\u043e\u0458", 398);
    freq.put("\u0441\u043e ", 5615);
    freq.put("\u0420\u0435", 1553);
    freq.put("\u0458", 55736);
    freq.put("\u0420\u0438", 680);
    freq.put("\u0420\u043e", 593);
    freq.put("\u0444\u0435\u0440", 358);
    freq.put("\u043b\u0430\u043c", 296);
    freq.put("\u0438\u043d\u0441", 2166);
    freq.put("\u043e\u043f\u043e", 646);
    freq.put("\u043e\u043f\u0438", 565);
    freq.put("\u043e\u043f\u0435", 396);
    freq.put("\u0430\u0458 ", 1373);
    freq.put("\u043e\u043f\u0430", 631);
    freq.put(" \u0420\u0443", 528);
    freq.put("\u0446\u0430 ", 1645);
    freq.put("\u0437\u0438\u0458", 706);
    freq.put("\u0438\u043d\u043e", 890);
    freq.put(" km", 286);
    freq.put("\u0437\u0438\u0446", 855);
    freq.put("\u0437\u0438\u0447", 514);
    freq.put("\u0437\u0438\u0440", 670);
    freq.put("\u0437\u0438\u0442", 574);
    freq.put(" \u0410\u043c", 433);
    freq.put("\u043d\u0430\u0434", 781);
    freq.put("\u043d\u0430\u0435", 357);
    freq.put("\u043d\u0430\u0432", 317);
    freq.put("\u043d\u0430\u043e", 2376);
    freq.put("\u043d\u0430\u043f", 588);
    freq.put("\u043d\u0430\u043c", 682);
    freq.put("\u043d\u0430\u043d", 329);
    freq.put("\u043d\u0430\u043a", 346);
    freq.put("\u043d\u0430\u043b", 1991);
    freq.put("\u0430\u0448\u043a", 290);
    freq.put("\u043b\u0438 ", 5921);
    freq.put("\u0443", 55891);
    freq.put("\u03c2", 427);
    freq.put("\u0441\u043c\u0435", 854);
    freq.put("\u043d\u0430\u0458", 2709);
    freq.put("\u043d\u0430\u0446", 749);
    freq.put("\u043d\u0430\u0447", 1308);
    freq.put("\u043d\u0430\u0442", 7755);
    freq.put("\u043d\u0430\u0443", 554);
    freq.put("\u043d\u0430\u0440", 1995);
    freq.put("\u043d\u0430\u0441", 2005);
    freq.put("\u045a\u0430 ", 993);
    freq.put("\u043c\u043d\u043e", 1052);
    freq.put("\u043c\u043d\u0430", 468);
    freq.put("\u0437\u0438\u043d", 797);
    freq.put("k", 1469);
    freq.put("\u0430\u045a\u0430", 532);
    freq.put("\u0437\u0438\u043a", 2343);
    freq.put(" \u0420\u0430", 517);
    freq.put(" \u0420\u0435", 1553);
    freq.put("\u043c\u0458\u0430", 559);
    freq.put(" \u0420\u0438", 680);
    freq.put(" \u0420\u043e", 593);
    freq.put("\u043c\u0458\u0438", 343);
    freq.put("\u0435\u0437\u0438", 298);
    freq.put("\u0435\u0437\u043d", 323);
    freq.put("\u0435\u0437\u0430", 382);
    freq.put("\u0435\u0437\u0435", 477);
    freq.put("\u0435\u0437\u0434", 396);
    freq.put("\u0446\u0440", 866);
    freq.put("\u043b\u043a\u0430", 359);
    freq.put("\u0446\u0443", 450);
    freq.put("\u0438\u0446\u0430", 1798);
    freq.put("m ", 843);
    freq.put("\u043a\u0435\u0434", 3751);
    freq.put("\u0430\u043c ", 781);
    freq.put(" \u0444\u0443", 590);
    freq.put(" \u0444\u0440", 608);
    freq.put("\u0438\u0435 ", 1909);
    freq.put("\u0443\u0436\u043d", 805);
    freq.put("\u0438\u0434\u0435", 991);
    freq.put(" \u0444\u043e", 1103);
    freq.put(" \u0444\u0438", 1284);
    freq.put(" \u0444\u0435", 667);
    freq.put(" \u0444\u0430", 744);
    freq.put("me", 447);
    freq.put("\u043b\u043a\u0443", 522);
    freq.put("\u0413\u0440", 1204);
    freq.put("ma", 512);
    freq.put("\u0441\u0432\u0435", 1266);
    freq.put("\u0446\u0438", 13250);
    freq.put("\u041e\u043f", 470);
    freq.put("\u0446\u043d", 316);
    freq.put("\u0441\u0432\u043e", 1166);
    freq.put("\u043f\u043e\u0434", 1948);
    freq.put("\u0443\u043c\u0435", 785);
    freq.put("\u0433\u0301\u0443", 1282);
    freq.put("\u0435\u045a\u0435", 1370);
    freq.put("\u0438\u0440", 7402);
    freq.put("\u0412\u0435", 686);
    freq.put("\u0412\u0430", 687);
    freq.put("\u0412\u043e", 1671);
    freq.put("\u0412\u0438", 848);
    freq.put("\u043c ", 4019);
    freq.put("\u0430\u0430\u0442", 3002);
    freq.put("\u0438\u0437\u043c", 698);
    freq.put("\u0438\u0437\u0438", 1398);
    freq.put("\u041f\u0438", 295);
    freq.put("\u0438\u0437\u0434", 435);
    freq.put("\u0438\u0437\u0432", 1007);
    freq.put("\u0438\u0437\u0433", 666);
    freq.put("\u0438\u0437\u0430", 1563);
    freq.put("\u0438\u0437\u0431", 296);
    freq.put(" \u043b\u0430", 991);
    freq.put("\u0430\u043b\u0431", 313);
    freq.put("\u0421\u043a\u043e", 700);
    freq.put("A", 1208);
    freq.put("II ", 332);
    freq.put("\u0459", 298);
    freq.put("\u0430\u043e\u0433\u0301", 2290);
    freq.put("\u0430\u043b\u0438", 3092);
    freq.put("\u0438\u0437\u0440", 316);
    freq.put("\u041f\u0440", 1600);
    freq.put("\u0420\u0430", 521);
    freq.put(" \u043c\u0443", 1023);
    freq.put("\u0437\u0440\u0430", 561);
    freq.put("\u0440\u043e\u0458", 2600);
    freq.put("\u0438\u0442\u0435", 15877);
    freq.put("\u0440\u043e\u0441", 834);
    freq.put("\u0440\u043e\u0442", 1919);
    freq.put("\u0440\u043e\u0444", 371);
    freq.put("\u0440\u043e\u0446", 373);
    freq.put("\u03c1", 335);
    freq.put("\u0440\u043e\u0438", 701);
    freq.put("\u0440\u043e\u043b", 306);
    freq.put("\u0440\u043e\u043a", 621);
    freq.put("\u0440\u043e\u043d", 752);
    freq.put("\u0444", 11418);
    freq.put("\u0440\u043e\u043f", 944);
    freq.put("\u043e\u0433\u0301\u0430", 2306);
    freq.put("\u0440\u043e\u0433", 438);
    freq.put("\u0440\u043e\u0432", 2202);
    freq.put("\u0440\u043e\u0434", 3344);
    freq.put("\u0440\u043e\u0437", 340);
    freq.put("\u0433\u043e ", 2513);
    freq.put(" \u0412\u0438", 845);
    freq.put(" \u043d\u0435", 4874);
    freq.put(" \u043d\u0430", 43543);
    freq.put("\u0430\u0447 ", 549);
    freq.put(" \u043d\u043e", 1774);
    freq.put(" \u043d\u0438", 1307);
    freq.put("l", 4802);
    freq.put("\u0448\u0430\u043d", 341);
    freq.put("\u0440\u0430\u045a", 570);
    freq.put("\u0440\u0430\u0458", 718);
    freq.put("\u0440\u0430\u0442", 2616);
    freq.put("\u0440\u0430\u0441", 1293);
    freq.put("\u0440\u0430\u0447", 346);
    freq.put("\u0440\u0430\u0446", 462);
    freq.put("\u0440\u0430\u0444", 696);
    freq.put("rt", 285);
    freq.put("\u043e\u043c\u0430", 1343);
    freq.put("\u043e\u043c\u0435", 1683);
    freq.put("\u043e\u043c\u0438", 891);
    freq.put("\u043e\u043c\u043d", 415);
    freq.put("\u043e\u043c\u043f", 789);
    freq.put("\u043e\u043c\u043e", 661);
    freq.put("\u0433\u0430\u0448", 492);
    freq.put("re", 789);
    freq.put("\u0445\u043e", 1598);
    freq.put("ra", 861);
    freq.put("\u0433\u0430\u0440", 1072);
    freq.put("\u0442\u0438\u0440", 892);
    freq.put("\u0433\u0430\u0442", 448);
    freq.put("ro", 643);
    freq.put("ri", 940);
    freq.put("\u0442\u0438\u0447", 2394);
    freq.put("\u0442\u0438\u043b", 553);
    freq.put("\u0433\u0430\u043b", 357);
    freq.put("\u0424\u0438\u043b", 384);
    freq.put("\u0433\u0430\u043d", 1283);
    freq.put("\u0442\u0438\u043f", 307);
    freq.put("\u0442\u0438\u043e", 463);
    freq.put("\u0442\u0438\u0432", 1778);
    freq.put("\u041a ", 292);
    freq.put("\u0415\u0433", 326);
    freq.put("W", 350);
    freq.put("\u0415\u0432", 564);
    freq.put("\u0440\u0430\u0432", 1584);
    freq.put("\u0440\u0430\u0431", 909);
    freq.put("\u0440\u0430\u0430", 405);
    freq.put("\u0440\u0430\u0437", 2373);
    freq.put("\u0440\u0430\u0434", 4624);
    freq.put("\u0440\u0430\u043b", 1971);
    freq.put("\u0440\u0430\u043a", 1026);
    freq.put("\u0440\u0430\u0438", 514);
    freq.put("\u0440\u0430\u043f", 368);
    freq.put("\u0440\u0430\u043d", 5737);
    freq.put("\u0440\u0430\u043c", 1207);
    freq.put("r ", 882);
    freq.put("\u0431\u0458\u0435", 284);
    freq.put(" \u0421\u0410", 357);
    freq.put("\u0434\u0435 ", 1153);
    freq.put("\u041a", 6325);
    freq.put("\u0422\u043e", 1430);
    freq.put("\u043c\u043e\u043d", 609);
    freq.put("\u0437\u043b\u0438", 625);
    freq.put("\u043c\u043e\u0434", 313);
    freq.put("\u0443\u0447\u0443", 537);
    freq.put("\u043c\u043e\u0436", 942);
    freq.put("\u0424\u0440", 445);
    freq.put("\u0458\u043a", 379);
    freq.put("\u0458\u0438", 475);
    freq.put("\u0437\u0435\u0440", 453);
    freq.put("\u0458\u043e", 1613);
    freq.put("\u0458\u043f", 396);
    freq.put("\u0458\u043c", 402);
    freq.put("\u0420\u0438\u043c", 340);
    freq.put("\u0458\u0432", 456);
    freq.put("\u0458\u0433", 710);
    freq.put("\u0458\u0430", 31927);
    freq.put(" \u0421\u043b", 373);
    freq.put("\u0458\u0437", 570);
    freq.put("\u0458\u0434", 458);
    freq.put("\u0458\u0435", 1464);
    freq.put("\u0435\u0436\u0438", 423);
    freq.put(" \u0421\u0442", 843);
    freq.put("B", 839);
    freq.put("\u0458\u0443", 2500);
    freq.put("\u0458\u0441", 1508);
    freq.put("\u0458\u0447", 415);
    freq.put("\u0437\u0435\u043d", 322);
    freq.put("\u0437\u0435\u043c", 1002);
    freq.put("\u0443\u0447\u0438", 444);
    freq.put("\u0443\u0447\u043d", 321);
    freq.put("\u0458\u043a\u0301", 588);
    freq.put("\u043b\u043d\u0430", 1254);
    freq.put("\u043b\u043d\u043e", 1301);
    freq.put("\u045a", 6876);
    freq.put("\u0443\u0447\u0435", 651);
    freq.put("\u043c\u043e\u0440", 627);
    freq.put("\u043c\u043e\u0442", 1353);
    freq.put("\u0430\u043d ", 3695);
    freq.put("\u043a\u0432\u0430", 1424);
    freq.put("\u043a\u0432\u0438", 345);
    freq.put("\u0441\u0443\u0432", 590);
    freq.put("\u0430\u043f\u0440", 517);
    freq.put("\u0430\u043f\u0441", 423);
    freq.put("\u0458\u0430\u043b", 1511);
    freq.put(" \u0445\u043e", 304);
    freq.put("\u0438\u0438 ", 1591);
    freq.put(" \u0445\u0438", 314);
    freq.put("\u0458\u0430\u043d", 1997);
    freq.put(" \u0445\u0435", 609);
    freq.put("\u0458\u0430\u0437", 2727);
    freq.put("\u0458\u0430\u0434", 290);
    freq.put("\u0441 ", 3798);
    freq.put(" \u041a\u0440", 732);
    freq.put(" \u041a\u0443", 462);
    freq.put("\u0417\u0435", 393);
    freq.put("\u0417\u0430", 893);
    freq.put(" \u0417\u0430", 893);
    freq.put("\u0445", 6666);
    freq.put("\u0433\u0438\u0442", 546);
    freq.put("\u0432\u0430 ", 8865);
    freq.put("\u0422\u043e\u0458", 871);
    freq.put(" \u041a\u0438", 514);
    freq.put(" \u041a\u043b", 294);
    freq.put(" \u041a\u0430", 1843);
    freq.put("\u0458\u0430\u0442", 4096);
    freq.put(" \u0445\u0440", 549);
    freq.put("\u0430\u043f\u043e", 665);
    freq.put("\u0430\u043f\u0438", 499);
    freq.put("\u0430\u043f\u0430", 1524);
    freq.put("\u0442\u043d\u0430", 541);
    freq.put("\u0420\u0435\u043f", 976);
    freq.put("\u043b\u0443\u0446", 507);
    freq.put("\u0430\u0458\u043a\u0301", 358);
    freq.put("\u0442\u043d\u0438", 1408);
    freq.put("\u0442\u043d\u043e", 744);
    freq.put("d ", 868);
    freq.put("\u043f\u0458\u0435", 616);
    freq.put("\u0430\u0458\u0441", 402);
    freq.put("\u0430\u0458\u0447", 379);
    freq.put("\u0435\u0440\u043e", 1509);
    freq.put("\u0447\u0435\u0442", 714);
    freq.put("\u0435\u0440\u043c", 1219);
    freq.put("\u0435\u0440\u043d", 1475);
    freq.put("\u0435\u0440\u043a", 320);
    freq.put("\u0435\u0440\u0438", 4408);
    freq.put("\u0435\u0440\u0437", 406);
    freq.put("\u043f\u043e ", 1690);
    freq.put("\u0435\u0440\u0435", 664);
    freq.put("\u0435\u0440\u0430", 2000);
    freq.put("\u0441\u043e\u0446", 292);
    freq.put("\u0441\u043e\u0447", 283);
    freq.put("\u0441\u043e\u0441", 874);
    freq.put("\u0441\u043e\u0442", 388);
    freq.put("\u0430\u0446\u0438", 3529);
    freq.put("\u0447\u043b\u0435", 406);
    freq.put("\u0441\u043e\u0434", 296);
    freq.put("\u0440", 143160);
    freq.put("\u0441\u043e\u0437", 452);
    freq.put("\u0441\u043e\u0431", 473);
    freq.put("\u0441\u043e\u0432", 600);
    freq.put("di", 400);
    freq.put("\u0441\u043e\u043d", 314);
    freq.put("de", 624);
    freq.put("\u0441\u043e\u043a", 602);
    freq.put("da", 295);
    freq.put("\u0447\u0435\u0432", 319);
    freq.put("X", 347);
    freq.put("\u0447\u0435\u043d", 1330);
    freq.put("\u0435\u0440\u0441", 707);
    freq.put("\u0446\u0438\u0440", 340);
    freq.put("\u0430\u0458\u043f", 372);
    freq.put("\u0430\u0458\u043d", 658);
    freq.put("\u0430\u0458\u043c", 316);
    freq.put("\u0430\u0458\u0433", 681);
    freq.put("\u0430\u0458\u0430", 393);
    freq.put("\u0430\u0458\u0434", 338);
    freq.put("\u043a\u0301\u0435 ", 750);
    freq.put("\u043a\u0440\u0443", 671);
    freq.put("\u0443\u0442\u0435", 298);
    freq.put(" \u0414\u043e", 561);
    freq.put("\u043b\u0438\u043a", 2508);
    freq.put("\u043b\u0438\u043c", 882);
    freq.put("\u043b\u0438\u043d", 1340);
    freq.put(" \u0442\u0443", 815);
    freq.put("\u043b\u0438\u043f", 313);
    freq.put("\u043b\u0438\u0432", 613);
    freq.put("\u0430\u0448 ", 464);
    freq.put("\u0413\u0435", 525);
    freq.put("\u043b\u0438\u0437", 933);
    freq.put("\u043d\u0430 ", 51854);
    freq.put("\u043b\u0438\u0458", 1726);
    freq.put("C", 1276);
    freq.put("\u0443\u0434\u0430", 547);
    freq.put("\u0443\u0434\u0431", 322);
    freq.put("\u0443\u0434\u0438", 328);
    freq.put(" \u0442\u0435", 3329);
    freq.put("\u0455\u0432\u0435", 297);
    freq.put(" \u0442\u0430", 1317);
    freq.put(" \u0442\u0432", 438);
    freq.put("\u043b\u0438\u0441", 1550);
    freq.put("\u043b\u0438\u0442", 1817);
    freq.put(" \u0442\u043e", 1808);
    freq.put("\u043b\u0438\u0444", 510);
    freq.put(" \u0442\u0438", 832);
    freq.put("\u043b\u0438\u0446", 678);
    freq.put("\u043b\u0438\u0447", 1268);
    freq.put("\u0458\u043d\u0438", 502);
    freq.put("\u0446\u0430\u0440", 343);
    freq.put("\u0446\u0430\u0442", 333);
    freq.put("\u0458\u043d\u0430", 646);
    freq.put("\u043a\u0440\u0438", 723);
    freq.put("\u0437\u0438 ", 329);
    freq.put("\u043a\u0440\u043e", 310);
    freq.put("\u043a\u0440\u0430", 1871);
    freq.put("\u0443\u0440\u0438", 529);
    freq.put("\u043a\u0440\u0435", 290);
    freq.put("\u0435\u043a\u0301\u0435", 715);
    freq.put(" \u0417\u0435", 393);
    freq.put("\u043f ", 907);
    freq.put("\u0416", 390);
    freq.put("\u0435\u0437 ", 342);
    freq.put("\u0430\u0440\u0443", 298);
    freq.put("\u0438\u0435\u043d", 500);
    freq.put("\u0430\u043c\u0435", 1650);
    freq.put("\u0442\u0430\u043f", 396);
    freq.put("\u0430\u043c\u0430", 619);
    freq.put("\u0430\u043c\u043e", 926);
    freq.put("\u0430\u043c\u0438", 1203);
    freq.put("\u0410\u0414 ", 331);
    freq.put("\u03b9", 356);
    freq.put("\u0448\u0438\u0440", 378);
    freq.put("\u0438\u0435\u0440", 283);
    freq.put("\u0438\u0435\u0442", 479);
    freq.put("\u0438\u045a\u0430", 474);
    freq.put("n", 6781);
    freq.put("\u0446 ", 857);
    freq.put("\u0430\u045a\u0435", 3967);
    freq.put("\u0447\u043d\u0430", 1312);
    freq.put("\u043c\u0435", 13316);
    freq.put("\u043c\u0432", 986);
    freq.put("\u043c\u0430", 12609);
    freq.put("\u043c\u0431", 886);
    freq.put("\u043c\u043e", 6592);
    freq.put("\u043c\u043f", 2215);
    freq.put("is", 934);
    freq.put("\u043c\u043d", 1816);
    freq.put("it", 584);
    freq.put("\u043c\u0438", 7979);
    freq.put(" \u043b\u0443", 423);
    freq.put("\u0447\u043d\u0438", 1436);
    freq.put("il", 394);
    freq.put("io", 670);
    freq.put("in", 1115);
    freq.put("ia", 681);
    freq.put("ic", 719);
    freq.put("ie", 315);
    freq.put("id", 295);
    freq.put("\u0410\u043d", 848);
    freq.put("\u0415\u0440", 317);
    freq.put("\u0438\u0437 ", 417);
    freq.put("\u0441", 124190);
    freq.put("\u0430\u0430 ", 1364);
    freq.put("\u043a\u043d", 889);
    freq.put("\u03c4", 303);
    freq.put("\u0440\u043c\u0430", 1504);
    freq.put("\u0446\u0430", 2399);
    freq.put("\u0440\u043c\u0438", 912);
    freq.put("i ", 786);
    freq.put("\u043a\u043e", 29166);
    freq.put(" \u043b\u0435", 768);
    freq.put(" \u043b\u0438", 1394);
    freq.put(" \u043b\u043e", 957);
    freq.put("\u043c\u0458", 1034);
    freq.put("\u043c\u0443", 1844);
    freq.put("\u043c\u0440", 516);
    freq.put("\u043c\u0441", 1507);
    freq.put("the", 294);
    freq.put("\u0430\u0447\u0443", 385);
    freq.put("\u0433\u043e\u0442", 553);
    freq.put("\u0433\u043e\u0440", 505);
    freq.put("\u0433\u043e\u0434", 3338);
    freq.put("\u0433\u0301\u0430", 3178);
    freq.put("\u0433\u043e\u0432", 1806);
    freq.put("D", 603);
    freq.put("\u0442\u043a\u0430", 575);
    freq.put("\u0442\u043a\u043e", 341);
    freq.put("\u0433\u043e\u043b", 2184);
    freq.put("\u0442\u043a\u0438", 324);
    freq.put("\u0433\u0301\u0435", 418);
    freq.put("\u0440\u043e ", 695);
    freq.put("\u0447\u043a\u043e", 656);
    freq.put("\u0430\u0447\u0435", 347);
    freq.put("\u0430\u0447\u0430", 344);
    freq.put("\u043a\u043b", 2271);
    freq.put("\u0430\u0447\u043a", 640);
    freq.put("\u0430\u0447\u0438", 1031);
    freq.put("\u0441\u043d\u0438", 929);
    freq.put("\u0441\u043d\u043e", 1836);
    freq.put("\u0441\u043d\u0430", 721);
    freq.put("\u0417", 1960);
    freq.put("\u0431\u043e\u0440", 1569);
    freq.put("\u041b\u0430", 558);
    freq.put("\u041b\u0435", 628);
    freq.put("\u041b\u0438", 491);
    freq.put("\u041b\u043e", 317);
    freq.put("\u0443\u0433\u0301\u0435", 382);
    freq.put("\u0447\u043a\u0438", 2688);
    freq.put("\u041b\u0443", 312);
    freq.put("\u0433\u0430 ", 1478);
    freq.put("\u0442\u0438 ", 4039);
    freq.put("\u0458\u0435\u043a", 289);
    freq.put("\u0437\u0435", 2250);
    freq.put("o", 7437);
    freq.put("\u0440\u0430 ", 3142);
    freq.put("\u0447\u043a\u0430", 1890);
    freq.put("\u0437\u0433", 962);
    freq.put("\u0437\u0430\u043c", 529);
    freq.put("\u0434\u0435\u043a", 1195);
    freq.put("\u0434\u0435\u043b", 3411);
    freq.put("\u0434\u0435\u043c", 341);
    freq.put("\u0434\u0435\u043d", 5845);
    freq.put("\u0430\u043d\u0442", 1418);
    freq.put("\u0430\u043d\u0443", 570);
    freq.put("\u0446\u0438\u043e", 1351);
    freq.put(" \u0443\u043f", 512);
    freq.put(" \u0443\u043c", 454);
    freq.put(" \u0443\u043d", 383);
    freq.put("\u0446\u0438\u0438", 969);
    freq.put("\u0448\u043d\u0430", 496);
    freq.put("\u0458 ", 8902);
    freq.put("\u0422\u0430\u0430", 318);
    freq.put("\u043a\u0441\u0438", 508);
    freq.put("er ", 422);
    freq.put("\u0437\u0438", 7831);
    freq.put("\u043c\u043e ", 748);
    freq.put("\u043a\u0441\u0430", 284);
    freq.put("\u0442", 178546);
    freq.put("\u043a\u0441\u0442", 341);
    freq.put("\u0437\u0430\u0432", 514);
    freq.put(" \u0418\u043d", 570);
    freq.put(" \u0418\u043c", 496);
    freq.put(" \u0418\u0437", 327);
    freq.put("\u0434\u0435\u0458", 478);
    freq.put(" \u0443\u0448", 328);
    freq.put("\u0458\u043e\u0442", 1205);
    freq.put(" \u0443\u0441", 533);
    freq.put("\u0438\u0436\u0435", 402);
    freq.put(" \u0443\u0447", 625);
    freq.put("\u0430\u043d\u0434", 1155);
    freq.put("\u0430\u043d\u0435", 747);
    freq.put("\u043c\u0435\u0433\u0301", 1150);
    freq.put("\u0430\u043d\u0430", 3750);
    freq.put("\u0430\u043d\u0433", 1211);
    freq.put("\u0434\u0435\u0440", 607);
    freq.put("\u0434\u0435\u0441", 441);
    freq.put("\u0430\u043d\u043e", 1527);
    freq.put("\u0430\u043d\u0438", 6541);
    freq.put("\u0430\u043d\u043a", 497);
    freq.put("\u0458\u0430 ", 19199);
    freq.put("\u041a\u0440", 735);
    freq.put("\u041a\u0443", 463);
    freq.put("ni", 597);
    freq.put("\u0445\u0438\u0442", 310);
    freq.put("\u0432\u0430\u0458", 507);
    freq.put("\u0432\u0430\u045a", 3265);
    freq.put("nd", 628);
    freq.put("ne", 472);
    freq.put("ng", 429);
    freq.put("\u0432\u0430\u0440", 956);
    freq.put("\u0432\u0430\u0442", 2229);
    freq.put("\u0441\u0435", 20196);
    freq.put("\u0432\u0430\u0447", 868);
    freq.put("\u0441\u0438", 5941);
    freq.put("\u0441\u043b", 4921);
    freq.put("\u0441\u043a", 26715);
    freq.put("nt", 684);
    freq.put("\u0441\u043c", 1616);
    freq.put("\u0441\u043f", 3213);
    freq.put("\u0441\u043e", 11740);
    freq.put("\u0432\u0430\u0430", 2386);
    freq.put("\u0431\u0440\u0438", 330);
    freq.put("\u0441\u0442", 32059);
    freq.put("\u0431\u0440\u043e", 2687);
    freq.put("\u0441\u0446", 293);
    freq.put("\u0431\u0440\u0430", 1074);
    freq.put("\u0432\u0430\u043d", 1597);
    freq.put("\u0431\u0440\u0435", 488);
    freq.put("n ", 1564);
    freq.put("es ", 384);
    freq.put("\u0438\u0438\u0442", 454);
    freq.put("\u041a\u043e", 1594);
    freq.put("\u041a\u0438", 516);
    freq.put("\u041a\u043b", 294);
    freq.put("\u041a\u0430", 1846);
    freq.put("\u043a\u043e\u0433", 686);
    freq.put("\u043a\u043e\u0432", 1275);
    freq.put(" \u0447\u0435", 954);
    freq.put("\u043a\u043e\u0435", 689);
    freq.put(" \u0447\u043e", 400);
    freq.put("\u0408", 1691);
    freq.put("V", 551);
    freq.put("\u043a\u043e\u043f", 1132);
    freq.put(" \u0447\u043b", 393);
    freq.put(" \u0447\u0438", 499);
    freq.put("\u043a\u043e\u043c", 1394);
    freq.put("\u0438\u043a ", 3740);
    freq.put("\u0447\u0435", 4695);
    freq.put("\u0447\u0430", 1926);
    freq.put("\u0447\u043e", 686);
    freq.put("\u0447\u043d", 4154);
    freq.put("\u0447\u043b", 414);
    freq.put("\u0447\u043a", 5243);
    freq.put("\u0447\u0438", 3265);
    freq.put("\u0435\u0434\u0430", 979);
    freq.put("\u0435\u0434\u0435", 2597);
    freq.put("\u0435\u0434\u0438", 2433);
    freq.put("\u0435\u0434\u043e", 4194);
    freq.put("\u0435\u0434\u043d", 3441);
    freq.put("\u0435\u0434\u0443", 826);
    freq.put(" \u041c\u0435", 823);
    freq.put(" \u041c\u0430", 3825);
    freq.put("\u0448", 16654);
    freq.put("\u043e\u0442 ", 21175);
    freq.put(" \u041c\u0438", 780);
    freq.put("\u0447\u0443", 1362);
    freq.put("\u043d ", 18349);
    freq.put("\u0432\u043e ", 22199);
    freq.put("\u0446\u0435", 3069);
    freq.put("\u043a\u043e\u0458", 5826);
    freq.put("p", 1803);
    freq.put("\u043b\u0431\u0430", 979);
    freq.put("\u0434\u0431\u0430", 505);
    freq.put("\u0438\u043c\u043f", 928);
    freq.put("\u0438\u043c\u043e", 452);
    freq.put("\u0438\u043c\u0438", 494);
    freq.put("\u0438\u043c\u0435", 2091);
    freq.put("\u0438\u043c\u0430", 2023);
    freq.put("\u0430\u0433\u043e", 607);
    freq.put("\u0433\u0443", 1829);
    freq.put("\u0430\u0433\u0430", 381);
    freq.put("\u0433\u0440", 9052);
    freq.put("\u0443\u043d\u043a", 323);
    freq.put("\u043b\u0443\u0432", 419);
    freq.put("\u043f\u0438 ", 325);
    freq.put("\u043e\u0440\u0443", 832);
    freq.put("\u043e\u0440\u0442", 556);
    freq.put("\u0426\u0440", 465);
    freq.put("\u0433", 42718);
    freq.put("\u0424\u0440\u0430", 322);
    freq.put("\u0438\u0441\u0442", 8007);
    freq.put("\u0438\u0441\u0438", 462);
    freq.put("\u0438\u0441\u043a", 3494);
    freq.put("\u0438\u0441\u043b", 520);
    freq.put("Ma", 323);
    freq.put("\u0438\u0441\u043d", 402);
    freq.put("\u043b\u0443\u0433\u0301", 365);
    freq.put(" \u0413\u043b", 341);
    freq.put("\u0438\u0441\u0430", 487);
    freq.put("\u0438\u0441\u0435", 361);
    freq.put("\u043e\u0440\u043d", 663);
    freq.put("\u043e\u0440\u043c", 1326);
    freq.put("\u043b\u0443\u0447", 790);
    freq.put("\u0410\u043b\u0431", 429);
    freq.put("\u043e\u0440\u0438", 3831);
    freq.put("\u043e\u0440\u0435", 2005);
    freq.put("\u043e\u0440\u0434", 482);
    freq.put("\u0421\u0440\u0431", 287);
    freq.put("\u043e\u0440\u0430", 1582);
    freq.put("\u043e\u0440\u0433", 1108);
    freq.put("\u0433\u043b", 3601);
    freq.put("\u0433\u0438", 5000);
    freq.put("\u0410\u0414", 338);
    freq.put("\u0433\u043d", 490);
    freq.put("\u0430\u0433\u0440", 309);
    freq.put("\u0433\u0430", 5709);
    freq.put("\u0433\u0435", 2417);
    freq.put("\u043e\u043d ", 2167);
    freq.put(" \u0413\u0430", 384);
    freq.put("\u0438\u043c\u0441", 590);
    freq.put("tio", 345);
    freq.put("\u043e\u0433\u0440", 1093);
    freq.put("\u043e\u0433\u0443", 753);
    freq.put("\u041e", 4503);
    freq.put("\u043d\u0444", 376);
    freq.put(" \u0432\u0440", 2219);
    freq.put(" \u0432\u0442", 300);
    freq.put("\u043d\u043e ", 8706);
    freq.put(" \u0432\u0435", 1999);
    freq.put(" \u0432\u0430", 516);
    freq.put("F", 432);
    freq.put("\u043d\u0442", 6041);
    freq.put(" \u0432\u0438", 1958);
    freq.put(" \u0432\u043b", 994);
    freq.put(" \u0432\u043a", 456);
    freq.put("\u043e\u0433\u0438", 878);
    freq.put("\u0443\u0431\u043b", 1212);
    freq.put("\u043e\u0433\u043b", 313);
    freq.put("\u043e\u0433\u043e", 815);
    freq.put("\u043e\u0433\u0430", 1201);
    freq.put(" \u0458\u0443", 1544);
    freq.put("\u043d\u0435", 10732);
    freq.put("\u0433\u0435\u0440", 583);
    freq.put(" \u0424\u0440", 445);
    freq.put("\u0437\u0443\u0432", 311);
    freq.put("\u0444\u0440\u0430", 515);
    freq.put("\u0441\u0442 ", 3322);
    freq.put("\u0440\u0433\u0430", 1142);
    freq.put("s ", 2376);
    freq.put("\u041f\u043e", 1730);
    freq.put("\u043f\u043b", 2009);
    freq.put(" o ", 369);
    freq.put("\u043d\u043b", 307);
    freq.put("\u043d\u043a", 1682);
    freq.put("\u0458\u0441\u0442", 589);
    freq.put("\u043e\u0442\u043a", 367);
    freq.put("\u0435\u0431\u0435", 337);
    freq.put("\u0411\u0435\u043b", 406);
    freq.put("st", 673);
    freq.put("si", 446);
    freq.put("\u0435\u0458 ", 342);
    freq.put(" \u0424\u0438", 520);
    freq.put("\u0433\u0435\u043e", 440);
    freq.put("\u0441\u0430 ", 460);
    freq.put("\u0446\u0438\u0442", 991);
    freq.put("\u041f\u0435", 965);
    freq.put("se", 302);
    freq.put("\u0443\u0437\u0438", 649);
    freq.put("\u0430\u043d\u0446", 867);
    freq.put("\u0432\u0443\u0432", 2038);
    freq.put("\u043b\u043e\u043c", 349);
    freq.put("\u043b\u043e\u043d", 478);
    freq.put("\u043b\u043e\u043a", 568);
    freq.put("\u043b\u043e\u0436", 284);
    freq.put("\u041f\u0430", 998);
    freq.put("\u043b\u043e\u0432", 1561);
    freq.put("\u043b\u043e\u0433", 1288);
    freq.put("\u043b\u043e\u0431", 414);
    freq.put("\u0442\u0435\u043a", 1487);
    freq.put("\u0442\u0435\u043b", 2805);
    freq.put("\u0458\u0441\u043a", 745);
    freq.put("\u0442\u0435\u043e", 301);
    freq.put("\u0442\u0435\u043c", 1441);
    freq.put("\u0434\u0430 ", 4123);
    freq.put(" \u043f", 36928);
    freq.put("\u03b1", 455);
    freq.put("\u0435\u0448\u0435", 584);
    freq.put("\u0434", 90920);
    freq.put(" \u0448\u0442", 2822);
    freq.put("\u0435\u0448\u043d", 741);
    freq.put("\u0435\u0448\u043a", 443);
    freq.put("\u0440\u0442\u0438", 754);
    freq.put("\u0441\u0440\u0435", 870);
    freq.put("\u0435\u0448\u0442", 455);
    freq.put("\u0430\u0432 ", 328);
    freq.put("\u0458\u0433\u043e", 612);
    freq.put(" \u0448\u0435", 287);
    freq.put("\u0442\u0435\u0442", 1279);
    freq.put("\u0438\u043b ", 3300);
    freq.put("\u0442\u0435\u0441", 476);
    freq.put("\u0442 ", 35867);
    freq.put("\u043b\u043e\u0448", 669);
    freq.put("\u043b\u043e\u0442", 1377);
    freq.put("\u0425\u0440", 339);
    freq.put("\u043b\u043e\u0441", 414);
    freq.put("\u0435\u0433\u0430", 454);
    freq.put("\u0435\u0433\u043e", 1463);
    freq.put("\u0435\u0433\u0438", 839);
    freq.put("el", 544);
    freq.put("en", 923);
    freq.put(" \u041d\u0430", 1547);
    freq.put("ed", 390);
    freq.put(" \u041d\u043e", 521);
    freq.put("ea", 411);
    freq.put("\u0438\u043a", 11472);
    freq.put("\u0438\u043b", 14255);
    freq.put("\u0438\u0438", 2086);
    freq.put("\u0438\u043e", 12982);
    freq.put("\u0438\u043f", 1917);
    freq.put("\u0438\u043c", 7924);
    freq.put("\u0438\u043d", 21871);
    freq.put("\u0438\u0432", 6555);
    freq.put("et", 387);
    freq.put("\u0438\u0430", 334);
    freq.put("\u0438\u0440 ", 506);
    freq.put("\u0438\u0436", 639);
    freq.put("\u0438\u0437", 7830);
    freq.put("\u041f", 6311);
    freq.put("er", 1600);
    freq.put("\u0438\u0446\u0438", 3395);
    freq.put("\u0410\u0440", 692);
    freq.put("\u0430\u0434\u0440", 313);
    freq.put("\u0434\u0432\u0438", 611);
    freq.put("\u043b\u0430\u0432", 1747);
    freq.put("\u043b\u0430\u0433", 370);
    freq.put("\u043b\u0430\u0434", 919);
    freq.put("\u0434\u0432\u043e", 453);
    freq.put("\u0434\u0432\u0430", 530);
    freq.put("\u0438\u043d\u0446", 810);
    freq.put("\u0434\u0432\u0435", 568);
    freq.put("\u043b\u0430\u043d", 1512);
    freq.put("\u0438\u043d\u0442", 558);
    freq.put("\u0438\u043d\u0443", 385);
    freq.put("\u043b\u0430\u0440", 497);
    freq.put("\u043b\u0430\u0441", 1834);
    freq.put("\u043b\u0430\u0442", 1878);
    freq.put("\u0438\u043d\u0438", 3140);
    freq.put("G", 577);
    freq.put("\u0438\u043d\u0434", 577);
    freq.put("\u0438\u043d\u0435", 862);
    freq.put("\u0438\u043d\u0430", 9820);
    freq.put("e ", 2587);
    freq.put("\u0438\u043d\u0433", 507);
    freq.put("\u0430\u0434\u043e", 1542);
    freq.put("\u0430\u0434\u043d", 1034);
    freq.put("\u0430\u0434\u043c", 285);
    freq.put("\u0430\u0434\u0438", 1566);
    freq.put("\u0430\u0434\u0435", 2265);
    freq.put("\u0434\u043c\u0438", 387);
    freq.put("\u045f", 1064);
    freq.put("\u0430\u0434\u0430", 949);
    freq.put("\u0438\u0448", 2058);
    freq.put("\u0443\u043c\u0438", 352);
    freq.put("\u0438\u0442", 22205);
    freq.put("\u0438\u0443", 361);
    freq.put("\u043b\u0442\u0430", 406);
    freq.put("\u0438\u0441", 15994);
    freq.put("\u0438\u0446", 5454);
    freq.put("\u0438\u0447", 7399);
    freq.put("\u0438\u0444", 1198);
    freq.put("\u0438\u0445", 496);
    freq.put("\u0438\u045a", 534);
    freq.put("\u0438\u0458", 21371);
    freq.put(" \u0418\u0441", 742);
    freq.put("\u043e\u0441\u0432", 433);
    freq.put("\u0438\u0442\u043e", 1415);
    freq.put("\u0438\u0442\u0438", 1229);
    freq.put("\u043e\u0441\u0435", 641);
    freq.put("\u043e\u0441\u043a", 407);
    freq.put("\u043e\u0441\u043b", 1286);
    freq.put("\u043e\u0441\u0438", 467);
    freq.put("\u043e\u0441\u043e", 623);
    freq.put("\u0438\u0442\u0430", 1364);
    freq.put("\u043e\u0441\u043d", 1425);
    freq.put("\u0410\u043c\u0435", 307);
    freq.put("\u043f\u0435\u0442", 425);
    freq.put("\u043f\u0435\u0441", 307);
    freq.put("\u043f\u0435\u0440", 1862);
    freq.put("\u0431\u0438 ", 515);
    freq.put("\u0436\u0435 ", 578);
    freq.put("\u0444\u0438\u0458", 319);
    freq.put("\u043e\u0432 ", 1440);
    freq.put(" \u0412\u0435", 685);
    freq.put("on ", 498);
    freq.put("\u043a\u0301\u0430 ", 348);
    freq.put(" \u0421\u0435", 1778);
    freq.put("\u0443\u0433\u0430", 1084);
    freq.put("\u0420\u0443\u0441", 402);
    freq.put("ia ", 314);
    freq.put("\u043e\u0441\u0442", 6452);
    freq.put("\u0432\u043d\u0430", 1234);
    freq.put("r", 6845);
    freq.put("\u0440\u0432 ", 449);
    freq.put("\u0432\u043d\u0438", 1914);
    freq.put("\u0432\u043d\u043e", 1024);
    freq.put("\u0438\u0442\u0443", 775);
    freq.put("and", 335);
    freq.put(" \u0433\u043b", 1761);
    freq.put(" \u0433\u0438", 1230);
    freq.put(" \u0433\u043e", 6416);
    freq.put("\u043c\u0438 ", 1067);
    freq.put(" \u0433\u0435", 1159);
    freq.put("\u0444\u0438\u0446", 459);
    freq.put("\u0431\u043e\u0434", 337);
    freq.put("\u0435", 224574);
    freq.put("\u0431\u043e\u043b", 467);
    freq.put("an ", 327);
    freq.put("\u0431\u043e\u0442", 1139);
    freq.put("\u0444\u0441\u043a", 446);
    freq.put("\u0440\u0434\u0438", 936);
    freq.put("\u0440\u0434\u0430", 316);
    freq.put("\u043a\u0430 ", 12158);
    freq.put(" \u0433\u0440", 5370);
    freq.put("\u0431\u0430\u0440", 494);
    freq.put("\u0438\u043a\u0430", 4788);
    freq.put("\u0438\u043a\u043e", 1235);
    freq.put("\u0438\u043a\u0438", 550);
    freq.put("\u043a\u043e ", 6033);
    freq.put("\u0430\u0431\u043e", 1052);
    freq.put("\u0435\u0434 ", 1436);
    freq.put("\u0432\u043e\u0458", 2262);
    freq.put("\u0443\u043b\u0430", 701);
    freq.put(" \u0430\u0442", 297);
    freq.put("\u043b\u0441\u043a", 1346);
    freq.put("\u043e\u0442\u0440", 639);
    freq.put("\u0443\u043b\u0438", 697);
    freq.put("\u0430", 349769);
    freq.put("\u043d\u0447", 293);
    freq.put("\u043d\u0446", 2585);
    freq.put("\u043d\u0441", 10729);
    freq.put("\u043d\u0443", 2258);
    freq.put("\u0447 ", 920);
    freq.put("\u0432\u043e\u0442", 2101);
    freq.put("\u0432\u043e\u0441", 388);
    freq.put("\u0432\u043e\u0440", 1284);
    freq.put("\u0432\u043e\u043b", 822);
    freq.put("\u043d\u0434", 3033);
    freq.put("\u043d\u0437", 408);
    freq.put("\u0432\u043e\u0438", 368);
    freq.put("\u043d\u0431", 290);
    freq.put("\u043d\u0430", 77634);
    freq.put("\u043d\u0433", 2911);
    freq.put("H", 549);
    freq.put("\u043d\u043e", 20747);
    freq.put("\u0432\u043e\u0437", 430);
    freq.put("\u043d\u0438", 34239);
    freq.put("\u0432\u043e\u0435", 499);
    freq.put("\u0432\u043e\u0434", 1487);
    freq.put("\u043b\u0441\u0442", 374);
    freq.put("\u043e\u0442\u0438", 883);
    freq.put("\u043e\u0442\u043e", 5629);
    freq.put("\u043e\u0442\u043d", 448);
    freq.put("\u0443\u043b\u0442", 955);
    freq.put("\u043e\u0442\u0430", 373);
    freq.put("\u043e\u0442\u0435", 1213);
    freq.put("\u0436\u0435", 2514);
    freq.put("\u0438\u043a\u0443", 390);
    freq.put(" \u0421\u043f", 403);
    freq.put("\u043e\u043d\u0446", 377);
    freq.put("\u043e\u043d\u0442", 604);
    freq.put("\u043e\u043d\u0441", 2772);
    freq.put("\u0443\u0440\u0435", 411);
    freq.put(" \u0430\u0437", 335);
    freq.put("\u041b", 2399);
    freq.put("\u0438\u043c ", 736);
    freq.put(" \u043e\u043b", 358);
    freq.put(" \u043e\u043a", 1879);
    freq.put(" \u043e\u043f", 2029);
    freq.put(" \u043e\u0431", 2355);
    freq.put(" \u043e\u0432", 1233);
    freq.put(" \u043e\u0434", 15767);
    freq.put(" \u043e\u0437", 315);
    freq.put("\u043f\u0438\u043d", 286);
    freq.put(" \u0430\u0441", 329);
    freq.put(" \u0430\u0440", 1051);
    freq.put("\u043b\u0443 ", 886);
    freq.put(" \u0430\u0432", 1128);
    freq.put("\u043f\u0438\u0448", 657);
    freq.put("\u0445\u0438", 1138);
    freq.put(" \u0430\u0434", 312);
    freq.put(" \u0430\u043b", 614);
    freq.put(" \u0430\u043a", 630);
    freq.put(" \u0430\u043f", 418);
    freq.put("\u043f\u0438\u0441", 1343);
    freq.put(" \u0430\u043d", 1462);
    freq.put("\u043e\u0440 ", 1906);
    freq.put("\u0438\u0441 ", 533);
    freq.put(" \u043e\u0440", 1315);
    freq.put(" \u0430\u043c", 537);
    freq.put(" \u043e\u0444", 386);
    freq.put("\u043e\u043d\u0435", 1032);
    freq.put("\u043e\u043d\u0433", 566);
    freq.put("\u043e\u043d\u0430", 1646);
    freq.put("\u0440\u0438\u043a", 1477);
    freq.put("\u043e\u043d\u043e", 1647);
    freq.put("\u043e\u043d\u0438", 3271);
    freq.put("s", 5501);
    freq.put("\u0433 ", 2028);
    freq.put(" \u0422\u0440", 451);
    freq.put(" \u0422\u0443", 523);
    freq.put("\u0440\u0438\u043c", 878);
    freq.put(" \u043e\u0441", 2370);
    freq.put("\u041c\u0430\u043a", 2308);
    freq.put(" \u043e\u0442", 647);
    freq.put("\u043d\u043e\u043c", 868);
    freq.put("\u0440\u0431\u0438", 405);
    freq.put("\u043d\u043e\u0432", 2577);
    freq.put("\u043d\u043e\u0433", 889);
    freq.put("\u043d\u043e\u0435", 302);
    freq.put("\u0446\u0443\u0441", 389);
    freq.put("\u0446", 21764);
    freq.put("\u0444\u0438\u043d", 438);
    freq.put("\u0436\u043d", 1527);
    freq.put("\u043c\u043f\u0435", 650);
    freq.put("\u043d\u043e\u0441", 3399);
    freq.put("\u043d\u043e\u0442", 2355);
    freq.put("\u041c\u0435", 823);
    freq.put("\u0448\u043a\u0430", 496);
    freq.put("\u041c\u0430", 3832);
    freq.put("\u041c\u043e", 930);
    freq.put("\u0432\u0438\u0435", 441);
    freq.put("\u041c\u0438", 784);
    freq.put("\u041c\u0430\u0440", 480);
    freq.put(" \u0422\u0435", 689);
    freq.put(" \u0422\u0430", 770);
    freq.put("\u043e\u0433 ", 396);
    freq.put(" \u0422\u043e", 1430);
    freq.put(" \u0422\u0438", 438);
    freq.put("\u0437\u0434\u0430", 948);
    freq.put("\u0425\u043e", 298);
    freq.put("\u0443\u0446\u0438", 681);
    freq.put("\u0435\u0458\u0441", 859);
    freq.put("\u0441\u0430\u0442", 511);
    freq.put("\u0440\u043e\u043c", 966);
    freq.put(" Ma", 317);
    freq.put("\u0431\u0458", 460);
    freq.put("\u0431", 32290);
    freq.put("\u0440\u043e\u0431", 326);
    freq.put("\u0441\u0442\u0432", 3177);
    freq.put(" \u0437\u0435", 866);
    freq.put("\u0441\u0442\u0435", 2303);
    freq.put("\u0441\u0442\u0438", 4708);
    freq.put("I ", 636);
    freq.put("\u0441\u0442\u043e", 6090);
    freq.put("\u0441\u0442\u0440", 4031);
    freq.put(" \u0411\u0430", 927);
    freq.put("\u0441\u0442\u0443", 413);
    freq.put(" \u0446\u0435", 1471);
    freq.put("I", 1773);
    freq.put(" \u0446\u0438", 311);
    freq.put(" \u0437\u0431", 1071);
    freq.put("II", 479);
    freq.put(" \u0411\u0435", 877);
    freq.put("\u0435\u0458\u0437", 450);
    freq.put("\u0441\u0430\u043c", 861);
    freq.put("\u0441\u0430\u043d", 508);
    freq.put("na", 717);
    freq.put(" \u0414\u0430", 437);
    freq.put("\u0442\u0445", 499);
    freq.put(" \u041b\u0430", 557);
    freq.put("\u0434\u0435", 15216);
    freq.put("\u041f\u0430\u0440", 311);
    freq.put("\u0442\u0441", 3837);
    freq.put("\u0442\u0442", 407);
    freq.put("\u0442\u0443", 4071);
    freq.put(" \u041b\u0438", 490);
    freq.put(" \u041b\u043e", 316);
    freq.put("\u043b\u043e ", 2497);
    freq.put(" \u0411\u043e", 736);
    freq.put("\u043d\u0435\u0441", 1333);
    freq.put("\u0418\u0441\u0442", 523);
    freq.put("\u041c", 7265);
    freq.put("\u0440\u0442 ", 589);
    freq.put("\u0430\u0432\u0443", 1675);
    freq.put("\u0430\u0432\u0442", 686);
    freq.put("\u0408\u0430", 560);
    freq.put("\u0434\u0430\u0434", 551);
    freq.put("\u0434\u0430\u0432", 666);
    freq.put("\u0434\u0430\u043d", 444);
    freq.put("\u0434\u0430\u043b", 491);
    freq.put("\u0432\u0435 ", 532);
    freq.put("\u0438\u043b\u0438", 5248);
    freq.put("\u0438\u043b\u043e", 1256);
    freq.put("\u0434\u0430\u0442", 1402);
    freq.put("\u0438\u043b\u043c", 478);
    freq.put("\u0434\u0430\u0440", 782);
    freq.put("\u0438\u043b\u0430", 1963);
    freq.put("\u043d\u0435\u0448", 642);
    freq.put("\u0430\u0432\u0435", 1404);
    freq.put("\u0448\u043a\u0438", 805);
    freq.put("\u0430\u0432\u0430", 2546);
    freq.put("\u0430\u0432\u043d", 1461);
    freq.put("\u0408\u0443", 674);
    freq.put("\u0430\u0432\u043e", 532);
    freq.put("\u0430\u0432\u0438", 1807);
    freq.put("\u0443\u043a\u0432", 382);
    freq.put("\u0441\u043d", 3623);
    freq.put("\u0443\u043a\u0430", 732);
    freq.put("\u0442\u0435", 29796);
    freq.put("\u0442\u0430", 36712);
    freq.put("t", 5815);
    freq.put("\u0442\u0432", 4680);
    freq.put("\u0442\u043d", 2841);
    freq.put("\u0442\u043e", 28365);
    freq.put("\u0442\u043f", 601);
    freq.put("\u0442\u0438", 19086);
    freq.put("\u0442\u043a", 1435);
    freq.put("\u0442\u043b", 534);
    freq.put("\u0445 ", 407);
    freq.put("\u0438\u0440\u0438", 916);
    freq.put("\u0438\u0440\u043e", 1138);
    freq.put("\u0441\u0440", 1256);
    freq.put("\u0438 ", 77640);
    freq.put("\u0438\u0440\u0430", 3770);
    freq.put("\u0441\u0443", 2000);
    freq.put("\u0438\u0440\u0435", 311);
    freq.put("\u0445\u0435\u043c", 340);
    freq.put("\u0445\u0435\u043e", 283);
    freq.put("E", 600);
    freq.put(" \u043f\u0440", 14360);
    freq.put("\u043b\u0430 ", 4400);
    freq.put("\u0448\u043a\u043e", 400);
    freq.put("o ", 1254);
    freq.put(" \u0413\u043e", 800);
    freq.put("\u0425\u0435", 392);
    freq.put("\u0432\u0430\u043b", 1237);
    freq.put("\u0447", 22883);
    freq.put("\u0430\u0434 ", 2199);
    freq.put("\u0438\u043d ", 1454);
    freq.put(" \u043f\u043e", 15733);
    freq.put("on", 1271);
    freq.put("om", 450);
    freq.put("ol", 392);
    freq.put("\u043f\u043b\u0435", 333);
    freq.put(" \u043f\u043b", 1137);
    freq.put(" \u043f\u0438", 929);
    freq.put("\u043f\u043b\u0438", 320);
    freq.put(" \u043f\u0435", 1794);
    freq.put(" \u043f\u0430", 2332);
    freq.put("\u043f\u043b\u043e", 389);
    freq.put("ou", 298);
    freq.put("os", 424);
    freq.put("or", 933);
    freq.put("op", 290);
    freq.put(" \u0431\u0430", 813);
    freq.put(" \u0431\u0435", 1085);
    freq.put(" \u0431\u0438", 4668);
    freq.put(" \u0431\u043b", 584);
    freq.put(" \u0431\u043e", 1018);
    freq.put("\u0421\u0430", 911);
    freq.put("\u043e\u0441 ", 575);
    freq.put("\u0421\u0432", 650);
    freq.put("\u0421\u0435", 1780);
    freq.put("\u0421\u0438", 589);
    freq.put("\u0421\u043b", 373);
    freq.put("\u0421\u043a", 807);
    freq.put("\u0438\u0442 ", 464);
    freq.put("\u0421\u043f", 404);
    freq.put("\u0421\u043e", 1077);
    freq.put("\u043e\u0432\u0438", 5165);
    freq.put("\u043e\u0432\u043e", 2355);
    freq.put("\u043e\u0432\u043d", 742);
    freq.put("\u043e\u0432\u0430", 2348);
    freq.put("\u043e\u0432\u0435", 2546);
    freq.put("\u0421\u0410", 368);
    freq.put("\u0432", 105270);
    freq.put("\u0431\u0438\u0434", 516);
    freq.put("\u0431\u0438\u043b", 3972);
    freq.put("\u0436\u0435\u043d", 928);
    freq.put("\u0436\u0435\u043b", 288);
    freq.put("\u0431\u0438\u0442", 461);
    freq.put("\u0431\u0438\u0440", 443);
    freq.put("\u0448\u043d\u0438", 549);
    freq.put("\u0446\u0440\u043a", 515);
    freq.put("\u0431\u0438\u0447", 355);
    freq.put("J", 289);
    freq.put("\u0431\u0438\u0458", 384);
    freq.put("\u043e\u0432\u0440", 984);
    freq.put("\u0436\u0435\u045a", 316);
    freq.put("\u0440\u0432\u0435", 449);
    freq.put("\u0421\u0440", 474);
    freq.put("\u0421\u0442", 846);
    freq.put("\u0440\u0432\u0430", 669);
    freq.put("\u0440\u0432\u043e", 342);
    freq.put("\u0440\u0432\u0438", 554);
    freq.put("\u0443\u0436", 1378);
    freq.put(" \u0431\u0440", 3187);
    freq.put("\u0412\u0435\u043b", 340);
    freq.put(" \u0431\u0443", 674);
    freq.put("he ", 401);
    freq.put("\u0443\u0435", 298);
    freq.put("\u0422\u0438", 438);
    freq.put("\u043a\u0430\u0458", 517);
    freq.put("ac", 442);
    freq.put("ae", 314);
    freq.put("am", 363);
    freq.put("al", 1004);
    freq.put("an", 1614);
    freq.put("as", 511);
    freq.put("ar", 1185);
    freq.put("at", 846);
    freq.put("\u043c\u0438\u043e", 320);
    freq.put("\u043c\u0438\u043d", 1679);
    freq.put("\u043a\u0430\u0442", 5730);
    freq.put("\u043c\u0438\u043b", 526);
    freq.put("\u043a\u0430\u0446", 351);
    freq.put("\u043d\u0438\u0435", 1319);
    freq.put("\u043d\u0438\u0432", 1190);
    freq.put("\u043e\u0430 ", 1059);
    freq.put("\u0432\u0442\u043e", 1107);
    freq.put("\u0442\u0438\u0458", 1079);
    freq.put("\u0446\u0435\u043d", 1177);
    freq.put("m", 3009);
    freq.put(" \u043c\u043e", 2407);
    freq.put("\u043a\u0430\u043b", 885);
    freq.put("\u043a\u0430\u043a", 3097);
    freq.put("\u043a\u0430\u043d", 1422);
    freq.put("\u043c\u0438\u0442", 1061);
    freq.put("\u043c\u0438\u0441", 724);
    freq.put("\u043c\u0438\u0440", 732);
    freq.put("\u0434\u0440\u0430", 666);
    freq.put("\u0447\u0430\u0440", 740);
    freq.put("\u043a\u0430\u0434", 630);
    freq.put("\u043a\u0430\u0437", 294);
    freq.put("\u043a\u0430\u0436", 406);
    freq.put("u", 3216);
    freq.put("\u0440\u0441\u043a", 2698);
    freq.put("\u043c\u0438\u0458", 737);
    freq.put(" \u0435\u043a", 551);
    freq.put(" \u0435\u043b", 592);
    freq.put(" \u0435\u0434", 3169);
    freq.put("\u0430\u043a\u0301\u0430", 380);
    freq.put("\u0433\u0443\u0441", 349);
    freq.put("\u043f\u0441\u043a", 1161);
    freq.put(" \u0435\u0432", 363);
    freq.put("\u043e\u0436\u0435", 937);
    freq.put("\u0444\u043e\u0440", 1281);
    freq.put("\u0444\u043e\u0442", 446);
    freq.put("\u043c\u043f\u0438", 518);
    freq.put("\u043a\u0442\u0440", 386);
    freq.put("tr", 283);
    freq.put("to", 540);
    freq.put("th", 673);
    freq.put("ti", 907);
    freq.put("\u0438", 261784);
    freq.put("te", 849);
    freq.put("ta", 699);
    freq.put("\u0413\u043b", 343);
    freq.put("\u043a\u043e\u0438", 2339);
    freq.put("\u0413\u043e", 804);
    freq.put("\u0413\u0430", 384);
    freq.put("al ", 294);
    freq.put("\u0440\u0436\u0430", 1664);
    freq.put("\u0444\u0443\u043d", 322);
    freq.put("\u043a\u043e\u043d", 2061);
    freq.put("is ", 354);
    freq.put("\u0435\u043b\u043e", 2613);
    freq.put("\u0422\u0443\u0440", 381);
    freq.put("\u0435\u043b\u043d", 396);
    freq.put("\u0445\u0430", 892);
    freq.put("\u043f\u0441\u0442", 289);
    freq.put("t ", 818);
    freq.put("\u0430\u0441\u0430", 450);
    freq.put("\u0441\u0435 ", 11859);
    freq.put("\u0430\u0441\u0435", 1117);
    freq.put("\u0430\u0441\u0438", 680);
    freq.put("\u0430\u0441\u043a", 436);
    freq.put("\u0430\u0441\u043b", 312);
    freq.put("\u0430\u0441\u043d", 388);
    freq.put("\u0430\u0441\u043e", 310);
    freq.put("\u0430\u0441\u043f", 410);
    freq.put("\u0442\u0438\u043a", 921);
    freq.put("\u0442\u0438\u043d", 2798);
    freq.put("ter", 323);
    freq.put("\u0448\u0438\u043d", 495);
    freq.put("\u0442\u0430\u0440", 2183);
    freq.put("\u0423", 965);
    freq.put("\u0442\u0430\u0442", 1512);
    freq.put("\u0435\u0432 ", 387);
    freq.put("\u0442\u0430\u0446", 321);
    freq.put("\u0458\u043a\u0301\u0438", 588);
    freq.put("\u043a\u0442", 3820);
    freq.put("\u0430 ", 151197);
    freq.put("\u043a\u0432", 1916);
    freq.put("\u0433\u0438\u0458", 928);
    freq.put("\u045a\u0435", 5394);
    freq.put("\u045a\u0430", 1280);
    freq.put(" \u0440\u0443", 564);
    freq.put("K", 455);
    freq.put("\u0445\u0440", 886);
    freq.put("\u0442\u0430\u0430", 321);
    freq.put("\u0442\u0430\u0432", 2466);
    freq.put("\u0442\u0430\u043b", 1456);
    freq.put("\u0442\u0430\u043a", 837);
    freq.put("\u0442\u0430\u043d", 2640);
    freq.put("\u0433\u0438\u043e", 772);
    freq.put("\u0443\u0440\u043d", 333);
    freq.put("\u0441\u0432", 2617);
    freq.put("\u0430\u0441\u0442", 2995);
    freq.put("\u0440\u0445\u0438", 519);
    freq.put("\u0428", 1184);
    freq.put("\u0440\u0445\u0435", 302);
    freq.put("\u0442\u0443\u0440", 2009);
    freq.put("\u043b\u0435\u0442", 727);
    freq.put("\u043b\u0435\u0441", 486);
    freq.put("\u043b\u0435\u0440", 345);
    freq.put("\u0441\u043b\u0438", 753);
    freq.put("\u0441\u043b\u043e", 1010);
    freq.put("\u0441\u043b\u0430", 744);
    freq.put("\u0441\u043b\u0435", 1796);
    freq.put("\u0435\u043e\u0440", 360);
    freq.put("\u0430\u0433\u0301\u0430", 856);
    freq.put("\u0437\u0433\u0440", 557);
    freq.put("\u0438\u0433", 2802);
    freq.put("\u0435\u043e\u0433", 380);
    freq.put("\u0435\u043e\u043b", 430);
    freq.put("\u0435\u0433\u0301\u0443", 1271);
    freq.put("\u0441\u043b\u0443", 574);
    freq.put("\u043b\u0435\u043d", 3033);
    freq.put("\u043b\u0435\u043c", 2373);
    freq.put("\u043b\u0435\u043a", 1469);
    freq.put("v", 996);
    freq.put("\u043b\u0435\u0437", 472);
    freq.put("\u043b\u0435\u0434", 1625);
    freq.put("\u043b\u0435\u0433", 370);
    freq.put("\u043b\u0435\u0432", 497);
    freq.put("\u0442\u0443\u0432", 539);
    freq.put("\u0430\u0437\u0432", 373);
    freq.put("\u0430\u0437\u0430", 432);
    freq.put("\u0430\u0437\u0431", 417);
    freq.put("\u041f\u0440\u0438", 340);
    freq.put("\u0430\u0437\u043d", 452);
    freq.put("\u0430\u0437\u043b", 623);
    freq.put("\u0430\u0437\u0438", 3687);
    freq.put("f ", 324);
    freq.put("\u0443\u0441\u0442", 803);
    freq.put("ati", 284);
    freq.put(" \u041c\u043e", 928);
    freq.put("\u043e\u0444\u0438", 716);
    freq.put("w", 745);
    freq.put("\u0438\u0434", 3802);
    freq.put("a", 10833);
    freq.put(" \u0412\u0430", 686);
    freq.put(" \u0412\u043e", 1669);
    freq.put("\u0436\u0438 ", 501);
    freq.put("\u0437\u0430\u0440", 363);
    freq.put("y ", 690);
    freq.put("\u0418\u0441", 747);
    freq.put("\u041a\u0440\u0430", 315);
    freq.put("\u0441\u0442\u0430", 7801);
    freq.put("\u0448\u0435 ", 558);
    freq.put("\u0424", 2111);
    freq.put(" \u0446\u0440", 836);
    freq.put("\u043c\u0430\u043d", 2367);
    freq.put("\u0432\u0438\u043b", 734);
    freq.put("\u0432\u0438\u043d", 1260);
    freq.put("\u0432\u0438\u043e", 811);
    freq.put("\u0440\u0435 ", 437);
    freq.put("\u0432\u0438\u0434", 1204);
    freq.put("\u0432\u0438\u0437", 445);
    freq.put("\u0432\u0438\u0436", 381);
    freq.put("\u043f\u0440\u0435", 5957);
    freq.put("\u0443\u043d", 2432);
    freq.put("\u043f\u0440\u0430", 1665);
    freq.put("\u043f\u0440\u0432", 1141);
    freq.put("\u0432\u0438\u0441", 1212);
    freq.put("\u043f\u0440\u043e", 4233);
    freq.put("\u0432\u0438\u0442", 1405);
    freq.put("\u043f\u0440\u0438", 3441);
    freq.put("L", 579);
    freq.put("\u0432\u0438\u0447", 290);
    freq.put("\u043e\u0437\u0434", 514);
    freq.put("\u0432\u0438\u0458", 388);
    freq.put("\u0430\u0440 ", 2828);
    freq.put("\u043e\u0437\u0430", 639);
    freq.put("\u043e\u0437\u043d", 2037);
    freq.put("\u043e\u0437\u043e", 309);
    freq.put("\u043e\u0437\u0438", 514);
    freq.put("\u0445\u043e\u0434", 569);
    freq.put("\u045f\u0430", 360);
    freq.put("\u0448\u0442\u043e", 3204);
    freq.put("\u0448\u0442\u0438", 1481);
    freq.put("\u0418\u043c", 497);
    freq.put("\u0418\u043d", 571);
    freq.put("\u0448\u0442\u0435", 1404);
    freq.put("\u0418\u0437", 327);
    freq.put("\u043a\u0440", 4199);
    freq.put("\u040f", 661);
    freq.put("\u043d\u0438\u043e", 3455);
    freq.put("\u043d\u0438\u043c", 450);
    freq.put("\u043d\u0438\u043d", 793);
    freq.put("\u043d\u0438\u043a", 2233);
    freq.put("\u043e\u0458\u0430", 4079);
    freq.put("\u0440\u0437\u0430", 354);
    freq.put("\u043e\u0458\u043d", 740);
    freq.put("\u043d\u0438\u0437", 1413);
    freq.put("\u043e\u0458\u043e", 993);
    freq.put("\u0437\u0430 ", 5828);
    freq.put("\u0446\u0438 ", 2599);
    freq.put("\u0440\u0437\u0438", 395);
    freq.put("\u0434\u0440\u0436", 2045);
    freq.put("\u0434\u0440\u0435", 612);
    freq.put("\u043a\u043e\u0442", 2936);
    freq.put("\u0435\u0446 ", 658);
    freq.put("\u0434\u0440\u043e", 328);
    freq.put("\u045a\u0435\u0442", 1203);
    freq.put("\u043a\u043e\u0440", 1338);
    freq.put("\u0430\u0442\u0441", 493);
    freq.put("\u0430\u0442\u0440", 330);
    freq.put("\u0430\u0442\u0443", 514);
    freq.put(" \u0436\u0438", 1512);
    freq.put("\u0430\u0442\u0435", 2125);
    freq.put("\u0430\u0442\u0430", 20566);
    freq.put("\u0430\u0442\u043d", 495);
    freq.put("\u0430\u0442\u043f", 334);
    freq.put("\u0430\u0442\u043e", 1865);
    freq.put("\u0430\u0442\u0438", 3730);
    freq.put("\u0430\u0442\u043a", 340);
    freq.put("\u0434\u0440\u0443", 1086);
    freq.put("\u043c\u0435 ", 1911);
    freq.put("\u041f\u0440\u0435", 445);
    freq.put("\u043e\u0458\u0443", 491);
    freq.put("\u043d\u0438\u0446", 2089);
    freq.put("\u043d\u0438\u0447", 1161);
    freq.put("\u041f\u0440\u043e", 342);
    freq.put("\u043d\u0438\u0442", 3914);
    freq.put("\u043d\u0438\u0440", 495);
    freq.put("\u043d\u0438\u0441", 1095);
    freq.put(" \u0436\u0435", 492);
    freq.put("\u043d\u0438\u0458", 3754);
    freq.put("\u043e\u0438", 4773);
    freq.put("\u043e\u043a", 6835);
    freq.put("\u043e\u043b", 13527);
    freq.put("\u043e\u043c", 7054);
    freq.put("\u043e\u043d", 15080);
    freq.put("\u043e\u043e", 627);
    freq.put("\u043e\u043f", 6149);
    freq.put("\u043e\u0430", 1652);
    freq.put("\u043e\u0431", 5296);
    freq.put("\u043e\u0432", 16820);
    freq.put("\u043e\u0433", 5746);
    freq.put("\u043e\u0434", 29777);
    freq.put("\u043e\u0435", 2635);
    freq.put("\u043e\u0436", 1857);
    freq.put("\u043e\u0437", 4638);
    freq.put("\u0433\u043b\u0435", 564);
    freq.put("\u0431\u0440", 4813);
    freq.put("\u0431\u0443", 1986);
    freq.put("\u0433\u043b\u0430", 1406);
    freq.put("\u0433\u043b\u0438", 1163);
    freq.put(" \u0421\u0430", 911);
    freq.put("\u0440\u0446\u0438", 855);
    freq.put(" \u0421\u0432", 648);
    freq.put("\u043a", 111435);
    freq.put("\u043a\u043b\u0443", 723);
    freq.put("\u043a\u043b\u043e", 480);
    freq.put("\u0434\u043e ", 1648);
    freq.put("\u0458\u0437\u0438", 419);
    freq.put("\u043a\u043b\u0435", 364);
    freq.put("\u0458\u043d", 1588);
    freq.put("\u043a\u043b\u0430", 474);
    freq.put("\u0441\u043a\u0438", 15155);
    freq.put(" \u0421\u0438", 588);
    freq.put("\u0443\u0441\u0438", 423);
    freq.put("\u0441\u043a\u043e", 2753);
    freq.put("\u0441\u043a\u0430", 7767);
    freq.put(" \u0421\u043a", 806);
    freq.put("\u043e\u0458", 14117);
    freq.put("\u0431\u0430", 4355);
    freq.put("b", 1224);
    freq.put("\u0431\u0435", 3314);
    freq.put("\u0435\u0458\u0430", 386);
    freq.put("\u0433\u0301\u0430\u0430", 300);
    freq.put("\u0431\u0438", 7825);
    freq.put("\u0431\u043b", 3356);
    freq.put("\u043e\u0433\u0301", 2317);
    freq.put("\u0431\u043d", 514);
    freq.put("\u0431\u043e", 4771);
    freq.put("\u043e\u0448", 1554);
    freq.put("\u0437\u0432\u0435", 330);
    freq.put(" \u0421\u043e", 1077);
    freq.put("\u0437\u0432\u043e", 628);
    freq.put("\u043e\u0441", 13243);
    freq.put("\u043e\u0442", 31750);
    freq.put("\u043e\u0443", 339);
    freq.put("\u043e\u0444", 1458);
    freq.put("\u043e\u0445", 400);
    freq.put("\u0437\u0432\u0438", 372);
    freq.put("\u043e\u0447", 2768);
    freq.put(" \u0421\u0440", 473);
    freq.put("\u0435\u043d\u0435", 1764);
    freq.put("\u0435\u043d\u0434", 500);
    freq.put("\u0435\u043d\u0430", 3300);
    freq.put("\u0435\u043d\u043e", 2370);
    freq.put("\u0435\u043d\u0438", 4714);
    freq.put("\u0435\u043d\u043a", 321);
    freq.put("\u0442\u0440\u0430", 3106);
    freq.put("\u0425", 1951);
    freq.put("\u0434\u0438\u0448", 466);
    freq.put("\u0443\u0430\u0440", 643);
    freq.put("\u0434\u0438\u0446", 456);
    freq.put("\u0434\u0438\u0442", 597);
    freq.put("\u0434\u0438\u0441", 491);
    freq.put("\u0442\u0440\u043e", 1844);
    freq.put("\u0434\u0438\u0458", 826);
    freq.put("\u0434 ", 20357);
    freq.put("\u0430\u0438\u043d", 488);
    freq.put("\u0443\u0448", 1171);
    freq.put("M", 1021);
    freq.put("\u0434\u0438\u043d", 5382);
    freq.put("\u0435\u043d\u0446", 490);
    freq.put("\u0435\u043d\u0441", 1151);
    freq.put("\u0435\u043d\u0443", 344);
    freq.put("\u0435\u043d\u0442", 3074);
    freq.put("\u0442\u043e\u0458", 1245);
    freq.put("\u0443\u043d\u0438", 908);
    freq.put("km", 293);
    freq.put("\u0424\u0438", 522);
    freq.put("\u043e\u0440\u0441", 410);
    freq.put("\u0440\u0443\u0441", 732);
    freq.put("\u0458\u0435 ", 862);
    freq.put("\u041d\u0430 ", 392);
    freq.put("\u0442\u0440", 9143);
    freq.put("\u0443\u043d\u0430", 414);
    freq.put("\u0442\u0432\u0443", 302);
    freq.put("\u0442\u0432\u0440", 556);
    freq.put("\u041d\u0435", 719);
    freq.put("\u0420", 4369);
    freq.put("\u041d\u0430", 1551);
    freq.put("\u0437\u043e\u043d", 283);
    freq.put("\u041d\u0438", 442);
    freq.put(" \u0425\u043e", 298);
    freq.put(" \u0425\u0435", 392);
    freq.put("\u043b\u043d\u0438", 1621);
    freq.put("\u0437\u0431\u0443", 314);
    freq.put("\u0437\u0431\u043e", 1117);
    freq.put("\u0437\u0431\u0438", 290);
    freq.put(" \u0425\u0440", 338);
    freq.put("\u0432\u043b", 1274);
    freq.put("\u0442\u0432\u043e", 2438);
    freq.put("\u0442\u0432\u0435", 696);
    freq.put("\u0433\u0443 ", 683);
    freq.put("\u0442\u0432\u0430", 548);
    freq.put("\u0435\u0447\u043a", 442);
    freq.put("\u0440\u0443\u043f", 1220);
    freq.put("\u0435\u0447\u043d", 297);
    freq.put("\u0440\u0443\u0432", 1033);
    freq.put("x", 320);
    freq.put("\u0440\u0443\u0430", 354);
    freq.put("\u0440\u0443\u0436", 292);
    freq.put("\u0435\u0447\u0435", 723);
    freq.put("\u0443\u0433\u0438", 667);
    freq.put("\u0441\u0435\u0431", 334);
    freq.put("\u0441\u0435\u0432", 971);
    freq.put("\u0441\u0435\u0434", 864);
    freq.put("\u0430\u043d\u0441", 4432);
    freq.put("\u0441\u0435\u043b", 2274);
    freq.put("\u0441\u0435\u043a", 726);
    freq.put("\u0441\u0435\u043d", 517);
    freq.put("\u0441\u0435\u043c", 349);
    freq.put("\u0441\u0435\u043f", 284);
    freq.put("\u0426\u0435", 313);
    freq.put("\u0430\u0432", 11512);
    freq.put("\u0430\u0433", 2167);
    freq.put("\u0430\u0430", 4444);
    freq.put("\u0430\u0431", 2331);
    freq.put("\u0430\u0436", 1096);
    freq.put("\u0438\u0441\u043e", 810);
    freq.put("\u0430\u0434", 10986);
    freq.put("\u0430\u0435", 1609);
    freq.put("\u0430\u043a", 12466);
    freq.put("\u0430\u043b", 15259);
    freq.put("\u0430\u0438", 936);
    freq.put("\u0430\u043e", 2597);
    freq.put("\u0430\u043f", 4252);
    freq.put("\u0413\u0440\u0446", 367);
    freq.put("\u0430\u043d", 27243);
    freq.put("\u0435\u0432\u0435", 1630);
    freq.put("\u0435\u0432\u0430", 629);
    freq.put("\u0432\u0440\u0434", 656);
    freq.put("\u0432\u0440\u0437", 737);
    freq.put(" \u041e\u0441", 605);
    freq.put("\u0432\u0440\u0438", 1040);
    freq.put("\u0435\u0432\u043e", 1021);
    freq.put(" \u0414\u0440", 341);
    freq.put("\u0435\u0432\u0438", 727);
    freq.put("\u0432\u0440\u043e", 757);
    freq.put("\u0433\u0438 ", 1837);
    freq.put("\u0442\u0430 ", 23306);
    freq.put("\u0432\u0440\u0443", 340);
    freq.put("\u0435\u0432\u0440", 732);
    freq.put(" \u041e\u043f", 468);
    freq.put("\u0430\u045a", 4559);
    freq.put("\u0432\u0440\u0448", 792);
    freq.put("\u0430\u0458", 7017);
    freq.put(" \u041e\u0432", 1078);
    freq.put("\u0430\u043a\u0301", 462);
    freq.put("\u0430\u0442", 37636);
    freq.put("\u043e\u0440", 16926);
    freq.put("\u0430\u0440", 17103);
    freq.put("\u0430\u0441", 7790);
    freq.put("\u0430\u0446", 3769);
    freq.put("\u0430\u0447", 3591);
    freq.put("\u0430\u0444", 1127);
    freq.put("\u0430\u0445", 737);
    freq.put("\u0413\u0440\u0430", 387);
    freq.put("\u0430\u0448", 1946);
    freq.put("\u0441\u0435\u0440", 521);
    freq.put("c", 2969);
    freq.put("\u0441\u0435\u0442", 758);
    freq.put("\u0438\u0433\u0440", 971);
    freq.put("\u043e\u0440\u043e", 1288);
    freq.put("\u0442\u0445\u043e", 477);
    freq.put("\u043e\u0446", 1836);
    freq.put("\u0438\u043e\u0442", 8785);
    freq.put("\u0434\u043d\u0430", 2163);
    freq.put("\u0443\u043f\u0430", 1105);
    freq.put(" \u0410\u0440", 690);
    freq.put("\u0434\u043d\u0435", 428);
    freq.put("\u0430\u0435\u0434", 445);
    freq.put("\u0430\u0437", 7096);
    freq.put("\u0434\u043d\u043e", 2480);
    freq.put("\u0443\u043f\u043e", 434);
    freq.put("\u0436", 11105);
    freq.put("\u043e\u0446\u0435", 494);
    freq.put("\u043e\u0446\u043d", 311);
    freq.put("N", 552);
    freq.put(" th", 283);
    freq.put("\u0442\u0435 ", 14904);
    freq.put("\u0433\u043e", 11946);
    freq.put(" \u0410\u0432", 472);
    freq.put(" \u0410\u043b", 1073);
    freq.put(" \u0410\u043d", 848);
    freq.put("\u043b\u0435 ", 2377);
    freq.put(" \u0413\u0440", 1204);
    freq.put("\u0438\u043e\u0434", 616);
    freq.put("\u0438\u043e\u043d", 2538);
    freq.put("\u0448\u043d\u043e", 321);
    freq.put("\u0443\u0448\u0442", 599);
    freq.put("\u0436\u0438\u0442", 423);
    freq.put("\u0458\u0430\u0432", 629);
    freq.put("\u0421", 9342);
    freq.put("\u043e\u0431\u0440", 811);
    freq.put("\u0422\u0440", 452);
    freq.put("\u0422\u0443", 524);
    freq.put("\u0442\u0438\u0441", 499);
    freq.put("\u043e\u0431\u0458", 366);
    freq.put("\u0432\u043a\u043b", 312);
    freq.put(" \u0434\u0440", 2545);
    freq.put(" \u0434\u043e", 4472);
    freq.put(" \u0434\u0438", 1319);
    freq.put(" \u0434\u0435", 5656);
    freq.put(" \u0434\u0432", 1419);
    freq.put(" \u0434\u0430", 2966);
    freq.put("\u0422\u0435", 690);
    freq.put("\u0422\u0430", 770);
    freq.put("\u043e\u0431\u0435", 598);
    freq.put("\u0437\u0430\u043d", 720);
    freq.put("\u043e\u0431\u043b", 1113);
    freq.put("\u043e\u0431\u0438", 1201);
    freq.put("\u0438\u043b\u0435", 1067);
    freq.put("\u043e\u0431\u043e", 536);
    freq.put("\u0442\u0435\u043d", 1940);
    freq.put("\u0442\u0440\u0438", 1787);
    freq.put("y", 1482);
    freq.put("\u0436\u0438\u0432", 1211);
    freq.put("\u0442\u0438\u0442", 1897);
    freq.put(" \u0426\u0440", 465);
    freq.put("\u043d\u043a\u0430", 519);
    freq.put("\u043d\u043a\u0438", 331);
    freq.put("\u0440\u0435\u043c", 1904);
    freq.put("\u0440\u0435\u043d", 1613);
    freq.put("\u0440\u0435\u043f", 457);
    freq.put("\u0440\u0435\u043a", 1638);
    freq.put("\u0440\u0435\u043b", 504);
    freq.put("\u0440\u0435\u0434", 3985);
    freq.put("\u0432\u0438 ", 3384);
    freq.put("\u0440\u0435\u0436", 432);
    freq.put("\u0440\u0435\u0437", 448);
    freq.put("\u0440\u0435\u0430", 398);
    freq.put("\u0440\u0435\u0431", 752);
    freq.put("\u0440\u0435\u0432", 1305);
    freq.put("\u0440\u0435\u0433", 1001);
    freq.put("\u0433\u0440\u0438", 662);
    freq.put("\u0430\u0440\u0442", 1039);
    freq.put("\u0430\u0440\u0441", 1354);
    freq.put("\u0430\u0440\u0445", 678);
    freq.put("\u0433\u0440\u0430", 5732);
    freq.put("\u0448\u0435\u043d", 456);
    freq.put("\u0433\u0440\u0435", 320);
    freq.put("\u0430\u0440\u0430", 1867);
    freq.put("\u0440\u0435\u0458", 340);
    freq.put("\u0447\u043d\u043e", 1236);
    freq.put("\u0430\u0440\u0435", 1123);
    freq.put("\u0430\u0440\u0434", 653);
    freq.put("\u0430\u0440\u043a", 629);
    freq.put("\u0433\u0440\u0443", 1162);
    freq.put("\u0430\u0440\u043e", 1814);
    freq.put("\u0430\u0440\u043d", 612);
    freq.put("\u0433\u0440\u0447", 711);
    freq.put("\u0436\u0443\u0432", 901);
    freq.put("\u0440\u0435\u0448", 461);
    freq.put("\u0440\u0435\u0447", 605);
    freq.put("\u0440\u0435\u0441", 955);
    freq.put("\u0440\u0435\u0442", 3047);
    freq.put("\u043d\u043a\u0446", 314);
    freq.put(" \u0426\u0435", 313);
    freq.put("d", 2970);
    freq.put(" \u0414\u0438", 459);
    freq.put(" \u0414\u0435", 856);
    freq.put("\u043e\u043f\u0448", 1157);
    freq.put("\u043c\u0435\u0440", 1511);
    freq.put("\u043c\u0435\u0441", 950);
    freq.put("\u043c\u0435\u0442", 2904);
    freq.put("\u0437\u0430\u043f", 1380);
    freq.put("\u0432\u0441\u0442", 329);
    freq.put("\u043e\u0458 ", 6820);
    freq.put("\u0440\u0437 ", 285);
    freq.put("\u0437\u0430\u0435", 409);
    freq.put("\u043d\u0438 ", 9820);
    freq.put("\u0455\u0432", 310);
    freq.put("\u0458\u0443\u0433", 496);
    freq.put("\u043d\u0446\u0443", 394);
    freq.put("\u0458\u0443\u0436", 519);
    freq.put(" \u0458\u0430", 4740);
    freq.put(" \u041b\u0443", 312);
    freq.put("\u0435\u0446\u0438", 352);
    freq.put("\u0437", 39653);
    freq.put("\u0412\u043e ", 1246);
    freq.put("\u043a\u043d\u0438", 318);
    freq.put("\u0433\u0301\u0443 ", 904);
    freq.put("O", 461);
    freq.put("\u045a\u0435 ", 4162);
    freq.put("\u0430\u0442 ", 6463);
    freq.put("\u03c2 ", 427);
    freq.put("\u0446\u0438\u0458", 5710);
    freq.put("\u043d\u0446\u0438", 1726);
    freq.put("\u0442\u0440\u0443", 758);
    freq.put(" \u041a\u043e", 1590);
    freq.put("\u043c\u0435\u0434", 429);
    freq.put("\u0435\u0431\u0430", 481);
    freq.put("\u0437\u0430\u0446", 679);
    freq.put("\u0432\u0441\u043a", 1077);
    freq.put("\u043c\u0435\u043d", 3380);
    freq.put("\u0437\u0430\u0442", 324);
    freq.put("\u0448\u0435", 1638);
    freq.put(" \u041f\u043e", 1728);
    freq.put("\u043a\u0446\u0438", 783);
    freq.put(" \u041f\u0438", 295);
    freq.put(" \u041f\u0435", 961);
    freq.put(" \u041f\u0430", 996);
    freq.put("\u043e ", 68362);
    freq.put("\u0435\u043f\u043e", 307);
    freq.put("\u0434\u043e\u0446", 331);
    freq.put("\u0434\u043e\u0441", 369);
    freq.put("\u0434\u043e\u0442", 1786);
    freq.put("\u0430\u0436\u0443", 426);
    freq.put("\u041a\u0430\u0440", 402);
    freq.put("\u0421\u0432\u0435", 487);
    freq.put("\u0434\u043e\u0434", 356);
    freq.put("\u0434\u043e\u0431", 755);
    freq.put("\u0434\u043e\u0432", 988);
    freq.put("\u0434\u043e\u043d", 4125);
    freq.put("\u0434\u043e\u043c", 347);
    freq.put("\u0434\u043e\u043b", 887);
    freq.put("\u0434\u043e\u043a", 331);
    freq.put("\u0435\u043f\u0443", 1119);
    freq.put("\u0435\u043f\u0442", 359);
    freq.put("us", 735);
    freq.put("ur", 355);
    freq.put("\u0431 ", 542);
    freq.put("\u0433\u0301\u0430 ", 2452);
    freq.put("z", 571);
    freq.put(" \u041f\u0440", 1592);
    freq.put("\u043e\u0447\u0435", 494);
    freq.put("\u0427\u0435", 319);
    freq.put("\u0435\u043d ", 10275);
    freq.put("\u0411\u0443\u0433", 380);
    freq.put("\u043e\u0447\u043d", 1426);
    freq.put("\u043e\u0447\u0438", 455);
    freq.put("\u041f\u043e\u043b", 375);
    freq.put("\u0448\u0443", 599);
    freq.put("\u0434\u043e", 12951);
    freq.put("\u0434\u043c", 697);
    freq.put("\u0434\u043d", 7627);
    freq.put("\u041e\u043f\u0448", 342);
    freq.put("\u0434\u043b", 415);
    freq.put("\u0434\u0438", 12328);
    freq.put(" \u0411\u0438", 680);
    freq.put("\u0445\u0435", 1090);
    freq.put("\u0434\u0432", 2181);
    freq.put("\u0434\u0433", 373);
    freq.put("\u0434\u0430", 9183);
    freq.put("\u0434\u0431", 788);
    freq.put("\u0438\u043f\u0430", 375);
    freq.put("\u0438\u043f\u0438", 348);
    freq.put(" \u0432\u043e", 21906);
    freq.put("\u0434\u0438 ", 1894);
    freq.put(" \u0411\u0440", 703);
    freq.put(" \u0411\u0443", 778);
    freq.put("\u0434\u0443", 2009);
    freq.put("\u0434\u0440", 5219);
    freq.put("\u0434\u0441", 1024);
    freq.put("e", 9834);
    freq.put("\u041a\u043e\u043d", 322);
    freq.put("\u0432\u043b\u0435", 285);
    freq.put("\u0432\u043b\u0430", 692);
    freq.put("\u0438\u0444\u043e", 430);
    freq.put("\u0438\u0444\u0438", 395);
    freq.put(" c", 357);
    freq.put(" a", 559);
    freq.put("\u043a\u0442\u0443", 473);
    freq.put(" d", 474);
    freq.put(" e", 367);
    freq.put(" k", 375);
    freq.put(" i", 285);
    freq.put(" o", 776);
    freq.put(" m", 470);
    freq.put(" s", 442);
    freq.put(" p", 361);
    freq.put("\u043a\u0438", 22033);
    freq.put(" t", 538);
    freq.put("\u0435\u043b\u0438", 2173);
    freq.put("\u043a\u0435", 4892);
    freq.put("\u0435\u043b\u0435", 3177);
    freq.put("\u043a\u0430", 27714);
    freq.put("\u0435\u043b\u0431", 498);
    freq.put("\u0435\u043b\u0430", 1614);
    freq.put(" B", 722);
    freq.put(" C", 1036);
    freq.put(" A", 1024);
    freq.put(" F", 403);
    freq.put(" G", 506);
    freq.put(" D", 520);
    freq.put(" E", 476);
    freq.put("\u0443\u0440\u0430", 1158);
    freq.put(" K", 424);
    freq.put(" H", 467);
    freq.put(" I", 966);
    freq.put(" N", 433);
    freq.put(" O", 314);
    freq.put(" L", 498);
    freq.put(" M", 897);
    freq.put(" R", 489);
    freq.put(" S", 1135);
    freq.put(" P", 814);
    freq.put("\u0447\u0443\u0432", 1137);
    freq.put(" V", 362);
    freq.put(" W", 317);
    freq.put(" T", 673);
    freq.put(" U", 304);
    freq.put("\u03bd", 292);
    freq.put("\u0430\u043a\u0443", 331);
    freq.put("\u0430\u043a\u0442", 1164);
    freq.put("\u0443\u0432\u0430", 11421);
    freq.put("\u0430\u043a\u043e", 4144);
    freq.put("\u0430\u043a\u0435", 3801);
    freq.put("\u0430\u043a\u0430", 975);
    freq.put("\u0430\u043a\u0432", 313);
    freq.put("P", 991);
    freq.put(" \u0440\u0430", 3709);
    freq.put(" \u0440\u0435", 3839);
    freq.put("g ", 312);
    freq.put("\u0443\u0440\u0441", 618);
    freq.put(" \u0440\u0438", 619);
    freq.put(" \u0440\u043e", 1485);
    freq.put("\u0443\u0440\u0446", 319);
    freq.put("\u043a\u0446", 796);
    freq.put("us ", 554);
    freq.put("\u0435\u043b\u0443", 301);
    freq.put("\u043a\u0441", 1892);
    freq.put("\u0435\u043b\u0441", 372);
    freq.put("\u043a\u0443", 4201);
    freq.put("\u043a\u0442\u0435", 605);
    freq.put("\u043a\u0442\u043e", 713);
    freq.put("\u043a\u0442\u0438", 891);
    freq.put("\u0440\u0442", 2549);
    freq.put("\u0440\u0443", 6871);
    freq.put("\u0440\u0441", 3892);
    freq.put("\u0440\u0446", 1077);
    freq.put("\u0440\u0447", 928);
    freq.put("\u0440\u0445", 1018);
    freq.put("\u043e\u0434 ", 14751);
    freq.put("\u0440\u0448", 1040);
    freq.put("\u0413", 3754);
    freq.put("\u0438\u0433\u0430", 533);
    freq.put(" \u0435 ", 17047);
    freq.put("\u0438\u0433\u0438", 461);
    freq.put(" \u0415\u0432", 563);
    freq.put(" \u0415\u0433", 326);
    freq.put("\u0432\u0440", 6858);
    freq.put("\u0431\u0430 ", 1244);
    freq.put("\u0440\u0438 ", 5094);
    freq.put("\u0447\u0435\u0441", 1120);
    freq.put("\u0433\u0301", 4991);
    freq.put("\u0442\u0440\u0435", 1295);
    freq.put(" \u0415\u0440", 317);
    freq.put("\u0438\u0458\u0430", 20901);
    freq.put("\u0440\u0432", 2697);
    freq.put("\u0440\u0433", 2004);
    freq.put("\u0440\u0430", 32025);
    freq.put("\u0440\u0431", 1278);
    freq.put("\u0440\u0436", 2185);
    freq.put("\u0440\u0437", 1370);
    freq.put("\u0440\u0434", 2000);
    freq.put("\u0440\u0435", 21468);
    freq.put("\u0440\u043a", 2169);
    freq.put("\u0440\u043b", 526);
    freq.put("\u0440\u0438", 23710);
    freq.put("\u0440\u043e", 18691);
    freq.put("\u0440\u043f", 592);
    freq.put("\u0440\u043c", 2952);
    freq.put("\u0440\u043d", 3559);
    freq.put("\u041d\u043e", 521);
    freq.put("\u0431\u0443\u043a", 590);
    freq.put("\u0432\u0435\u043a", 1300);
    freq.put("\u0432\u0435\u043b", 447);
    freq.put("\u0432\u0435\u043d", 3438);
    freq.put("\u0432\u0435\u0437", 364);
    freq.put("\u0432\u0435\u0434", 808);
    freq.put("\u0432\u0435\u0435", 283);
    freq.put("\u0436\u043d\u043e", 527);
    freq.put("\u043e\u043a ", 1161);
    freq.put("\u0436\u043d\u0438", 489);
    freq.put("\u0443 ", 4465);
    freq.put("\u0436\u043d\u0430", 492);
    freq.put("\u043e", 278169);
    freq.put("\u043f\u043b\u0430", 934);
    freq.put("\u0442\u043e ", 13336);
    freq.put("\u0448\u0438", 1346);
    freq.put("\u0447\u0435\u045a", 285);
    freq.put("\u0440\u043a\u0430", 561);
    freq.put("\u0440\u043a\u0432", 703);
    freq.put("\u043d\u0435 ", 1045);
    freq.put("f", 1092);
    freq.put("\u0432\u0435\u0442", 2185);
    freq.put(" \u0425\u0430", 496);
    freq.put("\u0432\u0435\u0440", 2282);
    freq.put("\u0432\u0435\u0441", 376);
    freq.put("\u0434\u0443\u0432", 889);
    freq.put("\u0432\u0435\u043a\u0301", 667);
    freq.put("of", 311);
    freq.put("\u0447\u0438\u0442", 363);
    freq.put("\u043c\u0443\u0437", 537);
    freq.put("\u0435\u0441\u0443", 502);
    freq.put("\u043c\u0443\u043d", 373);
    freq.put("\u0435\u0441\u0442", 3547);
    freq.put("\u043f\u0458", 828);
    freq.put("\u043c\u0430 ", 2440);
    freq.put("\u043e\u0438\u0437", 367);
    freq.put("\u043f\u0448", 1508);
    freq.put("\u043e\u0438\u043c", 505);
    freq.put("\u043f\u0443", 1996);
    freq.put("\u043f\u0442", 674);
    freq.put("\u043f\u0441", 1836);
    freq.put("\u043f\u0440", 16649);
    freq.put("\u043f\u043e", 20419);
    freq.put("\u043f\u043d", 348);
    freq.put("\u043e\u0438\u0441", 379);
    freq.put("\u043f\u0438", 3835);
    freq.put("\u0435\u043c ", 1181);
    freq.put("\u0438\u0434 ", 907);
    freq.put("\u043f\u0430", 7611);
    freq.put("\u0421\u0410\u0414", 331);
    freq.put("\u0422", 4778);
    freq.put("\u043a\u0438 ", 14686);
    freq.put("\u0435\u0441\u043a", 430);
    freq.put("\u0435\u0441\u043d", 1000);
    freq.put("\u0435\u0441\u043e", 341);
    freq.put("\u0443\u043c ", 532);
    freq.put("\u0435\u0441\u0435", 1065);
    freq.put("\u043d\u0433\u043e", 310);
    freq.put("\u043d\u0433\u043b", 1025);
    freq.put("\u0447\u0438\u043d", 910);
    freq.put("\u0443\u0441 ", 503);
    freq.put("\u043d\u0433\u0430", 386);
    freq.put("\u0441\u043f\u0435", 625);
    freq.put("\u0441\u043f\u0430", 419);
    freq.put("\u0441\u043f\u043e", 1324);
    freq.put("\u0443\u0433 ", 454);
    freq.put("\u0414", 3627);
    freq.put("\u043d\u0441\u043a", 8777);
    freq.put("\u0432\u0435", 13770);
    freq.put("le", 704);
    freq.put("\u0432\u0430", 22923);
    freq.put("la", 806);
    freq.put("lo", 357);
    freq.put("ll", 449);
    freq.put("\u0432\u0438", 13074);
    freq.put("\u0435\u043a\u0441", 1174);
    freq.put("\u0435\u043a\u0442", 1806);
    freq.put("li", 761);
    freq.put("\u0448\u0442\u0430", 515);
    freq.put("\u043c\u0432\u0440", 974);
    freq.put("\u0435\u043a\u043e", 2603);
    freq.put("\u0435\u043a\u0438", 306);
    freq.put("\u0432\u0441", 1589);
    freq.put("\u0432\u0442", 1215);
    freq.put("\u0435\u043a\u043b", 312);
    freq.put("\u0435\u043a\u0435", 284);
    freq.put("\u0435\u043a\u0430", 1814);
    freq.put("\u043d\u0441\u0442", 1138);
    freq.put("l ", 690);
    freq.put("\u0438\u0432 ", 663);
    freq.put("\u0441\u043f\u0440", 420);
    freq.put("\u0435 ", 62888);
    freq.put("\u0430\u043b\u0441", 704);
    freq.put("\u043f\u0430 ", 1261);
    freq.put(" \u0441\u0430", 1270);
    freq.put(" \u0441\u0432", 1979);
    freq.put(" \u0441\u0435", 16046);
    freq.put(" \u0441\u0438", 2281);
    freq.put("\u041e\u0441", 606);
    freq.put(" \u0441\u043a", 603);
    freq.put(" \u0441\u043b", 2331);
    freq.put(" \u0441\u043c", 1011);
    freq.put(" \u0441\u043e", 9088);
    freq.put(" \u0441\u043f", 1778);
    freq.put(" \u0427\u0435", 319);
    freq.put("\u0411\u0440", 705);
    freq.put("\u0411\u0443", 778);
    freq.put("\u043a\u0443\u0432", 856);
    freq.put("\u041f\u0435\u0442", 286);
    freq.put("\u043a\u0443\u043f", 340);
    freq.put("\u043f\u0435", 4276);
    freq.put("\u043f", 63533);
    freq.put("\u043a\u0443\u043b", 1012);
    freq.put("\u0411\u0430", 928);
    freq.put("\u0411\u0435", 879);
    freq.put("\u0440\u0443\u043c", 335);
    freq.put("\u0411\u0438", 685);
    freq.put("\u043e\u0435 ", 669);
    freq.put("\u0411\u043e", 738);
    freq.put("\u043b ", 10222);
    freq.put("\u0440\u0443\u0433", 1560);
    freq.put(" \u0441\u0440", 1095);
    freq.put(" \u0441\u0442", 3760);
    freq.put(" \u0441\u0443", 653);
    freq.put("\u0415\u0432\u0440", 489);
    freq.put("g", 1689);
    freq.put("\u0438\u0434\u0430", 352);
    freq.put("\u0438\u0434\u043e", 449);
    freq.put("\u041e\u0432", 1078);
    freq.put("\u0438\u0434\u0438", 356);
    freq.put("\u0430\u043b\u0430", 1561);
    freq.put("\u0421\u0435\u0432", 333);
    freq.put("\u0430\u043b\u0435", 2411);
    freq.put("\u0430\u043b\u043a", 385);
    freq.put("\u0421\u0435\u043b", 334);
    freq.put("\u0430\u043b\u043e", 848);
    freq.put("\u0430\u043b\u043d", 2980);
    freq.put(" \u041b\u0435", 628);
    freq.put(" \u0430 ", 1703);
    freq.put(" \u0408\u0430", 559);
    freq.put("\u0414 ", 485);
    freq.put(" \u0438 ", 17952);
    freq.put("\u0435\u0441\u0438", 417);
    freq.put("R", 594);
    freq.put("\u043e\u043b ", 609);
    freq.put("\u0430\u0441 ", 519);
    freq.put(" \u0408\u0443", 674);
    freq.put("\u0430\u0440\u0438", 3185);
    freq.put("\u0431\u0435\u0434", 404);
    freq.put("\u0431\u0435\u0437", 326);
    freq.put("\u0436\u0430\u0432", 1162);
    freq.put("\u0436\u0430\u043d", 284);
    freq.put("\u0431\u0435\u043b", 545);
    freq.put("\u0431\u0435\u043d", 594);
    freq.put("\u0444\u0443", 697);
    freq.put("\u0444\u0440", 997);
    freq.put("\u0444\u0441", 456);
    freq.put("\u0415", 2673);
    freq.put("\u0437\u0443", 791);
    freq.put("\u0437\u0440", 646);
    freq.put("\u043d\u0434 ", 382);
    freq.put(" \u043a\u043d", 382);
    freq.put(" \u043a\u043e", 13222);
    freq.put("\u0435\u0442 ", 2199);
    freq.put(" \u043a\u0438", 580);
    freq.put(" \u043a\u043b", 860);
    freq.put(" \u043a\u0430", 5502);
    freq.put(" \u043a\u0440", 1663);
    freq.put(" \u043a\u0443", 901);
    freq.put("\u0441\u0438 ", 856);
    freq.put("\u0437\u0434", 1570);
    freq.put("\u0455", 416);
    freq.put("\u0437\u0432", 1627);
    freq.put("\u0437\u0431", 1994);
    freq.put("\u0437\u0430", 12607);
    freq.put("\u0437\u043e", 1382);
    freq.put("\u0437\u043d", 4381);
    freq.put("\u0437\u043c", 998);
    freq.put("\u0437\u043b", 1008);
    freq.put("\u0433\u0435\u043d", 767);
    freq.put(" \u0442\u0440", 1830);
    freq.put("\u0442\u0435\u0440", 3359);
    freq.put("\u043b\u0438\u043e", 355);
    freq.put("\u0444\u043e", 2242);
    freq.put("\u0431\u0435\u0440", 412);
    freq.put("\u0444\u0438", 3122);
    freq.put("\u0436\u0430\u0442", 386);
    freq.put("\u0431\u0435\u0448", 291);
    freq.put("\u0444\u0435", 1624);
    freq.put("\u043d\u0442 ", 615);
    freq.put("\u0444\u0430", 1468);
    freq.put("\u0410\u0432", 472);
    freq.put("\u043b\u0438\u0433", 412);
    freq.put(" \u041d\u0438", 438);
    freq.put("\u0410\u043b", 1075);
    freq.put("\u043a ", 7206);
    freq.put("\u0410\u043c", 433);
    freq.put("\u0435\u043b ", 3388);
    freq.put("\u0410", 6164);
    freq.put("\u0430\u043c", 6375);
    freq.put("\u043e\u0432\u0441", 795);
    freq.put(" \u0442", 10678);
    freq.put(" \u0443", 3946);
    freq.put(" \u0440", 10396);
    freq.put(" \u0441", 42490);
    freq.put(" \u0446", 3019);
    freq.put(" \u0447", 2568);
    freq.put(" \u0444", 5078);
    freq.put(" \u0445", 2102);
    freq.put(" \u0448", 4226);
    freq.put(" \u0413\u0435", 523);
    freq.put("\u0432\u0440\u0435", 1804);
    freq.put(" \u0458", 6372);
    freq.put(" \u043a\u0301", 305);
    freq.put(" \u0422", 4639);
    freq.put(" \u0423", 893);
    freq.put(" \u0420", 3961);
    freq.put(" \u0421", 8974);
    freq.put(" \u0426", 1068);
    freq.put(" \u0427", 758);
    freq.put(" \u0424", 1931);
    freq.put(" \u0425", 1928);
    freq.put(" \u0428", 1131);
    freq.put(" \u0432", 30954);
    freq.put(" \u0433", 16454);
    freq.put(" \u0430", 9283);
    freq.put(" \u0431", 12052);
    freq.put(" \u0436", 2284);
    freq.put(" \u0437", 12782);
    freq.put(" \u0434", 18766);
    freq.put(" \u0435", 23200);
    freq.put(" \u043a", 23687);
    freq.put(" \u043b", 4546);
    freq.put(" \u0438", 33901);
    freq.put(" \u043e", 29291);
    freq.put("\u0430\u043a ", 666);
    freq.put(" \u043c", 12882);
    freq.put(" \u043d", 51827);
    freq.put("\u043a\u0442 ", 520);
    freq.put("h", 2724);
    freq.put(" \u0408", 1624);
    freq.put(" \u040f", 661);
    freq.put(" \u0412", 4654);
    freq.put(" \u0413", 3616);
    freq.put(" \u0410", 5482);
    freq.put(" \u0411", 5022);
    freq.put(" \u0416", 385);
    freq.put(" \u0417", 1936);
    freq.put(" \u0414", 3069);
    freq.put(" \u0415", 2489);
    freq.put(" \u041a", 5975);
    freq.put(" \u041b", 2339);
    freq.put(" \u0418", 3361);
    freq.put(" \u041e", 4096);
    freq.put(" \u041f", 6133);
    freq.put(" \u041c", 6938);
    freq.put(" \u041d", 3453);
    freq.put("\u0430\u0433\u0301", 883);
    freq.put("\u043f\u0443\u0431", 1193);
    freq.put("\u041d\u043e\u0432", 305);
    freq.put("\u043e\u0434\u0438", 4273);
    freq.put("\u0438\u0448\u0430", 368);
    freq.put("\u043e\u0434\u043d", 2574);
    freq.put("\u0434\u0441\u0442", 314);
    freq.put("\u043e\u0434\u043e", 1251);
    freq.put("\u043e\u0434\u0430", 1107);
    freq.put("\u043e\u0434\u0433", 298);
    freq.put("\u043e\u0434\u0432", 294);
    freq.put("\u043e\u0434\u0435", 2517);
    freq.put("\u0448\u0443\u0432", 475);
    freq.put("\u0627", 324);
    freq.put("\u0431\u0430\u0442", 375);
    freq.put("\u0440\u0438\u0442", 2109);
    freq.put("\u0440\u0438\u0441", 2774);
    freq.put("\u0440\u0438\u0440", 852);
    freq.put("\u0440\u0438\u0447", 442);
    freq.put("\u0425\u0430", 496);
    freq.put("\u0440\u0438\u0458", 3270);
    freq.put("\u043b", 91274);
    freq.put("\u0440\u0438\u043b", 774);
    freq.put("\u0431\u0430\u043b", 536);
    freq.put("S", 1413);
    freq.put("\u0440\u0438\u0438", 353);
    freq.put("\u0440\u0438\u043f", 420);
    freq.put("\u0440\u0438\u043e", 1095);
    freq.put("\u0440\u0438\u043d", 740);
    freq.put("\u0431\u0430\u043d", 796);
    freq.put("\u0440\u0438\u0432", 398);
    freq.put("\u0440\u0438\u0431", 299);
    freq.put("\u0440\u0438\u0437", 552);
    freq.put("\u0440\u0438\u0435", 488);
    freq.put("\u0440\u0438\u0434", 648);
    freq.put("\u0438\u0448\u0443", 288);
    freq.put("\u0438\u0448\u0442", 844);
    freq.put("\u0440 ", 8070);
    freq.put("\u0444\u0438\u043b", 788);
    freq.put("\u0444\u0438\u043a", 307);
    freq.put("\u0430\u0443", 1031);
    freq.put("\u043e\u0434\u0440", 1508);
    freq.put("\u0432\u0433", 415);
    freq.put("\u0434\u0441\u043a", 660);
    freq.put("\u0438\u0458 ", 327);
    freq.put("\u0414\u0440", 341);
    freq.put(" \u0437\u0430", 9018);
    freq.put("\u0432\u043d", 4219);
    freq.put(" \u0437\u043d", 1014);
    freq.put("\u0432\u043e", 32617);
    freq.put("\u0441\u0430", 3377);
    freq.put("ci", 314);
    freq.put("ch", 448);
    freq.put("co", 397);
    freq.put("\u043d\u0435\u0440", 1150);
    freq.put("\u043d\u0435\u0442", 980);
    freq.put("ca", 400);
    freq.put("\u0440\u0441\u0442", 683);
    freq.put("ce", 390);
    freq.put("\u0436\u0430", 2420);
    freq.put("\u0432\u043a", 750);
    freq.put("\u0436\u0438", 2889);
    freq.put("\u0435\u043a\u0443", 1063);
    freq.put("\u043d\u0435\u0458", 441);
    freq.put("\u043c\u0441\u043a", 1350);
    freq.put("\u0426", 1100);
    freq.put("\u0442\u043e\u0442", 2026);
    freq.put("\u0442\u043e\u0440", 3285);
    freq.put("\u0442\u043e\u0447", 1182);
    freq.put("\u0442\u043e\u0446", 289);
    freq.put("\u0443\u043b", 3220);
    freq.put("\u0443\u043a", 2337);
    freq.put("\u043e\u043a\u0430", 1091);
    freq.put("\u0443\u043f", 2469);
    freq.put("\u043a\u043e\u043b", 2256);
    freq.put("\u0443\u043c", 2729);
    freq.put("\u0443\u0433", 3250);
    freq.put("\u0443\u0432", 11713);
    freq.put("\u0443\u0431", 2169);
    freq.put("\u0443\u0430", 1187);
    freq.put("\u0443\u0437", 1241);
    freq.put("\u043e\u043a\u043e", 2063);
    freq.put("\u03bf", 532);
    freq.put("\u0443\u0434", 1768);
    freq.put("\u043e\u043a\u0442", 286);
    freq.put("\u043e\u043a\u0440", 1306);
    freq.put("\u0443\u0442", 1165);
    freq.put("\u0443\u0441", 3800);
    freq.put("\u0443\u0440", 4376);
    freq.put("\u0443\u0447", 2178);
    freq.put("\u0443\u0446", 759);
    freq.put("\u0442\u043e\u043b", 870);
    freq.put("\u0442\u043e\u043a", 893);
    freq.put("\u0442\u043e\u0438", 602);
    freq.put("\u0442\u043e\u043f", 356);
    freq.put("\u0442\u043e\u043d", 944);
    freq.put("\u0442\u043e\u043c", 830);
    freq.put("\u0443\u0433\u0301", 407);
    freq.put("\u0442\u043e\u0432", 635);
    freq.put("\u0442\u043e\u0430", 832);
    freq.put("\u0436\u0443", 939);
    freq.put("\u0440\u0447\u043a", 744);
    freq.put("\u0447\u043e\u0432", 406);
    freq.put("\u043d\u0435\u0437", 398);
    freq.put("\u043d\u0435\u0433", 1025);
    freq.put("\u043d\u0435\u043d", 441);
    freq.put("\u043d\u0435\u043a", 1134);
    freq.put("\u043a\u0438\u0442", 2518);
    freq.put("ve", 297);
    freq.put("\u043c\u0443 ", 324);
    freq.put("\u0411", 5118);
    freq.put("\u0442\u0441\u0442", 1499);
    freq.put("\u043a\u0430\u0440", 1133);
    freq.put(" \u0448\u043f", 318);
    freq.put("\u0442\u0443\u0434", 444);
    freq.put("\u043e\u0438 ", 2794);
    freq.put("\u043a\u0301\u0438 ", 636);
    freq.put("\u041d", 3704);
    freq.put("\u043d\u0443\u0432", 1506);
    freq.put("\u0435\u043c\u0458", 955);
    freq.put("\u0437\u043d\u0438", 663);
    freq.put("\u043c\u0430\u043b", 1112);
    freq.put("\u043c\u0430\u043a", 1628);
    freq.put("\u0437\u043d\u0430", 3413);
    freq.put("\u043c\u0430\u0430", 339);
    freq.put("\u043c\u0430\u0448", 335);
    freq.put("\u043c\u0430\u0442", 1625);
    freq.put("\u043c\u0430\u0441", 309);
    freq.put("\u043c\u0430\u0440", 614);
    freq.put("ion", 475);
    freq.put("\u0435\u043c\u0438", 2065);
    freq.put("\u0435\u043c\u043e", 621);
    freq.put("\u043c\u0430\u0458", 590);
    freq.put("\u0435\u043c\u0432", 738);
    freq.put("\u0435\u043c\u0430", 1276);
    freq.put("\u0435\u043c\u0435", 2170);
    freq.put("\u0443\u0441\u043a", 1016);
    freq.put("\u0442\u0441\u0435", 374);
    freq.put("\u0447\u0438 ", 884);
    freq.put("i", 8516);
    freq.put("\u0442\u0441\u043a", 1871);
    freq.put("\u043d\u0433 ", 468);
    freq.put("\u0435\u0441 ", 859);
    freq.put("\u043a\u0438\u043d", 368);
    freq.put("\u0435\u0442\u043e", 5033);
    freq.put("\u043a\u0438\u043e", 3400);
    freq.put("\u0435\u043a\u0301", 923);
    freq.put("\u0435\u0458", 2932);
    freq.put("\u0435\u045a", 1526);
    freq.put("\u0432\u0443", 2258);
    freq.put("\u0435\u0433\u0301", 1275);
    freq.put("\u0443\u0433\u043e", 905);
    freq.put("\u0435\u0448", 2657);
    freq.put("\u0445\u0440\u0438", 386);
    freq.put("\u0435\u0445", 563);
    freq.put("\u0435\u0444", 889);
    freq.put("\u0435\u0447", 1979);
    freq.put("\u0435\u0446", 1329);
    freq.put("\u0435\u0441", 8709);
    freq.put("\u0435\u0440", 16613);
    freq.put("\u0435\u0442", 17396);
    freq.put("\u043a\u0301\u0435", 1037);
    freq.put("\u043a\u0301\u0430", 686);
    freq.put("\u043a\u0301\u0438", 734);
    freq.put("\u0438\u0431", 811);
    freq.put("\u0432 ", 3431);
    freq.put("\u043c", 56196);
    freq.put("\u0435\u043a ", 1095);
    freq.put("T", 883);
    freq.put("\u0435\u043d", 28920);
    freq.put("\u0435\u043c", 9666);
    freq.put("\u0435\u043f", 2846);
    freq.put("\u0435\u043e", 1987);
    freq.put("\u0435\u0438", 513);
    freq.put("\u0435\u043b", 15327);
    freq.put("\u0435\u043a", 11126);
    freq.put("\u0435\u0435", 663);
    freq.put("\u0435\u0434", 16863);
    freq.put("\u0435\u0437", 2727);
    freq.put("\u0435\u0436", 1162);
    freq.put("\u0435\u0431", 1885);
    freq.put("\u0435\u0430", 1309);
    freq.put("\u0435\u0433", 3639);
    freq.put("\u0435\u0432", 5864);
    freq.put("\u0438\u0432\u043d", 1457);
    freq.put("\u0438\u0432\u043e", 1058);
    freq.put("\u0438\u0432\u0438", 638);
    freq.put("\u0438\u0432\u0435", 1425);
    freq.put("\u0438\u0432\u0430", 1008);
    freq.put("\u041e\u0432\u043e", 374);
    freq.put("a ", 2176);
    freq.put("\u0446\u0435\u043b", 738);
    freq.put("\u041e\u0432\u0430", 565);
    freq.put("\u043f\u0430\u0434", 1381);
    freq.put("\u0434\u043d\u0438", 2521);
    freq.put("\u0448\u0442", 6867);
    freq.put("\u043f\u0430\u043d", 956);
    freq.put("\u043f\u0430\u043a", 283);
    freq.put("\u043a\u0443 ", 1035);
    freq.put("\u0427", 767);
    freq.put("\u043b\u0458", 325);
    freq.put("\u043e\u0435\u0442", 296);
    freq.put("\u043b\u0443", 4631);
    freq.put("\u043b\u0442", 1426);
    freq.put("\u043b\u0441", 1887);
    freq.put("\u0438\u0447\u043d", 2026);
    freq.put("\u0438\u0447\u043a", 3274);
    freq.put("\u0438\u0447\u0438", 380);
    freq.put("\u0438\u0447\u0435", 543);
    freq.put("\u0438\u0447\u0430", 867);
    freq.put("\u043b\u0433", 660);
    freq.put("\u043b\u0431", 1321);
    freq.put("\u043b\u0430", 14718);
    freq.put("\u043b\u0436", 375);
    freq.put("\u043b\u0435", 15180);
    freq.put("\u043b\u0434", 283);
    freq.put("\u043b\u043a", 1166);
    freq.put("\u043b\u0438", 21964);
    freq.put("\u043b\u043e", 11112);
    freq.put("\u043b\u043d", 4295);
    freq.put("\u043b\u043c", 650);
    freq.put("\u043e\u0435\u043c", 310);
    freq.put("\u043e\u0435\u043d", 405);
    freq.put("\u043e\u0435\u0434", 304);
    freq.put("\u0448\u043a", 1724);
    freq.put("\u0421\u0435 ", 508);
    freq.put("\u0430\u043b ", 2115);
    freq.put("\u043f\u0430\u0440", 1020);
    freq.put("\u0448\u043f", 336);
    freq.put("\u043f\u0430\u0442", 1339);
    freq.put("\u0448\u043d", 1414);
    freq.put("\u0448\u0430", 1244);
    freq.put("\u043e\u0448\u043a", 618);
    freq.put("\u043f\u0430\u0433\u0301", 517);
    freq.put("\u0435\u0442\u0440", 679);
    freq.put("\u0414\u043e", 567);
    freq.put("\u043e\u043b\u0441", 527);
    freq.put("\u043e\u043b\u0443", 1982);
    freq.put("\u0414\u0438", 461);
    freq.put(" \u041d\u0435", 717);
    freq.put("\u0414\u0435", 856);
    freq.put("\u0414\u0430", 437);
    freq.put("\u0412", 4777);
    freq.put("h ", 457);
    freq.put(" \u0438\u043b", 3716);
    freq.put(" \u0438\u043d", 1410);
    freq.put(" \u0438\u043c", 3303);
    freq.put(" \u0438\u0433", 813);
    freq.put(" \u0438\u0437", 2798);
    freq.put("\u0430\u0444\u0441", 366);
    freq.put("\u0430\u0444\u0438", 298);
    freq.put(" \u0438\u0442", 411);
    freq.put(" \u0438\u0441", 2928);
    freq.put("hi", 303);
    freq.put("ha", 360);
    freq.put("\u043a\u0301", 2840);
    freq.put("he", 719);
    freq.put("j", 528);
    freq.put("\u043e\u043b\u0430", 807);
    freq.put("\u043e\u043b\u0433", 289);
    freq.put("\u043e\u043b\u0435", 2647);
    freq.put("\u043e\u043b\u0436", 334);
    freq.put("\u043e\u043b\u0438", 2456);
    freq.put("\u043e\u043b\u043a", 576);
    freq.put("\u043e\u043b\u043d", 609);
    freq.put("\u043e\u043b\u043e", 2164);
    freq.put(" \u043a\u0301\u0435", 299);
    freq.put("\u043b\u0442\u0443", 424);
    freq.put("\u0458\u0447\u0435", 337);
    freq.put("\u043d\u0442\u0440", 628);
    freq.put("\u0435\u0442\u0435", 797);
    freq.put("\u0440\u0448\u0438", 562);
    freq.put("\u0435\u0442\u0430", 1622);
    freq.put("\u0435\u0442\u043d", 1147);
    freq.put("\u0441\u0438\u0458", 608);
    freq.put("\u0435\u0442\u0438", 1694);
    freq.put("\u0435\u0442\u043a", 321);
    freq.put("\u0441\u0438\u0442", 795);
    freq.put("\u043d\u0434\u0438", 607);
    freq.put("\u0441\u0438\u0441", 839);
    freq.put("\u043d\u0434\u043e", 434);
    freq.put("es", 758);
    freq.put("\u043d\u0434\u0430", 719);
    freq.put("\u0438\u0435", 3605);
    freq.put("\u043d", 193670);
    freq.put("\u0437 ", 1486);
    freq.put("\u0441\u0438\u043b", 492);
    freq.put("\u0441\u0438\u043c", 340);
    freq.put("\u0441\u0438\u043d", 510);
    freq.put("\u0435\u0442\u0445", 473);
    freq.put("U", 346);
    freq.put("\u0435\u0442\u0441", 2563);
    freq.put("\u043e\u0446\u0438", 931);
    freq.put("\u043d\u0442\u043e", 379);
    freq.put("\u043d\u0442\u0438", 1942);
    freq.put("\u0442\u043f\u0440", 359);
    freq.put("\u043d\u0442\u0435", 740);
    freq.put("\u043d\u0442\u0430", 1389);
    freq.put("\u0444 ", 405);
    freq.put("\u043c\u0431\u043e", 288);
    freq.put("\u0437\u043c\u043e", 513);
  }
  
}

