package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class LV extends CLangProfile {
  private static final String name = "lv";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public LV() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2106271;
    n_words[1] = 2428959;
    n_words[2] = 2036825;

    freq.put("IX ", 48);
    freq.put("ia\u0304n\u0327", 39);
    freq.put("dni\u0304", 68);
    freq.put("NO ", 49);
    freq.put("Lu\u0304", 27);
    freq.put("i\u0304sa\u0304", 29);
    freq.put("n\u0327a\u0304 ", 197);
    freq.put("HL ", 22);
    freq.put("n\u0327a\u0304s", 22);
    freq.put("Li\u0304", 215);
    freq.put("lmu", 99);
    freq.put("n\u0327a\u0304m", 78);
    freq.put("La\u0304", 40);
    freq.put("k", 78380);
    freq.put("Le\u0304", 28);
    freq.put("A\u0304", 409);
    freq.put("ia\u0304n", 89);
    freq.put("ia\u0304c", 169);
    freq.put("dne", 44);
    freq.put("dni", 257);
    freq.put("una\u0304", 343);
    freq.put("i\u0304z ", 81);
    freq.put("voj", 423);
    freq.put("Le", 274);
    freq.put("i\u0304s\u030cu", 52);
    freq.put("La", 2106);
    freq.put("Lo", 258);
    freq.put("Li", 1187);
    freq.put("Lu", 187);
    freq.put("Ly", 26);
    freq.put("hon", 30);
    freq.put("hol", 226);
    freq.put("hom", 35);
    freq.put("hok", 186);
    freq.put("hot", 32);
    freq.put("hor", 75);
    freq.put("i\u0304s ", 468);
    freq.put("hop", 25);
    freq.put("uco", 23);
    freq.put("A", 5495);
    freq.put("\u0645", 47);
    freq.put("L ", 193);
    freq.put("\u03bf\u03c2 ", 59);
    freq.put("le\u0304c", 25);
    freq.put("i\u0304st", 852);
    freq.put(" c\u030ca", 23);
    freq.put("i\u0304ss", 36);
    freq.put("u\u0304", 7903);
    freq.put("i\u0304sa", 30);
    freq.put("i\u0304sl", 28);
    freq.put("i\u0304si", 181);
    freq.put("i\u0304sk", 119);
    freq.put("nze\u0304", 40);
    freq.put(" V ", 48);
    freq.put("a\u0304zi", 216);
    freq.put("zam", 111);
    freq.put("AP ", 26);
    freq.put("a\u0304s\u030ca", 527);
    freq.put("Hip", 27);
    freq.put("fis", 214);
    freq.put("His", 22);
    freq.put("Hit", 49);
    freq.put("fiz", 287);
    freq.put("zai", 49);
    freq.put("le\u0304t", 383);
    freq.put("fic", 294);
    freq.put("fig", 49);
    freq.put("fij", 235);
    freq.put("fik", 181);
    freq.put("Hil", 23);
    freq.put("Him", 40);
    freq.put("fil", 435);
    freq.put(" Va", 790);
    freq.put(" Ve", 526);
    freq.put("es\u030co", 30);
    freq.put("upo", 29);
    freq.put(" Vi", 1347);
    freq.put(" Vl", 38);
    freq.put(" Vo", 205);
    freq.put(" Vu", 40);
    freq.put("sa\u0304n", 37);
    freq.put("es\u030cs", 32);
    freq.put("es\u030cu", 1242);
    freq.put("es\u030cv", 29);
    freq.put("fi ", 28);
    freq.put("mdo", 23);
    freq.put("mda", 33);
    freq.put("mde", 27);
    freq.put("lpa\u0304", 54);
    freq.put("rt", 4290);
    freq.put("ru", 7404);
    freq.put("rv", 1310);
    freq.put("rp", 1821);
    freq.put("rr", 239);
    freq.put("rs", 5613);
    freq.put("smu", 340);
    freq.put("sms", 242);
    freq.put("ry", 160);
    freq.put("rz", 732);
    freq.put("smo", 229);
    freq.put("re", 6968);
    freq.put("rf", 127);
    freq.put("rg", 2074);
    freq.put("ra", 18562);
    freq.put("rb", 2090);
    freq.put("rc", 590);
    freq.put("rl", 568);
    freq.put("rm", 3278);
    freq.put("rn", 1729);
    freq.put("ro", 10142);
    freq.put("rh", 439);
    freq.put("ri", 15479);
    freq.put("rj", 126);
    freq.put("rk", 1664);
    freq.put("se\u0304t", 1211);
    freq.put("atf", 33);
    freq.put("atg", 171);
    freq.put("atd", 107);
    freq.put("ate", 661);
    freq.put("atb", 314);
    freq.put("atc", 32);
    freq.put("ata", 845);
    freq.put("atn", 153);
    freq.put("ato", 1405);
    freq.put("atl", 205);
    freq.put("atm", 195);
    freq.put("atj", 54);
    freq.put("atk", 493);
    freq.put("ath", 38);
    freq.put("ati", 895);
    freq.put("atv", 2153);
    freq.put("att", 979);
    freq.put("atu", 973);
    freq.put("r ", 23056);
    freq.put("ats", 614);
    freq.put("atp", 124);
    freq.put("atz", 132);
    freq.put("ds ", 1372);
    freq.put("Dub", 30);
    freq.put("es\u030ck\u0327", 123);
    freq.put(" Va\u0304", 354);
    freq.put("es\u030ca\u0304", 114);
    freq.put("Cen", 195);
    freq.put("l\u0327u\u0304t", 29);
    freq.put("Cel", 26);
    freq.put("l\u0327u\u0304s", 33);
    freq.put(" Ve\u0304", 121);
    freq.put("Cet", 27);
    freq.put("Cer", 41);
    freq.put("l\u0327u\u0304d", 92);
    freq.put("s\u030ci\u0304b", 168);
    freq.put("ti\u0304v", 934);
    freq.put("i\u0301", 35);
    freq.put("nza", 50);
    freq.put("nzi", 41);
    freq.put("nzo", 53);
    freq.put("bi\u0304d", 30);
    freq.put("bi\u0304g", 65);
    freq.put("z\u030coj", 249);
    freq.put("bi\u0304b", 430);
    freq.put("ata\u0304", 330);
    freq.put("bi\u0304n", 33);
    freq.put("bi\u0304t", 96);
    freq.put("rn\u0327", 171);
    freq.put("ate\u0304", 140);
    freq.put("bi\u0304r", 30);
    freq.put("bi\u0304s", 120);
    freq.put("\u30a2", 23);
    freq.put("Ast", 53);
    freq.put("se\u0304m", 89);
    freq.put("rz\u030c", 79);
    freq.put("ati\u0304", 1487);
    freq.put("rs\u030c", 1224);
    freq.put("Asi", 33);
    freq.put("Aso", 76);
    freq.put("ru\u0304", 541);
    freq.put("atn\u0327", 23);
    freq.put("\u0445", 31);
    freq.put("re\u0304", 1505);
    freq.put("sme\u0304", 44);
    freq.put("ra\u0304", 7122);
    freq.put("sma\u0304", 173);
    freq.put("mi\u0304g", 202);
    freq.put("rk\u0327", 279);
    freq.put("mi\u0304b", 243);
    freq.put("ats\u030c", 186);
    freq.put("rl\u0327", 24);
    freq.put("mi\u0304n", 84);
    freq.put("lpu", 76);
    freq.put("mi\u0304l", 44);
    freq.put("mi\u0304k", 32);
    freq.put("atu\u0304", 468);
    freq.put("lpo", 192);
    freq.put("mi\u0304t", 118);
    freq.put("smi\u0304", 51);
    freq.put("lpi", 52);
    freq.put("rg\u0327", 265);
    freq.put("lpe", 42);
    freq.put("lpa", 98);
    freq.put("ri\u0304", 5569);
    freq.put("se\u0304n", 52);
    freq.put("oi\u0304d", 99);
    freq.put("zti", 66);
    freq.put("zte", 106);
    freq.put("ta\u0304z\u030c", 25);
    freq.put("ta\u0304s\u030c", 25);
    freq.put("ztu", 134);
    freq.put("ztv", 96);
    freq.put("fre\u0304", 39);
    freq.put("X", 234);
    freq.put("fri\u0304", 26);
    freq.put("Rie", 159);
    freq.put("a\u0304ks", 485);
    freq.put("PS ", 25);
    freq.put("n\u0327ji", 23);
    freq.put("a\u0304ku", 495);
    freq.put("a\u0304kt", 61);
    freq.put("a\u0304ki", 268);
    freq.put("a\u0304ko", 642);
    freq.put("a\u0304ka", 1716);
    freq.put("irz", 314);
    freq.put("irr", 24);
    freq.put("irs", 599);
    freq.put("irt", 236);
    freq.put("iru", 216);
    freq.put("iri", 558);
    freq.put("irk", 171);
    freq.put("irm", 929);
    freq.put("irn", 124);
    freq.put("iro", 905);
    freq.put("ira", 259);
    freq.put("irb", 90);
    freq.put("irc", 39);
    freq.put("ird", 185);
    freq.put("ire", 99);
    freq.put("irg", 402);
    freq.put("tzi\u0304", 84);
    freq.put("a\u0304k ", 1029);
    freq.put("l\u0327e\u0304j", 87);
    freq.put("ir ", 14672);
    freq.put("pre", 942);
    freq.put("s\u030cru", 52);
    freq.put("ta\u0304t", 740);
    freq.put("SR ", 106);
    freq.put("ta\u0304p", 79);
    freq.put("fre", 65);
    freq.put("ta\u0304s", 1054);
    freq.put("fri", 213);
    freq.put("fro", 69);
    freq.put("ta\u0304z", 22);
    freq.put("ta\u0304d", 527);
    freq.put("ta\u0304c", 148);
    freq.put("ta\u0304l", 1306);
    freq.put("ta\u0304m", 538);
    freq.put("ta\u0304n", 411);
    freq.put("pro", 1797);
    freq.put("ta\u0304j", 1760);
    freq.put("ta\u0304k", 538);
    freq.put("pri", 1091);
    freq.put("kte", 51);
    freq.put("n\u0327i", 716);
    freq.put("ant", 1775);
    freq.put("ta\u0304 ", 2912);
    freq.put("ug\u0327", 166);
    freq.put("rk\u0327e", 31);
    freq.put("rk\u0327i", 179);
    freq.put("bil", 410);
    freq.put("tza", 38);
    freq.put("ld ", 81);
    freq.put("rk\u0327u", 27);
    freq.put("tzi", 22);
    freq.put("a\u0304ks\u030c", 30);
    freq.put("Tra", 108);
    freq.put("ua\u0304r", 73);
    freq.put("ua\u0304l", 181);
    freq.put("irs\u030c", 41);
    freq.put("ua\u0304c", 50);
    freq.put("\u0441", 262);
    freq.put("bie", 860);
    freq.put("a\u0304kl\u0327", 103);
    freq.put("ire\u0304", 31);
    freq.put("jko", 24);
    freq.put("ira\u0304", 703);
    freq.put("iri\u0304", 150);
    freq.put("a\u0304ka\u0304", 884);
    freq.put("sos\u030c", 166);
    freq.put("ia\u0304l", 1004);
    freq.put("aza\u0304", 276);
    freq.put("s\u030ck\u0327u", 61);
    freq.put("c\u030cu ", 517);
    freq.put("s\u030ck\u0327i", 792);
    freq.put("s\u030ck\u0327e", 37);
    freq.put("Div", 37);
    freq.put("s\u030ck\u0327a", 58);
    freq.put("hai", 42);
    freq.put("azi\u0304", 447);
    freq.put("hal", 100);
    freq.put("ham", 85);
    freq.put("han", 159);
    freq.put("son\u0327", 53);
    freq.put("hae", 23);
    freq.put("bni", 61);
    freq.put("har", 152);
    freq.put("has", 51);
    freq.put("hat", 24);
    freq.put("hau", 35);
    freq.put("uz\u030c", 113);
    freq.put("ha ", 116);
    freq.put("eb ", 1292);
    freq.put("ola", 1498);
    freq.put("olb", 29);
    freq.put("old", 135);
    freq.put("ole", 441);
    freq.put("olf", 57);
    freq.put("olg", 32);
    freq.put("I\u0304sl", 26);
    freq.put("oli", 1155);
    freq.put(" X ", 41);
    freq.put("oll", 82);
    freq.put("olm", 107);
    freq.put("oln", 31);
    freq.put("olo", 1146);
    freq.put("ols", 417);
    freq.put("olt", 46);
    freq.put("olu", 413);
    freq.put("fot", 77);
    freq.put("umt", 47);
    freq.put("umv", 39);
    freq.put("ump", 111);
    freq.put("for", 1089);
    freq.put("fos", 41);
    freq.put("ume", 317);
    freq.put("umd", 66);
    freq.put("uma", 1511);
    freq.put("umb", 191);
    freq.put("fol", 75);
    freq.put("uml", 29);
    freq.put("fon", 280);
    freq.put("umn", 30);
    freq.put("umi", 1048);
    freq.put("\u03bf\u03c2", 59);
    freq.put("Ce\u0304s", 56);
    freq.put("ol ", 51);
    freq.put("N\u0327", 124);
    freq.put("ja\u0304d", 51);
    freq.put("ms\u030ca", 94);
    freq.put("o", 88352);
    freq.put("um ", 175);
    freq.put("mbl", 29);
    freq.put("Fed", 124);
    freq.put("mbo", 287);
    freq.put("sod", 41);
    freq.put("sof", 59);
    freq.put("Fen", 23);
    freq.put("mbe", 47);
    freq.put("Fel", 22);
    freq.put("soj", 40);
    freq.put("som", 91);
    freq.put("sol", 116);
    freq.put("son", 503);
    freq.put("sos", 35);
    freq.put("sor", 227);
    freq.put("Fer", 33);
    freq.put("sot", 106);
    freq.put("sov", 22);
    freq.put("IV ", 42);
    freq.put("n\u0327in", 63);
    freq.put("mbr", 158);
    freq.put("az ", 62);
    freq.put("so ", 75);
    freq.put("\u03c3", 41);
    freq.put("ku\u0304v", 24);
    freq.put("n\u0327i ", 361);
    freq.put("s\u030ck\u0327i\u0304", 179);
    freq.put("azi", 230);
    freq.put("azm", 31);
    freq.put("azn", 207);
    freq.put("azo", 137);
    freq.put("aza", 217);
    freq.put("s\u030ck\u0327e\u0304", 67);
    freq.put("aze", 46);
    freq.put("azs", 68);
    freq.put("azu", 55);
    freq.put("s\u030ck\u0327a\u0304", 29);
    freq.put("Sir", 32);
    freq.put("u\u0304do", 28);
    freq.put("u\u0304de", 716);
    freq.put("olu\u0304", 125);
    freq.put("u\u0304da", 90);
    freq.put("Sib", 28);
    freq.put("Sig", 27);
    freq.put("Sie", 22);
    freq.put("kho", 57);
    freq.put("u\u0304du", 26);
    freq.put("Sin", 63);
    freq.put("Sim", 41);
    freq.put("Sil", 58);
    freq.put("ums\u030c", 52);
    freq.put("E", 2166);
    freq.put("ume\u0304", 24);
    freq.put("oli\u0304", 129);
    freq.put("uma\u0304", 913);
    freq.put("ola\u0304", 244);
    freq.put("ole\u0304", 98);
    freq.put("umi\u0304", 24);
    freq.put("osp", 73);
    freq.put("oss", 48);
    freq.put("osu", 40);
    freq.put("ost", 506);
    freq.put("osi", 149);
    freq.put("osk", 156);
    freq.put("osm", 456);
    freq.put("per", 1152);
    freq.put("oso", 109);
    freq.put("osa", 935);
    freq.put("ose", 88);
    freq.put("osf", 203);
    freq.put("Ju\u0304l", 32);
    freq.put("vet", 45);
    freq.put("ver", 992);
    freq.put("ves", 531);
    freq.put("ved", 123);
    freq.put("vec", 250);
    freq.put("ven", 961);
    freq.put("vel", 158);
    freq.put("un", 12883);
    freq.put("vej", 30);
    freq.put("vek", 42);
    freq.put("vei", 2843);
    freq.put("ipi\u0304", 32);
    freq.put("os ", 3856);
    freq.put("Tau", 65);
    freq.put("Tar", 26);
    freq.put("Tas", 583);
    freq.put(" gu\u0304", 38);
    freq.put("ipe\u0304", 33);
    freq.put("ve ", 176);
    freq.put("Tal", 71);
    freq.put("Tam", 51);
    freq.put("Tan", 40);
    freq.put("Tai", 63);
    freq.put("Taj", 81);
    freq.put("Tak", 27);
    freq.put("M ", 140);
    freq.put("se\u0304", 2104);
    freq.put("sa\u0304", 1658);
    freq.put("ka\u0304n\u0327", 216);
    freq.put("zru", 92);
    freq.put("si\u0304", 1152);
    freq.put("zra", 210);
    freq.put("Me", 656);
    freq.put("Ma", 1352);
    freq.put("Mo", 497);
    freq.put("Mi", 487);
    freq.put("Mu", 257);
    freq.put("O", 1507);
    freq.put("My", 39);
    freq.put("su\u0304", 160);
    freq.put("ipa", 229);
    freq.put("ipe", 167);
    freq.put("ak\u0327u", 37);
    freq.put("ipi", 127);
    freq.put("ipo", 63);
    freq.put("ipl", 132);
    freq.put("ipr", 208);
    freq.put("ips", 96);
    freq.put("osu\u0304", 27);
    freq.put("ipt", 115);
    freq.put("ipu", 70);
    freq.put("ak\u0327e", 127);
    freq.put("ugo", 30);
    freq.put("ves\u030c", 46);
    freq.put("\u03b5", 43);
    freq.put("og\u0327i", 861);
    freq.put("ip ", 24);
    freq.put("mba", 149);
    freq.put("osa\u0304", 36);
    freq.put("gzn", 376);
    freq.put("gzd", 28);
    freq.put("Mi\u0304", 29);
    freq.put("u\u0304n", 373);
    freq.put("Ma\u0304", 133);
    freq.put("Me\u0304", 139);
    freq.put("s ", 99264);
    freq.put("Mu\u0304", 173);
    freq.put("zra\u0304", 47);
    freq.put("U\u0304d", 31);
    freq.put("sz", 152);
    freq.put("sy", 29);
    freq.put("ss", 1501);
    freq.put("sr", 95);
    freq.put("sp", 4072);
    freq.put("sw", 23);
    freq.put("sv", 864);
    freq.put("su", 2355);
    freq.put("st", 22568);
    freq.put("sk", 10907);
    freq.put("sj", 78);
    freq.put("si", 5921);
    freq.put("sh", 197);
    freq.put("so", 1970);
    freq.put("sn", 958);
    freq.put("sm", 2964);
    freq.put("sl", 2038);
    freq.put("sc", 379);
    freq.put("sb", 260);
    freq.put("sa", 11922);
    freq.put("sg", 86);
    freq.put("sf", 321);
    freq.put("se", 3495);
    freq.put("sd", 451);
    freq.put("n\u0327ra", 135);
    freq.put(" Zi\u0304", 28);
    freq.put("ttp", 39);
    freq.put("\u044f ", 56);
    freq.put("tti", 291);
    freq.put("tto", 22);
    freq.put("ttl", 22);
    freq.put("tta", 34);
    freq.put("nes\u030c", 108);
    freq.put("tte", 67);
    freq.put("jie", 1464);
    freq.put("s\u030ca ", 338);
    freq.put("rzi\u0304", 41);
    freq.put("jis", 272);
    freq.put("uks\u030c", 120);
    freq.put("hos", 37);
    freq.put("oni\u0304", 135);
    freq.put("Z\u030ce", 35);
    freq.put("Z\u030ca", 46);
    freq.put("tt ", 106);
    freq.put("Z\u030ci", 23);
    freq.put("uka\u0304", 121);
    freq.put("ji ", 637);
    freq.put("s\u030cam", 126);
    freq.put("s\u030can", 3757);
    freq.put("s\u030cai", 236);
    freq.put("s\u030cah", 27);
    freq.put("s\u030caj", 205);
    freq.put("s\u030cau", 228);
    freq.put("s\u030cas", 321);
    freq.put("one\u0304", 180);
    freq.put("l\u0327sk", 34);
    freq.put("saz\u030c", 44);
    freq.put("c\u030cs ", 40);
    freq.put("Jor", 27);
    freq.put("ps\u030cu", 22);
    freq.put("san\u0327", 59);
    freq.put("ps\u030ca", 33);
    freq.put("blo", 48);
    freq.put("bli", 610);
    freq.put("ble", 47);
    freq.put("bla", 73);
    freq.put("Jon", 25);
    freq.put("sai\u0304", 148);
    freq.put("tri\u0304", 313);
    freq.put("e\u0304du", 26);
    freq.put("e\u0304dz", 296);
    freq.put("ps\u030c ", 215);
    freq.put("e\u0304de", 49);
    freq.put("e\u0304da", 98);
    freq.put("e\u0304di", 142);
    freq.put("jin\u0327", 29);
    freq.put("onk", 159);
    freq.put("oni", 1530);
    freq.put("onn", 56);
    freq.put("ono", 626);
    freq.put("onc", 136);
    freq.put("ona", 1194);
    freq.put("onf", 111);
    freq.put(" Z ", 22);
    freq.put("ond", 224);
    freq.put("one", 173);
    freq.put("onz", 36);
    freq.put("ony", 39);
    freq.put("onr", 30);
    freq.put("ons", 1271);
    freq.put("onv", 60);
    freq.put("ont", 491);
    freq.put("onu", 567);
    freq.put("mez\u030c", 103);
    freq.put("uku", 836);
    freq.put("ukt", 791);
    freq.put("uks", 271);
    freq.put("uko", 36);
    freq.put("ukl", 91);
    freq.put("uki", 42);
    freq.put("ukc", 69);
    freq.put("uka", 140);
    freq.put(" Zo", 72);
    freq.put(" Zi", 551);
    freq.put(" c\u030ce", 400);
    freq.put(" Ze", 604);
    freq.put("on ", 659);
    freq.put(" Za", 124);
    freq.put("tti\u0304", 266);
    freq.put(" Zu", 31);
    freq.put(" Zv", 222);
    freq.put("rze", 250);
    freq.put("rza", 50);
    freq.put("tte\u0304", 198);
    freq.put("rzi", 284);
    freq.put("rzs", 23);
    freq.put("tta\u0304", 196);
    freq.put("sak", 466);
    freq.put("saj", 138);
    freq.put("sai", 857);
    freq.put("san", 223);
    freq.put("sam", 248);
    freq.put("e\u0304de\u0304", 151);
    freq.put("sac", 442);
    freq.put("sab", 330);
    freq.put("sag", 154);
    freq.put("sad", 310);
    freq.put("saz", 48);
    freq.put(" Ci", 203);
    freq.put("e\u0304da\u0304", 27);
    freq.put("sas", 1660);
    freq.put("sar", 747);
    freq.put("sap", 162);
    freq.put("sav", 1100);
    freq.put("n\u0327oj", 49);
    freq.put("sat", 285);
    freq.put("zob", 42);
    freq.put("zod", 22);
    freq.put("zof", 144);
    freq.put("lna", 214);
    freq.put("zol", 154);
    freq.put("zom", 26);
    freq.put("zon", 281);
    freq.put("zop", 22);
    freq.put("ldi\u0304", 542);
    freq.put("ax ", 25);
    freq.put("zos", 43);
    freq.put("zot", 69);
    freq.put("sa ", 1042);
    freq.put("ble\u0304", 52);
    freq.put("z\u030ci\u0304m", 24);
    freq.put("zo ", 48);
    freq.put("\u0627\u0644", 32);
    freq.put("bli\u0304", 48);
    freq.put("Sku", 25);
    freq.put("Ska", 110);
    freq.put("Sko", 119);
    freq.put(" s\u030cu\u0304", 130);
    freq.put("li\u0304 ", 122);
    freq.put("vid", 1832);
    freq.put(" s\u030ca\u0304", 147);
    freq.put("zpe\u0304", 51);
    freq.put("ux", 47);
    freq.put("li\u0304n", 460);
    freq.put("li\u0304m", 186);
    freq.put("li\u0304j", 172);
    freq.put("a\u0304su", 62);
    freq.put("li\u0304g", 392);
    freq.put("li\u0304d", 1562);
    freq.put("uz", 3239);
    freq.put("li\u0304b", 213);
    freq.put("li\u0304c", 164);
    freq.put("uu", 163);
    freq.put("li\u0304z", 66);
    freq.put("Ju", 235);
    freq.put("ut", 3554);
    freq.put("li\u0304v", 121);
    freq.put("li\u0304t", 444);
    freq.put("At", 405);
    freq.put("cin", 303);
    freq.put("us", 8406);
    freq.put("\u041b", 28);
    freq.put("cil", 946);
    freq.put("um", 10369);
    freq.put(" b ", 53);
    freq.put("cir", 29);
    freq.put(" K\u0327i\u0304", 169);
    freq.put("a\u0304sa", 252);
    freq.put("n\u0327g\u0327", 77);
    freq.put("uh", 49);
    freq.put("fir", 37);
    freq.put("ciu", 34);
    freq.put("uor", 22);
    freq.put("uj", 549);
    freq.put("ivi\u0304", 107);
    freq.put("a\u0304si", 27);
    freq.put(" be", 1390);
    freq.put(" ba", 1482);
    freq.put("iva\u0304", 236);
    freq.put(" bl", 146);
    freq.put(" bo", 133);
    freq.put(" bi", 2895);
    freq.put(" bu", 382);
    freq.put("s", 178123);
    freq.put(" br", 766);
    freq.put("li\u0304c\u030c", 64);
    freq.put("ma\u0304n\u0327", 51);
    freq.put(" s\u030ca", 314);
    freq.put(" s\u030ce", 87);
    freq.put(" s\u030ci", 160);
    freq.put("zpr", 45);
    freq.put(" s\u030co", 253);
    freq.put("zpi", 173);
    freq.put(" s\u030ct", 206);
    freq.put("zpl", 262);
    freq.put("zpa", 78);
    freq.put("Je\u0304k", 140);
    freq.put("Je\u0304z", 37);
    freq.put("fin", 189);
    freq.put("li\u0304s\u030c", 88);
    freq.put("ivd", 29);
    freq.put("ive", 291);
    freq.put(" ba\u0304", 233);
    freq.put("iva", 204);
    freq.put("ivo", 171);
    freq.put("ivi", 487);
    freq.put("ivj", 45);
    freq.put("ivk", 27);
    freq.put("ivu", 117);
    freq.put("ivv", 36);
    freq.put("ivp", 30);
    freq.put("ivr", 48);
    freq.put("ivs", 26);
    freq.put("Jo", 238);
    freq.put(" bi\u0304", 86);
    freq.put("es\u030ca", 400);
    freq.put("\u03b4", 42);
    freq.put("tkr", 96);
    freq.put("\u044c ", 24);
    freq.put("I", 2327);
    freq.put("es\u030cd", 35);
    freq.put(" gu", 155);
    freq.put("Mat", 72);
    freq.put(" K\u0327e", 55);
    freq.put(" bu\u0304", 407);
    freq.put("eg\u0327e", 52);
    freq.put("eg\u0327i", 394);
    freq.put("u\u0304mu", 36);
    freq.put("SV ", 351);
    freq.put("Ni\u0304", 78);
    freq.put("Mak", 70);
    freq.put("Na\u0304", 75);
    freq.put("as\u030c", 1551);
    freq.put("ezt", 29);
    freq.put("ezu", 188);
    freq.put("ezv", 29);
    freq.put("ezp", 31);
    freq.put("ezm", 33);
    freq.put("ezn", 141);
    freq.put("ezo", 141);
    freq.put("tvi", 1976);
    freq.put("ezi", 201);
    freq.put("ezk", 125);
    freq.put("ezd", 35);
    freq.put("eze", 817);
    freq.put("ezg", 53);
    freq.put("tva", 158);
    freq.put("eza", 38);
    freq.put("az\u030c", 1131);
    freq.put("ac ", 37);
    freq.put("an\u0327", 799);
    freq.put(" z\u030cu", 96);
    freq.put(" z\u030ca", 153);
    freq.put("dda", 35);
    freq.put(" z\u030ce", 29);
    freq.put("Sa\u0304k", 57);
    freq.put("ag\u0327", 126);
    freq.put("rn\u0327u", 41);
    freq.put("ai\u0304", 165);
    freq.put("rn\u0327a", 66);
    freq.put("ak\u0327", 196);
    freq.put("ez ", 111);
    freq.put("al\u0327", 2174);
    freq.put("aa\u0304", 32);
    freq.put("aca", 38);
    freq.put("ace", 507);
    freq.put("ack", 35);
    freq.put("aci", 939);
    freq.put("ach", 47);
    freq.put("ac\u030c", 195);
    freq.put("ae\u0304", 38);
    freq.put("acu", 34);
    freq.put("act", 88);
    freq.put("ly ", 28);
    freq.put("Ni", 163);
    freq.put("bje", 249);
    freq.put("No", 488);
    freq.put("uil", 24);
    freq.put("Na", 331);
    freq.put("Ne", 339);
    freq.put("bju", 45);
    freq.put("\u0629 ", 22);
    freq.put("Nu", 37);
    freq.put("het", 54);
    freq.put("\u043e\u0432\u0438", 22);
    freq.put("her", 196);
    freq.put("\u0432", 222);
    freq.put("hel", 84);
    freq.put("hem", 51);
    freq.put("hen", 64);
    freq.put("heo", 49);
    freq.put("hei", 58);
    freq.put("hek", 42);
    freq.put("ago", 152);
    freq.put("agn", 169);
    freq.put("N ", 114);
    freq.put(" e\u0304z", 45);
    freq.put(" e\u0304r", 63);
    freq.put(" e\u0304t", 31);
    freq.put(" e\u0304k", 65);
    freq.put("he ", 281);
    freq.put(" e\u0304d", 44);
    freq.put("aa", 123);
    freq.put("ac", 1971);
    freq.put("ab", 3333);
    freq.put("ae", 799);
    freq.put("ad", 7331);
    freq.put("ag", 2079);
    freq.put("af", 317);
    freq.put("Hon", 23);
    freq.put("ah", 438);
    freq.put("Hol", 58);
    freq.put("aj", 4377);
    freq.put("am", 7193);
    freq.put("Hok", 34);
    freq.put("ao", 99);
    freq.put("an", 13591);
    freq.put("ap", 6109);
    freq.put("as", 46560);
    freq.put("Hou", 27);
    freq.put("Hor", 54);
    freq.put("at", 15301);
    freq.put("aw", 25);
    freq.put("av", 4016);
    freq.put("ay", 138);
    freq.put("ax", 44);
    freq.put("az", 1867);
    freq.put("ni\u0304j", 53);
    freq.put("ija\u0304", 2772);
    freq.put("aci\u0304", 139);
    freq.put("rn\u0327a\u0304", 31);
    freq.put("du\u0304 ", 66);
    freq.put("a ", 45978);
    freq.put("ezi\u0304", 69);
    freq.put(" zi", 2010);
    freq.put("at ", 261);
    freq.put("tve\u0304", 108);
    freq.put("u\u0304z\u030c", 54);
    freq.put("du\u0304d", 48);
    freq.put("N\u0327u", 43);
    freq.put("tva\u0304", 37);
    freq.put("Fir", 23);
    freq.put("sco", 39);
    freq.put("vis\u030c", 195);
    freq.put("sci", 117);
    freq.put("kla\u0304", 396);
    freq.put("sce", 66);
    freq.put("sca", 22);
    freq.put(" da\u0304", 101);
    freq.put("mni", 192);
    freq.put("kle\u0304", 111);
    freq.put("mna", 27);
    freq.put(" de\u0304", 302);
    freq.put("Fil", 64);
    freq.put("rd", 2322);
    freq.put("zmi", 84);
    freq.put(" di\u0304", 55);
    freq.put("ty", 109);
    freq.put("tv", 2682);
    freq.put("tw", 38);
    freq.put("tt", 1263);
    freq.put("tu", 9581);
    freq.put("tr", 9995);
    freq.put("ts", 7290);
    freq.put("tp", 327);
    freq.put("kli\u0304", 65);
    freq.put("tn", 1900);
    freq.put("to", 9558);
    freq.put("tl", 676);
    freq.put("dsm", 48);
    freq.put("tj", 107);
    freq.put("tk", 771);
    freq.put("th", 431);
    freq.put("ti", 16287);
    freq.put("tf", 75);
    freq.put("tg", 235);
    freq.put("td", 205);
    freq.put("te", 8645);
    freq.put("tb", 1541);
    freq.put("tc", 58);
    freq.put("dsk", 23);
    freq.put("smi", 429);
    freq.put("dsi", 206);
    freq.put("la\u0304n", 215);
    freq.put("sme", 291);
    freq.put("vil\u0327", 118);
    freq.put(" zv", 544);
    freq.put(" s", 20595);
    freq.put("eiv", 56);
    freq.put("vic\u030c", 61);
    freq.put(" dz\u030c", 28);
    freq.put("ga\u0304 ", 654);
    freq.put("pba", 51);
    freq.put("sma", 1140);
    freq.put("t ", 6209);
    freq.put("eiz", 614);
    freq.put("a\u0304rn\u0327", 54);
    freq.put("z\u030cr", 80);
    freq.put("z\u030cs", 96);
    freq.put("z\u030cu", 691);
    freq.put("z\u030ci", 613);
    freq.put("z\u030ck", 75);
    freq.put("z\u030cm", 27);
    freq.put("Smi", 29);
    freq.put("z\u030co", 773);
    freq.put("z\u030ca", 902);
    freq.put("z\u030ce", 338);
    freq.put("ni\u0304s", 25);
    freq.put("a\u0304ps", 37);
    freq.put("la\u0304z", 36);
    freq.put("don\u0327", 93);
    freq.put("z\u030c ", 41);
    freq.put("la\u0304v", 61);
    freq.put("la\u0304p", 55);
    freq.put("la\u0304s", 590);
    freq.put("vic", 31);
    freq.put("via", 49);
    freq.put("vig", 52);
    freq.put("Aug", 149);
    freq.put("vie", 6969);
    freq.put("vij", 2101);
    freq.put("vik", 41);
    freq.put("vin", 313);
    freq.put("vio", 33);
    freq.put("vil", 371);
    freq.put("k\u0327e\u0304n", 27);
    freq.put("vir", 905);
    freq.put("vis", 1620);
    freq.put("Aus", 451);
    freq.put("k\u0327e\u0304r", 58);
    freq.put("Aut", 94);
    freq.put("vit", 157);
    freq.put("tn\u0327", 104);
    freq.put("a\u0304rs\u030c", 275);
    freq.put(" d ", 35);
    freq.put("tu\u0304", 1454);
    freq.put("ts\u030c", 221);
    freq.put("vi ", 493);
    freq.put("te\u0304", 2602);
    freq.put("zme\u0304", 101);
    freq.put("ta\u0304", 11917);
    freq.put(" do", 494);
    freq.put("kle", 136);
    freq.put("tl\u0327", 184);
    freq.put("kla", 494);
    freq.put(" di", 3087);
    freq.put(" de", 1205);
    freq.put("klo", 153);
    freq.put("kli", 573);
    freq.put(" da", 4272);
    freq.put("klu", 183);
    freq.put(" dz", 3456);
    freq.put("kls", 75);
    freq.put(" du", 128);
    freq.put("g\u0327a ", 65);
    freq.put(" dr", 234);
    freq.put("dos\u030c", 285);
    freq.put("RS ", 104);
    freq.put("z\u030cu\u0304", 26);
    freq.put("atr", 1790);
    freq.put("z\u030cn\u0327", 118);
    freq.put("z\u030ci\u0304", 67);
    freq.put("z\u030cg\u0327", 48);
    freq.put("e\u0304g\u0327i", 168);
    freq.put("z\u030ca\u0304", 790);
    freq.put("ito", 983);
    freq.put("itl", 241);
    freq.put("itm", 69);
    freq.put("ith", 30);
    freq.put("iti", 844);
    freq.put("ite", 695);
    freq.put("ita", 561);
    freq.put("ity", 36);
    freq.put("itt", 30);
    freq.put("itu", 694);
    freq.put("itr", 232);
    freq.put("its", 171);
    freq.put("itp", 32);
    freq.put(" Mu", 257);
    freq.put(" Vi\u0304", 58);
    freq.put("zik\u0327", 104);
    freq.put("Fri\u0304", 41);
    freq.put("it ", 228);
    freq.put("omm", 51);
    freq.put("tro", 2406);
    freq.put("tra", 1972);
    freq.put(" A ", 102);
    freq.put("a\u0304m ", 3525);
    freq.put("fta", 36);
    freq.put(" Ab", 144);
    freq.put(" Ac", 82);
    freq.put(" Ad", 148);
    freq.put(" Af", 50);
    freq.put(" Ag", 50);
    freq.put(" Ah", 36);
    freq.put(" Ai", 198);
    freq.put(" Ak", 149);
    freq.put(" Al", 533);
    freq.put(" Am", 327);
    freq.put(" An", 736);
    freq.put(" Ap", 260);
    freq.put(" Ar", 519);
    freq.put(" As", 243);
    freq.put(" At", 403);
    freq.put(" Au", 758);
    freq.put(" Av", 74);
    freq.put(" Az", 34);
    freq.put("trs", 398);
    freq.put("a\u0304mi", 68);
    freq.put("a\u0304ri\u0304", 93);
    freq.put("a\u0304ma", 396);
    freq.put("tpu\u0304", 25);
    freq.put("ft ", 61);
    freq.put("w", 553);
    freq.put("a\u0304ms", 160);
    freq.put("a\u0304mu", 42);
    freq.put("Fra", 343);
    freq.put("\u043e\u043b", 32);
    freq.put("itu\u0304", 160);
    freq.put("Fre", 87);
    freq.put("\u043e\u0432", 87);
    freq.put("\u043e\u0435", 22);
    freq.put("jer", 106);
    freq.put("jev", 88);
    freq.put("jet", 57);
    freq.put("jeb", 1453);
    freq.put("jek", 399);
    freq.put("\u043a", 221);
    freq.put("jen", 64);
    freq.put("jel", 23);
    freq.put("iti\u0304", 222);
    freq.put("itl\u0327", 164);
    freq.put("ita\u0304", 1332);
    freq.put("aau", 77);
    freq.put("\u043e\u0440", 37);
    freq.put("\u043e\u0441", 22);
    freq.put("s\u030cel", 77);
    freq.put("a\u0304ma\u0304", 78);
    freq.put("ex ", 26);
    freq.put("tp ", 39);
    freq.put("M", 3974);
    freq.put("Isl", 22);
    freq.put("tpe", 28);
    freq.put("a\u0302", 42);
    freq.put("tpa", 63);
    freq.put("lna\u0304", 79);
    freq.put("tpl", 32);
    freq.put("tpi", 87);
    freq.put("tpr", 24);
    freq.put("Hai", 24);
    freq.put("ugi", 71);
    freq.put("oju", 1293);
    freq.put("Hal", 59);
    freq.put("Ham", 27);
    freq.put("Han", 77);
    freq.put("ugl", 76);
    freq.put("Hab", 30);
    freq.put("oje", 183);
    freq.put("oja", 1186);
    freq.put("ugs", 799);
    freq.put("ojo", 586);
    freq.put("Har", 76);
    freq.put("Hav", 40);
    freq.put("oji", 109);
    freq.put("mu\u0304n", 33);
    freq.put("mu\u0304k", 26);
    freq.put("mu\u0304s", 296);
    freq.put("mu\u0304r", 69);
    freq.put("mu\u0304z", 468);
    freq.put("C\u030ce", 124);
    freq.put("C\u030ca", 35);
    freq.put("Li\u0304g", 32);
    freq.put("Li\u0304d", 101);
    freq.put("ug ", 37);
    freq.put("C\u030ci", 48);
    freq.put("C\u030cu", 25);
    freq.put("rfa", 28);
    freq.put("rfo", 45);
    freq.put("cro", 67);
    freq.put("c\u030ce", 516);
    freq.put("sev", 271);
    freq.put("set", 54);
    freq.put("c\u030ca", 247);
    freq.put("ser", 334);
    freq.put("For", 93);
    freq.put("sep", 119);
    freq.put("c\u030co", 33);
    freq.put("c\u030ci", 150);
    freq.put("sez", 117);
    freq.put(" fa\u0304", 22);
    freq.put("sed", 36);
    freq.put("sec", 62);
    freq.put("c\u030cs", 42);
    freq.put("sen", 630);
    freq.put("sem", 62);
    freq.put("sel", 189);
    freq.put("sek", 324);
    freq.put("sej", 83);
    freq.put("sei", 104);
    freq.put("zkl", 48);
    freq.put("zka", 34);
    freq.put("zkr", 193);
    freq.put("je\u0304d", 148);
    freq.put("a\u0304rr", 75);
    freq.put("ue ", 35);
    freq.put("bu\u0304t", 380);
    freq.put("bu\u0304v", 217);
    freq.put("se ", 542);
    freq.put("pdz", 192);
    freq.put("pdr", 26);
    freq.put("va\u0304j", 43);
    freq.put("va\u0304k", 140);
    freq.put("va\u0304n", 38);
    freq.put("va\u0304l", 70);
    freq.put("va\u0304m", 138);
    freq.put("va\u0304c", 471);
    freq.put("s\u030c ", 1382);
    freq.put("C\u030ci\u0304", 26);
    freq.put("va\u0304r", 1021);
    freq.put("va\u0304s", 151);
    freq.put("va\u0304v", 76);
    freq.put("va\u0304t", 107);
    freq.put("ml ", 23);
    freq.put("a\u0304ru", 144);
    freq.put("tiv", 158);
    freq.put("K\u0327i\u0304n", 125);
    freq.put("mu\u0304z\u030c", 31);
    freq.put("nri", 78);
    freq.put("nra", 85);
    freq.put("ugl\u0327", 37);
    freq.put("nrs", 66);
    freq.put("ibi\u0304", 64);
    freq.put("Oli", 250);
    freq.put("uga\u0304", 140);
    freq.put("oja\u0304", 198);
    freq.put("vod", 34);
    freq.put("i\u0304s\u030ca", 499);
    freq.put("vol", 130);
    freq.put("von", 248);
    freq.put("c\u030cu\u0304", 27);
    freq.put("vok", 149);
    freq.put("vot", 667);
    freq.put("ses\u030c", 62);
    freq.put("vos", 64);
    freq.put("g\u0327", 3732);
    freq.put("psa", 72);
    freq.put("vo ", 339);
    freq.put("ra\u0304l\u0327", 69);
    freq.put("zka\u0304", 32);
    freq.put("vgo", 31);
    freq.put("a\u0304de\u0304", 157);
    freq.put("Soc", 53);
    freq.put(" fr", 351);
    freq.put(" fu", 829);
    freq.put("kne", 183);
    freq.put("Som", 114);
    freq.put("Sol", 25);
    freq.put("Son", 25);
    freq.put(" fa", 282);
    freq.put(" fe", 288);
    freq.put(" fi", 803);
    freq.put(" fl", 69);
    freq.put(" fo", 740);
    freq.put("tim", 104);
    freq.put("cia\u0304", 742);
    freq.put("ue\u0304", 34);
    freq.put("O ", 256);
    freq.put("uc\u030c", 23);
    freq.put("a\u0304sa\u0304", 40);
    freq.put("i\u0304ru", 139);
    freq.put("ua\u0304", 341);
    freq.put("ul\u0327", 295);
    freq.put("n\u0327r", 139);
    freq.put("n\u0327s", 60);
    freq.put("n\u0327u", 2226);
    freq.put("n\u0327v", 39);
    freq.put("n\u0327a", 1766);
    freq.put("n\u0327b", 29);
    freq.put("i\u0304ri", 268);
    freq.put("n\u0327d", 47);
    freq.put("n\u0327e", 432);
    freq.put(" Ce\u0304", 86);
    freq.put("n\u0327j", 25);
    freq.put("n\u0327k", 42);
    freq.put("n\u0327n", 28);
    freq.put("n\u0327o", 260);
    freq.put("On", 42);
    freq.put("Ol", 289);
    freq.put("Ok", 85);
    freq.put("cin\u0327", 28);
    freq.put("Oh", 28);
    freq.put("Og", 53);
    freq.put("Of", 29);
    freq.put("Od", 50);
    freq.put("Ob", 41);
    freq.put("tsa", 92);
    freq.put("Ov", 28);
    freq.put("Ot", 132);
    freq.put("Os", 199);
    freq.put("Or", 179);
    freq.put("Op", 65);
    freq.put("i\u0304ra", 120);
    freq.put("d", 58295);
    freq.put("us\u030c", 785);
    freq.put("ii ", 23);
    freq.put("ijs", 425);
    freq.put("b ", 1431);
    freq.put("iju", 1715);
    freq.put("ja\u0304s", 923);
    freq.put("aga\u0304", 163);
    freq.put("ja\u0304n", 27);
    freq.put("ija", 12639);
    freq.put("ja\u0304m", 1042);
    freq.put("ja\u0304j", 22);
    freq.put("ije", 54);
    freq.put("iji", 165);
    freq.put("s\u030cka\u0304", 87);
    freq.put("ja\u0304b", 32);
    freq.put("Vel", 97);
    freq.put("u\u0304 ", 140);
    freq.put("e\u0304l\u0327a", 42);
    freq.put(" Z\u030c", 134);
    freq.put("bd", 41);
    freq.put("be", 3600);
    freq.put("ba", 7096);
    freq.put("bb", 37);
    freq.put("bl", 923);
    freq.put("bn", 90);
    freq.put("bo", 2478);
    freq.put("bi", 5030);
    freq.put("bj", 321);
    freq.put("bk", 204);
    freq.put("ij ", 163);
    freq.put("bu", 2780);
    freq.put("bv", 92);
    freq.put("bp", 134);
    freq.put("br", 1873);
    freq.put("bs", 478);
    freq.put("a\u0304rt", 1313);
    freq.put("by", 23);
    freq.put("ja\u0304 ", 4204);
    freq.put("Fu", 230);
    freq.put("u\u0304c", 206);
    freq.put("u\u0304g", 56);
    freq.put("u\u0304d", 971);
    freq.put("u\u0304k", 417);
    freq.put("i\u0304ka\u0304", 26);
    freq.put("og\u0327e", 28);
    freq.put("Ost", 30);
    freq.put("u\u0304m", 112);
    freq.put("u\u0304l", 106);
    freq.put("u\u0304s", 815);
    freq.put("u\u0304r", 2415);
    freq.put("Osk", 35);
    freq.put("u\u0304p", 130);
    freq.put("Osm", 120);
    freq.put("u\u0304v", 256);
    freq.put("u\u0304t", 957);
    freq.put("u\u0304z", 629);
    freq.put("a\u0304rz", 92);
    freq.put(" C ", 203);
    freq.put("\u043e ", 42);
    freq.put("ci ", 164);
    freq.put("a\u0304ra", 470);
    freq.put("n\u0327s\u030c", 324);
    freq.put("a\u0304s ", 6616);
    freq.put("u ", 34678);
    freq.put("a\u0304re", 82);
    freq.put(" Ch", 131);
    freq.put("n\u0327e\u0304", 348);
    freq.put(" Co", 292);
    freq.put(" Cl", 40);
    freq.put("dok", 188);
    freq.put(" Ca", 270);
    freq.put(" Ce", 344);
    freq.put("n\u0327a\u0304", 297);
    freq.put("mi\u0304d", 29);
    freq.put("a\u0304ri", 461);
    freq.put(" Cr", 39);
    freq.put(" Cu", 37);
    freq.put("cia", 105);
    freq.put("cif", 53);
    freq.put("cie", 767);
    freq.put("n\u0327k\u0327", 245);
    freq.put("cik", 179);
    freq.put("cij", 3939);
    freq.put("uv", 1138);
    freq.put("cio", 768);
    freq.put("up", 1299);
    freq.put("cim", 32);
    freq.put("ur", 8826);
    freq.put("cis", 561);
    freq.put("ul", 3970);
    freq.put("uo", 66);
    freq.put("cip", 250);
    freq.put("ui", 330);
    freq.put("civ", 69);
    freq.put("uk", 2577);
    freq.put("cit", 901);
    freq.put("ue", 159);
    freq.put("ud", 1801);
    freq.put("ug", 2904);
    freq.put("uf", 42);
    freq.put("ua", 219);
    freq.put("uc", 777);
    freq.put("ub", 1129);
    freq.put("lps", 165);
    freq.put("bi\u0304", 818);
    freq.put("k\u0327el", 35);
    freq.put("a\u0304c\u030cu", 68);
    freq.put("ka\u0304 ", 4239);
    freq.put("ba\u0304", 1878);
    freq.put("be\u0304", 351);
    freq.put("bu\u0304", 646);
    freq.put("a\u0304rl", 118);
    freq.put("ka\u0304c", 170);
    freq.put("ka\u0304b", 641);
    freq.put("u\u0304s\u030c", 146);
    freq.put("agl", 88);
    freq.put("agi", 39);
    freq.put("ka\u0304d", 424);
    freq.put("ka\u0304k", 39);
    freq.put("ka\u0304j", 89);
    freq.put("age", 107);
    freq.put("ka\u0304n", 152);
    freq.put("ka\u0304m", 189);
    freq.put("ka\u0304l", 251);
    freq.put("ka\u0304s", 1168);
    freq.put("ka\u0304r", 1333);
    freq.put("ka\u0304p", 196);
    freq.put("ka\u0304t", 32);
    freq.put("ka\u0304z", 22);
    freq.put("agu", 84);
    freq.put("ags", 92);
    freq.put("agr", 218);
    freq.put("zin\u0327", 261);
    freq.put("bva", 41);
    freq.put("ev ", 24);
    freq.put("a\u0304ro", 74);
    freq.put("on\u0327a", 59);
    freq.put("on\u0327i", 162);
    freq.put("on\u0327u", 145);
    freq.put("sle\u0304", 278);
    freq.put("gs\u030ca", 114);
    freq.put("tri", 1251);
    freq.put("evi", 1543);
    freq.put("evn", 29);
    freq.put("evo", 146);
    freq.put("CP ", 24);
    freq.put("eva", 376);
    freq.put("zil\u0327", 81);
    freq.put("tre", 229);
    freq.put("eve", 83);
    freq.put("evr", 24);
    freq.put("evs", 91);
    freq.put("tru", 1883);
    freq.put("evu", 397);
    freq.put("le ", 615);
    freq.put("uel", 29);
    freq.put("odz", 39);
    freq.put("odr", 212);
    freq.put("ods", 132);
    freq.put("odu", 575);
    freq.put("odi", 313);
    freq.put("Blo", 34);
    freq.put("odn", 41);
    freq.put("odo", 337);
    freq.put("oda", 2367);
    freq.put("Bla", 25);
    freq.put("ode", 548);
    freq.put("uer", 36);
    freq.put("F ", 117);
    freq.put("ct ", 32);
    freq.put("rd ", 116);
    freq.put("lea", 23);
    freq.put("lec", 71);
    freq.put("led", 254);
    freq.put("lef", 47);
    freq.put("leg", 36);
    freq.put("lei", 141);
    freq.put("lej", 190);
    freq.put("lek", 1222);
    freq.put("lem", 358);
    freq.put("len", 329);
    freq.put("leo", 70);
    freq.put("lep", 67);
    freq.put("ler", 213);
    freq.put("les", 1626);
    freq.put("let", 176);
    freq.put("lev", 95);
    freq.put("od ", 93);
    freq.put("lez", 112);
    freq.put("rdu", 246);
    freq.put("rds", 349);
    freq.put("cty", 34);
    freq.put("rdz", 219);
    freq.put("rde", 305);
    freq.put("cte", 48);
    freq.put("rda", 365);
    freq.put("rdo", 96);
    freq.put("rdn", 63);
    freq.put("rdi", 228);
    freq.put("cti", 74);
    freq.put("ik\u0327e", 39);
    freq.put("ik\u0327a", 30);
    freq.put("tra\u0304", 1294);
    freq.put("eva\u0304", 40);
    freq.put("sgr", 33);
    freq.put("Ukr", 55);
    freq.put("ik\u0327i", 331);
    freq.put("ik\u0327u", 54);
    freq.put("sga", 35);
    freq.put("\u0421\u041d ", 64);
    freq.put("tre\u0304", 132);
    freq.put("eve\u0304", 231);
    freq.put("ziv", 58);
    freq.put("zit", 58);
    freq.put("evi\u0304", 174);
    freq.put("zir", 324);
    freq.put("zis", 229);
    freq.put("gs\u030ce\u0304", 65);
    freq.put("zid", 135);
    freq.put("zie", 1720);
    freq.put("zin", 1174);
    freq.put("zio", 48);
    freq.put("zil", 123);
    freq.put("zim", 1926);
    freq.put("zij", 625);
    freq.put("zik", 669);
    freq.put("\u043e", 387);
    freq.put("rva\u0304", 75);
    freq.put("tru\u0304", 52);
    freq.put("zi ", 317);
    freq.put("leg\u0327", 37);
    freq.put("rde\u0304", 22);
    freq.put("rda\u0304", 161);
    freq.put("Blu\u0304", 22);
    freq.put("lec\u030c", 51);
    freq.put("\u03bc", 50);
    freq.put("rdi\u0304", 30);
    freq.put("sa\u0304l\u0327", 43);
    freq.put("npa", 23);
    freq.put("Q", 38);
    freq.put("odi\u0304", 31);
    freq.put("afi", 105);
    freq.put("mje", 32);
    freq.put("len\u0327", 73);
    freq.put("rdz\u030c", 57);
    freq.put("mju", 201);
    freq.put("oda\u0304", 459);
    freq.put("VI ", 40);
    freq.put("g\u0327eo", 161);
    freq.put("g\u0327en", 236);
    freq.put("g\u0327el", 28);
    freq.put("g\u0327er", 123);
    freq.put("lzs", 43);
    freq.put("lzi", 33);
    freq.put("lza", 40);
    freq.put("lzc", 242);
    freq.put("Sak", 57);
    freq.put("Sai", 29);
    freq.put("Sah", 30);
    freq.put("San", 93);
    freq.put("Sam", 35);
    freq.put("Sal", 189);
    freq.put("Sac", 23);
    freq.put("Sab", 29);
    freq.put("u\u0304li", 71);
    freq.put("Sae", 27);
    freq.put("Sad", 27);
    freq.put("ta\u0304l\u0327", 48);
    freq.put(" hi", 297);
    freq.put(" ho", 304);
    freq.put(" hl", 48);
    freq.put("Sas", 60);
    freq.put("Sar", 143);
    freq.put(" ha", 132);
    freq.put("Sav", 262);
    freq.put(" he", 218);
    freq.put("Sat", 49);
    freq.put("\u0438\u0447 ", 26);
    freq.put("loj", 39);
    freq.put("vmu\u0304", 35);
    freq.put("ihs", 70);
    freq.put("lzi\u0304", 23);
    freq.put("ihi", 54);
    freq.put("iho", 104);
    freq.put("iha", 58);
    freq.put("ra\u0304t", 492);
    freq.put("va\u0304", 2847);
    freq.put("S\u030ck\u0327i", 29);
    freq.put(" l\u0327a", 118);
    freq.put(" l\u0327o", 206);
    freq.put("ode\u0304", 120);
    freq.put(" E ", 56);
    freq.put("ck ", 59);
    freq.put(" El", 193);
    freq.put(" Em", 90);
    freq.put(" En", 121);
    freq.put(" Ei", 676);
    freq.put(" Ek", 92);
    freq.put(" Ed", 95);
    freq.put(" Eg", 26);
    freq.put(" Eb", 22);
    freq.put(" Ex", 28);
    freq.put(" Ez", 43);
    freq.put(" Et", 48);
    freq.put(" Eu", 85);
    freq.put(" Ev", 42);
    freq.put(" Eq", 185);
    freq.put(" Er", 98);
    freq.put(" Es", 44);
    freq.put("cke", 32);
    freq.put("cka", 44);
    freq.put("cu\u0304", 51);
    freq.put("sze", 116);
    freq.put("\u0410", 26);
    freq.put("rba\u0304", 31);
    freq.put("otn", 222);
    freq.put("jau", 557);
    freq.put("jar", 34);
    freq.put("jas", 8640);
    freq.put("jap", 53);
    freq.put("jan", 85);
    freq.put("ae ", 655);
    freq.put("jam", 931);
    freq.put("rbi\u0304", 529);
    freq.put("jak", 65);
    freq.put("jai", 593);
    freq.put("jad", 67);
    freq.put("s\u030ci ", 834);
    freq.put("ci\u0304", 1751);
    freq.put("z\u030cn\u0327u", 81);
    freq.put("i\u0304n\u0327a\u0304", 28);
    freq.put("uce\u0304", 126);
    freq.put("h", 5764);
    freq.put("ca\u0304", 282);
    freq.put("s\u030cis", 80);
    freq.put("s\u030cim", 31);
    freq.put("s\u030cin", 270);
    freq.put("rbu\u0304", 24);
    freq.put("aei", 29);
    freq.put("s\u030cif", 27);
    freq.put("ael", 27);
    freq.put("ja ", 7647);
    freq.put("Pr", 574);
    freq.put("Ps", 29);
    freq.put("A\u0304zi", 142);
    freq.put("Pu", 149);
    freq.put("oma", 1047);
    freq.put("Pa", 1460);
    freq.put("Pe", 330);
    freq.put("Ph", 56);
    freq.put("Pi", 543);
    freq.put("Po", 522);
    freq.put("Pl", 246);
    freq.put("\u0627", 101);
    freq.put("et ", 1093);
    freq.put("\u0432\u0435", 29);
    freq.put("vi\u0304", 926);
    freq.put("tsl", 24);
    freq.put("P ", 315);
    freq.put("le", 5914);
    freq.put("ik\u0327", 475);
    freq.put("\u0432\u0430", 29);
    freq.put("tsk", 152);
    freq.put("etr", 698);
    freq.put("ets", 222);
    freq.put("z\u030cg\u0327i\u0304", 37);
    freq.put("etv", 168);
    freq.put("ett", 58);
    freq.put("etu", 1584);
    freq.put("etb", 351);
    freq.put("tla", 152);
    freq.put("eta", 734);
    freq.put("tle", 76);
    freq.put("ete", 624);
    freq.put("eth", 26);
    freq.put("eti", 845);
    freq.put("etn", 170);
    freq.put("eto", 1378);
    freq.put("etl", 29);
    freq.put("ck", 210);
    freq.put("ci", 9940);
    freq.put("ch", 496);
    freq.put("co", 534);
    freq.put("Her", 113);
    freq.put("cl", 78);
    freq.put("cc", 58);
    freq.put("lj", 234);
    freq.put("ca", 1325);
    freq.put("oc\u030c", 89);
    freq.put("ce", 3798);
    freq.put("cy", 80);
    freq.put("oge\u0304", 50);
    freq.put("uca", 88);
    freq.put("cs", 106);
    freq.put("cr", 118);
    freq.put("Hen", 52);
    freq.put("cp", 28);
    freq.put("Hei", 53);
    freq.put("cu", 688);
    freq.put("ct", 320);
    freq.put("Ger", 28);
    freq.put("i\u0304n\u0327u", 254);
    freq.put("uda\u0304", 23);
    freq.put("i\u0304n\u0327a", 76);
    freq.put("Geo", 50);
    freq.put("Gen", 23);
    freq.put("ls", 6050);
    freq.put("lgo", 65);
    freq.put("c ", 1617);
    freq.put("lge", 25);
    freq.put("uc ", 316);
    freq.put("lgr", 44);
    freq.put("lgs", 36);
    freq.put("lgt", 25);
    freq.put("lgu", 44);
    freq.put("oga\u0304", 71);
    freq.put("rbu", 231);
    freq.put("rbs", 88);
    freq.put("rbo", 531);
    freq.put("tsp", 162);
    freq.put("rbi", 268);
    freq.put("rbe", 87);
    freq.put("unz", 34);
    freq.put("rba", 232);
    freq.put("tle\u0304", 35);
    freq.put("ete\u0304", 183);
    freq.put("vc", 24);
    freq.put("vd", 128);
    freq.put("ve", 6316);
    freq.put("vg", 67);
    freq.put("vi", 15879);
    freq.put("vj", 161);
    freq.put("vk", 55);
    freq.put("vl", 36);
    freq.put("vm", 57);
    freq.put("vn", 277);
    freq.put("vo", 2198);
    freq.put("vp", 135);
    freq.put("vr", 110);
    freq.put("eta\u0304", 683);
    freq.put("vu", 1511);
    freq.put("vv", 135);
    freq.put("Pu\u0304", 23);
    freq.put("vz", 34);
    freq.put("of ", 167);
    freq.put("zgu", 59);
    freq.put("zgl", 134);
    freq.put("tli\u0304", 43);
    freq.put("eti\u0304", 89);
    freq.put("une", 47);
    freq.put("v ", 977);
    freq.put("phi", 54);
    freq.put("yon", 65);
    freq.put("pha", 38);
    freq.put("oi\u0304", 103);
    freq.put("nme\u0304", 32);
    freq.put("Pe\u0304", 222);
    freq.put("ofa", 27);
    freq.put("ofe", 168);
    freq.put("ofi", 331);
    freq.put("ofo", 72);
    freq.put("ofs", 60);
    freq.put("Pa\u0304", 146);
    freq.put("oft", 50);
    freq.put("\u043a\u0438\u0438\u0306", 32);
    freq.put("Ta\u0304 ", 634);
    freq.put("wer", 27);
    freq.put("Ta\u0304s", 150);
    freq.put("ok\u0327", 34);
    freq.put("nve", 133);
    freq.put("nva", 62);
    freq.put("sa\u0304r", 68);
    freq.put("Ta\u0304l", 53);
    freq.put("nvi", 1034);
    freq.put("sa\u0304p", 24);
    freq.put(" hr", 108);
    freq.put("sa\u0304t", 137);
    freq.put("umk", 31);
    freq.put("inz\u030c", 48);
    freq.put("vst", 90);
    freq.put("gur", 196);
    freq.put("e\u0304se\u0304", 144);
    freq.put(" hu", 35);
    freq.put("inu\u0304", 22);
    freq.put(" ht", 33);
    freq.put("e\u0304sa\u0304", 29);
    freq.put("ins\u030c", 34);
    freq.put("i\u0304ba\u0304", 960);
    freq.put("e\u0304si\u0304", 28);
    freq.put("\u043b\u044c", 27);
    freq.put("\u043b\u0430", 30);
    freq.put("\u043b\u0435", 23);
    freq.put("\u4e4b", 22);
    freq.put("\u043b\u0438", 29);
    freq.put("fra", 303);
    freq.put("vs ", 473);
    freq.put("ini\u0304", 182);
    freq.put("Sco", 41);
    freq.put("Sci", 36);
    freq.put("Sch", 39);
    freq.put("u\u0304ni", 45);
    freq.put(" ju", 119);
    freq.put("kru", 265);
    freq.put("inc\u030c", 41);
    freq.put(" jo", 407);
    freq.put("kri", 985);
    freq.put("Sau", 200);
    freq.put(" je", 1511);
    freq.put("kra", 920);
    freq.put(" ja", 682);
    freq.put("ina\u0304", 3097);
    freq.put("kre", 163);
    freq.put("nva\u0304", 46);
    freq.put("Kle", 26);
    freq.put("Kla", 44);
    freq.put("Kli", 34);
    freq.put("Klu", 132);
    freq.put("Ug", 37);
    freq.put("inu", 278);
    freq.put("inv", 33);
    freq.put(" je\u0304", 154);
    freq.put("ins", 796);
    freq.put("inn", 34);
    freq.put("ino", 729);
    freq.put("inh", 61);
    freq.put("ini", 1119);
    freq.put("inj", 23);
    freq.put("ink", 89);
    freq.put("ind", 539);
    freq.put("ine", 633);
    freq.put("inf", 318);
    freq.put("ing", 589);
    freq.put(" ja\u0304", 140);
    freq.put("ina", 1252);
    freq.put("inc", 281);
    freq.put("a\u0304be\u0304", 84);
    freq.put("eo ", 63);
    freq.put("kri\u0304", 67);
    freq.put("e\u0304s ", 404);
    freq.put("i\u0304bi", 22);
    freq.put("i\u0304bn", 58);
    freq.put("i\u0304ba", 3544);
    freq.put("i\u0304be", 36);
    freq.put("U", 852);
    freq.put("in ", 197);
    freq.put("i\u0304bu", 1222);
    freq.put("eog", 110);
    freq.put("eof", 26);
    freq.put("eod", 60);
    freq.put("e\u0304su", 45);
    freq.put("e\u0304st", 566);
    freq.put("eon", 61);
    freq.put("eom", 53);
    freq.put("eol", 176);
    freq.put("eos", 34);
    freq.put("eor", 322);
    freq.put("eop", 39);
    freq.put(" ju\u0304", 849);
    freq.put("res", 696);
    freq.put("rep", 144);
    freq.put("pto", 59);
    freq.put("tne\u0304", 293);
    freq.put("ere\u0304", 156);
    freq.put("pu\u0304s\u030c", 30);
    freq.put("bru\u0304", 72);
    freq.put("era\u0304", 709);
    freq.put("nka\u0304", 234);
    freq.put("cm ", 47);
    freq.put("Tuk", 33);
    freq.put("erg\u0327", 206);
    freq.put("ren", 387);
    freq.put("ald", 1013);
    freq.put("tni\u0304", 27);
    freq.put("eri\u0304", 393);
    freq.put(" Gv", 31);
    freq.put(" Gu", 162);
    freq.put(" Gr", 516);
    freq.put("nku\u0304", 25);
    freq.put("lvo", 84);
    freq.put("vi\u0304 ", 36);
    freq.put("ern\u0327", 62);
    freq.put(" Ge", 158);
    freq.put("bri\u0304", 410);
    freq.put(" Ga", 455);
    freq.put(" Go", 172);
    freq.put(" Gl", 86);
    freq.put("s\u030cpu", 29);
    freq.put(" Gi", 68);
    freq.put("ers\u030c", 24);
    freq.put("l\u0327i ", 260);
    freq.put("bra\u0304", 110);
    freq.put("eru\u0304", 27);
    freq.put("a\u0304", 76597);
    freq.put("s\u030co ", 346);
    freq.put(" n\u0327e", 38);
    freq.put("ptu", 237);
    freq.put("s\u030cpa", 34);
    freq.put("tmi", 87);
    freq.put("\u062f", 35);
    freq.put("las\u030c", 379);
    freq.put("s\u030cot", 31);
    freq.put("s\u030cos", 132);
    freq.put("sle", 81);
    freq.put("gli", 344);
    freq.put("glo", 94);
    freq.put("aks", 1610);
    freq.put("gla", 305);
    freq.put("gle", 241);
    freq.put("aku", 213);
    freq.put("akt", 789);
    freq.put("aki", 53);
    freq.put("ako", 151);
    freq.put("akn", 91);
    freq.put("akm", 124);
    freq.put("akl", 47);
    freq.put("akc", 136);
    freq.put("aka", 880);
    freq.put("gls", 48);
    freq.put("glu", 49);
    freq.put("ake", 96);
    freq.put("Jer", 41);
    freq.put("pu\u0304t", 23);
    freq.put("ix", 47);
    freq.put("bru", 342);
    freq.put("bro", 61);
    freq.put("n\u0327g\u0327e\u0304", 37);
    freq.put("bri", 385);
    freq.put("bre", 171);
    freq.put("Jel", 80);
    freq.put("er ", 1104);
    freq.put(" Ga\u0304", 24);
    freq.put("nka", 173);
    freq.put("nkc", 180);
    freq.put("nke", 26);
    freq.put("nki", 45);
    freq.put("nko", 53);
    freq.put("nkr", 126);
    freq.put("nks", 81);
    freq.put("nkt", 272);
    freq.put("nku", 121);
    freq.put("iv", 1914);
    freq.put("ert", 417);
    freq.put("eru", 391);
    freq.put("erv", 331);
    freq.put("erp", 67);
    freq.put("err", 36);
    freq.put("ers", 1648);
    freq.put("ery", 29);
    freq.put("erz", 36);
    freq.put("erd", 99);
    freq.put("ere", 536);
    freq.put("erf", 37);
    freq.put("erg", 167);
    freq.put("Cha", 50);
    freq.put("era", 1626);
    freq.put("erb", 238);
    freq.put("erc", 178);
    freq.put("erl", 157);
    freq.put("erm", 855);
    freq.put("ern", 467);
    freq.put("ero", 595);
    freq.put("tni", 753);
    freq.put("eri", 2539);
    freq.put("erk", 66);
    freq.put("io", 3152);
    freq.put("gla\u0304", 76);
    freq.put("uar", 51);
    freq.put("la ", 3657);
    freq.put("Abr", 31);
    freq.put("ual", 31);
    freq.put("uan", 35);
    freq.put("aka\u0304", 218);
    freq.put("uag", 22);
    freq.put("ib", 840);
    freq.put("akl\u0327", 72);
    freq.put("i\u0304", 34346);
    freq.put("lam", 314);
    freq.put("lan", 766);
    freq.put("lah", 38);
    freq.put("lai", 2379);
    freq.put("laj", 474);
    freq.put("lak", 285);
    freq.put("lad", 63);
    freq.put("lag", 32);
    freq.put("lab", 686);
    freq.put("lac", 74);
    freq.put("lay", 44);
    freq.put("laz", 38);
    freq.put("lat", 1524);
    freq.put("lau", 462);
    freq.put("lav", 247);
    freq.put("lap", 246);
    freq.put("vi\u0304b", 202);
    freq.put("lar", 131);
    freq.put("las", 2361);
    freq.put("vi\u0304d", 56);
    freq.put("aks\u030c", 415);
    freq.put("zeb", 60);
    freq.put("zef", 34);
    freq.put("N\u0327uj", 43);
    freq.put("zej", 232);
    freq.put("zek", 170);
    freq.put(" li\u0304", 2107);
    freq.put("zel", 450);
    freq.put("kte\u0304", 73);
    freq.put("zer", 903);
    freq.put("zes", 430);
    freq.put("kta\u0304", 172);
    freq.put(" la\u0304", 230);
    freq.put("e\u0304l\u0327 ", 153);
    freq.put(" le\u0304", 170);
    freq.put("kti\u0304", 473);
    freq.put("pjo", 49);
    freq.put(" lu\u0304", 49);
    freq.put("pju", 63);
    freq.put("l", 73126);
    freq.put("ktu\u0304", 291);
    freq.put("e\u0304l\u0327u", 170);
    freq.put("\u0301", 38);
    freq.put("G\u0327e", 106);
    freq.put("nt ", 98);
    freq.put("os\u030ca", 1342);
    freq.put("os\u030co", 147);
    freq.put("os\u030ci", 415);
    freq.put("os\u030cu", 115);
    freq.put("os\u030cs", 181);
    freq.put("kip", 24);
    freq.put("nts", 925);
    freq.put("ntr", 875);
    freq.put("ntu", 416);
    freq.put("nti", 950);
    freq.put("nth", 28);
    freq.put("nto", 950);
    freq.put("nta", 799);
    freq.put("nte", 768);
    freq.put(" g\u0327i", 768);
    freq.put("ls\u030c", 164);
    freq.put(" g\u0327e", 323);
    freq.put("mvi", 24);
    freq.put("tek", 587);
    freq.put("zen\u0327", 47);
    freq.put("kt ", 222);
    freq.put(" le", 458);
    freq.put("B", 3355);
    freq.put(" la", 3298);
    freq.put(" lo", 437);
    freq.put(" li", 2852);
    freq.put(" lv", 27);
    freq.put(" lu", 115);
    freq.put("zel\u0327", 55);
    freq.put("Ser", 100);
    freq.put("ktu", 492);
    freq.put("to ", 1892);
    freq.put("ktr", 699);
    freq.put("l\u0327", 8048);
    freq.put("kto", 408);
    freq.put("kti", 662);
    freq.put("Sen", 122);
    freq.put("Sem", 34);
    freq.put("Sel", 26);
    freq.put("Sek", 22);
    freq.put("kta", 560);
    freq.put("u\u0304pn", 62);
    freq.put(" u\u0304d", 556);
    freq.put("nti\u0304", 340);
    freq.put("nte\u0304", 146);
    freq.put("udu", 86);
    freq.put("udz", 752);
    freq.put("nta\u0304", 395);
    freq.put("\u03c0", 29);
    freq.put("Qu", 25);
    freq.put("os\u030ca\u0304", 198);
    freq.put("ntu\u0304", 58);
    freq.put("tse", 174);
    freq.put("os\u030ci\u0304", 35);
    freq.put("uda", 124);
    freq.put("gne\u0304", 109);
    freq.put("i\u0304d ", 59);
    freq.put("d ", 1260);
    freq.put("gna\u0304", 78);
    freq.put("ail\u0327", 41);
    freq.put("em ", 6412);
    freq.put("l\u0327a\u0304s", 38);
    freq.put("l\u0327a\u0304m", 48);
    freq.put("hro", 158);
    freq.put("hri", 23);
    freq.put("dn", 387);
    freq.put("do", 4137);
    freq.put("dl", 81);
    freq.put("dm", 437);
    freq.put(" A\u0304g", 35);
    freq.put("dk", 50);
    freq.put("dh", 33);
    freq.put("di", 7508);
    freq.put("dg", 22);
    freq.put("dd", 61);
    freq.put("de", 6326);
    freq.put("i\u0304da", 185);
    freq.put("da", 13240);
    freq.put(" A\u0304r", 50);
    freq.put("dz", 8558);
    freq.put("i\u0304dz", 1603);
    freq.put("dy", 39);
    freq.put("dv", 153);
    freq.put(" A\u0304z", 143);
    freq.put("dt", 34);
    freq.put("du", 3460);
    freq.put("dr", 2632);
    freq.put("ds", 1737);
    freq.put("dp", 40);
    freq.put("i\u0304ds", 186);
    freq.put("eme", 2607);
    freq.put("emd", 28);
    freq.put("emg", 143);
    freq.put("aiz\u030c", 27);
    freq.put("ema", 412);
    freq.put("emb", 176);
    freq.put("emo", 348);
    freq.put("emn", 25);
    freq.put("emi", 389);
    freq.put("emj", 71);
    freq.put("PA ", 36);
    freq.put("emt", 133);
    freq.put("emp", 493);
    freq.put("ems", 89);
    freq.put("ais\u030c", 99);
    freq.put("w ", 104);
    freq.put("n\u0327ve", 32);
    freq.put("u\u0304ve", 114);
    freq.put(" I ", 103);
    freq.put("nik\u0327", 23);
    freq.put("hi\u0304d", 23);
    freq.put("epa\u0304", 130);
    freq.put("il ", 50);
    freq.put("te ", 724);
    freq.put("we", 66);
    freq.put("wa", 100);
    freq.put("wo", 40);
    freq.put(" Ir", 159);
    freq.put(" Is", 56);
    freq.put(" It", 130);
    freq.put("wi", 65);
    freq.put("ww", 72);
    freq.put(" Ik", 26);
    freq.put("ws", 45);
    freq.put(" Im", 77);
    freq.put(" In", 594);
    freq.put(" Ib", 23);
    freq.put(" Id", 25);
    freq.put(" Ie", 156);
    freq.put(" Ig", 193);
    freq.put("ilg", 175);
    freq.put("ild", 409);
    freq.put("ile", 125);
    freq.put("ilb", 52);
    freq.put("ilc", 81);
    freq.put("ila", 297);
    freq.put("iln", 265);
    freq.put("ilo", 443);
    freq.put("ill", 168);
    freq.put("ilm", 237);
    freq.put("ilj", 175);
    freq.put("ilk", 121);
    freq.put("ilh", 58);
    freq.put("ili", 579);
    freq.put("ilv", 752);
    freq.put("ilt", 346);
    freq.put("ilu", 127);
    freq.put("ils", 2044);
    freq.put("ilp", 256);
    freq.put(" ra", 2342);
    freq.put("ilz", 47);
    freq.put("col", 50);
    freq.put("con", 50);
    freq.put("ema\u0304", 318);
    freq.put("di\u0304", 2457);
    freq.put("i\u0304di\u0304", 105);
    freq.put("eme\u0304", 508);
    freq.put("mbu", 166);
    freq.put("i\u0304da\u0304", 112);
    freq.put("emi\u0304", 84);
    freq.put("da\u0304", 3118);
    freq.put("de\u0304", 1715);
    freq.put("du\u0304", 151);
    freq.put("s\u030cme", 77);
    freq.put("dz\u030c", 490);
    freq.put("ems\u030c", 50);
    freq.put("aiz", 832);
    freq.put("dn\u0327", 25);
    freq.put("ait", 1125);
    freq.put("aiv", 51);
    freq.put("aip", 45);
    freq.put("ais", 4315);
    freq.put("air", 752);
    freq.put("aim", 532);
    freq.put("ail", 137);
    freq.put("gna", 34);
    freq.put("aik", 1200);
    freq.put("aij", 61);
    freq.put("aie", 25);
    freq.put("aid", 426);
    freq.put("aig", 508);
    freq.put("gni", 35);
    freq.put("gno", 38);
    freq.put("aic", 101);
    freq.put("aib", 25);
    freq.put("ila\u0304", 148);
    freq.put("ni ", 1261);
    freq.put("\u043c\u0438", 22);
    freq.put("ile\u0304", 113);
    freq.put("ili\u0304", 94);
    freq.put("ep ", 41);
    freq.put("th ", 68);
    freq.put("nij", 1586);
    freq.put("nik", 329);
    freq.put("nin", 84);
    freq.put("\u03c4", 47);
    freq.put("nil", 57);
    freq.put("nim", 128);
    freq.put("nic", 83);
    freq.put("nia", 73);
    freq.put("nif", 36);
    freq.put("nig", 62);
    freq.put("nid", 123);
    freq.put("nie", 3147);
    freq.put("niz", 488);
    freq.put("Y", 65);
    freq.put("nis", 2463);
    freq.put("nip", 37);
    freq.put("niv", 242);
    freq.put("nit", 151);
    freq.put("ils\u030c", 47);
    freq.put("ept", 197);
    freq.put("epu", 444);
    freq.put("epr", 190);
    freq.put("eps", 32);
    freq.put("tho", 40);
    freq.put("epo", 71);
    freq.put("epl", 47);
    freq.put("epj", 76);
    freq.put("eph", 37);
    freq.put("epi", 258);
    freq.put("z\u030cs ", 70);
    freq.put("the", 191);
    freq.put("epe", 71);
    freq.put("tha", 41);
    freq.put("epa", 258);
    freq.put("s\u030ca\u0304 ", 313);
    freq.put("rn ", 84);
    freq.put("mta\u0304", 193);
    freq.put("Gau", 47);
    freq.put("Gar", 70);
    freq.put("Gan", 49);
    freq.put("Gam", 34);
    freq.put("Gal", 115);
    freq.put("Gai", 64);
    freq.put("Tri", 83);
    freq.put("s\u030ca\u0304d", 125);
    freq.put("rni", 347);
    freq.put("rno", 46);
    freq.put("Tro", 39);
    freq.put("s\u030ca\u0304m", 60);
    freq.put("rna", 307);
    freq.put("Tre", 69);
    freq.put("s\u030ca\u0304k", 184);
    freq.put("s\u030ca\u0304v", 22);
    freq.put("s\u030ca\u0304s", 183);
    freq.put("rns", 56);
    freq.put("rnu", 187);
    freq.put("lci", 93);
    freq.put("mir", 718);
    freq.put("bpi", 124);
    freq.put("zce", 422);
    freq.put(" ni\u0304", 29);
    freq.put("rs\u030ca", 176);
    freq.put("rs\u030co", 29);
    freq.put("zci", 73);
    freq.put("rs\u030ci", 100);
    freq.put("rs\u030cu", 90);
    freq.put("rs\u030cr", 51);
    freq.put("u\u0304ra\u0304", 242);
    freq.put("Led", 38);
    freq.put(" na\u0304", 219);
    freq.put("Lej", 26);
    freq.put("Leo", 37);
    freq.put("Tim", 41);
    freq.put("Let", 23);
    freq.put("plu", 29);
    freq.put("rs\u030c ", 626);
    freq.put("ple", 241);
    freq.put("pla", 1300);
    freq.put("plo", 77);
    freq.put("pli", 106);
    freq.put("obo", 33);
    freq.put("obl", 72);
    freq.put("S\u030cve", 65);
    freq.put("obi", 154);
    freq.put("obe", 704);
    freq.put("oba", 54);
    freq.put("obu", 91);
    freq.put("obr", 164);
    freq.put("obs", 66);
    freq.put("rni\u0304", 124);
    freq.put("Tri\u0304", 27);
    freq.put("Z\u030can", 29);
    freq.put("rna\u0304", 130);
    freq.put("rne\u0304", 53);
    freq.put("mt ", 26);
    freq.put("war", 33);
    freq.put("mpe\u0304", 250);
    freq.put("\u0442", 170);
    freq.put("mts", 51);
    freq.put("mtu", 58);
    freq.put("Odi", 27);
    freq.put("mti", 48);
    freq.put("mta", 1054);
    freq.put("mte", 23);
    freq.put("u\u0308r", 23);
    freq.put(" n ", 74);
    freq.put("oba\u0304", 56);
    freq.put("pli\u0304", 101);
    freq.put("ple\u0304", 184);
    freq.put("obi\u0304", 23);
    freq.put("pla\u0304", 202);
    freq.put(" ni", 63);
    freq.put("umu", 2190);
    freq.put("kve", 97);
    freq.put(" no", 9749);
    freq.put("kva", 316);
    freq.put(" na", 986);
    freq.put(" ne", 2383);
    freq.put("kvi", 68);
    freq.put(" nu", 108);
    freq.put("ums", 2443);
    freq.put("rs\u030ca\u0304", 79);
    freq.put("u\u0304rs", 28);
    freq.put("u\u0304rv", 45);
    freq.put("u\u0304ru", 316);
    freq.put("u\u0304ri", 123);
    freq.put("u\u0304rn", 45);
    freq.put("u\u0304rm", 32);
    freq.put("u\u0304ra", 1491);
    freq.put("u\u0304rg", 22);
    freq.put("Mu\u0304s", 71);
    freq.put("Mu\u0304z", 68);
    freq.put("gu ", 870);
    freq.put("is\u030ci", 31);
    freq.put("uzn\u0327", 254);
    freq.put("is\u030ca", 70);
    freq.put("jvi", 27);
    freq.put("is\u030cu", 56);
    freq.put("i\u0304l\u0327u", 88);
    freq.put(" Ka\u0304", 157);
    freq.put("n\u0327", 7202);
    freq.put("umm", 30);
    freq.put("\u043d ", 27);
    freq.put("a\u0304k", 5743);
    freq.put("umo", 1060);
    freq.put("gub", 86);
    freq.put("gua", 28);
    freq.put("gud", 66);
    freq.put("gun", 194);
    freq.put("gum", 401);
    freq.put("gul", 224);
    freq.put("gus", 188);
    freq.put("p", 52161);
    freq.put("guv", 148);
    freq.put("uze\u0304", 26);
    freq.put("htt", 39);
    freq.put("Ins", 32);
    freq.put("ek ", 1542);
    freq.put("\u0433", 53);
    freq.put("ht ", 30);
    freq.put("spi\u0304", 75);
    freq.put("eko", 416);
    freq.put("ekn", 62);
    freq.put("ekm", 150);
    freq.put("ekl", 427);
    freq.put("kss", 117);
    freq.put("eki", 366);
    freq.put("eke", 31);
    freq.put("spe\u0304", 1745);
    freq.put("ekc", 120);
    freq.put("eka", 402);
    freq.put("ekv", 109);
    freq.put("eku", 811);
    freq.put("ekt", 1750);
    freq.put("eks", 1397);
    freq.put("ag\u0327i", 37);
    freq.put("uzl", 72);
    freq.put("uzm", 28);
    freq.put("n\u0327k\u0327o", 49);
    freq.put("n\u0327k\u0327i", 80);
    freq.put("uzk", 39);
    freq.put("uzd", 109);
    freq.put("uze", 128);
    freq.put("is\u030cn\u0327", 36);
    freq.put("n\u0327k\u0327a", 92);
    freq.put("uzb", 144);
    freq.put("uzc", 22);
    freq.put("uzt", 192);
    freq.put("uzv", 164);
    freq.put("uzr", 64);
    freq.put("uzs", 479);
    freq.put(" Ka", 1303);
    freq.put(" Ke", 174);
    freq.put("Vla", 36);
    freq.put(" Ki", 234);
    freq.put(" Ko", 784);
    freq.put(" Kl", 266);
    freq.put(" Kr", 1044);
    freq.put(" Kv", 49);
    freq.put(" Ku", 433);
    freq.put("ksa", 250);
    freq.put("ca ", 396);
    freq.put("gul\u0327", 52);
    freq.put("F", 1831);
    freq.put("\u064a", 53);
    freq.put("uz ", 1335);
    freq.put("aa\u0304t", 29);
    freq.put("ibi", 285);
    freq.put(" K ", 22);
    freq.put("ibl", 76);
    freq.put("ibo", 30);
    freq.put("cas", 201);
    freq.put("car", 55);
    freq.put("ibe", 125);
    freq.put("cau", 337);
    freq.put("cat", 29);
    freq.put("can", 76);
    freq.put("cam", 74);
    freq.put("cal", 52);
    freq.put("cab", 38);
    freq.put("ibr", 57);
    freq.put("Mod", 95);
    freq.put("ibu", 58);
    freq.put("ao ", 25);
    freq.put("spr", 198);
    freq.put("spu", 61);
    freq.put("eka\u0304", 290);
    freq.put("spi", 604);
    freq.put("s\u030cs ", 266);
    freq.put("spl", 61);
    freq.put("spo", 584);
    freq.put("spa", 151);
    freq.put("l\u0327a ", 1215);
    freq.put("spe", 377);
    freq.put("QL ", 27);
    freq.put("ekl\u0327", 537);
    freq.put("s\u030cst", 29);
    freq.put("l\u0327au", 478);
    freq.put("l\u0327av", 42);
    freq.put("l\u0327as", 391);
    freq.put("l\u0327am", 83);
    freq.put("s\u030csa", 28);
    freq.put("l\u0327ai", 47);
    freq.put("ght", 32);
    freq.put("ek\u0327i", 82);
    freq.put("eks\u030c", 656);
    freq.put("re\u0304s", 31);
    freq.put("ek\u0327u", 303);
    freq.put("Ru", 198);
    freq.put("Jav", 26);
    freq.put("Jau", 217);
    freq.put("no ", 5915);
    freq.put("soc", 383);
    freq.put("Jap", 129);
    freq.put("Jan", 40);
    freq.put("Re", 684);
    freq.put("Chr", 32);
    freq.put("Jam", 45);
    freq.put("Ra", 377);
    freq.put("Jag", 28);
    freq.put("Ro", 567);
    freq.put("Rh", 25);
    freq.put("Ri", 309);
    freq.put("mbi", 138);
    freq.put("\u03b1", 118);
    freq.put("nol", 424);
    freq.put("nom", 610);
    freq.put("non", 115);
    freq.put("K\u0327e", 55);
    freq.put("noj", 304);
    freq.put("nok", 292);
    freq.put("nod", 505);
    freq.put("nof", 35);
    freq.put("nog", 200);
    freq.put("noa", 58);
    freq.put("nob", 42);
    freq.put("noc", 58);
    freq.put("zal\u0327", 79);
    freq.put("R ", 242);
    freq.put("noz", 696);
    freq.put("not", 1518);
    freq.put("nov", 804);
    freq.put("nop", 85);
    freq.put("Ja ", 27);
    freq.put("nos", 1301);
    freq.put("em", 12435);
    freq.put("el", 8559);
    freq.put("eo", 1018);
    freq.put("en", 17231);
    freq.put("ei", 6080);
    freq.put("eh", 574);
    freq.put("ek", 9435);
    freq.put("ej", 1682);
    freq.put("ee", 260);
    freq.put("ed", 5035);
    freq.put("eg", 1917);
    freq.put("Afg", 26);
    freq.put("ea", 831);
    freq.put("ec", 2362);
    freq.put("eb", 2145);
    freq.put("ey", 101);
    freq.put("ex", 66);
    freq.put("ez", 2104);
    freq.put("eu", 138);
    freq.put("et", 9035);
    freq.put("ew", 72);
    freq.put("ev", 3202);
    freq.put("ep", 1928);
    freq.put("es", 13667);
    freq.put("er", 13266);
    freq.put("\u0633", 25);
    freq.put("si\u0304 ", 32);
    freq.put("rlo", 32);
    freq.put("rli", 126);
    freq.put("rle", 24);
    freq.put("rld", 35);
    freq.put("lms", 33);
    freq.put("rla", 201);
    freq.put("e ", 9104);
    freq.put(" \u041a", 29);
    freq.put("lma", 269);
    freq.put("lme", 73);
    freq.put("rls", 24);
    freq.put("si\u0304t", 105);
    freq.put("si\u0304v", 85);
    freq.put("si\u0304s", 28);
    freq.put("si\u0304d", 98);
    freq.put("si\u0304g", 56);
    freq.put("si\u0304b", 502);
    freq.put("si\u0304m", 27);
    freq.put("si\u0304n", 31);
    freq.put("si\u0304k", 51);
    freq.put("si\u0304j", 64);
    freq.put("zan", 24);
    freq.put("xi", 24);
    freq.put("zak", 23);
    freq.put("zah", 57);
    freq.put("noi\u0304", 26);
    freq.put("K\u0327i\u0304", 170);
    freq.put("zab", 39);
    freq.put("usj", 49);
    freq.put("fi", 2006);
    freq.put("zav", 27);
    freq.put("zat", 43);
    freq.put("zau", 128);
    freq.put("zar", 328);
    freq.put("zas", 275);
    freq.put("xt", 23);
    freq.put("Eur", 70);
    freq.put("fl", 161);
    freq.put("i\u0304g\u0327e", 36);
    freq.put("x ", 250);
    freq.put("nos\u030c", 193);
    freq.put("za ", 232);
    freq.put("pni", 63);
    freq.put("pne", 24);
    freq.put("Ri\u0304", 858);
    freq.put("Re\u0304", 60);
    freq.put("Ra\u0304", 30);
    freq.put("rli\u0304", 45);
    freq.put("es\u030c", 2372);
    freq.put("ez\u030c", 1461);
    freq.put("si\u0304l\u0327", 23);
    freq.put("Pha", 28);
    freq.put("en\u0327", 1120);
    freq.put("lma\u0304", 69);
    freq.put("ei\u0304", 44);
    freq.put("o\u0308", 83);
    freq.put("eg\u0327", 460);
    freq.put("el\u0327", 2084);
    freq.put("ek\u0327", 397);
    freq.put("ec\u030c", 136);
    freq.put("ea\u0304", 550);
    freq.put("la\u0304c\u030c", 85);
    freq.put("l\u0327ie", 252);
    freq.put(" p ", 50);
    freq.put("\u043d\u0441", 22);
    freq.put("u\u0304t ", 294);
    freq.put(" ps", 120);
    freq.put(" pr", 3156);
    freq.put("\u043d\u0430", 44);
    freq.put(" pu", 1266);
    freq.put("la\u0304n\u0327", 65);
    freq.put("\u043d\u043e", 31);
    freq.put("\u043d\u0438", 29);
    freq.put(" pc", 24);
    freq.put(" pa", 8411);
    freq.put(" pe", 651);
    freq.put(" pi", 5908);
    freq.put(" po", 1148);
    freq.put(" pl", 1389);
    freq.put("a\u0304ps\u030c", 36);
    freq.put("u\u0304tu", 111);
    freq.put("la\u0304s\u030c", 22);
    freq.put("u\u0304ts", 52);
    freq.put("u\u0304tn", 56);
    freq.put("u\u0304to", 32);
    freq.put("u\u0304ti", 73);
    freq.put("u\u0304te", 28);
    freq.put("u\u0304ta", 126);
    freq.put("azd", 25);
    freq.put("uvo", 31);
    freq.put("zga", 142);
    freq.put("vu ", 956);
    freq.put(" Mu\u0304", 173);
    freq.put(" Ma\u0304", 133);
    freq.put("Kru", 113);
    freq.put("Kri", 714);
    freq.put("Kro", 35);
    freq.put(" Me\u0304", 139);
    freq.put("Kra", 70);
    freq.put("Kre", 35);
    freq.put("vul", 71);
    freq.put("vum", 201);
    freq.put("vuk", 61);
    freq.put(" Mi\u0304", 29);
    freq.put("ma\u0304s\u030c", 32);
    freq.put("\u03b1 ", 62);
    freq.put("vus", 141);
    freq.put("zga\u0304", 25);
    freq.put(" pi\u0304", 83);
    freq.put("u\u0304ta\u0304", 37);
    freq.put(" pe\u0304", 1285);
    freq.put("la\u0304 ", 1304);
    freq.put("ei ", 338);
    freq.put(" pa\u0304", 1765);
    freq.put("u\u0304ti\u0304", 135);
    freq.put("\u0446", 23);
    freq.put("lle", 160);
    freq.put(" pu\u0304", 63);
    freq.put("la\u0304m", 367);
    freq.put("eis", 229);
    freq.put("eir", 180);
    freq.put("eit", 215);
    freq.put("la\u0304j", 219);
    freq.put("la\u0304k", 1056);
    freq.put("la\u0304d", 144);
    freq.put("la\u0304g", 85);
    freq.put("la\u0304c", 180);
    freq.put("CO ", 32);
    freq.put("eic", 317);
    freq.put("eib", 23);
    freq.put("eie", 54);
    freq.put("eid", 2544);
    freq.put("eig", 207);
    freq.put("la\u0304t", 209);
    freq.put("eih", 26);
    freq.put("eik", 735);
    freq.put("eim", 142);
    freq.put("eil", 42);
    freq.put("la\u0304r", 401);
    freq.put("ein", 253);
    freq.put("pi\u0304r", 89);
    freq.put("Sid", 28);
    freq.put(" Me", 654);
    freq.put(" Ma", 1344);
    freq.put(" Mo", 496);
    freq.put(" Mi", 483);
    freq.put("ma\u0304 ", 1508);
    freq.put("ve\u0304", 3474);
    freq.put("u\u0304dr", 44);
    freq.put("tn\u0327u", 72);
    freq.put("Kra\u0304", 28);
    freq.put(" My", 39);
    freq.put("NS ", 43);
    freq.put("cek", 125);
    freq.put("ux ", 33);
    freq.put("tli", 341);
    freq.put("ma\u0304s", 220);
    freq.put("ma\u0304r", 102);
    freq.put(" M ", 45);
    freq.put("ma\u0304t", 506);
    freq.put("vus\u030c", 26);
    freq.put("ma\u0304z", 34);
    freq.put("ma\u0304c", 507);
    freq.put("ma\u0304k", 627);
    freq.put("ma\u0304j", 191);
    freq.put("ma\u0304m", 145);
    freq.put("ma\u0304l", 154);
    freq.put("ma\u0304n", 158);
    freq.put("lon\u0327", 26);
    freq.put("am ", 2221);
    freq.put("ps ", 241);
    freq.put("\u041c", 37);
    freq.put("los\u030c", 29);
    freq.put("cm", 65);
    freq.put("ta\u0304v", 1332);
    freq.put("cb", 46);
    freq.put("loz\u030c", 83);
    freq.put("ami", 532);
    freq.put("psk", 78);
    freq.put("psi", 158);
    freq.put("amm", 408);
    freq.put("pso", 28);
    freq.put("amo", 175);
    freq.put("ama", 1351);
    freq.put("amb", 217);
    freq.put("ame", 775);
    freq.put("pse", 42);
    freq.put("amp", 185);
    freq.put("ams", 603);
    freq.put("amu", 130);
    freq.put("pst", 387);
    freq.put("psu", 31);
    freq.put("log\u0327", 845);
    freq.put("re\u0304k\u0327", 47);
    freq.put("loi\u0304", 24);
    freq.put("uce", 66);
    freq.put("t", 118682);
    freq.put("g\u0327i\u0304", 39);
    freq.put("Rak", 35);
    freq.put("Hel", 44);
    freq.put("Bra\u0304", 30);
    freq.put("dz ", 1238);
    freq.put("ta\u0304r", 419);
    freq.put("gu\u0304s", 114);
    freq.put("gu\u0304r", 45);
    freq.put("gu\u0304t", 168);
    freq.put("Bri\u0304", 92);
    freq.put("ude\u0304", 94);
    freq.put("g\u0327e\u0304", 120);
    freq.put("g\u0327e\u0304l", 37);
    freq.put("tdi", 61);
    freq.put("tda", 95);
    freq.put("nme", 24);
    freq.put("nma", 29);
    freq.put("g\u0327e\u0304t", 22);
    freq.put("g\u0327e\u0304r", 24);
    freq.put("dza", 294);
    freq.put("n\u0327br", 28);
    freq.put("oc\u030ca", 27);
    freq.put("sra", 53);
    freq.put("dze", 1097);
    freq.put("dzi", 2913);
    freq.put("oc\u030ci", 28);
    freq.put("dzo", 52);
    freq.put("dzn", 78);
    freq.put("dzs", 170);
    freq.put("dzu", 124);
    freq.put("dzv", 49);
    freq.put("ami\u0304", 170);
    freq.put("Adr", 25);
    freq.put("tu\u0304c", 93);
    freq.put("tu\u0304k", 66);
    freq.put("tu\u0304t", 53);
    freq.put("tu\u0304r", 1186);
    freq.put("Ada", 38);
    freq.put("lob", 58);
    freq.put("loc", 172);
    freq.put("log", 309);
    freq.put("lod", 1255);
    freq.put("ama\u0304", 271);
    freq.put("lok", 186);
    freq.put("lon", 250);
    freq.put("lom", 194);
    freq.put("lor", 215);
    freq.put("los", 267);
    freq.put("lop", 98);
    freq.put("lov", 125);
    freq.put("lot", 233);
    freq.put("loz", 171);
    freq.put("pse\u0304", 31);
    freq.put("ame\u0304", 73);
    freq.put("a\u0304ci", 2513);
    freq.put("\u0646", 33);
    freq.put("pu ", 321);
    freq.put("J", 1801);
    freq.put("gl\u0327u", 239);
    freq.put("rje", 48);
    freq.put("rja", 44);
    freq.put("lo ", 480);
    freq.put("Ent", 23);
    freq.put("dza\u0304", 72);
    freq.put("a\u0304cu", 337);
    freq.put("za\u0304c", 457);
    freq.put("dze\u0304", 373);
    freq.put("Lam", 24);
    freq.put("Lan", 56);
    freq.put("Lai", 103);
    freq.put("Lak", 51);
    freq.put("dzi\u0304", 2001);
    freq.put("Lag", 34);
    freq.put("Lab", 56);
    freq.put("te\u0304g\u0327", 40);
    freq.put("Lat", 1556);
    freq.put("Lau", 64);
    freq.put("Lap", 25);
    freq.put("Lar", 29);
    freq.put("g\u0327i", 2798);
    freq.put("lga", 178);
    freq.put("g\u0327a", 66);
    freq.put("g\u0327e", 601);
    freq.put("g\u0327u", 81);
    freq.put("Bru", 49);
    freq.put("Bro", 55);
    freq.put("Bri", 92);
    freq.put("Bre", 53);
    freq.put("Bra", 125);
    freq.put("Si\u0304", 40);
    freq.put("Se\u0304", 77);
    freq.put("\u041e\u041d ", 57);
    freq.put("Sa\u0304", 102);
    freq.put("mpe", 254);
    freq.put("mpa", 147);
    freq.put("mpo", 156);
    freq.put("mpl", 189);
    freq.put("mpi", 549);
    freq.put("mpt", 22);
    freq.put("mpu", 71);
    freq.put("mpr", 55);
    freq.put("mps", 29);
    freq.put("g\u0327i\u0304t", 31);
    freq.put("osl", 225);
    freq.put("ass", 194);
    freq.put("ega\u0304", 92);
    freq.put("fi\u0304", 68);
    freq.put("fe\u0304", 229);
    freq.put("fa\u0304", 86);
    freq.put("e\u0304ka\u0304", 56);
    freq.put(" ru", 206);
    freq.put("i\u0304ja\u0304", 106);
    freq.put("u\u0304vi", 42);
    freq.put(" re", 2229);
    freq.put("e\u0304ks\u030c", 30);
    freq.put(" ro", 913);
    freq.put(" ri", 726);
    freq.put("s\u030c", 16459);
    freq.put("TS ", 22);
    freq.put("egu\u0304", 271);
    freq.put("egs\u030c", 47);
    freq.put("a\u0304z\u030cu", 50);
    freq.put("jra", 36);
    freq.put("va", 13478);
    freq.put("put", 341);
    freq.put("a\u0304z\u030ca", 23);
    freq.put("S ", 509);
    freq.put("mpa\u0304", 152);
    freq.put("asm", 50);
    freq.put("asl", 59);
    freq.put("Sy", 41);
    freq.put("Sp", 308);
    freq.put("Sv", 222);
    freq.put("Su", 204);
    freq.put("St", 811);
    freq.put("Sk", 318);
    freq.put("Si", 396);
    freq.put("Sh", 52);
    freq.put("So", 292);
    freq.put("Sn", 22);
    freq.put("Sm", 71);
    freq.put("Sl", 112);
    freq.put("Sc", 140);
    freq.put("Sa", 1320);
    freq.put("Se", 449);
    freq.put("vem", 34);
    freq.put("lig\u0327", 139);
    freq.put("vs", 665);
    freq.put("f ", 227);
    freq.put("A\u0304ge", 33);
    freq.put(" ri\u0304", 133);
    freq.put("i\u0304ja", 305);
    freq.put("i\u0304ji", 84);
    freq.put(" ra\u0304", 73);
    freq.put("u\u0304ve\u0304", 84);
    freq.put("i\u0304ju", 700);
    freq.put("e\u0304ku", 376);
    freq.put("e\u0304kt", 35);
    freq.put("fr", 742);
    freq.put("fs", 184);
    freq.put("ft", 143);
    freq.put("fu", 915);
    freq.put("e\u0304ks", 180);
    freq.put("\u03bf\u0301", 36);
    freq.put("fa", 698);
    freq.put("e\u0304ka", 504);
    freq.put("fe", 924);
    freq.put("ff", 54);
    freq.put("fg", 38);
    freq.put("e\u0304kl", 37);
    freq.put("e\u0304ko", 23);
    freq.put("e\u0304ki", 215);
    freq.put(" ru\u0304", 113);
    freq.put("fo", 1630);
    freq.put("a", 237698);
    freq.put("oz\u030ca", 54);
    freq.put("egs", 36);
    freq.put("egr", 83);
    freq.put("egv", 44);
    freq.put("egu", 482);
    freq.put("egt", 159);
    freq.put("egi", 29);
    freq.put("ego", 210);
    freq.put("egl", 203);
    freq.put("ega", 166);
    freq.put("ege", 31);
    freq.put("sta\u0304", 3123);
    freq.put("ce ", 431);
    freq.put("y ", 470);
    freq.put("uvu", 135);
    freq.put("uvi", 141);
    freq.put("ste\u0304", 996);
    freq.put("uva", 357);
    freq.put("uve", 337);
    freq.put(" On", 42);
    freq.put(" Ol", 289);
    freq.put(" Ok", 85);
    freq.put(" Oh", 28);
    freq.put(" Of", 27);
    freq.put(" Og", 53);
    freq.put(" Od", 50);
    freq.put("nce\u0304", 85);
    freq.put(" Ob", 41);
    freq.put("sti\u0304", 1710);
    freq.put(" Ov", 27);
    freq.put(" Ot", 132);
    freq.put(" Or", 178);
    freq.put(" Os", 199);
    freq.put(" Op", 65);
    freq.put("yi", 22);
    freq.put("ced", 32);
    freq.put("ym", 26);
    freq.put("yl", 66);
    freq.put("yo", 86);
    freq.put("yn", 43);
    freq.put("ya", 64);
    freq.put("cen", 1090);
    freq.put("yc", 58);
    freq.put("cel", 374);
    freq.put("ye", 62);
    freq.put("yd", 22);
    freq.put("yg", 24);
    freq.put("pi\u0304b", 56);
    freq.put("cet", 115);
    freq.put("ces", 699);
    freq.put("cer", 171);
    freq.put("pi\u0304d", 81);
    freq.put("cep", 69);
    freq.put("yp", 31);
    freq.put("ys", 126);
    freq.put("yr", 30);
    freq.put("pi\u0304n", 23);
    freq.put("yt", 35);
    freq.put("pi\u0304l", 42);
    freq.put("ifr", 46);
    freq.put("ifs", 22);
    freq.put(" O ", 55);
    freq.put("stu\u0304", 113);
    freq.put("ife", 75);
    freq.put("ifo", 180);
    freq.put("ifi", 245);
    freq.put("lin\u0327", 107);
    freq.put("End", 31);
    freq.put("c\u030c", 1638);
    freq.put("as ", 38125);
    freq.put("kak\u0327", 31);
    freq.put("kal\u0327", 69);
    freq.put("a\u0304n\u0327i", 41);
    freq.put("\u0131 ", 35);
    freq.put("a\u0304n\u0327a", 65);
    freq.put("pe\u0304l\u0327", 144);
    freq.put("a\u0304n\u0327u", 468);
    freq.put("pul", 349);
    freq.put("pum", 233);
    freq.put("pun", 290);
    freq.put("asp", 375);
    freq.put("asv", 32);
    freq.put("asu", 217);
    freq.put("ast", 3489);
    freq.put("pub", 494);
    freq.put("asc", 35);
    freq.put("asa", 1301);
    freq.put("asf", 22);
    freq.put("ase", 553);
    freq.put("ask", 709);
    freq.put("asi", 550);
    freq.put("ash", 28);
    freq.put("aso", 90);
    freq.put("asn", 297);
    freq.put("pur", 145);
    freq.put("pus", 720);
    freq.put("kan\u0327", 374);
    freq.put("ion", 1944);
    freq.put("dip", 35);
    freq.put("iol", 177);
    freq.put("KS ", 29);
    freq.put("Ima", 40);
    freq.put("pi\u0304l\u0327", 68);
    freq.put("Imp", 27);
    freq.put("Pi\u0304", 38);
    freq.put("cel\u0327", 571);
    freq.put("z\u030cur", 90);
    freq.put("z\u030cus", 34);
    freq.put("st ", 664);
    freq.put("tfo", 35);
    freq.put("z\u030cu ", 492);
    freq.put("nch", 29);
    freq.put("nci", 571);
    freq.put("nca", 32);
    freq.put("nce", 476);
    freq.put("ste", 1133);
    freq.put("sta", 3898);
    freq.put("stl", 22);
    freq.put("stm", 49);
    freq.put("stn", 212);
    freq.put("sto", 1125);
    freq.put("sti", 2606);
    freq.put("stu", 1969);
    freq.put("stv", 62);
    freq.put("stp", 85);
    freq.put("rg\u0327i", 226);
    freq.put("str", 3208);
    freq.put("sts", 1496);
    freq.put("rg\u0327e", 23);
    freq.put("Gol", 28);
    freq.put("ka ", 3723);
    freq.put("God", 26);
    freq.put("ez\u030ci", 331);
    freq.put("asi\u0304", 143);
    freq.put("Got", 33);
    freq.put("ase\u0304", 82);
    freq.put("Nik", 51);
    freq.put("lif", 131);
    freq.put("lig", 100);
    freq.put("Nin", 27);
    freq.put("lia", 94);
    freq.put("lib", 49);
    freq.put("lic", 208);
    freq.put("lim", 573);
    freq.put("lin", 517);
    freq.put("lio", 99);
    freq.put("lij", 964);
    freq.put("lik", 929);
    freq.put("lit", 895);
    freq.put("asa\u0304", 83);
    freq.put("2 ", 53);
    freq.put("k\u0327", 3799);
    freq.put("lis", 1779);
    freq.put("ez\u030co", 374);
    freq.put("liz", 308);
    freq.put("kab", 198);
    freq.put("kad", 430);
    freq.put("kak", 37);
    freq.put("kaj", 1054);
    freq.put("kai", 2823);
    freq.put("kan", 621);
    freq.put("kam", 395);
    freq.put("kal", 1136);
    freq.put("kas", 6913);
    freq.put("kar", 1806);
    freq.put("kap", 301);
    freq.put("kav", 162);
    freq.put("kau", 385);
    freq.put("kat", 1010);
    freq.put("rha", 55);
    freq.put("kaz", 48);
    freq.put("The", 138);
    freq.put("rhe", 62);
    freq.put("pe\u0304j", 691);
    freq.put("pe\u0304k", 384);
    freq.put("li ", 1126);
    freq.put("Bi\u0304b", 25);
    freq.put("pe\u0304m", 32);
    freq.put("pe\u0304c", 941);
    freq.put("pe\u0304d", 188);
    freq.put("pe\u0304r", 307);
    freq.put("pe\u0304t", 433);
    freq.put("ru\u0304t", 48);
    freq.put("ru\u0304p", 88);
    freq.put("ru\u0304s", 59);
    freq.put("Equ", 185);
    freq.put("ru\u0304d", 56);
    freq.put(" ti\u0304", 340);
    freq.put("ru\u0304m", 55);
    freq.put("ru\u0304n", 90);
    freq.put("ru\u0304k", 50);
    freq.put("\u0420", 35);
    freq.put("Va\u0304c", 268);
    freq.put(" te\u0304", 247);
    freq.put("ve\u0304g\u0327", 76);
    freq.put("Va\u0304r", 66);
    freq.put("ox ", 29);
    freq.put(" ta\u0304", 1796);
    freq.put("a\u0304bu\u0304", 29);
    freq.put(" tu\u0304", 103);
    freq.put("nc\u030cu", 194);
    freq.put("ve\u0304s\u030c", 46);
    freq.put("nc\u030ca", 33);
    freq.put("x", 396);
    freq.put("\u0430\u044f ", 29);
    freq.put("uve\u0304", 31);
    freq.put("Ja\u0304n\u0327", 29);
    freq.put("wor", 28);
    freq.put("Ple", 55);
    freq.put("Pla", 145);
    freq.put(" i\u0304s", 256);
    freq.put(" i\u0304p", 415);
    freq.put("uva\u0304", 81);
    freq.put("mas\u030c", 145);
    freq.put("ig\u0327i", 165);
    freq.put("ig\u0327e", 27);
    freq.put("gme", 45);
    freq.put("War", 28);
    freq.put(" t ", 61);
    freq.put("ve\u0304 ", 134);
    freq.put("i\u0304di", 166);
    freq.put("a\u0304ba", 24);
    freq.put("a\u0304be", 514);
    freq.put(" tv", 38);
    freq.put(" tu", 790);
    freq.put(" tr", 1203);
    freq.put("N", 1829);
    freq.put(" to", 1082);
    freq.put("a\u0304bu", 87);
    freq.put(" ti", 3365);
    freq.put(" th", 155);
    freq.put(" te", 2144);
    freq.put(" ta", 1745);
    freq.put("ve\u0304r", 790);
    freq.put("ve\u0304s", 501);
    freq.put("ve\u0304t", 425);
    freq.put("ve\u0304c", 27);
    freq.put("ve\u0304j", 244);
    freq.put("adi", 802);
    freq.put("ve\u0304l", 461);
    freq.put("ve\u0304n", 31);
    freq.put("jpu", 34);
    freq.put("oz\u030ca\u0304", 27);
    freq.put("Kva", 27);
    freq.put("Ja\u0304n", 51);
    freq.put("gs ", 1150);
    freq.put("i\u0304de", 154);
    freq.put("lid", 326);
    freq.put("lie", 3537);
    freq.put("FA ", 41);
    freq.put("gst", 733);
    freq.put("gsn", 33);
    freq.put("uta\u0304", 171);
    freq.put("Ka\u0304r", 70);
    freq.put("in\u0327s\u030c", 323);
    freq.put("e\u0304m ", 819);
    freq.put("i\u0304le", 67);
    freq.put("i\u0304la", 22);
    freq.put("uti\u0304", 62);
    freq.put("i\u0304li", 124);
    freq.put("l\u0327os\u030c", 38);
    freq.put("\u03b9", 60);
    freq.put("lip", 94);
    freq.put("ee ", 59);
    freq.put("Ka\u0304 ", 42);
    freq.put("lir", 22);
    freq.put("e\u0304mu", 365);
    freq.put("e\u0304mi", 221);
    freq.put("e\u0304ma", 558);
    freq.put("een", 27);
    freq.put("in\u0327a\u0304", 150);
    freq.put("eej", 99);
    freq.put("k\u0327e", 541);
    freq.put("k\u0327i\u0304m", 271);
    freq.put("ak\u0327i", 22);
    freq.put("k\u0327a", 229);
    freq.put("k\u0327i\u0304n", 49);
    freq.put("k\u0327o", 78);
    freq.put("ru ", 2726);
    freq.put("k\u0327i\u0304d", 71);
    freq.put("k\u0327i", 1644);
    freq.put("sva\u0304", 52);
    freq.put("tuv", 673);
    freq.put("k\u0327u", 510);
    freq.put("k\u0327s", 30);
    freq.put("k\u0327i\u0304s", 84);
    freq.put("k\u0327i\u0304r", 23);
    freq.put("sve\u0304", 166);
    freq.put("svi\u0304", 41);
    freq.put("\u0437", 76);
    freq.put("id ", 25);
    freq.put("ruk", 350);
    freq.put("run", 357);
    freq.put("E\u0304r", 64);
    freq.put("rum", 1852);
    freq.put("ruc", 33);
    freq.put("a\u0304r ", 34);
    freq.put("rud", 44);
    freq.put("ruz", 42);
    freq.put("Ti\u0304", 49);
    freq.put("rur", 31);
    freq.put("rus", 878);
    freq.put("rup", 644);
    freq.put("rut", 84);
    freq.put("rhi", 273);
    freq.put("idz", 312);
    freq.put("idu", 626);
    freq.put("idr", 632);
    freq.put("ids", 336);
    freq.put("idp", 27);
    freq.put("idn", 29);
    freq.put("ido", 1694);
    freq.put("idm", 53);
    freq.put("idi", 317);
    freq.put("idd", 33);
    freq.put("ide", 638);
    freq.put("ida", 1167);
    freq.put("in\u0327u", 475);
    freq.put("Eli", 48);
    freq.put("in\u0327s", 42);
    freq.put("oha", 113);
    freq.put("Ele", 79);
    freq.put("in\u0327a", 746);
    freq.put("in\u0327o", 51);
    freq.put("in\u0327i", 157);
    freq.put("in\u0327j", 22);
    freq.put("l\u0327os", 305);
    freq.put("ut ", 97);
    freq.put("l\u0327ot", 251);
    freq.put("s\u030cum", 55);
    freq.put("s\u030cus", 57);
    freq.put("kus", 576);
    freq.put("l\u0327oj", 28);
    freq.put("e\u0304ma\u0304", 142);
    freq.put("us\u030cu", 56);
    freq.put("utb", 797);
    freq.put("s\u030cu ", 1883);
    freq.put("uta", 279);
    freq.put("pe\u0304l", 736);
    freq.put("ute", 201);
    freq.put("S\u030caj", 103);
    freq.put("uti", 652);
    freq.put("utn", 283);
    freq.put("uto", 580);
    freq.put("i\u0304li\u0304", 22);
    freq.put("utr", 30);
    freq.put("uts", 90);
    freq.put("S\u030car", 24);
    freq.put("utv", 22);
    freq.put("utt", 67);
    freq.put("utu", 102);
    freq.put("z\u030cku", 26);
    freq.put("Tu", 367);
    freq.put("Tr", 348);
    freq.put("ide\u0304", 338);
    freq.put("To", 528);
    freq.put("Tj", 24);
    freq.put("Th", 183);
    freq.put("E\u0304g\u0327", 41);
    freq.put("Te", 412);
    freq.put("ida\u0304", 226);
    freq.put("nab", 23);
    freq.put("A ", 493);
    freq.put("vsk", 63);
    freq.put("naf", 23);
    freq.put("nag", 57);
    freq.put("nad", 66);
    freq.put("nae", 90);
    freq.put("naj", 193);
    freq.put("nak", 85);
    freq.put("rua\u0304", 39);
    freq.put("Uz ", 28);
    freq.put("nal", 235);
    freq.put("nam", 315);
    freq.put("nar", 136);
    freq.put("nas", 3073);
    freq.put("nav", 456);
    freq.put("idi\u0304", 348);
    freq.put("nat", 306);
    freq.put("nau", 117);
    freq.put("naz", 22);
    freq.put("rus\u030c", 59);
    freq.put("k\u0327i\u0304", 541);
    freq.put("tms", 32);
    freq.put("T ", 118);
    freq.put("idz\u030c", 50);
    freq.put("Ac", 82);
    freq.put("Ab", 147);
    freq.put("dvi", 33);
    freq.put("Ad", 148);
    freq.put("k\u0327a\u0304", 31);
    freq.put("svi", 110);
    freq.put("dve", 34);
    freq.put("Ah", 37);
    freq.put("Ak", 154);
    freq.put("sve", 113);
    freq.put("run\u0327", 155);
    freq.put("Al", 535);
    freq.put("An", 739);
    freq.put("Ap", 260);
    freq.put("As", 243);
    freq.put("Ar", 519);
    freq.put("k\u0327e\u0304", 171);
    freq.put("idu\u0304", 60);
    freq.put("Av", 74);
    freq.put("Az", 34);
    freq.put("gv", 152);
    freq.put("gu", 2538);
    freq.put("gt", 345);
    freq.put("gs", 1978);
    freq.put("gr", 3115);
    freq.put("gz", 413);
    freq.put("gg", 39);
    freq.put("ge", 675);
    freq.put("gd", 52);
    freq.put("gb", 23);
    freq.put("ga", 11955);
    freq.put("go", 1269);
    freq.put("gn", 346);
    freq.put("gm", 103);
    freq.put("gl", 1302);
    freq.put("gk", 23);
    freq.put("gi", 1023);
    freq.put("gh", 75);
    freq.put("lko", 184);
    freq.put("lkl", 39);
    freq.put("Nok", 22);
    freq.put("lke", 27);
    freq.put("Nob", 33);
    freq.put("lka", 119);
    freq.put("Not", 22);
    freq.put("Nov", 61);
    freq.put("lku", 31);
    freq.put("\u03bd", 83);
    freq.put("lks", 97);
    freq.put("Nor", 163);
    freq.put("Nos", 50);
    freq.put("kci", 508);
    freq.put("g ", 378);
    freq.put("zs\u030c", 91);
    freq.put("hi ", 25);
    freq.put("tml", 23);
    freq.put("No ", 69);
    freq.put("Spi", 27);
    freq.put("Spo", 27);
    freq.put("Spa", 42);
    freq.put("n\u0327s\u030c ", 323);
    freq.put("Spe", 35);
    freq.put("zl", 791);
    freq.put("zm", 1200);
    freq.put("zn", 964);
    freq.put("zo", 976);
    freq.put("zi", 7929);
    freq.put("zj", 64);
    freq.put("zk", 332);
    freq.put("zd", 606);
    freq.put("ze", 4296);
    freq.put("zg", 379);
    freq.put("za", 1506);
    freq.put("zb", 206);
    freq.put("zc", 577);
    freq.put("zz", 61);
    freq.put("zt", 460);
    freq.put("zu", 648);
    freq.put("zv", 1734);
    freq.put("zp", 657);
    freq.put("zr", 375);
    freq.put("zs", 1624);
    freq.put("iz\u030ck", 30);
    freq.put("iz\u030ce", 26);
    freq.put("iz\u030ca", 92);
    freq.put("iz\u030cu", 32);
    freq.put(" va\u0304", 1227);
    freq.put("oze", 115);
    freq.put("ull", 58);
    freq.put("oza", 288);
    freq.put("ozo", 189);
    freq.put("ulm", 42);
    freq.put("z ", 3167);
    freq.put("\u043b\u043e", 25);
    freq.put("ulb", 50);
    freq.put(" ve\u0304", 1059);
    freq.put("ozu", 30);
    freq.put("ni\u0304m", 63);
    freq.put("ulf", 35);
    freq.put(" vi\u0304", 192);
    freq.put("ulg", 48);
    freq.put("\u0440\u0430", 42);
    freq.put("dus\u030c", 31);
    freq.put("\u0440\u0438", 31);
    freq.put("\u0440\u043e", 53);
    freq.put("lkn\u0327", 24);
    freq.put("gz\u030c", 90);
    freq.put("Spe\u0304", 56);
    freq.put("IA ", 51);
    freq.put("gs\u030c", 291);
    freq.put("OS ", 28);
    freq.put("Spa\u0304", 87);
    freq.put("gu\u0304", 417);
    freq.put("lks\u030c", 22);
    freq.put("ps\u030c", 285);
    freq.put("jda", 46);
    freq.put("gl\u0327", 378);
    freq.put("lka\u0304", 113);
    freq.put("Je", 180);
    freq.put("ge\u0304", 101);
    freq.put("Ja", 606);
    freq.put("ga\u0304", 2261);
    freq.put("zu\u0304", 24);
    freq.put("ozi\u0304", 528);
    freq.put("ine\u0304", 330);
    freq.put(" va", 7044);
    freq.put(" ve", 2127);
    freq.put("oza\u0304", 24);
    freq.put(" vi", 7158);
    freq.put("zn\u0327", 392);
    freq.put(" vo", 159);
    freq.put(" vu", 52);
    freq.put("L\u0327", 56);
    freq.put("kro", 296);
    freq.put("zi\u0304", 3820);
    freq.put("iz\u030ca\u0304", 28);
    freq.put("u\u0304zi", 561);
    freq.put("ic\u030cs", 33);
    freq.put("u\u0304nu", 55);
    freq.put("za\u0304", 1002);
    freq.put("u\u0304ns", 22);
    freq.put("pa\u0304", 3136);
    freq.put("ze\u0304", 1137);
    freq.put("zme", 35);
    freq.put("jni", 88);
    freq.put("ic\u030cu", 24);
    freq.put("\u0628", 27);
    freq.put("rsa\u0304", 44);
    freq.put("rse\u0304", 59);
    freq.put("rsu\u0304", 33);
    freq.put(" Se\u0304", 77);
    freq.put(" Sa\u0304", 102);
    freq.put("c\u0327", 26);
    freq.put(" Si\u0304", 40);
    freq.put("bez\u030c", 545);
    freq.put("ura\u0304", 908);
    freq.put("map", 23);
    freq.put("ug\u0327u", 36);
    freq.put("hlo", 75);
    freq.put("l\u0327in\u0327", 134);
    freq.put("mar", 276);
    freq.put("i\u0304mi", 343);
    freq.put("ure\u0304", 196);
    freq.put("i\u0304no", 33);
    freq.put("i\u0304ni", 507);
    freq.put("i\u0304ne", 41);
    freq.put("i\u0304na", 462);
    freq.put("i\u0304nu", 169);
    freq.put("i\u0304ns", 285);
    freq.put("\u043f", 57);
    freq.put("ece", 209);
    freq.put("kst", 1947);
    freq.put("eca", 89);
    freq.put("eco", 62);
    freq.put("eck", 45);
    freq.put("eci", 633);
    freq.put("ech", 44);
    freq.put("ecu", 116);
    freq.put("ect", 70);
    freq.put("ecp", 24);
    freq.put("urs\u030c", 530);
    freq.put("adz\u030c", 91);
    freq.put("ez\u030cg\u0327", 48);
    freq.put("ce\u0304", 786);
    freq.put("mad", 68);
    freq.put("ug\u0327a", 52);
    freq.put("rs ", 2853);
    freq.put("su\u0304t", 95);
    freq.put(" Sy", 39);
    freq.put(" Sp", 307);
    freq.put(" Sv", 220);
    freq.put(" St", 793);
    freq.put(" Su", 203);
    freq.put(" Sk", 316);
    freq.put(" Sh", 52);
    freq.put(" Si", 395);
    freq.put(" Sn", 22);
    freq.put(" So", 290);
    freq.put(" Sl", 112);
    freq.put(" Sm", 70);
    freq.put(" Sc", 134);
    freq.put(" Sa", 1313);
    freq.put(" Se", 442);
    freq.put("rsl", 46);
    freq.put("rsm", 215);
    freq.put("rsn", 57);
    freq.put("rso", 354);
    freq.put("rsi", 451);
    freq.put("rsk", 108);
    freq.put("rsd", 23);
    freq.put("rse", 69);
    freq.put("rsa", 148);
    freq.put("R", 3339);
    freq.put("rst", 685);
    freq.put("rsu", 128);
    freq.put("rsv", 73);
    freq.put("cyo", 60);
    freq.put("rss", 51);
    freq.put("bek", 85);
    freq.put("bei", 323);
    freq.put("ben", 195);
    freq.put("bel", 118);
    freq.put("bed", 22);
    freq.put("bez", 361);
    freq.put("ber", 482);
    freq.put("bes", 245);
    freq.put(" S ", 101);
    freq.put("bet", 713);
    freq.put("are", 686);
    freq.put("eci\u0304", 715);
    freq.put("arh", 312);
    freq.put("ari", 685);
    freq.put("ade\u0304", 277);
    freq.put("ur ", 573);
    freq.put("eca\u0304", 200);
    freq.put("arm", 206);
    freq.put("bur", 350);
    freq.put("ece\u0304", 53);
    freq.put("bus", 88);
    freq.put("l\u0327in", 31);
    freq.put("aro", 671);
    freq.put("BA ", 99);
    freq.put("ni\u0304r", 102);
    freq.put("Gra\u0304", 24);
    freq.put("\ufeff", 23);
    freq.put("i\u0304na\u0304", 148);
    freq.put("c\u030cu\u0304s", 27);
    freq.put("urd", 30);
    freq.put("ure", 246);
    freq.put("urg", 216);
    freq.put("i\u0304ni\u0304", 56);
    freq.put("urb", 65);
    freq.put("urc", 141);
    freq.put("url", 46);
    freq.put("zmu", 41);
    freq.put("urn", 303);
    freq.put("uro", 291);
    freq.put("uri", 851);
    freq.put("urj", 22);
    freq.put("urk", 327);
    freq.put("urt", 245);
    freq.put("uru", 1149);
    freq.put("urv", 97);
    freq.put("urp", 107);
    freq.put("urs", 344);
    freq.put("Del", 44);
    freq.put("urz", 200);
    freq.put("oti\u0304", 57);
    freq.put("Den", 34);
    freq.put("z\u030cis", 66);
    freq.put("bum", 299);
    freq.put("z\u030cie", 84);
    freq.put("nge", 139);
    freq.put("nga", 229);
    freq.put("ngl", 303);
    freq.put("ota\u0304", 1010);
    freq.put("ngo", 130);
    freq.put("ngi", 47);
    freq.put("sh ", 43);
    freq.put("ngu", 183);
    freq.put("ngv", 61);
    freq.put("ngr", 212);
    freq.put("ngs", 108);
    freq.put("ote\u0304", 115);
    freq.put("n\u0327da", 33);
    freq.put("mga", 146);
    freq.put("na\u0304s\u030c", 340);
    freq.put("tbr", 38);
    freq.put("tbi", 216);
    freq.put("fe\u0304r", 208);
    freq.put("tbo", 1157);
    freq.put("tba", 91);
    freq.put("z\u030ci ", 383);
    freq.put("ng ", 184);
    freq.put("dpo", 22);
    freq.put("shi", 22);
    freq.put("m2 ", 52);
    freq.put("sho", 31);
    freq.put("ke ", 111);
    freq.put("lup", 35);
    freq.put("lur", 30);
    freq.put("lus", 425);
    freq.put("lut", 87);
    freq.put("lub", 111);
    freq.put("luc", 32);
    freq.put("lud", 54);
    freq.put("lug", 36);
    freq.put("\u043b", 187);
    freq.put("luk", 23);
    freq.put("lum", 401);
    freq.put("luo", 34);
    freq.put("ken", 50);
    freq.put("kel", 71);
    freq.put("Dze", 94);
    freq.put("kej", 204);
    freq.put("Dzi", 93);
    freq.put("ket", 457);
    freq.put("kes", 27);
    freq.put("ker", 86);
    freq.put("uum", 27);
    freq.put("\u0440 ", 25);
    freq.put("lu ", 1807);
    freq.put("na\u0304 ", 1513);
    freq.put("she\u0304", 40);
    freq.put("ot ", 1449);
    freq.put("Lok", 22);
    freq.put("Lon", 64);
    freq.put("Lor", 22);
    freq.put("fga", 33);
    freq.put("int", 1230);
    freq.put("kre\u0304", 127);
    freq.put(" S\u030ck\u0327", 45);
    freq.put("\u0434", 133);
    freq.put("oth", 36);
    freq.put("na\u0304c", 166);
    freq.put("nga\u0304", 136);
    freq.put("na\u0304d", 289);
    freq.put("oto", 694);
    freq.put("na\u0304j", 705);
    freq.put("na\u0304k", 422);
    freq.put("ote", 602);
    freq.put("na\u0304l", 1149);
    freq.put("na\u0304m", 427);
    freq.put("na\u0304r", 126);
    freq.put("na\u0304s", 1024);
    freq.put("na\u0304v", 198);
    freq.put("inr", 24);
    freq.put("na\u0304t", 1807);
    freq.put("otr", 369);
    freq.put("u\u0304na\u0304", 49);
    freq.put("ott", 59);
    freq.put("otu", 305);
    freq.put("And", 123);
    freq.put("Ang", 135);
    freq.put("Ana", 95);
    freq.put("Ann", 55);
    freq.put("zsa", 231);
    freq.put("Ant", 228);
    freq.put("ngl\u0327", 211);
    freq.put("Dzi\u0304", 27);
    freq.put("\u0411", 29);
    freq.put("kra\u0304", 588);
    freq.put("kea\u0304", 336);
    freq.put("ts\u030ck\u0327", 209);
    freq.put("pi\u0304", 487);
    freq.put("i", 199506);
    freq.put("sbu", 40);
    freq.put("ksi", 433);
    freq.put("ria\u0304", 400);
    freq.put("eag\u0327", 26);
    freq.put("hi\u0304", 43);
    freq.put("Be", 447);
    freq.put("Ba", 1010);
    freq.put("Bl", 116);
    freq.put("he\u0304", 85);
    freq.put("Bo", 341);
    freq.put("Bi", 333);
    freq.put("Bu", 240);
    freq.put("n\u0327os", 47);
    freq.put("Br", 526);
    freq.put("ha\u0304", 197);
    freq.put("a\u0304fi", 261);
    freq.put("HK ", 23);
    freq.put("a\u0304fr", 63);
    freq.put("a\u0304fs", 37);
    freq.put("B ", 133);
    freq.put(" x ", 60);
    freq.put(" C\u030ci\u0304", 26);
    freq.put("ru\u0304s\u030c", 31);
    freq.put("ona\u0304", 1526);
    freq.put("lni\u0304", 100);
    freq.put("ba\u0304 ", 646);
    freq.put("U ", 122);
    freq.put("l\u0327ve", 81);
    freq.put("ubs", 106);
    freq.put("l\u0327vi", 28);
    freq.put("g\u0327u ", 60);
    freq.put("n\u0327az", 78);
    freq.put("ba\u0304t", 57);
    freq.put("ba\u0304s", 254);
    freq.put("Uz", 97);
    freq.put("ba\u0304z", 178);
    freq.put("Up", 46);
    freq.put("Ur", 133);
    freq.put("Ul", 29);
    freq.put("Un", 191);
    freq.put("Uk", 57);
    freq.put("ba\u0304n", 43);
    freq.put("dul", 78);
    freq.put("ba\u0304l", 44);
    freq.put("ba\u0304m", 208);
    freq.put("ba\u0304j", 44);
    freq.put("ba\u0304k", 295);
    freq.put("dun", 24);
    freq.put("iez\u030c", 570);
    freq.put("n\u0327as", 543);
    freq.put("s\u030cie", 334);
    freq.put("ea ", 66);
    freq.put("h ", 326);
    freq.put("ca\u0304 ", 43);
    freq.put(" C\u030ce", 124);
    freq.put(" C\u030ca", 35);
    freq.put("n\u0327ak", 24);
    freq.put("i\u0304bv", 37);
    freq.put(" C\u030ci", 48);
    freq.put("i\u0304pa", 426);
    freq.put(" C\u030cu", 25);
    freq.put("n\u0327ai", 51);
    freq.put("eak", 105);
    freq.put("hy", 49);
    freq.put("eal", 83);
    freq.put("ean", 79);
    freq.put("ca\u0304s", 52);
    freq.put("hs", 176);
    freq.put("Ju\u0304", 171);
    freq.put("ht", 159);
    freq.put("hu", 177);
    freq.put("ca\u0304k", 136);
    freq.put("pj", 212);
    freq.put("hi", 1019);
    freq.put("hn", 345);
    freq.put("ho", 773);
    freq.put("ca\u0304m", 35);
    freq.put("Be\u0304", 72);
    freq.put("eap", 54);
    freq.put("eas", 36);
    freq.put("ear", 51);
    freq.put("eau", 46);
    freq.put("ph", 171);
    freq.put("he", 981);
    freq.put("dma", 88);
    freq.put("pi", 8931);
    freq.put("dmi", 319);
    freq.put("Bi\u0304", 48);
    freq.put("n\u0327os\u030c", 22);
    freq.put("hn ", 22);
    freq.put(" Uz", 96);
    freq.put("e\u0304sl", 23);
    freq.put(" Up", 44);
    freq.put(" Ur", 133);
    freq.put(" Ul", 29);
    freq.put(" Un", 191);
    freq.put(" Uk", 57);
    freq.put(" Ug", 37);
    freq.put("a\u0304bj", 26);
    freq.put("eot", 23);
    freq.put("ba\u0304s\u030c", 52);
    freq.put("hni", 146);
    freq.put("k\u0327en", 35);
    freq.put("hno", 151);
    freq.put(" U ", 30);
    freq.put("ti\u0304 ", 235);
    freq.put("auc", 511);
    freq.put("aud", 1114);
    freq.put("aug", 1739);
    freq.put("auk", 1608);
    freq.put("auj", 444);
    freq.put("aum", 53);
    freq.put("aul", 1187);
    freq.put("up ", 25);
    freq.put("aun", 922);
    freq.put("aup", 26);
    freq.put("aus", 1232);
    freq.put("aur", 568);
    freq.put("aut", 1629);
    freq.put("auv", 33);
    freq.put("auz", 73);
    freq.put("a\u0304bi", 54);
    freq.put("ec\u030ce", 56);
    freq.put("ti\u0304g", 275);
    freq.put("ti\u0304d", 188);
    freq.put("ti\u0304b", 1094);
    freq.put("nul", 25);
    freq.put("ti\u0304n", 159);
    freq.put("ti\u0304m", 268);
    freq.put("ti\u0304j", 350);
    freq.put("ti\u0304k", 237);
    freq.put("ec\u030cu", 47);
    freq.put("Joh", 102);
    freq.put("ti\u0304t", 1190);
    freq.put("ti\u0304r", 77);
    freq.put("ti\u0304s", 433);
    freq.put("au ", 159);
    freq.put("upj", 23);
    freq.put("S\u030cei", 27);
    freq.put("upi", 127);
    freq.put("upe", 293);
    freq.put("upa", 461);
    freq.put("upu", 109);
    freq.put("S\u030cep", 43);
    freq.put("olk", 110);
    freq.put("me ", 570);
    freq.put("z\u030cot", 153);
    freq.put("z\u030cor", 51);
    freq.put("z\u030cos", 33);
    freq.put("z\u030con", 63);
    freq.put("Iga", 176);
    freq.put("ovi\u0304", 25);
    freq.put("nen", 247);
    freq.put("ove\u0304", 187);
    freq.put("nel", 264);
    freq.put("nem", 97);
    freq.put("nej", 92);
    freq.put("nek", 293);
    freq.put("nei", 201);
    freq.put("neg", 80);
    freq.put("ned", 153);
    freq.put("neb", 55);
    freq.put("nec", 44);
    freq.put("nea", 224);
    freq.put("ova\u0304", 78);
    freq.put("nez", 35);
    freq.put("nev", 218);
    freq.put("net", 418);
    freq.put("ner", 698);
    freq.put("nes", 1590);
    freq.put("nep", 336);
    freq.put("med", 310);
    freq.put("\u0443", 116);
    freq.put("oru", 295);
    freq.put("mem", 29);
    freq.put("mel", 157);
    freq.put("men", 1391);
    freq.put("mei", 147);
    freq.put("meh", 105);
    freq.put("mek", 209);
    freq.put("met", 1247);
    freq.put("mes", 1625);
    freq.put("mer", 791);
    freq.put("z\u030co ", 82);
    freq.put("mez", 28);
    freq.put("ve\u0304k", 693);
    freq.put("Alu\u0304", 46);
    freq.put("drs", 87);
    freq.put("dru", 292);
    freq.put("ne ", 1014);
    freq.put("dri", 640);
    freq.put("dro", 640);
    freq.put("dra", 350);
    freq.put("dre", 139);
    freq.put("ti\u0304g\u0327", 32);
    freq.put("aun\u0327", 57);
    freq.put("upa\u0304", 104);
    freq.put("upe\u0304", 50);
    freq.put("aus\u030c", 105);
    freq.put("upi\u0304", 23);
    freq.put("orc", 49);
    freq.put("auz\u030c", 79);
    freq.put("Ste", 80);
    freq.put("kgr", 28);
    freq.put("Sta", 349);
    freq.put("ti\u0304s\u030c", 166);
    freq.put("Sto", 87);
    freq.put("u\u0304ci", 182);
    freq.put("Sti", 60);
    freq.put("kga", 63);
    freq.put("Stu", 53);
    freq.put("arz\u030c", 51);
    freq.put("Str", 115);
    freq.put("V", 3715);
    freq.put("ti\u0304n\u0327", 237);
    freq.put("rio", 330);
    freq.put(" Pa\u0304", 146);
    freq.put("E\u0304g\u0327i", 41);
    freq.put("Lie", 695);
    freq.put("Lib", 28);
    freq.put("Lim", 30);
    freq.put("Lin", 97);
    freq.put("Lit", 29);
    freq.put("Liv", 157);
    freq.put("rig", 98);
    freq.put("dra\u0304", 113);
    freq.put("mel\u0327", 1113);
    freq.put("z\u030cos\u030c", 80);
    freq.put("Kab", 22);
    freq.put("Kad", 24);
    freq.put("Kai", 30);
    freq.put("Kan", 182);
    freq.put("Kam", 79);
    freq.put("Kal", 190);
    freq.put("Kas", 57);
    freq.put("Kar", 357);
    freq.put("dri\u0304", 349);
    freq.put("Kap", 52);
    freq.put("Kau", 72);
    freq.put("Kat", 99);
    freq.put("Kaz", 79);
    freq.put("ovs", 143);
    freq.put("ova", 643);
    freq.put("ovg", 31);
    freq.put("ove", 137);
    freq.put("ovi", 389);
    freq.put("All", 36);
    freq.put("men\u0327", 339);
    freq.put("Alf", 40);
    freq.put("Ale", 93);
    freq.put("Alb", 79);
    freq.put("Ala", 26);
    freq.put("sju\u0304", 46);
    freq.put("nel\u0327", 30);
    freq.put("Alt", 55);
    freq.put("Alp", 29);
    freq.put("e\u0304z\u030c", 23);
    freq.put("e\u0304s\u030c", 773);
    freq.put("e\u0304n\u0327", 27);
    freq.put("\u03c1", 66);
    freq.put("e\u0304l\u0327", 376);
    freq.put("e\u0304k\u0327", 56);
    freq.put("ong", 158);
    freq.put("e\u0304g\u0327", 190);
    freq.put("a\u0304n\u0327", 597);
    freq.put("Wor", 39);
    freq.put("SS ", 24);
    freq.put("a\u0304s\u030c", 567);
    freq.put(" zo", 142);
    freq.put("gz\u030cn\u0327", 89);
    freq.put(" ze", 740);
    freq.put(" za", 193);
    freq.put("zdo", 186);
    freq.put(" zu", 23);
    freq.put("is ", 8439);
    freq.put("a\u0304z\u030c", 93);
    freq.put("a\u0304du", 390);
    freq.put("a\u0304ds", 129);
    freq.put("a\u0304c\u030c", 113);
    freq.put("zde", 234);
    freq.put("a\u0304de", 246);
    freq.put("a\u0304da", 636);
    freq.put("a\u0304dn", 33);
    freq.put("a\u0304do", 104);
    freq.put("i\u0304ra\u0304", 42);
    freq.put("a\u0304di", 416);
    freq.put("k\u0327es\u030c", 66);
    freq.put("e\u0304ci\u0304", 76);
    freq.put("iss", 145);
    freq.put("isp", 195);
    freq.put("isv", 78);
    freq.put("isu", 253);
    freq.put("ist", 3658);
    freq.put("isk", 6070);
    freq.put("isi", 459);
    freq.put("ish", 36);
    freq.put("iso", 147);
    freq.put("isn", 115);
    freq.put("ism", 951);
    freq.put("isl", 163);
    freq.put("isc", 158);
    freq.put("isb", 151);
    freq.put("isa", 605);
    freq.put("a\u0304l\u0327", 238);
    freq.put("ise", 117);
    freq.put("e\u0304z", 349);
    freq.put("e\u0304s", 1279);
    freq.put("e\u0304r", 3544);
    freq.put("e\u0304p", 82);
    freq.put("e\u0304v", 258);
    freq.put("e\u0304t", 4896);
    freq.put("e\u0304k", 1496);
    freq.put("e\u0304j", 4209);
    freq.put(" ka", 7945);
    freq.put("e\u0304n", 867);
    freq.put("e\u0304m", 2242);
    freq.put("e\u0304l", 2212);
    freq.put("e\u0304c", 1136);
    freq.put("e\u0304b", 25);
    freq.put("e\u0304g", 174);
    freq.put("e\u0304d", 833);
    freq.put("e\u0304 ", 2668);
    freq.put("A\u0304b", 22);
    freq.put("A\u0304f", 113);
    freq.put("A\u0304g", 35);
    freq.put("A\u0304d", 23);
    freq.put("A\u0304r", 50);
    freq.put("A\u0304z", 143);
    freq.put("ty ", 51);
    freq.put("Izr", 29);
    freq.put("Izv", 72);
    freq.put("isa\u0304", 208);
    freq.put("a\u0304di\u0304", 293);
    freq.put("a\u0304c", 3184);
    freq.put("a\u0304b", 862);
    freq.put("e\u0304ci", 41);
    freq.put("a\u0304d", 3136);
    freq.put("a\u0304g", 215);
    freq.put("a\u0304f", 379);
    freq.put("i\u0304rs", 118);
    freq.put("do ", 341);
    freq.put("a\u0304j", 3661);
    freq.put("a\u0304m", 4331);
    freq.put("a\u0304l", 5581);
    freq.put("a\u0304n", 2529);
    freq.put("isi\u0304", 84);
    freq.put("a\u0304p", 472);
    freq.put("a\u0304s", 7161);
    freq.put("a\u0304r", 6698);
    freq.put("a\u0304t", 4781);
    freq.put("a\u0304v", 1981);
    freq.put("a\u0304z", 697);
    freq.put("tyl", 39);
    freq.put(" za\u0304", 53);
    freq.put("doj", 533);
    freq.put("a\u0304 ", 23455);
    freq.put("don", 402);
    freq.put(" zi\u0304", 183);
    freq.put("dom", 421);
    freq.put("dob", 64);
    freq.put("m", 69285);
    freq.put("e\u0304c ", 930);
    freq.put("dod", 87);
    freq.put("doe", 23);
    freq.put("k\u0327es", 25);
    freq.put("k\u0327er", 270);
    freq.put("k\u0327et", 39);
    freq.put("dor", 118);
    freq.put("dos", 455);
    freq.put("dov", 34);
    freq.put("dow", 29);
    freq.put("dot", 762);
    freq.put(" We", 44);
    freq.put(" Wa", 65);
    freq.put(" Wo", 56);
    freq.put(" Wi", 95);
    freq.put("Ce\u0304", 86);
    freq.put("sla\u0304", 344);
    freq.put("kul", 627);
    freq.put("ba ", 1526);
    freq.put("sli\u0304", 114);
    freq.put("ac\u030cu", 132);
    freq.put("\u03c5", 22);
    freq.put(" W ", 26);
    freq.put("zsv", 33);
    freq.put("ri\u0304s\u030c", 55);
    freq.put("bat", 100);
    freq.put("bau", 36);
    freq.put("bar", 192);
    freq.put("bas", 2875);
    freq.put("ute\u0304", 47);
    freq.put("baz", 174);
    freq.put("bag", 46);
    freq.put("bad", 23);
    freq.put("bac", 26);
    freq.put("ban", 81);
    freq.put("bal", 1602);
    freq.put("bam", 32);
    freq.put("baj", 47);
    freq.put("bak", 69);
    freq.put("bai", 173);
    freq.put("Va\u0304", 356);
    freq.put("om ", 55);
    freq.put("iz\u030c", 275);
    freq.put("rz\u030cu", 43);
    freq.put("Ve\u0304", 122);
    freq.put("is\u030c", 513);
    freq.put("Run", 31);
    freq.put("Rum", 56);
    freq.put("Rub", 29);
    freq.put("Vi\u0304", 58);
    freq.put("un ", 9898);
    freq.put("Sve\u0304", 102);
    freq.put("in\u0327", 2232);
    freq.put("omb", 95);
    freq.put("C", 2145);
    freq.put("il\u0327", 351);
    freq.put("ome", 546);
    freq.put("omj", 98);
    freq.put("omi", 730);
    freq.put("omo", 191);
    freq.put("I\u0304ri", 58);
    freq.put("oms", 200);
    freq.put("omp", 487);
    freq.put("omu", 284);
    freq.put("omt", 26);
    freq.put("ig\u0327", 203);
    freq.put("unr", 34);
    freq.put("uns", 163);
    freq.put("unt", 48);
    freq.put("unu", 158);
    freq.put("unv", 30);
    freq.put("ie\u0304", 45);
    freq.put("n\u0327ie", 244);
    freq.put("una", 264);
    freq.put("unc", 25);
    freq.put("ic\u030c", 143);
    freq.put("n\u0327g\u0327e", 27);
    freq.put("ung", 150);
    freq.put("ia\u0304", 1355);

    init2();
  }
  private static void init2() {
    
    freq.put("uni", 663);
    freq.put("zsk", 600);
    freq.put("unl", 25);
    freq.put("uno", 67);
    freq.put("n\u0327ot", 124);
    freq.put("Ies", 23);
    freq.put("Ier", 30);
    freq.put("Iek", 27);
    freq.put("ri\u0304 ", 2361);
    freq.put("Ied", 23);
    freq.put("C ", 377);
    freq.put("ri\u0304t", 190);
    freq.put("ri\u0304v", 387);
    freq.put("ri\u0304s", 243);
    freq.put("ri\u0304z", 162);
    freq.put("ri\u0304d", 236);
    freq.put("e\u0304ra\u0304", 124);
    freq.put("ri\u0304b", 593);
    freq.put("ri\u0304c", 210);
    freq.put("ri\u0304l", 26);
    freq.put("ri\u0304n", 188);
    freq.put("ri\u0304j", 40);
    freq.put("ri\u0304k", 162);
    freq.put("Ci", 209);
    freq.put("Ch", 135);
    freq.put("Co", 292);
    freq.put("Cl", 54);
    freq.put("slu", 68);
    freq.put("Ca", 279);
    freq.put("Ce", 347);
    freq.put("slo", 148);
    freq.put("sli", 399);
    freq.put("akr", 121);
    freq.put("Cr", 43);
    freq.put("sla", 592);
    freq.put("Cu", 37);
    freq.put("Nac", 121);
    freq.put("iz", 8191);
    freq.put("iq", 24);
    freq.put("ip", 1361);
    freq.put("is", 22114);
    freq.put("ir", 20819);
    freq.put("iu", 210);
    freq.put("it", 6916);
    freq.put("Nam", 26);
    freq.put("ii", 76);
    freq.put("ih", 374);
    freq.put("ik", 8262);
    freq.put("ij", 18002);
    freq.put("im", 5227);
    freq.put("il", 7272);
    freq.put("Nat", 30);
    freq.put("in", 12037);
    freq.put("ia", 987);
    freq.put("ic", 1972);
    freq.put("ki ", 1566);
    freq.put("ie", 43851);
    freq.put("id", 6988);
    freq.put("ig", 1651);
    freq.put("if", 662);
    freq.put("V ", 507);
    freq.put("oma\u0304", 452);
    freq.put("ome\u0304", 208);
    freq.put("sau", 2277);
    freq.put("s\u030ce\u0304j", 249);
    freq.put("uni\u0304", 25);
    freq.put("kis", 66);
    freq.put("kir", 36);
    freq.put("Sve", 45);
    freq.put("\u0438\u0438\u0306 ", 35);
    freq.put("kij", 77);
    freq.put("kin", 233);
    freq.put("kil", 129);
    freq.put("i ", 20844);
    freq.put("kia", 33);
    freq.put("kie", 620);
    freq.put("Va", 795);
    freq.put("Ve", 528);
    freq.put("Vi", 1349);
    freq.put("Vl", 38);
    freq.put("Vo", 206);
    freq.put("Vu", 40);
    freq.put("nk ", 29);
    freq.put("op ", 56);
    freq.put("a\u0304je\u0304", 32);
    freq.put("zor", 28);
    freq.put("Ar ", 101);
    freq.put("a\u0304ja\u0304", 201);
    freq.put("opt", 86);
    freq.put("opu", 475);
    freq.put("opr", 71);
    freq.put("ops", 93);
    freq.put("ope", 301);
    freq.put("opa", 835);
    freq.put("opl", 68);
    freq.put("opm", 30);
    freq.put("opo", 347);
    freq.put("oph", 40);
    freq.put("opi", 253);
    freq.put("Art", 56);
    freq.put("vda", 91);
    freq.put("Ara", 25);
    freq.put("Ard", 29);
    freq.put("Are", 22);
    freq.put("Arg", 44);
    freq.put("Arh", 40);
    freq.put("Ari", 31);
    freq.put("Arm", 42);
    freq.put("www", 36);
    freq.put("kl\u0327o", 52);
    freq.put("re\u0304 ", 110);
    freq.put("zu ", 183);
    freq.put("bra", 298);
    freq.put("a\u0304l\u0327u", 173);
    freq.put("ww ", 36);
    freq.put("a\u0304l\u0327i", 45);
    freq.put("re\u0304l", 48);
    freq.put("zus", 63);
    freq.put("re\u0304n", 56);
    freq.put("re\u0304j", 380);
    freq.put("re\u0304k", 33);
    freq.put("re\u0304d", 88);
    freq.put("re\u0304t", 449);
    freq.put("zul", 164);
    freq.put("zum", 137);
    freq.put("Ara\u0304", 51);
    freq.put("a\u0304j ", 38);
    freq.put("opi\u0304", 120);
    freq.put("ope\u0304", 176);
    freq.put("opa\u0304", 322);
    freq.put("Tuv", 48);
    freq.put("a\u0304jp", 22);
    freq.put("a\u0304js", 680);
    freq.put("a\u0304ju", 1139);
    freq.put("a\u0304ji", 502);
    freq.put("ops\u030c", 220);
    freq.put("a\u0304jo", 89);
    freq.put("a\u0304ja", 844);
    freq.put("Z", 1747);
    freq.put("a\u0304je", 33);
    freq.put("zua\u0304", 39);
    freq.put("fs ", 175);
    freq.put("za\u0304 ", 57);
    freq.put("l\u0327ri", 165);
    freq.put("\u0441\u043a", 94);
    freq.put("\u0441\u0442", 46);
    freq.put(" Qu", 23);
    freq.put("za\u0304n", 65);
    freq.put("za\u0304l", 65);
    freq.put("za\u0304m", 26);
    freq.put("za\u0304k", 210);
    freq.put("Win", 29);
    freq.put("Wil", 32);
    freq.put("re\u0304s\u030c", 122);
    freq.put("za\u0304s", 75);
    freq.put("ule\u0304", 350);
    freq.put("ula\u0304", 424);
    freq.put("i\u0304tu", 205);
    freq.put("di ", 661);
    freq.put("i\u0304tr", 41);
    freq.put("i\u0304ts", 565);
    freq.put("uli\u0304", 38);
    freq.put("i\u0304tn", 23);
    freq.put("i\u0304to", 115);
    freq.put("i\u0304ti", 392);
    freq.put("i\u0304te", 151);
    freq.put("i\u0304ta", 808);
    freq.put("tnu", 123);
    freq.put("dil", 24);
    freq.put("dim", 118);
    freq.put("din", 621);
    freq.put("dio", 398);
    freq.put("tns", 112);
    freq.put("dij", 481);
    freq.put("dik", 129);
    freq.put("U\u0304de", 29);
    freq.put("die", 2511);
    freq.put("dif", 53);
    freq.put("dig", 41);
    freq.put("dia", 195);
    freq.put("dib", 246);
    freq.put("dic", 163);
    freq.put("dit", 40);
    freq.put("diu", 34);
    freq.put("div", 810);
    freq.put("i\u0304t ", 399);
    freq.put("dir", 59);
    freq.put("dis", 577);
    freq.put("zna\u0304", 215);
    freq.put("Gru", 54);
    freq.put("ez\u030cu", 144);
    freq.put(" Yo", 26);
    freq.put("sni\u0304", 38);
    freq.put("zne\u0304", 22);
    freq.put("ez\u030ca", 263);
    freq.put("mag\u0327", 28);
    freq.put("Gre", 140);
    freq.put("Gra", 91);
    freq.put("Gro", 39);
    freq.put("Gri", 112);
    freq.put("tne", 504);
    freq.put("zni\u0304", 263);
    freq.put("\u03b2", 23);
    freq.put("sne\u0304", 32);
    freq.put("k\u0327i\u0304 ", 22);
    freq.put("bo ", 36);
    freq.put("tna", 35);
    freq.put("ae\u0304l", 30);
    freq.put("ju\u0304t", 39);
    freq.put("ju\u0304r", 881);
    freq.put("ju\u0304l", 25);
    freq.put("ju\u0304d", 35);
    freq.put("tno", 42);
    freq.put("bor", 108);
    freq.put("bos", 35);
    freq.put("bot", 84);
    freq.put("bov", 23);
    freq.put("boj", 283);
    freq.put("bok", 22);
    freq.put("bol", 1514);
    freq.put("bon", 217);
    freq.put("man\u0327", 208);
    freq.put("dia\u0304", 75);
    freq.put("AU ", 30);
    freq.put("aye", 23);
    freq.put(" ku\u0304", 39);
    freq.put("ul ", 24);
    freq.put("Ben", 73);
    freq.put("Bel", 45);
    freq.put("din\u0327", 89);
    freq.put("i\u0304te\u0304", 23);
    freq.put("Bez", 37);
    freq.put("oot", 22);
    freq.put("oor", 77);
    freq.put("Ber", 134);
    freq.put("i\u0304ta\u0304", 552);
    freq.put("uls", 122);
    freq.put("ulp", 39);
    freq.put("S\u030cis", 89);
    freq.put("ulv", 63);
    freq.put("ay ", 49);
    freq.put("ult", 666);
    freq.put("ulu", 136);
    freq.put("fli", 29);
    freq.put("ulk", 243);
    freq.put("diz\u030c", 52);
    freq.put("uli", 203);
    freq.put("ulo", 29);
    freq.put("flo", 42);
    freq.put("i\u0304ti\u0304", 76);
    freq.put("fla", 25);
    freq.put("ulc", 29);
    freq.put("nz\u030ce", 53);
    freq.put("ula", 397);
    freq.put("fle", 24);
    freq.put("S\u030cie", 27);
    freq.put("uld", 110);
    freq.put("ule", 823);
    freq.put("Te\u0304", 78);
    freq.put("ma ", 2997);
    freq.put("bol\u0327", 39);
    freq.put("z\u030cka\u0304", 37);
    freq.put(" ob", 243);
    freq.put("sng", 29);
    freq.put("mas", 1459);
    freq.put("sne", 180);
    freq.put("mat", 1537);
    freq.put("sna", 41);
    freq.put("sno", 53);
    freq.put("maz", 508);
    freq.put("sni", 516);
    freq.put("mac", 23);
    freq.put("gli\u0304", 122);
    freq.put("sns", 27);
    freq.put("mag", 255);
    freq.put("Urs", 73);
    freq.put("mai", 882);
    freq.put("end", 388);
    freq.put("mak", 194);
    freq.put("ez\u030ci\u0304", 26);
    freq.put("mam", 184);
    freq.put("Gri\u0304", 41);
    freq.put("ug\u0327i", 59);
    freq.put("man", 1880);
    freq.put("zna", 38);
    freq.put("zne", 198);
    freq.put("zni", 156);
    freq.put("eng", 203);
    freq.put("zno", 68);
    freq.put("q", 293);
    freq.put("ez\u030ca\u0304", 198);
    freq.put("Edv", 25);
    freq.put("Edu", 28);
    freq.put("ny ", 39);
    freq.put("Ta\u0304", 889);
    freq.put(" S\u030ca\u0304", 65);
    freq.put("lse", 64);
    freq.put("tl\u0327u", 59);
    freq.put("lsa", 85);
    freq.put("lsn", 30);
    freq.put("lso", 131);
    freq.put("lsm", 135);
    freq.put("lsk", 140);
    freq.put("lsi", 33);
    freq.put("lst", 1735);
    freq.put("lsu", 49);
    freq.put("lss", 53);
    freq.put("lsp", 34);
    freq.put(" ab", 209);
    freq.put(" ac", 105);
    freq.put(" ad", 392);
    freq.put(" af", 23);
    freq.put(" ag", 155);
    freq.put(" S\u030ci\u0304", 134);
    freq.put(" ai", 846);
    freq.put(" ak", 503);
    freq.put(" al", 593);
    freq.put(" am", 414);
    freq.put(" an", 722);
    freq.put(" ap", 4517);
    freq.put(" ar", 6236);
    freq.put(" as", 496);
    freq.put(" at", 4655);
    freq.put(" au", 2262);
    freq.put(" av", 171);
    freq.put("ls ", 2358);
    freq.put(" a ", 72);
    freq.put("s\u030cz\u030ca", 24);
    freq.put(" s\u030ci\u0304", 215);
    freq.put("Lut", 24);
    freq.put("Lud", 28);
    freq.put("Lug", 27);
    freq.put("Luk", 24);
    freq.put("or ", 99);
    freq.put("Ken", 34);
    freq.put("Kem", 29);
    freq.put("Kei", 25);
    freq.put("Dz\u030c", 311);
    freq.put("Ker", 28);
    freq.put("orz", 33);
    freq.put("G", 1835);
    freq.put("ory", 23);
    freq.put("orv", 185);
    freq.put("ort", 723);
    freq.put(" s\u030ck\u0327", 525);
    freq.put("orr", 39);
    freq.put("ors", 691);
    freq.put("orp", 128);
    freq.put("Da\u0304", 72);
    freq.put("orn", 222);
    freq.put("oro", 248);
    freq.put("orl", 52);
    freq.put("orm", 1086);
    freq.put("ork", 107);
    freq.put("orh", 26);
    freq.put("ori", 1689);
    freq.put("orf", 64);
    freq.put("org", 872);
    freq.put("ord", 492);
    freq.put("ore", 247);
    freq.put("orb", 148);
    freq.put("De\u0304", 23);
    freq.put("ora", 653);
    freq.put("cem", 35);
    freq.put("Apv", 89);
    freq.put("vju", 71);
    freq.put("vji", 56);
    freq.put("Apo", 23);
    freq.put("n\u0327s ", 24);
    freq.put("e\u0304me\u0304", 83);
    freq.put("ua ", 31);
    freq.put("un\u0327i", 48);
    freq.put("un\u0327o", 84);
    freq.put("s\u030ci", 1623);
    freq.put("zs ", 189);
    freq.put("Otr", 101);
    freq.put("un\u0327u", 131);
    freq.put("lsi\u0304", 24);
    freq.put("kul\u0327", 50);
    freq.put("s\u030cn", 89);
    freq.put("zst", 360);
    freq.put(" S\u030ca", 199);
    freq.put(" ag\u0327", 61);
    freq.put("zsp", 47);
    freq.put(" S\u030ce", 104);
    freq.put(" S\u030ci", 163);
    freq.put(" S\u030co", 131);
    freq.put("s\u030cr", 148);
    freq.put(" S\u030cv", 81);
    freq.put(" S\u030ct", 29);
    freq.put("zsl", 25);
    freq.put("s\u030ct", 354);
    freq.put("i\u0304vp", 28);
    freq.put("ork\u0327", 25);
    freq.put("ori\u0304", 50);
    freq.put("Do", 208);
    freq.put("Di", 679);
    freq.put("De", 400);
    freq.put("ore\u0304", 91);
    freq.put("Da", 634);
    freq.put("2", 54);
    freq.put("Dz", 229);
    freq.put("Du", 106);
    freq.put("Dr", 103);
    freq.put("ora\u0304", 211);
    freq.put("D ", 170);
    freq.put("orn\u0327", 38);
    freq.put("ge ", 89);
    freq.put("az\u030ca\u0304", 482);
    freq.put("me\u0304g\u0327", 49);
    freq.put("We", 47);
    freq.put("Wa", 68);
    freq.put("Wo", 58);
    freq.put("Wi", 99);
    freq.put("\u0430", 390);
    freq.put("ges", 34);
    freq.put("ger", 118);
    freq.put("tl\u0327a", 51);
    freq.put("S\u030ca", 199);
    freq.put("S\u030ce", 104);
    freq.put("zen", 285);
    freq.put("tl\u0327i", 52);
    freq.put("S\u030ci", 163);
    freq.put("tl\u0327o", 22);
    freq.put("S\u030co", 132);
    freq.put("S\u030cv", 81);
    freq.put("S\u030ct", 29);
    freq.put("gej", 38);
    freq.put("zem", 1268);
    freq.put("gen", 244);
    freq.put("me\u0304s\u030c", 100);
    freq.put("gel", 54);
    freq.put("W ", 36);
    freq.put("o\u0301", 42);
    freq.put("uth", 28);
    freq.put("s\u030ca", 5315);
    freq.put("i\u0304ve", 148);
    freq.put("s\u030ce", 180);
    freq.put("s\u030cd", 202);
    freq.put("s\u030cg", 29);
    freq.put("i\u0304va", 467);
    freq.put("i\u0304vn", 200);
    freq.put("i\u0304vo", 1046);
    freq.put("s\u030ck", 157);
    freq.put("i\u0304vm", 36);
    freq.put("s\u030cm", 110);
    freq.put("s\u030cl", 112);
    freq.put("s\u030co", 571);
    freq.put("i\u0304vi", 298);
    freq.put("s\u030cp", 217);
    freq.put("s\u030cs", 357);
    freq.put("i\u0304vu", 146);
    freq.put("s\u030cu", 2014);
    freq.put("i\u0304vs", 154);
    freq.put("pan\u0327", 40);
    freq.put("s\u030cv", 170);
    freq.put("tu ", 4075);
    freq.put("s\u030cz", 36);
    freq.put("j ", 431);
    freq.put("uja\u0304", 42);
    freq.put(" E\u0304r", 64);
    freq.put("e\u0304gu", 33);
    freq.put("e\u0304gt", 73);
    freq.put("k\u0327a ", 175);
    freq.put("pas\u030c", 762);
    freq.put("tur", 1909);
    freq.put("ima", 242);
    freq.put("jt", 24);
    freq.put("ju", 6450);
    freq.put("jv", 54);
    freq.put("tus", 646);
    freq.put("jp", 49);
    freq.put("jr", 40);
    freq.put("js", 1745);
    freq.put("jl", 29);
    freq.put("paa\u0304", 29);
    freq.put("jn", 108);
    freq.put("jo", 2718);
    freq.put("tul", 280);
    freq.put("ji", 2430);
    freq.put("tun", 72);
    freq.put("jk", 33);
    freq.put("jd", 65);
    freq.put("je", 2277);
    freq.put("tub", 43);
    freq.put("tuc", 22);
    freq.put("tud", 188);
    freq.put("ja", 18785);
    freq.put("tug", 34);
    freq.put("pal\u0327", 30);
    freq.put(" Z\u030ce", 35);
    freq.put("tuk", 47);
    freq.put(" Z\u030ca", 46);
    freq.put("a\u0304vu", 149);
    freq.put("dko", 25);
    freq.put(" Z\u030ci", 23);
    freq.put("tum", 1336);
    freq.put("S\u030ci\u0304", 134);
    freq.put("S\u030ck\u0327", 45);
    freq.put("a\u0304vs", 30);
    freq.put("me\u0304 ", 626);
    freq.put("S\u030ca\u0304", 65);
    freq.put("a\u0304vi", 182);
    freq.put("me\u0304t", 199);
    freq.put("me\u0304s", 84);
    freq.put("me\u0304r", 1231);
    freq.put("me\u0304n", 131);
    freq.put("me\u0304m", 78);
    freq.put("me\u0304l", 71);
    freq.put("me\u0304j", 294);
    freq.put("me\u0304d", 92);
    freq.put("az\u030cu", 75);
    freq.put("az\u030cr", 77);
    freq.put("az\u030ca", 89);
    freq.put("az\u030co", 204);
    freq.put("az\u030ci", 139);
    freq.put("az\u030ck", 37);
    freq.put("s\u030cu\u0304", 152);
    freq.put("Ti", 330);
    freq.put("ze ", 308);
    freq.put("a\u0304da\u0304", 677);
    freq.put("ji\u0304", 54);
    freq.put("s\u030cz\u030c", 26);
    freq.put("pap", 138);
    freq.put("par", 3884);
    freq.put("pas", 2092);
    freq.put("pat", 548);
    freq.put("pau", 149);
    freq.put("pav", 354);
    freq.put("s\u030cn\u0327", 106);
    freq.put("paz", 430);
    freq.put("je\u0304", 253);
    freq.put("paa", 70);
    freq.put("pab", 25);
    freq.put("pac", 124);
    freq.put("pad", 181);
    freq.put("pag", 415);
    freq.put("pai", 59);
    freq.put("pak", 786);
    freq.put("pal", 445);
    freq.put("ja\u0304", 6443);
    freq.put("pan", 195);
    freq.put("oin", 31);
    freq.put("s\u030cg\u0327", 28);
    freq.put("nac", 383);
    freq.put("pja", 69);
    freq.put("s\u030ci\u0304", 572);
    freq.put("i\u0304vi\u0304", 139);
    freq.put("s\u030ck\u0327", 1261);
    freq.put("ju\u0304", 1021);
    freq.put("tus\u030c", 25);
    freq.put("ois", 41);
    freq.put("js\u030c", 27);
    freq.put("s\u030ca\u0304", 893);
    freq.put("i\u0304va\u0304", 296);
    freq.put("pa ", 730);
    freq.put("s\u030ce\u0304", 273);
    freq.put("ujo", 73);
    freq.put("i\u0304ve\u0304", 41);
    freq.put(" E\u0304g\u0327", 41);
    freq.put("uja", 223);
    freq.put("nai", 923);
    freq.put("nan", 170);
    freq.put("mo ", 301);
    freq.put("G\u0327en", 28);
    freq.put("G\u0327eo", 39);
    freq.put("G\u0327er", 28);
    freq.put("\u03c9", 27);
    freq.put("mor", 220);
    freq.put("mop", 26);
    freq.put("mot", 190);
    freq.put("mok", 98);
    freq.put("moj", 43);
    freq.put("mon", 399);
    freq.put("mom", 24);
    freq.put("mol", 217);
    freq.put("moc", 27);
    freq.put("mob", 84);
    freq.put("mog", 37);
    freq.put("mod", 286);
    freq.put("il\u0327u", 60);
    freq.put("zla", 642);
    freq.put("zli", 78);
    freq.put("km2", 49);
    freq.put("il\u0327a", 27);
    freq.put("\u0442\u043e", 24);
    freq.put("il\u0327i", 22);
    freq.put("Neo", 28);
    freq.put("Nei", 26);
    freq.put("Nea", 33);
    freq.put("New", 31);
    freq.put("Net", 40);
    freq.put("Ner", 49);
    freq.put("Nep", 30);
    freq.put("Med", 58);
    freq.put("kme", 260);
    freq.put(" ci", 2295);
    freq.put(" co", 68);
    freq.put(" cm", 50);
    freq.put("Mel", 144);
    freq.put("Men", 40);
    freq.put("Mei", 30);
    freq.put("Mek", 48);
    freq.put(" ce", 962);
    freq.put("Met", 75);
    freq.put("z\u030ca ", 310);
    freq.put("Mer", 74);
    freq.put("Mez", 22);
    freq.put("\u0447", 56);
    freq.put(" k\u0327e\u0304", 68);
    freq.put("Dra", 31);
    freq.put("z\u030cas", 293);
    freq.put("km ", 504);
    freq.put(" c ", 63);
    freq.put(" k\u0327i\u0304", 292);
    freq.put("z\u030cag", 66);
    freq.put("z\u030cai", 25);
    freq.put("z\u030can", 122);
    freq.put("z\u030cam", 29);
    freq.put("zla\u0304", 29);
    freq.put("il\u0327a\u0304", 27);
    freq.put("na ", 4384);
    freq.put("il\u0327n\u0327", 141);
    freq.put("e", 131519);
    freq.put("mos\u030c", 35);
    freq.put("Ag", 51);
    freq.put("Af", 50);
    freq.put("Ai", 200);
    freq.put("Avo", 25);
    freq.put("Am", 328);
    freq.put("es\u030ci", 317);
    freq.put("sva", 373);
    freq.put("\u041d", 52);
    freq.put("ci\u0304n\u0327", 106);
    freq.put(" cu\u0304", 37);
    freq.put(" k\u0327e", 273);
    freq.put("kmu\u0304", 49);
    freq.put("e\u0304ze", 148);
    freq.put("Au", 759);
    freq.put("Ovi", 22);
    freq.put("e\u0304zu", 41);
    freq.put("kme\u0304", 88);
    freq.put(" ce\u0304", 148);
    freq.put(" ci\u0304", 105);
    freq.put("kmi\u0304", 26);
    freq.put("u", 101354);
    freq.put("Vai", 65);
    freq.put("Van", 50);
    freq.put("Val", 406);
    freq.put("Var", 89);
    freq.put("Vas", 82);
    freq.put("a\u0304nd", 34);
    freq.put("ws ", 30);
    freq.put("del\u0327", 51);
    freq.put("a\u0304na", 615);
    freq.put("pl\u0327a", 22);
    freq.put("a\u0304no", 72);
    freq.put("a\u0304ni", 891);
    freq.put("a\u0304nu", 327);
    freq.put("\u041d ", 147);
    freq.put("a\u0304ns", 365);
    freq.put("\u0438", 382);
    freq.put("se\u0304 ", 157);
    freq.put("ium", 46);
    freq.put("got", 83);
    freq.put("ius", 102);
    freq.put("iur", 38);
    freq.put("den\u0327", 285);
    freq.put("as\u030ca", 197);
    freq.put("as\u030cl", 70);
    freq.put("as\u030cn", 47);
    freq.put("as\u030ci", 302);
    freq.put("e\u0304ln", 72);
    freq.put("se\u0304s", 30);
    freq.put("se\u0304r", 135);
    freq.put("as\u030cu", 167);
    freq.put("gl\u0327i", 38);
    freq.put("SI ", 51);
    freq.put("as\u030cs", 53);
    freq.put("as\u030cr", 63);
    freq.put(" Ra\u0304", 30);
    freq.put("Zvi", 157);
    freq.put("Zva", 55);
    freq.put("aba", 1096);
    freq.put("abe", 95);
    freq.put("abi", 630);
    freq.put("abl", 44);
    freq.put("abo", 176);
    freq.put("abp", 131);
    freq.put("\u0430 ", 100);
    freq.put("abs", 116);
    freq.put("abu", 136);
    freq.put("abv", 34);
    freq.put("K", 4616);
    freq.put("lki", 33);
    freq.put("as\u030ca\u0304", 181);
    freq.put("Vas\u030c", 22);
    freq.put("two", 22);
    freq.put("as\u030ci\u0304", 283);
    freq.put("de ", 574);
    freq.put("ul\u0327i", 36);
    freq.put("ul\u0327o", 37);
    freq.put("ul\u0327a", 32);
    freq.put("ul\u0327v", 73);
    freq.put("ul\u0327u", 71);
    freq.put("ey ", 55);
    freq.put("dep", 138);
    freq.put("der", 1382);
    freq.put("des", 875);
    freq.put("det", 70);
    freq.put("dev", 375);
    freq.put("deh", 29);
    freq.put("dei", 89);
    freq.put("dej", 161);
    freq.put("dek", 100);
    freq.put("del", 244);
    freq.put("dem", 139);
    freq.put("den", 1101);
    freq.put("deo", 95);
    freq.put("dea", 22);
    freq.put("deb", 147);
    freq.put("dec", 38);
    freq.put("ded", 49);
    freq.put("def", 128);
    freq.put("deg", 170);
    freq.put(" be\u0304", 90);
    freq.put("L\u0327e", 28);
    freq.put("lba\u0304", 28);
    freq.put("usa\u0304", 96);
    freq.put("aba\u0304", 487);
    freq.put("Don", 29);
    freq.put("Dom", 61);
    freq.put("Dob", 31);
    freq.put("bku", 154);
    freq.put("abe\u0304", 108);
    freq.put("ge\u0304n", 73);
    freq.put("P", 4759);
    freq.put("abi\u0304", 81);
    freq.put("cs ", 85);
    freq.put("ry ", 107);
    freq.put("Ma\u0304r", 46);
    freq.put("kon\u0327", 106);
    freq.put("ok ", 31);
    freq.put("Ma\u0304k", 28);
    freq.put("kos\u030c", 92);
    freq.put("pci", 27);
    freq.put("oks", 506);
    freq.put("Bau", 40);
    freq.put("Bar", 119);
    freq.put("Bas", 49);
    freq.put("uha", 22);
    freq.put("Baz", 45);
    freq.put("oka", 339);
    freq.put("je\u0304 ", 37);
    freq.put("Bab", 25);
    freq.put("tua\u0304", 134);
    freq.put("Ban", 57);
    freq.put("okh", 49);
    freq.put("Bal", 501);
    freq.put("okm", 47);
    freq.put("Bak", 26);
    freq.put("oko", 208);
    freq.put("uj ", 134);
    freq.put("pam", 682);
    freq.put(" el\u0327", 37);
    freq.put("pa\u0304n\u0327", 98);
    freq.put("pc ", 24);
    freq.put("ka\u0304", 9200);
    freq.put("ke\u0304", 55);
    freq.put("mm ", 35);
    freq.put("ki\u0304", 37);
    freq.put("E ", 106);
    freq.put("kl\u0327", 994);
    freq.put("toz", 23);
    freq.put("kn\u0327", 114);
    freq.put("Ats\u030c", 29);
    freq.put("mmu", 74);
    freq.put("\u044f", 84);
    freq.put("Ung", 47);
    freq.put("mme", 33);
    freq.put("Uni", 125);
    freq.put("sbi", 144);
    freq.put("mma", 291);
    freq.put("Em", 90);
    freq.put("El", 193);
    freq.put("ks\u030c", 1455);
    freq.put("En", 123);
    freq.put("Ei", 677);
    freq.put("Ek", 93);
    freq.put("ku\u0304", 96);
    freq.put("Ed", 95);
    freq.put("Eg", 26);
    freq.put("Eb", 22);
    freq.put("Ex", 29);
    freq.put("Ez", 43);
    freq.put("Eu", 85);
    freq.put("Et", 48);
    freq.put("Ev", 42);
    freq.put("Eq", 185);
    freq.put("Es", 44);
    freq.put("Er", 98);
    freq.put("okl\u0327", 89);
    freq.put("pa\u0304 ", 453);
    freq.put(" el", 849);
    freq.put("koh", 29);
    freq.put(" en", 251);
    freq.put("koj", 143);
    freq.put("kom", 1199);
    freq.put(" ei", 45);
    freq.put("koo", 61);
    freq.put(" ek", 494);
    freq.put(" ef", 77);
    freq.put("koe", 27);
    freq.put("kod", 306);
    freq.put(" eb", 89);
    freq.put("s\u030cl\u0327", 41);
    freq.put("oka\u0304", 278);
    freq.put("koz", 38);
    freq.put(" ez", 655);
    freq.put(" et", 118);
    freq.put("kop", 1110);
    freq.put("kos", 513);
    freq.put("kor", 259);
    freq.put(" ep", 55);
    freq.put("kot", 513);
    freq.put(" er", 23);
    freq.put(" es", 227);
    freq.put("pa\u0304r", 1984);
    freq.put("pa\u0304s", 27);
    freq.put("u\u0304ku", 78);
    freq.put("u\u0304ks", 153);
    freq.put("u\u0304ko", 44);
    freq.put("Slo", 56);
    freq.put("pa\u0304j", 65);
    freq.put("u\u0304ka", 36);
    freq.put("pa\u0304m", 68);
    freq.put("pa\u0304n", 369);
    freq.put("b", 30435);
    freq.put("ko ", 1627);
    freq.put(" e ", 62);
    freq.put("Ve\u0304r", 24);
    freq.put("Ve\u0304s", 43);
    freq.put("\u2212 ", 42);
    freq.put("k ", 3032);
    freq.put("Kir", 46);
    freq.put("mme\u0304", 68);
    freq.put("Kij", 27);
    freq.put("Kin", 77);
    freq.put("mma\u0304", 27);
    freq.put("\u0434 ", 27);
    freq.put("uji", 27);
    freq.put("vna", 31);
    freq.put("Ata", 28);
    freq.put("Ato", 22);
    freq.put("Atl", 83);
    freq.put("Atk", 35);
    freq.put("vni", 238);
    freq.put("Atr", 91);
    freq.put("kc", 519);
    freq.put("kb", 27);
    freq.put("ka", 21595);
    freq.put("kg", 105);
    freq.put("ke", 1430);
    freq.put("kd", 52);
    freq.put("kk", 49);
    freq.put("ki", 2861);
    freq.put("kh", 87);
    freq.put("ko", 8251);
    freq.put("kn", 291);
    freq.put("km", 1006);
    freq.put("kl", 2204);
    freq.put("ks", 6047);
    freq.put("kr", 3493);
    freq.put("kp", 53);
    freq.put("kv", 498);
    freq.put("ku", 9917);
    freq.put("kt", 4783);
    freq.put("ky", 24);
    freq.put("gal\u0327", 93);
    freq.put("pe", 2624);
    freq.put("a\u0304va\u0304", 189);
    freq.put("Ope", 52);
    freq.put("gaz\u030c", 22);
    freq.put(" Be", 444);
    freq.put(" Ba", 1003);
    freq.put(" Bl", 114);
    freq.put(" Bo", 338);
    freq.put(" Bi", 327);
    freq.put(" Bu", 238);
    freq.put("ik ", 182);
    freq.put(" Br", 524);
    freq.put("kts", 634);
    freq.put("\u0430\u0432", 30);
    freq.put("a\u0304lo", 317);
    freq.put("da\u0304f", 28);
    freq.put("le\u0304s\u030c", 123);
    freq.put("da\u0304l", 53);
    freq.put("da\u0304m", 160);
    freq.put("da\u0304n", 30);
    freq.put("a\u0304le", 181);
    freq.put("da\u0304j", 251);
    freq.put("\u0430\u043d", 46);
    freq.put("da\u0304t", 198);
    freq.put("tal\u0327", 38);
    freq.put("da\u0304v", 49);
    freq.put("da\u0304r", 218);
    freq.put("da\u0304s", 334);
    freq.put("\u03ba", 31);
    freq.put("a\u0304ls", 579);
    freq.put("iks", 380);
    freq.put("ikr", 195);
    freq.put(" B ", 49);
    freq.put("iku", 1045);
    freq.put("ikt", 677);
    freq.put("\u044b", 62);
    freq.put("\u0430\u0440", 38);
    freq.put("ikg", 62);
    freq.put("ike", 59);
    freq.put("ikd", 24);
    freq.put("iki", 144);
    freq.put("ozi", 143);
    freq.put("iko", 225);
    freq.put("\u0430\u044f", 29);
    freq.put("ikm", 90);
    freq.put("ikl", 215);
    freq.put("i\u0304ze\u0304", 29);
    freq.put("da\u0304 ", 1681);
    freq.put("i\u0304za\u0304", 35);
    freq.put("Ira\u0304", 62);
    freq.put("lbu", 171);
    freq.put("ga ", 1326);
    freq.put("s\u030cdz", 152);
    freq.put("\u4e09", 24);
    freq.put("s\u030cde", 24);
    freq.put("fu ", 37);
    freq.put("gav", 387);
    freq.put("gau", 305);
    freq.put("gat", 362);
    freq.put("gas", 1682);
    freq.put("gar", 786);
    freq.put("gan", 1451);
    freq.put("gam", 98);
    freq.put("gal", 1339);
    freq.put("gaj", 108);
    freq.put("gai", 779);
    freq.put("gad", 2505);
    freq.put("gab", 646);
    freq.put("lba", 32);
    freq.put("fut", 631);
    freq.put("fun", 189);
    freq.put("lbe", 128);
    freq.put("in\u0327k\u0327", 170);
    freq.put("i\u0304ze", 130);
    freq.put("i\u0304zi", 177);
    freq.put("\u0421", 193);
    freq.put("le\u0304g", 138);
    freq.put("le\u0304d", 76);
    freq.put("da\u0304s\u030c", 37);
    freq.put("le\u0304n", 178);
    freq.put("raz", 76);
    freq.put("le\u0304l", 48);
    freq.put("le\u0304m", 141);
    freq.put("le\u0304j", 178);
    freq.put("le\u0304k", 87);
    freq.put("mos", 1307);
    freq.put("ika\u0304", 1450);
    freq.put("le\u0304r", 42);
    freq.put("le\u0304s", 295);
    freq.put("le\u0304p", 64);
    freq.put("\u0440\u0435", 36);
    freq.put("cea", 28);
    freq.put(" Bi\u0304", 48);
    freq.put("a\u0304la\u0304", 1101);
    freq.put("iks\u030c", 84);
    freq.put("Ir ", 43);
    freq.put(" Ba\u0304", 54);
    freq.put("a\u0304li\u0304", 22);
    freq.put("le\u0304 ", 420);
    freq.put("ew ", 38);
    freq.put("\u0424", 23);
    freq.put("lga\u0304", 68);
    freq.put(" Be\u0304", 72);
    freq.put("y", 1297);
    freq.put("lda", 256);
    freq.put("lde", 303);
    freq.put("ldi", 101);
    freq.put("ldo", 68);
    freq.put("ldn", 139);
    freq.put("bi ", 165);
    freq.put("lds", 71);
    freq.put("ldr", 27);
    freq.put("ldv", 22);
    freq.put("ldu", 71);
    freq.put("rgs", 168);
    freq.put("cus", 46);
    freq.put("rgu", 304);
    freq.put("rga", 943);
    freq.put("rge", 111);
    freq.put("rgi", 83);
    freq.put("cum", 72);
    freq.put("cul", 28);
    freq.put("rgo", 78);
    freq.put("bin", 496);
    freq.put("bio", 155);
    freq.put("Din", 26);
    freq.put("nsi\u0304", 306);
    freq.put("bij", 2367);
    freq.put("bik", 26);
    freq.put("Die", 362);
    freq.put("Dig", 22);
    freq.put("bib", 56);
    freq.put("Dib", 24);
    freq.put("biz", 35);
    freq.put("bit", 116);
    freq.put("bir", 59);
    freq.put("bis", 145);
    freq.put("Dis", 48);
    freq.put("Ta", 1094);
    freq.put("i\u0304c\u030cu", 22);
    freq.put("rg ", 40);
    freq.put("\u2212", 111);
    freq.put("cu ", 436);
    freq.put("nse\u0304", 48);
    freq.put("S\u030co ", 72);
    freq.put("pet", 33);
    freq.put("Ju\u0304r", 108);
    freq.put("pes", 264);
    freq.put("pel", 224);
    freq.put("pen", 158);
    freq.put("pei", 23);
    freq.put("pek", 146);
    freq.put("ped", 72);
    freq.put("pea", 50);
    freq.put("pec", 223);
    freq.put("Bor", 50);
    freq.put("Bos", 71);
    freq.put("S\u030cob", 33);
    freq.put("use", 127);
    freq.put("Bov", 25);
    freq.put("oei", 29);
    freq.put("Bol", 40);
    freq.put("oen", 27);
    freq.put("Bon", 23);
    freq.put(" ga\u0304", 212);
    freq.put("oef", 31);
    freq.put("\u03c2 ", 97);
    freq.put("a\u0308", 65);
    freq.put("uso", 49);
    freq.put("pe ", 174);
    freq.put("usm", 71);
    freq.put("nsi", 192);
    freq.put("nsk", 554);
    freq.put("nsl", 44);
    freq.put("nso", 88);
    freq.put("ldu\u0304", 50);
    freq.put("nsa", 85);
    freq.put("nse", 131);
    freq.put("nsf", 27);
    freq.put("nsg", 24);
    freq.put("ci\u0304j", 23);
    freq.put("bil\u0327", 23);
    freq.put("aja\u0304", 2224);
    freq.put("nsp", 162);
    freq.put("nss", 27);
    freq.put("nst", 540);
    freq.put("nsu", 59);
    freq.put("nsv", 36);
    freq.put("mko", 36);
    freq.put("uss", 395);
    freq.put(" R ", 37);
    freq.put("ns ", 4213);
    freq.put("sdz", 22);
    freq.put("rga\u0304", 217);
    freq.put("sda", 48);
    freq.put("Flo", 40);
    freq.put("sdi", 356);
    freq.put("lda\u0304", 34);
    freq.put("bin\u0327", 28);
    freq.put("rgl\u0327", 35);
    freq.put("lde\u0304", 33);
    freq.put("tve", 395);
    freq.put("Mas", 145);
    freq.put("Mar", 393);
    freq.put(" gr", 1494);
    freq.put(" gs", 71);
    freq.put("u\u0304ma", 25);
    freq.put("Maz", 108);
    freq.put("Mac", 23);
    freq.put(" ge", 43);
    freq.put("Mad", 99);
    freq.put("Mag", 45);
    freq.put(" ga", 5014);
    freq.put("Mai", 65);
    freq.put(" go", 110);
    freq.put(" gl", 287);
    freq.put("uiz\u030c", 110);
    freq.put("Mam", 22);
    freq.put("Mal", 86);
    freq.put("Man", 129);
    freq.put(" ch", 25);
    freq.put(" k", 23420);
    freq.put("pel\u0327", 35);
    freq.put("z\u030cet", 61);
    freq.put("z\u030cer", 29);
    freq.put("z\u030ces", 28);
    freq.put("z\u030cen", 74);
    freq.put("z\u030cel", 23);
    freq.put(" g ", 36);
    freq.put("z\u030cei", 43);
    freq.put(" b", 8086);
    freq.put(" c", 4249);
    freq.put(" a", 22507);
    freq.put(" f", 3413);
    freq.put(" g", 7521);
    freq.put(" d", 13444);
    freq.put(" e", 3216);
    freq.put(" j", 3868);
    freq.put("Pe\u0304c", 116);
    freq.put(" h", 1222);
    freq.put(" i", 26578);
    freq.put(" n", 13651);
    freq.put(" o", 3224);
    freq.put(" l", 9777);
    freq.put(" m", 8646);
    freq.put(" r", 6772);
    freq.put(" Dz\u030c", 308);
    freq.put(" p", 25406);
    freq.put(" q", 33);
    freq.put(" v", 19041);
    freq.put(" w", 93);
    freq.put(" t", 13126);
    freq.put(" u", 13570);
    freq.put(" z", 3907);
    freq.put(" x", 65);
    freq.put(" y", 33);
    freq.put("Pe\u0304t", 62);
    freq.put(" B", 3324);
    freq.put(" C", 2058);
    freq.put(" A", 5469);
    freq.put(" F", 1822);
    freq.put(" G", 1815);
    freq.put(" D", 3031);
    freq.put(" E", 2156);
    freq.put(" J", 1795);
    freq.put(" K", 4607);
    freq.put(" H", 1796);
    freq.put(" I", 2309);
    freq.put(" N", 1813);
    freq.put(" O", 1473);
    freq.put(" L", 4536);
    freq.put(" M", 3956);
    freq.put(" R", 3325);
    freq.put(" S", 5368);
    freq.put(" P", 4729);
    freq.put(" Q", 37);
    freq.put(" V", 3691);
    freq.put(" W", 350);
    freq.put(" T", 4452);
    freq.put(" U", 847);
    freq.put(" Z", 1739);
    freq.put(" X", 228);
    freq.put(" Y", 64);
    freq.put("a\u0304re\u0304", 202);
    freq.put("a\u0304ra\u0304", 289);
    freq.put("n\u0327e\u0304m", 347);
    freq.put(" Da\u0304", 72);
    freq.put(" cu", 46);
    freq.put(" De\u0304", 23);
    freq.put("I\u0304r", 60);
    freq.put("I\u0304s", 48);
    freq.put("l\u0327 ", 195);
    freq.put(" L\u0327e", 28);
    freq.put("Org", 41);
    freq.put("l\u0327v", 154);
    freq.put("l\u0327u", 2107);
    freq.put("l\u0327r", 180);
    freq.put("l\u0327s", 48);
    freq.put("och", 26);
    freq.put("ock", 58);
    freq.put("l\u0327d", 32);
    freq.put("l\u0327e", 71);
    freq.put("l\u0327a", 2291);
    freq.put("l\u0327o", 646);
    freq.put("l\u0327l", 36);
    freq.put("l\u0327j", 32);
    freq.put("l\u0327k", 39);
    freq.put("l\u0327i", 696);
    freq.put("cu\u0304k", 37);
    freq.put("e\u0304la\u0304", 185);
    freq.put(" Do", 202);
    freq.put(" S\u030c", 1042);
    freq.put(" s\u030c", 2083);
    freq.put("Ver", 44);
    freq.put("Ves", 70);
    freq.put(" Di", 673);
    freq.put(" U\u0304", 37);
    freq.put(" u\u0304", 565);
    freq.put(" De", 398);
    freq.put(" Da", 629);
    freq.put("gu\u0304s\u030c", 56);
    freq.put("Vec", 107);
    freq.put("Ven", 119);
    freq.put(" Du", 106);
    freq.put(" z\u030c", 311);
    freq.put(" Dr", 102);
    freq.put("Vei", 37);
    freq.put("a\u0304rp", 114);
    freq.put("cha", 72);
    freq.put("Fr", 536);
    freq.put("a\u0304rs", 844);
    freq.put(" n\u0327", 41);
    freq.put("che", 97);
    freq.put("a\u0304rv", 488);
    freq.put(" N\u0327", 120);
    freq.put("chi", 53);
    freq.put("s\u030cg\u0327i", 28);
    freq.put("chn", 24);
    freq.put("cho", 24);
    freq.put("Fa", 110);
    freq.put("a\u0304rb", 33);
    freq.put("a\u0304rd", 904);
    freq.put("Fe", 227);
    freq.put("a\u0304rg", 36);
    freq.put("Fi", 194);
    freq.put("a\u0304rk", 89);
    freq.put("Fl", 70);
    freq.put("a\u0304rm", 72);
    freq.put("a\u0304rn", 280);
    freq.put("Fo", 212);
    freq.put(" G\u0327", 128);
    freq.put(" g\u0327", 1094);
    freq.put(" I\u0304", 131);
    freq.put(" i\u0304", 702);
    freq.put(" D ", 68);
    freq.put(" K\u0327", 254);
    freq.put(" k\u0327", 663);
    freq.put(" L\u0327", 56);
    freq.put(" l\u0327", 329);
    freq.put("ch ", 124);
    freq.put(" A\u0304", 409);
    freq.put(" a\u0304", 501);
    freq.put("N\u0327u\u0304", 40);
    freq.put("f", 8161);
    freq.put(" C\u030c", 299);
    freq.put(" c\u030c", 467);
    freq.put(" E\u0304", 143);
    freq.put(" e\u0304", 282);
    freq.put("l\u0327k\u0327", 37);
    freq.put(" A\u0304b", 22);
    freq.put("l\u0327l\u0327", 89);
    freq.put("l\u0327g\u0327", 54);
    freq.put("l\u0327i\u0304", 23);
    freq.put(" A\u0304f", 113);
    freq.put("l\u0327e\u0304", 91);
    freq.put("Yo", 26);
    freq.put(" A\u0304d", 23);
    freq.put("afa", 26);
    freq.put("l\u0327a\u0304", 656);
    freq.put("aft", 53);
    freq.put("afr", 25);
    freq.put("l\u0327s\u030c", 133);
    freq.put("l\u0327u\u0304", 169);
    freq.put("l\u0327n\u0327", 176);
    freq.put("ogl\u0327", 73);
    freq.put("da ", 3140);
    freq.put("E\u0304", 143);
    freq.put("n\u0327u ", 2105);
    freq.put("i\u0304du", 170);
    freq.put("lf", 344);
    freq.put("lg", 521);
    freq.put("ld", 1879);
    freq.put("ain\u0327", 241);
    freq.put("lb", 519);
    freq.put("lc", 198);
    freq.put("la", 14259);
    freq.put("ln", 1238);
    freq.put("lo", 5141);
    freq.put("\u0432\u043e", 24);
    freq.put("lm", 668);
    freq.put("\u0432\u0438", 41);
    freq.put("lk", 789);
    freq.put("lh", 104);
    freq.put("li", 12111);
    freq.put("lv", 2188);
    freq.put("lt", 2348);
    freq.put("lu", 3183);
    freq.put("lr", 53);
    freq.put("i\u0304dr", 32);
    freq.put("lp", 774);
    freq.put("tsv", 27);
    freq.put("eut", 31);
    freq.put("tst", 123);
    freq.put("tsu", 24);
    freq.put("lz", 417);
    freq.put("k\u0327o ", 45);
    freq.put("eus", 24);
    freq.put("ly", 68);
    freq.put("dae", 523);
    freq.put("dag", 58);
    freq.put("n\u0327us", 89);
    freq.put("dab", 346);
    freq.put("dac", 25);
    freq.put("dal", 823);
    freq.put("dam", 271);
    freq.put("dan", 60);
    freq.put("udz\u030c", 74);
    freq.put("dai", 150);
    freq.put("dak", 25);
    freq.put("dat", 711);
    freq.put("dau", 771);
    freq.put("dap", 69);
    freq.put("dar", 1471);
    freq.put("das", 2562);
    freq.put("l ", 908);
    freq.put("pga\u0304", 32);
    freq.put("ts ", 6404);
    freq.put("\u0435 ", 61);
    freq.put("lfa", 193);
    freq.put("S\u030ca\u0304d", 55);
    freq.put("min\u0327", 109);
    freq.put("Pas\u030c", 73);
    freq.put("lfr", 22);
    freq.put("rez", 384);
    freq.put("emu", 60);
    freq.put("rer", 29);
    freq.put("aga", 835);
    freq.put("Tur", 208);
    freq.put("u\u0304zu", 22);
    freq.put("rev", 103);
    freq.put("sfe\u0304", 192);
    freq.put("ret", 778);
    freq.put("reu", 25);
    freq.put("rej", 271);
    freq.put("rek", 208);
    freq.put("rei", 822);
    freq.put("Tul", 26);
    freq.put("reo", 23);
    freq.put("rel", 259);
    freq.put("rem", 185);
    freq.put("reb", 22);
    freq.put("rec", 144);
    freq.put("rea", 246);
    freq.put("ref", 132);
    freq.put("reg", 233);
    freq.put("red", 582);
    freq.put("ree", 37);
    freq.put("quu", 124);
    freq.put("qua", 27);
    freq.put("que", 29);
    freq.put("qui", 79);
    freq.put("vi\u0304z", 153);
    freq.put("l\u0327a\u0304 ", 507);
    freq.put("vi\u0304r", 237);
    freq.put("vi\u0304t", 70);
    freq.put("s\u030cu\u0304n", 142);
    freq.put("vi\u0304n", 52);
    freq.put("re ", 399);
    freq.put("Z\u030c", 134);
    freq.put("mik\u0327", 31);
    freq.put("vi\u0304g", 77);
    freq.put("pga", 664);
    freq.put("sa\u0304s", 67);
    freq.put("pgr", 35);
    freq.put("dal\u0327", 1548);
    freq.put("ea\u0304l", 99);
    freq.put("ea\u0304n", 337);
    freq.put("lu\u0304", 587);
    freq.put("he\u0304m", 45);
    freq.put("lz\u030c", 37);
    freq.put("ea\u0304t", 94);
    freq.put("udr", 142);
    freq.put("la\u0304", 5128);
    freq.put("ogu", 116);
    freq.put("ogs", 183);
    freq.put("ogr", 713);
    freq.put("ogl", 96);
    freq.put("ogo", 65);
    freq.put("ogn", 46);
    freq.put("ogi", 122);
    freq.put("le\u0304", 2235);
    freq.put("ude", 104);
    freq.put("daz\u030c", 632);
    freq.put("udi", 282);
    freq.put("oga", 163);
    freq.put("udo", 32);
    freq.put("li\u0304", 4107);
    freq.put("Pap", 26);
    freq.put("Par", 468);
    freq.put("Pas", 386);
    freq.put("Pat", 54);
    freq.put("Pau", 41);
    freq.put("Pav", 27);
    freq.put("Paz", 31);
    freq.put("Pad", 103);
    freq.put("Pak", 46);
    freq.put("Pal", 61);
    freq.put("Pan", 44);
    freq.put("mik", 313);
    freq.put("mij", 472);
    freq.put("rez\u030c", 135);
    freq.put("mil", 392);
    freq.put("mio", 29);
    freq.put("min", 1418);
    freq.put("\u0629", 22);
    freq.put("mic", 35);
    freq.put("mie", 997);
    freq.put("mid", 33);
    freq.put("mig", 64);
    freq.put("miz", 31);
    freq.put("mis", 1428);
    freq.put("res\u030c", 174);
    freq.put("mit", 475);
    freq.put("lfi\u0304", 26);
    freq.put("sfo", 68);
    freq.put(" \u03b1", 37);
    freq.put("rec\u030c", 45);
    freq.put("rea\u0304", 83);
    freq.put("sfa", 26);
    freq.put("mi ", 937);
    freq.put("reg\u0327", 361);
    freq.put("ksu", 120);
    freq.put("Moz", 28);
    freq.put(" iz", 4946);
    freq.put(" \u0441", 29);
    freq.put("ksp", 156);
    freq.put("ag\u0327e", 63);
    freq.put("co ", 36);
    freq.put("Mos", 23);
    freq.put("Mor", 85);
    freq.put(" ir", 14600);
    freq.put(" is", 92);
    freq.put(" it", 111);
    freq.put(" iv", 22);
    freq.put("Mot", 31);
    freq.put("kse", 83);
    freq.put(" ik", 136);
    freq.put(" il", 190);
    freq.put("Mon", 122);
    freq.put(" in", 1344);
    freq.put("Mol", 50);
    freq.put("ksm", 118);
    freq.put("ksl", 373);
    freq.put("kso", 59);
    freq.put("ksn", 205);
    freq.put(" id", 175);
    freq.put(" ie", 4455);
    freq.put("ksk", 31);
    freq.put(" ig", 94);
    freq.put(" \u0420", 34);
    freq.put(" \u0421", 176);
    freq.put(" \u0424", 23);
    freq.put("i\u0304ci\u0304", 70);
    freq.put("s\u030cn\u0327u", 59);
    freq.put(" \u043e", 23);
    freq.put("Na\u0304c", 29);
    freq.put("i\u0304ca\u0304", 40);
    freq.put(" \u0412", 29);
    freq.put("C\u030ceh", 54);
    freq.put(" \u0410", 25);
    freq.put(" \u0411", 28);
    freq.put("ks ", 1859);
    freq.put(" i ", 44);
    freq.put(" \u041b", 27);
    freq.put(" \u041e", 26);
    freq.put(" \u041c", 37);
    freq.put(" \u041d", 52);
    freq.put(" Iz", 255);
    freq.put("re\u0304m", 93);
    freq.put("ne\u0304j", 281);
    freq.put("ne\u0304m", 160);
    freq.put("ne\u0304z", 87);
    freq.put("ne\u0304s", 72);
    freq.put("ne\u0304t", 549);
    freq.put("a\u0304pe\u0304", 74);
    freq.put("S", 5447);
    freq.put(" Iv", 35);
    freq.put("vri", 37);
    freq.put("ne\u0304 ", 308);
    freq.put(" Il", 59);
    freq.put("i\u0304ce", 148);
    freq.put("uz\u030ca", 37);
    freq.put("i\u0304ca", 276);
    freq.put("i\u0304ci", 383);
    freq.put("ohn", 25);
    freq.put("oho", 29);
    freq.put("uz\u030cu", 32);
    freq.put(" im", 336);
    freq.put("uid", 83);
    freq.put("ol\u0327u", 172);
    freq.put("iba", 66);
    freq.put("E\u0304rg", 30);
    freq.put("ai", 16755);
    freq.put("e\u0304po", 30);
    freq.put("ak", 5105);
    freq.put("Hom", 27);
    freq.put("kse\u0304", 49);
    freq.put("cop", 28);
    freq.put("al", 13877);
    freq.put("ag\u0327e\u0304", 26);
    freq.put("cor", 52);
    freq.put("ksa\u0304", 78);
    freq.put("cot", 97);
    freq.put("uis", 38);
    freq.put("ar", 22107);
    freq.put("au", 11606);
    freq.put("ksi\u0304", 103);
    freq.put("yst", 46);
    freq.put(" Fr", 535);
    freq.put(" Fu", 230);
    freq.put("nin\u0327", 82);
    freq.put(" Fa", 110);
    freq.put(" Fe", 226);
    freq.put(" Fi", 190);
    freq.put(" Fl", 70);
    freq.put(" Fo", 211);
    freq.put("io ", 204);
    freq.put("ne\u0304s\u030c", 36);
    freq.put("a\u0304pu", 44);
    freq.put("a\u0304pi", 34);
    freq.put("a\u0304pa", 64);
    freq.put("a\u0304pe", 142);
    freq.put("SO ", 60);
    freq.put("cog", 76);
    freq.put("iov", 23);
    freq.put("iot", 138);
    freq.put("ios", 84);
    freq.put("ior", 31);
    freq.put("iop", 23);
    freq.put(" F ", 24);
    freq.put("iom", 40);
    freq.put("e\u0304zi", 135);
    freq.put("iok", 51);
    freq.put("iog", 37);
    freq.put("iod", 270);
    freq.put("ioa", 45);
    freq.put("com", 55);
    freq.put("ji\u0304g", 32);
    freq.put("bul\u0327", 79);
    freq.put("an\u0327g\u0327", 36);
    freq.put("l\u0327da", 25);
    freq.put(" k\u0327i", 28);
    freq.put("\u0435\u0441", 31);
    freq.put("\u0435\u0440", 46);
    freq.put("adu", 517);
    freq.put("adr", 151);
    freq.put("ads", 379);
    freq.put("be\u0304t", 95);
    freq.put("gma", 49);
    freq.put("adz", 161);
    freq.put("an\u0327a\u0304", 78);
    freq.put("be\u0304r", 112);
    freq.put("be\u0304m", 82);
    freq.put("ade", 142);
    freq.put("be\u0304j", 25);
    freq.put("ada", 1586);
    freq.put("adn", 49);
    freq.put("ado", 609);
    freq.put("adl", 29);
    freq.put("adm", 304);
    freq.put("\u043c", 85);
    freq.put("an\u0327e\u0304", 59);
    freq.put(" \u0627", 37);
    freq.put("el\u0327r", 165);
    freq.put("el\u0327v", 32);
    freq.put("el\u0327u", 421);
    freq.put("el\u0327i", 128);
    freq.put("el\u0327o", 286);
    freq.put("el\u0327a", 635);
    freq.put("el\u0327d", 25);
    freq.put("el\u0327e", 30);
    freq.put("\u0435\u043d", 52);
    freq.put("Mez\u030c", 62);
    freq.put("U\u0304", 37);
    freq.put("ad ", 480);
    freq.put("nja", 39);
    freq.put("k\u0327i ", 217);
    freq.put("njo", 28);
    freq.put("us\u030ci", 230);
    freq.put("us\u030co", 68);
    freq.put("us\u030ca", 268);
    freq.put("esv", 35);
    freq.put("esu", 212);
    freq.put("est", 937);
    freq.put("ess", 340);
    freq.put("esr", 33);
    freq.put("esp", 338);
    freq.put("pin\u0327", 42);
    freq.put("tma", 80);
    freq.put("ese", 289);
    freq.put("esc", 24);
    freq.put("uba\u0304", 54);
    freq.put("esa", 337);
    freq.put("eso", 286);
    freq.put("esn", 43);
    freq.put("esm", 388);
    freq.put("esl", 110);
    freq.put("esk", 278);
    freq.put("esi", 374);
    freq.put("tmo", 123);
    freq.put("k\u0327ie", 106);
    freq.put("k\u0327id", 184);
    freq.put("k\u0327in", 48);
    freq.put("k\u0327im", 24);
    freq.put("k\u0327ij", 62);
    freq.put("k\u0327is", 433);
    freq.put("k\u0327ir", 550);
    freq.put(" N\u0327u", 39);
    freq.put("es ", 8988);
    freq.put("el\u0327l\u0327", 42);
    freq.put("\u0412", 29);
    freq.put("el\u0327g\u0327", 25);
    freq.put("bu ", 1529);
    freq.put("rct", 35);
    freq.put("rco", 80);
    freq.put("rch", 63);
    freq.put("rci", 226);
    freq.put("rce", 59);
    freq.put("el\u0327a\u0304", 42);
    freq.put("rca", 34);
    freq.put("an\u0327o", 46);
    freq.put(" Dz", 227);
    freq.put("an\u0327i", 61);
    freq.put("an\u0327d", 30);
    freq.put("an\u0327e", 35);
    freq.put("Der", 41);
    freq.put("Des", 26);
    freq.put("an\u0327a", 180);
    freq.put("but", 64);
    freq.put("Dei", 40);
    freq.put("bun", 25);
    freq.put("Dem", 45);
    freq.put("bul", 250);
    freq.put("ada\u0304", 819);
    freq.put("an\u0327u", 241);
    freq.put("el\u0327s\u030c", 95);
    freq.put("bud", 74);
    freq.put("Deg", 23);
    freq.put("Iva", 31);
    freq.put("j", 43124);
    freq.put("ai ", 5352);
    freq.put("el\u0327n\u0327", 24);
    freq.put("adi\u0304", 860);
    freq.put("js\u030c ", 26);
    freq.put("pij", 105);
    freq.put("pil", 2275);
    freq.put("pin", 133);
    freq.put("pio", 305);
    freq.put("pie", 4300);
    freq.put("pig", 22);
    freq.put("pir", 966);
    freq.put("pis", 387);
    freq.put("pit", 151);
    freq.put("oal", 24);
    freq.put("oak", 87);
    freq.put("ubu", 76);
    freq.put("tme\u0304", 32);
    freq.put("ese\u0304", 107);
    freq.put(" N\u0327u\u0304", 40);
    freq.put("pi ", 142);
    freq.put("ube", 111);
    freq.put("uba", 77);
    freq.put("esa\u0304", 195);
    freq.put("Act", 23);
    freq.put("ubl", 522);
    freq.put("ubi", 59);
    freq.put("ubj", 31);
    freq.put("urg\u0327", 36);
    freq.put("us\u030ca\u0304", 109);
    freq.put("esi\u0304", 292);
    freq.put("ma\u0304", 4269);
    freq.put("me\u0304", 2975);
    freq.put("uri\u0304", 204);
    freq.put("kl\u0327u\u0304", 96);
    freq.put(" G\u0327e", 106);
    freq.put("mi\u0304", 785);
    freq.put("Fiz", 28);
    freq.put("Oke", 30);
    freq.put("G ", 59);
    freq.put("\u0644", 68);
    freq.put("\u05d9", 25);
    freq.put("Gv", 31);
    freq.put("Gu", 165);
    freq.put("ms\u030c", 154);
    freq.put("Gr", 518);
    freq.put("zdz", 26);
    freq.put("mu\u0304", 945);
    freq.put("Ge", 158);
    freq.put("Ga", 460);
    freq.put("Go", 173);
    freq.put("Eze", 42);
    freq.put("Gl", 88);
    freq.put("zda", 107);
    freq.put("Gi", 68);
    freq.put("C\u030ci\u0304l", 23);
    freq.put("e\u0304rs\u030c", 71);
    freq.put(" ke", 72);
    freq.put(" ki", 241);
    freq.put(" ko", 4523);
    freq.put(" kl", 531);
    freq.put(" km", 554);
    freq.put(" kr", 1914);
    freq.put(" kv", 261);
    freq.put(" ku", 4521);
    freq.put("ens\u030c", 59);
    freq.put("Fin", 30);
    freq.put("kuu", 25);
    freq.put("kut", 36);
    freq.put("Z ", 47);
    freq.put("kur", 4124);
    freq.put("kup", 73);
    freq.put("kun", 181);
    freq.put("kum", 1594);
    freq.put("ain", 809);
    freq.put("kuk", 32);
    freq.put("kuj", 25);
    freq.put("vin\u0327", 404);
    freq.put("ena\u0304", 1113);
    freq.put("\u03c2", 97);
    freq.put("e\u0304ri\u0304", 91);
    freq.put("enc\u030c", 28);
    freq.put("ene\u0304", 213);
    freq.put("e\u0304rk\u0327", 215);
    freq.put("tz", 181);
    freq.put("Zo", 72);
    freq.put("Zi", 554);
    freq.put("Ze", 604);
    freq.put("eni\u0304", 969);
    freq.put("Za", 126);
    freq.put("l\u0327g\u0327i", 26);
    freq.put("e\u0304re\u0304", 61);
    freq.put("Zu", 34);
    freq.put("Zv", 222);
    freq.put("ku ", 2253);
    freq.put("kl\u0327u", 259);
    freq.put("Kok", 40);
    freq.put("zma", 918);
    freq.put("Kom", 112);
    freq.put("Kol", 59);
    freq.put("Kon", 195);
    freq.put("Kod", 29);
    freq.put("kl\u0327a", 421);
    freq.put("Ga\u0304", 24);
    freq.put("Kop", 106);
    freq.put("Kos", 58);
    freq.put("Kor", 100);
    freq.put("kl\u0327i", 136);
    freq.put("m ", 14604);
    freq.put("tm", 416);
    freq.put("vpr", 25);
    freq.put("K\u0327", 255);
    freq.put("vpa", 23);
    freq.put("vpi", 79);
    freq.put("me", 8257);
    freq.put("md", 123);
    freq.put("mg", 152);
    freq.put("mf", 62);
    freq.put("ma", 11255);
    freq.put("ltu", 221);
    freq.put("mb", 1027);
    freq.put("mm", 568);
    freq.put("ml", 84);
    freq.put("mo", 3385);
    freq.put("mn", 294);
    freq.put("mi", 7529);
    freq.put("mk", 81);
    freq.put("mj", 254);
    freq.put("mu", 4579);
    freq.put("mt", 1499);
    freq.put("mv", 67);
    freq.put("mp", 1937);
    freq.put("ms", 4163);
    freq.put("ta", 17648);
    freq.put("mz", 26);
    freq.put("e\u0304rb", 56);
    freq.put("e\u0304ra", 721);
    freq.put("e\u0304rd", 31);
    freq.put("e\u0304re", 37);
    freq.put("e\u0304rk", 23);
    freq.put("e\u0304ri", 669);
    freq.put("e\u0304rn", 117);
    freq.put("e\u0304ro", 293);
    freq.put("e\u0304rs", 217);
    freq.put("e\u0304rp", 23);
    freq.put("e\u0304rv", 101);
    freq.put("e\u0304rt", 389);
    freq.put("e\u0304ru", 97);
    freq.put("e\u0304rz", 31);
    freq.put("ena", 2039);
    freq.put("enb", 97);
    freq.put("enc", 397);
    freq.put(" kn\u0327", 49);
    freq.put("ene", 1004);
    freq.put("Zi\u0304", 28);
    freq.put("eni", 1040);
    freq.put("enk", 331);
    freq.put("enl", 88);
    freq.put("enm", 45);
    freq.put("enn", 52);
    freq.put("eno", 1358);
    freq.put("enp", 40);
    freq.put("enr", 79);
    freq.put("ens", 2464);
    freq.put("ent", 2847);
    freq.put("enu", 734);
    freq.put("env", 1058);
    freq.put("m2", 53);
    freq.put("enz", 110);
    freq.put("kus\u030c", 110);
    freq.put("e\u0304r ", 112);
    freq.put("II ", 185);
    freq.put(" kl\u0327", 152);
    freq.put("en ", 402);
    freq.put(" ka\u0304", 2571);
    freq.put("ri\u0304g", 665);
    freq.put("ltn", 68);
    freq.put(" U\u0304d", 31);
    freq.put("kug\u0327", 144);
    freq.put(" Hu", 54);
    freq.put(" Hi", 232);
    freq.put(" Ho", 304);
    freq.put(" Ha", 441);
    freq.put("ton\u0327", 39);
    freq.put(" He", 345);
    freq.put("CH ", 201);
    freq.put("imb", 308);
    freq.put("ime", 522);
    freq.put("imf", 36);
    freq.put("al\u0327v", 40);
    freq.put("cle", 31);
    freq.put("al\u0327u", 335);
    freq.put("imo", 88);
    freq.put("imn", 195);
    freq.put("imp", 593);
    freq.put("ims", 83);
    freq.put("a\u0304vo", 161);
    freq.put("imu", 237);
    freq.put("imt", 1282);
    freq.put("a\u0304vj", 71);
    freq.put("al\u0327i", 184);
    freq.put("a\u0304vd", 67);
    freq.put("a\u0304ve", 205);
    freq.put("tos\u030c", 435);
    freq.put("a\u0304va", 113);
    freq.put("al\u0327a", 796);
    freq.put("SA ", 43);
    freq.put("via\u0304", 31);
    freq.put(" H ", 140);
    freq.put("im ", 312);
    freq.put("tol\u0327", 81);
    freq.put("c\u030cem", 249);
    freq.put("c\u030cet", 144);
    freq.put("c\u030cer", 57);
    freq.put("a\u0304v ", 562);
    freq.put("al\u0327 ", 30);
    freq.put("ras\u030c", 66);
    freq.put("s\u030cno", 38);
    freq.put("s\u030cni", 32);
    freq.put("Ita\u0304", 112);
    freq.put("raz\u030c", 305);
    freq.put("nio", 28);
    freq.put("gol", 71);
    freq.put("gon", 119);
    freq.put("god", 68);
    freq.put("gog", 33);
    freq.put("ajs", 38);
    freq.put("aju", 73);
    freq.put("aji", 783);
    freq.put("as\u030cv", 86);
    freq.put("ajo", 724);
    freq.put("aja", 469);
    freq.put("gov", 43);
    freq.put("aje", 41);
    freq.put("gos", 60);
    freq.put("gor", 256);
    freq.put("se\u0304k", 27);
    freq.put("se\u0304j", 316);
    freq.put("rak\u0327", 99);
    freq.put("W", 365);
    freq.put("se\u0304d", 44);
    freq.put("ral\u0327", 69);
    freq.put("Vid", 291);
    freq.put("Vie", 179);
    freq.put("Vik", 70);
    freq.put("Vin", 38);
    freq.put("go ", 413);
    freq.put("Vil", 141);
    freq.put("Vir", 65);
    freq.put("Vis", 230);
    freq.put("rae\u0304", 35);
    freq.put("Vit", 48);
    freq.put("be ", 419);
    freq.put("nhe", 54);
    freq.put("nha", 38);
    freq.put("nhi", 24);
    freq.put("nir", 27);
    freq.put("\u041a", 30);
    freq.put("ims\u030c", 47);
    freq.put("tor", 2083);
    freq.put("tos", 547);
    freq.put("top", 326);
    freq.put("tov", 52);
    freq.put("tot", 998);
    freq.put("toj", 671);
    freq.put("tok", 294);
    freq.put("ton", 588);
    freq.put("tol", 346);
    freq.put("tom", 540);
    freq.put("tob", 116);
    freq.put("toc", 137);
    freq.put("tof", 38);
    freq.put("tog", 69);
    freq.put("tod", 192);
    freq.put("ima\u0304", 119);
    freq.put("Fut", 176);
    freq.put("al\u0327e\u0304", 89);
    freq.put("a\u0304ve\u0304", 149);
    freq.put("ime\u0304", 165);
    freq.put("lu\u0304t", 49);
    freq.put("al\u0327a\u0304", 556);
    freq.put(" He\u0304", 35);
    freq.put("al\u0327k\u0327", 22);
    freq.put("imi\u0304", 127);
    freq.put("a\u0304vi\u0304", 87);
    freq.put(" Ha\u0304", 28);
    freq.put("raf", 152);
    freq.put("rag", 283);
    freq.put("rad", 1141);
    freq.put("lbr", 107);
    freq.put("rab", 128);
    freq.put("z\u030cn", 24);
    freq.put("ran", 1071);
    freq.put("ral", 520);
    freq.put("ram", 1238);
    freq.put("raj", 717);
    freq.put("rak", 1567);
    freq.put("rah", 53);
    freq.put("rai", 643);
    freq.put("rav", 242);
    freq.put("rat", 1049);
    freq.put("rau", 810);
    freq.put("rar", 28);
    freq.put("ras", 4121);
    freq.put("rap", 69);
    freq.put("bs ", 212);
    freq.put("rax", 25);
    freq.put("gos\u030c", 45);
    freq.put("Sys", 26);
    freq.put("Vil\u0327", 33);
    freq.put("Vin\u0327", 206);
    freq.put("thi", 29);
    freq.put("ra ", 3874);
    freq.put("bst", 77);
    freq.put("bso", 54);
    freq.put("bsk", 33);
    freq.put("bse", 25);
    freq.put("z\u030cre", 77);
    freq.put(" mu\u0304", 750);
    freq.put("pka", 321);
    freq.put("i\u0304gu", 405);
    freq.put("pko", 110);
    freq.put("oci", 581);
    freq.put("Bio", 33);
    freq.put("Bil", 27);
    freq.put("oco", 46);
    freq.put("oca", 32);
    freq.put("rsp", 142);
    freq.put("Bie", 67);
    freq.put("oce", 578);
    freq.put("abr", 109);
    freq.put("ocy", 51);
    freq.put("Biz", 31);
    freq.put("Bir", 42);
    freq.put("\u0440", 268);
    freq.put(" mi\u0304", 111);
    freq.put(" a\u0304p", 26);
    freq.put(" ma\u0304", 826);
    freq.put(" me\u0304", 678);
    freq.put("i\u0304n\u0327", 368);
    freq.put("nux", 29);
    freq.put("Pet", 30);
    freq.put("nus", 295);
    freq.put("Per", 109);
    freq.put("Pel", 45);
    freq.put("Pen", 59);
    freq.put("num", 139);
    freq.put("nuk", 32);
    freq.put("Pek", 25);
    freq.put("mut", 78);
    freq.put("i\u0304s\u030c", 592);
    freq.put("mus", 558);
    freq.put("mur", 78);
    freq.put("vve\u0304", 32);
    freq.put("fa\u0304t", 30);
    freq.put("muz", 106);
    freq.put("mug", 77);
    freq.put("\u043d\u0430 ", 32);
    freq.put("mum", 318);
    freq.put("mul", 121);
    freq.put("mun", 151);
    freq.put("mui", 109);
    freq.put("ls\u030ca", 104);
    freq.put("i\u0304c\u030c", 97);
    freq.put("te\u0304s\u030c", 90);
    freq.put("zbr", 68);
    freq.put("ls\u030cu", 27);
    freq.put("nu ", 3157);
    freq.put("i\u0304g\u0327", 38);
    freq.put("mu ", 2868);
    freq.put("i\u0304l\u0327", 122);
    freq.put(" me", 1393);
    freq.put(" ma", 1802);
    freq.put(" mm", 35);
    freq.put(" mo", 718);
    freq.put(" mi", 1711);
    freq.put(" mu", 445);
    freq.put("Re\u0304z", 54);
    freq.put("u\u0304su", 37);
    freq.put("u\u0304st", 237);
    freq.put("\u03b9\u0301", 37);
    freq.put("u\u0304sd", 328);
    freq.put("u\u0304sm", 68);
    freq.put("u\u0304si", 58);
    freq.put(" m ", 158);
    freq.put("a\u0304ga", 57);
    freq.put("oce\u0304", 27);
    freq.put("TV ", 22);
    freq.put("oci\u0304", 54);
    freq.put("n", 95937);
    freq.put("pka\u0304", 95);
    freq.put("u\u0304s ", 24);
    freq.put("te\u0304 ", 318);
    freq.put("i\u0304c", 960);
    freq.put("i\u0304b", 5893);
    freq.put("i\u0304g", 4125);
    freq.put("i\u0304d", 2819);
    freq.put("i\u0304k", 663);
    freq.put("i\u0304j", 1202);
    freq.put("i\u0304n", 1786);
    freq.put("i\u0304m", 2002);
    freq.put("i\u0304l", 317);
    freq.put("i\u0304s", 1871);
    freq.put("i\u0304r", 757);
    freq.put("i\u0304p", 453);
    freq.put("mus\u030c", 43);
    freq.put("i\u0304v", 3050);
    freq.put("i\u0304t", 3369);
    freq.put("i\u0304z", 500);
    freq.put("te\u0304n", 44);
    freq.put("te\u0304l", 335);
    freq.put("te\u0304m", 821);
    freq.put("te\u0304j", 348);
    freq.put("te\u0304k", 46);
    freq.put("zbu\u0304", 81);
    freq.put("te\u0304z", 37);
    freq.put("rne", 333);
    freq.put("te\u0304v", 63);
    freq.put("te\u0304t", 204);
    freq.put("te\u0304r", 175);
    freq.put("te\u0304s", 73);
    freq.put("vva", 94);
    freq.put("i\u0304 ", 3304);
    freq.put("mul\u0327", 23);
    freq.put("lce", 40);
    freq.put("e\u0304te", 130);
    freq.put("i\u0304gs", 407);
    freq.put(" a\u0304d", 29);
    freq.put("e\u0304ta", 1832);
    freq.put("e\u0304tn", 71);
    freq.put("e\u0304to", 79);
    freq.put("e\u0304ti", 598);
    freq.put("e\u0304tk", 66);
    freq.put("i\u0304ga", 1676);
    freq.put("e\u0304tu", 414);
    freq.put(" a\u0304r", 250);
    freq.put(" a\u0304t", 154);
    freq.put("e\u0304tr", 34);
    freq.put("e\u0304ts", 396);
    freq.put("i\u0304gi", 496);
    freq.put("i\u0304go", 298);
    freq.put("k\u0327e\u0304d", 39);
    freq.put("elj", 22);
    freq.put("elk", 50);
    freq.put("eli", 980);
    freq.put("eln", 210);
    freq.put("elo", 182);
    freq.put("ell", 209);
    freq.put("elm", 98);
    freq.put("elb", 111);
    freq.put("ela", 1449);
    freq.put("elf", 85);
    freq.put("elg", 122);
    freq.put("eld", 81);
    freq.put("ele", 1367);
    freq.put("elz", 306);
    freq.put("els", 567);
    freq.put("elp", 198);
    freq.put("elv", 59);
    freq.put("elt", 409);
    freq.put("elu", 464);
    freq.put("e\u0304t ", 252);
    freq.put("D", 3059);
    freq.put("OH ", 75);
    freq.put("ze\u0304s\u030c", 55);
    freq.put("rip", 74);
    freq.put("aha\u0304", 45);
    freq.put("el ", 113);
    freq.put("hs ", 112);
    freq.put("a\u0304te", 469);
    freq.put("a\u0304ta", 627);
    freq.put(" Ju", 233);
    freq.put("a\u0304to", 42);
    freq.put("ce\u0304s\u030c", 42);
    freq.put("dz\u030ci", 70);
    freq.put("a\u0304ti", 825);
    freq.put("viz", 69);
    freq.put(" Jo", 237);
    freq.put("a\u0304tu", 408);
    freq.put("a\u0304tr", 318);
    freq.put("a\u0304ts", 679);
    freq.put(" Je", 179);
    freq.put("tin\u0327", 164);
    freq.put(" Ja", 604);
    freq.put("zn\u0327e", 149);
    freq.put("ick", 37);
    freq.put("ici", 543);
    freq.put("nu\u0304", 52);
    freq.put("ico", 88);
    freq.put("icl", 22);
    freq.put("ns\u030c", 154);
    freq.put("ica", 238);
    freq.put("ice", 118);
    freq.put("Hu", 55);
    freq.put("Hi", 235);
    freq.put("Ho", 305);
    freq.put("nz\u030c", 71);
    freq.put("ics", 32);
    freq.put("icr", 40);
    freq.put("Ha", 442);
    freq.put("icu", 63);
    freq.put("He", 346);
    freq.put("nc\u030c", 276);
    freq.put("a\u0304t ", 234);
    freq.put("na\u0304", 8240);
    freq.put("a\u0304st", 95);
    freq.put("hst", 50);
    freq.put("ne\u0304", 1546);
    freq.put(" J ", 40);
    freq.put("ni\u0304", 2204);
    freq.put("ic ", 183);
    freq.put("H ", 468);
    freq.put("aha", 93);
    freq.put("ahi", 35);
    freq.put("s\u030cla", 74);
    freq.put("ahr", 22);
    freq.put("ahs", 67);
    freq.put("ze\u0304 ", 172);
    freq.put("aht", 36);
    freq.put(" \u0421 ", 34);
    freq.put("git", 41);
    freq.put("gis", 49);
    freq.put("els\u030c", 89);
    freq.put("a\u0304tn", 541);
    freq.put("gie", 240);
    freq.put("gin", 40);
    freq.put("ze\u0304t", 500);
    freq.put("ah ", 32);
    freq.put("ze\u0304r", 47);
    freq.put("ze\u0304s", 27);
    freq.put("ela\u0304", 1125);
    freq.put("e\u0304ti\u0304", 178);
    freq.put("ze\u0304l", 36);
    freq.put("ele\u0304", 112);
    freq.put("ze\u0304j", 212);
    freq.put("ura", 1608);
    freq.put("eli\u0304", 103);
    freq.put("un\u0327", 333);
    freq.put("e\u0304ta\u0304", 792);
    freq.put("Vol", 134);
    freq.put("i\u0304ga\u0304", 813);
    freq.put("Vor", 36);
    freq.put("gi ", 519);
    freq.put("ce\u0304m", 41);
    freq.put("ce\u0304l", 179);
    freq.put("ce\u0304n", 32);
    freq.put("nni", 41);
    freq.put("ce\u0304j", 228);
    freq.put("nne", 83);
    freq.put("nna", 118);
    freq.put("k\u0327u ", 470);
    freq.put(" Ju\u0304", 171);
    freq.put("ce\u0304t", 118);
    freq.put("a\u0304na\u0304", 124);
    freq.put("nh", 159);
    freq.put("ni", 10637);
    freq.put("nj", 103);
    freq.put("nk", 1409);
    freq.put("nl", 178);
    freq.put("nm", 119);
    freq.put("nn", 366);
    freq.put("no", 13676);
    freq.put("tit", 273);
    freq.put("na", 11100);
    freq.put("nb", 173);
    freq.put("nc", 1308);
    freq.put("nd", 3610);
    freq.put("ne", 6367);
    freq.put("nf", 496);
    freq.put("ng", 2033);
    freq.put("til", 601);
    freq.put("ny", 68);
    freq.put("nz", 252);
    freq.put("tio", 312);
    freq.put("tij", 940);
    freq.put("ES ", 40);
    freq.put("np", 87);
    freq.put("tie", 4403);
    freq.put("nr", 301);
    freq.put("ns", 6634);
    freq.put("nt", 6816);
    freq.put("nu", 3766);
    freq.put("nv", 1299);
    freq.put("tic", 277);
    freq.put("k\u0327us", 35);
    freq.put("ll", 864);
    freq.put("He\u0304", 35);
    freq.put("ce\u0304 ", 120);
    freq.put("nn ", 32);
    freq.put("ich", 68);
    freq.put("ice\u0304", 211);
    freq.put("Ha\u0304", 28);
    freq.put("ici\u0304", 260);
    freq.put("a\u0304ta\u0304", 439);
    freq.put("n ", 12333);
    freq.put(" Je\u0304", 211);
    freq.put("a\u0304te\u0304", 54);
    freq.put(" Ja\u0304", 93);
    freq.put("dz\u030cu", 100);
    freq.put("roi", 35);
    freq.put("roj", 521);
    freq.put("rok", 423);
    freq.put("rol", 216);
    freq.put("rom", 435);
    freq.put("ron", 900);
    freq.put("roo", 23);
    freq.put("lls", 27);
    freq.put("roa", 30);
    freq.put("rob", 624);
    freq.put("roc", 512);
    freq.put("rod", 1744);
    freq.put("roe", 58);
    freq.put("rof", 236);
    freq.put("rog", 545);
    freq.put("dz\u030ce", 114);
    freq.put("roz", 140);
    freq.put("llo", 82);
    freq.put("rop", 1052);
    freq.put("ror", 63);
    freq.put("ros", 500);
    freq.put("rot", 765);
    freq.put("rou", 41);
    freq.put("rov", 266);
    freq.put("Dab", 33);
    freq.put("Dan", 52);
    freq.put("Dat", 63);
    freq.put("Dau", 261);
    freq.put("Dar", 42);
    freq.put("S\u030c", 1043);
    freq.put("ro ", 308);
    freq.put("Cil", 47);
    freq.put("Cir", 22);
    freq.put("Cit", 38);
    freq.put("ll ", 123);
    freq.put("ict", 31);
    freq.put("Res", 30);
    freq.put("Rep", 321);
    freq.put("pme", 52);
    freq.put("Rei", 58);
    freq.put("Ren", 27);
    freq.put("pma", 68);
    freq.put("Rec", 23);
    freq.put("Red", 33);
    freq.put("\u0131", 70);
    freq.put("gl\u0327u\u0304", 52);
    freq.put("ti\u0304", 5903);
    freq.put("zsa\u0304", 72);
    freq.put("zi\u0304l", 49);
    freq.put("zi\u0304m", 1070);
    freq.put("zi\u0304j", 29);
    freq.put("Mil", 64);
    freq.put("neo", 76);
    freq.put("zi\u0304g", 242);
    freq.put("zi\u0304b", 324);
    freq.put("zi\u0304c", 55);
    freq.put("zi\u0304t", 108);
    freq.put("zi\u0304v", 1468);
    freq.put("zi\u0304s", 345);
    freq.put("ros\u030c", 448);
    freq.put("roz\u030c", 23);
    freq.put("\u041e", 27);
    freq.put("ngt", 36);
    freq.put("ci\u0304g", 288);
    freq.put("ci\u0304b", 793);
    freq.put("msu", 24);
    freq.put("ci\u0304n", 190);
    freq.put("mss", 33);
    freq.put("ci\u0304k", 97);
    freq.put("Ogr", 36);
    freq.put("ci\u0304t", 112);
    freq.put("msk", 121);
    freq.put("Daz\u030c", 59);
    freq.put("msa", 67);
    freq.put("ci\u0304z", 63);
    freq.put("roi\u0304", 36);
    freq.put("obj", 208);
    freq.put("ci\u0304 ", 27);
    freq.put("dz\u030ca\u0304", 37);
    freq.put("ms ", 3789);
    freq.put(" on", 40);
    freq.put("Mih", 26);
    freq.put(" ol", 76);
    freq.put("tik\u0327", 219);
    freq.put(" ok", 512);
    freq.put("Min", 133);
    freq.put(" of", 307);
    freq.put(" og", 135);
    freq.put("Mic", 50);
    freq.put("Mie", 24);
    freq.put(" \u03b1 ", 31);
    freq.put(" ot", 330);
    freq.put("Mir", 23);
    freq.put(" or", 1147);
    freq.put(" os", 114);
    freq.put(" op", 221);
    freq.put("pmu\u0304", 26);
    freq.put("Reg\u0327", 30);
    freq.put("lmi", 75);
    freq.put("pme\u0304", 120);
    freq.put("zi\u0304s\u030c", 29);
    freq.put("pma\u0304", 37);
    freq.put("Zie", 391);
    freq.put("lse\u0304", 1122);
    freq.put("Zin", 62);
    freq.put("Zil", 29);
    freq.put("gta", 111);
    freq.put("TP ", 38);
    freq.put(" ca", 410);
    freq.put("gto", 46);
    freq.put("gts", 50);
    freq.put("gtu", 35);
    freq.put("\u0648", 37);
    freq.put("ppl", 37);
    freq.put("gt ", 56);
    freq.put("a\u0304ze\u0304", 88);
    freq.put("ppu", 25);
    freq.put(" La\u0304", 40);
    freq.put("pru\u0304", 42);
    freq.put("z\u030ca\u0304 ", 38);
    freq.put("\u0438\u0438\u0306", 38);
    freq.put(" Le\u0304", 28);
    freq.put("\u0438\u043d", 34);
    freq.put("e\u0304vs", 32);
    freq.put("ejn", 76);
    freq.put("ejo", 81);
    freq.put("eji", 80);
    freq.put(" Li\u0304", 215);
    freq.put("eja", 808);
    freq.put("eju", 260);
    freq.put("ejv", 23);
    freq.put("ejs", 177);
    freq.put("z\u030ca\u0304s", 33);
    freq.put("\u03c6", 23);
    freq.put("pri\u0304", 60);
    freq.put("ani\u0304", 82);
    freq.put("z\u030ca\u0304d", 455);
    freq.put("z\u030ca\u0304k", 194);
    freq.put("z\u030ca\u0304m", 34);
    freq.put("pra\u0304", 125);
    freq.put("ana\u0304", 994);
    freq.put("anc\u030c", 183);
    freq.put(" Lu\u0304", 27);
    freq.put("\u0438\u0447", 34);
    freq.put("pre\u0304", 65);
    freq.put("ane\u0304", 182);
    freq.put("\u0421 ", 41);
    freq.put("hu ", 43);
    freq.put("a\u0304ze", 265);
    freq.put("a\u0304zu", 50);
    freq.put("iam", 59);
    freq.put("ial", 119);
    freq.put("ian", 220);
    freq.put("iak", 26);
    freq.put("s\u030ci\u0304s", 96);
    freq.put("s\u030ci\u0304r", 28);
    freq.put("iag", 25);
    freq.put("c\u030ca ", 145);
    freq.put("s\u030ci\u0304n", 152);
    freq.put("iaz", 26);
    freq.put("iat", 108);
    freq.put("ias", 27);
    freq.put("hum", 50);
    freq.put("ia ", 270);
    freq.put("r", 127678);
    freq.put("s\u030ci\u0304 ", 103);
    freq.put("and", 1589);
    freq.put("ane", 123);
    freq.put("ang", 611);
    freq.put("pra", 501);
    freq.put("ana", 3035);
    freq.put("anc", 401);
    freq.put("anl", 23);
    freq.put("ann", 140);
    freq.put("ano", 394);
    freq.put("anh", 30);
    freq.put("ani", 1185);
    freq.put("anj", 22);
    freq.put("ank", 275);
    freq.put("pru", 34);
    freq.put("anu", 718);
    freq.put("anv", 34);
    freq.put("s\u030cre", 66);
    freq.put("anr", 123);
    freq.put("ans", 674);
    freq.put("anz", 65);
    freq.put("ML ", 46);
    freq.put("\u0435", 335);
    freq.put("an ", 784);
    freq.put("eja\u0304", 89);
    freq.put(" Le", 272);
    freq.put(" La", 2100);
    freq.put(" Lo", 254);
    freq.put(" Li", 1175);
    freq.put(" Lu", 187);
    freq.put("e\u0304ve\u0304", 143);
    freq.put(" Ly", 24);
    freq.put("poz\u030c", 46);
    freq.put("tka", 280);
    freq.put("tko", 27);
    freq.put("tkl", 212);
    freq.put("IP ", 41);
    freq.put("tki", 59);
    freq.put("nla", 94);
    freq.put("tku", 37);
    freq.put("nle", 25);
    freq.put("ze\u0304m", 74);
    freq.put("dy ", 22);
    freq.put("ss ", 875);
    freq.put("pos\u030c", 65);
    freq.put("\u0447 ", 32);
    freq.put("pol\u0327", 35);
    freq.put("H", 1820);
    freq.put("ssv", 26);
    freq.put("ssp", 22);
    freq.put("sso", 61);
    freq.put("ssi", 62);
    freq.put("ssk", 34);
    freq.put("sse", 108);
    freq.put("ssa", 247);
    freq.put("rms", 203);
    freq.put("rmu", 139);
    freq.put("lnu", 164);
    freq.put("lnv", 34);
    freq.put("lns", 198);
    freq.put("lno", 58);
    freq.put("rma", 773);
    freq.put("lni", 256);
    freq.put("lnk", 23);
    freq.put("rme", 418);
    freq.put("lne", 55);
    freq.put("rmk", 26);
    freq.put("rmi", 499);
    freq.put("l\u0327s\u030c ", 124);
    freq.put("rmo", 304);
    freq.put("nno", 31);
    freq.put("uci", 96);
    freq.put("poz", 106);
    freq.put("pot", 153);
    freq.put("por", 630);
    freq.put("pos", 221);
    freq.put("pop", 247);
    freq.put("pon", 210);
    freq.put("pol", 767);
    freq.put("poj", 154);
    freq.put("pok", 25);
    freq.put("pog", 70);
    freq.put("pod", 51);
    freq.put("Bur", 79);
    freq.put("Bul", 41);
    freq.put("po ", 65);
    freq.put("tka\u0304", 47);
    freq.put("seg", 72);
    freq.put("l\u0327um", 33);
    freq.put("okr", 192);
    freq.put("oku", 309);
    freq.put("okt", 89);
    freq.put("\u0431", 51);
    freq.put("I ", 434);
    freq.put("a\u0304tn\u0327", 41);
    freq.put("Da\u0304n", 37);
    freq.put("XX ", 24);
    freq.put("Da\u0304r", 22);
    freq.put("rme\u0304", 77);
    freq.put("Iz", 255);
    freq.put("tiz", 110);
    freq.put("Is", 56);
    freq.put("Ir", 159);
    freq.put("It", 130);
    freq.put("Iv", 35);
    freq.put("Ik", 26);
    freq.put("rma\u0304", 762);
    freq.put("Im", 77);
    freq.put("Il", 62);
    freq.put("In", 597);
    freq.put("oke", 542);
    freq.put("Ib", 23);
    freq.put("Ie", 161);
    freq.put("Id", 25);
    freq.put("Ig", 193);
    freq.put("ra\u0304n\u0327", 44);
    freq.put(" qu", 23);
    freq.put("tip", 378);
    freq.put("oki", 85);
    freq.put("tir", 195);
    freq.put("tis", 2277);
    freq.put("i\u0304ks\u030c", 28);
    freq.put("l\u0327n\u0327u", 56);
    freq.put("ra\u0304s\u030c", 23);
    freq.put("ai\u0304s", 153);
    freq.put("tin", 593);
    freq.put("je\u0304j", 29);
    freq.put("okl", 145);
    freq.put("l\u0327n\u0327a", 76);
    freq.put("l\u0327n\u0327i", 27);
    freq.put("jus\u030c", 280);
    freq.put("tik", 1958);
    freq.put("tid", 70);
    freq.put("eha\u0304", 103);
    freq.put("tif", 82);
    freq.put("de\u0304n", 29);
    freq.put("tig", 30);
    freq.put("Pil", 83);
    freq.put("Pie", 153);
    freq.put("tia", 75);
    freq.put("de\u0304j", 602);
    freq.put("Pir", 196);
    freq.put("Pit", 22);
    freq.put("ehi\u0304", 26);
    freq.put("ni\u0304b", 728);
    freq.put("ni\u0304c", 430);
    freq.put("ni\u0304d", 58);
    freq.put("ni\u0304g", 331);
    freq.put("\u0438 ", 54);
    freq.put("Kur", 259);
    freq.put("ni\u0304n", 27);
    freq.put("Se\u0304r", 28);
    freq.put("Se\u0304l", 24);
    freq.put("alt", 791);
    freq.put("Kul", 67);
    freq.put("ni\u0304t", 121);
    freq.put("gvi", 84);
    freq.put("igz\u030c", 89);
    freq.put("gva", 31);
    freq.put("vze", 33);
    freq.put("o ", 13523);
    freq.put("igu\u0304", 45);
    freq.put("ni\u0304 ", 207);
    freq.put("und", 348);
    freq.put("a\u0304ti\u0304", 67);
    freq.put("iga\u0304", 206);
    freq.put("zci\u0304", 73);
    freq.put("oo", 225);
    freq.put("on", 9439);
    freq.put("om", 4560);
    freq.put("ol", 6437);
    freq.put("ok", 3012);
    freq.put("oj", 3579);
    freq.put("oi", 175);
    freq.put("oh", 231);
    freq.put("og", 1772);
    freq.put("of", 937);
    freq.put("oe", 196);
    freq.put("od", 5344);
    freq.put("oc", 1480);
    freq.put("ob", 1666);
    freq.put("oa", 231);
    freq.put("rve\u0304", 141);
    freq.put("oz", 1358);
    freq.put("oy", 26);
    freq.put("ox", 43);
    freq.put("ow", 104);
    freq.put("ov", 1717);
    freq.put("ou", 258);
    freq.put("ot", 8233);
    freq.put("os", 7017);
    freq.put("or", 8642);
    freq.put("op", 3592);
    freq.put("ju ", 3050);
    freq.put("i\u0304ks", 151);
    freq.put("i\u0304kl", 241);
    freq.put("i\u0304ko", 106);
    freq.put("dol", 232);
    freq.put("Jum", 22);
    freq.put("i\u0304ka", 42);
    freq.put("ra\u0304f", 309);
    freq.put("ra\u0304g", 38);
    freq.put("ra\u0304d", 816);
    freq.put("ra\u0304b", 117);
    freq.put("ra\u0304c", 432);
    freq.put("ra\u0304n", 164);
    freq.put("plu\u0304", 201);
    freq.put("ra\u0304l", 881);
    freq.put("ra\u0304m", 402);
    freq.put("ra\u0304j", 67);
    freq.put("ra\u0304k", 869);
    freq.put("ra\u0304v", 135);
    freq.put("\u03b3", 49);
    freq.put("ra\u0304r", 31);
    freq.put("ra\u0304s", 553);
    freq.put("ra\u0304p", 24);
    freq.put("ehn", 276);
    freq.put("eho", 29);
    freq.put("ra\u0304z", 74);
    freq.put("ehi", 58);
    freq.put("jum", 2601);
    freq.put("jur", 89);
    freq.put("jus", 320);
    freq.put("zs\u030ck\u0327", 85);
    freq.put("ra\u0304 ", 1557);
    freq.put("zn\u0327e\u0304", 241);
    freq.put("ni\u0304s\u030c", 44);
    freq.put("rva", 432);
    freq.put("cba", 35);
    freq.put("rve", 210);
    freq.put("oti", 1556);
    freq.put("rvi", 327);
    freq.put("rvs", 22);
    freq.put("rvu", 63);
    freq.put("unk", 486);
    freq.put("sa\u0304k", 643);
    freq.put("sa\u0304j", 28);
    freq.put("igu", 73);
    freq.put("igs", 27);
    freq.put("igr", 58);
    freq.put("sa\u0304m", 92);
    freq.put("sa\u0304l", 103);
    freq.put("sa\u0304c", 43);
    freq.put("og\u0327", 891);
    freq.put("igz", 407);
    freq.put("\u0631", 50);
    freq.put("ige", 58);
    freq.put("ol\u0327", 231);
    freq.put("iga", 284);
    freq.put("ota", 947);
    freq.put("igo", 33);
    freq.put("ign", 102);
    freq.put("igm", 40);
    freq.put("igl", 56);
    freq.put("igi", 68);
    freq.put("igh", 40);
    freq.put("A\u0304fr", 113);
    freq.put("on\u0327", 431);
    freq.put("s\u0327", 30);
    freq.put("ti ", 2942);
    freq.put("sa\u0304 ", 333);
    freq.put("os\u030c", 2487);
    freq.put("oz\u030c", 188);
    freq.put(" \u2212 ", 35);
    freq.put("aln", 628);
    freq.put("alo", 1383);
    freq.put("all", 272);
    freq.put("alm", 121);
    freq.put("alk", 231);
    freq.put("pti", 177);
    freq.put("ali", 1208);
    freq.put("alf", 96);
    freq.put("alg", 97);
    freq.put("pte", 121);
    freq.put("ale", 584);
    freq.put("alb", 172);
    freq.put("alc", 61);
    freq.put("pta", 564);
    freq.put("ala", 1330);
    freq.put("s\u030cpi", 125);
    freq.put("rks\u030c", 28);
    freq.put("alv", 1226);
    freq.put("ptv", 61);
    freq.put("fa ", 173);
    freq.put("alu", 519);
    freq.put("als", 1977);
    freq.put("alp", 208);
    freq.put("ots", 723);
    freq.put("dz\u030cs", 35);
    freq.put(" N ", 55);
    freq.put("faz", 23);
    freq.put("far", 40);
    freq.put("fas", 28);
    freq.put("al ", 300);
    freq.put("fak", 97);
    freq.put("fai", 36);
    freq.put("fan", 93);
    freq.put("llu", 78);
    freq.put("fal", 45);
    freq.put("fab", 102);
    freq.put(" Ni", 163);
    freq.put("ga\u0304l\u0327", 23);
    freq.put(" No", 486);
    freq.put(" Na", 328);
    freq.put(" Ne", 334);
    freq.put("lli", 182);
    freq.put("rka\u0304", 93);
    freq.put("dz\u030ca", 84);
    freq.put(" Nu", 37);
    freq.put("teh", 268);
    freq.put("tei", 672);
    freq.put("tej", 47);
    freq.put("ks\u030c ", 48);
    freq.put("tel", 542);
    freq.put("tem", 480);
    freq.put("ten", 587);
    freq.put("teo", 285);
    freq.put("teb", 48);
    freq.put("tec", 92);
    freq.put("ted", 53);
    freq.put("nbu", 52);
    freq.put("teg", 123);
    freq.put("tep", 65);
    freq.put("ter", 2575);
    freq.put("tes", 1146);
    freq.put("tet", 45);
    freq.put("lla", 140);
    freq.put("nbe", 61);
    freq.put("sug", 619);
    freq.put("sud", 63);
    freq.put("sub", 69);
    freq.put("sun", 42);
    freq.put("sum", 128);
    freq.put("sul", 139);
    freq.put("suv", 25);
    freq.put("sus", 127);
    freq.put("sur", 82);
    freq.put("sup", 49);
    freq.put("ks\u030ca", 264);
    freq.put("ks\u030cd", 149);
    freq.put("ks\u030ck", 106);
    freq.put("o\u0304", 55);
    freq.put("ks\u030cn", 32);
    freq.put("ks\u030cm", 75);
    freq.put("ks\u030cl", 23);
    freq.put("ks\u030cs", 52);
    freq.put("ks\u030cp", 164);
    freq.put("ks\u030cu", 53);
    freq.put("ks\u030ct", 50);
    freq.put("Dz\u030cu", 25);
    freq.put("su ", 834);
    freq.put("Dz\u030ce", 88);
    freq.put("Dz\u030co", 145);
    freq.put("rkt", 251);
    freq.put("rku", 265);
    freq.put("ptu\u0304", 22);
    freq.put("alu\u0304", 32);
    freq.put("rks", 248);
    freq.put("Tor", 80);
    freq.put("Tos", 31);
    freq.put("Top", 34);
    freq.put("rke", 63);
    freq.put("rka", 377);
    freq.put("Tom", 55);
    freq.put("rkl", 58);
    freq.put("rkn", 35);
    freq.put("rko", 61);
    freq.put("sch", 88);
    freq.put("rki", 73);
    freq.put(" Ni\u0304", 78);
    freq.put("ga\u0304z", 197);
    freq.put("ga\u0304t", 113);
    freq.put("ga\u0304s", 198);
    freq.put("ga\u0304r", 144);
    freq.put("ga\u0304n", 110);
    freq.put("ga\u0304m", 215);
    freq.put("ga\u0304l", 68);
    freq.put("ga\u0304k", 229);
    freq.put("ga\u0304j", 129);
    freq.put("\u03b7", 40);
    freq.put("ga\u0304d", 124);
    freq.put("ga\u0304c", 40);
    freq.put("pti\u0304", 28);
    freq.put("ali\u0304", 910);
    freq.put("rk ", 63);
    freq.put("To ", 233);
    freq.put("ebu\u0304", 23);
    freq.put("a\u0301", 40);
    freq.put("Int", 119);
    freq.put("ala\u0304", 492);
    freq.put("v", 49552);
    freq.put("Ind", 290);
    freq.put("Inf", 36);
    freq.put("Ing", 34);
    freq.put("ale\u0304", 137);
    freq.put("Inc", 26);
    freq.put("ks\u030cg\u0327", 28);
    freq.put("sun\u0327", 88);
    freq.put("ks\u030ck\u0327", 38);
    freq.put("ks\u030ca\u0304", 24);
    freq.put("ten\u0327", 82);
    freq.put("ks\u030ce\u0304", 181);
    freq.put("\u0438\u0306", 81);
    freq.put("sua\u0304", 44);
    freq.put("\u03bd ", 22);
    freq.put("Aka", 34);
    freq.put("ks\u030cz\u030c", 25);
    freq.put("lhe", 59);
    freq.put("ks\u030cn\u0327", 49);
    freq.put("tea\u0304", 78);
    freq.put("maj", 174);
    freq.put("G\u0327", 128);
    freq.put(" I\u0304s", 47);
    freq.put(" I\u0304r", 60);
    freq.put("mal", 305);
    freq.put("Fri", 44);
    freq.put("L", 4567);
    freq.put("\u0432\u0438\u0447", 26);
    freq.put("C\u030c", 300);
    freq.put("Ern", 25);
    freq.put("Eri", 30);
    freq.put("Rag", 24);
    freq.put("Rad", 110);
    freq.put("Me\u0304r", 47);
    freq.put("Rai", 35);
    freq.put("Me\u0304n", 64);
    freq.put("Rau", 22);
    freq.put(" Na\u0304", 75);
    freq.put("a\u0304cb", 31);
    freq.put("a\u0304ca", 27);
    freq.put("Mus", 124);
    freq.put("Mur", 22);
    freq.put(" sp", 2239);
    freq.put(" sv", 412);
    freq.put(" st", 3025);
    freq.put(" su", 879);
    freq.put(" sk", 1357);
    freq.put(" sh", 33);
    freq.put(" si", 1753);
    freq.put(" sn", 112);
    freq.put(" so", 351);
    freq.put(" sl", 596);
    freq.put(" sm", 289);
    freq.put(" sc", 42);
    freq.put(" sa", 6813);
    freq.put(" sf", 46);
    freq.put(" se", 1483);
    freq.put("iza", 170);
    freq.put("izb", 41);
    freq.put("izc", 301);
    freq.put("izd", 376);
    freq.put("ize", 159);
    freq.put("izg", 245);
    freq.put("izi", 513);
    freq.put("izj", 45);
    freq.put("izk", 139);
    freq.put("izl", 692);
    freq.put("izm", 1077);
    freq.put("izn", 131);
    freq.put("izo", 166);
    freq.put("izp", 558);
    freq.put("izr", 274);
    freq.put("izs", 752);
    freq.put("izt", 200);
    freq.put("izu", 55);
    freq.put("izv", 798);
    freq.put("izz", 43);
    freq.put(" em", 85);
    freq.put("kok", 286);
    freq.put("e\u0304ji\u0304", 33);
    freq.put(" s ", 86);
    freq.put("kol", 578);
    freq.put("iz ", 254);
    freq.put("kon", 1216);
    freq.put("oz\u030cu", 58);
    freq.put("e\u0304ja\u0304", 633);
    freq.put("X ", 140);
    freq.put("kog", 34);
    freq.put("Ri\u0304g", 820);
    freq.put("\u0441\u043a\u0438", 39);
    freq.put("\u0441\u043a\u043e", 22);
    freq.put("\u0441\u043a\u0430", 25);
    freq.put(" ev", 61);
    freq.put("kov", 64);
    freq.put("js ", 1627);
    freq.put("izn\u0327", 119);
    freq.put("e\u0304jr", 35);
    freq.put("e\u0304js", 400);
    freq.put("e\u0304jp", 24);
    freq.put("e\u0304ju", 643);
    freq.put(" su\u0304", 56);
    freq.put("e\u0304ji", 561);
    freq.put("e\u0304jo", 477);
    freq.put("e\u0304ja", 1223);
    freq.put("e\u0304jd", 44);
    freq.put("izs\u030c", 65);
    freq.put("efs", 31);
    freq.put("efi", 131);
    freq.put("efo", 131);
    freq.put("efa", 30);
    freq.put("efe", 198);
    freq.put("iza\u0304", 483);
    freq.put("imi", 811);
    freq.put("a\u0304ci\u0304", 199);
    freq.put("jsi", 45);
    freq.put(" si\u0304", 84);
    freq.put("ize\u0304", 509);
    freq.put("e\u0304j ", 73);
    freq.put(" se\u0304", 228);
    freq.put("Zel", 41);
    freq.put("Zem", 525);
    freq.put("a\u0304ce\u0304", 37);
    freq.put("pa\u0304c", 26);
    freq.put(" sa\u0304", 685);
    freq.put("rte", 168);
    freq.put("rta", 1012);
    freq.put("rtl", 32);
    freq.put("rto", 248);
    freq.put("rtn", 59);
    freq.put("rti", 792);
    freq.put("rth", 30);
    freq.put("rtu", 328);
    freq.put("rts", 333);
    freq.put("rtr", 97);
    freq.put("iez", 227);
    freq.put("i\u0304m ", 246);
    freq.put("iep", 380);
    freq.put("ies", 2658);
    freq.put("ier", 1197);
    freq.put("iet", 4005);
    freq.put("iev", 1792);
    freq.put("iek", 4508);
    freq.put("iej", 39);
    freq.put("iem", 8120);
    freq.put("iel", 3446);
    freq.put("ien", 7676);
    freq.put("iea", 35);
    freq.put("pu\u0304", 149);
    freq.put("iec", 1164);
    freq.put("ieb", 72);
    freq.put("iee", 100);
    freq.put("ied", 2745);
    freq.put("ieg", 992);
    freq.put("hip", 128);
    freq.put("pe\u0304", 3898);
    freq.put("his", 79);
    freq.put("hit", 143);
    freq.put("rt ", 437);
    freq.put("dua\u0304", 33);
    freq.put("hib", 51);
    freq.put("hic", 23);
    freq.put("hid", 182);
    freq.put("hie", 34);
    freq.put("hij", 70);
    freq.put("mfo", 25);
    freq.put("hil", 44);
    freq.put("him", 44);
    freq.put("hin", 98);
    freq.put("i\u0304me", 446);
    freq.put("i\u0304mo", 31);
    freq.put("i\u0304mj", 45);
    freq.put("pl\u0327", 34);
    freq.put("i\u0304mu", 34);
    freq.put("tga\u0304", 22);
    freq.put("i\u0304ms", 40);
    freq.put("ie ", 1698);
    freq.put("J ", 48);
    freq.put("arp", 1342);
    freq.put("arr", 34);
    freq.put("ars", 430);
    freq.put("art", 883);
    freq.put("aru", 580);
    freq.put("arv", 25);
    freq.put("ary", 36);
    freq.put("pva", 35);
    freq.put("ara", 2574);
    freq.put("arb", 1417);
    freq.put("arc", 143);
    freq.put("ard", 512);
    freq.put("s\u030cvi", 22);
    freq.put("arg", 217);
    freq.put("pvi", 404);
    freq.put("s\u030cve", 23);
    freq.put("arj", 66);
    freq.put("ark", 821);
    freq.put("arl", 146);
    freq.put("s\u030cva", 72);
    freq.put("arn", 121);
    freq.put("ris\u030c", 83);
    freq.put("ns\u030ca", 32);
    freq.put(" P ", 63);
    freq.put("ns\u030ct", 29);
    freq.put("ns\u030cu", 53);
    freq.put("rin\u0327", 229);
    freq.put("rik\u0327", 45);
    freq.put("uus", 124);
    freq.put("ar ", 6199);
    freq.put("rig\u0327", 56);
    freq.put(" Ps", 28);
    freq.put(" Pr", 570);
    freq.put("c", 22500);
    freq.put(" Pu", 147);
    freq.put("liv", 35);
    freq.put("ite\u0304", 104);
    freq.put(" Pa", 1447);
    freq.put(" Pe", 329);
    freq.put(" Pi", 541);
    freq.put(" Ph", 55);
    freq.put(" Po", 516);
    freq.put(" Pl", 245);
    freq.put("tgr", 47);
    freq.put("en\u0327e\u0304", 35);
    freq.put("tga", 132);
    freq.put("i\u0304me\u0304", 659);
    freq.put("ien\u0327", 198);
    freq.put("pr", 4678);
    freq.put("ps", 1123);
    freq.put("pp", 139);
    freq.put("duk", 158);
    freq.put("pv", 476);
    freq.put("dum", 173);
    freq.put("pt", 1346);
    freq.put("pu", 3008);
    freq.put("pz", 438);
    freq.put("dua", 23);
    freq.put("dub", 73);
    freq.put("duc", 94);
    freq.put("i\u0304mi\u0304", 130);
    freq.put("dug", 33);
    freq.put("pb", 92);
    freq.put("pc", 59);
    freq.put("pa", 12196);
    freq.put("pg", 761);
    freq.put("pd", 241);
    freq.put("n\u0327am", 33);
    freq.put("ies\u030c", 1802);
    freq.put("pk", 534);
    freq.put("dur", 107);
    freq.put("dus", 742);
    freq.put("pn", 123);
    freq.put("po", 2922);
    freq.put("pl", 2446);
    freq.put("pm", 337);
    freq.put("\u0438\u0306 ", 60);
    freq.put("Emi", 22);
    freq.put("rti\u0304", 278);
    freq.put("Je\u0304", 211);
    freq.put("Ja\u0304", 93);
    freq.put("rta\u0304", 193);
    freq.put("iel\u0327", 23);
    freq.put("du ", 1832);
    freq.put("iek\u0327", 378);
    freq.put("zi\u0304d", 65);
    freq.put("p ", 1187);
    freq.put("rte\u0304", 197);
    freq.put("n\u0327a ", 1018);
    freq.put(" Pe\u0304", 221);
    freq.put("riz", 128);
    freq.put("riv", 81);
    freq.put("rit", 1293);
    freq.put("riu", 29);
    freq.put("ris", 2568);
    freq.put("Tir", 25);
    freq.put("rin", 683);
    freq.put("ars\u030c", 263);
    freq.put("ril", 99);
    freq.put("rim", 290);
    freq.put("rij", 2366);
    freq.put("rik", 885);
    freq.put("rih", 80);
    freq.put("rif", 114);
    freq.put("Tie", 134);
    freq.put("rid", 231);
    freq.put("rie", 3740);
    freq.put("rib", 107);
    freq.put("ric", 188);
    freq.put("Tib", 26);
    freq.put("ria", 161);
    freq.put(" Pi\u0304", 38);
    freq.put("Cor", 106);
    freq.put("spa\u0304", 202);
    freq.put("ari\u0304", 2864);
    freq.put("Com", 69);
    freq.put("Col", 30);
    freq.put("ri ", 1063);
    freq.put("Con", 48);
    freq.put("are\u0304", 195);
    freq.put("ekr", 305);
    freq.put("ara\u0304", 580);
    freq.put(" Pu\u0304", 23);
    freq.put("s\u030cva\u0304", 48);
    freq.put("e\u0304k\u0327i", 49);
    freq.put("uzi", 73);
    freq.put("sal", 1082);
    freq.put("uzg", 36);
    freq.put("Aiz", 104);
    freq.put("\u044c", 65);
    freq.put("ljo", 123);
    freq.put("lja", 61);
    freq.put("lje", 30);
    freq.put("gru\u0304", 45);
    freq.put("gre\u0304", 114);
    freq.put("zzi", 39);
    freq.put("gra\u0304", 671);
    freq.put("Rom", 176);
    freq.put("Ron", 23);
    freq.put("Rob", 99);
    freq.put("Rod", 49);
    freq.put("yla", 29);
    freq.put("Ros", 76);
    freq.put("gri\u0304", 79);
    freq.put("mst", 25);
    freq.put(" uz", 2903);
    freq.put(" ut", 55);
    freq.put(" up", 232);
    freq.put(" ur", 52);
    freq.put(" un", 10091);
    freq.put("ron\u0327", 62);
    freq.put(" ug", 66);
    freq.put("zju\u0304", 39);
    freq.put(" u ", 116);
    freq.put("ix ", 38);
    freq.put("z", 35062);
    freq.put("gru", 596);
    freq.put("gre", 213);
    freq.put("gra", 755);
    freq.put("gro", 67);
    freq.put("gri", 552);
    freq.put("\u2212C", 44);
    freq.put("kru\u0304", 64);
    freq.put("ic\u030ca", 38);
    freq.put("eda", 646);
    freq.put(" Re\u0304", 60);
    freq.put("ede", 1042);
    freq.put("ic\u030ci", 25);
    freq.put("e\u0304lu", 113);
    freq.put("edi", 335);
    freq.put("edo", 120);
    freq.put("e\u0304ls", 126);
    freq.put("edr", 685);
    freq.put("eds", 41);
    freq.put("\u043a\u043e", 45);
    freq.put("e\u0304lo", 171);
    freq.put("\u043a\u0438", 52);
    freq.put("e\u0304li", 303);
    freq.put("edu", 254);
    freq.put("edz", 1195);
    freq.put("e\u0304le", 379);
    freq.put("\u043a\u0430", 54);
    freq.put("e\u0304la", 172);
    freq.put("uga", 887);
    freq.put(" Ri\u0304", 858);
    freq.put("ed ", 130);
    freq.put("vor", 27);
    freq.put("gus\u030c", 31);
    freq.put("api\u0304", 65);
    freq.put("use\u0304", 169);
    freq.put("e\u0304l ", 109);
    freq.put("roc\u030c", 76);
    freq.put("Pa\u0304r", 113);
    freq.put("kn\u0327u", 24);
    freq.put("Pa\u0304v", 29);
    freq.put("usi\u0304", 47);
    freq.put("kn\u0327a", 79);
    freq.put("apa\u0304", 234);
    freq.put(" Ru\u0304", 43);
    freq.put("rri", 36);
    freq.put("rre", 54);
    freq.put("rra", 96);
    freq.put("sin\u0327", 49);
    freq.put("ugu", 553);
    freq.put("rac", 100);
    freq.put("meg", 22);
    freq.put("is\u030ck\u0327", 223);
    freq.put("tac\u030c", 123);
    freq.put("u\u0304na", 154);
    freq.put("apz", 415);
    freq.put("i\u0304c\u030ca", 67);
    freq.put("apr", 520);
    freq.put("aps", 483);
    freq.put("app", 36);
    freq.put("apv", 358);
    freq.put("Mik", 53);
    freq.put("apt", 349);
    freq.put("apu", 118);
    freq.put("apj", 56);
    freq.put("apk", 491);
    freq.put("aph", 30);
    freq.put("api", 222);
    freq.put("apo", 44);
    freq.put("apl", 157);
    freq.put("apm", 273);
    freq.put("apb", 88);
    freq.put("apa", 727);
    freq.put("edz\u030c", 46);
    freq.put("apg", 734);
    freq.put("apd", 220);
    freq.put("ape", 72);
    freq.put("fed", 168);
    freq.put("usd", 32);
    freq.put("feb", 35);
    freq.put("usa", 206);
    freq.put("fen", 84);
    freq.put("feo", 25);
    freq.put("fel", 37);
    freq.put("usl", 182);
    freq.put("usk", 104);
    freq.put("fek", 185);
    freq.put("usi", 609);
    freq.put("usv", 36);
    freq.put("usu", 107);
    freq.put("ust", 2158);
    freq.put("fer", 133);
    freq.put("fes", 176);
    freq.put("usz", 100);
    freq.put("edi\u0304", 123);
    freq.put("Gui", 25);
    freq.put("Gul", 51);
    freq.put("Gus", 31);
    freq.put(" \u041d ", 25);
    freq.put("e\u0304li\u0304", 53);
    freq.put("ap ", 332);
    freq.put(" Ru", 196);
    freq.put("eda\u0304", 218);
    freq.put("fe ", 34);
    freq.put("us ", 3775);
    freq.put("e\u0304le\u0304", 492);
    freq.put(" Re", 681);
    freq.put("ede\u0304", 86);
    freq.put(" Ra", 371);
    freq.put(" Ro", 565);
    freq.put(" Ri", 308);
    freq.put(" Rh", 25);
    freq.put("tat", 537);
    freq.put("tau", 931);
    freq.put("tav", 303);
    freq.put("tap", 52);
    freq.put("tar", 1920);
    freq.put("tas", 3364);
    freq.put("tad", 222);
    freq.put("taf", 30);
    freq.put("tag", 177);
    freq.put("tab", 171);
    freq.put("tac", 309);
    freq.put("tal", 256);
    freq.put("tam", 934);
    freq.put("tan", 395);
    freq.put("tai", 828);
    freq.put("taj", 702);
    freq.put("tak", 124);
    freq.put("sis", 1127);
    freq.put("sir", 69);
    freq.put("sip", 27);
    freq.put("sit", 335);
    freq.put("siz", 24);
    freq.put("sic", 34);
    freq.put("sib", 36);
    freq.put("sia", 56);
    freq.put("sig", 89);
    freq.put("sif", 65);
    freq.put("sie", 635);
    freq.put("sid", 107);
    freq.put("sik", 99);
    freq.put("sij", 423);
    freq.put("sih", 129);
    freq.put("sio", 148);
    freq.put("sin", 756);
    freq.put("sim", 594);
    freq.put("sil", 229);
    freq.put("Eko", 28);
    freq.put("pi\u0304t", 24);
    freq.put("ta ", 6165);
    freq.put("Eks", 36);
    freq.put("nds", 68);
    freq.put("s\u030cte", 79);
    freq.put("s\u030cta", 234);
    freq.put("ndu", 273);
    freq.put("si ", 826);
    freq.put("Ka\u0304", 157);
    freq.put("cto", 75);
    freq.put("Car", 39);
    freq.put("Cap", 22);
    freq.put("Cau", 23);
    freq.put("Can", 86);
    freq.put("Cam", 27);
    freq.put("Cal", 37);
    freq.put("Pre", 78);
    freq.put("nfe", 88);
    freq.put("Pra", 58);
    freq.put("nfo", 273);
    freq.put("Pro", 228);
    freq.put("nfl", 40);
    freq.put("Pri", 121);
    freq.put("nfi", 27);
    freq.put(" \u2212", 67);
    freq.put("nfr", 48);
    freq.put("oun", 55);
    freq.put("ha\u0304n", 110);
    freq.put("ous", 25);
    freq.put("our", 37);
    freq.put("ha\u0304r", 41);
    freq.put("out", 44);
    freq.put("lt ", 35);
    freq.put("lts", 217);
    freq.put("ltr", 29);
    freq.put("g", 29438);
    freq.put("a\u0304ga\u0304", 35);
    freq.put("vab", 47);
    freq.put("lta", 371);
    freq.put("lte", 188);
    freq.put("ltk", 80);
    freq.put("lti", 424);
    freq.put("lto", 53);
    freq.put("u\u0308", 91);
    freq.put("K ", 99);
    freq.put("Pra\u0304", 22);
    freq.put("Ame", 197);
    freq.put("vad", 1354);
    freq.put("ses", 362);
    freq.put("vos\u030c", 86);
    freq.put("lu\u0304k", 137);
    freq.put("lu\u0304g", 25);
    freq.put("lu\u0304d", 44);
    freq.put("lu\u0304c", 74);
    freq.put("lu\u0304z", 46);
    freq.put("\u03bb", 61);
    freq.put("lu\u0304s", 138);
    freq.put("lu\u0304p", 24);
    freq.put("Ka", 1308);
    freq.put("Ke", 175);
    freq.put("Ki", 234);
    freq.put("Ko", 785);
    freq.put("Kl", 267);
    freq.put("Kr", 1045);
    freq.put("Kv", 49);
    freq.put("Ku", 433);
    freq.put("c\u030cu", 562);
    freq.put("Pru\u0304", 54);
    freq.put("a\u0304go", 45);
    freq.put("pi\u0304g", 88);
    freq.put("lta\u0304", 300);
    freq.put("a\u0304gs", 41);
    freq.put("Ba\u0304", 56);
    freq.put("kne\u0304", 45);
    freq.put("hr", 242);
    freq.put("lti\u0304", 58);
    freq.put("a\u0304li", 1326);
    freq.put("Por", 59);
    freq.put("Pos", 25);
    freq.put("Pop", 24);
    freq.put("Pol", 274);
    freq.put("\u0430\u043b", 24);
    freq.put("ltu\u0304", 225);
    freq.put("a\u0304ld", 44);
    freq.put("hl", 97);
    freq.put("e\u0304na\u0304", 38);
    freq.put("hm", 55);
    freq.put("e\u0304ne\u0304", 31);
    freq.put("a\u0304la", 1215);
    freq.put("de\u0304s\u030c", 109);
    freq.put("ei\u0304n", 30);
    freq.put("ha", 893);
    freq.put("e\u0304s\u030ca", 752);
    freq.put("eat", 203);
    freq.put("lvu", 57);
    freq.put("de\u0304l\u0327", 202);
    freq.put("rpe\u0304", 106);
    freq.put("a\u0304lu", 633);
    freq.put("qu", 266);
    freq.put("pni\u0304", 27);
    freq.put("rpa\u0304", 40);
    freq.put(" ww", 36);
    freq.put("z\u030c", 4793);
    freq.put("ebe", 168);
    freq.put("eba", 49);
    freq.put("ebo", 22);
    freq.put(" Te\u0304", 78);
    freq.put("ebi", 87);
    freq.put("ebk", 175);
    freq.put("jo ", 387);
    freq.put("ebr", 247);
    freq.put("ebs", 44);
    freq.put(" Ta\u0304", 889);
    freq.put("ikv", 30);
    freq.put("l\u0327u ", 1814);
    freq.put("Jac", 27);
    freq.put(" Ti\u0304", 49);
    freq.put("jor", 71);
    freq.put("jos", 350);
    freq.put("jot", 574);
    freq.put(" \u0627\u0644", 23);
    freq.put("pzi\u0304", 361);
    freq.put("avi\u0304", 79);
    freq.put("jol", 22);
    freq.put("jom", 89);
    freq.put("jon", 751);
    freq.put("lvi", 41);
    freq.put("ika", 3320);
    freq.put("ave\u0304", 54);
    freq.put("l\u0327us", 125);
    freq.put("l\u0327uv", 123);
    freq.put("ava\u0304", 267);
    freq.put("rpp", 23);
    freq.put("rpr", 64);
    freq.put("rpu", 97);
    freq.put("rpt", 521);
    freq.put("de\u0304v", 144);
    freq.put("c\u030ci ", 69);
    freq.put("de\u0304t", 124);
    freq.put("bu\u0304s", 22);
    freq.put("de\u0304s", 22);
    freq.put("rpa", 43);
    freq.put("de\u0304l", 80);
    freq.put("de\u0304m", 188);
    freq.put("rpe", 30);
    freq.put("rpi", 90);
    freq.put("rpl", 24);
    freq.put("rpo", 72);
    freq.put("Jug", 32);
    freq.put("ikn", 25);
    freq.put("Jur", 42);
    freq.put("Jup", 83);
    freq.put("\u03bf", 116);
    freq.put("c\u030cie", 24);
    freq.put("Be\u0304r", 58);
    freq.put("rp ", 573);
    freq.put("hme", 29);
    freq.put("de\u0304 ", 186);
    freq.put("e\u0304ne", 214);
    freq.put("Ni\u0304d", 49);
    freq.put("e\u0304na", 102);
    freq.put("e\u0301", 81);
    freq.put("e\u0304ni", 174);
    freq.put("e\u0304nu", 91);
    freq.put("e\u0304ns", 137);
    freq.put("tja", 44);
    freq.put("avu", 357);
    freq.put("avv", 82);
    freq.put("avp", 76);
    freq.put("avr", 23);
    freq.put("avs", 157);
    freq.put("e\u0304", 27728);
    freq.put("avo", 299);
    freq.put("pzi", 58);
    freq.put("avi", 843);
    freq.put("ave", 232);
    freq.put("ava", 1146);
    freq.put("Zal\u0327", 27);
    freq.put("Vul", 29);
    freq.put("zvi", 325);
    freq.put("jos\u030c", 397);
    freq.put("C\u030cik", 22);
    freq.put("av ", 331);
    freq.put(" Tu", 361);
    freq.put(" Tr", 346);
    freq.put(" To", 521);
    freq.put(" Tj", 24);
    freq.put(" Ti", 329);
    freq.put(" Th", 177);
    freq.put("tju", 24);
    freq.put(" Te", 399);
    freq.put(" Ta", 1092);
    freq.put("lve\u0304", 725);
    freq.put("n\u0327em", 387);
    freq.put("van\u0327", 38);
    freq.put("en\u0327k\u0327", 69);
    freq.put("lva\u0304", 83);
    freq.put("tce", 25);
    freq.put("sku", 481);
    freq.put("sks", 400);
    freq.put("skr", 170);
    freq.put("I\u0304", 133);
    freq.put("ske", 410);
    freq.put("ska", 4650);
    freq.put("nor", 435);
    freq.put("sko", 1104);
    freq.put("ski", 1153);
    freq.put("ugs\u030c", 195);
    freq.put("Eir", 595);
    freq.put("T", 4509);
    freq.put("s\u030cze", 25);
    freq.put("sk ", 23);
    freq.put("val\u0327", 151);
    freq.put("kdi", 30);
    freq.put("Sul", 33);
    freq.put("S\u030ci\u0304 ", 93);
    freq.put("di\u0304t", 668);
    freq.put("nd ", 206);
    freq.put("di\u0304z", 28);
    freq.put("di\u0304g", 518);
    freq.put("di\u0304b", 475);
    freq.put("di\u0304c", 65);
    freq.put("di\u0304n", 38);
    freq.put("di\u0304j", 452);
    freq.put("z\u030cni", 23);
    freq.put("zve\u0304", 121);
    freq.put("ndi", 727);
    freq.put("ndo", 248);
    freq.put("nda", 780);
    freq.put("nde", 437);
    freq.put("l\u0327l\u0327u", 39);
    freq.put("ndz", 31);
    freq.put("l\u0327l\u0327a", 40);
    freq.put("ndr", 359);
    freq.put("Te\u0304r", 50);
    freq.put("Ru\u0304", 43);
    freq.put("owe", 22);
    freq.put("ows", 32);
    freq.put("ans\u030c", 45);
    freq.put("vaj", 267);
    freq.put("vak", 43);
    freq.put("vai", 3704);
    freq.put("van", 198);
    freq.put("val", 3215);
    freq.put("vam", 39);
    freq.put("Ama", 49);
    freq.put("g\u0327ij", 982);
    freq.put("g\u0327io", 352);
    freq.put("g\u0327in", 756);
    freq.put("g\u0327im", 77);
    freq.put("g\u0327is", 449);
    freq.put("g\u0327ip", 59);
    freq.put("lv ", 26);
    freq.put("g\u0327it", 52);
    freq.put("var", 1672);
    freq.put("vas", 1579);
    freq.put("vat", 135);
    freq.put("ef", 579);
    freq.put("en\u0327r", 134);
    freq.put("en\u0327u", 143);
    freq.put("en\u0327i", 138);
    freq.put("ska\u0304", 2459);
    freq.put("en\u0327o", 30);
    freq.put("en\u0327a", 350);
    freq.put("en\u0327b", 28);
    freq.put("en\u0327e", 150);
    freq.put("Teh", 22);
    freq.put("Tei", 33);
    freq.put("g\u0327i ", 28);
    freq.put("Tel", 43);
    freq.put("Tem", 25);
    freq.put("Teo", 25);
    freq.put("va ", 982);
    freq.put("Tec", 22);
    freq.put("dva", 54);
    freq.put("lve", 648);
    freq.put("lva", 502);
    freq.put("Ter", 125);
    freq.put("Tet", 23);
    freq.put("nda\u0304", 228);
    freq.put("S\u030ci\u0304s", 37);
    freq.put("nde\u0304", 98);
    freq.put("ndi\u0304", 35);
    freq.put("zva", 673);
    freq.put("zve", 584);
    freq.put("di\u0304s\u030c", 155);
    freq.put("\u043d", 271);
    freq.put("va\u0304 ", 578);
    freq.put("u\u0304s\u030ca", 102);
    freq.put("u\u0304s\u030cu", 22);
    freq.put("oel", 45);
    freq.put("ndz\u030c", 62);
  }
  
}

