package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class LT extends CLangProfile {
  private static final String name = "lt";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public LT() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 6266541;
    n_words[1] = 7160065;
    n_words[2] = 6094403;

    freq.put("i\u0328gy", 242);
    freq.put("i\u0328ga", 117);
    freq.put("ys\u030cu", 129);
    freq.put("IX ", 219);
    freq.put("ys\u030ci", 281);
    freq.put("ys\u030ck", 285);
    freq.put("i\u0328m", 672);
    freq.put("i\u0328l", 469);
    freq.put("i\u0328k", 1035);
    freq.put("i\u0328g", 465);
    freq.put("i\u0328e", 122);
    freq.put("i\u0328d", 140);
    freq.put("i\u0328v", 1510);
    freq.put("i\u0328t", 836);
    freq.put("i\u0328s", 2207);
    freq.put("i\u0328r", 905);
    freq.put("i\u0328p", 182);
    freq.put("lmu", 116);
    freq.put("nz\u030cu", 77);
    freq.put("k", 242084);
    freq.put("i\u0328 ", 15271);
    freq.put("Le\u0307", 71);
    freq.put(" yp", 378);
    freq.put(" yr", 9482);
    freq.put("up ", 104);
    freq.put("dni", 66);
    freq.put("Le", 2735);
    freq.put("vor", 253);
    freq.put("La", 2652);
    freq.put("Lo", 724);
    freq.put("Li", 7587);
    freq.put("Lu", 489);
    freq.put("\u56fd ", 82);
    freq.put("Ly", 250);
    freq.put("hon", 117);
    freq.put("hol", 535);
    freq.put("hom", 130);
    freq.put("hov", 154);
    freq.put("i\u0328z\u030c", 184);
    freq.put("hot", 89);
    freq.put("hor", 425);
    freq.put("hos", 152);
    freq.put("hop", 73);
    freq.put("A", 19441);
    freq.put("\u0645", 65);
    freq.put("L ", 366);
    freq.put("\u03bf\u03c2 ", 93);
    freq.put(" c\u030ce", 566);
    freq.put("ho ", 213);
    freq.put("u\u0304", 25506);
    freq.put(" c\u030ci", 215);
    freq.put("DP ", 99);
    freq.put(" V ", 128);
    freq.put("es\u030c ", 414);
    freq.put("zam", 101);
    freq.put("Hip", 99);
    freq.put("uop", 102);
    freq.put("fit", 88);
    freq.put("uot", 3875);
    freq.put("fiz", 526);
    freq.put("uoz", 64);
    freq.put("fic", 473);
    freq.put("uog", 115);
    freq.put("fig", 118);
    freq.put("uod", 1799);
    freq.put("fij", 466);
    freq.put("fik", 605);
    freq.put("fin", 1043);
    freq.put("Him", 100);
    freq.put("fil", 952);
    freq.put("uol", 1850);
    freq.put(" Va", 2931);
    freq.put("es\u030ck", 262);
    freq.put(" Ve", 1358);
    freq.put("es\u030co", 276);
    freq.put("upo", 164);
    freq.put(" Vi", 4303);
    freq.put("es\u030ce", 206);
    freq.put(" Vl", 71);
    freq.put(" Vo", 1248);
    freq.put(" Vy", 520);
    freq.put("es\u030cp", 103);
    freq.put("es\u030cu", 171);
    freq.put("es\u030ct", 271);
    freq.put("uo ", 11031);
    freq.put("mdi", 69);
    freq.put("mdo", 70);
    freq.put("lpe\u0307", 80);
    freq.put("uch", 229);
    freq.put("rt", 15475);
    freq.put("ru", 13317);
    freq.put("rv", 2004);
    freq.put("rp", 4617);
    freq.put("rr", 385);
    freq.put("rs", 5538);
    freq.put("smu", 706);
    freq.put("ry", 13171);
    freq.put("rz", 154);
    freq.put("rd", 4525);
    freq.put("re", 18683);
    freq.put("rf", 267);
    freq.put("rg", 5620);
    freq.put("ra", 68430);
    freq.put("rb", 9032);
    freq.put("rc", 1831);
    freq.put("rl", 1174);
    freq.put("rm", 7673);
    freq.put("rn", 3965);
    freq.put("ro", 31644);
    freq.put("rh", 115);
    freq.put("ri", 79105);
    freq.put("rj", 224);
    freq.put("rk", 4790);
    freq.put("Egi", 189);
    freq.put("atf", 194);
    freq.put("atg", 129);
    freq.put("ate", 2024);
    freq.put("ata", 3198);
    freq.put("atn", 97);
    freq.put("ato", 2724);
    freq.put("atl", 931);
    freq.put("atm", 389);
    freq.put("atk", 211);
    freq.put("ath", 131);
    freq.put("ati", 4429);
    freq.put("atv", 1480);
    freq.put("att", 75);
    freq.put("atu", 978);
    freq.put("r ", 33992);
    freq.put("ats", 3002);
    freq.put("atp", 71);
    freq.put("ds ", 126);
    freq.put("aty", 1953);
    freq.put("yin", 78);
    freq.put("Dun", 110);
    freq.put("Dub", 146);
    freq.put("u\u0304br", 365);
    freq.put("Dus", 63);
    freq.put("li\u0328 ", 872);
    freq.put("z\u030cli", 98);
    freq.put("Cen", 563);
    freq.put("uoz\u030c", 251);
    freq.put("uos\u030c", 293);
    freq.put("Cer", 118);
    freq.put(" Ve\u0307", 216);
    freq.put("uoc\u030c", 243);
    freq.put("Sof", 72);
    freq.put("i\u0301", 134);
    freq.put("nzi", 126);
    freq.put("nzo", 87);
    freq.put("ata\u0328", 166);
    freq.put("ate\u0307", 313);
    freq.put("e\u0307", 94567);
    freq.put("\u30a2", 227);
    freq.put("Asu", 66);
    freq.put("Ast", 264);
    freq.put("rz\u030c", 1586);
    freq.put("smu\u0328", 124);
    freq.put("c\u030ce\u0307", 116);
    freq.put("rs\u030c", 2441);
    freq.put("ru\u0304", 3551);
    freq.put("re\u0307", 10366);
    freq.put("sme\u0307", 297);
    freq.put("re\u0328", 1878);
    freq.put("ra\u0328", 1320);
    freq.put("rc\u030c", 361);
    freq.put("nek", 262);
    freq.put("ats\u030c", 113);
    freq.put("lpt", 73);
    freq.put("atu\u0304", 905);
    freq.put("lpo", 78);
    freq.put(" y ", 87);
    freq.put("atu\u0328", 809);
    freq.put("lpi", 224);
    freq.put("neg", 409);
    freq.put("atz\u030c", 107);
    freq.put("ri\u0328", 1236);
    freq.put("lpa", 143);
    freq.put("lo", 17284);
    freq.put("\u1100\u1161 ", 71);
    freq.put("I\u0328", 732);
    freq.put("X", 1264);
    freq.put("Je\u0307z", 95);
    freq.put("Rin", 77);
    freq.put("Rio", 84);
    freq.put("Rie", 98);
    freq.put("Rib", 131);
    freq.put("e\u0307pa", 71);
    freq.put("med", 2275);
    freq.put("meg", 289);
    freq.put("fu\u0328 ", 79);
    freq.put("iry", 540);
    freq.put("irp", 210);
    freq.put("irs", 602);
    freq.put("irt", 3182);
    freq.put("iru", 470);
    freq.put("irv", 355);
    freq.put("iri", 3779);
    freq.put("irk", 393);
    freq.put("irm", 1827);
    freq.put("irn", 109);
    freq.put("iro", 972);
    freq.put("ira", 1224);
    freq.put("irb", 684);
    freq.put("ird", 228);
    freq.put("ire", 616);
    freq.put("irg", 245);
    freq.put("cur", 66);
    freq.put("ir ", 24988);
    freq.put("pre", 1608);
    freq.put("a\u0328ra", 686);
    freq.put("s\u030cru", 91);
    freq.put("SR ", 568);
    freq.put("fri", 745);
    freq.put("fro", 133);
    freq.put("pro", 5447);
    freq.put("NR ", 79);
    freq.put("pru", 94);
    freq.put("anu", 591);
    freq.put("Din", 76);
    freq.put("bim", 181);
    freq.put("irz\u030c", 446);
    freq.put("iru\u0328", 76);
    freq.put("iru\u0304", 86);
    freq.put("irs\u030c", 1690);
    freq.put("\u0441", 408);
    freq.put("ire\u0328", 81);
    freq.put("ire\u0307", 261);
    freq.put("ira\u0328", 66);
    freq.put("mbu\u0304", 66);
    freq.put("aze\u0307", 203);
    freq.put("hai", 104);
    freq.put("haj", 70);
    freq.put("hal", 255);
    freq.put("ham", 166);
    freq.put("han", 534);
    freq.put("hab", 63);
    freq.put("had", 70);
    freq.put("bip", 90);
    freq.put("har", 550);
    freq.put("has", 169);
    freq.put("hat", 88);
    freq.put("hau", 98);
    freq.put("ha ", 309);
    freq.put("ola", 1063);
    freq.put("old", 223);
    freq.put("ole", 1072);
    freq.put("olf", 87);
    freq.put("olg", 102);
    freq.put("oli", 7420);
    freq.put("olk", 163);
    freq.put("oll", 172);
    freq.put("olm", 81);
    freq.put("oln", 64);
    freq.put("olo", 5241);
    freq.put("u\u0304dz\u030c", 157);
    freq.put("olt", 96);
    freq.put("olu", 523);
    freq.put("oly", 304);
    freq.put("AV ", 1248);
    freq.put("fot", 172);
    freq.put("ump", 675);
    freq.put("for", 3388);
    freq.put("fos", 117);
    freq.put("ume", 1015);
    freq.put("uma", 2535);
    freq.put("umb", 630);
    freq.put("fol", 145);
    freq.put("fon", 490);
    freq.put("umi", 565);
    freq.put("\u03bf\u03c2", 93);
    freq.put("Vyr", 158);
    freq.put("aus\u030c", 245);
    freq.put("lmu\u0328", 71);
    freq.put("Vyt", 150);
    freq.put("o", 414082);
    freq.put("fo ", 188);
    freq.put("um ", 371);
    freq.put("mbl", 299);
    freq.put("soc", 1068);
    freq.put("mbo", 656);
    freq.put("sod", 242);
    freq.put("sof", 371);
    freq.put("mbe", 160);
    freq.put("soj", 156);
    freq.put("som", 660);
    freq.put("sol", 244);
    freq.put("son", 563);
    freq.put("sop", 70);
    freq.put("sos", 1164);
    freq.put("sor", 222);
    freq.put("Fer", 122);
    freq.put("sot", 100);
    freq.put("sov", 81);
    freq.put("IV ", 137);
    freq.put("mbr", 361);
    freq.put("so ", 3418);
    freq.put("\u03c3", 88);
    freq.put("mb ", 104);
    freq.put("ku\u0304s", 84);
    freq.put("ku\u0304r", 1568);
    freq.put("ku\u0304n", 731);
    freq.put("ku\u0304g", 75);
    freq.put("azi", 1049);
    freq.put("azl", 78);
    freq.put("azm", 131);
    freq.put("azo", 425);
    freq.put("aza", 391);
    freq.put("azd", 314);
    freq.put("aze", 155);
    freq.put("azg", 73);
    freq.put("Sir", 117);
    freq.put("u\u0304do", 102);
    freq.put("u\u0304di", 671);
    freq.put("u\u0304da", 331);
    freq.put("Sic", 64);
    freq.put("Sib", 270);
    freq.put("olu\u0328", 162);
    freq.put("Sie", 159);
    freq.put("Sid", 156);
    freq.put("u\u0304du", 237);
    freq.put("Sin", 192);
    freq.put("Sim", 140);
    freq.put("Sil", 118);
    freq.put("umu\u0328", 278);
    freq.put("z\u030cba", 64);
    freq.put("e\u0328s ", 3114);
    freq.put("E", 5566);
    freq.put("\u30a2\u30a2", 188);
    freq.put("uma\u0328", 619);
    freq.put("ola\u0328", 105);
    freq.put("ole\u0307", 893);
    freq.put("ole\u0328", 89);
    freq.put("osp", 155);
    freq.put("oss", 88);
    freq.put("osu", 63);
    freq.put("ost", 1854);
    freq.put("osv", 137);
    freq.put("osi", 4557);
    freq.put("ipu\u0328", 79);
    freq.put("osk", 117);
    freq.put("osm", 327);
    freq.put("per", 4439);
    freq.put("oso", 811);
    freq.put("osn", 165);
    freq.put("osa", 489);
    freq.put("pes", 135);
    freq.put("ose", 10057);
    freq.put("osf", 255);
    freq.put("vet", 199);
    freq.put("ver", 3346);
    freq.put("ves", 601);
    freq.put("veg", 178);
    freq.put("ved", 568);
    freq.put("ven", 4988);
    freq.put("vel", 635);
    freq.put("vej", 358);
    freq.put("vek", 95);
    freq.put("vei", 3674);
    freq.put("os ", 71850);
    freq.put("Tau", 535);
    freq.put("Tar", 749);
    freq.put("Tad", 89);
    freq.put("ipe\u0307", 458);
    freq.put("ve ", 425);
    freq.put("Tal", 105);
    freq.put("Tam", 147);
    freq.put("Tan", 110);
    freq.put("Tai", 1790);
    freq.put("Tak", 96);
    freq.put("se\u0328", 282);
    freq.put("M ", 415);
    freq.put("se\u0307", 3998);
    freq.put("sc\u030c", 2453);
    freq.put("sa\u0328", 2757);
    freq.put("si\u0328", 230);
    freq.put("zra", 92);
    freq.put("Me", 1902);
    freq.put("ydo", 238);
    freq.put("Ma", 4741);
    freq.put("e\u0307ra", 344);
    freq.put("Mo", 1998);
    freq.put("yde", 256);
    freq.put("Mi", 1792);
    freq.put("e\u0307ri", 244);
    freq.put("Mu", 533);
    freq.put("O", 2898);
    freq.put("ydy", 152);
    freq.put("My", 151);
    freq.put("ugi", 2043);
    freq.put("su\u0328", 1592);
    freq.put("su\u0304", 452);
    freq.put("ipa", 679);
    freq.put("ipe", 332);
    freq.put("ipi", 440);
    freq.put("ipo", 522);
    freq.put("ipl", 309);
    freq.put("ipr", 458);
    freq.put("ips", 676);
    freq.put("ipt", 461);
    freq.put("ipu", 252);
    freq.put("yga", 678);
    freq.put("vez\u030c", 182);
    freq.put("ip ", 3767);
    freq.put("ygl", 225);
    freq.put("ygi", 962);
    freq.put("u\u0304g", 553);
    freq.put("ygu", 328);
    freq.put("ose\u0307", 119);
    freq.put("u\u0304k", 1535);
    freq.put("ydi\u0328", 315);
    freq.put("gzi", 495);
    freq.put("Ost", 83);
    freq.put(" pv", 390);
    freq.put("Me\u0307", 156);
    freq.put("s ", 278368);
    freq.put(" px", 100);
    freq.put("Mu\u0304", 111);
    freq.put("ydz\u030c", 370);
    freq.put("ydu\u0328", 119);
    freq.put("sz", 67);
    freq.put("sy", 1283);
    freq.put("ss", 694);
    freq.put("sr", 2349);
    freq.put("sp", 7479);
    freq.put("sv", 2479);
    freq.put("su", 18269);
    freq.put("st", 45024);
    freq.put("sk", 13287);
    freq.put("sj", 177);
    freq.put("si", 47811);
    freq.put("sh", 403);
    freq.put("so", 8499);
    freq.put("sn", 3503);
    freq.put("sm", 4814);
    freq.put("sl", 4978);
    freq.put("sc", 661);
    freq.put("sb", 164);
    freq.put("sa", 23030);
    freq.put("sf", 460);
    freq.put("se", 19656);
    freq.put("sd", 318);
    freq.put("ons\u030c", 70);
    freq.put("\u044f ", 102);
    freq.put("dyd", 692);
    freq.put("ia\u0328j", 181);
    freq.put("onu\u0328", 1034);
    freq.put("nes\u030c", 331);
    freq.put("tte", 91);
    freq.put("nez\u030c", 127);
    freq.put("jie", 392);
    freq.put("s\u030ca ", 145);
    freq.put("jin", 736);
    freq.put("jim", 2557);
    freq.put("uku\u0328", 215);
    freq.put("uku\u0304", 174);
    freq.put("jis", 383);
    freq.put("uks\u030c", 4009);
    freq.put("Z\u030cu", 122);
    freq.put("Ac", 198);
    freq.put("Z\u030cv", 178);
    freq.put("uke\u0307", 207);
    freq.put("Z\u030cy", 116);
    freq.put("Z\u030ce", 955);
    freq.put("Z\u030ca", 482);
    freq.put("Z\u030cm", 91);
    freq.put("ia\u0328 ", 1321);
    freq.put("uka\u0328", 82);
    freq.put("tt ", 65);
    freq.put("Z\u030ci", 399);
    freq.put("s\u030cac", 68);
    freq.put("s\u030cam", 125);
    freq.put("s\u030cal", 2584);
    freq.put("s\u030can", 259);
    freq.put("s\u030cai", 175);
    freq.put("s\u030cak", 893);
    freq.put("ona\u0328", 313);
    freq.put("s\u030cau", 451);
    freq.put("s\u030cas", 283);
    freq.put("s\u030car", 241);
    freq.put("one\u0307", 1445);
    freq.put("Z\u030cem", 792);
    freq.put("Jos", 270);
    freq.put("nsu", 225);
    freq.put("blo", 199);
    freq.put("bli", 2467);
    freq.put("ble", 254);
    freq.put("ps\u030ci", 366);
    freq.put("bla", 154);
    freq.put("Jon", 566);
    freq.put("Jo ", 148);
    freq.put("onk", 450);
    freq.put("oni", 5683);
    freq.put("ono", 5947);
    freq.put("onc", 437);
    freq.put("ona", 5705);
    freq.put("onf", 314);
    freq.put("ong", 677);
    freq.put("ond", 604);
    freq.put("one", 3050);
    freq.put("onz", 95);
    freq.put("ony", 229);
    freq.put("ons", 941);
    freq.put("onv", 131);
    freq.put("ont", 1350);
    freq.put("onu", 771);
    freq.put("uku", 1424);
    freq.put("ukt", 1044);
    freq.put("uks", 488);
    freq.put("ukr", 338);
    freq.put("uko", 768);
    freq.put("ukm", 63);
    freq.put("ukl", 276);
    freq.put("uki", 835);
    freq.put("uke", 516);
    freq.put("ukc", 193);
    freq.put("uka", 1363);
    freq.put(" Zo", 73);
    freq.put(" Zi", 68);
    freq.put(" Ze", 220);
    freq.put("on ", 1119);
    freq.put(" Za", 514);
    freq.put("AT ", 96);
    freq.put("rma", 2602);
    freq.put("sak", 1089);
    freq.put("saj", 93);
    freq.put("sai", 543);
    freq.put("san", 3811);
    freq.put("sam", 580);
    freq.put("sal", 3421);
    freq.put("sac", 151);
    freq.put("sag", 124);
    freq.put("sad", 119);
    freq.put("sas", 1914);
    freq.put("sar", 840);
    freq.put("sap", 78);
    freq.put("sav", 6083);
    freq.put("sau", 3166);
    freq.put("sat", 201);
    freq.put("zol", 127);
    freq.put("zon", 766);
    freq.put("zos", 160);
    freq.put("zot", 82);
    freq.put("sa ", 609);
    freq.put("zo ", 283);
    freq.put("Sku", 184);
    freq.put("Skr", 105);
    freq.put("Sky", 69);
    freq.put("Ska", 362);
    freq.put("Ski", 160);
    freq.put("XI ", 73);
    freq.put("sdi", 133);
    freq.put("ux", 118);
    freq.put("uz", 1745);
    freq.put("Tim", 101);
    freq.put(" s\u030ci\u0328", 69);
    freq.put("ut", 11996);
    freq.put("up", 8302);
    freq.put("ivu\u0328", 75);
    freq.put("cil", 163);
    freq.put("um", 9287);
    freq.put("ul", 12572);
    freq.put("un", 10381);
    freq.put("vka", 106);
    freq.put("uh", 117);
    freq.put("fir", 67);
    freq.put("Ryg", 105);
    freq.put("uj", 5784);
    freq.put("ue ", 115);
    freq.put(" be", 6829);
    freq.put(" ba", 4469);
    freq.put(" bl", 292);
    freq.put(" bo", 424);
    freq.put(" bi", 992);
    freq.put(" bu", 4118);
    freq.put("s", 495974);
    freq.put("ive\u0307", 295);
    freq.put("alu\u0328", 2328);
    freq.put(" br", 918);
    freq.put(" by", 148);
    freq.put("Tin", 67);
    freq.put(" s\u030ca", 3536);
    freq.put(" s\u030ce", 4400);
    freq.put("uob", 148);
    freq.put(" s\u030ci", 9378);
    freq.put(" s\u030cl", 369);
    freq.put(" s\u030co", 352);
    freq.put(" s\u030ct", 72);
    freq.put(" s\u030cu", 230);
    freq.put(" s\u030cv", 1206);
    freq.put("De\u0307l", 85);
    freq.put("yvu\u0304", 473);
    freq.put("lu\u0328 ", 4053);
    freq.put("uok", 472);
    freq.put("yzd", 234);
    freq.put("uoj", 2916);
    freq.put("uon", 468);
    freq.put("uom", 2229);
    freq.put("ive", 1142);
    freq.put("iva", 5713);
    freq.put("ivo", 225);
    freq.put("ivi", 1601);
    freq.put("ivu", 89);
    freq.put(" be\u0307", 99);
    freq.put("es\u030cm", 321);
    freq.put("ivy", 313);
    freq.put("Jo", 1434);
    freq.put("es\u030ca", 283);
    freq.put("Nyd", 143);
    freq.put("XV ", 71);
    freq.put("I", 6943);
    freq.put("ja\u0328 ", 2223);
    freq.put(" gu", 260);
    freq.put("Mau", 95);
    freq.put(" bu\u0304", 2814);
    freq.put("u\u0328", 90375);
    freq.put("gdy", 714);
    freq.put("gda", 73);
    freq.put("gdo", 74);
    freq.put("zu\u0328 ", 230);
    freq.put("Mah", 72);
    freq.put("Mak", 226);
    freq.put("Man", 463);
    freq.put("as\u030c", 6163);
    freq.put("tvy", 70);
    freq.put("ezu", 126);
    freq.put("ezo", 319);
    freq.put("tvi", 1569);
    freq.put("ezi", 795);
    freq.put("tve", 795);
    freq.put("eze", 135);
    freq.put("tva", 1876);
    freq.put("eza", 64);
    freq.put("az\u030c", 6015);
    freq.put(" z\u030cy", 592);
    freq.put("ac ", 144);
    freq.put(" z\u030cu", 959);
    freq.put("uik", 63);
    freq.put(" z\u030cv", 1024);
    freq.put(" z\u030ci", 2342);
    freq.put(" z\u030cm", 1523);
    freq.put(" z\u030co", 907);
    freq.put(" z\u030ca", 1939);
    freq.put(" z\u030ce", 2052);
    freq.put("aca", 72);
    freq.put("ace", 1807);
    freq.put("ack", 137);
    freq.put("aci", 7737);
    freq.put("ach", 900);
    freq.put("ac\u030c", 2434);
    freq.put("cu\u0328 ", 73);
    freq.put("s\u030cga", 146);
    freq.put("ae\u0307", 112);
    freq.put("act", 213);
    freq.put("Ni", 720);
    freq.put("bje", 1237);
    freq.put("No", 779);
    freq.put("uil", 83);
    freq.put("Na", 1866);
    freq.put("Dni", 78);
    freq.put("Ne", 1803);
    freq.put("Ny", 218);
    freq.put("Nr", 561);
    freq.put("Nu", 901);
    freq.put("het", 95);
    freq.put("hev", 142);
    freq.put("her", 871);
    freq.put("hes", 72);
    freq.put("\u0432", 327);
    freq.put("hel", 177);
    freq.put("hem", 647);
    freq.put("hen", 157);
    freq.put("heo", 356);
    freq.put("hei", 83);
    freq.put("N ", 208);
    freq.put("agm", 87);
    freq.put("C\u030cek", 141);
    freq.put("C\u030cer", 143);
    freq.put("he ", 653);
    freq.put("aa", 279);
    freq.put("ac", 11205);
    freq.put("ab", 6312);
    freq.put("ae", 3599);
    freq.put("ad", 17624);
    freq.put("ag", 11672);
    freq.put("af", 1358);
    freq.put("ai", 71518);
    freq.put("ah", 654);
    freq.put("Hol", 87);
    freq.put("Hom", 79);
    freq.put("am", 34880);
    freq.put("al", 70175);
    freq.put("ao", 400);
    freq.put("an", 55907);
    freq.put("ap", 19804);
    freq.put("as", 91731);
    freq.put("ar", 60917);
    freq.put("Hor", 71);
    freq.put("at", 26947);
    freq.put("aw", 113);
    freq.put("av", 20318);
    freq.put("ay", 393);
    freq.put("ax", 94);
    freq.put("az", 2975);
    freq.put("a ", 85927);
    freq.put("z\u030cei", 363);
    freq.put("s\u030cka", 2905);
    freq.put("du\u0304r", 138);
    freq.put("at ", 1471);
    freq.put("tve\u0307", 152);
    freq.put("eze\u0307", 113);
    freq.put("u\u0304z\u030c", 93);
    freq.put("uit", 183);
    freq.put("kla\u0328", 309);
    freq.put("vis\u030c", 606);
    freq.put("sci", 144);
    freq.put("sch", 242);
    freq.put("sce", 120);
    freq.put("viu\u0328", 2220);
    freq.put("kle\u0307", 428);
    freq.put(" de\u0307", 1157);
    freq.put(" Du\u0304", 73);
    freq.put("Fin", 83);
    freq.put("Fil", 257);
    freq.put("smo", 495);
    freq.put("tz", 73);
    freq.put("zmo", 623);
    freq.put("ty", 13326);
    freq.put("tv", 4512);
    freq.put("tw", 77);
    freq.put("tt", 447);
    freq.put("tu", 28297);
    freq.put("tr", 20341);
    freq.put("ts", 3686);
    freq.put("tp", 243);
    freq.put("zme", 95);
    freq.put("tn", 718);
    freq.put("to", 36142);
    freq.put("tl", 1570);
    freq.put("tm", 1109);
    freq.put("tj", 104);
    freq.put("tk", 518);
    freq.put("th", 1088);
    freq.put("ti", 64800);
    freq.put("tf", 256);
    freq.put("tg", 277);
    freq.put("te", 29101);
    freq.put("tb", 1204);
    freq.put("tc", 76);
    freq.put("ta", 61331);
    freq.put("smi", 538);
    freq.put("sme", 1637);
    freq.put(" s", 59667);
    freq.put("vic\u030c", 254);
    freq.put(" dz\u030c", 138);
    freq.put("sma", 829);
    freq.put("klu\u0328", 780);
    freq.put("t ", 8619);
    freq.put(" w", 140);
    freq.put("z\u030cy", 1527);
    freq.put("z\u030cp", 171);
    freq.put("z\u030cr", 232);
    freq.put("z\u030cs", 417);
    freq.put("z\u030ct", 693);
    freq.put("z\u030cu", 2236);
    freq.put("z\u030cv", 1312);
    freq.put("z\u030ci", 16869);
    freq.put("z\u030ck", 289);
    freq.put("z\u030cl", 158);
    freq.put("z\u030cm", 1670);
    freq.put("Smi", 70);
    freq.put("z\u030co", 2063);
    freq.put("z\u030ca", 3699);
    freq.put("z\u030cb", 100);
    freq.put("z\u030cd", 1624);
    freq.put("z\u030ce", 6838);
    freq.put("Sma", 84);
    freq.put("\u4e09\u4e09", 72);
    freq.put("z\u030c ", 1080);
    freq.put("e\u0307c\u030ci", 63);
    freq.put("vic", 102);
    freq.put("via", 688);
    freq.put("vig", 137);
    freq.put("Aug", 852);
    freq.put("vie", 10516);
    freq.put("vij", 1156);
    freq.put("vik", 248);
    freq.put("Auk", 724);
    freq.put("vin", 4831);
    freq.put("vio", 508);
    freq.put("vil", 1104);
    freq.put("vim", 2439);
    freq.put("vir", 3137);
    freq.put("vis", 3495);
    freq.put("Aus", 646);
    freq.put("viv", 2783);
    freq.put("Aut", 259);
    freq.put("vit", 264);
    freq.put("viu", 186);
    freq.put("viz", 527);
    freq.put("tz\u030c", 178);
    freq.put("tu\u0328", 12691);
    freq.put(" d ", 1323);
    freq.put("tu\u0304", 4346);
    freq.put("zmu\u0328", 92);
    freq.put("ts\u030c", 139);
    freq.put("vi ", 818);
    freq.put("te\u0328", 1071);
    freq.put("te\u0307", 5769);
    freq.put("zma\u0328", 73);
    freq.put("ta\u0328", 2285);
    freq.put(" do", 606);
    freq.put("kle", 472);
    freq.put("kla", 7712);
    freq.put(" di", 7861);
    freq.put(" de", 4787);
    freq.put("klo", 1474);
    freq.put("kli", 2387);
    freq.put(" da", 11917);
    freq.put("klu", 945);
    freq.put(" dy", 1060);
    freq.put(" dv", 1810);
    freq.put(" du", 1631);
    freq.put(" dr", 1386);
    freq.put("z\u030cu\u0328", 376);
    freq.put("RS ", 294);
    freq.put("iu\u0304 ", 112);
    freq.put("Ru\u0304d", 99);
    freq.put("tsi", 864);
    freq.put("atr", 904);
    freq.put("iu\u0304r", 499);
    freq.put("iu\u0304t", 153);
    freq.put("z\u030ci\u0328", 113);
    freq.put("iu\u0304n", 1343);
    freq.put("iu\u0304l", 184);
    freq.put("z\u030ce\u0307", 568);
    freq.put("z\u030ca\u0328", 94);
    freq.put("itn", 63);
    freq.put("ito", 5645);
    freq.put("itm", 290);
    freq.put("itk", 77);
    freq.put("ith", 115);
    freq.put("iti", 4567);
    freq.put("ite", 2150);
    freq.put("ita", 3101);
    freq.put("ity", 2401);
    freq.put("itv", 127);
    freq.put("itt", 74);
    freq.put("itu", 2883);
    freq.put("itr", 489);
    freq.put("it ", 169);
    freq.put("s\u030ces\u030c", 251);
    freq.put(" A ", 384);
    freq.put("fto", 75);
    freq.put(" Ab", 408);
    freq.put(" Ac", 198);
    freq.put(" Ad", 550);
    freq.put(" Af", 804);
    freq.put(" Ag", 281);
    freq.put(" Ai", 520);
    freq.put(" Aj", 72);
    freq.put(" Ak", 583);
    freq.put(" Al", 1977);
    freq.put(" Am", 1804);
    freq.put(" An", 2616);
    freq.put(" Ap", 776);
    freq.put(" Ar", 1939);
    freq.put(" As", 629);
    freq.put(" At", 910);
    freq.put(" Au", 2682);
    freq.put(" Av", 213);
    freq.put(" Az", 731);
    freq.put("ft ", 191);
    freq.put("w", 1450);
    freq.put("Fra", 186);
    freq.put("\u043e\u043b", 71);
    freq.put("Fre", 105);
    freq.put("uel", 163);
    freq.put("\u043e\u0432", 122);
    freq.put("C\u030c", 1561);
    freq.put("itu\u0328", 1031);
    freq.put("jer", 295);
    freq.put("jev", 166);
    freq.put("jet", 69);
    freq.put("s\u030ce ", 72);
    freq.put("jek", 1582);
    freq.put("jei", 143);
    freq.put("jen", 63);
    freq.put("iti\u0328", 88);
    freq.put("\u3042", 83);
    freq.put("Iz", 149);
    freq.put("s\u030cer", 281);
    freq.put("ita\u0328", 217);
    freq.put("je ", 35197);
    freq.put("ite\u0328", 494);
    freq.put("s\u030cei", 4330);
    freq.put("ite\u0307", 412);
    freq.put("s\u030cel", 123);
    freq.put("e\u0307ni", 505);
    freq.put("e\u0307no", 201);
    freq.put("a\u0328st", 536);
    freq.put("tp ", 76);
    freq.put("uer", 154);
    freq.put(" As\u030c", 111);
    freq.put("In", 1584);
    freq.put("M", 12432);
    freq.put("Isl", 135);
    freq.put("e\u0307ny", 160);
    freq.put("tpa", 67);
    freq.put("nu\u0328j", 77);
    freq.put("oju", 555);
    freq.put("Hal", 105);
    freq.put("Ham", 121);
    freq.put("Han", 93);
    freq.put("ugl", 79);
    freq.put("uga", 3449);
    freq.put("uge", 478);
    freq.put("ugd", 727);
    freq.put("ugy", 234);
    freq.put("oje", 21105);
    freq.put("oja", 6655);
    freq.put("ugs", 210);
    freq.put("ojo", 4241);
    freq.put("Har", 160);
    freq.put("ugp", 256);
    freq.put("ugv", 81);
    freq.put("Hav", 88);
    freq.put("oji", 3887);
    freq.put("mu\u0304g", 65);
    freq.put("z\u030cdz\u030c", 217);
    freq.put("Gyv", 237);
    freq.put("mu\u0304s", 116);
    freq.put("mu\u0304r", 92);
    freq.put("\u093e", 68);
    freq.put("C\u030ce", 428);
    freq.put("C\u030ca", 214);
    freq.put("nu\u0328 ", 7207);
    freq.put("ug ", 571);
    freq.put("z\u030cde\u0307", 292);
    freq.put("C\u030ci", 814);
    freq.put("oj ", 68);
    freq.put("rfi", 80);
    freq.put("rfo", 87);
    freq.put("cro", 177);
    freq.put("c\u030ce", 803);
    freq.put("seu", 67);
    freq.put("set", 159);
    freq.put("ses", 253);
    freq.put("ser", 955);
    freq.put("For", 525);
    freq.put("sep", 203);
    freq.put("c\u030co", 121);
    freq.put("c\u030ci", 21375);
    freq.put("sez", 169);
    freq.put("c\u030ck", 154);
    freq.put("c\u030cu", 90);
    freq.put("sed", 68);
    freq.put("e\u0307 ", 26547);
    freq.put("sen", 3202);
    freq.put("sem", 199);
    freq.put("sel", 216);
    freq.put("sek", 790);
    freq.put("sei", 720);
    freq.put("tiz", 264);
    freq.put("bu\u0304d", 1044);
    freq.put("c\u030c ", 409);
    freq.put("bu\u0304n", 290);
    freq.put("bu\u0304k", 89);
    freq.put("bu\u0304t", 996);
    freq.put("bu\u0304r", 626);
    freq.put("se ", 12437);
    freq.put("pdo", 296);
    freq.put("oju\u0328", 757);
    freq.put(" pr", 18161);
    freq.put("tiu", 112);
    freq.put("ugu\u0328", 171);
    freq.put("z\u030cdy", 272);
    freq.put("mu\u0304s\u030c", 172);
    freq.put("z\u030cdu", 70);
    freq.put("tiv", 191);
    freq.put("z\u030cdi", 76);
    freq.put("Ku\u0304n", 234);
    freq.put("z\u030cda", 511);
    freq.put("z\u030cde", 109);
    freq.put("nri", 70);
    freq.put("nro", 72);
    freq.put("ty ", 191);
    freq.put("nra", 165);
    freq.put("oje\u0307", 85);
    freq.put("Oli", 102);
    freq.put("mln", 124);
    freq.put("uge\u0328", 74);
    freq.put("uge\u0307", 81);
    freq.put("vol", 423);
    freq.put("von", 160);
    freq.put("voj", 2810);
    freq.put("vok", 960);
    freq.put("vot", 192);
    freq.put("c\u030cu\u0328", 69);
    freq.put("vos", 5796);
    freq.put("amm", 86);
    freq.put("psa", 387);
    freq.put("vo ", 7394);
    freq.put("loc\u030c", 162);
    freq.put("Soc", 156);
    freq.put(" fr", 209);
    freq.put(" fu", 1594);
    freq.put("kni", 155);
    freq.put("Sok", 963);
    freq.put("ru\u0328", 3959);
    freq.put("Sol", 99);
    freq.put("Son", 84);
    freq.put(" fa", 728);
    freq.put("Sos", 108);
    freq.put(" fe", 604);
    freq.put("kny", 405);
    freq.put(" fi", 1973);
    freq.put(" fl", 132);
    freq.put(" fo", 1905);
    freq.put("O ", 471);
    freq.put("uc\u030c", 735);
    freq.put(" \u4e4b", 78);
    freq.put("se\u0307 ", 786);
    freq.put("On", 141);
    freq.put("Om", 89);
    freq.put("Ol", 265);
    freq.put("Ok", 221);
    freq.put("Of", 81);
    freq.put("Od", 117);
    freq.put("Oc", 104);
    freq.put("Ob", 214);
    freq.put("Ot", 63);
    freq.put("Os", 252);
    freq.put("Or", 562);
    freq.put("Op", 146);
    freq.put("cis\u030c", 133);
    freq.put("uz\u030c", 4062);
    freq.put("d", 143421);
    freq.put(" \u4e09", 86);
    freq.put("us\u030c", 1079);
    freq.put("ii ", 82);
    freq.put("b ", 435);
    freq.put("iju", 808);
    freq.put("s\u030cke\u0307", 457);
    freq.put("ija", 13519);
    freq.put("ije", 95);
    freq.put("age\u0307", 263);
    freq.put("iji", 627);
    freq.put("Vel", 220);
    freq.put("s\u030cka\u0328", 187);
    freq.put("ijo", 29798);
    freq.put("u\u0304 ", 138);
    freq.put(" Z\u030c", 2446);
    freq.put("bd", 129);
    freq.put("be", 9419);
    freq.put("ba", 18685);
    freq.put("bl", 3193);
    freq.put("bn", 67);
    freq.put("bo", 6948);
    freq.put("bi", 8863);
    freq.put("bj", 1259);
    freq.put("bt", 432);
    freq.put("bu", 7186);
    freq.put("br", 2910);
    freq.put("bs", 381);
    freq.put("by", 382);
    freq.put("bz", 182);
    freq.put("Fu", 220);
    freq.put("u\u0304b", 446);
    freq.put("agu\u0304", 453);
    freq.put("u\u0304d", 1733);
    freq.put("s\u030cku\u0328", 474);
    freq.put("u\u0304n", 4467);
    freq.put("u\u0304m", 598);
    freq.put("u\u0304l", 283);
    freq.put("u\u0304s", 1429);
    freq.put("u\u0304r", 9049);
    freq.put("u\u0304p", 172);
    freq.put("u\u0304v", 180);
    freq.put("u\u0304t", 1461);
    freq.put("u\u0304z", 1060);
    freq.put("agu\u0328", 187);
    freq.put(" C ", 148);
    freq.put("\u043e ", 63);
    freq.put("u ", 18088);
    freq.put("Fe", 543);
    freq.put(" Ch", 1252);
    freq.put(" Ci", 314);
    freq.put(" Co", 818);
    freq.put(" Cl", 153);
    freq.put(" Ca", 760);
    freq.put(" Ce", 856);
    freq.put(" Cy", 71);
    freq.put(" Cr", 197);
    freq.put(" Cu", 130);
    freq.put("cia", 2358);
    freq.put("cif", 247);
    freq.put("cie", 95);
    freq.put("I\u0328ei", 85);
    freq.put("cik", 433);
    freq.put("cij", 9068);
    freq.put("uv", 14825);
    freq.put("cio", 1497);
    freq.put("cin", 3236);
    freq.put("us", 51555);
    freq.put("ur", 34041);
    freq.put("cis", 123);
    freq.put("dob", 88);
    freq.put("uo", 35316);
    freq.put("cip", 355);
    freq.put("ui", 3816);
    freq.put("civ", 350);
    freq.put("uk", 12269);
    freq.put("cit", 220);
    freq.put("ue", 864);
    freq.put("ud", 10289);
    freq.put("ug", 10980);
    freq.put("uf", 303);
    freq.put("ua", 1611);
    freq.put("uc", 1769);
    freq.put("ub", 4404);
    freq.put("iju\u0328", 2456);
    freq.put("u\u0304c\u030c", 245);
    freq.put("iju\u0304", 154);
    freq.put("ba\u0328", 398);
    freq.put("lpn", 97);
    freq.put("be\u0307", 6516);
    freq.put("be\u0328", 413);
    freq.put("bu\u0304", 3463);
    freq.put("bu\u0328", 1576);
    freq.put("Sa\u0328j", 308);
    freq.put("ago", 977);
    freq.put("agn", 741);
    freq.put("u\u0304s\u030c", 2032);
    freq.put("agl", 74);
    freq.put("agi", 657);
    freq.put("ije\u0328", 103);
    freq.put("age", 494);
    freq.put("s\u030cku", 531);
    freq.put("s\u030cki", 3659);
    freq.put("s\u030cko", 2173);
    freq.put("ija\u0328", 1411);
    freq.put("agy", 177);
    freq.put("agv", 331);
    freq.put("agu", 296);
    freq.put("agr", 3158);
    freq.put("s\u030cke", 337);
    freq.put("Jie", 135);
    freq.put("Jis", 502);
    freq.put("z\u030cym", 728);
    freq.put("z\u030cyb", 321);
    freq.put("tr ", 100);
    freq.put("z\u030cyg", 68);
    freq.put("z\u030cyd", 166);
    freq.put("e\u0307ge\u0307", 107);
    freq.put(" Wo", 146);
    freq.put("z\u030cys", 63);
    freq.put("Ji ", 425);
    freq.put("gs\u030ct", 167);
    freq.put(" e\u0307j", 280);
    freq.put("e\u0307gu\u0328", 151);
    freq.put("tri", 3774);
    freq.put("evi", 699);
    freq.put("tro", 4397);
    freq.put("evo", 715);
    freq.put("tra", 6670);
    freq.put("eva", 902);
    freq.put("f", 17928);
    freq.put("tre", 865);
    freq.put("eve", 542);
    freq.put("try", 1680);
    freq.put("evy", 281);
    freq.put("evr", 154);
    freq.put("tru", 2118);
    freq.put("le ", 987);
    freq.put("ody", 417);
    freq.put("uen", 154);
    freq.put("uei", 67);
    freq.put("odr", 68);
    freq.put("odu", 589);
    freq.put("odi", 1127);
    freq.put("odk", 163);
    freq.put("odo", 1175);
    freq.put("oda", 2306);
    freq.put("Bla", 117);
    freq.put("ode", 1122);
    freq.put("odg", 104);
    freq.put("rd ", 418);
    freq.put("lec", 77);
    freq.put("led", 360);
    freq.put("lef", 117);
    freq.put("leg", 368);
    freq.put("lei", 2618);
    freq.put("lek", 1990);
    freq.put("lel", 445);
    freq.put("lem", 868);
    freq.put("len", 3529);
    freq.put("leo", 285);
    freq.put("lep", 84);
    freq.put("ler", 662);
    freq.put("les", 733);
    freq.put("let", 811);
    freq.put("leu", 86);
    freq.put("lev", 356);
    freq.put("od ", 72);
    freq.put("lez", 63);
    freq.put("rdu", 515);
    freq.put("rdv", 219);
    freq.put("rds", 64);
    freq.put("z\u030ci\u0328s", 104);
    freq.put("rde", 192);
    freq.put("rda", 868);
    freq.put("cta", 124);
    freq.put("rdo", 569);
    freq.put("cto", 80);
    freq.put("rdi", 1074);
    freq.put("cti", 127);
    freq.put("tra\u0328", 137);
    freq.put("Ukr", 322);
    freq.put("Ukm", 131);
    freq.put("tre\u0307", 213);
    freq.put("eve\u0307", 459);
    freq.put("zit", 198);
    freq.put("zis", 547);
    freq.put("zid", 291);
    freq.put("zie", 245);
    freq.put("zic", 125);
    freq.put("zia", 212);
    freq.put("zin", 555);
    freq.put("zio", 150);
    freq.put("zil", 400);
    freq.put("zij", 2812);
    freq.put("zik", 1298);
    freq.put("\u043e", 721);
    freq.put("e\u0307ga", 161);
    freq.put("e\u0307go", 219);
    freq.put("e\u0307gi", 261);
    freq.put("tru\u0304", 89);
    freq.put("ku\u0328 ", 5583);
    freq.put("tru\u0328", 261);
    freq.put("evu\u0328", 124);
    freq.put("rde\u0307", 104);
    freq.put("vz ", 411);
    freq.put("odz\u030c", 830);
    freq.put("odu\u0328", 160);
    freq.put("rda\u0328", 70);
    freq.put("\u03bc", 79);
    freq.put("Q", 106);
    freq.put("lez\u030c", 588);
    freq.put("rdu\u0328", 72);
    freq.put("rdz\u030c", 190);
    freq.put("ode\u0307", 378);
    freq.put("oda\u0328", 88);
    freq.put("VI ", 165);
    freq.put("Sak", 119);
    freq.put("Yr", 183);
    freq.put("San", 807);
    freq.put("Sam", 191);
    freq.put("Sal", 563);
    freq.put("Sac", 85);
    freq.put(" hu", 138);
    freq.put(" hi", 591);
    freq.put(" ho", 365);
    freq.put("Ez\u030ce", 263);
    freq.put("Sar", 175);
    freq.put(" ha", 363);
    freq.put("Sav", 191);
    freq.put(" he", 768);
    freq.put("Sat", 80);
    freq.put("\u094d", 69);
    freq.put(" Ez\u030c", 273);
    freq.put("e\u0307za", 80);
    freq.put("lon", 920);
    freq.put("ge\u0328s", 112);
    freq.put("rz\u030ci", 124);
    freq.put("mna", 274);
    freq.put(" E ", 80);
    freq.put("MC ", 504);
    freq.put("e\u0328", 9237);
    freq.put("ck ", 279);
    freq.put(" El", 573);
    freq.put(" Em", 142);
    freq.put(" En", 317);
    freq.put(" Ei", 124);
    freq.put(" Ek", 234);
    freq.put(" Ed", 144);
    freq.put(" Eg", 301);
    freq.put(" Ex", 72);
    freq.put(" Et", 188);
    freq.put(" Eu", 1612);
    freq.put(" Ev", 98);
    freq.put(" Ep", 87);
    freq.put(" Er", 362);
    freq.put(" Es", 385);
    freq.put("cko", 72);
    freq.put("cu\u0304", 948);
    freq.put("rbe\u0307", 133);
    freq.put("cu\u0328", 73);
    freq.put("rba\u0328", 117);
    freq.put("jav", 90);
    freq.put("jau", 1901);
    freq.put("jar", 157);
    freq.put("jas", 2376);
    freq.put("jap", 205);
    freq.put("jan", 2657);
    freq.put("ae ", 3025);
    freq.put("jam", 5082);
    freq.put("jak", 120);
    freq.put("jai", 1573);
    freq.put("jag", 120);
    freq.put("jad", 82);
    freq.put("s\u030ci ", 168);
    freq.put("s\u030ciu", 646);
    freq.put("h", 15703);
    freq.put("rbu\u0328", 71);
    freq.put("s\u030cis", 1523);
    freq.put("s\u030cir", 121);
    freq.put("s\u030cim", 653);
    freq.put("s\u030cil", 344);
    freq.put("s\u030cio", 1156);
    freq.put("s\u030cin", 2480);
    freq.put("s\u030cik", 111);
    freq.put("aei", 134);
    freq.put("s\u030cia", 7811);
    freq.put("ael", 136);
    freq.put("ja ", 13854);
    freq.put("aen", 65);
    freq.put("Pr", 4041);
    freq.put("Ps", 108);
    freq.put("btr", 68);
    freq.put("vu\u0304", 491);
    freq.put("C", 5201);
    freq.put("Pa", 7638);
    freq.put("bta", 77);
    freq.put("Pe", 1585);
    freq.put("Ph", 112);
    freq.put("Pi", 2755);
    freq.put("bti", 224);
    freq.put("Po", 1535);
    freq.put("Pl", 1104);
    freq.put("\u0627", 149);
    freq.put("et ", 1493);
    freq.put("\u0432\u0435", 64);
    freq.put("P ", 639);
    freq.put("ude\u0307", 847);
    freq.put("etr", 2354);
    freq.put("etv", 1625);
    freq.put("va\u0328", 321);
    freq.put("ett", 92);
    freq.put("etu", 10440);
    freq.put("ety", 134);
    freq.put("vc\u030c", 186);
    freq.put("tla", 468);
    freq.put("eta", 5454);
    freq.put("tle", 281);
    freq.put("ve\u0307", 5454);
    freq.put("ve\u0328", 713);
    freq.put("tli", 717);
    freq.put("eti", 4554);
    freq.put("etn", 281);
    freq.put("ll", 1349);
    freq.put("ck", 632);
    freq.put("ci", 18836);
    freq.put("ch", 6035);
    freq.put("co", 1164);
    freq.put("Her", 326);
    freq.put("cl", 149);
    freq.put("cc", 125);
    freq.put("ca", 1365);
    freq.put("oc\u030c", 849);
    freq.put("ce", 6724);
    freq.put("cy", 129);
    freq.put("s\u030cia\u0328", 67);
    freq.put("cr", 288);
    freq.put("Hen", 73);
    freq.put("tsa", 349);
    freq.put("omy", 305);
    freq.put("cu", 428);
    freq.put("ct", 550);
    freq.put("Ger", 157);
    freq.put("tu\u0328j", 219);
    freq.put("Geg", 68);
    freq.put("Ged", 147);
    freq.put("Geo", 114);
    freq.put("Gen", 295);
    freq.put("Gel", 228);
    freq.put("lgi", 1731);
    freq.put("lgo", 332);
    freq.put("c ", 600);
    freq.put("Sen", 642);
    freq.put("lgy", 105);
    freq.put("unt", 286);
    freq.put("lgu", 66);
    freq.put("rby", 63);
    freq.put("rbu", 464);
    freq.put("rbt", 207);
    freq.put("s\u030ciu\u0328", 982);
    freq.put("rbo", 606);
    freq.put("rbl", 168);
    freq.put("tsp", 242);
    freq.put("rbi", 1182);
    freq.put("rbe", 227);
    freq.put("eur", 366);
    freq.put("s\u030cis\u030c", 128);
    freq.put("rba", 5655);
    freq.put("va", 45949);
    freq.put("ete\u0307", 1071);
    freq.put("vi", 38809);
    freq.put("vk", 143);
    freq.put("vl", 94);
    freq.put("vn", 98);
    freq.put("vo", 18294);
    freq.put("vr", 219);
    freq.put("vs", 237);
    freq.put("vu", 2039);
    freq.put("eta\u0328", 266);
    freq.put("vy", 6021);
    freq.put("vz", 413);
    freq.put("of ", 299);
    freq.put("zga", 86);
    freq.put("v ", 492);
    freq.put("phi", 136);
    freq.put("pho", 90);
    freq.put("pha", 125);
    freq.put("phy", 268);
    freq.put("etu\u0328", 4160);
    freq.put("ofa", 95);
    freq.put("ofe", 379);
    freq.put("ofi", 842);
    freq.put("ofo", 158);
    freq.put("oft", 141);
    freq.put("\u043a\u0438\u0438\u0306", 66);
    freq.put("yru\u0328", 212);
    freq.put("nve", 361);
    freq.put("nva", 85);
    freq.put("nvi", 1009);
    freq.put("yre\u0307", 91);
    freq.put("inz\u030c", 95);
    freq.put("gur", 151);
    freq.put("inu\u0328", 1093);
    freq.put("vsk", 219);
    freq.put("\u4e4b", 194);
    freq.put("fra", 263);
    freq.put("ini\u0328", 1158);
    freq.put("u\u0304no", 452);
    freq.put("Sco", 107);
    freq.put("kry", 1180);
    freq.put("ine\u0328", 1356);
    freq.put("u\u0304ni", 1251);
    freq.put(" ju", 2553);
    freq.put("u\u0304ne", 67);
    freq.put("kru", 318);
    freq.put("edy", 257);
    freq.put("inc\u030c", 492);
    freq.put(" jo", 2067);
    freq.put("kri", 3232);
    freq.put(" ji", 819);
    freq.put("kro", 983);
    freq.put(" je", 150);
    freq.put("ina\u0328", 194);
    freq.put("kra", 4663);
    freq.put(" ja", 1311);
    freq.put("kre", 1055);
    freq.put("yri", 1443);
    freq.put("yro", 395);
    freq.put("yra", 10061);
    freq.put("yre", 153);
    freq.put("yru", 239);
    freq.put("Kle", 64);
    freq.put("Kla", 523);
    freq.put("Kli", 79);
    freq.put("Klu", 106);
    freq.put("iny", 2814);
    freq.put("int", 7918);
    freq.put("inu", 851);
    freq.put(" je\u0307", 239);
    freq.put("u\u0304na\u0328", 68);
    freq.put("ins", 1597);
    freq.put("inm", 71);
    freq.put("ino", 4836);
    freq.put("ini", 42857);
    freq.put("ink", 9182);
    freq.put("ind", 4737);
    freq.put("ine", 2681);
    freq.put("inf", 613);
    freq.put("ing", 5394);
    freq.put("ina", 9499);
    freq.put("kra\u0328", 130);
    freq.put("eo ", 170);
    freq.put(" ji\u0328", 257);
    freq.put("U", 3005);
    freq.put("uos", 9387);
    freq.put("in ", 677);
    freq.put("eog", 245);
    freq.put("eod", 89);
    freq.put("kru\u0328", 140);
    freq.put("eon", 218);
    freq.put(" ju\u0328", 977);
    freq.put("eol", 734);
    freq.put("kru\u0304", 445);
    freq.put("eop", 149);
    freq.put(" ju\u0304", 1646);
    freq.put("eot", 67);
    freq.put("Tur", 537);
    freq.put("aln", 4883);
    freq.put("ere\u0307", 268);
    freq.put("era\u0328", 156);
    freq.put(" G ", 65);
    freq.put("erc\u030c", 118);
    freq.put("nka\u0328", 172);
    freq.put("rku\u0328", 131);
    freq.put("cm ", 459);
    freq.put("nke\u0307", 2543);
    freq.put("eri\u0328", 83);
    freq.put("ald", 5080);
    freq.put(" Gv", 487);
    freq.put("nks\u030c", 139);
    freq.put(" Gu", 448);
    freq.put(" Gr", 2243);
    freq.put("Tun", 69);
    freq.put("lvo", 651);
    freq.put(" Gy", 327);
    freq.put(" Ge", 1126);
    freq.put(" Ga", 1407);
    freq.put(" Go", 421);
    freq.put(" Gl", 237);
    freq.put(" Gi", 589);
    freq.put("eru\u0328", 398);
    freq.put("bre\u0307", 285);
    freq.put("erz\u030c", 348);
    freq.put("ers\u030c", 197);
    freq.put("a\u0304", 164);
    freq.put("s\u030cpl", 90);
    freq.put("s\u030co ", 946);
    freq.put("ptu", 124);
    freq.put("lac\u030c", 341);
    freq.put("s\u030cpa", 109);
    freq.put("gl ", 220);
    freq.put("tmi", 171);
    freq.put("ka\u0328 ", 1267);
    freq.put("ak ", 92);
    freq.put("s\u030con", 165);
    freq.put("s\u030com", 149);
    freq.put("s\u030cok", 166);
    freq.put("s\u030coj", 128);
    freq.put("s\u030cos", 190);
    freq.put("s\u030cor", 222);
    freq.put("sle", 271);
    freq.put("gli", 959);
    freq.put("aky", 230);
    freq.put("glo", 300);
    freq.put("aks", 329);
    freq.put("akr", 1125);
    freq.put("\u30a2\u30a2\u30a2", 149);
    freq.put("aku", 724);
    freq.put("akt", 1972);
    freq.put("aki", 1290);
    freq.put("ako", 1771);
    freq.put("akn", 187);
    freq.put("akm", 413);
    freq.put("akl", 356);
    freq.put("akc", 437);
    freq.put("aka", 10783);
    freq.put("ake", 779);
    freq.put("Jer", 74);
    freq.put("pu\u0304s", 102);
    freq.put("sso", 72);
    freq.put("bry", 134);
    freq.put("Nac", 163);
    freq.put("bru", 157);
    freq.put("bro", 454);
    freq.put("bri", 867);
    freq.put("S\u030ciu", 193);
    freq.put("bre", 106);
    freq.put("Jel", 102);
    freq.put("Nag", 68);
    freq.put("er ", 2219);
    freq.put("nka", 2908);
    freq.put("nkc", 507);
    freq.put("nke", 587);
    freq.put("nki", 5054);
    freq.put("nkl", 1886);
    freq.put("nko", 1384);
    freq.put("nkr", 206);
    freq.put("nks", 891);
    freq.put("nkt", 1190);
    freq.put("nku", 626);
    freq.put("nky", 223);
    freq.put("iv", 9558);
    freq.put("ert", 1937);
    freq.put("eru", 488);
    freq.put("erv", 903);
    freq.put("erp", 330);
    freq.put("err", 173);
    freq.put("ers", 2707);
    freq.put("ery", 234);
    freq.put("erd", 659);
    freq.put("ere", 1184);
    freq.put("erf", 77);
    freq.put("erg", 1284);
    freq.put("tna", 162);
    freq.put("era", 5900);
    freq.put("erb", 981);
    freq.put("erc", 545);
    freq.put("erl", 418);
    freq.put("erm", 1142);
    freq.put("ern", 1320);
    freq.put("ero", 2197);
    freq.put("tni", 215);
    freq.put("eri", 10880);
    freq.put("erk", 587);
    freq.put("io", 45938);
    freq.put("Abi", 168);
    freq.put("in", 120546);
    freq.put("ake\u0307", 76);
    freq.put("ual", 389);
    freq.put("uan", 260);
    freq.put("uac", 101);
    freq.put("S\u030cta", 114);
    freq.put("gle\u0307", 83);
    freq.put("ib", 3663);
    freq.put("i\u0304", 70);
    freq.put("lal", 283);
    freq.put("lam", 672);
    freq.put("lan", 3678);
    freq.put("lai", 7095);
    freq.put("laj", 360);
    freq.put("lak", 544);
    freq.put("lad", 233);
    freq.put("lag", 301);
    freq.put("lab", 885);
    freq.put("lac", 354);
    freq.put("lay", 83);
    freq.put("laz", 248);
    freq.put("lat", 1022);
    freq.put("lau", 4662);
    freq.put("lav", 1958);
    freq.put("lap", 1033);
    freq.put("lar", 290);
    freq.put("las", 4962);
    freq.put("aku\u0328", 454);
    freq.put("aks\u030c", 168);
    freq.put("glu\u0328", 187);
    freq.put("kte\u0307", 87);
    freq.put("zen", 162);
    freq.put("zel", 75);
    freq.put("zer", 347);
    freq.put("zeu", 81);
    freq.put("kta\u0328", 149);
    freq.put(" la\u0328", 374);
    freq.put(" le\u0307", 404);
    freq.put("ze ", 133);
    freq.put(" lu\u0304", 96);
    freq.put("l", 214716);
    freq.put("ktu\u0328", 516);
    freq.put("ktu\u0304", 882);
    freq.put("nt ", 3145);
    freq.put("Bu\u0304d", 72);
    freq.put("os\u030ce", 197);
    freq.put("os\u030ca", 95);
    freq.put("os\u030ci", 132);
    freq.put("os\u030ct", 122);
    freq.put("nty", 1460);
    freq.put("Sve", 90);
    freq.put("nts", 156);
    freq.put("ntr", 4642);
    freq.put("ntu", 1006);
    freq.put("ntv", 111);
    freq.put("nti", 13882);
    freq.put("nth", 149);
    freq.put("nto", 3213);
    freq.put("nta", 6698);
    freq.put("kit", 2704);
    freq.put("nte", 3240);
    freq.put("ntg", 70);
    freq.put("omu\u0328", 264);
    freq.put("e\u0307ce\u0307", 111);
    freq.put("­", 175);
    freq.put("tsk", 627);
    freq.put("kt ", 364);
    freq.put(" le", 2689);
    freq.put("B", 11003);
    freq.put(" la", 7451);
    freq.put(" lo", 631);
    freq.put(" li", 4372);
    freq.put(" lu", 92);
    freq.put(" ly", 1967);
    freq.put("Ser", 315);
    freq.put("Sep", 68);
    freq.put("ktu", 872);
    freq.put("Nr ", 561);
    freq.put("ktr", 1113);
    freq.put("kto", 1582);
    freq.put("kti", 2012);
    freq.put("z\u030cmo", 1552);
    freq.put("u\u0304pi", 97);
    freq.put("Sem", 92);
    freq.put("Sel", 68);
    freq.put("kta", 2002);
    freq.put("Sei", 374);
    freq.put(" u\u0304k", 511);
    freq.put("nti\u0328", 195);
    freq.put("ypt", 748);
    freq.put("nte\u0307", 672);
    freq.put("udz", 149);
    freq.put("ypa", 451);
    freq.put("nta\u0328", 186);
    freq.put("\u03c0", 65);
    freq.put("udy", 189);
    freq.put("ntu\u0328", 1010);
    freq.put("Chu", 119);
    freq.put("ntu\u0304", 104);
    freq.put("sud", 2168);
    freq.put("le\u0307", 8350);
    freq.put("uda", 2525);
    freq.put("d ", 4075);
    freq.put("aic\u030c", 1223);
    freq.put("la\u0328 ", 721);
    freq.put("hry", 109);
    freq.put("em ", 150);
    freq.put("hro", 216);
    freq.put("hri", 103);
    freq.put("hra", 72);
    freq.put("s\u030cme\u0307", 100);
    freq.put("dn", 150);
    freq.put("do", 13968);
    freq.put("dl", 210);
    freq.put("dm", 1790);
    freq.put("dk", 208);
    freq.put("dh", 99);
    freq.put("di", 31560);
    freq.put("dg", 238);
    freq.put("de", 15402);
    freq.put("da", 31040);
    freq.put("dz", 385);
    freq.put("dy", 7581);
    freq.put("dv", 2782);
    freq.put("du", 8502);
    freq.put("dr", 6349);
    freq.put("ds", 320);
    freq.put("eme", 1016);
    freq.put("emd", 90);
    freq.put("aiz\u030c", 139);
    freq.put("ema", 2008);
    freq.put("emb", 301);
    freq.put("emo", 2200);
    freq.put("emi", 2274);
    freq.put("emu", 703);
    freq.put("emt", 191);
    freq.put("la\u0328s", 439);
    freq.put("emp", 946);
    freq.put("ems", 853);
    freq.put("ais\u030c", 684);
    freq.put("w ", 260);
    freq.put("epe\u0307", 63);
    freq.put(" I ", 269);
    freq.put("ma\u0328 ", 3290);
    freq.put("il ", 133);
    freq.put("co ", 242);
    freq.put("niu\u0304", 1065);
    freq.put("we", 130);
    freq.put("wa", 302);
    freq.put("wo", 98);
    freq.put("wn", 67);
    freq.put(" Ir", 401);
    freq.put(" Is", 623);
    freq.put(" It", 425);
    freq.put("wi", 168);
    freq.put("ww", 153);
    freq.put(" Ik", 112);
    freq.put(" Il", 691);
    freq.put(" Im", 226);
    freq.put(" In", 1579);
    freq.put("niu\u0328", 11248);
    freq.put(" Ib", 64);
    freq.put(" Id", 102);
    freq.put(" Ig", 304);
    freq.put("ilg", 1557);
    freq.put("ild", 935);
    freq.put("ile", 510);
    freq.put("ila", 1055);
    freq.put("iln", 1654);
    freq.put("ilo", 1045);
    freq.put("ill", 367);
    freq.put("ilm", 942);
    freq.put("ilj", 190);
    freq.put("ilk", 807);
    freq.put("ili", 7113);
    freq.put("ilv", 228);
    freq.put("ilt", 617);
    freq.put("ilu", 734);
    freq.put("ils", 105);
    freq.put("ma\u0328s", 197);
    freq.put("com", 76);
    freq.put("col", 102);
    freq.put("ily", 138);
    freq.put("ema\u0328", 219);
    freq.put("di\u0328", 460);
    freq.put("eme\u0307", 1363);
    freq.put("da\u0328", 519);
    freq.put("mbu", 328);
    freq.put("de\u0328", 233);
    freq.put("de\u0307", 5783);
    freq.put("ai ", 28957);
    freq.put("s\u030cmi", 172);
    freq.put("du\u0304", 239);
    freq.put("s\u030cmo", 366);
    freq.put("s\u030cma", 81);
    freq.put("s\u030cme", 157);
    freq.put("dz\u030c", 9497);
    freq.put("du\u0328", 1603);
    freq.put("aiz", 904);
    freq.put("ait", 1788);
    freq.put("aiv", 2833);
    freq.put("aip", 4816);
    freq.put("ais", 9853);
    freq.put("air", 2272);
    freq.put("aim", 3610);
    freq.put("ail", 788);
    freq.put("gna", 449);
    freq.put("emu\u0328", 168);
    freq.put("gne", 245);
    freq.put("aid", 2977);
    freq.put("aig", 1833);
    freq.put("gni", 373);
    freq.put("gno", 577);
    freq.put("aib", 279);
    freq.put("opu", 410);
    freq.put("ni ", 526);
    freq.put("ile\u0307", 771);
    freq.put("vu\u0328j", 76);
    freq.put("ile\u0328", 379);
    freq.put("z\u030csi", 337);
    freq.put("Iki", 75);
    freq.put("th ", 187);
    freq.put("nij", 5825);
    freq.put("nik", 1554);
    freq.put("nin", 8141);
    freq.put("nio", 7526);
    freq.put("nil", 147);
    freq.put("nim", 4778);
    freq.put("nic", 409);
    freq.put("nia", 7994);
    freq.put("nif", 163);
    freq.put("nig", 783);
    freq.put("nid", 254);
    freq.put("nie", 779);
    freq.put("niz", 2108);
    freq.put("nir", 72);
    freq.put(" Is\u030c", 781);
    freq.put("nip", 69);
    freq.put("niv", 780);
    freq.put("nit", 387);
    freq.put("niu", 3647);
    freq.put("ept", 436);
    freq.put("epu", 165);
    freq.put("epr", 642);
    freq.put("eps", 96);
    freq.put("tho", 100);
    freq.put("epo", 412);
    freq.put("ilu\u0328", 166);
    freq.put("eph", 64);
    freq.put("epi", 513);
    freq.put("ilz\u030c", 195);
    freq.put("the", 357);
    freq.put("epe", 177);
    freq.put("epc", 101);
    freq.put("tha", 124);
    freq.put("epa", 1258);
    freq.put("rn ", 72);
    freq.put("Gau", 103);
    freq.put("Gar", 244);
    freq.put("Gan", 127);
    freq.put("Gam", 189);
    freq.put("Gal", 319);
    freq.put("Gaj", 89);
    freq.put("Gai", 76);
    freq.put("Gab", 77);
    freq.put("Tri", 330);
    freq.put("rni", 813);
    freq.put("rno", 408);
    freq.put("Tro", 116);
    freq.put("Tra", 520);
    freq.put("rna", 1385);
    freq.put("Tre", 156);
    freq.put("rne", 498);
    freq.put("rny", 471);
    freq.put("Tir", 87);
    freq.put("Tru", 94);
    freq.put("rnu", 106);
    freq.put("lci", 77);
    freq.put("Tok", 232);
    freq.put("mu\u0328 ", 3232);
    freq.put("u\u0304re\u0328", 259);
    freq.put("a\u0328", 20880);
    freq.put("rs\u030ca", 115);
    freq.put("u\u0304re\u0307", 579);
    freq.put("rs\u030ci", 542);
    freq.put("rs\u030ct", 245);
    freq.put("rs\u030cu", 471);
    freq.put("bu\u0328 ", 1576);
    freq.put("u\u0304ra\u0328", 276);
    freq.put("S\u030cv ", 293);
    freq.put("yka", 208);
    freq.put("ykd", 1149);
    freq.put("Lei", 123);
    freq.put("yki", 766);
    freq.put("yko", 378);
    freq.put("Len", 1971);
    freq.put("Leo", 93);
    freq.put("Lep", 69);
    freq.put("kve\u0307", 157);
    freq.put("Les", 78);
    freq.put("yku", 494);
    freq.put(" ne\u0307", 349);
    freq.put("plu", 196);
    freq.put("rs\u030c ", 371);
    freq.put("e\u0307ms", 611);
    freq.put("ply", 260);
    freq.put("e\u0307mi", 1028);
    freq.put("Z\u030cal", 202);
    freq.put("pla", 1821);
    freq.put("plo", 1805);
    freq.put("e\u0307me", 99);
    freq.put("obo", 229);
    freq.put("obl", 199);
    freq.put("obj", 1006);
    freq.put("obi", 1248);
    freq.put("S\u030cvi", 88);
    freq.put("u\u0304ru\u0328", 466);
    freq.put("obe", 189);
    freq.put("oba", 242);
    freq.put("obu", 232);
    freq.put("obs", 81);
    freq.put("mt ", 92);
    freq.put("war", 74);
    freq.put(" X ", 111);
    freq.put("Sud", 274);
    freq.put("z\u030ca ", 218);
    freq.put("rnu\u0328", 71);
    freq.put("mti", 479);
    freq.put("mto", 342);
    freq.put("mtm", 156);
    freq.put("mta", 393);
    freq.put("S\u030cvc\u030c", 176);
    freq.put("rs\u030cu\u0304", 168);
    freq.put("obe\u0307", 124);
    freq.put("Sau", 518);
    freq.put("ple\u0307", 383);
    freq.put("yks\u030c", 318);
    freq.put("e\u0307me\u0307", 214);
    freq.put("i\u0328", 24134);
    freq.put(" ni", 198);
    freq.put("umu", 499);
    freq.put("kve", 103);
    freq.put(" no", 1368);
    freq.put("kva", 547);
    freq.put(" na", 5031);
    freq.put("kvo", 154);
    freq.put(" ne", 7202);
    freq.put("kvi", 414);
    freq.put(" ny", 106);
    freq.put("yke\u0328", 197);
    freq.put(" nu", 12007);
    freq.put("u\u0304ry", 183);
    freq.put("obu\u0304", 144);
    freq.put("u\u0304ru", 361);
    freq.put("u\u0304ri", 1981);
    freq.put("u\u0304ro", 3121);
    freq.put("u\u0304ra", 1708);
    freq.put("\u1100\u1161\u1100\u1161", 99);
    freq.put("ibe\u0307", 80);
    freq.put("is\u030cm", 207);
    freq.put("is\u030cl", 1019);
    freq.put("is\u030co", 261);
    freq.put("gu ", 264);
    freq.put("is\u030ci", 468);
    freq.put("is\u030ck", 9640);
    freq.put("is\u030ce", 155);
    freq.put(" Ku\u0304", 349);
    freq.put("is\u030cg", 193);
    freq.put("is\u030ca", 318);
    freq.put("yvy", 146);
    freq.put("yve", 3277);
    freq.put("yva", 1082);
    freq.put("is\u030ct", 673);
    freq.put("is\u030cv", 411);
    freq.put("is\u030cp", 207);
    freq.put("is\u030cs", 1093);
    freq.put("is\u030cr", 686);
    freq.put(" Ke\u0307", 213);
    freq.put("umo", 1874);
    freq.put("gub", 128);
    freq.put("gua", 121);
    freq.put("ibu\u0304", 258);
    freq.put("gue", 64);
    freq.put("gui", 113);
    freq.put("guo", 261);
    freq.put("is\u030c ", 6273);
    freq.put("gum", 1158);
    freq.put("gul", 484);
    freq.put("gus", 1460);
    freq.put("p", 146221);
    freq.put("guv", 99);
    freq.put("gut", 67);
    freq.put("ibu\u0328", 249);
    freq.put("ol ", 243);
    freq.put("htt", 75);
    freq.put("ek ", 622);
    freq.put("\u0433", 113);
    freq.put("ht ", 128);
    freq.put("gle", 181);
    freq.put("eko", 1042);
    freq.put("ekm", 65);
    freq.put("ekl", 411);
    freq.put("eki", 1989);
    freq.put("eke", 125);
    freq.put("ekc", 170);
    freq.put("eka", 2352);
    freq.put("spe\u0307", 63);
    freq.put("eky", 288);
    freq.put("ekv", 315);
    freq.put("eku", 345);
    freq.put("ekt", 4207);
    freq.put("eks", 1896);
    freq.put("ekr", 192);
    freq.put("uzi", 1325);
    freq.put("Pun", 96);
    freq.put("uzd", 74);
    freq.put("uza", 114);
    freq.put("su\u0328 ", 1585);
    freq.put("Mok", 227);
    freq.put(" Ka", 7194);
    freq.put(" Ke", 839);
    freq.put(" Ki", 1466);
    freq.put(" Kn", 86);
    freq.put(" Ko", 2662);
    freq.put(" Kl", 830);
    freq.put(" Kr", 1957);
    freq.put(" Kv", 191);
    freq.put(" Ku", 1464);
    freq.put("ksa", 796);
    freq.put("ca ", 297);
    freq.put(" im", 762);
    freq.put("F", 3594);
    freq.put("\u064a", 99);
    freq.put("ibi", 638);
    freq.put(" K ", 135);
    freq.put("ibl", 199);
    freq.put("ibo", 741);
    freq.put("cas", 107);
    freq.put("car", 324);
    freq.put("ibe", 354);
    freq.put("cat", 74);
    freq.put("can", 137);
    freq.put("cal", 88);
    freq.put("cac", 140);
    freq.put("ibr", 360);
    freq.put("ibu", 210);
    freq.put("spy", 159);
    freq.put("ao ", 130);
    freq.put("spr", 582);
    freq.put("spu", 1602);
    freq.put("spi", 670);
    freq.put("eke\u0328", 92);
    freq.put("spo", 957);
    freq.put("eke\u0307", 269);
    freq.put("spa", 2100);
    freq.put("spe", 1156);
    freq.put("eki\u0328", 64);
    freq.put("s\u030csp", 63);
    freq.put("s\u030csa", 81);
    freq.put("aos", 78);
    freq.put("s\u030csk", 346);
    freq.put("s\u030csi", 699);
    freq.put("ght", 134);
    freq.put("eks\u030c", 67);
    freq.put("eku\u0328", 115);
    freq.put("Ru", 2114);
    freq.put("Che", 286);
    freq.put("Jav", 80);
    freq.put("Chi", 117);
    freq.put("Jau", 108);
    freq.put("no ", 11621);
    freq.put("Fed", 229);
    freq.put("Jap", 569);
    freq.put("Cho", 100);
    freq.put("Jan", 213);
    freq.put("Re", 2289);
    freq.put("Chr", 185);
    freq.put("Jam", 221);
    freq.put("Ra", 1932);
    freq.put("Ro", 1443);
    freq.put("Ri", 771);
    freq.put("mbi", 672);
    freq.put("\u03b1", 204);
    freq.put("nol", 827);
    freq.put("nom", 2167);
    freq.put("non", 256);
    freq.put("noi", 70);
    freq.put("noj", 1649);
    freq.put("nok", 84);
    freq.put("nod", 224);
    freq.put("nog", 120);
    freq.put("mba", 403);
    freq.put("C\u030ciu", 96);
    freq.put("R ", 1502);
    freq.put("noz", 151);
    freq.put("not", 507);
    freq.put("nov", 1035);
    freq.put("nop", 168);
    freq.put("nor", 1222);
    freq.put("nos", 4995);
    freq.put("em", 13103);
    freq.put("el", 20835);
    freq.put("eo", 2521);
    freq.put("en", 55954);
    freq.put("ei", 27949);
    freq.put("eh", 155);
    freq.put("ek", 14743);
    freq.put("ej", 2777);
    freq.put("ee", 377);
    freq.put("ed", 9131);
    freq.put("eg", 6969);
    freq.put("ef", 1143);
    freq.put("ea", 3623);
    freq.put("ec", 2366);
    freq.put("eb", 2049);
    freq.put("ey", 228);
    freq.put("ex", 138);
    freq.put("ez", 1754);
    freq.put("eu", 1022);
    freq.put("et", 36257);
    freq.put("ew", 210);
    freq.put("ev", 4073);
    freq.put("ep", 4431);
    freq.put("es", 24051);
    freq.put("er", 37980);
    freq.put("rlo", 116);
    freq.put("rli", 270);
    freq.put("rle", 65);
    freq.put("rld", 79);
    freq.put("rla", 454);
    freq.put("e ", 76709);
    freq.put("lmi", 148);
    freq.put("rly", 64);
    freq.put("lmo", 217);
    freq.put("lma", 561);
    freq.put("lme", 109);
    freq.put("ce\u0307", 232);
    freq.put("zan", 208);
    freq.put("zal", 69);
    freq.put("xi", 80);
    freq.put("zai", 89);
    freq.put("zac", 1511);
    freq.put("zav", 191);
    freq.put("zau", 206);
    freq.put("zar", 93);
    freq.put("zas", 215);
    freq.put("z\u030cir", 69);
    freq.put("Eur", 1489);
    freq.put("Pu", 558);
    freq.put("x ", 613);
    freq.put("za ", 200);
    freq.put("vu\u0328", 1508);
    freq.put("es\u030c", 4905);
    freq.put("ez\u030c", 4639);
    freq.put("lme\u0307", 408);
    freq.put("ei\u0328", 147);
    freq.put("egl", 182);
    freq.put("ec\u030c", 2839);
    freq.put("\u1100\u1161", 170);
    freq.put("usr", 197);
    freq.put("uvy", 103);
    freq.put("eic\u030c", 280);
    freq.put("\u03b5", 95);
    freq.put(" ps", 398);
    freq.put("i\u0328la", 456);
    freq.put("\u043d\u0430", 78);
    freq.put(" pu", 2293);
    freq.put("\u043d\u043e", 71);
    freq.put("\u043d\u0438", 79);
    freq.put(" pa", 29839);
    freq.put(" pe", 3678);
    freq.put(" pj", 71);
    freq.put(" pi", 10334);
    freq.put(" po", 4807);
    freq.put(" pl", 4167);
    freq.put("u\u0304ty", 109);
    freq.put("eis\u030c", 1009);
    freq.put("uvk", 94);
    freq.put("u\u0304ti", 914);
    freq.put("u\u0304te", 79);
    freq.put("u\u0304ta", 74);
    freq.put("vu ", 109);
    freq.put("ytu", 3236);
    freq.put(" Mu\u0304", 111);
    freq.put("yto", 736);
    freq.put("yti", 2477);
    freq.put("yta", 2174);
    freq.put("Kry", 125);
    freq.put("Kru", 166);
    freq.put("Kri", 437);
    freq.put("Kro", 173);
    freq.put("Kra", 414);
    freq.put("Kre", 575);
    freq.put("vuo", 278);
    freq.put("vul", 245);
    freq.put("vum", 127);
    freq.put("\u03b1 ", 85);
    freq.put("Ja\u0328 ", 106);
    freq.put("vus", 1133);
    freq.put("Yra", 183);
    freq.put("ii", 607);
    freq.put(" pe\u0307", 140);
    freq.put("ei ", 3954);
    freq.put("\u0446", 67);
    freq.put("lle", 203);
    freq.put(" pu\u0304", 86);
    freq.put("eip", 170);
    freq.put("eis", 5132);
    freq.put("eir", 124);
    freq.put("eit", 977);
    freq.put("eiv", 749);
    freq.put("eiz", 76);
    freq.put("u\u0304tu\u0328", 160);
    freq.put("eic", 241);
    freq.put("eid", 1499);
    freq.put("eig", 1358);
    freq.put("eik", 5224);
    freq.put("eim", 4571);
    freq.put("eil", 568);
    freq.put("ein", 1861);
    freq.put("ceg", 78);
    freq.put(" Me", 1896);
    freq.put(" Ma", 4719);
    freq.put(" Mo", 1991);
    freq.put(" Mi", 1782);
    freq.put(" Mu", 530);
    freq.put(" My", 150);
    freq.put("I\u0328si", 88);
    freq.put("yb", 11044);
    freq.put("yte\u0307", 146);
    freq.put("ete", 1059);
    freq.put("i\u0328st", 1175);
    freq.put("i\u0328si", 807);
    freq.put("i\u0328sk", 80);
    freq.put("ux ", 100);
    freq.put("yta\u0328", 75);
    freq.put("I\u0328st", 114);
    freq.put(" M ", 181);
    freq.put("eto", 2887);
    freq.put("yz", 303);
    freq.put("am ", 1782);
    freq.put("cm", 472);
    freq.put("ami", 5086);
    freq.put("psk", 1854);
    freq.put("psi", 725);
    freq.put("psn", 657);
    freq.put("amo", 3569);
    freq.put("ama", 10174);
    freq.put("amb", 1223);
    freq.put("ame", 5511);
    freq.put("pse", 76);
    freq.put("amy", 484);
    freq.put("amz", 131);
    freq.put("uz\u030cn", 124);
    freq.put("amp", 1185);
    freq.put("ams", 2382);
    freq.put("amu", 630);
    freq.put("amt", 459);
    freq.put("pst", 87);
    freq.put("psu", 123);
    freq.put("uz\u030cs", 382);
    freq.put("t", 305542);
    freq.put("Hel", 151);
    freq.put("yc\u030ci", 2350);
    freq.put("gu\u0304r", 160);
    freq.put("uci", 1337);
    freq.put("gu\u0304n", 307);
    freq.put("gu\u0304b", 364);
    freq.put("yny", 165);
    freq.put("ji\u0328 ", 548);
    freq.put("nme", 211);
    freq.put("nma", 125);
    freq.put("sra", 172);
    freq.put("dzi", 233);
    freq.put("oc\u030ci", 767);
    freq.put("sri", 1777);
    freq.put("sro", 178);
    freq.put("sru", 176);
    freq.put("Adr", 71);
    freq.put("tu\u0304n", 64);
    freq.put("tu\u0304k", 418);
    freq.put("s\u030ca\u0328 ", 73);
    freq.put("tu\u0304r", 3760);
    freq.put("Ada", 67);
    freq.put("Adm", 203);
    freq.put("lob", 276);
    freq.put("loc", 79);
    freq.put("log", 3426);
    freq.put("lod", 121);
    freq.put("loj", 732);
    freq.put("lok", 724);
    freq.put("loi", 69);
    freq.put("ama\u0328", 414);
    freq.put("lom", 534);
    freq.put("lor", 335);
    freq.put("los", 2610);
    freq.put("lop", 556);
    freq.put("lov", 512);
    freq.put("lot", 1612);
    freq.put("lou", 74);
    freq.put("\u0646", 73);
    freq.put("c\u030c", 23545);
    freq.put("J", 8588);
    freq.put("rje", 132);
    freq.put("amz\u030c", 667);
    freq.put("amu\u0328", 755);
    freq.put(" su", 14551);
    freq.put("lo ", 4298);
    freq.put("Est", 230);
    freq.put("Lam", 138);
    freq.put("Lan", 215);
    freq.put("Lao", 67);
    freq.put("Lai", 279);
    freq.put("Lab", 226);
    freq.put("Laz", 170);
    freq.put("Lat", 571);
    freq.put("Lau", 223);
    freq.put("Lap", 196);
    freq.put("yop", 72);
    freq.put("lga", 584);
    freq.put("lge", 222);
    freq.put("Bru", 71);
    freq.put("La ", 159);
    freq.put("Bro", 169);
    freq.put("Bri", 429);
    freq.put("Bre", 103);
    freq.put("Bra", 609);
    freq.put("Se\u0307", 67);
    freq.put("yvo", 316);
    freq.put("a\u0328mo", 118);
    freq.put("Sa\u0328", 373);
    freq.put("mpe", 889);
    freq.put("mpa", 1170);
    freq.put("mpo", 545);
    freq.put("mpl", 367);
    freq.put("mph", 67);
    freq.put("mpi", 2031);
    freq.put("Su\u0304", 95);
    freq.put("mpu", 163);
    freq.put("mpr", 78);
    freq.put("yvi", 885);
    freq.put("osl", 114);
    freq.put("pul", 563);
    freq.put("ege\u0307", 73);
    freq.put("pun", 96);
    freq.put("puo", 365);
    freq.put("tu\u0328 ", 12460);
    freq.put("fe\u0307", 82);
    freq.put("puk", 97);
    freq.put("vc\u030c ", 177);
    freq.put(" ru", 1285);
    freq.put("fu\u0328", 79);
    freq.put("s\u030ciu\u0304", 137);
    freq.put(" ry", 5467);
    freq.put("u\u0304vi", 114);
    freq.put(" re", 7211);
    freq.put(" ra", 8074);
    freq.put("pub", 1670);
    freq.put(" ro", 1078);
    freq.put(" ri", 2152);
    freq.put("s\u030c", 70424);
    freq.put("TS ", 71);
    freq.put("put", 192);
    freq.put("S ", 1115);
    freq.put("ve", 15404);
    freq.put("aso", 710);
    freq.put("asn", 256);
    freq.put("mpe\u0307", 146);
    freq.put("pur", 225);
    freq.put("asl", 491);
    freq.put("Sy", 113);
    freq.put("Sr", 63);
    freq.put("Sp", 553);
    freq.put("Sv", 277);
    freq.put("Su", 2454);
    freq.put("St", 1651);
    freq.put("Sk", 1024);
    freq.put("Si", 1578);
    freq.put("Sh", 180);
    freq.put("So", 1804);
    freq.put("Sn", 82);
    freq.put("Sm", 286);
    freq.put("Sl", 299);
    freq.put("Sc", 300);
    freq.put("Sa", 3106);
    freq.put("Se", 1883);
    freq.put("f ", 470);
    freq.put("fr", 1236);
    freq.put("ft", 398);
    freq.put("fu", 1782);
    freq.put("fy", 103);
    freq.put("fa", 1478);
    freq.put("fe", 2397);
    freq.put("ff", 102);
    freq.put("fg", 67);
    freq.put("fi", 4585);
    freq.put("fl", 318);
    freq.put(" ru\u0304", 2140);
    freq.put("fo", 4629);
    freq.put("a", 700709);
    freq.put("egz", 550);
    freq.put("egy", 91);
    freq.put("egr", 181);
    freq.put("egu", 769);
    freq.put("egi", 3283);
    freq.put("ego", 396);
    freq.put("o\u0308", 70);
    freq.put("ega", 737);
    freq.put("ege", 449);
    freq.put("sta\u0328", 248);
    freq.put("ce ", 305);
    freq.put("y ", 1490);
    freq.put("uvu", 401);
    freq.put("uvi", 2426);
    freq.put("ste\u0307", 1387);
    freq.put("uvo", 8973);
    freq.put("uva", 1382);
    freq.put("ste\u0328", 193);
    freq.put(" On", 138);
    freq.put(" Ol", 265);
    freq.put(" Om", 89);
    freq.put(" Ok", 221);
    freq.put(" Of", 78);
    freq.put(" Od", 117);
    freq.put(" Ob", 214);
    freq.put(" Oc", 104);
    freq.put(" Or", 560);
    freq.put(" Os", 251);
    freq.put(" Op", 146);
    freq.put("yi", 98);
    freq.put("yk", 7720);
    freq.put("yj", 6842);
    freq.put("ym", 5531);
    freq.put("yl", 2089);
    freq.put("yo", 203);
    freq.put("yn", 5647);
    freq.put("ya", 257);
    freq.put("cen", 3061);
    freq.put("yc", 258);
    freq.put("cel", 113);
    freq.put("ye", 94);
    freq.put("yd", 2201);
    freq.put("yg", 3318);
    freq.put("cet", 70);
    freq.put("ces", 658);
    freq.put("cer", 417);
    freq.put("cep", 179);
    freq.put("yp", 1504);
    freq.put("ys", 9392);
    freq.put("yr", 12733);
    freq.put("yt", 11083);
    freq.put("yv", 6788);
    freq.put(" O ", 103);
    freq.put("stu\u0304", 94);
    freq.put("ife", 169);
    freq.put("ifa", 104);
    freq.put("stu\u0328", 690);
    freq.put("ifo", 912);
    freq.put("ifi", 598);
    freq.put("pu ", 180);
    freq.put("z\u030cuv", 1113);
    freq.put("as ", 68022);
    freq.put("Ent", 76);
    freq.put("ioz", 68);
    freq.put("lis\u030c", 786);
    freq.put("liu\u0304", 227);
    freq.put("liu\u0328", 4116);
    freq.put("ass", 235);
    freq.put("lia\u0328", 195);
    freq.put("kas\u030c", 89);
    freq.put("asp", 307);
    freq.put("asv", 107);
    freq.put("asu", 274);
    freq.put("ast", 4236);
    freq.put("asy", 280);
    freq.put("pua", 68);
    freq.put("kc\u030ci", 82);
    freq.put("asa", 3470);
    freq.put("ase", 867);
    freq.put("asd", 82);
    freq.put("ask", 1323);
    freq.put("st ", 506);
    freq.put("asi", 8082);
    freq.put("ash", 79);
    freq.put("pup", 123);
    freq.put("kaz\u030c", 63);
    freq.put("asm", 1404);
    freq.put("pus", 2091);
    freq.put("z\u030cuo", 217);
    freq.put("z\u030cud", 129);
    freq.put("uvu\u0328", 343);
    freq.put("Imp", 87);
    freq.put("nc ", 104);
    freq.put("z\u030cut", 66);
    freq.put("z\u030cur", 382);
    freq.put("ge\u0307 ", 262);
    freq.put("yc\u030c", 2372);
    freq.put("tfo", 195);
    freq.put("lyj", 2459);
    freq.put("ys\u030c", 830);
    freq.put("nch", 181);
    freq.put("nci", 2521);
    freq.put("nco", 109);
    freq.put("nce", 603);
    freq.put("ste", 4835);
    freq.put("sta", 11594);
    freq.put("sto", 6918);
    freq.put("sti", 7618);
    freq.put("uve\u0307", 461);
    freq.put("stu", 1797);
    freq.put("str", 5446);
    freq.put("sty", 3413);
    freq.put("Gol", 68);
    freq.put("ka ", 5403);
    freq.put("ez\u030ci", 1071);
    freq.put("lid", 423);
    freq.put("puc\u030c", 92);
    freq.put("lif", 303);
    freq.put("lig", 956);
    freq.put("ase\u0307", 868);
    freq.put("lia", 9617);
    freq.put("lib", 160);
    freq.put("lic", 390);
    freq.put("lim", 1681);
    freq.put("lin", 10945);
    freq.put("lio", 6518);
    freq.put("Nig", 114);
    freq.put("lij", 2779);
    freq.put("lik", 3451);
    freq.put("lit", 2868);
    freq.put("liu", 3368);
    freq.put("liv", 318);
    freq.put("2 ", 443);
    freq.put("lis", 6123);
    freq.put("asc\u030c", 85);
    freq.put("Niu", 165);
    freq.put("kac", 439);
    freq.put("kab", 221);
    freq.put("kag", 106);
    freq.put("kad", 1450);
    freq.put("kak", 332);
    freq.put("kaj", 116);
    freq.put("kai", 11174);
    freq.put("kan", 2442);
    freq.put("kam", 1843);
    freq.put("kal", 11413);
    freq.put("kas", 6028);
    freq.put("kar", 10769);
    freq.put("kap", 1244);
    freq.put("kav", 389);
    freq.put("kau", 876);
    freq.put("kat", 1246);
    freq.put("kaz", 236);
    freq.put("The", 467);
    freq.put("li ", 2175);
    freq.put("bzd", 176);
    freq.put("ru\u0304t", 179);
    freq.put("ru\u0304v", 85);
    freq.put("ru\u0304p", 93);
    freq.put("ru\u0304s", 316);
    freq.put("yz\u030c", 529);
    freq.put("ru\u0304d", 121);
    freq.put("ru\u0304g", 209);
    freq.put("ru\u0304m", 473);
    freq.put("ru\u0304n", 147);
    freq.put("ru\u0304k", 126);
    freq.put("e\u0307ki", 72);
    freq.put("e\u0307km", 115);
    freq.put("e\u0307kl", 135);
    freq.put(" te\u0328", 151);
    freq.put(" te\u0307", 174);
    freq.put("yma", 917);
    freq.put("yme", 67);
    freq.put("ymi", 564);
    freq.put("ox ", 72);
    freq.put("e\u0307kt", 249);
    freq.put("ymo", 2861);
    freq.put("uve\u0328", 282);
    freq.put(" tu\u0304", 466);
    freq.put("x", 937);
    freq.put("nc\u030ci", 4255);
    freq.put("gse\u0307", 181);
    freq.put("Plu", 194);
    freq.put("ydi", 267);
    freq.put("Ple", 71);
    freq.put("Pla", 439);
    freq.put("dut", 428);
    freq.put("Plo", 267);
    freq.put("Pli", 66);
    freq.put("Obe", 83);
    freq.put("maz\u030c", 1405);
    freq.put("si\u0328 ", 224);
    freq.put("ge\u0307r", 187);
    freq.put("ru\u0304s\u030c", 1748);
    freq.put("War", 82);
    freq.put(" t ", 238);
    freq.put("ymu\u0328", 245);
    freq.put("ydr", 112);
    freq.put(" ty", 567);
    freq.put(" tv", 701);
    freq.put(" tu", 2991);
    freq.put("buc\u030c", 70);
    freq.put(" tr", 3585);
    freq.put("N", 7515);
    freq.put(" to", 1975);
    freq.put("yma\u0328", 285);
    freq.put(" ti", 5451);
    freq.put(" th", 302);
    freq.put(" te", 9733);
    freq.put(" ta", 10594);
    freq.put("adm", 1262);
    freq.put("ba\u0328 ", 394);
    freq.put(" u\u0328j", 70);
    freq.put("Kva", 100);
    freq.put("Nik", 109);
    freq.put("FA ", 185);
    freq.put("vyr", 1040);
    freq.put("vys", 564);
    freq.put("gst", 140);
    freq.put("vyt", 65);
    freq.put("vyz", 235);
    freq.put("vyb", 651);
    freq.put("vyd", 92);
    freq.put("vyj", 96);
    freq.put("vyk", 2515);
    freq.put("vyn", 610);
    freq.put("vyl", 67);
    freq.put("va\u0328 ", 302);
    freq.put("ute\u0307", 482);
    freq.put("\u03b9", 119);
    freq.put("lip", 320);
    freq.put("tut", 476);
    freq.put("lc\u030ci", 255);
    freq.put("liz", 1115);
    freq.put("eed", 76);
    freq.put("asu\u0328", 302);
    freq.put("ju\u0328 ", 7448);
    freq.put("ru ", 632);
    freq.put("tuv", 8023);
    freq.put("sve\u0307", 126);
    freq.put("dve\u0307", 188);
    freq.put("nas\u030c", 624);
    freq.put("gi\u0328 ", 94);
    freq.put("\u0437", 104);
    freq.put("naz\u030c", 94);
    freq.put("id ", 126);
    freq.put("ruk", 710);
    freq.put("rui", 138);
    freq.put("run", 372);
    freq.put("ruo", 2554);
    freq.put("rum", 1117);
    freq.put("rub", 105);
    freq.put("rug", 582);
    freq.put("rud", 269);
    freq.put("pus\u030c", 167);
    freq.put("ruz", 216);
    freq.put("rur", 65);
    freq.put("rus", 3390);
    freq.put("rup", 2436);
    freq.put("ruv", 66);
    freq.put("rut", 405);
    freq.put("As\u030c", 111);
    freq.put("idy", 563);
    freq.put("idv", 63);
    freq.put("Te\u0307", 65);
    freq.put("idu", 2683);
    freq.put("idr", 494);
    freq.put("ido", 937);
    freq.put("idm", 185);
    freq.put("mc\u030ci", 71);
    freq.put("idi", 2189);
    freq.put("ide", 3721);
    freq.put("ida", 3570);
    freq.put("Ele", 243);
    freq.put("ut ", 98);
    freq.put("\u4e26", 122);
    freq.put("s\u030cuk", 112);
    freq.put("s\u030cuj", 65);
    freq.put("s\u030cum", 70);
    freq.put("s\u030cul", 170);
    freq.put("s\u030cuo", 95);
    freq.put("s\u030cun", 139);
    freq.put("s\u030cus", 224);
    freq.put("s\u030cut", 236);
    freq.put("s\u030cuv", 83);
    freq.put("ti\u0328 ", 848);
    freq.put("tul", 676);
    freq.put("utb", 1100);
    freq.put("uta", 1298);
    freq.put("ute", 1211);
    freq.put("S\u030cak", 157);
    freq.put("S\u030cal", 318);
    freq.put("uto", 2462);
    freq.put("S\u030can", 75);
    freq.put("utr", 654);
    freq.put("uts", 108);
    freq.put("S\u030car", 99);
    freq.put("S\u030cau", 91);
    freq.put("utu", 465);
    freq.put("uty", 105);
    freq.put("tun", 200);
    freq.put("Ty", 98);
    freq.put("Tv", 72);
    freq.put("ide\u0307", 1297);
    freq.put("Tu", 954);
    freq.put("Tr", 1269);
    freq.put("To", 1061);
    freq.put("Th", 580);
    freq.put("Ti", 954);
    freq.put("ida\u0328", 63);
    freq.put("Ta", 3988);
    freq.put("nab", 100);
    freq.put("A ", 1074);
    freq.put("naf", 82);
    freq.put("nag", 711);
    freq.put("nad", 530);
    freq.put("nae", 88);
    freq.put("naj", 138);
    freq.put("nak", 285);
    freq.put("nai", 2792);
    freq.put("nan", 2181);
    freq.put("nal", 3006);
    freq.put("nam", 4510);
    freq.put("nar", 1177);
    freq.put("nas", 9068);
    freq.put("nap", 314);
    freq.put("nav", 974);
    freq.put("nat", 1500);
    freq.put("nau", 2982);
    freq.put("naz", 237);
    freq.put("a\u0328n", 83);
    freq.put("T ", 426);
    freq.put("idz\u030c", 3127);
    freq.put("svo", 286);
    freq.put("dvo", 211);
    freq.put("Ab", 409);
    freq.put("dvi", 1481);
    freq.put("Ad", 552);
    freq.put("Ag", 282);
    freq.put("svi", 243);
    freq.put("dve", 133);
    freq.put("Ak", 583);
    freq.put("Aj", 72);
    freq.put("Am", 1804);
    freq.put("idu\u0328", 320);
    freq.put("An", 2621);
    freq.put("Ap", 788);
    freq.put("As", 631);
    freq.put("Ar", 1944);
    freq.put("dvy", 133);
    freq.put("At", 910);
    freq.put("Av", 215);
    freq.put("svu", 88);
    freq.put("gv", 1056);
    freq.put("gu", 4898);
    freq.put("gt", 1721);
    freq.put("gs", 555);
    freq.put("Gir", 131);
    freq.put("gp", 278);
    freq.put("gz", 596);
    freq.put("gy", 5384);
    freq.put("ge", 8770);
    freq.put("gd", 980);
    freq.put("Gib", 75);
    freq.put("ga", 24984);
    freq.put("go", 7511);
    freq.put("gn", 1795);
    freq.put("gm", 391);
    freq.put("Gil", 90);
    freq.put("gi", 19462);
    freq.put("gh", 277);
    freq.put("lko", 1340);
    freq.put("lkl", 70);
    freq.put("lki", 640);
    freq.put("lke", 67);
    freq.put("lka", 889);
    freq.put("Not", 108);
    freq.put("Nov", 113);
    freq.put("lku", 68);
    freq.put("\u03bd", 128);
    freq.put("lks", 80);
    freq.put("Nor", 386);
    freq.put("kci", 1331);
    freq.put("g ", 2674);
    freq.put("hi ", 89);
    freq.put("Spi", 75);
    freq.put("a\u0328s", 1224);
    freq.put("Spo", 74);
    freq.put("Spa", 162);
    freq.put("tmo", 148);
    freq.put("Spe", 132);
    freq.put("zl", 136);
    freq.put("zm", 1647);
    freq.put("zn", 153);
    freq.put("zo", 1897);
    freq.put("zi", 7116);
    freq.put("zk", 67);
    freq.put("zd", 1810);
    freq.put("ze", 985);
    freq.put("zg", 207);
    freq.put("za", 3048);
    freq.put("zb", 85);
    freq.put("dis\u030c", 216);
    freq.put("zy", 69);
    freq.put("zu", 1165);
    freq.put("zr", 101);
    freq.put("iz\u030ci", 186);
    freq.put("de\u0307n", 263);
    freq.put("iz\u030ca", 147);
    freq.put("iz\u030cy", 171);
    freq.put("ulo", 319);
    freq.put("u\u0304zu\u0328", 144);
    freq.put("oza", 345);
    freq.put("ozo", 156);
    freq.put("ulm", 98);
    freq.put("z ", 658);
    freq.put("ozi", 309);
    freq.put(" ve\u0307", 1295);
    freq.put("ymu", 353);
    freq.put("ulg", 118);
    freq.put("\u0440\u0430", 115);
    freq.put("iep", 530);
    freq.put("gu\u0328", 1741);
    freq.put("gz\u030c", 880);
    freq.put("gs\u030c", 230);
    freq.put("gu\u0304", 892);
    freq.put("lku\u0304", 97);
    freq.put("lks\u030c", 220);
    freq.put("ps\u030c", 499);
    freq.put("lku\u0328", 772);
    freq.put("Ji", 1102);
    freq.put("Je", 435);
    freq.put("gi\u0328", 95);
    freq.put("lke\u0307", 206);
    freq.put("ge\u0307", 2321);
    freq.put("ge\u0328", 183);
    freq.put("Ja", 1783);
    freq.put("ga\u0328", 598);
    freq.put("ine\u0307", 20322);
    freq.put("zu\u0304", 96);
    freq.put("a\u0328 ", 16360);
    freq.put("u\u0304na", 1137);
    freq.put("pe\u0307", 6097);
    freq.put(" va", 20321);
    freq.put("se\u0328 ", 210);
    freq.put(" ve", 4247);
    freq.put(" vi", 14126);
    freq.put(" vo", 600);
    freq.put("oze\u0307", 194);
    freq.put(" vu", 113);
    freq.put(" vy", 3074);
    freq.put("e\u0307p", 181);
    freq.put("u\u0304zi", 829);
    freq.put("u\u0304nu", 353);
    freq.put("se\u0328s", 72);
    freq.put("ze\u0328", 74);
    freq.put("ze\u0307", 693);
    freq.put("ju\u0304c\u030c", 213);
    freq.put("\u0628", 63);
    freq.put(" Su\u0304", 95);
    freq.put("rse\u0307", 70);
    freq.put(" Se\u0307", 67);
    freq.put(" Sa\u0328", 373);
    freq.put("bez\u030c", 91);
    freq.put("mis\u030c", 1246);
    freq.put("hlo", 65);
    freq.put("mar", 995);
    freq.put("ure\u0328", 1318);
    freq.put("mat", 2440);
    freq.put("mav", 409);
    freq.put("\u043f", 122);
    freq.put("ece", 95);
    freq.put("eca", 89);
    freq.put("eco", 118);
    freq.put("eck", 65);
    freq.put("eci", 846);
    freq.put("ech", 882);
    freq.put("ect", 147);
    freq.put("urs\u030c", 132);
    freq.put("uru\u0328", 123);
    freq.put("urz\u030c", 199);
    freq.put("arp", 3635);
    freq.put("rs ", 981);
    freq.put("pi\u0328 ", 89);
    freq.put("aru", 2631);
    freq.put(" Sy", 113);
    freq.put("su\u0304r", 75);
    freq.put(" Sr", 63);
    freq.put(" Sp", 549);
    freq.put(" Sv", 277);
    freq.put(" St", 1586);
    freq.put(" Su", 2443);
    freq.put(" Sk", 1023);
    freq.put(" Sh", 178);
    freq.put(" Si", 1574);
    freq.put(" Sn", 82);
    freq.put(" So", 1791);
    freq.put(" Sl", 298);
    freq.put(" Sm", 286);
    freq.put(" Sc", 292);
    freq.put(" Sa", 3099);
    freq.put(" Se", 1876);
    freq.put("rsl", 371);
    freq.put("rsm", 221);
    freq.put("rso", 508);
    freq.put("rsi", 1214);
    freq.put("rsk", 222);
    freq.put("rse", 236);
    freq.put("rsa", 416);
    freq.put("R", 10122);
    freq.put("rst", 803);
    freq.put("rsu", 138);
    freq.put("bek", 139);
    freq.put("bei", 2412);
    freq.put("ben", 2915);
    freq.put("bel", 329);
    freq.put("ber", 929);
    freq.put("bes", 726);
    freq.put(" S ", 144);
    freq.put("bev", 245);
    freq.put("bet", 875);
    freq.put("are", 1358);
    freq.put("s\u030cve", 671);
    freq.put("ur ", 478);
    freq.put("arm", 594);
    freq.put("Dep", 64);
    freq.put("ris\u030c", 698);
    freq.put("BA ", 84);
    freq.put("pyr", 87);
    freq.put("pyt", 97);
    freq.put("pyv", 70);
    freq.put("pyj", 119);
    freq.put("pyk", 93);
    freq.put("pyl", 1154);
    freq.put("pyn", 242);
    freq.put("pyg", 410);
    freq.put("urd", 135);
    freq.put("ure", 433);
    freq.put("urg", 609);
    freq.put("ura", 1290);
    freq.put("urb", 304);
    freq.put("Dei", 68);
    freq.put("urm", 174);
    freq.put("urn", 819);
    freq.put("uro", 2323);
    freq.put("uri", 13437);
    freq.put("urk", 677);
    freq.put("urt", 2267);
    freq.put("uru", 270);
    freq.put("urv", 125);
    freq.put("urp", 92);
    freq.put("urs", 335);
    freq.put("ury", 263);
    freq.put("Dem", 131);
    freq.put("ri\u0328 ", 999);
    freq.put("z\u030cis", 284);
    freq.put("z\u030ciu", 1205);
    freq.put("z\u030cik", 242);
    freq.put("z\u030cin", 2776);
    freq.put("z\u030cio", 3609);
    freq.put("z\u030cim", 518);
    freq.put("z\u030cia", 4861);
    freq.put("z\u030cie", 756);
    freq.put("nge", 541);
    freq.put("nga", 2804);
    freq.put("ngl", 1130);
    freq.put("ngo", 2538);
    freq.put("ngi", 2530);
    freq.put("sh ", 92);
    freq.put("ngu", 1035);
    freq.put("ngv", 440);
    freq.put("ngr", 450);
    freq.put("ngs", 123);
    freq.put("ote\u0307", 267);
    freq.put("mga", 68);
    freq.put("ttp", 75);
    freq.put("tbo", 1115);
    freq.put("z\u030ci ", 73);
    freq.put("otu\u0328", 425);
    freq.put("ng ", 636);
    freq.put("shi", 127);
    freq.put("m2 ", 432);
    freq.put("ke ", 844);
    freq.put("ts\u030ca", 98);
    freq.put("lup", 118);
    freq.put("lur", 73);
    freq.put("lus", 1933);
    freq.put("lut", 328);
    freq.put("luv", 66);
    freq.put("lub", 724);
    freq.put("pe\u0307 ", 2903);
    freq.put("lui", 136);
    freq.put("\u043b", 327);
    freq.put("luk", 80);
    freq.put("lum", 619);
    freq.put("lun", 291);
    freq.put("luo", 731);
    freq.put("ken", 372);
    freq.put("kel", 3590);
    freq.put("Dze", 98);
    freq.put("kei", 560);
    freq.put("ked", 124);
    freq.put("kea", 110);
    freq.put(" i\u0328z\u030c", 65);
    freq.put("ket", 958);
    freq.put("kes", 439);
    freq.put("ker", 661);
    freq.put("kep", 138);
    freq.put("pe\u0307s", 2048);
    freq.put("lu ", 327);
    freq.put("pe\u0307d", 630);
    freq.put("pe\u0307n", 79);
    freq.put("pe\u0307m", 214);
    freq.put("pe\u0307j", 200);
    freq.put("re\u0307z\u030c", 276);
    freq.put("ot ", 142);
    freq.put("z\u030ciu\u0328", 1603);
    freq.put("Lon", 143);
    freq.put("Los", 103);
    freq.put("Lot", 96);
    freq.put("ngu\u0328", 481);
    freq.put("inv", 260);
    freq.put("\u0434", 172);
    freq.put("oti", 3180);
    freq.put("otn", 65);
    freq.put("oto", 2263);
    freq.put("ota", 3370);
    freq.put("ote", 1275);
    freq.put("oty", 482);
    freq.put("nge\u0307", 262);
    freq.put("ri\u0328z\u030c", 117);
    freq.put("otr", 264);
    freq.put("ott", 72);
    freq.put("otu", 369);
    freq.put("And", 549);
    freq.put("Ang", 426);
    freq.put("Ana", 165);
    freq.put("Ank", 145);
    freq.put("Ant", 913);
    freq.put("Any", 154);
    freq.put("z\u030cia\u0328", 130);
    freq.put(" i\u0328 ", 8903);
    freq.put(" ja\u0328", 256);
    freq.put("u\u0304ne\u0307", 216);
    freq.put("Ryt", 687);
    freq.put("re\u0307 ", 1022);
    freq.put("inc", 1582);
    freq.put(" i\u0328l", 469);
    freq.put(" i\u0328m", 645);
    freq.put(" i\u0328k", 1033);
    freq.put(" i\u0328g", 452);
    freq.put(" i\u0328d", 139);
    freq.put(" i\u0328e", 113);
    freq.put("mzd", 138);
    freq.put(" i\u0328v", 1493);
    freq.put("esu\u0328", 111);
    freq.put(" i\u0328t", 810);
    freq.put(" i\u0328r", 895);
    freq.put(" i\u0328s", 1931);
    freq.put(" i\u0328p", 146);
    freq.put("ria\u0328", 492);
    freq.put("re\u0307d", 146);
    freq.put("re\u0307g", 75);
    freq.put("i", 803156);
    freq.put("re\u0307j", 1557);
    freq.put("re\u0307l", 160);
    freq.put("re\u0307m", 119);
    freq.put("re\u0307n", 386);
    freq.put("re\u0307s", 6344);
    freq.put("re\u0307t", 168);
    freq.put("Be", 1548);
    freq.put("Ba", 3819);
    freq.put("Bl", 293);
    freq.put("Bo", 1206);
    freq.put("he\u0307", 71);
    freq.put("Bu", 1123);
    freq.put("a\u0328z\u030c", 190);
    freq.put("Br", 1448);
    freq.put("ve\u0307 ", 1134);
    freq.put("i\u0328du", 68);
    freq.put("B ", 521);
    freq.put("ji ", 3840);
    freq.put(" x ", 92);
    freq.put("ve\u0307p", 105);
    freq.put("ve\u0307r", 82);
    freq.put("ve\u0307s", 1539);
    freq.put("ve\u0307l", 1093);
    freq.put("ve\u0307m", 70);
    freq.put("ve\u0307n", 180);
    freq.put("ve\u0307j", 505);
    freq.put("ve\u0307d", 103);
    freq.put("ubt", 123);
    freq.put("U ", 260);
    freq.put(" Uz\u030c", 349);
    freq.put("ps", 4103);
    freq.put("Ut", 266);
    freq.put("pp", 160);
    freq.put("Us", 82);
    freq.put("Ur", 330);
    freq.put("Ul", 82);
    freq.put("Uo", 118);
    freq.put("Un", 265);
    freq.put("Uk", 462);
    freq.put("pv", 639);
    freq.put("Ug", 88);
    freq.put("duo", 2102);
    freq.put("s\u030cie", 268);
    freq.put("dub", 205);
    freq.put("ea ", 188);
    freq.put("h ", 675);
    freq.put("dug", 90);
    freq.put(" C\u030ce", 428);
    freq.put(" C\u030ca", 214);
    freq.put(" C\u030ci", 814);
    freq.put("Bu\u0304", 168);
    freq.put("eak", 217);
    freq.put("hy", 403);
    freq.put("eal", 365);
    freq.put("ean", 215);
    freq.put("hr", 575);
    freq.put("hs", 179);
    freq.put("pe", 8966);
    freq.put("eae", 1640);
    freq.put("eag", 73);
    freq.put("hu", 755);
    freq.put("pj", 353);
    freq.put("hi", 2459);
    freq.put("hn", 698);
    freq.put("ho", 2226);
    freq.put("hl", 151);
    freq.put("hm", 207);
    freq.put("eap", 89);
    freq.put("ear", 134);
    freq.put("eau", 64);
    freq.put("eat", 373);
    freq.put("he", 3549);
    freq.put("ve\u0307z\u030c", 564);
    freq.put("pi", 24691);
    freq.put("dme", 216);
    freq.put("dmi", 1463);
    freq.put("pl", 7261);
    freq.put("Gvi", 230);
    freq.put("Gva", 257);
    freq.put("tz\u030cv", 91);
    freq.put("eom", 87);
    freq.put("yme\u0307", 134);
    freq.put(" Uz", 68);
    freq.put("eor", 538);
    freq.put(" Ut", 265);
    freq.put(" Up", 172);
    freq.put(" Ur", 330);
    freq.put(" Us", 82);
    freq.put(" Ul", 82);
    freq.put(" Un", 258);
    freq.put(" Uo", 118);
    freq.put(" Uk", 462);
    freq.put(" Ug", 88);
    freq.put("Uz\u030c", 349);
    freq.put("cid", 198);
    freq.put("hni", 331);
    freq.put("hno", 260);
    freq.put("u\u0304nu\u0328", 861);
    freq.put("s\u030cym", 121);
    freq.put("aub", 219);
    freq.put("aud", 4737);
    freq.put("aug", 7354);
    freq.put("auk", 5802);
    freq.put("auj", 2881);
    freq.put("aum", 246);
    freq.put("aul", 3204);
    freq.put("auo", 93);
    freq.put("aun", 1743);
    freq.put("aup", 243);
    freq.put("aus", 15793);
    freq.put("aur", 9854);
    freq.put("aut", 4104);
    freq.put("s\u030cyt", 666);
    freq.put("auz", 79);
    freq.put("s\u030cys", 236);
    freq.put("ec\u030ci", 2678);
    freq.put("Joh", 97);
    freq.put("au ", 2801);
    freq.put("upi", 1336);
    freq.put("upe", 880);
    freq.put("upa", 260);
    freq.put("upy", 138);
    freq.put("upt", 113);
    freq.put("upu", 131);
    freq.put("upr", 184);
    freq.put("me ", 4745);
    freq.put("z\u030cos", 282);
    freq.put("z\u030col", 428);
    freq.put("ygu\u0328", 179);
    freq.put("z\u030coj", 209);
    freq.put("z\u030cod", 694);
    freq.put("Ign", 235);
    freq.put("nen", 435);
    freq.put("neo", 246);
    freq.put("nel", 523);
    freq.put("nem", 377);
    freq.put("ove\u0307", 1571);
    freq.put("nei", 1033);
    freq.put("nef", 72);
    freq.put("Pue", 76);
    freq.put("ned", 530);
    freq.put("ove\u0328", 68);
    freq.put("neb", 233);
    freq.put("nec", 126);
    freq.put("nea", 242);
    freq.put("nez", 420);
    freq.put("nev", 652);
    freq.put("net", 3370);
    freq.put("neu", 225);
    freq.put("ner", 1909);
    freq.put("nes", 2353);
    freq.put("nep", 854);
    freq.put("Pus", 118);
    freq.put("ovu\u0328", 204);
    freq.put("\u0443", 184);
    freq.put("mec", 166);
    freq.put("mem", 105);
    freq.put("mel", 455);
    freq.put("men", 7636);
    freq.put("mei", 219);
    freq.put("met", 7146);
    freq.put("mes", 916);
    freq.put("mer", 2496);
    freq.put("z\u030co ", 203);
    freq.put("mez", 71);
    freq.put("dry", 71);
    freq.put("lne\u0307", 167);
    freq.put("yga\u0328", 95);
    freq.put("dru", 787);
    freq.put("ne ", 5137);
    freq.put("dri", 926);
    freq.put("a\u0328ly", 225);
    freq.put("sjo", 73);
    freq.put("dro", 2362);
    freq.put("dra", 1708);
    freq.put("dre", 173);
    freq.put("e\u0328si", 184);
    freq.put("kg ", 77);
    freq.put("De\u0307", 112);
    freq.put("upe\u0307", 4550);
    freq.put("e\u0328st", 139);
    freq.put("s\u030cc\u030ci", 2647);
    freq.put("pe\u0328 ", 262);
    freq.put("auz\u030c", 306);
    freq.put("Ste", 219);
    freq.put("Sta", 653);
    freq.put("Sto", 157);
    freq.put("auc\u030c", 212);
    freq.put("Sti", 184);
    freq.put("Stu", 148);
    freq.put("rip", 333);
    freq.put("Str", 249);
    freq.put("V", 11358);
    freq.put("Til", 74);
    freq.put("rio", 6643);
    freq.put("S\u030ces\u030c", 127);
    freq.put("Lie", 6085);
    freq.put("Lig", 81);
    freq.put("Lia", 138);
    freq.put("Lib", 176);
    freq.put("ygo", 549);
    freq.put("Lim", 100);
    freq.put("Lin", 276);
    freq.put("Tik", 149);
    freq.put("sje\u0307", 92);
    freq.put("dre\u0307", 138);
    freq.put("Lit", 89);
    freq.put("Liu", 198);
    freq.put("Liv", 74);
    freq.put("rig", 767);
    freq.put("dra\u0328", 94);
    freq.put("Kab", 68);
    freq.put("rie", 6574);
    freq.put("Kad", 98);
    freq.put("mec\u030c", 426);
    freq.put("Kai", 1116);
    freq.put("Kan", 625);
    freq.put("Kam", 412);
    freq.put("Kal", 1098);
    freq.put("Kas", 171);
    freq.put("Kar", 1509);
    freq.put("Kap", 211);
    freq.put("Kau", 985);
    freq.put("Kat", 242);
    freq.put("Kaz", 340);
    freq.put("ovs", 154);
    freq.put("mes\u030c", 73);
    freq.put("ovu", 118);
    freq.put("ovy", 172);
    freq.put("u\u0304c\u030ci", 238);
    freq.put("ova", 2312);
    freq.put("ove", 473);
    freq.put("ovi", 2936);
    freq.put("ovo", 1368);
    freq.put("nei\u0328", 137);
    freq.put("Alk", 99);
    freq.put("Ali", 208);
    freq.put("Alg", 65);
    freq.put("Ale", 201);
    freq.put("Alb", 193);
    freq.put("Ala", 187);
    freq.put("nku\u0328", 1281);
    freq.put("Aly", 220);
    freq.put("Alt", 143);
    freq.put("Alp", 174);
    freq.put("\u03c1", 114);
    freq.put("zdy", 84);
    freq.put("Wor", 95);
    freq.put("mu\u0304", 487);
    freq.put("SS ", 87);
    freq.put("tyc\u030c", 85);
    freq.put(" zo", 229);
    freq.put("zdo", 187);
    freq.put("is ", 52601);
    freq.put("mu\u0328", 3539);
    freq.put("zde", 65);
    freq.put("isy", 283);
    freq.put("mz\u030c", 705);
    freq.put("iss", 63);
    freq.put("isp", 344);
    freq.put("isv", 554);
    freq.put("isu", 1429);
    freq.put("ist", 10402);
    freq.put("isk", 1115);
    freq.put("isi", 2798);
    freq.put("ish", 114);
    freq.put("iso", 747);
    freq.put("ism", 716);
    freq.put("isl", 291);
    freq.put("isc", 198);
    freq.put("isa", 1339);
    freq.put("ise", 370);
    freq.put("isd", 71);
    freq.put("gyd", 154);
    freq.put("gyb", 293);
    freq.put("gyn", 197);
    freq.put("gyl", 77);
    freq.put("gyv", 4200);
    freq.put("gys", 254);
    freq.put("a\u0328si", 447);
    freq.put("ise\u0328", 115);
    freq.put("je\u0328 ", 118);
    freq.put("gz\u030cd", 845);
    freq.put("ise\u0307", 1814);
    freq.put("Izr", 81);
    freq.put("isa\u0328", 156);
    freq.put("do ", 2940);
    freq.put("tyl", 66);
    freq.put("tym", 1125);
    freq.put("tyn", 745);
    freq.put("tyj", 2629);
    freq.put("tyk", 592);
    freq.put("tyg", 105);
    freq.put("tyb", 2995);
    freq.put("tyt", 1130);
    freq.put("tyv", 1223);
    freq.put("tyr", 732);
    freq.put("tys", 1652);
    freq.put("doj", 2119);
    freq.put("dok", 455);
    freq.put("don", 1347);
    freq.put("dol", 160);
    freq.put("dom", 1366);
    freq.put("isu\u0328", 290);
    freq.put("m", 192290);
    freq.put("doe", 78);
    freq.put("dor", 1140);
    freq.put("dos", 2310);
    freq.put("dov", 1045);
    freq.put("dow", 94);
    freq.put("dot", 521);
    freq.put(" We", 123);
    freq.put(" Wa", 210);
    freq.put("Z ", 96);
    freq.put("sle\u0307", 668);
    freq.put(" Wi", 267);
    freq.put("me\u0307 ", 740);
    freq.put("ac\u030ci", 1928);
    freq.put("ac\u030ck", 85);
    freq.put("ac\u030ca", 64);
    freq.put("enu\u0328", 1350);
    freq.put("ba ", 7831);
    freq.put("me\u0307s", 1624);
    freq.put("me\u0307t", 142);
    freq.put("me\u0307g", 132);
    freq.put("me\u0307j", 427);
    freq.put("me\u0307n", 862);
    freq.put("me\u0307m", 110);
    freq.put("me\u0307l", 387);
    freq.put("bat", 206);
    freq.put("bau", 383);
    freq.put("bar", 1644);
    freq.put("bas", 1718);
    freq.put("ac\u030c ", 218);
    freq.put("baz", 180);
    freq.put("slu\u0328", 200);
    freq.put("bad", 71);
    freq.put("bac", 144);
    freq.put("ban", 1542);
    freq.put("bal", 1952);
    freq.put("bam", 151);
    freq.put("baj", 127);
    freq.put("bak", 168);
    freq.put("bai", 1573);
    freq.put("rz\u030cy", 332);
    freq.put("om ", 163);
    freq.put("iz\u030c", 716);
    freq.put("iu\u0328", 36065);
    freq.put("rz\u030cu", 185);
    freq.put("iu\u0304", 2482);
    freq.put("rz\u030co", 186);
    freq.put("Ve\u0307", 216);
    freq.put("is\u030c", 22230);
    freq.put("rz\u030ca", 90);
    freq.put("rz\u030ce", 425);
    freq.put("je\u0328s", 545);
    freq.put("Rum", 121);
    freq.put("Rug", 83);
    freq.put("Rud", 101);
    freq.put("un ", 91);
    freq.put("Rus", 1573);
    freq.put("kia\u0328", 80);
    freq.put("omb", 322);
    freq.put("oma", 4058);
    freq.put("ome", 2921);
    freq.put("kiu\u0328", 2205);
    freq.put("omi", 4219);
    freq.put("z\u030ce\u0307s", 302);
    freq.put("omo", 2822);
    freq.put("las\u030c", 117);
    freq.put("oms", 893);
    freq.put("omp", 1868);
    freq.put("omu", 462);
    freq.put("kis\u030c", 1820);
    freq.put("uns", 125);
    freq.put("Ju\u0328 ", 127);
    freq.put("unu", 78);
    freq.put("ie\u0307", 81);
    freq.put("una", 778);
    freq.put("unc", 101);
    freq.put("ic\u030c", 2386);
    freq.put("une", 377);
    freq.put("ung", 2769);
    freq.put("uni", 2717);
    freq.put("unk", 1010);
    freq.put("ia\u0328", 1524);
    freq.put("uno", 1046);
    freq.put("C ", 1065);
    freq.put("Ute", 210);
    freq.put("Ci", 314);
    freq.put("Ch", 1267);
    freq.put("Co", 831);
    freq.put("Cl", 158);
    freq.put("baz\u030c", 702);
    freq.put("slu", 296);
    freq.put("Ca", 774);
    freq.put("Ce", 857);
    freq.put("Cy", 71);
    freq.put("slo", 811);
    freq.put("sli", 978);
    freq.put("gla", 443);
    freq.put("Cr", 212);
    freq.put("sla", 1643);
    freq.put("Cu", 139);
    freq.put("ix", 156);
    freq.put("iz", 7107);
    freq.put("o\u0304 ", 76);
    freq.put("une\u0307", 100);
    freq.put("rz\u030cu\u0328", 128);
    freq.put("ip", 8649);
    freq.put("is", 76128);
    freq.put("ir", 43336);
    freq.put("iu", 21162);
    freq.put("it", 24630);
    freq.put("Nam", 132);
    freq.put("Nar", 128);
    freq.put("ih", 166);
    freq.put("ik", 38607);
    freq.put("ij", 49065);
    freq.put("im", 33709);
    freq.put("il", 20049);
    freq.put("Nat", 155);
    freq.put("Nau", 859);
    freq.put("ia", 66700);
    freq.put("ic", 4825);
    freq.put("ki ", 3521);
    freq.put("ie", 61163);
    freq.put("id", 19607);
    freq.put("ig", 7460);
    freq.put("if", 2042);
    freq.put("V ", 1768);
    freq.put("oma\u0328", 125);
    freq.put("ome\u0307", 233);
    freq.put("Dvi", 80);
    freq.put("kis", 920);
    freq.put("kir", 3853);
    freq.put("kip", 128);
    freq.put("Dva", 68);
    freq.put("kiv", 63);
    freq.put("kiu", 661);
    freq.put("Sva", 109);
    freq.put("\u0438\u0438\u0306 ", 71);
    freq.put("kij", 2691);
    freq.put("kio", 2376);
    freq.put("kin", 5088);
    freq.put("kim", 1590);
    freq.put("kil", 1486);
    freq.put("i ", 72374);
    freq.put("kia", 4293);
    freq.put("kie", 2272);
    freq.put("Va", 2935);
    freq.put("unu\u0328", 111);
    freq.put("Ve", 1368);
    freq.put("Vi", 4324);
    freq.put("Vl", 71);
    freq.put("Vo", 1251);
    freq.put("Vy", 520);
    freq.put("du\u0328 ", 1583);
    freq.put("nk ", 388);
    freq.put("e\u0307se", 1427);
    freq.put("e\u0307si", 184);
    freq.put("na\u0328 ", 1490);
    freq.put("e\u0307sn", 115);
    freq.put("op ", 190);
    freq.put("e\u0307st", 385);
    freq.put("opt", 255);
    freq.put("e\u0307s ", 35616);
    freq.put("na\u0328j", 98);
    freq.put("opr", 78);
    freq.put("ops", 178);
    freq.put("ope", 871);
    freq.put("opa", 456);
    freq.put("opl", 208);
    freq.put("opo", 1809);
    freq.put("oph", 333);
    freq.put("opi", 1192);
    freq.put("Du", 605);
    freq.put("Art", 193);
    freq.put("Ara", 258);
    freq.put("Arc", 130);
    freq.put("Are", 73);
    freq.put("Arg", 584);
    freq.put("Ari", 111);
    freq.put("Ark", 155);
    freq.put("Arm", 184);
    freq.put("www", 76);
    freq.put("z\u030ciu\u0304", 506);
    freq.put("utu\u0328", 550);
    freq.put("bra", 835);
    freq.put("ww ", 76);
    freq.put("zuo", 830);
    freq.put("zul", 113);
    freq.put("ope\u0307", 75);
    freq.put("Z", 1079);
    freq.put("e\u0307sc\u030c", 100);
    freq.put("ytu\u0328", 2089);
    freq.put("\u0441\u043a", 151);
    freq.put("\u0441\u0442", 86);
    freq.put("Win", 96);
    freq.put("Wil", 72);
    freq.put("ule\u0307", 940);
    freq.put("di ", 260);
    freq.put("uli\u0328", 98);
    freq.put("zdz\u030c", 483);
    freq.put("dil", 259);
    freq.put("dim", 1824);
    freq.put("din", 11534);
    freq.put("dio", 390);
    freq.put("dij", 4732);
    freq.put("dik", 613);
    freq.put("did", 3151);
    freq.put("die", 4136);
    freq.put("dif", 150);
    freq.put("dia", 454);
    freq.put("dic", 606);
    freq.put("diz", 157);
    freq.put("dit", 234);
    freq.put("diu", 103);
    freq.put("div", 255);
    freq.put("dip", 85);
    freq.put("dir", 773);
    freq.put("dis", 1529);
    freq.put("Gru", 297);
    freq.put("ez\u030ct", 146);
    freq.put("ez\u030cu", 89);
    freq.put(" Yo", 68);
    freq.put("sni\u0328", 163);
    freq.put("ez\u030ca", 160);
    freq.put("Gre", 184);
    freq.put("ez\u030cd", 87);
    freq.put("ez\u030ce", 2899);
    freq.put("Gra", 983);
    freq.put("Gro", 162);
    freq.put(" Yr", 183);
    freq.put("Gri", 532);
    freq.put("tne", 192);
    freq.put("sne\u0307", 370);
    freq.put("bo ", 831);
    freq.put("ge\u0307g", 66);
    freq.put("ge\u0307l", 263);
    freq.put("ju\u0304r", 1765);
    freq.put("ge\u0307j", 295);
    freq.put("mas\u030c", 150);
    freq.put("ju\u0304n", 185);
    freq.put("ge\u0307s", 1188);
    freq.put("nyc\u030c", 782);
    freq.put("tno", 94);
    freq.put(" ok", 189);
    freq.put("u\u0328ju\u0328", 1526);
    freq.put("bor", 294);
    freq.put("bos", 2270);
    freq.put("bot", 239);
    freq.put("boj", 747);
    freq.put("bok", 148);
    freq.put("bol", 1634);
    freq.put("bom", 266);
    freq.put("bon", 209);
    freq.put("bod", 66);
    freq.put("Su\u0304d", 82);
    freq.put("ke\u0307j", 853);
    freq.put("ke\u0307l", 172);
    freq.put("ke\u0307n", 99);
    freq.put("ke\u0307s", 2221);
    freq.put("ke\u0307t", 269);
    freq.put("S\u030ci ", 192);
    freq.put("ul ", 100);
    freq.put("ood", 82);
    freq.put("uar", 229);
    freq.put("Ben", 312);
    freq.put("Bel", 409);
    freq.put("ool", 67);
    freq.put("oor", 180);
    freq.put("Ber", 374);
    freq.put("Bet", 72);
    freq.put("ke\u0307 ", 1457);
    freq.put("uly", 692);
    freq.put("S\u030cip", 64);
    freq.put("uls", 117);
    freq.put("S\u030cir", 132);
    freq.put("S\u030cis", 287);
    freq.put("ulv", 76);
    freq.put("ay ", 151);
    freq.put("ult", 2376);
    freq.put("ulu", 205);
    freq.put("fli", 110);
    freq.put("ulk", 1598);
    freq.put("uli", 4261);
    freq.put("S\u030cil", 407);
    freq.put("S\u030cim", 69);
    freq.put("nz\u030ci", 161);
    freq.put("S\u030cio", 192);
    freq.put("fla", 74);
    freq.put("S\u030cia", 1607);
    freq.put("ula", 686);
    freq.put("S\u030cie", 85);
    freq.put("ule", 258);
    freq.put("ma ", 8966);
    freq.put("nyr", 226);
    freq.put("nys", 2919);
    freq.put("get", 168);
    freq.put("nyt", 99);
    freq.put("nyj", 775);
    freq.put("nyk", 427);
    freq.put("nyi", 66);
    freq.put("nyn", 1169);
    freq.put("aka\u0328", 119);
    freq.put("vu\u0304n", 458);
    freq.put("nyb", 586);
    freq.put("nyg", 399);
    freq.put("mas", 16980);
    freq.put("sne", 141);
    freq.put("mau", 158);
    freq.put("Ura", 110);
    freq.put("sna", 277);
    freq.put("sno", 220);
    freq.put("maz", 236);
    freq.put("sni", 2039);
    freq.put("Uru", 89);
    freq.put("mac", 657);
    freq.put("snu", 80);
    freq.put("mad", 111);
    freq.put("mag", 648);
    freq.put("ylo", 78);
    freq.put("mai", 3495);
    freq.put("mak", 310);
    freq.put("maj", 238);
    freq.put("mam", 360);
    freq.put("mal", 1077);
    freq.put("sny", 134);
    freq.put("zna", 91);
    freq.put("Ros", 182);
    freq.put("q", 282);
    freq.put("S\u030cv", 1543);
    freq.put("ny ", 199);
    freq.put("lsa", 135);
    freq.put("lso", 116);
    freq.put("lsk", 87);
    freq.put("lsi", 157);
    freq.put("lsv", 208);
    freq.put("lst", 3935);
    freq.put(" ab", 508);
    freq.put(" ac", 88);
    freq.put(" ad", 1540);
    freq.put(" ag", 258);
    freq.put(" ai", 453);
    freq.put(" ak", 1627);
    freq.put(" al", 1456);
    freq.put(" am", 912);
    freq.put(" an", 3700);
    freq.put(" ap", 10764);
    freq.put(" ar", 9760);
    freq.put(" as", 2056);
    freq.put(" at", 6438);
    freq.put(" au", 6951);
    freq.put(" av", 222);
    freq.put("ls ", 120);
    freq.put("u\u0304gi", 136);
    freq.put("u\u0304gn", 67);
    freq.put(" a ", 1580);
    freq.put("az\u030cu\u0328", 112);
    freq.put("Lua", 75);
    freq.put("ulu\u0328", 95);
    freq.put("Luk", 93);
    freq.put("or ", 364);
    freq.put("Ken", 88);
    freq.put("Kel", 250);
    freq.put("Du\u0304", 73);
    freq.put("Dz\u030c", 420);
    freq.put("Ket", 93);
    freq.put("Ker", 168);
    freq.put("G", 7812);
    freq.put("ory", 137);
    freq.put("orv", 193);
    freq.put("ort", 1674);
    freq.put("oru", 254);
    freq.put("ors", 672);
    freq.put("orp", 329);
    freq.put("orn", 376);
    freq.put("oro", 1427);
    freq.put("orl", 173);
    freq.put("orm", 3710);
    freq.put("ork", 297);
    freq.put("ori", 8425);
    freq.put("orf", 147);
    freq.put("org", 2280);
    freq.put("ord", 1011);
    freq.put("ore", 636);
    freq.put("orb", 205);
    freq.put("orc", 113);
    freq.put("ora", 1549);
    freq.put("Api", 205);
    freq.put("Apo", 92);
    freq.put("Apa", 86);
    freq.put("ua ", 181);
    freq.put(" as\u030c", 299);
    freq.put("z\u030ce\u0307 ", 79);
    freq.put("u\u0304gs\u030c", 200);
    freq.put(" S\u030ca", 886);
    freq.put(" S\u030ce", 340);
    freq.put(" S\u030ck", 111);
    freq.put(" S\u030ci", 3390);
    freq.put("lsc\u030c", 1443);
    freq.put(" S\u030co", 70);
    freq.put("z\u030ce\u0307j", 93);
    freq.put(" S\u030cl", 99);
    freq.put(" S\u030cr", 75);
    freq.put(" S\u030cv", 1543);
    freq.put(" S\u030cu", 220);
    freq.put(" S\u030ct", 147);
    freq.put("tu ", 2200);
    freq.put("ve\u0328 ", 211);
    freq.put("da\u0328 ", 495);
    freq.put("Dn", 85);
    freq.put("Do", 667);
    freq.put("Di", 2059);
    freq.put("ore\u0307", 417);
    freq.put("De", 900);
    freq.put("Da", 2187);
    freq.put("2", 445);
    freq.put("Dz", 157);
    freq.put("Dy", 151);
    freq.put("Dv", 187);
    freq.put("ora\u0328", 78);
    freq.put("Dr", 666);
    freq.put("ve\u0328s", 499);
    freq.put("oru\u0328", 130);
    freq.put("oru\u0304", 115);
    freq.put("yvu\u0328", 140);
    freq.put("D ", 380);
    freq.put("ge ", 442);
    freq.put("We", 128);
    freq.put("Wa", 211);
    freq.put("Wo", 154);
    freq.put("Wi", 274);
    freq.put("Wh", 63);
    freq.put("\u0430", 757);
    freq.put("az\u030ci\u0328", 104);
    freq.put("ges", 352);
    freq.put("ger", 1023);
    freq.put("S\u030ca", 886);
    freq.put("S\u030ce", 341);
    freq.put("S\u030ck", 111);
    freq.put("S\u030ci", 3391);
    freq.put("S\u030co", 70);
    freq.put("S\u030cl", 99);
    freq.put("S\u030cr", 75);
    freq.put("geb", 197);
    freq.put("geg", 248);
    freq.put("S\u030ct", 155);
    freq.put("S\u030cu", 220);
    freq.put("gei", 69);
    freq.put("geo", 416);
    freq.put("gen", 3944);
    freq.put("gem", 66);
    freq.put("gel", 1714);
    freq.put("W ", 71);
    freq.put("o\u0301", 158);
    freq.put("s\u030ca", 5331);
    freq.put("s\u030cb", 74);
    freq.put("s\u030ce", 5219);
    freq.put("s\u030cd", 199);
    freq.put("s\u030cg", 221);
    freq.put("s\u030ci", 16792);
    freq.put("s\u030ck", 10936);
    freq.put("s\u030cm", 981);
    freq.put("s\u030cl", 1712);
    freq.put("s\u030co", 2052);
    freq.put("s\u030cn", 613);
    freq.put("s\u030cp", 366);
    freq.put("s\u030cs", 1233);
    freq.put("s\u030cr", 983);
    freq.put("s\u030cu", 1367);
    freq.put("s\u030ct", 7877);
    freq.put("s\u030cv", 1932);
    freq.put("s\u030cy", 1194);
    freq.put("uja\u0328", 85);
    freq.put("le\u0307 ", 2188);
    freq.put("j ", 778);
    freq.put(" Ha", 877);
    freq.put("ain", 2341);
    freq.put("paz\u030c", 694);
    freq.put("pas\u030c", 357);
    freq.put(" He", 844);
    freq.put("ju", 6480);
    freq.put("u\u0328 ", 88718);
    freq.put("s\u030c ", 7298);
    freq.put("jy", 130);
    freq.put("tup", 188);
    freq.put("le\u0307s", 3311);
    freq.put("tur", 3389);
    freq.put("tus", 4707);
    freq.put("le\u0307v", 65);
    freq.put("le\u0307t", 585);
    freq.put("le\u0307j", 539);
    freq.put("le\u0307k", 280);
    freq.put("jo", 44031);
    freq.put("le\u0307n", 507);
    freq.put("ji", 8060);
    freq.put("le\u0307l", 106);
    freq.put("le\u0307m", 235);
    freq.put("je", 37765);
    freq.put("tub", 127);
    freq.put("tuc", 1071);
    freq.put("tud", 729);
    freq.put("pac\u030c", 638);
    freq.put("le\u0307d", 122);
    freq.put("tug", 166);
    freq.put(" Z\u030cu", 120);
    freq.put(" Z\u030cv", 178);
    freq.put("tui", 321);
    freq.put(" Z\u030cy", 115);
    freq.put("uju\u0328", 216);
    freq.put(" Z\u030ce", 954);
    freq.put("tuk", 242);
    freq.put(" Z\u030ca", 482);
    freq.put("dka", 165);
    freq.put(" Z\u030cm", 91);
    freq.put(" Z\u030ci", 399);
    freq.put("tum", 1081);
    freq.put("aik", 6012);
    freq.put("tuo", 4132);
    freq.put("tua", 342);
    freq.put("le\u0307g", 91);
    freq.put("az\u030cu", 326);
    freq.put("z\u030cka", 118);
    freq.put("az\u030cy", 107);
    freq.put("az\u030cd", 237);
    freq.put("az\u030ce", 494);
    freq.put("az\u030ca", 639);
    freq.put("az\u030cn", 2141);
    freq.put("az\u030co", 516);
    freq.put("\u56fd", 86);
    freq.put("az\u030ci", 1113);
    freq.put("s\u030cu\u0304", 280);
    freq.put("s\u030cu\u0328", 238);
    freq.put("ji\u0328", 548);
    freq.put("c\u030cu\u0328 ", 69);
    freq.put("pap", 2360);
    freq.put("par", 5103);
    freq.put("pas", 6180);
    freq.put("pat", 3653);
    freq.put("pau", 1209);
    freq.put("pav", 2954);
    freq.put("u\u0328j", 1568);
    freq.put("je\u0307", 931);
    freq.put("paa", 84);
    freq.put("pab", 319);
    freq.put("pac", 165);
    freq.put("pad", 1171);
    freq.put("pag", 4995);
    freq.put("ke\u0328s", 421);
    freq.put("ja\u0328", 2263);
    freq.put("paj", 498);
    freq.put("pak", 1745);
    freq.put("pal", 2163);
    freq.put("pam", 953);
    freq.put("pan", 2096);
    freq.put("nac", 1442);
    freq.put("oid", 309);
    freq.put("S\u030cko", 96);
    freq.put("s\u030ci\u0328", 142);
    freq.put("ju\u0328", 7476);
    freq.put("ju\u0304", 2283);
    freq.put("tus\u030c", 104);
    freq.put("le\u0307s\u030c", 194);
    freq.put("s\u030ca\u0328", 98);
    freq.put("uju", 231);
    freq.put("ke\u0328 ", 172);
    freq.put("s\u030cc\u030c", 2693);
    freq.put("pa ", 504);
    freq.put("ujo", 901);
    freq.put("uji", 238);
    freq.put("s\u030ce\u0307", 408);
    freq.put("uje", 2229);
    freq.put("uja", 1817);
    freq.put("a\u0328ji\u0328", 197);
    freq.put("vid", 2656);
    freq.put("mo ", 11787);
    freq.put("a\u0328ja\u0328", 384);
    freq.put("mos", 8683);
    freq.put("mor", 477);
    freq.put("mot", 735);
    freq.put("mok", 6158);
    freq.put("moj", 1912);
    freq.put("mon", 3483);
    freq.put("mom", 231);
    freq.put("mol", 407);
    freq.put("moc", 111);
    freq.put("mob", 923);
    freq.put("mog", 880);
    freq.put("mod", 511);
    freq.put("km2", 423);
    freq.put("Nem", 374);
    freq.put("Nev", 213);
    freq.put("New", 68);
    freq.put("Net", 114);
    freq.put("Neu", 81);
    freq.put("Ner", 231);
    freq.put("Nep", 196);
    freq.put("Med", 222);
    freq.put("kme", 718);
    freq.put(" ci", 727);
    freq.put(" co", 131);
    freq.put(" cm", 466);
    freq.put("Mel", 164);
    freq.put("Men", 159);
    freq.put("s\u030ce\u0307s", 100);
    freq.put("kmi", 91);
    freq.put(" ce", 2733);
    freq.put("Met", 158);
    freq.put("kmu", 184);
    freq.put("s\u030ce\u0307j", 66);
    freq.put("Mes", 186);
    freq.put("Mer", 401);
    freq.put("Mez", 64);
    freq.put("\u0447", 71);
    freq.put("Dru", 132);
    freq.put("Dri", 158);
    freq.put("Dra", 241);
    freq.put("z\u030car", 129);
    freq.put("z\u030cas", 486);
    freq.put("km ", 5939);

    init2();
  }
  private static void init2() {
    
    freq.put("VD ", 82);
    freq.put("z\u030cai", 1499);
    freq.put("z\u030can", 496);
    freq.put("z\u030cal", 557);
    freq.put("s\u030ce\u0307 ", 158);
    freq.put("ne\u0328 ", 1530);
    freq.put("te\u0328 ", 460);
    freq.put("Upe\u0307", 66);
    freq.put("ne\u0328s", 68);
    freq.put("na ", 6125);
    freq.put("e", 363311);
    freq.put("Af", 806);
    freq.put("Ai", 520);
    freq.put("Avi", 81);
    freq.put("te\u0328s", 608);
    freq.put("sve", 370);
    freq.put("dva", 622);
    freq.put("Al", 1985);
    freq.put("es\u030ci", 2201);
    freq.put("sva", 1159);
    freq.put("Au", 2682);
    freq.put("svy", 123);
    freq.put("kme\u0307", 162);
    freq.put("Az", 731);
    freq.put("u", 266546);
    freq.put("Vak", 682);
    freq.put("Vai", 313);
    freq.put("Van", 212);
    freq.put("Val", 695);
    freq.put("iu ", 2871);
    freq.put("Vad", 65);
    freq.put("Var", 578);
    freq.put("Vas", 102);
    freq.put("gr", 11904);
    freq.put("ws ", 91);
    freq.put("\u0438", 579);
    freq.put("iui", 902);
    freq.put("iuk", 566);
    freq.put("iuj", 1926);
    freq.put("ium", 511);
    freq.put("iul", 202);
    freq.put("iuo", 4507);
    freq.put("iun", 199);
    freq.put("iuc", 232);
    freq.put("iub", 80);
    freq.put("iud", 174);
    freq.put("iuz", 146);
    freq.put("got", 295);
    freq.put("ius", 6964);
    freq.put("iur", 510);
    freq.put("iut", 1006);
    freq.put("iuv", 85);
    freq.put("as\u030ce", 79);
    freq.put("as\u030ca", 470);
    freq.put("as\u030cm", 98);
    freq.put("as\u030cl", 96);
    freq.put("as\u030co", 756);
    freq.put("as\u030ci", 756);
    freq.put("as\u030ck", 334);
    freq.put("as\u030cu", 283);
    freq.put("as\u030ct", 1920);
    freq.put("SI ", 77);
    freq.put("hyt", 188);
    freq.put("des\u030c", 1558);
    freq.put("as\u030cy", 781);
    freq.put("Gin", 94);
    freq.put("aba", 2740);
    freq.put("gl", 2484);
    freq.put("abe", 207);
    freq.put("abi", 1011);
    freq.put("abl", 158);
    freq.put("rys\u030c", 526);
    freq.put("ryz\u030c", 454);
    freq.put("\u0430 ", 158);
    freq.put("abs", 143);
    freq.put("abu", 396);
    freq.put("abz", 181);
    freq.put("ryc\u030c", 1308);
    freq.put("K", 17851);
    freq.put("akv", 76);
    freq.put("ab ", 182);
    freq.put("a\u0300", 65);
    freq.put("upe\u0328", 254);
    freq.put("as\u030cc\u030c", 176);
    freq.put("Vas\u030c", 70);
    freq.put("as\u030ce\u0307", 95);
    freq.put("de ", 955);
    freq.put("ius\u030c", 73);
    freq.put("ey ", 158);
    freq.put("lbe\u0307", 158);
    freq.put("dep", 764);
    freq.put("der", 1524);
    freq.put("des", 572);
    freq.put("det", 124);
    freq.put("dev", 201);
    freq.put("dei", 369);
    freq.put("dek", 567);
    freq.put("del", 1942);
    freq.put("dem", 709);
    freq.put("den", 3068);
    freq.put("deo", 162);
    freq.put("dea", 123);
    freq.put("deb", 268);
    freq.put("ded", 1735);
    freq.put("deg", 595);
    freq.put("usa\u0328", 115);
    freq.put("ryn", 188);
    freq.put("ryo", 78);
    freq.put("ryl", 68);
    freq.put("rym", 161);
    freq.put("ryj", 340);
    freq.put("ryk", 138);
    freq.put("ryd", 120);
    freq.put("ryb", 1588);
    freq.put("abu\u0328", 128);
    freq.put("ryt", 5807);
    freq.put("rys", 1185);
    freq.put("ryp", 869);
    freq.put("Don", 122);
    freq.put("Dom", 99);
    freq.put("Dod", 83);
    freq.put("abe\u0307", 174);
    freq.put("je\u0328", 663);
    freq.put("ry ", 248);
    freq.put("ok ", 122);
    freq.put(" es\u030c", 161);
    freq.put(" ez\u030c", 2821);
    freq.put("pci", 139);
    freq.put("pu", 6072);
    freq.put("oks", 1989);
    freq.put("okr", 516);
    freq.put("oku", 1484);
    freq.put("Bas", 130);
    freq.put("uha", 63);
    freq.put("oky", 4231);
    freq.put("oka", 1176);
    freq.put("Bag", 85);
    freq.put("Bad", 64);
    freq.put("Bab", 93);
    freq.put("pai", 635);
    freq.put("Ban", 272);
    freq.put("Bal", 1866);
    freq.put("u\u0304ks\u030c", 76);
    freq.put("okl", 512);
    freq.put("oko", 845);
    freq.put("Bai", 88);
    freq.put("ka\u0328", 1329);
    freq.put("kc\u030c", 96);
    freq.put("ke\u0307", 5197);
    freq.put("ke\u0328", 593);
    freq.put("mm ", 215);
    freq.put("ki\u0328", 293);
    freq.put("E ", 242);
    freq.put("\u044f", 147);
    freq.put("Uni", 208);
    freq.put("Em", 143);
    freq.put("El", 573);
    freq.put("ks\u030c", 7202);
    freq.put("En", 323);
    freq.put("Ei", 125);
    freq.put("Ek", 234);
    freq.put("ku\u0304", 2551);
    freq.put("Ed", 144);
    freq.put("Eg", 301);
    freq.put("ku\u0328", 5621);
    freq.put("Ex", 73);
    freq.put("Eu", 1613);
    freq.put("Et", 189);
    freq.put("Ev", 98);
    freq.put("Ep", 87);
    freq.put("Es", 386);
    freq.put("Er", 363);
    freq.put("oki\u0328", 63);
    freq.put(" el", 1508);
    freq.put("koh", 148);
    freq.put(" en", 778);
    freq.put("koj", 2216);
    freq.put("kom", 3814);
    freq.put(" ei", 683);
    freq.put("koo", 136);
    freq.put(" ek", 915);
    freq.put("X ", 603);
    freq.put(" eg", 645);
    freq.put("kod", 1418);
    freq.put(" et", 431);
    freq.put("kop", 332);
    freq.put("kos", 8611);
    freq.put("kor", 653);
    freq.put(" ep", 239);
    freq.put("kot", 816);
    freq.put(" er", 623);
    freq.put("kov", 891);
    freq.put("oku\u0328", 103);
    freq.put("Baz\u030c", 77);
    freq.put("u\u0304ks", 471);
    freq.put("oks\u030c", 697);
    freq.put("u\u0304kl", 137);
    freq.put("Slo", 158);
    freq.put("u\u0304ki", 544);
    freq.put("u\u0304ka", 130);
    freq.put("b", 73275);
    freq.put("ko ", 5671);
    freq.put(" e ", 82);
    freq.put("\u2212 ", 502);
    freq.put("k ", 2911);
    freq.put("pju\u0304", 231);
    freq.put("Kir", 183);
    freq.put("Kip", 63);
    freq.put("Kit", 124);
    freq.put("Kin", 537);
    freq.put("Kil", 126);
    freq.put("Kie", 93);
    freq.put("Atl", 385);
    freq.put("Ats", 131);
    freq.put("sa\u0328s", 356);
    freq.put("kc", 1366);
    freq.put("ka", 55987);
    freq.put("kg", 90);
    freq.put("ke", 8017);
    freq.put("kd", 1358);
    freq.put("ki", 36060);
    freq.put("kh", 180);
    freq.put("ko", 29827);
    freq.put("kn", 695);
    freq.put("km", 7611);
    freq.put("kl", 14764);
    freq.put("ks", 8217);
    freq.put("kr", 12212);
    freq.put("Ez\u030c", 273);
    freq.put("kv", 1386);
    freq.put("ku", 20625);
    freq.put("kt", 10687);
    freq.put("ky", 6899);
    freq.put("s\u030cde\u0307", 102);
    freq.put("lz\u030ci", 190);
    freq.put("siu\u0304", 210);
    freq.put("kty", 770);
    freq.put("ph", 742);
    freq.put(" Be", 1541);
    freq.put(" Ba", 3796);
    freq.put(" Bl", 291);
    freq.put(" Bo", 1202);
    freq.put(" Bi", 835);
    freq.put("yda", 247);
    freq.put(" Bu", 1122);
    freq.put("ik ", 1008);
    freq.put(" Br", 1443);
    freq.put("\u0430\u043b", 63);
    freq.put("\u0430\u043d", 71);
    freq.put("\u03ba", 65);
    freq.put("iks", 1325);
    freq.put("ikr", 1885);
    freq.put(" B ", 160);
    freq.put("e\u0307z\u030ct", 110);
    freq.put("ikt", 1187);
    freq.put("iky", 490);
    freq.put("\u0430\u0440", 72);
    freq.put("ike", 332);
    freq.put("kte", 286);
    freq.put("iki", 8010);
    freq.put("e\u0307z\u030ci", 636);
    freq.put("iko", 8237);
    freq.put("ikm", 102);
    freq.put("ikl", 4355);
    freq.put("lbu", 643);
    freq.put("ga ", 2878);
    freq.put("be\u0307s", 4168);
    freq.put("be\u0307t", 104);
    freq.put("ran", 8258);
    freq.put("be\u0307c", 110);
    freq.put("be\u0307g", 144);
    freq.put("be\u0307j", 670);
    freq.put("be\u0307m", 94);
    freq.put("be\u0307n", 81);
    freq.put("gav", 268);
    freq.put("gau", 1337);
    freq.put("gat", 335);
    freq.put("gas", 1974);
    freq.put("gar", 1729);
    freq.put("gan", 3227);
    freq.put("gam", 2232);
    freq.put("gal", 9014);
    freq.put("gai", 1374);
    freq.put("gad", 87);
    freq.put("gac", 108);
    freq.put("gab", 134);
    freq.put("lba", 2195);
    freq.put("fut", 1079);
    freq.put("be\u0307 ", 1092);
    freq.put("fun", 535);
    freq.put("rar", 206);
    freq.put(" Bu\u0304", 168);
    freq.put("Ira", 230);
    freq.put("\u0421", 93);
    freq.put("ike\u0307", 859);
    freq.put("ike\u0328", 172);
    freq.put("ika\u0328", 480);
    freq.put("iku\u0328", 1702);
    freq.put("syb", 334);
    freq.put("dge", 113);
    freq.put("syk", 221);
    freq.put("cea", 1680);
    freq.put("syn", 63);
    freq.put("sys", 136);
    freq.put("iks\u030c", 1311);
    freq.put("syv", 319);
    freq.put("syt", 71);
    freq.put("iku\u0304", 653);
    freq.put("ew ", 79);
    freq.put("Te", 1633);
    freq.put("y", 92511);
    freq.put("lda", 470);
    freq.put("lde", 301);
    freq.put("ldi", 380);
    freq.put("ldo", 1438);
    freq.put("bi ", 151);
    freq.put("ldu", 86);
    freq.put("ldy", 3239);
    freq.put("nsu\u0328", 145);
    freq.put("cus", 68);
    freq.put("rgu", 182);
    freq.put("rga", 2638);
    freq.put("rge", 1017);
    freq.put("rgi", 812);
    freq.put("cul", 112);
    freq.put("rgl", 72);
    freq.put("rgo", 391);
    freq.put("bin", 2312);
    freq.put("bio", 445);
    freq.put("bil", 1165);
    freq.put("ld ", 140);
    freq.put("bij", 590);
    freq.put("bik", 90);
    freq.put("Did", 1104);
    freq.put("Die", 275);
    freq.put("bie", 263);
    freq.put("bib", 123);
    freq.put("Dia", 66);
    freq.put("bia", 875);
    freq.put("bit", 262);
    freq.put("biu", 413);
    freq.put("bir", 575);
    freq.put("bis", 206);
    freq.put("Dir", 98);
    freq.put("Dis", 102);
    freq.put("edu\u0328", 106);
    freq.put("\u2212", 522);
    freq.put("e\u0307da", 433);
    freq.put("e\u0307di", 261);
    freq.put("e\u0307do", 412);
    freq.put("pet", 193);
    freq.put("Ju\u0304r", 171);
    freq.put("Maz\u030c", 500);
    freq.put("pel", 1215);
    freq.put("pen", 679);
    freq.put("u\u0304mu\u0328", 111);
    freq.put("pei", 362);
    freq.put("pek", 276);
    freq.put("ped", 487);
    freq.put("pec", 747);
    freq.put(" ge\u0307", 342);
    freq.put("ufo", 165);
    freq.put("Bor", 174);
    freq.put("Bos", 142);
    freq.put("Bot", 70);
    freq.put("use", 242);
    freq.put("oeu", 79);
    freq.put("oet", 66);
    freq.put("Bol", 312);
    freq.put("Bon", 72);
    freq.put("oel", 84);
    freq.put("\u03c2 ", 168);
    freq.put("a\u0308", 96);
    freq.put("uso", 1941);
    freq.put("pe ", 192);
    freq.put("usm", 292);
    freq.put("nsi", 456);
    freq.put("nsk", 533);
    freq.put("nsl", 149);
    freq.put("nso", 235);
    freq.put("nsa", 277);
    freq.put("nse", 182);
    freq.put("nsp", 335);
    freq.put("nst", 1864);
    freq.put("ldz\u030c", 460);
    freq.put("rgu\u0328", 68);
    freq.put("usv", 157);
    freq.put("rgz\u030c", 70);
    freq.put("uss", 74);
    freq.put(" R ", 90);
    freq.put("rge\u0307", 150);
    freq.put("ns ", 1187);
    freq.put("bis\u030c", 132);
    freq.put("sda", 106);
    freq.put("Flo", 97);
    freq.put("biu\u0328", 787);
    freq.put("lde\u0307", 95);
    freq.put("lyt", 728);
    freq.put("lyv", 644);
    freq.put("lyp", 129);
    freq.put("lys", 1218);
    freq.put("lyd", 329);
    freq.put("lyg", 1880);
    freq.put("lyb", 79);
    freq.put("lym", 88);
    freq.put("lyn", 910);
    freq.put("e\u0307dz\u030c", 122);
    freq.put("lyk", 200);
    freq.put(" gv", 148);
    freq.put("Mas", 288);
    freq.put("Mar", 1387);
    freq.put(" gr", 5317);
    freq.put("Mat", 219);
    freq.put("u\u0304ma", 254);
    freq.put("u\u0304mi", 118);
    freq.put(" gy", 4128);
    freq.put("Mac", 86);
    freq.put(" ge", 4705);
    freq.put("Mad", 147);
    freq.put("Mag", 384);
    freq.put(" ga", 6719);
    freq.put("Mai", 142);
    freq.put(" go", 132);
    freq.put(" gl", 388);
    freq.put("Maj", 79);
    freq.put("Mal", 406);
    freq.put("zu\u0304r", 65);
    freq.put(" gi", 1781);
    freq.put(" ch", 821);
    freq.put("ly ", 90);
    freq.put("z\u030cet", 91);
    freq.put("z\u030cer", 3193);
    freq.put("z\u030ces", 178);
    freq.put("z\u030cen", 275);
    freq.put("z\u030cel", 344);
    freq.put("z\u030cem", 2279);
    freq.put(" g ", 911);
    freq.put("e\u0307de\u0307", 151);
    freq.put(" b", 21159);
    freq.put(" c", 5176);
    freq.put(" a", 48847);
    freq.put(" f", 7201);
    freq.put(" g", 24899);
    freq.put(" d", 33767);
    freq.put(" e", 11412);
    freq.put(" j", 10300);
    freq.put(" k", 69096);
    freq.put(" h", 2325);
    freq.put(" i", 50039);
    freq.put(" n", 26364);
    freq.put(" o", 7927);
    freq.put(" l", 18168);
    freq.put(" m", 39544);
    freq.put(" r", 27511);
    freq.put(" Dz\u030c", 420);
    freq.put(" p", 74653);
    freq.put(" v", 43820);
    freq.put("Mek", 335);
    freq.put(" t", 37056);
    freq.put(" u", 9812);
    freq.put(" z", 358);
    freq.put(" x", 101);
    freq.put(" y", 9991);
    freq.put(" B", 10949);
    freq.put(" C", 5111);
    freq.put(" A", 19385);
    freq.put(" F", 3572);
    freq.put(" G", 7762);
    freq.put(" D", 8642);
    freq.put(" E", 5548);
    freq.put(" J", 8568);
    freq.put(" K", 17825);
    freq.put(" H", 3382);
    freq.put(" I", 6930);
    freq.put(" N", 7489);
    freq.put(" O", 2834);
    freq.put(" L", 15878);
    freq.put(" M", 12380);
    freq.put(" R", 10064);
    freq.put(" S", 16766);
    freq.put(" P", 20081);
    freq.put(" Q", 106);
    freq.put(" V", 11305);
    freq.put(" W", 927);
    freq.put(" T", 11383);
    freq.put(" U", 2992);
    freq.put(" Z", 1072);
    freq.put(" X", 1253);
    freq.put(" Y", 439);
    freq.put("Azi", 595);
    freq.put("Aze", 82);
    freq.put(" De\u0307", 110);
    freq.put(" cu", 64);
    freq.put("kik", 107);
    freq.put("Oro", 67);
    freq.put("Ori", 91);
    freq.put("Org", 75);
    freq.put("ock", 185);
    freq.put("cu\u0304z", 939);
    freq.put(" Do", 658);
    freq.put(" Dn", 85);
    freq.put(" S\u030c", 7067);
    freq.put(" s\u030c", 19822);
    freq.put("Ver", 344);
    freq.put("Ves", 109);
    freq.put(" Di", 2044);
    freq.put(" U\u0304", 76);
    freq.put(" u\u0304", 618);
    freq.put(" De", 898);
    freq.put(" Da", 2178);
    freq.put(" u\u0328", 74);
    freq.put(" Dz", 157);
    freq.put(" Dy", 151);
    freq.put("Ven", 367);
    freq.put(" Dv", 187);
    freq.put(" Du", 604);
    freq.put(" z\u030c", 11466);
    freq.put(" Dr", 663);
    freq.put("Vei", 167);
    freq.put("cha", 955);
    freq.put("Fr", 454);
    freq.put("che", 1211);
    freq.put("chi", 1035);
    freq.put("chl", 85);
    freq.put("chm", 91);
    freq.put("chn", 602);
    freq.put("cho", 966);
    freq.put("Fa", 428);
    freq.put("chr", 188);
    freq.put("chs", 167);
    freq.put("cht", 194);
    freq.put("chu", 89);
    freq.put("Fi", 559);
    freq.put("Fl", 218);
    freq.put("Fo", 751);
    freq.put("se\u0307k", 228);
    freq.put("se\u0307j", 581);
    freq.put(" I\u0328", 722);
    freq.put(" i\u0328", 17189);
    freq.put(" D ", 97);
    freq.put("iid", 108);
    freq.put("yz\u030ci", 382);
    freq.put("iim", 317);
    freq.put("se\u0307s", 2025);
    freq.put("se\u0307t", 101);
    freq.put("ch ", 208);
    freq.put(" a\u0328", 118);
    freq.put(" C\u030c", 1561);
    freq.put(" c\u030c", 811);
    freq.put("F ", 250);
    freq.put(" e\u0307", 303);
    freq.put("ze\u0328 ", 74);
    freq.put("AB ", 129);
    freq.put("afo", 102);
    freq.put("afi", 672);
    freq.put("Yo", 68);
    freq.put("afa", 115);
    freq.put("afy", 94);
    freq.put("aft", 132);
    freq.put("zu\u0328", 230);
    freq.put("afr", 63);
    freq.put("da ", 3356);
    freq.put("lf", 324);
    freq.put("lg", 3321);
    freq.put("ld", 6869);
    freq.put("le", 15356);
    freq.put("lb", 5099);
    freq.put("lc", 275);
    freq.put("euk", 102);
    freq.put("la", 33178);
    freq.put("ln", 7253);
    freq.put("eud", 63);
    freq.put("oge\u0307", 746);
    freq.put("lm", 1772);
    freq.put("lj", 376);
    freq.put("lk", 4623);
    freq.put("lh", 105);
    freq.put("li", 63975);
    freq.put("lv", 2437);
    freq.put("lt", 6648);
    freq.put("lu", 5702);
    freq.put("ls", 6461);
    freq.put("lp", 828);
    freq.put("eut", 158);
    freq.put("tst", 1087);
    freq.put("lz", 63);
    freq.put("eus", 130);
    freq.put("ly", 8935);
    freq.put("dad", 96);
    freq.put("dae", 1242);
    freq.put("dag", 146);
    freq.put("dab", 1199);
    freq.put("dac", 195);
    freq.put("dal", 5226);
    freq.put("dam", 1100);
    freq.put("dan", 2672);
    freq.put("udz\u030c", 589);
    freq.put("dai", 1928);
    freq.put("ogu\u0328", 154);
    freq.put("dak", 155);
    freq.put("dat", 189);
    freq.put("dau", 2555);
    freq.put("dav", 1026);
    freq.put("dar", 5510);
    freq.put("das", 3048);
    freq.put("l ", 5566);
    freq.put("ts ", 284);
    freq.put("\u0435 ", 76);
    freq.put("lie", 4974);
    freq.put("lfa", 89);
    freq.put("lfi", 69);
    freq.put("a\u0328j", 1470);
    freq.put("Pas\u030c", 81);
    freq.put("rez", 564);
    freq.put("rer", 127);
    freq.put("res", 1263);
    freq.put("rep", 489);
    freq.put("rev", 180);
    freq.put("ret", 1342);
    freq.put("rej", 92);
    freq.put("rek", 801);
    freq.put("rei", 3237);
    freq.put("ren", 2189);
    freq.put("reo", 63);
    freq.put("rel", 806);
    freq.put("rem", 808);
    freq.put("reb", 105);
    freq.put("rec", 183);
    freq.put("miu\u0328", 389);
    freq.put("rea", 608);
    freq.put("ref", 432);
    freq.put("reg", 2937);
    freq.put("red", 291);
    freq.put("ree", 109);
    freq.put("que", 92);
    freq.put("qui", 80);
    freq.put("emy", 348);
    freq.put("s\u030cu\u0304n", 177);
    freq.put("ta ", 7677);
    freq.put("re ", 1146);
    freq.put("Z\u030c", 2451);
    freq.put("p ", 5826);
    freq.put("og ", 261);
    freq.put("ls\u030c", 275);
    freq.put("lu\u0304", 569);
    freq.put("nuv", 180);
    freq.put("lu\u0328", 4078);
    freq.put("lz\u030c", 345);
    freq.put("udr", 145);
    freq.put("la\u0328", 1161);
    freq.put("udu", 90);
    freq.put("ogu", 324);
    freq.put("lc\u030c", 267);
    freq.put("ogs", 78);
    freq.put("ogr", 2210);
    freq.put("ogl", 119);
    freq.put("ogo", 286);
    freq.put("ogn", 64);
    freq.put("ogi", 3408);
    freq.put("ude", 508);
    freq.put("oge", 235);
    freq.put("daz\u030c", 1194);
    freq.put("udi", 1843);
    freq.put("oga", 839);
    freq.put("udo", 3114);
    freq.put("le\u0328", 789);
    freq.put("Pel", 183);
    freq.put("li\u0328", 874);
    freq.put("Pen", 132);
    freq.put("Pap", 991);
    freq.put("Par", 1014);
    freq.put("Pas", 767);
    freq.put("Pat", 292);
    freq.put("Pau", 206);
    freq.put("Pav", 466);
    freq.put("Pab", 107);
    freq.put("Pad", 139);
    freq.put("Pag", 484);
    freq.put("Paj", 94);
    freq.put("Pak", 297);
    freq.put("Pal", 1658);
    freq.put("Pam", 122);
    freq.put("Pan", 697);
    freq.put("mik", 627);
    freq.put("mij", 1021);
    freq.put("rez\u030c", 195);
    freq.put("mil", 606);
    freq.put("mio", 695);
    freq.put("min", 8866);
    freq.put("mia", 1046);
    freq.put("mic", 65);
    freq.put("mie", 3684);
    freq.put("mid", 149);
    freq.put("mig", 185);
    freq.put("si ", 5878);
    freq.put("mis", 3697);
    freq.put("mir", 512);
    freq.put("miu", 166);
    freq.put("mit", 1456);
    freq.put("a\u0328ja", 230);
    freq.put("vu\u0328 ", 1432);
    freq.put("sfo", 80);
    freq.put("rec\u030c", 569);
    freq.put("sfe", 280);
    freq.put("mi ", 2927);
    freq.put("ysc\u030c", 138);
    freq.put("a\u0328ju", 613);
    freq.put("pa\u0328 ", 193);
    freq.put("ksu", 217);
    freq.put("kst", 1638);
    freq.put(" iz", 109);
    freq.put("ksp", 237);
    freq.put("Mos", 65);
    freq.put("Mor", 209);
    freq.put(" ir", 24988);
    freq.put(" is", 1471);
    freq.put(" it", 186);
    freq.put("Mot", 313);
    freq.put("kse", 134);
    freq.put(" ik", 3172);
    freq.put(" il", 1403);
    freq.put("Mon", 426);
    freq.put(" in", 5586);
    freq.put("Mol", 370);
    freq.put("ksm", 470);
    freq.put("ksl", 1822);
    freq.put("kso", 492);
    freq.put("ksn", 481);
    freq.put("ksi", 1031);
    freq.put(" ie", 140);
    freq.put(" \u0421", 93);
    freq.put("ks ", 271);
    freq.put("uz\u030ce\u0307", 257);
    freq.put("te\u0307 ", 2107);
    freq.put(" Iz", 149);
    freq.put("Ve\u0307l", 110);
    freq.put("ioc\u030c", 215);
    freq.put("nis\u030c", 1026);
    freq.put("te\u0307j", 863);
    freq.put("te\u0307n", 94);
    freq.put("te\u0307l", 64);
    freq.put("te\u0307m", 94);
    freq.put("te\u0307s", 2264);
    freq.put("S", 16914);
    freq.put("te\u0307v", 185);
    freq.put(" Iv", 74);
    freq.put("vro", 160);
    freq.put("ws", 118);
    freq.put("uz\u030ca", 101);
    freq.put("uz\u030cd", 391);
    freq.put("uz\u030ce", 68);
    freq.put("uz\u030ci", 622);
    freq.put("uz\u030ck", 126);
    freq.put("uic", 69);
    freq.put("re\u0328 ", 1445);
    freq.put("uz\u030cp", 129);
    freq.put("uz\u030cr", 186);
    freq.put("oho", 167);
    freq.put("uz\u030ct", 281);
    freq.put("uz\u030cu", 95);
    freq.put("uid", 65);
    freq.put("ksu\u0328", 107);
    freq.put("ys ", 5011);
    freq.put("Hon", 129);
    freq.put("ohe", 76);
    freq.put(" is\u030c", 11701);
    freq.put("ak", 21549);
    freq.put("uz\u030c ", 1010);
    freq.put("aj", 9247);
    freq.put("cop", 83);
    freq.put("cos", 201);
    freq.put("oha", 70);
    freq.put("cor", 163);
    freq.put("ksc\u030c", 304);
    freq.put("uin", 83);
    freq.put("re\u0328s", 410);
    freq.put("ysk", 104);
    freq.put("ysi", 1379);
    freq.put("ysl", 216);
    freq.put("uis", 152);
    freq.put("yse", 638);
    freq.put("au", 60068);
    freq.put("yst", 1756);
    freq.put(" Fr", 454);
    freq.put(" Fu", 218);
    freq.put(" Fa", 424);
    freq.put(" Fe", 541);
    freq.put(" Fi", 557);
    freq.put("ma\u0328j", 193);
    freq.put(" Fl", 215);
    freq.put(" Fo", 747);
    freq.put("io ", 24537);
    freq.put("uiz", 104);
    freq.put("SO ", 120);
    freq.put("ilp", 157);
    freq.put("iov", 183);
    freq.put("iot", 445);
    freq.put("ios", 8346);
    freq.put("ior", 133);
    freq.put("iop", 388);
    freq.put("ion", 5845);
    freq.put("iom", 700);
    freq.put("iol", 667);
    freq.put("iok", 271);
    freq.put("ioj", 3109);
    freq.put("iog", 457);
    freq.put("iod", 332);
    freq.put("ioc", 68);
    freq.put(" id", 308);
    freq.put("con", 95);
    freq.put("ze\u0307 ", 373);
    freq.put("\u0435\u0440", 72);
    freq.put("adv", 445);
    freq.put("adu", 285);
    freq.put("adr", 251);
    freq.put("gma", 128);
    freq.put("gme", 171);
    freq.put("ady", 144);
    freq.put("ade", 803);
    freq.put("ada", 1767);
    freq.put("ado", 1953);
    freq.put("rsu\u0328", 124);
    freq.put("\u043c", 156);
    freq.put("adi", 7918);
    freq.put("buz\u030c", 82);
    freq.put("fys", 93);
    freq.put("ze\u0307s", 255);
    freq.put("\u0435\u043d", 65);
    freq.put("U\u0304", 76);
    freq.put("ad ", 1165);
    freq.put("LR ", 167);
    freq.put("nja", 76);
    freq.put("ybu\u0328", 501);
    freq.put("ui ", 2863);
    freq.put("pis\u030c", 241);
    freq.put("njo", 112);
    freq.put("us\u030ct", 63);
    freq.put("us\u030ci", 396);
    freq.put("us\u030ck", 90);
    freq.put("us\u030ca", 109);
    freq.put("piu\u0328", 716);
    freq.put("a\u0328m", 118);
    freq.put("a\u0328l", 250);
    freq.put("esu", 549);
    freq.put("est", 4994);
    freq.put("ess", 157);
    freq.put("esp", 1704);
    freq.put("esy", 202);
    freq.put("Ji\u0328 ", 73);
    freq.put("tma", 182);
    freq.put("ese", 290);
    freq.put("tme", 480);
    freq.put("esa", 2125);
    freq.put("eso", 815);
    freq.put("esn", 1467);
    freq.put("esm", 259);
    freq.put("a\u0328v", 409);
    freq.put("esk", 317);
    freq.put("esj", 92);
    freq.put("esi", 2143);
    freq.put("a\u0328r", 696);
    freq.put("ubu\u0328", 81);
    freq.put("OS ", 98);
    freq.put("e\u0307g", 1127);
    freq.put("e\u0307d", 1595);
    freq.put("e\u0307c", 117);
    freq.put("e\u0307n", 2911);
    freq.put("e\u0307m", 2033);
    freq.put("e\u0307l", 4129);
    freq.put("e\u0307k", 704);
    freq.put("e\u0307j", 12119);
    freq.put("e\u0307v", 406);
    freq.put("e\u0307t", 2531);
    freq.put("e\u0307s", 37968);
    freq.put("e\u0307r", 671);
    freq.put("es ", 8000);
    freq.put("\u4e09 ", 108);
    freq.put("e\u0307z", 158);
    freq.put("bu ", 188);
    freq.put("adu\u0328", 80);
    freq.put("adz\u030c", 530);
    freq.put("rcu", 85);
    freq.put("rco", 114);
    freq.put("rch", 1033);
    freq.put("rci", 353);
    freq.put("rce", 143);
    freq.put("ade\u0307", 694);
    freq.put("bur", 719);
    freq.put("bus", 430);
    freq.put("buv", 3564);
    freq.put("but", 190);
    freq.put("buk", 109);
    freq.put("ncu\u0304", 939);
    freq.put("bui", 94);
    freq.put("Del", 74);
    freq.put("buo", 284);
    freq.put("bul", 328);
    freq.put("bum", 669);
    freq.put("bud", 276);
    freq.put("Deg", 63);
    freq.put("ge\u0328 ", 71);
    freq.put("j", 140065);
    freq.put("ure\u0307", 7194);
    freq.put("pij", 468);
    freq.put("pik", 263);
    freq.put("pil", 4079);
    freq.put("pim", 702);
    freq.put("pin", 2920);
    freq.put("pio", 1030);
    freq.put("pia", 510);
    freq.put("pib", 499);
    freq.put("pid", 180);
    freq.put("pie", 9064);
    freq.put("pig", 92);
    freq.put("pir", 1825);
    freq.put("pis", 533);
    freq.put("pit", 515);
    freq.put("piu", 812);
    freq.put("oac", 66);
    freq.put("oat", 135);
    freq.put("oar", 69);
    freq.put("ese\u0307", 92);
    freq.put("ubu", 247);
    freq.put("ubr", 94);
    freq.put("Ach", 87);
    freq.put("ube", 224);
    freq.put("esa\u0328", 106);
    freq.put("uba", 739);
    freq.put("ubl", 1778);
    freq.put("esc\u030c", 286);
    freq.put("ubo", 317);
    freq.put("ubi", 273);
    freq.put("ubj", 203);
    freq.put("e\u0307s\u030c", 258);
    freq.put("oa ", 103);
    freq.put("us\u030ce\u0307", 81);
    freq.put("taz\u030c", 90);
    freq.put("esi\u0328", 127);
    freq.put("e\u0307z\u030c", 954);
    freq.put("ma\u0328", 3705);
    freq.put("uri\u0328", 786);
    freq.put("mc\u030c", 71);
    freq.put("me\u0307", 4474);
    freq.put("me\u0328", 301);
    freq.put("Cro", 65);
    freq.put("Oke", 81);
    freq.put("G ", 220);
    freq.put("\u0644", 106);
    freq.put("Gv", 487);
    freq.put("Gu", 450);
    freq.put("ms\u030c", 101);
    freq.put("Gr", 2248);
    freq.put("zdu", 307);
    freq.put("Gy", 327);
    freq.put("Ge", 1133);
    freq.put("zdi", 311);
    freq.put("Ga", 1414);
    freq.put("Go", 422);
    freq.put("Gl", 239);
    freq.put("zda", 224);
    freq.put("Gi", 594);
    freq.put(" ka", 22789);
    freq.put(" kg", 76);
    freq.put(" ke", 3545);
    freq.put(" ki", 5307);
    freq.put(" kn", 370);
    freq.put(" ko", 8974);
    freq.put(" kl", 2310);
    freq.put(" km", 6372);
    freq.put(" kr", 4858);
    freq.put(" kv", 492);
    freq.put(" kt", 309);
    freq.put(" ku", 12047);
    freq.put(" ky", 193);
    freq.put("kuv", 68);
    freq.put("kut", 500);
    freq.put("kus", 1457);
    freq.put("kur", 11466);
    freq.put("kup", 293);
    freq.put("kuo", 1084);
    freq.put("kun", 573);
    freq.put("kum", 831);
    freq.put("kul", 3442);
    freq.put("kui", 142);
    freq.put("kub", 70);
    freq.put(" k ", 116);
    freq.put("\u03c2", 168);
    freq.put("ena\u0328", 643);
    freq.put("enc\u030c", 626);
    freq.put("ene\u0307", 1439);
    freq.put("ene\u0328", 98);
    freq.put("e\u0307s\u030cr", 96);
    freq.put("Zo", 74);
    freq.put("Zi", 68);
    freq.put("Z\u030cai", 105);
    freq.put("Ze", 220);
    freq.put("Za", 514);
    freq.put("eni\u0328", 206);
    freq.put("ku ", 438);
    freq.put("zma", 593);
    freq.put("Kom", 332);
    freq.put("Kol", 450);
    freq.put("Kon", 597);
    freq.put("Kop", 80);
    freq.put("Kos", 140);
    freq.put("Kor", 624);
    freq.put("Kov", 100);
    freq.put("m ", 17519);
    freq.put("me", 27128);
    freq.put("md", 246);
    freq.put("mg", 95);
    freq.put("mf", 234);
    freq.put("ma", 41541);
    freq.put("ltu", 191);
    freq.put("mb", 3140);
    freq.put("mm", 415);
    freq.put("ml", 224);
    freq.put("mo", 36514);
    freq.put("mn", 423);
    freq.put("mi", 27912);
    freq.put("mk", 64);
    freq.put("mu", 8277);
    freq.put("mt", 1706);
    freq.put("mp", 5761);
    freq.put("ms", 5086);
    freq.put("zmu", 127);
    freq.put("my", 1666);
    freq.put("mz", 185);
    freq.put(" ku\u0304", 1165);
    freq.put("ena", 6485);
    freq.put("enb", 111);
    freq.put("enc", 1042);
    freq.put("end", 4440);
    freq.put("ene", 2754);
    freq.put("eng", 1816);
    freq.put("eni", 6797);
    freq.put("enk", 5159);
    freq.put("enl", 92);
    freq.put("enm", 89);
    freq.put("eno", 4885);
    freq.put("enr", 107);
    freq.put("ens", 1444);
    freq.put("ent", 11928);
    freq.put("enu", 670);
    freq.put("env", 1006);
    freq.put("m2", 434);
    freq.put("eny", 1624);
    freq.put("enz", 118);
    freq.put("kuc\u030c", 63);
    freq.put("II ", 866);
    freq.put("en ", 710);
    freq.put(" Hy", 110);
    freq.put("i\u0328ta", 351);
    freq.put("i\u0328te", 278);
    freq.put(" Hu", 227);
    freq.put(" Hi", 515);
    freq.put(" Ho", 536);
    freq.put("i\u0328tr", 77);
    freq.put("i\u0328tv", 117);
    freq.put("ima", 10774);
    freq.put("imb", 476);
    freq.put("ime", 1400);
    freq.put("imd", 91);
    freq.put("imf", 152);
    freq.put("imi", 2582);
    freq.put("imo", 10288);
    freq.put("imn", 310);
    freq.put("imp", 910);
    freq.put("ims", 264);
    freq.put("imu", 2073);
    freq.put("imt", 970);
    freq.put("imy", 291);
    freq.put("SA ", 111);
    freq.put(" H ", 80);
    freq.put("im ", 74);
    freq.put("c\u030cem", 518);
    freq.put("s\u030cne", 70);
    freq.put("lbu\u0328", 491);
    freq.put("s\u030cna", 94);
    freq.put("ras\u030c", 3717);
    freq.put("hyl", 73);
    freq.put("s\u030cno", 80);
    freq.put("s\u030cni", 181);
    freq.put("raz\u030c", 304);
    freq.put("s\u030cny", 138);
    freq.put("\u03c4", 94);
    freq.put("gom", 579);
    freq.put("gol", 244);
    freq.put("gon", 466);
    freq.put("goj", 625);
    freq.put("gog", 103);
    freq.put("aju", 423);
    freq.put("aji", 120);
    freq.put("ajo", 4851);
    freq.put("aja", 2169);
    freq.put("gov", 127);
    freq.put("aje", 126);
    freq.put("gos", 3067);
    freq.put("gor", 332);
    freq.put("W", 951);
    freq.put("Vid", 634);
    freq.put("Vie", 542);
    freq.put("Vik", 201);
    freq.put("rac\u030c", 122);
    freq.put("Vin", 109);
    freq.put("go ", 1512);
    freq.put("Vil", 1774);
    freq.put("Vir", 184);
    freq.put("Vis", 391);
    freq.put("lba\u0328", 82);
    freq.put("Vit", 100);
    freq.put("aj ", 639);
    freq.put("be ", 431);
    freq.put("nha", 74);
    freq.put("Y", 441);
    freq.put("nis", 15940);
    freq.put("toz", 74);
    freq.put("le\u0328s", 405);
    freq.put("tor", 6343);
    freq.put("tos", 4057);
    freq.put("top", 234);
    freq.put("tov", 2012);
    freq.put("tot", 663);
    freq.put("toj", 3705);
    freq.put("tok", 1091);
    freq.put("imu\u0328", 1088);
    freq.put("ton", 1654);
    freq.put("tol", 2595);
    freq.put("tom", 2117);
    freq.put("tob", 201);
    freq.put("toc", 126);
    freq.put("tog", 985);
    freq.put("tod", 622);
    freq.put("ima\u0328", 1476);
    freq.put("ime\u0307", 266);
    freq.put("su\u0304n", 301);
    freq.put("le\u0328 ", 354);
    freq.put("to ", 9437);
    freq.put("thu", 146);
    freq.put("raf", 875);
    freq.put("rag", 1079);
    freq.put("rad", 3322);
    freq.put("rae", 172);
    freq.put("rab", 639);
    freq.put("z\u030cn", 2332);
    freq.put("\u4e09", 326);
    freq.put("rao", 69);
    freq.put("ral", 3029);
    freq.put("ram", 2837);
    freq.put("raj", 5239);
    freq.put("rak", 1364);
    freq.put("rah", 84);
    freq.put("rai", 3447);
    freq.put("rav", 918);
    freq.put("rat", 2588);
    freq.put("rau", 2880);
    freq.put("lbe", 120);
    freq.put("ras", 10157);
    freq.put("rap", 372);
    freq.put("lbi", 260);
    freq.put("raz", 577);
    freq.put("lbo", 1044);
    freq.put("aju\u0328", 380);
    freq.put("aju\u0304", 107);
    freq.put("thi", 68);
    freq.put("ra ", 13206);
    freq.put("bst", 94);
    freq.put("aje\u0307", 352);
    freq.put("bso", 103);
    freq.put("bse", 75);
    freq.put("Vis\u030c", 70);
    freq.put("Ita", 399);
    freq.put("me\u0328 ", 264);
    freq.put("z\u030cra", 185);
    freq.put("Viz\u030c", 91);
    freq.put("pkr", 163);
    freq.put(" mu\u0304", 318);
    freq.put("abo", 330);
    freq.put("oci", 1478);
    freq.put("och", 261);
    freq.put("Bil", 78);
    freq.put("u\u0304su\u0328", 232);
    freq.put("oce", 779);
    freq.put("abr", 414);
    freq.put("Bir", 299);
    freq.put("\u0440", 400);
    freq.put("S\u030cud", 88);
    freq.put("e\u0301 ", 79);
    freq.put(" ma\u0328", 77);
    freq.put(" me\u0307", 866);
    freq.put("nux", 72);
    freq.put("Pet", 236);
    freq.put("nut", 401);
    freq.put("nur", 161);
    freq.put("nus", 1958);
    freq.put("Per", 807);
    freq.put("nun", 66);
    freq.put("nuo", 11505);
    freq.put("nul", 255);
    freq.put("num", 449);
    freq.put("nuk", 354);
    freq.put("nui", 231);
    freq.put("nug", 200);
    freq.put("mut", 199);
    freq.put("mus", 1181);
    freq.put("mur", 124);
    freq.put("muz", 1069);
    freq.put("mum", 317);
    freq.put("mul", 740);
    freq.put("muo", 1470);
    freq.put("mun", 878);
    freq.put("mui", 800);
    freq.put("ls\u030ci", 179);
    freq.put("yba", 1117);
    freq.put("eln", 456);
    freq.put("nu ", 681);
    freq.put("mu ", 1142);
    freq.put(" me", 9020);
    freq.put("\u4e4b ", 65);
    freq.put(" ma", 4864);
    freq.put(" ml", 158);
    freq.put(" mm", 210);
    freq.put(" mo", 7083);
    freq.put(" mi", 7229);
    freq.put(" mu", 1417);
    freq.put("je\u0307 ", 190);
    freq.put(" my", 64);
    freq.put("u\u0304st", 200);
    freq.put("u\u0301", 64);
    freq.put("u\u0304se", 158);
    freq.put("u\u0304si", 141);
    freq.put("mu\u0328j", 304);
    freq.put(" m ", 8180);
    freq.put("je\u0307s", 91);
    freq.put("TV ", 98);
    freq.put("je\u0307g", 559);
    freq.put("n", 341806);
    freq.put("u\u0304s ", 568);
    freq.put("ne\u0307t", 145);
    freq.put("ne\u0307r", 303);
    freq.put("ne\u0307s", 9359);
    freq.put("mus\u030c", 82);
    freq.put("ne\u0307l", 246);
    freq.put("ne\u0307m", 645);
    freq.put("ne\u0307n", 104);
    freq.put("ne\u0307j", 3435);
    freq.put("a\u0328na", 83);
    freq.put("ne\u0307 ", 11072);
    freq.put("ra\u0328 ", 1079);
    freq.put("elj", 72);
    freq.put("elk", 671);
    freq.put("eli", 8265);
    freq.put("giu\u0328", 416);
    freq.put("elo", 518);
    freq.put("ell", 316);
    freq.put("elm", 261);
    freq.put("elb", 215);
    freq.put("e\u0328 ", 5692);
    freq.put("ela", 746);
    freq.put("elf", 88);
    freq.put("elg", 477);
    freq.put("eld", 365);
    freq.put("ele", 3424);
    freq.put("ely", 474);
    freq.put("gis\u030c", 189);
    freq.put("els", 353);
    freq.put("elv", 84);
    freq.put("elt", 670);
    freq.put("elu", 87);
    freq.put("D", 8684);
    freq.put("ra\u0328j", 82);
    freq.put("dz\u030co", 105);
    freq.put("el ", 389);
    freq.put("Lyg", 63);
    freq.put("jyb", 83);
    freq.put("e\u0328s", 3467);
    freq.put(" Ju", 1786);
    freq.put("i\u0328vy", 373);
    freq.put("dz\u030ci", 8825);
    freq.put(" Jo", 1429);
    freq.put("i\u0328va", 943);
    freq.put(" Ji", 1102);
    freq.put("i\u0328ve", 191);
    freq.put(" Je", 431);
    freq.put(" Ja", 1776);
    freq.put("ick", 163);
    freq.put("ici", 1931);
    freq.put("Hy", 110);
    freq.put("ico", 274);
    freq.put("ns\u030c", 207);
    freq.put("ica", 672);
    freq.put("ice", 275);
    freq.put("Hu", 227);
    freq.put("Hi", 517);
    freq.put("Ho", 543);
    freq.put("nz\u030c", 291);
    freq.put("icr", 108);
    freq.put("nu\u0328", 7287);
    freq.put("tis\u030c", 751);
    freq.put("icu", 77);
    freq.put("He", 851);
    freq.put("nc\u030c", 4435);
    freq.put("na\u0328", 1594);
    freq.put("ne\u0328", 1600);
    freq.put("hst", 134);
    freq.put(" J ", 93);
    freq.put("ne\u0307", 25365);
    freq.put("ni\u0328", 1610);
    freq.put("ic ", 202);
    freq.put("H ", 197);
    freq.put("de\u0328 ", 83);
    freq.put("aha", 210);
    freq.put("s\u030cli", 309);
    freq.put("s\u030cle", 715);
    freq.put("aho", 88);
    freq.put("s\u030cla", 532);
    freq.put("ybi", 1941);
    freq.put("giu", 292);
    freq.put("git", 144);
    freq.put("gis", 1794);
    freq.put("gir", 399);
    freq.put("gip", 251);
    freq.put("els\u030c", 173);
    freq.put("gie", 143);
    freq.put("gia", 3193);
    freq.put("gio", 2880);
    freq.put("gin", 4262);
    freq.put("gim", 1321);
    freq.put("gil", 204);
    freq.put("gik", 123);
    freq.put("gij", 3190);
    freq.put("ra\u0328z\u030c", 93);
    freq.put("rs\u030ck", 199);
    freq.put("ele\u0328", 124);
    freq.put("ele\u0307", 2221);
    freq.put("eli\u0328", 206);
    freq.put("Vol", 265);
    freq.put("Vok", 795);
    freq.put("gi ", 457);
    freq.put("nni", 71);
    freq.put("nne", 81);
    freq.put(" Ju\u0328", 127);
    freq.put(" Ju\u0304", 181);
    freq.put("nh", 168);
    freq.put("ni", 75394);
    freq.put("nj", 255);
    freq.put("nk", 20248);
    freq.put("nl", 177);
    freq.put("nm", 383);
    freq.put("nn", 299);
    freq.put("no", 25328);
    freq.put("tit", 1932);
    freq.put("na", 39063);
    freq.put("nb", 286);
    freq.put("nc", 4749);
    freq.put("nd", 18751);
    freq.put("ne", 20163);
    freq.put("nf", 1054);
    freq.put("ng", 14841);
    freq.put("til", 880);
    freq.put("ny", 7794);
    freq.put("nz", 353);
    freq.put("tio", 733);
    freq.put("tij", 3726);
    freq.put("ES ", 63);
    freq.put("np", 87);
    freq.put("tie", 4693);
    freq.put("nr", 387);
    freq.put("ns", 5838);
    freq.put("nt", 40253);
    freq.put("nu", 16862);
    freq.put("nv", 1496);
    freq.put("tic", 399);
    freq.put(" Ji\u0328", 73);
    freq.put("ich", 922);
    freq.put("n ", 4899);
    freq.put(" Je\u0307", 115);
    freq.put(" Ja\u0328", 106);
    freq.put("ti ", 12579);
    freq.put("roi", 152);
    freq.put("roj", 2662);
    freq.put("rok", 757);
    freq.put("rol", 1077);
    freq.put("rom", 1205);
    freq.put("ron", 1539);
    freq.put("lls", 89);
    freq.put("roa", 194);
    freq.put("rob", 326);
    freq.put("roc", 897);
    freq.put("rod", 1480);
    freq.put("roe", 102);
    freq.put("rof", 604);
    freq.put("rog", 1825);
    freq.put("dz\u030ce", 173);
    freq.put("roz", 106);
    freq.put("llo", 104);
    freq.put("rop", 2336);
    freq.put("ror", 154);
    freq.put("de\u0328s", 150);
    freq.put("rot", 753);
    freq.put("rou", 123);
    freq.put("rov", 2454);
    freq.put("row", 67);
    freq.put("yks", 518);
    freq.put("Dab", 105);
    freq.put("Dal", 128);
    freq.put("Dam", 137);
    freq.put("Dan", 260);
    freq.put("a\u0328vo", 220);
    freq.put("Dai", 135);
    freq.put("Dau", 478);
    freq.put("Dar", 403);
    freq.put("Ke\u0307d", 210);
    freq.put("S\u030c", 7077);
    freq.put("ro ", 7225);
    freq.put("Cit", 67);
    freq.put("ll ", 250);
    freq.put("Ha", 879);
    freq.put("ga\u0328 ", 583);
    freq.put("z\u030cpa", 73);
    freq.put("e\u0307ly", 383);
    freq.put("Mis\u030c", 117);
    freq.put("Res", 1390);
    freq.put("kys\u030c", 114);
    freq.put("Mik", 194);
    freq.put(" oz\u030c", 66);
    freq.put("e\u0307li", 1870);
    freq.put("Rei", 156);
    freq.put("Ren", 82);
    freq.put("Rec", 68);
    freq.put("Reg", 116);
    freq.put("Red", 71);
    freq.put("ti\u0328", 886);
    freq.put("ulp", 163);
    freq.put("as\u030cu\u0328", 113);
    freq.put("Aga", 104);
    freq.put("e\u0307l ", 1089);
    freq.put("kyc\u030c", 84);
    freq.put("ple", 626);
    freq.put("kly", 141);
    freq.put("z\u030cu\u0328 ", 324);
    freq.put("uve", 227);
    freq.put("sc\u030ci", 2451);
    freq.put("ota\u0328", 235);
    freq.put("roz\u030c", 108);
    freq.put("ngt", 1224);
    freq.put("mso", 66);
    freq.put("pli", 2030);
    freq.put("msi", 145);
    freq.put("Daz\u030c", 276);
    freq.put("S\u030cve", 932);
    freq.put("yje", 6777);
    freq.put("Me\u0307n", 80);
    freq.put("ms ", 4671);
    freq.put("kyk", 2742);
    freq.put("kyj", 122);
    freq.put(" ol", 297);
    freq.put(" oj", 106);
    freq.put("Mil", 131);
    freq.put("kym", 1532);
    freq.put("kyl", 177);
    freq.put(" of", 644);
    freq.put("kyb", 405);
    freq.put("Mic", 168);
    freq.put("i\u0328mo", 598);
    freq.put("kyd", 213);
    freq.put("kys", 407);
    freq.put("kyr", 514);
    freq.put("Mis", 99);
    freq.put("Mir", 79);
    freq.put(" or", 3230);
    freq.put("Mit", 95);
    freq.put(" op", 537);
    freq.put("kyt", 491);
    freq.put("Mie", 142);
    freq.put(" o ", 1212);
    freq.put("Z\u030cmo", 87);
    freq.put("e\u0307le\u0307", 390);
    freq.put("gta", 465);
    freq.put("ri\u0328s", 115);
    freq.put("gti", 868);
    freq.put("gto", 154);
    freq.put("iaz\u030c", 208);
    freq.put("gty", 102);
    freq.put("ahi", 72);
    freq.put(" ca", 122);
    freq.put("pru\u0304", 156);
    freq.put(" Le\u0307", 70);
    freq.put("\u0438\u0438\u0306", 86);
    freq.put("\u0438\u043d", 66);
    freq.put("anz\u030c", 85);
    freq.put("mim", 392);
    freq.put("ejo", 153);
    freq.put("eji", 683);
    freq.put("eje", 65);
    freq.put("eja", 503);
    freq.put("ejy", 83);
    freq.put("eju", 497);
    freq.put("uc\u030ci", 685);
    freq.put("ana\u0328", 115);
    freq.put("anc\u030c", 3200);
    freq.put("ane\u0307", 190);
    freq.put("z\u030c", 44691);
    freq.put("i\u0328pr", 139);
    freq.put("pu\u0328 ", 324);
    freq.put("eps\u030c", 367);
    freq.put("iam", 6822);
    freq.put("ial", 2617);
    freq.put("ian", 3835);
    freq.put("iai", 12600);
    freq.put("iak", 2489);
    freq.put("iaj", 841);
    freq.put("iad", 246);
    freq.put("iag", 1048);
    freq.put("iac", 1098);
    freq.put("iab", 113);
    freq.put("iau", 21521);
    freq.put("iat", 599);
    freq.put("iav", 1428);
    freq.put("iap", 102);
    freq.put("ias", 3810);
    freq.put("iar", 592);
    freq.put("hua", 109);
    freq.put("hum", 232);
    freq.put("hun", 68);
    freq.put("ia ", 6457);
    freq.put("r", 352720);
    freq.put("la ", 3891);
    freq.put("and", 6903);
    freq.put("ane", 1374);
    freq.put("ang", 3590);
    freq.put("pra", 5043);
    freq.put("ana", 4088);
    freq.put("anc", 1441);
    freq.put("anm", 118);
    freq.put("ann", 125);
    freq.put("ano", 3129);
    freq.put("pri", 9679);
    freq.put("ani", 4762);
    freq.put("anj", 123);
    freq.put("ank", 4229);
    freq.put("ant", 17439);
    freq.put("s\u030cra", 138);
    freq.put("\u0442", 349);
    freq.put("s\u030cre", 107);
    freq.put("anr", 199);
    freq.put("ans", 1524);
    freq.put("s\u030cri", 577);
    freq.put("any", 235);
    freq.put("anz", 118);
    freq.put(" L ", 82);
    freq.put("\u0435", 519);
    freq.put("eju\u0328", 738);
    freq.put("an ", 1340);
    freq.put("pr ", 158);
    freq.put(" Le", 2732);
    freq.put(" La", 2647);
    freq.put(" Lo", 721);
    freq.put(" Li", 7563);
    freq.put(" Lu", 488);
    freq.put(" Ly", 249);
    freq.put("poz\u030c", 275);
    freq.put("tka", 159);
    freq.put("tko", 75);
    freq.put("nla", 91);
    freq.put("tku", 65);
    freq.put("ss ", 140);
    freq.put("pos\u030c", 212);
    freq.put("dyt", 634);
    freq.put("H", 3427);
    freq.put("dys", 311);
    freq.put("dym", 1573);
    freq.put("dyn", 853);
    freq.put("ssi", 140);
    freq.put("dyk", 422);
    freq.put("sse", 159);
    freq.put("dyg", 104);
    freq.put("ssa", 96);
    freq.put("dyb", 2813);
    freq.put("lny", 212);
    freq.put("rmu", 712);
    freq.put("lnu", 597);
    freq.put("lno", 410);
    freq.put("s\u030cu\u0328 ", 222);
    freq.put("lni", 4011);
    freq.put("rme", 740);
    freq.put("lne", 64);
    freq.put("rmi", 1316);
    freq.put("lna", 1027);
    freq.put("rmo", 1239);
    freq.put("z\u030cve", 120);
    freq.put("z\u030cva", 821);
    freq.put("z\u030cvi", 225);
    freq.put("ln ", 170);
    freq.put("z\u030cvy", 103);
    freq.put("e\u0307nu\u0328", 1107);
    freq.put("Is\u030c", 781);
    freq.put("poz", 347);
    freq.put("pov", 195);
    freq.put("pot", 290);
    freq.put("por", 1711);
    freq.put("pos", 1432);
    freq.put("pop", 634);
    freq.put("pon", 986);
    freq.put("pol", 1919);
    freq.put("pom", 76);
    freq.put("poj", 445);
    freq.put("pok", 315);
    freq.put("pog", 134);
    freq.put("pod", 139);
    freq.put("poe", 104);
    freq.put("pob", 138);
    freq.put("poc", 74);
    freq.put("Bur", 231);
    freq.put("Buv", 78);
    freq.put("But", 90);
    freq.put("Bui", 103);
    freq.put("Bul", 113);
    freq.put("Bud", 102);
    freq.put("Bue", 112);
    freq.put("po ", 1517);
    freq.put("rmu\u0328", 317);
    freq.put("Bat", 90);
    freq.put("lnu\u0328", 522);
    freq.put("Bau", 99);
    freq.put("Bar", 458);
    freq.put("okt", 115);
    freq.put("e\u0307n ", 149);
    freq.put("\u0431", 111);
    freq.put("I ", 1579);
    freq.put("XX ", 204);
    freq.put("Eti", 120);
    freq.put("e\u0307na", 175);
    freq.put("rme\u0307", 253);
    freq.put("e\u0307ne", 311);
    freq.put("Is", 624);
    freq.put("Ir", 401);
    freq.put("It", 425);
    freq.put("Iv", 75);
    freq.put("Ik", 112);
    freq.put("Im", 227);
    freq.put("Il", 691);
    freq.put("rma\u0328", 324);
    freq.put("oke", 340);
    freq.put("Ib", 64);
    freq.put("Id", 102);
    freq.put("Ig", 304);
    freq.put("tip", 1038);
    freq.put("oki", 2742);
    freq.put("tir", 719);
    freq.put("tis", 9550);
    freq.put("tim", 2115);
    freq.put("tin", 18689);
    freq.put("Bak", 129);
    freq.put("Bah", 87);
    freq.put("pc\u030ci", 95);
    freq.put("tik", 5456);
    freq.put("tid", 346);
    freq.put("tif", 144);
    freq.put("tig", 115);
    freq.put("Pil", 450);
    freq.put("Pin", 159);
    freq.put("e\u0307nu", 240);
    freq.put("Pic", 67);
    freq.put("Pie", 1313);
    freq.put("tia", 180);
    freq.put("tib", 66);
    freq.put("Pir", 463);
    freq.put("\u0438 ", 92);
    freq.put("Kur", 371);
    freq.put("Kup", 188);
    freq.put("rvu\u0328", 140);
    freq.put("Kun", 174);
    freq.put("alt", 2672);
    freq.put("Kul", 193);
    freq.put("Kub", 74);
    freq.put("gvi", 98);
    freq.put("igu\u0328", 264);
    freq.put("gvo", 218);
    freq.put("igz\u030c", 771);
    freq.put("gva", 685);
    freq.put("o ", 113444);
    freq.put("igu\u0304", 296);
    freq.put("ige\u0307", 179);
    freq.put("und", 514);
    freq.put("Jas", 71);
    freq.put("oo", 622);
    freq.put("on", 30734);
    freq.put("om", 18799);
    freq.put("ol", 18423);
    freq.put("ok", 15352);
    freq.put("oj", 37495);
    freq.put("oi", 681);
    freq.put("oh", 445);
    freq.put("og", 8954);
    freq.put("of", 2043);
    freq.put("oe", 521);
    freq.put("od", 8826);
    freq.put("oc", 3010);
    freq.put("ob", 3847);
    freq.put("oa", 712);
    freq.put("rve\u0307", 96);
    freq.put("oz", 1228);
    freq.put("oy", 145);
    freq.put("ox", 93);
    freq.put("ow", 356);
    freq.put("ov", 9611);
    freq.put("ou", 825);
    freq.put("ot", 12743);
    freq.put("os", 91367);
    freq.put("or", 24858);
    freq.put("op", 6292);
    freq.put("ju ", 392);
    freq.put("plu\u0304", 91);
    freq.put("jud", 642);
    freq.put("juj", 263);
    freq.put("jui", 107);
    freq.put("jun", 1716);
    freq.put("juo", 1236);
    freq.put("jur", 161);
    freq.put("jus", 1760);
    freq.put("\u4e01", 115);
    freq.put("Kuz\u030c", 106);
    freq.put("rva", 500);
    freq.put("rve", 467);
    freq.put("nga\u0328", 233);
    freq.put("rvi", 416);
    freq.put("rvo", 162);
    freq.put("i\u0328ro", 74);
    freq.put("rvu", 153);
    freq.put("i\u0328re", 301);
    freq.put("i\u0328ra", 525);
    freq.put("igu", 322);
    freq.put("igt", 307);
    freq.put("igr", 206);
    freq.put("igy", 112);
    freq.put("\u0631", 65);
    freq.put("ige", 301);
    freq.put("iga", 1803);
    freq.put("igo", 701);
    freq.put("ign", 206);
    freq.put("igm", 118);
    freq.put("igl", 111);
    freq.put("igi", 1406);
    freq.put("igh", 167);
    freq.put("os\u030c", 750);
    freq.put("oz\u030c", 891);
    freq.put(" \u2212 ", 501);
    freq.put("pto", 309);
    freq.put("alo", 3517);
    freq.put("all", 289);
    freq.put("alm", 300);
    freq.put("alk", 1267);
    freq.put("pti", 1385);
    freq.put("ali", 17593);
    freq.put("alg", 429);
    freq.put("pte", 200);
    freq.put("ale", 3230);
    freq.put("alb", 4521);
    freq.put("alc", 176);
    freq.put("pta", 1134);
    freq.put("ala", 5633);
    freq.put("rks\u030c", 158);
    freq.put("pty", 174);
    freq.put("aly", 3612);
    freq.put("alv", 1945);
    freq.put("fa ", 109);
    freq.put("alu", 1766);
    freq.put("als", 5664);
    freq.put("alp", 263);
    freq.put("faz", 69);
    freq.put("far", 115);
    freq.put("fas", 187);
    freq.put("al ", 2864);
    freq.put("fak", 286);
    freq.put("fai", 102);
    freq.put("fan", 250);
    freq.put("llu", 67);
    freq.put("fal", 119);
    freq.put(" Ni", 719);
    freq.put("rke\u0307", 212);
    freq.put(" No", 770);
    freq.put(" Na", 1859);
    freq.put(" Ne", 1796);
    freq.put("lli", 227);
    freq.put(" Ny", 218);
    freq.put("rka\u0328", 115);
    freq.put("dz\u030ca", 265);
    freq.put(" Nr", 561);
    freq.put(" Nu", 899);
    freq.put("tei", 4906);
    freq.put("tek", 2029);
    freq.put("tel", 3046);
    freq.put("tem", 2567);
    freq.put("ten", 1501);
    freq.put("teo", 504);
    freq.put("tea", 212);
    freq.put("teb", 306);
    freq.put("tec", 578);
    freq.put("ted", 149);
    freq.put("nbu", 79);
    freq.put("teg", 305);
    freq.put("tez", 110);
    freq.put("ce\u0307l", 111);
    freq.put("tep", 206);
    freq.put("ter", 7958);
    freq.put("tes", 640);
    freq.put("tet", 1080);
    freq.put("lla", 282);
    freq.put("nbe", 88);
    freq.put("sug", 205);
    freq.put("suf", 148);
    freq.put("sue", 135);
    freq.put("ros", 5272);
    freq.put("sub", 489);
    freq.put("sua", 240);
    freq.put("suo", 1175);
    freq.put("sun", 407);
    freq.put("sum", 815);
    freq.put("sul", 523);
    freq.put("suk", 1852);
    freq.put("suj", 169);
    freq.put("sui", 78);
    freq.put("suv", 210);
    freq.put("sut", 1183);
    freq.put("sus", 2952);
    freq.put("sur", 378);
    freq.put("sup", 534);
    freq.put("yvu", 368);
    freq.put("te ", 2806);
    freq.put("o\u0304", 147);
    freq.put("ks\u030co", 166);
    freq.put("ks\u030cn", 209);
    freq.put("ks\u030cm", 294);
    freq.put("ks\u030cl", 78);
    freq.put("is\u030cn", 213);
    freq.put("ks\u030ct", 3974);
    freq.put("su ", 4472);
    freq.put("ya ", 66);
    freq.put("Dz\u030ce", 84);
    freq.put("Dz\u030ca", 76);
    freq.put("is\u030cd", 131);
    freq.put("Dz\u030co", 137);
    freq.put("Dz\u030ci", 72);
    freq.put("rkt", 264);
    freq.put("rku", 184);
    freq.put("rkv", 63);
    freq.put("ptu\u0304", 85);
    freq.put("alu\u0304", 263);
    freq.put("rks", 74);
    freq.put("Tor", 126);
    freq.put("rky", 100);
    freq.put("rke", 407);
    freq.put("Ton", 98);
    freq.put("rka", 1300);
    freq.put("Tol", 111);
    freq.put("Tom", 115);
    freq.put("rkl", 319);
    freq.put("rko", 615);
    freq.put("rki", 550);
    freq.put("z\u030cti", 234);
    freq.put("ali\u0328", 375);
    freq.put("z\u030cta", 167);
    freq.put("z\u030cte", 70);
    freq.put("rk ", 142);
    freq.put("z\u030ctv", 87);
    freq.put("a\u0301", 197);
    freq.put("Z\u030cva", 101);
    freq.put("alc\u030c", 210);
    freq.put("Int", 267);
    freq.put("ala\u0328", 244);
    freq.put("Ins", 77);
    freq.put("v", 137211);
    freq.put("Ind", 876);
    freq.put("ale\u0307", 817);
    freq.put("Inf", 65);
    freq.put("ks\u030cc\u030c", 2245);
    freq.put("\u0438\u0306", 180);
    freq.put("suz\u030c", 77);
    freq.put("mz\u030ci", 691);
    freq.put("Gla", 64);
    freq.put("Akm", 194);
    freq.put("Aka", 93);
    freq.put("Och", 90);
    freq.put("yn ", 82);
    freq.put("Fri", 67);
    freq.put("L", 15923);
    freq.put("Eri", 121);
    freq.put("Rag", 90);
    freq.put("Rad", 254);
    freq.put("yno", 1069);
    freq.put("yni", 762);
    freq.put("Ran", 143);
    freq.put("yne", 693);
    freq.put("Ram", 470);
    freq.put("Raj", 66);
    freq.put("yna", 1411);
    freq.put("Rai", 78);
    freq.put("Rau", 279);
    freq.put("Ras", 159);
    freq.put("man", 2648);
    freq.put("ynu", 272);
    freq.put("Mus", 128);
    freq.put("Mur", 145);
    freq.put(" sr", 2054);
    freq.put(" sp", 3493);
    freq.put(" sv", 1124);
    freq.put(" st", 5898);
    freq.put("gun", 99);
    freq.put(" sk", 5183);
    freq.put(" si", 4889);
    freq.put(" sn", 168);
    freq.put(" so", 1538);
    freq.put(" sl", 1116);
    freq.put(" sm", 866);
    freq.put(" sc", 162);
    freq.put(" sa", 11017);
    freq.put(" sf", 110);
    freq.put(" se", 4482);
    freq.put("iza", 1796);
    freq.put("izd", 791);
    freq.put("ize", 116);
    freq.put("izg", 80);
    freq.put("izi", 1251);
    freq.put("izm", 1490);
    freq.put("izn", 83);
    freq.put("izo", 451);
    freq.put("izu", 821);
    freq.put("o\u0301n", 71);
    freq.put(" em", 226);
    freq.put("kok", 423);
    freq.put(" s ", 108);
    freq.put("kol", 1241);
    freq.put("oz\u030cy", 124);
    freq.put("oke\u0307", 208);
    freq.put("kon", 3138);
    freq.put("oz\u030ci", 226);
    freq.put("oz\u030ca", 97);
    freq.put("Z\u030cie", 168);
    freq.put(" ef", 150);
    freq.put("oz\u030ce", 207);
    freq.put("yna\u0328", 129);
    freq.put("Rac\u030c", 79);
    freq.put("yne\u0307", 548);
    freq.put("gpj", 199);
    freq.put("\u0441\u043a\u0438", 73);
    freq.put(" eu", 161);
    freq.put(" ev", 173);
    freq.put("\u043a", 381);
    freq.put("Nuo", 622);
    freq.put(" es", 1712);
    freq.put("ynu\u0328", 327);
    freq.put(" su\u0304", 347);
    freq.put("e\u0307la", 197);
    freq.put("efi", 76);
    freq.put("efo", 293);
    freq.put("efa", 70);
    freq.put("efe", 515);
    freq.put("ize\u0307", 124);
    freq.put(" se\u0307", 250);
    freq.put("Zel", 141);
    freq.put(" sa\u0328", 2199);
    freq.put("rte", 485);
    freq.put("de\u0307s", 969);
    freq.put("rta", 4621);
    freq.put("de\u0307t", 870);
    freq.put("rtm", 86);
    freq.put("rto", 2230);
    freq.put("rtn", 140);
    freq.put("rti", 4648);
    freq.put("rth", 95);
    freq.put("rtu", 1225);
    freq.put("rtr", 75);
    freq.put("de\u0307j", 1386);
    freq.put("rty", 412);
    freq.put("de\u0307l", 1132);
    freq.put("de\u0307m", 219);
    freq.put("pu\u0328", 330);
    freq.put("I\u0328 ", 110);
    freq.put("Ju", 1787);
    freq.put("ies", 9563);
    freq.put("ier", 804);
    freq.put("pz\u030c", 94);
    freq.put("iet", 17789);
    freq.put("iev", 1199);
    freq.put("iek", 3632);
    freq.put("iej", 2087);
    freq.put("iem", 1768);
    freq.put("iel", 363);
    freq.put("ien", 11441);
    freq.put("pu\u0304", 264);
    freq.put("ieb", 372);
    freq.put("ied", 842);
    freq.put("ieg", 235);
    freq.put("hip", 216);
    freq.put("hir", 118);
    freq.put("his", 79);
    freq.put("hit", 343);
    freq.put("rt ", 258);
    freq.put("s\u030ci\u0328 ", 141);
    freq.put("pe\u0328", 314);
    freq.put("hia", 94);
    freq.put("de\u0307 ", 795);
    freq.put("hid", 370);
    freq.put("hie", 74);
    freq.put("pa\u0328", 197);
    freq.put("hij", 135);
    freq.put("hil", 142);
    freq.put("him", 102);
    freq.put("hin", 342);
    freq.put("pc\u030c", 97);
    freq.put(" \u1100\u1161", 71);
    freq.put("I\u0328k", 141);
    freq.put("I\u0328e", 85);
    freq.put("ie ", 6151);
    freq.put("I\u0328s", 221);
    freq.put("J ", 126);
    freq.put("pi\u0328", 89);
    freq.put("riz\u030c", 94);
    freq.put("arr", 83);
    freq.put("ars", 1153);
    freq.put("art", 6116);
    freq.put("s\u030cvy", 117);
    freq.put("arv", 357);
    freq.put("ary", 2268);
    freq.put("pvz", 390);
    freq.put("riu\u0328", 3254);
    freq.put("pva", 210);
    freq.put("ara", 6684);
    freq.put("arb", 6774);
    freq.put("arc", 907);
    freq.put("ard", 2315);
    freq.put("s\u030cvi", 810);
    freq.put("arg", 513);
    freq.put("ari", 8416);
    freq.put("arj", 115);
    freq.put("ark", 2565);
    freq.put("arl", 418);
    freq.put("s\u030cva", 235);
    freq.put("arn", 1263);
    freq.put("aro", 3645);
    freq.put("ns\u030ci", 88);
    freq.put(" P ", 142);
    freq.put("ar ", 4730);
    freq.put("fga", 67);
    freq.put("be\u0328 ", 399);
    freq.put(" Ps", 108);
    freq.put(" Pr", 4036);
    freq.put("c", 39025);
    freq.put(" Pu", 558);
    freq.put(" Pa", 7618);
    freq.put("ric\u030c", 321);
    freq.put(" Pe", 1581);
    freq.put(" Pi", 2753);
    freq.put(" Ph", 102);
    freq.put(" Po", 1526);
    freq.put(" Pl", 1099);
    freq.put("Bi", 838);
    freq.put("tga", 173);
    freq.put("rtu\u0328", 277);
    freq.put("pr", 22301);
    freq.put("dui", 167);
    freq.put("duj", 255);
    freq.put("duk", 700);
    freq.put("dul", 493);
    freq.put("dum", 210);
    freq.put("pt", 3572);
    freq.put("iez\u030c", 504);
    freq.put("dua", 83);
    freq.put("px", 100);
    freq.put("py", 2379);
    freq.put("Ju\u0328", 127);
    freq.put("pc", 152);
    freq.put("pa", 38606);
    freq.put("pg", 158);
    freq.put("pd", 423);
    freq.put("Ju\u0304", 181);
    freq.put("ies\u030c", 2115);
    freq.put("pk", 273);
    freq.put("dur", 2035);
    freq.put("dus", 534);
    freq.put("pn", 207);
    freq.put("po", 11055);
    freq.put("duv", 159);
    freq.put("pm", 79);
    freq.put("\u0438\u0306 ", 139);
    freq.put("rti\u0328", 75);
    freq.put("Je\u0307", 115);
    freq.put("iec\u030c", 1593);
    freq.put("Ja\u0328", 106);
    freq.put("rta\u0328", 376);
    freq.put("du ", 892);
    freq.put("rte\u0307", 217);
    freq.put("Ji\u0328", 73);
    freq.put("aru\u0328", 1990);
    freq.put("riz", 580);
    freq.put("rix", 85);
    freq.put("riv", 457);
    freq.put("Tiu", 72);
    freq.put("rit", 7580);
    freq.put("riu", 3503);
    freq.put("ris", 4114);
    freq.put("arz\u030c", 560);
    freq.put("rin", 15816);
    freq.put("ars\u030c", 379);
    freq.put("ril", 196);
    freq.put("rim", 1853);
    freq.put("rij", 7031);
    freq.put("rik", 6018);
    freq.put("rii", 272);
    freq.put("rif", 330);
    freq.put("Tie", 67);
    freq.put("rid", 769);
    freq.put("aru\u0304", 95);
    freq.put("rib", 1061);
    freq.put("ric", 629);
    freq.put("Tib", 113);
    freq.put("ria", 7346);
    freq.put("aga", 3563);
    freq.put("Ilg", 538);
    freq.put("Cor", 127);
    freq.put("se\u0307d", 208);
    freq.put("Com", 218);
    freq.put("Col", 154);
    freq.put("ri ", 2109);
    freq.put("Con", 133);
    freq.put("are\u0307", 673);
    freq.put("are\u0328", 105);
    freq.put("di\u0328 ", 451);
    freq.put("ara\u0328", 182);
    freq.put("arc\u030c", 154);
    freq.put(" uz\u030c", 2934);
    freq.put("vaz\u030c", 200);
    freq.put("i\u0328ku\u0304", 191);
    freq.put("\u044c", 90);
    freq.put("Air", 332);
    freq.put("lja", 125);
    freq.put("lje", 178);
    freq.put("gru\u0304", 76);
    freq.put("Isp", 323);
    freq.put("gra\u0328", 89);
    freq.put("e\u0307jo", 1675);
    freq.put("Rok", 173);
    freq.put("Rom", 573);
    freq.put("e\u0307ji", 1633);
    freq.put("Rob", 64);
    freq.put("e\u0307je", 5476);
    freq.put("Rod", 82);
    freq.put("e\u0307ja", 1671);
    freq.put("yla", 244);
    freq.put("gri\u0328", 216);
    freq.put("yll", 79);
    freq.put("e\u0307ju", 616);
    freq.put("yli", 1437);
    freq.put("i\u0328ku", 691);
    freq.put(" up", 3500);
    freq.put(" ur", 214);
    freq.put(" ul", 71);
    freq.put(" un", 1322);
    freq.put(" uo", 741);
    freq.put("I\u0328ku", 124);
    freq.put(" ug", 910);
    freq.put(" Ky", 76);
    freq.put("ix ", 136);
    freq.put("z", 20490);
    freq.put("Sur", 111);
    freq.put("yle\u0307", 72);
    freq.put("e\u0307je\u0328", 513);
    freq.put("gru", 2484);
    freq.put("gry", 429);
    freq.put("gre", 877);
    freq.put("gra", 4017);
    freq.put("gro", 326);
    freq.put("gri", 3118);
    freq.put("ni\u0328 ", 1595);
    freq.put("gr ", 135);
    freq.put("e\u0307ju\u0328", 416);
    freq.put("eda", 2475);
    freq.put("ede", 757);
    freq.put("ic\u030ci", 2192);
    freq.put("apu\u0328", 68);
    freq.put("edi", 2343);
    freq.put("edo", 437);
    freq.put("edr", 226);
    freq.put("\u043a\u043e", 78);
    freq.put("\u043a\u0438", 93);
    freq.put("edu", 236);
    freq.put("ugo", 862);
    freq.put("aps\u030c", 64);
    freq.put("\u043a\u0430", 91);
    freq.put("ugn", 281);
    freq.put("usu\u0328", 229);
    freq.put("rc\u030ci", 327);
    freq.put("ed ", 292);
    freq.put("use\u0307", 442);
    freq.put("P", 20146);
    freq.put("ja", 28492);
    freq.put("use\u0328", 91);
    freq.put("usi\u0328", 91);
    freq.put("ape\u0307", 321);
    freq.put("iba", 407);
    freq.put(" Ru\u0304", 228);
    freq.put("s\u030cta\u0328", 94);
    freq.put("rre", 91);
    freq.put("rra", 105);
    freq.put("s\u030cte\u0307", 332);
    freq.put("tas\u030c", 256);
    freq.put("ugr", 96);
    freq.put("siu\u0328", 1944);
    freq.put("sa\u0328v", 390);
    freq.put("bda", 77);
    freq.put("sa\u0328r", 690);
    freq.put("s\u030cti\u0328", 112);
    freq.put("Uz", 69);
    freq.put("siz\u030c", 207);
    freq.put("gu\u0328 ", 1699);
    freq.put("sis\u030c", 352);
    freq.put("ugu", 1147);
    freq.put("rac", 2843);
    freq.put("sa\u0328n", 78);
    freq.put("sa\u0328m", 110);
    freq.put("sa\u0328l", 240);
    freq.put("sa\u0328j", 351);
    freq.put("Up", 176);
    freq.put("sia\u0328", 193);
    freq.put("guz\u030c", 295);
    freq.put("s\u030ctu\u0328", 188);
    freq.put("sa\u0328 ", 505);
    freq.put("tac\u030c", 773);
    freq.put("apy", 1793);
    freq.put("apr", 1671);
    freq.put("aps", 2502);
    freq.put("apv", 201);
    freq.put("i\u0328ma", 63);
    freq.put("apt", 510);
    freq.put("apu", 404);
    freq.put("apk", 227);
    freq.put("api", 6467);
    freq.put("apo", 1183);
    freq.put("apl", 1752);
    freq.put("Is\u030ct", 197);
    freq.put("apa", 1300);
    freq.put("edz\u030c", 1549);
    freq.put("apg", 138);
    freq.put("apd", 357);
    freq.put("ape", 335);
    freq.put("fed", 364);
    freq.put("usd", 94);
    freq.put("usa", 1585);
    freq.put("fen", 78);
    freq.put("fel", 82);
    freq.put("Min", 395);
    freq.put("usk", 802);
    freq.put("fek", 526);
    freq.put("usi", 16156);
    freq.put("Mia", 99);
    freq.put("usu", 325);
    freq.put("ust", 2671);
    freq.put("fer", 701);
    freq.put("fes", 435);
    freq.put(" od", 155);
    freq.put("usy", 348);
    freq.put("Gua", 94);
    freq.put("Gud", 68);
    freq.put(" ob", 1166);
    freq.put("Is\u030c ", 185);
    freq.put("ap ", 76);
    freq.put("px ", 100);
    freq.put(" Ru", 2112);
    freq.put("fe ", 71);
    freq.put("us ", 25324);
    freq.put(" Ry", 866);
    freq.put(" Re", 2283);
    freq.put(" Ra", 1919);
    freq.put("ede\u0307", 140);
    freq.put(" Ro", 1436);
    freq.put(" Ri", 769);
    freq.put("tat", 2848);
    freq.put("tau", 2680);
    freq.put("tav", 1620);
    freq.put("tap", 484);
    freq.put("tar", 6407);
    freq.put("tas", 15287);
    freq.put("tad", 469);
    freq.put(" ov", 65);
    freq.put("tag", 213);
    freq.put("tab", 401);
    freq.put("tac", 699);
    freq.put("tal", 2568);
    freq.put("tam", 3320);
    freq.put("tan", 2917);
    freq.put("tai", 9707);
    freq.put("taj", 152);
    freq.put("tak", 2532);
    freq.put("sis", 6798);
    freq.put("sir", 1172);
    freq.put("sip", 235);
    freq.put("siv", 352);
    freq.put("siu", 976);
    freq.put("sit", 1385);
    freq.put(" os", 113);
    freq.put("sic", 542);
    freq.put("sib", 166);
    freq.put("sia", 6343);
    freq.put("sig", 288);
    freq.put("sif", 333);
    freq.put("sie", 2665);
    freq.put("sid", 3080);
    freq.put("sik", 1642);
    freq.put("sij", 3056);
    freq.put("sii", 91);
    freq.put("sio", 4893);
    freq.put("sin", 3201);
    freq.put("sim", 839);
    freq.put("sil", 885);
    freq.put("Eko", 63);
    freq.put("c\u030cku\u0328", 69);
    freq.put("Ekv", 92);
    freq.put("ykl", 3525);
    freq.put("s\u030cte", 875);
    freq.put("s\u030cta", 1289);
    freq.put("s\u030cto", 898);
    freq.put("s\u030cky", 77);
    freq.put("s\u030cti", 1747);
    freq.put("s\u030ctu", 1243);
    freq.put("s\u030ctr", 99);
    freq.put("usl", 117);
    freq.put("s\u030cty", 912);
    freq.put("ybe\u0328", 375);
    freq.put("ybe\u0307", 5361);
    freq.put("yba\u0328", 107);
    freq.put(" Me\u0307", 156);
    freq.put("bys", 99);
    freq.put("byl", 146);
    freq.put("Ke\u0307", 213);
    freq.put("e\u0307ti\u0328", 118);
    freq.put("Ku\u0304", 349);
    freq.put("Car", 189);
    freq.put("Cap", 73);
    freq.put("Can", 84);
    freq.put("Cam", 66);
    freq.put("Cal", 67);
    freq.put("Cac", 84);
    freq.put("Cad", 64);
    freq.put("Pre", 234);
    freq.put("nfe", 266);
    freq.put("e\u0307tu\u0328", 311);
    freq.put("Pra", 2269);
    freq.put("nfo", 543);
    freq.put("Pro", 479);
    freq.put("nfl", 92);
    freq.put("Pri", 882);
    freq.put(" \u2212", 501);
    freq.put("nfr", 63);
    freq.put("oun", 122);
    freq.put("ous", 97);
    freq.put("our", 160);
    freq.put("oup", 69);
    freq.put("out", 83);
    freq.put("lt ", 76);
    freq.put("Moz", 127);
    freq.put("ou ", 101);
    freq.put("ltr", 83);
    freq.put("val", 10598);
    freq.put("g", 102928);
    freq.put("lty", 140);
    freq.put("vab", 435);
    freq.put("lta", 1286);
    freq.put("lte", 434);
    freq.put("lti", 1386);
    freq.put("lto", 827);
    freq.put("u\u0308", 86);
    freq.put(" I\u0328k", 141);
    freq.put("K ", 521);
    freq.put(" I\u0328e", 85);
    freq.put("sp ", 78);
    freq.put("c\u030ca", 249);
    freq.put(" I\u0328s", 221);
    freq.put("lu\u0304n", 117);
    freq.put("lu\u0304k", 105);
    freq.put("lu\u0304d", 70);
    freq.put("\u03bb", 109);
    freq.put("lu\u0304s", 124);
    freq.put("Ka", 7199);
    freq.put("Ke", 841);
    freq.put(" I\u0328 ", 86);
    freq.put("Ki", 1470);
    freq.put("Ko", 2668);
    freq.put("Kn", 86);
    freq.put("Kl", 830);
    freq.put("Kr", 1957);
    freq.put("Kv", 191);
    freq.put("Ku", 1466);
    freq.put("Ky", 76);
    freq.put("e\u0307ty", 82);
    freq.put("Pru\u0304", 117);
    freq.put("e\u0307ta", 441);
    freq.put("ybo", 1219);
    freq.put("e\u0307ti", 999);
    freq.put("uau", 101);
    freq.put("ybe", 375);
    freq.put("e\u0307to", 359);
    freq.put("i\u0328ei", 119);
    freq.put("lta\u0328", 68);
    freq.put("voz\u030c", 79);
    freq.put("Po ", 75);
    freq.put("ht", 431);
    freq.put("ltu\u0328", 271);
    freq.put("Pot", 100);
    freq.put("Por", 237);
    freq.put("Pos", 67);
    freq.put("Pop", 119);
    freq.put("Pon", 120);
    freq.put("Pol", 415);
    freq.put("ltu\u0304", 1732);
    freq.put("Pod", 91);
    freq.put("Cha", 378);
    freq.put("a\u0328va", 67);
    freq.put("a\u0328ve", 118);
    freq.put("ta\u0328j", 82);
    freq.put("ha", 2884);
    freq.put("c\u030cia\u0328", 252);
    freq.put("c\u030ciu\u0304", 111);
    freq.put("uti", 3065);
    freq.put("Ry", 867);
    freq.put("c\u030ciu\u0328", 6037);
    freq.put("qu", 225);
    freq.put("ta\u0328 ", 2180);
    freq.put(" ww", 64);
    freq.put("Jak", 178);
    freq.put("ebe", 309);
    freq.put("eba", 313);
    freq.put(" Te\u0307", 65);
    freq.put("ebo", 120);
    freq.put("ebi", 367);
    freq.put("avu\u0328", 296);
    freq.put("jo ", 6159);
    freq.put("ebu", 212);
    freq.put("ebr", 205);
    freq.put("iku", 935);
    freq.put("\u044b", 100);
    freq.put("jor", 274);
    freq.put("jos", 20733);
    freq.put("jot", 90);
    freq.put("jog", 127);
    freq.put("joj", 10950);
    freq.put("jok", 177);
    freq.put("jom", 502);
    freq.put("jon", 4897);
    freq.put("ave\u0328", 277);
    freq.put("lvi", 553);
    freq.put("ave\u0307", 225);
    freq.put("ika", 5325);
    freq.put("Zar", 256);
    freq.put("rps", 98);
    freq.put("rpr", 64);
    freq.put("rpu", 483);
    freq.put("rpt", 814);
    freq.put("bu\u0304s", 338);
    freq.put("rpa", 257);
    freq.put("rpe", 180);
    freq.put("rpi", 679);
    freq.put("rpo", 225);
    freq.put("Jug", 66);
    freq.put("Juk", 63);
    freq.put("Jun", 554);
    freq.put("Juo", 530);
    freq.put("e\u0307c\u030c", 63);
    freq.put("Jur", 232);
    freq.put("Jup", 99);
    freq.put("\u03bf", 198);
    freq.put("myr", 132);
    freq.put("c\u030cio", 4188);
    freq.put("c\u030cin", 247);
    freq.put("c\u030cia", 6305);
    freq.put("rp ", 1398);
    freq.put("Is\u030cs", 132);
    freq.put("c\u030ciu", 3945);
    freq.put("hma", 111);
    freq.put("e\u0301", 265);
    freq.put("avy", 790);
    freq.put("avu", 579);
    freq.put("AR ", 460);
    freq.put("avo", 3989);
    freq.put("avi", 8394);
    freq.put("ave", 644);
    freq.put("ava", 4842);
    freq.put("C\u030cia", 184);
    freq.put("C\u030cil", 228);
    freq.put("C\u030cik", 109);
    freq.put(" Ty", 93);
    freq.put(" Tv", 72);
    freq.put(" Tu", 948);
    freq.put(" Tr", 1262);
    freq.put(" To", 1060);
    freq.put("ebe\u0307", 292);
    freq.put(" Ti", 951);
    freq.put(" Th", 577);
    freq.put(" Te", 1623);
    freq.put(" Ta", 3980);
    freq.put("lve\u0307", 163);
    freq.put("ru\u0328 ", 3880);
    freq.put("mfo", 93);
    freq.put("sku", 545);
    freq.put("skv", 165);
    freq.put("skr", 2283);
    freq.put("Far", 66);
    freq.put("sky", 900);
    freq.put("ske", 580);
    freq.put("ska", 2455);
    freq.put("Fal", 71);
    freq.put("Fab", 73);
    freq.put("skl", 344);
    freq.put("sko", 1593);
    freq.put("ski", 4050);
    freq.put("ru\u0328j", 78);
    freq.put("vac\u030c", 96);
    freq.put("T", 11425);
    freq.put("lvu\u0328", 129);
    freq.put("kdo", 201);
    freq.put("Suc", 101);
    freq.put("Sub", 64);
    freq.put("Suo", 198);
    freq.put("Sun", 92);
    freq.put("Sum", 113);
    freq.put("Suk", 74);
    freq.put("kda", 895);
    freq.put("Suv", 802);
    freq.put("Sus", 251);
    freq.put("kdy", 223);
    freq.put("Sup", 79);
    freq.put("nd ", 453);
    freq.put("z\u030cny", 789);
    freq.put("z\u030cni", 1016);
    freq.put("z\u030cna", 456);
    freq.put("ndi", 4736);
    freq.put("ndo", 1993);
    freq.put("nda", 1898);
    freq.put("nde", 2551);
    freq.put("ndy", 107);
    freq.put("nds", 72);
    freq.put("ndr", 3362);
    freq.put("ndu", 1568);
    freq.put("Ru\u0304", 230);
    freq.put("ows", 92);
    freq.put("vaj", 535);
    freq.put("vak", 4952);
    freq.put("vai", 6631);
    freq.put("van", 3055);
    freq.put("sku\u0328", 182);
    freq.put("vam", 251);
    freq.put("Ama", 241);
    freq.put("vac", 68);
    freq.put("Ame", 1274);
    freq.put("vag", 166);
    freq.put("vad", 6655);
    freq.put("vaz", 104);
    freq.put("var", 5998);
    freq.put("vas", 2439);
    freq.put("vap", 91);
    freq.put("vav", 423);
    freq.put("vat", 733);
    freq.put("vau", 1068);
    freq.put("ske\u0307", 68);
    freq.put("ow ", 66);
    freq.put("Tei", 320);
    freq.put("Tek", 128);
    freq.put("Tel", 387);
    freq.put("Ten", 81);
    freq.put("va ", 1330);
    freq.put("lve", 135);
    freq.put("lva", 657);
    freq.put("Ter", 267);
    freq.put("Tes", 113);
    freq.put("Tet", 74);
    freq.put("anu\u0328", 720);
    freq.put("nda\u0328", 97);
    freq.put("myk", 132);
    freq.put("myl", 81);
    freq.put("myn", 393);
    freq.put("myb", 757);
    freq.put("nde\u0307", 404);
    freq.put("ki\u0328 ", 292);
    freq.put("Afr", 719);
    freq.put("iu\u0328 ", 35485);
    freq.put("\u043d", 471);
    freq.put("u\u0304s\u030ci", 1752);
    freq.put("u\u0304s\u030cy", 191);
    freq.put("ndu\u0304", 86);
    freq.put("iu\u0328j", 519);
    freq.put("e\u0307vi", 102);
    freq.put("ndz\u030c", 626);
    freq.put("ndu\u0328", 534);
    freq.put("e\u0307va", 79);
  }
  
}

