package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class LA extends CLangProfile {
  private static final String name = "la";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public LA() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 97956;
    n_words[1] = 114269;
    n_words[2] = 95604;

    freq.put("all", 39);
    freq.put(" po", 278);
    freq.put("gae", 6);
    freq.put("aua", 3);
    freq.put("xtu", 5);
    freq.put("aue", 9);
    freq.put("xtr", 11);
    freq.put("auf", 3);
    freq.put("aui", 10);
    freq.put("oeb", 3);
    freq.put("aul", 8);
    freq.put("xte", 9);
    freq.put("aur", 18);
    freq.put("aut", 85);
    freq.put("aux", 7);
    freq.put("xti", 7);
    freq.put("Tum", 5);
    freq.put(" Gr", 6);
    freq.put(" Ga", 28);
    freq.put("E ", 4);
    freq.put("upl", 4);
    freq.put("Gr", 6);
    freq.put("upi", 26);
    freq.put("upe", 27);
    freq.put("Ga", 28);
    freq.put("upt", 9);
    freq.put("upr", 6);
    freq.put("upp", 29);
    freq.put("me ", 119);
    freq.put("alv", 11);
    freq.put("alt", 21);
    freq.put("nen", 15);
    freq.put("neo", 4);
    freq.put("nem", 80);
    freq.put("nef", 24);
    freq.put("neg", 20);
    freq.put("neb", 9);
    freq.put("Cy", 29);
    freq.put("nea", 3);
    freq.put("net", 13);
    freq.put("neu", 7);
    freq.put("ner", 70);
    freq.put("nes", 91);
    freq.put("neq", 51);
    freq.put("med", 16);
    freq.put("mea", 58);
    freq.put("mec", 6);
    freq.put("mem", 32);
    freq.put("mel", 9);
    freq.put("meo", 26);
    freq.put("men", 136);
    freq.put("mei", 29);
    freq.put("auc", 27);
    freq.put("ors", 7);
    freq.put("meu", 10);
    freq.put("fun", 12);
    freq.put("mes", 29);
    freq.put("mer", 36);
    freq.put("oed", 3);
    freq.put("aud", 63);
    freq.put("glo", 8);
    freq.put("gla", 12);
    freq.put("gle", 6);
    freq.put("ne ", 177);
    freq.put("bru", 3);
    freq.put("bro", 13);
    freq.put("bri", 16);
    freq.put("bre", 11);
    freq.put("bra", 10);
    freq.put("m ", 2607);
    freq.put("aus", 30);
    freq.put("vol", 47);
    freq.put("er ", 150);
    freq.put("ni ", 54);
    freq.put("Sta", 9);
    freq.put("ngu", 30);
    freq.put("lci", 8);
    freq.put("it", 1163);
    freq.put("V", 43);
    freq.put("iv", 135);
    freq.put("me", 542);
    freq.put("md", 5);
    freq.put("erv", 46);
    freq.put("ma", 411);
    freq.put("erq", 5);
    freq.put("err", 65);
    freq.put("mb", 22);
    freq.put("mm", 73);
    freq.put("mo", 416);
    freq.put("mn", 165);
    freq.put("mi", 532);
    freq.put("mu", 311);
    freq.put("ere", 445);
    freq.put("erf", 42);
    freq.put("erg", 9);
    freq.put("mq", 126);
    freq.put("mp", 233);
    freq.put("ms", 8);
    freq.put("erc", 33);
    freq.put("erm", 23);
    freq.put("ern", 69);
    freq.put("ero", 105);
    freq.put("eri", 348);
    freq.put("Le", 34);
    freq.put("La", 6);
    freq.put("Mul", 5);
    freq.put("uas", 31);
    freq.put("vos", 26);
    freq.put("la ", 131);
    freq.put("uat", 13);
    freq.put("Li", 3);
    freq.put("mpe", 83);
    freq.put("uam", 200);
    freq.put("ual", 13);
    freq.put("uan", 44);
    freq.put("uac", 13);
    freq.put("uae", 173);
    freq.put("uad", 9);
    freq.put("ena", 86);
    freq.put("hod", 8);
    freq.put("hoe", 4);
    freq.put("end", 148);
    freq.put("hoc", 51);
    freq.put("hon", 16);
    freq.put("eni", 143);
    freq.put("hom", 50);
    freq.put("osu", 12);
    freq.put("eno", 9);
    freq.put("far", 18);
    freq.put("ens", 80);
    freq.put("hor", 28);
    freq.put("hos", 46);
    freq.put("mpo", 35);
    freq.put("mpl", 34);
    freq.put("A", 127);
    freq.put("lam", 39);
    freq.put("lan", 35);
    freq.put("L ", 25);
    freq.put("lad", 12);
    freq.put("lae", 34);
    freq.put("lag", 9);
    freq.put("lab", 25);
    freq.put("lac", 46);
    freq.put("ova", 3);
    freq.put("al ", 3);
    freq.put("ove", 22);
    freq.put("lat", 49);
    freq.put("lau", 19);
    freq.put("lav", 3);
    freq.put("ovi", 32);
    freq.put("lap", 10);
    freq.put("laq", 3);
    freq.put("lar", 55);
    freq.put("las", 25);
    freq.put("en ", 59);
    freq.put("All", 11);
    freq.put("Alt", 3);
    freq.put("mps", 3);
    freq.put(" Hy", 9);
    freq.put("fam", 18);
    freq.put(" Hu", 4);
    freq.put(" Hi", 12);
    freq.put("oni", 132);
    freq.put(" Ho", 9);
    freq.put("Mag", 3);
    freq.put(" Ha", 17);
    freq.put(" He", 6);
    freq.put("ono", 22);
    freq.put("ima", 55);
    freq.put("uor", 34);
    freq.put("uoq", 6);
    freq.put("ime", 45);
    freq.put("cli", 6);
    freq.put("fit", 7);
    freq.put("uot", 17);
    freq.put("imi", 86);
    freq.put("fix", 4);
    freq.put("imm", 8);
    freq.put("cla", 27);
    freq.put("imo", 71);
    freq.put("uoc", 13);
    freq.put("imp", 64);
    freq.put("Hic", 4);
    freq.put("imu", 103);
    freq.put(" ga", 12);
    freq.put("fid", 21);
    freq.put("fie", 9);
    freq.put("clu", 10);
    freq.put("fin", 10);
    freq.put("uon", 21);
    freq.put("fil", 6);
    freq.put("uol", 11);
    freq.put("ona", 29);
    freq.put(" Ve", 12);
    freq.put(" Vi", 10);
    freq.put(" Vo", 9);
    freq.put("one", 119);
    freq.put("im ", 81);
    freq.put("l", 3291);
    freq.put("Hi ", 3);
    freq.put("uci", 29);
    freq.put("uo ", 70);
    freq.put("dep", 30);
    freq.put("mda", 3);
    freq.put("ons", 216);
    freq.put("nt ", 371);
    freq.put("rt", 286);
    freq.put("ru", 499);
    freq.put("rv", 50);
    freq.put("rp", 43);
    freq.put("rq", 9);
    freq.put("rr", 110);
    freq.put("rs", 76);
    freq.put("ry", 4);
    freq.put("rd", 68);
    freq.put("re", 1419);
    freq.put("rf", 42);
    freq.put("rg", 40);
    freq.put("ra", 779);
    freq.put("rb", 161);
    freq.put("rc", 75);
    freq.put("got", 3);
    freq.put("rn", 93);
    freq.put("is ", 1162);
    freq.put("rh", 3);
    freq.put("ri", 1058);
    freq.put("gor", 9);
    freq.put("ntr", 33);
    freq.put("ntu", 163);
    freq.put("nti", 220);
    freq.put("nth", 29);
    freq.put("Ego", 7);
    freq.put("nto", 27);
    freq.put("nta", 67);
    freq.put("nte", 251);
    freq.put("ate", 97);
    freq.put("xur", 5);
    freq.put("xus", 3);
    freq.put("iss", 218);
    freq.put("ato", 69);
    freq.put("isq", 20);
    freq.put("isp", 5);
    freq.put("go ", 101);
    freq.put("isu", 6);
    freq.put("ist", 119);
    freq.put("isi", 23);
    freq.put("atu", 193);
    freq.put("r ", 510);
    freq.put("atq", 130);
    freq.put("isc", 35);
    freq.put("xum", 5);
    freq.put("isa", 10);
    freq.put("ise", 40);
    freq.put("isd", 4);
    freq.put("on ", 268);
    freq.put("nis", 173);
    freq.put("tem", 241);
    freq.put("xie", 4);
    freq.put("tor", 121);
    freq.put("tos", 53);
    freq.put("toq", 4);
    freq.put("xil", 23);
    freq.put("xim", 30);
    freq.put("tot", 33);
    freq.put("xir", 4);
    freq.put("xis", 14);
    freq.put("xit", 21);
    freq.put("tol", 13);
    freq.put("tog", 6);
    freq.put("tod", 22);
    freq.put(" le", 68);
    freq.put("B", 7);
    freq.put(" la", 95);
    freq.put(" lo", 51);
    freq.put(" li", 94);
    freq.put(" lu", 37);
    freq.put(" ly", 5);
    freq.put("xi ", 10);
    freq.put("vac", 4);
    freq.put("Ser", 5);
    freq.put("Sed", 18);
    freq.put("to ", 124);
    freq.put("rad", 10);
    freq.put("rae", 144);
    freq.put("rab", 17);
    freq.put("rac", 10);
    freq.put("ran", 45);
    freq.put("ram", 44);
    freq.put("rah", 6);
    freq.put("rav", 17);
    freq.put("Q ", 6);
    freq.put("rat", 188);
    freq.put("rau", 10);
    freq.put("rar", 52);
    freq.put("ras", 42);
    freq.put("rap", 9);
    freq.put("dur", 20);
    freq.put("bs ", 4);
    freq.put("yps", 3);
    freq.put("do ", 89);
    freq.put("hun", 12);
    freq.put("Qu", 142);
    freq.put("thi", 29);
    freq.put("ra ", 172);
    freq.put("bst", 7);
    freq.put("uem", 39);
    freq.put("y", 70);
    freq.put("bsi", 7);
    freq.put("abd", 4);
    freq.put("abe", 53);
    freq.put("don", 7);
    freq.put("dol", 27);
    freq.put("dom", 54);
    freq.put("doc", 8);
    freq.put("m", 5704);
    freq.put("Ita", 29);
    freq.put("ogn", 14);
    freq.put("lpi", 3);
    freq.put("abi", 35);
    freq.put("dor", 16);
    freq.put("dos", 21);
    freq.put("lpa", 3);
    freq.put("ude", 44);
    freq.put("d ", 460);
    freq.put("nec", 66);
    freq.put("oci", 33);
    freq.put("em ", 520);
    freq.put("oco", 6);
    freq.put("oca", 29);
    freq.put("oga", 14);
    freq.put("occ", 18);
    freq.put("oce", 31);
    freq.put("ba ", 13);
    freq.put("ocu", 34);
    freq.put("oct", 38);
    freq.put("abu", 16);
    freq.put("do", 228);
    freq.put("dm", 11);
    freq.put("dh", 5);
    freq.put("di", 713);
    freq.put("df", 9);
    freq.put("dd", 8);
    freq.put("de", 774);
    freq.put("dc", 6);
    freq.put("da", 198);
    freq.put("dv", 5);
    freq.put("X", 13);
    freq.put("du", 234);
    freq.put("dr", 4);
    freq.put("ds", 19);
    freq.put("dq", 6);
    freq.put("eme", 34);
    freq.put("bat", 37);
    freq.put("bar", 10);
    freq.put("bas", 7);
    freq.put("emb", 11);
    freq.put("emm", 3);
    freq.put("oc ", 46);
    freq.put("emo", 46);
    freq.put("emn", 8);
    freq.put("emi", 48);
    freq.put("emu", 35);
    freq.put("bae", 3);
    freq.put("emq", 23);
    freq.put("emp", 91);
    freq.put("ban", 20);
    freq.put("bam", 18);
    freq.put("nut", 6);
    freq.put("nus", 63);
    freq.put("nup", 3);
    freq.put("nun", 30);
    freq.put("nul", 51);
    freq.put("num", 125);
    freq.put("nui", 16);
    freq.put("nud", 6);
    freq.put("nue", 10);
    freq.put("nua", 4);
    freq.put("mut", 14);
    freq.put("il ", 26);
    freq.put("mur", 27);
    freq.put("irr", 3);
    freq.put("irt", 18);
    freq.put("iru", 5);
    freq.put("iri", 71);
    freq.put("irm", 10);
    freq.put("iro", 15);
    freq.put("mum", 56);
    freq.put("ira", 16);
    freq.put("irc", 16);
    freq.put("mui", 12);
    freq.put("ire", 64);
    freq.put("irg", 4);
    freq.put("C", 234);
    freq.put("ome", 27);
    freq.put("omi", 98);
    freq.put(" It", 30);
    freq.put("omn", 146);
    freq.put("omm", 31);
    freq.put("meh", 3);
    freq.put("omp", 44);
    freq.put(" Il", 8);
    freq.put(" In", 17);
    freq.put(" Io", 10);
    freq.put(" Ia", 11);
    freq.put(" Id", 12);
    freq.put("nu ", 10);
    freq.put("cur", 55);
    freq.put("cop", 14);
    freq.put("cos", 4);
    freq.put("ile", 25);
    freq.put("unt", 206);
    freq.put("ell", 123);
    freq.put("ila", 22);
    freq.put("ill", 204);
    freq.put("ili", 244);
    freq.put("una", 44);
    freq.put("ilu", 5);
    freq.put("coe", 14);
    freq.put("une", 23);
    freq.put("cog", 46);
    freq.put("ung", 10);
    freq.put("ir ", 5);
    freq.put("uni", 45);
    freq.put("com", 82);
    freq.put("col", 28);
    freq.put("con", 446);
    freq.put("and", 99);
    freq.put("ela", 16);
    freq.put(" ma", 190);
    freq.put(" mo", 162);
    freq.put(" mi", 184);
    freq.put("inf", 33);
    freq.put(" mu", 99);
    freq.put("ele", 73);
    freq.put("san", 29);
    freq.put("fra", 13);
    freq.put("che", 4);
    freq.put("fre", 10);
    freq.put("lti", 27);
    freq.put("fri", 11);
    freq.put("sal", 52);
    freq.put("fro", 4);
    freq.put("sac", 7);
    freq.put("fru", 8);
    freq.put("pro", 177);
    freq.put("cub", 6);
    freq.put("cun", 19);
    freq.put("pru", 9);
    freq.put("Ci", 17);
    freq.put("Co", 8);
    freq.put("gnu", 17);
    freq.put("aiu", 5);
    freq.put("Ca", 109);
    freq.put("Ce", 19);
    freq.put("n", 5972);
    freq.put("aio", 14);
    freq.put("gna", 33);
    freq.put("gne", 4);
    freq.put("gni", 35);
    freq.put("gno", 31);
    freq.put("Cu", 14);
    freq.put("ix", 45);
    freq.put("iq", 88);
    freq.put("ip", 129);
    freq.put("is", 1746);
    freq.put("ir", 229);
    freq.put("iu", 595);
    freq.put("Om", 7);
    freq.put("Nam", 13);
    freq.put("ii", 150);
    freq.put("ih", 127);
    freq.put("im", 523);
    freq.put("il", 534);
    freq.put("io", 372);
    freq.put("in", 1297);
    freq.put("ia", 748);
    freq.put("opp", 15);
    freq.put("ic", 640);
    freq.put("ib", 393);
    freq.put("ie", 244);
    freq.put("id", 485);
    freq.put("ig", 141);
    freq.put("if", 18);
    freq.put("V ", 3);
    freq.put("dhu", 4);
    freq.put("nih", 28);
    freq.put("nii", 6);
    freq.put("nin", 4);
    freq.put("nio", 17);
    freq.put("nim", 92);
    freq.put("nib", 65);
    freq.put("nic", 25);
    freq.put("nia", 67);
    freq.put("nif", 9);
    freq.put("nig", 3);
    freq.put("nie", 11);
    freq.put("nix", 4);
    freq.put("nir", 6);
    freq.put("i ", 1254);
    freq.put("niq", 28);
    freq.put("niv", 11);
    freq.put("nit", 67);
    freq.put("niu", 106);
    freq.put("Ve", 12);
    freq.put("Vi", 10);
    freq.put("ept", 28);
    freq.put(" L ", 25);
    freq.put("epr", 11);
    freq.put("eps", 4);
    freq.put("Vo", 9);
    freq.put("epo", 11);
    freq.put("eph", 3);
    freq.put("epi", 17);
    freq.put("the", 17);
    freq.put("epe", 47);
    freq.put("tha", 8);
    freq.put("dse", 7);
    freq.put("eli", 91);
    freq.put("hal", 3);
    freq.put("elo", 5);
    freq.put("han", 30);
    freq.put("bir", 9);
    freq.put("hab", 33);
    freq.put("hac", 29);
    freq.put("hae", 47);
    freq.put("bis", 129);
    freq.put("Gal", 23);
    freq.put("lch", 4);
    freq.put("har", 5);
    freq.put("has", 4);
    freq.put("hat", 3);
    freq.put("hau", 3);
    freq.put("elu", 10);
    freq.put("opt", 26);
    freq.put("opu", 42);
    freq.put("rni", 31);
    freq.put("rno", 21);
    freq.put("D", 24);
    freq.put("opr", 3);
    freq.put("rna", 28);
    freq.put("rne", 7);
    freq.put("ope", 21);
    freq.put("opa", 3);
    freq.put("opo", 13);
    freq.put("opi", 25);
    freq.put("rnu", 6);
    freq.put("IO ", 4);
    freq.put("efi", 12);
    freq.put("el ", 9);
    freq.put("Arg", 5);
    freq.put("ola", 15);
    freq.put("ole", 30);
    freq.put("oli", 34);
    freq.put("oll", 45);
    freq.put("olo", 41);
    freq.put("olt", 10);
    freq.put("olu", 73);
    freq.put("umu", 17);
    freq.put("ici", 174);
    freq.put("Hy", 9);
    freq.put("ico", 20);
    freq.put("ump", 13);
    freq.put("for", 102);
    freq.put("icl", 3);
    freq.put("ica", 188);
    freq.put("ice", 100);
    freq.put("Hu", 4);
    freq.put("Lep", 3);
    freq.put("foe", 3);
    freq.put("Hi", 12);
    freq.put("uma", 15);
    freq.put("Ho", 9);
    freq.put("foc", 3);
    freq.put("umm", 24);
    freq.put("icq", 5);
    freq.put("Ha", 17);
    freq.put("umi", 21);
    freq.put("icu", 59);
    freq.put("He", 6);
    freq.put("plu", 10);
    freq.put("ple", 19);
    freq.put("pla", 31);
    freq.put("plo", 3);
    freq.put("pli", 37);
    freq.put("obo", 7);
    freq.put("obl", 12);
    freq.put("obi", 82);
    freq.put("ic ", 63);
    freq.put("o", 5678);
    freq.put("oba", 3);
    freq.put("um ", 1219);
    freq.put("obt", 3);
    freq.put("obu", 7);
    freq.put("obr", 13);
    freq.put("obs", 18);
    freq.put("soc", 14);
    freq.put("ars", 5);
    freq.put("chu", 5);
    freq.put("ppe", 8);
    freq.put("ahe", 3);
    freq.put("ppi", 4);
    freq.put("ppo", 6);
    freq.put("sol", 72);
    freq.put("ppl", 24);
    freq.put("ppr", 12);
    freq.put("sos", 16);
    freq.put("sor", 9);
    freq.put("Cum", 11);
    freq.put("mbr", 18);
    freq.put("art", 28);
    freq.put("git", 64);
    freq.put("gis", 35);
    freq.put("gie", 4);
    freq.put("gid", 3);
    freq.put("gib", 4);
    freq.put("gia", 5);
    freq.put("gio", 7);
    freq.put("gin", 10);
    freq.put("gil", 20);
    freq.put("so ", 17);
    freq.put("Z", 3);
    freq.put("Vol", 8);
    freq.put("gi ", 7);
    freq.put("ci ", 35);
    freq.put("nno", 4);
    freq.put("nni", 5);
    freq.put("nne", 6);
    freq.put("Sic", 4);
    freq.put("D ", 10);
    freq.put("nnu", 7);
    freq.put("Id ", 5);
    freq.put("Sil", 6);
    freq.put("nh", 3);
    freq.put("ni", 783);
    freq.put("nl", 19);
    freq.put("nm", 27);
    freq.put("nn", 26);
    freq.put("no", 631);
    freq.put("tit", 71);
    freq.put("na", 451);
    freq.put("tiv", 3);
    freq.put("nc", 219);
    freq.put("nd", 362);
    freq.put("ne", 648);
    freq.put("nf", 72);
    freq.put("ng", 82);
    freq.put("nx", 4);
    freq.put("tim", 69);
    freq.put("tin", 47);
    freq.put("tio", 133);
    freq.put("tii", 14);
    freq.put("np", 29);
    freq.put("nq", 16);
    freq.put("ns", 349);
    freq.put("nt", 1171);
    freq.put("nu", 329);
    freq.put("nv", 59);
    freq.put("tic", 27);
    freq.put(" ni", 60);
    freq.put("E", 56);
    freq.put(" no", 489);
    freq.put(" na", 32);
    freq.put(" ne", 227);
    freq.put("squ", 62);
    freq.put("Si ", 5);
    freq.put("tec", 20);
    freq.put("umq", 67);
    freq.put(" nu", 124);
    freq.put("ums", 5);
    freq.put("n ", 629);
    freq.put("mme", 9);
    freq.put("Tul", 8);
    freq.put("ti ", 166);
    freq.put("roi", 5);
    freq.put("rol", 5);
    freq.put("rom", 3);
    freq.put("ron", 18);
    freq.put("osq", 10);
    freq.put("osp", 5);
    freq.put("rob", 25);
    freq.put("roc", 14);
    freq.put("rod", 8);
    freq.put("ost", 135);
    freq.put("rof", 34);
    freq.put("rog", 21);
    freq.put("rox", 16);
    freq.put("lli", 123);
    freq.put("llo", 83);
    freq.put("ob ", 6);
    freq.put("oso", 8);
    freq.put("rop", 30);
    freq.put("ror", 37);
    freq.put("ros", 62);
    freq.put("rot", 3);
    freq.put("rou", 3);
    freq.put("rov", 22);
    freq.put("ume", 23);
    freq.put("vet", 9);
    freq.put("ver", 138);
    freq.put("ves", 76);
    freq.put("umd", 3);
    freq.put("urt", 5);
    freq.put("di ", 49);
    freq.put("vex", 4);
    freq.put("ven", 48);
    freq.put("vel", 16);
    freq.put("vem", 13);
    freq.put("veh", 16);
    freq.put("Cic", 13);
    freq.put("ert", 113);
    freq.put("eru", 147);
    freq.put("ro ", 143);
    freq.put("umb", 7);
    freq.put("erp", 11);
    freq.put("Gab", 5);
    freq.put("dil", 17);
    freq.put("dim", 11);
    freq.put("din", 28);
    freq.put("dio", 31);
    freq.put("dii", 34);
    freq.put("gue", 5);
    freq.put("did", 11);
    freq.put("die", 60);
    freq.put("gui", 9);
    freq.put("ers", 55);
    freq.put("gun", 6);
    freq.put("gum", 18);
    freq.put("gul", 10);
    freq.put("gus", 8);
    freq.put("p", 2420);
    freq.put("dix", 19);
    freq.put("ve ", 7);
    freq.put("gut", 4);
    freq.put("dit", 77);
    freq.put("diu", 41);
    freq.put("Tan", 3);
    freq.put("ict", 24);
    freq.put("der", 102);
    freq.put("dir", 10);
    freq.put("dis", 79);
    freq.put("des", 72);
    freq.put("M ", 31);
    freq.put("Gra", 6);
    freq.put("IN ", 6);
    freq.put("uls", 10);
    freq.put("erd", 25);
    freq.put("ffe", 7);
    freq.put("Qua", 39);
    freq.put("Que", 3);
    freq.put("AM ", 5);
    freq.put("bo ", 14);
    freq.put("Quo", 29);
    freq.put("era", 201);
    freq.put("Me", 11);
    freq.put("rua", 8);
    freq.put("Ma", 24);
    freq.put("erb", 35);
    freq.put("deo", 43);
    freq.put("Mi", 8);
    freq.put("Mu", 9);
    freq.put("O", 27);
    freq.put("Qui", 71);
    freq.put("deb", 41);
    freq.put("bor", 23);
    freq.put("bos", 3);
    freq.put("bon", 24);
    freq.put("ard", 19);
    freq.put("ipe", 14);
    freq.put("ipi", 21);
    freq.put("ngi", 9);
    freq.put("ips", 52);
    freq.put("ipp", 4);
    freq.put("ipt", 29);
    freq.put("ipu", 5);
    freq.put(" Ka", 5);
    freq.put("Min", 3);
    freq.put(" ii", 14);
    freq.put("msi", 3);
    freq.put("ul ", 15);
    freq.put("ca ", 44);
    freq.put("uar", 24);
    freq.put("ngr", 9);
    freq.put("cis", 43);
    freq.put("F", 14);
    freq.put("ma ", 57);
    freq.put("ulu", 37);
    freq.put("ibi", 99);
    freq.put("cas", 32);
    freq.put("car", 71);
    freq.put("ulp", 5);
    freq.put("cap", 14);
    freq.put("flu", 6);
    freq.put("ibe", 43);
    freq.put("cau", 23);
    freq.put("cat", 41);
    freq.put("fli", 5);
    freq.put("uli", 103);
    freq.put("can", 32);
    freq.put("cam", 39);
    freq.put("cal", 6);
    freq.put("fla", 17);
    freq.put("ulc", 13);
    freq.put("ula", 70);
    freq.put("fle", 17);
    freq.put("ibu", 239);
    freq.put("cae", 84);
    freq.put("cad", 7);
    freq.put(" ol", 4);
    freq.put(" om", 145);
    freq.put("ger", 26);
    freq.put(" of", 3);
    freq.put(" od", 7);
    freq.put(" ob", 46);
    freq.put(" oc", 39);
    freq.put("spi", 36);
    freq.put("spo", 16);
    freq.put("spa", 3);
    freq.put(" ot", 6);
    freq.put(" or", 43);
    freq.put("spe", 48);
    freq.put(" op", 55);
    freq.put("s ", 3097);
    freq.put("maq", 4);
    freq.put("mas", 8);
    freq.put("mar", 19);
    freq.put("mat", 19);
    freq.put("mav", 3);
    freq.put("max", 17);
    freq.put("idi", 107);
    freq.put(" o ", 11);
    freq.put("uga", 5);
    freq.put("mae", 21);
    freq.put("mad", 4);
    freq.put("mag", 51);
    freq.put("mai", 17);
    freq.put("lmi", 4);
    freq.put("mam", 15);
    freq.put("mal", 26);
    freq.put("ene", 59);
    freq.put("ss", 615);
    freq.put("sq", 62);
    freq.put("sp", 104);
    freq.put(" pa", 191);
    freq.put("su", 516);
    freq.put("st", 804);
    freq.put("q", 1580);
    freq.put("si", 756);
    freq.put("so", 147);
    freq.put("sc", 244);
    freq.put("sa", 275);
    freq.put("se", 856);
    freq.put("sd", 10);
    freq.put("lsa", 5);
    freq.put("no ", 64);
    freq.put("ttu", 3);
    freq.put("Re", 8);
    freq.put("tti", 4);
    freq.put("lsu", 7);
    freq.put("tto", 4);
    freq.put("tta", 4);
    freq.put("Ro", 47);
    freq.put("tte", 20);
    freq.put(" ab", 55);
    freq.put(" ac", 129);
    freq.put(" ad", 223);
    freq.put(" ae", 42);
    freq.put(" af", 3);
    freq.put(" ag", 28);
    freq.put(" ai", 3);
    freq.put(" al", 81);
    freq.put(" am", 108);
    freq.put(" an", 89);
    freq.put("tie", 25);
    freq.put(" ap", 22);
    freq.put(" aq", 7);
    freq.put(" ar", 55);
    freq.put(" as", 21);
    freq.put(" at", 151);
    freq.put(" au", 164);
    freq.put(" av", 5);
    freq.put("nsa", 12);
    freq.put("ent", 442);
    freq.put("gel", 3);
    freq.put("enu", 28);
    freq.put("nom", 21);
    freq.put("non", 291);
    freq.put("som", 8);
    freq.put("nob", 30);
    freq.put("noc", 39);
    freq.put("nox", 7);
    freq.put("not", 17);
    freq.put("qu", 1580);
    freq.put("nov", 9);
    freq.put("son", 6);
    freq.put("nop", 3);
    freq.put("nor", 36);
    freq.put("nos", 95);
    freq.put(" a ", 99);
    freq.put("LI ", 4);
    freq.put("em", 881);
    freq.put("el", 328);
    freq.put("eo", 154);
    freq.put("en", 1060);
    freq.put("ei", 159);
    freq.put("eh", 32);
    freq.put("ee", 4);
    freq.put("ed", 270);
    freq.put("eg", 218);
    freq.put("ef", 100);
    freq.put("ea", 199);
    freq.put("ec", 407);
    freq.put("eb", 126);
    freq.put("ex", 239);
    freq.put("eu", 81);
    freq.put("et", 956);
    freq.put("ev", 43);
    freq.put("eq", 115);
    freq.put("ep", 141);
    freq.put("es", 1278);
    freq.put("er", 1938);
    freq.put("nsu", 97);
    freq.put("bli", 127);
    freq.put("dif", 6);
    freq.put("bla", 10);
    freq.put("G", 39);
    freq.put("ort", 122);
    freq.put("oru", 180);
    freq.put("orr", 18);
    freq.put("e ", 2541);
    freq.put("orp", 9);
    freq.put("orq", 3);
    freq.put("orn", 8);
    freq.put("oro", 15);
    freq.put("orm", 18);
    freq.put("ori", 120);
    freq.put("ord", 22);
    freq.put("ore", 189);
    freq.put("orb", 6);
    freq.put("ora", 56);
    freq.put("mos", 23);
    freq.put("lla", 162);
    freq.put(" ce", 79);
    freq.put("II ", 4);
    freq.put("xi", 111);
    freq.put("onn", 6);
    freq.put("xo", 5);
    freq.put("xc", 18);
    freq.put("xa", 20);
    freq.put("onf", 39);
    freq.put("ong", 22);
    freq.put("ond", 36);
    freq.put("xe", 34);
    freq.put("ua ", 70);
    freq.put("xs", 7);
    freq.put("xp", 26);
    freq.put("onv", 24);
    freq.put("xt", 36);
    freq.put("xu", 18);
    freq.put("iam", 289);
    freq.put("ian", 12);
    freq.put("iae", 96);
    freq.put("dib", 15);
    freq.put("iac", 17);
    freq.put("ule", 34);
    freq.put("iat", 32);
    freq.put("fo", 111);
    freq.put("iaq", 4);
    freq.put("ias", 29);
    freq.put("iar", 13);
    freq.put("huc", 5);
    freq.put(" Ze", 3);
    freq.put("hum", 12);
    freq.put("x ", 80);
    freq.put("dic", 109);
    freq.put("hui", 43);
    freq.put("ebi", 26);
    freq.put("hus", 3);
    freq.put("ia ", 241);
    freq.put("r", 5886);
    freq.put("ehe", 32);
    freq.put("pre", 40);
    freq.put("ane", 28);
    freq.put("ang", 13);
    freq.put("pra", 108);
    freq.put("ana", 17);
    freq.put("sam", 12);
    freq.put("anc", 35);
    freq.put("anl", 10);
    freq.put("ann", 12);
    freq.put("ano", 20);
    freq.put("pri", 80);
    freq.put("ani", 94);
    freq.put("sae", 44);
    freq.put("ant", 278);
    freq.put("anu", 39);
    freq.put("sax", 4);
    freq.put("ans", 15);
    freq.put("sas", 9);
    freq.put("sar", 16);
    freq.put("sau", 5);
    freq.put("sat", 21);
    freq.put("Pho", 3);
    freq.put("Di", 7);
    freq.put("De", 8);
    freq.put("an ", 12);
    freq.put("tiu", 73);
    freq.put("sa ", 68);
    freq.put(" Le", 34);
    freq.put(" La", 6);
    freq.put("axu", 3);
    freq.put(" Li", 3);
    freq.put("axa", 3);
    freq.put("axi", 15);
    freq.put("nlu", 5);
    freq.put("ge ", 9);
    freq.put("xor", 3);
    freq.put("nli", 10);
    freq.put("ce ", 34);
    freq.put("lub", 15);
    freq.put("Cyn", 28);
    freq.put("ges", 28);
    freq.put(" pr", 346);
    freq.put(" pu", 213);
    freq.put("get", 9);
    freq.put("ssu", 53);
    freq.put("H", 61);
    freq.put("rvo", 5);
    freq.put("geb", 3);
    freq.put("sso", 7);
    freq.put("ssi", 167);
    freq.put(" pe", 247);
    freq.put("sse", 351);
    freq.put(" pi", 5);
    freq.put("ssa", 37);
    freq.put("gen", 63);
    freq.put("gem", 6);
    freq.put(" pl", 36);
    freq.put("cid", 33);
    freq.put("iqu", 88);
    freq.put("cii", 19);
    freq.put("uti", 39);
    freq.put("uto", 6);
    freq.put("rma", 27);
    freq.put("cim", 10);
    freq.put("rme", 3);
    freq.put("lne", 5);
    freq.put("rmi", 32);
    freq.put("rmo", 18);
    freq.put("utr", 4);
    freq.put("cir", 21);
    freq.put("cip", 34);
    freq.put("fir", 10);
    freq.put("tus", 166);
    freq.put("tup", 9);
    freq.put("tur", 293);
    freq.put("cit", 89);
    freq.put("tut", 37);
    freq.put("tuu", 7);
    freq.put("tui", 44);
    freq.put("tul", 70);
    freq.put("tum", 211);
    freq.put("tun", 30);
    freq.put("tuo", 30);
    freq.put("fat", 24);
    freq.put("tud", 35);
    freq.put("tue", 15);
    freq.put(" be", 46);
    freq.put(" ba", 5);
    freq.put(" bl", 7);
    freq.put(" bo", 24);
    freq.put("vum", 4);
    freq.put(" bi", 6);
    freq.put("P ", 17);
    freq.put("s", 7695);
    freq.put("vus", 3);
    freq.put(" br", 6);
    freq.put("unu", 16);
    freq.put("pot", 75);
    freq.put("por", 49);
    freq.put("pos", 138);
    freq.put("pop", 42);
    freq.put("pon", 43);
    freq.put("Ant", 3);
    freq.put("pol", 5);
    freq.put("tua", 39);
    freq.put("poe", 20);
    freq.put("tib", 93);
    freq.put("fic", 43);
    freq.put("ei ", 65);
    freq.put("cqu", 9);
    freq.put("fig", 3);
    freq.put("uod", 130);
    freq.put("eis", 24);
    freq.put("eiu", 24);
    freq.put("eic", 4);
    freq.put("eie", 17);
    freq.put("ein", 12);
    freq.put("ive", 38);
    freq.put("uxu", 5);
    freq.put("iva", 13);
    freq.put("ivo", 3);
    freq.put("ivi", 80);
    freq.put("uxe", 5);
    freq.put("mqu", 126);
    freq.put("uxo", 3);
    freq.put("mod", 63);
    freq.put("Len", 26);
    freq.put(" Me", 11);
    freq.put("par", 82);
    freq.put("pas", 3);
    freq.put("pat", 84);
    freq.put("pau", 13);
    freq.put(" Mi", 8);
    freq.put(" Mu", 9);
    freq.put("pac", 9);
    freq.put("pae", 9);
    freq.put("I ", 13);
    freq.put("pal", 10);
    freq.put("uic", 26);
    freq.put("Etr", 7);
    freq.put("oin", 3);
    freq.put("fon", 3);
    freq.put("I", 107);
    freq.put("Mar", 6);
    freq.put("Ete", 12);
    freq.put("mpa", 8);
    freq.put("uib", 27);
    freq.put(" M ", 22);
    freq.put("ccu", 16);
    freq.put("It", 30);
    freq.put("cci", 15);
    freq.put("Il", 8);
    freq.put("Io", 10);
    freq.put("In", 17);
    freq.put("Ia", 11);
    freq.put("uie", 12);
    freq.put("Id", 12);
    freq.put("cer", 178);
    freq.put(" qu", 931);
    freq.put("am ", 785);
    freq.put("ps ", 4);
    freq.put("ucu", 12);
    freq.put("tiq", 4);
    freq.put("uct", 26);
    freq.put("tir", 12);
    freq.put("uid", 121);
    freq.put("co", 703);
    freq.put("tis", 328);
    freq.put("ucr", 5);
    freq.put("til", 88);
    freq.put("ot ", 3);
    freq.put("gre", 22);
    freq.put("ami", 36);
    freq.put("psi", 21);
    freq.put("amm", 7);
    freq.put("pso", 10);
    freq.put("amo", 52);
    freq.put("amn", 3);
    freq.put("ama", 42);
    freq.put("mor", 172);
    freq.put("psa", 10);
    freq.put("ame", 62);
    freq.put("mov", 11);
    freq.put("mou", 3);
    freq.put("pse", 10);
    freq.put("tid", 5);
    freq.put("mon", 28);
    freq.put("mol", 21);
    freq.put("amq", 36);
    freq.put("amp", 15);
    freq.put("ams", 3);
    freq.put("Ze", 3);
    freq.put("amu", 21);
    freq.put("moe", 8);
    freq.put("psu", 12);
    freq.put("dsi", 10);
    freq.put("tig", 14);
    freq.put("Pic", 3);
    freq.put("tia", 193);
    freq.put("t", 7698);
    freq.put("ucc", 4);
    freq.put("Man", 11);
    freq.put("uco", 3);
    freq.put("Neq", 5);
    freq.put(" ch", 5);
    freq.put(" ci", 89);
    freq.put(" co", 650);
    freq.put(" cl", 23);
    freq.put("Mem", 4);
    freq.put("Iov", 7);
    freq.put(" ca", 150);
    freq.put("mph", 10);
    freq.put("ddu", 4);
    freq.put("o ", 1018);
    freq.put("Met", 4);
    freq.put("cu", 511);
    freq.put(" cr", 44);
    freq.put(" cu", 255);
    freq.put("mpi", 9);
    freq.put("nmo", 23);
    freq.put("acc", 32);
    freq.put("on", 1067);
    freq.put("aca", 9);
    freq.put("ol", 251);
    freq.put("ace", 68);
    freq.put("oh", 3);
    freq.put("og", 74);
    freq.put("of", 37);
    freq.put("aci", 76);
    freq.put("ach", 4);
    freq.put("oc", 243);
    freq.put("ob", 156);
    freq.put("oa", 4);
    freq.put("acr", 24);
    freq.put("acu", 18);
    freq.put("ox", 25);
    freq.put("ov", 57);
    freq.put("ou", 15);
    freq.put("ot", 178);
    freq.put("os", 668);
    freq.put("or", 902);
    freq.put("oq", 31);
    freq.put("op", 148);
    freq.put("Ni", 5);
    freq.put("No", 22);
    freq.put("uil", 8);
    freq.put("Na", 14);
    freq.put("Ne", 9);
    freq.put("Ny", 4);
    freq.put("Nu", 24);
    freq.put("lob", 11);
    freq.put("loc", 31);
    freq.put("her", 16);
    freq.put("hes", 10);
    freq.put("lon", 27);
    freq.put("lor", 54);
    freq.put("los", 24);
    freq.put("heg", 14);
    freq.put("hem", 15);
    freq.put("hen", 18);
    freq.put("hei", 3);
    freq.put("N ", 8);
    freq.put("na ", 153);
    freq.put("Ad ", 3);
    freq.put("lo ", 89);
    freq.put("as ", 257);
    freq.put("uia", 11);
    freq.put("ac", 416);
    freq.put("ab", 185);
    freq.put("ae", 835);
    freq.put("ad", 276);
    freq.put("ag", 103);
    freq.put("af", 3);
    freq.put("ai", 27);
    freq.put("ah", 6);
    freq.put("rvi", 12);
    freq.put("Hom", 3);
    freq.put("am", 1145);
    freq.put("al", 306);
    freq.put("uio", 4);
    freq.put("an", 674);
    freq.put("aq", 31);
    freq.put("ap", 64);
    freq.put("as", 391);
    freq.put("ar", 559);
    freq.put("au", 266);
    freq.put("at", 1155);
    freq.put("rvu", 4);
    freq.put("av", 64);
    freq.put("ax", 24);
    freq.put("igu", 8);
    freq.put("igr", 3);
    freq.put("Lae", 4);
    freq.put("ige", 18);
    freq.put("iga", 9);
    freq.put("ota", 30);
    freq.put("ign", 62);
    freq.put("igi", 39);
    freq.put("a ", 1472);
    freq.put("met", 22);
    freq.put("at ", 185);
    freq.put("u", 8111);
    freq.put("uit", 117);
    freq.put("pto", 11);
    freq.put("alo", 6);
    freq.put("sco", 7);
    freq.put("alm", 4);
    freq.put("sci", 53);
    freq.put("pti", 41);
    freq.put("ali", 113);
    freq.put("sce", 120);
    freq.put("iu ", 16);
    freq.put("pte", 14);
    freq.put("ale", 33);
    freq.put("sca", 11);
    freq.put("mnu", 4);
    freq.put("pta", 27);
    freq.put("ala", 19);
    freq.put("mni", 116);
    freq.put("eda", 14);
    freq.put("mno", 8);
    freq.put("scu", 20);
    freq.put("mna", 4);
    freq.put("ptu", 22);
    freq.put("alu", 46);
    freq.put("als", 5);
    freq.put("scr", 33);
    freq.put("tt", 36);
    freq.put("tu", 1100);
    freq.put("tr", 355);
    freq.put("tq", 153);
    freq.put("tn", 3);
    freq.put("to", 389);
    freq.put("th", 56);
    freq.put("ti", 1375);
    freq.put("tu ", 105);
    freq.put("te", 1137);
    freq.put("oss", 87);
    freq.put("ta", 1108);
    freq.put("iui", 10);
    freq.put("edi", 66);
    freq.put("ium", 213);
    freq.put("iun", 30);
    freq.put("iua", 5);
    freq.put("fas", 6);
    freq.put("iuc", 9);
    freq.put("iub", 7);
    freq.put("iue", 12);
    freq.put("iud", 21);
    freq.put("iug", 13);
    freq.put("fau", 5);
    freq.put("mpt", 17);
    freq.put("mpu", 13);
    freq.put("mpr", 21);
    freq.put("llu", 69);
    freq.put("fal", 10);
    freq.put("rm", 82);
    freq.put("fac", 94);
    freq.put("ius", 206);
    freq.put("iur", 38);
    freq.put("iuu", 7);
    freq.put("iut", 4);
    freq.put("iuv", 3);
    freq.put(" Ni", 5);
    freq.put("osi", 26);
    freq.put("ro", 458);
    freq.put(" No", 22);
    freq.put(" Na", 14);
    freq.put(" Ne", 9);
    freq.put("ge", 148);
    freq.put(" Ny", 4);
    freq.put(" Nu", 24);
    freq.put("t ", 1922);
    freq.put("ass", 39);
    freq.put("tel", 27);
    freq.put("ga", 93);
    freq.put("ten", 85);
    freq.put("tea", 16);
    freq.put("teb", 7);
    freq.put("edu", 27);
    freq.put("asq", 5);
    freq.put("tef", 10);
    freq.put("teg", 8);
    freq.put("osa", 13);
    freq.put("asp", 11);
    freq.put("tep", 4);
    freq.put("ter", 295);
    freq.put("tes", 139);
    freq.put("tet", 9);
    freq.put("osc", 24);
    freq.put("aba", 20);
    freq.put("sue", 11);
    freq.put("suc", 4);
    freq.put("sub", 35);
    freq.put("sua", 32);
    freq.put("suo", 13);
    freq.put("sun", 69);
    freq.put("sum", 99);
    freq.put("sul", 83);
    freq.put("sui", 22);
    freq.put("abo", 20);
    freq.put("mmu", 15);
    freq.put("suu", 4);
    freq.put("abs", 9);
    freq.put("sus", 64);
    freq.put("sur", 13);
    freq.put("sup", 45);
    freq.put(" ru", 12);
    freq.put("te ", 249);
    freq.put("K", 5);
    freq.put(" re", 319);
    freq.put(" ra", 33);
    freq.put("pub", 117);
    freq.put(" ro", 14);
    freq.put(" ri", 3);
    freq.put("ab ", 21);
    freq.put("asc", 12);
    freq.put("su ", 17);
    freq.put("mmo", 14);
    freq.put("mmi", 13);
    freq.put("vib", 8);
    freq.put("vic", 14);
    freq.put("via", 5);
    freq.put("vig", 16);
    freq.put("vid", 125);
    freq.put("vii", 3);
    freq.put("vin", 21);
    freq.put("vio", 3);
    freq.put("vil", 8);
    freq.put("vim", 6);
    freq.put("vir", 53);
    freq.put("vis", 51);
    freq.put("viv", 21);
    freq.put("mun", 28);
    freq.put("vit", 89);
    freq.put("viu", 32);
    freq.put("vix", 8);
    freq.put("ear", 6);
    freq.put("ull", 101);
    freq.put("dfe", 6);
    freq.put("mus", 85);
    freq.put("de ", 95);
    freq.put("giu", 6);
    freq.put("In ", 4);
    freq.put("vi ", 31);
    freq.put("Su", 11);
    freq.put("St", 9);
    freq.put("Si", 21);
    freq.put("Sc", 3);
    freq.put("Sa", 6);
    freq.put(" X", 13);
    freq.put("Se", 28);
    freq.put(" do", 92);
    freq.put("Vid", 7);
    freq.put(" di", 216);
    freq.put("Int", 7);
    freq.put(" de", 349);
    freq.put("ata", 101);
    freq.put("det", 33);
    freq.put("deu", 5);
    freq.put(" da", 22);
    freq.put("ioq", 4);
    freq.put("dei", 13);
    freq.put("del", 44);
    freq.put("dem", 122);
    freq.put("den", 58);
    freq.put("v", 1062);
    freq.put("dea", 23);
    freq.put(" du", 91);
    freq.put("dec", 27);
    freq.put("ded", 18);
    freq.put("dee", 3);
    freq.put("def", 34);
    freq.put("avi", 44);
    freq.put("ati", 300);
    freq.put("att", 8);
    freq.put("rya", 3);
    freq.put("atr", 70);
    freq.put("uxi", 15);
    freq.put("fr", 46);
    freq.put("fu", 121);
    freq.put("fa", 182);
    freq.put("fe", 198);
    freq.put("ff", 18);
    freq.put("fi", 117);
    freq.put("fl", 49);
    freq.put(" Ma", 24);
    freq.put("a", 8095);
    freq.put("egr", 15);
    freq.put("egu", 8);
    freq.put("egi", 33);
    freq.put("ego", 97);
    freq.put("egn", 6);
    freq.put("egl", 6);
    freq.put("ega", 28);
    freq.put("ege", 25);
    freq.put("ito", 65);
    freq.put("iti", 141);
    freq.put("ffu", 4);
    freq.put("ite", 133);
    freq.put("ita", 263);
    freq.put("ffi", 5);
    freq.put("os ", 316);
    freq.put("itt", 26);
    freq.put("itu", 137);
    freq.put("itr", 8);
    freq.put(" Om", 7);
    freq.put(" Or", 4);
    freq.put("ced", 23);
    freq.put("ym", 5);
    freq.put("yl", 11);
    freq.put("cea", 4);
    freq.put("yn", 30);
    freq.put("ya", 3);
    freq.put("cen", 64);
    freq.put("cem", 26);
    freq.put("cel", 69);
    freq.put("L", 73);
    freq.put("it ", 381);
    freq.put("cet", 50);
    freq.put("ces", 56);
    freq.put("Era", 3);
    freq.put("cep", 26);
    freq.put("yp", 4);
    freq.put("yr", 8);
    freq.put("Bai", 3);
    freq.put("epu", 15);
    freq.put(" O ", 7);
    freq.put("ife", 8);
    freq.put("iff", 4);
    freq.put("Nym", 3);
    freq.put("man", 140);
    freq.put("ynt", 28);
    freq.put("ifi", 6);
    freq.put("dig", 18);
    freq.put(" sp", 33);
    freq.put(" st", 50);
    freq.put(" su", 280);
    freq.put(" si", 341);
    freq.put(" so", 97);
    freq.put(" sc", 68);
    freq.put("uda", 24);
    freq.put(" sa", 132);
    freq.put(" se", 364);
    freq.put("gur", 4);
    freq.put("Omn", 7);
    freq.put("bui", 10);
    freq.put("pul", 72);
    freq.put("pun", 8);
    freq.put(" Ac", 5);
    freq.put(" Ad", 7);
    freq.put("asu", 8);
    freq.put("ast", 35);
    freq.put("pud", 20);
    freq.put("pue", 41);
    freq.put("pug", 5);
    freq.put(" Al", 19);
    freq.put(" Am", 18);
    freq.put(" An", 11);
    freq.put(" Ap", 6);
    freq.put(" Ar", 10);
    freq.put(" As", 3);
    freq.put(" At", 29);
    freq.put(" Au", 3);
    freq.put("put", 29);
    freq.put("asi", 7);
    freq.put("mma", 22);
    freq.put("div", 3);
    freq.put("pur", 12);
    freq.put("pus", 6);
    freq.put("Eo", 3);
    freq.put("Eg", 8);
    freq.put("Ex", 3);
    freq.put("Eu", 3);
    freq.put("Et", 22);
    freq.put("Es", 4);
    freq.put("Er", 6);
    freq.put("le ", 74);
    freq.put("equ", 115);
    freq.put("nc ", 90);
    freq.put(" el", 4);
    freq.put(" em", 7);
    freq.put(" en", 37);
    freq.put(" eo", 53);
    freq.put("st ", 193);
    freq.put(" ei", 45);
    freq.put(" ed", 13);
    freq.put(" ef", 8);
    freq.put(" eg", 102);
    freq.put(" ea", 49);
    freq.put(" ec", 5);
    freq.put("Cet", 16);
    freq.put(" ex", 214);
    freq.put(" et", 483);
    freq.put(" eu", 9);
    freq.put(" ev", 5);
    freq.put(" eq", 10);
    freq.put(" er", 86);
    freq.put(" es", 353);
    freq.put("uef", 4);
    freq.put("ncr", 8);
    freq.put("nct", 15);
    freq.put("ncu", 15);
    freq.put("nci", 34);
    freq.put("ncl", 6);
    freq.put("uec", 3);
    freq.put("nco", 8);
    freq.put("nca", 3);
    freq.put("nce", 29);
    freq.put("ste", 70);
    freq.put("b", 1352);
    freq.put("sta", 97);
    freq.put("sto", 42);
    freq.put("sth", 4);
    freq.put("sti", 174);
    freq.put("Nun", 14);
    freq.put("stu", 55);
    freq.put("Nul", 4);
    freq.put("Num", 6);
    freq.put("str", 163);
    freq.put("At ", 6);
    freq.put("uet", 15);
    freq.put("lid", 3);
    freq.put("lie", 20);
    freq.put("Nih", 3);
    freq.put("lig", 22);
    freq.put("lia", 62);
    freq.put("ex ", 59);
    freq.put("lic", 197);
    freq.put("lim", 16);
    freq.put("lin", 109);
    freq.put("lio", 31);
    freq.put("lii", 22);
    freq.put("lit", 95);
    freq.put("liu", 74);
    freq.put("efl", 3);
    freq.put("liq", 43);
    freq.put("lir", 3);
    freq.put("lis", 130);
    freq.put("efa", 33);
    freq.put("lix", 5);
    freq.put("efe", 43);
    freq.put("eff", 8);
    freq.put("cch", 9);
    freq.put("ofu", 3);
    freq.put("M", 77);
    freq.put("cce", 15);
    freq.put("Atq", 20);
    freq.put("The", 6);
    freq.put("exe", 20);
    freq.put("li ", 86);
    freq.put("exc", 18);
    freq.put("exa", 12);
    freq.put("exi", 46);
    freq.put("ext", 33);
    freq.put("exu", 6);
    freq.put("exs", 7);
    freq.put("exp", 25);
    freq.put("rte", 62);
    freq.put("ugi", 17);
    freq.put("rta", 57);
    freq.put("ugn", 5);
    freq.put("Hab", 8);
    freq.put("rti", 97);
    freq.put("Hae", 5);
    freq.put("uge", 10);
    freq.put("rtu", 57);
    freq.put("ugu", 3);
    freq.put("ymp", 5);
    freq.put("evi", 12);
    freq.put("ies", 27);
    freq.put("ier", 31);
    freq.put("iet", 23);
    freq.put("iei", 3);
    freq.put("iem", 23);
    freq.put("ien", 68);
    freq.put("iec", 35);
    freq.put("ieb", 8);
    freq.put("ox ", 7);
    freq.put("his", 29);
    freq.put("hia", 29);
    freq.put("hib", 4);
    freq.put("hic", 23);
    freq.put("hil", 32);
    freq.put("hin", 10);
    freq.put("rfr", 3);
    freq.put("rfu", 3);
    freq.put("cru", 24);
    freq.put("cra", 6);
    freq.put("oxi", 16);
    freq.put("rfe", 19);
    freq.put("cre", 45);
    freq.put("ie ", 21);
    freq.put("rfi", 17);
    freq.put("cri", 57);
    freq.put("cro", 4);
    freq.put("arp", 3);
    freq.put("sev", 9);
    freq.put("seu", 8);
    freq.put("set", 59);
    freq.put(" Ba", 6);
    freq.put("ser", 118);
    freq.put("seq", 17);
    freq.put("sep", 7);
    freq.put(" e ", 9);
    freq.put("ara", 37);
    freq.put("arb", 15);
    freq.put("sed", 90);
    freq.put("sec", 26);
    freq.put("are", 171);
    freq.put("arg", 12);
    freq.put("sen", 156);
    freq.put("sem", 55);
    freq.put("sel", 5);
    freq.put("arm", 29);
    freq.put("aro", 3);
    freq.put("mo ", 63);
    freq.put(" P ", 17);
    freq.put("uus", 6);
    freq.put("ue ", 422);
    freq.put("ar ", 19);
    freq.put("uul", 4);
    freq.put("se ", 259);
    freq.put("uue", 4);
    freq.put("Ba", 6);
    freq.put(" Pr", 9);
    freq.put("c", 3772);
    freq.put(" Pa", 12);
    freq.put(" Pe", 5);
    freq.put(" Pi", 3);
    freq.put(" Ph", 6);
    freq.put(" Po", 13);
    freq.put("oqu", 31);
    freq.put("lex", 11);
    freq.put("ga ", 9);
    freq.put("pr", 414);
    freq.put("ps", 69);
    freq.put("pp", 57);
    freq.put("dul", 14);
    freq.put("dum", 76);
    freq.put("pt", 115);
    freq.put("pu", 314);
    freq.put("dua", 5);
    freq.put("dub", 11);
    freq.put("duc", 49);
    freq.put("xat", 3);
    freq.put("due", 5);
    freq.put("dux", 13);
    freq.put("pa", 218);
    freq.put("nau", 8);
    freq.put("pe", 551);
    freq.put("ph", 15);
    freq.put("pi", 183);
    freq.put("po", 379);
    freq.put("pl", 101);
    freq.put("gav", 4);
    freq.put(" tu", 200);
    freq.put("gat", 32);
    freq.put("gas", 9);
    freq.put(" tr", 47);
    freq.put("N", 80);
    freq.put(" to", 45);
    freq.put("gan", 6);
    freq.put("gam", 5);
    freq.put(" ti", 95);
    freq.put(" te", 222);
    freq.put(" ta", 222);
    freq.put("fut", 12);
    freq.put("fur", 24);
    freq.put("fug", 19);
    freq.put("fue", 15);
    freq.put("xa ", 9);
    freq.put("ful", 3);
    freq.put("adi", 29);
    freq.put("fui", 35);
    freq.put("vob", 41);
    freq.put("voc", 26);
    freq.put("riv", 13);
    freq.put("rit", 195);
    freq.put("riu", 46);
    freq.put("rir", 8);
    freq.put("ris", 206);
    freq.put("rip", 35);
    freq.put("riq", 5);
    freq.put("rin", 26);
    freq.put("rio", 43);
    freq.put("rim", 80);
    freq.put("vor", 3);
    freq.put("rii", 24);
    freq.put("rig", 8);
    freq.put("rid", 16);
    freq.put("rie", 13);
    freq.put("rib", 67);
    freq.put("ric", 53);
    freq.put("ria", 88);
    freq.put("ceb", 7);
    freq.put("tqu", 153);
    freq.put("vo ", 4);
    freq.put("Ill", 8);
    freq.put("mot", 15);
    freq.put("ri ", 119);
    freq.put("Con", 3);
    freq.put(" fr", 30);
    freq.put(" fu", 109);
    freq.put("lib", 58);
    freq.put(" fa", 146);
    freq.put(" fe", 63);
    freq.put(" fi", 43);
    freq.put(" fl", 35);
    freq.put(" fo", 110);
    freq.put("bi ", 98);
    freq.put("O ", 11);
    freq.put("cuu", 3);
    freq.put("cut", 16);
    freq.put("cus", 41);
    freq.put("rgu", 7);
    freq.put("cup", 24);
    freq.put("rga", 7);
    freq.put("rge", 10);
    freq.put("cuo", 4);
    freq.put("rgi", 13);
    freq.put("cum", 215);
    freq.put("cul", 82);
    freq.put("app", 6);
    freq.put("cui", 40);
    freq.put("rgo", 3);
    freq.put("bin", 8);
    freq.put("bil", 25);
    freq.put("bii", 3);
    freq.put("bid", 8);
    freq.put("bie", 10);
    freq.put("bib", 3);
    freq.put("Dic", 4);
    freq.put("bit", 56);
    freq.put("gr", 79);
    freq.put("Or", 4);
    freq.put("d", 2723);
    freq.put("b ", 35);
    freq.put(" Qu", 142);
    freq.put("pet", 24);
    freq.put("per", 372);
    freq.put("pes", 28);
    freq.put("pel", 10);
    freq.put("pem", 9);
    freq.put("pen", 20);
    freq.put("ped", 9);
    freq.put("id ", 105);
    freq.put("pec", 33);
    freq.put("bd", 7);
    freq.put("be", 245);
    freq.put("rui", 18);
    freq.put("run", 71);
    freq.put("ba", 111);
    freq.put("rum", 320);
    freq.put("bl", 137);
    freq.put("ruc", 11);
    freq.put("bo", 66);
    freq.put("bi", 363);
    freq.put("rud", 22);
    freq.put("rue", 4);
    freq.put("bt", 3);
    freq.put("bu", 287);
    freq.put("oen", 26);
    freq.put("br", 53);
    freq.put("bs", 34);
    freq.put("rur", 5);
    freq.put("rus", 26);
    freq.put("rup", 11);
    freq.put("oeg", 4);
    freq.put("fec", 54);
    freq.put("Rom", 47);
    freq.put("idu", 16);
    freq.put(" Q ", 6);
    freq.put("ido", 19);
    freq.put("yla", 6);
    freq.put("yll", 3);
    freq.put("ide", 199);
    freq.put("pe ", 36);
    freq.put("ida", 28);
    freq.put("nsi", 81);
    freq.put(" ux", 3);
    freq.put("nso", 6);
    freq.put(" ut", 167);
    freq.put(" uu", 3);
    freq.put(" C ", 25);
    freq.put("nsc", 35);
    freq.put("nse", 32);
    freq.put(" ur", 102);
    freq.put(" us", 7);
    freq.put(" ul", 39);
    freq.put(" um", 17);
    freq.put(" un", 71);
    freq.put(" uo", 27);
    freq.put(" ui", 51);
    freq.put("bse", 8);
    freq.put("nsp", 6);
    freq.put(" ue", 80);
    freq.put("nst", 34);
    freq.put(" ua", 23);
    freq.put(" ub", 11);
    freq.put("ut ", 198);
    freq.put("ixi", 16);
    freq.put("xpo", 7);
    freq.put("ixa", 5);
    freq.put("xpe", 16);
    freq.put("ixe", 6);
    freq.put("uss", 17);
    freq.put("bsc", 6);
    freq.put("u ", 172);
    freq.put("ixt", 3);
    freq.put("ixu", 3);
    freq.put("aqu", 31);
    freq.put(" Ci", 17);
    freq.put(" Co", 8);
    freq.put("ns ", 41);
    freq.put(" Ca", 109);
    freq.put(" Ce", 19);
    freq.put("sde", 8);
    freq.put(" Cy", 29);
    freq.put("Fla", 4);
    freq.put(" Cu", 14);
    freq.put("cib", 14);
    freq.put("cia", 49);
    freq.put("uta", 53);
    freq.put("ux", 30);
    freq.put("cie", 41);
    freq.put("ute", 77);
    freq.put("uu", 29);
    freq.put("ut", 419);
    freq.put("ix ", 11);
    freq.put("uv", 3);
    freq.put("cio", 51);
    freq.put("up", 105);
    freq.put("us", 1044);
    freq.put("ur", 631);
    freq.put("um", 1530);
    freq.put("ul", 560);
    freq.put("uo", 366);
    freq.put("un", 459);
    freq.put("ui", 829);
    freq.put("civ", 71);
    freq.put("ciu", 22);
    freq.put("utu", 31);
    freq.put("ue", 767);
    freq.put("ud", 186);
    freq.put("ug", 40);
    freq.put("uf", 4);
    freq.put("ua", 598);
    freq.put("uc", 120);
    freq.put("ub", 207);
    freq.put("lyr", 4);
    freq.put("cin", 23);
    freq.put("Tu", 18);
    freq.put("Th", 7);
    freq.put("Ti", 5);
    freq.put("Te", 4);
    freq.put("Ta", 5);
    freq.put("A ", 6);
    freq.put("Mas", 3);
    freq.put("gru", 3);
    freq.put(" gr", 35);
    freq.put("nae", 35);
    freq.put("nan", 12);
    freq.put("nal", 3);
    freq.put("nam", 70);
    freq.put("nar", 24);
    freq.put("nas", 30);
    freq.put(" ge", 49);
    freq.put("nav", 3);
    freq.put("nat", 101);
    freq.put("gra", 44);
    freq.put("gro", 3);
    freq.put(" gl", 20);
    freq.put("gri", 7);
    freq.put("cil", 23);
    freq.put("ac ", 104);
    freq.put("T ", 3);
    freq.put("ago", 5);
    freq.put("agn", 33);
    freq.put("Ac", 5);
    freq.put("e", 11462);
    freq.put("Ad", 7);
    freq.put("agi", 35);
    freq.put("dve", 5);
    freq.put("age", 6);
    freq.put("Am", 18);
    freq.put("Al", 19);
    freq.put("aga", 5);
    freq.put("An", 11);
    freq.put("Ap", 6);
    freq.put("As", 3);
    freq.put("Ar", 10);
    freq.put("Au", 3);
    freq.put("At", 29);
    freq.put("agr", 14);
    freq.put(" b", 95);
    freq.put(" c", 1298);
    freq.put("gu", 70);
    freq.put(" a", 1293);
    freq.put(" f", 536);
    freq.put(" g", 118);
    freq.put(" d", 772);
    freq.put(" e", 1494);
    freq.put(" h", 472);
    freq.put(" i", 1425);
    freq.put(" n", 932);
    freq.put(" o", 380);
    freq.put(" l", 350);
    freq.put(" m", 972);
    freq.put(" r", 381);
    freq.put(" s", 1365);
    freq.put(" p", 1317);
    freq.put(" q", 931);
    freq.put(" v", 626);
    freq.put(" t", 833);
    freq.put(" u", 603);
    freq.put("go", 123);
    freq.put("gn", 120);
    freq.put("gl", 26);
    freq.put("gi", 169);
    freq.put(" B", 7);
    freq.put(" C", 234);
    freq.put("Non", 12);
    freq.put(" A", 127);
    freq.put(" F", 14);
    freq.put(" G", 39);
    freq.put(" D", 24);
    freq.put(" E", 56);
    freq.put(" K", 5);
    freq.put(" H", 61);
    freq.put(" I", 107);
    freq.put(" N", 80);
    freq.put(" O", 27);
    freq.put(" L", 73);
    freq.put(" M", 77);
    freq.put(" R", 57);
    freq.put(" S", 87);
    freq.put(" P", 71);
    freq.put(" Q", 156);
    freq.put(" V", 43);
    freq.put(" T", 54);
    freq.put(" U", 9);
    freq.put(" Z", 3);
    freq.put("Nov", 7);
    freq.put("rto", 9);
    freq.put("ed ", 91);
    freq.put("P", 71);
    freq.put("tri", 101);
    freq.put("hi ", 96);
    freq.put("tro", 57);
    freq.put("evo", 8);
    freq.put("tra", 123);
    freq.put("eva", 8);
    freq.put("us ", 849);
    freq.put("tre", 43);
    freq.put("eve", 15);
    freq.put("iba", 7);
    freq.put("tru", 31);
    freq.put("rro", 12);
    freq.put("uel", 40);
    freq.put("uen", 48);
    freq.put("rri", 31);
    freq.put("ulv", 6);
    freq.put("rre", 34);
    freq.put("ods", 9);
    freq.put("odu", 10);
    freq.put("rra", 21);
    freq.put("cav", 9);
    freq.put("odi", 43);
    freq.put("ult", 107);
    freq.put("odo", 49);
    freq.put("oda", 7);
    freq.put("rru", 11);
    freq.put("odc", 4);
    freq.put("ode", 11);
    freq.put("ues", 18);
    freq.put("uer", 134);
    freq.put("bdi", 5);
    freq.put("ulo", 52);
    freq.put("lea", 5);
    freq.put("leb", 11);
    freq.put("lec", 26);
    freq.put("flo", 4);
    freq.put("leg", 45);
    freq.put("lei", 3);
    freq.put("lem", 28);
    freq.put("len", 42);
    freq.put("ler", 76);
    freq.put("les", 36);
    freq.put("let", 17);
    freq.put("leu", 16);
    freq.put("lev", 11);
    freq.put("od ", 107);
    freq.put("rdu", 6);
    freq.put("ctu", 93);
    freq.put("ulg", 3);
    freq.put("rde", 3);
    freq.put("cte", 27);
    freq.put("rda", 8);
    freq.put("cta", 91);
    freq.put("rdo", 7);
    freq.put("cto", 54);
    freq.put("rdi", 44);
    freq.put("cti", 39);
    freq.put("Ver", 4);
    freq.put("Ves", 3);
    freq.put(" Di", 7);
    freq.put("aps", 6);
    freq.put(" De", 8);
    freq.put("apt", 6);
    freq.put("apu", 7);
    freq.put("api", 24);
    freq.put("ii ", 32);
    freq.put("Ven", 5);
    freq.put("ape", 13);
    freq.put("cha", 3);
    freq.put("usd", 3);
    freq.put("usc", 15);
    freq.put("Fu", 6);
    freq.put("usa", 25);
    freq.put("fen", 17);
    freq.put("chi", 5);
    freq.put("fel", 11);
    freq.put("xce", 3);
    freq.put("usi", 5);
    freq.put("cho", 6);
    freq.put("Fa", 3);
    freq.put("usu", 15);
    freq.put("ust", 55);
    freq.put("fer", 88);
    freq.put("fes", 21);
    freq.put("usq", 17);
    freq.put("usp", 13);
    freq.put("Fl", 4);
    freq.put("iit", 3);
    freq.put("iis", 112);
    freq.put("om", 421);
    freq.put(" D ", 4);
    freq.put("oi", 7);
    freq.put("f", 842);
    freq.put(" Re", 8);
    freq.put(" Ro", 47);
    freq.put("oe", 52);
    freq.put("tat", 178);
    freq.put("tav", 12);
    freq.put("od", 248);
    freq.put("taq", 9);
    freq.put("tar", 68);
    freq.put("tas", 86);
    freq.put("xci", 10);
    freq.put("xcl", 3);
    freq.put("tae", 44);
    freq.put("tab", 29);
    freq.put("tac", 22);
    freq.put("tal", 55);
    freq.put("tam", 188);
    freq.put("tan", 112);
    freq.put("sis", 43);
    freq.put(" ve", 205);
    freq.put("siv", 7);
    freq.put("siu", 13);
    freq.put("sit", 98);
    freq.put(" vi", 270);
    freq.put(" vo", 127);
    freq.put(" os", 18);
    freq.put("sic", 33);
    freq.put("sib", 19);
    freq.put("sia", 4);
    freq.put("sig", 25);
    freq.put("sid", 63);
    freq.put("sio", 22);
    freq.put("sin", 80);
    freq.put("sim", 119);
    freq.put("sil", 49);
    freq.put(" va", 23);
    freq.put("npo", 3);
    freq.put("npe", 8);
    freq.put("act", 68);
    freq.put("Q", 156);
    freq.put("ta ", 286);
    freq.put("npu", 7);
    freq.put("npr", 10);
    freq.put("si ", 162);
    freq.put("VI ", 3);
    freq.put("da ", 35);
    freq.put("eum", 14);
    freq.put("lg", 3);
    freq.put("euo", 4);
    freq.put("le", 407);
    freq.put("eui", 16);
    freq.put("lc", 17);
    freq.put("la", 510);
    freq.put("ln", 6);
    freq.put("lo", 259);
    freq.put("ll", 534);
    freq.put("lm", 5);
    freq.put("eua", 6);
    freq.put("li", 990);
    freq.put("lv", 19);
    freq.put("lt", 142);
    freq.put("lu", 308);
    freq.put("ls", 16);
    freq.put("lp", 8);
    freq.put("eus", 12);
    freq.put("ly", 8);
    freq.put("dae", 13);
    freq.put("dab", 3);
    freq.put("dac", 18);
    freq.put("Cas", 8);
    freq.put("dam", 51);
    freq.put("dan", 12);
    freq.put("Cap", 5);
    freq.put("Cat", 81);
    freq.put("dat", 29);
    freq.put("dar", 11);
    freq.put("Cal", 3);
    freq.put("ema", 11);
    freq.put("Cae", 8);
    freq.put("nfe", 31);
    freq.put("Pra", 4);
    freq.put("l ", 54);
    freq.put("nfl", 8);
    freq.put("Pri", 3);
    freq.put("eu ", 12);
    freq.put(" hu", 65);
    freq.put(" hi", 62);
    freq.put(" ho", 189);
    freq.put("nfr", 7);
    freq.put(" ha", 140);
    freq.put(" he", 16);
    freq.put("Sat", 4);
    freq.put("ec ", 95);
    freq.put("oua", 3);
    freq.put("oue", 6);
    freq.put("rex", 3);
    freq.put("rer", 33);
    freq.put("res", 183);
    freq.put("rep", 28);
    freq.put("req", 8);
    freq.put("rev", 17);
    freq.put("ret", 91);
    freq.put("reu", 7);
    freq.put("reh", 13);
    freq.put("rei", 54);
    freq.put("ren", 83);
    freq.put("reo", 11);
    freq.put("rel", 38);
    freq.put("rem", 132);
    freq.put("reb", 19);
    freq.put("rec", 27);
    freq.put("rea", 18);
    freq.put("ref", 11);
    freq.put("reg", 20);
    freq.put("red", 32);
    freq.put("ece", 51);
    freq.put("eca", 9);
    freq.put("eco", 7);
    freq.put("ecl", 9);
    freq.put("eci", 31);
    freq.put("qua", 419);
    freq.put("ecu", 47);
    freq.put("ect", 131);
    freq.put("que", 516);
    freq.put("ecr", 18);
    freq.put("ecq", 4);
    freq.put("x", 370);
    freq.put("qui", 396);
    freq.put("quo", 247);
    freq.put("ltr", 3);
    freq.put("val", 6);
    freq.put("g", 831);
    freq.put("mac", 4);
    freq.put("lta", 35);
    freq.put("lte", 24);
    freq.put("rcu", 29);
    freq.put("Tu ", 4);
    freq.put("re ", 558);
    freq.put("lto", 28);
    freq.put("rs ", 12);
    freq.put("arr", 7);
    freq.put("ud ", 14);
    freq.put("ihi", 127);
    freq.put("ses", 20);
    freq.put("aru", 44);
    freq.put("arv", 4);
    freq.put("be ", 34);
    freq.put(" St", 9);
    freq.put(" Su", 11);
    freq.put(" Si", 21);
    freq.put(" Sc", 3);
    freq.put(" Sa", 6);
    freq.put(" Se", 28);
    freq.put("Ka", 5);
    freq.put("rso", 7);
    freq.put("rsi", 11);
    freq.put("udu", 4);
    freq.put("ogu", 10);
    freq.put("rse", 3);
    freq.put("rsa", 20);
    freq.put("ogo", 8);
    freq.put("R", 57);
    freq.put("ogi", 22);
    freq.put("vas", 9);
    freq.put("oge", 5);
    freq.put("rsu", 15);
    freq.put("udi", 89);
    freq.put("rsp", 6);
    freq.put("udo", 10);
    freq.put("ben", 26);
    freq.put("beo", 5);
    freq.put("bel", 40);
    freq.put("bem", 30);
    freq.put("beb", 6);
    freq.put("bea", 9);
    freq.put("onc", 31);
    freq.put("arc", 15);
    freq.put("ber", 61);
    freq.put("bes", 10);
    freq.put("bet", 17);
    freq.put("Pat", 3);
    freq.put("nqu", 16);
    freq.put("ari", 147);
    freq.put("mih", 94);
    freq.put("ur ", 212);
    freq.put("mil", 26);
    freq.put("min", 172);
    freq.put("mia", 6);
    freq.put("mic", 24);
    freq.put("mid", 5);
    freq.put("mix", 3);
    freq.put("mis", 118);
    freq.put("mir", 7);
    freq.put("miu", 8);
    freq.put("mit", 33);
    freq.put(" Eo", 3);
    freq.put(" Eg", 8);
    freq.put(" Ex", 3);
    freq.put(" Et", 22);
    freq.put(" Eu", 3);
    freq.put(" Er", 6);
    freq.put(" Es", 4);
    freq.put("ure", 23);
    freq.put("urg", 10);
    freq.put("ura", 91);
    freq.put("urb", 105);
    freq.put("urc", 8);
    freq.put("mi ", 26);
    freq.put("urn", 16);
    freq.put("uro", 31);
    freq.put("mne", 33);
    freq.put("uri", 57);
    freq.put("Pon", 3);
    freq.put("uru", 22);
    freq.put("Pom", 4);
    freq.put("urp", 18);
    freq.put("urr", 15);
    freq.put("urs", 8);
    freq.put("Iam", 5);
    freq.put("Ian", 3);
    freq.put("nge", 22);
    freq.put("Dec", 4);
    freq.put("nga", 12);
    freq.put("co ", 17);
    freq.put(" ip", 50);
    freq.put(" ir", 22);
    freq.put(" is", 64);
    freq.put(" it", 44);
    freq.put(" iu", 82);
    freq.put("ae ", 436);
    freq.put(" il", 193);
    freq.put(" im", 77);
    freq.put(" in", 692);
    freq.put(" ia", 107);
    freq.put(" ib", 6);
    freq.put(" id", 45);
    freq.put(" ig", 26);
    freq.put("mul", 85);
    freq.put("aeq", 19);
    freq.put("aep", 27);
    freq.put("aes", 71);
    freq.put("aer", 28);
    freq.put("aeu", 9);
    freq.put("aet", 56);
    freq.put("h", 766);
    freq.put("aec", 70);
    freq.put("aed", 42);
    freq.put("aei", 3);
    freq.put("aem", 11);
    freq.put("ael", 7);
    freq.put("aen", 10);
    freq.put("Pr", 9);
    freq.put("ebe", 16);
    freq.put("eba", 49);
    freq.put("ebo", 6);
    freq.put("oma", 47);
    freq.put("ebu", 20);
    freq.put("Pa", 12);
    freq.put("Kal", 5);
    freq.put("ebr", 9);
    freq.put("Pe", 5);
    freq.put("ede", 60);
    freq.put("Ph", 6);
    freq.put("Pi", 3);
    freq.put("Po", 13);
    freq.put("lup", 5);
    freq.put("lur", 7);
    freq.put("lus", 45);
    freq.put("lut", 37);
    freq.put("lux", 7);
    freq.put("lua", 5);
    freq.put("et ", 581);
    freq.put("luc", 10);
    freq.put("lud", 14);
    freq.put("lue", 17);
    freq.put("lui", 15);
    freq.put("lum", 108);
    freq.put("lun", 21);
    freq.put("omo", 8);
    freq.put("S", 87);
    freq.put("eun", 6);
    freq.put("etr", 5);
    freq.put("uum", 10);
    freq.put("etu", 86);
    freq.put("eue", 8);
    freq.put("eta", 20);
    freq.put("ete", 70);
    freq.put("eth", 15);
    freq.put("eti", 130);
    freq.put("eto", 18);
    freq.put("ci", 582);
    freq.put("ch", 23);
    freq.put("rpu", 4);
    freq.put("omu", 19);
    freq.put("Her", 4);
    freq.put("cl", 47);
    freq.put("cc", 57);
    freq.put("ca", 410);
    freq.put("rva", 23);
    freq.put("ce", 542);
    freq.put("uce", 29);
    freq.put("Est", 4);
    freq.put("rpe", 16);
    freq.put("uca", 6);
    freq.put("rpi", 11);
    freq.put("cr", 136);
    freq.put("cq", 9);
    freq.put("rpo", 9);
    freq.put("ct", 304);
    freq.put("An ", 5);
    freq.put("rve", 6);
    freq.put("pia", 24);
    freq.put("pib", 5);
    freq.put("oti", 57);
    freq.put("oto", 9);
    freq.put("pid", 15);
    freq.put("c ", 411);
    freq.put("edo", 5);
    freq.put("ote", 48);
    freq.put("pie", 11);
    freq.put("cor", 45);
    freq.put("uc ", 6);
    freq.put("uin", 20);
    freq.put("otu", 29);
    freq.put("cot", 4);
    freq.put("rbu", 3);
    freq.put("uis", 144);
    freq.put("rbo", 7);
    freq.put("uir", 53);
    freq.put("UM ", 3);
    freq.put("rbi", 64);
    freq.put("uiu", 55);
    freq.put("rbe", 63);
    freq.put("rba", 23);
    freq.put("Hos", 4);
    freq.put("va", 74);
    freq.put(" Fu", 6);
    freq.put("ve", 332);
    freq.put("vi", 495);
    freq.put("vo", 152);
    freq.put(" Fa", 3);
    freq.put("vu", 9);
    freq.put("ave", 15);
    freq.put(" Fl", 4);
    freq.put("io ", 137);
    freq.put("pis", 13);
    freq.put("piu", 4);
    freq.put("unc", 65);
    freq.put("und", 36);
    freq.put("phi", 4);
    freq.put("pha", 4);
    freq.put("ios", 34);
    freq.put("ior", 72);
    freq.put("phe", 3);
    freq.put("iop", 3);
    freq.put("ion", 109);
    freq.put("ont", 85);
    freq.put("off", 3);
    freq.put("ofe", 20);
    freq.put("i", 11152);
    freq.put(" Tu", 18);
    freq.put("ofi", 10);
    freq.put(" Ti", 5);
    freq.put(" Th", 7);
    freq.put(" Te", 4);
    freq.put("uno", 10);
    freq.put(" Ta", 5);
    freq.put("onu", 11);
    freq.put(" me", 337);
    freq.put("das", 18);
    freq.put("xer", 30);
    freq.put("nou", 7);
    freq.put("adv", 5);
    freq.put("dqu", 6);
    freq.put("adu", 14);
    freq.put("ads", 10);
    freq.put("adf", 9);
    freq.put("add", 4);
    freq.put("ade", 24);
    freq.put("ada", 5);
    freq.put("adm", 11);
    freq.put("loq", 12);
    freq.put("adh", 5);
    freq.put("Fae", 3);
    freq.put("Hyl", 6);
    freq.put("Hyp", 3);
    freq.put("nve", 22);
    freq.put("T", 54);
    freq.put("nvo", 6);
    freq.put("nvi", 31);
    freq.put("ad ", 133);
    freq.put("oep", 7);
    freq.put("ui ", 204);
    freq.put("Sul", 9);
    freq.put("nfi", 23);
    freq.put("esu", 6);
    freq.put("est", 361);
    freq.put("ess", 254);
    freq.put("esq", 9);
    freq.put("esp", 22);
    freq.put("dia", 89);
    freq.put("ese", 35);
    freq.put("esc", 45);
    freq.put("esa", 10);
    freq.put("eso", 6);
    freq.put("esi", 50);
    freq.put("dui", 4);
    freq.put("Ut", 4);
    freq.put("lle", 96);
    freq.put("Un", 3);
    freq.put("dcu", 4);
    freq.put("ndi", 108);
    freq.put("Sci", 3);
    freq.put("dun", 9);
    freq.put("ndo", 44);
    freq.put("nda", 82);
    freq.put("duo", 5);
    freq.put("nde", 71);
    freq.put("es ", 451);
    freq.put("ndu", 56);
    freq.put("oet", 3);
    freq.put("C ", 27);
    freq.put("ea ", 77);
    freq.put("van", 10);
    freq.put("Amo", 17);
    freq.put("yra", 4);
    freq.put("xul", 3);
    freq.put("rci", 25);
    freq.put("var", 9);
    freq.put("rce", 16);
    freq.put("vav", 3);
    freq.put("rca", 3);
    freq.put("vat", 23);
    freq.put("hy", 5);
    freq.put("eam", 27);
    freq.put("ean", 21);
    freq.put("bus", 249);
    freq.put("eae", 15);
    freq.put("ead", 4);
    freq.put("but", 5);
    freq.put("hu", 75);
    freq.put("hi", 234);
    freq.put("bun", 14);
    freq.put("ho", 205);
    freq.put("bul", 5);
    freq.put("eas", 6);
    freq.put("ha", 162);
    freq.put("eat", 38);
    freq.put("he", 83);
    freq.put("dus", 19);
    freq.put("dmi", 8);
    freq.put("va ", 3);
    freq.put("lvi", 14);
    freq.put("ID ", 4);
    freq.put("pii", 6);
    freq.put("Ac ", 5);
    freq.put("pil", 6);
    freq.put("pin", 14);
    freq.put("pio", 12);
    freq.put("int", 122);
    freq.put("inu", 73);
    freq.put("inv", 35);
    freq.put("pic", 28);
    freq.put("inp", 28);
    freq.put("inq", 15);
    freq.put("ins", 36);
    freq.put("inl", 7);
    freq.put("inm", 26);
    freq.put("inn", 4);
    freq.put("ino", 14);
    freq.put("ub ", 8);
    freq.put("ini", 119);
    freq.put("ind", 39);
    freq.put("ine", 132);
    freq.put("pir", 8);
    freq.put("ing", 37);
    freq.put("pit", 32);
    freq.put("ina", 174);
    freq.put("inc", 88);
    freq.put("eo ", 69);
    freq.put(" Ut", 4);
    freq.put(" Un", 3);
    freq.put("or ", 124);
    freq.put("gau", 11);
    freq.put("rqu", 9);
    freq.put("ubr", 5);
    freq.put("ubs", 5);
    freq.put("gar", 8);
    freq.put("ubd", 3);
    freq.put("ube", 19);
    freq.put("U", 9);
    freq.put("uos", 59);
    freq.put("ubl", 118);
    freq.put("in ", 277);
    freq.put("ubi", 46);
    freq.put("eod", 4);
    freq.put("eos", 36);
    freq.put("eor", 40);
    freq.put("ltu", 25);
  }
  
}

