package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class IS extends CLangProfile {
  private static final String name = "is";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public IS() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2831948;
    n_words[1] = 3326341;
    n_words[2] = 2728347;

    freq.put("xtu", 66);
    freq.put("ti\u0301s", 148);
    freq.put("ti\u0301u", 187);
    freq.put("e\u0301rs", 261);
    freq.put("e\u0301ru", 58);
    freq.put("e\u0301rh", 132);
    freq.put("ti\u0301f", 31);
    freq.put("ti\u0301g", 107);
    freq.put("e\u0301ra", 473);
    freq.put("ti\u0301l", 107);
    freq.put("ti\u0301m", 1376);
    freq.put("ti\u0301n", 493);
    freq.put("mle", 912);
    freq.put("e\u0301r ", 713);
    freq.put("tja\u0301", 158);
    freq.put("ti\u0301ð", 431);
    freq.put("mlu", 66);
    freq.put("lmu", 132);
    freq.put("xa ", 51);
    freq.put(" yn", 69);
    freq.put("lmi", 211);
    freq.put("k", 84595);
    freq.put(" yf", 1550);
    freq.put("þu\u0301s", 303);
    freq.put(" yr", 29);
    freq.put(" ys", 51);
    freq.put(" yt", 52);
    freq.put("Læ", 49);
    freq.put("La\u0301", 110);
    freq.put("Li\u0301", 171);
    freq.put("Lo\u0308", 102);
    freq.put("Lo\u0301", 43);
    freq.put("Ly\u0301", 96);
    freq.put("Lu\u0301", 62);
    freq.put("dna", 116);
    freq.put("dni", 37);
    freq.put("dnu", 50);
    freq.put("xta", 178);
    freq.put("xti", 64);
    freq.put("Le", 589);
    freq.put("La", 1290);
    freq.put("Lo", 531);
    freq.put("Lj", 88);
    freq.put("Li", 540);
    freq.put("Lu", 200);
    freq.put("Ly", 57);
    freq.put("dna\u0301", 398);
    freq.put("hon", 246);
    freq.put("hol", 488);
    freq.put("hom", 68);
    freq.put("\u03b1\u0301", 44);
    freq.put("hou", 37);
    freq.put("hor", 323);
    freq.put("hop", 49);
    freq.put("A", 5835);
    freq.put("\u0645", 100);
    freq.put("L ", 154);
    freq.put("O\u0308", 390);
    freq.put("\u03bf\u03c2 ", 71);
    freq.put("ho ", 29);
    freq.put("u\u0304", 35);
    freq.put("mdæ", 65);
    freq.put("upa\u0301", 53);
    freq.put("i\u0301bu\u0301", 416);
    freq.put("Hip", 31);
    freq.put("æki", 736);
    freq.put("ro\u0308", 1573);
    freq.put("His", 29);
    freq.put("rð", 12661);
    freq.put("ækn", 356);
    freq.put("ro\u0301", 3050);
    freq.put("dso\u0308", 53);
    freq.put("ry\u0301", 331);
    freq.put("rþ", 186);
    freq.put("smo\u0301", 46);
    freq.put("ru\u0301", 1794);
    freq.put("pri\u0301", 173);
    freq.put("ræ", 6045);
    freq.put("ra\u0301", 5069);
    freq.put("ri\u0301", 6044);
    freq.put("Hil", 53);
    freq.put("re\u0301", 1220);
    freq.put("fil", 143);
    freq.put("fim", 307);
    freq.put(" Va", 709);
    freq.put(" Ve", 1143);
    freq.put("fhl", 44);
    freq.put(" Vi", 651);
    freq.put(" Vo", 162);
    freq.put("upm", 133);
    freq.put("atæ", 44);
    freq.put("ata\u0301", 67);
    freq.put("ati\u0301", 446);
    freq.put("ato\u0308", 90);
    freq.put("fi ", 1557);
    freq.put("ato\u0301", 78);
    freq.put("dro\u0301", 35);
    freq.put("mdi", 69);
    freq.put("lo\u0301ð", 350);
    freq.put("i\u0301be", 59);
    freq.put("mda", 120);
    freq.put("he\u0301r", 502);
    freq.put("mde", 37);
    freq.put("vo ", 541);
    freq.put("mdu", 54);
    freq.put("rt", 4340);
    freq.put("ru", 11212);
    freq.put("rv", 1275);
    freq.put("rw", 51);
    freq.put("rp", 1277);
    freq.put("rr", 3768);
    freq.put("rs", 10257);
    freq.put("dsv", 141);
    freq.put("dst", 207);
    freq.put("dsr", 47);
    freq.put("ry", 982);
    freq.put("rz", 66);
    freq.put("gu\u0301s", 189);
    freq.put("rd", 1531);
    freq.put("re", 10640);
    freq.put("rf", 4667);
    freq.put("rg", 5415);
    freq.put("dsj", 55);
    freq.put("ra", 19142);
    freq.put("rb", 1584);
    freq.put("rc", 245);
    freq.put("rl", 3496);
    freq.put("rm", 2415);
    freq.put("rn", 7451);
    freq.put("ro", 2458);
    freq.put("rh", 1825);
    freq.put("ri", 23025);
    freq.put("rj", 1626);
    freq.put("rk", 5904);
    freq.put("Egy", 100);
    freq.put(" Ve\u0301", 39);
    freq.put("md ", 63);
    freq.put(" Vi\u0301", 264);
    freq.put("syn", 591);
    freq.put("Egi", 67);
    freq.put(" Vo\u0308", 72);
    freq.put("syl", 37);
    freq.put("atf", 38);
    freq.put("ate", 387);
    freq.put("atb", 114);
    freq.put("ata", 1386);
    freq.put("atn", 1309);
    freq.put("ato", 180);
    freq.put("atl", 50);
    freq.put("Ny\u0301j", 100);
    freq.put("atk", 61);
    freq.put("ath", 330);
    freq.put("ati", 491);
    freq.put("atv", 191);
    freq.put("att", 952);
    freq.put("atu", 294);
    freq.put("r ", 98244);
    freq.put("ats", 86);
    freq.put("ds ", 1667);
    freq.put("sm ", 71);
    freq.put("kfr", 105);
    freq.put("kfa", 29);
    freq.put("Cen", 41);
    freq.put("xin", 82);
    freq.put("nz ", 37);
    freq.put("Asi\u0301", 208);
    freq.put("Sof", 40);
    freq.put("i\u0301", 48796);
    freq.put("nzk", 209);
    freq.put("smy", 129);
    freq.put("ma\u0301r", 47);
    freq.put("Son", 39);
    freq.put("ma\u0301t", 62);
    freq.put("Ass", 31);
    freq.put("\u30a2", 218);
    freq.put("Ast", 30);
    freq.put("xið", 31);
    freq.put("Sou", 36);
    freq.put("þjo\u0301", 1391);
    freq.put("\u0445", 30);
    freq.put("þja\u0301", 53);
    freq.put("knu", 434);
    freq.put("lpu", 35);
    freq.put("lph", 37);
    freq.put("lpe", 30);
    freq.put("lpa", 98);
    freq.put("yf ", 34);
    freq.put("ne\u0301 ", 49);
    freq.put("i\u0301sl", 2033);
    freq.put("irð", 784);
    freq.put("u\u0301ve", 99);
    freq.put("iri\u0301", 91);
    freq.put("iræ", 48);
    freq.put("yfa", 39);
    freq.put("Yo", 164);
    freq.put("yfl", 41);
    freq.put("yfi", 1843);
    freq.put("yfj", 42);
    freq.put("yft", 54);
    freq.put("ldm", 49);
    freq.put("X", 126);
    freq.put("O ", 134);
    freq.put("eðv", 33);
    freq.put("ner", 236);
    freq.put("Rit", 75);
    freq.put("eðu", 188);
    freq.put("eðr", 140);
    freq.put("eðs", 115);
    freq.put("eðn", 127);
    freq.put("eðl", 410);
    freq.put("eðj", 70);
    freq.put("eði", 184);
    freq.put("eðf", 92);
    freq.put("Ric", 60);
    freq.put("eða", 6425);
    freq.put("meg", 340);
    freq.put("irr", 770);
    freq.put("irs", 247);
    freq.put("irt", 855);
    freq.put("iru", 61);
    freq.put("irv", 49);
    freq.put("a\u0301ðg", 34);
    freq.put("irh", 41);
    freq.put("iri", 354);
    freq.put("irk", 1284);
    freq.put("irl", 451);
    freq.put("irm", 92);
    freq.put("irn", 320);
    freq.put("iro", 49);
    freq.put("ira", 203);
    freq.put("irb", 292);
    freq.put("smo", 37);
    freq.put("ire", 187);
    freq.put("irf", 191);
    freq.put("irg", 228);
    freq.put("dy\u0301p", 59);
    freq.put("dy\u0301r", 894);
    freq.put("rgt", 31);
    freq.put("Ljo\u0301", 82);
    freq.put("ir ", 13932);
    freq.put("pre", 517);
    freq.put("a\u0301ll", 88);
    freq.put("a\u0301lm", 334);
    freq.put("uef", 41);
    freq.put("ana", 1067);
    freq.put("fra", 2612);
    freq.put("a\u0301lh", 106);
    freq.put("fre", 467);
    freq.put("frj", 180);
    freq.put("fri", 247);
    freq.put("anc", 186);
    freq.put("fro", 66);
    freq.put("a\u0301lf", 1089);
    freq.put("fru", 674);
    freq.put("anm", 237);
    freq.put("a\u0301ld", 466);
    freq.put("a\u0301le", 131);
    freq.put("pri", 135);
    freq.put("lo\u0301k", 52);
    freq.put("a\u0301la", 688);
    freq.put("cum", 33);
    freq.put("pru", 359);
    freq.put("lo\u0301t", 52);
    freq.put("smi", 324);
    freq.put("sju", 30);
    freq.put("dri", 390);
    freq.put("fra\u0301", 3018);
    freq.put("fræ", 3955);
    freq.put("dhe", 43);
    freq.put("fri\u0301", 321);
    freq.put("fro\u0301", 162);
    freq.put("fro\u0308", 89);
    freq.put("bi\u0301", 505);
    freq.put("\u0441", 242);
    freq.put("ML ", 30);
    freq.put("tz ", 61);
    freq.put("o\u0301lg", 69);
    freq.put("sme", 283);
    freq.put(" a\u0301g", 152);
    freq.put("bo\u0301", 1425);
    freq.put("oli\u0301", 72);
    freq.put(" i\u0301þ", 190);
    freq.put("umo\u0308", 32);
    freq.put("hal", 899);
    freq.put("ham", 273);
    freq.put("han", 2326);
    freq.put("hae", 47);
    freq.put("haf", 2871);
    freq.put("hag", 381);
    freq.put("umæ", 45);
    freq.put("uma\u0301", 434);
    freq.put("\u0435", 181);
    freq.put("har", 340);
    freq.put("has", 39);
    freq.put("hat", 96);
    freq.put("hau", 175);
    freq.put("gko", 58);
    freq.put("ko\u0308n", 66);
    freq.put("ko\u0308l", 238);
    freq.put("ko\u0308m", 42);
    freq.put("ko\u0308k", 33);
    freq.put("ko\u0308t", 45);
    freq.put("ko\u0308r", 99);
    freq.put("ko\u0308p", 65);
    freq.put("so\u0308k", 67);
    freq.put("ha ", 73);
    freq.put("ola", 137);
    freq.put("olb", 58);
    freq.put("old", 173);
    freq.put("ole", 105);
    freq.put(" i\u0301b", 414);
    freq.put(" i\u0301l", 31);
    freq.put("oli", 166);
    freq.put(" X ", 47);
    freq.put("oll", 558);
    freq.put("olm", 30);
    freq.put("olo", 103);
    freq.put(" i\u0301t", 165);
    freq.put("ols", 62);
    freq.put("olt", 453);
    freq.put("olu", 106);
    freq.put(" i\u0301r", 55);
    freq.put(" i\u0301s", 1832);
    freq.put("oly", 34);
    freq.put("umu", 278);
    freq.put("umt", 34);
    freq.put("umv", 35);
    freq.put("lo\u0301 ", 63);
    freq.put("for", 2274);
    freq.put("fos", 163);
    freq.put("jo\u0308r", 1720);
    freq.put("umy", 38);
    freq.put("jo\u0308u", 59);
    freq.put("jo\u0308t", 144);
    freq.put("jo\u0308k", 280);
    freq.put("umd", 81);
    freq.put("umf", 103);
    freq.put("uma", 561);
    freq.put("jo\u0308l", 1329);
    freq.put("fol", 50);
    freq.put("uml", 76);
    freq.put("umn", 32);
    freq.put("æin", 69);
    freq.put("\u03bf\u03c2", 71);
    freq.put("umk", 61);
    freq.put("ol ", 139);
    freq.put(" i\u0301 ", 19047);
    freq.put("tek", 688);
    freq.put("ðlæ", 31);
    freq.put("o", 68668);
    freq.put("um ", 21458);
    freq.put("jo\u0308 ", 94);
    freq.put("mbl", 54);
    freq.put("khu\u0301", 66);
    freq.put("mbo", 170);
    freq.put("o\u0301an", 31);
    freq.put("sof", 60);
    freq.put("Fen", 29);
    freq.put("mbe", 570);
    freq.put("Fel", 69);
    freq.put("kho\u0301", 38);
    freq.put("sol", 30);
    freq.put("son", 2333);
    freq.put("sop", 47);
    freq.put("sor", 180);
    freq.put("Fer", 95);
    freq.put("o\u0308ð ", 459);
    freq.put("o\u0301as", 59);
    freq.put("o\u0301ar", 52);
    freq.put("mbr", 131);
    freq.put("o\u0301at", 33);
    freq.put("az ", 37);
    freq.put("o\u0308ðu", 713);
    freq.put("\u03c3", 73);
    freq.put("o\u0308ðv", 305);
    freq.put("o\u0308ðr", 512);
    freq.put("o\u0301a ", 210);
    freq.put("mb ", 57);
    freq.put("o\u0308ðl", 46);
    freq.put("o\u0308ði", 221);
    freq.put("mbi\u0301", 46);
    freq.put("up", 2929);
    freq.put("mbæ", 186);
    freq.put("Sig", 433);
    freq.put("kho", 40);
    freq.put("kha", 33);
    freq.put("mbo\u0308", 37);
    freq.put("o\u0301að", 58);
    freq.put("Sin", 41);
    freq.put("Sim", 64);
    freq.put("Sil", 74);
    freq.put("ðr", 2069);
    freq.put("E", 3951);
    freq.put("\u30a2\u30a2", 185);
    freq.put("U\u0301", 294);
    freq.put("rgo\u0308", 94);
    freq.put("oss", 397);
    freq.put("ost", 320);
    freq.put("osi", 138);
    freq.put("osh", 54);
    freq.put("osk", 246);
    freq.put("oso", 80);
    freq.put("osn", 180);
    freq.put("osa", 139);
    freq.put("Byg", 36);
    freq.put("ose", 94);
    freq.put("osf", 59);
    freq.put("u\u0301ti\u0301", 111);
    freq.put("o\u0308gm", 139);
    freq.put("o\u0308gn", 233);
    freq.put("ver", 6921);
    freq.put("o\u0308gi", 82);
    freq.put("vep", 209);
    freq.put("o\u0308gf", 50);
    freq.put("o\u0308gg", 153);
    freq.put("vex", 159);
    freq.put("vef", 239);
    freq.put("veg", 1474);
    freq.put("ven", 751);
    freq.put("o\u0308gu", 1452);
    freq.put("vel", 1100);
    freq.put("vem", 147);
    freq.put("vek", 61);
    freq.put("o\u0308gr", 85);
    freq.put("o\u0308gs", 34);
    freq.put("lra", 219);
    freq.put("Mæ", 40);
    freq.put("Ma\u0301", 196);
    freq.put("Mi\u0301", 43);
    freq.put("pek", 637);
    freq.put("ho\u0301l", 244);
    freq.put("ho\u0301p", 300);
    freq.put("Mo\u0308", 80);
    freq.put("Mo\u0301", 77);
    freq.put("My\u0301", 140);
    freq.put("Mu\u0308", 48);
    freq.put("Mu\u0301", 128);
    freq.put("tkv", 226);
    freq.put("peg", 29);
    freq.put("o\u0308g ", 817);
    freq.put("ðo", 29);
    freq.put("tku", 148);
    freq.put("ve ", 176);
    freq.put("Tal", 83);
    freq.put("Tan", 53);
    freq.put("M ", 133);
    freq.put("tey", 170);
    freq.put("ufl", 123);
    freq.put("u\u0301tl", 88);
    freq.put("u\u0301ti", 93);
    freq.put("u\u0301th", 65);
    freq.put("veð", 482);
    freq.put("u\u0301td", 41);
    freq.put("u\u0301tg", 318);
    freq.put("u\u0301tf", 37);
    freq.put("u\u0301ta", 123);
    freq.put("u\u0301tb", 80);
    freq.put("u\u0301tu", 109);
    freq.put("u\u0301tv", 167);
    freq.put("o\u0308gð", 187);
    freq.put("u\u0301ts", 144);
    freq.put("u\u0301tr", 45);
    freq.put("Me", 774);
    freq.put("Ma", 1619);
    freq.put("Mc", 44);
    freq.put("lræ", 29);
    freq.put("Mo", 567);
    freq.put("Mi", 929);
    freq.put("Mj", 65);
    freq.put("Mu", 181);
    freq.put("uff", 37);
    freq.put("My", 193);
    freq.put("u\u0301t ", 1602);
    freq.put("ipa", 275);
    freq.put("ipe", 46);
    freq.put("ipi", 107);
    freq.put("ipl", 30);
    freq.put("ips", 70);
    freq.put("ipp", 147);
    freq.put("ipt", 795);
    freq.put("ipu", 275);
    freq.put("a\u0301ks", 66);
    freq.put("te\u0301t", 65);
    freq.put("ærð", 475);
    freq.put("ip ", 220);
    freq.put("tep", 34);
    freq.put("su\u0301", 642);
    freq.put("sþ", 235);
    freq.put("sy\u0301", 1460);
    freq.put("so\u0301", 1189);
    freq.put("so\u0308", 1819);
    freq.put("se\u0301", 1567);
    freq.put("si\u0301", 2536);
    freq.put("sa\u0301", 1042);
    freq.put("sæ", 968);
    freq.put("æra", 217);
    freq.put("ære", 175);
    freq.put("æri", 815);
    freq.put("ærs", 892);
    freq.put("ærr", 162);
    freq.put("æru", 151);
    freq.put("ært", 38);
    freq.put("s ", 20225);
    freq.put("sy", 891);
    freq.put("ær ", 1321);
    freq.put("ss", 7478);
    freq.put("sr", 592);
    freq.put("sp", 2463);
    freq.put("sv", 4635);
    freq.put("su", 3147);
    freq.put("st", 37992);
    freq.put("sk", 20851);
    freq.put("sj", 2608);
    freq.put("si", 7701);
    freq.put("sh", 1736);
    freq.put("so", 2878);
    freq.put("sn", 2092);
    freq.put("sm", 2339);
    freq.put("sl", 8316);
    freq.put("sc", 305);
    freq.put("sb", 788);
    freq.put("sa", 9556);
    freq.put("sg", 382);
    freq.put("sf", 1106);
    freq.put("se", 20267);
    freq.put("sd", 792);
    freq.put("pi\u0301t", 55);
    freq.put("pi\u0301u", 114);
    freq.put("pi\u0301p", 39);
    freq.put("i\u0301ð ", 441);
    freq.put("tts", 368);
    freq.put("ttr", 107);
    freq.put("ttp", 29);
    freq.put("ttv", 68);
    freq.put("ttu", 1777);
    freq.put("\u044f ", 46);
    freq.put("ttk", 177);
    freq.put("tti", 1896);
    freq.put("tth", 142);
    freq.put("tto", 50);
    freq.put("pi\u0301a", 68);
    freq.put("ttm", 78);
    freq.put("ttl", 443);
    freq.put("ttb", 296);
    freq.put("tta", 1700);
    freq.put("ttf", 40);
    freq.put("tte", 221);
    freq.put("blo\u0308", 167);
    freq.put("blo\u0301", 334);
    freq.put("mo\u0301ð", 114);
    freq.put("bli\u0301", 66);
    freq.put("blæ", 36);
    freq.put("bla\u0301", 155);
    freq.put("i\u0301ða", 1262);
    freq.put("i\u0301ðn", 37);
    freq.put("uge", 80);
    freq.put("i\u0301ði", 373);
    freq.put("i\u0301ðu", 289);
    freq.put("i\u0301ðs", 99);
    freq.put("tt ", 3973);
    freq.put("ji ", 76);
    freq.put("utæ", 43);
    freq.put("ttu\u0301", 315);
    freq.put("tta\u0301", 38);
    freq.put("Jos", 55);
    freq.put("dju\u0301", 102);
    freq.put("mo\u0301n", 57);
    freq.put("bli", 128);
    freq.put("nsv", 84);
    freq.put("ble", 145);
    freq.put("bla", 414);
    freq.put("mo\u0301b", 30);
    freq.put("Jon", 44);
    freq.put(" go\u0308", 256);
    freq.put("oni", 201);
    freq.put("onn", 87);
    freq.put("ono", 62);
    freq.put("ove", 83);
    freq.put("saæ", 40);
    freq.put("ond", 305);
    freq.put("one", 201);
    freq.put("ony", 41);
    freq.put("ons", 298);
    freq.put("sað", 68);
    freq.put("ont", 181);
    freq.put("onu", 1209);
    freq.put("mkv", 450);
    freq.put("uku", 56);
    freq.put("ukt", 40);
    freq.put("ukn", 82);
    freq.put("ukk", 98);
    freq.put("uki", 102);
    freq.put("uke", 171);
    freq.put("uka", 181);
    freq.put("fma", 136);
    freq.put(" Ze", 49);
    freq.put("on ", 2981);
    freq.put(" Za", 29);
    freq.put("u ", 23701);
    freq.put("axa\u0301", 78);
    freq.put("uk ", 357);
    freq.put("sak", 243);
    freq.put("Ko\u0301p", 83);
    freq.put("sam", 4354);
    freq.put("Ko\u0301r", 59);
    freq.put("sac", 50);
    freq.put("sab", 56);
    freq.put("i\u0301ns", 125);
    freq.put("sag", 708);
    freq.put("saf", 750);
    freq.put("i\u0301nv", 127);
    freq.put("i\u0301ni", 88);
    freq.put("sas", 112);
    freq.put("Ko\u0301l", 42);
    freq.put("sav", 82);
    freq.put("sau", 114);
    freq.put("sat", 94);
    freq.put("A\u0301ra", 30);
    freq.put("lna", 176);
    freq.put("ax ", 56);
    freq.put("fmæ", 37);
    freq.put("uti\u0301", 62);
    freq.put("Flu", 50);
    freq.put("sa ", 884);
    freq.put("i\u0301n ", 498);
    freq.put("axt", 48);
    freq.put("o\u0301fo", 31);
    freq.put("axa", 101);
    freq.put("axi", 148);
    freq.put("axn", 54);
    freq.put("axl", 39);
    freq.put("Sku", 31);
    freq.put("kja\u0301", 188);
    freq.put("Skr", 62);
    freq.put("Sky", 37);
    freq.put("Ske", 116);
    freq.put("Ska", 549);
    freq.put("Sko", 140);
    freq.put("Ski", 81);
    freq.put("O\u0301ma", 39);
    freq.put("Skj", 90);
    freq.put("vid", 89);
    freq.put(" bæ", 1033);
    freq.put(" ba\u0301", 176);
    freq.put(" bi\u0301", 110);
    freq.put("kjo\u0301", 69);
    freq.put(" bo\u0308", 146);
    freq.put("kjo\u0308", 344);
    freq.put(" bo\u0301", 727);
    freq.put(" by\u0301", 113);
    freq.put(" bu\u0301", 500);
    freq.put("Sko\u0301", 140);
    freq.put("ai\u0301 ", 153);
    freq.put("Sku\u0301", 52);
    freq.put("Ska\u0301", 150);
    freq.put("Ski\u0301", 37);
    freq.put("ur", 34056);
    freq.put("um", 24785);
    freq.put(" b ", 35);
    freq.put("fir", 2556);
    freq.put("fis", 690);
    freq.put("ækj", 217);
    freq.put("ækk", 69);
    freq.put("ud", 463);
    freq.put("Hit", 42);
    freq.put(" be", 1105);
    freq.put("kja", 2742);
    freq.put(" ba", 1579);
    freq.put("fit", 83);
    freq.put("ua", 273);
    freq.put(" bo", 1713);
    freq.put(" bi", 592);
    freq.put(" bj", 275);
    freq.put(" bu", 123);
    freq.put("s", 170723);
    freq.put("kju", 1220);
    freq.put("ub", 622);
    freq.put(" by", 1013);
    freq.put("lyt", 300);
    freq.put("ni\u0301 ", 161);
    freq.put("u\u0301rv", 36);
    freq.put("u\u0301ru", 307);
    freq.put("u\u0301rt", 29);
    freq.put("u\u0301rs", 50);
    freq.put("smi\u0301", 94);
    freq.put("u\u0301rg", 32);
    freq.put("u\u0301rf", 29);
    freq.put("u\u0301re", 62);
    freq.put("u\u0301ra", 87);
    freq.put("Jo\u0308r", 55);
    freq.put("u\u0301rl", 34);
    freq.put("u\u0301rk", 41);
    freq.put("ni\u0301t", 33);
    freq.put("ni\u0301u", 415);
    freq.put("ni\u0301s", 81);
    freq.put("ni\u0301f", 29);
    freq.put("smæ", 45);
    freq.put("ni\u0301n", 81);
    freq.put("ækt", 237);
    freq.put("lyf", 122);
    freq.put("æku", 92);
    freq.put("Hin", 97);
    freq.put("u\u0301r ", 1479);
    freq.put("ive", 235);
    freq.put("iva", 54);
    freq.put("ivi", 61);
    freq.put("e\u0301tt", 1263);
    freq.put("e\u0301tu", 131);
    freq.put("e\u0301tr", 52);
    freq.put("nso\u0301", 384);
    freq.put("aðg", 231);
    freq.put("\u03b4", 52);
    freq.put("u\u0301ri\u0301", 36);
    freq.put("lyk", 142);
    freq.put("ugv", 167);
    freq.put("\u044c ", 33);
    freq.put("I", 1566);
    freq.put("e\u0301t ", 143);
    freq.put("Mar", 589);
    freq.put("Þ", 3879);
    freq.put("Max", 34);
    freq.put("gdr", 32);
    freq.put("gdu", 56);
    freq.put("tvo\u0308", 262);
    freq.put("tvi\u0301", 220);
    freq.put("gda", 103);
    freq.put("gdi", 40);
    freq.put("tvæ", 181);
    freq.put("fvi", 41);
    freq.put("æpl", 30);
    freq.put("fve", 203);
    freq.put("Sy\u0301r", 30);
    freq.put("La\u0301r", 54);
    freq.put("gd ", 235);
    freq.put("Mak", 33);
    freq.put("NA ", 58);
    freq.put("Myn", 130);
    freq.put("Man", 190);
    freq.put("gdy\u0301", 42);
    freq.put("tvo", 138);
    freq.put("tvi", 179);
    freq.put("tve", 811);
    freq.put("tva", 215);
    freq.put("ac ", 69);
    freq.put("a\u0301a ", 42);
    freq.put("dds", 49);
    freq.put("ddu", 785);
    freq.put("ddi", 256);
    freq.put("dda", 212);
    freq.put("i\u0301þj", 172);
    freq.put("i\u0301þr", 259);
    freq.put("ez ", 34);
    freq.put("rðs", 472);
    freq.put("ace", 117);
    freq.put("ack", 101);
    freq.put("aci", 77);
    freq.put("ach", 162);
    freq.put("aco", 29);
    freq.put("a\u0301ar", 36);
    freq.put("FL ", 35);
    freq.put("dd ", 334);
    freq.put("aa\u0301", 119);
    freq.put("Ni", 233);
    freq.put("Nj", 57);
    freq.put("bja", 121);
    freq.put("aæ", 251);
    freq.put("Na", 464);
    freq.put("usl", 30);
    freq.put("ai\u0301", 380);
    freq.put("Ne", 516);
    freq.put("að", 23009);
    freq.put("ao\u0301", 39);
    freq.put("ao\u0308", 53);
    freq.put("au\u0301", 77);
    freq.put("Nu", 48);
    freq.put("aþ", 342);
    freq.put("het", 78);
    freq.put("her", 942);
    freq.put("hes", 156);
    freq.put("hey", 346);
    freq.put("hef", 1628);
    freq.put("\u0432", 111);
    freq.put("heb", 56);
    freq.put("hel", 997);
    freq.put("hem", 44);
    freq.put("hen", 1048);
    freq.put("hei", 4035);
    freq.put("ku\u0301r", 39);
    freq.put("ku\u0301t", 86);
    freq.put("N ", 121);
    freq.put("i\u0301ba", 75);
    freq.put("agl", 139);
    freq.put("ku\u0301l", 122);
    freq.put("mpr", 35);
    freq.put("he ", 479);
    freq.put("aa", 265);
    freq.put("ac", 749);
    freq.put("ab", 2521);
    freq.put("ae", 748);
    freq.put("Ni\u0301", 89);
    freq.put("ag", 8003);
    freq.put("af", 17312);
    freq.put("ai", 546);
    freq.put("ah", 1785);
    freq.put("Hol", 265);
    freq.put("aj", 229);
    freq.put("am", 11839);
    freq.put("al", 17385);
    freq.put("ao", 105);
    freq.put("an", 36124);
    freq.put("aq", 51);
    freq.put("bjo\u0308", 156);
    freq.put("Nu\u0301", 101);
    freq.put("ar", 51349);
    freq.put("bjo\u0301", 189);
    freq.put("at", 7217);
    freq.put("aw", 133);
    freq.put("av", 2668);
    freq.put("ay", 341);
    freq.put("ax", 603);
    freq.put("az", 129);
    freq.put("uis", 52);
    freq.put("æmt", 313);
    freq.put("æmu", 71);
    freq.put("æmi", 690);
    freq.put("æmd", 120);
    freq.put("æma", 80);
    freq.put("a ", 54859);
    freq.put("fið", 525);
    freq.put("agt", 139);
    freq.put("at ", 305);
    freq.put("ua\u0301", 36);
    freq.put("uit", 37);
    freq.put("smu", 253);
    freq.put("o\u0301ni\u0301", 98);
    freq.put("Fir", 29);
    freq.put("o\u0301ev", 37);
    freq.put("sco", 77);
    freq.put("sch", 105);
    freq.put("sca", 45);
    freq.put("mnu", 39);
    freq.put("fæð", 108);
    freq.put("mni", 205);
    freq.put("dsp", 43);
    freq.put("mna", 60);
    freq.put("Fin", 139);
    freq.put("mne", 186);
    freq.put("Sma\u0301", 43);
    freq.put("Fim", 41);
    freq.put("dsn", 42);
    freq.put("tz", 87);
    freq.put("go\u0308l", 30);
    freq.put("ty", 774);
    freq.put("tv", 2024);
    freq.put("tw", 67);
    freq.put("tt", 12048);
    freq.put("tu", 13668);
    freq.put("tr", 5330);
    freq.put("dsl", 272);
    freq.put("tp", 67);
    freq.put("tn", 2675);
    freq.put("to", 3449);
    freq.put("tl", 2066);
    freq.put("tm", 438);
    freq.put("tj", 2442);
    freq.put("tk", 513);
    freq.put("th", 1669);
    freq.put("ti", 20846);
    freq.put("tf", 506);
    freq.put("tg", 495);
    freq.put("td", 76);
    freq.put("te", 7118);
    freq.put("tb", 686);
    freq.put("tc", 63);
    freq.put("go\u0308t", 244);
    freq.put("dsk", 119);
    freq.put("dsh", 112);
    freq.put("dsi", 362);
    freq.put("dsf", 53);
    freq.put("dsd", 51);
    freq.put("dse", 98);
    freq.put("dsb", 51);
    freq.put("\u30a2\u30a2 ", 30);
    freq.put("i\u0301lo\u0301", 181);
    freq.put("sma", 628);
    freq.put("dsa", 115);
    freq.put("t ", 24652);
    freq.put("Þær", 73);
    freq.put("fæt", 90);
    freq.put("fæs", 142);
    freq.put("fær", 603);
    freq.put("Smi", 30);
    freq.put("fæd", 750);
    freq.put("tþ", 77);
    freq.put("i\u0301l ", 215);
    freq.put("ty\u0301", 358);
    freq.put("tu\u0301", 766);
    freq.put("to\u0308", 3200);
    freq.put("to\u0301", 2681);
    freq.put("ti\u0301", 3010);
    freq.put("te\u0301", 125);
    freq.put("tæ", 3059);
    freq.put("ta\u0301", 725);
    freq.put("se\u0301r", 1103);
    freq.put("i\u0301la", 168);
    freq.put("se\u0301u", 75);
    freq.put("i\u0301ld", 62);
    freq.put("i\u0301le", 41);
    freq.put("i\u0301li", 51);
    freq.put("i\u0301ll", 70);
    freq.put("i\u0301ls", 42);
    freq.put("vic", 33);
    freq.put("vif", 41);
    freq.put("vig", 107);
    freq.put("Aug", 34);
    freq.put("vik", 659);
    freq.put("Auk", 30);
    freq.put("vin", 1308);
    freq.put("vil", 263);
    freq.put("vir", 486);
    freq.put("vis", 416);
    freq.put("Aus", 516);
    freq.put(" L", 4213);
    freq.put("vit", 214);
    freq.put("o\u0308ku", 681);
    freq.put("u\u0308nc", 35);
    freq.put(" d ", 204);
    freq.put("o\u0308ki", 70);
    freq.put("o\u0308kk", 171);
    freq.put("o\u0308kl", 108);
    freq.put("o\u0308kf", 51);
    freq.put("vi ", 117);
    freq.put(" do", 59);
    freq.put("kle", 411);
    freq.put("kla", 939);
    freq.put(" di", 134);
    freq.put(" de", 781);
    freq.put("klo", 62);
    freq.put("kli", 470);
    freq.put(" da", 1144);
    freq.put("klu", 225);
    freq.put(" dy", 47);
    freq.put("o\u0308k ", 413);
    freq.put(" dv", 45);
    freq.put(" du", 109);
    freq.put(" dr", 748);
    freq.put("Auð", 65);
    freq.put("við", 5233);
    freq.put("way", 31);
    freq.put("u\u0301ps", 35);
    freq.put("u\u0301pu", 52);
    freq.put("u\u0301pv", 33);
    freq.put("u\u0301pi", 33);
    freq.put("u\u0301pa", 59);
    freq.put("atr", 203);
    freq.put("hvo\u0308", 38);
    freq.put("klæ", 58);
    freq.put(" dæ", 326);
    freq.put("xi\u0301k", 59);
    freq.put(" da\u0301", 76);
    freq.put(" dy\u0301", 362);
    freq.put(" du\u0301", 43);
    freq.put("I\u0301bu\u0301", 146);
    freq.put("klo\u0301", 34);
    freq.put(" do\u0308", 163);
    freq.put(" do\u0301", 235);
    freq.put("klu\u0301", 36);
    freq.put("gfu\u0301", 42);
    freq.put("ito", 53);
    freq.put("itl", 270);
    freq.put("itm", 37);
    freq.put("ith", 325);
    freq.put("iti", 2561);
    freq.put("itg", 57);
    freq.put("ite", 114);
    freq.put("ita", 1646);
    freq.put("gfe\u0301", 47);
    freq.put("itz", 45);
    freq.put("ity", 146);
    freq.put("itv", 30);
    freq.put("itt", 1458);
    freq.put("itu", 683);
    freq.put("itr", 160);
    freq.put("its", 233);
    freq.put(" þe\u0301", 142);
    freq.put("fto\u0301", 31);
    freq.put("Yfi", 66);
    freq.put("ftæ", 51);
    freq.put("ka\u0301k", 62);
    freq.put("it ", 1254);
    freq.put("ka\u0301l", 657);
    freq.put(" Að", 243);
    freq.put(" Aþ", 47);
    freq.put("bu\u0301s", 74);
    freq.put("tro", 207);
    freq.put("O\u0301ði", 53);
    freq.put("bu\u0301d", 35);
    freq.put("bu\u0301a", 689);
    freq.put("bu\u0301n", 284);
    freq.put("bu\u0301i", 183);
    freq.put(" A ", 141);
    freq.put("iti\u0301", 89);
    freq.put("gfr", 149);
    freq.put("sþa\u0301", 113);
    freq.put("gfi", 32);
    freq.put("gfa", 30);
    freq.put("gfe", 34);
    freq.put("fts", 95);
    freq.put("ftu", 254);
    freq.put("ævi", 136);
    freq.put("æva", 29);
    freq.put("fta", 843);
    freq.put("fti", 2157);
    freq.put(" Aa", 38);
    freq.put(" Ab", 95);
    freq.put(" Ac", 57);
    freq.put(" Ad", 101);
    freq.put(" Af", 348);
    freq.put(" Ag", 60);
    freq.put(" Ai", 48);
    freq.put(" Ak", 256);
    freq.put(" Al", 992);
    freq.put(" Am", 374);
    freq.put(" An", 597);
    freq.put(" Ap", 140);
    freq.put(" Ar", 655);
    freq.put(" As", 369);
    freq.put(" At", 285);
    freq.put(" Au", 690);
    freq.put(" Av", 40);
    freq.put("bu\u0301ð", 112);
    freq.put("ft ", 1106);
    freq.put("w", 1317);
    freq.put("Fra", 556);
    freq.put("Fre", 118);
    freq.put("\u043e\u0431", 32);
    freq.put("\u043e\u0432", 39);
    freq.put("Fro", 37);
    freq.put("æ ", 266);
    freq.put("Fru", 56);
    freq.put("dfr", 39);
    freq.put("dfj", 56);
    freq.put("\u043a", 145);
    freq.put("jen", 38);
    freq.put("æp", 103);
    freq.put("ær", 4290);
    freq.put("æs", 710);
    freq.put("æt", 3260);
    freq.put("æv", 174);
    freq.put("æx", 41);
    freq.put("æd", 792);
    freq.put("æf", 427);
    freq.put("æg", 1139);
    freq.put("æi", 109);
    freq.put("æj", 307);
    freq.put("æk", 1777);
    freq.put("æl", 1029);
    freq.put("æm", 1338);
    freq.put("æn", 1633);
    freq.put("aaf", 34);
    freq.put("tsd", 95);
    freq.put("aal", 29);
    freq.put("exi\u0301", 65);
    freq.put("Ra\u0301ð", 30);
    freq.put("aar", 39);
    freq.put("\u043e\u0441", 32);
    freq.put("a\u0301gu", 57);
    freq.put("a\u0301gs", 40);
    freq.put("a\u0301gr", 106);
    freq.put("Fra\u0301", 36);
    freq.put("Fræ", 55);
    freq.put("Fri\u0301", 39);
    freq.put("ex ", 266);
    freq.put("odd", 103);
    freq.put("æð", 6732);
    freq.put("M", 5323);
    freq.put("Isl", 57);
    freq.put("lo\u0308k", 35);
    freq.put("exa", 95);
    freq.put("ext", 253);
    freq.put("a\u0301gu\u0301", 123);
    freq.put("ugi", 102);
    freq.put("ugh", 68);
    freq.put("Hal", 249);
    freq.put("Ham", 103);
    freq.put("Han", 1145);
    freq.put("ugl", 480);
    freq.put(" o\u0301r", 37);
    freq.put(" o\u0301s", 171);
    freq.put("uga", 631);
    freq.put(" o\u0301v", 94);
    freq.put("ugf", 52);
    freq.put(" o\u0301t", 48);
    freq.put("Hag", 49);
    freq.put(" o\u0301h", 75);
    freq.put(" o\u0301l", 197);
    freq.put(" o\u0301m", 33);
    freq.put(" o\u0301b", 82);
    freq.put("ugr", 64);
    freq.put("Har", 211);
    freq.put(" o\u0301f", 82);
    freq.put("Hau", 84);
    freq.put("ugu", 342);
    freq.put(" o\u0301e", 43);
    freq.put("rf ", 244);
    freq.put("am ", 1285);
    freq.put("ps ", 194);
    freq.put("ug ", 195);
    freq.put("rfs", 230);
    freq.put("rfr", 289);
    freq.put("rfu", 285);
    freq.put("rft", 34);
    freq.put("rfy", 82);
    freq.put("rfa", 643);
    freq.put("a\u0301s ", 143);
    freq.put("rfe", 164);
    freq.put("rfj", 246);
    freq.put("rfi", 1445);
    freq.put("cri", 30);
    freq.put("rfo", 103);
    freq.put("cro", 75);
    freq.put("rfl", 183);
    freq.put("set", 1580);
    freq.put(" o\u0301þ", 38);
    freq.put("ser", 203);
    freq.put("For", 261);
    freq.put("Fos", 51);
    freq.put("o\u0301gr", 30);
    freq.put("o\u0301gu", 78);
    freq.put("sey", 275);
    freq.put("sex", 134);
    freq.put("seg", 634);
    freq.put("sef", 91);
    freq.put("sea", 30);
    freq.put("o\u0301ga", 70);
    freq.put("sen", 611);
    freq.put("sem", 15452);
    freq.put("sel", 291);
    freq.put("o\u0301ge", 44);
    freq.put("sei", 316);
    freq.put("u\u0301mi", 46);
    freq.put("gði", 360);
    freq.put("u\u0301ml", 92);
    freq.put("u\u0301mm", 51);
    freq.put("gða", 277);
    freq.put("u\u0301me", 150);
    freq.put("u\u0301ms", 48);
    freq.put("ue ", 86);
    freq.put("Um ", 130);
    freq.put("se ", 199);
    freq.put("ðbu", 122);
    freq.put("rfð", 143);
    freq.put("ðbr", 88);
    freq.put("u\u0301m ", 49);
    freq.put("gð ", 585);
    freq.put("ðba", 46);
    freq.put("rfæ", 63);
    freq.put("rfe\u0301", 382);
    freq.put("lex", 80);
    freq.put("xar", 46);
    freq.put("xas", 32);
    freq.put("Vo\u0308l", 29);
    freq.put("xan", 81);
    freq.put("tre\u0301", 135);
    freq.put("nri", 142);
    freq.put("nra", 58);
    freq.put(" fo\u0301", 715);
    freq.put("mla", 218);
    freq.put(" fo\u0308", 181);
    freq.put("lo\u0308g", 1326);
    freq.put("mli", 71);
    freq.put(" fa\u0301", 200);
    freq.put("knu\u0301", 46);
    freq.put(" fæ", 1198);
    freq.put(" fe\u0301", 473);
    freq.put(" fi\u0301", 60);
    freq.put("ami", 326);
    freq.put("vog", 188);
    freq.put("amh", 353);
    freq.put("vol", 114);
    freq.put("von", 122);
    freq.put("vok", 77);
    freq.put("vot", 61);
    freq.put("vop", 132);
    freq.put("vor", 1409);
    freq.put("psn", 40);
    freq.put("pso", 41);
    freq.put("amn", 326);
    freq.put("kn ", 153);
    freq.put(" f ", 217);
    freq.put("tru\u0301", 459);
    freq.put("try\u0301", 35);
    freq.put("sþi", 29);
    freq.put("nre\u0301", 59);
    freq.put("psa", 36);
    freq.put("he\u0301t", 88);
    freq.put("nri\u0301", 48);
    freq.put("pse", 49);
    freq.put("he\u0301l", 52);
    freq.put("tro\u0301", 64);
    freq.put(" fr", 7589);
    freq.put(" fu", 598);
    freq.put("Sog", 33);
    freq.put("kni", 971);
    freq.put(" fy", 4531);
    freq.put("kne", 96);
    freq.put("Sol", 36);
    freq.put("kna", 1143);
    freq.put(" fa", 994);
    freq.put(" fe", 1285);
    freq.put("Sov", 61);
    freq.put(" fi", 969);
    freq.put(" fj", 2182);
    freq.put(" fl", 2079);
    freq.put(" fo", 1797);
    freq.put("tim", 103);
    freq.put("po\u0308r", 37);
    freq.put("a\u0301ðs", 118);
    freq.put("a\u0301ðu", 798);
    freq.put("a\u0301ðh", 171);
    freq.put("a\u0301ði", 225);
    freq.put("pss", 172);
    freq.put("a\u0301ða", 140);
    freq.put("a\u0301si", 75);
    freq.put("Ves", 624);
    freq.put("na\u0301g", 58);
    freq.put("na\u0301k", 43);
    freq.put("na\u0301n", 98);
    freq.put("na\u0301l", 173);
    freq.put("na\u0301m", 587);
    freq.put("na\u0301s", 32);
    freq.put("na\u0301t", 321);
    freq.put("On", 43);
    freq.put("bæ", 1840);
    freq.put("Ol", 56);
    freq.put("Ok", 35);
    freq.put("ba\u0301", 511);
    freq.put("Oh", 30);
    freq.put("Of", 128);
    freq.put("Od", 80);
    freq.put("ðis", 677);
    freq.put("bo\u0308", 256);
    freq.put("Ox", 46);
    freq.put("by\u0301", 357);
    freq.put("a\u0301ð ", 233);
    freq.put("Ot", 31);
    freq.put("Os", 65);
    freq.put("Or", 413);
    freq.put("bu\u0301", 1553);
    freq.put("Op", 55);
    freq.put("so\u0308n", 374);
    freq.put("na\u0301 ", 105);
    freq.put("so\u0308m", 115);
    freq.put("d", 53734);
    freq.put("so\u0308f", 68);
    freq.put("so\u0308g", 1012);
    freq.put("b ", 287);
    freq.put("na\u0301ð", 134);
    freq.put("be", 3254);
    freq.put("ba", 3436);
    freq.put("bb", 255);
    freq.put("afi\u0301", 36);
    freq.put("bl", 1526);
    freq.put("bn", 48);
    freq.put("bo", 3424);
    freq.put("bi", 1485);
    freq.put("bj", 538);
    freq.put("bu", 941);
    freq.put("br", 3631);
    freq.put("bs", 81);
    freq.put("by", 1518);
    freq.put("afe\u0301", 292);
    freq.put("i\u0301kj", 759);
    freq.put("Fy", 316);
    freq.put("i\u0301ki", 1509);
    freq.put(" C ", 121);
    freq.put("ci ", 39);
    freq.put("ætu", 294);
    freq.put("ætt", 2050);
    freq.put("æta", 147);
    freq.put("æti", 456);
    freq.put("ætl", 282);
    freq.put("Li\u0301f", 63);
    freq.put("Fe", 260);
    freq.put(" Ch", 431);
    freq.put(" Ci", 85);
    freq.put(" Co", 494);
    freq.put(" Cl", 177);
    freq.put(" Ca", 484);
    freq.put(" Ce", 87);
    freq.put(" Cr", 127);
    freq.put(" Cu", 55);
    freq.put("cia", 66);
    freq.put("uy", 35);
    freq.put("ux", 78);
    freq.put("cie", 48);
    freq.put("uz", 51);
    freq.put("uu", 36);
    freq.put("ut", 4027);
    freq.put("uv", 609);
    freq.put("cin", 65);
    freq.put("us", 5972);
    freq.put("cil", 37);
    freq.put("cis", 51);
    freq.put("ul", 3466);
    freq.put("uo", 98);
    freq.put("un", 17263);
    freq.put("ui", 242);
    freq.put("uh", 528);
    freq.put("uk", 1254);
    freq.put("uj", 51);
    freq.put("ue", 357);
    freq.put("ago\u0308", 58);
    freq.put("ug", 3646);
    freq.put("uf", 941);
    freq.put("ago\u0301", 47);
    freq.put("uc", 259);
    freq.put("agð", 277);
    freq.put("ag ", 1083);
    freq.put("ago", 116);
    freq.put("agn", 1177);
    freq.put("uþ", 108);
    freq.put("agk", 31);
    freq.put("agj", 32);
    freq.put("agi", 919);
    freq.put("agg", 36);
    freq.put("agf", 101);
    freq.put("age", 255);
    freq.put("uð", 6077);
    freq.put("aga", 1887);
    freq.put("agv", 46);
    freq.put("agu", 274);
    freq.put("uæ", 73);
    freq.put("ags", 903);
    freq.put("agr", 297);
    freq.put("Blo\u0308", 85);
    freq.put("Blo\u0301", 44);
    freq.put("o ", 2043);
    freq.put("Bla\u0301", 56);
    freq.put("my\u0301r", 102);
    freq.put("wa ", 41);
    freq.put("leð", 89);
    freq.put("tri", 1095);
    freq.put("evi", 74);
    freq.put("trj", 59);
    freq.put("rdo\u0301", 74);
    freq.put("evo", 39);
    freq.put("rdy\u0301", 141);
    freq.put("eva", 56);
    freq.put("tre", 326);
    freq.put("eve", 76);
    freq.put("try", 105);
    freq.put("rdæ", 68);
    freq.put("rdi\u0301", 30);
    freq.put("evr", 168);
    freq.put("tru", 188);
    freq.put("le ", 477);
    freq.put("uel", 43);
    freq.put("Dju\u0301", 38);
    freq.put("odu", 43);
    freq.put("odi", 36);
    freq.put("odo", 53);
    freq.put("oda", 50);
    freq.put("Bla", 79);
    freq.put("ode", 87);
    freq.put("ues", 38);
    freq.put("uer", 36);
    freq.put("ct ", 31);
    freq.put("rd ", 235);
    freq.put("lea", 40);
    freq.put("lef", 174);
    freq.put("leg", 4445);
    freq.put("lei", 4428);
    freq.put("lek", 97);
    freq.put("lem", 83);
    freq.put("len", 3455);
    freq.put("lep", 51);
    freq.put("ler", 229);
    freq.put("les", 811);
    freq.put("let", 264);
    freq.put("leu", 35);
    freq.put("lev", 29);
    freq.put("od ", 57);
    freq.put("ley", 649);
    freq.put("nmy", 38);
    freq.put("rdu", 33);
    freq.put("ctu", 33);
    freq.put("tri\u0301", 436);
    freq.put("rds", 39);
    freq.put("tra\u0301", 56);
    freq.put("træ", 183);
    freq.put("rde", 130);
    freq.put("nme", 186);
    freq.put("rda", 542);
    freq.put("rdo", 29);
    freq.put("cto", 64);
    freq.put("rdi", 87);
    freq.put("cti", 110);
    freq.put("rdj", 41);
    freq.put("sgr", 89);
    freq.put("sga", 69);
    freq.put("sge", 55);
    freq.put("u\u0301kl", 39);
    freq.put("u\u0301kd", 157);
    freq.put("u\u0301ka", 42);
    freq.put("u\u0301ku", 33);
    freq.put("u\u0301kr", 68);
    freq.put("\u043e", 257);
    freq.put("o\u0308t ", 64);
    freq.put("ro\u0301ð", 187);
    freq.put("o\u0301tl", 55);
    freq.put("mjo\u0308", 303);
    freq.put("eð ", 3577);
    freq.put("mjo\u0301", 184);
    freq.put("mju\u0301", 31);
    freq.put("ro\u0301 ", 38);
    freq.put("sgo\u0308", 54);
    freq.put("\u03bc", 51);
    freq.put("ro\u0301l", 88);
    freq.put("ro\u0301m", 241);
    freq.put("ro\u0301n", 128);
    freq.put("ro\u0301i", 38);
    freq.put("ro\u0301j", 32);
    freq.put("ro\u0301k", 92);
    freq.put("ro\u0301f", 441);
    freq.put("ro\u0301a", 188);
    freq.put("Q", 137);
    freq.put("Fo\u0301", 50);
    freq.put("ro\u0301t", 502);
    freq.put("ro\u0301u", 170);
    freq.put("ro\u0301p", 739);
    freq.put("ro\u0301s", 105);
    freq.put("ðdy\u0301", 38);
    freq.put("Fo\u0308", 37);
    freq.put("æ", 24190);
    freq.put("aþi", 69);
    freq.put("i\u0301hy", 55);
    freq.put("u\u0301l", 849);
    freq.put("u\u0301m", 548);
    freq.put("u\u0301n", 2987);
    freq.put("u\u0301i", 308);
    freq.put("u\u0301k", 435);
    freq.put("u\u0301d", 160);
    freq.put("u\u0301e", 84);
    freq.put("u\u0301f", 229);
    freq.put("u\u0301g", 271);
    freq.put("u\u0301a", 1374);
    freq.put("u\u0301b", 118);
    freq.put("u\u0301t", 3137);
    freq.put("u\u0301u", 46);
    freq.put("u\u0301v", 113);
    freq.put("u\u0301p", 309);
    freq.put("u\u0301r", 2334);
    freq.put("u\u0301s", 2168);
    freq.put("Fa\u0301", 50);
    freq.put("u\u0301 ", 1027);
    freq.put("mo\u0308r", 555);
    freq.put("Kjo\u0308", 29);
    freq.put("Fe\u0301", 158);
    freq.put(" hy", 49);
    freq.put("San", 244);
    freq.put("Sam", 545);
    freq.put("Sal", 86);
    freq.put(" hr", 1011);
    freq.put("Sag", 99);
    freq.put("Saf", 35);
    freq.put(" hu", 968);
    freq.put("Ho\u0308f", 247);
    freq.put(" hj", 450);
    freq.put(" hi", 1085);
    freq.put("Sax", 56);
    freq.put(" ho", 514);
    freq.put(" hn", 173);
    freq.put(" hl", 3298);
    freq.put("Sar", 46);
    freq.put(" ha", 4851);
    freq.put("Ho\u0308r", 55);
    freq.put("Sav", 41);
    freq.put(" he", 6396);
    freq.put("u\u0301ð", 432);
    freq.put("Po\u0301l", 106);
    freq.put("Kja", 80);
    freq.put("tok", 74);
    freq.put(" hu\u0301", 877);
    freq.put(" hy\u0301", 48);
    freq.put(" ho\u0301", 647);
    freq.put(" ho\u0308", 1280);
    freq.put(" he\u0301", 535);
    freq.put("mo\u0308n", 242);
    freq.put(" ha\u0301", 1191);
    freq.put(" hæ", 774);
    freq.put("ta\u0301r", 67);
    freq.put("ihl", 41);
    freq.put("ta\u0301l", 58);
    freq.put("ta\u0301n", 117);
    freq.put("iha", 82);
    freq.put("ihe", 1081);
    freq.put("ta\u0301 ", 55);
    freq.put("e\u0301n ", 35);
    freq.put("Þin", 237);
    freq.put("y\u0301", 7865);
    freq.put(" E ", 35);
    freq.put("ck ", 218);
    freq.put("So\u0301l", 71);
    freq.put("So\u0301k", 35);
    freq.put(" El", 310);
    freq.put(" Em", 78);
    freq.put(" En", 509);
    freq.put(" Ei", 508);
    freq.put(" Ek", 54);
    freq.put(" Ed", 147);
    freq.put(" Ef", 192);
    freq.put(" Eg", 213);
    freq.put(" Ea", 43);
    freq.put("jo\u0308g", 408);
    freq.put(" Ex", 43);
    freq.put(" Ey", 536);
    freq.put(" Et", 30);
    freq.put(" Eu", 55);
    freq.put(" Ev", 632);
    freq.put(" Er", 231);
    freq.put(" Es", 91);
    freq.put("cke", 55);
    freq.put("ckl", 29);
    freq.put("cks", 45);
    freq.put("Po\u0301", 142);
    freq.put("dbo", 31);
    freq.put("dba", 39);
    freq.put("Pa\u0301", 120);
    freq.put("dbr", 34);
    freq.put("Pi\u0301", 33);
    freq.put("jav", 807);
    freq.put("jat", 92);
    freq.put("jar", 3369);
    freq.put("jas", 441);
    freq.put("jap", 160);
    freq.put("jan", 1062);
    freq.put("ae ", 196);
    freq.put("jal", 1563);
    freq.put("jam", 60);
    freq.put("jak", 139);
    freq.put("jah", 111);
    freq.put("jaf", 886);
    freq.put("jad", 61);
    freq.put("jab", 64);
    freq.put("mtu", 58);
    freq.put("O\u0301", 667);
    freq.put("aey", 189);
    freq.put("h", 42906);
    freq.put("gbl", 50);
    freq.put("a\u0301kv", 456);
    freq.put("a\u0301ku", 34);
    freq.put("gbr", 62);
    freq.put("a\u0301kn", 429);
    freq.put("aef", 43);
    freq.put("aei", 56);
    freq.put("a\u0301ka", 90);
    freq.put("ael", 113);
    freq.put("ja ", 3453);
    freq.put("Pr", 335);
    freq.put("Pu", 82);
    freq.put("oma", 392);
    freq.put("dbu\u0301", 64);
    freq.put("Pe", 379);
    freq.put("Ph", 126);
    freq.put("Pi", 180);
    freq.put("Po", 355);
    freq.put("Pl", 227);
    freq.put("\u0627", 239);
    freq.put("jað", 148);
    freq.put("et ", 347);
    freq.put("lf", 2514);
    freq.put("tsl", 69);
    freq.put("P ", 275);
    freq.put("tsm", 42);
    freq.put("tsj", 49);
    freq.put("tsk", 176);
    freq.put("etr", 663);
    freq.put("ets", 81);
    freq.put("ett", 1496);
    freq.put("etu", 910);
    freq.put("tsi", 93);
    freq.put("etb", 29);
    freq.put("tla", 1003);
    freq.put("eta", 600);
    freq.put("tle", 549);
    freq.put("ete", 97);
    freq.put("etj", 138);
    freq.put("Ri\u0301k", 122);
    freq.put("eth", 57);
    freq.put("eti", 412);
    freq.put("etn", 430);
    freq.put("reð", 86);
    freq.put("etl", 247);
    freq.put("ck", 446);
    freq.put("ci", 425);
    freq.put("ch", 1138);
    freq.put("co", 503);
    freq.put("væ", 2362);
    freq.put("Hes", 54);
    freq.put("cc", 89);
    freq.put("ve\u0301", 379);
    freq.put("ca", 618);
    freq.put("vi\u0301", 5140);
    freq.put("ce", 634);
    freq.put("cy", 44);
    freq.put("Hea", 36);
    freq.put("vo\u0308", 1344);
    freq.put("cs", 53);
    freq.put("cr", 172);
    freq.put("Hen", 69);
    freq.put("tsa", 40);
    freq.put("uck", 49);
    freq.put("Hei", 302);
    freq.put("cu", 238);
    freq.put("ct", 305);
    freq.put("Ges", 41);
    freq.put("Ger", 69);
    freq.put("u\u0301ið", 119);
    freq.put("Gei", 146);
    freq.put("Geo", 100);
    freq.put("Gen", 80);
    freq.put("lgj", 181);
    freq.put("lgi", 219);
    freq.put("ðfæ", 123);
    freq.put("ðfe\u0301", 50);
    freq.put("c ", 322);
    freq.put("lge", 419);
    freq.put("uns", 75);
    freq.put("lgr", 315);
    freq.put("unt", 112);
    freq.put("lgu", 75);
    freq.put("unv", 62);
    freq.put("rby", 65);
    freq.put("rbu", 32);
    freq.put("rbr", 230);
    freq.put("rbo", 361);
    freq.put("Bjo\u0308", 145);
    freq.put("rbl", 48);
    freq.put("rbj", 47);
    freq.put("rbi", 30);
    freq.put("rbe", 117);
    freq.put("LP ", 162);
    freq.put("rba", 200);
    freq.put("va", 13225);
    freq.put("ve", 15820);
    freq.put("vi", 9174);
    freq.put("vn", 41);
    freq.put("vo", 2712);
    freq.put("vr", 778);
    freq.put("vu", 610);
    freq.put("of ", 366);
    freq.put("una", 2110);
    freq.put("unb", 61);
    freq.put("unc", 32);
    freq.put("u\u0301in", 138);
    freq.put("und", 5296);
    freq.put("v ", 113);
    freq.put("phi", 81);
    freq.put("ðfe", 384);
    freq.put("lgi\u0301", 110);
    freq.put("pha", 447);
    freq.put("ðfj", 46);
    freq.put("ðfl", 57);
    freq.put("phe", 36);
    freq.put("phy", 56);
    freq.put("guh", 41);
    freq.put("rby\u0301", 31);
    freq.put("ofa", 240);
    freq.put("off", 70);
    freq.put("rbu\u0301", 62);
    freq.put("Bja", 184);
    freq.put("ofi", 70);
    freq.put("rbo\u0301", 57);
    freq.put("Tvi\u0301", 41);
    freq.put("ofs", 67);
    freq.put("unn", 2545);
    freq.put("u\u0301i ", 32);
    freq.put("ofu", 107);
    freq.put("rbæ", 241);
    freq.put("gun", 1431);
    freq.put("\u0631", 96);
    freq.put("gum", 2005);
    freq.put("wer", 56);
    freq.put("umi", 189);
    freq.put("gul", 515);
    freq.put("nve", 746);
    freq.put("nva", 467);
    freq.put("iðv", 49);
    freq.put("nvi", 93);
    freq.put("kru\u0301", 51);
    freq.put("umh", 215);
    freq.put("mhl", 52);
    freq.put(" ju\u0301", 303);
    freq.put("gus", 223);
    freq.put(" jo\u0308", 359);
    freq.put("kro\u0308", 33);
    freq.put(" jo\u0301", 154);
    freq.put("mha", 163);
    freq.put("i\u0301va", 36);
    freq.put("kri\u0301", 69);
    freq.put("mhv", 209);
    freq.put("kra\u0301", 299);
    freq.put(" ja\u0301", 131);
    freq.put("o\u0308ml", 44);
    freq.put("o\u0308mm", 54);
    freq.put("gur", 4137);
    freq.put("llg", 128);
    freq.put(" hv", 1445);
    freq.put("o\u0308mu", 145);
    freq.put("nvo\u0308", 31);
    freq.put("\u043b\u0430", 36);
    freq.put("\u4e4b", 47);
    freq.put("nvæ", 34);
    freq.put("bæn", 134);
    freq.put("Sco", 36);
    freq.put("kry", 53);
    freq.put("Sch", 99);
    freq.put(" ju", 184);
    freq.put("kru", 154);
    freq.put("kri", 1166);
    freq.put("kro", 107);
    freq.put("kra", 945);
    freq.put(" ja", 1316);
    freq.put("i\u0301vi\u0301", 47);
    freq.put("kre", 121);
    freq.put("ini\u0301", 40);
    freq.put("yri", 3304);
    freq.put("yrj", 263);
    freq.put("yrk", 276);
    freq.put("yrn", 424);
    freq.put("yra", 258);
    freq.put("yrg", 59);
    freq.put("yrp", 48);
    freq.put("yrr", 562);
    freq.put("yrs", 1207);
    freq.put("yrt", 41);
    freq.put("yru", 38);
    freq.put("Kle", 57);
    freq.put("Kla", 45);
    freq.put("au", 7198);
    freq.put("yr ", 47);
    freq.put("iny", 29);
    freq.put("int", 511);
    freq.put("inu", 3925);
    freq.put("inv", 49);
    freq.put("mæl", 428);
    freq.put("i\u0301as", 50);
    freq.put("inr", 53);
    freq.put("ins", 4795);
    freq.put("inl", 365);
    freq.put("inm", 78);
    freq.put("inn", 11792);
    freq.put("Svi\u0301", 230);
    freq.put("inh", 343);
    freq.put("ini", 973);
    freq.put("inj", 88);
    freq.put("ink", 753);
    freq.put("ind", 1888);
    freq.put("ine", 220);
    freq.put("inf", 252);
    freq.put("ing", 10532);
    freq.put("ina", 1616);
    freq.put("inb", 291);
    freq.put("inc", 97);
    freq.put("eo ", 32);
    freq.put("o\u0301nn", 30);
    freq.put("yrð", 218);
    freq.put("tma", 134);
    freq.put("U", 1075);
    freq.put("in ", 6373);
    freq.put("eon", 46);
    freq.put("Þor", 406);
    freq.put("eor", 111);
    freq.put("uor", 53);
    freq.put("sst", 880);
    freq.put("Tur", 46);
    freq.put("a\u0301rr", 36);
    freq.put("a\u0301rs", 356);
    freq.put(" G ", 36);
    freq.put("le\u0301", 431);
    freq.put("a\u0301ru", 387);
    freq.put("alh", 154);
    freq.put("e\u0301l ", 93);
    freq.put("cm ", 36);
    freq.put("æxl", 41);
    freq.put("pte", 249);
    freq.put(" Gv", 43);
    freq.put(" Gu", 613);
    freq.put(" Gr", 964);
    freq.put("Tun", 86);
    freq.put("ðri", 810);
    freq.put("ska", 5867);
    freq.put(" Gy", 51);
    freq.put(" Ge", 549);
    freq.put(" Ga", 560);
    freq.put(" Gn", 42);
    freq.put(" Go", 223);
    freq.put(" Gl", 210);
    freq.put(" Gj", 38);
    freq.put(" Gi", 180);
    freq.put("væn", 135);
    freq.put("væm", 521);
    freq.put("ly\u0301", 968);
    freq.put("gli\u0301", 50);
    freq.put("e\u0301la", 1571);
    freq.put("ako\u0301", 58);
    freq.put("lu\u0301", 270);
    freq.put("glæ", 66);
    freq.put("e\u0301li", 43);
    freq.put("e\u0301lt", 37);
    freq.put("gly\u0301", 46);
    freq.put("aki\u0301", 50);
    freq.put("Ve\u0301", 39);
    freq.put("væt", 40);
    freq.put("vær", 197);
    freq.put("glo\u0308", 41);
    freq.put("a\u0304", 102);
    freq.put("Ævi", 29);
    freq.put("a\u0301rg", 32);
    freq.put("alv", 169);
    freq.put("alt", 530);
    freq.put("a\u0301rk", 58);
    freq.put("gl ", 222);
    freq.put("alr", 40);
    freq.put("\u062f", 85);
    freq.put("a\u0301rm", 104);
    freq.put("alp", 48);
    freq.put("ak ", 482);
    freq.put(" Go\u0308", 52);
    freq.put("Cr", 129);
    freq.put(" Gi\u0301", 124);
    freq.put("gli", 346);
    freq.put("glj", 57);
    freq.put("aks", 182);
    freq.put("akr", 86);
    freq.put("\u30a2\u30a2\u30a2", 152);
    freq.put("aku", 48);
    freq.put("a\u0301ir", 32);
    freq.put("e\u0301lo\u0308", 131);
    freq.put("akj", 37);
    freq.put("aki", 430);
    freq.put("a\u0301in", 106);
    freq.put("ako", 186);
    freq.put("akm", 75);
    freq.put("akl", 519);
    freq.put("que", 67);
    freq.put("aka", 724);
    freq.put("gls", 98);
    freq.put("glu", 412);
    freq.put("ake", 553);
    freq.put("væð", 1152);
    freq.put("Jer", 68);
    freq.put("Jes", 43);
    freq.put("Þy\u0301s", 303);
    freq.put("bry", 35);
    freq.put("bru", 150);
    freq.put("bro", 253);
    freq.put("lby", 30);
    freq.put("brj", 92);
    freq.put("bri", 289);
    freq.put("bre", 1260);
    freq.put("Jen", 40);
    freq.put("bra", 622);
    freq.put("Fu", 127);
    freq.put("er ", 26993);
    freq.put("tn ", 382);
    freq.put("nka", 436);
    freq.put("nke", 308);
    freq.put("nki", 143);
    freq.put("laæ", 29);
    freq.put("la ", 3270);
    freq.put("nko", 60);
    freq.put("nkt", 196);
    freq.put("nku", 284);
    freq.put("nky", 63);
    freq.put("lað", 1400);
    freq.put("ert", 870);
    freq.put("ii", 120);
    freq.put("erv", 161);
    freq.put("erp", 109);
    freq.put("err", 409);
    freq.put("ers", 1962);
    freq.put("ery", 35);
    freq.put("erd", 76);
    freq.put("ere", 120);
    freq.put("erf", 1459);
    freq.put("erg", 583);
    freq.put("tna", 432);
    freq.put("era", 1234);
    freq.put("erb", 160);
    freq.put("erc", 66);
    freq.put("erl", 415);
    freq.put("erm", 315);
    freq.put("ern", 801);
    freq.put("ero", 113);
    freq.put("erh", 55);
    freq.put("eri", 1572);
    freq.put("erj", 619);
    freq.put("erk", 1822);
    freq.put("io", 856);
    freq.put("bro\u0308", 90);
    freq.put("in", 45324);
    freq.put("bro\u0301", 94);
    freq.put("mpe", 55);
    freq.put("ual", 30);
    freq.put("bre\u0301", 110);
    freq.put("uan", 43);
    freq.put("bræ", 116);
    freq.put("bra\u0301", 62);
    freq.put("ib", 562);
    freq.put("i\u0304", 50);
    freq.put("lal", 147);
    freq.put("lam", 321);
    freq.put("lan", 8388);
    freq.put("lah", 156);
    freq.put("lai", 54);
    freq.put("lak", 210);
    freq.put("lad", 110);
    freq.put("lae", 76);
    freq.put("laf", 643);
    freq.put("lag", 2929);
    freq.put("lab", 255);
    freq.put("lac", 81);
    freq.put("lax", 34);
    freq.put("fat", 65);
    freq.put("lat", 1416);
    freq.put("lau", 1468);
    freq.put("lav", 277);
    freq.put("mpi", 49);
    freq.put("lap", 48);
    freq.put("lar", 1445);
    freq.put("las", 1408);
    freq.put("erð", 2864);
    freq.put("ero\u0301", 30);
    freq.put("eru\u0301", 35);
    freq.put("mpu", 43);
    freq.put("era\u0301", 64);
    freq.put("eri\u0301", 413);
    freq.put("fre\u0301", 80);
    freq.put("Eyj", 294);
    freq.put("Eys", 84);
    freq.put("Eyr", 71);
    freq.put("Eyv", 33);
    freq.put("u\u0301gu", 29);
    freq.put("u\u0301ga", 156);
    freq.put("ltr", 104);
    freq.put("ðho", 42);
    freq.put("ðha", 43);
    freq.put("pja", 37);
    freq.put("ðhe", 185);
    freq.put("nto\u0308", 45);
    freq.put("nti\u0301", 118);
    freq.put("ðhv", 60);
    freq.put("ba\u0301ð", 53);
    freq.put("i\u0301to\u0308", 52);
    freq.put("l", 133209);
    freq.put("i\u0301ta\u0301", 50);
    freq.put("\u0301", 73);
    freq.put("nt ", 1180);
    freq.put("i\u0301t ", 92);
    freq.put("ta\u0301k", 413);
    freq.put("Sve", 238);
    freq.put("nts", 226);
    freq.put("ntr", 104);
    freq.put("ntu", 324);
    freq.put("nti", 309);
    freq.put("nth", 63);
    freq.put("nto", 119);
    freq.put("nta", 596);
    freq.put("kit", 45);
    freq.put("nte", 421);
    freq.put("ðho\u0308", 65);
    freq.put("ba\u0301t", 196);
    freq.put("i\u0301tr", 55);
    freq.put("i\u0301tt", 43);
    freq.put("i\u0301tu", 112);
    freq.put("mva", 32);
    freq.put("i\u0301ti", 396);
    freq.put("mve", 268);
    freq.put("i\u0301tl", 29);
    freq.put("mvi", 66);
    freq.put("ba\u0301l", 229);
    freq.put("i\u0301ta", 480);
    freq.put("o\u0308st", 120);
    freq.put("o\u0308su", 31);
    freq.put("ðræ", 84);
    freq.put("o\u0308sk", 74);
    freq.put("Jo\u0301l", 33);
    freq.put("Jo\u0301n", 432);
    freq.put("Jo\u0301h", 104);
    freq.put("Jo\u0301t", 38);
    freq.put("Jo\u0301r", 29);
    freq.put("kt ", 1361);
    freq.put(" le", 2444);
    freq.put("B", 5986);
    freq.put(" la", 3474);
    freq.put(" lo", 635);
    freq.put("ted", 71);
    freq.put(" lj", 434);
    freq.put(" li", 1725);
    freq.put("to\u0308ð", 1090);
    freq.put(" lu", 44);
    freq.put("Jul", 35);
    freq.put("tef", 480);
    freq.put(" ly", 173);
    freq.put("tex", 159);
    freq.put("Set", 31);
    freq.put("Ser", 78);
    freq.put("nbj", 30);
    freq.put("ktu", 499);
    freq.put("Sey", 30);
    freq.put("kts", 31);
    freq.put("Seg", 32);
    freq.put("kto", 78);
    freq.put("kti", 182);
    freq.put("Sen", 51);
    freq.put("Sem", 35);
    freq.put("Sel", 128);
    freq.put("kta", 448);
    freq.put("Sei", 38);
    freq.put("Bæj", 56);
    freq.put("Bær", 105);
    freq.put("slo\u0301", 155);
    freq.put("yps", 42);
    freq.put("ypt", 168);
    freq.put("ypi", 37);
    freq.put("\u03c0", 60);
    freq.put("U\u0301lf", 48);
    freq.put("Qu", 74);
    freq.put(" la\u0301", 392);
    freq.put(" li\u0301", 1770);
    freq.put(" O\u0308l", 87);
    freq.put(" le\u0301", 191);
    freq.put("Kna", 56);
    freq.put(" lo\u0308", 1089);
    freq.put(" O\u0308s", 31);
    freq.put(" O\u0308r", 95);
    freq.put(" lo\u0301", 69);
    freq.put(" O\u0308x", 50);
    freq.put(" ly\u0301", 420);
    freq.put(" lu\u0301", 49);
    freq.put("tse", 120);
    freq.put("kto\u0301", 189);
    freq.put("uda", 130);
    freq.put("tsb", 48);
    freq.put("ude", 123);
    freq.put("d ", 7343);
    freq.put("mær", 230);
    freq.put("hry", 131);
    freq.put("em ", 15176);
    freq.put("hru", 56);
    freq.put("do\u0301t", 514);
    freq.put("do\u0301r", 123);
    freq.put("do\u0301n", 58);
    freq.put("Fo", 403);
    freq.put("hro", 60);
    freq.put("do\u0301m", 399);
    freq.put("hri", 511);
    freq.put("hre", 864);
    freq.put("do\u0301e", 37);
    freq.put("hra", 356);
    freq.put("dn", 635);
    freq.put("do", 802);
    freq.put("dl", 570);
    freq.put("dm", 128);
    freq.put("dj", 161);
    freq.put("dk", 373);
    freq.put("dh", 181);
    freq.put("di", 10756);
    freq.put("df", 200);
    freq.put("dg", 199);
    freq.put("dd", 1771);
    freq.put("de", 2371);
    freq.put("db", 244);
    freq.put("da", 11080);
    freq.put("dy", 153);
    freq.put("dv", 327);
    freq.put("dw", 47);
    freq.put("dt", 82);
    freq.put("du", 6343);
    freq.put("dr", 2023);
    freq.put("ds", 4031);
    freq.put("eme", 166);
    freq.put("emd", 57);
    freq.put("ema", 216);
    freq.put("emb", 731);
    freq.put("emm", 172);
    freq.put("emo", 53);
    freq.put("ili\u0301", 122);
    freq.put("emi", 212);
    freq.put("emu", 458);
    freq.put("emp", 64);
    freq.put("ems", 115);
    freq.put("do\u0301 ", 54);
    freq.put("w ", 311);
    freq.put("oð ", 82);
    freq.put(" I ", 60);
    freq.put("il ", 5889);
    freq.put("hri\u0301", 33);
    freq.put("co ", 104);
    freq.put("iða", 1209);
    freq.put("hræ", 36);
    freq.put("hra\u0301", 47);
    freq.put("oðu", 86);
    freq.put("we", 162);
    freq.put("di\u0301", 356);
    freq.put("wa", 277);
    freq.put("oðs", 85);
    freq.put("wo", 89);
    freq.put("wn", 54);
    freq.put(" Is", 113);
    freq.put("wi", 159);
    freq.put("da\u0301", 141);
    freq.put("ww", 36);
    freq.put("dy\u0301", 970);
    freq.put(" Il", 85);
    freq.put(" Im", 35);
    freq.put(" In", 759);
    freq.put("do\u0308", 206);
    freq.put("oðn", 31);
    freq.put(" Ic", 56);
    freq.put("do\u0301", 1251);
    freq.put("ilf", 193);
    freq.put("ilg", 369);
    freq.put("ild", 1200);
    freq.put("ile", 949);
    freq.put("ilb", 133);
    freq.put("cot", 33);
    freq.put("ila", 590);
    freq.put("iln", 105);
    freq.put("ilo", 79);
    freq.put("ill", 2619);
    freq.put("ilm", 73);
    freq.put("ilj", 142);
    freq.put("ilk", 107);
    freq.put("ilh", 348);
    freq.put("ili", 745);
    freq.put("ilv", 300);
    freq.put("ilt", 422);
    freq.put("ilu", 204);
    freq.put("ilr", 73);
    freq.put("ils", 420);
    freq.put("com", 44);
    freq.put("col", 55);
    freq.put("ily", 95);
    freq.put("Ætt", 33);
    freq.put("o\u0301ps", 195);
    freq.put("o\u0301pu", 659);
    freq.put("o\u0301pi", 56);
    freq.put("dsm", 154);
    freq.put("o\u0301pa", 167);
    freq.put("o\u0301pe", 33);
    freq.put("mbu", 134);
    freq.put("gn ", 453);
    freq.put("ai ", 55);
    freq.put("o\u0301p ", 40);
    freq.put("nið", 1052);
    freq.put("gns", 98);
    freq.put("gnv", 46);
    freq.put("gnu", 408);
    freq.put("tho\u0308", 259);
    freq.put("ais", 50);
    freq.put("air", 55);
    freq.put("ail", 51);
    freq.put("gna", 1067);
    freq.put("gnf", 78);
    freq.put("gne", 63);
    freq.put("gnh", 31);
    freq.put("gni", 304);
    freq.put("tha\u0301", 36);
    freq.put("Þo\u0301r", 281);
    freq.put("o\u0301pi\u0301", 47);
    freq.put("rðh", 35);
    freq.put("þyk", 156);
    freq.put("tra", 1427);
    freq.put("rðm", 67);
    freq.put("þyr", 48);
    freq.put("Mu\u0308n", 41);
    freq.put("th ", 216);
    freq.put("nik", 72);
    freq.put("nih", 310);
    freq.put("nin", 4763);
    freq.put("\u03c4", 83);
    freq.put("nil", 175);
    freq.put("nim", 227);
    freq.put("nic", 97);
    freq.put("nia", 97);
    freq.put("nif", 72);
    freq.put("nig", 1566);
    freq.put("nid", 40);
    freq.put("nie", 59);
    freq.put("Y", 369);
    freq.put("nis", 1128);
    freq.put("nip", 29);
    freq.put("niv", 147);
    freq.put("nit", 151);
    freq.put("niu", 46);
    freq.put("thy", 59);
    freq.put("gnu\u0301", 139);
    freq.put("thv", 123);
    freq.put("ept", 231);
    freq.put("thr", 34);
    freq.put("epp", 1389);
    freq.put("tho", 74);
    freq.put("epl", 35);
    freq.put("thl", 29);
    freq.put("eph", 64);
    freq.put("epi", 31);
    freq.put("the", 336);
    freq.put("tha", 162);
    freq.put("epa", 67);
    freq.put("du\u0301", 164);
    freq.put("rn ", 955);
    freq.put("tsp", 261);
    freq.put("Gau", 70);
    freq.put("Gat", 36);
    freq.put("Gar", 113);
    freq.put("Gam", 94);
    freq.put("Gal", 86);
    freq.put("Gag", 40);
    freq.put("Tri", 44);
    freq.put("plo\u0308", 432);
    freq.put("rni", 1126);
    freq.put("rno", 60);
    freq.put("rnm", 279);
    freq.put("rnl", 105);
    freq.put("Tra", 74);
    freq.put("rnb", 71);
    freq.put("rna", 2301);
    freq.put("rng", 308);
    freq.put("rnf", 82);
    freq.put("rne", 499);
    freq.put("rnd", 175);
    freq.put("Try", 40);
    freq.put("rns", 265);
    freq.put("rnr", 31);
    freq.put("rnv", 34);
    freq.put("rnu", 692);
    freq.put("rnt", 68);
    freq.put("fo\u0301l", 411);
    freq.put("fo\u0301n", 31);
    freq.put("fo\u0301r", 224);
    freq.put("fo\u0301s", 48);
    freq.put("fo\u0301t", 90);
    freq.put("u\u0301el", 31);
    freq.put("ykk", 283);
    freq.put("Lei", 237);
    freq.put("yki", 114);
    freq.put("ykh", 37);
    freq.put("Len", 37);
    freq.put("yks", 31);
    freq.put("ykr", 37);
    freq.put("Les", 33);
    freq.put("Let", 29);
    freq.put("yku", 91);
    freq.put("ykt", 79);
    freq.put("ðji", 36);
    freq.put("rni\u0301", 108);
    freq.put("rna\u0301", 49);
    freq.put("ðja", 484);
    freq.put("ple", 140);
    freq.put("pla", 766);
    freq.put("rno\u0301", 42);
    freq.put("Tro\u0301", 34);
    freq.put("rno\u0308", 83);
    freq.put("pli", 59);
    freq.put("Tro\u0308", 38);
    freq.put("Le ", 30);
    freq.put("obi", 55);
    freq.put("obe", 61);
    freq.put("oba", 45);
    freq.put("fo\u0301ð", 29);
    freq.put("þo\u0308r", 71);
    freq.put("tu\u0301r", 354);
    freq.put("I\u0301 ", 655);
    freq.put("tu\u0301d", 45);
    freq.put("tu\u0301g", 124);
    freq.put("tu\u0301l", 110);
    freq.put("tu\u0301n", 89);
    freq.put("olf", 120);
    freq.put("wai", 35);
    freq.put("ry\u0301n", 71);
    freq.put("ry\u0301m", 56);
    freq.put("ry\u0301s", 98);
    freq.put("ry\u0301t", 47);
    freq.put("ha\u0301ð", 110);
    freq.put("mt ", 874);
    freq.put("i\u0301r ", 94);
    freq.put("war", 95);
    freq.put(" ne\u0301", 32);
    freq.put("\u0442", 158);
    freq.put(" ni\u0301", 127);
    freq.put("I\u0301b", 166);
    freq.put(" na\u0301", 971);
    freq.put("kvi\u0301", 214);
    freq.put(" næ", 757);
    freq.put("kvo\u0308", 70);
    freq.put("I\u0301t", 191);
    freq.put(" nu\u0301", 672);
    freq.put(" ny\u0301", 430);
    freq.put("I\u0301s", 2281);
    freq.put("I\u0301r", 171);
    freq.put(" no\u0301", 204);
    freq.put(" no\u0308", 39);
    freq.put("i\u0301ru", 32);
    freq.put("O\u0308l", 88);
    freq.put("O\u0308n", 69);
    freq.put("i\u0301rs", 66);
    freq.put("O\u0308r", 97);
    freq.put("O\u0308s", 31);
    freq.put("O\u0308x", 50);
    freq.put("mta", 215);
    freq.put("Odd", 60);
    freq.put("i\u0301ra", 38);
    freq.put("mte", 29);
    freq.put("u\u0308r", 71);
    freq.put("olv", 29);
    freq.put(" n ", 78);
    freq.put("u\u0308n", 52);
    freq.put("Sau", 95);
    freq.put("ha\u0301l", 239);
    freq.put("fo\u0308", 400);
    freq.put("ha\u0301r", 141);
    freq.put("ha\u0301s", 508);
    freq.put("ha\u0301t", 389);
    freq.put(" ni", 345);
    freq.put("kve", 660);
    freq.put(" no", 3458);
    freq.put("kva", 323);
    freq.put(" na", 898);
    freq.put(" ne", 1620);
    freq.put("kvi", 617);
    freq.put(" ny", 134);
    freq.put("itn", 80);
    freq.put("Su", 942);
    freq.put("I\u0301þ", 49);
    freq.put(" nu", 54);
    freq.put("Sk", 1512);
    freq.put("ums", 276);
    freq.put("Sj", 305);
    freq.put("ha\u0301 ", 44);
    freq.put("umr", 110);
    freq.put("mto\u0308", 286);
    freq.put("mti\u0301", 120);
    freq.put("fæ", 1715);
    freq.put("ume", 325);
    freq.put("gu ", 2071);
    freq.put("o\u0301 ", 1141);
    freq.put("yvi", 33);
    freq.put("umb", 222);
    freq.put("umm", 97);
    freq.put("gua", 30);
    freq.put("guf", 112);
    freq.put("gue", 40);
    freq.put("o\u0301s", 1395);
    freq.put("o\u0301r", 3904);
    freq.put("o\u0301p", 1247);
    freq.put("o\u0301v", 375);
    freq.put("o\u0301u", 215);
    freq.put("o\u0301t", 2821);
    freq.put("o\u0301k", 2164);
    freq.put("p", 24810);
    freq.put("o\u0301i", 177);
    freq.put("o\u0301h", 245);
    freq.put("o\u0301n", 3499);
    freq.put("o\u0301m", 3062);
    freq.put("o\u0301l", 4371);
    freq.put("o\u0301b", 406);
    freq.put("o\u0301a", 487);
    freq.put("o\u0301g", 351);
    freq.put("o\u0301f", 1069);
    freq.put("o\u0301e", 87);
    freq.put("o\u0301d", 134);
    freq.put("Pe\u0301", 116);
    freq.put("þri", 320);
    freq.put("ek ", 94);
    freq.put("\u0433", 31);
    freq.put("ht ", 90);
    freq.put("gle", 410);
    freq.put("ekn", 178);
    freq.put("ekk", 2070);
    freq.put("o\u0301þ", 62);
    freq.put("eki", 1159);
    freq.put("kyn", 662);
    freq.put("o\u0301ð", 3019);
    freq.put("eka", 127);
    freq.put("guð", 201);
    freq.put("eku", 210);
    freq.put("ekt", 94);
    freq.put("eks", 107);
    freq.put("fbr", 125);
    freq.put("spi\u0301", 66);
    freq.put("fbe", 30);
    freq.put("spa\u0301", 57);
    freq.put("spæ", 137);
    freq.put(" Ka", 1198);
    freq.put("kyl", 290);
    freq.put(" Ke", 368);
    freq.put(" Kj", 147);
    freq.put("O\u0308nn", 32);
    freq.put(" Ki", 275);
    freq.put(" Kn", 101);
    freq.put(" Ko", 532);
    freq.put(" Kl", 180);
    freq.put(" Kr", 556);
    freq.put(" Kv", 148);
    freq.put(" Ku", 90);
    freq.put("Að ", 48);
    freq.put("ca ", 193);
    freq.put("F", 4399);
    freq.put("\u064a", 130);
    freq.put("ibi", 39);
    freq.put(" K ", 33);
    freq.put("ibl", 77);
    freq.put("cas", 39);
    freq.put("car", 60);
    freq.put("ibe", 53);
    freq.put("cat", 48);
    freq.put("iby", 31);
    freq.put("can", 86);
    freq.put("cal", 71);
    freq.put("ibr", 56);
    freq.put("Aða", 120);
    freq.put("cag", 30);
    freq.put("ibu", 44);
    freq.put("spy", 259);
    freq.put("a\u0301m ", 162);
    freq.put("spr", 262);
    freq.put("spu", 111);
    freq.put("spi", 313);
    freq.put("spj", 61);
    freq.put("spo", 83);
    freq.put("spa", 131);
    freq.put("spe", 881);
    freq.put(" Ka\u0301", 86);
    freq.put(" Ki\u0301", 164);
    freq.put(" Ko\u0301", 213);
    freq.put(" Ko\u0308", 70);
    freq.put(" Ku\u0301", 67);
    freq.put("a\u0301mi", 57);
    freq.put("a\u0301ma", 116);
    freq.put("aos", 34);
    freq.put("a\u0301ms", 328);
    freq.put("a\u0301mu", 55);
    freq.put("ght", 99);
    freq.put("ghe", 48);
    freq.put("gha", 53);
    freq.put("gho", 33);
    freq.put("Ru", 106);
    freq.put("Che", 50);
    freq.put("Chi", 122);
    freq.put("Jar", 64);
    freq.put("soc", 29);
    freq.put("Jap", 87);
    freq.put("Jan", 110);
    freq.put("Re", 1401);
    freq.put("Chr", 82);
    freq.put("Jam", 61);
    freq.put("Ra", 615);
    freq.put("Jaf", 30);
    freq.put("Ro", 345);
    freq.put("Rh", 36);
    freq.put("Ri", 256);
    freq.put("eo\u0301", 56);
    freq.put("mbi", 46);
    freq.put("o\u0301r ", 572);
    freq.put("Mu\u0301s", 34);
    freq.put("\u03b1", 162);
    freq.put("Mu\u0301l", 61);
    freq.put("rli\u0301", 129);
    freq.put("nom", 35);
    freq.put("non", 64);
    freq.put("noi", 41);
    freq.put("nok", 465);
    freq.put("rlæ", 104);
    freq.put("rla\u0301", 68);
    freq.put("lmo\u0308", 34);
    freq.put("mba", 627);
    freq.put("rly\u0301", 62);
    freq.put("R ", 119);
    freq.put("not", 1703);
    freq.put("rlo\u0308", 185);
    freq.put("nor", 1577);
    freq.put("nos", 55);
    freq.put("o\u0301rb", 108);
    freq.put("o\u0301ra", 323);
    freq.put("o\u0301rf", 38);
    freq.put("o\u0301re", 82);
    freq.put("o\u0301rh", 40);
    freq.put("o\u0301ri", 369);
    freq.put("o\u0301rn", 1251);
    freq.put("o\u0301rr", 30);
    freq.put("o\u0301rs", 264);
    freq.put("o\u0301rv", 45);
    freq.put("o\u0301rt", 130);
    freq.put("o\u0301ru", 242);
    freq.put("sou", 29);
    freq.put("mby", 39);
    freq.put("em", 17579);
    freq.put("el", 7041);
    freq.put("eo", 285);
    freq.put("en", 19500);
    freq.put("ei", 27077);
    freq.put("eh", 101);
    freq.put("ek", 4309);
    freq.put("ej", 35);
    freq.put("ee", 293);
    freq.put("ed", 647);
    freq.put("eg", 10758);
    freq.put("Afg", 30);
    freq.put("ea", 698);
    freq.put("rl ", 136);
    freq.put("ec", 343);
    freq.put("eb", 435);
    freq.put("ey", 6435);
    freq.put("Ra\u0301", 45);
    freq.put("ez", 75);
    freq.put("eu", 292);
    freq.put("et", 5721);
    freq.put("ew", 295);
    freq.put("ev", 474);
    freq.put("eq", 33);
    freq.put("Re\u0301", 30);
    freq.put("es", 9022);
    freq.put("er", 48228);
    freq.put("Sy\u0301", 65);
    freq.put("\u0633", 65);
    freq.put("Gla", 37);
    freq.put("a\u0301ko", 53);
    freq.put("tlæ", 32);
    freq.put("rlm", 64);
    freq.put("rlo", 52);
    freq.put("rli", 393);
    freq.put("rlj", 29);
    freq.put("rle", 987);
    freq.put("rld", 50);
    freq.put("lms", 88);
    freq.put("rla", 936);
    freq.put("e ", 4753);
    freq.put("So\u0308", 178);
    freq.put(" \u041a", 36);
    freq.put("tjo\u0301", 1537);
    freq.put("rly", 31);
    freq.put("tjo\u0308", 220);
    freq.put("rlu", 136);
    freq.put("lma", 336);
    freq.put("lme", 420);
    freq.put("rls", 75);
    freq.put("Se\u0301", 40);
    freq.put("o\u0301ri\u0301", 40);
    freq.put("o\u0301ro\u0301", 29);
    freq.put("o\u0301rð", 209);
    freq.put("lla", 2838);
    freq.put("psk", 239);
    freq.put("xi", 212);
    freq.put("xn", 82);
    freq.put("Si\u0301", 179);
    freq.put("xl", 137);
    freq.put("xa", 252);
    freq.put("xf", 48);
    freq.put("xe", 64);
    freq.put("pn ", 39);
    freq.put("xp", 31);
    freq.put("Sa\u0301", 78);
    freq.put("xt", 373);
    freq.put("xu", 39);
    freq.put("yin", 76);
    freq.put("Sæ", 90);
    freq.put("ðlu", 118);
    freq.put("x ", 601);
    freq.put("pnu", 104);
    freq.put("pni", 409);
    freq.put("ush", 40);
    freq.put("ðle", 272);
    freq.put("ðla", 663);
    freq.put("pna", 137);
    freq.put("ðli", 420);
    freq.put("þry\u0301", 79);
    freq.put("þro\u0301", 578);
    freq.put("Pa", 545);
    freq.put(" y\u0301m", 413);
    freq.put("mræ", 144);
    freq.put("xi\u0301", 115);
    freq.put("xa\u0301", 78);
    freq.put("y\u0301ni", 230);
    freq.put("Phi", 60);
    freq.put("Pho", 31);
    freq.put("y\u0301na", 59);
    freq.put("y\u0301nd", 168);
    freq.put("y\u0301nt", 39);
    freq.put("egl", 570);
    freq.put("bi\u0301l", 118);
    freq.put("bi\u0301s", 172);
    freq.put("i\u0301pu", 47);
    freq.put("Oft", 93);
    freq.put("bi\u0301u", 86);
    freq.put("mru", 37);
    freq.put("\u062f ", 39);
    freq.put("mri", 72);
    freq.put("mra", 69);
    freq.put("\u1100\u1161", 30);
    freq.put("Wei", 29);
    freq.put("Wes", 69);
    freq.put("\u03b5", 87);
    freq.put(" pr", 628);
    freq.put("\u043d\u0430", 33);
    freq.put(" pu", 136);
    freq.put("Kro\u0301", 49);
    freq.put(" pa", 204);
    freq.put(" pe", 303);
    freq.put(" pi", 60);
    freq.put(" po", 204);
    freq.put(" pl", 325);
    freq.put("Kr ", 66);
    freq.put("vu ", 91);
    freq.put("ytt", 292);
    freq.put("ytu", 186);
    freq.put("ytr", 53);
    freq.put("ytj", 179);
    freq.put("yti", 525);
    freq.put("yta", 127);
    freq.put(" po\u0301", 129);
    freq.put(" U\u0301l", 56);
    freq.put(" po\u0308", 85);
    freq.put(" U\u0301k", 30);
    freq.put(" pa\u0301", 51);
    freq.put("Kri", 234);
    freq.put("Kro", 41);
    freq.put(" U\u0301t", 101);
    freq.put("Kra", 61);
    freq.put(" pi\u0301", 89);
    freq.put(" U\u0301r", 58);
    freq.put("vun", 101);
    freq.put("vuo", 30);
    freq.put("vul", 145);
    freq.put("vum", 75);
    freq.put("\u03b1 ", 38);
    freq.put("vur", 48);
    freq.put("vus", 33);
    freq.put("hvo", 342);
    freq.put("hva", 437);
    freq.put("hve", 1438);
    freq.put("ki\u0301f", 146);
    freq.put(" Mæ", 40);
    freq.put("ho\u0301f", 338);
    freq.put(" Ma\u0301", 195);
    freq.put(" Mi\u0301", 43);
    freq.put("ki\u0301l", 193);
    freq.put("ih", 1334);
    freq.put("ei ", 96);
    freq.put(" Mo\u0308", 79);
    freq.put("ki\u0301s", 41);
    freq.put("ki\u0301r", 55);
    freq.put(" Mo\u0301", 77);
    freq.put(" Mu\u0308", 48);
    freq.put(" My\u0301", 140);
    freq.put("xi\u0301ð", 39);
    freq.put(" Mu\u0301", 128);
    freq.put("Þar", 262);
    freq.put("Þau", 111);
    freq.put("lle", 713);
    freq.put("eip", 47);
    freq.put("eis", 901);
    freq.put("eir", 2011);
    freq.put("eit", 4783);
    freq.put("CO ", 32);
    freq.put("eid", 336);
    freq.put("eig", 1161);
    freq.put("eif", 473);
    freq.put("khl", 111);
    freq.put("eik", 3123);
    freq.put("eim", 2679);
    freq.put("eil", 1098);
    freq.put("ein", 8206);
    freq.put("yi", 92);
    freq.put("hvi\u0301", 219);
    freq.put("yl", 1475);
    freq.put(" Me", 769);
    freq.put("syð", 69);
    freq.put(" Ma", 1610);
    freq.put(" Mc", 44);
    freq.put(" Mo", 559);
    freq.put(" Mi", 927);
    freq.put(" Mj", 65);
    freq.put("O\u0308lf", 40);
    freq.put(" Mu", 180);
    freq.put("e\u0301f ", 34);
    freq.put("ki\u0301ð", 62);
    freq.put(" My", 192);
    freq.put("Það", 730);
    freq.put("yb", 37);
    freq.put("yg", 1822);
    freq.put("ux ", 46);
    freq.put("tli", 156);
    freq.put("eið", 2061);
    freq.put(" M ", 34);
    freq.put("gbu\u0301", 105);
    freq.put("eto", 75);
    freq.put("e\u0301fa", 46);
    freq.put("a\u0301a", 140);
    freq.put("a\u0301b", 249);
    freq.put("a\u0301e", 70);
    freq.put("a\u0301d", 63);
    freq.put("a\u0301g", 530);
    freq.put("a\u0301f", 560);
    freq.put("a\u0301i", 182);
    freq.put("a\u0301h", 466);
    freq.put("a\u0301k", 1231);
    freq.put("a\u0301m", 763);
    freq.put("a\u0301l", 5705);
    freq.put("a\u0301n", 1343);
    freq.put("a\u0301p", 70);
    freq.put("a\u0301s", 1809);
    freq.put("a\u0301r", 6093);
    freq.put("a\u0301u", 67);
    freq.put("a\u0301t", 2849);
    freq.put("a\u0301v", 511);
    freq.put("\u041c", 32);
    freq.put("cm", 37);
    freq.put("ðso\u0308", 131);
    freq.put("cl", 64);
    freq.put("yv", 43);
    freq.put("a\u0301ss", 31);
    freq.put("a\u0301 ", 17048);
    freq.put("amk", 501);
    freq.put("psi", 86);
    freq.put("amm", 631);
    freq.put("aml", 867);
    freq.put("amo", 77);
    freq.put("a\u0301st", 312);
    freq.put("ama", 1875);
    freq.put("amb", 945);
    freq.put("ame", 964);
    freq.put("amd", 67);
    freq.put("amg", 65);
    freq.put("amf", 296);
    freq.put("amy", 55);
    freq.put("a\u0301sa", 364);
    freq.put("a\u0301se", 31);
    freq.put("nma\u0301", 266);
    freq.put("a\u0301sk", 711);
    freq.put("amp", 188);
    freq.put("ams", 715);
    freq.put("amr", 194);
    freq.put("amu", 36);
    freq.put("amt", 977);
    freq.put("pst", 155);
    freq.put("amv", 106);
    freq.put("sra\u0301", 129);
    freq.put("o\u0301ti\u0301", 55);
    freq.put("gju", 374);
    freq.put("sri\u0301", 153);
    freq.put("ynd", 2435);
    freq.put("t", 142015);
    freq.put("gja", 1901);
    freq.put("uca", 53);
    freq.put("a\u0301æ", 82);
    freq.put("a\u0301ð", 1784);
    freq.put("o\u0301t ", 306);
    freq.put("uch", 32);
    freq.put("ami\u0301", 123);
    freq.put("a\u0301so\u0308", 38);
    freq.put("ama\u0301", 227);
    freq.put("\u02c8", 29);
    freq.put("tda", 38);
    freq.put("amæ", 216);
    freq.put("amu\u0301", 39);
    freq.put("psþ", 115);
    freq.put("amþ", 87);
    freq.put("amo\u0301", 187);
    freq.put("amo\u0308", 61);
    freq.put("o\u0301te", 161);
    freq.put("sra", 90);
    freq.put("o\u0301ta", 345);
    freq.put("sre", 88);
    freq.put("gjo\u0308", 146);
    freq.put("o\u0301tm", 41);
    freq.put("sri", 40);
    freq.put("o\u0301ti", 277);
    freq.put("o\u0301tt", 1174);
    freq.put("o\u0301tu", 133);
    freq.put("o\u0301ts", 159);
    freq.put("gja\u0301", 29);
    freq.put("Ha\u0301k", 37);
    freq.put("loc", 48);
    freq.put("lof", 376);
    freq.put("log", 101);
    freq.put("lok", 1278);
    freq.put("Hru\u0301", 49);
    freq.put("lon", 100);
    freq.put("lom", 31);
    freq.put("lor", 130);
    freq.put("los", 137);
    freq.put("lop", 33);
    freq.put("low", 39);
    freq.put("lot", 189);
    freq.put("lou", 29);
    freq.put("rju", 301);
    freq.put("\u0646", 92);
    freq.put("J", 2209);
    freq.put("uvo\u0308", 31);
    freq.put("rja", 455);
    freq.put("lo ", 81);
    freq.put("Bru\u0301", 53);
    freq.put("I\u0301sl", 2081);
    freq.put("fsi", 147);
    freq.put("Wil", 110);
    freq.put("u\u0301af", 94);
    freq.put("Wii", 32);
    freq.put("u\u0301ar", 691);
    freq.put("Lam", 35);
    freq.put("Lan", 545);
    freq.put("Lao", 32);
    freq.put("æða", 580);
    freq.put("Lag", 87);
    freq.put("æði", 5160);
    freq.put("æðu", 478);
    freq.put("Lax", 122);
    freq.put("æðs", 139);
    freq.put("æðr", 99);
    freq.put("Lat", 43);
    freq.put("Lau", 192);
    freq.put("rjo\u0308", 122);
    freq.put("lga", 439);
    freq.put("rjo\u0301", 300);
    freq.put("ðnu", 157);
    freq.put("rju\u0301", 69);
    freq.put("u\u0301a ", 496);
    freq.put("ðni", 136);
    freq.put("rja\u0301", 342);
    freq.put("ðna", 212);
    freq.put("ðne", 31);
    freq.put("æð ", 244);
    freq.put("Bry", 34);
    freq.put("Bru", 46);
    freq.put("La ", 46);
    freq.put("Bro", 90);
    freq.put("Bri", 92);
    freq.put("Bre", 500);
    freq.put("Bra", 209);
    freq.put("to\u0308r", 51);
    freq.put("to\u0308l", 1034);
    freq.put("to\u0308n", 65);
    freq.put("to\u0308k", 743);
    freq.put("to\u0308f", 197);
    freq.put("y\u0301le", 93);
    freq.put("y\u0301li", 248);
    freq.put(" ro\u0308", 312);
    freq.put(" ro\u0301", 306);
    freq.put("mpa", 70);
    freq.put(" ry\u0301", 32);
    freq.put("mpl", 736);
    freq.put(" ru\u0301", 443);
    freq.put(" ræ", 385);
    freq.put(" ra\u0301", 293);
    freq.put("mps", 68);
    freq.put(" ri\u0301", 972);
    freq.put(" re\u0301", 421);
    freq.put("ysl", 34);
    freq.put("ysa", 75);
    freq.put("pul", 139);
    freq.put("ðsk", 523);
    freq.put("ðsh", 47);
    freq.put("ðsi", 217);
    freq.put("ða\u0301r", 38);
    freq.put("ðsl", 355);
    freq.put("Þi", 250);
    freq.put("puk", 38);
    freq.put(" ru", 152);
    freq.put("o\u0308gl", 33);
    freq.put("mpi\u0301", 104);
    freq.put(" ry", 31);
    freq.put("vet", 255);
    freq.put(" re", 1271);
    freq.put(" ra", 1335);
    freq.put("Þa", 1137);
    freq.put(" ro", 246);
    freq.put("I\u0301ta", 188);
    freq.put(" ri", 857);
    freq.put("ves", 1169);
    freq.put("s\u030c", 31);
    freq.put("yst", 379);
    freq.put("ny\u0301l", 85);
    freq.put("ny\u0301j", 114);
    freq.put("put", 29);
    freq.put("ny\u0301t", 153);
    freq.put("ny\u0301r", 57);
    freq.put("ny\u0301s", 66);
    freq.put("asj", 57);
    freq.put("S ", 238);
    freq.put("ðsp", 39);
    freq.put("ðsv", 67);
    freq.put("pur", 707);
    freq.put("pus", 125);
    freq.put("fð", 1006);
    freq.put("Sy", 96);
    freq.put("fo\u0301", 868);
    freq.put("ny\u0301 ", 52);
    freq.put("fu\u0301", 58);
    freq.put("Sp", 372);
    freq.put("Sv", 974);
    freq.put("fþ", 53);
    freq.put("St", 1866);
    freq.put("FC ", 43);
    freq.put("fa\u0301", 352);
    freq.put("Si", 722);
    freq.put("Sh", 148);
    freq.put("So", 351);
    freq.put("Sn", 277);
    freq.put("Sm", 127);
    freq.put("Sl", 218);
    freq.put("Sc", 214);
    freq.put("fe\u0301", 1623);
    freq.put("Sa", 1406);
    freq.put("fi\u0301", 157);
    freq.put("Se", 576);
    freq.put("o\u0308un", 59);
    freq.put("egð", 96);
    freq.put("vei", 2637);
    freq.put("f ", 7700);
    freq.put("lre", 29);
    freq.put("Fe\u0301l", 151);
    freq.put("lri", 85);
    freq.put("eg ", 669);
    freq.put("Su\u0301", 126);
    freq.put("fr", 11940);
    freq.put("fs", 2374);
    freq.put("ft", 4797);
    freq.put("fu", 5606);
    freq.put("fv", 268);
    freq.put("So\u0301", 163);
    freq.put("fy", 4976);
    freq.put("\u03bf\u0301", 43);
    freq.put("fa", 5499);
    freq.put("fb", 250);
    freq.put("fd", 62);
    freq.put("fe", 3046);
    freq.put("ff", 584);
    freq.put("fg", 129);
    freq.put("fh", 173);
    freq.put("fi", 7839);
    freq.put("fj", 4059);
    freq.put("fk", 117);
    freq.put("fl", 4455);
    freq.put("fm", 226);
    freq.put("fn", 8061);
    freq.put("fo", 2567);
    freq.put("a", 263792);
    freq.put("egy", 33);
    freq.put("egs", 216);
    freq.put("egr", 290);
    freq.put("egu", 1949);
    freq.put("egt", 454);
    freq.put("egj", 131);
    freq.put("egi", 1272);
    freq.put("ego", 116);
    freq.put("egn", 789);
    freq.put("o\u0308", 23897);
    freq.put("ega", 3391);
    freq.put("egg", 655);
    freq.put("ege", 76);
    freq.put("ce ", 210);
    freq.put("y ", 1711);
    freq.put("ffr", 124);
    freq.put("uvi", 38);
    freq.put("Hri", 58);
    freq.put("ffi", 118);
    freq.put("os ", 473);
    freq.put("Hre", 99);
    freq.put("uva", 134);
    freq.put("ffe", 40);
    freq.put("Hra", 144);
    freq.put("uve", 291);
    freq.put("ffa", 53);
    freq.put(" On", 42);
    freq.put(" Ol", 55);
    freq.put(" Ok", 35);
    freq.put(" Oh", 30);
    freq.put(" Of", 128);
    freq.put(" Od", 79);
    freq.put("\u0631 ", 29);
    freq.put("if ", 187);
    freq.put(" Ox", 46);
    freq.put(" Ot", 31);
    freq.put(" Or", 369);
    freq.put(" Os", 65);
    freq.put(" Op", 55);
    freq.put("aso\u0301", 42);
    freq.put("yk", 1688);
    freq.put("yj", 1636);
    freq.put("ym", 390);
    freq.put("aso\u0308", 150);
    freq.put("yo", 75);
    freq.put("yn", 4442);
    freq.put("ya", 182);
    freq.put("cen", 40);
    freq.put("yc", 47);
    freq.put("cel", 70);
    freq.put("ye", 103);
    freq.put("yd", 149);
    freq.put("asy\u0301", 141);
    freq.put("yf", 2085);
    freq.put("lþy\u0301", 88);
    freq.put("cet", 54);
    freq.put("ces", 67);
    freq.put("cer", 51);
    freq.put("yp", 342);
    freq.put("ys", 971);
    freq.put("yr", 6845);
    freq.put("puð", 74);
    freq.put("yt", 1440);
    freq.put("asi\u0301", 119);
    freq.put("ff ", 51);
    freq.put("ift", 225);
    freq.put("ifu", 195);
    freq.put("ifr", 86);
    freq.put("ifs", 149);
    freq.put(" O ", 35);
    freq.put("ife", 72);
    freq.put("iff", 48);
    freq.put("ifa", 566);
    freq.put("ifl", 73);
    freq.put("ifo", 174);
    freq.put("ifi", 210);
    freq.put("ifj", 45);
    freq.put("ðfa", 52);
    freq.put("End", 39);
    freq.put("Eng", 344);
    freq.put("ðs ", 277);
    freq.put("pu ", 453);
    freq.put("Hro\u0301", 53);
    freq.put("Si\u0301ð", 58);
    freq.put("Ens", 32);
    freq.put("uvi\u0301", 69);
    freq.put("ffæ", 88);
    freq.put("ly\u0301s", 582);
    freq.put("ass", 502);
    freq.put("pum", 165);
    freq.put("pun", 389);
    freq.put("asp", 70);
    freq.put("lþi", 147);
    freq.put("asv", 193);
    freq.put("asu", 87);
    freq.put("ast", 4650);
    freq.put("asy", 41);
    freq.put("ðsa", 58);
    freq.put("ðsf", 48);
    freq.put("pub", 42);
    freq.put("ðse", 398);
    freq.put("asa", 1107);
    freq.put("ðsy", 35);
    freq.put("as ", 455);
    freq.put("ase", 151);
    freq.put("ask", 904);
    freq.put("yð", 586);
    freq.put("asi", 329);
    freq.put("ash", 111);
    freq.put("aso", 291);
    freq.put("asn", 37);
    freq.put("asm", 56);
    freq.put("asl", 51);
    freq.put("ion", 501);
    freq.put("ðfr", 439);
    freq.put("Cla", 106);
    freq.put("st ", 7277);
    freq.put("dt ", 40);
    freq.put("u\u0301ðu", 100);
    freq.put("u\u0301ði", 56);
    freq.put("lið", 1440);
    freq.put("hu\u0301ð", 63);
    freq.put("u\u0301ða", 105);
    freq.put("tfl", 34);
    freq.put("rhu\u0301", 92);
    freq.put("tfi", 62);
    freq.put("tfj", 120);
    freq.put("tfe", 37);
    freq.put("rho\u0301", 65);
    freq.put("tfa", 120);
    freq.put("rho\u0308", 75);
    freq.put("rhe\u0301", 29);
    freq.put("nci", 82);
    freq.put("kað", 419);
    freq.put("nco", 35);
    freq.put("rha\u0301", 110);
    freq.put("kaþ", 93);
    freq.put("rhæ", 116);
    freq.put("ste", 1923);
    freq.put("stf", 191);
    freq.put("sta", 8651);
    freq.put("stb", 39);
    freq.put("o\u0301vi", 58);
    freq.put("stl", 62);
    freq.put("stm", 156);
    freq.put("stn", 133);
    freq.put("o\u0301ve", 202);
    freq.put("sth", 38);
    freq.put("sti", 2147);
    freq.put("stj", 1787);
    freq.put("o\u0301va", 44);
    freq.put("stu", 5049);
    freq.put("stv", 37);
    freq.put("str", 2496);
    freq.put("sts", 239);
    freq.put("u\u0301ð ", 64);
    freq.put("sty", 391);
    freq.put("Gol", 33);
    freq.put("ka ", 5563);
    freq.put("ofn", 1635);
    freq.put("Got", 52);
    freq.put("lid", 33);
    freq.put("Nik", 35);
    freq.put("lif", 428);
    freq.put("lig", 590);
    freq.put("Nin", 66);
    freq.put("lia", 157);
    freq.put("lib", 33);
    freq.put("lic", 99);
    freq.put("lil", 61);
    freq.put("Nic", 32);
    freq.put("lin", 2452);
    freq.put("hu\u0301n", 569);
    freq.put("lik", 141);
    freq.put("lit", 720);
    freq.put("liu", 91);
    freq.put("liv", 30);
    freq.put("2 ", 107);
    freq.put("lir", 354);
    freq.put("lis", 1592);
    freq.put("rhy", 62);
    freq.put("kab", 52);
    freq.put("kag", 595);
    freq.put("kaf", 322);
    freq.put("kad", 110);
    freq.put("kak", 79);
    freq.put("kah", 74);
    freq.put("rhu", 32);
    freq.put("kan", 720);
    freq.put("kam", 694);
    freq.put("kal", 1475);
    freq.put("Tho", 106);
    freq.put("kar", 1751);
    freq.put("kap", 274);
    freq.put("rhl", 419);
    freq.put("kau", 363);
    freq.put("kat", 183);
    freq.put("rha", 190);
    freq.put("The", 298);
    freq.put("rhe", 181);
    freq.put("Tha", 29);
    freq.put("nch", 109);
    freq.put("stæ", 1897);
    freq.put("li ", 3368);
    freq.put("sta\u0301", 53);
    freq.put("sti\u0301", 390);
    freq.put("ste\u0301", 71);
    freq.put("sto\u0308", 1473);
    freq.put("sto\u0301", 1005);
    freq.put("sty\u0301", 228);
    freq.put("stu\u0301", 122);
    freq.put(" A\u0301 ", 609);
    freq.put("gæs", 64);
    freq.put("gæt", 90);
    freq.put("gæf", 29);
    freq.put("\u0420", 33);
    freq.put("yms", 49);
    freq.put("nce", 184);
    freq.put("yma", 72);
    freq.put("ymi", 55);
    freq.put("tfr", 38);
    freq.put("ox ", 46);
    freq.put(" A\u0301g", 72);
    freq.put(" A\u0301l", 120);
    freq.put(" A\u0301r", 415);
    freq.put(" A\u0301s", 264);
    freq.put("elf", 107);
    freq.put("x", 2164);
    freq.put("\u0430\u044f ", 31);
    freq.put("sto", 2031);
    freq.put("gæð", 40);
    freq.put("stk", 49);
    freq.put("y\u0301ju", 59);
    freq.put("wor", 29);
    freq.put("dæm", 557);
    freq.put("dæl", 69);
    freq.put("y\u0301ja", 206);
    freq.put("Pla", 169);
    freq.put("dæg", 46);
    freq.put("eð", 11441);
    freq.put("ydd", 64);
    freq.put(" A\u0301ð", 37);
    freq.put("oxi\u0301", 40);
    freq.put("þy", 303);
    freq.put("Wal", 110);
    freq.put("þr", 1838);
    freq.put("þu", 272);
    freq.put("þv", 1549);
    freq.put("þi", 534);
    freq.put("þj", 1460);
    freq.put("þo", 314);
    freq.put("þa", 4830);
    freq.put("Was", 36);
    freq.put("þe", 4740);
    freq.put(" t ", 217);
    freq.put("add", 86);
    freq.put("lo\u0301a", 225);
    freq.put(" Þy\u0301", 325);
    freq.put(" ty", 60);
    freq.put(" tv", 1119);
    freq.put(" Þo\u0301", 307);
    freq.put(" tr", 698);
    freq.put("N", 3677);
    freq.put(" to", 200);
    freq.put("lo\u0301n", 87);
    freq.put(" tj", 75);
    freq.put(" ti", 6298);
    freq.put(" th", 207);
    freq.put("þ ", 167);
    freq.put(" te", 2098);
    freq.put("I\u0301ra", 76);
    freq.put(" ta", 1361);
    freq.put(" Þæ", 99);
    freq.put("gsæ", 96);
    freq.put("þu\u0301", 323);
    freq.put("no\u0301l", 35);
    freq.put("þy\u0301", 829);
    freq.put("þo\u0301", 497);
    freq.put("þo\u0308", 79);
    freq.put("þe\u0301", 152);
    freq.put("þi\u0301", 45);
    freq.put("þa\u0301", 1196);
    freq.put("no\u0301t", 79);
    freq.put("þæ", 401);
    freq.put("ðid", 32);
    freq.put("Kve", 46);
    freq.put("lo\u0301m", 402);
    freq.put("Kvi", 48);
    freq.put("gs ", 890);
    freq.put(" Þy", 38);
    freq.put(" tu\u0301", 84);
    freq.put("lie", 155);
    freq.put("no\u0301 ", 64);
    freq.put(" to\u0308", 739);
    freq.put(" Þr", 200);
    freq.put(" Þu", 34);
    freq.put(" Þv", 74);
    freq.put(" Þi", 250);
    freq.put(" ti\u0301", 1122);
    freq.put(" Þj", 278);
    freq.put(" Þo", 417);
    freq.put(" Þa", 1137);
    freq.put(" tæ", 256);
    freq.put(" Þe", 606);
    freq.put(" ta\u0301", 346);
    freq.put("gsp", 47);
    freq.put("gss", 198);
    freq.put("gsr", 110);
    freq.put("gsu", 50);
    freq.put("gst", 295);
    freq.put("gsv", 75);
    freq.put("gsa", 85);
    freq.put("gsb", 67);
    freq.put("gse", 69);
    freq.put("gsd", 42);
    freq.put("gsf", 96);
    freq.put("gsi", 265);
    freq.put("gsh", 92);
    freq.put("gsk", 208);
    freq.put("gsm", 187);
    freq.put("gsl", 236);
    freq.put("zku", 191);
    freq.put("æfð", 38);
    freq.put("hja", 45);
    freq.put("Ma\u0301r", 34);
    freq.put("lo\u0301i", 51);
    freq.put("\u03b9", 127);
    freq.put("lip", 103);
    freq.put("ee ", 58);
    freq.put("lo\u0301v", 63);
    freq.put("hu\u0301s", 642);
    freq.put("Þet", 130);
    freq.put("Þes", 144);
    freq.put("Þei", 197);
    freq.put("Þeg", 77);
    freq.put("ruð", 130);
    freq.put("eet", 35);
    freq.put("een", 87);
    freq.put("kro\u0301", 126);
    freq.put("eed", 29);
    freq.put("mhe", 130);
    freq.put("hjo\u0301", 152);
    freq.put("ru ", 5901);
    freq.put("hju\u0301", 47);
    freq.put("hja\u0301", 398);
    freq.put("æfi", 141);
    freq.put("æfe", 104);
    freq.put("æfa", 50);
    freq.put(" Qu", 74);
    freq.put("xa\u0301r", 48);
    freq.put("\u0437", 43);
    freq.put("id ", 120);
    freq.put("ruh", 42);
    freq.put("rhr", 181);
    freq.put("run", 1571);
    freq.put("rul", 208);
    freq.put("rum", 2163);
    freq.put("rub", 37);
    freq.put("ruc", 30);
    freq.put("ruf", 120);
    freq.put("rug", 140);
    freq.put("rud", 31);
    freq.put("rur", 213);
    freq.put("rus", 350);
    freq.put("rup", 45);
    freq.put("rhv", 114);
    freq.put("ruv", 97);
    freq.put("rut", 38);
    freq.put("kas", 646);
    freq.put("idi", 32);
    freq.put("xa\u0301 ", 30);
    freq.put("idg", 43);
    freq.put("idd", 384);
    freq.put("ide", 137);
    freq.put("ida", 195);
    freq.put("Tu\u0301", 51);
    freq.put("rho", 90);
    freq.put("Ell", 80);
    freq.put("To\u0308", 63);
    freq.put("ðu ", 1241);
    freq.put("To\u0301", 200);
    freq.put("Eld", 72);
    freq.put("Ti\u0301", 127);
    freq.put("Te\u0301", 39);
    freq.put("Tæ", 41);
    freq.put("Ta\u0301", 38);
    freq.put("ut ", 328);
    freq.put("\u4e26", 35);
    freq.put("nað", 2058);
    freq.put("nau\u0301", 37);
    freq.put("naþ", 36);
    freq.put("ðul", 76);
    freq.put("ðum", 1484);
    freq.put("ðun", 524);
    freq.put("ðuh", 32);
    freq.put("ðuk", 30);
    freq.put("ðuf", 35);
    freq.put("ðug", 67);
    freq.put("ðub", 33);
    freq.put("i\u0301gð", 53);
    freq.put("ðuv", 112);
    freq.put("ður", 7875);
    freq.put("ðus", 182);
    freq.put(" æs", 38);
    freq.put("svi\u0301", 186);
    freq.put("utf", 76);
    freq.put(" æt", 868);
    freq.put(" æv", 104);
    freq.put("svæ", 826);
    freq.put(" æx", 33);
    freq.put("uth", 88);
    freq.put("uti", 783);
    freq.put("utn", 112);
    freq.put("uto", 43);
    freq.put("utl", 60);
    freq.put("utr", 39);
    freq.put("Að", 243);
    freq.put("utv", 219);
    freq.put("utt", 454);
    freq.put("utu", 201);
    freq.put("svo\u0308", 99);
    freq.put("Aþ", 47);
    freq.put("i\u0301g ", 45);
    freq.put("Eli\u0301", 30);
    freq.put("Tv", 79);
    freq.put("Tu", 195);
    freq.put("Tr", 409);
    freq.put("Ice", 47);
    freq.put("To", 307);
    freq.put("Tj", 67);
    freq.put("Th", 490);
    freq.put("Ti", 314);
    freq.put("Te", 275);
    freq.put("Ta", 376);
    freq.put("nab", 189);
    freq.put("A ", 369);
    freq.put("naf", 1278);
    freq.put("nag", 145);
    freq.put("nad", 255);
    freq.put("nae", 106);
    freq.put("naj", 48);
    freq.put("nak", 181);
    freq.put("nah", 376);
    freq.put("nan", 1706);
    freq.put("nal", 486);
    freq.put("nam", 345);
    freq.put("nar", 7258);
    freq.put("nas", 978);
    freq.put("nap", 74);
    freq.put("nav", 232);
    freq.put("nat", 892);
    freq.put("nau", 139);
    freq.put("i\u0301ga", 62);
    freq.put("sni\u0301", 36);
    freq.put("i\u0301gi", 50);
    freq.put("i\u0301gs", 41);
    freq.put("i\u0301gr", 36);
    freq.put("i\u0301gu", 52);
    freq.put("ðuð", 62);
    freq.put("T ", 79);
    freq.put("Aa", 38);
    freq.put(" æð", 121);
    freq.put("Ac", 57);
    freq.put("Ab", 97);
    freq.put("e", 187693);
    freq.put("Ad", 101);
    freq.put("Ag", 60);
    freq.put("Af", 349);
    freq.put("Ai", 48);
    freq.put("Ak", 259);
    freq.put("sve", 2028);
    freq.put("Am", 376);
    freq.put("Al", 997);
    freq.put("An", 599);
    freq.put("o\u0301ha", 107);
    freq.put("As", 369);
    freq.put("Ar", 661);
    freq.put("Au", 691);
    freq.put("At", 288);
    freq.put("Av", 40);
    freq.put("u\u0301", 17028);
    freq.put("arð", 2612);
    freq.put("gu", 10964);
    freq.put("gt", 1944);
    freq.put("gs", 3263);
    freq.put("gr", 4868);
    freq.put("gy", 295);
    freq.put("gg", 3399);
    freq.put("Ber", 266);
    freq.put("ge", 6266);
    freq.put("gd", 575);
    freq.put("gb", 298);
    freq.put("ga", 14643);
    freq.put("go", 889);
    freq.put("gn", 2900);
    freq.put("gm", 495);
    freq.put("Gil", 84);
    freq.put("gk", 130);
    freq.put("gj", 2483);
    freq.put("gi", 7861);
    freq.put("gh", 415);
    freq.put("lkn", 60);
    freq.put("lko", 96);
    freq.put("lkj", 58);
    freq.put("lki", 628);
    freq.put("mai\u0301", 169);
    freq.put("lke", 74);
    freq.put("lka", 170);
    freq.put("lky", 33);
    freq.put("Not", 36);
    freq.put("lku", 305);
    freq.put("\u03bd", 134);
    freq.put("rto", 127);
    freq.put("Nor", 1398);
    freq.put("tme", 42);
    freq.put("g ", 30278);
    freq.put("hi ", 50);
    freq.put("lk ", 248);
    freq.put("Spi", 49);
    freq.put("Spa", 50);
    freq.put("Spe", 34);
    freq.put("go\u0308", 726);
    freq.put("zo", 77);
    freq.put("go\u0301", 341);
    freq.put("aræ", 58);
    freq.put("zk", 225);
    freq.put("ze", 74);
    freq.put("za", 123);
    freq.put("gæ", 257);
    freq.put("ga\u0301", 474);
    freq.put("zu", 44);
    freq.put("gi\u0301", 357);
    freq.put("fli", 90);
    freq.put("flj", 256);
    freq.put("Tjo\u0308", 35);
    freq.put("lko\u0301", 30);
    freq.put("ulo", 30);
    freq.put("æna", 190);
    freq.put("ymp", 115);
    freq.put("z ", 258);
    freq.put("ula", 290);
    freq.put("ulf", 47);
    freq.put("\u0440\u0430", 31);
    freq.put("uld", 119);
    freq.put("Spa\u0301", 114);
    freq.put("wic", 43);
    freq.put(" væ", 160);
    freq.put(" ve\u0301", 126);
    freq.put(" vi\u0301", 914);
    freq.put(" vo\u0308", 461);
    freq.put("ied", 45);
    freq.put(" va", 8042);
    freq.put(" ve", 5521);
    freq.put(" vi", 6117);
    freq.put(" vo", 1291);
    freq.put("mi\u0301l", 29);
    freq.put("mi\u0301n", 126);
    freq.put("hly\u0301", 34);
    freq.put("nu\u0301 ", 311);
    freq.put("hli\u0301", 219);
    freq.put("Pa\u0301l", 100);
    freq.put("y\u0301ki", 49);
    freq.put("\u0628", 97);
    freq.put("sæt", 356);
    freq.put("sæn", 178);
    freq.put("sæl", 271);
    freq.put("sæk", 59);
    freq.put("ly\u0301t", 37);
    freq.put("hlu", 2009);
    freq.put("pið", 157);
    freq.put("mar", 1996);
    freq.put("hlj", 1680);
    freq.put("hli", 228);
    freq.put("hle", 106);
    freq.put("hla", 226);
    freq.put("ko\u0301t", 31);
    freq.put("Æt", 40);
    freq.put("Æv", 33);
    freq.put("ko\u0301r", 108);
    freq.put("mav", 111);
    freq.put("ko\u0301g", 196);
    freq.put("sy\u0301s", 821);
    freq.put("ko\u0301l", 1488);
    freq.put("\u043f", 31);
    freq.put("eco", 32);
    freq.put("Ru\u0301n", 33);
    freq.put("eck", 48);
    freq.put("ech", 72);
    freq.put("ect", 77);
    freq.put("Ru\u0301s", 196);
    freq.put("ko\u0301 ", 88);
    freq.put("mad", 43);
    freq.put("ðto", 53);
    freq.put("rs ", 1328);
    freq.put("rtæ", 610);
    freq.put("art", 990);
    freq.put(" Sy", 96);
    freq.put(" Sp", 370);
    freq.put(" Sv", 974);
    freq.put(" St", 1837);
    freq.put(" Su", 940);
    freq.put(" Sj", 303);
    freq.put(" Sk", 1509);
    freq.put(" Sh", 147);
    freq.put(" Si", 722);
    freq.put(" Sn", 277);
    freq.put(" So", 351);
    freq.put(" Sl", 218);
    freq.put(" Sm", 127);
    freq.put(" Sc", 205);
    freq.put(" Sa", 1402);
    freq.put(" Se", 571);
    freq.put("rsl", 476);
    freq.put("rsm", 68);
    freq.put("rsn", 93);
    freq.put("rso", 176);
    freq.put("rsh", 96);
    freq.put("rsi", 446);
    freq.put("rsj", 74);
    freq.put("rsk", 1287);
    freq.put("rsd", 88);
    freq.put("rse", 406);
    freq.put("rsf", 44);
    freq.put("rsa", 290);
    freq.put("rsb", 37);
    freq.put("R", 3778);
    freq.put("rsy", 38);
    freq.put("rst", 3509);
    freq.put("rsu", 120);
    freq.put("rsv", 330);
    freq.put("rsp", 74);
    freq.put("rss", 354);
    freq.put("bek", 34);
    freq.put("bei", 420);
    freq.put("Hvi\u0301", 124);
    freq.put("ura\u0301", 81);
    freq.put("bel", 260);
    freq.put("uri\u0301", 54);
    freq.put("fja\u0301", 227);
    freq.put("rto\u0308", 112);
    freq.put("urð", 755);
    freq.put("ber", 1931);
    freq.put("bes", 144);
    freq.put(" S ", 42);
    freq.put("fjo\u0308", 1748);
    freq.put("bet", 171);
    freq.put("arf", 2166);
    freq.put("arj", 31);
    freq.put(" Su\u0301", 125);
    freq.put("ur ", 26291);
    freq.put(" Sy\u0301", 65);
    freq.put("nnr", 157);
    freq.put(" So\u0301", 162);
    freq.put("ubo\u0301", 48);
    freq.put(" So\u0308", 178);
    freq.put(" Se\u0301", 40);
    freq.put(" Si\u0301", 179);
    freq.put("aro", 178);
    freq.put(" Sæ", 89);
    freq.put("rsi\u0301", 75);
    freq.put("rsæ", 104);
    freq.put("rsa\u0301", 81);
    freq.put("rsy\u0301", 233);
    freq.put("\u05d4", 29);
    freq.put("rso\u0308", 95);
    freq.put("lu\u0301b", 39);
    freq.put("awa", 61);
    freq.put("rso\u0301", 269);
    freq.put("urd", 67);
    freq.put("ure", 339);
    freq.put("urf", 235);
    freq.put("urg", 224);
    freq.put("ædd", 776);
    freq.put("urb", 253);
    freq.put("Hva", 208);
    freq.put("urm", 112);
    freq.put("fja", 1696);
    freq.put("uro", 90);
    freq.put("Hve", 94);
    freq.put("uri", 1241);
    freq.put("urj", 30);
    freq.put("urk", 192);
    freq.put("urt", 381);
    freq.put("uru", 95);
    freq.put("urv", 93);
    freq.put("urp", 40);
    freq.put("urr", 390);
    freq.put("urs", 1140);
    freq.put("Del", 38);
    freq.put("ury", 37);
    freq.put("fju", 37);
    freq.put("mfe\u0301", 153);
    freq.put("ngd", 467);
    freq.put("nge", 478);
    freq.put("ngf", 42);
    freq.put("y\u0301sl", 836);
    freq.put("y\u0301sk", 757);
    freq.put("nga", 4769);
    freq.put("ngb", 69);
    freq.put("ngl", 694);
    freq.put("ngm", 109);
    freq.put("ngn", 161);
    freq.put("ngo", 35);
    freq.put("ngh", 122);
    freq.put("ngi", 2358);
    freq.put("ngj", 642);
    freq.put("ngk", 66);
    freq.put("sh ", 114);
    freq.put("ngu", 4585);
    freq.put("ngv", 376);
    freq.put("ngr", 646);
    freq.put("ngs", 1362);
    freq.put("y\u0301st", 220);
    freq.put("tbr", 96);
    freq.put("tbu", 123);
    freq.put("i\u0301et", 48);
    freq.put("tbo", 47);
    freq.put("tba", 41);
    freq.put("ttt", 56);
    freq.put("tbe", 34);
    freq.put("keð", 39);
    freq.put("shr", 178);
    freq.put("ng ", 2515);
    freq.put("shv", 58);
    freq.put("shy", 73);
    freq.put("o\u0301ju", 31);
    freq.put("sha", 333);
    freq.put("she", 190);
    freq.put("shi", 231);
    freq.put("shl", 141);
    freq.put("sho", 46);
    freq.put("ke ", 136);
    freq.put("lur", 1152);
    freq.put("lus", 353);
    freq.put("lut", 2348);
    freq.put("nga\u0301", 73);
    freq.put("luv", 69);
    freq.put("ngo\u0308", 59);
    freq.put("lue", 48);
    freq.put("luf", 94);
    freq.put("ngo\u0301", 130);
    freq.put("luh", 51);
    freq.put("\u043b", 143);
    freq.put("luk", 133);
    freq.put("lul", 121);
    freq.put("lum", 1455);
    freq.put("lun", 888);
    freq.put("ken", 1184);
    freq.put("kem", 386);
    freq.put("kel", 195);
    freq.put("tby\u0301", 74);
    freq.put("kei", 325);
    freq.put("keg", 32);
    freq.put("kef", 136);
    freq.put("mgo\u0308", 49);
    freq.put("key", 170);
    freq.put("tba\u0301", 198);
    freq.put("ket", 42);
    freq.put("kes", 42);
    freq.put("ker", 1044);
    freq.put("kep", 493);
    freq.put("sho\u0301", 47);
    freq.put("sho\u0308", 100);
    freq.put("shu\u0301", 35);
    freq.put("lu ", 1523);
    freq.put("sha\u0301", 42);
    freq.put("Lof", 40);
    freq.put("ot ", 172);
    freq.put("Lon", 229);
    freq.put("Los", 48);
    freq.put("lo\u0308t", 398);
    freq.put("Lou", 37);
    freq.put("yan", 50);
    freq.put(" au", 1349);
    freq.put("oth", 76);
    freq.put("oti", 132);
    freq.put("otk", 150);
    freq.put("otl", 108);
    freq.put("otn", 229);
    freq.put("oto", 46);
    freq.put("ota", 1324);
    freq.put("ote", 93);
    freq.put("ots", 82);
    freq.put("ott", 415);
    freq.put("otu", 454);
    freq.put("otv", 37);
    freq.put("And", 211);
    freq.put("Ang", 85);
    freq.put("Ana", 32);
    freq.put("A\u0301lf", 73);
    freq.put("Ann", 73);
    freq.put("Ani", 38);
    freq.put("Ant", 112);
    freq.put("ino", 134);
    freq.put("mæt", 102);
    freq.put("ya ", 46);
    freq.put("You", 39);
    freq.put("Yor", 108);
    freq.put("go\u0308g", 58);
    freq.put("orð", 3303);
    freq.put("kkl", 305);
    freq.put("i", 195706);
    freq.put("ori\u0301", 119);
    freq.put("þ", 19539);
    freq.put("\u3042\u3042", 41);
    freq.put("so\u0301s", 78);
    freq.put("Be", 746);
    freq.put("Ba", 1277);
    freq.put("Bl", 365);
    freq.put("Bo", 829);
    freq.put("Bi", 297);
    freq.put("Bj", 353);
    freq.put("Bu", 149);
    freq.put("Br", 1094);
    freq.put("ora\u0301", 31);
    freq.put("By", 66);
    freq.put(" a ", 135);
    freq.put("B ", 133);
    freq.put(" x ", 48);
    freq.put("e\u0301st", 58);
    freq.put("y\u0301ðs", 32);
    freq.put("U ", 71);
    freq.put("Bæ", 200);
    freq.put("Ba\u0301", 77);
    freq.put("Bi\u0301", 44);
    freq.put("War", 47);
    freq.put("Bo\u0308", 36);
    freq.put("Bo\u0301", 133);
    freq.put("Bu\u0301", 144);
    freq.put("duh", 45);
    freq.put("Ut", 32);
    freq.put("Up", 198);
    freq.put("Ur", 47);
    freq.put("Um", 210);
    freq.put("Ul", 39);
    freq.put("Un", 333);
    freq.put("pv", 50);
    freq.put("pt", 1531);
    freq.put("duc", 33);
    freq.put("ea ", 112);
    freq.put("h ", 796);
    freq.put("eak", 31);
    freq.put("hy", 512);
    freq.put("eal", 37);
    freq.put("ean", 82);
    freq.put("hr", 2163);
    freq.put("hs", 37);
    freq.put("pe", 1831);
    freq.put("eae", 45);
    freq.put("ead", 32);
    freq.put("ht", 210);
    freq.put("hu", 1451);
    freq.put("hj", 645);
    freq.put("hi", 2023);
    freq.put("hn", 524);
    freq.put("ho", 1432);
    freq.put("hl", 4630);
    freq.put("hm", 61);
    freq.put("hb", 32);
    freq.put("eas", 45);
    freq.put("ear", 81);
    freq.put("eau", 29);
    freq.put("ph", 775);
    freq.put("he", 10053);
    freq.put("dus", 104);
    freq.put("dmi", 55);
    freq.put("hni\u0301", 30);
    freq.put("po", 550);
    freq.put("gro", 36);
    freq.put("pl", 1650);
    freq.put("hnu\u0301", 49);
    freq.put("hn ", 90);
    freq.put("þæt", 143);
    freq.put("þær", 240);
    freq.put(" Ut", 32);
    freq.put(" Up", 196);
    freq.put(" Ur", 46);
    freq.put(" Ul", 39);
    freq.put(" Um", 208);
    freq.put(" Un", 333);
    freq.put("or ", 435);
    freq.put(" tu", 588);
    freq.put("hu\u0301", 1293);
    freq.put("hy\u0301", 74);
    freq.put("ho\u0301", 925);
    freq.put("ho\u0308", 2143);
    freq.put("Aþe", 44);
    freq.put("he\u0301", 660);
    freq.put("hi\u0301", 33);
    freq.put("ha\u0301", 1640);
    freq.put("hæ", 1097);
    freq.put("hna", 38);
    freq.put("I\u0301rl", 73);
    freq.put("hne", 91);
    freq.put("hni", 63);
    freq.put("hno", 44);
    freq.put("hns", 33);
    freq.put("mo\u0301t", 447);
    freq.put(" Þa\u0301", 57);
    freq.put("aug", 671);
    freq.put("auf", 120);
    freq.put("auk", 646);
    freq.put("aum", 222);
    freq.put("aul", 90);
    freq.put("up ", 193);
    freq.put("aun", 895);
    freq.put("aup", 528);
    freq.put("aus", 1761);
    freq.put("aur", 125);
    freq.put("aut", 633);
    freq.put("neð", 186);
    freq.put("Joh", 167);
    freq.put("með", 4188);
    freq.put("po\u0308n", 127);
    freq.put("sju\u0301", 230);
    freq.put("au ", 547);
    freq.put("dru\u0301", 32);
    freq.put("upi", 81);
    freq.put("fhe", 36);
    freq.put("sjo\u0301", 945);
    freq.put("æja", 272);
    freq.put("upe", 58);
    freq.put("sjo\u0308", 285);
    freq.put("upa", 89);
    freq.put("dre\u0301", 44);
    freq.put("o\u0301li\u0301", 218);
    freq.put("dri\u0301", 37);
    freq.put("dra\u0301", 54);
    freq.put("sja\u0301", 875);
    freq.put("ups", 167);
    freq.put("æju", 29);
    freq.put("dræ", 56);
    freq.put("þun", 127);
    freq.put("olk", 48);
    freq.put("me ", 192);
    freq.put("þur", 132);
    freq.put("nen", 108);
    freq.put("nel", 88);
    freq.put("nem", 287);
    freq.put("nei", 195);
    freq.put("nef", 1415);
    freq.put("neg", 62);
    freq.put("ned", 41);
    freq.put("nea", 43);
    freq.put("auð", 861);
    freq.put("ney", 381);
    freq.put("net", 289);
    freq.put("neu", 45);
    freq.put("o\u0301l ", 221);
    freq.put("nes", 1695);
    freq.put("med", 51);
    freq.put("\u0443", 71);
    freq.put("mef", 118);
    freq.put("mel", 116);
    freq.put("men", 2186);
    freq.put("mei", 865);
    freq.put("met", 614);
    freq.put("orp", 260);
    freq.put("mes", 450);
    freq.put("mer", 1104);
    freq.put("mey", 48);
    freq.put("dry", 91);
    freq.put("o\u0301ly", 43);
    freq.put("so\u0301l", 222);
    freq.put("o\u0301lu", 206);
    freq.put("dru", 103);
    freq.put("ne ", 377);
    freq.put("o\u0301ls", 237);
    freq.put("o\u0301ll", 128);
    freq.put("o\u0301lm", 135);
    freq.put("so\u0301n", 245);
    freq.put("o\u0301li", 764);
    freq.put("dro", 176);
    freq.put("o\u0301lk", 565);
    freq.put("dra", 458);
    freq.put("o\u0301le", 64);
    freq.put("o\u0301lf", 325);
    freq.put("sja", 169);
    freq.put("dre", 520);
    freq.put("o\u0301la", 1201);
    freq.put("St ", 29);
    freq.put("ygð", 31);
    freq.put("A\u0301", 1654);
    freq.put("Ste", 372);
    freq.put("kgr", 34);
    freq.put("Sta", 383);
    freq.put("Sto", 146);
    freq.put("Sti", 42);
    freq.put("Stj", 104);
    freq.put("Stu", 161);
    freq.put("Str", 276);
    freq.put("V", 3210);
    freq.put("ly\u0301ð", 232);
    freq.put("ove\u0301", 67);
    freq.put("Sty", 51);
    freq.put("rin", 4044);
    freq.put("Tim", 38);
    freq.put("Tin", 49);
    freq.put("Alþ", 272);
    freq.put("tga\u0301", 259);
    freq.put("ygg", 1542);
    freq.put("Lim", 33);
    freq.put("Lin", 79);
    freq.put("ygl", 52);
    freq.put("ygj", 36);
    freq.put("ygi", 89);
    freq.put("Lit", 139);
    freq.put("ov ", 34);
    freq.put("Lis", 104);
    freq.put("Kan", 178);
    freq.put("Kam", 65);
    freq.put("Kal", 223);
    freq.put("Kas", 91);
    freq.put("Kar", 285);
    freq.put("Kap", 39);
    freq.put("no\u0301v", 141);
    freq.put("Kau", 134);
    freq.put("Kat", 86);
    freq.put("Stæ", 32);
    freq.put(" sa", 4334);
    freq.put("Sto\u0308", 59);
    freq.put("ova", 32);
    freq.put("Sto\u0301", 139);
    freq.put("ovi", 54);
    freq.put("All", 93);
    freq.put("Alm", 57);
    freq.put("Alf", 93);
    freq.put("Alg", 63);
    freq.put("Ale", 88);
    freq.put("Alb", 62);
    freq.put("Ala", 63);
    freq.put("pu\u0301", 114);
    freq.put("A\u0301ri", 106);
    freq.put("A\u0301rm", 44);
    freq.put("A\u0301rn", 150);
    freq.put("ra\u0301b", 38);
    freq.put("ra\u0301a", 38);
    freq.put("ra\u0301n", 98);
    freq.put("ra\u0301k", 60);
    freq.put("ra\u0301i", 33);
    freq.put("ra\u0301v", 43);
    freq.put("ra\u0301t", 145);
    freq.put("ra\u0301r", 206);
    freq.put("ra\u0301s", 260);
    freq.put("\u03c1", 115);
    freq.put("ona", 1076);
    freq.put("ra\u0301 ", 3167);
    freq.put("bo\u0301t", 132);
    freq.put("ong", 207);
    freq.put("bo\u0301l", 159);

    init2();
  }
  private static void init2() {
    
    freq.put("bo\u0301n", 65);
    freq.put("væl", 58);
    freq.put("bo\u0301k", 1011);
    freq.put("Oxf", 36);
    freq.put("lo\u0308ð", 154);
    freq.put("U\u0301l", 56);
    freq.put("isu\u0301", 45);
    freq.put("ðsa\u0301", 34);
    freq.put("U\u0301k", 30);
    freq.put("væg", 225);
    freq.put("U\u0301t", 101);
    freq.put("isa\u0301", 31);
    freq.put("U\u0301r", 59);
    freq.put("Wor", 55);
    freq.put("u\u0301fu", 85);
    freq.put("ra\u0301ð", 822);
    freq.put("Cou", 37);
    freq.put("ri\u0301o", 31);
    freq.put("is ", 1869);
    freq.put(" to\u0301", 1014);
    freq.put("Þri\u0301", 29);
    freq.put("Þra\u0301", 37);
    freq.put("ðvi\u0301", 60);
    freq.put("iss", 785);
    freq.put("isr", 186);
    freq.put("isp", 55);
    freq.put("isv", 198);
    freq.put("isu", 36);
    freq.put("ist", 4346);
    freq.put("isk", 905);
    freq.put("isj", 46);
    freq.put("isi", 625);
    freq.put("ish", 290);
    freq.put("iso", 62);
    freq.put("isn", 159);
    freq.put("ism", 523);
    freq.put("isl", 359);
    freq.put("isc", 101);
    freq.put("isb", 133);
    freq.put("isa", 319);
    freq.put("isg", 63);
    freq.put("isf", 275);
    freq.put("ise", 129);
    freq.put("isd", 44);
    freq.put("Eur", 33);
    freq.put("gy ", 31);
    freq.put("la\u0301 ", 83);
    freq.put("fin", 1853);
    freq.put("i\u0301o\u0301i", 42);
    freq.put("la\u0301n", 85);
    freq.put("la\u0301k", 76);
    freq.put("la\u0301g", 191);
    freq.put("gyp", 133);
    freq.put("la\u0301t", 267);
    freq.put("la\u0301r", 68);
    freq.put("la\u0301s", 107);
    freq.put("i\u0301o\u0301 ", 37);
    freq.put("ty ", 229);
    freq.put("i\u0301no\u0301", 48);
    freq.put("do ", 152);
    freq.put("tyk", 37);
    freq.put("oft", 1402);
    freq.put("gyð", 102);
    freq.put("tyt", 114);
    freq.put("tyr", 286);
    freq.put("don", 304);
    freq.put("dom", 32);
    freq.put("m", 99769);
    freq.put("dor", 109);
    freq.put("dos", 38);
    freq.put("dow", 49);
    freq.put(" We", 157);
    freq.put(" Wa", 263);
    freq.put(" Wo", 94);
    freq.put(" Wh", 41);
    freq.put(" Wi", 308);
    freq.put("vo\u0308 ", 226);
    freq.put("kul", 461);
    freq.put("ba ", 118);
    freq.put("\u03c5", 43);
    freq.put("vo\u0308x", 63);
    freq.put("vo\u0308t", 84);
    freq.put("vo\u0308r", 454);
    freq.put("vo\u0308l", 332);
    freq.put("vo\u0308k", 88);
    freq.put("kuf", 44);
    freq.put("bat", 32);
    freq.put("bau", 182);
    freq.put("bar", 589);
    freq.put("bas", 167);
    freq.put("bad", 40);
    freq.put("Hja\u0301", 32);
    freq.put("bac", 32);
    freq.put("mo\u0308g", 91);
    freq.put("ban", 1603);
    freq.put("bal", 62);
    freq.put("bam", 50);
    freq.put("bak", 368);
    freq.put("bah", 47);
    freq.put("om ", 494);
    freq.put("Eft", 63);
    freq.put("Efn", 44);
    freq.put("un ", 2337);
    freq.put("fn ", 987);
    freq.put("omb", 46);
    freq.put("C", 2240);
    freq.put("ome", 121);
    freq.put("omi", 303);
    freq.put("omo", 42);
    freq.put("omn", 42);
    freq.put("omm", 235);
    freq.put("vo\u0308ð", 43);
    freq.put("oms", 54);
    freq.put("omp", 59);
    freq.put("omu", 187);
    freq.put("Ef ", 37);
    freq.put("fnv", 120);
    freq.put("fnu", 1196);
    freq.put("fnt", 253);
    freq.put("fns", 126);
    freq.put("unu", 1350);
    freq.put("bað", 32);
    freq.put("fng", 60);
    freq.put("fnf", 164);
    freq.put("fne", 55);
    freq.put("fnd", 868);
    freq.put("Hja", 125);
    freq.put("une", 148);
    freq.put("fna", 2112);
    freq.put("ung", 2211);
    freq.put("uni", 524);
    freq.put("unk", 272);
    freq.put("fni", 1953);
    freq.put("fnh", 30);
    freq.put("o\u0301n ", 402);
    freq.put("iþ", 48);
    freq.put("ið", 22433);
    freq.put("i\u0301a ", 451);
    freq.put("ia\u0301", 30);
    freq.put("san", 529);
    freq.put("yðr", 29);
    freq.put("yðs", 65);
    freq.put("C ", 290);
    freq.put("yða", 47);
    freq.put("ppu", 465);
    freq.put("yðj", 117);
    freq.put("yði", 287);
    freq.put("sl ", 180);
    freq.put("o\u0301ng", 36);
    freq.put("o\u0301nd", 59);
    freq.put("o\u0301ne", 67);
    freq.put("o\u0301na", 507);
    freq.put("Svæ", 31);
    freq.put("o\u0301nl", 482);
    freq.put("kið", 1002);
    freq.put("o\u0301ni", 207);
    freq.put("o\u0301nv", 387);
    freq.put("o\u0301nu", 716);
    freq.put("o\u0301ns", 366);
    freq.put("i\u0301al", 40);
    freq.put("i\u0301an", 123);
    freq.put("Ci", 87);
    freq.put("Ch", 432);
    freq.put("Co", 498);
    freq.put("sly", 46);
    freq.put("Cl", 179);
    freq.put("slu", 1624);
    freq.put("Ca", 498);
    freq.put("Vi\u0301", 264);
    freq.put("Ce", 91);
    freq.put("Ma\u0301l", 122);
    freq.put("slo", 65);
    freq.put("sli", 370);
    freq.put("Vo\u0308", 72);
    freq.put("gla", 791);
    freq.put("sle", 2574);
    freq.put("sla", 2777);
    freq.put("Cu", 62);
    freq.put("iy", 35);
    freq.put("ix", 96);
    freq.put("iz", 110);
    freq.put("Naf", 146);
    freq.put("iq", 49);
    freq.put("ip", 2056);
    freq.put("is", 11681);
    freq.put("ir", 20666);
    freq.put("iu", 360);
    freq.put("it", 9396);
    freq.put("iv", 434);
    freq.put("Nar", 29);
    freq.put("Nas", 29);
    freq.put("ik", 5708);
    freq.put("ij", 65);
    freq.put("im", 4416);
    freq.put("il", 15253);
    freq.put("Nat", 57);
    freq.put("Nau", 55);
    freq.put("ia", 1044);
    freq.put("ic", 1301);
    freq.put("ki ", 3751);
    freq.put("ie", 864);
    freq.put("id", 1046);
    freq.put("ig", 5591);
    freq.put("if", 2163);
    freq.put("V ", 127);
    freq.put("akk", 529);
    freq.put("u\u0301fe\u0301", 45);
    freq.put("i\u0301ne", 65);
    freq.put("Svi", 95);
    freq.put("kis", 1049);
    freq.put("kir", 1170);
    freq.put("kip", 1436);
    freq.put("Sva", 354);
    freq.put("kin", 2085);
    freq.put("kim", 46);
    freq.put("kil", 1176);
    freq.put("i ", 42436);
    freq.put("kif", 29);
    freq.put("kie", 30);
    freq.put("Va", 711);
    freq.put("lo\u0308n", 726);
    freq.put("Ve", 1144);
    freq.put("Vi", 653);
    freq.put("slo\u0308", 108);
    freq.put("Vo", 162);
    freq.put("sli\u0301", 192);
    freq.put("sle\u0301", 92);
    freq.put("slæ", 31);
    freq.put("sla\u0301", 52);
    freq.put("nk ", 108);
    freq.put("op ", 66);
    freq.put("yer", 35);
    freq.put("o\u0308f ", 67);
    freq.put("opt", 43);
    freq.put("opp", 155);
    freq.put("ope", 40);
    freq.put("opa", 52);
    freq.put("opn", 231);
    freq.put("opo", 41);
    freq.put("oph", 87);
    freq.put("opi", 251);
    freq.put("o\u0308fn", 464);
    freq.put("o\u0308fl", 142);
    freq.put("Art", 46);
    freq.put("Ara", 128);
    freq.put("Are", 29);
    freq.put("Arg", 37);
    freq.put("Ari", 100);
    freq.put("o\u0308fu", 1400);
    freq.put("o\u0308fr", 36);
    freq.put("Arn", 175);
    freq.put("To\u0301n", 101);
    freq.put("To\u0301m", 44);
    freq.put("o\u0301ðr", 133);
    freq.put("o\u0301ðs", 215);
    freq.put("o\u0301ðu", 414);
    freq.put("o\u0301ðv", 149);
    freq.put("o\u0301ðh", 71);
    freq.put("o\u0301ði", 237);
    freq.put("o\u0301ðk", 45);
    freq.put("o\u0301ðl", 242);
    freq.put("o\u0301ðm", 36);
    freq.put("o\u0301ða", 595);
    freq.put("o\u0301ðb", 40);
    freq.put("o\u0301ðe", 41);
    freq.put("o\u0301ðf", 210);
    freq.put("o\u0301ðg", 53);
    freq.put("o\u0301ð ", 473);
    freq.put("o\u0308fð", 390);
    freq.put("Z", 178);
    freq.put("iqu", 44);
    freq.put("fsi\u0301", 41);
    freq.put("fs ", 273);
    freq.put("\u0627\u0644", 93);
    freq.put("\u0441\u043a", 66);
    freq.put("\u0441\u0442", 78);
    freq.put("fsa", 40);
    freq.put("fsd", 78);
    freq.put("fse", 170);
    freq.put("fsf", 61);
    freq.put("fsh", 40);
    freq.put("Win", 83);
    freq.put("fsj", 32);
    freq.put("fsk", 78);
    freq.put("fsm", 103);
    freq.put("Læk", 37);
    freq.put("fss", 270);
    freq.put("fst", 735);
    freq.put("fsv", 103);
    freq.put("Gro\u0301", 29);
    freq.put("Græ", 154);
    freq.put("Gra\u0301", 30);
    freq.put("Gri\u0301", 106);
    freq.put("di ", 5025);
    freq.put("\u0634", 31);
    freq.put("tnu", 113);
    freq.put("eru", 4787);
    freq.put("nu\u0301ð", 42);
    freq.put("dil", 68);
    freq.put("dim", 46);
    freq.put("din", 1824);
    freq.put("dio", 43);
    freq.put("tns", 509);
    freq.put("dik", 52);
    freq.put("boð", 197);
    freq.put("die", 47);
    freq.put("dia", 76);
    freq.put("dic", 66);
    freq.put("dir", 2045);
    freq.put("dis", 659);
    freq.put("Gru", 62);
    freq.put(" Yo", 162);
    freq.put(" Ya", 33);
    freq.put(" Yf", 65);
    freq.put("Gre", 171);
    freq.put("Gra", 178);
    freq.put("Gro", 42);
    freq.put("uða\u0301", 45);
    freq.put("Gri", 130);
    freq.put("tne", 174);
    freq.put("tni", 1019);
    freq.put("bor", 2681);
    freq.put("bot", 163);
    freq.put("bol", 146);
    freq.put("bon", 36);
    freq.put("dið", 637);
    freq.put("bog", 60);
    freq.put("pve", 36);
    freq.put("bru\u0301", 361);
    freq.put("aye", 40);
    freq.put("aya", 40);
    freq.put("æn ", 110);
    freq.put("fl ", 57);
    freq.put("ul ", 138);
    freq.put("snæ", 42);
    freq.put("ood", 45);
    freq.put("Bei", 52);
    freq.put("Ben", 118);
    freq.put("Bel", 130);
    freq.put("ool", 48);
    freq.put("Bea", 37);
    freq.put("ook", 64);
    freq.put("Bey", 33);
    freq.put("maæ", 41);
    freq.put("Fjo\u0301", 52);
    freq.put("sny\u0301", 67);
    freq.put("snu\u0301", 516);
    freq.put("Fjo\u0308", 95);
    freq.put("Bet", 31);
    freq.put("fly", 309);
    freq.put("ænu", 227);
    freq.put("ænt", 81);
    freq.put("æns", 354);
    freq.put("ulr", 34);
    freq.put("uls", 171);
    freq.put("Hlu", 52);
    freq.put("flu", 781);
    freq.put("ay ", 120);
    freq.put("ult", 54);
    freq.put("ulu", 90);
    freq.put("æng", 118);
    freq.put("ænd", 99);
    freq.put("Hlj", 179);
    freq.put("flo", 1007);
    freq.put("kme", 201);
    freq.put("fla", 445);
    freq.put("ænn", 155);
    freq.put("ænm", 30);
    freq.put("ænl", 161);
    freq.put("fle", 884);
    freq.put("ulg", 31);
    freq.put("æni", 89);
    freq.put("ule", 1154);
    freq.put("sn ", 57);
    freq.put("ma ", 1535);
    freq.put("þin", 513);
    freq.put("nyr", 104);
    freq.put("nyt", 33);
    freq.put("yle", 30);
    freq.put("jo\u0308", 4211);
    freq.put("mas", 392);
    freq.put("sne", 753);
    freq.put("mat", 635);
    freq.put("sna", 202);
    freq.put("i\u0301os", 29);
    freq.put("Fja", 106);
    freq.put("snj", 58);
    freq.put("sni", 260);
    freq.put("mab", 539);
    freq.put("mae", 55);
    freq.put("i\u0301on", 35);
    freq.put("mag", 278);
    freq.put("maf", 42);
    freq.put("mah", 39);
    freq.put("mak", 53);
    freq.put("mam", 64);
    freq.put("mal", 260);
    freq.put("man", 3392);
    freq.put("flu\u0301", 30);
    freq.put("Edd", 90);
    freq.put("uly\u0301", 49);
    freq.put("flo\u0301", 302);
    freq.put("ulo\u0308", 48);
    freq.put("flo\u0308", 79);
    freq.put("q", 297);
    freq.put("Hli\u0301", 31);
    freq.put("uli\u0301", 46);
    freq.put("ny ", 83);
    freq.put("ula\u0301", 50);
    freq.put("flæ", 88);
    freq.put("lsf", 58);
    freq.put("lsd", 64);
    freq.put("lse", 116);
    freq.put("lsb", 58);
    freq.put("lsa", 85);
    freq.put("lsn", 115);
    freq.put("lsl", 62);
    freq.put("lsm", 64);
    freq.put("lsj", 39);
    freq.put("lsk", 731);
    freq.put("lsh", 178);
    freq.put("lsi", 379);
    freq.put("lsv", 167);
    freq.put("lst", 946);
    freq.put("lsu", 92);
    freq.put("lss", 277);
    freq.put("si\u0301ð", 895);
    freq.put("kk ", 327);
    freq.put(" ab", 43);
    freq.put(" af", 6312);
    freq.put(" ag", 34);
    freq.put(" ak", 50);
    freq.put(" al", 2511);
    freq.put(" am", 104);
    freq.put(" an", 1387);
    freq.put("gen", 859);
    freq.put(" ap", 172);
    freq.put(" ar", 311);
    freq.put(" as", 67);
    freq.put(" at", 450);
    freq.put("\u0434", 70);
    freq.put("ls ", 828);
    freq.put("kku", 899);
    freq.put("kkt", 826);
    freq.put("kkv", 35);
    freq.put("kks", 204);
    freq.put("kkr", 232);
    freq.put("Sha", 56);
    freq.put("kko", 71);
    freq.put("kkn", 107);
    freq.put("kki", 1529);
    freq.put("kkh", 101);
    freq.put("kkj", 140);
    freq.put("kke", 95);
    freq.put("Shi", 29);
    freq.put("kka", 637);
    freq.put("kkb", 29);
    freq.put("Vi\u0301n", 30);
    freq.put("Vi\u0301k", 49);
    freq.put("Vi\u0301e", 38);
    freq.put("xla", 43);
    freq.put("xlu", 43);
    freq.put("Vi\u0301s", 51);
    freq.put("lsa\u0301", 123);
    freq.put("lsi\u0301", 62);
    freq.put("Lun", 86);
    freq.put("Ken", 76);
    freq.put("Kel", 35);
    freq.put("Kef", 52);
    freq.put(" að", 9614);
    freq.put("Ket", 54);
    freq.put("Ker", 45);
    freq.put("Kep", 34);
    freq.put("G", 3894);
    freq.put("ory", 62);
    freq.put("orv", 93);
    freq.put("so\u0301t", 79);
    freq.put("ort", 719);
    freq.put("oru", 1072);
    freq.put("orr", 707);
    freq.put("ors", 867);
    freq.put("kko\u0301", 35);
    freq.put("orn", 1435);
    freq.put("oro", 81);
    freq.put("orl", 173);
    freq.put("orm", 710);
    freq.put("ork", 465);
    freq.put("so\u0301k", 506);
    freq.put("ori", 386);
    freq.put("orf", 203);
    freq.put("org", 2899);
    freq.put("ord", 318);
    freq.put("ore", 423);
    freq.put("orb", 110);
    freq.put("orc", 31);
    freq.put("ora", 164);
    freq.put("App", 83);
    freq.put("ðo\u0308", 84);
    freq.put("Vi\u0301ð", 50);
    freq.put("lay", 48);
    freq.put("ri\u0301r", 32);
    freq.put("ri\u0301s", 1547);
    freq.put("ri\u0301v", 32);
    freq.put("ri\u0301t", 76);
    freq.put("ri\u0301u", 241);
    freq.put("ri\u0301b", 73);
    freq.put("ri\u0301a", 168);
    freq.put("ri\u0301f", 39);
    freq.put("ri\u0301k", 2512);
    freq.put("ri\u0301h", 63);
    freq.put("ri\u0301n", 121);
    freq.put("Ti\u0301m", 60);
    freq.put("ri\u0301l", 176);
    freq.put("ri\u0301m", 339);
    freq.put("Þve", 45);
    freq.put("Dæ", 71);
    freq.put("Dy\u0301", 44);
    freq.put("Do\u0308", 29);
    freq.put("Do\u0301", 65);
    freq.put("nu\u0301s", 141);
    freq.put("ri\u0301 ", 42);
    freq.put("nu\u0301p", 46);
    freq.put("y\u0301ðr", 52);
    freq.put("uðk", 47);
    freq.put("uði", 226);
    freq.put("uðf", 78);
    freq.put("u\u0301um", 39);
    freq.put("ri\u0301o\u0301", 57);
    freq.put("ri\u0301ð", 409);
    freq.put("e\u0301u ", 77);
    freq.put("ør", 44);
    freq.put("\u30a2 ", 30);
    freq.put("Do", 199);
    freq.put("Dj", 72);
    freq.put("Di", 273);
    freq.put("De", 344);
    freq.put("Da", 796);
    freq.put("2", 107);
    freq.put("Dy", 59);
    freq.put("Du", 121);
    freq.put("Dr", 201);
    freq.put("uðv", 232);
    freq.put("uðu", 1637);
    freq.put("D ", 98);
    freq.put("uðs", 298);
    freq.put("nu\u0301l", 72);
    freq.put("ge ", 230);
    freq.put("li\u0301 ", 172);
    freq.put("We", 159);
    freq.put("a\u0301be", 37);
    freq.put("Wa", 265);
    freq.put("Wo", 95);
    freq.put("Wi", 310);
    freq.put("Wh", 42);
    freq.put("\u0430", 337);
    freq.put("a\u0301br", 30);
    freq.put("a\u0301by", 43);
    freq.put("pti", 394);
    freq.put("ges", 57);
    freq.put("ger", 1807);
    freq.put("iðb", 270);
    freq.put("ju\u0301", 991);
    freq.put("get", 826);
    freq.put("tuð", 583);
    freq.put("gey", 329);
    freq.put("li\u0301s", 172);
    freq.put("li\u0301t", 407);
    freq.put("li\u0301u", 494);
    freq.put("jo\u0301", 9027);
    freq.put("geb", 47);
    freq.put("li\u0301k", 1027);
    freq.put("geg", 382);
    freq.put("gef", 1039);
    freq.put("li\u0301n", 354);
    freq.put("gek", 42);
    freq.put("li\u0301a", 90);
    freq.put("gei", 373);
    freq.put("ja\u0301", 2743);
    freq.put("li\u0301f", 935);
    freq.put("gel", 153);
    freq.put("W ", 56);
    freq.put("æsi", 41);
    freq.put("æsk", 45);
    freq.put("æsl", 32);
    freq.put("o\u0301", 30363);
    freq.put("æst", 554);
    freq.put("tæp", 54);
    freq.put("tu ", 1914);
    freq.put("j ", 69);
    freq.put("uts", 66);
    freq.put("ai\u0301n", 58);
    freq.put("a\u0301bo\u0301", 66);
    freq.put("geð", 49);
    freq.put("li\u0301ð", 255);
    freq.put("ju", 3468);
    freq.put("tur", 6286);
    freq.put("tus", 346);
    freq.put("tut", 290);
    freq.put("ai\u0301d", 31);
    freq.put("tuh", 68);
    freq.put("jo", 90);
    freq.put("tul", 115);
    freq.put("ji", 208);
    freq.put("tun", 2035);
    freq.put("je", 151);
    freq.put("tub", 54);
    freq.put("tud", 78);
    freq.put("ja", 12542);
    freq.put("tuf", 48);
    freq.put("tug", 285);
    freq.put("tuk", 92);
    freq.put("dkn", 291);
    freq.put("Pe\u0301t", 113);
    freq.put("tum", 1349);
    freq.put("pi\u0301r", 83);
    freq.put("iðe", 79);
    freq.put("imo", 50);
    freq.put("pað", 131);
    freq.put("Ty", 102);
    freq.put("E\u0301", 51);
    freq.put(" bl", 752);
    freq.put("nty\u0301", 78);
    freq.put("pap", 68);
    freq.put("par", 415);
    freq.put("pas", 115);
    freq.put("pat", 41);
    freq.put("pav", 105);
    freq.put("y\u0301ði", 302);
    freq.put("pac", 29);
    freq.put("pad", 30);
    freq.put("paf", 53);
    freq.put("æl ", 48);
    freq.put("pak", 38);
    freq.put("pal", 112);
    freq.put("nto\u0301", 67);
    freq.put("pan", 400);
    freq.put("nac", 33);
    freq.put(" br", 1739);
    freq.put("ois", 44);
    freq.put("iðl", 242);
    freq.put("ælu", 92);
    freq.put("ælt", 61);
    freq.put("æli", 334);
    freq.put("æll", 56);
    freq.put("æla", 272);
    freq.put("æld", 77);
    freq.put("ro\u0308g", 86);
    freq.put("ro\u0308f", 82);
    freq.put("ro\u0308k", 168);
    freq.put("ro\u0308n", 643);
    freq.put("þor", 186);
    freq.put("ro\u0308l", 81);
    freq.put("ro\u0308s", 68);
    freq.put("mo ", 39);
    freq.put("i\u0301m ", 33);
    freq.put("Neð", 45);
    freq.put("u\u0301n ", 1473);
    freq.put("kmo\u0308", 30);
    freq.put("Með", 113);
    freq.put("i\u0301my", 31);
    freq.put("\u03c9", 34);
    freq.put("Sjo\u0301", 78);
    freq.put("Sjo\u0308", 30);
    freq.put("i\u0301ms", 207);
    freq.put("o\u0301ba", 44);
    freq.put("i\u0301mi", 124);
    freq.put("mon", 182);
    freq.put("o\u0301be", 269);
    freq.put("i\u0301me", 53);
    freq.put("Sja\u0301", 155);
    freq.put("i\u0301ma", 1376);
    freq.put("Upp", 182);
    freq.put("u\u0301na", 560);
    freq.put("u\u0301ni", 599);
    freq.put("u\u0301nn", 35);
    freq.put("km2", 99);
    freq.put("u\u0301nu", 54);
    freq.put("Ju\u0301l", 36);
    freq.put("ho\u0308l", 107);
    freq.put("ho\u0308n", 281);
    freq.put("Nef", 35);
    freq.put("ho\u0308g", 61);
    freq.put("ho\u0308f", 1628);
    freq.put("ptu", 116);
    freq.put("ro\u0308ð", 352);
    freq.put("New", 193);
    freq.put("Net", 32);
    freq.put("ho\u0308r", 44);
    freq.put("Nes", 42);
    freq.put("Med", 40);
    freq.put(" ch", 40);
    freq.put(" co", 79);
    freq.put("kma", 92);
    freq.put(" cm", 36);
    freq.put("Mel", 83);
    freq.put("Men", 138);
    freq.put("kmi", 111);
    freq.put("Met", 61);
    freq.put("Mes", 43);
    freq.put("Mer", 93);
    freq.put("Mex", 54);
    freq.put("kmy", 402);
    freq.put("O\u0301ly", 64);
    freq.put("\u0447", 38);
    freq.put("fa\u0301s", 32);
    freq.put("fa\u0301n", 134);
    freq.put("Dra", 80);
    freq.put("Dre", 57);
    freq.put("O\u0301la", 271);
    freq.put("km ", 337);
    freq.put("u\u0301ni\u0301", 148);
    freq.put("xna", 31);
    freq.put("xne", 38);
    freq.put(" I\u0301b", 166);
    freq.put(" I\u0301t", 191);
    freq.put(" I\u0301r", 171);
    freq.put(" I\u0301s", 2273);
    freq.put("svo", 582);
    freq.put("O\u0301ð", 61);
    freq.put("na ", 7656);
    freq.put("dvi", 51);
    freq.put(" I\u0301 ", 611);
    freq.put("uli", 154);
    freq.put("svi", 516);
    freq.put("dve", 148);
    freq.put("u\u0301si\u0301", 34);
    freq.put("dva", 88);
    freq.put("sva", 378);
    freq.put("by\u0301r", 47);
    freq.put("Dy\u0301r", 35);
    freq.put("Ap", 140);
    freq.put("u\u0301s ", 380);
    freq.put(" I\u0301þ", 49);
    freq.put("by\u0301l", 253);
    freq.put("o\u0301he", 37);
    freq.put("po\u0301l", 144);
    freq.put("O\u0301s", 82);
    freq.put("O\u0301m", 42);
    freq.put("O\u0301l", 368);
    freq.put("po\u0301s", 50);
    freq.put("O\u0301d", 30);
    freq.put("u\u0301st", 268);
    freq.put("u\u0301su", 332);
    freq.put("u\u0301ss", 498);
    freq.put("u\u0301sd", 34);
    freq.put("u\u0301se", 29);
    freq.put("u", 132172);
    freq.put("u\u0301sa", 165);
    freq.put("u\u0301sl", 41);
    freq.put("u\u0301sn", 29);
    freq.put("u\u0301si", 225);
    freq.put("u\u0301sk", 37);
    freq.put("Van", 47);
    freq.put("Val", 271);
    freq.put("gv", 803);
    freq.put("iu ", 46);
    freq.put("ni\u0301a", 80);
    freq.put("e\u0301k ", 30);
    freq.put("Var", 102);
    freq.put("Vat", 207);
    freq.put("hy ", 40);
    freq.put("aba\u0301", 34);
    freq.put("þy\u0301t", 31);
    freq.put("rre\u0301", 62);
    freq.put("abæ", 120);
    freq.put("abi\u0301", 243);
    freq.put("abo\u0301", 285);
    freq.put("\u0438", 226);
    freq.put("abu\u0301", 61);
    freq.put("ium", 116);
    freq.put("ggð", 568);
    freq.put("got", 57);
    freq.put("e\u0301kk", 137);
    freq.put("ius", 175);
    freq.put("vi\u0301þ", 176);
    freq.put("gf", 407);
    freq.put("hyl", 69);
    freq.put("du\u0301n", 44);
    freq.put("hyr", 120);
    freq.put("SI ", 80);
    freq.put("heg", 81);
    freq.put("Gi\u0301n", 44);
    freq.put("gg ", 105);
    freq.put("Gi\u0301s", 50);
    freq.put("aba", 247);
    freq.put("abb", 91);
    freq.put("gl", 2693);
    freq.put("abe", 147);
    freq.put("þy\u0301ð", 375);
    freq.put("abi", 501);
    freq.put("abj", 35);
    freq.put("abl", 134);
    freq.put("abo", 208);
    freq.put("\u0430 ", 49);
    freq.put("abu", 41);
    freq.put("aby", 70);
    freq.put("ggu", 598);
    freq.put("ggt", 85);
    freq.put("ggv", 60);
    freq.put("ggs", 75);
    freq.put("K", 4574);
    freq.put("gge", 45);
    freq.put("ggd", 40);
    freq.put("akv", 56);
    freq.put("gga", 155);
    freq.put("ggl", 31);
    freq.put("ggi", 554);
    freq.put("ggj", 980);
    freq.put("a\u0300", 32);
    freq.put("ðsm", 81);
    freq.put("ky\u0301r", 177);
    freq.put("akt", 192);
    freq.put("ky\u0301j", 35);
    freq.put("eyg", 150);
    freq.put("eyf", 333);
    freq.put("eyi", 44);
    freq.put("eyk", 1077);
    freq.put("eyj", 1341);
    freq.put("eym", 192);
    freq.put("two", 32);
    freq.put("eyn", 309);
    freq.put("eyp", 145);
    freq.put("eys", 419);
    freq.put("eyr", 688);
    freq.put("eyt", 859);
    freq.put("de ", 373);
    freq.put("gð", 1600);
    freq.put("ryð", 51);
    freq.put("aæt", 246);
    freq.put("ky\u0301 ", 32);
    freq.put("ey ", 517);
    freq.put("der", 294);
    freq.put("des", 336);
    freq.put("det", 32);
    freq.put("lks", 187);
    freq.put("dei", 506);
    freq.put("del", 110);
    freq.put("dem", 107);
    freq.put("den", 250);
    freq.put("dea", 33);
    freq.put("deg", 113);
    freq.put("pro", 73);
    freq.put("ryn", 55);
    freq.put("ryl", 29);
    freq.put("ryk", 114);
    freq.put("ryg", 260);
    freq.put("ryd", 53);
    freq.put("eyð", 283);
    freq.put("hf ", 56);
    freq.put("rys", 58);
    freq.put("Tyr", 85);
    freq.put("Don", 53);
    freq.put("cs ", 45);
    freq.put("ry ", 262);
    freq.put("jo\u0301 ", 290);
    freq.put("ok ", 125);
    freq.put("ðar", 3764);
    freq.put("ðas", 709);
    freq.put("ðat", 38);
    freq.put("ðau", 278);
    freq.put("ðav", 103);
    freq.put("uðm", 148);
    freq.put("ðab", 236);
    freq.put("bæð", 272);
    freq.put("ðad", 86);
    freq.put("ðae", 34);
    freq.put("ðaf", 336);
    freq.put("ðag", 69);
    freq.put("ðah", 156);
    freq.put("ðak", 71);
    freq.put("ðal", 1210);
    freq.put("ðam", 182);
    freq.put("ðan", 1528);
    freq.put("sbo\u0301", 49);
    freq.put("jo\u0301f", 63);
    freq.put("lbu\u0301", 63);
    freq.put("Bar", 205);
    freq.put("Bas", 64);
    freq.put("mmu\u0301", 58);
    freq.put("jo\u0301l", 491);
    freq.put("jo\u0301m", 1532);
    freq.put("jo\u0301n", 1264);
    freq.put("jo\u0301t", 508);
    freq.put("sbæ", 68);
    freq.put("jo\u0301r", 2056);
    freq.put("jo\u0301s", 611);
    freq.put("Ban", 640);
    freq.put("o\u0301di\u0301", 33);
    freq.put("Bal", 91);
    freq.put("mma\u0301", 75);
    freq.put("Bak", 55);
    freq.put("u\u0301li\u0301", 196);
    freq.put("ða ", 7924);
    freq.put("Eð", 29);
    freq.put("mm ", 233);
    freq.put("ðað", 227);
    freq.put("i\u0301ka", 550);
    freq.put("bæk", 87);
    freq.put("bæj", 204);
    freq.put("bæi", 95);
    freq.put("i\u0301kl", 107);
    freq.put("E ", 99);
    freq.put("ðaþ", 30);
    freq.put("bær", 563);
    freq.put("i\u0301ku", 987);
    freq.put("i\u0301kt", 208);
    freq.put("i\u0301ks", 66);
    freq.put("i\u0301kr", 40);
    freq.put("bæt", 285);
    freq.put("sbr", 123);
    freq.put("oid", 32);
    freq.put("mmy", 31);
    freq.put("sbu", 68);
    freq.put("mmu", 172);
    freq.put("mmt", 327);
    freq.put("sby", 61);
    freq.put("\u044f", 55);
    freq.put("uho\u0308", 65);
    freq.put("mmo", 32);
    freq.put("sba", 82);
    freq.put("Und", 51);
    freq.put("Ung", 70);
    freq.put("mme", 102);
    freq.put("Uni", 181);
    freq.put("sbi", 51);
    freq.put("mma", 212);
    freq.put("sbo", 107);
    freq.put("sbl", 34);
    freq.put("Em", 79);
    freq.put("El", 310);
    freq.put("bæ ", 192);
    freq.put("u\u0301la", 181);
    freq.put("Ek", 54);
    freq.put("i\u0301k ", 916);
    freq.put("i\u0301nu", 752);
    freq.put("u\u0301ll", 94);
    freq.put("Eg", 213);
    freq.put("Ef", 192);
    freq.put("u\u0301li", 36);
    freq.put("u\u0301lk", 110);
    freq.put("u\u0301lu", 109);
    freq.put("Ey", 536);
    freq.put("Ex", 43);
    freq.put("Eu", 56);
    freq.put("Et", 30);
    freq.put("Ev", 632);
    freq.put("Es", 92);
    freq.put("Er", 232);
    freq.put("vi\u0301n", 173);
    freq.put("ðss", 159);
    freq.put("zi", 76);
    freq.put(" el", 620);
    freq.put(" em", 145);
    freq.put(" en", 4649);
    freq.put(" eh", 31);
    freq.put(" ei", 5897);
    freq.put("kon", 1246);
    freq.put(" ef", 2947);
    freq.put(" eg", 82);
    freq.put("Ho\u0301l", 152);
    freq.put(" ey", 827);
    freq.put("gþ", 48);
    freq.put(" et", 46);
    freq.put("kop", 46);
    freq.put(" ev", 138);
    freq.put("kor", 407);
    freq.put("kot", 277);
    freq.put(" er", 28966);
    freq.put("I\u0301", 3558);
    freq.put("gu\u0301", 251);
    freq.put("y\u0301ðv", 179);
    freq.put("lug", 511);
    freq.put("ka\u0301", 825);
    freq.put("b", 27005);
    freq.put("kæ", 150);
    freq.put("ko ", 34);
    freq.put("\u0431\u043b", 47);
    freq.put(" e ", 310);
    freq.put("ki\u0301", 733);
    freq.put("ko\u0301", 2090);
    freq.put("ko\u0308", 623);
    freq.put("ku\u0301", 380);
    freq.put("ky\u0301", 317);
    freq.put("zz", 45);
    freq.put("vi\u0301t", 367);
    freq.put("ðst", 779);
    freq.put("pa ", 507);
    freq.put("k ", 6366);
    freq.put("ynn", 253);
    freq.put("Kir", 145);
    freq.put("y\u0301ðu", 113);
    freq.put("Kin", 55);
    freq.put("koð", 120);
    freq.put(" eð", 5981);
    freq.put("Atl", 210);
    freq.put("Slo\u0301", 37);
    freq.put("Sli\u0301", 40);
    freq.put("Sle\u0301", 43);
    freq.put("kb", 82);
    freq.put("ka", 13629);
    freq.put("kg", 80);
    freq.put("kf", 253);
    freq.put("ke", 4269);
    freq.put("kd", 187);
    freq.put("kk", 5618);
    freq.put("kj", 4569);
    freq.put("ki", 11936);
    freq.put("kh", 360);
    freq.put("ko", 4051);
    freq.put("kn", 2921);
    freq.put("km", 1291);
    freq.put("kl", 2343);
    freq.put("ks", 1875);
    freq.put("kr", 3178);
    freq.put("kv", 2762);
    freq.put("ku", 9598);
    freq.put("kt", 2936);
    freq.put("ky", 1074);
    freq.put(" Bæ", 200);
    freq.put(" Ba\u0301", 77);
    freq.put(" Bi\u0301", 44);
    freq.put("re\u0301t", 867);
    freq.put("re\u0301s", 59);
    freq.put(" Bo\u0308", 36);
    freq.put(" Bo\u0301", 133);
    freq.put("Te\u0301k", 31);
    freq.put("re\u0301f", 119);
    freq.put(" Bu\u0301", 143);
    freq.put("þot", 31);
    freq.put("ki\u0301n", 122);
    freq.put("i\u0301na", 797);
    freq.put("tæð", 489);
    freq.put("re\u0301 ", 89);
    freq.put("þol", 52);
    freq.put(" Be", 741);
    freq.put(" Ba", 1274);
    freq.put(" Bl", 363);
    freq.put(" Bo", 816);
    freq.put(" Bi", 297);
    freq.put("re\u0301ð", 35);
    freq.put(" Bj", 353);
    freq.put(" Bu", 149);
    freq.put("ik ", 458);
    freq.put(" Br", 1093);
    freq.put(" By", 64);
    freq.put("Þjo\u0301", 274);
    freq.put("þo\u0301r", 44);
    freq.put("þo\u0301t", 75);
    freq.put("\u0430\u043d", 42);
    freq.put("þo\u0301l", 58);
    freq.put("\u03ba", 62);
    freq.put("iks", 474);
    freq.put("ikr", 111);
    freq.put(" B ", 65);
    freq.put("iku", 599);
    freq.put("ikt", 88);
    freq.put("\u044b", 69);
    freq.put("ika", 773);
    freq.put("\u0430\u0441", 31);
    freq.put("ikf", 51);
    freq.put("ike", 140);
    freq.put("kte", 85);
    freq.put("ikk", 205);
    freq.put("ikj", 227);
    freq.put("iki", 1110);
    freq.put("ikh", 77);
    freq.put("iko", 33);
    freq.put("ikn", 392);
    freq.put("ikm", 465);
    freq.put("ikl", 338);
    freq.put("þo\u0301 ", 313);
    freq.put("lbr", 155);
    freq.put("ga ", 4778);
    freq.put("a\u0301fe", 61);
    freq.put("le\u0301n", 49);
    freq.put("a\u0301fa", 149);
    freq.put("le\u0301k", 31);
    freq.put("le\u0301t", 224);
    freq.put("ran", 2332);
    freq.put("fu ", 237);
    freq.put("le\u0301s", 58);
    freq.put("a\u0301fu", 225);
    freq.put("a\u0301fr", 66);
    freq.put("dgæ", 30);
    freq.put("gav", 94);
    freq.put("gau", 40);
    freq.put("gat", 286);
    freq.put("gas", 712);
    freq.put("gar", 5221);
    freq.put("gap", 30);
    freq.put("gan", 1061);
    freq.put("gam", 445);
    freq.put("gal", 380);
    freq.put("gak", 142);
    freq.put("gah", 95);
    freq.put("gag", 255);
    freq.put("gaf", 494);
    freq.put("gad", 130);
    freq.put("gab", 121);
    freq.put("gaa", 32);
    freq.put("lba", 94);
    freq.put("fur", 2375);
    freq.put("fus", 91);
    freq.put("fuf", 32);
    freq.put("fug", 341);
    freq.put("fub", 43);
    freq.put("fun", 902);
    freq.put("lbe", 135);
    freq.put("ful", 355);
    freq.put("fum", 292);
    freq.put("fuk", 55);
    freq.put("\u0421", 41);
    freq.put("i\u0301mu", 159);
    freq.put("mor", 175);
    freq.put("gaþ", 60);
    freq.put("dge", 78);
    freq.put("syk", 82);
    freq.put("gao\u0308", 31);
    freq.put("cea", 68);
    freq.put("dgo", 49);
    freq.put("gað", 150);
    freq.put("sys", 40);
    freq.put("mou", 30);
    freq.put("\u043e\u0431\u043b", 31);
    freq.put("fuð", 815);
    freq.put("ew ", 192);
    freq.put("y", 26307);
    freq.put("ldb", 66);
    freq.put("lda", 1630);
    freq.put("ldg", 92);
    freq.put("ldf", 77);
    freq.put("lde", 90);
    freq.put("ldk", 29);
    freq.put("ldi", 1971);
    freq.put("mol", 39);
    freq.put("ldn", 83);
    freq.put("bi ", 52);
    freq.put("ldl", 84);
    freq.put("lds", 601);
    freq.put("ldr", 327);
    freq.put("ldv", 44);
    freq.put("ldu", 1350);
    freq.put("A\u0301 ", 621);
    freq.put("rgr", 329);
    freq.put("rgs", 155);
    freq.put("cus", 90);
    freq.put("rgu", 338);
    freq.put("rgv", 83);
    freq.put("ðþ", 39);
    freq.put("rga", 1056);
    freq.put("ða\u0301", 72);
    freq.put("rge", 305);
    freq.put("rgf", 73);
    freq.put("rgi", 863);
    freq.put("rgj", 52);
    freq.put("cul", 53);
    freq.put("rgl", 50);
    freq.put("bin", 115);
    freq.put("ufe\u0301", 80);
    freq.put("bil", 637);
    freq.put("ld ", 1392);
    freq.put("bik", 50);
    freq.put("bif", 37);
    freq.put("bib", 31);
    freq.put("Dia", 31);
    freq.put("mþy", 72);
    freq.put("bit", 57);
    freq.put("bir", 182);
    freq.put("bis", 218);
    freq.put("Dis", 97);
    freq.put("A\u0301g", 72);
    freq.put("A\u0301l", 120);
    freq.put("rg ", 1633);
    freq.put("A\u0301s", 264);
    freq.put("A\u0301r", 416);
    freq.put(" læ", 234);
    freq.put("ldo\u0301", 125);
    freq.put("y\u0301tt", 104);
    freq.put("ldy\u0301", 49);
    freq.put("rgð", 52);
    freq.put("ðs", 3396);
    freq.put("ðp", 30);
    freq.put("ðv", 1344);
    freq.put("ðt", 171);
    freq.put("ðu", 11785);
    freq.put("per", 484);
    freq.put("pes", 31);
    freq.put("ðb", 974);
    freq.put("rga\u0301", 37);
    freq.put("pen", 326);
    freq.put("ða", 17064);
    freq.put("ðf", 1240);
    freq.put("ðg", 495);
    freq.put("ðd", 125);
    freq.put("ðe", 430);
    freq.put("ðj", 880);
    freq.put("ðk", 295);
    freq.put("ðh", 571);
    freq.put("ði", 13616);
    freq.put("ðn", 620);
    freq.put("rgi\u0301", 51);
    freq.put("ðl", 1590);
    freq.put("ðm", 400);
    freq.put("ufi", 29);
    freq.put("ufj", 77);
    freq.put("ppn", 424);
    freq.put("ufo", 48);
    freq.put("ufa", 76);
    freq.put("Bor", 456);
    freq.put("Bos", 43);
    freq.put("Bot", 40);
    freq.put("ufe", 30);
    freq.put("O", 1245);
    freq.put("ufy", 58);
    freq.put("sið", 390);
    freq.put("Bol", 62);
    freq.put("Boo", 38);
    freq.put("ufr", 151);
    freq.put(" O\u0308n", 69);
    freq.put("uft", 32);
    freq.put("ufu", 94);
    freq.put("\u03c2 ", 149);
    freq.put("a\u0308", 93);
    freq.put("A\u0301ð", 37);
    freq.put("ð ", 40406);
    freq.put("usn", 74);
    freq.put("pe ", 53);
    freq.put("Hun", 69);
    freq.put("nsh", 91);
    freq.put("nsi", 284);
    freq.put("nsj", 37);
    freq.put("nsk", 4454);
    freq.put("nsl", 375);
    freq.put("nsm", 56);
    freq.put("nsn", 109);
    freq.put("nso", 41);
    freq.put("nsa", 227);
    freq.put("nsb", 64);
    freq.put("nsd", 160);
    freq.put("nse", 233);
    freq.put("nsf", 108);
    freq.put("nsg", 31);
    freq.put("nsy", 38);
    freq.put("nsp", 46);
    freq.put("nss", 607);
    freq.put("nst", 1135);
    freq.put("nsu", 61);
    freq.put("o\u0301f ", 138);
    freq.put("Snæ", 134);
    freq.put("mke", 47);
    freq.put(" go\u0301", 105);
    freq.put("mki", 55);
    freq.put(" gæ", 107);
    freq.put("go\u0301 ", 40);
    freq.put(" ga\u0301", 35);
    freq.put("uss", 141);
    freq.put(" gi\u0301", 129);
    freq.put("mky", 51);
    freq.put(" R ", 43);
    freq.put("ns ", 5692);
    freq.put("o\u0301fu", 99);
    freq.put("o\u0301fr", 36);
    freq.put("o\u0301fs", 262);
    freq.put("sde", 55);
    freq.put("o\u0301fl", 62);
    freq.put("Flj", 91);
    freq.put("sda", 221);
    freq.put("Flo", 84);
    freq.put("o\u0301fi", 133);
    freq.put("Fla", 98);
    freq.put("o\u0301fe", 115);
    freq.put("Fle", 86);
    freq.put("o\u0301fa", 126);
    freq.put("go\u0301l", 117);
    freq.put("ap", 1426);
    freq.put("nsi\u0301", 40);
    freq.put("lyr", 91);
    freq.put("lys", 63);
    freq.put("aðr", 337);
    freq.put("aðs", 858);
    freq.put("aðv", 31);
    freq.put("nsæ", 244);
    freq.put("aðu", 2529);
    freq.put("Jo\u0308k", 86);
    freq.put("aðh", 97);
    freq.put("aði", 1858);
    freq.put("aðn", 42);
    freq.put("nsy\u0301", 72);
    freq.put("aðl", 109);
    freq.put("lym", 116);
    freq.put("lyn", 76);
    freq.put("aða", 2137);
    freq.put("aðf", 330);
    freq.put("ðo\u0308l", 79);
    freq.put("as", 9693);
    freq.put("aðe", 248);
    freq.put("Mas", 67);
    freq.put(" gu", 299);
    freq.put(" gr", 1982);
    freq.put("Mat", 90);
    freq.put("Sno", 80);
    freq.put(" gy", 80);
    freq.put("Mac", 73);
    freq.put(" ge", 3864);
    freq.put("Mad", 42);
    freq.put("Mag", 199);
    freq.put(" ga", 1049);
    freq.put("Mai", 40);
    freq.put(" go", 395);
    freq.put(" gl", 267);
    freq.put(" gj", 246);
    freq.put("Mal", 118);
    freq.put(" gi", 256);
    freq.put("sdo\u0301", 359);
    freq.put("sdy\u0301", 41);
    freq.put("Flo\u0301", 77);
    freq.put("Meg", 45);
    freq.put("sdæ", 76);
    freq.put("ly ", 105);
    freq.put("að ", 14115);
    freq.put("go\u0301ð", 87);
    freq.put(" b", 11739);
    freq.put(" c", 312);
    freq.put(" a", 22647);
    freq.put(" f", 25096);
    freq.put(" g", 9131);
    freq.put(" d", 4603);
    freq.put(" e", 51762);
    freq.put(" j", 2491);
    freq.put(" k", 10596);
    freq.put(" h", 25667);
    freq.put(" i", 1873);
    freq.put(" n", 9875);
    freq.put(" o", 24158);
    freq.put(" l", 13188);
    freq.put(" m", 17205);
    freq.put(" r", 7093);
    freq.put(" s", 52785);
    freq.put(" p", 2352);
    freq.put(" v", 22667);
    freq.put(" w", 71);
    freq.put(" t", 16530);
    freq.put(" u", 8441);
    freq.put(" z", 29);
    freq.put(" x", 58);
    freq.put(" y", 1803);
    freq.put(" B", 5951);
    freq.put(" C", 2201);
    freq.put(" A", 5808);
    freq.put(" F", 4383);
    freq.put(" G", 3869);
    freq.put(" D", 2495);
    freq.put(" E", 3934);
    freq.put(" J", 2203);
    freq.put(" K", 4567);
    freq.put(" H", 8585);
    freq.put(" I", 1555);
    freq.put(" N", 3667);
    freq.put(" O", 1188);
    freq.put("Orð", 204);
    freq.put(" M", 5293);
    freq.put(" R", 3756);
    freq.put(" S", 11508);
    freq.put(" P", 2823);
    freq.put(" Q", 135);
    freq.put(" V", 3197);
    freq.put(" W", 981);
    freq.put(" T", 3273);
    freq.put(" U", 1070);
    freq.put(" Z", 177);
    freq.put(" X", 119);
    freq.put(" Y", 365);
    freq.put("ðib", 80);
    freq.put("o\u0308ng", 1010);
    freq.put("o\u0308nd", 1211);
    freq.put("o\u0308nn", 762);
    freq.put("o\u0308nk", 81);
    freq.put("o\u0308nt", 102);
    freq.put("o\u0308ns", 279);
    freq.put("se\u0301 ", 343);
    freq.put("næð", 35);
    freq.put(" a\u0301", 19136);
    freq.put(" æ", 1194);
    freq.put(" e\u0301", 48);
    freq.put(" i\u0301", 21823);
    freq.put(" o\u0301", 1123);
    freq.put(" o\u0308", 1771);
    freq.put(" u\u0301", 4082);
    freq.put(" þ", 16844);
    freq.put(" y\u0301", 438);
    freq.put(" A\u0301", 1653);
    freq.put(" Æ", 142);
    freq.put("Þa\u0301t", 29);
    freq.put(" E\u0301", 49);
    freq.put(" I\u0301", 3550);
    freq.put("\u05d5", 29);
    freq.put(" O\u0301", 667);
    freq.put(" O\u0308", 387);
    freq.put("Ork", 38);
    freq.put(" U\u0301", 293);
    freq.put("Org", 32);
    freq.put(" Þ", 3878);
    freq.put(" Y\u0301", 38);
    freq.put("ock", 125);
    freq.put("næg", 56);
    freq.put("næf", 123);
    freq.put("næm", 31);
    freq.put("næt", 37);
    freq.put("næs", 243);
    freq.put("nær", 514);
    freq.put(" Do", 188);
    freq.put("Vet", 35);
    freq.put("Ver", 208);
    freq.put(" Dj", 72);
    freq.put(" Di", 273);
    freq.put("i\u0301fa", 134);
    freq.put(" De", 342);
    freq.put(" Da", 794);
    freq.put("Veg", 63);
    freq.put("ii ", 75);
    freq.put(" Dy", 59);
    freq.put("Ven", 79);
    freq.put(" Du", 120);
    freq.put(" Dr", 200);
    freq.put("Vei", 40);
    freq.put("cha", 138);
    freq.put("Fr", 1134);
    freq.put("che", 262);
    freq.put("chi", 127);
    freq.put("afæ", 30);
    freq.put("chn", 39);
    freq.put("cho", 60);
    freq.put("Fa", 299);
    freq.put("cht", 62);
    freq.put("chu", 59);
    freq.put("chw", 37);
    freq.put("Fi", 347);
    freq.put("Fj", 284);
    freq.put("Fl", 550);
    freq.put("afo\u0301", 34);
    freq.put("i\u0301fl", 51);
    freq.put(" D ", 30);
    freq.put("ch ", 237);
    freq.put("do\u0308n", 95);
    freq.put("do\u0308k", 34);
    freq.put("f", 81003);
    freq.put("do\u0308g", 48);
    freq.put("i\u0301fr", 77);
    freq.put("F ", 112);
    freq.put("i\u0301fs", 158);
    freq.put("a\u0301an", 33);
    freq.put("i\u0301fv", 204);
    freq.put("Veð", 31);
    freq.put(" Dæ", 71);
    freq.put(" Dy\u0301", 44);
    freq.put(" Do\u0308", 29);
    freq.put(" Do\u0301", 65);
    freq.put("afl", 1145);
    freq.put("afm", 183);
    freq.put("afn", 2524);
    freq.put("afo", 148);
    freq.put("afh", 109);
    freq.put("afi", 1278);
    freq.put("afj", 658);
    freq.put("afk", 73);
    freq.put("Ya", 33);
    freq.put("afe", 261);
    freq.put("aff", 148);
    freq.put("afa", 1337);
    freq.put("afb", 140);
    freq.put("Yf", 66);
    freq.put(" Ið", 49);
    freq.put("afy", 94);
    freq.put("Fæ", 128);
    freq.put("aft", 662);
    freq.put("afu", 287);
    freq.put("Fi\u0301", 29);
    freq.put("afr", 1163);
    freq.put("afs", 676);
    freq.put("sis", 245);
    freq.put("act", 62);
    freq.put("o\u0301kr", 63);
    freq.put("af ", 5722);
    freq.put("da ", 2461);
    freq.put("eum", 32);
    freq.put("lg", 1902);
    freq.put("ld", 8186);
    freq.put("le", 15573);
    freq.put("lb", 662);
    freq.put("lc", 60);
    freq.put("tsh", 220);
    freq.put("la", 24339);
    freq.put("ln", 490);
    freq.put("lo", 2737);
    freq.put("ll", 11846);
    freq.put("lm", 1436);
    freq.put("lj", 3578);
    freq.put("lk", 1973);
    freq.put("lh", 740);
    freq.put("li", 12184);
    freq.put("lv", 1365);
    freq.put("lt", 2655);
    freq.put("lu", 9341);
    freq.put("lr", 408);
    freq.put("ls", 4614);
    freq.put("lp", 267);
    freq.put("tsv", 50);
    freq.put("o\u0301ka", 293);
    freq.put("tst", 183);
    freq.put("tsu", 54);
    freq.put("lz", 40);
    freq.put("tss", 149);
    freq.put("eus", 66);
    freq.put("ly", 1089);
    freq.put("dad", 43);
    freq.put("dae", 100);
    freq.put("daf", 226);
    freq.put("dag", 946);
    freq.put("dab", 91);
    freq.put("dal", 1432);
    freq.put("dam", 444);
    freq.put("dan", 878);
    freq.put("dah", 92);
    freq.put("dak", 98);
    freq.put("dat", 82);
    freq.put("dau", 223);
    freq.put("dav", 102);
    freq.put("dap", 31);
    freq.put("dar", 2968);
    freq.put("das", 501);
    freq.put("jo\u0308f", 126);
    freq.put("l ", 12639);
    freq.put("o\u0301ki", 198);
    freq.put("eu ", 59);
    freq.put("ts ", 398);
    freq.put("lfe", 71);
    freq.put("lfa", 315);
    freq.put("lfb", 34);
    freq.put("lfl", 58);
    freq.put("lfo", 43);
    freq.put("agb", 56);
    freq.put("lfi", 167);
    freq.put("lfj", 68);
    freq.put("lfu", 334);
    freq.put("lft", 177);
    freq.put("lfv", 36);
    freq.put("lfs", 536);
    freq.put("lfr", 406);
    freq.put("læ", 985);
    freq.put("ilo\u0308", 36);
    freq.put("rey", 1506);
    freq.put("la\u0301", 981);
    freq.put("res", 811);
    freq.put("rep", 672);
    freq.put("li\u0301", 4068);
    freq.put("ret", 461);
    freq.put("reu", 56);
    freq.put("lo\u0308", 2699);
    freq.put("rek", 593);
    freq.put("rei", 2743);
    freq.put("ren", 1042);
    freq.put("lo\u0301", 1489);
    freq.put("rel", 158);
    freq.put("rem", 334);
    freq.put("lþ", 583);
    freq.put("rea", 127);
    freq.put("ref", 289);
    freq.put("reg", 939);
    freq.put("red", 93);
    freq.put("ree", 99);
    freq.put("lf ", 135);
    freq.put("qua", 30);
    freq.put("dað", 218);
    freq.put("qui", 57);
    freq.put("daþ", 31);
    freq.put("re ", 456);
    freq.put("og ", 20914);
    freq.put("ðey", 75);
    freq.put(" o\u0308f", 73);
    freq.put(" o\u0308k", 39);
    freq.put(" o\u0308l", 609);
    freq.put(" o\u0308n", 266);
    freq.put("nuv", 51);
    freq.put("ðen", 29);
    freq.put(" o\u0308r", 241);
    freq.put("ðei", 268);
    freq.put("mið", 1660);
    freq.put("ogu", 44);
    freq.put("ogs", 89);
    freq.put("ogr", 32);
    freq.put("ogl", 33);
    freq.put("ogn", 32);
    freq.put("ogi", 191);
    freq.put("udd", 31);
    freq.put("sfe\u0301", 34);
    freq.put("oge", 37);
    freq.put("ogg", 37);
    freq.put("udi", 40);
    freq.put("oga", 158);
    freq.put("nul", 144);
    freq.put("lim", 235);
    freq.put("Pap", 35);
    freq.put("Par", 152);
    freq.put("rðr", 296);
    freq.put("Pat", 43);
    freq.put("Pau", 49);
    freq.put("rðv", 334);
    freq.put("pgo\u0308", 32);
    freq.put("nuf", 123);
    freq.put("rðb", 53);
    freq.put("rðe", 35);
    freq.put("rðg", 39);
    freq.put("rðf", 294);
    freq.put("rði", 2526);
    freq.put("ben", 97);
    freq.put("Pak", 41);
    freq.put("Pal", 72);
    freq.put("rðl", 335);
    freq.put("Pan", 54);
    freq.put("mik", 821);
    freq.put("mil", 1646);
    freq.put("min", 1199);
    freq.put("mic", 43);
    freq.put(" o\u0308ð", 482);
    freq.put("mis", 788);
    freq.put("mir", 185);
    freq.put("mit", 132);
    freq.put(" \u03a0", 31);
    freq.put("sfy", 34);
    freq.put("sfr", 321);
    freq.put("sfo", 31);
    freq.put("sfl", 100);
    freq.put("sfj", 305);
    freq.put("sfi", 93);
    freq.put("sfe", 87);
    freq.put("sfa", 35);
    freq.put("mi ", 1234);
    freq.put("ao\u0308l", 43);
    freq.put("kst", 476);
    freq.put("ksv", 50);
    freq.put("kss", 123);
    freq.put("Mos", 92);
    freq.put("Mor", 172);
    freq.put(" O\u0301ð", 61);
    freq.put(" is", 51);
    freq.put("Mot", 32);
    freq.put("kse", 36);
    freq.put("ksf", 65);
    freq.put(" il", 75);
    freq.put("Mon", 128);
    freq.put(" in", 1466);
    freq.put("Mol", 36);
    freq.put("ksm", 107);
    freq.put("ksl", 35);
    freq.put("ksi", 136);
    freq.put("ksh", 75);
    freq.put("ksk", 82);
    freq.put("vro\u0301", 716);
    freq.put(" \u0420", 33);
    freq.put(" \u0421", 41);
    freq.put("o\u0308læ", 50);
    freq.put("ty\u0301r", 322);
    freq.put(" \u043e", 38);
    freq.put("þar", 1999);
    freq.put("þau", 382);
    freq.put("ks ", 435);
    freq.put(" i ", 55);
    freq.put("þak", 46);
    freq.put("þan", 673);
    freq.put(" \u041c", 32);
    freq.put("fa\u0301 ", 59);
    freq.put("o\u0308l ", 78);
    freq.put(" ið", 125);
    freq.put(" O\u0301s", 82);
    freq.put("dæ", 682);
    freq.put("ksa\u0301", 78);
    freq.put(" O\u0301l", 368);
    freq.put(" O\u0301m", 42);
    freq.put(" O\u0301d", 30);
    freq.put("o\u0308lm", 167);
    freq.put("o\u0308ll", 1141);
    freq.put("o\u0308ln", 31);
    freq.put("o\u0308lb", 96);
    freq.put("o\u0308ld", 1331);
    freq.put("o\u0308lg", 41);
    freq.put("o\u0308lf", 107);
    freq.put("nsa\u0301", 38);
    freq.put("S", 11572);
    freq.put("o\u0308ls", 201);
    freq.put("o\u0308lu", 629);
    freq.put("o\u0308lv", 557);
    freq.put("það", 1705);
    freq.put("e\u0300", 36);
    freq.put("ws", 87);
    freq.put("oða", 349);
    freq.put("Hof", 73);
    freq.put(" Fo\u0301", 49);
    freq.put(" Fo\u0308", 37);
    freq.put("ohn", 133);
    freq.put(" Fa\u0301", 50);
    freq.put(" Fæ", 127);
    freq.put(" Fe\u0301", 158);
    freq.put(" Fi\u0301", 29);
    freq.put("ad", 1746);
    freq.put("ys ", 74);
    freq.put("oði", 87);
    freq.put("Hon", 37);
    freq.put("Na\u0301", 93);
    freq.put("ak", 4372);
    freq.put("oha", 44);
    freq.put("cor", 78);
    freq.put("Næ", 38);
    freq.put("byg", 1051);
    freq.put("uin", 39);
    freq.put("ysk", 93);
    freq.put("Þy", 38);
    freq.put("ysi", 128);
    freq.put("How", 29);
    freq.put("Þr", 200);
    freq.put("Þu", 34);
    freq.put("Þv", 74);
    freq.put("emi\u0301", 69);
    freq.put("Þj", 278);
    freq.put("Þo", 417);
    freq.put("yss", 114);
    freq.put("Hor", 96);
    freq.put("Þe", 606);
    freq.put("ysu", 42);
    freq.put("Ny\u0301", 191);
    freq.put(" Fr", 1133);
    freq.put(" Fu", 126);
    freq.put(" Fy", 316);
    freq.put(" Fa", 298);
    freq.put(" Fe", 260);
    freq.put(" Fi", 346);
    freq.put(" Fj", 284);
    freq.put(" Fl", 547);
    freq.put(" Fo", 401);
    freq.put("io ", 167);
    freq.put("No\u0301", 36);
    freq.put("ior", 56);
    freq.put(" F ", 53);
    freq.put("Þy\u0301", 326);
    freq.put("Þo\u0301", 307);
    freq.put("Þa\u0301", 57);
    freq.put("con", 78);
    freq.put("Þæ", 99);
    freq.put("njo\u0301", 114);
    freq.put("adr", 85);
    freq.put("ads", 38);
    freq.put("gma", 107);
    freq.put("esu\u0301", 56);
    freq.put("gme", 79);
    freq.put("tma\u0301", 108);
    freq.put("gmy", 138);
    freq.put("ade", 268);
    freq.put("tmæ", 47);
    freq.put("ada", 509);
    freq.put("ado", 94);
    freq.put("esi\u0301", 96);
    freq.put("\u043c", 63);
    freq.put("adi", 100);
    freq.put(" \u0627", 112);
    freq.put("fyl", 713);
    freq.put("fyr", 4233);
    freq.put("lto\u0308", 53);
    freq.put(" \u30a2\u30a2", 29);
    freq.put("ad ", 170);
    freq.put("nja", 244);
    freq.put("y\u0301ta", 55);
    freq.put("nju", 309);
    freq.put("est", 3452);
    freq.put("ess", 1992);
    freq.put("ado\u0301", 89);
    freq.put("esp", 60);
    freq.put("tmy", 32);
    freq.put("gma\u0301", 109);
    freq.put("ady\u0301", 30);
    freq.put("adæ", 81);
    freq.put("esf", 32);
    freq.put("ese", 247);
    freq.put("esc", 36);
    freq.put("esb", 59);
    freq.put("esa", 148);
    freq.put("eso", 32);
    freq.put("tmi", 41);
    freq.put("adi\u0301", 88);
    freq.put("esk", 983);
    freq.put("esj", 33);
    freq.put("esi", 419);
    freq.put("esh", 83);
    freq.put("OS ", 34);
    freq.put("nfy", 38);
    freq.put("es ", 1150);
    freq.put("\u4e09 ", 35);
    freq.put("ðgo\u0308", 37);
    freq.put("De ", 44);
    freq.put("bu ", 44);
    freq.put("rcu", 48);
    freq.put("rch", 57);
    freq.put("rce", 64);
    freq.put("mu\u0301r", 37);
    freq.put("mu\u0301s", 74);
    freq.put("bur", 454);
    freq.put("bus", 56);
    freq.put("Dev", 30);
    freq.put("Dei", 35);
    freq.put("ubæ", 33);
    freq.put("bun", 269);
    freq.put("Den", 31);
    freq.put("mu\u0301l", 68);
    freq.put("mu\u0301n", 52);
    freq.put("uha\u0301", 62);
    freq.put("j", 33645);
    freq.put("ðge", 167);
    freq.put("pil", 337);
    freq.put("pin", 465);
    freq.put("ðga", 93);
    freq.put("su\u0301r", 97);
    freq.put("ðgu", 32);
    freq.put("ðgr", 104);
    freq.put("pir", 132);
    freq.put("pis", 61);
    freq.put("pit", 31);
    freq.put("Her", 215);
    freq.put("I\u0301þr", 48);
    freq.put("ubr", 59);
    freq.put("pi ", 583);
    freq.put("ube", 67);
    freq.put("uba", 61);
    freq.put("ubb", 30);
    freq.put("ubl", 130);
    freq.put("ubo", 41);
    freq.put("ko\u0301s", 45);
    freq.put("mað", 1182);
    freq.put("o\u0308tn", 84);
    freq.put(" ka\u0301", 29);
    freq.put(" kæ", 55);
    freq.put("Fis", 39);
    freq.put(" ki\u0301", 261);
    freq.put(" ko\u0301", 124);
    freq.put("rþi", 59);
    freq.put(" ko\u0308", 324);
    freq.put(" ku\u0301", 89);
    freq.put("rþe", 39);
    freq.put(" ky\u0301", 34);
    freq.put("i\u0301us", 154);
    freq.put("i\u0301ur", 45);
    freq.put("kuð", 160);
    freq.put("lt ", 907);
    freq.put("G ", 277);
    freq.put("i\u0301um", 114);
    freq.put("i\u0301ul", 62);
    freq.put("i\u0301un", 207);
    freq.put("i\u0301uh", 63);
    freq.put("\u0644", 172);
    freq.put("\u05d9", 40);
    freq.put("li\u0301m", 87);
    freq.put("Gv", 43);
    freq.put("Gu", 618);
    freq.put("Gr", 968);
    freq.put("Gy", 51);
    freq.put("Ge", 554);
    freq.put("i\u0301u ", 1396);
    freq.put("Ga", 560);
    freq.put("Go", 225);
    freq.put("Gn", 42);
    freq.put("Gl", 211);
    freq.put("Gj", 38);
    freq.put("Gi", 186);
    freq.put(" ka", 1977);
    freq.put(" ke", 1446);
    freq.put(" kj", 379);
    freq.put(" ki", 467);
    freq.put(" kn", 246);
    freq.put(" ko", 2181);
    freq.put(" kl", 476);
    freq.put(" km", 437);
    freq.put(" kr", 671);
    freq.put(" kv", 906);
    freq.put(" ku", 88);
    freq.put(" ky", 352);
    freq.put("di\u0301 ", 50);
    freq.put("He\u0301r", 92);
    freq.put("kuv", 29);
    freq.put("kut", 72);
    freq.put("kus", 117);
    freq.put("kur", 3957);
    freq.put("kup", 220);
    freq.put("kun", 523);
    freq.put("kum", 1574);
    freq.put("ain", 143);
    freq.put("Fil", 53);
    freq.put("kug", 52);
    freq.put("fe\u0301k", 83);
    freq.put("kub", 39);
    freq.put("fe\u0301l", 1458);
    freq.put("\u03c2", 149);
    freq.put("xfo", 37);
    freq.put("ws ", 58);
    freq.put("go\u0308n", 268);
    freq.put("pæn", 140);
    freq.put("þy\u0301s", 403);
    freq.put("Go\u0308", 52);
    freq.put("Ze", 49);
    freq.put("go\u0308m", 74);
    freq.put("Za", 29);
    freq.put("di\u0301n", 33);
    freq.put("fe\u0301 ", 69);
    freq.put("di\u0301s", 130);
    freq.put("di\u0301u", 40);
    freq.put("Gi\u0301", 124);
    freq.put("ku ", 2256);
    freq.put("Kom", 44);
    freq.put("Kol", 166);
    freq.put("Kon", 176);
    freq.put("ts", 2200);
    freq.put("o\u0308r ", 105);
    freq.put("Kos", 29);
    freq.put("Kor", 44);
    freq.put("m ", 40783);
    freq.put("si\u0301u", 323);
    freq.put("si\u0301s", 110);
    freq.put("eni\u0301", 97);
    freq.put("si\u0301n", 753);
    freq.put("si\u0301m", 100);
    freq.put("si\u0301l", 50);
    freq.put("si\u0301k", 31);
    freq.put("si\u0301g", 43);
    freq.put("ni ", 6328);
    freq.put("si\u0301a", 114);
    freq.put("o\u0308rs", 47);
    freq.put("o\u0308rp", 62);
    freq.put("o\u0308rv", 91);
    freq.put("o\u0308ru", 372);
    freq.put("o\u0308rt", 84);
    freq.put("o\u0308ry", 39);
    freq.put("go\u0308r", 37);
    freq.put("o\u0308rg", 409);
    freq.put("o\u0308rf", 205);
    freq.put("o\u0308rd", 65);
    freq.put("o\u0308rk", 384);
    freq.put("o\u0308ri", 68);
    freq.put("o\u0308rn", 587);
    freq.put("o\u0308rl", 66);
    freq.put("me", 10367);
    freq.put("md", 435);
    freq.put("mg", 109);
    freq.put("mf", 545);
    freq.put("ma", 10956);
    freq.put("ltu", 112);
    freq.put("mb", 2218);
    freq.put("mm", 1678);
    freq.put("ml", 1350);
    freq.put("mo", 647);
    freq.put("mn", 514);
    freq.put("mi", 7819);
    freq.put("mh", 618);
    freq.put("mk", 703);
    freq.put("mj", 551);
    freq.put("mu", 3055);
    freq.put("mt", 1727);
    freq.put("mv", 384);
    freq.put("mp", 1250);
    freq.put("ms", 4462);
    freq.put("mr", 361);
    freq.put("ta", 23969);
    freq.put("my", 2358);
    freq.put("kær", 45);
    freq.put("kæn", 58);
    freq.put("ena", 189);
    freq.put("enb", 71);
    freq.put("enc", 88);
    freq.put("end", 2651);
    freq.put("ene", 240);
    freq.put("enf", 36);
    freq.put("eng", 2379);
    freq.put("enh", 41);
    freq.put("eni", 177);
    freq.put("enj", 285);
    freq.put("enk", 42);
    freq.put("enn", 4534);
    freq.put("eno", 72);
    freq.put("enr", 50);
    freq.put("ens", 3046);
    freq.put("ent", 778);
    freq.put("enu", 71);
    freq.put("m2", 103);
    freq.put("enz", 239);
    freq.put("Hel", 374);
    freq.put("o\u0308rð", 1075);
    freq.put("II ", 73);
    freq.put("þyn", 97);
    freq.put("en ", 4249);
    freq.put("uðl", 128);
    freq.put("mæ", 806);
    freq.put("ma\u0301", 3190);
    freq.put("nu\u0301v", 68);
    freq.put("nu\u0301t", 151);
    freq.put("mi\u0301", 442);
    freq.put("uðg", 34);
    freq.put("uðb", 470);
    freq.put("uða", 444);
    freq.put("nu\u0301a", 192);
    freq.put("mo\u0308", 974);
    freq.put("mo\u0301", 746);
    freq.put("y\u0301ða", 33);
    freq.put("my\u0301", 131);
    freq.put("nu\u0301i", 49);
    freq.put("mþ", 95);
    freq.put("uðr", 201);
    freq.put("nu\u0301n", 502);
    freq.put("nu\u0301m", 106);
    freq.put("mu\u0301", 288);
    freq.put(" Hr", 478);
    freq.put(" Hv", 447);
    freq.put(" Hu", 336);
    freq.put(" Hj", 179);
    freq.put(" Hi", 343);
    freq.put(" Ho", 620);
    freq.put(" Hn", 67);
    freq.put(" Hl", 320);
    freq.put(" Ha", 2193);
    freq.put(" He", 1194);
    freq.put("ima", 446);
    freq.put("imb", 81);
    freq.put("ime", 190);
    freq.put("imf", 72);
    freq.put("imi", 735);
    freq.put("imk", 47);
    freq.put("imm", 338);
    freq.put("iml", 33);
    freq.put("ajo\u0308", 66);
    freq.put("imn", 59);
    freq.put("imp", 63);
    freq.put("ims", 1087);
    freq.put("imu", 329);
    freq.put("imy", 162);
    freq.put("goð", 247);
    freq.put("SA ", 48);
    freq.put(" H ", 70);
    freq.put("im ", 624);
    freq.put("hyg", 213);
    freq.put("Fær", 114);
    freq.put("Við", 210);
    freq.put("\u064a ", 37);
    freq.put(" Hu\u0301", 1094);
    freq.put("a\u0301ha", 37);
    freq.put("a\u0301he", 82);
    freq.put(" Ho\u0301", 219);
    freq.put(" Ho\u0308", 355);
    freq.put("a\u0301hr", 211);
    freq.put(" He\u0301", 115);
    freq.put(" Hi\u0301", 33);
    freq.put("a\u0301hu", 51);
    freq.put(" Ha\u0301", 323);
    freq.put(" Hæ", 71);
    freq.put("nio", 41);
    freq.put("gon", 51);
    freq.put("gog", 30);
    freq.put("aja", 65);
    freq.put("gos", 180);
    freq.put("gor", 133);
    freq.put("W", 992);
    freq.put("Vig", 35);
    freq.put("Vik", 42);
    freq.put("Vin", 79);
    freq.put("go ", 107);
    freq.put("Vil", 122);
    freq.put("Vir", 57);
    freq.put("Vis", 32);
    freq.put("be ", 48);
    freq.put("nhe", 69);
    freq.put("nha", 96);
    freq.put("nhl", 58);
    freq.put("rai\u0301", 49);
    freq.put("nhi", 29);
    freq.put("lba\u0301", 43);
    freq.put("nir", 1570);
    freq.put("nhv", 283);
    freq.put("rað", 905);
    freq.put("\u041a", 36);
    freq.put("tor", 456);
    freq.put("tos", 79);
    freq.put("top", 73);
    freq.put("Ka\u0301r", 32);
    freq.put("ton", 377);
    freq.put("tol", 63);
    freq.put("tom", 29);
    freq.put("toc", 34);
    freq.put("tof", 1728);
    freq.put("tog", 155);
    freq.put("Bu\u0301r", 44);
    freq.put("Ful", 38);
    freq.put("tfæ", 31);
    freq.put("to ", 193);
    freq.put("thu", 143);
    freq.put("raf", 954);
    freq.put("rag", 405);
    freq.put("rad", 211);
    freq.put("rae", 86);
    freq.put("rab", 445);
    freq.put("rac", 77);
    freq.put("\u4e09", 94);
    freq.put("ral", 525);
    freq.put("ram", 2670);
    freq.put("rak", 489);
    freq.put("rah", 258);
    freq.put("rai", 43);
    freq.put("rav", 117);
    freq.put("rat", 554);
    freq.put("rau", 1255);
    freq.put("rar", 1340);
    freq.put("ras", 718);
    freq.put("rap", 103);
    freq.put("lbo", 49);
    freq.put("toð", 80);
    freq.put("lu\u0301ð", 37);
    freq.put("thi", 41);
    freq.put("ra ", 5434);
    freq.put("My\u0301v", 29);
    freq.put("My\u0301r", 98);
    freq.put("ðih", 890);
    freq.put("ðil", 607);
    freq.put("ðim", 112);
    freq.put("ðin", 3092);
    freq.put("e\u0301s", 167);
    freq.put("e\u0301r", 1779);
    freq.put("e\u0301u", 87);
    freq.put("e\u0301t", 1646);
    freq.put("nuð", 960);
    freq.put("ðig", 61);
    freq.put("e\u0301k", 185);
    freq.put("e\u0301l", 2012);
    freq.put("e\u0301n", 89);
    freq.put("ðir", 1217);
    freq.put("e\u0301b", 41);
    freq.put("e\u0301g", 31);
    freq.put("e\u0301f", 124);
    freq.put("oci", 55);
    freq.put("och", 58);
    freq.put("Bil", 56);
    freq.put("oco", 29);
    freq.put("Bib", 37);
    freq.put("abr", 215);
    freq.put(" u\u0301t", 2473);
    freq.put("Bir", 67);
    freq.put("Bis", 37);
    freq.put(" u\u0301r", 1554);
    freq.put("\u0440", 151);
    freq.put("e\u0301ði", 33);
    freq.put("ði ", 5726);
    freq.put("e\u0301 ", 624);
    freq.put("rðu", 3047);
    freq.put("Pet", 79);
    freq.put("e\u0301ð", 84);
    freq.put("nur", 921);
    freq.put("nus", 525);
    freq.put("Per", 153);
    freq.put("nun", 1626);
    freq.put("Pen", 61);
    freq.put("num", 5240);
    freq.put("nuh", 50);
    freq.put("ðið", 1005);
    freq.put("nug", 63);
    freq.put("nud", 81);
    freq.put("nub", 32);
    freq.put("nua", 31);
    freq.put("mus", 94);
    freq.put("mur", 1133);
    freq.put("i\u0301su", 62);
    freq.put("i\u0301st", 50);
    freq.put("bey", 64);
    freq.put("i\u0301sk", 2316);
    freq.put("i\u0301si", 469);
    freq.put("mum", 344);
    freq.put("mul", 139);
    freq.put("mun", 905);
    freq.put("i\u0301sa", 218);
    freq.put("Hu\u0301", 1094);
    freq.put("fjo\u0301", 323);
    freq.put("A\u0301gu\u0301", 61);
    freq.put("nu ", 4087);
    freq.put("mu ", 328);
    freq.put("u\u0301de", 39);
    freq.put("u\u0301dd", 41);
    freq.put("u\u0301da", 42);
    freq.put("i\u0301s ", 151);
    freq.put(" me", 6197);
    freq.put(" ma", 2672);
    freq.put(" mm", 37);
    freq.put(" mo", 182);
    freq.put(" mi", 3548);
    freq.put(" mj", 459);
    freq.put(" mu", 272);
    freq.put(" my", 1128);
    freq.put("\u03b9\u0301", 34);
    freq.put(" m ", 286);
    freq.put("Cri", 38);
    freq.put("þet", 98);
    freq.put("þes", 1283);
    freq.put("n", 216937);
    freq.put("þen", 84);
    freq.put("þek", 897);
    freq.put("þei", 1439);
    freq.put("þeg", 905);
    freq.put(" mæ", 323);
    freq.put(" ma\u0301", 1082);
    freq.put("i\u0301ff", 195);
    freq.put(" mi\u0301", 73);
    freq.put("e\u0301ð ", 29);
    freq.put(" mo\u0308", 457);
    freq.put(" mo\u0301", 335);
    freq.put(" my\u0301", 45);
    freq.put(" mu\u0301", 64);
    freq.put("Tro", 45);
    freq.put("\u062d", 41);
    freq.put("ply\u0301", 155);
    freq.put("o\u0308pu", 50);
    freq.put("rða", 3018);
    freq.put("o\u0308pp", 29);
    freq.put("Tre", 49);
    freq.put("Ly\u0301ð", 56);
    freq.put("au\u0301t", 75);
    freq.put(" Ju\u0301", 86);
    freq.put("a\u0301um", 45);
    freq.put(" Jo\u0308", 155);
    freq.put(" Jo\u0301", 679);
    freq.put(" Ja\u0301", 37);
    freq.put("elj", 279);
    freq.put("eli", 198);
    freq.put("elo", 54);
    freq.put("ell", 1350);
    freq.put("elm", 97);
    freq.put("Ho\u0301", 220);
    freq.put("ela", 212);
    freq.put("Ho\u0308", 355);
    freq.put("elg", 458);
    freq.put("eld", 1621);
    freq.put("ele", 208);
    freq.put("He\u0301", 115);
    freq.put("Hi\u0301", 33);
    freq.put("els", 1013);
    freq.put("elp", 39);
    freq.put("Ha\u0301", 323);
    freq.put("Hæ", 71);
    freq.put("elt", 302);
    freq.put("elu", 227);
    freq.put("D", 2516);
    freq.put(" Sa\u0301", 78);
    freq.put("el ", 631);
    freq.put("vip", 108);
    freq.put(" Ju", 93);
    freq.put(" Jo", 341);
    freq.put(" Je", 228);
    freq.put(" Ja", 516);
    freq.put("ick", 89);
    freq.put("ici", 64);
    freq.put("ich", 282);
    freq.put("ico", 79);
    freq.put("eli\u0301", 74);
    freq.put("Hr", 479);
    freq.put("ica", 290);
    freq.put("Hv", 448);
    freq.put("ice", 85);
    freq.put("Hu", 359);
    freq.put("Hj", 179);
    freq.put("Hi", 344);
    freq.put("Hn", 67);
    freq.put("Ho", 620);
    freq.put("Hl", 321);
    freq.put("ics", 37);
    freq.put("icr", 57);
    freq.put("Ha", 2194);
    freq.put("pyr", 266);
    freq.put("icu", 82);
    freq.put("He", 1196);
    freq.put("lu\u0301t", 54);
    freq.put("ic ", 168);
    freq.put("H ", 152);
    freq.put("a\u0301nd", 108);
    freq.put("ppa", 270);
    freq.put("aha", 506);
    freq.put("ppg", 58);
    freq.put("a\u0301na", 282);
    freq.put("ppe", 128);
    freq.put("ahe", 110);
    freq.put("a\u0301nn", 67);
    freq.put("pph", 431);
    freq.put("a\u0301ni", 194);
    freq.put("ahl", 129);
    freq.put("ppl", 285);
    freq.put("ahr", 268);
    freq.put("a\u0301nu", 150);
    freq.put("ahv", 94);
    freq.put("o\u0308kv", 108);
    freq.put("Na\u0301t", 43);
    freq.put("a\u0301ns", 123);
    freq.put("ahy", 29);
    freq.put("ne\u0301", 65);
    freq.put("git", 30);
    freq.put("gis", 534);
    freq.put("ni\u0301", 1001);
    freq.put("na\u0301", 1602);
    freq.put("tið", 769);
    freq.put("næ", 1092);
    freq.put("gif", 68);
    freq.put("nu\u0301", 1706);
    freq.put("ny\u0301", 623);
    freq.put("nþ", 148);
    freq.put("gin", 2704);
    freq.put("gim", 55);
    freq.put("gil", 555);
    freq.put("no\u0308", 212);
    freq.put("So\u0308n", 96);
    freq.put("ah ", 67);
    freq.put("pp ", 769);
    freq.put("a\u0301n ", 338);
    freq.put("So\u0308g", 42);
    freq.put("o\u0301si\u0301", 50);
    freq.put("uðn", 68);
    freq.put("ura", 213);
    freq.put("Vol", 51);
    freq.put("url", 562);
    freq.put("mmi", 66);
    freq.put("gi ", 2174);
    freq.put("urn", 504);
    freq.put("nno", 53);
    freq.put("aha\u0301", 51);
    freq.put("nnk", 88);
    freq.put("nni", 6598);
    freq.put("nnh", 72);
    freq.put("nng", 84);
    freq.put("nnf", 115);
    freq.put("nne", 296);
    freq.put("nnd", 365);
    freq.put("iðn", 200);
    freq.put("nnb", 60);
    freq.put("ppi\u0301", 56);
    freq.put("iðm", 78);
    freq.put("iðr", 196);
    freq.put("iðs", 853);
    freq.put("aho\u0308", 183);
    freq.put("nny", 33);
    freq.put("iðu", 850);
    freq.put("ahu\u0301", 86);
    freq.put("nnv", 87);
    freq.put("nnu", 1613);
    freq.put("nnt", 643);
    freq.put("nns", 1691);
    freq.put("o\u0301s ", 169);
    freq.put("nh", 697);
    freq.put("ni", 18092);
    freq.put("nj", 745);
    freq.put("nk", 1747);
    freq.put("nl", 1765);
    freq.put("nm", 750);
    freq.put("nn", 28163);
    freq.put("no", 4303);
    freq.put("tit", 169);
    freq.put("na", 24623);
    freq.put("nb", 713);
    freq.put("nc", 512);
    freq.put("nd", 28901);
    freq.put("ne", 5566);
    freq.put("nf", 978);
    freq.put("ng", 20121);
    freq.put("til", 6806);
    freq.put("ny", 302);
    freq.put("nz", 284);
    freq.put("tio", 397);
    freq.put("tik", 46);
    freq.put("np", 59);
    freq.put("tie", 49);
    freq.put("nr", 473);
    freq.put("ns", 14817);
    freq.put("nt", 3812);
    freq.put("nu", 14078);
    freq.put("nv", 1399);
    freq.put("nw", 40);
    freq.put("ið ", 16040);
    freq.put("o\u0301su", 45);
    freq.put("o\u0301st", 252);
    freq.put("nn ", 8805);
    freq.put("o\u0301sm", 64);
    freq.put("o\u0301sl", 49);
    freq.put("o\u0301si", 102);
    freq.put("o\u0301sk", 121);
    freq.put("o\u0301se", 107);
    freq.put("o\u0301sa", 223);
    freq.put("n ", 36944);
    freq.put("A\u0301ðu", 37);
    freq.put("ykj", 958);
    freq.put("ti ", 5397);
    freq.put("lly", 78);
    freq.put("rok", 333);
    freq.put("rol", 93);
    freq.put("rom", 128);
    freq.put("ron", 188);
    freq.put("lls", 642);
    freq.put("llr", 182);
    freq.put("roc", 48);
    freq.put("rod", 104);
    freq.put("llv", 107);
    freq.put("rof", 43);
    freq.put("rog", 34);
    freq.put("llk", 55);
    freq.put("roy", 30);
    freq.put("lli", 2397);
    freq.put("llh", 48);
    freq.put("llo", 157);
    freq.put("ob ", 50);
    freq.put("llm", 34);
    freq.put("rop", 81);
    freq.put("llb", 51);
    freq.put("ror", 58);
    freq.put("ros", 443);
    freq.put("rot", 445);
    freq.put("rou", 80);
    freq.put("rov", 35);
    freq.put("row", 39);
    freq.put("Dag", 64);
    freq.put("fða", 298);
    freq.put("fðb", 90);
    freq.put("Dal", 141);
    freq.put("Dan", 318);
    freq.put("fði", 429);
    freq.put("fðu", 130);
    freq.put("Dav", 95);
    freq.put("so\u0308l", 167);
    freq.put("Dar", 51);
    freq.put("dey", 65);
    freq.put("ro ", 119);
    freq.put("Cit", 32);
    freq.put("ll ", 1950);
    freq.put(" dj", 84);
    freq.put("fð ", 55);
    freq.put("ict", 48);
    freq.put("Rey", 1063);
    freq.put("dss", 318);
    freq.put("llo\u0301", 29);
    freq.put("Rei", 54);
    freq.put("pma", 115);
    freq.put("lli\u0301", 79);
    freq.put("ðke", 36);
    freq.put("ðki", 33);
    freq.put("Reg", 63);
    freq.put("Que", 34);
    freq.put(" \u30a2", 29);
    freq.put("luð", 344);
    freq.put("y\u0301si", 434);
    freq.put("Mil", 62);
    freq.put("ð", 97792);
    freq.put("a\u0301t ", 80);
    freq.put("ðju", 320);
    freq.put("y\u0301sa", 87);
    freq.put("Mið", 393);
    freq.put("ngt", 285);
    freq.put("msv", 831);
    freq.put("msu", 130);
    freq.put("mst", 639);
    freq.put("mss", 231);
    freq.put("msp", 568);
    freq.put("msm", 255);
    freq.put("msl", 119);
    freq.put("msk", 329);
    freq.put("msj", 68);
    freq.put("msi", 108);
    freq.put("msh", 58);
    freq.put("msf", 81);
    freq.put("mse", 173);
    freq.put("msb", 39);
    freq.put("msa", 120);
    freq.put("ræn", 875);
    freq.put("u\u0301bb", 42);
    freq.put("Evr", 590);
    freq.put("yja", 1253);
    freq.put("ulj", 36);
    freq.put("yju", 348);
    freq.put("ru\u0301ð", 68);
    freq.put("ms ", 324);
    freq.put("Mik", 116);
    freq.put(" ok", 208);
    freq.put("Min", 98);
    freq.put(" of", 1574);
    freq.put(" og", 20861);
    freq.put("Mic", 123);
    freq.put("nma", 83);
    freq.put("kyr", 42);
    freq.put("Mis", 52);
    freq.put(" or", 937);
    freq.put(" os", 39);
    freq.put(" op", 322);
    freq.put("msy\u0301", 70);
    freq.put("ru\u0301 ", 190);
    freq.put("mso\u0308", 32);
    freq.put("mso\u0301", 36);
    freq.put("fi\u0301n", 37);
    freq.put("msæ", 58);
    freq.put("msa\u0301", 58);
    freq.put("Æ", 142);
    freq.put("ky ", 34);
    freq.put(" o ", 46);
    freq.put("ru\u0301g", 52);
    freq.put("ru\u0301f", 57);
    freq.put("ru\u0301a", 419);
    freq.put("ru\u0301n", 199);
    freq.put("ru\u0301m", 310);
    freq.put("ru\u0301i", 57);
    freq.put("yjo\u0301", 34);
    freq.put("ru\u0301s", 221);
    freq.put("sa\u0301l", 193);
    freq.put("nni\u0301", 45);
    freq.put("Fan", 34);
    freq.put("sa\u0301r", 272);
    freq.put("U\u0301kr", 30);
    freq.put("ppf", 56);
    freq.put("gta", 478);
    freq.put("ðbæ", 76);
    freq.put("ull", 717);
    freq.put("gto", 58);
    freq.put("ppi", 417);
    freq.put("\u0648", 81);
    freq.put("sa\u0301 ", 403);
    freq.put("aho", 81);
    freq.put("nna\u0301", 48);
    freq.put("gt ", 1312);
    freq.put("pps", 271);
    freq.put("ppr", 373);
    freq.put("iðo\u0308", 77);
    freq.put("nþa\u0301", 53);
    freq.put(" ca", 62);
    freq.put("ppt", 170);
    freq.put("Ro\u0301m", 176);
    freq.put("gto\u0308", 37);
    freq.put("kvæ", 806);
    freq.put("ttn", 145);
    freq.put("gir", 792);
    freq.put("mos", 64);
    freq.put("m2 ", 103);
    freq.put("nþr", 30);
    freq.put("a\u0301li\u0301", 29);
    freq.put("a\u0301læ", 106);
    freq.put("ani\u0301", 198);
    freq.put("þe\u0301t", 142);
    freq.put("ma\u0301 ", 229);
    freq.put("pro\u0301", 302);
    freq.put("ano\u0301", 79);
    freq.put("anþ", 38);
    freq.put("anu\u0301", 173);
    freq.put("iam", 73);
    freq.put("ial", 59);
    freq.put("ian", 234);
    freq.put(" a\u0301æ", 48);
    freq.put(" a\u0301ð", 574);
    freq.put("iat", 58);
    freq.put("ias", 35);
    freq.put("gib", 68);
    freq.put("ma\u0301s", 73);
    freq.put("hug", 970);
    freq.put("y\u0301ð", 730);
    freq.put("hum", 74);
    freq.put("hun", 188);
    freq.put("hur", 44);
    freq.put("hus", 67);
    freq.put("Y\u0301", 39);
    freq.put("ma\u0301l", 2457);
    freq.put("ma\u0301n", 166);
    freq.put(" Læ", 47);
    freq.put("no\u0301", 446);
    freq.put(" La\u0301", 110);
    freq.put(" Li\u0301", 171);
    freq.put("ia ", 441);
    freq.put("\u0646 ", 58);
    freq.put(" Lo\u0308", 101);
    freq.put("r", 261058);
    freq.put(" Lo\u0301", 43);
    freq.put(" Ly\u0301", 96);
    freq.put(" Lu\u0301", 62);
    freq.put("and", 12634);
    freq.put("ane", 475);
    freq.put("anf", 63);
    freq.put("ang", 1850);
    freq.put("pra", 73);
    freq.put("a\u0301lk", 336);
    freq.put("anb", 53);
    freq.put("a\u0301li", 555);
    freq.put("anl", 325);
    freq.put("a\u0301lg", 55);
    freq.put("ann", 7640);
    freq.put("ano", 128);
    freq.put("anh", 50);
    freq.put("ani", 508);
    freq.put("anj", 69);
    freq.put("ank", 389);
    freq.put("ant", 646);
    freq.put("anu", 572);
    freq.put("anv", 402);
    freq.put("lo\u0301r", 49);
    freq.put("y\u0301 ", 120);
    freq.put("anr", 62);
    freq.put("ans", 2276);
    freq.put("a\u0301lv", 69);
    freq.put("a\u0301lu", 194);
    freq.put("a\u0301ls", 457);
    freq.put("a\u0301lp", 80);
    freq.put(" a\u0301b", 154);
    freq.put(" a\u0301f", 139);
    freq.put(" L ", 32);
    freq.put(" a\u0301h", 379);
    freq.put(" a\u0301k", 361);
    freq.put(" a\u0301l", 132);
    freq.put(" a\u0301n", 237);
    freq.put(" a\u0301r", 4236);
    freq.put(" a\u0301s", 462);
    freq.put(" a\u0301t", 481);
    freq.put(" a\u0301v", 94);
    freq.put("y\u0301t", 324);
    freq.put("y\u0301v", 32);
    freq.put("an ", 5852);
    freq.put("y\u0301p", 92);
    freq.put("y\u0301s", 2406);
    freq.put("y\u0301r", 1984);
    freq.put("a\u0301l ", 816);
    freq.put("y\u0301d", 43);
    freq.put("Lo\u0308g", 81);
    freq.put("y\u0301f", 75);
    freq.put("y\u0301a", 30);
    freq.put("u\u0301p ", 32);
    freq.put("y\u0301m", 480);
    freq.put("y\u0301l", 453);
    freq.put("y\u0301n", 556);
    freq.put("y\u0301k", 129);
    freq.put("y\u0301j", 265);
    freq.put(" a\u0301 ", 11624);
    freq.put(" Le", 588);
    freq.put(" La", 1289);
    freq.put(" Lo", 529);
    freq.put(" Lj", 87);
    freq.put(" Li", 537);
    freq.put(" Lu", 199);
    freq.put(" Ly", 57);
    freq.put("rmo\u0301", 68);
    freq.put("tke", 39);
    freq.put("rmo\u0308", 79);
    freq.put("rmu\u0301", 75);
    freq.put("Mjo\u0301", 31);
    freq.put("nla", 365);
    freq.put("rma\u0301", 390);
    freq.put("nle", 833);
    freq.put("nli", 460);
    freq.put("dy ", 43);
    freq.put("ss ", 1445);
    freq.put("o\u0301un", 156);
    freq.put("lub", 100);
    freq.put("Fyl", 44);
    freq.put("Fyr", 272);
    freq.put("fo\u0308ð", 56);
    freq.put("ssy", 180);
    freq.put("ssu", 314);
    freq.put("H", 8629);
    freq.put("ssv", 116);
    freq.put("ssp", 30);
    freq.put("dys", 33);
    freq.put("ssl", 175);
    freq.put("sso", 1722);
    freq.put("ssn", 223);
    freq.put("ssi", 507);
    freq.put("ssk", 305);
    freq.put("ssj", 54);
    freq.put("sse", 290);
    freq.put("ssa", 788);
    freq.put("rms", 59);
    freq.put("rmu", 102);
    freq.put("lnu", 78);
    freq.put("rmy", 87);
    freq.put("rma", 627);
    freq.put("lni", 132);
    freq.put("Ro\u0308", 41);
    freq.put("rme", 281);
    freq.put("lne", 42);
    freq.put("kav", 64);
    freq.put("rmi", 222);
    freq.put("nli\u0301", 51);
    freq.put("rmo", 35);
    freq.put("rml", 167);
    freq.put("fo\u0308n", 37);
    freq.put("fo\u0308l", 135);
    freq.put(" \u043e\u0431", 31);
    freq.put("mti", 77);
    freq.put("fo\u0308t", 31);
    freq.put("fo\u0308s", 57);
    freq.put("fo\u0308r", 70);
    freq.put("ssy\u0301", 210);
    freq.put("sso\u0308", 35);
    freq.put("ssi\u0301", 67);
    freq.put("rm ", 127);
    freq.put("ðmu", 161);
    freq.put("yll", 160);
    freq.put("por", 171);
    freq.put("pos", 65);
    freq.put("pop", 61);
    freq.put("pon", 36);
    freq.put("pol", 74);
    freq.put("nnl", 189);
    freq.put("ðma", 32);
    freq.put("iðf", 164);
    freq.put("ðmi", 61);
    freq.put(" þy", 189);
    freq.put("iðd", 64);
    freq.put("Bur", 43);
    freq.put(" þr", 1309);
    freq.put(" þu", 239);
    freq.put(" þv", 1520);
    freq.put(" þi", 195);
    freq.put("iðj", 659);
    freq.put(" þj", 806);
    freq.put(" þo", 209);
    freq.put("iðk", 105);
    freq.put(" þa", 4775);
    freq.put("i\u0301ko\u0301", 69);
    freq.put(" þe", 4557);
    freq.put("iðh", 142);
    freq.put("iði", 994);
    freq.put("bu\u0301 ", 35);
    freq.put("nna", 7028);
    freq.put("rð ", 1989);
    freq.put("Ið", 49);
    freq.put(" þ ", 166);
    freq.put("iðt", 99);
    freq.put("oks", 33);
    freq.put("ðmæ", 37);
    freq.put("uhe", 55);
    freq.put("oku", 100);
    freq.put("okt", 196);
    freq.put(" þu\u0301", 310);
    freq.put(" þy\u0301", 700);
    freq.put(" þo\u0301", 393);
    freq.put("uha", 44);
    freq.put(" þo\u0308", 45);
    freq.put("\u0431", 78);
    freq.put(" þa\u0301", 953);
    freq.put("I ", 270);
    freq.put("uhl", 89);
    freq.put(" þæ", 322);
    freq.put("oka", 194);
    freq.put("Nja\u0301", 30);
    freq.put("Is", 113);
    freq.put("gið", 678);
    freq.put("Im", 36);
    freq.put("Il", 85);
    freq.put("In", 761);
    freq.put("uhr", 48);
    freq.put("Ic", 56);
    freq.put("tiv", 71);
    freq.put("oki", 67);
    freq.put("tir", 3353);
    freq.put("tis", 756);
    freq.put("okk", 1938);
    freq.put("gve\u0301", 77);
    freq.put("gvi\u0301", 39);
    freq.put("tin", 2196);
    freq.put("gvo\u0308", 64);
    freq.put("tid", 39);
    freq.put("tif", 55);
    freq.put("tig", 294);
    freq.put("y\u0301mi", 230);
    freq.put("Pin", 45);
    freq.put("aþo\u0301", 58);
    freq.put("tia", 90);
    freq.put("aþa\u0301", 42);
    freq.put("tic", 138);
    freq.put("y\u0301ms", 227);
    freq.put("oð", 819);
    freq.put("gvi", 54);
    freq.put("gva", 364);
    freq.put("o\u0308tl", 36);
    freq.put("gve", 169);
    freq.put("o\u0308tu", 646);
    freq.put("o\u0308tt", 156);
    freq.put("o\u0308tv", 30);
    freq.put("ynl", 57);
    freq.put("oo", 305);
    freq.put("on", 7027);
    freq.put("om", 2016);
    freq.put("ol", 2476);
    freq.put("ok", 2788);
    freq.put("oj", 70);
    freq.put("oi", 174);
    freq.put("oh", 219);
    freq.put("og", 21658);
    freq.put("of", 4047);
    freq.put("oe", 103);
    freq.put("od", 513);
    freq.put("oc", 382);
    freq.put("ob", 315);
    freq.put("oa", 97);
    freq.put("kvu", 31);
    freq.put("oz", 31);
    freq.put("oy", 162);
    freq.put("ox", 157);
    freq.put("ow", 306);
    freq.put("ov", 311);
    freq.put("ou", 631);
    freq.put("ot", 3409);
    freq.put("os", 2326);
    freq.put("or", 15125);
    freq.put("aþj", 48);
    freq.put("op", 1077);
    freq.put("ju ", 578);
    freq.put("rvi\u0301", 87);
    freq.put("Do\u0301m", 48);
    freq.put("rvo\u0308", 60);
    freq.put("pa\u0301r", 60);
    freq.put("igð", 208);
    freq.put("ehf", 31);
    freq.put("pa\u0301n", 114);
    freq.put("jub", 47);
    freq.put("juf", 31);
    freq.put("jug", 89);
    freq.put("jud", 50);
    freq.put("juh", 41);
    freq.put("jun", 745);
    freq.put("jul", 273);
    freq.put("jum", 817);
    freq.put("jur", 390);
    freq.put("jus", 220);
    freq.put("juv", 64);
    freq.put("pel", 119);
    freq.put("rva", 375);
    freq.put("rve", 420);
    freq.put("sy\u0301n", 431);
    freq.put("rvi", 233);
    freq.put("rvo", 44);
    freq.put("ve\u0301l", 295);
    freq.put("ve\u0301t", 58);
    freq.put("sy\u0301k", 65);
    freq.put("igu", 503);
    freq.put("igs", 49);
    freq.put("igr", 192);
    freq.put("igg", 668);
    freq.put("igf", 50);
    freq.put("ige", 85);
    freq.put("iga", 307);
    freq.put("ign", 307);
    freq.put("igl", 259);
    freq.put("igi", 601);
    freq.put("igh", 129);
    freq.put("SG ", 207);
    freq.put("tlu", 263);
    freq.put("ig ", 2070);
    freq.put("aln", 159);
    freq.put("alo", 66);
    freq.put("all", 4558);
    freq.put("alm", 385);
    freq.put("ðra", 457);
    freq.put("alk", 134);
    freq.put("a\u0301rv", 81);
    freq.put("ali", 1259);
    freq.put("alf", 139);
    freq.put("alg", 346);
    freq.put("ald", 2532);
    freq.put("ale", 741);
    freq.put("alb", 102);
    freq.put("pta", 402);
    freq.put("ala", 1875);
    freq.put("ðru", 553);
    freq.put("a\u0301ra", 516);
    freq.put("a\u0301rd", 141);
    freq.put("a\u0301re", 46);
    freq.put("a\u0301rf", 67);
    freq.put("aly", 37);
    freq.put("a\u0301rh", 61);
    freq.put("a\u0301ri", 3035);
    freq.put("fa ", 1735);
    freq.put("alu", 337);
    freq.put("a\u0301rl", 107);
    freq.put("als", 1039);
    freq.put("a\u0301rn", 118);
    freq.put("ðaa\u0301", 38);
    freq.put(" N ", 56);
    freq.put("sy\u0301r", 127);
    freq.put("suð", 680);
    freq.put("far", 1064);
    freq.put("fas", 294);
    freq.put("al ", 1641);
    freq.put("pt ", 185);
    freq.put("a\u0301r ", 710);
    freq.put("fah", 32);
    freq.put("fan", 667);
    freq.put("llu", 1097);
    freq.put("fal", 741);
    freq.put("fam", 53);
    freq.put("llt", 609);
    freq.put("faf", 45);
    freq.put("fag", 101);
    freq.put(" Ni", 233);
    freq.put(" Nj", 57);
    freq.put(" No", 1523);
    freq.put("llj", 272);
    freq.put(" Na", 464);
    freq.put(" Ne", 513);
    freq.put(" Nu", 48);
    freq.put("lln", 58);
    freq.put("a\u0301rð", 42);
    freq.put("tei", 1039);
    freq.put("ali\u0301", 469);
    freq.put("tel", 552);
    freq.put("tem", 310);
    freq.put("ten", 1249);
    freq.put("alæ", 30);
    freq.put("nbr", 60);
    freq.put("ðre\u0301", 42);
    freq.put("nbu", 51);
    freq.put("teg", 799);
    freq.put("alþ", 280);
    freq.put("a\u0301ra\u0301", 48);
    freq.put("aly\u0301", 31);
    freq.put("nbo", 78);
    freq.put("nbl", 83);
    freq.put("alo\u0308", 117);
    freq.put("pto\u0308", 103);
    freq.put("ter", 920);
    freq.put("tes", 176);
    freq.put("tet", 95);
    freq.put("alo\u0301", 52);
    freq.put("nbe", 288);
    freq.put("ðru\u0301", 35);
    freq.put("sun", 1042);
    freq.put("sum", 731);
    freq.put("oko\u0308", 33);
    freq.put("sus", 74);
    freq.put("sur", 86);
    freq.put("lld", 150);
    freq.put("te ", 264);
    freq.put("o\u0304", 51);
    freq.put("fað", 546);
    freq.put("mms", 259);
    freq.put(" Ni\u0301", 89);
    freq.put("su ", 308);
    freq.put(" Na\u0301", 93);
    freq.put(" Næ", 38);
    freq.put(" Nu\u0301", 101);
    freq.put(" Ny\u0301", 191);
    freq.put("nmo\u0308", 126);
    freq.put("jo\u0301ð", 2051);
    freq.put(" No\u0301", 36);
    freq.put("rkt", 84);
    freq.put("rku", 705);
    freq.put("rkv", 63);
    freq.put("rkr", 89);
    freq.put("rks", 157);
    freq.put("Tor", 78);
    freq.put("Tos", 37);
    freq.put("sbe", 82);
    freq.put("rke", 391);
    freq.put("rkf", 85);
    freq.put("rka", 797);
    freq.put("Tom", 37);
    freq.put("rkl", 152);
    freq.put("rkm", 132);
    freq.put("rkn", 154);
    freq.put("rko", 161);
    freq.put("rki", 911);
    freq.put("rkj", 1072);
    freq.put("\u03b7", 55);
    freq.put("þvi\u0301", 1355);
    freq.put("u\u0301lf", 51);
    freq.put("rk ", 749);
    freq.put("Ei", 511);
    freq.put("a\u0301", 41692);
    freq.put("Int", 121);
    freq.put("Ins", 29);
    freq.put("þrj", 165);
    freq.put("Inn", 76);
    freq.put("þro", 69);
    freq.put("v", 51876);
    freq.put("Ind", 243);
    freq.put("Ing", 198);
    freq.put("þre", 237);
    freq.put("Ea", 44);
    freq.put("rku\u0301", 29);
    freq.put("rki\u0301", 63);
    freq.put("\u0438\u0306", 61);
    freq.put("oya", 34);
    freq.put("Glo", 38);
    freq.put("Akr", 70);
    freq.put("Gle", 35);
    freq.put("Aku", 116);
    freq.put("\u03bd ", 35);
    freq.put("lhe", 309);
    freq.put("lha", 33);
    freq.put("lho", 108);
    freq.put("lhl", 81);
    freq.put("lhj", 75);
    freq.put("þri\u0301", 169);
    freq.put("aa\u0301r", 34);
    freq.put("þra\u0301", 74);
    freq.put("þræ", 66);
    freq.put("oy ", 61);
    freq.put(" su\u0301", 468);
    freq.put(" sy\u0301", 615);
    freq.put(" so\u0301", 322);
    freq.put(" so\u0308", 1067);
    freq.put(" se\u0301", 1534);
    freq.put("Er ", 52);
    freq.put(" si\u0301", 1634);
    freq.put(" sa\u0301", 460);
    freq.put(" sæ", 382);
    freq.put("yn ", 65);
    freq.put("Fri", 161);
    freq.put("L", 4227);
    freq.put("Erl", 41);
    freq.put("Raf", 70);
    freq.put("Rag", 108);
    freq.put("Rad", 29);
    freq.put("ræð", 4116);
    freq.put("yni", 439);
    freq.put("ynj", 135);
    freq.put("Ran", 132);
    freq.put("ynf", 55);
    freq.put("yng", 529);
    freq.put("yna", 50);
    freq.put("Rau", 132);
    freq.put("ynt", 58);
    freq.put("yns", 204);
    freq.put(" sy", 488);
    freq.put("Ha\u0301l", 31);
    freq.put("Mus", 51);
    freq.put(" sp", 941);
    freq.put(" sv", 2024);
    freq.put("I\u0301sr", 41);
    freq.put(" st", 9503);
    freq.put(" su", 1520);
    freq.put(" sj", 1921);
    freq.put(" sk", 4722);
    freq.put(" si", 1522);
    freq.put(" sn", 851);
    freq.put(" so", 265);
    freq.put(" sl", 415);
    freq.put(" sm", 466);
    freq.put("Mun", 57);
    freq.put("Ha\u0301t", 37);
    freq.put("I\u0301sa", 105);
    freq.put(" se", 17046);
    freq.put("iza", 39);
    freq.put("o\u0301j", 46);
    freq.put("kom", 1243);
    freq.put(" s ", 184);
    freq.put("kol", 168);
    freq.put("ræv", 35);
    freq.put("ræt", 349);
    freq.put(" ek", 1007);
    freq.put("ynþ", 31);
    freq.put("ræg", 184);
    freq.put("ræf", 40);
    freq.put("ræk", 248);
    freq.put("X ", 104);
    freq.put("ræm", 47);
    freq.put("ræl", 54);
    freq.put("kob", 49);
    freq.put("lly\u0301", 48);
    freq.put("efð", 193);
    freq.put("efa\u0301", 91);
    freq.put("Bo\u0301k", 91);
    freq.put("No", 1524);
    freq.put("kos", 362);
    freq.put("þa\u0301t", 560);
    freq.put("hæs", 106);
    freq.put("hær", 33);
    freq.put("hæt", 240);
    freq.put("hæk", 32);
    freq.put("ðka", 49);
    freq.put("hæg", 247);
    freq.put("hæf", 189);
    freq.put("lu\u0301s", 36);
    freq.put("\u3042", 61);
    freq.put("\u03a0", 31);
    freq.put("efr", 52);
    freq.put("efs", 237);
    freq.put("eft", 1944);
    freq.put("efu", 1553);
    freq.put("ðko", 89);
    freq.put("efi", 869);
    freq.put("efj", 94);
    freq.put("efl", 96);
    freq.put("efn", 3337);
    freq.put("\u0639", 51);
    freq.put("efa", 155);
    freq.put("eff", 31);
    freq.put("Ba\u0301r", 54);
    freq.put("hæð", 207);
    freq.put("ef ", 241);
    freq.put("rte", 220);
    freq.put("aro\u0301", 106);
    freq.put("rta", 441);
    freq.put("aro\u0308", 154);
    freq.put("rtl", 50);
    freq.put("aru\u0301", 66);
    freq.put("rti", 364);
    freq.put("rth", 122);
    freq.put("arþ", 116);
    freq.put("rtu", 242);
    freq.put("ara\u0301", 337);
    freq.put("rts", 104);
    freq.put("rtr", 57);
    freq.put("are\u0301", 99);
    freq.put("ari\u0301", 1423);
    freq.put("Ju", 93);
    freq.put("ies", 63);
    freq.put("ier", 105);
    freq.put("iet", 44);
    freq.put("iei", 96);
    freq.put("Jo", 341);
    freq.put("iel", 71);
    freq.put("ien", 104);
    freq.put("Je", 231);
    freq.put("Ja", 517);
    freq.put("ief", 45);
    freq.put("hip", 34);
    freq.put("hir", 173);
    freq.put("his", 35);
    freq.put("hit", 297);
    freq.put("rt ", 1301);
    freq.put("mi\u0301u", 36);
    freq.put("mi\u0301s", 58);
    freq.put("hia", 38);
    freq.put("hic", 69);
    freq.put("hig", 37);
    freq.put("hil", 183);
    freq.put("him", 136);
    freq.put("hin", 765);
    freq.put(" Po\u0301", 142);
    freq.put(" Pa\u0301", 120);
    freq.put("ie ", 195);
    freq.put(" Pe\u0301", 116);
    freq.put("J ", 42);
    freq.put(" Pi\u0301", 33);
    freq.put("arp", 734);
    freq.put("arr", 610);
    freq.put("ars", 2758);
    freq.put("rta\u0301", 75);
    freq.put("aru", 75);
    freq.put("arv", 495);
    freq.put("rti\u0301", 153);
    freq.put("ary", 75);
    freq.put("ðta", 31);
    freq.put("ara", 2184);
    freq.put("arb", 562);
    freq.put("arc", 90);
    freq.put("ard", 705);
    freq.put("are", 429);
    freq.put("rto\u0301", 34);
    freq.put("arg", 845);
    freq.put("arh", 891);
    freq.put("ari", 2716);
    freq.put("bju", 54);
    freq.put("ark", 1210);
    freq.put("arl", 1420);
    freq.put("arm", 909);
    freq.put("arn", 1542);
    freq.put("rtu\u0301", 143);
    freq.put("Ju\u0301", 86);
    freq.put("Jo\u0308", 155);
    freq.put("Jo\u0301", 681);
    freq.put("Ja\u0301", 37);
    freq.put("hið", 78);
    freq.put("mi\u0301ð", 92);
    freq.put("ar ", 24659);
    freq.put("fge", 31);
    freq.put("fga", 65);
    freq.put(" Pr", 333);
    freq.put("c", 5204);
    freq.put("smo\u0308", 45);
    freq.put(" Pu", 82);
    freq.put(" Pa", 536);
    freq.put(" Pe", 377);
    freq.put("ø", 114);
    freq.put(" Pi", 180);
    freq.put(" Ph", 118);
    freq.put(" Po", 343);
    freq.put(" Pl", 227);
    freq.put("tgr", 38);
    freq.put("o\u0301ms", 871);
    freq.put("rið", 4639);
    freq.put("tga", 31);
    freq.put("tge", 143);
    freq.put("pr", 1694);
    freq.put("ps", 1356);
    freq.put("pp", 4302);
    freq.put("dul", 119);
    freq.put("dum", 1677);
    freq.put("dun", 333);
    freq.put("pu", 2231);
    freq.put("py", 298);
    freq.put("duf", 29);
    freq.put("pb", 43);
    freq.put("pa", 2152);
    freq.put("pf", 85);
    freq.put("pg", 70);
    freq.put("En", 512);
    freq.put("pj", 95);
    freq.put("pk", 33);
    freq.put("dur", 3307);
    freq.put("pi", 1889);
    freq.put("pn", 706);
    freq.put("o\u0301in", 48);
    freq.put("duv", 56);
    freq.put("pm", 157);
    freq.put("Fal", 50);
    freq.put("\u0438\u0306 ", 44);
    freq.put("o\u0301me", 237);
    freq.put("ekj", 180);
    freq.put("du ", 383);
    freq.put("p ", 1704);
    freq.put("o\u0301i ", 77);
    freq.put("Tit", 29);
    freq.put("rit", 1626);
    freq.put("riu", 44);
    freq.put("rir", 3442);
    freq.put("ris", 1095);
    freq.put("rip", 130);
    freq.put("Til", 161);
    freq.put("rio", 79);
    freq.put("ril", 173);
    freq.put("rim", 103);
    freq.put("rik", 328);
    freq.put("rih", 31);
    freq.put("rif", 777);
    freq.put("rig", 346);
    freq.put("rid", 143);
    freq.put("rie", 134);
    freq.put("rib", 57);
    freq.put("ric", 218);
    freq.put("ria", 195);
    freq.put("po\u0301", 246);
    freq.put("o\u0301ið", 33);
    freq.put("po\u0308", 182);
    freq.put("fu\u0301s", 45);
    freq.put("py\u0301", 31);
    freq.put("pa\u0301", 304);
    freq.put("pæ", 160);
    freq.put("O\u0301sk", 37);
    freq.put("duð", 125);
    freq.put("pi\u0301", 449);
    freq.put("Cor", 85);
    freq.put("Ha\u0301s", 150);
    freq.put("Ill", 42);
    freq.put("Com", 79);
    freq.put("Col", 95);
    freq.put("ri ", 5309);
    freq.put("Con", 100);
    freq.put("y\u0301va", 31);
    freq.put("Ed", 148);
    freq.put("sal", 365);
    freq.put("\u044c", 55);
    freq.put("Air", 29);
    freq.put("lja", 366);
    freq.put("lju", 52);
    freq.put("bo\u0308r", 116);
    freq.put("bo\u0308k", 39);
    freq.put("bo\u0308n", 81);
    freq.put("ndu\u0301", 78);
    freq.put("a\u0301æt", 78);
    freq.put("ndy\u0301", 173);
    freq.put("Gnu\u0301", 34);
    freq.put("ga\u0301t", 46);
    freq.put("ga\u0301r", 91);
    freq.put("ga\u0301f", 290);
    freq.put("ylv", 38);
    freq.put("ylt", 92);
    freq.put("Rom", 33);
    freq.put("lja\u0301", 29);
    freq.put("Rob", 50);
    freq.put("Roc", 43);
    freq.put("ylf", 29);
    freq.put("ylg", 269);
    freq.put("yld", 242);
    freq.put("lju\u0301", 103);
    freq.put("ljo\u0301", 2991);
    freq.put("Ros", 47);
    freq.put("ylk", 497);
    freq.put("wn ", 40);
    freq.put(" ut", 212);
    freq.put(" up", 1941);
    freq.put(" ur", 156);
    freq.put(" ul", 34);
    freq.put(" um", 4447);
    freq.put(" un", 1589);
    freq.put("gro\u0308", 62);
    freq.put("gro\u0301", 151);
    freq.put("gru\u0301", 33);
    freq.put("græ", 199);
    freq.put("upp", 2005);
    freq.put("gra\u0301", 134);
    freq.put("gri\u0301", 914);
    freq.put("gre\u0301", 42);
    freq.put("sma\u0301", 328);
    freq.put(" u ", 29);
    freq.put(" Ky", 159);
    freq.put("a\u030a", 50);
    freq.put("ix ", 65);
    freq.put("z", 1088);
    freq.put("urh", 524);
    freq.put("gru", 389);
    freq.put("gre", 1498);
    freq.put("gra", 798);
    freq.put("o\u0308xt", 60);
    freq.put("grj", 36);
    freq.put("gri", 532);
    freq.put("rri\u0301", 167);
    freq.put("eda", 35);
    freq.put("edd", 31);
    freq.put("ede", 88);
    freq.put("rræ", 279);
    freq.put("edi", 112);
    freq.put("edo", 29);
    freq.put("rra\u0301", 98);
    freq.put("edr", 32);
    freq.put("\u043a\u0430", 44);
    freq.put("vi\u0301ð", 290);
    freq.put("ugn", 84);
    freq.put("ugm", 142);
    freq.put("ugb", 111);
    freq.put("ed ", 214);
    freq.put("ugg", 223);
    freq.put("ibj", 53);
    freq.put("sar", 943);
    freq.put("P", 2862);
    freq.put("Haf", 163);
    freq.put("uæt", 68);
    freq.put("Kyn", 37);
    freq.put("iba", 30);
    freq.put("Kyr", 107);
    freq.put("rro", 51);
    freq.put("vi\u0301l", 52);
    freq.put("vi\u0301m", 40);
    freq.put("rrk", 38);
    freq.put("vi\u0301k", 1324);
    freq.put("rri", 789);
    freq.put("vi\u0301g", 117);
    freq.put("rre", 213);
    freq.put("rra", 1384);
    freq.put("vi\u0301a", 47);
    freq.put("ugs", 232);
    freq.put("rry", 72);
    freq.put("vi\u0301v", 36);
    freq.put("rrv", 80);
    freq.put("rru", 200);
    freq.put("vi\u0301u", 65);
    freq.put("vi\u0301r", 31);
    freq.put("vi\u0301s", 868);
    freq.put(" o\u0301g", 40);
    freq.put("ugt", 564);
    freq.put("vi\u0301 ", 1408);
    freq.put("rr ", 186);
    freq.put("tað", 3001);
    freq.put("apr", 187);
    freq.put("app", 288);
    freq.put(" ol", 65);
    freq.put("apu", 54);
    freq.put("ðva", 303);
    freq.put("aph", 36);
    freq.put("api", 60);
    freq.put("ðve", 852);
    freq.put("apo", 29);
    freq.put("apl", 48);
    freq.put("ðvi", 83);
    freq.put("a\u0301ve", 79);
    freq.put("apa", 379);
    freq.put("æg ", 91);
    freq.put("a\u0301va", 365);
    freq.put("ape", 84);
    freq.put("use", 190);
    freq.put("Hug", 182);
    freq.put("feb", 142);
    freq.put("usa", 273);
    freq.put("fen", 195);
    freq.put("Hum", 33);
    freq.put("fel", 818);
    freq.put("\u062a", 33);
    freq.put("usk", 240);
    freq.put("usi", 109);
    freq.put("fei", 90);
    freq.put("usv", 66);
    freq.put("fet", 34);
    freq.put("ust", 3311);
    freq.put("fer", 1310);
    freq.put("fes", 284);
    freq.put("usp", 64);
    freq.put(" od", 33);
    freq.put("fey", 29);
    freq.put("y\u0301rl", 53);
    freq.put("Gua", 30);
    freq.put("ægt", 328);
    freq.put("ægu", 162);
    freq.put("Gun", 117);
    freq.put("ægr", 102);
    freq.put("Gul", 70);
    freq.put("ægi", 110);
    freq.put("ægj", 69);
    freq.put("ap ", 71);
    freq.put("æga", 135);
    freq.put("y\u0301ri", 416);
    freq.put(" Ru", 106);
    freq.put("us ", 1167);
    freq.put(" Re", 1399);
    freq.put("y\u0301rd", 38);
    freq.put(" Ra", 615);
    freq.put(" Ro", 344);
    freq.put(" Ri", 247);
    freq.put(" Rh", 36);
    freq.put("tat", 143);
    freq.put("tau", 127);
    freq.put("tav", 183);
    freq.put("ndb", 149);
    freq.put("tap", 85);
    freq.put("i\u0301fe", 48);
    freq.put("tar", 3875);
    freq.put("tas", 1447);
    freq.put("i\u0301fi", 116);
    freq.put("a\u0301vo\u0308", 33);
    freq.put("apo\u0308", 55);
    freq.put("y\u0301ra", 596);
    freq.put("tad", 164);
    freq.put("tae", 43);
    freq.put("taf", 1306);
    freq.put("tag", 148);
    freq.put("i\u0301ft", 46);
    freq.put("i\u0301fu", 123);
    freq.put("tab", 188);
    freq.put("tal", 2080);
    freq.put("tam", 380);
    freq.put("tan", 2188);
    freq.put("tah", 147);
    freq.put("tai", 47);
    freq.put("tak", 1550);
    freq.put("o\u0301ku", 123);
    freq.put("sir", 292);
    freq.put("o\u0301ks", 153);
    freq.put("sit", 427);
    freq.put("sic", 68);
    freq.put("sia", 58);
    freq.put("sig", 687);
    freq.put("feð", 29);
    freq.put("sid", 34);
    freq.put("o\u0301km", 151);
    freq.put("o\u0301kn", 521);
    freq.put("sio", 58);
    freq.put("sin", 3946);
    freq.put("sil", 235);
    freq.put("i\u0301f ", 93);
    freq.put("Ekk", 41);
    freq.put("ægð", 100);
    freq.put("Guð", 291);
    freq.put("ta ", 6721);
    freq.put(" Ro\u0308", 41);
    freq.put(" Ro\u0301", 242);
    freq.put(" Ru\u0301", 290);
    freq.put("si ", 1082);
    freq.put(" Ra\u0301", 45);
    freq.put("o\u0301k ", 536);
    freq.put(" Ri\u0301", 181);
    freq.put("y\u0301rs", 37);
    freq.put(" Re\u0301", 29);
    freq.put("kbr", 32);
    freq.put("o\u0308g", 3309);
    freq.put("byr", 205);
    freq.put("bys", 77);
    freq.put("byl", 138);
    freq.put("gh ", 58);
    freq.put("þve", 149);
    freq.put("Cas", 34);
    freq.put("Car", 150);
    freq.put("Cat", 30);
    freq.put("Can", 52);
    freq.put("Cam", 73);
    freq.put("Cal", 54);
    freq.put("Pre", 57);
    freq.put("nfe", 55);
    freq.put("y\u0301ti", 83);
    freq.put("ðbo\u0301", 84);
    freq.put("nfa", 160);
    freq.put("Pro", 96);
    freq.put("nfl", 71);
    freq.put("Pri", 96);
    freq.put("nfj", 30);
    freq.put("nfu", 33);
    freq.put("nfr", 379);
    freq.put("by ", 34);
    freq.put("y\u0301tu", 56);
    freq.put("oui", 32);
    freq.put("oun", 72);
    freq.put("su\u0301l", 58);
    freq.put("oul", 47);
    freq.put("oug", 45);
    freq.put("ous", 64);
    freq.put("our", 135);
    freq.put("su\u0301t", 44);
    freq.put("out", 62);
    freq.put("ja\u0301v", 273);
    freq.put("ja\u0301t", 39);
    freq.put("ja\u0301r", 442);
    freq.put("ja\u0301s", 35);
    freq.put("ja\u0301n", 150);
    freq.put("ja\u0301l", 1132);
    freq.put("cra", 34);
    freq.put("ja\u0301k", 79);
    freq.put("su\u0301 ", 352);
    freq.put("ou ", 62);
    freq.put("lts", 172);
    freq.put("nfæ", 48);
    freq.put("g", 100010);
    freq.put("vam", 93);
    freq.put("nfo\u0308", 56);
    freq.put("lta", 329);
    freq.put("lte", 303);
    freq.put("lti", 430);
    freq.put("u\u0308", 180);
    freq.put("ja\u0301 ", 476);
    freq.put("hy\u0301s", 53);
    freq.put("K ", 93);
    freq.put("vaf", 68);
    freq.put("ses", 89);
    freq.put("sep", 228);
    freq.put("\u03bb", 87);
    freq.put("to\u0301ð", 129);
    freq.put("Ka", 1200);
    freq.put("Ke", 369);
    freq.put("Kj", 148);
    freq.put("Ki", 277);
    freq.put("Ko", 534);
    freq.put("Kn", 101);
    freq.put("Kl", 180);
    freq.put("Kr", 557);
    freq.put("Kv", 148);
    freq.put("Ku", 90);
    freq.put("Ky", 159);
    freq.put("uta", 1193);
    freq.put("uar", 31);
    freq.put("o\u0301gi", 34);
    freq.put("to\u0301n", 860);
    freq.put("to\u0301l", 186);
    freq.put("to\u0301m", 77);
    freq.put("to\u0301k", 231);
    freq.put("to\u0301f", 35);
    freq.put("sek", 38);
    freq.put("to\u0301b", 197);
    freq.put("ru\u0301t", 141);
    freq.put("to\u0301t", 73);
    freq.put("to\u0301r", 803);
    freq.put("iby\u0301", 65);
    freq.put("Ka\u0301", 86);
    freq.put("hv", 2491);
    freq.put("da\u0301i", 46);
    freq.put("Ki\u0301", 164);
    freq.put("hw", 52);
    freq.put("Ko\u0301", 214);
    freq.put("ute", 116);
    freq.put("Ko\u0308", 70);
    freq.put("afð", 193);
    freq.put("Ku\u0301", 67);
    freq.put("Pot", 52);
    freq.put("Por", 129);
    freq.put("to\u0301 ", 38);
    freq.put("To\u0308l", 55);
    freq.put("Pol", 31);
    freq.put("vi\u0301d", 42);
    freq.put("læg", 317);
    freq.put("Cha", 121);
    freq.put("læm", 64);
    freq.put("læk", 184);
    freq.put("læt", 66);
    freq.put("læp", 38);
    freq.put("lær", 134);
    freq.put("ha", 7740);
    freq.put("hf", 59);
    freq.put("eat", 104);
    freq.put("q ", 62);
    freq.put("no ", 154);
    freq.put("gðu", 319);
    freq.put("qu", 172);
    freq.put("Jak", 50);
    freq.put("ebe", 38);
    freq.put("læð", 115);
    freq.put("ebr", 277);
    freq.put("ikv", 111);
    freq.put("lve", 225);
    freq.put("dla", 206);
    freq.put("tæk", 1071);
    freq.put("dle", 192);
    freq.put("dli", 96);
    freq.put("Jac", 46);
    freq.put("dlu", 40);
    freq.put("sa\u0301t", 78);
    freq.put("no\u0308f", 78);
    freq.put(" \u0627\u0644", 82);
    freq.put("no\u0308l", 72);
    freq.put("lþj", 313);
    freq.put("rps", 409);
    freq.put("rpr", 62);
    freq.put("rpu", 127);
    freq.put("avo\u0308", 101);
    freq.put("rpa", 113);
    freq.put("avi\u0301", 1064);
    freq.put("rpe", 36);
    freq.put("ave\u0301", 39);
    freq.put("tæt", 90);
    freq.put("rpi", 226);
    freq.put("rpo", 41);
    freq.put("bbi", 37);
    freq.put("bba", 96);
    freq.put("\u0430\u044f", 31);
    freq.put("nso\u0308", 46);
    freq.put("bbu", 35);
    freq.put("tær", 1323);
    freq.put("\u03bf", 164);
    freq.put("rp ", 163);
    freq.put("Dæm", 64);
    freq.put(" Tu\u0301", 51);
    freq.put("e\u0301", 6992);
    freq.put(" To\u0308", 59);
    freq.put(" To\u0301", 200);
    freq.put("bb ", 35);
    freq.put(" Ti\u0301", 126);
    freq.put(" Te\u0301", 39);
    freq.put(" Tæ", 41);
    freq.put(" Ta\u0301", 38);
    freq.put("tja", 445);
    freq.put("myn", 2237);
    freq.put("avn", 36);
    freq.put("avo", 132);
    freq.put("avi", 270);
    freq.put("ave", 508);
    freq.put("ava", 456);
    freq.put("ju\u0301n", 149);
    freq.put("ju\u0301l", 154);
    freq.put("ju\u0301k", 314);
    freq.put("ju\u0301g", 38);
    freq.put("ju\u0301f", 76);
    freq.put("þa\u0301 ", 592);
    freq.put("ju\u0301p", 173);
    freq.put("ðbo", 469);
    freq.put(" Ty", 102);
    freq.put(" Tv", 79);
    freq.put(" Tu", 190);
    freq.put(" Tr", 405);
    freq.put("ju\u0301 ", 59);
    freq.put(" To", 304);
    freq.put(" Tj", 67);
    freq.put(" Ti", 313);
    freq.put(" Th", 487);
    freq.put("tju", 44);
    freq.put(" Te", 268);
    freq.put(" Ta", 373);
    freq.put("mfa", 71);
    freq.put("mfe", 123);
    freq.put("Ki\u0301n", 133);
    freq.put("mfj", 29);
    freq.put("i\u0301da", 53);
    freq.put("i\u0301de", 43);
    freq.put("mfr", 56);
    freq.put("tch", 58);
    freq.put("Suð", 653);
    freq.put("mfy", 45);
    freq.put("kdo\u0301", 160);
    freq.put("sku", 3717);
    freq.put("skt", 636);
    freq.put("skv", 172);
    freq.put("sks", 67);
    freq.put("skr", 1500);
    freq.put("Far", 50);
    freq.put("o\u0301mv", 228);
    freq.put("o\u0301mu", 162);
    freq.put("sky", 454);
    freq.put("o\u0301mp", 698);
    freq.put("ske", 638);
    freq.put("tro\u0308", 549);
    freq.put("o\u0301mk", 72);
    freq.put("o\u0301mi", 78);
    freq.put("skl", 38);
    freq.put("sko", 719);
    freq.put("ski", 2451);
    freq.put("o\u0301mb", 34);
    freq.put("o\u0301ma", 424);
    freq.put("skj", 398);
    freq.put("Eir", 81);
    freq.put("T", 3307);
    freq.put("Ein", 322);
    freq.put("ndi\u0301", 91);
    freq.put("a\u0301ta", 175);
    freq.put("nda\u0301", 32);
    freq.put("a\u0301ti", 93);
    freq.put("a\u0301tt", 1937);
    freq.put("a\u0301tu", 169);
    freq.put("a\u0301tr", 47);
    freq.put("sk ", 1182);
    freq.put("ndo\u0301", 106);
    freq.put("y\u0301rð", 81);
    freq.put("o\u0301m ", 126);
    freq.put("Sun", 82);
    freq.put("Sum", 80);
    freq.put("Hu\u0301n", 965);
    freq.put("Hu\u0301s", 107);
    freq.put("Sup", 30);
    freq.put("sko\u0308", 121);
    freq.put("sko\u0301", 1556);
    freq.put("sky\u0301", 245);
    freq.put("nd ", 4229);
    freq.put("y\u0301r ", 423);
    freq.put("sku\u0301", 111);
    freq.put("skæ", 55);
    freq.put("ska\u0301", 595);
    freq.put("ski\u0301", 253);
    freq.put("uð ", 1944);
    freq.put("ndi", 7817);
    freq.put("ndh", 138);
    freq.put("ndk", 337);
    freq.put("ndm", 49);
    freq.put("ndl", 456);
    freq.put("ndo", 373);
    freq.put("ndn", 520);
    freq.put("nda", 5929);
    freq.put("a\u0301ti\u0301", 162);
    freq.put("nde", 320);
    freq.put("ndd", 33);
    freq.put("ndg", 40);
    freq.put("ndf", 105);
    freq.put("a\u0301to\u0308", 52);
    freq.put("y\u0301rt", 38);
    freq.put("y\u0301ru", 217);
    freq.put("nds", 3224);
    freq.put("ndr", 595);
    freq.put("ndu", 3833);
    freq.put("ndv", 196);
    freq.put("own", 47);
    freq.put("o\u0308d", 29);
    freq.put(" Æt", 40);
    freq.put("o\u0308f", 2560);
    freq.put(" Æv", 33);
    freq.put("owe", 53);
    freq.put("o\u0308k", 1689);
    freq.put("o\u0308l", 4517);
    freq.put("o\u0308m", 308);
    freq.put("o\u0308n", 3508);
    freq.put("o\u0308p", 100);
    freq.put("o\u0308r", 3745);
    freq.put("o\u0308s", 255);
    freq.put("o\u0308t", 1074);
    freq.put("o\u0308u", 59);
    freq.put("o\u0308x", 90);
    freq.put("ows", 60);
    freq.put("vak", 173);
    freq.put("van", 556);
    freq.put("val", 1084);
    freq.put("A\u0301st", 139);
    freq.put("Ama", 30);
    freq.put("Ro\u0301", 242);
    freq.put("Ame", 231);
    freq.put("vag", 69);
    freq.put("vad", 53);
    freq.put("vax", 219);
    freq.put("A\u0301sg", 52);
    freq.put("var", 9040);
    freq.put("vas", 74);
    freq.put("vav", 70);
    freq.put("vat", 1043);
    freq.put("o\u0308 ", 331);
    freq.put("ef", 8971);
    freq.put("uct", 39);
    freq.put("ow ", 78);
    freq.put("Ru\u0301", 290);
    freq.put("lvu", 443);
    freq.put("Tel", 34);
    freq.put("Ten", 40);
    freq.put("va ", 334);
    freq.put("Tex", 43);
    freq.put("lva", 264);
    freq.put("i\u0301ð", 2645);
    freq.put("i\u0301o\u0301", 153);
    freq.put("Ter", 34);
    freq.put("i\u0301þ", 437);
    freq.put("lvi", 125);
    freq.put("ex", 734);
    freq.put("myr", 42);
    freq.put("o\u0308ð", 2279);
    freq.put("lm ", 74);
    freq.put("Ri\u0301", 181);
    freq.put("i\u0301 ", 21136);
    freq.put("gi\u0301g", 49);
    freq.put("ep", 1965);
    freq.put("lvæ", 179);
    freq.put("Afr", 254);
    freq.put("gi\u0301s", 71);
    freq.put("vað", 288);
    freq.put("\u043d", 183);
    freq.put("gi\u0301u", 82);
    freq.put("gi\u0301t", 108);
    freq.put("my ", 29);
    freq.put("i\u0301e", 115);
    freq.put("i\u0301d", 173);
    freq.put("i\u0301g", 419);
    freq.put("i\u0301f", 1316);
    freq.put("i\u0301a", 767);
    freq.put("i\u0301b", 632);
    freq.put("i\u0301m", 2131);
    freq.put("i\u0301l", 945);
    freq.put("i\u0301o", 119);
    freq.put("i\u0301n", 2687);
    freq.put("i\u0301h", 106);
    freq.put("i\u0301k", 5310);
    freq.put("i\u0301u", 2135);
    freq.put("i\u0301t", 1441);
    freq.put("i\u0301v", 134);
    freq.put("i\u0301p", 113);
    freq.put("i\u0301s", 5447);
    freq.put("i\u0301r", 336);
    freq.put("lvi\u0301", 102);
  }
  
}

