package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ID extends CLangProfile {
  private static final String name = "id";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ID() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 11077227;
    n_words[1] = 12709440;
    n_words[2] = 9643042;

    freq.put(" ti", 9886);
    freq.put("mny", 1911);
    freq.put(" th", 1170);
    freq.put("aua", 1165);
    freq.put("up ", 3437);
    freq.put("aup", 1527);
    freq.put("aus", 1167);
    freq.put("aut", 2942);
    freq.put(" Gu", 2405);
    freq.put(" Gr", 2062);
    freq.put(" Ge", 3275);
    freq.put(" Ga", 2665);
    freq.put(" Go", 1803);
    freq.put("au ", 21880);
    freq.put("Gu", 2419);
    freq.put("Gr", 2085);
    freq.put("upa", 26147);
    freq.put("Ge", 3292);
    freq.put("Ga", 2686);
    freq.put("Go", 1818);
    freq.put("upu", 1725);
    freq.put(" ka", 17469);
    freq.put("me ", 2693);
    freq.put(" ke", 41380);
    freq.put(" kh", 1422);
    freq.put(" ki", 3127);
    freq.put(" ko", 17290);
    freq.put(" kl", 1852);
    freq.put(" km", 2201);
    freq.put("Ce", 1371);
    freq.put(" ku", 3200);
    freq.put("n", 996656);
    freq.put("Pul", 1756);
    freq.put("neg", 5658);
    freq.put("kut", 2035);
    freq.put("kus", 1523);
    freq.put("kur", 1949);
    freq.put("kup", 1223);
    freq.put("kun", 2321);
    freq.put("kum", 1981);
    freq.put("kul", 1651);
    freq.put("kuk", 1717);
    freq.put("net", 1984);
    freq.put("ak ", 26644);
    freq.put("ner", 3870);
    freq.put("nes", 16997);
    freq.put("kua", 1980);
    freq.put("med", 1539);
    freq.put("mem", 15519);
    freq.put("mel", 4982);
    freq.put("men", 35186);
    freq.put("lmu", 1446);
    freq.put("met", 2294);
    freq.put("mes", 1768);
    freq.put("mer", 26378);
    freq.put("aks", 3177);
    freq.put(" ya", 62479);
    freq.put("k", 378208);
    freq.put("aku", 4198);
    freq.put("akt", 4736);
    freq.put("aki", 3783);
    freq.put("akh", 2140);
    freq.put("dra", 1669);
    freq.put("aka", 36392);
    freq.put("ku ", 4682);
    freq.put("Jer", 2596);
    freq.put("Jep", 2416);
    freq.put("Kom", 1142);
    freq.put("Kon", 1421);
    freq.put("Kor", 1136);
    freq.put("Kot", 4453);
    freq.put("m ", 50860);
    freq.put("er ", 19709);
    freq.put("ni ", 27725);
    freq.put("nka", 1820);
    freq.put("Sta", 2065);
    freq.put("V", 6089);
    freq.put("me", 93044);
    freq.put("eru", 21470);
    freq.put("ma", 94460);
    freq.put("mb", 26120);
    freq.put("mm", 2111);
    freq.put("ml", 1630);
    freq.put("mo", 8478);
    freq.put("mn", 2215);
    freq.put("mi", 26777);
    freq.put("mu", 28574);
    freq.put("ere", 6493);
    freq.put("erg", 3829);
    freq.put("mp", 24012);
    freq.put("erb", 12574);
    freq.put("erc", 1371);
    freq.put("erl", 11827);
    freq.put("erm", 8938);
    freq.put("ern", 7132);
    freq.put("ero", 2183);
    freq.put("erh", 2837);
    freq.put("eri", 25792);
    freq.put("erj", 4499);
    freq.put("erk", 7438);
    freq.put("Le", 3207);
    freq.put("La", 6311);
    freq.put("Lo", 2427);
    freq.put("uas", 4449);
    freq.put("uar", 6223);
    freq.put("la ", 8248);
    freq.put("uat", 8034);
    freq.put("Li", 3131);
    freq.put("uah", 19677);
    freq.put("Lu", 1669);
    freq.put("ual", 1917);
    freq.put("uan", 9121);
    freq.put("Kab", 8059);
    freq.put("enc", 3844);
    freq.put("end", 12541);
    freq.put("ene", 6504);
    freq.put("eng", 44211);
    freq.put("eni", 5826);
    freq.put("enj", 6735);
    freq.put("mpa", 7594);
    freq.put("Kan", 1250);
    freq.put("Kal", 5302);
    freq.put("Kar", 2399);
    freq.put("ens", 2961);
    freq.put("ent", 14866);
    freq.put("enu", 4939);
    freq.put("Kat", 1399);
    freq.put("eny", 6205);
    freq.put("A", 46756);
    freq.put("lam", 23788);
    freq.put("lan", 18336);
    freq.put("lah", 85384);
    freq.put("lai", 7338);
    freq.put("lak", 4119);
    freq.put("lag", 1642);
    freq.put("fat", 1257);
    freq.put("ove", 2391);
    freq.put("lat", 9794);
    freq.put("lau", 6152);
    freq.put("ovi", 10349);
    freq.put("lap", 1829);
    freq.put("lar", 2452);
    freq.put("las", 5560);
    freq.put("en ", 21818);
    freq.put(" Hu", 2077);
    freq.put(" Hi", 2728);
    freq.put("zam", 1194);
    freq.put(" Ho", 2444);
    freq.put(" Ha", 5588);
    freq.put(" He", 2029);
    freq.put("ima", 9934);
    freq.put("fis", 1267);
    freq.put("ime", 1812);
    freq.put("imi", 1994);
    freq.put("imp", 2775);
    freq.put("imu", 7350);
    freq.put(" ga", 3124);
    freq.put("fik", 2255);
    freq.put("fil", 3873);
    freq.put(" Vi", 1551);
    freq.put("one", 17406);
    freq.put("im ", 3888);
    freq.put("l", 430448);
    freq.put("nt ", 2342);
    freq.put("rt", 29454);
    freq.put("ru", 41105);
    freq.put("rv", 1161);
    freq.put("rw", 1931);
    freq.put("rp", 3731);
    freq.put("at ", 42706);
    freq.put("rs", 13384);
    freq.put(" za", 1414);
    freq.put("ry", 4130);
    freq.put("rd", 11856);
    freq.put("re", 30519);
    freq.put("rf", 1249);
    freq.put("rg", 10415);
    freq.put("ra", 143028);
    freq.put("rb", 14366);
    freq.put("rc", 2704);
    freq.put("rl", 14368);
    freq.put("aja", 7514);
    freq.put("rn", 12088);
    freq.put("is ", 23018);
    freq.put("rh", 3147);
    freq.put("ri", 102805);
    freq.put("rj", 5203);
    freq.put("gor", 1284);
    freq.put("ntr", 1617);
    freq.put("ntu", 18006);
    freq.put("nti", 5215);
    freq.put("W", 10090);
    freq.put("nta", 22900);
    freq.put("nte", 7428);
    freq.put("ate", 14253);
    freq.put("ata", 52964);
    freq.put("ato", 2873);
    freq.put("atk", 1321);
    freq.put("isu", 1798);
    freq.put("ist", 11957);
    freq.put("isi", 11065);
    freq.put("atu", 20191);
    freq.put("r ", 75373);
    freq.put("ism", 1635);
    freq.put("isa", 7947);
    freq.put("ise", 5218);
    freq.put("on ", 12856);
    freq.put("nis", 7959);
    freq.put("tem", 9574);
    freq.put("tor", 4842);
    freq.put("tok", 1669);
    freq.put("ton", 2911);
    freq.put("tol", 2048);
    freq.put("tob", 1155);
    freq.put(" le", 5736);
    freq.put("B", 45618);
    freq.put(" la", 14587);
    freq.put(" lo", 1345);
    freq.put("mbe", 6808);
    freq.put(" li", 3289);
    freq.put(" lu", 3991);
    freq.put("Ser", 4461);
    freq.put("Sep", 1413);
    freq.put("ktu", 2650);
    freq.put("ktr", 1281);
    freq.put("kto", 2651);
    freq.put("Seb", 1132);
    freq.put("kte", 1325);
    freq.put("Sem", 1247);
    freq.put("Sel", 5571);
    freq.put("raf", 1467);
    freq.put("rag", 1442);
    freq.put("rad", 6359);
    freq.put("rab", 2762);
    freq.put("raa", 1221);
    freq.put("ran", 36962);
    freq.put("ral", 3814);
    freq.put("ram", 3611);
    freq.put("raj", 2995);
    freq.put("rak", 7284);
    freq.put("rah", 9741);
    freq.put("rai", 2568);
    freq.put("raw", 1318);
    freq.put("rat", 11399);
    freq.put("rar", 1749);
    freq.put("ras", 8094);
    freq.put("rap", 3154);
    freq.put("do ", 1904);
    freq.put("x ", 1658);
    freq.put("nen", 1469);
    freq.put("ra ", 33891);
    freq.put("y", 153007);
    freq.put("dok", 1141);
    freq.put("don", 16622);
    freq.put("m", 362974);
    freq.put("Ita", 1993);
    freq.put("uda", 4275);
    freq.put("sun", 2892);
    freq.put("\u4e00\u4e00", 1315);
    freq.put(" We", 1211);
    freq.put(" Wa", 3147);
    freq.put(" Wo", 1267);
    freq.put("d ", 16186);
    freq.put(" Wi", 2689);
    freq.put("em ", 3699);
    freq.put("sto", 1411);
    freq.put("ba ", 1212);
    freq.put("sur", 1552);
    freq.put("do", 23309);
    freq.put("di", 143405);
    freq.put("dd", 1120);
    freq.put("de", 45859);
    freq.put("da", 219838);
    freq.put("dy", 1437);
    freq.put("X", 1468);
    freq.put("du", 22038);
    freq.put("dr", 3663);
    freq.put("ds", 1430);
    freq.put("eme", 9102);
    freq.put("baw", 2021);
    freq.put("bat", 5802);
    freq.put("bar", 6280);
    freq.put("bas", 2119);
    freq.put("emb", 14950);
    freq.put("emo", 1229);
    freq.put("emi", 9424);
    freq.put("emu", 4943);
    freq.put("bag", 18039);
    freq.put("bad", 2660);
    freq.put("emp", 7479);
    freq.put("ban", 15219);
    freq.put("bal", 2565);
    freq.put("bak", 1477);
    freq.put("bah", 11866);
    freq.put("bai", 2045);
    freq.put("ggu", 3578);
    freq.put("om ", 1677);
    freq.put("w ", 1917);
    freq.put("nur", 1832);
    freq.put("nus", 2178);
    freq.put("Per", 8357);
    freq.put("nun", 2161);
    freq.put("Pem", 1634);
    freq.put("Pen", 3260);
    freq.put("nua", 1507);
    freq.put("il ", 7886);
    freq.put("mur", 7325);
    freq.put("un ", 20290);
    freq.put("iri", 9503);
    freq.put("irk", 1299);
    freq.put("mua", 1660);
    freq.put("mum", 2269);
    freq.put("Rus", 1267);
    freq.put("mun", 4790);
    freq.put("ire", 1684);
    freq.put("muk", 2006);
    freq.put("omb", 1474);
    freq.put("we", 3398);
    freq.put("wa", 31269);
    freq.put("wo", 1229);
    freq.put(" Ir", 1206);
    freq.put(" Is", 3262);
    freq.put(" It", 2123);
    freq.put("wi", 10306);
    freq.put("hak", 1134);
    freq.put(" In", 24109);
    freq.put(" Ia", 3220);
    freq.put(" Ib", 1298);
    freq.put("ham", 2420);
    freq.put("ile", 1187);
    freq.put("unt", 12867);
    freq.put("ell", 1619);
    freq.put("ila", 14804);
    freq.put("uny", 2077);
    freq.put("ill", 2052);
    freq.put("ilm", 5734);
    freq.put("ili", 13211);
    freq.put(" II", 1738);
    freq.put("unc", 1388);
    freq.put("und", 1967);
    freq.put("mu ", 1626);
    freq.put("ung", 21765);
    freq.put("ir ", 10536);
    freq.put("gga", 11266);
    freq.put(" me", 68772);
    freq.put(" ma", 16460);
    freq.put(" mo", 2739);
    freq.put(" mi", 4388);
    freq.put(" mu", 5887);
    freq.put("sah", 3766);
    freq.put("ggo", 2263);
    freq.put("san", 11536);
    freq.put("C ", 1897);
    freq.put("ai ", 28231);
    freq.put("Uta", 2484);
    freq.put("Ci", 2915);
    freq.put("Ch", 3483);
    freq.put("Co", 3999);
    freq.put("ait", 2311);
    freq.put("Ca", 4296);
    freq.put("ais", 1591);
    freq.put("air", 2314);
    freq.put("ain", 9801);
    freq.put("sli", 1139);
    freq.put("aik", 1989);
    freq.put("sla", 1693);
    freq.put("iy", 1200);
    freq.put("iz", 1367);
    freq.put("rtu", 2198);
    freq.put("ip", 11977);
    freq.put("is", 68271);
    freq.put("ir", 31102);
    freq.put("iu", 5028);
    freq.put("it", 40678);
    freq.put("iw", 2077);
    freq.put("iv", 4491);
    freq.put("ih", 9019);
    freq.put("ik", 61148);
    freq.put("ij", 2865);
    freq.put("im", 30225);
    freq.put("il", 48904);
    freq.put("io", 16681);
    freq.put("in", 117362);
    freq.put("ia", 81624);
    freq.put("ic", 8689);
    freq.put("ki ", 8986);
    freq.put("ie", 7742);
    freq.put("id", 19549);
    freq.put("ig", 10843);
    freq.put("if", 6720);
    freq.put("V ", 1165);
    freq.put("th ", 1540);
    freq.put("nik", 2713);
    freq.put("nin", 2190);
    freq.put("kis", 1425);
    freq.put("kir", 1475);
    freq.put("nia", 6702);
    freq.put("kit", 4346);
    freq.put("kin", 2100);
    freq.put("kim", 1495);
    freq.put("kil", 1164);
    freq.put("Y", 7072);
    freq.put("i ", 261146);
    freq.put("niv", 1591);
    freq.put("nit", 2077);
    freq.put("mil", 8646);
    freq.put("Vi", 1573);
    freq.put("ept", 1302);
    freq.put("epu", 3274);
    freq.put("the", 1811);
    freq.put("epe", 3912);
    freq.put("epa", 9668);
    freq.put("rn ", 1378);
    freq.put("eli", 4636);
    freq.put("hal", 1973);
    freq.put("elo", 2885);
    freq.put("han", 14832);
    freq.put("haa", 1690);
    freq.put("ela", 27699);
    freq.put("had", 1765);
    freq.put("ele", 4883);
    freq.put("har", 6037);
    freq.put("has", 12725);
    freq.put("hat", 1841);
    freq.put("elu", 8272);
    freq.put("opu", 1750);
    freq.put("D", 29898);
    freq.put("rna", 5736);
    freq.put("ope", 1909);
    freq.put("rny", 1495);
    freq.put("opa", 1279);
    freq.put("vis", 1830);
    freq.put("ha ", 2059);
    freq.put("el ", 6722);
    freq.put("Ara", 1730);
    freq.put("ola", 5593);
    freq.put("ole", 13717);
    freq.put(" Ju", 3129);
    freq.put("oli", 4593);
    freq.put("olo", 5388);
    freq.put(" Jo", 2086);
    freq.put(" Je", 6511);
    freq.put(" Ja", 10843);
    freq.put("umu", 2414);
    freq.put("ich", 1544);
    freq.put("ump", 1843);
    freq.put("for", 2821);
    freq.put("ica", 1838);
    freq.put("Hu", 2080);
    freq.put("rio", 1652);
    freq.put("Hi", 2733);
    freq.put("uma", 4069);
    freq.put("Ho", 2454);
    freq.put("umb", 3461);
    freq.put("uml", 1462);
    freq.put("Ha", 5613);
    freq.put("umi", 1414);
    freq.put("He", 2039);
    freq.put("ol ", 2833);
    freq.put("obe", 1842);
    freq.put("o", 305761);
    freq.put("um ", 7458);
    freq.put("aha", 23711);
    freq.put("mbi", 2114);
    freq.put("ahk", 1403);
    freq.put("ahi", 5150);
    freq.put("mba", 10647);
    freq.put("son", 1660);
    freq.put("ahu", 13410);
    freq.put("mbu", 4891);
    freq.put("wan", 5957);
    freq.put("git", 1200);
    freq.put("wak", 2165);
    freq.put("wah", 1890);
    freq.put("awa", 16458);
    freq.put("gia", 7505);
    freq.put("gio", 1293);
    freq.put("gin", 2402);
    freq.put("wat", 1765);
    freq.put("was", 1762);
    freq.put("war", 3553);
    freq.put("ah ", 131776);
    freq.put("Z", 2501);
    freq.put("ura", 9315);
    freq.put("wa ", 9713);
    freq.put("gi ", 10809);
    freq.put("khi", 1575);
    freq.put(" Li", 3097);
    freq.put("nny", 5115);
    freq.put("Sin", 1312);
    freq.put("ni", 56068);
    freq.put("nj", 13796);
    freq.put("nk", 3871);
    freq.put("nn", 7780);
    freq.put("no", 11352);
    freq.put("tit", 1315);
    freq.put("na", 77075);
    freq.put("tiv", 1124);
    freq.put("nc", 11437);
    freq.put("nd", 56574);
    freq.put("ne", 39080);
    freq.put("nf", 2387);
    freq.put("ng", 238792);
    freq.put("til", 2355);
    freq.put("ny", 39684);
    freq.put("nz", 1307);
    freq.put("tio", 3164);
    freq.put("tik", 7507);
    freq.put("tid", 3087);
    freq.put("tif", 2658);
    freq.put("ns", 21631);
    freq.put("nt", 61715);
    freq.put("nu", 12849);
    freq.put("E", 10468);
    freq.put(" no", 1685);
    freq.put(" na", 8812);
    freq.put(" ne", 5231);
    freq.put("n ", 334938);
    freq.put("rk ", 1641);
    freq.put("ti ", 10357);
    freq.put("rom", 1135);
    freq.put("ron", 3571);
    freq.put("rod", 2363);
    freq.put("rog", 1358);
    freq.put("osi", 2975);
    freq.put("lli", 1227);
    freq.put("oso", 1148);
    freq.put("rop", 2512);
    freq.put("lla", 1957);
    freq.put("ros", 2826);
    freq.put("rot", 1395);
    freq.put("rov", 9832);
    freq.put("ume", 1307);
    freq.put("gu ", 1706);
    freq.put("ver", 3522);
    freq.put("Dal", 2000);
    freq.put("di ", 63731);
    freq.put("ert", 16167);
    freq.put("ro ", 1992);
    freq.put("erp", 2943);
    freq.put("ll ", 1780);
    freq.put("dil", 3331);
    freq.put("dim", 2715);
    freq.put("din", 3800);
    freq.put("dio", 1486);
    freq.put("dik", 8070);
    freq.put("did", 3706);
    freq.put("ers", 10880);
    freq.put("gun", 9840);
    freq.put("dib", 6007);
    freq.put("gus", 2168);
    freq.put("p", 245252);
    freq.put("dit", 5425);
    freq.put("Tan", 2075);
    freq.put("dip", 4666);
    freq.put("der", 4755);
    freq.put("dir", 8308);
    freq.put("dis", 11623);
    freq.put("M ", 1852);
    freq.put(" Yo", 2043);
    freq.put(" Ya", 1612);
    freq.put("Rep", 1522);
    freq.put(" Yu", 2156);
    freq.put("erd", 7020);
    freq.put("ek ", 3218);
    freq.put("era", 35580);
    freq.put("Me", 8886);
    freq.put("rua", 2111);
    freq.put("Ma", 15663);
    freq.put("den", 19332);
    freq.put("Mo", 3510);
    freq.put("Mi", 3917);
    freq.put("Mu", 4166);
    freq.put("ngg", 24626);
    freq.put("Agu", 1534);
    freq.put("eko", 2677);
    freq.put("ekn", 1342);
    freq.put("eki", 2304);
    freq.put("eke", 1577);
    freq.put("eka", 8278);
    freq.put("bol", 2158);
    freq.put("eku", 2083);
    freq.put("ekt", 2574);
    freq.put("eks", 2683);
    freq.put("ipa", 2509);
    freq.put("ipe", 2501);
    freq.put("jar", 5491);
    freq.put("ipi", 1541);
    freq.put("ipu", 1250);
    freq.put(" Ka", 22393);
    freq.put(" Ke", 13629);
    freq.put(" Ki", 1879);
    freq.put("aya", 17559);
    freq.put(" Ko", 9805);
    freq.put(" Kr", 1679);
    freq.put(" Ku", 3543);
    freq.put("ayu", 1260);
    freq.put("ksa", 1691);
    freq.put("ul ", 3263);
    freq.put("ca ", 1339);
    freq.put("Ben", 1538);
    freq.put("Bel", 2649);
    freq.put("F", 12839);
    freq.put("Ber", 2116);
    freq.put(" ib", 1921);
    freq.put("ibi", 1510);
    freq.put("car", 5372);
    freq.put("ay ", 1252);
    freq.put("ult", 1653);
    freq.put("ulu", 3880);
    freq.put("uli", 4656);
    freq.put("can", 2310);
    freq.put("cam", 11583);
    freq.put("ula", 12496);
    freq.put("ibu", 4263);
    freq.put(" ol", 12623);
    freq.put("ger", 4633);
    freq.put(" of", 1811);
    freq.put("ma ", 21495);
    freq.put(" or", 4567);
    freq.put("spe", 1482);
    freq.put("nyi", 2079);
    freq.put("s ", 74416);
    freq.put("nye", 2679);
    freq.put("mas", 10730);
    freq.put("mar", 3160);
    freq.put("mat", 17173);
    freq.put("ena", 14758);
    freq.put("use", 1166);
    freq.put("mad", 1850);
    freq.put("mai", 3887);
    freq.put("mah", 2164);
    freq.put("mak", 3420);
    freq.put("mal", 1793);
    freq.put("man", 22564);
    freq.put("sy", 2246);
    freq.put("ss", 5417);
    freq.put("sp", 3394);
    freq.put("sw", 1219);
    freq.put("su", 25989);
    freq.put("st", 32797);
    freq.put("q", 2068);
    freq.put("si", 103815);
    freq.put("sh", 4276);
    freq.put("so", 6557);
    freq.put("sn", 2055);
    freq.put("sm", 3761);
    freq.put("sl", 3160);
    freq.put("sc", 1962);
    freq.put("sa", 100996);
    freq.put("se", 100046);
    freq.put("Ru", 2528);
    freq.put("Jaw", 4820);
    freq.put("no ", 2934);
    freq.put("Jan", 1394);
    freq.put("Re", 4622);
    freq.put("Ra", 5456);
    freq.put("Ro", 3385);
    freq.put("Ri", 1937);
    freq.put(" ab", 1554);
    freq.put(" ad", 60411);
    freq.put(" ag", 1308);
    freq.put("ssa", 1575);
    freq.put(" ak", 5080);
    freq.put(" al", 4506);
    freq.put(" ca", 3227);
    freq.put(" an", 11749);
    freq.put(" ap", 1720);
    freq.put(" ar", 2749);
    freq.put(" as", 3479);
    freq.put(" at", 18641);
    freq.put(" aw", 1213);
    freq.put("nol", 1247);
    freq.put("nom", 2318);
    freq.put("ng ", 124434);
    freq.put("kka", 1328);
    freq.put("em", 59371);
    freq.put("el", 59121);
    freq.put("eo", 11093);
    freq.put("en", 149316);
    freq.put("ei", 5982);
    freq.put("eh", 16895);
    freq.put("ek", 27553);
    freq.put("ej", 8227);
    freq.put("ee", 3361);
    freq.put("ed", 14792);
    freq.put("eg", 14415);
    freq.put("ef", 2165);
    freq.put("ea", 8168);
    freq.put("ec", 18556);
    freq.put("eb", 53877);
    freq.put("ey", 2387);
    freq.put("eu", 3102);
    freq.put("et", 34760);
    freq.put("ew", 5523);
    freq.put("ev", 3178);
    freq.put("ep", 21232);
    freq.put("es", 60149);
    freq.put("er", 212475);
    freq.put("Kel", 1127);
    freq.put("Kec", 4407);
    freq.put("eja", 5845);
    freq.put("bli", 2292);
    freq.put("yu ", 1225);
    freq.put("Ker", 1724);
    freq.put("Kep", 1438);
    freq.put("G", 16234);
    freq.put("rle", 9267);
    freq.put("ort", 1972);
    freq.put("rla", 2281);
    freq.put("e ", 42795);
    freq.put("oro", 1416);
    freq.put("orm", 2622);
    freq.put("ori", 3198);
    freq.put("org", 2231);
    freq.put("ord", 1550);
    freq.put("ore", 2472);
    freq.put("ora", 11685);
    freq.put("II ", 2070);
    freq.put("oni", 2889);
    freq.put("ono", 3029);
    freq.put("ona", 7292);
    freq.put("ong", 6397);
    freq.put("ond", 2230);
    freq.put("dia", 10670);
    freq.put("ua ", 5771);
    freq.put("ons", 2868);
    freq.put("ont", 3055);
    freq.put("iam", 1372);
    freq.put("ial", 6166);
    freq.put("ian", 16893);
    freq.put("uku", 6493);
    freq.put("uks", 1606);
    freq.put("uko", 1586);
    freq.put("uki", 1626);
    freq.put("iat", 1370);
    freq.put("iap", 1176);
    freq.put("ias", 3614);
    freq.put("hub", 1262);
    freq.put("hun", 11971);
    freq.put("hus", 1117);
    freq.put("yi ", 1127);
    freq.put("ia ", 44404);
    freq.put("r", 589018);
    freq.put("uk ", 22268);
    freq.put("and", 16448);
    freq.put("ane", 1770);
    freq.put("sai", 1253);
    freq.put("ang", 133187);
    freq.put("ana", 17620);
    freq.put("sam", 5305);
    freq.put("anc", 4861);
    freq.put("ann", 4127);
    freq.put("ano", 1219);
    freq.put("pri", 2203);
    freq.put("ani", 10218);
    freq.put("anj", 5111);
    freq.put("ank", 1863);
    freq.put("ant", 18067);
    freq.put("anu", 3628);
    freq.put("ans", 3241);
    freq.put("sas", 2791);
    freq.put("sar", 11521);
    freq.put("saw", 1247);
    freq.put("any", 11108);
    freq.put("sat", 14608);
    freq.put("Do", 1602);
    freq.put("Di", 6852);
    freq.put("De", 6798);
    freq.put("gku", 1576);
    freq.put("Da", 7353);
    freq.put("gka", 11656);
    freq.put("tny", 1162);
    freq.put("Du", 2494);
    freq.put("ts ", 1124);
    freq.put("an ", 259764);
    freq.put("iwa", 1676);
    freq.put("sa ", 26535);
    freq.put(" Le", 3183);
    freq.put(" La", 6277);
    freq.put(" Lo", 2414);
    freq.put("D ", 1256);
    freq.put(" Lu", 1657);
    freq.put("tka", 2458);
    freq.put("ge ", 1412);
    freq.put("ss ", 1345);
    freq.put("We", 1219);
    freq.put("Wa", 3162);
    freq.put("Wo", 1285);
    freq.put("iti", 3900);
    freq.put("Wi", 2707);
    freq.put(" pr", 10257);
    freq.put(" pu", 5843);
    freq.put("H", 16882);
    freq.put(" pa", 26959);
    freq.put(" pe", 52401);
    freq.put(" pi", 2294);
    freq.put(" po", 5413);
    freq.put("gen", 4341);
    freq.put("gem", 1548);
    freq.put("gel", 2369);
    freq.put("lum", 2455);
    freq.put("lny", 1353);
    freq.put("rmu", 1260);
    freq.put("rma", 9740);
    freq.put("tu ", 22458);
    freq.put("ur", 39636);
    freq.put("um", 25849);
    freq.put("tus", 3183);
    freq.put("ju", 15959);
    freq.put("tur", 4927);
    freq.put("utu", 1851);
    freq.put("tuj", 1345);
    freq.put("jo", 2256);
    freq.put("tul", 1791);
    freq.put("ji", 4743);
    freq.put("tun", 2681);
    freq.put("je", 5678);
    freq.put("ja", 34513);
    freq.put(" be", 42050);
    freq.put("z", 10934);
    freq.put(" ba", 29062);
    freq.put("C", 22345);
    freq.put(" bo", 2101);
    freq.put(" bi", 8314);
    freq.put("P ", 1286);
    freq.put(" bu", 6066);
    freq.put("s", 482635);
    freq.put("tuk", 15174);
    freq.put("tum", 1823);
    freq.put("por", 1652);
    freq.put("pos", 1337);
    freq.put("pop", 1746);
    freq.put("pon", 1531);
    freq.put("pol", 2768);
    freq.put("pok", 1819);
    freq.put("tua", 3005);
    freq.put("ei ", 1901);
    freq.put("mpe", 2325);
    freq.put("ein", 1306);
    freq.put("ive", 2266);
    freq.put("ivi", 1396);
    freq.put(" Me", 8848);
    freq.put("par", 4662);
    freq.put("pas", 2458);
    freq.put("pat", 19772);
    freq.put(" Ma", 15603);
    freq.put(" Mo", 3486);
    freq.put(" Mi", 3888);
    freq.put(" Mu", 4147);
    freq.put("pad", 19421);
    freq.put("I ", 4993);
    freq.put("pak", 16990);
    freq.put("pal", 3741);
    freq.put("pan", 11608);
    freq.put("I", 48750);
    freq.put("II", 2521);
    freq.put("Mar", 3752);
    freq.put("uju", 3230);
    freq.put("Is", 3276);
    freq.put("Ir", 1207);
    freq.put("It", 2124);
    freq.put("pa ", 5126);
    freq.put("In", 24134);
    freq.put("Ia", 3224);
    freq.put("Ib", 1304);
    freq.put("\u4e00", 3113);
    freq.put("sec", 2609);
    freq.put("am ", 27176);
    freq.put("tis", 2474);
    freq.put("Bal", 1493);
    freq.put("tim", 3584);
    freq.put("tin", 8673);
    freq.put("oko", 1983);
    freq.put("ami", 2968);
    freq.put("ama", 38387);
    freq.put("mor", 1409);
    freq.put("amb", 4802);
    freq.put("ame", 2230);
    freq.put("mon", 1666);
    freq.put("amp", 6554);
    freq.put("ib", 13081);
    freq.put("mod", 1185);
    freq.put("tig", 1707);
    freq.put("tia", 2861);
    freq.put("t", 522270);
    freq.put("Man", 2093);
    freq.put("Neg", 1421);
    freq.put(" co", 1499);
    freq.put("Men", 2499);
    freq.put(" ce", 1281);
    freq.put("Mer", 1254);
    freq.put("oo", 2776);
    freq.put("on", 61017);
    freq.put("aca", 2365);
    freq.put("ol", 35874);
    freq.put("ok", 11631);
    freq.put("ace", 1304);
    freq.put("km ", 1129);
    freq.put("og", 9163);
    freq.put("of", 3903);
    freq.put("oe", 1902);
    freq.put("ach", 1161);
    freq.put("oc", 2742);
    freq.put("ob", 5836);
    freq.put("oa", 2254);
    freq.put("ngo", 1466);
    freq.put("oy", 1610);
    freq.put("ow", 2582);
    freq.put("ov", 13798);
    freq.put("ou", 5529);
    freq.put("ot", 23779);
    freq.put("os", 12530);
    freq.put("or", 39625);
    freq.put("op", 9093);
    freq.put("Ni", 1382);
    freq.put("No", 3476);
    freq.put("Na", 5130);
    freq.put("Ne", 3573);
    freq.put("ngh", 3138);
    freq.put("Nu", 1142);
    freq.put("log", 4305);
    freq.put("her", 1241);
    freq.put("lok", 1231);
    freq.put("lon", 2362);
    freq.put("lom", 2722);
    freq.put("ehi", 1472);
    freq.put("jua", 1961);
    freq.put("jug", 4990);
    freq.put("juk", 1809);
    freq.put("J", 24390);
    freq.put("jun", 1767);
    freq.put("na ", 14205);
    freq.put("jum", 1474);
    freq.put("rja", 3509);
    freq.put("wal", 2130);
    freq.put("Ag", 2188);
    freq.put("as ", 18260);
    freq.put("he ", 2996);
    freq.put("eh ", 13927);
    freq.put("aa", 15819);
    freq.put("ac", 7825);
    freq.put("ab", 26392);
    freq.put("ae", 6490);
    freq.put("ad", 111448);
    freq.put("ag", 30377);
    freq.put("af", 4082);
    freq.put("ai", 50563);
    freq.put("ah", 179811);
    freq.put("ak", 85647);
    freq.put("aj", 9897);
    freq.put("am", 87049);
    freq.put("al", 170145);
    freq.put("an", 494871);
    freq.put("ap", 26307);
    freq.put("as", 93999);
    freq.put("ar", 156214);
    freq.put("au", 33011);
    freq.put("at", 148965);
    freq.put("aw", 19383);
    freq.put("av", 2545);
    freq.put("ay", 22914);
    freq.put("az", 1822);
    freq.put("igu", 3825);
    freq.put("ngu", 4341);
    freq.put("iga", 3238);
    freq.put("Lau", 1252);
    freq.put("a ", 312256);
    freq.put("oh ", 1516);
    freq.put("rr", 2177);
    freq.put("u", 508685);
    freq.put("Bri", 1173);
    freq.put("alo", 1291);
    freq.put("all", 1612);
    freq.put("ali", 20004);
    freq.put("pte", 1271);
    freq.put("ale", 3013);
    freq.put("ala", 101814);
    freq.put("eda", 4173);
    freq.put("gs", 5762);
    freq.put("alu", 3924);
    freq.put("Fil", 1716);
    freq.put("gr", 8256);
    freq.put("ty", 2279);
    freq.put("tt", 3054);
    freq.put("tu", 61107);
    freq.put("tr", 20074);
    freq.put("ts", 2489);
    freq.put("tn", 2005);
    freq.put("to", 20692);
    freq.put("tl", 1402);
    freq.put("tk", 2568);
    freq.put("th", 5635);
    freq.put("ti", 55141);
    freq.put("te", 90779);
    freq.put("ta", 176003);
    freq.put("edi", 3728);
    freq.put("ium", 1147);
    freq.put("smi", 1231);
    freq.put("iun", 2068);
    freq.put("mpo", 2760);
    freq.put("al ", 32136);
    freq.put("mpi", 3325);
    freq.put("mpu", 6558);
    freq.put("rm", 13211);
    freq.put("ruk", 1365);
    freq.put("sme", 1407);
    freq.put(" Ni", 1377);
    freq.put("gg", 24987);
    freq.put("pre", 1413);
    freq.put("ro", 34136);
    freq.put(" No", 3465);
    freq.put(" Na", 5110);
    freq.put(" Ne", 3562);
    freq.put("ge", 17252);
    freq.put("rk", 15615);
    freq.put(" Nu", 1139);
    freq.put("t ", 74952);
    freq.put("pul", 5693);
    freq.put("tek", 2322);
    freq.put("tel", 6089);
    freq.put("ga", 100134);
    freq.put("ten", 16531);
    freq.put("edu", 2208);
    freq.put("pun", 4895);
    freq.put("go", 7739);
    freq.put("ter", 45895);
    freq.put("tes", 1167);
    freq.put("tet", 1414);
    freq.put("aba", 6181);
    freq.put("gl", 1807);
    freq.put("sua", 5405);
    freq.put("abi", 1719);
    freq.put("sum", 1276);
    freq.put(" Ag", 2185);
    freq.put("suk", 5658);
    freq.put("sut", 1776);
    freq.put("sus", 2249);
    freq.put("abu", 12017);
    freq.put(" ru", 1822);
    freq.put("ggr", 3634);
    freq.put("te ", 2719);
    freq.put("K", 57099);
    freq.put("pua", 1330);
    freq.put(" re", 4944);
    freq.put(" ra", 4660);
    freq.put("pub", 1942);
    freq.put("mul", 2774);
    freq.put(" ro", 1171);
    freq.put("ggi", 3715);
    freq.put("ab ", 3122);
    freq.put("oma", 3069);
    freq.put(" Ar", 4490);
    freq.put("nto", 2680);
    freq.put("vin", 9845);
    freq.put("rke", 4730);
    freq.put("Aus", 1437);
    freq.put("rka", 5975);
    freq.put("S ", 1994);
    freq.put("rki", 1226);
    freq.put("de ", 5057);
    freq.put("Sy", 1338);
    freq.put("Sp", 1564);
    freq.put("Su", 10264);
    freq.put("St", 3734);
    freq.put("Si", 5355);
    freq.put("Sh", 2006);
    freq.put("So", 3044);
    freq.put("Sa", 8331);
    freq.put("umn", 1617);
    freq.put("Se", 18572);
    freq.put(" do", 1270);
    freq.put("ey ", 1761);
    freq.put("kla", 1828);
    freq.put(" di", 109723);
    freq.put("Int", 1699);
    freq.put(" de", 28323);
    freq.put("des", 7802);
    freq.put(" da", 93500);
    freq.put("dek", 2240);
    freq.put("del", 1249);
    freq.put("dem", 1173);
    freq.put("SM", 1268);
    freq.put("v", 31442);
    freq.put("Ind", 17352);
    freq.put(" du", 4523);
    freq.put("Ing", 3276);
    freq.put("pro", 9219);
    freq.put("go ", 1252);
    freq.put("f ", 6725);
    freq.put("lal", 2146);
    freq.put("ati", 9780);
    freq.put("rya", 1832);
    freq.put("fr", 1949);
    freq.put("ft", 1686);
    freq.put("fu", 1399);
    freq.put("fa", 4277);
    freq.put("fe", 4040);
    freq.put("fi", 10254);
    freq.put("fo", 4136);
    freq.put("a", 2100570);
    freq.put("ry ", 1765);
    freq.put("ne ", 3872);
    freq.put("egi", 2598);
    freq.put("ega", 7504);
    freq.put("ege", 2018);
    freq.put("ito", 1897);
    freq.put("uh ", 4643);
    freq.put("ce ", 2031);
    freq.put("y ", 11456);
    freq.put("ite", 4451);
    freq.put("ita", 13383);
    freq.put("ok ", 3549);
    freq.put("os ", 1902);
    freq.put("itu", 7300);
    freq.put(" Ok", 1169);
    freq.put("if ", 2797);
    freq.put(" Or", 1346);
    freq.put("yi", 2638);
    freq.put("Bat", 1605);
    freq.put("Bar", 4958);
    freq.put("yo", 3138);
    freq.put("uha", 3495);
    freq.put("ya", 121025);
    freq.put("ye", 4611);
    freq.put("L", 19113);
    freq.put("it ", 5451);
    freq.put("oka", 1673);
    freq.put("cer", 1324);
    freq.put("pai", 3130);
    freq.put("Ban", 5008);
    freq.put("ys", 1566);
    freq.put("yu", 3182);
    freq.put("Bah", 2306);
    freq.put("ifi", 1731);
    freq.put("dig", 4149);
    freq.put("Mus", 1132);
    freq.put(" sp", 1184);
    freq.put(" st", 3288);
    freq.put(" su", 11745);
    freq.put(" si", 6482);
    freq.put(" so", 1196);
    freq.put(" sa", 30188);
    freq.put(" se", 78628);
    freq.put("gur", 1410);
    freq.put("ass", 1429);
    freq.put(" Ab", 1471);
    freq.put(" Ac", 1711);
    freq.put(" Ad", 1437);
    freq.put("asu", 4212);
    freq.put("ast", 4229);
    freq.put("asy", 1183);
    freq.put(" Al", 4777);
    freq.put(" Am", 5319);
    freq.put(" An", 4070);
    freq.put(" Ap", 1628);
    freq.put("asa", 28749);
    freq.put(" As", 2567);
    freq.put(" Au", 2049);
    freq.put("ase", 1504);
    freq.put("ask", 2058);
    freq.put("Uni", 2252);
    freq.put("asi", 28272);
    freq.put("pur", 2238);
    freq.put("pus", 1843);
    freq.put("omp", 4769);
    freq.put("kon", 4219);
    freq.put("w", 50622);
    freq.put("Er", 1543);
    freq.put("koh", 1184);
    freq.put(" en", 1364);
    freq.put("kom", 5415);
    freq.put("kol", 2400);
    freq.put(" ek", 1536);
    freq.put("jen", 2753);
    freq.put("kot", 9086);
    freq.put("ncu", 1191);
    freq.put("odu", 2149);
    freq.put("nci", 3629);
    freq.put("nca", 3309);
    freq.put("nce", 1815);
    freq.put("ste", 6115);
    freq.put("b", 246328);
    freq.put("sta", 5899);
    freq.put("ko ", 1260);
    freq.put("aan", 12880);
    freq.put("sti", 6848);
    freq.put("aat", 2166);
    freq.put("str", 8471);
    freq.put("ka ", 12884);
    freq.put("k ", 77693);
    freq.put("lia", 5362);
    freq.put("lim", 6542);
    freq.put("lin", 6938);
    freq.put("lih", 1781);
    freq.put("lik", 11324);
    freq.put("lit", 5426);
    freq.put("lip", 1370);
    freq.put("lir", 1515);
    freq.put("lis", 7079);
    freq.put("kab", 2943);
    freq.put("kad", 1254);
    freq.put("kai", 2738);
    freq.put("M", 41589);
    freq.put("kan", 62967);
    freq.put("kam", 1705);
    freq.put("kal", 5122);
    freq.put("kas", 4851);
    freq.put("kar", 11177);
    freq.put("kap", 2757);
    freq.put("kaw", 1325);
    freq.put("Isl", 1234);
    freq.put("rha", 2148);
    freq.put("The", 1859);
    freq.put("ka", 127350);
    freq.put("li ", 7633);
    freq.put("ke", 56774);
    freq.put("kk", 1592);
    freq.put("ki", 23132);
    freq.put("kh", 4590);
    freq.put("ko", 27878);
    freq.put("kn", 3265);
    freq.put("km", 2765);
    freq.put("kl", 3754);
    freq.put("ks", 9835);
    freq.put("kr", 3523);
    freq.put("ku", 22809);
    freq.put("kt", 10395);
    freq.put("ky", 1397);
    freq.put("rte", 3710);
    freq.put("rta", 11752);
    freq.put("Han", 1227);
    freq.put("lay", 9124);
    freq.put("rti", 7667);
    freq.put("hi ", 1844);
    freq.put("Har", 1306);
    freq.put("Ju", 3132);
    freq.put("ies", 1321);
    freq.put("ier", 1178);
    freq.put("Jo", 2100);
    freq.put("Je", 6536);
    freq.put("Ja", 10872);
    freq.put("hir", 6378);
    freq.put("rt ", 1478);
    freq.put("ose", 2201);
    freq.put("hid", 1896);
    freq.put("hin", 3929);
    freq.put("ie ", 1390);
    freq.put(" Be", 8434);
    freq.put("ars", 1240);
    freq.put("art", 10017);
    freq.put("aru", 4864);
    freq.put("sep", 5282);
    freq.put("ary", 2056);
    freq.put(" Bo", 2979);
    freq.put(" Bi", 2483);
    freq.put(" Bu", 4209);
    freq.put("ara", 50200);
    freq.put("ik ", 17419);
    freq.put("ard", 2694);
    freq.put("are", 4682);
    freq.put("arg", 2616);
    freq.put("seo", 6619);
    freq.put("ari", 39797);
    freq.put("sem", 4262);
    freq.put("ark", 4616);
    freq.put("arl", 1195);
    freq.put("sej", 4109);
    freq.put("arn", 2327);
    freq.put("aro", 1477);
    freq.put("stu", 1610);
    freq.put("ses", 3161);
    freq.put("law", 2074);
    freq.put("kti", 1994);
    freq.put("iku", 2328);
    freq.put("ar ", 23543);
    freq.put("ika", 23689);
    freq.put("ike", 5441);
    freq.put("se ", 1750);
    freq.put("iki", 7614);
    freq.put("iko", 1474);
    freq.put("to ", 3427);
    freq.put(" Pr", 10827);
    freq.put("c", 70473);
    freq.put(" Pu", 4013);
    freq.put(" Pa", 12421);
    freq.put(" Pe", 15730);
    freq.put(" Pi", 2336);
    freq.put(" Po", 3467);
    freq.put("ga ", 16084);
    freq.put("pr", 13816);
    freq.put("ps", 1371);
    freq.put("duk", 5272);
    freq.put("dul", 1434);
    freq.put("pt", 3193);
    freq.put("pu", 23123);
    freq.put("dua", 3278);
    freq.put("dud", 2657);
    freq.put("pa", 90070);
    freq.put("pe", 68224);
    freq.put("dup", 1272);
    freq.put("ph", 1712);
    freq.put("pi", 13857);
    freq.put("po", 12602);
    freq.put("pl", 2952);
    freq.put("ty ", 1866);
    freq.put(" tu", 4514);
    freq.put("gat", 2080);
    freq.put("gas", 1879);
    freq.put(" tr", 2305);
    freq.put("N", 19093);
    freq.put(" to", 2153);
    freq.put("gan", 35620);
    freq.put("gam", 3520);
    freq.put("gal", 5628);
    freq.put("gai", 13025);
    freq.put("gah", 5405);
    freq.put(" te", 42313);
    freq.put(" ta", 18998);
    freq.put("sak", 1265);
    freq.put("mla", 1505);
    freq.put("du ", 1319);
    freq.put("p ", 11473);
    freq.put("rit", 4490);
    freq.put("ris", 9168);
    freq.put("rip", 1275);
    freq.put("rin", 9510);
    freq.put("Tim", 5598);
    freq.put("ril", 2736);
    freq.put("rim", 1709);
    freq.put("rik", 14926);
    freq.put("rid", 1193);
    freq.put("rie", 1621);
    freq.put("rib", 1211);
    freq.put("ric", 1356);
    freq.put("ria", 5936);
    freq.put("ewa", 3433);
    freq.put("sya", 1486);
    freq.put("ri ", 42938);
    freq.put("gsa", 3115);
    freq.put("kny", 1410);
    freq.put(" fi", 5527);
    freq.put(" fo", 1399);
    freq.put("amu", 2163);
    freq.put("rga", 5059);
    freq.put("sal", 14489);
    freq.put("rge", 1577);
    freq.put("bin", 3990);
    freq.put("bil", 2430);
    freq.put("Ok", 1174);
    freq.put("bih", 2863);
    freq.put("bid", 1129);
    freq.put("Dia", 1644);
    freq.put("bia", 3415);
    freq.put("bit", 1641);
    freq.put("bis", 1615);
    freq.put("d", 485064);
    freq.put("rg ", 1147);
    freq.put("b ", 5402);
    freq.put("ru ", 3013);
    freq.put("saa", 3516);
    freq.put("ija", 1503);
    freq.put("per", 28237);
    freq.put("pes", 2547);
    freq.put("pel", 2885);
    freq.put("pem", 8687);
    freq.put("pen", 20640);
    freq.put("id ", 2050);
    freq.put("be", 67748);
    freq.put("ruh", 2011);
    freq.put("run", 3050);
    freq.put("ba", 74854);
    freq.put("rum", 2131);
    freq.put("bl", 3420);
    freq.put("bo", 6681);
    freq.put("bi", 20522);
    freq.put("O", 9096);
    freq.put("bu", 59966);
    freq.put("br", 3158);
    freq.put("rus", 4704);
    freq.put("rup", 16158);
    freq.put("rut", 3005);
    freq.put("Rom", 1304);
    freq.put("idu", 1993);
    freq.put("idi", 3417);
    freq.put("ide", 3199);
    freq.put("ida", 6661);
    freq.put("nsi", 12613);
    freq.put(" ut", 3268);
    freq.put("kat", 13174);
    freq.put("nse", 1390);
    freq.put(" um", 2172);
    freq.put(" un", 12469);
    freq.put("nst", 1796);
    freq.put("ut ", 11892);
    freq.put("u ", 69102);
    freq.put(" Ch", 3462);
    freq.put(" Ci", 2897);
    freq.put(" Co", 3963);
    freq.put("ns ", 1443);
    freq.put("lka", 1991);
    freq.put(" Ca", 4213);
    freq.put(" Ce", 1368);
    freq.put("uta", 7869);
    freq.put("ute", 2083);
    freq.put("ut", 30979);
    freq.put("uti", 2003);
    freq.put("up", 32836);
    freq.put("us", 36462);
    freq.put("cil", 1660);
    freq.put("cis", 2553);
    freq.put("ul", 29290);
    freq.put("un", 84334);
    freq.put("ui", 4586);
    freq.put("uh", 9753);
    freq.put("uk", 44283);
    freq.put("uj", 4080);
    freq.put("ue", 2818);
    freq.put("ud", 13238);
    freq.put("ug", 8297);
    freq.put("uf", 1241);
    freq.put("ua", 56784);
    freq.put("uc", 2268);
    freq.put("ub", 9153);
    freq.put("Tu", 2495);
    freq.put("Tr", 1946);
    freq.put("To", 2609);
    freq.put("Th", 2978);
    freq.put("Ti", 8403);
    freq.put("Te", 9113);
    freq.put("Ta", 6615);
    freq.put("A ", 3175);
    freq.put("Mas", 1454);
    freq.put(" gu", 1601);
    freq.put(" gr", 1294);
    freq.put("nak", 8053);
    freq.put("nah", 2814);
    freq.put("nai", 1146);
    freq.put("nan", 12711);
    freq.put("nal", 12498);
    freq.put("nam", 10027);
    freq.put("nar", 2327);
    freq.put("nas", 5218);
    freq.put(" ge", 4483);
    freq.put("nat", 2083);
    freq.put("gra", 2940);
    freq.put("Mal", 2386);
    freq.put("gri", 3408);
    freq.put("T ", 1420);
    freq.put("Ac", 1714);
    freq.put("Ab", 1488);
    freq.put("e", 840847);
    freq.put("Ad", 1447);
    freq.put("agi", 8426);
    freq.put("age", 1445);
    freq.put("Am", 5332);
    freq.put("Al", 4784);
    freq.put("aga", 15818);
    freq.put("An", 4093);
    freq.put("Ap", 1629);
    freq.put("As", 2577);
    freq.put("Ar", 4506);
    freq.put("Au", 2055);
    freq.put("agu", 2010);
    freq.put(" b", 88325);
    freq.put(" c", 8643);
    freq.put("gu", 19428);
    freq.put(" a", 116958);
    freq.put(" f", 10185);
    freq.put(" g", 12086);
    freq.put(" d", 239066);
    freq.put(" e", 8087);
    freq.put(" j", 15556);
    freq.put(" k", 88933);
    freq.put(" h", 14754);
    freq.put(" i", 38006);
    freq.put(" n", 17327);
    freq.put(" o", 22384);
    freq.put(" l", 29162);
    freq.put(" m", 98895);
    freq.put(" r", 13775);
    freq.put(" s", 135289);
    freq.put(" p", 104408);
    freq.put(" v", 3008);
    freq.put(" w", 11107);
    freq.put(" t", 81597);
    freq.put(" u", 21958);
    freq.put(" z", 1713);
    freq.put("gn", 2069);
    freq.put(" y", 62811);
    freq.put("gk", 15524);
    freq.put("gi", 27056);
    freq.put("gh", 4457);
    freq.put(" B", 43424);
    freq.put(" C", 19640);
    freq.put(" A", 41294);
    freq.put(" F", 11657);
    freq.put(" G", 14895);
    freq.put(" D", 28065);
    freq.put(" E", 8736);
    freq.put(" J", 23985);
    freq.put(" K", 55803);
    freq.put(" H", 16124);
    freq.put(" I", 42065);
    freq.put(" N", 16611);
    freq.put(" O", 7318);
    freq.put(" L", 17821);
    freq.put(" M", 38172);
    freq.put(" R", 19599);
    freq.put(" S", 61440);
    freq.put(" P", 52451);
    freq.put(" Q", 1212);
    freq.put(" V", 4735);
    freq.put(" W", 9492);
    freq.put(" T", 36300);
    freq.put(" U", 10169);
    freq.put(" Z", 2373);
    freq.put("Nov", 1144);
    freq.put(" Y", 6861);
    freq.put("uga", 6118);
    freq.put("ch ", 1540);
    freq.put("ed ", 1578);
    freq.put("P", 55685);
    freq.put("g ", 127207);
    freq.put("tri", 6158);
    freq.put("evi", 1298);
    freq.put("tro", 2826);
    freq.put("tra", 8844);
    freq.put("us ", 12050);
    freq.put("iba", 3456);
    freq.put("tru", 1229);
    freq.put("le ", 2787);
    freq.put("zi", 2204);
    freq.put("za", 3196);
    freq.put("ibe", 2500);
    freq.put("ode", 3528);
    freq.put("rd ", 2133);
    freq.put("leb", 3217);
    freq.put("leh", 12733);
    freq.put("got", 2192);
    freq.put("lek", 2289);
    freq.put("z ", 1416);
    freq.put("lem", 2195);
    freq.put("len", 2677);
    freq.put("ler", 1546);
    freq.put("les", 2673);
    freq.put("let", 9284);
    freq.put("lev", 1141);
    freq.put("Yun", 1506);
    freq.put("hka", 1709);
    freq.put("rda", 4163);
    freq.put("rdi", 3109);
    freq.put(" Do", 1546);
    freq.put(" Di", 6832);
    freq.put(" De", 6775);
    freq.put("wil", 6167);
    freq.put(" Da", 7319);
    freq.put("apu", 2004);
    freq.put("api", 3283);
    freq.put(" Du", 2487);
    freq.put("apa", 12599);
    freq.put("cha", 1339);
    freq.put("Fr", 1829);
    freq.put("che", 1327);
    freq.put("usa", 6560);
    freq.put("chi", 1177);
    freq.put("usi", 7004);
    freq.put("Fa", 1382);
    freq.put("usu", 2654);
    freq.put("ust", 3983);
    freq.put("Fe", 1983);
    freq.put("Fi", 2806);
    freq.put("Fo", 1312);
    freq.put("wi ", 1323);
    freq.put("om", 19983);
    freq.put("ap ", 5145);
    freq.put(" Ru", 2526);
    freq.put("oi", 1595);
    freq.put("f", 36925);
    freq.put("oh", 4041);
    freq.put(" Re", 4599);
    freq.put("nda", 13200);
    freq.put(" Ra", 5409);
    freq.put(" Ro", 3363);
    freq.put(" Ri", 1930);
    freq.put("tat", 1881);
    freq.put("tau", 16309);
    freq.put("od", 8904);
    freq.put("tap", 2003);
    freq.put("tar", 15390);
    freq.put("tas", 11773);
    freq.put("tab", 1684);
    freq.put("tal", 4630);
    freq.put("tam", 7817);
    freq.put("tan", 48487);
    freq.put("tah", 16201);
    freq.put("tai", 3534);
    freq.put("tak", 12396);
    freq.put("sis", 6271);
    freq.put("sir", 1424);
    freq.put("uka", 7728);
    freq.put("afi", 1142);
    freq.put("Yo", 2051);
    freq.put("sit", 3002);
    freq.put("Ya", 1618);
    freq.put("sia", 23497);
    freq.put("sif", 1869);
    freq.put("sid", 1884);
    freq.put("sik", 5796);
    freq.put("sih", 1154);
    freq.put("Yu", 2161);
    freq.put("sin", 5946);
    freq.put("sim", 1558);
    freq.put("sil", 3164);
    freq.put("Q", 1321);
    freq.put("ta ", 30047);
    freq.put("siu", 2036);
    freq.put("ndu", 6040);
    freq.put("si ", 37996);
    freq.put("da ", 32556);
    freq.put("ld", 2217);
    freq.put("le", 44927);
    freq.put("lb", 1849);
    freq.put("la", 192799);
    freq.put("ln", 1524);
    freq.put("lo", 16018);
    freq.put("ll", 7645);
    freq.put("lm", 6776);
    freq.put("lk", 2913);
    freq.put("li", 60829);
    freq.put("lt", 3200);
    freq.put("lu", 24730);
    freq.put("ls", 1781);
    freq.put("ly", 1874);
    freq.put("dae", 2768);
    freq.put("dal", 74713);
    freq.put("dam", 1256);
    freq.put("dan", 52470);
    freq.put("dah", 2729);
    freq.put("dak", 4551);
    freq.put("dat", 2016);
    freq.put("dap", 6287);
    freq.put("dar", 32215);
    freq.put("das", 2265);
    freq.put("ema", 7624);
    freq.put("day", 1876);
    freq.put("Pre", 1253);
    freq.put("nya", 32061);
    freq.put("San", 2004);
    freq.put("l ", 56560);
    freq.put("sio", 5312);
    freq.put("Pro", 7786);
    freq.put(" hu", 2034);
    freq.put(" hi", 4380);
    freq.put(" ha", 6291);
    freq.put("oun", 1267);
    freq.put("h ", 162608);
    freq.put("res", 4698);
    freq.put("ret", 2887);
    freq.put("rej", 1691);
    freq.put("rek", 3031);
    freq.put("ren", 4953);
    freq.put("rea", 2388);
    freq.put("eca", 14054);
    freq.put("eci", 1667);
    freq.put("x", 3585);
    freq.put("g", 365165);
    freq.put("put", 3676);
    freq.put("lta", 1301);
    freq.put("re ", 2800);
    freq.put("rs ", 1283);
    freq.put("set", 3675);
    freq.put(" SM", 1160);
    freq.put(" Ba", 19679);
    freq.put("iha", 2592);
    freq.put("ser", 7000);
    freq.put(" Sy", 1332);
    freq.put(" Sp", 1555);
    freq.put(" St", 3681);
    freq.put(" Su", 10248);
    freq.put(" Sh", 1982);
    freq.put(" Si", 5333);
    freq.put(" So", 3026);
    freq.put(" Sa", 8312);
    freq.put(" Se", 18549);
    freq.put("Ka", 22425);
    freq.put("rsi", 3955);
    freq.put("Ke", 13666);
    freq.put("udu", 3551);
    freq.put("rse", 3931);
    freq.put("Ki", 1891);
    freq.put("Ko", 9825);
    freq.put("rsa", 2467);
    freq.put("ogr", 1789);
    freq.put("Kr", 1685);
    freq.put("R", 21435);
    freq.put("ogi", 3408);
    freq.put("Ku", 3549);
    freq.put("ih ", 5574);
    freq.put("udi", 2630);
    freq.put("bek", 1139);
    freq.put("ben", 5468);
    freq.put("bel", 6123);
    freq.put("beb", 2207);
    freq.put("nul", 1194);
    freq.put("bed", 1156);
    freq.put("sed", 1550);
    freq.put("ber", 44372);
    freq.put("bes", 5623);
    freq.put("seb", 38986);
    freq.put("Par", 2408);
    freq.put("Pas", 1289);
    freq.put(" Br", 3065);
    freq.put("Pad", 2035);
    freq.put("sen", 4315);
    freq.put("Pan", 1988);
    freq.put("sk", 6158);
    freq.put("mik", 1662);
    freq.put("sel", 6726);
    freq.put("ur ", 13684);
    freq.put("ck ", 1406);
    freq.put("min", 4316);
    freq.put("mia", 1700);
    freq.put("sek", 6032);
    freq.put("hr", 1702);
    freq.put("mis", 1673);
    freq.put("seh", 1426);
    freq.put("mit", 1227);
    freq.put("gha", 1865);
    freq.put("ht", 1424);
    freq.put("awi", 1328);
    freq.put("st ", 1847);
    freq.put(" Er", 1536);
    freq.put("mus", 3149);
    freq.put("hk", 1872);
    freq.put("mi ", 4545);
    freq.put("uri", 1909);
    freq.put("urk", 1245);
    freq.put("uru", 7051);
    freq.put("Pol", 1113);
    freq.put("hn", 2129);
    freq.put("hl", 1668);
    freq.put("Cha", 1289);
    freq.put("nge", 5034);
    freq.put("ha", 50757);
    freq.put("nga", 45848);
    freq.put("mud", 2039);
    freq.put(" is", 2175);
    freq.put(" it", 1708);
    freq.put("ngi", 5434);
    freq.put("ngk", 15500);
    freq.put("jan", 3425);
    freq.put("ae ", 1556);
    freq.put("jal", 2507);
    freq.put(" il", 1562);
    freq.put("jak", 2749);
    freq.put(" in", 24841);
    freq.put("ngs", 5639);
    freq.put(" ia", 3559);
    freq.put("jad", 5570);
    freq.put("jab", 1150);
    freq.put("jaa", 2051);
    freq.put("Ia ", 3146);
    freq.put("ira", 4533);
    freq.put("aer", 3528);
    freq.put("qu", 1325);
    freq.put(" wa", 3549);
    freq.put("h", 280863);
    freq.put(" wi", 6744);
    freq.put("ks ", 1167);
    freq.put("shi", 1399);
    freq.put("ja ", 5112);
    freq.put("Jak", 1458);
    freq.put("Pr", 10851);
    freq.put("ebe", 8142);
    freq.put("eba", 14092);
    freq.put("Pu", 4020);
    freq.put("ebi", 3337);
    freq.put("ke ", 5970);
    freq.put("jo ", 1155);
    freq.put("ebu", 26049);
    freq.put("Pa", 12458);
    freq.put("ebr", 1132);
    freq.put("Pe", 15767);
    freq.put("ede", 1589);
    freq.put("Pi", 2342);
    freq.put("Po", 3505);
    freq.put("lur", 4662);
    freq.put("lus", 1551);
    freq.put("ome", 2094);
    freq.put("\u0627", 1474);
    freq.put("lua", 4860);
    freq.put("et ", 5262);
    freq.put("lui", 1193);
    freq.put("luk", 2200);
    freq.put("omi", 2626);
    freq.put("lun", 1652);
    freq.put("ken", 6683);
    freq.put("kem", 4126);
    freq.put("kel", 7010);
    freq.put("kek", 1191);
    freq.put("omo", 1445);
    freq.put("ked", 2012);
    freq.put("kec", 8512);
    freq.put("keb", 2854);
    freq.put("S", 65231);
    freq.put("ket", 3912);
    freq.put("kes", 1631);
    freq.put("ker", 5150);
    freq.put("kep", 3726);
    freq.put("utr", 2712);
    freq.put("etu", 1676);
    freq.put("lu ", 3267);
    freq.put("eta", 14851);
    freq.put("ete", 4068);
    freq.put("eti", 4646);
    freq.put("ck", 2674);
    freq.put("ci", 8787);
    freq.put("ch", 7724);
    freq.put("co", 4648);
    freq.put("omu", 1988);
    freq.put("ca", 27397);
    freq.put("ce", 8123);
    freq.put("rpe", 1250);
    freq.put("cu", 3577);
    freq.put("ct", 1798);
    freq.put("Ger", 1344);
    freq.put("yat", 1924);
    freq.put("Jul", 1161);
    freq.put("yar", 2043);
    freq.put("yan", 64564);
    freq.put("yai", 2823);
    freq.put("yah", 7474);
    freq.put("yak", 4682);
    freq.put("oto", 2549);
    freq.put("ota", 16038);
    freq.put("c ", 1919);
    freq.put("ote", 1332);
    freq.put("unu", 2087);
    freq.put("Ang", 1356);
    freq.put("e\u0301", 2192);
    freq.put("rbu", 1584);
    freq.put("rbi", 1817);
    freq.put("rbe", 3317);
    freq.put("ya ", 33584);
    freq.put("rba", 6850);
    freq.put("va", 3932);
    freq.put(" Fr", 1822);
    freq.put("ve", 8269);
    freq.put("vi", 15930);
    freq.put("vo", 1681);
    freq.put(" Fa", 1366);
    freq.put(" Fe", 1977);
    freq.put(" Fi", 2802);
    freq.put(" Fo", 1303);
    freq.put("io ", 1907);
    freq.put("of ", 1858);
    freq.put("pis", 1169);
    freq.put("una", 10560);
    freq.put("une", 1335);
    freq.put("ion", 11007);
    freq.put("uni", 6942);
    freq.put("i", 864649);
    freq.put(" Tu", 2469);
    freq.put(" Tr", 1942);
    freq.put("ksi", 4460);
    freq.put(" To", 2586);
    freq.put(" Ti", 8388);
    freq.put(" Th", 2952);
    freq.put(" Te", 9090);
    freq.put(" Ta", 6595);
    freq.put("Be", 8472);
    freq.put("Ba", 19721);
    freq.put("Bo", 3000);
    freq.put("Bi", 2492);
    freq.put("Bu", 4215);
    freq.put("ade", 2164);
    freq.put("ska", 2806);
    freq.put("Br", 3076);
    freq.put("ada", 91074);
    freq.put("adi", 10057);
    freq.put("T", 39498);
    freq.put("Sam", 1292);
    freq.put("ad ", 3820);
    freq.put("nja", 9105);
    freq.put("ui ", 2114);
    freq.put("Sun", 2471);
    freq.put("Sum", 1934);
    freq.put("Sul", 1400);
    freq.put("Sur", 1395);
    freq.put("nju", 2843);
    freq.put("esu", 1622);
    freq.put("est", 3135);
    freq.put("ess", 1214);
    freq.put("nd ", 3909);
    freq.put("ese", 3800);
    freq.put("esa", 15867);
    freq.put("esi", 21745);
    freq.put("Ut", 2746);
    freq.put("lle", 1326);
    freq.put("Un", 3136);
    freq.put("ndi", 8610);
    freq.put("dun", 4005);
    freq.put("ndo", 17880);
    freq.put(" ju", 6965);
    freq.put("nde", 4365);
    freq.put("es ", 8727);
    freq.put(" je", 2335);
    freq.put("ndr", 1343);
    freq.put(" ja", 5269);
    freq.put("ea ", 1655);
    freq.put("bu ", 2451);
    freq.put("Ame", 4085);
    freq.put("bur", 1967);
    freq.put("bup", 9962);
    freq.put("Des", 2124);
    freq.put("but", 6527);
    freq.put("hu", 19954);
    freq.put("buk", 3601);
    freq.put("buh", 2607);
    freq.put("hi", 19755);
    freq.put("bun", 4326);
    freq.put("ho", 5306);
    freq.put("bul", 1642);
    freq.put("bum", 1823);
    freq.put("bua", 22699);
    freq.put("he", 8947);
    freq.put("dus", 1247);
    freq.put("Ten", 4508);
    freq.put("j", 64260);
    freq.put("Ter", 1521);
    freq.put("pil", 1386);
    freq.put("iny", 3792);
    freq.put("pin", 3678);
    freq.put("int", 9752);
    freq.put("ins", 11171);
    freq.put("lm ", 4360);
    freq.put("inn", 1767);
    freq.put("ino", 1354);
    freq.put("ini", 22825);
    freq.put("ink", 1199);
    freq.put("ind", 4767);
    freq.put("ine", 2698);
    freq.put("ing", 27890);
    freq.put("ina", 9693);
    freq.put("Or", 1349);
    freq.put(" Ut", 2746);
    freq.put(" Un", 3130);
    freq.put("or ", 7039);
    freq.put("ubu", 2471);
    freq.put("pi ", 3245);
    freq.put("gar", 10391);
    freq.put("U", 11179);
    freq.put("uba", 1945);
    freq.put("ubl", 2137);
    freq.put("gap", 1320);
    freq.put("in ", 16335);
    freq.put("eor", 7717);
    freq.put("hny", 1246);
    freq.put("o ", 23320);
  }
  
}

