package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HU extends CLangProfile {
  private static final String name = "hu";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HU() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 10929783;
    n_words[1] = 12338513;
    n_words[2] = 8457220;

    freq.put("lo\u030bt", 1770);
    freq.put(" ke\u0301", 11002);
    freq.put(" ki\u0301", 1660);
    freq.put("alm", 6541);
    freq.put(" ko\u0308", 27883);
    freq.put(" ku\u0308", 3017);
    freq.put("ja\u0301n", 4452);
    freq.put("e\u0301l ", 2635);
    freq.put("e\u0301rs", 1117);
    freq.put("e\u0301rt", 4687);
    freq.put("e\u0301ri", 1359);
    freq.put("aur", 1366);
    freq.put("aut", 1403);
    freq.put("Ez ", 1152);
    freq.put("e\u0301re", 3670);
    freq.put("e\u0301rf", 1845);
    freq.put("ja\u0301k", 1953);
    freq.put(" Gr", 1700);
    freq.put("ero\u030b", 1876);
    freq.put(" Gy", 1279);
    freq.put("dje\u0301", 9456);
    freq.put(" Ge", 1837);
    freq.put(" Ga", 2065);
    freq.put("ra ", 14404);
    freq.put(" Go", 1438);
    freq.put("vu\u030b ", 1466);
    freq.put("ala", 25236);
    freq.put("lo\u030b ", 3629);
    freq.put("aku\u0301", 5988);
    freq.put("e\u0301le", 4096);
    freq.put("Gr", 1713);
    freq.put("e\u0301lk", 1173);
    freq.put("Gy", 1283);
    freq.put("e\u0301li", 2101);
    freq.put("Ge", 1854);
    freq.put("e\u0301k ", 14028);
    freq.put("mu\u030b", 8899);
    freq.put("Ga", 2079);
    freq.put("Go", 1444);
    freq.put("zda", 1164);
    freq.put("e\u0301ly", 3515);
    freq.put(" ka", 7871);
    freq.put("me ", 1765);
    freq.put(" ke", 13720);
    freq.put(" ki", 17579);
    freq.put(" ko", 9227);
    freq.put(" km", 2432);
    freq.put(" kr", 1168);
    freq.put("o\u030b ", 26112);
    freq.put(" ku", 2128);
    freq.put("fe\u0301r", 1780);
    freq.put("nel", 1635);
    freq.put("nem", 11176);
    freq.put("nek", 17344);
    freq.put("neg", 1502);
    freq.put("kus", 4984);
    freq.put("gna", 2223);
    freq.put("ers", 4641);
    freq.put("eke", 7178);
    freq.put("net", 3267);
    freq.put("a\u0301ro", 12322);
    freq.put("o\u0301l ", 13016);
    freq.put("nes", 2093);
    freq.put("fe\u0301l", 10120);
    freq.put("o\u030bs", 10918);
    freq.put("o\u030br", 2463);
    freq.put("o\u030bt", 2983);
    freq.put("o\u030bv", 2032);
    freq.put("orr", 2134);
    freq.put("o\u030bz", 2353);
    freq.put("mek", 1223);
    freq.put("ors", 11126);
    freq.put("met", 6641);
    freq.put("o\u030bb", 2103);
    freq.put("o\u030be", 1463);
    freq.put("o\u030bd", 2691);
    freq.put("o\u030bg", 1179);
    freq.put("mer", 9128);
    freq.put("o\u030bi", 2735);
    freq.put("o\u030bk", 4433);
    freq.put("o\u030bj", 2432);
    freq.put("o\u030bl", 9494);
    freq.put("o\u030bn", 2715);
    freq.put("ti\u0301v", 1267);
    freq.put("lmi", 2811);
    freq.put("akr", 1682);
    freq.put("k", 454857);
    freq.put("roc", 1647);
    freq.put("aku", 2116);
    freq.put("e\u0301le\u0301", 8715);
    freq.put("akk", 1936);
    freq.put("aki", 3799);
    freq.put("ako", 5426);
    freq.put("aka", 2195);
    freq.put("lo\u0308n", 2431);
    freq.put("der", 2519);
    freq.put("nk ", 1863);
    freq.put("e\u0301ro\u030b", 1195);
    freq.put("o\u0308r ", 1444);
    freq.put("bri", 1367);
    freq.put("lma", 4921);
    freq.put("u\u0308gg", 1434);
    freq.put("bra", 1211);
    freq.put("Nag", 2455);
    freq.put("m ", 27269);
    freq.put("ene\u0301", 1314);
    freq.put("si\u0301t", 5115);
    freq.put("er ", 12986);
    freq.put("io\u0301 ", 2881);
    freq.put("ni ", 7437);
    freq.put("A\u0301", 2646);
    freq.put("nka", 1134);
    freq.put("o\u0308rt", 3402);
    freq.put("o\u0308rz", 1373);
    freq.put(" me\u0301", 4247);
    freq.put("go\u0308r", 2727);
    freq.put("ova\u0301", 8369);
    freq.put("V", 10406);
    freq.put("me", 75090);
    freq.put("erv", 3920);
    freq.put("ma", 45288);
    freq.put("err", 1968);
    freq.put("mb", 11466);
    freq.put("mm", 4364);
    freq.put("ml", 3581);
    freq.put("mo", 16948);
    freq.put("mn", 1344);
    freq.put("mi", 28248);
    freq.put("erz", 2655);
    freq.put("mu", 7004);
    freq.put("ere", 20225);
    freq.put("erg", 1768);
    freq.put("mp", 6217);
    freq.put("ms", 1960);
    freq.put("erc", 2570);
    freq.put("erm", 4064);
    freq.put("ern", 2834);
    freq.put("ero", 1595);
    freq.put("eri", 12722);
    freq.put("erj", 2568);
    freq.put("mz", 4734);
    freq.put("Le", 3145);
    freq.put("La", 4095);
    freq.put("Lo", 1996);
    freq.put("la ", 5399);
    freq.put("Li", 2545);
    freq.put("to\u030b ", 4350);
    freq.put("hog", 3581);
    freq.put("ib", 5712);
    freq.put("end", 20330);
    freq.put("ene", 6376);
    freq.put("eng", 4545);
    freq.put("hon", 1202);
    freq.put("eni", 2643);
    freq.put("hol", 2205);
    freq.put("enl", 1598);
    freq.put("enn", 3397);
    freq.put("ens", 3074);
    freq.put("hor", 2048);
    freq.put("hos", 1589);
    freq.put("sse", 3446);
    freq.put("eny", 3762);
    freq.put("hoz", 7697);
    freq.put("A", 98368);
    freq.put("nka\u0301", 1105);
    freq.put("lan", 5737);
    freq.put("o\u0308ro\u0308", 5177);
    freq.put("laj", 1625);
    freq.put("lak", 15098);
    freq.put("lad", 1437);
    freq.put("lag", 3296);
    freq.put("etu\u0308", 1875);
    freq.put("lab", 1923);
    freq.put("o\u0308ru\u0308", 1396);
    freq.put("ova", 1834);
    freq.put("ove", 1321);
    freq.put("lat", 10133);
    freq.put("ovi", 1122);
    freq.put("lap", 6224);
    freq.put("re ", 12803);
    freq.put("las", 4338);
    freq.put("en ", 52180);
    freq.put("faj", 8821);
    freq.put("ci\u0301m", 4480);
    freq.put("ma\u0301", 27550);
    freq.put("mi\u0301", 1861);
    freq.put("me\u0301", 15355);
    freq.put("era\u0301", 1228);
    freq.put("mo\u0301", 2093);
    freq.put("ere\u0301", 4519);
    freq.put("mu\u0301", 1197);
    freq.put("ra\u0301g", 1665);
    freq.put("ra\u0301b", 2450);
    freq.put("fal", 3069);
    freq.put("rta\u0301", 1222);
    freq.put("zek", 2284);
    freq.put("ra\u0301l", 4428);
    freq.put("zen", 10515);
    freq.put("zel", 4337);
    freq.put("zem", 3342);
    freq.put("zer", 19180);
    freq.put("zes", 1480);
    freq.put("oni", 3479);
    freq.put(" Ho", 2631);
    freq.put("ra\u0301s", 8381);
    freq.put("zet", 19059);
    freq.put(" Ha", 3587);
    freq.put(" He", 2393);
    freq.put("zak", 6902);
    freq.put("ro\u0308", 8024);
    freq.put("ro\u0301", 12762);
    freq.put("ru\u0308", 11432);
    freq.put("e\u0301ko", 2177);
    freq.put("ru\u0301", 3555);
    freq.put("imp", 1521);
    freq.put("fia", 1202);
    freq.put("ra\u0301", 28508);
    freq.put("ri\u0301", 1306);
    freq.put("fin", 1712);
    freq.put("re\u0301", 19532);
    freq.put("fil", 2271);
    freq.put(" Va", 2262);
    freq.put("ze ", 4791);
    freq.put(" Ve", 1647);
    freq.put(" Vi", 2142);
    freq.put("bo\u0301l", 6420);
    freq.put("gyu\u030b", 1250);
    freq.put("one", 1152);
    freq.put("eru\u030b", 1796);
    freq.put("o\u030btt", 1492);
    freq.put("ata\u0301", 8809);
    freq.put("i\u0301to\u0301", 2222);
    freq.put("l", 670215);
    freq.put("i\u0301te\u0301", 2953);
    freq.put("ato\u0301", 6586);
    freq.put("i\u0301ta\u0301", 3043);
    freq.put("Cse", 1140);
    freq.put("a\u0301ho", 4041);
    freq.put("ako\u0308", 2063);
    freq.put("ru\u030b ", 1401);
    freq.put("nt ", 15590);
    freq.put("rt", 47601);
    freq.put("ru", 7619);
    freq.put("rv", 8829);
    freq.put("gv", 1711);
    freq.put("rp", 2572);
    freq.put("rr", 6334);
    freq.put("rs", 21922);
    freq.put(" ze", 2004);
    freq.put("u\u0301go\u0301", 1191);
    freq.put("ajt", 2171);
    freq.put("e\u0301lt", 1344);
    freq.put("rz", 5827);
    freq.put("rd", 9230);
    freq.put("re", 67985);
    freq.put("rf", 3837);
    freq.put("rg", 7757);
    freq.put("ra", 55047);
    freq.put("ajn", 3205);
    freq.put("rc", 7289);
    freq.put("rl", 4279);
    freq.put("aja", 1802);
    freq.put("rn", 9437);
    freq.put("ro", 47249);
    freq.put("ajd", 2547);
    freq.put("ri", 45410);
    freq.put("rj", 4223);
    freq.put("rk", 7954);
    freq.put("nty", 1140);
    freq.put("Egy", 3037);
    freq.put("pja\u0301", 1227);
    freq.put("nti", 4462);
    freq.put("e\u0301r ", 1942);
    freq.put("ntj", 1553);
    freq.put("W", 4434);
    freq.put("nta", 2379);
    freq.put("nte", 5991);
    freq.put("a\u0301zi", 1122);
    freq.put("ate", 2686);
    freq.put("atb", 1153);
    freq.put("ata", 7891);
    freq.put("iss", 1661);
    freq.put("a\u0301za", 2446);
    freq.put("atl", 1204);
    freq.put("ath", 1161);
    freq.put("ati", 9317);
    freq.put("isk", 1278);
    freq.put("att", 4210);
    freq.put("r ", 40419);
    freq.put("i\u0301to", 2971);
    freq.put("ism", 3684);
    freq.put("aj ", 6376);
    freq.put(" Sp", 1107);
    freq.put("ise", 2504);
    freq.put("i\u0301te", 4142);
    freq.put("o\u0308ss", 4328);
    freq.put("ra\u0301n", 5049);
    freq.put("gy ", 37866);
    freq.put("fu\u0308g", 1411);
    freq.put("tek", 7221);
    freq.put("yik", 7147);
    freq.put("osa", 4828);
    freq.put("nis", 2046);
    freq.put("tem", 4106);
    freq.put("toz", 15230);
    freq.put("tor", 5700);
    freq.put("tos", 4461);
    freq.put("tot", 7575);
    freq.put("tok", 4029);
    freq.put("ton", 3995);
    freq.put("ri ", 7426);
    freq.put("tol", 3082);
    freq.put("tom", 3113);
    freq.put("la\u0301l", 4812);
    freq.put(" le", 17706);
    freq.put("B", 24663);
    freq.put(" la", 7930);
    freq.put(" lo", 1099);
    freq.put("gym", 1148);
    freq.put("la\u0301g", 4159);
    freq.put("gyk", 1565);
    freq.put(" li", 2353);
    freq.put("gyh", 1320);
    freq.put("o\u0308s ", 1742);
    freq.put("gys", 4096);
    freq.put("la\u0301t", 1961);
    freq.put("teg", 2075);
    freq.put("la\u0301s", 5210);
    freq.put("a\u0301ra\u0301", 5593);
    freq.put("i\u0301", 56628);
    freq.put("to ", 1211);
    freq.put("rag", 1242);
    freq.put("rad", 2745);
    freq.put("rab", 2185);
    freq.put("ro\u030b", 4773);
    freq.put("ran", 7745);
    freq.put("ral", 2852);
    freq.put("ram", 2669);
    freq.put("raj", 1914);
    freq.put("rak", 6278);
    freq.put("rai", 1551);
    freq.put("rat", 3432);
    freq.put("ras", 2085);
    freq.put("ter", 19863);
    freq.put("ru\u030b", 2676);
    freq.put("alo\u0301", 3345);
    freq.put("Az ", 14884);
    freq.put("rse", 2444);
    freq.put("on ", 14829);
    freq.put("mba", 2545);
    freq.put(" la\u0301", 2021);
    freq.put("i\u0301to\u030b", 1100);
    freq.put("abb", 3158);
    freq.put(" le\u0301", 4236);
    freq.put("y", 242745);
    freq.put("abd", 1557);
    freq.put("gyu\u0308", 2858);
    freq.put("don", 3362);
    freq.put("dol", 1610);
    freq.put("dom", 3952);
    freq.put("nto\u030b", 1470);
    freq.put("m", 298372);
    freq.put("uda", 1985);
    freq.put("ko\u0308d", 1357);
    freq.put("dor", 1576);
    freq.put("dot", 2319);
    freq.put("e\u0301z", 4750);
    freq.put("e\u0301p", 16482);
    freq.put("e\u0301s", 84643);
    freq.put("e\u0301r", 22242);
    freq.put("e\u0301t", 19103);
    freq.put("d ", 20001);
    freq.put(" Wi", 1310);
    freq.put("e\u0301h", 4561);
    freq.put("e\u0301k", 26204);
    freq.put("e\u0301j", 1119);
    freq.put("e\u0301m", 6476);
    freq.put("e\u0301l", 30309);
    freq.put("e\u0301n", 36437);
    freq.put("e\u0301c", 1321);
    freq.put("e\u0301b", 17184);
    freq.put("e\u0301d", 3694);
    freq.put("e\u0301pu\u0308", 1343);
    freq.put("ock", 1291);
    freq.put("zti", 1839);
    freq.put("em ", 9006);
    freq.put(" u\u0301j", 1846);
    freq.put("zte", 5806);
    freq.put("oga", 3293);
    freq.put("sto", 1355);
    freq.put("zta", 2495);
    freq.put("kul", 4809);
    freq.put("ba ", 10534);
    freq.put("ira\u0301", 5579);
    freq.put("ztr", 2410);
    freq.put("dn", 1552);
    freq.put("do", 18282);
    freq.put("oma\u0301", 8665);
    freq.put("dj", 21891);
    freq.put("ne\u0301l", 1390);
    freq.put("di", 23518);
    freq.put("ke\u0301s", 3743);
    freq.put("dd", 1273);
    freq.put("de", 31392);
    freq.put("db", 1466);
    freq.put("ne\u0301g", 1166);
    freq.put("da", 33610);
    freq.put("ke\u0301k", 1183);
    freq.put("nev", 9590);
    freq.put("dz", 1317);
    freq.put("ke\u0301n", 3827);
    freq.put("dv", 2240);
    freq.put("e\u0301 ", 4130);
    freq.put("dt", 3427);
    freq.put("du", 4251);
    freq.put("dr", 4675);
    freq.put("ds", 5503);
    freq.put("yi ", 5728);
    freq.put("eme", 6876);
    freq.put("ak ", 42544);
    freq.put("bar", 1493);
    freq.put("ila\u0301", 4340);
    freq.put("eml", 2503);
    freq.put("pu\u0308l", 4756);
    freq.put("emi", 1303);
    freq.put("zt ", 3494);
    freq.put("bad", 1154);
    freq.put("yez", 2468);
    freq.put("emp", 1725);
    freq.put("ban", 38532);
    freq.put("bal", 3567);
    freq.put("baj", 2665);
    freq.put("do\u0301 ", 3604);
    freq.put("emz", 4591);
    freq.put("om ", 4999);
    freq.put("e\u0301pe", 3380);
    freq.put("job", 1168);
    freq.put("nus", 1717);
    freq.put("e\u0301ps", 1130);
    freq.put("nul", 2608);
    freq.put("kok", 2194);
    freq.put("mut", 1302);
    freq.put("zte\u0301", 2691);
    freq.put("mus", 1737);
    freq.put("zta\u0301", 11872);
    freq.put("lte", 3310);
    freq.put("iro", 2666);
    freq.put("ira", 1291);
    freq.put("mun", 2084);
    freq.put("ire", 1148);
    freq.put("omb", 2831);
    freq.put("e\u0301p ", 2557);
    freq.put("di\u0301", 4512);
    freq.put("wa", 1485);
    freq.put("de\u0301", 9871);
    freq.put("omi", 1564);
    freq.put(" Is", 1400);
    freq.put("omo", 2114);
    freq.put("elh", 1530);
    freq.put("wi", 1167);
    freq.put("da\u0301", 7767);
    freq.put(" In", 4206);
    freq.put("yba", 1297);
    freq.put("do\u0308", 1970);
    freq.put("eln", 2146);
    freq.put("do\u0301", 5588);
    freq.put("ile", 2438);
    freq.put("ell", 9606);
    freq.put("ila", 1887);
    freq.put("e\u0301ba", 2195);
    freq.put("ill", 7614);
    freq.put("ilm", 1881);
    freq.put("eme\u0301", 3302);
    freq.put("e\u0301be", 12999);
    freq.put("ili", 3110);
    freq.put("uni", 1375);
    freq.put("unk", 2047);
    freq.put(" me", 30782);
    freq.put(" ma", 18644);
    freq.put("lo\u0301g", 2572);
    freq.put("io\u0301", 9250);
    freq.put(" mo", 4422);
    freq.put(" mi", 10796);
    freq.put(" mu", 2133);
    freq.put("ia\u0301", 11532);
    freq.put("o\u0301pa", 1701);
    freq.put("ele", 27299);
    freq.put("san", 2277);
    freq.put("fra", 1911);
    freq.put("rga", 1547);
    freq.put("a\u0301li", 4198);
    freq.put("ve\u0301d", 2112);
    freq.put("mez", 3626);
    freq.put("ai ", 23587);
    freq.put("ona\u0301", 1361);
    freq.put("no\u030bs", 2336);
    freq.put("nia\u0301", 1146);
    freq.put("els", 6778);
    freq.put("kia\u0301", 3411);
    freq.put("ank", 1265);
    freq.put("epu\u0308", 3424);
    freq.put("Ch", 2651);
    freq.put("Co", 4107);
    freq.put("ait", 1256);
    freq.put("Ca", 4180);
    freq.put("Ce", 1232);
    freq.put("n", 579901);
    freq.put("ain", 2508);
    freq.put("gla", 1955);
    freq.put("Cs", 2770);
    freq.put("sle", 1305);
    freq.put("di\u0301j", 1758);
    freq.put("do\u030b", 5431);
    freq.put("iz", 8720);
    freq.put(" ma\u0301", 8283);
    freq.put("ip", 5320);
    freq.put("is", 42797);
    freq.put("ir", 14921);
    freq.put("iu", 6023);
    freq.put("it", 23842);
    freq.put("iv", 7173);
    freq.put("ii", 3341);
    freq.put("ih", 1907);
    freq.put("ik", 46279);
    freq.put("ij", 1228);
    freq.put("im", 8040);
    freq.put("il", 27833);
    freq.put("io", 8559);
    freq.put("in", 53934);
    freq.put("ia", 30517);
    freq.put("ic", 13315);
    freq.put("akt", 1697);
    freq.put("ie", 7180);
    freq.put("id", 22338);
    freq.put("ig", 15930);
    freq.put("if", 9201);
    freq.put("V ", 1123);
    freq.put("osz", 17179);
    freq.put("di\u0301t", 1872);
    freq.put("ko\u0308l", 1449);
    freq.put("th ", 1102);
    freq.put("\u0441", 1133);
    freq.put("nik", 2308);
    freq.put("kis", 3777);
    freq.put("kir", 2041);
    freq.put("nia", 2714);
    freq.put("to\u0301l", 4069);
    freq.put("nid", 1544);
    freq.put("kit", 1528);
    freq.put("kik", 1160);
    freq.put("kin", 1795);
    freq.put("kil", 1182);
    freq.put("Y", 1303);
    freq.put("i ", 117842);
    freq.put("kia", 2258);
    freq.put("kif", 1538);
    freq.put("mil", 1543);
    freq.put("Va", 2270);
    freq.put("Ve", 1656);
    freq.put("Vi", 2150);
    freq.put("ko\u0308t", 1840);
    freq.put("epl", 1338);
    freq.put("epi", 1162);
    freq.put("the", 2658);
    freq.put("epe", 2041);
    freq.put("tha", 1854);
    freq.put("yei", 1140);
    freq.put("ola\u0301", 1371);
    freq.put("yek", 4530);
    freq.put("zok", 2301);
    freq.put("yel", 9386);
    freq.put("yen", 2702);
    freq.put("zol", 2432);
    freq.put("yed", 1362);
    freq.put("olo\u0301", 3495);
    freq.put("yes", 5416);
    freq.put("yer", 1837);
    freq.put("yet", 5968);
    freq.put("elj", 2109);
    freq.put("elk", 2863);
    freq.put("haj", 2261);
    freq.put("eli", 3526);
    freq.put("hal", 5044);
    freq.put("elo", 1349);
    freq.put("han", 3792);
    freq.put("elm", 4378);
    freq.put("ela", 1439);
    freq.put("had", 1308);
    freq.put("hag", 1327);
    freq.put("ely", 23022);
    freq.put(" a\u0301t", 2658);
    freq.put("har", 4293);
    freq.put("has", 5102);
    freq.put("hat", 10778);
    freq.put("elt", 4823);
    freq.put("opt", 1890);
    freq.put("rni", 1311);
    freq.put("D", 13198);
    freq.put("ko\u0308n", 3656);
    freq.put("ye ", 3860);
    freq.put("rna", 1947);
    freq.put("rne", 1337);
    freq.put("ko\u0308v", 1585);
    freq.put("rny", 1765);
    freq.put("ko\u0308r", 4099);
    freq.put("opo", 3410);
    freq.put("ko\u0308z", 23037);
    freq.put("so\u0308k", 1579);
    freq.put("vis", 3046);
    freq.put("ha ", 1609);
    freq.put("el ", 15987);
    freq.put("jes", 2679);
    freq.put("ola", 3942);
    freq.put("olc", 1133);
    freq.put("old", 2725);
    freq.put("olg", 2986);
    freq.put("oli", 4956);
    freq.put("oll", 1909);
    freq.put("oln", 1426);
    freq.put("olo", 2069);
    freq.put(" Jo", 1515);
    freq.put("ols", 1101);
    freq.put("olt", 11581);
    freq.put("olu", 1943);
    freq.put(" i\u0301r", 3245);
    freq.put(" Je", 1288);
    freq.put("no\u030b", 6159);
    freq.put(" Ja", 1919);
    freq.put("ici", 1201);
    freq.put("ich", 2336);
    freq.put("for", 12637);
    freq.put("tei", 1486);
    freq.put("ica", 2195);
    freq.put("ice", 1195);
    freq.put("zo\u0308r", 1244);
    freq.put("fog", 4106);
    freq.put("uma", 1476);
    freq.put("Ho", 2637);
    freq.put("elu\u0308", 5526);
    freq.put("umb", 1113);
    freq.put("ics", 1889);
    freq.put("fon", 1546);
    freq.put("Ha", 3592);
    freq.put("He", 2397);
    freq.put("ol ", 3707);
    freq.put("ide\u0301", 1418);
    freq.put("plo", 1196);
    freq.put("obb", 3582);
    freq.put("o", 467276);
    freq.put("um ", 4397);
    freq.put(" no\u030b", 1649);
    freq.put("meg", 18261);
    freq.put("zul", 1547);
    freq.put("a\u0301na", 12065);
    freq.put("mbe", 4662);
    freq.put("sok", 5478);
    freq.put("a\u0301no", 1436);
    freq.put("a\u0301ni", 2143);
    freq.put("son", 4142);
    freq.put("a\u0301nu", 1287);
    freq.put("sor", 6863);
    freq.put("elo\u030b", 7242);
    freq.put("a\u0301ny", 14546);
    freq.put("ne\u0301", 20022);
    freq.put("art", 20941);
    freq.put("git", 1317);
    freq.put("az ", 35775);
    freq.put("na\u0301", 12107);
    freq.put("gia", 2402);
    freq.put("no\u0301", 1459);
    freq.put("no\u0308", 2962);
    freq.put(" ne\u0301", 13996);
    freq.put("io\u0301s", 1792);
    freq.put("a\u0301n ", 13154);
    freq.put("Z", 4534);
    freq.put(" no\u0308", 1405);
    freq.put("azi", 1454);
    freq.put("azo", 3899);
    freq.put("i\u0301rt", 1125);
    freq.put("aza", 1771);
    freq.put("azd", 1290);
    freq.put("azg", 1460);
    freq.put("azz", 1187);
    freq.put("gi ", 5691);
    freq.put("azt", 1117);
    freq.put("u\u0308t", 3250);
    freq.put("u\u0308r", 1396);
    freq.put("nni", 1136);
    freq.put("kor", 12163);
    freq.put("nne", 2064);
    freq.put("u\u0308z", 1153);
    freq.put("nna", 2413);
    freq.put("u\u0308g", 2645);
    freq.put("nny", 1741);
    freq.put("oly", 9282);
    freq.put("u\u0308n", 2126);
    freq.put("u\u0308l", 37857);
    freq.put("u\u0308k", 3502);
    freq.put("nh", 1725);
    freq.put("ni", 26541);
    freq.put("nj", 1322);
    freq.put("nk", 8011);
    freq.put("nl", 3257);
    freq.put("nn", 10307);
    freq.put("no", 16464);
    freq.put("na", 50058);
    freq.put("nb", 3564);
    freq.put("nc", 11966);
    freq.put("nd", 37316);
    freq.put("ne", 56223);
    freq.put("nf", 2395);
    freq.put("ng", 19748);
    freq.put("til", 2521);
    freq.put("ny", 61139);
    freq.put("nz", 2533);
    freq.put("tio", 2102);
    freq.put("tik", 5482);
    freq.put("ha\u0301r", 2058);
    freq.put("ns", 9377);
    freq.put("nt", 48640);
    freq.put("nu", 6592);
    freq.put("E", 18562);
    freq.put(" no", 1409);
    freq.put("o\u0301sz", 1200);
    freq.put(" na", 5781);
    freq.put(" ne", 18984);
    freq.put(" ny", 10296);
    freq.put("ele\u0301", 3820);
    freq.put("la\u0301n", 2463);
    freq.put("plo\u030b", 1147);
    freq.put("n ", 153664);
    freq.put("aza\u0301", 1314);
    freq.put("i\u0301ro\u0301", 2841);
    freq.put("rk ", 1195);
    freq.put("ti ", 14986);
    freq.put("i\u0301ra\u0301", 2059);
    freq.put("rok", 2835);
    freq.put("rol", 2608);
    freq.put("rom", 4552);
    freq.put("ron", 3143);
    freq.put("oss", 3713);
    freq.put("e\u0301lo\u030b", 1204);
    freq.put("rod", 2730);
    freq.put("ost", 2095);
    freq.put("rog", 1810);
    freq.put("roz", 4272);
    freq.put("llo", 1404);
    freq.put("oso", 1195);
    freq.put("rop", 1359);
    freq.put("ror", 2542);
    freq.put("ros", 13308);
    freq.put("rot", 1270);
    freq.put("rov", 1366);
    freq.put("nop", 1219);
    freq.put("vet", 5802);
    freq.put("zto", 1911);
    freq.put("ver", 7753);
    freq.put("ves", 3105);
    freq.put("di ", 3532);
    freq.put("yve", 2842);
    freq.put("ven", 5494);
    freq.put("vel", 6375);
    freq.put("o\u0301 ", 44110);
    freq.put("vek", 3167);
    freq.put(" do", 1754);
    freq.put("lre", 1816);
    freq.put("io\u0301j", 1245);
    freq.put("fol", 3847);
    freq.put("os ", 17347);
    freq.put("ll ", 3110);
    freq.put("o\u0301z", 2079);
    freq.put("din", 2017);
    freq.put("dik", 7071);
    freq.put("o\u0301s", 5892);
    freq.put("o\u0301r", 2907);
    freq.put("o\u0301p", 3032);
    freq.put("o\u0308g ", 1983);
    freq.put("o\u0301v", 1296);
    freq.put("o\u0301t", 4344);
    freq.put("o\u0301k", 6328);
    freq.put("p", 129287);
    freq.put("o\u0301i", 2619);
    freq.put("rma\u0301", 4220);
    freq.put("o\u0301n", 2969);
    freq.put("o\u0301m", 2752);
    freq.put("o\u0301l", 15303);
    freq.put("o\u0301c", 1867);
    freq.put("o\u0301b", 3397);
    freq.put("o\u0301a", 1234);
    freq.put("o\u0301g", 4159);
    freq.put("o\u0301f", 2044);
    freq.put("o\u0301d", 5384);
    freq.put("llo\u0301", 2888);
    freq.put("la\u0301d", 12468);
    freq.put("osi\u0301", 1185);
    freq.put("lli\u0301", 1578);
    freq.put("osa\u0301", 2471);
    freq.put("lla\u0301", 2364);
    freq.put("erd", 1315);
    freq.put("ge\u0301s", 1802);
    freq.put("rul", 1250);
    freq.put("ge\u0301p", 2262);
    freq.put("je\u0301n", 1719);
    freq.put("o\u030bk ", 2201);
    freq.put("je\u0301h", 3083);
    freq.put("ek ", 33389);
    freq.put("ge\u0301b", 1114);
    freq.put("ge\u0301n", 2847);
    freq.put("rva", 1143);
    freq.put("era", 2862);
    freq.put("Me", 3040);
    freq.put("Ma", 10861);
    freq.put("erb", 2020);
    freq.put("Mo", 3340);
    freq.put("Mi", 3545);
    freq.put("u\u0308le\u0301", 2870);
    freq.put("ga\u0301r", 1661);
    freq.put("Mu", 1674);
    freq.put("eki", 1276);
    freq.put("ga\u0301n", 1121);
    freq.put("su\u030b", 1526);
    freq.put("ekb", 1825);
    freq.put("u\u030b", 27405);
    freq.put("jed", 1383);
    freq.put("bol", 1519);
    freq.put("vo\u030b ", 1785);
    freq.put("erk", 1552);
    freq.put("e\u0301ve", 6732);
    freq.put("ngo", 3206);
    freq.put(" Ka", 3809);
    freq.put("te\u0301z", 2544);
    freq.put(" Ke", 1641);
    freq.put("te\u0301t", 2097);
    freq.put(" Ki", 3002);
    freq.put(" Ko", 2859);
    freq.put("te\u0301r", 3350);
    freq.put("ja\u0301h", 2978);
    freq.put(" Kr", 1178);
    freq.put("te\u0301n", 6927);
    freq.put("nye\u0301", 1280);
    freq.put("nyi\u0301", 1276);
    freq.put("ul ", 10317);
    freq.put("ca ", 1909);
    freq.put("e\u0301v ", 4758);
    freq.put("F", 13797);
    freq.put("su\u0301", 4418);
    freq.put("zna\u0301", 3356);
    freq.put("su\u0308", 3136);
    freq.put("so\u0301", 2652);
    freq.put("so\u0308", 2411);
    freq.put("ult", 3281);
    freq.put("se\u0301", 27679);
    freq.put("si\u0301", 6485);
    freq.put("sa\u0301", 25703);
    freq.put("ula", 2897);
    freq.put(" ol", 6794);
    freq.put("za\u0301m", 6211);
    freq.put(" ok", 1477);
    freq.put("ger", 3980);
    freq.put(" of", 1186);
    freq.put("a\u0301m ", 1135);
    freq.put("ma ", 5513);
    freq.put("do\u030b ", 2164);
    freq.put("spo", 1141);
    freq.put("spa", 1306);
    freq.put(" or", 4197);
    freq.put(" os", 10567);
    freq.put("nys", 1658);
    freq.put("ssz", 9449);
    freq.put("nyv", 3444);
    freq.put("nyt", 1370);
    freq.put("nyu", 2805);
    freq.put("nyi", 4978);
    freq.put(" Ko\u0308", 2904);
    freq.put("nyo", 6087);
    freq.put("nyb", 1400);
    freq.put("s ", 157503);
    freq.put("nye", 12400);
    freq.put("mas", 1406);
    freq.put("mar", 2289);
    freq.put("mat", 4172);
    freq.put("a\u0301mo", 1867);
    freq.put("a\u0301ma", 1434);
    freq.put("maz", 4614);
    freq.put("uga", 4002);
    freq.put("enc", 3429);
    freq.put("mad", 7309);
    freq.put("mag", 9145);
    freq.put("mai", 2750);
    freq.put("maj", 1342);
    freq.put("mal", 2064);
    freq.put("man", 2348);
    freq.put("de\u0301l", 3343);
    freq.put("sz", 174760);
    freq.put("jel", 12132);
    freq.put("zi\u0301", 5603);
    freq.put("de\u0301k", 1979);
    freq.put("ss", 22768);
    freq.put("sr", 3213);
    freq.put("sp", 4512);
    freq.put("sv", 2378);
    freq.put("su", 4875);
    freq.put("st", 26226);
    freq.put("q", 1410);
    freq.put("si", 20642);
    freq.put("sh", 2900);
    freq.put("so", 26449);
    freq.put("sn", 2526);
    freq.put("sm", 5506);
    freq.put("sl", 2577);
    freq.put("sc", 3372);
    freq.put("sb", 5688);
    freq.put("sa", 40529);
    freq.put("ula\u0301", 1430);
    freq.put("sf", 1789);
    freq.put("se", 34881);
    freq.put("sd", 1132);
    freq.put("pi\u0301t", 3633);
    freq.put("sa\u0301n", 1607);
    freq.put("sa\u0301b", 4560);
    freq.put("ea\u0301", 1335);
    freq.put("Re", 2307);
    freq.put("tti", 1842);
    freq.put("Ra", 1803);
    freq.put("sa\u0301r", 2700);
    freq.put("tta", 4727);
    freq.put("Ro", 2833);
    freq.put("lsz", 1378);
    freq.put(" pi", 1682);
    freq.put("tte", 6235);
    freq.put("sod", 2739);
    freq.put(" ad", 3539);
    freq.put("eje\u0301", 1183);
    freq.put("ssa", 2570);
    freq.put(" ak", 3658);
    freq.put(" al", 19507);
    freq.put(" am", 14965);
    freq.put(" an", 8296);
    freq.put("gen", 2834);
    freq.put("dja", 1819);
    freq.put(" ar", 2746);
    freq.put(" as", 2187);
    freq.put("vtu", 1747);
    freq.put(" au", 2171);
    freq.put("ent", 14391);
    freq.put(" az", 39674);
    freq.put("tja", 3013);
    freq.put("oru\u0301", 1625);
    freq.put("nok", 4021);
    freq.put("sol", 2274);
    freq.put("ert", 6946);
    freq.put("o\u0308vi", 1986);
    freq.put("kke", 2328);
    freq.put("ng ", 3420);
    freq.put("o\u0308ve", 4144);
    freq.put("tt ", 30966);
    freq.put("ze\u0301", 19023);
    freq.put("nos", 3762);
    freq.put(" a ", 114242);
    freq.put("sop", 2367);
    freq.put("a\u0301ci", 2905);
    freq.put("a\u0301cs", 1314);
    freq.put("em", 38648);
    freq.put("el", 138888);
    freq.put("eo", 3448);
    freq.put("en", 123802);
    freq.put("ei", 11205);
    freq.put("eh", 6429);
    freq.put("ek", 55065);
    freq.put("ej", 8422);
    freq.put("ee", 2573);
    freq.put("ed", 20502);
    freq.put("eg", 88315);
    freq.put("ef", 4014);
    freq.put("ea", 6887);
    freq.put("ec", 7541);
    freq.put("eb", 8727);
    freq.put("tte\u0301", 1199);
    freq.put("ey", 1469);
    freq.put("ex", 2202);
    freq.put("ez", 42514);
    freq.put("eu", 3957);
    freq.put("et", 109362);
    freq.put("tta\u0301", 1546);
    freq.put("ev", 16778);
    freq.put("ep", 13034);
    freq.put("es", 66857);
    freq.put("er", 112461);
    freq.put("ejl", 2010);
    freq.put("eje", 2098);
    freq.put("o\u030bje", 1778);
    freq.put("dja\u0301", 9950);
    freq.put("ejt", 1562);
    freq.put("mo\u0301d", 1366);
    freq.put("tja\u0301", 2955);
    freq.put("mu\u030b ", 3511);
    freq.put("nic", 1428);
    freq.put("G", 13466);
    freq.put("orv", 1840);
    freq.put("ort", 5009);
    freq.put("rla", 1110);
    freq.put("e ", 99285);
    freq.put("orn", 2184);
    freq.put("oro", 8033);
    freq.put("orm", 10619);
    freq.put("o\u0308ve\u0301", 1547);
    freq.put("ori", 4752);
    freq.put("org", 1652);
    freq.put("ord", 2929);
    freq.put("ore", 1109);
    freq.put("orb", 1551);
    freq.put("lme", 1597);
    freq.put("ora", 2591);
    freq.put("o\u0301ja", 2231);
    freq.put("Szl", 3665);
    freq.put("Sza", 1311);
    freq.put("Sze", 2596);
    freq.put("da\u0301r", 1447);
    freq.put("yug", 2984);
    freq.put("zal", 1294);
    freq.put("xi", 1625);
    freq.put("ono", 2799);
    freq.put("zad", 1388);
    freq.put("ona", 4624);
    freq.put("zab", 2585);
    freq.put("ong", 1637);
    freq.put("ond", 2206);
    freq.put("dia", 1805);
    freq.put("ony", 4114);
    freq.put("u\u0301ak", 6906);
    freq.put("ons", 1750);
    freq.put("zat", 8108);
    freq.put("a\u0301lo\u0301", 2208);
    freq.put("ont", 8687);
    freq.put("Eur", 1570);
    freq.put("ial", 1462);
    freq.put("ian", 2020);
    freq.put("iai", 5083);
    freq.put("De\u0301", 1163);
    freq.put("iad", 1714);
    freq.put("e\u0301gy", 1459);
    freq.put("e\u0301ge", 6434);
    freq.put("e\u0301gb", 1296);
    freq.put("lso\u030b", 6342);
    freq.put("iat", 1462);
    freq.put("e\u0301gi", 4433);
    freq.put("ma\u0301s", 7074);
    freq.put("ma\u0301r", 3617);
    freq.put("x ", 2815);
    freq.put("za\u0301", 31274);
    freq.put("egy", 47388);
    freq.put("za ", 3143);
    freq.put("ma\u0301j", 1466);
    freq.put("ma\u0301n", 10674);
    freq.put("rze", 1233);
    freq.put("lha", 4212);
    freq.put("ia ", 14894);
    freq.put("eru\u0308", 9565);
    freq.put("r", 536637);
    freq.put("rzs", 1300);
    freq.put("e\u0301g ", 10442);
    freq.put("ehe", 2302);
    freq.put("zsi", 1572);
    freq.put("uk ", 1640);
    freq.put("and", 5977);
    freq.put("ane", 1370);
    freq.put("a\u0301ll", 11176);
    freq.put("ang", 7307);
    freq.put("ana", 3610);
    freq.put("a\u0301lh", 2859);
    freq.put("anc", 3826);
    freq.put("sab", 1704);
    freq.put("ann", 3140);
    freq.put("ano", 1477);
    freq.put("pri", 1456);
    freq.put("ani", 3989);
    freq.put("a\u0301la", 2623);
    freq.put("ant", 4051);
    freq.put("anu", 1841);
    freq.put("lo\u0301s", 1760);
    freq.put("a\u0301ly", 14827);
    freq.put("sas", 1771);
    freq.put("a\u0301lt", 12559);
    freq.put("sap", 1951);
    freq.put("any", 6283);
    freq.put("sat", 1742);
    freq.put("Do", 1533);
    freq.put("omm", 1333);
    freq.put("zu\u0308", 5181);
    freq.put("Di", 1628);
    freq.put("lna", 1780);
    freq.put("De", 2255);
    freq.put(" a\u0301l", 11522);
    freq.put("zom", 1281);
    freq.put("zon", 5431);
    freq.put("Da", 1481);
    freq.put("zor", 2657);
    freq.put("\u0435", 1700);
    freq.put("Du", 1186);
    freq.put("e\u0301ge\u0301", 2685);
    freq.put("an ", 50569);
    freq.put("lo\u0301 ", 6853);
    freq.put("sa ", 7871);
    freq.put("a\u0301l ", 2859);
    freq.put(" Le", 3135);
    freq.put(" La", 4057);
    freq.put(" Lo", 1988);
    freq.put(" Li", 2524);
    freq.put("lli", 2652);
    freq.put("zse\u0301", 5276);
    freq.put("tke", 1731);
    freq.put("ge ", 3243);
    freq.put("ede\u0301", 2069);
    freq.put("rme\u0301", 1800);
    freq.put("a\u0301ba", 23979);
    freq.put("a\u0301bb", 3556);
    freq.put("iti", 1991);
    freq.put("Wi", 1325);
    freq.put("a\u0301bo", 1867);
    freq.put("\u0430", 2749);
    freq.put("u\u0308lo\u0308", 2566);
    freq.put("ges", 2578);
    freq.put(" pr", 3595);
    freq.put("ju\u0301", 2913);
    freq.put("get", 4617);
    freq.put("H", 13530);
    freq.put("li\u0301t", 2551);
    freq.put("jo\u0301", 1888);
    freq.put(" pa", 5441);
    freq.put("uta", 3446);
    freq.put("je\u0301", 12386);
    freq.put(" pe", 2664);
    freq.put("gek", 1625);
    freq.put("zu\u0301", 1280);
    freq.put(" po", 4686);
    freq.put("ja\u0301", 30832);
    freq.put("gel", 2023);
    freq.put(" ba\u0301", 1342);
    freq.put(" be\u0301", 1167);
    freq.put("o\u0301", 117740);
    freq.put("no\u0308v", 1656);
    freq.put("uto", 1342);
    freq.put("tko\u0308", 1448);
    freq.put("rma", 4453);
    freq.put("us", 30910);
    freq.put("rme", 7442);
    freq.put("lne", 1797);
    freq.put("sva\u0301", 1185);
    freq.put("j ", 9703);
    freq.put("fo\u0308l", 2822);
    freq.put("ye\u0301b", 2439);
    freq.put("u\u0308le", 10807);
    freq.put("a\u0301bo\u0301", 2969);
    freq.put("zhe", 2186);
    freq.put("u\u0308lt", 4085);
    freq.put("te\u0301k", 6622);
    freq.put("jz", 1414);
    freq.put("jt", 5016);
    freq.put("ju", 2496);
    freq.put("tur", 1775);
    freq.put("tus", 2989);
    freq.put("jl", 2908);
    freq.put("jn", 3362);
    freq.put("jo", 4214);
    freq.put("sse\u0301", 2608);
    freq.put("tum", 1120);
    freq.put("jd", 2673);
    freq.put("je", 23937);
    freq.put(" pe\u0301", 1624);
    freq.put("ssa\u0301", 1740);
    freq.put("ja", 22570);
    freq.put(" be", 18442);
    freq.put(" ba", 7443);
    freq.put(" bo", 2566);
    freq.put("u\u0308l ", 11962);
    freq.put(" bi", 2851);
    freq.put(" pa\u0301", 3006);
    freq.put(" bu", 1302);
    freq.put("s", 637262);
    freq.put("usz", 5860);
    freq.put("tve", 3654);
    freq.put("tul", 1430);
    freq.put("por", 4386);
    freq.put("pos", 1197);
    freq.put("pon", 4538);
    freq.put("pol", 3552);
    freq.put("tud", 4114);
    freq.put("o\u030bi ", 1993);
    freq.put("o\u0308lt", 2040);
    freq.put("ei ", 4004);
    freq.put("zpo", 1664);
    freq.put("Bud", 1205);
    freq.put("E\u0301", 1936);
    freq.put("lcs", 2466);
    freq.put("aja\u0301", 1272);
    freq.put("eit", 1126);
    freq.put("lye", 12093);
    freq.put("yha\u0301", 1178);
    freq.put("ein", 1947);
    freq.put("ive", 1942);
    freq.put("iva", 2264);
    freq.put("ka\u0301b", 1589);
    freq.put("e\u0301te", 4730);
    freq.put("oks", 2384);
    freq.put("zis", 1133);
    freq.put("u\u0308lo\u030b", 1827);
    freq.put("e\u0301tr", 1526);
    freq.put("okt", 1201);
    freq.put("pap", 1164);
    freq.put(" Me", 3025);
    freq.put("par", 3913);
    freq.put("lyo", 1466);
    freq.put("pat", 2664);
    freq.put(" Ma", 10822);
    freq.put(" Mo", 3325);
    freq.put(" Mi", 3523);
    freq.put("khe", 1740);
    freq.put(" Mu", 1669);
    freq.put("ora\u0301", 3688);
    freq.put("cen", 1114);
    freq.put("I ", 2334);
    freq.put("Ta", 2278);
    freq.put("pan", 2344);
    freq.put("I", 14875);
    freq.put("e\u0301t ", 8716);
    freq.put("ka\u0301n", 1252);
    freq.put("II", 1513);
    freq.put("it ", 5468);
    freq.put("gio\u0301", 1365);
    freq.put("ka\u0301l", 1176);
    freq.put("ze\u0301s", 6463);
    freq.put("nte\u0301", 5969);
    freq.put("o\u0301ja\u0301", 1365);
    freq.put("tiz", 1109);
    freq.put("e\u0301pi\u0301", 1687);
    freq.put("Is", 1406);
    freq.put("pa ", 1509);
    freq.put("okb", 1937);
    freq.put("In", 4213);
    freq.put("ha\u0301b", 1477);
    freq.put("\u4e00", 1237);
    freq.put("a\u0301c", 4739);
    freq.put("a\u0301b", 34134);
    freq.put("ro\u0308g", 2754);
    freq.put("a\u0301d", 14308);
    freq.put("a\u0301g", 29984);
    freq.put("ro\u0308k", 1818);
    freq.put("am ", 2190);
    freq.put("a\u0301k", 18338);
    freq.put("a\u0301j", 7251);
    freq.put("a\u0301m", 8760);
    freq.put("a\u0301l", 59120);
    freq.put("a\u0301n", 50938);
    freq.put("a\u0301p", 2119);
    freq.put("a\u0301s", 47264);
    freq.put("a\u0301s ", 11271);
    freq.put("a\u0301u", 1148);
    freq.put("a\u0301t", 21141);
    freq.put("a\u0301v", 4411);
    freq.put("a\u0301z", 7779);
    freq.put("tva\u0301", 1162);
    freq.put("okk", 1292);
    freq.put("seb", 2714);
    freq.put(" ce\u0301", 1611);
    freq.put("e\u0301ze", 2382);
    freq.put(" ci\u0301", 4405);
    freq.put("ha\u0301z", 2853);
    freq.put("ot ", 4277);
    freq.put("gre", 1699);
    freq.put("a\u0301ss", 1306);
    freq.put("a\u0301 ", 2111);
    freq.put("amm", 1385);
    freq.put("nat", 2233);
    freq.put("amo", 3002);
    freq.put("a\u0301st", 1822);
    freq.put("ama", 2681);
    freq.put("a\u0301sz", 3797);
    freq.put("amb", 1439);
    freq.put("ame", 12652);
    freq.put("mot", 1595);
    freq.put("psz", 1291);
    freq.put("a\u0301sb", 2951);
    freq.put("a\u0301sa", 4529);
    freq.put("o\u0301ba", 1208);
    freq.put("mon", 2735);
    freq.put("amp", 1099);
    freq.put("a\u0301si", 3907);
    freq.put("a\u0301so", 5295);
    freq.put("zle", 1674);
    freq.put("zlo", 7817);
    freq.put("sre\u0301", 1266);
    freq.put("t", 700784);
    freq.put("gje", 1874);
    freq.put("gja", 1441);
    freq.put("Nem", 1251);
    freq.put("ezt", 2772);
    freq.put("ezh", 1979);
    freq.put("ezi", 1930);
    freq.put("ezd", 1515);
    freq.put("eze", 13658);
    freq.put(" ci", 1469);
    freq.put("zi\u0301n", 2823);
    freq.put("o ", 10039);
    freq.put("na ", 6605);
    freq.put("o\u0308tt", 6080);
    freq.put(" cs", 21597);
    freq.put("zi\u0301t", 1657);
    freq.put("mpi", 1413);
    freq.put("a\u0301sa\u0301", 7057);
    freq.put("ez ", 6988);
    freq.put("me\u0301l", 2519);
    freq.put("oo", 1729);
    freq.put("on", 54876);
    freq.put("om", 30097);
    freq.put("ol", 57719);
    freq.put("ok", 33935);
    freq.put("o\u0301ta", 1799);
    freq.put("oi", 1954);
    freq.put("oh", 1599);
    freq.put("og", 16189);
    freq.put("of", 2805);
    freq.put("aci", 1651);
    freq.put("od", 12616);
    freq.put("oc", 6235);
    freq.put("ob", 7903);
    freq.put("acs", 1177);
    freq.put("oz", 36942);
    freq.put("ow", 1527);
    freq.put("ov", 15603);
    freq.put("ou", 3364);
    freq.put("ot", 26104);
    freq.put("os", 55594);
    freq.put("or", 73234);
    freq.put("op", 11263);
    freq.put(" A ", 54120);
    freq.put("rva\u0301", 1234);
    freq.put("No", 1352);
    freq.put("u\u030bve", 1432);
    freq.put("rve\u0301", 1214);
    freq.put("Ne", 3381);
    freq.put("Ny", 3322);
    freq.put("me\u0301g", 1185);
    freq.put("het", 6443);
    freq.put("pa\u0301r", 2273);
    freq.put("log", 1806);
    freq.put("her", 2201);
    freq.put("lon", 1455);
    freq.put("hez", 5105);
    freq.put("lom", 5872);
    freq.put("lor", 1462);
    freq.put("los", 2605);
    freq.put("\u0432", 1255);
    freq.put("lov", 8327);
    freq.put("lot", 1131);
    freq.put("hel", 6775);
    freq.put("pa\u0301l", 1428);
    freq.put("pa\u0301n", 1462);
    freq.put("J", 7703);
    freq.put("i\u0301mu\u030b", 2569);
    freq.put("cia\u0301", 1338);
    freq.put("se\u0301r", 1918);
    freq.put("rje", 2570);
    freq.put("ku\u0301a", 5586);
    freq.put("ita\u0301", 2293);
    freq.put("yag", 1568);
    freq.put("he ", 2263);
    freq.put("aa", 1143);
    freq.put("Ne\u0301", 1630);
    freq.put("ac", 9905);
    freq.put("ab", 12613);
    freq.put("ae", 13109);
    freq.put("u\u030bve\u0301", 1367);
    freq.put("ag", 47002);
    freq.put("af", 4252);
    freq.put("ai", 30999);
    freq.put("ah", 3611);
    freq.put("ak", 76786);
    freq.put("aj", 22921);
    freq.put("am", 34363);
    freq.put("al", 112498);
    freq.put("ao", 1282);
    freq.put("an", 99045);
    freq.put("ap", 21474);
    freq.put("as", 35129);
    freq.put("ar", 73118);
    freq.put("au", 6414);
    freq.put("at", 73551);
    freq.put("ve\u0301t", 1848);
    freq.put("av", 6465);
    freq.put("ay", 1779);
    freq.put("az", 52261);
    freq.put("yom", 2043);
    freq.put("yol", 1936);
    freq.put("yok", 1279);
    freq.put("uto\u0301", 1685);
    freq.put("Lad", 1325);
    freq.put("ezo\u030b", 2970);
    freq.put("ige", 3208);
    freq.put("iga", 2520);
    freq.put("yos", 2298);
    freq.put("ehe\u0301", 1275);
    freq.put("a ", 242203);
    freq.put("gol", 3486);
    freq.put("lo\u030bs", 2401);
    freq.put("ajz", 1349);
    freq.put("gon", 2487);
    freq.put("dsz", 3860);
    freq.put("Az", 15235);
    freq.put("at ", 13186);
    freq.put("u\u0301sz", 1202);
    freq.put("a\u0301z ", 1260);
    freq.put("u", 147118);
    freq.put("ig ", 5385);
    freq.put("alo", 6119);
    freq.put("all", 3854);
    freq.put("a\u0301rs", 2861);
    freq.put("a\u0301rt", 3175);
    freq.put("alk", 5861);
    freq.put("ali", 4354);
    freq.put("to\u030bl", 2706);
    freq.put("pte", 2465);
    freq.put("ale", 2695);
    freq.put("alb", 2678);
    freq.put("alc", 1755);
    freq.put("ry", 3017);
    freq.put("a\u0301ra", 5673);
    freq.put("gt", 2295);
    freq.put("to\u030bs", 1505);
    freq.put("alv", 1163);
    freq.put("a\u0301ri", 3231);
    freq.put("alt", 1806);
    freq.put("alu", 2639);
    freq.put("alr", 1104);
    freq.put("a\u0301rm", 2982);
    freq.put("gr", 6943);
    freq.put("ty", 4352);
    freq.put("tv", 7094);
    freq.put("tt", 50460);
    freq.put("tu", 13656);
    freq.put("tr", 17609);
    freq.put("ts", 8729);
    freq.put("tn", 2524);
    freq.put("to", 52152);
    freq.put("tl", 6382);
    freq.put("tm", 2785);
    freq.put("tj", 7119);
    freq.put("tk", 5205);
    freq.put("th", 9478);
    freq.put("ti", 40828);
    freq.put("tf", 1412);
    freq.put("\u0438", 1900);
    freq.put("te", 87104);
    freq.put("tb", 6187);
    freq.put("tc", 1163);
    freq.put("ta", 76171);
    freq.put(" ro\u0308", 2141);
    freq.put("ium", 2277);
    freq.put("rb", 5639);
    freq.put(" ro\u0301", 1121);
    freq.put("mpl", 1595);
    freq.put("al ", 17585);
    freq.put("gz", 1512);
    freq.put("a\u0301r ", 6296);
    freq.put("gy", 101312);
    freq.put("e\u0301ke", 3632);
    freq.put("rm", 20825);
    freq.put("ius", 3051);
    freq.put("e\u0301kh", 1465);
    freq.put(" re\u0301", 10099);
    freq.put("sme", 3505);
    freq.put("gg", 3431);
    freq.put("pre", 1161);
    freq.put("is ", 16119);
    freq.put(" No", 1346);
    freq.put("gf", 2198);
    freq.put(" Na", 3783);
    freq.put("rh", 2668);
    freq.put(" Ne", 3354);
    freq.put("ge", 24009);
    freq.put(" Ny", 3316);
    freq.put("gos", 1601);
    freq.put("heg", 1841);
    freq.put("t ", 159290);
    freq.put("ass", 5488);
    freq.put("a\u0301ro\u0301", 1875);
    freq.put("tel", 10568);
    freq.put("ga", 25428);
    freq.put("ten", 6944);
    freq.put("zig", 3735);
    freq.put("ala\u0301", 20616);
    freq.put("go", 14059);
    freq.put("nba", 1457);
    freq.put("tes", 7803);
    freq.put("tet", 11629);
    freq.put("zo\u0308", 10272);
    freq.put("sug", 1404);
    freq.put("aba", 1856);
    freq.put("tu\u0308", 4027);
    freq.put("tu\u0301", 2750);
    freq.put("to\u0308", 12442);
    freq.put("to\u0301", 18526);
    freq.put("no\u030b ", 1717);
    freq.put("ti\u0301", 4348);
    freq.put("lle", 8630);
    freq.put("te\u0301", 34673);
    freq.put("zo\u0301", 20498);
    freq.put("ta\u0301", 43166);
    freq.put("lko", 4418);
    freq.put("te ", 9032);
    freq.put("K", 21077);
    freq.put(" re", 19463);
    freq.put(" ra", 2479);
    freq.put("zu\u0308l", 3298);
    freq.put(" ro", 3461);
    freq.put(" Ne\u0301", 1627);
    freq.put("fo\u030b", 4516);
    freq.put("oma", 1728);
    freq.put("se\u0301t", 1189);
    freq.put("ko\u030b", 1313);
    freq.put("sba", 3589);
    freq.put("no\u030bi", 1248);
    freq.put("yu\u0308", 3112);
    freq.put("lke", 2520);
    freq.put("nto", 3218);
    freq.put("vid", 4003);
    freq.put("vez", 9822);
    freq.put("vil", 4652);
    freq.put("to\u030b", 14413);
    freq.put("vir", 1492);
    freq.put("rke", 1521);
    freq.put("S ", 1580);
    freq.put("yo\u0301", 2584);
    freq.put("ki ", 6708);
    freq.put("veg", 1557);
    freq.put("mma", 1863);
    freq.put("csa\u0301", 1388);
    freq.put("tu\u030b", 4358);
    freq.put("de ", 4718);
    freq.put("se\u0301g", 20101);
    freq.put("Sz", 12584);
    freq.put("vi ", 1300);
    freq.put("fo\u0308", 2942);
    freq.put("isz", 6268);
    freq.put("Sp", 1130);
    freq.put("fu\u0308", 2239);
    freq.put("St", 3173);
    freq.put("fa\u0301", 1392);
    freq.put("Si", 1430);
    freq.put("So", 1614);
    freq.put("Sc", 1225);
    freq.put("fe\u0301", 13187);
    freq.put("Sa", 3389);
    freq.put("Se", 1702);
    freq.put("a\u0301", 372527);
    freq.put("dez", 2835);
    freq.put(" di", 2713);
    freq.put("Int", 2403);
    freq.put(" de", 6050);
    freq.put("des", 1303);
    freq.put("det", 5300);
    freq.put(" da", 2485);
    freq.put("se\u0301n", 1506);
    freq.put("ege\u0301", 3370);
    freq.put("del", 4174);
    freq.put("den", 3777);
    freq.put("v", 203150);
    freq.put("o\u0308k ", 2555);
    freq.put(" Fe", 3060);
    freq.put("pro", 3235);
    freq.put("f ", 3042);
    freq.put("lal", 2932);
    freq.put("ist", 5127);
    freq.put("cso", 5464);
    freq.put("csi", 2762);
    freq.put("csk", 1549);
    freq.put("cse", 2576);
    freq.put("csa", 18273);
    freq.put("lam", 7155);
    freq.put("atr", 1521);
    freq.put("eg ", 8600);
    freq.put("fr", 3611);
    freq.put("fu", 1929);
    freq.put("fa", 14955);
    freq.put("fe", 22515);
    freq.put("ff", 1119);
    freq.put("fi", 9218);
    freq.put("fo", 23259);
    freq.put("a", 1016786);
    freq.put(" di\u0301", 1823);
    freq.put("us ", 17567);
    freq.put(" de\u0301", 2801);
    freq.put("egs", 1610);
    freq.put("egr", 1473);
    freq.put("cs ", 2427);
    freq.put("ry ", 1179);
    freq.put("egt", 1312);
    freq.put("egk", 1751);
    freq.put("egj", 2290);
    freq.put("egi", 1596);
    freq.put("egh", 1485);
    freq.put("egn", 2926);
    freq.put("o\u0308", 107023);
    freq.put("ega", 1438);
    freq.put("egf", 1828);
    freq.put("ege", 4339);
    freq.put("ito", 1407);
    freq.put("ce ", 2292);
    freq.put("y ", 64628);
    freq.put("ite", 2144);
    freq.put("ita", 2682);
    freq.put("ok ", 16218);
    freq.put("itt", 1847);
    freq.put("itr", 1237);
    freq.put("iza\u0301", 1108);
    freq.put(" Ol", 1338);
    freq.put("pcs", 1390);
    freq.put("lya", 5925);
    freq.put("o\u030bsz", 2500);
    freq.put(" Or", 1691);
    freq.put("yi", 17109);
    freq.put("yh", 1922);
    freq.put("yk", 2442);
    freq.put("okr", 1131);
    freq.put("ym", 1973);
    freq.put("yl", 2832);
    freq.put("yo", 12260);
    freq.put("yn", 3914);
    freq.put("ya", 26830);
    freq.put("asu\u0301", 1719);
    freq.put("yc", 1116);
    freq.put("yb", 3764);
    freq.put("ye", 40237);
    freq.put("L", 15870);
    freq.put("yg", 1834);
    freq.put("yf", 2056);
    freq.put("oka", 3243);
    freq.put("asa\u0301", 3004);
    freq.put("yz", 1903);
    freq.put("cer", 1367);
    freq.put("lyb", 1133);
    freq.put("pai", 1203);
    freq.put("yp", 1398);
    freq.put("ys", 7991);
    freq.put("yr", 1838);
    freq.put("yu", 3843);
    freq.put("yt", 3497);
    freq.put("oko", 2728);
    freq.put("yv", 4653);
    freq.put("o\u030bs ", 1549);
    freq.put("yne", 2282);
    freq.put("tse\u0301", 3581);
    freq.put("ife", 1711);
    freq.put("sa\u0301g", 11788);
    freq.put("e\u0301de", 1275);
    freq.put(" sz", 51220);
    freq.put("dig", 1984);
    freq.put(" sp", 2365);
    freq.put(" st", 2457);
    freq.put(" su", 1760);
    freq.put("as ", 5129);
    freq.put("va\u0301n", 2981);
    freq.put(" so", 5755);
    freq.put("i\u0301v ", 1366);
    freq.put(" sa", 2016);
    freq.put(" se", 2587);
    freq.put("gus", 1307);
    freq.put("ize", 1447);
    freq.put("o\u0301j", 4542);
    freq.put("o\u030bsi\u0301", 1918);
    freq.put("izo", 1300);
    freq.put("mes", 7852);
    freq.put("o\u030bso\u0308", 1177);
    freq.put("ye\u0301", 5272);
    freq.put(" Ac", 1573);
    freq.put("yi\u0301", 1801);
    freq.put("ve ", 7296);
    freq.put("ast", 1692);
    freq.put("ya\u0301", 13547);
    freq.put("asz", 10871);
    freq.put(" Al", 3798);
    freq.put(" Am", 2399);
    freq.put(" An", 3650);
    freq.put(" Ar", 2712);
    freq.put("yu\u0301", 1973);
    freq.put(" Au", 1680);
    freq.put("st ", 5212);
    freq.put(" Az", 15203);
    freq.put("aso", 1347);
    freq.put("pus", 1929);
    freq.put("El", 1696);
    freq.put("mze", 3907);
    freq.put("Eg", 3224);
    freq.put("o\u0308zl", 1118);
    freq.put("w", 6657);
    freq.put("Ez", 1912);
    freq.put("Eu", 1996);
    freq.put("Er", 1727);
    freq.put("le ", 4396);
    freq.put("Fra", 1443);
    freq.put("dt ", 1182);
    freq.put("zm", 2937);
    freq.put("zo", 19843);
    freq.put("ans", 1439);
    freq.put("zh", 3151);
    freq.put(" el", 22279);
    freq.put(" em", 3989);
    freq.put(" en", 1270);
    freq.put("kom", 1428);
    freq.put("kol", 2622);
    freq.put("kon", 4605);
    freq.put("jez", 1371);
    freq.put(" eg", 37244);
    freq.put("kod", 1381);
    freq.put("o\u0308ze", 2220);
    freq.put("a\u0301g ", 10677);
    freq.put("koz", 3084);
    freq.put(" ez", 6961);
    freq.put("o\u0308zs", 4673);
    freq.put("kos", 4432);
    freq.put("\u043a", 1191);
    freq.put("kot", 2662);
    freq.put(" er", 6741);
    freq.put(" es", 6369);
    freq.put("zg", 2806);
    freq.put("ag ", 2506);
    freq.put("ncs", 2007);
    freq.put("za", 30193);
    freq.put("nci", 3666);
    freq.put("su\u030b ", 1297);
    freq.put("rra", 1492);
    freq.put("yu\u030b", 1984);
    freq.put("nce", 2318);
    freq.put("a\u0301go", 3161);
    freq.put("ste", 4883);
    freq.put("ka\u0301", 8866);
    freq.put("b", 219927);
    freq.put("sta", 3478);
    freq.put("a\u0301gi", 2804);
    freq.put("odi", 3096);
    freq.put("ke\u0301", 20553);
    freq.put("ato", 8994);
    freq.put("a\u0301gb", 3476);
    freq.put("ki\u0301", 3018);
    freq.put("ko\u0301", 3434);
    freq.put("je ", 3339);
    freq.put("ko\u0308", 37773);
    freq.put("str", 2018);
    freq.put("yo\u030b", 1310);
    freq.put("ku\u0301", 6878);
    freq.put("o\u0308zt", 1797);
    freq.put("ku\u0308", 4521);
    freq.put("ka ", 5099);
    freq.put("ga\u0301", 10089);
    freq.put("gye", 12610);
    freq.put("zt", 36837);
    freq.put("oda", 2951);
    freq.put("zv", 1698);
    freq.put("lid", 1319);
    freq.put("o\u0308ze\u0301", 2985);
    freq.put("k ", 156709);
    freq.put("gya", 12084);
    freq.put("o\u0301s ", 2694);
    freq.put("lim", 1567);
    freq.put("lin", 2766);
    freq.put("lik", 2243);
    freq.put("lit", 2107);
    freq.put("o\u030bne", 2127);
    freq.put("ge\u0301", 11029);
    freq.put("efo", 1148);
    freq.put("o\u0308zo\u0308", 5568);
    freq.put("bo\u030bl", 3435);
    freq.put("M", 28130);
    freq.put("kan", 1437);
    freq.put("kal", 4211);
    freq.put("kas", 1212);
    freq.put("kar", 2888);
    freq.put("kap", 3160);
    freq.put("gyi", 8702);
    freq.put("kat", 6062);
    freq.put("ku\u0308l", 3938);
    freq.put("je\u0301b", 6198);
    freq.put("The", 1583);
    freq.put("kc", 1158);
    freq.put("kb", 6547);
    freq.put("ka", 34729);
    freq.put("li ", 5160);
    freq.put("sta\u0301", 1316);
    freq.put("ke", 42527);
    freq.put("kk", 6940);
    freq.put("ki", 30779);
    freq.put("kh", 2892);
    freq.put("ko", 37181);
    freq.put("kn", 3693);
    freq.put("a\u0301ga\u0301", 1372);
    freq.put("kl", 3302);
    freq.put("ks", 5542);
    freq.put("kr", 7237);
    freq.put("kv", 1892);
    freq.put("ku", 13047);
    freq.put("kt", 6729);
    freq.put("rte", 3860);
    freq.put("ifo", 5710);
    freq.put("rta", 3812);
    freq.put(" Bi\u0301", 1298);
    freq.put("aru\u0301", 1364);
    freq.put("rti", 1302);
    freq.put("re\u0301s", 10041);
    freq.put(" o\u0301t", 1104);
    freq.put("rtj", 2461);
    freq.put(" o\u0301k", 1246);
    freq.put("re\u0301g", 2911);
    freq.put("re\u0301b", 2703);
    freq.put("Jo", 1519);
    freq.put("a\u0301h", 4265);
    freq.put("Je", 1294);
    freq.put("Ja", 1924);
    freq.put("rd ", 1700);
    freq.put("rt ", 8024);
    freq.put("hiv", 1273);
    freq.put("mi\u0301t", 1327);
    freq.put(" A\u0301l", 1439);
    freq.put("ika\u0301", 2172);
    freq.put("ne ", 3513);
    freq.put("a\u0301r", 52483);
    freq.put("x", 7186);
    freq.put("rfi", 1520);
    freq.put("eze\u0301", 5371);
    freq.put(" Be", 4051);
    freq.put("arr", 1237);
    freq.put("set", 1567);
    freq.put(" Ba", 3855);
    freq.put("aru", 1342);
    freq.put(" Bo", 3283);
    freq.put(" Bi", 1842);
    freq.put("sti", 2035);
    freq.put(" Bu", 2577);
    freq.put("ara", 12278);
    freq.put("arc", 2552);
    freq.put("ard", 2003);
    freq.put("a\u0301ga", 2054);
    freq.put(" Br", 2520);
    freq.put("ari", 4156);
    freq.put("sem", 1195);
    freq.put("ark", 2718);
    freq.put("arl", 1467);
    freq.put("arm", 1949);
    freq.put("lo\u0301d", 1195);
    freq.put("aro", 4590);
    freq.put("zke", 1119);
    freq.put("leg", 14221);
    freq.put("ozo", 1583);
    freq.put("so\u030b", 8855);
    freq.put(" fo\u030b", 4149);
    freq.put("iku", 4841);
    freq.put("lel", 1659);
    freq.put("ar ", 7389);
    freq.put("ika", 8060);
    freq.put("ike", 2523);
    freq.put("se ", 7438);
    freq.put("iko", 1515);
    freq.put(" Pr", 2030);
    freq.put("c", 121096);
    freq.put("ro\u0308v", 1876);
    freq.put("ozt", 1266);
    freq.put(" Pa", 5457);
    freq.put(" Pe", 2496);
    freq.put(" Pi", 1722);
    freq.put(" Po", 2728);
    freq.put("esu\u0308", 1885);
    freq.put("ve\u0301g", 2913);
    freq.put("lbu", 2257);
    freq.put("ga ", 3541);
    freq.put("pr", 7474);
    freq.put("ps", 3440);
    freq.put("pp", 2547);
    freq.put("le\u0301g", 1202);
    freq.put("dul", 1851);
    freq.put("pt", 5892);
    freq.put("pu", 3980);
    freq.put("le\u0301n", 1237);
    freq.put("le\u0301k", 10125);
    freq.put("le\u0301t", 2548);
    freq.put("pc", 1541);
    freq.put("pa", 16699);
    freq.put("lta\u0301", 1280);
    freq.put("pe", 16459);
    freq.put("pj", 2198);
    freq.put("pk", 2115);
    freq.put("ph", 4251);
    freq.put("pi", 8966);
    freq.put("po", 17893);
    freq.put("pl", 5060);
    freq.put("gaz", 3489);
    freq.put(" tu", 3046);
    freq.put("gat", 6541);
    freq.put("gas", 2172);
    freq.put(" tr", 1755);
    freq.put("N", 17752);
    freq.put(" to", 2214);
    freq.put("gal", 3993);
    freq.put(" ti", 2324);
    freq.put("ado", 2879);
    freq.put(" te", 19251);
    freq.put("sko", 1582);
    freq.put(" ta", 23929);
    freq.put("sak", 2444);
    freq.put(" fo\u0308", 1646);
    freq.put(" fu\u0308", 1523);
    freq.put("p ", 5660);
    freq.put("o\u0301i ", 1956);
    freq.put(" fe\u0301", 4201);
    freq.put("zo\u0308t", 4004);
    freq.put("bor", 3409);
    freq.put("ami", 6863);
    freq.put("moz", 1966);
    freq.put("vol", 10664);
    freq.put("rit", 2732);
    freq.put("ris", 3358);
    freq.put("rin", 5644);
    freq.put("ril", 1221);
    freq.put("rik", 5031);
    freq.put("rif", 2877);
    freq.put("rid", 1666);
    freq.put("rie", 1106);
    freq.put("ric", 1848);
    freq.put("sai", 1775);
    freq.put("ria", 3879);
    freq.put("lu\u0308l", 5325);
    freq.put("pu\u0308", 4993);
    freq.put("mos", 2616);
    freq.put("pa\u0301", 7384);
    freq.put("pe\u0301", 3054);
    freq.put("nle", 1203);
    freq.put("pi\u0301", 3835);
    freq.put("tis", 1923);
    freq.put(" to\u0308", 9167);
    freq.put("cea", 1428);
    freq.put("to\u030bn", 1924);
    freq.put(" te\u0301", 2457);
    freq.put(" ta\u0301", 3920);
    freq.put("lia", 3789);
    freq.put("mok", 3026);
    freq.put(" fr", 2101);
    freq.put(" fu", 1228);
    freq.put("gsz", 2045);
    freq.put("kna", 1132);
    freq.put(" fa", 10457);
    freq.put(" fe", 16017);
    freq.put(" fi", 3986);
    freq.put(" fo", 11286);
    freq.put("lda", 1565);
    freq.put("ldi", 1183);
    freq.put("bi ", 2519);
    freq.put("ad", 30543);
    freq.put("tin", 5413);
    freq.put("na\u0301l", 7068);
    freq.put("\u043e", 2301);
    freq.put("sal", 14426);
    freq.put("rge", 1233);
    freq.put("rgi", 1214);
    freq.put("gs", 3570);
    freq.put("elv", 9038);
    freq.put("Ol", 1338);
    freq.put("ba\u0301n", 1642);
    freq.put("ba\u0301", 5025);
    freq.put("lis", 6935);
    freq.put("be\u0301", 2495);
    freq.put("bo\u0308", 1784);
    freq.put("biz", 1578);
    freq.put("apt", 1225);
    freq.put("bo\u0301", 6751);
    freq.put("Or", 1697);
    freq.put("d", 216557);
    freq.put("lja", 2062);
    freq.put("lje", 1805);
    freq.put("A\u0301l", 1439);
    freq.put("e\u0301sr", 1270);
    freq.put("ii ", 1284);
    freq.put("ta\u0301k", 3376);
    freq.put("lda\u0301", 1177);
    freq.put("b ", 16527);
    freq.put("gok", 1862);
    freq.put("ld ", 2188);
    freq.put("e\u0301he", 3730);
    freq.put("gya\u0301", 1929);
    freq.put("per", 4376);
    freq.put("pes", 3470);
    freq.put("pel", 1327);
    freq.put("pen", 1323);
    freq.put("ped", 1503);
    freq.put("kai", 6519);
    freq.put("id ", 1248);
    freq.put("bd", 1747);
    freq.put("be", 56227);
    freq.put("ba", 62023);
    freq.put("bb", 21421);
    freq.put("bl", 2460);
    freq.put("bo", 9382);
    freq.put("ga\u0301s", 1179);
    freq.put("bi", 10991);
    freq.put("O", 8481);
    freq.put("bu", 6371);
    freq.put("ga\u0301l", 2697);
    freq.put("gye\u0301", 3341);
    freq.put("br", 4886);
    freq.put("bs", 1600);
    freq.put("rus", 2059);
    freq.put("zza", 1374);
    freq.put("che", 1523);
    freq.put("o\u0308zi", 2766);
    freq.put("lja\u0301", 1491);
    freq.put("ne\u0301v", 7964);
    freq.put("fen", 1212);
    freq.put("u\u0308tt", 2514);
    freq.put("ide", 4043);
    freq.put("ida", 9550);
    freq.put("lyo\u0301", 1710);
    freq.put(" ut", 3907);
    freq.put("fej", 4036);
    freq.put("nse", 1158);
    freq.put(" ur", 1101);
    freq.put("ner", 1420);
    freq.put("nsz", 1210);
    freq.put("lya\u0301", 9265);
    freq.put("te\u0301s", 9077);
    freq.put(" go\u0308", 2536);
    freq.put("te\u0301l", 1509);
    freq.put("ci ", 1364);
    freq.put("u\u030b ", 13555);
    freq.put("go\u0301 ", 1820);
    freq.put("ust", 1128);
    freq.put("Ko\u0308z", 2207);
    freq.put("u ", 5228);
    freq.put("ekt", 2496);
    freq.put(" Ch", 2631);
    freq.put(" Co", 4068);
    freq.put("ns ", 1607);
    freq.put("lka", 2131);
    freq.put(" Ca", 4107);
    freq.put(" Ce", 1230);
    freq.put(" Cs", 2760);
    freq.put("cia", 3115);
    freq.put("nya\u0301", 1816);
    freq.put("ut", 12436);
    freq.put("up", 2459);
    freq.put("aga\u0301", 2325);
    freq.put("ur", 14404);
    freq.put("um", 11242);
    freq.put("ul", 23432);
    freq.put("un", 8785);
    freq.put("ui", 1873);
    freq.put("uk", 4884);
    freq.put("ue", 1945);
    freq.put("ud", 8185);
    freq.put("ug", 7493);
    freq.put("z", 429255);
    freq.put("ua", 1854);
    freq.put("uc", 2378);
    freq.put("ub", 2532);
    freq.put("lyt", 1183);
    freq.put("lys", 1166);
    freq.put("Tu", 1174);
    freq.put("Tr", 2483);
    freq.put("To", 1807);
    freq.put("km", 3318);
    freq.put("Th", 2533);
    freq.put("Ti", 1466);
    freq.put("a\u0301mi\u0301", 1237);
    freq.put("lyn", 2379);
    freq.put("Te", 2749);
    freq.put("lyi", 2296);
    freq.put("Nye", 1809);
    freq.put("A ", 56345);
    freq.put("Mar", 2612);
    freq.put(" gr", 1159);
    freq.put("nag", 5845);
    freq.put("ze\u0301p", 2406);
    freq.put("nae", 1236);
    freq.put("nak", 21124);
    freq.put("nai", 2208);
    freq.put("nal", 2777);
    freq.put(" gy", 6161);
    freq.put("nap", 2250);
    freq.put(" ge", 1465);
    freq.put("Mag", 3698);
    freq.put(" ga", 1837);
    freq.put("ze\u0301n", 2337);
    freq.put("ze\u0301l", 1670);
    freq.put("ze\u0301k", 2328);
    freq.put("ido\u030b", 1933);
    freq.put("ly ", 11120);
    freq.put("ago", 2554);
    freq.put("Ac", 1577);
    freq.put("uta\u0301", 2191);
    freq.put("e", 996693);
    freq.put("agj", 1385);
    freq.put("Am", 2415);
    freq.put("Al", 3816);
    freq.put("aga", 3600);
    freq.put("An", 3658);
    freq.put("cio\u0301", 4016);
    freq.put("lu ", 1887);
    freq.put("Ar", 2744);
    freq.put("Au", 1680);
    freq.put("bo\u030b", 3863);
    freq.put("agy", 29473);
    freq.put("nd ", 4041);
    freq.put("u\u0301", 35451);
    freq.put("ua\u0301", 1400);
    freq.put(" b", 38681);
    freq.put(" c", 32807);
    freq.put("gu", 3889);
    freq.put(" a", 216424);
    freq.put(" f", 58652);
    freq.put(" g", 17434);
    freq.put(" d", 20317);
    freq.put(" e", 90097);
    freq.put(" j", 25021);
    freq.put(" k", 101750);
    freq.put(" h", 46816);
    freq.put(" i", 30318);
    freq.put(" n", 55262);
    freq.put(" o", 27009);
    freq.put(" l", 36854);
    freq.put(" m", 86086);
    freq.put(" r", 41479);
    freq.put(" s", 75268);
    freq.put(" p", 25823);
    freq.put(" v", 67319);
    freq.put("gb", 5764);
    freq.put(" t", 73839);
    freq.put(" u", 7248);
    freq.put(" z", 5071);
    freq.put("gn", 5176);
    freq.put("gm", 1339);
    freq.put("gl", 4237);
    freq.put("gk", 2851);
    freq.put("gj", 4145);
    freq.put("gi", 17202);
    freq.put("gh", 4135);
    freq.put(" B", 23082);
    freq.put(" C", 19809);
    freq.put(" A", 94593);
    freq.put(" F", 12742);
    freq.put(" G", 12445);
    freq.put(" D", 12015);
    freq.put(" E", 17107);
    freq.put(" J", 7511);
    freq.put(" K", 20282);
    freq.put(" H", 12799);
    freq.put(" I", 11800);
    freq.put(" N", 16438);
    freq.put(" O", 7214);
    freq.put(" L", 14736);
    freq.put(" M", 26568);
    freq.put(" R", 11088);
    freq.put(" S", 32225);
    freq.put(" P", 20591);
    freq.put(" V", 9030);
    freq.put(" W", 4161);
    freq.put(" T", 17702);
    freq.put(" U", 3712);
    freq.put(" Z", 3901);
    freq.put(" Y", 1159);
    freq.put("rto", 16676);
    freq.put("ed ", 1845);
    freq.put("o\u0308nb", 1254);
    freq.put("oza\u0301", 2383);
    freq.put("P", 22295);
    freq.put("ozo\u0301", 12847);
    freq.put("g ", 45451);
    freq.put("e\u0301v", 16532);
    freq.put("o\u0308ny", 3378);
    freq.put("tri", 3477);
    freq.put("tro", 2690);
    freq.put("ara\u0301", 1634);
    freq.put("tra", 4155);
    freq.put("u\u030bv", 2905);
    freq.put("tre", 3344);
    freq.put("eve", 8161);
    freq.put("o\u030bl ", 7803);
    freq.put(" mu\u030b", 3958);
    freq.put("zl", 11760);
    freq.put("go\u0308", 3372);
    freq.put("zn", 6608);
    freq.put(" a\u0301", 18269);
    freq.put("go\u0301", 4573);
    freq.put("zi", 25268);
    freq.put("oz ", 6136);
    freq.put("zk", 4768);
    freq.put("zd", 4010);
    freq.put("ze", 71368);
    freq.put("zf", 1314);
    freq.put(" e\u0301", 57281);
    freq.put("gu\u0301", 1727);
    freq.put("zb", 1632);
    freq.put(" i\u0301", 4682);
    freq.put(" o\u0301", 3751);
    freq.put(" o\u0308", 8570);
    freq.put("zz", 3816);
    freq.put("odo", 1217);
    freq.put(" u\u0301", 3722);
    freq.put("zu", 3963);
    freq.put("gi\u0301", 1165);
    freq.put("zp", 2246);
    freq.put("ode", 1450);
    freq.put(" u\u0308", 2190);
    freq.put("zs", 12765);
    freq.put(" A\u0301", 2459);
    freq.put("bda", 1545);
    freq.put(" E\u0301", 1858);
    freq.put("e\u0301g", 31689);
    freq.put("rac", 1357);
    freq.put("u\u030be", 1599);
    freq.put("tar", 19006);
    freq.put("o\u0308na\u0301", 1325);
    freq.put("oza", 5292);
    freq.put("leh", 1502);
    freq.put("got", 1210);
    freq.put("lek", 3977);
    freq.put("z ", 78459);
    freq.put("lem", 6723);
    freq.put("len", 17272);
    freq.put("ozi", 2582);
    freq.put("o\u030b", 81190);
    freq.put("o\u030bbb", 1227);
    freq.put("les", 5249);
    freq.put("let", 23881);
    freq.put("lev", 1937);
    freq.put("u\u030bk", 1684);
    freq.put("eve\u0301", 4056);
    freq.put("tu\u030b ", 2810);
    freq.put("tra\u0301", 1500);
    freq.put("ce\u0301l", 1462);
    freq.put("rde", 1294);
    freq.put("ze\u0301r", 1246);
    freq.put("cti", 1331);
    freq.put(" Do", 1490);
    freq.put(" Di", 1622);
    freq.put(" De", 2234);
    freq.put("za\u0301l", 1821);
    freq.put(" Da", 1472);
    freq.put("apj", 1950);
    freq.put("api", 1102);
    freq.put("mel", 20048);
    freq.put("apo", 2602);
    freq.put("apc", 1186);
    freq.put(" Du", 1183);
    freq.put("apa", 2996);
    freq.put("a\u0301va", 2230);
    freq.put("ape", 1622);
    freq.put(" va\u0301", 10832);
    freq.put("cha", 1323);
    freq.put("Fr", 2249);
    freq.put("afe\u0301", 1601);
    freq.put("go\u030b", 1259);
    freq.put(" ve\u0301", 3902);
    freq.put("chi", 1879);
    freq.put("fel", 10451);
    freq.put(" vi\u0301", 1450);
    freq.put("fek", 1857);
    freq.put("Fa", 1242);
    freq.put(" o\u030b", 1879);
    freq.put("Fe", 3066);
    freq.put("za\u0301g", 9532);
    freq.put("zin", 2369);
    freq.put("Fi", 1170);
    freq.put("zil", 1212);
    freq.put("zik", 7225);
    freq.put("Fo", 1548);
    freq.put("i\u0301zi", 1186);
    freq.put("ch ", 1376);
    freq.put("u\u030bs", 1405);
    freq.put("u\u030br", 1219);
    freq.put("ace", 1933);
    freq.put("f", 108322);
    freq.put("km ", 2029);
    freq.put(" Re", 2297);
    freq.put(" Ra", 1786);
    freq.put("zi ", 4058);
    freq.put("za\u0301z", 1557);
    freq.put(" Ro", 2824);
    freq.put("tat", 5289);
    freq.put("ach", 1191);
    freq.put(" De\u0301", 1163);
    freq.put("\u0440", 1511);
    freq.put("ro\u0301 ", 3203);
    freq.put("tu\u0308l", 2293);
    freq.put("tag", 2404);
    freq.put("api\u0301", 1933);
    freq.put("tal", 17363);
    freq.put("tan", 4747);
    freq.put("apa\u0301", 1330);
    freq.put("tai", 1258);
    freq.put("tak", 4038);
    freq.put(" va", 20643);
    freq.put(" ve", 9072);
    freq.put("zio\u0301", 1200);
    freq.put(" vi", 8365);
    freq.put("za\u0301r", 4252);
    freq.put("ne\u0301m", 3320);
    freq.put(" jo", 1938);
    freq.put(" vo", 11603);
    freq.put("za\u0301s", 4765);
    freq.put("sid", 1199);
    freq.put("sik", 1599);
    freq.put("o\u0301ko", 1362);
    freq.put("a\u0301dj", 10076);
    freq.put("zo\u030b", 8108);
    freq.put("sil", 1988);
    freq.put("ro\u0301l", 2801);
    freq.put("ke\u0301p", 5158);
    freq.put("ta ", 15756);
    freq.put("men", 4193);
    freq.put("ke\u0301t", 4231);
    freq.put("ro\u0301p", 2151);
    freq.put("ndr", 1401);
    freq.put("si ", 8670);
    freq.put("o\u0301k ", 2577);
    freq.put("a\u0301d ", 2121);
    freq.put("u\u0301l", 1994);
    freq.put("da ", 3729);
    freq.put("u\u0301j", 3185);
    freq.put("u\u0301g", 2023);
    freq.put("u\u0301a", 6976);
    freq.put("kbe", 2008);
    freq.put("u\u0301z", 1141);
    freq.put("X", 1480);
    freq.put("u\u0301t", 2986);
    freq.put("ia\u0301b", 6342);
    freq.put("jno", 2503);
    freq.put("ne\u0301p", 2342);
    freq.put("u\u0301r", 1723);
    freq.put("u\u0301s", 1934);
    freq.put("lf", 2782);
    freq.put("lg", 5358);
    freq.put("ld", 10308);
    freq.put("le", 93067);
    freq.put("lb", 4771);
    freq.put("lc", 4145);
    freq.put("la", 70668);
    freq.put("ln", 6206);
    freq.put("lo", 28055);
    freq.put("ll", 38085);
    freq.put("lm", 14166);
    freq.put("lj", 5903);
    freq.put("lk", 11727);
    freq.put("lh", 5532);
    freq.put("li", 35208);
    freq.put("lv", 12472);
    freq.put("lt", 43305);
    freq.put("lu", 8529);
    freq.put("lr", 2355);
    freq.put("ls", 10986);
    freq.put("Na", 3799);
    freq.put("asa", 1245);
    freq.put("zo\u0301 ", 13810);
    freq.put("ro\u030bl", 1883);
    freq.put("lz", 1116);
    freq.put("ly", 54235);
    freq.put("dae", 8117);
    freq.put("dal", 6673);
    freq.put("Car", 1146);
    freq.put("u\u0301 ", 9189);
    freq.put("dat", 1797);
    freq.put("dap", 1398);
    freq.put("dar", 6693);
    freq.put("das", 1500);
    freq.put("ema", 1264);
    freq.put("ogl", 2068);
    freq.put("nya", 6957);
    freq.put("l ", 91636);
    freq.put("emb", 4386);
    freq.put(" hi", 3276);
    freq.put(" ho", 8126);
    freq.put(" ha", 19271);
    freq.put(" he", 6504);
    freq.put("u\u030bko\u0308", 1244);
    freq.put("la\u0301", 37200);
    freq.put("res", 5836);
    freq.put("rep", 4197);
    freq.put("li\u0301", 3237);
    freq.put("ja\u0301r", 7148);
    freq.put("ret", 2640);
    freq.put("le\u0301", 24839);
    freq.put("lo\u0308", 4000);
    freq.put("rek", 3056);
    freq.put("lt ", 21002);
    freq.put("ren", 20766);
    freq.put("lo\u0301", 16644);
    freq.put("rel", 1449);
    freq.put("rem", 1197);
    freq.put("lu\u0308", 5880);
    freq.put("ja\u0301b", 8030);
    freq.put("reg", 2954);
    freq.put("red", 5622);
    freq.put("su\u0301 ", 1586);
    freq.put("ech", 1220);
    freq.put("ect", 1158);
    freq.put("ecs", 1616);
    freq.put("ie ", 1156);
    freq.put("zo\u030b ", 4019);
    freq.put("rci", 1283);
    freq.put("g", 317259);
    freq.put("lta", 8440);
    freq.put(" hi\u0301", 1381);
    freq.put(" ha\u0301", 4031);
    freq.put("lto", 3300);
    freq.put("u\u0308", 54519);
    freq.put("ta\u0301v", 1125);
    freq.put("e\u0301ny", 11240);
    freq.put("ta\u0301r", 7602);
    freq.put("ta\u0301s", 11209);
    freq.put("e\u0301nt", 3323);
    freq.put("h ", 4414);
    freq.put("rs ", 1186);
    freq.put("e\u0301ni", 1139);
    freq.put("lo\u030b", 14903);
    freq.put("ta\u0301l", 11084);
    freq.put("e\u0301ne", 8073);
    freq.put("ta\u0301n", 3887);
    freq.put("ta\u0301j", 1226);
    freq.put("ser", 4397);
    freq.put(" Sz", 12567);
    freq.put("be ", 8763);
    freq.put(" St", 3106);
    freq.put(" o\u0308n", 2076);
    freq.put(" o\u0308s", 3774);
    freq.put(" Si", 1425);
    freq.put(" So", 1606);
    freq.put(" Sc", 1193);
    freq.put(" Sa", 3377);
    freq.put(" Se", 1692);
    freq.put("ru\u0301g", 1325);
    freq.put("Ka", 3817);
    freq.put("ogy", 4073);
    freq.put("Ke", 1650);
    freq.put("to\u0308r", 6044);
    freq.put("rte\u0301", 4693);
    freq.put("Ki", 3017);
    freq.put("Ko", 2867);
    freq.put("rsa", 2647);
    freq.put("ogr", 1697);
    freq.put("Kr", 1187);
    freq.put("R", 12093);
    freq.put("rsz", 11249);
    freq.put("vas", 2577);
    freq.put("e\u0301n ", 10291);
    freq.put("udo", 3577);
    freq.put("o\u0301gi", 2210);
    freq.put("ben", 26680);
    freq.put("bel", 7243);
    freq.put("ru\u0308l", 11029);
    freq.put("ik ", 22104);
    freq.put("uro\u0301", 2193);
    freq.put("ber", 6263);
    freq.put("bes", 1771);
    freq.put("ybe", 1927);
    freq.put("bet", 1775);
    freq.put("are", 1125);
    freq.put("Par", 1124);
    freq.put("Pas", 2299);
    freq.put("sen", 5233);
    freq.put("sk", 7704);
    freq.put("mik", 1748);
    freq.put("sel", 3187);
    freq.put("ck ", 1275);
    freq.put("min", 10577);
    freq.put("mia", 1836);
    freq.put("sek", 2815);
    freq.put("a\u0301ul", 1145);
    freq.put("bur", 1175);
    freq.put("mit", 2000);
    freq.put("gha", 1393);
    freq.put(" El", 1692);
    freq.put("rse\u0301", 1351);
    freq.put(" Eg", 3214);
    freq.put("Ko\u0308", 2908);
    freq.put(" Ez", 1906);
    freq.put("da\u0301s", 3281);
    freq.put(" Eu", 1996);
    freq.put("ny ", 9196);
    freq.put(" Er", 1720);
    freq.put("urg", 1418);
    freq.put("ura", 2400);
    freq.put("mi ", 6215);
    freq.put("uri", 1391);
    freq.put("to\u0301 ", 7302);
    freq.put("de\u0301s", 3202);
    freq.put("szk", 3277);
    freq.put("szi", 9598);
    freq.put("szn", 4368);
    freq.put("szo", 9131);
    freq.put("szl", 6370);
    freq.put("sza", 14173);
    freq.put("sze", 35971);
    freq.put("ibe", 1135);
    freq.put("szt", 27632);
    freq.put("szu", 2442);
    freq.put("nge", 3949);
    freq.put(" ir", 2442);
    freq.put(" is", 10067);
    freq.put("ksz", 1790);
    freq.put("ae ", 11230);
    freq.put("yu\u0308t", 2463);
    freq.put(" il", 2853);
    freq.put(" in", 4519);
    freq.put("jai", 1887);
    freq.put("a\u0301k ", 11048);
    freq.put(" id", 3467);
    freq.put("ngy", 1650);
    freq.put(" ig", 3043);
    freq.put("kba", 2863);
    freq.put("no ", 1255);
    freq.put("sz ", 8870);
    freq.put("tba", 1669);
    freq.put("tbe", 3293);
    freq.put("gbe", 1509);
    freq.put("qu", 1194);
    freq.put("gba", 3483);
    freq.put("h", 131050);
    freq.put("a\u0301ku", 1940);
    freq.put("a\u0301ki", 3435);
    freq.put("ete\u0301", 6862);
    freq.put("va ", 3234);
    freq.put("ja ", 16271);
    freq.put("Pr", 2035);
    freq.put("ebe", 1132);
    freq.put("sze\u0301", 7434);
    freq.put("ebb", 4696);
    freq.put("szi\u0301", 4720);
    freq.put("o\u0308zp", 1522);
    freq.put("sza\u0301", 22866);
    freq.put("C", 21970);
    freq.put("ke ", 3579);
    freq.put("gyo", 4080);
    freq.put("vu\u030b", 1517);
    freq.put("Pa", 5475);
    freq.put("szu\u0308", 3008);
    freq.put("Pe", 2500);
    freq.put("ede", 6411);
    freq.put("szo\u0301", 5026);
    freq.put("Pi", 1727);
    freq.put("szo\u0308", 3515);
    freq.put("Po", 2747);
    freq.put("lus", 1938);
    freq.put("Bi\u0301r", 1270);
    freq.put("vo\u030b", 2313);
    freq.put("et ", 26086);
    freq.put("ksa\u0301", 2221);
    freq.put("\u043b", 1197);
    freq.put("sa\u0301t", 1861);
    freq.put("lul", 1401);
    freq.put("u\u0308k ", 2123);
    freq.put("ken", 2595);
    freq.put("kel", 6145);
    freq.put("ked", 3722);
    freq.put("o\u0308ld", 3665);
    freq.put("S", 35593);
    freq.put("kez", 5201);
    freq.put("jog", 1359);
    freq.put("ket", 5479);
    freq.put("kes", 2444);
    freq.put("ker", 9767);
    freq.put("etr", 2609);
    freq.put("ets", 2876);
    freq.put("etv", 2394);
    freq.put("ett", 18422);
    freq.put("etb", 3254);
    freq.put("tla", 1565);
    freq.put("eta", 1302);
    freq.put("tle", 4022);
    freq.put("ete", 14739);
    freq.put("etk", 2537);
    freq.put("eti", 8705);
    freq.put("etl", 3489);
    freq.put("ck", 3543);
    freq.put("va\u0301", 29898);
    freq.put("ci", 18130);
    freq.put("ch", 10237);
    freq.put("co", 5597);
    freq.put("cc", 1311);
    freq.put("ve\u0301", 17783);
    freq.put("ca", 6636);
    freq.put("vi\u0301", 2765);
    freq.put("ce", 11684);
    freq.put("edi", 4113);
    freq.put("vo\u0308", 1632);
    freq.put("cs", 39940);
    freq.put("cr", 1412);
    freq.put("cu", 2732);
    freq.put("ct", 3944);
    freq.put("vi\u0301z", 2022);
    freq.put("rve", 3364);
    freq.put("bbi", 2623);
    freq.put("me\u0301n", 4256);
    freq.put("to\u0308b", 3419);
    freq.put("lep", 3720);
    freq.put("bba", 2240);
    freq.put("yar", 8873);
    freq.put("yal", 1350);
    freq.put("yan", 3850);
    freq.put("yai", 1283);
    freq.put("yak", 3842);
    freq.put("pia", 1507);
    freq.put("tsz", 2410);
    freq.put("me\u0301s", 1202);
    freq.put("me\u0301r", 2829);
    freq.put("me\u0301t", 1869);
    freq.put("oto", 1925);
    freq.put("ve\u0301n", 5253);
    freq.put("c ", 4126);
    freq.put("so\u030b ", 5513);
    freq.put("ott", 13732);
    freq.put("o\u0308bb", 3612);
    freq.put("A\u0301ll", 1152);
    freq.put("ve\u0301s", 2023);
    freq.put("e\u0301", 327830);
    freq.put("bb ", 12760);
    freq.put("ysz", 2663);
    freq.put("ilo", 2015);
    freq.put("rbe", 1412);
    freq.put("eur", 1117);
    freq.put("ya ", 3038);
    freq.put("rba", 1762);
    freq.put("va", 38110);
    freq.put("ce\u0301", 2844);
    freq.put(" Fr", 2248);
    freq.put("ve", 52514);
    freq.put("ci\u0301", 4683);
    freq.put("vi", 19889);
    freq.put("vo", 15593);
    freq.put(" Fa", 1224);
    freq.put("vt", 2486);
    freq.put("avi", 1292);
    freq.put(" Fi", 1161);
    freq.put("ava", 2849);
    freq.put(" Fo", 1535);
    freq.put("va\u0301k", 7162);
    freq.put("of ", 1189);
    freq.put("e\u0301me", 4235);
    freq.put("va\u0301l", 6881);
    freq.put(" e\u0301p", 2514);
    freq.put(" e\u0301r", 4015);
    freq.put(" e\u0301s", 39564);
    freq.put(" e\u0301v", 4437);
    freq.put(" e\u0301l", 3293);
    freq.put(" e\u0301n", 2210);
    freq.put("va\u0301r", 8676);
    freq.put("zga", 2049);
    freq.put("v ", 9584);
    freq.put("eto\u030b", 6086);
    freq.put("pha", 1287);
    freq.put("lga\u0301", 2219);
    freq.put("ion", 3768);
    freq.put("von", 3245);
    freq.put("yse\u0301", 2805);
    freq.put("etu\u030b", 3115);
    freq.put("lme\u0301", 1286);
    freq.put("i", 506132);
    freq.put(" Tu", 1156);
    freq.put(" Tr", 2468);
    freq.put("ju\u0301 ", 1653);
    freq.put(" To", 1786);
    freq.put(" Ti", 1460);
    freq.put(" Th", 2520);
    freq.put(" Te", 2728);
    freq.put(" Ta", 2270);
    freq.put("rzo\u030b", 1316);
    freq.put("yob", 2167);
    freq.put("nov", 1101);
    freq.put("Be", 4063);
    freq.put("adt", 1359);
    freq.put("Ba", 3859);
    freq.put("a\u0301t ", 7693);
    freq.put("kka", 1690);
    freq.put("Bo", 3301);
    freq.put("Bi", 1847);
    freq.put("ske", 1576);
    freq.put("Bu", 2584);
    freq.put("ska", 1477);
    freq.put("Br", 2522);
    freq.put("ada", 7719);
    freq.put("a\u0301ja", 2888);
    freq.put("esi\u0301", 1394);
    freq.put("e\u0301s ", 42926);
    freq.put("zo\u0308v", 1986);
    freq.put("o\u0301ma", 1626);
    freq.put("adi", 3222);
    freq.put("lla", 10657);
    freq.put("T", 19473);
    freq.put("e\u0301sz", 20296);
    freq.put("B ", 1118);
    freq.put("a\u0301to", 1839);
    freq.put("e\u0301st", 1350);
    freq.put("e\u0301si", 1788);
    freq.put("a\u0301ts", 1437);
    freq.put("ad ", 2344);
    freq.put(" ja\u0301", 7979);
    freq.put("e\u0301se", 7910);
    freq.put("la\u0301b", 2286);
    freq.put("jle", 1493);
    freq.put("est", 5914);
    freq.put("ess", 3758);
    freq.put("ado\u0301", 2898);
    freq.put("Bi\u0301", 1300);
    freq.put("yo\u0301 ", 1102);
    freq.put("ino\u030b", 1958);
    freq.put("ya\u0301r", 2315);
    freq.put("ese", 5978);
    freq.put("ya\u0301n", 7191);
    freq.put("ada\u0301", 3539);
    freq.put("a\u0301ja\u0301", 1672);
    freq.put("ria\u0301", 1542);
    freq.put("esi", 1683);
    freq.put("ya\u0301b", 1633);
    freq.put("lte\u0301", 1277);
    freq.put("ndi", 2220);
    freq.put("ndj", 9787);
    freq.put("ndo", 2353);
    freq.put("nda", 1524);
    freq.put("nde", 6999);
    freq.put("a\u0301te\u0301", 2725);
    freq.put("e\u0301se\u0301", 4210);
    freq.put("a\u0301to\u0301", 1225);
    freq.put("es ", 29789);
    freq.put(" je", 10035);
    freq.put("nds", 3385);
    freq.put("kra", 2981);
    freq.put(" ja", 1594);
    freq.put("su\u0308l", 2209);
    freq.put("o\u0308b", 4016);
    freq.put("C ", 1489);
    freq.put("o\u0308d", 2116);
    freq.put("o\u0308g", 3454);
    freq.put("ea ", 1332);
    freq.put("o\u0308k", 5801);
    freq.put("o\u0308l", 8906);
    freq.put("o\u0308m", 1336);
    freq.put("o\u0308n", 10766);
    freq.put("o\u0308r", 17835);
    freq.put("o\u0308s", 7442);
    freq.put("o\u0308t", 9388);
    freq.put("o\u0308v", 8122);
    freq.put("o\u0308z", 26938);
    freq.put("van", 3020);
    freq.put("val", 9128);
    freq.put("Ame", 1184);
    freq.put("vag", 11793);
    freq.put("vad", 1432);
    freq.put("gra", 2375);
    freq.put("var", 2245);
    freq.put("rce", 1814);
    freq.put("mu\u030bk", 1274);
    freq.put("vat", 2280);
    freq.put("esz", 10684);
    freq.put("hy", 1869);
    freq.put("hr", 1649);
    freq.put("le\u0301s", 5210);
    freq.put("eae", 1455);
    freq.put("ht", 1620);
    freq.put("hu", 2691);
    freq.put("hi", 9568);
    freq.put("hn", 1454);
    freq.put("ho", 21034);
    freq.put("bum", 2164);
    freq.put("ha", 38767);
    freq.put("he", 27807);
    freq.put("lvt", 1957);
    freq.put("e\u0301su\u030b", 1277);
    freq.put("j", 133885);
    freq.put("lve", 3172);
    freq.put("lva", 1622);
    freq.put("zot", 2710);
    freq.put("lso\u0301", 1363);
    freq.put("int", 11506);
    freq.put("inu", 1420);
    freq.put("mu\u030bv", 2529);
    freq.put("ino", 2798);
    freq.put("ini", 2901);
    freq.put("ink", 1323);
    freq.put("ind", 5305);
    freq.put("ine", 3645);
    freq.put("ing", 3990);
    freq.put("ina", 5669);
    freq.put("inc", 1595);
    freq.put("so\u0301 ", 1339);
    freq.put("or ", 6588);
    freq.put("\u043d", 1605);
    freq.put("gar", 1902);
    freq.put("he\u0301", 2687);
    freq.put("U", 4237);
    freq.put("hi\u0301", 1890);
    freq.put("ha\u0301", 9402);
    freq.put("in ", 5995);
    freq.put("i\u0301g", 1483);
    freq.put("i\u0301m", 4915);
    freq.put("i\u0301l", 1523);
    freq.put("i\u0301n", 4459);
    freq.put("i\u0301k", 1149);
    freq.put("i\u0301j", 1882);
    freq.put("i\u0301t", 21446);
    freq.put("i\u0301v", 3409);
    freq.put("lva\u0301", 1133);
    freq.put("rre", 1962);
    freq.put("i\u0301r", 8949);
    freq.put("ja\u0301t", 5567);
    freq.put("i\u0301z", 3248);
  }
  
}

