package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HR extends CLangProfile {
  private static final String name = "hr";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HR() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 5153330;
    n_words[1] = 5928363;
    n_words[2] = 4281211;

    freq.put("up ", 535);
    freq.put("\u0111en", 1909);
    freq.put("aus", 601);
    freq.put("\u0111er", 597);
    freq.put("aut", 1108);
    freq.put(" Gv", 612);
    freq.put(" Gu", 878);
    freq.put(" Gr", 2247);
    freq.put("ec\u030ci", 628);
    freq.put(" Ge", 702);
    freq.put(" Ga", 961);
    freq.put(" Go", 1534);
    freq.put(" Gl", 525);
    freq.put("s\u030ce ", 976);
    freq.put("upn", 605);
    freq.put("Gv", 612);
    freq.put("Gu", 881);
    freq.put("Gr", 2253);
    freq.put("upi", 4500);
    freq.put("upe", 980);
    freq.put("upa", 2662);
    freq.put("mlj", 1522);
    freq.put("Ge", 716);
    freq.put("Ga", 972);
    freq.put("Go", 1536);
    freq.put("Gl", 526);
    freq.put("zda", 1154);
    freq.put(" ka", 7800);
    freq.put("me ", 5240);
    freq.put(" ki", 1128);
    freq.put(" kn", 829);
    freq.put(" ko", 26854);
    freq.put(" kl", 1410);
    freq.put(" km", 1048);
    freq.put(" kr", 4664);
    freq.put(" ku", 1972);
    freq.put("nen", 652);
    freq.put("nej", 882);
    freq.put("nek", 2622);
    freq.put("gl ", 618);
    freq.put("kup", 5219);
    freq.put("slo", 1832);
    freq.put("nez", 1162);
    freq.put("ilm", 540);
    freq.put("net", 1026);
    freq.put("ak ", 2449);
    freq.put("ner", 1509);
    freq.put("nes", 1293);
    freq.put("nep", 734);
    freq.put("med", 673);
    freq.put("mel", 710);
    freq.put("men", 6548);
    freq.put("ors", 1607);
    freq.put("met", 3414);
    freq.put("mer", 3791);
    freq.put("Ze", 593);
    freq.put("k", 204303);
    freq.put("dru", 5517);
    freq.put("gle", 1361);
    freq.put("aku", 618);
    freq.put("akt", 1211);
    freq.put("aki", 683);
    freq.put("orm", 1284);
    freq.put("ako", 4291);
    freq.put("dra", 1195);
    freq.put("aka", 2848);
    freq.put("dre", 1145);
    freq.put("ake", 1450);
    freq.put("ku ", 4982);
    freq.put("bro", 2066);
    freq.put("bri", 882);
    freq.put("bra", 1828);
    freq.put("dne", 953);
    freq.put("dna", 2624);
    freq.put("m ", 37899);
    freq.put("dno", 6490);
    freq.put("dni", 3564);
    freq.put("dnj", 1612);
    freq.put("vol", 582);
    freq.put("er ", 4432);
    freq.put("uc\u030cj", 2470);
    freq.put("ni ", 16130);
    freq.put("nka", 782);
    freq.put("Sta", 754);
    freq.put("voj", 3212);
    freq.put("V", 5850);
    freq.put("iv", 14019);
    freq.put("me", 24452);
    freq.put("eru", 1435);
    freq.put("erv", 605);
    freq.put("ma", 31717);
    freq.put("ltu", 737);
    freq.put("mb", 2862);
    freq.put("ml", 1963);
    freq.put("mo", 11753);
    freq.put("mn", 1665);
    freq.put("mi", 10591);
    freq.put("mj", 5104);
    freq.put("mu", 3945);
    freq.put("ere", 1639);
    freq.put("erg", 698);
    freq.put("tna", 778);
    freq.put("mp", 2261);
    freq.put("ms", 2000);
    freq.put("mr", 1000);
    freq.put("erm", 720);
    freq.put("ern", 3520);
    freq.put("ero", 2614);
    freq.put("tni", 2342);
    freq.put("eri", 7215);
    freq.put("ec\u030ce", 573);
    freq.put("Le", 881);
    freq.put("ic\u0301a", 608);
    freq.put("La", 1685);
    freq.put("Lo", 1036);
    freq.put("la ", 9649);
    freq.put("Li", 1283);
    freq.put("ov ", 1004);
    freq.put("Lu", 593);
    freq.put("ual", 550);
    freq.put("uan", 840);
    freq.put("ena", 7266);
    freq.put("ib", 2814);
    freq.put("end", 836);
    freq.put("ene", 3561);
    freq.put("eng", 1640);
    freq.put("eni", 7665);
    freq.put("enj", 3407);
    freq.put("Kan", 524);
    freq.put("Kal", 564);
    freq.put("hov", 1213);
    freq.put("Kar", 752);
    freq.put("ens", 1955);
    freq.put("ent", 3912);
    freq.put("enu", 1213);
    freq.put("A", 14720);
    freq.put("lam", 781);
    freq.put("lan", 3996);
    freq.put("L ", 681);
    freq.put("lak", 731);
    freq.put("lad", 1494);
    freq.put("lag", 644);
    freq.put("lac", 1275);
    freq.put("ova", 7007);
    freq.put("laz", 5016);
    freq.put("ove", 3130);
    freq.put("ovj", 940);
    freq.put("ua ", 834);
    freq.put("lav", 4030);
    freq.put("ovi", 7022);
    freq.put("ovn", 2887);
    freq.put("ovo", 6487);
    freq.put("lar", 880);
    freq.put("las", 3015);
    freq.put("en ", 4377);
    freq.put(" c\u030ce", 1938);
    freq.put("drz\u030c", 4140);
    freq.put(" c\u030cl", 530);
    freq.put(" c\u030ci", 1960);
    freq.put("zan", 918);
    freq.put(" Hr", 2946);
    freq.put(" Hu", 528);
    freq.put("zem", 1449);
    freq.put("zer", 1084);
    freq.put(" Hi", 565);
    freq.put("zam", 819);
    freq.put(" Ho", 895);
    freq.put(" Ha", 1336);
    freq.put(" He", 1372);
    freq.put("ima", 9207);
    freq.put("ime", 3556);
    freq.put("c\u030ce ", 853);
    freq.put("imi", 856);
    freq.put("imo", 723);
    freq.put("imp", 613);
    freq.put(" ga", 1134);
    freq.put("fik", 566);
    freq.put("fin", 592);
    freq.put("fil", 896);
    freq.put(" Va", 1018);
    freq.put("es\u030ck", 669);
    freq.put(" Ve", 1517);
    freq.put("upo", 759);
    freq.put(" Vi", 1035);
    freq.put(" Vo", 661);
    freq.put("zac", 771);
    freq.put("toc\u030c", 2840);
    freq.put("es\u030ct", 1289);
    freq.put("im ", 10462);
    freq.put("c\u030cen", 1159);
    freq.put("l", 177559);
    freq.put("c\u030cet", 1250);
    freq.put("c\u030ces", 595);
    freq.put("nij", 6542);
    freq.put("ras\u030c", 597);
    freq.put("s\u030cnj", 2421);
    freq.put("raz\u030c", 797);
    freq.put("nt ", 937);
    freq.put("rt", 5687);
    freq.put("ru", 17434);
    freq.put("rv", 8435);
    freq.put(" zn", 2259);
    freq.put("rp", 1334);
    freq.put("at ", 2601);
    freq.put("rs", 8936);
    freq.put(" ze", 1108);
    freq.put("god", 2754);
    freq.put("dst", 1252);
    freq.put("ajs", 690);
    freq.put(" za", 12881);
    freq.put("aju", 3559);
    freq.put("rz", 1007);
    freq.put(" zb", 633);
    freq.put("rd", 3070);
    freq.put("re", 32485);
    freq.put("rg", 3269);
    freq.put("ra", 64303);
    freq.put("ajn", 1118);
    freq.put("rc", 1885);
    freq.put("rl", 1655);
    freq.put("aja", 1758);
    freq.put("rn", 10194);
    freq.put("is ", 1700);
    freq.put("rh", 1312);
    freq.put("aje", 2556);
    freq.put("gos", 769);
    freq.put("rk", 2924);
    freq.put("ntr", 1002);
    freq.put("nti", 2109);
    freq.put("W", 3179);
    freq.put("nta", 2295);
    freq.put("nte", 1843);
    freq.put("rac\u0301", 609);
    freq.put("ate", 2791);
    freq.put("ata", 3446);
    freq.put("atn", 1424);
    freq.put("ato", 2245);
    freq.put("isp", 569);
    freq.put("atk", 562);
    freq.put("isu", 779);
    freq.put("ist", 10340);
    freq.put("isk", 1391);
    freq.put("isi", 976);
    freq.put("atu", 1171);
    freq.put("atr", 1028);
    freq.put("ats", 4995);
    freq.put("isl", 604);
    freq.put("isc", 574);
    freq.put("isa", 1555);
    freq.put(" Sp", 836);
    freq.put("ise", 556);
    freq.put("nir", 714);
    freq.put("osa", 1092);
    freq.put("nis", 1359);
    freq.put("tem", 1590);
    freq.put("tor", 3179);
    freq.put("top", 785);
    freq.put("tov", 1949);
    freq.put("toj", 1710);
    freq.put("tok", 3601);
    freq.put("toi", 723);
    freq.put("ton", 1847);
    freq.put("tol", 1732);
    freq.put("tom", 1889);
    freq.put("toc", 579);
    freq.put("tog", 984);
    freq.put(" le", 827);
    freq.put("B", 12556);
    freq.put(" la", 2172);
    freq.put(" lo", 1177);
    freq.put(" lj", 2291);
    freq.put(" li", 2543);
    freq.put("c\u030ces\u030c", 556);
    freq.put("z\u030ci", 5092);
    freq.put("ktu", 654);
    freq.put("i\u0301", 886);
    freq.put("ktr", 973);
    freq.put("kti", 1269);
    freq.put("to ", 5478);
    freq.put("raf", 1147);
    freq.put("rag", 678);
    freq.put("rad", 6716);
    freq.put("lbu", 1947);
    freq.put("rac", 1934);
    freq.put("ran", 11269);
    freq.put("ral", 3163);
    freq.put("ram", 1816);
    freq.put("raj", 3616);
    freq.put("rak", 1775);
    freq.put("ose", 1141);
    freq.put("rav", 4237);
    freq.put("rat", 4060);
    freq.put("ras", 1520);
    freq.put("rap", 1294);
    freq.put("raz", 4813);
    freq.put("ter", 4781);
    freq.put("rz\u030c", 4670);
    freq.put("rs\u030c", 1722);
    freq.put("on ", 4329);
    freq.put("ra ", 9271);
    freq.put("y", 9646);
    freq.put("rc\u030c", 1709);
    freq.put("dok", 659);
    freq.put("don", 1767);
    freq.put("dol", 970);
    freq.put("dom", 1052);
    freq.put("dob", 1518);
    freq.put("m", 139424);
    freq.put("uda", 924);
    freq.put("dos", 617);
    freq.put("dov", 1189);
    freq.put(" Wa", 1098);
    freq.put("d ", 22851);
    freq.put(" Wi", 714);
    freq.put("pc\u0301i", 2432);
    freq.put("ac\u030ci", 1814);
    freq.put("ac\u030ck", 3501);
    freq.put("em ", 3991);
    freq.put("ac\u030ca", 1970);
    freq.put("hrv", 1503);
    freq.put("ac\u030ce", 950);
    freq.put("os\u030c ", 708);
    freq.put("kul", 1164);
    freq.put("ba ", 2218);
    freq.put("ac\u030cu", 958);
    freq.put("dn", 15638);
    freq.put("do", 12624);
    freq.put("dl", 806);
    freq.put("dm", 1005);
    freq.put("dj", 3005);
    freq.put("di", 30316);
    freq.put("dg", 624);
    freq.put("de", 10224);
    freq.put("db", 626);
    freq.put("da", 22107);
    freq.put("dv", 2741);
    freq.put("e\u0301 ", 601);
    freq.put("du", 5516);
    freq.put("dr", 13255);
    freq.put("ds", 4759);
    freq.put("bav", 860);
    freq.put("bar", 843);
    freq.put("eml", 1258);
    freq.put("emo", 840);
    freq.put("emi", 1481);
    freq.put("ban", 1537);
    freq.put("bal", 1792);
    freq.put("om ", 17269);
    freq.put("w ", 858);
    freq.put("nut", 1280);
    freq.put("Per", 568);
    freq.put("is\u030c", 6125);
    freq.put("rz\u030ca", 4071);
    freq.put("il ", 644);
    freq.put("nic\u030c", 2517);
    freq.put("iri", 1540);
    freq.put("iro", 1457);
    freq.put("ira", 5142);
    freq.put("mun", 787);
    freq.put("ire", 1683);
    freq.put("we", 956);
    freq.put("wa", 2878);
    freq.put("zbo", 641);
    freq.put("omi", 1374);
    freq.put(" Is", 977);
    freq.put("omo", 1785);
    freq.put("wi", 861);
    freq.put("omp", 729);
    freq.put(" In", 4605);
    freq.put("nu ", 5412);
    freq.put("ile", 865);
    freq.put("ell", 698);
    freq.put("ila", 3734);
    freq.put("ilo", 2029);
    freq.put("ill", 863);
    freq.put(" IS", 2110);
    freq.put("ilj", 1386);
    freq.put("ili", 10385);
    freq.put("una", 2557);
    freq.put("ilu", 562);
    freq.put("ic\u030c", 14290);
    freq.put("ils", 642);
    freq.put("ir ", 678);
    freq.put("uni", 993);
    freq.put("ic\u0301", 2802);
    freq.put(" me", 3676);
    freq.put(" ma", 4891);
    freq.put(" mn", 528);
    freq.put(" mo", 4787);
    freq.put(" mi", 2188);
    freq.put(" mj", 1905);
    freq.put(" mu", 1067);
    freq.put("san", 1142);
    freq.put("fra", 927);
    freq.put("sam", 1694);
    freq.put("rga", 1240);
    freq.put("fri", 721);
    freq.put("ai ", 709);
    freq.put("pri", 7027);
    freq.put("dz\u030c", 894);
    freq.put("dsk", 2664);
    freq.put("sad", 738);
    freq.put("Ch", 1843);
    freq.put("Co", 1834);
    freq.put("grc\u030c", 1302);
    freq.put("slu", 1752);
    freq.put("Ca", 2160);
    freq.put("Ce", 588);
    freq.put("n", 342270);
    freq.put("ain", 623);
    freq.put("sli", 1331);
    freq.put("slj", 632);
    freq.put("gla", 3728);
    freq.put("Cr", 1328);
    freq.put("sla", 2093);
    freq.put("iz", 19026);
    freq.put("opu", 936);
    freq.put("ip", 4978);
    freq.put("is", 21664);
    freq.put("ir", 12272);
    freq.put("iu", 848);
    freq.put("it", 16417);
    freq.put("Nal", 560);
    freq.put("Za", 2365);
    freq.put("ih", 18991);
    freq.put("ik", 23850);
    freq.put("ij", 57037);
    freq.put("im", 27723);
    freq.put("il", 22797);
    freq.put("io", 10059);
    freq.put("in", 47299);
    freq.put("ia", 4852);
    freq.put("ic", 20781);
    freq.put("ki ", 16671);
    freq.put("ie", 2060);
    freq.put("id", 4699);
    freq.put("ig", 5433);
    freq.put("if", 1923);
    freq.put("uje", 2393);
    freq.put("th ", 723);
    freq.put("\u0441", 742);
    freq.put("nik", 4325);
    freq.put("nih", 6201);
    freq.put("nin", 1303);
    freq.put("nim", 4415);
    freq.put("nic", 5054);
    freq.put("niz", 1589);
    freq.put("kih", 5870);
    freq.put("kin", 753);
    freq.put("kim", 2628);
    freq.put("ic\u0301 ", 1370);
    freq.put("Y", 1450);
    freq.put("i ", 135497);
    freq.put("nit", 879);
    freq.put("mil", 697);
    freq.put("Va", 1022);
    freq.put("Ve", 1522);
    freq.put("Vi", 1040);
    freq.put("epu", 2109);
    freq.put("epr", 650);
    freq.put("Vo", 662);
    freq.put("epo", 647);
    freq.put("the", 1111);
    freq.put("sje", 4603);
    freq.put("rs\u030ci", 715);
    freq.put("epa", 580);
    freq.put("rn ", 540);
    freq.put("elj", 5961);
    freq.put("eli", 4944);
    freq.put("elo", 2967);
    freq.put("han", 1101);
    freq.put("ela", 3182);
    freq.put("ele", 2918);
    freq.put("bno", 610);
    freq.put("har", 926);
    freq.put("elu", 1458);
    freq.put("rnj", 845);
    freq.put("rni", 2710);
    freq.put("rno", 2932);
    freq.put("D", 8690);
    freq.put("opr", 664);
    freq.put("ops", 861);
    freq.put("rna", 1479);
    freq.put("rne", 1371);
    freq.put("ope", 858);
    freq.put("opa", 775);
    freq.put("opl", 1169);
    freq.put("c\u030cun", 831);
    freq.put("opi", 1778);
    freq.put("sma", 1116);
    freq.put("vis", 1291);
    freq.put("ha ", 913);
    freq.put("el ", 1052);
    freq.put("Ara", 578);
    freq.put("ola", 1856);
    freq.put("ole", 1119);
    freq.put(" Ju", 1556);
    freq.put("oli", 4446);
    freq.put("olj", 2400);
    freq.put("olo", 3261);
    freq.put(" Jo", 707);
    freq.put("ols", 789);
    freq.put("olu", 1664);
    freq.put(" Je", 1023);
    freq.put(" Ja", 1447);
    freq.put("ici", 6028);
    freq.put("ich", 645);
    freq.put("for", 1658);
    freq.put("z\u030cbe", 582);
    freq.put("Hr", 2959);
    freq.put("ica", 6876);
    freq.put("ice", 4697);
    freq.put("Hu", 536);
    freq.put("ume", 724);
    freq.put("zu ", 768);
    freq.put("Hi", 570);
    freq.put("uma", 1379);
    freq.put("Ho", 905);
    freq.put("umb", 688);
    freq.put("Ha", 1340);
    freq.put("umi", 603);
    freq.put("icu", 773);
    freq.put("He", 1374);
    freq.put("ol ", 664);
    freq.put("tic\u030c", 3116);
    freq.put("ple", 3986);
    freq.put("pla", 1804);
    freq.put("plo", 1052);
    freq.put("plj", 816);
    freq.put("pli", 1041);
    freq.put("obn", 555);
    freq.put("obo", 933);
    freq.put("obl", 1881);
    freq.put("obj", 1316);
    freq.put("obi", 2599);
    freq.put("lju", 4071);
    freq.put("ic ", 604);
    freq.put("o", 415815);
    freq.put("oba", 2782);
    freq.put("um ", 2138);
    freq.put("H ", 574);
    freq.put("obu", 893);
    freq.put("obr", 1117);
    freq.put("zum", 625);
    freq.put("aha", 673);
    freq.put("mbi", 905);
    freq.put("son", 650);
    freq.put("sov", 613);
    freq.put("opo", 690);
    freq.put("art", 1393);
    freq.put("opc\u0301", 1972);
    freq.put("gin", 523);
    freq.put("gij", 2556);
    freq.put("\u0442", 629);
    freq.put("Z", 4251);
    freq.put("azi", 7453);
    freq.put("azl", 1063);
    freq.put("azn", 685);
    freq.put("aza", 1040);
    freq.put("azb", 1010);
    freq.put("aze", 804);
    freq.put("wa ", 713);
    freq.put("gi ", 831);
    freq.put("azu", 592);
    freq.put("azv", 1013);
    freq.put(" Li", 1265);
    freq.put("ni", 54450);
    freq.put("nj", 27833);
    freq.put("nk", 2801);
    freq.put("nn", 1399);
    freq.put("no", 45797);
    freq.put("tit", 1406);
    freq.put("na", 87240);
    freq.put("tiv", 2430);
    freq.put("nc", 5972);
    freq.put("nd", 11672);
    freq.put("ne", 33576);
    freq.put("nf", 891);
    freq.put("ng", 7899);
    freq.put("til", 813);
    freq.put("ny", 715);
    freq.put("nz", 952);
    freq.put("tio", 1426);
    freq.put("tih", 692);
    freq.put("tij", 2254);
    freq.put("tik", 1009);
    freq.put("ns", 14593);
    freq.put("nt", 10450);
    freq.put("nu", 8144);
    freq.put("tic", 2096);
    freq.put(" ni", 1874);
    freq.put(" nj", 3220);
    freq.put("E", 5169);
    freq.put(" no", 2407);
    freq.put("kva", 701);
    freq.put(" na", 34503);
    freq.put(" ne", 6451);
    freq.put("n ", 24345);
    freq.put("fsk", 622);
    freq.put("ti ", 9529);
    freq.put("roi", 1622);
    freq.put("roj", 2300);
    freq.put("rok", 933);
    freq.put("rol", 793);
    freq.put("rom", 2618);
    freq.put("ron", 1652);
    freq.put("roa", 633);
    freq.put("rob", 584);
    freq.put("roc", 1470);
    freq.put("rod", 8265);
    freq.put("ost", 8908);
    freq.put("rog", 1195);
    freq.put("osi", 1554);
    freq.put("roz", 1266);
    freq.put("osl", 1958);
    freq.put("oso", 1519);
    freq.put("osn", 2717);
    freq.put("rop", 1763);
    freq.put("lla", 657);
    freq.put("ros", 2073);
    freq.put("rot", 1439);
    freq.put("rov", 2438);
    freq.put("vet", 804);
    freq.put("gu ", 1902);
    freq.put("ver", 4932);
    freq.put("is\u030ce", 1062);
    freq.put("di ", 4014);
    freq.put("aj ", 1426);
    freq.put("ved", 700);
    freq.put("ven", 3207);
    freq.put("is\u030ct", 2503);
    freq.put("vel", 1857);
    freq.put("jve", 805);
    freq.put(" do", 6878);
    freq.put("ro ", 1317);
    freq.put("os ", 1176);
    freq.put("ll ", 619);
    freq.put("kla", 1495);
    freq.put("ry", 930);
    freq.put("din", 5519);
    freq.put("dio", 1844);
    freq.put("dij", 7896);
    freq.put("ers", 1367);
    freq.put("dic", 3889);
    freq.put("p", 126499);
    freq.put("ve ", 5319);
    freq.put("umj", 671);
    freq.put("der", 1371);
    freq.put("dis", 1126);
    freq.put("des", 966);
    freq.put("ruk", 844);
    freq.put("Rep", 1934);
    freq.put("sre", 2282);
    freq.put("klj", 755);
    freq.put("Gra", 1106);
    freq.put("ek ", 753);
    freq.put("zra", 1677);
    freq.put("mac\u030c", 1334);
    freq.put("rva", 5151);
    freq.put("era", 4007);
    freq.put("Me", 1818);
    freq.put("bo", 6809);
    freq.put("Ma", 5853);
    freq.put("Mo", 1972);
    freq.put("erc", 963);
    freq.put("Mi", 1887);
    freq.put("rug", 4029);
    freq.put("Mu", 793);
    freq.put("ze ", 973);
    freq.put("O", 10729);
    freq.put("tno", 1901);
    freq.put("eko", 2778);
    freq.put("eki", 802);
    freq.put("bor", 1232);
    freq.put("eka", 2350);
    freq.put("ngl", 1753);
    freq.put("boj", 638);
    freq.put("bol", 1257);
    freq.put("eku", 789);
    freq.put("ekt", 2568);
    freq.put("eks", 1589);
    freq.put("bog", 903);
    freq.put("ipa", 1930);
    freq.put("dis\u030c", 1956);
    freq.put("ugo", 2301);
    freq.put("jan", 5965);
    freq.put(" Ka", 3666);
    freq.put("ae ", 719);
    freq.put(" Ki", 914);
    freq.put("aya", 527);
    freq.put(" Ko", 2481);
    freq.put(" Kr", 1745);
    freq.put("msk", 1673);
    freq.put(" Ku", 843);
    freq.put("ca ", 10450);
    freq.put("jak", 822);
    freq.put("F", 5109);
    freq.put("uz ", 1098);
    freq.put("vec\u0301", 1856);
    freq.put("car", 656);
    freq.put("ibe", 551);
    freq.put("ult", 1215);
    freq.put("tvo", 2139);
    freq.put("uli", 687);
    freq.put("can", 1075);
    freq.put("ula", 1753);
    freq.put(" on", 1068);
    freq.put(" ok", 4011);
    freq.put("ao ", 5760);
    freq.put(" of", 856);
    freq.put(" od", 15714);
    freq.put(" ob", 6528);
    freq.put("ma ", 15645);
    freq.put(" oz", 1224);
    freq.put("spo", 2263);
    freq.put(" ov", 1276);
    freq.put("spa", 672);
    freq.put(" ot", 2810);
    freq.put(" or", 1765);
    freq.put(" os", 3950);
    freq.put(" op", 3149);
    freq.put("s ", 15910);
    freq.put("mas", 812);
    freq.put("sne", 697);
    freq.put("mat", 2524);
    freq.put("sna", 922);
    freq.put("sno", 3094);
    freq.put(" o ", 1165);
    freq.put("sni", 2255);
    freq.put("mac", 714);
    freq.put("enc", 1218);
    freq.put("mak", 533);
    freq.put("maj", 623);
    freq.put("mal", 2079);
    freq.put("man", 3666);
    freq.put("zna", 6328);
    freq.put("ss", 1881);
    freq.put("sr", 3449);
    freq.put("zni", 942);
    freq.put("sp", 5046);
    freq.put("zno", 753);
    freq.put("sv", 6451);
    freq.put("su", 13292);
    freq.put("st", 55588);
    freq.put("q", 1755);
    freq.put("sj", 4697);
    freq.put("si", 10381);
    freq.put("sh", 2381);
    freq.put("so", 5247);
    freq.put("sn", 7159);
    freq.put("sm", 3278);
    freq.put("sl", 7897);
    freq.put("sc", 1522);
    freq.put("sa", 16094);
    freq.put("se", 24429);
    freq.put("Ru", 1026);
    freq.put("ro", 34834);
    freq.put("Chi", 621);
    freq.put("no ", 15032);
    freq.put("lsk", 2111);
    freq.put("Re", 2977);
    freq.put("sob", 1342);
    freq.put("Ra", 1418);
    freq.put("Ro", 1097);
    freq.put("Ri", 1491);
    freq.put("jin", 1845);
    freq.put("jim", 3670);
    freq.put(" al", 3416);
    freq.put(" am", 2645);
    freq.put(" an", 1498);
    freq.put("jiv", 803);
    freq.put(" ar", 1418);
    freq.put(" at", 615);
    freq.put(" au", 1442);
    freq.put("me\u0111", 2505);
    freq.put("nom", 6601);
    freq.put("tje", 1395);
    freq.put("noj", 3137);
    freq.put("nog", 6035);
    freq.put("noa", 520);
    freq.put("ert", 600);
    freq.put("c\u030cna", 751);
    freq.put("ng ", 2367);
    freq.put("nov", 4240);
    freq.put("nor", 535);
    freq.put("nos", 6166);
    freq.put(" a ", 4274);
    freq.put("ji ", 16045);
    freq.put("ndu", 534);
    freq.put("em", 19226);
    freq.put("el", 24518);
    freq.put("eo", 3348);
    freq.put("en", 44674);
    freq.put("ei", 1534);
    freq.put("eh", 1279);
    freq.put("ek", 14461);
    freq.put("ej", 2546);
    freq.put("ee", 1826);
    freq.put("ed", 22606);
    freq.put("eg", 7983);
    freq.put("ef", 1181);
    freq.put("ea", 3988);
    freq.put("ec", 3773);
    freq.put("eb", 4045);
    freq.put("ey", 838);
    freq.put("ez", 15435);
    freq.put("eu", 1755);
    freq.put("et", 18394);
    freq.put("ew", 844);
    freq.put("ev", 10791);
    freq.put("ep", 5699);
    freq.put("es", 16599);
    freq.put("er", 32266);
    freq.put("skl", 527);
    freq.put("bli", 4296);
    freq.put("blj", 1003);
    freq.put("bla", 688);
    freq.put("ejs", 573);
    freq.put("rlo", 551);
    freq.put("G", 8706);
    freq.put("s\u030cc\u0301e", 547);
    freq.put("oru", 1306);
    freq.put("e ", 160018);
    freq.put("orn", 2821);
    freq.put("oro", 4229);
    freq.put("ci ", 6216);
    freq.put("uc\u030ca", 545);
    freq.put("ori", 7402);
    freq.put("org", 1291);
    freq.put("ord", 815);
    freq.put("ore", 2892);
    freq.put("uc\u030ci", 687);
    freq.put("ora", 3600);
    freq.put("z\u030c", 23555);
    freq.put("vje", 3831);
    freq.put("onj", 777);
    freq.put("zal", 859);
    freq.put("oni", 2936);
    freq.put("zaj", 1076);
    freq.put("ono", 2047);
    freq.put("ona", 3954);
    freq.put("ong", 1053);
    freq.put("ond", 619);
    freq.put("one", 1941);
    freq.put("lat", 2578);
    freq.put("ISO", 2034);
    freq.put("zav", 531);
    freq.put("ons", 1609);
    freq.put("zas", 565);
    freq.put("ont", 1171);
    freq.put("Eur", 771);
    freq.put("ian", 1493);
    freq.put("uko", 757);
    freq.put("c\u030ca ", 974);
    freq.put("ukl", 657);
    freq.put("uka", 702);
    freq.put(" Ze", 593);
    freq.put("x ", 785);
    freq.put(" Za", 2362);
    freq.put("za ", 7407);
    freq.put("c\u030car", 558);
    freq.put("c\u030cav", 1111);
    freq.put("ia ", 1869);
    freq.put("rzi", 592);
    freq.put("r", 271701);
    freq.put("lni", 2255);
    freq.put("c\u030caj", 693);
    freq.put("c\u030can", 800);
    freq.put("and", 3683);
    freq.put("ane", 2342);
    freq.put("ang", 1485);
    freq.put("pra", 3170);
    freq.put("ana", 11419);
    freq.put("c\u0301", 16773);
    freq.put("anc", 2218);
    freq.put("pro", 8677);
    freq.put("ano", 4034);
    freq.put("es\u030c", 3371);
    freq.put("ani", 9755);
    freq.put("anj", 10858);
    freq.put("ank", 1213);
    freq.put("ant", 2834);
    freq.put("anu", 1384);
    freq.put("ez\u030c", 1706);
    freq.put("ans", 7065);
    freq.put("sas", 3039);
    freq.put("sav", 1014);
    freq.put("sat", 604);
    freq.put("Do", 1328);
    freq.put("Di", 1002);
    freq.put("lna", 885);
    freq.put("De", 1138);
    freq.put("zon", 794);
    freq.put("Da", 1321);
    freq.put("\u0435", 917);
    freq.put("Du", 764);
    freq.put("Dr", 1133);
    freq.put("c\u0301a ", 3122);
    freq.put("an ", 10347);
    freq.put("sa ", 5478);
    freq.put("ec\u030c", 2671);
    freq.put(" Le", 867);
    freq.put(" La", 1670);
    freq.put(" Lo", 1032);
    freq.put("ec\u0301", 4631);
    freq.put("D ", 829);
    freq.put("c\u0301an", 554);
    freq.put(" Lu", 587);
    freq.put("e\u0111", 3970);
    freq.put("tka", 775);
    freq.put("tko", 583);
    freq.put("ge ", 1704);
    freq.put("Wa", 1107);
    freq.put("ce ", 5505);
    freq.put("lub", 608);
    freq.put("Wi", 722);
    freq.put("\u0430", 1816);
    freq.put(" pr", 23703);
    freq.put("ite", 2457);
    freq.put(" pu", 1716);
    freq.put("H", 9113);
    freq.put("oce", 973);
    freq.put(" pa", 2832);
    freq.put(" pe", 1664);
    freq.put(" pj", 1218);
    freq.put(" pi", 966);
    freq.put(" po", 28804);
    freq.put("gen", 1325);
    freq.put(" pl", 5604);
    freq.put("ute", 706);
    freq.put("oc\u030ce", 731);
    freq.put("o\u0301", 546);
    freq.put("poc\u030c", 712);
    freq.put("cij", 9280);
    freq.put("s\u030ca", 1860);
    freq.put("vrs", 1358);
    freq.put("uti", 590);
    freq.put("s\u030ce", 2480);
    freq.put("s\u030ci", 3525);
    freq.put("s\u030ck", 2964);
    freq.put("s\u030cl", 591);
    freq.put("s\u030cn", 3132);
    freq.put("s\u030cp", 635);
    freq.put("lno", 1832);
    freq.put("rma", 1223);
    freq.put("s\u030cu", 567);
    freq.put("s\u030ct", 7272);
    freq.put("lne", 712);
    freq.put("rmi", 655);
    freq.put("j ", 16449);
    freq.put("vu ", 2689);
    freq.put("cir", 569);
    freq.put("vrt", 868);
    freq.put("tur", 2517);
    freq.put("s\u030c ", 1063);
    freq.put("tup", 876);
    freq.put("ju", 19590);
    freq.put("jv", 1605);
    freq.put("js", 8691);
    freq.put("jn", 2724);
    freq.put("jo", 4699);
    freq.put("ji", 26676);
    freq.put("jk", 855);
    freq.put("je", 134763);
    freq.put("Kra", 872);
    freq.put("tud", 1103);
    freq.put("ja", 39549);
    freq.put(" be", 1110);
    freq.put(" ba", 2490);
    freq.put(" bl", 1053);
    freq.put(" bo", 2421);
    freq.put(" bi", 5965);
    freq.put(" bu", 691);
    freq.put("s", 238514);
    freq.put(" br", 3222);
    freq.put("poz", 2191);
    freq.put("hva", 1061);
    freq.put("pot", 1881);
    freq.put("por", 5631);
    freq.put("pos", 3892);
    freq.put("pop", 1191);
    freq.put("pon", 975);
    freq.put("pol", 3220);
    freq.put("pom", 933);
    freq.put("poj", 1457);
    freq.put("pok", 1642);
    freq.put("pog", 612);
    freq.put("pod", 6429);
    freq.put("vri", 916);
    freq.put(" s\u030ci", 1148);
    freq.put(" s\u030cp", 620);
    freq.put(" s\u030ct", 1607);
    freq.put("mog", 976);
    freq.put("po ", 2082);
    freq.put("Nje", 555);
    freq.put(" Op", 1008);
    freq.put("az\u030cn", 588);
    freq.put("ive", 1512);
    freq.put("iva", 3738);
    freq.put("pje", 1454);
    freq.put("ivn", 1941);
    freq.put("ivo", 1642);
    freq.put("ivi", 1447);
    freq.put(" Me", 1804);
    freq.put("par", 1595);
    freq.put("pat", 647);
    freq.put(" Ma", 5817);
    freq.put(" Mo", 1968);
    freq.put(" Mi", 1882);
    freq.put(" Mu", 787);
    freq.put("o\u0111e", 1121);
    freq.put("pad", 4813);
    freq.put("I ", 821);
    freq.put("pal", 580);
    freq.put("pan", 3273);
    freq.put("oim", 653);
    freq.put("iv ", 1925);
    freq.put("nac", 3781);
    freq.put("I", 13451);
    freq.put("IS", 2154);
    freq.put("ac\u0301a", 1021);
    freq.put("ec\u0301i", 1617);
    freq.put("gru", 1369);
    freq.put("oiz", 1012);
    freq.put("ec\u0301a", 1346);
    freq.put("ois", 1145);
    freq.put("ec\u0301e", 940);
    freq.put("nag", 771);
    freq.put("uhv", 776);
    freq.put("Iz", 610);
    freq.put("s\u030cc\u0301", 1355);
    freq.put("zbe", 843);
    freq.put("uju", 1023);
    freq.put("Is", 978);
    freq.put("pa ", 1847);
    freq.put("In", 4619);
    freq.put("oke", 734);
    freq.put("ort", 1833);
    freq.put("am ", 2209);
    freq.put("mij", 1629);
    freq.put("uz\u030cb", 678);
    freq.put("tir", 1327);
    freq.put("gdj", 702);
    freq.put("mo ", 1420);
    freq.put("los\u030c", 641);
    freq.put("juc\u0301", 551);
    freq.put("tim", 1630);
    freq.put("nap", 971);
    freq.put("juc\u030c", 696);
    freq.put("pov", 2463);
    freq.put(" ge", 1007);
    freq.put("uz\u030ci", 889);
    freq.put("ami", 1538);
    freq.put("a\u0301 ", 773);
    freq.put("amo", 1853);
    freq.put("ama", 5199);
    freq.put("mor", 2726);
    freq.put("amb", 801);
    freq.put("ame", 3781);
    freq.put("mot", 653);
    freq.put("mon", 1050);
    freq.put("juz\u030c", 1378);
    freq.put("zla", 762);
    freq.put("zli", 1013);
    freq.put("t", 201984);
    freq.put("as\u030c", 3959);
    freq.put("tvu", 537);
    freq.put("ezu", 527);
    freq.put("tvr", 1039);
    freq.put("uto", 1403);
    freq.put("ezn", 818);
    freq.put("ezi", 9990);
    freq.put("tve", 1133);
    freq.put("eze", 1246);
    freq.put("tva", 2106);
    freq.put("eza", 1009);
    freq.put("az\u030c", 1877);
    freq.put(" ci", 1052);
    freq.put(" ca", 552);
    freq.put(" z\u030cu", 1586);
    freq.put(" ce", 1531);
    freq.put(" z\u030ci", 2289);
    freq.put("uci", 556);
    freq.put(" cr", 1408);
    freq.put(" z\u030ce", 880);
    freq.put("mpi", 753);
    freq.put("ez ", 610);
    freq.put("Sje", 767);
    freq.put("oo", 1568);
    freq.put("on", 23346);
    freq.put("aca", 3812);
    freq.put("ol", 17826);
    freq.put("ok", 14795);
    freq.put("oj", 40426);
    freq.put("oi", 3961);
    freq.put("oh", 1159);
    freq.put("og", 22833);
    freq.put("of", 2150);
    freq.put("aci", 6004);
    freq.put("ach", 727);
    freq.put("ac\u030c", 10342);
    freq.put("ob", 12953);
    freq.put("oa", 2451);
    freq.put("a\u0111", 2045);
    freq.put("ngo", 698);
    freq.put("oz", 7848);
    freq.put("ow", 1054);
    freq.put("ov", 31034);
    freq.put("ou", 2922);
    freq.put("ot", 12114);
    freq.put("os", 23349);
    freq.put("or", 33494);
    freq.put("op", 11191);
    freq.put("Ni", 1096);
    freq.put("ju ", 11452);
    freq.put("bja", 1027);
    freq.put("No", 2003);
    freq.put("Na", 3401);
    freq.put("Ne", 1404);
    freq.put("c\u0301e ", 1908);
    freq.put("lob", 538);
    freq.put("a\u0111e", 658);
    freq.put("log", 2016);
    freq.put("her", 717);
    freq.put("lok", 712);
    freq.put("lon", 791);
    freq.put("lom", 1506);
    freq.put("lop", 558);
    freq.put("\u0432", 563);
    freq.put("lov", 4118);
    freq.put("a\u0111a", 855);
    freq.put("jug", 1520);
    freq.put("jud", 1914);
    freq.put("juj", 863);
    freq.put(" sv", 5803);
    freq.put("J", 5359);
    freq.put("na ", 42477);
    freq.put("rje", 601);
    freq.put("dvi", 741);
    freq.put(" ak", 848);
    freq.put("lo ", 4167);
    freq.put("svi", 1441);
    freq.put("as ", 2262);
    freq.put("he ", 1979);
    freq.put("aa", 799);
    freq.put("oc\u030c", 4671);
    freq.put("ab", 3879);
    freq.put("\u0111u", 2924);
    freq.put("ad", 21936);
    freq.put("ag", 6276);
    freq.put("af", 2077);
    freq.put("oc\u0301", 686);
    freq.put("ah", 2814);
    freq.put("ak", 15591);
    freq.put("aj", 16895);
    freq.put("am", 17849);
    freq.put("al", 35013);
    freq.put("ao", 6448);
    freq.put("an", 70440);
    freq.put("\u0111a", 1580);
    freq.put("ap", 10100);
    freq.put("as", 22343);
    freq.put("ar", 30709);
    freq.put("\u0111e", 2942);
    freq.put("at", 29447);
    freq.put("aw", 1498);
    freq.put("av", 28227);
    freq.put("ay", 1948);
    freq.put("az", 15697);
    freq.put("o\u0111", 1449);
    freq.put("igr", 1302);
    freq.put("c\u030cin", 2554);
    freq.put("As", 560);
    freq.put("ige", 790);
    freq.put("iga", 952);
    freq.put("ota", 912);
    freq.put("Au", 808);
    freq.put("igi", 547);
    freq.put("gom", 912);
    freq.put("gon", 803);
    freq.put("rr", 1162);
    freq.put("os\u030c", 2893);
    freq.put("oz\u030c", 2534);
    freq.put("u", 209613);
    freq.put("Bri", 609);
    freq.put("Bra", 541);
    freq.put("aln", 4903);
    freq.put("alo", 1706);
    freq.put("all", 806);
    freq.put("vis\u030c", 1245);
    freq.put("alj", 2503);
    freq.put("z\u030can", 794);
    freq.put("pti", 586);
    freq.put("ali", 7309);
    freq.put("os\u030ck", 698);
    freq.put("ale", 2883);
    freq.put("alb", 1948);
    freq.put("ala", 6700);
    freq.put("eda", 3130);
    freq.put("ajv", 1325);
    freq.put("mno", 900);
    freq.put("alt", 538);
    freq.put("alu", 766);
    freq.put("als", 661);
    freq.put("gr", 14473);
    freq.put("aji", 1629);
    freq.put("tv", 7233);
    freq.put("tt", 1393);
    freq.put("tu", 9961);
    freq.put("tr", 16932);
    freq.put("ts", 8790);
    freq.put("tp", 896);
    freq.put("zme", 1381);
    freq.put("tn", 5773);
    freq.put("to", 28843);
    freq.put("tl", 1860);
    freq.put("tm", 575);
    freq.put("tj", 1700);
    freq.put("tk", 2453);
    freq.put("th", 3097);
    freq.put("ti", 34096);
    freq.put("\u0438", 1209);
    freq.put("tu ", 3006);
    freq.put("te", 22658);
    freq.put("ic\u030ck", 8118);
    freq.put("ta", 38983);
    freq.put("edi", 4719);
    freq.put("rb", 2322);
    freq.put("edn", 7588);
    freq.put("al ", 2419);
    freq.put("edo", 1202);
    freq.put("rm", 2849);
    freq.put("ic\u030cn", 3327);
    freq.put(" Ni", 1084);
    freq.put("pre", 6249);
    freq.put(" Nj", 820);
    freq.put("vic\u0301", 621);
    freq.put(" No", 2002);
    freq.put("eds", 1513);
    freq.put(" Na", 3399);
    freq.put("as\u030cn", 1360);
    freq.put(" Ne", 1391);
    freq.put("ge", 5429);
    freq.put("ri", 44000);
    freq.put("as\u030ct", 576);
    freq.put("rj", 894);
    freq.put("gor", 1668);
    freq.put("t ", 14252);
    freq.put("tek", 931);
    freq.put("tel", 2393);
    freq.put("ga", 10157);
    freq.put("ten", 2148);
    freq.put("z\u030cu", 2110);
    freq.put("go", 15835);
    freq.put("z\u030cn", 3428);
    freq.put("z\u030ca", 6201);
    freq.put("z\u030cb", 852);
    freq.put("tet", 818);
    freq.put("z\u030ce", 4351);
    freq.put("aba", 762);
    freq.put("abi", 791);
    freq.put("\u0430 ", 562);
    freq.put("sus", 1535);
    freq.put("lle", 663);
    freq.put("smj", 1004);
    freq.put(" ru", 1327);
    freq.put("te ", 6089);
    freq.put("K", 11989);
    freq.put(" re", 4140);
    freq.put("is\u030cn", 1267);
    freq.put(" ra", 7698);
    freq.put("pub", 2165);
    freq.put(" ro", 2280);
    freq.put(" ri", 4141);
    freq.put("s\u030c", 26211);
    freq.put("su ", 8627);
    freq.put("oma", 2281);
    freq.put(" Ar", 1651);
    freq.put("uc\u0301a", 616);
    freq.put("vic", 888);
    freq.put("rkv", 521);
    freq.put("nto", 781);
    freq.put("vid", 903);
    freq.put("vij", 3997);
    freq.put("vez", 1580);
    freq.put("vih", 903);
    freq.put("vin", 3680);
    freq.put("vil", 1092);
    freq.put("vim", 1483);
    freq.put("vir", 547);
    freq.put("put", 1060);
    freq.put("vc", 593);
    freq.put("rka", 695);
    freq.put("vit", 817);
    freq.put("S ", 720);
    freq.put("asi", 1226);
    freq.put("avu", 1466);
    freq.put("de ", 2788);
    freq.put("vi ", 4716);
    freq.put("Sr", 1393);
    freq.put("Sp", 846);
    freq.put("Sv", 940);
    freq.put("Su", 1303);
    freq.put("St", 1916);
    freq.put("Sj", 776);
    freq.put("Si", 1385);
    freq.put("Sh", 659);
    freq.put("So", 1277);
    freq.put("Sl", 1203);
    freq.put("Sa", 3386);
    freq.put("Nov", 1094);
    freq.put("Se", 1283);
    freq.put("a\u0301", 1674);
    freq.put("S\u030c", 1432);
    freq.put(" dj", 1233);
    freq.put(" di", 5389);
    freq.put(" de", 2927);
    freq.put("klo", 701);
    freq.put("avn", 4358);
    freq.put(" da", 4574);
    freq.put("avo", 1516);
    freq.put("SO", 2074);
    freq.put("den", 1450);
    freq.put("v", 140168);
    freq.put("Ind", 3698);
    freq.put(" dv", 2035);
    freq.put(" du", 1555);
    freq.put(" dr", 6375);
    freq.put("avi", 4083);
    freq.put("rac\u030c", 1555);
    freq.put("go ", 855);
    freq.put("f ", 1430);
    freq.put("ati", 6984);
    freq.put("c\u030cni", 1699);
    freq.put("ish", 564);
    freq.put("c\u030cno", 3306);
    freq.put("r ", 11028);
    freq.put("eg ", 2170);
    freq.put("c\u030cne", 1006);
    freq.put("isn", 807);
    freq.put("fr", 2013);
    freq.put("fs", 661);
    freq.put("fu", 639);
    freq.put("ra\u0111", 876);
    freq.put("fa", 1476);
    freq.put("fe", 2011);
    freq.put("fi", 4106);
    freq.put("fo", 2404);
    freq.put("a", 586818);
    freq.put("ry ", 556);
    freq.put("c\u0301en", 895);
    freq.put("ne ", 19985);
    freq.put("egi", 1521);
    freq.put("ego", 1890);
    freq.put("zik", 7193);
    freq.put("ega", 1085);
    freq.put("ito", 2406);
    freq.put("ger", 827);
    freq.put("iti", 4001);
    freq.put("y ", 3377);
    freq.put("Hrv", 2864);
    freq.put("ita", 3250);
    freq.put("ok ", 1418);
    freq.put("uz\u030cn", 2163);
    freq.put("itu", 706);
    freq.put("its", 544);
    freq.put("c\u0301u", 1057);
    freq.put("jc\u030c", 526);
    freq.put(" Ob", 956);
    freq.put("c\u0301e", 3354);
    freq.put("jes\u030c", 1621);
    freq.put("c\u0301a", 4248);
    freq.put(" Ov", 665);
    freq.put(" Or", 732);
    freq.put(" Os", 789);
    freq.put("c\u0301i", 5749);
    freq.put("ceg", 685);
    freq.put("okr", 3164);
    freq.put("oku", 2145);
    freq.put("yo", 520);
    freq.put("dim", 541);
    freq.put("ya", 1738);
    freq.put("cen", 997);
    freq.put("ye", 523);
    freq.put("L", 6822);
    freq.put("it ", 890);
    freq.put("oka", 2684);
    freq.put("ces", 1492);
    freq.put("jec\u0301", 1172);
    freq.put("ko\u0111", 596);
    freq.put("oko", 3273);
    freq.put("jec\u030c", 1963);
    freq.put("tro", 2790);
    freq.put("c\u0301 ", 1732);
    freq.put("ifi", 824);
    freq.put(" sr", 2957);
    freq.put(" sp", 2436);
    freq.put("c\u030c", 46294);
    freq.put(" st", 9162);
    freq.put(" su", 10580);
    freq.put(" sj", 3429);
    freq.put(" sk", 4532);
    freq.put(" si", 2544);
    freq.put(" sn", 698);
    freq.put(" so", 944);
    freq.put(" sl", 3915);
    freq.put(" sm", 1890);
    freq.put(" sa", 9931);
    freq.put("prv", 1850);
    freq.put(" se", 16886);
    freq.put("iza", 2198);
    freq.put("izd", 806);
    freq.put("lis\u030c", 638);
    freq.put("izi", 2042);
    freq.put("izl", 668);
    freq.put("izm", 2019);
    freq.put("izn", 759);
    freq.put("izo", 774);
    freq.put("izr", 793);
    freq.put("izu", 877);
    freq.put("izv", 2232);
    freq.put("Nj", 820);
    freq.put("ac\u0301e", 585);
    freq.put("pul", 698);
    freq.put("jer", 2418);
    freq.put("pun", 676);
    freq.put("asp", 540);
    freq.put(" Af", 533);
    freq.put("ast", 9058);
    freq.put("lic\u030c", 1936);
    freq.put(" Al", 1637);
    freq.put(" Am", 1333);
    freq.put(" An", 1450);
    freq.put("asa", 826);
    freq.put(" As", 558);
    freq.put(" At", 724);
    freq.put(" Au", 794);
    freq.put("ase", 3354);
    freq.put("ask", 1064);
    freq.put("kom", 6854);
    freq.put(" s ", 3500);
    freq.put("ash", 669);
    freq.put("asn", 1043);
    freq.put("asl", 534);
    freq.put("iz ", 4867);
    freq.put("jos\u030c", 665);
    freq.put("kon", 3505);
    freq.put("w", 7347);
    freq.put("Eu", 879);
    freq.put("oc\u030ci", 564);
    freq.put("oz\u030ce", 1175);
    freq.put("le ", 3757);
    freq.put("Fra", 831);
    freq.put("C\u030c", 895);
    freq.put("z\u030cup", 1446);
    freq.put(" el", 1166);
    freq.put("jes", 4061);
    freq.put(" en", 2154);
    freq.put("koj", 25320);
    freq.put("jev", 7451);
    freq.put("kol", 2347);
    freq.put("jet", 3631);
    freq.put(" ek", 584);
    freq.put("jez", 10141);
    freq.put("kod", 903);
    freq.put("kog", 6388);
    freq.put("jec", 1103);
    freq.put("jeg", 2764);
    freq.put("jed", 10627);
    freq.put(" et", 559);
    freq.put("jek", 4521);
    freq.put("kor", 2342);
    freq.put("jen", 9322);
    freq.put("kot", 547);
    freq.put("jel", 6299);
    freq.put("jem", 5086);
    freq.put("ods", 1138);
    freq.put("ncu", 940);
    freq.put("odu", 910);
    freq.put("nci", 2911);
    freq.put("Slo", 726);
    freq.put("kop", 1083);
    freq.put("nce", 931);
    freq.put("ste", 2346);
    freq.put("\u043a", 817);
    freq.put("sta", 16592);
    freq.put("ko ", 9564);
    freq.put("sto", 9996);
    freq.put("sti", 9753);
    freq.put("stu", 2357);
    freq.put("je ", 61320);
    freq.put("str", 6456);
    freq.put("kov", 2238);
    freq.put("s\u030cen", 553);
    freq.put("ka ", 22352);
    freq.put("sh ", 559);
    freq.put("oda", 2801);
    freq.put("Gor", 695);
    freq.put("k ", 14010);
    freq.put("lia", 609);
    freq.put("lic", 2147);
    freq.put("lim", 1508);
    freq.put("lin", 3083);
    freq.put("lij", 3213);
    freq.put("lik", 6521);
    freq.put("lit", 2066);
    freq.put("lis", 1339);
    freq.put("liz", 1420);
    freq.put("kac", 594);
    freq.put("vne", 801);
    freq.put("vna", 1303);
    freq.put("kad", 1513);
    freq.put("kak", 633);
    freq.put("M", 14153);
    freq.put("kan", 1885);
    freq.put("kam", 671);
    freq.put("kal", 1067);
    freq.put("jst", 574);
    freq.put("kar", 1304);
    freq.put("kat", 974);
    freq.put("kaz", 825);
    freq.put("The", 928);
    freq.put("kc", 1026);
    freq.put("ka", 37663);
    freq.put("li ", 12760);
    freq.put("ke", 16969);
    freq.put("ki", 28341);
    freq.put("ko", 63668);
    freq.put("kn", 1083);
    freq.put("km", 1244);
    freq.put("kl", 4333);
    freq.put("ks", 2734);
    freq.put("kr", 10108);
    freq.put("kv", 1615);
    freq.put("ku", 14523);
    freq.put("kt", 4893);
    freq.put("ugi", 1126);
    freq.put("oju", 1294);
    freq.put("rta", 726);
    freq.put("ojs", 576);
    freq.put("ugl", 583);
    freq.put("uga", 1630);
    freq.put("rti", 871);
    freq.put("uge", 731);
    freq.put("oje", 6734);
    freq.put("oja", 6046);
    freq.put("ojn", 1052);
    freq.put("ojo", 759);
    freq.put("ugu", 1137);
    freq.put("oji", 10382);
    freq.put("Ju", 1563);
    freq.put("Jo", 711);
    freq.put("duz\u030c", 619);
    freq.put("Je", 1026);
    freq.put("Ja", 1450);
    freq.put("hit", 527);
    freq.put("rt ", 714);
    freq.put("ug ", 588);
    freq.put("b", 60942);
    freq.put("pc\u0301", 2758);
    freq.put("oj ", 12832);
    freq.put("hin", 716);
    freq.put("ie ", 604);
    freq.put(" Be", 1676);
    freq.put("ars", 3100);
    freq.put(" Ba", 2689);
    freq.put("aru", 579);
    freq.put("c\u030cl", 554);
    freq.put(" Bo", 2110);
    freq.put("c\u030cn", 7182);
    freq.put(" Bi", 1296);
    freq.put("c\u030ck", 13325);
    freq.put("c\u030cj", 2822);
    freq.put(" Bu", 1004);
    freq.put("ara", 6301);
    freq.put("ik ", 6489);
    freq.put("ard", 1409);
    freq.put("are", 1147);
    freq.put(" Br", 2033);
    freq.put("arh", 564);
    freq.put("ari", 4189);
    freq.put("ark", 1048);
    freq.put("arn", 1712);
    freq.put("aro", 3575);
    freq.put("stv", 3654);
    freq.put("c\u030cko", 4001);
    freq.put("c\u030c ", 1473);
    freq.put("iku", 1705);
    freq.put("lem", 4158);
    freq.put("ar ", 2545);
    freq.put("ika", 7961);
    freq.put("c\u030cki", 5096);
    freq.put("ike", 2426);
    freq.put("se ", 14671);
    freq.put("iki", 780);
    freq.put("iko", 2904);
    freq.put("Ba", 2710);
    freq.put(" Pr", 3007);
    freq.put("c", 64868);
    freq.put(" Pu", 743);
    freq.put(" Pa", 2881);
    freq.put("ric\u030c", 3609);
    freq.put(" Pe", 1599);
    freq.put(" Pi", 864);
    freq.put(" Po", 3623);
    freq.put(" Pl", 812);
    freq.put("ga ", 4609);
    freq.put("pr", 27731);
    freq.put("ps", 2712);
    freq.put("pp", 658);
    freq.put("pt", 1447);
    freq.put("pu", 6628);
    freq.put("pa", 15403);
    freq.put("pe", 6182);
    freq.put("pj", 1476);
    freq.put("ph", 606);
    freq.put("pi", 11043);
    freq.put("pn", 1287);
    freq.put("po", 36246);
    freq.put("pl", 8816);
    freq.put(" tv", 902);
    freq.put(" tu", 1007);
    freq.put(" tr", 4273);
    freq.put("N", 10511);
    freq.put(" to", 2817);
    freq.put("gan", 1740);
    freq.put("Opc\u0301", 766);
    freq.put(" ti", 2177);
    freq.put(" th", 929);
    freq.put(" te", 5426);
    freq.put(" ta", 2808);
    freq.put("du ", 2280);
    freq.put("p ", 2149);
    freq.put("eke", 1782);
    freq.put("vod", 2717);
    freq.put("vog", 1164);
    freq.put("riz", 799);
    freq.put("psk", 1887);
    freq.put("riv", 1004);
    freq.put("vom", 1226);
    freq.put("rit", 2510);
    freq.put("rir", 879);
    freq.put("ris", 3174);
    freq.put("rip", 1837);
    freq.put("rin", 1848);
    freq.put("rio", 889);
    freq.put("ril", 1430);
    freq.put("rim", 1849);
    freq.put("rij", 11045);
    freq.put("rik", 1383);
    freq.put("vor", 5059);
    freq.put("rig", 523);
    freq.put("rid", 583);
    freq.put("rib", 805);
    freq.put("ric", 1431);
    freq.put("voz", 1030);
    freq.put("ria", 651);
    freq.put("mos", 601);
    freq.put("vo ", 3548);
    freq.put("tis", 916);
    freq.put("cea", 713);
    freq.put("lig", 541);
    freq.put("ri ", 5834);
    freq.put(" fr", 941);
    freq.put("knj", 735);
    freq.put(" fa", 621);
    freq.put(" fi", 1669);
    freq.put("ae", 1668);
    freq.put("do ", 2419);
    freq.put(" fo", 883);
    freq.put(" uz\u030c", 620);
    freq.put("c\u030cla", 542);
    freq.put("upr", 748);
    freq.put("bi ", 1256);
    freq.put("O ", 2633);
    freq.put("uc\u030c", 5083);
    freq.put("uc\u0301", 2114);
    freq.put("tin", 3058);
    freq.put("cus", 960);
    freq.put("lj ", 865);
    freq.put("\u043e", 1253);
    freq.put("rgi", 678);
    freq.put("bin", 696);
    freq.put("bio", 1738);
    freq.put("bil", 3046);
    freq.put("bij", 1580);
    freq.put("Ob", 956);
    freq.put("biv", 585);
    freq.put("Ov", 672);
    freq.put("bit", 2079);
    freq.put("Os", 790);
    freq.put("Or", 735);
    freq.put("Op", 1011);
    freq.put("lji", 2209);
    freq.put("uz\u030c", 5556);
    freq.put("d", 148916);
    freq.put("lja", 4832);
    freq.put("lje", 10652);
    freq.put("cu ", 955);
    freq.put("ljs", 545);
    freq.put("us\u030c", 2233);
    freq.put("ijs", 5406);
    freq.put("b ", 1522);
    freq.put("iju", 2114);
    freq.put("ru ", 2471);
    freq.put("ija", 16185);
    freq.put("ovr", 829);
    freq.put("ije", 24598);
    freq.put("iji", 7426);
    freq.put("Vel", 771);
    freq.put("ijo", 787);
    freq.put("nas\u030c", 1014);
    freq.put("pet", 668);
    freq.put("per", 1812);
    freq.put("vno", 3450);
    freq.put("be", 6031);
    freq.put("run", 520);
    freq.put("ba", 10149);
    freq.put("bl", 6540);
    freq.put("kao", 3422);
    freq.put("bn", 1412);
    freq.put("Bos", 708);
    freq.put("bi", 13442);
    freq.put("bj", 1695);
    freq.put("nac\u030c", 2757);
    freq.put("bu", 5481);
    freq.put("vni", 4024);
    freq.put("br", 6048);
    freq.put("rus", 1028);
    freq.put("rup", 1471);
    freq.put("jsk", 7836);
    freq.put("kas", 686);
    freq.put("idi", 521);
    freq.put("ide", 1150);
    freq.put("pe ", 1308);
    freq.put("ida", 944);
    freq.put("nsk", 10758);
    freq.put(" uz", 1739);
    freq.put(" ut", 721);
    freq.put(" up", 1243);
    freq.put(" ur", 562);
    freq.put(" us", 1218);
    freq.put(" ul", 803);
    freq.put(" um", 849);
    freq.put(" un", 999);
    freq.put(" uk", 1055);
    freq.put(" ud", 648);
    freq.put(" ug", 653);
    freq.put("nst", 1771);
    freq.put("ut ", 910);
    freq.put("bic\u030c", 654);
    freq.put("u ", 87089);
    freq.put("zic", 1241);
    freq.put(" Ch", 1828);
    freq.put(" Co", 1819);
    freq.put("ns ", 584);
    freq.put(" Ca", 2140);
    freq.put(" Ce", 585);
    freq.put(" Cr", 1326);
    freq.put(" u ", 32404);
    freq.put("uta", 1448);
    freq.put("uz", 3112);
    freq.put("ut", 7404);
    freq.put("uv", 1349);
    freq.put("cio", 1059);
    freq.put("up", 11863);
    freq.put("us", 10059);
    freq.put("ur", 9708);
    freq.put("um", 7672);
    freq.put("ul", 5933);
    freq.put("uo", 923);
    freq.put("un", 8708);
    freq.put("ui", 1893);
    freq.put("uh", 1544);
    freq.put("uk", 4559);
    freq.put("uj", 4079);
    freq.put("ue", 1973);
    freq.put("ud", 5733);
    freq.put("ug", 8425);
    freq.put("z", 85944);
    freq.put("ua", 3882);
    freq.put("uc", 1692);
    freq.put("ub", 5211);
    freq.put("Tu", 1072);
    freq.put("Tr", 1314);
    freq.put("To", 1609);
    freq.put("vot", 928);
    freq.put("Th", 1212);
    freq.put("Ti", 993);
    freq.put("Te", 1282);
    freq.put("Ta", 1685);
    freq.put("A ", 857);
    freq.put("Mar", 1189);
    freq.put(" gr", 8161);
    freq.put("cim", 1128);
    freq.put("nad", 1618);
    freq.put("ruc\u030c", 2722);
    freq.put("naj", 3818);
    freq.put("nak", 2307);
    freq.put("nan", 1732);
    freq.put("nal", 5099);
    freq.put("nam", 1658);
    freq.put("nar", 3446);
    freq.put("nas", 6912);
    freq.put(" gd", 551);
    freq.put("gre", 1427);
    freq.put("nav", 631);
    freq.put("Mad", 576);
    freq.put("nat", 3622);
    freq.put("gra", 9421);
    freq.put("naz", 2805);
    freq.put(" go", 6544);
    freq.put(" gl", 3276);
    freq.put("Mal", 573);
    freq.put("z\u030ce ", 1842);
    freq.put("Man", 821);
    freq.put("ic\u030ca", 967);
    freq.put("rus\u030c", 721);
    freq.put("ac ", 1484);
    freq.put("ruz\u030c", 889);
    freq.put("ago", 1080);
    freq.put("svo", 1576);
    freq.put("dvo", 690);
    freq.put("e", 436858);
    freq.put("Af", 545);
    freq.put("age", 778);
    freq.put("sve", 1415);
    freq.put("Am", 1341);
    freq.put("Al", 1655);
    freq.put("aga", 937);
    freq.put("An", 1467);
    freq.put("z\u030cen", 1273);
    freq.put("s\u030cki", 826);
    freq.put("Ar", 1684);
    freq.put("s\u030cko", 1181);
    freq.put("At", 729);
    freq.put("agu", 525);
    freq.put("agr", 1324);
    freq.put(" b", 17477);
    freq.put(" c", 5752);
    freq.put("gu", 4729);
    freq.put(" a", 19142);
    freq.put(" f", 5286);
    freq.put(" g", 21986);
    freq.put(" d", 31478);
    freq.put(" e", 6507);
    freq.put(" j", 56434);
    freq.put(" k", 46966);
    freq.put(" h", 4791);
    freq.put(" i", 61249);
    freq.put(" n", 49295);
    freq.put(" o", 45630);
    freq.put(" l", 9617);
    freq.put(" m", 20259);
    freq.put(" r", 20001);
    freq.put(" s", 79773);
    freq.put(" p", 67380);
    freq.put("gd", 857);
    freq.put(" v", 15539);
    freq.put(" w", 820);
    freq.put(" t", 21468);
    freq.put(" u", 45274);
    freq.put(" z", 19710);
    freq.put("gn", 997);
    freq.put("gl", 6895);
    freq.put("gi", 6788);
    freq.put("gh", 714);
    freq.put(" B", 11861);
    freq.put(" C", 9435);
    freq.put("uc\u0301i", 766);
    freq.put(" A", 13018);
    freq.put(" F", 4631);
    freq.put(" G", 8304);
    freq.put(" D", 7573);
    freq.put(" E", 4598);
    freq.put(" J", 5152);
    freq.put(" K", 11465);
    freq.put(" H", 8434);
    freq.put(" I", 11848);
    freq.put(" N", 9837);
    freq.put(" O", 7822);
    freq.put(" L", 5986);
    freq.put(" M", 13514);
    freq.put(" R", 8667);
    freq.put(" S", 19621);
    freq.put(" P", 14387);
    freq.put(" Q", 537);
    freq.put(" V", 5326);
    freq.put(" W", 3048);
    freq.put(" T", 9972);
    freq.put(" U", 4477);
    freq.put(" Z", 4104);
    freq.put("rc\u030ck", 1144);
    freq.put(" X", 526);
    freq.put(" Y", 1407);
    freq.put("ch ", 519);
    freq.put("ed ", 1254);
    freq.put("vlj", 3383);
    freq.put("vla", 1440);
    freq.put("kci", 941);
    freq.put("P", 15109);
    freq.put("g ", 19299);
    freq.put("zic\u030c", 837);
    freq.put("tri", 3139);
    freq.put("evi", 1701);
    freq.put("evn", 623);
    freq.put("evo", 961);
    freq.put("tra", 6680);
    freq.put("eva", 1803);
    freq.put("us ", 1654);
    freq.put("tre", 2014);
    freq.put("eve", 4353);
    freq.put("iba", 598);
    freq.put("tru", 1417);
    freq.put("zl", 2200);
    freq.put("zm", 2468);
    freq.put("zn", 8371);
    freq.put("zo", 3146);
    freq.put("zi", 22879);
    freq.put("oz ", 529);
    freq.put("zd", 2018);
    freq.put("ze", 4698);
    freq.put("odr", 4259);
    freq.put("zg", 1072);
    freq.put("za", 19270);
    freq.put("zb", 2089);
    freq.put("ay ", 531);
    freq.put("\u0111", 8171);
    freq.put("odi", 8132);
    freq.put("odn", 4204);
    freq.put("odo", 921);
    freq.put("zu", 2322);
    freq.put("zv", 4353);
    freq.put("ode", 1274);
    freq.put("zr", 2246);
    freq.put("rd ", 686);
    freq.put("ic\u030ci", 1329);
    freq.put("oci", 1114);
    freq.put("c\u030cke", 2028);
    freq.put("led", 614);
    freq.put("c\u030cka", 1912);
    freq.put("oza", 1421);
    freq.put("ozn", 3312);
    freq.put("lek", 2007);
    freq.put("z ", 7997);
    freq.put("ock", 1115);
    freq.put("len", 1436);
    freq.put("ozi", 1205);
    freq.put("les", 1936);
    freq.put("let", 657);
    freq.put("od ", 14807);
    freq.put("rdi", 692);
    freq.put(" Do", 1300);
    freq.put(" S\u030c", 1403);
    freq.put(" s\u030c", 4901);
    freq.put("gov", 5098);
    freq.put(" Di", 998);
    freq.put("apr", 526);
    freq.put("aps", 650);
    freq.put(" De", 1131);
    freq.put(" Da", 1296);
    freq.put("apu", 900);
    freq.put("api", 1243);
    freq.put("apo", 975);
    freq.put(" Du", 759);
    freq.put("apa", 4410);
    freq.put(" z\u030c", 5028);
    freq.put(" Dr", 1125);
    freq.put(" Z\u030c", 838);
    freq.put("ziv", 3073);
    freq.put("cha", 750);
    freq.put("Fr", 1113);
    freq.put("zir", 891);
    freq.put("che", 856);
    freq.put("chi", 796);
    freq.put("usk", 1818);
    freq.put("usi", 743);
    freq.put("Fa", 563);
    freq.put("ust", 3150);
    freq.put("fer", 566);
    freq.put("Fe", 631);
    freq.put("zin", 1079);
    freq.put("Fi", 649);
    freq.put("zil", 1675);
    freq.put("zij", 2320);
    freq.put("spr", 578);
    freq.put("Fo", 779);
    freq.put("ue ", 562);
    freq.put("om", 28810);
    freq.put("z\u030cav", 3922);
    freq.put(" Ru", 1022);
    freq.put("ac\u0301", 1902);
    freq.put("f", 16193);
    freq.put("km ", 900);
    freq.put(" C\u030c", 887);
    freq.put(" c\u030c", 5596);
    freq.put(" Re", 2970);
    freq.put("nda", 1627);
    freq.put(" Ra", 1412);
    freq.put("zi ", 3239);
    freq.put(" Ro", 1089);
    freq.put(" Ri", 1491);
    freq.put("oe", 678);
    freq.put("tat", 1128);
    freq.put("tav", 5990);
    freq.put("od", 40790);
    freq.put("tar", 4163);
    freq.put("\u0440", 912);
    freq.put("oc", 4342);
    freq.put("oc\u030cn", 2463);
    freq.put("eno", 6088);
    freq.put("tac", 782);
    freq.put("tal", 4191);
    freq.put("tam", 583);
    freq.put("tan", 6149);
    freq.put("taj", 996);
    freq.put("tak", 2161);
    freq.put(" va", 1250);
    freq.put(" ve", 3149);
    freq.put("afi", 554);
    freq.put(" vi", 2766);
    freq.put(" vj", 724);
    freq.put(" vl", 1147);
    freq.put(" vo", 2912);
    freq.put("spe", 611);
    freq.put(" vr", 3315);
    freq.put("sij", 991);
    freq.put("sin", 1783);
    freq.put("sim", 836);
    freq.put("afs", 539);
    freq.put("sis", 550);
    freq.put("Q", 585);
    freq.put(" Fa", 554);
    freq.put("ta ", 9339);
    freq.put("mje", 5038);
    freq.put("s\u030cte", 2571);
    freq.put("s\u030cta", 884);
    freq.put("s\u030cto", 1559);
    freq.put("s\u030cti", 879);
    freq.put("s\u030ctv", 1041);
    freq.put("si ", 1399);
    freq.put("da ", 9164);
    freq.put("bje", 654);
    freq.put("X", 701);
    freq.put("jni", 1204);
    freq.put("lg", 643);
    freq.put("ld", 889);
    freq.put("le", 17764);
    freq.put("lb", 2414);
    freq.put("tsk", 7605);
    freq.put("la", 37196);
    freq.put("ln", 5989);
    freq.put("lo", 18651);
    freq.put("ll", 3111);
    freq.put("lm", 1222);
    freq.put("lj", 24378);
    freq.put("lk", 741);
    freq.put("li", 41243);
    freq.put("lt", 2358);
    freq.put("lu", 8623);
    freq.put("ls", 2651);
    freq.put("eme", 6131);
    freq.put("dal", 1347);
    freq.put("Car", 617);
    freq.put("dan", 5150);
    freq.put("daj", 785);
    freq.put("dat", 824);
    freq.put("dav", 567);
    freq.put("dar", 1385);
    freq.put("ema", 3624);
    freq.put("ogl", 635);
    freq.put("Pre", 828);
    freq.put("kuc\u0301", 703);
    freq.put("San", 791);
    freq.put("l ", 6966);
    freq.put(" hr", 1744);
    freq.put("Pro", 696);
    freq.put("Pri", 721);
    freq.put(" hi", 648);
    freq.put(" ho", 696);
    freq.put("ac\u030c ", 583);
    freq.put(" ha", 604);
    freq.put("sil", 686);
    freq.put(" he", 608);
    freq.put("c\u030cju", 1626);
    freq.put("mar", 837);
    freq.put("h ", 20168);
    freq.put("rez", 931);
    freq.put("res", 1271);
    freq.put("rep", 724);
    freq.put("rev", 690);
    freq.put("ret", 1800);
    freq.put("rek", 1056);
    freq.put("ren", 2797);
    freq.put("rel", 612);
    freq.put("rem", 2802);
    freq.put("reb", 1913);
    freq.put("rea", 805);
    freq.put("reg", 1745);
    freq.put("red", 6133);
    freq.put("ree", 521);
    freq.put("eca", 935);
    freq.put("eci", 935);
    freq.put("x", 2022);
    freq.put("qui", 570);
    freq.put("zap", 3007);
    freq.put("g", 88687);
    freq.put("re ", 4525);
    freq.put("Z\u030c", 887);
    freq.put("c\u030ce", 5735);
    freq.put("set", 665);
    freq.put("iho", 1185);
    freq.put("c\u030ca", 5202);
    freq.put("og ", 13004);
    freq.put("ser", 1178);
    freq.put(" Sr", 1393);
    freq.put("be ", 1311);
    freq.put("iz\u030c", 1025);
    freq.put(" Sv", 937);
    freq.put(" St", 1875);
    freq.put(" Su", 1301);
    freq.put(" Sj", 776);
    freq.put(" Sh", 655);
    freq.put(" Si", 1373);
    freq.put(" So", 1270);
    freq.put(" Sl", 1201);
    freq.put(" Sa", 3371);
    freq.put(" Se", 1273);
    freq.put("Ka", 3681);
    freq.put("rsk", 5201);
    freq.put("ogu", 995);
    freq.put("c\u030ci", 7487);
    freq.put("Ki", 952);
    freq.put("Ko", 2488);
    freq.put("ogr", 2375);
    freq.put("Kr", 1748);
    freq.put("ogo", 1802);
    freq.put("R", 9319);
    freq.put("ogi", 1476);
    freq.put("Ku", 844);
    freq.put("rst", 2436);
    freq.put("ih ", 17225);
    freq.put("udi", 2722);
    freq.put("oga", 1651);
    freq.put("c\u030cu", 1818);
    freq.put("ben", 1811);
    freq.put("ber", 918);
    freq.put("seb", 745);
    freq.put("Par", 726);
    freq.put("moz\u030c", 877);
    freq.put("sk", 52271);
    freq.put("sel", 4338);
    freq.put("ck ", 1290);
    freq.put("min", 2090);
    freq.put("mis", 832);
    freq.put("mir", 1036);
    freq.put("mit", 939);
    freq.put("re\u0111", 981);
    freq.put("st ", 3926);
    freq.put(" Eu", 878);
    freq.put("rec\u0301", 667);
    freq.put("awa", 719);
    freq.put("ure", 1189);
    freq.put("ura", 1400);
    freq.put("mi ", 1004);
    freq.put("urn", 947);
    freq.put("uro", 1486);
    freq.put("uri", 1158);
    freq.put("uru", 580);
    freq.put("urs", 550);
    freq.put(" zv", 702);
    freq.put("Cha", 594);
    freq.put("z\u030civ", 2628);
    freq.put(" iz", 11704);
    freq.put("nga", 751);
    freq.put("co ", 549);
    freq.put("jav", 2585);
    freq.put("jat", 632);
    freq.put(" is", 4046);
    freq.put(" ih", 786);
    freq.put("\u0111u ", 1688);
    freq.put("jal", 1858);
    freq.put("jam", 1147);
    freq.put(" il", 7148);
    freq.put(" im", 3911);
    freq.put(" in", 3359);
    freq.put("Juz\u030c", 532);
    freq.put(" ig", 1120);
    freq.put("Rus", 582);
    freq.put("z\u030ci ", 866);
    freq.put("qu", 1390);
    freq.put("h", 49394);
    freq.put("s\u030cir", 1400);
    freq.put("s\u030cin", 692);
    freq.put(" i ", 27993);
    freq.put("shi", 607);
    freq.put(" zr", 767);
    freq.put("ja ", 23119);
    freq.put("\u0111un", 708);
    freq.put("Pr", 3018);
    freq.put("ebe", 581);
    freq.put("eba", 923);
    freq.put("Pu", 746);
    freq.put("C", 10193);
    freq.put("ke ", 14258);
    freq.put("Pa", 2898);
    freq.put("Pe", 1604);
    freq.put("ede", 1425);
    freq.put("Pi", 867);
    freq.put("Po", 3639);
    freq.put("Pl", 816);
    freq.put("ome", 2911);
    freq.put("et ", 2066);
    freq.put("\u043b", 648);
    freq.put("lum", 944);
    freq.put("Srb", 562);
    freq.put("nis\u030c", 631);
    freq.put("Sre", 533);
    freq.put("ked", 578);
    freq.put("S", 23054);
    freq.put("vre", 806);
    freq.put("joj", 1250);
    freq.put("jom", 1082);
    freq.put("etr", 912);
    freq.put("ets", 1480);
    freq.put("etv", 760);
    freq.put("etu", 996);
    freq.put("Zag", 834);
    freq.put("lu ", 2550);
    freq.put("tla", 700);
    freq.put("eta", 3704);
    freq.put("ete", 898);
    freq.put("etk", 539);
    freq.put("eti", 2144);
    freq.put("etn", 2390);
    freq.put("eto", 1100);
    freq.put("etl", 530);
    freq.put("ck", 2130);
    freq.put("ci", 21232);
    freq.put("ch", 4164);
    freq.put("co", 2679);
    freq.put("uz\u030ce", 864);
    freq.put("Her", 776);
    freq.put("ot ", 522);
    freq.put("c\u030ci ", 1484);
    freq.put("ca", 14154);
    freq.put("ac", 13980);
    freq.put("ce", 10558);
    freq.put("jih", 2364);
    freq.put("cr", 1908);
    freq.put("cu", 2623);
    freq.put("ct", 683);
    freq.put("rve", 1037);
    freq.put("ai", 3078);
    freq.put("dje", 2862);
    freq.put("rvi", 1279);
    freq.put("oti", 1557);
    freq.put("c\u030cij", 837);
    freq.put("oto", 4095);
    freq.put("rvo", 605);
    freq.put("c\u030cic", 566);
    freq.put("c ", 2983);
    freq.put("ote", 985);
    freq.put("jac\u030c", 750);
    freq.put("otp", 614);
    freq.put("otr", 921);
    freq.put("c\u030cit", 844);
    freq.put("unu", 749);
    freq.put("lli", 529);
    freq.put("e\u0301", 1412);
    freq.put("rbi", 882);
    freq.put("au", 3869);
    freq.put("ya ", 644);
    freq.put("va", 35406);
    freq.put(" Fr", 1109);
    freq.put("ve", 22017);
    freq.put("vi", 24026);
    freq.put("vj", 3877);
    freq.put("vk", 562);
    freq.put("vl", 4881);
    freq.put("vn", 9959);
    freq.put("vo", 21455);
    freq.put("avl", 3013);
    freq.put("vr", 6622);
    freq.put("vs", 1342);
    freq.put(" Fe", 623);
    freq.put("vu", 3419);
    freq.put("c\u0301i ", 2008);
    freq.put(" Fi", 643);
    freq.put("ave", 3087);
    freq.put("ava", 8033);
    freq.put(" Fo", 742);
    freq.put("io ", 4778);
    freq.put("of ", 888);
    freq.put("pis", 2255);
    freq.put("luz\u030c", 1294);
    freq.put("dam", 626);
    freq.put("und", 654);
    freq.put("mu ", 1457);
    freq.put("v ", 4865);
    freq.put("SO ", 2049);
    freq.put("ion", 3221);
    freq.put("vrs\u030c", 1066);
    freq.put("c\u0301in", 2919);
    freq.put("av ", 1100);
    freq.put("i", 501698);
    freq.put(" Tu", 1066);
    freq.put(" Tr", 1295);
    freq.put("ksi", 936);
    freq.put(" To", 1604);
    freq.put(" Ti", 990);
    freq.put(" Th", 1189);
    freq.put(" Te", 1277);
    freq.put(" Ta", 1677);
    freq.put("onu", 585);
    freq.put("sku", 5305);
    freq.put("Be", 1685);
    freq.put("adu", 1422);
    freq.put("adr", 1028);
    freq.put("ads", 935);
    freq.put("skr", 553);
    freq.put("Bo", 2115);
    freq.put("Bi", 1321);
    freq.put("ske", 5955);
    freq.put("Bu", 1011);
    freq.put("ade", 1153);
    freq.put("ska", 7019);
    freq.put("Br", 2042);
    freq.put("ada", 5689);
    freq.put("adn", 3155);
    freq.put("ado", 1169);
    freq.put("sko", 15307);
    freq.put("ski", 17159);
    freq.put("adi", 2550);
    freq.put("c\u0301u ", 879);
    freq.put("vac\u030c", 1765);
    freq.put("vac\u0301", 849);
    freq.put("T", 10711);
    freq.put("ad ", 3345);
    freq.put("svj", 804);
    freq.put("nja", 6205);
    freq.put("nje", 12914);
    freq.put("a ", 202747);
    freq.put("nji", 3978);
    freq.put("njo", 1594);
    freq.put("us\u030ct", 795);
    freq.put("njs", 879);
    freq.put("nju", 1904);
    freq.put("vsk", 989);
    freq.put("U ", 1401);
    freq.put("est", 6673);
    freq.put("nd ", 1313);
    freq.put("ese", 1073);
    freq.put("iso", 539);
    freq.put("esa", 706);
    freq.put("esn", 1243);
    freq.put("esm", 595);
    freq.put("esk", 1461);
    freq.put("esi", 709);
    freq.put("z\u030cno", 1666);
    freq.put("z\u030cni", 894);
    freq.put("ndi", 5037);
    freq.put("ndo", 1052);
    freq.put(" ju", 3163);
    freq.put("nde", 837);
    freq.put("kru", 1711);
    freq.put(" jo", 810);
    freq.put("kri", 1186);
    freq.put("kro", 1000);
    freq.put("es ", 2168);
    freq.put(" je", 51007);
    freq.put("kra", 4133);
    freq.put(" ja", 1334);
    freq.put("kre", 1063);
    freq.put("ea ", 773);
    freq.put("e\u0111u", 2748);
    freq.put("bu ", 732);
    freq.put("e\u0111e", 812);
    freq.put("vaj", 1521);
    freq.put("vak", 779);
    freq.put("van", 5697);
    freq.put("val", 1770);
    freq.put("vac", 751);
    freq.put("Ame", 663);
    freq.put("var", 1878);
    freq.put("rce", 928);
    freq.put("vat", 5563);
    freq.put("ean", 810);
    freq.put("hr", 2448);
    freq.put("hv", 1089);
    freq.put("ht", 807);
    freq.put("hu", 1937);
    freq.put("buh", 796);
    freq.put("hi", 4652);
    freq.put("hn", 862);
    freq.put("ho", 4536);
    freq.put("bum", 1939);
    freq.put("ha", 5859);
    freq.put("he", 4881);
    freq.put("va ", 12711);
    freq.put("j", 258985);
    freq.put("dva", 1103);
    freq.put("pij", 889);
    freq.put("pin", 4572);
    freq.put("int", 1177);
    freq.put("inu", 1508);
    freq.put("ins", 3389);
    freq.put("ino", 2039);
    freq.put("ini", 6764);
    freq.put("inj", 1865);
    freq.put("ind", 1666);
    freq.put("ine", 10127);
    freq.put("ing", 2574);
    freq.put("ina", 9909);
    freq.put("inc", 1602);
    freq.put("zvi", 939);
    freq.put("zvo", 1982);
    freq.put("oan", 559);
    freq.put("zva", 612);
    freq.put("or ", 2008);
    freq.put("\u043d", 943);
    freq.put("sva", 788);
    freq.put("pi ", 571);
    freq.put("gar", 946);
    freq.put("U", 4743);
    freq.put("ubl", 2337);
    freq.put("in ", 2960);
    freq.put(" Iz", 607);
    freq.put("gal", 662);
    freq.put(" U ", 1282);
    freq.put("o ", 61519);
  }
  
}

