package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HI extends CLangProfile {
  private static final String name = "hi";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HI() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 3436892;
    n_words[1] = 4107546;
    n_words[2] = 2722787;

    freq.put("\u0902\u0964 ", 4299);
    freq.put("\u0906", 15110);
    freq.put("\u0927\u093f\u0915", 1763);
    freq.put("\u0947\u092f\u0930", 374);
    freq.put("\u0917\u0924\u093f", 373);
    freq.put("\u0930\u0924\u093f", 1618);
    freq.put("\u0930\u0924\u093e", 1516);
    freq.put("\u0923\u094b\u0902", 461);
    freq.put("\u091d\u093e", 416);
    freq.put("\u093e\u092b\u0940", 651);
    freq.put("\u0927\u093f\u092f", 418);
    freq.put("\u0927\u093f\u0924", 713);
    freq.put("\u0930\u0932 ", 672);
    freq.put("\u090f ", 4565);
    freq.put("\u0930\u0924\u094d", 447);
    freq.put("\u0930\u0924\u0947", 811);
    freq.put("\u0947\u091c\u093c", 466);
    freq.put("\u0930\u0924\u0940", 4166);
    freq.put("\u094d\u091f\u094d", 2750);
    freq.put("\u0932\u0935\u0947", 3731);
    freq.put(" \u091b\u0942", 1830);
    freq.put("\u0936\u093e ", 783);
    freq.put(" \u091b\u094b", 700);
    freq.put("\u0916\u0940", 461);
    freq.put("\u0938\u093f\u0902", 774);
    freq.put("\u0905\u0927\u093f", 1401);
    freq.put("\u0916\u0947", 1130);
    freq.put("\u0916\u094b", 528);
    freq.put("\u0916\u094d", 2681);
    freq.put("\u0932\u0917\u092d", 597);
    freq.put("\u0940\u0924\u093f", 750);
    freq.put("\u0938\u093f\u0915", 706);
    freq.put("\u093c ", 2122);
    freq.put("\u0938\u0940 ", 3799);
    freq.put("\u0938\u093f\u0926", 1352);
    freq.put("\u0938\u093f\u0924", 526);
    freq.put("\u0939\u0947 ", 650);
    freq.put("\u0930\u094b\u0902", 2025);
    freq.put("\u0930\u093e\u092a", 737);
    freq.put("\u0938\u093f\u0930", 645);
    freq.put("\u093c\u0947 ", 628);
    freq.put("\u093e\u092e ", 3709);
    freq.put("\u092d\u093e\u0937", 2240);
    freq.put("\u0916\u0902", 419);
    freq.put("\u0916\u0915", 372);
    freq.put("\u091a\u0932 ", 435);
    freq.put("\u092a ", 5685);
    freq.put("\u0915\u0940 ", 19870);
    freq.put("\u096f\u096f", 438);
    freq.put("\u096f\u096e", 427);
    freq.put("\u096f\u096d", 465);
    freq.put("\u096f\u096c", 475);
    freq.put("\u096f\u096b", 380);
    freq.put("\u0916\u0928", 943);
    freq.put("\u0941\u0915\u094d", 1845);
    freq.put("\u093e\u0939\u093f", 1577);
    freq.put("\u0905\u0927\u094d", 641);
    freq.put("\u093e\u0939\u0930", 429);
    freq.put("\u0915\u092e\u094d", 429);
    freq.put("\u0916\u093e", 2157);
    freq.put("\u0916\u093f", 516);
    freq.put("\u093e\u0938", 7258);
    freq.put("\u091a\u0940\u0928", 1126);
    freq.put("\u0915\u094b\u091a", 453);
    freq.put("\u093e\u0930", 38751);
    freq.put("\u093e\u0932", 13682);
    freq.put("\u094b\u0924\u0947", 895);
    freq.put("\u094b\u0924\u0940", 1270);
    freq.put("\u093e\u0935", 4478);
    freq.put("\u093e\u0936", 1899);
    freq.put("\u093e\u0937", 4485);
    freq.put("\u093e\u0928", 23672);
    freq.put("\u091c\u0947", 4339);
    freq.put("\u093e\u092a", 4193);
    freq.put("\u093e\u092b", 948);
    freq.put("\u091c\u0942", 402);
    freq.put("\u093e\u092d", 451);
    freq.put("\u091c\u0940", 3381);
    freq.put("\u0915\u094b\u0908", 460);
    freq.put("\u093e\u0920", 433);
    freq.put("\u093e\u0921", 1607);
    freq.put("\u091c\u094d", 5651);
    freq.put("\u093e\u0924", 13410);
    freq.put("\u0915\u094b\u0902", 1045);
    freq.put("\u091c\u0948", 1167);
    freq.put("\u093e\u0927", 1672);
    freq.put("\u093e\u091a", 1779);
    freq.put("\u093e\u091c", 7904);
    freq.put("\u093e\u091f", 1520);
    freq.put("\u0915\u094b\u0936", 370);
    freq.put("\u093e\u0913", 2028);
    freq.put("\u093e\u0915", 3759);
    freq.put("\u093e\u0916", 925);
    freq.put("\u093e\u0917", 3365);
    freq.put("\u093e\u0908", 2655);
    freq.put("\u0930", 228209);
    freq.put("\u092a\u0924\u093f", 612);
    freq.put("\u091a\u093f\u0924", 1154);
    freq.put("\u093e\u090f", 1076);
    freq.put("\u093e\u0901", 2505);
    freq.put("\u0908 ", 6870);
    freq.put("\u0938 ", 15469);
    freq.put("\u0915\u094b\u0921", 3985);
    freq.put("\u093e\u0907", 2283);
    freq.put("\u0935\u093e ", 1780);
    freq.put("\u091c\u0917", 567);
    freq.put("\u0930\u0940\u0930", 445);
    freq.put("\u091c\u0902", 1545);
    freq.put(" \u0924\u0941", 355);
    freq.put("\u093e\u0964", 4894);
    freq.put("\u091c\u0932", 806);
    freq.put("\u091c\u0930", 910);
    freq.put("\u091c\u093e", 12605);
    freq.put("\u091c\u093f", 7022);
    freq.put("\u091c\u093c", 2064);
    freq.put("\u091c\u0938", 483);
    freq.put("\u091c\u0939", 523);
    freq.put("\u091c\u0927", 594);
    freq.put("\u094b\u0924\u093e", 2537);
    freq.put("\u091c\u092e", 644);
    freq.put("\u091c\u092f", 526);
    freq.put("\u091c\u092c", 740);
    freq.put("\u091c\u0928", 5056);
    freq.put("\u093e\u0902 ", 1658);
    freq.put("\u094d\u0937 ", 1625);
    freq.put("\u092a\u0940\u0921", 441);
    freq.put("\u091b", 5467);
    freq.put("\u093f\u0915\u094b", 367);
    freq.put(" \u092b\u093e", 416);
    freq.put("\u0902\u0917\u0940", 464);
    freq.put("\u091b ", 1066);
    freq.put("\u0902\u0917\u094d", 1940);
    freq.put("\u0915\u093e ", 19876);
    freq.put("\u0902\u0917\u0932", 563);
    freq.put("\u0902\u0917\u093e", 789);
    freq.put("\u093f\u0924 ", 12024);
    freq.put("\u093e\u0917\u0930", 849);
    freq.put("\u0941\u0924\u094d", 627);
    freq.put("\u0947\u0917", 371);
    freq.put("\u0947\u0916", 1744);
    freq.put("\u0947\u0915", 2519);
    freq.put("\u0947\u091f", 1393);
    freq.put("\u093f\u0932\u0924", 401);
    freq.put("\u0947\u091c", 1606);
    freq.put("\u0935\u094d", 3139);
    freq.put("\u0935\u0948", 1045);
    freq.put("\u0935\u094b", 877);
    freq.put("\u0935\u0947", 7461);
    freq.put("\u0935\u0940", 3437);
    freq.put("\u0935\u0943", 595);
    freq.put("\u0947\u0937", 1173);
    freq.put("\u0947\u0936", 12536);
    freq.put("\u0947\u0935", 2738);
    freq.put("\u093e\u091a\u0940", 795);
    freq.put("\u094d\u0925 ", 1814);
    freq.put("\u0947\u0930", 2606);
    freq.put("\u0932\u0924\u093e", 462);
    freq.put("\u0917\u0935\u093e", 390);
    freq.put("\u0947\u0939", 634);
    freq.put("\u0947\u0938", 4417);
    freq.put("\u0947\u0926", 951);
    freq.put("\u0947\u0924", 4873);
    freq.put("\u0947\u0921", 787);
    freq.put(" \u091c\u0940", 1466);
    freq.put("\u0947\u092f", 725);
    freq.put("\u0947\u092e", 795);
    freq.put(" \u091c\u094d", 953);
    freq.put("\u0947\u092c", 355);
    freq.put(" \u091c\u094b", 3609);
    freq.put("\u0947\u092a", 664);
    freq.put("\u0928\u0917\u0930", 1205);
    freq.put("\u0947\u0928", 6508);
    freq.put("\u0935\u091c", 391);
    freq.put(" \u091c\u0932", 669);
    freq.put(" \u091c\u0930", 355);
    freq.put("\u0935\u0915", 455);
    freq.put(" \u091c\u093e", 9396);
    freq.put("\u0927\u093e\u0928", 1811);
    freq.put("\u0913\u0930", 445);
    freq.put(" \u091c\u0939", 416);
    freq.put("\u092f\u094b\u091c", 542);
    freq.put("\u094b\u091a ", 425);
    freq.put("\u0932\u0924\u0940", 425);
    freq.put(" \u091c\u092c", 682);
    freq.put("\u0935\u0902", 3802);
    freq.put(" \u091c\u0917", 453);
    freq.put("\u0935\u093f", 15882);
    freq.put("\u0935\u093e", 18296);
    freq.put("\u0935\u0939", 1716);
    freq.put("\u0935\u0938", 1629);
    freq.put("\u0942\u092a ", 2670);
    freq.put("\u0935\u0935", 621);
    freq.put("\u093f\u0932\u0947", 1007);
    freq.put("\u0935\u0936", 922);
    freq.put("\u0935\u0930", 5872);
    freq.put("\u0935\u0932", 726);
    freq.put("\u0935\u092f", 393);
    freq.put("\u0947\u0964", 1956);
    freq.put("\u0935\u0928", 1882);
    freq.put("\u0935\u092a", 710);
    freq.put("\u0913\u0902", 2444);
    freq.put("\u0935\u0927", 1955);
    freq.put("\u093e\u0928\u0935", 590);
    freq.put("\u0938\u0930\u094d", 919);
    freq.put("\u093e\u0928\u093f", 2065);
    freq.put("\u093e\u0928\u093e", 1838);
    freq.put("\u092e\u092f ", 1094);
    freq.put("\u093e\u0928\u0938", 622);
    freq.put("\u093e\u0928\u0924", 633);
    freq.put(" \u0914\u0930", 11423);
    freq.put("\u091d", 1114);
    freq.put("\u092c\u093e\u0930", 924);
    freq.put("\u092c\u093e\u0932", 449);
    freq.put("\u093e\u0928\u0915", 524);
    freq.put("\u0902 ", 59244);
    freq.put("\u0940\u0964", 1527);
    freq.put("\u092a\u0930\u092e", 473);
    freq.put("\u0940\u092f ", 6964);
    freq.put("\u092c\u093e\u0902", 380);
    freq.put("\u0940\u0902", 3186);
    freq.put("\u0940\u0915", 2676);
    freq.put("\u0940\u091a", 800);
    freq.put("\u0940\u091f", 1012);
    freq.put("\u0940\u091c", 592);
    freq.put("\u0940\u0921", 730);
    freq.put("\u0940\u0924", 2135);
    freq.put("\u0940\u092a", 1050);
    freq.put("\u0940\u0928", 3683);
    freq.put("\u0940\u092e", 1042);
    freq.put("\u0940\u092f", 7229);
    freq.put("\u0940\u092c", 439);
    freq.put("\u0940\u0932", 1370);
    freq.put("\u0940\u0930", 2043);
    freq.put("\u093e\u0928\u0940", 2791);
    freq.put("\u0940\u0935", 1580);
    freq.put("\u093e\u0928\u094d", 1734);
    freq.put("\u0940\u0938", 1060);
    freq.put("\u093e\u0928\u094b", 532);
    freq.put("\u093c\u0940 ", 1669);
    freq.put("\u0915\u0932 ", 368);
    freq.put("\u091c", 58287);
    freq.put("\u090f\u0915\u094d", 3566);
    freq.put("\u0930\u091a\u0928", 643);
    freq.put("\u094d\u0917\u0924", 419);
    freq.put("\u0905\u0915\u094d", 469);
    freq.put("\u092e\u094d\u092a", 956);
    freq.put("\u091a\u0941\u0928", 405);
    freq.put("\u0947 ", 101676);
    freq.put("\u094b\u0930 ", 430);
    freq.put("\u0926\u0947\u0916", 471);
    freq.put("\u0967 ", 954);
    freq.put("\u0968\u0966", 1612);
    freq.put("\u0915\u093f ", 2326);
    freq.put("\u093e\u092f\u0940", 366);
    freq.put("\u0928\u093e\u0917", 557);
    freq.put("\u0924\u092e\u093f", 373);
    freq.put("\u0924\u092e\u093e", 404);
    freq.put("\u0907", 21960);
    freq.put("\u092c\u0908 ", 387);
    freq.put("\u0930\u0941\u092a", 452);
    freq.put("\u093f\u0915 ", 8100);
    freq.put("\u0941\u0935\u093e", 512);
    freq.put("\u0902\u0926\u0940", 875);
    freq.put("\u0902\u0926\u094d", 705);
    freq.put("\u094d\u0938 ", 1196);
    freq.put("\u0947", 193119);
    freq.put("\u0942\u0938\u0930", 611);
    freq.put("\u0902\u0928\u0947", 716);
    freq.put("\u092f\u0915\u093e", 377);
    freq.put("\u0917\u093e ", 602);
    freq.put("\u0902\u0926\u0930", 556);
    freq.put("\u092a\u0941\u0924", 428);
    freq.put("\u0902\u0926\u093f", 932);
    freq.put("\u0902\u092d ", 447);
    freq.put("\u0939\u0930\u093e", 369);
    freq.put("\u092e\u0915 ", 839);
    freq.put("\u0941\u0930 ", 2020);
    freq.put("\u093e\u0915\u094d", 373);
    freq.put("\u093e\u092a\u0928", 842);
    freq.put("\u0915\u0902\u092a", 421);
    freq.put("\u091e", 2576);
    freq.put("\u093f\u0937\u094d", 1088);
    freq.put("\u0902\u0915\u094b", 451);
    freq.put("\u0924\u094b\u0902", 455);
    freq.put("\u0902\u0915\u094d", 1624);
    freq.put("\u092f\u093e\u0932", 1423);
    freq.put("\u093f\u092d\u093f", 546);
    freq.put("\u0941\u0938\u094d", 700);
    freq.put("\u092a\u093e\u0915", 1033);
    freq.put("\u092a\u093e\u0926", 1538);
    freq.put("\u092a\u093e\u0924", 387);
    freq.put("\u0925\u0940\u0964", 911);
    freq.put("\u092a\u093e\u0928", 519);
    freq.put("\u093e\u0915\u093e", 641);
    freq.put("\u093e\u0915\u093f", 1058);
    freq.put("\u0937\u093e ", 2805);
    freq.put("\u092a\u093e\u0930", 1007);
    freq.put("\u0932\u093f\u090f", 2317);
    freq.put("\u093e\u0926\u093e", 388);
    freq.put("\u092a\u093e\u0938", 574);
    freq.put("\ufffd", 2362);
    freq.put("\u093e\u0915\u0930", 472);
    freq.put("\u0906\u0915", 698);
    freq.put("\u0909", 14369);
    freq.put("\u0906\u091c", 527);
    freq.put("\u0923\u094d\u0921", 966);
    freq.put("\u0936\u094d", 6992);
    freq.put("\u0906\u0902", 508);
    freq.put("\u0906\u0908", 372);
    freq.put("\u093f\u0936\u094d", 1982);
    freq.put("\u0930\u0926\u093e", 576);
    freq.put("\u0906\u0930", 1257);
    freq.put("\u0906\u0935", 1056);
    freq.put("\u092c ", 2705);
    freq.put("\u0906\u0938", 422);
    freq.put("\u0942\u0937\u0923", 1023);
    freq.put("\u0906\u0924", 950);
    freq.put("\u0906\u0926", 1231);
    freq.put("\u0906\u0927", 1054);
    freq.put("\u0906\u0928", 511);
    freq.put("\u0906\u092a", 1303);
    freq.put("\u0906\u092e", 383);
    freq.put("\u0906\u092f", 903);
    freq.put("\u0940\u0902 ", 2774);
    freq.put("\u0930\u0938\u093f", 1094);
    freq.put("\u0930\u0938\u093e", 555);
    freq.put("\u0949", 2831);
    freq.put(" \u092a\u091f", 420);
    freq.put("\u092c\u093f\u0939", 404);
    freq.put("\u093e\u0935 ", 1068);
    freq.put("\u0930\u0926\u0947", 1187);
    freq.put("\u091a ", 2310);
    freq.put("\u0924\u0902\u0924", 641);
    freq.put("\u0940\u0930 ", 855);
    freq.put("\u0906\u0964", 435);
    freq.put("\u094b\u0902\u0928", 705);
    freq.put("\u0908", 8670);
    freq.put("\u092e\u0902", 2240);
    freq.put("\u0915\u0930 ", 3798);
    freq.put("\u0935\u0940\u0902", 679);
    freq.put("\u092e\u0915", 1369);
    freq.put("\u092e\u0928", 2122);
    freq.put("\u092e\u092f", 1214);
    freq.put("\u0939\u0948\u0902", 10612);
    freq.put("\u092e\u0923", 522);
    freq.put("\u092e\u0924", 879);
    freq.put("\u092e\u0926", 711);
    freq.put("\u092e\u0927", 940);
    freq.put("\u092e\u0938", 725);
    freq.put("\u092e\u0939", 3586);
    freq.put(" \u0932\u0947", 1874);
    freq.put("\u0935\u0940\u092a", 490);
    freq.put("\u0938\u094d\u0932", 386);
    freq.put("\u092e\u093e", 15028);
    freq.put("\u092e\u093f", 6854);
    freq.put("\u092e\u0930", 1260);
    freq.put("\u092c\u0928\u093e", 1428);
    freq.put("\u092e\u0932", 693);
    freq.put("\u091f\u0947\u0936", 7359);
    freq.put("\u092e\u0936", 384);
    freq.put("\u092e\u0948", 980);
    freq.put("\u0932\u094b\u0915", 1046);
    freq.put("\u092e\u094b", 1712);
    freq.put("\u092e\u094d", 5925);
    freq.put("\u0928\u093f\u0930", 2352);
    freq.put("\u092e\u0940", 3565);
    freq.put("\u092e\u0941", 5029);
    freq.put("\u092e\u0942", 1671);
    freq.put("\u092e\u0943", 555);
    freq.put("\u0939\u0948\u0964", 21737);
    freq.put("\u092e\u0947", 33130);
    freq.put("\u0932\u094b\u0902", 837);
    freq.put("\u0943\u0924 ", 890);
    freq.put(" \u0932\u0917", 1362);
    freq.put("\u092d ", 1015);
    freq.put(" \u0932\u0902", 500);
    freq.put("\u0932\u094b\u092e", 397);
    freq.put("\u092a\u0928\u093e", 1055);
    freq.put("\u0905\u0902\u0924", 806);
    freq.put(" \u0924\u094d", 639);
    freq.put("\u0941\u0902", 2936);
    freq.put(" \u0924\u094b", 1173);
    freq.put("\u0941\u0906", 2021);
    freq.put("\u0941\u0908", 845);
    freq.put("\u0939\u0924\u0947", 1441);
    freq.put("\u0941\u090f", 1050);
    freq.put(" \u0924\u0940", 840);
    freq.put("\u0926\u0938\u094d", 366);
    freq.put("\u0941\u0913", 472);
    freq.put("\u0941\u0915", 2798);
    freq.put("\u0941\u0917", 719);
    freq.put("\u0941\u0916", 2469);
    freq.put("\u0941\u091b", 884);
    freq.put("\u0941\u091c", 614);
    freq.put("\u0941\u091f", 385);
    freq.put("\u0941\u0921", 541);
    freq.put("\u0941\u0923", 594);
    freq.put("\u092a\u0930\u094d", 1203);
    freq.put("\u0941\u0924", 2428);
    freq.put("\u0941\u0927", 368);
    freq.put("\u0941\u0926", 1873);
    freq.put("\u0941\u0928", 2123);
    freq.put("\u0941\u092a", 1093);
    freq.put("\u0941\u092e", 1318);
    freq.put("\u0947\u0964 ", 1586);
    freq.put("\u0941\u0930", 6463);
    freq.put("\u0941\u0932", 2104);
    freq.put("\u0941\u0935", 1118);
    freq.put("\u0941\u0937", 645);
    freq.put("\u0941\u0938", 2362);
    freq.put("\u094d\u0932\u0947", 511);
    freq.put("\u094d\u0932\u0940", 1260);
    freq.put("\u094d\u0932\u093e", 820);
    freq.put("\u0936\u093f\u0935", 510);
    freq.put("\u0916\u0947\u0902", 445);
    freq.put("\u0926 ", 7269);
    freq.put("\u0941\u0938\u093e", 1149);
    freq.put("\u092a\u0930\u093f", 1837);
    freq.put("\u092a\u0930\u093e", 615);
    freq.put(" \u0924\u0915", 1670);
    freq.put("\u0930\u0942\u092a", 2871);
    freq.put(" \u0924\u092e", 403);
    freq.put(" \u0924\u0925", 2624);
    freq.put(" \u0924\u0924", 379);
    freq.put(" \u0924\u093f", 580);
    freq.put(" \u0924\u093e", 833);
    freq.put("\u0925\u0935\u093e", 400);
    freq.put("\u0930\u093e ", 9045);
    freq.put(" \u0924\u0930", 977);
    freq.put("\u0925\u092e", 587);
    freq.put("\u093e\u0939", 4362);
    freq.put("\u090a", 1116);
    freq.put("\u091a\u0928\u093e", 962);
    freq.put("\u0925\u093f", 3214);
    freq.put("\u0925\u093e", 11678);
    freq.put("\u094d\u0935 ", 2678);
    freq.put("\u0925\u0935", 456);
    freq.put("\u0932\u0928 ", 775);
    freq.put("\u0925\u0932", 512);
    freq.put("\u0947\u0915 ", 779);
    freq.put("\u0902\u0924\u094d", 1705);
    freq.put("\u0922\u093c ", 636);
    freq.put(" \u0925\u093e", 4674);
    freq.put(" \u0969", 490);
    freq.put("\u0915\u094b", 17366);
    freq.put("\u0926\u094b ", 833);
    freq.put(" \u0925\u0947", 2324);
    freq.put(" \u0925\u0940", 1702);
    freq.put(" \u0936\u093e", 2156);
    freq.put("\u091a\u094d\u091a", 632);
    freq.put("\u0902\u0924\u0930", 775);
    freq.put("\u0902\u0924\u093f", 457);
    freq.put("\u0925\u094d", 491);
    freq.put("\u092d\u0942\u092e", 411);
    freq.put("\u091f\u0930 ", 1798);
    freq.put("\u0925\u094b", 462);
    freq.put("\u0925\u0947", 2431);
    freq.put("\u0925\u0940", 1994);
    freq.put("\u093e\u092c", 2717);
    freq.put("\u092d\u0942\u0937", 1010);
    freq.put("\u092f\u0941\u0926", 407);
    freq.put("\u092f\u0941\u0924", 419);
    freq.put("\u0930\u0916", 1463);
    freq.put("\u0930\u0917", 385);
    freq.put("\u0930\u0915", 5780);
    freq.put("\u0924\u0915 ", 1940);
    freq.put("\u0930\u0925\u092e", 512);
    freq.put("\u091c\u0941", 839);
    freq.put("\u0930\u091c", 1027);
    freq.put("\u0930\u0902", 1975);
    freq.put("\u0907\u0938\u0915", 6193);
    freq.put("\u0917\u0908 ", 460);
    freq.put("\u092f\u093e\u0926", 888);
    freq.put("\u092e\u0928 ", 544);
    freq.put("\u0930\u0932", 964);
    freq.put("\u093e\u0923", 2291);
    freq.put("\u0930\u0936", 605);
    freq.put("\u094d\u092f\u093e", 6530);
    freq.put("\u092e\u094d\u0930", 418);
    freq.put("\u0930\u0935", 1845);
    freq.put("\u0907\u0938\u092e", 1168);
    freq.put("\u0930\u0939", 3970);
    freq.put("\u0930\u093e", 30478);
    freq.put("\u0930\u093f", 9664);
    freq.put("\u094d\u092f\u0935", 609);
    freq.put("\u091c\u094b", 3936);
    freq.put("\u0930\u0923", 4290);
    freq.put("\u092f\u0941\u0915", 1333);
    freq.put("\u094d\u092f\u092f", 385);
    freq.put("\u094d\u092f\u092e", 558);
    freq.put("\u0930\u0924", 13386);
    freq.put("\u0930\u0925", 786);
    freq.put("\u0930\u092a", 839);
    freq.put("\u0947\u0928\u094d", 1060);
    freq.put("\u0930\u0928", 4212);
    freq.put("\u0930\u092e", 3670);
    freq.put("\u0930\u092f", 1959);
    freq.put("\u0930\u092c", 740);
    freq.put("\u0930\u092d", 636);
    freq.put("\u0907\u0938\u0947", 1083);
    freq.put("\u0907\u0938\u0940", 419);
    freq.put("\u0907\u0938\u094d", 411);
    freq.put("\u0947\u0928\u093e", 477);
    freq.put("\u0930\u0942", 3986);
    freq.put("\u0930\u0940", 10641);
    freq.put("\u0930\u0941", 2131);
    freq.put("\u0930\u0947", 18745);
    freq.put("\u0930\u094b", 5583);
    freq.put("\u0930\u0948", 502);
    freq.put("\u0930\u0949", 358);
    freq.put("\u0930\u094d", 27657);
    freq.put("\u0939\u0924\u094d", 826);
    freq.put("\u091e\u093e", 1890);
    freq.put("\u0942\u0928 ", 537);
    freq.put("\u092a\u094d\u0930", 23891);
    freq.put("\u0941\u091b ", 876);
    freq.put("\u092a\u094d\u092f", 460);
    freq.put("\u093e\u0924 ", 1397);
    freq.put("\u0930\u0923 ", 3158);
    freq.put("\u092a\u094d\u0924", 1355);
    freq.put("\u0905\u0925\u0935", 383);
    freq.put("\u0915\u094b\u0932", 359);
    freq.put("\u0935\u0930 ", 730);
    freq.put("\u093f\u0930 ", 1319);
    freq.put(" \u090f\u0915", 15549);
    freq.put("\u0930\u0947\u091c", 901);
    freq.put("\u0924\u094d", 23294);
    freq.put("\u0924\u094b", 1865);
    freq.put("\u093e\u0909", 506);
    freq.put("\u0924\u0947", 6961);
    freq.put("\u0930\u092e\u093e", 570);
    freq.put("\u0924\u0940", 14469);
    freq.put("\u0924\u0941", 2358);
    freq.put("\u0930\u091a", 1272);
    freq.put("\u0926\u0915\u094d", 984);
    freq.put("\u0924\u092e", 1364);
    freq.put("\u0924\u092a", 364);
    freq.put("\u0924\u093e\u0930", 557);
    freq.put("\u0924\u0928", 1343);
    freq.put("\u0924\u0924", 547);
    freq.put("\u0924\u0925", 2628);
    freq.put("\u0928\u093e\u091f", 450);
    freq.put("\u0924\u093e", 20016);
    freq.put("\u0924\u093f", 11566);
    freq.put("\u094d\u091a ", 578);
    freq.put("\u094d\u092f\u0915", 2308);
    freq.put("\u0924\u093e\u092c", 607);
    freq.put("\u0924\u0935", 480);
    freq.put("\u0924\u0932", 566);
    freq.put("\u093e\u0902", 6856);
    freq.put("\u0924\u0930", 5109);
    freq.put("\u0966 ", 1980);
    freq.put("\u0928\u093e\u0935", 392);
    freq.put("\u0924\u093e\u0913", 415);
    freq.put("\u0924\u0902", 976);
    freq.put("\u0924\u0903", 367);
    freq.put("\u0928\u093e\u0921", 359);
    freq.put("\u0928\u093e\u0925", 458);
    freq.put("\u091a\u093f\u092e", 876);
    freq.put("\u0928\u093e\u0928", 715);
    freq.put("\u0936\u094b\u0902", 440);
    freq.put("\u0924\u0915", 2674);
    freq.put("\u0928\u093e\u092f", 738);
    freq.put("\u0928\u093e\u092e", 2777);
    freq.put("\u092a\u0924\u094d", 1249);
    freq.put("\u0902\u0938\u093e", 366);
    freq.put("\u0941\u0906 ", 1392);
    freq.put("\u0923 ", 9157);
    freq.put("\u0928\u0940\u0924", 724);
    freq.put("\u0930\u091c\u093f", 411);
    freq.put("\u0930\u0947\u0902", 640);
    freq.put("\u0935\u094d\u092f", 2741);
    freq.put("\u0940\u0915 ", 803);
    freq.put("\u091f", 40532);
    freq.put(" \ufffd", 578);
    freq.put("\u0937\u0947", 3151);
    freq.put("\u094d\u0915\u0930", 450);
    freq.put("\u0937\u094d", 6623);
    freq.put("\u094d\u0915\u093e", 992);
    freq.put("\u0936\u0924\u093e", 469);
    freq.put("\u0935\u0938\u094d", 1030);
    freq.put("\u0937\u0923", 1876);
    freq.put("\u093c\u093e ", 1290);
    freq.put("\u0937\u092f", 360);
    freq.put("\u092a\u0915\u094d", 435);
    freq.put("\u094d\u0915\u0943", 823);
    freq.put("\u0937\u093f", 1967);
    freq.put("\u0937\u093e", 3622);
    freq.put("\u0917\u094b\u0932", 437);
    freq.put("\u0935\u092a\u0942", 515);
    freq.put("\u0917\u094b\u0902", 941);
    freq.put("\u094d\u0926 ", 1588);
    freq.put("\u0902\u0938\u094d", 2087);
    freq.put("\u0928\u094d ", 786);
    freq.put("\u0930\u0938", 3428);
    freq.put("\u091a\u0940 ", 462);
    freq.put("\u094d\u0939\u094b", 949);
    freq.put(" \u092d\u0930", 368);
    freq.put("\u0916", 13380);
    freq.put("\u093e ", 97285);
    freq.put(" \u092d\u093e", 10893);
    freq.put("\u094d\u0923 ", 1354);
    freq.put("\u0925\u093e\u092a", 1123);
    freq.put("\u094d\u0939\u0947", 874);
    freq.put("\u0908\u0938", 387);
    freq.put("\u091f\u0924\u0940", 1811);
    freq.put("\u0930\u0940\u092f", 1696);
    freq.put("\u0914\u0930 ", 11340);
    freq.put(" \u092d\u0917", 427);
    freq.put("\u0930\u0926", 2279);
    freq.put("\u092e\u0902\u0921", 367);
    freq.put("\u094b\u0902 ", 14584);
    freq.put("\u0915\u094b ", 9463);
    freq.put("\u0935\u0930\u094d", 3433);
    freq.put("\u0930\u094b\u0917", 432);
    freq.put("\u0935\u093e\u0926", 1110);
    freq.put("\u0935\u093e\u0928", 862);
    freq.put("\u0902\u092c\u0930", 485);
    freq.put("\u0935\u0930\u0940", 565);
    freq.put("\u0938\u0942\u0930", 646);
    freq.put("\u0935\u093e\u0930", 6241);
    freq.put("\u092e\u094d\u092e", 1860);
    freq.put("\u093e\u0901 ", 1565);
    freq.put("\u0930\u0940 ", 6215);
    freq.put("\u0930\u0916\u0947", 433);
    freq.put("\u0935\u093e\u0938", 1153);
    freq.put("\u0935\u093e\u0939", 694);
    freq.put("\u092e\u094d\u092c", 1357);
    freq.put(" \u092d\u0940", 4132);
    freq.put("\u0930\u0940\u0915", 801);
    freq.put(" \u092d\u0942", 1742);
    freq.put(" \u092d\u094c", 360);
    freq.put("\u0917\u094d\u0932", 427);
    freq.put("\u0917\u094d\u0930", 3597);
    freq.put("\u091c ", 2925);
    freq.put("\u0935\u093e\u091a", 378);
    freq.put("\u094d\u092f\u0924", 638);
    freq.put("\u0902\u092c\u0902", 450);
    freq.put("\u0901", 3754);
    freq.put("\u093f\u0924\u094d", 3274);
    freq.put("\u094d\u0937\u093f", 1460);
    freq.put("\u094d\u0937\u093e", 1408);
    freq.put("\u093e\u0902\u0924", 1630);
    freq.put("\u094d\u0937\u0923", 540);
    freq.put("\u093e\u0902\u0938", 610);
    freq.put("\u0941\u0924 ", 1429);
    freq.put("\u091b\u093e", 395);
    freq.put("\u0930\u092f\u094b", 985);
    freq.put("\u0938\u093e\u0930", 1977);
    freq.put("\u0917\u093f\u0915", 498);
    freq.put("\u0930\u0947\u0932", 6023);
    freq.put("\u093e\u0902\u0917", 686);
    freq.put("\u0930\u092f\u0941", 635);
    freq.put("\u0941", 44034);
    freq.put("\u0927\u094d\u092f", 2164);
    freq.put("\u092f\u0924\u093e", 597);
    freq.put("\u0902\u0917 ", 1786);
    freq.put("\u091b\u0942", 1841);
    freq.put("\u091b\u094b", 713);
    freq.put(" \u092f\u094b", 670);
    freq.put("\u093e\u0932\u093e", 1369);
    freq.put("\u0909\u0938", 2266);
    freq.put("\u093e\u0917 ", 1189);
    freq.put("\u0902\u091a\u093e", 2297);
    freq.put("\u091a\u0924\u0940", 1825);
    freq.put("\u0909\u0928", 3336);
    freq.put("\u0902\u091a\u0924", 1845);
    freq.put("\u094d\u0937\u0947", 3114);
    freq.put("\u0930\u0947\u0938", 3665);
    freq.put("\u093f\u0924\u093e", 1136);
    freq.put("\u093f\u0924\u093f", 559);
    freq.put(" \u091d", 690);
    freq.put("\u0909\u0924", 2684);
    freq.put("\u094d\u0937\u094d", 370);
    freq.put("\u0909\u0926", 1042);
    freq.put("\u0917\u0924 ", 745);
    freq.put(" \u0917\u0923", 526);
    freq.put(" \u0917\u092f", 3607);
    freq.put("\u0915\u0924\u0947", 720);
    freq.put(" \u0917\u0930", 416);
    freq.put("\u094d\u092f\u0942", 989);
    freq.put(" \u0917\u093e", 1413);
    freq.put("\u092e\u0941\u0926", 734);
    freq.put("\u094d\u092f\u0941", 778);
    freq.put(" \u0917\u090f", 382);
    freq.put(" \u0917\u0908", 551);
    freq.put("\u0943\u0924", 2832);
    freq.put("\u0943\u0937", 1881);
    freq.put("\u0927\u093f ", 2431);
    freq.put("\u091c\u094b ", 3111);
    freq.put("\u0930\u0924 ", 4510);
    freq.put(" \u0909\u0938", 2203);
    freq.put("\u0940", 110466);
    freq.put("\u0941\u0908 ", 687);
    freq.put("\u092c\u0928\u094d", 526);
    freq.put(" \u0909\u0928", 3214);
    freq.put(" \u0909\u092a", 2582);
    freq.put("\u090f\u0938", 427);
    freq.put("\u092e\u0938\u094d", 459);
    freq.put("\u090f\u0935", 3043);
    freq.put(" \u0909\u0924", 2673);
    freq.put("\u090f\u0932", 360);
    freq.put(" \u0909\u0926", 990);
    freq.put("\u0936\u093e\u0932", 480);
    freq.put(" \u0917\u0941", 1570);
    freq.put(" \u0917\u094d", 1394);
    freq.put("\u0915\u0924\u093e", 1005);
    freq.put("\u090f\u0902", 534);
    freq.put("\u090f\u0901", 425);
    freq.put("\u0936\u093e\u0938", 1407);
    freq.put("\u0940\u0932 ", 655);
    freq.put("\u0940\u092e\u093e", 484);
    freq.put("\u090f\u0915", 15570);
    freq.put("\u0939\u0947\u0902", 816);
    freq.put("\u093c\u093e", 2260);
    freq.put("\u093c\u093f", 839);
    freq.put("\u0938\u092d\u0940", 533);
    freq.put("\u0940\u0924 ", 751);
    freq.put("\u0915\u092e ", 375);
    freq.put("\u093c\u0924", 356);
    freq.put("\u0938\u0940\u092e", 423);
    freq.put("\u0915\u0932\u093e", 836);
    freq.put("\u092b", 9525);
    freq.put("\u0939\u094b\u0924", 4643);
    freq.put("\u096f ", 917);
    freq.put("\u092a\u094c", 356);
    freq.put("\u092a\u094d", 26390);
    freq.put("\u092a\u0948", 501);
    freq.put("\u092a\u094b", 892);
    freq.put("\u092a\u0947", 1223);
    freq.put("\u092a\u0940", 1550);
    freq.put("\u092a\u0941", 5232);
    freq.put("\u092a\u0942", 3275);
    freq.put("\u092a\u0943", 1255);
    freq.put("\u092e\u0941\u0902", 391);
    freq.put("\u092a\u093e", 8076);
    freq.put("\u092a\u093f", 1966);
    freq.put("\u092a\u0938", 581);
    freq.put("\u092a\u0939", 3589);
    freq.put("\u0942\u0930\u0940", 482);
    freq.put("\u092a\u0936", 1179);
    freq.put("\u092a\u0930", 12235);
    freq.put("\u092f\u093e\u0938", 655);
    freq.put("\u092a\u0932", 544);
    freq.put("\u0915\u0940\u092f", 409);
    freq.put("\u092a\u092f", 630);
    freq.put("\u092a\u0928", 4849);
    freq.put("\u092a\u0924", 2217);
    freq.put("\u092a\u0926", 2167);
    freq.put("\u092a\u0921", 542);
    freq.put("\u0916 ", 1929);
    freq.put("\u092a\u091f", 576);
    freq.put("\u0936\u092c\u094d", 1328);
    freq.put("\u092a\u0915", 1243);
    freq.put("\u096b", 1969);
    freq.put("\u0928\u0938\u092d", 406);
    freq.put("\u093c\u0947", 807);
    freq.put("\u0938\u092d\u093e", 753);
    freq.put("\u093c\u0940", 1936);
    freq.put("\u093c\u094d", 460);
    freq.put("\u093c\u094b", 448);
    freq.put("\u092a\u0902", 1090);
    freq.put("\u0902", 116003);
    freq.put("\u0967\u0966", 362);
    freq.put("\u0967\u096f", 2833);
    freq.put("\u0967\u096e", 536);
    freq.put("\u0968 ", 974);
    freq.put("\u0907\u0924\u093f", 479);
    freq.put("\u0947\u0938 ", 3757);
    freq.put("\u0906\u0926\u093f", 993);
    freq.put(" \u092e\u0948", 859);
    freq.put(" \u092e\u094b", 707);
    freq.put(" \u092e\u0941", 2959);
    freq.put(" \u092e\u0940", 694);
    freq.put(" \u092e\u0942", 889);
    freq.put(" \u092e\u0947", 29038);
    freq.put("\u0938\u092e\u093e", 1211);
    freq.put("\u094d\u0917 ", 934);
    freq.put("\u094b\u0930\u094d", 465);
    freq.put("\u0938\u092e\u092f", 1034);
    freq.put("\u0928\u0939\u0940", 1669);
    freq.put("\u0916\u094d\u092f", 2528);
    freq.put("\u0918\u0902\u091f", 1796);
    freq.put("\u0942", 22463);
    freq.put("\u0939\u094b\u0902", 935);
    freq.put("\u090f\u0915 ", 11574);
    freq.put(" \u092e\u0927", 857);
    freq.put(" \u092e\u0939", 3455);
    freq.put("\u0938\u092e\u0942", 429);
    freq.put(" \u092e\u093f", 3653);
    freq.put(" \u092e\u093e", 5157);
    freq.put("\u0928\u094b\u0902", 1406);
    freq.put(" \u092e\u0930", 397);
    freq.put("\u0938\u092e\u094d", 2440);
    freq.put("\u0924\u092e ", 378);
    freq.put("\u0915\u093f\u0924", 562);
    freq.put("\u0915\u093f\u092a", 365);
    freq.put("\u0915\u093f\u0928", 799);
    freq.put("\u0915\u093f\u092f", 4402);
    freq.put("\u0915\u093f\u0932", 674);
    freq.put("\u0915\u093f\u0938", 2621);
    freq.put("\u093f\u0915\u093f", 844);
    freq.put("\u093f\u0915\u093e", 3179);
    freq.put("\u093f\u0915\u0932", 459);
    freq.put("\u0915\u094d\u091f", 677);
    freq.put("\u0930\u0941 ", 369);
    freq.put("\u0941\u0930\u094d", 818);
    freq.put("\u0941\u0930\u0942", 359);
    freq.put("\u0941\u0930\u0941", 791);
    freq.put("\u094d\u0938\u093e", 631);
    freq.put("\u0915\u094d\u0937", 8266);
    freq.put("\u0915\u094d\u0936", 1460);
    freq.put("\u0915\u094d\u0930", 2787);
    freq.put("\u092b\u0940 ", 766);
    freq.put("\u091c\u093c\u0940", 477);
    freq.put("\u092d", 28885);
    freq.put("\u0915\u094d\u0938", 4316);
    freq.put("\u0915\u094d\u0924", 3551);
    freq.put("\u092a\u0926\u093e", 458);
    freq.put("\u0915\u094d\u092f", 529);
    freq.put("\u0917\u093e\u0932", 415);
    freq.put("\u0902\u0926 ", 452);
    freq.put("\u092a\u0926\u094d", 1215);
    freq.put("\u094d\u0938\u094d", 3660);
    freq.put("\u094d\u0936\u0928", 1985);
    freq.put("\u0969 ", 798);
    freq.put("\u0941\u0930\u0938", 482);
    freq.put("\u0941\u0930\u093e", 1009);
    freq.put(" \u0935 ", 823);
    freq.put("\u096d", 1738);
    freq.put("\u0917\u093e\u0902", 472);
    freq.put("\u0939\u0930 ", 1676);
    freq.put("\u093f\u0915\u094d", 1744);
    freq.put("\u093f\u0915\u0940", 876);
    freq.put("\u092e\u094b\u0902", 431);
    freq.put("\u0936\u0924", 728);
    freq.put("\u092f\u094b\u0917", 2669);
    freq.put("\u0936\u0928", 10719);
    freq.put("\u090f\u0935\u0902", 2948);
    freq.put("\u0936\u092c", 1373);
    freq.put("\u0935\u0935\u093f", 516);
    freq.put("\u093f\u0932 ", 1061);
    freq.put("\u0936\u0930", 623);
    freq.put("\u092f\u094b\u0902", 3685);
    freq.put("\u093e\u0926\u0940", 544);
    freq.put("\u0936\u0939", 1374);
    freq.put("\u093f\u0936\u093e", 959);
    freq.put("\u0936\u093e", 4600);
    freq.put("\u0936\u093f", 3780);
    freq.put("\u0937\u093f\u0924", 444);
    freq.put("\u091e\u093e\u0928", 1620);
    freq.put("\u092c", 39694);
    freq.put("\u0937\u093f\u0923", 921);
    freq.put("\u094d\u0921 ", 1049);
    freq.put("\u0936\u0915", 894);
    freq.put("\u094d\u0925\u0932", 430);
    freq.put("\u0913\u0930 ", 406);
    freq.put("\u094d\u0925\u093f", 2834);
    freq.put("\u094d\u0925\u093e", 3750);
    freq.put("\u092f\u0947 ", 4867);
    freq.put("\u0927\u093e ", 464);
    freq.put("\u092c\u0940\u091a", 558);
    freq.put("\u0936\u0940", 1148);
    freq.put("\u0936\u0941", 1050);
    freq.put(" \u090f\u0935", 3020);
    freq.put("\u092e\u0939\u093e", 2097);
    freq.put("\u093f\u0936\u0947", 677);
    freq.put("\u0936\u0947", 1186);
    freq.put("\u0936\u0948", 363);
    freq.put(" \u0918\u0902", 1793);
    freq.put("\u0936\u094b", 892);
    freq.put("\u096c", 1789);
    freq.put("\u091c\u0948\u0938", 743);
    freq.put(" \u0936\u0915", 380);
    freq.put("\u0935 ", 7299);
    freq.put("\u092e\u0939\u0924", 756);
    freq.put("\u0936\u093f\u0915", 1243);
    freq.put("\u0941\u090f ", 894);
    freq.put("\u092c\u093e ", 412);
    freq.put("\u0902\u0915", 4013);
    freq.put("\u0902\u0916", 1287);
    freq.put("\u0902\u0917", 7039);
    freq.put("\u093e\u0928 ", 8758);
    freq.put("\u0917", 41430);
    freq.put("\u0902\u091c", 1716);
    freq.put("\u0902\u091f", 3074);
    freq.put("\u0902\u0918", 459);
    freq.put("\u0902\u091a", 5039);
    freq.put("\u0902\u0924", 5036);
    freq.put("\u0902\u0925", 399);
    freq.put("\u0902\u0926", 4729);
    freq.put("\u0902\u0927", 1776);
    freq.put("\u0902\u0921", 2775);
    freq.put("\u093f\u0928\u094d", 3490);
    freq.put("\u0902\u092c", 1984);
    freq.put("\u0902\u092d", 782);
    freq.put("\u0902\u092f", 471);
    freq.put("\u0902\u0928", 763);
    freq.put("\u0902\u092a", 2156);
    freq.put("\u0936\u093f\u0924", 453);
    freq.put("\u0902\u0935", 676);
    freq.put("\u0902\u0936", 984);
    freq.put(" \u0967\u096e", 501);
    freq.put(" \u0967\u096f", 2789);
    freq.put("\u0936\u093f\u092f", 571);
    freq.put("\u0902\u0938", 3555);
    freq.put("\u0902\u0939", 717);
    freq.put("\u0905\u092a\u0928", 2305);
    freq.put("\u094d\u091c\u093e", 403);
    freq.put("\u092f\u0935", 775);
    freq.put("\u0940\u0921\u093f", 468);
    freq.put("\u0902\u0964", 6630);
    freq.put("\u0940 ", 75983);
    freq.put("\u0948\u0938\u0947", 672);
    freq.put("\u0938\u0930 ", 563);
    freq.put("\u0936 ", 4366);
    freq.put("\u092d\u0941", 462);
    freq.put("\u092d\u0940", 5128);
    freq.put("\u0915\u0930\u0928", 3111);
    freq.put("\u092d\u0942", 2019);
    freq.put("\u092d\u094d", 381);
    freq.put("\u092d\u094c", 389);
    freq.put("\u0915\u0930\u0924", 2060);
    freq.put("\u0906\u092a ", 923);
    freq.put("\u0915\u0930\u0923", 990);
    freq.put("\u092d\u094b", 416);
    freq.put("\u0915\u0930\u093e", 372);
    freq.put("\u091b\u094b\u091f", 541);
    freq.put("\u0926\u0940", 5182);
    freq.put("\u0938\u0942\u091a", 437);
    freq.put("\u092e ", 13770);
    freq.put("\u0924\u0930\u093e", 413);
    freq.put("\u091f\u0947 ", 2183);
    freq.put("\u0924\u0930\u0939", 445);
    freq.put("\u092e", 108014);
    freq.put("\u0935\u0940 ", 1441);
    freq.put("\u0915\u093e\u0932", 1674);
    freq.put("\u0939\u094b\u0928", 1130);
    freq.put(" \u0936\u0939", 1270);
    freq.put("\u092d\u0917", 1053);
    freq.put("\u0924\u0930\u0940", 448);
    freq.put("\u0924\u0930\u094d", 854);
    freq.put("\u0936\u0947\u0937", 769);
    freq.put("\u093f\u0932\u093e", 1775);
    freq.put("\u0906\u0927\u093e", 542);
    freq.put("\u0915\u0930\u094d", 878);
    freq.put("\u0915\u0930\u0947", 537);
    freq.put("\u096e", 1943);
    freq.put("\u092d\u0935", 561);
    freq.put("\u092d\u0930", 525);
    freq.put("\u092d\u093f", 1870);
    freq.put("\u092d\u093e", 13836);
    freq.put(" \u0968\u0966", 1512);
    freq.put("\u0947\u0902", 31320);
    freq.put("\u0906\u0935\u0936", 646);
    freq.put("\u0915\u093e\u0902", 514);
    freq.put(" \u092f\u0926", 611);
    freq.put(" \u092f\u093e", 6370);
    freq.put("\u093e\u0926\u093f", 1157);
    freq.put("\u091c\u0902\u0915", 1375);
    freq.put(" \u092f\u0939", 10383);
    freq.put("\u0941 ", 3758);
    freq.put("\u091a\u093f\u0915", 478);
    freq.put("\u0915\u093e\u0928", 492);
    freq.put("\u092c\u094b\u0932", 432);
    freq.put("\u0915\u093e\u092b", 651);
    freq.put("\u0915\u093e\u092e", 601);
    freq.put("\u0915\u093e\u0930", 8097);
    freq.put("\u0926\u0941", 1528);
    freq.put("\u0926\u0942", 2227);
    freq.put("\u0926\u0943", 463);
    freq.put("\u0915\u093e\u0935", 390);
    freq.put("\u0915\u093e\u0936", 1174);
    freq.put("\u0926\u0947", 6364);
    freq.put("\u0915\u093e\u0938", 610);
    freq.put("\u0926\u094b", 2067);
    freq.put("\u0926\u094c", 382);
    freq.put("\u0926\u094d", 15486);
    freq.put("\u0928\u093e\u0924", 423);
    freq.put("\u0926\u0930", 2412);
    freq.put("\u0930\u094d\u0915", 924);
    freq.put("\u0926\u0932", 1038);
    freq.put("\u0930\u094d\u0917", 1726);
    freq.put("\u0926\u0936", 363);
    freq.put("\u092b\u0947\u0930", 414);
    freq.put("\u0926\u0938", 512);
    freq.put(" \u0928\u0917", 840);
    freq.put("\u0930\u094d\u091f", 763);
    freq.put("\u0926\u093e", 4680);
    freq.put("\u0926\u093f", 8815);
    freq.put("\u0930\u094d\u091a", 479);
    freq.put("\u0926\u0928", 776);
    freq.put("\u0947\u0932", 9698);
    freq.put("\u091a\u093e\u0932", 2122);
    freq.put(" \u0925", 8999);
    freq.put("\u091a\u093e\u0930", 1698);
    freq.put("\u0926\u0915", 1341);
    freq.put(" \u092f\u0947", 2040);
    freq.put(" \u092f\u0942", 702);
    freq.put(" \u092f\u0941", 969);
    freq.put("\u0930\u094d\u0924", 1633);
    freq.put("\u0930\u094d\u0925", 2552);
    freq.put("\u0930\u094d\u0926", 1098);
    freq.put("\u0930\u094d\u0927", 360);
    freq.put("\u0930\u094d\u0921", 507);
    freq.put("\u0930\u094d\u0923", 1686);
    freq.put("\u0930\u094d\u092c", 360);
    freq.put("\u0930\u094d\u092d", 362);
    freq.put("\u0947\u0932 ", 4266);
    freq.put("\u0930\u094d\u092f", 2627);
    freq.put("\u0930\u094d\u0928", 513);
    freq.put("\u0930\u094d\u092b", 531);
    freq.put("\u094d\u0924\u094d", 1391);
    freq.put("\u094d\u0924\u0940", 679);
    freq.put("\u094d\u0924\u0941", 954);
    freq.put("\u0924\u094b ", 1178);
    freq.put("\u0938\u0915\u0924", 1521);
    freq.put("\u0918", 4688);
    freq.put("\u0942\u0939 ", 393);
    freq.put("\u0925\u0940 ", 791);
    freq.put("\u093f\u0927\u093f", 924);
    freq.put("\u0932", 79901);
    freq.put("\u093f\u0923 ", 703);
    freq.put(" \u091c\u0928", 2746);
    freq.put("\u091f\u093f ", 384);
    freq.put("\u0930\u094d\u0935", 3266);
    freq.put(" \u0928\u0939", 1717);
    freq.put("\u0930\u094d\u0937", 1579);
    freq.put("\u0902\u0915 ", 375);
    freq.put("\u094d\u0924\u0915", 539);
    freq.put("\u0941\u0926\u094d", 1350);
    freq.put("\u094d\u0924\u0928", 384);
    freq.put("\u094d\u0924\u092e", 479);
    freq.put("\u0938\u0942", 1760);
    freq.put("\u0928\u0908 ", 675);
    freq.put("\u094d\u0924\u093e", 2582);
    freq.put("\u094d\u0924\u093f", 2706);
    freq.put("\u094d\u0920 ", 1088);
    freq.put("\u094d\u0924\u0930", 2639);
    freq.put(" \u091c\u0948", 1100);
    freq.put("\u091a\u094c", 426);
    freq.put("\u091a\u094d", 1117);
    freq.put("\u0903", 743);
    freq.put("\u092e\u093e\u091c", 766);
    freq.put("\u092c\u0902", 1558);
    freq.put("\u0930\u094d\u0938", 388);
    freq.put("\u091a\u0947", 1055);
    freq.put("\u091a\u0940", 1816);
    freq.put("\u091a\u0941", 923);
    freq.put("\u092c\u0908", 388);
    freq.put("\u092c\u091c", 3798);
    freq.put("\u092e\u093e\u0902", 436);
    freq.put("\u0940\u0930\u094d", 408);
    freq.put("\u092c\u0926", 869);
    freq.put("\u092c\u0921", 1139);
    freq.put("\u093e\u0927\u093f", 410);
    freq.put("\u092e\u093e\u0932", 612);
    freq.put("\u092c\u0928", 3146);
    freq.put("\u092e\u093e\u0930", 2023);
    freq.put("\u0906 ", 1631);
    freq.put(" \u091c\u093f", 5438);
    freq.put("\u092c\u0932", 818);
    freq.put("\u092c\u0930", 2061);
    freq.put("\u092e\u093e\u0928", 5551);
    freq.put("\u092c\u093e", 6278);
    freq.put("\u092c\u093f", 1756);
    freq.put("\u092e\u093e\u0924", 697);
    freq.put("\u092e\u093e\u0923", 1011);
    freq.put("\u092c\u0938", 1999);
    freq.put("\u092c\u0939", 1601);
    freq.put("\u092c\u0947", 1048);
    freq.put("\u0943", 6345);
    freq.put("\u092c\u0940", 1868);
    freq.put("\u092c\u0941", 789);
    freq.put("\u092c\u094d", 3946);
    freq.put("\u092c\u094b", 1031);
    freq.put("\u092c\u0948", 523);
    freq.put("\u093e\u0935\u093e", 595);
    freq.put("\u093e\u0935\u093f", 362);
    freq.put("\u091a\u0915", 424);
    freq.put("\u091c\u0947 ", 3791);
    freq.put("\u091c\u0928\u0938", 468);
    freq.put("\u0930\u094d\u092e", 3443);
    freq.put("\u093e\u0935\u0930", 399);
    freq.put("\u093e\u0938 ", 2767);
    freq.put("\u091a\u0928", 1667);
    freq.put("\u091a\u0924", 1993);
    freq.put("\u0927\u093e\u0930", 1754);
    freq.put("\u091a\u093e", 5438);
    freq.put("\u091a\u093f", 3214);
    freq.put("\u091a\u0930", 750);
    freq.put("\u091a\u0932", 1479);
    freq.put("\u092f\u0902\u0924", 450);
    freq.put("\u093e\u092a\u093e", 517);
    freq.put("\u0930\u0935\u093e", 666);
    freq.put("\u092e\u0947 ", 1785);
    freq.put("\u091c\u093c ", 425);
    freq.put("\u091c\u0927\u093e", 578);
    freq.put("\u092a\u0942\u0930", 2834);
    freq.put("\u0905\u0928\u0947", 519);
    freq.put("\u0905\u0928\u0941", 2084);
    freq.put("\u0905\u0928\u094d", 1665);
    freq.put("\u0938\u093e\u0902", 361);
    freq.put("\u094d\u091a\u093f", 1116);
    freq.put("\u0924 ", 29579);
    freq.put("\u093f\u0932\u094d", 2138);
    freq.put("\u0924\u093e ", 14635);
    freq.put("\u0938\u093e\u0917", 441);
    freq.put("\u093f\u0932\u094b", 516);
    freq.put("\u0938\u093e\u0925", 1234);
    freq.put("\u0938\u093e\u0927", 457);
    freq.put("\u0938\u093e\u092f", 536);
    freq.put("\u0938\u093e\u092e", 1236);
    freq.put("\u0928\u093e ", 7450);
    freq.put("\u0943\u0937\u094d", 1735);
    freq.put("\u0938\u093e\u0939", 1353);
    freq.put("\u093e\u092a\u094d", 901);
    freq.put("\u0940\u0915\u093e", 588);
    freq.put("\u0923\u0928", 433);
    freq.put("\u0905", 27216);
    freq.put("\u0928\u0940 ", 5102);
    freq.put("\u093e\u0938\u0915", 514);
    freq.put("\u0923\u093f", 851);
    freq.put("\u0923\u093e", 1135);
    freq.put("\u0902\u0938 ", 426);
    freq.put("\u092c\u0940 ", 558);
    freq.put("\u093e\u092e", 8252);
    freq.put("\u096b ", 1070);
    freq.put("\u093e\u0938\u0928", 527);
    freq.put(" \u0930\u0942", 2374);
    freq.put(" \u0930\u0941", 449);
    freq.put(" \u0930\u0947", 6398);
    freq.put("\u094d\u0915 ", 738);
    freq.put(" \u0930\u094b", 897);
    freq.put("\u094b\u0932\u0940", 389);
    freq.put("\u093e\u0938\u093e", 469);
    freq.put(" \u091c\u0902", 1512);
    freq.put("\u093e\u092f", 6583);
    freq.put("\u093e\u0938\u0940", 381);
    freq.put("\u0937 ", 2544);
    freq.put("\u093e\u0938\u094d", 1433);
    freq.put(" \u0930\u0939", 2139);
    freq.put("\u093e\u0926 ", 3112);
    freq.put(" \u0930\u093f", 478);
    freq.put(" \u0930\u093e", 8448);
    freq.put("\u0935\u0924", 1673);
    freq.put("\u0923\u094b", 495);
    freq.put(" \u0930\u0916", 1043);
    freq.put("\u0923\u094d", 1311);
    freq.put(" \u0930\u091a", 735);
    freq.put("\u0923\u0941", 577);
    freq.put("\u0923\u0940", 758);
    freq.put("\u0924\u0928 ", 484);
    freq.put(" \u0930\u0902", 422);
    freq.put("\u0928\u094d\u092e", 1190);
    freq.put("\u0928\u094d\u092f", 2792);
    freq.put("\u0928\u094d\u0928", 1957);
    freq.put("\u0932\u094d\u092a", 398);
    freq.put("\u0928\u094d\u0926", 3701);
    freq.put("\u0928\u094d\u0927", 640);
    freq.put("\u0932\u094d\u092e", 761);
    freq.put("\u0932\u094d\u092f", 463);
    freq.put("\u094d\u0935\u0935", 540);
    freq.put("\u094d\u0935\u0930", 1044);
    freq.put("\u0932\u0928\u093e", 388);
    freq.put("\u091f\u0930\u094d", 362);
    freq.put("\u094d\u0935\u093f", 632);
    freq.put("\u094d\u0935\u093e", 6601);
    freq.put("\u0925 ", 4109);
    freq.put("\u0939\u0932\u0947", 581);
    freq.put("\u091a\u0928 ", 356);
    freq.put("\u092f\u0930 ", 634);
    freq.put("\u094d\u0935\u092a", 609);
    freq.put("\u0947\u0935\u093e", 915);
    freq.put("\u0902\u0936 ", 574);
    freq.put("\u0902\u092a\u093e", 1007);
    freq.put("\u0947\u0915\u093f", 361);
    freq.put(" \u0921\u093e", 569);
    freq.put(" \u0921\u093f", 508);
    freq.put("\u0926\u094b\u0928", 372);
    freq.put("\u092c\u093e\u0926", 1868);
    freq.put("\u0902\u0924 ", 1187);
    freq.put("\u0947\u0915\u094d", 824);
    freq.put("\u0941\u0937\u094d", 405);
    freq.put("\u090f\u0901 ", 417);
    freq.put("\u0926\u094b\u0902", 393);
    freq.put("\u0903 ", 691);
    freq.put("\u094d\u0935\u0947", 430);
    freq.put("\u092a\u093f\u0924", 787);
    freq.put("\u093e\u0925", 2015);
    freq.put("\u094d\u0935\u0940", 1298);
    freq.put("\u0939\u0932\u093e", 582);
    freq.put("\u092f\u0941 ", 436);
    freq.put("\u091f\u093e ", 740);
    freq.put("\u093e\u0926", 7103);
    freq.put("\u093e\u0924\u094d", 3549);
    freq.put("\u093e\u0924\u0940", 1316);
    freq.put("\u093f\u0930\u093e", 423);
    freq.put("\u093e\u0924\u0947", 918);
    freq.put(" \u091a\u094c", 410);
    freq.put("\u0907\u0938 ", 3686);
    freq.put(" \u091a\u0947", 563);
    freq.put(" \u091a\u0941", 690);
    freq.put(" \u091a\u0940", 475);
    freq.put("\u092f", 96626);
    freq.put("\u0930 ", 61007);
    freq.put("\u093e\u0921\u093c", 911);
    freq.put("\u0928\u0915\u093e", 1135);
    freq.put("\u094d\u092f ", 9507);
    freq.put("\u092f\u0926\u093f", 507);
    freq.put("\u0928\u0915\u0947", 1054);
    freq.put("\u0928\u0915\u0940", 794);
    freq.put("\u092e\u093f\u0915", 732);
    freq.put(" \u091a\u093f", 1251);
    freq.put(" \u091a\u093e", 1105);
    freq.put("\u0947\u0928 ", 4101);
    freq.put("\u094b\u091c\u0928", 549);
    freq.put(" \u091a\u0930", 408);
    freq.put(" \u091a\u0932", 837);
    freq.put("\u0930\u0923\u093e", 516);
    freq.put("\u093e\u0924\u093f", 524);
    freq.put("\u093e\u0924\u093e", 4840);
    freq.put("\u093f\u0930\u094d", 2740);
    freq.put("\u0930\u093e\u092e", 1378);
    freq.put("\u096f", 4350);
    freq.put("\u092e\u093f\u0928", 2223);
    freq.put("\u091e ", 468);
    freq.put("\u0902\u0916\u094d", 1085);
    freq.put("\u0930\u0939 ", 1087);
    freq.put("\u091c\u0940 ", 1578);
    freq.put("\u0905\u0932\u0917", 451);
    freq.put("\u0926", 62970);
    freq.put("\u0909\u0938\u0947", 365);
    freq.put("\u0928\u094b", 2338);
    freq.put("\u0928\u094d", 16749);
    freq.put("\u0909\u092a\u0928", 475);
    freq.put("\u0928\u0940", 7183);
    freq.put("\u0928\u0941", 2801);
    freq.put("\u0928\u0947", 15948);
    freq.put("\u0909\u092a\u092f", 550);
    freq.put("\u0928\u0938", 1797);
    freq.put("\u0928\u0939", 1786);
    freq.put("\u0928\u093e", 16910);
    freq.put("\u0928\u093f", 11710);
    freq.put("\u0928\u0932", 477);
    freq.put("\u0928\u0930", 642);
    freq.put("\u0928\u0935", 1823);
    freq.put("\u0928\u092a", 443);
    freq.put("\u0928\u0928", 633);
    freq.put("\u0928\u092e", 981);
    freq.put("\u0928\u0926", 975);
    freq.put("\u0928\u0924", 1382);
    freq.put("\u0928\u091f", 1830);
    freq.put("\u0966", 5718);
    freq.put("\u0928\u0917", 1441);
    freq.put("\u0928\u0915", 3879);
    freq.put("\u0928\u0908", 683);
    freq.put(" \u0926\u0942", 1295);
    freq.put("\u0938\u0902\u0917", 1492);
    freq.put("\u0909\u0938\u0915", 842);
    freq.put(" \u0906\u0930", 1183);
    freq.put(" \u0906\u0935", 1052);
    freq.put("\u093e\u0930\u0915", 420);
    freq.put(" \u0906\u0938", 419);
    freq.put("\u0911", 695);
    freq.put("\u0947\u0930\u093f", 755);
    freq.put(" \u0906\u0924", 825);
    freq.put(" \u0906\u0927", 1052);
    freq.put(" \u0906\u0926", 1214);
    freq.put(" \u0906\u0928", 491);
    freq.put("\u0924\u093f ", 4868);
    freq.put(" \u0906\u092a", 1294);
    freq.put(" \u0906\u092f", 881);
    freq.put(" \u0906\u092e", 378);
    freq.put("\u093e\u0930\u093f", 1016);
    freq.put("\u093e\u0930\u093e", 6234);
    freq.put(" \u0906\u0915", 690);
    freq.put("\u093e\u0930\u0938", 394);
    freq.put("\u0905\u092e\u0947", 560);
    freq.put(" \u0906\u091c", 524);
    freq.put("\u0938\u0947 ", 20466);
    freq.put(" \u0906\u0902", 486);
    freq.put("\u0928\u093f ", 406);
    freq.put("\u093e\u0930\u0924", 7763);
    freq.put("\u091c\u0939\u093e", 441);
    freq.put("\u093e\u0930\u0923", 1386);
    freq.put("\u0938\u094d\u092e", 485);
    freq.put("\u0938\u094d\u092f", 682);
    freq.put("\u0938\u094d\u092a", 4184);
    freq.put("\u0938\u094d\u0924", 5132);
    freq.put("\u0938\u094d\u0925", 6865);
    freq.put("\u093e\u0930\u094d", 5244);
    freq.put("\u0938\u0939\u093e", 390);
    freq.put("\u093e\u0930\u094b", 922);
    freq.put("\u0938\u094d\u0935", 2405);
    freq.put("\u093e\u0930\u0947", 707);
    freq.put("\u093e\u0930\u0940", 1527);
    freq.put("\u0902\u0939 ", 485);
    freq.put("\u093e\u0930\u0942", 465);
    freq.put("\u0915\u0935\u093f", 783);
    freq.put("\u092f\u0915 ", 1025);
    freq.put("\u0938\u094d\u091f", 9331);
    freq.put("\u0938\u0938\u0947", 419);
    freq.put("\u0938\u094d\u0915", 2303);
    freq.put(" \u0967", 5155);
    freq.put(" \u0964", 6381);
    freq.put(" \u0968", 2506);
    freq.put("\u0915\u0947 ", 35060);
    freq.put("\u0932\u0947 ", 3374);
    freq.put("\u0910", 1181);
    freq.put("\u0925\u093e\u0964", 3059);
    freq.put("\u0948\u0964 ", 17713);
    freq.put(" \u0915\u0947", 32645);
    freq.put("\u0926\u0928 ", 568);
    freq.put(" \u0915\u0941", 2268);
    freq.put("\u0938\u0930\u0915", 1452);
    freq.put(" \u0921", 2225);
    freq.put(" \u0926", 21719);
    freq.put(" \u0927", 2884);
    freq.put(" \u0924", 12822);
    freq.put("\u0926\u093e ", 857);
    freq.put(" \u092a", 54146);
    freq.put(" \u092b", 4760);
    freq.put(" \u0928", 21169);
    freq.put(" \u092e", 54702);
    freq.put(" \u092f", 22634);
    freq.put(" \u092c", 23290);
    freq.put(" \u092d", 19961);
    freq.put(" \u0932", 14663);
    freq.put(" \u0930", 25548);
    freq.put(" \u0936", 12231);
    freq.put(" \u0935", 27670);
    freq.put("\u0925\u093e\u0928", 1787);
    freq.put(" \u0938", 78945);
    freq.put(" \u0939", 72412);
    freq.put("\u091f\u0928\u093e", 394);
    freq.put(" \u0906", 12686);
    freq.put(" \u0907", 19284);
    freq.put(" \u0905", 26917);
    freq.put(" \u090a", 806);
    freq.put(" \u0908", 1344);
    freq.put(" \u0909", 13706);
    freq.put(" \u090f", 21008);
    freq.put("\u0930\u0947\u0928", 3698);
    freq.put("\u092e\u0902\u0926", 933);
    freq.put(" \u0913", 938);
    freq.put(" \u0910", 1154);
    freq.put(" \u0911", 666);
    freq.put(" \u0916", 3003);
    freq.put(" \u0917", 13738);
    freq.put(" \u0914", 11821);
    freq.put(" \u0915", 119739);
    freq.put(" \u091a", 7337);
    freq.put(" \u091b", 3781);
    freq.put(" \u0918", 3397);
    freq.put("\u092e\u0902\u0924", 477);
    freq.put(" \u091f", 5844);
    freq.put(" \u091c", 31363);
    freq.put("\u0917\u0941\u0930", 518);
    freq.put("\u093f\u0928\u093e", 538);
    freq.put("\u093f\u0928\u093f", 795);
    freq.put("\u092f\u094b", 8068);
    freq.put("\u092f\u0947", 5448);
    freq.put("\u092f\u0942", 1784);
    freq.put("\u092f\u0941", 3494);
    freq.put("\u092f\u0940", 833);
    freq.put("\u092b\u094d\u0930", 464);
    freq.put("\u092f\u093e\u0902", 725);
    freq.put("\u092f\u093e\u0901", 525);
    freq.put("\u096a ", 778);
    freq.put("\u0967\u096f\u096d", 415);
    freq.put("\u0967\u096f\u096c", 420);
    freq.put("\u0967\u096f\u096f", 360);
    freq.put("\u093f\u0928\u091f", 1785);
    freq.put("\u094d\u0930 ", 7477);
    freq.put("\u0924\u0940\u092f", 3767);
    freq.put("\u092f\u093e\u0930", 471);
    freq.put("\u0942\u0930\u094d", 2859);
    freq.put("\u093e\u0928\u0947", 2242);
    freq.put("\u0924\u0940\u0928", 446);
    freq.put("\u092f\u093e\u092a", 561);
    freq.put("\u092f\u093e\u0928", 790);
    freq.put("\u092e\u0941\u0916", 2339);
    freq.put("\u092f\u093e\u092f", 535);
    freq.put(" \u0907\u0902", 1185);
    freq.put("\u093e\u091c\u094d", 2259);
    freq.put("\u092f\u093e\u0924", 2560);
    freq.put("\u0924\u0940\u0938", 449);
    freq.put("\u092f\u0940 ", 716);
    freq.put("\u092d\u0917\u0935", 386);
    freq.put("\u093e\u091c\u0938", 382);
    freq.put("\u092f\u0902", 862);
    freq.put("\u093e\u091c\u093f", 402);
    freq.put("\u093e\u091c\u093e", 802);
    freq.put("\u093f\u092f ", 463);
    freq.put("\u093e\u091c\u0927", 594);
    freq.put("\u093e\u091c\u0928", 843);
    freq.put("\u092f\u0915", 2875);
    freq.put("\u0935\u093e\u092f", 555);
    freq.put("\u092f\u092f", 399);
    freq.put("\u092f\u092e", 1479);
    freq.put("\u092f\u092a", 564);
    freq.put("\u092f\u0928", 1546);
    freq.put("\u092f\u0926", 785);
    freq.put("\u0926\u0941\u0930", 430);
    freq.put("\u092f\u0924", 1327);
    freq.put("\u0917\u092d\u0917", 596);
    freq.put("\u0935\u093e\u0932", 2753);
    freq.put("\u092f\u093f", 596);
    freq.put("\u092f\u093e", 29338);
    freq.put("\u0909\u0924\u094d", 2559);
    freq.put("\u092f\u0939", 10437);
    freq.put("\u094d\u092e ", 3545);
    freq.put("\u0948 ", 18248);
    freq.put("\u092f\u093e\u0964", 1162);
    freq.put("\u092f\u0930", 1126);
    freq.put("\u093f\u0935\u0947", 381);
    freq.put("\u0926\u0942 ", 610);
    freq.put("\u091c\u0928\u0940", 553);
    freq.put("\u091c\u0928\u094d", 1234);
    freq.put("\u091c\u092c ", 495);
    freq.put("\u0902\u091f\u0947", 1825);
    freq.put("\u092e\u093e\u0927", 371);
    freq.put("\u092f\u092e ", 869);
    freq.put("\u093e\u092f ", 1113);
    freq.put("\u093f\u0935\u093e", 1432);
    freq.put("\u093f\u0927\u093e", 871);
    freq.put("\u093f\u0935\u0930", 417);
    freq.put("\u0935\u093e\u092e", 390);
    freq.put("\u0930\u094b ", 378);
    freq.put("\u0926\u093f\u0932", 1253);
    freq.put("\u0930\u093e\u0902", 1067);
    freq.put("\u0930\u093e\u091a", 861);
    freq.put(" \u0915\u0908", 773);
    freq.put("\u0930\u093e\u091c", 5799);
    freq.put("\u091c\u094d\u091e", 2457);
    freq.put("\u0927 ", 3357);
    freq.put("\u0940\u0928 ", 2404);
    freq.put("\u0930\u093e\u0915", 432);
    freq.put("\u091c\u093e ", 1910);
    freq.put(" \u0915\u0902", 518);
    freq.put("\u0930\u093e\u0928", 1776);
    freq.put(" \u0915\u093e", 20292);
    freq.put(" \u0915\u093f", 9638);
    freq.put(" \u0915\u0939", 3125);
    freq.put("\u0930\u093e\u092f", 1077);
    freq.put("\u091c\u094d\u092f", 2693);
    freq.put("\u0941\u0906\u0964", 435);
    freq.put(" \u0915\u0935", 757);
    freq.put("\u0930\u093e\u0923", 691);
    freq.put(" \u0915\u0930", 8774);
    freq.put("\u0930\u093e\u0924", 590);
    freq.put(" \u0915\u0932", 965);
    freq.put("\u0930\u093e\u0938", 461);
    freq.put(" \u0915\u092e", 1021);
    freq.put(" \u0915\u0928", 365);
    freq.put(" \u092a\u0943", 1225);
    freq.put("\u0930\u093e\u0930", 802);
    freq.put("\u091f\u0915 ", 496);
    freq.put("\u0930\u093e\u0935", 460);
    freq.put("\u0930\u093e\u0937", 2127);
    freq.put(" \u0907\u0932", 428);
    freq.put("\u0947\u0937 ", 525);
    freq.put("\u092f\u0915\u094d", 1167);
    freq.put(" \u0907\u0938", 13352);
    freq.put(" \u0915\u094d", 4800);
    freq.put(" \u0907\u0924", 729);
    freq.put(" \u0915\u0948", 557);
    freq.put("\u091a\u0902", 451);
    freq.put(" \u0915\u094b", 14690);
    freq.put("\u0939\u0941\u0924", 957);
    freq.put("\u0901\u091a", 523);
    freq.put(" \u0915\u0940", 14772);
    freq.put("\u0915 ", 31192);
    freq.put(" \u0907\u0928", 2514);
    freq.put(" \u0915\u0943", 765);
    freq.put(" \u0938\u092d", 777);
    freq.put("\u0939\u0941\u090f", 951);
    freq.put("\u091f\u0940 ", 1658);
    freq.put("\u0939\u0941\u0908", 797);
    freq.put("\u0939\u0941\u0906", 1762);
    freq.put("\u0939\u0941\u0902", 1933);
    freq.put("\u0915\u0943\u0937", 566);
    freq.put("\u0935\u0928 ", 938);
    freq.put(" \u0938\u0902", 11345);
    freq.put("\u0940\u091a ", 562);
    freq.put(" \u092a\u094d", 19145);
    freq.put("\u0915\u0943\u0924", 1818);
    freq.put(" \u0938\u091f", 433);
    freq.put(" \u092a\u0948", 416);
    freq.put(" \u092a\u094b", 399);
    freq.put("\u093e\u0927\u094d", 419);
    freq.put("\u0947\u091c\u0940", 411);
    freq.put("\u0947\u0902\u091f", 533);
    freq.put(" \u092a\u0947", 601);
    freq.put(" \u092a\u0941", 2921);
    freq.put(" \u092a\u0940", 496);
    freq.put(" \u0938\u0915", 1827);
    freq.put(" \u092a\u0942", 2103);
    freq.put("\u0947\u0902\u0926", 417);
    freq.put(" \u0938\u0928", 1812);
    freq.put(" \u0938\u092e", 6692);
    freq.put("\u0924\u0925\u093e", 2577);
    freq.put(" \u0938\u092c", 1516);
    freq.put("\u0906\u0930\u094d", 522);
    freq.put(" \u0938\u0926", 698);
    freq.put(" \u0938\u0924", 571);
    freq.put(" \u0938\u0939", 892);
    freq.put(" \u0938\u093f", 2848);
    freq.put(" \u0938\u093e", 6452);
    freq.put(" \u0938\u0930", 2776);
    freq.put("\u093c", 11159);
    freq.put(" \u0938\u094b", 571);
    freq.put("\u0907\u0915", 606);
    freq.put(" \u0938\u094d", 16029);
    freq.put("\u0907\u091f", 387);
    freq.put(" \u0938\u0942", 1297);
    freq.put(" \u0938\u0941", 1695);
    freq.put(" \u0938\u0940", 1037);
    freq.put(" \u0938\u0947", 17371);
    freq.put("\u092b ", 1049);
    freq.put("\u0907\u0902", 1275);
    freq.put(" \u092a\u0902", 1035);
    freq.put(" \u092a\u093f", 711);
    freq.put(" \u092a\u093e", 4190);
    freq.put("\u0942 ", 2066);
    freq.put("\u0907\u0932", 681);
    freq.put(" \u092a\u0936", 1088);
    freq.put(" \u092a\u0930", 10662);
    freq.put("\u0907\u0938", 13512);
    freq.put("\u0907\u0924", 740);
    freq.put(" \u092a\u0924", 1117);
    freq.put(" \u092a\u0926", 1827);
    freq.put(" \u092a\u0921", 455);
    freq.put("\u0907\u0928", 2901);
    freq.put("\u0926\u093f ", 1483);
    freq.put("\u0926\u0930\u094d", 1109);
    freq.put("\u0902\u0921\u093f", 369);
    freq.put("\u0920 ", 1539);
    freq.put("\u0907\u0928 ", 809);
    freq.put("\u0927", 21789);
    freq.put("\u0917\u0940\u0924", 642);
    freq.put("\u094d\u092a\u094d", 3747);
    freq.put("\u094d\u0930\u0926", 1892);
    freq.put("\u092b\u093f\u0932", 452);
    freq.put("\u094d\u092a\u0928", 572);
    freq.put("\u0939\u093f\u0928", 1798);
    freq.put("\u0922\u093c", 1322);
    freq.put("\u094d\u092a\u093e", 591);
    freq.put("\u0939\u093f\u0924", 1670);
    freq.put("\u093e\u090f\u0901", 397);
    freq.put("\u092f\u0939\u093e", 1528);
    freq.put("\u0967", 6322);
    freq.put("\u092d\u0940 ", 4811);
    freq.put("\u0939\u093f\u0902", 1060);
    freq.put("\u0921 ", 6850);
    freq.put("\u0939\u093e\u0938", 1027);
    freq.put("\u093f\u092a\u0940", 396);
    freq.put("\u0939\u093e\u0935", 428);
    freq.put("\u0939\u093e\u0930", 1703);
    freq.put("\u0939\u093e\u0928", 874);
    freq.put("\u092e\u0947\u0932", 1950);
    freq.put("\u093f\u092e ", 1068);
    freq.put("\u0921\u093c\u093e", 1450);
    freq.put("\u092a\u0939\u0932", 1024);
    freq.put("\u092e\u0947\u0902", 27306);
    freq.put("\u0936\u0915\u094d", 405);
    freq.put("\u0927\u0928 ", 595);
    freq.put("\u093e\u0908 ", 2362);
    freq.put("\u091c\u0938\u094d", 392);
    freq.put("\u0939\u093e\u0902", 1185);
    freq.put("\u094b\u0921\u093c", 535);
    freq.put("\u0917\u092f\u093e", 3134);
    freq.put("\u0918\u0902", 1798);
    freq.put("\u0930\u092d\u093e", 427);
    freq.put("\u0935", 82288);
    freq.put("\u092a\u0939\u0941", 2050);
    freq.put("\u0921\u093c\u0947", 606);
    freq.put("\u0932\u093e ", 4369);
    freq.put("\u0921\u093c\u0940", 1222);
    freq.put("\u0925\u0947\u0964", 1504);
    freq.put("\u0925\u092e ", 523);
    freq.put("\u0935\u0939 ", 1195);
    freq.put("\u0926\u0947\u0935", 1125);
    freq.put("\u0926\u0947\u0936", 3481);
    freq.put("\u0902\u091c\u093e", 609);
    freq.put("\u0918\u093e", 478);
    freq.put("\u0948\u0964", 21739);
    freq.put("\u0918\u0930", 423);
    freq.put("\u0942\u0932 ", 705);
    freq.put("\u094d\u0925", 9797);
    freq.put("\u094d\u0924", 17955);
    freq.put("\u094d\u0927", 4156);
    freq.put("\u094d\u0926", 7520);
    freq.put("\u094d\u0921", 2149);
    freq.put("\u094d\u0920", 1556);
    freq.put("\u094d\u0923", 2398);
    freq.put("\u0942\u0930 ", 759);
    freq.put("\u094d\u092d", 823);
    freq.put("\u094d\u092c", 2118);
    freq.put("\u094d\u092f", 26066);
    freq.put("\u094d\u092e", 10658);
    freq.put("\u094d\u0928", 3593);
    freq.put("\u092b\u094d", 1074);
    freq.put("\u0909\u0928\u0915", 1565);
    freq.put("\u094d\u0935", 16523);
    freq.put("\u094d\u0937", 9849);
    freq.put("\u094d\u0936", 2596);
    freq.put("\u094d\u0930", 57172);
    freq.put("\u094d\u0932", 4149);
    freq.put("\u094d\u0939", 2245);
    freq.put("\u094d\u0938", 6797);
    freq.put("\u0938\u093e ", 1620);
    freq.put("\u091a", 24607);
    freq.put("\u0948\u091c", 408);
    freq.put(" \u0916\u0947", 428);
    freq.put("\u093f\u0938 ", 650);
    freq.put("\u094d\u0915", 4547);
    freq.put("\u094d\u0917", 2050);
    freq.put("\u094d\u091c", 1507);
    freq.put("\u094d\u091f", 15553);
    freq.put("\u094d\u091e", 2460);
    freq.put("\u094d\u0927\u093f", 463);
    freq.put("\u094d\u0927\u093e", 551);
    freq.put("\u094d\u091a", 2621);
    freq.put("\u094d\u0930\u094b", 1860);
    freq.put("\u0930\u093f\u091f", 356);
    freq.put("\u0909\u0928\u094d", 1250);
    freq.put("\u0940\u0964 ", 1157);
    freq.put("\u093f ", 14043);
    freq.put("\u093e\u092c ", 747);
    freq.put("\u0932\u093e", 9912);
    freq.put("\u0969", 1587);
    freq.put("\u0930\u093f\u0924", 976);
    freq.put("\u092b\u0932", 545);
    freq.put("\u0905\u0930\u094d", 1665);
    freq.put("\u0930\u093f\u0935", 843);
    freq.put("\u092b\u093f", 861);
    freq.put("\u092b\u093e", 687);
    freq.put("\u0968\u0966\u0966", 1298);
    freq.put(" \u0939\u0948", 50701);
    freq.put(" \u0939\u094b", 7690);
    freq.put(" \u0939\u0940", 2071);
    freq.put(" \u0939\u0941", 3748);
    freq.put("\u0947\u0936 ", 2529);
    freq.put("\u0935\u0924\u093e", 365);
    freq.put(" \u0939\u0947", 505);
    freq.put("\u092c\u0921\u093c", 987);
    freq.put("\u0948\u0902", 11503);
    freq.put("\u094d\u091f\u093f", 711);
    freq.put("\u0930\u0902\u092d", 445);
    freq.put("\u0905\u092d\u093f", 793);
    freq.put("\u094d\u091f\u0930", 764);
    freq.put("\u0936\u094d\u092f", 1102);
    freq.put("\u0930\u0902\u0917", 680);
    freq.put("\u0928", 137720);
    freq.put("\u0905\u0902\u0917", 1106);
    freq.put("\u093e\u0932 ", 3360);
    freq.put("\u0936\u094d\u0930", 1917);
    freq.put("\u092a\u0936\u094d", 999);
    freq.put("\u092e\u0942\u0939", 442);
    freq.put("\u096c ", 930);
    freq.put("\u0968", 3762);
    freq.put("\u094d\u091f\u0940", 634);
    freq.put("\u094d\u091f\u0947", 7603);
    freq.put("\u0935\u0947\u0926", 482);
    freq.put(" \u0939\u093e", 1189);
    freq.put(" \u0939\u093f", 3553);
    freq.put(" \u0939\u0930", 704);
    freq.put("\u0935\u0947\u0936", 377);
    freq.put("\u0932\u0917\u093e", 459);
    freq.put("\u092d\u093e ", 824);
    freq.put("\u091f\u0915", 827);
    freq.put("\u092b\u093c\u093f", 394);
    freq.put("\u0913", 3623);
    freq.put("\u094d\u092f\u094b", 1594);
    freq.put(" \u092b\u093f", 728);
    freq.put(" \u092b\u093c", 822);
    freq.put("\u091f\u093f", 1894);
    freq.put("\u091f\u093e", 1764);
    freq.put("\u0938\u0928 ", 1657);
    freq.put("\u091f\u0932", 396);
    freq.put("\u091f\u0930", 2646);
    freq.put(" \u0905\u0924", 780);
    freq.put("\u0909\u092a", 2592);
    freq.put("\u091f\u0928", 928);
    freq.put("\u091f\u0924", 1909);
    freq.put("\u094c\u0926", 469);
    freq.put("\u094c\u0924", 437);
    freq.put(" \u0905\u0927", 2196);
    freq.put("\u091f\u094d", 8239);
    freq.put("\u091f\u094b", 662);
    freq.put("\u094c\u0930", 1279);
    freq.put("\u091f\u0947", 10515);
    freq.put("\u091f\u0940", 2663);
    freq.put(" \u092b\u0947", 481);
    freq.put("\u0941\u0928\u093e", 530);
    freq.put(" \u092b\u094d", 403);
    freq.put("\u091a\u0947\u0928", 368);
    freq.put(" \u0905\u0938", 670);
    freq.put("\u094b ", 17876);
    freq.put("\u0935\u093f\u0927", 1382);
    freq.put("\u0935\u093f\u0926", 1842);
    freq.put("\u0935\u093f\u0924", 981);
    freq.put("\u0932\u094b\u0917", 827);
    freq.put("\u0935\u093f\u092d", 1112);
    freq.put("\u0935\u093f\u0937", 806);
    freq.put("\u0935\u093f\u0936", 2580);
    freq.put("\u0935\u093f\u0935", 625);
    freq.put(" \u0905\u0935", 2716);
    freq.put("\u0935\u093f\u0938", 375);
    freq.put("\u096d ", 816);
    freq.put(" \u0905\u0930", 2119);
    freq.put("\u092a", 89801);
    freq.put(" \u092a\u0939", 3539);
    freq.put("\u0938\u0915\u0947", 2127);
    freq.put("\u0938\u0915\u0940", 3365);
    freq.put(" \u0905\u0932", 1382);
    freq.put("\u0935\u093f\u0915", 1766);
    freq.put("\u0935\u093f\u091a", 389);
    freq.put("\u094c\u0930 ", 706);
    freq.put("\u0935\u093f\u091c", 1255);
    freq.put("\u092a\u0928\u0940", 874);
    freq.put("\u092a\u0928\u0947", 1546);
    freq.put("\u0939 ", 13867);
    freq.put("\u0938\u0915\u093e", 2827);
    freq.put("\u092a\u0928\u094d", 743);
    freq.put("\u094d\u0928\u093e", 572);
    freq.put("\u0924\u0947 ", 6248);
    freq.put("\u0926\u0932 ", 742);
    freq.put("\u0928\u093e\u0930", 680);
    freq.put("\u096a", 1437);
    freq.put("\u0941\u0932\u093e", 407);
    freq.put("\u0902\u092f\u0941", 368);
    freq.put("\u0917\u0930 ", 1575);
    freq.put("\u092e\u0940 ", 1758);
    freq.put("\u094d\u0926\u0940", 1870);
    freq.put("\u094d\u0926\u0942", 492);
    freq.put("\u0924\u094d\u0924", 3587);
    freq.put("\u094d\u0926\u0947", 907);
    freq.put("\u0924\u094d\u092a", 791);
    freq.put("\u094d\u0926\u094d", 869);
    freq.put("\u0924\u094d\u092e", 761);
    freq.put("\u0924\u094d\u092f", 2756);
    freq.put("\u0924\u094d\u0930", 11745);
    freq.put("\u0915", 215389);
    freq.put("\u0924\u094d\u0935", 1830);
    freq.put("\u0924\u094d\u0938", 696);
    freq.put("\u0923\u0941 ", 439);
    freq.put("\u092a\u0941\u0938", 378);
    freq.put("\u0917 ", 7730);
    freq.put("\u0941\u0916\u094d", 1068);
    freq.put("\u0923\u093e\u0932", 368);
    freq.put("\u0926\u0940 ", 4353);
    freq.put("\u093e\u0913\u0902", 1931);
    freq.put("\u0921\u0940 ", 506);
    freq.put("\u092a\u0941\u0930", 3647);
    freq.put("\u0930\u092e\u094d", 388);
    freq.put("\u093e\u0937\u094d", 2240);
    freq.put("\u0930\u092e\u0941", 1096);
    freq.put("\u094b\u0917 ", 2225);
    freq.put("\u0947\u0932\u0935", 3726);
    freq.put("\u0936\u094d\u091a", 1235);
    freq.put("\u0928\u0935\u0930", 402);
    freq.put("\u0914", 11975);
    freq.put("\u093e\u0936\u093f", 573);
    freq.put("\u0940\u092a ", 552);
    freq.put("\u0936\u0939\u0930", 1243);
    freq.put("\u0915\u0925\u093e", 387);
    freq.put("\u0932 ", 18408);
    freq.put("\u0939\u0940\u0902", 1893);
    freq.put("\u0928\u0947\u092a", 393);
    freq.put("\u094d\u091e\u093e", 1890);
    freq.put("\u0928\u0947\u0924", 472);
    freq.put("\u0928\u0947\u0915", 552);
    freq.put("\u0940\u091f\u0930", 673);
    freq.put("\u093e\u0925 ", 1651);
    freq.put("\u0930\u0915\u094d", 994);
    freq.put("\u0915\u0941\u0932", 589);
    freq.put("\u092c\u091c\u0947", 3647);
    freq.put("\u0915\u0941\u092e", 405);
    freq.put(" \u092c\u0947", 646);
    freq.put("\u0915\u0941\u091b", 880);
    freq.put(" \u0939\u092e", 409);
    freq.put(" \u092c\u0941", 605);
    freq.put(" \u092c\u0940", 1196);
    freq.put(" \u092c\u094d", 1174);
    freq.put(" \u092c\u094b", 710);
    freq.put("\u094b\u092e\u0940", 388);
    freq.put(" \u092c\u0948", 464);
    freq.put("\u0939\u0948 ", 18074);
    freq.put("\u0938\u092c\u0938", 1305);
    freq.put("\u093e\u0964 ", 4040);
    freq.put("\u0936\u0928 ", 10109);
    freq.put("\u093f", 139433);
    freq.put(" \u092c\u0926", 685);
    freq.put(" \u092c\u0921", 1101);
    freq.put(" \u092c\u0928", 2421);
    freq.put(" \u092c\u0932", 422);
    freq.put(" \u092c\u0930", 576);
    freq.put(" \u092c\u093f", 1259);
    freq.put(" \u092c\u093e", 3995);
    freq.put(" \u092c\u0939", 1547);
    freq.put(" \u092c\u0938", 477);
    freq.put("\u0928\u0924\u0947", 555);
    freq.put(" \u092c\u0902", 729);
    freq.put("\u0930\u0915\u093e", 3522);
    freq.put("\u0937\u0947\u0924", 2985);
    freq.put(" \u092c\u091c", 3787);
    freq.put("\u0915\u0947\u0928", 435);
    freq.put(" \u0926\u0941", 776);
    freq.put(" \u0926\u0940", 559);
    freq.put(" \u0926\u0943", 400);
    freq.put("\u094b\u0928\u094b", 409);
    freq.put(" \u0926\u0947", 3244);
    freq.put(" \u0926\u094b", 1318);
    freq.put(" \u0926\u094d", 5503);
    freq.put("\u093e\u0937\u093e", 2056);
    freq.put("\u094b\u0928\u0947", 1142);
    freq.put("\u0932\u0947\u0915", 881);
    freq.put("\u0932\u0947\u0916", 932);
    freq.put("\u0936", 41726);
    freq.put(" \u0926\u0915", 983);
    freq.put("\u0926\u093e\u092f", 435);
    freq.put("\u0926\u093e\u0928", 855);
    freq.put("\u0925\u093e ", 4899);
    freq.put("\u0926\u093e\u0930", 977);
    freq.put("\u093e\u0938\u093f", 587);
    freq.put(" \u0926\u0930", 820);
    freq.put("\u0930\u0947 ", 1761);
    freq.put(" \u0926\u093f", 4337);
    freq.put(" \u0926\u093e", 748);
    freq.put("\u0935\u0902 ", 2957);
    freq.put("\u092e\u0947\u0930", 842);
    freq.put("\u0916\u0928\u0947", 369);
    freq.put("\u091f\u0928 ", 357);
    freq.put("\u094d\u0930\u0902", 360);
    freq.put("\u094d\u092b ", 515);
    freq.put(" \u0917\u094b", 922);
    freq.put("\u094d\u0930\u0915", 2642);
    freq.put("\u0936\u093e\u0939", 383);
    freq.put("\u094d\u092e\u0940", 437);
    freq.put("\u094d\u0930\u091c", 367);
    freq.put("\u094d\u0930\u091a", 370);
    freq.put("\u0921", 21061);
    freq.put("\u094d\u0930\u0924", 2596);
    freq.put("\u094d\u0930\u0925", 561);
    freq.put("\u094d\u0930\u0923", 709);
    freq.put("\u0938\u091f\u0940", 407);
    freq.put("\u0924\u0940 ", 9089);
    freq.put("\u094d\u0930\u092e", 2375);
    freq.put("\u094d\u0930\u092f", 1925);
    freq.put("\u094d\u0930\u092d", 518);
    freq.put("\u094d\u0930\u092a", 384);
    freq.put("\u094d\u0930\u0936", 494);
    freq.put("\u093f\u092f\u0947", 2350);
    freq.put("\u094d\u0930\u0935", 977);
    freq.put("\u0921\u093e ", 698);
    freq.put("\u094d\u0930\u093e", 9061);
    freq.put("\u094d\u0930\u093f", 3453);
    freq.put("\u092f\u093e ", 17033);
    freq.put("\u094d\u0930\u0938", 1694);
    freq.put("\u094d\u0930\u0939", 1076);
    freq.put("\u094d\u0930\u0947", 9372);
    freq.put("\u094d\u0930\u0940", 4034);
    freq.put("\u093f\u092f\u093e", 10338);
    freq.put("\u092f\u0928 ", 960);
    freq.put("\u094d\u092e\u0915", 445);
    freq.put("\u094d\u0930\u0948", 386);
    freq.put("\u0948\u0915", 523);
    freq.put("\u093e\u091c ", 1013);
    freq.put("\u092d\u0917 ", 605);
    freq.put("\u0928\u091f ", 1785);
    freq.put("\u0923\u0940 ", 648);
    freq.put("\u093f\u092f\u092e", 677);
    freq.put("\u093f\u092f\u0928", 355);
    freq.put("\u0948\u0938", 1223);
    freq.put("\u094d\u092e\u093e", 2864);
    freq.put("\u094d\u092e\u093f", 1000);
    freq.put("\u0948\u0932", 1189);
    freq.put("\u092e\u0942\u0932", 727);
    freq.put("\u0948\u0930", 490);
    freq.put("\u092f ", 22189);
    freq.put("\u0948\u0928", 999);
    freq.put("\u0930\u0939\u0947", 489);
    freq.put("\u0948\u0926", 560);
    freq.put("\u0941\u0928\u093f", 743);
    freq.put("\u0948\u0924", 376);
    freq.put("\u093e\u092e\u093f", 517);
    freq.put("\u093e\u092e\u093e", 1032);
    freq.put("\u0930\u0939\u093e", 649);
    freq.put("\u091c\u0940\u0935", 1088);
    freq.put("\u0928\u093f\u0915", 2637);
    freq.put("\u0930\u0939\u0924", 499);
    freq.put("\u0920", 3871);
    freq.put("\u093e\u092e\u0915", 498);
    freq.put("\u0940\u0935\u0928", 532);
    freq.put("\u0943\u0924\u094d", 636);
    freq.put("\u0932\u094d\u0932", 1775);
    freq.put(" \u091c\u0941", 639);
    freq.put("\u0938\u0947\u0902", 450);
    freq.put("\u0909\u0938 ", 606);
    freq.put("\u0928 ", 42221);
    freq.put("\u0928\u094d\u0939", 2015);
    freq.put(" \u0910\u0938", 714);
    freq.put("\u0939\u093e\u0901", 938);
    freq.put("\u092c\u0938\u0947", 1366);
    freq.put("\u093e\u092e\u094d", 377);
    freq.put("\u0947\u0926 ", 371);
    freq.put("\u093e", 290518);
    freq.put("\u093e\u092e\u0940", 544);
    freq.put("\u0924\u093f\u0939", 787);
    freq.put("\u0924\u093f\u0930", 505);
    freq.put("\u0947\u0930 ", 787);
    freq.put("\u0924\u093f\u0928", 613);
    freq.put("\u0924\u093f\u092f", 1006);
    freq.put("\u094b\u0908 ", 492);
    freq.put(" \u0930\u091c", 470);
    freq.put("\u0928\u093f\u0935", 567);
    freq.put("\u0924\u093f\u091c", 375);
    freq.put("\u0924\u093f\u0915", 1335);
    freq.put("\u0928\u093f\u0927", 617);
    freq.put("\u0928\u093f\u0924", 1221);
    freq.put("\u0928\u093f\u092f", 1801);
    freq.put("\u092d\u093e\u0930", 7799);
    freq.put("\u0938\u0947\u0935", 720);
    freq.put("\u093e\u0930 ", 11273);
    freq.put("\u094b", 68898);
    freq.put("\u093f\u092d\u093e", 779);
    freq.put("\u0928\u0941\u0938", 1344);
    freq.put("\u0928\u094d\u0924", 2330);
    freq.put("\u0937\u094d\u092f", 501);
    freq.put("\u0916\u093e ", 869);
    freq.put("\u0937\u094d\u0923", 694);
    freq.put("\u0937\u094d\u0920", 1362);
    freq.put("\u0915\u0939\u0932", 373);
    freq.put("\u0937\u094d\u091f", 3181);
    freq.put("\u0938\u0947\u0928", 499);
    freq.put("\u0938\u0924\u094d", 357);
    freq.put("\u0915\u0939\u093e", 1242);
    freq.put("\u0915\u0939\u0924", 1259);
    freq.put(" \u0935\u093e", 3866);
    freq.put(" \u0935\u093f", 11396);
    freq.put(" \u0935\u0938", 497);
    freq.put(" \u0935\u0939", 1459);
    freq.put(" \u0935\u0930", 2508);
    freq.put("\u0935\u0902\u0936", 456);
    freq.put("\u0928\u0924\u093e", 441);
    freq.put("\u0922", 1924);
    freq.put("\u0947\u0902 ", 29625);
    freq.put("\u0935\u0936\u094d", 752);
    freq.put("\u0935\u094b\u0902", 401);
    freq.put("\u092d\u093f\u0928", 962);
    freq.put("\u0920\u0928", 369);
    freq.put("\u091f ", 6235);
    freq.put("\u0942\u091f", 2497);
    freq.put("\u0920\u093e", 568);
    freq.put("\u0942\u091a", 523);
    freq.put("\u0942\u0924", 791);
    freq.put("\u092a\u0921\u093c", 437);
    freq.put("\u094d\u0935\u0924", 875);
    freq.put("\u0942\u092c", 457);
    freq.put("\u0942\u092e", 650);
    freq.put("\u0942\u0928", 1187);
    freq.put("\u0942\u092a", 2981);
    freq.put(" \u0935\u094d", 2079);
    freq.put("\u0942\u0937", 1076);
    freq.put("\u0942\u0930", 5314);
    freq.put("\u093f\u090f ", 2584);
    freq.put("\u0942\u0932", 1317);
    freq.put("\u0947\u091c ", 388);
    freq.put(" \u0935\u0947", 1801);
    freq.put("\u0942\u0938", 930);
    freq.put("\u094d\u0924 ", 4240);
    freq.put(" \u0935\u0943", 367);
    freq.put("\u0926\u093f\u0924", 1005);
    freq.put("\u0928\u0938\u0902", 440);
    freq.put("\u0926\u093f\u092f", 1540);
    freq.put("\u0926\u093f\u0928", 569);
    freq.put("\u0926\u093f\u0936", 630);
    freq.put("\u0926\u093f\u0930", 1086);
    freq.put("\u0902\u0921 ", 1010);
    freq.put("\u0907\u0928\u0915", 960);
    freq.put(" \u0927\u0930", 1010);
    freq.put("\u092a\u093e\u0932", 950);
    freq.put(" \u0927\u093e", 800);
    freq.put("\u0917\u0940 ", 381);
    freq.put("\u093f\u091c\u094d", 1407);
    freq.put("\u093f\u0926\u094d", 3069);
    freq.put("\u094b\u0902", 15790);
    freq.put("\u0932\u092f ", 1619);
    freq.put("\u0926\u094d\u0935", 5706);
    freq.put("\u094d", 228350);
    freq.put("\u0926\u094d\u0930", 2473);
    freq.put("\u0926\u094d\u092e", 1046);
    freq.put("\u0926\u094d\u092f", 2403);
    freq.put("\u0926\u094d\u0926", 569);
    freq.put("\u0926\u094d\u0927", 2842);
    freq.put(" \u0927\u094d", 387);
    freq.put("\u0930\u094d\u091c", 853);
    freq.put("\u0928\u0926\u0940", 699);
    freq.put("\u0924\u0941 ", 1219);
    freq.put("\u0926\u0930 ", 576);
    freq.put("\u0907\u0928\u094d", 786);
    freq.put("\u092a\u0930 ", 7035);
    freq.put("\u092a\u092f\u094b", 528);
    freq.put("\u092f\u0939 ", 8676);
    freq.put("\u0927\u0930\u094d", 969);
    freq.put("\u0914\u0930", 11428);
    freq.put("\u092b\u0940", 943);
    freq.put("\u0930\u0928\u093e", 959);
    freq.put("\u092b\u0947", 662);
    freq.put("\u0926\u0942\u0930", 671);
    freq.put("\u0926\u0942\u0938", 592);
    freq.put("\u092b\u094b", 368);
    freq.put("\u092c\u0939\u0941", 1203);
    freq.put("\u0927\u0940 ", 490);
    freq.put("\u093e\u092f\u093e", 1613);
    freq.put("\u092c\u0902\u0927", 817);
    freq.put("\u0905\u0935\u0927", 1855);
    freq.put("\u094c", 4425);
    freq.put("\u093f\u0936 ", 406);
    freq.put("\u093e\u092f\u0928", 449);
    freq.put("\u094d\u092b", 981);
    freq.put("\u091c\u0928 ", 1003);
    freq.put("\u094d\u092a", 6879);
    freq.put("\u092e\u0930\u094d", 364);
    freq.put("\u0916\u0902\u0921", 407);
    freq.put("\u093e\u092f\u0915", 414);
    freq.put("\u0930\u0928\u0947", 2577);
    freq.put("\u093f\u0939\u093e", 1270);
    freq.put(" \u091f\u094d", 3950);
    freq.put("\u093e\u0939 ", 929);
    freq.put("\u0927\u0930", 1283);
    freq.put("\u0927\u093f", 5621);
    freq.put("\u0927\u093e", 4715);
    freq.put("\u091c\u093e\u0930", 493);
    freq.put("\u091c\u093e\u092c", 559);
    freq.put("\u092a\u0943\u0937", 917);
    freq.put("\u091c\u093e\u0928", 2165);
    freq.put("\u091c\u093e\u0924", 5721);
    freq.put("\u0927\u0928", 912);
    freq.put("\u093e\u0923 ", 964);
    freq.put("\u0949\u0930", 357);
    freq.put("\u0949\u0932", 485);
    freq.put("\u0915\u094d", 22746);
    freq.put("\u0949\u0928", 366);
    freq.put("\u0915\u0949", 440);
    freq.put("\u0915\u0948", 618);
    freq.put("\u0937", 22409);
    freq.put("\u0915\u0947", 37285);
    freq.put("\u0915\u0941", 3003);
    freq.put("\u0915\u0940", 20919);
    freq.put("\u0915\u0943", 2446);
    freq.put("\u0915\u0942", 402);
    freq.put("\u091f\u0940\u0915", 471);
    freq.put("\u0915\u093f", 12948);
    freq.put("\u0915\u093e", 35945);
    freq.put("\u0915\u0939", 3138);
    freq.put("\u0915\u0938", 766);
    freq.put("\u0928\u092e\u0947", 432);
    freq.put("\u0915\u0935", 956);
    freq.put("\u0915\u0930", 12591);
    freq.put("\u0915\u0932", 2049);
    freq.put("\u0915\u092e", 1276);
    freq.put("\u0915\u0928", 1065);
    freq.put("\u0915\u092a", 515);
    freq.put("\u0915\u0925", 448);
    freq.put("\u0915\u0924", 2310);
    freq.put("\u0941\u0902\u091a", 1928);
    freq.put("\u0915\u0921", 382);
    freq.put("\u0939\u094d\u092e", 356);
    freq.put("\u0901 ", 2207);
    freq.put("\u0915\u091f", 630);
    freq.put("\u0943\u0924\u093f", 1045);
    freq.put("\u0941\u0902\u092c", 372);
    freq.put("\u093f\u0938\u092e", 787);
    freq.put("\u092c\u094d\u0930", 1124);
    freq.put("\u0915\u0908", 777);
    freq.put("\u0927\u0941", 599);
    freq.put("\u0927\u0940", 935);
    freq.put("\u0927\u094d", 2713);
    freq.put("\u0915\u0902", 723);
    freq.put("\u0947\u0936\u0928", 8153);
    freq.put("\u094d\u091f ", 1436);
    freq.put("\u093f\u092f\u094b", 3134);
    freq.put("\u0913\u0902 ", 2427);
    freq.put("\u093e\u0932\u093f", 2288);
    freq.put("\u091b\u0942\u091f", 1815);
    freq.put("\u091c\u093f\u0924", 402);
    freq.put("\u091c\u093f\u0928", 942);
    freq.put("\u0948\u0902\u0921", 368);
    freq.put(" \u0964 ", 3304);
    freq.put("\u091c\u093f\u0932", 1663);
    freq.put("\u093e\u0932\u092f", 1677);
    freq.put("\u091c\u093f\u0938", 3147);
    freq.put("\u091f\u094d\u0930", 7028);
    freq.put("\u0930\u0938\u094d", 963);
    freq.put("\u0935\u0927\u093f", 1770);
    freq.put("\u092c\u0926\u0932", 617);
    freq.put("\u093e\u0932\u0940", 1852);
    freq.put("\u093e\u0932\u0947", 1192);
    freq.put("\u0966\u0966 ", 579);
    freq.put("\u0932\u0917 ", 468);
    freq.put("\u0947\u0936\u094b", 391);
    freq.put("\u0947\u0936\u094d", 531);
    freq.put("\u0948\u0902\u0964", 6253);
    freq.put("\u0935\u0947 ", 5027);
    freq.put("\u091f\u094d\u091f", 617);
    freq.put("\u092c\u094d\u0926", 1896);
    freq.put("\u093f\u0928 ", 1347);
    freq.put("\u092e\u093e ", 1358);
    freq.put("\u0938\u092a", 658);
    freq.put("\u0938\u0928", 2988);
    freq.put("\u0938\u092e", 9143);
    freq.put("\u0938\u092c", 1580);
    freq.put("\u0938\u092d", 1408);
    freq.put("\u094c\u0926\u094d", 366);
    freq.put("\u0938\u0926", 867);
    freq.put("\u0938\u0924", 766);
    freq.put("\u0938\u0938", 498);
    freq.put("\u0938\u0939", 931);
    freq.put("\u0938\u093e", 11391);
    freq.put("\u0938\u093f", 5630);
    freq.put(" \u0928\u094d", 487);
    freq.put("\u0938\u0932", 818);
    freq.put("\u0938\u0930", 4398);
    freq.put(" \u0928\u0940", 536);
    freq.put(" \u0928\u0947", 3413);
    freq.put("\u092d\u093e\u0935", 792);
    freq.put("\u0938\u0935", 526);
    freq.put("\u0932\u0940 ", 4841);
    freq.put("\u0935\u0932 ", 387);
    freq.put(" \u0936\u0924", 617);
    freq.put("\u0938\u0902", 12512);
    freq.put(" \u0936\u092c", 1343);
    freq.put(" \u0936\u0930", 525);
    freq.put("\u0938\u091f", 463);
    freq.put("\u0939", 118206);
    freq.put("\u0947\u091f ", 613);
    freq.put(" \u0936\u093f", 1818);
    freq.put("\u0938\u0915", 10544);
    freq.put(" \u0936\u0941", 774);
    freq.put(" \u0936\u094d", 1605);
    freq.put("\u0938\u0928\u094d", 672);
    freq.put("\u0938\u094b", 953);
    freq.put("\u0938\u0948", 435);
    freq.put(" \u0928\u093f", 5215);
    freq.put(" \u0928\u093e", 4741);
    freq.put("\u0938\u094d", 33294);
    freq.put("\u096e ", 811);
    freq.put("\u0938\u0940", 5308);
    freq.put("\u0938\u0941", 1954);
    freq.put("\u0938\u0947", 22788);
    freq.put(" \u0928\u0935", 592);
    freq.put("\u0948\u0902 ", 4429);
    freq.put(" \u0928\u0926", 808);
    freq.put("\u093f\u092e\u093e", 800);
    freq.put("\u0921\u0932", 514);
    freq.put("\u0925\u0947 ", 819);
    freq.put("\u0939\u093e ", 1528);
    freq.put("\u0921\u093c", 5317);
    freq.put("\u0921\u093f", 2023);
    freq.put("\u0921\u093e", 1474);
    freq.put("\u094b\u0921 ", 4034);
    freq.put("\u0938", 149246);
    freq.put(" \u0916\u093e", 713);
    freq.put("\u092e\u0943\u0924", 432);
    freq.put("\u0921\u093c ", 675);
    freq.put("\u0947\u092a\u093e", 393);
    freq.put("\u0938\u0902\u0938", 2227);
    freq.put("\u0930\u093f\u092f", 2208);
    freq.put("\u0932\u093e\u0932", 465);
    freq.put("\u0921\u0932 ", 378);
    freq.put("\u0938\u0902\u092c", 719);
    freq.put("\u0938\u0902\u092f", 444);
    freq.put("\u0930\u093f\u0915", 2624);
    freq.put("\u0938\u0902\u092a", 1355);
    freq.put("\u0932\u093e\u0924", 527);
    freq.put("\u0921\u0941", 358);
    freq.put("\u0921\u0940", 831);
    freq.put("\u0938\u0902\u0918", 401);
    freq.put("\u0921\u0947", 781);
    freq.put("\u0938\u0902\u091a", 2031);
    freq.put("\u0938\u0902\u0915", 898);
    freq.put("\u0930\u094d\u0936", 1019);
    freq.put("\u0921\u094b", 499);
    freq.put("\u0938\u0902\u0916", 1034);
    freq.put("\u0921\u094d", 669);
    freq.put("\u0932\u093e\u0915", 373);
    freq.put("\u0909\u0926\u094d", 651);
    freq.put("\u093f\u092e\u0940", 551);
    freq.put("\u094d ", 2686);
    freq.put(" \u092e\u0928", 1109);
    freq.put("\u092e\u0927\u094d", 813);
    freq.put("\u093e\u092c\u094d", 555);
    freq.put("\u093f\u0938\u0915", 1052);
    freq.put("\u0947\u0924\u094d", 3123);
    freq.put("\u0923", 16159);
    freq.put("\u094d\u0927 ", 2352);
    freq.put("\u0937\u0923 ", 1678);
    freq.put("\u0941\u0913\u0902", 451);
    freq.put("\u092b\u0930", 388);
    freq.put("\u0909\u0928 ", 374);
    freq.put("\u093f\u0938\u094d", 2756);
    freq.put("\u093f\u0939", 1477);
    freq.put("\u093f\u0938", 8212);
    freq.put("\u093f\u0937", 1899);
    freq.put("\u093f\u0936", 4603);
    freq.put("\u093f\u0935", 3402);
    freq.put("\u093f\u0938\u0947", 557);
    freq.put("\u093f\u0938\u0940", 1508);
    freq.put("\u093f\u0932", 8308);
    freq.put("\u093f\u0930", 6200);
    freq.put("\u093f\u092f", 18344);
    freq.put("\u093f\u092e", 3142);
    freq.put("\u093f\u092d", 1498);
    freq.put("\u093f\u092c", 505);
    freq.put("\u093f\u092a", 1804);
    freq.put("\u093f\u0928", 9694);
    freq.put("\u093f\u0927", 2081);
    freq.put("\u093f\u0926", 3772);
    freq.put("\u093f\u0924", 17874);
    freq.put("\u093f\u0923", 1209);
    freq.put("\u093f\u091f", 1437);
    freq.put("\u0938\u092e\u0941", 515);
    freq.put("\u093f\u091c", 2534);
    freq.put("\u093f\u091a", 656);
    freq.put("\u093f\u0917", 560);
    freq.put("\u093f\u0916", 1296);
    freq.put("\u093f\u0915", 17099);
    freq.put("\u092a\u0902\u091c", 567);
    freq.put("\u0947\u0924\u093e", 622);
    freq.put("\u093f\u090f", 2749);
    freq.put("\u092b\u093c", 1678);
    freq.put("\u093f\u0902", 3492);
    freq.put("\u093e\u092c\u093e", 770);
    freq.put("\u0932\u0915", 1497);
    freq.put("\u0932\u0917", 2035);
    freq.put("\u0928\u0935 ", 411);
    freq.put("\u0938\u092e\u0947", 1977);
    freq.put("\u093e\u0936 ", 423);
    freq.put("\u0910\u0938", 714);
    freq.put("\u0932\u0902", 804);
    freq.put(" \u0908 ", 361);
    freq.put("\u094b\u0917\u093f", 441);
    freq.put("\u0932\u0935", 4226);
    freq.put(" \u0913\u0930", 436);
    freq.put("\u0932\u093f", 10617);
    freq.put("\u0932\u0924", 1279);
    freq.put("\u0932\u092c", 457);
    freq.put("\u0932\u092e", 734);
    freq.put("\u0932\u092f", 1888);
    freq.put("\u0932\u0928", 1624);
    freq.put("\u092c\u0930 ", 1142);
    freq.put(" \u0905\u092c", 411);
    freq.put(" \u0905\u092d", 1046);
    freq.put(" \u0905\u092e", 1263);
    freq.put(" \u0905\u0928", 4720);
    freq.put(" \u0905\u092a", 3085);
    freq.put("\u094d\u091e ", 468);
    freq.put(" \u0905\u0925", 432);
    freq.put("\u0917\u0930", 2860);
    freq.put("\u092d\u093e\u0917", 1261);
    freq.put("\u0932\u0947", 6664);
    freq.put("\u0932\u0940", 6031);
    freq.put("\u0932\u0941", 426);
    freq.put("\u093e\u091f\u0915", 402);
    freq.put("\u0932\u094d", 5184);
    freq.put("\u0932\u0948", 601);
    freq.put("\u0928\u0947 ", 12971);
    freq.put("\u0932\u094b", 3980);
    freq.put("\u0939\u0940 ", 2790);
    freq.put("\u094b\u0917\u094b", 559);
    freq.put("\u0942\u091f\u0924", 1807);
    freq.put(" \u0905\u0902", 2469);
    freq.put(" \u0905\u0915", 778);
    freq.put(" \u0905\u0917", 573);
    freq.put(" \u092e\u0902", 1754);
    freq.put("\u0936\u0940 ", 479);
    freq.put("\u093f\u0902\u0939", 577);
    freq.put("\u0924\u0924\u094d", 438);
    freq.put("\u093f\u0902\u0926", 1176);
    freq.put("\u0925", 26984);
    freq.put("\u093f\u0902\u0917", 982);
    freq.put(" \u0935\u0948", 880);
    freq.put("\u0905\u0902", 2476);
    freq.put(" \u0935\u0940", 554);
    freq.put("\u0930\u0915 ", 417);
    freq.put("\u0942\u0939", 483);
    freq.put("\u094b\u0921", 4892);
    freq.put("\u0935\u093f ", 440);
    freq.put("\u094b\u0927", 664);
    freq.put("\u094b\u0926", 429);
    freq.put("\u092c\u0902\u0917", 529);
    freq.put("\u094b\u0924", 5502);
    freq.put("\u094b\u092a", 971);
    freq.put("\u094b\u0928", 2390);
    freq.put("\u094b\u092e", 1176);
    freq.put("\u0964 ", 33428);
    freq.put("\u094b\u092c", 410);
    freq.put("\u094b\u0932", 2394);
    freq.put("\u094b\u0930", 2026);
    freq.put("\u094b\u0937", 453);
    freq.put("\u094b\u0936", 547);
    freq.put("\u094b\u0935", 518);
    freq.put("\u0925\u093f\u0924", 2566);
    freq.put("\u094b\u0939", 815);
    freq.put("\u094b\u0938", 741);
    freq.put("\u0939\u0948", 50827);
    freq.put("\u0939\u094b", 8889);
    freq.put("\u0939\u094d", 694);
    freq.put("\u0924", 129370);
    freq.put("\u0924\u093e\u0928", 1545);
    freq.put("\u0939\u0941", 7130);
    freq.put("\u0939\u0940", 5060);
    freq.put("\u094b\u0908", 504);
    freq.put("\u0939\u0947", 2158);
    freq.put("\u094b\u0917", 4303);
    freq.put("\u094b\u0915", 1863);
    freq.put("\u094b\u091a", 771);
    freq.put("\u094b\u091f", 1429);
    freq.put("\u094b\u091c", 1283);
    freq.put("\u092f\u093f\u0915", 384);
    freq.put("\u0939\u0928", 827);
    freq.put("\u092e\u0940\u091f", 638);
    freq.put("\u092f\u0942\u0928", 379);
    freq.put("\u0939\u092e", 833);
    freq.put("\u094d\u092c\u0928", 468);
    freq.put("\u0924\u0930 ", 1819);
    freq.put("\u0939\u0924", 2956);
    freq.put("\u094d\u0928 ", 1500);
    freq.put("\u0939\u0938", 476);
    freq.put("\u0939\u093f", 5996);
    freq.put("\u0939\u093e", 10508);
    freq.put("\u0939\u0930", 3284);
    freq.put("\u0939\u0932", 1812);
    freq.put("\u0939\u0935", 548);
    freq.put("\u0936\u094d\u0935", 2006);
    freq.put("\u0964", 45019);
    freq.put("\u0941\u0932 ", 595);
    freq.put("\u092f\u0942\u091f", 437);
    freq.put(" \u0932\u094b", 1934);
    freq.put("\u0921\u093f\u092f", 1027);
    freq.put("\u0941\u092e\u093e", 600);
    freq.put("\u0924\u094d ", 405);
    freq.put("\u0917\u0902", 513);
    freq.put("\u0915\u0908 ", 776);
    freq.put("\u0917\u090f", 383);
    freq.put("\u0917\u0922\u093c", 657);
    freq.put("\u090f", 27071);
    freq.put("\u0917\u0908", 554);
    freq.put("\u0932\u093f\u092a", 379);
    freq.put("\u0939\u094b ", 1330);
    freq.put("\u092e\u093f\u0932", 1800);
    freq.put("\u0932\u093f\u092f", 3022);
    freq.put("\u0930\u092e ", 841);
    freq.put("\u0932\u093f\u0924", 2228);
    freq.put("\u0917\u0926", 372);
    freq.put("\u0917\u0924", 1406);
    freq.put("\u0917\u0923", 767);
    freq.put("\u0917\u0922", 741);
    freq.put("\u0923\u093e ", 355);
    freq.put("\u0917\u0920", 414);
    freq.put("\u0917\u092f", 3634);
    freq.put("\u0917\u092e", 494);
    freq.put("\u0917\u092d", 616);
    freq.put("\u0932\u093f\u0915", 529);
    freq.put("\u0932\u093f\u0916", 696);
    freq.put("\u0917\u0935", 557);
    freq.put("\u0917\u0932", 1055);
    freq.put("\u0948", 59521);
    freq.put("\u0917\u093f", 1175);
    freq.put("\u0917\u093e", 3720);
    freq.put(" \u0932\u093f", 5639);
    freq.put("\u0917\u0939", 412);
    freq.put("\u0917\u0947", 620);
    freq.put(" \u0932\u093e", 1268);
    freq.put("\u0917\u0941", 1958);
    freq.put("\u0917\u0940", 1381);
    freq.put("\u0917\u094d", 4970);
    freq.put("\u0917\u094b", 2483);
    freq.put("\u0917\u0948", 364);
    freq.put("\u092e\u093f\u0924", 732);
    freq.put("\u0966\u0966", 2062);
    freq.put("\u0905\u0915", 781);
    freq.put("\u0905\u0917", 575);
    freq.put("\u0941\u0916 ", 1161);
    freq.put("\u0905\u092d", 1051);
    freq.put("\u0905\u092c", 415);
    freq.put("\u0905\u092e", 1289);
    freq.put("\u0905\u0928", 4741);
    freq.put("\u0905\u092a", 3105);
    freq.put("\u0905\u0925", 432);
    freq.put("\u0905\u0924", 785);
    freq.put("\u0905\u0927", 2198);
    freq.put("\u0905\u0938", 694);
    freq.put("\u0905\u0935", 2719);
    freq.put("\u0905\u0930", 2196);
    freq.put("\u0905\u0932", 1444);
  }
  
}

