package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class HE extends CLangProfile {
  private static final String name = "he";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public HE() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 7414842;
    n_words[1] = 8743276;
    n_words[2] = 5934016;

    freq.put("\u05d9\u05ea ", 68847);
    freq.put("\u05d3\u05d5 ", 2707);
    freq.put("\u05d5\u05dd ", 16021);
    freq.put("\u05d3\u05e8 ", 2321);
    freq.put("\u05e7\u05e6", 3292);
    freq.put("\u05e7\u05e4", 1285);
    freq.put("\u05e7\u05e2", 1184);
    freq.put("\u05e7\u05e1", 4328);
    freq.put("\u05e7\u05e0", 4930);
    freq.put("\u05d5\u05ea\u05e8", 5363);
    freq.put("\u05e7\u05ea", 4771);
    freq.put("\u05e7\u05e9", 3566);
    freq.put("\u05e7\u05e8", 20408);
    freq.put("\u05e7\u05d5", 31546);
    freq.put("\u05e7\u05d4", 11443);
    freq.put("\u05e7\u05d3", 4923);
    freq.put("\u05e7\u05d1", 8684);
    freq.put("\u05e7\u05d0", 6360);
    freq.put("\u05e7\u05df", 2101);
    freq.put("\u05e7\u05de", 2688);
    freq.put("\u05e7\u05dd", 1371);
    freq.put("\u05e7\u05dc", 7255);
    freq.put("\u05e7\u05d8\u05e8", 975);
    freq.put("\u05e7\u05d9", 22013);
    freq.put("\u05e7\u05d8", 8069);
    freq.put("\u05e0\u05d9\u05ea", 14496);
    freq.put("\u05db\u05dc\u05dc", 3229);
    freq.put("\u0644", 1891);
    freq.put("\u05e0\u05d9\u05e1", 1942);
    freq.put("\u05e0\u05d9\u05e7", 1685);
    freq.put("\u05d9", 838057);
    freq.put("\u05d8\u05db\u05e0", 772);
    freq.put("\u05e4\u05d1\u05e8", 1306);
    freq.put("\u05e8\u05d2\u05e0", 814);
    freq.put("\u05e8\u05d2\u05dc", 1905);
    freq.put("\u05e8\u05d2\u05d9", 1770);
    freq.put("\u05e7\u05d8\u05d5", 2534);
    freq.put("\u05e8\u05d2\u05d5", 2907);
    freq.put("\u05d9\u05d1 ", 3393);
    freq.put("\u05e0\u05d9\u05d9", 6008);
    freq.put("\u05e0\u05d9\u05dd", 13661);
    freq.put("\u05e0\u05d9\u05de", 1196);
    freq.put("\u05e0\u05d9\u05d1", 1798);
    freq.put("\u05e0\u05d9\u05d4", 4469);
    freq.put("\u05e0\u05d9\u05d5", 3890);
    freq.put("\u05de\u05d2\u05d3", 820);
    freq.put(" \u05dc ", 2779);
    freq.put("\u05de\u05d2\u05d5", 862);
    freq.put("\u05e6\u05dc\u05d9", 914);
    freq.put(" \u05ea\u05db", 774);
    freq.put("\u05d6\u05d5\u05e8", 3460);
    freq.put("\u05e1\u05e7 ", 1452);
    freq.put("\u05d7\u05e1\u05d9", 1544);
    freq.put(" \u05d0\u05d3", 3113);
    freq.put(" \u05d0\u05d2", 950);
    freq.put(" \u05d0\u05d1", 4176);
    freq.put(" \u05d0\u05d7", 7629);
    freq.put(" \u05d0\u05d6", 1939);
    freq.put(" \u05d0\u05d5", 23084);
    freq.put("\u05db\u05d9\u05dc", 789);
    freq.put(" \u05d0\u05da", 1639);
    freq.put(" \u05d0\u05d9", 11144);
    freq.put(" \u05d0\u05de", 5812);
    freq.put(" \u05d0\u05dd", 984);
    freq.put(" \u05d0\u05dc", 10175);
    freq.put("\u05d5\u05e9\u05d1", 1741);
    freq.put("\u05d5\u05e9\u05d0", 1174);
    freq.put("\u05d5\u05e9\u05d2", 868);
    freq.put("\u05d5\u05e9\u05d5", 851);
    freq.put("\u05d5\u05e9\u05d4", 1203);
    freq.put("\u05d5\u05e9\u05d9", 1977);
    freq.put("\u05d5\u05e9\u05dc", 2823);
    freq.put("k", 3209);
    freq.put("ne ", 883);
    freq.put("\u05d7\u05d3\u05e9", 1272);
    freq.put(" \u05d0\u05e1", 1813);
    freq.put(" \u05d0\u05e0", 6385);
    freq.put(" \u05d0\u05e7", 1199);
    freq.put(" \u05d0\u05e6", 767);
    freq.put(" \u05d0\u05e4", 2121);
    freq.put("\u05e9\u05de\u05d4", 1020);
    freq.put(" \u05d0\u05ea", 12538);
    freq.put(" \u05d0\u05e9", 4957);
    freq.put(" \u05d0\u05e8", 6566);
    freq.put("\u05e9\u05de\u05d0", 2250);
    freq.put("\u05d8\u05d7 ", 798);
    freq.put("\u05d9\u05d7\u05d5", 1331);
    freq.put("\u05e1\u05dc\u05d5", 858);
    freq.put("\u05e2 ", 17848);
    freq.put("\u05e0\u05d7 ", 1477);
    freq.put("\u05d9\u05d7\u05d9", 2092);
    freq.put("\u05d8\u05d9 ", 5165);
    freq.put("\u05d1\u05e1\u05e4", 2568);
    freq.put("\u05d2\u05e0\u05d5", 1314);
    freq.put("\u05e4\u05e8\u05d9", 7391);
    freq.put("\u05e4\u05e8\u05d8", 1640);
    freq.put("\u05d2\u05e0\u05d9", 1049);
    freq.put("\u05e4\u05e8\u05d5", 4724);
    freq.put("\u05e8\u05d0 ", 2013);
    freq.put("\u05e4\u05e8\u05d3", 2122);
    freq.put("\u05d7\u05d1 ", 1144);
    freq.put("\u05d1\u05e1\u05d5", 1238);
    freq.put("\u05d4\u05d4 ", 812);
    freq.put("m ", 1750);
    freq.put("\u05e4\u05e8\u05e9", 1302);
    freq.put("\u05e4\u05e8\u05e7", 1005);
    freq.put("\u05d5\u05e4\u05d5", 2815);
    freq.put("\u05d1\u05e1\u05d9", 1809);
    freq.put("\u05e4\u05e8\u05e1", 3792);
    freq.put("\u05e4\u05e8\u05e0", 1094);
    freq.put("er ", 2469);
    freq.put("\u05d9\u05d7\u05e1", 2243);
    freq.put("\u05ea\u05dc", 3463);
    freq.put("\u05d5\u05e4\u05d9", 5387);
    freq.put("\u05d1\u05d3\u05e6", 1243);
    freq.put("\u05ea\u05d4\u05dc", 1012);
    freq.put("\u05dc\u05da ", 2677);
    freq.put("\u05d1\u05d3\u05e8", 2390);
    freq.put("\u05e2\u05dc ", 22307);
    freq.put("\u05d5\u05db\u05e0", 2823);
    freq.put(" \u05de\u05e9", 13103);
    freq.put(" \u05de\u05e8", 5197);
    freq.put(" \u05de\u05ea", 7226);
    freq.put("V", 1278);
    freq.put(" \u05de\u05e1", 7731);
    freq.put(" \u05de\u05e0", 4010);
    freq.put(" \u05de\u05e2", 6426);
    freq.put(" \u05de\u05e4", 3253);
    freq.put(" \u05de\u05e7", 5213);
    freq.put(" \u05de\u05e6", 3521);
    freq.put(" \u05de\u05d9", 10487);
    freq.put(" \u05de\u05d8", 3237);
    freq.put(" \u05de\u05db", 3995);
    freq.put("\u05e8\u05db\u05d1", 1910);
    freq.put("ma", 1706);
    freq.put(" \u05de\u05dc", 5214);
    freq.put(" \u05de\u05df", 1074);
    freq.put(" \u05de\u05de", 8626);
    freq.put(" \u05de\u05d1", 4174);
    freq.put(" \u05de\u05d0", 7744);
    freq.put("mo", 751);
    freq.put(" \u05de\u05d2", 2553);
    freq.put(" \u05de\u05d5", 15023);
    freq.put(" \u05de\u05d4", 5964);
    freq.put(" \u05de\u05d7", 5968);
    freq.put(" \u05de\u05d6", 2002);
    freq.put("\u05d5\u05db\u05df", 1385);
    freq.put("\u05d5\u05db\u05dc", 1110);
    freq.put("\u05d1\u05d3\u05d5", 915);
    freq.put("\u05d1\u05d3\u05d9", 2083);
    freq.put("\u05e8\u05db\u05d5", 1721);
    freq.put("\u05d5\u05db\u05d1", 1408);
    freq.put("\u05de\u05e8\u05d5", 1617);
    freq.put("\u05de\u05e8\u05d7", 1042);
    freq.put("\u05ea", 390314);
    freq.put("\u05d4\u05e2\u05dc", 1178);
    freq.put("\u05d4\u05e2\u05d1", 1724);
    freq.put("\u05e9\u05d1\u05ea", 1116);
    freq.put("\u05de\u05e8\u05d9", 5941);
    freq.put("\u05de\u05e8\u05db", 2955);
    freq.put("\u05d9\u05d1\u05d5", 5867);
    freq.put("\u05d9\u05e1\u05e8", 789);
    freq.put("\u05d9\u05d8\u05e0", 845);
    freq.put("\u05ea\u05d5 ", 7307);
    freq.put("\u05d9\u05e1\u05d9", 1267);
    freq.put("\u05d9\u05e1\u05d8", 5187);
    freq.put("\u05d9\u05e1\u05d5", 2347);
    freq.put("\u05d9\u05e1\u05d4", 750);
    freq.put("\u05d9\u05e1\u05d3", 879);
    freq.put("\u05e8\u05d2 ", 1850);
    freq.put("\u05de\u05e8\u05e5", 1409);
    freq.put("\u05d4\u05e2\u05e8", 1024);
    freq.put("\u05d4\u05e2\u05ea", 967);
    freq.put("ent", 903);
    freq.put("\u05dc\u05d9\u05d0", 1164);
    freq.put("\u05e9\u05d1\u05e2", 790);
    freq.put("\u05de\u05e8\u05ea", 774);
    freq.put("A", 5600);
    freq.put("\u0645", 1083);
    freq.put("\u05ea\u05e0\u05d5", 2011);
    freq.put("\u05ea\u05e0\u05d4", 885);
    freq.put("\u05d4\u05d0\u05d7", 1546);
    freq.put("\u05dc\u05d5\u05d1", 1152);
    freq.put("\u05d4\u05d0\u05d5", 3742);
    freq.put("\u05d9\u05d8\u05d9", 4701);
    freq.put("\u05d4\u05d0\u05d3", 1377);
    freq.put("\u05dc\u05d5\u05d5", 2569);
    freq.put("\u05dc\u05d9\u05dd", 8070);
    freq.put("\u05d8", 120550);
    freq.put("\u05d4\u05d0\u05dc", 2120);
    freq.put("\u05dc\u05d5\u05dc", 1458);
    freq.put("\u05e8\u05d8\u05d9", 3060);
    freq.put("\u05d4\u05d0\u05d9", 3937);
    freq.put("\u05dc\u05d5\u05df", 862);
    freq.put("en ", 849);
    freq.put("\u05dc\u05d5\u05e1", 1978);
    freq.put("\u05dc\u05d4 ", 14910);
    freq.put("\u05d9\u05d8\u05dc", 2302);
    freq.put("\u05d4\u05d0\u05e0", 1474);
    freq.put("\u05dc\u05d5\u05e8", 772);
    freq.put("\u05dc\u05d5\u05e9", 1494);
    freq.put("\u05dc\u05d5\u05ea", 5393);
    freq.put("\u05d4\u05d0\u05e8", 2435);
    freq.put("\u05e9\u05d1\u05d5", 2486);
    freq.put("\u05d0\u05d1\u05d5", 828);
    freq.put("\u05e9\u05d1\u05d4", 1333);
    freq.put("\u05d0\u05d1\u05d9", 2570);
    freq.put("\u05e1\u05d3\u05e8", 3650);
    freq.put("\u05d3\u05d9 ", 14259);
    freq.put("\u05d2\u05d5 ", 887);
    freq.put("\u05d1\u05e4\u05e8", 1402);
    freq.put("\u05d9\u05e2 ", 1962);
    freq.put("\u05d9\u05d8\u05d5", 2202);
    freq.put("\u05d8\u05dc\u05d9", 1241);
    freq.put("\u05d8\u05dc\u05d5", 1568);
    freq.put("\u05e9\u05d1 ", 2846);
    freq.put("\u05d5\u05e4\u05e7", 800);
    freq.put("\u05de\u05d3\u05d9", 5777);
    freq.put("\u05d5\u05dc ", 7891);
    freq.put("\u05de\u05d3\u05d5", 1516);
    freq.put("\u05d5\u05e4\u05ea", 1896);
    freq.put("\u05d5\u05e4\u05e8", 3436);
    freq.put(" \u05d5\u05e7", 1350);
    freq.put("l", 18280);
    freq.put("\u05db\u05dc\u05d9", 2030);
    freq.put("\u05de\u05d3\u05e8", 908);
    freq.put("\u05de\u05d3\u05e2", 3235);
    freq.put(" \u05d1\u05d0", 23971);
    freq.put(" \u05d1\u05d1", 3563);
    freq.put(" \u05d1\u05d2", 3763);
    freq.put(" \u05d1\u05d3", 5369);
    freq.put(" \u05d1\u05d4", 6389);
    freq.put(" \u05d1\u05d5", 5324);
    freq.put(" \u05d1\u05d6", 1578);
    freq.put(" \u05d1\u05d7", 3909);
    freq.put(" \u05d1\u05d8", 1774);
    freq.put(" \u05d1\u05d9", 25678);
    freq.put(" \u05d1\u05db", 4321);
    freq.put(" \u05d1\u05dc", 4682);
    freq.put(" \u05d1\u05de", 21078);
    freq.put(" \u05d1\u05df", 1774);
    freq.put("\u05d1\u05e2 ", 2728);
    freq.put("\u05d5\u05e8\u05d4", 4165);
    freq.put("\u05d5\u05e8\u05d5", 3649);
    freq.put("\u05d5\u05e8\u05d2", 4279);
    freq.put("\u05d5\u05e8\u05d3", 1610);
    freq.put("\u05d5\u05e8\u05d0", 1280);
    freq.put("\u05d5\u05e8\u05d1", 1210);
    freq.put("\u05d5\u05e8\u05de", 1653);
    freq.put("\u05d5\u05ea ", 80938);
    freq.put("\u05d5\u05e8\u05db", 1436);
    freq.put("\u05d5\u05e8\u05d8", 1801);
    freq.put("\u05d5\u05e8\u05d9", 12062);
    freq.put("rt", 1408);
    freq.put("\u05d5\u05e8\u05e7", 1753);
    freq.put("\u05d5\u05e8\u05e0", 1343);
    freq.put("rs", 966);
    freq.put("\u05d5\u05e8\u05ea", 4134);
    freq.put("ry", 760);
    freq.put("\u05d5\u05e8\u05e8", 1139);
    freq.put("\u05d5\u05e8\u05e9", 1062);
    freq.put("rd", 1160);
    freq.put("re", 2927);
    freq.put(" \u05d1\u05e2", 12834);
    freq.put(" \u05d1\u05e4", 5193);
    freq.put("ra", 3300);
    freq.put(" \u05d1\u05e6", 3678);
    freq.put(" \u05d1\u05e7", 4194);
    freq.put(" \u05d1\u05e8", 10133);
    freq.put(" \u05d1\u05e9", 14953);
    freq.put(" \u05d1\u05ea", 9609);
    freq.put("is ", 1053);
    freq.put("ri", 3441);
    freq.put("\u05e1\u05e4\u05e8", 9874);
    freq.put("\u05d9\u05d6\u05dd", 1225);
    freq.put("\u05d9\u05d6\u05d9", 2803);
    freq.put("\u05e0\u05e1\u05d5", 805);
    freq.put("W", 1765);
    freq.put("\u05e0\u05e1\u05d9", 2174);
    freq.put("\u05da", 21160);
    freq.put("\u05d1\u05e0\u05d9", 4749);
    freq.put("\u05e4\u05e9\u05e8", 1288);
    freq.put("\u05e0\u05e1\u05ea", 1066);
    freq.put("\u05d1\u05e0\u05d4", 1480);
    freq.put("ati", 1099);
    freq.put("r ", 4009);
    freq.put("\u05db\u05d6 ", 1400);
    freq.put("\u05d4\u05d2\u05d3", 2288);
    freq.put("\u05d8\u05e8 ", 2558);
    freq.put("\u05d1\u05d2\u05e8", 1359);
    freq.put("\u05e7 ", 22523);
    freq.put("\u05d9\u05e0\u05d2", 1937);
    freq.put("\u05d9\u05e0\u05d0", 757);
    freq.put("\u05d9\u05e0\u05d4", 5280);
    freq.put("\u05d9\u05e0\u05d5", 10255);
    freq.put("\u05d9\u05e0\u05d8", 1703);
    freq.put("\u05d9\u05e0\u05d9", 8382);
    freq.put("\u05d9\u05e0\u05dc", 1089);
    freq.put("\u05d6\u05d4 ", 4910);
    freq.put("\u05d9\u05e0\u05e1", 944);
    freq.put("\u05d9\u05e0\u05ea", 1901);
    freq.put("\u05d5\u05d9\u05dc", 1139);
    freq.put("\u05e1\u05dc ", 766);
    freq.put("\u05de\u05e9\u05da", 1130);
    freq.put("B", 4044);
    freq.put("\u05de\u05e9\u05de", 3131);
    freq.put("\u05de\u05e9\u05dc", 2762);
    freq.put("\u05d7\u05d3 ", 5298);
    freq.put("\u05e0\u05d8 ", 1605);
    freq.put("\u05de\u05e9\u05d7", 2455);
    freq.put("\u05de\u05e9\u05d5", 2959);
    freq.put("\u05d3\u05ea", 5288);
    freq.put("\u05d3\u05e9", 2624);
    freq.put("\u05d3\u05e8", 19078);
    freq.put("\u05d0\u05e4\u05e9", 1248);
    freq.put("\u05d0\u05e4\u05e8", 2492);
    freq.put("\u05e8\u05d1 ", 5168);
    freq.put("\u05d3\u05e2", 6022);
    freq.put("\u05d3\u05e1", 1191);
    freq.put("\u05d3\u05e0", 1611);
    freq.put("\u05d3\u05e7", 1275);
    freq.put("\u05d3\u05e6", 1312);
    freq.put("\u05d3\u05e4", 866);
    freq.put("\u05d3\u05d9", 39839);
    freq.put("\u05d3\u05df", 1253);
    freq.put("\u05d3\u05de", 4712);
    freq.put("\u05d3\u05dd", 3790);
    freq.put("\u05d3\u05dc", 3528);
    freq.put("\u05d3\u05d3", 1385);
    freq.put("\u05d3\u05d2", 1438);
    freq.put("\u05d3\u05d1", 1971);
    freq.put("\u05d3\u05d0", 1968);
    freq.put("\u05d3\u05d5", 30532);
    freq.put("\u05d3\u05d4", 10078);
    freq.put("\u05de\u05e9\u05ea", 2362);
    freq.put("\u05de\u05e9\u05e8", 976);
    freq.put("\u05d3\u05e8\u05d9", 1886);
    freq.put("\u05d2\u05d3\u05d5", 3497);
    freq.put("\u05de\u05e9\u05e0", 2281);
    freq.put("\u05de\u05e9\u05e7", 861);
    freq.put("\u05de\u05e9\u05e4", 4826);
    freq.put("\u05d4\u05d1\u05d5", 902);
    freq.put("\u05e2\u05dd ", 5134);
    freq.put("\u05e1\u05dd ", 1071);
    freq.put("\u05d4\u05d1\u05d9", 3093);
    freq.put("\u05e7\u05d9 ", 3109);
    freq.put("\u05d4\u05d1\u05e8", 3864);
    freq.put("\u05e1\u05d2\u05e0", 827);
    freq.put("\u05e6\u05d5\u05e8", 3752);
    freq.put("\u05e1\u05d2\u05e8", 950);
    freq.put("on ", 2345);
    freq.put("\u05d9\u05ea\u05d5", 3399);
    freq.put(" \u05e6\u05d1", 1575);
    freq.put("\u05e8\u05e4\u05d5", 1781);
    freq.put(" \u05e6\u05d5", 1425);
    freq.put(" \u05e6\u05d9", 2521);
    freq.put("\u05e8\u05e4\u05d9", 1377);
    freq.put(" \u05e6\u05de", 781);
    freq.put("\u05e6\u05d5\u05d5", 876);
    freq.put("\u05d9\u05ea\u05d9", 1065);
    freq.put("the", 876);
    freq.put("m", 9009);
    freq.put("\u05d0\u05df ", 3273);
    freq.put("\u05e6\u05d9\u05d1", 1399);
    freq.put(" \u05e6\u05e4", 808);
    freq.put("\u05db\u05d0\u05e9", 1171);
    freq.put(" \u05e6\u05e8", 1714);
    freq.put("\u05e8\u05e4\u05ea", 3016);
    freq.put("\u05d0\u05d1 ", 829);
    freq.put("\u05db\u05e0\u05d5", 1432);
    freq.put("\u05db\u05e0\u05d9", 2511);
    freq.put("d ", 3184);
    freq.put("\u05d4\u05d7\u05d1", 1254);
    freq.put("\u05d4\u05d7\u05d5", 2245);
    freq.put("\u05dc\u05d4\u05d9", 1584);
    freq.put("\u05d4\u05d7\u05d9", 1691);
    freq.put("\u05d4\u05d7\u05dc", 2789);
    freq.put("\u05dc\u05d5 ", 5117);
    freq.put("\u05e6\u05d9", 17340);
    freq.put("\u05dc\u05d4\u05e7", 2345);
    freq.put("\u05dc\u05d4\u05ea", 947);
    freq.put("\u05d4\u05d7\u05e9", 794);
    freq.put("\u05db\u05e0\u05e1", 2070);
    freq.put("\u05e1\u05d3 ", 1188);
    freq.put("\u05e9\u05de\u05d5", 3471);
    freq.put("do", 869);
    freq.put("\u05e7\u05e8\u05d0", 3185);
    freq.put("\u05e7\u05e8\u05d1", 1789);
    freq.put("di", 1239);
    freq.put("de", 2377);
    freq.put("\u05e7\u05e8\u05d9", 3474);
    freq.put("da", 916);
    freq.put("\u05d0\u05de\u05d9", 1391);
    freq.put("\u05ea\u05d5\u05d0", 930);
    freq.put(" \u05e4\u05dc", 1804);
    freq.put("\u05e8\u05e2\u05d9", 965);
    freq.put("\u05ea\u05d5\u05d7", 1128);
    freq.put(" \u05e4\u05d9", 5929);
    freq.put("\u05ea\u05d5\u05da", 1588);
    freq.put("\u05ea\u05d5\u05db", 2531);
    freq.put(" \u05e4\u05d5", 6232);
    freq.put("\u05d0\u05de\u05d5", 966);
    freq.put("\u05d9\u05e1 ", 3129);
    freq.put("\u05ea\u05d5\u05dc", 1229);
    freq.put(" \u05e4\u05d0", 1358);
    freq.put("\u05d5\u05de\u05d1", 746);
    freq.put("\u05d0\u05de\u05e8", 4875);
    freq.put("\u05ea\u05d5\u05e0", 1543);
    freq.put("\u05ea\u05d5\u05e6", 851);
    freq.put("\u05ea\u05d5\u05e4", 747);
    freq.put(" \u05e4\u05e8", 8948);
    freq.put("\u05ea\u05d5\u05ea", 809);
    freq.put("\u05d0\u05de\u05e0", 1370);
    freq.put("\u05ea\u05d5\u05e8", 2674);
    freq.put(" \u05e4\u05e2", 2438);
    freq.put(" \u05e4\u05e1", 1467);
    freq.put(" \u05e4\u05e0", 1331);
    freq.put("\u05de\u05e8 ", 3374);
    freq.put("\u05d3\u05df ", 1252);
    freq.put("\u05d1\u05d3 ", 1438);
    freq.put("\u05e2\u05dc\u05ea", 1040);
    freq.put("\u05e7\u05de\u05d4", 931);
    freq.put(" \u05de ", 2074);
    freq.put("\u05d3\u05ea ", 3965);
    freq.put("\u05e9\u05de\u05e9", 2616);
    freq.put("\u05e1\u05de\u05d5", 1244);
    freq.put("\u05db\u05d9\u05dd", 1975);
    freq.put("\u05e6\u05e2\u05d5", 1152);
    freq.put("\u05e6\u05e2\u05d9", 1124);
    freq.put("\u05de\u05d5\u05e9", 3780);
    freq.put("\u05e2\u05dc\u05d9", 4061);
    freq.put("\u05e2\u05dc\u05d5", 1136);
    freq.put("\u05e2\u05dc\u05d4", 1199);
    freq.put("\u05de\u05d5\u05e4", 1468);
    freq.put("\u05e2\u05e6", 4716);
    freq.put("\u05e2\u05e7", 2148);
    freq.put("\u05e2\u05e0", 3092);
    freq.put("\u05e2\u05e1", 1118);
    freq.put("\u05e2\u05e8", 15071);
    freq.put("\u05e2\u05e9", 4774);
    freq.put("\u05e2\u05ea", 7895);
    freq.put("\u05e0\u05d7\u05e9", 1738);
    freq.put("\u05d8\u05d9\u05e0", 2155);
    freq.put("\u05e8\u05d0\u05ea", 808);
    freq.put("\u05e8\u05d0\u05e9", 9879);
    freq.put("\u05d8\u05d9\u05e4", 954);
    freq.put("\u05e9\u05de\u05e2", 1452);
    freq.put("\u05d6", 63772);
    freq.put("\u05e4\u05d7\u05ea", 1765);
    freq.put("\u05d8\u05d9\u05ea", 3454);
    freq.put("\u05db\u05d9\u05d4", 761);
    freq.put("\u05d8\u05d9\u05d1", 1924);
    freq.put("\u05e8\u05d0\u05d9", 2021);
    freq.put("\u05d8\u05d9\u05d5", 1116);
    freq.put("\u05e4\u05d7\u05d4", 834);
    freq.put("\u05e8\u05d0\u05dc", 9123);
    freq.put("\u05d8\u05d9\u05d9", 2059);
    freq.put("\u05d8\u05d9\u05dd", 3865);
    freq.put("\u05e8\u05d0\u05d5", 1207);
    freq.put("\u05e4\u05e8 ", 7389);
    freq.put("\u05e2\u05d4", 5494);
    freq.put("\u05e2\u05d5", 21588);
    freq.put("\u05e2\u05d6", 1654);
    freq.put("\u05e2\u05d1", 7995);
    freq.put("\u05e2\u05d3", 7161);
    freq.put("\u05e2\u05dc", 30126);
    freq.put("\u05e2\u05dd", 5137);
    freq.put("\u05e2\u05de", 4465);
    freq.put("\u05e2\u05d8", 1111);
    freq.put("\u05e2\u05d9", 23608);
    freq.put("\u05de\u05dc\u05d0", 1080);
    freq.put("\u05de\u05dc\u05d5", 953);
    freq.put("\u05d7\u05e7\u05e0", 990);
    freq.put("\u05de\u05dc\u05d7", 3450);
    freq.put("\u05de\u05dc\u05d9", 1534);
    freq.put("\u05de\u05dc\u05db", 2095);
    freq.put("\u05de\u05dc\u05da", 1227);
    freq.put("\u05d7\u05e7\u05e8", 1503);
    freq.put("\u05e9\u05d9 ", 4651);
    freq.put("\u05e6\u05de\u05d7", 843);
    freq.put("\u05d5\u05df ", 31676);
    freq.put("\u05e6\u05de\u05d1", 1291);
    freq.put("\u05d5\u05e9 ", 3750);
    freq.put("\u05d6\u05d9\u05d4", 1878);
    freq.put(" \u05d0 ", 1385);
    freq.put("\u05d7\u05e7\u05df", 1010);
    freq.put("\u05db\u05d9 ", 2345);
    freq.put("\u05d7\u05e7\u05d9", 1130);
    freq.put("\u05de\u05dc ", 1062);
    freq.put("\u05d7\u05e1 ", 1181);
    freq.put("\u05dc\u05e9\u05e0", 1062);
    freq.put("\u05e2\u05e7\u05d1", 1399);
    freq.put("\u05e1\u05e7\u05d9", 1760);
    freq.put("\u05e1\u05e7\u05d5", 1337);
    freq.put("Ch", 747);
    freq.put("Co", 1139);
    freq.put("\u05d6\u05d5 ", 2407);
    freq.put("Ca", 914);
    freq.put("n", 25648);
    freq.put("\u05d1\u05d5\u05e0", 896);
    freq.put("\u05e9\u05d8\u05d7", 1349);
    freq.put("\u05e0\u05d9 ", 19093);
    freq.put("is", 2730);
    freq.put("ir", 937);
    freq.put("it", 1899);
    freq.put("\u05d9\u05d1\u05d9", 2538);
    freq.put("il", 1849);
    freq.put("io", 2236);
    freq.put("in", 4459);
    freq.put("ia", 1960);
    freq.put("\u05d9\u05d1\u05d4", 1458);
    freq.put("ic", 2833);
    freq.put("ie", 1690);
    freq.put("id", 1119);
    freq.put("ig", 907);
    freq.put("\u05d9\u05d1\u05e8", 2757);
    freq.put("\u05d9\u05d1\u05ea", 1107);
    freq.put("\u05db\u05d9\u05e8", 1145);
    freq.put("\u05d5\u05d0\u05e8", 4871);
    freq.put("\u05e9\u05de\u05d9", 1858);
    freq.put("\u0441", 1017);
    freq.put("\u05e2\u05e9\u05e8", 1306);
    freq.put(" \u05dc\u05e7", 2667);
    freq.put(" \u05dc\u05e6", 1757);
    freq.put(" \u05dc\u05e4", 4810);
    freq.put(" \u05dc\u05e2", 3788);
    freq.put(" \u05dc\u05e1", 2540);
    freq.put(" \u05dc\u05e0", 1953);
    freq.put("i ", 1770);
    freq.put("\u05d3\u05e8\u05ea", 2145);
    freq.put("on", 5076);
    freq.put(" \u05dc\u05ea", 2908);
    freq.put(" \u05dc\u05e9", 5145);
    freq.put(" \u05dc\u05e8", 2977);
    freq.put(" \u05dc\u05d7", 2914);
    freq.put(" \u05dc\u05d6", 853);
    freq.put(" \u05dc\u05d5", 4443);
    freq.put(" \u05dc\u05d4", 9774);
    freq.put(" \u05dc\u05d3", 1145);
    freq.put(" \u05dc\u05d2", 1530);
    freq.put(" \u05dc\u05d1", 3660);
    freq.put(" \u05dc\u05d0", 10716);
    freq.put(" \u05dc\u05de", 9220);
    freq.put("\u05d3\u05e8\u05da", 2231);
    freq.put(" \u05dc\u05dc", 1387);
    freq.put(" \u05dc\u05db", 2758);
    freq.put(" \u05dc\u05d9", 6245);
    freq.put(" \u05dc\u05d8", 1128);
    freq.put("\u05e2\u05e9\u05d9", 1214);
    freq.put("\u05e2\u05e9\u05d4", 950);
    freq.put("\u05e2\u05e9\u05d5", 933);
    freq.put("\u05d5\u05e2\u05d4", 1693);
    freq.put("\u05d5\u05e0\u05ea", 1474);
    freq.put("\u05d5\u05e2\u05d5", 1416);
    freq.put("\u05db\u05d0", 3499);
    freq.put("\u05d9\u05d7\u05d3", 770);
    freq.put(" \u05d7\u05e1", 883);
    freq.put(" \u05e6 ", 1288);
    freq.put("\u05db\u05da", 1583);
    freq.put("\u05e7\u05ea ", 3999);
    freq.put("\u05d6\u05d9\u05e7", 3731);
    freq.put("\u05dc\u05db\u05ea", 1177);
    freq.put("D", 3214);
    freq.put("\u05d5\u05e2\u05d9", 1952);
    freq.put("\u05e7\u05d9\u05d5", 786);
    freq.put("\u05e7\u05d9\u05d3", 1911);
    freq.put(" \u05d7\u05e8", 777);
    freq.put("\u05e7\u05d9\u05d1", 1075);
    freq.put("\u05e7\u05d9\u05dd", 4228);
    freq.put(" \u05d7\u05e9", 1430);
    freq.put("\u05e7\u05d9\u05d9", 2845);
    freq.put("\u05e7\u05d9\u05e6", 864);
    freq.put("\u05d1\u05e4\u05d1", 1248);
    freq.put("\u05e7\u05d9\u05e1", 929);
    freq.put("\u05e2\u05e8\u05d9", 962);
    freq.put("\u05e7\u05d9\u05ea", 1359);
    freq.put("\u05e7\u05d9\u05e8", 818);
    freq.put("\u05dc\u05db\u05dc", 1891);
    freq.put(" \u05e1\u05d5", 5658);
    freq.put("\u05d9\u05d8\u05d4", 1667);
    freq.put("\u05dc\u05db\u05d4", 1199);
    freq.put("\u05dc\u05db\u05d5", 898);
    freq.put("\u05d9\u05de\u05e9", 796);
    freq.put(" \u05d4\u05df", 954);
    freq.put("\u05e0\u05d8\u05e8", 1455);
    freq.put("\u05d9\u05de\u05ea", 1210);
    freq.put(" \u05d4\u05de", 46981);
    freq.put("\u05d2\u05d3 ", 977);
    freq.put("\u05db\u05da ", 1583);
    freq.put("\u05de\u05db", 7596);
    freq.put("\u05de\u05dc", 12739);
    freq.put("\u05e8\u05d1\u05e2", 1063);
    freq.put("\u05d3 ", 40754);
    freq.put("\u05e4\u05d0\u05e8", 769);
    freq.put("\u05e8\u05d1\u05d9", 6491);
    freq.put("\u05e2\u05e8\u05db", 3489);
    freq.put(" \u05d4\u05d9", 41072);
    freq.put("\u05de\u05df", 5860);
    freq.put("\u05e8\u05d1\u05d4", 870);
    freq.put("\u05e8\u05d1\u05d5", 2717);
    freq.put("\u05d1\u05dc ", 2984);
    freq.put("\u05d1\u05ea\u05d5", 2504);
    freq.put(" \u05d4\u05d7", 10762);
    freq.put("\u05e0\u05d8\u05d9", 3381);
    freq.put(" \u05d4\u05d6", 2732);
    freq.put("\u05de\u05e9 ", 2759);
    freq.put("\u05d1\u05ea\u05d7", 2033);
    freq.put(" \u05d4\u05d5", 33156);
    freq.put("\u05e0\u05d8\u05d5", 1177);
    freq.put("\u05d1\u05de\u05d5", 1362);
    freq.put("\u05de\u05d3", 15338);
    freq.put("\u05de\u05d4", 19324);
    freq.put("of", 1227);
    freq.put("\u05d5\u05da ", 3767);
    freq.put(" \u05d4\u05d2", 7501);
    freq.put("\u05d6\u05d4\u05d5", 873);
    freq.put(" \u05d4\u05d1", 10880);
    freq.put(" \u05d4\u05d0", 22400);
    freq.put("\u05d9\u05de\u05d9", 5064);
    freq.put("\u05d1\u05e1\u05d3", 891);
    freq.put("o", 25621);
    freq.put("\u05d9\u05de\u05d4", 1856);
    freq.put("\u05d8\u05e8\u05d5", 3685);
    freq.put("\u05d9\u05de\u05d5", 4842);
    freq.put("\u05d9\u05d9\u05e1", 1621);
    freq.put("\u05d8\u05e8\u05d9", 3898);
    freq.put("\u05d9\u05d9\u05e0", 2765);
    freq.put("\u05d1\u05d5\u05e1", 1642);
    freq.put("\u05db\u05d6\u05d9", 1062);
    freq.put("\u05e4\u05e9\u05d9", 825);
    freq.put("\u05e0\u05e1 ", 1624);
    freq.put("\u05d9\u05d9\u05e9", 1691);
    freq.put("\u05d5\u05e2\u05e6", 1483);
    freq.put("\u05d9\u05d9\u05e8", 2338);
    freq.put("\u05d7\u05d9\u05df", 819);
    freq.put(" \u05d7\u05d5", 5710);
    freq.put("\u05d9\u05d6 ", 756);
    freq.put("\u05d5\u05e4\u05df", 1487);
    freq.put("\u05d9\u05d9\u05ea", 6408);
    freq.put("\u05d9\u05d0\u05d4", 813);
    freq.put("\u05d9\u05d9\u05d4", 4423);
    freq.put("\u05d9\u05d0\u05d8", 1005);
    freq.put(" \u05d7\u05d1", 4303);
    freq.put("\u05d9\u05d9\u05d7", 1458);
    freq.put("\u05d9\u05d0\u05dc", 1853);
    freq.put("de ", 816);
    freq.put("\u05d1\u05e4\u05d9", 884);
    freq.put("\u05d7", 143673);
    freq.put("\u05d1\u05e2\u05e8", 1666);
    freq.put("\u05d9\u05d9\u05d1", 892);
    freq.put("\u05d1\u05e2\u05ea", 1302);
    freq.put(" \u05d7\u05dc", 3208);
    freq.put("\u05d1\u05e2\u05d1", 1312);
    freq.put("\u05db\u05de\u05d5", 1809);
    freq.put("\u05d1\u05e2\u05d5", 2020);
    freq.put("\u05d5\u05e8 ", 18092);
    freq.put("\u05d5\u05ea\u05d4", 2054);
    freq.put("\u05d1\u05e2\u05d9", 5046);
    freq.put("\u05d5\u05ea\u05d7", 851);
    freq.put("\u05d1\u05e2\u05dc", 3414);
    freq.put(" \u05d1 ", 10067);
    freq.put("\u05d9\u05d9\u05dd", 14831);
    freq.put("\u05d9\u05d0\u05e0", 1337);
    freq.put("\u05d9\u05d9\u05dc", 1292);
    freq.put("\u05d9\u05d9\u05df", 3012);
    freq.put("\u05d5\u05dc\u05ea", 1183);
    freq.put("\u05d9\u05e8\u05ea", 2005);
    freq.put("\u05d5\u05dc\u05e8", 980);
    freq.put("\u05d9\u05d9\u05de", 2364);
    freq.put("\u05d8\u05ea ", 2178);
    freq.put("\u05d5\u05dc\u05e0", 2842);
    freq.put("\u05d5\u05dc\u05e7", 1057);
    freq.put("\u05d5\u05dc\u05e4", 880);
    freq.put("\u05d9\u05d9\u05d8", 1193);
    freq.put("\u05d9\u05d9\u05da", 816);
    freq.put("ni", 1853);
    freq.put("nn", 849);
    freq.put("\u05de\u05e9", 30914);
    freq.put("na", 1919);
    freq.put("nc", 982);
    freq.put("nd", 2342);
    freq.put("ne", 2187);
    freq.put("ng", 1840);
    freq.put("\u05d5\u05dc\u05d8", 1565);
    freq.put("tio", 1159);
    freq.put("\u05d5\u05dc\u05de", 1167);
    freq.put("\u05d5\u05dc\u05dc", 2126);
    freq.put("\u05d5\u05dc\u05dd", 4221);
    freq.put("\u05de\u05d3 ", 1904);
    freq.put("\u05d5\u05dc\u05d3", 6790);
    freq.put("\u05d5\u05dc\u05d0", 1327);
    freq.put("ns", 1298);
    freq.put("nt", 2386);
    freq.put("\u05d5\u05dc\u05d4", 3768);
    freq.put("\u05d5\u05dc\u05d5", 7007);
    freq.put("\u05e9\u05dd ", 6732);
    freq.put("\u05d4\u05e1\u05d5", 2019);
    freq.put("\u05d2\u05d5\u05e8", 2881);
    freq.put("\u05d3\u05d9\u05e0", 5116);
    freq.put("E", 2525);
    freq.put("\u05d4\u05e1\u05d3", 840);
    freq.put("\u05d2\u05d5\u05e3", 967);
    freq.put("\u05d2\u05d5\u05e1", 1728);
    freq.put("\u05d4\u05e1\u05d9", 1362);
    freq.put("\u05d1\u05de\u05d4", 1632);
    freq.put("\u05e1\u05ea ", 2182);
    freq.put("\u05d1\u05de\u05d7", 1274);
    freq.put("\u05d1\u05de\u05d0", 2636);
    freq.put("\u05d1\u05de\u05d1", 1705);
    freq.put(" \u05d4\u05e6", 5867);
    freq.put("\u05e7\u05d1 ", 846);
    freq.put("\u05de\u05e2", 13284);
    freq.put("\u05d9\u05e2\u05d9", 1794);
    freq.put("\u05d1\u05de\u05e7", 1759);
    freq.put("\u05d1\u05de\u05e1", 1456);
    freq.put("\u05d1\u05de\u05e2", 1091);
    freq.put("n ", 6713);
    freq.put("\u05d5\u05e1\u05e3", 1300);
    freq.put("\u05d1\u05de\u05e8", 2370);
    freq.put("\u05d1\u05de\u05e9", 1939);
    freq.put("\u05d4\u05e1\u05e4", 2367);
    freq.put("\u05e6\u05e2 ", 1320);
    freq.put(" \u05d4\u05e1", 10053);
    freq.put("\u05d2\u05d5\u05dc", 1378);
    freq.put("\u05d3\u05d9\u05d4", 1129);
    freq.put("\u05d2\u05d5\u05d3", 1622);
    freq.put("\u05d3\u05d9\u05d9", 1568);
    freq.put(" \u05d4\u05e0", 10137);
    freq.put("\u05d4\u05e1\u05e8", 1363);
    freq.put("\u05d3\u05d9\u05dd", 4959);
    freq.put("\u05e7\u05d1\u05d9", 757);
    freq.put("\u05e0\u05e4\u05d5", 1293);
    freq.put("\u05dc\u05ea\u05d9", 1345);
    freq.put("\u05e8\u05d3 ", 3185);
    freq.put("\u05dc\u05ea\u05d5", 964);
    freq.put("me", 1669);
    freq.put("\u05e7\u05d5 ", 1976);
    freq.put("\u05d1\u05d7\u05e8", 970);
    freq.put("\u05d5\u05d7\u05e8", 794);
    freq.put("\u05d4\u05e8\u05e9", 823);
    freq.put("\u05d4\u05e8\u05e4", 831);
    freq.put("\u05d5\u05e1\u05e7", 2400);
    freq.put("\u05d4\u05e8\u05db", 769);
    freq.put("\u05d4\u05e8\u05d9", 1168);
    freq.put("\u05d7\u05e8\u05d5", 2409);
    freq.put("\u05d5\u05d7\u05d3", 1468);
    freq.put("\u05d4\u05e8\u05d5", 2886);
    freq.put("\u05d4\u05e8\u05d1", 2013);
    freq.put("\u05d4\u05e8\u05d0", 4672);
    freq.put("p", 7557);
    freq.put("\u05e8\u05e5 ", 4170);
    freq.put("\u05d1\u05d7\u05d9", 1679);
    freq.put("\u05d1\u05d7\u05d5", 1131);
    freq.put(" \u05de\u05d3", 6437);
    freq.put("\u05d4\u05de\u05e4", 1404);
    freq.put("\u05d4\u05de\u05e7", 2404);
    freq.put("\u05d4\u05de\u05e6", 1978);
    freq.put("\u05d4\u05de\u05e1", 1855);
    freq.put("\u05d4\u05de\u05e0", 1147);
    freq.put("\u05d4\u05de\u05e2", 1738);
    freq.put("mi", 920);
    freq.put("\u05d4\u05de\u05e9", 5759);
    freq.put("\u05d4\u05de\u05e8", 1784);
    freq.put("\u05d4\u05de\u05ea", 2867);
    freq.put("\u05d0\u05e3", 1142);
    freq.put("\u05d0\u05e0", 19673);
    freq.put("\u05d0\u05e1", 5720);
    freq.put("\u05d0\u05e6", 2077);
    freq.put("\u05d0\u05e7", 3488);
    freq.put("\u05d0\u05e4", 6737);
    freq.put("\u05d0\u05ea", 18469);
    freq.put("\u05d0\u05e8", 23727);
    freq.put("\u05d0\u05e9", 17310);
    freq.put("\u05d0\u05d2", 2909);
    freq.put("\u05d0\u05d3", 6606);
    freq.put("\u05d0\u05d1", 7150);
    freq.put("\u05d0\u05d6", 5466);
    freq.put("\u05d0\u05d7", 13816);
    freq.put("\u05d0\u05d4", 8465);
    freq.put("\u05d0\u05d5", 54111);
    freq.put("\u05d0\u05da", 1814);
    freq.put("\u05d0\u05db", 1022);
    freq.put("\u05d0\u05d8", 3314);
    freq.put("\u05d0\u05d9", 39448);
    freq.put("\u05d0\u05de", 12397);
    freq.put("\u05d0\u05df", 3277);
    freq.put("\u05d0\u05dc", 31779);
    freq.put("\u05d0\u05dd", 2757);
    freq.put("\u05d4\u05de\u05d5", 7722);
    freq.put("\u05d4\u05de\u05d7", 2130);
    freq.put("\u05d4\u05de\u05d6", 1081);
    freq.put("\u05d4\u05de\u05d1", 1301);
    freq.put("\u05d4\u05de\u05d0", 3556);
    freq.put("\u05d4\u05de\u05d3", 2330);
    freq.put("\u05d8\u05e8\u05ea", 804);
    freq.put("\u05d4\u05de\u05dc", 2091);
    freq.put("\u05d4\u05de\u05de", 1866);
    freq.put("\u05d4\u05de\u05d9", 3193);
    freq.put("\u05d9\u05e4\u05d4", 1175);
    freq.put("\u05d4\u05de\u05db", 1676);
    freq.put("\u05d4\u05dc ", 908);
    freq.put("Ma", 1436);
    freq.put("\u05d5\u05db\u05d9", 1321);
    freq.put("\u05d0\u05d5\u05ea", 6901);
    freq.put("\u05d0\u05d5\u05e4", 3417);
    freq.put("\u05d0\u05d5\u05e7", 2466);
    freq.put("\u05d0\u05d5\u05e0", 2600);
    freq.put("\u05d0\u05d5\u05e1", 2423);
    freq.put("\u05d5\u05d6 ", 2245);
    freq.put("\u05dc\u05d1\u05d9", 1775);
    freq.put("\u05dc\u05d1\u05d5", 2832);
    freq.put("\u05e8\u05e9\u05ea", 1744);
    freq.put("\u05d5\u05db\u05d5", 764);
    freq.put("\u05de", 381378);
    freq.put("\u05d5\u05db\u05d4", 1041);
    freq.put("\u05e8\u05e9\u05d5", 916);
    freq.put("\u05e7\u05e1\u05d9", 1168);
    freq.put("\u05e8\u05e9\u05d9", 915);
    freq.put("\u05dc\u05d1\u05e0", 1140);
    freq.put("\u05d0\u05d5\u05dc", 3101);
    freq.put("\u05d0\u05d5\u05de", 3134);
    freq.put("\u05d0\u05d5\u05df", 955);
    freq.put("\u05d0\u05d5\u05d8", 953);
    freq.put("\u05d9\u05e8\u05d4", 3648);
    freq.put("\u05d0\u05d5\u05d5", 1522);
    freq.put("\u05ea\u05dc\u05de", 974);
    freq.put("\u05d0\u05d5\u05d2", 1935);
    freq.put("\u05d0\u05d5\u05d3", 916);
    freq.put(" \u05e9\u05d8", 1041);
    freq.put(" \u05e9\u05d9", 8345);
    freq.put(" \u05e9\u05db", 1941);
    freq.put(" \u05e9\u05dc", 48394);
    freq.put(" \u05e9\u05dd", 3634);
    freq.put(" \u05e9\u05de", 8425);
    freq.put("\u05e8\u05e7\u05d9", 1347);
    freq.put(" \u05e9\u05d0", 2492);
    freq.put(" \u05e9\u05d1", 7588);
    freq.put(" \u05e9\u05d4", 7711);
    freq.put(" \u05e9\u05d5", 5579);
    freq.put(" \u05e9\u05d7", 2817);
    freq.put("\u05d5\u05d9 ", 5737);
    freq.put("\u05d9\u05d3\u05d9", 10222);
    freq.put("\u05d7\u05e8\u05ea", 762);
    freq.put("\u05db\u05d5 ", 1279);
    freq.put("\u05e4\u05d8\u05e8", 1084);
    freq.put("\u05db\u05d9\u05de", 930);
    freq.put("\u05e4\u05dc\u05d5", 847);
    freq.put("\u05d9\u05e7 ", 3514);
    freq.put("\u05d7\u05dc\u05dc", 804);
    freq.put(" \u05e9\u05e8", 1669);
    freq.put(" \u05e9\u05e9", 1373);
    freq.put(" \u05e9\u05ea", 1185);
    freq.put(" \u05e9\u05e0", 9947);
    freq.put(" \u05e9\u05e2", 1892);
    freq.put(" \u05e9\u05e4", 2381);
    freq.put(" \u05e9\u05e7", 787);
    freq.put("F", 2735);
    freq.put("\u05d4\u05e2\u05d5", 4093);
    freq.put("\u064a", 1156);
    freq.put("\u05d8\u05de\u05d1", 1415);
    freq.put("\u05e8\u05d5\u05d5", 1191);
    freq.put("\u05e8\u05d5\u05d6", 748);
    freq.put("\u05e8\u05d5\u05d7", 842);
    freq.put("\u05e2\u05d9\u05ea", 1602);
    freq.put("\u05e8\u05d5\u05d1", 4518);
    freq.put("\u05e2\u05d9\u05e8", 4131);
    freq.put("\u05dc\u05e8 ", 750);
    freq.put("\u05e2\u05d9\u05e7", 3105);
    freq.put("\u05e8\u05d5\u05de", 4126);
    freq.put("\u05e8\u05d5\u05df", 3292);
    freq.put("\u05e8\u05d5\u05d8", 809);
    freq.put("\u05e8\u05d5\u05d9", 1525);
    freq.put("\u05e8\u05d5\u05e4", 3572);
    freq.put("\u05e2\u05d9\u05df", 910);
    freq.put("e ", 9963);
    freq.put("\u05e2\u05d9\u05dd", 3131);
    freq.put("\u05e8\u05d5\u05e0", 2892);
    freq.put("\u05e8\u05d5\u05e1", 3581);
    freq.put("\u05e8\u05d5\u05e2", 945);
    freq.put("\u05e2\u05d9\u05d9", 870);
    freq.put("\u05d9 ", 129045);
    freq.put("\u05e2\u05d9\u05d5", 894);
    freq.put("\u05e8\u05d5\u05e8", 832);
    freq.put("\u05e8\u05d5\u05e9", 2596);
    freq.put("\u05e8\u05d5\u05ea", 11282);
    freq.put("\u05d7\u05dc\u05e7", 3950);
    freq.put("\u05e4\u05ea ", 4142);
    freq.put("\u05d9\u05d5 ", 8828);
    freq.put(" of", 1007);
    freq.put("\u05e9\u05dc ", 44424);
    freq.put("\u05e0\u05dc\u05d0", 901);
    freq.put("\u05d5\u05e7 ", 4196);
    freq.put("\u05e6\u05d1\u05d9", 1113);
    freq.put(" \u05d2 ", 4498);
    freq.put("H", 2508);
    freq.put("\u05db\u05d9\u05d1", 953);
    freq.put("\u05e6\u05d1\u05d0", 1757);
    freq.put("s ", 8103);
    freq.put("\u05de\u05d1\u05e0", 1260);
    freq.put("\u05d6\u05e2\u05e8", 1824);
    freq.put("\u05de\u05d1\u05e8", 4568);
    freq.put("\u05d8\u05e8\u05d4", 1144);
    freq.put("\u05d9\u05e8 ", 9468);
    freq.put("\u05e9\u05d5\u05d9", 825);
    freq.put("ss", 1070);
    freq.put("st", 2602);
    freq.put("si", 1360);
    freq.put("so", 786);
    freq.put("\u05d5\u05d5\u05d0", 1655);
    freq.put("\u05de\u05d1\u05d5", 1915);
    freq.put("\u05de\u05d1\u05d9", 1059);
    freq.put("se", 1404);
    freq.put("\u05d9\u05dc\u05d3", 1523);
    freq.put("\u05e6\u05d0 ", 3406);
    freq.put("\u05d1\u05d0 ", 1578);
    freq.put("\u05d0\u05e8\u05db", 746);
    freq.put("\u05d0\u05e8\u05d9", 2497);
    freq.put("\u05d4\u05e9\u05ea", 1139);
    freq.put("\u05d9\u05e4\u05d9", 1104);
    freq.put("\u05d0\u05e8\u05d3", 814);
    freq.put("\u05d0\u05e8\u05d2", 2148);
    freq.put("\u05d0\u05e8\u05d1", 1076);
    freq.put("\u05d9\u05e4\u05d5", 4212);
    freq.put("\u05d4\u05e9\u05e0", 4351);
    freq.put("\u05d0\u05e8\u05d5", 1606);
    freq.put("\u05d4\u05e9\u05dc", 1958);
    freq.put("\u05d4\u05e9\u05dd", 895);
    freq.put("\u05d4\u05e9\u05de", 1266);
    freq.put("\u05ea\u05e8\u05d1", 1108);
    freq.put("\u05d4\u05e9\u05d9", 2832);
    freq.put("\u05d4\u05e9\u05d5", 2146);
    freq.put("\u05d4\u05e9\u05d7", 757);
    freq.put("\u05d0\u05e8\u05e7", 837);
    freq.put("\u05d0\u05e8\u05e6", 2697);
    freq.put("\u05d0\u05e8\u05e5", 2338);
    freq.put("\u05db\u05d9\u05d5", 2320);
    freq.put("\u05b5", 751);
    freq.put("\u05d7\u05dc\u05d5", 1698);
    freq.put("\u05e7\u05e8 ", 5102);
    freq.put("\u05d9\u05dc ", 6999);
    freq.put("\u05d5\u05e7\u05e8", 2331);
    freq.put("\u05e8\u05d4 ", 17356);
    freq.put("\u05d7\u05dd ", 833);
    freq.put("\u05e4\u05d3", 1152);
    freq.put("\u05d9\u05db\u05d9", 851);
    freq.put("em", 940);
    freq.put("el", 2456);
    freq.put("en", 3848);
    freq.put("ei", 783);
    freq.put("ed", 1174);
    freq.put("ea", 1448);
    freq.put("ec", 949);
    freq.put("et", 1553);
    freq.put("es", 3076);
    freq.put("er", 6931);
    freq.put("\u05e8\u05ea\u05d5", 1195);
    freq.put("\u05d0\u05d6\u05d5", 2699);
    freq.put("\u05e7\u05e0\u05d9", 2966);
    freq.put("\u05e8\u05ea\u05d9", 1593);
    freq.put("\u05ea\u05d1 ", 1936);
    freq.put("\u05d8\u05d5 ", 1328);
    freq.put(" \u05e8 ", 1507);
    freq.put("\u05dd ", 165828);
    freq.put("\u05ea\u05df ", 2959);
    freq.put(" \u05ea\u05dc", 1823);
    freq.put(" \u05ea\u05d9", 1934);
    freq.put("G", 2624);
    freq.put(" \u05ea\u05d5", 4939);
    freq.put(" \u05ea\u05d7", 2475);
    freq.put(" \u05ea\u05d0", 1279);
    freq.put("\u05dc\u05e7\u05d5", 1461);
    freq.put("\u05d0\u05d4 ", 7609);
    freq.put("\u05e8\u05e8 ", 986);
    freq.put("\u05e6\u05e4\u05d5", 2771);
    freq.put("\u05d8\u05dc\u05e7", 1324);
    freq.put("\u05dc\u05d5\u05d2", 4860);
    freq.put("\u05dc\u05d0 ", 4586);
    freq.put(" \u05ea\u05e9", 1190);
    freq.put(" \u05ea\u05e8", 2157);
    freq.put("\u05e8\u05d8\u05d5", 1441);
    freq.put(" \u05ea\u05e4", 1385);
    freq.put(" \u05ea\u05e7", 2224);
    freq.put(" \u05ea\u05e0", 1167);
    freq.put(" \u05ea\u05e2", 967);
    freq.put("\u05d4\u05dd ", 6282);
    freq.put("\u05dc\u05d8 ", 1236);
    freq.put("\u05dc\u05d5\u05d7", 1147);
    freq.put("\u05d3\u05dd ", 3784);
    freq.put("\u05d1 ", 39174);
    freq.put("\u05d3\u05e8\u05d4", 2116);
    freq.put("\u05d4\u05d0\u05de", 2115);
    freq.put("\u05d3\u05de\u05d5", 2336);
    freq.put("\u05d5\u05e0\u05d8", 1231);
    freq.put("\u05d5\u05e0\u05d9", 18082);
    freq.put("\u05dc\u05d5\u05dd", 1009);
    freq.put("\u05dc\u05d5\u05de", 2089);
    freq.put("\u05d1\u05e8\u05d8", 849);
    freq.put("\u05dc\u05d5\u05e0", 1458);
    freq.put("\u05d5\u05e0\u05d5", 5615);
    freq.put("\u05e9\u05e0\u05d4", 2722);
    freq.put("\u05e9\u05e0\u05d5", 3666);
    freq.put("x ", 2437);
    freq.put("\u05e9\u05e0\u05d9", 8407);
    freq.put("\u05d5\u05e0\u05d3", 1458);
    freq.put("\u05e4 ", 1749);
    freq.put("\u05d5\u05d8 ", 1289);
    freq.put("\u05d9\u05d9\u05d3", 1305);
    freq.put("\u05df", 91462);
    freq.put("\u05dc\u05d5\u05e7", 1039);
    freq.put("ia ", 834);
    freq.put("r", 26616);
    freq.put("\u05e9\u05e0\u05ea", 8163);
    freq.put("and", 1073);
    freq.put("\u05d5\u05bc", 1323);
    freq.put("\u05d5\u05b9", 1575);
    freq.put("\u05d0\u05dc\u05d4", 1036);
    freq.put("\u05dc\u05e4\u05d9", 2283);
    freq.put("\u05d1\u05e7\u05e8", 1360);
    freq.put("\u05de\u05d6\u05e8", 2302);
    freq.put("\u05d8 ", 20042);
    freq.put("\u05d9\u05d0\u05d5", 2501);
    freq.put("\u05d9\u05e9 ", 4075);
    freq.put("\u05de\u05d6\u05d5", 770);
    freq.put("\u05dc\u05e4\u05e0", 1939);
    freq.put("\u0435", 1219);
    freq.put("\u05b4", 1697);
    freq.put("\u05d6\u05d9\u05ea", 1113);
    freq.put("\u05dc\u05e4\u05e8", 766);
    freq.put("\u05d9\u05d4 ", 40026);
    freq.put("\u05de\u05d8", 8749);
    freq.put("\u05de\u05d9", 43286);
    freq.put(" \u05d4\u05dd", 2069);
    freq.put(" \u05d4\u05dc", 5334);
    freq.put("an ", 1270);
    freq.put("\u05de\u05de", 12115);
    freq.put(" \u05d4\u05d8", 3324);
    freq.put("\u05de\u05d0", 19955);
    freq.put("\u05de\u05d1", 11717);
    freq.put("\u05de\u05d2", 4215);
    freq.put(" \u05d4\u05d4", 5396);
    freq.put(" \u05d4\u05d3", 4857);
    freq.put("\u05de\u05d5", 54355);
    freq.put("\u05de\u05d6", 4310);
    freq.put("\u05de\u05d7", 12385);
    freq.put("\u05d9\u05da ", 2851);
    freq.put("\u05d9\u05d9\u05e7", 972);
    freq.put("\u05d9\u05d9\u05e6", 1194);
    freq.put("\u05d5\u05e9", 17323);
    freq.put("\u05d5\u05e8", 67093);
    freq.put("\u05d5\u05ea", 101531);
    freq.put("\u05d5\u05e5", 2534);
    freq.put("\u05d5\u05e4", 26005);
    freq.put("\u05d5\u05e7", 18906);
    freq.put("\u05d5\u05e6", 14838);
    freq.put("\u05d5\u05e1", 26165);
    freq.put("\u05d5\u05e0", 45275);
    freq.put("\u05d5\u05e3", 4260);
    freq.put("\u05d5\u05e2", 21211);
    freq.put("\u05d5\u05dd", 16031);
    freq.put("\u05d5\u05dc", 56167);
    freq.put("\u05d5\u05df", 31711);
    freq.put("\u05d5\u05de", 32989);
    freq.put("\u05d5\u05d9", 25913);
    freq.put("\u05d5\u05d8", 7960);
    freq.put("\u05d5\u05db", 13432);
    freq.put("\u05d5\u05da", 3767);
    freq.put("\u05d5\u05d5", 21707);
    freq.put("\u05d5\u05d4", 16855);
    freq.put("\u05d5\u05d7", 11917);
    freq.put("\u05d5\u05d6", 11389);
    freq.put("\u05d5\u05d1", 35986);
    freq.put("\u05d5\u05d0", 44658);
    freq.put("\u05d5\u05d3", 26125);
    freq.put("\u05d5\u05d2", 17753);
    freq.put("\u05de\u05e8", 20980);
    freq.put("\u05e2\u05e1\u05e7", 909);
    freq.put("\u05de\u05ea", 18345);
    freq.put("\u0627\u0644", 1187);
    freq.put(" \u05d4\u05ea", 11571);
    freq.put(" \u05d4\u05e9", 17912);
    freq.put(" \u05d4\u05e8", 14413);
    freq.put("\u05de\u05e0", 16156);
    freq.put("\u05de\u05e1", 13321);
    freq.put(" \u05d3 ", 1157);
    freq.put(" \u05d4\u05e4", 9733);
    freq.put("\u05de\u05e4", 8474);
    freq.put(" \u05d4\u05e2", 13912);
    freq.put("\u05de\u05e6", 11869);
    freq.put("\u05de\u05e7", 11494);
    freq.put("\u05de\u05d0\u05dc", 2405);
    freq.put("\u05de\u05d0\u05d9", 3462);
    freq.put("\u05de\u05d0\u05d5", 3114);
    freq.put("\u05de\u05d0\u05d4", 2706);
    freq.put("\u05de\u05d0\u05d6", 946);
    freq.put("\u05d9\u05e4", 9697);
    freq.put("\u05dc\u05e8\u05d9", 1005);
    freq.put("\u05d6\u05db\u05d5", 1572);
    freq.put("\u0430", 1783);
    freq.put("\u05d1\u05e8\u05e1", 1667);
    freq.put("\u05de\u05d0\u05e8", 916);
    freq.put("\u05d0\u05d7\u05ea", 1793);
    freq.put("\u05de\u05d0\u05ea", 1015);
    freq.put("\u05de\u05d0\u05e4", 1026);
    freq.put("\u05de\u05d0\u05e0", 883);
    freq.put(" \u05d2\u05d5", 3424);
    freq.put(" \u05d2\u05d1", 1847);
    freq.put(" \u05d2\u05d0", 1205);
    freq.put(" \u05d2\u05d3", 1588);
    freq.put("\u05d5\u05ea\u05dd", 860);
    freq.put(" \u05d2\u05dd", 4780);
    freq.put(" \u05d2\u05dc", 1445);
    freq.put("\u05e6\u05d1 ", 1365);
    freq.put(" px", 1777);
    freq.put(" \u05d2\u05d9", 2015);
    freq.put("\u05d5\u05e7\u05d9", 1776);
    freq.put("\u05d5\u05e7\u05d8", 2107);
    freq.put("\u05d5\u05e7\u05de", 1227);
    freq.put("\u05d5\u05e7\u05dd", 1123);
    freq.put("\u05d1\u05e7\u05d5", 797);
    freq.put("\u05d9\u05db\u05e8", 764);
    freq.put("\u05e9\u05dc\u05ea", 1194);
    freq.put("\u05d5\u05e7\u05d5", 1308);
    freq.put("\u05d5\u05ea\u05d9", 4897);
    freq.put("\u05e9\u05dc\u05d4", 1787);
    freq.put("\u05e9\u05dc\u05d5", 3513);
    freq.put("\u05d9\u05db\u05d5", 4344);
    freq.put("\u05e0\u05d5 ", 5903);
    freq.put("\u05d5\u05e7\u05e1", 776);
    freq.put("\u05e9\u05dc\u05d8", 1378);
    freq.put("\u05e9\u05dc\u05d9", 4040);
    freq.put("\u05d5\u05ea\u05d5", 3558);
    freq.put("\u05d5\u05e0\u05e1", 965);
    freq.put(" \u05d2\u05e8", 3583);
    freq.put("\u05dc\u05d9\u05e9", 1631);
    freq.put("\u05d9\u05d5\u05dd", 4082);
    freq.put("\u05d9\u05d5\u05dc", 2364);
    freq.put("\u05e4\u05ea\u05d7", 1344);
    freq.put("\u05d9\u05d5\u05de", 966);
    freq.put("\u05e4\u05ea\u05d9", 2367);
    freq.put("\u05d9\u05d5\u05d5", 4083);
    freq.put("\u05d9\u05d5\u05d7", 1326);
    freq.put("\u05d5\u05e4\u05e9", 817);
    freq.put("\u05d9\u05d9", 52949);
    freq.put("\u05d9\u05d8", 18165);
    freq.put("\u05d9\u05db", 8588);
    freq.put("\u05d9\u05da", 2854);
    freq.put("\u05d9\u05dd", 101424);
    freq.put("\u05d9\u05dc", 28185);
    freq.put("\u05d9\u05df", 20736);
    freq.put("\u05d9\u05de", 19188);
    freq.put("\u05d9\u05d1", 19301);
    freq.put("\u05d9\u05d0", 28186);
    freq.put("\u05d9\u05d3", 26912);
    freq.put("\u05d9\u05d2", 6611);
    freq.put("\u05d9\u05d5", 59458);
    freq.put("\u05d9\u05d4", 49212);
    freq.put("\u05e2\u05d9 ", 4052);
    freq.put("\u05d9\u05d6", 7368);
    freq.put("\u05d9\u05e9", 24046);
    freq.put("\u05d9\u05e8", 32678);
    freq.put("\u05dc\u05e8\u05d5", 1023);
    freq.put("\u05d9\u05ea", 80424);
    freq.put("\u05e8\u05d5 ", 3945);
    freq.put("\u05d1\u05e7\u05d9", 1190);
    freq.put("\u05dc\u05e8\u05d0", 1055);
    freq.put("\u05d9\u05e1", 16568);
    freq.put("\u05d9\u05e0", 36790);
    freq.put("\u05d9\u05e3", 1039);
    freq.put("\u05d9\u05e2", 8301);
    freq.put("\u05d9\u05e5", 1467);
    freq.put("\u05e0\u05e2\u05e8", 986);
    freq.put("\u05d9\u05e7", 28848);
    freq.put("\u05d9\u05e6", 10768);
    freq.put("\u05d9\u05d5\u05e8", 2161);
    freq.put("\u05d9\u05d5\u05ea", 18525);
    freq.put("\u05d9\u05d5\u05e1", 1553);
    freq.put("\u05d9\u05d5\u05e0", 4734);
    freq.put("\u05d9\u05d5\u05e6", 1391);
    freq.put("\u05ea\u05e8 ", 6554);
    freq.put("\u05d5\u05d9\u05e0", 891);
    freq.put("\u05d9\u05e7\u05d5", 3145);
    freq.put("\u05d9\u05e7\u05d4", 6636);
    freq.put("\u05d5\u05d9\u05e7", 1124);
    freq.put("\u05d9\u05e7\u05d0", 4207);
    freq.put("\u05d5\u05d9\u05e8", 1363);
    freq.put("\u05d9\u05e7\u05dc", 1432);
    freq.put("\u05d9\u05e7\u05d9", 1290);
    freq.put("\u05d9\u05e7\u05d8", 1251);
    freq.put("\u05d5\u05d9\u05d3", 832);
    freq.put("\u05d5\u05d9\u05d5", 3873);
    freq.put("\u05d5\u05d9\u05d4", 1089);
    freq.put("\u05d5\u05d9\u05d6", 1668);
    freq.put("\u05d5\u05d9\u05d9", 2636);
    freq.put("\u05d5\u05d9\u05dd", 1245);
    freq.put(" \u0627\u0644", 1017);
    freq.put("\u05d5\u05d9\u05de", 813);
    freq.put("s", 19158);
    freq.put("\u05d1\u05d1\u05d9", 1380);
    freq.put("\u05e8\u05e7 ", 2876);
    freq.put("\u05ea\u05dc ", 1457);
    freq.put("\u05d0\u05d5 ", 12752);
    freq.put("\u05e8\u05e9 ", 946);
    freq.put("\u05d2\u05d1\u05d5", 1377);
    freq.put("\u05d7\u05dc ", 1502);
    freq.put("\u05e7\u05e1 ", 1455);
    freq.put("\u05d2\u05d0\u05d5", 1715);
    freq.put("\u05e7\u05e8\u05d5", 2813);
    freq.put("\u05dc\u05d1 ", 1394);
    freq.put("\u05d4\u05dc\u05d0", 944);
    freq.put("\u05d4\u05dc\u05d5", 1160);
    freq.put("\u05d4\u05dc\u05d4", 874);
    freq.put("\u05d4\u05dc\u05db", 875);
    freq.put("\u05d4\u05dc\u05da", 1189);
    freq.put("\u05d4\u05dc\u05d9", 2332);
    freq.put("\u05ea\u05de\u05e9", 815);
    freq.put("\u05e1\u05d1\u05d9", 1330);
    freq.put("\u05d4\u05d2\u05d9", 1488);
    freq.put("\u05d0 ", 61709);
    freq.put("\u05dc\u05d7\u05d9", 1661);
    freq.put("\u05dc\u05d7\u05de", 2604);
    freq.put("\u05d4\u05d2\u05d1", 784);
    freq.put("\u05db", 123771);
    freq.put("\u05d4\u05d2\u05d5", 1529);
    freq.put("\u05ea\u05ea ", 1033);
    freq.put("\u05d4\u05d2\u05e8", 1312);
    freq.put("\u05d9\u05e7\u05e0", 1394);
    freq.put("\u05ea\u05de\u05d5", 1033);
    freq.put("\u05d0\u05d3\u05dd", 2266);
    freq.put("\u05e2\u05d1\u05d5", 2091);
    freq.put("\u05d0\u05d3\u05d5", 1100);
    freq.put("\u05e4\u05dc\u05d2", 1367);
    freq.put(" \u05e7\u05d5", 8076);
    freq.put("\u05d4\u05ea\u05d7", 1134);
    freq.put(" \u05e7\u05d0", 953);
    freq.put(" \u05e7\u05d1", 2948);
    freq.put("\u05e7\u05d5\u05ea", 1519);
    freq.put(" \u05e7\u05dc", 1932);
    freq.put("\u05e7\u05d5\u05e8", 4356);
    freq.put(" \u05e7\u05d8", 1426);
    freq.put(" \u05e7\u05d9", 3820);
    freq.put("\u05ea\u05d0\u05d9", 785);
    freq.put("\u05d5\u05d7 ", 3705);
    freq.put("\u05ea\u05d0\u05d5", 1106);
    freq.put("\u05d4\u05e8 ", 1518);
    freq.put("\u05ea\u05d0\u05e8", 1331);
    freq.put(" Ma", 1422);
    freq.put("\u05d9\u05e5 ", 1463);
    freq.put(" \u05e7\u05e6", 927);
    freq.put("\u05b0", 2319);
    freq.put("\u05e7\u05d5\u05d1", 1891);
    freq.put(" \u05e7\u05e0", 905);
    freq.put("\u05e7\u05d5\u05d8", 813);
    freq.put("\u05e7\u05d5\u05de", 2802);
    freq.put(" \u05e7\u05e8", 4233);
    freq.put(" \u05e7\u05e9", 1007);
    freq.put("\u05d4\u05ea\u05e0", 1704);
    freq.put("I", 3050);
    freq.put("\u05dc\u05ea ", 6746);
    freq.put("\u05e8\u05d3\u05d9", 2706);
    freq.put("\u05db\u05d3\u05d5", 2961);
    freq.put("no", 898);
    freq.put("\u05d7\u05e9\u05d5", 1442);
    freq.put("\u05d4\u05ea\u05e8", 1227);
    freq.put("\u4e00", 845);
    freq.put(" \u05d3\u05d9", 3533);
    freq.put(" \u05d3\u05de", 1254);
    freq.put("\u05db\u05dd ", 777);
    freq.put("\u05e2\u05e0\u05d9", 1193);
    freq.put(" \u05d3\u05d1", 749);
    freq.put(" \u05d3\u05d4", 785);
    freq.put(" \u05d3\u05d5", 3757);
    freq.put("\u05d5\u05e6\u05d9", 1905);
    freq.put("\u05d9\u05d9 ", 1538);
    freq.put("\u05e9\u05d2 ", 788);
    freq.put("\u05d5\u05e6\u05d4", 1895);
    freq.put("\u05d5 ", 72231);
    freq.put("\u05d5\u05e6\u05e8", 3353);
    freq.put("\u05d5\u05e6\u05ea", 1866);
    freq.put("\u05d9\u05e9\u05d4", 1288);
    freq.put("\u05db\u05d3\u05d9", 968);
    freq.put("\u05e9\u05d5\u05e0", 5449);
    freq.put("\u05d5\u05e5 ", 2534);
    freq.put(" \u05d3\u05e8", 2719);
    freq.put("\u05d5\u05dc\u05d9", 9326);
    freq.put("\u05de ", 2663);
    freq.put(" \u05d4 ", 7037);
    freq.put("\u05d9\u05d4\u05df", 839);
    freq.put("\u05d9\u05d4\u05dd", 1573);
    freq.put("\u05d9\u05d4\u05d5", 5488);
    freq.put("\u05d8\u05db", 861);
    freq.put("\u05d8\u05d9", 27400);
    freq.put("\u05d8\u05de", 2400);
    freq.put("\u05d8\u05df", 1424);
    freq.put("\u05d8\u05dc", 6264);
    freq.put("\u05d1\u05e6\u05e4", 918);
    freq.put("\u05e8\u05de", 9087);
    freq.put("\u05d8\u05d0", 3408);
    freq.put("\u05d8\u05d1", 2858);
    freq.put("\u05dd", 165990);
    freq.put("\u05d8\u05d7", 2065);
    freq.put("\u05d8\u05d4", 4110);
    freq.put("\u05d8\u05d5", 20425);
    freq.put("\u05d8\u05ea", 2335);
    freq.put("\u05dc\u05e9\u05d5", 879);
    freq.put("\u05d8\u05e8", 15887);
    freq.put("\u05d8\u05e2", 1653);
    freq.put("\u05d1\u05e6\u05d5", 754);
    freq.put("\u05d8\u05e0", 3561);
    freq.put("\u05d8\u05e1", 846);
    freq.put("\u05d8\u05e7", 1116);
    freq.put("\u05d6\u05d9 ", 1210);
    freq.put("\u05d9\u05e8\u05d5", 10154);
    freq.put("t", 20514);
    freq.put("\u05d2\u05d5\u05ea", 1342);
    freq.put("\u05d1\u05d0\u05e8", 2896);
    freq.put("\u05d1\u05d0\u05e0", 6445);
    freq.put("\u05d1\u05d0\u05e4", 1580);
    freq.put("\u05d9\u05e6\u05d5", 3383);
    freq.put("\u05e0\u05dd ", 1133);
    freq.put("\u05d9\u05e6\u05d9", 2337);
    freq.put("\u05d5\u05d8\u05d5", 1573);
    freq.put("\u05d8\u05d9\u05e1", 800);
    freq.put("o ", 2412);
    freq.put("\u05d1\u05d0\u05d9", 3225);
    freq.put("\u05d1\u05d0\u05de", 1587);
    freq.put("\u05d1\u05d0\u05dc", 995);
    freq.put("\u05d3\u05d9\u05ea", 2578);
    freq.put("\u05d1\u05d0\u05d6", 1071);
    freq.put("\u05d1\u05d0\u05d5", 6670);
    freq.put("\u05d3\u05d9\u05e8", 1020);
    freq.put("\u05d1\u05e1", 9775);
    freq.put("\u05d1\u05e0", 12394);
    freq.put("\u05d1\u05e2", 20054);
    freq.put("\u05d1\u05e4", 5660);
    freq.put("\u05d1\u05e7", 6122);
    freq.put("\u05d1\u05e6", 5367);
    freq.put("\u05d1\u05e9", 16669);
    freq.put("\u05d1\u05e8", 44457);
    freq.put("\u05d1\u05ea", 15296);
    freq.put("\u05d2\u05d1\u05e8", 964);
    freq.put("\u05d1\u05d1", 4468);
    freq.put("\u05d1\u05d0", 28974);
    freq.put("\u05d1\u05d3", 9533);
    freq.put("ol", 1724);
    freq.put("\u05d1\u05d5", 37124);
    freq.put("\u05d1\u05d4", 14562);
    freq.put("\u05d1\u05d7", 6845);
    freq.put("\u05d1\u05d6", 1800);
    freq.put("\u05d1\u05d9", 60852);
    freq.put("\u05d1\u05d8", 3788);
    freq.put("\u05d1\u05db", 5400);
    freq.put("oc", 763);
    freq.put("\u05d1\u05dc", 12579);
    freq.put("\u05d1\u05df", 3469);
    freq.put("\u05d1\u05de", 24479);
    freq.put("\u05d1\u05d5\u05e2", 1416);
    freq.put("ou", 1121);
    freq.put("ot", 992);
    freq.put("os", 1322);
    freq.put("or", 3356);
    freq.put("op", 789);
    freq.put("\u05e8\u05d8 ", 4971);
    freq.put("\u05e1\u05e0", 2332);
    freq.put("\u05d1\u05de\u05d3", 1407);
    freq.put("\u05e1\u05e4\u05d5", 1293);
    freq.put("\u05dc\u05d0\u05d9", 1340);
    freq.put("\u05d4\u05d3\u05d9", 781);
    freq.put("\u05dc\u05d0\u05d7", 2966);
    freq.put("\u05dc\u05d0\u05d5", 4844);
    freq.put("\u05d4\u05d3\u05d5", 1789);
    freq.put("\u05e7\u05e6\u05d9", 1354);
    freq.put("\u05dc\u05e0\u05d9", 1139);
    freq.put("\u05d4\u05d3\u05e8", 1419);
    freq.put("\u05dc\u05d0\u05e8", 955);
    freq.put("\u05dc\u05d0\u05e1", 784);
    freq.put("\u05d1\u05de\u05d9", 1660);
    freq.put("\u0432", 941);
    freq.put("\u05db\u05e4\u05e8", 832);
    freq.put("\u05db\u05df ", 3170);
    freq.put("\u05e4\u05df ", 2293);
    freq.put("\u05e2\u05d6\u05e8", 762);
    freq.put(" \u05e8\u05db", 802);
    freq.put(" \u05e8\u05d9", 2280);
    freq.put("\u05e7\u05d5\u05e4", 3480);
    freq.put("\u0646", 836);
    freq.put(" \u05e8\u05d1", 4590);
    freq.put(" \u05e8\u05d0", 3404);
    freq.put(" \u05e8\u05d7", 840);
    freq.put("\u05d5\u05d5\u05df", 1540);
    freq.put(" \u05e8\u05d5", 6814);
    freq.put("\u05d0\u05d6 ", 1578);
    freq.put("\u05e1\u05e4\u05d8", 1488);
    freq.put("\u05d5\u05d5\u05d9", 6670);
    freq.put("\u05e1\u05e4\u05d9", 2004);
    freq.put("\u05d8\u05d9\u05e7", 2311);
    freq.put("\u05e7\u05d8\u05d9", 1305);
    freq.put(" \u05e8\u05e9", 1366);
    freq.put("he ", 1611);
    freq.put("\u05e2\u05d4 ", 5479);
    freq.put("\u05db\u05d9\u05e0", 1581);
    freq.put("\u05e7\u05d4\u05d9", 992);
    freq.put(" \u05e8\u05e7", 1211);
    freq.put(" \u05e8\u05e6", 860);
    freq.put(" \u05e8\u05e4", 810);
    freq.put("ac", 1575);
    freq.put("ad", 954);
    freq.put("ai", 824);
    freq.put("\u05d9\u05e2\u05d4", 1184);
    freq.put("\u05d4\u05df ", 3375);
    freq.put("am", 1581);
    freq.put("al", 3282);
    freq.put("an", 5294);
    freq.put("\u05de\u05e6\u05d0", 2270);
    freq.put("as", 1657);
    freq.put("ar", 4336);
    freq.put("au", 801);
    freq.put("at", 3174);
    freq.put("\u05d2\u05df ", 1860);
    freq.put("\u05d5\u05e8\u05da", 1570);
    freq.put("\u05dc\u05d2\u05d1", 764);
    freq.put("\u0631", 948);
    freq.put("\u05d2\u05d5\u05df", 2245);
    freq.put("a ", 5141);
    freq.put("\u05d3\u05d9\u05d5", 2800);
    freq.put("\u05d3\u05dc ", 1350);
    freq.put("\u05e6\u05d0\u05ea", 990);
    freq.put("\u05e0\u05db\u05ea", 1073);
    freq.put("\u05dc", 422282);
    freq.put("\u05d2\u05d5\u05d1", 1126);
    freq.put("\u05d3\u05d9\u05df", 785);
    freq.put("\u05d0\u05e8 ", 5565);
    freq.put("\u05e6\u05d0\u05d4", 819);
    freq.put("u", 12118);
    freq.put("\u05e8\u05db\u05ea", 2068);
    freq.put("\u05de\u05e1\u05e4", 3471);
    freq.put("\u05e0\u05d2\u05d3", 1024);
    freq.put("\u05e0\u05d2\u05dc", 9186);
    freq.put("\u05d8\u05e8\u05e0", 1010);
    freq.put("\u05d6\u05e8 ", 1170);
    freq.put("\u05d6 ", 8988);
    freq.put(" \u05d1\u05e0", 6905);
    freq.put("\u05e7\u05d3\u05d5", 1269);
    freq.put(" \u05d1\u05e1", 7728);
    freq.put("tt", 809);
    freq.put("tu", 790);
    freq.put("tr", 1218);
    freq.put("\u05d9\u05d0 ", 17223);
    freq.put("\u05e7\u05d3\u05de", 1302);
    freq.put("to", 1696);
    freq.put("\u05e8\u05db\u05d9", 2246);
    freq.put("th", 2015);
    freq.put("ti", 3191);
    freq.put("\u05b9", 1678);
    freq.put("\u0438", 1731);
    freq.put("te", 3049);
    freq.put("\u05e8\u05db\u05d6", 2614);
    freq.put("\u05e0\u05d2\u05e8", 1057);
    freq.put("\u05e8\u05db\u05d4", 807);
    freq.put("ta", 1915);
    freq.put("\u05e1\u05e8 ", 1369);
    freq.put("\u05db\u05dc ", 4979);
    freq.put("al ", 1171);
    freq.put("\u05de\u05db\u05d5", 2726);
    freq.put("\u05de\u05db\u05d9", 1235);
    freq.put("\u05d9\u05d8 ", 1800);
    freq.put("rn", 818);
    freq.put("\u05d4 ", 204656);
    freq.put("ro", 2308);
    freq.put(" \u05e0\u05e4", 2034);
    freq.put("ge", 1176);
    freq.put("\u05d9\u05e7\u05e8", 3694);
    freq.put("\u05d5\u05e4 ", 863);
    freq.put(" \u05d5 ", 2034);
    freq.put("\u05d4\u05db\u05dc", 1158);
    freq.put("t ", 3529);
    freq.put(" \u05db\u05e4", 1233);
    freq.put("\u05d5\u05e1\u05d8", 3543);
    freq.put("\u05e9\u05e9", 1558);
    freq.put("\u05e9\u05e8", 23791);
    freq.put("\u05e9\u05ea", 9019);
    freq.put("\u05e6\u05d5\u05e2", 1224);
    freq.put("\u05e9\u05e0", 26253);
    freq.put("ter", 1142);
    freq.put("\u05e9\u05e2", 3886);
    freq.put("\u05e6\u05d5\u05ea", 4135);
    freq.put("\u05e9\u05e4", 9870);
    freq.put("\u05e9\u05e7", 2676);
    freq.put("\u05e9\u05d9", 32057);
    freq.put("\u05e9\u05d8", 3529);
    freq.put("\u05e9\u05db", 3883);
    freq.put("\u05e9\u05da", 1218);
    freq.put("\u05e9\u05dd", 6738);
    freq.put("\u05e9\u05dc", 59496);
    freq.put("\u05e9\u05de", 16387);
    freq.put("\u05e9\u05d1", 15227);
    freq.put("\u05e9\u05d0", 5518);
    freq.put("\u05e9\u05d3", 1381);
    freq.put("\u05e9\u05d2", 2036);
    freq.put("\u05e9\u05d5", 28172);
    freq.put("\u05e9\u05d4", 14417);
    freq.put("\u05e9\u05d7", 6900);
    freq.put("\u05e6\u05d5\u05d9", 1042);
    freq.put(" \u05db\u05d2", 1001);
    freq.put("\u05dc\u05e7\u05d8", 1068);
    freq.put("\u05dc\u05e7\u05d9", 2709);
    freq.put("\u05de\u05d5\u05ea", 5842);
    freq.put("\u05de\u05d5\u05e8", 3868);
    freq.put(" \u05db\u05d3", 2689);
    freq.put("\u05de\u05d5\u05e6", 2037);
    freq.put("\u05de\u05d5\u05e7", 2142);
    freq.put("K", 1288);
    freq.put("\u05de\u05d5\u05e2", 3080);
    freq.put("\u05de\u05d5\u05e0", 5841);
    freq.put("\u05de\u05d5\u05e1", 2260);
    freq.put(" \u05db\u05d1", 1385);
    freq.put(" \u05db\u05d7", 844);
    freq.put("\u05e9\u05d7\u05e7", 4451);
    freq.put("\u05d8\u05e0\u05d9", 1443);
    freq.put("\u05ea\u05de\u05d8", 1174);
    freq.put(" \u05db\u05d5", 3554);
    freq.put("\u05de\u05d5\u05df", 1066);
    freq.put("\u05de\u05d5\u05dc", 1345);
    freq.put("\u05de\u05d5\u05db", 1297);
    freq.put("\u05de\u05d5\u05d9", 943);
    freq.put("\u05de\u05d5\u05d6", 5024);
    freq.put("\u05de\u05d5\u05d7", 898);
    freq.put("\u05de\u05d5\u05d2", 886);
    freq.put("\u05de\u05d5\u05d3", 3483);
    freq.put("\u05de\u05d5\u05d1", 939);
    freq.put("\u05db\u05d3", 4207);
    freq.put("\u05db\u05d2", 1009);
    freq.put("\u05db\u05d1", 6283);
    freq.put(" \u05db\u05d9", 5212);
    freq.put("\u05db\u05d7", 1672);
    freq.put("\u05db\u05d6", 3111);
    freq.put("\u05db\u05d5", 21072);
    freq.put("\u05db\u05d4", 6173);
    freq.put("\u05db\u05db", 754);
    freq.put(" \u05db\u05de", 3311);
    freq.put("\u05db\u05d9", 15596);
    freq.put("\u05db\u05df", 3171);
    freq.put("\u05db\u05de", 4368);
    freq.put("\u05db\u05dd", 777);
    freq.put("\u05db\u05dc", 14948);
    freq.put("\u05d1\u05ea\u05d9", 1021);
    freq.put("\u05e7\u05d5\u05e0", 1555);
    freq.put("\u05d2\u05e0", 4603);
    freq.put(" \u05db\u05dc", 6776);
    freq.put("\u05d2\u05e2", 907);
    freq.put("\u05d9\u05de\u05e4", 1867);
    freq.put("\u05dc\u05de\u05d9", 2394);
    freq.put("\u05d2\u05e8", 12191);
    freq.put("\u05d2\u05e9", 1319);
    freq.put("\u05d2\u05ea", 2080);
    freq.put("ve", 1332);
    freq.put("\u05d2\u05d4", 2711);
    freq.put("\u05d2\u05d5", 18230);
    freq.put("\u05d2\u05d6", 1369);
    freq.put("\u05d2\u05d0", 2681);
    freq.put("\u05d2\u05d1", 4647);
    freq.put("\u05d2\u05d3", 7511);
    freq.put("\u05d2\u05dc", 15851);
    freq.put("\u05d2\u05dd", 5839);
    freq.put("\u05d2\u05de", 1889);
    freq.put("\u05d2\u05df", 1862);
    freq.put("\u05d2\u05d9", 15377);
    freq.put("\u05e8\u05d7 ", 1986);
    freq.put("\u05d1\u05ea\u05e7", 1270);
    freq.put("\u05dc\u05de\u05d5", 2080);
    freq.put("\u05db\u05e1", 2535);
    freq.put("\u05db\u05e0", 8682);
    freq.put(" \u05d7\u05d3", 1040);
    freq.put("\u05db\u05e4", 2033);
    freq.put(" \u05d7\u05de", 880);
    freq.put("\u05db\u05ea", 9752);
    freq.put("\u05db\u05e9", 2355);
    freq.put("\u05db\u05e8", 5552);
    freq.put("\u05e4\u05dc\u05d9", 1158);
    freq.put("\u05d5\u05e2\u05ea", 846);
    freq.put(" \u05d7\u05d9", 4768);
    freq.put("\u05e8\u05d9 ", 10968);
    freq.put("\u05e0\u05e7\u05d5", 1045);
    freq.put("St", 822);
    freq.put("\u05d5\u05de\u05d8", 1282);
    freq.put("\u05d5\u05d4\u05d0", 894);
    freq.put("\u05d5\u05d4\u05d5", 1891);
    freq.put("\u05d5\u05d4\u05d9", 2099);
    freq.put("\u05d5\u05d4\u05de", 1272);
    freq.put("\u05e3", 12208);
    freq.put(" de", 821);
    freq.put("\u05d1\u05d5\u05ea", 6458);
    freq.put("\u05e0\u05e7\u05e6", 758);
    freq.put("\u05d9\u05e8\u05d9", 3756);
    freq.put("v", 3224);
    freq.put("\u05d9\u05e8\u05d0", 823);
    freq.put("\u05e4\u05e7\u05d9", 1813);
    freq.put("\u05e0\u05e7\u05e8", 1955);
    freq.put("\u05e4\u05d8 ", 1621);
    freq.put("f ", 1405);
    freq.put("\u05d1\u05e0\u05d5", 3853);
    freq.put("\u05d1\u05d4\u05d5", 872);
    freq.put("\u05d0\u05ea\u05e8", 938);
    freq.put("\u05d1\u05d4\u05dd", 920);
    freq.put("\u05d1\u05d4\u05d9", 972);
    freq.put("\u05dc\u05d3 ", 5523);
    freq.put("\u05b8", 1859);
    freq.put("\u05e2\u05d5 ", 882);
    freq.put("\u05d4\u05d9\u05e8", 1734);
    freq.put("\u05d4\u05d9\u05e9", 1505);
    freq.put("\u05d4\u05d9\u05e0", 2071);
    freq.put("of ", 1020);
    freq.put("\u05d3\u05d1\u05e8", 1224);
    freq.put("\u05d2\u05dc ", 2819);
    freq.put("a", 34025);
    freq.put("us ", 1690);
    freq.put("\u05db\u05ea\u05d5", 1006);
    freq.put("\u05db\u05ea ", 4160);
    freq.put("\u05d5\u05e1\u05e4", 1419);
    freq.put("\u05d4\u05d9\u05dc", 1466);
    freq.put("\u05d4\u05d9\u05dd", 937);
    freq.put("\u05d4\u05d9\u05d9", 4423);
    freq.put("\u05d4\u05d9\u05d4", 10243);
    freq.put("\u05d4\u05d9\u05d5", 4371);
    freq.put("\u05d4\u05d9\u05d7", 928);
    freq.put("\u05d4\u05d9\u05d0", 15411);
    freq.put("\u05d5\u05d8\u05d9", 1439);
    freq.put("\u05d4\u05d9\u05d2", 810);
    freq.put("\u05d4\u05d9\u05d3", 1593);
    freq.put("\u05db\u05ea\u05d9", 946);
    freq.put("\u05dc\u05d2\u05d5", 927);
    freq.put("y ", 3108);
    freq.put("\u05d5\u05d0\u05d9", 2839);
    freq.put("\u05d1\u05d5 ", 4295);
    freq.put("\u05de\u05d8\u05d9", 1746);
    freq.put("\u05d5\u05d0\u05d4", 1373);
    freq.put("\u05e7\u05d5\u05d3", 2387);
    freq.put("\u05d4\u05e4\u05d5", 2450);
    freq.put("\u05d5\u05d0\u05d5", 1083);
    freq.put("\u05d0\u05e9 ", 2340);
    freq.put("\u05e9\u05ea\u05d9", 1677);
    freq.put("\u05de\u05d8\u05e8", 3264);
    freq.put("\u05e9\u05ea\u05de", 820);
    freq.put("\u05dc\u05de\u05e9", 1364);
    freq.put("\u05e7\u05d5\u05d5", 1390);
    freq.put("\u05e9\u05e4\u05d8", 1854);
    freq.put("\u05e9\u05e4\u05d9", 949);
    freq.put("\u05e9\u05e4\u05d7", 2708);
    freq.put("\u05e9\u05e4\u05d4", 1050);
    freq.put("\u05e9\u05e4\u05d5", 1080);
    freq.put("L", 2999);
    freq.put("\u05e8\u05ea", 19384);
    freq.put("\u05e8\u05e8", 1758);
    freq.put("\u05e8\u05e9", 6651);
    freq.put("\u05d7\u05e9\u05d1", 3253);
    freq.put("\u05e8\u05e2", 2837);
    freq.put("\u05e8\u05e0", 6801);
    freq.put("\u05e8\u05e1", 9590);
    freq.put("\u05e8\u05e6", 5822);
    freq.put("\u05e8\u05e7", 7125);
    freq.put("\u05e8\u05e4", 7179);
    freq.put("\u05e8\u05e5", 4177);
    freq.put("\u05e8\u05da", 5453);
    freq.put("\u05e8\u05db", 12424);
    freq.put("\u05e8\u05d8", 11059);
    freq.put("\u05e8\u05d9", 69906);
    freq.put("\u05e5", 10248);
    freq.put("\u05e8\u05df", 1612);
    freq.put("\u05e8\u05dc", 4398);
    freq.put("\u05e8\u05dd", 1942);
    freq.put("\u05e8\u05d2", 11231);
    freq.put("\u05e8\u05d3", 8475);
    freq.put("\u05e8\u05d0", 29022);
    freq.put("\u05e8\u05d1", 18351);
    freq.put("\u05e8\u05d6", 1504);
    freq.put("\u05e8\u05d7", 8185);
    freq.put("\u05e8\u05d4", 18046);
    freq.put("\u05e8\u05d5", 57537);
    freq.put("\u05e7\u05d5\u05dd", 1590);
    freq.put("\u05d2\u05ea ", 1847);
    freq.put("\u05e7\u05d5\u05dc", 4389);
    freq.put("\u05e9\u05e4\u05e2", 1069);
    freq.put("\u05e1\u05e1", 1542);
    freq.put(" \u05d6 ", 1154);
    freq.put("\u05e1\u05e3", 1568);
    freq.put("\u05e1\u05e2", 1202);
    freq.put("\u05e1\u05e4", 16242);
    freq.put("\u05e1\u05e7", 6961);
    freq.put("\u05e1\u05e8", 7306);
    freq.put("\u05dc\u05e0\u05d5", 2241);
    freq.put("\u05e1\u05ea", 3711);
    freq.put("\u05dc\u05e0\u05d3", 1704);
    freq.put("\u05d5\u05d7\u05d5", 1384);
    freq.put("\u05d9\u05df ", 20713);
    freq.put("\u05db\u05d5\u05ea", 3899);
    freq.put("\u05e1\u05d1", 2454);
    freq.put("\u05e1\u05d0", 1865);
    freq.put("\u05e1\u05d3", 6581);
    freq.put("\u05e1\u05d2", 2607);
    freq.put("\u05e1\u05d5", 21766);
    freq.put("\u05e1\u05d4", 2338);
    freq.put("\u05e1\u05d7", 1327);
    freq.put("\u05d5\u05e3 ", 4256);
    freq.put("\u05e1\u05d9", 26035);
    freq.put("\u05e1\u05d8", 14456);
    freq.put("\u05e1\u05db", 1718);
    freq.put("\u05e1\u05dd", 1071);
    freq.put("\u05e1\u05dc", 4205);
    freq.put("\u05e1\u05de", 4060);
    freq.put("\u05d5\u05e1\u05d9", 4415);
    freq.put("\u05d5\u05de\u05d3", 1168);
    freq.put(" \u05d8\u05e8", 1404);
    freq.put("\u05de\u05d4 ", 11039);
    freq.put("\u05d5\u05e1\u05d3", 1576);
    freq.put("\u05e3 ", 12199);
    freq.put("\u05d5\u05e1\u05d5", 1601);
    freq.put("\u05d1\u05e9\u05dd", 1347);
    freq.put("\u05d1\u05e9\u05dc", 1420);
    freq.put("\u05d1\u05e9\u05de", 809);
    freq.put("\u05d1\u05e9\u05d9", 1378);
    freq.put("\u05d5\u05de\u05d4", 2366);
    freq.put("\u05e9\u05d0 ", 795);
    freq.put("\u05d0", 355837);
    freq.put("\u05d1\u05e9\u05e0", 7415);
    freq.put(" \u05d8\u05d9", 1699);
    freq.put("w", 2312);
    freq.put(" \u05d8\u05dc", 1002);
    freq.put("\u05d5\u05e1\u05e1", 1023);
    freq.put("\u05d7\u05d5\u05e7", 2664);
    freq.put(" \u05d8\u05d1", 768);
    freq.put("\u05d5\u05de\u05d5", 3468);
    freq.put(" \u05d8\u05d5", 2163);
    freq.put("\u05d2\u05e8\u05d9", 1714);
    freq.put("\u05d2\u05e8\u05de", 3486);
    freq.put("\u05d3\u05e2\u05d9", 2475);
    freq.put("\u05d2\u05e8\u05d5", 886);
    freq.put("\u05e6\u05d4 ", 4704);
    freq.put("\u05d4\u05e4\u05d9", 1400);
    freq.put("\u05d5\u05d3\u05d4", 2328);
    freq.put("\u05d5\u05d3\u05dc", 997);
    freq.put("\u05e0\u05df ", 997);
    freq.put("\u05d7\u05e7 ", 2379);
    freq.put("\u05d4\u05e4\u05e8", 2442);
    freq.put("\u05d5\u05d3\u05e2", 1169);
    freq.put("\u05d4\u05e4\u05e2", 812);
    freq.put("\u05d4\u05e4\u05e1", 746);
    freq.put("\u05da ", 21128);
    freq.put("\u05d5\u05d3\u05ea", 964);
    freq.put("\u05d5\u05d3\u05e8", 1718);
    freq.put("\u05e4\u05e0\u05d4", 1015);
    freq.put("\u043a", 858);
    freq.put("\u05d2\u05e8\u05e4", 891);
    freq.put("\u05e4\u05e0\u05d9", 3690);
    freq.put("\u05d1\u05d2\u05d5", 776);
    freq.put("\u05d5\u05e2\u05d3", 3169);
    freq.put("\u05d1\u05db\u05d9", 1314);
    freq.put("b", 4292);
    freq.put("\u05d1\u05db\u05dc", 1398);
    freq.put("\u05de\u05e1 ", 899);
    freq.put("\u05d7\u05d9 ", 1719);
    freq.put("\u05d5\u05e2\u05dc", 2118);
    freq.put("\u05e8\u05da ", 5443);
    freq.put("\u05de\u05e0\u05ea", 816);
    freq.put("\u05de\u05e9\u05d9", 1615);
    freq.put("\u05d2\u05d3\u05e8", 1056);
    freq.put("\u05d3\u05d5\u05dd", 754);
    freq.put("k ", 1105);
    freq.put("\u05d0\u05e1\u05d9", 1374);
    freq.put("\u05d5\u05d5\u05e0", 2693);
    freq.put("\u05e6\u05ea ", 2388);
    freq.put("\u05de\u05e0\u05d9", 6289);
    freq.put("\u05de\u05e0\u05d8", 976);
    freq.put("\u05de\u05e0\u05d5", 2766);
    freq.put("\u05de\u05e0\u05d4", 2231);
    freq.put("\u05e4\u05d9 ", 4902);
    freq.put("\u05e1\u05d4 ", 2203);
    freq.put("\u05db\u05e8 ", 1517);
    freq.put("\u05e2\u05d3\u05d5", 1037);
    freq.put("M", 4837);
    freq.put("\u05d0\u05d9\u05e8", 3360);
    freq.put("\u05d0\u05d9\u05e9", 1805);
    freq.put("\u05d0\u05d9\u05ea", 2756);
    freq.put("\u05d0\u05d9\u05e0", 4275);
    freq.put("\u05d0\u05d9\u05e1", 807);
    freq.put("The", 1046);
    freq.put("\u05d0\u05d9\u05d8", 1941);
    freq.put("\u05d0\u05d9\u05d9", 2254);
    freq.put("\u05d0\u05d9\u05dc", 857);
    freq.put("\u05e4", 163464);
    freq.put("\u05d0\u05d9\u05de", 1541);
    freq.put("\u05d0\u05d9\u05df", 766);
    freq.put("\u05d0\u05d9\u05d5", 924);
    freq.put("\u05dc\u05dc ", 3884);
    freq.put("\u05de\u05e2\u05e9", 819);
    freq.put("\u05de\u05e2\u05e8", 4843);
    freq.put("\u05d1\u05dc\u05d9", 2952);
    freq.put("\u05d3\u05d5\u05ea", 4827);
    freq.put("\u05d1\u05dc\u05d5", 1708);
    freq.put("\u05d2\u05dc\u05d9", 10256);
    freq.put("\u05d2\u05dc\u05d5", 929);
    freq.put("\u05d3\u05de\u05d9", 1260);
    freq.put("\u05de\u05e2\u05dc", 1128);
    freq.put("\u05de\u05e2\u05d1", 969);
    freq.put("\u05de\u05e2\u05d5", 2266);
    freq.put("\u05d3\u05dc\u05d9", 756);
    freq.put("\u05e4\u05d5\u05e0", 2515);
    freq.put("\u05e1\u05d5\u05e3", 1248);
    freq.put("\u05dc\u05d3\u05d5", 1001);
    freq.put("\u05e1\u05d5\u05e4", 3199);
    freq.put("\u05e2\u05d5\u05dc", 5515);
    freq.put("\u05e1\u05d5\u05e8", 2397);
    freq.put("\u05e1\u05d5\u05ea", 809);
    freq.put("\u05dc\u05d3\u05d9", 1178);
    freq.put("\u05d1\u05d4 ", 7790);
    freq.put("\u05d1\u05dc\u05ea", 1123);
    freq.put(" \u05d4\u05db", 7288);
    freq.put("\u05d0\u05d7\u05e8", 6475);
    freq.put("\u05e1", 156906);
    freq.put("\u05d2\u05dd ", 5839);
    freq.put("\u05d0\u05d7\u05d3", 3813);
    freq.put("\u05d0\u05ea ", 15913);
    freq.put("\u05e1\u05d5\u05d1", 810);
    freq.put("\u05e1\u05d5\u05d3", 1173);
    freq.put("\u05e1\u05d5\u05d2", 2713);
    freq.put("\u05e1\u05d5\u05d9", 1607);
    freq.put("x", 3018);
    freq.put("\u05e2\u05d5\u05e0", 916);
    freq.put("\u05e2\u05d5\u05e1", 1354);
    freq.put("\u05e1\u05d5\u05dc", 1222);
    freq.put("\u05e1\u05d5\u05df", 1399);
    freq.put("\u05e8\u05d9\u05e0", 921);
    freq.put("\u05e4\u05d8\u05de", 1413);
    freq.put("\u05e4\u05d8\u05d9", 1246);
    freq.put("\u05e8\u05d9\u05e7", 5899);
    freq.put("\u05e0\u05d0\u05d9", 1779);
    freq.put("\u05d5\u05e6\u05d0", 2429);
    freq.put("\u05d0\u05d5\u05e8", 6849);
    freq.put("\u05d5\u05d4 ", 2998);
    freq.put("\u05d5\u05e6\u05d5", 1018);
    freq.put("\u05e8\u05d9\u05d0", 2270);
    freq.put("\u05e7\u05d1\u05dc", 961);
    freq.put("\u05e8\u05d9\u05d4", 4718);
    freq.put("\u05e8\u05d9\u05d5", 3530);
    freq.put("\u05e0\u05e7 ", 1115);
    freq.put("\u05b6", 1684);
    freq.put("\u05e4\u05d5\u05e4", 985);
    freq.put("\u05e8\u05d9\u05d9", 3646);
    freq.put("\u05e7\u05d1\u05d5", 5125);
    freq.put("\u05e8\u05d9\u05db", 1158);
    freq.put("\u05e8\u05d9\u05dc", 1756);
    freq.put("\u05e8\u05d9\u05dd", 13911);
    freq.put("\u05d7\u05de\u05d4", 852);
    freq.put("\u05d7\u05de\u05d9", 1161);
    freq.put("\u05d2 ", 17864);
    freq.put("\u05e8\u05d7\u05d9", 1692);
    freq.put("\u05e8\u05d7\u05d5", 949);
    freq.put("\u05e8\u05d7\u05d1", 1963);
    freq.put("\u05d4\u05d5\u05e8", 1218);
    freq.put("c", 11175);
    freq.put("\u05e8\u05d7\u05e9", 787);
    freq.put("\u05d1\u05ea ", 4691);
    freq.put("\u05d0\u05dc\u05d5", 1949);
    freq.put(" Pa", 776);
    freq.put("\u05db ", 3096);
    freq.put("\u05d5\u05e2 ", 5599);
    freq.put("\u05d7\u05de\u05ea", 1678);
    freq.put("\u05d0\u05dc\u05d1", 2498);
    freq.put("\u05de\u05d5 ", 5183);
    freq.put("\u05d4\u05d5\u05e0", 877);
    freq.put("\u05e0\u05de\u05e6", 1867);
    freq.put("\u05de\u05e7\u05e8", 1322);
    freq.put("px", 1778);
    freq.put("\u05d4\u05d5\u05e6", 992);
    freq.put("pe", 961);
    freq.put("ph", 746);
    freq.put("\u05de\u05d7\u05e7", 931);
    freq.put("\u05d6\u05de\u05df", 1228);
    freq.put("\u05de\u05d7\u05e9", 1462);
    freq.put("N", 2358);
    freq.put("\u05e9 ", 18495);
    freq.put(" \u05e2\u05e0", 811);
    freq.put("\u05de\u05d7\u05d5", 2697);
    freq.put("\u05de\u05d7\u05d6", 1008);
    freq.put("\u05de\u05d7\u05dc", 1800);
    freq.put("\u05de\u05d7\u05d9", 970);
    freq.put("\u05d6\u05de\u05e8", 1390);
    freq.put(" \u05d5\u05dc", 4945);
    freq.put(" \u05d5\u05de", 9400);
    freq.put(" \u05d5\u05d9", 4333);
    freq.put("\u05d5\u05e4\u05d4", 2721);
    freq.put(" \u05d5\u05db", 2933);
    freq.put(" \u05d5\u05d4", 11812);
    freq.put(" \u05d5\u05d5", 1631);
    freq.put(" \u05d5\u05d6", 955);
    freq.put(" \u05d5\u05d7", 1862);
    freq.put(" \u05d5\u05d0", 5274);
    freq.put(" \u05d5\u05d1", 8620);
    freq.put(" \u05d5\u05d2", 1290);
    freq.put(" \u05d5\u05d3", 892);
    freq.put("\u05d9\u05d8\u05ea", 1710);
    freq.put("\u05d9\u05d8\u05e8", 974);
    freq.put("\u05d1\u05e4\u05d5", 753);
    freq.put("\u05d4\u05ea", 16129);
    freq.put("\u05d4\u05e8", 18303);
    freq.put("\u05d4\u05e9", 20373);
    freq.put("\u05d4\u05e6", 7002);
    freq.put("\u05d4\u05e7", 13593);
    freq.put("\u05d4\u05e4", 12266);
    freq.put("\u05d4\u05e2", 15156);
    freq.put("\u05d4\u05e0", 11770);
    freq.put("\u05d4\u05e1", 11464);
    freq.put("\u05d4\u05de", 50070);
    freq.put("\u05d4\u05df", 3379);
    freq.put("\u05d4\u05dc", 10568);
    freq.put("\u05d4\u05dd", 6285);
    freq.put("\u05e9\u05d1\u05d9", 2213);
    freq.put("\u05d4\u05db", 8371);
    freq.put("\u05d4\u05d8", 3770);
    freq.put("\u05d4\u05d9", 51622);
    freq.put("\u05d4\u05d6", 2998);
    freq.put("\u05d4\u05d7", 11926);
    freq.put("\u05d4\u05d4", 6606);
    freq.put("\u05d4\u05d5", 49027);
    freq.put("\u05d4\u05d2", 10416);
    freq.put("\u05d4\u05d3", 6369);
    freq.put("\u05d4\u05d0", 24412);
    freq.put("\u05d4\u05d1", 13059);
    freq.put("\u05d5\u05e4\u05e2", 1474);
    freq.put("\u05db\u05dc\u05d5", 1791);
    freq.put("\u05d5\u05e4\u05e1", 1055);
    freq.put(" \u05d5\u05e8", 2477);
    freq.put(" \u05d5\u05e9", 2610);
    freq.put(" \u05d5\u05ea", 1633);
    freq.put(" \u05d5\u05e4", 2170);
    freq.put("\u05e1\u05e8\u05d8", 3915);
    freq.put("\u05e1\u05e8\u05d9", 1021);
    freq.put(" \u05d5\u05e0", 3060);
    freq.put(" \u05d5\u05e1", 1644);
    freq.put(" \u05d5\u05e2", 3597);
    freq.put("\u05db\u05dc\u05db", 1033);
    freq.put("\u05d6\u05d0", 1585);
    freq.put("\u05d6\u05d4", 6566);
    freq.put("\u05d6\u05d5", 10251);
    freq.put("\u05d6\u05d9", 12406);
    freq.put("\u05d6\u05db", 3534);
    freq.put("\u05d6\u05dc", 838);
    freq.put("\u05d6\u05dd", 1284);
    freq.put("\u05d6\u05de", 4439);
    freq.put("\u05d6\u05e0", 886);
    freq.put("\u05e0", 265593);
    freq.put("\u05d6\u05e2", 2250);
    freq.put("\u05d0\u05d5\u05d7", 876);
    freq.put("\u05d6\u05e7", 1127);
    freq.put("\u05d6\u05e8", 6935);
    freq.put("\u05d6\u05e8\u05d7", 2887);
    freq.put("\u05d9\u05ea\u05d4", 3362);
    freq.put("\u05e0\u05d2 ", 1904);
    freq.put("y", 5684);
    freq.put("\u05d1\u05e6\u05e8", 1026);
    freq.put("\u05d9\u05ea\u05df", 1501);
    freq.put("\u05dc\u05dc\u05d9", 1608);
    freq.put("\u05d0\u05d8\u05e8", 826);
    freq.put("\u05d0\u05d9 ", 11190);
    freq.put("\u05db\u05e8\u05d9", 914);
    freq.put("\u05d1\u05e6\u05e2", 1020);
    freq.put("\u05dc\u05dd ", 5107);
    freq.put("\u05ea\u05db\u05d5", 755);
    freq.put("\u05e2\u05d3 ", 4359);
    freq.put("\u05db\u05e8\u05d5", 1009);
    freq.put("\u05e4\u05d9\u05dc", 2559);
    freq.put("\u05e4\u05d9\u05dd", 2239);
    freq.put("\u05e4\u05d9\u05d9", 2109);
    freq.put("\u05e0\u05d1\u05d7", 833);
    freq.put("\u05e4\u05d9\u05d4", 1485);
    freq.put("\u05e4\u05d9\u05d5", 1127);
    freq.put("\u05e4\u05d9\u05d6", 1279);
    freq.put("d", 10934);
    freq.put("\u05e4\u05d9\u05e8", 2169);
    freq.put("\u05e7\u05d0\u05d9", 4278);
    freq.put("\u05e4\u05d9\u05ea", 1710);
    freq.put("\u05e4\u05d9\u05e7", 1363);
    freq.put("\u05e4\u05d9\u05e0", 1223);
    freq.put("\u05e4\u05d9\u05e2", 1348);
    freq.put("\u05d7\u05d9\u05d5", 928);
    freq.put("\u05d7\u05d9\u05d3", 1965);
    freq.put("\u05e1\u05d8 ", 2719);
    freq.put("\u05d7\u05d9\u05dd", 2086);
    freq.put("\u05d7\u05d9\u05dc", 2274);
    freq.put("\u05d7\u05d9\u05d9", 3491);
    freq.put("\u05dc\u05e9\u05d9", 1010);
    freq.put("\u05d8\u05d1\u05e2", 1372);
    freq.put("\u05d7\u05d9\u05e0", 1388);
    freq.put("\u05d7\u05d9\u05ea", 881);
    freq.put("\u05d7\u05d9\u05e8", 890);
    freq.put("be", 993);
    freq.put("O", 1895);
    freq.put("\u05db\u05d1\u05d9", 2214);
    freq.put("\u05e2", 168037);
    freq.put("\u05d5\u05d3 ", 6343);
    freq.put("\u05db\u05d1\u05ea", 844);
    freq.put("\u05d3\u05e2 ", 2354);
    freq.put("\u05d2\u05e8 ", 827);
    freq.put("\u05e0\u05e8 ", 886);
    freq.put("\u05d0\u05e4\u05d9", 1390);
    freq.put("\u05e9\u05d0\u05d9", 1679);
    freq.put("\u05d9\u05d5\u05df", 4211);
    freq.put("\u05e9\u05d0\u05e8", 864);
    freq.put("\u05dc\u05d8\u05d5", 1868);
    freq.put("\u05de\u05d4\u05dc", 1373);
    freq.put("\u05b7", 1974);
    freq.put("\u05de\u05d4\u05de", 885);
    freq.put("\u05d5\u05e1 ", 5753);
    freq.put("\u05de\u05d4\u05d5", 1225);
    freq.put("\u05e1 ", 23921);
    freq.put(" Co", 1129);
    freq.put(" \u05d6\u05e8", 823);
    freq.put(" Ca", 896);
    freq.put("\u05d0\u05d9\u05dd", 3388);
    freq.put("\u05d9\u05dd ", 101313);
    freq.put("us", 2545);
    freq.put("ur", 1480);
    freq.put("um", 935);
    freq.put("ul", 958);
    freq.put("un", 962);
    freq.put(" \u05d6\u05d5", 3424);
    freq.put(" \u05d6\u05d4", 3518);
    freq.put(" \u05d6\u05d9", 910);
    freq.put("\u05d9\u05e6\u05d0", 1573);
    freq.put(" \u05d6\u05db", 1452);
    freq.put("z", 1550);
    freq.put("\u05d6\u05dd ", 1283);
    freq.put(" \u05d6\u05de", 1557);
    freq.put("\u05e4\u05d5\u05e8", 5443);
    freq.put("\u05e0\u05e6\u05d9", 1255);
    freq.put("\u05d9\u05e9\u05e8", 9232);
    freq.put("\u05d4\u05ea\u05d0", 1307);
    freq.put("\u05d4\u05ea\u05d5", 1514);
    freq.put("Th", 1329);
    freq.put("\u05d4\u05ea\u05d9", 1325);
    freq.put("\u05e8 ", 101491);
    freq.put("\u05d4\u05ea\u05de", 749);
    freq.put("A ", 1146);
    freq.put("\u05e1\u05e3 ", 1568);
    freq.put("\u05d4\u05ea\u05e4", 1798);
    freq.put("\u05d4\u05ea\u05e7", 1851);
    freq.put("\u05d5\u05d1\u05d5", 2126);
    freq.put("\u05e4\u05e9", 3647);
    freq.put("\u05d9\u05e9\u05d5", 3196);
    freq.put(" \u05d9 ", 1129);
    freq.put("\u05e4\u05d5\u05e1", 1005);
    freq.put("\u05d5\u05d3\u05d5", 2620);
    freq.put("\u05d9\u05e9\u05d9", 4067);
    freq.put("\u05e0\u05d5\u05d0", 1590);
    freq.put("\u05e0\u05d5\u05d1", 2639);
    freq.put("\u05e9\u05ea ", 3670);
    freq.put("\u05d0\u05e9\u05d9", 2353);
    freq.put("\u05ea\u05e8\u05d2", 858);
    freq.put("\u05ea\u05e8\u05d5", 1096);
    freq.put("\u05e4\u05d5\u05e6", 750);
    freq.put("\u05ea\u05e8\u05d7", 857);
    freq.put("\u05d1\u05d5\u05e6", 4259);
    freq.put("\u05d1\u05d5\u05e8", 4953);
    freq.put("\u05e4\u05e1", 4846);
    freq.put("\u05d0\u05e9\u05d5", 5612);
    freq.put("\u05d0\u05e9\u05e8", 5633);
    freq.put("\u05d5\u05d5\u05dc", 1093);
    freq.put("\u05d1\u05d5\u05d3", 2124);
    freq.put("e", 38551);
    freq.put("\u05d1\u05d5\u05d4", 789);
    freq.put("\u05d1\u05d5\u05d9", 829);
    freq.put("\u05d5\u05d5\u05d4", 2251);
    freq.put("\u05d5\u05de\u05d0", 1433);
    freq.put("\u05d1\u05d5\u05dd", 1558);
    freq.put("\u05d1\u05d5\u05dc", 2422);
    freq.put("\u05d4\u05e6\u05e4", 881);
    freq.put("\u05e8\u05d5\u05d0", 1983);
    freq.put("\u05df ", 91356);
    freq.put("\u05d5\u05de\u05e0", 2251);
    freq.put(" c", 818);
    freq.put(" a", 1241);
    freq.put(" d", 1423);
    freq.put("\u05d5\u05de\u05e8", 2913);
    freq.put("\u05d5\u05de\u05e9", 1030);
    freq.put("\u05d5\u05de\u05ea", 1301);
    freq.put(" o", 1293);
    freq.put("\u05e8\u05dc ", 1007);
    freq.put(" s", 1080);
    freq.put(" p", 2507);
    freq.put("\u05d7\u05d5 ", 753);
    freq.put(" t", 1122);
    freq.put("\u05e8\u05d5\u05dd", 2275);
    freq.put(" \u05db\u05ea", 1870);
    freq.put(" \u05db\u05e8", 1353);
    freq.put(" \u05db\u05e9", 1438);
    freq.put(" B", 3287);
    freq.put(" C", 4445);
    freq.put(" \u05db\u05d0", 2275);
    freq.put(" A", 4293);
    freq.put(" F", 2284);
    freq.put(" G", 2345);
    freq.put(" D", 2725);
    freq.put(" E", 1939);
    freq.put(" J", 1761);
    freq.put(" K", 1182);
    freq.put(" H", 2237);
    freq.put(" I", 2087);
    freq.put(" N", 1804);
    freq.put(" O", 1286);
    freq.put(" L", 2498);
    freq.put(" M", 4152);
    freq.put(" R", 2670);
    freq.put(" S", 4832);
    freq.put(" P", 3269);
    freq.put("\u05e2\u05e8\u05da", 1379);
    freq.put(" V", 962);
    freq.put(" W", 1618);
    freq.put(" T", 3332);
    freq.put("\u05d5\u05de\u05d7", 813);
    freq.put("\u05e2\u05e8\u05d1", 4397);
    freq.put("\u05d5\u05de\u05d9", 8418);
    freq.put("\u05e0\u05d3 ", 1870);
    freq.put("\u05e2\u05e8\u05d5", 1170);
    freq.put("\u05d4\u05e7\u05d3", 827);
    freq.put("\u05d4\u05e7\u05d1", 1121);
    freq.put("\u05d4\u05e7\u05d4", 1071);
    freq.put("\u05d4\u05e7\u05d5", 2620);
    freq.put("\u05d4\u05e7\u05d9", 1474);
    freq.put("\u05e2\u05d9\u05dc", 2019);
    freq.put("\u05d4\u05e7\u05dc", 776);
    freq.put("P", 3992);
    freq.put("\u05d5\u05d0\u05dc", 1667);
    freq.put("\u05e8\u05d5\u05e7", 2070);
    freq.put("\u05ea\u05d9 ", 6224);
    freq.put("g ", 1420);
    freq.put("\u05d0\u05e0\u05e9", 1036);
    freq.put("\u05d0\u05e0\u05e8", 800);
    freq.put("\u05d0\u05da ", 1814);
    freq.put("\u05d0\u05e0\u05d3", 988);
    freq.put("\u05d0\u05e0\u05d2", 9388);
    freq.put("\u05d0\u05e0\u05d5", 1034);
    freq.put("\u05e9", 294877);
    freq.put("\u05d0\u05e0\u05d9", 2535);
    freq.put("\u05d0\u05e0\u05d8", 1124);
    freq.put("\u05e8\u05de\u05d9", 1311);
    freq.put("\u05d4\u05e7\u05ea", 1394);
    freq.put("\u05d4\u05e7\u05e8", 1616);
    freq.put("\u05d4\u05e7\u05e9", 833);
    freq.put("le ", 936);
    freq.put("\u05d2\u05d9\u05dc", 1327);
    freq.put("\u05d2\u05d9\u05dd", 1431);
    freq.put("\u05d3\u05d5\u05d3", 964);
    freq.put("\u05d3\u05d5\u05d2", 872);
    freq.put("\u05d3\u05d5\u05d1", 1184);
    freq.put("\u05d2\u05d9\u05d9", 929);
    freq.put("\u05d3\u05d5\u05df", 1523);
    freq.put("\u05d3\u05d5\u05de", 1571);
    freq.put("\u05d2\u05d9\u05d4", 3078);
    freq.put("\u05d3\u05d5\u05dc", 3841);
    freq.put("\u05d3\u05d5\u05e7", 822);
    freq.put("\u05d2\u05d9\u05ea", 995);
    freq.put("\u05d3\u05d5\u05e2", 2536);
    freq.put("\u05de\u05d9 ", 7001);
    freq.put("\u05d2\u05d9\u05e2", 1045);
    freq.put("\u05d1\u05e8 ", 12599);
    freq.put("\u05d3\u05d5\u05e8", 4722);
    freq.put("\u05e4\u05d5\u05dc", 5205);
    freq.put("\u05e0\u05d5\u05ea", 10949);
    freq.put("\u05e4\u05d5\u05df", 2263);
    freq.put(" \u05e2\u05d5", 4351);
    freq.put("\u05e8\u05e0\u05d9", 2334);
    freq.put("\u05e8\u05e0\u05d8", 865);
    freq.put(" \u05e2\u05d1", 2405);
    freq.put("\u05d0\u05dc\u05d2", 769);
    freq.put(" \u05e2\u05d3", 2831);
    freq.put("\u05e4\u05d5\u05d1", 883);
    freq.put(" \u05e2\u05dd", 3883);
    freq.put(" \u05e2\u05dc", 19873);
    freq.put(" \u05e2\u05de", 1580);
    freq.put(" \u05e2\u05d9", 2972);
    freq.put("\u05e4\u05d4", 6116);
    freq.put("\u05d0\u05dc\u05d9", 7303);
    freq.put("\u05d4\u05d5\u05e7", 1750);
    freq.put("\u05d0\u05dc\u05e7", 946);
    freq.put("\u05de\u05e7\u05d5", 5589);
    freq.put(" \u05e2\u05e7", 770);
    freq.put(" \u05e2\u05e6", 1752);
    freq.put("\u05d4\u05d5\u05dc", 1454);
    freq.put("\u05de\u05e7\u05d1", 868);
    freq.put("\u05d4\u05d5\u05d0", 27359);
    freq.put("\u05e4\u05d2", 1094);
    freq.put("\u05e8\u05e0\u05e1", 871);
    freq.put("\u05d4\u05d5\u05d3", 5252);
    freq.put(" \u05e2\u05e9", 1568);
    freq.put(" \u05e2\u05e8", 2088);
    freq.put(" \u05e2\u05ea", 798);
    freq.put("\u05e0\u05d5\u05e2", 4528);
    freq.put("\u05d1\u05d9\u05e9", 3045);
    freq.put("\u05ea\u05d7\u05ea", 1243);
    freq.put("\u05e1\u05d8\u05e8", 2818);
    freq.put("\u05ea\u05d7\u05d9", 1668);
    freq.put("\u05d5\u05d3\u05d9", 6497);
    freq.put("\u05d5\u05d2 ", 4167);
    freq.put("\u05e1\u05d8\u05d5", 3180);
    freq.put("\u05e1\u05d8\u05d9", 3364);
    freq.put("\u05ea\u05d7\u05d5", 3127);
    freq.put("\u05d1\u05d9\u05e0", 3973);
    freq.put("\u05e2\u05de\u05d9", 1194);
    freq.put("\u05e2\u05de\u05d3", 1340);
    freq.put("\u05e2\u05de\u05d5", 895);
    freq.put("\u043e", 1736);
    freq.put("\u05e0\u05d5\u05dc", 6258);
    freq.put("\u05e4\u05d5\u05ea", 3286);
    freq.put("\u05e0\u05d5\u05df", 1701);
    freq.put("\u05e4\u05ea", 9249);
    freq.put("\u05e0\u05d5\u05d9", 2975);
    freq.put("\u05e4\u05e8", 34424);
    freq.put("\u05e2\u05ea ", 4300);
    freq.put("\u05e4\u05e6", 904);
    freq.put("\u05e4\u05e7", 4972);
    freq.put("\u05e4\u05d5\u05e2", 1359);
    freq.put("\u05e4\u05e2", 6986);
    freq.put("om", 1498);
    freq.put("\u05e4\u05e0", 5942);
    freq.put("\u05e0\u05d5\u05d3", 953);
    freq.put("\u05e8\u05de\u05e0", 3395);
    freq.put("\u05d3", 182547);
    freq.put("\u05d1\u05d2", 4476);
    freq.put("px ", 1770);
    freq.put("\u05d4\u05d8\u05d5", 996);
    freq.put("\u05e7\u05dc\u05d9", 2877);
    freq.put("\u05e8\u05de\u05d5", 1109);
    freq.put("\u05d8\u05df ", 1424);
    freq.put("f", 3967);
    freq.put("\u05e7\u05dc\u05d0", 1049);
    freq.put("\u05e7\u05dc\u05d5", 814);
    freq.put("\u05e4\u05df", 2295);
    freq.put("\u05e4\u05dc", 6474);
    freq.put("\u05e0\u05d5\u05e8", 1169);
    freq.put("\u05e0\u05d5\u05e9", 1445);
    freq.put("\u05e4\u05d8", 6029);
    freq.put("\u05e4\u05d9", 27041);
    freq.put("\u05e4\u05d5\u05d0", 886);
    freq.put("\u05e4\u05d7", 3684);
    freq.put("\u05e0\u05d5\u05e6", 1379);
    freq.put("\u05e4\u05d5", 28843);
    freq.put("\u05e0\u05d5\u05e0", 778);
    freq.put("\u05e0\u05d5\u05e1", 3397);
    freq.put("\u05e4\u05d0", 3156);
    freq.put("\u05e4\u05d1", 1568);
    freq.put("\u05d8\u05d5\u05d1", 2684);
    freq.put("\u0440", 1134);
    freq.put("\u05d8\u05d5\u05df", 1905);
    freq.put("\u05dc\u05d3\u05d4", 1350);
    freq.put("\u05e9\u05e8\u05ea", 856);
    freq.put("\u05de\u05de\u05dc", 1294);
    freq.put("\u05d4\u05d5\u05e4", 1656);
    freq.put("\u05de\u05de\u05d5", 4003);
    freq.put("\u05d2\u05d1\u05d9", 1029);
    freq.put("\u05e9\u05e8\u05d9", 1851);
    freq.put("\u05de\u05de\u05e9", 2774);
    freq.put("\u05e9\u05d5 ", 1123);
    freq.put("\u05e9\u05e8\u05d0", 9189);
    freq.put("\u05e9\u05e8\u05d4", 794);
    freq.put("\u05e9\u05e8\u05d5", 1075);
    freq.put("\u05d8\u05d5\u05e0", 1205);
    freq.put("\u05d8\u05d5\u05e1", 1037);
    freq.put("\u05d5\u05e0\u05d4", 7200);
    freq.put("\u05e2\u05d5\u05d3", 1596);
    freq.put("\u05d8\u05d5\u05e8", 5386);
    freq.put("\u05d8\u05d5\u05ea", 1114);
    freq.put("\u05e2\u05d5\u05d1", 1493);
    freq.put("\u05db\u05d5\u05df", 1365);
    freq.put("\u05e6\u05e2", 4237);
    freq.put("\u05db\u05d5\u05dc", 4477);
    freq.put("\u05e6\u05e4", 3530);
    freq.put("\u05e6\u05e8", 9786);
    freq.put("\u05e6\u05ea", 2627);
    freq.put("\u05e6\u05d0", 6953);
    freq.put("\u05e6\u05d1", 5471);
    freq.put("\u05e6\u05d2", 1091);
    freq.put("\u05e6\u05d3", 1322);
    freq.put("\u05e6\u05d4", 5120);
    freq.put("\u05e6\u05d5", 14859);
    freq.put("\u05e6\u05d7", 1679);
    freq.put("\u05e6\u05d8", 759);
    freq.put("\u05e8", 442678);
    freq.put("\u05e6\u05dc", 2956);
    freq.put("\u05e6\u05de", 5084);
    freq.put("\u05db\u05d5\u05e0", 3439);
    freq.put("\u05e9\u05e8\u05d3", 795);
    freq.put("\u05d4\u05e0\u05d7", 758);
    freq.put("\u05d4\u05e0\u05d5", 2020);
    freq.put("\u05de\u05ea\u05d0", 1357);
    freq.put("\u05de\u05ea\u05d7", 1378);
    freq.put("\u05de\u05ea\u05d5", 2071);
    freq.put("\u05d4\u05e0\u05de", 908);
    freq.put("\u05de\u05ea\u05d9", 1175);
    freq.put("\u05de\u05ea\u05de", 1624);
    freq.put("\u05d4\u05e0\u05d9", 1012);
    freq.put("\u05d0\u05e3 ", 1141);
    freq.put("le", 2918);
    freq.put("la", 2312);
    freq.put("\u05d0\u05e1\u05d8", 928);
    freq.put("\u0628", 960);
    freq.put("ll", 2162);
    freq.put("li", 2362);
    freq.put("\u05d4\u05e0\u05e4", 766);
    freq.put("\u05de\u05ea\u05e7", 1096);
    freq.put("\u05d8\u05d4 ", 3869);
    freq.put("\u05e4\u05d4 ", 6052);
    freq.put("\u05e8\u05dd ", 1940);
    freq.put("\u05e5 ", 10234);
    freq.put("\u05d7\u05d4 ", 3681);
    freq.put("\u05d5", 795043);
    freq.put("\u05e7\u05dd ", 1371);
    freq.put("l ", 3308);
    freq.put("\u05dc\u05e1 ", 944);
    freq.put(" \u05d4\u05e7", 10138);
    freq.put("\u05e0\u05d4 ", 21979);
    freq.put("\u05e7\u05e9\u05d5", 1188);
    freq.put("\u05e1\u05d9 ", 2536);
    freq.put("\u05de\u05e4\u05e8", 1910);
    freq.put("\u05e8\u05e1\u05dd", 846);
    freq.put("\u05d0\u05de\u05e6", 1763);
    freq.put("\u05de\u05e4\u05d9", 1187);
    freq.put("\u05e2\u05d5\u05ea", 4912);
    freq.put("\u05d4\u05d6\u05de", 843);
    freq.put("\u05de\u05e4\u05dc", 1393);
    freq.put("\u05ea ", 251160);
    freq.put("\u05de\u05e4\u05d5", 1340);
    freq.put("\u05e2\u05d5\u05e8", 1459);
    freq.put("\u05e7\u05e9\u05e8", 1129);
    freq.put("\u05dc\u05d9\u05e4", 1428);
    freq.put("\u05dc\u05d9\u05e6", 890);
    freq.put("\u05dc\u05d9\u05e7", 1573);
    freq.put("\u05dc\u05d9\u05e0", 1320);
    freq.put("\u05dc\u05d9\u05e1", 1055);
    freq.put("\u05d4\u05d4\u05d9", 939);
    freq.put("\u05dc\u05d9\u05ea", 12132);
    freq.put("\u05ea\u05e8", 13462);
    freq.put("\u05ea\u05e9", 2068);
    freq.put("\u05ea\u05ea", 1846);
    freq.put("\u05ea\u05e4", 5557);
    freq.put("\u05ea\u05e7", 7602);
    freq.put("\u05ea\u05e0", 5503);
    freq.put("\u05ea\u05e2", 2232);
    freq.put(" \u05e1 ", 1112);
    freq.put("\u05ea\u05dd", 2303);
    freq.put("\u05ea\u05de", 4850);
    freq.put("\u05ea\u05df", 2959);
    freq.put("\u05ea\u05d9", 25751);
    freq.put("g", 6300);
    freq.put("\u05ea\u05db", 2023);
    freq.put("\u05ea\u05d4", 9277);
    freq.put("\u05ea\u05d5", 25811);
    freq.put("\u05ea\u05d7", 9940);
    freq.put("\u05ea\u05d0", 5204);
    freq.put("\u05ea\u05d1", 4462);
    freq.put("\u05ea\u05d2", 1436);
    freq.put("\u05dc\u05d9\u05d4", 3296);
    freq.put("\u05dc\u05d9\u05d5", 3604);
    freq.put("\u05dc\u05d9\u05d6", 849);
    freq.put("\u05dc\u05d9\u05d7", 784);
    freq.put("\u05d4\u05db\u05e0", 1262);
    freq.put("\u05dc\u05d9\u05d2", 1396);
    freq.put("\u05dc\u05d9\u05d3", 1413);
    freq.put("\u05dc\u05d9\u05dc", 2282);
    freq.put("\u05db\u05d5\u05db", 1222);
    freq.put("\u05dc\u05d9\u05de", 1810);
    freq.put("\u05dc\u05d9\u05df", 1391);
    freq.put("\u05dc\u05d9\u05d8", 3150);
    freq.put("\u05dc\u05d9\u05d9", 2952);
    freq.put("\u05dc\u05d9\u05da", 906);
    freq.put("\u05e8\u05d9\u05e1", 1584);
    freq.put("\u05e6\u05e8 ", 2282);
    freq.put("\u05db\u05d5\u05d7", 1334);
    freq.put("\u05d4\u05d4\u05d5", 815);
    freq.put("\u05d1\u05d9 ", 5655);
    freq.put(" St", 815);
    freq.put("\u05e8\u05d9\u05ea", 8516);
    freq.put("\u05dc\u05d6", 1198);
    freq.put("\u05dc\u05d7", 8146);
    freq.put("\u05dc\u05d4", 26418);
    freq.put("\u05dc\u05d5", 38179);
    freq.put("\u05dc\u05d2", 4986);
    freq.put("\u05dc\u05d3", 10370);
    freq.put("\u05dc\u05d0", 20135);
    freq.put("\u05dc\u05d1", 10370);
    freq.put("\u05dc\u05de", 14400);
    freq.put("\u05dc\u05df", 1558);
    freq.put("\u05dc\u05dc", 8431);
    freq.put("\u05dc\u05dd", 5118);
    freq.put("\u05dc\u05da", 2679);
    freq.put("\u05dc\u05db", 7962);
    freq.put("\u05dc\u05d8", 7328);
    freq.put("\u05dc\u05d9", 67951);
    freq.put("\u05e6\u05d9\u05d0", 1461);
    freq.put("R", 3127);
    freq.put("\u05e6\u05d9\u05d4", 2306);
    freq.put("\u05e6\u05d9\u05d5", 2783);
    freq.put("\u05d7\u05e8 ", 3837);
    freq.put("\u05e6\u05d9\u05d9", 1115);
    freq.put("\u05e6\u05d9\u05dd", 1036);
    freq.put("\u05d5\u05d1 ", 6671);
    freq.put("\u05e6\u05d9\u05e8", 1681);
    freq.put("\u05d7 ", 14016);
    freq.put("\u05dc\u05e6", 2285);
    freq.put("\u05dc\u05e7", 11094);
    freq.put("\u05dc\u05e4", 7565);
    freq.put("\u05dc\u05e2", 5121);
    freq.put("\u05dc\u05e0", 7233);
    freq.put("\u05dc\u05e1", 4718);
    freq.put("\u05dc\u05ea", 11787);
    freq.put("\u05e0\u05ea ", 12553);
    freq.put("\u05dc\u05e8", 5001);
    freq.put("\u05dc\u05e9", 7046);
    freq.put("\u05e8\u05e6\u05d9", 1126);
    freq.put("\u05e9\u05d9\u05e6", 765);
    freq.put("\u05e9\u05d9\u05e0", 1048);
    freq.put("\u05e9\u05d9\u05e9", 1013);
    freq.put("\u05e9\u05d9\u05e8", 3655);
    freq.put("\u05e9\u05d9\u05ea", 2397);
    freq.put("\u05d4\u05d5\u05d5", 1959);
    freq.put("\u05e2\u05e6\u05d4", 792);
    freq.put("\u05e2\u05e6\u05de", 2020);
    freq.put("\u05e9\u05d9\u05d5", 1010);
    freq.put("\u05e9\u05d9\u05d7", 755);
    freq.put("\u05e9\u05d9\u05d1", 1320);
    freq.put("\u05e9\u05d9\u05d0", 1478);
    freq.put("\u05e9\u05d9\u05dd", 3750);
    freq.put("\u05e9\u05d9\u05de", 3122);
    freq.put("\u05e9\u05d9\u05d9", 2304);
    freq.put("\u05e9\u05d9\u05d8", 1510);
    freq.put("J", 1816);
    freq.put("\u05e8\u05e6\u05d5", 3053);
    freq.put("\u05d4", 590284);
    freq.put("\u05d9\u05d2\u05d4", 763);
    freq.put("\u05d9\u05d2\u05d5", 1454);
    freq.put("\u05d5\u05d5\u05e8", 1036);
    freq.put(" \u05db\u05e0", 1474);
    freq.put("\u05d9\u05d3 ", 4579);
    freq.put("\u05e9\u05d4 ", 6000);
    freq.put("\u05e8\u05ea ", 15678);
    freq.put("\u05e9\u05da ", 1218);
    freq.put("\u05d3\u05e6\u05de", 1291);
    freq.put("\u05dc\u05d5\u05d9", 1233);
    freq.put("\u05d5\u05e0\u05d0", 1208);
    freq.put("\u05e6 ", 3355);
    freq.put("\u05d7\u05d6", 2980);
    freq.put("\u05d7\u05d5", 22900);
    freq.put("\u05d7\u05d4", 3687);
    freq.put("\u05d7\u05d3", 8305);
    freq.put("\u05d7\u05d1", 10029);
    freq.put("\u05d7\u05de", 5926);
    freq.put("\u05d7\u05dd", 835);
    freq.put("\u05d7\u05dc", 11067);
    freq.put("\u05d7\u05e8\u05d9", 2444);
    freq.put("\u05d7\u05d9", 19519);
    freq.put("\u05db\u05d2\u05d5", 871);
    freq.put("\u05d7\u05e7", 7976);
    freq.put("\u05d7\u05e6", 1267);
    freq.put("\u05d5\u05e8\u05e1", 1879);
    freq.put("\u05e1\u05e1 ", 885);
    freq.put("\u05d7\u05e1", 4114);
    freq.put("\u05d7\u05e0", 2382);
    freq.put("\u05d7\u05ea", 6995);
    freq.put("\u05d7\u05e9", 6932);
    freq.put("\u05d7\u05e8", 11087);
    freq.put("\u05e8\u05d9\u05d3", 1253);
    freq.put("\u05e9\u05db\u05d5", 948);
    freq.put("\u05e0\u05e2", 2683);
    freq.put("\u05e0\u05e0", 1118);
    freq.put("\u05e0\u05e1", 7827);
    freq.put("\u05e0\u05e6", 2907);
    freq.put("\u05e0\u05e7", 6861);
    freq.put("\u05e0\u05e4", 4308);
    freq.put("\u05e0\u05ea", 16355);
    freq.put("\u05e0\u05e8", 4214);
    freq.put("\u05e0\u05e9", 4892);
    freq.put("\u05d1", 395285);
    freq.put("\u05e8\u05d9\u05d8", 3551);
    freq.put("\u05d9\u05dc\u05d4", 3661);
    freq.put("\u05d9\u05dc\u05d5", 5745);
    freq.put("\u05e9\u05d5\u05dc", 846);
    freq.put("\u05e9\u05d5\u05df", 3078);
    freq.put("\u05e9\u05d5\u05de", 896);
    freq.put("\u05e9\u05d5\u05d1", 2695);
    freq.put("\u05e9\u05e8 ", 8585);
    freq.put("\u05e9\u05d5\u05d5", 1653);
    freq.put("\u05d9\u05dc\u05d9", 5359);
    freq.put("\u05e9\u05d5\u05e8", 3173);
    freq.put("\u05e9\u05d5\u05ea", 2730);
    freq.put("ng ", 993);
    freq.put("h", 10406);
    freq.put("\u05d9\u05dc\u05ea", 1987);
    freq.put("\u05e0\u05d2", 16204);
    freq.put("\u05e0\u05d3", 8678);
    freq.put("\u05e0\u05d0", 5195);
    freq.put("\u05e0\u05d1", 2857);
    freq.put("\u05e0\u05d6", 1832);
    freq.put("\u05e0\u05d7", 5856);
    freq.put("\u05e0\u05d4", 26549);
    freq.put("\u05e0\u05d5", 50382);
    freq.put("\u05e0\u05db", 2770);
    freq.put("\u05e0\u05d8", 9488);
    freq.put("\u05e0\u05d9", 73546);
    freq.put("\u05e0\u05de", 4014);
    freq.put("\u05e0\u05df", 997);
    freq.put("\u05e0\u05dc", 2549);
    freq.put("\u05e0\u05dd", 1134);
    freq.put(" \u05d9\u05e8", 1739);
    freq.put(" \u05d9\u05e9", 8585);
    freq.put("\u05d1\u05e8\u05d0", 1602);
    freq.put("\u05d1\u05e8\u05d4", 2480);
    freq.put("\u05d1\u05e8\u05d5", 5256);
    freq.put("\u05e4\u05d5 ", 941);
    freq.put("\u05d5\u05e0\u05d7", 1810);
    freq.put(" \u05d9\u05e2", 851);
    freq.put("\u05d1\u05e8\u05d9", 11218);
    freq.put("\u05d5\u05e0\u05d2", 1320);
    freq.put("C", 5446);
    freq.put(" \u05d9\u05e6", 2302);
    freq.put("\u05d4\u05e9\u05e4", 1366);
    freq.put("Pa", 795);
    freq.put("\u05e7\u05dc ", 917);
    freq.put("\u05d5\u05d6\u05e2", 1797);
    freq.put("\u0627", 2457);
    freq.put(" \u05d9\u05d9", 2324);
    freq.put(" \u05d9\u05db", 1029);
    freq.put(" \u05d9\u05dc", 1306);
    freq.put(" \u05d9\u05de", 1454);
    freq.put("\u05d1\u05e8\u05ea", 3153);
    freq.put("\u05d5\u05e0\u05e7", 1268);
    freq.put("\u043b", 851);
    freq.put(" \u05d9\u05d3", 8356);
    freq.put(" \u05d9\u05d4", 3689);
    freq.put(" \u05d9\u05d5", 7458);
    freq.put("\u05e2\u05ea\u05d9", 2916);
    freq.put(" \u05d9\u05d7", 2213);
    freq.put("\u05e0\u05e9\u05d9", 2815);
    freq.put("\u05d5\u05d6\u05d9", 3484);
    freq.put("\u05d5\u05d2\u05d5", 2244);
    freq.put("S", 6051);
    freq.put("\u05d5\u05d2\u05d3", 821);
    freq.put("\u05ea\u05d7 ", 1273);
    freq.put("\u05d5\u05d2\u05de", 793);
    freq.put("\u05d5\u05d2\u05d9", 5063);
    freq.put("\u05e6", 88276);
    freq.put("\u05d5\u05d2\u05e8", 1479);
    freq.put("\u05e7\u05d8 ", 953);
    freq.put("\u05e4\u05e1\u05d5", 1262);
    freq.put("lo", 1342);
    freq.put("\u05e4\u05e1\u05d9", 1405);
    freq.put("ci", 1010);
    freq.put("ch", 2176);
    freq.put("co", 1157);
    freq.put("ca", 1297);
    freq.put("\u05d7\u05d1\u05e8", 6406);
    freq.put("\u05d5\u05d5\u05ea", 1300);
    freq.put("\u05db\u05ea\u05d1", 2605);
    freq.put("ce", 1369);
    freq.put("\u05d4\u05e9\u05d1", 876);
    freq.put("\u05ea\u05e7\u05d9", 1081);
    freq.put("\u05d4\u05d5 ", 1555);
    freq.put("\u05ea\u05e7\u05d5", 3171);
    freq.put("ct", 774);
    freq.put("\u05d0\u05dc ", 12893);
    freq.put("\u05ea\u05dd ", 2303);
    freq.put("c ", 854);
    freq.put(" \u05e0\u05d2", 1220);
    freq.put(" \u05e0\u05d1", 1056);
    freq.put(" \u05e0\u05d0", 920);
    freq.put(" \u05e0\u05d7", 2096);
    freq.put(" \u05e0\u05d5", 11348);
    freq.put(" \u05e0\u05d4", 1061);
    freq.put(" \u05e0\u05db", 1356);
    freq.put(" \u05e0\u05d9", 4715);
    freq.put(" \u05e0\u05de", 1957);
    freq.put("\u05de\u05e1\u05d2", 979);
    freq.put(" \u05e0\u05e2", 1238);
    freq.put("\u05d4\u05db\u05d5", 1820);
    freq.put(" \u05e0\u05e7", 2006);
    freq.put("\u05d7\u05d1\u05d9", 909);
    freq.put("\u05de\u05e1\u05d5", 3392);
    freq.put(" \u05e0\u05ea", 1130);
    freq.put(" \u05e0\u05e9", 1719);
    freq.put("\u05de\u05e1\u05d9", 756);
    freq.put("\u05d2\u05d9 ", 1572);
    freq.put("\u05d4\u05db\u05d9", 931);
    freq.put(" \u05e2", 48214);
    freq.put(" \u05e0", 37369);
    freq.put(" \u05e1", 29027);
    freq.put(" \u05e6", 12233);
    freq.put(" \u05e7", 30023);
    freq.put(" \u05e4", 33679);
    freq.put(" \u05ea", 26310);
    freq.put("vi", 786);
    freq.put(" \u05e8", 28151);
    freq.put(" \u05e9", 120088);
    freq.put("\u05dc\u05de\u05d3", 977);
    freq.put("\u05ea\u05d9\u05e7", 1981);
    freq.put("\u05d4\u05d9\u05e1", 2192);
    freq.put("\u05e8\u05d0\u05d4", 1168);
    freq.put("\u05ea\u05d9\u05ea", 3825);
    freq.put("\u05ea\u05d9\u05d4", 1049);
    freq.put("\u05ea\u05d9\u05d5", 2454);
    freq.put("\u05ea\u05d9\u05d0", 1180);
    freq.put("\u05ea\u05d9\u05d1", 1533);
    freq.put("\u05ea\u05d9\u05dd", 1902);
    freq.put("\u05d5\u05d0 ", 27697);
    freq.put("\u05ea\u05d9\u05d9", 3333);
    freq.put(" \u05d2", 26594);
    freq.put(" \u05d3", 18598);
    freq.put(" \u05d0", 111429);
    freq.put(" \u05d1", 199095);
    freq.put(" \u05d6", 14443);
    freq.put(" \u05d7", 27536);
    freq.put(" \u05d4", 315869);
    freq.put(" \u05d5", 76633);
    freq.put(" \u05db", 41422);
    freq.put(" \u05d8", 10158);
    freq.put(" \u05d9", 46710);
    freq.put(" \u05de", 140680);
    freq.put("\u05dc\u05de\u05e0", 879);
    freq.put(" \u05dc", 87440);
    freq.put("\u05dc\u05de\u05e2", 1288);
    freq.put("\u05e0\u05d3\u05d9", 1685);
    freq.put("\u05b4\u05d9", 1007);
    freq.put("\u05e2\u05e8 ", 2948);
    freq.put("\u05d9\u05d7 ", 1007);
    freq.put("\u05e0\u05d3\u05d5", 1190);
    freq.put("ion", 1503);
    freq.put(" \u05db ", 2336);
    freq.put("\u05d3\u05e9 ", 1335);
    freq.put("\u05e6\u05e8\u05d9", 2230);
    freq.put("\u05d7\u05d5\u05e4", 953);
    freq.put("\u05d7\u05d5\u05ea", 2707);
    freq.put("\u05d7\u05d5\u05e8", 1374);
    freq.put("\u05d7\u05d5\u05d3", 1401);
    freq.put("\u05d7\u05d5\u05d1", 1301);
    freq.put("\u05d7\u05d5\u05d6", 2017);
    freq.put("i", 28660);
    freq.put("\u05e6\u05e8\u05e4", 2865);
    freq.put("\u05d7\u05d5\u05de", 2243);
    freq.put("\u05d7\u05d5\u05dd", 1881);
    freq.put("\u05d7\u05d5\u05dc", 1611);
    freq.put("\u05e0\u05d3\u05e8", 1651);
    freq.put("\u05e8\u05dc\u05d9", 1812);
    freq.put(" Th", 1324);
    freq.put("\u05dc\u05e2\u05ea", 1312);
    freq.put("\u05d4\u05e2\u05d9", 2782);
    freq.put("\u05e9\u05d4\u05d9", 1689);
    freq.put("\u05e9\u05d4\u05d5", 2779);
    freq.put("\u05d9\u05d3\u05d5", 5598);
    freq.put("\u05d9\u05d3\u05d4", 2025);
    freq.put("\u05d9\u05d3\u05ea", 830);
    freq.put("\u05e9\u05d4\u05ea", 1193);
    freq.put("\u05d9\u05d2 ", 1633);
    freq.put("\u05d9\u05d3\u05e2", 1040);
    freq.put("\u05d5\u05db\u05e8", 1278);
    freq.put(" \u0627", 1195);
    freq.put("T", 4063);
    freq.put("\u05db\u05d4 ", 5083);
    freq.put("\u05d7\u05ea ", 4976);
    freq.put(" \u05db\u05da", 799);
    freq.put("\u05e0\u05ea\u05d9", 767);
    freq.put("\u05e0\u05ea\u05d5", 1033);
    freq.put("\u05d5\u05d1\u05d9", 4910);
    freq.put("\u05d4\u05e6\u05dc", 875);
    freq.put("\u05d4\u05e6\u05d9", 1591);
    freq.put("\u05d5\u05d1\u05dc", 2998);
    freq.put("\u05d5\u05d1\u05de", 2420);
    freq.put("\u05d5\u05d1\u05d0", 1004);
    freq.put("\u05d5\u05d1\u05d3", 1206);
    freq.put("\u05d4\u05e6\u05d1", 868);
    freq.put("\u05d5\u05d1\u05d4", 2620);
    freq.put("\u05d5\u05d1\u05e8", 4203);
    freq.put("\u05e6\u05d9 ", 1464);
    freq.put("\u05d5\u05d1\u05ea", 944);
    freq.put("nd ", 899);
    freq.put("\u05d5\u05d1\u05e2", 1673);
    freq.put("\u05de\u05df ", 5852);
    freq.put("\u05e4\u05e2\u05d9", 1681);
    freq.put("\u05e4\u05e2\u05dc", 1386);
    freq.put("\u05dc ", 123422);
    freq.put("\u05d2\u05e8\u05ea", 1011);
    freq.put("\u05e4\u05e2\u05d5", 1775);
    freq.put("\u05d2", 118718);
    freq.put("\u05ea\u05e4\u05d9", 902);
    freq.put("\u05d1\u05d9\u05e8", 2459);
    freq.put("\u05e8\u05df ", 1611);
    freq.put("\u05d1\u05d9\u05ea", 7075);
    freq.put("\u05d1\u05d9\u05e6", 869);
    freq.put("\u05e7\u05df ", 2098);
    freq.put("\u05d1\u05d9\u05e2", 1697);
    freq.put("\u05d1\u05d9\u05dd", 5704);
    freq.put("\u05d1\u05d9\u05dc", 1749);
    freq.put("\u05d1\u05d9\u05df", 7303);
    freq.put("\u05d1\u05d9\u05de", 897);
    freq.put("\u05d1\u05d9\u05d9", 2219);
    freq.put("\u05d1\u05d9\u05d8", 1549);
    freq.put("\u05ea\u05e4\u05ea", 844);
    freq.put("\u05d1\u05d9\u05d5", 8219);
    freq.put("\u05d1\u05d9\u05d4", 1061);
    freq.put("\u05ea\u05e4\u05e7", 1672);
    freq.put("\u05d1\u05d9\u05d1", 2499);
    freq.put("\u05d1\u05d9\u05d0", 912);
    freq.put("\u05d1\u05d9\u05d3", 1090);
    freq.put("es ", 1643);
    freq.put("\u05e7\u05d4 ", 10128);
    freq.put("\u05dc\u05d9 ", 12633);
    freq.put("\u05d3\u05e8\u05d5", 3914);
    freq.put("\u05dc\u05df ", 1554);
    freq.put(" \u05e1\u05d1", 864);
    freq.put(" \u05e1\u05d2", 795);
    freq.put(" \u05e1\u05d3", 1598);
    freq.put("\u05de\u05e6\u05e2", 1849);
    freq.put(" \u05e1\u05d8", 1619);
    freq.put(" \u05e1\u05d9", 4571);
    freq.put("h ", 1424);
    freq.put(" \u05e1\u05dc", 908);
    freq.put("\u05ea\u05d4 ", 7963);
    freq.put(" \u05e1\u05de", 1246);
    freq.put("\u05de\u05e6\u05e8", 828);
    freq.put("\u05de\u05e6\u05d5", 2210);
    freq.put(" \u05e1\u05e4", 4534);
    freq.put("\u05de\u05e6\u05d1", 1295);
    freq.put(" \u05e1\u05e7", 894);
    freq.put(" \u05e1\u05e8", 2435);
    freq.put("\u05d9\u05e2\u05d5", 1404);
    freq.put("\u05de\u05e6\u05d9", 1590);
    freq.put("\u05e1\u05d9\u05ea", 2310);
    freq.put("\u05e1\u05d9\u05e4", 1197);
    freq.put("\u05e1\u05d9\u05e1", 1561);
    freq.put("\u05e1\u05d9\u05e0", 1401);
    freq.put("\u05e2\u05d1\u05e8", 4731);
    freq.put("hi", 1088);
    freq.put("ho", 885);
    freq.put("ha", 1572);
    freq.put("\u05dc\u05e7 ", 2384);
    freq.put("he", 2979);
    freq.put("\u05d9\u05e7\u05ea", 771);
    freq.put("\u05d0\u05dd ", 2755);
    freq.put("\u05e7", 174715);
    freq.put("\u05e8\u05e1\u05d9", 2582);
    freq.put("\u05e8\u05e1 ", 2957);
    freq.put("\u05e1\u05d9\u05dd", 1765);
    freq.put("\u05e1\u05d9\u05dc", 886);
    freq.put("\u05e1\u05d9\u05de", 1300);
    freq.put("\u05e1\u05d9\u05d9", 2145);
    freq.put("\u05e1\u05d9\u05d8", 1729);
    freq.put("\u05e1\u05d9\u05db", 1356);
    freq.put("\u05e1\u05d9\u05d5", 1804);
    freq.put("\u05e1\u05d9\u05d4", 1411);
    freq.put("\u05e1\u05d9\u05d1", 1007);
    freq.put("\u05e1\u05d9\u05d3", 979);
    freq.put("\u05e0\u05d4\u05dc", 1094);
    freq.put("\u05dc\u05d8\u05d9", 2006);
    freq.put("\u05e0\u05d4\u05d9", 761);
    freq.put("\u05e0\u05d4\u05d2", 967);
    freq.put("ing", 1041);
    freq.put("\u05d3\u05d4 ", 9750);
    freq.put("\u05e0\u05d4\u05e8", 1042);
    freq.put("\u05db\u05d1 ", 1369);
    freq.put("\u043d", 1202);
    freq.put("\u05bc", 3241);
    freq.put("\u05d2\u05d4 ", 2608);
    freq.put("\u05d0\u05e1 ", 1146);
    freq.put("\u05de\u05d9\u05d9", 3085);
    freq.put("U", 823);
    freq.put("\u05de\u05d9\u05df", 1783);
    freq.put("\u05de\u05d9\u05dc", 2833);
    freq.put("\u05de\u05d9\u05dd", 6416);
    freq.put("\u05de\u05d9\u05d3", 2520);
    freq.put("\u05d9\u05e3 ", 1039);
    freq.put("in ", 936);
    freq.put("\u05de\u05d9\u05d4", 1218);
    freq.put("\u05de\u05d9\u05d5", 3528);
    freq.put("\u05de\u05d9\u05ea", 4649);
    freq.put("\u05de\u05d9\u05e8", 984);
    freq.put("\u05de\u05d9\u05e9", 1371);
    freq.put("\u05d1\u05df ", 3463);
    freq.put("\u05de\u05d9\u05e0", 3538);
    freq.put("\u05de\u05d9\u05e7", 1216);
    freq.put("\u05d9\u05d7", 8678);
    freq.put("\u05de\u05ea ", 6084);
  }
  
}

