package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class FI extends CLangProfile {
  private static final String name = "fi";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public FI() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 15184556;
    n_words[1] = 16912812;
    n_words[2] = 13033049;

    freq.put(" ka\u0308", 15552);
    freq.put("aud", 2731);
    freq.put("auh", 2050);
    freq.put("auk", 3794);
    freq.put("aul", 4866);
    freq.put("aup", 10709);
    freq.put("aus", 6854);
    freq.put("aur", 1674);
    freq.put("aut", 8391);
    freq.put("ta\u0308 ", 34022);
    freq.put(" Gr", 2717);
    freq.put(" Ge", 2007);
    freq.put(" Ga", 2281);
    freq.put("Gr", 2750);
    freq.put("upe", 2549);
    freq.put("Ge", 2029);
    freq.put("Ga", 2319);
    freq.put("upu", 10042);
    freq.put(" ka", 41758);
    freq.put("me ", 2801);
    freq.put(" ke", 20426);
    freq.put(" ki", 21829);
    freq.put(" ko", 26681);
    freq.put(" kr", 3070);
    freq.put(" ku", 35062);
    freq.put(" ky", 5412);
    freq.put("nen", 63104);
    freq.put("a\u0308ri", 6126);
    freq.put("nel", 5383);
    freq.put("nei", 4215);
    freq.put("kuv", 12915);
    freq.put("kuu", 20315);
    freq.put("nee", 7398);
    freq.put("kus", 5968);
    freq.put("kup", 2448);
    freq.put("kuo", 2056);
    freq.put("kun", 18716);
    freq.put("a\u0308rj", 7258);
    freq.put("kuk", 1991);
    freq.put("kui", 3945);
    freq.put("net", 11819);
    freq.put("neu", 1692);
    freq.put("ner", 2732);
    freq.put("nes", 5079);
    freq.put("sli", 1829);
    freq.put("mee", 1671);
    freq.put("mel", 4799);
    freq.put("men", 18334);
    freq.put("mei", 2490);
    freq.put("met", 10390);
    freq.put("mes", 9381);
    freq.put("mer", 13701);
    freq.put("ee ", 9590);
    freq.put(" yh", 19431);
    freq.put(" yk", 6097);
    freq.put(" yl", 9242);
    freq.put(" ym", 1774);
    freq.put("lmi", 8971);
    freq.put("aks", 12179);
    freq.put("gla", 2321);
    freq.put("k", 691662);
    freq.put("gle", 2192);
    freq.put("aku", 8003);
    freq.put("akt", 1737);
    freq.put("akk", 5053);
    freq.put("aki", 5604);
    freq.put("ako", 3232);
    freq.put("aka", 6269);
    freq.put("ake", 7201);
    freq.put("ku ", 3951);
    freq.put("sso", 2391);
    freq.put("bri", 1634);
    freq.put("lma", 14737);
    freq.put("ena\u0308", 7730);
    freq.put("m ", 8821);
    freq.put("a\u0308lk", 2158);
    freq.put("a\u0308li", 6173);
    freq.put("a\u0308ll", 6310);
    freq.put("er ", 8358);
    freq.put("a\u0308lt", 2814);
    freq.put("ni ", 6341);
    freq.put("nka", 13056);
    freq.put("Sta", 1658);
    freq.put("nki", 13461);
    freq.put("nko", 2285);
    freq.put("V", 24290);
    freq.put("lop", 2359);
    freq.put("me", 68275);
    freq.put("eru", 10609);
    freq.put("erv", 1561);
    freq.put("ma", 107323);
    freq.put("err", 4242);
    freq.put("mb", 5971);
    freq.put("mm", 26269);
    freq.put("mo", 20189);
    freq.put("mi", 93628);
    freq.put("mu", 39868);
    freq.put("ere", 5494);
    freq.put("erg", 2239);
    freq.put("era", 4710);
    freq.put("erm", 2674);
    freq.put("ern", 2916);
    freq.put("ero", 5460);
    freq.put("my", 13711);
    freq.put("eri", 25262);
    freq.put("erk", 7307);
    freq.put("Le", 5504);
    freq.put("La", 6972);
    freq.put("Lo", 3355);
    freq.put("uas", 1855);
    freq.put("vos", 2863);
    freq.put("la ", 45674);
    freq.put("Li", 5491);
    freq.put("Lu", 2444);
    freq.put("ta\u0308n", 1885);
    freq.put("ena", 5955);
    freq.put("ib", 2776);
    freq.put("end", 1729);
    freq.put("ene", 8165);
    freq.put("eng", 2981);
    freq.put("hon", 2485);
    freq.put("eni", 7989);
    freq.put("hol", 1937);
    freq.put("enk", 6752);
    freq.put("Kan", 2320);
    freq.put("enn", 9973);
    freq.put("Kal", 1586);
    freq.put("Kar", 2566);
    freq.put("ens", 15471);
    freq.put("ent", 18077);
    freq.put("Kau", 1621);
    freq.put("sse", 2037);
    freq.put("A", 40046);
    freq.put("lam", 1915);
    freq.put("lan", 15670);
    freq.put("lah", 2594);
    freq.put("lai", 41589);
    freq.put("laj", 7083);
    freq.put("lak", 2624);
    freq.put("laa", 8510);
    freq.put("ova", 10956);
    freq.put("ove", 2498);
    freq.put("lat", 4073);
    freq.put("lau", 6037);
    freq.put("ovi", 3135);
    freq.put("lti", 5458);
    freq.put("las", 9219);
    freq.put("en ", 216998);
    freq.put("ma\u0308", 30120);
    freq.put("Alb", 1684);
    freq.put("era\u0308", 4263);
    freq.put(" Hi", 2219);
    freq.put(" Ho", 2907);
    freq.put(" Ha", 6075);
    freq.put(" He", 6845);
    freq.put("ima", 7267);
    freq.put("uor", 5597);
    freq.put("ime", 14110);
    freq.put("uot", 13021);
    freq.put("imi", 21669);
    freq.put("imm", 10403);
    freq.put("imo", 4420);
    freq.put("ta\u0308v", 7438);
    freq.put("ra\u0308", 7609);
    freq.put("imp", 1982);
    freq.put("imu", 3688);
    freq.put("uod", 11474);
    freq.put("uok", 4826);
    freq.put("uon", 20919);
    freq.put("fil", 1743);
    freq.put("uol", 10441);
    freq.put(" Va", 5984);
    freq.put(" Ve", 5638);
    freq.put(" Vi", 4890);
    freq.put(" Vu", 2183);
    freq.put("nta\u0308", 3484);
    freq.put("l", 885783);
    freq.put("isa\u0308", 6664);
    freq.put("nik", 3354);
    freq.put("nii", 4930);
    freq.put("nt ", 1924);
    freq.put(" Ha\u0308", 4383);
    freq.put("rt", 23316);
    freq.put("ru", 25282);
    freq.put("rv", 12255);
    freq.put("rp", 3591);
    freq.put("nil", 2835);
    freq.put("rr", 9979);
    freq.put("rs", 10921);
    freq.put("nim", 13793);
    freq.put("ry", 7951);
    freq.put("rd", 7095);
    freq.put("re", 35490);
    freq.put("rg", 6568);
    freq.put("ra", 66068);
    freq.put("rb", 1938);
    freq.put("ajo", 3036);
    freq.put("rl", 3938);
    freq.put("aja", 18366);
    freq.put("rn", 7182);
    freq.put("is ", 8294);
    freq.put("rh", 7195);
    freq.put("aje", 2029);
    freq.put("rj", 32055);
    freq.put("rk", 30938);
    freq.put("nty", 5978);
    freq.put("nia", 6492);
    freq.put("ntu", 4377);
    freq.put("ntt", 4440);
    freq.put("nti", 13349);
    freq.put("W", 9333);
    freq.put("nta", 21023);
    freq.put("a\u0308a", 1925);
    freq.put("nte", 11336);
    freq.put("isy", 1690);
    freq.put("ate", 6056);
    freq.put("ata", 7640);
    freq.put("iss", 30541);
    freq.put("ato", 4227);
    freq.put("isp", 1964);
    freq.put("atk", 3390);
    freq.put("isu", 9410);
    freq.put("ist", 90841);
    freq.put("isk", 6128);
    freq.put("isi", 26753);
    freq.put("atu", 3704);
    freq.put("iso", 4721);
    freq.put("ats", 1884);
    freq.put("ism", 2973);
    freq.put("isl", 1855);
    freq.put("isa", 5742);
    freq.put("ise", 59209);
    freq.put("o\u0308ss", 1852);
    freq.put("nha", 2067);
    freq.put("tei", 13515);
    freq.put("uks", 15716);
    freq.put("a\u0308y", 16618);
    freq.put("Y", 10043);
    freq.put("nis", 11071);
    freq.put("a\u0308t", 13038);
    freq.put("tem", 2906);
    freq.put("tor", 8049);
    freq.put("tos", 4171);
    freq.put("top", 1727);
    freq.put("tot", 2445);
    freq.put("toj", 3671);
    freq.put("tok", 5162);
    freq.put("toi", 21414);
    freq.put("ton", 10160);
    freq.put("a\u0308p", 3824);
    freq.put("tol", 5536);
    freq.put("Se ", 11672);
    freq.put("toa", 3897);
    freq.put(" le", 7943);
    freq.put("B", 22964);
    freq.put("uki", 2552);
    freq.put(" la", 17994);
    freq.put(" lo", 4509);
    freq.put(" li", 11414);
    freq.put("o\u0308s ", 7736);
    freq.put(" lu", 14733);
    freq.put("tyo\u0308", 3659);
    freq.put("uom", 19569);
    freq.put(" ly", 2009);
    freq.put("Ve", 5654);
    freq.put("a\u0308ma\u0308", 7782);
    freq.put("tsi", 5021);
    freq.put("kti", 3367);
    freq.put("Sen", 4830);
    freq.put("to ", 10851);
    freq.put("rad", 3325);
    freq.put("lbu", 8824);
    freq.put("raa", 6078);
    freq.put("ran", 13051);
    freq.put("ral", 4384);
    freq.put("raj", 2533);
    freq.put("rak", 6377);
    freq.put("rai", 2122);
    freq.put("rat", 4668);
    freq.put("rau", 3008);
    freq.put("ras", 4899);
    freq.put("on ", 146201);
    freq.put("ssa\u0308", 20775);
    freq.put("tym", 2979);
    freq.put("tyn", 4512);
    freq.put(" la\u0308", 10166);
    freq.put("tyi", 5279);
    freq.put("ra ", 5712);
    freq.put("tyk", 3846);
    freq.put("tye", 7861);
    freq.put("y", 250687);
    freq.put("tyy", 6164);
    freq.put("tyv", 3209);
    freq.put("uuk", 1525);
    freq.put("tys", 6857);
    freq.put("tse", 11636);
    freq.put("don", 2736);
    freq.put("dol", 2034);
    freq.put("a\u0308mi", 2674);
    freq.put("m", 433706);
    freq.put("suo", 12490);
    freq.put("dos", 3976);
    freq.put("lpa", 4160);
    freq.put("ma\u0308i", 6703);
    freq.put("ma\u0308n", 3876);
    freq.put(" Wa", 2289);
    freq.put("d ", 12256);
    freq.put(" Wi", 2296);
    freq.put("ma\u0308s", 1650);
    freq.put("ock", 3160);
    freq.put("sto", 18448);
    freq.put("kul", 5464);
    freq.put("do", 15043);
    freq.put("di", 25899);
    freq.put("ra\u0308i", 2223);
    freq.put("ma\u0308 ", 7257);
    freq.put("de", 60149);
    freq.put("da", 16197);
    freq.put("dy", 8630);
    freq.put("X", 1821);
    freq.put("du", 5956);
    freq.put("dr", 3184);
    freq.put("ds", 2160);
    freq.put("eme", 2562);
    freq.put("ila\u0308", 2764);
    freq.put("ema", 7235);
    freq.put("emm", 5417);
    freq.put("emo", 1546);
    freq.put("emi", 5347);
    freq.put("ilo\u0308", 2966);
    freq.put("emp", 2813);
    freq.put("hja", 5248);
    freq.put("koh", 3422);
    freq.put("w ", 2157);
    freq.put("nut", 8387);
    freq.put("nus", 3629);
    freq.put("Per", 1731);
    freq.put("num", 1758);
    freq.put("kok", 7259);
    freq.put("muu", 6734);
    freq.put("mut", 3853);
    freq.put("Ruo", 1578);
    freq.put("mus", 7282);
    freq.put("irt", 2993);
    freq.put("un ", 17537);
    freq.put("iri", 6484);
    freq.put("irj", 10801);
    freq.put("irk", 4448);
    freq.put("mua", 1679);
    freq.put("iro", 1572);
    freq.put("ira", 5520);
    freq.put("muo", 5752);
    freq.put("mui", 3639);
    freq.put("ire", 2058);
    freq.put("muk", 6397);
    freq.put("hah", 1631);
    freq.put("C", 22892);
    freq.put("wa", 2667);
    freq.put("da\u0308", 2655);
    freq.put(" Is", 2125);
    freq.put(" It", 2580);
    freq.put(" In", 4291);
    freq.put("ta\u0308a\u0308", 13926);
    freq.put("ema\u0308", 1894);
    freq.put("ile", 2304);
    freq.put("unt", 10189);
    freq.put("han", 4990);
    freq.put("ila", 13660);
    freq.put("ilo", 6040);
    freq.put("ill", 27290);
    freq.put("ilm", 11405);
    freq.put("ilj", 1888);
    freq.put("ili", 8485);
    freq.put("una", 4707);
    freq.put("ilt", 4359);
    freq.put("ilu", 7728);
    freq.put("und", 1617);
    freq.put("kol", 7289);
    freq.put("ilp", 4235);
    freq.put("ung", 5391);
    freq.put("uni", 5890);
    freq.put("unk", 6506);
    freq.put("va\u0308l", 6253);
    freq.put("unn", 17239);
    freq.put("va\u0308n", 2110);
    freq.put(" me", 12340);
    freq.put(" ma", 22033);
    freq.put(" mo", 4701);
    freq.put(" mi", 8054);
    freq.put("io\u0308", 6377);
    freq.put(" mu", 27269);
    freq.put(" my", 11678);
    freq.put("san", 10417);
    freq.put("fri", 1576);
    freq.put("C ", 2932);
    freq.put("ely", 1692);
    freq.put("ai ", 13611);
    freq.put("a\u0308a\u0308", 49135);
    freq.put("els", 2931);
    freq.put("Ch", 3205);
    freq.put("Co", 4892);
    freq.put("ait", 14001);
    freq.put("Ca", 3954);
    freq.put("aiv", 4010);
    freq.put("ais", 49469);
    freq.put("a\u0308rv", 3216);
    freq.put("aim", 1862);
    freq.put("ail", 13159);
    freq.put("ain", 38398);
    freq.put("aih", 3713);
    freq.put("aik", 14735);
    freq.put("aid", 2730);
    freq.put("sla", 3001);
    freq.put(" ma\u0308", 2284);
    freq.put("ip", 11864);
    freq.put("is", 262822);
    freq.put("ir", 40208);
    freq.put("iu", 5141);
    freq.put("it", 142893);
    freq.put("a\u0308 ", 141477);
    freq.put("iv", 30487);
    freq.put("ii", 85125);
    freq.put("ih", 17748);
    freq.put("ik", 78594);
    freq.put("ij", 23513);
    freq.put("im", 65870);
    freq.put("il", 97254);
    freq.put("io", 39520);
    freq.put("in", 288307);
    freq.put("ia", 70345);
    freq.put("ic", 10236);
    freq.put("ki ", 12342);
    freq.put("ie", 58968);
    freq.put("id", 26485);
    freq.put("ig", 6859);
    freq.put("if", 2884);
    freq.put("a\u0308ne", 3700);
    freq.put("a\u0308nn", 2773);
    freq.put("a\u0308ni", 2131);
    freq.put("a\u0308nt", 2999);
    freq.put("a\u0308ns", 2545);
    freq.put("th ", 1573);
    freq.put("a\u0308n", 46392);
    freq.put("a\u0308o", 2938);
    freq.put("a\u0308l", 20535);
    freq.put("a\u0308m", 13914);
    freq.put("a\u0308j", 7869);
    freq.put("a\u0308k", 13701);
    freq.put("a\u0308h", 12610);
    freq.put("a\u0308i", 25110);
    freq.put("kis", 5163);
    freq.put("kir", 13427);
    freq.put("a\u0308e", 2662);
    freq.put("kiv", 2180);
    freq.put("kit", 6283);
    freq.put("kik", 3240);
    freq.put("kij", 2090);
    freq.put("kii", 3407);
    freq.put("kio", 1639);
    freq.put("kin", 14280);
    freq.put("kim", 2775);
    freq.put("kil", 12288);
    freq.put("a\u0308v", 12353);
    freq.put("i ", 187878);
    freq.put("kia", 4204);
    freq.put("a\u0308r", 23375);
    freq.put("a\u0308s", 18046);
    freq.put("kie", 9439);
    freq.put("mil", 5082);
    freq.put("Va", 6002);
    freq.put("a\u0308n ", 27597);
    freq.put("Vi", 4932);
    freq.put("thu", 3317);
    freq.put("Vu", 2187);
    freq.put("the", 3039);
    freq.put("a\u0308ra\u0308", 1957);
    freq.put("yee", 3728);
    freq.put("via", 2642);
    freq.put("elj", 2641);
    freq.put("hai", 2275);
    freq.put("eli", 28185);
    freq.put("hal", 6945);
    freq.put("elo", 8595);
    freq.put("ell", 36182);
    freq.put("elm", 10985);
    freq.put("haa", 1766);
    freq.put("ela", 5301);
    freq.put("ele", 9915);
    freq.put("n", 1349748);
    freq.put("eur", 5135);
    freq.put("har", 4587);
    freq.put("Ha\u0308", 4384);
    freq.put("elu", 6803);
    freq.put("opu", 2089);
    freq.put("rni", 2033);
    freq.put("opp", 4159);
    freq.put("D", 15745);
    freq.put("ye ", 3730);
    freq.put("rna", 1810);
    freq.put("rne", 1656);
    freq.put("ope", 4607);
    freq.put("opa", 3651);
    freq.put("opi", 5727);
    freq.put("vis", 7340);
    freq.put("ha ", 1581);
    freq.put("el ", 2656);
    freq.put("ola", 6203);
    freq.put("ole", 10977);
    freq.put(" Ju", 3077);
    freq.put("oli", 32153);
    freq.put("oll", 16426);
    freq.put("olm", 4749);
    freq.put("olo", 5842);
    freq.put(" Jo", 4519);
    freq.put("olt", 1744);
    freq.put("olu", 4176);
    freq.put("oly", 2026);
    freq.put(" Ja", 4528);
    freq.put("ich", 1751);
    freq.put("for", 2137);
    freq.put("ica", 1971);
    freq.put("ela\u0308", 9755);
    freq.put("rki", 6693);
    freq.put("yks", 11428);
    freq.put("Hi", 2221);
    freq.put("uma", 5258);
    freq.put("Ho", 2925);
    freq.put("umb", 3567);
    freq.put("yky", 3192);
    freq.put("Ha", 6094);
    freq.put("umi", 12508);
    freq.put("He", 6887);
    freq.put("ic ", 1670);
    freq.put("o", 934203);
    freq.put("um ", 2055);
    freq.put("ppa", 7267);
    freq.put("aha", 3293);
    freq.put("sod", 2739);
    freq.put("ahd", 4670);
    freq.put("sof", 1780);
    freq.put("soi", 4463);
    freq.put("ppi", 4768);
    freq.put("nna\u0308", 1593);
    freq.put("sol", 2285);
    freq.put("ahm", 1834);
    freq.put("sop", 1591);
    freq.put("sos", 3124);
    freq.put("sot", 3315);
    freq.put("aht", 3966);
    freq.put("gis", 3146);
    freq.put("a\u0308st", 3327);
    freq.put("na\u0308", 20276);
    freq.put("a\u0308ss", 3767);
    freq.put("gia", 4299);
    freq.put("a\u0308si", 4968);
    freq.put("gin", 6890);
    freq.put("a\u0308se", 2119);
    freq.put("no\u0308", 1934);
    freq.put("mb ", 3008);
    freq.put(" na\u0308", 4180);
    freq.put("Z", 1858);
    freq.put("a\u0308s ", 1575);
    freq.put("nno", 6361);
    freq.put("nni", 12231);
    freq.put(" n ", 4861);
    freq.put("nne", 16039);
    freq.put("nna", 31714);
    freq.put(" Li", 5091);
    freq.put("nnu", 4777);
    freq.put("nke", 2631);
    freq.put("nh", 5001);
    freq.put("ni", 80364);
    freq.put("nj", 4418);
    freq.put("nk", 37841);
    freq.put("nl", 4563);
    freq.put("lo", 48127);
    freq.put("nn", 76172);
    freq.put("no", 34422);
    freq.put("tit", 2814);
    freq.put("na", 88104);
    freq.put("tiv", 2672);
    freq.put("nc", 4077);
    freq.put("nd", 15417);
    freq.put("ne", 115628);
    freq.put("nf", 1558);
    freq.put("ng", 26517);
    freq.put("til", 10225);
    freq.put("ny", 10224);
    freq.put("tin", 13829);
    freq.put("tio", 13178);
    freq.put("tii", 20914);
    freq.put("tik", 4482);
    freq.put("np", 4065);
    freq.put("tie", 14185);
    freq.put("nr", 2630);
    freq.put("ns", 48167);
    freq.put("nt", 79878);
    freq.put("nu", 19006);
    freq.put("nv", 4829);
    freq.put(" ni", 12782);
    freq.put("E", 23140);
    freq.put(" no", 7612);
    freq.put(" na", 3130);
    freq.put(" ne", 5502);
    freq.put(" ny", 2745);
    freq.put(" nu", 2351);
    freq.put("n ", 656910);
    freq.put("mme", 2557);
    freq.put("ti ", 27214);
    freq.put("roi", 1996);
    freq.put("hta\u0308", 1902);
    freq.put("rom", 2805);
    freq.put("ron", 4039);
    freq.put("roo", 4243);
    freq.put("oss", 12304);
    freq.put("roc", 2312);
    freq.put("ost", 14630);
    freq.put("llu", 3725);
    freq.put("osi", 11836);
    freq.put("osk", 3907);
    freq.put("llo", 8003);
    freq.put("oso", 3047);
    freq.put("osa", 15087);
    freq.put("lla", 45545);
    freq.put("ros", 3755);
    freq.put("rot", 3070);
    freq.put("rov", 1686);
    freq.put("ume", 3010);
    freq.put("ver", 6645);
    freq.put("ves", 2270);
    freq.put("di ", 1662);
    freq.put("ven", 5385);
    freq.put("vel", 7217);
    freq.put("yvi", 1744);
    freq.put("ert", 7186);
    freq.put("ro ", 2723);
    freq.put("os ", 5287);
    freq.put("ll ", 2046);
    freq.put("din", 5138);
    freq.put("dio", 5021);
    freq.put("ers", 4983);
    freq.put("dia", 2516);
    freq.put("p", 248621);
    freq.put("ve ", 1928);
    freq.put("a\u0308os", 2009);
    freq.put("der", 2863);
    freq.put("dis", 6234);
    freq.put(" Yh", 4598);
    freq.put("hte", 8765);
    freq.put("M ", 1871);
    freq.put("hta", 4518);
    freq.put("hto", 2163);
    freq.put("hti", 9794);
    freq.put("htu", 3085);
    freq.put("hty", 9392);
    freq.put("ruo", 2205);
    freq.put("yva\u0308", 4334);
    freq.put("mp", 15152);
    freq.put("Me", 4707);
    freq.put("Ma", 12276);
    freq.put("Mo", 4384);
    freq.put("v", 295575);
    freq.put("Mi", 5018);
    freq.put("Mu", 3221);
    freq.put("eko", 1843);
    freq.put("ekn", 1637);
    freq.put("ekk", 1967);
    freq.put("eki", 2975);
    freq.put("erh", 1625);
    freq.put("ekt", 2330);
    freq.put("eks", 9087);
    freq.put("ipa", 1808);
    freq.put("ipe", 1630);
    freq.put("ngi", 7939);
    freq.put("ipp", 2283);
    freq.put("ipu", 1889);
    freq.put(" ih", 2463);
    freq.put(" Ka", 13310);
    freq.put(" Ke", 4144);
    freq.put(" Ki", 5524);
    freq.put(" Ko", 6537);
    freq.put(" Kr", 2018);
    freq.put(" Ku", 5494);
    freq.put("ksa", 4741);
    freq.put(" Ky", 1626);
    freq.put("F", 13820);
    freq.put("oom", 1672);
    freq.put("ool", 1601);
    freq.put("oon", 7289);
    freq.put("oot", 2091);
    freq.put("oop", 3454);
    freq.put("oos", 2166);
    freq.put("ult", 3742);
    freq.put("ulu", 17346);
    freq.put("ulk", 14188);
    freq.put("uli", 3634);
    freq.put("ulo", 2329);
    freq.put("ull", 6128);
    freq.put("ula", 6501);
    freq.put("sa\u0308", 41776);
    freq.put(" on", 110013);
    freq.put(" ol", 30354);
    freq.put(" om", 3788);
    freq.put(" oh", 5375);
    freq.put(" oi", 2526);
    freq.put(" of", 2700);
    freq.put("ma ", 15016);
    freq.put(" ov", 7670);
    freq.put("spa", 2113);
    freq.put(" ot", 1666);
    freq.put(" or", 1769);
    freq.put(" os", 9956);
    freq.put(" op", 3466);
    freq.put("yo\u0308s", 8569);
    freq.put("nyt", 4401);
    freq.put("nyk", 2547);
    freq.put("yo\u0308n", 1725);
    freq.put("s ", 74921);
    freq.put("yo\u0308h", 1625);
    freq.put("mas", 6492);
    freq.put("mar", 3413);
    freq.put("mat", 9985);
    freq.put("use", 5829);
    freq.put("maa", 25280);
    freq.put("mai", 6076);
    freq.put("mah", 1595);
    freq.put("mak", 3049);
    freq.put("mal", 15003);
    freq.put("man", 17338);
    freq.put("ght", 1865);
    freq.put("sy", 12228);
    freq.put("pa\u0308a\u0308", 9932);
    freq.put("ss", 117492);
    freq.put("sr", 2112);
    freq.put("sp", 7200);
    freq.put("sv", 13201);
    freq.put("su", 49746);
    freq.put("st", 215124);
    freq.put("q", 1633);
    freq.put("sj", 2476);
    freq.put("si", 171906);
    freq.put("sh", 5275);
    freq.put("so", 30621);
    freq.put("sn", 1670);
    freq.put("sm", 5723);
    freq.put("sl", 7481);
    freq.put("sc", 2341);
    freq.put("sa", 155918);
    freq.put("yli", 5834);
    freq.put("se", 139811);
    freq.put("Ru", 2993);
    freq.put("tty", 9077);
    freq.put("ea\u0308", 2738);
    freq.put("no ", 2124);
    freq.put("ttu", 17456);
    freq.put("lsi", 2865);
    freq.put("Re", 3883);
    freq.put("tti", 29985);
    freq.put("tto", 7420);
    freq.put("Ra", 6455);
    freq.put("tta", 37250);
    freq.put("Ro", 4731);
    freq.put("Ri", 2393);
    freq.put("tte", 15326);
    freq.put("ppe", 1921);
    freq.put("a\u0308hi", 1621);
    freq.put("jia", 1786);
    freq.put(" ai", 10388);
    freq.put(" aj", 3176);
    freq.put("a\u0308hd", 1555);
    freq.put(" al", 26047);
    freq.put(" am", 2608);
    freq.put(" an", 4850);
    freq.put(" ar", 5107);
    freq.put(" as", 8761);
    freq.put(" au", 2714);
    freq.put(" av", 3055);
    freq.put("nsa", 12409);
    freq.put("a\u0308ht", 3405);
    freq.put("nol", 2730);
    freq.put("nom", 2361);
    freq.put("non", 3636);
    freq.put("noi", 8508);
    freq.put("kku", 3944);
    freq.put("kko", 10268);
    freq.put("kki", 11721);
    freq.put("kke", 3841);
    freq.put("ng ", 3916);
    freq.put("son", 3580);
    freq.put("kka", 15414);
    freq.put("nos", 4123);
    freq.put("ji ", 2297);
    freq.put("em", 29073);
    freq.put("el", 141223);
    freq.put("eo", 9816);
    freq.put("en", 311708);
    freq.put("ei", 64027);
    freq.put("eh", 18148);
    freq.put("ek", 30007);
    freq.put("ej", 4585);
    freq.put("ee", 73047);
    freq.put("ed", 14005);
    freq.put("eg", 3976);
    freq.put("ef", 1593);
    freq.put("ea", 17917);
    freq.put("tto\u0308", 2890);
    freq.put("ec", 3419);
    freq.put("eb", 2211);
    freq.put("ey", 5808);
    freq.put("eu", 16676);
    freq.put("et", 103119);
    freq.put("ew", 1828);
    freq.put("ev", 21342);
    freq.put("ep", 7092);
    freq.put("es", 102393);
    freq.put("er", 103228);
    freq.put("eja", 2716);
    freq.put("G", 13964);
    freq.put("ort", 3782);
    freq.put("e ", 102313);
    freq.put("orn", 1628);
    freq.put("oro", 2190);
    freq.put("orm", 3104);
    freq.put("ork", 3647);
    freq.put("ori", 12794);
    freq.put("org", 2171);
    freq.put("ord", 2513);
    freq.put("ore", 3159);
    freq.put("lme", 5378);
    freq.put("ora", 3303);
    freq.put("tio\u0308", 3363);
    freq.put("onk", 9689);
    freq.put("oni", 10795);
    freq.put("onn", 20892);
    freq.put("ono", 2022);
    freq.put("ona", 6281);
    freq.put("ong", 1915);
    freq.put("one", 7607);
    freq.put("ua ", 4041);
    freq.put("ons", 4191);
    freq.put("ont", 4754);
    freq.put("Eur", 2720);
    freq.put("ial", 8370);
    freq.put("ian", 13283);
    freq.put("uku", 7377);
    freq.put("iaa", 4991);
    freq.put("uko", 2518);
    freq.put("ukk", 6046);
    freq.put("yis", 3850);
    freq.put("uke", 1610);
    freq.put("ias", 7499);
    freq.put("hum", 3543);
    freq.put("x ", 5327);
    freq.put("huo", 1796);
    freq.put("yi ", 2699);
    freq.put("ia ", 28344);
    freq.put("r", 475344);
    freq.put("nie", 2772);
    freq.put("and", 6936);
    freq.put("ane", 3551);
    freq.put("sai", 4605);
    freq.put("ang", 3334);
    freq.put("ana", 14302);
    freq.put("sam", 4120);
    freq.put("anc", 1814);
    freq.put("anm", 2516);
    freq.put("ann", 13433);
    freq.put("ano", 5725);
    freq.put("anh", 3197);
    freq.put("ani", 13808);
    freq.put("anj", 1817);
    freq.put("ank", 6571);
    freq.put("ant", 14494);
    freq.put("anu", 4220);
    freq.put("ans", 18785);
    freq.put("sas", 5453);
    freq.put("sar", 9940);
    freq.put("sav", 3217);
    freq.put("sat", 2386);
    freq.put("Do", 1694);
    freq.put("Di", 2497);
    freq.put("De", 2688);
    freq.put("Da", 2655);
    freq.put("an ", 106763);
    freq.put("sa ", 88364);
    freq.put("luu", 4990);
    freq.put(" Le", 5486);
    freq.put(" La", 6921);
    freq.put(" Lo", 3341);
    freq.put("D ", 1819);
    freq.put(" Lu", 2432);
    freq.put("lli", 38165);
    freq.put("set", 8009);
    freq.put("tka", 4817);
    freq.put("tki", 4098);
    freq.put("nla", 2791);
    freq.put("ses", 19353);
    freq.put("Wa", 2313);
    freq.put("ce ", 2305);
    freq.put("Wi", 2315);
    freq.put("ser", 1954);
    freq.put(" pr", 4112);
    freq.put("io\u0308 ", 2528);
    freq.put(" pu", 9566);
    freq.put("H", 28813);
    freq.put(" py", 2739);
    freq.put(" px", 2387);
    freq.put("dys", 6375);
    freq.put(" pa", 14359);
    freq.put("ssi", 7227);
    freq.put(" pe", 20224);
    freq.put("ja\u0308", 31523);
    freq.put(" pi", 14437);
    freq.put(" po", 10381);
    freq.put("gen", 2252);
    freq.put("utk", 3663);
    freq.put("px ", 2372);
    freq.put("tka\u0308", 1786);
    freq.put("uti", 2698);
    freq.put("uvo", 2424);
    freq.put("uto", 3590);
    freq.put("kel", 5236);
    freq.put("rme", 1785);
    freq.put("tu ", 15401);
    freq.put("rmi", 2119);
    freq.put("yty", 2014);
    freq.put("ytt", 9230);
    freq.put("rko", 8356);
    freq.put("yte", 5446);
    freq.put("uos", 6389);
    freq.put("tus", 10527);
    freq.put("utt", 14676);
    freq.put("ju", 18610);
    freq.put("tur", 3509);
    freq.put("utu", 7065);
    freq.put("tut", 5144);
    freq.put("tuu", 8595);
    freq.put("tuv", 3012);
    freq.put("tui", 4969);
    freq.put("ue ", 4574);
    freq.put("jo", 83376);
    freq.put("tul", 5059);
    freq.put("ji", 8870);
    freq.put("tun", 13048);
    freq.put(" pa\u0308", 9746);
    freq.put("je", 25016);
    freq.put("tud", 2510);
    freq.put("ja", 144917);
    freq.put("a\u0308in", 8551);
    freq.put("vun", 2514);
    freq.put("vuo", 32425);
    freq.put("vul", 3123);
    freq.put("P ", 1899);
    freq.put("ko ", 7803);
    freq.put("s", 1099978);
    freq.put("tuk", 7469);
    freq.put("a\u0308iv", 1941);
    freq.put("yt ", 5088);
    freq.put("a\u0308is", 10749);
    freq.put("iva\u0308", 3912);
    freq.put("unu", 3435);
    freq.put("tuo", 5296);
    freq.put("por", 1632);
    freq.put("pol", 4180);
    freq.put("poh", 4180);
    freq.put("kev", 1653);
    freq.put("ket", 2834);
    freq.put("kes", 10316);
    freq.put("ei ", 3830);
    freq.put("nit", 5273);
    freq.put("la\u0308h", 6121);
    freq.put("nsa\u0308", 4958);
    freq.put("eis", 18168);
    freq.put("eit", 8348);
    freq.put("hdy", 6548);
    freq.put("hde", 8081);
    freq.put("eid", 4335);
    freq.put("hdo", 2167);
    freq.put("eik", 4720);
    freq.put("eim", 3841);
    freq.put("eil", 7078);
    freq.put("hdi", 4168);
    freq.put("ein", 8482);
    freq.put("ive", 3576);
    freq.put("iva", 11789);
    freq.put("ivo", 1659);
    freq.put("ivi", 6748);
    freq.put("oi ", 3679);
    freq.put("nso", 2855);
    freq.put("ivu", 2547);
    freq.put("oku", 9166);
    freq.put(" Me", 4668);
    freq.put("par", 4524);
    freq.put(" Ma", 12197);
    freq.put(" Mo", 4358);
    freq.put(" Mi", 4965);
    freq.put(" Mu", 3189);
    freq.put("pah", 2670);
    freq.put("I ", 2891);
    freq.put("pak", 1785);
    freq.put("pal", 14678);
    freq.put("pan", 6844);
    freq.put("oin", 13137);
    freq.put("oim", 14211);
    freq.put("oil", 4642);
    freq.put("oik", 5181);
    freq.put("oih", 1702);
    freq.put("I", 21256);
    freq.put("oid", 5498);
    freq.put("yd", 4538);
    freq.put("II", 1871);
    freq.put("naa", 4824);
    freq.put("Ete", 1912);
    freq.put("oiv", 1619);
    freq.put("oit", 25419);
    freq.put("ois", 23808);
    freq.put("oir", 1655);
    freq.put("nm", 4904);
    freq.put("oka", 27584);
    freq.put("yhm", 2893);
    freq.put("Is", 2133);
    freq.put("It", 2586);
    freq.put("yhd", 7827);
    freq.put("pa ", 1685);
    freq.put("In", 4312);
    freq.put("uje", 1776);
    freq.put("uja", 2763);
    freq.put("yht", 15566);
    freq.put("nai", 6761);
    freq.put("mma\u0308", 7757);
    freq.put("va\u0308", 26642);
    freq.put("mo ", 3241);
    freq.put("okk", 2554);
    freq.put("tim", 2695);
    freq.put("a\u0308ja\u0308", 6711);
    freq.put("ami", 8254);
    freq.put("amm", 4533);
    freq.put("amo", 2056);
    freq.put("ama", 17130);
    freq.put("ame", 4479);
    freq.put("moo", 2276);
    freq.put("mon", 6257);
    freq.put("amp", 3132);
    freq.put("ta\u0308h", 1876);
    freq.put("tia", 5511);
    freq.put("t", 1169051);
    freq.put("poi", 2560);
    freq.put("Kun", 1618);
    freq.put("o ", 46103);
    freq.put("ka\u0308r", 1779);
    freq.put("ka\u0308s", 5110);
    freq.put("mpi", 5319);
    freq.put("nme", 1667);
    freq.put("nma", 1873);
    freq.put("oo", 22586);
    freq.put("on", 220535);
    freq.put("om", 49202);
    freq.put("ol", 88347);
    freq.put("ok", 63100);
    freq.put("oj", 13195);
    freq.put("oi", 101083);
    freq.put("oh", 26450);
    freq.put("ack", 1788);
    freq.put("of", 6585);
    freq.put("oe", 6505);
    freq.put("od", 21394);
    freq.put("oc", 5124);
    freq.put("ob", 3163);
    freq.put("oa", 12733);
    freq.put("oy", 1883);
    freq.put("ow", 2927);
    freq.put("ov", 18707);
    freq.put("ou", 20507);
    freq.put("ot", 48882);
    freq.put("os", 73162);
    freq.put("or", 48012);
    freq.put("op", 25063);
    freq.put("Ni", 3815);
    freq.put("yyp", 2141);
    freq.put("yys", 2076);
    freq.put("No", 3154);
    freq.put("Na", 2575);
    freq.put("Ne", 4302);
    freq.put("yyl", 1824);
    freq.put("het", 1965);
    freq.put("eht", 6057);
    freq.put("log", 4285);
    freq.put("her", 2750);
    freq.put("lok", 9030);
    freq.put("loi", 6423);
    freq.put("lon", 3666);
    freq.put("lom", 4409);
    freq.put("hee", 1552);
    freq.put("ehd", 2924);
    freq.put("lot", 1540);
    freq.put("lou", 2403);
    freq.put("hel", 4032);
    freq.put("hem", 2103);
    freq.put("hen", 6953);
    freq.put("hei", 7575);
    freq.put("ehi", 4544);
    freq.put("uin", 4870);
    freq.put("J", 16698);
    freq.put("jul", 11521);
    freq.put("rje", 7814);
    freq.put("yy ", 2993);
    freq.put("rja", 16764);
    freq.put("rjo", 6361);
    freq.put("lo ", 3012);
    freq.put("ja\u0308a\u0308", 2989);
    freq.put("as ", 6418);
    freq.put("he ", 6389);
    freq.put("aa", 139980);
    freq.put("ac", 6773);
    freq.put("ab", 3846);
    freq.put("ae", 6848);
    freq.put("ad", 13018);
    freq.put("ag", 5956);
    freq.put("af", 2453);
    freq.put("ai", 159817);
    freq.put("ah", 19189);
    freq.put("ak", 51088);
    freq.put("aj", 32823);
    freq.put("am", 44148);
    freq.put("al", 188447);
    freq.put("ao", 2348);
    freq.put("an", 226249);
    freq.put("ap", 28311);
    freq.put("as", 103098);
    freq.put("ar", 90264);
    freq.put("au", 43994);
    freq.put("at", 82974);
    freq.put("av", 32524);
    freq.put("ay", 3699);
    freq.put("az", 1738);
    freq.put("ja\u0308 ", 5912);
    freq.put("ota", 8496);
    freq.put("igh", 2049);
    freq.put("a ", 521046);
    freq.put("ja\u0308l", 4462);
    freq.put("ja\u0308n", 3177);
    freq.put("at ", 26536);
    freq.put("u", 751889);
    freq.put("Bri", 2185);
    freq.put("uit", 1991);
    freq.put("ja\u0308s", 2729);
    freq.put("ja\u0308r", 9906);
    freq.put("alo", 7802);
    freq.put("all", 43431);
    freq.put("alm", 6123);
    freq.put("alk", 10647);
    freq.put("Val", 1869);
    freq.put("ali", 18156);
    freq.put("ale", 9704);
    freq.put("alb", 7609);
    freq.put("to\u0308s", 1710);
    freq.put("ala", 40225);
    freq.put("to\u0308n", 2023);
    freq.put("alv", 4153);
    freq.put("alt", 16363);
    freq.put("alu", 15472);
    freq.put("gr", 3324);
    freq.put("ty", 54901);
    freq.put("tt", 139450);
    freq.put("tu", 95699);
    freq.put("tr", 16390);
    freq.put("ts", 24815);
    freq.put("to", 89637);
    freq.put("tl", 2100);
    freq.put("tk", 13593);
    freq.put("th", 11168);
    freq.put("ti", 135644);
    freq.put("te", 142275);
    freq.put("ta", 258052);
    freq.put("ta\u0308j", 3398);
    freq.put("edi", 2493);
    freq.put("smi", 2339);
    freq.put("ta\u0308m", 6823);
    freq.put("mpa", 1715);
    freq.put("rc", 2086);
    freq.put("ysi", 1754);
    freq.put("al ", 4672);
    freq.put("edo", 1603);
    freq.put("ta\u0308y", 1596);
    freq.put("rm", 9935);
    freq.put("ta\u0308r", 1635);
    freq.put("to\u0308 ", 2585);
    freq.put(" Ni", 3790);
    freq.put("ro", 37223);
    freq.put(" No", 3136);
    freq.put(" Na", 2563);
    freq.put(" Ne", 4266);
    freq.put("ge", 9008);
    freq.put("ri", 107434);
    freq.put("sma", 1538);
    freq.put("hyv", 1693);
    freq.put("t ", 86930);
    freq.put("teh", 4545);
    freq.put("pul", 1657);
    freq.put("tek", 5492);
    freq.put("tel", 25974);
    freq.put("ga", 10572);
    freq.put("ten", 19694);
    freq.put("teo", 3855);
    freq.put("edu", 2200);
    freq.put("tee", 16061);
    freq.put("ter", 13778);
    freq.put("tes", 1638);
    freq.put("tet", 23609);
    freq.put("gl", 5520);
    freq.put("rma", 3198);
    freq.put("to\u0308", 12963);
    freq.put("ose", 3031);
    freq.put("suk", 6559);
    freq.put("suu", 15921);
    freq.put("sut", 2418);
    freq.put("lle", 23098);
    freq.put("ta\u0308", 77533);
    freq.put(" ru", 4569);
    freq.put("mpa\u0308", 2564);
    freq.put("lko", 3906);
    freq.put("a\u0308yt", 13595);
    freq.put("K", 43440);
    freq.put(" ry", 2522);
    freq.put(" Am", 2670);
    freq.put(" re", 3082);
    freq.put(" ra", 14800);
    freq.put(" ro", 4580);
    freq.put(" ri", 4303);
    freq.put("s\u030c", 2606);
    freq.put("lki", 3385);
    freq.put(" Ar", 3519);
    freq.put("lke", 3142);
    freq.put("nto", 10581);
    freq.put("vie", 4226);
    freq.put("vii", 6538);
    freq.put("vin", 6040);
    freq.put("vio", 1556);
    freq.put("vil", 2731);
    freq.put("vir", 4221);
    freq.put("rke", 4145);
    freq.put("rka", 1913);
    freq.put("vit", 3912);
    freq.put("puu", 2017);
    freq.put("S ", 3929);
    freq.put(" s ", 2297);
    freq.put("rkk", 7003);
    freq.put("mma", 5671);
    freq.put("avu", 2827);
    freq.put("de ", 3246);
    freq.put("pus", 1680);
    freq.put("vi ", 2985);
    freq.put("a\u0308he", 3536);
    freq.put("Su", 13153);
    freq.put("St", 4721);
    freq.put("Si", 6786);
    freq.put("Sh", 1709);
    freq.put("So", 3993);
    freq.put("Sa", 10443);
    freq.put("Se", 20320);
    freq.put("ey ", 1541);
    freq.put("lku", 3582);
    freq.put("a\u0308ks", 2395);
    freq.put(" di", 1711);
    freq.put("Int", 2022);
    freq.put(" de", 3555);
    freq.put("des", 8657);
    freq.put("det", 3714);
    freq.put("dek", 2312);
    freq.put("del", 8280);
    freq.put("dem", 1603);
    freq.put("den", 24947);
    freq.put("a\u0308ka", 1964);
    freq.put("a\u0308ki", 2767);
    freq.put("pro", 3960);
    freq.put("f ", 4183);
    freq.put("lal", 1802);
    freq.put("ati", 12192);
    freq.put("ryh", 2885);
    freq.put("a\u0308a\u0308s", 2129);
    freq.put("a\u0308a\u0308r", 4190);
    freq.put("att", 13242);
    freq.put("a\u0308a\u0308t", 2724);
    freq.put("a\u0308a\u0308k", 4426);
    freq.put("a\u0308a\u0308n", 18825);
    freq.put("r ", 15286);
    freq.put("fr", 2666);
    freq.put("fa", 2058);
    freq.put("eka\u0308", 5887);
    freq.put("fe", 3904);
    freq.put("fi", 6772);
    freq.put("fo", 3746);
    freq.put("a", 1814181);
    freq.put("ry ", 2410);
    freq.put("ne ", 6951);
    freq.put("o\u0308", 56679);
    freq.put("a\u0308a\u0308 ", 10320);
    freq.put("ito", 6246);
    freq.put("itk", 2090);
    freq.put("ger", 1575);
    freq.put("iti", 5058);
    freq.put("y ", 23865);
    freq.put("ite", 16460);
    freq.put("uvu", 5385);
    freq.put("ita", 17408);
    freq.put("uvi", 3760);
    freq.put("ity", 9715);
    freq.put("uva", 18498);
    freq.put("itt", 43813);
    freq.put("itu", 9149);
    freq.put("its", 13426);
    freq.put(" sa\u0308", 4588);
    freq.put("paa", 2641);
    freq.put("yn ", 4172);
    freq.put("yi", 8456);
    freq.put("yh", 29899);
    freq.put("yk", 18251);
    freq.put("ym", 10818);
    freq.put("yl", 20580);
    freq.put("yn", 15218);
    freq.put("ya", 1921);
    freq.put("ye", 9120);
    freq.put("L", 28771);
    freq.put("it ", 5916);
    freq.put("yy", 14572);
    freq.put("uht", 1985);
    freq.put("uhu", 1855);
    freq.put("oke", 2183);
    freq.put("pai", 9231);
    freq.put("oki", 3937);
    freq.put("yp", 4560);
    freq.put("ys", 23779);
    freq.put("yr", 6697);
    freq.put("yt", 27603);
    freq.put("oko", 8846);
    freq.put("yv", 6669);
    freq.put("Ran", 1941);
    freq.put("yne", 1918);
    freq.put(" a\u0308a\u0308", 2036);
    freq.put("yny", 2515);
    freq.put("ynt", 3210);
    freq.put(" sy", 5905);
    freq.put("ita\u0308", 10709);
    freq.put(" st", 3683);
    freq.put(" su", 25086);
    freq.put(" si", 27049);
    freq.put(" so", 8389);
    freq.put("oks", 6588);
    freq.put(" sa", 23518);
    freq.put(" se", 22713);
    freq.put("ass", 30398);
    freq.put(" el", 17426);
    freq.put("pun", 10901);
    freq.put("puo", 7107);
    freq.put("puh", 2589);
    freq.put("asv", 4804);
    freq.put("asu", 5324);
    freq.put("ast", 26494);
    freq.put(" Al", 7546);
    freq.put("ya\u0308", 2288);
    freq.put(" An", 4363);
    freq.put("asa", 4886);
    freq.put(" As", 1683);
    freq.put("mmi", 7415);
    freq.put(" Au", 2195);
    freq.put("ase", 5553);
    freq.put("ask", 4888);
    freq.put("st ", 1959);
    freq.put("asi", 8287);
    freq.put("aso", 1854);
    freq.put("pur", 1783);
    freq.put("yo\u0308", 17077);
    freq.put("El", 2967);
    freq.put("En", 2950);
    freq.put("jet", 1556);
    freq.put("w", 11494);
    freq.put("Eu", 3024);
    freq.put("Et", 2349);
    freq.put("Es", 2046);
    freq.put("le ", 23672);
    freq.put("koi", 14746);
    freq.put("jes", 7295);
    freq.put(" en", 13349);
    freq.put("koj", 1821);
    freq.put("kom", 3392);
    freq.put(" ei", 4106);
    freq.put("koo", 4082);
    freq.put("kon", 11074);
    freq.put(" ed", 3633);
    freq.put("koe", 1980);
    freq.put(" et", 8124);
    freq.put("kos", 5488);
    freq.put("kor", 5268);
    freq.put("kou", 3762);
    freq.put("kot", 3952);
    freq.put("jel", 4529);
    freq.put(" es", 9200);
    freq.put("tom", 3430);
    freq.put("nce", 1684);
    freq.put("ste", 34759);
    freq.put("b", 43435);
    freq.put("sta", 74007);
    freq.put("ka\u0308", 31248);
    freq.put("aam", 4542);
    freq.put("jen", 8431);
    freq.put("aan", 46070);
    freq.put("aai", 4807);
    freq.put("sti", 27582);
    freq.put("aak", 5208);
    freq.put("aaj", 5209);
    freq.put("aat", 11110);
    freq.put("aav", 4444);
    freq.put(" er", 7980);
    freq.put("aas", 4039);
    freq.put("aar", 7457);
    freq.put("sty", 7941);
    freq.put("ka ", 40830);
    freq.put("uet", 2172);
    freq.put("o\u0308n ", 5342);
    freq.put("lie", 2208);
    freq.put("k ", 7419);
    freq.put("lia", 6855);
    freq.put("lil", 3081);
    freq.put("Kir", 1567);
    freq.put("lin", 25643);
    freq.put("lio", 3340);
    freq.put("lii", 12989);
    freq.put("lij", 5839);
    freq.put("lik", 3266);
    freq.put("lit", 6604);
    freq.put("liv", 3460);
    freq.put("lip", 2086);
    freq.put("lis", 35039);
    freq.put("lla\u0308", 17871);
    freq.put("kaa", 14665);
    freq.put("kak", 4624);
    freq.put("kai", 21386);
    freq.put("kah", 2946);
    freq.put("M", 37698);
    freq.put("kan", 20757);
    freq.put("kam", 1710);
    freq.put("kal", 9712);
    freq.put("kas", 12031);
    freq.put("kar", 4289);
    freq.put("kap", 6608);
    freq.put("kau", 16540);
    freq.put("kat", 4283);
    freq.put("rha", 2376);
    freq.put("The", 3947);
    freq.put("rhe", 3181);
    freq.put("sta\u0308", 20839);
    freq.put("ka", 163517);
    freq.put("li ", 38792);
    freq.put("ke", 65747);
    freq.put("kk", 48142);
    freq.put("ki", 95289);
    freq.put("ko", 85957);
    freq.put("kn", 1816);
    freq.put("kl", 2002);
    freq.put("ks", 65607);
    freq.put("kr", 5885);
    freq.put("sto\u0308", 6003);
    freq.put("ku", 90075);
    freq.put("kt", 5970);
    freq.put("ky", 14212);
    freq.put("rte", 2990);
    freq.put("rta", 4520);
    freq.put("rto", 3696);
    freq.put("rti", 3436);
    freq.put("rtt", 1850);
    freq.put("oje", 6434);
    freq.put("oja", 5307);
    freq.put("ymp", 3885);
    freq.put("Ju", 3085);
    freq.put("ies", 3794);
    freq.put("ier", 2897);
    freq.put("iet", 9042);
    freq.put("ieh", 1857);
    freq.put("iek", 1604);
    freq.put("Jo", 4525);
    freq.put("iem", 2939);
    freq.put("iel", 9758);
    freq.put("ien", 20960);
    freq.put("ymi", 2202);
    freq.put("ied", 2257);
    freq.put("his", 2803);
    freq.put("hit", 5065);
    freq.put("rt ", 1812);
    freq.put("ika\u0308", 1979);
    freq.put("hin", 8148);
    freq.put("aal", 13155);
    freq.put("ie ", 2310);
    freq.put(" Be", 3463);
    freq.put("sev", 3309);
    freq.put("arr", 3315);
    freq.put("ars", 2606);
    freq.put("art", 6849);
    freq.put("aru", 3626);
    freq.put("For", 1614);
    freq.put(" Bo", 2840);
    freq.put(" Bi", 1601);
    freq.put(" Bu", 1591);
    freq.put("ara", 7612);
    freq.put("see", 16044);
    freq.put("ard", 3175);
    freq.put("are", 4235);
    freq.put(" Br", 4522);
    freq.put("arh", 2305);
    freq.put("ari", 15453);
    freq.put("arj", 11397);
    freq.put("ark", 11086);
    freq.put("arl", 1651);
    freq.put("arm", 2145);
    freq.put("sei", 5713);
    freq.put("aro", 2059);
    freq.put("stu", 19044);
    freq.put("yma\u0308", 1567);
    freq.put("ko\u0308", 4127);
    freq.put("iks", 5910);
    freq.put("yde", 2513);
    freq.put("str", 3547);
    freq.put("iku", 7225);
    freq.put("uut", 11944);
    freq.put("uus", 11398);
    freq.put("uur", 9061);
    freq.put("ar ", 2391);
    freq.put("uul", 10457);
    freq.put("ika", 17282);
    freq.put("uun", 9740);
    freq.put("ike", 7607);
    freq.put("se ", 7339);
    freq.put("ikk", 20680);
    freq.put("uud", 5759);
    freq.put("iki", 6034);
    freq.put("iko", 8699);
    freq.put(" Pr", 3297);
    freq.put("c", 44492);
    freq.put(" Pu", 2902);
    freq.put(" Pa", 6894);
    freq.put(" Pe", 5834);
    freq.put(" Pi", 3788);
    freq.put(" Po", 6838);
    freq.put("ria\u0308", 3343);
    freq.put("pr", 6312);
    freq.put("ps", 3220);
    freq.put("pp", 18507);
    freq.put("pt", 2602);
    freq.put("pu", 33575);
    freq.put("px", 2388);
    freq.put("py", 4209);
    freq.put("pa", 50151);
    freq.put("pe", 39610);
    freq.put("ph", 2309);
    freq.put("pi", 40558);
    freq.put("po", 19855);
    freq.put("pl", 2749);
    freq.put(" ty", 5276);
    freq.put("ty ", 6437);
    freq.put(" tu", 19858);
    freq.put("gas", 2278);
    freq.put("N", 19249);
    freq.put(" to", 18439);
    freq.put("gan", 2134);
    freq.put(" ti", 8862);
    freq.put(" th", 5224);
    freq.put(" te", 13642);
    freq.put(" ta", 38855);
    freq.put("sak", 3935);
    freq.put("p ", 3699);
    freq.put("rit", 12816);
    freq.put("ris", 12311);
    freq.put("rin", 19152);
    freq.put("rio", 2073);
    freq.put("ril", 5111);
    freq.put("rim", 2324);
    freq.put("sa\u0308 ", 25127);
    freq.put("rik", 9617);
    freq.put("rii", 3347);
    freq.put("rie", 2399);
    freq.put("ric", 1741);
    freq.put("ria", 8783);
    freq.put("vy ", 2051);
    freq.put("pa\u0308", 16825);
    freq.put("sa\u0308v", 1927);
    freq.put("tis", 9101);
    freq.put("syn", 3354);
    freq.put("sa\u0308l", 3359);
    freq.put("syy", 2751);
    freq.put(" ta\u0308", 4808);
    freq.put("ri ", 14183);
    freq.put("sa\u0308k", 2119);
    freq.put("lim", 2511);
    freq.put(" fi", 2104);
    freq.put("hje", 3366);
    freq.put("ija\u0308", 3525);
    freq.put("hjo", 5005);
    freq.put("sal", 8568);
    freq.put("ohj", 13237);
    freq.put("rgi", 2577);
    freq.put("app", 6574);
    freq.put("d", 158713);
    freq.put("ljo", 1577);
    freq.put("eet", 6503);
    freq.put("lje", 1833);
    freq.put("pa\u0308r", 2295);
    freq.put("ees", 6176);
    freq.put("eel", 9070);
    freq.put("yla\u0308", 5863);
    freq.put("een", 37770);
    freq.put("pa\u0308i", 2568);
    freq.put("elt", 10887);
    freq.put("b ", 4269);
    freq.put("saa", 11689);
    freq.put("ija", 15115);
    freq.put("ijo", 3212);
    freq.put("pet", 1794);
    freq.put("per", 21853);
    freq.put("pel", 8616);
    freq.put("be", 5208);
    freq.put("ea\u0308 ", 1619);
    freq.put("run", 2801);
    freq.put("ba", 5388);
    freq.put("bl", 1718);
    freq.put("bo", 3540);
    freq.put("bi", 4927);
    freq.put("O", 13807);
    freq.put("bu", 11145);
    freq.put("oen", 2647);
    freq.put("br", 3098);
    freq.put("oel", 2434);
    freq.put("rus", 12209);
    freq.put("von", 1808);
    freq.put("ruu", 3504);
    freq.put("a\u0308", 426790);
    freq.put("lja\u0308", 2124);
    freq.put("yle", 4657);
    freq.put("aa ", 30258);
    freq.put("idi", 2094);
    freq.put("yll", 2070);
    freq.put("ide", 16311);
    freq.put("ida", 3705);
    freq.put("nsi", 11891);
    freq.put("nsk", 3706);
    freq.put("la\u0308a\u0308", 3392);
    freq.put("tuj", 1880);
    freq.put(" uu", 2456);
    freq.put("nse", 1616);
    freq.put(" ur", 1664);
    freq.put(" us", 4512);
    freq.put(" ul", 2520);
    freq.put("kut", 5564);
    freq.put("Ta\u0308", 2310);
    freq.put("nss", 4946);
    freq.put("ut ", 13926);
    freq.put("voi", 10127);
    freq.put("u ", 38729);
    freq.put(" Ch", 3183);
    freq.put(" Co", 4800);
    freq.put("ns ", 1897);
    freq.put("lka", 14232);
    freq.put(" Ca", 3824);
    freq.put("tum", 4274);
    freq.put("uta", 9377);
    freq.put("ute", 5204);
    freq.put("uu", 71208);
    freq.put("ut", 63413);
    freq.put("uv", 30695);
    freq.put("up", 18134);
    freq.put("us", 87239);
    freq.put("ur", 38607);
    freq.put("um", 30283);
    freq.put("ul", 59174);
    freq.put("uo", 96118);
    freq.put("un", 78305);
    freq.put("ui", 22148);
    freq.put("uh", 10868);
    freq.put("uk", 45990);
    freq.put("uj", 5727);
    freq.put("ue", 19283);
    freq.put("ud", 16569);
    freq.put("ug", 2138);
    freq.put("z", 7860);
    freq.put("ua", 10701);
    freq.put("uc", 1658);
    freq.put("ub", 2312);
    freq.put("la\u0308i", 5398);
    freq.put("Tu", 4391);
    freq.put("Tr", 2204);
    freq.put("la\u0308n", 3940);
    freq.put("la\u0308m", 2523);
    freq.put("To", 3873);
    freq.put("la\u0308p", 1604);
    freq.put("Th", 5318);
    freq.put("Ti", 2566);
    freq.put("lym", 1752);
    freq.put("Te", 3907);
    freq.put("lyh", 1732);
    freq.put("Ta", 5984);
    freq.put("A ", 2604);
    freq.put("Mar", 3439);
    freq.put("nak", 1691);
    freq.put("a\u0308t ", 5667);
    freq.put("nan", 9972);
    freq.put("nal", 6875);
    freq.put("nas", 6250);
    freq.put("nat", 3023);
    freq.put("gra", 1797);
    freq.put("la\u0308 ", 21592);
    freq.put("ppu", 2417);
    freq.put("tua", 2491);
    freq.put("na ", 39872);
    freq.put("e", 1194104);
    freq.put("svi", 2330);
    freq.put("Am", 2679);
    freq.put("Al", 7577);
    freq.put("An", 4463);
    freq.put("As", 1696);
    freq.put("Ar", 3564);
    freq.put("Au", 2202);
    freq.put("a\u0308tt", 2038);
    freq.put(" b", 5870);
    freq.put(" c", 2712);
    freq.put("gu", 2320);
    freq.put(" a", 72510);
    freq.put(" f", 6572);
    freq.put(" g", 3193);
    freq.put(" d", 8045);
    freq.put(" e", 69090);
    freq.put(" j", 161666);
    freq.put(" k", 172428);
    freq.put(" h", 39470);
    freq.put(" i", 21438);
    freq.put(" n", 43615);
    freq.put(" o", 180629);
    freq.put(" l", 70812);
    freq.put(" m", 89685);
    freq.put(" r", 34331);
    freq.put(" s", 126171);
    freq.put(" p", 89643);
    freq.put(" v", 98965);
    freq.put(" t", 117334);
    freq.put(" u", 13744);
    freq.put("go", 5014);
    freq.put("gn", 1824);
    freq.put(" y", 39165);
    freq.put("gi", 17723);
    freq.put("gh", 2779);
    freq.put(" B", 21331);
    freq.put(" C", 19265);
    freq.put(" A", 36093);
    freq.put(" F", 12406);
    freq.put(" G", 12952);
    freq.put(" D", 13481);
    freq.put(" E", 21275);
    freq.put(" J", 16375);
    freq.put(" K", 41900);
    freq.put(" H", 27293);
    freq.put(" I", 17045);
    freq.put(" N", 17648);
    freq.put(" O", 11538);
    freq.put(" L", 26471);
    freq.put(" M", 33953);
    freq.put(" R", 22636);
    freq.put(" S", 71766);
    freq.put(" P", 35182);
    freq.put(" V", 22294);
    freq.put(" W", 8721);
    freq.put(" T", 34378);
    freq.put(" U", 6908);
    freq.put(" Z", 1697);
    freq.put(" Y", 9517);
    freq.put("Nor", 1531);
    freq.put("ed ", 1799);
    freq.put("P", 38188);
    freq.put("g ", 5897);
    freq.put("tri", 7061);
    freq.put("evi", 4106);
    freq.put("kse", 20115);
    freq.put("tro", 3179);
    freq.put("tra", 3772);
    freq.put("eva", 7898);
    freq.put("us ", 19751);
    freq.put("eve", 1697);
    freq.put("evy", 4434);
    freq.put("rro", 1797);
    freq.put("too", 2936);
    freq.put(" a\u0308", 2798);
    freq.put("uee", 7376);
    freq.put("rre", 2394);
    freq.put("rra", 3831);
    freq.put("odi", 1977);
    freq.put("odo", 4669);
    freq.put("oda", 3354);
    freq.put("ode", 9371);
    freq.put("rd ", 1882);
    freq.put("lee", 7823);
    freq.put("leh", 3152);
    freq.put("lei", 7201);
    freq.put("lek", 2031);
    freq.put("lel", 2977);
    freq.put("lem", 3429);
    freq.put("len", 7655);
    freq.put("ler", 1630);
    freq.put("les", 3513);
    freq.put("let", 2489);
    freq.put("lev", 10595);
    freq.put("kue", 1696);
    freq.put("eva\u0308", 1690);
    freq.put("nva\u0308", 1760);
    freq.put("ule", 2174);
    freq.put("rdi", 1756);
    freq.put(" Do", 1656);
    freq.put(" Di", 2463);
    freq.put(" De", 2676);
    freq.put("kyi", 1827);
    freq.put(" Da", 2631);
    freq.put("apu", 2355);
    freq.put("api", 2097);
    freq.put("ii ", 2634);
    freq.put("Ven", 3558);
    freq.put("apa", 10451);
    freq.put("ape", 2308);
    freq.put("Fr", 2159);
    freq.put(" va\u0308", 7263);
    freq.put("usa", 2048);
    freq.put("kyl", 5052);
    freq.put("usk", 5912);
    freq.put("usi", 8604);
    freq.put("Fa", 1585);
    freq.put("ust", 26922);
    freq.put("uss", 6964);
    freq.put("sia\u0308", 2875);
    freq.put("Fi", 2245);
    freq.put("Fo", 2415);
    freq.put("iit", 11463);
    freq.put("iiv", 3159);
    freq.put("iip", 1650);
    freq.put("iis", 3357);
    freq.put("iir", 7370);
    freq.put("iid", 1915);
    freq.put("iim", 1601);
    freq.put("iil", 1871);
    freq.put("iin", 34905);
    freq.put("iih", 2036);
    freq.put("iik", 12079);
    freq.put(" Ru", 2990);
    freq.put("f", 29615);
    freq.put("Ja", 4546);
    freq.put(" Re", 3856);
    freq.put("og", 7134);
    freq.put(" Ra", 6410);
    freq.put(" Ro", 4711);
    freq.put(" Ri", 2382);
    freq.put("tat", 3910);
    freq.put("tau", 2602);
    freq.put("tav", 11283);
    freq.put("tap", 4732);
    freq.put("tar", 15686);
    freq.put("tas", 5911);
    freq.put("taa", 33105);
    freq.put("tal", 15729);
    freq.put("tam", 13647);
    freq.put("tan", 13725);
    freq.put("tai", 23079);
    freq.put("taj", 9294);
    freq.put("tak", 4197);
    freq.put(" va", 34158);
    freq.put("Yh", 4604);
    freq.put("uka", 8994);
    freq.put(" ve", 7508);
    freq.put("siv", 2877);
    freq.put("sit", 13812);
    freq.put(" vi", 12396);
    freq.put(" vo", 6724);
    freq.put("sia", 14727);
    freq.put(" vu", 30542);
    freq.put("sie", 3768);
    freq.put("sik", 6439);
    freq.put("sij", 10631);
    freq.put("sii", 15427);
    freq.put("sio", 5975);
    freq.put("sin", 22898);
    freq.put("sim", 10671);
    freq.put("sil", 7537);
    freq.put("sis", 15595);
    freq.put("tsu", 1775);
    freq.put("ta ", 96137);
    freq.put("ha\u0308n", 3427);
    freq.put("Ha\u0308n", 3486);
    freq.put("si ", 33316);
    freq.put("usl", 2474);
    freq.put("da ", 1964);
    freq.put("yyt", 1690);
    freq.put("ld", 2991);
    freq.put("le", 81668);
    freq.put("lb", 9921);
    freq.put("la", 154382);
    freq.put("eud", 1841);
    freq.put("ll", 141072);
    freq.put("lm", 34905);
    freq.put("lj", 7180);
    freq.put("lk", 30410);
    freq.put("li", 159675);
    freq.put("lv", 6764);
    freq.put("lt", 40738);
    freq.put("lu", 74348);
    freq.put("ls", 4754);
    freq.put("lp", 5969);
    freq.put("ea ", 2811);
    freq.put("eut", 3244);
    freq.put("euv", 2196);
    freq.put("eus", 2033);
    freq.put("ly", 10157);
    freq.put("daa", 2346);
    freq.put("dal", 1725);
    freq.put("dan", 3795);
    freq.put("das", 2350);
    freq.put("Sak", 1930);
    freq.put(" hy", 3213);
    freq.put("l ", 13054);
    freq.put("ssa", 81782);
    freq.put(" hu", 2999);
    freq.put(" hi", 4639);
    freq.put(" ho", 2199);
    freq.put("lta\u0308", 6950);
    freq.put(" ha", 11651);
    freq.put(" he", 10326);
    freq.put("ouk", 4542);
    freq.put("oun", 1887);
    freq.put("oul", 4682);
    freq.put("ous", 2951);
    freq.put("out", 1762);
    freq.put("la\u0308", 49440);
    freq.put("res", 3703);
    freq.put("Tur", 1761);
    freq.put("ret", 2238);
    freq.put("lo\u0308", 4854);
    freq.put("rei", 4803);
    freq.put("ren", 6049);
    freq.put("rel", 2990);
    freq.put("rea", 2509);
    freq.put("ree", 2885);
    freq.put("vak", 1862);
    freq.put("x", 8131);
    freq.put("va\u0308a\u0308", 1811);
    freq.put("g", 68514);
    freq.put("ltt", 2378);
    freq.put("uha", 2389);
    freq.put("lta", 20774);
    freq.put("re ", 2848);
    freq.put(" ha\u0308", 3832);
    freq.put("arp", 1607);
    freq.put("rs ", 1794);
    freq.put("seu", 4708);
    freq.put("iht", 1902);
    freq.put("ihi", 4976);
    freq.put("ihm", 2273);
    freq.put(" Ba", 4234);
    freq.put("iha", 1816);
    freq.put("ihe", 3769);
    freq.put("arv", 4834);
    freq.put("los", 4127);
    freq.put("nda", 1665);
    freq.put(" St", 4422);
    freq.put(" Su", 13126);
    freq.put(" Sh", 1689);
    freq.put(" Si", 6699);
    freq.put(" So", 3959);
    freq.put(" Sa", 10406);
    freq.put(" Se", 20290);
    freq.put("Ka", 13363);
    freq.put("rsi", 3925);
    freq.put("Ke", 4172);
    freq.put("Ki", 5554);
    freq.put("Ko", 6559);
    freq.put("Kr", 2024);
    freq.put("R", 24157);
    freq.put("ogi", 4118);
    freq.put("ma\u0308a\u0308", 5076);
    freq.put("Ku", 5528);
    freq.put("ude", 10287);
    freq.put("Ky", 1627);
    freq.put("udi", 3267);
    freq.put("ber", 2683);
    freq.put("Par", 1783);
    freq.put("sen", 44413);
    freq.put("sem", 6469);
    freq.put("mii", 3025);
    freq.put("sk", 39138);
    freq.put("mik", 3016);
    freq.put("sel", 8992);
    freq.put("ck ", 3175);
    freq.put("min", 18710);
    freq.put("mia", 4076);
    freq.put("sek", 9571);
    freq.put("mie", 6732);
    freq.put("uu ", 9094);
    freq.put("mis", 25017);
    freq.put("mit", 6945);
    freq.put(" El", 2955);
    freq.put(" En", 2918);
    freq.put("Yhd", 3250);
    freq.put(" Et", 2345);
    freq.put(" Eu", 3021);
    freq.put(" Es", 2034);
    freq.put("ure", 2812);
    freq.put("ura", 6710);
    freq.put("mi ", 13252);
    freq.put("uro", 4160);
    freq.put("urh", 2266);
    freq.put("uri", 10072);
    freq.put("uru", 1961);
    freq.put("Poh", 2941);
    freq.put("hm", 8011);
    freq.put("nge", 2486);
    freq.put("nga", 3203);
    freq.put("va\u0308 ", 5493);
    freq.put("ngl", 4558);
    freq.put("jat", 4403);
    freq.put(" is", 1907);
    freq.put(" it", 4582);
    freq.put("jas", 4641);
    freq.put("jan", 11104);
    freq.put("ae ", 1542);
    freq.put("jal", 7569);
    freq.put(" il", 6233);
    freq.put("jak", 4713);
    freq.put(" in", 3365);
    freq.put("jai", 10124);
    freq.put("kso", 2000);
    freq.put("ksi", 34515);
    freq.put("jaa", 5054);
    freq.put("ya\u0308 ", 1547);
    freq.put("a\u0308vi", 2773);
    freq.put("a\u0308ve", 2052);
    freq.put("h", 239330);
    freq.put("eta\u0308", 4989);
    freq.put("ael", 1895);
    freq.put("ja ", 90836);
    freq.put("Pr", 3317);
    freq.put("Pu", 2910);
    freq.put("oma", 18393);
    freq.put("ke ", 2125);
    freq.put("Pa", 6975);
    freq.put("Pe", 5861);
    freq.put("ede", 4270);
    freq.put("Pi", 3820);
    freq.put("Po", 6867);
    freq.put("lus", 6284);
    freq.put("lut", 6301);
    freq.put("ome", 15724);
    freq.put("luv", 9141);
    freq.put("et ", 16346);
    freq.put("lue", 13574);
    freq.put("lui", 2536);
    freq.put("luk", 6577);
    freq.put("omi", 7452);
    freq.put("lun", 5262);
    freq.put("luo", 7753);
    freq.put("ken", 9401);
    freq.put("kem", 2757);
    freq.put("jos", 6649);
    freq.put("jot", 6559);
    freq.put("jou", 4303);
    freq.put("kei", 5212);
    freq.put("keh", 4191);
    freq.put("kee", 4463);
    freq.put("kea", 4096);
    freq.put("S", 77764);
    freq.put("joe", 2427);
    freq.put("joh", 4795);
    freq.put("joi", 16729);
    freq.put("keu", 3655);
    freq.put("jok", 24849);
    freq.put("jol", 3356);
    freq.put("ker", 7027);
    freq.put("jon", 9520);
    freq.put("etr", 5809);
    freq.put("ets", 2385);
    freq.put("ett", 36313);
    freq.put("etu", 5501);
    freq.put("a\u0308va\u0308", 6336);
    freq.put("ety", 2077);
    freq.put("lu ", 5034);
    freq.put("eta", 9667);
    freq.put("ete", 9398);
    freq.put("eti", 3164);
    freq.put("eto", 4814);
    freq.put("uts", 1830);
    freq.put("ck", 6770);
    freq.put("ci", 3249);
    freq.put("ch", 7835);
    freq.put("co", 5044);
    freq.put("omu", 1601);
    freq.put("ot ", 3256);
    freq.put("ca", 4693);
    freq.put("rva", 2385);
    freq.put("ce", 5416);
    freq.put("oho", 2246);
    freq.put("ka\u0308y", 11169);
    freq.put("Hel", 2818);
    freq.put("tsa", 2112);
    freq.put("cu", 1883);
    freq.put("ct", 2366);
    freq.put("rve", 3560);
    freq.put("na\u0308 ", 7166);
    freq.put("ys ", 5219);
    freq.put("pia", 3590);
    freq.put("rvi", 3707);
    freq.put("oti", 5562);
    freq.put("otk", 3192);
    freq.put("oto", 4571);
    freq.put("rvo", 2466);
    freq.put("c ", 2562);
    freq.put("ka\u0308 ", 7989);
    freq.put("ote", 5798);
    freq.put("hmo", 1850);
    freq.put("hmi", 2965);
    freq.put("ots", 2991);
    freq.put("ott", 10457);
    freq.put("otu", 2486);
    freq.put("va\u0308t", 4019);
    freq.put("na\u0308i", 1855);
    freq.put("na\u0308k", 2091);
    freq.put("na\u0308j", 3467);
    freq.put("e\u0301", 2342);
    freq.put("uis", 6404);
    freq.put("na\u0308y", 2474);
    freq.put(" Ta\u0308", 2303);
    freq.put("ysv", 6099);
    freq.put("yst", 4193);
    freq.put("va", 118391);
    freq.put(" Fr", 2153);
    freq.put("ve", 29647);
    freq.put("ka\u0308a\u0308", 1980);
    freq.put("vi", 49369);
    freq.put("vo", 19782);
    freq.put(" Fa", 1558);
    freq.put("oht", 5278);
    freq.put("avo", 2634);
    freq.put("vu", 43029);
    freq.put(" Fi", 2200);
    freq.put("vy", 5926);
    freq.put("ava", 19468);
    freq.put(" Fo", 2388);
    freq.put("io ", 5938);
    freq.put("of ", 2718);
    freq.put("pis", 5110);
    freq.put("une", 2125);
    freq.put("Vuo", 2097);
    freq.put("iot", 1986);
    freq.put("ios", 4401);
    freq.put("iop", 2837);
    freq.put("ion", 10934);
    freq.put("iol", 2452);
    freq.put("ioi", 3973);
    freq.put("hma\u0308", 2450);
    freq.put("ioa", 2138);
    freq.put("i", 1579260);
    freq.put(" Tu", 4371);
    freq.put("ofi", 1682);
    freq.put(" Tr", 2184);
    freq.put(" To", 3832);
    freq.put(" Ti", 2528);
    freq.put(" Th", 5301);
    freq.put(" Te", 3868);
    freq.put(" Ta", 5960);
    freq.put("not", 1919);
    freq.put("sku", 10246);
    freq.put("Be", 3488);
    freq.put("Ba", 4270);
    freq.put("lma\u0308", 3813);
    freq.put("Bo", 2874);
    freq.put("Bi", 1625);
    freq.put("ske", 7078);
    freq.put("Bu", 1605);
    freq.put("esa\u0308", 2111);
    freq.put("ska", 6718);
    freq.put("Br", 4547);
    freq.put("ada", 3189);
    freq.put("sko", 4863);
    freq.put("ski", 7594);
    freq.put("adi", 4196);
    freq.put("T", 36899);
    freq.put("nva", 1615);
    freq.put(" ja\u0308", 12144);
    freq.put("nja", 2100);
    freq.put("ui ", 2881);
    freq.put("Suo", 9477);
    freq.put("hoi", 2109);
    freq.put("est", 38413);
    freq.put("ess", 23541);
    freq.put("nd ", 4059);
    freq.put("ia\u0308", 11662);
    freq.put("ese", 2664);
    freq.put("esk", 9110);
    freq.put("esi", 14483);
    freq.put("Un", 1530);
    freq.put("ndi", 2475);
    freq.put("ndo", 1777);
    freq.put(" ju", 13868);
    freq.put("nde", 2171);
    freq.put(" jo", 60523);
    freq.put("es ", 8151);
    freq.put(" ja", 74622);
    freq.put("kre", 1700);
    freq.put("o\u0308h", 1825);
    freq.put("o\u0308i", 4386);
    freq.put("o\u0308k", 3180);
    freq.put("o\u0308l", 2694);
    freq.put("o\u0308m", 1579);
    freq.put("o\u0308n", 8537);
    freq.put("myo\u0308", 9305);
    freq.put("o\u0308r", 2049);
    freq.put("o\u0308s", 12022);
    freq.put("o\u0308t", 2960);
    freq.put("ina\u0308", 3666);
    freq.put("o\u0308y", 2134);
    freq.put("h ", 5313);
    freq.put("yri", 2968);
    freq.put("vai", 7839);
    freq.put("van", 11048);
    freq.put("val", 26751);
    freq.put("vaa", 7863);
    freq.put("var", 8953);
    freq.put("vas", 8886);
    freq.put("vap", 1548);
    freq.put("vat", 20575);
    freq.put("o\u0308 ", 8048);
    freq.put("hy", 6074);
    freq.put("eal", 1781);
    freq.put("ean", 1991);
    freq.put("hr", 2420);
    freq.put("ht", 42173);
    freq.put("hu", 10726);
    freq.put("hj", 14036);
    freq.put("hk", 3966);
    freq.put("hi", 25267);
    freq.put("hn", 1754);
    freq.put("ho", 13688);
    freq.put("hl", 1555);
    freq.put("bum", 8758);
    freq.put("ha", 33064);
    freq.put("eat", 2428);
    freq.put("hd", 23028);
    freq.put("he", 38383);
    freq.put("dus", 2698);
    freq.put("avi", 5086);
    freq.put("va ", 18614);
    freq.put("j", 314669);
    freq.put("lve", 3316);
    freq.put("ia\u0308 ", 10723);
    freq.put("lvi", 1540);
    freq.put("pii", 5873);
    freq.put("pil", 2184);
    freq.put("pin", 5017);
    freq.put("int", 21117);
    freq.put("inu", 2993);
    freq.put("inv", 2235);
    freq.put("pid", 1828);
    freq.put("pie", 3232);
    freq.put("ins", 3814);
    freq.put("inn", 9244);
    freq.put("ino", 7309);
    freq.put("ini", 7961);
    freq.put("o\u0308o\u0308", 1835);
    freq.put("ink", 6694);
    freq.put("ind", 1904);
    freq.put("ine", 62207);
    freq.put("ing", 10847);
    freq.put("pit", 5090);
    freq.put("ina", 17571);
    freq.put("te ", 4200);
    freq.put("oal", 3299);
    freq.put("or ", 1961);
    freq.put("tta\u0308", 18426);
    freq.put("nin", 16562);
    freq.put("sva", 8410);
    freq.put("pi ", 2782);
    freq.put("U", 7805);
    freq.put("aji", 6912);
    freq.put("in ", 123439);
    freq.put("ha\u0308", 6582);
    freq.put("sa\u0308a\u0308", 2844);
    freq.put("oa ", 4765);
    freq.put("eol", 1627);
    freq.put("eor", 2097);
  }
  
}

