package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class FA extends CLangProfile {
  private static final String name = "fa";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public FA() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 8069793;
    n_words[1] = 10004435;
    n_words[2] = 6796528;

    freq.put("\u06f2\u06f7 ", 991);
    freq.put("\u06f1\u06f7 ", 1225);
    freq.put("\u06f8\u06f8", 1649);
    freq.put("\u06f8\u06f9", 1660);
    freq.put("\u06f8\u06f2", 1238);
    freq.put("\u06f8\u06f3", 1867);
    freq.put("\u06f8\u06f0", 1426);
    freq.put("\u0647\u060c", 2861);
    freq.put("\u06a9\u0648\u0686", 1236);
    freq.put("\u06f8\u06f7", 1462);
    freq.put("\u06f8\u06f4", 1157);
    freq.put("\u06f8\u06f5", 1706);
    freq.put("\u0647\u0635", 1630);
    freq.put("\u0647\u0634", 9098);
    freq.put("\u0647\u0633", 7389);
    freq.put("\u0647\u0632", 15706);
    freq.put("\u0647\u0631", 26999);
    freq.put("\u0631\u06a9\u064a", 1378);
    freq.put("\u0644\u062a ", 2709);
    freq.put("\u06af", 80261);
    freq.put("\u0647\u0627", 75779);
    freq.put("\u0627\u0646\u06a9", 896);
    freq.put("\u0627\u0646\u06af", 3856);
    freq.put("\u0647\u062f", 4476);
    freq.put("\u0647\u062c", 3131);
    freq.put("\u0647\u062a", 1153);
    freq.put("\u0647\u0628", 1561);
    freq.put("\u0641\u062a ", 4170);
    freq.put("\u0647\u0654", 10019);
    freq.put("\u0644", 186547);
    freq.put("\u0631\u06a9\u062a", 2292);
    freq.put("\u0647\u0647", 1141);
    freq.put("\u0647\u0646", 8401);
    freq.put("\u0647\u0645", 15355);
    freq.put("\u0647\u0644", 3945);
    freq.put("\u0647\u0641", 7528);
    freq.put("\u0627\u0653\u0632\u0627", 908);
    freq.put("\u0631\u0646 ", 1348);
    freq.put("\u0647\u064a", 7368);
    freq.put("\u0647\u0648", 6697);
    freq.put("\u064a\u0632 ", 4213);
    freq.put("\u0627\u062b\u0631", 1056);
    freq.put("\u0627\u06a9 ", 1290);
    freq.put("\u0627\u0698\u0647", 1048);
    freq.put("\u064a\u0644\u0648", 2447);
    freq.put("\u0648\u062f ", 25900);
    freq.put("\u064a\u0644\u064a", 2362);
    freq.put("\u064a\u0644\u0645", 2163);
    freq.put(" \u06f3\u06f0", 1169);
    freq.put("\u0644\u0628 ", 937);
    freq.put("\u0627\u0646\u060c", 3374);
    freq.put("\u06f5\u06f2", 836);
    freq.put(" \u0642\u0645", 3484);
    freq.put(" \u0642\u0644", 1179);
    freq.put("\u06f8\u06f1", 1392);
    freq.put("\u0627\u0646\u0632", 1366);
    freq.put("\u0627\u0646\u0633", 4593);
    freq.put("\u0645 ", 45325);
    freq.put("\u062f", 475980);
    freq.put("\u0627\u0646\u0635", 1766);
    freq.put("\u0627\u0646\u062a", 3295);
    freq.put("\u0627\u0646\u062f", 8054);
    freq.put("\u0627\u0646\u062c", 1903);
    freq.put("\u0627\u0646\u0627", 2522);
    freq.put("\u0648\u062a ", 2984);
    freq.put(" \u0642\u0627", 3036);
    freq.put(" \u0642\u062f", 1747);
    freq.put(" \u0642\u0628", 1076);
    freq.put("\u0627\u0646\u064a", 16598);
    freq.put("\u0627\u0646\u0648", 5568);
    freq.put(" \u0642\u0631", 6081);
    freq.put("\u062f\u0631 ", 87864);
    freq.put("\u0627\u0646\u0642", 1002);
    freq.put("\u0627\u0646\u0646", 2230);
    freq.put("\u06a9\u0648\u0647", 1843);
    freq.put("\u06a9\u0648\u0645", 883);
    freq.put("\u064a\u0644\u0627", 5819);
    freq.put("\u0646\u06af\u064a", 1776);
    freq.put("\u0648 ", 126016);
    freq.put("\u0628\u0627 ", 13059);
    freq.put("\u0645\u062a\u062d", 1213);
    freq.put("\u0631\u0628\u0631", 1171);
    freq.put("\u0642\u064a ", 7279);
    freq.put("\u062a\u0631 ", 6150);
    freq.put("\u0646\u062f\u0633", 875);
    freq.put("\u0631\u0628\u0627", 5086);
    freq.put("\u0645\u062a\u0631", 3763);
    freq.put("\u0648\u0686\u06a9", 1078);
    freq.put("\u064a\u0631\u0627", 13163);
    freq.put("\u062f\u0648\u0644", 1633);
    freq.put("\u0627\u0637\u0644", 2273);
    freq.put("\u062f\u0646 ", 19684);
    freq.put("\u064a\u0631\u064a", 2723);
    freq.put("\u064a\u0631\u0648", 2532);
    freq.put("\u064a\u0634 ", 4417);
    freq.put("\u064a\u0631\u0647", 2645);
    freq.put("\u0639\u0646\u0627", 1018);
    freq.put("\u0645\u062a\u0648", 1555);
    freq.put("\u0637\u0628\u0642", 15902);
    freq.put("\u0631\u0628\u064a", 3967);
    freq.put("\u0633\u0647 ", 5126);
    freq.put("\u0639\u064a ", 3265);
    freq.put("\u0646\u062f ", 23182);
    freq.put("\u06a9\u0644 ", 1774);
    freq.put("\u06f8\u06f5 ", 947);
    freq.put("\u0634\u0627\u0647", 3881);
    freq.put("\u0634\u0627\u0645", 1210);
    freq.put("\u0633\u062a ", 82115);
    freq.put("\u0634\u0627\u0631", 1758);
    freq.put("\u0645", 383367);
    freq.put("\u0644\u0648\u064a", 1612);
    freq.put("\u0644\u0648\u0645", 2898);
    freq.put(" \u06f1 ", 999);
    freq.put("\u0645\u06a9\u0627", 1239);
    freq.put("\u0634\u0627\u062e", 862);
    freq.put("\u0648\u0634\u062a", 1878);
    freq.put("\u06a9\u0627 ", 2349);
    freq.put("\u0642\u0644", 3288);
    freq.put("\u0642\u0645", 3612);
    freq.put("\u0642\u0647", 3627);
    freq.put("\u0642\u0648", 3406);
    freq.put("\u0642\u064a", 10959);
    freq.put("\u0645\u062d\u0644", 1270);
    freq.put("\u062a\u06af\u0627", 1213);
    freq.put("\u063a\u0627\u0646", 879);
    freq.put("\u0627\u0647\u064a", 3496);
    freq.put("\u0627\u0628\u0631", 3253);
    freq.put("\u06a9\u0634\u0648", 4351);
    freq.put("\u0627\u0628\u0639", 2818);
    freq.put("\u06a9\u0634\u0641", 46287);
    freq.put("\u06a9\u064a ", 15027);
    freq.put("\u0627\u0628\u0627", 1519);
    freq.put("\u062a\u064a\u0627", 863);
    freq.put("\u06f3 ", 8356);
    freq.put("\u0627\u0628\u062a", 1082);
    freq.put("\u0646\u0633 ", 921);
    freq.put("\u0648\u0627\u064a", 1826);
    freq.put("\u06f1\u06f6 ", 1284);
    freq.put("\u0627\u0628\u0644", 1424);
    freq.put("\u0627\u0628\u0642", 1003);
    freq.put("\u062a\u064a\u0646", 1737);
    freq.put("\u062a\u064a\u0645", 1139);
    freq.put("\u0627\u0628\u0648", 1132);
    freq.put("\u0627\u0628\u064a", 1834);
    freq.put("\u0627\u0647\u0634", 1637);
    freq.put("\u0642\u0627", 9232);
    freq.put("\u0627\u0647\u0631", 1198);
    freq.put("\u06a9\u0646\u0648", 1241);
    freq.put("\u063a\u0627\u0632", 1437);
    freq.put("\u0642\u062f", 3410);
    freq.put("\u0642\u0628", 1853);
    freq.put("\u0642\u062a", 1605);
    freq.put("\u0642\u0634", 1281);
    freq.put("\u0627\u0647\u0627", 4950);
    freq.put("\u0627\u0648\u0627", 1252);
    freq.put("\u0642\u0631", 7195);
    freq.put("\u0642\u0633", 1226);
    freq.put("\u0627\u0647\u062f", 836);
    freq.put("\u064a ", 278753);
    freq.put("\u0642\u0639", 6601);
    freq.put("\u062f\u06af\u0627", 1978);
    freq.put("\u0627\u0634\u0646", 1730);
    freq.put(" \u0641\u0627", 3850);
    freq.put("\u0631\u062a ", 5024);
    freq.put("\u0627\u0634\u064a", 1130);
    freq.put(" \u0641\u0631", 9595);
    freq.put("\u0698", 11180);
    freq.put("\u06a9\u0646\u062f", 3501);
    freq.put("\u064a\u0633 ", 3929);
    freq.put("\u0646\u0634\u06af", 2179);
    freq.put("\u062a\u064a\u06a9", 1005);
    freq.put(" \u06f2\u06f5", 1220);
    freq.put(" \u06f2\u06f4", 1600);
    freq.put("\u0643", 2176);
    freq.put(" \u06f2\u06f6", 1106);
    freq.put(" \u06f2\u06f1", 1529);
    freq.put(" \u06f2\u06f0", 5779);
    freq.put(" \u06f2\u06f3", 1186);
    freq.put(" \u06f2\u06f2", 1386);
    freq.put(" \u06f2\u06f9", 1004);
    freq.put(" \u06f2\u06f8", 971);
    freq.put("\u064a\u0647\u0654", 843);
    freq.put("\u0631\u0645 ", 3802);
    freq.put(" \u0641\u0644", 1560);
    freq.put("\u0627\u0634\u0627", 865);
    freq.put(" \u0641\u0648", 3446);
    freq.put("\u0627\u0634\u062a", 3533);
    freq.put("\u0648\u062f\u0631", 855);
    freq.put("\u0627\u0634\u062f", 5423);
    freq.put("\u0627\u062c ", 937);
    freq.put("\u0646\u0634\u0627", 1366);
    freq.put("\u0647\u062f ", 1760);
    freq.put("\u0646\u06af ", 4653);
    freq.put("\u0628\u0639\u062f", 1118);
    freq.put("\u0648\u0632 ", 3949);
    freq.put("\u06a9\u0628\u064a", 947);
    freq.put("\u0637\u0631\u0627", 958);
    freq.put("\u0631\u06a9\u0632", 5506);
    freq.put("\u0634\u064a\u062f", 1499);
    freq.put("\u062e", 65646);
    freq.put("\u0634\u064a\u0631", 1302);
    freq.put("\u0646\u062c\u0627", 19529);
    freq.put("\u064a\u0644\u0647", 1142);
    freq.put("\u0635\u0627\u062f", 1085);
    freq.put("\u0634\u064a\u0646", 1156);
    freq.put("\u0627\u060c ", 2188);
    freq.put("\u064a\u06af\u0627", 1094);
    freq.put("\u062f\u0633\u062a", 3550);
    freq.put("\u0628\u062a ", 1678);
    freq.put("\u062f\u0633\u0627", 1658);
    freq.put("\u0637\u0647 ", 1047);
    freq.put(" \u062c\u0647", 2834);
    freq.put(" \u062c\u0646", 6563);
    freq.put(" \u062c\u0645", 4408);
    freq.put(" \u062c\u0644", 883);
    freq.put("\u0648\u0633\u062a", 8309);
    freq.put(" \u062c\u0648", 1700);
    freq.put("\u0648\u0633\u0637", 3323);
    freq.put(" \u063a\u0631", 3490);
    freq.put("\u06f5 ", 8279);
    freq.put("\u0633\u0646 ", 1047);
    freq.put(" \u062c\u0627", 5217);
    freq.put("\u062e\u0633\u062a", 1155);
    freq.put(" \u063a\u064a", 1131);
    freq.put(" \u062c\u062f", 1121);
    freq.put("\u0644\u0627 ", 1918);
    freq.put(" \u062c\u0632", 2226);
    freq.put(" \u062c\u0631", 1081);
    freq.put("\u0646\u062c ", 1914);
    freq.put("\u0646\u0648 ", 876);
    freq.put("\u0634\u062f ", 26077);
    freq.put("\u0642\u0648\u064a", 1155);
    freq.put("\u0686\u0627\u0631", 831);
    freq.put("\u0631\u064a\u062e", 2752);
    freq.put("\u064a\u0646\u064a", 2869);
    freq.put("\u064a\u0646\u0648", 1227);
    freq.put("\u0648\u0631\u0632", 1216);
    freq.put("\u064a\u0646\u0647", 1667);
    freq.put(" \u0642\u0648", 1126);
    freq.put("\u06f8\u06f8 ", 992);
    freq.put("\u064a\u0648", 11558);
    freq.put("\u0627\u0646\u0634", 5048);
    freq.put("\u064a\u064a", 14011);
    freq.put("\u064a\u0644", 23315);
    freq.put("\u064a\u0645", 13074);
    freq.put("\u064a\u0646", 90729);
    freq.put("\u064a\u0647", 14576);
    freq.put("\u064a\u0641", 3191);
    freq.put("\u064a\u0642", 4160);
    freq.put("\u064a\u067e", 878);
    freq.put("\u0646\u0633\u0648", 981);
    freq.put("\u0627\u0644\u0639", 862);
    freq.put("\u062c", 87595);
    freq.put("\u0627\u0628 ", 5407);
    freq.put("\u0627\u0644\u0627", 3840);
    freq.put("\u0627\u0644\u0628", 1010);
    freq.put("\u0627\u0644\u062a", 2172);
    freq.put("\u062a\u064a ", 8134);
    freq.put("\u0646\u0633\u0627", 1177);
    freq.put("\u0646\u0633\u062a", 1454);
    freq.put("\u064a\u060c", 6981);
    freq.put("\u0627\u0644\u0644", 1166);
    freq.put("\u0627\u0644\u0645", 2177);
    freq.put("\u0627\u0644\u0646", 1060);
    freq.put("\u0627\u0644\u0647", 1801);
    freq.put("\u0627\u0644\u064a", 6506);
    freq.put("\u0631\u0634", 6643);
    freq.put("\u064a\u0646\u062a", 984);
    freq.put("\u0642 ", 24581);
    freq.put("\u064a\u0639", 3352);
    freq.put("\u064a\u0646\u062c", 15434);
    freq.put("\u064a\u0634", 9793);
    freq.put("\u064a\u0635", 2081);
    freq.put("\u064a\u0646\u0627", 1201);
    freq.put("\u064a\u0631", 33847);
    freq.put("\u064a\u0632", 10370);
    freq.put("\u064a\u0633", 23115);
    freq.put("\u064a\u062c", 6291);
    freq.put("\u064a\u062d", 1015);
    freq.put("\u064a\u062e", 3819);
    freq.put("\u064a\u062f", 17899);
    freq.put("\u064a\u0628", 4572);
    freq.put("\u0627\u0647 ", 14391);
    freq.put("\u064a\u062a", 13742);
    freq.put(" \u0686\u0646", 1727);
    freq.put("\u064a\u0627", 96279);
    freq.put("\u0631\u062a\u0628", 927);
    freq.put("\u0632\u0628\u0627", 3526);
    freq.put("\u0631\u0645\u064a", 2432);
    freq.put("\u06f1\u06f5 ", 1270);
    freq.put("\u0639\u0627\u0644", 2039);
    freq.put("\u0639\u0631\u0628", 2186);
    freq.put("\u064a\u0647 ", 12282);
    freq.put("\u0639\u0631\u0627", 897);
    freq.put("\u064a\u0633\u062a", 11437);
    freq.put("\u0627\u0644\u06a9", 1567);
    freq.put("\u064a\u0633\u0646", 1399);
    freq.put("\u064a\u0633\u0647", 1037);
    freq.put("\u064a\u0698", 1013);
    freq.put("\u0639\u0631\u0648", 1419);
    freq.put("\u0627\u0635\u0644", 2729);
    freq.put("\u0639\u0627\u062f", 1232);
    freq.put("\u0639\u0631\u0641", 15753);
    freq.put("\u0639\u0627\u062a", 1421);
    freq.put("\u064a\u0633\u064a", 2944);
    freq.put("\u0631\u0628", 15211);
    freq.put("\u064a\u0686", 1842);
    freq.put("\u0627\u0634 ", 1063);
    freq.put("\u06f3\u06f9", 874);
    freq.put("\u06f3\u06f8", 3317);
    freq.put("\u064a\u0646\u06af", 934);
    freq.put("\u0631\u0645\u0627", 3636);
    freq.put("\u06f3\u06f3", 1412);
    freq.put("\u06f3\u06f2", 1475);
    freq.put("\u06f3\u06f1", 1756);
    freq.put("\u06f3\u06f0", 2261);
    freq.put("\u06f3\u06f7", 1442);
    freq.put("\u06f3\u06f6", 1469);
    freq.put("\u06f3\u06f5", 1620);
    freq.put("\u06f3\u06f4", 1319);
    freq.put("\u064a\u06af", 5574);
    freq.put("\u0631\u062f", 33206);
    freq.put("\u0631\u062e", 3587);
    freq.put("\u0627\u0639\u0627", 905);
    freq.put(" \u0645\u062d", 8486);
    freq.put("\u0628\u0646\u0627", 1507);
    freq.put(" \u0639\u0644", 4955);
    freq.put(" \u0639\u0645", 2914);
    freq.put(" \u0639\u0646", 2426);
    freq.put("\u0648\u0631 ", 11858);
    freq.put(" \u0645\u062f", 3474);
    freq.put("\u06af\u0632\u0627", 1135);
    freq.put("\u0642\u0639 ", 6048);
    freq.put("\u0634\u064a ", 3088);
    freq.put(" \u0645\u062a", 6834);
    freq.put("\u0648\u062f\u060c", 1062);
    freq.put("\u064a\u0627\u062f", 1729);
    freq.put("\u0627\u0646\u0647", 7584);
    freq.put("\u0633\u0646\u06af", 854);
    freq.put("\u06a9\u0633", 3863);
    freq.put("\u0642", 86257);
    freq.put("\u062f\u06af\u064a", 1827);
    freq.put("\u0627\u0639\u062a", 1127);
    freq.put("\u062a\u062e\u0627", 898);
    freq.put("\u064a\u060c ", 6814);
    freq.put("\u0635\u064a ", 884);
    freq.put(" \u0639\u0628", 2630);
    freq.put("\u06f5\u06f9", 829);
    freq.put("\u06f5\u06f8", 881);
    freq.put("\u0627\u064a\u0654", 3170);
    freq.put("\u06f5\u06f5", 896);
    freq.put("\u06f5\u06f4", 849);
    freq.put("\u06f5\u06f7", 978);
    freq.put("\u06f5\u06f6", 829);
    freq.put("\u06f5\u06f1", 867);
    freq.put("\u06f5\u06f0", 1455);
    freq.put("\u06f5\u06f3", 863);
    freq.put(" \u0639\u0627", 1962);
    freq.put("\u0646\u06af\u0644", 2493);
    freq.put("\u0645\u0627\u0645", 1588);
    freq.put("\u0648\u0632\u064a", 1584);
    freq.put(" \u0639\u0631", 3450);
    freq.put("\u0648\u0632\u0647", 1349);
    freq.put("\u0648\u0632\u0646", 1058);
    freq.put(" \u0639\u0636", 849);
    freq.put("\u06a9\u062f", 1167);
    freq.put(" \u0645\u0634", 3603);
    freq.put(" \u0645\u0635", 1331);
    freq.put("\u0648\u0633 ", 2204);
    freq.put(" \u0645\u0637", 1111);
    freq.put("\u062d", 43181);
    freq.put(" \u0645\u0631", 12704);
    freq.put("\u0633\u0646\u062f", 1687);
    freq.put("\u0633\u0648\u0645", 2657);
    freq.put("\u0633\u0648\u064a", 1270);
    freq.put(" \u0645\u0633", 5314);
    freq.put("\u0646\u062c\u0645", 2428);
    freq.put("\u0654 ", 10096);
    freq.put("\u0634\u0648\u062f", 8535);
    freq.put("\u064a\u0632\u0647", 870);
    freq.put("\u062f\u062f ", 1157);
    freq.put("\u0645\u0686", 1311);
    freq.put("\u0646\u0632\u062f", 2165);
    freq.put("\u064a\u0632\u064a", 2379);
    freq.put("\u0627\u06a9\u0646", 1376);
    freq.put("\u0632\u0628 ", 861);
    freq.put("\u0634\u0631", 11318);
    freq.put("\u0645\u062d\u0645", 2301);
    freq.put("\u0634\u062e", 1686);
    freq.put("\u0645\u06a9", 3060);
    freq.put("\u0645\u0627\u064a", 4595);
    freq.put("\u0647 ", 289561);
    freq.put("\u0634\u0648\u0646", 1223);
    freq.put("\u0648\u0698", 952);
    freq.put("\u0631\u06a9 ", 48005);
    freq.put("\u0634\u0648\u0631", 5763);
    freq.put("\u06f8\u06f9 ", 864);
    freq.put("\u0631\u0646\u062f", 2708);
    freq.put("\u0645\u062d\u0631", 1442);
    freq.put("\u062f\u0631\u06af", 1116);
    freq.put(" \u06f3 ", 1037);
    freq.put("\u0631\u0646\u0627", 1487);
    freq.put("\u0648\u0686", 1800);
    freq.put("\u0627\u06a9\u0633", 936);
    freq.put("\u064a\u0632\u062f", 1123);
    freq.put("\u0645\u0627\u0647", 2044);
    freq.put("\u0648\u06a9", 2822);
    freq.put("\u0648\u06af", 1347);
    freq.put("\u0645\u0627\u0644", 4589);
    freq.put("\u0627\u06a9\u062a", 3167);
    freq.put("\u0645\u060c", 1074);
    freq.put("\u0648\u064a", 29381);
    freq.put("\u0648\u0648", 995);
    freq.put("\u0628\u0627\u064a", 4838);
    freq.put("\u0631\u0627\u0646", 23644);
    freq.put("\u0628\u0627\u0646", 6032);
    freq.put("\u0628\u0627\u0644", 3191);
    freq.put("\u0648\u0641", 3392);
    freq.put("\u0648\u0646", 20803);
    freq.put("\u0648\u0647", 7280);
    freq.put("\u0648\u0644", 18645);
    freq.put("\u0648\u0645", 15237);
    freq.put("\u0645\u062d", 8770);
    freq.put("\u0645\u062c", 4572);
    freq.put("\u0645\u062f", 9936);
    freq.put("\u0645\u062e", 2590);
    freq.put("\u0648\u067e", 2022);
    freq.put("\u0645\u0628", 9205);
    freq.put("\u0645\u062a", 12979);
    freq.put(" \u06a9\u0631", 7960);
    freq.put("\u0645\u0627", 76186);
    freq.put(" \u06a9\u0634", 52338);
    freq.put(" \u06a9\u0628", 1107);
    freq.put(" \u06a9\u062a", 2907);
    freq.put("\u0645\u0639", 25874);
    freq.put("\u0648\u0646\u0647", 1782);
    freq.put("\u0627\u067e", 4030);
    freq.put("\u0645\u0635", 1370);
    freq.put("\u0645\u0634", 4307);
    freq.put("\u0645\u0637", 1157);
    freq.put("\u0645\u0631", 23149);
    freq.put("\u062f\u0631\u064a", 2646);
    freq.put("\u0645\u0633", 6882);
    freq.put("\u0645\u0632", 2088);
    freq.put("\u062f\u0631\u0633", 984);
    freq.put("\u0645\u0648", 18704);
    freq.put("\u0645\u064a", 78888);
    freq.put("\u0645\u0644", 8979);
    freq.put("\u06f8 ", 9234);
    freq.put("\u0645\u0646", 11960);
    freq.put("\u0645\u0641", 852);
    freq.put("\u0645\u0642", 2922);
    freq.put("\u062f\u0631\u0627", 1451);
    freq.put(" \u06a9\u064a", 3060);
    freq.put("\u06af\u0633\u062a", 862);
    freq.put("\u06f1\u06f4 ", 1282);
    freq.put("\u0648\u0631\u062f", 3566);
    freq.put("\u0647\u062c\u0631", 2343);
    freq.put("\u062f\u0631\u062c", 847);
    freq.put(" \u06a9\u0644", 3525);
    freq.put(" \u06a9\u0645", 2467);
    freq.put(" \u06a9\u0646", 7370);
    freq.put(" \u06a9\u0647", 48270);
    freq.put("\u0648\u062f\u0646", 1173);
    freq.put("\u0648\u062f\u0647", 3280);
    freq.put("\u0648\u0639", 5118);
    freq.put("\u0648\u0632", 11168);
    freq.put("\u0648\u0633", 20717);
    freq.put("\u0628\u0627\u0634", 6504);
    freq.put("\u0648\u0631", 41200);
    freq.put("\u0648\u0636", 931);
    freq.put("\u0628\u0627\u0633", 1834);
    freq.put("\u0648\u0634", 6987);
    freq.put("\u0648\u0635", 985);
    freq.put("\u0648\u062a", 7324);
    freq.put("\u0628\u0627\u062f", 2479);
    freq.put("\u0648\u0628", 8255);
    freq.put("\u0645\u067e", 1882);
    freq.put("\u0628\u0627\u062a", 1162);
    freq.put("\u0648\u062f", 37999);
    freq.put("\u0648\u062c", 4297);
    freq.put("\u0648\u062d", 978);
    freq.put("\u0645\u0627\u062f", 1634);
    freq.put("\u0648\u064a\u0654", 3203);
    freq.put("\u0648\u0627", 39119);
    freq.put(" \u06f1\u06f0", 2514);
    freq.put(" \u06f1\u06f1", 2053);
    freq.put(" \u06f1\u06f2", 2491);
    freq.put(" \u06f1\u06f3", 7504);
    freq.put(" \u06f1\u06f4", 1848);
    freq.put(" \u06f1\u06f5", 1981);
    freq.put(" \u06f1\u06f6", 1865);
    freq.put(" \u06f1\u06f7", 1946);
    freq.put(" \u06f1\u06f8", 3370);
    freq.put(" \u06f1\u06f9", 20860);
    freq.put("\u067e\u062f", 1266);
    freq.put("\u0645\u062a ", 2632);
    freq.put("\u0627\u064a\u06af", 1002);
    freq.put("\u0631\u0628 ", 1902);
    freq.put(" \u062a\u0648", 11109);
    freq.put(" \u062a\u064a", 2383);
    freq.put(" \u062a\u0645", 1148);
    freq.put(" \u062a\u0644", 1644);
    freq.put(" \u062a\u0647", 3565);
    freq.put(" \u062a\u0646", 2119);
    freq.put(" \u062a\u0642", 2105);
    freq.put(" \u0627\u0632", 47219);
    freq.put("\u0642\u0627\u0644", 936);
    freq.put("\u0627\u0637 ", 832);
    freq.put("\u0642\u0627\u0646", 1259);
    freq.put("\u062f\u0646\u064a", 1772);
    freq.put("\u064a\u0631 ", 7783);
    freq.put("\u0633\u062a\u06af", 1285);
    freq.put("\u067e\u0627", 14295);
    freq.put("\u0644\u06a9\u062a", 1073);
    freq.put("\u0642\u0627\u0628", 1236);
    freq.put("\u062f\u0646\u062f", 2383);
    freq.put("\u0645\u0639\u0645", 1600);
    freq.put(" \u062a\u0639", 1944);
    freq.put("\u0642\u064a\u0642", 1249);
    freq.put("\u062a\u0631\u0648", 1889);
    freq.put(" \u062a\u0635", 1087);
    freq.put(" \u062a\u0634", 1637);
    freq.put(" \u062a\u0631", 7158);
    freq.put(" \u062a\u062d", 1857);
    freq.put(" \u062a\u062c", 1001);
    freq.put(" \u062a\u062e", 1066);
    freq.put(" \u062a\u0628", 1758);
    freq.put(" \u062a\u0627", 10536);
    freq.put("\u0645\u0639\u064a", 1766);
    freq.put("\u0646\u062f\u0631", 1455);
    freq.put("\u062a\u0631\u06a9", 1945);
    freq.put("\u0627\u064a\u0634", 2420);
    freq.put("\u0646\u0648\u0646", 2065);
    freq.put("\u0627\u064a\u0632", 1142);
    freq.put("\u0627\u064a\u0633", 842);
    freq.put("\u0627\u0639\u064a", 1202);
    freq.put("\u0627\u064a\u062f", 1943);
    freq.put("\u0627\u064a\u062c", 4814);
    freq.put("\u06a9\u0627\u0644", 1004);
    freq.put("\u0627\u064a\u062a", 2340);
    freq.put("\u0633\u062a\u060c", 1386);
    freq.put("\u0627\u064a\u0627", 4829);
    freq.put("\u06a9\u0627\u064a", 1649);
    freq.put("\u0627\u0646", 164721);
    freq.put("\u0646\u062a\u0634", 1291);
    freq.put("\u0633\u062a\u0631", 2167);
    freq.put("\u064a\u062c\u0627", 4729);
    freq.put("\u0644\u0648 ", 1092);
    freq.put("\u0633\u062a\u0628", 15399);
    freq.put("\u06a9\u064a", 21693);
    freq.put("\u0644\u0628\u0631", 1058);
    freq.put("\u067e\u0633 ", 2219);
    freq.put("\u0633\u062a\u0627", 39209);
    freq.put("\u0641", 144242);
    freq.put("\u0633\u062a\u064a", 2717);
    freq.put("\u0633\u062a\u0648", 1258);
    freq.put("\u062d\u062a ", 897);
    freq.put("\u0633\u062a\u0641", 2194);
    freq.put("\u0633\u062a\u0646", 2498);
    freq.put("\u0633\u062a\u0647", 2853);
    freq.put("\u0633\u062a\u0645", 1666);
    freq.put("\u0646\u0648\u062f", 1940);
    freq.put("\u0646\u0648\u0628", 3858);
    freq.put("\u06a9\u0627\u0631", 7408);
    freq.put("\u0648\u0634 ", 1865);
    freq.put("\u0627\u064b", 1680);
    freq.put("\u0646\u0648\u0627", 6754);
    freq.put("\u0627\u064a", 143043);
    freq.put("\u0644\u0627\u062a", 2844);
    freq.put("\u0646\u062f\u0647", 6796);
    freq.put(" \u062a\u06a9", 1140);
    freq.put(" \u067e\u0627", 11101);
    freq.put("\u0627\u064a\u0646", 37088);
    freq.put("\u0627\u064a\u0647", 1592);
    freq.put("\u0627\u064a\u0644", 1631);
    freq.put("\u06a9\u0646", 11029);
    freq.put("\u0646\u0648\u0631", 1647);
    freq.put("\u062b", 6476);
    freq.put("\u0631\u060c ", 2027);
    freq.put("\u0646\u0648\u0632", 853);
    freq.put(" \u06af\u0627", 3551);
    freq.put("\u0686\u0647\u0627", 6583);
    freq.put(" \u06af\u0630", 2142);
    freq.put(" \u06af\u0631", 10421);
    freq.put("\u0631\u0648\u0632", 5199);
    freq.put("\u0631\u0648\u0633", 7942);
    freq.put("\u0631\u0648\u0631", 969);
    freq.put("\u0631\u0648\u0634", 1626);
    freq.put("\u0644\u0627\u0633", 997);
    freq.put("\u0634\u0646\u0627", 4807);
    freq.put("\u0648\u0631\u064a", 9228);
    freq.put("\u0641\u0648\u0631", 2032);
    freq.put("\u0634", 310066);
    freq.put("\u0631\u0633\u062a", 10190);
    freq.put("\u0631\u0648\u062f", 4045);
    freq.put("\u0645\u063a", 887);
    freq.put("\u0627\u0653\u0648\u0631", 2786);
    freq.put("\u0631\u0648\u0641", 1550);
    freq.put("\u0631\u0648\u0646", 2388);
    freq.put("\u0631\u0648\u0647", 2711);
    freq.put("\u0631\u0648\u0645", 1326);
    freq.put("\u0631\u0648\u064a", 3959);
    freq.put("\u0628 ", 20308);
    freq.put("\u0627\u0646 ", 92173);
    freq.put("\u0642\u0647 ", 2804);
    freq.put(" \u06af\u064a", 3912);
    freq.put(" \u06af\u0648", 4533);
    freq.put(" \u06af\u0644", 1221);
    freq.put("\u0631\u0648\u067e", 963);
    freq.put(" \u06af\u0641", 2153);
    freq.put("\u0686\u0647\u0644", 2101);
    freq.put("\u062f\u0631\u0648", 1489);
    freq.put("\u0633\u0631 ", 1698);
    freq.put(" \u06f4 ", 1026);
    freq.put("\u0639\u0628\u062f", 885);
    freq.put("\u0648\u0639\u0647", 1942);
    freq.put("\u0648\u0639\u064a", 1123);
    freq.put("\u0639\u0628\u0627", 1366);
    freq.put("\u061b ", 940);
    freq.put("\u0645\u0647", 13616);
    freq.put("\u0627\u062a ", 10939);
    freq.put("\u0646\u0635\u062f", 1688);
    freq.put("\u0648\u0631\u0634", 1426);
    freq.put("\u06a9\u062a ", 2257);
    freq.put("\u0632\u0646\u0627", 1261);
    freq.put("\u0632\u0646\u062f", 3098);
    freq.put("\u0628\u062f\u0627", 1231);
    freq.put("\u064a\u0631\u062f", 1088);
    freq.put("\u0637\u064a ", 1075);
    freq.put("\u06f0 ", 11742);
    freq.put("\u0631\u0646\u06af", 1040);
    freq.put("\u06f4", 17256);
    freq.put("\u0627\u0641 ", 1676);
    freq.put(" \u0627\u0653\u0645", 7369);
    freq.put(" \u0627\u0653\u0644", 2819);
    freq.put(" \u0627\u0653\u0647", 1013);
    freq.put(" \u0627\u0653\u0646", 28846);
    freq.put("\u06af\u0648\u064a", 1532);
    freq.put("\u06f7 ", 8195);
    freq.put("\u06af\u0648\u0646", 2525);
    freq.put(" \u0627\u0653\u0648", 2892);
    freq.put(" \u0627\u0653\u064a", 1817);
    freq.put("\u067e\u064a\u0631", 873);
    freq.put("\u067e\u064a\u0634", 2404);
    freq.put("\u064a\u0645 ", 5175);
    freq.put("\u0633\u0627\u064a", 1790);
    freq.put("\u0628\u0631\u062e", 1084);
    freq.put("\u0628\u0631\u062f", 2157);
    freq.put("\u062a\u0639\u062f", 829);
    freq.put("\u0648\u0631\u0627", 3355);
    freq.put("\u0628\u0631\u0627", 9676);
    freq.put("\u064a", 735907);
    freq.put("\u0627\u0653\u0645\u0627", 970);
    freq.put("\u0628\u0631\u0648", 884);
    freq.put("\u0628\u0631\u064a", 2753);
    freq.put("\u0631\u062f ", 14918);
    freq.put("\u062a\u0647\u0631", 2967);
    freq.put("\u067e\u064a\u0648", 992);
    freq.put("\u0628\u0631\u0646", 1758);
    freq.put(" \u0627\u0653\u0628", 3531);
    freq.put(" \u0627\u0653\u062b", 831);
    freq.put("\u064a\u062e ", 2265);
    freq.put("\u06f5", 18080);
    freq.put(" \u0627\u0653\u0630", 4109);
    freq.put(" \u0627\u0653\u0633", 1300);
    freq.put(" \u0627\u0653\u0632", 1278);
    freq.put("\u0633\u0627\u0646", 4639);
    freq.put("\u06af\u0648\u0631", 1227);
    freq.put(" \u0627\u0653\u063a", 1486);
    freq.put("\u0628\u0627\u0632", 4359);
    freq.put("\u0648\u0637", 1483);
    freq.put("\u0628\u0627\u0631", 4430);
    freq.put("\u0627\u0642\u0639", 6290);
    freq.put("\u062c\u0627", 32040);
    freq.put("\u0645\u064a\u062f", 1645);
    freq.put("\u0631\u064a ", 28175);
    freq.put("\u062c\u062f", 2691);
    freq.put("\u0645\u064a\u0627", 3140);
    freq.put("\u062c\u062a", 900);
    freq.put("\u0646\u0627\u0631", 1067);
    freq.put("\u062c\u0628", 888);
    freq.put("\u0646\u0627\u0633", 3745);
    freq.put(" \u0646\u0641", 1957);
    freq.put("\u0646\u0627\u062e", 1262);
    freq.put(" \u0646\u0642", 2575);
    freq.put("\u0635", 43813);
    freq.put("\u062c\u0633", 1114);
    freq.put(" \u0646\u0647", 5384);
    freq.put("\u0628\u0631\u06af", 2294);
    freq.put("\u062c\u0645\u0639", 1997);
    freq.put("\u06a9\u0644\u0627", 1036);
    freq.put(" \u0646\u064a", 6690);
    freq.put("\u0645\u064a\u0631", 1559);
    freq.put("\u062c\u0646", 6990);
    freq.put("\u062c\u0647", 5500);
    freq.put("\u062c\u0644", 2106);
    freq.put("\u062c\u0645", 10111);
    freq.put(" \u0646\u0635", 1002);
    freq.put(" \u0646\u0634", 1872);
    freq.put("\u062c\u0645\u0647", 2045);
    freq.put("\u062c\u0645\u0648", 2028);
    freq.put(" \u0646\u0638", 2990);
    freq.put("\u062c\u0645\u064a", 1716);
    freq.put("\u062c\u064a", 2986);
    freq.put("\u062c\u0648", 5371);
    freq.put(" \u0646\u0627", 13232);
    freq.put("\u0646\u0627\u0645", 12986);
    freq.put("\u0646\u0627\u0646", 3607);
    freq.put("\u062a ", 137024);
    freq.put("\u0627\u064a\u064a", 11337);
    freq.put(" \u0646\u062e", 1392);
    freq.put("\u0627\u0642\u064a", 1204);
    freq.put("\u0631\u0633 ", 3514);
    freq.put("\u067e\u0631\u0627", 1102);
    freq.put("\u0633\u0627\u062e", 3059);
    freq.put("\u067e\u0631\u062f", 1609);
    freq.put("\u06f9\u06f1", 1915);
    freq.put("\u06f1\u06f3 ", 1130);
    freq.put("\u0639\u0644\u064a", 2182);
    freq.put("\u0639\u062a ", 1441);
    freq.put("\u0644\u064a\u0633", 3144);
    freq.put("\u0639\u0644\u0648", 970);
    freq.put("\u06f9\u06f7", 3928);
    freq.put("\u0644\u064a\u0627", 2311);
    freq.put("\u062a\u0631\u0627", 2202);
    freq.put("\u0634\u0627\u0646", 2849);
    freq.put("\u0644\u064a\u062a", 1597);
    freq.put("\u0644\u064a\u062f", 1495);
    freq.put("\u0639\u0644\u0645", 1702);
    freq.put("\u0648", 425936);
    freq.put("\u0631\u0632\u0634", 844);
    freq.put("\u0644\u064a\u0644", 1108);
    freq.put("\u0644\u064a\u0646", 2134);
    freq.put("\u0644\u064a\u0648", 834);
    freq.put("\u06f1\u06f1", 2760);
    freq.put("\u06f1\u06f0", 3498);
    freq.put("\u06f1\u06f3", 8246);
    freq.put("\u06f1\u06f2", 3243);
    freq.put("\u06f1\u06f5", 2740);
    freq.put("\u06f1\u06f4", 2656);
    freq.put("\u06f1\u06f7", 2716);
    freq.put("\u06f1\u06f6", 2670);
    freq.put("\u06f1\u06f9", 21618);
    freq.put("\u06f1\u06f8", 4100);
    freq.put("\u067e\u0631\u0648", 1607);
    freq.put("\u06af ", 9285);
    freq.put("\u06f3", 25683);
    freq.put("\u06f2 ", 7902);
    freq.put("\u0631\u0633\u064a", 3685);
    freq.put("\u06f9 ", 8815);
    freq.put(" \u062f\u0633", 4487);
    freq.put(" \u062f\u0631", 93973);
    freq.put("\u0646\u062f\u06af", 2266);
    freq.put("\u062f\u0628\u064a", 1292);
    freq.put("\u0633", 370480);
    freq.put("\u0628\u062e\u0634", 8437);
    freq.put("\u062e\u0648\u0631", 1687);
    freq.put("\u0631\u06af ", 3861);
    freq.put(" \u06f5 ", 990);
    freq.put("\u0647\u0631\u064a", 1954);
    freq.put(" \u062f\u064a", 6271);
    freq.put("\u0647\u0627\u0633", 15525);
    freq.put(" \u062f\u0648", 15789);
    freq.put(" \u062f\u0646", 1430);
    freq.put(" \u062f\u0647", 8568);
    freq.put(" \u062f\u0644", 1101);
    freq.put("\u0642\u0645\u0631", 3187);
    freq.put("\u062a\u0646\u062f", 2837);
    freq.put(" \u0645\u06a9", 1516);
    freq.put("\u064a\u06a9\u0627", 4258);
    freq.put("\u0645\u0644\u064a", 2015);
    freq.put("\u0646\u0645\u0648", 979);
    freq.put("\u0627\u06af", 2405);
    freq.put("\u0627\u06a9", 9717);
    freq.put("\u064a\u06af\u0631", 3114);
    freq.put("\u062e\u062a\u0647", 2886);
    freq.put("\u062e\u062a\u0644", 1697);
    freq.put("\u0627\u0698", 1490);
    freq.put("\u0627\u064a\u0654\u064a", 1624);
    freq.put("\u0634\u06af", 3723);
    freq.put("\u0634\u06a9", 5793);
    freq.put("\u06f1\u06f9\u06f9", 7313);
    freq.put("\u06f1\u06f9\u06f8", 3784);
    freq.put("\u06f1\u06f9\u06f5", 879);
    freq.put("\u06f1\u06f9\u06f4", 946);
    freq.put("\u06f1\u06f9\u06f7", 2720);
    freq.put("\u06f1\u06f9\u06f6", 1373);
    freq.put("\u06f8\u06f6", 1335);
    freq.put("\u06f1\u06f9\u06f2", 829);
    freq.put("\u062e\u062a\u0631", 883);
    freq.put("\u0646 ", 207616);
    freq.put("\u064a\u0642 ", 1173);
    freq.put("\u0627\u0637", 5875);
    freq.put("\u0627\u0636", 1760);
    freq.put("\u0627\u0635", 6315);
    freq.put("\u0627\u0634", 15541);
    freq.put("\u0627\u0633", 126776);
    freq.put("\u0627\u0632", 65740);
    freq.put("\u0627\u0631", 177821);
    freq.put("\u06a9\u0631", 10838);
    freq.put("\u062c\u0627 ", 15939);
    freq.put("\u06a9\u0632", 5951);
    freq.put("\u06a9\u0634", 52864);
    freq.put("\u0627\u0639", 7941);
    freq.put("\u0627\u0638", 989);
    freq.put("\u0645\u0639\u0631", 16933);
    freq.put("\u06a9\u0628", 1527);
    freq.put("\u06a9\u062a", 10947);
    freq.put(" \u0645\u0639", 22757);
    freq.put("\u0627\u064a ", 55848);
    freq.put("\u0627\u062f", 40749);
    freq.put("\u0627\u062e", 9486);
    freq.put("\u0627\u062d", 6972);
    freq.put("\u0627\u062c", 4954);
    freq.put("\u0627\u062b", 1612);
    freq.put("\u0627\u062a", 19285);
    freq.put("\u06a9\u0627", 21352);
    freq.put("\u0627\u0628", 23054);
    freq.put("\u0631\u06af\u0631", 1703);
    freq.put("\u0634\u0639", 1023);
    freq.put("\u0634\u0634", 4939);
    freq.put("\u0634\u0635", 3397);
    freq.put("\u0627\u0631 ", 39983);
    freq.put("\u067e\u0648", 2856);
    freq.put("\u0634\u062f", 71050);
    freq.put("\u067e\u064a", 8594);
    freq.put("\u0634\u062a", 20229);
    freq.put("\u0634\u0628", 2714);
    freq.put("\u0634\u0627", 14113);
    freq.put("\u0627\u060c", 2256);
    freq.put("\u067e\u0644", 1723);
    freq.put("\u0645\u0627\u0646", 14800);
    freq.put("\u067e\u0646", 7042);
    freq.put("\u067e\u0647", 1230);
    freq.put("\u0645\u0627\u0639", 870);
    freq.put("\u0698\u0627\u0646", 2068);
    freq.put("\u067e\u0631", 7121);
    freq.put("\u0645\u0627\u0631", 39512);
    freq.put("\u067e\u0633", 3568);
    freq.put("\u0632\u062f\u064a", 1099);
    freq.put("\u0645\u0627\u062a", 1140);
    freq.put("\u067e\u062a", 4019);
    freq.put(" \u0698\u0648", 2172);
    freq.put("\u0634\u064a", 10582);
    freq.put("\u0634\u0648", 16524);
    freq.put("\u0630\u0627\u0631", 1352);
    freq.put("\u0634\u0646", 7520);
    freq.put("\u0634\u0647", 20211);
    freq.put("\u0634\u0645", 40834);
    freq.put("\u0634\u0641", 46579);
    freq.put(" \u0645\u0648", 8861);
    freq.put(" \u0645\u064a", 39390);
    freq.put("\u0645\u0639\u0646", 1773);
    freq.put(" \u0645\u0644", 2782);
    freq.put(" \u0645\u0646", 6720);
    freq.put(" \u0645\u0647", 4441);
    freq.put(" \u0645\u0642", 2722);
    freq.put("\u062f ", 139796);
    freq.put("\u0627\u0647", 29729);
    freq.put("\u06a9\u0648", 9889);
    freq.put("\u0627\u0645", 46608);
    freq.put("\u0627\u0644", 53226);
    freq.put("\u0627\u0642", 12353);
    freq.put("\u0627\u0641", 9698);
    freq.put("\u06a9\u0645", 5441);
    freq.put("\u06a9\u0644", 6076);
    freq.put("\u06a9\u0647", 50638);
    freq.put("\u0627\u0648", 19244);
    freq.put("\u0627\u067e ", 1341);
    freq.put("\u0631\u0633\u0627", 1284);
    freq.put("\u06af\u064a", 9941);
    freq.put("\u06af\u0648", 7699);
    freq.put("\u06af\u0647", 1120);
    freq.put("\u06af\u0646", 1256);
    freq.put("\u0645\u0647\u0645", 1073);
    freq.put("\u06af\u0644", 4014);
    freq.put("\u06af\u0641", 2232);
    freq.put("\u062a\u062d\u062f", 1114);
    freq.put("\u067e\u0646\u062c", 5682);
    freq.put(" \u062e\u0648", 9064);
    freq.put(" \u062e\u064a", 1014);
    freq.put("\u0632\u064a\u0633", 843);
    freq.put("\u0632\u064a\u0631", 3410);
    freq.put("\u0648\u0641 ", 1708);
    freq.put(" \u062e\u0644", 1477);
    freq.put("\u0632\u064a\u0627", 1067);
    freq.put("\u0644\u064a ", 12663);
    freq.put("\u0635\u0648\u0631", 2307);
    freq.put("\u0631\u0632 ", 943);
    freq.put("\u0635\u0648\u0644", 885);
    freq.put(" \u062e\u062f", 1173);
    freq.put(" \u062e\u0627", 5629);
    freq.put("\u062e\u064a ", 1696);
    freq.put("\u06f9\u06f9", 9457);
    freq.put("\u06f9\u06f8", 5762);
    freq.put(" \u062e\u0631", 1716);
    freq.put("\u06f9\u06f0", 1972);
    freq.put("\u06f9\u06f3", 2257);
    freq.put("\u06f9\u06f2", 1938);
    freq.put("\u06f9\u06f5", 1920);
    freq.put("\u06f9\u06f4", 1978);
    freq.put(" \u062e\u0637", 1264);
    freq.put("\u06f9\u06f6", 2485);
    freq.put("\u0631\u0633\u0645", 1031);
    freq.put("\u06af\u0627", 16359);
    freq.put("\u062f\u0645\u0627", 1034);
    freq.put("\u062a\u0631\u0646", 839);
    freq.put("\u0639\u0644\u0627", 887);
    freq.put("\u06af\u0634", 860);
    freq.put("\u06af\u0633", 1433);
    freq.put("\u06af\u0632", 1726);
    freq.put("\u06af\u0631", 18517);
    freq.put("\u06af\u0630", 3598);
    freq.put("\u062e\u0627\u0646", 4015);
    freq.put("\u0647\u0634\u062a", 6878);
    freq.put("\u06f2\u06f4", 2310);
    freq.put("\u06f2\u06f5", 2015);
    freq.put("\u06f2\u06f6", 1845);
    freq.put("\u06f2\u06f7", 1672);
    freq.put("\u06f2\u06f0", 6610);
    freq.put("\u06f2\u06f1", 2252);
    freq.put("\u06f2\u06f2", 2072);
    freq.put("\u06f2\u06f3", 1837);
    freq.put("\u06f2\u06f8", 1810);
    freq.put("\u06f2\u06f9", 1827);
    freq.put("\u06f1 ", 8359);
    freq.put("\u0645\u0644\u0647", 1083);
    freq.put("\u0632\u064a\u06a9", 1213);
    freq.put("\u0631\u06af\u0632", 904);
    freq.put("\u0647", 501741);
    freq.put("\u0631\u06af\u0630", 955);
    freq.put("\u062c\u064a ", 1241);
    freq.put(" \u0698\u0627", 2692);
    freq.put("\u0631\u06af\u0627", 1053);
    freq.put("\u06a9\u0644\u064a", 1793);
    freq.put("\u0647\u0634\u0645", 1388);
    freq.put(" \u0627\u0647", 1491);
    freq.put("\u062e\u0627\u0628", 828);
    freq.put("\u062e\u0627\u0631", 1012);
    freq.put("\u064b ", 1683);
    freq.put("\u0646\u0642\u0634", 885);
    freq.put("\u062a\u0646 ", 2136);
    freq.put("\u0628\u0642 ", 16057);
    freq.put("\u0646\u0641", 2887);
    freq.put("\u0646\u0642", 3830);
    freq.put("\u0645\u0642\u0627", 1363);
    freq.put("\u0646\u0645", 4839);
    freq.put("\u0646\u0646", 4681);
    freq.put("\u0646\u0647", 35756);
    freq.put("\u0646\u0648", 29290);
    freq.put("\u0646\u064a", 39040);
    freq.put("\u064a\u0642\u064a", 1448);
    freq.put("\u0641\u062a\u0627", 2708);
    freq.put("\u0627\u0631\u06af", 1672);
    freq.put("\u0627\u0644 ", 24240);
    freq.put(" \u0644\u064a", 1375);
    freq.put("\u0627\u0631\u06a9", 47474);
    freq.put(" \u0644\u0648", 1161);
    freq.put("\u0646\u0648\u064a", 5351);
    freq.put("\u0646\u0637\u0642", 1746);
    freq.put("\u0627\u0653\u0630\u0631", 4073);
    freq.put("\u0632", 155766);
    freq.put("\u0639\u064a\u062a", 1749);
    freq.put("\u062e\u062a ", 2202);
    freq.put("\u062d\u064a ", 1372);
    freq.put(" \u0644\u0627", 2038);
    freq.put("\u0645\u0648\u062f", 1287);
    freq.put("\u0627\u064a\u0631", 12515);
    freq.put("\u0646\u060c", 5004);
    freq.put("\u062f\u06af", 4253);
    freq.put("\u0646\u0631", 3727);
    freq.put("\u0646\u0632", 3319);
    freq.put("\u0646\u0633", 7940);
    freq.put("\u0646\u0634", 8281);
    freq.put("\u0646\u0635", 3159);
    freq.put("\u062f\u06a9", 1541);
    freq.put("\u0646\u0637", 1891);
    freq.put("\u0646\u0638", 3887);
    freq.put("\u0646\u0639", 1089);
    freq.put("\u06a9\u0627\u0645", 1480);
    freq.put("\u0646\u062f\u0627", 3431);
    freq.put("\u0646\u0627", 34982);
    freq.put("\u0646\u0628", 2742);
    freq.put("\u0646\u062a", 9394);
    freq.put("\u0646\u062c", 25669);
    freq.put("\u0641\u062a\u0645", 1892);
    freq.put("\u0646\u062e", 1510);
    freq.put("\u0646\u062f", 45085);
    freq.put("\u0634\u0645\u064a", 1876);
    freq.put("\u062f\u064a", 30900);
    freq.put("\u062f\u0648", 21727);
    freq.put("\u062f\u0647", 71326);
    freq.put("\u062f\u0646", 24729);
    freq.put("\u062f\u0645", 4441);
    freq.put("\u062f\u0644", 3645);
    freq.put("\u062f\u0642", 1055);
    freq.put("\u062f\u0641", 1399);
    freq.put("\u0646\u0634 ", 1280);
    freq.put("\u0627 ", 87899);
    freq.put("\u06a9 ", 69398);
    freq.put("\u062c\u0627\u0631", 1185);
    freq.put("\u06f1\u06f9 ", 1122);
    freq.put("\u0627\u0653\u0644", 2867);
    freq.put("\u0627\u0653\u0645", 7747);
    freq.put("\u0627\u0653\u0646", 29292);
    freq.put("\u0627\u0653\u0647", 1034);
    freq.put("\u0627\u0653\u0641", 915);
    freq.put("\u0627\u0631\u0628", 1131);
    freq.put("\u0627\u0631\u0627", 5657);
    freq.put("\u06f2\u06f8 ", 1132);
    freq.put("\u0627\u0653\u0648", 3278);
    freq.put("\u0627\u0653\u064a", 2113);
    freq.put("\u0686\u0646\u064a", 1160);
    freq.put("\u064a\u062f\u0627", 2030);
    freq.put("\u0627\u0631\u0635", 1726);
    freq.put("\u0627\u0631\u0634", 1311);
    freq.put("\u0627\u0631\u0633", 5553);
    freq.put("\u0627\u0631\u0632", 893);
    freq.put("\u0634 ", 24544);
    freq.put("\u062f\u060c", 4720);
    freq.put("\u0627\u0631\u064a", 13153);
    freq.put("\u0627\u0631\u0648", 2419);
    freq.put("\u0627\u0631\u0647", 35608);
    freq.put("\u0627\u0631\u0646", 1623);
    freq.put("\u0627\u0631\u0645", 2814);
    freq.put("\u0627\u0653\u0628", 4072);
    freq.put("\u0627\u0653\u062b", 840);
    freq.put("\u0686\u0646\u062f", 1391);
    freq.put("\u0627\u0653\u0630", 4112);
    freq.put("\u0627\u0653\u0631", 1739);
    freq.put("\u0627\u0653\u0632", 1293);
    freq.put("\u0627\u0653\u0633", 1327);
    freq.put("\u067e ", 2440);
    freq.put("\u064a\u062f\u064a", 1302);
    freq.put("\u0645\u0627 ", 2248);
    freq.put("\u0627\u0653\u063a", 1527);
    freq.put("\u062f\u062f", 1619);
    freq.put("\u062f\u062e", 1393);
    freq.put("\u06f0\u06f0\u06f0", 1569);
    freq.put("\u062f\u062a", 1296);
    freq.put("\u062f\u0628", 2008);
    freq.put("\u062f\u0627", 45095);
    freq.put("\u062c\u0627\u0646", 5597);
    freq.put("\u062c\u0627\u0647", 2146);
    freq.put("\u062c\u0627\u0645", 2439);
    freq.put("\u06f2", 32624);
    freq.put("\u064a\u062c ", 845);
    freq.put("\u0646\u06a9", 2007);
    freq.put("\u062f\u0634", 2498);
    freq.put("\u062f\u0633", 6715);
    freq.put("\u062f\u0631", 101792);
    freq.put("\u0646\u06af", 14413);
    freq.put(" \u062d\u0627", 2893);
    freq.put("\u062a\u063a\u064a", 867);
    freq.put("\u0634\u0631\u0642", 5570);
    freq.put(" \u062d\u062f", 1443);
    freq.put("\u0646\u064a\u0632", 2529);
    freq.put("\u06f3\u06f8\u06f3", 931);
    freq.put(" \u062d\u0631", 1265);
    freq.put(" \u062d\u0632", 987);
    freq.put(" \u062d\u0633", 1494);
    freq.put("\u0686\u0647 ", 1398);
    freq.put("\u06f0\u06f2", 955);
    freq.put("\u06f0\u06f3", 960);
    freq.put("\u06f0\u06f0", 7262);
    freq.put("\u06f0\u06f1", 1251);
    freq.put("\u06f0\u06f6", 1030);
    freq.put("\u06f0\u06f7", 971);
    freq.put("\u06f0\u06f4", 954);
    freq.put("\u06f0\u06f5", 991);
    freq.put("\u06f0\u06f8", 1126);
    freq.put("\u06f0\u06f9", 925);
    freq.put("\u0628\u064a", 27336);
    freq.put("\u0630", 11817);
    freq.put("\u0628\u0648", 16880);
    freq.put("\u0628\u0642", 17149);
    freq.put("\u0628\u0646", 6697);
    freq.put("\u0628\u0647", 44819);
    freq.put("\u0628\u0644", 4961);
    freq.put("\u0633\u064a\u0645", 1189);
    freq.put("\u062c\u0648\u0627", 942);
    freq.put("\u0628\u0639", 5160);
    freq.put("\u0628\u0632", 4117);
    freq.put("\u0628\u0633", 4538);
    freq.put("\u0628\u0631", 58307);
    freq.put("\u0647\u0635\u062f", 1629);
    freq.put("\u0628\u0637", 1115);
    freq.put("\u0628\u0634", 1384);
    freq.put("\u0641\u062a\u0635", 1637);
    freq.put("\u0628\u062a", 3170);
    freq.put("\u0646\u062f\u060c", 1301);
    freq.put("\u0628\u062e", 9337);
    freq.put("\u0628\u062f", 4503);
    freq.put(" \u06a9\u0627", 11187);
    freq.put("\u0628\u0627", 53255);
    freq.put(" \u062d\u0645", 1000);
    freq.put(" \u0645\u062c", 4247);
    freq.put("\u0648\u062f\u064a", 1606);
    freq.put(" \u062d\u0642", 954);
    freq.put(" \u060c ", 7275);
    freq.put("\u0698\u0647", 1974);
    freq.put(" \u062d\u0648", 858);
    freq.put("\u06a9\u0646 ", 1159);
    freq.put("\u064a\u0646 ", 61177);
    freq.put("\u062a\u0648\u0627", 4394);
    freq.put("\u0644\u0647 ", 6963);
    freq.put(" \u062d\u06a9", 1033);
    freq.put("\u062a\u0648\u0631", 2332);
    freq.put("\u062a\u0648\u0633", 3860);
    freq.put("\u0627\u0641\u064a", 974);
    freq.put("\u0632\u0627\u0646", 1010);
    freq.put("\u061b", 1040);
    freq.put("\u0633\u0631\u0627", 2106);
    freq.put(" \u0645\u062e", 2396);
    freq.put("\u0648\u0637 ", 936);
    freq.put("\u0627\u062a\u0631", 1045);
    freq.put("\u0642\u0637", 1598);
    freq.put("\u0637\u0648\u0631", 1362);
    freq.put("\u0648\u0639 ", 1666);
    freq.put("\u06a9\u062a\u0631", 1843);
    freq.put("\u0646\u0645\u0627", 2997);
    freq.put("\u0628\u06a9", 2261);
    freq.put("\u0627\u062a\u064a", 2176);
    freq.put("\u0627\u062a\u0648", 1748);
    freq.put("\u06a9\u062a\u0627", 2868);
    freq.put("\u06a9\u062a\u0628", 2985);
    freq.put(" \u0645\u0628", 1057);
    freq.put("\u0632\u0627\u0631", 18512);
    freq.put("\u062a\u0648\u0644", 2859);
    freq.put("\u062a\u0648\u0646", 1309);
    freq.put("\u0627\u063a", 1903);
    freq.put("\u0635\u0631 ", 1320);
    freq.put("\u0627\u0641\u0632", 1059);
    freq.put("\u0627\u0641\u0631", 840);
    freq.put("\u06f0", 28783);
    freq.put("\u0633\u0631\u0648", 889);
    freq.put("\u0627\u0641\u062a", 2627);
    freq.put("\u0632\u0627\u062f", 3573);
    freq.put("\u0627\u0636\u064a", 879);
    freq.put("\u064a\u0644 ", 7962);
    freq.put("\u0637\u0644\u0627", 2183);
    freq.put("\u0637\u0644\u0633", 913);
    freq.put("\u06f6\u06f0 ", 1024);
    freq.put("\u064a\u062e\u064a", 912);
    freq.put("\u0631\u064a\u06a9", 4778);
    freq.put("\u0647\u0648\u0627", 1704);
    freq.put("\u0628\u064a\u0627", 1448);
    freq.put("\u0631\u062f\u0647", 3960);
    freq.put("\u0631\u062f\u0646", 2001);
    freq.put("\u0631\u062f\u0645", 1119);
    freq.put("\u064a\u0645\u0627", 2897);
    freq.put("\u0628\u0631 ", 33260);
    freq.put("\u0631\u062f\u064a", 2386);
    freq.put("\u0646", 505254);
    freq.put("\u062a\u0647 ", 15461);
    freq.put("\u0648\u0642", 2152);
    freq.put("\u0631\u062f\u0627", 4731);
    freq.put("\u062a\u06af", 2018);
    freq.put("\u064a\u0645\u0646", 836);
    freq.put("\u062a\u06a9", 1874);
    freq.put("\u0648\u067e\u0627", 979);
    freq.put("\u064a\u0645\u064a", 2048);
    freq.put("\u062d\u0627\u0644", 1317);
    freq.put("\u06f1", 63091);
    freq.put("\u0631\u064a\u060c", 1064);
    freq.put("\u0627\u0642 ", 2509);
    freq.put("\u0686", 25230);
    freq.put(" \u0641\u0639", 1613);
    freq.put("\u0631\u064a\u062a", 1617);
    freq.put("\u0641\u0627", 9831);
    freq.put("\u0641\u062a", 17008);
    freq.put(" \u0645\u0627", 10891);
    freq.put("\u06f9\u06f1 ", 894);
    freq.put("\u0641\u062f", 1178);
    freq.put("\u0631\u064a\u0627", 4939);
    freq.put("\u0641\u0631", 14718);
    freq.put("\u0641\u0633", 1042);
    freq.put("\u0641\u0632", 1100);
    freq.put("\u062a\u0648", 18858);
    freq.put("\u062a\u064a", 16351);
    freq.put("\u0641\u0636", 915);
    freq.put("\u062a\u0644", 4375);
    freq.put("\u062a\u0645", 9655);
    freq.put("\u062a\u0646", 7644);
    freq.put("\u062a\u0647", 20979);
    freq.put("\u0646\u0627 ", 1758);
    freq.put("\u062a\u0641", 4099);
    freq.put("\u062a\u0642", 4035);
    freq.put("\u0631\u064a\u0648", 908);
    freq.put("\u0641\u0642", 1179);
    freq.put("\u062a\u0639", 2873);
    freq.put("\u062a\u063a", 1106);
    freq.put("\u0641\u0646", 1501);
    freq.put("\u062a\u0634", 4284);
    freq.put("\u062a\u0635", 5949);
    freq.put("\u0631\u064a\u0642", 887);
    freq.put("\u0641\u064a", 8057);
    freq.put("\u0631\u064a\u0644", 1861);
    freq.put("\u062a\u0631", 24685);
    freq.put("\u0631\u064a\u0646", 6859);
    freq.put("\u062a\u0633", 1020);
    freq.put("\u06f7\u06f7", 1205);
    freq.put("\u06f7\u06f6", 1037);
    freq.put("\u06f7\u06f5", 996);
    freq.put("\u06f7\u06f4", 853);
    freq.put("\u06f7\u06f3", 1099);
    freq.put("\u06f7\u06f2", 902);
    freq.put("\u06f7\u06f1", 971);
    freq.put("\u06f7\u06f0", 1130);
    freq.put("\u062a\u0627", 68031);
    freq.put("\u06f7\u06f9", 1133);
    freq.put("\u06f7\u06f8", 1210);
    freq.put("\u0641\u0627\u0639", 864);
    freq.put("\u0646\u062f\u0648", 1099);
    freq.put("\u06f2\u06f9 ", 1101);
    freq.put("\u06a9\u0627\u062a", 897);
    freq.put("\u062a\u060c", 2720);
    freq.put("\u0646\u062f\u064a", 2668);
    freq.put("\u062d\u0645", 4596);
    freq.put("\u062d\u0644", 2638);
    freq.put("\u0636\u0627\u064a", 1046);
    freq.put("\u062d\u0642", 1478);
    freq.put("\u0634\u062f\u0647", 27411);
    freq.put("\u063a\u0627", 3393);
    freq.put("\u062d\u0648", 1605);
    freq.put("\u062d\u064a", 3848);
    freq.put("\u062a\u0642\u0627", 902);
    freq.put("\u0645\u0647\u0648", 1618);
    freq.put("\u062d\u0633\u064a", 842);
    freq.put("\u0628\u0646\u062f", 1464);
    freq.put("\u063a\u0631", 4096);
    freq.put("\u0631\u062c ", 831);
    freq.put("\u0646\u062a\u064a", 1863);
    freq.put("\u06f1\u06f8 ", 1153);
    freq.put("\u0638\u0631 ", 999);
    freq.put("\u0627\u0633 ", 3550);
    freq.put("\u063a\u0631\u0628", 3482);
    freq.put("\u0646\u0647\u0645", 1851);
    freq.put(" \u06f6 ", 835);
    freq.put("\u0646\u0647\u0635", 1628);
    freq.put("\u0645\u0648\u0627", 1351);
    freq.put("\u0646\u062a\u0631", 1378);
    freq.put("\u0646\u0647\u0627", 19728);
    freq.put(" \u06f7 ", 1034);
    freq.put("\u062d\u0627", 5566);
    freq.put("\u063a\u064a", 2298);
    freq.put("\u062d\u062f", 3791);
    freq.put("\u062d\u0628", 830);
    freq.put("\u062d\u062a", 1860);
    freq.put("\u062d\u0635", 1359);
    freq.put("\u06f9\u06f2 ", 854);
    freq.put("\u0634\u0647 ", 1221);
    freq.put("\u0628\u0646\u064a", 1199);
    freq.put("\u062d\u0631", 3367);
    freq.put("\u062a\u060c ", 2631);
    freq.put("\u062d\u0633", 2640);
    freq.put("\u062d\u0632", 1102);
    freq.put("\u062a\u0642\u0648", 993);
    freq.put("\u0627\u0653\u062b\u0627", 830);
    freq.put("\u0646\u0638\u0631", 1892);
    freq.put(" \u06f2\u06f7", 943);
    freq.put("\u06a9\u0632\u064a", 3453);
    freq.put("\u0646\u0638\u0627", 1022);
    freq.put("\u0628\u0648\u0631", 941);
    freq.put("\u0630\u0631", 4784);
    freq.put("\u0630\u0634", 1625);
    freq.put("\u0645\u064a ", 37976);
    freq.put("\u0630\u0627", 2266);
    freq.put("\u0628\u0648\u062f", 10929);
    freq.put("\u0627\u0653\u0646 ", 10516);
    freq.put("\u064a\u0628\u0627", 1219);
    freq.put("\u0646\u0642\u0644", 1074);
    freq.put("\u064f", 2202);
    freq.put("\u0630\u064a", 851);
    freq.put("\u062c\u0632\u064a", 1617);
    freq.put("\u062d\u06a9", 1290);
    freq.put("\u0639\u062f ", 843);
    freq.put("\u0637\u0642\u0647", 1497);
    freq.put("\u0648\u0628 ", 4521);
    freq.put("\u0641\u062a\u0647", 4673);
    freq.put("\u0632\u0647 ", 3212);
    freq.put("\u0648\u0646\u064a", 3417);
    freq.put("\u0631\u0627\u064a", 12001);
    freq.put("\u0631\u0627\u0648", 1025);
    freq.put("\u0631\u0627\u0647", 2985);
    freq.put("\u062e\u0634 ", 8012);
    freq.put("\u0631\u0627\u0645", 1664);
    freq.put("\u0631\u0627\u0644", 1192);
    freq.put("\u0631\u0627\u0641", 1247);
    freq.put("\u062c\u0627\u062f", 1192);
    freq.put("\u062e ", 4523);
    freq.put("\u0645\u0628\u0631", 7239);
    freq.put("\u0647\u0627 ", 10366);
    freq.put("\u0631\u0642\u064a", 4879);
    freq.put("\u063a", 15714);
    freq.put("\u0631\u0648\u0627", 2639);
    freq.put("\u06f6 ", 7892);
    freq.put("\u0647\u0631 ", 8315);
    freq.put("\u067e\u062a\u0627", 3629);
    freq.put(" \u0634\u06a9", 1757);
    freq.put("\u0642\u0644\u0627", 1065);
    freq.put("\u0646\u0627\u0628", 867);
    freq.put("\u0631\u0627\u0633", 2348);
    freq.put("\u0631\u0627\u0632", 1040);
    freq.put("\u0631\u0627\u0631", 4645);
    freq.put("\u0631\u0627\u062f", 1759);
    freq.put("\u0631\u0627\u062d", 1002);
    freq.put("\u0631\u0627\u062a", 2813);
    freq.put("\u0648\u0646\u062f", 2535);
    freq.put("\u0631\u0627\u0628", 3402);
    freq.put("\u0631\u0627\u064a\u0654", 1115);
    freq.put(" \u0641\u064a", 4001);
    freq.put("\u0648\u0646\u0627", 1554);
    freq.put("\u062a\u0627\u064a", 3199);
    freq.put("\u0627\u0653\u0645\u062f", 1740);
    freq.put("\u062a\u0627\u0644", 1624);
    freq.put("\u062a\u0627\u0645", 3922);
    freq.put("\u062a\u0627\u0646", 31858);
    freq.put("\u062a\u0627\u0647", 3675);
    freq.put("\u0628\u0644 ", 1849);
    freq.put("\u0627\u0653\u0645\u0631", 3443);
    freq.put("\u0631\u0635\u062f", 2148);
    freq.put("\u064a\u0627\u0645", 955);
    freq.put(" \u0634\u064a", 3635);
    freq.put(" \u0634\u0648", 11010);
    freq.put(" \u0634\u0647", 16707);
    freq.put(" \u0634\u0646", 2904);
    freq.put(" \u0634\u0645", 35388);
    freq.put("\u0627\u0631\u062f", 9154);
    freq.put(" \u0634\u0635", 1903);
    freq.put(" \u0634\u0634", 4604);
    freq.put(" \u0634\u0631", 8538);
    freq.put(" \u0634\u062f", 64662);
    freq.put(" \u0634\u062e", 981);
    freq.put(" \u0634\u0628", 2526);
    freq.put(" \u0634\u0627", 6389);
    freq.put("\u06f4\u06f5", 921);
    freq.put("\u06f1\u06f3\u06f8", 2507);
    freq.put("\u0627\u0631\u062a", 4139);
    freq.put("\u062a\u0627\u0628", 4019);
    freq.put("\u0627\u0653\u0645\u0648", 1076);
    freq.put("\u067e\u0627\u062f", 1299);
    freq.put("\u062a\u0627\u062f", 4918);
    freq.put(" \u06f8 ", 918);
    freq.put("\u06f9\u06f0 ", 940);
    freq.put("\u0631\u0627\u06a9", 1311);
    freq.put("\u062a\u0627\u0631", 5154);
    freq.put("\u062a\u0627\u0634", 890);
    freq.put("\u0646\u0646\u062f", 4531);
    freq.put("\u0635\u0648", 4924);
    freq.put("\u062c\u0631\u064a", 3087);
    freq.put("\u0635\u064a", 2649);
    freq.put("\u0635\u0644", 3684);
    freq.put("\u0635\u0646", 1205);
    freq.put("\u0635\u0641", 2604);
    freq.put("\u0633\u064a ", 13405);
    freq.put("\u0645\u0648\u0632", 1395);
    freq.put("\u0645\u0648\u0633", 2124);
    freq.put("\u0645\u0648\u0631", 2297);
    freq.put("\u062c\u0647\u0627", 2193);
    freq.put("\u0645\u0648\u0639", 2058);
    freq.put(" \u0648\u064a", 5201);
    freq.put("\u0638", 7379);
    freq.put("\u0645\u0648\u062c", 939);
    freq.put("\u064a\u0641 ", 1505);
    freq.put(" \u0648\u0644", 1293);
    freq.put("\u06f0\u06f0 ", 2532);
    freq.put("\u06f2\u06f4 ", 1524);
    freq.put(" \u0648\u0633", 1484);
    freq.put(" \u0648\u0632", 1216);
    freq.put(" \u0648\u0631", 1520);
    freq.put("\u0645\u0648\u0646", 1614);
    freq.put("\u0632\u0634 ", 1033);
    freq.put(" \u0648\u062c", 1401);
    freq.put("\u0634\u0631 ", 1296);
    freq.put(" \u0648\u0627", 10473);
    freq.put(" \u0646\u0645", 3573);
    freq.put("\u0635\u0631", 2425);
    freq.put("\u0635\u062f", 15627);
    freq.put("\u0647\u0645\u0686", 1222);
    freq.put("\u0627\u0632 ", 51085);
    freq.put("\u0635\u062a", 1929);
    freq.put("\u0635\u0627", 3027);
    freq.put("\u062c\u0631\u0627", 1045);
    freq.put("\u0634\u06af\u0627", 3095);
    freq.put("\u064a\u062a ", 7713);
    freq.put("\u06f1\u06f9\u06f3", 1178);
    freq.put("\u0638\u0627", 1618);
    freq.put("\u067e\u0627\u0646", 3222);
    freq.put("\u06f2\u06f6 ", 1164);
    freq.put("\u0638\u0631", 2221);
    freq.put("\u067e\u0627\u064a", 4002);
    freq.put("\u0627\u0654", 1456);
    freq.put("\u062d\u0645\u062f", 2876);
    freq.put("\u06a9\u0633\u062a", 856);
    freq.put("\u0647\u0645\u064a", 4888);
    freq.put("\u064a\u0639\u064a", 880);
    freq.put("\u0647\u0654 ", 10011);
    freq.put("\u0647\u0645\u0627", 980);
    freq.put("\u062b\u0627", 1467);
    freq.put("\u067e\u0627\u0631", 1859);
    freq.put("\u062b\u0631", 1600);
    freq.put("\u0648\u0644 ", 5820);
    freq.put("\u0644\u0645 ", 2584);
    freq.put("\u06f8", 24510);
    freq.put("\u0633 ", 20728);
    freq.put(" \u0646\u0648", 12914);
    freq.put("\u062e\u0647 ", 1063);
    freq.put("\u064a\u062f\u0646", 1012);
    freq.put("\u064a\u062f\u0647", 2751);
    freq.put("\u0627\u0653\u0644\u0645", 1164);
    freq.put("\u062e\u0644\u064a", 855);
    freq.put("\u0644\u0646\u062f", 1567);
    freq.put("\u0635\u0644 ", 1169);
    freq.put("\u0648\u0645\u062a", 2798);
    freq.put("\u064a\u0654\u0646 ", 919);
    freq.put("\u062c\u0627\u064a", 1843);
    freq.put("\u0686\u064a\u0646", 1123);
    freq.put("\u064e", 4564);
    freq.put("\u0648\u0645\u064a", 5536);
    freq.put("\u0635\u062f ", 14363);
    freq.put("\u062a\u0634\u06a9", 1423);
    freq.put("\u06f9", 42744);
    freq.put("\u0648\u062a\u0628", 889);
    freq.put(" \u0633\u0631", 6965);
    freq.put(" \u0633\u0637", 837);
    freq.put(" \u0633\u062a", 1210);
    freq.put("\u0633\u067e\u0627", 1035);
    freq.put(" \u0633\u0628", 1207);
    freq.put(" \u0633\u062f", 907);
    freq.put("\u0634\u0645\u0627", 36739);
    freq.put("\u0633\u067e\u062a", 3558);
    freq.put(" \u0633\u0627", 27260);
    freq.put("\u0639", 91539);
    freq.put(" \u0633\u067e", 4409);
    freq.put("\u062a\u0645 ", 2196);
    freq.put("\u0647\u0633\u062a", 7247);
    freq.put("\u062f\u0648 ", 4399);
    freq.put(" \u0633\u064a", 58158);
    freq.put("\u0647\u060c ", 2793);
    freq.put(" \u0633\u0648", 5501);
    freq.put("\u06af\u064a ", 4154);
    freq.put(" \u0633\u0641", 999);
    freq.put(" \u0633\u0646", 2452);
    freq.put(" \u0633\u0647", 2789);
    freq.put(" \u0633\u0644", 2036);
    freq.put(" \u0633\u0645", 1003);
    freq.put(" \u0647\u0634", 6627);
    freq.put(" \u0647\u0632", 15471);
    freq.put(" \u0647\u0633", 2372);
    freq.put(" \u0647\u0631", 3177);
    freq.put("\u060c", 43281);
    freq.put("\u0627\u0632\u0646", 1098);
    freq.put("\u0627\u0632\u0647", 1433);
    freq.put("\u0627\u0632\u0645", 1894);
    freq.put("\u064a\u062a\u064a", 884);
    freq.put(" \u0647\u062c", 2983);
    freq.put("\u0627\u0632\u064a", 4465);
    freq.put("\u063a\u064a\u0631", 1279);
    freq.put("\u0648\u0627\u0698", 1094);
    freq.put(" \u06f9 ", 923);
    freq.put("\u062c\u0647 ", 2283);
    freq.put(" \u0646\u0632", 1060);
    freq.put("\u0645\u0648\u0644", 1953);
    freq.put("\u06f9\u06f7 ", 955);
    freq.put("\u0698\u0647 ", 1588);
    freq.put(" \u0648 ", 107907);
    freq.put("\u0647\u0648\u0631", 2961);
    freq.put("\u0647\u0632\u0627", 15536);
    freq.put("\u06af\u0644\u064a", 2047);
    freq.put(" \u0647\u0646", 3049);
    freq.put("\u0627\u0632\u0627", 956);
    freq.put("\u0633\u06a9", 2829);
    freq.put("\u062f\u0627\u062e", 1028);
    freq.put("\u06f7", 19045);
    freq.put(" \u0647\u0641", 7486);
    freq.put("\u064a\u062a\u0627", 2607);
    freq.put("\u0627\u0632\u062f", 2915);
    freq.put(" \u0647\u064a", 1336);
    freq.put("\u0635 ", 2346);
    freq.put(" \u0647\u0648", 2401);
    freq.put("\u0638 ", 1176);
    freq.put("\u0648\u0627\u0632", 2127);
    freq.put("\u0648\u0627\u0631", 3450);
    freq.put("\u0633\u064a", 82351);
    freq.put("\u0644\u0645\u064a", 1688);
    freq.put("\u0633\u0648", 9339);
    freq.put("\u0648\u0627\u0628", 2536);
    freq.put("\u0632\u0631\u06af", 3314);
    freq.put("\u0633\u0641", 2299);
    freq.put("\u0633\u0647", 5822);
    freq.put("\u0633\u0646", 5406);
    freq.put("\u0633\u0645", 5040);
    freq.put("\u0633\u0644", 6428);
    freq.put("\u0698\u0648\u064a\u0654", 1909);
    freq.put("\u0631\u0645\u0632", 959);
    freq.put("\u064a\u0686 ", 1170);
    freq.put("\u064a\u0654\u0646", 1012);
    freq.put("\u064a\u0654\u0648", 1601);
    freq.put("\u064a\u0654\u064a", 4511);
    freq.put("\u06a9\u0633 ", 931);
    freq.put(" \u0642", 22376);
    freq.put("\u0647\u0645 ", 4541);
    freq.put("\u0648\u064a\u0686", 897);
    freq.put("\u064a\u0639 ", 1026);
    freq.put("\u0641\u0639\u0627", 1470);
    freq.put(" \u0647", 83469);
    freq.put("\u0633\u0639", 1222);
    freq.put("\u062b ", 1238);
    freq.put("\u0633\u0631", 10053);
    freq.put("\u0633\u0637", 4899);
    freq.put("\u0648\u0644\u0627", 2437);
    freq.put("\u0633\u062a", 157670);
    freq.put("\u0633\u0628", 3293);
    freq.put("\u0633\u062f", 1583);
    freq.put("\u0633\u062e", 1157);
    freq.put("\u0648\u0644\u062f", 1454);
    freq.put("\u0648\u0627\u0647", 871);
    freq.put("\u0648\u0627\u0644", 1232);
    freq.put("\u0648\u0627\u0645", 2251);
    freq.put("\u0633\u0627", 40397);
    freq.put("\u0648\u0644\u062a", 1350);
    freq.put("\u0644\u0645\u0627", 2054);
    freq.put("\u0642\u0631\u0627", 4415);
    freq.put("\u0627\u0653", 65724);
    freq.put("\u0631\u0648 ", 1622);
    freq.put(" \u0632\u0645", 4334);
    freq.put("\u0642\u062f\u064a", 1049);
    freq.put(" \u0632\u0646", 2927);
    freq.put("\u0648\u0645 ", 4571);
    freq.put(" \u0632\u064a", 3601);
    freq.put("\u0633\u0645\u064a", 1232);
    freq.put("\u0633\u064a\u0642", 1188);
    freq.put(" \u0632\u0627", 2852);
    freq.put("\u0635\u0644\u064a", 1295);
    freq.put(" \u0632\u0628", 3421);
    freq.put("\u0642\u0631\u0646", 906);
    freq.put("\u0627\u0653\u0647\u0646", 945);
    freq.put("\u0646\u0627\u064a", 2070);
    freq.put("\u0633\u064a\u0646", 2125);
    freq.put("\u0633\u064a\u0644", 1493);
    freq.put("\u062f\u0648\u064a", 2445);
    freq.put("\u0628\u0633\u062a", 2397);
    freq.put("\u062f\u0648\u0645", 3136);
    freq.put("\u062f\u0648\u0646", 991);
    freq.put("\u06af\u0627\u0631", 1384);
    freq.put(" \u06a9\u0648", 5973);
    freq.put("\u0634\u062e\u0635", 1423);
    freq.put("\u0634\u062f\u0646", 16377);
    freq.put("\u0641\u064a\u0632", 835);
    freq.put("\u0632\u0645\u0627", 4471);
    freq.put("\u062c\u0648\u062f", 1945);
    freq.put("\u0633\u064a\u0633", 2418);
    freq.put("\u062a\u0645\u064a", 4044);
    freq.put("\u0644\u062f ", 1738);
    freq.put("\u0633\u064a\u0631", 939);
    freq.put("\u062a\u0645\u0627", 2359);
    freq.put("\u0633\u064a\u0635", 1797);
    freq.put("\u0641\u064a\u0644", 2814);
    freq.put("\u062f\u0648\u062f", 1919);
    freq.put("\u06af\u064a\u0631", 2604);
    freq.put("\u0628\u0633\u064a", 1565);
    freq.put("\u062f\u0648\u0627", 1480);
    freq.put(" \u0630", 1128);
    freq.put(" \u0631", 51088);
    freq.put(" \u064a\u06a9", 22683);
    freq.put("\u06af\u0627\u0647", 8669);
    freq.put("\u06af\u0627\u0646", 3798);
    freq.put("\u06af\u064a\u062a", 1091);
    freq.put("\u062f\u0648\u0631", 3332);
    freq.put("\u0633\u064a\u062f", 2026);
    freq.put("\u063a ", 1398);
    freq.put("\u0634\u0628\u0647", 953);
    freq.put("\u06a9\u0646\u0627", 990);
    freq.put("\u0628\u0646 ", 2042);
    freq.put("\u0634\u0647\u0648", 994);
    freq.put("\u0636\u064a ", 873);
    freq.put("\u0627\u0633\u0631", 1003);
    freq.put("\u0633\u064a\u0627", 50847);
    freq.put("\u0648\u064a\u0654\u064a", 1673);
    freq.put("\u0627\u0633\u0627", 2986);
    freq.put("\u0627\u0633\u062a", 105076);
    freq.put("\u0648\u064a\u0654\u0646", 956);
    freq.put("\u0646\u062a ", 1363);
    freq.put("\u0641\u064a ", 1976);
    freq.put("\u0633\u064a\u0648", 851);
    freq.put("\u0627\u0633\u0645", 943);
    freq.put("\u0627\u0633\u0644", 2665);
    freq.put("\u0627\u0633\u064a", 5578);
    freq.put("\u0646\u0647 ", 11112);
    freq.put("\u0634\u0647\u0631", 16753);
    freq.put("\u062d ", 3843);
    freq.put("\u0633\u0637 ", 3314);
    freq.put("\u06f8\u06f0 ", 846);
    freq.put("\u0627\u0633\u067e", 971);
    freq.put("\u06f9\u06f6 ", 844);
    freq.put("\u0631\u062c\u0647", 899);
    freq.put("\u0645\u0647 ", 7560);
    freq.put(" \u0633", 118308);
    freq.put("\u0648\u0628\u064a", 1735);
    freq.put("\u0627\u0653\u0646\u0647", 16519);
    freq.put("\u0648\u0627\u062f", 2014);
    freq.put("\u0644\u0627\u0628", 1067);
    freq.put("\u0644\u0627\u062f", 4785);
    freq.put("\u0644\u0627\u062d", 1096);
    freq.put("\u0648\u0633\u064a", 3688);
    freq.put("\u0644\u0627\u0631", 867);
    freq.put("\u0627\u0633\u06a9", 971);
    freq.put("\u0644\u0627\u0639", 939);
    freq.put("\u0644\u0627\u0642", 1169);
    freq.put("\u064a\u0628 ", 1599);
    freq.put("\u0644\u0627\u0641", 888);
    freq.put("\u0644\u0627\u0646", 2170);
    freq.put("\u0644\u0627\u0644", 908);
    freq.put("\u0644\u0627\u0645", 3536);
    freq.put("\u0644\u0627\u064a", 1580);
    freq.put("\u064b", 1698);
    freq.put("\u06f2\u06f2 ", 1199);
    freq.put("\u062f\u064a\u062f", 3091);
    freq.put("\u0644\u0644\u0647", 1097);
    freq.put("\u0639\u062f\u0627", 1093);
    freq.put("\u062d\u0644 ", 927);
    freq.put("\u06a9\u0632 ", 2384);
    freq.put("\u0647\u064a ", 3587);
    freq.put(" \u0631\u0633", 3186);
    freq.put(" \u0631\u0634", 1541);
    freq.put("\u060c ", 41769);
    freq.put("\u0647\u0644 ", 2462);
    freq.put("\u06f4\u06f0", 1179);
    freq.put(" \u0631\u0627", 15933);
    freq.put("\u0647\u0627\u060c", 830);
    freq.put("\u062e\u062a", 10589);
    freq.put("\u0647\u0627\u0631", 8046);
    freq.put("\u0698\u064a ", 877);
    freq.put("\u062a\u0628\u0627", 2109);
    freq.put("\u062e\u062f", 1570);
    freq.put("\u0647\u0631\u0647", 1437);
    freq.put("\u0647\u0631\u0645", 1056);
    freq.put("\u062e\u0627", 9456);
    freq.put("\u062a\u0628\u0631", 18681);
    freq.put("\u0633\u0644\u0627", 2748);
    freq.put("\u0636", 9683);
    freq.put("\u062e\u0631", 3213);
    freq.put("\u062e\u0633", 1563);
    freq.put("\u062e\u0634", 9472);
    freq.put("\u062e\u0635", 2448);
    freq.put("\u062e\u0637", 1338);
    freq.put("\u062e\u0648", 10471);
    freq.put("\u062e\u064a", 3813);
    freq.put("\u0647\u0631\u0627", 3739);
    freq.put("\u062e\u0644", 2639);
    freq.put("\u062e\u0647", 1201);
    freq.put("\u0631\u0642 ", 1211);
    freq.put("\u0647\u0627\u0646", 4405);
    freq.put("\u0647\u0631\u0633", 8280);
    freq.put("\u0647\u0627\u064a", 33269);
    freq.put("\u0631\u062d", 1384);
    freq.put("\u062c\u0646\u06af", 1615);
    freq.put("\u0628\u0632\u0631", 3175);
    freq.put(" \u0631\u0641", 1064);
    freq.put(" \u0631\u0645", 1079);
    freq.put(" \u0631\u0648", 19239);
    freq.put("\u0648\u0646 ", 8984);
    freq.put(" \u0631\u064a", 3051);
    freq.put("\u0631\u0627 ", 12544);
    freq.put("\u0634\u06a9\u064a", 1859);
    freq.put("\u062a\u0634\u0631", 878);
    freq.put("\u062a\u0644\u0627", 1147);
    freq.put("\u062c\u0646\u0648", 3614);
    freq.put("\u06f6\u06f0", 1533);
    freq.put("\u06f6\u06f1", 861);
    freq.put("\u06f6\u06f5", 892);
    freq.put("\u06f6\u06f8", 828);
    freq.put("\u06f6\u06f9", 864);
    freq.put("\u0632\u0627\u064a", 1000);
    freq.put("\u0621", 1000);
    freq.put("\u0632\u0645\u064a", 2413);
    freq.put("\u0646\u0641\u0631", 1610);
    freq.put("\u0641\u0647 ", 1283);
    freq.put("\u062a\u0647\u0627", 877);
    freq.put("\u062a\u0627 ", 5488);
    freq.put("\u062a\u0644\u0641", 1376);
    freq.put("\u06f6", 17216);
    freq.put("\u062b\u0627\u0631", 853);
    freq.put("\u0645\u062e\u062a", 1330);
    freq.put("\u0645\u062c\u0644", 977);
    freq.put("\u0631\u0647\u0627", 4101);
    freq.put("\u062f\u0627 ", 1969);
    freq.put("\u064a\u0635\u062f", 1797);
    freq.put("\u0650", 3108);
    freq.put("\u0632 ", 65089);
    freq.put(" \u0646\u06af", 1352);
    freq.put("\u0645\u0634\u0647", 1314);
    freq.put("\u0645\u0646\u062f", 1285);
    freq.put("\u0654", 10105);
    freq.put("\u0628\u0647 ", 41777);
    freq.put(" \u0647\u0627", 28631);
    freq.put("\u0631\u0647\u0654", 1083);
    freq.put("\u062f\u064a ", 13399);
    freq.put("\u0631\u0647\u0646", 1422);
    freq.put(" \u06f2 ", 1134);
    freq.put("\u06af\u0630\u0634", 1619);
    freq.put(" \u0686\u0627", 2040);
    freq.put("\u0645\u0686\u0646", 1005);
    freq.put(" \u0637\u0648", 1797);
    freq.put("\u06af\u0630\u0627", 1619);
    freq.put("\u06f3\u06f1 ", 837);
    freq.put("\u06f8\u06f1 ", 878);
    freq.put("\u0645\u0646 ", 2003);
    freq.put(" \u0627\u0653\u0631", 1633);
    freq.put("\u0627\u0653\u0628 ", 1128);
    freq.put("\u0648\u0631\u0648", 1136);
    freq.put("\u0646\u0648\u0639", 1934);
    freq.put("\u0627\u062d ", 1044);
    freq.put(" \u0637\u0628", 16842);
    freq.put(" \u0637\u0631", 1891);
    freq.put("\u0636\u0627", 2719);
    freq.put("\u06f2\u06f3 ", 1040);
    freq.put("\u06af\u0641\u062a", 2210);
    freq.put("\u0645\u0631\u06a9", 5626);
    freq.put("\u0636\u0631", 876);
    freq.put("\u0634\u0635\u062a", 1903);
    freq.put("\u0634\u0635\u062f", 1494);
    freq.put("\u064a\u064a ", 11355);
    freq.put("\u06f4\u06f8", 900);
    freq.put("\u06f4\u06f9", 832);
    freq.put("\u06f4\u06f4", 839);
    freq.put("\u062a", 373990);
    freq.put("\u06f4\u06f2", 932);
    freq.put("\u06f4\u06f3", 828);
    freq.put("\u062f\u0647\u0633", 4371);
    freq.put("\u06f4\u06f1", 851);
    freq.put("\u062f\u0647\u062f", 1019);
    freq.put("\u06a9\u0645\u064a", 2269);
    freq.put("\u06a9\u0627\u0646", 3075);
    freq.put("\u062f\u0647\u0627", 1941);
    freq.put("\u06f1\u06f2 ", 1158);
    freq.put("\u0639\u0645\u0648", 1947);
    freq.put("\u0646\u062e\u0633", 1148);
    freq.put("\u0627\u062d\u062a", 888);
    freq.put("\u062f\u0647\u0654", 2250);
    freq.put("\u0639\u0645\u0644", 1014);
    freq.put("\u062f\u0647\u0645", 3138);
    freq.put("\u0636\u0648", 1678);
    freq.put("\u0636\u064a", 1604);
    freq.put("\u0646\u0648\u0634", 1776);
    freq.put("\u0627\u0644\u062f", 1099);
    freq.put("\u0631\u0641 ", 16580);
    freq.put("\u0634\u0631\u06a9", 1669);
    freq.put("\u0645\u0631\u0628", 1215);
    freq.put("\u0627\u0645\u0647", 4047);
    freq.put("\u0627\u0645\u0646", 1026);
    freq.put("\u0645\u0631\u062f", 2093);
    freq.put("\u0627\u0645\u0644", 2517);
    freq.put("\u0627\u0645\u064a", 5640);
    freq.put("\u0627\u0645\u0648", 1040);
    freq.put("\u0645\u0631\u0627", 2087);
    freq.put("\u0633\u0631\u064a", 988);
    freq.put("\u0627\u0645\u067e", 1281);
    freq.put("\u0641\u0631\u0627", 3846);
    freq.put("\u0627\u062e\u062a", 6534);
    freq.put("\u0641\u0631\u062f", 869);
    freq.put("\u0648\u0647 ", 3934);
    freq.put("\u0641\u0627\u062f", 2141);
    freq.put("\u0641 ", 71140);
    freq.put("\u0641\u0631\u0645", 1232);
    freq.put("\u0641\u0631\u0647", 1581);
    freq.put("\u0631\u0634 ", 1790);
    freq.put("\u062f\u064a\u06af", 2478);
    freq.put("\u0641\u0631\u0648", 1305);
    freq.put("\u0641\u0627\u0631", 2458);
    freq.put("\u0641\u0631\u064a", 1360);
    freq.put("\u0627\u0645\u0631", 1231);
    freq.put("\u0644 ", 55421);
    freq.put("\u0645\u0631\u0648", 1152);
    freq.put("\u0645\u0631\u064a", 7089);
    freq.put("\u0627\u0645\u0627", 3065);
    freq.put("\u06a9\u064a\u0644", 3244);
    freq.put("\u0627\u0645\u0628", 7272);
    freq.put("\u064a\u062f ", 7931);
    freq.put("\u0648\u064a\u0631", 1085);
    freq.put("\u0648\u064a\u0633", 4678);
    freq.put("\u0648\u064a\u0632", 853);
    freq.put("\u0630\u0631\u0628", 3735);
    freq.put("\u0641\u0639", 2000);
    freq.put("\u0631", 687985);
    freq.put("\u0628", 289206);
    freq.put("\u06af\u0631\u0641", 2543);
    freq.put("\u0686\u0627", 2573);
    freq.put("\u062c\u0632", 2725);
    freq.put("\u06af\u0631\u064a", 2038);
    freq.put("\u06af\u0631\u0648", 2216);
    freq.put("\u062c\u0631", 5927);
    freq.put("\u064a\u062f\u0644", 878);
    freq.put("\u06af\u0631\u0627", 2354);
    freq.put("\u0686\u0646", 2891);
    freq.put("\u0686\u0647", 10435);
    freq.put("\u06af\u0631\u062f", 3447);
    freq.put("\u064a\u0646\u062f", 2629);
    freq.put("\u0686\u064a", 2258);
    freq.put("\u0646\u064a\u06a9", 1404);
    freq.put("\u0645\u060c ", 1039);
    freq.put("\u064a\u0654\u064a\u0647", 1089);
    freq.put("\u0648\u064a\u0645", 1400);
    freq.put("\u0648\u064a\u0647", 2289);
    freq.put("\u0648\u064a\u0646", 2044);
    freq.put("\u0648\u064a\u064a", 925);
    freq.put(" \u0646\u0631", 962);
    freq.put("\u0634\u062a\u0627", 2276);
    freq.put("\u0639\u0646\u0648", 2161);
    freq.put(" \u0646\u0633", 1428);
    freq.put("\u0639\u0646\u064a", 1446);
    freq.put("\u066c", 970);
    freq.put("\u0634\u062a\u0631", 2340);
    freq.put(" \u0628\u064a", 13492);
    freq.put(" \u0628\u0648", 12627);
    freq.put("\u0634\u062a\u0635", 1588);
    freq.put(" \u0628\u0647", 41159);
    freq.put(" \u0628\u0646", 5266);
    freq.put(" \u0628\u0644", 1919);
    freq.put("\u0639\u0647 ", 4310);
    freq.put("\u0637 ", 7167);
    freq.put("\u0648\u064a\u0698", 863);
    freq.put("\u0645\u064a\u0644", 5431);
    freq.put(" \u0647\u0645", 7875);
    freq.put("\u0686\u06a9", 1330);
    freq.put("\u062f\u0645 ", 1329);
    freq.put("\u0645\u064a\u0646", 23588);
    freq.put("\u0634\u0634\u0645", 1955);
    freq.put(" \u0686\u0647", 9110);
    freq.put("\u0632\u062f ", 1250);
    freq.put("\u064a\u0627\u0628", 1358);
    freq.put("\u0634\u0634\u0635", 1494);
    freq.put("\u06a9\u0647 ", 49534);
    freq.put("\u06f3\u06f0 ", 1283);
    freq.put("\u062a\u0641\u0627", 3357);
    freq.put(" \u0628\u0639", 1479);
    freq.put(" \u0686\u064a", 1498);
    freq.put("\u0634\u062a\u0645", 2005);
    freq.put("\u0634\u062a\u0647", 5322);
    freq.put(" \u0628\u0633", 2873);
    freq.put(" \u0628\u0632", 3261);
    freq.put(" \u0628\u0631", 23110);
    freq.put("\u0634\u062a\u064a", 869);
    freq.put("\u062f\u0644\u0628", 839);
    freq.put(" \u0628\u062f", 2040);
    freq.put(" \u0628\u062e", 8934);
    freq.put(" \u0628\u0627", 32041);
    freq.put("\u0633\u0645\u062a", 1146);
    freq.put("\u0646\u064a\u0648", 887);
    freq.put("\u0627\u0648\u0631", 2685);
    freq.put("\u0627\u062f\u064a", 8285);
    freq.put("\u0645\u0639\u0627", 1278);
    freq.put("\u0627\u062f\u0647", 8465);
    freq.put("\u0646\u064a\u0646", 1804);
    freq.put("\u0646\u064a\u0645", 949);
    freq.put("\u0631\u0641", 22038);
    freq.put("\u0631\u0642", 7164);
    freq.put("\u0631\u0645", 13248);
    freq.put("\u0631\u0644", 1461);
    freq.put("\u0631\u0647", 48555);
    freq.put("\u0631\u0646", 9102);
    freq.put("\u0631\u0648", 41463);
    freq.put("\u0631\u064a", 64671);
    freq.put("\u0627\u0648\u062a", 2392);
    freq.put("\u06a9", 285107);
    freq.put("\u0631\u067e", 863);
    freq.put("\u0628\u064a ", 8868);
    freq.put("\u06f2\u06f5 ", 1126);
    freq.put("\u0646\u064a\u060c", 840);
    freq.put("\u0639 ", 15503);
    freq.put("\u06f2\u06f0 ", 1572);
    freq.put("\u0631\u060c", 2098);
    freq.put("\u0631\u0631", 874);
    freq.put("\u0631\u0633", 21469);
    freq.put("\u0631\u0632", 5465);
    freq.put("\u0631\u0635", 2328);
    freq.put("\u0627\u062f\u0628", 902);
    freq.put("\u0645\u0644\u0644", 1010);
    freq.put("\u0631\u0636", 1657);
    freq.put("\u0631\u0639", 995);
    freq.put("\u0627\u062f\u0627", 1809);
    freq.put("\u0646\u064a\u0627", 4775);
    freq.put("\u0632\u062f\u0647", 4341);
    freq.put("\u0627\u0648\u0644", 3794);
    freq.put("\u06a9\u0646\u0646", 2076);
    freq.put("\u0631\u0627\u0653", 1627);
    freq.put("\u0631\u0627", 79279);
    freq.put("\u0641\u0632\u0627", 918);
    freq.put("\u0646\u064a\u0633", 1397);
    freq.put("\u0627\u062f\u0634", 1271);
    freq.put("\u0646\u064a\u0631", 1331);
    freq.put("\u0631\u062a", 10552);
    freq.put("\u0627\u062f\u0631", 1545);
    freq.put("\u0631\u062c", 4101);
    freq.put("\u0627\u0648\u064a", 1440);
    freq.put("\u067e", 57795);
    freq.put("\u0698\u064a", 1330);
    freq.put("\u0698\u0648", 2750);
    freq.put("\u06f1\u06f1 ", 1041);
    freq.put("\u064a\u0648\u0646", 3682);
    freq.put("\u06f9\u06f9\u06f9", 1558);
    freq.put("\u06f9\u06f9\u06f8", 1457);
    freq.put(" \u067e\u0648", 1775);
    freq.put(" \u067e\u064a", 6231);
    freq.put("\u064a\u0627\u0631", 48948);
    freq.put("\u064a\u0627\u0632", 1404);
    freq.put("\u064a\u0627\u0633", 2249);
    freq.put(" \u067e\u0644", 1189);
    freq.put(" \u067e\u0646", 6100);
    freq.put("\u062f\u060c ", 4587);
    freq.put("\u0629", 899);
    freq.put("\u0644\u0645\u0644", 950);
    freq.put("\u0648\u0644\u064a", 4939);
    freq.put("\u0646\u060c ", 4905);
    freq.put("\u0645\u062f ", 3240);
    freq.put("\u0644\u0641 ", 1009);
    freq.put("\u064a\u0633\u0627", 894);
    freq.put("\u0647\u0641\u062a", 6908);
    freq.put("\u0631\u0686", 966);
    freq.put("\u0633\u067e", 5713);
    freq.put("\u064a\u0627\u064a", 3214);
    freq.put("\u064a\u0648\u0627", 1011);
    freq.put(" \u067e\u0631", 5507);
    freq.put("\u064a\u0627\u0641", 1602);
    freq.put(" \u067e\u0633", 3103);
    freq.put("\u064a\u0627\u0644", 2762);
    freq.put("\u0698\u0627", 3316);
    freq.put("\u064a\u0627\u0646", 11075);
    freq.put("\u064a\u0627\u0647", 1109);
    freq.put("\u064a\u0648\u0633", 866);
    freq.put("\u064a\u0627\u062a", 2044);
    freq.put(" \u067e\u062f", 1204);
    freq.put("\u0631\u06a9", 59526);
    freq.put("\u0631\u06af", 10959);
    freq.put("\u064a\u0654\u064a ", 825);
    freq.put("\u062f\u0634\u0627", 1262);
    freq.put(" \u0635\u062f", 3342);
    freq.put("\u0648\u064a ", 9400);
    freq.put("\u0627\u064b ", 1671);
    freq.put("\u0686 ", 1702);
    freq.put("\u0639\u0645\u0627", 1036);
    freq.put("\u0633\u0627\u0645", 2387);
    freq.put("\u0633\u0627\u0644", 16867);
    freq.put(" \u0627\u06a9", 4067);
    freq.put("\u0637", 45348);
    freq.put("\u0633\u0627\u0633", 1619);
    freq.put("\u0633\u0627\u0632", 3943);
    freq.put("\u0633\u0627\u0628", 1251);
    freq.put("\u06af\u0631 ", 3440);
    freq.put("\u062e\u0648\u0627", 3065);
    freq.put("\u062e\u0648\u062f", 3802);
    freq.put(" \u0635\u0648", 2043);
    freq.put(" \u0635\u0646", 981);
    freq.put(" \u0635\u0641", 1164);
    freq.put("\u0634\u062a ", 4426);
    freq.put("\u0630\u0634\u062a", 1620);
    freq.put(" \u0627\u0637", 2539);
    freq.put(" \u0627\u0634", 2136);
    freq.put(" \u0627\u0635", 3471);
    freq.put("\u062d\u0631\u0645", 1392);
    freq.put(" \u0627\u0633", 93321);
    freq.put("\u0627", 1111531);
    freq.put(" \u0627\u0631", 5819);
    freq.put(" \u0627\u0639", 2096);
    freq.put(" \u0627\u062e", 1959);
    freq.put(" \u0627\u062f", 2220);
    freq.put(" \u0627\u062c", 1670);
    freq.put(" \u0627\u062d", 1812);
    freq.put(" \u0627\u062a", 1821);
    freq.put(" \u0627\u062b", 1151);
    freq.put(" \u0627\u0628", 2944);
    freq.put(" \u0627\u0646", 13519);
    freq.put("\u062f\u0645\u064a", 947);
    freq.put(" \u0627\u0644", 9180);
    freq.put(" \u0627\u0645", 5995);
    freq.put(" \u0627\u0642", 1653);
    freq.put(" \u0627\u0641", 3495);
    freq.put("\u0648\u0631\u062a", 2597);
    freq.put("\u0634\u0634 ", 1401);
    freq.put(" \u0627\u064a", 60506);
    freq.put(" \u0627\u0648", 12009);
    freq.put("\u064a\u06a9\u0645", 1999);
    freq.put("\u064a\u06a9\u064a", 12431);
    freq.put("\u0633\u0645 ", 1194);
    freq.put("\u062f\u0644 ", 1012);
    freq.put("\u0645\u0644 ", 2783);
    freq.put("\u0645\u0633\u0627", 1677);
    freq.put("\u0627\u0648 ", 4256);
    freq.put("\u0647\u0646\u06af", 2686);
    freq.put("\u0645\u0633\u062a", 1149);
    freq.put("\u0628\u0639 ", 2965);
    freq.put("\u0628\u064a\u0634", 2092);
    freq.put("\u0639\u064a", 7120);
    freq.put("\u0628\u064a\u0631", 1134);
    freq.put("\u0628\u064a\u0633", 5590);
    freq.put("\u0639\u0645", 5201);
    freq.put("\u0639\u0644", 6634);
    freq.put("\u0639\u0647", 5570);
    freq.put("\u0639\u0646", 4842);
    freq.put("\u06f8\u06f3 ", 1400);
    freq.put("\u0627\u062c\u0631", 1089);
    freq.put("\u0639\u0628", 3193);
    freq.put("\u0639\u062a", 3100);
    freq.put("\u0639\u062f", 3656);
    freq.put("\u0632\u064a ", 8767);
    freq.put("\u0631\u062a\u064a", 854);
    freq.put("\u0639\u0627", 7561);
    freq.put("\u0628\u064a\u0645", 902);
    freq.put("\u0628\u064a\u0646", 3092);
    freq.put("\u06f9\u06f9 ", 1855);
    freq.put("\u0639\u0631", 22149);
    freq.put("\u0639\u0636", 1560);
    freq.put("\u0646\u064a ", 21211);
    freq.put("\u0627\u062f ", 13676);
    freq.put("\u0631 ", 213685);
    freq.put("\u062d\u062f\u0648", 1445);
    freq.put("\u062d\u062f\u0647", 1001);
    freq.put("\u0645\u0633\u064a", 1271);
    freq.put("\u06f2\u06f0\u06f0", 3965);
    freq.put("\u0627\u0639 ", 1667);
    freq.put("\u064a\u0627 ", 15452);
    freq.put("\u0647\u0646\u0631", 1330);
    freq.put("\u0648\u0631\u0647", 2981);
    freq.put("\u0647\u0646\u062f", 2551);
    freq.put("\u06f2\u06f1 ", 1215);
    freq.put("\u064a\u0634\u062a", 1412);
    freq.put("\u0645\u062c\u0645", 2201);
    freq.put("\u0644\u0633 ", 1850);
    freq.put("\u0645\u062f\u064a", 1420);
    freq.put("\u062b\u0631 ", 1178);
    freq.put(" \u062e ", 829);
    freq.put("\u0634\u0641 ", 46304);
    freq.put("\u064a\u06a9", 36397);
    freq.put("\u0645\u062f\u0627", 1385);
    freq.put("\u06f1\u06f0 ", 1507);
    freq.put("\u0648\u0627\u0646", 9374);
    freq.put("\u0645\u062f\u0631", 931);
    freq.put("\u064a\u0648 ", 1257);
    freq.put("\u062c ", 5421);
    freq.put("\u0648\u0627\u0642", 6339);
    freq.put("\u062a\u0631\u064a", 7869);
    freq.put("\u064a\u0634\u0647", 906);
    freq.put("\u062a\u0635\u0627", 1521);
    freq.put("\u0641\u0648\u062a", 1061);
    freq.put("\u062f\u0627\u0634", 2836);
    freq.put("\u062f\u0627\u0631", 14265);
    freq.put("\u062a\u0635\u062f", 3250);
    freq.put("\u062f\u0627\u0633", 1080);
    freq.put("\u062f\u0627\u0632", 1707);
    freq.put("\u062f\u064a\u0646", 2614);
    freq.put("\u0686\u0648", 1224);
    freq.put("\u062f\u0627\u062f", 4687);
    freq.put("\u062f\u064a\u0645", 1100);
    freq.put(" \u067e", 40145);
    freq.put("\u062f\u064a\u0648", 1392);
    freq.put("\u0631\u0647 ", 40871);
    freq.put("\u0632\u0634", 2575);
    freq.put(" \u0643", 1185);
    freq.put(" \u0641", 28537);
    freq.put(" \u0646", 61607);
    freq.put("\u0632\u0631", 4516);
    freq.put(" \u0644", 8629);
    freq.put(" \u0645", 155700);
    freq.put(" \u064a", 42307);
    freq.put(" \u0648", 134423);
    freq.put("\u0632\u0627", 26314);
    freq.put("\u0632\u062f", 7554);
    freq.put("\u0632\u0628", 4854);
    freq.put("\u0647\u062f\u0627", 927);
    freq.put(" \u0627\u0653", 62929);
    freq.put(" \u0627", 284499);
    freq.put(" \u062a", 57718);
    freq.put(" \u0628", 152331);
    freq.put(" \u062e", 24724);
    freq.put(" \u062f", 158860);
    freq.put(" \u062c", 29359);
    freq.put(" \u062d", 15097);
    freq.put(" \u0632", 19079);
    freq.put("\u0632\u0645", 7708);
    freq.put("\u0632\u0646", 6220);
    freq.put("\u0632\u0647", 4419);
    freq.put(" \u0636", 1200);
    freq.put(" \u0637", 22340);
    freq.put(" \u0634", 162851);
    freq.put(" \u0635", 10068);
    freq.put(" \u063a", 6362);
    freq.put(" \u0639", 23850);
    freq.put("\u0632\u0648", 2068);
    freq.put("\u0631\u064a\u0632", 1529);
    freq.put("\u0632\u064a", 19577);
    freq.put("\u0631\u064a\u0633", 1451);
    freq.put("\u062f\u064a\u0631", 977);
    freq.put(" \u060c", 7698);
    freq.put("\u062f\u064a\u0627", 931);
    freq.put("\u0646\u06af\u0627", 2016);
    freq.put("\u062f\u0627\u064a", 1703);
    freq.put("\u062f\u0627\u0645", 1683);
    freq.put("\u062f\u0627\u0644", 1294);
    freq.put("\u062f\u0627\u0646", 9861);
    freq.put("\u0627\u062d\u064a", 1808);
    freq.put("\u062e\u062f\u0627", 1090);
    freq.put("\u0627\u062d\u0645", 966);
    freq.put(" \u06f2", 17985);
    freq.put(" \u06f3", 5368);
    freq.put(" \u06f1", 47632);
    freq.put(" \u06f6", 2742);
    freq.put(" \u06f7", 2925);
    freq.put(" \u06f4", 3375);
    freq.put(" \u06f5", 3167);
    freq.put("\u0634\u06a9\u0644", 1326);
    freq.put(" \u06f8", 2786);
    freq.put(" \u06f9", 2591);
    freq.put("\u0641\u0644", 2016);
    freq.put("\u0641\u0647", 2747);
    freq.put("\u0645\u0646\u0637", 1759);
    freq.put("\u0627\u0653\u063a\u0627", 1416);
    freq.put("\u0645\u0646\u062a", 1332);
    freq.put("\u062d\u0632\u0628", 975);
    freq.put(" \u064a\u0648", 1770);
    freq.put("\u0641\u0648", 4734);
    freq.put("\u0632\u06af", 1068);
    freq.put("\u0635\u062a ", 1755);
    freq.put("\u0645\u0646\u0627", 1581);
    freq.put(" \u06a9", 148021);
    freq.put(" \u06af", 30777);
    freq.put("\u0627\u0653\u0628\u0627", 1911);
    freq.put(" \u064a\u0627", 14595);
    freq.put("\u0631\u064a\u0647", 3010);
    freq.put("\u062a\u062c", 1247);
    freq.put(" \u0686", 17369);
    freq.put("\u062a\u062d", 3912);
    freq.put("\u062a\u062e", 2986);
    freq.put("\u062a\u062f", 1435);
    freq.put("\u062a\u0628", 22518);
    freq.put(" \u0698", 5441);
    freq.put("\u062f\u064a\u06a9", 1038);
    freq.put("\u064a\u06a9 ", 14180);
    freq.put("\u064a\u0654", 9436);
    freq.put("\u0638\u0627\u0645", 977);
    freq.put("\u06a9\u0631\u062f", 5509);
    freq.put(" \u062f\u0627", 22315);
    freq.put("\u06a9\u0631\u0627", 939);
    freq.put("\u062f\u0647 ", 55594);
    freq.put("\u06a9\u0645 ", 997);
    freq.put("\u0644\u06af", 942);
    freq.put("\u0644\u06a9", 3276);
    freq.put("\u0644\u064a", 31085);
    freq.put("\u0644\u0648", 11064);
    freq.put("\u0644\u0646", 3401);
    freq.put("\u0644\u0647", 9135);
    freq.put("\u0644\u0644", 2270);
    freq.put("\u0644\u0645", 9307);
    freq.put("\u0644\u0642", 1885);
    freq.put("\u0644\u0641", 2767);
    freq.put("\u0648\u062c\u0648", 2093);
    freq.put("\u06f9\u06f8 ", 1731);
    freq.put("\u0631\u0641\u062a", 3769);
    freq.put("\u0637\u0647", 1305);
    freq.put("\u0637\u0644", 3586);
    freq.put("\u0637\u0642", 2226);
    freq.put("\u0637\u064a", 2187);
    freq.put("\u0637\u0648", 2844);
    freq.put("\u0641\u0631 ", 1868);
    freq.put("\u0648\u0647\u0627", 1116);
    freq.put("\u0631\u0634\u064a", 1128);
    freq.put("\u0637\u0627", 2296);
    freq.put("\u0644\u060c", 834);
    freq.put("\u0637\u0628", 17352);
    freq.put("\u0651", 1083);
    freq.put("\u0637\u0631", 3523);
    freq.put("\u0631\u0634\u062a", 1369);
    freq.put("\u0644\u062f", 3211);
    freq.put("\u0644\u062d", 1516);
    freq.put("\u0644\u062a", 4427);
    freq.put("\u0644\u0628", 3816);
    freq.put("\u0644\u0627", 28241);
    freq.put("\u0627\u0645 ", 15467);
    freq.put("\u0644\u0639", 1660);
    freq.put("\u0644\u0637", 1095);
    freq.put("\u0644\u0632", 963);
    freq.put("\u0644\u0633", 4361);
    freq.put("\u06f4 ", 8000);
    freq.put("\u0644\u0631", 1340);
  }
  
}

