package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class EU extends CLangProfile {
  private static final String name = "eu";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public EU() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 10862913;
    n_words[1] = 12392263;
    n_words[2] = 10572779;

    freq.put("nc\u0327o", 166);
    freq.put("gai", 4004);
    freq.put("kus", 1014);
    freq.put("alo", 1294);
    freq.put("sco", 757);
    freq.put("adm", 643);
    freq.put("MA ", 123);
    freq.put("\u0438\u0447 ", 157);
    freq.put("asc", 404);
    freq.put("reu", 617);
    freq.put("ivi", 458);
    freq.put("gae", 256);
    freq.put("sch", 523);
    freq.put("aua", 391);
    freq.put("auc", 470);
    freq.put("aub", 143);
    freq.put("aue", 1117);
    freq.put("aud", 2046);
    freq.put("aug", 815);
    freq.put("Uha", 317);
    freq.put("mpe", 165);
    freq.put("IX ", 263);
    freq.put("Okz", 8717);
    freq.put("aum", 331);
    freq.put("blo", 238);
    freq.put("up ", 152);
    freq.put("aun", 1227);
    freq.put("e\u0301ri", 214);
    freq.put("aus", 1048);
    freq.put("o\u0302", 3132);
    freq.put("\u4e34", 277);
    freq.put("G ", 191);
    freq.put("tai", 3219);
    freq.put("e\u0301ra", 508);
    freq.put("auz", 2790);
    freq.put("Ez ", 126);
    freq.put("e\u0301re", 128);
    freq.put("ti\u0301n", 140);
    freq.put("amu", 416);
    freq.put(" Gw", 139);
    freq.put(" Gu", 2252);
    freq.put(" Gr", 2249);
    freq.put("\u0644", 670);
    freq.put("sca", 504);
    freq.put("din", 3293);
    freq.put(" Gy", 275);
    freq.put("ble", 654);
    freq.put(" Ge", 4583);
    freq.put("lep", 680);
    freq.put(" Ga", 8127);
    freq.put("\u05d9", 145);
    freq.put(" Go", 2376);
    freq.put(" Gl", 404);
    freq.put("pik", 760);
    freq.put(" Gi", 3327);
    freq.put("Gw", 139);
    freq.put("au ", 3167);
    freq.put("Gu", 2262);
    freq.put("Gr", 2264);
    freq.put("upi", 127);
    freq.put("e\u0308", 206);
    freq.put("aiz", 1199);
    freq.put("Gy", 276);
    freq.put("e\u0301li", 109);
    freq.put("dre\u0301", 154);
    freq.put("Ge", 4595);
    freq.put("red", 748);
    freq.put("Ga", 8150);
    freq.put("Ezk", 195);
    freq.put("Go", 2393);
    freq.put("Gl", 406);
    freq.put("Gi", 3338);
    freq.put("a\u0304", 699);
    freq.put(" ka", 6507);
    freq.put("olk", 977);
    freq.put("me ", 3651);
    freq.put(" ke", 272);
    freq.put(" ki", 4014);
    freq.put(" ko", 25212);
    freq.put(" kl", 781);
    freq.put(" km", 546);
    freq.put(" kr", 1091);
    freq.put("alv", 863);
    freq.put("ais", 1887);
    freq.put(" ku", 1542);
    freq.put("Ign", 110);
    freq.put("a\u0308rv", 206);
    freq.put("Tom", 137);
    freq.put("nen", 5074);
    freq.put("neo", 478);
    freq.put("He\u0301r", 386);
    freq.put("nem", 1122);
    freq.put("nek", 3786);
    freq.put("cti", 251);
    freq.put("nei", 353);
    freq.put(" y ", 323);
    freq.put("Pue", 117);
    freq.put("ned", 379);
    freq.put("nee", 138);
    freq.put("neb", 129);
    freq.put("aio", 2613);
    freq.put("\u062f", 321);
    freq.put("nea", 4726);
    freq.put("orv", 338);
    freq.put("kum", 688);
    freq.put("Lyg", 192);
    freq.put("nez", 3775);
    freq.put("Puy", 565);
    freq.put("Mug", 257);
    freq.put("ney", 289);
    freq.put("nev", 226);
    freq.put("net", 5039);
    freq.put("Vau", 379);
    freq.put("ner", 12607);
    freq.put("nes", 2224);
    freq.put("kua", 34372);
    freq.put("e\u0300z", 354);
    freq.put("dep", 31070);
    freq.put("\u0443", 285);
    freq.put("\u03c2", 638);
    freq.put("mea", 1209);
    freq.put("fiz", 1025);
    freq.put("e\u0300r", 1733);
    freq.put("e\u0300s", 933);
    freq.put("meo", 147);
    freq.put("gne", 942);
    freq.put("e\u0300v", 648);
    freq.put("mek", 454);
    freq.put("ors", 420);
    freq.put("zur", 964);
    freq.put("fun", 655);
    freq.put("kul", 2168);
    freq.put("e\u0300n", 113);
    freq.put("mes", 758);
    freq.put("aid", 440);
    freq.put("e\u0300g", 419);
    freq.put("ee ", 210);
    freq.put("akz", 215);
    freq.put("ulo", 533);
    freq.put("Zo", 305);
    freq.put("Zh", 191);
    freq.put("Zi", 1026);
    freq.put("glo", 370);
    freq.put("Ze", 1350);
    freq.put("k", 463043);
    freq.put("\u30a2\u30a2\u30a2", 219);
    freq.put("aku", 2585);
    freq.put("akt", 1284);
    freq.put("dri", 1545);
    freq.put("aki", 3275);
    freq.put("akh", 163);
    freq.put("ako", 87760);
    freq.put("dro", 1415);
    freq.put(" N ", 227);
    freq.put("dra", 754);
    freq.put("Zu", 1064);
    freq.put("aka", 3860);
    freq.put("aib", 241);
    freq.put("dre", 1584);
    freq.put("auk", 876);
    freq.put("ake", 2522);
    freq.put("ku ", 1173);
    freq.put("Jer", 194);
    freq.put("Jes", 231);
    freq.put("Kom", 296);
    freq.put("Kol", 432);
    freq.put("txi", 4866);
    freq.put("Kon", 1335);
    freq.put("bru", 149);
    freq.put("lmo", 204);
    freq.put("txa", 1807);
    freq.put("Le\u0301", 212);
    freq.put("bro", 342);
    freq.put("orf", 275);
    freq.put("Jea", 485);
    freq.put("bri", 2477);
    freq.put("lma", 675);
    freq.put("Naf", 1923);
    freq.put("Kos", 152);
    freq.put("Kor", 646);
    freq.put("lec", 200);
    freq.put("bra", 732);
    freq.put("Nag", 310);
    freq.put("m ", 4321);
    freq.put("aup", 140);
    freq.put("met", 5777);
    freq.put("rph", 358);
    freq.put("Rho\u0302", 310);
    freq.put("lme", 519);
    freq.put("aur", 6720);
    freq.put("er ", 6409);
    freq.put("det", 1562);
    freq.put("ora", 3882);
    freq.put("ni ", 1052);
    freq.put("aut", 4572);
    freq.put("A\u0301", 135);
    freq.put("Ste", 414);
    freq.put("rla", 3010);
    freq.put("Sta", 507);
    freq.put("Nan", 255);
    freq.put("Sto", 163);
    freq.put("pic", 144);
    freq.put("nyi", 1026);
    freq.put("ris", 4325);
    freq.put("yra", 176);
    freq.put("nue", 380);
    freq.put("rip", 367);
    freq.put("Str", 342);
    freq.put("V", 9991);
    freq.put("mu ", 428);
    freq.put("iv", 1736);
    freq.put("me", 60276);
    freq.put("Nar", 6638);
    freq.put("mg", 110);
    freq.put("ma", 42350);
    freq.put("ltu", 1223);
    freq.put("err", 62362);
    freq.put("mb", 1990);
    freq.put("mm", 1879);
    freq.put("mo", 12040);
    freq.put("mn", 549);
    freq.put("mi", 30640);
    freq.put("Nap", 194);
    freq.put("erz", 150);
    freq.put("mu", 11394);
    freq.put("mt", 139);
    freq.put("erf", 172);
    freq.put("erg", 1467);
    freq.put("lir", 147);
    freq.put("mp", 2538);
    freq.put("ms", 406);
    freq.put("erc", 707);
    freq.put("erl", 1568);
    freq.put("Nav", 137);
    freq.put("ern", 3239);
    freq.put("ero", 11175);
    freq.put("my", 536);
    freq.put("eri", 9060);
    freq.put("erk", 2593);
    freq.put("Aba", 192);
    freq.put("Lif", 129);
    freq.put("Le", 5234);
    freq.put("Abe", 336);
    freq.put("Lib", 309);
    freq.put("La", 7002);
    freq.put("Mul", 124);
    freq.put("Lo", 6499);
    freq.put("Ll", 255);
    freq.put("Lio", 514);
    freq.put("la ", 13924);
    freq.put("uat", 379);
    freq.put("Li", 3143);
    freq.put("Lit", 211);
    freq.put("Naz", 944);
    freq.put("Liv", 131);
    freq.put("Lu", 2001);
    freq.put("ual", 33640);
    freq.put("Lur", 628);
    freq.put("Lis", 187);
    freq.put("uad", 292);
    freq.put("Liz", 228);
    freq.put("Ly", 440);
    freq.put("hog", 384);
    freq.put("hod", 259);
    freq.put("ki ", 14622);
    freq.put("hob", 344);
    freq.put("hoc", 115);
    freq.put("enf", 133);
    freq.put("hoa", 178);
    freq.put("hon", 2777);
    freq.put("eni", 2624);
    freq.put("i\u0304", 353);
    freq.put("hom", 373);
    freq.put("\u03b1\u0301", 203);
    freq.put("Al ", 169);
    freq.put("Kal", 524);
    freq.put("Kas", 158);
    freq.put("Kar", 856);
    freq.put("hot", 751);
    freq.put("Kap", 120);
    freq.put("hor", 3428);
    freq.put("hos", 554);
    freq.put("hop", 188);
    freq.put("m2", 115);
    freq.put("Rha", 154);
    freq.put("Kaz", 123);
    freq.put("enz", 249);
    freq.put("it ", 1135);
    freq.put("Hel", 358);
    freq.put("yal", 138);
    freq.put("A", 49254);
    freq.put("lam", 935);
    freq.put("lan", 12052);
    freq.put("\u0645", 459);
    freq.put("lai", 2536);
    freq.put("L ", 365);
    freq.put("lak", 5012);
    freq.put("lad", 550);
    freq.put("lae", 479);
    freq.put("zed", 168);
    freq.put("lag", 1101);
    freq.put("ost", 3761);
    freq.put("lab", 1670);
    freq.put("dei", 1488);
    freq.put("ozk", 775);
    freq.put("ova", 475);
    freq.put("lax", 140);
    freq.put("II ", 948);
    freq.put("laz", 1246);
    freq.put("ove", 679);
    freq.put("lat", 4673);
    freq.put("lau", 1492);
    freq.put("lav", 391);
    freq.put("ovi", 716);
    freq.put("lap", 544);
    freq.put("iel", 657);
    freq.put("\u03bf\u03c2 ", 290);
    freq.put("las", 2232);
    freq.put("en ", 169009);
    freq.put("Alo", 136);
    freq.put("All", 581);
    freq.put("Alm", 128);
    freq.put("Alj", 125);
    freq.put("ho ", 201);
    freq.put("Ali", 138);
    freq.put("Alf", 227);
    freq.put("Alg", 117);
    freq.put("u\u0304", 427);
    freq.put("Ale", 1684);
    freq.put("me\u0301", 209);
    freq.put("pub", 1994);
    freq.put("Ala", 306);
    freq.put("gra", 2474);
    freq.put("mpr", 155);
    freq.put("Alt", 401);
    freq.put("Alp", 727);
    freq.put("mps", 237);
    freq.put(" V ", 128);
    freq.put(" Hy", 384);
    freq.put("zea", 4408);
    freq.put("okt", 241);
    freq.put("ngu", 2685);
    freq.put("ofe", 486);
    freq.put("lt ", 691);
    freq.put("zek", 4796);
    freq.put("zeh", 1509);
    freq.put("fam", 8183);
    freq.put("zen", 47887);
    freq.put("zeo", 158);
    freq.put(" Hu", 1024);
    freq.put("zer", 3205);
    freq.put("zes", 644);
    freq.put(" Hi", 2583);
    freq.put("anc\u0327", 220);
    freq.put(" Ho", 2274);
    freq.put("zet", 1270);
    freq.put("zeu", 174);
    freq.put("Bav", 137);
    freq.put(" Ha", 6216);
    freq.put("peg", 247);
    freq.put(" He", 6623);
    freq.put("ono", 3870);
    freq.put("ro\u0302", 347);
    freq.put("fis", 784);
    freq.put("Hir", 971);
    freq.put("His", 306);
    freq.put("Hit", 208);
    freq.put("dur", 2122);
    freq.put("fit", 221);
    freq.put("imi", 1266);
    freq.put("cle", 140);
    freq.put("Hiz", 289);
    freq.put("zai", 5026);
    freq.put("imm", 120);
    freq.put("cla", 138);
    freq.put("imo", 875);
    freq.put("ssa", 845);
    freq.put("fic", 126);
    freq.put("fia", 757);
    freq.put("imu", 195);
    freq.put("nja", 149);
    freq.put("Hig", 126);
    freq.put("ri\u0301", 340);
    freq.put("re\u0300", 474);
    freq.put("re\u0301", 955);
    freq.put("fil", 1255);
    freq.put("\u03c1", 505);
    freq.put("ze ", 2487);
    freq.put("ona", 9127);
    freq.put(" Ve", 1772);
    freq.put(" Vi", 3778);
    freq.put("zab", 1288);
    freq.put("zia", 43966);
    freq.put(" Vo", 900);
    freq.put("ong", 1876);
    freq.put("ler", 37899);
    freq.put("teu", 131);
    freq.put("a\u0304n ", 123);
    freq.put(" H ", 110);
    freq.put("im ", 459);
    freq.put("ava", 748);
    freq.put("zib", 216);
    freq.put("okl", 115);
    freq.put("l", 395235);
    freq.put("uka", 1067);
    freq.put("ri\u0301a", 207);
    freq.put("gri", 255);
    freq.put("zaz", 774);
    freq.put("\u064a ", 165);
    freq.put("\u0301", 383);
    freq.put("upe", 490);
    freq.put("kiz", 579);
    freq.put("hyl", 274);
    freq.put("Wor", 153);
    freq.put("oku", 440);
    freq.put(" He\u0301", 453);
    freq.put("tzu", 3457);
    freq.put("tee", 1553);
    freq.put("mbo", 218);
    freq.put("nt ", 6455);
    freq.put("upa", 176);
    freq.put("zat", 4596);
    freq.put("nio", 1723);
    freq.put("rt", 84154);
    freq.put("ru", 29410);
    freq.put("rv", 1353);
    freq.put("rw", 161);
    freq.put("rp", 2429);
    freq.put("rq", 209);
    freq.put("rr", 133906);
    freq.put("rs", 4346);
    freq.put(" ze", 24755);
    freq.put("god", 354);
    freq.put("gog", 353);
    freq.put("rx", 118);
    freq.put("ry", 1952);
    freq.put("rz", 597);
    freq.put("gob", 600);
    freq.put("rd", 16275);
    freq.put("re", 124545);
    freq.put("rf", 596);
    freq.put("rg", 8992);
    freq.put("nic", 527);
    freq.put("ra", 172109);
    freq.put("rb", 5362);
    freq.put("rc", 2417);
    freq.put("rl", 6227);
    freq.put("rm", 7397);
    freq.put("rn", 9800);
    freq.put("ro", 53014);
    freq.put("rh", 504);
    freq.put("ri", 132692);
    freq.put("rj", 253);
    freq.put("rk", 10937);
    freq.put("ntx", 477);
    freq.put("kip", 627);
    freq.put("nif", 230);
    freq.put("nts", 4328);
    freq.put("ntr", 1766);
    freq.put("ntu", 3025);
    freq.put("Egu", 578);
    freq.put("nti", 3678);
    freq.put("nth", 439);
    freq.put("Egi", 536);
    freq.put("mbi", 246);
    freq.put("W", 3928);
    freq.put("nta", 4382);
    freq.put("Qu\u0304", 205);
    freq.put("kit", 2888);
    freq.put("nte", 6419);
    freq.put("deb", 3140);
    freq.put("Vic", 317);
    freq.put("Eus", 2856);
    freq.put("ate", 18483);
    freq.put("Vig", 138);
    freq.put("xur", 507);
    freq.put("Vie", 959);
    freq.put("iss", 773);
    freq.put("ato", 3893);
    freq.put("atl", 299);
    freq.put("atm", 119);
    freq.put("Vin", 200);
    freq.put("i\u0300", 278);
    freq.put("Vil", 1162);
    freq.put("ati", 19404);
    freq.put("Vir", 171);
    freq.put("Vip", 162);
    freq.put("atu", 34742);
    freq.put("r ", 35138);
    freq.put("ats", 845);
    freq.put("Vit", 132);
    freq.put("isl", 341);
    freq.put("isc", 611);
    freq.put("isb", 459);
    freq.put("isa", 1271);
    freq.put("dec", 379);
    freq.put("atz", 18521);
    freq.put("be ", 1452);
    freq.put("atx", 565);
    freq.put("Eur", 2345);
    freq.put("zam", 162);
    freq.put("nha", 305);
    freq.put("Dun", 167);
    freq.put(" l ", 317);
    freq.put("Dub", 337);
    freq.put("on ", 9316);
    freq.put("pir", 1470);
    freq.put("nir", 121);
    freq.put("osa", 5006);
    freq.put("kib", 168);
    freq.put("Dur", 225);
    freq.put("\u041a", 143);
    freq.put("fin", 1035);
    freq.put("toz", 229);
    freq.put("xia", 292);
    freq.put("xie", 194);
    freq.put("tor", 7132);
    freq.put("Cen", 305);
    freq.put("lm ", 353);
    freq.put("Cel", 174);
    freq.put("xil", 657);
    freq.put("xim", 206);
    freq.put("xin", 2912);
    freq.put("tou", 170);
    freq.put("tok", 1652);
    freq.put("zep", 260);
    freq.put("nz ", 115);
    freq.put("nec", 148);
    freq.put("Cer", 368);
    freq.put("tol", 2657);
    freq.put("tom", 728);
    freq.put("tob", 359);
    freq.put("toc", 190);
    freq.put("dik", 2769);
    freq.put("niu", 163);
    freq.put("tog", 246);
    freq.put("tod", 580);
    freq.put("ax ", 148);
    freq.put(" le", 6898);
    freq.put("B", 32314);
    freq.put(" la", 8148);
    freq.put(" lo", 2463);
    freq.put(" li", 3011);
    freq.put("zak", 3577);
    freq.put(" lu", 3558);
    freq.put("Sob", 257);
    freq.put("Fun", 140);
    freq.put("se\u0300r", 390);
    freq.put("wan", 193);
    freq.put("uke", 693);
    freq.put("xi ", 475);
    freq.put("Sev", 217);
    freq.put("okz", 240);
    freq.put("ho\u0302n", 315);
    freq.put("Ser", 500);
    freq.put("ltx", 178);
    freq.put("ktu", 1773);
    freq.put("i\u0301", 1797);
    freq.put("nbi", 1065);
    freq.put("ktr", 750);
    freq.put("Seg", 141);
    freq.put("apt", 114);
    freq.put("deg", 553);
    freq.put("kti", 747);
    freq.put("Sen", 362);
    freq.put("Sem", 121);
    freq.put("Sel", 120);
    freq.put("kta", 288);
    freq.put("Sei", 1420);
    freq.put("raf", 1044);
    freq.put("Iza", 331);
    freq.put("rad", 2088);
    freq.put("epu", 1540);
    freq.put("rab", 9119);
    freq.put("Ize", 360);
    freq.put("yas", 121);
    freq.put("\u4e09", 1377);
    freq.put("rao", 152);
    freq.put("ral", 6492);
    freq.put("ram", 1927);
    freq.put("raj", 132);
    freq.put("rak", 9219);
    freq.put("rah", 192);
    freq.put("rai", 9556);
    freq.put("rav", 257);
    freq.put("rat", 19217);
    freq.put("rau", 2390);
    freq.put("rar", 3528);
    freq.put("ras", 8250);
    freq.put("rap", 758);
    freq.put("ebe", 1499);
    freq.put("lbi", 632);
    freq.put("bs ", 545);
    freq.put("ter", 11656);
    freq.put("lbo", 1200);
    freq.put("hua", 295);
    freq.put("Ass", 118);
    freq.put("tho", 471);
    freq.put("\u30a2", 394);
    freq.put("eud", 448);
    freq.put("\u5927", 136);
    freq.put("Ast", 557);
    freq.put("do ", 13628);
    freq.put("rsk", 111);
    freq.put("rce", 466);
    freq.put("a\u0304n", 289);
    freq.put("piz", 190);
    freq.put("kes", 365);
    freq.put("tev", 241);
    freq.put("ntz", 53194);
    freq.put("Ask", 171);
    freq.put("Sou", 293);
    freq.put("Asi", 444);
    freq.put("Ash", 115);
    freq.put("hun", 759);
    freq.put("ep", 39259);
    freq.put("\u03c0", 199);
    freq.put("Qu", 659);
    freq.put("thi", 275);
    freq.put("ra ", 35431);
    freq.put("urn", 368);
    freq.put("bst", 212);
    freq.put("osg", 604);
    freq.put("nel", 533);
    freq.put(" le\u0300", 553);
    freq.put(" fi", 2901);
    freq.put("ipo", 429);
    freq.put("Qi", 124);
    freq.put("xor", 162);
    freq.put("ogr", 1140);
    freq.put("typ", 482);
    freq.put("iid", 341);
    freq.put("sub", 323);
    freq.put("euf", 120);
    freq.put("doi", 1104);
    freq.put("don", 1432);
    freq.put("dol", 488);
    freq.put("dom", 352);
    freq.put("dob", 254);
    freq.put("aci", 488);
    freq.put("doa", 2009);
    freq.put("m", 170469);
    freq.put("llu", 240);
    freq.put("Ita", 1023);
    freq.put("doz", 381);
    freq.put("ogl", 187);
    freq.put("Itz", 194);
    freq.put("lpi", 131);
    freq.put("sun", 3563);
    freq.put("dor", 3977);
    freq.put("dos", 896);
    freq.put("dop", 318);
    freq.put("Itu", 232);
    freq.put("Its", 696);
    freq.put("dot", 620);
    freq.put("dou", 190);
    freq.put("e\u0301z", 196);
    freq.put("aEu", 198);
    freq.put(" Wa", 873);
    freq.put(" Wo", 331);
    freq.put("e\u0301s", 320);
    freq.put("e\u0301r", 1074);
    freq.put("e\u0301t", 218);
    freq.put("d ", 7993);
    freq.put(" Wi", 1455);
    freq.put("oge", 994);
    freq.put("e\u0301m", 241);
    freq.put("e\u0301l", 236);
    freq.put("e\u0301o", 163);
    freq.put("e\u0301n", 464);
    freq.put("e\u0301a", 185);
    freq.put("e\u0301c", 258);
    freq.put("kup", 125);
    freq.put("e\u0301e", 453);
    freq.put("e\u0301d", 183);
    freq.put("e\u0301g", 228);
    freq.put("oci", 236);
    freq.put("Bio", 163);
    freq.put("Bil", 1194);
    freq.put("hry", 189);
    freq.put("em ", 347);
    freq.put("oco", 220);
    freq.put("oa ", 23154);
    freq.put("oca", 267);
    freq.put("Big", 333);
    freq.put("Bid", 263);
    freq.put("Bie", 141);
    freq.put("Bib", 135);
    freq.put("\u062c", 158);
    freq.put("Bia", 112);
    freq.put("hro", 550);
    freq.put("abs", 119);
    freq.put("Biz", 1309);
    freq.put("ba ", 1649);
    freq.put("ztu", 2068);
    freq.put("kuk", 191);
    freq.put("Bir", 303);
    freq.put("Bis", 146);
    freq.put("sur", 2717);
    freq.put("dn", 167);
    freq.put("\u0440", 831);
    freq.put("dl", 187);
    freq.put("dm", 9929);
    freq.put("\u03c5", 181);
    freq.put("kui", 374);
    freq.put("dh", 268);
    freq.put("di", 46366);
    freq.put(" In\u0303", 129);
    freq.put("dd", 530);
    freq.put("de", 134965);
    freq.put("da", 201401);
    freq.put("xon", 327);
    freq.put("tis", 1599);
    freq.put("dy", 552);
    freq.put("e\u0301 ", 1538);
    freq.put("dt", 177);
    freq.put("du", 58038);
    freq.put("dr", 5710);
    freq.put("ds", 538);
    freq.put("koi", 1642);
    freq.put("eme", 1995);
    freq.put("bat", 43650);
    freq.put("ak ", 35410);
    freq.put("bar", 12363);
    freq.put("bas", 1155);
    freq.put("emb", 233);
    freq.put("Riv", 186);
    freq.put("oc ", 215);
    freq.put("emo", 994);
    freq.put("baz", 996);
    freq.put("Bi ", 209);
    freq.put("kub", 403);
    freq.put("emu", 1285);
    freq.put("Mun", 792);
    freq.put("bad", 1178);
    freq.put("bae", 319);
    freq.put("bab", 550);
    freq.put("bac", 240);
    freq.put("ban", 2718);
    freq.put("bal", 5966);
    freq.put("Rib", 112);
    freq.put("Ric", 281);
    freq.put("uek", 1147);
    freq.put("Ria", 109);
    freq.put("mee", 219);
    freq.put("om ", 243);
    freq.put("\u4e07", 373);
    freq.put("w ", 1243);
    freq.put("Pet", 525);
    freq.put("eel", 320);
    freq.put("nur", 159);
    freq.put("nus", 716);
    freq.put("Per", 814);
    freq.put("ia ", 66121);
    freq.put("Pel", 246);
    freq.put("Pen", 376);
    freq.put("num", 238);
    freq.put("nuk", 355);
    freq.put(" I ", 500);
    freq.put("kok", 4933);
    freq.put("sna", 476);
    freq.put("nua", 755);
    freq.put("mut", 703);
    freq.put("il ", 2896);
    freq.put("mur", 529);
    freq.put("uso", 148);
    freq.put("irr", 1309);
    freq.put("gna", 765);
    freq.put("irt", 277);
    freq.put("iru", 3334);
    freq.put("un ", 5328);
    freq.put("iri", 11303);
    freq.put("mug", 1811);
    freq.put("irk", 440);
    freq.put("irl", 941);
    freq.put("irm", 114);
    freq.put("iro", 2123);
    freq.put("ira", 10391);
    freq.put("mun", 2365);
    freq.put("ird", 162);
    freq.put("ire", 8235);
    freq.put("irg", 171);
    freq.put("omb", 366);
    freq.put("we", 945);
    freq.put("men", 42606);
    freq.put("zah", 516);
    freq.put("wa", 1578);
    freq.put("de\u0301", 379);
    freq.put(" Ip", 1284);
    freq.put("wn", 243);
    freq.put(" Ir", 2841);
    freq.put(" Is", 1292);
    freq.put(" It", 2274);
    freq.put("Sam", 232);
    freq.put(" Iv", 140);
    freq.put("Ohi", 123);
    freq.put("ww", 215);
    freq.put(" Ik", 324);
    freq.put("ws", 184);
    freq.put(" Im", 160);
    freq.put(" In", 4497);
    freq.put("kom", 1476);
    freq.put("ued", 519);
    freq.put(" Ib", 692);
    freq.put("utb", 708);
    freq.put(" Id", 259);
    freq.put("wy", 210);
    freq.put(" Ig", 331);
    freq.put("\u4e09\u4e09", 257);
    freq.put("joe", 132);
    freq.put("ile", 8785);
    freq.put("ilb", 1403);
    freq.put("ell", 3887);
    freq.put("ila", 10425);
    freq.put("oki", 11899);
    freq.put("ilo", 4660);
    freq.put("ill", 6632);
    freq.put("ilm", 637);
    freq.put("ilk", 7089);
    freq.put("ilh", 252);
    freq.put("ili", 12072);
    freq.put("von", 289);
    freq.put("una", 6699);
    freq.put("ilt", 2974);
    freq.put("ilu", 1485);
    freq.put("und", 3967);
    freq.put("ils", 121);
    freq.put("ung", 1494);
    freq.put("ir ", 1292);
    freq.put(" i ", 197);
    freq.put("goz", 493);
    freq.put("unk", 576);
    freq.put("com", 276);
    freq.put("hab", 197);
    freq.put("unn", 124);
    freq.put("con", 497);
    freq.put(" me", 9646);
    freq.put("ela", 7880);
    freq.put(" ma", 8141);
    freq.put("ead", 117);
    freq.put("in\u0303", 300);
    freq.put("had", 140);
    freq.put("io\u0301", 290);
    freq.put(" mo", 3550);
    freq.put(" mi", 3328);
    freq.put("rti", 3170);
    freq.put("io\u0308", 115);
    freq.put("ie\u0301", 152);
    freq.put("ie\u0300", 1602);
    freq.put("Pas", 1075);
    freq.put("ia\u0301", 151);
    freq.put("ia\u0300", 195);
    freq.put("hag", 159);
    freq.put("san", 1883);
    freq.put("fra", 2359);
    freq.put("Bal", 660);
    freq.put("sam", 544);
    freq.put("fre", 282);
    freq.put("rga", 1667);
    freq.put("ggi", 124);
    freq.put("fri", 962);
    freq.put("C ", 551);
    freq.put("fro", 345);
    freq.put("haz", 745);
    freq.put("\u03b9\u0301", 245);
    freq.put("sac", 395);
    freq.put("Gal", 1278);
    freq.put("fru", 141);
    freq.put("sab", 386);
    freq.put("uja", 166);
    freq.put("mez", 354);
    freq.put("ai ", 2679);
    freq.put("ab ", 142);
    freq.put("nie\u0300", 150);
    freq.put("\u0642", 122);
    freq.put(" m ", 200);
    freq.put("gli", 281);
    freq.put("pri", 796);
    freq.put("ran", 42992);
    freq.put("kio\u0308", 114);
    freq.put("kte", 291);
    freq.put("rgh", 113);
    freq.put("Cra", 131);
    freq.put("Cre", 406);
    freq.put("zio", 10069);
    freq.put("Cri", 128);
    freq.put("Cro", 283);
    freq.put("Ci", 545);
    freq.put("Ch", 5833);
    freq.put("Co", 5762);
    freq.put("Cn", 233);
    freq.put("Cl", 878);
    freq.put("ait", 6762);
    freq.put("Ca", 6336);
    freq.put("gny", 701);
    freq.put("aip", 526);
    freq.put("Ce", 1047);
    freq.put("n", 845494);
    freq.put("aim", 225);
    freq.put("ail", 16466);
    freq.put("Cy", 474);
    freq.put("ain", 22745);
    freq.put("sli", 115);
    freq.put("aik", 2668);
    freq.put("akr", 254);
    freq.put("aie", 1989);
    freq.put("Cr", 1202);
    freq.put("aig", 330);
    freq.put("gni", 265);
    freq.put("aia", 7883);
    freq.put("gno", 312);
    freq.put("Cu", 578);
    freq.put("Ct", 233);
    freq.put("iy", 270);
    freq.put("ix", 1809);
    freq.put("iz", 65709);
    freq.put("EB ", 427);
    freq.put("o\u0304 ", 172);
    freq.put("rtu", 8524);
    freq.put("bio", 874);
    freq.put("iq", 528);
    freq.put("ip", 9370);
    freq.put("is", 41795);
    freq.put("ir", 40658);
    freq.put("iu", 1861);
    freq.put("it", 88626);
    freq.put("iw", 111);
    freq.put("Za", 1318);
    freq.put("ii", 901);
    freq.put("ih", 1356);
    freq.put("ik", 65069);
    freq.put("ij", 1221);
    freq.put("im", 14806);
    freq.put("il", 61174);
    freq.put("io", 30374);
    freq.put("in", 101260);
    freq.put("ia", 177930);
    freq.put("ic", 6403);
    freq.put("ib", 22289);
    freq.put("ie", 37824);
    freq.put("id", 28391);
    freq.put("ig", 10103);
    freq.put("if", 3391);
    freq.put("V ", 486);
    freq.put("en\u0303a", 150);
    freq.put("bih", 468);
    freq.put("Aiz", 109);
    freq.put("\u062d", 170);
    freq.put("i\u0304n", 117);
    freq.put("Ika", 163);
    freq.put("sau", 475);
    freq.put("Ait", 206);
    freq.put("Auz", 146);
    freq.put("eaz", 319);
    freq.put("rna", 1877);
    freq.put("th ", 729);
    freq.put("\u0441", 671);
    freq.put("EBe", 213);
    freq.put("bie", 1454);
    freq.put("nin", 1144);
    freq.put("\u03c4", 391);
    freq.put("Nat", 287);
    freq.put("nim", 7615);
    freq.put("kis", 461);
    freq.put("Tre", 367);
    freq.put("o\u0304n", 111);
    freq.put("ima", 8169);
    freq.put("nig", 202);
    freq.put("nid", 1634);
    freq.put("\u044c", 254);
    freq.put("kik", 669);
    freq.put("tz ", 3179);
    freq.put("kio", 719);
    freq.put("kin", 6825);
    freq.put("kim", 840);
    freq.put("kil", 2662);
    freq.put("Y", 2494);
    freq.put("i ", 75419);
    freq.put("kia", 6057);
    freq.put("bia", 2180);
    freq.put("a\u0308r", 266);
    freq.put("kie", 1433);
    freq.put("kid", 1763);
    freq.put("Va", 2746);
    freq.put("\u043a\u043e", 120);
    freq.put("i\u0304 ", 109);
    freq.put("Ve", 1775);
    freq.put("noe", 258);
    freq.put("Vi", 3787);
    freq.put("ept", 728);
    freq.put(" L ", 160);
    freq.put("eps", 204);
    freq.put("Vo", 900);
    freq.put("o\u0302ne", 1395);
    freq.put("epo", 499);
    freq.put("ll ", 864);
    freq.put("eph", 603);
    freq.put("epi", 3559);
    freq.put("abr", 604);
    freq.put("uce", 126);
    freq.put("epe", 753);
    freq.put("in\u0303a", 144);
    freq.put("tha", 655);
    freq.put("Co\u0302", 768);
    freq.put("nk ", 215);
    freq.put("zok", 314);
    freq.put("gzh", 121);
    freq.put("yen", 319);
    freq.put("zol", 134);
    freq.put("rhi", 113);
    freq.put("rn ", 837);
    freq.put("nci", 1712);
    freq.put("mid", 994);
    freq.put("via", 694);
    freq.put("op ", 248);
    freq.put("mig", 137);
    freq.put("Xab", 116);
    freq.put("yer", 179);
    freq.put("bit", 2242);
    freq.put("vig", 216);
    freq.put("hai", 2518);
    freq.put("nog", 132);
    freq.put("hak", 119);
    freq.put("hal", 2041);
    freq.put("Gaz", 575);
    freq.put("han", 4212);
    freq.put("elm", 234);
    freq.put("elb", 764);
    freq.put("Dip", 284);
    freq.put("Gau", 462);
    freq.put("hac", 168);
    freq.put("Gas", 607);
    freq.put("Gar", 4067);
    freq.put("eld", 843);
    freq.put("bis", 1045);
    freq.put("Gan", 238);
    freq.put("Gam", 113);
    freq.put("He\u0301", 453);
    freq.put("Gai", 282);
    freq.put("hap", 332);
    freq.put("els", 360);
    freq.put("har", 11639);
    freq.put("Dis", 216);
    freq.put("hat", 743);
    freq.put("Gab", 184);
    freq.put("elt", 1391);
    freq.put("elu", 1274);
    freq.put("Tri", 446);
    freq.put("opu", 866);
    freq.put("rni", 878);
    freq.put("rno", 850);
    freq.put("D", 12636);
    freq.put("Tro", 782);
    freq.put("ops", 1174);
    freq.put("Tra", 727);
    freq.put("ye ", 281);
    freq.put("hoi", 120);
    freq.put(" E\u0301t", 203);
    freq.put("xka", 395);
    freq.put("rne", 4341);
    freq.put("vad", 796);
    freq.put("ope", 1031);
    freq.put("opa", 1875);
    freq.put("lca", 121);
    freq.put("opl", 283);
    freq.put("ub ", 167);
    freq.put(" E\u0301c", 146);
    freq.put("oph", 2032);
    freq.put("opi", 1772);
    freq.put("rnu", 670);
    freq.put("sma", 633);
    freq.put("a\u0302te", 302);
    freq.put("Arr", 879);
    freq.put("med", 627);
    freq.put("Art", 881);
    freq.put("rke", 2368);
    freq.put("ha ", 447);
    freq.put("el ", 3223);
    freq.put("sk ", 177);
    freq.put("lba", 511);
    freq.put("Ara", 1880);
    freq.put("Arb", 146);
    freq.put("Arc", 161);
    freq.put("Ard", 862);
    freq.put("Are", 343);
    freq.put("Arg", 594);
    freq.put("Ari", 603);
    freq.put("Ark", 223);
    freq.put("uez", 197);
    freq.put("Arm", 450);
    freq.put("Arn", 154);
    freq.put("Aro", 492);
    freq.put("lku", 282);
    freq.put("ola", 6129);
    freq.put("old", 2635);
    freq.put("ole", 2038);
    freq.put("olf", 204);
    freq.put(" Ju", 1944);
    freq.put("ruk", 7712);
    freq.put(" X ", 118);
    freq.put("oll", 736);
    freq.put("olm", 155);
    freq.put("olo", 6056);
    freq.put("olp", 119);
    freq.put(" Jo", 2739);
    freq.put("ols", 202);
    freq.put(" Ji", 326);
    freq.put("olu", 2010);
    freq.put("Kop", 181);
    freq.put(" Je", 1147);
    freq.put("oly", 472);
    freq.put("noc", 367);
    freq.put("toi", 544);
    freq.put(" Ja", 2821);
    freq.put("bre", 1164);
    freq.put("ick", 329);
    freq.put("Lea", 127);
    freq.put("ici", 329);
    freq.put("Hy", 385);
    freq.put("ico", 799);
    freq.put("for", 3048);
    freq.put("Leg", 497);
    freq.put("Leh", 498);
    freq.put("Lei", 412);
    freq.put("arp", 378);
    freq.put("Lek", 123);
    freq.put("yko", 242);
    freq.put("Lem", 125);
    freq.put("Len", 128);
    freq.put("Hu", 1033);
    freq.put("Lep", 592);
    freq.put("zee", 198);
    freq.put("Ler", 221);
    freq.put("Hi", 2597);
    freq.put("Let", 186);
    freq.put("Ho", 2280);
    freq.put("umb", 322);
    freq.put("fol", 298);
    freq.put("icr", 332);
    freq.put("fon", 526);
    freq.put("Ha", 6267);
    freq.put("umi", 217);
    freq.put("\u03bf\u03c2", 294);
    freq.put("icu", 365);
    freq.put("He", 6657);
    freq.put("ol ", 1542);
    freq.put(" Xi", 356);
    freq.put(" Xa", 262);
    freq.put(" Xe", 150);
    freq.put("ple", 493);
    freq.put("pla", 1480);
    freq.put("plo", 475);
    freq.put(" J ", 124);
    freq.put("pli", 1410);
    freq.put("ouv", 335);
    freq.put("Le ", 868);
    freq.put("obo", 225);
    freq.put("obl", 583);
    freq.put("bn ", 137);
    freq.put("obj", 240);
    freq.put("zut", 2275);
    freq.put("obi", 4309);
    freq.put("zuz", 1928);
    freq.put("ic ", 497);
    freq.put("o", 639351);
    freq.put("oba", 971);
    freq.put("zub", 389);
    freq.put("zua", 330);
    freq.put("fo ", 357);
    freq.put("um ", 1084);
    freq.put("zue", 6583);
    freq.put("zuk", 745);
    freq.put("H ", 330);
    freq.put("obu", 191);
    freq.put("obr", 314);
    freq.put("zul", 747);
    freq.put("oss", 573);
    freq.put("soa", 1638);
    freq.put("Fed", 255);
    freq.put("a\u0301ng", 124);
    freq.put("soe", 201);
    freq.put("Cur", 113);
    freq.put("ppe", 293);
    freq.put("sof", 846);
    freq.put("Fen", 110);
    freq.put("mbe", 401);
    freq.put("Fel", 133);
    freq.put("ahi", 1974);
    freq.put("rtx", 1302);
    freq.put("aho", 676);
    freq.put("son", 3257);
    freq.put("sop", 239);
    freq.put("oin", 2360);
    freq.put("sor", 5121);
    freq.put("Fer", 565);
    freq.put("efo", 313);
    freq.put("ahu", 235);
    freq.put("IV ", 188);
    freq.put("lgi", 369);
    freq.put("soz", 627);
    freq.put("opo", 1448);
    freq.put("mbr", 369);
    freq.put("re\u0300z", 299);
    freq.put("tem", 2289);
    freq.put("ne\u0301", 358);
    freq.put("git", 4426);
    freq.put("gis", 854);
    freq.put("gir", 652);
    freq.put("ulm", 122);
    freq.put("gip", 786);
    freq.put("az ", 12242);
    freq.put("na\u0301", 137);
    freq.put("giz", 1772);
    freq.put("nc\u0327", 272);
    freq.put("ign", 1443);
    freq.put("gie", 433);
    freq.put("gid", 465);
    freq.put("awa", 295);
    freq.put("gia", 5348);
    freq.put("oli", 5769);
    freq.put("gio", 349);
    freq.put("gin", 5407);
    freq.put("Din", 121);
    freq.put("gil", 2535);
    freq.put("gik", 1305);
    freq.put("war", 517);
    freq.put("ret", 4609);
    freq.put("so ", 2308);
    freq.put("\u03c3", 279);
    freq.put("\u0442", 523);
    freq.put("a\u0301n ", 329);
    freq.put("zej", 597);
    freq.put("mb ", 125);
    freq.put("aul", 1718);
    freq.put("e\u0301co", 116);
    freq.put("efa", 131);
    freq.put("low", 117);
    freq.put("Z", 5511);
    freq.put("ura", 8810);
    freq.put("azi", 7825);
    freq.put("azk", 3543);
    freq.put("azl", 2452);
    freq.put("azo", 562);
    freq.put("Vol", 182);
    freq.put("aza", 3082);
    freq.put("aze", 1070);
    freq.put("wa ", 219);
    freq.put("llo", 1275);
    freq.put("azz", 159);
    freq.put("xit", 138);
    freq.put("rya", 116);
    freq.put("Vos", 480);
    freq.put("azp", 1356);
    freq.put("olt", 171);
    freq.put("azt", 5546);
    freq.put("azu", 329);
    freq.put("Sis", 185);
    freq.put("Sir", 222);
    freq.put("rif", 356);
    freq.put("uro", 1987);
    freq.put("u\u0308r", 178);
    freq.put("nni", 412);
    freq.put("nka", 819);
    freq.put("uai", 215);
    freq.put(" n ", 330);
    freq.put("nne", 2767);
    freq.put("cop", 272);
    freq.put("vi ", 294);
    freq.put("nna", 510);
    freq.put("uri", 5079);
    freq.put("Sib", 121);
    freq.put(" Li", 3050);
    freq.put("Sie", 134);
    freq.put("kho", 112);
    freq.put("kha", 202);
    freq.put("elo", 1639);
    freq.put("Sin", 296);
    freq.put("Sim", 208);
    freq.put("Sil", 273);
    freq.put("nh", 729);
    freq.put("ni", 56445);
    freq.put("nj", 622);
    freq.put("nk", 3770);
    freq.put("nl", 20585);
    freq.put("nm", 259);
    freq.put("nn", 4720);
    freq.put("no", 18233);
    freq.put("tit", 1526);
    freq.put("na", 89833);
    freq.put("nb", 5719);
    freq.put("nc", 5864);
    freq.put("nd", 77531);
    freq.put("ne", 54150);
    freq.put("nf", 1744);
    freq.put("ng", 20200);
    freq.put("nx", 162);
    freq.put("ny", 2628);
    freq.put("nz", 1004);
    freq.put("\u0627\u0644", 397);
    freq.put("uff", 155);
    freq.put("nki", 526);
    freq.put("np", 6374);
    freq.put("nq", 161);
    freq.put("nr", 517);
    freq.put("\u0441\u043a", 207);
    freq.put("nt", 87610);
    freq.put("nu", 3790);
    freq.put("nv", 608);
    freq.put("nw", 144);
    freq.put(" ni", 298);
    freq.put("\u0441\u0442", 182);
    freq.put("E", 31626);
    freq.put(" no", 1940);
    freq.put(" na", 6665);
    freq.put("urs", 288);
    freq.put(" ne", 1575);
    freq.put("squ", 206);
    freq.put("nn ", 470);
    freq.put("Oze", 547);
    freq.put("rei", 1098);
    freq.put("n\u0303o ", 122);
    freq.put("ve ", 552);
    freq.put("bo ", 895);
    freq.put(" nu", 269);
    freq.put("Ida", 112);
    freq.put("xea", 732);
    freq.put("n ", 374467);
    freq.put("Win", 144);
    freq.put("Wil", 429);
    freq.put("Wik", 612);
    freq.put("plu", 342);
    freq.put("rk ", 865);
    freq.put("ti ", 3145);
    freq.put("ica", 1267);
    freq.put("nku", 162);
    freq.put("roi", 1273);
    freq.put("\u1100\u1161\u1100\u1161", 128);
    freq.put("rok", 9546);
    freq.put("rol", 3561);
    freq.put("rom", 2243);
    freq.put("ae ", 7943);
    freq.put("roo", 173);
    freq.put("lls", 158);
    freq.put("roa", 6616);
    freq.put("rob", 3623);
    freq.put("roc", 757);
    freq.put("rod", 811);
    freq.put("roe", 542);
    freq.put("rof", 646);
    freq.put("rog", 1119);
    freq.put("osi", 954);
    freq.put("roy", 129);
    freq.put("roz", 1007);
    freq.put("osm", 148);
    freq.put("ice", 649);
    freq.put("oso", 2977);
    freq.put("osn", 183);
    freq.put("rop", 4279);
    freq.put("ror", 761);
    freq.put("Leo", 391);
    freq.put("rot", 2296);
    freq.put("rou", 490);
    freq.put("rov", 593);
    freq.put("row", 119);
    freq.put("ume", 1972);
    freq.put("vet", 138);
    freq.put("gu ", 476);
    freq.put("ver", 1032);
    freq.put("ves", 311);
    freq.put("Dal", 132);
    freq.put("Dam", 258);
    freq.put("Dan", 487);
    freq.put("di ", 3931);
    freq.put("zu ", 506);
    freq.put("lwa", 119);
    freq.put("vey", 349);
    freq.put("Dat", 205);
    freq.put("veg", 284);
    freq.put("Dav", 212);
    freq.put("Les", 516);
    freq.put("\u0634", 113);
    freq.put("Dar", 179);
    freq.put("ven", 884);
    freq.put("uma", 1860);
    freq.put("vel", 488);
    freq.put("o\u0301 ", 189);
    freq.put("ofo", 462);
    freq.put("oid", 551);
    freq.put("foa", 306);
    freq.put(" do", 2083);
    freq.put("uiz", 145);
    freq.put("le\u0301 ", 113);
    freq.put("ey ", 1366);
    freq.put("ro ", 5889);
    freq.put("Me\u0301", 297);
    freq.put("erv", 411);
    freq.put("Ukr", 188);
    freq.put("\u043d ", 112);
    freq.put("Cit", 117);
    freq.put("erp", 616);
    freq.put("gla", 304);
    freq.put("umo", 363);
    freq.put("cqu", 221);
    freq.put("dil", 919);
    freq.put("dim", 351);
    freq.put("gua", 626);
    freq.put("dio", 1674);
    freq.put("Tar", 886);
    freq.put("gud", 543);
    freq.put("did", 286);
    freq.put("die", 3603);
    freq.put("gui", 372);
    freq.put("ers", 2709);
    freq.put("gun", 7491);
    freq.put("dib", 563);
    freq.put("gul", 293);
    freq.put("gus", 2569);
    freq.put("p", 125668);
    freq.put("o\u0301n", 676);
    freq.put("diz", 2212);
    freq.put("gut", 1860);
    freq.put("Tal", 334);
    freq.put("auv", 282);
    freq.put("Tan", 225);
    freq.put("ict", 263);
    freq.put("dip", 225);
    freq.put("Tai", 174);
    freq.put("dir", 6847);
    freq.put("Tak", 137);
    freq.put("lou", 253);
    freq.put("klo", 486);
    freq.put("M ", 322);
    freq.put(" Yo", 1348);
    freq.put(" Ya", 232);
    freq.put(" Ye", 164);
    freq.put("kli", 257);
    freq.put("ose\u0301", 257);
    freq.put("lle\u0301", 141);
    freq.put("Gre", 836);
    freq.put("Ren", 337);
    freq.put("Gra", 882);
    freq.put("Gro", 247);
    freq.put("Rea", 142);
    freq.put(" Yu", 192);
    freq.put(" Yv", 208);
    freq.put("Gri", 154);
    freq.put("erd", 4566);
    freq.put("hou", 397);
    freq.put("rul", 119);
    freq.put("tez", 2099);
    freq.put("ere", 16377);
    freq.put("ek ", 6903);
    freq.put("puz", 1734);
    freq.put("rub", 137);
    freq.put("\u0433", 226);
    freq.put("dek", 7786);
    freq.put("Que", 317);
    freq.put("aux", 633);
    freq.put("oer", 727);
    freq.put("Qui", 200);
    freq.put("del", 2329);
    freq.put("Bor", 485);
    freq.put("era", 40409);
    freq.put("Me", 5309);
    freq.put("ngd", 140);
    freq.put("Bos", 337);
    freq.put("Ma", 13695);
    freq.put("erb", 2356);
    freq.put("Agi", 187);
    freq.put("ht ", 301);
    freq.put("Bot", 216);
    freq.put("Mo", 5680);
    freq.put("deo", 330);
    freq.put("Mi", 2877);
    freq.put("Aga", 387);
    freq.put("Bou", 715);
    freq.put("Mu", 2429);
    freq.put("gle", 317);
    freq.put("O", 18871);
    freq.put("lop", 1545);
    freq.put("erm", 1856);
    freq.put("Agu", 144);
    freq.put("oet", 2140);
    freq.put("ydr", 356);
    freq.put("Inf", 149);
    freq.put("or ", 2026);
    freq.put("eko", 32688);
    freq.put("ekn", 504);
    freq.put("boz", 129);
    freq.put("ekl", 121);
    freq.put("ekk", 958);
    freq.put("eki", 8183);
    freq.put("Boi", 402);
    freq.put("tni", 243);
    freq.put("bor", 1560);
    freq.put("bos", 584);
    freq.put("bot", 625);
    freq.put("bou", 296);
    freq.put("eka", 2666);
    freq.put("dee", 1641);
    freq.put("Mos", 1550);
    freq.put("bok", 9893);
    freq.put("bol", 1370);
    freq.put("ekz", 206);
    freq.put("bon", 636);
    freq.put("boa", 985);
    freq.put("eku", 1445);
    freq.put("ekt", 3089);
    freq.put("uve", 444);
    freq.put("boe", 180);
    freq.put("oen", 30360);
    freq.put("jau", 579);
    freq.put("Bon", 360);
    freq.put("Lie", 116);
    freq.put("jar", 1747);
    freq.put("ipi", 478);
    freq.put("e\u0301vi", 152);
    freq.put("ipl", 363);
    freq.put("ngi", 806);
    freq.put("ips", 176);
    freq.put("ipp", 233);
    freq.put("Lig", 406);
    freq.put("jap", 648);
    freq.put("ipt", 634);
    freq.put("ipu", 2084);
    freq.put("uzt", 5216);
    freq.put("Mot", 148);
    freq.put("ugo", 167);
    freq.put("jan", 459);
    freq.put("ayo", 136);
    freq.put(" Ka", 4363);
    freq.put("Min", 480);
    freq.put(" Ke", 748);
    freq.put("aye", 536);
    freq.put(" Kh", 198);
    freq.put(" Ki", 1096);
    freq.put("aya", 303);
    freq.put(" Ko", 3426);
    freq.put(" Kl", 325);
    freq.put(" Kr", 791);
    freq.put("ygo", 225);
    freq.put("Uda", 518);
    freq.put("der", 7825);
    freq.put("ult", 3635);
    freq.put(" Ku", 827);
    freq.put("xik", 2037);
    freq.put("ca ", 1045);
    freq.put("cro", 386);
    freq.put("Lin", 293);
    freq.put("ays", 139);
    freq.put("Mon", 2148);
    freq.put("ood", 215);
    freq.put("Beh", 504);
    freq.put("Bei", 190);
    freq.put("Ben", 412);
    freq.put("ngr", 203);
    freq.put("Bel", 1201);
    freq.put("F", 41733);
    freq.put("zoa", 1994);
    freq.put("ool", 150);
    freq.put("\u064a", 584);
    freq.put("uz ", 3148);
    freq.put("ook", 209);
    freq.put("zta", 21734);
    freq.put("ma ", 5443);
    freq.put("omp", 326);
    freq.put("ylu", 1217);
    freq.put("pia", 822);
    freq.put("mba", 280);
    freq.put("oor", 211);
    freq.put("Ber", 3897);
    freq.put("Bes", 339);
    freq.put("une", 4343);
    freq.put("Bet", 367);
    freq.put("Rom", 283);
    freq.put("ezk", 3961);
    freq.put("ibi", 2091);
    freq.put(" K ", 344);
    freq.put("ibl", 211);
    freq.put("ibo", 10573);
    freq.put("cas", 288);
    freq.put("car", 483);
    freq.put("oiz", 813);
    freq.put("cap", 126);
    freq.put("flu", 128);
    freq.put("ay ", 1280);
    freq.put("cau", 179);
    freq.put("cat", 226);
    freq.put("n\u0303", 2145);
    freq.put("se\u0301", 400);
    freq.put("se\u0300", 421);
    freq.put("can", 540);
    freq.put("cam", 158);
    freq.put("cal", 436);
    freq.put("fla", 235);
    freq.put("ibr", 326);
    freq.put("Mod", 145);
    freq.put("cag", 240);
    freq.put("ibu", 3077);
    freq.put("uco", 199);
    freq.put("cad", 117);
    freq.put(" on", 4235);
    freq.put("ges", 1287);
    freq.put(" ol", 651);
    freq.put(" om", 239);
    freq.put("eag", 605);
    freq.put(" ok", 389);
    freq.put(" oh", 1483);
    freq.put(" oi", 1278);
    freq.put(" of", 1484);
    freq.put("idr", 287);
    freq.put(" od", 151);
    freq.put("uan", 34449);
    freq.put(" ob", 692);
    freq.put("Mig", 214);
    freq.put("spi", 825);
    freq.put(" oz", 163);
    freq.put(" ox", 142);
    freq.put("spo", 227);
    freq.put("spa", 4514);
    freq.put(" ot", 1043);
    freq.put("Mir", 210);
    freq.put(" or", 3982);
    freq.put(" os", 6513);
    freq.put(" op", 380);
    freq.put("\u4e01 ", 173);
    freq.put("ido", 1820);
    freq.put("rvi", 571);
    freq.put("kro", 731);
    freq.put("gh ", 273);
    freq.put("uag", 257);
    freq.put("gez", 400);
    freq.put("mel", 403);
    freq.put("s ", 48513);
    freq.put("eog", 358);
    freq.put("Urd", 163);
    freq.put("mas", 1187);
    freq.put("sne", 1033);
    freq.put("Ura", 118);
    freq.put("ena", 41627);
    freq.put("aon", 151);
    freq.put("Uro", 222);
    freq.put("Uri", 138);
    freq.put("aoi", 123);
    freq.put("Urk", 120);
    freq.put("Urt", 224);
    freq.put("Cte", 231);
    freq.put("nik", 2843);
    freq.put("enc", 765);
    freq.put("mae", 329);
    freq.put("mad", 637);
    freq.put("Urr", 361);
    freq.put("mai", 4561);
    freq.put("end", 44877);
    freq.put("lmi", 305);
    freq.put("mal", 8071);
    freq.put("ene", 16371);
    freq.put("ght", 231);
    freq.put("sz", 245);
    freq.put("sy", 515);
    freq.put("ide", 10967);
    freq.put("xel", 128);
    freq.put("ss", 4629);
    freq.put("sr", 212);
    freq.put("sq", 219);
    freq.put("sp", 8612);
    freq.put("sw", 227);
    freq.put("sv", 152);
    freq.put("su", 14353);
    freq.put("st", 55835);
    freq.put("q", 2827);
    freq.put("sj", 125);
    freq.put("si", 25419);
    freq.put("sh", 2489);
    freq.put("so", 18734);
    freq.put("sn", 1906);
    freq.put("sm", 3054);
    freq.put("sl", 3070);
    freq.put("sc", 2520);
    freq.put("sb", 1326);
    freq.put("sa", 30547);
    freq.put("yli", 146);
    freq.put("sg", 1046);
    freq.put("sf", 603);
    freq.put("se", 20022);
    freq.put("sd", 220);
    freq.put("Ru", 564);
    freq.put("enk", 297);
    freq.put("Che", 1052);
    freq.put("nsi", 830);
    freq.put("Jav", 138);
    freq.put("Chi", 641);
    freq.put("Jat", 166);
    freq.put("Jau", 467);
    freq.put("Jar", 142);
    freq.put("Jap", 555);
    freq.put("\u044f ", 139);
    freq.put("Jan", 172);
    freq.put("Re", 1715);
    freq.put("Chr", 241);
    freq.put("Jam", 243);
    freq.put("Zib", 154);
    freq.put("Ra", 1463);
    freq.put("Jai", 339);
    freq.put("Zin", 153);
    freq.put("\u4e18", 302);
    freq.put("tta", 369);
    freq.put("Ro", 2679);
    freq.put("Rh", 1366);
    freq.put("Ri", 1242);
    freq.put("tte", 927);
    freq.put("nsm", 113);
    freq.put("Rhi", 762);
    freq.put(" ab", 5206);
    freq.put(" ad", 2544);
    freq.put("ull", 366);
    freq.put(" af", 170);
    freq.put(" ag", 1571);
    freq.put(" ah", 1271);
    freq.put(" ai", 1625);
    freq.put(" ak", 945);
    freq.put(" al", 7726);
    freq.put(" am", 1664);
    freq.put(" an", 37224);
    freq.put("gto", 194);
    freq.put("\u03b1", 749);
    freq.put("soi", 556);
    freq.put(" ar", 17725);
    freq.put(" as", 2486);
    freq.put(" at", 1816);
    freq.put("\u0434", 267);
    freq.put("ent", 12453);
    freq.put(" az", 4149);
    freq.put("gel", 2960);
    freq.put("sok", 569);
    freq.put("enu", 163);
    freq.put("nol", 1301);
    freq.put("nom", 2855);
    freq.put("non", 1208);
    freq.put("usa", 632);
    freq.put("noi", 432);
    freq.put("ls ", 415);
    freq.put("nok", 336);
    freq.put("nod", 214);
    freq.put("\u0648", 342);
    freq.put("uge", 534);
    freq.put("Kat", 1063);
    freq.put("sle", 1317);
    freq.put("nob", 252);
    freq.put("sol", 1417);
    freq.put("Sha", 388);
    freq.put("kko", 963);
    freq.put("aer", 1127);
    freq.put("R ", 202);
    freq.put("She", 176);
    freq.put("noz", 134);
    freq.put("eny", 137);
    freq.put("not", 726);
    freq.put("Shi", 203);
    freq.put("nov", 276);
    freq.put("Ele", 228);
    freq.put("nop", 687);
    freq.put("nor", 1438);
    freq.put("shu", 112);
    freq.put(" a ", 8305);
    freq.put("per", 5212);
    freq.put("nil", 338);
    freq.put("eru", 942);
    freq.put("tti", 344);
    freq.put("oya", 225);
    freq.put("Kir", 246);
    freq.put("sot", 612);
    freq.put("em", 15409);
    freq.put("el", 32829);
    freq.put("eo", 5671);
    freq.put("en", 302618);
    freq.put("ei", 12396);
    freq.put("eh", 10866);
    freq.put("ek", 58090);
    freq.put("ej", 999);
    freq.put("ee", 7857);
    freq.put("ed", 20845);
    freq.put("eg", 27624);
    freq.put("ef", 2297);
    freq.put("ea", 90696);
    freq.put("rl ", 161);
    freq.put("ec", 2369);
    freq.put("eb", 7278);
    freq.put("Luc", 199);
    freq.put("ey", 2501);
    freq.put("ex", 2335);
    freq.put("ect", 278);
    freq.put("ez", 30732);
    freq.put("eu", 10850);
    freq.put("et", 97162);
    freq.put("ew", 1215);
    freq.put("ev", 2468);
    freq.put("Re\u0301", 151);
    freq.put("es", 80312);
    freq.put("er", 181118);
    freq.put("Ken", 177);
    freq.put("Jor", 132);
    freq.put("Jos", 894);
    freq.put("nib", 1314);
    freq.put("Dom", 330);
    freq.put("eja", 123);
    freq.put("tto", 194);
    freq.put("Joa", 335);
    freq.put("\u0633", 238);
    freq.put("bli", 2524);
    freq.put("dif", 136);
    freq.put("os ", 3052);
    freq.put("Joh", 504);
    freq.put("eju", 612);
    freq.put("Jok", 251);
    freq.put("bla", 489);
    freq.put("Ker", 134);
    freq.put("Jon", 241);
    freq.put("rlo", 918);
    freq.put("rli", 1036);
    freq.put("tif", 454);
    freq.put("G", 24671);
    freq.put("\u03c6", 112);
    freq.put("rle", 728);
    freq.put("rld", 114);
    freq.put("ort", 9314);
    freq.put("oru", 798);
    freq.put("a\u0300n", 218);
    freq.put("e ", 126190);
    freq.put("orp", 1026);
    freq.put("mio", 152);
    freq.put("orn", 1125);
    freq.put(" \u041a", 143);
    freq.put("orl", 371);
    freq.put("orm", 2863);
    freq.put("ork", 1333);
    freq.put("ori", 6643);
    freq.put("rlu", 114);
    freq.put("org", 1446);
    freq.put("ord", 4422);
    freq.put("ore", 7122);
    freq.put("orb", 627);
    freq.put("orc", 229);
    freq.put("axa", 121);
    freq.put("mos", 401);
    freq.put("osu", 155);
    freq.put("\u0438\u0447", 173);
    freq.put("tse", 2634);
    freq.put("Apo", 201);
    freq.put("cos", 170);
    freq.put("Apa", 132);
    freq.put("nia", 21004);
    freq.put("fe", 4135);
    freq.put("zan", 15520);
    freq.put("xk", 501);
    freq.put("e\u0300s ", 918);
    freq.put("xi", 8569);
    freq.put("onn", 1364);
    freq.put("xo", 2798);
    freq.put("lfo", 360);
    freq.put("aix", 538);
    freq.put("onb", 522);
    freq.put("onc", 465);
    freq.put("zad", 174);
    freq.put("xa", 3213);
    freq.put("onf", 339);
    freq.put("rgu", 720);
    freq.put("ond", 7536);
    freq.put("xe", 3776);
    freq.put("by ", 112);
    freq.put("ony", 150);
    freq.put("fak", 148);
    freq.put("ua ", 13559);
    freq.put("ons", 1225);
    freq.put("onp", 1137);
    freq.put("zau", 482);
    freq.put("onv", 206);
    freq.put("xt", 269);
    freq.put("xu", 1487);
    freq.put("iam", 434);
    freq.put("ial", 8884);
    freq.put("ian", 17793);
    freq.put("iak", 58472);
    freq.put("iad", 428);
    freq.put("\u4e4b\u4e09", 148);
    freq.put("yin", 1034);
    freq.put("ukr", 242);
    freq.put("iac", 288);
    freq.put("iab", 177);
    freq.put("uko", 10845);
    freq.put("ukl", 257);
    freq.put("lar", 14549);
    freq.put("uki", 593);
    freq.put("iaz", 1327);
    freq.put("iau", 120);
    freq.put("iat", 2790);
    freq.put("Do\u0302", 481);
    freq.put("Dou", 638);
    freq.put("iap", 140);
    freq.put("ias", 645);
    freq.put("iar", 18221);
    freq.put("Co\u0302t", 760);
    freq.put(" Zo", 304);
    freq.put("ebo", 188);
    freq.put(" Zi", 1025);
    freq.put(" Zh", 191);
    freq.put(" Ze", 1333);
    freq.put("hum", 243);
    freq.put("x ", 3431);
    freq.put("dic", 166);
    freq.put(" Za", 1318);
    freq.put("lhe", 161);
    freq.put("za ", 8723);
    freq.put("ebi", 808);
    freq.put("hut", 205);
    freq.put("ush", 119);
    freq.put("Die", 165);
    freq.put("hur", 1153);
    freq.put("hus", 732);
    freq.put(" Zu", 1054);
    freq.put("tig", 462);
    freq.put("gim", 660);
    freq.put("rze", 132);
    freq.put("yi ", 127);
    freq.put("rza", 167);
    freq.put("Am", 3102);
    freq.put(" Le\u0301", 212);
    freq.put("\u0646 ", 205);
    freq.put("r", 847892);
    freq.put("nie", 1873);
    freq.put("ehe", 4597);
    freq.put("Ald", 917);
    freq.put("uk ", 736);
    freq.put("and", 13202);
    freq.put("ane", 3569);
    freq.put("anf", 114);
    freq.put("ang", 4075);
    freq.put("pra", 285);
    freq.put("ana", 6367);
    freq.put("anb", 593);
    freq.put("anc", 2276);
    freq.put("anl", 19832);
    freq.put("Alb", 472);
    freq.put("ann", 1154);
    freq.put("ano", 2915);
    freq.put("sag", 755);
    freq.put("ani", 22937);
    freq.put("anj", 269);
    freq.put("ank", 984);
    freq.put("ant", 46628);
    freq.put("anu", 801);
    freq.put("anp", 1062);
    freq.put("ry ", 1109);
    freq.put("ans", 1575);
    freq.put("sas", 2876);
    freq.put("sar", 2841);
    freq.put("Nie\u0300", 290);
    freq.put("any", 212);
    freq.put("anz", 393);
    freq.put("sat", 4584);
    freq.put("Do", 3494);
    freq.put("Phi", 231);
    freq.put("rmi", 806);
    freq.put("zoe", 174);
    freq.put("Di", 1558);
    freq.put("zoi", 237);
    freq.put("De", 2359);
    freq.put("lti", 598);
    freq.put("zon", 1162);
    freq.put("Da", 1856);
    freq.put("Phy", 140);
    freq.put("2", 121);
    freq.put("\u0435", 865);
    freq.put("elf", 319);
    freq.put("Phr", 148);
    freq.put("Du", 1120);
    freq.put("Dr", 849);
    freq.put("ts ", 1033);
    freq.put("an ", 170348);
    freq.put("Se\u0300v", 275);
    freq.put("ust", 3020);
    freq.put("Fri", 275);
    freq.put("sa ", 3578);
    freq.put("uya", 140);
    freq.put("uck", 125);
    freq.put("ery", 187);
    freq.put("\u4e59", 208);
    freq.put("sga", 355);
    freq.put("zo ", 1317);
    freq.put(" Le", 5208);
    freq.put(" La", 6984);
    freq.put("axu", 131);
    freq.put(" Lo", 6484);
    freq.put(" Ll", 255);
    freq.put("rpu", 497);
    freq.put("D ", 286);
    freq.put("\u062f ", 145);
    freq.put("\u0627\u0646", 117);
    freq.put(" Lu", 1998);
    freq.put("o\u0300", 128);
    freq.put("tze", 31257);
    freq.put("neu", 1060);
    freq.put("axi", 278);
    freq.put("axo", 276);
    freq.put(" Ly", 440);
    freq.put("\u1100\u1161", 192);
    freq.put("rka", 2965);
    freq.put("fes", 515);
    freq.put("urt", 8830);
    freq.put("Wes", 294);
    freq.put("Fla", 260);
    freq.put("ge ", 1979);
    freq.put("nle", 19805);
    freq.put("des", 2086);
    freq.put("xis", 324);
    freq.put("lay", 294);
    freq.put("dy ", 206);
    freq.put("ss ", 363);
    freq.put("lig", 725);
    freq.put("zeg", 625);
    freq.put("Lim", 186);
    freq.put("Cyr", 266);
    freq.put("We", 721);
    freq.put("ith", 384);
    freq.put("Wa", 880);
    freq.put("lua", 1210);
    freq.put("Wo", 340);
    freq.put("iti", 6015);
    freq.put("lub", 1731);
    freq.put("Wi", 1463);
    freq.put("Wh", 118);
    freq.put("sou", 390);
    freq.put("\u0430", 1315);
    freq.put("air", 1724);
    freq.put("\u03b5", 392);
    freq.put("osk", 831);
    freq.put("\u0447 ", 164);
    freq.put("pti", 290);
    freq.put("tic", 667);
    freq.put("uvr", 124);
    freq.put(" ps", 237);
    freq.put(" pr", 7926);
    freq.put("zei", 931);
    freq.put("ssy", 167);
    freq.put(" pu", 1255);
    freq.put("get", 173);
    freq.put("ssu", 264);
    freq.put("H", 20234);
    freq.put("\u043d\u043e", 113);
    freq.put("oce", 551);
    freq.put("dyl", 181);
    freq.put(" pa", 3424);
    freq.put("geg", 119);
    freq.put("zel", 1984);
    freq.put(" pe", 3345);
    freq.put("ja\u0308", 211);
    freq.put(" pi", 2498);
    freq.put("geh", 1437);
    freq.put(" po", 4955);
    freq.put("gen", 9845);
    freq.put(" pl", 1311);
    freq.put("to ", 2344);
    freq.put("uvi", 405);
    freq.put("cid", 1189);
    freq.put("E\u0301t", 205);
    freq.put("Tim", 132);
    freq.put("lum", 401);
    freq.put("iqu", 500);
    freq.put("o\u0301", 1337);
    freq.put("lun", 936);
    freq.put("diu", 152);
    freq.put("E\u0301c", 146);
    freq.put("ia\u0300n", 147);
    freq.put("mmo", 170);
    freq.put("uti", 2642);
    freq.put("ffi", 176);
    freq.put("rmu", 500);
    freq.put(" \u0627\u0644", 346);
    freq.put("cin", 1476);
    freq.put("zez", 804);
    freq.put("rma", 3800);
    freq.put("alg", 595);
    freq.put("rme", 1506);
    freq.put("tu ", 19929);
    freq.put("kek", 347);
    freq.put("cil", 203);
    freq.put("j ", 153);
    freq.put("ffe", 167);
    freq.put("cis", 344);
    freq.put("nis", 11960);
    freq.put("uts", 624);
    freq.put("tna", 149);
    freq.put("xa ", 433);
    freq.put("uxe", 167);
    freq.put("yla", 109);
    freq.put("pte", 196);
    freq.put("kau", 137);
    freq.put("Hip", 128);
    freq.put("tuz", 3752);
    freq.put("tus", 1524);
    freq.put("utt", 153);
    freq.put("\u0647", 130);
    freq.put("lie\u0300", 124);
    freq.put("ju", 1296);
    freq.put("tur", 8124);
    freq.put("gi ", 1669);
    freq.put("tut", 13606);
    freq.put("uth", 327);
    freq.put("utz", 2136);
    freq.put("ue ", 1044);
    freq.put("jo", 3182);
    freq.put("tul", 337);
    freq.put("ji", 1295);
    freq.put("kat", 17259);
    freq.put("xe ", 943);
    freq.put("je", 1468);
    freq.put("tub", 959);
    freq.put("tud", 397);
    freq.put("ja", 9289);
    freq.put("Kre", 127);
    freq.put(" be", 18081);
    freq.put("ros", 1392);
    freq.put("z", 349493);
    freq.put(" ba", 61785);
    freq.put("unt", 5181);
    freq.put(" bl", 186);
    freq.put(" bo", 1808);
    freq.put(" bi", 31183);
    freq.put("P ", 389);
    freq.put(" bu", 3139);
    freq.put("\u03b1 ", 219);
    freq.put("s", 298290);
    freq.put("Kri", 277);
    freq.put("rki", 3202);
    freq.put("zho", 218);
    freq.put("odr", 254);
    freq.put(" br", 903);
    freq.put("Pe\u0301r", 118);
    freq.put("wer", 265);
    freq.put("niv", 129);
    freq.put("Kro", 231);
    freq.put("nno", 193);
    freq.put("uci", 117);
    freq.put("moa", 1809);
    freq.put("yon", 185);
    freq.put("sul", 894);
    freq.put("yn ", 138);
    freq.put("pot", 370);
    freq.put("por", 1550);
    freq.put("pos", 1322);
    freq.put("pop", 436);
    freq.put("pon", 1624);
    freq.put("pol", 3723);
    freq.put("pok", 216);
    freq.put("tua", 12060);
    freq.put("nsk", 396);
    freq.put("pod", 317);
    freq.put("poe", 553);
    freq.put("tib", 10581);
    freq.put("poa", 264);
    freq.put("sso", 606);
    freq.put("ket", 6095);
    freq.put("Bur", 532);
    freq.put("Bus", 154);
    freq.put("dis", 1910);
    freq.put(" Me\u0301", 297);
    freq.put("tue", 26377);
    freq.put("zpi", 1584);
    freq.put("ei ", 1830);
    freq.put("\u0632", 110);
    freq.put("Bul", 138);
    freq.put("nit", 1609);
    freq.put("bil", 6749);
    freq.put("tug", 593);
    freq.put("zpe", 474);
    freq.put("Bud", 110);
    freq.put("Bue", 186);
    freq.put("mog", 116);
    freq.put("tzo", 1861);
    freq.put("idu", 909);
    freq.put("E\u0301", 768);
    freq.put("fie", 126);
    freq.put("lle", 6822);
    freq.put("odu", 1464);
    freq.put("fik", 2128);
    freq.put("po ", 711);
    freq.put("eis", 293);
    freq.put("eir", 418);
    freq.put("ett", 760);
    freq.put("In\u0303", 132);
    freq.put("Hil", 265);
    freq.put("eiz", 933);
    freq.put("tzi", 45858);
    freq.put("eia", 366);
    freq.put("eok", 178);
    freq.put("eic", 110);
    freq.put("eie", 157);
    freq.put("eid", 253);
    freq.put("eig", 270);
    freq.put("eik", 189);
    freq.put("eij", 125);
    freq.put("eim", 319);
    freq.put("eil", 722);
    freq.put("eio", 204);
    freq.put("ein", 3804);
    freq.put(" Va", 2741);
    freq.put("uia", 127);
    freq.put("iva", 357);
    freq.put("tio", 1317);
    freq.put("seg", 464);
    freq.put("ivo", 164);
    freq.put("Bat", 3332);
    freq.put("oi ", 1867);
    freq.put("zis", 301);
    freq.put("okr", 376);
    freq.put("gee", 110);
    freq.put("Bar", 2121);
    freq.put("suk", 305);
    freq.put("Bas", 1042);
    freq.put("pap", 195);
    freq.put(" Me", 5297);
    freq.put("par", 37920);
    freq.put("pas", 522);
    freq.put("pat", 1309);
    freq.put(" Ma", 13659);
    freq.put("orr", 8683);
    freq.put("paz", 432);
    freq.put(" Mo", 5669);
    freq.put(" Mi", 2855);
    freq.put("ory", 148);
    freq.put("\u0431", 218);
    freq.put(" Mu", 2390);
    freq.put("pac", 116);
    freq.put("pad", 210);
    freq.put("\u03b4", 171);
    freq.put("pag", 296);
    freq.put("I ", 1890);
    freq.put("web", 234);
    freq.put("pak", 754);
    freq.put("pal", 618);
    freq.put("pan", 730);
    freq.put("nab", 663);
    freq.put("oil", 486);
    freq.put("oik", 468);
    freq.put("nac", 646);
    freq.put("I", 17795);
    freq.put("Baz", 195);
    freq.put("Etx", 413);
    freq.put("ete", 2569);
    freq.put("oia", 1590);
    freq.put("yd", 772);
    freq.put("Mar", 6226);
    freq.put("\u0432\u0438\u0447", 155);
    freq.put("ux ", 1723);
    freq.put("oix", 147);
    freq.put("Mau", 432);
    freq.put("oit", 1745);
    freq.put("ois", 1228);
    freq.put("oir", 3115);
    freq.put("nag", 2948);
    freq.put("lib", 1181);
    freq.put("ds ", 300);
    freq.put("Iz", 862);
    freq.put(" M ", 119);
    freq.put("tiz", 562);
    freq.put("zbe", 719);
    freq.put("Ip", 1284);
    freq.put("Is", 1295);
    freq.put("Ir", 2852);
    freq.put("It", 2278);
    freq.put("Iv", 141);
    freq.put("pa ", 796);
    freq.put("Ik", 340);
    freq.put("Im", 160);
    freq.put("Il", 578);
    freq.put("In", 4524);
    freq.put("oke", 354);
    freq.put("uba", 1426);
    freq.put("Ib", 698);
    freq.put("Id", 259);
    freq.put("Ig", 331);
    freq.put("cer", 590);
    freq.put("nai", 1342);
    freq.put(" qu", 182);
    freq.put("a\u0301i", 148);
    freq.put("am ", 849);
    freq.put("ps ", 1451);
    freq.put("vid", 247);
    freq.put("a\u0301l", 138);
    freq.put("a\u0301n", 687);
    freq.put("rac", 1198);
    freq.put("a\u0301r", 132);
    freq.put("tir", 1298);
    freq.put("mpo", 233);
    freq.put("uid", 216);
    freq.put("rgo", 1529);
    freq.put("nam", 614);
    freq.put("Ern", 111);
    freq.put("tso", 2535);
    freq.put("til", 1069);
    freq.put("wyn", 124);
    freq.put("lke", 746);
    freq.put("tim", 1547);
    freq.put("lts", 230);
    freq.put("Hes", 115);
    freq.put("tin", 3308);
    freq.put("mys", 135);
    freq.put("Eri", 170);
    freq.put("Aki", 200);
    freq.put("oda", 1173);
    freq.put("gre", 2219);
    freq.put("oko", 14411);
    freq.put("xua", 342);
    freq.put("Bai", 588);
    freq.put("oel", 238);
    freq.put("fa ", 176);
    freq.put("ami", 9813);
    freq.put("a\u0301 ", 169);
    freq.put("psi", 410);
    freq.put("amm", 343);
    freq.put("pso", 126);
    freq.put("amo", 901);
    freq.put("amn", 123);
    freq.put("\u03c9", 158);
    freq.put("mor", 1418);
    freq.put("amb", 651);
    freq.put("ame", 32856);
    freq.put("Dro\u0302", 329);
    freq.put("mou", 184);
    freq.put("mot", 1295);
    freq.put("mok", 406);
    freq.put("naz", 1755);
    freq.put("moi", 170);
    freq.put("ubl", 2352);
    freq.put("Hez", 131);
    freq.put("Mah", 123);
    freq.put("amp", 1235);
    freq.put("ams", 133);
    freq.put("Gir", 724);
    freq.put("Mak", 109);
    freq.put("moe", 126);
    freq.put("mod", 1434);
    freq.put("zle", 2768);
    freq.put("rpa", 194);
    freq.put("NA ", 1300);
    freq.put("ns", 6135);
    freq.put("Pil", 160);
    freq.put("Pin", 245);
    freq.put("Pia", 119);
    freq.put("Pic", 114);
    freq.put("Pie", 535);
    freq.put("uet", 3427);
    freq.put("tia", 4907);
    freq.put("uei", 226);
    freq.put("Heg", 983);
    freq.put("t", 693891);
    freq.put("Pir", 1128);
    freq.put("Man", 1508);
    freq.put("on\u0303", 152);
    freq.put("\u0641", 132);
    freq.put("uca", 203);
    freq.put("enb", 2943);
    freq.put("ezt", 764);
    freq.put("ezu", 483);
    freq.put("ylv", 131);
    freq.put("ezp", 276);
    freq.put("Kur", 185);
    freq.put("ezl", 261);
    freq.put("cs", 124);
    freq.put("ptu", 244);
    freq.put("Kul", 139);
    freq.put("ezi", 5130);
    freq.put("Hem", 285);
    freq.put("Gip", 1442);
    freq.put("New", 858);
    freq.put("Neu", 356);
    freq.put("Ner", 122);
    freq.put("Hen", 358);
    freq.put("ezb", 637);
    freq.put("Med", 480);
    freq.put(" ch", 186);
    freq.put("ac ", 1453);
    freq.put("usc", 130);
    freq.put("\u30a2\u30a2", 304);
    freq.put("unc", 158);
    freq.put("Mel", 250);
    freq.put(" ca", 373);
    freq.put("mph", 670);
    freq.put("Hol", 339);
    freq.put("o ", 239621);
    freq.put("Meu", 1170);
    freq.put("Met", 319);
    freq.put("ddo", 115);
    freq.put(" \u0301", 110);
    freq.put("Mes", 401);
    freq.put("Mer", 455);
    freq.put(" cr", 121);
    freq.put("uch", 496);
    freq.put("Mex", 492);
    freq.put("ty ", 368);
    freq.put("one", 4593);
    freq.put("\u0447", 225);
    freq.put("Ger", 1702);
    freq.put("mpi", 239);
    freq.put("zit", 32762);
    freq.put("dwa", 144);
    freq.put("Dra", 223);
    freq.put("oro", 1987);
    freq.put("ez ", 12298);
    freq.put("oo", 1321);
    freq.put("on", 56967);
    freq.put("om", 15442);
    freq.put("ol", 29688);
    freq.put("ok", 34406);
    freq.put("oj", 392);
    freq.put("oi", 15827);
    freq.put("oh", 2732);
    freq.put("og", 7848);
    freq.put("of", 3518);
    freq.put("oe", 35138);
    freq.put("od", 6707);
    freq.put("oc", 3225);
    freq.put("ob", 8716);
    freq.put("oa", 47947);
    freq.put("acr", 160);
    freq.put("acq", 143);
    freq.put("oz", 6401);
    freq.put("oy", 1012);
    freq.put("ox", 827);
    freq.put("ow", 1113);
    freq.put("ov", 2405);
    freq.put("ou", 8969);
    freq.put("ot", 18274);
    freq.put("os", 23317);
    freq.put("or", 55477);
    freq.put("oq", 186);
    freq.put("op", 11236);
    freq.put("Ni", 1359);
    freq.put("bje", 319);
    freq.put("ys ", 403);
    freq.put("naf", 779);
    freq.put("No", 2161);
    freq.put("uil", 962);
    freq.put("Na", 11411);
    freq.put("alp", 282);
    freq.put("ai\u0301", 122);
    freq.put("Ne", 2222);
    freq.put("ngh", 311);
    freq.put("an\u0303", 358);
    freq.put("tza", 20297);
    freq.put("ao\u0302", 1078);
    freq.put("Ada", 158);
    freq.put("\u0629 ", 203);
    freq.put("Adm", 9191);
    freq.put("Nu", 354);
    freq.put("Adi", 259);
    freq.put("het", 258);
    freq.put("loc", 168);
    freq.put("hev", 153);
    freq.put("\u043e\u0432\u0438", 110);
    freq.put("log", 3913);
    freq.put("her", 9041);
    freq.put("Jus", 123);
    freq.put("loj", 116);
    freq.put("sak", 1159);
    freq.put("loi", 515);
    freq.put("lon", 2710);
    freq.put("hez", 537);
    freq.put("lom", 2677);
    freq.put("hed", 603);
    freq.put("los", 1717);
    freq.put("\u03b3", 157);
    freq.put("\u0432", 628);
    freq.put("lov", 277);
    freq.put("T ", 234);
    freq.put("heb", 248);
    freq.put("hec", 165);
    freq.put("hel", 1598);
    freq.put("hem", 423);
    freq.put("hen", 3743);
    freq.put("heo", 124);
    freq.put("hei", 419);
    freq.put("hek", 291);
    freq.put("jua", 336);
    freq.put("uin", 1030);
    freq.put("sid", 627);
    freq.put("jud", 181);
    freq.put("\u0646", 404);
    freq.put("N ", 436);
    freq.put("tsa", 4489);
    freq.put("J", 9363);
    freq.put("Giz", 302);
    freq.put("na ", 51123);
    freq.put("nke", 316);
    freq.put("jur", 356);
    freq.put("zpa", 171);
    freq.put("wal", 111);
    freq.put("vy ", 146);
    freq.put("Eno", 127);
    freq.put("lo ", 1720);
    freq.put("agi", 3410);
    freq.put("mat", 5384);
    freq.put("agh", 132);
    freq.put(" sh", 276);
    freq.put("as ", 4585);
    freq.put("he ", 3675);
    freq.put("Avi", 122);
    freq.put("Ave", 440);
    freq.put("Gel", 126);
    freq.put("age", 1716);
    freq.put("\u4e01", 715);
    freq.put("ac", 7614);
    freq.put("ab", 24555);
    freq.put("ae", 11540);
    freq.put("ad", 15049);
    freq.put("ag", 67873);
    freq.put("af", 5163);
    freq.put("ai", 71296);
    freq.put("ah", 5467);
    freq.put("ak", 137603);
    freq.put("aj", 772);
    freq.put("am", 53259);
    freq.put("al", 150790);
    freq.put("ao", 1106);
    freq.put("an", 300148);
    freq.put("aq", 229);
    freq.put("ap", 9383);
    freq.put("as", 38078);
    freq.put("ar", 234987);
    freq.put("au", 28656);
    freq.put("at", 138353);
    freq.put("aw", 605);
    freq.put("av", 3400);
    freq.put("ay", 2915);
    freq.put("ax", 1187);
    freq.put("xu ", 295);
    freq.put("az", 38405);
    freq.put("Esk", 1235);
    freq.put("uis", 870);
    freq.put("Lam", 255);
    freq.put("Lan", 1366);
    freq.put("aB", 147);
    freq.put("aE", 312);
    freq.put("igr", 300);
    freq.put("Lak", 109);
    freq.put("uzo", 1817);
    freq.put("thu", 295);
    freq.put("Lag", 212);
    freq.put("Lab", 307);
    freq.put("Lac", 384);
    freq.put("\u0631", 498);
    freq.put("ige", 670);
    freq.put("iga", 3099);
    freq.put("ota", 4700);
    freq.put("Lat", 204);
    freq.put("Au", 3356);
    freq.put("Lav", 171);
    freq.put("igl", 239);
    freq.put("Lap", 493);
    freq.put("Lar", 562);
    freq.put("Las", 259);
    freq.put("n\u0303a ", 328);
    freq.put("a ", 418310);
    freq.put("ham", 2422);
    freq.put("sto", 3482);
    freq.put("gol", 1108);
    freq.put("a\u0300n ", 157);
    freq.put(" zo", 627);
    freq.put("ote", 1876);
    freq.put("gon", 1318);
    freq.put("uga", 3668);
    freq.put(" zi", 26100);
    freq.put("Hor", 488);
    freq.put("sio", 1888);
    freq.put("zuh", 271);
    freq.put("oaf", 179);
    freq.put("Az", 821);
    freq.put("at ", 33651);
    freq.put("Txi", 1766);
    freq.put("Bru", 377);
    freq.put("La ", 1524);
    freq.put("Txa", 393);
    freq.put("Bro", 433);
    freq.put("goe", 28566);
    freq.put("u", 464998);
    freq.put("Bri", 733);
    freq.put("ig ", 225);
    freq.put("uit", 797);
    freq.put("e\u0301e ", 379);
    freq.put("Bre", 742);
    freq.put("Bra", 786);
    freq.put("ja\u0308r", 205);
    freq.put("pto", 1097);
    freq.put("Fis", 168);
    freq.put("all", 1873);
    freq.put("alm", 822);
    freq.put("Van", 188);
    freq.put("alk", 1496);
    freq.put("Val", 1311);
    freq.put("ali", 14200);
    freq.put("alf", 261);
    freq.put(" za", 4120);
    freq.put("ald", 57921);
    freq.put("ale", 42820);
    freq.put("alb", 844);
    freq.put("alc", 178);
    freq.put("ala", 12819);
    freq.put("gt", 292);
    freq.put("mbl", 156);
    freq.put("Var", 518);
    freq.put("ze\u0300", 218);
    freq.put("alt", 3287);
    freq.put("alu", 1501);
    freq.put("Fin", 531);
    freq.put("als", 169);
    freq.put("Fil", 503);
    freq.put("gr", 5318);
    freq.put("hy ", 139);
    freq.put("smo", 1970);
    freq.put("ree", 1399);
    freq.put("ots", 1405);
    freq.put("tz", 106075);
    freq.put("edd", 167);
    freq.put("tx", 11953);
    freq.put("ty", 2264);
    freq.put("tw", 311);
    freq.put("tt", 2560);
    freq.put("tu", 90564);
    freq.put("tr", 26770);
    freq.put("ts", 16546);
    freq.put("tp", 196);
    freq.put("osl", 159);
    freq.put("tn", 499);
    freq.put("to", 23073);
    freq.put("tl", 1525);
    freq.put("tm", 498);
    freq.put("th", 5295);
    freq.put("ti", 60433);
    freq.put("tf", 199);
    freq.put("\u0438", 1033);
    freq.put("set", 590);
    freq.put("te", 85168);
    freq.put("tb", 891);
    freq.put("tc", 244);
    freq.put("ta", 203261);
    freq.put("yda", 109);
    freq.put("edi", 3117);
    freq.put("ium", 623);
    freq.put("smi", 193);
    freq.put("mpa", 321);
    freq.put("far", 2984);
    freq.put("fas", 196);
    freq.put("mpl", 143);
    freq.put("ajo", 184);
    freq.put("al ", 8930);
    freq.put("gz", 158);
    freq.put(" zu", 10484);
    freq.put("nko", 1451);
    freq.put("utr", 268);
    freq.put("fan", 210);
    freq.put("gy", 318);
    freq.put("fal", 486);
    freq.put("aja", 231);
    freq.put("fab", 275);
    freq.put("ngs", 265);
    freq.put("ius", 683);
    freq.put("iur", 210);
    freq.put("uze", 3853);
    freq.put("sme", 185);
    freq.put("mbu", 137);
    freq.put("ert", 11444);
    freq.put(" Ni", 1355);
    freq.put("gg", 388);
    freq.put("pre", 2596);
    freq.put("is ", 8540);
    freq.put("hyd", 145);
    freq.put(" No", 2154);
    freq.put("osh", 196);
    freq.put(" Na", 11386);
    freq.put(" Ne", 2204);
    freq.put("ge", 26042);
    freq.put("aje", 125);
    freq.put("oho", 168);
    freq.put("ngo", 4685);
    freq.put("gd", 272);
    freq.put("gos", 518);
    freq.put("ogn", 260);
    freq.put("heg", 3098);
    freq.put("gor", 3038);
    freq.put(" Nu", 351);
    freq.put("rbu", 270);
    freq.put("t ", 54109);
    freq.put("gb", 147);
    freq.put("teh", 241);
    freq.put("pul", 574);
    freq.put("tek", 9552);
    freq.put("tel", 3847);
    freq.put("ga", 31469);
    freq.put("ten", 15717);
    freq.put("teo", 777);
    freq.put("tea", 12289);
    freq.put("teb", 185);
    freq.put("edu", 758);
    freq.put("ted", 602);
    freq.put("pun", 714);
    freq.put("nbu", 575);
    freq.put("teg", 2380);
    freq.put("go", 71226);
    freq.put("\u4e09\u4e4b", 120);
    freq.put("asp", 509);
    freq.put("nbo", 866);
    freq.put("Cha\u0302", 343);
    freq.put("Gin", 141);
    freq.put("rre\u0300", 303);
    freq.put("nba", 2467);
    freq.put("tes", 1845);
    freq.put("tet", 1953);
    freq.put("gm", 257);
    freq.put("nbe", 572);
    freq.put("sug", 112);
    freq.put("aba", 5416);
    freq.put("sue", 1113);
    freq.put("gl", 1391);
    freq.put("abd", 115);
    freq.put("abe", 8846);
    freq.put("sua", 1580);
    freq.put("abi", 6317);
    freq.put("sum", 1240);
    freq.put("ast", 11887);
    freq.put("abl", 275);
    freq.put("sui", 142);
    freq.put("abo", 739);
    freq.put("mmu", 161);
    freq.put("\u0430 ", 256);
    freq.put("ti\u0301", 194);
    freq.put("sus", 779);
    freq.put("abu", 1781);
    freq.put("kop", 563);
    freq.put("te\u0301", 228);
    freq.put("zig", 450);
    freq.put("ff ", 133);
    freq.put("osf", 232);
    freq.put(" ru", 136);
    freq.put("lko", 462);
    freq.put("te ", 16458);
    freq.put(" Al", 6496);
    freq.put("K", 12674);
    freq.put(" re", 402);
    freq.put("eha", 3263);
    freq.put(" ra", 630);
    freq.put(" An", 4660);
    freq.put(" ro", 580);
    freq.put("kzi", 9745);
    freq.put(" ri", 131);
    freq.put("s\u030c", 115);
    freq.put("a\u0300", 612);
    freq.put("rch", 425);
    freq.put("zti", 2572);
    freq.put("su ", 1117);
    freq.put("oma", 3483);
    freq.put("lki", 1220);
    freq.put("asa", 2228);
    freq.put("Gil", 209);
    freq.put("ev ", 129);
    freq.put("sba", 383);
    freq.put("xo ", 287);
    freq.put("asg", 196);
    freq.put("oad", 180);
    freq.put("sci", 309);
    freq.put("rku", 647);
    freq.put("Aub", 618);
    freq.put("Aud", 619);
    freq.put("Aug", 208);
    freq.put("Yon", 444);
    freq.put("Tor", 335);
    freq.put("sbe", 333);
    freq.put("vin", 415);
    freq.put("Tow", 179);
    freq.put("vil", 2088);
    freq.put("Tou", 411);
    freq.put("vir", 147);
    freq.put("Tok", 213);
    freq.put("Aus", 617);
    freq.put("Aur", 352);
    freq.put("Aut", 408);
    freq.put("Tol", 699);
    freq.put("Uni", 1067);
    freq.put("S ", 435);
    freq.put(" s ", 207);
    freq.put("twa", 207);
    freq.put("jio", 380);
    freq.put("mma", 310);
    freq.put("ov ", 231);
    freq.put(" d ", 1527);
    freq.put("mme", 989);
    freq.put("udu", 480);
    freq.put("eyr", 541);
    freq.put("pur", 933);
    freq.put("\u03b7", 259);
    freq.put("de ", 14213);
    freq.put("pus", 334);
    freq.put("n\u0303ak", 177);
    freq.put("iz ", 3294);
    freq.put("Sy", 260);
    freq.put("ph ", 172);
    freq.put("Sp", 738);
    freq.put("dai", 1813);
    freq.put("Su", 1641);
    freq.put("St", 1667);
    freq.put("Sk", 128);
    freq.put("Not", 129);
    freq.put("Si", 1956);
    freq.put("Sh", 1018);
    freq.put("So", 2835);
    freq.put("Sl", 127);
    freq.put("Sc", 1754);
    freq.put("Sa", 12778);
    freq.put("tru", 540);
    freq.put("Nov", 113);
    freq.put("Se", 3621);
    freq.put("xer", 312);
    freq.put("a\u0301", 1849);
    freq.put("kle", 410);
    freq.put("dez", 1959);
    freq.put("e\u0300ge", 392);
    freq.put("kla", 832);
    freq.put(" di", 15772);
    freq.put("Int", 602);
    freq.put(" de", 49829);
    freq.put("ata", 5981);
    freq.put("Inp", 655);
    freq.put("vr", 1081);
    freq.put(" da", 131136);
    freq.put("Ins", 196);
    freq.put("klu", 109);
    freq.put("avo", 638);
    freq.put("Vas", 132);
    freq.put("dem", 540);
    freq.put("den", 11216);
    freq.put("v", 18456);
    freq.put("Ind", 1394);
    freq.put("dea", 45982);
    freq.put(" du", 13144);
    freq.put("Ing", 1090);
    freq.put(" dr", 141);
    freq.put("def", 455);
    freq.put("avi", 1105);
    freq.put("epa", 30994);
    freq.put("isp", 164);
    freq.put("rua", 4504);
    freq.put("vie\u0300", 127);
    freq.put("eol", 759);
    freq.put("dui", 109);
    freq.put("pro", 6098);
    freq.put("km ", 412);
    freq.put("f ", 1461);
    freq.put("way", 199);
    freq.put("lal", 149);
    freq.put("ath", 563);
    freq.put("ave", 561);
    freq.put("pai", 3956);
    freq.put("e\u0300vr", 599);
    freq.put("ryn", 159);
    freq.put("isk", 1566);
    freq.put("tsi", 2184);
    freq.put("ft ", 115);
    freq.put("o\u0302t", 781);
    freq.put("slo", 268);
    freq.put("att", 437);
    freq.put("Yor", 688);
    freq.put("o\u0302n", 1427);
    freq.put("o\u0302m", 838);
    freq.put("fed", 363);
    freq.put("\u0438\u0306", 238);
    freq.put("atr", 577);
    freq.put("oye", 159);
    freq.put("uxi", 112);
    freq.put("Typ", 542);
    freq.put("ryp", 120);
    freq.put("isn", 727);
    freq.put("fr", 4122);
    freq.put("ft", 461);
    freq.put("fu", 1726);
    freq.put("Glo", 115);
    freq.put("Gla", 168);
    freq.put("\u03bf\u0301", 170);
    freq.put("rmo", 557);
    freq.put("fa", 13204);
    freq.put("Se\u0301", 155);
    freq.put("Se\u0300", 286);
    freq.put("\u03bd ", 159);
    freq.put("ff", 773);
    freq.put("fg", 114);
    freq.put("Dor", 804);
    freq.put("fi", 7825);
    freq.put("Aka", 163);
    freq.put("fl", 595);
    freq.put("fo", 4955);
    freq.put("a", 1770525);
    freq.put("kor", 2545);
    freq.put("zy ", 123);
    freq.put("lha", 201);
    freq.put("egr", 361);
    freq.put("egu", 4291);
    freq.put("mar", 5241);
    freq.put("ne ", 11184);
    freq.put("egi", 10698);
    freq.put("ego", 7214);
    freq.put("ise", 2016);
    freq.put("o\u0308", 568);
    freq.put("usk", 7231);
    freq.put("ega", 1847);
    freq.put("ege", 2822);
    freq.put("oy ", 351);
    freq.put("ito", 2098);
    freq.put("itm", 162);
    freq.put("Deu", 416);
    freq.put("ce ", 1311);
    freq.put("y ", 9063);
    freq.put("rug", 753);
    freq.put("ite", 6146);
    freq.put("lah", 118);
    freq.put("txo", 1698);
    freq.put("ita", 22759);
    freq.put("ok ", 552);
    freq.put("itz", 12198);
    freq.put("itx", 1037);
    freq.put("ity", 169);
    freq.put("uva", 124);
    freq.put("itt", 399);
    freq.put("itu", 32563);
    freq.put("itr", 368);
    freq.put("its", 2904);
    freq.put("pid", 4283);
    freq.put(" On", 612);
    freq.put(" Ol", 1015);
    freq.put(" Om", 121);
    freq.put(" Ok", 8850);
    freq.put(" Oh", 168);
    freq.put(" Oi", 1023);
    freq.put(" Of", 119);
    freq.put(" Od", 227);
    freq.put("gy ", 143);
    freq.put(" Ob", 227);
    freq.put("nto", 2625);
    freq.put("usp", 226);
    freq.put(" Oz", 621);
    freq.put(" Ox", 152);
    freq.put(" Ov", 109);
    freq.put("oar", 7570);
    freq.put(" Ot", 443);
    freq.put(" Ou", 336);
    freq.put(" Or", 2903);
    freq.put(" Os", 758);
    freq.put(" Op", 333);
    freq.put("yi", 1221);
    freq.put("yk", 360);
    freq.put("Bau", 120);
    freq.put("ym", 693);
    freq.put("yl", 2141);
    freq.put("yo", 623);
    freq.put("yn", 833);
    freq.put("ya", 1650);
    freq.put("cen", 434);
    freq.put("yc", 830);
    freq.put("cel", 570);
    freq.put("ye", 1014);
    freq.put("L", 25422);
    freq.put("yg", 376);
    freq.put("Bay", 133);
    freq.put("Erd", 679);
    freq.put("Ere", 283);
    freq.put("Bad", 228);
    freq.put("ces", 263);
    freq.put("Era", 611);
    freq.put("cep", 383);
    freq.put("Ban", 555);
    freq.put("yp", 1406);
    freq.put("ys", 908);
    freq.put("yr", 1417);
    freq.put("yu", 249);
    freq.put("yt", 384);
    freq.put("cey", 125);
    freq.put("Erk", 205);
    freq.put("yno", 210);
    freq.put("mah", 164);
    freq.put("gue", 1210);
    freq.put("Ran", 155);
    freq.put("yne", 176);
    freq.put("Ram", 376);
    freq.put(" O ", 208);
    freq.put("Rai", 109);
    freq.put("ife", 501);
    freq.put("iff", 119);
    freq.put("val", 523);
    freq.put("lyc", 377);
    freq.put("ifa", 243);
    freq.put("man", 6689);
    freq.put("dak", 4129);
    freq.put("ifo", 600);
    freq.put("ifi", 1639);
    freq.put(" A ", 442);
    freq.put("Mut", 117);
    freq.put("dig", 733);
    freq.put("Mus", 488);
    freq.put("Mur", 267);
    freq.put("ro\u0302m", 333);
    freq.put("tre", 1843);
    freq.put(" sp", 132);
    freq.put(" st", 216);
    freq.put(" su", 3722);
    freq.put("Enp", 155);
    freq.put("\u4e13", 624);
    freq.put(" si", 3486);
    freq.put("Ent", 296);
    freq.put(" so", 7153);
    freq.put("ypt", 141);
    freq.put(" sc", 161);
    freq.put("uda", 33965);
    freq.put(" sa", 10788);
    freq.put(" se", 2907);
    freq.put("iza", 19239);
    freq.put("ize", 7802);
    freq.put("ftw", 197);
    freq.put("izg", 172);
    freq.put("izi", 6510);
    freq.put("izk", 5110);
    freq.put("izl", 132);
    freq.put("E ", 494);
    freq.put("izo", 1014);
    freq.put("izp", 401);
    freq.put("oig", 146);
    freq.put("izt", 21049);
    freq.put("izu", 662);
    freq.put("exa", 425);
    freq.put("oie", 762);
    freq.put("Loz", 203);
    freq.put("ass", 921);
    freq.put("jer", 179);
    freq.put(" Ab", 1037);
    freq.put(" Ac", 451);
    freq.put(" Ad", 9947);
    freq.put("pui", 142);
    freq.put(" Af", 752);
    freq.put(" Ag", 994);
    freq.put(" Ah", 190);
    freq.put(" Ai", 1863);
    freq.put(" Ak", 544);
    freq.put("o\u0304", 492);
    freq.put(" Am", 3098);
    freq.put("\u044f", 187);
    freq.put(" Ap", 641);
    freq.put("dit", 6852);
    freq.put(" Ar", 7825);
    freq.put(" As", 1839);
    freq.put(" At", 1715);
    freq.put(" Au", 3286);
    freq.put(" Av", 691);
    freq.put("guz", 1681);
    freq.put("ask", 3157);
    freq.put(" Ay", 124);
    freq.put(" Az", 814);
    freq.put("ash", 374);
    freq.put("aso", 2684);
    freq.put("sbo", 201);
    freq.put("asm", 635);
    freq.put("asl", 1054);
    freq.put("Em", 589);
    freq.put("El", 2242);
    freq.put("En", 1222);
    freq.put("Ei", 284);
    freq.put("Ek", 1089);
    freq.put("Ed", 572);
    freq.put("Eg", 1307);
    freq.put("kon", 8009);
    freq.put("Ea", 166);
    freq.put("Ec", 112);
    freq.put("Eb", 131);
    freq.put("nfi", 148);
    freq.put("koa", 15917);
    freq.put("XX ", 192);
    freq.put("Ex", 216);
    freq.put("w", 6134);
    freq.put("Ez", 530);
    freq.put("Eu", 5638);
    freq.put("Et", 707);
    freq.put("Ev", 124);
    freq.put("Ep", 195);
    freq.put("Es", 7502);
    freq.put("Er", 7909);
    freq.put("rro", 8594);
    freq.put("Fra", 33371);
    freq.put("kob", 165);
    freq.put("Fre", 391);
    freq.put("uel", 1556);
    freq.put("Cle", 128);
    freq.put("\u043e\u0432", 295);
    freq.put("Fro", 202);
    freq.put("Cla", 350);
    freq.put("kod", 227);
    freq.put("mop", 136);
    freq.put("ude", 2755);
    freq.put("uen", 35965);
    freq.put("bul", 964);
    freq.put("elk", 1631);
    freq.put("ur ", 5462);
    freq.put("Clu", 134);
    freq.put("pea", 802);
    freq.put("osc", 282);
    freq.put(" el", 3773);
    freq.put(" em", 2495);
    freq.put(" en", 3242);
    freq.put(" eh", 379);
    freq.put("kol", 2022);
    freq.put("koo", 115);
    freq.put(" ek", 9675);
    freq.put(" ed", 12800);
    freq.put("oaz", 457);
    freq.put("X ", 613);
    freq.put(" eg", 10971);
    freq.put("koe", 2023);
    freq.put(" ea", 1283);
    freq.put(" eb", 259);
    freq.put("imb", 209);
    freq.put("koz", 874);
    freq.put(" ex", 330);
    freq.put("phu", 411);
    freq.put(" ez", 8057);
    freq.put("Res", 126);
    freq.put(" et", 48874);
    freq.put(" eu", 4631);
    freq.put("kos", 1322);
    freq.put("\u043a", 647);
    freq.put(" ep", 416);
    freq.put("kot", 1230);
    freq.put(" er", 27809);
    freq.put(" es", 44512);
    freq.put("omu", 1205);
    freq.put("ncy", 130);
    freq.put("dal", 34505);
    freq.put("nct", 118);
    freq.put("ncu", 199);
    freq.put("mua", 312);
    freq.put("ime", 3172);
    freq.put("nch", 1193);
    freq.put("eli", 2171);
    freq.put("Ise\u0300", 386);
    freq.put("o\u0302me", 834);
    freq.put("scu", 158);
    freq.put("jek", 326);
    freq.put("nca", 298);
    freq.put("hth", 235);
    freq.put("nce", 1222);
    freq.put("ste", 10155);
    freq.put("b", 212072);
    freq.put("sta", 12361);
    freq.put("dam", 370);
    freq.put("bag", 126);
    freq.put("stl", 148);
    freq.put("jen", 358);
    freq.put("Xa", 263);
    freq.put(" e ", 115);
    freq.put("sti", 12235);
    freq.put("Xe", 154);
    freq.put("stu", 1961);
    freq.put("Rei", 155);
    freq.put("le\u0300s", 615);
    freq.put("jel", 120);
    freq.put("str", 13494);
    freq.put("aar", 137);
    freq.put("kov", 156);
    freq.put("nfa", 134);
    freq.put("Gol", 169);
    freq.put("Gon", 350);
    freq.put("Goi", 319);
    freq.put("rry", 287);
    freq.put("sh ", 330);
    freq.put("Rem", 135);
    freq.put("Fut", 140);
    freq.put("ui ", 164);
    freq.put("Gob", 162);
    freq.put("nak", 8535);
    freq.put("Rec", 114);
    freq.put("Gou", 140);
    freq.put("Got", 125);
    freq.put("Gor", 655);
    freq.put("lid", 704);
    freq.put("Nik", 161);
    freq.put("lif", 1422);
    freq.put("k ", 62634);
    freq.put("lia", 18816);
    freq.put("Nil", 110);
    freq.put("lic", 425);
    freq.put("Bla", 371);
    freq.put("lin", 3474);
    freq.put("lio", 1757);
    freq.put("Nig", 111);
    freq.put("lem", 3502);
    freq.put("Reg", 177);
    freq.put("lit", 5235);
    freq.put("efi", 386);
    freq.put("liv", 211);
    freq.put("mak", 1772);
    freq.put("lip", 493);
    freq.put("Kin", 214);
    freq.put("Kim", 109);
    freq.put("Kil", 130);
    freq.put("\u0639", 171);
    freq.put("cci", 190);
    freq.put("lix", 128);
    freq.put("efe", 1060);
    freq.put("liz", 2323);
    freq.put("uji", 118);
    freq.put("zga", 145);
    freq.put("kab", 331);
    freq.put("Ate", 172);
    freq.put("kag", 867);
    freq.put("oft", 279);
    freq.put("kae", 232);
    freq.put("Ata", 133);
    freq.put("kak", 2781);
    freq.put("Isr", 115);
    freq.put("Atl", 685);
    freq.put("M", 31193);
    freq.put("kan", 3807);
    freq.put("Ath", 126);
    freq.put("Ist", 111);
    freq.put("Tho", 316);
    freq.put("kar", 12671);
    freq.put("kap", 656);
    freq.put("Atr", 335);
    freq.put("Thi", 181);
    freq.put("Isl", 300);
    freq.put("kaz", 1190);
    freq.put("The", 888);
    freq.put("Tha", 159);
    freq.put("zik", 1618);
    freq.put("ka", 61958);
    freq.put("a\u0302", 543);
    freq.put("li ", 1303);
    freq.put("usu", 203);
    freq.put("ke", 15259);
    freq.put("Zee", 161);
    freq.put("kk", 1095);
    freq.put("exo", 122);
    freq.put("ki", 41699);
    freq.put("kh", 562);
    freq.put("ko", 209669);
    freq.put("kn", 545);
    freq.put("km", 634);
    freq.put("kl", 2132);
    freq.put("ks", 428);
    freq.put("kr", 3078);
    freq.put("exu", 444);
    freq.put("ku", 47447);
    freq.put("kt", 5287);
    freq.put("kz", 9751);
    freq.put("ky", 241);
    freq.put("phl", 1004);
    freq.put("rte", 16058);
    freq.put("Hai", 353);
    freq.put("ugi", 893);
    freq.put("ugh", 140);
    freq.put("Hal", 393);
    freq.put("Ham", 279);
    freq.put("Han", 786);
    freq.put("rra", 27202);
    freq.put("rto", 962);
    freq.put("nco", 700);
    freq.put(" Be\u0301", 203);
    freq.put("rth", 1501);
    freq.put("sup", 126);
    freq.put("hi ", 2061);
    freq.put("rbo", 540);
    freq.put("rts", 3910);
    freq.put("rtr", 191);
    freq.put("Err", 5471);
    freq.put("Har", 1000);
    freq.put("Has", 208);
    freq.put("Hau", 2610);
    freq.put("ugu", 650);
    freq.put("rtz", 8628);
    freq.put("iez", 349);
    freq.put("Ju", 1950);
    freq.put("Gym", 213);
    freq.put("ier", 10660);
    freq.put("ieu", 535);
    freq.put("iet", 4538);
    freq.put("iev", 194);
    freq.put("iei", 288);
    freq.put("Ope", 128);
    freq.put("iek", 1321);
    freq.put("Jo", 2759);
    freq.put("iem", 109);
    freq.put("Ji", 328);
    freq.put("ien", 15589);
    freq.put("iea", 142);
    freq.put("Je", 1151);
    freq.put("iee", 130);
    freq.put("Ja", 2843);
    freq.put("ieg", 332);
    freq.put("\u093e", 121);
    freq.put("hip", 234);
    freq.put("tts", 160);
    freq.put("hir", 8155);
    freq.put("his", 2862);
    freq.put("hit", 1675);
    freq.put("rt ", 2199);
    freq.put("ose", 2342);
    freq.put("hiz", 2483);
    freq.put("e\u0300re", 1699);
    freq.put("Xi", 357);
    freq.put("hid", 400);
    freq.put("hie", 1401);
    freq.put("hig", 352);
    freq.put("hii", 240);
    freq.put("hik", 564);
    freq.put("hil", 1588);
    freq.put("him", 161);
    freq.put("hin", 1789);
    freq.put("hio", 194);
    freq.put("noa", 1389);
    freq.put("cru", 146);
    freq.put("zot", 212);
    freq.put("uss", 762);
    freq.put("hae", 346);
    freq.put("oxi", 323);
    freq.put("ko ", 166136);
    freq.put("x", 24609);
    freq.put(" Pe\u0301", 178);
    freq.put("cri", 123);
    freq.put("J ", 172);
    freq.put("elg", 473);
    freq.put(" Be", 7803);
    freq.put("Fou", 190);
    freq.put("arr", 46687);
    freq.put("ars", 715);
    freq.put(" Ba", 9875);
    freq.put("aru", 371);
    freq.put("For", 678);
    freq.put("sep", 278);
    freq.put(" Bl", 636);
    freq.put(" Bo", 3476);
    freq.put(" Bi", 4537);
    freq.put("sez", 2416);
    freq.put("sey", 232);
    freq.put("sex", 360);
    freq.put(" Bu", 1682);
    freq.put("ara", 18217);
    freq.put("arb", 1084);
    freq.put("arc", 902);
    freq.put("ard", 3975);
    freq.put("are", 45955);
    freq.put("sea", 404);
    freq.put(" Br", 3193);
    freq.put("seo", 240);
    freq.put("ari", 25386);
    freq.put("Fon", 318);
    freq.put("ark", 3693);
    freq.put("arl", 1757);
    freq.put("arm", 1625);
    freq.put("arn", 4158);
    freq.put("aro", 3911);
    freq.put("mo ", 1194);
    freq.put("zki", 1871);
    freq.put("zke", 2202);
    freq.put("oza", 425);
    freq.put("use", 2014);
    freq.put("nza", 293);
    freq.put("\u0430\u043d", 144);
    freq.put("chu", 371);
    freq.put("Ple", 223);
    freq.put("kto", 1401);
    freq.put("Pla", 722);
    freq.put("ozo", 304);
    freq.put("gek", 219);
    freq.put("ele", 6128);
    freq.put("ms ", 126);
    freq.put("\u03ba", 273);
    freq.put("ikr", 256);
    freq.put(" B ", 131);
    freq.put("iku", 2386);
    freq.put("ikt", 193);
    freq.put("ikz", 303);
    freq.put("\u044b", 136);
    freq.put("tik", 17820);
    freq.put("a\u030c", 126);
    freq.put("ar ", 18677);
    freq.put("ika", 16573);
    freq.put("\u0430\u0441", 113);
    freq.put("ike", 2410);
    freq.put("se ", 3435);
    freq.put("tiv", 202);
    freq.put("te\u0301 ", 122);
    freq.put("iki", 4819);
    freq.put("leo", 696);
    freq.put("iko", 21260);
    freq.put("fga", 109);
    freq.put("ot ", 1204);
    freq.put("ikl", 464);
    freq.put(" Ps", 372);
    freq.put(" Pr", 2625);
    freq.put("c", 39575);
    freq.put("ueb", 168);
    freq.put(" Pu", 1219);
    freq.put(" Pt", 120);
    freq.put(" Py", 112);
    freq.put("skr", 385);
    freq.put("fos", 110);
    freq.put("yph", 1017);
    freq.put("Far", 152);
    freq.put(" Pa", 5978);
    freq.put("gei", 542);
    freq.put(" Pe", 2717);
    freq.put("igu", 1200);
    freq.put("tra", 13798);
    freq.put(" Pi", 2760);
    freq.put(" Ph", 764);
    freq.put(" Po", 3289);
    freq.put("gma", 140);
    freq.put("lol", 163);
    freq.put(" Pl", 1082);
    freq.put("kez", 458);
    freq.put("Wal", 229);
    freq.put("sai", 9052);
    freq.put("rag", 3181);
    freq.put("oqu", 170);
    freq.put("rur", 560);
    freq.put("doc", 225);
    freq.put("eze", 550);
    freq.put("ka ", 7200);
    freq.put("rie\u0300", 489);
    freq.put("nat", 3667);
    freq.put("lbu", 874);
    freq.put("txu", 656);
    freq.put("Was", 125);
    freq.put("War", 190);
    freq.put("ga ", 2307);
    freq.put("pr", 9929);
    freq.put("ps", 2339);
    freq.put("pp", 706);
    freq.put("duk", 1954);
    freq.put("dul", 792);
    freq.put("dum", 256);
    freq.put("pt", 2020);
    freq.put("pu", 7547);
    freq.put("pz", 138);
    freq.put("dua", 33103);
    freq.put("xar", 321);
    freq.put("py", 188);
    freq.put("xat", 249);
    freq.put("due", 5451);
    freq.put("dug", 218);
    freq.put("geo", 710);
    freq.put("ely", 133);
    freq.put("duz", 254);
    freq.put("pa", 48349);
    freq.put("xal", 109);
    freq.put("nau", 412);
    freq.put("xan", 503);
    freq.put("pe", 17100);
    freq.put("ska", 8859);
    freq.put("ph", 5789);
    freq.put("pi", 13999);
    freq.put("dut", 4392);
    freq.put("po", 11630);
    freq.put("pl", 4223);
    freq.put("exe", 123);
    freq.put("nri", 259);
    freq.put("Ema", 110);
    freq.put("Fal", 128);
    freq.put("nla", 655);
    freq.put(" tx", 4570);
    freq.put("\u0438\u0306 ", 179);
    freq.put(" tu", 424);
    freq.put("gat", 2266);
    freq.put("Emi", 244);
    freq.put(" tr", 2688);
    freq.put("N", 19703);
    freq.put(" to", 1288);
    freq.put("gan", 2119);
    freq.put("gam", 476);
    freq.put("gal", 2723);
    freq.put("gak", 724);
    freq.put(" ti", 1534);
    freq.put(" th", 540);
    freq.put("ze\u0300r", 200);
    freq.put(" te", 2817);
    freq.put("gad", 132);
    freq.put("gab", 1043);
    freq.put(" ta", 4238);
    freq.put("Ola", 182);
    freq.put("fut", 598);
    freq.put("e\u0301s ", 183);
    freq.put("iya", 143);
    freq.put("fus", 174);
    freq.put("Rio", 118);
    freq.put("du ", 7012);
    freq.put("Oli", 468);
    freq.put("tip", 247);
    freq.put("p ", 1016);
    freq.put("u\u0300", 141);
    freq.put("lbe", 387);
    freq.put("eke", 1121);
    freq.put("sy ", 268);
    freq.put("riz", 2281);
    freq.put("rix", 382);
    freq.put("moz", 332);
    freq.put("riv", 160);
    freq.put("tiq", 263);
    freq.put("rit", 7871);
    freq.put("riu", 525);
    freq.put("rir", 622);
    freq.put("Iru", 781);
    freq.put("Tir", 125);
    freq.put("rin", 4139);
    freq.put("Iri", 152);
    freq.put("ril", 4692);
    freq.put("rim", 739);
    freq.put("Irl", 1084);
    freq.put("rik", 14158);
    freq.put("aha", 1972);
    freq.put("Ira", 616);
    freq.put("rid", 2808);
    freq.put("rie", 4686);
    freq.put("rib", 3119);
    freq.put("ric", 1194);
    freq.put("Tib", 109);
    freq.put("ria", 43986);
    freq.put("\u0421", 176);
    freq.put("ng ", 2807);
    freq.put("boi", 169);
    freq.put("raz", 13993);
    freq.put("nay", 387);
    freq.put("ama", 5578);
    freq.put("clu", 182);
    freq.put("spe", 2584);
    freq.put("ray", 301);
    freq.put("ssi", 746);
    freq.put("ohn", 393);
    freq.put("\u4e13 ", 284);
    freq.put("Cos", 145);
    freq.put("Cor", 1166);
    freq.put("Cou", 568);
    freq.put("omm", 1081);
    freq.put("dge", 253);
    freq.put("Ill", 286);
    freq.put("kud", 351);
    freq.put("cea", 325);
    freq.put("Asp", 121);
    freq.put("an\u0303a", 175);
    freq.put("uto", 1475);
    freq.put("gom", 158);
    freq.put("Com", 567);
    freq.put("Col", 1978);
    freq.put("ri ", 30074);
    freq.put("Con", 778);
    freq.put("kno", 187);
    freq.put("Soc", 136);
    freq.put(" fr", 2586);
    freq.put(" fu", 1398);
    freq.put("ex ", 208);
    freq.put("kni", 322);
    freq.put("rdi", 6252);
    freq.put("si ", 2705);
    freq.put("ew ", 848);
    freq.put("Som", 871);
    freq.put("Sol", 243);
    freq.put("Son", 154);
    freq.put(" fa", 8966);
    freq.put("Sor", 289);
    freq.put(" fe", 664);
    freq.put("Nic", 160);
    freq.put("y", 24758);
    freq.put("Soz", 190);
    freq.put(" fl", 294);
    freq.put(" fo", 1255);
    freq.put("mon", 2086);
    freq.put("lda", 3988);
    freq.put("zku", 2058);
    freq.put("sla", 1331);
    freq.put("lde", 53459);
    freq.put("ldi", 2939);
    freq.put("mol", 594);
    freq.put("ldo", 569);
    freq.put("bi ", 1854);
    freq.put("O ", 483);
    freq.put("Yve", 193);
    freq.put("ipa", 3058);
    freq.put("lij", 389);
    freq.put("ldu", 1826);
    freq.put("ohi", 1496);
    freq.put("wic", 120);
    freq.put("lik", 3840);
    freq.put("ltz", 6760);
    freq.put("uzi", 824);
    freq.put("cut", 132);
    freq.put("cus", 776);
    freq.put("cur", 130);
    freq.put("liu", 172);
    freq.put("uaz", 311);
    freq.put(" \u4e4b", 199);
    freq.put("ipe", 1493);
    freq.put("\u043e", 1160);
    freq.put("sal", 1071);
    freq.put("rge", 1357);
    freq.put("win", 111);
    freq.put("\u03b9", 506);
    freq.put("rgi", 2575);
    freq.put("cul", 269);
    freq.put("sin", 2608);
    freq.put("app", 159);
    freq.put("gs", 391);
    freq.put("elv", 114);
    freq.put("bin", 3474);
    freq.put("On", 616);
    freq.put("Om", 122);
    freq.put("Ol", 1020);
    freq.put("Ok", 8891);
    freq.put("bik", 563);
    freq.put("Oi", 1025);
    freq.put("Oh", 168);
    freq.put("urd", 1157);
    freq.put("Of", 128);
    freq.put("bid", 4505);
    freq.put("Od", 228);
    freq.put("Kai", 138);
    freq.put("be\u0301", 122);
    freq.put("Ais", 678);
    freq.put("Air", 369);
    freq.put("Ain", 131);
    freq.put("biz", 22873);
    freq.put("Oz", 622);
    freq.put("Ox", 154);
    freq.put("Ov", 109);
    freq.put("Ou", 336);
    freq.put("Ot", 444);
    freq.put("Os", 761);
    freq.put("Or", 2924);
    freq.put("Op", 333);
    freq.put("uy ", 638);
    freq.put("kuz", 165);
    freq.put(" \u4e01", 261);
    freq.put("d", 496450);
    freq.put("fel", 165);
    freq.put("eet", 3066);
    freq.put("ppi", 156);
    freq.put(" \u4e09", 359);
    freq.put("lje", 187);
    freq.put("dun", 1704);
    freq.put("eer", 450);
    freq.put("rg ", 780);
    freq.put(" \u4e13", 142);
    freq.put("ule", 1208);
    freq.put("een", 2608);
    freq.put("eei", 184);
    freq.put("eek", 733);
    freq.put(" \u4e18", 117);
    freq.put("ii ", 406);
    freq.put(" We", 715);
    freq.put("tyl", 1154);
    freq.put("b ", 834);
    freq.put("neg", 587);
    freq.put("uf ", 132);
    freq.put("xot", 335);
    freq.put("ru ", 3378);
    freq.put("gok", 1203);
    freq.put("ohe", 156);
    freq.put("ija", 210);
    freq.put("ld ", 516);
    freq.put("zie", 3257);
    freq.put("c\u0327a", 162);
    freq.put("c\u0327o", 189);
    freq.put("iji", 583);
    freq.put("oe ", 120);
    freq.put("Vel", 146);
    freq.put("ijo", 114);
    freq.put("e\u0300ze", 351);
    freq.put("u\u0304 ", 285);
    freq.put(" Qu", 655);
    freq.put("pez", 1232);
    freq.put("pet", 1004);
    freq.put("sge", 484);
    freq.put("kad", 1070);
    freq.put("rio", 4087);
    freq.put("pes", 475);
    freq.put("pel", 1577);
    freq.put("pen", 3866);
    freq.put("pei", 178);
    freq.put("pek", 338);
    freq.put("ped", 964);
    freq.put(" Qi", 123);
    freq.put("uku", 113);
    freq.put("ape", 2743);
    freq.put("kai", 3049);
    freq.put("id ", 402);
    freq.put("km2", 111);
    freq.put("bd", 240);
    freq.put("be", 37939);
    freq.put("bg", 166);
    freq.put("run", 1514);
    freq.put("ba", 82298);
    freq.put("bb", 248);
    freq.put("rum", 622);
    freq.put("bl", 4003);
    freq.put("ruc", 148);
    freq.put("bn", 150);
    freq.put("bo", 17651);
    freq.put("bh", 132);
    freq.put("bi", 50340);
    freq.put("bj", 339);
    freq.put("rue", 502);
    freq.put("ruz", 1278);
    freq.put("bu", 10932);
    freq.put("oei", 191);
    freq.put("tid", 1081);
    freq.put("Bol", 414);
    freq.put("kam", 178);
    freq.put("br", 4958);
    freq.put("bs", 905);
    freq.put("eux", 721);
    freq.put("rus", 3454);
    freq.put("rup", 118);
    freq.put("kal", 6938);
    freq.put("by", 276);
    freq.put("rut", 2747);
    freq.put("che", 2829);
    freq.put("sse", 1415);
    freq.put("kas", 3232);
    freq.put("lge", 122);
    freq.put("ich", 1326);
    freq.put("\u03c2 ", 631);
    freq.put("a\u0308", 628);
    freq.put("gea", 1197);
    freq.put("Rob", 311);
    freq.put("Roc", 325);
    freq.put("Rod", 194);
    freq.put("Roy", 117);
    freq.put("yle", 229);
    freq.put("rta", 37313);
    freq.put("bgu", 159);
    freq.put("Oso", 146);
    freq.put("idi", 703);
    freq.put("idg", 234);
    freq.put("yll", 153);
    freq.put("Ros", 328);
    freq.put("pe ", 842);
    freq.put("Rou", 411);
    freq.put("ida", 12783);
    freq.put("nsh", 183);
    freq.put("Elk", 412);
    freq.put("wn ", 153);
    freq.put("Eli", 450);
    freq.put("Elo", 131);
    freq.put(" uz", 1119);
    freq.put("nso", 335);
    freq.put(" ut", 439);
    freq.put("nsa", 275);
    freq.put(" C ", 208);
    freq.put("Ela", 199);
    freq.put("nse", 442);
    freq.put(" ur", 7726);
    freq.put(" us", 349);
    freq.put(" ul", 113);
    freq.put(" um", 156);
    freq.put(" un", 1012);
    freq.put(" uh", 1778);
    freq.put("kut", 584);
    freq.put(" uk", 258);
    freq.put(" ud", 33375);
    freq.put(" ug", 588);
    freq.put("nst", 1117);
    freq.put("nsu", 131);
    freq.put("rig", 1164);
    freq.put("ixk", 401);
    freq.put("ut ", 685);
    freq.put("sad", 276);
    freq.put("ixo", 397);
    freq.put("tuk", 1405);
    freq.put("\u4e26", 364);
    freq.put("Nob", 153);
    freq.put("zid", 476);
    freq.put("ixe", 126);
    freq.put("lac", 584);
    freq.put("xoa", 1198);
    freq.put("voi", 624);
    freq.put("cht", 276);
    freq.put("u ", 41051);
    freq.put("kig", 334);
    freq.put("hri", 326);
    freq.put("aqu", 160);
    freq.put(" Ch", 5831);
    freq.put(" Ci", 542);
    freq.put(" Cn", 231);
    freq.put(" Co", 5729);
    freq.put(" Cl", 859);
    freq.put("dok", 827);
    freq.put("ns ", 1708);
    freq.put("lka", 8759);
    freq.put("El ", 382);
    freq.put(" Ca", 6284);
    freq.put(" Ce", 1039);
    freq.put("ukt", 390);
    freq.put("kur", 1078);
    freq.put(" Cy", 473);
    freq.put("Flo", 355);
    freq.put("chy", 392);
    freq.put(" Cr", 1191);
    freq.put("ul ", 480);
    freq.put(" Ct", 233);
    freq.put(" Cu", 573);
    freq.put("saz", 146);
    freq.put("cia", 581);
    freq.put("uta", 14646);
    freq.put("uy", 977);
    freq.put("ux", 2209);
    freq.put("cie", 258);
    freq.put("uz", 19517);
    freq.put("exi", 839);
    freq.put("ut", 35746);
    freq.put("ix ", 589);
    freq.put("uv", 1191);
    freq.put("cio", 340);
    freq.put("up", 1366);
    freq.put("us", 31658);
    freq.put("ur", 58487);
    freq.put("um", 6170);
    freq.put("ul", 13460);
    freq.put("uo", 392);
    freq.put("un", 31293);
    freq.put("ui", 4962);
    freq.put("uh", 2527);
    freq.put("uk", 15052);
    freq.put("uj", 404);
    freq.put("ue", 46850);
    freq.put("ud", 39922);
    freq.put("ug", 6475);
    freq.put("uf", 629);
    freq.put("ua", 92243);
    freq.put("Zeh", 114);
    freq.put("uc", 1798);
    freq.put("ub", 8862);
    freq.put("tun", 1118);
    freq.put("txe", 2626);
    freq.put("Tx", 2595);
    freq.put("Ty", 618);
    freq.put("Zen", 285);
    freq.put("Tu", 924);
    freq.put("Tr", 2492);
    freq.put("To", 2471);
    freq.put("Cne", 218);
    freq.put("Zel", 160);
    freq.put("Th", 1746);
    freq.put("Ti", 995);
    freq.put("zal", 4025);
    freq.put("Te", 1911);
    freq.put("Ta", 2499);
    freq.put("ser", 1632);
    freq.put("A ", 2297);
    freq.put("Mas", 420);
    freq.put(" gu", 3064);
    freq.put(" gr", 2766);
    freq.put("Mat", 548);
    freq.put("nad", 808);
    freq.put("nae", 224);
    freq.put("May", 341);
    freq.put("Max", 125);
    freq.put("nah", 1954);
    freq.put("Maz", 151);
    freq.put("nan", 1735);
    freq.put("nal", 3860);
    freq.put("eza", 6134);
    freq.put("nar", 6462);
    freq.put("nas", 994);
    freq.put("Mac", 300);
    freq.put(" ge", 12607);
    freq.put("nav", 317);
    freq.put("Mad", 1098);
    freq.put("Mag", 310);
    freq.put(" ga", 11697);
    freq.put("Mai", 913);
    freq.put(" go", 3412);
    freq.put(" gl", 237);
    freq.put(" Qu\u0304", 205);
    freq.put("Mal", 618);
    freq.put(" gi", 2915);
    freq.put("Zur", 179);
    freq.put("kir", 776);
    freq.put("Bea", 612);
    freq.put("zun", 824);
    freq.put("Zuz", 173);
    freq.put("pau", 187);
    freq.put("aen", 488);
    freq.put("hea", 271);
    freq.put("Zub", 282);
    freq.put("ly ", 703);
    freq.put("lpe", 1008);
    freq.put(" Co\u0302", 768);
    freq.put(" co", 450);
    freq.put("ago", 50304);
    freq.put("agn", 992);
    freq.put("Ac", 453);
    freq.put("Ab", 1086);
    freq.put("e", 1172759);
    freq.put("Ad", 9951);
    freq.put("Ag", 995);
    freq.put("Af", 752);
    freq.put("Ai", 1869);
    freq.put("Ah", 190);
    freq.put("Ak", 667);
    freq.put("un\u0303", 753);
    freq.put("Al", 6525);
    freq.put("aga", 4252);
    freq.put("An", 4722);
    freq.put("cio\u0301", 186);
    freq.put("Ap", 642);
    freq.put("As", 1845);
    freq.put("Ar", 7948);
    freq.put("ue\u0301", 150);
    freq.put("At", 1721);
    freq.put("Av", 693);
    freq.put("Ay", 124);
    freq.put("agu", 6313);
    freq.put("u\u0301", 522);
    freq.put("agr", 297);
    freq.put(" b", 117209);
    freq.put(" c", 1597);
    freq.put("gu", 20475);
    freq.put(" a", 103410);
    freq.put(" f", 18132);
    freq.put(" g", 36773);
    freq.put(" d", 213721);
    freq.put(" e", 179842);
    freq.put(" j", 11234);
    freq.put(" k", 40202);
    freq.put(" h", 48767);
    freq.put(" i", 53849);
    freq.put(" n", 11168);
    freq.put(" o", 23087);
    freq.put(" l", 25023);
    freq.put(" m", 32235);
    freq.put(" r", 2003);
    freq.put(" s", 29279);
    freq.put(" p", 25257);
    freq.put(" q", 216);
    freq.put(" v", 880);
    freq.put(" w", 614);
    freq.put(" t", 18277);
    freq.put(" u", 47027);
    freq.put(" z", 66161);
    freq.put("gn", 3188);
    freq.put(" x", 499);
    freq.put(" y", 441);
    freq.put("\u043a\u0430", 189);
    freq.put("gi", 27050);
    freq.put("gh", 1165);
    freq.put(" B", 32085);
    freq.put(" C", 24661);
    freq.put(" A", 48997);
    freq.put(" F", 41666);
    freq.put(" G", 24576);
    freq.put(" D", 12574);
    freq.put(" E", 30981);
    freq.put(" J", 9317);
    freq.put(" K", 12636);
    freq.put(" H", 20099);
    freq.put(" I", 17702);
    freq.put(" N", 19654);
    freq.put(" O", 18798);
    freq.put(" L", 25277);
    freq.put(" M", 31072);
    freq.put(" R", 9631);
    freq.put(" S", 29950);
    freq.put(" P", 21762);
    freq.put(" Q", 1162);
    freq.put(" V", 9966);
    freq.put(" W", 3894);
    freq.put(" T", 16758);
    freq.put(" U", 5599);
    freq.put(" Z", 5479);
    freq.put("mil", 9541);
    freq.put(" X", 2059);
    freq.put(" Y", 2491);
    freq.put("\u03bd", 549);
    freq.put("ne\u0301 ", 169);
    freq.put("Nor", 1256);
    freq.put("esb", 376);
    freq.put("ch ", 1027);
    freq.put("ed ", 562);
    freq.put("Azk", 248);
    freq.put("Aza", 115);
    freq.put("oze\u0300", 187);
    freq.put("a\u0302t", 411);
    freq.put("P", 21838);
    freq.put(" Wh", 115);
    freq.put("g ", 4240);
    freq.put("Azp", 147);
    freq.put("osp", 1434);
    freq.put("e\u0301v", 257);

    init2();
  }
  private static void init2() {
    
    freq.put("tri", 2959);
    freq.put("evi", 1107);
    freq.put("mp ", 117);
    freq.put("tro", 7382);
    freq.put("evo", 137);
    freq.put("opt", 221);
    freq.put("eva", 377);
    freq.put("ekr", 109);
    freq.put("us ", 9795);
    freq.put("zag", 3454);
    freq.put("eve", 525);
    freq.put("lk ", 177);
    freq.put("Sph", 400);
    freq.put("se\u0301 ", 310);
    freq.put("min", 12260);
    freq.put("iba", 3588);
    freq.put("urm", 306);
    freq.put("tmo", 266);
    freq.put("rae", 295);
    freq.put("ulp", 177);
    freq.put("zl", 2872);
    freq.put("ody", 112);
    freq.put("zo", 6743);
    freq.put("zh", 568);
    freq.put("zi", 104084);
    freq.put("rri", 59865);
    freq.put("zk", 17416);
    freq.put("ze", 72397);
    freq.put("rre", 25667);
    freq.put("zg", 277);
    freq.put("za", 55517);
    freq.put("zb", 829);
    freq.put("ibe", 2135);
    freq.put("uir", 110);
    freq.put("odi", 779);
    freq.put("Blo", 124);
    freq.put("mia", 1625);
    freq.put("doe", 371);
    freq.put("zy", 159);
    freq.put("zz", 285);
    freq.put("odo", 1366);
    freq.put("zt", 33176);
    freq.put("zu", 15760);
    freq.put("rru", 11643);
    freq.put("ulu", 958);
    freq.put("zp", 2277);
    freq.put("ode", 1086);
    freq.put("ues", 754);
    freq.put("uer", 1318);
    freq.put("re\u0301 ", 295);
    freq.put(" Re", 1711);
    freq.put(" A\u0301", 134);
    freq.put("eng", 2970);
    freq.put("zae", 141);
    freq.put("xak", 258);
    freq.put("Ort", 156);
    freq.put(" E\u0301", 748);
    freq.put("ari\u0301", 190);
    freq.put("Orn", 527);
    freq.put("Oro", 257);
    freq.put("ych", 465);
    freq.put("yco", 120);
    freq.put("rd ", 1974);
    freq.put("Ori", 184);
    freq.put("rho", 158);
    freq.put("Org", 128);
    freq.put("Ord", 215);
    freq.put("Ore", 134);
    freq.put("Ora", 139);
    freq.put("lea", 7810);
    freq.put("leb", 1036);
    freq.put("enh", 206);
    freq.put("led", 224);
    freq.put("lee", 849);
    freq.put("lef", 184);
    freq.put("och", 579);
    freq.put("leh", 2756);
    freq.put("got", 736);
    freq.put("lek", 3605);
    freq.put("z ", 36063);
    freq.put("ock", 754);
    freq.put("len", 2886);
    freq.put("ozi", 1536);
    freq.put("asu", 3797);
    freq.put("ozt", 385);
    freq.put("les", 5236);
    freq.put("let", 2340);
    freq.put("leu", 374);
    freq.put("Men", 1204);
    freq.put("kue", 274);
    freq.put("od ", 223);
    freq.put("ley", 359);
    freq.put("lez", 813);
    freq.put("rdu", 1468);
    freq.put("ctu", 376);
    freq.put("o\u0301n ", 558);
    freq.put("ula", 4220);
    freq.put("zac", 133);
    freq.put("rds", 187);
    freq.put("fle", 119);
    freq.put("rdy", 168);
    freq.put("cty", 1123);
    freq.put("ulg", 169);
    freq.put("rde", 3329);
    freq.put("zte", 6650);
    freq.put("\u0440\u0430", 136);
    freq.put("rda", 944);
    freq.put("cta", 224);
    freq.put("uhi", 142);
    freq.put("rdo", 1564);
    freq.put("cto", 282);
    freq.put("\u0440\u043e", 162);
    freq.put("ies", 673);
    freq.put("Or ", 694);
    freq.put(" Do", 3472);
    freq.put("Ver", 591);
    freq.put(" Di", 1550);
    freq.put("apr", 133);
    freq.put("aps", 163);
    freq.put(" De", 2338);
    freq.put("wil", 123);
    freq.put("Mik", 294);
    freq.put(" Da", 1841);
    freq.put("apu", 638);
    freq.put("aph", 271);
    freq.put("api", 1618);
    freq.put("ive", 562);
    freq.put("apo", 1684);
    freq.put("apl", 270);
    freq.put("Ven", 718);
    freq.put(" Du", 1118);
    freq.put("apa", 1371);
    freq.put("rui", 249);
    freq.put(" Dr", 847);
    freq.put("Mil", 404);
    freq.put("cha", 1044);
    freq.put("Fr", 34398);
    freq.put("zir", 2573);
    freq.put("Fu", 637);
    freq.put("zip", 247);
    freq.put("fen", 469);
    freq.put("chi", 830);
    freq.put("Hun", 272);
    freq.put("\u062a", 166);
    freq.put("chl", 124);
    freq.put("fek", 715);
    freq.put("usi", 7071);
    freq.put("cho", 437);
    freq.put("Fa", 940);
    freq.put("chr", 456);
    freq.put("rf ", 117);
    freq.put("fer", 1274);
    freq.put("Fe", 1310);
    freq.put("Hur", 125);
    freq.put("chw", 110);
    freq.put("zin", 2910);
    freq.put("Fi", 1608);
    freq.put("zil", 633);
    freq.put("zim", 160);
    freq.put("Fl", 778);
    freq.put("Mic", 585);
    freq.put("Fo", 1536);
    freq.put("Gua", 381);
    freq.put("Gue", 128);
    freq.put("Gui", 276);
    freq.put("io\u0301n", 245);
    freq.put("aca", 415);
    freq.put("Gur", 199);
    freq.put("sra", 160);
    freq.put("nhe", 147);
    freq.put("Guz", 741);
    freq.put(" Ru", 561);
    freq.put("ace", 785);
    freq.put("fe ", 256);
    freq.put("f", 39789);
    freq.put("hra", 124);
    freq.put("Bak", 203);
    freq.put("ied", 378);
    freq.put("F ", 196);
    freq.put("ack", 319);
    freq.put("npl", 1447);
    freq.put(" Ra", 1451);
    freq.put("zi ", 3451);
    freq.put("enn", 1479);
    freq.put("spl", 190);
    freq.put(" Ro", 2671);
    freq.put("ymn", 245);
    freq.put(" Ri", 1240);
    freq.put(" Rh", 1366);
    freq.put("oz ", 1399);
    freq.put("tat", 11576);
    freq.put("tau", 653);
    freq.put("tav", 112);
    freq.put("ach", 1442);
    freq.put("tap", 321);
    freq.put("tar", 13099);
    freq.put("do", 27634);
    freq.put("ie\u0300r", 845);
    freq.put("aco", 349);
    freq.put("ie\u0300v", 316);
    freq.put("taz", 975);
    freq.put("wor", 110);
    freq.put("tad", 501);
    freq.put("tae", 444);
    freq.put("taf", 399);
    freq.put("tag", 801);
    freq.put("eno", 2247);
    freq.put("tab", 681);
    freq.put("tac", 177);
    freq.put("tal", 9875);
    freq.put("tam", 31263);
    freq.put("sed", 159);
    freq.put(" Do\u0302", 481);
    freq.put("Mis", 141);
    freq.put("tak", 18285);
    freq.put(" va", 276);
    freq.put("sir", 233);
    freq.put("afo", 576);
    freq.put(" ve", 153);
    freq.put("afi", 865);
    freq.put("Yo", 1349);
    freq.put("sit", 1781);
    freq.put("Ya", 233);
    freq.put("afe", 133);
    freq.put("aff", 141);
    freq.put("uzk", 3402);
    freq.put("Ye", 164);
    freq.put("afa", 2878);
    freq.put(" vo", 221);
    freq.put("Mit", 157);
    freq.put("sic", 145);
    freq.put("sib", 219);
    freq.put("sia", 4506);
    freq.put("enp", 1606);
    freq.put("sig", 316);
    freq.put("sie", 2276);
    freq.put("dg", 314);
    freq.put("sik", 4135);
    freq.put("Fe\u0301", 111);
    freq.put("Yu", 192);
    freq.put("\u03bc", 233);
    freq.put("afr", 334);
    freq.put("Yv", 208);
    freq.put("Eko", 224);
    freq.put("sis", 2072);
    freq.put("npo", 1351);
    freq.put("npi", 336);
    freq.put("acu", 160);
    freq.put("Eki", 655);
    freq.put("npe", 1521);
    freq.put("act", 1592);
    freq.put("npa", 532);
    freq.put("uak", 3352);
    freq.put("Q", 1167);
    freq.put("tsu", 3293);
    freq.put("ta ", 64927);
    freq.put("mi ", 314);
    freq.put("goi", 1856);
    freq.put("npr", 973);
    freq.put("dd ", 135);
    freq.put("Ono", 139);
    freq.put("hia", 1281);
    freq.put("ndu", 36540);
    freq.put("tos", 463);
    freq.put("Ond", 186);
    freq.put("enr", 290);
    freq.put(" vi", 176);
    freq.put("hic", 295);
    freq.put("mei", 212);
    freq.put("siz", 297);
    freq.put(" Re\u0301", 151);
    freq.put("n\u0303ea", 278);
    freq.put("VI ", 183);
    freq.put("da ", 83681);
    freq.put("kun", 4291);
    freq.put("n\u0303ek", 147);
    freq.put("top", 659);
    freq.put("ens", 1539);
    freq.put("xag", 128);
    freq.put("lgu", 141);
    freq.put("dw", 263);
    freq.put("lf", 1145);
    freq.put("lg", 2023);
    freq.put("ld", 63524);
    freq.put("le", 105272);
    freq.put("lb", 3705);
    freq.put("lc", 483);
    freq.put("euk", 128);
    freq.put("la", 65016);
    freq.put("ln", 225);
    freq.put("\u0628", 429);
    freq.put("ll", 14813);
    freq.put("lm", 2191);
    freq.put("lj", 263);
    freq.put("lk", 11786);
    freq.put("lh", 523);
    freq.put("li", 47744);
    freq.put("lv", 1388);
    freq.put("lw", 166);
    freq.put("lt", 11988);
    freq.put("lu", 13777);
    freq.put("ls", 1249);
    freq.put("lp", 1461);
    freq.put("eut", 239);
    freq.put("re ", 19143);
    freq.put("euv", 304);
    freq.put("lz", 205);
    freq.put("eus", 5316);
    freq.put("ly", 1619);
    freq.put("dad", 591);
    freq.put("dae", 7409);
    freq.put("dag", 46918);
    freq.put("dab", 383);
    freq.put("dac", 1167);
    freq.put("Cas", 692);
    freq.put("Iba", 263);
    freq.put("dan", 1747);
    freq.put("Cap", 209);
    freq.put("u\u0301 ", 187);
    freq.put("Ibe", 221);
    freq.put("Cau", 156);
    freq.put("Cat", 248);
    freq.put("dat", 4371);
    freq.put("dau", 2348);
    freq.put("Cai", 113);
    freq.put("\u05d5", 119);
    freq.put("Can", 647);
    freq.put("Cam", 634);
    freq.put("Cal", 1977);
    freq.put("Cab", 148);
    freq.put("daz", 3020);
    freq.put("Cad", 128);
    freq.put("Pre", 388);
    freq.put("uev", 148);
    freq.put("Sai", 5007);
    freq.put("nya", 287);
    freq.put("Pra", 311);
    freq.put("San", 2399);
    freq.put("c\u0327", 407);
    freq.put("Sal", 766);
    freq.put("nfo", 733);
    freq.put("Sab", 129);
    freq.put("Pro", 1149);
    freq.put("nfl", 131);
    freq.put("Pri", 464);
    freq.put("eu ", 330);
    freq.put(" hu", 1046);
    freq.put("ema", 8298);
    freq.put("Pru", 183);
    freq.put(" hi", 13695);
    freq.put("Sax", 145);
    freq.put(" ho", 6235);
    freq.put("sim", 204);
    freq.put("Sas", 116);
    freq.put("Sar", 1149);
    freq.put(" ha", 15787);
    freq.put("sil", 990);
    freq.put("onk", 362);
    freq.put("Sav", 636);
    freq.put(" he", 11845);
    freq.put("Sat", 139);
    freq.put("oze", 1252);
    freq.put("lie", 1726);
    freq.put("oui", 410);
    freq.put("tot", 514);
    freq.put("lfa", 358);
    freq.put("oun", 317);
    freq.put("ec ", 189);
    freq.put("ouc", 291);
    freq.put("emi", 1594);
    freq.put("oua", 149);
    freq.put("oug", 264);
    freq.put("oue", 152);
    freq.put("oud", 180);
    freq.put("hlo", 1029);
    freq.put("ouz", 161);
    freq.put("Dio", 112);
    freq.put("oux", 333);
    freq.put("bax", 116);
    freq.put("sob", 130);
    freq.put("our", 2427);
    freq.put("hle", 145);
    freq.put("oup", 179);
    freq.put("oxe", 134);
    freq.put("bu ", 155);
    freq.put("out", 459);
    freq.put("rez", 4457);
    freq.put("rey", 281);
    freq.put("zar", 6420);
    freq.put("la\u0301", 134);
    freq.put("rer", 1714);
    freq.put("res", 7061);
    freq.put("Tur", 461);
    freq.put("li\u0301", 113);
    freq.put("rev", 255);
    freq.put("ute", 9518);
    freq.put("le\u0300", 695);
    freq.put("le\u0301", 417);
    freq.put("ase", 1361);
    freq.put("rek", 7795);
    freq.put("reh", 258);
    freq.put("cra", 135);
    freq.put("ren", 57161);
    freq.put("reo", 216);
    freq.put("rel", 1168);
    freq.put("rem", 1526);
    freq.put("reb", 423);
    freq.put("rec", 235);
    freq.put("rea", 5485);
    freq.put("ref", 864);
    freq.put("reg", 3035);
    freq.put("\u043f", 143);
    freq.put("emp", 192);
    freq.put("lob", 424);
    freq.put("maz", 985);
    freq.put("lf ", 110);
    freq.put("eca", 138);
    freq.put("vak", 167);
    freq.put("eco", 286);
    freq.put("ixa", 122);
    freq.put("ou ", 585);
    freq.put("eck", 189);
    freq.put("oka", 5664);
    freq.put("eci", 177);
    freq.put("ech", 649);
    freq.put("qua", 275);
    freq.put("ecu", 151);
    freq.put("ehu", 489);
    freq.put("que", 1375);
    freq.put("ie ", 1575);
    freq.put("qui", 483);
    freq.put("sni", 281);
    freq.put("oni", 6318);
    freq.put("rci", 264);
    freq.put("zap", 297);
    freq.put("Ipa", 1240);
    freq.put("lod", 422);
    freq.put("g", 194786);
    freq.put("emy", 190);
    freq.put("uha", 2168);
    freq.put("hes", 714);
    freq.put("put", 783);
    freq.put("mac", 227);
    freq.put("bak", 3303);
    freq.put("n\u0303a", 982);
    freq.put("un\u0303a", 238);
    freq.put("lta", 966);
    freq.put("mab", 228);
    freq.put("n\u0303e", 634);
    freq.put("lte", 571);
    freq.put("lok", 422);
    freq.put("Ess", 209);
    freq.put("bai", 7451);
    freq.put("lto", 617);
    freq.put("u\u0308", 636);
    freq.put("n\u0303o", 321);
    freq.put("Sao\u0302", 1077);
    freq.put("Xia\u0300", 110);
    freq.put("K ", 469);
    freq.put("mag", 822);
    freq.put("uli", 995);
    freq.put("un\u0303e", 454);
    freq.put("rs ", 1994);
    freq.put("seu", 341);
    freq.put("ihu", 414);
    freq.put("npu", 200);
    freq.put("ud ", 222);
    freq.put("cy ", 306);
    freq.put("iho", 241);
    freq.put("lph", 125);
    freq.put("art", 52635);
    freq.put("iha", 384);
    freq.put("og ", 109);
    freq.put("ihe", 190);
    freq.put("has", 2581);
    freq.put(" Sy", 259);
    freq.put("ao ", 342);
    freq.put("arv", 202);
    freq.put("asi", 3937);
    freq.put(" Sp", 735);
    freq.put("nda", 11174);
    freq.put(" St", 1657);
    freq.put(" Su", 1637);
    freq.put(" Sk", 123);
    freq.put(" Sh", 1015);
    freq.put(" Si", 1935);
    freq.put(" So", 2830);
    freq.put(" Sl", 127);
    freq.put("ary", 240);
    freq.put("mno", 287);
    freq.put(" Sc", 1747);
    freq.put("\u03bb", 400);
    freq.put(" Sa", 12748);
    freq.put("arz", 155);
    freq.put("mer", 3360);
    freq.put(" Se", 3599);
    freq.put("Ka", 4370);
    freq.put("rso", 234);
    freq.put("rsh", 119);
    freq.put("rsi", 579);
    freq.put("Ke", 755);
    freq.put("eit", 1960);
    freq.put("ogu", 264);
    freq.put("rse", 377);
    freq.put("Ki", 1106);
    freq.put("Kh", 198);
    freq.put("Ko", 3438);
    freq.put("rsa", 310);
    freq.put("rsb", 123);
    freq.put("Kl", 325);
    freq.put("Kr", 801);
    freq.put("ogo", 1114);
    freq.put("R", 9657);
    freq.put("ogi", 3112);
    freq.put("Ku", 829);
    freq.put("eho", 226);
    freq.put("rst", 238);
    freq.put("udi", 1792);
    freq.put("oga", 472);
    freq.put("hau", 3280);
    freq.put("lim", 313);
    freq.put("vie", 427);
    freq.put("bek", 859);
    freq.put("beh", 2621);
    freq.put("bei", 305);
    freq.put("ben", 1757);
    freq.put("bel", 1463);
    freq.put("bec", 150);
    freq.put("bea", 507);
    freq.put("beg", 284);
    freq.put("bed", 218);
    freq.put("rca", 271);
    freq.put("bez", 2002);
    freq.put("ses", 1995);
    freq.put("ik ", 16195);
    freq.put("de\u0301e", 208);
    freq.put("ber", 19208);
    freq.put("bes", 5139);
    freq.put("ehi", 2102);
    freq.put("thr", 250);
    freq.put("bet", 1729);
    freq.put("buz", 1067);
    freq.put("Par", 2304);
    freq.put("Edi", 139);
    freq.put("Pat", 265);
    freq.put("Pau", 404);
    freq.put("nqu", 144);
    freq.put("xab", 132);
    freq.put("arg", 3519);
    freq.put("oti", 1497);
    freq.put("Ped", 255);
    freq.put("Pac", 140);
    freq.put("sen", 2206);
    freq.put("le ", 29964);
    freq.put("Pal", 580);
    freq.put("sem", 882);
    freq.put("Pan", 351);
    freq.put("eal", 880);
    freq.put("sk", 52536);
    freq.put("mik", 1980);
    freq.put("sel", 1814);
    freq.put("obe", 1621);
    freq.put("ck ", 966);
    freq.put("som", 367);
    freq.put("ghe", 212);
    freq.put("\u0629", 205);
    freq.put("sek", 1181);
    freq.put("mic", 192);
    freq.put("mie", 282);
    freq.put("sut", 122);
    freq.put("inv", 181);
    freq.put("bur", 7454);
    freq.put(" Se\u0300", 285);
    freq.put(" Se\u0301", 155);
    freq.put("i\u0301n ", 239);
    freq.put("sei", 1006);
    freq.put("bus", 313);
    freq.put("\u4e39", 146);
    freq.put("mis", 679);
    freq.put("mir", 441);
    freq.put("Ois", 735);
    freq.put("mit", 1601);
    freq.put("Dia", 142);
    freq.put("gha", 252);
    freq.put(" El", 2228);
    freq.put(" Em", 587);
    freq.put(" En", 1209);
    freq.put(" Ei", 282);
    freq.put(" Ek", 1058);
    freq.put(" Ed", 572);
    freq.put(" Eg", 1300);
    freq.put(" Ea", 161);
    freq.put(" Eb", 127);
    freq.put(" Ec", 112);
    freq.put("sfo", 111);
    freq.put("zko", 8159);
    freq.put(" Ex", 211);
    freq.put("but", 176);
    freq.put(" Ez", 526);
    freq.put("st ", 1348);
    freq.put(" Et", 695);
    freq.put(" Eu", 5218);
    freq.put(" Ev", 121);
    freq.put("sfe", 412);
    freq.put(" Ep", 193);
    freq.put("ny ", 1034);
    freq.put(" Er", 7880);
    freq.put(" Es", 7460);
    freq.put("cke", 298);
    freq.put("ure", 3312);
    freq.put("urg", 1560);
    freq.put("mus", 3234);
    freq.put("urb", 881);
    freq.put("urc", 233);
    freq.put("url", 279);
    freq.put("lpa", 119);
    freq.put("Pot", 148);
    freq.put("Pou", 137);
    freq.put("Por", 717);
    freq.put("Pos", 133);
    freq.put("Pop", 124);
    freq.put("urk", 2210);
    freq.put("Pon", 385);
    freq.put("uru", 8984);
    freq.put("Pol", 1076);
    freq.put("Pom", 111);
    freq.put("urp", 319);
    freq.put("urr", 7898);
    freq.put("Poi", 164);
    freq.put("Del", 171);
    freq.put("ury", 170);
    freq.put("Dem", 199);
    freq.put("ngl", 421);
    freq.put("Den", 399);
    freq.put("ah ", 241);
    freq.put("Cha", 3073);
    freq.put("toa", 986);
    freq.put("ioz", 931);
    freq.put("bum", 126);
    freq.put("clo", 110);
    freq.put("sze", 109);
    freq.put("\u0410", 116);
    freq.put("run\u0303", 573);
    freq.put("Pe\u0301", 178);
    freq.put("eas", 238);
    freq.put("leg", 2211);
    freq.put("eda", 1186);
    freq.put("nge", 3635);
    freq.put(" iz", 22098);
    freq.put("ear", 5919);
    freq.put("jaz", 157);
    freq.put("nga", 2908);
    freq.put("co ", 929);
    freq.put(" ip", 2762);
    freq.put("Mor", 687);
    freq.put(" ir", 5256);
    freq.put(" is", 831);
    freq.put(" it", 3666);
    freq.put("jas", 739);
    freq.put("Mou", 317);
    freq.put("Pse", 223);
    freq.put(" ih", 124);
    freq.put("q ", 190);
    freq.put("jal", 123);
    freq.put(" ik", 2938);
    freq.put(" il", 408);
    freq.put(" im", 117);
    freq.put(" in", 7560);
    freq.put("Mol", 190);
    freq.put("ie\u0300g", 369);
    freq.put(" ia", 184);
    freq.put(" ib", 2762);
    freq.put(" id", 4126);
    freq.put("ngy", 127);
    freq.put("ngz", 152);
    freq.put(" ig", 680);
    freq.put("oto", 1274);
    freq.put(" \u0421", 176);
    freq.put("no ", 4249);
    freq.put("lga", 398);
    freq.put("tbo", 740);
    freq.put("mul", 1435);
    freq.put("Kan", 885);
    freq.put("lei", 663);
    freq.put("Cho", 209);
    freq.put(" we", 277);
    freq.put("qu", 2270);
    freq.put("aet", 117);
    freq.put("uza", 960);
    freq.put("h", 111048);
    freq.put("lst", 144);
    freq.put("niz", 435);
    freq.put(" \u0412", 111);
    freq.put("sha", 293);
    freq.put(" \u0410", 116);
    freq.put("Zie", 209);
    freq.put("she", 237);
    freq.put("Kam", 110);
    freq.put("qi", 160);
    freq.put("shi", 909);
    freq.put("aem", 396);
    freq.put("ael", 880);
    freq.put("ja ", 330);
    freq.put("Jak", 114);
    freq.put("Pr", 2635);
    freq.put("Ps", 373);
    freq.put("ebg", 158);
    freq.put("eba", 3556);
    freq.put("Pt", 120);
    freq.put("Pu", 1219);
    freq.put("Py", 117);
    freq.put("vis", 236);
    freq.put("C", 24793);
    freq.put("ke ", 1678);
    freq.put("jo ", 284);
    freq.put("ebu", 253);
    freq.put("Zor", 154);
    freq.put("Pa", 5996);
    freq.put("ebr", 497);
    freq.put("Pe", 2734);
    freq.put("ede", 1453);
    freq.put("Ph", 767);
    freq.put("Pi", 2764);
    freq.put("Po", 3314);
    freq.put("Pl", 1086);
    freq.put("lve", 149);
    freq.put("lur", 2397);
    freq.put("lus", 2243);
    freq.put("lut", 259);
    freq.put("ome", 4236);
    freq.put("\u0627", 1078);
    freq.put("lux", 127);
    freq.put("en\u0303", 229);
    freq.put("luz", 1919);
    freq.put("Jac", 241);
    freq.put("wo", 287);
    freq.put("et ", 5547);
    freq.put("lel", 174);
    freq.put("lue", 348);
    freq.put("\u043b", 615);
    freq.put("luk", 181);
    freq.put("lul", 394);
    freq.put("omi", 2449);
    freq.put("rpi", 260);
    freq.put("keo", 173);
    freq.put("ken", 1434);
    freq.put("jor", 115);
    freq.put("kel", 306);
    freq.put("jot", 496);
    freq.put("kei", 150);
    freq.put("eul", 175);
    freq.put("omo", 1653);
    freq.put("kee", 629);
    freq.put("sho", 242);
    freq.put("kea", 556);
    freq.put("joa", 281);
    freq.put("S", 30092);
    freq.put("eun", 111);
    freq.put("wi", 721);
    freq.put("vre", 805);
    freq.put("eui", 361);
    freq.put("jok", 1248);
    freq.put("jol", 254);
    freq.put("ker", 2731);
    freq.put("etr", 5219);
    freq.put("ets", 1121);
    freq.put("Zal", 136);
    freq.put("cak", 136);
    freq.put("loa", 880);
    freq.put("lly", 586);
    freq.put("Zah", 179);
    freq.put("etu", 368);
    freq.put("etz", 1163);
    freq.put("e\u0300", 4480);
    freq.put("etx", 2177);
    freq.put("jia", 219);
    freq.put("Zab", 118);
    freq.put("sov", 121);
    freq.put("jin", 276);
    freq.put("tla", 841);
    freq.put("eta", 71146);
    freq.put("tle", 497);
    freq.put("lo", 23311);
    freq.put(" Il", 575);
    freq.put("eth", 290);
    freq.put("eti", 4795);
    freq.put("Zar", 377);
    freq.put("eto", 1392);
    freq.put("uns", 142);
    freq.put("ck", 1858);
    freq.put("aa", 638);
    freq.put("ci", 5204);
    freq.put("ch", 8436);
    freq.put("co", 4763);
    freq.put("Log", 117);
    freq.put("Her", 3806);
    freq.put("cl", 657);
    freq.put("cc", 457);
    freq.put("\u0432\u0438", 184);
    freq.put("ca", 4335);
    freq.put("Loi", 2917);
    freq.put("Lon", 848);
    freq.put("rva", 299);
    freq.put("ce", 4449);
    freq.put("Lor", 274);
    freq.put("Los", 296);
    freq.put("cy", 423);
    freq.put("Est", 2782);
    freq.put("rpe", 728);
    freq.put("lis", 2569);
    freq.put("Lot", 763);
    freq.put("Lou", 492);
    freq.put(" Fe\u0301", 110);
    freq.put("cr", 939);
    freq.put("cq", 317);
    freq.put("ucl", 185);
    freq.put("pzi", 136);
    freq.put("Hei", 184);
    freq.put("cu", 1624);
    freq.put("ct", 2467);
    freq.put(" ap", 2038);
    freq.put("vit", 352);
    freq.put("Jua", 434);
    freq.put("An ", 143);
    freq.put("rve", 398);
    freq.put("Get", 138);
    freq.put("Esp", 2765);
    freq.put("Jun", 115);
    freq.put("Jul", 330);
    freq.put("yar", 131);
    freq.put("Jur", 582);
    freq.put("Hon", 528);
    freq.put("yan", 296);
    freq.put("nu ", 553);
    freq.put("rko", 637);
    freq.put("Gek", 939);
    freq.put("Geh", 141);
    freq.put("Geo", 759);
    freq.put("Gen", 514);
    freq.put("\u03bf", 715);
    freq.put(" au", 6652);
    freq.put("oth", 414);
    freq.put("ao\u0302n", 1078);
    freq.put("Hom", 153);
    freq.put("lgo", 926);
    freq.put("ilg", 475);
    freq.put("inp", 1720);
    freq.put("c ", 2780);
    freq.put("edo", 12587);
    freq.put("ild", 890);
    freq.put("oha", 408);
    freq.put("otx", 166);
    freq.put("oty", 475);
    freq.put("otz", 3173);
    freq.put("cor", 390);
    freq.put("tt ", 158);
    freq.put("cou", 1017);
    freq.put("otr", 282);
    freq.put("pig", 222);
    freq.put("ott", 442);
    freq.put("otu", 1228);
    freq.put("cot", 155);
    freq.put("And", 973);
    freq.put("lli", 1822);
    freq.put("Ang", 544);
    freq.put("Ana", 309);
    freq.put("ndr", 2320);
    freq.put("e\u0301", 6456);
    freq.put("onz", 159);
    freq.put("Ann", 178);
    freq.put("Ano", 454);
    freq.put("Hot", 121);
    freq.put("Ant", 1538);
    freq.put("rpo", 196);
    freq.put("Hou", 158);
    freq.put("rbi", 2074);
    freq.put("\u4e07 ", 297);
    freq.put("Esc", 150);
    freq.put("rbe", 1362);
    freq.put("eur", 2218);
    freq.put("ya ", 555);
    freq.put("rba", 974);
    freq.put("yst", 148);
    freq.put("bir", 655);
    freq.put("va", 4080);
    freq.put(" Fr", 34376);
    freq.put(" Fu", 636);
    freq.put("ve", 4565);
    freq.put("ci\u0301", 127);
    freq.put("\u5009", 119);
    freq.put("vi", 5771);
    freq.put("ink", 1408);
    freq.put("vo", 1538);
    freq.put(" Fa", 936);
    freq.put("e\u0304", 126);
    freq.put("vs", 130);
    freq.put(" Fe", 1297);
    freq.put("vu", 143);
    freq.put(" Fi", 1595);
    freq.put("vy", 165);
    freq.put(" Fl", 773);
    freq.put(" Fo", 1533);
    freq.put("io ", 8484);
    freq.put("of ", 673);
    freq.put("pis", 933);
    freq.put("tas", 3495);
    freq.put("edr", 806);
    freq.put("pit", 729);
    freq.put("vo ", 165);
    freq.put("unb", 140);
    freq.put("iol", 1372);
    freq.put("etn", 393);
    freq.put("utu", 1500);
    freq.put("Car", 985);
    freq.put("oxa", 143);
    freq.put("ziz", 641);
    freq.put("tie", 8056);
    freq.put("xir", 793);
    freq.put("Ob", 229);
    freq.put("cod", 133);
    freq.put("v ", 481);
    freq.put("xap", 662);
    freq.put("phi", 1924);
    freq.put("fur", 143);
    freq.put("pho", 650);
    freq.put("Zer", 305);
    freq.put("iox", 130);
    freq.put("pha", 737);
    freq.put("iot", 1950);
    freq.put("ios", 459);
    freq.put("ior", 622);
    freq.put("phe", 439);
    freq.put("iop", 428);
    freq.put("ion", 6034);
    freq.put("phy", 150);
    freq.put("jat", 1353);
    freq.put("iok", 992);
    freq.put("ioi", 472);
    freq.put("uni", 2485);
    freq.put("iog", 146);
    freq.put("ioe", 954);
    freq.put("iod", 290);
    freq.put("ioc", 123);
    freq.put("iob", 288);
    freq.put("ioa", 6380);
    freq.put("pht", 217);
    freq.put("lev", 222);
    freq.put("ont", 7687);
    freq.put("off", 123);
    freq.put("toe", 252);
    freq.put(" Ty", 618);
    freq.put(" Tx", 2595);
    freq.put("i", 893736);
    freq.put(" Tu", 917);
    freq.put("ofi", 1327);
    freq.put(" Tr", 2477);
    freq.put("sbu", 282);
    freq.put("col", 516);
    freq.put(" To", 2450);
    freq.put(" Ti", 988);
    freq.put(" Th", 1731);
    freq.put("dap", 284);
    freq.put(" Te", 1895);
    freq.put("uno", 187);
    freq.put("ron", 4833);
    freq.put(" Ta", 2484);
    freq.put("hol", 600);
    freq.put("onu", 301);
    freq.put("isu", 768);
    freq.put("dar", 7697);
    freq.put("xeb", 306);
    freq.put("lso", 139);
    freq.put("xen", 218);
    freq.put("das", 372);
    freq.put("tei", 891);
    freq.put("utx", 862);
    freq.put("xek", 523);
    freq.put("xet", 179);
    freq.put("\u4e4b ", 273);
    freq.put("oai", 315);
    freq.put("tch", 169);
    freq.put("nou", 160);
    freq.put("mui", 219);
    freq.put("lex", 439);
    freq.put("\u0435\u0440", 141);
    freq.put("ist", 19392);
    freq.put("sku", 35531);
    freq.put("Be", 8067);
    freq.put("adu", 1159);
    freq.put("adr", 1175);
    freq.put("Ba", 9918);
    freq.put(" \u0645", 129);
    freq.put("Bl", 641);
    freq.put(" xa", 124);
    freq.put("Bo", 3491);
    freq.put("oes", 154);
    freq.put("Bi", 4638);
    freq.put(" xe", 141);
    freq.put("the", 2245);
    freq.put("ske", 1695);
    freq.put("Bu", 1690);
    freq.put("ger", 4696);
    freq.put("ade", 1430);
    freq.put("\u0432 ", 122);
    freq.put("Br", 3204);
    freq.put("ada", 3736);
    freq.put("ado", 2055);
    freq.put("sko", 4744);
    freq.put("ha\u0304", 111);
    freq.put("ski", 965);
    freq.put("\u043c", 252);
    freq.put("adi", 3700);
    freq.put("psa", 122);
    freq.put("Hyd", 269);
    freq.put(" \u0627", 406);
    freq.put(" \u0628", 155);
    freq.put("nfe", 453);
    freq.put("igo", 1186);
    freq.put("lla", 2591);
    freq.put("T", 16850);
    freq.put("Lau", 560);
    freq.put("lu ", 1176);
    freq.put("nvi", 456);
    freq.put("nde\u0301", 266);
    freq.put("B ", 768);
    freq.put("l ", 19248);
    freq.put(" mu", 7219);
    freq.put(" x ", 114);
    freq.put("\u0435\u0432", 111);
    freq.put("igi", 1126);
    freq.put("ad ", 651);
    freq.put("ho\u0304", 150);
    freq.put("isi", 1862);
    freq.put("igh", 367);
    freq.put("i\u0301o ", 118);
    freq.put("Sue", 239);
    freq.put("iag", 1598);
    freq.put("Qu\u0304 ", 204);
    freq.put("nje", 125);
    freq.put("gur", 3120);
    freq.put("goa", 4107);
    freq.put("nji", 179);
    freq.put("Sul", 122);
    freq.put("Sui", 315);
    freq.put("Sur", 139);
    freq.put("X", 2077);
    freq.put("ish", 426);
    freq.put("vsk", 110);
    freq.put("U ", 162);
    freq.put("tum", 153);
    freq.put("esu", 1628);
    freq.put("est", 11662);
    freq.put("ess", 912);
    freq.put("ubr", 1485);
    freq.put("esp", 3014);
    freq.put("nd ", 1618);
    freq.put("Be\u0301", 204);
    freq.put("dia", 9396);
    freq.put("esf", 120);
    freq.put("ese", 3688);
    freq.put("esc", 377);
    freq.put("iso", 671);
    freq.put("esa", 3808);
    freq.put("eso", 556);
    freq.put("esn", 776);
    freq.put("esm", 224);
    freq.put("esl", 821);
    freq.put("esk", 37262);
    freq.put("esi", 2406);
    freq.put("esh", 127);
    freq.put("\u043b\u0430", 160);
    freq.put("Uz", 154);
    freq.put("\u4e01\u4e09", 109);
    freq.put("Ut", 139);
    freq.put("\u4e4b", 886);
    freq.put("Us", 185);
    freq.put("Ur", 1743);
    freq.put("Ul", 214);
    freq.put("Un", 1309);
    freq.put("Uh", 348);
    freq.put("Uk", 242);
    freq.put("ha\u0302t", 347);
    freq.put("Ud", 554);
    freq.put("ndi", 10387);
    freq.put("Sco", 113);
    freq.put("go ", 26432);
    freq.put("Sci", 1122);
    freq.put("Sch", 335);
    freq.put("ndo", 4551);
    freq.put(" ju", 380);
    freq.put("nde", 10020);
    freq.put("nos", 1504);
    freq.put("ism", 1753);
    freq.put(" jo", 2357);
    freq.put("kri", 1134);
    freq.put("Sau", 359);
    freq.put("es ", 12081);
    freq.put(" je", 446);
    freq.put("\u4e09 ", 381);
    freq.put("nds", 159);
    freq.put("kra", 849);
    freq.put(" ja", 7967);
    freq.put("o\u0302te", 774);
    freq.put("kre", 293);
    freq.put("own", 214);
    freq.put("owe", 287);
    freq.put("ea ", 21907);
    freq.put("lot", 1891);
    freq.put("a\u0300 ", 197);
    freq.put("zto", 118);
    freq.put("\u0412", 111);
    freq.put("ngt", 258);
    freq.put("h ", 3096);
    freq.put("ton", 2972);
    freq.put("oek", 753);
    freq.put("jak", 490);
    freq.put("Ami", 117);
    freq.put("loe", 182);
    freq.put("vai", 119);
    freq.put("van", 773);
    freq.put("Amo", 119);
    freq.put("yro", 439);
    freq.put("Ama", 372);
    freq.put("rcu", 273);
    freq.put("oul", 669);
    freq.put("Ame", 1656);
    freq.put("yre", 199);
    freq.put("i\u0301a ", 420);
    freq.put("rfo", 144);
    freq.put("rco", 298);
    freq.put("gaz", 2792);
    freq.put("tg", 181);
    freq.put("oub", 647);
    freq.put("var", 579);
    freq.put("Amp", 481);
    freq.put("zka", 3073);
    freq.put("tx ", 291);
    freq.put("yrt", 231);
    freq.put("Luz", 124);
    freq.put("vat", 112);
    freq.put("zor", 775);
    freq.put("o\u0308 ", 127);
    freq.put("eak", 5006);
    freq.put("hy", 1010);
    freq.put("Kla", 112);
    freq.put("ean", 53210);
    freq.put("hr", 1439);
    freq.put("hs", 188);
    freq.put("Der", 132);
    freq.put("Des", 202);
    freq.put("eae", 255);
    freq.put("hw", 153);
    freq.put("ht", 906);
    freq.put("hu", 4025);
    freq.put("buk", 216);
    freq.put("hi", 26055);
    freq.put("hn", 657);
    freq.put("ho", 11118);
    freq.put("hl", 1392);
    freq.put("hm", 308);
    freq.put("jai", 2132);
    freq.put("Deb", 142);
    freq.put("ha", 32541);
    freq.put("eau", 1023);
    freq.put("eat", 764);
    freq.put("he", 25799);
    freq.put("Tei", 132);
    freq.put("dus", 429);
    freq.put("Tel", 274);
    freq.put("vic", 152);
    freq.put("Ten", 223);
    freq.put("Teo", 128);
    freq.put("dmi", 9816);
    freq.put("va ", 528);
    freq.put("j", 17374);
    freq.put("ow ", 180);
    freq.put("gro", 244);
    freq.put("lor", 2845);
    freq.put("lva", 1011);
    freq.put("rij", 116);
    freq.put("Ter", 439);
    freq.put("Tes", 138);
    freq.put("lvi", 156);
    freq.put("Txe", 254);
    freq.put("e\u0302", 267);
    freq.put("pil", 704);
    freq.put("iny", 1050);
    freq.put("pin", 1928);
    freq.put("pio", 428);
    freq.put("int", 13017);
    freq.put("inu", 1280);
    freq.put("\u0f0b", 163);
    freq.put("\u0438\u043d", 111);
    freq.put("Don", 1289);
    freq.put("pie", 488);
    freq.put("rud", 764);
    freq.put("ins", 1000);
    freq.put("inl", 550);
    freq.put("ous", 984);
    freq.put("inn", 283);
    freq.put("ino", 3873);
    freq.put("inh", 165);
    freq.put("ini", 17586);
    freq.put("Lui", 341);
    freq.put("ind", 5098);
    freq.put("ine", 11821);
    freq.put("inf", 881);
    freq.put("ing", 7209);
    freq.put("rrh", 151);
    freq.put("ina", 14551);
    freq.put("inb", 1383);
    freq.put("inc", 1845);
    freq.put("oag", 249);
    freq.put("hn ", 341);
    freq.put("eo ", 860);
    freq.put("eb ", 149);
    freq.put("i\u0301 ", 198);
    freq.put(" Uz", 153);
    freq.put(" Ut", 139);
    freq.put("oan", 5469);
    freq.put("oal", 1996);
    freq.put("oak", 7788);
    freq.put(" Ur", 1698);
    freq.put(" Us", 185);
    freq.put(" Ul", 214);
    freq.put(" Un", 1298);
    freq.put("oat", 134);
    freq.put(" Uh", 347);
    freq.put("Afr", 600);
    freq.put(" Uk", 211);
    freq.put(" Ud", 553);
    freq.put("\u043d", 760);
    freq.put("gau", 1336);
    freq.put("ubu", 129);
    freq.put("Aca", 159);
    freq.put("rqu", 185);
    freq.put("Do\u0302m", 479);
    freq.put("ubs", 680);
    freq.put("pi ", 440);
    freq.put("gas", 712);
    freq.put("Kem", 181);
    freq.put("ho\u0302", 322);
    freq.put("gar", 10218);
    freq.put("oem", 135);
    freq.put("ube", 1089);
    freq.put("he\u0301", 316);
    freq.put("U", 5646);
    freq.put("udo", 382);
    freq.put("ha\u0302", 367);
    freq.put("my ", 184);
    freq.put("ubo", 127);
    freq.put("in ", 15912);
    freq.put("ubi", 1182);
    freq.put("tan", 42023);
    freq.put("eoa", 338);
    freq.put("i\u0301a", 492);
    freq.put("eoe", 128);
    freq.put("eod", 110);
    freq.put(" Iz", 849);
    freq.put("\u4e26 ", 155);
    freq.put("i\u0301o", 159);
    freq.put("i\u0301n", 439);
    freq.put("big", 994);
    freq.put("eon", 704);
    freq.put("eom", 283);
    freq.put("jab", 248);
    freq.put("eor", 1271);
    freq.put("eop", 146);
    freq.put("oih", 139);
    freq.put("i\u0301s", 174);
    freq.put("eot", 118);
    freq.put("uar", 5388);
    freq.put("rep", 4742);
  }
  
}

