package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ET extends CLangProfile {
  private static final String name = "et";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ET() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 4341644;
    n_words[1] = 4941492;
    n_words[2] = 4175920;

    freq.put("\u4e34", 68);
    freq.put("Ja\u0308a\u0308", 129);
    freq.put("fa\u0308a\u0308", 209);
    freq.put("mle", 44);
    freq.put("\u0435\u0438\u0306 ", 78);
    freq.put(" y ", 67);
    freq.put("lmu", 534);
    freq.put("Ja\u0308r", 285);
    freq.put("lmi", 1561);
    freq.put("k", 181311);
    freq.put("lu\u0308k", 99);
    freq.put("A\u0304", 44);
    freq.put("La\u0308", 1080);
    freq.put("Lo\u0303", 671);
    freq.put("Lu\u0308", 129);
    freq.put("dne", 328);
    freq.put("a\u0308lg", 52);
    freq.put("a\u0308le", 277);
    freq.put("a\u0308ld", 112);
    freq.put("a\u0308lj", 1874);
    freq.put("a\u0308li", 683);
    freq.put("dni", 181);
    freq.put("\u042e", 47);
    freq.put("dnu", 82);
    freq.put("a\u0308lu", 94);
    freq.put("a\u0308lt", 126);
    freq.put("jms", 73);
    freq.put("Pa\u0308r", 428);
    freq.put("lu\u0308h", 844);
    freq.put("Pa\u0308i", 111);
    freq.put("Le", 1403);
    freq.put("\u0412\u0430", 94);
    freq.put("La", 1509);
    freq.put("Lo", 1151);
    freq.put("\u0412\u0438", 55);
    freq.put("Li", 2750);
    freq.put("Lu", 547);
    freq.put("Ly", 58);
    freq.put("hof", 75);
    freq.put("hod", 56);
    freq.put("hoe", 47);
    freq.put("hob", 86);
    freq.put("hon", 119);
    freq.put("hoo", 630);
    freq.put("hol", 538);
    freq.put("hom", 193);
    freq.put("lu\u0308m", 359);
    freq.put("\u03b1\u0301", 69);
    freq.put("hoi", 327);
    freq.put("hov", 70);
    freq.put("hot", 60);
    freq.put("hou", 76);
    freq.put("hor", 259);
    freq.put("hos", 103);
    freq.put("hop", 48);
    freq.put("A", 13995);
    freq.put("\u0645", 185);
    freq.put("L ", 301);
    freq.put("O\u0308", 167);
    freq.put("Pa\u0308a\u0308", 51);
    freq.put("\u03bf\u03c2 ", 107);
    freq.put("ho ", 78);
    freq.put("u\u0304", 213);
    freq.put(" V ", 98);
    freq.put("fir", 227);
    freq.put("ro\u0303", 329);
    freq.put("ro\u0308", 278);
    freq.put("His", 301);
    freq.put("fit", 113);
    freq.put("uot", 45);
    freq.put("ru\u0308", 1335);
    freq.put("smo\u0303", 57);
    freq.put("rø", 55);
    freq.put("ra\u0308", 668);
    freq.put("fic", 72);
    freq.put("fia", 527);
    freq.put("fid", 70);
    freq.put("fie", 44);
    freq.put("o\u0303mm", 206);
    freq.put("ri\u0301", 55);
    freq.put("fii", 98);
    freq.put("Hil", 89);
    freq.put("re\u0301", 93);
    freq.put("Hin", 100);
    freq.put("uol", 59);
    freq.put(" Va", 3308);
    freq.put(" Ve", 2347);
    freq.put("upo", 146);
    freq.put(" Vi", 1878);
    freq.put(" Vl", 115);
    freq.put(" Vo", 452);
    freq.put(" Vu", 47);
    freq.put("ata\u0308", 55);
    freq.put("ato\u0308", 93);
    freq.put("fi ", 130);
    freq.put("ato\u0303", 66);
    freq.put("atu\u0308", 106);
    freq.put("upa", 311);
    freq.put("rt", 7363);
    freq.put("ru", 7114);
    freq.put("rv", 5729);
    freq.put("rw", 105);
    freq.put("rp", 648);
    freq.put("rr", 3973);
    freq.put("rs", 3109);
    freq.put("smu", 122);
    freq.put("dsu", 120);
    freq.put("ry", 602);
    freq.put("rz", 159);
    freq.put("Uur", 54);
    freq.put("rd", 6093);
    freq.put("re", 19761);
    freq.put("rf", 347);
    freq.put("rg", 9073);
    freq.put("ra", 27209);
    freq.put("rb", 1857);
    freq.put("dsi", 69);
    freq.put("rl", 1539);
    freq.put("rm", 4085);
    freq.put("rn", 3712);
    freq.put("ro", 11751);
    freq.put("rh", 803);
    freq.put("ri", 41739);
    freq.put("rj", 4639);
    freq.put("rk", 3920);
    freq.put(" Va\u0308", 632);
    freq.put("Egi", 118);
    freq.put(" Vo\u0303", 412);
    freq.put("Ege", 46);
    freq.put("ate", 6661);
    freq.put("ata", 5828);
    freq.put("atn", 57);
    freq.put("ato", 1488);
    freq.put("atl", 435);
    freq.put("atm", 137);
    freq.put("atk", 174);
    freq.put("ath", 254);
    freq.put("ati", 3865);
    freq.put("atv", 82);
    freq.put("att", 452);
    freq.put("atu", 6581);
    freq.put("r ", 11002);
    freq.put("ats", 3184);
    freq.put("ds ", 128);
    freq.put("sm ", 509);
    freq.put("Hu\u0308d", 45);
    freq.put("\u044b\u0438\u0306", 89);
    freq.put("Cen", 74);
    freq.put("xim", 52);
    freq.put("nz ", 90);
    freq.put("xi ", 91);
    freq.put("i\u0301", 335);
    freq.put("nza", 48);
    freq.put("nze", 88);
    freq.put("nzi", 54);
    freq.put("a\u0308es", 339);
    freq.put("fu\u0308u\u0308", 427);
    freq.put("e\u0307", 44);
    freq.put("Ass", 139);
    freq.put("\u30a2", 442);
    freq.put("Asu", 1049);
    freq.put("Ast", 103);
    freq.put("Ase", 89);
    freq.put("Sou", 50);
    freq.put("\u0445", 292);
    freq.put("nel", 854);
    freq.put("ra\u0304", 49);
    freq.put("ats\u030c", 101);
    freq.put("lpt", 60);
    freq.put("lpo", 71);
    freq.put("lpi", 167);
    freq.put("neg", 216);
    freq.put("lpe", 157);
    freq.put("\u1100\u1161 ", 51);
    freq.put("iru\u0308", 49);
    freq.put("\u0441\u043e\u0432", 48);
    freq.put("ldm", 61);
    freq.put("dr ", 97);
    freq.put("X", 461);
    freq.put("Ris", 101);
    freq.put("Rin", 80);
    freq.put("nep", 231);
    freq.put("Rii", 508);
    freq.put("Rid", 55);
    freq.put("Ric", 153);
    freq.put("meg", 594);
    freq.put("irs", 78);
    freq.put("irt", 114);
    freq.put("iru", 697);
    freq.put("irv", 50);
    freq.put("iri", 2513);
    freq.put("irj", 2489);
    freq.put("irk", 973);
    freq.put("irl", 76);
    freq.put("irm", 315);
    freq.put("irn", 410);
    freq.put("iro", 264);
    freq.put("ira", 660);
    freq.put("irc", 67);
    freq.put("ird", 488);
    freq.put("ire", 897);
    freq.put("irg", 342);
    freq.put("cur", 49);
    freq.put("ir ", 371);
    freq.put("pre", 785);
    freq.put("fra", 194);
    freq.put("fre", 107);
    freq.put("fri", 412);
    freq.put("fro", 53);
    freq.put("pro", 2923);
    freq.put("a\u0308a\u0308", 6210);
    freq.put("pru", 93);
    freq.put("rgk", 63);
    freq.put("Oo", 46);
    freq.put("a\u0308 ", 222);
    freq.put("Dio", 47);
    freq.put("tze", 47);
    freq.put("tzi", 57);
    freq.put("a\u0308ne", 1640);
    freq.put("a\u0308nd", 528);
    freq.put("a\u0308ng", 1228);
    freq.put("a\u0308na", 797);
    freq.put("a\u0308nn", 112);
    freq.put("a\u0308ni", 236);
    freq.put("dha", 80);
    freq.put("a\u0308nu", 150);
    freq.put("\u0441", 1744);
    freq.put("a\u0308o", 127);
    freq.put("a\u0308l", 3418);
    freq.put("a\u0308m", 341);
    freq.put("a\u0308k", 203);
    freq.put("a\u0308h", 3974);
    freq.put("a\u0308i", 4721);
    freq.put("a\u0308g", 1326);
    freq.put("a\u0308d", 252);
    freq.put("a\u0308e", 2551);
    freq.put("a\u0308b", 871);
    freq.put("tz ", 121);
    freq.put("a\u0308v", 318);
    freq.put("a\u0308t", 739);
    freq.put("a\u0308r", 10885);
    freq.put("a\u0308s", 977);
    freq.put("a\u0308p", 377);
    freq.put("upo\u0303", 82);
    freq.put("vka", 64);
    freq.put("olu\u0308", 473);
    freq.put("bit", 234);
    freq.put("hai", 439);
    freq.put("haj", 90);
    freq.put("hak", 332);
    freq.put("hal", 1865);
    freq.put("ham", 380);
    freq.put("han", 1084);
    freq.put("mo\u0303r", 58);
    freq.put("haa", 386);
    freq.put("hab", 58);
    freq.put("had", 171);
    freq.put("hae", 123);
    freq.put("haf", 57);
    freq.put("hag", 90);
    freq.put("mo\u0303e", 265);
    freq.put("uma\u0308", 125);
    freq.put("hap", 399);
    freq.put("mo\u0303l", 89);
    freq.put("har", 1689);
    freq.put("has", 829);
    freq.put("hat", 244);
    freq.put("hau", 155);
    freq.put("hav", 82);
    freq.put("mo\u0303j", 443);
    freq.put("ha ", 1068);
    freq.put("bn ", 58);
    freq.put("ola", 1318);
    freq.put("old", 420);
    freq.put("ole", 2988);
    freq.put("olf", 126);
    freq.put("olg", 132);
    freq.put("oli", 8483);
    freq.put("olj", 64);
    freq.put(" X ", 95);
    freq.put("oll", 1578);
    freq.put("olm", 1122);
    freq.put("oln", 368);
    freq.put("olo", 2600);
    freq.put("ols", 1007);
    freq.put("olt", 1144);
    freq.put("olu", 1563);
    freq.put("\u0417", 71);
    freq.put("jm ", 66);
    freq.put("fot", 258);
    freq.put("ump", 59);
    freq.put("for", 851);
    freq.put("fos", 114);
    freq.put("ume", 800);
    freq.put("o\u0303kk", 88);
    freq.put("umb", 1389);
    freq.put("fol", 120);
    freq.put("fon", 233);
    freq.put("foo", 243);
    freq.put("umi", 3810);
    freq.put("\u03bf\u03c2", 107);
    freq.put("ol ", 1399);
    freq.put(" Xi", 80);
    freq.put("vaa", 1097);
    freq.put("o", 223900);
    freq.put("fo ", 79);
    freq.put("um ", 1368);
    freq.put("soa", 50);
    freq.put("soc", 67);
    freq.put("sob", 104);
    freq.put("mbi", 269);
    freq.put("sog", 196);
    freq.put("sof", 91);
    freq.put("mbe", 2044);
    freq.put("Fel", 59);
    freq.put("som", 95);
    freq.put("sol", 473);
    freq.put("soo", 2060);
    freq.put("son", 907);
    freq.put("sop", 124);
    freq.put("sos", 135);
    freq.put("sor", 585);
    freq.put("Fer", 121);
    freq.put("sot", 518);
    freq.put("sov", 164);
    freq.put("b ", 14100);
    freq.put("mbr", 1530);
    freq.put("a\u0308st", 200);
    freq.put("a\u0308su", 88);
    freq.put("a\u0308ss", 64);
    freq.put("a\u0308sk", 115);
    freq.put("a\u0308si", 369);
    freq.put("a\u0308se", 53);
    freq.put("so ", 126);
    freq.put("\u03c3", 105);
    freq.put("mb ", 129);
    freq.put("Ees", 3340);
    freq.put("azi", 122);
    freq.put("azo", 46);
    freq.put("aza", 97);
    freq.put("azz", 52);
    freq.put("Sis", 180);
    freq.put("Sir", 66);
    freq.put("Sib", 150);
    freq.put("Sig", 69);
    freq.put("Sie", 46);
    freq.put("kho", 116);
    freq.put("kha", 79);
    freq.put("Sii", 184);
    freq.put("Sih", 45);
    freq.put("Sin", 138);
    freq.put("Sim", 113);
    freq.put("Sil", 212);
    freq.put("\u0641", 48);
    freq.put("E", 9114);
    freq.put("\u30a2\u30a2", 377);
    freq.put("Ida", 408);
    freq.put("um", 10739);
    freq.put("\u043a\u043e\u0432", 99);
    freq.put("\u043a\u043e\u043b", 81);
    freq.put("osp", 69);
    freq.put("oss", 687);
    freq.put("osu", 161);
    freq.put("ost", 1657);
    freq.put("osi", 662);
    freq.put("osh", 53);
    freq.put("osk", 556);
    freq.put("osm", 201);
    freq.put("osl", 192);
    freq.put("oso", 739);
    freq.put("osn", 672);
    freq.put("osa", 4585);
    freq.put("ose", 1045);
    freq.put("osf", 200);
    freq.put("vet", 333);
    freq.put("ver", 1595);
    freq.put("o\u0308gi", 100);
    freq.put("u\u0308bi", 94);
    freq.put("veg", 47);
    freq.put("ved", 504);
    freq.put("vee", 1876);
    freq.put("Ta ", 667);
    freq.put("vea", 44);
    freq.put("ven", 2478);
    freq.put("veo", 115);
    freq.put("vel", 383);
    freq.put("vem", 547);
    freq.put("vek", 127);
    freq.put("vei", 261);
    freq.put("lra", 58);
    freq.put("Ma\u0308", 340);
    freq.put("lri", 102);
    freq.put("Mo\u0303", 229);
    freq.put("\u0438\u044f ", 116);
    freq.put("Mu\u0308", 121);
    freq.put("Tat", 66);
    freq.put("Tav", 135);
    freq.put("Tar", 920);
    freq.put("Tad", 48);
    freq.put("Tag", 78);
    freq.put("Taa", 310);
    freq.put("Tab", 46);
    freq.put("Tal", 1376);
    freq.put("Tam", 134);
    freq.put("Tan", 148);
    freq.put("Tai", 140);
    freq.put("M ", 228);
    freq.put("\u0438\u043c\u0438", 56);
    freq.put("ufo", 48);
    freq.put("\u0438\u0441\u0442", 52);
    freq.put("Me", 1361);
    freq.put("Ma", 3890);
    freq.put("Mc", 62);
    freq.put("Mo", 1371);
    freq.put("Mi", 1243);
    freq.put("Mu", 881);
    freq.put("\u043e\u0440\u043e", 72);
    freq.put("\u043e\u0440\u0438", 54);
    freq.put("My", 97);
    freq.put("lru\u0308", 75);
    freq.put("ugh", 62);
    freq.put("ipa", 243);
    freq.put("ipe", 504);
    freq.put("ipi", 209);
    freq.put("ipo", 148);
    freq.put("ipl", 275);
    freq.put("ipr", 172);
    freq.put("ips", 94);
    freq.put("ipp", 426);
    freq.put("ipt", 204);
    freq.put("ipu", 354);
    freq.put("\u03b5", 108);
    freq.put("ip ", 128);
    freq.put("\u0412\u043b", 51);
    freq.put("su\u0308", 7550);
    freq.put("so\u0308", 241);
    freq.put("so\u0303", 3307);
    freq.put("n\u0303", 47);
    freq.put("se\u0301", 45);
    freq.put("sa\u0308", 382);
    freq.put("\u043d\u0435", 99);
    freq.put("ipa\u0308", 225);
    freq.put("\u043d\u0434", 193);
    freq.put("ipo\u0303", 57);
    freq.put("\u043d\u0433", 60);
    freq.put("\u044c\u0441", 48);
    freq.put("sst", 65);
    freq.put("s ", 83808);
    freq.put("\u043d\u043e", 345);
    freq.put("Kab", 68);
    freq.put("u\u0308tt", 66);
    freq.put("so\u0308o\u0308", 193);
    freq.put("\u044c\u0435", 98);
    freq.put("\u044c\u043d", 72);
    freq.put("sz", 75);
    freq.put("sy", 172);
    freq.put("ss", 8143);
    freq.put("sr", 794);
    freq.put("sp", 2885);
    freq.put("sw", 139);
    freq.put("sv", 2315);
    freq.put("su", 20276);
    freq.put("st", 67054);
    freq.put("sk", 10212);
    freq.put("sj", 1063);
    freq.put("si", 30745);
    freq.put("sh", 1322);
    freq.put("so", 5912);
    freq.put("sn", 1521);
    freq.put("BA ", 64);
    freq.put("sl", 2942);
    freq.put("sc", 930);
    freq.put("sb", 374);
    freq.put("sa", 24031);
    freq.put("sg", 140);
    freq.put("sf", 485);
    freq.put("se", 62785);
    freq.put("sd", 174);
    freq.put("Aa", 1076);
    freq.put("tts", 70);
    freq.put("ttp", 55);
    freq.put("ttu", 276);
    freq.put("\u044f ", 380);
    freq.put("tti", 343);
    freq.put("tto", 143);
    freq.put("Kam", 188);
    freq.put("ttl", 46);
    freq.put("tta", 440);
    freq.put("Kal", 368);
    freq.put("tte", 2371);
    freq.put("dju", 74);
    freq.put("s\u030ca ", 68);
    freq.put("a\u0308hi", 637);
    freq.put("jia", 91);
    freq.put("a\u0308he", 2126);
    freq.put("dja", 309);
    freq.put("a\u0308ht", 1060);
    freq.put("nio", 206);
    freq.put("tt ", 402);
    freq.put("ji ", 46);
    freq.put("s\u030cat", 45);
    freq.put("\u041f", 266);
    freq.put("Jor", 57);
    freq.put("Jos", 138);
    freq.put("Joa", 63);
    freq.put("blo", 54);
    freq.put("bli", 550);
    freq.put("ble", 274);
    freq.put("Ag", 213);
    freq.put("bla", 847);
    freq.put("Jon", 103);
    freq.put("Joo", 51);
    freq.put("onk", 273);
    freq.put("o\u0303ib", 513);
    freq.put("o\u0303ie", 258);
    freq.put("o\u0303id", 332);
    freq.put("o\u0303ig", 1596);
    freq.put("o\u0303ik", 622);
    freq.put("ona", 1303);
    freq.put("o\u0303im", 1468);
    freq.put("ong", 640);
    freq.put("ond", 3491);
    freq.put("one", 1232);
    freq.put("o\u0303is", 2033);
    freq.put("ony", 92);
    freq.put("o\u0303it", 583);
    freq.put("o\u0303iv", 218);
    freq.put("onr", 44);
    freq.put("ons", 816);
    freq.put("onp", 75);
    freq.put("onv", 154);
    freq.put("ont", 1242);
    freq.put("onu", 172);
    freq.put("uku", 265);
    freq.put("ukt", 617);
    freq.put("uks", 640);
    freq.put("ukr", 117);
    freq.put("uko", 1820);
    freq.put("ukl", 81);
    freq.put("ukk", 131);
    freq.put("uki", 384);
    freq.put("uke", 268);
    freq.put("\u043e\u0432 ", 254);
    freq.put("uka", 800);
    freq.put("o\u0303i ", 5148);
    freq.put(" Zo", 49);
    freq.put(" Zi", 58);
    freq.put(" Zh", 62);
    freq.put(" Ze", 122);
    freq.put("on ", 39161);
    freq.put(" Za", 127);
    freq.put(" Zu", 94);
    freq.put("rze", 44);
    freq.put("vo\u0303e", 178);
    freq.put("vo\u0303n", 91);
    freq.put("vo\u0303l", 153);
    freq.put("vo\u0303i", 7974);
    freq.put("vo\u0303t", 836);
    freq.put("vo\u0303r", 892);
    freq.put("vo\u0303s", 96);
    freq.put("uk ", 199);
    freq.put("sak", 2002);
    freq.put("saj", 656);
    freq.put("sai", 500);
    freq.put("sah", 226);
    freq.put("san", 1221);
    freq.put("sam", 2292);
    freq.put("sal", 1925);
    freq.put("sab", 140);
    freq.put("saa", 4775);
    freq.put("sag", 380);
    freq.put("sae", 148);
    freq.put("sad", 632);
    freq.put("onu\u0308", 106);
    freq.put("sas", 2183);
    freq.put("sar", 1496);
    freq.put("sap", 131);
    freq.put("sav", 213);
    freq.put("sau", 105);
    freq.put("sat", 1244);
    freq.put("uku\u0308", 84);
    freq.put("zon", 61);
    freq.put("ax ", 62);
    freq.put("o\u0308o\u0308v", 121);
    freq.put("sa ", 3636);
    freq.put("o\u0308o\u0308s", 287);
    freq.put("o\u0308o\u0308r", 516);
    freq.put("o\u0308o\u0308p", 158);
    freq.put("o\u0308o\u0308n", 269);
    freq.put("o\u0308o\u0308m", 71);
    freq.put("o\u0308o\u0308l", 141);
    freq.put("o\u0308o\u0308k", 163);
    freq.put("o\u0308o\u0308g", 123);
    freq.put("o\u0308o\u0308d", 419);
    freq.put("o\u0308o\u0308b", 59);
    freq.put("zo ", 48);
    freq.put("\u0627\u0646", 46);
    freq.put("\u0627\u0644", 176);
    freq.put("axi", 69);
    freq.put("\u0438\u043a\u043e", 106);
    freq.put("\u043a\u043e ", 58);
    freq.put("Ska", 93);
    freq.put("vid", 522);
    freq.put("ho\u0303o\u0303", 63);
    freq.put(" ba\u0308", 181);
    freq.put("uv", 4464);
    freq.put("øn", 53);
    freq.put("up", 1948);
    freq.put("øy", 105);
    freq.put("ør", 74);
    freq.put("\u041b", 141);
    freq.put("u\u0308lj", 132);
    freq.put("kj ", 53);
    freq.put("u\u0308lo", 65);
    freq.put(" b ", 66);
    freq.put("u\u0308lm", 94);
    freq.put("u\u0308ll", 158);
    freq.put("u\u0308la", 1693);
    freq.put("u\u0308lg", 296);
    freq.put("u\u0308le", 1718);
    freq.put("u\u0308ld", 476);
    freq.put("vkj", 47);
    freq.put("vko", 169);
    freq.put("u\u0308lr", 51);
    freq.put("o\u0308el", 65);
    freq.put("uos", 126);
    freq.put("ho\u0303b", 45);
    freq.put("fis", 69);
    freq.put("ho\u0303l", 310);
    freq.put("\u043e\u0440 ", 52);
    freq.put("Kru", 51);
    freq.put(" be", 162);
    freq.put("kja", 72);
    freq.put(" ba", 664);
    freq.put(" bl", 78);
    freq.put(" bo", 152);
    freq.put("u\u0308l ", 45);
    freq.put(" bi", 566);
    freq.put(" bu", 241);
    freq.put("s", 344443);
    freq.put(" br", 141);
    freq.put("iva\u0308", 146);
    freq.put("ivo\u0303", 345);
    freq.put("Az", 50);
    freq.put("o\u0303mb", 51);
    freq.put("Hii", 583);
    freq.put("sma\u0308", 672);
    freq.put("fin", 213);
    freq.put("fil", 1891);
    freq.put("ive", 618);
    freq.put("iva", 1768);
    freq.put("ivn", 346);
    freq.put("ivo", 234);
    freq.put("ivi", 1653);
    freq.put("\u0435\u0435\u0432", 71);
    freq.put("ivu", 91);
    freq.put("ivs", 528);
    freq.put("\u0441\u0442\u0430", 51);
    freq.put("\u0441\u0442\u0432", 57);
    freq.put("\u03b4", 59);
    freq.put("\u0441\u0442\u043e", 56);
    freq.put("\u0441\u0442\u0440", 66);
    freq.put("iv ", 471);
    freq.put("\u044c ", 130);
    freq.put("I", 5403);
    freq.put(" gr", 524);
    freq.put("bu\u0308r", 50);
    freq.put("tvo\u0303", 44);
    freq.put("gda", 70);
    freq.put("\u044f\u043d", 79);
    freq.put("gde", 51);
    freq.put("uid", 849);
    freq.put("tva\u0308", 73);
    freq.put("SV ", 478);
    freq.put("uig", 91);
    freq.put(" go", 49);
    freq.put(" gl", 111);
    freq.put("NA ", 78);
    freq.put("as\u030c", 218);
    freq.put("tvu", 92);
    freq.put("tvo", 55);
    freq.put("ezi", 53);
    freq.put("tve", 93);
    freq.put("tva", 221);
    freq.put("az\u030c", 108);
    freq.put("ac ", 51);
    freq.put(" z\u030ca", 50);
    freq.put("dde", 47);
    freq.put("ez ", 79);
    freq.put("acc", 48);
    freq.put("aca", 68);
    freq.put("ace", 151);
    freq.put("ack", 227);
    freq.put("aci", 112);
    freq.put("ach", 400);
    freq.put("aco", 80);
    freq.put("act", 96);
    freq.put("Ni", 728);
    freq.put("bje", 380);
    freq.put("bja", 66);
    freq.put("No", 1468);
    freq.put("uil", 85);
    freq.put("Na", 1009);
    freq.put("Ne", 1120);
    freq.put("Ny", 45);
    freq.put("ao\u0303", 117);
    freq.put("\u0629 ", 66);
    freq.put("au\u0308", 201);
    freq.put("het", 632);
    freq.put("hev", 124);
    freq.put("\u043e\u0432\u0438", 380);
    freq.put("hep", 112);
    freq.put("\u043e\u0432\u043d", 48);
    freq.put("hes", 861);
    freq.put("\u043e\u0432\u0430", 78);
    freq.put("\u043e\u0432\u0435", 46);
    freq.put("hed", 836);
    freq.put("hee", 149);
    freq.put("\u0432", 1990);
    freq.put("hea", 267);
    freq.put("hel", 4104);
    freq.put("hem", 646);
    freq.put("hen", 4035);
    freq.put("heo", 122);
    freq.put("hei", 379);
    freq.put("hek", 639);
    freq.put("uu\u0308", 74);
    freq.put("N ", 331);
    freq.put("\u043e\u0432\u0441", 48);
    freq.put("o\u0303", 40539);
    freq.put("aa", 42535);
    freq.put("o\u0303gi", 631);
    freq.put("ab", 9670);
    freq.put("ae", 3739);
    freq.put("ad", 21341);
    freq.put("ag", 6434);
    freq.put("af", 1986);
    freq.put("Hon", 86);
    freq.put("ah", 11107);
    freq.put("Hol", 356);
    freq.put("aj", 8772);
    freq.put("Na\u0308", 146);
    freq.put("al", 53791);
    freq.put("\u043d\u044b\u0438\u0306", 73);
    freq.put("an", 38127);
    freq.put("aq", 50);
    freq.put("ap", 5317);
    freq.put("as", 52565);
    freq.put("ar", 30297);
    freq.put("Nu\u0308", 46);
    freq.put("at", 32525);
    freq.put("aw", 265);
    freq.put("av", 11952);
    freq.put("ay", 578);
    freq.put("ax", 179);
    freq.put("ohv", 181);
    freq.put("az", 442);
    freq.put("No\u0303", 704);
    freq.put("uis", 365);
    freq.put("a ", 101956);
    freq.put("at ", 2216);
    freq.put("uit", 151);
    freq.put("Fir", 68);
    freq.put("sco", 130);
    freq.put("sci", 49);
    freq.put("sch", 453);
    freq.put("sca", 191);
    freq.put("Ko\u0303r", 209);
    freq.put("mni", 67);
    freq.put(" a", 29616);
    freq.put("Uus", 233);
    freq.put("Ko\u0303i", 90);
    freq.put("mna", 105);
    freq.put("Fin", 145);
    freq.put("mne", 450);
    freq.put("Fil", 156);
    freq.put("smo", 245);
    freq.put("tz", 299);
    freq.put("dso", 79);
    freq.put("tv", 618);
    freq.put("tw", 94);
    freq.put("tt", 4340);
    freq.put("tu", 27878);
    freq.put("tr", 8177);
    freq.put("ts", 21273);
    freq.put("tp", 259);
    freq.put("tn", 1099);
    freq.put("to", 11780);
    freq.put("tl", 5476);
    freq.put("tm", 2505);
    freq.put("tj", 657);
    freq.put("tk", 949);
    freq.put("th", 1862);
    freq.put("ti", 30264);
    freq.put("tf", 183);
    freq.put("tg", 91);
    freq.put("te", 48864);
    freq.put("tb", 129);
    freq.put("tc", 91);
    freq.put("ta", 41990);
    freq.put("smi", 1155);
    freq.put("rc", 505);
    freq.put("Uue", 46);
    freq.put("mn ", 55);
    freq.put("sme", 256);
    freq.put("dse", 425);
    freq.put(" s", 33963);
    freq.put(" dz\u030c", 65);
    freq.put("sma", 1250);
    freq.put("dsa", 56);
    freq.put("t ", 40235);
    freq.put("\u0430\u0441\u0438", 52);
    freq.put("z\u030cu", 64);
    freq.put("z\u030ci", 342);
    freq.put("z\u030co", 59);
    freq.put("z\u030ca", 274);
    freq.put("z\u030ce", 84);
    freq.put("tu\u0308", 1113);
    freq.put("to\u0308", 1641);
    freq.put("to\u0303", 1288);
    freq.put("te\u0301", 49);
    freq.put("ta\u0308", 3641);
    freq.put("\u4e09\u4e09", 54);
    freq.put("z\u030c ", 81);
    freq.put("vib", 72);
    freq.put("vic", 51);
    freq.put("via", 291);
    freq.put("vig", 116);
    freq.put("Aug", 149);
    freq.put("vie", 84);
    freq.put("vik", 721);
    freq.put("vih", 89);
    freq.put("vii", 1360);
    freq.put("vin", 1205);
    freq.put("vio", 50);
    freq.put("vil", 657);
    freq.put("vim", 530);
    freq.put("vir", 136);
    freq.put("vis", 990);
    freq.put("Aus", 402);
    freq.put("viv", 99);
    freq.put("Aut", 116);
    freq.put("vit", 1084);
    freq.put("u\u0308no", 56);
    freq.put("u\u0308nn", 379);
    freq.put("u\u0308nk", 61);
    freq.put("u\u0308nd", 3848);
    freq.put("u\u0308ng", 61);
    freq.put("u\u0308na", 270);
    freq.put("ov ", 391);
    freq.put(" d ", 153);
    freq.put("o\u0308ko", 300);
    freq.put("u\u0308nt", 213);
    freq.put("ts\u030c", 984);
    freq.put("vi ", 1273);
    freq.put(" do", 440);
    freq.put("S\u030c", 453);
    freq.put("kla", 1096);
    freq.put(" di", 908);
    freq.put(" de", 2173);
    freq.put("klo", 288);
    freq.put("kli", 1510);
    freq.put(" da", 137);
    freq.put("klu", 516);
    freq.put("\u043b\u0435\u043d", 58);
    freq.put("\u043b\u0435\u043a", 145);
    freq.put(" du", 101);
    freq.put(" dr", 125);
    freq.put("atr", 525);
    freq.put(" \u0412\u0430", 94);
    freq.put(" \u0412\u0438", 55);
    freq.put(" \u0412\u043b", 50);
    freq.put(" du\u0308", 205);
    freq.put("itn", 116);
    freq.put("ito", 1263);
    freq.put("itl", 1066);
    freq.put("itm", 881);
    freq.put("itj", 280);
    freq.put("ith", 114);
    freq.put("iti", 2606);
    freq.put("ite", 4040);
    freq.put("ita", 4226);
    freq.put("itz", 125);
    freq.put("ity", 156);
    freq.put("itt", 840);
    freq.put("itu", 2865);
    freq.put("itr", 232);
    freq.put("its", 4841);
    freq.put("\u0438\u0445\u0430", 59);
    freq.put("it ", 2043);
    freq.put("ht", 6604);
    freq.put("\u0418\u0432", 73);
    freq.put("aaz\u030c", 50);
    freq.put(" A ", 257);
    freq.put("itu\u0308", 46);
    freq.put("ito\u0308", 136);
    freq.put("ito\u0303", 50);
    freq.put("fu\u0308s", 56);
    freq.put("fta", 81);
    freq.put("fti", 45);
    freq.put(" Aa", 1075);
    freq.put(" Ab", 516);
    freq.put(" Ac", 133);
    freq.put(" Ad", 404);
    freq.put(" Ae", 126);
    freq.put(" Af", 163);
    freq.put(" Ag", 212);
    freq.put(" Ah", 170);
    freq.put(" Ai", 275);
    freq.put(" Aj", 171);
    freq.put(" Ak", 327);
    freq.put(" Al", 2024);
    freq.put(" Am", 1400);
    freq.put(" An", 1581);
    freq.put(" Ap", 221);
    freq.put(" Ar", 1360);
    freq.put(" As", 1512);
    freq.put(" At", 438);
    freq.put(" Au", 835);
    freq.put(" Av", 171);
    freq.put(" Az", 50);
    freq.put("ft ", 139);
    freq.put("w", 2663);
    freq.put("\u043e\u0438\u0306", 87);
    freq.put("Fra", 377);
    freq.put("\u043e\u043b", 330);
    freq.put("\u043e\u043c", 142);
    freq.put("\u043e\u043d", 240);
    freq.put("Fre", 186);
    freq.put("\u043e\u043f", 51);
    freq.put("\u043e\u0431", 67);
    freq.put("Fri", 218);
    freq.put("\u043e\u0433", 103);
    freq.put("\u043e\u0434", 117);
    freq.put("\u043e\u0435", 100);
    freq.put("its\u030c", 421);
    freq.put("jer", 66);
    freq.put("jes", 189);
    freq.put("jev", 327);
    freq.put("aa ", 3615);
    freq.put("jet", 51);
    freq.put("jee", 65);
    freq.put("jek", 711);
    freq.put("a\u0308da", 144);
    freq.put("\u043a", 1535);
    freq.put("jen", 398);
    freq.put("jel", 510);
    freq.put("jem", 199);
    freq.put("\u3042", 71);
    freq.put("ku\u0308u\u0308", 67);
    freq.put("aae", 152);
    freq.put("aad", 3122);
    freq.put("aag", 470);
    freq.put("s\u030cer", 71);
    freq.put("s\u030cet", 55);
    freq.put("s\u030cev", 66);
    freq.put("aam", 1949);
    freq.put("aal", 7268);
    freq.put("aan", 4143);
    freq.put("aai", 1233);
    freq.put("aak", 2014);
    freq.put("aaj", 148);
    freq.put("aau", 47);
    freq.put("aat", 3358);
    freq.put("je ", 209);
    freq.put("aav", 886);
    freq.put("s\u030cee", 52);
    freq.put("aap", 765);
    freq.put("aas", 6140);
    freq.put("aar", 5151);
    freq.put("\u043e\u0440", 399);
    freq.put("\u043e\u0441", 221);
    freq.put("\u043e\u0442", 68);
    freq.put("s\u030cel", 50);
    freq.put("bha", 48);
    freq.put("uet", 68);
    freq.put("ex ", 72);
    freq.put("tp ", 49);
    freq.put("ku\u0308t", 108);
    freq.put("ku\u0308s", 137);
    freq.put("M", 10132);
    freq.put("Isl", 190);
    freq.put("ku\u0308l", 2089);
    freq.put("ku\u0308m", 165);
    freq.put("Isa", 72);
    freq.put("Ise", 51);
    freq.put("exa", 132);
    freq.put("exi", 65);
    freq.put("o\u0303el", 416);
    freq.put("ugi", 162);
    freq.put("o\u0303en", 137);
    freq.put("Hal", 209);
    freq.put("Ham", 105);
    freq.put("Han", 256);
    freq.put("ugl", 46);
    freq.put("Haa", 140);
    freq.put("Hab", 68);
    freq.put("uge", 590);
    freq.put("oje", 372);
    freq.put("oja", 659);
    freq.put("o\u0303et", 187);
    freq.put("Har", 682);
    freq.put("Hau", 60);
    freq.put("o\u0303es", 152);
    freq.put(" O\u0303", 255);
    freq.put("o\u0303e ", 1023);
    freq.put("rfa", 51);
    freq.put("cra", 52);
    freq.put("rfe", 44);
    freq.put("rfi", 65);
    freq.put("rfo", 51);
    freq.put("cro", 105);
    freq.put("sev", 717);
    freq.put("seu", 254);
    freq.put("set", 1978);
    freq.put("ses", 5796);
    freq.put("ser", 1068);
    freq.put("For", 124);
    freq.put("sep", 903);
    freq.put("sey", 55);
    freq.put("seg", 1695);
    freq.put("see", 2074);
    freq.put("sed", 3928);
    freq.put("seb", 254);
    freq.put("sea", 1804);
    freq.put("seo", 645);
    freq.put("sen", 2101);
    freq.put("Fon", 48);
    freq.put("sel", 10065);
    freq.put("sek", 3272);
    freq.put("sej", 332);
    freq.put("sei", 2222);
    freq.put("seh", 77);
    freq.put("ue ", 313);
    freq.put("se ", 21232);
    freq.put("No\u0303u", 525);
    freq.put("No\u0303m", 138);
    freq.put("nr ", 71);
    freq.put("lex", 145);
    freq.put("tiv", 496);
    freq.put("xan", 102);
    freq.put("\u0436", 145);
    freq.put("nri", 214);
    freq.put("nra", 73);
    freq.put(" \u0410\u0431", 44);
    freq.put("mla", 87);
    freq.put("Ole", 65);
    freq.put(" fo\u0308", 77);
    freq.put(" \u0410\u043b", 161);
    freq.put("Oli", 46);
    freq.put("mli", 87);
    freq.put(" fu\u0308", 370);
    freq.put(" \u0410\u043d", 87);
    freq.put("ami", 6164);
    freq.put("o\u0308id", 47);
    freq.put("vol", 333);
    freq.put("von", 554);
    freq.put("voo", 711);
    freq.put("voj", 65);
    freq.put("vok", 90);
    freq.put("psi", 131);
    freq.put("vor", 540);
    freq.put("vos", 69);
    freq.put("pso", 44);
    freq.put("u\u0308ht", 317);
    freq.put("u\u0308hr", 50);
    freq.put("u\u0308he", 2500);
    freq.put("u\u0308ha", 330);
    freq.put("u\u0308hm", 571);
    freq.put("u\u0308hi", 1384);
    freq.put("u\u0308hh", 198);
    freq.put("psa", 102);
    freq.put("vo ", 249);
    freq.put("vgo", 75);
    freq.put("pse", 289);
    freq.put("Soc", 51);
    freq.put(" fr", 185);
    freq.put(" fu", 315);
    freq.put("Sof", 45);
    freq.put("kne", 492);
    freq.put("Som", 77);
    freq.put("Sol", 103);
    freq.put("Soo", 896);
    freq.put("Son", 96);
    freq.put(" fa", 280);
    freq.put(" fe", 136);
    freq.put("Sot", 162);
    freq.put(" fi", 1214);
    freq.put(" fj", 44);
    freq.put("Olu\u0308", 53);
    freq.put(" fl", 88);
    freq.put(" fo", 525);
    freq.put("O ", 457);
    freq.put("ija\u0308", 97);
    freq.put(" \u4e4b", 80);
    freq.put("ba\u0308", 233);
    freq.put("On", 147);
    freq.put("Om", 123);
    freq.put("Ol", 339);
    freq.put("Ok", 125);
    freq.put("Oi", 46);
    freq.put("Oh", 110);
    freq.put("Of", 51);
    freq.put("Od", 88);
    freq.put("Ob", 154);
    freq.put("bo\u0308", 50);
    freq.put("bu\u0308", 159);
    freq.put("Ou", 77);
    freq.put("Ot", 174);
    freq.put("Os", 432);
    freq.put("Or", 500);
    freq.put("Op", 127);
    freq.put(" \u4e01", 77);
    freq.put("d", 141364);
    freq.put(" \u4e09", 86);
    freq.put("us\u030c", 116);
    freq.put("IV ", 90);
    freq.put("iju", 112);
    freq.put("po\u0308o\u0308", 270);
    freq.put("ija", 1055);
    freq.put("ije", 50);
    freq.put(" Du", 150);
    freq.put("ijo", 86);
    freq.put("u\u0304 ", 64);
    freq.put("bd", 109);
    freq.put("be", 5461);
    freq.put("ba", 4886);
    freq.put("bb", 142);
    freq.put("bl", 1788);
    freq.put("bn", 97);
    freq.put("bo", 1301);
    freq.put("bh", 62);
    freq.put("bi", 4858);
    freq.put("bj", 462);
    freq.put("bk", 63);
    freq.put("bt", 50);
    freq.put("bu", 2050);
    freq.put("br", 3541);
    freq.put("bs", 372);
    freq.put("by", 175);
    freq.put("Fu", 158);
    freq.put("Oss", 50);
    freq.put("Ost", 56);
    freq.put("Osl", 81);
    freq.put("Osa", 64);
    freq.put("Osc", 88);
    freq.put("\u0432\u0441\u043a", 69);
    freq.put(" C ", 205);
    freq.put("tif", 152);
    freq.put("\u043e ", 255);
    freq.put("ci ", 105);
    freq.put("tig", 255);
    freq.put("u ", 17617);
    freq.put("Fe", 322);
    freq.put(" Ch", 848);
    freq.put(" Ci", 166);
    freq.put(" Co", 1011);
    freq.put(" Cl", 225);
    freq.put("dok", 340);
    freq.put(" Ca", 996);
    freq.put(" Ce", 158);
    freq.put(" Cr", 170);
    freq.put(" Cu", 137);
    freq.put("cia", 158);
    freq.put("uy", 48);
    freq.put("ux", 121);
    freq.put("cie", 98);
    freq.put("uz", 144);
    freq.put("uu", 16971);
    freq.put("ut", 13872);
    freq.put("dom", 146);
    freq.put("cin", 92);
    freq.put("us", 50648);
    freq.put("ur", 13993);
    freq.put("cis", 100);
    freq.put("ul", 16978);
    freq.put("uo", 494);
    freq.put("un", 13735);
    freq.put("ui", 3667);
    freq.put("uh", 3669);
    freq.put("uk", 5480);
    freq.put("uj", 2076);
    freq.put("ue", 1272);
    freq.put("ud", 21571);
    freq.put("ug", 4237);
    freq.put("uf", 259);
    freq.put("ua", 3006);
    freq.put("uc", 397);
    freq.put("ub", 5783);
    freq.put("sla", 864);
    freq.put("ag ", 78);
    freq.put("lph", 47);
    freq.put("\u044d", 66);
    freq.put("\u10da", 57);
    freq.put("ago", 338);
    freq.put("agn", 333);
    freq.put("agi", 522);
    freq.put("uo\u0303", 62);
    freq.put("age", 905);
    freq.put("agd", 52);
    freq.put("aga", 2664);
    freq.put("agu", 1145);
    freq.put("agr", 165);
    freq.put("ev ", 1881);
    freq.put("wa ", 114);
    freq.put("tri", 3128);
    freq.put("evi", 1332);
    freq.put("evk", 55);
    freq.put("tro", 1685);
    freq.put("evo", 358);
    freq.put("tra", 1815);
    freq.put("eva", 4542);
    freq.put("tre", 529);
    freq.put("eve", 552);
    freq.put("tru", 752);
    freq.put("evu", 1013);
    freq.put("le ", 12620);
    freq.put("uel", 155);
    freq.put("uen", 148);
    freq.put("uee", 109);
    freq.put("odr", 58);
    freq.put("ods", 77);
    freq.put(" o\u0303p", 648);
    freq.put("odu", 2480);
    freq.put(" o\u0303l", 119);
    freq.put("odi", 1047);
    freq.put(" o\u0303n", 74);
    freq.put("odk", 64);
    freq.put(" o\u0303h", 408);
    freq.put(" o\u0303i", 938);
    freq.put("odn", 64);
    freq.put("odo", 182);
    freq.put("oda", 609);
    freq.put("Bla", 86);
    freq.put("ode", 1123);
    freq.put("ues", 193);
    freq.put("uer", 113);
    freq.put("ct ", 57);
    freq.put("rd ", 981);
    freq.put("lea", 143);
    freq.put("leb", 814);
    freq.put("lec", 56);
    freq.put("led", 276);
    freq.put("lee", 784);
    freq.put("lef", 123);
    freq.put("leg", 615);
    freq.put("leh", 741);
    freq.put("lei", 662);
    freq.put("lej", 650);
    freq.put("lek", 2924);
    freq.put("lel", 939);
    freq.put("lem", 2382);
    freq.put("len", 1713);
    freq.put("leo", 191);
    freq.put("lep", 522);
    freq.put("ler", 467);
    freq.put("les", 6911);
    freq.put("let", 1229);
    freq.put("leu", 72);
    freq.put("lev", 2102);
    freq.put("od ", 481);
    freq.put("ley", 127);
    freq.put("rdu", 636);
    freq.put("ctu", 66);
    freq.put("rds", 305);
    freq.put("rdr", 70);
    freq.put("zm", 49);
    freq.put("eva\u0308", 227);
    freq.put("rde", 1014);
    freq.put("rda", 591);
    freq.put("tru\u0308", 150);
    freq.put("rdm", 90);
    freq.put("rdl", 149);
    freq.put("rdo", 137);
    freq.put("rdn", 203);
    freq.put("rdi", 1642);
    freq.put("cti", 143);
    freq.put("rdk", 56);
    freq.put("\u10d4", 73);
    freq.put("sgr", 60);
    freq.put("Ukr", 194);
    freq.put("tu\u0308u\u0308", 554);
    freq.put(" \u1100\u1161\u1100\u1161", 46);
    freq.put("zia", 44);
    freq.put("zin", 86);
    freq.put("\u043e", 3362);
    freq.put("ha\u0308v", 119);
    freq.put("ha\u0308r", 83);
    freq.put("zi ", 155);
    freq.put("tu\u0308k", 102);
    freq.put("tu\u0308h", 106);
    freq.put("tu\u0308r", 79);
    freq.put("tu\u0308t", 130);
    freq.put("On ", 49);
    freq.put("\u03bc", 94);
    freq.put("o\u0302", 78);
    freq.put("\u043f\u043e", 93);
    freq.put("\u043f\u0435", 55);
    freq.put("\u043f\u0430", 67);
    freq.put("Q", 266);
    freq.put("npr", 44);
    freq.put("Yo", 251);
    freq.put("O\u0303ig", 83);
    freq.put("æ", 123);
    freq.put("mjo", 107);
    freq.put("VI ", 61);
    freq.put("\u0414", 138);
    freq.put("vms", 66);
    freq.put("e\u0302\u0309", 72);
    freq.put("Sak", 1209);
    freq.put("Sai", 131);
    freq.put("Sah", 102);
    freq.put("San", 281);
    freq.put("Sam", 213);
    freq.put("Sal", 247);
    freq.put("Sab", 44);
    freq.put("Saa", 614);
    freq.put("Sag", 67);
    freq.put("\u0438\u0432 ", 46);
    freq.put(" hu", 967);
    freq.put("Sad", 48);
    freq.put("kpa", 66);
    freq.put(" hi", 1143);
    freq.put(" ho", 971);
    freq.put("kpi", 89);
    freq.put(" ha", 2640);
    freq.put("\u043f\u0440", 87);
    freq.put("Sav", 86);
    freq.put(" he", 1467);
    freq.put("kpo", 74);
    freq.put("pu\u0308r", 52);
    freq.put("\u0438\u0447 ", 575);
    freq.put("uht", 1356);
    freq.put("rvu\u0308", 53);
    freq.put("\u043b ", 110);
    freq.put(" hu\u0308", 385);
    freq.put(" ho\u0303", 577);
    freq.put("umu", 239);
    freq.put(" ha\u0308", 549);
    freq.put("puu", 696);
    freq.put("iht", 687);
    freq.put("ihu", 144);
    freq.put("ihk", 182);
    freq.put("ihh", 111);
    freq.put("ihi", 253);
    freq.put("iho", 52);
    freq.put("ihm", 65);
    freq.put("iha", 299);
    freq.put("ihe", 679);
    freq.put("Ta\u0308h", 115);
    freq.put("Ta\u0308n", 126);
    freq.put("too", 2528);
    freq.put(" E ", 253);
    freq.put("ck ", 487);
    freq.put("\u0435\u0442 ", 44);
    freq.put(" El", 689);
    freq.put(" Em", 267);
    freq.put(" En", 453);
    freq.put(" Eh", 78);
    freq.put(" Ei", 131);
    freq.put(" Ek", 107);
    freq.put(" Ed", 300);
    freq.put(" Ee", 3409);
    freq.put(" Eg", 183);
    freq.put(" Ea", 51);
    freq.put(" Ec", 83);
    freq.put(" Ex", 60);
    freq.put(" Et", 156);
    freq.put(" Eu", 1052);
    freq.put(" Ev", 105);
    freq.put("jum", 545);
    freq.put(" Ep", 67);
    freq.put(" Er", 526);
    freq.put(" Es", 505);
    freq.put("cke", 185);
    freq.put("cka", 54);
    freq.put("cki", 151);
    freq.put("ckh", 122);
    freq.put("cks", 55);
    freq.put("Po\u0308", 45);
    freq.put("Po\u0303", 1331);
    freq.put("Pu\u0308", 264);
    freq.put("\u0410", 448);
    freq.put("Pa\u0308", 660);
    freq.put("jaz", 54);
    freq.put("jav", 659);
    freq.put("jat", 1299);
    freq.put("jar", 182);
    freq.put("jas", 1811);
    freq.put("jap", 328);
    freq.put("jan", 2708);
    freq.put("jao", 620);
    freq.put("jal", 3824);
    freq.put("jam", 517);
    freq.put("jaj", 121);
    freq.put("jak", 1121);
    freq.put("jah", 222);
    freq.put("jai", 178);
    freq.put("jag", 412);
    freq.put("jad", 794);
    freq.put("jab", 52);
    freq.put("s\u030ci ", 155);
    freq.put("jaa", 1553);
    freq.put("cla", 52);
    freq.put("\u0434\u0438\u043c", 49);
    freq.put("aes", 76);
    freq.put("aer", 147);
    freq.put("eto\u0308", 63);
    freq.put("aet", 163);
    freq.put("eto\u0303", 90);
    freq.put("h", 68975);
    freq.put("etu\u0308", 153);
    freq.put("aee", 54);
    freq.put("aed", 90);
    freq.put("aeg", 1173);
    freq.put("aeh", 45);
    freq.put("aek", 78);
    freq.put("ael", 441);
    freq.put("ja ", 25408);
    freq.put("aen", 249);
    freq.put("Pr", 1526);
    freq.put("Ps", 58);
    freq.put("Pt", 77);
    freq.put("Pu", 606);
    freq.put("Py", 58);
    freq.put("oma", 3656);
    freq.put("Pa", 2287);
    freq.put("Pe", 1263);
    freq.put("Ph", 224);
    freq.put("Pi", 1126);
    freq.put("Po", 1247);
    freq.put("Pl", 289);
    freq.put("\u0627", 449);
    freq.put("et ", 2344);
    freq.put("lf", 372);
    freq.put("\u0432\u0435", 150);
    freq.put("tsl", 83);
    freq.put("P ", 412);
    freq.put("tsm", 159);
    freq.put("\u0432\u0430", 236);
    freq.put("tsk", 220);
    freq.put("etr", 1191);
    freq.put("ets", 1555);
    freq.put("etv", 60);
    freq.put("ett", 1369);
    freq.put("etu", 2430);
    freq.put("tsi", 9068);
    freq.put("tla", 898);
    freq.put("eta", 4185);
    freq.put("tle", 1553);
    freq.put("\u0432\u043d", 105);
    freq.put("etk", 122);
    freq.put("eth", 183);
    freq.put("eti", 2019);
    freq.put("etn", 244);
    freq.put("\u0432\u043e", 155);
    freq.put("etl", 824);
    freq.put("ck", 1210);
    freq.put("ci", 834);
    freq.put("ch", 3094);
    freq.put("va\u0308", 6112);
    freq.put("Her", 270);
    freq.put("cl", 163);
    freq.put("cc", 199);
    freq.put("\u0432\u0438", 646);
    freq.put("ca", 1187);
    freq.put("ce", 1021);
    freq.put("tsc", 70);
    freq.put("cz", 59);
    freq.put("cy", 123);
    freq.put("Hea", 65);
    freq.put("vo\u0308", 298);
    freq.put("Hel", 430);
    freq.put("cr", 248);
    freq.put("Hen", 145);
    freq.put("tsa", 1214);
    freq.put("vu\u0308", 141);
    freq.put("Hei", 240);
    freq.put("cu", 367);
    freq.put("ct", 474);
    freq.put("Ger", 95);
    freq.put("Geo", 499);
    freq.put("Gen", 130);
    freq.put("rb ", 55);
    freq.put("lgi", 247);
    freq.put("lgn", 56);
    freq.put("lgo", 86);
    freq.put("lgl", 54);
    freq.put("c ", 475);
    freq.put("lge", 1193);
    freq.put("lgr", 91);
    freq.put("lgs", 300);
    freq.put("lgp", 735);
    freq.put("lgu", 794);
    freq.put("rbu", 230);
    freq.put("rbr", 301);
    freq.put("rbo", 167);
    freq.put("rbl", 48);
    freq.put("rbi", 388);
    freq.put("Tve", 67);
    freq.put("rbe", 348);
    freq.put("ly", 347);
    freq.put("rba", 241);
    freq.put("va", 34297);
    freq.put("vd", 60);
    freq.put("ve", 10196);
    freq.put("vg", 104);
    freq.put("vi", 9510);
    freq.put("vj", 46);
    freq.put("ph ", 74);
    freq.put("vl", 251);
    freq.put("vm", 177);
    freq.put("vn", 468);
    freq.put("vo", 2748);
    freq.put("vp", 221);
    freq.put("vr", 127);
    freq.put("a\u0308ga", 245);
    freq.put("vt", 88);
    freq.put("vu", 4481);
    freq.put("vv", 89);
    freq.put("vy", 59);
    freq.put("of ", 621);
    freq.put("una", 2903);
    freq.put("unc", 54);
    freq.put("gu\u0308m", 58);
    freq.put("v ", 7055);
    freq.put("phi", 121);
    freq.put("a\u0308gi", 746);
    freq.put("pho", 86);
    freq.put("pha", 122);
    freq.put("ung", 491);
    freq.put("phe", 92);
    freq.put("\u0435\u0308", 86);
    freq.put("phy", 67);
    freq.put("mu\u0308u\u0308", 230);
    freq.put("unk", 808);
    freq.put("off", 59);
    freq.put("ofe", 202);
    freq.put("ofi", 557);
    freq.put("ofo", 118);
    freq.put("ets\u030c", 80);
    freq.put("oft", 95);
    freq.put("\u043a\u0438\u0438\u0306", 216);
    freq.put("\u05d5", 53);
    freq.put("uno", 48);
    freq.put("wen", 48);
    freq.put("wer", 86);
    freq.put("nve", 213);
    freq.put(" jo\u0303", 1996);
    freq.put("Sau", 94);
    freq.put(" ja\u0308", 3184);
    freq.put("vst", 161);
    freq.put("vsu", 116);
    freq.put("o\u0308mi", 48);
    freq.put("vse", 403);
    freq.put("vsk", 184);
    freq.put("Jo\u0303g", 96);
    freq.put("\u0427", 60);
    freq.put("Jo\u0303e", 111);
    freq.put("kr ", 45);
    freq.put("\u043b\u044c", 338);
    freq.put("\u043b\u0430", 291);
    freq.put("\u043b\u0435", 285);
    freq.put("\u043b\u043b", 50);
    freq.put("\u4e4b", 249);
    freq.put("\u043b\u0438", 217);
    freq.put("\u043b\u043e", 200);
    freq.put("Sar", 178);
    freq.put("Sco", 47);
    freq.put("Sch", 374);
    freq.put(" ju", 2953);
    freq.put(" jt", 94);
    freq.put("kru", 92);
    freq.put(" jm", 152);
    freq.put(" jo", 514);
    freq.put("kri", 683);
    freq.put("kro", 695);
    freq.put("kra", 1232);
    freq.put(" ja", 20477);
    freq.put("kre", 1046);
    freq.put("\u041c\u0438\u0445", 58);
    freq.put("ino\u0303", 65);
    freq.put("ina\u0308", 160);
    freq.put("Po\u0303l", 225);
    freq.put("Po\u0303h", 1046);
    freq.put("Kle", 53);
    freq.put("Kla", 98);
    freq.put("Klo", 53);
    freq.put("Kli", 49);
    freq.put("Klu", 55);
    freq.put("iny", 57);
    freq.put("int", 1835);
    freq.put("inu", 4443);
    freq.put("inv", 62);
    freq.put("inr", 85);
    freq.put("ins", 667);
    freq.put("inl", 74);
    freq.put("inn", 6824);
    freq.put("ino", 606);
    freq.put("inh", 82);
    freq.put("ini", 4649);
    freq.put("inj", 49);
    freq.put("ink", 241);
    freq.put("ind", 2723);
    freq.put("ine", 12596);
    freq.put("inf", 422);
    freq.put("ing", 10735);
    freq.put("ina", 4896);
    freq.put("inb", 48);
    freq.put("inc", 157);
    freq.put("eo ", 141);
    freq.put("\u0435\u0442\u0440", 46);
    freq.put("in ", 2156);
    freq.put("eob", 44);
    freq.put("eog", 500);
    freq.put("eod", 99);
    freq.put("eok", 113);
    freq.put("eoo", 298);
    freq.put("eon", 217);
    freq.put("eom", 115);
    freq.put("eol", 658);
    freq.put("eos", 1290);
    freq.put("eor", 477);
    freq.put("eop", 87);
    freq.put("uor", 83);
    freq.put("eot", 431);
    freq.put("ja\u0308r", 2920);
    freq.put("rep", 269);
    freq.put("pto", 149);
    freq.put("So\u0303n", 78);
    freq.put("So\u0303j", 66);
    freq.put("So\u0303r", 64);
    freq.put(" G ", 69);
    freq.put("\u0418", 192);
    freq.put("le\u0301", 50);
    freq.put("pti", 246);
    freq.put("cm ", 52);
    freq.put("lo\u0303", 2040);
    freq.put("Tul", 130);
    freq.put("pte", 686);
    freq.put(" Gu", 492);
    freq.put(" Gr", 850);
    freq.put("Tun", 106);
    freq.put(" Gy", 49);
    freq.put(" Ge", 860);
    freq.put(" Ga", 590);
    freq.put(" Go", 366);
    freq.put(" Gl", 139);
    freq.put(" Gi", 307);
    freq.put("lo\u0308o\u0308", 149);
    freq.put("aku\u0308", 111);
    freq.put("glu\u0308", 44);
    freq.put("Ca", 1008);
    freq.put("aka\u0308", 47);
    freq.put("a\u0304", 654);
    freq.put("fa ", 46);
    freq.put("gl ", 95);
    freq.put("pts", 116);
    freq.put("\u062f", 159);
    freq.put("als", 1219);
    freq.put("slo", 247);
    freq.put("ak ", 324);
    freq.put("Vo\u0303", 414);
    freq.put(" Go\u0308", 60);
    freq.put("a\u0308b ", 221);
    freq.put(" Gu\u0308", 52);
    freq.put("sle", 179);
    freq.put("gli", 2195);
    freq.put("glo", 135);
    freq.put("aks", 8379);
    freq.put("gla", 352);
    freq.put("akp", 79);
    freq.put("\u30a2\u30a2\u30a2", 314);
    freq.put("aku", 957);
    freq.put("akt", 1317);
    freq.put("akk", 543);
    freq.put("aki", 1056);
    freq.put("ako", 2809);
    freq.put("Cu", 143);
    freq.put("akl", 109);
    freq.put("aka", 1199);
    freq.put(" \u0420\u043e", 57);
    freq.put("ake", 1191);
    freq.put("Jer", 96);
    freq.put("bru", 574);
    freq.put("bro", 86);
    freq.put("Jea", 76);
    freq.put("bri", 2225);
    freq.put("Jee", 58);
    freq.put("bre", 198);
    freq.put("Jen", 64);
    freq.put("bra", 389);
    freq.put("o\u0304 ", 113);
    freq.put("er ", 4533);
    freq.put("nka", 177);
    freq.put("nke", 134);
    freq.put("iu", 2821);
    freq.put("nkl", 53);
    freq.put("nko", 182);
    freq.put("nkr", 123);
    freq.put("nks", 69);
    freq.put("nkt", 721);
    freq.put("nku", 165);
    freq.put("ert", 1083);
    freq.put("ii", 25093);
    freq.put("erv", 749);
    freq.put("erp", 165);
    freq.put("err", 901);
    freq.put("ers", 969);
    freq.put("ik", 35922);
    freq.put("erz", 44);
    freq.put("erd", 390);
    freq.put("ere", 3347);
    freq.put("erf", 89);
    freq.put("erg", 1464);
    freq.put("tna", 202);
    freq.put("era", 2994);
    freq.put("erb", 550);
    freq.put("erc", 92);
    freq.put("erl", 431);
    freq.put("erm", 1039);
    freq.put("ern", 1144);
    freq.put("ero", 598);
    freq.put("erh", 103);
    freq.put("eri", 8620);
    freq.put("erj", 357);
    freq.put("erk", 288);
    freq.put("Aba", 83);
    freq.put("Abd", 79);
    freq.put("Abe", 61);
    freq.put("Abi", 49);
    freq.put("uas", 207);
    freq.put("uar", 1172);
    freq.put("la ", 5991);
    freq.put("uat", 112);
    freq.put("uai", 64);
    freq.put("Abr", 47);
    freq.put("mpe", 554);
    freq.put("uam", 44);
    freq.put("ual", 222);
    freq.put("\u043c ", 90);
    freq.put("uan", 196);
    freq.put("uaa", 347);
    freq.put("uad", 62);
    freq.put("ib", 3313);
    freq.put("i\u0304", 336);
    freq.put("mpo", 299);
    freq.put("lal", 666);
    freq.put("lam", 1233);
    freq.put("lan", 3578);
    freq.put("lao", 158);
    freq.put("lah", 1640);
    freq.put("lai", 1062);
    freq.put("laj", 204);
    freq.put("lak", 450);
    freq.put("lad", 1522);
    freq.put("lae", 732);
    freq.put("lag", 388);
    freq.put("laa", 1373);
    freq.put("lab", 404);
    freq.put("lac", 145);
    freq.put("al ", 9437);
    freq.put("lat", 2238);
    freq.put("lau", 1302);
    freq.put("lav", 840);
    freq.put("lap", 307);
    freq.put("lar", 440);
    freq.put("las", 6761);
    freq.put("o\u0303ul", 55);
    freq.put("eru\u0308", 78);
    freq.put("fai", 103);
    freq.put("fal", 91);
    freq.put("zen", 74);
    freq.put("zer", 96);
    freq.put("o\u0303ud", 589);
    freq.put("mbl", 329);
    freq.put("ze ", 109);
    freq.put("\u0142", 96);
    freq.put("l", 256122);
    freq.put("\u041d\u0438\u043a", 72);
    freq.put("\u0301", 52);
    freq.put("a\u0308n", 4791);
    freq.put("mbo", 263);
    freq.put("nt ", 1663);
    freq.put("\u042f", 49);
    freq.put("tso", 358);
    freq.put("kip", 117);
    freq.put("nts", 3190);
    freq.put("ntr", 629);
    freq.put("ntu", 1152);
    freq.put("nti", 1551);
    freq.put("nth", 107);
    freq.put("o\u0304k", 47);
    freq.put("nto", 594);
    freq.put("ntn", 44);
    freq.put("nta", 1333);
    freq.put("nte", 1954);
    freq.put("kik", 66);
    freq.put("o\u0308st", 232);
    freq.put(" l ", 68);
    freq.put("tsj", 165);
    freq.put("i ", 67391);
    freq.put("kt ", 481);
    freq.put(" le", 1944);
    freq.put("B", 6049);
    freq.put(" la", 5115);
    freq.put(" lo", 3309);
    freq.put(" lk", 65);
    freq.put(" li", 6989);
    freq.put("o\u0308s ", 62);
    freq.put(" lu", 810);
    freq.put("tef", 53);
    freq.put("Sev", 74);
    freq.put("Ser", 245);
    freq.put("Sep", 56);
    freq.put("ktu", 547);
    freq.put("ktr", 1077);
    freq.put("kts", 955);
    freq.put("See", 1098);
    freq.put("Sed", 193);
    freq.put("kti", 1734);
    freq.put("Sea", 119);
    freq.put("Sen", 68);
    freq.put("Sem", 74);
    freq.put("Sel", 786);
    freq.put("kta", 184);
    freq.put("Sei", 87);
    freq.put("ter", 4969);
    freq.put("tes", 4048);
    freq.put("udu", 959);
    freq.put(" \u041a\u0443", 52);
    freq.put("tev", 754);
    freq.put("\u03c0", 59);
    freq.put(" la\u0308", 2715);
    freq.put("Qu", 132);
    freq.put(" O\u0308k", 64);
    freq.put(" lo\u0308", 96);
    freq.put(" lo\u0303", 1781);
    freq.put(" \u041a\u043e", 95);
    freq.put(" lu\u0308", 990);
    freq.put(" \u041a\u0430", 71);
    freq.put("tse", 5653);
    freq.put("ogl", 51);
    freq.put("uda", 566);
    freq.put("ma\u0308n", 1220);
    freq.put("ma\u0308l", 265);
    freq.put("ma\u0308g", 380);
    freq.put("d ", 44215);
    freq.put("ma\u0308e", 703);
    freq.put("ma\u0308r", 1565);
    freq.put("\u0435\u0440\u043d", 50);
    freq.put("em ", 2077);
    freq.put("\u0435\u0440\u0433", 55);
    freq.put("hrm", 49);
    freq.put("hro", 62);
    freq.put("hri", 254);
    freq.put("hre", 114);
    freq.put("hra", 59);
    freq.put("dn", 649);
    freq.put("do", 2346);
    freq.put("dl", 1518);
    freq.put("dm", 1746);
    freq.put("dj", 432);
    freq.put("dk", 488);
    freq.put("dh", 181);
    freq.put("di", 20365);
    freq.put("dg", 178);
    freq.put("dd", 200);
    freq.put("de", 25494);
    freq.put("db", 83);
    freq.put("da", 21215);
    freq.put("dz", 76);
    freq.put("dy", 147);
    freq.put("dv", 357);
    freq.put("dw", 178);
    freq.put("dt", 600);
    freq.put("du", 15412);
    freq.put("dr", 3163);
    freq.put("ds", 1055);
    freq.put("dp", 77);
    freq.put("eme", 1702);
    freq.put("ema", 5853);
    freq.put("emb", 1631);
    freq.put("emm", 105);
    freq.put("emo", 658);
    freq.put("emn", 126);
    freq.put("emi", 4057);
    freq.put("emk", 49);
    freq.put("emj", 89);
    freq.put("emu", 471);
    freq.put("ilo\u0303", 45);
    freq.put("pu\u0308s", 236);
    freq.put("emp", 531);
    freq.put("ems", 73);
    freq.put("w ", 514);
    freq.put("ma\u0308a\u0308", 557);
    freq.put(" I ", 313);
    freq.put("o\u0303zs", 53);
    freq.put("il ", 6055);
    freq.put("co ", 192);
    freq.put("we", 364);
    freq.put("wa", 716);
    freq.put("de\u0301", 47);
    freq.put("wo", 143);
    freq.put("wn", 69);
    freq.put(" Ir", 247);
    freq.put(" Is", 445);
    freq.put(" It", 383);
    freq.put("wi", 436);
    freq.put("ww", 59);
    freq.put(" Ii", 222);
    freq.put("du\u0308", 272);
    freq.put("ws", 111);
    freq.put(" Im", 143);
    freq.put(" In", 1484);
    freq.put(" Io", 55);
    freq.put("do\u0303", 82);
    freq.put(" Id", 463);
    freq.put(" Ig", 87);
    freq.put("ema\u0308", 170);
    freq.put("ild", 409);
    freq.put("ile", 1595);
    freq.put("ilb", 76);
    freq.put("cot", 61);
    freq.put("ila", 1146);
    freq.put("iln", 65);
    freq.put("ilo", 1161);
    freq.put("ill", 5963);
    freq.put("ilm", 2925);
    freq.put("ilj", 833);
    freq.put("ilk", 54);
    freq.put("ilh", 117);
    freq.put("ili", 8126);
    freq.put("ilv", 181);
    freq.put("ilt", 420);
    freq.put("ilu", 306);
    freq.put("va\u0308e", 751);
    freq.put("ils", 210);
    freq.put("ilp", 103);
    freq.put("va\u0308i", 1090);
    freq.put("va\u0308h", 435);
    freq.put("pu\u0308u\u0308", 159);
    freq.put("com", 86);
    freq.put("col", 137);
    freq.put("con", 154);
    freq.put("mbu", 182);
    freq.put("ai ", 831);
    freq.put("dz\u030c", 411);
    freq.put("mo\u0303n", 454);
    freq.put("aiu", 220);
    freq.put("ait", 1457);
    freq.put("aiv", 79);
    freq.put("ais", 922);
    freq.put("air", 125);
    freq.put("aim", 1277);
    freq.put("ail", 2117);
    freq.put("aio", 97);
    freq.put("ain", 2391);
    freq.put("aik", 874);
    freq.put("gne", 544);
    freq.put("aie", 299);
    freq.put("aid", 1846);
    freq.put("epa\u0308", 212);
    freq.put("gni", 103);
    freq.put("aia", 317);
    freq.put("gno", 68);
    freq.put("\u043c\u0435", 79);
    freq.put("\u043c\u0430", 140);
    freq.put("\u043c\u043e", 119);
    freq.put("ni ", 8348);
    freq.put("\u043c\u0438", 161);
    freq.put("Mu\u0308n", 49);
    freq.put("ep ", 59);
    freq.put("th ", 373);
    freq.put("nij", 103);
    freq.put("nik", 3655);
    freq.put("nih", 114);
    freq.put("nii", 935);
    freq.put("nin", 5067);
    freq.put("\u03c4", 124);
    freq.put("nil", 1691);
    freq.put("nim", 5797);
    freq.put("nib", 61);
    freq.put("nic", 153);
    freq.put("nia", 1970);
    freq.put("nif", 70);
    freq.put("nig", 327);
    freq.put("nid", 1206);
    freq.put("nie", 199);
    freq.put("nix", 49);
    freq.put("Y", 596);
    freq.put("nis", 5167);
    freq.put("nip", 222);
    freq.put("niv", 309);
    freq.put("nit", 1025);
    freq.put("niu", 138);
    freq.put("ept", 722);
    freq.put("epu", 101);
    freq.put("epr", 147);
    freq.put("eps", 46);
    freq.put("epp", 174);
    freq.put("tho", 135);
    freq.put("epo", 236);
    freq.put("epl", 50);
    freq.put("eph", 149);
    freq.put("epi", 674);
    freq.put("the", 496);
    freq.put("epe", 305);
    freq.put("tha", 245);
    freq.put("epa", 593);
    freq.put("rn ", 318);
    freq.put("u\u0308st", 1343);
    freq.put("u\u0308ss", 79);
    freq.put("Gar", 101);
    freq.put("Gan", 54);
    freq.put("Gam", 62);
    freq.put("Gal", 104);
    freq.put("\u0433\u043e\u0440", 67);
    freq.put("Gab", 56);
    freq.put("u\u0308si", 1015);
    freq.put("Tri", 130);
    freq.put("rni", 528);
    freq.put("rno", 131);
    freq.put("Tro", 136);
    freq.put("Tra", 219);
    freq.put("rna", 702);
    freq.put("Tre", 108);
    freq.put("rne", 1143);
    freq.put("rns", 89);
    freq.put("Tru", 76);
    freq.put("rnu", 569);
    freq.put("evo\u0303", 561);
    freq.put("u\u0308s ", 51);
    freq.put("rka", 216);
    freq.put("Lea", 56);
    freq.put("Lee", 284);
    freq.put("Leh", 50);
    freq.put("Lei", 135);
    freq.put("Lem", 45);
    freq.put("Len", 251);
    freq.put("Leo", 109);
    freq.put("Lep", 73);
    freq.put("Les", 48);
    freq.put("Lev", 81);
    freq.put("A\u0308", 128);
    freq.put("ple", 335);
    freq.put("pla", 985);
    freq.put("plo", 204);
    freq.put("pli", 241);
    freq.put("Le ", 49);
    freq.put("obo", 116);
    freq.put("obl", 782);
    freq.put("S\u030cve", 145);
    freq.put("obi", 400);
    freq.put("obe", 361);
    freq.put("oba", 165);
    freq.put("obu", 202);
    freq.put("obr", 390);
    freq.put("obs", 62);
    freq.put("u\u0308u\u0308", 2774);
    freq.put("wan", 110);
    freq.put("wal", 97);
    freq.put("way", 55);
    freq.put("war", 196);
    freq.put("\u043a\u0441\u0430", 105);
    freq.put("\u0442", 1384);
    freq.put(" na\u0308", 1534);
    freq.put(" nu\u0308", 110);
    freq.put(" \u0418\u0432", 73);
    freq.put(" no\u0303", 449);
    freq.put("O\u0308k", 67);
    freq.put("mtu", 96);
    freq.put("mte", 76);
    freq.put("u\u0308v", 138);
    freq.put("u\u0308t", 1243);
    freq.put("u\u0308r", 1208);
    freq.put("u\u0308s", 2571);
    freq.put("u\u0308p", 727);
    freq.put(" n ", 104);
    freq.put("\u041a\u0443", 52);
    freq.put("u\u0308f", 48);
    freq.put("u\u0308g", 358);
    freq.put("u\u0308d", 830);
    freq.put("u\u0308b", 167);
    freq.put("u\u0308a", 118);
    freq.put("u\u0308n", 5015);
    freq.put("u\u0308o", 89);
    freq.put("u\u0308l", 5410);
    freq.put("u\u0308m", 1677);
    freq.put("u\u0308k", 2636);
    freq.put("u\u0308h", 5389);
    freq.put(" ni", 6713);
    freq.put("mo\u0303o\u0303", 559);
    freq.put("kve", 117);
    freq.put(" no", 1262);
    freq.put(" nn", 71);
    freq.put(" na", 1142);
    freq.put(" ne", 1909);
    freq.put(" nd", 118);
    freq.put("kvi", 101);
    freq.put("\u0259", 85);
    freq.put("\u044e", 76);
    freq.put(" nu", 369);
    freq.put(" nt", 126);
    freq.put("Sk", 219);
    freq.put("\u041a\u043e", 96);
    freq.put("So", 1693);
    freq.put("\u041a\u0430", 72);
    freq.put("\u1100\u1161\u1100\u1161", 97);
    freq.put("gu ", 2469);
    freq.put("Mol", 99);
    freq.put("uma", 2384);
    freq.put(" \u041c\u0430", 83);
    freq.put(" \u041c\u043e", 47);
    freq.put(" \u041c\u0438", 98);
    freq.put("umm", 293);
    freq.put("\u043d ", 434);
    freq.put("umo", 96);
    freq.put("gub", 77);
    freq.put("gua", 174);
    freq.put("gug", 104);
    freq.put("gue", 138);
    freq.put("gud", 1131);
    freq.put("guk", 582);
    freq.put("gui", 112);
    freq.put("guo", 121);
    freq.put("gun", 555);
    freq.put("gum", 403);
    freq.put("gul", 521);
    freq.put("gus", 4478);
    freq.put("p", 61630);
    freq.put("gup", 144);
    freq.put("guv", 167);
    freq.put("guu", 62);
    freq.put("gut", 1041);
    freq.put("hte", 1012);
    freq.put("hta", 927);
    freq.put("htn", 93);
    freq.put("htm", 114);
    freq.put("htl", 468);
    freq.put("htk", 120);
    freq.put("hti", 872);
    freq.put("htu", 834);
    freq.put("htt", 114);
    freq.put("hts", 526);
    freq.put("htr", 54);
    freq.put("htp", 46);
    freq.put("ek ", 209);
    freq.put("\u0433", 616);
    freq.put("ht ", 1267);
    freq.put("o\u0303nn", 136);
    freq.put("\u10d0", 150);
    freq.put("gle", 108);
    freq.put("eko", 1441);
    freq.put("ekl", 132);
    freq.put("ekk", 441);
    freq.put("eki", 846);
    freq.put("eke", 406);
    freq.put("eka", 1625);
    freq.put("ekv", 84);
    freq.put("eku", 1116);
    freq.put("ekt", 2822);
    freq.put("eks", 6278);
    freq.put("ekr", 148);
    freq.put("Lo\u0303u", 592);
    freq.put(" \u0413\u0435", 81);
    freq.put("spa\u0308", 99);
    freq.put(" Ka", 3502);
    freq.put("kyl", 45);
    freq.put(" Ke", 1459);
    freq.put("Vla", 113);
    freq.put(" Kh", 87);
    freq.put(" Ki", 1200);
    freq.put(" Kn", 46);
    freq.put(" Ko", 2402);
    freq.put(" Kl", 320);
    freq.put(" Kr", 947);
    freq.put(" Kv", 67);
    freq.put(" Ku", 1637);
    freq.put(" il", 865);
    freq.put(" Ky", 76);
    freq.put(" im", 299);
    freq.put("F", 3428);
    freq.put("\u064a", 278);
    freq.put("kso", 186);
    freq.put("ibi", 192);
    freq.put("ibl", 123);
    freq.put("ibn", 54);
    freq.put("ibo", 94);
    freq.put("cas", 78);
    freq.put("car", 187);
    freq.put("ibe", 483);
    freq.put("cat", 96);
    freq.put("can", 142);
    freq.put("cal", 161);
    freq.put("ibr", 97);
    freq.put(" ig", 443);
    freq.put("ibu", 187);
    freq.put("ao ", 126);
    freq.put("spr", 203);
    freq.put("spu", 121);
    freq.put("spi", 353);
    freq.put("spo", 772);
    freq.put("spa", 687);
    freq.put("spe", 493);
    freq.put(" Ka\u0308", 196);
    freq.put(" Ko\u0308", 81);
    freq.put(" Ko\u0303", 416);
    freq.put(" Ku\u0308", 278);
    freq.put("aol", 220);
    freq.put("aok", 108);
    freq.put("aot", 356);
    freq.put("aos", 1245);
    freq.put("aor", 55);
    freq.put(" \u042d", 77);
    freq.put("ght", 152);
    freq.put("gha", 121);
    freq.put("Cha", 324);
    freq.put("Che", 117);
    freq.put("Chi", 112);
    freq.put("Jar", 46);
    freq.put("Jan", 141);
    freq.put("Re", 985);
    freq.put("Chr", 190);
    freq.put("\u044b ", 90);
    freq.put("Ra", 1769);
    freq.put("eo\u0303", 59);
    freq.put("Ro", 1769);
    freq.put("Rh", 72);
    freq.put("Ri", 1129);
    freq.put("Jaa", 509);
    freq.put("Iis", 118);
    freq.put("Iir", 94);
    freq.put("\u03b1", 274);
    freq.put("nol", 406);
    freq.put("nom", 241);
    freq.put("non", 176);
    freq.put("noo", 957);
    freq.put("noi", 73);
    freq.put("nok", 61);
    freq.put("nod", 52);
    freq.put("nof", 50);
    freq.put("nog", 106);
    freq.put("nob", 45);
    freq.put("mba", 251);
    freq.put("R ", 183);
    freq.put("not", 137);
    freq.put("\u0442\u0435\u0440", 49);
    freq.put("nop", 56);
    freq.put("nor", 508);
    freq.put("nos", 276);
    freq.put("aev", 851);
    freq.put("sou", 51);
    freq.put("em", 17859);
    freq.put("el", 44868);
    freq.put("eo", 4613);
    freq.put("en", 30509);
    freq.put("ei", 11617);
    freq.put("eh", 9506);
    freq.put("ek", 15889);
    freq.put("ej", 1876);
    freq.put("Ru\u0308", 62);
    freq.put("ed", 12410);
    freq.put("eg", 11045);
    freq.put("Afg", 70);
    freq.put("ea", 10628);
    freq.put("rl ", 207);
    freq.put("ec", 855);
    freq.put("eb", 4711);
    freq.put("Ra\u0308", 65);
    freq.put("ey", 521);
    freq.put("ex", 366);
    freq.put("ez", 242);
    freq.put("eu", 1294);
    freq.put("et", 21350);
    freq.put("ew", 508);
    freq.put("ev", 10732);
    freq.put("eq", 50);
    freq.put("ep", 3591);
    freq.put("es", 49834);
    freq.put("er", 30979);
    freq.put("eK", 296);
    freq.put("\u0633", 100);
    freq.put("glu", 61);
    freq.put("s\u030cii", 58);
    freq.put(" \u0417", 71);
    freq.put("rlo", 160);
    freq.put("rli", 332);
    freq.put("eta\u0308", 142);
    freq.put("rle", 265);
    freq.put("rld", 67);
    freq.put("lms", 87);
    freq.put("rla", 365);
    freq.put("e ", 97234);
    freq.put("\u03bf\u0301", 79);
    freq.put(" \u041a", 315);
    freq.put("lmn", 103);
    freq.put("a\u0308rd", 69);
    freq.put("lma", 2491);
    freq.put("lme", 771);
    freq.put("lla", 3994);
    freq.put("zan", 66);
    freq.put("xi", 267);
    freq.put("xa", 160);
    freq.put("zab", 50);
    freq.put("xe", 69);
    freq.put("mel", 1042);
    freq.put("zar", 62);
    freq.put("xt", 76);
    freq.put("Eur", 956);
    freq.put("yin", 76);
    freq.put("Sa\u0308", 63);
    freq.put("x ", 556);
    freq.put("za ", 111);
    freq.put("pni", 140);
    freq.put("pne", 50);
    freq.put("\u0432\u043d\u0430", 76);
    freq.put("es\u030c", 58);
    freq.put("øya", 60);
    freq.put("ez\u030c", 190);
    freq.put("Phi", 103);
    freq.put("Pho", 46);
    freq.put("egl", 195);
    freq.put("\u062f ", 87);
    freq.put("\u043a\u0430 ", 82);
    freq.put("\u1100\u1161", 148);
    freq.put("usr", 193);
    freq.put("Wei", 45);
    freq.put("Weh", 50);
    freq.put("Wes", 117);
    freq.put(" p ", 48);
    freq.put("\u043d\u0441", 154);
    freq.put("\u043d\u0442", 92);
    freq.put("\u043d\u044b", 111);
    freq.put(" ps", 246);
    freq.put(" pr", 4024);
    freq.put("\u043d\u0430", 391);
    freq.put(" pu", 1946);
    freq.put("\u043d\u043d", 108);
    freq.put(" px", 82);
    freq.put("\u043d\u0438", 279);
    freq.put("\u043d\u043a", 74);
    freq.put(" pa", 3723);
    freq.put(" pe", 3640);
    freq.put(" pi", 4298);
    freq.put(" po", 5154);
    freq.put(" pl", 542);
    freq.put("u\u0308u\u0308s", 557);
    freq.put("uvo", 58);
    freq.put("Kr ", 310);
    freq.put("vu ", 181);
    freq.put(" po\u0308", 222);
    freq.put(" po\u0303", 3044);
    freq.put(" pu\u0308", 607);
    freq.put("Kri", 267);
    freq.put("Kro", 87);
    freq.put(" pa\u0308", 1847);
    freq.put("Kra", 186);
    freq.put("u\u0308u\u0308a", 70);
    freq.put("Kre", 312);
    freq.put("vud", 63);
    freq.put("u\u0308u\u0308g", 68);
    freq.put("vul", 243);
    freq.put("vum", 73);
    freq.put("S", 15988);
    freq.put("\u03b1 ", 91);
    freq.put("vut", 793);
    freq.put("vus", 2887);
    freq.put("jt ", 90);
    freq.put("hvi", 258);
    freq.put("hvk", 76);
    freq.put("hva", 963);
    freq.put("hve", 131);
    freq.put("hvu", 1043);
    freq.put(" Ma\u0308", 338);
    freq.put(" Mo\u0303", 229);
    freq.put(" Mu\u0308", 121);
    freq.put("TU\u0308 ", 47);
    freq.put("\u0446", 201);
    freq.put("hv ", 86);
    freq.put("lle", 7577);
    freq.put("eip", 60);
    freq.put("eis", 4050);
    freq.put("eir", 116);
    freq.put("eiu", 148);
    freq.put("eit", 602);
    freq.put("eiv", 45);
    freq.put("eia", 95);
    freq.put("CO ", 51);
    freq.put("eic", 64);
    freq.put("eib", 48);
    freq.put("eie", 63);
    freq.put("eid", 2255);
    freq.put("eig", 71);
    freq.put("eii", 45);
    freq.put("eik", 96);
    freq.put("eim", 514);
    freq.put("eil", 387);
    freq.put("ein", 1247);
    freq.put("SD ", 47);
    freq.put("o\u0303va", 82);
    freq.put("o\u0303ve", 54);
    freq.put(" Me", 1354);
    freq.put(" Ma", 3863);
    freq.put(" Mc", 62);
    freq.put(" Mo", 1366);
    freq.put(" Mi", 1232);
    freq.put(" Mu", 873);
    freq.put(" My", 96);
    freq.put("cel", 80);
    freq.put("ete", 3476);
    freq.put("ux ", 63);
    freq.put("tli", 1813);
    freq.put(" M ", 95);
    freq.put("eto", 650);
    freq.put("cci", 47);
    freq.put("am ", 1037);
    freq.put("ps ", 115);
    freq.put("a\u0301n", 134);
    freq.put("uu ", 547);
    freq.put("a\u0301r", 59);
    freq.put("co", 978);
    freq.put("\u041c", 293);
    freq.put("cm", 60);
    freq.put("lg ", 112);
    freq.put("Na\u0308i", 96);
    freq.put("a\u0301 ", 83);
    freq.put("amj", 57);
    freq.put("amm", 1132);
    freq.put("aml", 63);
    freq.put("amo", 227);
    freq.put("lu\u0308l", 150);
    freq.put("ama", 4891);
    freq.put("amb", 788);
    freq.put("ame", 2122);
    freq.put(" Fu\u0308", 63);
    freq.put("amp", 318);
    freq.put("ams", 141);
    freq.put("amu", 491);
    freq.put("amt", 68);
    freq.put("ß", 76);
    freq.put("psu", 187);
    freq.put("gjo", 58);
    freq.put("t", 258531);
    freq.put("gji", 57);
    freq.put("vo\u0303", 10296);
    freq.put("uca", 46);
    freq.put("cs", 86);
    freq.put(" \u043f\u0440", 54);
    freq.put("uck", 66);
    freq.put("uci", 50);
    freq.put("uch", 100);
    freq.put("ama\u0308", 398);
    freq.put("nme", 49);
    freq.put("amu\u0308", 61);
    freq.put("psu\u0308", 231);
    freq.put("lu\u0308u\u0308", 275);
    freq.put("io\u0303p", 167);
    freq.put("amo\u0303", 135);
    freq.put(" \u043f\u043e", 46);
    freq.put("sra", 250);
    freq.put("sre", 70);
    freq.put("sri", 388);
    freq.put("Ka\u0308r", 84);
    freq.put("Adv", 74);
    freq.put("ys ", 119);
    freq.put("Ade", 47);
    freq.put("Ada", 90);
    freq.put("Ado", 56);
    freq.put("lob", 91);
    freq.put("loc", 108);
    freq.put("log", 273);
    freq.put("lod", 57);
    freq.put("loe", 826);
    freq.put("lok", 121);
    freq.put("loh", 62);
    freq.put("loi", 81);
    freq.put("lon", 328);
    freq.put("loo", 6341);
    freq.put("lol", 75);
    freq.put("lom", 526);
    freq.put("lor", 264);
    freq.put("los", 787);
    freq.put("lop", 192);
    freq.put("lov", 353);
    freq.put("lot", 130);
    freq.put("rju", 905);
    freq.put("\u0646", 161);
    freq.put("pu ", 143);
    freq.put("J", 4779);
    freq.put("rje", 754);
    freq.put("rja", 2847);
    freq.put("rjo", 50);
    freq.put("lo ", 301);
    freq.put("ja\u0308a\u0308", 730);
    freq.put("Est", 182);
    freq.put("\u043a\u0430\u044f", 100);
    freq.put(" sc", 47);
    freq.put("Esi", 185);
    freq.put("Lam", 60);
    freq.put("Lan", 154);
    freq.put("Lah", 103);
    freq.put("Lai", 145);
    freq.put("Lak", 57);
    freq.put("Lad", 56);
    freq.put("Lae", 57);
    freq.put("Lag", 77);
    freq.put("Laa", 70);
    freq.put("Lau", 185);
    freq.put("Lap", 96);
    freq.put("Lar", 49);
    freq.put("Las", 93);
    freq.put("lga", 1157);
    freq.put("O\u0303p", 48);
    freq.put("rja\u0308", 49);
    freq.put("ja\u0308l", 102);
    freq.put("ja\u0308i", 81);
    freq.put("Bru", 68);
    freq.put("La ", 89);
    freq.put("Bro", 108);
    freq.put("Bri", 271);
    freq.put("ja\u0308t", 125);
    freq.put("Bre", 116);
    freq.put("Bra", 266);
    freq.put("O\u0303h", 47);
    freq.put("mp ", 57);
    freq.put(" ro\u0303", 177);
    freq.put(" ro\u0308", 76);
    freq.put("mpa", 252);
    freq.put(" ru\u0308", 649);
    freq.put("mpl", 310);
    freq.put("mph", 51);
    freq.put("mpi", 452);
    freq.put(" ra\u0308", 537);
    freq.put("mpu", 89);
    freq.put("mpr", 66);
    freq.put("mps", 61);
    freq.put("pul", 391);
    freq.put("to\u0308o\u0308", 1589);
    freq.put("pui", 197);
    freq.put(" ru", 423);
    freq.put(" re", 2103);
    freq.put(" ra", 5080);
    freq.put(" ro", 1241);
    freq.put(" ri", 3272);
    freq.put("ves", 902);
    freq.put("s\u030c", 2423);
    freq.put("ofu\u0308", 93);
    freq.put("put", 156);
    freq.put(" U\u0308 ", 59);
    freq.put("S ", 641);
    freq.put("pur", 257);
    freq.put("pus", 270);
    freq.put("Sy", 110);
    freq.put("vk", 322);
    freq.put("fo\u0308", 145);
    freq.put("Sp", 264);
    freq.put("fu\u0308", 589);
    freq.put("Sv", 158);
    freq.put("Su", 1472);
    freq.put("St", 1249);
    freq.put("FC ", 88);
    freq.put("Si", 1380);
    freq.put("Sh", 515);
    freq.put("fa\u0308", 213);
    freq.put("Sm", 85);
    freq.put("Sl", 182);
    freq.put("Sc", 514);
    freq.put("Sa", 3549);
    freq.put(" U\u0308l", 578);
    freq.put("Se", 3048);
    freq.put(" U\u0308h", 851);
    freq.put("vs", 891);
    freq.put("f ", 1128);
    freq.put("hha", 319);
    freq.put("hhi", 366);
    freq.put("hho", 288);
    freq.put("ob ", 139);
    freq.put("eg ", 436);
    freq.put("fr", 799);
    freq.put("fs", 80);
    freq.put("ft", 358);
    freq.put("fu", 505);
    freq.put("Su\u0308", 198);
    freq.put("So\u0308", 54);
    freq.put("So\u0303", 312);
    freq.put("fa", 820);
    freq.put("fe", 1177);
    freq.put("ff", 336);
    freq.put("fg", 90);
    freq.put("fi", 3834);
    freq.put("fj", 156);
    freq.put("fl", 261);
    freq.put("fo", 2004);
    freq.put("a", 496421);
    freq.put("egs", 221);
    freq.put("egr", 208);
    freq.put("egu", 1523);
    freq.put("egi", 861);
    freq.put("ego", 223);
    freq.put("egn", 128);
    freq.put("o\u0308", 8126);
    freq.put("ega", 4991);
    freq.put("ege", 2106);
    freq.put("ce ", 506);
    freq.put("y ", 2468);
    freq.put("uvu", 186);
    freq.put("uvi", 326);
    freq.put("ffi", 97);
    freq.put("os ", 1676);
    freq.put("uva", 2014);
    freq.put("ffe", 80);
    freq.put("uve", 246);
    freq.put(" On", 146);
    freq.put(" Oo", 46);
    freq.put(" Ol", 339);
    freq.put(" Om", 122);
    freq.put(" Ok", 124);
    freq.put(" Oh", 110);
    freq.put(" Oi", 46);
    freq.put(" Of", 45);
    freq.put(" Od", 87);
    freq.put(" Ob", 154);
    freq.put(" Ot", 172);
    freq.put(" Ou", 77);
    freq.put(" Or", 497);
    freq.put(" Os", 431);
    freq.put(" Op", 127);
    freq.put("yi", 121);
    freq.put("rwa", 50);
    freq.put("yk", 76);
    freq.put("ym", 152);
    freq.put("yl", 325);
    freq.put("aso\u0303", 365);
    freq.put("AO ", 53);
    freq.put("ya", 457);
    freq.put("cen", 106);
    freq.put("yc", 105);
    freq.put("yb", 52);
    freq.put("ye", 201);
    freq.put("yd", 131);
    freq.put("yg", 56);
    freq.put("asu\u0308", 91);
    freq.put("ces", 126);
    freq.put("uv ", 1217);
    freq.put("yp", 88);
    freq.put("ys", 416);
    freq.put("yr", 185);
    freq.put("yt", 138);
    freq.put("ff ", 69);
    freq.put("ifu", 44);
    freq.put(" a\u0308a\u0308", 835);
    freq.put(" O ", 93);
    freq.put("ife", 183);
    freq.put("ifa", 59);
    freq.put("ifo", 208);
    freq.put("ifi", 363);
    freq.put("o\u0303tu\u0308", 68);
    freq.put("Ena", 97);
    freq.put("End", 51);
    freq.put("Ene", 66);
    freq.put("Eng", 50);
    freq.put("c\u030c", 90);
    freq.put("uvo\u0303", 268);
    freq.put("\u4e13", 99);
    freq.put("as ", 16624);
    freq.put("Ent", 53);
    freq.put("uva\u0308", 105);
    freq.put("o\u0303t ", 51);
    freq.put("\u0434\u0440\u043e", 45);
    freq.put("ass", 1978);
    freq.put("asr", 56);
    freq.put("pun", 658);
    freq.put("asp", 282);
    freq.put("puh", 552);
    freq.put("asv", 597);
    freq.put("asu", 6462);
    freq.put("ast", 15872);
    freq.put("pud", 66);
    freq.put("pub", 112);
    freq.put("asc", 73);
    freq.put("asa", 1531);
    freq.put("ase", 3414);
    freq.put("ask", 962);
    freq.put("asj", 302);
    freq.put("asi", 2682);
    freq.put("ash", 208);
    freq.put("aso", 395);
    freq.put("asn", 174);
    freq.put("asm", 178);
    freq.put("asl", 169);
    freq.put("o\u0303ta", 58);
    freq.put("o\u0303te", 379);
    freq.put("o\u0303tj", 101);
    freq.put("o\u0303tl", 100);
    freq.put("o\u0303tm", 273);
    freq.put("o\u0303tt", 671);
    freq.put("o\u0303tu", 46);
    freq.put(" a\u0308r", 293);
    freq.put("Cla", 86);
    freq.put("Imp", 71);
    freq.put("Clu", 51);
    freq.put("osu\u0308", 192);
    freq.put("st ", 19438);
    freq.put("dt ", 79);
    freq.put("lio\u0303", 138);
    freq.put("ncy", 54);
    freq.put("tfo", 51);
    freq.put("tfa", 78);
    freq.put("nch", 174);
    freq.put("nci", 160);
    freq.put("nco", 82);
    freq.put("nce", 327);
    freq.put("ste", 12441);
    freq.put("stf", 123);
    freq.put("yo\u0304", 62);
    freq.put("sta", 12430);
    freq.put("stl", 1467);
    freq.put("stm", 389);
    freq.put("stn", 305);
    freq.put("sto", 736);
    freq.put("sti", 11558);
    freq.put("dte", 403);
    freq.put("stk", 190);
    freq.put("stu", 4098);
    freq.put("stv", 203);
    freq.put("str", 2584);
    freq.put("sts", 374);
    freq.put("Gol", 71);
    freq.put("ka ", 8332);
    freq.put("ez\u030ci", 152);
    freq.put("Got", 58);
    freq.put("Gor", 73);
    freq.put("lid", 1460);
    freq.put("Nik", 161);
    freq.put("lif", 188);
    freq.put("Nii", 60);
    freq.put("lia", 1378);
    freq.put("lib", 211);
    freq.put("Nim", 92);
    freq.put("lil", 1193);
    freq.put("Nic", 90);
    freq.put("lin", 10479);
    freq.put("lio", 191);
    freq.put("lih", 443);
    freq.put("Nig", 95);
    freq.put("lij", 133);
    freq.put("lik", 8420);
    freq.put("lit", 3006);
    freq.put("liu", 274);
    freq.put("liv", 165);
    freq.put("2 ", 198);
    freq.put("lir", 127);
    freq.put("lis", 12972);
    freq.put("liz", 82);
    freq.put("kab", 194);
    freq.put("kaa", 1822);
    freq.put("kag", 415);
    freq.put("kae", 301);
    freq.put("kad", 579);
    freq.put("kak", 404);
    freq.put("kaj", 243);
    freq.put("kai", 1321);
    freq.put("kah", 1019);
    freq.put("kao", 86);
    freq.put("kan", 1568);
    freq.put("kam", 275);
    freq.put("kal", 1965);
    freq.put("rhi", 386);
    freq.put("kar", 907);
    freq.put("kap", 253);
    freq.put("kav", 342);
    freq.put("kau", 1221);
    freq.put("kat", 1523);
    freq.put("rha", 144);
    freq.put("The", 470);
    freq.put("rhe", 141);
    freq.put("li ", 8571);
    freq.put("uur", 5973);
    freq.put("sto\u0303", 73);
    freq.put("sto\u0308", 240);
    freq.put("ta\u0308p", 255);
    freq.put("\u0420", 154);
    freq.put("ox ", 49);
    freq.put(" ts\u030c", 115);
    freq.put("a\u0303", 61);
    freq.put("x", 1328);
    freq.put("\u0430\u044f ", 201);
    freq.put("stj", 94);
    freq.put("wor", 58);
    freq.put("Ple", 51);
    freq.put("Pla", 187);
    freq.put("lo\u0303p", 469);
    freq.put("tso\u0303", 45);
    freq.put("Obe", 69);
    freq.put("gmi", 89);
    freq.put("lo\u0303u", 988);
    freq.put("\u0561", 118);
    freq.put("duv", 409);
    freq.put("o\u0303s\u030c", 48);
    freq.put("Wal", 182);
    freq.put("Wat", 77);
    freq.put("Was", 59);
    freq.put("War", 74);
    freq.put("\u0430\u0435\u0432", 60);
    freq.put(" t ", 61);
    freq.put(" tu", 3292);
    freq.put(" ts", 358);
    freq.put(" tr", 1088);
    freq.put("N", 6533);
    freq.put(" to", 2603);
    freq.put(" ti", 918);
    freq.put(" th", 387);
    freq.put(" te", 10216);
    freq.put(" ta", 4816);
    freq.put("o\u0303o\u0303", 933);
    freq.put("bos", 56);
    freq.put("Aja", 140);
    freq.put("Kva", 53);
    freq.put("gs ", 53);
    freq.put("vy ", 55);
    freq.put("o\u0303 ", 118);
    freq.put("ohn", 161);
    freq.put(" tu\u0308", 520);
    freq.put("bon", 137);
    freq.put("lie", 227);
    freq.put(" to\u0308", 1012);
    freq.put(" to\u0303", 919);
    freq.put("lig", 496);
    freq.put("FA ", 50);
    freq.put(" ta\u0308", 3294);
    freq.put("sa\u0308i", 178);
    freq.put("o\u0303z", 69);
    freq.put("o\u0303u", 3856);
    freq.put("o\u0303t", 1896);
    freq.put("o\u0303v", 176);
    freq.put("o\u0303p", 1548);
    freq.put("o\u0303s", 403);
    freq.put("o\u0303r", 3591);
    freq.put("o\u0303m", 351);
    freq.put("o\u0303l", 2454);
    freq.put("o\u0303o", 45);
    freq.put("o\u0303n", 2300);
    freq.put("gse", 607);
    freq.put("o\u0303h", 4577);
    freq.put("o\u0303k", 165);
    freq.put("o\u0303j", 1645);
    freq.put("o\u0303e", 2011);
    freq.put("o\u0303d", 527);
    freq.put("o\u0303g", 861);
    freq.put("o\u0303b", 159);
    freq.put("hju", 407);
    freq.put("lii", 5503);
    freq.put("hje", 45);
    freq.put("hja", 2408);
    freq.put("ohi", 105);
    freq.put("\u03b9", 145);
    freq.put("lip", 448);
    freq.put("ee ", 3170);
    freq.put("eet", 2444);
    freq.put("eev", 114);
    freq.put("eep", 225);
    freq.put("ees", 3817);
    freq.put("eer", 4899);
    freq.put("eem", 2642);
    freq.put("eel", 7467);
    freq.put("een", 1833);
    freq.put("eeh", 72);
    freq.put("eek", 1260);
    freq.put("eej", 166);
    freq.put("eed", 1212);
    freq.put("eeg", 511);
    freq.put("eea", 50);
    freq.put("eeb", 812);
    freq.put("ru ", 1080);
    freq.put("ohe", 234);
    freq.put("ld ", 1107);
    freq.put("Ts\u030c", 407);
    freq.put(" Qu", 130);
    freq.put("To\u0304", 50);
    freq.put("\u0437", 300);
    freq.put("\u0434\u0440 ", 56);
    freq.put("id ", 9461);
    freq.put("ruk", 513);
    freq.put("run", 460);
    freq.put("rul", 170);
    freq.put("rum", 712);
    freq.put("rub", 87);
    freq.put("ruc", 52);
    freq.put("rua", 490);
    freq.put("rug", 66);
    freq.put("rud", 172);
    freq.put("rue", 78);
    freq.put("rus", 1487);
    freq.put("rup", 396);
    freq.put("ruv", 117);
    freq.put("rut", 261);
    freq.put("ruu", 777);
    freq.put("Tho", 103);
    freq.put("tui", 121);
    freq.put("idu", 2141);
    freq.put("idr", 54);
    freq.put("ids", 89);
    freq.put("idn", 61);
    freq.put("ido", 139);
    freq.put("idl", 140);
    freq.put("idm", 73);
    freq.put("idi", 1042);
    freq.put("idg", 52);
    freq.put("ide", 8097);
    freq.put("ida", 3662);
    freq.put("Tu\u0308", 236);
    freq.put("Eli", 126);
    freq.put("rho", 51);
    freq.put("Ell", 63);
    freq.put("To\u0308", 129);
    freq.put("Ela", 50);
    freq.put("Ele", 225);
    freq.put("Ta\u0308", 315);
    freq.put("ut ", 606);
    freq.put("\u0434\u043e\u0440", 45);
    freq.put("\u4e26", 138);
    freq.put("kus", 4511);
    freq.put("o\u0303rd", 333);
    freq.put("tum", 1084);
    freq.put("o\u0303rg", 1625);
    freq.put("o\u0303ra", 75);
    freq.put("o\u0303rb", 100);
    freq.put("ute", 1328);
    freq.put("o\u0303rm", 46);
    freq.put("sva\u0308", 103);
    freq.put("uti", 1297);
    freq.put("utn", 50);
    freq.put("o\u0303ri", 60);
    freq.put("o\u0303rj", 81);
    freq.put("o\u0303rk", 196);
    freq.put("utr", 121);
    freq.put("o\u0303ru", 187);
    freq.put("o\u0303rv", 475);
    freq.put("utv", 93);
    freq.put("o\u0303rr", 267);
    freq.put("utu", 2313);
    freq.put("svo\u0308", 80);
    freq.put("svo\u0303", 164);
    freq.put("Ty", 76);
    freq.put("Tv", 68);
    freq.put("Tu", 682);
    freq.put("Tr", 728);
    freq.put("Ts", 169);
    freq.put("To", 953);
    freq.put("Th", 747);
    freq.put("Ti", 538);
    freq.put("ooa", 118);
    freq.put("Te", 1883);
    freq.put("Ta", 4354);
    freq.put("nab", 249);
    freq.put("A ", 1491);
    freq.put("naa", 1844);
    freq.put("naf", 95);
    freq.put("nag", 661);
    freq.put("nad", 869);
    freq.put("nae", 164);
    freq.put("naj", 121);
    freq.put("nak", 847);
    freq.put("nah", 165);
    freq.put("nai", 421);
    freq.put("nan", 791);
    freq.put("nao", 524);
    freq.put("nal", 1444);
    freq.put("nam", 1141);
    freq.put("nar", 696);
    freq.put("nas", 5608);
    freq.put("nap", 666);
    freq.put("nav", 684);
    freq.put("nat", 1014);
    freq.put("nau", 173);
    freq.put("oon", 7646);
    freq.put("T ", 213);
    freq.put("tmu", 55);
    freq.put("idz\u030c", 109);
    freq.put("svo", 72);
    freq.put("a\u0308ti", 288);
    freq.put("Ab", 517);
    freq.put("e", 425996);
    freq.put("Ad", 407);
    freq.put("a\u0308tm", 48);
    freq.put("svi", 156);
    freq.put("Ai", 278);
    freq.put("Ah", 170);
    freq.put("Ak", 327);
    freq.put("sve", 77);
    freq.put("dva", 107);
    freq.put("Al", 2030);
    freq.put("An", 1589);
    freq.put("Ap", 221);
    freq.put("As", 1550);
    freq.put("Ar", 1361);
    freq.put("Au", 837);
    freq.put("At", 438);
    freq.put("Av", 172);
    freq.put("dvu", 88);
    freq.put("svu", 249);
    freq.put("a\u0308tt", 141);
    freq.put("gv", 123);
    freq.put("gu", 12657);
    freq.put("gt", 248);
    freq.put("gs", 906);
    freq.put("gr", 3204);
    freq.put("gp", 765);
    freq.put("gy", 115);
    freq.put("gg", 188);
    freq.put("ge", 11091);
    freq.put("gd", 177);
    freq.put("ga", 17189);
    freq.put("go", 1593);
    freq.put("gn", 1067);
    freq.put("gm", 312);
    freq.put("gl", 3003);
    freq.put("gk", 631);
    freq.put("gj", 169);
    freq.put("gi", 15351);
    freq.put("gh", 514);
    freq.put("lko", 770);
    freq.put("lkl", 73);
    freq.put("Noo", 108);
    freq.put("lki", 380);
    freq.put("\u0428", 75);
    freq.put("lke", 205);
    freq.put("lka", 667);
    freq.put("Nov", 157);
    freq.put("lku", 106);
    freq.put("\u03bd", 197);
    freq.put("Nor", 978);
    freq.put("hu\u0308p", 189);
    freq.put("\u0438\u043d ", 106);
    freq.put("rti", 1255);
    freq.put("g ", 7339);
    freq.put("iu\u0308l", 54);
    freq.put("rtu", 1315);
    freq.put("lk ", 259);
    freq.put("iu\u0308h", 71);
    freq.put("Spo", 69);
    freq.put("Spa", 44);
    freq.put("tmo", 97);
    freq.put("Spe", 59);
    freq.put("\u0440\u0442", 59);
    freq.put("\u0440\u0443", 71);
    freq.put("zn", 53);
    freq.put("\u0440\u0441", 87);
    freq.put("zh", 68);
    freq.put("zi", 492);
    freq.put("ze", 455);
    freq.put("gu\u0308", 68);
    freq.put("za", 431);
    freq.put("\u0440\u044c", 62);
    freq.put("zy", 50);
    freq.put("zz", 105);
    freq.put("zu", 144);
    freq.put("zs", 86);
    freq.put("ulj", 361);
    freq.put("hu\u0308u\u0308", 97);
    freq.put("lko\u0303", 156);
    freq.put("z ", 542);
    freq.put("ulg", 972);
    freq.put("\u0440\u0433", 121);
    freq.put("\u0440\u0430", 317);
    freq.put("\u0440\u0434", 63);
    freq.put("\u0440\u0435", 208);
    freq.put("\u0440\u043a", 48);
    freq.put("\u0440\u0438", 296);
    freq.put("\u0440\u043e", 406);
    freq.put("\u0440\u043d", 83);
    freq.put("wig", 128);
    freq.put("wic", 50);
    freq.put("win", 68);
    freq.put("wit", 44);
    freq.put(" va\u0308", 4759);
    freq.put(" vo\u0303", 8473);
    freq.put("To\u0303n", 45);
    freq.put(" vo\u0308", 80);
    freq.put(" vu\u0308", 80);
    freq.put("Ji", 117);
    freq.put("ied", 249);
    freq.put(" va", 12420);
    freq.put(" ve", 4280);
    freq.put(" vi", 1606);
    freq.put(" vk", 47);
    freq.put(" vm", 99);
    freq.put(" vo", 1317);
    freq.put(" jn", 167);
    freq.put(" vu", 102);
    freq.put("hic", 69);
    freq.put("TO ", 49);
    freq.put("jne", 167);
    freq.put("\u0430\u0438\u0306 ", 47);
    freq.put("\u0628", 196);
    freq.put("\u0435\u043a\u0441", 141);
    freq.put("c\u0327", 89);
    freq.put("\u0430\u043b\u044c", 66);
    freq.put("mar", 885);
    freq.put("hli", 44);
    freq.put("hle", 125);
    freq.put("hla", 75);
    freq.put("mav", 524);
    freq.put("uso\u0303", 228);
    freq.put("\u043f", 426);
    freq.put("eco", 81);
    freq.put(" Pa\u0308", 659);
    freq.put("eck", 136);
    freq.put("eci", 98);
    freq.put("ech", 210);
    freq.put("\u4e26 ", 57);
    freq.put("ect", 151);
    freq.put("mab", 268);
    freq.put("\u0430\u043b\u0438", 51);
    freq.put("rs ", 316);
    freq.put("cy ", 83);
    freq.put(" Sy", 110);
    freq.put("be ", 205);
    freq.put(" Sv", 156);
    freq.put(" St", 1223);
    freq.put(" Su", 1464);
    freq.put(" Sk", 219);
    freq.put(" Sh", 511);
    freq.put(" Si", 1350);
    freq.put(" So", 1682);
    freq.put(" Sl", 182);
    freq.put(" Sm", 84);
    freq.put(" Sc", 495);
    freq.put(" Sa", 3543);
    freq.put(" Se", 3040);
    freq.put("rso", 171);
    freq.put("rsh", 62);
    freq.put("rsi", 519);
    freq.put("rsk", 243);
    freq.put("rse", 561);
    freq.put("rsa", 171);
    freq.put("rsc", 53);
    freq.put("AS ", 102);
    freq.put("rst", 515);
    freq.put("rsu", 190);
    freq.put("rss", 168);
    freq.put("bek", 156);
    freq.put("ben", 167);
    freq.put("bel", 642);
    freq.put("bem", 51);
    freq.put("bec", 51);
    freq.put("bed", 61);
    freq.put("bee", 78);
    freq.put("ber", 2586);
    freq.put("bes", 968);
    freq.put(" S ", 141);
    freq.put("bet", 314);
    freq.put("\u0415", 66);
    freq.put("rtu\u0308", 56);
    freq.put("ur ", 1500);
    freq.put(" Su\u0308", 194);
    freq.put(" So\u0308", 54);
    freq.put(" So\u0303", 311);
    freq.put("Dep", 48);
    freq.put("\u4e39", 47);
    freq.put("usu\u0308", 545);
    freq.put(" Sa\u0308", 63);
    freq.put("sm", 4289);
    freq.put("Dev", 50);
    freq.put("awa", 117);
    freq.put("urd", 430);
    freq.put("ure", 1850);
    freq.put("urg", 757);
    freq.put("fjo", 141);
    freq.put("ura", 699);
    freq.put("urb", 400);
    freq.put("o\u0303pi", 263);
    freq.put("url", 67);
    freq.put("urm", 383);
    freq.put("urn", 372);
    freq.put("o\u0303pe", 513);
    freq.put("uri", 3709);
    freq.put("urj", 163);
    freq.put("urk", 267);
    freq.put("\u0444\u043e", 51);
    freq.put("uru", 948);
    freq.put("urv", 239);
    freq.put("urr", 134);
    freq.put("urs", 299);
    freq.put("bun", 75);
    freq.put("o\u0303pu", 202);
    freq.put("o\u0303pp", 472);
    freq.put("Den", 66);
    freq.put("z\u030cis", 93);
    freq.put("z\u030cik", 69);
    freq.put("z\u030cii", 61);
    freq.put("ngd", 44);
    freq.put("nge", 1413);
    freq.put("nga", 1383);
    freq.put("ngl", 2197);
    freq.put("ngo", 283);
    freq.put("ngh", 131);
    freq.put("ngi", 2407);
    freq.put("ngj", 112);
    freq.put("ngk", 485);
    freq.put("sh ", 174);
    freq.put("ngu", 1971);
    freq.put("ngv", 53);
    freq.put(" P ", 83);
    freq.put("ngr", 466);
    freq.put("ngs", 158);
    freq.put("tba", 65);
    freq.put("z\u030ci ", 55);
    freq.put("a\u0308vi", 138);
    freq.put("shu", 57);
    freq.put("a\u0308va", 99);
    freq.put("sha", 261);
    freq.put("she", 80);
    freq.put("shi", 370);
    freq.put("m2 ", 198);
    freq.put("sho", 138);
    freq.put("ke ", 2101);
    freq.put("ts\u030ce", 222);
    freq.put("ts\u030ca", 111);
    freq.put("ts\u030ci", 133);
    freq.put("lup", 150);
    freq.put("lur", 311);
    freq.put("lus", 3490);
    freq.put("lut", 683);
    freq.put("luu", 781);
    freq.put("luv", 1330);
    freq.put("lua", 79);
    freq.put("lub", 1064);
    freq.put("lud", 201);
    freq.put("lue", 62);
    freq.put("lug", 367);
    freq.put("\u043b", 1746);
    freq.put("luk", 457);
    freq.put("lul", 347);
    freq.put("lum", 505);
    freq.put("lun", 505);
    freq.put("luo", 49);
    freq.put("ken", 530);
    freq.put("kem", 268);
    freq.put("kel", 1252);
    freq.put("kek", 94);
    freq.put("kej", 56);
    freq.put("kei", 247);
    freq.put("keh", 762);
    freq.put("kee", 6776);
    freq.put("ked", 219);
    freq.put("kea", 512);
    freq.put("ts\u030c ", 386);
    freq.put("kev", 86);
    freq.put("ket", 387);
    freq.put("kes", 5621);
    freq.put("ker", 962);
    freq.put("kep", 122);
    freq.put("uum", 754);
    freq.put("\u0440 ", 253);
    freq.put("lu ", 1464);
    freq.put("ot ", 233);
    freq.put("Lok", 47);
    freq.put("Loh", 45);
    freq.put("Lon", 195);
    freq.put("Loo", 276);
    freq.put("Lom", 53);
    freq.put("Lor", 56);
    freq.put("Los", 88);
    freq.put("Lot", 49);
    freq.put("Lou", 126);
    freq.put("ty", 350);
    freq.put("\u0443\u043b", 50);
    freq.put("yan", 90);
    freq.put("\u0443\u043d", 50);
    freq.put("\u0443\u0431", 58);
    freq.put("\u0434", 957);
    freq.put("oth", 115);
    freq.put("oti", 581);
    freq.put("otj", 93);
    freq.put("otk", 48);
    freq.put("otl", 94);
    freq.put("otm", 209);
    freq.put("oto", 793);
    freq.put("ota", 435);
    freq.put("\u0443\u0441", 74);
    freq.put("\u0443\u0440", 101);
    freq.put("ote", 630);
    freq.put("otr", 134);
    freq.put("ots", 2879);
    freq.put("ott", 288);
    freq.put("otu", 561);
    freq.put("And", 351);
    freq.put("Ang", 173);
    freq.put("Ana", 136);
    freq.put("Ann", 191);
    freq.put("Ani", 70);
    freq.put("Ant", 450);
    freq.put("Ans", 55);
    freq.put("ya ", 162);
    freq.put("Fo\u0308d", 118);
    freq.put("\u0411", 203);
    freq.put("You", 47);
    freq.put("Yor", 178);
    freq.put("otu\u0308", 52);
    freq.put("i", 428108);
    freq.put("ksi", 1286);
    freq.put("\u3042\u3042", 46);
    freq.put("Be", 1094);
    freq.put("Ba", 1524);
    freq.put("Bl", 189);
    freq.put("Bo", 722);
    freq.put("Bi", 534);
    freq.put("Bu", 590);
    freq.put("Br", 896);
    freq.put("ha\u0304", 79);
    freq.put("ksj", 60);
    freq.put("hu\u0304", 50);
    freq.put("B ", 254);
    freq.put(" x ", 107);
    freq.put("ho\u0304", 45);
    freq.put("U ", 154);
    freq.put("pr", 5736);
    freq.put("RO ", 68);
    freq.put("Ut", 61);
    freq.put("Us", 124);
    freq.put("Ur", 136);
    freq.put("Um", 60);
    freq.put("Ul", 110);
    freq.put("Un", 420);
    freq.put("Uk", 201);
    freq.put("Ud", 58);
    freq.put("pt", 1489);
    freq.put("U", 2720);
    freq.put("dub", 375);
    freq.put("ea ", 655);
    freq.put("\u043e\u043b\u044c", 64);
    freq.put("h ", 1684);
    freq.put("ko\u0303v", 81);
    freq.put("ko\u0303r", 1655);
    freq.put("ko\u0303n", 322);
    freq.put("ko\u0303l", 116);
    freq.put("ko\u0303i", 997);
    freq.put("eai", 99);
    freq.put("eah", 87);
    freq.put("eak", 483);
    freq.put("eaj", 63);
    freq.put("eam", 934);
    freq.put("eal", 1914);
    freq.put("eao", 48);
    freq.put("ean", 733);
    freq.put("eaa", 424);
    freq.put("hs", 195);
    freq.put("eab", 210);
    freq.put("eae", 122);
    freq.put("ead", 2747);
    freq.put("eag", 132);
    freq.put("\u0435\u043a", 180);
    freq.put("hj", 2882);
    freq.put("hk", 5994);
    freq.put("hh", 1052);
    freq.put("hi", 9059);
    freq.put("hn", 1001);
    freq.put("ho", 2898);
    freq.put("hl", 335);
    freq.put("pk", 178);
    freq.put("eap", 99);
    freq.put("eas", 399);
    freq.put("ear", 190);
    freq.put("eau", 103);
    freq.put("ph", 615);
    freq.put("eav", 225);
    freq.put("dma", 248);
    freq.put("dus", 9107);
    freq.put("dme", 789);
    freq.put("dmi", 448);
    freq.put("po", 8371);
    freq.put("\u043e\u043b\u0430", 72);
    freq.put("dmu", 204);
    freq.put("\u043e\u043b\u0438", 53);
    freq.put("\u043e\u043b\u043e", 46);
    freq.put("hn ", 212);
    freq.put(" Ut", 61);
    freq.put(" Uu", 347);
    freq.put(" Ur", 135);
    freq.put(" Us", 122);
    freq.put(" Ul", 110);
    freq.put(" Um", 60);
    freq.put(" Un", 417);
    freq.put(" Uk", 200);
    freq.put(" Ud", 58);
    freq.put("hu\u0308", 580);
    freq.put("ho\u0303", 638);
    freq.put("ha\u0308", 827);
    freq.put("hna", 53);
    freq.put("sa\u0308a\u0308", 83);
    freq.put("hni", 355);
    freq.put("\u043e\u0438\u0306 ", 73);
    freq.put("hno", 248);
    freq.put("hnu", 57);
    freq.put("Ehi", 44);
    freq.put("aua", 310);
    freq.put("aub", 254);
    freq.put("aue", 64);
    freq.put("aud", 1021);
    freq.put("aug", 1111);
    freq.put("auf", 46);
    freq.put("auh", 299);
    freq.put("auk", 196);
    freq.put("aum", 65);
    freq.put("aul", 1069);
    freq.put("up ", 125);
    freq.put("aun", 225);
    freq.put("aup", 177);
    freq.put("aus", 715);
    freq.put("aur", 292);
    freq.put("aut", 985);
    freq.put("Joh", 467);
    freq.put("au ", 240);
    freq.put("upl", 50);
    freq.put("o\u0303nu", 108);
    freq.put("upi", 356);
    freq.put("e\u0308", 66);
    freq.put("upe", 239);
    freq.put("sjo\u0303", 49);
    freq.put("o\u0303na", 926);
    freq.put("o\u0303nd", 49);
    freq.put("o\u0303ne", 668);
    freq.put("o\u0303ng", 76);
    freq.put("o\u0303ni", 203);
    freq.put("o\u0303nk", 86);
    freq.put("upr", 65);
    freq.put("sja\u0308", 141);
    freq.put("olk", 349);
    freq.put("me ", 2925);
    freq.put("nen", 1253);
    freq.put("neo", 254);
    freq.put("Pun", 149);
    freq.put("nem", 2691);
    freq.put("Puh", 59);
    freq.put("nek", 392);
    freq.put("nei", 559);
    freq.put("Pue", 49);
    freq.put("ned", 454);
    freq.put("nee", 1283);
    freq.put("neb", 1735);
    freq.put("nea", 209);
    freq.put("nez", 55);
    freq.put("ney", 104);
    freq.put("nev", 1928);
    freq.put("Puu", 79);
    freq.put("net", 1372);
    freq.put("neu", 153);
    freq.put("ner", 1383);
    freq.put("nes", 1547);
    freq.put("Pur", 44);
    freq.put("mee", 3676);
    freq.put("med", 1125);
    freq.put("\u0443", 739);
    freq.put("mea", 100);
    freq.put("mem", 157);
    freq.put("orr", 1904);
    freq.put("men", 2636);
    freq.put("mei", 782);
    freq.put("meh", 405);
    freq.put("mek", 592);
    freq.put("met", 4426);
    freq.put("mev", 67);
    freq.put("mep", 72);
    freq.put("mes", 2849);
    freq.put("mer", 2169);
    freq.put("\u10e0", 63);
    freq.put("a\u0308ps", 237);
    freq.put("a\u0308pp", 49);
    freq.put("upa\u0308", 61);
    freq.put("dru", 114);
    freq.put("ne ", 18973);
    freq.put("sju", 179);
    freq.put("dri", 1541);
    freq.put("drh", 50);
    freq.put("sjo", 145);
    freq.put("dro", 385);
    freq.put("dra", 532);
    freq.put("sja", 511);
    freq.put("dre", 399);
    freq.put("u\u0308gi", 120);
    freq.put("u\u0308ga", 160);
    freq.put("orc", 46);
    freq.put("\u043b\u044c\u0441", 44);
    freq.put("A\u0301", 51);
    freq.put("Ste", 226);
    freq.put("Sta", 395);
    freq.put("\u043b\u044c\u043d", 72);
    freq.put("Sto", 184);
    freq.put("Stu", 106);
    freq.put("Str", 229);
    freq.put("V", 9682);
    freq.put("rio", 550);
    freq.put("Tih", 59);
    freq.put("Tii", 133);
    freq.put("Lie", 81);
    freq.put("Lig", 47);
    freq.put("Lib", 76);
    freq.put("Lil", 58);
    freq.put("Lim", 58);
    freq.put("Lin", 573);
    freq.put("Lih", 74);
    freq.put("Lii", 1363);
    freq.put("Lit", 56);
    freq.put("Liv", 63);
    freq.put("Lip", 63);
    freq.put("Lis", 111);
    freq.put("\u041f\u043e", 48);
    freq.put("Kaa", 255);
    freq.put("Kag", 66);
    freq.put("Kad", 123);
    freq.put("Kak", 46);
    freq.put("\u041f\u0435", 79);
    freq.put("Kah", 71);
    freq.put("Kan", 466);
    freq.put("Al ", 56);
    freq.put("\u041f\u0430", 47);
    freq.put("Kas", 307);
    freq.put("Kar", 687);
    freq.put("Kap", 63);
    freq.put("Kau", 239);
    freq.put("Kat", 178);
    freq.put("ovs", 142);
    freq.put("ovu", 110);
    freq.put("olv", 65);
    freq.put("ova", 496);
    freq.put("ovg", 80);
    freq.put("ove", 767);
    freq.put("ovi", 1506);
    freq.put("ovn", 57);
    freq.put("ovo", 225);
    freq.put("yn", 260);
    freq.put("All", 206);
    freq.put("Ali", 85);
    freq.put("Alf", 50);
    freq.put("Alg", 178);
    freq.put("Ale", 472);
    freq.put("Alb", 201);
    freq.put("Ala", 283);
    freq.put("Alt", 115);
    freq.put("Alu", 59);
    freq.put("Alp", 102);
    freq.put("oni", 6425);
    freq.put("onn", 4600);
    freq.put("du\u0308n", 222);
    freq.put("ono", 803);
    freq.put("onl", 72);
    freq.put("\u03c1", 156);
    freq.put("onf", 139);
    freq.put("isu\u0308", 229);
    freq.put("iso\u0303", 144);
    freq.put("O\u0303", 259);
    freq.put("Wor", 93);
    freq.put("Wol", 71);
    freq.put("Va\u0308r", 64);
    freq.put("SS ", 97);
    freq.put(" zo", 50);
    freq.put(" zu", 50);
    freq.put("is ", 17934);
    freq.put("\u0445\u0430", 91);
    freq.put("fik", 301);
    freq.put("iss", 1297);
    freq.put("isr", 458);
    freq.put("isp", 759);
    freq.put("isv", 570);
    freq.put("isu", 1149);
    freq.put("ist", 16111);
    freq.put("isk", 1562);
    freq.put("isj", 238);
    freq.put("isi", 2505);
    freq.put("ish", 182);
    freq.put("iso", 452);
    freq.put("isn", 380);
    freq.put("ism", 2164);
    freq.put("isl", 320);
    freq.put("isc", 260);
    freq.put("isa", 2662);
    freq.put("ise", 17961);
    freq.put("a\u0308bi", 596);
    freq.put("gy ", 51);
    freq.put("no\u0303u", 458);
    freq.put("no\u0303r", 64);
    freq.put("no\u0303l", 71);
    freq.put("no\u0303i", 66);
    freq.put("o\u0303ge", 171);
    freq.put("Col", 177);
    freq.put("\u0430\u043d ", 122);
    freq.put("La\u0308h", 64);
    freq.put("La\u0308t", 200);
    freq.put("ty ", 254);
    freq.put("\u0441 ", 91);
    freq.put("h\u0327", 72);
    freq.put("do ", 334);
    freq.put("a\u0304n", 168);
    freq.put("a\u0304r", 63);
    freq.put("o\u0303i", 12796);
    freq.put("oil", 59);
    freq.put("a\u0304 ", 58);
    freq.put("don", 412);
    freq.put("a\u0308me", 148);
    freq.put("dol", 150);
    freq.put("La\u0308a\u0308", 780);
    freq.put("m", 147242);
    freq.put("a\u0308mm", 58);
    freq.put("dor", 276);
    freq.put("dos", 91);
    freq.put("dov", 88);
    freq.put("dow", 80);
    freq.put("dot", 70);
    freq.put(" We", 424);
    freq.put(" Wa", 532);
    freq.put(" Wo", 210);
    freq.put(" Wh", 45);
    freq.put(" Wi", 583);
    freq.put("mo\u0303t", 400);
    freq.put("kul", 2990);
    freq.put("ba ", 651);
    freq.put("\u03c5", 62);
    freq.put(" W ", 53);
    freq.put("oma\u0308", 44);
    freq.put("omo\u0308", 62);
    freq.put("bav", 70);
    freq.put("bat", 316);
    freq.put("bar", 1055);
    freq.put("bas", 493);
    freq.put("bad", 310);
    freq.put("bac", 66);
    freq.put("baa", 286);
    freq.put("ban", 365);
    freq.put("bal", 373);
    freq.put("bam", 130);
    freq.put("baj", 47);
    freq.put("bak", 284);
    freq.put("bah", 73);
    freq.put("bai", 111);
    freq.put("om ", 370);
    freq.put("iz\u030c", 51);
    freq.put("is\u030c", 133);
    freq.put("Rum", 92);
    freq.put("un ", 198);
    freq.put("Rus", 63);
    freq.put("omb", 266);
    freq.put("C", 4433);
    freq.put("ome", 2088);
    freq.put("vo\u0308o\u0308", 291);
    freq.put("omi", 1618);
    freq.put("omo", 342);
    freq.put("omn", 106);
    freq.put("omm", 613);
    freq.put("oms", 246);
    freq.put("omp", 670);
    freq.put("omu", 606);
    freq.put("omt", 108);
    freq.put("uns", 729);
    freq.put("unt", 871);
    freq.put("unu", 969);
    freq.put("mo\u0308o\u0308", 180);
    freq.put("go\u0308", 54);
    freq.put("o\u0303lv", 413);
    freq.put("o\u0303lt", 294);
    freq.put("o\u0303lu", 48);
    freq.put("o\u0303lk", 134);
    freq.put("o\u0303li", 251);
    freq.put("und", 1856);
    freq.put("une", 1105);
    freq.put("o\u0303ll", 298);
    freq.put("o\u0303lm", 435);
    freq.put("uni", 2914);
    freq.put("o\u0303la", 152);
    freq.put("o\u0303lg", 110);
    freq.put("unn", 618);
    freq.put("o\u0303le", 240);
    freq.put("iu\u0308", 173);
    freq.put("o\u0301n ", 53);
    freq.put("io\u0303", 260);
    freq.put("i\u0301a ", 44);
    freq.put("C ", 532);
    freq.put("a\u0308r ", 134);
    freq.put("o\u0301ni", 51);
    freq.put("\u043b\u044c ", 49);
    freq.put("\u0456", 130);
    freq.put("Ts\u030cu", 55);
    freq.put("Ci", 177);
    freq.put("Ch", 852);
    freq.put("Co", 1022);
    freq.put("Cl", 241);
    freq.put("slu", 141);
    freq.put("a\u0308rs", 325);
    freq.put("a\u0308rr", 78);
    freq.put("a\u0308ru", 76);
    freq.put("a\u0308rt", 890);
    freq.put("Ce", 161);
    freq.put("a\u0308rv", 1633);
    freq.put("a\u0308ri", 1473);
    freq.put("Ts\u030ce", 232);
    freq.put("a\u0308rk", 656);
    freq.put("a\u0308rj", 460);
    freq.put("a\u0308rm", 139);
    freq.put("sli", 1453);
    freq.put("a\u0308rn", 371);
    freq.put("a\u0308ra", 1650);
    freq.put("Cr", 170);
    freq.put("a\u0308re", 1128);
    freq.put("Ts\u030ci", 63);
    freq.put("a\u0308rg", 1735);
    freq.put("iy", 72);
    freq.put("ix", 158);
    freq.put("iz", 330);
    freq.put("Nag", 44);
    freq.put("Nad", 109);
    freq.put("iq", 93);
    freq.put("ip", 3170);
    freq.put("is", 67525);
    freq.put("ir", 11061);
    freq.put("Nan", 47);
    freq.put("it", 26582);
    freq.put("iw", 71);
    freq.put("iv", 6458);
    freq.put("Nar", 263);
    freq.put("ih", 2638);
    freq.put("Nap", 53);
    freq.put("ij", 1535);
    freq.put("im", 19741);
    freq.put("il", 29934);
    freq.put("io", 9587);
    freq.put("in", 53773);
    freq.put("ia", 15748);
    freq.put("ic", 2524);
    freq.put("ki ", 1992);
    freq.put("ie", 3981);
    freq.put("id", 25348);
    freq.put("ig", 11090);
    freq.put("if", 1034);
    freq.put("V ", 865);
    freq.put("o\u0308o\u0308 ", 232);
    freq.put("kis", 700);
    freq.put("kir", 3701);
    freq.put("Sve", 99);
    freq.put("kiv", 697);
    freq.put("kiu", 59);
    freq.put("kit", 731);
    freq.put("\u0438\u0438\u0306 ", 339);
    freq.put("kij", 101);
    freq.put("kii", 670);
    freq.put("kih", 644);
    freq.put("\u0412\u043b\u0430", 51);
    freq.put("kin", 1384);
    freq.put("kim", 281);
    freq.put("kil", 445);
    freq.put("kib", 147);
    freq.put("kia", 138);
    freq.put("kie", 46);
    freq.put("kid", 1460);
    freq.put("Va", 3312);
    freq.put("Ve", 2352);
    freq.put("Vi", 1892);
    freq.put("Vl", 115);
    freq.put("Vo", 452);
    freq.put("Vu", 47);
    freq.put("nk ", 386);
    freq.put("uu\u0308h", 53);
    freq.put("op ", 270);
    freq.put("yer", 56);
    freq.put("opt", 153);
    freq.put("opu", 229);
    freq.put("opp", 88);
    freq.put("opr", 90);
    freq.put("ops", 80);
    freq.put("ope", 659);
    freq.put("opa", 1002);
    freq.put("opl", 127);
    freq.put("opo", 355);
    freq.put("oph", 152);
    freq.put("opi", 377);
    freq.put("opk", 103);
    freq.put("Art", 168);
    freq.put("Aru", 68);
    freq.put("Arv", 91);
    freq.put("Ara", 180);
    freq.put("Arc", 52);
    freq.put("Are", 119);
    freq.put("Arg", 115);
    freq.put("Arh", 59);
    freq.put("Ari", 84);
    freq.put("Ark", 65);
    freq.put("Arm", 142);
    freq.put("Arn", 51);
    freq.put("pa\u0308r", 1925);
    freq.put("\u041b\u0435", 48);
    freq.put("\u0445 ", 65);
    freq.put("o\u0308o\u0308t", 635);
    freq.put("pa\u0308i", 92);
    freq.put("pa\u0308e", 892);
    freq.put("\u0440\u0430 ", 49);
    freq.put("\u0438\u0435 ", 51);
    freq.put("eno\u0303", 60);
    freq.put("A\u030a", 72);
    freq.put("Z", 653);
    freq.put("iqu", 72);
    freq.put("u\u0308u\u0308r", 188);
    freq.put("u\u0308u\u0308p", 380);
    freq.put("u\u0308u\u0308t", 421);
    freq.put("\u0430\u043d\u0434", 117);
    freq.put("u\u0308u\u0308h", 62);
    freq.put("u\u0308u\u0308n", 56);
    freq.put("u\u0308u\u0308m", 176);
    freq.put("u\u0308u\u0308l", 234);
    freq.put("u\u0308u\u0308b", 92);
    freq.put("\u0430\u043d\u043e", 90);
    freq.put("\u0430\u043d\u0438", 46);
    freq.put("u\u0308u\u0308d", 395);
    freq.put("Kuu", 241);
    freq.put("\u0441\u0430", 149);
    freq.put("vo\u0303o\u0303", 64);
    freq.put("\u0441\u0435", 96);
    freq.put("nki", 267);
    freq.put("\u0441\u0438", 145);
    freq.put("\u0441\u043b", 56);
    freq.put("\u0441\u043a", 479);
    freq.put("\u0441\u043e", 89);
    freq.put("\u0441\u0441", 83);
    freq.put("\u0441\u0442", 346);
    freq.put("Win", 131);
    freq.put("Wil", 257);
    freq.put("Gro\u0308", 69);
    freq.put("di ", 4266);
    freq.put("\u0634", 48);
    freq.put("tnu", 77);
    freq.put("eru", 688);
    freq.put("dil", 754);
    freq.put("dim", 305);
    freq.put("din", 5058);
    freq.put("dio", 737);
    freq.put("dii", 121);
    freq.put("a\u0308ol", 71);
    freq.put("dik", 678);
    freq.put("did", 1413);
    freq.put("die", 158);
    freq.put("dif", 137);
    freq.put("dig", 325);
    freq.put("dia", 1187);
    freq.put("dic", 84);
    freq.put("\u0446\u0438", 80);
    freq.put("dit", 1143);
    freq.put("diu", 154);
    freq.put("div", 260);
    freq.put("dip", 162);
    freq.put("dir", 107);
    freq.put("dis", 3167);
    freq.put("Gru", 170);
    freq.put(" Yo", 250);
    freq.put(" Ya", 113);
    freq.put("ery", 69);
    freq.put("Gre", 178);
    freq.put("Gra", 216);
    freq.put("\u0433\u0443", 45);
    freq.put("Gro", 104);
    freq.put(" Yu", 48);
    freq.put("Gri", 80);
    freq.put("tne", 300);
    freq.put("bo ", 72);
    freq.put("\u0410\u043b\u0435", 136);
    freq.put("tno", 51);
    freq.put("\u0433\u0438", 57);
    freq.put("\u0433\u043e", 156);
    freq.put("tni", 437);
    freq.put("bor", 247);
    freq.put("\u0433\u0430", 89);
    freq.put("bot", 147);
    freq.put("bou", 65);
    freq.put("\u0433\u0435", 109);
    freq.put("bok", 45);
    freq.put("bol", 236);
    freq.put("\u043e\u043d ", 72);
    freq.put("boo", 67);
    freq.put("bod", 50);
    freq.put("oo ", 462);
    freq.put("aye", 71);
    freq.put("aya", 58);
    freq.put("ul ", 2180);
    freq.put("ood", 3903);
    freq.put("oog", 2684);
    freq.put("oof", 591);
    freq.put("Ben", 187);
    freq.put("Bel", 194);
    freq.put("oob", 808);
    freq.put("oom", 3730);
    freq.put("ool", 6457);
    freq.put("Bea", 78);
    freq.put("ook", 1060);
    freq.put("ooj", 448);
    freq.put("oot", 2071);
    freq.put("oov", 321);
    freq.put("oop", 1217);
    freq.put("oos", 2409);
    freq.put("oor", 2416);
    freq.put("Ber", 414);
    freq.put("\u043e\u0433\u043e", 52);
    freq.put("o\u0303ju", 446);
    freq.put("ulp", 70);
    freq.put("ay ", 224);
    freq.put("ult", 2105);
    freq.put("ulu", 2649);
    freq.put("fli", 57);
    freq.put("ulk", 645);
    freq.put("uli", 2783);
    freq.put("uln", 45);
    freq.put("ulo", 139);
    freq.put("ull", 465);
    freq.put("ulm", 184);
    freq.put("fla", 75);
    freq.put("ula", 1652);
    freq.put("o\u0303ja", 1187);
    freq.put("uld", 337);
    freq.put("ule", 2072);
    freq.put("ma ", 4860);
    freq.put("lo\u0303i", 316);
    freq.put("nyi", 68);
    freq.put("nya", 69);
    freq.put("map", 146);
    freq.put("mas", 3246);
    freq.put("sne", 888);
    freq.put("mat", 3086);
    freq.put("sna", 125);
    freq.put("sno", 114);
    freq.put("sni", 235);
    freq.put("maa", 11983);
    freq.put("mac", 100);
    freq.put("snu", 95);
    freq.put("mae", 114);
    freq.put("mad", 1582);
    freq.put("mag", 417);
    freq.put("maf", 51);
    freq.put("mai", 1139);
    freq.put("mah", 237);
    freq.put("mak", 919);
    freq.put("maj", 980);
    freq.put("mam", 324);
    freq.put("mal", 2280);
    freq.put("man", 2399);
    freq.put("pa\u0308a\u0308", 190);
    freq.put("Ede", 52);
    freq.put("q", 542);
    freq.put("Edw", 63);
    freq.put("Edu", 80);
    freq.put("go\u0303z", 53);
    freq.put("ny ", 159);
    freq.put("lse", 1684);
    freq.put("lsa", 658);
    freq.put("lso", 81);
    freq.put("lsk", 106);
    freq.put("lsi", 290);
    freq.put("ja\u0308", 4035);
    freq.put("lst", 139);
    freq.put("lsu", 210);
    freq.put("lss", 61);
    freq.put("Ju\u0308r", 85);
    freq.put("kk ", 305);
    freq.put(" aa", 4258);
    freq.put(" ab", 842);
    freq.put(" ac", 46);
    freq.put(" ad", 192);
    freq.put(" ae", 363);
    freq.put(" af", 69);
    freq.put(" ag", 306);
    freq.put(" ah", 192);
    freq.put(" ai", 1079);
    freq.put(" aj", 1910);
    freq.put(" ak", 483);
    freq.put(" al", 5568);
    freq.put(" am", 855);
    freq.put(" an", 2331);
    freq.put(" ap", 575);
    freq.put(" ar", 3514);
    freq.put(" as", 4137);
    freq.put(" at", 197);
    freq.put(" au", 1797);
    freq.put(" av", 698);
    freq.put("To\u0303", 185);
    freq.put("ls ", 120);
    freq.put("kku", 1792);
    freq.put("Sha", 138);
    freq.put("kko", 768);
    freq.put("kki", 577);
    freq.put("She", 124);
    freq.put("kke", 775);
    freq.put("Shi", 143);
    freq.put("kka", 353);
    freq.put(" a ", 162);
    freq.put("\u0442 ", 156);
    freq.put("Lut", 62);
    freq.put("Luu", 51);
    freq.put("Luc", 57);
    freq.put("Lud", 75);
    freq.put("Lui", 44);
    freq.put("Luk", 48);
    freq.put("or ", 1504);
    freq.put("Ken", 126);

    init2();
  }
  private static void init2() {
    
    freq.put("Kem", 44);
    freq.put("Kel", 51);
    freq.put("Kei", 251);
    freq.put("Keh", 55);
    freq.put("Kee", 118);
    freq.put("Dz\u030c", 49);
    freq.put("o\u0308d ", 110);
    freq.put("\u043b\u0430\u0432", 45);
    freq.put("\u043b\u0430\u0434", 53);
    freq.put("Ket", 49);
    freq.put("Kes", 554);
    freq.put("Ker", 134);
    freq.put("G", 4270);
    freq.put("ory", 79);
    freq.put("orv", 260);
    freq.put("ort", 1076);
    freq.put("oru", 308);
    freq.put("\u0438\u043d\u0430", 63);
    freq.put("ors", 316);
    freq.put("orp", 251);
    freq.put("orn", 581);
    freq.put("oro", 441);
    freq.put("orl", 106);
    freq.put("orm", 1403);
    freq.put("orj", 99);
    freq.put("ork", 293);
    freq.put("ori", 3030);
    freq.put("orf", 173);
    freq.put("org", 2150);
    freq.put("ord", 2640);
    freq.put("ore", 923);
    freq.put("orb", 147);
    freq.put("U\u0308", 1682);
    freq.put("ora", 643);
    freq.put("App", 49);
    freq.put("o\u0308da", 96);
    freq.put("o\u0308de", 377);
    freq.put("Apo", 82);
    freq.put("o\u0308di", 95);
    freq.put("lay", 76);
    freq.put("ua ", 229);
    freq.put("Ote", 47);
    freq.put("Du\u0308", 69);
    freq.put("Ott", 71);
    freq.put("zst", 65);
    freq.put(" S\u030ca", 47);
    freq.put("owa", 44);
    freq.put(" S\u030co", 91);
    freq.put("\u043e\u0441\u0442", 84);
    freq.put(" S\u030cv", 165);
    freq.put("Do", 581);
    freq.put("Di", 576);
    freq.put("De", 809);
    freq.put("Da", 636);
    freq.put("2", 200);
    freq.put("Du", 151);
    freq.put("Dr", 153);
    freq.put("iwa", 47);
    freq.put("u\u0308li", 561);
    freq.put("D ", 280);
    freq.put("ge ", 1988);
    freq.put("We", 428);
    freq.put("Wa", 532);
    freq.put("Wo", 216);
    freq.put("Wi", 599);
    freq.put("Wh", 48);
    freq.put("\u0430", 3415);
    freq.put("ges", 288);
    freq.put("ger", 573);
    freq.put("S\u030ca", 47);
    freq.put("gev", 1367);
    freq.put("geu", 170);
    freq.put("get", 321);
    freq.put("jo\u0303", 2814);
    freq.put("jo\u0308", 51);
    freq.put("S\u030co", 91);
    freq.put("geb", 241);
    freq.put("uta", 4946);
    freq.put("S\u030cv", 165);
    freq.put("gee", 427);
    freq.put("ged", 631);
    freq.put("gek", 61);
    freq.put("gej", 286);
    freq.put("gei", 271);
    freq.put("geo", 730);
    freq.put("gen", 1194);
    freq.put("gem", 670);
    freq.put("gel", 1762);
    freq.put("W ", 104);
    freq.put("o\u0301", 356);
    freq.put("utk", 47);
    freq.put("uth", 113);
    freq.put("s\u030ca", 283);
    freq.put("s\u030ce", 571);
    freq.put("s\u030ci", 439);
    freq.put("s\u030ck", 120);
    freq.put("s\u030co", 109);
    freq.put("uto", 959);
    freq.put("s\u030cu", 129);
    freq.put("s\u030ct", 112);
    freq.put("tu ", 1887);
    freq.put("utm", 97);
    freq.put("j ", 178);
    freq.put("uts", 1366);
    freq.put("tup", 139);
    freq.put("s\u030c ", 464);
    freq.put("utt", 121);
    freq.put("\u0647", 60);
    freq.put("jt", 102);
    freq.put("ju", 8195);
    freq.put("tur", 775);
    freq.put("tus", 7900);
    freq.put("tut", 545);
    freq.put("tuu", 2287);
    freq.put("tuv", 618);
    freq.put("ho\u0303i", 206);
    freq.put("tuh", 72);
    freq.put("jm", 158);
    freq.put("jn", 184);
    freq.put("jo", 2230);
    freq.put("tul", 1640);
    freq.put("ji", 256);
    freq.put("tun", 1878);
    freq.put("je", 2855);
    freq.put("tub", 376);
    freq.put("tud", 7345);
    freq.put("ja", 41991);
    freq.put("tug", 512);
    freq.put("a\u0308il", 189);
    freq.put("a\u0308in", 438);
    freq.put("ra\u0308n", 173);
    freq.put("a\u0308ij", 45);
    freq.put("a\u0308ik", 1090);
    freq.put("a\u0308id", 319);
    freq.put("a\u0308ie", 224);
    freq.put("a\u0308ig", 275);
    freq.put("tuj", 83);
    freq.put("a\u0308ib", 55);
    freq.put("tuk", 346);
    freq.put("dka", 57);
    freq.put("a\u0308it", 1511);
    freq.put("dko", 283);
    freq.put("a\u0308iv", 81);
    freq.put("\u0433 ", 58);
    freq.put("a\u0308ir", 146);
    freq.put("dki", 67);
    freq.put("iml", 60);
    freq.put("tua", 183);
    freq.put("\u041c\u0430", 85);
    freq.put("\u041c\u043e", 47);
    freq.put("\u041c\u0438", 98);
    freq.put("uja\u0308", 52);
    freq.put("oi ", 80);
    freq.put("pap", 44);
    freq.put("par", 1885);
    freq.put("pas", 347);
    freq.put("pat", 370);
    freq.put("pau", 44);
    freq.put("paa", 872);
    freq.put("pab", 98);
    freq.put("pad", 102);
    freq.put("pae", 47);
    freq.put("pag", 125);
    freq.put("pai", 924);
    freq.put("paj", 61);
    freq.put("pak", 331);
    freq.put("pal", 1654);
    freq.put("pan", 1223);
    freq.put("oin", 102);
    freq.put("oim", 998);
    freq.put("\u0440\u043e\u0432", 215);
    freq.put("oik", 52);
    freq.put("jo\u0303g", 658);
    freq.put("nac", 71);
    freq.put("jo\u0303k", 47);
    freq.put("oid", 535);
    freq.put("o\u0303hj", 2576);
    freq.put("o\u0303hk", 139);
    freq.put("oia", 64);
    freq.put("o\u0303hi", 1112);
    freq.put("o\u0303hu", 552);
    freq.put("jo\u0303u", 952);
    freq.put("oiu", 71);
    freq.put("oit", 264);
    freq.put("ois", 197);
    freq.put("\u0418\u0432\u0430", 71);
    freq.put("uju", 1494);
    freq.put("pa ", 804);
    freq.put("a\u0308is", 253);
    freq.put("uja", 426);
    freq.put("\u0442\u0440", 186);
    freq.put("\u0442\u044c", 45);
    freq.put("mo ", 151);
    freq.put("\u0438\u043b\u044c", 70);
    freq.put("\u03c9", 53);
    freq.put("mor", 367);
    freq.put("mov", 44);
    freq.put("mot", 173);
    freq.put("mok", 297);
    freq.put("moo", 1204);
    freq.put("mon", 658);
    freq.put("mom", 61);
    freq.put("mol", 409);
    freq.put("mob", 84);
    freq.put("mog", 59);
    freq.put("moe", 58);
    freq.put("mod", 191);
    freq.put("\u0442\u0435", 148);
    freq.put("\u0442\u0430", 205);
    freq.put("km2", 193);
    freq.put("\u0442\u0432", 71);
    freq.put("\u0442\u043e", 214);
    freq.put("\u0442\u0438", 150);
    freq.put("Nen", 81);
    freq.put("Nel", 76);
    freq.put("Nei", 118);
    freq.put("Nee", 123);
    freq.put("ptu", 183);
    freq.put("ro\u0308o\u0308", 217);
    freq.put("Nev", 47);
    freq.put("New", 291);
    freq.put("Net", 49);
    freq.put("Neu", 75);
    freq.put("Mee", 102);
    freq.put("Med", 80);
    freq.put(" ch", 69);
    freq.put("ae ", 265);
    freq.put("kma", 69);
    freq.put(" cm", 54);
    freq.put("Mel", 110);
    freq.put(" ca", 117);
    freq.put("Mei", 81);
    freq.put("Meh", 138);
    freq.put("kmi", 180);
    freq.put("Met", 201);
    freq.put("Mes", 92);
    freq.put("Mer", 322);
    freq.put("\u0447", 785);
    freq.put("o\u0303o\u0303t", 409);
    freq.put("o\u0303o\u0303s", 83);
    freq.put("o\u0303o\u0303r", 156);
    freq.put("Dra", 54);
    freq.put("o\u0303o\u0303d", 171);
    freq.put("Dre", 44);
    freq.put("km ", 1345);
    freq.put("z\u030caa", 84);
    freq.put("z\u030can", 88);
    freq.put("so\u0303d", 233);
    freq.put("u\u0308m ", 72);
    freq.put("so\u0303n", 939);
    freq.put("so\u0303l", 377);
    freq.put("so\u0303j", 1120);
    freq.put("so\u0303i", 351);
    freq.put("so\u0303p", 113);
    freq.put("a\u0308tk", 94);
    freq.put("Ac", 135);
    freq.put("Ae", 128);
    freq.put("u\u0308mi", 74);
    freq.put("u\u0308mm", 93);
    freq.put("u\u0308mn", 303);
    freq.put("u\u0308mb", 638);
    freq.put("Af", 163);
    freq.put("u\u0308me", 56);
    freq.put("u\u0308mf", 54);
    freq.put("dve", 99);
    freq.put("u\u0308mp", 310);
    freq.put("Ava", 88);
    freq.put("Aj", 171);
    freq.put("Am", 1404);
    freq.put("sva", 1352);
    freq.put("\u041d", 192);
    freq.put("U\u0308 ", 171);
    freq.put("a\u0308ts", 56);
    freq.put("u\u0301", 88);
    freq.put("u", 213745);
    freq.put("U\u0308l", 582);
    freq.put("U\u0308h", 852);
    freq.put("Vah", 167);
    freq.put("Vai", 341);
    freq.put("Van", 479);
    freq.put("Val", 835);
    freq.put("Vab", 795);
    freq.put("iu ", 159);
    freq.put("Vaa", 45);
    freq.put("Var", 232);
    freq.put("Vas", 243);
    freq.put("ws ", 61);
    freq.put("ede", 2096);
    freq.put("\u0438", 3293);
    freq.put("ta\u0308i", 727);
    freq.put("ta\u0308h", 1822);
    freq.put("ium", 1351);
    freq.put("iul", 72);
    freq.put("iud", 60);
    freq.put("TA ", 65);
    freq.put("got", 49);
    freq.put("iup", 58);
    freq.put("ius", 891);
    freq.put("akr", 533);
    freq.put("iut", 86);
    freq.put("a\u0304n ", 65);
    freq.put("as\u030ci", 75);
    freq.put("SI ", 60);
    freq.put("a\u0308hk", 56);
    freq.put("Gio", 51);
    freq.put("aba", 1901);
    freq.put("Gil", 46);
    freq.put("\u0435\u0432 ", 82);
    freq.put("abe", 658);
    freq.put("abi", 1296);
    freq.put("abl", 140);
    freq.put("abo", 165);
    freq.put("abr", 186);
    freq.put("abs", 170);
    freq.put("abu", 92);
    freq.put("mum", 89);
    freq.put("K", 13384);
    freq.put("hu\u0308m", 55);
    freq.put("akv", 79);
    freq.put("gga", 46);
    freq.put("ab ", 4871);
    freq.put("a\u0300", 86);
    freq.put("ta\u0308r", 60);
    freq.put("ntl", 53);
    freq.put("hu\u0308d", 167);
    freq.put("Mo\u0303n", 60);
    freq.put("Mo\u0303i", 70);
    freq.put("eys", 46);
    freq.put("de ", 10486);
    freq.put("ey ", 327);
    freq.put("dep", 286);
    freq.put("der", 1254);
    freq.put("des", 3846);
    freq.put("det", 1487);
    freq.put("dev", 307);
    freq.put("dei", 268);
    freq.put("dek", 762);
    freq.put("del", 2624);
    freq.put("dem", 499);
    freq.put("den", 1386);
    freq.put("deo", 437);
    freq.put("dea", 150);
    freq.put("deb", 74);
    freq.put("ded", 103);
    freq.put("dee", 433);
    freq.put("def", 181);
    freq.put("deg", 743);
    freq.put("go ", 269);
    freq.put("Don", 122);
    freq.put("Doo", 55);
    freq.put("Dom", 77);
    freq.put("Doy", 59);
    freq.put("Dor", 65);
    freq.put("cs ", 57);
    freq.put("ry ", 413);
    freq.put("ok ", 100);
    freq.put("Bat", 57);
    freq.put("Bau", 47);
    freq.put("Bar", 269);
    freq.put("Bas", 115);
    freq.put("uha", 362);
    freq.put("uho", 49);
    freq.put("uhk", 168);
    freq.put("uhi", 560);
    freq.put("oka", 297);
    freq.put("Bad", 75);
    freq.put("uhu", 769);
    freq.put("Bab", 69);
    freq.put("Ban", 110);
    freq.put("Bal", 343);
    freq.put("Bak", 55);
    freq.put("oko", 247);
    freq.put("Bai", 96);
    freq.put("o\u0303he", 49);
    freq.put("mm ", 329);
    freq.put("Oma", 92);
    freq.put("jo\u0303e", 1151);
    freq.put("E ", 421);
    freq.put("mmy", 82);
    freq.put("sbu", 115);
    freq.put("mmu", 480);
    freq.put("\u0430\u0442\u043e", 47);
    freq.put("\u044f", 590);
    freq.put("mmo", 72);
    freq.put("mmi", 519);
    freq.put("sbe", 92);
    freq.put("mme", 654);
    freq.put("Uni", 210);
    freq.put("mma", 633);
    freq.put("sbo", 51);
    freq.put("Em", 268);
    freq.put("El", 689);
    freq.put("ks\u030c", 54);
    freq.put("En", 458);
    freq.put("Ei", 131);
    freq.put("Eh", 79);
    freq.put("Ek", 108);
    freq.put("Ee", 3423);
    freq.put("Ed", 303);
    freq.put("Eg", 183);
    freq.put("Ea", 53);
    freq.put("Ec", 84);
    freq.put("Ex", 60);
    freq.put("Eu", 1055);
    freq.put("Et", 156);
    freq.put("Ev", 105);
    freq.put("Ep", 67);
    freq.put("Es", 507);
    freq.put("Er", 534);
    freq.put(" eK", 291);
    freq.put("go\u0303", 66);
    freq.put("zo", 270);
    freq.put(" el", 2672);
    freq.put("koh", 2395);
    freq.put("kok", 400);
    freq.put("koj", 93);
    freq.put("kom", 1331);
    freq.put("kol", 1558);
    freq.put("koo", 4137);
    freq.put("kon", 8471);
    freq.put("koa", 59);
    freq.put(" ee", 3011);
    freq.put("X ", 185);
    freq.put("kob", 69);
    freq.put("koe", 132);
    freq.put("kod", 636);
    freq.put("kog", 2107);
    freq.put("oir", 72);
    freq.put(" et", 1438);
    freq.put("kop", 353);
    freq.put("kos", 501);
    freq.put("kor", 2423);
    freq.put(" ep", 75);
    freq.put("kot", 103);
    freq.put(" er", 2077);
    freq.put(" es", 2246);
    freq.put("Slo", 106);
    freq.put("\u0431\u0430", 89);
    freq.put("b", 40246);
    freq.put("\u0431\u0435", 93);
    freq.put("ka\u0308", 1444);
    freq.put("ko ", 325);
    freq.put(" e ", 147);
    freq.put("\u0431\u043e", 55);
    freq.put("ko\u0308", 136);
    freq.put("ko\u0303", 3255);
    freq.put("ku\u0308", 2678);
    freq.put("hk ", 5071);
    freq.put("k ", 16382);
    freq.put("\u0425", 61);
    freq.put("Kir", 431);
    freq.put("Kiv", 96);
    freq.put("Kit", 75);
    freq.put("Kii", 162);
    freq.put("Kih", 48);
    freq.put("Kin", 160);
    freq.put("Kil", 83);
    freq.put("\u0434 ", 86);
    freq.put("vne", 367);
    freq.put("Ate", 50);
    freq.put("vna", 66);
    freq.put("Atl", 232);
    freq.put("kb", 60);
    freq.put("ka", 27697);
    freq.put("kf", 60);
    freq.put("ke", 20124);
    freq.put("kd", 44);
    freq.put("kk", 4692);
    freq.put("Va\u0308", 634);
    freq.put("ki", 13463);
    freq.put("kh", 323);
    freq.put("ko", 25420);
    freq.put("kn", 633);
    freq.put("km", 2283);
    freq.put("kl", 3700);
    freq.put("ks", 20790);
    freq.put("kr", 3838);
    freq.put("kp", 298);
    freq.put("kv", 1230);
    freq.put("ku", 25416);
    freq.put("kt", 6626);
    freq.put("ky", 200);
    freq.put("\u1100\u1161\u1100\u1161\u1100\u1161", 51);
    freq.put("\u041d\u0438", 84);
    freq.put("Ope", 62);
    freq.put("po\u0303l", 539);
    freq.put("po\u0303h", 2641);
    freq.put("po\u0303i", 53);
    freq.put("iko\u0303", 47);
    freq.put("iku\u0308", 95);
    freq.put("po\u0303r", 58);
    freq.put(" Be", 1090);
    freq.put(" Ba", 1515);
    freq.put(" Bl", 186);
    freq.put(" Bo", 717);
    freq.put(" Bi", 531);
    freq.put(" Bu", 586);
    freq.put("ik ", 7328);
    freq.put(" Br", 891);
    freq.put("mo\u0303i", 1422);
    freq.put("\u0430\u0432", 150);
    freq.put("\u0430\u0433", 45);
    freq.put("\u0430\u0431", 45);
    freq.put("\u0430\u0437", 52);
    freq.put("\u0430\u0434", 144);
    freq.put("\u0430\u0435", 61);
    freq.put("\u0430\u043a", 68);
    freq.put("\u0430\u043b", 255);
    freq.put("\u0430\u0438\u0306", 127);
    freq.put("\u0430\u043c", 81);
    freq.put("\u0430\u043d", 559);
    freq.put("kto", 1139);
    freq.put("pn", 209);
    freq.put("\u03ba", 95);
    freq.put("\u0435\u0432\u0438", 205);
    freq.put("iks", 1858);
    freq.put("ikr", 276);
    freq.put(" B ", 117);
    freq.put("iku", 8444);
    freq.put("ikt", 211);
    freq.put("\u044b", 415);
    freq.put("\u0430\u0442", 153);
    freq.put("ika", 6374);
    freq.put("\u0430\u0441", 154);
    freq.put("ike", 2715);
    freq.put("kte", 370);
    freq.put("ikk", 1983);
    freq.put("\u10d8", 145);
    freq.put("iki", 2101);
    freq.put("ikh", 52);
    freq.put("iko", 1851);
    freq.put("ikn", 407);
    freq.put("ikm", 345);
    freq.put("ikl", 1543);
    freq.put("lbr", 50);
    freq.put("lbu", 264);
    freq.put("ga ", 9681);
    freq.put("ran", 3582);
    freq.put("gaz", 58);
    freq.put("gav", 357);
    freq.put("gat", 540);
    freq.put("gas", 1340);
    freq.put("gar", 467);
    freq.put("gap", 72);
    freq.put("gan", 2019);
    freq.put("gam", 272);
    freq.put("gal", 712);
    freq.put("gak", 106);
    freq.put("gaj", 153);
    freq.put("gai", 51);
    freq.put("gad", 306);
    freq.put("gab", 187);
    freq.put("gaa", 657);
    freq.put("lba", 164);
    freq.put("fur", 44);
    freq.put("fun", 331);
    freq.put("lbe", 196);
    freq.put("sy ", 64);
    freq.put("Ira", 139);
    freq.put("\u0421", 395);
    freq.put("mos", 365);
    freq.put("a\u0308e ", 449);
    freq.put("dge", 90);
    freq.put("cea", 61);
    freq.put("dgl", 50);
    freq.put("ew ", 294);
    freq.put("a\u0308et", 56);
    freq.put("\u0424", 101);
    freq.put("a\u0308ev", 922);
    freq.put("a\u0308el", 380);
    freq.put("y", 5816);
    freq.put("a\u0308ea", 55);
    freq.put("a\u0308ed", 62);
    freq.put("lda", 2949);
    freq.put("ldg", 52);
    freq.put("lde", 484);
    freq.put("ldk", 243);
    freq.put("ldj", 62);
    freq.put("ldi", 712);
    freq.put("ldo", 95);
    freq.put("ldn", 65);
    freq.put("bi ", 1023);
    freq.put("lds", 102);
    freq.put("ldr", 58);
    freq.put("ldu", 1916);
    freq.put("ldt", 53);
    freq.put("rgr", 60);
    freq.put("rgs", 57);
    freq.put("cus", 131);
    freq.put("rgu", 1208);
    freq.put("rga", 2008);
    freq.put("rge", 1513);
    freq.put("rgh", 68);
    freq.put("rgi", 2791);
    freq.put("cul", 68);
    freq.put("rgl", 133);
    freq.put("rgm", 113);
    freq.put("rgn", 141);
    freq.put("rgo", 122);
    freq.put("bin", 301);
    freq.put("bio", 537);
    freq.put("bil", 578);
    freq.put("bim", 157);
    freq.put("bij", 70);
    freq.put("bik", 204);
    freq.put("bii", 222);
    freq.put("Die", 54);
    freq.put("bid", 126);
    freq.put("bie", 117);
    freq.put("bib", 89);
    freq.put("Dia", 62);
    freq.put("bia", 533);
    freq.put("biv", 187);
    freq.put("Div", 45);
    freq.put("bir", 67);
    freq.put("bis", 218);
    freq.put("bip", 80);
    freq.put("Dis", 117);
    freq.put("rg ", 613);
    freq.put("oe ", 109);
    freq.put("rgo\u0303", 53);
    freq.put("ppo", 76);
    freq.put("pet", 866);
    freq.put("per", 2019);
    freq.put("pes", 209);
    freq.put("pel", 221);
    freq.put("pen", 309);
    freq.put("pei", 56);
    freq.put("pej", 56);
    freq.put("pek", 193);
    freq.put("ped", 165);
    freq.put("pee", 735);
    freq.put("ape", 400);
    freq.put("pea", 2994);
    freq.put("peb", 54);
    freq.put("pec", 50);
    freq.put("ufi", 80);
    freq.put("o\u0303du", 141);
    freq.put("oes", 47);
    freq.put("oer", 126);
    freq.put("Bor", 154);
    freq.put("Bos", 66);
    freq.put("Bou", 71);
    freq.put("O", 2986);
    freq.put("oet", 688);
    freq.put("o\u0303da", 213);
    freq.put("Bol", 76);
    freq.put("oen", 399);
    freq.put("Bon", 63);
    freq.put("o\u0303de", 121);
    freq.put("S\u030cot", 73);
    freq.put("oeg", 287);
    freq.put("oee", 44);
    freq.put("va\u0308a\u0308", 478);
    freq.put("u\u0308ta", 158);
    freq.put("\u03c2 ", 231);
    freq.put("a\u0308", 42375);
    freq.put("u\u0308te", 90);
    freq.put("u\u0308ti", 151);
    freq.put("u\u0308to", 339);
    freq.put("u\u0308tm", 69);
    freq.put("u\u0308tl", 183);
    freq.put("uso", 240);
    freq.put("u\u0308tu", 70);
    freq.put("usn", 79);
    freq.put("pe ", 459);
    freq.put("usm", 668);
    freq.put("nsh", 72);
    freq.put("nsi", 398);
    freq.put("nsk", 423);
    freq.put("nso", 192);
    freq.put("nsa", 519);
    freq.put("nsb", 47);
    freq.put("nse", 418);
    freq.put("usj", 225);
    freq.put("nsp", 183);
    freq.put("nss", 87);
    freq.put("nst", 1654);
    freq.put("nsu", 194);
    freq.put("mka", 66);
    freq.put("mko", 173);
    freq.put("ba\u0308n", 220);
    freq.put("ust", 10829);
    freq.put("uss", 984);
    freq.put(" R ", 62);
    freq.put("ns ", 389);
    freq.put("sda", 47);
    freq.put("Flo", 75);
    freq.put("Fla", 65);
    freq.put("sdo", 45);
    freq.put("nsu\u0308", 49);
    freq.put("\u0434\u043e", 115);
    freq.put("Mas", 191);
    freq.put("Mar", 1023);
    freq.put("Mau", 82);
    freq.put("Mat", 240);
    freq.put("\u0434\u0438", 121);
    freq.put("Max", 73);
    freq.put("\u0434\u0435", 141);
    freq.put(" \u0411\u043e", 74);
    freq.put("Maa", 607);
    freq.put("Mac", 68);
    freq.put(" ge", 720);
    freq.put("Mad", 279);
    freq.put("Mag", 212);
    freq.put(" ga", 319);
    freq.put("Mai", 109);
    freq.put("Mah", 61);
    freq.put("Mak", 124);
    freq.put("Maj", 106);
    freq.put("Mal", 230);
    freq.put("Man", 356);
    freq.put("kme", 409);
    freq.put("ly ", 163);
    freq.put("au", 7185);
    freq.put("\u0434\u0440", 169);
    freq.put(" co", 181);
    freq.put(" b", 2333);
    freq.put(" c", 602);
    freq.put("Men", 72);
    freq.put(" f", 3289);
    freq.put(" g", 1891);
    freq.put(" d", 4378);
    freq.put(" e", 23050);
    freq.put(" j", 29617);
    freq.put(" k", 61170);
    freq.put(" h", 8823);
    freq.put(" i", 10696);
    freq.put(" n", 13986);
    freq.put(" o", 51528);
    freq.put(" l", 23928);
    freq.put(" m", 38337);
    freq.put(" r", 13644);
    freq.put(" Dz\u030c", 49);
    freq.put(" p", 29550);
    freq.put(" q", 53);
    freq.put(" v", 33321);
    freq.put(" w", 134);
    freq.put(" t", 29638);
    freq.put(" u", 3277);
    freq.put(" z", 161);
    freq.put(" x", 127);
    freq.put(" y", 132);
    freq.put(" B", 6003);
    freq.put(" C", 4377);
    freq.put(" A", 13953);
    freq.put(" F", 3376);
    freq.put(" G", 4219);
    freq.put(" D", 3559);
    freq.put(" E", 9045);
    freq.put(" J", 4764);
    freq.put(" K", 12980);
    freq.put(" H", 6494);
    freq.put(" I", 5378);
    freq.put(" N", 6511);
    freq.put(" O", 2964);
    freq.put(" L", 9614);
    freq.put(" M", 10069);
    freq.put(" R", 6777);
    freq.put(" S", 15877);
    freq.put(" P", 11356);
    freq.put(" Q", 264);
    freq.put(" V", 9645);
    freq.put(" W", 2074);
    freq.put(" T", 11830);
    freq.put(" U", 2711);
    freq.put(" Z", 652);
    freq.put(" X", 432);
    freq.put(" Y", 594);
    freq.put("vli", 75);
    freq.put("o\u0308nd", 159);
    freq.put("vla", 98);
    freq.put("o\u0308ni", 115);
    freq.put(" a\u0308", 1217);
    freq.put("mia", 602);
    freq.put(" o\u0308", 381);
    freq.put(" o\u0303", 2318);
    freq.put(" u\u0308", 7159);
    freq.put(" A\u0301", 51);
    freq.put(" A\u0308", 128);
    freq.put(" A\u030a", 72);
    freq.put(" O\u0308", 164);
    freq.put("Ori", 67);
    freq.put("Org", 113);
    freq.put("Ord", 51);
    freq.put(" U\u0308", 1674);
    freq.put("Ora", 58);
    freq.put("och", 80);
    freq.put("ock", 501);
    freq.put(" Do", 564);
    freq.put(" S\u030c", 453);
    freq.put(" s\u030c", 125);
    freq.put("Ver", 155);
    freq.put("Ves", 127);
    freq.put(" Di", 564);
    freq.put(" De", 805);
    freq.put(" Da", 635);
    freq.put("Vee", 94);
    freq.put("ii ", 657);
    freq.put("Ven", 1754);
    freq.put("Vel", 86);
    freq.put(" z\u030c", 64);
    freq.put(" Dr", 153);
    freq.put(" Z\u030c", 57);
    freq.put("cha", 386);
    freq.put("Fr", 833);
    freq.put("che", 615);
    freq.put("\u0434\u0430", 103);
    freq.put("chi", 411);
    freq.put("chl", 138);
    freq.put("chm", 45);
    freq.put("chn", 57);
    freq.put("cho", 153);
    freq.put("Fa", 384);
    freq.put("chr", 50);
    freq.put("chs", 85);
    freq.put("cht", 224);
    freq.put("chu", 131);
    freq.put("chw", 86);
    freq.put("Fi", 490);
    freq.put("Fj", 45);
    freq.put("Fl", 194);
    freq.put("Fo", 411);
    freq.put("iiu", 178);
    freq.put("iit", 2428);
    freq.put("iiv", 1986);
    freq.put("iip", 91);
    freq.put("iis", 1521);
    freq.put("iir", 3180);
    freq.put(" D ", 91);
    freq.put("iie", 248);
    freq.put("iid", 2067);
    freq.put("iig", 4040);
    freq.put("iif", 48);
    freq.put("iia", 256);
    freq.put("iib", 405);
    freq.put("iim", 756);
    freq.put("iil", 963);
    freq.put("iin", 2367);
    freq.put("iik", 3861);
    freq.put("ch ", 578);
    freq.put(" A\u0304", 44);
    freq.put("f", 12728);
    freq.put("F ", 209);
    freq.put(" \u0438", 51);
    freq.put("Aad", 67);
    freq.put(" Du\u0308", 69);
    freq.put("afo", 83);
    freq.put("afi", 983);
    freq.put("Fo\u0308", 134);
    freq.put("Ya", 114);
    freq.put("afe", 44);
    freq.put("aff", 76);
    freq.put("Fu\u0308", 63);
    freq.put("afa", 57);
    freq.put("apa\u0308", 659);
    freq.put("aft", 134);
    freq.put("Yu", 48);
    freq.put("afr", 355);
    freq.put("\u05e8", 53);
    freq.put("af ", 128);
    freq.put("da ", 7682);
    freq.put("eum", 209);
    freq.put("lg", 4950);
    freq.put("ld", 8105);
    freq.put("le", 37295);
    freq.put("lb", 823);
    freq.put("lc", 95);
    freq.put("euk", 45);
    freq.put("la", 31670);
    freq.put("ln", 1607);
    freq.put("eud", 58);
    freq.put("ll", 19635);
    freq.put("lm", 6318);
    freq.put("lj", 4573);
    freq.put("lk", 2832);
    freq.put("lh", 474);
    freq.put("li", 57000);
    freq.put("lv", 1889);
    freq.put("lt", 11142);
    freq.put("lu", 12030);
    freq.put("lr", 311);
    freq.put("ls", 3471);
    freq.put("lp", 708);
    freq.put("eut", 162);
    freq.put("tst", 212);
    freq.put("tsu", 2329);
    freq.put("lz", 55);
    freq.put("eus", 372);
    freq.put("eur", 217);
    freq.put("dad", 930);
    freq.put("dae", 79);
    freq.put("dag", 307);
    freq.put("daa", 286);
    freq.put("dab", 1585);
    freq.put("a\u0308ge", 296);
    freq.put("dal", 2308);
    freq.put("dam", 1690);
    freq.put("dan", 602);
    freq.put("dao", 265);
    freq.put("dai", 94);
    freq.put("daj", 449);
    freq.put("dak", 424);
    freq.put("dat", 1521);
    freq.put("dav", 923);
    freq.put("dap", 141);
    freq.put("\u0432\u0441", 81);
    freq.put("dar", 435);
    freq.put("das", 1349);
    freq.put("dwi", 78);
    freq.put("l ", 31660);
    freq.put("ts ", 1169);
    freq.put("uhe", 222);
    freq.put("\u0435 ", 239);
    freq.put("lfa", 51);
    freq.put("lfi", 78);
    freq.put("lfr", 46);
    freq.put("pu\u0308h", 249);
    freq.put("la\u0308", 2964);
    freq.put("rer", 134);
    freq.put("res", 3334);
    freq.put("Tur", 159);
    freq.put("vu\u0308r", 134);
    freq.put("rev", 282);
    freq.put("Tuu", 92);
    freq.put("ret", 637);
    freq.put("reu", 99);
    freq.put("lo\u0308", 179);
    freq.put("rek", 855);
    freq.put("tsu\u0308", 333);
    freq.put("rei", 666);
    freq.put("ren", 1721);
    freq.put("reo", 148);
    freq.put("rel", 1476);
    freq.put("rem", 1488);
    freq.put("reb", 76);
    freq.put("rec", 94);
    freq.put("lu\u0308", 1913);
    freq.put("rea", 973);
    freq.put("ref", 247);
    freq.put("reg", 889);
    freq.put("red", 566);
    freq.put("ree", 2061);
    freq.put("mu\u0308r", 81);
    freq.put("lf ", 96);
    freq.put("mu\u0308t", 281);
    freq.put("\u043e\u0435 ", 83);
    freq.put("qua", 76);
    freq.put("que", 158);
    freq.put("qui", 88);
    freq.put("mu\u0308n", 66);
    freq.put("\u10dc", 45);
    freq.put("her", 737);
    freq.put("re ", 3338);
    freq.put("Z\u030c", 57);
    freq.put("ud ", 15469);
    freq.put("og ", 463);
    freq.put(" o\u0308e", 60);
    freq.put(" o\u0308k", 219);
    freq.put("nuv", 56);
    freq.put("heg", 134);
    freq.put("lic", 156);
    freq.put("uds", 80);
    freq.put("udw", 51);
    freq.put("udt", 385);
    freq.put("la\u0304", 51);
    freq.put("ogu", 2080);
    freq.put("ogt", 71);
    freq.put("ogs", 64);
    freq.put("ogr", 1310);
    freq.put("o\u0303be", 86);
    freq.put("ogo", 115);
    freq.put("ogn", 110);
    freq.put("ogi", 2325);
    freq.put("ude", 2760);
    freq.put("oge", 329);
    freq.put("sfa\u0308", 198);
    freq.put("udi", 687);
    freq.put("oga", 201);
    freq.put("udo", 126);
    freq.put("udm", 209);
    freq.put("u\u0308ve", 65);
    freq.put("nun", 66);
    freq.put("nul", 392);
    freq.put("lim", 654);
    freq.put("ru\u0308n", 141);
    freq.put("ru\u0308h", 567);
    freq.put("Par", 721);
    freq.put("Pas", 71);
    freq.put("Pat", 127);
    freq.put("Pau", 155);
    freq.put("Pav", 48);
    freq.put("Paa", 107);
    freq.put("Pad", 62);
    freq.put("Pai", 107);
    freq.put("Pak", 101);
    freq.put("Pal", 313);
    freq.put("Pan", 241);
    freq.put("mii", 356);
    freq.put("mik", 1090);
    freq.put("rez\u030c", 141);
    freq.put("mil", 5861);
    freq.put("mio", 159);
    freq.put("min", 5859);
    freq.put("\u0629", 66);
    freq.put("mic", 74);
    freq.put("mie", 74);
    freq.put("mid", 2544);
    freq.put("mig", 164);
    freq.put(" \u043a\u043e", 46);
    freq.put(" o\u0308o\u0308", 76);
    freq.put("mip", 65);
    freq.put("mis", 17764);
    freq.put("mir", 250);
    freq.put("mit", 2152);
    freq.put("miv", 72);
    freq.put("Nat", 157);
    freq.put("sfo", 68);
    freq.put("sfi", 86);
    freq.put("mi ", 3313);
    freq.put("\u043b\u0438\u0432", 45);
    freq.put("o\u0304ky", 44);
    freq.put("ksu", 1368);
    freq.put("kst", 539);
    freq.put(" \u0441", 79);
    freq.put("ksp", 172);
    freq.put("Mos", 352);
    freq.put("Mor", 136);
    freq.put(" is", 1859);
    freq.put(" it", 246);
    freq.put("Mot", 44);
    freq.put("kse", 4827);
    freq.put(" ii", 156);
    freq.put("Moh", 45);
    freq.put("ksa", 2425);
    freq.put("Mon", 346);
    freq.put(" in", 4488);
    freq.put(" io", 82);
    freq.put("ksm", 52);
    freq.put("ksl", 97);
    freq.put(" ib", 56);
    freq.put("ksn", 51);
    freq.put(" id", 1072);
    freq.put("ksh", 44);
    freq.put("ksk", 77);
    freq.put("Mod", 67);
    freq.put(" \u0422", 143);
    freq.put(" \u0423", 64);
    freq.put(" \u0420", 152);
    freq.put(" \u0421", 394);
    freq.put(" \u0427", 60);
    freq.put(" \u0424", 99);
    freq.put(" \u0425", 61);
    freq.put(" \u0428", 75);
    freq.put(" \u042e", 47);
    freq.put(" \u042f", 48);
    freq.put("Vo\u0303i", 74);
    freq.put(" \u0432", 53);
    freq.put(" \u0433", 58);
    freq.put(" \u0431", 52);
    freq.put("Vo\u0303r", 202);
    freq.put(" \u0434", 53);
    freq.put(" \u043a", 97);
    freq.put(" \u0413\u0440", 45);
    freq.put(" \u043e", 107);
    freq.put(" \u043f", 140);
    freq.put(" \u043c", 69);
    freq.put(" \u043d", 58);
    freq.put(" \u0412", 336);
    freq.put(" \u0413", 277);
    freq.put(" \u0410", 444);
    freq.put(" \u0411", 203);
    freq.put("ks ", 9327);
    freq.put(" \u0414", 137);
    freq.put(" \u0415", 66);
    freq.put(" i ", 993);
    freq.put(" \u041b", 139);
    freq.put(" \u0418", 192);
    freq.put(" \u041e", 113);
    freq.put(" \u041f", 265);
    freq.put(" \u041c", 291);
    freq.put(" \u041d", 191);
    freq.put("ksu\u0308", 131);
    freq.put("\u0440\u0438\u0441", 45);
    freq.put("he ", 2035);
    freq.put("rpi", 60);
    freq.put("o\u0308li", 74);
    freq.put("\u0440\u0438\u0438\u0306", 44);
    freq.put(" Iv", 146);
    freq.put("vri", 47);
    freq.put("e\u0300", 77);
    freq.put("u\u0308ks", 2052);
    freq.put("u\u0308kl", 190);
    freq.put("u\u0308kk", 136);
    freq.put("u\u0308ki", 160);
    freq.put(" Il", 189);
    freq.put("ka\u0308i", 618);
    freq.put(" Fo\u0308", 134);
    freq.put("ka\u0308e", 74);
    freq.put("ac", 1403);
    freq.put("oho", 123);
    freq.put("ka\u0308t", 121);
    freq.put("uie", 51);
    freq.put("ka\u0308r", 67);
    freq.put("ka\u0308s", 428);
    freq.put("ohj", 63);
    freq.put("ohk", 157);
    freq.put("ai", 13608);
    freq.put("Hoo", 71);
    freq.put("ak", 18860);
    freq.put("Hom", 80);
    freq.put("am", 18369);
    freq.put("cos", 67);
    freq.put("oha", 1453);
    freq.put("cor", 129);
    freq.put("O\u0303i", 103);
    freq.put("ao", 2265);
    freq.put("uin", 284);
    freq.put("na\u0308i", 1177);
    freq.put("na\u0308h", 356);
    freq.put("ysi", 65);
    freq.put("na\u0308o", 109);
    freq.put("na\u0308d", 70);
    freq.put("na\u0308g", 90);
    freq.put("\u0631 ", 45);
    freq.put("Hor", 121);
    freq.put("na\u0308r", 92);
    freq.put("yst", 121);
    freq.put("U\u0308li", 294);
    freq.put(" Fr", 828);
    freq.put(" Fu", 156);
    freq.put("ka\u0308a\u0308", 76);
    freq.put("uiv", 119);
    freq.put("U\u0308le", 201);
    freq.put("U\u0308ld", 58);
    freq.put(" Fa", 376);
    freq.put("oht", 1247);
    freq.put(" Fe", 322);
    freq.put("ohu", 379);
    freq.put(" Fi", 477);
    freq.put(" Fj", 45);
    freq.put(" Fl", 192);
    freq.put(" Fo", 396);
    freq.put("io ", 525);
    freq.put("emo\u0303", 84);
    freq.put("\u043c\u0430\u043d", 65);
    freq.put("SO ", 46);
    freq.put("va\u0308g", 389);
    freq.put("iov", 51);
    freq.put("iot", 121);
    freq.put("ios", 453);
    freq.put("ior", 225);
    freq.put("iop", 63);
    freq.put("ioo", 5170);
    freq.put("ion", 1904);
    freq.put("iom", 85);
    freq.put("iol", 466);
    freq.put("iok", 89);
    freq.put("iog", 121);
    freq.put("ioa", 102);
    freq.put("na\u0308a\u0308", 74);
    freq.put("va\u0308l", 2397);
    freq.put("\u0435\u0441", 139);
    freq.put("\u0435\u0440", 394);
    freq.put("\u0435\u0442", 178);
    freq.put("adv", 107);
    freq.put("eso\u0303", 110);
    freq.put("adu", 2361);
    freq.put("adr", 398);
    freq.put("ads", 103);
    freq.put(" \u0645", 56);
    freq.put("gma", 96);
    freq.put("esu\u0308", 78);
    freq.put("gme", 81);
    freq.put("ade", 4451);
    freq.put("\u0432 ", 424);
    freq.put("ada", 2882);
    freq.put("lo\u0303h", 137);
    freq.put("ado", 272);
    freq.put("adl", 409);
    freq.put("adm", 484);
    freq.put("adj", 65);
    freq.put("\u043c", 786);
    freq.put("adi", 3217);
    freq.put(" \u0627", 173);
    freq.put(" \u0628", 58);
    freq.put(" \u0639", 51);
    freq.put("\u0435\u043d", 381);
    freq.put("\u0435\u043c", 79);
    freq.put("\u0435\u043e", 53);
    freq.put("\u0435\u0438\u0306", 122);
    freq.put("\u0435\u043b", 192);
    freq.put(" \u30a2\u30a2", 51);
    freq.put("\u0435\u0435", 74);
    freq.put("\u0435\u0434", 85);
    freq.put("\u0435\u0432", 407);
    freq.put("ad ", 6207);
    freq.put("nja", 120);
    freq.put("ui ", 1419);
    freq.put("nji", 51);
    freq.put("njo", 51);
    freq.put("esw", 67);
    freq.put("esu", 447);
    freq.put("est", 15172);
    freq.put("ess", 2291);
    freq.put("esr", 46);
    freq.put("esp", 119);
    freq.put("tma", 236);
    freq.put("ese", 2495);
    freq.put("esc", 105);
    freq.put("tme", 1276);
    freq.put("esa", 695);
    freq.put("eso", 307);
    freq.put("esn", 50);
    freq.put("esm", 728);
    freq.put("esl", 149);
    freq.put("esk", 3814);
    freq.put("esi", 3721);
    freq.put("esh", 61);
    freq.put("OS ", 46);
    freq.put("es ", 19178);
    freq.put("\u4e09 ", 165);
    freq.put("\u0412", 339);
    freq.put("bu ", 80);
    freq.put("adz\u030c", 93);
    freq.put("rcu", 58);
    freq.put("rch", 187);
    freq.put("rce", 98);
    freq.put("bur", 697);
    freq.put("bus", 333);
    freq.put("Des", 76);
    freq.put("Det", 56);
    freq.put("but", 54);
    freq.put("Del", 63);
    freq.put("Dem", 159);
    freq.put("bul", 127);
    freq.put("bum", 298);
    freq.put("bub", 112);
    freq.put("bud", 140);
    freq.put("Iva", 115);
    freq.put("j", 63354);
    freq.put("pii", 2460);
    freq.put("pik", 984);
    freq.put("pil", 982);
    freq.put("pim", 106);
    freq.put("pin", 1660);
    freq.put("pio", 63);
    freq.put("pia", 480);
    freq.put("pid", 668);
    freq.put("pie", 55);
    freq.put("pig", 83);
    freq.put("ub ", 3808);
    freq.put("pir", 110);
    freq.put("pis", 249);
    freq.put("pit", 216);
    freq.put("oan", 65);
    freq.put("oam", 51);
    freq.put("oal", 156);
    freq.put("oak", 80);
    freq.put("oaj", 111);
    freq.put("u\u0308p ", 170);
    freq.put("oas", 64);
    freq.put("oar", 70);
    freq.put("ubu", 163);
    freq.put("pi ", 489);
    freq.put("\u043d\u0434\u0440", 145);
    freq.put("ube", 338);
    freq.put("uba", 529);
    freq.put("ubl", 189);
    freq.put("ubi", 508);
    freq.put("ubj", 82);
    freq.put("u\u0308po", 95);
    freq.put("u\u0308pi", 189);
    freq.put("oa ", 93);
    freq.put("u\u0308pe", 67);
    freq.put("u\u0308pp", 83);
    freq.put("ma\u0304", 44);
    freq.put(" ka\u0308", 1164);
    freq.put(" ko\u0308", 73);
    freq.put(" ko\u0303", 2868);
    freq.put(" ku\u0308", 1892);
    freq.put("G ", 207);
    freq.put("\u0644", 301);
    freq.put("mnu", 50);
    freq.put("\u05d9", 74);
    freq.put("\u0420\u043e", 57);
    freq.put("Gu", 494);
    freq.put("Gr", 855);
    freq.put("Gy", 49);
    freq.put("Ge", 880);
    freq.put("Ga", 592);
    freq.put("Go", 370);
    freq.put("Gl", 141);
    freq.put("Gi", 310);
    freq.put(" ka", 13902);
    freq.put(" ke", 11286);
    freq.put(" ki", 4980);
    freq.put(" ko", 10755);
    freq.put(" kl", 989);
    freq.put(" km", 1544);
    freq.put(" kr", 1633);
    freq.put(" kv", 246);
    freq.put(" ku", 9586);
    freq.put("kuv", 271);
    freq.put("kuu", 2381);
    freq.put("kut", 1032);
    freq.put("Z ", 57);
    freq.put("kur", 510);
    freq.put("kup", 256);
    freq.put("kun", 2636);
    freq.put("kum", 1199);
    freq.put("gna", 249);
    freq.put("kuk", 399);
    freq.put("kuj", 1401);
    freq.put("kui", 2011);
    freq.put("kuh", 220);
    freq.put("kug", 145);
    freq.put("kud", 842);
    freq.put("kub", 299);
    freq.put("kua", 93);
    freq.put(" k ", 146);
    freq.put("\u03c2", 232);
    freq.put("tiu", 100);
    freq.put("\u043d\u0430\u044f", 59);
    freq.put("tmi", 756);
    freq.put("aig", 556);
    freq.put("Go\u0308", 61);
    freq.put("Zo", 49);
    freq.put("Zh", 62);
    freq.put("Zi", 61);
    freq.put("Ze", 122);
    freq.put("Gu\u0308", 52);
    freq.put("Za", 127);
    freq.put("Zu", 94);
    freq.put("ku ", 4118);
    freq.put("Koi", 60);
    freq.put("Koh", 156);
    freq.put("Kok", 46);
    freq.put("Kom", 339);
    freq.put("Kol", 258);
    freq.put("Koo", 227);
    freq.put("Kon", 442);
    freq.put("Kod", 97);
    freq.put("Kog", 69);
    freq.put("o\u0308r ", 108);
    freq.put("Kop", 81);
    freq.put("Kos", 162);
    freq.put("Kor", 274);
    freq.put("Kot", 63);
    freq.put("ena\u0308", 125);
    freq.put("m ", 10376);
    freq.put(" O\u0303p", 48);
    freq.put(" O\u0303h", 47);
    freq.put(" O\u0303i", 101);
    freq.put("o\u0308rs", 50);
    freq.put("o\u0308ra", 67);
    freq.put("vpa", 151);
    freq.put("o\u0308rd", 139);
    freq.put("o\u0308ri", 170);
    freq.put("o\u0308rl", 72);
    freq.put("me", 23829);
    freq.put("mg", 52);
    freq.put("mf", 109);
    freq.put("ma", 35693);
    freq.put("ltu", 933);
    freq.put("mb", 5069);
    freq.put("mm", 2852);
    freq.put("ml", 264);
    freq.put("mo", 4294);
    freq.put("mn", 780);
    freq.put("mi", 40706);
    freq.put("mh", 80);
    freq.put("mk", 376);
    freq.put("mj", 183);
    freq.put("mu", 8559);
    freq.put("mt", 306);
    freq.put(" F ", 65);
    freq.put("mv", 97);
    freq.put("mp", 2268);
    freq.put("ms", 1112);
    freq.put("mr", 80);
    freq.put("my", 155);
    freq.put("ta\u0308n", 706);
    freq.put("ena", 1669);
    freq.put("enb", 279);
    freq.put("enc", 218);
    freq.put("end", 9301);
    freq.put("ene", 6080);
    freq.put("enf", 67);
    freq.put("eng", 640);
    freq.put("enh", 138);
    freq.put("eni", 2414);
    freq.put("enj", 57);
    freq.put("enk", 163);
    freq.put("enl", 78);
    freq.put("enn", 1302);
    freq.put("eno", 318);
    freq.put("enr", 170);
    freq.put("ens", 876);
    freq.put("ent", 3483);
    freq.put("enu", 916);
    freq.put("m2", 200);
    freq.put("eny", 49);
    freq.put("enz", 141);
    freq.put("II ", 579);
    freq.put("en ", 1782);
    freq.put("ma\u0308", 4794);
    freq.put("mo\u0303", 3716);
    freq.put("mo\u0308", 208);
    freq.put("mu\u0308", 731);
    freq.put(" Hy", 59);
    freq.put(" Hu", 297);
    freq.put(" Hi", 1244);
    freq.put(" Ho", 962);
    freq.put("O\u0308ko", 66);
    freq.put(" Ha", 1914);
    freq.put(" He", 1326);
    freq.put("CH ", 77);
    freq.put("imb", 81);
    freq.put("ime", 7025);
    freq.put("imi", 4107);
    freq.put("cle", 64);
    freq.put("imk", 210);
    freq.put("imm", 144);
    freq.put("ajo\u0303", 234);
    freq.put("imo", 225);
    freq.put("imn", 64);
    freq.put("imp", 192);
    freq.put("ims", 252);
    freq.put("imu", 1850);
    freq.put("imt", 70);
    freq.put("aja\u0308", 246);
    freq.put("\u0444", 166);
    freq.put("SA ", 770);
    freq.put(" H ", 102);
    freq.put("im ", 1389);
    freq.put("\u064a ", 68);
    freq.put(" Hu\u0308", 108);
    freq.put(" Ho\u0303", 54);
    freq.put("tip", 427);
    freq.put(" Ha\u0308", 127);
    freq.put("gol", 120);
    freq.put("goo", 292);
    freq.put("gon", 121);
    freq.put("ima\u0308", 330);
    freq.put("aju", 375);
    freq.put("imo\u0303", 379);
    freq.put("ajo", 642);
    freq.put("aja", 7056);
    freq.put("gov", 53);
    freq.put("aje", 136);
    freq.put("gos", 166);
    freq.put("gor", 359);
    freq.put("W", 2107);
    freq.put("Vic", 79);
    freq.put("Vig", 101);
    freq.put("Vid", 54);
    freq.put("Vie", 71);
    freq.put("Vik", 195);
    freq.put("Vih", 45);
    freq.put("Vii", 222);
    freq.put("Vin", 105);
    freq.put("i\u0300", 56);
    freq.put("Vil", 366);
    freq.put("Vir", 448);
    freq.put("Vis", 61);
    freq.put("Vit", 59);
    freq.put(" Sp", 263);
    freq.put("nhe", 51);
    freq.put("nha", 193);
    freq.put("nho", 71);
    freq.put("nir", 49);
    freq.put("\u041a", 318);
    freq.put("tor", 2218);
    freq.put("tos", 269);
    freq.put("top", 205);
    freq.put("tov", 120);
    freq.put("tot", 150);
    freq.put("\u043c\u043e\u0432", 45);
    freq.put("tok", 224);
    freq.put("toh", 46);
    freq.put("toi", 1340);
    freq.put("ton", 1159);
    freq.put(" \u0421\u0435", 84);
    freq.put("tol", 1335);
    freq.put("tom", 456);
    freq.put("toc", 161);
    freq.put("toa", 50);
    freq.put("tof", 48);
    freq.put("tog", 150);
    freq.put(" \u0421\u043e", 64);
    freq.put("toe", 213);
    freq.put(" \u0421\u0442", 49);
    freq.put("dz\u030cu", 46);
    freq.put("to ", 641);
    freq.put("thu", 237);
    freq.put("raf", 126);
    freq.put("rag", 255);
    freq.put("rad", 970);
    freq.put("rae", 588);
    freq.put("rab", 296);
    freq.put("rac", 160);
    freq.put("raa", 4053);
    freq.put("\u4e09", 373);
    freq.put("rao", 70);
    freq.put("ral", 1912);
    freq.put("ram", 1127);
    freq.put("raj", 969);
    freq.put("rak", 1264);
    freq.put("rah", 2331);
    freq.put("rai", 575);
    freq.put("rav", 669);
    freq.put("rat", 2331);
    freq.put("rau", 610);
    freq.put("rar", 113);
    freq.put("ras", 2388);
    freq.put("rap", 222);
    freq.put("lbi", 58);
    freq.put("lbo", 45);
    freq.put("va\u0308s", 44);
    freq.put("thi", 183);
    freq.put("ra ", 2421);
    freq.put("va\u0308r", 503);
    freq.put("bst", 74);
    freq.put("\u0423", 66);
    freq.put("\u0432\u0430 ", 83);
    freq.put("bso", 114);
    freq.put("bse", 67);
    freq.put("Ita", 340);
    freq.put("R", 6826);
    freq.put("ru\u0308u\u0308", 199);
    freq.put("e\u0301s", 48);
    freq.put("e\u0301r", 80);
    freq.put("e\u0301n", 82);
    freq.put("pko", 106);
    freq.put("oci", 105);
    freq.put("Bio", 136);
    freq.put("Bil", 84);
    freq.put("oco", 61);
    freq.put("oce", 44);
    freq.put("\u0430 ", 653);
    freq.put("Bir", 85);
    freq.put("Bis", 73);
    freq.put("\u0440", 2377);
    freq.put("Aaf", 295);
    freq.put("Aas", 446);
    freq.put("Aar", 73);
    freq.put("e\u0301 ", 189);
    freq.put("u\u0308rs", 166);
    freq.put("u\u0308rt", 60);
    freq.put("u\u0308ra", 58);
    freq.put("u\u0308re", 55);
    freq.put("u\u0308rg", 241);
    freq.put("u\u0308ri", 378);
    freq.put("u\u0308rk", 57);
    freq.put("u\u0308ro", 72);
    freq.put("nux", 47);
    freq.put("Pet", 350);
    freq.put("ru\u0308t", 71);
    freq.put("nut", 211);
    freq.put("nur", 279);
    freq.put("nus", 1407);
    freq.put("Per", 283);
    freq.put("Pel", 65);
    freq.put("Pen", 99);
    freq.put("num", 581);
    freq.put("nuj", 150);
    freq.put("nuk", 391);
    freq.put("ru\u0308k", 165);
    freq.put("nui", 73);
    freq.put("Ped", 50);
    freq.put("Pee", 136);
    freq.put("nud", 6307);
    freq.put("Pea", 138);
    freq.put("nua", 567);
    freq.put("muu", 2318);
    freq.put("mut", 357);
    freq.put("muv", 182);
    freq.put("mus", 2450);
    freq.put("mur", 342);
    freq.put("\u10d8 ", 59);
    freq.put("mud", 268);
    freq.put("\u043d\u0430 ", 209);
    freq.put("mub", 235);
    freq.put("Ku\u0308l", 163);
    freq.put("mul", 772);
    freq.put("mun", 762);
    freq.put("mui", 212);
    freq.put("muk", 66);
    freq.put("muj", 55);
    freq.put("nu ", 581);
    freq.put("ell", 3694);
    freq.put("mu ", 287);
    freq.put(" me", 3580);
    freq.put("\u4e4b ", 88);
    freq.put(" ma", 7824);
    freq.put(" mm", 67);
    freq.put(" mo", 1838);
    freq.put(" mi", 14942);
    freq.put(" mu", 3133);
    freq.put("ele", 10866);
    freq.put("\u03b9\u0301", 80);
    freq.put(" m ", 441);
    freq.put("VR ", 44);
    freq.put("Cri", 46);
    freq.put("TV ", 56);
    freq.put("n", 259681);
    freq.put("Tu\u0308r", 179);
    freq.put("elt", 4591);
    freq.put(" ma\u0308", 2882);
    freq.put(" mo\u0303", 2887);
    freq.put(" mo\u0308", 122);
    freq.put(" mu\u0308", 545);
    freq.put("\u062d", 106);
    freq.put("i\u0304n", 58);
    freq.put("o\u0308pm", 55);
    freq.put("i\u0304 ", 118);
    freq.put("ru\u0308o", 64);
    freq.put(" Ju\u0308", 111);
    freq.put(" Jo\u0303", 269);
    freq.put(" Ja\u0308", 515);
    freq.put("elj", 466);
    freq.put("elk", 721);
    freq.put("eli", 5612);
    freq.put("eln", 482);
    freq.put("elo", 690);
    freq.put("Hu\u0308", 108);
    freq.put("elm", 278);
    freq.put("elb", 55);
    freq.put("ela", 2671);
    freq.put("elf", 47);
    freq.put("elg", 374);
    freq.put("eld", 1386);
    freq.put("Ho\u0303", 54);
    freq.put("els", 698);
    freq.put("elp", 87);
    freq.put("elv", 392);
    freq.put("Ha\u0308", 127);
    freq.put("elu", 1130);
    freq.put("D", 3604);
    freq.put("el ", 10310);
    freq.put("vip", 54);
    freq.put(" Ju", 831);
    freq.put("dz\u030ci", 112);
    freq.put(" Jo", 986);
    freq.put(" Ji", 117);
    freq.put(" Je", 475);
    freq.put(" Ja", 1269);
    freq.put("U\u0308hi", 101);
    freq.put("ick", 168);
    freq.put("ici", 96);
    freq.put("Hy", 59);
    freq.put("ico", 150);
    freq.put("ica", 492);
    freq.put("ela\u0308", 86);
    freq.put("Hu", 297);
    freq.put("Hi", 1244);
    freq.put("Ho", 963);
    freq.put("ics", 57);
    freq.put("icr", 74);
    freq.put("Ha", 1920);
    freq.put("icu", 98);
    freq.put("He", 1336);
    freq.put("su\u0308k", 585);
    freq.put("hst", 88);
    freq.put("ic ", 272);
    freq.put("H ", 271);
    freq.put("thr", 60);
    freq.put("ppa", 134);
    freq.put("aha", 671);
    freq.put("ppe", 738);
    freq.put("ahe", 4825);
    freq.put("ahj", 153);
    freq.put("ahk", 234);
    freq.put("ahh", 236);
    freq.put("ahi", 395);
    freq.put("ahn", 114);
    freq.put("aho", 103);
    freq.put("ahl", 63);
    freq.put("ppl", 73);
    freq.put("ahr", 54);
    freq.put("ahs", 82);
    freq.put("ahv", 2279);
    freq.put("aht", 765);
    freq.put("ahu", 752);
    freq.put("ne\u0301", 46);
    freq.put("git", 756);
    freq.put("gis", 1905);
    freq.put("gir", 78);
    freq.put("gip", 428);
    freq.put("na\u0308", 2052);
    freq.put("nc\u0327", 57);
    freq.put("gig", 185);
    freq.put("gie", 61);
    freq.put("gid", 469);
    freq.put("nu\u0308", 262);
    freq.put("gib", 455);
    freq.put("gia", 2005);
    freq.put("gio", 325);
    freq.put("gin", 524);
    freq.put("gim", 411);
    freq.put("gil", 1090);
    freq.put("gik", 642);
    freq.put("no\u0303", 791);
    freq.put("gii", 53);
    freq.put("gih", 62);
    freq.put("ah ", 172);
    freq.put("pp ", 583);
    freq.put("a\u0301n ", 48);
    freq.put("n\u0301", 54);
    freq.put("Vol", 205);
    freq.put("Voo", 53);
    freq.put("U\u0308he", 728);
    freq.put("Vor", 103);
    freq.put("gi ", 5321);
    freq.put("nno", 142);
    freq.put("nnm", 60);
    freq.put("uro", 1163);
    freq.put("aha\u0308", 77);
    freq.put("nne", 1409);
    freq.put("nna", 9091);
    freq.put("nnu", 1256);
    freq.put("nns", 51);
    freq.put("nh", 382);
    freq.put("ni", 36973);
    freq.put("nj", 320);
    freq.put("nk", 2416);
    freq.put("nl", 419);
    freq.put("nm", 235);
    freq.put("nn", 17075);
    freq.put("no", 4692);
    freq.put("tit", 780);
    freq.put("na", 27821);
    freq.put("nb", 439);
    freq.put("nc", 950);
    freq.put("nd", 30717);
    freq.put("ne", 35835);
    freq.put("nf", 748);
    freq.put("ng", 16763);
    freq.put("til", 2148);
    freq.put("ny", 360);
    freq.put("nz", 355);
    freq.put("tio", 925);
    freq.put("tih", 290);
    freq.put("tii", 1991);
    freq.put("tij", 48);
    freq.put("tik", 5067);
    freq.put("np", 151);
    freq.put("tie", 142);
    freq.put("nr", 469);
    freq.put("ns", 4828);
    freq.put("nt", 12596);
    freq.put("nu", 11347);
    freq.put("nv", 314);
    freq.put("nw", 57);
    freq.put("\u0432\u0430\u043d", 86);
    freq.put("nn ", 2722);
    freq.put("ich", 758);
    freq.put("n ", 49802);
    freq.put("ti ", 9417);
    freq.put("roh", 391);
    freq.put("roi", 109);
    freq.put("roj", 238);
    freq.put("rok", 255);
    freq.put("rol", 630);
    freq.put("rom", 675);
    freq.put("ron", 932);
    freq.put("roo", 2596);
    freq.put("lls", 97);
    freq.put("roa", 117);
    freq.put("rob", 239);
    freq.put("roc", 250);
    freq.put("rod", 447);
    freq.put("roe", 51);
    freq.put("rof", 315);
    freq.put("rog", 576);
    freq.put("llk", 46);
    freq.put("lli", 4723);
    freq.put("llo", 330);
    freq.put("ice", 186);
    freq.put("rop", 430);
    freq.put("ror", 118);
    freq.put("ros", 627);
    freq.put("rot", 969);
    freq.put("rou", 140);
    freq.put("rov", 1089);
    freq.put("row", 56);
    freq.put("\u0447\u0435", 89);
    freq.put("Dan", 112);
    freq.put("Dav", 137);
    freq.put("Dar", 75);
    freq.put("kle", 259);
    freq.put("ro ", 398);
    freq.put("\u0448", 180);
    freq.put("Cit", 59);
    freq.put("\u0432\u043e ", 47);
    freq.put("ict", 114);
    freq.put("llu\u0308", 71);
    freq.put("Res", 61);
    freq.put("Rep", 45);
    freq.put("Rev", 69);
    freq.put("eu\u0308k", 52);
    freq.put("Rei", 185);
    freq.put("Ren", 63);
    freq.put("Rel", 79);
    freq.put("Rec", 53);
    freq.put("Rea", 67);
    freq.put("Reg", 77);
    freq.put("uls", 130);
    freq.put(" u\u0308r", 128);
    freq.put("kyo\u0304", 50);
    freq.put("\u0131", 50);
    freq.put(" u\u0308m", 508);
    freq.put(" u\u0308l", 2321);
    freq.put(" u\u0308k", 1493);
    freq.put(" u\u0308h", 2633);
    freq.put(" \u30a2", 53);
    freq.put("Age", 54);
    freq.put("ð", 63);
    freq.put("a\u0308ki", 100);
    freq.put("\u041e", 115);
    freq.put("ngt", 111);
    freq.put("msu", 90);
    freq.put("mst", 77);
    freq.put("mso", 47);
    freq.put("msi", 100);
    freq.put("mse", 406);
    freq.put("msa", 75);
    freq.put("Eva", 52);
    freq.put("obj", 309);
    freq.put("ms ", 217);
    freq.put(" on", 34245);
    freq.put("Mih", 126);
    freq.put(" ol", 7096);
    freq.put(" om", 1854);
    freq.put(" oj", 83);
    freq.put("Mil", 150);
    freq.put(" oh", 172);
    freq.put("Min", 245);
    freq.put(" of", 466);
    freq.put("Mic", 227);
    freq.put(" ob", 937);
    freq.put("nma", 125);
    freq.put(" ot", 471);
    freq.put(" or", 1834);
    freq.put(" os", 2510);
    freq.put(" op", 302);
    freq.put("ky ", 44);
    freq.put("\u4e18", 83);
    freq.put("\u043b\u043e\u0432", 104);
    freq.put("eja\u0308", 142);
    freq.put("gto", 66);
    freq.put("ejo\u0303", 394);
    freq.put("ppi", 265);
    freq.put("\u0648", 125);
    freq.put("ng ", 5293);
    freq.put("gt ", 50);
    freq.put("ppu", 86);
    freq.put(" \u041d\u0438", 84);
    freq.put("\u0438\u043a", 203);
    freq.put("\u0438\u043b", 197);
    freq.put("\u0438\u0438", 45);
    freq.put("\u0438\u0438\u0306", 374);
    freq.put("\u0438\u043c", 129);
    freq.put("\u0438\u043d", 324);
    freq.put("\u0438\u0432", 76);
    freq.put("\u0438\u0433", 52);
    freq.put("mim", 121);
    freq.put("\u0438\u0434", 49);
    freq.put("\u0438\u0435", 98);
    freq.put("ejo", 57);
    freq.put("eje", 77);
    freq.put("eja", 948);
    freq.put("eju", 213);
    freq.put("giv", 225);
    freq.put("\u0430\u0434\u0438", 61);
    freq.put("\u0438\u044f", 126);
    freq.put("\u0438\u0442", 98);
    freq.put("\u0438\u0440", 115);
    freq.put("\u0438\u0441", 145);
    freq.put("\u0438\u0447", 632);
    freq.put("\u0438\u0445", 108);
    freq.put("ana\u0308", 68);
    freq.put("anc\u0327", 55);
    freq.put("hu ", 482);
    freq.put("ano\u0303", 84);
    freq.put("iam", 367);
    freq.put("ial", 852);
    freq.put("iao", 48);
    freq.put("ian", 848);
    freq.put("iai", 81);
    freq.put("iah", 71);
    freq.put("iak", 307);
    freq.put("iaj", 141);
    freq.put("iae", 81);
    freq.put("iad", 147);
    freq.put("iag", 258);
    freq.put("iaa", 1098);
    freq.put("iac", 55);
    freq.put("iab", 61);
    freq.put("iau", 97);
    freq.put("iat", 663);
    freq.put("iav", 133);
    freq.put("iap", 68);
    freq.put("ias", 2407);
    freq.put("iar", 200);
    freq.put("hua", 81);
    freq.put("hul", 1525);
    freq.put("hum", 318);
    freq.put("hun", 86);
    freq.put("huk", 196);
    freq.put("hut", 421);
    freq.put("huu", 56);
    freq.put("huv", 197);
    freq.put("hur", 174);
    freq.put("hus", 694);
    freq.put("Mis", 98);
    freq.put(" La\u0308", 1080);
    freq.put("ia ", 7687);
    freq.put("gij", 262);
    freq.put("\u0646 ", 97);
    freq.put(" Lo\u0303", 669);
    freq.put("r", 180124);
    freq.put(" Lu\u0308", 129);
    freq.put("and", 7769);
    freq.put("ane", 2890);
    freq.put("ang", 1938);
    freq.put("pra", 973);
    freq.put("ana", 2831);
    freq.put("anc", 369);
    freq.put("anl", 132);
    freq.put("anm", 52);
    freq.put("ann", 2713);
    freq.put("ano", 601);
    freq.put("pri", 927);
    freq.put("ani", 8218);
    freq.put("anj", 107);
    freq.put("ank", 687);
    freq.put("ant", 3838);
    freq.put("anu", 1617);
    freq.put("anr", 93);
    freq.put("ans", 1284);
    freq.put("any", 60);
    freq.put("anz", 132);
    freq.put("ML ", 59);
    freq.put(" L ", 50);
    freq.put("\u0435", 2779);
    freq.put("gko", 571);
    freq.put("an ", 2385);
    freq.put("\u4e59", 67);
    freq.put(" Le", 1398);
    freq.put(" La", 1495);
    freq.put(" Lo", 1146);
    freq.put(" Li", 2733);
    freq.put(" Lu", 546);
    freq.put(" Ly", 58);
    freq.put("tke", 169);
    freq.put("kas", 4782);
    freq.put("tka", 199);
    freq.put("tko", 214);
    freq.put("IP ", 48);
    freq.put("hku", 160);
    freq.put("tki", 109);
    freq.put("nla", 220);
    freq.put("tku", 135);
    freq.put("nli", 99);
    freq.put("dy ", 101);
    freq.put("ss ", 961);
    freq.put("\u0447 ", 585);
    freq.put("ssu", 260);
    freq.put("H", 6531);
    freq.put("sso", 712);
    freq.put("ssi", 2279);
    freq.put("ssk", 48);
    freq.put("sse", 2400);
    freq.put("ssa", 886);
    freq.put("rms", 58);
    freq.put("rmu", 175);
    freq.put("lnu", 266);
    freq.put("uim", 112);
    freq.put("rma", 1727);
    freq.put("lni", 82);
    freq.put("rme", 627);
    freq.put("lne", 1147);
    freq.put("tku\u0308", 52);
    freq.put("rmi", 820);
    freq.put("rmo", 236);
    freq.put("fo\u0308d", 110);
    freq.put("o\u0303us", 427);
    freq.put("ssu\u0308", 155);
    freq.put("sso\u0303", 135);
    freq.put("sso\u0308", 85);
    freq.put("rm ", 305);
    freq.put(" \u0627\u0644", 145);
    freq.put("pot", 178);
    freq.put("por", 922);
    freq.put("pos", 489);
    freq.put("pop", 279);
    freq.put("pon", 250);
    freq.put("poo", 3433);
    freq.put("pol", 2011);
    freq.put("pom", 75);
    freq.put("poj", 56);
    freq.put("pok", 78);
    freq.put("poi", 69);
    freq.put("poe", 314);
    freq.put("nni", 2211);
    freq.put("Bur", 160);
    freq.put("Bus", 55);
    freq.put("\u043d\u043e\u0432", 187);
    freq.put("Bul", 94);
    freq.put("Bud", 75);
    freq.put("Aer", 49);
    freq.put("Aeg", 46);
    freq.put("po ", 62);
    freq.put("oks", 957);
    freq.put("okr", 399);
    freq.put("oku", 340);
    freq.put("okt", 664);
    freq.put("\u0431", 447);
    freq.put("I ", 1170);
    freq.put("yo", 142);
    freq.put("\u0441\u0430\u043d", 105);
    freq.put("Is", 449);
    freq.put("Ir", 247);
    freq.put("It", 383);
    freq.put("Iv", 146);
    freq.put("Ii", 222);
    freq.put("Im", 143);
    freq.put("Il", 192);
    freq.put("Io", 55);
    freq.put("In", 1490);
    freq.put("oke", 623);
    freq.put("Id", 463);
    freq.put("Ig", 87);
    freq.put(" \u041b\u0435", 47);
    freq.put("\u042d", 79);
    freq.put("oki", 231);
    freq.put("tir", 123);
    freq.put("tis", 3212);
    freq.put("okk", 531);
    freq.put("tim", 859);
    freq.put("tin", 1198);
    freq.put("okl", 55);
    freq.put("to\u0303r", 100);
    freq.put("to\u0303s", 109);
    freq.put("to\u0303t", 177);
    freq.put("to\u0303u", 195);
    freq.put("tid", 1567);
    freq.put("to\u0303k", 57);
    freq.put("to\u0303l", 200);
    freq.put("to\u0303m", 70);
    freq.put("to\u0303e", 238);
    freq.put("Pih", 114);
    freq.put("Pii", 306);
    freq.put("Pik", 86);
    freq.put("Pil", 73);
    freq.put("Pin", 124);
    freq.put("Pie", 94);
    freq.put("tia", 704);
    freq.put("ha\u0308a\u0308", 354);
    freq.put("Pir", 78);
    freq.put("tic", 223);
    freq.put("\u0438 ", 220);
    freq.put("Kur", 369);
    freq.put("Kun", 277);
    freq.put("Kul", 317);
    freq.put("Kui", 148);
    freq.put("o\u0308ta", 380);
    freq.put("gvi", 72);
    freq.put("kva", 933);
    freq.put("o\u0308tm", 68);
    freq.put("o\u0308tl", 187);
    freq.put("o ", 5439);
    freq.put("oo", 36377);
    freq.put("on", 61110);
    freq.put("om", 10938);
    freq.put("ol", 25486);
    freq.put("ok", 4533);
    freq.put("oj", 1236);
    freq.put("oi", 2595);
    freq.put("oh", 4211);
    freq.put("og", 7246);
    freq.put("of", 1882);
    freq.put("oe", 1975);
    freq.put("od", 6416);
    freq.put("oc", 974);
    freq.put("ob", 2993);
    freq.put("oa", 902);
    freq.put("oz", 161);
    freq.put("oy", 237);
    freq.put("ox", 103);
    freq.put("ow", 446);
    freq.put("ov", 3905);
    freq.put("ou", 1255);
    freq.put("ot", 7307);
    freq.put("os", 13528);
    freq.put("or", 18504);
    freq.put("ha\u0308i", 143);
    freq.put("op", 3770);
    freq.put("ju ", 890);
    freq.put("\u0421\u0435", 84);
    freq.put("Jum", 146);
    freq.put("\u0421\u043e", 64);
    freq.put("eht", 613);
    freq.put("ehr", 86);
    freq.put("\u03b3", 53);
    freq.put("ehe", 590);
    freq.put("ve ", 854);
    freq.put("eha", 1078);
    freq.put("ehn", 541);
    freq.put("eho", 88);
    freq.put("ehm", 64);
    freq.put("ehk", 5017);
    freq.put("ehh", 383);
    freq.put("ehi", 903);
    freq.put("jub", 134);
    freq.put("jug", 89);
    freq.put("jud", 292);
    freq.put("juk", 80);
    freq.put("juh", 1325);
    freq.put("jun", 529);
    freq.put("jul", 461);
    freq.put("Pu\u0308h", 181);
    freq.put("jur", 167);
    freq.put("jus", 656);
    freq.put("juv", 119);
    freq.put("Pu\u0308r", 45);
    freq.put("jut", 1345);
    freq.put("juu", 1477);
    freq.put("\u0421\u0442", 49);
    freq.put("\u0443\u0434", 52);
    freq.put("\u4e01", 204);
    freq.put("rva", 1548);
    freq.put("rve", 1159);
    freq.put("rvi", 795);
    freq.put("rvl", 46);
    freq.put("rvp", 144);
    freq.put("rvu", 1089);
    freq.put("igu", 1608);
    freq.put("igr", 133);
    freq.put("\u0631", 186);
    freq.put("ige", 1448);
    freq.put("iga", 2716);
    freq.put("igo", 112);
    freq.put("ign", 238);
    freq.put("igm", 62);
    freq.put("igl", 90);
    freq.put("otb", 45);
    freq.put("igi", 4211);
    freq.put("igh", 187);
    freq.put("rv ", 755);
    freq.put("Jak", 74);
    freq.put("hwa", 51);
    freq.put("nu\u0308u\u0308", 243);
    freq.put("s\u0327", 74);
    freq.put("tlu", 1138);
    freq.put("Ma\u0308n", 102);
    freq.put("\u043c\u0438\u0440", 58);
    freq.put("os\u030c", 66);
    freq.put("ig ", 195);
    freq.put("Ma\u0308r", 85);
    freq.put("aln", 583);
    freq.put("alo", 1054);
    freq.put("all", 6989);
    freq.put("alm", 1124);
    freq.put("alj", 729);
    freq.put("alk", 711);
    freq.put("alh", 218);
    freq.put("ali", 9008);
    freq.put("alf", 70);
    freq.put("alg", 2752);
    freq.put("ald", 4688);
    freq.put("ale", 3211);
    freq.put("alb", 322);
    freq.put("lly", 101);
    freq.put("pta", 45);
    freq.put("ala", 5975);
    freq.put("\u0442\u043e\u0432", 47);
    freq.put("alv", 587);
    freq.put("alt", 2286);
    freq.put("alu", 1954);
    freq.put("alr", 157);
    freq.put("o\u0303u ", 118);
    freq.put("alp", 242);
    freq.put(" N ", 212);
    freq.put("\u0413\u0440", 45);
    freq.put("llp", 58);
    freq.put("far", 57);
    freq.put("o\u0303ut", 47);
    freq.put("\u0413\u0435", 81);
    freq.put("fak", 63);
    freq.put("o\u0303un", 1596);
    freq.put("fan", 78);
    freq.put("llu", 829);
    freq.put("o\u0303uk", 759);
    freq.put("o\u0303ue", 77);
    freq.put("fac", 50);
    freq.put("o\u0303ug", 83);
    freq.put("faa", 159);
    freq.put("o\u0303ua", 73);
    freq.put(" Ni", 722);
    freq.put(" No", 1462);
    freq.put(" Na", 1003);
    freq.put(" Ne", 1115);
    freq.put(" Ny", 45);
    freq.put("dz\u030ca", 146);
    freq.put(" Nu", 172);
    freq.put("teh", 952);
    freq.put("tei", 2648);
    freq.put("tej", 88);
    freq.put("tek", 2590);
    freq.put("tel", 4094);
    freq.put("tem", 2042);
    freq.put("ten", 994);
    freq.put("teo", 974);
    freq.put("tea", 2198);
    freq.put("tec", 57);
    freq.put("ted", 509);
    freq.put("tee", 4577);
    freq.put("nbu", 170);
    freq.put("teg", 3418);
    freq.put("alu\u0308", 198);
    freq.put("tep", 235);
    freq.put("nba", 54);
    freq.put("alo\u0303", 58);
    freq.put("tet", 709);
    freq.put("eKr", 290);
    freq.put("nbe", 157);
    freq.put("sug", 926);
    freq.put("sud", 110);
    freq.put("sub", 2124);
    freq.put("sua", 230);
    freq.put("sun", 473);
    freq.put("sum", 385);
    freq.put("sul", 1089);
    freq.put("suk", 274);
    freq.put("suh", 654);
    freq.put("KP ", 62);
    freq.put("suv", 746);
    freq.put("suu", 3246);
    freq.put("sut", 3768);
    freq.put("sus", 4456);
    freq.put("sur", 769);
    freq.put("sup", 112);
    freq.put("te ", 12807);
    freq.put("o\u0304", 306);
    freq.put("\u0442\u0430\u043d", 48);
    freq.put("\u4e01 ", 49);
    freq.put("su ", 776);
    freq.put(" Na\u0308", 145);
    freq.put("lo", 11129);
    freq.put(" Nu\u0308", 45);
    freq.put(" No\u0303", 702);
    freq.put("rkt", 136);
    freq.put("rku", 265);
    freq.put("rkv", 211);
    freq.put("rks", 128);
    freq.put("Tor", 167);
    freq.put("Ung", 127);
    freq.put("rke", 333);
    freq.put("Toi", 63);
    freq.put("Ton", 64);
    freq.put("Too", 201);
    freq.put("Tol", 64);
    freq.put("Tom", 75);
    freq.put("rkm", 44);
    freq.put("rko", 1059);
    freq.put("rki", 431);
    freq.put("rkk", 66);
    freq.put("\u0438\u0306\u0441", 53);
    freq.put("\u03b7", 90);
    freq.put("rk ", 868);
    freq.put("a\u0301", 537);
    freq.put("Int", 306);
    freq.put("Ins", 151);
    freq.put("Ini", 62);
    freq.put("v", 88215);
    freq.put("Ind", 377);
    freq.put("Inf", 74);
    freq.put("Ing", 355);
    freq.put("a\u0308a\u0308s", 242);
    freq.put("a\u0308a\u0308r", 2288);
    freq.put("a\u0308a\u0308v", 158);
    freq.put("a\u0308a\u0308t", 82);
    freq.put("a\u0308a\u0308k", 111);
    freq.put("oyl", 61);
    freq.put("a\u0308a\u0308n", 2004);
    freq.put("a\u0308a\u0308m", 126);
    freq.put("a\u0308a\u0308l", 395);
    freq.put("\u0438\u0306", 835);
    freq.put("a\u0308a\u0308b", 251);
    freq.put("a\u0308a\u0308g", 344);
    freq.put("oya", 45);
    freq.put("a\u0308a\u0308d", 51);
    freq.put("Akt", 63);
    freq.put("Aka", 119);
    freq.put("lhe", 124);
    freq.put("lha", 82);
    freq.put("lho", 73);
    freq.put("lhu", 155);
    freq.put("a\u0308a\u0308 ", 101);
    freq.put("oy ", 48);
    freq.put(" su\u0308", 5410);
    freq.put(" so\u0308", 81);
    freq.put("\u043e\u043a", 58);
    freq.put(" so\u0303", 2172);
    freq.put(" sa\u0308", 314);
    freq.put("ll ", 1528);
    freq.put("yn ", 51);
    freq.put("To\u0304k", 46);
    freq.put("\u043e\u0432", 918);
    freq.put("L", 9649);
    freq.put("\u0432\u0438\u0447", 569);
    freq.put("Era", 62);
    freq.put("Ern", 93);
    freq.put("Eri", 232);
    freq.put("Rad", 71);
    freq.put("Raa", 184);
    freq.put("Ran", 128);
    freq.put("yne", 47);
    freq.put("Ram", 65);
    freq.put("Rak", 98);
    freq.put("Rah", 536);
    freq.put("Rai", 65);
    freq.put("Rau", 107);
    freq.put("Ras", 57);
    freq.put("Rap", 154);
    freq.put("Muu", 174);
    freq.put(" sy", 46);
    freq.put("Mus", 281);
    freq.put("Mur", 95);
    freq.put(" sp", 570);
    freq.put(" st", 1273);
    freq.put(" su", 5118);
    freq.put(" sk", 246);
    freq.put(" sh", 125);
    freq.put(" si", 2589);
    freq.put(" so", 1701);
    freq.put(" sl", 105);
    freq.put("Mul", 70);
    freq.put(" sa", 6645);
    freq.put("Muh", 59);
    freq.put(" se", 7005);
    freq.put("iza", 126);
    freq.put("ize", 56);
    freq.put("gur", 250);
    freq.put("eku\u0308", 242);
    freq.put("doo", 134);
    freq.put("o\u0301n", 116);
    freq.put(" em", 344);
    freq.put(" en", 2378);
    freq.put("ima", 3230);
    freq.put(" eh", 5575);
    freq.put(" s ", 402);
    freq.put(" ei", 852);
    freq.put(" ek", 498);
    freq.put(" ed", 721);
    freq.put(" ef", 88);
    freq.put(" eg", 105);
    freq.put(" eb", 183);
    freq.put("gpa", 728);
    freq.put("\u0441\u043a\u0438", 218);
    freq.put("\u0441\u043a\u043e", 106);
    freq.put(" eu", 119);
    freq.put("\u0441\u043a\u0430", 112);
    freq.put(" ev", 98);
    freq.put("pme", 107);
    freq.put("au\u0308l", 78);
    freq.put("a\u0308de", 48);
    freq.put("au\u0308h", 102);
    freq.put("kov", 236);
    freq.put("\u0435\u043d\u043d", 63);
    freq.put("\u0435\u043d\u0438", 90);
    freq.put("eft", 49);
    freq.put("\u0442\u0440\u043e", 97);
    freq.put("efi", 173);
    freq.put("efo", 256);
    freq.put("\u0639", 100);
    freq.put("efa", 50);
    freq.put("efe", 291);
    freq.put("eff", 54);
    freq.put("ef ", 57);
    freq.put("rte", 1543);
    freq.put("rta", 274);
    freq.put("aro\u0303", 46);
    freq.put("aro\u0308", 60);
    freq.put("rtm", 58);
    freq.put("rtl", 107);
    freq.put("rto", 217);
    freq.put("rtn", 92);
    freq.put("aru\u0308", 99);
    freq.put("rth", 281);
    freq.put("hi ", 803);
    freq.put("rtt", 57);
    freq.put("rts", 1053);
    freq.put("rtr", 65);
    freq.put("\u0447\u0435\u0441", 55);
    freq.put("Ju", 835);
    freq.put("ies", 329);
    freq.put("ier", 409);
    freq.put("iet", 453);
    freq.put("iev", 106);
    freq.put("iek", 65);
    freq.put("Jo", 991);
    freq.put("iem", 193);
    freq.put("iel", 576);
    freq.put("ien", 617);
    freq.put("Je", 477);
    freq.put("iec", 79);
    freq.put("iee", 79);
    freq.put("Ja", 1273);
    freq.put("hip", 104);
    freq.put("hir", 223);
    freq.put("his", 1677);
    freq.put("hit", 1195);
    freq.put("rt ", 810);
    freq.put("hiv", 50);
    freq.put("hia", 196);
    freq.put("hib", 91);
    freq.put("Xi", 96);
    freq.put("hid", 172);
    freq.put("hie", 100);
    freq.put("hig", 50);
    freq.put("hii", 392);
    freq.put("hik", 677);
    freq.put("hil", 853);
    freq.put("him", 313);
    freq.put("hin", 1818);
    freq.put("hio", 120);
    freq.put(" \u1100\u1161", 51);
    freq.put(" Po\u0308", 45);
    freq.put(" Po\u0303", 1331);
    freq.put("aab", 988);
    freq.put(" Pu\u0308", 263);
    freq.put("upu", 118);
    freq.put("\u0576", 64);
    freq.put("ie ", 546);
    freq.put("J ", 73);
    freq.put("arp", 144);
    freq.put("arr", 543);
    freq.put("ars", 766);
    freq.put("art", 3541);
    freq.put("aru", 930);
    freq.put("arv", 2193);
    freq.put("ary", 130);
    freq.put("ara", 2982);
    freq.put("arb", 519);
    freq.put("arc", 202);
    freq.put("ard", 1446);
    freq.put("are", 3776);
    freq.put("arf", 44);
    freq.put("arg", 455);
    freq.put("arh", 476);
    freq.put("ari", 5535);
    freq.put("arj", 940);
    freq.put("ark", 1022);
    freq.put("arl", 676);
    freq.put("arm", 512);
    freq.put("arn", 587);
    freq.put("aro", 486);
    freq.put("Ju\u0308", 111);
    freq.put("o\u0303sa", 163);
    freq.put("Jo\u0303", 269);
    freq.put("o\u0303st", 108);
    freq.put("Ja\u0308", 515);
    freq.put("uut", 1103);
    freq.put("uuv", 44);
    freq.put("hiu\u0308", 45);
    freq.put("uup", 59);
    freq.put("uus", 2149);
    freq.put("a\u030c", 46);
    freq.put("ar ", 2000);
    freq.put("uul", 3063);
    freq.put("uun", 1174);
    freq.put("uuk", 89);
    freq.put("s\u030ceh", 151);
    freq.put("uue", 262);
    freq.put("uud", 1301);
    freq.put("uug", 75);
    freq.put("uua", 104);
    freq.put("fga", 88);
    freq.put("uub", 214);
    freq.put(" Ps", 52);
    freq.put(" Pr", 1513);
    freq.put("c", 10761);
    freq.put(" Pu", 606);
    freq.put(" Pt", 76);
    freq.put(" Py", 57);
    freq.put(" Pa", 2281);
    freq.put(" Pe", 1250);
    freq.put("ø", 326);
    freq.put(" Pi", 1123);
    freq.put(" Ph", 212);
    freq.put(" Po", 1235);
    freq.put(" Pl", 283);
    freq.put("riu\u0308", 55);
    freq.put("swi", 78);
    freq.put("ps", 1178);
    freq.put("pp", 2089);
    freq.put("duk", 455);
    freq.put("dul", 361);
    freq.put("dum", 683);
    freq.put("dun", 212);
    freq.put("pu", 3682);
    freq.put("dua", 181);
    freq.put("px", 82);
    freq.put("py", 45);
    freq.put("dud", 1109);
    freq.put("ei ", 1558);
    freq.put("pa", 9082);
    freq.put("pf", 53);
    freq.put("pe", 8582);
    freq.put("Fan", 92);
    freq.put("dur", 309);
    freq.put("pi", 8736);
    freq.put("dut", 208);
    freq.put("duu", 64);
    freq.put("pl", 1823);
    freq.put("pm", 182);
    freq.put("Ema", 72);
    freq.put("Emm", 77);
    freq.put("\u0438\u0306 ", 637);
    freq.put("du ", 1711);
    freq.put("p ", 1639);
    freq.put("riz", 44);
    freq.put("riv", 668);
    freq.put("rit", 4861);
    freq.put("riu", 963);
    freq.put("rir", 293);
    freq.put("ris", 3546);
    freq.put("rip", 347);
    freq.put("rin", 3123);
    freq.put("Tim", 77);
    freq.put("ril", 3640);
    freq.put("rim", 2490);
    freq.put("rij", 404);
    freq.put("rik", 3181);
    freq.put("rih", 61);
    freq.put("rii", 5626);
    freq.put("rif", 87);
    freq.put("rig", 747);
    freq.put("rid", 1612);
    freq.put("rie", 633);
    freq.put("rib", 484);
    freq.put("ric", 609);
    freq.put("ria", 2118);
    freq.put("po\u0308", 275);
    freq.put("po\u0303", 3410);
    freq.put("pu\u0308", 734);
    freq.put("pa\u0308", 3196);
    freq.put("Va\u0308s", 46);
    freq.put("Cor", 172);
    freq.put("Cou", 57);
    freq.put("\u0438\u0306\u0441\u043a", 48);
    freq.put("Ill", 72);
    freq.put("Va\u0308i", 301);
    freq.put("Com", 152);
    freq.put("Va\u0308l", 103);
    freq.put("ri ", 5455);
    freq.put("Con", 247);
    freq.put("Nu", 172);
    freq.put("\u043d\u043a\u043e", 46);
    freq.put("\u044c", 570);
    freq.put("Air", 92);
    freq.put("\u0412\u0430\u0441", 49);
    freq.put("Ain", 50);
    freq.put("ljo", 186);
    freq.put("lja", 2809);
    freq.put("lje", 847);
    freq.put("yla\u0308", 47);
    freq.put("lju", 697);
    freq.put("Roh", 92);
    freq.put("Rom", 120);
    freq.put("Roo", 904);
    freq.put("Rob", 131);
    freq.put("Roc", 60);
    freq.put("ib ", 1767);
    freq.put("yle", 91);
    freq.put("ylo", 45);
    freq.put("Ros", 150);
    freq.put(" \u041f\u043e", 48);
    freq.put("la\u0308a\u0308", 1062);
    freq.put(" uu", 1024);
    freq.put(" \u041f\u0435", 79);
    freq.put(" \u041f\u0430", 47);
    freq.put(" us", 346);
    freq.put(" ul", 323);
    freq.put(" um", 867);
    freq.put(" un", 274);
    freq.put(" uj", 60);
    freq.put(" uk", 117);
    freq.put("ku\u0308n", 49);
    freq.put("\u0422", 143);
    freq.put("upp", 283);
    freq.put(" u ", 56);
    freq.put("ca ", 308);
    freq.put("a\u030a", 190);
    freq.put("ix ", 96);
    freq.put("kj", 201);
    freq.put("z", 3134);
    freq.put("la\u0308b", 569);
    freq.put("\u044c\u0435\u0432", 85);
    freq.put("la\u0308h", 1032);
    freq.put("la\u0308t", 92);
    freq.put("gru", 407);
    freq.put("gre", 257);
    freq.put("gra", 1940);
    freq.put("gro", 161);
    freq.put("epo\u0303", 75);
    freq.put("gri", 373);
    freq.put("la\u0308 ", 65);
    freq.put("ra\u0308a\u0308", 402);
    freq.put("nd ", 4383);
    freq.put("eda", 2449);
    freq.put("urt", 336);
    freq.put("Hai", 81);
    freq.put("edi", 900);
    freq.put("edo", 157);
    freq.put("edr", 231);
    freq.put("\u043a\u043e", 414);
    freq.put("oju", 137);
    freq.put("\u043a\u0438", 323);
    freq.put("edu", 707);
    freq.put("ugo", 56);
    freq.put("\u043a\u0430", 276);
    freq.put("\u1100\u1161\u1100\u1161 ", 46);
    freq.put("uga", 910);
    freq.put("ed ", 5646);
    freq.put("P", 11422);
    freq.put("\u0435\u043b\u044c", 84);
    freq.put("\u043a\u0441", 169);
    freq.put("iba", 199);
    freq.put("rro", 167);
    freq.put("rri", 784);
    freq.put("rre", 476);
    freq.put("rra", 2127);
    freq.put("\u0413", 287);
    freq.put("rry", 114);
    freq.put("ugr", 50);
    freq.put("rru", 164);
    freq.put("Uu", 347);
    freq.put("ugu", 2195);
    freq.put("hkr", 47);
    freq.put("hkv", 87);
    freq.put("rr ", 55);
    freq.put("hkl", 54);
    freq.put("hka", 48);
    freq.put("hke", 354);
    freq.put(" oo", 592);
    freq.put("apr", 632);
    freq.put("aps", 286);
    freq.put("app", 368);
    freq.put("Mik", 120);
    freq.put("apt", 144);
    freq.put("apu", 179);
    freq.put("aph", 50);
    freq.put("api", 685);
    freq.put("apn", 98);
    freq.put("apo", 517);
    freq.put("apl", 208);
    freq.put("apa", 845);
    freq.put(" ok", 758);
    freq.put("usg", 54);
    freq.put("usf", 104);
    freq.put("use", 12729);
    freq.put("usd", 49);
    freq.put("usc", 44);
    freq.put("usa", 1306);
    freq.put("fen", 116);
    freq.put("Hum", 47);
    freq.put("fel", 93);
    freq.put("\u062a", 46);
    freq.put("usk", 1361);
    freq.put("fek", 256);
    freq.put("usi", 2532);
    freq.put("ush", 270);
    freq.put("usv", 989);
    freq.put("usu", 604);
    freq.put("vuk", 112);
    freq.put("fer", 227);
    freq.put("fes", 255);
    freq.put("usp", 536);
    freq.put("ndi", 9574);
    freq.put("Gua", 87);
    freq.put("Gui", 119);
    freq.put("Gus", 86);
    freq.put("ap ", 65);
    freq.put("px ", 81);
    freq.put(" Ru", 426);
    freq.put("fe ", 58);
    freq.put("us ", 14520);
    freq.put(" Re", 978);
    freq.put(" Ra", 1755);
    freq.put(" Ro", 1766);
    freq.put(" Ri", 1126);
    freq.put(" Rh", 72);
    freq.put("tat", 7322);
    freq.put("tau", 131);
    freq.put("tav", 3721);
    freq.put("tap", 159);
    freq.put("tar", 1636);
    freq.put("tas", 2453);
    freq.put("apo\u0303", 81);
    freq.put("tad", 1273);
    freq.put("tae", 166);
    freq.put("taf", 74);
    freq.put("tag", 732);
    freq.put("taa", 2158);
    freq.put("tab", 1730);
    freq.put("tac", 49);
    freq.put("tal", 2877);
    freq.put("tam", 2975);
    freq.put("tan", 2647);
    freq.put("tao", 157);
    freq.put("tah", 420);
    freq.put("tai", 1177);
    freq.put("taj", 1586);
    freq.put("tak", 4223);
    freq.put("sis", 2918);
    freq.put("sir", 212);
    freq.put("sip", 251);
    freq.put("siv", 324);
    freq.put("siu", 225);
    freq.put("sit", 1318);
    freq.put("Mit", 88);
    freq.put("sic", 71);
    freq.put("sib", 74);
    freq.put("sia", 2206);
    freq.put("dwa", 83);
    freq.put("sig", 349);
    freq.put("sif", 138);
    freq.put("sie", 142);
    freq.put("sid", 2303);
    freq.put("sik", 2762);
    freq.put("sij", 144);
    freq.put("sii", 1362);
    freq.put("sih", 204);
    freq.put("sio", 5046);
    freq.put("sin", 1981);
    freq.put("sim", 1606);
    freq.put("sil", 1686);
    freq.put("ug ", 76);
    freq.put("ta ", 4265);
    freq.put("Eks", 56);
    freq.put(" Ro\u0303", 64);
    freq.put(" Ru\u0308", 62);
    freq.put("EE ", 44);
    freq.put(" Ra\u0308", 65);
    freq.put("si ", 5360);
    freq.put("usl", 1435);
    freq.put("su\u0308n", 4272);
    freq.put("su\u0308h", 336);
    freq.put("\u043d\u0441\u043a", 92);
    freq.put("o\u0308g", 138);
    freq.put("su\u0308d", 144);
    freq.put("cto", 118);
    freq.put("gh ", 77);
    freq.put("na ", 9461);
    freq.put("su\u0308g", 181);
    freq.put("Cas", 93);
    freq.put("Car", 284);
    freq.put("Cat", 48);
    freq.put("Can", 91);
    freq.put("Cam", 87);
    freq.put("Cal", 198);
    freq.put("Pre", 257);
    freq.put("nfe", 71);
    freq.put("Pra", 604);
    freq.put("nfo", 399);
    freq.put("Pro", 404);
    freq.put("nfl", 72);
    freq.put("Pri", 219);
    freq.put("nfi", 63);
    freq.put("by ", 122);
    freq.put("oui", 114);
    freq.put("oun", 169);
    freq.put("oul", 81);
    freq.put("oug", 79);
    freq.put("ous", 121);
    freq.put("our", 234);
    freq.put("oup", 53);
    freq.put("out", 116);
    freq.put("lt ", 7949);
    freq.put("\u041f\u0435\u0442", 51);
    freq.put("u\u0308dr", 236);
    freq.put("ou ", 125);
    freq.put("\u0411\u043e", 74);
    freq.put("u\u0308da", 146);
    freq.put("u\u0308di", 214);
    freq.put("u\u0308dn", 80);
    freq.put("lts", 498);
    freq.put("ltr", 71);
    freq.put("g", 77107);
    freq.put("vab", 718);
    freq.put("lta", 252);
    freq.put("lte", 588);
    freq.put("lti", 513);
    freq.put("lto", 103);
    freq.put("u\u0308", 30512);
    freq.put("K ", 351);
    freq.put("\u03bb", 130);
    freq.put("Ka", 3521);
    freq.put("Ke", 1467);
    freq.put("Ki", 1209);
    freq.put("Kh", 87);
    freq.put("Ko", 2411);
    freq.put("Kn", 47);
    freq.put("Kl", 321);
    freq.put("Kr", 1260);
    freq.put("Kv", 67);
    freq.put("Ku", 1642);
    freq.put("Ky", 76);
    freq.put("\u10dd", 50);
    freq.put("To\u0308o\u0308", 118);
    freq.put("Dig", 58);
    freq.put("hy", 186);
    freq.put("sem", 2170);
    freq.put("Foo", 47);
    freq.put("hr", 621);
    freq.put("Ka\u0308", 196);
    freq.put("hv", 2638);
    freq.put("hw", 103);
    freq.put("Ko\u0308", 81);
    freq.put("Ko\u0303", 416);
    freq.put("\u0437\u0430", 70);
    freq.put("hu", 4453);
    freq.put("Ku\u0308", 279);
    freq.put("Pot", 67);
    freq.put("Por", 187);
    freq.put("Pos", 114);
    freq.put("Poo", 305);
    freq.put("Pol", 248);
    freq.put("Pom", 45);
    freq.put("Poh", 46);
    freq.put("Kai", 254);
    freq.put("\u0410\u0431", 44);
    freq.put("Ru", 426);
    freq.put("\u0410\u043b", 161);
    freq.put("hm", 902);
    freq.put("\u043a ", 130);
    freq.put("\u0410\u043d", 87);
    freq.put("ha", 9696);
    freq.put("uak", 53);
    freq.put("eat", 919);
    freq.put("q ", 46);
    freq.put("he", 15992);
    freq.put("no ", 545);
    freq.put("qu", 338);
    freq.put("eu\u0308", 118);
    freq.put("Jal", 74);
    freq.put("Jam", 143);
    freq.put("z\u030c", 1084);
    freq.put("ebe", 121);
    freq.put("eba", 352);
    freq.put("ebl", 44);
    freq.put("ebo", 77);
    freq.put("ebi", 253);
    freq.put("ebu", 73);
    freq.put("ebr", 684);
    freq.put("ikv", 103);
    freq.put("dla", 684);
    freq.put("utl", 151);
    freq.put("dle", 97);
    freq.put("dli", 419);
    freq.put("Jac", 79);
    freq.put("dlu", 270);
    freq.put("jor", 223);
    freq.put("eb ", 2987);
    freq.put(" To\u0304", 50);
    freq.put("jok", 49);
    freq.put("jon", 315);
    freq.put("joo", 1404);
    freq.put("\u0430\u0440", 332);
    freq.put(" Ts\u030c", 404);
    freq.put("Moo", 103);
    freq.put("rpr", 48);
    freq.put("rpu", 103);
    freq.put("avo\u0303", 220);
    freq.put("avo\u0308", 76);
    freq.put("rpa", 108);
    freq.put("rpe", 48);
    freq.put("po\u0303o\u0303", 56);
    freq.put("ava\u0308", 555);
    freq.put("hm ", 244);
    freq.put("rpo", 141);
    freq.put("Jug", 45);
    freq.put("Juh", 63);
    freq.put("\u0442\u043e\u0440", 53);
    freq.put("Jul", 218);
    freq.put("\u0430\u044f", 206);
    freq.put("Jur", 60);
    freq.put("Juu", 106);
    freq.put("\u03bf", 232);
    freq.put("hmi", 96);
    freq.put("hme", 82);
    freq.put("hma", 426);
    freq.put(" Tu\u0308", 235);
    freq.put("e\u0301", 703);
    freq.put(" To\u0308", 129);
    freq.put(" To\u0303", 184);
    freq.put("DV ", 45);
    freq.put(" Ta\u0308", 312);
    freq.put("tja", 582);
    freq.put("avy", 49);
    freq.put("\u5009", 51);
    freq.put("avu", 364);
    freq.put("avs", 163);
    freq.put("avl", 84);
    freq.put("e\u0304", 125);
    freq.put("avo", 221);
    freq.put("avi", 977);
    freq.put("ave", 501);
    freq.put("ava", 6484);
    freq.put(" T ", 66);
    freq.put("tod", 315);
    freq.put("utz", 51);
    freq.put("av ", 2085);
    freq.put(" Ty", 76);
    freq.put(" Tv", 68);
    freq.put(" Tu", 679);
    freq.put(" Ts", 168);
    freq.put(" Tr", 722);
    freq.put(" To", 951);
    freq.put(" Ti", 535);
    freq.put(" Th", 744);
    freq.put(" Te", 1863);
    freq.put(" Ta", 4345);
    freq.put("tch", 74);
    freq.put("nov", 777);
    freq.put("sku", 1933);
    freq.put("skv", 335);
    freq.put("skp", 86);
    freq.put("sks", 70);
    freq.put("skr", 240);
    freq.put("ske", 1189);
    freq.put("Fai", 50);
    freq.put("ska", 1203);
    freq.put("Fal", 44);
    freq.put("skm", 251);
    freq.put("skl", 222);
    freq.put("sko", 1611);
    freq.put("skn", 98);
    freq.put("ski", 1330);
    freq.put("skk", 688);
    freq.put("skj", 46);
    freq.put("T", 11888);
    freq.put("sk ", 538);
    freq.put("Sud", 52);
    freq.put("Sun", 86);
    freq.put("Sul", 92);
    freq.put("Suu", 805);
    freq.put("Sur", 85);
    freq.put("Sup", 46);
    freq.put("sko\u0303", 91);
    freq.put("sku\u0308", 66);
    freq.put("ska\u0308", 80);
    freq.put("Pto", 68);
    freq.put("ndk", 76);
    freq.put("ndj", 199);
    freq.put("ndm", 736);
    freq.put("ndl", 703);
    freq.put("ndo", 567);
    freq.put("ndn", 73);
    freq.put("nda", 5981);
    freq.put("nde", 2285);
    freq.put("nds", 245);
    freq.put("ndr", 1767);
    freq.put("ndu", 3781);
    freq.put("ndt", 47);
    freq.put("ndv", 49);
    freq.put("su\u0308l", 70);
    freq.put("su\u0308m", 231);
    freq.put("o\u0308b", 82);
    freq.put("own", 56);
    freq.put("o\u0308d", 707);
    freq.put("o\u0308e", 80);
    freq.put("Ro\u0303", 64);
    freq.put("owe", 70);
    freq.put("o\u0308i", 89);
    freq.put("o\u0308k", 454);
    freq.put("o\u0308l", 253);
    freq.put("o\u0308m", 99);
    freq.put("o\u0308n", 372);
    freq.put("o\u0308p", 203);
    freq.put("o\u0308r", 689);
    freq.put("o\u0308s", 334);
    freq.put("o\u0308t", 705);
    freq.put("o\u0308v", 135);
    freq.put("su\u0308t", 71);
    freq.put("ows", 73);
    freq.put("su\u0308s", 1324);
    freq.put("vaj", 399);
    freq.put("vak", 669);
    freq.put("vah", 2967);
    freq.put("vai", 1190);
    freq.put("van", 2026);
    freq.put("val", 8945);
    freq.put("vam", 407);
    freq.put("Ama", 69);
    freq.put("Amb", 81);
    freq.put("Ame", 1051);
    freq.put("vag", 98);
    freq.put("vad", 3860);
    freq.put("vae", 151);
    freq.put("ee", 30805);
    freq.put("lv ", 77);
    freq.put("var", 1747);
    freq.put("vas", 3460);
    freq.put("vap", 226);
    freq.put("vav", 166);
    freq.put("vat", 2727);
    freq.put("o\u0308 ", 312);
    freq.put("ef", 1060);
    freq.put("uct", 46);
    freq.put("ow ", 114);
    freq.put("Teh", 108);
    freq.put("Tei", 326);
    freq.put("Tel", 114);
    freq.put("Tem", 174);
    freq.put("Ten", 61);
    freq.put("Teo", 71);
    freq.put("Tea", 178);
    freq.put("va ", 3296);
    freq.put("\u044b\u0438\u0306 ", 88);
    freq.put("Ted", 50);
    freq.put("Tee", 206);
    freq.put("Teg", 101);
    freq.put("lve", 678);
    freq.put("lva", 713);
    freq.put("Ter", 274);
    freq.put("Tes", 65);
    freq.put("lvi", 208);
    freq.put("lvk", 62);
    freq.put("ro\u0303h", 178);
    freq.put("su\u0308u\u0308", 243);
    freq.put("lm ", 614);
    freq.put("o\u0308o\u0308", 3301);
    freq.put("i\u0301 ", 51);
    freq.put("\u043d", 2533);
    freq.put("\u0441\u0438\u043b", 46);
    freq.put("my ", 109);
    freq.put("i\u0301a", 57);
    freq.put("i\u0301n", 74);
    freq.put("aaf", 943);
    freq.put("oel", 103);
    freq.put("ndz\u030c", 60);
  }
  
}

