package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ES extends CLangProfile {
  private static final String name = "es";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ES() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 70286890;
    n_words[1] = 82926999;
    n_words[2] = 60413548;

    freq.put("sco", 24677);
    freq.put("pti", 14042);
    freq.put("aun", 7152);
    freq.put("e\u0301ri", 13573);
    freq.put("aus", 7903);
    freq.put("aur", 9494);
    freq.put("aut", 18769);
    freq.put("ti\u0301n", 7356);
    freq.put(" Gu", 21689);
    freq.put(" Gr", 21740);
    freq.put(" Ge", 16178);
    freq.put(" Ga", 21582);
    freq.put(" Go", 14559);
    freq.put(" Gi", 8540);
    freq.put("gle\u0301", 12339);
    freq.put("Gu", 21771);
    freq.put("Gr", 21868);
    freq.put("upe", 15682);
    freq.put("Ge", 16269);
    freq.put("Ga", 21659);
    freq.put("Go", 14614);
    freq.put("Gi", 8606);
    freq.put("me ", 12825);
    freq.put(" km", 14107);
    freq.put("Ce", 15444);
    freq.put("nen", 11810);
    freq.put("neo", 11720);
    freq.put(" y ", 406137);
    freq.put("nec", 28654);
    freq.put("nea", 12399);
    freq.put("nez", 7381);
    freq.put("net", 8127);
    freq.put("scr", 25119);
    freq.put("ner", 65372);
    freq.put("nes", 80792);
    freq.put("dep", 50829);
    freq.put("orr", 19323);
    freq.put("men", 167009);
    freq.put("met", 16848);
    freq.put("mes", 19527);
    freq.put("mer", 60276);
    freq.put("i\u0301cu", 14416);
    freq.put("mex", 7078);
    freq.put("di\u0301a", 18502);
    freq.put("glo", 15485);
    freq.put("gla", 7868);
    freq.put("k", 118503);
    freq.put("gle", 10695);
    freq.put("ne ", 57285);
    freq.put("dri", 13291);
    freq.put("o\u0301lo", 7805);
    freq.put("dro", 9953);
    freq.put("dra", 9547);
    freq.put("dre", 11310);
    freq.put("bro", 15368);
    freq.put("bri", 27454);
    freq.put("bre", 105758);
    freq.put("bra", 26651);
    freq.put("m ", 52750);
    freq.put("er ", 98611);
    freq.put("io\u0301 ", 27428);
    freq.put("ni ", 7789);
    freq.put("e\u0301rm", 8428);
    freq.put("A\u0301", 8848);
    freq.put("V", 93781);
    freq.put("me", 329898);
    freq.put("erv", 17764);
    freq.put("ma", 323604);
    freq.put("ltu", 9464);
    freq.put("err", 53481);
    freq.put("mb", 142619);
    freq.put("mm", 8572);
    freq.put("mo", 207044);
    freq.put("mi", 236057);
    freq.put("mu", 126184);
    freq.put("ere", 38036);
    freq.put("erf", 9607);
    freq.put("erg", 11010);
    freq.put("era", 127455);
    freq.put("erb", 7502);
    freq.put("erc", 31567);
    freq.put("erm", 26731);
    freq.put("ern", 44545);
    freq.put("ero", 107826);
    freq.put("eri", 85302);
    freq.put("si\u0301 ", 7618);
    freq.put("Le", 25199);
    freq.put("La", 111930);
    freq.put("Lo", 44117);
    freq.put("o\u0301gi", 7057);
    freq.put("uar", 13380);
    freq.put("la ", 610751);
    freq.put("uat", 7912);
    freq.put("Li", 24708);
    freq.put("Lu", 14073);
    freq.put("ual", 41530);
    freq.put("uan", 21270);
    freq.put("uad", 38503);
    freq.put("ena", 41586);
    freq.put("enc", 77537);
    freq.put("end", 51128);
    freq.put("ene", 94564);
    freq.put("eng", 10179);
    freq.put("eni", 23612);
    freq.put("hom", 8228);
    freq.put("eno", 37094);
    freq.put("ens", 46652);
    freq.put("ent", 408861);
    freq.put("hos", 7240);
    freq.put("en\u0303o", 12432);
    freq.put("m2", 9191);
    freq.put("en\u0303a", 13429);
    freq.put("enz", 9528);
    freq.put("A", 269964);
    freq.put("lam", 24610);
    freq.put("lan", 69592);
    freq.put("lad", 24486);
    freq.put("lag", 7484);
    freq.put("lab", 11220);
    freq.put("lac", 64631);
    freq.put("II ", 12947);
    freq.put("ove", 16922);
    freq.put("lat", 24612);
    freq.put("ua ", 14731);
    freq.put("ovi", 57483);
    freq.put("lti", 12566);
    freq.put("lar", 41436);
    freq.put("las", 124120);
    freq.put("en ", 609899);
    freq.put("ma\u0301", 63634);
    freq.put("ho ", 17368);
    freq.put("mi\u0301", 7526);
    freq.put("Ale", 9873);
    freq.put("me\u0301", 17124);
    freq.put("mo\u0301", 11660);
    freq.put("eri\u0301", 14511);
    freq.put("Alt", 8713);
    freq.put("mu\u0301", 13777);
    freq.put("gu\u0301n", 7107);
    freq.put(" Hu", 9382);
    freq.put(" Hi", 11833);
    freq.put("oni", 32298);
    freq.put(" Ho", 12969);
    freq.put(" Ha", 19064);
    freq.put(" He", 16181);
    freq.put("ima", 28669);
    freq.put("ime", 39882);
    freq.put("dur", 19421);
    freq.put("ro\u0301", 22130);
    freq.put("imi", 27512);
    freq.put("cla", 14341);
    freq.put("imo", 21293);
    freq.put("imp", 19247);
    freq.put("ra\u0301", 28876);
    freq.put("ri\u0301", 60498);
    freq.put("fin", 19583);
    freq.put("re\u0301", 8377);
    freq.put("fil", 9492);
    freq.put(" Va", 20787);
    freq.put(" Ve", 16562);
    freq.put("upo", 17158);
    freq.put(" Vi", 28257);
    freq.put("nto\u0301", 37020);
    freq.put("zac", 11303);
    freq.put("one", 74442);
    freq.put("l", 3848407);
    freq.put("e\u0301ne", 20764);
    freq.put("nt ", 24387);
    freq.put("rt", 263306);
    freq.put("ru", 82530);
    freq.put("rv", 23971);
    freq.put("gon", 9593);
    freq.put("rp", 16192);
    freq.put("rq", 18301);
    freq.put("rr", 132506);
    freq.put("rs", 76964);
    freq.put("zar", 10021);
    freq.put("ry", 14114);
    freq.put("rz", 18465);
    freq.put("gob", 7093);
    freq.put("rd", 86475);
    freq.put("re", 689451);
    freq.put("rf", 13796);
    freq.put("rg", 83834);
    freq.put("ra", 734384);
    freq.put("rb", 27212);
    freq.put("ajo", 16624);
    freq.put("rl", 28428);
    freq.put("aja", 11561);
    freq.put("rn", 71986);
    freq.put("is ", 44742);
    freq.put("aje", 17588);
    freq.put("gos", 23034);
    freq.put("rk", 11610);
    freq.put("ntr", 93850);
    freq.put("ntu", 7064);
    freq.put("nti", 67583);
    freq.put("W", 35590);
    freq.put("nta", 102723);
    freq.put("nte", 292971);
    freq.put("ate", 31650);
    freq.put("ata", 37974);
    freq.put("ato", 31490);
    freq.put("isp", 12009);
    freq.put("go ", 53446);
    freq.put("Vil", 8238);
    freq.put("ist", 177840);
    freq.put("isi", 29089);
    freq.put("atu", 16694);
    freq.put("atr", 18116);
    freq.put("ism", 26830);
    freq.put("isl", 10534);
    freq.put("isc", 18799);
    freq.put("ise", 10419);
    freq.put("osa", 21383);
    freq.put("nis", 28903);
    freq.put("tem", 32370);
    freq.put("xic", 17547);
    freq.put("tor", 94895);
    freq.put("Cen", 8021);
    freq.put("equ", 18716);
    freq.put("xim", 7461);
    freq.put("ton", 20463);
    freq.put("Se ", 18407);
    freq.put("tod", 17241);
    freq.put(" le", 29852);
    freq.put("B", 167407);
    freq.put(" la", 626496);
    freq.put(" lo", 186366);
    freq.put(" ll", 24228);
    freq.put(" li", 28752);
    freq.put(" lu", 16286);
    freq.put("Fue", 18788);
    freq.put("i\u0301", 298098);
    freq.put("nza", 20160);
    freq.put("to ", 261732);
    freq.put("raf", 7329);
    freq.put("rag", 12449);
    freq.put("rad", 60032);
    freq.put("rab", 19532);
    freq.put("rac", 43442);
    freq.put("ran", 146320);
    freq.put("ral", 52901);
    freq.put("ram", 21212);
    freq.put("ose", 15508);
    freq.put("rav", 8075);
    freq.put("rat", 31492);
    freq.put("rar", 15085);
    freq.put("ras", 50104);
    freq.put("do ", 341916);
    freq.put("on ", 190943);
    freq.put("Qu", 8096);
    freq.put("ra ", 231606);
    freq.put(" li\u0301", 9079);
    freq.put("y", 639511);
    freq.put("sub", 9390);
    freq.put("don", 18997);
    freq.put("doc", 7141);
    freq.put("m", 1698678);
    freq.put("uda", 37565);
    freq.put("dor", 54124);
    freq.put("dos", 96466);
    freq.put("dou", 11963);
    freq.put("e\u0301x", 11216);
    freq.put(" Wa", 8349);
    freq.put("e\u0301s", 52145);
    freq.put("e\u0301r", 34634);
    freq.put("e\u0301t", 12035);
    freq.put("d ", 184141);
    freq.put(" Wi", 9336);
    freq.put("e\u0301l", 11392);
    freq.put("e\u0301n", 55163);
    freq.put("e\u0301c", 11450);
    freq.put("oci", 56829);
    freq.put("och", 8312);
    freq.put("ock", 8945);
    freq.put("uen", 38522);
    freq.put("oco", 9047);
    freq.put("oca", 41229);
    freq.put("oce", 17267);
    freq.put("ba ", 19878);
    freq.put("ocu", 9100);
    freq.put("oct", 12604);
    freq.put("do", 556174);
    freq.put("dm", 7851);
    freq.put("di", 323631);
    freq.put("de", 2140534);
    freq.put("da", 466302);
    freq.put("e\u0301 ", 16494);
    freq.put("du", 66523);
    freq.put("dr", 51266);
    freq.put("eme", 18576);
    freq.put("bar", 17411);
    freq.put("bas", 16282);
    freq.put("emb", 41784);
    freq.put("emo", 14924);
    freq.put("emi", 17348);
    freq.put("emp", 34242);
    freq.put("ban", 26993);
    freq.put("bal", 10177);
    freq.put("baj", 17768);
    freq.put("w ", 7730);
    freq.put("Per", 15205);
    freq.put("nue", 9759);
    freq.put("il ", 29082);
    freq.put("i\u0301st", 9984);
    freq.put("un ", 217532);
    freq.put("iri", 18435);
    freq.put("ira", 17066);
    freq.put("mun", 83842);
    freq.put("ire", 21390);
    freq.put("omb", 45255);
    freq.put("C", 324676);
    freq.put("di\u0301", 25020);
    freq.put("wa", 13090);
    freq.put("de\u0301", 12258);
    freq.put("omi", 25678);
    freq.put(" Is", 11343);
    freq.put("omo", 82407);
    freq.put("omp", 41070);
    freq.put(" In", 34554);
    freq.put("elo", 21079);
    freq.put("cos", 36158);
    freq.put("ile", 24670);
    freq.put("ema\u0301", 15175);
    freq.put("ell", 40806);
    freq.put("ila", 17117);
    freq.put("ilo", 12791);
    freq.put("ill", 61746);
    freq.put("ili", 73439);
    freq.put("una", 267868);
    freq.put("unc", 10467);
    freq.put("und", 48857);
    freq.put("une", 8988);
    freq.put("ueg", 19032);
    freq.put("ir ", 23370);
    freq.put("uni", 64830);
    freq.put("com", 184452);
    freq.put("col", 25189);
    freq.put("con", 251381);
    freq.put(" me", 61144);
    freq.put("ela", 41071);
    freq.put(" ma", 85649);
    freq.put("o\u0301n ", 361830);
    freq.put("io\u0301", 324878);
    freq.put(" mo", 34821);
    freq.put(" mi", 48266);
    freq.put("ie\u0301", 32355);
    freq.put(" mu", 56375);
    freq.put("san", 10863);
    freq.put("fra", 50839);
    freq.put("che", 19885);
    freq.put("fre", 13616);
    freq.put("fri", 7302);
    freq.put("C ", 12178);
    freq.put("pro", 108338);
    freq.put("i\u0301as", 8590);
    freq.put("a\u0301lb", 11283);
    freq.put("o\u0301ni", 12420);
    freq.put("Ci", 15164);
    freq.put("Ch", 44811);
    freq.put("epu\u0301", 7797);
    freq.put("Cl", 11053);
    freq.put("Ca", 88236);
    freq.put("ais", 7210);
    freq.put("n", 5177793);
    freq.put("ain", 19507);
    freq.put("Cr", 14045);
    freq.put("gni", 7865);
    freq.put("sla", 17876);
    freq.put("Cu", 13670);
    freq.put("Nac", 11329);
    freq.put("iz", 77284);
    freq.put(" ma\u0301", 36795);
    freq.put("ip", 90246);
    freq.put("is", 363824);
    freq.put("ir", 119098);
    freq.put("iu", 42028);
    freq.put("it", 317793);
    freq.put("iv", 114899);
    freq.put("ik", 8874);
    freq.put("ij", 12968);
    freq.put("im", 150543);
    freq.put("il", 242265);
    freq.put("io", 362002);
    freq.put("in", 518205);
    freq.put("ia", 458387);
    freq.put("ic", 527484);
    freq.put("ib", 58759);
    freq.put("ie", 349344);
    freq.put("id", 350652);
    freq.put("ig", 130847);
    freq.put("if", 53944);
    freq.put("V ", 8314);
    freq.put("th ", 7178);
    freq.put("nio", 20490);
    freq.put("nim", 13518);
    freq.put("VI", 7056);
    freq.put("nia", 31660);
    freq.put("nif", 10693);
    freq.put("nid", 51044);
    freq.put("nie", 9958);
    freq.put("niz", 14512);
    freq.put("Y", 15953);
    freq.put("i ", 67723);
    freq.put("niv", 15892);
    freq.put("nit", 8537);
    freq.put("mil", 54218);
    freq.put("Va", 20820);
    freq.put("Ve", 16615);
    freq.put("Vi", 28361);
    freq.put("ept", 16454);
    freq.put("epr", 9962);
    freq.put("epo", 8010);
    freq.put("the", 10645);
    freq.put("epe", 9088);
    freq.put("epa", 47324);
    freq.put("oli\u0301", 19344);
    freq.put("eli", 19783);
    freq.put("ham", 8200);
    freq.put("han", 11281);
    freq.put("hab", 28769);
    freq.put("hac", 13453);
    freq.put("Gar", 7699);
    freq.put("ele", 43829);
    freq.put("har", 13249);
    freq.put("has", 16766);
    freq.put("opu", 9913);
    freq.put("rni", 8562);
    freq.put("rno", 13811);
    freq.put("D", 116547);
    freq.put("rna", 28042);
    freq.put("rne", 12661);
    freq.put("ope", 13312);
    freq.put("opa", 10564);
    freq.put("opo", 9237);
    freq.put("opi", 14838);
    freq.put("ha ", 23020);
    freq.put("el ", 611266);
    freq.put("Arg", 10516);
    freq.put("ola", 30987);
    freq.put("ole", 17479);
    freq.put(" Ju", 22012);
    freq.put("oli", 25682);
    freq.put("oll", 17825);
    freq.put("olo", 38775);
    freq.put(" Jo", 22025);
    freq.put("olu", 11781);
    freq.put(" Je", 8808);
    freq.put(" Ja", 18701);
    freq.put("ici", 106469);
    freq.put("ich", 18974);
    freq.put("ico", 124072);
    freq.put("for", 59914);
    freq.put("eli\u0301", 11498);
    freq.put("ica", 217183);
    freq.put("ice", 11245);
    freq.put("Hu", 9391);
    freq.put("ume", 13099);
    freq.put("Hi", 11870);
    freq.put("uma", 10015);
    freq.put("Ho", 13033);
    freq.put("Ha", 19115);
    freq.put("ict", 9719);
    freq.put("ol ", 38964);
    freq.put("ple", 15398);
    freq.put("pla", 29458);
    freq.put("plo", 9048);
    freq.put("pli", 11132);
    freq.put("obl", 50514);
    freq.put("obi", 12794);
    freq.put("ic ", 7674);
    freq.put("o", 5444424);
    freq.put("oba", 8003);
    freq.put("um ", 20862);
    freq.put("obr", 25648);
    freq.put("soc", 12868);
    freq.put("sob", 16402);
    freq.put("mbi", 42599);
    freq.put("sol", 12812);
    freq.put("son", 47400);
    freq.put("sos", 12831);
    freq.put("sor", 10955);
    freq.put("Fer", 7120);
    freq.put("mbr", 71287);
    freq.put("ne\u0301", 9922);
    freq.put("ni\u0301", 12258);
    freq.put("na\u0301", 7351);
    freq.put("nu\u0301", 7450);
    freq.put("gid", 10945);
    freq.put("gic", 10164);
    freq.put("gio", 12026);
    freq.put("gin", 15815);
    freq.put("no\u0301", 12071);
    freq.put("so ", 44831);
    freq.put("a\u0301n ", 27367);
    freq.put("Z", 15636);
    freq.put("ura", 67622);
    freq.put("aza", 10801);
    freq.put("n\u0303os", 18182);
    freq.put("nne", 10554);
    freq.put(" Li", 24432);
    freq.put("n\u0303ol", 28121);
    freq.put("ni", 309689);
    freq.put("nj", 11352);
    freq.put("nk", 8262);
    freq.put("gio\u0301", 54574);
    freq.put("nm", 8232);
    freq.put("nn", 24107);
    freq.put("no", 368063);
    freq.put("tit", 18235);
    freq.put("na", 683565);
    freq.put("tiv", 46603);
    freq.put("nc", 291584);
    freq.put("nd", 277346);
    freq.put("ne", 311456);
    freq.put("nf", 32397);
    freq.put("ng", 105777);
    freq.put("til", 28629);
    freq.put("ny", 8769);
    freq.put("nz", 31492);
    freq.put("tio", 15498);
    freq.put("tid", 24642);
    freq.put("nq", 11336);
    freq.put("ns", 140899);
    freq.put("nt", 779819);
    freq.put("nu", 35537);
    freq.put("nv", 18820);
    freq.put("tic", 87300);
    freq.put(" ni", 9094);
    freq.put("E", 296654);
    freq.put(" no", 85354);
    freq.put(" na", 40693);
    freq.put(" ne", 10791);
    freq.put("n\u0303o ", 26522);
    freq.put(" nu", 10795);
    freq.put("n ", 1645057);
    freq.put("rol", 20667);
    freq.put("rom", 15707);
    freq.put("ron", 42744);
    freq.put("roc", 21679);
    freq.put("rod", 21257);
    freq.put("ost", 31662);
    freq.put("rof", 11386);
    freq.put("rog", 9763);
    freq.put("osi", 18739);
    freq.put("Me\u0301x", 8860);
    freq.put("lli", 13816);
    freq.put("llo", 31751);
    freq.put("oso", 14720);
    freq.put("rop", 32071);
    freq.put("lla", 74669);
    freq.put("ros", 47929);
    freq.put("rot", 15483);
    freq.put("rov", 41024);
    freq.put("ver", 42481);
    freq.put("ves", 9401);
    freq.put("ven", 28441);
    freq.put("vel", 14981);
    freq.put("o\u0301 ", 71778);
    freq.put("ert", 62557);
    freq.put("ro ", 146408);
    freq.put("Me\u0301", 10810);
    freq.put("erp", 8929);
    freq.put("ll ", 10675);
    freq.put("gua", 27766);
    freq.put("dio", 35658);
    freq.put("gue", 27456);
    freq.put("did", 11186);
    freq.put("o\u0301r", 13833);
    freq.put("gui", 14307);
    freq.put("ers", 52410);
    freq.put("gun", 20675);
    freq.put("dic", 47817);
    freq.put("p", 1539196);
    freq.put("o\u0301n", 382883);
    freq.put("o\u0301m", 11589);
    freq.put("o\u0301l", 14360);
    freq.put("dit", 9088);
    freq.put("div", 13995);
    freq.put("He", 16228);
    freq.put("o\u0301g", 11484);
    freq.put("der", 49978);
    freq.put("dir", 18800);
    freq.put("o\u0301d", 8472);
    freq.put("Rep", 8544);
    freq.put("Gra", 11989);
    freq.put("erd", 14302);
    freq.put("u\u0301tb", 7936);
    freq.put("oes", 12161);
    freq.put("bo ", 7079);
    freq.put("ge\u0301n", 19973);
    freq.put("mp", 132049);
    freq.put("Me", 30598);
    freq.put("Ma", 85855);
    freq.put("io\u0301n", 292845);
    freq.put("Mo", 36242);
    freq.put("deo", 9414);
    freq.put("Mi", 26023);
    freq.put("Mu", 18246);
    freq.put("deb", 8351);
    freq.put("bor", 11023);
    freq.put("bol", 20729);
    freq.put("ipa", 22022);
    freq.put("ipi", 23278);
    freq.put("ipo", 17187);
    freq.put("ayo", 25160);
    freq.put(" Ka", 8187);
    freq.put("ngu", 15031);
    freq.put("aya", 7832);
    freq.put("te\u0301r", 8916);
    freq.put("ca ", 145181);
    freq.put("Mon", 15534);
    freq.put("F", 128129);
    freq.put("u\u0301bl", 12344);
    freq.put("mba", 10176);
    freq.put("Ber", 7187);
    freq.put("ibi", 8164);
    freq.put("ibl", 8505);
    freq.put("cas", 41067);
    freq.put("car", 45351);
    freq.put("cap", 14546);
    freq.put("ay ", 13782);
    freq.put("ult", 21405);
    freq.put("cat", 14539);
    freq.put("n\u0303", 141698);
    freq.put("se\u0301", 9023);
    freq.put("uli", 17880);
    freq.put("can", 94395);
    freq.put("cam", 20670);
    freq.put("cal", 48767);
    freq.put("cac", 16670);
    freq.put("cab", 10529);
    freq.put("ibr", 11003);
    freq.put("ula", 47246);
    freq.put("ibu", 11957);
    freq.put("cad", 51771);
    freq.put("obe", 8533);
    freq.put(" pr", 177892);
    freq.put(" of", 15543);
    freq.put(" ob", 20507);
    freq.put(" oc", 24698);
    freq.put("ma ", 72422);
    freq.put("spo", 14448);
    freq.put("spa", 61850);
    freq.put(" ot", 17424);
    freq.put("i\u0301o ", 10995);
    freq.put(" or", 52385);
    freq.put("spe", 51710);
    freq.put("s ", 1974557);
    freq.put("mas", 23691);
    freq.put("mar", 42452);
    freq.put("din", 11969);
    freq.put("may", 20759);
    freq.put("rm", 118903);
    freq.put("use", 7793);
    freq.put(" o ", 71023);
    freq.put("mac", 13622);
    freq.put("mad", 34215);
    freq.put("mal", 12192);
    freq.put("man", 63359);
    freq.put("ss", 27514);
    freq.put("sp", 146933);
    freq.put("su", 163099);
    freq.put("st", 570360);
    freq.put("q", 288923);
    freq.put("si", 316726);
    freq.put("sh", 16915);
    freq.put("so", 177522);
    freq.put("sm", 35452);
    freq.put("sl", 23077);
    freq.put("sc", 98040);
    freq.put("sa", 193871);
    freq.put("se", 328771);
    freq.put("sd", 21641);
    freq.put("Ru", 9143);
    freq.put("li\u0301n", 8248);
    freq.put("Chi", 15815);
    freq.put("no ", 158177);
    freq.put("Re", 46909);
    freq.put("Ra", 15098);
    freq.put("Ro", 31238);
    freq.put("en\u0303", 26834);
    freq.put("Ri", 14206);
    freq.put("eo\u0301", 10608);
    freq.put(" ab", 21502);
    freq.put(" ac", 45971);
    freq.put(" ad", 18011);
    freq.put("flo", 7804);
    freq.put(" ag", 19771);
    freq.put(" al", 116261);
    freq.put(" am", 14490);
    freq.put(" an", 45970);
    freq.put(" ap", 24125);
    freq.put(" ar", 40593);
    freq.put(" as", 24315);
    freq.put(" at", 8359);
    freq.put(" au", 26320);
    freq.put("hor", 7815);
    freq.put("nom", 49236);
    freq.put("noc", 38585);
    freq.put("ori\u0301", 9114);
    freq.put("ng ", 18654);
    freq.put("nov", 19327);
    freq.put("nor", 29422);
    freq.put("nos", 42446);
    freq.put(" a ", 151113);
    freq.put("em", 183658);
    freq.put("el", 821140);
    freq.put("eo", 63152);
    freq.put("en", 1446857);
    freq.put("ei", 38528);
    freq.put("ej", 32037);
    freq.put("ee", 18956);
    freq.put("ed", 147913);
    freq.put("eg", 169863);
    freq.put("ef", 34480);
    freq.put("ea", 126973);
    freq.put("ec", 261065);
    freq.put("eb", 49402);
    freq.put("ey", 26516);
    freq.put("ex", 62245);
    freq.put("ez", 45865);
    freq.put("eu", 25398);
    freq.put("et", 133793);
    freq.put("ev", 65967);
    freq.put("eq", 18834);
    freq.put("ep", 114508);
    freq.put("es", 1262459);
    freq.put("er", 848036);
    freq.put("Jos", 9116);
    freq.put("eje", 7469);
    freq.put("eja", 7548);
    freq.put(" an\u0303", 28328);
    freq.put("blo", 8255);
    freq.put("bli", 27042);
    freq.put("dif", 14152);
    freq.put("ble", 28350);
    freq.put("bla", 52392);
    freq.put("nic", 69869);
    freq.put("a\u0301ni", 16413);
    freq.put("G", 121338);
    freq.put("ort", 65622);
    freq.put("rla", 8699);
    freq.put("e ", 2816707);
    freq.put("orn", 13575);
    freq.put("oro", 14041);
    freq.put("orm", 64912);
    freq.put("ori", 66357);
    freq.put("org", 21075);
    freq.put("ord", 30127);
    freq.put("ore", 48358);
    freq.put("lme", 34946);
    freq.put("ora", 46259);
    freq.put("onj", 7098);
    freq.put("ri\u0301s", 7245);
    freq.put("xi", 40771);
    freq.put("ono", 52521);
    freq.put("onc", 23216);
    freq.put("zad", 34608);
    freq.put("ona", 104550);
    freq.put("onf", 9258);
    freq.put("ong", 11339);
    freq.put("ond", 38242);
    freq.put("dia", 35235);
    freq.put("ri\u0301a", 28707);
    freq.put("ons", 50424);
    freq.put("xp", 12413);
    freq.put("onv", 7285);
    freq.put("ri\u0301o", 10310);
    freq.put("xt", 20556);
    freq.put("Eur", 9266);
    freq.put("iam", 7087);
    freq.put("ial", 56085);
    freq.put("ian", 52472);
    freq.put("iad", 14476);
    freq.put("iac", 10109);
    freq.put("ias", 29422);
    freq.put("iar", 10235);
    freq.put("ma\u0301s", 38263);
    freq.put("ma\u0301t", 8971);
    freq.put("hum", 8623);
    freq.put("x ", 22885);
    freq.put("za ", 34624);
    freq.put("ma\u0301n", 10709);
    freq.put("rzo", 11621);
    freq.put("ia ", 260890);
    freq.put("r", 4307485);
    freq.put(" ge\u0301", 18729);
    freq.put("and", 90623);
    freq.put("ane", 17755);
    freq.put("ang", 19562);
    freq.put("ana", 70957);
    freq.put("anc", 101262);
    freq.put("ann", 7583);
    freq.put("ano", 79509);
    freq.put("pri", 52537);
    freq.put("ani", 47254);
    freq.put("sad", 15576);
    freq.put("ant", 195066);
    freq.put("anu", 10190);
    freq.put("ry ", 9879);
    freq.put("ans", 17426);
    freq.put("sas", 11791);
    freq.put("sar", 21220);
    freq.put("i\u0301ne", 7430);
    freq.put("anz", 18126);
    freq.put("Do", 14187);
    freq.put("rmi", 20846);
    freq.put("Di", 25181);
    freq.put("De", 29603);
    freq.put(" a\u0301l", 11624);
    freq.put("zon", 9132);
    freq.put("Da", 13474);
    freq.put(" a\u0301r", 9835);
    freq.put("2", 9268);
    freq.put("Du", 7509);
    freq.put("an ", 104955);
    freq.put("sa ", 86942);
    freq.put("uye", 9933);
    freq.put("i\u0301n ", 16078);
    freq.put("zo ", 17792);
    freq.put(" Le", 25083);
    freq.put(" La", 111649);
    freq.put(" Lo", 44008);
    freq.put("D ", 7805);
    freq.put(" Lu", 14044);
    freq.put("ge ", 11010);
    freq.put("ses", 15571);
    freq.put("Wa", 8415);
    freq.put("iti", 14600);
    freq.put("Wi", 9415);
    freq.put("ger", 8119);
    freq.put(" pu", 38713);
    freq.put("H", 81475);
    freq.put("li\u0301t", 16259);
    freq.put(" pa", 137566);
    freq.put(" pe", 108853);
    freq.put(" pi", 19178);
    freq.put("li\u0301c", 10958);
    freq.put(" po", 242173);
    freq.put("gen", 57105);
    freq.put(" pl", 26836);
    freq.put("cid", 70600);
    freq.put("o\u0301", 542725);
    freq.put("uti", 16202);
    freq.put("cin", 17134);
    freq.put("rma", 60914);
    freq.put("cim", 9340);
    freq.put("rme", 24156);
    freq.put("cil", 9620);
    freq.put("cis", 9341);
    freq.put("ni\u0301a", 7088);
    freq.put("cir", 8507);
    freq.put("cip", 45552);
    freq.put("ju", 57258);
    freq.put("tur", 45480);
    freq.put("cit", 8942);
    freq.put("jo", 44644);
    freq.put("tul", 9339);
    freq.put("je", 41244);
    freq.put("ai\u0301s", 14636);
    freq.put("tud", 17240);
    freq.put("ja", 41449);
    freq.put("tug", 8561);
    freq.put(" ba", 52391);
    freq.put(" bo", 13161);
    freq.put(" bi", 11562);
    freq.put("s", 4177405);
    freq.put(" br", 12518);
    freq.put("por", 173351);
    freq.put("pos", 33566);
    freq.put("pop", 7479);
    freq.put("i\u0301s ", 12371);
    freq.put("pon", 17239);
    freq.put("pol", 27348);
    freq.put("tua", 54339);
    freq.put("pod", 7343);
    freq.put("pob", 43702);
    freq.put("tub", 10280);
    freq.put("pan\u0303", 59522);
    freq.put("fic", 57976);
    freq.put(" Me\u0301", 10807);
    freq.put("pai\u0301", 9997);
    freq.put("odu", 18410);
    freq.put("clu", 14576);
    freq.put("po ", 39204);
    freq.put("mpe", 21376);
    freq.put("ein", 14332);
    freq.put("ive", 26878);
    freq.put("iva", 29645);
    freq.put("e\u0301ti", 7504);
    freq.put("ivo", 27807);
    freq.put("ivi", 28311);
    freq.put(" Me", 30504);
    freq.put("par", 158326);
    freq.put("pas", 11530);
    freq.put(" Ma", 85482);
    freq.put(" Mo", 36161);
    freq.put(" Mi", 25830);
    freq.put(" Mu", 18130);
    freq.put("pac", 12615);
    freq.put("I ", 25126);
    freq.put("pal", 23552);
    freq.put("pan", 11657);
    freq.put("nac", 46410);
    freq.put("I", 139475);
    freq.put("II", 18780);
    freq.put(" gu", 12156);
    freq.put("Is", 11404);
    freq.put("pa ", 14872);
    freq.put("cci", 38750);
    freq.put("In", 34662);
    freq.put("uie", 12890);
    freq.put("\u4e00", 7134);
    freq.put("a\u0301c", 15525);
    freq.put(" qu", 191524);
    freq.put("a\u0301f", 8040);
    freq.put("am ", 8792);
    freq.put("a\u0301l", 20287);
    freq.put("a\u0301n", 62336);
    freq.put("a\u0301s", 49088);
    freq.put("a\u0301r", 16431);
    freq.put("a\u0301t", 16282);
    freq.put("uid", 13351);
    freq.put("mo ", 116388);
    freq.put("u\u0301n ", 11275);
    freq.put("tim", 14112);
    freq.put("tin", 45124);
    freq.put(" ge", 20831);
    freq.put("ami", 57872);
    freq.put("a\u0301 ", 27321);
    freq.put("amo", 12426);
    freq.put("ama", 44395);
    freq.put("mor", 11861);
    freq.put("amb", 41071);
    freq.put("ame", 88516);
    freq.put("mon", 23296);
    freq.put("tie", 38174);
    freq.put("amp", 25988);
    freq.put("mod", 10208);
    freq.put("tig", 17405);
    freq.put("tia", 11282);
    freq.put("km2", 9037);
    freq.put("Man", 10902);
    freq.put("uto", 18658);
    freq.put("eza", 8196);
    freq.put("Med", 8474);
    freq.put(" ch", 12983);
    freq.put(" ci", 56484);
    freq.put(" co", 462664);
    freq.put(" cl", 15585);
    freq.put(" ca", 157850);
    freq.put(" ce", 31950);
    freq.put("uci", 25554);
    freq.put(" cr", 30029);
    freq.put("uch", 12624);
    freq.put(" cu", 60477);
    freq.put("mpi", 8494);
    freq.put("ez ", 27186);
    freq.put("acc", 10027);
    freq.put("on", 689571);
    freq.put("aca", 16009);
    freq.put("ol", 230551);
    freq.put("oj", 12159);
    freq.put("ace", 30766);
    freq.put("oh", 10801);
    freq.put("og", 57063);
    freq.put("of", 39013);
    freq.put("aci", 224093);
    freq.put("ach", 10349);
    freq.put("aco", 10755);
    freq.put("ob", 123195);
    freq.put("oa", 18159);
    freq.put("ngo", 7965);
    freq.put("oz", 11222);
    freq.put("oy", 19941);
    freq.put("act", 41870);
    freq.put("ow", 10366);
    freq.put("ov", 85328);
    freq.put("ou", 52929);
    freq.put("ot", 93533);
    freq.put("os", 699509);
    freq.put("or", 691238);
    freq.put("op", 77349);
    freq.put("Ni", 10392);
    freq.put("No", 24130);
    freq.put("Na", 26109);
    freq.put("ai\u0301", 17948);
    freq.put("Ne", 11654);
    freq.put("an\u0303", 100385);
    freq.put("Nu", 10474);
    freq.put("loc", 26941);
    freq.put("log", 23375);
    freq.put("her", 16542);
    freq.put("lon", 23409);
    freq.put("lom", 10655);
    freq.put("lor", 23128);
    freq.put("los", 171022);
    freq.put("jue", 11292);
    freq.put("J", 79180);
    freq.put("jun", 20993);
    freq.put("na ", 398062);
    freq.put("jul", 9258);
    freq.put("lo ", 93016);
    freq.put("as ", 405615);
    freq.put("he ", 23960);
    freq.put("ac", 374463);
    freq.put("Est", 40499);
    freq.put("ae", 43681);
    freq.put("ad", 631439);
    freq.put("ag", 85149);
    freq.put("Esp", 30688);
    freq.put("ai", 51423);
    freq.put("ah", 13118);
    freq.put("ak", 11907);
    freq.put("aj", 50703);
    freq.put("am", 297433);
    freq.put("al", 659633);
    freq.put("ao", 8102);
    freq.put("an", 805183);
    freq.put("aq", 9531);
    freq.put("ap", 77232);
    freq.put("as", 567489);
    freq.put("ar", 691307);
    freq.put("au", 72787);
    freq.put("at", 211115);
    freq.put("av", 48388);
    freq.put("ay", 59587);
    freq.put("az", 30061);
    freq.put("cio\u0301", 209489);
    freq.put("igu", 25326);
    freq.put("Mun", 7799);
    freq.put("ige", 12181);
    freq.put("iga", 13218);
    freq.put("igo", 7750);
    freq.put("ign", 13613);
    freq.put("igl", 16846);
    freq.put("yor", 11730);
    freq.put("igi", 27180);
    freq.put("Las", 10322);
    freq.put("a ", 2807777);
    freq.put("Es ", 20079);
    freq.put(" ga", 13109);
    freq.put("at ", 7824);
    freq.put("La ", 78398);
    freq.put("yo ", 17934);
    freq.put("u", 2624688);
    freq.put("u\u0301si", 8717);
    freq.put("alo", 13492);
    freq.put("all", 38280);
    freq.put("alm", 37560);
    freq.put("Val", 13044);
    freq.put("ali", 96797);
    freq.put("alg", 10767);
    freq.put("ald", 9255);
    freq.put("ale", 82063);
    freq.put("sca", 14799);
    freq.put("alc", 7683);
    freq.put("ala", 31798);
    freq.put("eda", 21258);
    freq.put("scu", 15948);
    freq.put("alt", 15595);
    freq.put("alu", 9523);
    freq.put("gr", 97493);
    freq.put("smo", 24196);
    freq.put("tt", 18266);
    freq.put("tu", 178275);
    freq.put("tr", 358077);
    freq.put("ts", 11628);
    freq.put("to", 492464);
    freq.put("tl", 11756);
    freq.put("th", 33828);
    freq.put("ti", 404422);
    freq.put("te", 662982);
    freq.put("tb", 14576);
    freq.put("ta", 636505);
    freq.put("edi", 50600);
    freq.put("mpa", 16447);
    freq.put("mpo", 32948);
    freq.put("mpl", 23586);
    freq.put("rc", 86488);
    freq.put("iud", 31065);
    freq.put("al ", 274116);
    freq.put("edo", 13652);
    freq.put("mpu", 10144);
    freq.put("mpr", 14573);
    freq.put("fam", 38352);
    freq.put(" Ni", 10343);
    freq.put("edr", 9154);
    freq.put("pre", 58569);
    freq.put("ro", 473902);
    freq.put(" No", 24018);
    freq.put(" Na", 26019);
    freq.put(" Ne", 11540);
    freq.put("ge", 97443);
    freq.put("ri", 592813);
    freq.put(" Nu", 10454);
    freq.put("t ", 94930);
    freq.put("pul", 11629);
    freq.put("tel", 23707);
    freq.put("ga", 124206);
    freq.put("ten", 66323);
    freq.put("tea", 9283);
    freq.put("tec", 13760);
    freq.put("teg", 9394);
    freq.put("go", 114696);
    freq.put("ter", 127000);
    freq.put("tes", 66100);
    freq.put("aba", 35637);
    freq.put("gl", 50338);
    freq.put("abe", 14437);
    freq.put("abi", 26160);
    freq.put("sul", 7853);
    freq.put("abl", 18696);
    freq.put("to\u0301", 61297);
    freq.put("abo", 13547);
    freq.put("abr", 22582);
    freq.put("ti\u0301", 29392);
    freq.put("sus", 22170);
    freq.put("sur", 23147);
    freq.put("te\u0301", 18357);
    freq.put("zo\u0301", 8970);
    freq.put("ta\u0301", 43968);
    freq.put(" ru", 8901);
    freq.put("te ", 284941);
    freq.put("K", 34991);
    freq.put(" re", 170810);
    freq.put(" ra", 15504);
    freq.put("pub", 10168);
    freq.put(" ro", 18871);
    freq.put("su ", 57230);
    freq.put(" Ar", 39211);
    freq.put("vic", 9152);
    freq.put("via", 12659);
    freq.put("nto", 136463);
    freq.put("vid", 23929);
    freq.put("vie", 21693);
    freq.put("vin", 37424);
    freq.put("vil", 17697);
    freq.put("vis", 25393);
    freq.put("ue\u0301s", 7665);
    freq.put("viv", 7676);
    freq.put("S ", 9671);
    freq.put("pec", 57888);
    freq.put("de ", 1556339);
    freq.put("Su", 36610);
    freq.put("St", 15377);
    freq.put("Si", 21213);
    freq.put("So", 22342);
    freq.put("Sc", 7275);
    freq.put("Sa", 70712);
    freq.put("fi\u0301", 9213);
    freq.put("Se", 51296);
    freq.put("a\u0301", 241717);
    freq.put("ey ", 19031);
    freq.put(" di", 146031);
    freq.put("Int", 10608);
    freq.put(" de", 1878742);
    freq.put("des", 90830);
    freq.put(" da", 13407);
    freq.put("del", 228490);
    freq.put("dem", 11684);
    freq.put("den", 85908);
    freq.put("v", 521828);
    freq.put("Ind", 7667);
    freq.put(" du", 20922);
    freq.put("dec", 9801);
    freq.put("def", 7698);
    freq.put("f ", 15176);
    freq.put("co\u0301", 10267);
    freq.put("ati", 40488);
    freq.put("i\u0301ti", 20855);
    freq.put("r ", 505089);
    freq.put("fr", 77696);
    freq.put("fu", 123473);
    freq.put("fa", 71295);
    freq.put("fe", 72710);
    freq.put("fi", 107495);
    freq.put("fl", 18249);
    freq.put("fo", 79998);
    freq.put("a", 7916083);
    freq.put("egr", 10013);
    freq.put("egu", 24464);
    freq.put("egi", 66647);
    freq.put("ego", 28111);
    freq.put("ega", 22427);
    freq.put("ito", 98982);
    freq.put("ce ", 35472);
    freq.put("y ", 494983);
    freq.put("ite", 23119);
    freq.put("ita", 90631);
    freq.put("os ", 567590);
    freq.put("itu", 57305);
    freq.put(" Or", 15358);
    freq.put("ced", 7879);
    freq.put("Bar", 13123);
    freq.put("yo", 35768);
    freq.put("ya", 28514);
    freq.put("cen", 32729);
    freq.put("cel", 19017);
    freq.put("ye", 23683);
    freq.put("L", 239740);
    freq.put("ces", 71319);
    freq.put("cer", 30048);
    freq.put("cep", 7727);
    freq.put("ife", 9766);
    freq.put("die", 14888);
    freq.put("ifo", 15425);
    freq.put("ifi", 21950);
    freq.put(" su", 139495);
    freq.put(" si", 104740);
    freq.put(" so", 62800);
    freq.put(" sa", 21596);
    freq.put(" se", 189308);
    freq.put("iza", 56748);
    freq.put("e\u0301xi", 11167);
    freq.put("gur", 7400);
    freq.put("E ", 7609);
    freq.put("En ", 18934);
    freq.put(" el", 384203);
    freq.put(" Ac", 8911);
    freq.put("ve ", 15016);
    freq.put("ast", 48943);
    freq.put(" Ai", 9020);
    freq.put(" Al", 51409);
    freq.put(" Am", 14012);
    freq.put(" An", 29155);
    freq.put("asc", 10580);
    freq.put("asa", 20743);
    freq.put(" As", 13733);
    freq.put(" At", 7457);
    freq.put(" Au", 18286);
    freq.put("ase", 16265);
    freq.put("put", 7419);
    freq.put("Uni", 27767);
    freq.put("asi", 22274);
    freq.put("aso", 13076);
    freq.put("El", 96353);
    freq.put("En", 28786);
    freq.put("Ed", 7168);
    freq.put("w", 47097);
    freq.put("tos", 55424);
    freq.put("Eu", 12005);
    freq.put("dis", 80875);
    freq.put("Es", 99956);
    freq.put("le ", 58880);
    freq.put("Fra", 22586);
    freq.put("zo", 36191);
    freq.put("jer", 7889);
    freq.put(" em", 20859);
    freq.put(" en", 614552);
    freq.put("st ", 10396);
    freq.put(" ej", 8137);
    freq.put(" ed", 14319);
    freq.put("X ", 8775);
    freq.put(" ex", 38515);
    freq.put(" eq", 8506);
    freq.put(" er", 14855);
    freq.put(" es", 539820);
    freq.put("tom", 10133);
    freq.put("ncu", 16386);
    freq.put("za", 111482);
    freq.put("nch", 9730);
    freq.put("nci", 146898);
    freq.put("ncl", 10729);
    freq.put("nco", 17791);
    freq.put("nca", 12577);
    freq.put("ueb", 8677);
    freq.put("nce", 61430);
    freq.put("ste", 88396);
    freq.put("b", 812441);
    freq.put("sta", 179440);
    freq.put("sto", 49757);
    freq.put(" e ", 10258);
    freq.put("sti", 69501);
    freq.put("stu", 17380);
    freq.put("je ", 13092);
    freq.put("str", 118933);
    freq.put("Nue", 8768);
    freq.put("oda", 9018);
    freq.put("lid", 38365);
    freq.put("lie", 8152);
    freq.put("k ", 32633);
    freq.put("lia", 73957);
    freq.put("lib", 11554);
    freq.put("lic", 48449);
    freq.put("lim", 8340);
    freq.put("lin", 23082);
    freq.put("lio", 17662);
    freq.put("lit", 23261);
    freq.put("efi", 9256);
    freq.put("2 ", 9260);
    freq.put("ues", 36069);
    freq.put("lis", 29055);
    freq.put("efe", 15631);
    freq.put("liz", 32987);
    freq.put("M", 232523);
    freq.put("nce\u0301", 9514);
    freq.put("The", 12538);
    freq.put("ka", 12118);
    freq.put("sta\u0301", 22167);
    freq.put("ke", 14800);
    freq.put("ki", 14501);
    freq.put("km", 14607);
    freq.put("exi", 15850);
    freq.put("ext", 18108);
    freq.put("exp", 10760);
    freq.put("rte", 83807);
    freq.put("rta", 69414);
    freq.put("sen\u0303", 8377);
    freq.put("rto", 22364);
    freq.put("rti", 44079);
    freq.put("sup", 14503);
    freq.put("rtu", 12987);
    freq.put("ari\u0301", 13656);
    freq.put("ugu", 12215);
    freq.put("Ju", 22045);
    freq.put("ies", 19531);
    freq.put("ier", 54165);
    freq.put("iet", 7563);
    freq.put("Jo", 22070);
    freq.put("iem", 41853);
    freq.put("iel", 8991);
    freq.put("ien", 137287);
    freq.put("Je", 8830);
    freq.put("ied", 10903);
    freq.put("ieg", 9534);
    freq.put("his", 17036);
    freq.put("rt ", 11603);
    freq.put("hil", 16082);
    freq.put("hin", 11792);
    freq.put("a\u0301s ", 40719);
    freq.put("cre", 24696);
    freq.put("ie ", 46477);
    freq.put("rfi", 8102);
    freq.put("cri", 31616);
    freq.put("cro", 8764);
    freq.put(" Be", 23973);
    freq.put("arq", 11629);
    freq.put("arr", 48459);
    freq.put("ars", 9729);
    freq.put("art", 119072);
    freq.put("ser", 42063);
    freq.put("sep", 14018);
    freq.put("rti\u0301", 7814);
    freq.put("arz", 11183);
    freq.put(" Bi", 9959);
    freq.put(" Bu", 16073);
    freq.put("ara", 95441);
    freq.put("arc", 32672);
    freq.put("ard", 31172);
    freq.put("are", 34407);
    freq.put("arg", 22636);
    freq.put("ari", 83070);
    freq.put("sem", 7053);
    freq.put("sel", 10295);
    freq.put("arl", 13962);
    freq.put("arm", 9270);
    freq.put("arn", 7316);
    freq.put("aro", 19229);
    freq.put("Pla", 8680);
    freq.put("ue ", 294774);
    freq.put("ar ", 100623);
    freq.put("se ", 142516);
    freq.put(" Pr", 36030);
    freq.put("c", 2912236);
    freq.put(" Pu", 11158);
    freq.put(" Pa", 58153);
    freq.put(" Pe", 30452);
    freq.put(" Pi", 20772);
    freq.put(" Po", 27637);
    freq.put(" Pl", 10897);
    freq.put("lbu", 12473);
    freq.put("ga ", 30329);
    freq.put("pr", 228655);
    freq.put("ps", 9053);
    freq.put("pt", 30720);
    freq.put("pu", 78951);
    freq.put("duc", 27199);
    freq.put("pa", 326975);
    freq.put("pe", 253260);
    freq.put("ph", 12436);
    freq.put("pi", 101456);
    freq.put("po", 370364);
    freq.put("pl", 67808);
    freq.put(" tu", 8296);
    freq.put("gas", 7988);
    freq.put(" tr", 62181);
    freq.put("N", 101570);
    freq.put(" to", 30228);
    freq.put("gan", 23906);
    freq.put("gal", 9045);
    freq.put(" ti", 31564);
    freq.put(" th", 7488);
    freq.put(" te", 60962);
    freq.put("gad", 14992);
    freq.put(" ta", 42321);
    freq.put("tip", 10749);
    freq.put("p ", 13048);
    freq.put("fue", 90978);
    freq.put("fun", 22112);
    freq.put("riz", 10435);
    freq.put("vol", 10345);
    freq.put("rit", 87431);
    freq.put("ris", 26175);
    freq.put("rin", 44691);
    freq.put("rio", 82353);
    freq.put("ril", 18939);
    freq.put("rim", 37251);
    freq.put("vos", 8624);
    freq.put("rig", 32503);
    freq.put("rid", 24912);
    freq.put("rie", 40300);
    freq.put("rib", 16779);
    freq.put("ric", 53993);
    freq.put("ria", 74022);
    freq.put("po\u0301", 8915);
    freq.put("tir", 9162);
    freq.put("pu\u0301", 12838);
    freq.put("mos", 17488);
    freq.put("Au", 18315);
    freq.put("Cor", 11229);
    freq.put("vo ", 33305);
    freq.put("tis", 12154);
    freq.put("cea", 16334);
    freq.put(" do", 35749);
    freq.put(" ti\u0301", 7323);
    freq.put("lig", 10555);
    freq.put("an\u0303a", 34948);
    freq.put(" te\u0301", 10997);
    freq.put("an\u0303o", 60064);
    freq.put("Com", 17537);
    freq.put("Col", 10868);
    freq.put("ri ", 7113);
    freq.put("Con", 24853);
    freq.put(" fr", 61229);
    freq.put(" fu", 116273);
    freq.put(" fa", 54639);
    freq.put(" fe", 21573);
    freq.put(" fi", 33918);
    freq.put(" fl", 10710);
    freq.put(" fo", 35270);
    freq.put("cur", 10605);
    freq.put("cuy", 7974);
    freq.put("rga", 23318);
    freq.put("cue", 32934);
    freq.put("sal", 12684);
    freq.put("rge", 24597);
    freq.put("cua", 33441);
    freq.put("cul", 40621);
    freq.put("rgo", 16017);
    freq.put("bio", 8582);
    freq.put("bil", 7159);
    freq.put("bie", 16653);
    freq.put("bic", 15037);
    freq.put("bia", 11473);
    freq.put("bit", 22599);
    freq.put("Or", 15403);
    freq.put("uy ", 8325);
    freq.put("d", 3877179);
    freq.put("b ", 16974);
    freq.put(" Qu", 7915);
    freq.put("per", 107782);
    freq.put("pes", 10236);
    freq.put("pel", 18436);
    freq.put("pen", 14739);
    freq.put("peo", 7168);
    freq.put("id ", 12492);
    freq.put("t", 3108332);
    freq.put("be", 67612);
    freq.put("ba", 136047);
    freq.put("bie\u0301", 25416);
    freq.put("bl", 117456);
    freq.put("ruc", 9429);
    freq.put("bo", 65362);
    freq.put("bi", 135239);
    freq.put("O", 64162);
    freq.put("bu", 47229);
    freq.put("br", 179247);
    freq.put("bs", 7367);
    freq.put("rus", 10637);
    freq.put("rup", 19339);
    freq.put("Fu", 23434);
    freq.put("ido", 115195);
    freq.put("idi", 11705);
    freq.put("ide", 56950);
    freq.put("pe ", 7492);
    freq.put("ida", 143468);
    freq.put("nsi", 26727);
    freq.put("nso", 9665);
    freq.put(" ut", 9609);
    freq.put("nsa", 11053);
    freq.put("nse", 26710);
    freq.put(" us", 12351);
    freq.put(" un", 466456);
    freq.put("nst", 30664);
    freq.put(" ub", 13189);
    freq.put("u ", 97650);
    freq.put("fes", 10458);
    freq.put("aqu", 8935);
    freq.put(" Ch", 44683);
    freq.put(" Ci", 15105);
    freq.put(" Co", 80501);
    freq.put(" Cl", 10942);
    freq.put("n\u0303a ", 43408);
    freq.put("ns ", 13747);
    freq.put("El ", 89488);
    freq.put(" Ca", 87586);
    freq.put(" Ce", 15402);
    freq.put("sde", 20004);
    freq.put(" Cr", 13930);
    freq.put("zan", 7115);
    freq.put(" Cu", 13492);
    freq.put("cia", 152068);
    freq.put("uta", 12332);
    freq.put("uy", 29308);
    freq.put("ux", 7768);
    freq.put("cie", 87706);
    freq.put("uz", 11349);
    freq.put("ut", 75455);
    freq.put("uv", 14743);
    freq.put("cio", 103441);
    freq.put("up", 46545);
    freq.put("us", 135539);
    freq.put("ur", 196055);
    freq.put("um", 62826);
    freq.put("ul", 130016);
    freq.put("uo", 9672);
    freq.put("un", 688515);
    freq.put("ui", 101034);
    freq.put("ciu", 26750);
    freq.put("uj", 10219);
    freq.put("ue", 529325);
    freq.put("ud", 82055);
    freq.put("ug", 37794);
    freq.put("z", 257162);
    freq.put("ua", 157161);
    freq.put("uc", 86063);
    freq.put("ub", 69875);
    freq.put("Tu", 7329);
    freq.put("Tr", 17446);
    freq.put("To", 19269);
    freq.put("Th", 18313);
    freq.put("Ti", 12341);
    freq.put("Te", 21087);
    freq.put("Ta", 17232);
    freq.put("A ", 15731);
    freq.put("gru", 17556);
    freq.put(" gr", 47141);
    freq.put("nad", 35305);
    freq.put("naj", 8529);
    freq.put("nan", 12157);
    freq.put("nal", 70953);
    freq.put("nam", 8218);
    freq.put("nar", 27443);
    freq.put("nas", 35377);
    freq.put("gre", 9359);
    freq.put("Mad", 9566);
    freq.put("nat", 21175);
    freq.put("gra", 45297);
    freq.put(" go", 9321);
    freq.put("gri", 10321);
    freq.put("ie\u0301n", 27517);
    freq.put("ago", 28675);
    freq.put("Ac", 8941);
    freq.put("e", 8874725);
    freq.put("Ai", 9057);
    freq.put("Am", 14049);
    freq.put("Al", 51515);
    freq.put("aga", 11365);
    freq.put("An", 29222);
    freq.put("ui\u0301", 10738);
    freq.put("As", 13866);
    freq.put("Ar", 39333);
    freq.put("ue\u0301", 9949);
    freq.put("At", 7482);
    freq.put("agu", 12491);
    freq.put("u\u0301", 87005);
    freq.put(" b", 110799);
    freq.put(" c", 841620);
    freq.put("gu", 117756);
    freq.put(" a", 615947);
    freq.put(" f", 346033);
    freq.put(" g", 128207);
    freq.put(" d", 2112466);
    freq.put(" e", 1686012);
    freq.put(" j", 57642);
    freq.put(" k", 20882);
    freq.put(" h", 153575);
    freq.put(" i", 177440);
    freq.put(" n", 169035);
    freq.put(" o", 224265);
    freq.put(" l", 925296);
    freq.put(" m", 342591);
    freq.put(" r", 229895);
    freq.put(" s", 537300);
    freq.put(" p", 764411);
    freq.put(" q", 191724);
    freq.put(" v", 109427);
    freq.put(" t", 263819);
    freq.put(" u", 509709);
    freq.put(" z", 8894);
    freq.put("gn", 24260);
    freq.put(" y", 413167);
    freq.put("uen\u0303", 8502);
    freq.put("gi", 128766);
    freq.put("gh", 9410);
    freq.put(" B", 158843);
    freq.put(" C", 308303);
    freq.put(" A", 248654);
    freq.put(" F", 121663);
    freq.put(" G", 115612);
    freq.put(" D", 105557);
    freq.put(" E", 280970);
    freq.put(" J", 77814);
    freq.put(" K", 33034);
    freq.put(" H", 77965);
    freq.put(" I", 96403);
    freq.put(" N", 91185);
    freq.put(" O", 55452);
    freq.put(" L", 232579);
    freq.put(" M", 222195);
    freq.put(" R", 131715);
    freq.put(" S", 256762);
    freq.put(" P", 211939);
    freq.put(" Q", 9140);
    freq.put(" V", 79914);
    freq.put(" W", 33301);
    freq.put(" T", 122063);
    freq.put(" U", 57665);
    freq.put(" Z", 14852);
    freq.put(" X", 18791);
    freq.put(" Y", 15119);
    freq.put("uga", 15579);
    freq.put("Nor", 14767);
    freq.put("ch ", 11118);
    freq.put("ed ", 10329);
    freq.put("P", 223906);
    freq.put("g ", 31294);
    freq.put("tri", 81313);
    freq.put("evi", 21593);
    freq.put("tro", 72914);
    freq.put("evo", 10163);
    freq.put("tra", 116327);
    freq.put("eva", 20123);
    freq.put("us ", 49172);
    freq.put("tre", 58815);
    freq.put("eve", 10842);
    freq.put("so\u0301", 7077);
    freq.put("tru", 16821);
    freq.put("rro", 28597);
    freq.put("uel", 28446);
    freq.put(" a\u0301", 26258);
    freq.put("go\u0301", 7060);
    freq.put("zi", 7657);
    freq.put("rri", 26111);
    freq.put("ued", 16010);
    freq.put("rre", 31796);
    freq.put(" e\u0301", 11575);
    freq.put("gu\u0301", 7200);
    freq.put("rra", 36840);
    freq.put("ibe", 11766);
    freq.put("odi", 11580);
    freq.put("odo", 26635);
    freq.put(" u\u0301", 11089);
    freq.put("zu", 8538);
    freq.put("gi\u0301", 14289);
    freq.put("uev", 15569);
    freq.put("ode", 14611);
    freq.put("ge\u0301", 21878);
    freq.put("uer", 46622);
    freq.put(" A\u0301", 8823);
    freq.put("med", 24892);
    freq.put("rd ", 11954);
    freq.put("ulo", 17762);
    freq.put("lea", 8424);
    freq.put("lec", 26734);
    freq.put("si\u0301", 13754);
    freq.put("leg", 14703);
    freq.put("z ", 55163);
    freq.put("lem", 26257);
    freq.put("len", 30658);
    freq.put("ler", 15144);
    freq.put("les", 91476);
    freq.put("let", 11653);
    freq.put("lev", 15617);
    freq.put("ctu", 33625);
    freq.put("ctr", 9939);
    freq.put("rde", 29313);
    freq.put("ce\u0301s", 10035);
    freq.put("cte", 9828);
    freq.put("rda", 8172);
    freq.put("cta", 10659);
    freq.put("rdo", 13679);
    freq.put("cto", 44819);
    freq.put("rdi", 9872);
    freq.put("cti", 20454);
    freq.put(" Do", 13935);
    freq.put(" Di", 25027);
    freq.put("apr", 7236);
    freq.put(" De", 29418);
    freq.put(" Da", 13336);
    freq.put("api", 11786);
    freq.put("apo", 11441);
    freq.put(" Du", 7489);
    freq.put("apa", 19232);
    freq.put("ape", 7495);
    freq.put("sio\u0301", 31343);
    freq.put("cha", 26138);
    freq.put("Fr", 30636);
    freq.put("feb", 8937);
    freq.put("fec", 9155);
    freq.put("usa", 13025);
    freq.put("uso", 9699);
    freq.put("chi", 20475);
    freq.put("pue", 30894);
    freq.put("usi", 15007);
    freq.put("cho", 21852);
    freq.put("Fa", 9899);
    freq.put("ust", 26126);
    freq.put("fer", 25898);
    freq.put("Fe", 19702);
    freq.put("Fi", 10813);
    freq.put("Fo", 10911);
    freq.put("oo", 15677);
    freq.put("Gue", 7438);
    freq.put("om", 334368);
    freq.put("spu", 8777);
    freq.put(" Ru", 9128);
    freq.put("oi", 24324);
    freq.put("f", 602083);
    freq.put("Ja", 18733);
    freq.put(" Re", 46794);
    freq.put("nda", 66093);
    freq.put(" Ra", 15024);
    freq.put(" Ro", 30970);
    freq.put(" Ri", 14181);
    freq.put("oe", 24400);
    freq.put("tat", 7964);
    freq.put("od", 93463);
    freq.put("tar", 41661);
    freq.put("tas", 38619);
    freq.put("oc", 180019);
    freq.put("tad", 77862);
    freq.put("tag", 7515);
    freq.put("tab", 14559);
    freq.put("tac", 23593);
    freq.put("tal", 73680);
    freq.put("tam", 79203);
    freq.put("tan", 67218);
    freq.put(" va", 23514);
    freq.put(" ve", 32789);
    freq.put("sit", 47886);
    freq.put(" vi", 36979);
    freq.put(" vo", 9768);
    freq.put("sic", 33044);
    freq.put("sia", 21182);
    freq.put("sig", 27477);
    freq.put("sie", 10373);
    freq.put("sid", 35818);
    freq.put("sio", 18884);
    freq.put("sin", 18695);
    freq.put("sim", 10529);
    freq.put("sil", 10556);
    freq.put("sis", 26321);
    freq.put("ro\u0301n", 9102);
    freq.put("ox", 9374);
    freq.put("Q", 9803);
    freq.put("ta ", 179252);
    freq.put("ndu", 7292);
    freq.put("u\u0301l", 7364);
    freq.put("u\u0301n", 21741);
    freq.put("da ", 212873);
    freq.put("u\u0301b", 12720);
    freq.put("X", 27052);
    freq.put("u\u0301t", 8499);
    freq.put("u\u0301s", 12464);
    freq.put("lf", 10189);
    freq.put("lg", 19778);
    freq.put("ld", 22533);
    freq.put("le", 344098);
    freq.put("lb", 23157);
    freq.put("lc", 15579);
    freq.put("la", 1037960);
    freq.put("lo", 395718);
    freq.put("ll", 193235);
    freq.put("lm", 47465);
    freq.put("li", 353994);
    freq.put("lv", 15446);
    freq.put("lt", 59369);
    freq.put("lu", 77232);
    freq.put("ls", 13390);
    freq.put("lp", 10103);
    freq.put("ly", 9017);
    freq.put("dad", 141389);
    freq.put("dae", 14141);
    freq.put("Cas", 14393);
    freq.put("Car", 17937);
    freq.put("dan", 12985);
    freq.put("u\u0301 ", 7505);
    freq.put("Can", 11389);
    freq.put("Cam", 10802);
    freq.put("Cal", 12289);
    freq.put("ema", 33787);
    freq.put("qui\u0301", 8097);
    freq.put("Pre", 7665);
    freq.put("Sai", 11675);
    freq.put("San", 32494);
    freq.put("l ", 1070460);
    freq.put("Sal", 8578);
    freq.put("nfo", 10116);
    freq.put("Pro", 17204);
    freq.put("Pri", 7235);
    freq.put(" hu", 9280);
    freq.put(" hi", 30296);
    freq.put(" ho", 20186);
    freq.put(" ha", 71347);
    freq.put(" he", 17319);
    freq.put("oun", 14708);
    freq.put("our", 10655);
    freq.put("mat", 18421);
    freq.put("la\u0301", 14567);
    freq.put("rer", 18242);
    freq.put("res", 140547);
    freq.put("rep", 14882);
    freq.put("li\u0301", 47975);
    freq.put("rev", 10637);
    freq.put("ret", 23611);
    freq.put("le\u0301", 20848);
    freq.put("rei", 7333);
    freq.put("ren", 51706);
    freq.put("lo\u0301", 19506);
    freq.put("rel", 19501);
    freq.put("rem", 14749);
    freq.put("rec", 55408);
    freq.put("rea", 43224);
    freq.put("ref", 13241);
    freq.put("reg", 68764);
    freq.put("red", 15261);
    freq.put("ece", 32005);
    freq.put("ecc", 12316);
    freq.put("eca", 7852);
    freq.put("eco", 21596);
    freq.put("eci", 89707);
    freq.put("ech", 18820);
    freq.put("ecu", 14868);
    freq.put("ect", 45028);
    freq.put("que", 227040);
    freq.put("x", 118459);
    freq.put("qui", 47867);
    freq.put("g", 868874);
    freq.put("n\u0303a", 56328);
    freq.put("lta", 15082);
    freq.put("re ", 155218);
    freq.put("lto", 11513);
    freq.put("n\u0303o", 76416);
    freq.put("rs ", 11514);
    freq.put("ud ", 8479);
    freq.put(" Ba", 43282);
    freq.put("ta\u0301n", 19529);
    freq.put("be ", 11171);
    freq.put(" St", 14732);
    freq.put(" Su", 36537);
    freq.put(" Si", 21147);
    freq.put(" So", 22241);
    freq.put(" Sc", 7137);
    freq.put(" Sa", 70550);
    freq.put(" Bo", 25824);
    freq.put(" Se", 51093);
    freq.put("Ka", 8249);
    freq.put("rso", 23313);
    freq.put("rsi", 16295);
    freq.put("rse", 13455);
    freq.put("ogr", 18966);
    freq.put("ogo", 8779);
    freq.put("R", 140692);
    freq.put("ta\u0301 ", 17299);
    freq.put("vas", 9770);
    freq.put("udi", 17314);
    freq.put("e\u0301n ", 28809);
    freq.put("seg", 17308);
    freq.put("ber", 30080);
    freq.put("sec", 10078);
    freq.put("Par", 20522);
    freq.put("nqu", 11277);
    freq.put(" Br", 22869);
    freq.put("sen", 28636);
    freq.put("to\u0301n", 43482);
    freq.put("sk", 8256);
    freq.put("ur ", 25587);
    freq.put("ck ", 13234);
    freq.put("min", 50965);
    freq.put("mic", 21219);
    freq.put("mie", 39274);
    freq.put("hr", 7436);
    freq.put("mis", 20947);
    freq.put("mit", 22265);
    freq.put(" El", 96116);
    freq.put(" En", 28605);
    freq.put(" Ed", 7143);
    freq.put("ogi\u0301", 11606);
    freq.put(" Eu", 11992);
    freq.put(" Es", 98653);
    freq.put("ure", 8908);
    freq.put("urg", 11824);
    freq.put("mus", 8143);
    freq.put("uro", 19849);
    freq.put("uri", 19845);
    freq.put("Cha", 15858);
    freq.put("nge", 13697);
    freq.put("nga", 8189);
    freq.put("co ", 135190);
    freq.put("ngl", 22080);
    freq.put(" is", 9470);
    freq.put(" it", 12073);
    freq.put("ae ", 28175);
    freq.put(" im", 16980);
    freq.put(" in", 113728);
    freq.put(" id", 8758);
    freq.put("tbo", 12533);
    freq.put("qu", 286748);
    freq.put("h", 478078);
    freq.put("m2 ", 9185);
    freq.put("ja ", 14889);
    freq.put("Pr", 36130);
    freq.put("Pu", 11178);
    freq.put("oma", 33534);
    freq.put("jo ", 28253);
    freq.put("Pa", 58336);
    freq.put("ebr", 19067);
    freq.put("Pe", 30523);
    freq.put("ede", 34956);
    freq.put("Pi", 20810);
    freq.put("Po", 27786);
    freq.put("Pl", 10964);
    freq.put("lus", 8634);
    freq.put("ome", 21150);
    freq.put("et ", 12616);
    freq.put("luc", 12530);
    freq.put("lug", 7366);
    freq.put("S", 275410);
    freq.put("etr", 18301);
    freq.put("e\u0300", 9587);
    freq.put("eta", 35458);
    freq.put("ete", 19089);
    freq.put("eti", 13610);
    freq.put("eto", 13724);
    freq.put("ck", 21843);
    freq.put("ci", 780154);
    freq.put("ch", 115875);
    freq.put("co", 691321);
    freq.put("omu", 58045);
    freq.put("cl", 46854);
    freq.put("cc", 44533);
    freq.put("ca", 518269);
    freq.put("rva", 8468);
    freq.put("ce", 230782);
    freq.put("Los", 18518);
    freq.put("uce", 7415);
    freq.put("ab", 144055);
    freq.put("ucc", 8218);
    freq.put("uca", 7683);
    freq.put("cr", 79888);
    freq.put("cu", 158454);
    freq.put("ct", 134054);
    freq.put("af", 21278);
    freq.put("uct", 12213);
    freq.put("me\u0301r", 9468);
    freq.put("rvi", 10259);
    freq.put("oto", 14558);
    freq.put("ota", 19189);
    freq.put("c ", 23067);
    freq.put("ote", 14228);
    freq.put("uil", 7952);
    freq.put("cor", 25629);
    freq.put("unt", 24294);
    freq.put("otr", 17397);
    freq.put("uin", 8672);
    freq.put("lgu", 7617);
    freq.put("And", 7070);
    freq.put("uip", 8207);
    freq.put("e\u0301", 232623);
    freq.put("uis", 11000);
    freq.put("Ant", 10595);
    freq.put("ya ", 16470);
    freq.put("uit", 13101);
    freq.put("va", 112048);
    freq.put("ce\u0301", 16005);
    freq.put(" Fr", 30592);
    freq.put(" Fu", 23266);
    freq.put("ve", 131509);
    freq.put("ci\u0301", 12742);
    freq.put("vi", 184322);
    freq.put("ca\u0301", 7737);
    freq.put("vo", 65147);
    freq.put(" Fa", 9820);
    freq.put(" Fe", 19655);
    freq.put("avi", 12074);
    freq.put(" Fi", 10737);
    freq.put("ave", 14502);
    freq.put("ava", 9975);
    freq.put(" Fo", 10836);
    freq.put("io ", 149275);
    freq.put("of ", 7638);
    freq.put("dal", 9998);
    freq.put("dam", 10048);
    freq.put("ios", 44527);
    freq.put("ior", 15897);
    freq.put("ion", 119701);
    freq.put("iod", 9277);
    freq.put("ont", 59611);
    freq.put("ofe", 9434);
    freq.put("i", 4816050);
    freq.put(" Tu", 7181);
    freq.put("ofi", 7512);
    freq.put(" Tr", 17351);
    freq.put(" To", 19041);
    freq.put(" Ti", 12302);
    freq.put(" Th", 18237);
    freq.put(" Te", 20935);
    freq.put("uno", 27366);
    freq.put(" Ta", 17163);
    freq.put("dar", 9501);
    freq.put("das", 36381);
    freq.put("Be", 24042);
    freq.put("adu", 7585);
    freq.put("adr", 17031);
    freq.put("Ba", 43405);
    freq.put("Bo", 25983);
    freq.put("Bi", 10052);
    freq.put("Bu", 16123);
    freq.put("ade", 31132);
    freq.put("Br", 22960);
    freq.put("ada", 154737);
    freq.put("ado", 272062);
    freq.put("e\u0301s ", 45633);
    freq.put("adi", 20049);
    freq.put("nve", 10579);
    freq.put("T", 132122);
    freq.put("i\u0301a ", 90214);
    freq.put("a\u0301ti", 14202);
    freq.put("ad ", 111062);
    freq.put("est", 182109);
    freq.put("esp", 91539);
    freq.put("nd ", 14500);
    freq.put("ese", 28957);
    freq.put("esd", 20115);
    freq.put("esc", 45995);
    freq.put("iso", 8290);
    freq.put("esa", 79475);
    freq.put("eso", 20238);
    freq.put("esi", 46520);
    freq.put("Su ", 13104);
    freq.put("lle", 47097);
    freq.put("Un", 40236);
    freq.put("ndi", 38911);
    freq.put("ndo", 65513);
    freq.put(" ju", 44169);
    freq.put("nde", 54981);
    freq.put("es ", 719197);
    freq.put("ndr", 12605);
    freq.put(" ja", 7912);
    freq.put("ea ", 28070);
    freq.put("h ", 31038);
    freq.put("pu\u0301b", 11593);
    freq.put("van", 9128);
    freq.put("val", 14785);
    freq.put("vad", 11386);
    freq.put("ubi", 18564);
    freq.put("rch", 7367);
    freq.put("rci", 19308);
    freq.put("var", 20642);
    freq.put("rce", 15953);
    freq.put("rca", 25800);
    freq.put("eal", 19761);
    freq.put("mu\u0301s", 8775);
    freq.put("bur", 7145);
    freq.put("le\u0301s", 13215);
    freq.put("eae", 10702);
    freq.put("ead", 15707);
    freq.put("ht", 8163);
    freq.put("hu", 24887);
    freq.put("hi", 87814);
    freq.put("ho", 64406);
    freq.put("bum", 12078);
    freq.put("eas", 12813);
    freq.put("ha", 138548);
    freq.put("eat", 7412);
    freq.put("he", 77025);
    freq.put("va ", 31522);
    freq.put("j", 201978);
    freq.put("lva", 8274);
    freq.put("pin", 12467);
    freq.put("pio", 24607);
    freq.put("int", 60589);
    freq.put("inv", 7546);
    freq.put("pic", 11535);
    freq.put("pie", 8675);
    freq.put("ins", 15850);
    freq.put("ino", 52448);
    freq.put("ini", 36645);
    freq.put("ind", 21266);
    freq.put("ine", 33717);
    freq.put("inf", 13445);
    freq.put("ing", 45586);
    freq.put("pit", 12508);
    freq.put("ina", 105516);
    freq.put("inc", 70215);
    freq.put("eo ", 20655);
    freq.put("i\u0301 ", 14487);
    freq.put("i\u0301t", 28434);
    freq.put("gi\u0301a", 13787);
    freq.put(" Un", 40136);
    freq.put("or ", 251715);
    freq.put(" mu\u0301", 9473);
    freq.put("rqu", 18224);
    freq.put("ubr", 12417);
    freq.put("gar", 19699);
    freq.put("ejo", 12599);
    freq.put("U", 62793);
    freq.put("ubl", 12045);
    freq.put("in ", 30692);
    freq.put("Mar", 33709);
    freq.put("i\u0301d", 7650);
    freq.put("i\u0301f", 8702);
    freq.put("i\u0301a", 105050);
    freq.put("i\u0301c", 18334);
    freq.put("i\u0301m", 10418);
    freq.put("Co", 80802);
    freq.put("i\u0301o", 16786);
    freq.put("i\u0301n", 33019);
    freq.put("eon", 7647);
    freq.put("eos", 9539);
    freq.put("eor", 7614);
    freq.put("i\u0301s", 34065);
    freq.put("o ", 1816298);
  }
  
}

