package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class EO extends CLangProfile {
  private static final String name = "eo";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public EO() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 269191;
    n_words[1] = 324159;
    n_words[2] = 263557;

    freq.put("aln", 50);
    freq.put("Tut", 8);
    freq.put("ufi", 41);
    freq.put("alj", 46);
    freq.put("erc\u0302", 28);
    freq.put("G\u0302u", 3);
    freq.put("lke", 41);
    freq.put("alh", 16);
    freq.put("ali", 206);
    freq.put("u\u0306sp", 3);
    freq.put("Oka", 5);
    freq.put("alf", 102);
    freq.put("mi ", 1385);
    freq.put("u\u0306sk", 34);
    freq.put("nru", 3);
    freq.put("G\u0302a", 4);
    freq.put("u\u0306se", 3);
    freq.put("ald", 132);
    freq.put("G\u0302i", 55);
    freq.put(" Gr", 93);
    freq.put("ers\u0302", 6);
    freq.put(" Ge", 10);
    freq.put(" Ga", 3);
    freq.put(" Go", 4);
    freq.put("upo", 20);
    freq.put("Gr", 93);
    freq.put("upi", 9);
    freq.put("ejp", 4);
    freq.put("upe", 36);
    freq.put("upa", 16);
    freq.put("Ge", 10);
    freq.put("Ga", 3);
    freq.put("Go", 4);
    freq.put("upr", 92);
    freq.put("dua", 28);
    freq.put(" ka", 2915);
    freq.put("g\u0302u ", 25);
    freq.put(" ke", 922);
    freq.put(" ki", 1492);
    freq.put(" kn", 65);
    freq.put(" ko", 729);
    freq.put(" kl", 93);
    freq.put(" kr", 161);
    freq.put("u\u0306a ", 14);
    freq.put(" kv", 195);
    freq.put(" ku", 595);
    freq.put("s\u0302i ", 302);
    freq.put("fa ", 6);
    freq.put("nen", 219);
    freq.put("neo", 4);
    freq.put("nel", 8);
    freq.put("nem", 5);
    freq.put("nej", 19);
    freq.put("nek", 57);
    freq.put("oze", 12);
    freq.put("nei", 5);
    freq.put("nef", 3);
    freq.put("alr", 31);
    freq.put("nee", 6);
    freq.put("neb", 31);
    freq.put("nec", 38);
    freq.put("nea", 3);
    freq.put("orv", 11);
    freq.put("kum", 10);
    freq.put("gna", 5);
    freq.put("nez", 9);
    freq.put("kui", 19);
    freq.put("nev", 5);
    freq.put("net", 18);
    freq.put("kud", 4);
    freq.put("ner", 11);
    freq.put("nes", 34);
    freq.put("nep", 13);
    freq.put("lau\u0306", 150);
    freq.put("meg", 28);
    freq.put("g\u0302ua", 3);
    freq.put("mec", 14);
    freq.put("meb", 3);
    freq.put("mem", 115);
    freq.put("s\u0302ip", 168);
    freq.put("s\u0302is", 47);
    freq.put("s\u0302ir", 26);
    freq.put("g\u0302ui", 4);
    freq.put("s\u0302it", 17);
    freq.put("ors", 16);
    freq.put("met", 144);
    freq.put("s\u0302il", 3);
    freq.put("g\u0302us", 34);
    freq.put("s\u0302in", 72);
    freq.put("s\u0302ia", 107);
    freq.put("u\u0306aj", 3);
    freq.put("eng\u0302", 6);
    freq.put("s\u0302ig", 5);
    freq.put("u\u0306an", 11);
    freq.put("bj", 16);
    freq.put("gli", 13);
    freq.put("gni", 18);
    freq.put("glo", 11);
    freq.put("aks", 21);
    freq.put("gla", 46);
    freq.put("k", 10915);
    freq.put("gle", 10);
    freq.put("aku", 5);
    freq.put("akt", 37);
    freq.put("dri", 14);
    freq.put("aki", 37);
    freq.put("orm", 82);
    freq.put("ako", 104);
    freq.put("dro", 7);
    freq.put("akc", 25);
    freq.put("Zu", 13);
    freq.put("aka", 16);
    freq.put("dre", 43);
    freq.put("glu", 15);
    freq.put("ake", 8);
    freq.put("ku ", 8);
    freq.put("Jes", 57);
    freq.put("tu", 713);
    freq.put("Kom", 14);
    freq.put("Kon", 17);
    freq.put("s\u0302ul", 23);
    freq.put("bru", 88);
    freq.put("lmo", 22);
    freq.put("s\u0302ui", 4);
    freq.put("dej\u0302", 4);
    freq.put("bro", 80);
    freq.put("s\u0302ut", 5);
    freq.put("bri", 79);
    freq.put("lma", 3);
    freq.put("bre", 10);
    freq.put("des", 15);
    freq.put("Jen", 30);
    freq.put("bra", 60);
    freq.put("m ", 977);
    freq.put("Iun", 3);
    freq.put("orb", 12);
    freq.put("LA ", 9);
    freq.put("rc\u0302o", 9);
    freq.put("er ", 290);
    freq.put("G\u0302ak", 4);
    freq.put("rc\u0302i", 18);
    freq.put("ni ", 521);
    freq.put("unk", 18);
    freq.put("rc\u0302a", 8);
    freq.put("nka", 189);
    freq.put("nke", 76);
    freq.put("nki", 34);
    freq.put("jmp", 4);
    freq.put("nkl", 21);
    freq.put("jmu", 5);
    freq.put("Je ", 12);
    freq.put("nue", 27);
    freq.put("jmo", 23);
    freq.put("nkv", 72);
    freq.put("V", 355);
    freq.put("jma", 3);
    freq.put("jme", 8);
    freq.put("g\u0302u", 87);
    freq.put("md", 21);
    freq.put("erv", 62);
    freq.put("g\u0302v", 3);
    freq.put("ma", 1869);
    freq.put("ltu", 16);
    freq.put("err", 15);
    freq.put("mb", 134);
    freq.put("ml", 4);
    freq.put("mo", 1112);
    freq.put("mn", 7);
    freq.put("mi", 2830);
    freq.put("ik", 262);
    freq.put("mk", 3);
    freq.put("g\u0302e", 119);
    freq.put("mt", 13);
    freq.put("erf", 8);
    freq.put("mv", 11);
    freq.put("g\u0302a", 267);
    freq.put("mp", 426);
    freq.put("ms", 3);
    freq.put("erc", 19);
    freq.put("erl", 12);
    freq.put("C\u0302e ", 6);
    freq.put("g\u0302o", 422);
    freq.put("ero", 439);
    freq.put("g\u0302i", 1228);
    freq.put("eri", 164);
    freq.put("erk", 10);
    freq.put("kus\u0302", 50);
    freq.put("Le", 11);
    freq.put("u\u0306aj\u0302", 8);
    freq.put("vor", 82);
    freq.put("Lib", 4);
    freq.put("La", 213);
    freq.put("Mul", 4);
    freq.put("Lo", 9);
    freq.put("uas", 4);
    freq.put("vos", 49);
    freq.put("la ", 3379);
    freq.put("Li", 179);
    freq.put("uaj", 9);
    freq.put("Ira", 3);
    freq.put("uac", 3);
    freq.put("uad", 9);
    freq.put("des\u0302", 7);
    freq.put("ena", 243);
    freq.put("hod", 34);
    freq.put("ib", 131);
    freq.put("s\u0302ig\u0302", 17);
    freq.put("ene", 87);
    freq.put("enf", 21);
    freq.put("eng", 5);
    freq.put("hon", 16);
    freq.put("eni", 700);
    freq.put("enj", 9);
    freq.put("hom", 140);
    freq.put("enl", 18);
    freq.put("hok", 4);
    freq.put("Al ", 8);
    freq.put("eno", 259);
    freq.put("enp", 35);
    freq.put("Kar", 47);
    freq.put("enr", 19);
    freq.put("ens", 230);
    freq.put("hor", 55);
    freq.put("enu", 89);
    freq.put("env", 32);
    freq.put("mpo", 164);
    freq.put("tau\u0306", 218);
    freq.put("enz", 3);
    freq.put("A", 194);
    freq.put("lam", 39);
    freq.put("lan", 318);
    freq.put("Li ", 143);
    freq.put("L ", 6);
    freq.put("ovu", 81);
    freq.put("lad", 41);
    freq.put("laf", 7);
    freq.put("lag", 8);
    freq.put("lab", 51);
    freq.put("lac", 15);
    freq.put("og\u0302u", 3);
    freq.put("neg\u0302", 6);
    freq.put("uob", 9);
    freq.put("ove", 71);
    freq.put("lat", 49);
    freq.put("ua ", 47);
    freq.put("lav", 67);
    freq.put("ovi", 340);
    freq.put("lap", 18);
    freq.put("ovo", 46);
    freq.put("lar", 99);
    freq.put("las", 215);
    freq.put("en ", 1086);
    freq.put("ho ", 8);
    freq.put("tku", 3);
    freq.put("Alf", 80);
    freq.put("Alv", 4);
    freq.put("TA ", 4);
    freq.put("Alp", 3);
    freq.put("mps", 6);
    freq.put(" V ", 8);
    freq.put("fam", 12);
    freq.put("zen", 29);
    freq.put(" Hv", 7);
    freq.put(" Hu", 4);
    freq.put("zem", 5);
    freq.put("zer", 17);
    freq.put(" Hi", 10);
    freq.put(" Ho", 65);
    freq.put("fac", 56);
    freq.put("onn", 3);
    freq.put(" Ha", 27);
    freq.put(" He", 11);
    freq.put("ima", 128);
    freq.put("fis", 29);
    freq.put("His", 9);
    freq.put("ime", 84);
    freq.put("osi", 20);
    freq.put("imi", 114);
    freq.put("imo", 75);
    freq.put("imp", 33);
    freq.put("fia", 5);
    freq.put("imu", 14);
    freq.put(" ga", 84);
    freq.put("fid", 57);
    freq.put("fie", 17);
    freq.put("uok", 6);
    freq.put("fik", 11);
    freq.put("fin", 135);
    freq.put("fio", 8);
    freq.put("fil", 108);
    freq.put("c\u0302o ", 54);
    freq.put("ze ", 34);
    freq.put(" Ve", 52);
    freq.put(" Vi", 287);
    freq.put("onf", 48);
    freq.put("fig", 21);
    freq.put(" Vo", 4);
    freq.put("im ", 3);
    freq.put("dra", 6);
    freq.put("l", 15203);
    freq.put("c\u0302on", 22);
    freq.put("fi ", 10);
    freq.put("cy ", 120);
    freq.put("c\u0302oj", 15);
    freq.put("dep", 3);
    freq.put("deo", 9);
    freq.put("nik", 6);
    freq.put("rau\u0306", 216);
    freq.put(" va", 75);
    freq.put("nt ", 14);
    freq.put("mdu", 19);
    freq.put("rt", 777);
    freq.put("ru", 464);
    freq.put(" zo", 30);
    freq.put("gon", 97);
    freq.put("rp", 80);
    freq.put("rr", 21);
    freq.put("goj", 83);
    freq.put("jor", 332);
    freq.put("onv", 44);
    freq.put("ajr", 38);
    freq.put("ajt", 16);
    freq.put("aju", 4);
    freq.put("goc", 22);
    freq.put("zas", 13);
    freq.put("smo", 3);
    freq.put("re", 2005);
    freq.put("rf", 30);
    freq.put("rg", 105);
    freq.put("ajl", 12);
    freq.put("ra", 2262);
    freq.put("ajn", 521);
    freq.put("ajo", 4);
    freq.put("rl", 104);
    freq.put("aja", 26);
    freq.put("rn", 168);
    freq.put("is ", 5018);
    freq.put("ajd", 4);
    freq.put("aje", 19);
    freq.put("gos", 28);
    freq.put("gor", 4);
    freq.put("ntr", 173);
    freq.put("ntu", 53);
    freq.put("ied", 58);
    freq.put("nti", 178);
    freq.put("raj\u0302", 63);
    freq.put("nid", 7);
    freq.put("W", 45);
    freq.put("nta", 554);
    freq.put("oso", 22);
    freq.put("nie", 65);
    freq.put("nte", 785);
    freq.put("deb", 22);
    freq.put("ntf", 3);
    freq.put("atf", 3);
    freq.put("ate", 158);
    freq.put("Vid", 8);
    freq.put("ata", 252);
    freq.put("iss", 5);
    freq.put("isr", 5);
    freq.put("isp", 33);
    freq.put("u\u0306", 1505);
    freq.put("isv", 3);
    freq.put("ath", 10);
    freq.put("ist", 125);
    freq.put("isk", 17);
    freq.put("isi", 25);
    freq.put("ish", 4);
    freq.put("iso", 6);
    freq.put("isn", 6);
    freq.put("isl", 3);
    freq.put("aj ", 3223);
    freq.put("aca", 7);
    freq.put("isa", 12);
    freq.put("rag\u0302", 29);
    freq.put("u\u0306ra", 8);
    freq.put("ise", 5);
    freq.put(" g\u0302a", 23);
    freq.put("nhe", 11);
    freq.put(" G\u0302u", 3);
    freq.put("rs\u0302a", 3);
    freq.put("nha", 18);
    freq.put("Dum", 14);
    freq.put(" l ", 40);
    freq.put("u\u0306no", 4);
    freq.put("nho", 6);
    freq.put("rs\u0302i", 13);
    freq.put("on ", 2751);
    freq.put("fis\u0302", 16);
    freq.put(" G\u0302a", 4);
    freq.put("nis", 441);
    freq.put("is\u0302i", 6);
    freq.put("kfo", 5);
    freq.put("is\u0302k", 7);
    freq.put("os\u0302o", 14);
    freq.put("is\u0302o", 11);
    freq.put("kfi", 13);
    freq.put("j\u0302u", 20);
    freq.put("niv", 6);
    freq.put("top", 16);
    freq.put("tot", 4);
    freq.put("toj", 402);
    freq.put("me ", 138);
    freq.put("j\u0302o", 341);
    freq.put("ton", 382);
    freq.put("nit", 197);
    freq.put("tol", 16);
    freq.put("Se ", 41);
    freq.put("j\u0302e", 53);
    freq.put("j\u0302a", 6);
    freq.put("tod", 8);
    freq.put(" le", 152);
    freq.put("B", 168);
    freq.put(" la", 3891);
    freq.put(" lo", 212);
    freq.put("ure", 35);
    freq.put(" li", 1300);
    freq.put("arp", 3);
    freq.put(" lu", 82);
    freq.put("dag\u0302", 5);
    freq.put("fic\u0302", 40);
    freq.put("ee ", 15);
    freq.put("Ses", 4);
    freq.put("ktu", 14);
    freq.put("to ", 699);
    freq.put("ktr", 15);
    freq.put("Sed", 146);
    freq.put("kti", 105);
    freq.put("Sen", 11);
    freq.put("Sem", 3);
    freq.put("c\u0302jo", 25);
    freq.put("Sek", 5);
    freq.put("kta", 36);
    freq.put("ktb", 5);
    freq.put("raf", 15);
    freq.put("rag", 126);
    freq.put("rad", 113);
    freq.put("lbr", 9);
    freq.put("rab", 36);
    freq.put("rac", 91);
    freq.put("ran", 579);
    freq.put("rs\u0302", 20);
    freq.put("ral", 10);
    freq.put("ram", 13);
    freq.put("raj", 115);
    freq.put("rak", 99);
    freq.put("ose", 19);
    freq.put("rav", 47);
    freq.put("rat", 125);
    freq.put("rar", 14);
    freq.put("ras", 184);
    freq.put("rap", 86);
    freq.put("laj\u0302", 26);
    freq.put("raz", 4);
    freq.put("ter", 458);
    freq.put("lbo", 83);
    freq.put("oc\u0302a", 7);
    freq.put("do ", 459);
    freq.put("isj\u0302", 4);
    freq.put("ens\u0302", 9);
    freq.put("og\u0302e", 15);
    freq.put("hum", 14);
    freq.put("hun", 26);
    freq.put("s\u0302ti", 3);
    freq.put("mba", 52);
    freq.put("s\u0302to", 36);
    freq.put("iss\u0302", 5);
    freq.put("aba", 19);
    freq.put("bst", 7);
    freq.put("rg\u0302", 36);
    freq.put("s\u0302te", 19);
    freq.put(" fi", 244);
    freq.put("bso", 4);
    freq.put("au\u0306g", 10);
    freq.put("bsk", 7);
    freq.put("bse", 24);
    freq.put("lc\u0302", 14);
    freq.put("rc\u0302", 38);
    freq.put("abe", 16);
    freq.put("rg\u0302a", 9);
    freq.put("dok", 138);
    freq.put("don", 386);
    freq.put("dol", 36);
    freq.put("dom", 123);
    freq.put("vis\u0302", 8);
    freq.put("lpu", 9);
    freq.put("m", 8816);
    freq.put("ac\u0302o", 8);
    freq.put("j\u0302on", 71);
    freq.put("lpo", 95);
    freq.put("lpl", 9);
    freq.put("lpi", 24);
    freq.put("abi", 34);
    freq.put("dor", 53);
    freq.put("ac\u0302i", 14);
    freq.put("lpe", 25);
    freq.put("epa", 9);
    freq.put("lpa", 34);
    freq.put("kut", 25);
    freq.put(" Wa", 38);
    freq.put("abl", 103);
    freq.put("ude", 31);
    freq.put("d ", 531);
    freq.put("kur", 128);
    freq.put("eal", 3);
    freq.put(" j\u0302e", 30);
    freq.put("kup", 20);
    freq.put("oci", 5);
    freq.put("jig\u0302", 8);
    freq.put("em ", 49);
    freq.put("oco", 16);
    freq.put("kun", 406);
    freq.put("oca", 7);
    freq.put("ac\u0302a", 4);
    freq.put("oce", 13);
    freq.put("S\u0302", 64);
    freq.put("eg\u0302e", 9);
    freq.put("kul", 186);
    freq.put("eg\u0302a", 7);
    freq.put("ba ", 4);
    freq.put("ngr", 37);
    freq.put("kuk", 4);
    freq.put("eg\u0302o", 37);
    freq.put("eg\u0302i", 5);
    freq.put("og\u0302i", 17);
    freq.put("abu", 11);
    freq.put("do", 1358);
    freq.put("dl", 40);
    freq.put("dm", 15);
    freq.put("dk", 5);
    freq.put(" W ", 4);
    freq.put("di", 2138);
    freq.put("dd", 22);
    freq.put("de", 2110);
    freq.put("da", 1149);
    freq.put("kug", 9);
    freq.put("dz", 107);
    freq.put("dv", 36);
    freq.put("du", 477);
    freq.put("dr", 70);
    freq.put("dp", 8);
    freq.put("eme", 175);
    freq.put("emd", 20);
    freq.put("bat", 94);
    freq.put("bar", 38);
    freq.put("bas", 12);
    freq.put("emb", 10);
    freq.put("Riv", 3);
    freq.put("emo", 70);
    freq.put("emi", 67);
    freq.put("emk", 3);
    freq.put("kub", 15);
    freq.put("bag", 6);
    freq.put("bad", 4);
    freq.put("emv", 3);
    freq.put("emp", 159);
    freq.put("ban", 24);
    freq.put("Rig", 8);
    freq.put("bal", 99);
    freq.put("bak", 16);
    freq.put("om ", 195);
    freq.put("med", 26);
    freq.put("nut", 60);
    freq.put("nur", 127);
    freq.put("nus", 18);
    freq.put("Per", 9);
    freq.put("nun", 185);
    freq.put("nuo", 13);
    freq.put("Pen", 5);
    freq.put("num", 26);
    freq.put("nuj", 14);
    freq.put("nuk", 3);
    freq.put("nui", 12);
    freq.put("nuf", 11);
    freq.put(" en", 989);
    freq.put("nub", 15);
    freq.put("Efe", 9);
    freq.put("nua", 37);
    freq.put("g\u0302et", 3);
    freq.put("is\u0302", 27);
    freq.put("kig\u0302", 54);
    freq.put("g\u0302er", 43);
    freq.put("irt", 4);
    freq.put("iru", 46);
    freq.put("muz", 22);
    freq.put("un ", 701);
    freq.put("iri", 838);
    freq.put("irk", 126);
    freq.put("irm", 27);
    freq.put("g\u0302ec", 7);
    freq.put("iro", 194);
    freq.put("g\u0302em", 11);
    freq.put("ira", 172);
    freq.put("g\u0302en", 13);
    freq.put("ird", 27);
    freq.put("ire", 42);
    freq.put("g\u0302ej", 15);
    freq.put("omb", 34);
    freq.put("C", 268);
    freq.put("men", 393);
    freq.put("wc", 12);
    freq.put("omf", 5);
    freq.put("ome", 159);
    freq.put(" Ir", 6);
    freq.put("omo", 268);
    freq.put(" Iu", 5);
    freq.put("eli", 159);
    freq.put(" Il", 43);
    freq.put("omv", 3);
    freq.put(" In", 7);
    freq.put(" Io", 6);
    freq.put(" Ia", 8);
    freq.put("mej", 25);
    freq.put("nu ", 245);
    freq.put("unp", 18);
    freq.put("ild", 10);
    freq.put("ile", 140);
    freq.put("ig\u0302", 646);
    freq.put("unu", 291);
    freq.put("unv", 4);
    freq.put("ila", 155);
    freq.put("ilo", 244);
    freq.put("ilk", 5);
    freq.put("ilh", 12);
    freq.put("ili", 649);
    freq.put("ic\u0302", 152);
    freq.put("una", 89);
    freq.put("unb", 5);
    freq.put("ilu", 7);
    freq.put("und", 87);
    freq.put("g\u0302e ", 17);
    freq.put("ilp", 3);
    freq.put("ung", 7);
    freq.put("uni", 16);
    freq.put("coj", 43);
    freq.put("com", 12);
    freq.put("unm", 3);
    freq.put("con", 84);
    freq.put("sak", 11);
    freq.put(" ma", 1212);
    freq.put("ane", 17);
    freq.put(" mo", 420);
    freq.put(" mi", 2324);
    freq.put(" mu", 219);
    freq.put("fit", 9);
    freq.put("ele", 80);
    freq.put("dau\u0306", 142);
    freq.put("ana", 57);
    freq.put("fra", 112);
    freq.put("baj\u0302", 6);
    freq.put("che", 158);
    freq.put("fre", 124);
    freq.put("lti", 70);
    freq.put("fri", 7);
    freq.put("C ", 5);
    freq.put("fro", 17);
    freq.put(" ek", 347);
    freq.put("fru", 31);
    freq.put("mez", 25);
    freq.put("akz", 3);
    freq.put("pri", 354);
    freq.put("Cer", 6);
    freq.put("kte", 54);
    freq.put("Cra", 123);
    freq.put("ank", 502);
    freq.put("elp", 100);
    freq.put("ant", 894);
    freq.put("enk", 85);
    freq.put("Cl", 125);
    freq.put("Ce", 9);
    freq.put("n", 21624);
    freq.put("ain", 86);
    freq.put("elt", 62);
    freq.put("akr", 11);
    freq.put("Cr", 124);
    freq.put("bau\u0306", 49);
    freq.put("gno", 57);
    freq.put("s\u0302so", 3);
    freq.put("us\u0302", 111);
    freq.put("iz", 207);
    freq.put("mus\u0302", 4);
    freq.put("ip", 311);
    freq.put("is", 5604);
    freq.put("ir", 1481);
    freq.put("iu", 1354);
    freq.put("it", 939);
    freq.put("akv", 16);
    freq.put("ii", 180);
    freq.put("ih", 5);
    freq.put("Nap", 12);
    freq.put("Dio", 57);
    freq.put("im", 453);
    freq.put("il", 1257);
    freq.put("io", 1424);
    freq.put("in", 3062);
    freq.put("ia", 2858);
    freq.put("ic", 94);
    freq.put("ki ", 35);
    freq.put("ie", 1301);
    freq.put("id", 670);
    freq.put("ig", 1088);
    freq.put("if", 74);
    freq.put("V ", 8);
    freq.put("Tro", 7);
    freq.put("s\u0302e ", 5);
    freq.put("rna", 46);
    freq.put("ep ", 4);
    freq.put("Tiu", 37);
    freq.put(" g\u0302u", 27);
    freq.put("nii", 8);
    freq.put("nin", 80);
    freq.put("nio", 108);
    freq.put("nil", 9);
    freq.put("nim", 39);
    freq.put("kis", 103);
    freq.put("kir", 24);
    freq.put("nia", 219);
    freq.put("nif", 13);
    freq.put("nig", 95);
    freq.put("kiu", 553);
    freq.put("kit", 19);
    freq.put(" g\u0302e", 11);
    freq.put("kio", 207);
    freq.put("kin", 16);
    freq.put("kil", 13);
    freq.put("nir", 50);
    freq.put("i ", 7097);
    freq.put("kia", 269);
    freq.put(" g\u0302o", 65);
    freq.put("kig", 20);
    freq.put(" g\u0302i", 662);
    freq.put("kie", 442);
    freq.put("niu", 43);
    freq.put("Ve", 52);
    freq.put("s\u0302er", 8);
    freq.put("Vi", 287);
    freq.put("ept", 33);
    freq.put(" L ", 5);
    freq.put("epr", 35);
    freq.put("Vo", 4);
    freq.put("epo", 9);
    freq.put("s\u0302el", 3);
    freq.put("tha", 7);
    freq.put("s\u0302ej", 4);
    freq.put("vic", 15);
    freq.put("via", 85);
    freq.put(" C\u0302a", 22);
    freq.put("vig", 56);
    freq.put("elk", 109);
    freq.put("hak", 14);
    freq.put("hal", 22);
    freq.put("elo", 149);
    freq.put("ell", 10);
    freq.put("elm", 24);
    freq.put("elb", 8);
    freq.put("ela", 105);
    freq.put("elf", 16);
    freq.put("hae", 16);
    freq.put("eld", 11);
    freq.put("bis", 28);
    freq.put("haz", 3);
    freq.put("Dir", 8);
    freq.put("elr", 20);
    freq.put("els", 16);
    freq.put("har", 23);
    freq.put("elv", 20);
    freq.put("s\u0302uo", 4);
    freq.put("hav", 249);
    freq.put("elu", 4);
    freq.put("Tri", 7);
    freq.put("rni", 47);
    freq.put("rno", 34);
    freq.put("D", 163);
    freq.put("opr", 57);
    freq.put("rnb", 3);
    freq.put("gig\u0302", 13);
    freq.put("Tre", 5);
    freq.put("rne", 37);
    freq.put("opl", 3);
    freq.put("opo", 21);
    freq.put("opi", 49);
    freq.put("vis", 427);
    freq.put("ha ", 33);
    freq.put("el ", 776);
    freq.put("Ark", 4);
    freq.put("ola", 144);
    freq.put("old", 11);
    freq.put("Jed", 22);
    freq.put("olf", 5);
    freq.put(" Ju", 6);
    freq.put("oli", 145);
    freq.put("Tom", 6);
    freq.put("olo", 94);
    freq.put(" Jo", 10);
    freq.put("olt", 9);
    freq.put("ns\u0302", 18);
    freq.put("olv", 16);
    freq.put(" Je", 121);
    freq.put(" Ja", 51);
    freq.put("umt", 5);
    freq.put("ici", 11);
    freq.put("S ", 6);
    freq.put("ico", 22);
    freq.put("ump", 3);
    freq.put("for", 354);
    freq.put("fos", 27);
    freq.put("ica", 3);
    freq.put("reg\u0302", 26);
    freq.put("Hv", 7);
    freq.put("ice", 40);
    freq.put("Hu", 4);
    freq.put("ume", 36);
    freq.put("zu ", 3);
    freq.put("Hi", 10);
    freq.put("uma", 35);
    freq.put("Ho", 65);
    freq.put("umb", 4);
    freq.put("fol", 26);
    freq.put("fon", 28);
    freq.put("Ha", 27);
    freq.put("umi", 39);
    freq.put("foj", 106);
    freq.put("He", 11);
    freq.put("ol ", 99);
    freq.put("nc\u0302", 53);
    freq.put("plu", 75);
    freq.put("Tur", 12);
    freq.put("ple", 230);
    freq.put("ng\u0302", 148);
    freq.put("pla", 57);
    freq.put("plo", 30);
    freq.put("pli", 288);
    freq.put("zur", 13);
    freq.put("zus", 3);
    freq.put("obl", 19);
    freq.put("ug\u0302a", 35);
    freq.put("obi", 4);
    freq.put("ug\u0302o", 4);
    freq.put("obe", 7);
    freq.put("ug\u0302i", 17);
    freq.put("o", 21593);
    freq.put("oba", 5);
    freq.put("ug\u0302u", 6);
    freq.put("fo ", 39);
    freq.put("um ", 69);
    freq.put("eeb", 3);
    freq.put("obs", 26);
    freq.put("zul", 9);
    freq.put("soc", 5);
    freq.put("mbo", 11);
    freq.put("soi", 4);
    freq.put("soj", 35);
    freq.put("som", 5);
    freq.put("sol", 68);
    freq.put("son", 138);
    freq.put("sop", 9);
    freq.put("sos", 17);
    freq.put("sor", 31);
    freq.put("efo", 23);
    freq.put("sov", 41);
    freq.put("uno", 37);
    freq.put("mbr", 64);
    freq.put("ole", 84);
    freq.put("tem", 172);
    freq.put("art", 140);
    freq.put("git", 137);
    freq.put("gis", 338);
    freq.put("gir", 6);
    freq.put("gig", 6);
    freq.put("gid", 8);
    freq.put("gio", 5);
    freq.put("gin", 19);
    freq.put("gil", 28);
    freq.put("so ", 92);
    freq.put("u\u0306pa", 8);
    freq.put("u\u0306pr", 14);
    freq.put("deg", 19);
    freq.put("Z", 14);
    freq.put("ura", 99);
    freq.put("azi", 44);
    freq.put("azo", 40);
    freq.put("aza", 86);
    freq.put("aze", 15);
    freq.put("mtu", 3);
    freq.put("Vor", 3);
    freq.put("gi ", 201);
    freq.put("mta", 3);
    freq.put("elj\u0302", 8);
    freq.put("nno", 5);
    freq.put(" n ", 7);
    freq.put("j\u0302us", 11);
    freq.put("j\u0302ur", 9);
    freq.put("uvi", 3);
    freq.put("D ", 4);
    freq.put("tea", 4);
    freq.put("kha", 3);
    freq.put("c\u0302ir", 113);
    freq.put("Sin", 46);
    freq.put("Sim", 5);
    freq.put("Sil", 4);
    freq.put("nh", 36);
    freq.put("ni", 2004);
    freq.put("nj", 342);
    freq.put("nk", 721);
    freq.put("nl", 30);
    freq.put("nm", 61);
    freq.put("nn", 7);
    freq.put("no", 1554);
    freq.put("tit", 68);
    freq.put("na", 967);
    freq.put("nb", 26);
    freq.put("nc", 428);
    freq.put("nd", 1015);
    freq.put("ne", 1619);
    freq.put("nf", 139);
    freq.put("ng", 409);
    freq.put("til", 36);
    freq.put("tim", 130);
    freq.put("nz", 8);
    freq.put("tio", 347);
    freq.put("tik", 29);
    freq.put("np", 63);
    freq.put("tie", 430);
    freq.put("nr", 24);
    freq.put("ns", 518);
    freq.put("nt", 2159);
    freq.put("nu", 854);
    freq.put("nv", 89);
    freq.put(" ni", 466);
    freq.put("kve", 23);
    freq.put("E", 142);
    freq.put(" no", 193);
    freq.put("kva", 179);
    freq.put(" na", 86);
    freq.put("kvo", 15);
    freq.put(" ne", 1165);
    freq.put("kvi", 170);
    freq.put("mun", 7);
    freq.put("ich", 17);
    freq.put("tec", 36);
    freq.put("nko", 270);
    freq.put(" nu", 326);
    freq.put("ns\u0302a", 10);
    freq.put("n ", 7828);
    freq.put("olc\u0302", 11);
    freq.put("dic", 5);
    freq.put("nic", 3);
    freq.put("nkr", 3);
    freq.put("ns\u0302i", 3);
    freq.put("fsp", 3);
    freq.put("nkt", 15);
    freq.put("ti ", 222);
    freq.put("nku", 34);
    freq.put("roj", 399);
    freq.put("rok", 111);
    freq.put("rol", 154);
    freq.put("rom", 93);
    freq.put("ron", 365);
    freq.put("roa", 3);
    freq.put("rob", 9);
    freq.put("roc", 12);
    freq.put("rod", 5);
    freq.put("ost", 242);
    freq.put("rof", 55);
    freq.put("rog", 11);
    freq.put("ag\u0302i", 51);
    freq.put("lli", 15);
    freq.put("llo", 21);
    freq.put("ag\u0302o", 131);
    freq.put("rop", 51);
    freq.put("ror", 4);
    freq.put("ros", 76);
    freq.put("rot", 16);
    freq.put("rov", 193);
    freq.put("vet", 105);
    freq.put("gu ", 46);
    freq.put("ver", 191);
    freq.put("ves", 72);
    freq.put("Dan", 4);
    freq.put("di ", 187);
    freq.put("kg\u0302e", 3);
    freq.put("caj\u0302", 11);
    freq.put("Ec\u0302 ", 4);
    freq.put("umf", 6);
    freq.put("ven", 370);
    freq.put("vel", 51);
    freq.put("vem", 4);
    freq.put("vej", 3);
    freq.put("vek", 14);
    freq.put("lra", 22);
    freq.put("me", 1001);
    freq.put("lre", 3);
    freq.put("ey ", 154);
    freq.put("ro ", 1207);
    freq.put("s\u0302ra", 5);
    freq.put("mf", 15);
    freq.put("lru", 3);
    freq.put("erp", 20);
    freq.put("ll ", 5);
    freq.put("umo", 80);
    freq.put("dil", 15);
    freq.put("ry", 3);
    freq.put("din", 51);
    freq.put("dio", 9);
    freq.put("dik", 32);
    freq.put("did", 3);
    freq.put("s\u0302s\u0302t", 3);
    freq.put("dif", 26);
    freq.put("ers", 53);
    freq.put("dia", 67);
    freq.put("gum", 8);
    freq.put("gul", 23);
    freq.put("gus", 27);
    freq.put("p", 6545);
    freq.put("Tag", 6);
    freq.put("ve ", 106);
    freq.put("gut", 5);
    freq.put("dit", 56);
    freq.put("Tam", 32);
    freq.put("div", 43);
    freq.put("fok", 3);
    freq.put("der", 15);
    freq.put("dir", 634);
    freq.put("dis", 858);
    freq.put("c\u0302le", 5);
    freq.put("maj\u0302", 17);
    freq.put("be", 284);
    freq.put("Res", 4);
    freq.put("Rev", 4);
    freq.put("dev", 118);
    freq.put("Gra", 91);
    freq.put("ufl", 12);
    freq.put("ba", 355);
    freq.put("mu", 306);
    freq.put("ere", 231);
    freq.put("ufo", 22);
    freq.put("mag\u0302", 3);
    freq.put("dzi", 78);
    freq.put("sj\u0302", 4);
    freq.put("ek ", 79);
    freq.put("bl", 386);
    freq.put("erg", 4);
    freq.put("bo ", 75);
    freq.put("del", 42);
    freq.put("era", 172);
    freq.put("Me", 4);
    freq.put("bo", 762);
    freq.put("Ma", 157);
    freq.put("erb", 41);
    freq.put("ss\u0302", 6);
    freq.put("kst", 80);
    freq.put("Mo", 11);
    freq.put("v", 4740);
    freq.put("Mi", 503);
    freq.put("bi", 149);
    freq.put("Mu", 10);
    freq.put("O", 29);
    freq.put("Mr", 5);
    freq.put("rue", 15);
    freq.put("ern", 81);
    freq.put("ksp", 10);
    freq.put("eko", 62);
    freq.put("bt", 12);
    freq.put("ekm", 4);
    freq.put("ekl", 10);
    freq.put("ekk", 52);
    freq.put("eki", 37);
    freq.put("ekh", 3);
    freq.put("ekf", 7);
    freq.put("bor", 113);
    freq.put("ekd", 30);
    freq.put("bot", 14);
    freq.put("ekb", 14);
    freq.put("bov", 7);
    freq.put("boj", 54);
    freq.put("bol", 5);
    freq.put("ekz", 14);
    freq.put("bon", 357);
    freq.put("boa", 122);
    freq.put("eku", 16);
    freq.put("ekt", 198);
    freq.put("eks", 137);
    freq.put("ekr", 27);
    freq.put("ekp", 14);
    freq.put("ipb", 6);
    freq.put("ipa", 32);
    freq.put("ipf", 4);
    freq.put("Bon", 18);
    freq.put("ipe", 70);
    freq.put("ipi", 10);
    freq.put("ipo", 157);
    freq.put("jas", 6);
    freq.put("ipr", 27);
    freq.put("ec\u0302 ", 49);
    freq.put("loz", 13);
    freq.put("Lia", 20);
    freq.put("are", 69);
    freq.put("jan", 6);
    freq.put(" Ka", 188);
    freq.put(" Ke", 16);
    freq.put(" Ki", 180);
    freq.put(" Ko", 31);
    freq.put(" Kl", 5);
    freq.put(" Kr", 32);
    freq.put(" Kv", 11);
    freq.put(" Ku", 13);
    freq.put(" il", 570);
    freq.put("ca ", 32);
    freq.put("ug\u0302e", 7);
    freq.put("Mia", 31);
    freq.put("Ben", 23);
    freq.put("ksc", 30);
    freq.put("F", 73);
    freq.put("Dac\u0302", 5);
    freq.put("ma ", 115);
    freq.put("u\u0306to", 4);
    freq.put("len", 134);
    freq.put("ec\u0302i", 3);
    freq.put("obj", 15);
    freq.put("kso", 18);
    freq.put("ec\u0302o", 3);
    freq.put("roc\u0302", 13);
    freq.put("lmu", 19);
    freq.put("ibo", 9);
    freq.put("cas", 23);
    freq.put("iba", 4);
    freq.put("ulp", 21);
    freq.put("flu", 51);
    freq.put("ibe", 48);
    freq.put("ult", 224);
    freq.put("Sur", 12);
    freq.put("caj", 12);
    freq.put("uli", 50);
    freq.put("can", 22);
    freq.put("flo", 39);
    freq.put("ulm", 4);
    freq.put("fla", 103);
    freq.put("ibr", 39);
    freq.put("ula", 27);
    freq.put("fle", 4);
    freq.put("ulg", 6);
    freq.put(" od", 4);
    freq.put("cad", 29);
    freq.put(" on", 120);
    freq.put(" ol", 103);
    freq.put(" om", 12);
    freq.put(" ok", 194);
    freq.put("ger", 10);
    freq.put(" of", 42);
    freq.put("spr", 29);
    freq.put("uan", 25);
    freq.put(" ob", 44);
    freq.put("spu", 10);
    freq.put("spi", 29);
    freq.put("ekg\u0302", 5);
    freq.put("og\u0302a", 16);
    freq.put("spl", 5);
    freq.put("spo", 132);
    freq.put("spa", 28);
    freq.put("Mis", 3);
    freq.put(" or", 108);
    freq.put("spe", 159);
    freq.put(" op", 41);
    freq.put("H", 127);
    freq.put("s ", 7815);
    freq.put("mas", 87);
    freq.put("mar", 155);
    freq.put("mat", 73);
    freq.put("Urb", 7);
    freq.put("Mi ", 417);
    freq.put("naj\u0302", 18);
    freq.put("enb", 9);
    freq.put(" o ", 4);
    freq.put("uga", 8);
    freq.put("snu", 6);
    freq.put("G\u0302i ", 43);
    freq.put("mad", 20);
    freq.put("mag", 17);
    freq.put("neg", 41);
    freq.put("mak", 7);
    freq.put("maj", 55);
    freq.put("mal", 862);
    freq.put("man", 440);
    freq.put("ls\u0302i", 6);
    freq.put("ss", 6);
    freq.put("sr", 8);
    freq.put("sp", 392);
    freq.put("sv", 10);
    freq.put("su", 920);
    freq.put("st", 2522);
    freq.put("sk", 272);
    freq.put("enh", 24);
    freq.put("si", 1513);
    freq.put("sh", 5);
    freq.put("so", 455);
    freq.put("sn", 6);
    freq.put("sm", 4);
    freq.put("sl", 3);
    freq.put("sc", 290);
    freq.put("sa", 462);
    freq.put("sf", 3);
    freq.put("se", 1147);
    freq.put("sd", 17);
    freq.put("zau\u0306", 75);
    freq.put("lsa", 43);
    freq.put("lso", 4);
    freq.put("no ", 597);
    freq.put("enm", 45);
    freq.put("Re", 14);
    freq.put("lst", 5);
    freq.put("Jam", 4);
    freq.put("Ra", 5);
    freq.put("lsp", 3);
    freq.put("Jaf", 13);
    freq.put("Ro", 14);
    freq.put("Ri", 17);
    freq.put("iau\u0306", 54);
    freq.put("jig", 7);
    freq.put(" ab", 10);
    freq.put(" ad", 57);
    freq.put("gte", 4);
    freq.put(" af", 92);
    freq.put(" ag", 37);
    freq.put(" aj", 44);
    freq.put(" ak", 63);
    freq.put(" al", 1368);
    freq.put(" am", 244);
    freq.put(" an", 451);
    freq.put(" ap", 121);
    freq.put("Uso", 4);
    freq.put(" ar", 106);
    freq.put(" as", 5);
    freq.put(" at", 123);
    freq.put("jis", 13);
    freq.put(" av", 9);
    freq.put("ons\u0302", 9);
    freq.put("ent", 533);
    freq.put("gel", 3);
    freq.put("nom", 79);
    freq.put("non", 269);
    freq.put("noj", 237);
    freq.put("nok", 84);
    freq.put("kku", 3);
    freq.put("nob", 8);
    freq.put("kkr", 40);
    freq.put("ert", 110);
    freq.put("kko", 5);
    freq.put("nov", 150);
    freq.put("zaj\u0302", 11);
    freq.put("kka", 3);
    freq.put("Ja ", 7);
    freq.put("nos", 60);
    freq.put("eru", 34);
    freq.put("zag\u0302", 99);
    freq.put("au\u0306s\u0302", 6);
    freq.put("Au\u0306 ", 4);
    freq.put("ndu", 86);
    freq.put("tse", 4);
    freq.put("fen", 32);
    freq.put("em", 714);
    freq.put("el", 1749);
    freq.put("eo", 70);
    freq.put("en", 4142);
    freq.put("ei", 34);
    freq.put("eh", 3);
    freq.put("ek", 842);
    freq.put("ej", 298);
    freq.put("ee", 47);
    freq.put("ed", 862);
    freq.put("eg", 368);
    freq.put("ef", 102);
    freq.put("ea", 30);
    freq.put("ec", 313);
    freq.put("eb", 214);
    freq.put("Du ", 7);
    freq.put("ey", 158);
    freq.put("ez", 240);
    freq.put("et", 886);
    freq.put("ew", 13);
    freq.put("ev", 386);
    freq.put("g\u0302", 2132);
    freq.put("ep", 96);
    freq.put("es", 2234);
    freq.put("er", 1966);
    freq.put("ejl", 22);
    freq.put("ejm", 47);
    freq.put("ejn", 4);
    freq.put("ejo", 118);
    freq.put("laj", 70);
    freq.put("blu", 16);
    freq.put("eje", 4);
    freq.put("lak", 13);
    freq.put("eja", 8);
    freq.put("C\u0302i ", 3);
    freq.put("blo", 60);
    freq.put("bli", 18);
    freq.put("ble", 166);
    freq.put("bla", 126);
    freq.put("Jon", 3);
    freq.put("rlo", 52);
    freq.put("tfl", 7);
    freq.put("rli", 9);
    freq.put("G", 115);
    freq.put("rle", 3);
    freq.put("ort", 465);
    freq.put("oru", 5);
    freq.put("rla", 40);
    freq.put("e ", 6350);
    freq.put("orp", 41);
    freq.put("orn", 18);
    freq.put("oro", 619);
    freq.put("orl", 42);
    freq.put("G\u0302us", 3);
    freq.put("ork", 43);
    freq.put("ori", 180);
    freq.put("orf", 20);
    freq.put("org", 80);
    freq.put("ord", 210);
    freq.put("ore", 71);
    freq.put("s\u0302", 1278);
    freq.put("lme", 26);
    freq.put("saj\u0302", 5);
    freq.put("ora", 217);
    freq.put("C\u0302ir", 3);
    freq.put("C\u0302iu", 17);
    freq.put("mos", 9);
    freq.put("ej ", 74);
    freq.put("anc\u0302", 48);
    freq.put("Ke ", 7);
    freq.put("Jo ", 5);
    freq.put("C\u0302ia", 9);
    freq.put("ova", 286);
    freq.put("sag\u0302", 36);
    freq.put("ang\u0302", 130);
    freq.put(" ce", 138);
    freq.put("C\u0302in", 3);
    freq.put("C\u0302io", 9);
    freq.put("zan", 12);
    freq.put("onk", 43);
    freq.put("onh", 8);
    freq.put("oni", 299);
    freq.put("zaj", 13);
    freq.put("ono", 228);
    freq.put("onm", 10);
    freq.put("au\u0306 ", 840);
    freq.put("zad", 8);
    freq.put("ona", 289);
    freq.put("nac\u0302", 4);
    freq.put("ong", 123);
    freq.put("ond", 265);
    freq.put("one", 159);
    freq.put("mel", 7);
    freq.put("ons", 136);
    freq.put("onp", 5);
    freq.put("zar", 5);
    freq.put("G\u0302", 64);
    freq.put("ont", 335);
    freq.put("onu", 35);
    freq.put("iam", 613);
    freq.put("ial", 161);
    freq.put("ian", 481);
    freq.put("iaj", 408);
    freq.put("iad", 5);
    freq.put("iaf", 26);
    freq.put(" au\u0306", 214);
    freq.put("iab", 7);
    freq.put("uko", 21);
    freq.put("lnu", 3);
    freq.put("ule", 12);
    freq.put("uki", 27);
    freq.put("iat", 5);
    freq.put("efl", 6);
    freq.put("iav", 4);
    freq.put("ukc", 24);
    freq.put("iap", 5);
    freq.put("ias", 112);
    freq.put("iar", 4);
    freq.put("au\u0306i", 12);
    freq.put("au\u0306k", 4);
    freq.put("au\u0306m", 7);
    freq.put("au\u0306l", 33);
    freq.put("au\u0306n", 5);
    freq.put("au\u0306a", 42);
    freq.put(" ac\u0302", 11);
    freq.put("r ", 1514);
    freq.put("au\u0306b", 4);
    freq.put("au\u0306e", 108);
    freq.put("au\u0306d", 96);
    freq.put("za ", 39);
    freq.put("au\u0306f", 3);
    freq.put("au\u0306z", 41);
    freq.put(" Zu", 13);
    freq.put("au\u0306p", 26);
    freq.put("au\u0306s", 43);
    freq.put("au\u0306r", 77);
    freq.put("au\u0306t", 58);
    freq.put("au\u0306v", 10);
    freq.put("bte", 10);
    freq.put("nc\u0302i", 26);
    freq.put("nc\u0302o", 16);
    freq.put("nc\u0302l", 5);
    freq.put("ia ", 890);
    freq.put("r", 15541);
    freq.put(" aj\u0302", 5);
    freq.put("Jac\u0302", 20);
    freq.put("Bik", 8);
    freq.put("pre", 465);
    freq.put("saj", 21);
    freq.put("anf", 8);
    freq.put("ang", 115);
    freq.put("pra", 64);
    freq.put("san", 76);
    freq.put("sam", 86);
    freq.put("sal", 54);
    freq.put("sab", 13);
    freq.put("pro", 435);
    freq.put("ano", 284);
    freq.put("sag", 8);
    freq.put("ani", 143);
    freq.put("edi", 54);
    freq.put("sad", 19);
    freq.put("pru", 27);
    freq.put("anu", 20);
    freq.put("anp", 3);
    freq.put("egu", 14);
    freq.put("ans", 43);
    freq.put("sas", 75);
    freq.put("sar", 6);
    freq.put("sap", 5);
    freq.put("sav", 19);
    freq.put("anz", 3);
    freq.put("sat", 7);
    freq.put("Do", 5);
    freq.put("zof", 13);
    freq.put("Di", 72);
    freq.put("zoj", 22);
    freq.put("De", 37);
    freq.put("zon", 92);
    freq.put("Da", 10);
    freq.put("es\u0302", 40);
    freq.put("zor", 37);
    freq.put("zos", 6);
    freq.put("orc\u0302", 8);
    freq.put("Du", 25);
    freq.put("Dr", 3);
    freq.put("wco", 12);
    freq.put("an ", 915);
    freq.put("tiu", 439);
    freq.put("sa ", 17);
    freq.put("ej\u0302", 6);
    freq.put("zo ", 97);
    freq.put(" Le", 11);
    freq.put("ors\u0302", 3);
    freq.put("ec\u0302", 60);
    freq.put("dle", 38);
    freq.put(" La", 213);
    freq.put(" Lo", 9);
    freq.put(" Li", 179);
    freq.put("eg\u0302", 59);
    freq.put("diz", 7);
    freq.put("zec", 3);
    freq.put("tko", 4);
    freq.put("nla", 3);
    freq.put(" p ", 6);
    freq.put("nle", 5);
    freq.put("nli", 17);
    freq.put("Sko", 5);
    freq.put("uf", 90);
    freq.put("nlo", 3);
    freq.put("pos\u0302", 19);
    freq.put("Wa", 38);
    freq.put("ce ", 108);
    freq.put("erd", 72);
    freq.put("ges", 30);
    freq.put(" pr", 833);
    freq.put(" pu", 44);
    freq.put("get", 3);
    freq.put("ng\u0302i", 45);
    freq.put("gec", 6);
    freq.put("geb", 3);
    freq.put(" pa", 546);
    freq.put("geg", 4);
    freq.put("zel", 3);
    freq.put(" pe", 603);
    freq.put("sse", 5);
    freq.put("j\u0302et", 50);
    freq.put(" pi", 78);
    freq.put(" po", 1252);
    freq.put("gen", 46);
    freq.put("RI ", 4);
    freq.put(" pl", 617);
    freq.put("W ", 4);
    freq.put("ute", 140);
    freq.put("u\u0306lo", 19);
    freq.put("Tim", 3);
    freq.put("lum", 84);
    freq.put("uti", 59);
    freq.put("rmv", 3);
    freq.put("rmu", 23);
    freq.put("c\u0302", 1964);
    freq.put("uvo", 12);
    freq.put("pas\u0302", 20);
    freq.put("uto", 70);
    freq.put("lno", 49);
    freq.put("rma", 83);
    freq.put("alg", 82);
    freq.put("rme", 98);
    freq.put("tu ", 71);
    freq.put("rmi", 67);
    freq.put("j ", 5023);
    freq.put("rmo", 64);
    freq.put("ge ", 140);
    freq.put("utr", 30);
    freq.put("vu ", 23);
    freq.put("cir", 12);
    freq.put("unr", 4);
    freq.put("tup", 12);
    freq.put("jto", 8);
    freq.put("cip", 23);
    freq.put("jti", 4);
    freq.put("jta", 4);
    freq.put("pau\u0306", 5);
    freq.put("civ", 4);
    freq.put("fir", 16);
    freq.put("tuz", 6);
    freq.put("tus", 107);
    freq.put("ciu", 4);
    freq.put("jt", 16);
    freq.put("ju", 148);
    freq.put("tur", 166);
    freq.put("utu", 3);
    freq.put("jp", 5);
    freq.put("jr", 38);
    freq.put("Kru", 14);
    freq.put("jl", 37);
    freq.put("jm", 47);
    freq.put("jn", 1375);
    freq.put("jo", 625);
    freq.put("g\u0302aj\u0302", 10);
    freq.put("ji", 30);
    freq.put("tun", 12);
    freq.put("jk", 4);
    freq.put("jd", 4);
    freq.put("je", 314);
    freq.put("tub", 6);
    freq.put("tud", 5);
    freq.put("ja", 275);
    freq.put("Kre", 4);
    freq.put(" be", 148);
    freq.put("lov", 24);
    freq.put("z", 1004);
    freq.put(" ba", 215);
    freq.put("paj\u0302", 3);
    freq.put("vun", 9);
    freq.put(" bl", 61);
    freq.put(" bo", 386);
    freq.put(" bi", 44);
    freq.put("vra", 4);
    freq.put(" bu", 38);
    freq.put("s", 16342);
    freq.put("Kri", 11);
    freq.put("iv", 307);
    freq.put("vus", 90);
    freq.put(" br", 162);
    freq.put("tul", 33);
    freq.put("mte", 7);
    freq.put("tum", 10);
    freq.put("poz", 23);
    freq.put("pov", 354);
    freq.put("C\u0302", 168);
    freq.put("pot", 9);
    freq.put("s\u0302pa", 9);
    freq.put("por", 790);
    freq.put("pos", 200);
    freq.put("pon", 291);
    freq.put("Ant", 10);
    freq.put("pol", 18);
    freq.put("pom", 12);
    freq.put("poj", 42);
    freq.put("tua", 4);
    freq.put("pof", 5);
    freq.put("pog", 8);
    freq.put("pod", 7);
    freq.put("poe", 3);
    freq.put("C\u0302ar", 22);
    freq.put("fic", 12);
    freq.put("vro", 11);
    freq.put("ei ", 4);
    freq.put("erm", 70);
    freq.put("uoj", 15);
    freq.put("po ", 215);
    freq.put("eis", 10);
    freq.put("eir", 11);
    freq.put("eit", 5);
    freq.put("NO ", 3);
    freq.put("uon", 45);
    freq.put("vul", 4);
    freq.put("ive", 118);
    freq.put("iva", 39);
    freq.put("ivm", 3);
    freq.put("ivo", 89);
    freq.put("ivi", 45);
    freq.put("g\u0302an", 48);
    freq.put("ivu", 6);
    freq.put("g\u0302as", 82);
    freq.put("g\u0302ar", 24);
    freq.put("S\u0302i ", 42);
    freq.put("Tio", 64);
    freq.put("okt", 215);
    freq.put("pap", 30);
    freq.put(" Me", 4);
    freq.put("par", 323);
    freq.put("pas", 61);
    freq.put("pat", 77);
    freq.put(" Ma", 157);
    freq.put("ulj", 3);
    freq.put(" Mo", 11);
    freq.put(" Mi", 503);
    freq.put(" Mu", 10);
    freq.put("pab", 14);
    freq.put("pac", 45);
    freq.put("pad", 11);
    freq.put(" Mr", 5);
    freq.put("pag", 13);
    freq.put("I ", 4);
    freq.put("paj", 11);
    freq.put("pak", 6);
    freq.put("pal", 17);
    freq.put("Leo", 8);
    freq.put("pan", 105);
    freq.put("nab", 69);
    freq.put("cel", 33);
    freq.put("nac", 14);
    freq.put("I", 82);
    freq.put("oif", 4);
    freq.put("dka", 5);
    freq.put("ruc\u0302", 4);
    freq.put("S\u0302ia", 5);
    freq.put("mpa", 74);
    freq.put("tus\u0302", 21);
    freq.put("Ir", 6);
    freq.put("Iu", 5);
    freq.put("pa ", 10);
    freq.put("ujn", 87);
    freq.put("ujo", 37);
    freq.put("Il", 43);
    freq.put("Io", 6);
    freq.put("In", 7);
    freq.put("Ia", 8);
    freq.put("ces", 61);
    freq.put("uja", 8);
    freq.put("am ", 657);
    freq.put("ch", 177);
    freq.put("tir", 30);
    freq.put("Vi ", 186);
    freq.put("co", 368);
    freq.put("Sni", 158);
    freq.put("tin", 211);
    freq.put(" ge", 48);
    freq.put("uig", 5);
    freq.put("jug\u0302", 24);
    freq.put("ami", 141);
    freq.put("pso", 6);
    freq.put("amo", 55);
    freq.put("amn", 4);
    freq.put("ama", 151);
    freq.put("mor", 205);
    freq.put("rug\u0302", 37);
    freq.put("ame", 121);
    freq.put("mov", 38);
    freq.put("mok", 8);
    freq.put("moj", 137);
    freq.put("mon", 341);
    freq.put("mom", 32);
    freq.put("mol", 5);
    freq.put("amp", 56);
    freq.put("amu", 10);
    freq.put("amt", 5);
    freq.put("log\u0302", 51);
    freq.put("aj\u0302a", 4);
    freq.put("tig", 114);
    freq.put("aj\u0302e", 4);
    freq.put("ej\u0302e", 3);
    freq.put("aj\u0302o", 338);
    freq.put("tia", 284);
    freq.put("t", 13085);
    freq.put("Man", 5);
    freq.put("Nen", 28);
    freq.put("s\u0302a ", 5);
    freq.put("Nek", 3);
    freq.put("ezu", 21);
    freq.put("au\u0306", 1495);
    freq.put("Kur", 4);
    freq.put("omp", 171);
    freq.put("Kun", 7);
    freq.put("ezo", 64);
    freq.put("ezi", 90);
    freq.put("New", 13);
    freq.put("eza", 17);
    freq.put("mus", 12);
    freq.put("Lau\u0306", 7);
    freq.put("gvi", 6);
    freq.put("gvo", 14);
    freq.put("kmo", 3);
    freq.put("gva", 11);
    freq.put("gve", 5);
    freq.put("Iom", 5);
    freq.put("uo ", 36);
    freq.put("j\u0302", 424);
    freq.put("cu", 7);
    freq.put("ddl", 22);
    freq.put("as\u0302", 62);
    freq.put("mur", 62);
    freq.put("s\u0302af", 3);
    freq.put("mpi", 43);
    freq.put("zit", 30);
    freq.put("s\u0302al", 5);
    freq.put("Ne ", 74);
    freq.put("s\u0302an", 63);
    freq.put("s\u0302as", 18);
    freq.put("s\u0302ar", 19);
    freq.put("aj\u0302", 350);
    freq.put("s\u0302at", 18);
    freq.put("nma", 30);
    freq.put("nmo", 16);
    freq.put("nmi", 6);
    freq.put("oo", 3);
    freq.put("on", 4927);
    freq.put("om", 954);
    freq.put("sra", 3);
    freq.put("ok", 696);
    freq.put("oj", 2547);
    freq.put("oi", 8);
    freq.put("ac\u0302", 70);
    freq.put("of", 134);
    freq.put("oe", 5);
    freq.put("od", 91);
    freq.put("oc", 41);
    freq.put("sro", 4);
    freq.put("oa", 128);
    freq.put("oz", 87);
    freq.put("ov", 857);
    freq.put("ot", 65);
    freq.put("ag\u0302", 274);
    freq.put("or", 2761);
    freq.put("op", 132);
    freq.put("Ni", 55);
    freq.put("bje", 15);
    freq.put("No", 5);
    freq.put("Na", 13);
    freq.put("Ne", 126);
    freq.put("c\u0302ev", 18);
    freq.put("s\u0302ov", 12);
    freq.put("Adl", 15);
    freq.put("Nu", 89);
    freq.put("Adi", 4);
    freq.put("ic\u0302u", 11);
    freq.put("lof", 4);
    freq.put("log", 15);
    freq.put("her", 21);
    freq.put("loj", 322);
    freq.put("lok", 80);
    freq.put("lon", 321);
    freq.put("hey", 158);
    freq.put("lom", 4);
    freq.put("ic\u0302e", 52);
    freq.put("los", 44);
    freq.put("lop", 8);
    freq.put("ic\u0302a", 67);
    freq.put("eha", 3);
    freq.put("hel", 88);
    freq.put("ic\u0302o", 17);
    freq.put("ic\u0302i", 5);
    freq.put("hej", 40);
    freq.put("oc\u0302o", 40);
    freq.put("uin", 17);
    freq.put("N ", 4);
    freq.put(" sv", 6);
    freq.put("J", 189);
    freq.put("jun", 97);
    freq.put("na ", 204);
    freq.put("jur", 8);
    freq.put("jus", 12);
    freq.put("dvi", 6);
    freq.put("mpr", 66);
    freq.put("lo ", 424);
    freq.put("oc\u0302i", 9);
    freq.put("as ", 1794);
    freq.put("oc\u0302e", 4);
    freq.put("rva", 22);
    freq.put("Est", 47);
    freq.put("ae", 25);
    freq.put("ad", 664);
    freq.put("rve", 12);
    freq.put("Esp", 6);
    freq.put("ai", 90);
    freq.put("rvi", 19);
    freq.put("aj", 4168);
    freq.put("rvo", 33);
    freq.put("al", 2912);
    freq.put("an", 3761);
    freq.put("ap", 501);
    freq.put("as", 2281);
    freq.put("ar", 2329);
    freq.put("at", 961);
    freq.put("av", 447);
    freq.put("az", 187);
    freq.put("uis", 36);
    freq.put("eka", 23);
    freq.put("igu", 72);
    freq.put("igr", 25);
    freq.put("Tia", 98);
    freq.put("ige", 17);
    freq.put("pig\u0302", 11);
    freq.put("iga", 280);
    freq.put("ota", 13);
    freq.put("igo", 52);
    freq.put("ign", 78);
    freq.put("igl", 17);
    freq.put("igi", 547);
    freq.put("Las", 3);
    freq.put("c\u0302am", 36);
    freq.put("a ", 6718);
    freq.put("c\u0302an", 11);
    freq.put("Ho ", 59);
    freq.put("c\u0302aj", 16);
    freq.put("c\u0302ad", 3);
    freq.put("c\u0302ag", 12);
    freq.put("mue", 6);
    freq.put("s\u0302au\u0306", 4);
    freq.put("rv", 89);
    freq.put("os\u0302", 23);
    freq.put("u\u0306te", 21);
    freq.put("c\u0302ap", 11);
    freq.put("c\u0302as", 16);
    freq.put("c\u0302ar", 197);
    freq.put("rs", 87);
    freq.put("La ", 191);
    freq.put("els\u0302", 4);
    freq.put("u", 8006);
    freq.put("Bri", 89);
    freq.put("pto", 7);
    freq.put("alo", 104);
    freq.put("all", 105);
    freq.put("alm", 41);
    freq.put("sci", 270);
    freq.put("alk", 75);
    freq.put("pti", 46);
    freq.put("gv", 36);
    freq.put("sce", 20);
    freq.put("iu ", 635);
    freq.put("pte", 10);
    freq.put("ale", 55);
    freq.put("alb", 87);
    freq.put("pta", 11);
    freq.put("ala", 150);
    freq.put("gt", 5);
    freq.put("mno", 4);
    freq.put("alv", 71);
    freq.put("gs", 124);
    freq.put("alt", 133);
    freq.put("alu", 26);
    freq.put("Fin", 28);
    freq.put("als", 93);
    freq.put("alp", 158);
    freq.put("gr", 353);
    freq.put("rd", 658);
    freq.put("edd", 22);
    freq.put("tv", 6);
    freq.put("tt", 3);
    freq.put("gp", 4);
    freq.put("tr", 1196);
    freq.put("ts", 8);
    freq.put("tp", 26);
    freq.put("tn", 4);
    freq.put("to", 1879);
    freq.put("tl", 5);
    freq.put("tm", 10);
    freq.put("tk", 9);
    freq.put("th", 18);
    freq.put("ti", 3441);
    freq.put("tf", 11);
    freq.put("te", 2358);
    freq.put("tb", 10);
    freq.put("tc", 158);
    freq.put("ta", 3096);
    freq.put("iuj", 377);
    freq.put("ium", 8);
    freq.put("rb", 189);
    freq.put("iuo", 5);
    freq.put("iun", 235);
    freq.put("far", 429);
    freq.put("fas", 9);
    freq.put("mpl", 26);
    freq.put("rc", 22);
    freq.put("fav", 12);
    freq.put("mpk", 3);
    freq.put("al ", 1033);
    freq.put("iuf", 9);
    freq.put("faj", 38);
    freq.put("fak", 8);
    freq.put("mpu", 5);
    freq.put("fan", 68);
    freq.put("llu", 27);
    freq.put("fal", 61);
    freq.put("rm", 338);
    freq.put("fab", 27);
    freq.put("iup", 4);
    freq.put("ius", 12);
    freq.put("iur", 5);
    freq.put("iut", 16);
    freq.put("fad", 8);
    freq.put("lez", 21);
    freq.put(" Ni", 55);
    freq.put("gg", 123);
    freq.put("and", 331);
    freq.put("ro", 2844);
    freq.put(" No", 5);
    freq.put("gf", 4);
    freq.put(" Na", 13);
    freq.put(" Ne", 126);
    freq.put("ge", 266);
    freq.put("ri", 3335);
    freq.put("pbo", 6);
    freq.put("rk", 249);
    freq.put(" Nu", 89);
    freq.put("t ", 112);
    freq.put("vig\u0302", 74);
    freq.put("En ", 30);
    freq.put("tek", 10);
    freq.put("tel", 50);
    freq.put("ga", 664);
    freq.put("ten", 319);
    freq.put("teo", 18);
    freq.put("s\u0302s\u0302", 4);
    freq.put("nbr", 7);
    freq.put("teb", 3);
    freq.put("edu", 10);
    freq.put("ted", 8);
    freq.put("teg", 66);
    freq.put("go", 409);
    freq.put("nbo", 3);
    freq.put("Smi", 30);
    freq.put(" c\u0302a", 256);
    freq.put("nba", 5);
    freq.put("tes", 23);
    freq.put("tet", 37);
    freq.put("lla", 28);
    freq.put("nbe", 8);
    freq.put("suf", 56);
    freq.put("sud", 4);
    freq.put("mug\u0302", 3);
    freq.put("sub", 75);
    freq.put("sun", 31);
    freq.put("sum", 5);
    freq.put("sul", 78);
    freq.put("suk", 25);
    freq.put("abo", 91);
    freq.put("abr", 8);
    freq.put("abs", 6);
    freq.put("sus", 17);
    freq.put("sur", 468);
    freq.put("sup", 124);
    freq.put(" ru", 66);
    freq.put("ggs", 123);
    freq.put("lko", 36);
    freq.put("te ", 1070);
    freq.put("K", 487);
    freq.put("lic\u0302", 78);
    freq.put(" re", 548);
    freq.put("ng\u0302e", 46);
    freq.put(" ra", 175);
    freq.put(" An", 35);
    freq.put("kze", 6);
    freq.put("mul", 171);
    freq.put(" ro", 39);
    freq.put("kzi", 13);
    freq.put(" ri", 455);
    freq.put("su ", 31);
    freq.put("ng\u0302a", 19);
    freq.put("asa", 26);
    freq.put(" j\u0302u", 18);
    freq.put("iig\u0302", 18);
    freq.put("lj\u0302e", 9);
    freq.put("ng\u0302o", 34);
    freq.put("rku", 34);
    freq.put("jre", 7);
    freq.put("ts\u0302", 3);
    freq.put("ase", 8);
    freq.put("vid", 282);
    freq.put("vie", 15);
    freq.put("jro", 28);
    freq.put("vin", 162);
    freq.put("vil", 81);
    freq.put("faj\u0302", 4);
    freq.put("vir", 162);
    freq.put("rke", 4);
    freq.put("viv", 160);
    freq.put("rka", 130);
    freq.put("vit", 36);
    freq.put("lig\u0302", 30);
    freq.put("viz", 133);
    freq.put("rko", 51);
    freq.put("rki", 29);
    freq.put("Tie", 40);
    freq.put("g\u0302ad", 18);
    freq.put("veg", 5);
    freq.put("og\u0302o", 9);
    freq.put("g\u0302is", 484);
    freq.put("als\u0302", 14);
    freq.put("anc", 128);
    freq.put("pur", 18);
    freq.put("avu", 18);
    freq.put("de ", 1194);
    freq.put("vi ", 350);
    freq.put("g\u0302aj", 33);
    freq.put("Su", 18);
    freq.put("St", 4);
    freq.put("Sk", 5);
    freq.put("lkv", 5);
    freq.put("Si", 58);
    freq.put("Via", 39);
    freq.put("So", 3);
    freq.put("Sn", 158);
    freq.put("Sm", 30);
    freq.put("Sc", 7);
    freq.put("Sa", 17);
    freq.put("Se", 214);
    freq.put(" do", 401);
    freq.put("kle", 4);
    freq.put("dez", 79);
    freq.put("kla", 87);
    freq.put(" di", 799);
    freq.put("alc\u0302", 3);
    freq.put("Int", 3);
    freq.put(" de", 1693);
    freq.put("klo", 12);
    freq.put("det", 70);
    freq.put("kli", 65);
    freq.put(" da", 413);
    freq.put("klu", 4);
    freq.put("dej", 16);
    freq.put("alg\u0302", 44);
    freq.put("enc", 275);
    freq.put("dem", 78);
    freq.put("den", 151);
    freq.put("S\u0302a", 9);
    freq.put(" du", 280);
    freq.put("dec", 42);
    freq.put(" dr", 14);
    freq.put("def", 19);
    freq.put("S\u0302i", 53);
    freq.put("Vin", 15);
    freq.put("go ", 167);
    freq.put("f ", 3);
    freq.put("lal", 7);
    freq.put("Vil", 14);
    freq.put("ati", 177);
    freq.put("s\u0302u", 39);
    freq.put("s\u0302t", 72);
    freq.put("s\u0302v", 3);
    freq.put("s\u0302p", 11);
    freq.put("s\u0302s", 3);
    freq.put("s\u0302r", 5);
    freq.put("ls\u0302p", 4);
    freq.put("ava", 141);
    freq.put("s\u0302e", 24);
    freq.put("lri", 23);
    freq.put("atu", 29);
    freq.put("s\u0302a", 211);
    freq.put("s\u0302l", 8);
    freq.put("s\u0302o", 84);
    freq.put("s\u0302n", 11);
    freq.put("s\u0302i", 792);
    freq.put("s\u0302k", 8);
    freq.put("u\u0306ri", 40);
    freq.put("Dok", 3);
    freq.put("fr", 291);
    freq.put("fs", 3);
    freq.put("ft", 35);
    freq.put("fu", 108);
    freq.put("lag\u0302", 8);
    freq.put("anh", 3);
    freq.put("unt", 25);
    freq.put("fa", 738);
    freq.put("fe", 374);
    freq.put("u\u0306re", 9);
    freq.put("osp", 6);
    freq.put("fi", 498);
    freq.put("fk", 3);
    freq.put("fl", 201);
    freq.put("fo", 590);
    freq.put("a", 30860);
    freq.put("lhe", 27);
    freq.put("ry ", 3);
    freq.put("hfi", 8);
    freq.put("ne ", 999);
    freq.put("egi", 87);
    freq.put("ego", 127);
    freq.put("Es", 54);
    freq.put("egm", 15);
    freq.put("ega", 77);
    freq.put("mvo", 9);
    freq.put("ege", 43);
    freq.put("ito", 46);
    freq.put("g\u0302on", 91);
    freq.put("iti", 44);
    freq.put("y ", 283);
    freq.put("ite", 97);
    freq.put("itc", 158);
    freq.put("ita", 562);
    freq.put("ok ", 6);
    freq.put("os ", 390);
    freq.put("g\u0302os", 32);
    freq.put("itu", 14);
    freq.put("itr", 11);
    freq.put("uve", 4);
    freq.put(" On", 11);
    freq.put(" Ok", 7);
    freq.put("os\u0302t", 3);
    freq.put("nto", 394);
    freq.put(" Or", 4);
    freq.put("c\u0302i ", 466);
    freq.put("oks", 97);
    freq.put("ced", 5);
    freq.put("oku", 125);
    freq.put(" ec\u0302", 53);
    freq.put("dim", 12);
    freq.put("cen", 34);
    freq.put("g\u0302o ", 154);
    freq.put("L", 428);
    freq.put("oka", 129);
    freq.put("cev", 31);
    freq.put("okc", 4);
    freq.put("cet", 52);
    freq.put("oke", 16);
    freq.put("cer", 75);
    freq.put("cep", 33);
    freq.put("oki", 17);
    freq.put("Bal", 16);
    freq.put("oko", 82);
    freq.put("ifu", 6);
    freq.put("uj ", 297);
    freq.put(" O ", 4);
    freq.put("ife", 23);
    freq.put("ifa", 12);
    freq.put("ifl", 3);
    freq.put("ifo", 21);
    freq.put("ifi", 9);
    freq.put("dig", 56);
    freq.put("g\u0302a ", 48);
    freq.put(" sp", 70);
    freq.put("pu ", 7);
    freq.put(" st", 194);
    freq.put(" su", 765);
    freq.put(" sk", 77);
    freq.put(" si", 1017);
    freq.put(" so", 189);
    freq.put("kaj\u0302", 13);
    freq.put(" sc", 218);
    freq.put("uda", 21);
    freq.put(" sa", 210);
    freq.put("kg\u0302", 5);
    freq.put(" se", 954);
    freq.put("iza", 120);
    freq.put("u\u0306za", 3);
    freq.put("ize", 11);
    freq.put("gur", 20);
    freq.put("izi", 24);
    freq.put("E ", 7);
    freq.put("izo", 47);
    freq.put("fte", 29);
    freq.put(" G\u0302i", 55);
    freq.put("fti", 4);
    freq.put("u\u0306ir", 3);
    freq.put("pul", 4);
    freq.put("pun", 11);
    freq.put("asp", 15);
    freq.put(" Ad", 20);
    freq.put("Unu", 44);
    freq.put("asu", 14);
    freq.put(" em", 3);
    freq.put("pud", 60);
    freq.put("pug", 5);
    freq.put(" Al", 103);
    freq.put(" Am", 8);
    freq.put("kau\u0306", 278);
    freq.put(" Ar", 6);
    freq.put(" S\u0302a", 9);
    freq.put("put", 9);
    freq.put("kom", 193);
    freq.put("asi", 117);
    freq.put("aso", 49);
    freq.put(" S\u0302i", 53);
    freq.put("pus", 4);
    freq.put("El", 6);
    freq.put("En", 35);
    freq.put("jet", 4);
    freq.put("Ek", 11);
    freq.put("u\u0306i ", 3);
    freq.put("Ef", 9);
    freq.put("Eb", 14);
    freq.put("tor", 180);
    freq.put("w", 17);
    freq.put("tos", 104);
    freq.put("kas\u0302", 39);
    freq.put("le ", 249);
    freq.put("Fra", 16);
    freq.put(" eg", 22);
    freq.put("Cle", 125);
    freq.put("s\u0302o ", 27);
    freq.put(" el", 468);
    freq.put("jes", 34);
    freq.put("kok", 6);
    freq.put("koj", 109);
    freq.put("st ", 95);
    freq.put("kol", 66);
    freq.put("ss\u0302i", 3);
    freq.put("kon", 615);
    freq.put(" ed", 110);
    freq.put(" ef", 33);
    freq.put("kob", 4);
    freq.put(" eb", 90);
    freq.put(" ec", 5);
    freq.put("jec", 5);
    freq.put("jeg", 8);
    freq.put(" et", 21);
    freq.put("jek", 19);
    freq.put("kos", 11);
    freq.put("kor", 246);
    freq.put("jen", 40);
    freq.put("kot", 10);
    freq.put("Nu ", 47);
    freq.put("kov", 31);
    freq.put("ncy", 123);
    freq.put("u\u0306ga", 8);
    freq.put("s\u0302on", 16);
    freq.put(" ag\u0302", 7);
    freq.put("tom", 24);
    freq.put("ncu", 5);
    freq.put("nci", 81);
    freq.put("nco", 83);
    freq.put("nca", 92);
    freq.put(" ev", 19);
    freq.put("ste", 176);
    freq.put("b", 2436);
    freq.put("sta", 887);
    freq.put("stl", 3);
    freq.put("ko ", 231);
    freq.put("sto", 301);
    freq.put("Nur", 13);
    freq.put("sti", 706);
    freq.put("stk", 3);
    freq.put("Nun", 28);
    freq.put("stu", 135);
    freq.put("je ", 187);
    freq.put(" er", 7);
    freq.put("str", 193);
    freq.put("sts", 3);
    freq.put(" es", 1401);
    freq.put("Gol", 4);
    freq.put("ka ", 44);
    freq.put("Ec\u0302", 4);
    freq.put("s\u0302oj", 23);
    freq.put("udi", 18);
    freq.put("tfo", 3);
    freq.put("ofo", 11);
    freq.put("c\u0302e ", 126);
    freq.put("lid", 7);
    freq.put("c\u0302ie", 31);
    freq.put("lif", 8);
    freq.put("k ", 87);
    freq.put("lia", 333);
    freq.put("lib", 70);
    freq.put("lil", 10);
    freq.put("ag\u0302a", 61);
    freq.put("lin", 400);
    freq.put("Nia", 9);
    freq.put("uc\u0302o", 4);
    freq.put("lik", 24);
    freq.put("lit", 48);
    freq.put("efi", 4);
    freq.put("liv", 5);
    freq.put("Kio", 53);
    freq.put("lir", 43);
    freq.put("lis", 159);
    freq.put("efa", 13);
    freq.put("Kia", 67);
    freq.put("efe", 48);
    freq.put("Kie", 45);
    freq.put("kab", 11);
    freq.put("oft", 29);
    freq.put("kad", 31);
    freq.put("kaj", 2512);
    freq.put("M", 699);
    freq.put("kan", 62);
    freq.put("kam", 101);
    freq.put("kal", 38);
    freq.put("kas", 26);
    freq.put("kar", 71);
    freq.put("kap", 201);
    freq.put("kav", 20);
    freq.put("kat", 71);
    freq.put("kaz", 87);
    freq.put("c\u0302io", 111);
    freq.put("kc", 61);
    freq.put("kb", 17);
    freq.put("ka", 3614);
    freq.put("li ", 1381);
    freq.put("kf", 24);
    freq.put("ke", 1090);
    freq.put("kd", 32);
    freq.put("kk", 53);
    freq.put("Ni ", 46);
    freq.put("kh", 6);
    freq.put("ko", 1530);
    freq.put("kn", 68);
    freq.put("km", 6);
    freq.put("kl", 172);
    freq.put("ks", 281);
    freq.put("pus\u0302", 16);
    freq.put("kp", 15);
    freq.put("es\u0302a", 15);
    freq.put("kv", 388);
    freq.put("ku", 898);
    freq.put("kt", 485);
    freq.put("kz", 19);
    freq.put("es\u0302o", 14);
    freq.put("es\u0302i", 8);
    freq.put("rte", 176);
    freq.put("ugi", 12);
    freq.put("oju", 3);
    freq.put("rta", 104);
    freq.put("ugl", 11);
    freq.put("rtm", 3);
    freq.put("rto", 195);
    freq.put("fug\u0302", 6);
    freq.put("rti", 241);
    freq.put("rth", 7);
    freq.put("uge", 13);
    freq.put("rtu", 21);
    freq.put("oje", 96);
    freq.put("rtp", 19);
    freq.put("rtr", 4);
    freq.put("ojn", 763);
    freq.put("ojo", 106);
    freq.put("ojl", 3);
    freq.put("ojk", 4);
    freq.put("Hav", 3);
    freq.put("oji", 27);
    freq.put(" s\u0302p", 7);
    freq.put("Ju", 6);
    freq.put("ies", 43);
    freq.put("ier", 80);
    freq.put("iet", 20);
    freq.put("nce", 44);
    freq.put("Jo", 10);
    freq.put("iem", 3);
    freq.put("iel", 653);
    freq.put("ien", 139);
    freq.put("iea", 4);
    freq.put("Je", 121);
    freq.put("iec", 4);
    freq.put("Ja", 51);
    freq.put("ieg", 21);
    freq.put("his", 13);
    freq.put("ig\u0302u", 24);
    freq.put("rg\u0302e", 8);
    freq.put("Ha ", 21);
    freq.put("rg\u0302i", 4);
    freq.put("rg\u0302o", 12);
    freq.put("ig\u0302a", 97);
    freq.put("mac\u0302", 4);
    freq.put("gau\u0306", 18);
    freq.put("ig\u0302e", 5);
    freq.put("hie", 6);
    freq.put("oj ", 1429);
    freq.put("ig\u0302i", 427);
    freq.put("ig\u0302o", 90);
    freq.put("end", 245);
    freq.put("rfu", 3);
    freq.put("rfa", 4);
    freq.put("ie ", 253);
    freq.put("rfi", 3);
    freq.put("J ", 4);
    freq.put("rfl", 14);
    freq.put(" s\u0302t", 59);
    freq.put(" s\u0302u", 31);
    freq.put("set", 4);
    freq.put(" Ba", 21);
    freq.put("ser", 124);
    freq.put(" s\u0302r", 3);
    freq.put("sep", 4);
    freq.put(" Bo", 19);
    freq.put(" Bi", 10);
    freq.put("seg", 10);
    freq.put(" s\u0302e", 10);
    freq.put("arb", 98);
    freq.put("sed", 293);
    freq.put("ard", 333);
    freq.put(" s\u0302a", 136);
    freq.put(" Br", 90);
    freq.put(" s\u0302l", 6);
    freq.put("sen", 340);
    freq.put("sem", 27);
    freq.put(" s\u0302o", 5);
    freq.put("sek", 86);
    freq.put(" s\u0302i", 659);
    freq.put("Foj", 5);
    freq.put("aro", 436);
    freq.put("mo ", 302);
    freq.put("c\u0302u ", 49);
    freq.put("leg", 59);
    freq.put("kto", 252);
    freq.put("atr", 60);
    freq.put("use", 4);
    freq.put("tiz", 4);
    freq.put("lej", 137);
    freq.put("iks", 19);
    freq.put("adv", 28);
    freq.put("ikv", 5);
    freq.put("ikt", 6);
    freq.put("lem", 133);
    freq.put("ar ", 211);
    freq.put("ika", 47);
    freq.put("ikf", 14);
    freq.put("ike", 9);
    freq.put("se ", 189);
    freq.put("iki", 29);
    freq.put("u\u0306zo", 18);
    freq.put("iko", 129);
    freq.put("u\u0306zi", 17);
    freq.put("u\u0306 ", 844);
    freq.put(" Pr", 29);
    freq.put("c", 1813);
    freq.put("rig\u0302", 121);
    freq.put("c\u0302ul", 13);
    freq.put("nzo", 8);
    freq.put("voc\u0302", 42);
    freq.put(" Pa", 42);
    freq.put(" Pe", 16);
    freq.put("ric\u0302", 29);
    freq.put(" Po", 49);
    freq.put(" Pl", 6);
    freq.put("eze", 47);
    freq.put("Hod", 4);
    freq.put("War", 37);
    freq.put("ga ", 78);
    freq.put("pr", 1345);
    freq.put("ps", 10);
    freq.put("duj", 4);
    freq.put("duk", 46);
    freq.put("dul", 26);
    freq.put("dum", 69);
    freq.put("pt", 76);
    freq.put("pu", 139);
    freq.put("ts\u0302i", 3);
    freq.put("dub", 24);
    freq.put("dud", 10);
    freq.put("duf", 5);
    freq.put("tiv", 48);
    freq.put("pb", 6);
    freq.put("pa", 886);
    freq.put("pf", 4);
    freq.put("fu ", 5);
    freq.put("pe", 1029);
    freq.put("pk", 3);
    freq.put("pi", 343);
    freq.put("dut", 20);
    freq.put("po", 2006);
    freq.put("pl", 680);
    freq.put("nri", 13);
    freq.put("gaz", 4);
    freq.put(" tu", 288);
    freq.put("gat", 23);
    freq.put("gas", 62);
    freq.put(" tr", 613);
    freq.put("N", 292);
    freq.put(" to", 37);
    freq.put("gan", 77);
    freq.put("gal", 18);
    freq.put("gaj", 91);
    freq.put(" ti", 1569);
    freq.put("ado", 228);
    freq.put(" te", 349);
    freq.put("gad", 35);
    freq.put("gab", 3);
    freq.put(" ta", 277);
    freq.put("lba", 5);
    freq.put("fut", 3);
    freq.put("mla", 3);
    freq.put("fur", 6);
    freq.put("du ", 162);
    freq.put("fuz", 12);
    freq.put("p ", 12);
    freq.put("fun", 57);
    freq.put("lbe", 6);
    freq.put("ful", 3);
    freq.put("fum", 14);
    freq.put("eke", 9);
    freq.put("riz", 36);
    freq.put("riv", 36);
    freq.put("ekc", 3);
    freq.put("rit", 154);
    freq.put("riu", 5);
    freq.put("rir", 40);
    freq.put("ris", 971);
    freq.put("rip", 85);
    freq.put("vok", 51);
    freq.put("rin", 199);
    freq.put("rio", 187);
    freq.put("ril", 116);
    freq.put("rim", 80);
    freq.put("rik", 23);
    freq.put("rih", 4);
    freq.put("rii", 37);
    freq.put("rif", 11);
    freq.put("rig", 349);
    freq.put("rid", 100);
    freq.put("rie", 30);
    freq.put("rib", 52);
    freq.put("ric", 35);
    freq.put("ria", 23);
    freq.put("Kva", 8);
    freq.put("ewc", 12);
    freq.put("u\u0306ro", 20);
    freq.put("Kvi", 3);
    freq.put("gs ", 121);
    freq.put("j\u0302o ", 172);
    freq.put("ac", 231);
    freq.put("amb", 84);
    freq.put("vo ", 123);
    freq.put("tis", 975);
    freq.put("lie", 56);
    freq.put("Ili", 43);
    freq.put("lig", 127);
    freq.put("ekv", 89);
    freq.put("ri ", 588);
    freq.put(" fr", 188);
    freq.put(" fu", 40);
    freq.put(" ft", 4);
    freq.put("seg\u0302", 15);
    freq.put("arg\u0302", 33);
    freq.put("kna", 67);
    freq.put(" fa", 571);
    freq.put(" fe", 121);
    freq.put("lim", 21);
    freq.put("y", 290);
    freq.put("j\u0302oj", 92);
    freq.put(" fl", 121);
    freq.put(" fo", 399);
    freq.put("ug\u0302", 71);
    freq.put("lda", 104);
    freq.put("lio", 37);
    freq.put("lde", 11);
    freq.put("ldi", 13);
    freq.put("ldo", 48);
    freq.put("bi ", 13);
    freq.put("O ", 21);
    freq.put("uzo", 15);
    freq.put("uc\u0302", 6);
    freq.put("Kiu", 12);
    freq.put("us\u0302s\u0302", 3);
    freq.put("cig\u0302", 13);
    freq.put("uzi", 45);
    freq.put("cus", 3);
    freq.put("rgu", 8);
    freq.put("mof", 3);
    freq.put("rga", 33);
    freq.put("rge", 33);
    freq.put("rgi", 24);
    freq.put("mod", 15);
    freq.put("cuj", 3);
    freq.put("rgo", 5);
    freq.put("bin", 26);
    freq.put("On", 11);
    freq.put("bil", 7);
    freq.put("ld ", 8);
    freq.put("Ok", 7);
    freq.put("big", 5);
    freq.put("bie", 13);
    freq.put(" C\u0302u", 90);
    freq.put("s\u0302u ", 3);
    freq.put(" C\u0302i", 46);
    freq.put("tut", 202);
    freq.put("apt", 41);
    freq.put("lki", 4);
    freq.put("bit", 26);
    freq.put("bir", 27);
    freq.put("Or", 4);
    freq.put(" C\u0302e", 10);
    freq.put("Dis", 4);
    freq.put("kuz", 3);
    freq.put("leo", 14);
    freq.put("d", 8106);
    freq.put("ljo", 4);
    freq.put("dig\u0302", 60);
    freq.put("u\u0306b", 4);
    freq.put("ees", 8);
    freq.put("Ebl", 14);
    freq.put("een", 13);
    freq.put("liz", 6);
    freq.put("lju", 45);
    freq.put("apo", 118);
    freq.put("b ", 25);
    freq.put("ru ", 67);
    freq.put("ovr", 32);
    freq.put("tuj", 34);
    freq.put("vol", 146);
    freq.put("h\u0302", 4);
    freq.put("ra ", 277);
    freq.put("pez", 20);
    freq.put("pet", 90);
    freq.put("per", 476);
    freq.put("nau\u0306", 34);
    freq.put("pel", 22);
    freq.put("pen", 277);
    freq.put("u\u0306ti", 3);
    freq.put("pek", 27);
    freq.put("ped", 7);
    freq.put("peg", 3);
    freq.put("Mau\u0306", 10);
    freq.put("pec", 55);
    freq.put("ruj", 9);
    freq.put("ruk", 9);
    freq.put("ufe", 15);
    freq.put("rui", 54);
    freq.put("run", 22);
    freq.put("ruo", 21);
    freq.put("rul", 36);
    freq.put("rum", 17);
    freq.put("rub", 3);
    freq.put("ruc", 3);
    freq.put("rua", 17);
    freq.put("rug", 10);
    freq.put("rud", 23);
    freq.put(" Au\u0306", 9);
    freq.put("ruz", 7);
    freq.put("bu", 76);
    freq.put("cid", 33);
    freq.put("br", 317);
    freq.put("bs", 45);
    freq.put("rur", 28);
    freq.put("rus", 61);
    freq.put("rup", 8);
    freq.put("ruv", 5);
    freq.put("rut", 4);
    freq.put("nag\u0302", 29);
    freq.put("idv", 7);
    freq.put("Rob", 4);
    freq.put("idu", 19);
    freq.put("Au\u0306", 9);
    freq.put("ido", 67);
    freq.put("idi", 293);
    freq.put("DE ", 5);
    freq.put("ide", 152);
    freq.put("pe ", 41);
    freq.put("ida", 126);
    freq.put("nsi", 109);
    freq.put(" uz", 20);
    freq.put("nso", 55);
    freq.put(" ut", 12);
    freq.put("nsa", 80);
    freq.put(" C ", 5);
    freq.put("nsc", 21);
    freq.put("nsd", 14);
    freq.put("nse", 52);
    freq.put(" ur", 21);
    freq.put(" ul", 16);
    freq.put(" un", 257);
    freq.put("nsp", 7);
    freq.put("nsr", 3);
    freq.put("nst", 75);
    freq.put("nsu", 90);
    freq.put("us\u0302e", 6);
    freq.put("ci ", 15);
    freq.put("us\u0302a", 26);
    freq.put("tuk", 12);
    freq.put("zig", 16);
    freq.put("mko", 3);
    freq.put("us\u0302o", 21);
    freq.put("us\u0302i", 52);
    freq.put("kus", 7);
    freq.put("s\u0302tu", 11);
    freq.put("u ", 1590);
    freq.put("fes", 22);
    freq.put("doj", 107);
    freq.put(" Cl", 125);
    freq.put("ns ", 5);
    freq.put("lka", 63);
    freq.put("El ", 3);
    freq.put("usp", 13);
    freq.put(" Ce", 9);
    freq.put("ukt", 11);
    freq.put("voj", 87);
    freq.put("Fi", 30);
    freq.put(" Cr", 124);
    freq.put("sdo", 15);
    freq.put("cia", 118);
    freq.put("uta", 115);
    freq.put("cig", 8);
    freq.put("tpa", 21);
    freq.put("cie", 23);
    freq.put("uz", 76);
    freq.put("ut", 425);
    freq.put("cii", 126);
    freq.put("uv", 21);
    freq.put("cio", 28);
    freq.put("up", 175);
    freq.put("us", 478);
    freq.put("ur", 1146);
    freq.put("um", 284);
    freq.put("ul", 727);
    freq.put("uo", 113);
    freq.put("un", 1409);
    freq.put("ui", 104);
    freq.put("uh", 3);
    freq.put("uk", 100);
    freq.put("uj", 461);
    freq.put("ue", 56);
    freq.put("ud", 139);
    freq.put("ug", 51);
    freq.put("Fo", 17);
    freq.put("ua", 110);
    freq.put("ki", 1757);
    freq.put("uc", 5);
    freq.put("ub", 144);
    freq.put("u\u0306e ", 56);
    freq.put("cin", 4);
    freq.put("Tu", 28);
    freq.put("Tr", 21);
    freq.put("Hve", 7);
    freq.put("lpr", 90);
    freq.put("To", 6);
    freq.put("dek", 106);
    freq.put("Rog\u0302", 9);
    freq.put("Ti", 242);
    freq.put("Te", 7);
    freq.put("Ta", 39);
    freq.put(" gv", 11);
    freq.put("A ", 21);
    freq.put("gru", 11);
    freq.put(" gr", 181);
    freq.put("nad", 58);
    freq.put("kr", 298);
    freq.put("naj", 78);
    freq.put("uri", 137);
    freq.put("nan", 135);
    freq.put("nal", 9);
    freq.put("nam", 18);
    freq.put("nar", 45);
    freq.put("nas", 151);
    freq.put("gre", 44);
    freq.put("nav", 3);
    freq.put("nat", 71);
    freq.put("gra", 260);
    freq.put("naz", 4);
    freq.put("gro", 17);
    freq.put(" gl", 41);
    freq.put("Mal", 28);
    freq.put("gri", 21);
    freq.put("Zur", 13);
    freq.put("cil", 56);
    freq.put("u\u0306eb", 21);
    freq.put("as\u0302s", 3);
    freq.put("u\u0306en", 21);
    freq.put("as\u0302i", 34);
    freq.put(" ci", 13);
    freq.put("as\u0302o", 12);
    freq.put("dos", 21);
    freq.put("as\u0302a", 3);
    freq.put("ebl", 176);
    freq.put("as\u0302e", 6);
    freq.put("ago", 153);
    freq.put("cis", 63);
    freq.put("agm", 10);
    freq.put("mu ", 8);
    freq.put("e", 22757);
    freq.put("Ad", 20);
    freq.put("agi", 36);
    freq.put("agg", 123);
    freq.put("age", 39);
    freq.put("sve", 6);
    freq.put("Am", 8);
    freq.put("Al", 103);
    freq.put("aga", 33);
    freq.put("An", 35);
    freq.put("Ar", 6);
    freq.put("agu", 7);
    freq.put("agr", 35);
    freq.put(" b", 1054);
    freq.put(" c", 151);
    freq.put("gu", 135);
    freq.put(" a", 2978);
    freq.put(" f", 1688);
    freq.put(" g", 378);
    freq.put(" d", 3600);
    freq.put(" e", 3568);
    freq.put(" j", 454);
    freq.put(" k", 7169);
    freq.put(" h", 723);
    freq.put(" i", 1375);
    freq.put(" n", 2243);
    freq.put(" o", 680);
    freq.put(" l", 5677);
    freq.put(" m", 4425);
    freq.put(" r", 1283);
    freq.put(" s", 3701);
    freq.put(" p", 3980);
    freq.put(" v", 1902);
    freq.put("gb", 3);
    freq.put(" t", 3133);
    freq.put(" u", 328);
    freq.put(" z", 30);
    freq.put("gn", 81);
    freq.put("gm", 26);
    freq.put("gl", 95);
    freq.put(" c\u0302e", 152);
    freq.put("gi", 778);
    freq.put(" B", 168);
    freq.put(" C", 268);
    freq.put("lkl", 6);
    freq.put(" A", 194);
    freq.put(" F", 73);
    freq.put(" G", 115);
    freq.put(" D", 163);
    freq.put(" E", 142);
    freq.put(" J", 189);
    freq.put(" K", 487);
    freq.put(" H", 127);
    freq.put(" I", 82);
    freq.put(" N", 292);
    freq.put(" O", 29);
    freq.put(" L", 428);
    freq.put(" M", 699);
    freq.put(" R", 56);
    freq.put(" S", 522);
    freq.put(" P", 148);
    freq.put("ng\u0302u", 4);
    freq.put(" V", 355);
    freq.put(" W", 45);
    freq.put(" T", 352);
    freq.put(" U", 58);
    freq.put(" Z", 14);
    freq.put("esc", 14);
    freq.put("uso", 7);
    freq.put("lku", 24);
    freq.put("lkr", 14);
    freq.put("gaj\u0302", 10);
    freq.put("tme", 4);
    freq.put("kce", 47);
    freq.put("urv", 14);
    freq.put("ed ", 471);
    freq.put("ibi", 27);
    freq.put("zig\u0302", 14);
    freq.put("kci", 14);
    freq.put("Ter", 3);
    freq.put("P", 148);
    freq.put("tri", 219);
    freq.put("evi", 149);
    freq.put("tro", 309);
    freq.put("evo", 20);
    freq.put("tra", 413);
    freq.put("eva", 102);
    freq.put("us ", 339);
    freq.put("tre", 191);
    freq.put("eve", 100);
    freq.put("ebi", 5);
    freq.put("tru", 62);
    freq.put("evu", 13);
    freq.put("rro", 13);
    freq.put("uel", 11);
    freq.put("zo", 271);
    freq.put("zi", 324);
    freq.put("uej", 3);
    freq.put("zd", 4);
    freq.put("ze", 94);
    freq.put("rre", 4);
    freq.put("oja", 32);
    freq.put("za", 281);
    freq.put("rra", 3);
    freq.put("odi", 48);
    freq.put("odo", 25);
    freq.put("zu", 28);
    freq.put("ode", 15);
    freq.put("fli", 4);
    freq.put("ulk", 6);
    freq.put("ag\u0302u", 16);
    freq.put("cit", 21);
    freq.put("efr", 3);
    freq.put("ulo", 342);
    freq.put("taj\u0302", 78);
    freq.put("leb", 5);
    freq.put("s\u0302aj", 72);
    freq.put("led", 3);
    freq.put("ull", 3);
    freq.put("lef", 3);
    freq.put("oza", 39);
    freq.put("ozo", 21);
    freq.put("c\u0302es", 12);
    freq.put("lek", 44);
    freq.put("Sam", 6);
    freq.put("c\u0302et", 14);
    freq.put("sig\u0302", 13);
    freq.put("ozi", 13);
    freq.put("lep", 6);
    freq.put("ler", 118);
    freq.put("les", 7);
    freq.put("let", 49);
    freq.put("lev", 83);
    freq.put("c\u0302en", 6);
    freq.put("c\u0302ec", 7);
    freq.put("c\u0302ee", 6);
    freq.put("c\u0302ef", 29);
    freq.put("rdu", 28);
    freq.put("ogr", 10);
    freq.put("ast", 96);
    freq.put("ciz", 7);
    freq.put("rde", 100);
    freq.put("nme", 9);
    freq.put("rda", 88);
    freq.put("uld", 19);
    freq.put("rdo", 235);
    freq.put("C\u0302e", 10);
    freq.put("rdi", 204);
    freq.put(" Do", 5);
    freq.put("Ver", 4);
    freq.put(" Di", 72);
    freq.put("apr", 45);
    freq.put(" De", 37);
    freq.put(" Da", 10);
    freq.put("apu", 58);
    freq.put("api", 94);
    freq.put("ii ", 18);
    freq.put("apl", 3);
    freq.put("Ven", 44);
    freq.put(" Du", 25);
    freq.put("apa", 64);
    freq.put(" Dr", 3);
    freq.put("ape", 74);
    freq.put("cha", 16);
    freq.put("Fr", 16);
    freq.put("zir", 73);
    freq.put("zis", 74);
    freq.put("Hul", 3);
    freq.put("fel", 84);
    freq.put("G\u0302is", 3);
    freq.put("usk", 10);
    freq.put("fek", 54);
    freq.put("usi", 3);
    freq.put("Fa", 5);
    freq.put("fet", 8);
    freq.put("ust", 81);
    freq.put("fer", 168);
    freq.put("zic", 3);
    freq.put("oc\u0302", 61);
    freq.put("zia", 5);
    freq.put("zin", 67);
    freq.put("zio", 5);
    freq.put("zik", 19);
    freq.put(" S\u0302", 64);
    freq.put(" s\u0302", 930);
    freq.put("ue ", 32);
    freq.put("iis", 106);
    freq.put(" c\u0302u", 50);
    freq.put("pfl", 4);
    freq.put(" D ", 4);
    freq.put("vri", 25);
    freq.put("iig", 34);
    freq.put("ol", 664);
    freq.put(" j\u0302", 51);
    freq.put("Sci", 5);
    freq.put("ace", 96);
    freq.put("fe ", 3);
    freq.put("f", 2849);
    freq.put(" C\u0302", 168);
    freq.put(" c\u0302", 1503);
    freq.put("C\u0302u", 90);
    freq.put(" Re", 14);
    freq.put("og", 41);
    freq.put("C\u0302i", 46);
    freq.put(" Ra", 5);
    freq.put("zi ", 15);
    freq.put("enn", 4);
    freq.put(" Ro", 14);
    freq.put("C\u0302a", 22);
    freq.put(" Ri", 17);
    freq.put("aci", 102);
    freq.put(" G\u0302", 64);
    freq.put(" g\u0302", 788);
    freq.put("tat", 51);
    freq.put("u\u0306dk", 3);
    freq.put("u\u0306di", 62);
    freq.put("tap", 4);
    freq.put("u\u0306do", 5);
    freq.put("tar", 108);
    freq.put("tas", 702);
    freq.put("aco", 24);
    freq.put("u\u0306da", 24);
    freq.put("taz", 6);
    freq.put("ob", 88);
    freq.put("tad", 94);
    freq.put("tag", 188);
    freq.put("dzo", 28);
    freq.put("tab", 43);
    freq.put("tal", 84);
    freq.put("tam", 41);
    freq.put("tan", 312);
    freq.put("Mr ", 4);
    freq.put("tai", 86);
    freq.put("taj", 327);
    freq.put("tak", 31);
    freq.put("sis", 201);
    freq.put("sip", 3);
    freq.put(" ve", 456);
    freq.put("afi", 103);
    freq.put("sit", 29);
    freq.put(" vi", 1123);
    freq.put("afe", 72);
    freq.put("c\u0302u", 65);
    freq.put("afa", 41);
    freq.put(" vo", 240);
    freq.put(" os", 6);
    freq.put("c\u0302i", 1124);
    freq.put("sia", 316);
    freq.put("c\u0302j", 25);
    freq.put("sig", 91);
    freq.put("c\u0302l", 5);
    freq.put("c\u0302o", 97);
    freq.put("sid", 78);
    freq.put("c\u0302a", 356);
    freq.put("afu", 7);
    freq.put("c\u0302e", 230);
    freq.put("sin", 468);
    freq.put("sim", 128);
    freq.put("sil", 43);
    freq.put("afl", 14);
    freq.put("npo", 15);
    freq.put(" c\u0302i", 1045);
    freq.put("paf", 131);
    freq.put("npe", 4);
    freq.put("npa", 9);
    freq.put("lac\u0302", 17);
    freq.put("afo", 51);
    freq.put("ta ", 661);
    freq.put("tig\u0302", 53);
    freq.put("npr", 28);
    freq.put("Oni", 9);
    freq.put("os", 734);
    freq.put("si ", 118);
    freq.put("u\u0306ve", 3);
    freq.put("ato", 264);
    freq.put("c\u0302 ", 54);
    freq.put("TO ", 7);
    freq.put("les\u0302", 14);
    freq.put("u\u0306vo", 3);
    freq.put("da ", 401);
    freq.put("kbo", 3);
    freq.put("vma", 3);
    freq.put("jna", 21);
    freq.put("jne", 23);
    freq.put("kbr", 9);
    freq.put("jni", 43);
    freq.put("jno", 26);
    freq.put("lf", 204);
    freq.put("lg", 90);
    freq.put("ld", 186);
    freq.put("le", 1146);
    freq.put("lb", 104);
    freq.put("lg\u0302o", 39);
    freq.put("ln", 54);
    freq.put("lo", 1430);
    freq.put("ll", 121);
    freq.put("lm", 71);
    freq.put("lj", 49);
    freq.put("lk", 197);
    freq.put("lh", 29);
    freq.put("li", 2999);
    freq.put("lv", 116);
    freq.put("lt", 433);
    freq.put("lu", 352);
    freq.put("lr", 52);
    freq.put("ls", 113);
    freq.put("lp", 286);
    freq.put(" vu", 8);
    freq.put("lg\u0302u", 3);
    freq.put("dad", 58);
    freq.put("tob", 3);
    freq.put("sie", 4);
    freq.put("dam", 6);
    freq.put("dan", 249);
    freq.put("uka", 12);
    freq.put("daj", 60);
    freq.put("dat", 19);
    freq.put("dav", 7);
    freq.put("jn ", 1187);
    freq.put("dar", 4);
    freq.put("das", 99);
    freq.put("ema", 148);
    freq.put("Pre", 8);
    freq.put("kpr", 8);
    freq.put("San", 5);
    freq.put("l ", 1979);
    freq.put("Sal", 4);
    freq.put("nfo", 7);
    freq.put("sio", 8);
    freq.put("Pro", 11);
    freq.put("nfl", 9);
    freq.put("Pri", 10);
    freq.put(" hu", 39);
    freq.put("leg\u0302", 7);
    freq.put("kpa", 3);
    freq.put(" hi", 21);
    freq.put(" ho", 239);
    freq.put(" ha", 314);
    freq.put("afs", 3);
    freq.put(" he", 108);
    freq.put("lfe", 48);
    freq.put("lfa", 29);
    freq.put("npl", 6);
    freq.put("lfo", 30);
    freq.put("lfi", 4);
    freq.put("ag\u0302e", 13);
    freq.put("C\u0302u ", 87);
    freq.put("De ", 22);
    freq.put("lfr", 90);
    freq.put("urg\u0302", 3);
    freq.put("Pau\u0306", 16);
    freq.put("og\u0302", 61);
    freq.put("rez", 43);
    freq.put(" Ec\u0302", 4);
    freq.put("rer", 7);
    freq.put("res", 287);
    freq.put("rep", 35);
    freq.put("rev", 94);
    freq.put("ret", 137);
    freq.put("rej", 11);
    freq.put("rek", 60);
    freq.put("Tuj", 8);
    freq.put("rei", 23);
    freq.put("ren", 387);
    freq.put("reo", 7);
    freq.put("rel", 23);
    freq.put("rem", 131);
    freq.put("reb", 12);
    freq.put("rec", 37);
    freq.put("rea", 6);
    freq.put("ref", 11);
    freq.put("reg", 63);
    freq.put("red", 167);
    freq.put("ree", 33);
    freq.put("lob", 3);
    freq.put("ece", 42);
    freq.put("eca", 13);
    freq.put("eco", 204);
    freq.put("eci", 53);
    freq.put("mig\u0302", 62);
    freq.put("urs\u0302", 9);
    freq.put("ltr", 65);
    freq.put("g", 3107);
    freq.put("rfo", 3);
    freq.put("ask", 53);
    freq.put("lta", 106);
    freq.put("lte", 144);
    freq.put("re ", 353);
    freq.put("lto", 28);
    freq.put(" Be", 25);
    freq.put("sev", 11);
    freq.put("daj\u0302", 40);
    freq.put("ud ", 44);
    freq.put("ars", 12);
    freq.put("iho", 4);
    freq.put("ses", 28);
    freq.put("ls\u0302", 19);
    freq.put("aru", 28);
    freq.put("mes", 40);
    freq.put("lor", 87);
    freq.put("For", 12);
    freq.put("uho", 3);
    freq.put("be ", 10);
    freq.put("nda", 314);
    freq.put(" St", 4);
    freq.put(" Su", 18);
    freq.put(" Sk", 5);
    freq.put("Mar", 110);
    freq.put(" Si", 58);
    freq.put(" Sn", 158);
    freq.put(" So", 3);
    freq.put(" Sm", 30);
    freq.put(" Sc", 7);
    freq.put(" Sa", 17);
    freq.put("mer", 30);
    freq.put(" Se", 214);
    freq.put("udr", 6);
    freq.put("Ka", 188);
    freq.put("rso", 33);
    freq.put("rsi", 10);
    freq.put("Ke", 16);
    freq.put("rse", 12);
    freq.put("Ki", 180);
    freq.put("Ko", 31);
    freq.put("rsa", 25);
    freq.put("Kl", 5);
    freq.put("Kr", 32);
    freq.put("ogo", 3);
    freq.put("R", 56);
    freq.put("ogi", 15);
    freq.put("Kv", 11);
    freq.put("Ku", 13);
    freq.put("ac\u0302j", 25);
    freq.put("ac\u0302e", 17);
    freq.put("lg\u0302", 44);
    freq.put("oga", 8);
    freq.put("udo", 11);
    freq.put("bej", 6);
    freq.put("bek", 3);
    freq.put("bei", 3);
    freq.put("ben", 29);
    freq.put("bel", 71);
    freq.put("ara", 203);
    freq.put("onc", 12);
    freq.put("nul", 39);
    freq.put("bed", 7);
    freq.put("bez", 34);
    freq.put("lj\u0302", 10);
    freq.put("ls\u0302a", 6);
    freq.put("ber", 58);
    freq.put("bes", 28);
    freq.put(" S ", 4);
    freq.put("bet", 28);
    freq.put("seb", 5);
    freq.put("Par", 13);
    freq.put("Pas", 8);
    freq.put("res\u0302", 17);
    freq.put("arg", 15);
    freq.put("Kap", 3);
    freq.put("ari", 508);
    freq.put("thf", 8);
    freq.put(" s\u0302n", 11);
    freq.put("Kla", 3);
    freq.put("asm", 3);
    freq.put("mik", 99);
    freq.put("ark", 52);
    freq.put("ur ", 431);
    freq.put("mil", 126);
    freq.put("lec", 35);
    freq.put("min", 270);
    freq.put("mia", 520);
    freq.put("arl", 44);
    freq.put("mie", 13);
    freq.put("mig", 37);
    freq.put("arm", 116);
    freq.put("miz", 6);
    freq.put("arn", 3);
    freq.put("mis", 127);
    freq.put("mir", 35);
    freq.put("mit", 21);
    freq.put(" El", 6);
    freq.put(" En", 35);
    freq.put(" Ek", 11);
    freq.put(" Ef", 9);
    freq.put(" Eb", 14);
    freq.put("Mic", 17);
    freq.put("rec\u0302", 6);
    freq.put("u\u0306vi", 4);
    freq.put(" Es", 54);
    freq.put("urd", 15);
    freq.put("Kaj", 131);
    freq.put("urg", 5);
    freq.put("u\u0306s\u0302a", 5);
    freq.put("il ", 13);
    freq.put("urb", 30);
    freq.put("urm", 43);
    freq.put("urn", 66);
    freq.put("uro", 123);
    freq.put("Por", 13);
    freq.put("Pos", 31);
    freq.put("urk", 14);
    freq.put("urt", 58);
    freq.put("uru", 14);
    freq.put("Pol", 4);
    freq.put("Dek", 4);
    freq.put("urp", 16);
    freq.put("S\u0302aj", 9);
    freq.put("urs", 5);
    freq.put("Dem", 3);
    freq.put("Iam", 3);
    freq.put("Den", 4);
    freq.put("Iaf", 4);
    freq.put("u\u0306st", 3);
    freq.put("lse", 26);
    freq.put("eda", 39);
    freq.put("nge", 70);
    freq.put("nga", 116);
    freq.put("co ", 221);
    freq.put("ngl", 16);
    freq.put("Mor", 7);
    freq.put(" ir", 119);
    freq.put("ngo", 61);
    freq.put("jar", 91);
    freq.put(" iu", 44);
    freq.put("kse", 10);
    freq.put("ngu", 22);
    freq.put("ngv", 23);
    freq.put("jam", 85);
    freq.put("jaj", 11);
    freq.put(" im", 30);
    freq.put(" in", 329);
    freq.put(" io", 173);
    freq.put(" ia", 79);
    freq.put("Au\u0306s", 4);
    freq.put(" id", 17);
    freq.put(" ie", 8);
    freq.put(" ig", 4);
    freq.put("nig\u0302", 47);
    freq.put("olu", 38);
    freq.put("s\u0302ka", 7);
    freq.put("g\u0302el", 8);
    freq.put("tba", 6);
    freq.put("lsi", 3);
    freq.put("aer", 9);
    freq.put("h", 1018);
    freq.put("lsu", 27);
    freq.put("she", 4);
    freq.put("dpa", 3);
    freq.put("ael", 16);
    freq.put("ja ", 60);
    freq.put("Jak", 5);
    freq.put("Pr", 29);
    freq.put("ebe", 10);
    freq.put("eba", 3);
    freq.put("c\u0302ig\u0302", 5);
    freq.put("ebo", 5);
    freq.put("oma", 62);
    freq.put("ke ", 856);
    freq.put("jo ", 167);
    freq.put("ebu", 3);
    freq.put("Pa", 42);
    freq.put("Kal", 4);
    freq.put("ebr", 10);
    freq.put("Pe", 16);
    freq.put("ede", 24);
    freq.put("g\u0302ul", 20);
    freq.put("tof", 3);
    freq.put("Po", 49);
    freq.put("Pl", 6);
    freq.put("lup", 4);
    freq.put("lur", 7);
    freq.put("lus", 35);
    freq.put("lut", 26);
    freq.put("luv", 13);
    freq.put("luz", 4);
    freq.put("lua", 21);
    freq.put("lud", 21);
    freq.put("lue", 6);
    freq.put("lug", 24);
    freq.put("lui", 8);
    freq.put("luj", 9);
    freq.put("lip", 17);
    freq.put("lul", 7);
    freq.put("omi", 26);
    freq.put("lun", 6);
    freq.put("luo", 18);
    freq.put("ken", 14);
    freq.put("kem", 11);
    freq.put("kel", 89);
    freq.put("kej", 8);
    freq.put("keg", 4);
    freq.put("ked", 3);
    freq.put("kec", 6);
    freq.put("keb", 4);
    freq.put("S", 522);
    freq.put("joj", 31);
    freq.put("ket", 20);
    freq.put("kes", 18);
    freq.put("ker", 5);
    freq.put("jon", 83);
    freq.put(" ae", 9);
    freq.put("etr", 27);
    freq.put("dic\u0302", 5);
    freq.put("etu", 111);
    freq.put("la", 4981);
    freq.put("lu ", 53);
    freq.put("tla", 3);
    freq.put("eta", 145);
    freq.put("ete", 150);
    freq.put("eti", 225);
    freq.put("eto", 221);
    freq.put("ksa", 12);
    freq.put("ci", 561);
    freq.put("rpr", 16);
    freq.put("rpu", 4);
    freq.put("omu", 10);
    freq.put("ca", 132);
    freq.put("omt", 3);
    freq.put("Lon", 8);
    freq.put("cf", 3);
    freq.put("ce", 442);
    freq.put("rpa", 24);
    freq.put("cy", 123);
    freq.put("ab", 288);
    freq.put("rpe", 12);
    freq.put("Hea", 8);
    freq.put("rpl", 5);
    freq.put("rpo", 18);
    freq.put("Ger", 6);
    freq.put("ag", 440);
    freq.put("af", 295);
    freq.put("Jun", 3);
    freq.put("uza", 13);
    freq.put("Geo", 4);
    freq.put("ak", 288);
    freq.put("oti", 7);
    freq.put("jag\u0302", 10);
    freq.put("lgo", 3);
    freq.put("lgl", 6);
    freq.put("oto", 14);
    freq.put("am", 1346);
    freq.put("lga", 15);
    freq.put("edo", 100);
    freq.put("ote", 22);
    freq.put("g\u0302it", 10);
    freq.put("uns", 4);
    freq.put("lgr", 63);
    freq.put("ilb", 9);
    freq.put("ins", 103);
    freq.put("otu", 5);
    freq.put("And", 4);
    freq.put("sj\u0302e", 4);
    freq.put("Ang", 9);
    freq.put("ndr", 45);
    freq.put("rbr", 4);
    freq.put("Ank", 10);
    freq.put("rbo", 131);
    freq.put("uir", 9);
    freq.put("rbi", 5);
    freq.put("rbe", 24);
    freq.put("rba", 22);
    freq.put("uit", 12);
    freq.put("va", 901);
    freq.put(" Fr", 16);
    freq.put("ve", 937);
    freq.put("vi", 2074);
    freq.put("g\u0302in", 291);
    freq.put("vm", 4);
    freq.put("avr", 7);
    freq.put("vo", 641);
    freq.put(" Fa", 5);
    freq.put("ind", 83);
    freq.put("vr", 42);
    freq.put("avo", 85);
    freq.put("vu", 131);
    freq.put(" Fi", 30);
    freq.put("ave", 44);
    freq.put("inf", 60);
    freq.put(" Fo", 17);
    freq.put("io ", 539);
    freq.put("ilv", 3);
    freq.put("ing", 150);
    freq.put("nod", 10);
    freq.put("g\u0302ig", 12);
    freq.put("dei", 3);
    freq.put("u\u0306li", 12);
    freq.put("une", 42);
    freq.put("ioz", 48);
    freq.put("osa", 9);
    freq.put("ios", 3);
    freq.put("ion", 557);
    freq.put("iom", 198);
    freq.put("ioj", 41);
    freq.put("von", 58);
    freq.put("c\u0302iu", 199);
    freq.put("c\u0302it", 6);
    freq.put("ofa", 3);
    freq.put("c\u0302is", 37);
    freq.put("ofe", 22);
    freq.put("i", 31548);
    freq.put("unl", 4);
    freq.put(" Tu", 28);
    freq.put("ofi", 23);
    freq.put(" Tr", 21);
    freq.put("ofl", 3);
    freq.put("ksi", 119);
    freq.put(" To", 6);
    freq.put("Duo", 3);
    freq.put("c\u0302ig", 3);
    freq.put("c\u0302if", 5);
    freq.put("c\u0302ia", 96);
    freq.put(" Ti", 242);
    freq.put("ofu", 40);
    freq.put("c\u0302il", 10);
    freq.put(" Te", 7);
    freq.put("c\u0302in", 4);
    freq.put(" Ta", 39);
    freq.put("u\u0306bo", 4);
    freq.put("uig\u0302", 10);
    freq.put(" me", 250);
    freq.put("c\u0302a ", 47);
    freq.put("mfo", 9);
    freq.put("g\u0302ia", 45);
    freq.put("tch", 158);
    freq.put("mpe", 37);
    freq.put("sku", 53);
    freq.put("Be", 25);
    freq.put("adu", 17);
    freq.put("adr", 3);
    freq.put("Ba", 21);
    freq.put("skr", 37);
    freq.put("Far", 4);
    freq.put("Bo", 19);
    freq.put("Bi", 10);
    freq.put("gme", 24);
    freq.put("ske", 4);
    freq.put("ade", 14);
    freq.put("ska", 64);
    freq.put("nor", 27);
    freq.put("Br", 90);
    freq.put("ada", 15);
    freq.put("s\u0302lo", 7);
    freq.put("skl", 40);
    freq.put("sko", 24);
    freq.put("adm", 14);
    freq.put("ski", 48);
    freq.put("adi", 343);
    freq.put("dvo", 30);
    freq.put("nfe", 12);
    freq.put("nve", 32);
    freq.put("T", 352);
    freq.put("nva", 6);
    freq.put("vag\u0302", 41);
    freq.put("nvo", 24);
    freq.put("nvi", 26);
    freq.put("u\u0306e", 108);
    freq.put("u\u0306d", 97);
    freq.put("u\u0306g", 11);
    freq.put("u\u0306f", 3);
    freq.put("u\u0306a", 42);
    freq.put("nfa", 59);
    freq.put("bus\u0302", 18);
    freq.put("u\u0306m", 7);
    freq.put("u\u0306l", 33);
    freq.put("u\u0306n", 5);
    freq.put("u\u0306i", 12);
    freq.put("u\u0306k", 4);
    freq.put("u\u0306tu", 8);
    freq.put("u\u0306t", 58);
    freq.put("u\u0306v", 10);
    freq.put("u\u0306p", 26);
    freq.put("u\u0306s", 47);
    freq.put("u\u0306r", 77);
    freq.put("u\u0306ta", 21);
    freq.put("u\u0306z", 41);
    freq.put("nja", 10);
    freq.put("kdo", 4);
    freq.put("Sub", 3);
    freq.put("ui ", 12);
    freq.put("kde", 13);
    freq.put("njo", 331);
    freq.put("jle", 4);
    freq.put("nfi", 40);
    freq.put("edz", 107);
    freq.put("kdu", 14);
    freq.put("jlo", 30);
    freq.put("esu", 16);
    freq.put("est", 1562);
    freq.put("esp", 219);
    freq.put("nd ", 4);
    freq.put("nfu", 10);
    freq.put("s\u0302nu", 11);
    freq.put("ese", 20);
    freq.put("g\u0302oj", 133);
    freq.put("pis\u0302", 3);
    freq.put("esa", 39);
    freq.put("eso", 54);
    freq.put("esk", 67);
    freq.put("esi", 85);
    freq.put("tmo", 3);
    freq.put("lle", 24);
    freq.put("ong\u0302", 10);
    freq.put("Us", 4);
    freq.put("Ur", 7);
    freq.put("Un", 45);
    freq.put("vaj\u0302", 16);
    freq.put("ndi", 295);
    freq.put("g\u0302ig\u0302", 18);
    freq.put("ndo", 214);
    freq.put(" ju", 93);
    freq.put("duo", 47);
    freq.put("nde", 53);
    freq.put("kru", 27);
    freq.put("ngi", 54);
    freq.put("kri", 134);
    freq.put("kro", 32);
    freq.put("es ", 145);
    freq.put(" je", 177);
    freq.put("kra", 18);
    freq.put(" ja", 184);
    freq.put("oet", 3);
    freq.put("kre", 87);
    freq.put("ea ", 4);
    freq.put("ngt", 5);
    freq.put("h ", 3);
    freq.put("vaj", 23);
    freq.put("vak", 4);
    freq.put("van", 160);
    freq.put("val", 33);
    freq.put("Ame", 3);
    freq.put("vag", 16);
    freq.put("vad", 40);
    freq.put("ubi", 28);
    freq.put("vaz", 76);
    freq.put("rco", 6);
    freq.put("rci", 5);
    freq.put("mut", 7);
    freq.put("var", 90);
    freq.put("vas", 303);
    freq.put("rca", 9);
    freq.put("vat", 11);
    freq.put("lc\u0302e", 3);
    freq.put("lc\u0302a", 9);
    freq.put("ean", 3);
    freq.put("s\u0302vi", 3);
    freq.put("but", 20);
    freq.put("hu", 43);
    freq.put("obo", 7);
    freq.put("hi", 22);
    freq.put("ho", 259);
    freq.put("bul", 24);
    freq.put("u\u0306s\u0302", 6);
    freq.put("ha", 366);
    freq.put("hf", 8);
    freq.put("eat", 16);
    freq.put("bud", 6);
    freq.put("he", 314);
    freq.put("dus", 16);
    freq.put("Tem", 3);
    freq.put("avi", 149);
    freq.put("dmi", 11);
    freq.put("va ", 79);
    freq.put("j", 8367);
    freq.put("dmo", 4);
    freq.put("lve", 47);
    freq.put("lva", 27);
    freq.put("lvo", 18);
    freq.put("lvi", 23);
    freq.put("pik", 6);
    freq.put("pil", 5);
    freq.put("pin", 49);
    freq.put("pio", 3);
    freq.put("int", 359);
    freq.put("inu", 26);
    freq.put("inv", 8);
    freq.put("pid", 66);
    freq.put("pie", 58);
    freq.put("pig", 8);
    freq.put("inl", 5);
    freq.put("inm", 3);
    freq.put("ino", 373);
    freq.put("ub ", 25);
    freq.put("ini", 102);
    freq.put("inj", 331);
    freq.put("ink", 60);
    freq.put("pip", 9);
    freq.put("ine", 85);
    freq.put("pir", 29);
    freq.put("pis", 38);
    freq.put("pit", 33);
    freq.put("ina", 57);
    freq.put("inb", 8);
    freq.put("inc", 12);
    freq.put("eo ", 21);
    freq.put(" Ur", 7);
    freq.put(" Us", 4);
    freq.put(" Un", 45);
    freq.put("oat", 124);
    freq.put("or ", 574);
    freq.put("nra", 6);
    freq.put("ubt", 9);
    freq.put("ubu", 16);
    freq.put("ubs", 9);
    freq.put("pi ", 19);
    freq.put("muf", 3);
    freq.put("gar", 239);
    freq.put("ube", 12);
    freq.put("Kel", 8);
    freq.put("U", 58);
    freq.put("uba", 12);
    freq.put("g\u0302i ", 347);
    freq.put("ubo", 22);
    freq.put("in ", 1151);
    freq.put(" gu", 11);
    freq.put("eoj", 3);
    freq.put("eon", 29);
    freq.put("eor", 12);
    freq.put("o ", 6195);
  }
  
}

