package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class DE extends CLangProfile {
  private static final String name = "de";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public DE() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 87197534;
    n_words[1] = 99298261;
    n_words[2] = 71857404;

    freq.put("ße ", 16400);
    freq.put("nwo", 19169);
    freq.put("auc", 75721);
    freq.put("aue", 19995);
    freq.put("Okt", 8850);
    freq.put("auf", 98508);
    freq.put("aum", 14540);
    freq.put("aup", 28995);
    freq.put("aus", 149891);
    freq.put("lt ", 63451);
    freq.put("aut", 27334);
    freq.put("G ", 11776);
    freq.put("pte", 12552);
    freq.put(" Gu", 10914);
    freq.put(" Gr", 74652);
    freq.put("ßen", 17047);
    freq.put("Joh", 10371);
    freq.put(" Ge", 150714);
    freq.put(" Ga", 33168);
    freq.put(" Go", 17225);
    freq.put(" Gl", 11774);
    freq.put(" Gi", 11192);
    freq.put("au ", 29621);
    freq.put("Gu", 11007);
    freq.put("Gr", 74845);
    freq.put("Ge", 151044);
    freq.put("Ga", 33294);
    freq.put("Go", 17306);
    freq.put("upt", 28543);
    freq.put("Gl", 11809);
    freq.put("Gi", 11262);
    freq.put(" ka", 23448);
    freq.put("me ", 36368);
    freq.put(" ko", 18379);
    freq.put(" kl", 13510);
    freq.put(" km", 15800);
    freq.put(" ku", 12534);
    freq.put("nen", 124634);
    freq.put("nel", 12298);
    freq.put("nem", 32650);
    freq.put("ho\u0308r", 33720);
    freq.put("neh", 18303);
    freq.put("ßt", 14023);
    freq.put("kur", 12239);
    freq.put("kun", 14388);
    freq.put("ße", 45162);
    freq.put("neu", 10682);
    freq.put("ner", 149716);
    freq.put("ßb", 17940);
    freq.put("mel", 10134);
    freq.put("men", 133736);
    freq.put("mei", 94533);
    freq.put("meh", 11820);
    freq.put("ors", 22259);
    freq.put("met", 20898);
    freq.put("mes", 11403);
    freq.put("mer", 74569);
    freq.put("gli", 40281);
    freq.put("Zi", 10309);
    freq.put("Ze", 31894);
    freq.put("k", 1042619);
    freq.put("gle", 20084);
    freq.put("ne ", 310275);
    freq.put("akt", 19509);
    freq.put("dri", 12382);
    freq.put("Zu", 19954);
    freq.put("Zw", 11243);
    freq.put("dre", 16392);
    freq.put("Kom", 17455);
    freq.put("Kon", 17432);
    freq.put("bru", 12222);
    freq.put("bri", 17955);
    freq.put("bre", 12676);
    freq.put("bra", 14742);
    freq.put("m ", 660573);
    freq.put("er ", 1578023);
    freq.put("a\u0308lt", 11293);
    freq.put("u\u0308dl", 8991);
    freq.put("ni ", 15548);
    freq.put("ssi", 42403);
    freq.put("Ste", 21247);
    freq.put("Sta", 109473);
    freq.put("o\u0308rt", 26727);
    freq.put("nkm", 14368);
    freq.put("Stu", 11271);
    freq.put("nkr", 10153);
    freq.put("nkt", 16086);
    freq.put("Str", 23794);
    freq.put("V", 203138);
    freq.put("iv", 65304);
    freq.put("me", 410943);
    freq.put("eru", 46595);
    freq.put("erv", 14305);
    freq.put("mf", 12265);
    freq.put("ma", 207608);
    freq.put("ltu", 37425);
    freq.put("err", 51760);
    freq.put("mb", 77222);
    freq.put("mm", 108620);
    freq.put("ml", 10335);
    freq.put("mo", 55705);
    freq.put("mi", 238709);
    freq.put("erz", 20677);
    freq.put("mu", 48362);
    freq.put("mt", 36178);
    freq.put("erf", 36150);
    freq.put("erg", 76890);
    freq.put("mp", 57358);
    freq.put("ms", 30817);
    freq.put("erl", 56900);
    freq.put("erm", 29678);
    freq.put("ern", 139910);
    freq.put("ero", 15582);
    freq.put("erh", 33322);
    freq.put("eri", 118551);
    freq.put("erk", 45646);
    freq.put("Le", 49783);
    freq.put("io", 214368);
    freq.put("La", 89578);
    freq.put("Lo", 26047);
    freq.put("Lin", 9234);
    freq.put("uar", 22497);
    freq.put("la ", 19811);
    freq.put("Li", 55021);
    freq.put("Lu", 17469);
    freq.put("Lis", 12636);
    freq.put("hof", 13254);
    freq.put("ena", 52256);
    freq.put("enb", 41104);
    freq.put("ib", 46123);
    freq.put("end", 112707);
    freq.put("hoc", 13003);
    freq.put("enf", 15937);
    freq.put("eng", 41769);
    freq.put("enh", 15362);
    freq.put("eni", 28822);
    freq.put("hol", 19495);
    freq.put("enk", 30270);
    freq.put("enl", 8977);
    freq.put("Kan", 19278);
    freq.put("enn", 31346);
    freq.put("eno", 10734);
    freq.put("Kar", 13767);
    freq.put("enr", 9992);
    freq.put("ens", 113000);
    freq.put("hor", 9009);
    freq.put("enz", 28843);
    freq.put("Rhe", 11094);
    freq.put("A", 448295);
    freq.put("lan", 114878);
    freq.put("lag", 29983);
    freq.put("lac", 9475);
    freq.put("O\u0308", 13881);
    freq.put("lat", 31357);
    freq.put("lau", 19611);
    freq.put("ovi", 27674);
    freq.put("lti", 11054);
    freq.put("lar", 12710);
    freq.put("las", 30573);
    freq.put("en ", 1453342);
    freq.put("ma\u0308", 18127);
    freq.put("ero\u0308", 10701);
    freq.put("a\u0308ch", 26798);
    freq.put("mo\u0308", 8912);
    freq.put("Alt", 10907);
    freq.put("Als", 17057);
    freq.put("wur", 70546);
    freq.put("zei", 75965);
    freq.put("zen", 43803);
    freq.put(" Hu", 10983);
    freq.put("zem", 9613);
    freq.put("zer", 23898);
    freq.put("zes", 9884);
    freq.put(" Hi", 21530);
    freq.put("oni", 29183);
    freq.put(" Ho", 42078);
    freq.put("zeu", 11441);
    freq.put(" Ha", 86258);
    freq.put(" He", 62512);
    freq.put("ima", 11905);
    freq.put("ro\u0308", 38038);
    freq.put("ime", 10380);
    freq.put("ru\u0308", 63451);
    freq.put("imm", 16766);
    freq.put("ra\u0308", 41054);
    freq.put("fin", 25920);
    freq.put("fil", 11145);
    freq.put(" Va", 14382);
    freq.put("ze ", 15773);
    freq.put("ona", 50054);
    freq.put(" Ve", 103873);
    freq.put(" Vi", 22523);
    freq.put(" Vo", 36449);
    freq.put("im ", 225234);
    freq.put("l", 3150399);
    freq.put("th ", 15758);
    freq.put(" Ho\u0308", 9372);
    freq.put("nt ", 97967);
    freq.put("rt", 385464);
    freq.put("ru", 174667);
    freq.put("rv", 18995);
    freq.put("rw", 59814);
    freq.put("rp", 30886);
    freq.put("rr", 85173);
    freq.put("rs", 267473);
    freq.put(" ze", 10132);
    freq.put("ry", 19301);
    freq.put("rz", 76103);
    freq.put("rd", 287337);
    freq.put("re", 658545);
    freq.put("rf", 74192);
    freq.put("rg", 185502);
    freq.put("ra", 423969);
    freq.put("rb", 105570);
    freq.put("rc", 86223);
    freq.put("rl", 93135);
    freq.put("rm", 96942);
    freq.put("rn", 187691);
    freq.put("is ", 120788);
    freq.put("rh", 58397);
    freq.put("ri", 506618);
    freq.put("rk", 131828);
    freq.put("nty", 16624);
    freq.put("nts", 23619);
    freq.put("ntr", 27593);
    freq.put("ntw", 17792);
    freq.put("nig", 30567);
    freq.put("nti", 33190);
    freq.put("nth", 12699);
    freq.put("ntl", 20923);
    freq.put("W", 221377);
    freq.put("nta", 24938);
    freq.put("nte", 156191);
    freq.put("ate", 62804);
    freq.put("ata", 11051);
    freq.put("iss", 46444);
    freq.put("ato", 14091);
    freq.put("rz ", 21038);
    freq.put("ath", 22536);
    freq.put("ist", 567635);
    freq.put("att", 42075);
    freq.put("atu", 18974);
    freq.put("r ", 1993661);
    freq.put("ats", 11481);
    freq.put("ism", 9438);
    freq.put("isc", 434611);
    freq.put("isa", 10445);
    freq.put("atz", 18097);
    freq.put(" Sp", 54582);
    freq.put("ise", 39335);
    freq.put("nhe", 16114);
    freq.put("fu\u0308h", 22557);
    freq.put("nha", 17909);
    freq.put("on ", 380926);
    freq.put("oße", 10850);
    freq.put("nis", 144657);
    freq.put("o\u0308si", 20607);
    freq.put("fu\u0308r", 75640);
    freq.put("tem", 46999);
    freq.put(" gi", 8908);
    freq.put("tor", 56677);
    freq.put("niv", 12854);
    freq.put(" Sh", 9926);
    freq.put("nz ", 37982);
    freq.put("ton", 34822);
    freq.put("tom", 9404);
    freq.put("tob", 10974);
    freq.put("raß", 12628);
    freq.put("kt ", 30020);
    freq.put(" le", 19412);
    freq.put("B", 452862);
    freq.put(" la", 25753);
    freq.put(" li", 42027);
    freq.put("Ser", 9549);
    freq.put("Sep", 9592);
    freq.put("ktu", 9324);
    freq.put("i\u0301", 8823);
    freq.put("ktr", 9556);
    freq.put("See", 8773);
    freq.put("kto", 15493);
    freq.put("kti", 30020);
    freq.put("nze", 40975);
    freq.put("kte", 20495);
    freq.put("nzi", 11904);
    freq.put("thu", 10251);
    freq.put("Sei", 11021);
    freq.put("raf", 18926);
    freq.put("rag", 25026);
    freq.put("rad", 17310);
    freq.put("rab", 8938);
    freq.put("rac", 30425);
    freq.put("ran", 87263);
    freq.put("ral", 31964);
    freq.put("ram", 18048);
    freq.put("ty ", 26382);
    freq.put("ose", 16100);
    freq.put("rai", 10459);
    freq.put("lba", 8767);
    freq.put("rat", 45378);
    freq.put("rau", 34010);
    freq.put("rar", 8924);
    freq.put("ras", 13690);
    freq.put("rap", 8929);
    freq.put("ter", 318918);
    freq.put("tsg", 8757);
    freq.put("hul", 13709);
    freq.put("hun", 26557);
    freq.put("Qu", 12167);
    freq.put("ra ", 23418);
    freq.put("bst", 12657);
    freq.put("lb ", 10692);
    freq.put("rsc", 59984);
    freq.put("don", 10905);
    freq.put("nzo\u0308", 20567);
    freq.put("Fuß", 15716);
    freq.put("m", 2035145);
    freq.put("dor", 21874);
    freq.put(" We", 76915);
    freq.put(" Wa", 43907);
    freq.put("e\u0301p", 12471);
    freq.put("d ", 722683);
    freq.put(" Wi", 47141);
    freq.put("oge", 19173);
    freq.put("rta", 10712);
    freq.put("och", 36284);
    freq.put("ock", 28973);
    freq.put("em ", 162112);
    freq.put("zte", 9874);
    freq.put("hrt", 21145);
    freq.put("u\u0308r ", 75451);
    freq.put("hri", 38046);
    freq.put("hre", 87475);
    freq.put("dn", 16795);
    freq.put("do", 69104);
    freq.put("dl", 45536);
    freq.put("wa\u0308", 21780);
    freq.put("dk", 27018);
    freq.put("dh", 11418);
    freq.put("di", 398882);
    freq.put("dg", 9266);
    freq.put("de", 1831853);
    freq.put("db", 9156);
    freq.put("da", 176290);
    freq.put("dw", 22283);
    freq.put("dt", 100722);
    freq.put("du", 88105);
    freq.put("dr", 54467);
    freq.put("ds", 46937);
    freq.put("eme", 116815);
    freq.put("bau", 19849);
    freq.put("bar", 18594);
    freq.put("u\u0308rt", 8780);
    freq.put("emb", 35370);
    freq.put("emi", 15129);
    freq.put("zt ", 19861);
    freq.put("nes", 53346);
    freq.put("bac", 14708);
    freq.put("ban", 20200);
    freq.put("bal", 24830);
    freq.put("hr ", 43100);
    freq.put("bah", 12251);
    freq.put("om ", 33290);
    freq.put("w ", 36904);
    freq.put("nur", 9530);
    freq.put("Per", 13707);
    freq.put("nun", 33102);
    freq.put("ru\u0308n", 30393);
    freq.put("ru\u0308h", 12452);
    freq.put("oma", 20160);
    freq.put("ru\u0308c", 12801);
    freq.put("nua", 9860);
    freq.put("il ", 53074);
    freq.put("irt", 10794);
    freq.put("irk", 24645);
    freq.put("irc", 21452);
    freq.put("ird", 46859);
    freq.put("ire", 14375);
    freq.put("we", 246633);
    freq.put("wa", 198781);
    freq.put("wo", 47417);
    freq.put("omi", 13337);
    freq.put(" Is", 10643);
    freq.put("omo", 11157);
    freq.put("wi", 176498);
    freq.put("wu", 73059);
    freq.put("omp", 19252);
    freq.put(" Im", 11222);
    freq.put(" In", 77993);
    freq.put("kom", 22572);
    freq.put("eln", 17751);
    freq.put("ild", 30027);
    freq.put("ile", 21718);
    freq.put("unt", 60343);
    freq.put("ell", 119434);
    freq.put("ilo", 17887);
    freq.put("ill", 36002);
    freq.put("ilm", 27378);
    freq.put("ili", 52680);
    freq.put("und", 450828);
    freq.put("ung", 313251);
    freq.put("uni", 19103);
    freq.put("unk", 20377);
    freq.put(" me", 26065);
    freq.put("ela", 19480);
    freq.put(" ma", 27726);
    freq.put("elf", 9116);
    freq.put(" mi", 107786);
    freq.put("eld", 20851);
    freq.put("ele", 71198);
    freq.put("san", 12568);
    freq.put("fra", 26521);
    freq.put("iß", 9834);
    freq.put("fri", 12770);
    freq.put("C ", 14623);
    freq.put("ai ", 14358);
    freq.put("Ch", 45017);
    freq.put("Co", 64248);
    freq.put("Cl", 9563);
    freq.put("Ca", 33967);
    freq.put("ais", 13530);
    freq.put("n", 7859499);
    freq.put("ain", 24754);
    freq.put("sla", 20592);
    freq.put("Nac", 12244);
    freq.put("iz", 46043);
    freq.put("tzu", 9903);
    freq.put("tzt", 23155);
    freq.put("ip", 33386);
    freq.put("is", 1295546);
    freq.put("ir", 170539);
    freq.put("iu", 24806);
    freq.put("it", 570135);
    freq.put("Nam", 20762);
    freq.put("ih", 35970);
    freq.put("ik", 165059);
    freq.put("ld ", 26676);
    freq.put("im", 289814);
    freq.put("il", 298251);
    freq.put("Nat", 19706);
    freq.put("in", 1828758);
    freq.put("ia", 115654);
    freq.put("ic", 534870);
    freq.put("ki ", 9579);
    freq.put("ie", 1150659);
    freq.put("id", 80042);
    freq.put("ig", 262184);
    freq.put("if", 71985);
    freq.put("V ", 9454);
    freq.put("a\u0308nd", 29875);
    freq.put("a\u0308ng", 21244);
    freq.put("fru\u0308", 9222);
    freq.put("a\u0308n", 69784);
    freq.put("nik", 13041);
    freq.put("a\u0308l", 29341);
    freq.put("nin", 9152);
    freq.put("a\u0308h", 39944);
    freq.put("kis", 9934);
    freq.put("kir", 9307);
    freq.put("a\u0308d", 10841);
    freq.put("nia", 9121);
    freq.put("a\u0308c", 27469);
    freq.put("nie", 44175);
    freq.put("tz ", 51212);
    freq.put("Y", 16379);
    freq.put("i ", 187041);
    freq.put("a\u0308t", 44405);
    freq.put("a\u0308u", 30285);
    freq.put("a\u0308r", 37279);
    freq.put("a\u0308s", 15220);
    freq.put("nit", 17226);
    freq.put("mil", 28731);
    freq.put("Va", 14430);
    freq.put("Ve", 104056);
    freq.put("Vi", 22665);
    freq.put("ept", 13647);
    freq.put("epu", 9001);
    freq.put("Vo", 36505);
    freq.put("tho", 19217);
    freq.put("the", 36369);
    freq.put("tha", 11467);
    freq.put("rn ", 74871);
    freq.put("yer", 10735);
    freq.put("eli", 22926);
    freq.put("hal", 38788);
    freq.put("han", 36578);
    freq.put("elm", 9454);
    freq.put("elb", 18844);
    freq.put("elc", 11326);
    freq.put("hab", 9073);
    freq.put("Gat", 12348);
    freq.put("Ho\u0308", 9378);
    freq.put("haf", 79189);
    freq.put("Or", 58036);
    freq.put("els", 30215);
    freq.put("har", 21603);
    freq.put("hat", 27886);
    freq.put("hau", 37347);
    freq.put("elt", 58131);
    freq.put("rni", 11673);
    freq.put("D", 565432);
    freq.put("Tra", 12824);
    freq.put("rna", 25318);
    freq.put("rne", 34331);
    freq.put("opa", 9142);
    freq.put("rns", 12992);
    freq.put("oph", 11323);
    freq.put("lch", 16014);
    freq.put("Art", 17165);
    freq.put("eze", 57686);
    freq.put("gke", 10880);
    freq.put("el ", 101100);
    freq.put("o\u0308ff", 11553);
    freq.put("ola", 9778);
    freq.put("old", 10163);
    freq.put("ole", 12997);
    freq.put("olg", 16083);
    freq.put(" Ju", 32722);
    freq.put("oli", 42117);
    freq.put("olk", 11956);
    freq.put("oll", 31645);
    freq.put("olo", 30821);
    freq.put(" Jo", 24054);
    freq.put(" Je", 11187);
    freq.put(" Ja", 77578);
    freq.put("ick", 25712);
    freq.put("ich", 454249);
    freq.put("for", 35090);
    freq.put("Lei", 11844);
    freq.put("ica", 15678);
    freq.put("Hu", 11017);
    freq.put("ume", 14114);
    freq.put("zu ", 51921);
    freq.put("Hi", 21572);
    freq.put("Ho", 42207);
    freq.put("umb", 12929);
    freq.put("fol", 14926);
    freq.put("Ha", 86398);
    freq.put("He", 62608);
    freq.put("hse", 23032);
    freq.put("hst", 18465);
    freq.put("zur", 37734);
    freq.put("zus", 11821);
    freq.put("obe", 24203);
    freq.put("o", 2714321);
    freq.put("zug", 11138);
    freq.put("zun", 15443);
    freq.put("zum", 31618);
    freq.put("chu", 40552);
    freq.put("ppe", 33120);
    freq.put("mbe", 37028);
    freq.put("ahn", 21966);
    freq.put("sol", 10161);
    freq.put("ahl", 22279);
    freq.put("ahm", 10952);
    freq.put("ahr", 74469);
    freq.put("sor", 15536);
    freq.put("Fer", 11772);
    freq.put("sow", 18519);
    freq.put("Pfa", 9319);
    freq.put("wan", 13038);
    freq.put("wal", 31257);
    freq.put("gis", 26824);
    freq.put("Pfl", 9335);
    freq.put("gie", 31403);
    freq.put("gio", 29407);
    freq.put("gin", 15255);
    freq.put("mt ", 15320);
    freq.put("war", 103047);
    freq.put("no\u0308", 10879);
    freq.put("so ", 11408);
    freq.put("Z", 96079);
    freq.put("Vol", 11987);
    freq.put("wa ", 19878);
    freq.put("Vor", 17501);
    freq.put("mte", 10917);
    freq.put("u\u0308t", 16867);
    freq.put("u\u0308r", 122114);
    freq.put("u\u0308s", 17438);
    freq.put("nni", 11264);
    freq.put("Sit", 13505);
    freq.put("nne", 52732);
    freq.put("u\u0308g", 9236);
    freq.put("u\u0308d", 43250);
    freq.put("u\u0308b", 39622);
    freq.put(" Li", 54819);
    freq.put("Sie", 53287);
    freq.put("u\u0308n", 62239);
    freq.put("nnt", 52262);
    freq.put("nns", 10154);
    freq.put("u\u0308h", 43336);
    freq.put("nke", 16356);
    freq.put("nh", 45861);
    freq.put("ni", 342822);
    freq.put("nk", 102273);
    freq.put("nl", 39986);
    freq.put("nm", 15381);
    freq.put("nn", 190420);
    freq.put("no", 90394);
    freq.put("tit", 14488);
    freq.put("na", 304264);
    freq.put("nb", 61884);
    freq.put("nc", 42156);
    freq.put("nd", 1104110);
    freq.put("ne", 802403);
    freq.put("nf", 54695);
    freq.put("ng", 588331);
    freq.put("ny", 13727);
    freq.put("nz", 136146);
    freq.put("tio", 114009);
    freq.put("tik", 35201);
    freq.put("tie", 28029);
    freq.put("nr", 20689);
    freq.put("ns", 309893);
    freq.put("nt", 478161);
    freq.put("nu", 74735);
    freq.put("nv", 14218);
    freq.put("nw", 36447);
    freq.put(" ni", 22730);
    freq.put("E", 313466);
    freq.put(" no", 19195);
    freq.put(" na", 48500);
    freq.put("a\u0308rz", 9551);
    freq.put(" ne", 14510);
    freq.put("nn ", 35057);
    freq.put("mun", 19505);
    freq.put(" nu", 10713);
    freq.put("Wie", 10497);
    freq.put("ums", 9212);
    freq.put("n ", 2940210);
    freq.put("Wil", 11137);
    freq.put("fa\u0308", 14922);
    freq.put("o\u0308ßt", 9800);
    freq.put("rol", 12320);
    freq.put("rom", 12509);
    freq.put("ron", 32055);
    freq.put("lls", 25768);
    freq.put("oss", 15828);
    freq.put("o\u0308rd", 14857);
    freq.put("rod", 18103);
    freq.put("ost", 26924);
    freq.put("rof", 8772);
    freq.put("rog", 9738);
    freq.put("lli", 30333);
    freq.put("rop", 24374);
    freq.put("lla", 17394);
    freq.put("ros", 12129);
    freq.put("rot", 11834);
    freq.put("rov", 26322);
    freq.put("ver", 144066);
    freq.put("umf", 9413);
    freq.put("Das", 56242);
    freq.put("ven", 17663);
    freq.put("vem", 8808);
    freq.put("Ma\u0308", 13878);
    freq.put("ey ", 16388);
    freq.put("ro ", 10671);
    freq.put("erw", 47997);
    freq.put("Mu\u0308", 11354);
    freq.put("ll ", 39906);
    freq.put("nla", 20752);
    freq.put("din", 14965);
    freq.put("die", 268782);
    freq.put("ers", 190257);
    freq.put("gun", 24014);
    freq.put("gus", 11665);
    freq.put("p", 756433);
    freq.put("ve ", 14670);
    freq.put("der", 838163);
    freq.put("dis", 37105);
    freq.put("hte", 48599);
    freq.put("Gru", 19222);
    freq.put("hti", 8985);
    freq.put("sre", 10655);
    freq.put("htu", 10990);
    freq.put("Rei", 15453);
    freq.put("hts", 18003);
    freq.put("Gra", 17232);
    freq.put("Rec", 10719);
    freq.put("Reg", 42336);
    freq.put("erd", 42731);
    freq.put("ere", 140461);
    freq.put(" u\u0308b", 31186);
    freq.put("roß", 19513);
    freq.put("era", 58724);
    freq.put("Me", 64987);
    freq.put("rua", 8770);
    freq.put("Ma", 116460);
    freq.put("erb", 63293);
    freq.put("ht ", 81034);
    freq.put("Mo", 46837);
    freq.put("Mi", 68245);
    freq.put("ufe", 13329);
    freq.put("Mu", 29273);
    freq.put("SA", 9500);
    freq.put("ma ", 15588);
    freq.put("eka", 19118);
    freq.put("ekt", 37882);
    freq.put("pla", 12193);
    freq.put(" Ka", 74525);
    freq.put(" Ke", 14835);
    freq.put("aye", 9954);
    freq.put(" Ki", 37849);
    freq.put(" Ko", 56929);
    freq.put(" Kl", 25011);
    freq.put(" Kr", 45960);
    freq.put(" Ku", 30157);
    freq.put("ca ", 13669);
    freq.put("Mon", 12046);
    freq.put("Bei", 10336);
    freq.put("F", 303463);
    freq.put("Beg", 14069);
    freq.put("Bez", 18543);
    freq.put("Ber", 42078);
    freq.put("Bes", 11001);
    freq.put("bge", 10311);
    freq.put("su\u0308", 19128);
    freq.put("flu", 9809);
    freq.put("ay ", 9249);
    freq.put("ult", 19564);
    freq.put("uli", 15580);
    freq.put("fla", 12837);
    freq.put("ula", 10852);
    freq.put("ibt", 8975);
    freq.put("sa\u0308", 14628);
    freq.put("Min", 10015);
    freq.put(" of", 20927);
    freq.put(" od", 67197);
    freq.put("spi", 46629);
    freq.put("spo", 10155);
    freq.put("spa", 12483);
    freq.put("Mit", 29518);
    freq.put(" Ko\u0308", 16410);
    freq.put("sst", 37624);
    freq.put("s ", 1183348);
    freq.put("um ", 104918);
    freq.put("mar", 19548);
    freq.put("mat", 30614);
    freq.put("use", 25762);
    freq.put("mal", 49935);
    freq.put("ene", 83278);
    freq.put("sz", 17514);
    freq.put("sy", 19371);
    freq.put("ss", 289880);
    freq.put("sr", 21109);
    freq.put("sp", 131491);
    freq.put("sw", 26360);
    freq.put("sv", 12561);
    freq.put("su", 36834);
    freq.put("st", 1222626);
    freq.put("q", 20503);
    freq.put("si", 322120);
    freq.put("sh", 47160);
    freq.put("so", 116426);
    freq.put("sm", 28595);
    freq.put("sl", 40519);
    freq.put("sc", 827974);
    freq.put("sb", 46727);
    freq.put("sa", 109787);
    freq.put("sg", 56341);
    freq.put("sf", 20622);
    freq.put("se", 456715);
    freq.put("sd", 16337);
    freq.put("Ru", 19547);
    freq.put("lsc", 14894);
    freq.put("Chi", 9883);
    freq.put("no ", 11518);
    freq.put("ttu", 15931);
    freq.put("Jan", 11806);
    freq.put("Re", 106782);
    freq.put("Chr", 9059);
    freq.put("Ra", 38143);
    freq.put("Jah", 47539);
    freq.put("Ro", 44332);
    freq.put("Rh", 15491);
    freq.put("Ri", 24028);
    freq.put("tte", 89035);
    freq.put(" ab", 26560);
    freq.put("a\u0308hl", 11359);
    freq.put("gte", 17882);
    freq.put("ssa", 12522);
    freq.put(" al", 101826);
    freq.put(" am", 69685);
    freq.put(" an", 87925);
    freq.put("eß", 9854);
    freq.put(" au", 256133);
    freq.put("ent", 181395);
    freq.put("a\u0308hr", 16538);
    freq.put("nom", 14191);
    freq.put("ls ", 107647);
    freq.put("ert", 122552);
    freq.put("R ", 11116);
    freq.put("ng ", 256902);
    freq.put("son", 33802);
    freq.put("nor", 17522);
    freq.put("gt ", 53228);
    freq.put("tti", 9403);
    freq.put("em", 396788);
    freq.put("el", 553287);
    freq.put("eo", 41207);
    freq.put("en", 2309793);
    freq.put("ei", 1578594);
    freq.put("eh", 196157);
    freq.put("ek", 82123);
    freq.put("ee", 58149);
    freq.put("ed", 151386);
    freq.put("eg", 232810);
    freq.put("ef", 68699);
    freq.put("ea", 71177);
    freq.put("ec", 131420);
    freq.put("eb", 165228);
    freq.put("ey", 30641);
    freq.put("ex", 29126);
    freq.put("ez", 98518);
    freq.put("eu", 212719);
    freq.put("et", 380175);
    freq.put("ew", 66696);
    freq.put("ev", 25427);
    freq.put("ep", 49360);
    freq.put("es", 772223);
    freq.put("er", 2971302);
    freq.put("bli", 23577);
    freq.put("za\u0308", 9571);
    freq.put("ble", 9072);
    freq.put("nic", 23391);
    freq.put("rli", 33691);
    freq.put("G", 350968);
    freq.put("rle", 11502);
    freq.put("erp", 11457);
    freq.put("ort", 57075);
    freq.put("zel", 10023);
    freq.put("rla", 23240);
    freq.put("e ", 2082290);
    freq.put("orn", 17190);
    freq.put("orm", 35190);
    freq.put("ork", 11076);
    freq.put("ori", 35553);
    freq.put("orf", 23363);
    freq.put("org", 24171);
    freq.put("ord", 64827);
    freq.put("ore", 22869);
    freq.put("U\u0308", 10506);
    freq.put("ora", 13071);
    freq.put("u\u0308ck", 19105);
    freq.put("rwe", 21555);
    freq.put("xi", 15762);
    freq.put("onn", 12427);
    freq.put("ono", 12443);
    freq.put("ove", 15851);
    freq.put("ong", 12616);
    freq.put("ond", 30722);
    freq.put("one", 41633);
    freq.put("ons", 40673);
    freq.put("ont", 24319);
    freq.put("Eur", 10652);
    freq.put("ial", 21666);
    freq.put("ian", 25164);
    freq.put("De\u0301", 12333);
    freq.put("ukt", 12384);
    freq.put("ule", 13595);
    freq.put("iat", 10334);
    freq.put(" Zi", 10283);
    freq.put(" Ze", 31828);
    freq.put("hum", 9803);
    freq.put("x ", 21295);
    freq.put("ebi", 30463);
    freq.put(" Zu", 19747);
    freq.put(" Zw", 11238);
    freq.put("rze", 22030);
    freq.put("ia ", 36994);
    freq.put("r", 6424621);
    freq.put("and", 264094);
    freq.put("ane", 16424);
    freq.put("ang", 74734);
    freq.put("pra", 20767);
    freq.put("ana", 30762);
    freq.put("sam", 29233);
    freq.put("anc", 17098);
    freq.put("ann", 95807);
    freq.put("ano", 9997);
    freq.put("pri", 21158);
    freq.put("ani", 87171);
    freq.put("ank", 29449);
    freq.put("ant", 49762);
    freq.put("anu", 15776);
    freq.put("ans", 31362);
    freq.put("anz", 50908);
    freq.put("sat", 17995);
    freq.put("Do", 28882);
    freq.put("Di", 188563);
    freq.put("De", 166635);
    freq.put("Da", 90985);
    freq.put("Du", 11229);
    freq.put("Dr", 19902);
    freq.put("an ", 124982);
    freq.put("ust", 38480);
    freq.put("net", 57023);
    freq.put(" Le", 49575);
    freq.put(" La", 89327);
    freq.put("uss", 45929);
    freq.put(" Lo", 25969);
    freq.put("D ", 9913);
    freq.put(" Lu", 17420);
    freq.put("tze", 24373);
    freq.put("Wei", 14673);
    freq.put("Wel", 14947);
    freq.put("Wes", 22169);
    freq.put("Wer", 11351);
    freq.put("ge ", 89868);
    freq.put("nli", 11747);
    freq.put("ss ", 36271);
    freq.put("We", 77082);
    freq.put("Wa", 44055);
    freq.put("Wo", 21476);
    freq.put("iti", 55617);
    freq.put("Wi", 47351);
    freq.put("itg", 12750);
    freq.put("ges", 76492);
    freq.put(" pr", 15398);
    freq.put("gew", 20591);
    freq.put("get", 10602);
    freq.put("H", 264836);
    freq.put("geb", 50080);
    freq.put("sso", 12151);
    freq.put("geg", 29832);
    freq.put("gef", 16578);
    freq.put("sse", 110613);
    freq.put("geh", 39393);
    freq.put(" po", 16457);
    freq.put("gen", 239581);
    freq.put("gem", 34840);
    freq.put("gel", 53887);
    freq.put("ehm", 19125);
    freq.put("ute", 38886);
    freq.put("itz", 41656);
    freq.put("rks", 11567);
    freq.put("uto", 20186);
    freq.put("rma", 31109);
    freq.put("rme", 19061);
    freq.put("rmi", 10506);
    freq.put("ffe", 34346);
    freq.put("uts", 91328);
    freq.put("tur", 43568);
    freq.put("utz", 15915);
    freq.put("rm ", 16219);
    freq.put("Kri", 9328);
    freq.put("tum", 9791);
    freq.put("tun", 79448);
    freq.put("je", 30947);
    freq.put("ja", 19963);
    freq.put("Kre", 22963);
    freq.put(" be", 204994);
    freq.put("z", 844832);
    freq.put(" ba", 8860);
    freq.put(" bi", 45326);
    freq.put("P ", 9001);
    freq.put("zw ", 9786);
    freq.put("s", 5151894);
    freq.put(" br", 14611);
    freq.put(" bz", 9809);
    freq.put("por", 21385);
    freq.put("pol", 21212);
    freq.put(" Ma\u0308", 13877);
    freq.put("Bur", 11846);
    freq.put("ln ", 17395);
    freq.put("ei ", 84962);
    freq.put("Bun", 26145);
    freq.put(" Mu\u0308", 11350);
    freq.put("dkr", 22973);
    freq.put("eis", 113764);
    freq.put("eit", 174763);
    freq.put("eiz", 17159);
    freq.put("eic", 136250);
    freq.put("eib", 17640);
    freq.put("eie", 15075);
    freq.put("eid", 22147);
    freq.put("eig", 23796);
    freq.put("eih", 11402);
    freq.put("eim", 26661);
    freq.put("eil", 79634);
    freq.put("u\u0308c", 24866);
    freq.put("ive", 36462);
    freq.put("ivi", 10241);
    freq.put("Bar", 8982);
    freq.put("Bas", 9343);
    freq.put(" Me", 64810);
    freq.put("par", 30140);
    freq.put(" Ma", 116111);
    freq.put(" Mo", 46674);
    freq.put(" Mi", 68090);
    freq.put(" Mu", 29161);
    freq.put("I ", 13640);
    freq.put("pan", 20821);
    freq.put("nac", 41308);
    freq.put("I", 169730);
    freq.put("eiß", 9569);
    freq.put("gru", 14203);
    freq.put("Is", 10695);
    freq.put("Im", 11278);
    freq.put("In", 78332);
    freq.put("tiv", 26072);
    freq.put("am ", 57496);
    freq.put("nam", 18687);
    freq.put("tim", 13478);
    freq.put("tin", 30024);
    freq.put(" ge", 155650);
    freq.put("ami", 43004);
    freq.put("amm", 42375);
    freq.put("zwi", 20415);
    freq.put("ama", 13307);
    freq.put("amb", 11361);
    freq.put("ame", 78887);
    freq.put("oß", 20955);
    freq.put("mon", 13165);
    freq.put("amp", 12259);
    freq.put("amt", 12217);
    freq.put("ß", 107796);
    freq.put("tig", 44003);
    freq.put("t", 5309288);
    freq.put("ßer", 9786);
    freq.put("gri", 24893);
    freq.put("zwe", 22370);
    freq.put("Kul", 11508);
    freq.put("ezi", 30267);
    freq.put("New", 10171);
    freq.put("Neu", 14698);
    freq.put(" ch", 11442);
    freq.put("kma", 10480);
    freq.put("Men", 8765);
    freq.put("o ", 123676);
    freq.put("Met", 15567);
    freq.put("uch", 109126);
    freq.put("ro\u0308ß", 14321);
    freq.put("Dre", 10394);
    freq.put("oo", 24531);
    freq.put("on", 667125);
    freq.put("om", 176521);
    freq.put("ol", 220141);
    freq.put("ok", 27868);
    freq.put("ace", 11312);
    freq.put("km ", 11509);
    freq.put("ack", 9729);
    freq.put("of", 64141);
    freq.put("oe", 10022);
    freq.put("ach", 145520);
    freq.put("oc", 78480);
    freq.put("ob", 51225);
    freq.put("oa", 14277);
    freq.put("oz", 19078);
    freq.put("ow", 58643);
    freq.put("ov", 54069);
    freq.put("ou", 69753);
    freq.put("ot", 88470);
    freq.put("os", 118609);
    freq.put("or", 433879);
    freq.put("op", 68308);
    freq.put("Ni", 23664);
    freq.put("No", 53500);
    freq.put("Na", 66351);
    freq.put("Ne", 44049);
    freq.put("heu", 16839);
    freq.put("eht", 23060);
    freq.put("ehr", 37443);
    freq.put("log", 27324);
    freq.put("her", 185057);
    freq.put("hes", 34182);
    freq.put("lon", 9380);
    freq.put("lom", 14967);
    freq.put("los", 22267);
    freq.put("ehe", 47146);
    freq.put("hec", 9261);
    freq.put("hel", 11970);
    freq.put("hem", 37228);
    freq.put("hen", 324438);
    freq.put("heo", 9547);
    freq.put(" sp", 27646);
    freq.put("aß", 17528);
    freq.put("J", 158568);
    freq.put("as ", 155043);
    freq.put("he ", 213315);
    freq.put("aa", 47275);
    freq.put("ac", 186135);
    freq.put("ab", 98737);
    freq.put("ae", 30527);
    freq.put("Hoc", 11500);
    freq.put("ag", 124899);
    freq.put("af", 117969);
    freq.put("ai", 78558);
    freq.put("ah", 148615);
    freq.put("ak", 51121);
    freq.put("am", 283487);
    freq.put("al", 571224);
    freq.put("an", 921405);
    freq.put("ap", 48798);
    freq.put("as", 323772);
    freq.put("ar", 487358);
    freq.put("au", 496496);
    freq.put("at", 393648);
    freq.put("aw", 12659);
    freq.put("av", 27657);
    freq.put("ay", 30095);
    freq.put("ax", 8820);
    freq.put("az", 20071);
    freq.put("ßba", 15077);
    freq.put("eho\u0308", 33094);
    freq.put("Lan", 56584);
    freq.put("igt", 19283);
    freq.put("ige", 123608);
    freq.put("iga", 12204);
    freq.put("ign", 9138);
    freq.put("igk", 10797);
    freq.put("igi", 12120);
    freq.put("a ", 292619);
    freq.put("hwe", 33406);
    freq.put("hwa", 10659);
    freq.put("Es ", 23376);
    freq.put("at ", 58813);
    freq.put("US ", 31557);
    freq.put("U\u0308b", 9926);
    freq.put("ig ", 34684);
    freq.put("Ma\u0308r", 10626);
    freq.put("Bre", 9847);
    freq.put("Bra", 12567);
    freq.put("all", 87642);
    freq.put("sch", 817718);
    freq.put("ali", 76090);
    freq.put("ald", 16999);
    freq.put("ale", 62596);
    freq.put("alb", 20979);
    freq.put("ala", 15461);
    freq.put("gt", 76690);
    freq.put("alz", 12079);
    freq.put("gs", 110120);
    freq.put("alt", 72681);
    freq.put("pts", 12222);
    freq.put("als", 84009);
    freq.put("Fil", 18131);
    freq.put("gr", 125748);
    freq.put("tz", 131414);
    freq.put("ty", 34073);
    freq.put("tw", 53648);
    freq.put("tt", 172596);
    freq.put("tu", 172266);
    freq.put("tr", 215121);
    freq.put("ts", 280176);
    freq.put("tp", 9922);
    freq.put("tn", 11002);
    freq.put("to", 167744);
    freq.put("tl", 110769);
    freq.put("tm", 18841);
    freq.put("tk", 15341);
    freq.put("th", 119533);
    freq.put("ti", 420789);
    freq.put("tf", 25417);
    freq.put("tg", 32640);
    freq.put("te", 1203919);
    freq.put("tb", 22514);
    freq.put("ta", 360262);
    freq.put("mpf", 9424);
    freq.put("edi", 25198);
    freq.put("ium", 14795);
    freq.put("ta\u0308n", 11031);
    freq.put("fas", 17434);
    freq.put("al ", 67162);
    freq.put(" zu", 137283);
    freq.put("fah", 14992);
    freq.put("fan", 11879);
    freq.put("llu", 11230);
    freq.put("fal", 21835);
    freq.put("llt", 17543);
    freq.put(" zw", 39753);
    freq.put("ta\u0308t", 24189);
    freq.put(" Ni", 23603);
    freq.put("gg", 10845);
    freq.put("pre", 14559);
    freq.put("ro", 256692);
    freq.put(" No", 53429);
    freq.put(" Na", 66181);
    freq.put(" Ne", 43845);
    freq.put("ge", 787899);
    freq.put("dsc", 11728);
    freq.put("t ", 1627252);
    freq.put("teh", 26143);
    freq.put("tei", 81154);
    freq.put("tel", 91292);
    freq.put("ga", 94286);
    freq.put("ten", 278529);
    freq.put("tec", 9644);
    freq.put("nbu", 15121);
    freq.put("go", 29970);
    freq.put("Unt", 29085);
    freq.put("nba", 15883);
    freq.put("tes", 39452);
    freq.put("tet", 40557);
    freq.put("nbe", 18026);
    freq.put("tu\u0308", 14407);
    freq.put("abe", 38207);
    freq.put("sun", 13352);
    freq.put("lle", 120640);
    freq.put("ta\u0308", 51288);
    freq.put(" ru", 14611);
    freq.put("te ", 230506);
    freq.put("K", 336559);
    freq.put(" re", 21422);
    freq.put("pub", 8976);
    freq.put("u\u0308be", 35449);
    freq.put("ab ", 9708);
    freq.put("Su\u0308d", 20812);
    freq.put("ein", 827667);
    freq.put("nto", 23385);
    freq.put("Aug", 12878);
    freq.put("Auf", 14417);
    freq.put("vin", 25318);
    freq.put("rke", 27812);
    freq.put("Aus", 25209);
    freq.put("Aut", 13725);
    freq.put("S ", 48175);
    freq.put("twa", 23393);
    freq.put("lsp", 9315);
    freq.put("twe", 10501);
    freq.put("u\u0308nd", 28744);
    freq.put("twi", 14763);
    freq.put("de ", 197184);
    freq.put("In ", 14119);
    freq.put("u\u0308ns", 8869);
    freq.put("zia", 11658);
    freq.put("Sy", 15026);
    freq.put("Sp", 54743);
    freq.put("fu\u0308", 107647);
    freq.put("Su", 18450);
    freq.put("St", 193472);
    freq.put("Si", 90352);
    freq.put("Sh", 10028);
    freq.put("So", 39076);
    freq.put(" U\u0308b", 9908);
    freq.put("Sc", 120209);
    freq.put("Sa", 63564);
    freq.put("Se", 64611);
    freq.put("a\u0301", 12062);
    freq.put("kle", 18061);
    freq.put("kla", 10851);
    freq.put(" di", 258330);
    freq.put("Int", 14682);
    freq.put(" de", 1066350);
    freq.put("des", 213577);
    freq.put("det", 50672);
    freq.put("deu", 71719);
    freq.put(" da", 104895);
    freq.put("Ins", 19291);
    freq.put("del", 34612);
    freq.put("dem", 104609);
    freq.put("den", 286768);
    freq.put("v", 645462);
    freq.put("Ind", 10322);
    freq.put(" du", 31949);
    freq.put(" dr", 12440);
    freq.put("pro", 24883);
    freq.put("f ", 156375);
    freq.put("ati", 113716);
    freq.put("isi", 17517);
    freq.put("ish", 14382);
    freq.put("eg ", 9875);
    freq.put("fr", 68277);
    freq.put("fs", 18166);
    freq.put("ft", 140067);
    freq.put("fu", 19769);
    freq.put("Su\u0308", 22392);
    freq.put("fa", 86743);
    freq.put("fe", 136348);
    freq.put("ff", 81186);
    freq.put("fg", 17796);
    freq.put("Dor", 10511);
    freq.put("fi", 73360);
    freq.put("fl", 45063);
    freq.put("fo", 55471);
    freq.put("a", 5009484);
    freq.put("egr", 34898);
    freq.put("ry ", 12420);
    freq.put("egt", 35267);
    freq.put("egi", 51407);
    freq.put("ds ", 13347);
    freq.put("o\u0308", 249595);
    freq.put("ega", 9107);
    freq.put("ege", 66150);
    freq.put(" su\u0308", 17881);
    freq.put("ce ", 20992);
    freq.put("y ", 99455);
    freq.put("ite", 83935);
    freq.put("ita", 30952);
    freq.put("Er ", 28197);
    freq.put("os ", 20626);
    freq.put("o\u0308st", 25495);
    freq.put("itt", 50909);
    freq.put("itu", 19936);
    freq.put("its", 25338);
    freq.put(" Ol", 9032);
    freq.put("dun", 25608);
    freq.put(" Ok", 13357);
    freq.put(" Ob", 22103);
    freq.put("usp", 9564);
    freq.put(" Or", 58009);
    freq.put(" Os", 17332);
    freq.put("rwa", 28214);
    freq.put("Bau", 14505);
    freq.put("ym", 18550);
    freq.put("yl", 11401);
    freq.put("yn", 15755);
    freq.put("ya", 11551);
    freq.put("ye", 15230);
    freq.put("L", 272371);
    freq.put("it ", 186965);
    freq.put("omm", 35850);
    freq.put("Bad", 10629);
    freq.put("Ban", 13867);
    freq.put("yp", 13299);
    freq.put("ys", 38183);
    freq.put("yr", 10616);
    freq.put("yt", 8983);
    freq.put("ow ", 10053);
    freq.put("ff ", 20858);
    freq.put("ift", 20078);
    freq.put("iff", 26227);
    freq.put("man", 57586);
    freq.put("dig", 18151);
    freq.put("Mus", 19078);
    freq.put("ita\u0308", 20849);
    freq.put("phi", 11788);
    freq.put(" st", 39848);
    freq.put(" si", 106825);
    freq.put("Ent", 11856);
    freq.put(" so", 41648);
    freq.put(" sc", 24771);
    freq.put(" se", 68014);
    freq.put("fts", 18001);
    freq.put("ize", 13649);
    freq.put("izi", 17119);
    freq.put("fte", 22800);
    freq.put("ftl", 11215);
    freq.put("ass", 73183);
    freq.put(" Ab", 25090);
    freq.put(" Ad", 11104);
    freq.put("ast", 27543);
    freq.put("mmu", 13317);
    freq.put("mmt", 13008);
    freq.put(" Al", 65979);
    freq.put(" Am", 21144);
    freq.put(" An", 55404);
    freq.put(" Ap", 14296);
    freq.put(" Ar", 57936);
    freq.put(" As", 17394);
    freq.put(" At", 9235);
    freq.put(" Au", 73430);
    freq.put("ase", 11784);
    freq.put("sbe", 20860);
    freq.put("mme", 52772);
    freq.put("Uni", 18259);
    freq.put("asi", 19652);
    freq.put("El", 17463);
    freq.put("En", 32393);
    freq.put("Ei", 81512);
    freq.put("ft ", 64901);
    freq.put("w", 833806);
    freq.put("Eu", 13931);
    freq.put("Es", 30499);
    freq.put("Er", 67899);
    freq.put("le ", 103052);
    freq.put("Fra", 28567);
    freq.put("Fre", 14074);
    freq.put("Fri", 10250);
    freq.put("uen", 13989);
    freq.put(" en", 55368);
    freq.put(" eh", 21203);
    freq.put(" ei", 604709);
    freq.put("kon", 15402);
    freq.put("dt ", 65936);
    freq.put(" et", 21454);
    freq.put(" er", 81246);
    freq.put(" es", 15402);
    freq.put("tfa", 9048);
    freq.put("odu", 15579);
    freq.put("nch", 15880);
    freq.put("rra", 9354);
    freq.put("nce", 12344);
    freq.put("ste", 300373);
    freq.put("stf", 9710);
    freq.put("b", 1254948);
    freq.put("sta", 116653);
    freq.put("rk ", 38902);
    freq.put("sto", 29905);
    freq.put("sti", 57375);
    freq.put("aat", 34161);
    freq.put("Gre", 10954);
    freq.put("ko\u0308", 10263);
    freq.put("str", 60741);
    freq.put("ku\u0308", 12292);
    freq.put("ka ", 18181);
    freq.put("Gro", 14185);
    freq.put("lie", 114815);
    freq.put("k ", 140095);
    freq.put("lia", 13089);
    freq.put("lic", 170755);
    freq.put("Kir", 12749);
    freq.put("lin", 51826);
    freq.put("Nie", 12050);
    freq.put("lit", 40830);
    freq.put("efi", 14121);
    freq.put("Kil", 10995);
    freq.put("efe", 11305);
    freq.put("M", 385363);
    freq.put("kan", 77012);
    freq.put("kal", 10319);
    freq.put("kat", 15038);
    freq.put("rha", 21798);
    freq.put("The", 20642);
    freq.put("rhe", 18402);
    freq.put("bzw", 9957);
    freq.put("ka", 155408);
    freq.put("li ", 14630);
    freq.put("ke", 186644);
    freq.put("ki", 44691);
    freq.put("Zei", 17372);
    freq.put("ko", 74144);
    freq.put("km", 33455);
    freq.put("kl", 44918);
    freq.put("ks", 34677);
    freq.put("kr", 80423);
    freq.put("ku", 45967);
    freq.put("kt", 124687);
    freq.put("rte", 100313);
    freq.put("Hal", 8751);
    freq.put("Han", 15746);
    freq.put("rti", 23089);
    freq.put("rth", 11159);
    freq.put("uge", 19918);
    freq.put("rts", 42716);
    freq.put("rtr", 18145);
    freq.put("Hau", 30716);
    freq.put("ugu", 12915);
    freq.put("Ju", 32751);
    freq.put("ies", 42285);
    freq.put("ier", 122946);
    freq.put("iet", 30400);
    freq.put("ieh", 10954);
    freq.put("Jo", 24131);
    freq.put("iel", 84385);
    freq.put("ien", 123978);
    freq.put("Je", 11227);
    freq.put("iec", 11989);
    freq.put("ieb", 29946);
    freq.put("ied", 66086);
    freq.put("ieg", 57690);
    freq.put("ief", 8944);
    freq.put("his", 35328);
    freq.put("rt ", 139444);
    freq.put("hic", 13745);
    freq.put("hie", 35579);
    freq.put("hil", 15183);
    freq.put("hin", 28238);
    freq.put("stl", 38070);
    freq.put("rfa", 14831);
    freq.put("x", 72882);
    freq.put("dur", 31652);
    freq.put("rfo", 9599);
    freq.put(" Be", 143584);
    freq.put("arr", 11665);
    freq.put("ars", 12931);
    freq.put("art", 72580);
    freq.put("ser", 52310);
    freq.put("ieß", 9409);
    freq.put(" Bl", 15450);
    freq.put(" Bo", 31991);
    freq.put(" Bi", 31731);
    freq.put(" Bu", 55625);
    freq.put("ara", 24649);
    freq.put("arb", 19113);
    freq.put("arc", 10050);
    freq.put("ard", 28108);
    freq.put("are", 33081);
    freq.put(" Br", 45134);
    freq.put("ari", 41626);
    freq.put("sem", 11510);
    freq.put("ark", 32666);
    freq.put("arl", 16356);
    freq.put("sei", 61074);
    freq.put("aro", 9777);
    freq.put("stu", 17599);
    freq.put("ses", 13066);
    freq.put("woh", 26117);
    freq.put("Pla", 10533);
    freq.put("ms ", 14667);
    freq.put("Obe", 15435);
    freq.put("upp", 21507);
    freq.put("ue ", 12656);
    freq.put("ar ", 124263);
    freq.put("ika", 58499);
    freq.put("ike", 34841);
    freq.put("se ", 74178);
    freq.put("fge", 10643);
    freq.put("De\u0301p", 12076);
    freq.put("to ", 13838);
    freq.put(" Pr", 83041);
    freq.put("c", 2286896);
    freq.put(" Pu", 10674);
    freq.put(" Pa", 55779);
    freq.put(" Pf", 21701);
    freq.put(" Pe", 31180);
    freq.put(" Pi", 16916);
    freq.put(" Ph", 15079);
    freq.put(" Po", 48260);
    freq.put(" Pl", 15331);
    freq.put("Wal", 11499);
    freq.put("wen", 21225);
    freq.put("tge", 13122);
    freq.put("Was", 9091);
    freq.put("tgl", 9160);
    freq.put("ga ", 12696);
    freq.put("pr", 99340);
    freq.put("ps", 12738);
    freq.put("pp", 47091);
    freq.put("pt", 54028);
    freq.put("pu", 30332);
    freq.put("swe", 11000);
    freq.put("ewa\u0308", 9115);
    freq.put("pa", 81077);
    freq.put("pf", 29697);
    freq.put("nau", 11932);
    freq.put("pe", 109404);
    freq.put("ph", 41272);
    freq.put("pi", 98645);
    freq.put("po", 71059);
    freq.put("pl", 26694);
    freq.put("U\u0308be", 9600);
    freq.put(" tr", 12290);
    freq.put("N", 224760);
    freq.put("gan", 29626);
    freq.put(" th", 15725);
    freq.put(" te", 8776);
    freq.put("gab", 8826);
    freq.put(" fu\u0308", 85353);
    freq.put("p ", 27276);
    freq.put("fun", 10974);
    freq.put("lbe", 17468);
    freq.put("vom", 22538);
    freq.put("rit", 36924);
    freq.put("ris", 65792);
    freq.put("rin", 60346);
    freq.put("ril", 13027);
    freq.put("rik", 52744);
    freq.put("vor", 35872);
    freq.put("rif", 31298);
    freq.put("rig", 20472);
    freq.put("rie", 98836);
    freq.put("ric", 47382);
    freq.put("ria", 21040);
    freq.put("ewi", 9238);
    freq.put("u\u0308hr", 24588);
    freq.put("ewe", 18343);
    freq.put("gs ", 14145);
    freq.put("u\u0308he", 8949);
    freq.put("pa\u0308", 14388);
    freq.put("Cou", 18879);
    freq.put("tis", 66050);
    freq.put("lig", 41309);
    freq.put("efu\u0308", 9260);
    freq.put("Com", 14437);
    freq.put("gss", 10565);
    freq.put(" fr", 36324);
    freq.put("gst", 11232);
    freq.put("ew ", 11648);
    freq.put("gsb", 9179);
    freq.put("gsg", 11045);
    freq.put("y", 283697);
    freq.put("lde", 27222);
    freq.put("ad", 167659);
    freq.put("wic", 21374);
    freq.put("lik", 12998);
    freq.put("urd", 76437);
    freq.put("rga", 19288);
    freq.put("rge", 50622);
    freq.put("rgi", 14417);
    freq.put("ee ", 17886);
    freq.put("bin", 15696);
    freq.put("bil", 24249);
    freq.put("Ol", 9042);
    freq.put("Ok", 13364);
    freq.put("Die", 157652);
    freq.put("bie", 27376);
    freq.put("Ob", 22144);
    freq.put("Os", 17404);
    freq.put("bis", 44646);
    freq.put("d", 3686275);
    freq.put("eer", 10701);
    freq.put("rg ", 68697);
    freq.put("b ", 47610);
    freq.put("uf ", 70919);
    freq.put("rf ", 19644);
    freq.put(" Qu", 12048);
    freq.put("per", 31265);
    freq.put("pel", 10530);
    freq.put("pen", 21299);
    freq.put("id ", 10846);
    freq.put("be", 567764);
    freq.put("bg", 11719);
    freq.put("run", 74339);
    freq.put("ba", 134727);
    freq.put("rum", 15222);
    freq.put("bl", 45392);
    freq.put("ruc", 12341);
    freq.put("bo", 31335);
    freq.put("bi", 136887);
    freq.put("O", 171336);
    freq.put("ufg", 14459);
    freq.put("bt", 20985);
    freq.put("bu", 78689);
    freq.put("br", 69597);
    freq.put("bs", 31297);
    freq.put("rus", 14979);
    freq.put("rup", 19176);
    freq.put("uft", 12442);
    freq.put("bz", 11720);
    freq.put("che", 671441);
    freq.put("Rom", 8900);
    freq.put("Ost", 13628);
    freq.put("ide", 33142);
    freq.put("pe ", 20233);
    freq.put("ida", 13186);
    freq.put("nsi", 11408);
    freq.put("nsa", 13614);
    freq.put("nsb", 9715);
    freq.put("nsc", 47879);
    freq.put("nse", 37942);
    freq.put(" um", 38406);
    freq.put(" un", 417759);
    freq.put("usi", 22265);
    freq.put("nsp", 11166);
    freq.put("nst", 73244);
    freq.put("gro\u0308", 13018);
    freq.put("ußb", 14873);
    freq.put("ut ", 20376);
    freq.put("uße", 8940);
    freq.put("zig", 9649);
    freq.put("gru\u0308", 19508);
    freq.put("zie", 29129);
    freq.put(" Wo", 21330);
    freq.put("cht", 155579);
    freq.put("u ", 108662);
    freq.put("fes", 13275);
    freq.put("sta\u0308", 18451);
    freq.put(" Ch", 44814);
    freq.put(" Co", 63874);
    freq.put(" Cl", 9441);
    freq.put("ns ", 52604);
    freq.put(" Ca", 33546);
    freq.put("Flu", 13729);
    freq.put("uz", 17658);
    freq.put("ut", 230981);
    freq.put("uti", 13537);
    freq.put("up", 64261);
    freq.put("us", 360270);
    freq.put("ur", 375391);
    freq.put("um", 178633);
    freq.put("ul", 92478);
    freq.put("ra\u0308g", 10007);
    freq.put("un", 921062);
    freq.put("ui", 24830);
    freq.put("uh", 10714);
    freq.put("uk", 24301);
    freq.put("ue", 71615);
    freq.put("ud", 39409);
    freq.put("ug", 74097);
    freq.put("uf", 143869);
    freq.put("ua", 44618);
    freq.put("uc", 128427);
    freq.put("ub", 43047);
    freq.put("la\u0308c", 9211);
    freq.put("Tu", 10377);
    freq.put("Tr", 32100);
    freq.put("la\u0308n", 14161);
    freq.put("To", 24574);
    freq.put("Th", 35305);
    freq.put("Ti", 19953);
    freq.put("Te", 52263);
    freq.put("Ta", 27705);
    freq.put("A ", 22760);
    freq.put("Mar", 33951);
    freq.put(" gr", 31732);
    freq.put("nad", 10470);
    freq.put("nah", 12864);
    freq.put("a\u0308t ", 14412);
    freq.put("nan", 39807);
    freq.put("nal", 58896);
    freq.put("ag ", 17784);
    freq.put("nar", 14659);
    freq.put("gre", 15248);
    freq.put("nat", 30766);
    freq.put("gra", 25992);
    freq.put("Mai", 15148);
    freq.put("gro", 10882);
    freq.put(" gl", 12278);
    freq.put("Mal", 9073);
    freq.put("Man", 15071);
    freq.put("uß", 27824);
    freq.put("na ", 34549);
    freq.put("Ab", 25174);
    freq.put("e", 12779820);
    freq.put("Ad", 11158);
    freq.put("age", 54066);
    freq.put("sve", 8840);
    freq.put("Am", 21201);
    freq.put("Al", 66179);
    freq.put("a\u0308te", 10008);
    freq.put("An", 55559);
    freq.put("Ap", 14324);
    freq.put("As", 17569);
    freq.put("Ar", 58134);
    freq.put("Au", 73540);
    freq.put("At", 9258);
    freq.put(" b", 294630);
    freq.put(" c", 26306);
    freq.put("gu", 58531);
    freq.put(" a", 569210);
    freq.put(" f", 160920);
    freq.put(" g", 218820);
    freq.put(" d", 1491422);
    freq.put(" e", 826321);
    freq.put(" j", 27689);
    freq.put(" k", 107425);
    freq.put(" h", 112970);
    freq.put(" i", 1142912);
    freq.put(" n", 127225);
    freq.put(" o", 112357);
    freq.put(" l", 98174);
    freq.put(" m", 186199);
    freq.put(" r", 56139);
    freq.put(" s", 347463);
    freq.put(" p", 57089);
    freq.put(" v", 371555);
    freq.put(" w", 322251);
    freq.put(" t", 56510);
    freq.put(" u", 467824);
    freq.put(" z", 200898);
    freq.put("gn", 22363);
    freq.put("zo\u0308", 21005);
    freq.put("gl", 78298);
    freq.put("gk", 13841);
    freq.put("gi", 130788);
    freq.put("gh", 20146);
    freq.put(" B", 437655);
    freq.put(" C", 196607);
    freq.put(" A", 413316);
    freq.put(" F", 291285);
    freq.put(" G", 334059);
    freq.put(" D", 543793);
    freq.put(" E", 298852);
    freq.put(" J", 156270);
    freq.put(" K", 328020);
    freq.put(" H", 253550);
    freq.put(" I", 146651);
    freq.put(" N", 212076);
    freq.put(" O", 159226);
    freq.put(" L", 260916);
    freq.put(" M", 370185);
    freq.put(" R", 264582);
    freq.put(" S", 736164);
    freq.put(" P", 316134);
    freq.put(" Q", 14562);
    freq.put(" V", 189915);
    freq.put(" W", 214460);
    freq.put(" T", 228797);
    freq.put(" U", 132267);
    freq.put(" Z", 93212);
    freq.put("Nov", 10049);
    freq.put(" Y", 15401);
    freq.put("Nor", 35685);
    freq.put("ch ", 425455);
    freq.put("ed ", 20514);
    freq.put("o\u0308ni", 10085);
    freq.put("P", 333284);
    freq.put("g ", 403400);
    freq.put("tri", 43316);
    freq.put("tro", 30104);
    freq.put("tra", 75255);
    freq.put("Spr", 13123);
    freq.put("us ", 143584);
    freq.put("tre", 34672);
    freq.put("Spi", 16479);
    freq.put("tru", 19097);
    freq.put("rro", 10371);
    freq.put("uel", 10929);
    freq.put("zo", 13315);
    freq.put("zi", 99549);
    freq.put(" a\u0308", 10185);
    freq.put("ze", 213386);
    freq.put("rre", 38535);
    freq.put("za", 20320);
    freq.put("zb", 8992);
    freq.put("ibe", 11815);
    freq.put(" o\u0308", 18488);
    freq.put("zt", 32056);
    freq.put("zu", 170081);
    freq.put("zw", 56096);
    freq.put("ode", 93686);
    freq.put(" u\u0308", 31572);
    freq.put("uer", 24349);
    freq.put("Ort", 33777);
    freq.put(" O\u0308", 12893);
    freq.put("rd ", 68822);
    freq.put(" U\u0308", 10208);
    freq.put("leb", 11626);
    freq.put("leg", 20421);
    freq.put("lei", 58951);
    freq.put("lek", 12889);
    freq.put("z ", 144384);
    freq.put("lem", 16242);
    freq.put("len", 91180);
    freq.put("ozi", 9366);
    freq.put("ler", 100316);
    freq.put("les", 24231);
    freq.put("let", 14648);
    freq.put("ogr", 16058);
    freq.put("rde", 136404);
    freq.put("rdl", 8810);
    freq.put("rdn", 11514);
    freq.put("rdi", 14216);
    freq.put(" Do", 28619);
    freq.put("wie", 34766);
    freq.put("Ver", 96243);
    freq.put(" Di", 188080);
    freq.put(" De", 166199);
    freq.put(" Da", 90740);
    freq.put("wis", 33738);
    freq.put("wir", 55249);
    freq.put(" Du", 11174);
    freq.put("sge", 44768);
    freq.put(" Dr", 19868);
    freq.put("usg", 18900);
    freq.put("cha", 118322);
    freq.put("Fr", 58870);
    freq.put("zir", 18395);
    freq.put("Fu", 26023);
    freq.put("usa", 16989);
    freq.put("fen", 43852);
    freq.put("chi", 103178);
    freq.put("fel", 18220);
    freq.put("chl", 70583);
    freq.put("chm", 11901);
    freq.put("chn", 86780);
    freq.put("cho", 20768);
    freq.put("Fa", 46184);
    freq.put("chr", 43254);
    freq.put("chs", 68005);
    freq.put("fer", 33138);
    freq.put("Fe", 38252);
    freq.put("chw", 51871);
    freq.put("Fi", 36767);
    freq.put("Fl", 33310);
    freq.put("spr", 34328);
    freq.put("Fo", 32048);
    freq.put("ndl", 16133);
    freq.put(" Ru", 19497);
    freq.put("oi", 24320);
    freq.put("fe ", 14115);
    freq.put("f", 1052401);
    freq.put("oh", 66434);
    freq.put("Ja", 77663);
    freq.put(" Re", 106629);
    freq.put("og", 71416);
    freq.put(" Ra", 37989);
    freq.put(" Ro", 44140);
    freq.put(" Ri", 23976);
    freq.put(" Rh", 15474);
    freq.put("tat", 27116);
    freq.put("tau", 10504);
    freq.put("od", 135885);
    freq.put(" De\u0301", 12331);
    freq.put("tad", 80208);
    freq.put("tag", 11693);
    freq.put("taa", 33781);
    freq.put("tal", 50681);
    freq.put("tam", 12219);
    freq.put("tan", 59689);
    freq.put("sis", 59876);
    freq.put(" ve", 73784);
    freq.put("sit", 30295);
    freq.put(" vi", 13609);
    freq.put("aff", 9982);
    freq.put(" vo", 278143);
    freq.put("spe", 13644);
    freq.put("sic", 57522);
    freq.put("sie", 44959);
    freq.put("dwe", 14218);
    freq.put("aft", 77933);
    freq.put("sio", 15881);
    freq.put("sin", 51565);
    freq.put("Q", 15370);
    freq.put("ta ", 18923);
    freq.put("cha\u0308", 10997);
    freq.put("ndr", 11275);
    freq.put("da ", 17513);
    freq.put("a\u0308uf", 9858);
    freq.put("X", 9646);
    freq.put("lz ", 10714);
    freq.put("lf", 32687);
    freq.put("lg", 41891);
    freq.put("ld", 86618);
    freq.put("le", 501436);
    freq.put("lb", 59934);
    freq.put("lc", 19357);
    freq.put("la", 312768);
    freq.put("ln", 33301);
    freq.put("lo", 124488);
    freq.put("ll", 300411);
    freq.put("lm", 52275);
    freq.put("lk", 36060);
    freq.put("lh", 12595);
    freq.put("li", 562165);
    freq.put("lv", 15360);
    freq.put("su\u0308d", 17890);
    freq.put("lt", 212969);
    freq.put("lu", 97812);
    freq.put("lr", 10222);
    freq.put("ls", 178640);
    freq.put("lp", 20136);
    freq.put("eut", 121638);
    freq.put("tst", 44445);
    freq.put("lz", 28989);
    freq.put("tsp", 10708);
    freq.put("ly", 20012);
    freq.put("Car", 9966);
    freq.put("sik", 20202);
    freq.put("dar", 15587);
    freq.put("das", 76737);
    freq.put("ema", 36279);
    freq.put("San", 12822);
    freq.put("l ", 312169);
    freq.put("nfo", 9002);
    freq.put("Pro", 54127);
    freq.put("Pri", 9311);
    freq.put("ts ", 32847);
    freq.put(" hi", 13984);
    freq.put(" ho", 9452);
    freq.put(" ha", 41553);
    freq.put(" he", 33774);
    freq.put("oun", 22912);
    freq.put("hlu", 9270);
    freq.put("hlo", 9385);
    freq.put("hli", 16905);
    freq.put("our", 13749);
    freq.put("hle", 29146);
    freq.put("hla", 28455);
    freq.put("la\u0308", 41208);
    freq.put("fre", 14454);
    freq.put("rer", 33774);
    freq.put("res", 34677);
    freq.put("ret", 20023);
    freq.put("reu", 13265);
    freq.put("rei", 196090);
    freq.put("ren", 145744);
    freq.put("wer", 58987);
    freq.put("rem", 14552);
    freq.put("rec", 32717);
    freq.put("lu\u0308", 10612);
    freq.put("rea", 10702);
    freq.put("reg", 17320);
    freq.put("eck", 32288);
    freq.put("ech", 81379);
    freq.put("ie ", 537544);
    freq.put("hl ", 14867);
    freq.put("g", 2011313);
    freq.put("lte", 61749);
    freq.put("re ", 80803);
    freq.put("u\u0308", 397123);
    freq.put("ihr", 18848);
    freq.put("rs ", 37799);
    freq.put("seu", 12734);
    freq.put("set", 25883);
    freq.put(" Ba", 87247);
    freq.put("ihe", 9068);
    freq.put(" Sy", 14940);
    freq.put("For", 20619);
    freq.put("be ", 15350);
    freq.put(" St", 192451);
    freq.put(" Su", 18414);
    freq.put(" o\u0308s", 13916);
    freq.put(" Si", 90133);
    freq.put(" So", 38900);
    freq.put(" Sc", 119896);
    freq.put(" Sa", 63396);
    freq.put(" Se", 64226);
    freq.put("Ka", 74688);
    freq.put("rso", 11863);
    freq.put("rsi", 21022);
    freq.put("Ke", 14966);
    freq.put("rse", 16931);
    freq.put("Ki", 37983);
    freq.put("Ko", 56995);
    freq.put("rsa", 9024);
    freq.put("Kl", 25047);
    freq.put("Kr", 46024);
    freq.put("R", 282432);
    freq.put("ogi", 20348);
    freq.put("Ku", 30221);
    freq.put("ude", 15376);
    freq.put("rst", 71108);
    freq.put("rsp", 15246);
    freq.put("vie", 18884);
    freq.put("bek", 17699);
    freq.put("bei", 74577);
    freq.put("ben", 84728);
    freq.put("bel", 16201);
    freq.put("bef", 14886);
    freq.put("see", 12215);
    freq.put("bed", 10076);
    freq.put("hei", 73898);
    freq.put("bez", 50353);
    freq.put("ik ", 39429);
    freq.put("ber", 182051);
    freq.put("bes", 47672);
    freq.put("bew", 10065);
    freq.put("bet", 15480);
    freq.put("Par", 21713);
    freq.put("e\u0301pa", 12146);
    freq.put("sen", 104567);
    freq.put("sk", 49450);
    freq.put("sel", 53325);
    freq.put("ur ", 74659);
    freq.put("ck ", 31790);
    freq.put(" Su\u0308", 22387);
    freq.put("min", 21460);
    freq.put("mie", 12587);
    freq.put("mig", 9701);
    freq.put("hr", 245096);
    freq.put("mis", 23371);
    freq.put("seh", 13958);
    freq.put("mit", 124264);
    freq.put(" El", 17420);
    freq.put(" En", 32299);
    freq.put(" Ei", 81331);
    freq.put("hw", 53275);
    freq.put("Ko\u0308", 16414);
    freq.put("st ", 524603);
    freq.put(" Eu", 13899);
    freq.put(" Er", 67840);
    freq.put(" Es", 30480);
    freq.put("cke", 51895);
    freq.put("ure", 16506);
    freq.put("urg", 50861);
    freq.put("mus", 17368);
    freq.put("urc", 36382);
    freq.put("ckl", 11099);
    freq.put("urn", 9214);
    freq.put("uro", 18224);
    freq.put("uri", 14126);
    freq.put("urt", 10114);
    freq.put("Pol", 21608);
    freq.put("urs", 13370);
    freq.put("hn", 163077);
    freq.put("urz", 14868);
    freq.put("Cha", 13525);
    freq.put("nge", 150664);
    freq.put("nga", 14715);
    freq.put("ngl", 32203);
    freq.put(" is", 439990);
    freq.put(" it", 10403);
    freq.put("ngi", 9157);
    freq.put(" ih", 21981);
    freq.put("ae ", 18008);
    freq.put(" im", 207684);
    freq.put(" in", 455196);
    freq.put("ngs", 81612);
    freq.put("tbe", 10504);
    freq.put(" we", 72625);
    freq.put("qu", 17893);
    freq.put(" wa", 91486);
    freq.put("h", 3128015);
    freq.put("lst", 14411);
    freq.put(" wi", 72114);
    freq.put("sha", 10198);
    freq.put(" wu", 68805);
    freq.put("ks ", 9057);
    freq.put("sho", 11670);
    freq.put("Pr", 83211);
    freq.put("ebe", 60498);
    freq.put("eba", 8988);
    freq.put("Pu", 10703);
    freq.put("C", 218833);
    freq.put("ke ", 26956);
    freq.put("ebu", 9376);
    freq.put("Pa", 56041);
    freq.put("Pf", 21717);
    freq.put("ebr", 17022);
    freq.put("Pe", 31242);
    freq.put("ede", 66213);
    freq.put("Ph", 15188);
    freq.put("Pi", 16961);
    freq.put("Po", 48441);
    freq.put("Pl", 15401);
    freq.put("lus", 22607);
    freq.put("ome", 26297);
    freq.put("dli", 27133);
    freq.put("et ", 137716);
    freq.put("lug", 9766);
    freq.put("lun", 37355);
    freq.put("ken", 38622);
    freq.put("kel", 18319);
    freq.put("kei", 25216);
    freq.put("S", 807982);
    freq.put("bt ", 13539);
    freq.put("key", 12420);
    freq.put("ker", 44613);
    freq.put("etr", 30198);
    freq.put("etw", 18129);
    freq.put("ett", 26303);
    freq.put("etz", 35905);
    freq.put("aße", 12922);
    freq.put("eue", 13801);
    freq.put("tla", 9588);
    freq.put("eta", 11725);
    freq.put("tle", 19198);
    freq.put("ete", 74739);
    freq.put("tli", 78058);
    freq.put("eti", 14295);
    freq.put("eug", 13587);
    freq.put("ck", 133244);
    freq.put("ohl", 8865);
    freq.put("ci", 25902);
    freq.put("ch", 1933159);
    freq.put("co", 32151);
    freq.put("Her", 23305);
    freq.put("ca", 38911);
    freq.put("ohn", 34927);
    freq.put("ce", 45478);
    freq.put("tsc", 125606);
    freq.put("lis", 62203);
    freq.put("uck", 11441);
    freq.put("Hei", 15430);
    freq.put("cu", 10926);
    freq.put("ct", 17144);
    freq.put("Ges", 25022);
    freq.put("Ger", 10345);
    freq.put("Jun", 10796);
    freq.put("Jul", 9776);
    freq.put("Geb", 17190);
    freq.put("Gen", 10761);
    freq.put("Gem", 51515);
    freq.put("oth", 10089);
    freq.put("oti", 8974);
    freq.put("oto", 13207);
    freq.put("c ", 18586);
    freq.put("ote", 15159);
    freq.put("lge", 22548);
    freq.put("uns", 11344);
    freq.put("hme", 30297);
    freq.put("ins", 51098);
    freq.put("ott", 13896);
    freq.put("e\u0301", 38695);
    freq.put("rbr", 9368);
    freq.put("Ant", 9903);
    freq.put("rbi", 13086);
    freq.put("rbe", 36419);
    freq.put("eur", 19487);
    freq.put("rba", 21515);
    freq.put("yst", 17491);
    freq.put("va", 38019);
    freq.put(" Fr", 58787);
    freq.put(" Fu", 25992);
    freq.put("ve", 197477);
    freq.put("tar", 23114);
    freq.put("vi", 76382);
    freq.put("vo", 299196);
    freq.put(" Fa", 46079);
    freq.put("a\u0308", 358815);
    freq.put(" Fe", 38170);
    freq.put(" Fi", 36574);
    freq.put(" Fl", 33229);
    freq.put(" Fo", 31900);
    freq.put("io ", 15324);
    freq.put("of ", 22612);
    freq.put("a\u0308f", 13624);
    freq.put("dam", 14425);
    freq.put("v ", 14300);
    freq.put("a\u0308g", 13766);
    freq.put("igu", 13208);
    freq.put("ion", 169772);
    freq.put("von", 226355);
    freq.put("off", 17101);
    freq.put("i", 7539051);
    freq.put(" Tu", 10321);
    freq.put(" Tr", 31991);
    freq.put(" To", 24396);
    freq.put(" Ti", 19864);
    freq.put(" Th", 35151);
    freq.put(" Te", 52071);
    freq.put(" Ta", 27626);
    freq.put("mfa", 9540);
    freq.put("Be", 143843);
    freq.put("adt", 77282);
    freq.put("tt ", 15987);
    freq.put("weg", 12299);
    freq.put("Ba", 87454);
    freq.put("Bl", 15582);
    freq.put("wei", 83410);
    freq.put("Bo", 32121);
    freq.put("Bi", 31885);
    freq.put("wel", 20147);
    freq.put("wes", 27777);
    freq.put("Bu", 55758);
    freq.put("ger", 96243);
    freq.put("ade", 24209);
    freq.put("ska", 11035);
    freq.put("Br", 45253);
    freq.put("Fam", 19152);
    freq.put("zo\u0308s", 20559);
    freq.put("ski", 8870);
    freq.put("adi", 20643);
    freq.put("Eis", 15092);
    freq.put("nve", 9948);
    freq.put("T", 243403);
    freq.put("ßte", 10219);
    freq.put("Ein", 58080);
    freq.put("B ", 10700);
    freq.put("nfa", 11653);
    freq.put("ad ", 15688);
    freq.put("est", 128414);
    freq.put("ess", 60542);
    freq.put("nd ", 563951);
    freq.put("ese", 67043);
    freq.put("esc", 45868);
    freq.put("esa", 12858);
    freq.put("eso", 11977);
    freq.put("esi", 26333);
    freq.put("Um", 8765);
    freq.put("Un", 54096);
    freq.put("ndi", 40257);
    freq.put("ndk", 23064);
    freq.put("Sch", 114345);
    freq.put("ndo", 18073);
    freq.put("nda", 14652);
    freq.put("nde", 333302);
    freq.put("US", 39827);
    freq.put("kri", 11594);
    freq.put("za\u0308h", 9158);
    freq.put("es ", 365853);
    freq.put(" je", 12055);
    freq.put("nds", 26772);
    freq.put("kra", 15849);
    freq.put("ndu", 21347);
    freq.put("ndt", 9026);
    freq.put("kre", 43910);
    freq.put("owi", 20813);
    freq.put("o\u0308f", 13450);
    freq.put("o\u0308h", 14808);
    freq.put("o\u0308l", 13380);
    freq.put("o\u0308m", 9902);
    freq.put("o\u0308n", 22557);
    freq.put("o\u0308r", 67546);
    freq.put("o\u0308s", 54393);
    freq.put("h ", 463041);
    freq.put("van", 10775);
    freq.put("rch", 72681);
    freq.put("Dez", 9022);
    freq.put("hy", 13546);
    freq.put("Kla", 9457);
    freq.put("bur", 42376);
    freq.put("hs", 72646);
    freq.put("Der", 97305);
    freq.put("Deu", 28251);
    freq.put("ht", 189239);
    freq.put("hu", 73471);
    freq.put("hk", 8886);
    freq.put("hi", 180846);
    freq.put("bun", 13485);
    freq.put("ho", 102479);
    freq.put("hl", 130889);
    freq.put("hm", 50687);
    freq.put("hb", 12648);
    freq.put("ha", 293469);
    freq.put("eat", 10811);
    freq.put("he", 941699);
    freq.put("Tei", 19885);
    freq.put("j", 85201);
    freq.put("lve", 9179);
    freq.put("rri", 12758);
    freq.put("inz", 40189);
    freq.put("int", 30667);
    freq.put("inw", 21089);
    freq.put("pie", 61526);
    freq.put(" US", 39409);
    freq.put("inl", 11619);
    freq.put("lm ", 19332);
    freq.put("inn", 28145);
    freq.put("ino", 11205);
    freq.put("inh", 13926);
    freq.put("ini", 56092);
    freq.put("ink", 12759);
    freq.put("ind", 156874);
    freq.put("ine", 425715);
    freq.put("inf", 10131);
    freq.put("ing", 93214);
    freq.put("ina", 40189);
    freq.put("hn ", 19219);
    freq.put(" Um", 8742);
    freq.put(" Un", 54031);
    freq.put("or ", 51491);
    freq.put("u", 3015383);
    freq.put("o\u0308ß", 14937);
    freq.put("hu\u0308", 11610);
    freq.put("ho\u0308", 49290);
    freq.put("gar", 15096);
    freq.put("U", 140118);
    freq.put("ubl", 12721);
    freq.put("in ", 793598);
    freq.put("ha\u0308", 31781);
    freq.put("hne", 77095);
    freq.put("hni", 15320);
    freq.put("eor", 17275);
    freq.put("hnu", 17265);
  }
  
}

