package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class DA extends CLangProfile {
  private static final String name = "da";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public DA() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 9674395;
    n_words[1] = 11309170;
    n_words[2] = 8090238;

    freq.put(" kø", 1518);
    freq.put("ørn", 1192);
    freq.put("øre", 4495);
    freq.put("up ", 2829);
    freq.put("lt ", 6296);
    freq.put("ørt", 1508);
    freq.put("pte", 1387);
    freq.put("ørs", 6046);
    freq.put("ørr", 1963);
    freq.put(" Gu", 1534);
    freq.put(" Gr", 3557);
    freq.put("Joh", 1172);
    freq.put(" Ge", 1892);
    freq.put(" Ga", 1860);
    freq.put(" Go", 1179);
    freq.put("au ", 1067);
    freq.put("Gu", 1554);
    freq.put("Gr", 3579);
    freq.put("væg", 1206);
    freq.put("ør ", 3471);
    freq.put("Ge", 1911);
    freq.put("vn ", 4721);
    freq.put("red", 12454);
    freq.put("Ga", 1871);
    freq.put("Go", 1190);
    freq.put("vær", 6621);
    freq.put("Gi", 973);
    freq.put(" ka", 10401);
    freq.put("me ", 4862);
    freq.put(" ke", 5007);
    freq.put(" ki", 4060);
    freq.put(" ko", 12549);
    freq.put(" kl", 2396);
    freq.put(" km", 1736);
    freq.put(" kr", 4395);
    freq.put(" kv", 1456);
    freq.put(" ku", 4034);
    freq.put("nen", 7128);
    freq.put("nel", 5371);
    freq.put("nem", 2182);
    freq.put("nek", 1429);
    freq.put("ned", 2644);
    freq.put("kun", 3121);
    freq.put("kul", 1926);
    freq.put(" fa\u030a", 1001);
    freq.put("net", 9752);
    freq.put("ner", 14377);
    freq.put("nes", 8157);
    freq.put("sli", 981);
    freq.put("med", 21647);
    freq.put("øde", 1837);
    freq.put("mel", 6023);
    freq.put("men", 16847);
    freq.put("ors", 6893);
    freq.put("met", 7243);
    freq.put("ødt", 7615);
    freq.put("mes", 4874);
    freq.put("mer", 15160);
    freq.put("lmi", 1310);
    freq.put("gla", 1189);
    freq.put("k", 286164);
    freq.put("gle", 3411);
    freq.put("ne ", 28324);
    freq.put("akt", 3338);
    freq.put("dri", 1805);
    freq.put("orm", 8791);
    freq.put("dro", 1133);
    freq.put("dra", 1347);
    freq.put("dre", 7141);
    freq.put("nk ", 979);
    freq.put("Kom", 6411);
    freq.put("Kon", 1132);
    freq.put("bru", 5207);
    freq.put("bro", 1760);
    freq.put("bri", 2216);
    freq.put("bre", 2307);
    freq.put("bra", 1230);
    freq.put("m ", 58614);
    freq.put("dni", 1787);
    freq.put("er ", 229484);
    freq.put("ni ", 1743);
    freq.put("Ste", 1353);
    freq.put("Sta", 3406);
    freq.put("Sto", 1709);
    freq.put("Sti", 2399);
    freq.put("nkt", 1750);
    freq.put("Str", 999);
    freq.put("V", 12180);
    freq.put("me", 79970);
    freq.put("eru", 2635);
    freq.put("erv", 2764);
    freq.put("mf", 2516);
    freq.put("ma", 28771);
    freq.put("ltu", 1430);
    freq.put("err", 4661);
    freq.put("mb", 6952);
    freq.put("mm", 27337);
    freq.put("ml", 2687);
    freq.put("mo", 10889);
    freq.put("mn", 1374);
    freq.put("mi", 18259);
    freq.put("mh", 1531);
    freq.put("mk", 2192);
    freq.put("mu", 15391);
    freq.put("mt", 7052);
    freq.put("erf", 2743);
    freq.put("erg", 5102);
    freq.put("mp", 7909);
    freq.put("ms", 5339);
    freq.put("mr", 3179);
    freq.put("erl", 2388);
    freq.put("erm", 1970);
    freq.put("ern", 16903);
    freq.put("ero", 1448);
    freq.put("my", 1487);
    freq.put("eri", 19046);
    freq.put("erk", 1552);
    freq.put("ygg", 4471);
    freq.put("Le", 2792);
    freq.put("La", 5071);
    freq.put("Lo", 2732);
    freq.put("uar", 1965);
    freq.put("la ", 1857);
    freq.put("Li", 3203);
    freq.put("ov ", 1326);
    freq.put("Lu", 1291);
    freq.put("ena", 1550);
    freq.put("enb", 1247);
    freq.put("enc", 1233);
    freq.put("end", 24965);
    freq.put("ene", 9879);
    freq.put("enf", 1295);
    freq.put("eng", 3572);
    freq.put("enh", 4546);
    freq.put("eni", 2823);
    freq.put("hol", 6737);
    freq.put("enk", 1120);
    freq.put("enn", 5553);
    freq.put("a\u030ale", 1126);
    freq.put("hov", 3711);
    freq.put("enr", 1262);
    freq.put("ens", 17443);
    freq.put("ent", 14377);
    freq.put("A", 25625);
    freq.put("ovs", 2306);
    freq.put("lan", 22791);
    freq.put("L ", 1217);
    freq.put("lad", 4353);
    freq.put("lag", 4790);
    freq.put("lac", 1163);
    freq.put("fat", 2864);
    freq.put("ove", 11716);
    freq.put("lat", 2523);
    freq.put("lav", 1728);
    freq.put("ovi", 1957);
    freq.put("lti", 975);
    freq.put("lar", 1164);
    freq.put("las", 2596);
    freq.put("ma\u030a", 5133);
    freq.put("mæ", 2988);
    freq.put("a\u030al ", 1259);
    freq.put("mø", 1338);
    freq.put(" Hu", 1582);
    freq.put(" Hi", 1510);
    freq.put("oni", 2635);
    freq.put(" Ho", 4265);
    freq.put("SAs", 1153);
    freq.put(" Ha", 6811);
    freq.put(" He", 6623);
    freq.put("fir", 1330);
    freq.put("fis", 991);
    freq.put("ækk", 2758);
    freq.put("ime", 1521);
    freq.put("rø", 5891);
    freq.put("ssa", 1137);
    freq.put("ra\u030a", 5052);
    freq.put("ræ", 12201);
    freq.put("fik", 1836);
    freq.put("fin", 3119);
    freq.put("fil", 4788);
    freq.put(" Va", 1707);
    freq.put(" Ve", 4322);
    freq.put(" Vi", 3432);
    freq.put("ma\u030al", 1925);
    freq.put("SA ", 2039);
    freq.put(" Vo", 984);
    freq.put("im ", 977);
    freq.put("den", 48394);
    freq.put("l", 487393);
    freq.put("øen", 1132);
    freq.put("nt ", 5652);
    freq.put("tør", 4175);
    freq.put("rt", 26331);
    freq.put("ru", 25205);
    freq.put("rv", 5600);
    freq.put("rp", 2368);
    freq.put("rr", 10396);
    freq.put("rs", 33077);
    freq.put("dst", 6032);
    freq.put("ry", 5622);
    freq.put("dsp", 2071);
    freq.put("rd", 25935);
    freq.put("re", 122058);
    freq.put("rf", 5902);
    freq.put("rg", 18288);
    freq.put("ra", 54038);
    freq.put("rb", 9120);
    freq.put("rc", 2308);
    freq.put("rl", 8366);
    freq.put("rm", 13546);
    freq.put("rn", 23969);
    freq.put("is ", 8187);
    freq.put("rh", 5594);
    freq.put("ri", 66660);
    freq.put("sma", 1205);
    freq.put("rk", 22061);
    freq.put("ntr", 3209);
    freq.put("nti", 2579);
    freq.put("ntl", 1237);
    freq.put("W", 7598);
    freq.put("nta", 2683);
    freq.put("nte", 11676);
    freq.put("ate", 7241);
    freq.put("øst", 4212);
    freq.put("ata", 1987);
    freq.put("iss", 2416);
    freq.put("ato", 1943);
    freq.put("ist", 15812);
    freq.put("isk", 22022);
    freq.put("isi", 1236);
    freq.put("atu", 2072);
    freq.put("r ", 303465);
    freq.put("ats", 1271);
    freq.put("ism", 1473);
    freq.put("aj ", 1010);
    freq.put("isa", 1650);
    freq.put(" Sp", 1954);
    freq.put("ise", 3850);
    freq.put("nhe", 1266);
    freq.put("nha", 2979);
    freq.put("on ", 17437);
    freq.put("i ", 102076);
    freq.put("tem", 5581);
    freq.put("tor", 9016);
    freq.put("top", 1001);
    freq.put("ød ", 1370);
    freq.put("ton", 2739);
    freq.put("tol", 1446);
    freq.put("kt ", 3134);
    freq.put("tog", 1011);
    freq.put("tod", 1141);
    freq.put(" le", 3614);
    freq.put("B", 25733);
    freq.put(" la", 9917);
    freq.put(" lo", 1691);
    freq.put(" li", 12024);
    freq.put(" lu", 1103);
    freq.put(" ly", 1210);
    freq.put("ktr", 1143);
    freq.put("kto", 1463);
    freq.put("kti", 4258);
    freq.put("mst", 1872);
    freq.put("kte", 2817);
    freq.put("to ", 3441);
    freq.put("thu", 1021);
    freq.put("raf", 2970);
    freq.put("rag", 1612);
    freq.put("rad", 2370);
    freq.put("lbu", 1855);
    freq.put("ran", 8553);
    freq.put("ral", 3419);
    freq.put("ram", 2785);
    freq.put("ty ", 1687);
    freq.put("rak", 1777);
    freq.put("lba", 1173);
    freq.put("rat", 6278);
    freq.put("ras", 1016);
    freq.put("lbo", 1181);
    freq.put("udt", 1177);
    freq.put("Syd", 1794);
    freq.put("hun", 1070);
    freq.put(" læ", 1975);
    freq.put(" la\u030a", 2186);
    freq.put("ra ", 16943);
    freq.put("tyd", 2007);
    freq.put("y", 86732);
    freq.put("ogr", 2357);
    freq.put("typ", 1409);
    freq.put("the", 2230);
    freq.put("tyr", 2052);
    freq.put(" lø", 1660);
    freq.put("don", 1291);
    freq.put("dom", 2065);
    freq.put("m", 293320);
    freq.put("As ", 1183);
    freq.put(" We", 1181);
    freq.put(" Wa", 1857);
    freq.put(" Wo", 983);
    freq.put("d ", 83491);
    freq.put(" Wi", 1981);
    freq.put("oge", 2091);
    freq.put("oci", 1344);
    freq.put("ock", 2154);
    freq.put("em ", 8110);
    freq.put("hri", 1405);
    freq.put("dn", 3058);
    freq.put("do", 7994);
    freq.put("dl", 12465);
    freq.put("dm", 1943);
    freq.put("dj", 1187);
    freq.put("dk", 4450);
    freq.put("dh", 1605);
    freq.put("di", 20969);
    freq.put("df", 2420);
    freq.put("dg", 5250);
    freq.put("dd", 6228);
    freq.put("de", 218146);
    freq.put("db", 9039);
    freq.put("da", 25268);
    freq.put("dy", 2631);
    freq.put("dv", 6155);
    freq.put("dt", 26827);
    freq.put("du", 5081);
    freq.put("dr", 12885);
    freq.put("ds", 29024);
    freq.put("eme", 3075);
    freq.put("lds", 2126);
    freq.put("bar", 1770);
    freq.put("bas", 2113);
    freq.put("emb", 3551);
    freq.put("emm", 3388);
    freq.put("emo", 1300);
    freq.put("emi", 2222);
    freq.put("bag", 1151);
    freq.put("emp", 1313);
    freq.put("ems", 1366);
    freq.put("ban", 5529);
    freq.put("bal", 1468);
    freq.put("om ", 32517);
    freq.put("stj", 1076);
    freq.put("w ", 2415);
    freq.put("nus", 1183);
    freq.put(" I ", 2530);
    freq.put("il ", 24604);
    freq.put("un ", 2311);
    freq.put("irk", 6542);
    freq.put("mul", 1155);
    freq.put("mun", 9999);
    freq.put("ire", 2379);
    freq.put("we", 1786);
    freq.put("wa", 2989);
    freq.put("dæ", 994);
    freq.put("omi", 1702);
    freq.put(" Is", 1181);
    freq.put("wi", 999);
    freq.put("oms", 1669);
    freq.put("omr", 2620);
    freq.put("omp", 2560);
    freq.put("dø", 3867);
    freq.put("Ø", 2784);
    freq.put("gge", 15510);
    freq.put("ild", 2323);
    freq.put("ile", 1492);
    freq.put("ell", 22146);
    freq.put("ilo", 3003);
    freq.put("ill", 15072);
    freq.put("ilm", 4941);
    freq.put("ilk", 1504);
    freq.put("ilh", 993);
    freq.put("ili", 3480);
    freq.put("una", 2326);
    freq.put("und", 15503);
    freq.put("ils", 1343);
    freq.put("ung", 3315);
    freq.put("uni", 2675);
    freq.put("unk", 1906);
    freq.put("com", 1147);
    freq.put(" me", 34653);
    freq.put(" ma", 10653);
    freq.put(" mo", 5717);
    freq.put(" mi", 5228);
    freq.put(" mu", 3617);
    freq.put("ay ", 1009);
    freq.put("san", 3521);
    freq.put("fra", 16811);
    freq.put("fre", 2876);
    freq.put("fri", 2352);
    freq.put("C ", 1471);
    freq.put("gn ", 5722);
    freq.put("pro", 9553);
    freq.put("pri", 5464);
    freq.put("sso", 1208);
    freq.put("dsk", 3064);
    freq.put("Ch", 3540);
    freq.put("Co", 3707);
    freq.put("Cl", 971);
    freq.put("slu", 1369);
    freq.put("Ca", 3808);
    freq.put("Ce", 1101);
    freq.put("n", 746797);
    freq.put("ain", 1470);
    freq.put("elt", 4815);
    freq.put("gne", 9082);
    freq.put("sle", 2180);
    freq.put("gni", 1875);
    freq.put("sla", 3115);
    freq.put(" ma\u030a", 3141);
    freq.put("iz", 977);
    freq.put("ip", 4261);
    freq.put("is", 62018);
    freq.put("ir", 14180);
    freq.put("iu", 2399);
    freq.put("it", 24973);
    freq.put("iv", 18874);
    freq.put("ik", 30570);
    freq.put("im", 7762);
    freq.put("il", 63431);
    freq.put("io", 27519);
    freq.put("in", 99762);
    freq.put("ia", 12086);
    freq.put("ic", 10962);
    freq.put("ib", 6095);
    freq.put("ie", 27731);
    freq.put("id", 25624);
    freq.put("ig", 59928);
    freq.put("if", 7649);
    freq.put("th ", 1733);
    freq.put("nik", 1101);
    freq.put("nin", 14093);
    freq.put("nio", 1012);
    freq.put("kis", 983);
    freq.put("kir", 1742);
    freq.put("Sve", 1310);
    freq.put("nie", 2401);
    freq.put("kin", 2032);
    freq.put("kil", 3875);
    freq.put("Y", 1840);
    freq.put("kib", 1205);
    freq.put("niv", 1911);
    freq.put("nit", 1685);
    freq.put("mil", 3215);
    freq.put("Va", 1711);
    freq.put("Ve", 4334);
    freq.put("Vi", 3450);
    freq.put("ept", 1210);
    freq.put("min", 6763);
    freq.put("Vo", 988);
    freq.put("slæ", 1631);
    freq.put("epa", 1085);
    freq.put("dse", 2268);
    freq.put("yen", 3113);
    freq.put("rn ", 3815);
    freq.put("op ", 2057);
    freq.put("yer", 2527);
    freq.put("vig", 1873);
    freq.put("eli", 11128);
    freq.put("hal", 2007);
    freq.put("ham", 1255);
    freq.put("han", 5336);
    freq.put("ela", 1844);
    freq.put("eld", 1116);
    freq.put("ele", 6394);
    freq.put("els", 21491);
    freq.put("har", 10554);
    freq.put("elv", 2251);
    freq.put("hav", 7061);
    freq.put("opt", 1105);
    freq.put("rni", 1274);
    freq.put("D", 31963);
    freq.put("opr", 3026);
    freq.put("ops", 1721);
    freq.put("rna", 2635);
    freq.put("rne", 13393);
    freq.put("ope", 1372);
    freq.put("opf", 1235);
    freq.put("opa", 1354);
    freq.put("opl", 974);
    freq.put("jer", 5562);
    freq.put("vis", 5672);
    freq.put("el ", 14709);
    freq.put("vde", 1584);
    freq.put("jyl", 1350);
    freq.put("old", 10067);
    freq.put("ole", 3254);
    freq.put(" Ju", 1199);
    freq.put("oli", 4334);
    freq.put("olk", 2982);
    freq.put("oll", 3644);
    freq.put("olm", 1298);
    freq.put("olo", 4008);
    freq.put(" Jo", 2762);
    freq.put("ols", 1497);
    freq.put("gør", 1749);
    freq.put(" Je", 1919);
    freq.put(" Ja", 2336);
    freq.put("ici", 1501);
    freq.put("ich", 2160);
    freq.put("for", 48487);
    freq.put("ykk", 1287);
    freq.put("ica", 1606);
    freq.put("og", 81449);
    freq.put("ice", 1664);
    freq.put("Hu", 1589);
    freq.put("fod", 2203);
    freq.put("Hi", 1514);
    freq.put("Ho", 4306);
    freq.put("umb", 1127);
    freq.put("fol", 2294);
    freq.put("Ha", 6824);
    freq.put("He", 6629);
    freq.put("ol ", 1201);
    freq.put("ple", 1353);
    freq.put("pla", 4596);
    freq.put("ic ", 1068);
    freq.put("o", 488340);
    freq.put("um ", 5774);
    freq.put("sog", 2156);
    freq.put("mbe", 3163);
    freq.put("øge", 1365);
    freq.put("som", 26634);
    freq.put("sol", 1008);
    freq.put("son", 4747);
    freq.put("sor", 1570);
    freq.put("giv", 4136);
    freq.put("gis", 2194);
    freq.put("na\u030a", 1618);
    freq.put("næ", 3458);
    freq.put("gie", 1747);
    freq.put("gio", 2383);
    freq.put("gin", 973);
    freq.put("mt ", 4527);
    freq.put("A\u030a", 1900);
    freq.put(" na\u030a", 1108);
    freq.put(" næ", 2233);
    freq.put("Z", 1413);
    freq.put("gi ", 1776);
    freq.put("nni", 1944);
    freq.put("nne", 10196);
    freq.put("nke", 3504);
    freq.put("nh", 5629);
    freq.put("ni", 34813);
    freq.put("nj", 1002);
    freq.put("nk", 9744);
    freq.put("nl", 3415);
    freq.put("nm", 3852);
    freq.put("nn", 14628);
    freq.put("no", 15192);
    freq.put("tit", 2754);
    freq.put("na", 26783);
    freq.put("nb", 2591);
    freq.put("nc", 5256);
    freq.put("nd", 115468);
    freq.put("ne", 83213);
    freq.put("nf", 2882);
    freq.put("ng", 65185);
    freq.put("til", 27566);
    freq.put("ny", 4222);
    freq.put("tin", 4128);
    freq.put("tio", 14633);
    freq.put("tik", 5022);
    freq.put("tid", 6831);
    freq.put("tie", 1611);
    freq.put("nr", 1599);
    freq.put("ns", 60694);
    freq.put("nt", 31384);
    freq.put("nu", 5799);
    freq.put("nv", 2608);
    freq.put("E", 16857);
    freq.put(" no", 8819);
    freq.put("kva", 1167);
    freq.put(" na", 5975);
    freq.put(" ne", 2244);
    freq.put("kvi", 1085);
    freq.put(" ny", 1418);
    freq.put(" nu", 1920);
    freq.put("n ", 242497);
    freq.put("mme", 16141);
    freq.put("Søn", 999);
    freq.put("rk ", 5973);
    freq.put("ti ", 3596);
    freq.put("kov", 1285);
    freq.put("rol", 2335);
    freq.put("rom", 2663);
    freq.put("ron", 3183);
    freq.put("roc", 1755);
    freq.put("rod", 3399);
    freq.put("ost", 2113);
    freq.put("rof", 1572);
    freq.put("rog", 3109);
    freq.put("osk", 985);
    freq.put("rop", 3118);
    freq.put("lla", 4918);
    freq.put("Bye", 1086);
    freq.put("rot", 1028);
    freq.put("rov", 4008);
    freq.put("ume", 1120);
    freq.put("vet", 6585);
    freq.put("ver", 19395);
    freq.put("ves", 5050);
    freq.put("Dan", 4528);
    freq.put("di ", 1057);
    freq.put("ved", 12182);
    freq.put("ven", 7443);
    freq.put("vel", 2142);
    freq.put("vem", 1052);
    freq.put("vej", 1947);
    freq.put("ert", 4521);
    freq.put("lre", 2112);
    freq.put("ey ", 1638);
    freq.put("ro ", 1858);
    freq.put("umm", 1471);
    freq.put(" Øs", 1852);
    freq.put("os ", 2264);
    freq.put("ll ", 2166);
    freq.put("din", 2827);
    freq.put("dio", 1576);
    freq.put("die", 2342);
    freq.put("ers", 15033);
    freq.put("dia", 1005);
    freq.put("gus", 1029);
    freq.put("p", 139855);
    freq.put("Tab", 1274);
    freq.put("dit", 1114);
    freq.put("der", 53839);
    freq.put("dis", 4268);
    freq.put("M ", 1238);
    freq.put(" Yo", 1015);
    freq.put("yd ", 1599);
    freq.put("Reg", 1718);
    freq.put("erd", 3362);
    freq.put("ere", 36721);
    freq.put("ræk", 2614);
    freq.put("era", 4483);
    freq.put("Me", 3324);
    freq.put("ngd", 1418);
    freq.put("Ma", 7557);
    freq.put("erb", 2464);
    freq.put("kst", 2005);
    freq.put("Mo", 3310);
    freq.put("yde", 3637);
    freq.put("Mi", 3899);
    freq.put("rug", 4144);
    freq.put("Mu", 1568);
    freq.put("O", 9041);
    freq.put("erh", 1890);
    freq.put("bor", 5893);
    freq.put("bol", 3467);
    freq.put("ekt", 4817);
    freq.put("eks", 4054);
    freq.put("ekr", 1629);
    freq.put("tne", 990);
    freq.put("bog", 1211);
    freq.put("a\u030al", 3106);
    freq.put("a\u030an", 3755);
    freq.put("a\u030ae", 2110);
    freq.put("a\u030ad", 6195);
    freq.put("a\u030ab", 1474);
    freq.put("ipt", 1296);
    freq.put("a\u030as", 1047);
    freq.put("a\u030ar", 11909);
    freq.put("jan", 1060);
    freq.put(" Ka", 3227);
    freq.put(" Ke", 1072);
    freq.put("aye", 1830);
    freq.put(" Ki", 2888);
    freq.put(" Ko", 8866);
    freq.put(" Kl", 1820);
    freq.put(" Kr", 1743);
    freq.put("rve", 2295);
    freq.put("ca ", 2352);
    freq.put("øve", 1134);
    freq.put("F", 19795);
    freq.put("a\u030a ", 31271);
    freq.put("ma ", 1277);
    freq.put("Ber", 1053);
    freq.put("fly", 1416);
    freq.put("sø", 4093);
    freq.put("æns", 1603);
    freq.put("ibo", 1076);
    freq.put("ibe", 2142);
    freq.put("ult", 2011);
    freq.put("æng", 3355);
    freq.put("ænd", 2342);
    freq.put("flo", 1580);
    freq.put("fla", 1188);
    freq.put("fle", 2554);
    freq.put("sæ", 4934);
    freq.put("sa\u030a", 7469);
    freq.put("ms ", 982);
    freq.put(" om", 10735);
    freq.put("ger", 26388);
    freq.put(" of", 4764);
    freq.put(" og", 60338);
    freq.put("spr", 2788);
    freq.put("spi", 8255);
    freq.put("spo", 1957);
    freq.put(" ov", 4934);
    freq.put("spa", 1108);
    freq.put(" or", 3538);
    freq.put("spe", 2284);
    freq.put(" op", 11111);
    freq.put("ære", 6027);
    freq.put("ærd", 1139);
    freq.put("ærk", 2357);
    freq.put("rvi", 1176);
    freq.put("ært", 1291);
    freq.put(" Kø", 2558);
    freq.put("s ", 87017);
    freq.put("mas", 1505);
    freq.put("mar", 6718);
    freq.put("mat", 3311);
    freq.put("use", 2336);
    freq.put("sni", 1817);
    freq.put("mag", 1391);
    freq.put("mal", 1831);
    freq.put("man", 9443);
    freq.put("sy", 9417);
    freq.put("ær ", 2495);
    freq.put("ss", 17007);
    freq.put("sr", 1826);
    freq.put("sp", 18285);
    freq.put("sv", 6120);
    freq.put("su", 4879);
    freq.put("st", 117117);
    freq.put("q", 1336);
    freq.put("sj", 1417);
    freq.put("si", 34046);
    freq.put("sh", 5513);
    freq.put("so", 39577);
    freq.put("sn", 3225);
    freq.put("sm", 6568);
    freq.put("sl", 10786);
    freq.put("sc", 3973);
    freq.put("sb", 7435);
    freq.put("sa", 20739);
    freq.put("sg", 1978);
    freq.put("sf", 3067);
    freq.put("se", 58416);
    freq.put("sd", 1411);
    freq.put("Ru", 1537);
    freq.put("lse", 13829);
    freq.put("lsk", 4901);
    freq.put("Re", 4467);
    freq.put("Chr", 1315);
    freq.put("Ra", 2483);
    freq.put("Ro", 3970);
    freq.put("Ri", 2574);
    freq.put("tte", 14611);
    freq.put(" ad", 2058);
    freq.put("gte", 3224);
    freq.put(" af", 47341);
    freq.put("gti", 1404);
    freq.put(" ak", 1320);
    freq.put(" al", 5943);
    freq.put(" am", 5476);
    freq.put(" an", 9937);
    freq.put("gen", 19301);
    freq.put(" ap", 1120);
    freq.put(" ar", 5256);
    freq.put(" at", 12715);
    freq.put(" au", 1423);
    freq.put("gel", 6514);
    freq.put("nom", 1719);
    freq.put("tje", 1256);
    freq.put("ls ", 1795);
    freq.put("nog", 1664);
    freq.put("kke", 10909);
    freq.put("ng ", 25397);
    freq.put("nov", 1161);
    freq.put("nor", 6469);
    freq.put("øje", 1642);
    freq.put("em", 29799);
    freq.put("el", 91687);
    freq.put("eo", 4491);
    freq.put("en", 269379);
    freq.put("ei", 7265);
    freq.put("eh", 3909);
    freq.put("ek", 16142);
    freq.put("ej", 9330);
    freq.put("ee", 3853);
    freq.put("ed", 75055);
    freq.put("eg", 21663);
    freq.put("ef", 12940);
    freq.put("ea", 8665);
    freq.put("ec", 4319);
    freq.put("eb", 9181);
    freq.put("nsp", 982);
    freq.put("fs", 1525);
    freq.put("ey", 2555);
    freq.put("ex", 1370);
    freq.put("ez", 1521);
    freq.put("eu", 3377);
    freq.put("et", 141301);
    freq.put("ew", 2085);
    freq.put("ev", 22509);
    freq.put("ep", 6194);
    freq.put("es", 67128);
    freq.put("er", 363438);
    freq.put("ejl", 1164);
    freq.put("ejd", 2400);
    freq.put("eje", 2612);
    freq.put("blo", 1344);
    freq.put("bli", 3619);
    freq.put("ble", 11852);
    freq.put("bla", 2817);
    freq.put("ejs", 1068);
    freq.put("rli", 2882);
    freq.put("G", 13674);
    freq.put("orv", 1018);
    freq.put("køb", 1295);
    freq.put("rla", 2011);
    freq.put("e ", 256545);
    freq.put("orn", 2079);
    freq.put("øbe", 3709);
    freq.put("orl", 1427);
    freq.put("dig", 3302);
    freq.put("ork", 2427);
    freq.put("orh", 1310);
    freq.put("ori", 4799);
    freq.put("orf", 2453);
    freq.put("org", 9163);
    freq.put("ord", 14176);
    freq.put("ore", 6583);
    freq.put("orb", 3261);
    freq.put("lme", 1724);
    freq.put("ora", 1624);
    freq.put("præ", 2064);
    freq.put("ono", 1620);
    freq.put("mor", 1053);
    freq.put("ona", 4226);
    freq.put("døs", 1339);
    freq.put("ong", 2553);
    freq.put("ond", 1810);
    freq.put("one", 10149);
    freq.put("uld", 1327);
    freq.put("ons", 4853);
    freq.put("død", 1050);
    freq.put("ont", 2499);
    freq.put("Eur", 1467);
    freq.put("ial", 2412);
    freq.put("ian", 3001);
    freq.put("ukt", 2014);
    freq.put("en ", 174071);
    freq.put("hum", 1081);
    freq.put("x ", 2713);
    freq.put("hus", 3072);
    freq.put("jæl", 1755);
    freq.put("ia ", 3660);
    freq.put("r", 850344);
    freq.put("mra\u030a", 2725);
    freq.put("and", 39458);
    freq.put("ane", 4038);
    freq.put("ang", 12562);
    freq.put("ana", 2737);
    freq.put("sam", 8006);
    freq.put("anc", 2097);
    freq.put("anm", 3219);
    freq.put("ann", 5158);
    freq.put("sag", 1459);
    freq.put("ani", 4609);
    freq.put("ank", 4263);
    freq.put("ant", 6958);
    freq.put("anu", 1902);
    freq.put("anv", 1364);
    freq.put("ans", 23197);
    freq.put("sat", 3398);
    freq.put("Do", 1568);
    freq.put("Di", 2020);
    freq.put("j ", 3361);
    freq.put("De", 17413);
    freq.put("Da", 6717);
    freq.put("an ", 17044);
    freq.put(" dø", 1180);
    freq.put(" Le", 2776);
    freq.put(" La", 5040);
    freq.put(" Lo", 2724);
    freq.put(" Li", 3188);
    freq.put(" Lu", 1285);
    freq.put("nla", 1269);
    freq.put("ge ", 22940);
    freq.put("nli", 1178);
    freq.put("We", 1192);
    freq.put("Wa", 1860);
    freq.put("Wo", 997);
    freq.put("iti", 5826);
    freq.put("lub", 2283);
    freq.put("Wi", 1997);
    freq.put("\u0430", 1047);
    freq.put("ges", 3499);
    freq.put(" pr", 10950);
    freq.put("jø", 1567);
    freq.put("get", 6054);
    freq.put("H", 24577);
    freq.put("dyr", 1288);
    freq.put(" pa", 3870);
    freq.put("ssi", 4603);
    freq.put(" pe", 4046);
    freq.put("sse", 5630);
    freq.put("jæ", 2156);
    freq.put(" po", 4785);
    freq.put("Au", 1064);
    freq.put("gem", 1137);
    freq.put(" pl", 3433);
    freq.put(" ba\u030a", 1058);
    freq.put("æse", 1314);
    freq.put("æsk", 1388);
    freq.put("æst", 1815);
    freq.put(" bø", 1211);
    freq.put("øj", 4875);
    freq.put("øk", 983);
    freq.put("øn", 5238);
    freq.put("øl", 3077);
    freq.put("øm", 1629);
    freq.put("øb", 5904);
    freq.put("øg", 2353);
    freq.put("ød", 12599);
    freq.put("øe", 2140);
    freq.put("rma", 3375);
    freq.put("rme", 5215);
    freq.put("ør", 20663);
    freq.put("øs", 5971);
    freq.put("øv", 2281);
    freq.put("ffe", 2245);
    freq.put("nis", 7071);
    freq.put("ytt", 1956);
    freq.put("rko", 1321);
    freq.put("tur", 4777);
    freq.put("jy", 1603);
    freq.put("ju", 2882);
    freq.put("ø ", 2608);
    freq.put("tut", 1397);
    freq.put("js", 1575);
    freq.put("jl", 1331);
    freq.put("rm ", 1940);
    freq.put("jo", 3376);
    freq.put(" pa\u030a", 21281);
    freq.put("jd", 2875);
    freq.put("je", 15216);
    freq.put("tud", 1198);
    freq.put("ja", 3097);
    freq.put(" be", 21652);
    freq.put("z", 8890);
    freq.put(" ba", 5812);
    freq.put(" bl", 16483);
    freq.put(" bo", 2959);
    freq.put(" bi", 2763);
    freq.put(" bu", 1513);
    freq.put("s", 567338);
    freq.put("rki", 1210);
    freq.put(" br", 6861);
    freq.put(" by", 7166);
    freq.put("hvi", 2196);
    freq.put("tun", 1107);
    freq.put("hvo", 4960);
    freq.put("yll", 1699);
    freq.put("hve", 1568);
    freq.put("pos", 979);
    freq.put("pop", 989);
    freq.put("pol", 3456);
    freq.put("fic", 1488);
    freq.put("lys", 1458);
    freq.put("dkr", 1756);
    freq.put("eis", 2241);
    freq.put("ein", 2075);
    freq.put("ive", 12562);
    freq.put("iva", 1011);
    freq.put("ivi", 1481);
    freq.put("Et ", 1446);
    freq.put("tni", 3342);
    freq.put(" Me", 3307);
    freq.put("par", 4298);
    freq.put(" Ma", 7451);
    freq.put(" Mo", 3297);
    freq.put(" Mi", 3885);
    freq.put(" Mu", 1554);
    freq.put("I ", 3326);
    freq.put("pan", 2233);
    freq.put("ga\u030ar", 2699);
    freq.put("ma\u030an", 1657);
    freq.put("iv ", 2118);
    freq.put("I", 12015);
    freq.put("yd", 11050);
    freq.put("gru", 5085);
    freq.put("yg", 7090);
    freq.put("A\u030arh", 1078);
    freq.put("ds ", 4746);
    freq.put("Is", 1195);
    freq.put("pa ", 1106);
    freq.put("æll", 2133);
    freq.put("In", 3339);
    freq.put("æld", 2168);
    freq.put("ort", 7693);
    freq.put("am ", 2554);
    freq.put("gde", 1133);
    freq.put("tis", 8549);
    freq.put("Her", 3429);
    freq.put(" ge", 4611);
    freq.put("ami", 2635);
    freq.put("amm", 7240);
    freq.put("aml", 2016);
    freq.put("ama", 1553);
    freq.put("por", 2733);
    freq.put(" ga", 3502);
    freq.put("ame", 7259);
    freq.put("mon", 1609);
    freq.put("amp", 2062);
    freq.put("amt", 2475);
    freq.put("pst", 1130);
    freq.put("mod", 4612);
    freq.put("tig", 3596);
    freq.put("røn", 1765);
    freq.put("rød", 1365);
    freq.put("tia", 1323);
    freq.put("t", 621215);
    freq.put(" gi", 1512);
    freq.put("ezi", 1048);
    freq.put("New", 1218);
    freq.put(" ci", 1062);
    freq.put(" co", 1546);
    freq.put(" ca", 2244);
    freq.put(" ce", 1786);
    freq.put("dda", 1566);
    freq.put("dde", 3541);
    freq.put("nma", 3344);
    freq.put("tv ", 1126);
    freq.put("oo", 2822);
    freq.put("on", 52834);
    freq.put("om", 68251);
    freq.put("ol", 36629);
    freq.put("ok", 6768);
    freq.put("ace", 1610);
    freq.put("oh", 1849);
    freq.put("ølg", 1529);
    freq.put("of", 9995);
    freq.put("oe", 2046);
    freq.put("ach", 1746);
    freq.put("oc", 5289);
    freq.put("ob", 5028);
    freq.put("oa", 1343);
    freq.put("sek", 1218);
    freq.put("ow", 2461);
    freq.put("ov", 19468);
    freq.put("ou", 6113);
    freq.put("ot", 9072);
    freq.put("os", 11517);
    freq.put("or", 109199);
    freq.put("op", 19430);
    freq.put("Ni", 2023);
    freq.put("bje", 1890);
    freq.put("No", 4840);
    freq.put("Na", 2422);
    freq.put("Ne", 2682);
    freq.put("log", 4064);
    freq.put("her", 3250);
    freq.put("ide", 10399);
    freq.put("lok", 1028);
    freq.put("lom", 2968);
    freq.put("hed", 6692);
    freq.put("los", 1196);
    freq.put("lov", 1376);
    freq.put("lot", 1245);
    freq.put("eha", 1147);
    freq.put("hel", 2400);
    freq.put("eho", 1258);
    freq.put("hen", 2397);
    freq.put("J", 9674);
    freq.put("jul", 1124);
    freq.put("dvi", 2440);
    freq.put("as ", 3170);
    freq.put("he ", 3841);
    freq.put("aa", 1902);
    freq.put("ac", 6807);
    freq.put("ab", 11909);
    freq.put("ae", 3053);
    freq.put("ad", 19629);
    freq.put("ag", 21569);
    freq.put("af", 53343);
    freq.put("ai", 4230);
    freq.put("ah", 1853);
    freq.put("Hol", 1719);
    freq.put("aj", 1819);
    freq.put("am", 30979);
    freq.put("al", 58276);
    freq.put("an", 131829);
    freq.put("ap", 5563);
    freq.put("as", 18978);
    freq.put("ar", 71549);
    freq.put("au", 6593);
    freq.put("at", 56481);
    freq.put("av", 20381);
    freq.put("ay", 3869);
    freq.put("az", 1010);
    freq.put("Lan", 2730);
    freq.put("igt", 6078);
    freq.put("igs", 1981);
    freq.put("igg", 9753);
    freq.put("ige", 19623);
    freq.put("iga", 1060);
    freq.put("ign", 1642);
    freq.put("igi", 1414);
    freq.put("igh", 3457);
    freq.put("a ", 44327);
    freq.put("at ", 17462);
    freq.put("u", 183003);
    freq.put("ig ", 12921);
    freq.put("all", 6438);
    freq.put("alm", 1522);
    freq.put("sch", 1769);
    freq.put("pti", 1074);
    freq.put("ali", 5360);
    freq.put("alg", 1439);
    freq.put("ald", 6029);
    freq.put("ale", 8208);
    freq.put("alb", 2973);
    freq.put("ala", 1794);
    freq.put("gt", 15761);
    freq.put("alv", 1423);
    freq.put("gs", 16863);
    freq.put("alt", 4977);
    freq.put("alr", 2167);
    freq.put("als", 1981);
    freq.put("Fil", 1000);
    freq.put("gr", 16831);
    freq.put("tz", 1053);
    freq.put("ty", 12222);
    freq.put("tv", 2718);
    freq.put("tt", 18340);
    freq.put("tu", 11275);
    freq.put("tr", 31125);
    freq.put("ts", 12139);
    freq.put("tn", 4704);
    freq.put("to", 25039);
    freq.put("tl", 7804);
    freq.put("tm", 1160);
    freq.put("tj", 2329);
    freq.put("th", 7738);
    freq.put("ti", 89903);
    freq.put("tf", 1908);
    freq.put("te", 116420);
    freq.put("tb", 1612);
    freq.put("ta", 40351);
    freq.put("ysk", 5330);
    freq.put("edi", 2262);
    freq.put("ium", 1528);
    freq.put("far", 1600);
    freq.put("fas", 1001);
    freq.put("al ", 9518);
    freq.put(" ræ", 1334);
    freq.put("fan", 1048);
    freq.put("gy", 1588);
    freq.put("fal", 1044);
    freq.put("fam", 1418);
    freq.put("ruk", 1154);
    freq.put("sme", 2348);
    freq.put(" Ni", 2020);
    freq.put("gg", 16392);
    freq.put("pre", 2422);
    freq.put("ro", 34074);
    freq.put(" No", 4834);
    freq.put("eds", 6584);
    freq.put(" Na", 2409);
    freq.put("dsb", 2127);
    freq.put(" Ne", 2661);
    freq.put("ge", 89823);
    freq.put("bæ", 1473);
    freq.put("dsa", 1334);
    freq.put("rbu", 1055);
    freq.put("t ", 215608);
    freq.put("gb", 1002);
    freq.put("En ", 3727);
    freq.put("tek", 2453);
    freq.put("tel", 3444);
    freq.put("ga", 13601);
    freq.put("ten", 11717);
    freq.put("ted", 5198);
    freq.put("fær", 971);
    freq.put("teg", 5502);
    freq.put("fæl", 1337);
    freq.put("ter", 41030);
    freq.put("tes", 3522);
    freq.put("tet", 9121);
    freq.put("ros", 1298);
    freq.put("abe", 4887);
    freq.put("tø", 6010);
    freq.put("ose", 1440);
    freq.put("lle", 37621);
    freq.put("tæ", 3691);
    freq.put("ha\u030an", 1024);
    freq.put("ta\u030a", 3749);
    freq.put(" ru", 2426);
    freq.put("te ", 23992);
    freq.put("K", 25355);
    freq.put(" re", 10118);
    freq.put(" ra", 1828);
    freq.put(" ro", 3386);
    freq.put(" ri", 1551);
    freq.put("ab ", 2197);
    freq.put("oma", 2195);
    freq.put("ev ", 11307);
    freq.put("lke", 3500);
    freq.put("nto", 1311);
    freq.put("vid", 3491);
    freq.put("rks", 2467);
    freq.put("vik", 2041);
    freq.put("vin", 4397);
    freq.put("vil", 2648);
    freq.put("vir", 2222);
    freq.put("rke", 7276);
    freq.put("rka", 1044);
    freq.put("S ", 1850);
    freq.put(" s ", 1355);
    freq.put("de ", 51365);
    freq.put("Sy", 2480);
    freq.put("fø", 16135);
    freq.put("Sp", 1977);
    freq.put("Sv", 1640);
    freq.put("Su", 1509);
    freq.put("St", 10943);
    freq.put("Sk", 3103);
    freq.put("Si", 2298);
    freq.put("Sh", 1188);
    freq.put("So", 7973);
    freq.put("fa\u030a", 1004);
    freq.put("fæ", 2974);
    freq.put("Sl", 1960);
    freq.put("Sc", 1974);
    freq.put("Sa", 4145);
    freq.put("Se", 2517);
    freq.put(" do", 1734);
    freq.put("kle", 1997);
    freq.put("kla", 3032);
    freq.put(" di", 4041);
    freq.put("jde", 2262);
    freq.put(" de", 85238);
    freq.put("des", 7277);
    freq.put("det", 27574);
    freq.put("kli", 1244);
    freq.put(" da", 14483);
    freq.put("deh", 997);
    freq.put("klu", 1988);
    freq.put("del", 20136);
    freq.put("dem", 1809);
    freq.put(" dy", 1311);
    freq.put("v", 176622);
    freq.put("Ind", 1212);
    freq.put("deb", 1003);
    freq.put(" dr", 1947);
    freq.put("ega\u030a", 1006);
    freq.put("A\u030ar", 1234);
    freq.put("f ", 48816);
    freq.put("avd", 1374);
    freq.put("ati", 16074);
    freq.put("ryk", 1357);
    freq.put("att", 4875);
    freq.put("lam", 1129);
    freq.put("Tys", 1072);
    freq.put("fr", 23015);
    freq.put("Sø", 1957);
    freq.put("ft", 15592);
    freq.put("fu", 3863);
    freq.put("fy", 1735);
    freq.put("fa", 10884);
    freq.put("fe", 8693);
    freq.put("ff", 4196);
    freq.put("fh", 1152);
    freq.put("fi", 15203);
    freq.put("fj", 1452);
    freq.put("fl", 7833);
    freq.put("fo", 54992);
    freq.put("a", 587527);
    freq.put("egr", 1976);
    freq.put("ry ", 1399);
    freq.put("egi", 3950);
    freq.put("a\u030aen", 1002);
    freq.put("egn", 6321);
    freq.put("omh", 1267);
    freq.put("o\u0308", 1579);
    freq.put("ege", 4459);
    freq.put(" sø", 1940);
    freq.put("ce ", 2816);
    freq.put("y ", 17470);
    freq.put("ite", 4554);
    freq.put("ita", 3145);
    freq.put("ffi", 1018);
    freq.put("itt", 1519);
    freq.put("itu", 1780);
    freq.put(" sæ", 2010);
    freq.put(" sa\u030a", 2369);
    freq.put(" Or", 1513);
    freq.put("yk", 3734);
    freq.put("ym", 2136);
    freq.put("yl", 4209);
    freq.put("yn", 4794);
    freq.put("ya", 1357);
    freq.put("cen", 3123);
    freq.put("yb", 1013);
    freq.put("ye", 6589);
    freq.put("L", 17275);
    freq.put("it ", 2641);
    freq.put("Bay", 1295);
    freq.put("oka", 1272);
    freq.put("ces", 1087);
    freq.put("cer", 3808);
    freq.put("yp", 2457);
    freq.put("ys", 11680);
    freq.put("yr", 5643);
    freq.put("yt", 3483);
    freq.put("ift", 4749);
    freq.put("ynd", 1352);
    freq.put(" sy", 6433);
    freq.put(" sp", 8070);
    freq.put(" sv", 2066);
    freq.put(" st", 20417);
    freq.put(" su", 1555);
    freq.put(" sk", 10508);
    freq.put(" si", 12012);
    freq.put(" so", 28866);
    freq.put(" sl", 3070);
    freq.put(" sm", 1227);
    freq.put(" sa", 10706);
    freq.put(" se", 8834);
    freq.put("ævn", 987);
    freq.put("fte", 8906);
    freq.put("ass", 3627);
    freq.put(" Aa", 1413);
    freq.put("pun", 1123);
    freq.put("ve ", 6698);
    freq.put("ast", 4061);
    freq.put("mmu", 9493);
    freq.put("sby", 2385);
    freq.put(" Al", 3774);
    freq.put(" Am", 3639);
    freq.put(" An", 3489);
    freq.put(" Ar", 2597);
    freq.put(" As", 1298);
    freq.put(" Au", 1061);
    freq.put("ase", 2004);
    freq.put("sbe", 2183);
    freq.put("ask", 1161);
    freq.put("Uni", 1434);
    freq.put("asi", 1827);
    freq.put("ræs", 2950);
    freq.put("El", 1343);
    freq.put("En", 5373);
    freq.put("pa\u030a ", 20701);
    freq.put("kon", 5299);
    freq.put("ft ", 4358);
    freq.put("w", 11095);
    freq.put("Eu", 1618);
    freq.put("Et", 1623);
    freq.put("ræn", 2483);
    freq.put("Er", 1008);
    freq.put("Fra", 1859);
    freq.put("dt ", 18171);
    freq.put("Fre", 1891);
    freq.put(" el", 13704);
    freq.put(" en", 65390);
    freq.put("kom", 8214);
    freq.put("kol", 2985);
    freq.put("jet", 1025);
    freq.put(" ek", 1980);
    freq.put(" ef", 3944);
    freq.put(" eg", 1315);
    freq.put("øn ", 1089);
    freq.put(" et", 23500);
    freq.put("jek", 1076);
    freq.put("kor", 3059);
    freq.put("jen", 1901);
    freq.put(" er", 79580);
    freq.put("jem", 1846);
    freq.put("ær", 17270);
    freq.put("æs", 6691);
    freq.put("æt", 3678);
    freq.put("æv", 1666);
    freq.put("odu", 2868);
    freq.put("æd", 2878);
    freq.put("æg", 5488);
    freq.put("æk", 5318);
    freq.put("æl", 6220);
    freq.put("nce", 2989);
    freq.put("æn", 8602);
    freq.put("ste", 30468);
    freq.put("dti", 2638);
    freq.put("b", 166372);
    freq.put("kæ", 2283);
    freq.put("stl", 3640);
    freq.put("tof", 1468);
    freq.put("stn", 1107);
    freq.put("sto", 7688);
    freq.put("sti", 13739);
    freq.put("dte", 2421);
    freq.put("stu", 1392);
    freq.put("je ", 1645);
    freq.put("ønd", 1642);
    freq.put("str", 12753);
    freq.put("hæn", 1282);
    freq.put("dtr", 1052);
    freq.put("kø", 2883);
    freq.put("sty", 2236);
    freq.put("ka ", 2541);
    freq.put("a\u030ade", 4772);
    freq.put("odb", 2119);
    freq.put("lie", 4111);
    freq.put("k ", 53472);
    freq.put("lia", 1325);
    freq.put("lil", 1691);
    freq.put("Kir", 1207);
    freq.put("lin", 9392);
    freq.put("eft", 4164);
    freq.put("lik", 2160);
    freq.put("lit", 4876);
    freq.put("efi", 1531);
    freq.put("liv", 2785);
    freq.put("efo", 3934);
    freq.put("kab", 5579);
    freq.put("vne", 3693);
    freq.put("oft", 2765);
    freq.put("Øst", 1835);
    freq.put("M", 22557);
    freq.put("kan", 11432);
    freq.put("kam", 1128);
    freq.put("kal", 6243);
    freq.put("kas", 971);
    freq.put("kar", 1404);
    freq.put("vns", 1255);
    freq.put("rho", 1270);
    freq.put("kat", 1697);
    freq.put("The", 2590);
    freq.put("kb", 1624);
    freq.put("ka", 33369);
    freq.put("li ", 1269);
    freq.put("ke", 62501);
    freq.put("kk", 11850);
    freq.put("ki", 13129);
    freq.put("ko", 24231);
    freq.put("kn", 3763);
    freq.put("km", 2041);
    freq.put("kl", 9428);
    freq.put("ks", 11787);
    freq.put("kr", 19731);
    freq.put("kv", 2686);
    freq.put("ku", 9611);
    freq.put("kt", 15601);
    freq.put("ky", 2485);
    freq.put("stø", 3565);
    freq.put("rte", 6848);
    freq.put("rta", 1313);
    freq.put("Han", 2509);
    freq.put("ugl", 1024);
    freq.put("sa\u030a ", 5902);
    freq.put("rti", 3566);
    freq.put("uge", 2701);
    freq.put("rts", 2294);
    freq.put("ugu", 1009);
    freq.put("ugt", 1589);
    freq.put("Ju", 1199);
    freq.put("ier", 4656);
    freq.put("iet", 2644);
    freq.put("Jo", 2770);
    freq.put("iel", 2523);
    freq.put("ien", 9683);
    freq.put("Je", 1924);
    freq.put("Ja", 2348);
    freq.put("his", 2209);
    freq.put("rt ", 7502);
    freq.put("hin", 1447);
    freq.put("sta", 15172);
    freq.put("rfa", 1970);
    freq.put("ie ", 4513);
    freq.put("rfo", 1099);
    freq.put(" Be", 3849);
    freq.put("arr", 1598);
    freq.put("ars", 2045);
    freq.put(" Ba", 5300);
    freq.put("ser", 12739);
    freq.put("For", 2210);
    freq.put("sep", 1174);
    freq.put(" Bl", 1427);
    freq.put(" Bo", 3066);
    freq.put(" Bi", 1733);
    freq.put(" Bu", 1519);
    freq.put("ara", 2794);
    freq.put("arb", 2537);
    freq.put("ik ", 5837);
    freq.put("ard", 3649);
    freq.put("are", 4543);
    freq.put(" Br", 3787);
    freq.put("ari", 4342);
    freq.put("sem", 1108);
    freq.put("ark", 7252);
    freq.put(" By", 1610);
    freq.put("arm", 1244);
    freq.put("leg", 1270);
    freq.put("ses", 2382);
    freq.put(" a\u030ar", 3117);
    freq.put("iks", 1269);
    freq.put("tæn", 1204);
    freq.put("ikt", 1780);
    freq.put("upp", 2843);
    freq.put("ue ", 1121);
    freq.put("ar ", 24485);
    freq.put("ikb", 1260);
    freq.put("ika", 7541);
    freq.put("ike", 2959);
    freq.put("se ", 14360);
    freq.put("ikk", 5095);
    freq.put("ikl", 2029);
    freq.put(" Pr", 4618);
    freq.put("c", 57573);
    freq.put(" Pa", 3735);
    freq.put(" Pe", 2468);
    freq.put("ø", 71666);
    freq.put(" Pi", 1093);
    freq.put(" Po", 2365);
    freq.put("pr", 20775);
    freq.put("ps", 3450);
    freq.put("pp", 6074);
    freq.put("duk", 1051);
    freq.put("pt", 4539);
    freq.put("pu", 4408);
    freq.put("duc", 1998);
    freq.put("tiv", 4885);
    freq.put("geo", 1146);
    freq.put("pa", 11174);
    freq.put("pf", 1434);
    freq.put("pe", 19212);
    freq.put("ph", 1997);
    freq.put("pi", 13460);
    freq.put("po", 10483);
    freq.put("pl", 7694);
    freq.put(" ty", 5331);
    freq.put(" tv", 1505);
    freq.put(" tr", 6706);
    freq.put("N", 16361);
    freq.put(" to", 3836);
    freq.put("gan", 5170);
    freq.put("gam", 1188);
    freq.put(" ti", 28004);
    freq.put(" th", 1962);
    freq.put(" te", 4720);
    freq.put("gad", 1042);
    freq.put(" ta", 3468);
    freq.put("mle", 1475);
    freq.put(" fø", 12841);
    freq.put("p ", 7331);
    freq.put("gsa\u030a", 4604);
    freq.put(" fæ", 1545);
    freq.put("fun", 1949);
    freq.put("riv", 2443);
    freq.put("rit", 3128);
    freq.put("ris", 7929);
    freq.put("rip", 1436);
    freq.put("vok", 971);
    freq.put("rin", 12007);
    freq.put("rio", 1666);
    freq.put("ril", 1328);
    freq.put("rim", 1705);
    freq.put("rik", 9410);
    freq.put("vor", 5368);
    freq.put("rif", 1151);
    freq.put("rig", 7130);
    freq.put("rid", 1336);
    freq.put("rie", 7227);
    freq.put("rib", 1119);
    freq.put("ric", 1788);
    freq.put("ria", 2312);
    freq.put("gs ", 1501);
    freq.put("pæ", 1318);
    freq.put("pa\u030a", 21476);
    freq.put("næs", 1010);
    freq.put("dga", 1116);
    freq.put("syd", 3714);
    freq.put("dgi", 2184);
    freq.put("syn", 1352);
    freq.put("sys", 1619);
    freq.put("lig", 34196);
    freq.put(" tæ", 998);
    freq.put("ri ", 2041);
    freq.put(" fr", 19782);
    freq.put(" fu", 1922);
    freq.put("gst", 2115);
    freq.put("Sog", 4806);
    freq.put("kni", 2413);
    freq.put(" fy", 1194);
    freq.put("ew ", 1416);
    freq.put(" fa", 4879);
    freq.put("ppe", 4792);
    freq.put("gsb", 1331);
    freq.put(" fe", 2371);
    freq.put(" fi", 8516);
    freq.put("gsk", 1233);
    freq.put(" fl", 5239);
    freq.put(" fo", 43206);
    freq.put("lde", 9460);
    freq.put("hje", 2112);
    freq.put("ldt", 2484);
    freq.put("rga", 2811);
    freq.put("sal", 1002);
    freq.put("rge", 3583);
    freq.put("rgi", 1032);
    freq.put("bin", 2468);
    freq.put("ba\u030a", 1373);
    freq.put("bil", 1901);
    freq.put("ld ", 5587);
    freq.put("lis", 3436);
    freq.put("Ba", 5317);
    freq.put("bø", 1832);
    freq.put("Or", 1531);
    freq.put("d", 493190);
    freq.put("rg ", 8008);
    freq.put("een", 1037);
    freq.put("b ", 7025);
    freq.put("per", 8319);
    freq.put("pel", 1218);
    freq.put("pen", 2557);
    freq.put("id ", 2460);
    freq.put("pec", 1027);
    freq.put("be", 49808);
    freq.put("run", 5278);
    freq.put("ba", 15017);
    freq.put("bb", 2090);
    freq.put("rum", 2612);
    freq.put("bl", 20954);
    freq.put("rhu", 1754);
    freq.put("bo", 14081);
    freq.put("bi", 8379);
    freq.put("bj", 2063);
    freq.put("rue", 1823);
    freq.put("bu", 7411);
    freq.put("br", 14152);
    freq.put("bs", 2188);
    freq.put("rus", 1691);
    freq.put("rup", 5078);
    freq.put("by", 15888);
    freq.put("a\u0308", 1464);
    freq.put("idt", 1926);
    freq.put("ids", 2132);
    freq.put("idl", 3701);
    freq.put("idi", 1064);
    freq.put("idd", 1704);
    freq.put("Ros", 1109);
    freq.put("pe ", 3064);
    freq.put("nsi", 1207);
    freq.put("nsk", 23035);
    freq.put("nsb", 1130);
    freq.put("nse", 6294);
    freq.put("tif", 3307);
    freq.put(" un", 6550);
    freq.put(" ud", 14434);
    freq.put("nst", 8074);
    freq.put("ut ", 1499);
    freq.put("ætt", 1489);
    freq.put("grø", 1000);
    freq.put("græ", 2818);
    freq.put("mkr", 1669);
    freq.put("uss", 1778);
    freq.put("tys", 3953);
    freq.put("u ", 4030);
    freq.put("fes", 1566);
    freq.put(" Ch", 3522);
    freq.put("løs", 1373);
    freq.put(" Co", 3667);
    freq.put("sta\u030a", 3319);
    freq.put("ns ", 13305);
    freq.put(" Ca", 3749);
    freq.put("stæ", 1164);
    freq.put(" Ce", 1081);
    freq.put("løb", 1835);
    freq.put("ktø", 1090);
    freq.put("cia", 1876);
    freq.put("a\u030a", 62645);
    freq.put("cie", 1532);
    freq.put("ute", 1658);
    freq.put("ut", 8713);
    freq.put("uti", 1400);
    freq.put("up", 6927);
    freq.put("us", 20761);
    freq.put("ur", 17879);
    freq.put("um", 12141);
    freq.put("ul", 11807);
    freq.put("un", 39154);
    freq.put("ui", 2354);
    freq.put("uk", 3985);
    freq.put("ue", 7203);
    freq.put("ud", 21845);
    freq.put("ug", 8656);
    freq.put("uf", 1429);
    freq.put("ua", 3814);
    freq.put("uc", 3424);
    freq.put("ub", 5076);
    freq.put("Ty", 1556);
    freq.put("Tr", 2242);
    freq.put("To", 2011);
    freq.put("Th", 4228);
    freq.put("Ti", 1419);
    freq.put("Te", 2146);
    freq.put("Ta", 2888);
    freq.put("A ", 4032);
    freq.put(" gu", 1731);
    freq.put(" gr", 8357);
    freq.put("nan", 1050);
    freq.put("nal", 7713);
    freq.put("ag ", 3450);
    freq.put("nar", 1016);
    freq.put("nas", 1015);
    freq.put("gre", 2783);
    freq.put("nav", 5158);
    freq.put("nat", 4037);
    freq.put("gra", 4027);
    freq.put("Man", 1218);
    freq.put("Aa", 1418);
    freq.put("na ", 3264);
    freq.put("e", 1436845);
    freq.put("svi", 1847);
    freq.put("dve", 2150);
    freq.put("age", 8240);
    freq.put("sve", 1375);
    freq.put("Am", 3646);
    freq.put("Al", 3794);
    freq.put("An", 3500);
    freq.put("As", 2462);
    freq.put("Ar", 2625);
    freq.put(" pi", 1184);
    freq.put("agt", 3576);
    freq.put(" b", 68676);
    freq.put(" c", 8562);
    freq.put("gu", 4973);
    freq.put(" a", 95172);
    freq.put(" f", 104584);
    freq.put(" g", 23827);
    freq.put(" d", 112412);
    freq.put(" e", 192889);
    freq.put(" j", 6194);
    freq.put(" k", 49552);
    freq.put(" h", 49372);
    freq.put(" i", 113380);
    freq.put(" n", 25041);
    freq.put(" o", 98877);
    freq.put(" l", 35858);
    freq.put(" m", 66057);
    freq.put(" r", 22226);
    freq.put(" s", 123480);
    freq.put(" p", 52152);
    freq.put("gd", 2544);
    freq.put(" v", 42657);
    freq.put(" w", 1082);
    freq.put(" t", 58677);
    freq.put(" u", 24358);
    freq.put("go", 3646);
    freq.put("gn", 17858);
    freq.put("gl", 6422);
    freq.put("gi", 15986);
    freq.put("gh", 4618);
    freq.put(" B", 25561);
    freq.put(" C", 16566);
    freq.put(" A", 25498);
    freq.put(" F", 19659);
    freq.put(" G", 13552);
    freq.put(" D", 31783);
    freq.put(" E", 16778);
    freq.put(" J", 9634);
    freq.put(" K", 25242);
    freq.put(" H", 24422);
    freq.put(" I", 11943);
    freq.put(" N", 16289);
    freq.put(" O", 8943);
    freq.put(" L", 17176);
    freq.put(" M", 22363);
    freq.put(" R", 17196);
    freq.put(" S", 49095);
    freq.put(" P", 17741);
    freq.put(" V", 12125);
    freq.put(" W", 7540);
    freq.put(" T", 19345);
    freq.put(" U", 7720);
    freq.put(" Z", 1391);
    freq.put(" Y", 1835);
    freq.put("Nor", 4041);
    freq.put("ch ", 2261);
    freq.put("ed ", 35220);
    freq.put("P", 17849);
    freq.put("g ", 111365);
    freq.put("tri", 4615);
    freq.put("evi", 1173);
    freq.put("tro", 3770);
    freq.put("tra", 6691);
    freq.put("eva", 1631);
    freq.put("us ", 6486);
    freq.put("tre", 5166);
    freq.put("eve", 5776);
    freq.put("try", 1478);
    freq.put("tru", 5093);
    freq.put("le ", 18274);
    freq.put("uel", 1000);
    freq.put(" æ", 1756);
    freq.put("zi", 1962);
    freq.put("rri", 1525);
    freq.put(" a\u030a", 3941);
    freq.put("ze", 1041);
    freq.put("rre", 6580);
    freq.put("ods", 1493);
    freq.put("za", 1046);
    freq.put("gø", 1910);
    freq.put("ga\u030a", 3551);
    freq.put(" ø", 5351);
    freq.put("ode", 4999);
    freq.put("ues", 1633);
    freq.put("uer", 2229);
    freq.put(" Re", 4459);
    freq.put(" A\u030a", 1898);
    freq.put("uli", 1842);
    freq.put("rd ", 6821);
    freq.put(" Ø", 2782);
    freq.put("led", 4289);
    freq.put("obe", 1539);
    freq.put("meg", 1181);
    freq.put("lek", 2168);
    freq.put("z ", 1958);
    freq.put("lem", 6534);
    freq.put("len", 6881);
    freq.put("ler", 27840);
    freq.put("les", 5717);
    freq.put("let", 5891);
    freq.put("lev", 14315);
    freq.put("kue", 1399);
    freq.put("od ", 3992);
    freq.put("rdv", 999);
    freq.put("rds", 1442);
    freq.put("evæ", 1177);
    freq.put("træ", 3121);
    freq.put("rde", 7501);
    freq.put("rda", 1335);
    freq.put("nær", 1381);
    freq.put("rdl", 1187);
    freq.put("ule", 1205);
    freq.put("rdi", 2720);
    freq.put(" Do", 1505);
    freq.put("Ver", 993);
    freq.put("Ves", 1255);
    freq.put(" Di", 2014);
    freq.put(" De", 17357);
    freq.put(" Da", 6687);
    freq.put("cha", 1908);
    freq.put("Fr", 4782);
    freq.put("zir", 1025);
    freq.put("che", 2404);
    freq.put(" væ", 5438);
    freq.put("fen", 1036);
    freq.put("usk", 1540);
    freq.put("usi", 3385);
    freq.put("Fa", 2183);
    freq.put("ust", 3006);
    freq.put("fer", 1682);
    freq.put("Fe", 1146);
    freq.put("Fi", 2355);
    freq.put("Fl", 1651);
    freq.put("ra\u030ad", 3726);
    freq.put("Fo", 3851);
    freq.put("ægt", 2411);
    freq.put("æge", 1409);
    freq.put("ndl", 3623);
    freq.put(" Ru", 1535);
    freq.put("oi", 1528);
    freq.put("f", 221888);
    freq.put("km ", 1307);
    freq.put("F ", 2501);
    freq.put("ack", 1318);
    freq.put(" Ra", 2473);
    freq.put(" Ro", 3958);
    freq.put(" Ri", 2570);
    freq.put("tat", 8263);
    freq.put("od", 18682);
    freq.put("tar", 2918);
    freq.put("tad", 2960);
    freq.put("tag", 2922);
    freq.put("tab", 1032);
    freq.put("tal", 8954);
    freq.put("tam", 1561);
    freq.put("tan", 5101);
    freq.put(" va", 14642);
    freq.put(" ve", 13203);
    freq.put("afi", 1171);
    freq.put("Yo", 1017);
    freq.put("sit", 3034);
    freq.put(" vi", 7015);
    freq.put(" vo", 1548);
    freq.put("sig", 4968);
    freq.put("sie", 1150);
    freq.put("sid", 5798);
    freq.put("aft", 1820);
    freq.put("sio", 2930);
    freq.put("sin", 4733);
    freq.put("afs", 1107);
    freq.put("sis", 4442);
    freq.put("ta ", 2303);
    freq.put("afh", 1105);
    freq.put("ndr", 5292);
    freq.put("æ", 62497);
    freq.put("af ", 43757);
    freq.put("ba\u030ad", 1117);
    freq.put("la\u030a ", 2263);
    freq.put("da ", 2439);
    freq.put("kba", 1487);
    freq.put("nyt", 1313);
    freq.put("lf", 2530);
    freq.put("lg", 4872);
    freq.put("ld", 24706);
    freq.put("le", 98770);
    freq.put("lb", 6128);
    freq.put("la", 47170);
    freq.put("lo", 18381);
    freq.put("ll", 54007);
    freq.put("lm", 9161);
    freq.put("lk", 6427);
    freq.put("lh", 1724);
    freq.put("li", 70659);
    freq.put("lv", 5002);
    freq.put("føl", 1523);
    freq.put("lt", 13794);
    freq.put("lu", 8894);
    freq.put("lr", 2728);
    freq.put("ls", 28805);
    freq.put("lp", 1954);
    freq.put("byg", 4928);
    freq.put("bye", 2309);
    freq.put("ly", 5517);
    freq.put("dag", 2881);
    freq.put("dal", 1321);
    freq.put("Car", 1184);
    freq.put("dan", 12624);
    freq.put("sær", 1369);
    freq.put("dat", 1966);
    freq.put("sik", 3367);
    freq.put("ema", 1766);
    freq.put("ogl", 1041);
    freq.put("San", 1256);
    freq.put("l ", 57442);
    freq.put("nfo", 1407);
    freq.put("Pro", 2885);
    freq.put(" hv", 8333);
    freq.put(" hu", 1995);
    freq.put(" hj", 2649);
    freq.put(" hi", 2424);
    freq.put(" ho", 5868);
    freq.put(" ha", 16862);
    freq.put(" he", 5872);
    freq.put("oun", 1213);
    freq.put("our", 1852);
    freq.put("ogn", 7366);
    freq.put("by ", 6807);
    freq.put("læ", 7117);
    freq.put("la\u030a", 3180);
    freq.put("emt", 1052);
    freq.put("rer", 8658);
    freq.put("res", 7617);
    freq.put("rep", 1174);
    freq.put("rev", 3074);
    freq.put("ret", 16711);
    freq.put("rek", 1859);
    freq.put("rei", 2319);
    freq.put("ren", 13272);
    freq.put("rel", 3506);
    freq.put("rem", 3072);
    freq.put("reb", 1759);
    freq.put("rea", 2289);
    freq.put("ref", 3055);
    freq.put("reg", 5210);
    freq.put("lø", 4835);
    freq.put("ece", 1005);
    freq.put("eci", 1115);
    freq.put("x", 5939);
    freq.put(" hø", 2581);
    freq.put("lod", 2232);
    freq.put("g", 349504);
    freq.put("lta", 1027);
    freq.put("lte", 2079);
    freq.put("høj", 2362);
    freq.put("re ", 32700);
    freq.put("u\u0308", 1583);
    freq.put(" ha\u030a", 1306);
    freq.put("rs ", 4872);
    freq.put("ud ", 2370);
    freq.put("set", 2238);
    freq.put("art", 9040);
    freq.put("og ", 59080);
    freq.put(" Sy", 2476);
    freq.put("arv", 1066);
    freq.put("hør", 1554);
    freq.put("be ", 1587);
    freq.put(" Sv", 1637);
    freq.put("nda", 1742);
    freq.put(" St", 10885);
    freq.put(" Su", 1503);
    freq.put(" Sk", 3100);
    freq.put(" Sh", 1168);
    freq.put(" Si", 2284);
    freq.put(" So", 7960);
    freq.put(" Sl", 1954);
    freq.put(" Sc", 1958);
    freq.put(" Sa", 4126);
    freq.put(" Se", 2497);
    freq.put("rsl", 985);
    freq.put("uds", 2177);
    freq.put("Ka", 3252);
    freq.put("rso", 2553);
    freq.put("udv", 2056);
    freq.put("rsi", 2088);
    freq.put("Ke", 1081);
    freq.put("rsk", 6329);
    freq.put("rse", 2094);
    freq.put("Ki", 2897);
    freq.put("Ko", 8878);
    freq.put("rsa", 1053);
    freq.put("ogs", 5045);
    freq.put("Kl", 1826);
    freq.put("udb", 1145);
    freq.put("Kr", 1747);
    freq.put("R", 17256);
    freq.put("ogi", 3275);
    freq.put("udg", 3260);
    freq.put("udd", 1881);
    freq.put("ude", 3316);
    freq.put("rst", 8534);
    freq.put("udi", 978);
    freq.put("bej", 2245);
    freq.put("ben", 6123);
    freq.put("bel", 6286);
    freq.put("bef", 974);
    freq.put("beg", 2119);
    freq.put("bed", 1902);
    freq.put("bez", 990);
    freq.put("ber", 10275);
    freq.put("bes", 5570);
    freq.put("bev", 1288);
    freq.put("bet", 8125);
    freq.put("Par", 1507);
    freq.put("sen", 14543);
    freq.put("sk", 90052);
    freq.put(" Sø", 1956);
    freq.put("sel", 4270);
    freq.put("ur ", 2594);
    freq.put("ck ", 2373);
    freq.put("ghe", 2580);
    freq.put("arl", 1801);
    freq.put("Køb", 2308);
    freq.put("mid", 2156);
    freq.put("hr", 2287);
    freq.put("mis", 2297);
    freq.put(" El", 1337);
    freq.put(" En", 5365);
    freq.put("hv", 9222);
    freq.put("sfo", 1331);
    freq.put("st ", 15643);
    freq.put(" Et", 1617);
    freq.put(" Eu", 1616);
    freq.put("Kø", 2561);
    freq.put(" Er", 1002);
    freq.put("cke", 1007);
    freq.put("ure", 2206);
    freq.put("urg", 1747);
    freq.put("æde", 2099);
    freq.put("mus", 3381);
    freq.put("urn", 1614);
    freq.put("uro", 2454);
    freq.put("uri", 1026);
    freq.put("urt", 1085);
    freq.put("hn", 1182);
    freq.put("læg", 3305);
    freq.put("dbo", 3204);
    freq.put("Cha", 1198);
    freq.put("læn", 1040);
    freq.put("dby", 3214);
    freq.put("lær", 1638);
    freq.put("dbr", 1439);
    freq.put("eda", 1072);
    freq.put("nge", 21530);
    freq.put("ngl", 1961);
    freq.put(" is", 1666);
    freq.put("ngi", 1084);
    freq.put("kse", 1892);
    freq.put(" ik", 2700);
    freq.put(" in", 18970);
    freq.put("ngs", 7820);
    freq.put("kso", 1301);
    freq.put("qu", 972);
    freq.put("h", 119659);
    freq.put("lst", 4539);
    freq.put("ks ", 2322);
    freq.put(" i ", 86016);
    freq.put("sho", 1591);
    freq.put("Pr", 4633);
    freq.put("ebe", 1273);
    freq.put("ebo", 1021);
    freq.put("C", 16797);
    freq.put("ke ", 28879);
    freq.put("Pa", 3757);
    freq.put("ebr", 1930);
    freq.put("Pe", 2483);
    freq.put("ede", 18829);
    freq.put("Pi", 1096);
    freq.put("Po", 2392);
    freq.put("dla", 1839);
    freq.put("lut", 1751);
    freq.put("ome", 4668);
    freq.put("dle", 3278);
    freq.put("dli", 6294);
    freq.put("omk", 1807);
    freq.put("et ", 110723);
    freq.put("a\u030ar ", 6325);
    freq.put("EF ", 1275);
    freq.put("ken", 10401);
    freq.put("jor", 2291);
    freq.put("kel", 4377);
    freq.put("ked", 1397);
    freq.put("S", 49336);
    freq.put("omm", 13262);
    freq.put("ket", 3222);
    freq.put("kes", 1300);
    freq.put("ker", 9106);
    freq.put("øj ", 1036);
    freq.put("etr", 1299);
    freq.put("ets", 3278);
    freq.put("ett", 4721);
    freq.put("ety", 1926);
    freq.put("a\u030ard", 2059);
    freq.put("a\u030are", 1034);
    freq.put("tla", 1138);
    freq.put("eta", 3145);
    freq.put("tle", 1766);
    freq.put("ete", 8817);
    freq.put("tli", 4586);
    freq.put("eti", 2099);
    freq.put("ck", 5340);
    freq.put("ci", 7534);
    freq.put("ch", 11084);
    freq.put("co", 4730);
    freq.put(" In", 3319);
    freq.put("væ", 10057);
    freq.put("ot ", 1242);
    freq.put("ca", 5613);
    freq.put("rva", 1035);
    freq.put("ce", 13957);
    freq.put("uce", 1989);
    freq.put("Hel", 1134);
    freq.put("før", 6664);
    freq.put("cu", 1080);
    freq.put("ct", 2015);
    freq.put("a\u030and", 1467);
    freq.put("a\u030ane", 2057);
    freq.put("bbe", 1641);
    freq.put("tær", 1046);
    freq.put("ak", 8835);
    freq.put("oto", 1594);
    freq.put("c ", 1829);
    freq.put("ote", 1650);
    freq.put("lge", 2455);
    freq.put("uns", 1753);
    freq.put("fød", 7830);
    freq.put("ott", 1354);
    freq.put(" A\u030ar", 1234);
    freq.put("And", 1120);
    freq.put("lli", 6167);
    freq.put("e\u0301", 2737);
    freq.put("edl", 1944);
    freq.put("rbr", 1012);
    freq.put("rbi", 1442);
    freq.put("rbe", 2916);
    freq.put("rba", 1156);
    freq.put("yst", 3197);
    freq.put("va", 25040);
    freq.put(" Fr", 4772);
    freq.put("vd", 1809);
    freq.put("ve", 64168);
    freq.put("vi", 25451);
    freq.put("vn", 10855);
    freq.put("vo", 8670);
    freq.put(" Fa", 2149);
    freq.put("avn", 8812);
    freq.put("vs", 4402);
    freq.put(" Fe", 1132);
    freq.put("avi", 1508);
    freq.put(" Fi", 2339);
    freq.put("ave", 5203);
    freq.put(" Fl", 1645);
    freq.put(" Fo", 3830);
    freq.put("io ", 1215);
    freq.put("of ", 2459);
    freq.put("pis", 1494);
    freq.put("edr", 1723);
    freq.put("dam", 1233);
    freq.put("sæt", 2008);
    freq.put("une", 7027);
    freq.put("v ", 18910);
    freq.put("ion", 21894);
    freq.put("Øs", 1854);
    freq.put("iod", 1188);
    freq.put("av ", 1155);
    freq.put("off", 2072);
    freq.put(" Ty", 1554);
    freq.put("ofe", 1326);
    freq.put("i", 613022);
    freq.put(" Tr", 2230);
    freq.put(" To", 1975);
    freq.put(" Ti", 1411);
    freq.put(" Th", 4217);
    freq.put(" Te", 2130);
    freq.put(" Ta", 2881);
    freq.put("mpe", 2509);
    freq.put("sku", 2545);
    freq.put("Be", 3864);
    freq.put("ads", 1953);
    freq.put("skr", 6518);
    freq.put("Bl", 1436);
    freq.put("Bo", 3085);
    freq.put("sky", 1101);
    freq.put("Bi", 1743);
    freq.put("ske", 25508);
    freq.put("Bu", 1524);
    freq.put("ade", 6627);
    freq.put("ska", 8399);
    freq.put("Br", 3812);
    freq.put("skl", 1367);
    freq.put("sko", 3585);
    freq.put("adm", 1030);
    freq.put("ski", 4168);
    freq.put("By", 1617);
    freq.put("adi", 3138);
    freq.put("gt ", 9775);
    freq.put("nve", 1870);
    freq.put("T", 19455);
    freq.put("edt", 1636);
    freq.put("mhe", 1090);
    freq.put("sk ", 33968);
    freq.put("ad ", 3260);
    freq.put("vst", 2580);
    freq.put("ts ", 4804);
    freq.put("esv", 1081);
    freq.put("est", 19859);
    freq.put("ess", 3934);
    freq.put("esp", 2172);
    freq.put("nd ", 19511);
    freq.put("ese", 1937);
    freq.put("esl", 1065);
    freq.put("esk", 4356);
    freq.put("esi", 2775);
    freq.put("Un", 2388);
    freq.put("ndi", 3782);
    freq.put("ndk", 1968);
    freq.put("Sch", 1301);
    freq.put("ndo", 2080);
    freq.put(" ju", 2042);
    freq.put("ndb", 3975);
    freq.put("nde", 48861);
    freq.put(" jo", 1235);
    freq.put("kri", 8221);
    freq.put("kro", 1365);
    freq.put("es ", 24995);
    freq.put("nds", 9100);
    freq.put("kra", 3109);
    freq.put(" ja", 1664);
    freq.put("ndt", 10291);
    freq.put("kre", 5594);
    freq.put("De ", 1771);
    freq.put("h ", 6139);
    freq.put("van", 4077);
    freq.put("val", 2588);
    freq.put("hæ", 2028);
    freq.put("yre", 2022);
    freq.put("var", 14654);
    freq.put("na\u030ar", 1017);
    freq.put("Amt", 2376);
    freq.put("vat", 1120);
    freq.put("hy", 1292);
    freq.put("eal", 1397);
    freq.put("bur", 1375);
    freq.put("Det", 5562);
    freq.put("ht", 1466);
    freq.put("hu", 6980);
    freq.put("hj", 3040);
    freq.put("hi", 7688);
    freq.put("bun", 1225);
    freq.put("ho", 15697);
    freq.put("Den", 6802);
    freq.put("bum", 1745);
    freq.put("ha", 30491);
    freq.put("eat", 1418);
    freq.put("he", 22182);
    freq.put("yr ", 1010);
    freq.put("dmi", 1103);
    freq.put("j", 42561);
    freq.put("pil", 7538);
    freq.put("int", 3500);
    freq.put("mæn", 1058);
    freq.put("ins", 7738);
    freq.put("lm ", 3777);
    freq.put("mær", 1139);
    freq.put("ub ", 1257);
    freq.put("ini", 3271);
    freq.put("ink", 1131);
    freq.put("ind", 23824);
    freq.put("ine", 6155);
    freq.put("ing", 36509);
    freq.put("ina", 3988);
    freq.put("ta\u030ar", 2373);
    freq.put(" Un", 2381);
    freq.put("or ", 31324);
    freq.put("gav", 1126);
    freq.put(" øs", 2023);
    freq.put("hø", 4198);
    freq.put("sva", 1612);
    freq.put("gar", 1035);
    freq.put("U", 7743);
    freq.put("ubb", 1133);
    freq.put("ubl", 1141);
    freq.put("in ", 7601);
    freq.put("Mar", 2635);
    freq.put("ha\u030a", 1642);
    freq.put("eol", 1033);
    freq.put("eor", 1469);
    freq.put("o ", 13391);
  }
  
}

