package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class CY extends CLangProfile {
  private static final String name = "cy";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public CY() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 3639934;
    n_words[1] = 4414620;
    n_words[2] = 3548300;

    freq.put("y\u0302n ", 163);
    freq.put("Yn ", 880);
    freq.put("Yng", 84);
    freq.put("Yny", 1064);
    freq.put(" y ", 23704);
    freq.put("Wla", 90);
    freq.put(" ym", 5719);
    freq.put(" yn", 41808);
    freq.put("k", 5358);
    freq.put(" yc", 300);
    freq.put(" yd", 4387);
    freq.put(" yr", 12153);
    freq.put(" ys", 1828);
    freq.put(" yw", 15955);
    freq.put("dne", 151);
    freq.put("dna", 932);
    freq.put("dno", 132);
    freq.put("aur", 199);
    freq.put("Le", 1967);
    freq.put("La", 1295);
    freq.put("Lo", 2189);
    freq.put("Ll", 8526);
    freq.put("Li", 730);
    freq.put("Lw", 47);
    freq.put("Lu", 321);
    freq.put("Ly", 372);
    freq.put("hof", 49);
    freq.put("hog", 250);
    freq.put("hod", 477);
    freq.put("hoe", 1138);
    freq.put("hob", 365);
    freq.put("hoc", 66);
    freq.put("hon", 1206);
    freq.put("hoo", 77);
    freq.put("hol", 2341);
    freq.put("hom", 352);
    freq.put("\u03b1\u0301", 48);
    freq.put("hoi", 337);
    freq.put("how", 182);
    freq.put("hot", 44);
    freq.put("hou", 76);
    freq.put("hor", 447);
    freq.put("hos", 458);
    freq.put("hop", 78);
    freq.put("hoy", 58);
    freq.put("A", 20881);
    freq.put("\u0645", 201);
    freq.put("L ", 90);
    freq.put("\u03bf\u03c2 ", 78);
    freq.put("ho ", 75);
    freq.put("u\u0304", 152);
    freq.put(" V ", 40);
    freq.put("ro\u0302", 114);
    freq.put("fis", 223);
    freq.put("Hir", 98);
    freq.put("His", 66);
    freq.put("fiw", 182);
    freq.put("fit", 156);
    freq.put("fic", 52);
    freq.put("fia", 821);
    freq.put("uog", 87);
    freq.put("fig", 170);
    freq.put("ra\u0302", 57);
    freq.put("Hig", 55);
    freq.put("fih", 95);
    freq.put("ri\u0308", 40);
    freq.put("Hil", 184);
    freq.put("Him", 44);
    freq.put("Hin", 102);
    freq.put("re\u0308", 66);
    freq.put(" Va", 334);
    freq.put(" Ve", 204);
    freq.put(" Vi", 332);
    freq.put(" Vo", 86);
    freq.put("Hi ", 175);
    freq.put("fi ", 462);
    freq.put("mda", 65);
    freq.put("mdd", 657);
    freq.put("mde", 487);
    freq.put("mdr", 53);
    freq.put("rt", 9794);
    freq.put("ru", 5227);
    freq.put("rv", 239);
    freq.put("rw", 8072);
    freq.put("rp", 904);
    freq.put("rq", 40);
    freq.put("rr", 3139);
    freq.put("rs", 2573);
    freq.put("dge", 156);
    freq.put("ry", 10076);
    freq.put("rz", 64);
    freq.put("rd", 11710);
    freq.put("re", 22722);
    freq.put("rf", 5415);
    freq.put("rg", 2743);
    freq.put("ra", 23899);
    freq.put("rb", 1538);
    freq.put("rc", 3476);
    freq.put("rl", 5238);
    freq.put("rm", 2771);
    freq.put("rn", 7321);
    freq.put("ro", 15586);
    freq.put("rh", 9744);
    freq.put("ri", 23922);
    freq.put("sma", 85);
    freq.put("rk", 493);
    freq.put("Egl", 261);
    freq.put("atg", 130);
    freq.put("ate", 809);
    freq.put("atb", 229);
    freq.put("atc", 82);
    freq.put("ata", 746);
    freq.put("ato", 500);
    freq.put("atm", 41);
    freq.put("ath", 1938);
    freq.put("ati", 760);
    freq.put("atw", 81);
    freq.put("att", 185);
    freq.put("atu", 1218);
    freq.put("r ", 97506);
    freq.put("ats", 96);
    freq.put("ds ", 246);
    freq.put("aty", 152);
    freq.put("Swi", 176);
    freq.put("Dui", 91);
    freq.put("Dul", 102);
    freq.put("Dun", 80);
    freq.put("Swa", 46);
    freq.put("Dub", 66);
    freq.put("Swe", 125);
    freq.put("Dug", 61);
    freq.put("Swy", 845);
    freq.put("Dur", 65);
    freq.put("Duw", 89);
    freq.put("Cef", 291);
    freq.put("xic", 123);
    freq.put("Cea", 48);
    freq.put("Cen", 423);
    freq.put("Cem", 52);
    freq.put("Cel", 239);
    freq.put("Cei", 925);
    freq.put("\u062e", 38);
    freq.put("Cer", 1421);
    freq.put("Du ", 131);
    freq.put("Ifa", 40);
    freq.put("i\u0301", 198);
    freq.put("e\u0301gi", 56);
    freq.put("Ass", 90);
    freq.put("rw\u0302", 459);
    freq.put("\u30a2", 100);
    freq.put("Ast", 95);
    freq.put("Ysb", 66);
    freq.put("Sou", 117);
    freq.put("Asi", 362);
    freq.put("lph", 58);
    freq.put("lpe", 48);
    freq.put("lpa", 73);
    freq.put("yf ", 458);
    freq.put("ly\u0302r", 43);
    freq.put("ly\u0302n", 132);
    freq.put("yfe", 2566);
    freq.put("yff", 1314);
    freq.put("yfa", 1668);
    freq.put("yfl", 563);
    freq.put("yfn", 833);
    freq.put("yfo", 259);
    freq.put("yfi", 251);
    freq.put("ne\u0301e", 69);
    freq.put("yfu", 361);
    freq.put("yfw", 48);
    freq.put("yfr", 2540);
    freq.put("new", 803);
    freq.put("X", 156);
    freq.put("yfy", 1325);
    freq.put("Riv", 41);
    freq.put("Ric", 257);
    freq.put("e\u0301pa", 346);
    freq.put("meg", 711);
    freq.put("wt ", 38);
    freq.put("iry", 54);
    freq.put("irr", 47);
    freq.put("irs", 63);
    freq.put("irt", 106);
    freq.put("irw", 755);
    freq.put("iri", 2683);
    freq.put("irk", 39);
    freq.put("irl", 116);
    freq.put("irn", 1040);
    freq.put("iro", 1087);
    freq.put("ira", 269);
    freq.put("irc", 70);
    freq.put("ird", 247);
    freq.put("ire", 717);
    freq.put("irf", 117);
    freq.put("irg", 231);
    freq.put("wty", 66);
    freq.put("wth", 52);
    freq.put("wto", 60);
    freq.put("ir ", 16769);
    freq.put("and", 2956);
    freq.put("la\u0302n", 38);
    freq.put("fra", 2027);
    freq.put("frg", 79);
    freq.put("fre", 1841);
    freq.put("frd", 59);
    freq.put("fri", 1485);
    freq.put("fro", 1336);
    freq.put("frw", 347);
    freq.put("fru", 72);
    freq.put("fry", 995);
    freq.put("pro", 331);
    freq.put("anh", 308);
    freq.put("fr ", 375);
    freq.put("BC ", 162);
    freq.put("BE ", 140);
    freq.put("bil", 108);
    freq.put("Dio", 56);
    freq.put("ne ", 2471);
    freq.put("e\u0302m ", 104);
    freq.put("dri", 671);
    freq.put("dhe", 140);
    freq.put("dha", 318);
    freq.put("bi\u0302", 58);
    freq.put("\u0441", 158);
    freq.put("bie", 42);
    freq.put("dro", 1676);
    freq.put("Nat", 1075);
    freq.put("tz ", 50);
    freq.put("bia", 315);
    freq.put("dh ", 410);
    freq.put("hai", 1115);
    freq.put("hak", 48);
    freq.put("hal", 1482);
    freq.put("ham", 591);
    freq.put("han", 7727);
    freq.put("hao", 141);
    freq.put("hab", 62);
    freq.put("hac", 101);
    freq.put("had", 434);
    freq.put("hae", 657);
    freq.put("haf", 786);
    freq.put("hag", 961);
    freq.put("hap", 50);
    freq.put("har", 2065);
    freq.put("has", 612);
    freq.put("hat", 129);
    freq.put("hau", 1360);
    freq.put("haw", 364);
    freq.put("wch", 1526);
    freq.put("ha ", 291);
    freq.put("ola", 1373);
    freq.put("olb", 704);
    freq.put("olc", 45);
    freq.put("old", 430);
    freq.put("ole", 1242);
    freq.put("olf", 383);
    freq.put("olg", 141);
    freq.put("olh", 134);
    freq.put("oli", 4195);
    freq.put("olk", 46);
    freq.put("oll", 572);
    freq.put("olm", 61);
    freq.put("olo", 538);
    freq.put("olt", 40);
    freq.put("olu", 128);
    freq.put("olw", 315);
    freq.put("Wys", 47);
    freq.put("fot", 51);
    freq.put("ump", 113);
    freq.put("for", 3487);
    freq.put("fos", 53);
    freq.put("fod", 2910);
    freq.put("foe", 238);
    freq.put("fog", 67);
    freq.put("uma", 120);
    freq.put("umb", 206);
    freq.put("fol", 717);
    freq.put("uml", 95);
    freq.put("fon", 2342);
    freq.put("\u03bf\u03c2", 78);
    freq.put("ol ", 19814);
    freq.put("o", 193011);
    freq.put("fo ", 353);
    freq.put("um ", 501);
    freq.put("mbl", 58);
    freq.put("soc", 64);
    freq.put("mbo", 281);
    freq.put("soe", 1016);
    freq.put("mbi", 109);
    freq.put("sog", 1454);
    freq.put("Sio\u0302", 76);
    freq.put("Fen", 103);
    freq.put("mbe", 242);
    freq.put("Fel", 228);
    freq.put("mba", 96);
    freq.put("Fei", 80);
    freq.put("sos", 82);
    freq.put("sor", 102);
    freq.put("Fer", 95);
    freq.put("mbu", 37);
    freq.put("mbr", 269);
    freq.put("so ", 95);
    freq.put("\u03c3", 58);
    freq.put("Fe ", 1539);
    freq.put("mb ", 111);
    freq.put("azi", 49);
    freq.put("aza", 106);
    freq.put("ee\u0308d", 39);
    freq.put("Sis", 59);
    freq.put("Sir", 1857);
    freq.put("Dwy", 227);
    freq.put("Sib", 37);
    freq.put("Sia", 245);
    freq.put("Sie", 50);
    freq.put("Sid", 94);
    freq.put("kha", 65);
    freq.put("Sio", 82);
    freq.put("Sin", 79);
    freq.put("Sim", 72);
    freq.put("Sil", 92);
    freq.put("o\u0300", 62);
    freq.put("\u0641", 45);
    freq.put("E", 9591);
    freq.put("\u30a2\u30a2", 78);
    freq.put("Idr", 57);
    freq.put("Idd", 114);
    freq.put("osy", 68);
    freq.put("oss", 202);
    freq.put("ost", 354);
    freq.put("osw", 61);
    freq.put("osi", 398);
    freq.put("osh", 69);
    freq.put("osl", 48);
    freq.put("oso", 1488);
    freq.put("osn", 40);
    freq.put("osa", 670);
    freq.put("Byd", 283);
    freq.put("osb", 238);
    freq.put("ose", 562);
    freq.put("osg", 209);
    freq.put("osf", 80);
    freq.put("ver", 485);
    freq.put("ves", 72);
    freq.put("ven", 296);
    freq.put("vel", 96);
    freq.put("Mo\u0302", 742);
    freq.put("os ", 1942);
    freq.put("Tat", 47);
    freq.put("Taw", 121);
    freq.put("Tar", 132);
    freq.put("Tay", 77);
    freq.put("Taf", 220);
    freq.put("ve ", 424);
    freq.put("Tac", 506);
    freq.put("Tal", 579);
    freq.put("Tam", 59);
    freq.put("Tan", 88);
    freq.put("Tai", 74);
    freq.put("M ", 130);
    freq.put("yd ", 10831);
    freq.put("ss ", 400);
    freq.put("ufa", 148);
    freq.put("ydn", 127);
    freq.put("ydo", 278);
    freq.put("ydl", 894);
    freq.put("Ma", 14605);
    freq.put("Mc", 91);
    freq.put("ydi", 506);
    freq.put("ydf", 99);
    freq.put("Mo", 2328);
    freq.put("yde", 440);
    freq.put("Mi", 742);
    freq.put("Mh", 722);
    freq.put("yda", 2864);
    freq.put("Mu", 488);
    freq.put("Mw", 171);
    freq.put("uff", 193);
    freq.put("Mr", 121);
    freq.put("ydw", 276);
    freq.put("Bow", 40);
    freq.put("My", 761);
    freq.put("ipe", 92);
    freq.put("ipi", 109);
    freq.put("ipl", 76);
    freq.put("ips", 45);
    freq.put("ipp", 108);
    freq.put("ipt", 130);
    freq.put("Bob", 38);
    freq.put("ygb", 169);
    freq.put("yga", 105);
    freq.put("Bod", 96);
    freq.put("ip ", 126);
    freq.put("ygw", 75);
    freq.put("ygu", 321);
    freq.put("se\u0302", 51);
    freq.put("se\u0301", 43);
    freq.put("si\u0308", 46);
    freq.put(" pr", 1508);
    freq.put("ST ", 48);
    freq.put("Whi", 104);
    freq.put("s ", 31741);
    freq.put(" px", 78);
    freq.put("i\u0302n ", 132);
    freq.put("sy", 11549);
    freq.put("ss", 1407);
    freq.put("sr", 218);
    freq.put("sp", 272);
    freq.put("sw", 1131);
    freq.put("dyn", 2076);
    freq.put("su", 1034);
    freq.put("st", 10674);
    freq.put("sk", 338);
    freq.put("si", 7703);
    freq.put("sh", 1353);
    freq.put("so", 5309);
    freq.put("sn", 4104);
    freq.put("sm", 342);
    freq.put("sl", 613);
    freq.put("sc", 590);
    freq.put("sb", 869);
    freq.put("sa", 4420);
    freq.put("sg", 5428);
    freq.put("sf", 301);
    freq.put("se", 6958);
    freq.put("sd", 421);
    freq.put("tty", 41);
    freq.put("tts", 49);
    freq.put("sse", 383);
    freq.put("tti", 111);
    freq.put("tth", 42);
    freq.put("tto", 97);
    freq.put("Rhw", 49);
    freq.put("ttl", 73);
    freq.put("tta", 92);
    freq.put("tte", 273);
    freq.put("Rhi", 208);
    freq.put(" ph", 1652);
    freq.put("Mhr", 108);
    freq.put("tt ", 218);
    freq.put("Jos", 121);
    freq.put("bly", 678);
    freq.put("blw", 152);
    freq.put("blo", 1344);
    freq.put("bli", 117);
    freq.put("ble", 366);
    freq.put("bla", 667);
    freq.put("Jon", 426);
    freq.put("a\u0302n ", 313);
    freq.put("bl ", 1207);
    freq.put("oni", 1332);
    freq.put("onn", 630);
    freq.put("ono", 1646);
    freq.put("onc", 97);
    freq.put("ona", 1663);
    freq.put("onf", 152);
    freq.put("ong", 675);
    freq.put("ond", 1690);
    freq.put("one", 971);
    freq.put("ony", 591);
    freq.put("ons", 312);
    freq.put("onw", 477);
    freq.put("ont", 1089);
    freq.put(" Zi", 43);
    freq.put(" Ze", 78);
    freq.put("on ", 11898);
    freq.put(" Za", 73);
    freq.put("sak", 39);
    freq.put("sai", 432);
    freq.put("san", 708);
    freq.put("sam", 242);
    freq.put("sal", 122);
    freq.put("sac", 80);
    freq.put("sab", 56);
    freq.put("saf", 1227);
    freq.put("sae", 126);
    freq.put("sad", 50);
    freq.put("say", 42);
    freq.put("sar", 175);
    freq.put("saw", 457);
    freq.put("sau", 254);
    freq.put("sat", 40);
    freq.put("zon", 65);
    freq.put("ax ", 61);
    freq.put("sa ", 271);
    freq.put("\u0627\u0646", 54);
    freq.put("\u0627\u0644", 222);
    freq.put("Cys", 83);
    freq.put("Cyr", 75);
    freq.put("Cyt", 157);
    freq.put("vid", 205);
    freq.put("Cyc", 57);
    freq.put("Cyf", 1040);
    freq.put("Cyd", 52);
    freq.put("Cyh", 146);
    freq.put("Cyn", 1224);
    freq.put("Cym", 4367);
    freq.put("Cyl", 131);
    freq.put("up", 276);
    freq.put("ur", 9114);
    freq.put("um", 1436);
    freq.put("Awy", 60);
    freq.put("Aws", 918);
    freq.put("wun", 41);
    freq.put("un", 9776);
    freq.put("ui", 873);
    freq.put("Awd", 150);
    freq.put("fir", 153);
    freq.put(" be", 2463);
    freq.put(" ba", 1485);
    freq.put(" bl", 1371);
    freq.put(" bo", 2899);
    freq.put(" bi", 247);
    freq.put(" bu", 556);
    freq.put("s", 97156);
    freq.put(" br", 2722);
    freq.put(" by", 2374);
    freq.put("\u0632", 53);
    freq.put("fid", 83);
    freq.put("fie", 361);
    freq.put("uoi", 80);
    freq.put("i\u0308o", 107);
    freq.put("fin", 1391);
    freq.put("i\u0308a", 463);
    freq.put("fio", 735);
    freq.put("fil", 1986);
    freq.put("uol", 447);
    freq.put("ive", 318);
    freq.put("iva", 70);
    freq.put("ivi", 57);
    freq.put("\u03b4", 38);
    freq.put("IR ", 39);
    freq.put("uic", 91);
    freq.put("I", 5301);
    freq.put(" gu", 50);
    freq.put("wpi", 70);
    freq.put("Mau", 68);
    freq.put("wpa", 41);
    freq.put("Owe", 132);
    freq.put("Owa", 159);
    freq.put("gdd", 63);
    freq.put("Mab", 124);
    freq.put("Mah", 50);
    freq.put("Myn", 603);
    freq.put("Man", 377);
    freq.put("Pe\u0302l", 41);
    freq.put("ddy", 2549);
    freq.put("ac ", 6256);
    freq.put("ddr", 255);
    freq.put("ddw", 3166);
    freq.put("ddu", 2078);
    freq.put("ddi", 10903);
    freq.put("ddh", 205);
    freq.put("ddo", 8493);
    freq.put("ddl", 174);
    freq.put("dda", 2729);
    freq.put("ddg", 83);
    freq.put("ddf", 808);
    freq.put("dde", 2964);
    freq.put("ez ", 93);
    freq.put("aca", 158);
    freq.put("ace", 317);
    freq.put("ack", 236);
    freq.put("aci", 176);
    freq.put("ach", 3246);
    freq.put("aco", 112);
    freq.put("acl", 41);
    freq.put("acs", 87);
    freq.put("acr", 47);
    freq.put("acu", 37);
    freq.put("act", 455);
    freq.put("dd ", 49936);
    freq.put("Nh", 168);
    freq.put("Ni", 590);
    freq.put("No", 968);
    freq.put("uil", 132);
    freq.put("Na", 1719);
    freq.put("Ne", 1732);
    freq.put("Ng", 1975);
    freq.put("Ny", 139);
    freq.put("\u0629 ", 125);
    freq.put("Nu", 77);
    freq.put("het", 177);
    freq.put("heu", 445);
    freq.put("hew", 93);
    freq.put("her", 1843);
    freq.put("hes", 532);
    freq.put("hey", 61);
    freq.put("hed", 1184);
    freq.put("hee", 57);
    freq.put("hef", 2098);
    freq.put("heg", 242);
    freq.put("hea", 360);
    freq.put("heb", 374);
    freq.put("hec", 90);
    freq.put("hel", 2523);
    freq.put("hem", 246);
    freq.put("hen", 1636);
    freq.put("heo", 518);
    freq.put("hei", 954);
    freq.put("N ", 179);
    freq.put("agh", 77);
    freq.put("he ", 1354);
    freq.put("a\u0302l ", 80);
    freq.put("aa", 163);
    freq.put("ac", 11287);
    freq.put("ab", 3228);
    freq.put("ae", 38165);
    freq.put("ad", 20781);
    freq.put("ag", 4220);
    freq.put("af", 10668);
    freq.put("Hon", 146);
    freq.put("ah", 1181);
    freq.put("Hol", 122);
    freq.put("aj", 129);
    freq.put("am", 10300);
    freq.put("al", 15639);
    freq.put("ao", 569);
    freq.put("an", 51341);
    freq.put("How", 58);
    freq.put("as", 12110);
    freq.put("Hou", 114);
    freq.put("Hor", 65);
    freq.put("at", 8544);
    freq.put("aw", 9171);
    freq.put("av", 851);
    freq.put("ay", 1012);
    freq.put("ax", 139);
    freq.put("az", 312);
    freq.put("uis", 142);
    freq.put("ddw\u0302", 75);
    freq.put("uir", 49);
    freq.put("a ", 51218);
    freq.put("at ", 1109);
    freq.put("uit", 55);
    freq.put("Fir", 87);
    freq.put("sco", 172);
    freq.put("sci", 60);
    freq.put("sch", 110);
    freq.put("sca", 115);
    freq.put("mni", 274);
    freq.put("Fie", 143);
    freq.put("Fin", 48);
    freq.put("mne", 46);
    freq.put("Fil", 43);
    freq.put("smo", 123);
    freq.put("tz", 134);
    freq.put("dso", 55);
    freq.put("tw", 874);
    freq.put("tt", 1060);
    freq.put("tu", 4774);
    freq.put("tr", 9852);
    freq.put("ts", 824);
    freq.put("tp", 42);
    freq.put("tn", 397);
    freq.put("to", 4656);
    freq.put("tl", 749);
    freq.put("tm", 136);
    freq.put("tk", 40);
    freq.put("th", 34123);
    freq.put("ti", 6270);
    freq.put("tf", 144);
    freq.put("tg", 191);
    freq.put("Eas", 62);
    freq.put("Ear", 39);
    freq.put("tb", 311);
    freq.put("tc", 225);
    freq.put("ta", 7641);
    freq.put("dsh", 71);
    freq.put("sme", 38);
    freq.put(" dw\u0302", 166);
    freq.put("t ", 12191);
    freq.put("Sma", 50);
    freq.put("ti\u0302", 45);
    freq.put("te\u0301", 52);
    freq.put("ta\u0302", 87);
    freq.put("vic", 81);
    freq.put("via", 62);
    freq.put("Aug", 57);
    freq.put("vie", 209);
    freq.put("vin", 110);
    freq.put("vil", 101);
    freq.put("vis", 116);
    freq.put("Aur", 46);
    freq.put("viu", 39);
    freq.put("ty\u0302", 48);
    freq.put(" d ", 109);
    freq.put(" do", 719);
    freq.put("kle", 37);
    freq.put("kla", 44);
    freq.put(" di", 3478);
    freq.put(" de", 5281);
    freq.put(" dd", 7964);
    freq.put(" da", 4373);
    freq.put(" dy", 2712);
    freq.put(" dw", 1202);
    freq.put(" du", 387);
    freq.put(" dr", 3411);
    freq.put("atr", 340);
    freq.put("ti\u0302m", 43);
    freq.put(" di\u0302", 55);
    freq.put(" I\u0302l", 39);
    freq.put(" de\u0301", 347);
    freq.put("ito", 86);
    freq.put("itl", 241);
    freq.put("ith", 9523);
    freq.put("iti", 268);
    freq.put("ite", 660);
    freq.put("itc", 77);
    freq.put("ita", 465);
    freq.put("itz", 75);
    freq.put("ity", 126);
    freq.put("itt", 152);
    freq.put("itu", 48);
    freq.put("itr", 65);
    freq.put("wrg", 40);
    freq.put("wrd", 645);
    freq.put("swo", 44);
    freq.put("wrc", 168);
    freq.put("wra", 424);
    freq.put("wrn", 594);
    freq.put("wro", 897);
    freq.put("A\u0300i", 440);
    freq.put("wri", 768);
    freq.put("wrt", 1573);
    freq.put("wrs", 66);
    freq.put("wrp", 460);
    freq.put("wry", 875);
    freq.put("it ", 213);
    freq.put("wr ", 5367);
    freq.put(" A ", 750);
    freq.put("gfy", 612);
    freq.put("gfa", 38);
    freq.put("gfe", 149);
    freq.put("\u0627\u0654", 38);
    freq.put("fta", 48);
    freq.put(" Ab", 1334);
    freq.put(" Ac", 625);
    freq.put(" Ad", 573);
    freq.put(" Ae", 323);
    freq.put(" Af", 1863);
    freq.put(" Ag", 155);
    freq.put(" Ai", 814);
    freq.put(" Al", 5312);
    freq.put(" Am", 1811);
    freq.put(" An", 1296);
    freq.put(" Ao", 85);
    freq.put(" Ap", 230);
    freq.put(" Aq", 45);
    freq.put(" Ar", 2746);
    freq.put(" As", 660);
    freq.put(" At", 329);
    freq.put(" Au", 228);
    freq.put(" Av", 92);
    freq.put(" Aw", 1144);
    freq.put(" Ay", 58);
    freq.put(" Az", 66);
    freq.put("ft ", 323);
    freq.put("w", 133473);
    freq.put("Fra", 319);
    freq.put("Fre", 191);
    freq.put("uel", 100);
    freq.put("\u043e\u0432", 62);
    freq.put("Fro", 64);
    freq.put("Fry", 84);
    freq.put("dfu", 76);
    freq.put("dfw", 52);
    freq.put("dfr", 146);
    freq.put("uee", 83);
    freq.put("dfo", 480);
    freq.put("dfe", 259);
    freq.put("\u043a", 145);
    freq.put("dfa", 511);
    freq.put("\u3042", 42);
    freq.put("df ", 92);
    freq.put("bha", 140);
    freq.put("Is ", 89);
    freq.put("ex ", 115);
    freq.put("hgy", 60);
    freq.put("Bla", 500);
    freq.put("hgr", 144);
    freq.put("ues", 64);
    freq.put("hga", 94);
    freq.put("Mo\u0302r", 383);
    freq.put("Isr", 118);
    freq.put("M", 24164);
    freq.put("Mo\u0302n", 358);
    freq.put("Isl", 207);
    freq.put("Isa", 101);
    freq.put("Ise", 233);
    freq.put("a\u0302", 2559);
    freq.put("exa", 133);
    freq.put("exi", 125);
    freq.put("y\u0302", 505);
    freq.put("gyr", 399);
    freq.put("Hai", 43);
    freq.put("ugi", 102);
    freq.put("ugh", 287);
    freq.put("Hal", 109);
    freq.put("Ham", 150);
    freq.put("Han", 221);
    freq.put("ugl", 146);
    freq.put("uga", 343);
    freq.put("Had", 42);
    freq.put("Hae", 300);
    freq.put("Haf", 198);
    freq.put("Har", 406);
    freq.put("Hau", 114);
    freq.put("ugu", 87);
    freq.put("Haw", 74);
    freq.put("Gyf", 142);
    freq.put("Gyd", 159);
    freq.put("Gyn", 163);
    freq.put("Gym", 1100);
    freq.put("rf ", 340);
    freq.put("Gyr", 41);
    freq.put("\u093e", 57);
    freq.put("ug ", 773);
    freq.put("ty\u0302 ", 48);
    freq.put("crw", 405);
    freq.put("cru", 57);
    freq.put("rfy", 869);
    freq.put("cry", 237);
    freq.put("rfb", 45);
    freq.put("rfa", 309);
    freq.put("cra", 272);
    freq.put("rff", 1405);
    freq.put("rfe", 703);
    freq.put("cre", 794);
    freq.put("rfi", 631);
    freq.put("cri", 112);
    freq.put("rfo", 973);
    freq.put("cro", 299);
    freq.put("rfl", 49);
    freq.put("Fou", 44);
    freq.put("set", 136);
    freq.put("ses", 213);
    freq.put("ser", 1507);
    freq.put("For", 307);
    freq.put("sep", 89);
    freq.put("sey", 83);
    freq.put("sex", 75);
    freq.put("seg", 442);
    freq.put("Foe", 122);
    freq.put("see", 37);
    freq.put("sed", 256);
    freq.put("sec", 40);
    freq.put("seb", 56);
    freq.put("sen", 717);
    freq.put("sem", 62);
    freq.put("sel", 456);
    freq.put("sei", 619);
    freq.put("ue ", 164);
    freq.put("se ", 534);
    freq.put("lex", 112);
    freq.put("ml ", 374);
    freq.put("xas", 52);
    freq.put("tiv", 155);
    freq.put("xan", 82);
    freq.put("nri", 910);
    freq.put("nrh", 586);
    freq.put("nro", 38);
    freq.put("nra", 250);
    freq.put("nre", 48);
    freq.put("nry", 402);
    freq.put("nrw", 38);
    freq.put("mla", 506);
    freq.put("ctr", 127);
    freq.put("mle", 90);
    freq.put("Oli", 119);
    freq.put("mlw", 137);
    freq.put("mlu", 98);
    freq.put("u\u0300", 63);
    freq.put("Oly", 162);
    freq.put("mly", 764);
    freq.put("von", 93);
    freq.put("cte", 79);
    freq.put("amg", 269);
    freq.put("Soc", 69);
    freq.put(" fr", 934);
    freq.put(" fu", 348);
    freq.put(" fw", 1451);
    freq.put("Sof", 96);
    freq.put(" fy", 1075);
    freq.put("Som", 57);
    freq.put("Sol", 60);
    freq.put("Son", 51);
    freq.put(" fa", 2334);
    freq.put(" fe", 5001);
    freq.put(" ff", 4585);
    freq.put(" fi", 507);
    freq.put(" fl", 1325);
    freq.put(" fo", 1170);
    freq.put("O ", 337);
    freq.put("On", 113);
    freq.put("Ol", 406);
    freq.put("Oh", 42);
    freq.put("Og", 270);
    freq.put("Of", 86);
    freq.put("Oe", 2267);
    freq.put("Od", 68);
    freq.put("Oc", 104);
    freq.put("Ob", 54);
    freq.put("Oa", 53);
    freq.put("tsa", 45);
    freq.put("Oy", 53);
    freq.put("Ow", 296);
    freq.put("Ou", 45);
    freq.put("Ot", 47);
    freq.put("Os", 135);
    freq.put("Or", 342);
    freq.put("Op", 59);
    freq.put("d", 297794);
    freq.put(" \u4e09", 37);
    freq.put("Kha", 59);
    freq.put("IV ", 48);
    freq.put("pe\u0302l", 157);
    freq.put("Ven", 60);
    freq.put("u\u0304 ", 77);
    freq.put("bd", 48);
    freq.put("be", 6777);
    freq.put("ba", 8027);
    freq.put("bb", 144);
    freq.put("bl", 4571);
    freq.put("bn", 48);
    freq.put("bo", 4368);
    freq.put("bh", 358);
    freq.put("bi", 1556);
    freq.put("bu", 1226);
    freq.put("bw", 1267);
    freq.put("br", 4597);
    freq.put("bs", 99);
    freq.put("by", 5500);
    freq.put("Fu", 118);
    freq.put("Fw", 115);
    freq.put("Fy", 369);
    freq.put(" C ", 232);
    freq.put("ci ", 202);
    freq.put("SJ ", 70);
    freq.put("u ", 38069);
    freq.put("Fe", 2231);
    freq.put(" Ch", 2756);
    freq.put(" Ci", 275);
    freq.put(" Cn", 42);
    freq.put(" Co", 2656);
    freq.put(" Cl", 933);
    freq.put(" Ca", 7220);
    freq.put(" Ce", 3495);
    freq.put(" Cy", 7369);
    freq.put("Fi", 488);
    freq.put(" Cr", 1937);
    freq.put(" Cw", 584);
    freq.put(" Cu", 270);
    freq.put("cia", 409);
    freq.put("uy", 100);
    freq.put("ux", 122);
    freq.put("cie", 97);
    freq.put("uz", 117);
    freq.put("ut", 1125);
    freq.put("uw", 1502);
    freq.put("uv", 98);
    freq.put("cio", 66);
    freq.put("cin", 98);
    freq.put("us", 3544);
    freq.put("cil", 222);
    freq.put("cis", 143);
    freq.put("ul", 2825);
    freq.put("uo", 2173);
    freq.put("cip", 70);
    freq.put("ciw", 72);
    freq.put("uh", 77);
    freq.put("uk", 137);
    freq.put("cit", 38);
    freq.put("ue", 842);
    freq.put("ud", 3346);
    freq.put("ug", 2077);
    freq.put("uf", 864);
    freq.put("ua", 3026);
    freq.put("uc", 1723);
    freq.put("ub", 587);
    freq.put("ag ", 1062);
    freq.put(" Ca\u0302", 42);
    freq.put(" Co\u0302", 47);
    freq.put("ago", 1155);
    freq.put("agn", 135);
    freq.put("agl", 348);
    freq.put("agi", 70);
    freq.put("le\u0302n", 948);
    freq.put("agg", 47);
    freq.put("agf", 578);
    freq.put("age", 183);
    freq.put("aga", 251);
    freq.put("agw", 108);
    freq.put("agu", 99);
    freq.put("Jim", 37);
    freq.put("ev ", 37);
    freq.put("tr ", 1173);
    freq.put("b ", 3328);
    freq.put("tri", 1062);
    freq.put("evi", 156);
    freq.put("tro", 965);
    freq.put("tra", 1795);
    freq.put("eva", 81);
    freq.put("tre", 3761);
    freq.put("eve", 268);
    freq.put("try", 340);
    freq.put("tru", 77);
    freq.put("trw", 624);
    freq.put("le ", 2080);
    freq.put("ody", 243);
    freq.put("uen", 92);
    freq.put("Blu", 41);
    freq.put("ued", 160);
    freq.put("odr", 901);
    freq.put("odu", 44);
    freq.put("odw", 617);
    freq.put("odi", 1787);
    freq.put("Blo", 83);
    freq.put("odl", 80);
    freq.put("odo", 830);
    freq.put("Ble", 43);
    freq.put("oda", 1191);
    freq.put("odd", 3893);
    freq.put("ode", 503);
    freq.put("odf", 76);
    freq.put("uer", 86);
    freq.put("ct ", 59);
    freq.put("rd ", 1148);
    freq.put("lea", 202);
    freq.put("leb", 37);
    freq.put("lec", 496);
    freq.put("led", 5984);
    freq.put("lee", 51);
    freq.put("lef", 740);
    freq.put("leg", 1759);
    freq.put("lei", 2402);
    freq.put("lem", 257);
    freq.put("len", 2864);
    freq.put("leo", 2599);
    freq.put("ler", 483);
    freq.put("les", 787);
    freq.put("let", 455);
    freq.put("leu", 338);
    freq.put("lev", 58);
    freq.put("lew", 3221);
    freq.put("od ", 6442);
    freq.put("ley", 287);
    freq.put("rdu", 122);
    freq.put("ctu", 101);
    freq.put("rdw", 84);
    freq.put("rds", 156);
    freq.put("rdr", 70);
    freq.put("rdy", 486);
    freq.put("rde", 771);
    freq.put("rdd", 6359);
    freq.put("rda", 1352);
    freq.put("cta", 132);
    freq.put("rdo", 260);
    freq.put("cto", 775);
    freq.put("rdi", 824);
    freq.put("cti", 292);
    freq.put("sgy", 278);
    freq.put("sgr", 1098);
    freq.put("sgu", 121);
    freq.put("sgw", 280);
    freq.put("sgi", 173);
    freq.put("sgl", 367);
    freq.put("sgo", 1819);
    freq.put("sga", 258);
    freq.put("sge", 250);
    freq.put("sgf", 73);
    freq.put("\u043e", 284);
    freq.put("sg ", 658);
    freq.put("\u03bc", 79);
    freq.put("o\u0302", 3067);
    freq.put("Q", 331);
    freq.put("Ym", 722);
    freq.put("æ", 50);
    freq.put(" h ", 491);
    freq.put("e\u0302\u0309", 69);
    freq.put(" hy", 3013);
    freq.put("afw", 88);
    freq.put("San", 631);
    freq.put("Sam", 100);
    freq.put("Sal", 155);
    freq.put("Sac", 72);
    freq.put(" hw", 571);
    freq.put("Saf", 103);
    freq.put(" hu", 549);
    freq.put("Sad", 43);
    freq.put(" hi", 741);
    freq.put(" ho", 683);
    freq.put("Sar", 112);
    freq.put(" ha", 2143);
    freq.put(" he", 3350);
    freq.put("Sat", 44);
    freq.put("\u0438\u0447 ", 40);
    freq.put("\u094d", 49);
    freq.put("iha", 170);
    freq.put("y\u0302r ", 76);
    freq.put(" E ", 42);
    freq.put("e\u0301ne\u0301", 40);
    freq.put("ck ", 502);
    freq.put(" El", 634);
    freq.put(" Em", 230);
    freq.put(" En", 1110);
    freq.put(" Ei", 1604);
    freq.put(" Ed", 412);
    freq.put(" Ef", 1230);
    freq.put(" Eg", 302);
    freq.put(" Ea", 167);
    freq.put(" Eb", 590);
    freq.put(" Ec", 68);
    freq.put(" Ex", 43);
    freq.put(" Et", 355);
    freq.put(" Eu", 257);
    freq.put(" Ev", 183);
    freq.put(" Ew", 723);
    freq.put(" Ep", 63);
    freq.put(" Er", 1072);
    freq.put(" Es", 277);
    freq.put("cke", 114);
    freq.put("ckl", 44);
    freq.put("cki", 49);
    freq.put("cks", 58);
    freq.put("Pe\u0302", 44);
    freq.put("dbw", 38);
    freq.put("jan", 42);
    freq.put("ae ", 13921);
    freq.put("Ty\u0302 ", 84);
    freq.put("aes", 3677);
    freq.put("aer", 2715);
    freq.put("aet", 9257);
    freq.put("aew", 200);
    freq.put("h", 111415);
    freq.put("gbi", 171);
    freq.put("aea", 937);
    freq.put("aed", 256);
    freq.put("aeg", 1463);
    freq.put("aem", 216);
    freq.put("lo\u0302n", 57);
    freq.put("aeo", 298);
    freq.put("aen", 2354);
    freq.put("Pr", 1739);
    freq.put("Ddy", 46);
    freq.put("Pw", 190);
    freq.put("Pu", 305);
    freq.put("Py", 119);
    freq.put("Ddw", 51);
    freq.put("C", 28561);
    freq.put("Ddu", 131);
    freq.put("Ddi", 405);
    freq.put("Pa", 1592);
    freq.put("Pe", 3405);
    freq.put("Dda", 107);
    freq.put("Pi", 467);
    freq.put("Po", 1922);
    freq.put("Dde", 168);
    freq.put("Iwe", 600);
    freq.put("\u0627", 513);
    freq.put("o\u0302r ", 759);
    freq.put("llw", 877);
    freq.put("et ", 700);
    freq.put("tl ", 156);
    freq.put("eul", 766);
    freq.put("ld", 3291);
    freq.put("P ", 102);
    freq.put("eun", 167);
    freq.put("etr", 1100);
    freq.put("ets", 101);
    freq.put("etw", 145);
    freq.put("ett", 277);
    freq.put("etu", 42);
    freq.put("la", 22265);
    freq.put("eue", 51);
    freq.put("tla", 185);
    freq.put("eta", 251);
    freq.put("tle", 205);
    freq.put("ete", 326);
    freq.put("eth", 10791);
    freq.put("eti", 221);
    freq.put("etn", 119);
    freq.put("ll", 25680);
    freq.put("tll", 46);
    freq.put("ck", 930);
    freq.put("ci", 1587);
    freq.put("ch", 26374);
    freq.put("co", 5637);
    freq.put("cn", 51);
    freq.put("Her", 204);
    freq.put("Hes", 38);
    freq.put("cc", 166);
    freq.put("\u0432\u0438", 49);
    freq.put("lg ", 94);
    freq.put("ce", 3041);
    freq.put("Hed", 82);
    freq.put("cy", 8823);
    freq.put("lh", 333);
    freq.put("Heb", 135);
    freq.put("cs", 549);
    freq.put("cr", 2262);
    freq.put("Hen", 857);
    freq.put("li", 13502);
    freq.put("cw", 614);
    freq.put("Hei", 49);
    freq.put("cu", 488);
    freq.put("ct", 1580);
    freq.put("Ger", 213);
    freq.put("Gea", 46);
    freq.put("euy", 40);
    freq.put("Gei", 1020);
    freq.put("Geo", 264);
    freq.put("Gen", 357);
    freq.put("Gem", 88);
    freq.put("Gel", 559);
    freq.put("lgo", 53);
    freq.put("lga", 220);
    freq.put("unr", 208);
    freq.put("lge", 216);
    freq.put("lgy", 51);
    freq.put("lgw", 38);
    freq.put("rby", 562);
    freq.put("rbw", 42);
    freq.put("rbu", 39);
    freq.put("rbr", 42);
    freq.put("rbo", 108);
    freq.put("rbi", 70);
    freq.put("rbh", 58);
    freq.put("rbe", 489);
    freq.put("ly", 9229);
    freq.put("rba", 80);
    freq.put("va", 690);
    freq.put("ve", 1501);
    freq.put("vi", 1082);
    freq.put("ph ", 99);
    freq.put("vo", 243);
    freq.put("vr", 48);
    freq.put("vu", 50);
    freq.put("of ", 754);
    freq.put("ap", 1859);
    freq.put("una", 363);
    freq.put("unc", 85);
    freq.put("v ", 135);
    freq.put("phi", 110);
    freq.put("pho", 428);
    freq.put("unf", 97);
    freq.put("phl", 179);
    freq.put("pha", 149);
    freq.put("phe", 446);
    freq.put("phy", 51);
    freq.put("phr", 313);
    freq.put("phw", 418);
    freq.put("phu", 46);
    freq.put("ofa", 165);
    freq.put("off", 461);
    freq.put("ofe", 578);
    freq.put("ofi", 339);
    freq.put("ofn", 179);
    freq.put("ofo", 135);
    freq.put("ofr", 130);
    freq.put("unn", 56);
    freq.put("wec", 102);
    freq.put("web", 67);
    freq.put("weg", 153);
    freq.put("wef", 1122);
    freq.put("wed", 6219);
    freq.put("wei", 2145);
    freq.put("wen", 943);
    freq.put("wel", 1143);
    freq.put("wes", 112);
    freq.put("wer", 1889);
    freq.put("Sai", 1382);
    freq.put("nve", 125);
    freq.put("Sah", 39);
    freq.put("mho", 82);
    freq.put("mhl", 147);
    freq.put("we ", 503);
    freq.put("mhe", 231);
    freq.put("mha", 708);
    freq.put("mhw", 50);
    freq.put("Sae", 3187);
    freq.put("\u043b\u044c", 41);
    freq.put("\u4e4b", 120);
    freq.put("Sco", 119);
    freq.put("Sci", 39);
    freq.put("Sch", 160);
    freq.put("Sca", 61);
    freq.put("Sau", 57);
    freq.put("ine\u0308", 53);
    freq.put("yrh", 40);
    freq.put("yri", 760);
    freq.put("yrn", 1071);
    freq.put("yro", 57);
    freq.put("yra", 2367);
    freq.put("yrc", 853);
    freq.put("yrd", 987);
    freq.put("yre", 633);
    freq.put("yrf", 123);
    freq.put("yry", 38);
    freq.put("yrr", 204);
    freq.put("yrs", 46);
    freq.put("yrw", 139);
    freq.put("yr ", 15016);
    freq.put("iny", 618);
    freq.put("int", 968);
    freq.put("inu", 82);
    freq.put("inw", 155);
    freq.put("ins", 292);
    freq.put("inl", 130);
    freq.put("inm", 467);
    freq.put("inn", 805);
    freq.put("ino", 1100);
    freq.put("ini", 3171);
    freq.put("ink", 95);
    freq.put("ind", 417);
    freq.put("ine", 1198);
    freq.put("inf", 90);
    freq.put("ing", 1306);
    freq.put("ina", 4133);
    freq.put("inb", 394);
    freq.put("inc", 980);
    freq.put("\u4e21", 62);
    freq.put("eo ", 144);
    freq.put("DA ", 97);
    freq.put("U", 5682);
    freq.put("uos", 1109);
    freq.put("in ", 13332);
    freq.put("eog", 53);
    freq.put("eoe", 80);
    freq.put("eod", 76);
    freq.put("e\u0302", 1481);
    freq.put("eon", 268);
    freq.put("eol", 3405);
    freq.put("eor", 285);
    freq.put("eop", 55);
    freq.put("Wre", 214);
    freq.put("SN ", 103);
    freq.put("le\u0302", 981);
    freq.put("cm ", 41);
    freq.put("cwm", 218);
    freq.put("ald", 305);
    freq.put("cwl", 44);
    freq.put(" Gw", 5007);
    freq.put(" Gu", 311);
    freq.put(" Gr", 2427);
    freq.put("Tun", 253);
    freq.put(" Gy", 1682);
    freq.put(" Ge", 2633);
    freq.put(" Ga", 3309);
    freq.put(" Go", 2436);
    freq.put(" Gl", 1637);
    freq.put(" Gh", 165);
    freq.put(" Gi", 263);
    freq.put("ref", 6655);
    freq.put("a\u0304", 208);
    freq.put("alt", 188);
    freq.put("uw ", 191);
    freq.put("gl ", 325);
    freq.put("\u062f", 148);
    freq.put("ak ", 74);
    freq.put("A\u0300", 445);
    freq.put("e\u0300r", 41);
    freq.put("e\u0300s", 40);
    freq.put("Fr", 789);
    freq.put("sle", 133);
    freq.put("gli", 289);
    freq.put("glo", 190);
    freq.put("gla", 882);
    freq.put("lo\u0308y", 126);
    freq.put("\u30a2\u30a2\u30a2", 57);
    freq.put("gly", 189);
    freq.put("aki", 95);
    freq.put("akh", 61);
    freq.put("ako", 53);
    freq.put("aka", 125);
    freq.put("glu", 132);
    freq.put("ake", 153);
    freq.put("glw", 795);
    freq.put("Jer", 98);
    freq.put("bry", 598);
    freq.put("brw", 83);
    freq.put("bro", 531);
    freq.put("Jea", 66);
    freq.put("bri", 1804);
    freq.put("bre", 653);
    freq.put("Jen", 67);
    freq.put("bra", 416);
    freq.put("o\u0302l ", 1565);
    freq.put("er ", 10194);
    freq.put("nka", 58);
    freq.put(" Gw\u0302", 111);
    freq.put("iu", 514);
    freq.put("br ", 444);
    freq.put("ert", 3212);
    freq.put("ii", 107);
    freq.put("erv", 60);
    freq.put("erw", 570);
    freq.put("erp", 114);
    freq.put("err", 1317);
    freq.put("ers", 1524);
    freq.put("ery", 875);
    freq.put("erd", 1936);
    freq.put("ere", 2066);
    freq.put("erf", 1312);
    freq.put("erg", 452);
    freq.put("tna", 134);
    freq.put("era", 2569);
    freq.put("erb", 725);
    freq.put("erc", 671);
    freq.put("erl", 567);
    freq.put("erm", 1779);
    freq.put("ern", 900);
    freq.put("ero", 902);
    freq.put("erh", 118);
    freq.put("eri", 3199);
    freq.put("erk", 43);
    freq.put("Aba", 80);
    freq.put("Abe", 1076);
    freq.put("uar", 137);
    freq.put("la ", 957);
    freq.put("uat", 48);
    freq.put("uai", 74);
    freq.put("Abr", 43);
    freq.put("ual", 68);
    freq.put("uan", 197);
    freq.put("uae", 87);
    freq.put("uad", 147);
    freq.put("uag", 90);
    freq.put("ib", 1579);
    freq.put("i\u0304", 83);
    freq.put("lal", 87);
    freq.put("lam", 265);
    freq.put("lan", 5318);
    freq.put("lah", 70);
    freq.put("lai", 3136);
    freq.put("lad", 4285);
    freq.put("lae", 2342);
    freq.put("laf", 737);
    freq.put("lag", 63);
    freq.put("lab", 92);
    freq.put("lac", 485);
    freq.put("lay", 112);
    freq.put("lat", 184);
    freq.put("lau", 895);
    freq.put("lav", 69);
    freq.put("fau", 218);
    freq.put("lap", 59);
    freq.put("lar", 293);
    freq.put("las", 992);
    freq.put("zer", 50);
    freq.put("uwc", 992);
    freq.put("ze ", 49);
    freq.put("yon", 159);
    freq.put("Bha", 56);
    freq.put("uoe", 102);
    freq.put("Bhe", 84);
    freq.put("l", 181438);
    freq.put("Bhr", 46);
    freq.put("Bhu", 62);
    freq.put("\u0301", 115);
    freq.put("uod", 142);
    freq.put("nt ", 5305);
    freq.put("wga", 86);
    freq.put("di\u0302m", 54);
    freq.put("wgr", 102);
    freq.put("nty", 316);
    freq.put("nts", 154);
    freq.put("ntr", 2835);
    freq.put("ntu", 146);
    freq.put("ntw", 74);
    freq.put("nti", 615);
    freq.put("nth", 322);
    freq.put("ntl", 64);
    freq.put("nto", 464);
    freq.put("nta", 1485);
    freq.put("nte", 453);
    freq.put("ntf", 38);
    freq.put("wg ", 400);
    freq.put("tel", 1208);
    freq.put("tea", 52);
    freq.put("uon", 143);
    freq.put(" le", 1343);
    freq.put("B", 12687);
    freq.put(" la", 1153);
    freq.put(" lo", 202);
    freq.put(" ll", 7015);
    freq.put(" li", 214);
    freq.put(" lw", 161);
    freq.put(" lu", 101);
    freq.put("tef", 162);
    freq.put(" ly", 443);
    freq.put("Ser", 173);
    freq.put("tsi", 56);
    freq.put("Sef", 291);
    freq.put("Sea", 62);
    freq.put("Vi", 334);
    freq.put("Sen", 310);
    freq.put("Sem", 38);
    freq.put("Sel", 127);
    freq.put("Sei", 620);
    freq.put("ter", 2833);
    freq.put("ypr", 60);
    freq.put("teu", 225);
    freq.put("tev", 62);
    freq.put("ype", 40);
    freq.put("\u03c0", 56);
    freq.put("Qu", 256);
    freq.put("Chu", 124);
    freq.put(" lo\u0302", 57);
    freq.put("tse", 80);
    freq.put("udf", 71);
    freq.put("d ", 90625);
    freq.put("udi", 647);
    freq.put("hry", 410);
    freq.put("em ", 460);
    freq.put("hru", 48);
    freq.put("udn", 61);
    freq.put("hro", 487);
    freq.put("hri", 715);
    freq.put("hre", 1207);
    freq.put("hra", 1003);
    freq.put("sur", 508);
    freq.put("dn", 1255);
    freq.put("do", 14938);
    freq.put("dl", 3195);
    freq.put("dm", 105);
    freq.put("wa\u0302", 83);
    freq.put("dh", 972);
    freq.put("di", 29599);
    freq.put("df", 1708);
    freq.put("dg", 311);
    freq.put("dd", 84524);
    freq.put("de", 16065);
    freq.put("db", 94);
    freq.put("dc", 38);
    freq.put("da", 17715);
    freq.put("dy", 12449);
    freq.put("dw", 8140);
    freq.put("dt", 42);
    freq.put("du", 6001);
    freq.put("dr", 8475);
    freq.put("ds", 484);
    freq.put("eme", 719);
    freq.put("ema", 883);
    freq.put("emb", 119);
    freq.put("eml", 44);
    freq.put("emo", 887);
    freq.put("emi", 335);
    freq.put("PA ", 37);
    freq.put("emp", 59);
    freq.put("emy", 94);
    freq.put("hr ", 234);
    freq.put("w ", 28552);
    freq.put(" I ", 222);
    freq.put("il ", 1444);
    freq.put("co ", 406);
    freq.put("wg", 664);
    freq.put("wf", 218);
    freq.put("we", 14515);
    freq.put("wd", 1844);
    freq.put("wc", 1767);
    freq.put("wb", 421);
    freq.put("wa", 8291);
    freq.put("de\u0301", 370);
    freq.put("wo", 2007);
    freq.put("wn", 9601);
    freq.put("wm", 1763);
    freq.put("wl", 4892);
    freq.put("da\u0302", 43);
    freq.put("wi", 6651);
    freq.put(" Iw", 647);
    freq.put("ww", 54);
    freq.put("wu", 53);
    freq.put("wt", 289);
    freq.put("ws", 2657);
    freq.put("wr", 12516);
    freq.put(" In", 879);
    freq.put(" Io", 765);
    freq.put(" Ia", 327);
    freq.put(" Ib", 42);
    freq.put(" Id", 236);
    freq.put(" Ie", 177);
    freq.put("wy", 36348);
    freq.put("ilf", 180);
    freq.put("ilg", 87);
    freq.put("ild", 117);
    freq.put("ile", 398);
    freq.put("cou", 73);
    freq.put("cot", 157);
    freq.put("ila", 556);
    freq.put("ilo", 375);
    freq.put("ill", 4682);
    freq.put("ilm", 1379);
    freq.put("ili", 1564);
    freq.put("ilw", 317);
    freq.put("ilt", 144);
    freq.put("ilu", 39);
    freq.put("coe", 175);
    freq.put("ils", 48);
    freq.put("cof", 150);
    freq.put("com", 217);
    freq.put("col", 301);
    freq.put("ily", 579);
    freq.put("ai ", 2298);
    freq.put("\u0642", 54);
    freq.put("dw\u0302", 331);
    freq.put("ait", 4733);
    freq.put("ais", 581);
    freq.put("air", 2398);
    freq.put("aim", 47);
    freq.put("ail", 1481);
    freq.put("gna", 64);
    freq.put("gne", 142);
    freq.put("aid", 7159);
    freq.put("aig", 842);
    freq.put("gni", 87);
    freq.put("aia", 54);
    freq.put("gno", 66);
    freq.put("aic", 285);
    freq.put("ni ", 1483);
    freq.put("Tit", 38);
    freq.put("o\u0302n ", 543);
    freq.put("th ", 17104);
    freq.put("nin", 984);
    freq.put("nio", 1796);
    freq.put("nil", 468);
    freq.put("nim", 150);
    freq.put("nib", 233);
    freq.put("nic", 341);
    freq.put("nia", 3864);
    freq.put("nif", 815);
    freq.put("nig", 2276);
    freq.put("nid", 544);
    freq.put("nie", 187);
    freq.put("nir", 305);
    freq.put("nis", 599);
    freq.put("niv", 47);
    freq.put("niw", 268);
    freq.put("nit", 132);
    freq.put("niu", 56);
    freq.put("thy", 2521);
    freq.put("thw", 450);
    freq.put("ept", 38);
    freq.put("ths", 111);
    freq.put("thr", 1553);
    freq.put("epp", 38);
    freq.put("i\u0302", 418);
    freq.put("o\u0302ne", 45);
    freq.put("\u0629", 126);
    freq.put("thm", 78);
    freq.put("thl", 355);
    freq.put("eph", 182);
    freq.put("epi", 1038);
    freq.put("thg", 113);
    freq.put("thf", 157);
    freq.put("the", 2439);
    freq.put("epe", 37);
    freq.put("tha", 2130);
    freq.put("epa", 97);
    freq.put("rn ", 2146);
    freq.put("Gaz", 46);
    freq.put("Gat", 72);
    freq.put("Gas", 89);
    freq.put("Gar", 516);
    freq.put("Gan", 372);
    freq.put("Gam", 70);
    freq.put("Gal", 398);
    freq.put("Gai", 99);
    freq.put("Gae", 1402);
    freq.put("Gad", 59);
    freq.put("Gab", 57);
    freq.put("Tri", 147);
    freq.put("rni", 383);
    freq.put("rno", 1027);
    freq.put("Tro", 153);
    freq.put("Tra", 432);
    freq.put("rna", 1374);
    freq.put("rng", 123);
    freq.put("rne", 1846);
    freq.put("Try", 61);
    freq.put("rny", 151);
    freq.put("lca", 76);
    freq.put("rns", 37);
    freq.put("lco", 59);
    freq.put("Tru", 44);
    freq.put("lch", 1070);
    freq.put("Tok", 42);
    freq.put("Ewr", 684);
    freq.put("Lea", 111);
    freq.put("Lee", 38);
    freq.put("yke", 46);
    freq.put("Leg", 43);
    freq.put("Lei", 113);
    freq.put("ob ", 762);
    freq.put("Leo", 78);
    freq.put("Lep", 994);
    freq.put("Ler", 63);
    freq.put("Les", 58);
    freq.put("Lev", 111);
    freq.put("Lew", 127);
    freq.put("plw", 76);
    freq.put("plu", 38);
    freq.put("ply", 40);
    freq.put("ple", 218);
    freq.put("pla", 375);
    freq.put("plo", 82);
    freq.put("Le ", 50);
    freq.put("obo", 63);
    freq.put("obl", 2204);
    freq.put("obh", 60);
    freq.put("obi", 128);
    freq.put("obe", 364);
    freq.put("oba", 133);
    freq.put("oby", 47);
    freq.put("obr", 327);
    freq.put("Cur", 60);
    freq.put("Rad", 90);
    freq.put("Cul", 80);
    freq.put("wan", 225);
    freq.put("wal", 228);
    freq.put("wai", 2037);
    freq.put("wah", 560);
    freq.put("wae", 306);
    freq.put("wad", 321);
    freq.put("way", 128);
    freq.put("wau", 1633);
    freq.put("was", 655);
    freq.put("war", 1946);
    freq.put("\u0442", 99);
    freq.put("wa ", 108);
    freq.put("mth", 126);
    freq.put("u\u0308r", 59);
    freq.put(" n ", 12651);
    freq.put("oly", 709);
    freq.put(" ni", 1109);
    freq.put(" nh", 758);
    freq.put(" no", 795);
    freq.put(" na", 2311);
    freq.put(" ne", 8387);
    freq.put(" ng", 3326);
    freq.put(" ny", 117);
    freq.put(" nw", 267);
    freq.put("Sgu", 236);
    freq.put("Sgi", 37);
    freq.put("Sgo", 69);
    freq.put("ume", 97);
    freq.put("gu ", 507);
    freq.put("fi\u0302", 107);
    freq.put("umo", 125);
    freq.put("gua", 83);
    freq.put("gue", 160);
    freq.put("gun", 41);
    freq.put("gul", 65);
    freq.put("gus", 127);
    freq.put("p", 27532);
    freq.put("o\u0301n", 72);
    freq.put("hto", 62);
    freq.put("ek ", 72);
    freq.put("\u0433", 58);
    freq.put("e\u0300re", 37);
    freq.put("ht ", 286);
    freq.put("gle", 4369);
    freq.put("fbw", 52);
    freq.put("fba", 41);
    freq.put(" Ka", 449);
    freq.put(" Ke", 303);
    freq.put("ib ", 99);
    freq.put(" Kh", 108);
    freq.put(" Ki", 398);
    freq.put(" Kn", 99);
    freq.put(" Ko", 131);
    freq.put(" Kr", 62);
    freq.put(" Ku", 119);
    freq.put("Moo", 54);
    freq.put("ca ", 1177);
    freq.put("F", 9129);
    freq.put("\u064a", 291);
    freq.put("uz ", 39);
    freq.put("ibh", 49);
    freq.put("ibi", 164);
    freq.put("ibl", 135);
    freq.put("ibo", 40);
    freq.put("cas", 275);
    freq.put("car", 1065);
    freq.put("cap", 69);
    freq.put("caw", 70);
    freq.put("ibe", 421);
    freq.put("cat", 148);
    freq.put("iby", 308);
    freq.put("cai", 547);
    freq.put("can", 2308);
    freq.put("cam", 299);
    freq.put("cal", 289);
    freq.put("ibr", 68);
    freq.put("caf", 386);
    freq.put("cae", 1029);
    freq.put("cad", 459);
    freq.put("ao ", 50);
    freq.put("spi", 54);
    freq.put("spo", 55);
    freq.put("spa", 52);
    freq.put("spe", 66);
    freq.put("gh ", 361);
    freq.put("aod", 56);
    freq.put("aob", 43);
    freq.put("aon", 63);
    freq.put("aol", 79);
    freq.put("aoi", 58);
    freq.put("aos", 40);
    freq.put("aor", 71);
    freq.put("ght", 218);
    freq.put("ghw", 91);
    freq.put("ibi\u0302", 56);
    freq.put("ghy", 1825);
    freq.put("ghe", 333);
    freq.put("gha", 1381);
    freq.put("gho", 144);
    freq.put("Ru", 535);
    freq.put("Rw", 509);
    freq.put("Che", 165);
    freq.put("ee\u0308", 45);
    freq.put("Chi", 233);
    freq.put("Chl", 64);
    freq.put("Fed", 56);
    freq.put("Jap", 343);
    freq.put("Cho", 221);
    freq.put("Jan", 70);
    freq.put("Re", 503);
    freq.put("Chr", 239);
    freq.put("Jam", 257);
    freq.put("Ra", 632);
    freq.put("Chw", 858);
    freq.put("Chy", 89);
    freq.put("Ro", 2605);
    freq.put("Rh", 3082);
    freq.put("Ri", 460);
    freq.put("sod", 829);
    freq.put("sof", 55);
    freq.put("\u03b1", 182);
    freq.put("nol", 6920);
    freq.put("nom", 300);
    freq.put("non", 374);
    freq.put("noi", 38);
    freq.put("nod", 2808);
    freq.put("noe", 174);
    freq.put("nof", 371);
    freq.put("nog", 705);
    freq.put("nob", 37);
    freq.put("noc", 164);
    freq.put("R ", 160);
    freq.put("noy", 55);
    freq.put("nou", 48);
    freq.put("nov", 50);
    freq.put("son", 872);
    freq.put("nor", 454);
    freq.put("nos", 284);
    freq.put("sou", 66);
    freq.put("em", 3744);
    freq.put("el", 20723);
    freq.put("eo", 4494);
    freq.put("en", 34977);
    freq.put("ei", 27830);
    freq.put("eh", 1107);
    freq.put("ek", 164);
    freq.put("ej", 41);
    freq.put("ee", 943);
    freq.put("ed", 44549);
    freq.put("eg", 15169);
    freq.put("Afg", 44);
    freq.put("ea", 4976);
    freq.put("rl ", 122);
    freq.put("ec", 2955);
    freq.put("eb", 3180);
    freq.put("ey", 2052);
    freq.put("ex", 424);
    freq.put("ez", 173);
    freq.put("lm ", 1156);
    freq.put("et", 14347);
    freq.put("ew", 8995);
    freq.put("ev", 608);
    freq.put("ep", 1574);
    freq.put("es", 16689);
    freq.put("er", 35301);
    freq.put("\u0633", 144);
    freq.put("rll", 3618);
    freq.put("rlo", 220);
    freq.put("rli", 209);
    freq.put("rle", 285);
    freq.put("rld", 49);
    freq.put("rla", 139);
    freq.put("e ", 32522);
    freq.put("lmi", 265);
    freq.put("rly", 277);
    freq.put("lmo", 40);
    freq.put("rlu", 234);
    freq.put("lma", 729);
    freq.put("lme", 52);
    freq.put("ael", 2752);
    freq.put("ja ", 42);
    freq.put("zan", 41);
    freq.put("xi", 200);
    freq.put("xo", 38);
    freq.put("xa", 159);
    freq.put("zab", 52);
    freq.put("xe", 70);
    freq.put("zar", 39);
    freq.put("Eup", 59);
    freq.put("xt", 49);
    freq.put("Eur", 69);
    freq.put("yie", 41);
    freq.put("x ", 538);
    freq.put("za ", 99);
    freq.put("Cwm", 473);
    freq.put("Ph", 393);
    freq.put("Phi", 138);
    freq.put("Pho", 86);
    freq.put("Phe", 40);
    freq.put("wca", 54);
    freq.put("Pl", 525);
    freq.put("Phr", 55);
    freq.put("wcl", 96);
    freq.put("Off", 71);
    freq.put("egl", 298);
    freq.put("mwd", 160);
    freq.put("mry", 585);
    freq.put("mru", 3069);
    freq.put("\u062f ", 50);
    freq.put("mro", 136);
    freq.put("mre", 767);
    freq.put("mra", 1424);
    freq.put("Uch", 2348);
    freq.put("Web", 41);
    freq.put("Wef", 896);
    freq.put("Wed", 39);
    freq.put("Wei", 199);
    freq.put("Wen", 117);
    freq.put("Wel", 99);
    freq.put("Wes", 154);
    freq.put("Wer", 95);
    freq.put("\u03b5", 83);
    freq.put("Mho", 230);
    freq.put(" pw", 499);
    freq.put("\u043d\u0430", 37);
    freq.put(" pu", 181);
    freq.put(" py", 162);
    freq.put("Mhe", 110);
    freq.put("Mha", 155);
    freq.put(" pa", 944);
    freq.put(" pe", 3258);
    freq.put(" pi", 236);
    freq.put("Mhu", 72);
    freq.put(" po", 1095);
    freq.put(" pl", 527);
    freq.put("gwa\u0302", 55);
    freq.put("yty", 72);
    freq.put("ytu", 126);
    freq.put("ytr", 121);
    freq.put("yts", 74);
    freq.put("yth", 1577);
    freq.put("yti", 312);
    freq.put("yta", 92);
    freq.put(" pe\u0302", 155);
    freq.put("gwe", 1487);
    freq.put("gwa", 1284);
    freq.put("gwb", 37);
    freq.put("gwm", 270);
    freq.put("gwl", 1426);
    freq.put("gwo", 40);
    freq.put("gwn", 213);
    freq.put("gwi", 169);
    freq.put("\u03b1 ", 57);
    freq.put("gwr", 1885);
    freq.put("gwy", 2799);
    freq.put(" Mo\u0302", 741);
    freq.put("ei ", 4933);
    freq.put("Yr ", 655);
    freq.put("eip", 43);
    freq.put("eis", 1705);
    freq.put("eir", 7366);
    freq.put("eit", 4122);
    freq.put("eia", 266);
    freq.put("eic", 354);
    freq.put("eib", 184);
    freq.put("eid", 2056);
    freq.put("eig", 925);
    freq.put("eif", 224);
    freq.put("eim", 111);
    freq.put("eil", 1530);
    freq.put("eio", 37);
    freq.put("ein", 3860);
    freq.put("ceg", 95);
    freq.put("ety", 70);
    freq.put("cef", 174);
    freq.put("yk", 65);
    freq.put("ced", 138);
    freq.put("yl", 4484);
    freq.put(" Me", 3065);
    freq.put(" Ma", 14593);
    freq.put(" Mc", 91);
    freq.put(" Mo", 2327);
    freq.put(" Mh", 722);
    freq.put(" Mi", 739);
    freq.put(" Mu", 485);
    freq.put(" Mw", 171);
    freq.put(" Mr", 121);
    freq.put("rwi", 121);
    freq.put(" My", 759);
    freq.put("yb", 822);
    freq.put("L", 15711);
    freq.put("yg", 2872);
    freq.put("ux ", 77);
    freq.put("yf", 12232);
    freq.put("aee\u0308", 39);
    freq.put("rwp", 99);
    freq.put(" M ", 53);
    freq.put("tlo", 100);
    freq.put("eto", 117);
    freq.put("cci", 42);
    freq.put("cca", 45);
    freq.put("a\u0301i", 74);
    freq.put("am ", 3780);
    freq.put("ps ", 77);
    freq.put("a\u0301n", 75);
    freq.put("yp", 196);
    freq.put(" a\u0302 ", 1666);
    freq.put("cl", 1111);
    freq.put("ca", 8269);
    freq.put("ami", 272);
    freq.put("amh", 93);
    freq.put("psi", 40);
    freq.put("amm", 156);
    freq.put("aml", 1316);
    freq.put("amo", 343);
    freq.put("ama", 982);
    freq.put("amc", 173);
    freq.put("amb", 378);
    freq.put("ame", 669);
    freq.put("amd", 204);
    freq.put("e\u0302r", 91);
    freq.put("e\u0302l", 271);
    freq.put("e\u0302m", 109);
    freq.put("e\u0302n", 983);
    freq.put("amp", 711);
    freq.put("ams", 445);
    freq.put("amr", 285);
    freq.put("amu", 51);
    freq.put("amw", 69);
    freq.put("Rac", 38);
    freq.put("uce", 83);
    freq.put("Ran", 141);
    freq.put("t", 96401);
    freq.put("Hea", 71);
    freq.put("Ram", 56);
    freq.put("uca", 70);
    freq.put("Hel", 181);
    freq.put("Rai", 42);
    freq.put("uck", 68);
    freq.put("Ior", 53);
    freq.put("Ion", 616);
    freq.put("uci", 43);
    freq.put("uch", 1304);
    freq.put("Ioa", 44);
    freq.put("yny", 6318);
    freq.put("\u02c8", 50);
    freq.put("nme", 498);
    freq.put("nma", 211);
    freq.put("sra", 159);
    freq.put("Adr", 99);
    freq.put("Add", 86);
    freq.put("Ade", 142);
    freq.put("Ada", 89);
    freq.put("Adn", 48);
    freq.put("lob", 68);
    freq.put("loc", 229);
    freq.put("lof", 189);
    freq.put("log", 1629);
    freq.put("lod", 1459);
    freq.put("loe", 1682);
    freq.put("loi", 55);
    freq.put("lon", 635);
    freq.put("loo", 45);
    freq.put("lol", 56);
    freq.put("lom", 296);
    freq.put("lor", 335);
    freq.put("los", 162);
    freq.put("lop", 83);
    freq.put("low", 187);
    freq.put("lot", 96);
    freq.put("lou", 84);
    freq.put("loy", 165);
    freq.put("\u0646", 219);
    freq.put("J", 2920);
    freq.put("lo ", 540);
    freq.put("Esg", 154);
    freq.put("Mul", 66);
    freq.put("Lam", 49);
    freq.put("Lan", 381);
    freq.put("Lao", 55);
    freq.put("Lai", 41);
    freq.put("Lad", 104);
    freq.put("Laf", 70);
    freq.put("Lag", 42);
    freq.put("Lau", 47);
    freq.put("Law", 91);
    freq.put("Lar", 55);
    freq.put("Las", 63);
    freq.put("c ", 8637);
    freq.put("Bry", 805);
    freq.put("Brw", 176);
    freq.put("Bru", 120);
    freq.put("La ", 83);
    freq.put("yo ", 95);
    freq.put("Bro", 495);
    freq.put("Bri", 461);
    freq.put("Bre", 500);
    freq.put("Bra", 479);
    freq.put("mp ", 159);
    freq.put("wmp", 187);
    freq.put("wmw", 171);
    freq.put("wmn", 259);
    freq.put("wmb", 41);
    freq.put("wma", 78);
    freq.put(" ro\u0302", 102);
    freq.put("mpe", 82);
    freq.put("mpa", 381);
    freq.put("mpl", 56);
    freq.put("mph", 82);
    freq.put("mpi", 350);
    freq.put("mpw", 155);
    freq.put("mpt", 51);
    freq.put("mps", 75);
    freq.put(" re\u0301", 57);
    freq.put("wm ", 924);
    freq.put("pul", 54);
    freq.put(" r ", 22194);
    freq.put("osc", 72);
    freq.put(" rw", 43);
    freq.put(" ry", 627);
    freq.put(" re", 611);
    freq.put(" ra", 1107);
    freq.put(" ro", 1221);
    freq.put(" ri", 136);
    freq.put(" rh", 8680);
    freq.put("S ", 764);
    freq.put("asm", 43);
    freq.put("Sy", 524);
    freq.put("fo\u0302", 44);
    freq.put("Sr", 86);
    freq.put("Sp", 262);
    freq.put("Sw", 1250);
    freq.put("Su", 393);
    freq.put("St", 1498);
    freq.put("Sk", 83);
    freq.put("Si", 2884);
    freq.put("Sh", 621);
    freq.put("So", 559);
    freq.put("Sm", 109);
    freq.put("Sl", 145);
    freq.put("Sc", 412);
    freq.put("Sb", 343);
    freq.put("Sa", 6147);
    freq.put("Sg", 470);
    freq.put("Se", 1837);
    freq.put("f ", 18520);
    freq.put("eg ", 10783);
    freq.put("fr", 8643);
    freq.put("fs", 46);
    freq.put("ft", 461);
    freq.put("fu", 2341);
    freq.put("fw", 1978);
    freq.put("fy", 10068);
    freq.put("\u03bf\u0301", 61);
    freq.put("fa", 9608);
    freq.put("fb", 102);
    freq.put("fd", 990);
    freq.put("fe", 14177);
    freq.put("ff", 11831);
    freq.put("fg", 93);
    freq.put("fi", 6912);
    freq.put("fl", 2826);
    freq.put("fn", 3165);
    freq.put("fo", 10368);
    freq.put("a", 340057);
    freq.put("egy", 248);
    freq.put("egr", 1255);
    freq.put("egw", 168);
    freq.put("egu", 49);
    freq.put("wle", 1242);
    freq.put("egi", 546);
    freq.put("ego", 998);
    freq.put("egn", 70);
    freq.put("o\u0308", 248);
    freq.put("ega", 438);
    freq.put("egf", 89);
    freq.put("ege", 153);
    freq.put("rw ", 1096);
    freq.put("ffy", 559);
    freq.put("ce ", 639);
    freq.put("ffw", 181);
    freq.put("y ", 43036);
    freq.put("ffu", 1091);
    freq.put("fft", 332);
    freq.put("ffr", 1792);
    freq.put("ffo", 2073);
    freq.put("ffl", 109);
    freq.put("ffi", 2487);
    freq.put("ffe", 1545);
    freq.put("uve", 61);
    freq.put("ffa", 542);
    freq.put(" On", 113);
    freq.put(" Ol", 406);
    freq.put(" Oh", 42);
    freq.put(" Of", 85);
    freq.put(" Og", 269);
    freq.put(" Od", 68);
    freq.put(" Oe", 2267);
    freq.put(" Ob", 54);
    freq.put(" Oc", 104);
    freq.put(" Oa", 50);
    freq.put("if ", 3195);
    freq.put(" Oy", 53);
    freq.put(" Ow", 296);
    freq.put(" Ot", 47);
    freq.put(" Ou", 45);
    freq.put(" Or", 342);
    freq.put(" Os", 133);
    freq.put(" Op", 59);
    freq.put("yi", 95);
    freq.put("rwa", 160);
    freq.put("rwb", 38);
    freq.put("rwc", 56);
    freq.put("ym", 17663);
    freq.put("rwe", 1416);
    freq.put("yo", 362);
    freq.put("yn", 74012);
    freq.put("ya", 2335);
    freq.put("cen", 351);
    freq.put("yc", 3592);
    freq.put("cel", 207);
    freq.put("ye", 236);
    freq.put("yd", 50329);
    freq.put("rwn", 561);
    freq.put("rwo", 224);
    freq.put("yy", 47);
    freq.put("rwr", 297);
    freq.put("rws", 144);
    freq.put("ces", 90);
    freq.put("cer", 588);
    freq.put("cep", 40);
    freq.put("rwy", 3684);
    freq.put("ys", 12384);
    freq.put("yr", 22478);
    freq.put("yu", 51);
    freq.put("yt", 2465);
    freq.put("yw", 21420);
    freq.put("ff ", 917);
    freq.put("ifw", 100);
    freq.put("ifr", 76);
    freq.put("ify", 395);
    freq.put(" O ", 158);
    freq.put("ifd", 919);
    freq.put("ife", 1414);
    freq.put("iff", 1472);
    freq.put("ifa", 410);
    freq.put("ifl", 67);
    freq.put("ifo", 628);
    freq.put("ifi", 808);
    freq.put("Eng", 69);
    freq.put("Eni", 89);
    freq.put("ffi\u0302", 106);
    freq.put("as ", 6724);
    freq.put("Enw", 854);
    freq.put("w\u0302r ", 390);
    freq.put("ass", 281);
    freq.put("pum", 128);
    freq.put("asw", 75);
    freq.put("asu", 218);
    freq.put("ast", 1476);
    freq.put("asy", 50);
    freq.put("asc", 78);
    freq.put("asa", 524);
    freq.put("asg", 690);
    freq.put("ase", 115);
    freq.put("asd", 54);
    freq.put("ask", 48);
    freq.put("asi", 753);
    freq.put("ash", 208);
    freq.put("aso", 389);
    freq.put("asn", 260);
    freq.put("pur", 257);
    freq.put("pus", 49);
    freq.put("Clo", 101);
    freq.put("Cli", 57);
    freq.put("Cle", 140);
    freq.put("Cla", 218);
    freq.put("Cly", 91);
    freq.put("i\u0302m ", 136);
    freq.put("nc ", 1075);
    freq.put("Clu", 93);
    freq.put("Clw", 225);
    freq.put("st ", 1362);
    freq.put("ncy", 93);
    freq.put("tfo", 51);
    freq.put("ncr", 37);
    freq.put("nct", 92);
    freq.put("ncw", 75);
    freq.put("nch", 147);
    freq.put("nci", 267);
    freq.put("ncl", 53);
    freq.put("nco", 109);
    freq.put("nca", 318);
    freq.put("nce", 463);
    freq.put("ste", 2086);
    freq.put("sta", 1396);
    freq.put("stl", 111);
    freq.put("stn", 164);
    freq.put("sto", 1089);
    freq.put("sti", 810);
    freq.put("stu", 468);
    freq.put("stw", 328);
    freq.put("str", 1798);
    freq.put("sty", 866);
    freq.put("Gom", 67);
    freq.put("Gol", 183);
    freq.put("Goo", 37);
    freq.put("ka ", 196);
    freq.put("God", 47);
    freq.put("Gog", 472);
    freq.put("Goc", 85);
    freq.put("Got", 62);
    freq.put("Gor", 1252);
    freq.put("lid", 245);
    freq.put("lie", 476);
    freq.put("lif", 562);
    freq.put("lig", 359);
    freq.put("Nin", 78);
    freq.put("lia", 3198);
    freq.put("lic", 203);
    freq.put("lil", 79);
    freq.put("Nic", 115);
    freq.put("lin", 1276);
    freq.put("lio", 1087);
    freq.put("Nig", 61);
    freq.put("Nid", 87);
    freq.put("lit", 378);
    freq.put("liu", 80);
    freq.put("liv", 56);
    freq.put("liw", 673);
    freq.put("2 ", 91);
    freq.put("lir", 1910);
    freq.put("lis", 440);
    freq.put("liz", 69);
    freq.put("rhy", 1627);
    freq.put("kai", 44);
    freq.put("rhu", 44);
    freq.put("kan", 58);
    freq.put("rhw", 2579);
    freq.put("rhi", 381);
    freq.put("kar", 68);
    freq.put("Thi", 43);
    freq.put("rha", 3805);
    freq.put("The", 818);
    freq.put("rhe", 939);
    freq.put("Tha", 114);
    freq.put("wyl", 1023);
    freq.put("li ", 2035);
    freq.put("Ni ", 64);
    freq.put("ymp", 236);
    freq.put("ymr", 5566);
    freq.put("ymu", 2206);
    freq.put("ymt", 125);
    freq.put("ymw", 638);
    freq.put("ymy", 322);
    freq.put("yma", 1393);
    freq.put("ymc", 84);
    freq.put("ymb", 284);
    freq.put("yme", 789);
    freq.put("ymd", 943);
    freq.put("ymg", 221);
    freq.put("ymf", 49);
    freq.put("ymi", 79);
    freq.put("ymh", 887);
    freq.put("ox ", 45);
    freq.put("yml", 267);
    freq.put("ymo", 286);
    freq.put(" ty\u0302", 48);
    freq.put("ym ", 3225);
    freq.put("x", 1194);
    freq.put("Me", 3068);
    freq.put("dus", 635);
    freq.put("Plw", 64);
    freq.put("wor", 104);
    freq.put("wol", 250);
    freq.put("woo", 72);
    freq.put("won", 68);
    freq.put("\u0637", 52);
    freq.put("wod", 593);
    freq.put("wog", 540);
    freq.put("ydd", 28126);
    freq.put("woc", 119);
    freq.put("wob", 230);
    freq.put("ni\u0308a", 320);
    freq.put("Wal", 281);
    freq.put("ydy", 4654);
    freq.put("Wav", 42);
    freq.put("Wau", 61);
    freq.put("Wat", 101);
    freq.put("Was", 76);
    freq.put("War", 117);
    freq.put(" t ", 111);
    freq.put("ydr", 1154);
    freq.put(" ty", 390);
    freq.put(" tw", 61);
    freq.put(" tu", 2121);
    freq.put(" tr", 2664);
    freq.put("N", 7579);
    freq.put(" to", 326);
    freq.put(" ti", 314);
    freq.put(" th", 2240);
    freq.put(" te", 1558);
    freq.put(" ta", 1382);
    freq.put("iya", 51);
    freq.put("iyn", 234);
    freq.put("mo\u0302r", 276);
    freq.put("Hyd", 590);
    freq.put("hu\u0304 ", 64);
    freq.put(" \u0627", 223);
    freq.put("gs ", 64);
    freq.put("e\u0302r ", 90);
    freq.put(" ti\u0302", 44);
    freq.put("gst", 47);
    freq.put("rwg", 50);
    freq.put("lim", 71);
    freq.put("\u03b9", 95);
    freq.put("lip", 176);
    freq.put("ee ", 253);
    freq.put("eet", 97);
    freq.put("ees", 61);
    freq.put("eer", 37);
    freq.put("eel", 41);
    freq.put("een", 324);
    freq.put("eed", 37);
    freq.put("CC ", 319);
    freq.put("Ty\u0302", 84);
    freq.put("ru ", 3404);
    freq.put("rwm", 69);
    freq.put(" Qu", 254);
    freq.put("id ", 3479);
    freq.put("rui", 70);
    freq.put("run", 62);
    freq.put("rum", 94);
    freq.put("ruc", 119);
    freq.put("ruf", 148);
    freq.put("rug", 759);
    freq.put("rud", 120);
    freq.put("Thr", 141);
    freq.put("rus", 185);
    freq.put("rut", 66);
    freq.put("Tho", 319);
    freq.put("idy", 707);
    freq.put("idw", 100);
    freq.put("idr", 79);
    freq.put("ido", 1466);
    freq.put("idl", 131);
    freq.put("idh", 303);
    freq.put("idi", 544);
    freq.put("idf", 47);
    freq.put("idg", 97);
    freq.put("idd", 6222);
    freq.put("ide", 336);
    freq.put("ida", 808);
    freq.put("Eli", 163);
    freq.put("rho", 350);
    freq.put("Ell", 61);
    freq.put("Elf", 104);
    freq.put("Ele", 70);
    freq.put("ut ", 194);
    freq.put("\u4e26", 68);
    freq.put("w\u0302p ", 436);
    freq.put("pwt", 58);
    freq.put("pwr", 173);
    freq.put("El ", 81);
    freq.put("pwy", 372);
    freq.put("pwl", 73);
    freq.put("uta", 55);
    freq.put("fdd", 922);
    freq.put("ute", 122);
    freq.put("uth", 300);
    freq.put("uti", 56);
    freq.put("uto", 58);
    freq.put("uts", 49);
    freq.put("utt", 64);
    freq.put("utu", 93);
    freq.put("Ty", 474);
    freq.put("Tw", 270);
    freq.put("Tu", 595);
    freq.put("Tr", 1825);
    freq.put("Ts", 360);
    freq.put("To", 757);
    freq.put("Th", 1526);
    freq.put("Ti", 598);
    freq.put("Te", 1081);
    freq.put("Ta", 2097);
    freq.put("nab", 949);
    freq.put("A ", 1088);
    freq.put("naf", 1404);
    freq.put("nag", 190);
    freq.put("nad", 788);
    freq.put("nae", 541);
    freq.put("nah", 42);
    freq.put("nai", 1969);
    freq.put("nan", 722);
    freq.put("nal", 455);
    freq.put("nam", 268);
    freq.put("nar", 638);
    freq.put("nas", 4427);
    freq.put("naw", 889);
    freq.put("nat", 502);
    freq.put("nau", 1855);
    freq.put("oon", 48);
    freq.put("ook", 101);
    freq.put("T ", 147);
    freq.put("na ", 2341);
    freq.put("Ab", 1337);
    freq.put("e", 305845);
    freq.put("Ad", 579);
    freq.put("Ag", 155);
    freq.put("Af", 1863);
    freq.put("Ai", 814);
    freq.put("Am", 1812);
    freq.put("Al", 5324);
    freq.put("Ao", 86);
    freq.put("An", 1298);
    freq.put("Aq", 45);
    freq.put("Ap", 230);
    freq.put("As", 660);
    freq.put("Ar", 2753);
    freq.put("Au", 228);
    freq.put("At", 330);
    freq.put("Aw", 1145);
    freq.put("Av", 93);
    freq.put("Ay", 58);
    freq.put("u\u0301", 96);
    freq.put("gw", 9737);
    freq.put("gu", 1382);
    freq.put("gt", 170);
    freq.put("gs", 165);
    freq.put("gr", 6508);
    freq.put("gy", 9888);
    freq.put("gg", 166);
    freq.put("gf", 868);
    freq.put("ge", 9102);
    freq.put("gd", 137);
    freq.put("gb", 189);
    freq.put("ga", 16120);
    freq.put("go", 16514);
    freq.put("gn", 416);
    freq.put("gm", 64);
    freq.put("Gil", 60);
    freq.put("gi", 3529);
    freq.put("gh", 4830);
    freq.put("tma", 64);
    freq.put("Nof", 207);
    freq.put("lke", 43);
    freq.put("Not", 37);
    freq.put("dw\u0302r", 302);
    freq.put("\u03bd", 135);
    freq.put("Nor", 455);
    freq.put("e\u0308eg", 55);
    freq.put("g ", 36598);
    freq.put("lk ", 57);
    freq.put("Spi", 76);
    freq.put("Spa", 48);
    freq.put("tmo", 40);
    freq.put("Spe", 51);
    freq.put("zo", 149);
    freq.put("zh", 71);
    freq.put("zi", 170);
    freq.put("ze", 198);
    freq.put("za", 330);
    freq.put("zb", 37);
    freq.put("ga\u0302", 69);
    freq.put("zz", 70);
    freq.put("zu", 71);
    freq.put("ge\u0302", 84);
    freq.put("ych", 3349);
    freq.put("ycl", 60);
    freq.put("yca", 52);
    freq.put("ull", 591);
    freq.put("z ", 355);
    freq.put("ulf", 75);
    freq.put("\u0440\u043e", 38);
    freq.put("wig", 187);
    freq.put("gw\u0302", 65);
    freq.put("wid", 262);
    freq.put("wic", 128);
    freq.put("wia", 359);
    freq.put("wio", 346);
    freq.put("win", 3305);
    freq.put("wil", 311);
    freq.put("wit", 92);
    freq.put("sys", 246);
    freq.put("wir", 738);
    freq.put("Ji", 72);
    freq.put("wi ", 316);
    freq.put("ied", 632);
    freq.put(" va", 38);
    freq.put(" ve", 41);
    freq.put(" vi", 53);
    freq.put(" vo", 48);
    freq.put(" w\u0302y", 55);
    freq.put("\u0628", 192);
    freq.put("c\u0327", 67);
    freq.put("o\u0308yn", 126);
    freq.put("hly", 120);
    freq.put("ec ", 78);
    freq.put("hlw", 214);
    freq.put("hlu", 57);
    freq.put("hlo", 125);
    freq.put("mar", 872);
    freq.put("hli", 122);
    freq.put("hle", 156);
    freq.put("hla", 1210);
    freq.put("ece", 39);
    freq.put("eca", 88);
    freq.put("eco", 330);
    freq.put("eck", 79);
    freq.put("eci", 144);
    freq.put("ech", 1424);
    freq.put("ect", 300);
    freq.put("ecs", 273);
    freq.put("ecr", 59);
    freq.put(" Pe\u0302", 44);
    freq.put("OC ", 70);
    freq.put("rs ", 905);
    freq.put("cy ", 84);
    freq.put(" Sy", 523);
    freq.put(" Sr", 86);
    freq.put(" Sp", 260);
    freq.put(" Sw", 1250);
    freq.put(" St", 1487);
    freq.put(" Su", 392);
    freq.put(" Sk", 82);
    freq.put(" Sh", 618);
    freq.put(" Si", 2880);
    freq.put(" So", 559);
    freq.put(" Sl", 145);
    freq.put(" Sm", 109);
    freq.put(" Sb", 343);
    freq.put(" Sc", 411);
    freq.put(" Sa", 6139);
    freq.put("re\u0301", 173);
    freq.put(" Se", 1836);
    freq.put("cys", 475);
    freq.put("cyr", 140);
    freq.put("rso", 354);
    freq.put("rsh", 49);
    freq.put("rsi", 244);
    freq.put("cyt", 158);
    freq.put("rse", 307);
    freq.put("rsa", 276);
    freq.put("cyc", 79);
    freq.put("R", 8785);
    freq.put("rsy", 112);
    freq.put("cyd", 196);
    freq.put("rst", 96);
    freq.put("rsw", 71);
    freq.put("cyn", 2866);
    freq.put("cym", 1147);
    freq.put("cyl", 309);
    freq.put("bei", 410);
    freq.put("ben", 1862);
    freq.put("bel", 400);
    freq.put("bec", 63);
    freq.put("beg", 385);
    freq.put("bed", 758);
    freq.put("ber", 2389);
    freq.put(" S ", 95);
    freq.put("bet", 283);
    freq.put("aw ", 1576);
    freq.put("ur ", 3905);
    freq.put("w\u0302n ", 84);
    freq.put("awy", 402);
    freq.put("pys", 41);
    freq.put("pyt", 61);
    freq.put("awr", 2782);
    freq.put("awn", 857);
    freq.put("awl", 555);
    freq.put("\u05d4", 41);
    freq.put("pyn", 54);
    freq.put("awg", 51);
    freq.put("awf", 124);
    freq.put("awe", 760);
    freq.put("awd", 1261);
    freq.put("awa", 150);
    freq.put("urd", 1224);
    freq.put("ure", 327);
    freq.put("urf", 869);
    freq.put("urg", 261);
    freq.put("ura", 273);
    freq.put("urc", 65);
    freq.put("urn", 280);
    freq.put("uro", 357);
    freq.put("uri", 598);
    freq.put("urk", 37);
    freq.put("urt", 95);
    freq.put("urw", 145);
    freq.put("urr", 296);
    freq.put("urs", 65);
    freq.put("ury", 156);
    freq.put("Ian", 45);
    freq.put("Iai", 126);
    freq.put("Den", 121);
    freq.put("Iar", 71);
    freq.put("ngd", 98);
    freq.put("nge", 1187);
    freq.put("nga", 1043);
    freq.put("ngl", 561);
    freq.put("ngo", 2653);
    freq.put("ngh", 2527);
    freq.put("ngi", 310);
    freq.put("sh ", 444);
    freq.put("ngu", 161);
    freq.put("ngw", 591);
    freq.put("Def", 186);
    freq.put("ngr", 197);
    freq.put("ngs", 104);
    freq.put("New", 1034);
    freq.put("ngy", 306);
    freq.put("Pla", 369);
    freq.put("mge", 117);
    freq.put("tbl", 227);
    freq.put("mgu", 85);
    freq.put("tba", 61);
    freq.put("mgy", 321);
    freq.put("ng ", 9397);
    freq.put("sha", 130);
    freq.put("she", 119);
    freq.put("shi", 361);
    freq.put("m2 ", 86);
    freq.put("sho", 46);
    freq.put("ke ", 171);
    freq.put("lur", 87);
    freq.put("lus", 297);
    freq.put("lub", 52);
    freq.put("luc", 42);
    freq.put("lud", 183);
    freq.put("lue", 48);
    freq.put("\u043b", 170);
    freq.put("lum", 206);
    freq.put("lun", 1166);
    freq.put("luo", 1302);
    freq.put("ken", 115);
    freq.put("kel", 108);
    freq.put("Sro", 50);
    freq.put("kes", 50);
    freq.put("ker", 140);
    freq.put("lu ", 1258);
    freq.put("Loc", 1370);
    freq.put("Loe", 137);
    freq.put("ot ", 344);
    freq.put("Loi", 64);
    freq.put("Lon", 140);
    freq.put("Lom", 91);
    freq.put("Lor", 55);
    freq.put("Los", 46);
    freq.put("Lou", 107);
    freq.put("An ", 121);
    freq.put("yal", 55);
    freq.put("yan", 80);
    freq.put("Ryg", 65);
    freq.put("yad", 44);
    freq.put("yaf", 1692);
    freq.put(" au", 347);
    freq.put("oth", 272);
    freq.put("oti", 143);
    freq.put("oto", 157);
    freq.put("ota", 156);
    freq.put("otb", 49);
    freq.put("ote", 190);
    freq.put("oty", 64);
    freq.put("ots", 65);
    freq.put("ott", 255);
    freq.put("And", 209);
    freq.put("Ang", 201);
    freq.put("Ana", 70);
    freq.put("Ann", 197);
    freq.put("Ani", 79);
    freq.put("Ant", 265);
    freq.put("shu\u0304", 62);
    freq.put("ya ", 226);
    freq.put("You", 59);
    freq.put("ga\u0302n", 47);
    freq.put("Be", 2806);
    freq.put("Ba", 2551);
    freq.put("Bl", 698);
    freq.put("Bo", 949);
    freq.put("Bh", 283);
    freq.put("Bi", 359);
    freq.put("Bu", 657);
    freq.put("Bw", 425);
    freq.put("Br", 3063);
    freq.put("By", 401);
    freq.put("hy\u0302", 72);
    freq.put("hu\u0304", 85);
    freq.put("yh", 854);
    freq.put("B ", 244);
    freq.put("U ", 156);
    freq.put("swi", 39);
    freq.put("Ut", 49);
    freq.put("Uw", 129);
    freq.put("Ur", 136);
    freq.put("Ul", 77);
    freq.put("e\u0302n ", 981);
    freq.put("dul", 211);
    freq.put("Uc", 2348);
    freq.put("swl", 42);
    freq.put("pt", 1306);
    freq.put("duo", 40);
    freq.put("dud", 167);
    freq.put("h ", 26458);
    freq.put("eai", 225);
    freq.put("eak", 38);
    freq.put("hy", 13222);
    freq.put("eam", 55);
    freq.put("eal", 663);
    freq.put("ean", 995);
    freq.put("hr", 4162);
    freq.put("hs", 206);
    freq.put("eac", 183);
    freq.put("eae", 48);
    freq.put("ead", 313);
    freq.put("eag", 286);
    freq.put("eaf", 76);
    freq.put("hi", 7126);
    freq.put("hn", 1183);
    freq.put("ho", 8111);
    freq.put("hl", 2073);
    freq.put("hm", 233);
    freq.put("hb", 108);
    freq.put("eas", 85);
    freq.put("ear", 1078);
    freq.put("eau", 164);
    freq.put("eat", 353);
    freq.put("hd", 1537);
    freq.put("he", 14852);
    freq.put("swr", 60);
    freq.put("lso", 43);
    freq.put("te", 8913);
    freq.put("hn ", 464);
    freq.put("Jr ", 44);
    freq.put(" Ut", 49);
    freq.put(" Uw", 129);
    freq.put(" Ur", 136);
    freq.put(" Ul", 77);
    freq.put(" Un", 2470);
    freq.put("Lun", 66);
    freq.put("\u0438\u0306 ", 51);
    freq.put(" Uc", 2348);
    freq.put("rqu", 38);
    freq.put("ho\u0302", 55);
    freq.put("ha\u0302", 88);
    freq.put("ha\u0301", 37);
    freq.put("hna", 273);
    freq.put("hne", 101);
    freq.put("hni", 112);
    freq.put("hno", 169);
    freq.put("aud", 91);
    freq.put("aug", 56);
    freq.put("aul", 281);
    freq.put("up ", 41);
    freq.put("aun", 217);
    freq.put("aus", 70);
    freq.put("Rws", 463);
    freq.put("aut", 123);
    freq.put("w\u0302l ", 39);
    freq.put("Joh", 529);
    freq.put("au ", 18148);
    freq.put("upi", 63);
    freq.put("e\u0308", 206);
    freq.put("upe", 58);
    freq.put("me ", 239);
    freq.put("nen", 226);
    freq.put("Pum", 82);
    freq.put("nel", 633);
    freq.put("nem", 48);
    freq.put("nei", 264);
    freq.put("nef", 63);
    freq.put("neg", 4193);
    freq.put("ned", 7692);
    freq.put("Pug", 63);
    freq.put("neb", 716);
    freq.put("nec", 67);
    freq.put("nea", 151);
    freq.put("ney", 242);
    freq.put("dr ", 1131);
    freq.put("net", 231);
    freq.put("neu", 7331);
    freq.put("ner", 1242);
    freq.put("nes", 2270);
    freq.put("Pur", 41);
    freq.put("med", 792);
    freq.put("\u0443", 60);
    freq.put("mea", 488);
    freq.put("mel", 276);
    freq.put("men", 1156);
    freq.put("mei", 882);
    freq.put("met", 1049);
    freq.put("mew", 2214);
    freq.put("mes", 747);
    freq.put("mer", 2496);
    freq.put("mey", 41);
    freq.put("dry", 370);
    freq.put("Ffy", 47);
    freq.put("Ffu", 103);
    freq.put("dru", 89);
    freq.put("Ffr", 1430);
    freq.put("drw", 337);
    freq.put("Ffo", 187);
    freq.put("Ffl", 265);
    freq.put("Ffi", 428);
    freq.put("dra", 2006);
    freq.put("Ffe", 213);
    freq.put("dre", 2155);
    freq.put("Ffa", 46);
    freq.put("St ", 109);
    freq.put("lwy", 4971);
    freq.put("lwr", 546);
    freq.put("lws", 76);
    freq.put("\u0930", 40);
    freq.put("lwi", 478);
    freq.put("lwn", 220);
    freq.put("lwm", 69);
    freq.put("lwb", 141);
    freq.put("lwc", 190);
    freq.put("lwa", 59);
    freq.put("lwg", 148);
    freq.put("lwe", 381);
    freq.put("Ste", 342);
    freq.put("Sta", 278);
    freq.put("Sto", 284);
    freq.put("Sti", 42);
    freq.put("Stu", 76);
    freq.put("Tir", 127);
    freq.put("Str", 352);
    freq.put("V", 1175);
    freq.put("Til", 75);
    freq.put("rio", 1986);
    freq.put("lw ", 187);
    freq.put("yge", 40);
    freq.put("Lia", 147);
    freq.put("Lib", 127);
    freq.put("ygo", 197);
    freq.put("Lim", 38);
    freq.put("Lin", 147);
    freq.put("ygl", 131);
    freq.put("ygi", 282);
    freq.put("Lit", 62);
    freq.put("ov ", 55);
    freq.put("ygr", 629);
    freq.put("ygy", 125);
    freq.put("Rhy", 836);
    freq.put("Rhu", 416);
    freq.put("Kan", 77);
    freq.put("Al ", 98);
    freq.put("Kas", 44);
    freq.put("Kar", 90);
    freq.put("Rho", 422);
    freq.put("Kat", 68);
    freq.put("Rha", 817);
    freq.put("Rhe", 292);
    freq.put(" sa", 1147);
    freq.put("yg ", 747);
    freq.put("ova", 45);
    freq.put("ove", 172);
    freq.put("ovi", 136);
    freq.put("All", 174);
    freq.put("Alm", 666);
    freq.put("Ali", 71);
    freq.put("Alf", 52);
    freq.put("Alg", 86);
    freq.put("Ale", 206);
    freq.put("Alb", 3548);
    freq.put("Ala", 129);
    freq.put("Alu", 44);
    freq.put("Alp", 112);
    freq.put("Ymr", 46);
    freq.put("Yma", 48);
    freq.put("Yme", 273);
    freq.put("Ymd", 103);
    freq.put("Ymg", 39);
    freq.put("Yml", 71);
    freq.put("\u03c1", 107);
    freq.put("Ym ", 65);
    freq.put("Wor", 81);
    freq.put("Woo", 67);
    freq.put("SS ", 37);
    freq.put("Wob", 86);
    freq.put("is ", 2910);
    freq.put("\u0643", 45);
    freq.put("isy", 118);
    freq.put("iss", 179);
    freq.put("isw", 48);
    freq.put("ist", 1922);
    freq.put("isi", 1027);
    freq.put("ish", 225);
    freq.put("iso", 170);
    freq.put("isn", 521);
    freq.put("ism", 50);
    freq.put("isl", 41);
    freq.put("isc", 102);
    freq.put("isb", 45);
    freq.put("isa", 207);
    freq.put("isg", 710);
    freq.put("ise", 398);
    freq.put("isd", 236);
    freq.put("gy ", 41);
    freq.put("gyf", 2828);
    freq.put("gyd", 2260);
    freq.put("gyb", 143);
    freq.put("gyn", 1911);
    freq.put("gym", 698);
    freq.put("gyl", 394);
    freq.put("gyh", 327);
    freq.put("gyw", 46);
    freq.put("gyt", 130);
    freq.put("gys", 648);
    freq.put("e\u0302l ", 267);
    freq.put("ty ", 569);
    freq.put("do ", 972);
    freq.put("a\u0304n", 56);
    freq.put("tyl", 97);
    freq.put("tym", 66);
    freq.put("tyn", 537);
    freq.put("tyd", 81);
    freq.put("tyf", 106);
    freq.put("tyw", 139);
    freq.put("typ", 46);
    freq.put("tyr", 569);
    freq.put("tys", 55);
    freq.put("don", 2366);
    freq.put("dol", 5215);
    freq.put("dom", 277);
    freq.put("doc", 100);
    freq.put("m", 70473);
    freq.put("dog", 979);
    freq.put("dod", 1351);
    freq.put("doe", 1307);
    freq.put("dor", 959);
    freq.put("dos", 197);
    freq.put("dop", 990);
    freq.put("dow", 54);
    freq.put(" We", 1708);
    freq.put(" Wa", 840);
    freq.put(" Wo", 325);
    freq.put(" Wl", 140);
    freq.put(" Wh", 149);
    freq.put(" Wi", 1099);
    freq.put(" Wr", 303);
    freq.put(" Wy", 416);
    freq.put("\u062c", 68);
    freq.put("ba ", 592);
    freq.put("\u03c5", 45);
    freq.put("baw", 50);
    freq.put("bat", 176);
    freq.put("bau", 111);
    freq.put("bar", 2113);
    freq.put("bas", 114);
    freq.put("bag", 40);
    freq.put("bad", 90);
    freq.put("bae", 396);
    freq.put("bab", 43);
    freq.put("bac", 337);
    freq.put("ban", 3482);
    freq.put("bal", 155);
    freq.put("bai", 223);
    freq.put("Efy", 881);
    freq.put("om ", 318);
    freq.put("i\u0308o ", 43);
    freq.put("Efr", 172);
    freq.put("Ruf", 288);
    freq.put("un ", 3244);
    freq.put("fn ", 482);
    freq.put("Rus", 66);
    freq.put("Rut", 39);
    freq.put("omb", 125);
    freq.put("oma", 643);
    freq.put("ome", 1050);
    freq.put("omi", 554);
    freq.put("omo", 222);
    freq.put("omm", 137);
    freq.put("Dy\u0302 ", 53);
    freq.put("omp", 83);
    freq.put("Ef ", 107);
    freq.put("omy", 55);
    freq.put("fnu", 70);
    freq.put("uns", 43);
    freq.put("unt", 210);
    freq.put("unw", 94);
    freq.put("uny", 251);
    freq.put("fny", 1148);
    freq.put("fnf", 190);
    freq.put("fne", 58);
    freq.put("fnd", 51);
    freq.put("und", 1356);
    freq.put("une", 2052);
    freq.put("fna", 74);
    freq.put("ung", 102);
    freq.put("fno", 916);
    freq.put("uni", 1229);
    freq.put("fni", 126);
    freq.put("uno", 252);
    freq.put("o\u0301n ", 59);
    freq.put("Ies", 43);
    freq.put("Ieu", 53);
    freq.put("io\u0302", 76);
    freq.put("Iei", 49);
    freq.put("ia\u0302", 71);
    freq.put("oni\u0308", 278);
    freq.put("C ", 911);
    freq.put("Pwy", 112);
    freq.put("Pwl", 49);
    freq.put("mch", 98);
    freq.put("mca", 193);
    freq.put("Ci", 277);
    freq.put("Ch", 2757);
    freq.put("Co", 2666);
    freq.put("Cn", 42);
    freq.put("Cl", 935);
    freq.put("Ca", 7250);
    freq.put("Ce", 3498);
    freq.put("Cy", 7372);
    freq.put("slo", 45);
    freq.put("sli", 58);
    freq.put("wdi", 51);
    freq.put("Cr", 1941);
    freq.put("Cw", 585);
    freq.put("sla", 296);
    freq.put("Cu", 272);
    freq.put("iy", 334);
    freq.put("ix", 147);
    freq.put("iz", 277);
    freq.put("o\u0304 ", 54);
    freq.put("Nad", 69);
    freq.put("iq", 80);
    freq.put("ip", 837);
    freq.put("is", 9056);
    freq.put("ir", 24552);
    freq.put("Nan", 259);
    freq.put("it", 12154);
    freq.put("iw", 5398);
    freq.put("iv", 491);
    freq.put("Nar", 52);
    freq.put("ih", 218);
    freq.put("ik", 308);
    freq.put("ij", 103);
    freq.put("im", 1505);
    freq.put("il", 12119);
    freq.put("io", 13225);
    freq.put("in", 29957);
    freq.put("ia", 26223);
    freq.put("ic", 5942);
    freq.put("ki ", 114);
    freq.put("ie", 4390);
    freq.put("id", 14418);
    freq.put("ig", 11702);
    freq.put("if", 9533);
    freq.put("V ", 167);
    freq.put("kis", 60);
    freq.put("kin", 180);
    freq.put("kil", 38);
    freq.put("i ", 38903);
    freq.put("Va", 335);
    freq.put("Ve", 206);
    freq.put("Ca\u0302", 42);
    freq.put("Vo", 87);
    freq.put("Co\u0302", 47);
    freq.put("nk ", 137);
    freq.put("op ", 681);
    freq.put("yer", 49);
    freq.put("Ar ", 131);
    freq.put("opt", 1017);
    freq.put("opu", 42);
    freq.put("opr", 39);
    freq.put("ye ", 65);
    freq.put("ope", 333);
    freq.put("opa", 4605);
    freq.put("opl", 66);
    freq.put("opo", 179);
    freq.put("oph", 125);
    freq.put("opi", 77);
    freq.put("Art", 218);
    freq.put("Arw", 129);
    freq.put("i\u0308", 652);
    freq.put("Ara", 645);
    freq.put("Arb", 38);
    freq.put("Arc", 172);
    freq.put("Ard", 330);
    freq.put("Are", 81);
    freq.put("Arf", 161);
    freq.put("Arg", 192);
    freq.put("Ari", 157);
    freq.put("Ark", 49);
    freq.put("Arl", 228);
    freq.put("Arm", 93);
    freq.put("\u0627\u0646 ", 40);
    freq.put("Z", 358);
    freq.put("iqu", 69);
    freq.put("nki", 55);
    freq.put("\u0441\u043a", 52);
    freq.put("Wic", 114);
    freq.put("Win", 87);
    freq.put("Wil", 763);
    freq.put("di ", 5212);
    freq.put("\u0634", 46);
    freq.put("eru", 112);
    freq.put("Gw\u0302", 111);
    freq.put("dil", 392);
    freq.put("dim", 202);
    freq.put("din", 4906);
    freq.put("dio", 2802);
    freq.put("did", 295);
    freq.put("die", 231);
    freq.put("dif", 421);
    freq.put("dig", 3101);
    freq.put("dia", 3817);
    freq.put("dib", 66);
    freq.put("dic", 115);
    freq.put("dit", 87);
    freq.put("diu", 39);
    freq.put("diw", 2623);
    freq.put("dip", 63);
    freq.put("dir", 4606);
    freq.put("dis", 563);
    freq.put("Gru", 159);
    freq.put(" Ym", 722);
    freq.put(" Yn", 2049);
    freq.put(" Yo", 129);
    freq.put(" Ya", 90);
    freq.put(" Ye", 72);
    freq.put("Gre", 610);
    freq.put("Gra", 555);
    freq.put("Gro", 691);
    freq.put(" Yr", 658);
    freq.put(" Ys", 1224);
    freq.put(" Yu", 65);
    freq.put("Gri", 267);
    freq.put("tne", 85);
    freq.put("bo ", 73);
    freq.put(" Y ", 1307);
    freq.put("tno", 155);
    freq.put("Tud", 152);
    freq.put("hbe", 70);
    freq.put("bor", 263);
    freq.put("bos", 79);
    freq.put("bot", 170);
    freq.put("bou", 98);
    freq.put("bol", 373);
    freq.put("bon", 391);
    freq.put("bob", 1364);
    freq.put("bod", 1326);
    freq.put("\u4e21 ", 46);
    freq.put("oo ", 37);
    freq.put("AU ", 49);
    freq.put("ayn", 40);
    freq.put("i\u0302l", 47);
    freq.put("i\u0302m", 141);
    freq.put("i\u0302n", 138);
    freq.put("aye", 44);
    freq.put("aya", 127);
    freq.put("fl ", 121);
    freq.put("ul ", 450);
    freq.put("ays", 51);
    freq.put("ood", 178);
    freq.put("Bei", 579);
    freq.put("Ben", 733);
    freq.put("Bel", 274);
    freq.put("Roi", 127);
    freq.put("oom", 107);
    freq.put("ool", 124);
    freq.put("Bea", 150);
    freq.put("Bed", 337);
    freq.put("oot", 121);
    freq.put("oor", 76);
    freq.put("Ber", 402);
    freq.put("Bet", 175);
    freq.put("fly", 274);
    freq.put("uly", 76);
    freq.put("i\u0302 ", 61);
    freq.put("flu", 96);
    freq.put("ay ", 572);
    freq.put("flw", 1207);
    freq.put("ulu", 685);
    freq.put("fli", 205);
    freq.put("ulh", 41);
    freq.put("uli", 246);
    freq.put("ulo", 75);
    freq.put("flo", 137);
    freq.put("fla", 336);
    freq.put("ula", 311);
    freq.put("fle", 446);
    freq.put("uld", 43);
    freq.put("ule", 57);
    freq.put("Grw\u0302", 144);
    freq.put("ma ", 1637);
    freq.put("nyr", 93);
    freq.put("nys", 1816);
    freq.put("Pyr", 65);
    freq.put("nyw", 409);
    freq.put("nyt", 58);
    freq.put("nyn", 289);
    freq.put("nym", 173);
    freq.put("nyb", 39);
    freq.put("nyc", 85);
    freq.put("nyf", 51);
    freq.put("nyd", 8463);
    freq.put("Urd", 80);
    freq.put("map", 57);
    freq.put("mas", 453);
    freq.put("sne", 3482);
    freq.put("mau", 1430);
    freq.put("mat", 779);
    freq.put("maw", 438);
    freq.put("sna", 146);
    freq.put("sni", 454);
    freq.put("mac", 103);
    freq.put("mab", 110);
    freq.put("mae", 4308);
    freq.put("mad", 228);
    freq.put("mag", 118);
    freq.put("mai", 606);
    freq.put("mam", 99);
    freq.put("mal", 309);
    freq.put("man", 1111);
    freq.put("Edm", 38);
    freq.put("q", 393);
    freq.put("Edw", 243);
    freq.put("ny ", 647);
    freq.put("Nge", 64);
    freq.put("lse", 40);
    freq.put("lsa", 39);
    freq.put("ho\u0302n", 42);
    freq.put("Ngo", 144);
    freq.put("Ngh", 1380);
    freq.put("lsh", 144);
    freq.put("lst", 89);
    freq.put("Ngw", 317);
    freq.put(" ab", 262);
    freq.put(" ac", 6621);
    freq.put(" ad", 2600);
    freq.put(" ae", 587);
    freq.put(" af", 757);
    freq.put(" ag", 1206);
    freq.put(" ai", 1226);
    freq.put(" al", 881);
    freq.put(" am", 4335);
    freq.put(" an", 2101);
    freq.put(" ap", 337);
    freq.put(" ar", 16211);
    freq.put(" as", 456);
    freq.put(" at", 1462);
    freq.put("\u0434", 81);
    freq.put(" aw", 854);
    freq.put("ls ", 154);
    freq.put("enw", 7750);
    freq.put("Sha", 163);
    freq.put("She", 116);
    freq.put("Shi", 200);
    freq.put("Sho", 72);
    freq.put(" a ", 25270);
    freq.put("Luc", 59);
    freq.put("or ", 3226);
    freq.put("Ken", 91);
    freq.put("Kel", 37);
    freq.put("Dy\u0302", 53);
    freq.put("Ker", 43);
    freq.put("G", 20345);
    freq.put("ory", 220);
    freq.put("orw", 1133);
    freq.put("ort", 1200);
    freq.put("oru", 96);
    freq.put("orr", 343);
    freq.put("ors", 432);
    freq.put("orp", 53);
    freq.put("orn", 345);
    freq.put("oro", 694);
    freq.put("orl", 3097);
    freq.put("orm", 633);
    freq.put("ork", 80);
    freq.put("ori", 1436);
    freq.put("orf", 1329);
    freq.put("org", 734);
    freq.put("ord", 2956);
    freq.put("ore", 929);
    freq.put("orb", 51);
    freq.put("orc", 174);
    freq.put("ora", 612);
    freq.put("App", 76);
    freq.put("Apo", 76);
    freq.put("ua ", 2061);
    freq.put("law", 1750);
    freq.put("iw ", 670);
    freq.put("Do", 759);
    freq.put("cm", 48);
    freq.put("Dh", 64);
    freq.put("Di", 1824);
    freq.put("Dd", 958);
    freq.put("De", 2160);
    freq.put("Da", 2498);
    freq.put("2", 91);
    freq.put("Dy", 1018);
    freq.put("Dw", 249);
    freq.put("Du", 804);
    freq.put("Dr", 592);
    freq.put("iwg", 119);
    freq.put("iwe", 1260);
    freq.put("iwd", 40);
    freq.put("iwc", 99);
    freq.put("iwb", 73);
    freq.put("iwa", 49);
    freq.put("iwn", 438);
    freq.put("iwm", 233);
    freq.put("iwl", 119);
    freq.put("iwi", 130);
    freq.put("iwt", 68);
    freq.put("iws", 49);
    freq.put("iwr", 950);
    freq.put("iwy", 1090);
    freq.put("D ", 151);
    freq.put("ge ", 527);
    freq.put("Lli", 81);
    freq.put("We", 1710);
    freq.put("Wa", 840);
    freq.put("Wo", 329);
    freq.put("Wl", 140);
    freq.put("Wi", 1101);
    freq.put("Wh", 150);
    freq.put("\u0430", 295);
    freq.put("Wr", 303);
    freq.put("Wy", 417);
    freq.put("ges", 210);
    freq.put("ger", 2409);
    freq.put("get", 83);
    freq.put("geg", 490);
    freq.put("gef", 158);
    freq.put("ged", 221);
    freq.put("gei", 2736);
    freq.put("gen", 960);
    freq.put("gem", 288);
    freq.put("gel", 883);
    freq.put("W ", 83);
    freq.put("o\u0301", 166);
    freq.put("tu ", 359);
    freq.put("j ", 48);
    freq.put("ain", 6784);
    freq.put("\u0647", 67);
    freq.put("ju", 54);
    freq.put("tur", 1378);
    freq.put("tus", 150);
    freq.put("jo", 72);
    freq.put("ji", 138);
    freq.put("tun", 319);
    freq.put("je", 73);
    freq.put("tud", 365);
    freq.put("ja", 217);
    freq.put("wa\u0302r", 55);
    freq.put("tum", 55);
    freq.put("Lla", 2896);
    freq.put("cla", 175);
    freq.put("tua", 1979);
    freq.put("E\u0301", 51);
    freq.put("hdr", 51);
    freq.put("hde", 1261);
    freq.put("hda", 91);
    freq.put("oi ", 372);
    freq.put("pap", 107);
    freq.put("par", 781);
    freq.put("pas", 659);
    freq.put("pat", 75);
    freq.put("pau", 82);
    freq.put(" bw", 689);
    freq.put("pac", 45);
    freq.put("pai", 175);
    freq.put("pal", 108);
    freq.put("pan", 983);
    freq.put("pao", 47);
    freq.put("oin", 128);
    freq.put("nac", 478);
    freq.put("oid", 128);
    freq.put("oic", 86);
    freq.put("oit", 58);
    freq.put("ois", 279);
    freq.put("oir", 340);
    freq.put("pa ", 4575);
    freq.put("mo ", 102);
    freq.put("mos", 228);
    freq.put("mor", 527);
    freq.put("mou", 82);
    freq.put("mot", 129);
    freq.put("mon", 1356);
    freq.put("mol", 107);
    freq.put("moc", 146);
    freq.put("moe", 79);
    freq.put("mod", 296);
    freq.put("km2", 84);
    freq.put("Ebr", 548);
    freq.put("Neo", 67);
    freq.put("Ned", 55);
    freq.put("Nev", 46);
    freq.put("Dr ", 38);
    freq.put("Neu", 46);
    freq.put("Nep", 47);
    freq.put("Med", 618);
    freq.put(" ch", 4604);
    freq.put(" ci", 218);
    freq.put("Mea", 441);
    freq.put(" co", 4045);
    freq.put(" cl", 534);
    freq.put(" cm", 41);
    freq.put("Mel", 122);
    freq.put("Men", 120);
    freq.put("Mei", 183);
    freq.put("Meh", 551);
    freq.put(" ce", 1490);
    freq.put("Meu", 40);
    freq.put("Met", 107);
    freq.put("Mew", 209);
    freq.put(" cy", 8555);
    freq.put("Mes", 98);
    freq.put("Mer", 331);
    freq.put(" cr", 1706);
    freq.put("Mex", 110);
    freq.put(" cu", 135);
    freq.put("Dry", 63);
    freq.put("\u0447", 59);
    freq.put("Dru", 57);
    freq.put("Ne ", 182);
    freq.put("Dri", 53);
    freq.put("Dro", 45);
    freq.put("Dra", 145);
    freq.put("Dre", 173);
    freq.put("km ", 586);
    freq.put(" c ", 146);
    freq.put("w\u0302", 1259);
    freq.put("Ac", 626);
    freq.put("Ae", 324);
    freq.put("Avo", 40);
    freq.put("re\u0308w", 49);
    freq.put("Az", 66);
    freq.put("ge\u0302m", 78);
    freq.put("u", 84011);
    freq.put("Vai", 45);
    freq.put("Van", 61);
    freq.put("Val", 137);
    freq.put("edf", 354);
    freq.put("hy ", 169);
    freq.put("ws ", 798);
    freq.put("\u0438", 260);
    freq.put("ium", 95);
    freq.put("ius", 367);
    freq.put("wsa", 63);
    freq.put("hyb", 55);
    freq.put("hyc", 428);
    freq.put("hyd", 3013);
    freq.put("hyf", 1088);
    freq.put("hyg", 114);
    freq.put("hyh", 50);
    freq.put("hyl", 212);
    freq.put("hym", 1892);
    freq.put("hyn", 4010);
    freq.put("hyr", 987);
    freq.put("hys", 337);
    freq.put("hyt", 162);
    freq.put("wst", 1039);
    freq.put("hyw", 645);
    freq.put("aba", 276);
    freq.put("gl", 7224);
    freq.put("abe", 698);
    freq.put("abh", 50);
    freq.put("abi", 212);
    freq.put("abl", 167);
    freq.put("abo", 216);
    freq.put("\u0430 ", 68);
    freq.put("abw", 100);
    freq.put("aby", 812);
    freq.put("K", 1955);
    freq.put("gga", 62);
    freq.put("ab ", 524);
    freq.put("a\u0300", 109);
    freq.put("fwn", 147);
    freq.put("fwy", 1473);
    freq.put("fwr", 292);
    freq.put("eye", 40);
    freq.put("eyd", 96);
    freq.put("twr", 164);
    freq.put("tws", 164);
    freq.put("eys", 88);
    freq.put("eyr", 966);
    freq.put("de ", 2554);
    freq.put("twy", 340);
    freq.put("ey ", 759);
    freq.put("dep", 41);
    freq.put("der", 2766);
    freq.put("des", 358);
    freq.put("det", 47);
    freq.put("deu", 912);
    freq.put("dew", 315);
    freq.put("deh", 309);
    freq.put("dei", 1883);
    freq.put("del", 971);
    freq.put("dem", 336);
    freq.put("den", 795);
    freq.put("deo", 150);
    freq.put("dea", 111);
    freq.put("deb", 1171);
    freq.put("dec", 320);
    freq.put("ded", 492);
    freq.put("dee", 65);
    freq.put("def", 1498);
    freq.put("deg", 755);
    freq.put("Vin", 38);
    freq.put("ryn", 2332);
    freq.put("ryl", 141);
    freq.put("rym", 301);
    freq.put("csi", 110);
    freq.put("Tyd", 45);
    freq.put("ryg", 165);
    freq.put("ryd", 2082);
    freq.put("csa", 239);
    freq.put("ryc", 824);
    freq.put("ryw", 1557);
    freq.put("ryt", 114);
    freq.put("Tyw", 284);
    freq.put("ryr", 190);
    freq.put("rys", 874);
    freq.put("Don", 111);
    freq.put("Dol", 168);
    freq.put("Dom", 58);
    freq.put("Doc", 73);
    freq.put("Dor", 76);
    freq.put("Dow", 41);
    freq.put("Dou", 83);
    freq.put("P", 10920);
    freq.put("cs ", 78);
    freq.put("ry ", 1037);
    freq.put("hfa", 83);
    freq.put("hfe", 111);
    freq.put("ok ", 75);
    freq.put("Bat", 87);
    freq.put("Bar", 705);
    freq.put("Bas", 189);
    freq.put("uha", 41);
    freq.put("Bay", 40);
    freq.put("Baf", 40);
    freq.put("Bad", 45);
    freq.put("Bae", 152);
    freq.put("Bab", 49);
    freq.put("Bac", 149);
    freq.put("Ban", 571);
    freq.put("Bal", 342);
    freq.put("Bai", 38);
    freq.put("ro\u0302l", 105);
    freq.put("Un ", 695);
    freq.put("E ", 255);
    freq.put("sbr", 83);
    freq.put("mmy", 53);
    freq.put("sbu", 82);
    freq.put("mmu", 54);
    freq.put("sby", 154);
    freq.put("A\u0300it", 437);
    freq.put("\u044f", 41);
    freq.put("mmo", 59);
    freq.put("sba", 268);
    freq.put("Und", 296);
    freq.put("Une", 566);
    freq.put("sbe", 72);
    freq.put("mme", 106);
    freq.put("Uni", 136);
    freq.put("sbi", 64);
    freq.put("mma", 119);
    freq.put("sbo", 63);
    freq.put("Uno", 738);
    freq.put("Em", 230);
    freq.put("El", 634);
    freq.put("En", 1155);
    freq.put("Ei", 1604);
    freq.put("Ed", 412);
    freq.put("Eg", 302);
    freq.put("Ef", 1230);
    freq.put("Ea", 170);
    freq.put("Ec", 68);
    freq.put("Eb", 590);
    freq.put("Ex", 44);
    freq.put("Eu", 257);
    freq.put("Et", 355);
    freq.put("Ew", 725);
    freq.put("Ev", 184);
    freq.put("Ep", 63);
    freq.put("Es", 277);
    freq.put("Er", 1074);
    freq.put(" el", 685);
    freq.put(" em", 89);
    freq.put(" en", 8086);
    freq.put(" eh", 46);
    freq.put(" ei", 5329);
    freq.put(" ed", 232);
    freq.put("X ", 53);
    freq.put(" eg", 690);
    freq.put(" ea", 139);
    freq.put(" ec", 224);
    freq.put(" et", 513);
    freq.put(" eu", 1065);
    freq.put(" ew", 44);
    freq.put(" ep", 59);
    freq.put(" er", 1863);
    freq.put(" es", 187);
    freq.put("Slo", 44);
    freq.put("Sla", 57);
    freq.put("b", 42206);
    freq.put("ko ", 44);
    freq.put(" e ", 202);
    freq.put("k ", 1329);
    freq.put("Kin", 187);
    freq.put("Kil", 92);
    freq.put("Atl", 65);
    freq.put("Ath", 193);
    freq.put("ka", 582);
    freq.put("ke", 713);
    freq.put("kk", 45);
    freq.put("ki", 563);
    freq.put("kh", 206);
    freq.put("ko", 255);
    freq.put("kn", 46);
    freq.put("km", 709);
    freq.put("kl", 117);
    freq.put("ks", 215);
    freq.put("kr", 68);
    freq.put("ku", 123);
    freq.put("ky", 143);
    freq.put("re\u0301g", 55);
    freq.put("Ope", 42);
    freq.put("w\u0302y", 196);
    freq.put("w\u0302p", 443);
    freq.put("w\u0302r", 393);
    freq.put("w\u0302l", 41);
    freq.put("w\u0302n", 87);
    freq.put("ph", 2260);
    freq.put(" Be", 2802);
    freq.put(" Ba", 2550);
    freq.put(" Bl", 695);
    freq.put(" Bo", 944);
    freq.put(" Bi", 359);
    freq.put(" Bh", 283);
    freq.put(" Bu", 657);
    freq.put(" Bw", 425);
    freq.put("ik ", 64);
    freq.put(" Br", 3059);
    freq.put(" By", 399);
    freq.put("\u0430\u043d", 37);
    freq.put("\u03ba", 64);
    freq.put(" B ", 201);
    freq.put("ika", 52);
    freq.put("ike", 47);
    freq.put("fi\u0302n", 104);
    freq.put("iki", 37);
    freq.put("iko", 49);
    freq.put("ga ", 202);
    freq.put("\u4e09", 165);
    freq.put("fu ", 398);
    freq.put("gaw", 58);
    freq.put("gau", 316);
    freq.put("gat", 114);
    freq.put("gas", 141);
    freq.put("gar", 1053);
    freq.put("gap", 38);
    freq.put("gan", 8980);
    freq.put("gam", 111);
    freq.put("gal", 587);
    freq.put("gai", 1331);
    freq.put("gaf", 171);
    freq.put("gae", 2618);
    freq.put("gad", 298);
    freq.put("gac", 62);
    freq.put("lba", 3961);
    freq.put("fur", 1066);
    freq.put("fus", 43);
    freq.put("fug", 165);
    freq.put("fud", 244);
    freq.put("fun", 259);
    freq.put("lbe", 138);
    freq.put("ful", 86);
    freq.put("sy ", 6998);
    freq.put("Ira", 166);
    freq.put("\u0421", 45);
    freq.put("ewi", 3673);
    freq.put("ewo", 68);
    freq.put("ewn", 2724);
    freq.put("ewa", 76);
    freq.put("ewe", 71);
    freq.put("ewy", 1561);
    freq.put("ews", 78);
    freq.put("ewr", 200);
    freq.put("syc", 54);
    freq.put("dga", 45);
    freq.put("syd", 2408);
    freq.put("cea", 95);
    freq.put("syn", 267);
    freq.put("sym", 497);
    freq.put("syl", 933);
    freq.put("dgr", 60);
    freq.put("syt", 47);
    freq.put("ew ", 378);
    freq.put("y", 272195);
    freq.put("lda", 44);
    freq.put("lde", 318);
    freq.put("ldi", 2042);
    freq.put("wie", 106);
    freq.put("bi ", 299);
    freq.put("lds", 45);
    freq.put("ldr", 142);
    freq.put("ldw", 120);
    freq.put("rgr", 243);
    freq.put("cus", 119);
    freq.put("rgu", 68);
    freq.put("rgw", 86);
    freq.put("rgy", 156);
    freq.put("rga", 737);
    freq.put("cud", 84);
    freq.put("rge", 464);
    freq.put("rgh", 39);
    freq.put("rgi", 149);
    freq.put("cul", 125);
    freq.put("rgl", 177);
    freq.put("rgo", 165);
    freq.put("bin", 244);
    freq.put("bio", 221);
    freq.put("Din", 930);
    freq.put("ld ", 464);
    freq.put("cem", 115);
    freq.put("big", 37);
    freq.put("bid", 38);
    freq.put("Dig", 90);
    freq.put("Dia", 78);
    freq.put("Dic", 59);
    freq.put("biw", 40);
    freq.put("bit", 41);
    freq.put("Diw", 144);
    freq.put("bir", 39);
    freq.put("Dir", 57);
    freq.put("Dis", 198);
    freq.put("aph", 68);
    freq.put("rg ", 415);
    freq.put("wis", 414);
    freq.put("Kno", 77);
    freq.put("c\u0327o", 37);
    freq.put("oe ", 182);
    freq.put(" gw\u0302", 50);
    freq.put("pet", 177);
    freq.put("per", 2223);
    freq.put("pes", 77);
    freq.put("pel", 255);
    freq.put("pen", 982);
    freq.put("pei", 78);
    freq.put("ped", 316);
    freq.put("cei", 440);
    freq.put("pea", 218);
    freq.put("pec", 49);
    freq.put("ufe", 472);
    freq.put("oes", 1111);
    freq.put("oer", 92);
    freq.put("Bor", 128);
    freq.put("Bos", 53);
    freq.put("Bou", 115);
    freq.put("O", 5361);
    freq.put("oet", 190);
    freq.put(" o\u0302l", 1443);
    freq.put("Bol", 50);
    freq.put("oen", 118);
    freq.put("Bon", 223);
    freq.put("oel", 498);
    freq.put("oea", 48);
    freq.put("oeg", 1830);
    freq.put("oed", 13126);
    freq.put("\u03c2 ", 162);
    freq.put("a\u0308", 70);
    freq.put("usn", 82);
    freq.put("pe ", 114);
    freq.put("Hun", 62);
    freq.put("nsh", 86);
    freq.put("nsi", 297);
    freq.put("nsk", 44);
    freq.put("nsl", 63);
    freq.put("nso", 522);
    freq.put("nsa", 259);
    freq.put("nsc", 44);
    freq.put("nse", 102);
    freq.put("nsg", 81);
    freq.put("nsy", 58);
    freq.put("ush", 85);
    freq.put("nst", 197);
    freq.put("nsw", 86);
    freq.put("ust", 299);
    freq.put(" ga\u0302", 47);
    freq.put("uss", 159);
    freq.put(" ge\u0302", 83);
    freq.put("sdr", 221);
    freq.put("ns ", 965);
    freq.put("sdy", 51);
    freq.put("sda", 48);
    freq.put("Flo", 39);
    freq.put("Fla", 61);
    freq.put("Fle", 45);
    freq.put("sdi", 60);
    freq.put("lyt", 263);
    freq.put("lyw", 939);
    freq.put("lyr", 52);
    freq.put("lys", 623);
    freq.put("lyd", 945);
    freq.put("lyf", 715);
    freq.put("lyg", 1379);
    freq.put("lyb", 68);
    freq.put("lyc", 94);
    freq.put("lym", 387);
    freq.put("lyn", 3191);
    freq.put("Nyf", 95);
    freq.put(" gw", 7430);
    freq.put("Mas", 96);
    freq.put("Mar", 903);
    freq.put(" gr", 2189);
    freq.put("Mat", 309);
    freq.put("Maw", 799);
    freq.put("May", 55);
    freq.put("Max", 37);
    freq.put(" gy", 7787);
    freq.put("Mac", 250);
    freq.put(" ge", 5478);
    freq.put("Mae", 10140);
    freq.put("Mad", 118);
    freq.put("Mag", 89);
    freq.put(" ga", 9934);
    freq.put("Mai", 677);
    freq.put(" go", 7824);
    freq.put(" gl", 929);
    freq.put("Mam", 89);
    freq.put("Mal", 270);
    freq.put("Mao", 42);
    freq.put(" gi", 324);
    freq.put("ly ", 477);
    freq.put(" cn", 41);
    freq.put("Mec", 52);
    freq.put(" b", 14900);
    freq.put(" c", 26227);
    freq.put(" a", 65561);
    freq.put(" f", 18797);
    freq.put(" g", 42173);
    freq.put(" d", 30278);
    freq.put(" e", 20097);
    freq.put(" j", 98);
    freq.put(" k", 864);
    freq.put(" h", 11620);
    freq.put(" i", 18800);
    freq.put(" n", 29792);
    freq.put(" o", 33276);
    freq.put(" l", 10735);
    freq.put(" m", 19257);
    freq.put(" r", 34831);
    freq.put(" s", 19137);
    freq.put(" p", 10362);
    freq.put(" v", 206);
    freq.put(" w", 8138);
    freq.put(" t", 11355);
    freq.put(" u", 7227);
    freq.put(" Dy\u0302", 53);
    freq.put(" y", 105922);
    freq.put(" B", 12669);
    freq.put(" C", 28504);
    freq.put(" A", 20837);
    freq.put(" F", 9117);
    freq.put(" G", 20264);
    freq.put(" D", 11311);
    freq.put(" E", 9519);
    freq.put(" J", 2904);
    freq.put(" K", 1945);
    freq.put(" H", 6645);
    freq.put(" I", 5291);
    freq.put(" N", 7566);
    freq.put(" O", 5351);
    freq.put(" L", 15685);
    freq.put(" M", 24137);
    freq.put(" R", 8770);
    freq.put(" S", 18405);
    freq.put(" P", 10887);
    freq.put(" Q", 329);
    freq.put(" V", 1168);
    freq.put(" W", 5129);
    freq.put(" T", 9888);
    freq.put(" U", 5681);
    freq.put(" Z", 352);
    freq.put(" X", 151);
    freq.put(" Y", 6373);

    init2();
  }
  private static void init2() {
    
    freq.put(" cw", 407);
    freq.put(" a\u0302", 1668);
    freq.put(" o\u0302", 1446);
    freq.put(" A\u0300", 445);
    freq.put(" E\u0301", 45);
    freq.put(" I\u0302", 41);
    freq.put("Orl", 66);
    freq.put("Ori", 47);
    freq.put("Org", 37);
    freq.put("Ora", 40);
    freq.put("ock", 228);
    freq.put(" Do", 753);
    freq.put("Ver", 74);
    freq.put(" Di", 1823);
    freq.put(" Dh", 64);
    freq.put(" De", 2156);
    freq.put(" Dd", 954);
    freq.put(" Da", 2496);
    freq.put("ii ", 78);
    freq.put(" Dy", 1018);
    freq.put(" w\u0302", 72);
    freq.put(" Dw", 249);
    freq.put(" Du", 803);
    freq.put(" Dr", 592);
    freq.put("cha", 3502);
    freq.put("chb", 78);
    freq.put("chd", 1364);
    freq.put("che", 3420);
    freq.put("chf", 102);
    freq.put("chg", 225);
    freq.put("chi", 932);
    freq.put("chl", 1181);
    freq.put("chm", 87);
    freq.put("chn", 386);
    freq.put("cho", 903);
    freq.put("Fa", 1155);
    freq.put("chr", 1036);
    freq.put("chs", 64);
    freq.put("cht", 200);
    freq.put("chu", 496);
    freq.put("Ff", 2731);
    freq.put("chw", 2809);
    freq.put("Fh", 75);
    freq.put("chy", 2533);
    freq.put("Fl", 182);
    freq.put("Fo", 691);
    freq.put(" D ", 49);
    freq.put("ch ", 6978);
    freq.put("f", 102454);
    freq.put("oct", 65);
    freq.put("F ", 59);
    freq.put("afl", 340);
    freq.put("afn", 71);
    freq.put("afo", 1900);
    freq.put("Fo\u0302", 38);
    freq.put("afi", 258);
    freq.put("Yo", 129);
    freq.put("Yn", 2049);
    freq.put("Ya", 90);
    freq.put("afe", 74);
    freq.put("aff", 533);
    freq.put("Ye", 72);
    freq.put("afa", 399);
    freq.put("afb", 52);
    freq.put("afy", 180);
    freq.put("afu", 183);
    freq.put("Ys", 1224);
    freq.put("Yr", 659);
    freq.put("Yu", 66);
    freq.put("afr", 202);
    freq.put("dwr", 1205);
    freq.put("Y ", 1318);
    freq.put("af ", 6324);
    freq.put("da ", 2613);
    freq.put(" Ia\u0302", 58);
    freq.put("lf", 1785);
    freq.put("lg", 727);
    freq.put("euo", 648);
    freq.put("le", 25308);
    freq.put("lb", 4658);
    freq.put("lc", 1274);
    freq.put("tsh", 38);
    freq.put("dwc", 74);
    freq.put("ln", 84);
    freq.put("eud", 983);
    freq.put("eug", 110);
    freq.put("lm", 2285);
    freq.put("eua", 272);
    freq.put("lk", 174);
    freq.put("euc", 47);
    freq.put("eub", 64);
    freq.put("lv", 181);
    freq.put("lw", 7516);
    freq.put("lt", 3355);
    freq.put("lu", 4776);
    freq.put("lr", 78);
    freq.put("ls", 592);
    freq.put("lp", 247);
    freq.put("eut", 118);
    freq.put("euw", 78);
    freq.put("lz", 47);
    freq.put("eus", 156);
    freq.put("eur", 164);
    freq.put("dad", 291);
    freq.put("dae", 1159);
    freq.put("daf", 139);
    freq.put("dag", 237);
    freq.put("dac", 62);
    freq.put("dal", 2984);
    freq.put("dam", 229);
    freq.put("dan", 1183);
    freq.put("dwe", 581);
    freq.put("dai", 3023);
    freq.put("dat", 359);
    freq.put("dau", 3395);
    freq.put("daw", 457);
    freq.put("\u05d5", 50);
    freq.put("dar", 1300);
    freq.put("das", 169);
    freq.put("day", 43);
    freq.put("l ", 44324);
    freq.put("eu ", 7692);
    freq.put("ts ", 407);
    freq.put("dwl", 78);
    freq.put("lfe", 288);
    freq.put("lff", 365);
    freq.put("lfa", 558);
    freq.put("lfo", 118);
    freq.put("lfr", 121);
    freq.put("lfy", 168);
    freq.put("cwy", 42);
    freq.put("rey", 132);
    freq.put("la\u0302", 62);
    freq.put("rer", 65);
    freq.put("res", 1898);
    freq.put("Tur", 62);
    freq.put("cwr", 96);
    freq.put("rev", 41);
    freq.put("rew", 191);
    freq.put("ret", 318);
    freq.put("reu", 562);
    freq.put("lo\u0308", 131);
    freq.put("rek", 37);
    freq.put("lo\u0302", 60);
    freq.put("rei", 2138);
    freq.put("ren", 2559);
    freq.put("reo", 299);
    freq.put("rel", 299);
    freq.put("rem", 807);
    freq.put("reb", 115);
    freq.put("rec", 445);
    freq.put("rea", 724);
    freq.put("cwe", 39);
    freq.put("reg", 1012);
    freq.put("red", 2528);
    freq.put("ree", 306);
    freq.put("bwr", 254);
    freq.put("lf ", 105);
    freq.put("bwy", 699);
    freq.put("qua", 43);
    freq.put("que", 158);
    freq.put("qui", 76);
    freq.put("bwl", 66);
    freq.put("bwm", 84);
    freq.put("re ", 1508);
    freq.put("ud ", 1095);
    freq.put("og ", 4103);
    freq.put("i\u0308ai", 46);
    freq.put("ly\u0302", 175);
    freq.put("i\u0308au", 380);
    freq.put("\u0432", 159);
    freq.put("ogy", 317);
    freq.put("udw", 146);
    freq.put("udu", 77);
    freq.put("ogw", 78);
    freq.put("ogr", 173);
    freq.put("ogl", 3819);
    freq.put("ogo", 455);
    freq.put("uda", 109);
    freq.put("ogi", 448);
    freq.put("udd", 714);
    freq.put("ude", 80);
    freq.put("oge", 298);
    freq.put("ogf", 54);
    freq.put("oga", 1857);
    freq.put("udo", 207);
    freq.put("Pen", 2562);
    freq.put("Pap", 93);
    freq.put("Par", 525);
    freq.put("Pas", 79);
    freq.put("Pat", 108);
    freq.put("Pau", 125);
    freq.put("Pab", 54);
    freq.put("Pac", 49);
    freq.put("Pak", 50);
    freq.put("Pal", 184);
    freq.put("Pan", 158);
    freq.put("mil", 1349);
    freq.put("mio", 78);
    freq.put("min", 367);
    freq.put("mia", 447);
    freq.put("mic", 53);
    freq.put("mie", 110);
    freq.put("mig", 178);
    freq.put("mis", 321);
    freq.put("mir", 63);
    freq.put("mit", 116);
    freq.put("miw", 182);
    freq.put("sfo", 43);
    freq.put("sff", 143);
    freq.put("sfa", 40);
    freq.put("mi ", 264);
    freq.put("Mos", 98);
    freq.put("Mor", 865);
    freq.put(" is", 434);
    freq.put("Mou", 90);
    freq.put("Mot", 83);
    freq.put("Moh", 40);
    freq.put(" il", 42);
    freq.put("Mon", 614);
    freq.put(" in", 191);
    freq.put(" io", 61);
    freq.put("Moc", 42);
    freq.put(" ia", 812);
    freq.put(" id", 384);
    freq.put(" ie", 418);
    freq.put("Moe", 284);
    freq.put("Mod", 56);
    freq.put(" \u0421", 45);
    freq.put("ks ", 103);
    freq.put(" i ", 16205);
    freq.put("di\u0302", 57);
    freq.put(" ia\u0302", 40);
    freq.put(" Ir", 229);
    freq.put(" Is", 832);
    freq.put(" It", 59);
    freq.put("S", 18433);
    freq.put("e\u0300", 159);
    freq.put(" Il", 78);
    freq.put(" Im", 55);
    freq.put(" Fo\u0302", 38);
    freq.put("wp", 170);
    freq.put("ohn", 495);
    freq.put("oho", 221);
    freq.put("uid", 128);
    freq.put("byn", 951);
    freq.put("ys ", 5008);
    freq.put("ai", 28376);
    freq.put(" If", 69);
    freq.put("ohe", 171);
    freq.put("ak", 678);
    freq.put("Hom", 49);
    freq.put("cop", 2154);
    freq.put("uim", 38);
    freq.put("cos", 91);
    freq.put("oha", 89);
    freq.put("cor", 495);
    freq.put("uin", 123);
    freq.put("byd", 1610);
    freq.put("ysi", 788);
    freq.put("yso", 937);
    freq.put("ysl", 39);
    freq.put("ysb", 191);
    freq.put("ysa", 193);
    freq.put("ysg", 2082);
    freq.put("ysf", 43);
    freq.put("yse", 204);
    freq.put("\u0631 ", 53);
    freq.put("ysy", 639);
    freq.put("ar", 38569);
    freq.put("au", 19336);
    freq.put("ysw", 48);
    freq.put("ysu", 113);
    freq.put("yst", 2007);
    freq.put(" Fr", 788);
    freq.put(" Fu", 118);
    freq.put(" Fw", 115);
    freq.put(" Fy", 369);
    freq.put(" Fa", 1154);
    freq.put(" Fe", 2231);
    freq.put(" Ff", 2729);
    freq.put(" Fi", 485);
    freq.put(" Fh", 75);
    freq.put(" Fl", 182);
    freq.put(" Fo", 687);
    freq.put("io ", 4492);
    freq.put("coc", 219);
    freq.put("cob", 38);
    freq.put("wy ", 2968);
    freq.put("cod", 670);
    freq.put("SO ", 61);
    freq.put("iot", 52);
    freq.put("ios", 73);
    freq.put("ior", 107);
    freq.put("iop", 79);
    freq.put("ion", 4410);
    freq.put("iol", 2152);
    freq.put("iog", 969);
    freq.put("ioe", 189);
    freq.put("iod", 501);
    freq.put("ioc", 84);
    freq.put("wyt", 933);
    freq.put("wys", 3904);
    freq.put("wyr", 4356);
    freq.put("wyg", 83);
    freq.put("wyf", 1666);
    freq.put("wyd", 14813);
    freq.put("wyb", 349);
    freq.put("wya", 1824);
    freq.put("wyo", 82);
    freq.put("wyn", 4153);
    freq.put("wym", 72);
    freq.put("con", 391);
    freq.put("wyi", 44);
    freq.put("\u0435\u0440", 44);
    freq.put("adw", 1093);
    freq.put("adu", 1508);
    freq.put("adr", 412);
    freq.put(" \u0645", 63);
    freq.put(" if", 86);
    freq.put("ady", 61);
    freq.put("adf", 220);
    freq.put("adg", 37);
    freq.put("add", 2640);
    freq.put("ade", 1321);
    freq.put("ada", 2456);
    freq.put("adn", 878);
    freq.put("ado", 1424);
    freq.put("adl", 478);
    freq.put("\u043c", 52);
    freq.put("adh", 309);
    freq.put("adi", 858);
    freq.put("fyf", 43);
    freq.put("fyg", 53);
    freq.put("fyd", 4950);
    freq.put(" \u0628", 53);
    freq.put("fyn", 2565);
    freq.put("fyl", 222);
    freq.put("fym", 71);
    freq.put("fyr", 1571);
    freq.put("fys", 392);
    freq.put("fyw", 141);
    freq.put("Hyw", 74);
    freq.put("\u0435\u0432", 40);
    freq.put("ad ", 6988);
    freq.put("nja", 59);
    freq.put("esw", 148);
    freq.put("esu", 390);
    freq.put("est", 1731);
    freq.put("ess", 369);
    freq.put("esp", 56);
    freq.put("esy", 588);
    freq.put("esg", 225);
    freq.put("esf", 58);
    freq.put("ese", 321);
    freq.put("esd", 86);
    freq.put("esc", 62);
    freq.put("esb", 120);
    freq.put("esa", 201);
    freq.put("eso", 767);
    freq.put("esn", 3171);
    freq.put("esm", 38);
    freq.put("esl", 60);
    freq.put("esi", 604);
    freq.put("esh", 104);
    freq.put("Fwy", 63);
    freq.put("OS ", 481);
    freq.put("by ", 89);
    freq.put("es ", 7548);
    freq.put("\u4e09 ", 61);
    freq.put("Twi", 39);
    freq.put("Twr", 136);
    freq.put("De ", 401);
    freq.put("bu ", 507);
    freq.put("Twy", 43);
    freq.put("rcy", 41);
    freq.put("rct", 79);
    freq.put("rcu", 73);
    freq.put("rco", 44);
    freq.put("rch", 2439);
    freq.put("rci", 169);
    freq.put("rce", 170);
    freq.put("rca", 64);
    freq.put("Dey", 467);
    freq.put("bur", 297);
    freq.put("bus", 107);
    freq.put("Der", 96);
    freq.put("Des", 74);
    freq.put("Deu", 61);
    freq.put("but", 37);
    freq.put("Dew", 73);
    freq.put("Deh", 65);
    freq.put("Del", 66);
    freq.put("Dem", 67);
    freq.put("bul", 47);
    freq.put("bum", 71);
    freq.put("Dea", 123);
    freq.put("Dec", 105);
    freq.put("Ded", 67);
    freq.put("bud", 56);
    freq.put("j", 732);
    freq.put("hll", 37);
    freq.put("rc ", 329);
    freq.put("pil", 126);
    freq.put("pin", 161);
    freq.put("pio", 130);
    freq.put("Ryf", 105);
    freq.put("pia", 550);
    freq.put("Ryd", 65);
    freq.put("pid", 1048);
    freq.put("pig", 55);
    freq.put("ub ", 91);
    freq.put("pis", 45);
    freq.put("pit", 95);
    freq.put("oad", 143);
    freq.put("oan", 72);
    freq.put("oat", 50);
    freq.put("ubu", 38);
    freq.put("Aca", 159);
    freq.put("pi ", 55);
    freq.put("Ach", 90);
    freq.put("ube", 47);
    freq.put("uba", 126);
    freq.put("Act", 324);
    freq.put("ubl", 79);
    freq.put("ubh", 79);
    freq.put("oa ", 66);
    freq.put("Boo", 44);
    freq.put("nwr", 453);
    freq.put("nws", 101);
    freq.put("nwy", 4103);
    freq.put("nwe", 332);
    freq.put("nwg", 196);
    freq.put("nwa", 1807);
    freq.put("nwl", 60);
    freq.put("nwo", 499);
    freq.put("nwi", 220);
    freq.put("mwr", 262);
    freq.put("mwy", 1376);
    freq.put("Cro", 352);
    freq.put("mwa", 49);
    freq.put("mwe", 56);
    freq.put("G ", 104);
    freq.put("mwn", 673);
    freq.put("\u0644", 362);
    freq.put("nw ", 6013);
    freq.put("\u05d9", 46);
    freq.put("Gw", 5026);
    freq.put("Gu", 315);
    freq.put("Gr", 2454);
    freq.put("Gy", 1683);
    freq.put("Ge", 2651);
    freq.put("Ga", 3313);
    freq.put("Go", 2441);
    freq.put("Gl", 1637);
    freq.put("Gi", 265);
    freq.put("Gh", 165);
    freq.put(" ke", 53);
    freq.put(" ki", 48);
    freq.put(" km", 670);
    freq.put("e\u0308wy", 48);
    freq.put("wfe", 98);
    freq.put("wd ", 517);
    freq.put("Sba", 324);
    freq.put("\u03c2", 162);
    freq.put("tiu", 49);
    freq.put("aif", 1555);
    freq.put("wdd", 251);
    freq.put("Zi", 43);
    freq.put("wdh", 39);
    freq.put("Ze", 78);
    freq.put("ty", 2334);
    freq.put("Za", 73);
    freq.put("wdu", 669);
    freq.put("wdw", 185);
    freq.put("Zu", 39);
    freq.put("ku ", 48);
    freq.put("m ", 12759);
    freq.put("me", 11191);
    freq.put("md", 1313);
    freq.put("mg", 609);
    freq.put("mf", 130);
    freq.put("ma", 12774);
    freq.put("g", 124045);
    freq.put("mc", 302);
    freq.put("mb", 1263);
    freq.put("mm", 469);
    freq.put("ml", 2070);
    freq.put("mo", 3170);
    freq.put("mn", 407);
    freq.put("mi", 3619);
    freq.put("mh", 1304);
    freq.put("mu", 2756);
    freq.put("mt", 173);
    freq.put("mw", 2666);
    freq.put("mp", 1485);
    freq.put("ms", 740);
    freq.put("mr", 6007);
    freq.put("my", 4653);
    freq.put("ena", 618);
    freq.put("enb", 102);
    freq.put("enc", 514);
    freq.put("end", 929);
    freq.put("ene", 2395);
    freq.put("enf", 555);
    freq.put("eng", 830);
    freq.put("enh", 570);
    freq.put("eni", 1683);
    freq.put("enk", 49);
    freq.put("enl", 180);
    freq.put("enm", 181);
    freq.put("enn", 3626);
    freq.put("eno", 688);
    freq.put("enr", 449);
    freq.put("ens", 549);
    freq.put("ent", 4104);
    freq.put("enu", 97);
    freq.put("m2", 86);
    freq.put("eny", 811);
    freq.put("enz", 60);
    freq.put("II ", 307);
    freq.put("en ", 8133);
    freq.put("ma\u0302", 48);
    freq.put("mo\u0302", 280);
    freq.put(" Hy", 775);
    freq.put(" Hw", 138);
    freq.put(" Hu", 453);
    freq.put(" Hi", 788);
    freq.put(" Ho", 749);
    freq.put(" Ha", 1860);
    freq.put(" He", 1741);
    freq.put("ima", 234);
    freq.put("clo", 200);
    freq.put("ime", 308);
    freq.put("cli", 85);
    freq.put("imi", 96);
    freq.put("cle", 277);
    freq.put("iml", 45);
    freq.put("imo", 119);
    freq.put("imp", 49);
    freq.put("cly", 91);
    freq.put("clu", 110);
    freq.put("clw", 122);
    freq.put("wse", 138);
    freq.put("im ", 424);
    freq.put("wsi", 378);
    freq.put("\u064a ", 83);
    freq.put("wsl", 55);
    freq.put("\u03c4", 85);
    freq.put("gom", 145);
    freq.put("gol", 3429);
    freq.put("gon", 261);
    freq.put("goe", 182);
    freq.put("god", 705);
    freq.put("gog", 3238);
    freq.put("gof", 323);
    freq.put("goc", 155);
    freq.put("gob", 234);
    freq.put("got", 51);
    freq.put("gow", 97);
    freq.put("gop", 2404);
    freq.put("gos", 1215);
    freq.put("gor", 3586);
    freq.put("w\u0302yr", 67);
    freq.put("W", 5139);
    freq.put("w\u0302yl", 106);
    freq.put("Vic", 94);
    freq.put("Ca\u0302n", 42);
    freq.put("go ", 385);
    freq.put("Vir", 48);
    freq.put("DU ", 59);
    freq.put("be ", 98);
    freq.put("nhe", 398);
    freq.put("nha", 1076);
    freq.put("nho", 72);
    freq.put("nhi", 540);
    freq.put("Y", 6381);
    freq.put("nhw", 208);
    freq.put("nhr", 112);
    freq.put("nhy", 526);
    freq.put("tor", 1235);
    freq.put("tos", 66);
    freq.put("top", 118);
    freq.put("tow", 75);
    freq.put("tou", 42);
    freq.put("toi", 46);
    freq.put("ton", 1238);
    freq.put("tol", 136);
    freq.put("tom", 329);
    freq.put("tob", 164);
    freq.put("toc", 94);
    freq.put("a\u0302r ", 137);
    freq.put("tog", 93);
    freq.put("tod", 481);
    freq.put("nh ", 42);
    freq.put(" Sg", 470);
    freq.put("to ", 461);
    freq.put("thu", 967);
    freq.put("raf", 654);
    freq.put("rag", 225);
    freq.put("rad", 1700);
    freq.put("rae", 3686);
    freq.put("rab", 559);
    freq.put("rac", 707);
    freq.put("lbw", 166);
    freq.put("lby", 104);
    freq.put("ral", 1583);
    freq.put("ram", 999);
    freq.put("rak", 64);
    freq.put("rah", 144);
    freq.put("rai", 5122);
    freq.put("rav", 72);
    freq.put("raw", 994);
    freq.put("rat", 596);
    freq.put("rau", 1291);
    freq.put("rar", 127);
    freq.put("ras", 623);
    freq.put("rap", 92);
    freq.put("cyw", 55);
    freq.put("a\u0302u ", 90);
    freq.put("lbo", 179);
    freq.put("ray", 146);
    freq.put("tho", 2822);
    freq.put("Syd", 49);
    freq.put("Syl", 57);
    freq.put("Sys", 57);
    freq.put("Syr", 267);
    freq.put("thi", 2871);
    freq.put("ra ", 2000);
    freq.put("thd", 135);
    freq.put("AS ", 68);
    freq.put("cyf", 2990);
    freq.put("e\u0301p", 354);
    freq.put("e\u0301r", 78);
    freq.put("e\u0301m", 39);
    freq.put("e\u0301l", 41);
    freq.put("e\u0301n", 68);
    freq.put("e\u0301e", 104);
    freq.put("e\u0301g", 64);
    freq.put("oci", 126);
    freq.put("och", 2669);
    freq.put("Bil", 57);
    freq.put("cyh", 309);
    freq.put("ocl", 42);
    freq.put("oco", 167);
    freq.put("oca", 256);
    freq.put("oce", 82);
    freq.put("abr", 69);
    freq.put("ocs", 68);
    freq.put("ocr", 146);
    freq.put("Bir", 54);
    freq.put("Bis", 38);
    freq.put("\u0440", 207);
    freq.put("e\u0301 ", 170);
    freq.put("oc ", 243);
    freq.put("Pet", 166);
    freq.put("nus", 314);
    freq.put("Per", 357);
    freq.put("Pel", 49);
    freq.put("nul", 284);
    freq.put("num", 42);
    freq.put("Ped", 89);
    freq.put("Pea", 46);
    freq.put("mus", 72);
    freq.put("mur", 150);
    freq.put("Oes", 2225);
    freq.put("mud", 331);
    freq.put("mun", 2037);
    freq.put("nu ", 1112);
    freq.put("mu ", 71);
    freq.put("bi\u0302 ", 57);
    freq.put(" me", 5050);
    freq.put("\u4e4b ", 53);
    freq.put(" ma", 5425);
    freq.put(" ml", 96);
    freq.put(" mo", 510);
    freq.put(" mh", 245);
    freq.put(" mi", 1482);
    freq.put(" mu", 301);
    freq.put(" mw", 1538);
    freq.put(" my", 3937);
    freq.put("wf ", 39);
    freq.put("\u03b9\u0301", 75);
    freq.put(" m ", 291);
    freq.put("Cru", 632);
    freq.put("Cry", 52);
    freq.put("Cra", 198);
    freq.put("Cre", 385);
    freq.put("Cri", 276);
    freq.put("TV ", 60);
    freq.put("n", 303994);
    freq.put("si\u0308a", 42);
    freq.put(" mo\u0302", 277);
    freq.put("\u062d", 77);
    freq.put("Tre", 944);
    freq.put("i\u0304 ", 39);
    freq.put("eli", 827);
    freq.put("elo", 1131);
    freq.put("ell", 3094);
    freq.put("elm", 49);
    freq.put("elb", 58);
    freq.put("rnw", 59);
    freq.put("ela", 658);
    freq.put("elf", 432);
    freq.put("elg", 144);
    freq.put("eld", 2120);
    freq.put("ele", 1904);
    freq.put("ely", 937);
    freq.put("yw ", 17417);
    freq.put("els", 154);
    freq.put("elp", 43);
    freq.put("elw", 957);
    freq.put("elt", 533);
    freq.put("elu", 92);
    freq.put("D", 11333);
    freq.put("ywu", 40);
    freq.put("el ", 7486);
    freq.put("ywy", 914);
    freq.put("Lyd", 44);
    freq.put("ywe", 457);
    freq.put("ywb", 47);
    freq.put("ywa", 1109);
    freq.put("ywo", 763);
    freq.put("Lyn", 107);
    freq.put("Lyo", 122);
    freq.put("ywi", 571);
    freq.put("hs ", 119);
    freq.put(" Ju", 220);
    freq.put(" Jr", 44);
    freq.put(" Jo", 1198);
    freq.put(" Ji", 72);
    freq.put(" Je", 327);
    freq.put(" Ja", 936);
    freq.put("ick", 291);
    freq.put("ici", 221);
    freq.put("Hy", 775);
    freq.put("ico", 318);
    freq.put("icl", 187);
    freq.put("ica", 2272);
    freq.put("Hw", 138);
    freq.put("ice", 249);
    freq.put("Hu", 453);
    freq.put("Hi", 789);
    freq.put("Ho", 750);
    freq.put("ics", 52);
    freq.put("icr", 127);
    freq.put("Ha", 1868);
    freq.put("icu", 74);
    freq.put("He", 1744);
    freq.put("aws", 410);
    freq.put(" J ", 50);
    freq.put("ic ", 408);
    freq.put("H ", 155);
    freq.put("aha", 670);
    freq.put("awi", 82);
    freq.put("ppe", 110);
    freq.put("ppi", 61);
    freq.put("ppl", 52);
    freq.put("ne\u0301", 106);
    freq.put("ne\u0308", 57);
    freq.put("gis", 343);
    freq.put("gir", 83);
    freq.put("ni\u0308", 350);
    freq.put("nc\u0327", 49);
    freq.put("gig", 167);
    freq.put("gie", 91);
    freq.put("gid", 96);
    freq.put("gia", 697);
    freq.put("gio", 1071);
    freq.put("gin", 207);
    freq.put("gil", 269);
    freq.put("ah ", 232);
    freq.put("a\u0301n ", 53);
    freq.put("thn", 220);
    freq.put("gi ", 259);
    freq.put("nno", 1554);
    freq.put("nni", 1551);
    freq.put("y\u0302 ", 235);
    freq.put("nne", 1057);
    freq.put("nna", 2821);
    freq.put("nny", 700);
    freq.put("nnw", 1776);
    freq.put("nnu", 754);
    freq.put("nns", 44);
    freq.put("nh", 3006);
    freq.put("ni", 14670);
    freq.put("nj", 135);
    freq.put("nk", 382);
    freq.put("nl", 948);
    freq.put("nm", 771);
    freq.put("nn", 11240);
    freq.put("no", 14100);
    freq.put("tit", 55);
    freq.put("na", 18605);
    freq.put("nb", 1462);
    freq.put("nc", 2771);
    freq.put("nd", 8926);
    freq.put("ne", 28781);
    freq.put("nf", 2039);
    freq.put("ng", 19411);
    freq.put("til", 111);
    freq.put("ny", 12248);
    freq.put("nz", 130);
    freq.put("tio", 758);
    freq.put("np", 53);
    freq.put("tie", 133);
    freq.put("nr", 2284);
    freq.put("ns", 2901);
    freq.put("nt", 12389);
    freq.put("nu", 1924);
    freq.put("nv", 170);
    freq.put("nw", 13858);
    freq.put("y\u0302n", 164);
    freq.put("nn ", 872);
    freq.put("ich", 1469);
    freq.put("y\u0302r", 76);
    freq.put("n ", 129973);
    freq.put("ti ", 249);
    freq.put("roi", 253);
    freq.put("lly", 1536);
    freq.put("rol", 2368);
    freq.put("rom", 276);
    freq.put("ron", 2092);
    freq.put("Tsi", 288);
    freq.put("lls", 93);
    freq.put("roa", 132);
    freq.put("rob", 80);
    freq.put("roc", 437);
    freq.put("rod", 1050);
    freq.put("roe", 2453);
    freq.put("rof", 352);
    freq.put("rog", 406);
    freq.put("roy", 52);
    freq.put("lli", 2844);
    freq.put("llh", 61);
    freq.put("llo", 886);
    freq.put("rop", 851);
    freq.put("lla", 2622);
    freq.put("ros", 1473);
    freq.put("rot", 256);
    freq.put("rou", 509);
    freq.put("rov", 96);
    freq.put("row", 190);
    freq.put("Dad", 40);
    freq.put("Dae", 153);
    freq.put("Daf", 217);
    freq.put("Dal", 797);
    freq.put("Dam", 55);
    freq.put("Dan", 185);
    freq.put("Dai", 40);
    freq.put("Dat", 83);
    freq.put("Dav", 367);
    freq.put("Daw", 158);
    freq.put("Dar", 231);
    freq.put("dey", 177);
    freq.put("ro ", 1459);
    freq.put("Cil", 97);
    freq.put("Cit", 58);
    freq.put("ll ", 5712);
    freq.put("ict", 213);
    freq.put("Res", 39);
    freq.put("lle\u0302", 46);
    freq.put("Rei", 43);
    freq.put("Ren", 42);
    freq.put("Rea", 48);
    freq.put("Reg", 46);
    freq.put("Red", 74);
    freq.put("Ree", 51);
    freq.put("Bwr", 151);
    freq.put("Que", 103);
    freq.put("Bwl", 182);
    freq.put("Quo", 68);
    freq.put("Ago", 41);
    freq.put("ngt", 147);
    freq.put("Ogw", 150);
    freq.put("mst", 38);
    freq.put("Ogl", 71);
    freq.put("Ogo", 40);
    freq.put("ult", 59);
    freq.put("mse", 222);
    freq.put("msa", 38);
    freq.put("Eva", 147);
    freq.put("ms ", 365);
    freq.put(" on", 1046);
    freq.put(" ol", 455);
    freq.put("Mil", 151);
    freq.put(" oh", 320);
    freq.put("Min", 107);
    freq.put(" of", 830);
    freq.put(" og", 435);
    freq.put("Mic", 171);
    freq.put(" oe", 5934);
    freq.put("Mid", 69);
    freq.put("Mis", 80);
    freq.put(" or", 2059);
    freq.put("Mit", 41);
    freq.put(" op", 73);
    freq.put("ky ", 83);
    freq.put("cso", 73);
    freq.put(" o ", 21338);
    freq.put("ryf", 329);
    freq.put("de\u0301p", 339);
    freq.put("\u4e18", 45);
    freq.put("Gw\u0302y", 103);
    freq.put("gto", 136);
    freq.put("\u0648", 196);
    freq.put("sht", 41);
    freq.put("ha\u0302n", 48);
    freq.put(" ca", 4243);
    freq.put("git", 112);
    freq.put("gip", 42);
    freq.put("\u0438\u0447", 41);
    freq.put("e\u0300s ", 39);
    freq.put("anc\u0327", 39);
    freq.put("hu ", 783);
    freq.put("iam", 862);
    freq.put("ial", 272);
    freq.put("ian", 2596);
    freq.put("iai", 1947);
    freq.put("iae", 3103);
    freq.put("iad", 7064);
    freq.put("iag", 47);
    freq.put("iaf", 180);
    freq.put("iac", 97);
    freq.put("iau", 4682);
    freq.put("iat", 304);
    freq.put("iaw", 277);
    freq.put("iap", 95);
    freq.put("ias", 109);
    freq.put("iar", 462);
    freq.put("hud", 119);
    freq.put("huf", 332);
    freq.put("hug", 114);
    freq.put("hua", 173);
    freq.put("hub", 85);
    freq.put("hum", 201);
    freq.put("hun", 510);
    freq.put("Ysg", 820);
    freq.put("hui", 111);
    freq.put("hut", 107);
    freq.put("hur", 322);
    freq.put("hus", 102);
    freq.put("Yst", 328);
    freq.put("ia ", 4053);
    freq.put("\u0646 ", 99);
    freq.put("r", 275486);
    freq.put("pre", 259);
    freq.put("ane", 3419);
    freq.put("anf", 695);
    freq.put("ang", 2452);
    freq.put("pra", 67);
    freq.put("ana", 2445);
    freq.put("anb", 852);
    freq.put("anc", 833);
    freq.put("anl", 302);
    freq.put("anm", 62);
    freq.put("ann", 2928);
    freq.put("ano", 3132);
    freq.put("pri", 908);
    freq.put("ani", 1520);
    freq.put("ank", 171);
    freq.put("ant", 3519);
    freq.put("anu", 408);
    freq.put("anw", 1721);
    freq.put("anr", 1027);
    freq.put("ans", 1375);
    freq.put("pry", 124);
    freq.put("any", 320);
    freq.put("anz", 40);
    freq.put("A\u0302R ", 38);
    freq.put(" L ", 42);
    freq.put("\u0435", 260);
    freq.put("an ", 20701);
    freq.put("Wyd", 174);
    freq.put("Wyn", 117);
    freq.put(" Le", 1952);
    freq.put(" La", 1290);
    freq.put(" Lo", 2188);
    freq.put(" Ll", 8523);
    freq.put(" Li", 729);
    freq.put(" Lw", 47);
    freq.put(" Lu", 320);
    freq.put(" Ly", 372);
    freq.put("nly", 168);
    freq.put("nla", 116);
    freq.put("nle", 42);
    freq.put("nli", 40);
    freq.put("dy ", 4499);
    freq.put("nll", 561);
    freq.put("Fyn", 271);
    freq.put("\u0447 ", 45);
    freq.put("H", 6663);
    freq.put("dyw", 304);
    freq.put("dyr", 98);
    freq.put("dys", 437);
    freq.put("dyl", 322);
    freq.put("dym", 701);
    freq.put("sso", 142);
    freq.put("ssi", 225);
    freq.put("dyd", 3079);
    freq.put("dyf", 430);
    freq.put("dyg", 246);
    freq.put("ssa", 154);
    freq.put("dyc", 204);
    freq.put("rms", 122);
    freq.put("rmw", 43);
    freq.put("rma", 1380);
    freq.put("rme", 127);
    freq.put("rmi", 264);
    freq.put("rmo", 210);
    freq.put("rm ", 554);
    freq.put("wre", 539);
    freq.put("aha\u0302", 37);
    freq.put("pot", 107);
    freq.put("por", 199);
    freq.put("pos", 99);
    freq.put("pop", 88);
    freq.put("pon", 96);
    freq.put("pol", 295);
    freq.put("poe", 47);
    freq.put("pob", 661);
    freq.put("Bur", 114);
    freq.put("nnh", 61);
    freq.put("But", 65);
    freq.put("Bui", 58);
    freq.put("Bul", 39);
    freq.put("Buc", 38);
    freq.put("Aer", 53);
    freq.put("Ael", 205);
    freq.put("po ", 38);
    freq.put("Bu ", 164);
    freq.put("Ia\u0302", 58);
    freq.put("Oak", 42);
    freq.put("\u0431", 38);
    freq.put("I ", 676);
    freq.put("Eth", 197);
    freq.put("Eti", 126);
    freq.put("oka", 38);
    freq.put("yho", 721);
    freq.put("Is", 833);
    freq.put("Ir", 229);
    freq.put("It", 59);
    freq.put("Iw", 647);
    freq.put("yhy", 100);
    freq.put("Im", 55);
    freq.put("Il", 79);
    freq.put("Io", 765);
    freq.put("In", 884);
    freq.put("Ia", 328);
    freq.put("oke", 60);
    freq.put("Ib", 42);
    freq.put("Ie", 177);
    freq.put("Id", 236);
    freq.put("If", 69);
    freq.put("Mwr", 59);
    freq.put("tiw", 232);
    freq.put("tir", 1682);
    freq.put("tis", 234);
    freq.put("tim", 109);
    freq.put("tin", 490);
    freq.put("wb ", 178);
    freq.put("tid", 55);
    freq.put("tif", 143);
    freq.put("tig", 337);
    freq.put("Pil", 40);
    freq.put("Pin", 50);
    freq.put("Pic", 69);
    freq.put("Pie", 81);
    freq.put("tia", 1118);
    freq.put("wbe", 49);
    freq.put("wba", 42);
    freq.put("wbl", 50);
    freq.put("tic", 242);
    freq.put("Pit", 98);
    freq.put("o ", 32658);
    freq.put("oo", 863);
    freq.put("on", 23684);
    freq.put("om", 3404);
    freq.put("ol", 31043);
    freq.put("ok", 359);
    freq.put("oi", 1499);
    freq.put("oh", 1022);
    freq.put("og", 11702);
    freq.put("of", 2843);
    freq.put("oe", 17244);
    freq.put("od", 16702);
    freq.put("oc", 4164);
    freq.put("ob", 4169);
    freq.put("oa", 475);
    freq.put("oz", 69);
    freq.put("oy", 522);
    freq.put("ox", 76);
    freq.put("ow", 1905);
    freq.put("ov", 478);
    freq.put("ou", 2364);
    freq.put("ot", 1836);
    freq.put("os", 6644);
    freq.put("or", 19871);
    freq.put("op", 7305);
    freq.put("\u03b3", 42);
    freq.put("ehe", 930);
    freq.put("eha", 71);
    freq.put("\u4e01", 71);
    freq.put("rva", 46);
    freq.put("rve", 108);
    freq.put("rvi", 51);
    freq.put("hw ", 113);
    freq.put("igw", 328);
    freq.put("igu", 58);
    freq.put("igr", 271);
    freq.put("e\u0301es", 42);
    freq.put("igy", 145);
    freq.put("\u0631", 230);
    freq.put("ige", 189);
    freq.put("iga", 404);
    freq.put("igo", 654);
    freq.put("ign", 71);
    freq.put("igl", 50);
    freq.put("igi", 940);
    freq.put("igh", 415);
    freq.put("hwn", 2898);
    freq.put("hwm", 129);
    freq.put("hwi", 274);
    freq.put("hwe", 1597);
    freq.put("hwc", 43);
    freq.put("hwa", 1012);
    freq.put("hwy", 1500);
    freq.put("hwr", 536);
    freq.put("ig ", 8077);
    freq.put("e\u0301e ", 55);
    freq.put("pto", 69);
    freq.put("alo", 371);
    freq.put("all", 3308);
    freq.put("alm", 88);
    freq.put("alk", 68);
    freq.put("pti", 107);
    freq.put("ali", 1102);
    freq.put("alf", 125);
    freq.put("alg", 97);
    freq.put("pte", 1044);
    freq.put("ale", 2251);
    freq.put("alb", 252);
    freq.put("alc", 202);
    freq.put("ala", 2417);
    freq.put("aly", 92);
    freq.put("alw", 828);
    freq.put("fa ", 921);
    freq.put("alu", 142);
    freq.put("als", 144);
    freq.put("alp", 44);
    freq.put("SH ", 92);
    freq.put("roo", 125);
    freq.put("uwy", 107);
    freq.put("far", 1398);
    freq.put("fas", 178);
    freq.put("faw", 347);
    freq.put("fat", 439);
    freq.put("pt ", 38);
    freq.put("uwi", 160);
    freq.put("fai", 692);
    freq.put("fan", 3403);
    freq.put("llu", 1630);
    freq.put("fal", 398);
    freq.put("fam", 349);
    freq.put("fab", 257);
    freq.put("fac", 250);
    freq.put("llt", 2306);
    freq.put("fag", 106);
    freq.put("fad", 65);
    freq.put("fae", 493);
    freq.put(" Ni", 588);
    freq.put(" Nh", 168);
    freq.put(" No", 968);
    freq.put(" Na", 1715);
    freq.put(" Ne", 1728);
    freq.put(" Ng", 1975);
    freq.put(" Ny", 139);
    freq.put(" Nu", 77);
    freq.put("io\u0302n", 44);
    freq.put("tei", 537);
    freq.put("nby", 393);
    freq.put("I\u0302l", 39);
    freq.put("tem", 745);
    freq.put("ten", 263);
    freq.put("nbr", 49);
    freq.put("teb", 257);
    freq.put("tec", 118);
    freq.put("ted", 382);
    freq.put("nbu", 88);
    freq.put("teg", 330);
    freq.put("tey", 122);
    freq.put("tep", 86);
    freq.put("nba", 661);
    freq.put("tes", 349);
    freq.put("ror", 608);
    freq.put("nbe", 186);
    freq.put("llg", 60);
    freq.put("sul", 51);
    freq.put("llf", 78);
    freq.put("sut", 42);
    freq.put("sus", 58);
    freq.put("lle", 6817);
    freq.put("te ", 1064);
    freq.put("o\u0304", 123);
    freq.put("i\u0302l ", 44);
    freq.put("su ", 192);
    freq.put("lo", 8056);
    freq.put("rks", 56);
    freq.put("Tor", 142);
    freq.put("Tow", 45);
    freq.put("Tou", 86);
    freq.put("rke", 72);
    freq.put("Ton", 77);
    freq.put("rka", 46);
    freq.put("Tom", 170);
    freq.put("\u03b7", 58);
    freq.put("rk ", 218);
    freq.put("Glo\u0308", 96);
    freq.put("a\u0301", 343);
    freq.put("Int", 85);
    freq.put("Inv", 100);
    freq.put("v", 3889);
    freq.put("Ind", 510);
    freq.put(" A\u0300i", 440);
    freq.put("oyw", 120);
    freq.put("o\u0302r", 762);
    freq.put("o\u0302n", 601);
    freq.put("o\u0302l", 1584);
    freq.put("\u0438\u0306", 66);
    freq.put("oyd", 162);
    freq.put("oya", 64);
    freq.put("Glo", 100);
    freq.put("Gla", 300);
    freq.put("Gle", 844);
    freq.put("Gly", 254);
    freq.put("lhe", 114);
    freq.put("Nha", 51);
    freq.put("lha", 157);
    freq.put("Nhr", 45);
    freq.put("oy ", 77);
    freq.put(" se\u0302", 49);
    freq.put("Er ", 143);
    freq.put("yn ", 47219);
    freq.put("Fri", 101);
    freq.put("Ers", 44);
    freq.put("Ery", 541);
    freq.put("\u0432\u0438\u0447", 38);
    freq.put("Erb", 44);
    freq.put("Eri", 162);
    freq.put("ynl", 244);
    freq.put("ynn", 2787);
    freq.put("yno", 1438);
    freq.put("ynh", 1161);
    freq.put("yni", 1100);
    freq.put("e\u0308e", 56);
    freq.put("e\u0308d", 42);
    freq.put("ynd", 320);
    freq.put("yne", 1666);
    freq.put("ynf", 195);
    freq.put("yng", 7196);
    freq.put("yna", 930);
    freq.put("ync", 116);
    freq.put("e\u0308w", 53);
    freq.put("Ras", 58);
    freq.put("ynt", 1723);
    freq.put("ynu", 364);
    freq.put("ynw", 625);
    freq.put("ynr", 509);
    freq.put(" sy", 9830);
    freq.put("Mus", 84);
    freq.put("Mur", 72);
    freq.put(" sp", 64);
    freq.put(" sw", 506);
    freq.put(" st", 735);
    freq.put(" su", 140);
    freq.put("Mud", 92);
    freq.put(" sh", 72);
    freq.put(" si", 1946);
    freq.put(" so", 173);
    freq.put(" sm", 89);
    freq.put(" sb", 90);
    freq.put(" sc", 46);
    freq.put("Mun", 41);
    freq.put(" sg", 392);
    freq.put(" se", 3484);
    freq.put("iza", 90);
    freq.put("gur", 278);
    freq.put("izo", 45);
    freq.put("wl ", 621);
    freq.put(" s ", 280);
    freq.put("wly", 42);
    freq.put("wli", 167);
    freq.put("wll", 145);
    freq.put("wla", 2176);
    freq.put("wlc", 168);
    freq.put(" ef", 594);
    freq.put("wlf", 163);
    freq.put("wlg", 67);
    freq.put("imb", 55);
    freq.put("dff", 43);
    freq.put("i", 224421);
    freq.put("efy", 3744);
    freq.put("efr", 578);
    freq.put("eft", 52);
    freq.put("efi", 914);
    freq.put("efn", 2061);
    freq.put("efo", 588);
    freq.put("\u0639", 70);
    freq.put("efa", 1730);
    freq.put("efe", 318);
    freq.put("eff", 454);
    freq.put("ef ", 6146);
    freq.put("rte", 612);
    freq.put("rta", 429);
    freq.put("rto", 132);
    freq.put("rtn", 57);
    freq.put("rti", 407);
    freq.put("rth", 6409);
    freq.put("hi ", 668);
    freq.put("rts", 105);
    freq.put("rtr", 278);
    freq.put("rty", 80);
    freq.put("Ju", 221);
    freq.put("ies", 434);
    freq.put("ier", 266);
    freq.put("ieu", 94);
    freq.put("iet", 350);
    freq.put("Jr", 44);
    freq.put("iei", 784);
    freq.put("Jo", 1211);
    freq.put("iel", 338);
    freq.put("ien", 309);
    freq.put("Je", 327);
    freq.put("iec", 167);
    freq.put("Ja", 937);
    freq.put("ieg", 134);
    freq.put("ief", 37);
    freq.put("hip", 49);
    freq.put("hir", 643);
    freq.put("his", 167);
    freq.put("hit", 155);
    freq.put("rt ", 1113);
    freq.put("hiw", 167);
    freq.put("hia", 2000);
    freq.put("hic", 96);
    freq.put("hid", 60);
    freq.put("hie", 154);
    freq.put("hif", 269);
    freq.put("hig", 403);
    freq.put("hil", 345);
    freq.put("him", 84);
    freq.put("hin", 783);
    freq.put("hio", 970);
    freq.put("ie ", 736);
    freq.put("J ", 134);
    freq.put("arp", 203);
    freq.put("arr", 856);
    freq.put("ars", 273);
    freq.put("art", 3281);
    freq.put("aru", 190);
    freq.put("arv", 109);
    freq.put("arw", 1994);
    freq.put("ary", 397);
    freq.put("ara", 2389);
    freq.put("arb", 599);
    freq.put("arc", 1261);
    freq.put("ard", 3174);
    freq.put("are", 1082);
    freq.put("arf", 1468);
    freq.put("arg", 679);
    freq.put("arh", 141);
    freq.put("ari", 1312);
    freq.put("ark", 227);
    freq.put("arl", 1098);
    freq.put("arm", 191);
    freq.put("arn", 2998);
    freq.put("aro", 1162);
    freq.put("al ", 3450);
    freq.put("use", 207);
    freq.put("ar ", 13348);
    freq.put("fgh", 43);
    freq.put("fga", 38);
    freq.put(" Pr", 1731);
    freq.put("c", 70455);
    freq.put(" Pw", 190);
    freq.put(" Pu", 304);
    freq.put(" Py", 119);
    freq.put(" Pa", 1581);
    freq.put(" Pe", 3404);
    freq.put(" Pi", 467);
    freq.put(" Ph", 390);
    freq.put(" Po", 1917);
    freq.put(" Pl", 523);
    freq.put("tga", 83);
    freq.put("tgo", 37);
    freq.put("pr", 1765);
    freq.put("ps", 228);
    freq.put("pp", 348);
    freq.put("swm", 55);
    freq.put("pw", 742);
    freq.put("dun", 58);
    freq.put("pu", 631);
    freq.put("swa", 56);
    freq.put("px", 78);
    freq.put("py", 248);
    freq.put("swe", 46);
    freq.put("dug", 82);
    freq.put("swy", 714);
    freq.put("pa", 7810);
    freq.put("pe", 4549);
    freq.put("Fan", 141);
    freq.put("dur", 2144);
    freq.put("pi", 2423);
    freq.put("po", 1801);
    freq.put("pl", 881);
    freq.put("duw", 218);
    freq.put("Emm", 39);
    freq.put("Eml", 53);
    freq.put("Emi", 37);
    freq.put("du ", 2339);
    freq.put("p ", 2056);
    freq.put("riz", 47);
    freq.put("rix", 39);
    freq.put("riv", 51);
    freq.put("riw", 213);
    freq.put("rit", 599);
    freq.put("riu", 72);
    freq.put("rir", 398);
    freq.put("ris", 1179);
    freq.put("rip", 190);
    freq.put("rin", 1456);
    freq.put("Tim", 107);
    freq.put("ril", 699);
    freq.put("rim", 124);
    freq.put("rik", 45);
    freq.put("rif", 5003);
    freq.put("rig", 1620);
    freq.put("rid", 570);
    freq.put("rie", 637);
    freq.put("rib", 415);
    freq.put("ric", 2311);
    freq.put("Tib", 106);
    freq.put("ria", 4427);
    freq.put("pe\u0302", 160);
    freq.put("Cop", 81);
    freq.put("Cos", 46);
    freq.put("Cor", 407);
    freq.put("Cou", 119);
    freq.put("I\u0302", 41);
    freq.put("Coc", 117);
    freq.put("Coe", 237);
    freq.put("Cof", 107);
    freq.put("Coi", 141);
    freq.put("Com", 238);
    freq.put("Col", 320);
    freq.put("ri ", 1789);
    freq.put("Con", 652);
    freq.put("Eid", 393);
    freq.put("\u044c", 66);
    freq.put("Air", 55);
    freq.put("Ail", 151);
    freq.put("Ain", 442);
    freq.put("Aif", 105);
    freq.put("Lle\u0302", 901);
    freq.put("grw\u0302", 298);
    freq.put("yl ", 434);
    freq.put("bh ", 143);
    freq.put("ylv", 55);
    freq.put("ylw", 219);
    freq.put("Lly", 1369);
    freq.put("ylu", 111);
    freq.put("Rom", 81);
    freq.put("Ron", 57);
    freq.put("Roa", 53);
    freq.put("Rob", 347);
    freq.put("Roc", 57);
    freq.put("Llw", 218);
    freq.put("Roe", 1456);
    freq.put("Llu", 548);
    freq.put("Rog", 56);
    freq.put("ylf", 185);
    freq.put("Roy", 48);
    freq.put("yld", 121);
    freq.put("yle", 201);
    freq.put("Llo", 1177);
    freq.put("ylc", 792);
    freq.put("yla", 317);
    freq.put("ylo", 75);
    freq.put("yll", 1653);
    freq.put("Ros", 111);
    freq.put("Rou", 63);
    freq.put("Lle", 1205);
    freq.put("yli", 297);
    freq.put("wn ", 4514);
    freq.put(" uw", 917);
    freq.put(" ur", 1014);
    freq.put(" un", 3364);
    freq.put(" ug", 115);
    freq.put(" uc", 1154);
    freq.put("gre\u0308", 37);
    freq.put("wnc", 60);
    freq.put("wna", 104);
    freq.put("wng", 2908);
    freq.put("wnd", 93);
    freq.put("wne", 924);
    freq.put("wni", 118);
    freq.put("wnn", 120);
    freq.put("wno", 71);
    freq.put("wns", 141);
    freq.put("wnt", 347);
    freq.put("wny", 106);
    freq.put(" u ", 582);
    freq.put(" Ky", 127);
    freq.put("ix ", 95);
    freq.put("z", 1653);
    freq.put("grw", 824);
    freq.put("gru", 108);
    freq.put("gry", 291);
    freq.put("gre", 514);
    freq.put("gra", 788);
    freq.put("gro", 1041);
    freq.put("gri", 1359);
    freq.put("Lly\u0302", 126);
    freq.put("gr ", 1217);
    freq.put("eda", 429);
    freq.put("a\u0302 ", 1741);
    freq.put("edd", 25528);
    freq.put("ede", 614);
    freq.put("edi", 6449);
    freq.put("edn", 55);
    freq.put("edo", 543);
    freq.put("edl", 1308);
    freq.put("edr", 525);
    freq.put("\u043a\u043e", 46);
    freq.put("edw", 785);
    freq.put("edu", 747);
    freq.put("ugo", 87);
    freq.put("edy", 568);
    freq.put("a\u0302d", 45);
    freq.put("ed ", 6517);
    freq.put("a\u0302l", 86);
    freq.put("a\u0302n", 336);
    freq.put("a\u0302t", 37);
    freq.put("a\u0302u", 90);
    freq.put("uge", 143);
    freq.put("a\u0302r", 140);
    freq.put("Kyl", 83);
    freq.put("iba", 122);
    freq.put("rro", 150);
    freq.put("rri", 1366);
    freq.put("rre", 437);
    freq.put("rra", 424);
    freq.put("DD ", 40);
    freq.put("rry", 313);
    freq.put("rrw", 61);
    freq.put("rru", 55);
    freq.put("rr ", 283);
    freq.put("Un", 2471);
    freq.put("app", 56);
    freq.put("apt", 39);
    freq.put("apu", 247);
    freq.put("ran", 2411);
    freq.put("api", 138);
    freq.put("apo", 90);
    freq.put("apa", 506);
    freq.put("ape", 190);
    freq.put("feg", 51);
    freq.put("fed", 1584);
    freq.put("Hug", 142);
    freq.put("usc", 42);
    freq.put("fec", 310);
    freq.put("usa", 109);
    freq.put("fen", 1795);
    freq.put("Hum", 61);
    freq.put("fel", 4370);
    freq.put("\u062a", 86);
    freq.put("usk", 46);
    freq.put("usi", 90);
    freq.put("fei", 2068);
    freq.put("few", 292);
    freq.put("fet", 126);
    freq.put("Huw", 52);
    freq.put("fer", 2706);
    freq.put("fes", 342);
    freq.put(" od", 327);
    freq.put("fey", 110);
    freq.put("Gua", 65);
    freq.put("Gui", 67);
    freq.put(" oc", 254);
    freq.put("ap ", 434);
    freq.put("px ", 78);
    freq.put(" Ru", 535);
    freq.put(" Rw", 509);
    freq.put("fe ", 363);
    freq.put("us ", 2318);
    freq.put(" Ry", 288);
    freq.put(" Re", 502);
    freq.put(" Ra", 627);
    freq.put(" Ro", 2598);
    freq.put(" Ri", 459);
    freq.put(" Rh", 3078);
    freq.put("tat", 257);
    freq.put("tau", 148);
    freq.put("taw", 293);
    freq.put("tar", 586);
    freq.put("tas", 137);
    freq.put("tad", 428);
    freq.put("tae", 112);
    freq.put("taf", 985);
    freq.put("tag", 117);
    freq.put("tab", 136);
    freq.put("tac", 100);
    freq.put("tal", 1078);
    freq.put("tam", 161);
    freq.put("tan", 960);
    freq.put("tai", 1174);
    freq.put("sis", 167);
    freq.put("sir", 1014);
    freq.put("siw", 382);
    freq.put("sit", 100);
    freq.put("siy", 220);
    freq.put("dwy", 4886);
    freq.put(" os", 109);
    freq.put("sic", 303);
    freq.put("sib", 67);
    freq.put("sia", 2244);
    freq.put("dwa", 882);
    freq.put("sig", 463);
    freq.put("sif", 99);
    freq.put("sie", 542);
    freq.put("sid", 204);
    freq.put("dwi", 169);
    freq.put("sio", 756);
    freq.put("sin", 210);
    freq.put("sim", 40);
    freq.put("sil", 315);
    freq.put("ta ", 832);
    freq.put("rw\u0302p", 443);
    freq.put("dw ", 187);
    freq.put("si ", 461);
    freq.put("e\u0308di", 40);
    freq.put("byw", 545);
    freq.put("byt", 107);
    freq.put("Dyw", 75);
    freq.put("byr", 125);
    freq.put("bys", 89);
    freq.put("Dys", 44);
    freq.put("Dyl", 71);
    freq.put("Dym", 227);
    freq.put("Dyn", 66);
    freq.put("bym", 110);
    freq.put("ea ", 342);
    freq.put("Dyd", 48);
    freq.put("byg", 624);
    freq.put("Dyf", 415);
    freq.put("byc", 1183);
    freq.put("Dyc", 49);
    freq.put("Cas", 915);
    freq.put("Car", 1877);
    freq.put("Cap", 159);
    freq.put("Caw", 62);
    freq.put("Cat", 223);
    freq.put("Cai", 366);
    freq.put("Can", 1350);
    freq.put("Cam", 227);
    freq.put("Cal", 219);
    freq.put("Cab", 43);
    freq.put("Caf", 480);
    freq.put("Cae", 1032);
    freq.put("Cad", 213);
    freq.put("Pre", 133);
    freq.put("nff", 206);
    freq.put("nfe", 298);
    freq.put("Pra", 116);
    freq.put("nfa", 429);
    freq.put("nfo", 387);
    freq.put("Pro", 243);
    freq.put("Pri", 768);
    freq.put("nfi", 141);
    freq.put("nfu", 53);
    freq.put("nfr", 376);
    freq.put("Pry", 452);
    freq.put("nfy", 113);
    freq.put("oui", 121);
    freq.put("oun", 623);
    freq.put("oul", 126);
    freq.put("oub", 57);
    freq.put("oua", 56);
    freq.put("oug", 154);
    freq.put("oud", 41);
    freq.put("ouz", 37);
    freq.put("ous", 235);
    freq.put("our", 437);
    freq.put("ouv", 47);
    freq.put("out", 170);
    freq.put("Aon", 53);
    freq.put("lt ", 544);
    freq.put("ou ", 122);
    freq.put("Gha", 77);
    freq.put("ltw", 61);
    freq.put("ltu", 263);
    freq.put("lta", 499);
    freq.put("lte", 173);
    freq.put("lti", 1579);
    freq.put("lto", 98);
    freq.put("u\u0308", 121);
    freq.put("K ", 39);
    freq.put("yb ", 51);
    freq.put("\u03bb", 95);
    freq.put("Ka", 451);
    freq.put("Ke", 308);
    freq.put("Ki", 402);
    freq.put("Kh", 108);
    freq.put("Ko", 131);
    freq.put("Kn", 99);
    freq.put("Kr", 62);
    freq.put("Ku", 119);
    freq.put("Ky", 127);
    freq.put("yby", 49);
    freq.put("Dif", 46);
    freq.put("ghr", 368);
    freq.put("sef", 1510);
    freq.put("ybr", 110);
    freq.put("ybu", 37);
    freq.put("ybi", 137);
    freq.put("ybl", 102);
    freq.put("ybo", 259);
    freq.put("ybe", 40);
    freq.put("Foo", 73);
    freq.put("sol", 527);
    freq.put("hw", 8162);
    freq.put("ht", 520);
    freq.put("hu", 3049);
    freq.put("Pow", 700);
    freq.put("Pot", 63);
    freq.put("Por", 358);
    freq.put("Pos", 39);
    freq.put("Pon", 298);
    freq.put("ra\u0302n", 40);
    freq.put("Pol", 106);
    freq.put("Poi", 41);
    freq.put("Pob", 179);
    freq.put("Cha", 693);
    freq.put("ha", 19081);
    freq.put(" w ", 359);
    freq.put("hf", 267);
    freq.put("hg", 350);
    freq.put("no ", 1182);
    freq.put("Ry", 288);
    freq.put(" we", 3663);
    freq.put("qu", 314);
    freq.put(" wa", 778);
    freq.put(" wn", 253);
    freq.put(" wo", 70);
    freq.put(" wl", 1199);
    freq.put(" wi", 144);
    freq.put(" wr", 987);
    freq.put(" wy", 632);
    freq.put("ebe", 278);
    freq.put("eba", 152);
    freq.put("ebl", 52);
    freq.put("ebo", 143);
    freq.put("ebi", 94);
    freq.put("ebu", 150);
    freq.put("ebr", 165);
    freq.put("eby", 658);
    freq.put("Tex", 55);
    freq.put("dla", 968);
    freq.put("dle", 505);
    freq.put("dli", 219);
    freq.put("dlo", 314);
    freq.put("Jac", 132);
    freq.put("dlw", 464);
    freq.put("dlu", 272);
    freq.put("dly", 168);
    freq.put("eb ", 1399);
    freq.put(" \u0627\u0644", 192);
    freq.put("dl ", 277);
    freq.put(" Ty\u0302", 84);
    freq.put("rpw", 58);
    freq.put("rpa", 573);
    freq.put("rpe", 88);
    freq.put("rpi", 50);
    freq.put("rpo", 41);
    freq.put("Jun", 38);
    freq.put("Jul", 71);
    freq.put("\u0f0b", 38);
    freq.put("\u03bf", 198);
    freq.put("hmo", 38);
    freq.put("hma", 89);
    freq.put("a\u0302d ", 43);
    freq.put("e\u0301", 1125);
    freq.put("e\u0304", 42);
    freq.put("avo", 39);
    freq.put("avi", 469);
    freq.put("ave", 206);
    freq.put("ava", 74);
    freq.put("Hwn", 76);
    freq.put(" T ", 37);
    freq.put("Gwe", 1233);
    freq.put("Gwa", 335);
    freq.put("Gwl", 709);
    freq.put("Gwo", 134);
    freq.put("Gwn", 52);
    freq.put("Gwi", 108);
    freq.put("Gwr", 140);
    freq.put("Gwy", 2266);
    freq.put(" Ty", 472);
    freq.put(" Tw", 270);
    freq.put(" Tu", 591);
    freq.put(" Ts", 358);
    freq.put(" Tr", 1823);
    freq.put(" To", 755);
    freq.put(" Ti", 598);
    freq.put(" Th", 1521);
    freq.put(" Te", 1075);
    freq.put(" Ta", 2095);
    freq.put("mff", 63);
    freq.put("Ei ", 672);
    freq.put("tch", 187);
    freq.put("Far", 105);
    freq.put("sky", 41);
    freq.put("Faw", 386);
    freq.put("Fai", 52);
    freq.put("ska", 87);
    freq.put("Fal", 84);
    freq.put("Uwc", 129);
    freq.put("Fac", 114);
    freq.put("sko", 40);
    freq.put("ski", 51);
    freq.put("Fae", 78);
    freq.put("Eis", 204);
    freq.put("Eit", 40);
    freq.put("T", 9914);
    freq.put("Eig", 43);
    freq.put("Eif", 65);
    freq.put("Eil", 45);
    freq.put("Ein", 91);
    freq.put("sk ", 65);
    freq.put("Sun", 61);
    freq.put("Sum", 39);
    freq.put("Sul", 51);
    freq.put("Sus", 41);
    freq.put("Sur", 47);
    freq.put("nd ", 2894);
    freq.put("ndi", 866);
    freq.put("ndl", 46);
    freq.put("ndo", 502);
    freq.put("nda", 858);
    freq.put("nde", 1235);
    freq.put("ndd", 869);
    freq.put("ndy", 248);
    freq.put("nds", 144);
    freq.put("ndr", 932);
    freq.put("ndu", 125);
    freq.put("ndw", 46);
    freq.put("owl", 62);
    freq.put("own", 249);
    freq.put("owe", 136);
    freq.put("owa", 86);
    freq.put("Afo", 1268);
    freq.put("owy", 855);
    freq.put("o\u0308y", 129);
    freq.put("ows", 37);
    freq.put("owr", 86);
    freq.put("van", 302);
    freq.put("val", 75);
    freq.put("Ama", 68);
    freq.put("Ame", 1251);
    freq.put("Amg", 74);
    freq.put("var", 50);
    freq.put("Ams", 41);
    freq.put("Aff", 460);
    freq.put("Amw", 99);
    freq.put("ef", 16678);
    freq.put("ow ", 296);
    freq.put("Tei", 113);
    freq.put("Tel", 116);
    freq.put("Ten", 65);
    freq.put("Am ", 62);
    freq.put("va ", 105);
    freq.put("Tec", 38);
    freq.put("Teg", 58);
    freq.put("lve", 64);
    freq.put("Tey", 148);
    freq.put("lva", 80);
    freq.put("Ter", 240);
    freq.put("Tes", 46);
    freq.put("Teu", 41);
    freq.put("mys", 130);
    freq.put("myr", 47);
    freq.put("myt", 139);
    freq.put("eu", 11450);
    freq.put("Oyk", 41);
    freq.put("myl", 119);
    freq.put("myn", 3805);
    freq.put("myd", 160);
    freq.put("myg", 57);
    freq.put("myf", 39);
    freq.put("i\u0301 ", 45);
    freq.put("\u043d", 180);
    freq.put("ne\u0308e", 50);
    freq.put("my ", 104);
    freq.put("ndw\u0302", 83);
  }
  
}

