package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class CS extends CLangProfile {
  private static final String name = "cs";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public CS() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 11333226;
    n_words[1] = 13010717;
    n_words[2] = 8780627;

    freq.put("e\u030cko", 1330);
    freq.put("e\u030ckd", 1747);
    freq.put("tne\u030c", 1562);
    freq.put("y\u0301ch", 32937);
    freq.put("e\u030ckt", 1458);
    freq.put("me\u030c", 22506);
    freq.put("oma\u0301", 2183);
    freq.put("ali", 6637);
    freq.put("e\u0301ri", 1326);
    freq.put("aur", 1970);
    freq.put("aut", 3726);
    freq.put("ti\u0301m", 1511);
    freq.put("ec\u030ce", 1504);
    freq.put("i\u0301ci\u0301", 14415);
    freq.put(" Gr", 1717);
    freq.put("ec\u030cn", 6772);
    freq.put(" Ge", 1446);
    freq.put(" Ga", 1588);
    freq.put("dne\u030c", 4952);
    freq.put("upn", 1306);
    freq.put("rea", 1647);
    freq.put("Gr", 1729);
    freq.put("upi", 4594);
    freq.put("mu\u030a", 3291);
    freq.put("upe", 1451);
    freq.put("Za\u0301", 1325);
    freq.put("ti\u0301 ", 11245);
    freq.put("Ge", 1462);
    freq.put("Ga", 1606);
    freq.put("dra\u0301", 1267);
    freq.put("mz\u030c", 1362);
    freq.put(" ka", 8683);
    freq.put("me ", 1813);
    freq.put(" kd", 3115);
    freq.put(" ke", 1672);
    freq.put("z\u030cov", 1554);
    freq.put("mno", 2859);
    freq.put(" kn", 2205);
    freq.put(" ko", 16866);
    freq.put(" kl", 3809);
    freq.put(" km", 3399);
    freq.put(" kr", 8199);
    freq.put(" kv", 1829);
    freq.put(" kt", 24717);
    freq.put(" ku", 2340);
    freq.put("r\u030ca\u0301d", 2065);
    freq.put("di\u0301 ", 3801);
    freq.put("nem", 4884);
    freq.put("nej", 9246);
    freq.put("nek", 1332);
    freq.put("ove\u030c", 6255);
    freq.put("ned", 1356);
    freq.put("neb", 12487);
    freq.put("nec", 2031);
    freq.put("kup", 4964);
    freq.put("kum", 1330);
    freq.put("kul", 2572);
    freq.put("nez", 1422);
    freq.put("hoz\u030c", 1183);
    freq.put("net", 2605);
    freq.put("a\u0301ro", 4387);
    freq.put("ner", 3084);
    freq.put("nes", 3430);
    freq.put("nep", 1631);
    freq.put("med", 1375);
    freq.put(" k ", 5918);
    freq.put("mec", 4748);
    freq.put("i\u0301ch", 18473);
    freq.put("mem", 1269);
    freq.put("i\u0301ce", 2062);
    freq.put("men", 11122);
    freq.put("ors", 1818);
    freq.put("met", 4900);
    freq.put("mer", 5988);
    freq.put("ene\u030c", 1924);
    freq.put("mez", 6394);
    freq.put("gli", 3394);
    freq.put("oro", 4330);
    freq.put("Ze", 1335);
    freq.put("k", 440118);
    freq.put("di\u0301l", 2411);
    freq.put("Za", 1646);
    freq.put("aku", 1247);
    freq.put("akt", 3867);
    freq.put("zdi\u0301", 1212);
    freq.put("ako", 12804);
    freq.put("dro", 2166);
    freq.put("dra", 2227);
    freq.put("uc\u030ca", 1905);
    freq.put("ake", 1229);
    freq.put("ku ", 19613);
    freq.put("zde\u030c", 2035);
    freq.put("bro", 1589);
    freq.put("bri", 1805);
    freq.put("Jeh", 1143);
    freq.put("ord", 1649);
    freq.put("bra", 3506);
    freq.put("dne", 2707);
    freq.put("ena\u0301", 5438);
    freq.put("ore", 3272);
    freq.put("dna", 2226);
    freq.put("m ", 95402);
    freq.put("pr\u030ci", 7219);
    freq.put("ene\u0301", 4823);
    freq.put("dno", 8163);
    freq.put("dni", 1534);
    freq.put("eni\u0301", 16758);
    freq.put("ne\u030cm", 4105);
    freq.put("er ", 7795);
    freq.put("ip", 4762);
    freq.put("si\u0301d", 1352);
    freq.put("ys\u030cs\u030c", 1364);
    freq.put("eny\u0301", 6913);
    freq.put("nka", 1355);
    freq.put("Sta", 2172);
    freq.put("nko", 1306);
    freq.put("Je ", 2998);
    freq.put("ova\u0301", 16410);
    freq.put("V", 19456);
    freq.put("ove\u0301", 14190);
    freq.put("jme", 2592);
    freq.put("me", 40325);
    freq.put("eru", 1909);
    freq.put("erv", 3468);
    freq.put("ma", 25523);
    freq.put(" c\u030ca\u0301", 5494);
    freq.put("mb", 4786);
    freq.put("mm", 1350);
    freq.put(" c\u030ci\u0301", 2219);
    freq.put("mo", 29298);
    freq.put("mn", 8112);
    freq.put("mi", 28342);
    freq.put("erz", 1749);
    freq.put("pr\u030ce", 14856);
    freq.put("mu", 15591);
    freq.put("ere", 2706);
    freq.put("erg", 1674);
    freq.put("tna", 1155);
    freq.put("mp", 4986);
    freq.put("ms", 3506);
    freq.put("mr", 1370);
    freq.put("erm", 2474);
    freq.put("ern", 7190);
    freq.put("ero", 6299);
    freq.put("my", 5631);
    freq.put("eri", 9740);
    freq.put("Le", 3365);
    freq.put("La", 2847);
    freq.put("Lo", 2548);
    freq.put("la ", 20221);
    freq.put("Li", 3491);
    freq.put("ov ", 3056);
    freq.put("Lu", 1426);
    freq.put("ena", 4918);
    freq.put("hod", 8706);
    freq.put("enc", 3468);
    freq.put("end", 1571);
    freq.put("ene", 4580);
    freq.put("dni\u0301", 18004);
    freq.put("eni", 2669);
    freq.put("hol", 1704);
    freq.put("dne\u0301", 1547);
    freq.put("hok", 1282);
    freq.put("enn", 2162);
    freq.put("ci\u0301 ", 18956);
    freq.put("hov", 5549);
    freq.put("Kar", 1595);
    freq.put("hot", 1459);
    freq.put("hou", 1879);
    freq.put("hor", 3514);
    freq.put("voz", 2714);
    freq.put("eny", 2102);
    freq.put(" kr\u030c", 2709);
    freq.put("A", 22558);
    freq.put("ovs", 3742);
    freq.put("lan", 4986);
    freq.put("L ", 1226);
    freq.put("u\u030azn", 1758);
    freq.put("ovy", 1368);
    freq.put("lac", 1653);
    freq.put("jme\u0301", 3893);
    freq.put("pra\u0301", 4755);
    freq.put("ove", 6197);
    freq.put("lat", 5358);
    freq.put("lav", 8047);
    freq.put("ovi", 10902);
    freq.put("ovn", 5524);
    freq.put("ovo", 6751);
    freq.put("las", 7702);
    freq.put("en ", 12357);
    freq.put(" c\u030ce", 12226);
    freq.put("ci\u0301m", 1211);
    freq.put("ma\u0301", 9760);
    freq.put(" c\u030ca", 2613);
    freq.put("ho ", 41844);
    freq.put(" c\u030cl", 2635);
    freq.put("ery\u0301", 10219);
    freq.put("me\u0301", 6077);
    freq.put(" c\u030ci", 5961);
    freq.put(" c\u030ct", 2423);
    freq.put("era\u0301", 7485);
    freq.put("vou", 5924);
    freq.put("my\u0301", 1831);
    freq.put("tne\u0301", 1153);
    freq.put("ere\u0301", 8410);
    freq.put(" V ", 3746);
    freq.put("ra\u0301b", 1423);
    freq.put("ra\u0301c", 2253);
    freq.put("zej", 2847);
    freq.put("s\u030cni\u0301", 1582);
    freq.put("ra\u0301l", 6073);
    freq.put("zen", 7446);
    freq.put("zel", 1300);
    freq.put("zem", 8432);
    freq.put("zer", 1349);
    freq.put("ra\u0301t", 2382);
    freq.put("oni", 3548);
    freq.put(" Ho", 2982);
    freq.put("r\u030cad", 2628);
    freq.put(" Ha", 2917);
    freq.put(" He", 2194);
    freq.put("ana\u0301", 3560);
    freq.put("fir", 1363);
    freq.put("ime", 1223);
    freq.put("ry\u0301", 11309);
    freq.put(" za\u0301", 11557);
    freq.put("n\u030cuj", 1462);
    freq.put("fic", 2581);
    freq.put("ra\u0301", 30974);
    freq.put("fik", 2015);
    freq.put("fin", 1574);
    freq.put("re\u0301", 10396);
    freq.put("fil", 3337);
    freq.put(" Va", 1650);
    freq.put(" du\u030a", 1272);
    freq.put("ze ", 9310);
    freq.put(" Ve", 3306);
    freq.put("ra\u0301 ", 6574);
    freq.put("es\u030cn", 1222);
    freq.put(" Vi", 1986);
    freq.put("zab", 1246);
    freq.put("hyb", 1243);
    freq.put(" Vo", 1286);
    freq.put("ong", 1188);
    freq.put(" Vy", 1684);
    freq.put("es\u030ct", 1436);
    freq.put("osk", 1491);
    freq.put("ake\u0301", 5289);
    freq.put("c\u030cel", 3765);
    freq.put("c\u030cen", 7616);
    freq.put("l", 442609);
    freq.put("ate\u0301", 1146);
    freq.put("c\u030cet", 1680);
    freq.put("c\u030ces", 6771);
    freq.put("c\u030cer", 2858);
    freq.put("ons", 4146);
    freq.put("raz\u030c", 1181);
    freq.put("cka\u0301", 6180);
    freq.put("rt", 11161);
    freq.put("ru", 27381);
    freq.put("rv", 11951);
    freq.put(" zn", 6476);
    freq.put("rp", 2592);
    freq.put("rr", 2082);
    freq.put("rs", 10884);
    freq.put(" ze", 8914);
    freq.put(" zd", 2577);
    freq.put("dst", 2606);
    freq.put(" za", 18239);
    freq.put("ry", 11066);
    freq.put("rz", 2926);
    freq.put("rd", 6788);
    freq.put("re", 36192);
    freq.put("rg", 7113);
    freq.put("ra", 81349);
    freq.put("rb", 3000);
    freq.put("rc", 6965);
    freq.put("rl", 3217);
    freq.put("rm", 10574);
    freq.put("rn", 21334);
    freq.put("ro", 116857);
    freq.put("rh", 1365);
    freq.put("aje", 2039);
    freq.put("rk", 6663);
    freq.put("ntr", 2728);
    freq.put("ntu", 1650);
    freq.put("nti", 4061);
    freq.put("ltu", 1148);
    freq.put("W", 5350);
    freq.put("nta", 3294);
    freq.put("e\u030cji", 2384);
    freq.put("nte", 4199);
    freq.put("ate", 11112);
    freq.put("ata", 3060);
    freq.put("atn", 1969);
    freq.put("ato", 5121);
    freq.put("rac\u030c", 1242);
    freq.put(" z ", 20036);
    freq.put("ati", 10351);
    freq.put("s\u030ci\u0301r\u030c", 1269);
    freq.put("atu", 2078);
    freq.put("r ", 22705);
    freq.put("ism", 2509);
    freq.put("isl", 2097);
    freq.put("i\u0301ta", 1783);
    freq.put("a\u0301zv", 1186);
    freq.put("ra\u0301n", 2154);
    freq.put("la\u0301 ", 1917);
    freq.put("ji\u0301 ", 9261);
    freq.put("tek", 2779);
    freq.put("osa", 2963);
    freq.put("nis", 3526);
    freq.put("ry\u0301c", 1165);
    freq.put("tem", 4570);
    freq.put("tor", 9066);
    freq.put("tos", 1217);
    freq.put("top", 2079);
    freq.put("teo", 1298);
    freq.put("tov", 8578);
    freq.put("tou", 3172);
    freq.put("tok", 1791);
    freq.put("toh", 1166);
    freq.put("xis", 1170);
    freq.put("ton", 3319);
    freq.put("tol", 3953);
    freq.put("tom", 3677);
    freq.put("skl", 1707);
    freq.put("kt ", 1234);
    freq.put(" le", 12637);
    freq.put("B", 22848);
    freq.put(" la", 3675);
    freq.put("y\u0301va", 2863);
    freq.put(" lo", 3118);
    freq.put(" li", 8468);
    freq.put("la\u0301t", 1414);
    freq.put("vyv", 1398);
    freq.put("ni ", 2504);
    freq.put("z\u030ci", 11885);
    freq.put("ktu", 2012);
    freq.put("i\u0301", 321621);
    freq.put("ktr", 2141);
    freq.put("aly\u0301", 1783);
    freq.put("kti", 3026);
    freq.put("kte", 27582);
    freq.put("to ", 14761);
    freq.put("raf", 2398);
    freq.put("rad", 5238);
    freq.put("rab", 1667);
    freq.put("rac", 4788);
    freq.put("ran", 13598);
    freq.put("s\u030ci\u0301 ", 8873);
    freq.put("ral", 1943);
    freq.put("ram", 4289);
    freq.put("raj", 4559);
    freq.put("rak", 3296);
    freq.put("rah", 1855);
    freq.put("rav", 9308);
    freq.put("rat", 6479);
    freq.put("ras", 1475);
    freq.put("raz", 3775);
    freq.put("rz\u030c", 1454);
    freq.put("rsk", 6183);
    freq.put("ru\u030a ", 3148);
    freq.put("rs\u030c", 2140);
    freq.put("ru\u030a", 8094);
    freq.put("ci\u0301c", 3683);
    freq.put("nen", 1766);
    freq.put("s\u030ci\u0301m", 3926);
    freq.put(" la\u0301", 1294);
    freq.put("s\u030ci\u0301c", 3060);
    freq.put("y", 191798);
    freq.put("e\u030cjs\u030c", 4291);
    freq.put("za ", 5089);
    freq.put("bsk", 1200);
    freq.put("rc\u030c", 2879);
    freq.put("ogr", 3240);
    freq.put("typ", 2401);
    freq.put("bsa", 1785);
    freq.put("atr\u030c", 2572);
    freq.put("dok", 1496);
    freq.put("dol", 1600);
    freq.put("dom", 1869);
    freq.put("dob", 7531);
    freq.put("m", 328621);
    freq.put("dor", 1289);
    freq.put("dos", 2695);
    freq.put("dop", 2114);
    freq.put("u\u030az\u030ce", 1655);
    freq.put("dov", 6030);
    freq.put("dou", 1896);
    freq.put(" Wa", 1184);
    freq.put("ne\u0301 ", 18438);
    freq.put("e\u0301r", 4128);
    freq.put("e\u0301t", 2091);
    freq.put("d ", 32945);
    freq.put(" Wi", 1593);
    freq.put("e\u0301h", 25602);
    freq.put("e\u0301m", 16118);
    freq.put("e\u0301l", 1388);
    freq.put("e\u0301n", 5964);
    freq.put("ke\u0301 ", 30775);
    freq.put("e\u0301d", 1164);
    freq.put("oci", 2151);
    freq.put("och", 4480);
    freq.put("ock", 1389);
    freq.put("aco", 1432);
    freq.put("ac\u030co", 2232);
    freq.put("ac\u030cn", 3017);
    freq.put("ac\u030ce", 3487);
    freq.put("hro", 1617);
    freq.put("abs", 1339);
    freq.put("ba ", 3672);
    freq.put(" u\u0301z", 3683);
    freq.put("hra", 7196);
    freq.put(" u\u0301s", 1372);
    freq.put("pr\u030ci\u0301", 8711);
    freq.put("dn", 44007);
    freq.put("do", 40054);
    freq.put("dl", 11857);
    freq.put("dm", 3275);
    freq.put("dk", 3086);
    freq.put("dh", 1175);
    freq.put("di", 24806);
    freq.put("dd", 1592);
    freq.put("de", 36807);
    freq.put("db", 1918);
    freq.put("dc", 2442);
    freq.put("da", 22450);
    freq.put("ke\u0301h", 13733);
    freq.put("ke\u0301m", 5563);
    freq.put("dy", 13097);
    freq.put("dv", 6535);
    freq.put("e\u0301 ", 80173);
    freq.put("du", 15000);
    freq.put("dr", 15992);
    freq.put("ds", 6618);
    freq.put("dp", 2177);
    freq.put("eme", 2383);
    freq.put("va\u0301 ", 12375);
    freq.put("ak ", 5398);
    freq.put("bar", 2156);
    freq.put("z\u030ci\u0301c", 1641);
    freq.put("emo", 2184);
    freq.put("emn", 1840);
    freq.put("emi", 4395);
    freq.put("z\u030ci\u0301v", 5443);
    freq.put("bal", 2672);
    freq.put(" me\u030c", 10287);
    freq.put("om ", 1785);
    freq.put("iz\u030c", 5869);
    freq.put("nut", 2319);
    freq.put("e\u030cme", 3785);
    freq.put("nuj", 1460);
    freq.put("is\u030c", 4295);
    freq.put("oma", 2266);
    freq.put("il ", 4856);
    freq.put("nic\u030c", 2090);
    freq.put("i\u0301st", 3954);
    freq.put("co ", 1224);
    freq.put("i\u0301sl", 1496);
    freq.put("irm", 1303);
    freq.put("iro", 1733);
    freq.put("i\u0301se", 1140);
    freq.put("mun", 1943);
    freq.put("hra\u0301", 2941);
    freq.put("y\u0301zn", 2182);
    freq.put("we", 1453);
    freq.put("di\u0301", 8010);
    freq.put("wa", 2470);
    freq.put("de\u0301", 2586);
    freq.put("omi", 2447);
    freq.put("omo", 5000);
    freq.put("da\u0301", 9259);
    freq.put("cky\u0301", 12856);
    freq.put("dy\u0301", 1471);
    freq.put(" In", 2868);
    freq.put("r\u030c", 105343);
    freq.put("eln", 3331);
    freq.put("nu ", 7672);
    freq.put("e\u030cz\u030cn", 1182);
    freq.put("ile", 1526);
    freq.put("cou", 2423);
    freq.put("ici\u0301", 1825);
    freq.put("ila", 2431);
    freq.put("iln", 1971);
    freq.put("ilo", 3489);
    freq.put("ill", 1963);
    freq.put("ilm", 2591);
    freq.put("ili", 3988);
    freq.put("ic\u030c", 7118);
    freq.put("mu ", 8025);
    freq.put("uni", 2964);
    freq.put("unk", 1600);
    freq.put("stv", 6645);
    freq.put(" me", 11211);
    freq.put(" ma", 9419);
    freq.put("e\u0301z\u030c", 3751);
    freq.put(" ml", 1339);
    freq.put(" mn", 2424);
    freq.put(" mo", 9457);
    freq.put(" mi", 4779);
    freq.put(" mu", 2661);
    freq.put("sah", 2489);
    freq.put("ii\u0301", 2470);
    freq.put("ia\u0301", 5235);
    freq.put(" my", 1417);
    freq.put("eme\u030c", 2087);
    freq.put("ana", 4560);
    freq.put("fra", 2633);
    freq.put("rga", 2761);
    freq.put("C ", 2405);
    freq.put("ac\u030cu", 2194);
    freq.put("de\u030c", 13132);
    freq.put("pro", 30809);
    freq.put(" u\u0301c\u030c", 1533);
    freq.put("du\u030a", 3418);
    freq.put("ano", 3773);
    freq.put(" m ", 1247);
    freq.put("ii\u0301 ", 2195);
    freq.put("pri", 1503);
    freq.put("ani", 8977);
    freq.put("dsk", 2773);
    freq.put("els", 2269);
    freq.put("R\u030c", 1405);
    freq.put("Ch", 3956);
    freq.put("Co", 3211);
    freq.put("slu", 2567);
    freq.put("Ca", 2582);
    freq.put("i\u0301le", 1385);
    freq.put("Ce", 1274);
    freq.put("n", 728035);
    freq.put("slo", 9919);
    freq.put("dr\u030c", 2617);
    freq.put("sle", 3342);
    freq.put("sla", 4078);
    freq.put("iz", 8625);
    freq.put(" ma\u0301", 2572);
    freq.put(" mi\u0301", 3137);
    freq.put("is", 36532);
    freq.put("ir", 8411);
    freq.put("iu", 2679);
    freq.put("it", 38607);
    freq.put("iv", 18333);
    freq.put("ii", 6209);
    freq.put("ih", 5555);
    freq.put("ik", 23953);
    freq.put("ij", 4185);
    freq.put("im", 9173);
    freq.put("il", 27036);
    freq.put("io", 12386);
    freq.put("in", 70373);
    freq.put("ia", 10547);
    freq.put("ic", 65339);
    freq.put("ib", 5266);
    freq.put("ie", 19796);
    freq.put("id", 15111);
    freq.put("ig", 6211);
    freq.put("if", 3335);
    freq.put("V ", 4585);
    freq.put("uje", 11818);
    freq.put("z\u030csk", 1623);
    freq.put("ome\u030c", 1557);
    freq.put("\u0441", 1165);
    freq.put("nik", 6308);
    freq.put("nih", 1649);
    freq.put("nin", 2133);
    freq.put("nic", 12884);
    freq.put("vzd", 1455);
    freq.put("nie", 1760);
    freq.put("niz", 2240);
    freq.put("pe\u030cv", 1148);
    freq.put("Y", 1260);
    freq.put("i ", 90037);
    freq.put("br\u030ce", 2487);
    freq.put("niv", 1387);
    freq.put("nit", 3056);
    freq.put("Va", 1654);
    freq.put("Ve", 3321);
    freq.put("Vi", 2012);
    freq.put("thu", 1152);
    freq.put("epu", 2593);
    freq.put("epr", 1430);
    freq.put("Vo", 1294);
    freq.put("Vy", 1686);
    freq.put("the", 1375);
    freq.put("rs\u030ci\u0301", 1390);
    freq.put("oli\u0301", 1626);
    freq.put("elk", 5262);
    freq.put("eli", 4792);
    freq.put("hal", 1464);
    freq.put("elo", 2426);
    freq.put("han", 1905);
    freq.put("elm", 1412);
    freq.put("ela", 2337);
    freq.put("ele", 12125);
    freq.put("er\u030c", 2784);
    freq.put("har", 2922);
    freq.put("opu", 1150);
    freq.put("rni", 1331);
    freq.put("rno", 1887);
    freq.put("D", 14883);
    freq.put("opr", 3218);
    freq.put("ops", 1833);
    freq.put("rna", 1957);
    freq.put("tr\u030ci", 1228);
    freq.put("ope", 2692);
    freq.put("opa", 2307);
    freq.put("opo", 2402);
    freq.put("opi", 2216);
    freq.put("rnu", 1168);
    freq.put("c\u030cuj", 2526);
    freq.put("obi\u0301", 2810);
    freq.put("ha ", 4741);
    freq.put("el ", 8637);
    freq.put("tu\u030a ", 3433);
    freq.put("ola", 2087);
    freq.put("Jed", 1974);
    freq.put(" Ju", 1242);
    freq.put("oli", 8828);
    freq.put("oln", 2388);
    freq.put("olo", 8650);
    freq.put(" Jo", 1792);
    freq.put("ols", 1995);
    freq.put(" Ji", 2194);
    freq.put("olu", 2611);
    freq.put(" Je", 8552);
    freq.put("oly", 1795);
    freq.put(" Ja", 4310);
    freq.put("ick", 33133);
    freq.put("ici", 3981);
    freq.put("ich", 6375);
    freq.put("for", 4925);
    freq.put("nu\u030a", 2947);
    freq.put("Hr", 1212);
    freq.put("ns\u030c", 1672);
    freq.put("ica", 1513);
    freq.put("i\u0301pa", 1629);
    freq.put("ice", 11279);
    freq.put("ykl", 2523);
    freq.put("ume", 1179);
    freq.put(" ne\u030c", 9405);
    freq.put("Ho", 2992);
    freq.put("nz\u030c", 1154);
    freq.put("umb", 1314);
    freq.put("umo", 1169);
    freq.put("Ha", 2931);
    freq.put("kve\u030c", 1156);
    freq.put("He", 2201);
    freq.put("ol ", 1430);
    freq.put("rne\u0301", 1326);
    freq.put("nc\u030c", 1796);
    freq.put("rni\u0301", 7275);
    freq.put("ple", 1738);
    freq.put("ne\u030c", 45741);
    freq.put("pla", 3524);
    freq.put("plo", 2559);
    freq.put("obn", 3328);
    freq.put("obo", 2639);
    freq.put("obl", 4657);
    freq.put("obj", 2067);
    freq.put("obi", 2455);
    freq.put("obd", 1788);
    freq.put("ic ", 2965);
    freq.put("obc", 2803);
    freq.put("o", 890229);
    freq.put("oba", 1485);
    freq.put("um ", 4532);
    freq.put("oby", 3426);
    freq.put("obv", 2042);
    freq.put("obu", 1622);
    freq.put("obr", 2915);
    freq.put("obs", 1745);
    freq.put("lej", 1379);
    freq.put("soc", 1565);
    freq.put("aha", 1562);
    freq.put("a\u0301na", 2621);
    freq.put("nne\u0301", 1576);
    freq.put("sof", 1375);
    freq.put("ve\u030c ", 4735);
    freq.put("a\u0301no", 2096);
    freq.put("nu\u030a ", 2566);
    freq.put("a\u0301ni", 1332);
    freq.put("son", 1432);
    freq.put("ahr", 2506);
    freq.put("a\u0301nu", 1360);
    freq.put("sou", 17153);
    freq.put("a\u0301ns", 1949);
    freq.put("a\u0301ny", 1316);
    freq.put("ole", 10375);
    freq.put("ne\u0301", 26518);
    freq.put("art", 3122);
    freq.put("ni\u0301", 119912);
    freq.put("c\u030cne\u0301", 1325);
    freq.put("na\u0301", 41081);
    freq.put("rne\u030c", 2168);
    freq.put("gie", 2007);
    freq.put("gic", 2475);
    freq.put("ny\u0301", 29623);
    freq.put("gio", 1330);
    freq.put("gin", 1170);
    freq.put("gii", 1170);
    freq.put("ve\u030ck", 2228);
    freq.put("a\u0301n ", 4623);
    freq.put("e\u030cls", 1244);
    freq.put(" na\u0301", 11985);
    freq.put("ve\u030cd", 2018);
    freq.put(" Le", 3350);
    freq.put("e\u030cle", 2558);
    freq.put("ve\u030cz", 1289);
    freq.put("Z", 7679);
    freq.put("ve\u030ct", 11745);
    freq.put("ura", 2035);
    freq.put("ry\u0301 ", 8817);
    freq.put("aze", 2771);
    freq.put("azy", 2655);
    freq.put("i\u0301ro", 1439);
    freq.put("i\u0301rk", 1295);
    freq.put("azu", 1350);
    freq.put("sve\u030c", 5020);
    freq.put("nno", 1485);
    freq.put("a\u0301ni\u0301", 9623);
    freq.put(" Li", 3464);
    freq.put("ni", 45831);
    freq.put("nk", 8297);
    freq.put("pre", 2679);
    freq.put("nn", 8311);
    freq.put("no", 57801);
    freq.put("tit", 2068);
    freq.put("na", 97771);
    freq.put("tiv", 5666);
    freq.put("nc", 16128);
    freq.put("nd", 14047);
    freq.put("ne", 57176);
    freq.put("nf", 2490);
    freq.put("ng", 13163);
    freq.put("til", 1384);
    freq.put("ny", 17200);
    freq.put("nz", 2252);
    freq.put("tio", 2588);
    freq.put("tik", 3154);
    freq.put("ns", 25831);
    freq.put("nt", 27386);
    freq.put("nu", 14720);
    freq.put("tic", 11897);
    freq.put(" ni", 2426);
    freq.put("fot", 2015);
    freq.put("E", 9868);
    freq.put(" no", 3710);
    freq.put("la\u0301s\u030c", 1492);
    freq.put(" na", 43193);
    freq.put(" ne", 33309);
    freq.put("t\u030c ", 1589);
    freq.put("ume\u030c", 1413);
    freq.put("ele\u0301", 1267);
    freq.put("tec", 6325);
    freq.put("obr\u030c", 1215);
    freq.put("ovy\u0301", 12973);
    freq.put("n ", 43523);
    freq.put("u\u030a", 48717);
    freq.put("azy\u0301", 1373);
    freq.put("rk ", 1359);
    freq.put("ti ", 14561);
    freq.put("du\u030a ", 1701);
    freq.put("roj", 4450);
    freq.put("rok", 8745);
    freq.put("rol", 2078);
    freq.put("rom", 4735);
    freq.put("ron", 3499);
    freq.put("osp", 1323);
    freq.put("rob", 3794);
    freq.put("roc", 8820);
    freq.put("c\u030ctv", 1158);
    freq.put("ost", 32198);
    freq.put("rof", 1452);
    freq.put("rog", 2059);
    freq.put("osi", 1402);
    freq.put("Byl", 1846);
    freq.put("osm", 1339);
    freq.put("osl", 4606);
    freq.put("oso", 3077);
    freq.put("rop", 5057);
    freq.put("lla", 1318);
    freq.put("ros", 9033);
    freq.put("rot", 4473);
    freq.put("rou", 3738);
    freq.put("rov", 17134);
    freq.put("te\u0301z\u030c", 3726);
    freq.put("ver", 8833);
    freq.put("ves", 2177);
    freq.put("di ", 2989);
    freq.put("zu ", 1323);
    freq.put("ved", 2640);
    freq.put("yva", 1858);
    freq.put("ven", 9163);
    freq.put("is\u030ct", 1515);
    freq.put("vel", 5581);
    freq.put("vem", 1785);
    freq.put(" do", 19631);
    freq.put("bni\u0301", 3217);
    freq.put("S\u030c", 3572);
    freq.put("ro ", 11368);
    freq.put("d\u030c ", 1420);
    freq.put("os ", 1967);
    freq.put("ll ", 1176);
    freq.put("din", 4766);
    freq.put("dio", 1325);
    freq.put("die", 1484);
    freq.put("ers", 3684);
    freq.put("dia", 1263);
    freq.put("dic", 1916);
    freq.put("p", 289793);
    freq.put("o\u0301n", 1579);
    freq.put("ve ", 12748);
    freq.put("ml", 2209);
    freq.put("div", 1579);
    freq.put("ict", 1675);
    freq.put("der", 3512);
    freq.put("o\u0301d", 1198);
    freq.put("des", 2009);
    freq.put("M ", 1302);
    freq.put("ruk", 1449);
    freq.put("dev", 1882);
    freq.put("ez\u030ci", 1875);
    freq.put("i\u0301ho", 9884);
    freq.put("rum", 1222);
    freq.put("ek ", 7971);
    freq.put("rub", 1147);
    freq.put("a\u0301me\u030c", 1142);
    freq.put("nez\u030c", 1270);
    freq.put("bo ", 10795);
    freq.put("sne\u030c", 1417);
    freq.put("rva", 1915);
    freq.put("era", 5702);
    freq.put("Me", 3379);
    freq.put("Ma", 8187);
    freq.put("Mo", 4597);
    freq.put("Mi", 4015);
    freq.put("ez\u030c ", 1798);
    freq.put("O", 10801);
    freq.put("deb", 1947);
    freq.put("eko", 2098);
    freq.put("ekl", 1253);
    freq.put("bor", 3758);
    freq.put("bou", 1297);
    freq.put("bov", 1176);
    freq.put("boj", 1202);
    freq.put("bol", 1903);
    freq.put("ekt", 6413);
    freq.put("bod", 1239);
    freq.put("uze", 1855);
    freq.put("uzs", 2041);
    freq.put(" Ka", 5019);
    freq.put(" Ko", 4081);
    freq.put(" Kl", 1383);
    freq.put(" Kr", 2542);
    freq.put("te\u0301m", 3602);
    freq.put("msk", 2845);
    freq.put("ult", 2459);
    freq.put(" Ku", 1171);
    freq.put("ca ", 1459);
    freq.put("jve\u030c", 1879);
    freq.put("F", 10603);
    freq.put("sni\u0301", 1788);
    freq.put("sne\u0301", 1153);
    freq.put("ma ", 3621);
    freq.put("a\u0301my\u0301", 1162);
    freq.put("Evr", 1575);
    freq.put("zna\u0301", 4232);
    freq.put("ibl", 1394);
    freq.put("zni\u0301", 1327);
    freq.put("se\u0301", 1859);
    freq.put("uli", 1303);
    freq.put("ulo", 1228);
    freq.put("si\u0301", 5664);
    freq.put("sa\u0301", 2703);
    freq.put("ula", 1664);
    freq.put("te\u0301 ", 3506);
    freq.put("zny\u0301", 1440);
    freq.put("obe", 3958);
    freq.put(" ok", 4623);
    freq.put(" of", 1957);
    freq.put("a\u0301m ", 1274);
    freq.put(" od", 14999);
    freq.put(" ob", 22345);
    freq.put(" oc", 1666);
    freq.put("spi", 1842);
    freq.put(" oz", 5841);
    freq.put("spo", 10422);
    freq.put(" ov", 1214);
    freq.put("e\u030c", 138011);
    freq.put(" or", 4357);
    freq.put(" os", 6522);
    freq.put(" op", 3355);
    freq.put("kyt", 2072);
    freq.put("ny ", 15609);
    freq.put("n\u030cu", 1474);
    freq.put("s ", 40054);
    freq.put("mar", 1328);
    freq.put("mat", 5599);
    freq.put("a\u0301mo", 1148);
    freq.put("ky ", 27061);
    freq.put(" o ", 7191);
    freq.put("sni", 1352);
    freq.put("zuj", 1535);
    freq.put("mac", 1223);
    freq.put("ity\u0301", 2115);
    freq.put("dna\u0301", 2916);
    freq.put("lmi", 1186);
    freq.put("maj", 1332);
    freq.put("mal", 2994);
    freq.put("man", 3894);
    freq.put("sy", 7700);
    freq.put("ss", 3706);
    freq.put("sr", 1708);
    freq.put("zni", 4038);
    freq.put("sp", 20097);
    freq.put("sv", 12247);
    freq.put("su", 6657);
    freq.put("st", 145711);
    freq.put("q", 1288);
    freq.put("si", 15634);
    freq.put("sh", 2118);
    freq.put("so", 35354);
    freq.put("sn", 8865);
    freq.put("sm", 8745);
    freq.put("sl", 22654);
    freq.put("sc", 4718);
    freq.put("sb", 1371);
    freq.put("sa", 15498);
    freq.put("se", 52884);
    freq.put("Ru", 1888);
    freq.put("pi\u0301s", 1810);
    freq.put("pu\u030av", 2875);
    freq.put("ea\u0301", 1247);
    freq.put("lsk", 6596);
    freq.put("Re", 2582);
    freq.put("sob", 5198);
    freq.put("Ra", 2507);
    freq.put("Ro", 3655);
    freq.put("eji\u0301", 5227);
    freq.put(" ab", 1328);
    freq.put("jic", 2414);
    freq.put("cu\u030a ", 1941);
    freq.put("jin", 3546);
    freq.put(" ak", 1935);
    freq.put(" al", 5289);
    freq.put(" am", 3804);
    freq.put(" an", 6347);
    freq.put("gen", 3213);
    freq.put(" ap", 1198);
    freq.put(" ar", 3304);
    freq.put(" as", 2951);
    freq.put(" at", 1332);
    freq.put(" au", 3694);
    freq.put("zar\u030c", 1286);
    freq.put("ent", 12967);
    freq.put("nol", 1273);
    freq.put("ri", 39119);
    freq.put("noh", 2321);
    freq.put("mu\u030az\u030c", 1309);
    freq.put("is ", 3839);
    freq.put("e\u030cst", 9587);
    freq.put("R ", 1716);
    freq.put("not", 3595);
    freq.put("nou", 8746);
    freq.put("nov", 9782);
    freq.put("nor", 2008);
    freq.put("nos", 13323);
    freq.put(" a ", 53430);
    freq.put("zac\u030c", 1189);
    freq.put("a\u0301ce", 1349);
    freq.put("a\u0301ch", 3663);
    freq.put("s\u030cak", 1283);
    freq.put("em", 54636);
    freq.put("el", 51949);
    freq.put("eo", 6058);
    freq.put("en", 103592);
    freq.put("ei", 3682);
    freq.put("eh", 9007);
    freq.put("ek", 22014);
    freq.put("ej", 27806);
    freq.put("ee", 1918);
    freq.put("ed", 50406);
    freq.put("eg", 5751);
    freq.put("ef", 3385);
    freq.put("ea", 6165);
    freq.put("ec", 32017);
    freq.put("eb", 20255);
    freq.put("ne\u030c ", 25254);
    freq.put("ey", 1497);
    freq.put("ex", 5658);
    freq.put("ez", 19185);
    freq.put("eu", 3247);
    freq.put("et", 33365);
    freq.put("ew", 1387);
    freq.put("ev", 22848);
    freq.put("ep", 11390);
    freq.put("es", 44385);
    freq.put("er", 89316);
    freq.put("ejm", 2020);
    freq.put("ejn", 3303);
    freq.put("eji", 2735);
    freq.put("ona\u0301", 1885);
    freq.put("lad", 8838);
    freq.put("bli", 4783);
    freq.put("ejv", 3622);
    freq.put("bla", 3565);
    freq.put("ejs", 2194);
    freq.put("G", 9505);
    freq.put("ory", 1722);
    freq.put("ort", 3045);
    freq.put("oru", 3220);
    freq.put("e ", 246825);
    freq.put("orn", 2809);
    freq.put("dpo", 1574);
    freq.put("orm", 4795);
    freq.put("y\u0301s\u030c", 1701);
    freq.put("ork", 1330);
    freq.put("ori", 6242);
    freq.put("org", 3417);
    freq.put("ne\u030cj", 4079);
    freq.put("ne\u030ck", 4566);
    freq.put("ne\u030cl", 1306);
    freq.put("u\u030avo", 3624);
    freq.put("ne\u030cn", 3988);
    freq.put("ora", 3762);
    freq.put("zi\u0301 ", 4964);
    freq.put("ej ", 1214);
    freq.put("ova", 19936);
    freq.put("usk", 3978);
    freq.put("eti\u0301", 2247);
    freq.put("ane\u030c", 2278);
    freq.put("zal", 3135);
    freq.put("xi", 2953);
    freq.put("hu ", 4702);
    freq.put(" r\u030ci\u0301", 3390);
    freq.put("zah", 1842);
    freq.put("de\u030cn", 1255);
    freq.put("onc", 1948);
    freq.put("de\u030cl", 3685);
    freq.put("ona", 3352);
    freq.put("de\u030cj", 2198);
    freq.put("ane\u0301", 4536);
    freq.put("ond", 1711);
    freq.put("one", 2668);
    freq.put("ma\u0301 ", 3426);
    freq.put("ru\u030az", 1961);
    freq.put("ony", 1528);
    freq.put("any\u0301", 5688);
    freq.put("mu\u030a ", 1642);
    freq.put("zas", 1298);
    freq.put("xt", 1600);
    freq.put("onu", 1779);
    freq.put("ial", 1377);
    freq.put("ian", 1754);
    freq.put("uko", 1228);
    freq.put("jiz\u030c", 2514);
    freq.put(" az\u030c", 2786);
    freq.put("hud", 2458);
    freq.put("e\u030cny\u0301", 1390);
    freq.put("ma\u0301t", 1458);
    freq.put("de\u030c ", 4195);
    freq.put(" Ze", 1330);
    freq.put("hum", 1365);
    freq.put("x ", 2742);
    freq.put(" Za", 1643);
    freq.put(" di\u0301", 1705);
    freq.put("huj", 1855);
    freq.put("noz\u030c", 1329);
    freq.put("e\u030cni\u0301", 3741);
    freq.put("ke ", 1607);
    freq.put("ma\u0301n", 1640);
    freq.put("c\u030cas", 5969);
    freq.put("ia ", 4182);
    freq.put("mi\u0301", 11983);
    freq.put("r", 514188);
    freq.put("zsk", 2646);
    freq.put("a\u0301ln", 9542);
    freq.put("a\u0301lo", 2573);
    freq.put("bi\u0301 ", 2241);
    freq.put("ang", 5036);
    freq.put("pra", 9290);
    freq.put("a\u0301lk", 1854);
    freq.put("sam", 2091);
    freq.put("a\u0301li", 1317);
    freq.put(" r\u030ca", 1815);
    freq.put("ann", 1847);
    freq.put("a\u0301le", 4254);
    freq.put("es\u030c", 4400);
    freq.put(" r\u030ce", 4682);
    freq.put("ank", 1763);
    freq.put("ant", 5679);
    freq.put("anu", 1370);
    freq.put("ez\u030c", 8504);
    freq.put("y\u0301 ", 58367);
    freq.put("ans", 3967);
    freq.put(" ni\u0301", 1455);
    freq.put("a\u0301lu", 1211);
    freq.put("any", 1635);
    freq.put("sau", 1548);
    freq.put("Do", 2726);
    freq.put("en\u030c", 2211);
    freq.put("Di", 1704);
    freq.put("r\u030ce ", 3029);
    freq.put("De", 2027);
    freq.put("Da", 2148);
    freq.put("zor", 1418);
    freq.put("\u0435", 1554);
    freq.put("zov", 3172);
    freq.put("y\u0301t", 1801);
    freq.put("y\u0301v", 5852);
    freq.put("an ", 5076);
    freq.put("y\u0301s", 1457);
    freq.put("y\u0301r", 2669);
    freq.put("sa ", 1633);
    freq.put(" Za\u0301", 1320);
    freq.put("a\u0301l ", 2023);
    freq.put("y\u0301z", 2981);
    freq.put("oru\u030a", 1170);
    freq.put("y\u0301c", 33402);
    freq.put("y\u0301m", 16378);
    freq.put("ec\u030c", 10324);
    freq.put("r\u030cek", 2349);
    freq.put("r\u030cej", 1316);
    freq.put("r\u030cel", 1284);
    freq.put(" La", 2820);
    freq.put("r\u030cen", 6131);
    freq.put(" Lo", 2542);
    freq.put("r\u030cec", 3115);
    freq.put("r\u030ceb", 1351);
    freq.put("r\u030ced", 13088);
    freq.put("D ", 1568);
    freq.put(" Lu", 1423);
    freq.put("r\u030cez", 1271);
    freq.put("r\u030ces", 3291);
    freq.put("r\u030cet", 1507);
    freq.put("r\u030cev", 1736);
    freq.put("lny\u0301", 1549);
    freq.put("tka", 3033);
    freq.put("tko", 1227);
    freq.put("s\u030ci\u0301", 18419);
    freq.put("lni\u0301", 11343);
    freq.put("rma\u0301", 1574);
    freq.put("lne\u0301", 1553);
    freq.put("or\u030ci", 1304);
    freq.put("li\u0301 ", 2188);
    freq.put("or\u030ce", 3041);
    freq.put("dy ", 11421);
    freq.put("tky", 1508);
    freq.put("e\u030clo", 1511);
    freq.put("Wa", 1205);
    freq.put("por\u030c", 1288);
    freq.put("iti", 3568);
    freq.put("lub", 1957);
    freq.put("Wi", 1615);
    freq.put("\u0430", 2293);
    freq.put("zpu\u030a", 1462);
    freq.put(" Hr", 1206);
    freq.put(" ps", 1456);
    freq.put(" pr", 44618);
    freq.put("H", 14139);
    freq.put("ts\u030ci", 1374);
    freq.put("ji\u0301", 23302);
    freq.put(" pa", 10148);
    freq.put(" pe", 2741);
    freq.put(" po", 56929);
    freq.put("ja\u0301", 1158);
    freq.put(" pl", 5963);
    freq.put("ra\u0301v", 4812);
    freq.put("sve\u0301", 1798);
    freq.put("oc\u030ce", 1902);
    freq.put("o\u0301", 5647);
    freq.put("poc\u030c", 3912);
    freq.put(" by\u0301", 3017);
    freq.put("zev", 2458);
    freq.put("s\u030ca", 2373);
    freq.put("s\u030ce", 8882);
    freq.put("s\u030ci", 4496);
    freq.put("s\u030ck", 3546);
    freq.put("ity", 1661);
    freq.put("s\u030cl", 1812);
    freq.put("s\u030cn", 3181);
    freq.put("or\u030ci\u0301", 2027);
    freq.put("rma", 3339);
    freq.put("lni", 1153);
    freq.put("s\u030ct", 7997);
    freq.put("tu ", 7164);
    freq.put("j ", 5728);
    freq.put("rmo", 1370);
    freq.put("vu ", 2977);
    freq.put("ytv", 1652);
    freq.put("ytu", 1246);
    freq.put("yto", 1723);
    freq.put("obe\u030c", 2552);
    freq.put("odp", 1587);
    freq.put("tur", 4631);
    freq.put("s\u030c ", 1248);
    freq.put("y\u0301t ", 1211);
    freq.put("tup", 3639);
    freq.put("ju", 1525);
    freq.put("jv", 3866);
    freq.put("js", 11164);
    freq.put("jm", 7494);
    freq.put(" pa\u0301", 1635);
    freq.put("jo", 3496);
    freq.put("ji", 17967);
    freq.put("je", 121519);
    freq.put("tud", 1736);
    freq.put("ja", 17600);
    freq.put(" pi\u0301", 1932);
    freq.put(" be", 2412);
    freq.put(" ba", 3819);
    freq.put("oc\u030ci", 1195);
    freq.put(" bo", 3752);
    freq.put(" bi", 2222);
    freq.put("P ", 1532);
    freq.put(" bu", 3054);
    freq.put("s", 514164);
    freq.put(" br", 3187);
    freq.put(" by", 19260);
    freq.put("poz", 3018);
    freq.put("i\u0301z\u030c ", 1472);
    freq.put("pot", 2565);
    freq.put("pou", 6174);
    freq.put("por", 4291);
    freq.put("pos", 5385);
    freq.put("pop", 2679);
    freq.put("pon", 2428);
    freq.put("pol", 12866);
    freq.put("pom", 2458);
    freq.put("poj", 5321);
    freq.put("imo", 1396);
    freq.put("ni\u0301 ", 79844);
    freq.put("pod", 13049);
    freq.put("pob", 1330);
    freq.put("poc", 1426);
    freq.put(" pe\u030c", 1240);
    freq.put(" s\u030ck", 1284);
    freq.put("az\u030c ", 2790);
    freq.put("aji\u0301", 6907);
    freq.put("r\u030ci\u0301z", 2145);
    freq.put("n\u030c", 6555);
    freq.put("i\u0301z\u030ce", 1335);
    freq.put("ni\u0301c", 9560);
    freq.put("a\u0301be\u030c", 1152);
    freq.put(" pu\u030a", 4589);
    freq.put("ni\u0301k", 6579);
    freq.put("ni\u0301h", 7211);
    freq.put(" pr\u030c", 29127);
    freq.put("az\u030cd", 1260);
    freq.put("uji\u0301", 7869);
    freq.put("ev ", 3656);
    freq.put("ein", 1192);
    freq.put("s\u030cs\u030c", 1500);
    freq.put("r\u030csk", 2573);
    freq.put("u\u030am ", 1924);
    freq.put("iva", 2483);
    freq.put("vuj", 1416);
    freq.put("c\u030cu", 2648);
    freq.put("ivo", 2672);
    freq.put("ivi", 1448);
    freq.put("oku", 8537);
    freq.put(" be\u030c", 2145);
    freq.put(" Me", 3365);
    freq.put("par", 3389);
    freq.put("pat", 3635);
    freq.put(" Ma", 8133);
    freq.put(" Mo", 4565);
    freq.put(" Mi", 3991);
    freq.put("pad", 7309);
    freq.put("uho", 1206);
    freq.put("I ", 2501);
    freq.put("pak", 1199);
    freq.put("pal", 1582);
    freq.put("cem", 1899);
    freq.put("pan", 2500);
    freq.put("cel", 4240);
    freq.put("nac", 3724);
    freq.put("I", 10554);
    freq.put("yd", 3200);
    freq.put(" br\u030c", 1481);
    freq.put("js\u030c", 5173);
    freq.put("eti", 3348);
    freq.put("sed", 1877);
    freq.put("lne\u030c", 2708);
    freq.put("s\u030cs\u030ci\u0301", 1462);
    freq.put("ody", 1671);
    freq.put("pa ", 1199);
    freq.put("In", 2920);
    freq.put("oke", 1629);
    freq.put("uz\u030ci", 2255);
    freq.put("a\u0301c", 7677);
    freq.put("a\u0301b", 3286);
    freq.put("a\u0301d", 11483);
    freq.put("a\u0301h", 2531);
    freq.put("a\u0301k", 7074);
    freq.put("a\u0301j", 1550);
    freq.put("a\u0301m", 8120);
    freq.put("a\u0301l", 25430);
    freq.put("a\u0301n", 28607);
    freq.put("tvi\u0301", 6726);
    freq.put("a\u0301p", 5503);
    freq.put("a\u0301s", 12931);
    freq.put("a\u0301r", 9720);
    freq.put("a\u0301t", 14731);
    freq.put("a\u0301v", 12832);
    freq.put("a\u0301z", 13195);
    freq.put("i\u0301m ", 20382);
    freq.put(" ci\u0301", 2459);
    freq.put("ha\u0301z", 6195);
    freq.put("str\u030c", 6161);
    freq.put("pov", 4058);
    freq.put("c\u030ci ", 4977);
    freq.put("loz\u030c", 5290);
    freq.put("ami", 3729);
    freq.put("a\u0301 ", 61028);
    freq.put("amo", 2812);
    freq.put("a\u0301st", 9035);
    freq.put("ama", 1900);
    freq.put("mor", 1679);
    freq.put("psa", 1291);
    freq.put("ame", 8001);
    freq.put("mov", 3077);
    freq.put("i\u0301ms", 1206);
    freq.put("mot", 2793);
    freq.put("i\u0301mi", 2048);
    freq.put("mon", 2073);
    freq.put("moc", 2506);
    freq.put("mob", 1461);
    freq.put("amu", 1194);
    freq.put("a\u0301zi\u0301", 4141);
    freq.put("y\u0301mi", 4161);
    freq.put("uce", 1140);
    freq.put("aci\u0301", 4252);
    freq.put("Ne\u030c", 1339);
    freq.put("t", 548551);
    freq.put("pok", 1746);
    freq.put("as\u030c", 1639);
    freq.put("poh", 2575);
    freq.put("tvr", 1530);
    freq.put("ezn", 2836);
    freq.put("ezi", 7262);
    freq.put("eze", 2667);
    freq.put("tva", 2695);
    freq.put("az\u030c", 7470);
    freq.put(" ch", 5478);
    freq.put(" co", 2133);
    freq.put(" ce", 6243);
    freq.put(" z\u030ci", 4198);
    freq.put("ar\u030c", 4683);
    freq.put("uch", 2624);
    freq.put(" z\u030ce", 3745);
    freq.put("ls\u030ci\u0301", 1771);
    freq.put("zit", 1344);
    freq.put("Ja", 4326);
    freq.put("cne\u030c", 1190);
    freq.put("zna", 13601);
    freq.put("sel", 1714);
    freq.put("tno", 1779);
    freq.put("oo", 2643);
    freq.put("on", 44356);
    freq.put("om", 27583);
    freq.put("ol", 47354);
    freq.put("ok", 26216);
    freq.put("oj", 17875);
    freq.put("oi", 2071);
    freq.put("oh", 13386);
    freq.put("og", 10937);
    freq.put("of", 6319);
    freq.put("oe", 1227);
    freq.put("od", 69409);
    freq.put("ac\u030c", 14478);
    freq.put("ob", 47136);
    freq.put("oa", 1996);
    freq.put("oz", 27164);
    freq.put("ox", 1211);
    freq.put("ow", 2081);
    freq.put("ov", 112940);
    freq.put("ou", 73196);
    freq.put("ot", 27460);
    freq.put("os", 56160);
    freq.put("or", 53147);
    freq.put("op", 21879);
    freq.put("a\u0301s\u030c", 2438);
    freq.put("Ni", 1492);
    freq.put("bje", 2435);
    freq.put("zpr", 1480);
    freq.put("No", 2609);
    freq.put("Na", 4223);
    freq.put("Ne", 3393);
    freq.put("iti\u0301", 1214);
    freq.put("a\u0301z\u030c", 2247);
    freq.put("log", 5594);
    freq.put("her", 2617);
    freq.put("lok", 1275);
    freq.put("loh", 1236);
    freq.put("lon", 1573);
    freq.put("lom", 1730);
    freq.put("los", 3409);
    freq.put("ame\u030c", 1185);
    freq.put("\u0432", 1172);
    freq.put("lov", 17182);
    freq.put("lou", 5777);
    freq.put("a\u0301r\u030c", 4474);
    freq.put("hem", 3497);
    freq.put("moz\u030c", 1630);
    freq.put(" sv", 11047);
    freq.put("J", 20213);
    freq.put("dvo", 3395);
    freq.put("se\u0301r", 1644);
    freq.put("ita\u0301", 1643);
    freq.put("lo ", 9285);
    freq.put("a\u0301c\u030c", 1328);
    freq.put("as ", 2058);
    freq.put("he ", 2188);
    freq.put("ohl", 1659);
    freq.put("oc\u030c", 8726);
    freq.put("ab", 9081);
    freq.put("ae", 4121);
    freq.put("ad", 38615);
    freq.put("ag", 6085);
    freq.put("af", 3809);
    freq.put("ai", 4202);
    freq.put("ah", 10143);
    freq.put("ak", 35472);
    freq.put("aj", 15958);
    freq.put("am", 28407);
    freq.put("al", 52089);
    freq.put("an", 76603);
    freq.put("ap", 12841);
    freq.put("as", 30808);
    freq.put("ar", 43773);
    freq.put("au", 9271);
    freq.put("at", 54683);
    freq.put("av", 34552);
    freq.put("ay", 1595);
    freq.put("ax", 1424);
    freq.put("az", 14206);
    freq.put("z\u030cen", 7485);
    freq.put("by\u0301v", 3044);
    freq.put("by\u0301t", 1189);
    freq.put("c\u030cin", 2747);
    freq.put("z\u030cel", 1619);
    freq.put("Au", 1413);
    freq.put("igi", 1176);
    freq.put("a ", 217661);
    freq.put("ve\u0301 ", 13437);
    freq.put("or\u030c", 9947);
    freq.put(" zk", 2698);
    freq.put("c\u030cov", 3019);
    freq.put("os\u030c", 2365);
    freq.put("oz\u030c", 13354);
    freq.put("u", 342714);
    freq.put("smu", 2054);
    freq.put("alo", 7874);
    freq.put("all", 1742);
    freq.put("sch", 2059);
    freq.put("zi\u0301", 7043);
    freq.put("ale", 6714);
    freq.put("alb", 1604);
    freq.put("ala", 3987);
    freq.put("eda", 1810);
    freq.put(" de\u030c", 2397);
    freq.put("z\u030ci\u0301", 12326);
    freq.put("aly", 1179);
    freq.put("z\u030ca\u0301", 1346);
    freq.put("be\u030ch", 2126);
    freq.put("als", 1998);
    freq.put("a\u0301rn", 3371);
    freq.put("gr", 6781);
    freq.put("hy ", 3116);
    freq.put("ni\u0301m", 14655);
    freq.put("tz", 1768);
    freq.put("ty", 13294);
    freq.put("tv", 17643);
    freq.put("tt", 3192);
    freq.put("tu", 25069);
    freq.put("tr", 38784);
    freq.put("ts", 8087);
    freq.put("tn", 18581);
    freq.put("to", 60100);
    freq.put("tl", 6035);
    freq.put("tm", 1809);
    freq.put("tk", 8430);
    freq.put("th", 6153);
    freq.put("ti", 58581);
    freq.put("\u0438", 1928);
    freq.put("te", 85042);
    freq.put("tb", 1873);
    freq.put("tc", 1257);
    freq.put("ta", 58747);
    freq.put("edi", 5930);
    freq.put("ium", 1381);
    freq.put("r\u030ci ", 4648);
    freq.put("a\u0301r\u030ce", 1219);
    freq.put("edn", 17139);
    freq.put("al ", 7387);
    freq.put("za\u0301", 15336);
    freq.put("be\u030c ", 2724);
    freq.put("gy", 1560);
    freq.put(" dr\u030c", 1310);
    freq.put("yso", 1389);
    freq.put("edm", 1145);
    freq.put("ert", 1878);
    freq.put(" Ni", 1486);
    freq.put("and", 5394);
    freq.put(" zv", 2770);
    freq.put(" No", 2595);
    freq.put("zy\u0301", 1387);
    freq.put(" Na", 4212);
    freq.put("ku\u030a ", 4430);
    freq.put("tec\u030c", 1644);
    freq.put(" Ne", 3375);
    freq.put("ge", 8367);
    freq.put(" zp", 3908);
    freq.put("pr\u030c ", 1535);
    freq.put("i\u0301r\u030ce", 1323);
    freq.put("t ", 42900);
    freq.put("odi\u0301", 1145);
    freq.put("ane", 2662);
    freq.put("tej", 1972);
    freq.put("e\u030cto", 2030);
    freq.put("tel", 12611);
    freq.put("ga", 7746);
    freq.put("ten", 3204);
    freq.put("ale\u0301", 1624);
    freq.put("z\u030cs", 2453);
    freq.put("ted", 1925);
    freq.put("e\u030cta", 1179);
    freq.put("ala\u0301", 1216);
    freq.put("go", 4942);
    freq.put("z\u030ck", 1495);
    freq.put("mni\u0301", 1927);
    freq.put("z\u030cn", 8213);
    freq.put("z\u030co", 1725);
    freq.put("ter", 37331);
    freq.put("z\u030cd", 1803);
    freq.put("z\u030ce", 16587);
    freq.put("tev", 1290);
    freq.put("ty\u0301", 6426);
    freq.put("abe", 1141);
    freq.put("ose", 1306);
    freq.put("ez\u030ci\u0301", 3799);
    freq.put("ti\u0301", 14980);
    freq.put("lle", 1365);
    freq.put("te\u0301", 13825);
    freq.put("ta\u0301", 14232);
    freq.put(" ru", 2498);
    freq.put("c\u030cne\u030c", 1729);
    freq.put("lko", 2458);
    freq.put("te ", 2317);
    freq.put("K", 19386);
    freq.put(" ry", 1961);
    freq.put(" re", 10229);
    freq.put("apr\u030c", 2101);
    freq.put(" ra", 2856);
    freq.put("pub", 3056);
    freq.put("z\u030c ", 17370);
    freq.put(" ro", 31079);
    freq.put("s\u030c", 60015);
    freq.put("su ", 2847);
    freq.put(" Na\u0301", 1395);
    freq.put("asa", 1162);
    freq.put("u\u030az\u030c", 1940);
    freq.put("yst", 4390);
    freq.put("vic", 2325);
    freq.put("ny\u0301c", 8901);
    freq.put("vid", 2543);
    freq.put("tr\u030c", 15220);
    freq.put("be\u030cz\u030c", 1211);
    freq.put("ny\u0301m", 4766);
    freq.put("vin", 6325);
    freq.put("vil", 1507);
    freq.put("als\u030c", 1631);
    freq.put("vis", 2095);
    freq.put(" Ne\u030c", 1337);
    freq.put("vc", 2056);
    freq.put("ky\u0301c", 10186);
    freq.put("u\u030aso", 2743);
    freq.put("viz", 1532);
    freq.put("ky\u0301m", 4999);
    freq.put("S ", 3112);
    freq.put("kr\u030c", 3224);
    freq.put("avy", 1957);
    freq.put("c\u030cny\u0301", 1279);
    freq.put("tu\u030a", 3818);
    freq.put("anc", 5148);
    freq.put("c\u030cni\u0301", 7738);
    freq.put("avu", 1943);
    freq.put("de ", 6350);
    freq.put("ivn", 3856);
    freq.put("ts\u030c", 4235);
    freq.put("vi ", 1398);
    freq.put("te\u030c", 14576);
    freq.put("ny\u0301 ", 15629);
    freq.put("dis", 2494);
    freq.put("Sp", 2686);
    freq.put("Sv", 1697);
    freq.put("Su", 1422);
    freq.put("St", 6172);
    freq.put("Sk", 1212);
    freq.put("Si", 1856);
    freq.put("So", 3053);
    freq.put("Sl", 2584);
    freq.put("Sc", 1219);
    freq.put("Sa", 3516);
    freq.put("avs", 1166);
    freq.put("Se", 3431);
    freq.put("a\u0301", 236804);
    freq.put(" dn", 2609);
    freq.put(" dl", 1361);
    freq.put("kla", 8470);
    freq.put(" di", 4948);
    freq.put(" de", 7028);
    freq.put("klo", 1299);
    freq.put("avn", 5290);
    freq.put(" da", 4034);
    freq.put("klu", 1477);
    freq.put("avo", 2741);
    freq.put("del", 3171);
    freq.put("dem", 3354);
    freq.put("den", 6683);
    freq.put("v", 451146);
    freq.put(" dv", 4297);
    freq.put(" du", 1944);
    freq.put("dec", 1456);
    freq.put(" dr", 8732);
    freq.put("avi", 3981);
    freq.put("mz\u030c ", 1199);
    freq.put("e\u030cts\u030c", 3901);
    freq.put("a\u0301ze", 5164);
    freq.put("f ", 2962);
    freq.put("ise", 1488);
    freq.put("ave", 3850);
    freq.put("ist", 15778);
    freq.put("uci\u0301", 1196);
    freq.put("isk", 2395);
    freq.put("ryc", 1171);
    freq.put("u\u030a ", 27572);
    freq.put("lam", 1157);
    freq.put("c\u030cno", 3388);
    freq.put("atr", 1563);
    freq.put("fr", 4738);
    freq.put("ft", 1555);
    freq.put("fu", 2046);
    freq.put("zy\u0301v", 1380);
    freq.put("fy", 1326);
    freq.put("rc\u030ce", 1253);
    freq.put("fa", 3278);
    freq.put("fe", 4502);
    freq.put("fi", 13067);
    freq.put(" ru\u030a", 1942);
    freq.put("fo", 9138);
    freq.put("a", 764805);
    freq.put("u\u030am", 2630);
    freq.put("u\u030al", 1327);
    freq.put("kla\u0301", 2870);
    freq.put(" da\u0301", 1402);
    freq.put("ne ", 3607);
    freq.put("egi", 1835);
    freq.put("u\u030az", 2205);
    freq.put("u\u030av", 4803);
    freq.put("u\u030as", 3997);
    freq.put("ito", 2582);
    freq.put("pu ", 1292);
    freq.put("ka\u0301 ", 15983);
    freq.put("uh ", 1827);
    freq.put("ce ", 37517);
    freq.put("y ", 96008);
    freq.put("ite", 5726);
    freq.put("ita", 3897);
    freq.put("ok ", 1263);
    freq.put(" si\u0301", 2537);
    freq.put("itu", 2506);
    freq.put("its", 1828);
    freq.put("ste\u030c", 3272);
    freq.put(" Ob", 1764);
    freq.put("nto", 3206);
    freq.put(" Or", 1230);
    freq.put(" Os", 1166);
    freq.put("yh", 1425);
    freq.put("yk", 5878);
    freq.put("okr", 4661);
    freq.put("ym", 4086);
    freq.put("yl", 23502);
    freq.put("yn", 5498);
    freq.put("cen", 5710);
    freq.put("yc", 3822);
    freq.put("yb", 3071);
    freq.put("L", 15978);
    freq.put("it ", 3805);
    freq.put("oka", 1642);
    freq.put("yz", 2224);
    freq.put("ces", 2551);
    freq.put("yp", 5097);
    freq.put("ys", 11111);
    freq.put("yr", 3273);
    freq.put("yu", 1291);
    freq.put("yt", 7847);
    freq.put("oko", 4002);
    freq.put("yv", 3371);
    freq.put("lu\u030a ", 2152);
    freq.put("tro", 11520);
    freq.put("pam", 1204);
    freq.put("ifi", 1720);
    freq.put(" sy", 4875);
    freq.put("ite\u0301", 1984);
    freq.put(" sr", 1447);
    freq.put(" sp", 14637);
    freq.put("c\u030c", 98194);
    freq.put(" st", 28273);
    freq.put(" su", 1768);
    freq.put(" sk", 7519);
    freq.put(" si", 3884);
    freq.put(" sn", 1263);
    freq.put(" so", 12794);
    freq.put(" sl", 8492);
    freq.put(" sm", 2713);
    freq.put(" sc", 1843);
    freq.put(" sa", 3585);
    freq.put("prv", 4970);
    freq.put(" se", 38618);
    freq.put("po ", 3633);
    freq.put("iza", 2404);
    freq.put("lis\u030c", 1271);
    freq.put("at ", 6248);
    freq.put("izo", 2349);
    freq.put("oz\u030c ", 2063);
    freq.put("san", 1523);
    freq.put("vne\u030c", 2710);
    freq.put("c\u030ci\u0301 ", 1292);
    freq.put("ky\u0301 ", 20031);
    freq.put("ast", 13117);
    freq.put("lic\u030c", 1203);
    freq.put(" Al", 3081);
    freq.put(" Am", 1697);
    freq.put(" An", 3275);
    freq.put("uhe\u0301", 1788);
    freq.put(" Ar", 2370);
    freq.put(" As", 1420);
    freq.put(" Au", 1408);
    freq.put("ase", 1167);
    freq.put("ask", 1257);
    freq.put("kom", 4572);
    freq.put(" s ", 10437);
    freq.put("aso", 1587);
    freq.put("asn", 2528);
    freq.put("omp", 1767);
    freq.put("i\u0301k ", 3909);
    freq.put("te\u030cz\u030c", 1441);
    freq.put("c\u030ci\u0301t", 2030);
    freq.put("ku\u030a", 5193);
    freq.put("c\u030ci\u0301s", 1405);
    freq.put("oz\u030ci", 1506);
    freq.put("oz\u030cn", 1513);
    freq.put("w", 9425);
    freq.put("Ev", 1845);
    freq.put("oz\u030ce", 4937);
    freq.put("le ", 15329);
    freq.put("Fra", 1982);
    freq.put("sva", 1646);
    freq.put("C\u030c", 7702);
    freq.put("ude", 2608);
    freq.put("ty\u0301m", 1477);
    freq.put(" el", 2125);
    freq.put(" en", 1401);
    freq.put("jev", 2523);
    freq.put("kol", 7494);
    freq.put("kon", 10573);
    freq.put("s\u030ce ", 1844);
    freq.put(" ex", 2023);
    freq.put("jed", 12881);
    freq.put("jej", 4795);
    freq.put("jek", 1841);
    freq.put("jeh", 3911);
    freq.put("kor", 1310);
    freq.put("jen", 5483);
    freq.put("jem", 2659);
    freq.put("omu", 2175);
    freq.put("ys\u030c", 3131);
    freq.put("vni\u0301", 15429);
    freq.put("odu", 5226);
    freq.put("nci", 5166);
    freq.put("Slo", 1556);
    freq.put("odv", 1246);
    freq.put("kop", 1321);
    freq.put("kos", 4285);
    freq.put("ste", 9093);
    freq.put("ka\u0301", 21030);
    freq.put("b", 175631);
    freq.put("sta", 23517);
    freq.put("stl", 1904);
    freq.put("kou", 9659);
    freq.put("ke\u0301", 50289);
    freq.put("sto", 14050);
    freq.put("sti", 18925);
    freq.put("yr\u030c", 1210);
    freq.put("stu", 6506);
    freq.put("s\u030cec", 1390);
    freq.put("str", 16919);
    freq.put("sts", 1291);
    freq.put("kov", 11417);
    freq.put("sty", 1890);
    freq.put("ky\u0301", 35391);
    freq.put("s\u030cen", 2332);
    freq.put("ka ", 20272);
    freq.put("la\u0301n", 1802);
    freq.put("zyk", 1998);
    freq.put("zt", 1618);
    freq.put("oda", 2197);
    freq.put("lid", 2928);
    freq.put("lie", 1691);
    freq.put("k ", 33844);
    freq.put("lia", 1350);
    freq.put("lic", 7730);
    freq.put("i\u0301ku\u030a", 1200);
    freq.put("lin", 6175);
    freq.put("ell", 1825);
    freq.put("ode", 4045);
    freq.put("lit", 5959);
    freq.put("la\u0301d", 4346);
    freq.put("liv", 3315);
    freq.put("te\u030c ", 5527);
    freq.put("lis", 4420);
    freq.put("liz", 1555);
    freq.put("kac", 1503);
    freq.put("vna", 1206);
    freq.put("vno", 1207);
    freq.put("jso", 6864);
    freq.put("M", 26754);
    freq.put("kan", 2047);
    freq.put("kam", 1509);
    freq.put("jsk", 2959);
    freq.put("kar", 1707);
    freq.put("kap", 1616);
    freq.put("kat", 3393);
    freq.put("kaz", 1148);
    freq.put("The", 1321);
    freq.put("kc", 3108);
    freq.put("ka", 39832);
    freq.put("atk", 1885);
    freq.put("ne\u0301h", 5048);
    freq.put("sta\u0301", 6877);
    freq.put("ke", 11246);
    freq.put("kd", 5064);
    freq.put("sti\u0301", 6180);
    freq.put("ki", 3600);
    freq.put("ko", 71233);
    freq.put("kn", 3161);
    freq.put("km", 3641);
    freq.put("kl", 18948);
    freq.put("kr", 19435);
    freq.put("ext", 1409);
    freq.put("kv", 3857);
    freq.put("ku", 33102);
    freq.put("kt", 39344);
    freq.put("te\u030cn", 1733);
    freq.put("ky", 30906);
    freq.put("te\u030cj", 1439);
    freq.put("c\u030ca\u0301", 8501);
    freq.put("c\u030ci\u0301", 6991);
    freq.put("rto", 1577);
    freq.put("pr\u030c", 32632);
    freq.put("rti", 1692);
    freq.put("rtu", 1152);
    freq.put("oje", 7276);
    freq.put("ojo", 1142);
    freq.put("ojm", 1998);
    freq.put("mi\u0301 ", 3982);
    freq.put("oji", 1192);
    freq.put(" te\u030c", 2639);
    freq.put("Ju", 1244);
    freq.put("ier", 1153);
    freq.put("nce", 5874);
    freq.put("Jo", 1796);
    freq.put("Ji", 2201);
    freq.put("am ", 2742);
    freq.put("Je", 8576);
    freq.put("pu\u030a", 6675);
    freq.put("C\u030ce", 5023);
    freq.put("rt ", 1561);
    freq.put("pe\u030c", 4347);
    freq.put("mi\u0301s", 2771);
    freq.put("mi\u0301r", 1517);
    freq.put("ika\u0301", 1715);
    freq.put("mi\u0301n", 2069);
    freq.put("oj ", 1676);
    freq.put("re\u0301 ", 7668);
    freq.put(" tr\u030c", 3845);
    freq.put("ko ", 14736);
    freq.put("x", 11788);
    freq.put("stn", 5308);
    freq.put(" Be", 3213);
    freq.put("sev", 4239);
    freq.put("ars", 2390);
    freq.put("c\u030ca", 7771);
    freq.put("ser", 1773);
    freq.put("c\u030cl", 2919);
    freq.put(" Bo", 2981);
    freq.put("c\u030cn", 16418);
    freq.put(" Bi", 1350);
    freq.put("c\u030ck", 4324);
    freq.put(" Bu", 2094);
    freq.put("c\u030ct", 3695);
    freq.put("arc", 2227);
    freq.put("ard", 3288);
    freq.put("are", 2437);
    freq.put(" Br", 3935);
    freq.put("ari", 4139);
    freq.put("sem", 1612);
    freq.put("a\u0301pa", 4357);
    freq.put(" By", 2085);
    freq.put("arm", 1290);
    freq.put("arn", 1320);
    freq.put("aro", 4126);
    freq.put("mo ", 1420);
    freq.put("je ", 83650);
    freq.put("rod", 11155);
    freq.put("vla\u0301", 2701);
    freq.put("kto", 1589);
    freq.put("use", 1494);
    freq.put("ozl", 1181);
    freq.put("zkr", 2046);
    freq.put("c\u030c ", 2311);
    freq.put("iku", 2133);
    freq.put("ikt", 1203);
    freq.put("iky", 3097);
    freq.put("ar ", 2605);
    freq.put("ika", 5332);
    freq.put("vi\u0301 ", 7249);
    freq.put("se ", 32266);
    freq.put("iko", 2695);
    freq.put("ikl", 2333);
    freq.put(" Pr", 7523);
    freq.put("c", 304749);
    freq.put(" Pa", 5464);
    freq.put("vys\u030c", 2053);
    freq.put("nt ", 3215);
    freq.put(" Pe", 2516);
    freq.put(" Pi", 1231);
    freq.put(" Po", 7138);
    freq.put(" Pl", 1502);
    freq.put("y\u0301m ", 11479);
    freq.put("lez", 2008);
    freq.put("ga ", 1144);
    freq.put("pr", 57083);
    freq.put("ps", 5342);
    freq.put("ty ", 7625);
    freq.put("pt", 3558);
    freq.put("pu", 7668);
    freq.put("py", 1779);
    freq.put("pc", 1302);
    freq.put("pa", 25836);
    freq.put("pe", 15026);
    freq.put("ph", 1918);
    freq.put("pi", 14831);
    freq.put("pn", 3046);
    freq.put("po", 81579);
    freq.put("pl", 12514);
    freq.put(" ty", 2521);
    freq.put(" tv", 3467);
    freq.put(" tu", 1727);
    freq.put(" tr", 6193);
    freq.put("N", 16476);
    freq.put(" to", 5957);
    freq.put("gan", 3061);
    freq.put(" ti", 1444);
    freq.put(" th", 1725);
    freq.put(" te", 10751);
    freq.put("sko", 9797);
    freq.put(" ta", 9553);
    freq.put("y\u0301va\u0301", 1959);
    freq.put("roz", 10708);
    freq.put("le\u0301 ", 2839);
    freq.put("du ", 8252);
    freq.put("ode\u030c", 2068);
    freq.put("p ", 4419);
    freq.put("fun", 1501);
    freq.put("vod", 8774);
    freq.put("ar\u030ci\u0301", 2027);
    freq.put("sy ", 1657);
    freq.put("psk", 1538);
    freq.put("vol", 2921);
    freq.put("rit", 3911);
    freq.put("ris", 3258);
    freq.put("voj", 3429);
    freq.put("rin", 2410);
    freq.put("ars\u030c", 1293);
    freq.put("vov", 1657);
    freq.put("rik", 1662);
    freq.put("vor", 1476);
    freq.put("rig", 1476);
    freq.put("rid", 1291);
    freq.put("rie", 3806);
    freq.put("ric", 8579);
    freq.put("ka\u0301n", 1145);
    freq.put("ria", 2007);
    freq.put("tvo", 4249);
    freq.put("amn", 1598);
    freq.put("mos", 2024);
    freq.put("vy ", 4952);
    freq.put("pa\u0301", 2981);
    freq.put("dru", 7228);
    freq.put("spe", 2260);
    freq.put("ac", 26092);
    freq.put("pi\u0301", 3163);
    freq.put(" ty\u0301", 1167);
    freq.put("vo ", 2147);
    freq.put("tis", 2205);
    freq.put(" Pr\u030c", 2056);
    freq.put("syn", 1327);
    freq.put("sys", 2806);
    freq.put("lig", 1241);
    freq.put("mou", 1328);
    freq.put(" te\u0301", 5230);
    freq.put("vyr", 1739);
    freq.put("vys", 3366);
    freq.put(" fr", 2890);
    freq.put(" fu", 1558);
    freq.put("vyt", 1966);
    freq.put("kni", 1628);
    freq.put("kle", 2073);
    freq.put(" fa", 1772);
    freq.put("vyd", 1992);
    freq.put(" fi", 6203);
    freq.put("vyk", 2012);
    freq.put("do ", 8212);
    freq.put(" fo", 4715);
    freq.put("T", 19206);
    freq.put(" uz\u030c", 1794);
    freq.put("c\u030cle", 1629);
    freq.put("O ", 1633);
    freq.put("uc\u030c", 6510);
    freq.put("lik", 5494);
    freq.put("tin", 7629);
    freq.put("na\u0301c", 1291);
    freq.put("r\u030ci\u0301", 28277);
    freq.put("r\u030ca\u0301", 2554);
    freq.put("na\u0301l", 3115);
    freq.put("na\u0301m", 4897);
    freq.put("na\u0301r", 3570);
    freq.put("\u043e", 2213);
    freq.put("na\u0301v", 1475);
    freq.put("na\u0301z", 3803);
    freq.put("rgi", 1143);
    freq.put("mod", 2374);
    freq.put("bil", 2518);
    freq.put("ba\u0301", 2585);
    freq.put("bi\u0301", 5183);
    freq.put("oha", 1909);
    freq.put("Ob", 1767);
    freq.put("by\u0301", 4615);
    freq.put("bit", 1438);
    freq.put("Os", 1168);
    freq.put("Or", 1234);
    freq.put("na\u0301 ", 14630);
    freq.put("uz\u030c", 12787);
    freq.put("d", 331353);
    freq.put("us\u030c", 4102);
    freq.put("apo", 2941);
    freq.put("b ", 5436);
    freq.put("ru ", 6692);
    freq.put("r\u030ci\u0301z\u030c", 1421);
    freq.put("e\u0301ho", 25401);
    freq.put("on ", 7329);
    freq.put("sme\u030c", 1301);
    freq.put("tuj", 2396);
    freq.put("r\u030ci", 14008);
    freq.put("ra ", 9350);
    freq.put("r\u030cn", 1352);
    freq.put("r\u030ca", 3989);
    freq.put("r\u030ce", 44896);
    freq.put("per", 4148);
    freq.put("pen", 1946);
    freq.put("yl ", 10326);
    freq.put("r\u030cs", 2960);
    freq.put("ape", 1349);
    freq.put("pec", 1647);
    freq.put("bd", 1995);
    freq.put("be", 13547);
    freq.put("ruh", 6961);
    freq.put("ba", 13431);
    freq.put("bc", 3044);
    freq.put("bl", 11541);
    freq.put("bn", 7303);
    freq.put("bo", 26250);
    freq.put("bi", 8921);
    freq.put("bj", 2483);
    freq.put("nac\u030c", 7033);
    freq.put("bu", 11101);
    freq.put("bv", 2259);
    freq.put("vni", 1709);
    freq.put("br", 9964);
    freq.put("bs", 4261);
    freq.put("rus", 3302);
    freq.put("kal", 2034);
    freq.put("by", 26507);
    freq.put("t\u030c", 3583);
    freq.put("r\u030c ", 4182);
    freq.put("yly", 1314);
    freq.put("ido", 1643);
    freq.put("idl", 1498);
    freq.put("yla", 6390);
    freq.put("ylo", 2929);
    freq.put("ide", 3474);
    freq.put("ida", 1748);
    freq.put("nsk", 18177);
    freq.put("jn", 5134);
    freq.put("chl", 1932);
    freq.put(" uv", 1309);
    freq.put(" ur", 2603);
    freq.put(" us", 1203);
    freq.put(" um", 2673);
    freq.put(" un", 1389);
    freq.put("nst", 3785);
    freq.put("ut ", 1210);
    freq.put("ci ", 10328);
    freq.put("ust", 3573);
    freq.put("u ", 121101);
    freq.put(" Ch", 3924);
    freq.put(" Co", 3154);
    freq.put("lka", 1525);
    freq.put(" Ca", 2514);
    freq.put(" Ce", 1267);
    freq.put("urn", 1235);
    freq.put("chy", 1469);
    freq.put("li ", 6590);
    freq.put(" u ", 3351);
    freq.put("cia", 1607);
    freq.put("cie", 2249);
    freq.put("uz", 6709);
    freq.put("exi", 1437);
    freq.put("ut", 14862);
    freq.put("uv", 3489);
    freq.put("up", 13452);
    freq.put("us", 20839);
    freq.put("ur", 17880);
    freq.put("um", 13455);
    freq.put("ul", 12653);
    freq.put("my ", 2400);
    freq.put("un", 12543);
    freq.put("ui", 1687);
    freq.put("uh", 10244);
    freq.put("uk", 7056);
    freq.put("uj", 20016);
    freq.put("ue", 2392);
    freq.put("ud", 12808);
    freq.put("ug", 1937);
    freq.put("z", 213126);
    freq.put("ua", 2086);
    freq.put("uc", 6671);
    freq.put("ub", 11697);
    freq.put("r\u030ci\u0301p", 1616);
    freq.put("r\u030ci\u0301s", 1609);
    freq.put("r\u030ci\u0301v", 1184);
    freq.put("Tu", 1161);
    freq.put("Tr", 2534);
    freq.put("d\u030c", 2560);
    freq.put("ste\u0301", 3269);
    freq.put("To", 2275);
    freq.put("r\u030ci\u0301c", 1240);
    freq.put("r\u030ci\u0301d", 3286);
    freq.put("Th", 2120);
    freq.put("Ti", 1361);
    freq.put("r\u030ci\u0301k", 1716);
    freq.put("Te", 3239);
    freq.put("r\u030ci\u0301m", 2008);
    freq.put("Ta", 2435);
    freq.put("A ", 3554);
    freq.put("Mar", 2760);
    freq.put(" gr", 1666);
    freq.put("nad", 3749);
    freq.put("nak", 1732);
    freq.put("nan", 1425);
    freq.put("me\u030cn", 2340);
    freq.put("nal", 3376);
    freq.put("nam", 6213);
    freq.put("nar", 1416);
    freq.put("nas", 1417);
    freq.put("nap", 3429);
    freq.put(" ge", 1763);
    freq.put("nav", 1415);
    freq.put("nat", 3143);
    freq.put("gra", 4857);
    freq.put("naz", 1632);
    freq.put("z\u030ce ", 5417);
    freq.put("be\u030c", 8276);
    freq.put("r\u030ci\u0301 ", 6262);
    freq.put("ruz\u030c", 1312);
    freq.put("nes\u030c", 1391);
    freq.put("te\u030cl", 1552);
    freq.put("vzn", 2563);
    freq.put("svo", 1261);
    freq.put("cia\u0301", 2350);
    freq.put("e", 908926);
    freq.put("age", 1161);
    freq.put("Am", 1706);
    freq.put("Al", 3092);
    freq.put("An", 3282);
    freq.put("ahu", 2375);
    freq.put("lu ", 4880);
    freq.put("As", 1426);
    freq.put("Ar", 2392);
    freq.put("s\u030cko", 1848);
    freq.put("ly\u0301 ", 2387);
    freq.put("u\u0301", 13969);
    freq.put("br\u030c", 2940);
    freq.put(" b", 47368);
    freq.put(" c", 20381);
    freq.put("gu", 3569);
    freq.put(" a", 90604);
    freq.put(" f", 19925);
    freq.put(" g", 5629);
    freq.put(" d", 65217);
    freq.put(" e", 11656);
    freq.put(" j", 127655);
    freq.put(" k", 89036);
    freq.put(" h", 32176);
    freq.put(" i", 15946);
    freq.put(" n", 107131);
    freq.put(" o", 79037);
    freq.put(" l", 32594);
    freq.put(" m", 62986);
    freq.put(" r", 52674);
    freq.put(" s", 159790);
    freq.put(" p", 164476);
    freq.put(" v", 146123);
    freq.put(" w", 1272);
    freq.put(" t", 59923);
    freq.put(" u", 20743);
    freq.put(" z", 85758);
    freq.put("gn", 2020);
    freq.put("gl", 5355);
    freq.put("gi", 10280);
    freq.put("gh", 1578);
    freq.put(" B", 22644);
    freq.put(" C", 16189);
    freq.put(" A", 22443);
    freq.put(" F", 10496);
    freq.put(" G", 9381);
    freq.put(" D", 14695);
    freq.put(" E", 9809);
    freq.put(" J", 20168);
    freq.put(" K", 19243);
    freq.put(" H", 14014);
    freq.put(" I", 10456);
    freq.put(" N", 16390);
    freq.put(" O", 10658);
    freq.put(" L", 15894);
    freq.put(" M", 26594);
    freq.put(" R", 13762);
    freq.put(" S", 35443);
    freq.put(" P", 31807);
    freq.put(" V", 19363);
    freq.put(" W", 5251);
    freq.put(" T", 19078);
    freq.put(" U", 5519);
    freq.put(" Z", 7643);
    freq.put("lky", 2194);
    freq.put("Nov", 1143);
    freq.put(" Y", 1252);
    freq.put("vot", 1529);
    freq.put("kce", 1649);
    freq.put("ch ", 62063);
    freq.put("ed ", 3026);
    freq.put(" mu\u030a", 1354);
    freq.put("oza\u0301", 1627);
    freq.put("vla", 2806);
    freq.put("P", 31985);
    freq.put("g ", 5595);
    freq.put("tri", 3505);
    freq.put("evi", 2322);
    freq.put("evn", 2175);
    freq.put("tra", 10732);
    freq.put("ske\u0301", 26627);
    freq.put("us ", 7285);
    freq.put("tre", 1691);
    freq.put("eve", 6187);
    freq.put("Spo", 1540);
    freq.put("ry ", 6263);
    freq.put("tru", 3242);
    freq.put("zl", 2273);
    freq.put("zm", 2157);
    freq.put("zn", 27029);
    freq.put("zo", 8118);
    freq.put("zh", 2175);
    freq.put("zi", 13719);
    freq.put("zk", 6049);
    freq.put("zd", 9382);
    freq.put("ze", 35435);
    freq.put("odr", 1258);
    freq.put("ods", 1272);
    freq.put("za", 24684);
    freq.put("zb", 2038);
    freq.put("edi\u0301", 1331);
    freq.put("odi", 2898);
    freq.put("odl", 3777);
    freq.put("zy", 3702);
    freq.put("odn", 14263);
    freq.put("odo", 4607);
    freq.put(" u\u0301", 11862);
    freq.put("zu", 4066);
    freq.put("zv", 6153);
    freq.put("zp", 5782);
    freq.put("s\u030cte\u030c", 3036);
    freq.put("zr", 1709);
    freq.put("zs", 3415);
    freq.put(" vs\u030c", 2884);
    freq.put("iz\u030cn", 3600);
    freq.put("lke\u0301", 1191);
    freq.put("bdo", 1660);
    freq.put("lky\u0301", 1221);
    freq.put("rd ", 1372);
    freq.put("ozd", 2636);
    freq.put("oze", 3842);
    freq.put("led", 7715);
    freq.put("c\u030cka", 1735);
    freq.put("ozn", 6156);
    freq.put("ozo", 1460);
    freq.put("e\u030cr\u030c", 2184);
    freq.put("lek", 3907);
    freq.put("z ", 24530);
    freq.put("lem", 5693);
    freq.put("len", 8028);
    freq.put("ozi", 1341);
    freq.put("ler", 1221);
    freq.put("les", 3807);
    freq.put("let", 9902);
    freq.put("lev", 1768);
    freq.put("od ", 15166);
    freq.put(" ve\u030c", 4981);
    freq.put("em ", 31739);
    freq.put("ctv", 1837);
    freq.put("zac", 2566);
    freq.put("z\u030ci\u0301 ", 4449);
    freq.put("tra\u0301", 2691);
    freq.put("iz\u030c ", 1205);
    freq.put("e\u030cz\u030c", 3582);
    freq.put("tac\u030c", 2083);
    freq.put("rdi", 1273);
    freq.put(" Do", 2665);
    freq.put(" S\u030c", 3567);
    freq.put(" s\u030c", 7349);
    freq.put(" Di", 1684);
    freq.put("oce", 9242);
    freq.put(" De", 2001);
    freq.put(" Da", 2135);
    freq.put("a\u0301vn", 2176);
    freq.put("a\u0301vi", 1211);
    freq.put("zde", 1205);
    freq.put("Vel", 1392);
    freq.put(" z\u030c", 9995);
    freq.put("a\u0301va", 2824);
    freq.put(" Z\u030c", 1647);
    freq.put(" va\u0301", 3060);
    freq.put("cha", 4867);
    freq.put("Fr", 2934);
    freq.put("che", 3452);
    freq.put("chi", 2422);
    freq.put("tas", 1264);
    freq.put(" vi\u0301", 2124);
    freq.put("chn", 2940);
    freq.put("cho", 11778);
    freq.put("chr", 1838);
    freq.put("hrn", 1403);
    freq.put("cht", 1572);
    freq.put("chu", 1777);
    freq.put("a\u0301da\u0301", 1824);
    freq.put("zin", 1828);
    freq.put("Fi", 1671);
    freq.put(" R\u030c", 1403);
    freq.put(" r\u030c", 11127);
    freq.put(" vy\u0301", 12688);
    freq.put("spr", 1930);
    freq.put("Fo", 1409);
    freq.put("ien", 1656);
    freq.put("i\u0301ze", 1985);
    freq.put(" Ru", 1883);
    freq.put("ace", 7532);
    freq.put("tru\u030a", 1395);
    freq.put("f", 46799);
    freq.put("evs\u030c", 1525);
    freq.put("km ", 2378);
    freq.put(" C\u030c", 7692);
    freq.put(" c\u030c", 34240);
    freq.put(" Re", 2567);
    freq.put(" Ra", 2495);
    freq.put("zi ", 5006);
    freq.put(" Ro", 3640);
    freq.put("aci", 3453);
    freq.put("tat", 3631);
    freq.put("tav", 8149);
    freq.put("ach", 6559);
    freq.put("tar", 5738);
    freq.put("\u0440", 1443);
    freq.put("ic\u030cn", 2337);
    freq.put("oc", 21110);
    freq.put("zs\u030c", 1160);
    freq.put("oc\u030cn", 1259);
    freq.put("tad", 1311);
    freq.put("za\u0301v", 1903);
    freq.put("his", 2398);
    freq.put("eno", 6243);
    freq.put("tac", 1310);
    freq.put("tal", 4758);
    freq.put("tan", 5175);
    freq.put("ly ", 6413);
    freq.put(" ot", 1283);
    freq.put("tak", 7734);
    freq.put(" va", 1643);
    freq.put("cha\u0301", 6943);
    freq.put(" ve", 20353);
    freq.put("afi", 1777);
    freq.put(" vi", 2111);
    freq.put("ne\u0301m", 2468);
    freq.put(" vl", 5324);
    freq.put(" vo", 5885);
    freq.put("a\u0301va\u0301", 2557);
    freq.put(" vr", 1606);
    freq.put("za\u0301p", 4090);
    freq.put("a\u0301da", 1737);
    freq.put(" vy", 18421);
    freq.put(" vz", 6214);
    freq.put("sin", 1775);
    freq.put("kro", 2033);
    freq.put("ia\u0301l", 4186);
    freq.put("ta ", 12315);
    freq.put("lez\u030c", 2967);
    freq.put("e\u030cs", 10757);
    freq.put("e\u030cr", 3724);
    freq.put("kra", 5687);
    freq.put("e\u030cv", 1529);
    freq.put("e\u030ct", 15295);
    freq.put("e\u030cz", 2258);
    freq.put("za\u0301k", 3066);
    freq.put("s\u030cti", 2097);
    freq.put("e\u030cc", 1612);
    freq.put("si ", 3518);
    freq.put("e\u030cd", 3131);
    freq.put("e\u030ck", 7417);
    freq.put("e\u030cj", 8834);
    freq.put("e\u030ch", 2633);
    freq.put("e\u030cn", 11047);
    freq.put("e\u030cm", 5852);
    freq.put("e\u030cl", 9917);
    freq.put("da ", 6390);
    freq.put("ens", 7642);
    freq.put("lec\u030c", 4689);
    freq.put("u\u0301z", 3790);
    freq.put("jno", 1257);
    freq.put("u\u0301s", 1640);
    freq.put("lf", 1159);
    freq.put("ld", 2521);
    freq.put("le", 77448);
    freq.put("lb", 2945);
    freq.put("lc", 1721);
    freq.put("la", 65008);
    freq.put("ln", 20483);
    freq.put("lo", 61865);
    freq.put("ll", 7520);
    freq.put("lm", 4934);
    freq.put("lk", 10732);
    freq.put("li", 57563);
    freq.put("lt", 4743);
    freq.put("e\u030c ", 45418);
    freq.put("ls", 8702);
    freq.put("lz", 1355);
    freq.put("ly", 9717);
    freq.put("na ", 53204);
    freq.put("tny\u0301", 1437);
    freq.put("dal", 3374);
    freq.put("dan", 2182);
    freq.put("daj", 1518);
    freq.put("dat", 3084);
    freq.put("ema", 1842);
    freq.put("Pra", 2828);
    freq.put("l ", 42283);
    freq.put("nfo", 1282);
    freq.put(" hr", 6552);
    freq.put("Pro", 2287);
    freq.put("e\u0301z\u030c ", 3711);
    freq.put(" hu", 3075);
    freq.put(" hi", 2201);
    freq.put(" ho", 6862);
    freq.put(" hl", 5156);
    freq.put(" ha", 1600);
    freq.put("sil", 2216);
    freq.put(" he", 2509);
    freq.put("ouh", 2082);
    freq.put("oun", 1766);
    freq.put("ec ", 4754);
    freq.put("ouc", 1601);
    freq.put("oub", 1598);
    freq.put("oud", 1374);
    freq.put("hlo", 1435);
    freq.put("ouz", 3479);
    freq.put("en\u030c ", 1751);
    freq.put("ous", 3223);
    freq.put("hle", 2243);
    freq.put("oup", 1457);
    freq.put("h ", 68060);
    freq.put("hla", 5571);
    freq.put("out", 2402);
    freq.put("rez", 1829);
    freq.put("la\u0301", 15416);
    freq.put("res", 5841);
    freq.put("rep", 3246);
    freq.put("li\u0301", 8097);
    freq.put("ute", 1270);
    freq.put("ret", 1327);
    freq.put("le\u0301", 7239);
    freq.put("rek", 1273);
    freq.put("ren", 2252);
    freq.put("rem", 3700);
    freq.put("rec", 1925);
    freq.put("ly\u0301", 4646);
    freq.put("reg", 1788);
    freq.put("ych", 2524);
    freq.put("ecn", 1350);
    freq.put("i\u0301ns", 1474);
    freq.put("ou ", 37147);
    freq.put("eck", 8996);
    freq.put("eci", 1513);
    freq.put("ech", 12275);
    freq.put("uti\u0301", 1162);
    freq.put("ie ", 13367);
    freq.put("van", 12007);
    freq.put("lod", 1650);
    freq.put("g", 61772);
    freq.put("ndo", 1521);
    freq.put("ono", 3674);
    freq.put("re ", 2546);
    freq.put("Z\u030c", 1649);
    freq.put("ta\u0301t", 4498);
    freq.put("c\u030ce", 26348);
    freq.put("ud ", 1221);
    freq.put("e\u0301no", 1417);
    freq.put("iho", 2925);
    freq.put("ta\u0301l", 2187);
    freq.put(" Ba", 3436);
    freq.put("ta\u0301n", 1850);
    freq.put("e\u0301na", 1816);
    freq.put("ls\u030c", 2281);
    freq.put("asi", 3609);
    freq.put("lu\u030a", 2536);
    freq.put(" Sp", 2664);
    freq.put("w ", 1552);
    freq.put(" Sv", 1696);
    freq.put(" St", 6100);
    freq.put(" Su", 1408);
    freq.put(" Sk", 1209);
    freq.put(" Si", 1839);
    freq.put(" So", 3031);
    freq.put(" Sl", 2578);
    freq.put(" Sc", 1168);
    freq.put(" Sa", 3503);
    freq.put("c\u030co", 3182);
    freq.put(" Se", 3406);
    freq.put("Ka", 5031);
    freq.put("ii ", 5869);
    freq.put(" v ", 54233);
    freq.put("c\u030ci", 11688);
    freq.put("Ko", 4086);
    freq.put("c\u030ca\u0301s", 7287);
    freq.put("Kl", 1430);
    freq.put("Kr", 2544);
    freq.put("R", 13848);
    freq.put("ogi", 4525);
    freq.put("Ku", 1175);
    freq.put("eho", 5425);
    freq.put("rst", 1339);
    freq.put("u\u0301ze", 3480);
    freq.put("udi", 1376);
    freq.put("udo", 2156);
    freq.put("u\u0301c\u030c", 1787);
    freq.put("ben", 2163);
    freq.put("ara", 4391);
    freq.put("bec", 2884);
    freq.put("cke\u0301", 15214);
    freq.put("bez", 1903);
    freq.put("ik ", 2696);
    freq.put("ber", 2768);
    freq.put("y\u0301", 129650);
    freq.put("Par", 1206);
    freq.put("da\u0301 ", 2060);
    freq.put("ouz\u030c", 6121);
    freq.put("sen", 1348);
    freq.put("py ", 1312);
    freq.put("sk", 92692);
    freq.put("ark", 1851);
    freq.put("rez\u030c", 1163);
    freq.put("mil", 1861);
    freq.put("lec", 1964);
    freq.put("min", 3830);
    freq.put("arl", 1695);
    freq.put("mic", 2749);
    freq.put("bur", 1260);
    freq.put("i\u0301n ", 1890);
    freq.put("mis", 1525);
    freq.put("da\u0301l", 1753);
    freq.put("da\u0301n", 2244);
    freq.put("da\u0301v", 1525);
    freq.put("zko", 1259);
    freq.put("st ", 11395);
    freq.put(" Ev", 1844);
    freq.put("n\u030c ", 2419);
    freq.put("ure", 1155);
    freq.put("mus", 1983);
    freq.put("ouc\u030c", 4572);
    freq.put("mi ", 12425);
    freq.put("cko", 3237);
    freq.put("uro", 1540);
    freq.put("uri", 1389);
    freq.put("uru", 1160);
    freq.put("Pol", 1195);
    freq.put("Pod", 1248);
    freq.put("cky", 4430);
    freq.put("ury", 1381);
    freq.put("ty\u0301 ", 2037);
    freq.put("cu\u030a", 2079);
    freq.put("Cha", 1224);
    freq.put("z\u030civ", 2602);
    freq.put("z\u030cit", 2707);
    freq.put("z\u030cij", 1345);
    freq.put("z\u030cil", 1490);
    freq.put("ts\u030ci\u0301", 2640);
    freq.put("nge", 1442);
    freq.put("jaz", 2568);
    freq.put("tni\u0301", 9445);
    freq.put("ngl", 4299);
    freq.put("vs\u030ca", 1280);
    freq.put(" it", 1175);
    freq.put("vs\u030ce", 1958);
    freq.put("ae ", 1943);
    freq.put("jak", 10723);
    freq.put(" in", 6001);
    freq.put("a\u0301k ", 1153);
    freq.put("ty\u0301c", 2116);
    freq.put("no ", 7023);
    freq.put("mor\u030c", 3176);
    freq.put("pu\u030as", 2701);
    freq.put("vi\u0301c", 1941);
    freq.put("tba", 1700);
    freq.put("ng ", 3190);
    freq.put("h", 259891);
    freq.put("vor\u030c", 3595);
    freq.put("s\u030cin", 1751);
    freq.put("a\u0301ko", 1419);
    freq.put("a\u0301kl", 2414);
    freq.put(" i ", 5273);
    freq.put("ael", 1206);
    freq.put("z\u030c", 81570);
    freq.put("Pr", 7552);
    freq.put("vs\u030c", 5164);
    freq.put("uto", 4678);
    freq.put("ebn", 2564);
    freq.put("ebo", 12455);
    freq.put("C", 16455);
    freq.put("vu\u030a", 2483);
    freq.put("Pa", 5499);
    freq.put("Pe", 2524);
    freq.put("ede", 6652);
    freq.put("Pi", 1236);
    freq.put("Po", 7183);
    freq.put("Pl", 1516);
    freq.put("he\u0301 ", 1767);
    freq.put("dla", 1946);
    freq.put("ome", 3465);
    freq.put("dle", 4381);
    freq.put("vs\u030ci\u0301", 1568);
    freq.put("dlo", 2844);
    freq.put("et ", 4584);
    freq.put("C\u030ces", 3563);
    freq.put("ta\u0301 ", 1819);
    freq.put("kem", 3800);
    freq.put("kej", 1210);
    freq.put("jov", 2720);
    freq.put("me\u030c ", 2287);
    freq.put("vrc", 1706);
    freq.put("S", 35760);
    freq.put("ket", 1376);
    freq.put("vro", 2455);
    freq.put("tsk", 6630);
    freq.put("etr", 4039);
    freq.put("ave\u030c", 1439);
    freq.put("sov", 4194);
    freq.put("byv", 1815);
    freq.put("tla", 1310);
    freq.put("eta", 2522);
    freq.put("ete", 4466);
    freq.put("tli", 2690);
    freq.put("ve\u030c", 25419);
    freq.put("etn", 2128);
    freq.put("eto", 3093);
    freq.put("ck", 45489);
    freq.put("va\u0301", 31782);
    freq.put("ci", 24104);
    freq.put("ch", 106800);
    freq.put("co", 10175);
    freq.put("cn", 2818);
    freq.put("ve\u0301", 19370);
    freq.put("ca", 4919);
    freq.put("vi\u0301", 13118);
    freq.put("ce", 56738);
    freq.put("cy", 1677);
    freq.put("oho", 4168);
    freq.put("jih", 2344);
    freq.put("cr", 1140);
    freq.put("vy\u0301", 29752);
    freq.put("cu", 2117);
    freq.put("ct", 4541);
    freq.put("bli\u0301", 1257);
    freq.put("vit", 4611);
    freq.put("rve", 2525);
    freq.put("me\u0301n", 4741);
    freq.put("vy\u0301s\u030c", 1486);
    freq.put("byl", 18860);
    freq.put("lu", 15908);
    freq.put("Na\u0301", 1404);
    freq.put("ve\u0301h", 3281);
    freq.put("vy\u0301 ", 6798);
    freq.put("oti", 3017);
    freq.put("otk", 1156);
    freq.put("otn", 1824);
    freq.put("oto", 6726);
    freq.put("ota", 1788);
    freq.put("otb", 1150);
    freq.put("c ", 9636);
    freq.put("edo", 3095);
    freq.put("ote", 2572);
    freq.put("rvn", 4272);
    freq.put("oty", 1225);
    freq.put("ve\u0301m", 1518);
    freq.put("c\u030cit", 1616);
    freq.put("ysk", 1190);
    freq.put("lli", 1334);
    freq.put("vy\u0301z", 2611);
    freq.put("ysl", 1771);
    freq.put("e\u0301", 145384);
    freq.put("edl", 1223);
    freq.put("cov", 2906);
    freq.put("vy\u0301r", 2025);
    freq.put("vy\u0301s", 1250);
    freq.put("emi\u0301", 4275);
    freq.put("vy\u0301m", 2640);
    freq.put("vy\u0301c", 8997);
    freq.put("ohy", 1525);
    freq.put("va", 51428);
    freq.put(" Fr", 2926);
    freq.put("ve", 47740);
    freq.put("ci\u0301", 27801);
    freq.put("nom", 2363);
    freq.put("vi", 26093);
    freq.put("vk", 3052);
    freq.put("vl", 7295);
    freq.put("uz\u030ci\u0301", 6581);
    freq.put("vn", 24780);
    freq.put("vo", 37739);
    freq.put("ive", 2466);
    freq.put("vr", 8123);
    freq.put("vs", 6209);
    freq.put("vu", 5429);
    freq.put(" Fi", 1650);
    freq.put("vy", 26292);
    freq.put("vz", 6628);
    freq.put("ava", 3516);
    freq.put(" Fo", 1382);
    freq.put("of ", 1489);
    freq.put("pis", 3803);
    freq.put("va\u0301n", 11057);
    freq.put("va\u0301l", 2700);
    freq.put("Pr\u030c", 2063);
    freq.put("e\u0301mu", 2422);
    freq.put("v ", 66402);
    freq.put("eds", 1915);
    freq.put("ion", 6938);
    freq.put("nco", 2679);
    freq.put("av ", 1604);
    freq.put("e\u0301m ", 11396);
    freq.put("ont", 3048);
    freq.put("i", 521717);
    freq.put(" Tu", 1143);
    freq.put("ofi", 1587);
    freq.put(" Tr", 2526);
    freq.put(" To", 2242);
    freq.put(" Ti", 1351);
    freq.put(" Th", 2108);
    freq.put("uc\u030ca\u0301", 1855);
    freq.put(" Te", 3210);
    freq.put(" Ta", 2426);
    freq.put("i\u0301dl", 1751);
    freq.put("me\u030cr\u030c", 1748);
    freq.put("sku", 8770);
    freq.put("Be", 3232);
    freq.put("adu", 2552);
    freq.put("Ba", 3474);
    freq.put("a\u0301t ", 2061);
    freq.put("tr\u030ce", 8474);
    freq.put("Bo", 3007);
    freq.put("sky", 9407);
    freq.put("Bi", 1362);
    freq.put("ady", 1580);
    freq.put("ske", 1405);
    freq.put("Bu", 2103);
    freq.put("ade", 3282);
    freq.put("ska", 4807);
    freq.put("Br", 3950);
    freq.put("ada", 3897);
    freq.put("adn", 6465);
    freq.put("ado", 1550);
    freq.put("adl", 1340);
    freq.put("By", 2085);
    freq.put("adi", 3651);
    freq.put("z\u030cni\u0301", 2919);
    freq.put("hu\u030a", 2019);
    freq.put("oc\u030ci\u0301", 2254);
    freq.put("a\u0301te", 1666);
    freq.put("ji ", 4802);
    freq.put("kr\u030ci\u0301", 1234);
    freq.put("a\u0301tn", 2002);
    freq.put("a\u0301to", 1624);
    freq.put("a\u0301tk", 2625);
    freq.put("i\u0301va", 3319);
    freq.put("a\u0301tu", 1328);
    freq.put("na\u0301s", 2254);
    freq.put("ad ", 4944);
    freq.put("kra\u0301", 4170);
    freq.put("bvy", 1413);
    freq.put("vst", 1754);
    freq.put("i\u0301c\u030c", 1699);
    freq.put("kde", 1621);
    freq.put("kdy", 3252);
    freq.put("vsk", 4082);
    freq.put("us\u030ce", 1228);
    freq.put("tr\u030ci\u0301", 4710);
    freq.put("est", 7801);
    freq.put("esp", 1404);
    freq.put("sky\u0301", 19060);
    freq.put("nd ", 2404);
    freq.put("ese", 3215);
    freq.put("ska\u0301", 8637);
    freq.put("iso", 2022);
    freq.put("eso", 1292);
    freq.put("esn", 2468);
    freq.put("ria\u0301", 1833);
    freq.put("esk", 11348);
    freq.put("esi", 1360);
    freq.put("dce", 1208);
    freq.put("i\u0301r\u030c", 2525);
    freq.put("ndi", 1883);
    freq.put("y\u0301ro", 1252);
    freq.put("i\u0301s\u030c", 1631);
    freq.put("hu\u030a ", 1499);
    freq.put("ine\u030c", 2331);
    freq.put("nda", 1497);
    freq.put("nde", 1639);
    freq.put(" js", 6707);
    freq.put(" jm", 2892);
    freq.put("i\u0301va\u0301", 2944);
    freq.put(" ji", 8392);
    freq.put("by ", 4307);
    freq.put("es ", 7550);
    freq.put(" je", 93301);
    freq.put("i\u0301z\u030c", 4061);
    freq.put(" ja", 14129);
    freq.put("kre", 3334);
    freq.put("iny\u0301", 1514);
    freq.put("duc", 1342);
    freq.put("edy", 1655);
    freq.put("ji\u0301c", 10934);
    freq.put("bu ", 2220);
    freq.put("ina\u0301", 3960);
    freq.put("vaj", 2879);
    freq.put(" C\u030ce", 5018);
    freq.put("ubo", 1407);
    freq.put("me\u030cs", 9181);
    freq.put("me\u030cr", 2410);
    freq.put("val", 7096);
    freq.put("vac", 2111);
    freq.put("vad", 1154);
    freq.put("vaz", 1671);
    freq.put("rch", 3978);
    freq.put("urc\u030c", 2415);
    freq.put("var", 2621);
    freq.put("rce", 1159);
    freq.put("me\u030cl", 2079);
    freq.put("pru\u030a", 1838);
    freq.put("vat", 8883);
    freq.put("hy", 6927);
    freq.put("hr", 15902);
    freq.put("hv", 1306);
    freq.put("ade\u030c", 2234);
    freq.put("ht", 2875);
    freq.put("hu", 12412);
    freq.put("hi", 7867);
    freq.put("hn", 5204);
    freq.put("ho", 73846);
    freq.put("hl", 13059);
    freq.put("hm", 1256);
    freq.put("ha", 16982);
    freq.put("bud", 1860);
    freq.put("he", 13421);
    freq.put("va ", 9872);
    freq.put("j", 233650);
    freq.put("dva", 1139);
    freq.put("hni", 1267);
    freq.put("i\u0301l", 6160);
    freq.put("iny", 6607);
    freq.put("pin", 4585);
    freq.put("int", 2630);
    freq.put("inu", 3551);
    freq.put("mys", 1461);
    freq.put("pic", 1267);
    freq.put("ins", 4625);
    freq.put("lm ", 1297);
    freq.put("inn", 2167);
    freq.put("ino", 5250);
    freq.put("ub ", 1463);
    freq.put("ini", 3264);
    freq.put("ink", 1380);
    freq.put("ind", 2184);
    freq.put("ine", 3495);
    freq.put("inf", 1536);
    freq.put("ing", 4248);
    freq.put("ina", 8223);
    freq.put("inc", 4325);
    freq.put("z\u030cne\u030c", 2362);
    freq.put("i\u0301 ", 168172);
    freq.put("eor", 1444);
    freq.put("yra\u0301", 1302);
    freq.put("js\u030ci\u0301", 4959);
    freq.put("or ", 5513);
    freq.put("\u043d", 1523);
    freq.put("hy\u0301", 1516);
    freq.put("he\u0301", 2618);
    freq.put("U", 5533);
    freq.put("ji\u0301m", 1621);
    freq.put("ubl", 3299);
    freq.put("aji", 2410);
    freq.put("ha\u0301", 9650);
    freq.put("in ", 6095);
    freq.put("i\u0301d", 6139);
    freq.put("i\u0301c", 36122);
    freq.put("i\u0301b", 1336);
    freq.put("i\u0301m", 27488);
    freq.put("bce", 1301);
    freq.put("i\u0301n", 7431);
    freq.put("i\u0301h", 10920);
    freq.put("i\u0301k", 10708);
    freq.put("i\u0301j", 1652);
    freq.put("i\u0301t", 5219);
    freq.put("i\u0301v", 7836);
    freq.put("i\u0301p", 2283);
    freq.put("i\u0301s", 9896);
    freq.put("i\u0301r", 5728);
    freq.put("o ", 138337);
    freq.put("i\u0301z", 3776);
  }
  
}

