package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class BG extends CLangProfile {
  private static final String name = "bg";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public BG() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 7994134;
    n_words[1] = 9177756;
    n_words[2] = 6462334;

    freq.put("\u0431\u043b\u0438", 5668);
    freq.put("\u0440\u043d\u0430", 4116);
    freq.put("\u0440\u043d\u043e", 2617);
    freq.put("\u0431\u043b\u0430", 3919);
    freq.put("\u043e\u043f\u0440", 1742);
    freq.put("\u043e\u043f\u0443", 959);
    freq.put("\u0418", 10722);
    freq.put("\u0420\u0443", 2132);
    freq.put(" \u043c\u0435", 7169);
    freq.put(" \u043c\u0430", 9333);
    freq.put(" \u043c\u043e", 4895);
    freq.put(" \u043c\u043d", 1906);
    freq.put(" \u043c\u0438", 3625);
    freq.put("\u043f\u043e\u043a", 1115);
    freq.put("\u043f\u043e\u043b", 13153);
    freq.put("\u0438\u043d\u044f", 874);
    freq.put("\u043f\u043e\u043f", 1206);
    freq.put("\u043f\u043e\u043c", 919);
    freq.put("\u043f\u043e\u043d", 1889);
    freq.put("\u043f\u043e\u0432", 2082);
    freq.put("\u043f\u043e\u0437", 1787);
    freq.put("\u043f\u043e\u0434", 4233);
    freq.put("\u043f\u043e\u0435", 904);
    freq.put("\u0447\u0435 ", 2916);
    freq.put("\u0443\u043f\u0440", 1211);
    freq.put("\u043f\u043e\u0442", 1094);
    freq.put("\u0440\u043d\u0438", 3773);
    freq.put("\u043f\u043e\u0440", 4301);
    freq.put("\u043f\u043e\u0441", 3943);
    freq.put("\u043f\u043e\u0447", 1394);
    freq.put("\u0420\u0430", 3306);
    freq.put(" \u043c\u0443", 6862);
    freq.put("\u0420\u0435", 3655);
    freq.put("\u0420\u0438", 2528);
    freq.put("\u0420\u043e", 3022);
    freq.put(" \u042e\u0436", 1162);
    freq.put("\u0444\u0435\u0440", 834);
    freq.put("\u0434\u0432\u0435", 833);
    freq.put("\u0438\u043d\u0441", 5959);
    freq.put("\u043e\u043f\u043e", 1901);
    freq.put("\u043e\u043f\u0438", 2343);
    freq.put("\u043e\u043f\u0435", 1825);
    freq.put("\u043e\u043f\u0430", 1705);
    freq.put("\u0444\u043e\u0440", 3324);
    freq.put(" \u0420\u0443", 2131);
    freq.put("\u0442\u043b\u0430", 1006);
    freq.put("\u0446\u0430 ", 4811);
    freq.put("\u0438\u043d\u043e", 2511);
    freq.put(" km", 4266);
    freq.put("\u0435\u0438\u0306 ", 1537);
    freq.put("\u0437\u0438\u0440", 1742);
    freq.put("\u0437\u0438\u0442", 1037);
    freq.put("\u043b\u0435 ", 963);
    freq.put("\u043d\u0430\u0437", 881);
    freq.put("\u043d\u0430\u0434", 1993);
    freq.put("\u043d\u0430\u0432", 1281);
    freq.put("\u043d\u0430\u0433", 991);
    freq.put("\u043d\u0430\u043f", 1914);
    freq.put("\u043d\u0430\u043c", 2383);
    freq.put("\u043d\u0430\u043d", 1145);
    freq.put("\u043d\u0430\u043b", 6581);
    freq.put("\u043d\u0430\u0438\u0306", 5108);
    freq.put("\u0430\u0448\u0438", 924);
    freq.put("\u043b\u0438 ", 17289);
    freq.put("\u0443", 110117);
    freq.put("\u03c2", 1823);
    freq.put("\u0441\u043c\u0438", 843);
    freq.put("\u043d\u0430\u0446", 1700);
    freq.put("\u043d\u0430\u0447", 4474);
    freq.put("\u043d\u0430\u0442", 17022);
    freq.put("\u043d\u0430\u0443", 1528);
    freq.put("\u043d\u0430\u0440", 6159);
    freq.put("\u043d\u0430\u0441", 8028);
    freq.put("\u043c\u043d\u043e", 2749);
    freq.put("\u043c\u043d\u0430", 831);
    freq.put("k", 7480);
    freq.put("\u0437\u0438\u043a", 4455);
    freq.put(" \u0420\u0430", 3274);
    freq.put(" \u0420\u0435", 3648);
    freq.put(" \u0420\u0438", 2525);
    freq.put(" \u0420\u043e", 3019);
    freq.put("\u0435\u0437\u0438", 4043);
    freq.put("\u0435\u0437\u043e", 914);
    freq.put("\u0444\u0443\u0442", 2220);
    freq.put("\u0435\u0437\u0430", 1907);
    freq.put("\u043b\u043a\u0430", 1568);
    freq.put("\u0438\u0446\u0430", 5886);
    freq.put("\u0446\u044a", 803);
    freq.put("\u043b\u043a\u043e", 1751);
    freq.put("m ", 2526);
    freq.put("\u043a\u0435\u0434", 4374);
    freq.put("\u0430\u043c ", 1105);
    freq.put("\u044e\u0436\u043d", 872);
    freq.put(" \u0444\u0443", 2793);
    freq.put("\u042e", 3236);
    freq.put("\u044f\u0442\u043e", 2957);
    freq.put("\u0438\u0435 ", 14021);
    freq.put("\u044f\u0442\u0430", 8869);
    freq.put("ir", 844);
    freq.put("\u0413\u044a", 1180);
    freq.put(" \u0441\u0442", 9556);
    freq.put(" \u0444\u043e", 2263);
    freq.put("V", 1965);
    freq.put(" \u0444\u0435", 1675);
    freq.put("\u0436\u0438\u0442", 2528);
    freq.put(" \u0444\u0430", 1634);
    freq.put("\u0446\u0430", 7811);
    freq.put("\u0413\u0440", 2290);
    freq.put("ma", 1173);
    freq.put("\u0446\u0435", 9248);
    freq.put("mb", 856);
    freq.put("\u0446\u0438", 32071);
    freq.put("\u0446\u043a", 2149);
    freq.put("\u0438\u0434\u0430", 1273);
    freq.put("mi", 900);
    freq.put("\u0441\u0432\u043e", 1889);
    freq.put("\u0435\u0440 ", 6034);
    freq.put("\u0443\u043c\u0435", 1194);
    freq.put("\u043b\u0442\u0430", 884);
    freq.put("\u0412\u0435", 2399);
    freq.put("\u0412\u0430", 2968);
    freq.put("\u044a\u043c ", 3109);
    freq.put("\u0443\u043c\u0430", 1453);
    freq.put("\u0412\u043e", 969);
    freq.put("\u0412\u0438", 2290);
    freq.put(" \u0418\u0306\u043e", 1543);
    freq.put("\u0418\u0306", 1921);
    freq.put("\u0438\u0437\u043e", 1731);
    freq.put("\u041f\u043e", 4526);
    freq.put("\u0438\u0437\u043c", 1954);
    freq.put("\u0438\u0437\u043d", 1188);
    freq.put("\u041f\u043b", 3225);
    freq.put("\u0438\u0437\u043b", 1205);
    freq.put("\u0438\u0437\u0438", 3858);
    freq.put("\u041f\u0438", 1272);
    freq.put("\u041f\u0435", 2744);
    freq.put("\u0438\u0437\u0432", 5752);
    freq.put("\u0438\u0437\u0430", 5067);
    freq.put("\u041f\u0430", 3246);
    freq.put("\u0438\u0438\u0306\u0441", 6452);
    freq.put("\u0430\u043b\u0431", 1650);
    freq.put("m2", 3381);
    freq.put("\u0449 ", 4203);
    freq.put("A", 4351);
    freq.put("\u043e\u044f\u043d", 1222);
    freq.put("\u043e\u043a\u0440", 6747);
    freq.put("\u0438\u0437\u044a", 865);
    freq.put("II ", 1339);
    freq.put("\u0438\u0437\u0445", 1032);
    freq.put("\u0438\u0437\u0442", 2743);
    freq.put("\u0448 ", 1936);
    freq.put("\u041f\u0440", 4433);
    freq.put("\u0433\u0430\u0440", 12015);
    freq.put("\u0440\u0436\u0430", 2590);
    freq.put("\u0412\u044a", 2366);
    freq.put("\u0432\u0430\u0440", 1920);
    freq.put("\u043e\u0431\u0449", 5055);
    freq.put(" \u043d\u044f", 1648);
    freq.put("\u0437\u0440\u0430", 1726);
    freq.put("\u0414\u0438\u043c", 1088);
    freq.put("\u0440\u043e\u044f", 1120);
    freq.put("\u0440\u043e\u0441", 2878);
    freq.put("\u0440\u043e\u0442", 1758);
    freq.put("\u0440\u043e\u0444", 1212);
    freq.put("\u0440\u043e\u0446", 854);
    freq.put("\u03c1", 1221);
    freq.put("\u0440\u043e\u0438", 4466);
    freq.put("\u0440\u043e\u043b", 1507);
    freq.put("\u0440\u043e\u043a", 1893);
    freq.put("\u0440\u043e\u043d", 2340);
    freq.put("\u0444", 35061);
    freq.put("\u0440\u043e\u043f", 2362);
    freq.put("\u0440\u043e\u0433", 1151);
    freq.put("\u0440\u043e\u0432", 7381);
    freq.put("\u0440\u043e\u0435", 938);
    freq.put("\u0440\u043e\u0434", 7855);
    freq.put("\u0440\u043e\u0437", 1160);
    freq.put("\u0433\u043e ", 2882);
    freq.put(" \u043d\u0435", 9125);
    freq.put(" \u043d\u0430", 119378);
    freq.put("\u0431\u044a\u0434", 803);
    freq.put(" \u043d\u043e", 5035);
    freq.put(" \u043d\u0438", 1121);
    freq.put("l", 16413);
    freq.put("\u041d\u0438\u043a", 1456);
    freq.put("\u0444\u0435\u0441", 938);
    freq.put("\u0438\u0306\u0441\u0442", 3543);
    freq.put("\u043e\u0431\u043e", 1542);
    freq.put("\u0438\u044f\u0442", 14767);
    freq.put("\u043d\u044f ", 922);
    freq.put("\u0440\u0430\u0442", 10837);
    freq.put("\u0440\u0430\u0441", 2637);
    freq.put("\u0440\u0430\u0446", 1472);
    freq.put("\u0440\u0430\u0444", 2143);
    freq.put("\u0440\u0430\u0449", 1083);
    freq.put("\u0440\u0430\u044f", 1251);
    freq.put("rt", 1054);
    freq.put("\u043e\u043c\u0430", 3616);
    freq.put("\u043e\u043c\u0435", 3032);
    freq.put("\u043e\u043c\u0438", 2906);
    freq.put("\u0438\u0306\u0441\u043a", 8916);
    freq.put("\u042f", 1596);
    freq.put("\u043e\u043c\u043e", 1980);
    freq.put("rd", 988);
    freq.put("re", 2281);
    freq.put("\u0445\u043e", 7132);
    freq.put("ra", 2624);
    freq.put("\u0442\u0438\u044f", 3555);
    freq.put("\u0445\u0435", 1611);
    freq.put("\u0442\u0438\u0440", 2210);
    freq.put("rn", 867);
    freq.put("ro", 1958);
    freq.put("\u0445\u0430", 4667);
    freq.put("\u0442\u0438\u0447", 5203);
    freq.put("\u0442\u0438\u0446", 909);
    freq.put("\u0442\u0438\u043b", 1307);
    freq.put("\u0433\u0430\u043b", 815);
    freq.put("\u0442\u0438\u043d", 3775);
    freq.put("\u0433\u0430\u043d", 4672);
    freq.put("\u0442\u0438\u0432", 4139);
    freq.put("\u0442\u0438\u0435", 1898);
    freq.put("\u0445\u0440", 1667);
    freq.put("\u0445\u0443", 1707);
    freq.put("W", 1604);
    freq.put("\u0440\u043c\u0438", 2339);
    freq.put("\u0440\u0430\u0432", 5786);
    freq.put("\u0440\u0430\u0431", 3055);
    freq.put("\u0440\u0430\u0437", 12192);
    freq.put("\u0440\u0430\u0436", 1539);
    freq.put("\u0440\u0430\u0435", 904);
    freq.put("\u0440\u0430\u0434", 11688);
    freq.put("\u0440\u0430\u043b", 6906);
    freq.put("\u0440\u0430\u043a", 2465);
    freq.put("\u0440\u0430\u0438\u0306", 2815);
    freq.put("\u0440\u0430\u043d", 13900);
    freq.put("\u0440\u0430\u043c", 2735);
    freq.put("\u043c\u044f\u0442", 820);
    freq.put("r ", 3015);
    freq.put("\u0430\u0449\u043e", 823);
    freq.put("\u0430\u0449\u0430", 2195);
    freq.put("\u0300", 1150);
    freq.put("\u0443\u043c ", 1519);
    freq.put(" \u0421\u0410", 2616);
    freq.put("\u0434\u0435 ", 1425);
    freq.put("\u041a", 22064);
    freq.put("\u043e\u0431\u0438", 2313);
    freq.put("\u043c\u043e\u043d", 1361);
    freq.put("\u0437\u043b\u0438", 2352);
    freq.put("\u043c\u043e\u043b", 819);
    freq.put("\u043c\u043e\u0434", 977);
    freq.put("\u043c\u043e\u0436", 1224);
    freq.put("\u0424\u0440", 2381);
    freq.put("\u043c\u043e\u0432", 951);
    freq.put(" \u0421\u0430", 2935);
    freq.put(" \u0421\u0432", 1624);
    freq.put(" \u0421\u0435", 4013);
    freq.put("\u0420\u0438\u043c", 1524);
    freq.put(" \u0421\u0438", 2198);
    freq.put(" \u0421\u043a", 944);
    freq.put(" \u0421\u043b", 1251);
    freq.put(" \u0421\u043e", 2383);
    freq.put(" \u0421\u043f", 1315);
    freq.put(" \u0421\u0440", 879);
    freq.put(" \u0421\u0442", 4014);
    freq.put("B", 3121);
    freq.put("\u044e ", 929);
    freq.put(" \u0421\u044a", 4598);
    freq.put("\u0435\u0436\u0434", 5041);
    freq.put("\u0437\u0435\u043c", 1420);
    freq.put("\u0424\u043e", 984);
    freq.put("\u0443\u0447\u0438", 956);
    freq.put("\u0424\u043b", 885);
    freq.put("\u0424\u0438", 1127);
    freq.put("\u043b\u043d\u0430", 4870);
    freq.put("\u043b\u043d\u043e", 5548);
    freq.put("\u0424\u0435", 819);
    freq.put("\u043c\u043e\u0441", 1285);
    freq.put("\u043c\u043e\u0440", 2165);
    freq.put("\u043c\u043e\u0442", 885);
    freq.put("\u0430\u043d ", 12026);
    freq.put("\u043a\u0432\u0430", 2572);
    freq.put("\u044a\u0442 ", 6352);
    freq.put("\u0442\u0438\u0441", 902);
    freq.put("\u043b\u044f\u043d", 866);
    freq.put("\u043b\u044f\u043c", 2082);
    freq.put("\u043b\u044f\u0432", 2485);
    freq.put("\u0430\u043f\u0440", 1718);
    freq.put("\u044a\u0440\u0448", 1020);
    freq.put(" \u0445\u043e", 1370);
    freq.put("\u0438\u0438 ", 2933);
    freq.put(" \u0445\u0438", 1498);
    freq.put("\u044a\u0440\u0441", 856);
    freq.put("\u044a\u0440\u0442", 1540);
    freq.put(" \u0445\u0430", 1277);
    freq.put("\u044a\u0440\u0446", 1189);
    freq.put("\u0441 ", 29451);
    freq.put("\u0437\u0438\u044f", 1529);
    freq.put(" \u041a\u0440", 2158);
    freq.put(" \u041a\u0443", 1412);
    freq.put("\u0435\u043a\u0438", 1118);
    freq.put("\u0422\u043e\u0438\u0306", 2267);
    freq.put("\u0417\u0430", 3607);
    freq.put("\u0422\u043e\u0432", 901);
    freq.put("\u0432\u043a\u043b", 1196);
    freq.put("on ", 1530);
    freq.put("\u0445", 26992);
    freq.put("\u044a\u043d ", 3472);
    freq.put("\u0432\u0430 ", 24595);
    freq.put(" \u041a\u043e", 5424);
    freq.put(" \u041a\u0438", 1607);
    freq.put(" \u041a\u043b", 1282);
    freq.put(" \u041a\u0435", 833);
    freq.put(" \u041a\u0430", 6065);
    freq.put("es", 2494);
    freq.put("\u044a\u0440\u043a", 1004);
    freq.put("\u044a\u0440\u043d", 1183);
    freq.put("\u044a\u0440\u0432", 4886);
    freq.put(" \u0445\u0440", 1022);
    freq.put("\u044a\u0440\u0434", 852);
    freq.put("\u044a\u0440\u0437", 1179);
    freq.put(" \u0445\u0443", 840);
    freq.put("\u0430\u043f\u043e", 1282);
    freq.put("\u0430\u043f\u0438", 1535);
    freq.put("\u043b\u044f\u0440", 941);
    freq.put("\u043b\u044f\u0442", 839);
    freq.put("\u0430\u043f\u0430", 4649);
    freq.put("\u0442\u043d\u0430", 2467);
    freq.put("\u0420\u0435\u043f", 2237);
    freq.put("\u0442\u043d\u0438", 5121);
    freq.put("\u0442\u043d\u043e", 3117);
    freq.put("d ", 2383);
    freq.put("\u0435\u0432\u043d", 1170);
    freq.put("\u0435\u0440\u043e", 3866);
    freq.put("\u0447\u0435\u0442", 1965);
    freq.put("\u0435\u0440\u043c", 2802);
    freq.put("\u0435\u0440\u043d", 4552);
    freq.put("\u0435\u0440\u0438", 14051);
    freq.put("\u043f\u043e ", 9531);
    freq.put("\u0440\u044a\u0436", 849);
    freq.put("\u0440\u044a\u0431", 829);
    freq.put("\u0435\u0440\u0433", 986);
    freq.put("\u0440\u044a\u0433", 7752);
    freq.put("km2", 3379);
    freq.put("\u0441\u043e\u0444", 1092);
    freq.put("\u0441\u043e\u0446", 1039);
    freq.put("\u0430\u0446\u0438", 9279);
    freq.put("\u0447\u043b\u0435", 872);
    freq.put("do", 824);
    freq.put("\u0441\u043e\u0431", 1154);
    freq.put("\u0441\u043e\u0432", 1181);
    freq.put("di", 1045);
    freq.put("de", 1775);
    freq.put("\u0441\u043e\u043a", 1395);
    freq.put("da", 1108);
    freq.put("\u0447\u0435\u0432", 1376);
    freq.put("X", 1029);
    freq.put("\u0440\u044a\u0446", 1917);
    freq.put("\u0440\u044a\u0441", 815);
    freq.put("\u0447\u0435\u043d", 5933);
    freq.put("\u0435\u0440\u0441", 2306);
    freq.put("\u0437\u043e\u0432", 1006);
    freq.put("\u0437\u043e\u043d", 1141);
    freq.put("\u0421\u0410\u0429", 2595);
    freq.put("\u043a\u0440\u044a", 8385);
    freq.put("\u0435\u0438\u0306\u043d", 1799);
    freq.put("\u0443\u0442\u0431", 2290);
    freq.put(" I ", 819);
    freq.put("\u043b\u0438\u0438\u0306", 4336);
    freq.put("\u043b\u0438\u043a", 5518);
    freq.put("\u043b\u0438\u043c", 1095);
    freq.put(" \u0442\u0440", 4417);
    freq.put(" \u0442\u0443", 1481);
    freq.put("\u043b\u0438\u0430", 1575);
    freq.put(" \u0442\u044f", 1501);
    freq.put("\u043b\u0438\u0433", 889);
    freq.put(" \u0442\u044a", 1070);
    freq.put("\u043d\u0430 ", 142528);
    freq.put("\u0432\u044f\u0442", 853);
    freq.put("C", 4592);
    freq.put("\u0443\u0434\u043e", 1145);
    freq.put("\u0443\u0434\u0438", 922);
    freq.put(" \u0442\u0435", 8827);
    freq.put("\u043b\u0438\u0449", 1562);
    freq.put(" \u0442\u0430", 2605);
    freq.put("\u043b\u0438\u044f", 3676);
    freq.put("\u043b\u0438\u0441", 3220);
    freq.put("\u043b\u0438\u0442", 6583);
    freq.put(" \u0442\u043e", 4709);
    freq.put("\u043b\u0438\u0444", 806);
    freq.put(" \u0442\u0438", 1471);
    freq.put("\u043b\u0438\u0446", 2347);
    freq.put("\u043b\u0438\u0447", 3301);
    freq.put("\u0446\u0430\u0440", 1123);
    freq.put("\u0446\u0430\u0442", 1708);
    freq.put("\u0435\u0438\u0306\u0441", 4529);
    freq.put("\u043a\u0440\u0438", 2482);
    freq.put("\u0437\u0438 ", 3101);
    freq.put("\u043a\u0440\u0430", 5743);
    freq.put("\u0443\u0440\u0438", 1177);
    freq.put("\u043a\u0440\u0435", 815);
    freq.put(" \u0417\u0430", 3604);
    freq.put("\u0416", 1534);
    freq.put("\u0435\u0437 ", 10672);
    freq.put("\u0438\u0435\u0432", 1368);
    freq.put("\u0438\u0435\u043d", 1203);
    freq.put("\u03b9\u0301", 816);
    freq.put("\u0436\u0430\u043d", 924);
    freq.put("\u0430\u043c\u0435", 7196);
    freq.put("\u0430\u043c\u0430", 2784);
    freq.put("\u0430\u043c\u043f", 965);
    freq.put("\u0430\u043c\u043e", 2012);
    freq.put("\u0430\u043c\u0438", 3947);
    freq.put("\u0431\u0435\u043a", 854);
    freq.put("\u0430\u0440\u0445", 1193);
    freq.put("\u0433\u0440\u0430", 16257);
    freq.put("\u0438\u0435\u0442", 8077);
    freq.put("Co", 972);
    freq.put("Ca", 930);
    freq.put("n", 21831);
    freq.put("\u0446 ", 3623);
    freq.put("\u0447\u043d\u0430", 4150);
    freq.put("\u043c\u0435", 34130);
    freq.put("\u043c\u0432", 3536);
    freq.put("\u043c\u0430", 34017);
    freq.put("\u043c\u0431", 1834);
    freq.put("\u043c\u043e", 14552);
    freq.put("\u043c\u043f", 7095);
    freq.put("is", 2366);
    freq.put("\u043c\u043d", 4561);
    freq.put("iu", 2316);
    freq.put("it", 1525);
    freq.put("\u043c\u0438", 25035);
    freq.put("\u0431\u0441\u043a", 1045);
    freq.put("\u0447\u043d\u0438", 4370);
    freq.put("\u0412 ", 2290);
    freq.put("il", 1887);
    freq.put("io", 1821);
    freq.put("in", 4071);
    freq.put("ia", 2261);
    freq.put("ic", 2468);
    freq.put("ie", 1280);
    freq.put("id", 1203);
    freq.put("ig", 1082);
    freq.put("\u0449\u0438", 5926);
    freq.put("\u0449\u043d", 816);
    freq.put("\u0449\u043e", 3015);
    freq.put("\u0449\u0430", 13149);
    freq.put("\u0430\u0440\u0434", 1683);
    freq.put("\u0449\u0435", 7866);
    freq.put("\u043e\u044f\u0432", 887);
    freq.put("\u0441", 363493);
    freq.put("\u0433\u0440\u0443", 3152);
    freq.put("\u0435\u043b\u043e", 4047);
    freq.put("\u03c4", 1963);
    freq.put("\u0415\u043b", 966);
    freq.put("\u0440\u043c\u0430", 3665);
    freq.put("\u0415\u0434", 825);
    freq.put("\u0415\u0432", 1551);
    freq.put("\u0438\u0438\u0306 ", 4437);
    freq.put("i ", 1873);
    freq.put("\u043a\u043e", 52495);
    freq.put("\u0449\u0442", 2297);
    freq.put("\u043e\u044f\u0442", 3638);
    freq.put(" \u043b\u0430", 1472);
    freq.put(" \u043b\u0435", 2135);
    freq.put(" \u043b\u0438", 3157);
    freq.put("\u0432\u0433\u0443", 856);
    freq.put("\u043c\u0443", 8961);
    freq.put("\u043c\u0441", 4731);
    freq.put("\u043c\u044f", 2035);
    freq.put("\u043c\u044a", 3046);
    freq.put("\u044a\u043a ", 1412);
    freq.put("\u0433\u043e\u0440", 2288);
    freq.put("\u0433\u043e\u0434", 7938);
    freq.put("\u0433\u043e\u0432", 3764);
    freq.put("D", 2636);
    freq.put("\u0442\u043a\u0430", 1702);
    freq.put("\u0428\u0430", 824);
    freq.put("\u0433\u043e\u043b", 3089);
    freq.put("\u0440\u043e ", 1581);
    freq.put("\u0417\u0430\u043f", 1336);
    freq.put("\u0430\u0447\u0435", 1418);
    freq.put(" \u043d ", 881);
    freq.put("\u0430\u0447\u0430", 3148);
    freq.put("\u0430\u0447\u0438", 1132);
    freq.put("\u0441\u043d\u0438", 1224);
    freq.put("\u0441\u043d\u043e", 4759);
    freq.put("\u0441\u043d\u0430", 1239);
    freq.put("\u043d\u044f\u043a", 1962);
    freq.put("\u0417", 5627);
    freq.put("\u043d\u044f\u0432", 1202);
    freq.put("\u0448\u0430 ", 1093);
    freq.put("\u0441\u0432\u044a", 838);
    freq.put("\u0441\u0430 ", 8477);
    freq.put("\u041b\u0430", 1638);
    freq.put("\u0442\u0430\u0442", 3225);
    freq.put("\u041b\u0435", 1710);
    freq.put("\u041b\u0438", 1795);
    freq.put("\u0445 ", 2350);
    freq.put("\u043e\u043c ", 1452);
    freq.put("\u0447\u043a\u0438", 1198);
    freq.put("\u041b\u0443", 1452);
    freq.put("\u0433\u0430 ", 4136);
    freq.put("\u0442\u0438 ", 11022);
    freq.put("\u0430\u0449 ", 1410);
    freq.put("\u0411\u0440\u0430", 846);
    freq.put("\u0441\u0438 ", 5183);
    freq.put("o", 21963);
    freq.put("\u0440\u0430 ", 12349);
    freq.put("\u0447\u0440\u0435", 802);
    freq.put("\u0448\u043d\u0438", 1037);
    freq.put("\u0434\u0435\u0438\u0306", 1639);
    freq.put("\u0430\u043d\u0446", 1702);
    freq.put("\u0434\u0435\u043b", 3837);
    freq.put("\u0434\u0435\u043c", 1659);
    freq.put("\u0430\u043d\u0441", 13953);
    freq.put("\u0430\u043d\u0442", 4813);
    freq.put("\u0437\u0430\u043d", 2665);
    freq.put("\u0434\u0435\u0435", 1168);
    freq.put("\u0446\u0438\u043e", 6596);
    freq.put(" \u0443\u043f", 1428);
    freq.put(" \u0443\u043d", 1177);
    freq.put("\u0432\u0441\u0442", 1194);
    freq.put("\u0413\u044a\u0440", 1058);
    freq.put(" \u0444\u0440", 2272);
    freq.put("\u044e\u0440", 1010);
    freq.put("\u0448\u043d\u0430", 1940);
    freq.put(" \u0418\u0441", 1003);
    freq.put("\u044e\u0446", 3295);
    freq.put("\u044e\u0447", 2002);
    freq.put("\u043a\u0441\u0438", 1227);
    freq.put("er ", 1669);
    freq.put("\u043c\u043e ", 1651);
    freq.put("\u043a\u0441\u0430", 1220);
    freq.put("\u03c3", 1479);
    freq.put("\u0442", 513431);
    freq.put("\u044e\u043b", 1213);
    freq.put("\u044e\u043d", 1123);
    freq.put(" \u0418\u043d", 1152);
    freq.put(" \u0418\u043c", 970);
    freq.put(" \u0418\u0432", 1368);
    freq.put("\u044e\u0433", 1081);
    freq.put(" \u0418\u0437", 2283);
    freq.put("\u044e\u0436", 980);
    freq.put("\u044e\u0437", 1052);
    freq.put(" \u0443\u0441", 1789);
    freq.put("\u0438\u0436\u0435", 812);
    freq.put(" \u0443\u0447", 2779);
    freq.put("\u0430\u043d\u0434", 5902);
    freq.put("\u0430\u043d\u0435", 11702);
    freq.put("\u0430\u043d\u0430", 8635);
    freq.put("\u0430\u043d\u0433", 4584);
    freq.put("\u0434\u0435\u0440", 1762);
    freq.put("\u0430\u043d\u043d", 912);
    freq.put("\u0430\u043d\u043e", 4066);
    freq.put("\u0430\u043d\u0438", 19618);
    freq.put("\u0430\u043d\u043a", 1502);
    freq.put("\u041a\u0440", 2175);
    freq.put("\u041a\u0443", 1413);
    freq.put("\u043b\u044f ", 1353);
    freq.put("\u0434\u0436\u0438", 1277);
    freq.put("ni", 2114);
    freq.put("no", 824);
    freq.put("na", 1825);
    freq.put("nd", 1832);
    freq.put("ne", 1694);
    freq.put("ng", 1442);
    freq.put("\u0441\u0430", 17003);
    freq.put("\u0441\u0432", 7943);
    freq.put("\u0441\u0435", 41908);
    freq.put("\u0432\u0430\u0449", 3095);
    freq.put("\u0441\u0438", 23052);
    freq.put("\u0441\u043b", 11817);
    freq.put("\u0441\u043a", 74214);
    freq.put("\u0441\u043d", 7769);
    freq.put("\u0441\u043c", 3598);
    freq.put("\u0441\u043f", 8021);
    freq.put("\u0441\u043e", 8891);
    freq.put("\u0441\u0440", 4324);
    freq.put("\u0441\u0443", 2617);
    freq.put("\u0441\u0442", 96170);
    freq.put("E", 1936);
    freq.put("\u0441\u0446", 1590);
    freq.put("\u0432\u0430\u043b", 2194);
    freq.put("\u0441\u044a", 18957);
    freq.put("\u0432\u0430\u043d", 13950);
    freq.put("\u0441\u044c", 1346);
    freq.put("\u0441\u044f", 1659);
    freq.put("\u0431\u0440\u0435", 1262);
    freq.put("\u0437\u0441\u043b", 944);
    freq.put("\u0445\u0438\u043c", 863);
    freq.put("n ", 4895);
    freq.put("\u0438\u0438\u0442", 965);
    freq.put("\u041a\u043e", 5445);
    freq.put("\u041a\u0438", 1609);
    freq.put("\u041a\u043b", 1286);
    freq.put("\u041a\u0435", 836);
    freq.put("\u041a\u0430", 6073);
    freq.put("\u043b\u0431\u0443", 1567);
    freq.put("\u043a\u043e\u0432", 4810);
    freq.put(" \u0447\u0435", 4520);
    freq.put("\u043a\u043e\u0435", 2107);
    freq.put("\u043a\u043e\u043b", 6405);
    freq.put("\u043a\u043e\u0438\u0306", 3594);
    freq.put("\u043a\u043e\u0438", 3390);
    freq.put("\u043a\u043e\u043f", 1296);
    freq.put(" \u0447\u043b", 866);
    freq.put(" \u0447\u0438", 1314);
    freq.put("\u041b\u043e", 1497);
    freq.put("\u0438\u043a ", 10314);
    freq.put("\u0447\u0435", 23255);
    freq.put("\u0447\u0432", 2213);
    freq.put("\u0447\u0430", 14633);
    freq.put("\u0447\u043e", 1988);
    freq.put("\u0447\u043d", 11748);
    freq.put("\u0447\u043b", 917);
    freq.put("\u0447\u043a", 2263);
    freq.put("\u0447\u0438", 7731);
    freq.put("\u0435\u0434\u0432", 1395);
    freq.put("\u0435\u0434\u0430", 2616);
    freq.put("\u0435\u0434\u0435", 4183);
    freq.put("\u0435\u0434\u0438", 11058);
    freq.put("\u0435\u0434\u043e", 5545);
    freq.put("\u0435\u0434\u043d", 6376);
    freq.put("me", 1262);
    freq.put(" \u041c\u0435", 2502);
    freq.put("\u0435\u0434\u0441", 4153);
    freq.put(" \u041c\u0430", 9223);
    freq.put("\u0448", 24527);
    freq.put("\u043e\u0442 ", 40884);
    freq.put("\u044a\u043b ", 2252);
    freq.put(" \u041c\u0438", 2950);
    freq.put("\u0447\u0443", 949);
    freq.put("\u043d ", 69303);
    freq.put("\u0438\u044f ", 57202);
    freq.put("\u0447\u0440", 804);
    freq.put("\u0432\u043e ", 9926);
    freq.put("\u0441\u0432\u0435", 3239);
    freq.put("\u0442\u044a\u0440", 5898);
    freq.put("p", 5894);
    freq.put("\u043a\u043e\u0441", 1575);
    freq.put("\u043a\u043e\u0440", 1875);
    freq.put("\u043a\u043e\u044f", 2700);
    freq.put("\u0438\u043c\u043f", 3052);
    freq.put("\u0438\u043c\u043e", 1892);
    freq.put("\u0438\u043c\u043d", 924);
    freq.put("\u0438\u043c\u0438", 3098);
    freq.put("\u0438\u043c\u0435", 5126);
    freq.put("\u0438\u043c\u0430", 3880);
    freq.put("\u0433\u044a", 1359);
    freq.put("\u043d\u043d\u043e", 1572);
    freq.put("\u0430\u0433\u043e", 1396);
    freq.put("\u0433\u0443", 2534);
    freq.put("\u0430\u0433\u0430", 1670);
    freq.put("\u0433\u0440", 23857);
    freq.put("\u043e\u0440\u044a", 1155);
    freq.put("\u043e\u0440\u0441", 1471);
    freq.put("\u043e\u0440\u0442", 2090);
    freq.put("\u0433", 129585);
    freq.put("\u0438\u0441\u044c", 1263);
    freq.put("\u044a\u0442", 9515);
    freq.put("\u0424\u0440\u0430", 1531);
    freq.put("\u0438\u0441\u0442", 15576);
    freq.put("\u0438\u0441\u0438", 1489);
    freq.put("\u0438\u0441\u043a", 1625);
    freq.put("\u0438\u0441\u043b", 1753);
    freq.put("Ma", 1469);
    freq.put("\u0426\u0435", 1510);
    freq.put("\u0438\u0441\u043e", 1673);
    freq.put("\u0438\u0441\u043f", 938);
    freq.put("\u0438\u0441\u0430", 3563);
    freq.put("\u043e\u0440\u043d", 2306);
    freq.put("\u043e\u0440\u043c", 3070);
    freq.put("\u043b\u0443\u0447", 1122);
    freq.put(" \u0430 ", 4115);
    freq.put("\u043e\u0440\u0438", 9957);
    freq.put("\u0410\u043b\u0435", 1070);
    freq.put("\u043e\u0440\u0435", 5253);
    freq.put(" \u0446", 6298);
    freq.put("\u043e\u0440\u0430", 5790);
    freq.put("\u043e\u0440\u0433", 4291);
    freq.put("\u0433\u043b", 8226);
    freq.put("\u0433\u0438", 12185);
    freq.put("\u0433\u043e", 24434);
    freq.put("\u0433\u043d", 1340);
    freq.put("\u0430\u0433\u0440", 1076);
    freq.put("\u0433\u0430", 25651);
    freq.put("\u0433\u0435", 6356);
    freq.put("\u043e\u043d ", 7439);
    freq.put(" \u0448", 3296);
    freq.put("\u0438\u043c\u0441", 2034);
    freq.put("\u043e\u0433\u0440", 2846);
    freq.put("\u0429 ", 2591);
    freq.put("\u0442\u044a\u043d", 1062);
    freq.put("\u041e", 13337);
    freq.put("\u0430", 881417);
    freq.put(" \u0432\u0441", 1918);
    freq.put(" \u0432\u0440", 3197);
    freq.put(" \u0432\u0442", 1082);
    freq.put("\u043d\u043e ", 26769);
    freq.put("\u03b5", 1298);
    freq.put(" \u0432\u044a", 7192);
    freq.put(" \u0432\u0435", 5179);
    freq.put(" \u0432\u0430", 1142);
    freq.put("F", 2232);
    freq.put("\u0447 ", 2829);
    freq.put(" \u0432\u0438", 5408);
    freq.put(" \u0432\u043b", 1868);
    freq.put(" \u0432\u043a", 1271);
    freq.put("\u043e\u0433\u0438", 3492);
    freq.put("\u0443\u0431\u043b", 3878);
    freq.put("\u043e\u0433\u043e", 3019);
    freq.put("\u043e\u0433\u0430", 2254);
    freq.put("\u0432\u043e\u043b", 4504);
    freq.put("\u043b\u043c ", 1747);
    freq.put("\u043c ", 14788);
    freq.put("\u0433\u0435\u0440", 1710);
    freq.put("\u0432\u043e\u0438\u0306", 3658);
    freq.put(" \u0424\u0440", 2376);
    freq.put("\u0444\u0440\u0435", 1952);
    freq.put("\u0441\u0442 ", 15103);
    freq.put("\u0440\u0433\u0438", 1489);
    freq.put("\u0440\u0433\u0430", 3761);
    freq.put("s ", 10393);
    freq.put("\u0438\u0437\u043f", 3253);
    freq.put("\u0449", 37947);
    freq.put("\u044c\u043e\u0440", 2769);
    freq.put("\u044c\u043e", 4687);
    freq.put("\u0438\u0437\u043a", 1474);
    freq.put("\u0432\u043e\u0434", 4759);
    freq.put(" \u0432", 81473);
    freq.put("\u043e\u0442\u043a", 1219);
    freq.put("ss", 891);
    freq.put("\u0438\u0442\u043d", 995);
    freq.put("\u0411\u0435\u043b", 1301);
    freq.put("st", 2061);
    freq.put(" \u0424\u043e", 984);
    freq.put("si", 1173);
    freq.put(" \u0424\u043b", 885);
    freq.put("\u0437\u0430\u0442", 1310);
    freq.put(" \u0424\u0438", 1126);
    freq.put(" \u0424\u0435", 819);
    freq.put("\u0438\u0437\u0434", 1669);
    freq.put("se", 1041);
    freq.put("\u0446\u043a\u0438", 1353);
    freq.put("\u044f\u043d\u0435", 821);
    freq.put("\u0443\u0437\u0438", 1937);
    freq.put("\u044f\u043d\u0438", 1186);
    freq.put("\u0434\u0435\u043a", 992);
    freq.put("\u044f ", 66327);
    freq.put("\u043b\u043e\u043c", 832);
    freq.put("\u0425\u043e", 1081);
    freq.put("\u0425\u0435", 1295);
    freq.put("\u043b\u043e\u0432", 4045);
    freq.put("\u0425\u0430", 2310);
    freq.put("\u0434\u0435\u043d", 12663);
    freq.put("\u0442\u0435\u043a", 1131);
    freq.put("\u0442\u0435\u043b", 16601);
    freq.put("\u0442\u0435\u043e", 1008);
    freq.put("\u0442\u0435\u043c", 3541);
    freq.put("\u0434\u0430 ", 13229);
    freq.put("\u0442\u0435\u0437", 1494);
    freq.put("\u0430\u043a ", 1047);
    freq.put("\u03b1", 2356);
    freq.put("\u0434", 212987);
    freq.put("\u0435\u0448\u043d", 2173);
    freq.put("\u0440\u0442\u0438", 2728);
    freq.put("\u044a\u0441 ", 1987);
    freq.put("\u0441\u0440\u0435", 3295);
    freq.put("\u0430\u0432 ", 839);
    freq.put("\u044a\u0432\u0435", 1335);
    freq.put(" \u0448\u0430", 881);
    freq.put("\u0435\u0440\u0432", 1379);
    freq.put("\u0442\u0435\u0442", 1731);
    freq.put("\u0438\u043b ", 4244);
    freq.put("\u0442\u0435\u0441", 853);
    freq.put("\u0442\u0435\u0445", 952);
    freq.put("\u0442 ", 98842);
    freq.put("\u043b\u043e\u0449", 4100);
    freq.put("\u043b\u043e\u0442", 2604);
    freq.put("\u0425\u0440", 971);
    freq.put("\u043b\u043e\u0440", 940);
    freq.put("\u043b\u043e\u0441", 1248);
    freq.put("\u0435\u0433\u0430", 870);
    freq.put("\u0435\u0433\u043e", 2858);
    freq.put("\u0435\u0433\u0438", 1678);
    freq.put("el", 2062);
    freq.put("en", 3274);
    freq.put(" \u041d\u0430", 5243);
    freq.put("ed", 916);
    freq.put(" \u041d\u043e", 2047);
    freq.put("\u044a\u0442\u0440", 1736);
    freq.put("ea", 1397);
    freq.put("ec", 826);
    freq.put("\u0438\u043a", 36656);
    freq.put("\u0438\u043b", 29439);
    freq.put("\u0438\u0438", 4086);
    freq.put("\u0438\u0438\u0306", 12560);
    freq.put("\u0438\u043e", 15275);
    freq.put("\u0438\u043f", 3934);
    freq.put("\u0438\u043c", 23532);
    freq.put("\u0438\u043d", 58356);
    freq.put("\u0435\u0442", 45213);
    freq.put("\u0438\u0433", 8987);
    freq.put("\u0438\u0430", 9057);
    freq.put("\u0438\u0431", 2301);
    freq.put("\u0438\u0436", 2121);
    freq.put("\u0438\u0437", 36345);
    freq.put("\u0438\u0434", 10074);
    freq.put("\u0438\u0435", 26794);
    freq.put(" \u0412", 15997);
    freq.put("\u0438\u0446\u0438", 6007);
    freq.put(" \u0410", 17337);
    freq.put("\u0434\u0432\u0438", 1371);
    freq.put("\u043b\u0430\u0432", 4235);
    freq.put("\u043b\u0430\u0433", 1602);
    freq.put("\u043b\u0430\u0434", 2109);
    freq.put("\u0434\u0432\u0430", 2719);
    freq.put("\u0438\u043d\u0446", 2399);
    freq.put("\u043b\u0430\u043c", 805);
    freq.put("\u043b\u0430\u043d", 5659);
    freq.put("\u0438\u043d\u0442", 1527);
    freq.put("\u043b\u0430\u0441", 5904);
    freq.put("\u043b\u0430\u0442", 3266);
    freq.put("\u0438\u043d\u0438", 7734);
    freq.put("G", 2334);
    freq.put("\u0438\u043d\u0434", 1369);
    freq.put("\u0438\u043d\u0435", 4216);
    freq.put("\u0438\u043d\u0430", 17378);
    freq.put("e ", 9458);
    freq.put("\u0438\u043d\u0433", 2575);
    freq.put("\u0421\u043e\u0444", 1291);
    freq.put("\u0430\u0434\u043e", 1154);
    freq.put("\u0430\u0434\u043d", 2853);
    freq.put("\u0430\u0434\u043c", 1400);
    freq.put("\u0430\u0434\u0438", 3451);
    freq.put("\u0430\u0434\u0435", 5585);
    freq.put("\u0434\u043c\u0438", 1636);
    freq.put("\u0430\u0434\u0430", 3119);
    freq.put("\u0438\u0448", 2457);
    freq.put("\u0438\u0449", 2902);
    freq.put("\u0438\u044f", 73064);
    freq.put("\u0438\u0442", 63592);
    freq.put("\u0438\u0446\u0435", 1072);
    freq.put("\u0438\u0440", 17875);
    freq.put("\u0438\u0441", 34276);
    freq.put("\u0438\u0446", 13361);
    freq.put("\u0438\u0447", 23215);
    freq.put("\u0438\u0444", 2446);
    freq.put("\u0438\u0445", 3360);
    freq.put("\u044e\u0442", 1002);
    freq.put("\u041f\u044a", 1179);
    freq.put("\u043e\u0441\u0432", 865);
    freq.put("\u0421 ", 937);
    freq.put("\u0438\u0442\u043e", 6371);
    freq.put("\u0438\u0442\u0438", 5468);
    freq.put("\u043e\u0441\u0435", 1009);
    freq.put("\u0438\u0442\u0435", 38859);
    freq.put("\u043e\u0441\u043b", 2267);
    freq.put("\u043e\u0441\u0438", 1734);
    freq.put("\u043e\u0441\u043e", 2118);
    freq.put("\u0438\u0442\u0430", 6132);
    freq.put("\u043e\u0441\u043c", 1054);
    freq.put("\u043e\u0441\u043d", 3443);
    freq.put("\u043f\u0435\u0442", 985);
    freq.put("\u043f\u0435\u0440", 6644);
    freq.put("\u043f\u0435\u0446", 914);
    freq.put("\u0431\u0438 ", 1015);
    freq.put("\u0436\u0435 ", 1283);
    freq.put("g", 5865);
    freq.put("\u043e\u0432 ", 8975);
    freq.put(" \u0412\u0435", 2397);
    freq.put("\u0442\u0443", 8218);
    freq.put("x ", 1094);
    freq.put("\u044a", 118638);
    freq.put("\u0443\u0433\u0430", 1360);
    freq.put("\u043f\u0435\u0438\u0306", 864);
    freq.put("\u043f\u0435\u043d", 871);
    freq.put("\u043e\u0434\u0438", 10451);
    freq.put("\u0420\u0443\u0441", 1292);
    freq.put("ia ", 930);
    freq.put("\u043e\u0441\u0442", 14287);
    freq.put("\u0432\u043d\u0430", 3375);
    freq.put("r", 22456);
    freq.put("\u0432\u043d\u0438", 3836);
    freq.put("\u0432\u043d\u043e", 2879);
    freq.put("\u0438\u0442\u0443", 932);
    freq.put("and", 809);
    freq.put(" \u0433\u043b", 1931);
    freq.put(" \u0433\u043e", 11993);
    freq.put("\u0438\u0306\u0442\u043e", 3630);
    freq.put("\u043c\u0438 ", 2984);
    freq.put("\u0447\u0430 ", 1350);
    freq.put(" \u0433\u0435", 2801);
    freq.put("\u0444\u0438\u0446", 1324);
    freq.put("\u0421\u0432\u0435", 1167);
    freq.put("2", 3527);
    freq.put("\u0435", 647345);
    freq.put("\u0431\u043e\u043b", 3321);
    freq.put("\u0431\u043e\u0440", 2442);
    freq.put("\u0438\u0430\u043d", 3297);
    freq.put("\u0431\u043e\u0442", 2082);
    freq.put("\u043f\u044a\u0440", 3460);
    freq.put("\u0440\u0434\u0438", 900);
    freq.put("\u0440\u0434\u0436", 839);
    freq.put("\u0440\u0434\u0430", 805);
    freq.put("\u0410\u0429 ", 2589);
    freq.put("\u043a\u0430 ", 28086);
    freq.put(" \u0433\u0440", 14818);
    freq.put("\u0438\u043a\u0430", 16650);
    freq.put("\u0438\u043a\u043d", 877);
    freq.put("\u0438\u043a\u043e", 3994);
    freq.put("\u0438\u043a\u0438", 1147);
    freq.put("\u0430\u0431\u0430", 833);
    freq.put("\u043a\u043e ", 8475);
    freq.put("\u044a\u0449", 3958);
    freq.put("\u044a\u0446", 2116);
    freq.put("\u044a\u0447", 1319);
    freq.put("\u044a\u0440", 28553);
    freq.put("\u044a\u0441", 7274);
    freq.put("\u0430\u0431\u043e", 2518);
    freq.put("\u0435\u0434 ", 5333);
    freq.put("\u0443\u043b\u0430", 1122);
    freq.put("\u043b\u0441\u043a", 2670);
    freq.put("\u043e\u0442\u0440", 1056);
    freq.put("\u0443\u043b\u0438", 1004);
    freq.put("\u043d\u0444", 1197);
    freq.put("\u043d\u0447", 1314);
    freq.put("\u043d\u0446", 6022);
    freq.put("\u043d\u0441", 29338);
    freq.put("\u043d\u0440", 827);
    freq.put("\u043d\u0443", 2379);
    freq.put("\u043d\u0442", 20098);
    freq.put("\u0432\u043e\u0442", 3890);
    freq.put("\u043d\u044f", 5762);
    freq.put("\u0432\u043e\u0440", 2694);
    freq.put("\u043d\u044a", 1330);
    freq.put("\u043d\u0435", 37699);
    freq.put("\u043d\u0434", 12141);
    freq.put("\u043d\u0437", 932);
    freq.put("\u043d\u0430", 206302);
    freq.put("\u043d\u0433", 9593);
    freq.put("\u043d\u043d", 7922);
    freq.put("H", 1934);
    freq.put("\u043d\u043e", 61747);
    freq.put("\u043d\u0438", 106631);
    freq.put("\u0432\u043e\u0435", 1398);
    freq.put("\u043d\u043a", 4229);
    freq.put("\u0421\u0442\u0430", 1292);
    freq.put("\u043b\u0441\u0442", 1405);
    freq.put("\u043e\u0442\u0438", 2542);
    freq.put("\u043e\u0442\u043e", 15284);
    freq.put("\u043e\u0442\u043d", 1748);
    freq.put("\u0443\u043b\u0442", 1584);
    freq.put("\u043e\u0442\u0432", 1153);
    freq.put("\u043e\u0442\u0431", 1366);
    freq.put("\u043e\u0442\u0430", 1480);
    freq.put("\u0421\u0442\u043e", 900);
    freq.put("\u044a\u043b\u0433", 11342);
    freq.put("\u044a\u043c", 3577);
    freq.put("\u044a\u043d", 6470);
    freq.put("\u044a\u043e", 998);
    freq.put("\u044a\u043f", 2106);
    freq.put("\u043b\u0435\u0434", 5662);
    freq.put("\u044a\u043a", 3158);
    freq.put("\u044a\u043b", 18163);
    freq.put("\u044a\u0434", 2915);
    freq.put("\u044a\u0435", 2628);
    freq.put("\u044a\u0436", 1821);
    freq.put("\u044a\u0437", 5682);
    freq.put("\u044a\u0431", 2128);
    freq.put("\u044a\u0432", 5386);
    freq.put("\u044a\u0433", 8535);
    freq.put("m2 ", 3381);
    freq.put("\u0436\u0434\u0443", 3122);
    freq.put("\u0434\u0435\u0442", 1508);
    freq.put("\u043e\u043d\u0442", 1752);
    freq.put("\u043e\u043d\u0441", 3193);
    freq.put("\u043e\u043d\u044f", 990);
    freq.put("\u041b", 9341);
    freq.put("\u0438\u043c ", 2180);
    freq.put(" \u043e\u043a", 9717);
    freq.put("\u043f\u044a\u0442", 1769);
    freq.put(" \u043e\u043f", 3022);
    freq.put("ul", 1045);
    freq.put(" \u043e\u0431", 13021);
    freq.put(" \u043e\u0434", 1340);
    freq.put(" \u043e\u0437", 981);
    freq.put(" \u0430\u0441", 835);
    freq.put(" \u0430\u0440", 2430);
    freq.put(" \u0430\u0432", 2928);
    freq.put(" \u0430\u0434", 1436);
    freq.put(" \u0430\u043b", 2238);
    freq.put(" \u0430\u043a", 2281);
    freq.put(" \u0430\u043f", 1113);
    freq.put("\u043f\u0438\u0441", 5195);
    freq.put(" \u0430\u043d", 5186);
    freq.put(" \u0430\u043c", 5117);
    freq.put(" \u043e\u0449", 1554);
    freq.put("\u043f\u0438\u0442", 1282);
    freq.put("\u0434\u0435\u0441", 1272);
    freq.put(" \u043e\u0441", 5533);
    freq.put(" \u043e\u0440", 4392);
    freq.put(" \u043e\u0442", 45416);
    freq.put(" \u043e\u0444", 1095);
    freq.put("\u043e\u043d\u0434", 803);
    freq.put("\u041e\u043a\u0440", 2063);
    freq.put("\u043e\u043d\u0430", 6297);
    freq.put("\u043e\u043d\u043e", 4114);
    freq.put("\u043e\u043d\u043d", 3311);
    freq.put("\u0440\u0438\u0438\u0306", 2243);
    freq.put("\u043e\u043d\u0438", 6360);
    freq.put("\u0436\u0434\u0430", 3366);
    freq.put("s", 19762);
    freq.put("\u0433 ", 21217);
    freq.put(" \u0422\u0440", 1782);
    freq.put("\u041f\u044a\u0440", 1058);
    freq.put(" \u0422\u044f", 1180);
    freq.put("\u0431\u0430\u043d", 1118);
    freq.put("\u0441\u044c\u043e", 1331);
    freq.put("\u0438\u0441 ", 2255);
    freq.put("\u041c\u0430\u043a", 3324);
    freq.put("\u043d\u043e\u043c", 2595);
    freq.put("\u0438\u0441\u044a", 1087);
    freq.put("\u0440\u0431\u0438", 1070);
    freq.put("\u043d\u043e\u0432", 10487);
    freq.put("\u043d\u043e\u0433", 2289);
    freq.put("\u043d\u043e\u0435", 844);
    freq.put("\u043f\u044a\u043b", 1566);
    freq.put("\u043e\u0447\u043d", 3093);
    freq.put("\u0434\u044a\u043b", 1733);
    freq.put("\u0434\u044a\u0440", 3663);
    freq.put("\u0446", 57885);
    freq.put("\u0444\u0438\u043d", 933);
    freq.put("\u043d\u043e\u0448", 880);
    freq.put("\u043c\u043f\u0430", 913);
    freq.put("\u043e\u043d\u0435", 3282);
    freq.put(" \u0432 ", 45152);
    freq.put("\u043c\u043f\u0435", 2702);
    freq.put("\u043d\u043e\u0440", 1012);
    freq.put("\u043d\u043e\u0441", 7389);
    freq.put("\u043c\u043f\u0438", 1340);
    freq.put("\u041c\u0435", 2505);
    freq.put("\u041c\u0430", 9260);
    freq.put("\u041c\u043e", 2461);
    freq.put("\u0432\u0438\u0435", 1422);
    freq.put("\u041c\u0438", 2960);
    freq.put("\u041c\u0430\u0440", 2452);
    freq.put(" \u0422\u0435", 2595);
    freq.put("\u0444\u0438\u0437", 1170);
    freq.put(" \u0422\u0430", 1620);
    freq.put("\u043e\u0433 ", 1478);
    freq.put(" \u0422\u043e", 5392);
    freq.put(" \u0422\u0438", 1162);
    freq.put("\u0437\u0434\u0430", 4154);
    freq.put("\u0440\u043e\u0438\u0306", 1470);
    freq.put("\u0443\u0446\u0438", 861);
    freq.put("\u0441\u0430\u0442", 1871);
    freq.put("\u0440\u043e\u043c", 2389);
    freq.put(" Ma", 1457);
    freq.put("\u0431", 87024);
    freq.put("\u0441\u0442\u0432", 16841);
    freq.put("\u0441\u0442\u0435", 8055);
    freq.put("\u043b\u044e\u0446", 3280);
    freq.put("I ", 2499);
    freq.put("\u0440\u0433 ", 1045);
    freq.put("\u0441\u0442\u043d", 3691);
    freq.put("\u0441\u0442\u043e", 10615);
    freq.put("\u0441\u0442\u0440", 11666);
    freq.put("\u0434\u043e", 23013);
    freq.put("\u0441\u0442\u0442", 2922);
    freq.put("\u0441\u0442\u0443", 903);
    freq.put(" \u0446\u0435", 3524);
    freq.put("I", 6368);
    freq.put("\u0441\u0442\u044a", 2246);
    freq.put("II", 1888);
    freq.put("\u0434\u043d", 14843);
    freq.put("\u0418\u0432\u0430", 1277);
    freq.put("\u0434\u043b", 987);
    freq.put("\u0441\u0430\u043c", 1827);
    freq.put("\u0441\u0430\u043d", 2444);
    freq.put("\u0434\u0436", 3808);
    freq.put("\u0435\u0435\u0446", 1133);
    freq.put(" \u041b\u0430", 1629);
    freq.put("\u0442\u0440", 27985);
    freq.put("\u0442\u0441", 3598);
    freq.put("\u0442\u0442", 3628);
    freq.put(" \u041b\u0435", 1707);
    freq.put(" \u041b\u0438", 1793);
    freq.put("\u0442\u044f", 2319);
    freq.put(" \u041b\u043e", 1496);
    freq.put("\u043b\u043e ", 7485);
    freq.put("\u044f\u043d", 5481);
    freq.put("\u043a\u044a\u043c", 1928);
    freq.put("\u044f\u043b", 2107);
    freq.put("\u044f\u043a", 3070);
    freq.put("\u0443\u043a\u0442", 810);
    freq.put("\u043d\u0435\u0441", 1561);
    freq.put("\u044f\u0434", 1101);
    freq.put("\u044f\u0433", 923);
    freq.put("\u044f\u0432", 7999);
    freq.put(" \u0422\u0443", 993);
    freq.put("\u0430\u0432\u0442", 1723);
    freq.put("\u0430\u0432\u044f", 1374);
    freq.put("\u0432\u0430\u0442", 9299);
    freq.put("\u0434\u0430\u0432", 2214);
    freq.put("\u0443\u0448\u0438", 3537);
    freq.put("\u0442\u0435 ", 30876);
    freq.put("\u0434\u0430\u043b", 1095);
    freq.put("\u0432\u0435 ", 3400);
    freq.put("\u0438\u043b\u0438", 12587);
    freq.put("\u0438\u043b\u043e", 3073);
    freq.put("\u0434\u0430\u0442", 3453);
    freq.put("\u0438\u043b\u043c", 2481);
    freq.put("\u0434\u0430\u0440", 1829);
    freq.put("\u0438\u043b\u0430", 2122);
    freq.put("\u0438\u043b\u0435", 1355);
    freq.put("\u0430\u0432\u0435", 2231);
    freq.put("\u0430\u0432\u0430", 11168);
    freq.put("\u0430\u0432\u043d", 2861);
    freq.put("\u0430\u0432\u043e", 1409);
    freq.put("\u044a\u0441\u0442", 3892);
    freq.put("\u0430\u0432\u0438", 4818);
    freq.put("\u0430\u0432\u043b", 2542);
    freq.put("ns", 1121);
    freq.put("\u044f\u0449", 989);
    freq.put("nt", 2097);
    freq.put("\u044f\u0445", 803);
    freq.put("\u044f\u0442", 23106);
    freq.put("\u044f\u0441", 1766);
    freq.put("\u044f\u0440", 1490);
    freq.put("\u0442\u0434", 804);
    freq.put("\u0442\u0435", 76446);
    freq.put("\u0442\u0430", 97852);
    freq.put("t", 17966);
    freq.put("\u0442\u0432", 20249);
    freq.put("\u0442\u043d", 10904);
    freq.put("\u0442\u043e", 91021);
    freq.put("\u0442\u0438", 47326);
    freq.put("\u0442\u043a", 3861);
    freq.put("\u0442\u043b", 2176);
    freq.put("\u0438\u0440\u0438", 1911);
    freq.put("\u0438\u0440\u043e", 1628);
    freq.put("\u0437\u0442\u043e", 3205);
    freq.put("\u0438 ", 202644);
    freq.put("\u0438\u0440\u0430", 10008);
    freq.put("\u0431\u0440\u0438", 1900);
    freq.put("\u0422\u044f ", 1123);
    freq.put(" \u043f\u044a", 4915);
    freq.put("\u0431\u0440\u043e", 1543);
    freq.put(" \u043f\u0443", 1035);
    freq.put(" \u043f\u0440", 44389);
    freq.put(" \u043f\u0441", 1741);
    freq.put("\u043b\u0430 ", 6130);
    freq.put("o ", 2327);
    freq.put("\u0437\u0432\u043e", 872);
    freq.put("\u0431\u0440\u0430", 3810);
    freq.put("\u0447", 69969);
    freq.put("\u0444\u0430\u043d", 1085);
    freq.put("\u0430\u0434 ", 8166);
    freq.put(" Co", 962);
    freq.put("\u0438\u043d ", 8393);
    freq.put(" \u043f\u043e", 33250);
    freq.put("on", 3740);
    freq.put("om", 1215);
    freq.put("ol", 1525);
    freq.put("\u043f\u043b\u0435", 1081);
    freq.put(" \u043f\u043b", 5058);
    freq.put(" \u043f\u0438", 3055);
    freq.put("km ", 885);
    freq.put("of", 927);
    freq.put(" \u043f\u0435", 4542);
    freq.put(" \u043f\u0430", 4088);
    freq.put("\u043f\u043b\u043e", 2643);
    freq.put("ou", 906);
    freq.put("ot", 815);
    freq.put("os", 1234);
    freq.put("or", 3049);
    freq.put(" \u0431\u0430", 2316);
    freq.put(" \u0431\u0435", 1826);
    freq.put(" \u0431\u0438", 3599);
    freq.put(" \u0431\u043b", 1708);
    freq.put(" \u0431\u043e", 2578);
    freq.put("\u0421\u0430", 2940);
    freq.put("\u043e\u0441 ", 1874);
    freq.put("\u0421\u0432", 1625);
    freq.put("\u0421\u0435", 4020);
    freq.put("\u0421\u0438", 2245);
    freq.put("\u0421\u043b", 1252);
    freq.put("\u0421\u043a", 946);
    freq.put("\u0438\u0442 ", 1689);
    freq.put("\u0421\u043f", 1322);
    freq.put("\u0421\u043e", 2387);
    freq.put("\u043e\u0432\u0438", 7840);
    freq.put("\u043e\u0432\u043e", 5297);
    freq.put("\u043e\u0432\u043d", 3952);
    freq.put("\u043e\u0432\u0430", 9654);
    freq.put("\u0430\u043d", 92124);
    freq.put("\u043e\u0432\u0435", 9903);
    freq.put("\u0431\u0438\u0432", 1415);
    freq.put("\u0421\u0410", 2694);
    freq.put("\u0432", 294348);
    freq.put("\u0431\u0438\u043a", 912);
    freq.put("\u0431\u0438\u043b", 1742);
    freq.put("\u0436\u0435\u043d", 7044);
    freq.put("\u042e\u0436", 1162);
    freq.put("\u0431\u0438\u0442", 1770);
    freq.put("\u0443\u043d", 6478);
    freq.put("\u0436\u0435\u0441", 1221);
    freq.put("J", 1261);
    freq.put("\u043e\u0432\u0441", 1386);
    freq.put("\u043e\u0449 ", 1985);
    freq.put("\u0440\u0432\u0435", 1684);
    freq.put("\u0421\u0440", 881);
    freq.put("\u0421\u0442", 4040);
    freq.put("\u043d\u043d\u0438", 2936);
    freq.put("\u0421\u044a", 4599);
    freq.put("\u043d\u043d\u0430", 3374);
    freq.put("\u043e\u043a\u043e", 5161);
    freq.put(" \u0431\u0440", 3218);
    freq.put("\u0412\u0435\u043b", 1059);
    freq.put(" \u0431\u0443", 1045);
    freq.put("he ", 1146);
    freq.put("\u0443\u0435", 1334);
    freq.put(" \u0431\u044a", 8445);
    freq.put("ac", 1396);
    freq.put("ae", 1227);
    freq.put("ad", 830);
    freq.put("ai", 928);
    freq.put("am", 1115);
    freq.put("al", 2739);
    freq.put("an", 4726);
    freq.put("\u0447\u0430\u043d", 1529);
    freq.put("as", 1457);
    freq.put("ar", 3743);
    freq.put("at", 2587);
    freq.put("\u0447\u0430\u043b", 1786);
    freq.put("\u043a\u0430\u0440", 2222);
    freq.put(" \u0433 ", 8207);
    freq.put("\u043a\u0430\u0442", 20763);
    freq.put("\u041d", 13530);
    freq.put("\u043c\u0438\u043a", 1065);
    freq.put("\u0447\u0430\u0432", 2550);
    freq.put("\u0437\u0430 ", 15694);
    freq.put("\u0446\u0438 ", 3879);
    freq.put("\u0446\u0435\u0440", 828);
    freq.put("\u0446\u0435\u0441", 947);
    freq.put("a ", 4950);
    freq.put("\u0446\u0435\u043d", 4575);
    freq.put("m", 12336);
    freq.put("\u0440\u043a ", 1201);
    freq.put("\u044a\u0440 ", 7548);
    freq.put("\u0438\u0300", 1026);
    freq.put("\u043c\u0438\u0447", 1772);
    freq.put("\u043a\u0430\u043b", 2533);
    freq.put("\u043a\u0430\u043a", 1566);
    freq.put("\u043a\u0430\u043d", 8113);
    freq.put("\u043c\u0438\u0442", 3385);
    freq.put("\u043c\u0438\u0441", 1421);
    freq.put("\u043c\u0438\u0440", 3990);
    freq.put("\u043c\u0438\u044f", 2187);
    freq.put("\u0434\u0440\u0430", 1827);
    freq.put("\u0447\u0430\u0441", 5618);
    freq.put("\u043a\u0430\u0437", 1398);
    freq.put("\u0435\u0440\u0442", 1057);
    freq.put("\u0435\u0449\u0430", 1146);
    freq.put("u", 15394);
    freq.put("\u0440\u0441\u0438", 1583);
    freq.put("\u0440\u0441\u043a", 11358);
    freq.put("\u0440\u0434 ", 1208);
    freq.put("\u043a\u043e\u0433", 1332);
    freq.put(" \u0435\u043f", 830);
    freq.put(" \u0435\u043a", 959);
    freq.put(" \u0435\u043b", 1747);
    freq.put(" \u0435\u0434", 7019);
    freq.put("\u0435\u043b\u043d", 4078);
    freq.put("\u041d\u0430\u043c", 821);
    freq.put(" \u0435\u0437", 2706);
    freq.put("\u0433\u0443\u0441", 909);
    freq.put(" \u0435\u0432", 904);
    freq.put("\u043f\u0441\u0438", 1481);
    freq.put("\u043e\u0436\u0435", 5313);
    freq.put("\u043e\u043c\u043f", 2499);
    freq.put("\u043e\u0436\u043d", 1229);
    freq.put("\u043d\u043e\u0442", 4382);
    freq.put("\u0445\u043d", 1728);
    freq.put(" \u0447\u0430", 4234);
    freq.put("tu", 1122);
    freq.put("tr", 962);
    freq.put("to", 1372);
    freq.put("th", 2095);
    freq.put("ti", 2705);
    freq.put("\u0438", 734943);
    freq.put("te", 2234);
    freq.put("ta", 1616);
    freq.put("\u0413\u043e", 1786);
    freq.put("\u0413\u0430", 1581);
    freq.put("\u0413\u0435", 2579);
    freq.put("\u0441\u0432\u0430", 1135);
    freq.put("\u043a\u043e\u043d", 4363);
    freq.put("ius", 2045);
    freq.put("\u043a\u043e\u043c", 4727);
    freq.put("\u0433\u0430\u0442", 2134);
    freq.put("is ", 934);
    freq.put("\u043a\u043d", 2476);
    freq.put("\u0444\u043e\u043d", 806);
    freq.put("ge", 970);
    freq.put("ri", 3533);
    freq.put("\u041d\u0430\u0441", 1183);
    freq.put("t ", 3334);
    freq.put("\u0430\u0441\u0430", 1041);
    freq.put("\u0441\u0435 ", 16807);
    freq.put("\u0430\u0441\u0435", 6138);
    freq.put("\u0430\u0441\u0438", 2434);
    freq.put("\u042e\u0436\u043d", 1054);
    freq.put("\u0435\u043b\u0438", 9768);
    freq.put("\u0440\u0442\u0430", 1478);
    freq.put("\u0430\u0441\u043e", 1029);
    freq.put("\u043b\u043e\u043d", 1406);
    freq.put("\u043a\u043c ", 856);
    freq.put("ter", 901);
    freq.put("\u0448\u0438\u043d", 804);
    freq.put("\u0442\u0430\u0440", 3238);
    freq.put("\u0423", 4389);
    freq.put(" \u0427\u0435", 1435);
    freq.put("\u0435\u0432 ", 3676);
    freq.put("\u0433\u0438\u0447", 1145);
    freq.put("\u0435\u043b\u0433", 908);
    freq.put("\u0420\u043e\u0434", 1271);
    freq.put("\u0433\u0438\u044f", 3508);
    freq.put("\u0430 ", 358572);
    freq.put(" \u0440\u0443", 1874);
    freq.put("\u0420\u0430\u0437", 1500);
    freq.put("K", 1010);
    freq.put("\u0442\u0430\u0432", 5484);
    freq.put("\u0442\u0430\u0438\u0306", 879);
    freq.put("\u0442\u0430\u043b", 3945);
    freq.put("\u0442\u0430\u043a", 1485);
    freq.put("\u0442\u0430\u043d", 6731);
    freq.put("\u0433\u0438\u043e", 1272);
    freq.put("\u0443\u0440\u043d", 1905);
    freq.put("\u0435\u0445\u043d", 1011);
    freq.put("\u0443\u0440\u0430", 2417);
    freq.put("\u0430\u0441\u0442", 14401);
    freq.put("\u0440\u0445\u0438", 885);
    freq.put("\u0428", 3131);
    freq.put("\u0430\u0441\u044f", 976);
    freq.put("\u044a\u043b\u0436", 1010);
    freq.put("\u0443\u0440\u0433", 1080);
    freq.put("\u0442\u0443\u0440", 4751);
    freq.put("\u043b\u0435\u0442", 2054);
    freq.put("\u043b\u0435\u0440", 878);
    freq.put("\u0441\u043b\u043e", 1460);
    freq.put("\u0441\u043b\u0430", 2258);
    freq.put("\u0441\u043b\u0435", 5451);
    freq.put("\u0435\u043e\u0440", 1928);
    freq.put("\u0438\u0306\u0441", 13136);
    freq.put("\u0438\u0432", 14438);
    freq.put("\u0438\u0306\u0442", 4652);
    freq.put("\u0437\u0432\u0438", 1188);
    freq.put("\u043e\u0440 ", 8928);
    freq.put("\u043d\u0438\u044f", 18624);
    freq.put("\u044e", 16520);
    freq.put("\u0438\u0306\u043b", 1354);
    freq.put("\u0438\u0306\u043a", 1995);
    freq.put("\u0438\u0306\u043d", 7255);
    freq.put("\u0438\u0306\u043c", 901);
    freq.put("\u0438\u0306\u043e", 1892);
    freq.put("\u0438\u0306\u0432", 1615);
    freq.put("\u0438\u0306\u0434", 1453);
    freq.put("\u0438\u043e ", 855);
    freq.put("\u0441\u043b\u0443", 1333);
    freq.put("\u0430\u043a\u0441", 811);
    freq.put("\u043b\u0435\u043d", 16713);
    freq.put("\u043b\u0435\u043c", 2731);
    freq.put("\u043b\u0435\u043a", 3978);
    freq.put("v", 3143);
    freq.put("\u043b\u0435\u0436", 946);
    freq.put("\u0430\u043a\u0442", 4848);
    freq.put("\u043b\u0435\u0432", 1784);
    freq.put("\u0430\u0437\u0432", 2060);
    freq.put("\u0430\u0437\u0430", 1484);
    freq.put("\u0430\u0437\u043e", 828);
    freq.put("\u0430\u0437\u043f", 4124);
    freq.put("\u0430\u0437\u043d", 1081);
    freq.put("\u0430\u0437\u043b", 1632);
    freq.put("\u0430\u0437\u0438", 2620);
    freq.put("f ", 974);
    freq.put("ati", 807);
    freq.put(" \u0412\u044a", 2363);
    freq.put("\u0430\u0449\u0438", 2202);
    freq.put("\u043e\u043b\u044e", 3412);
    freq.put("\u0438\u0306\u043d\u0430", 2642);
    freq.put(" \u041c\u043e", 2455);
    freq.put("\u0438\u0306", 56719);
    freq.put("\u0438\u0306\u043d\u0438", 1595);
    freq.put("\u0445\u0430\u0440", 1263);
    freq.put("\u0438\u0306\u043d\u043e", 1113);
    freq.put("\u043e\u0444\u0438", 2989);
    freq.put("\u0445\u0430\u043d", 805);
    freq.put("\u043e\u0444\u0435", 923);
    freq.put("\u03bd ", 1021);
    freq.put("a", 30637);
    freq.put("\u0449\u0430 ", 4581);
    freq.put(" \u0412\u0430", 2965);
    freq.put("\u0442\u044a\u0442", 942);
    freq.put(" \u0412\u043e", 966);
    freq.put(" \u0412\u0438", 2282);
    freq.put("\u0437\u0430\u0440", 1064);
    freq.put("\u0438\u0430\u043b", 3813);
    freq.put("\u0430\u0437\u0440", 1036);
    freq.put("y ", 2050);
    freq.put("\u0418\u0441", 1007);
    freq.put("\u0445\u043e\u0440", 974);
    freq.put("\u0441\u0442\u0430", 11874);
    freq.put("\u0424", 8267);
    freq.put("\u0432\u0438\u043b", 1146);
    freq.put("\u0432\u0438\u043d", 3278);
    freq.put("\u044a\u0435\u0434", 2623);
    freq.put("\u0438\u0445\u043e", 1462);
    freq.put("\u0440\u0435 ", 1433);
    freq.put("\u0432\u0438\u0434", 3578);
    freq.put("\u0432\u0438\u0437", 1513);
    freq.put("\u0432\u0438\u0436", 1141);
    freq.put("\u043f\u0440\u0435", 21619);
    freq.put("\u043f\u0440\u0430", 5058);
    freq.put("\u0432\u0438\u044f", 2762);
    freq.put("\u0432\u0438\u0441", 2864);
    freq.put("\u043f\u0440\u043e", 14907);
    freq.put("\u0432\u0438\u0442", 3903);
    freq.put("\u043f\u0440\u0438", 9598);
    freq.put("L", 2480);
    freq.put("\u0432\u0438\u0447", 1491);
    freq.put("\u0432\u0438\u0446", 847);
    freq.put("\u0441\u0442\u0438", 11129);
    freq.put("\u0430\u0440 ", 3643);
    freq.put("\u043e\u0437\u0430", 2042);
    freq.put("\u043b\u044e\u0447", 1984);
    freq.put("\u043e\u0437\u043d", 2520);
    freq.put("\u043e\u0437\u0438", 2118);
    freq.put("\u0433\u043b\u0435", 897);
    freq.put("\u0445\u043e\u0432", 933);
    freq.put("\u0445\u043e\u0434", 1906);
    freq.put("\u0445\u043e\u043b", 1095);
    freq.put("\u0418\u043c", 977);
    freq.put("\u0418\u043d", 1158);
    freq.put("\u0418\u0432", 1372);
    freq.put("\u0418\u0437", 2286);
    freq.put("\u0433\u043b\u0430", 2323);
    freq.put("\u0442\u0431\u043e", 3512);
    freq.put("\u043d\u0438\u043c", 1508);
    freq.put("\u043d\u0438\u043d", 2416);
    freq.put("\u043d\u0438\u043a", 6697);
    freq.put("\u0435\u043b\u0441", 1847);
    freq.put("\u043d\u0438\u0437", 3481);
    freq.put("\u043d\u0438\u0435", 16641);
    freq.put("\u043d\u0438\u0432", 1213);
    freq.put("\u043d\u0438\u0433", 977);
    freq.put("\u0434\u0440\u0435", 1806);
    freq.put("\u043a\u043e\u0442", 3860);
    freq.put("\u0435\u0446 ", 2918);
    freq.put("\u0434\u0440\u043e", 826);
    freq.put("\u0434\u0440\u0438", 2347);
    freq.put("\u0432\u0440\u0438", 3322);
    freq.put(" \u0436\u0435", 950);
    freq.put("\u0430\u0442\u0440", 1084);
    freq.put("\u0430\u0442\u0443", 1909);
    freq.put(" \u0436\u0438", 3991);
    freq.put("\u0430\u0442\u0435", 8423);
    freq.put("\u0430\u0442\u0430", 47391);
    freq.put("\u0438\u043b\u043d", 880);
    freq.put("\u0430\u0442\u043e", 12657);
    freq.put("\u0430\u0442\u0438", 9387);
    freq.put("\u044f", 119927);
    freq.put("\u0434\u0440\u0443", 2364);
    freq.put("\u043c\u0435 ", 3219);
    freq.put("\u041f\u0440\u0435", 1768);
    freq.put("\u043d\u0438\u0446", 3898);
    freq.put("\u043d\u0438\u0447", 2172);
    freq.put("\u041f\u0440\u043e", 1122);
    freq.put(" \u0428\u0430", 822);
    freq.put("\u041f\u0440\u0438", 1038);
    freq.put("\u043d\u0438\u0440", 1151);
    freq.put("\u043d\u0438\u0441", 3663);
    freq.put("w", 2350);
    freq.put("\u043e\u0438", 10610);
    freq.put("\u043e\u0438\u0306", 13778);
    freq.put("\u043e\u043a", 20081);
    freq.put("\u043e\u043b", 46187);
    freq.put("\u043e\u043c", 18413);
    freq.put("\u043e\u043d", 40545);
    freq.put("\u043e\u043e", 918);
    freq.put("\u043e\u043f", 12711);
    freq.put("\u043e\u0430", 1786);
    freq.put("\u043e\u0431", 22311);
    freq.put("\u043e\u0432", 49786);
    freq.put("\u043e\u0433", 14314);
    freq.put("\u043e\u0434", 35825);
    freq.put("\u043e\u0435", 7078);
    freq.put("\u043e\u0436", 8402);
    freq.put("\u043e\u0437", 8385);
    freq.put("\u0431\u0441", 2154);
    freq.put("\u0431\u0440", 9346);
    freq.put("\u0431\u0443", 4434);
    freq.put("\u043a\u0441 ", 1165);
    freq.put("\u0431\u0449", 5858);
    freq.put("\u0431\u044a", 10139);
    freq.put("\u0433\u043b\u0438", 4051);
    freq.put("\u0431\u044f", 950);
    freq.put("\u0440\u0446\u0438", 1577);
    freq.put("\u043a\u043b\u044e", 1993);
    freq.put("\u043a", 273267);
    freq.put("\u043a\u043b\u043e", 1049);
    freq.put("\u0434\u043e ", 6155);
    freq.put("\u043a\u043b\u0430", 1490);
    freq.put("\u0441\u043a\u0438", 43899);
    freq.put("\u0443\u0441\u0438", 1038);
    freq.put("\u0441\u043a\u043e", 7743);
    freq.put("\u0441\u043a\u0430", 20500);
    freq.put("\u0431\u0430", 6691);
    freq.put("b", 4459);
    freq.put("\u0431\u0435", 7947);
    freq.put("\u0431\u0438", 11046);
    freq.put("\u0431\u043b", 10831);
    freq.put(" e ", 1798);
    freq.put("\u0431\u043e", 12574);
    freq.put("\u043e\u0448", 1648);
    freq.put("\u043e\u0449", 6422);
    freq.put("\u0437\u0432\u0435", 5171);
    freq.put("\u0437\u0432\u0430", 3840);
    freq.put("\u043e\u044f", 7068);
    freq.put("\u043e\u0440", 52184);
    freq.put("\u043e\u0441", 31400);
    freq.put("\u043e\u0442", 71852);
    freq.put("\u043e\u0443", 1691);
    freq.put("\u043e\u0444", 5618);
    freq.put("\u043e\u0445", 1705);
    freq.put("\u043e\u0446", 2874);
    freq.put("\u043e\u0447", 6409);
    freq.put("\u0435\u0436\u0438", 2367);
    freq.put("\u0434\u043d\u0430", 5206);
    freq.put("\u0435\u043d\u0435", 4173);
    freq.put("\u0435\u043d\u0434", 1760);
    freq.put("\u0435\u043d\u0430", 10075);
    freq.put("\u0435\u043d\u043d", 2947);
    freq.put("\u0435\u043d\u043e", 7268);
    freq.put("\u0435\u043d\u0438", 27128);
    freq.put("\u0434\u0438\u044f", 1914);
    freq.put("\u0442\u0440\u0430", 10350);
    freq.put("k ", 904);
    freq.put("\u0425", 7715);
    freq.put("\u0438\u043f ", 824);
    freq.put("\u0443\u0430\u0440", 1716);
    freq.put("\u0434\u0438\u0446", 1640);
    freq.put("\u0443\u043f\u0430", 3307);
    freq.put("\u0434\u0438\u0442", 1804);
    freq.put("\u0434\u0438\u0441", 974);
    freq.put("\u0442\u0440\u043e", 5709);
    freq.put("2 ", 3527);
    freq.put("\u0434 ", 24331);
    freq.put("\u0421\u0430\u043d", 921);
    freq.put("M", 3950);
    freq.put("\u0434\u0438\u043e", 936);
    freq.put("\u0434\u0438\u043d", 15737);
    freq.put("\u0434\u0438\u043c", 1128);
    freq.put("\u0434\u0438\u0435", 842);
    freq.put("\u0434\u0438\u0432", 1005);
    freq.put("\u0435\u043d\u0446", 1053);
    freq.put("\u0435\u043d\u0441", 4280);
    freq.put("\u0435\u043d\u0442", 10211);
    freq.put("\u0443\u043d\u0438", 1783);
    freq.put("km", 4286);
    freq.put("\u0447\u0432\u0430", 2149);
    freq.put("\u0440\u0443\u0441", 2190);
    freq.put("\u0442\u0432\u044a", 860);
    freq.put("\u0443\u0447\u0430", 2759);
    freq.put("\u041f\u0430\u0440", 949);
    freq.put("\u0443\u043d\u0430", 1368);
    freq.put(" \u0435 ", 70638);
    freq.put("\u0438\u0432\u0448", 976);
    freq.put("\u041d\u0435", 1875);
    freq.put("\u0420", 16110);
    freq.put("\u041d\u0430", 5278);
    freq.put("\u0443\u0447\u0435", 1377);
    freq.put("\u041d\u043e", 2049);
    freq.put("\u041d\u0438", 2119);
    freq.put("\u044f\u0432\u0430", 6515);
    freq.put(" \u0425\u043e", 1079);
    freq.put(" \u0425\u0435", 1290);
    freq.put("\u043b\u043d\u0438", 5607);
    freq.put(" \u0425\u0430", 2307);
    freq.put("\u044f\u043c\u0430", 1227);
    freq.put(" \u0425\u0440", 970);
    freq.put("\u0411\u044a\u043b", 3319);
    freq.put("\u0442\u044a", 10928);
    freq.put("\u0440\u0432\u0430", 2274);
    freq.put("\u0442\u0432\u043e", 9227);
    freq.put("\u0442\u0432\u0438", 1621);
    freq.put("\u0442\u0432\u0435", 3786);
    freq.put("\u0442\u0432\u0430", 3607);
    freq.put("\u044f\u043c", 2556);
    freq.put("\u0440\u0443\u043f", 3391);
    freq.put("\u0440\u0443\u043c", 975);
    freq.put("x", 1681);
    freq.put("\u0430\u044f ", 1362);
    freq.put("\u0443\u0433\u0438", 1696);
    freq.put("\u0448\u0438 ", 3970);
    freq.put(" \u0449\u0430", 6448);
    freq.put("\u0431\u043d", 1672);
    freq.put("\u0430\u0441 ", 2329);
    freq.put("\u0441\u0435\u0432", 2490);
    freq.put("\u0441\u0435\u0434", 1178);
    freq.put("\u0441\u0435\u043b", 9974);
    freq.put("\u0441\u0435\u043a", 1165);
    freq.put("\u0441\u0435\u043d", 2491);
    freq.put("\u0441\u0435\u043c", 2208);
    freq.put("\u0441\u0435\u043f", 870);
    freq.put("\u0430\u0432", 32263);
    freq.put("\u0430\u0433", 6621);
    freq.put("\u0430\u0431", 6725);
    freq.put("\u0430\u0436", 2734);
    freq.put("\u0430\u0437", 20177);
    freq.put("\u0430\u0434", 29187);
    freq.put("\u0430\u0435", 3072);
    freq.put("\u0430\u043a", 18833);
    freq.put("\u0430\u043b", 43351);
    freq.put("\u0430\u0438", 1848);
    freq.put("\u0430\u0438\u0306", 16768);
    freq.put("\u0430\u043f", 10532);
    freq.put("\u0430\u043c", 19866);
    freq.put("\u041c", 19622);
    freq.put("\u0435\u0432\u0435", 5028);
    freq.put("\u0432\u0440\u0435", 3504);
    freq.put(" \u041e\u0441", 2127);
    freq.put(" \u041e\u0440", 1245);
    freq.put("\u0435\u0432\u043e", 4583);
    freq.put(" \u041e\u0442", 1080);
    freq.put("\u0435\u0432\u0438", 2758);
    freq.put("\u0432\u0440\u043e", 1874);
    freq.put("\u0433\u0438 ", 2787);
    freq.put("\u0442\u0430 ", 68838);
    freq.put(" \u041e\u043a", 2446);
    freq.put("\u0435\u0432\u0440", 1969);
    freq.put(" \u041e\u043f", 1048);
    freq.put(" \u041e\u0431", 2206);
    freq.put("\u0432\u0440\u044a", 1065);
    freq.put("\u0430\u0442", 95702);
    freq.put("\u0430\u0443", 3593);
    freq.put("\u0430\u0440", 52528);
    freq.put("\u0430\u0441", 30917);
    freq.put("\u0430\u0446", 9711);
    freq.put("\u0430\u0447", 7356);
    freq.put("\u0430\u0444", 3137);
    freq.put("\u0430\u0445", 2622);
    freq.put("\u0413\u0440\u0430", 1071);
    freq.put("\u0430\u0448", 2543);
    freq.put("\u0430\u0449", 6812);
    freq.put("\u0430\u044f", 1940);
    freq.put("\u0440\u0442 ", 2255);
    freq.put("\u0441\u0435\u0440", 1205);
    freq.put("c", 9844);
    freq.put("\u0441\u0435\u0442", 920);
    freq.put("\u0432\u044f\u0432", 1024);
    freq.put("\u043e\u0440\u043e", 2299);
    freq.put("\u043b\u0433\u0430", 11038);
    freq.put("\u043b\u0433\u0438", 963);
    freq.put("\u0430\u0435\u043c", 863);
    freq.put(" \u0410\u0442", 830);
    freq.put(" \u0410\u0440", 1714);
    freq.put("\u0434\u043d\u0435", 986);
    freq.put("\u043e\u0440\u0434", 1685);
    freq.put("\u0434\u043d\u0438", 3855);
    freq.put("\u0434\u043d\u043e", 4679);
    freq.put("\u0433\u0435\u043d", 2209);
    freq.put("\u0410\u043d\u0442", 866);
    freq.put("\u0434\u0430\u0434", 3266);
    freq.put("pe", 805);
    freq.put("\u043e\u0446\u0435", 1219);
    freq.put("\u0438\u0306 ", 18686);
    freq.put("\u044a\u0437\u0434", 2638);
    freq.put("N", 1781);
    freq.put(" th", 1043);
    freq.put("\u0436\u0438 ", 1063);
    freq.put("\u0434\u0430\u043d", 2923);
    freq.put(" \u0410\u0432", 1297);
    freq.put(" \u0410\u043b", 2947);
    freq.put(" \u0410\u043d", 3448);
    freq.put(" \u0410\u043c", 1038);
    freq.put(" \u0413\u0440", 2287);
    freq.put("\u0438\u043e\u0434", 1232);
    freq.put("\u0438\u043e\u043d", 10338);
    freq.put("\u0449\u0430\u0442", 7215);
    freq.put("\u0436\u0438\u0441", 1541);
    freq.put("\u043d\u0442\u0435", 1868);
    freq.put("\u0421", 33637);
    freq.put("\u0438\u0306\u043d ", 1098);
    freq.put("\u043e\u0431\u0440", 3456);
    freq.put("\u0422\u0440", 1786);
    freq.put("\u0422\u0443", 994);
    freq.put("\u044a\u0440\u0445", 1303);
    freq.put("\u0422\u044f", 1180);
    freq.put("\u0431\u044a\u043b", 7641);
    freq.put(" \u0434\u044a", 3603);
    freq.put(" \u0434\u0443", 4688);
    freq.put(" \u0434\u0440", 4782);
    freq.put(" \u0434\u043e", 9466);
    freq.put(" \u0434\u043d", 1385);
    freq.put(" \u0434\u0438", 3107);
    freq.put("\u0431\u044a\u0440", 1419);
    freq.put(" \u0434\u0435", 7755);
    freq.put(" \u0434\u0432", 3064);
    freq.put(" \u0434\u0430", 7239);
    freq.put("\u0422\u0435", 2600);
    freq.put("\u0422\u0430", 1626);
    freq.put("\u043e\u0431\u0435", 2463);
    freq.put("\u043e\u0431\u043b", 3221);
    freq.put("\u0422\u043e", 5455);
    freq.put("\u0422\u0438", 1166);
    freq.put("\u043e\u0431\u043d", 833);
    freq.put("\u0442\u0435\u043d", 6993);
    freq.put(" \u0412 ", 2161);
    freq.put("\u0442\u0440\u0438", 4952);
    freq.put("y", 4095);
    freq.put("\u0436\u0438\u0432", 1957);
    freq.put("\u0442\u0438\u0442", 2981);
    freq.put("\u043d\u043a\u0430", 817);
    freq.put("\u043d\u043a\u043e", 832);
    freq.put("\u0440\u0435\u043c", 3987);
    freq.put("\u0440\u0435\u043d", 6538);
    freq.put("\u0440\u0435\u043f", 1732);
    freq.put("\u0440\u0435\u0438\u0306", 892);
    freq.put("\u0440\u0435\u043a", 2832);
    freq.put("\u0440\u0435\u043b", 1209);
    freq.put("\u0440\u0435\u0434", 14324);
    freq.put("\u0432\u0438 ", 4285);
    freq.put("\u0440\u0435\u0436", 2438);
    freq.put("\u0440\u0435\u0437", 11468);
    freq.put("\u0440\u0435\u0431", 1455);
    freq.put("\u0440\u0435\u0432", 6384);
    freq.put("\u0440\u0435\u0433", 1970);
    freq.put("\u0433\u0440\u0438", 1115);
    freq.put("\u0430\u0440\u0442", 4677);
    freq.put("\u0430\u0440\u0441", 9548);
    freq.put(" \u0447\u043e", 1060);
    freq.put("\u03b9", 1833);
    freq.put("\u0448\u0435\u043d", 1940);
    freq.put("\u0433\u0440\u044a", 1949);
    freq.put("\u0430\u0440\u0430", 4896);
    freq.put("\u0447\u043d\u043e", 3174);
    freq.put("\u0430\u0440\u0435", 2062);
    freq.put("\u0435\u043c", 23126);
    freq.put("\u0430\u0440\u043b", 1170);
    freq.put("\u0430\u0440\u043a", 1896);
    freq.put("\u0430\u0440\u0438", 12961);
    freq.put("\u044c", 4950);
    freq.put("\u0430\u0440\u043d", 1173);
    freq.put("\u0430\u0440\u043c", 1084);
    freq.put("\u0440\u0435\u0448", 2153);
    freq.put("\u0440\u0435\u0449", 1470);
    freq.put("\u0440\u0435\u0447", 1092);
    freq.put("\u0440\u0435\u0441", 2290);
    freq.put("\u0440\u0435\u0442", 1976);
    freq.put(" \u0426\u0435", 1509);
    freq.put("d", 9193);
    freq.put("\u0435\u043a", 18670);
    freq.put("\u0435\u0434", 43311);
    freq.put("\u0435\u0437", 20414);
    freq.put("\u043c\u0435\u0440", 7582);
    freq.put("\u043c\u0435\u0441", 1879);
    freq.put("\u043c\u0435\u0442", 5373);
    freq.put("\u0437\u0430\u043f", 3505);
    freq.put("b ", 891);
    freq.put("\u0446\u0438\u0438", 1846);
    freq.put("\u0437\u0430\u0435", 830);
    freq.put("\u0446\u0438\u0430", 2597);
    freq.put("\u043d\u0438 ", 29732);
    freq.put("\u043a\u044a\u0441", 900);
    freq.put("\u0435\u0432", 22477);
    freq.put(" \u041b\u0443", 1447);
    freq.put("\u0435\u0446\u0438", 1425);
    freq.put("\u0437", 132692);
    freq.put("\u0441\u0446\u0435", 1326);
    freq.put("\u0442\u0431", 3928);
    freq.put("\u043a\u043d\u0438", 998);
    freq.put("O", 1368);
    freq.put("\u0430\u0442 ", 10948);
    freq.put("\u03c2 ", 1819);
    freq.put("\u043d\u0446\u0435", 866);
    freq.put("\u043d\u0446\u0438", 4501);
    freq.put("\u0442\u0440\u0443", 1929);
    freq.put("\u0446\u0438\u044f", 11555);
    freq.put("\u043c\u0435\u0434", 1422);
    freq.put("\u0437\u0430\u0449", 954);
    freq.put("\u043c\u0435\u0436", 2783);
    freq.put("\u043c\u0435\u0438\u0306", 1790);
    freq.put("\u0437\u0430\u0446", 2538);
    freq.put("\u0432\u0441\u043a", 2447);
    freq.put("\u043c\u0435\u043d", 8396);
    freq.put("\u0432\u0441\u0438", 896);
    freq.put("\u0446\u0438\u0442", 1550);
    freq.put(" \u041f\u043e", 4518);
    freq.put("\u0438\u0306\u043e\u043d", 1165);
    freq.put("\u043a\u0446\u0438", 1405);
    freq.put(" \u041f\u043b", 3222);
    freq.put(" \u041f\u0438", 1267);
    freq.put(" \u041f\u0435", 2739);
    freq.put(" \u041f\u0430", 3238);
    freq.put("\u043e ", 136170);
    freq.put("\u0435\u043f\u043e", 1006);
    freq.put("\u0422", 16259);
    freq.put("\u0434\u043e\u0441", 1220);
    freq.put("\u0434\u043e\u0440", 1353);
    freq.put("\u0438\u0437\u0441", 1113);
    freq.put("\u041a\u0430\u0440", 1717);
    freq.put("\u0442\u0442\u0430", 3294);
    freq.put("\u041a\u0430\u043b", 1241);
    freq.put("\u0430\u0436\u0434", 973);
    freq.put(" Ca", 925);
    freq.put("\u0445\u0438", 3810);
    freq.put("\u0434\u043e\u0431", 1818);
    freq.put("\u0434\u043e\u0432", 2389);
    freq.put("\u0434\u043e\u043d", 5500);
    freq.put("\u0438\u0434\u0435", 2406);
    freq.put("\u0437\u0430\u0432", 1648);
    freq.put("\u0434\u043e\u043a", 903);
    freq.put("\u0435\u043f\u0443", 3069);
    freq.put("\u0435\u043f\u0442", 1100);
    freq.put("us", 5560);
    freq.put("ur", 1295);
    freq.put("um", 1527);
    freq.put("\u0431 ", 1391);
    freq.put("un", 918);
    freq.put(" \u041f\u044a", 1174);
    freq.put("z", 1439);
    freq.put(" \u041f\u0440", 4415);
    freq.put("\u0427\u0435", 1438);
    freq.put("\u0435\u043d ", 33180);
    freq.put("\u044a\u0434\u0435", 1407);
    freq.put("\u041a ", 979);
    freq.put("\u0432\u043b\u044f", 1602);
    freq.put("\u043e\u0447\u0438", 922);
    freq.put("\u041f\u043e\u043b", 1310);
    freq.put("Th", 962);
    freq.put("\u044a\u0440\u0436", 2771);
    freq.put(" \u0411\u0430", 2734);
    freq.put("\u0434\u043f", 805);
    freq.put("\u0434\u043c", 2251);
    freq.put("\u0414\u0436\u043e", 1453);
    freq.put("\u0434\u043a", 815);
    freq.put(" \u0411\u0435", 2781);
    freq.put("\u0434\u0438", 35808);
    freq.put(" \u0411\u0438", 1492);
    freq.put("\u0434\u0435", 31362);
    freq.put("\u0434\u0432", 5622);
    freq.put(" \u0411\u043e", 2714);
    freq.put(" \u0432\u043e", 6415);
    freq.put("\u0434\u0438 ", 4057);
    freq.put(" \u0411\u0440", 1924);
    freq.put("\u0434\u044f", 1235);
    freq.put(" \u0411\u0443", 1133);
    freq.put("\u0434\u044a", 7215);
    freq.put("\u041e\u043f\u0435", 874);
    freq.put(" \u0411\u044a", 3733);
    freq.put("\u0434\u0443", 10303);
    freq.put("\u0434\u0440", 9809);
    freq.put("\u0434\u0441", 7551);
    freq.put("e", 32549);
    freq.put("\u041a\u043e\u043b", 892);
    freq.put("\u041a\u043e\u043d", 1216);
    freq.put("\u0432\u043b\u0435", 1219);
    freq.put("\u0432\u043b\u0430", 1152);
    freq.put("\u0431\u0449\u0438", 2449);
    freq.put("\u0431\u0449\u0435", 1011);
    freq.put("\u0438\u0444\u043e", 843);
    freq.put("\u0432\u043b\u0438", 1041);
    freq.put("\u0431\u0449\u0430", 1581);
    freq.put(" a", 954);
    freq.put(" d", 1024);
    freq.put(" e", 2141);
    freq.put(" k", 4461);
    freq.put(" o", 1042);
    freq.put("\u043a\u043c", 1179);
    freq.put(" s", 806);
    freq.put(" p", 1297);
    freq.put("\u043a\u0438", 58354);
    freq.put(" t", 1519);
    freq.put("\u043a\u043b", 6420);
    freq.put("\u043a\u0435", 7674);
    freq.put("\u0435\u043b\u0435", 11585);
    freq.put("\u043a\u0430", 68697);
    freq.put("\u043a\u0432", 3364);
    freq.put("\u0435\u043b\u0430", 1732);
    freq.put(" B", 2694);
    freq.put(" C", 3884);
    freq.put(" A", 3726);
    freq.put(" F", 2034);
    freq.put(" G", 2045);
    freq.put(" D", 2259);
    freq.put(" E", 1564);
    freq.put(" J", 1196);
    freq.put(" K", 898);
    freq.put(" H", 1769);
    freq.put(" I", 3444);
    freq.put(" N", 1367);
    freq.put(" O", 956);
    freq.put(" L", 2204);
    freq.put(" M", 3517);
    freq.put(" R", 2038);
    freq.put(" S", 4264);
    freq.put(" P", 3303);
    freq.put(" V", 1365);
    freq.put(" W", 1432);
    freq.put(" T", 2518);
    freq.put(" \u044e\u0433", 1007);
    freq.put("\u03bd", 2280);
    freq.put(" \u044e\u0436", 900);
    freq.put("\u0443\u0432\u0430", 2742);
    freq.put("\u0430\u043a\u043e", 1531);
    freq.put("\u0430\u043a\u0438", 1127);
    freq.put("\u0430\u043a\u0435", 4784);
    freq.put("\u0449\u043e ", 2387);
    freq.put("\u0430\u043a\u0430", 2207);
    freq.put("P", 3771);
    freq.put(" \u0440\u0430", 14338);
    freq.put(" \u0440\u0435", 11569);
    freq.put("g ", 1075);
    freq.put("\u0443\u0440\u0441", 982);
    freq.put(" \u0440\u0438", 1504);
    freq.put("an ", 963);
    freq.put(" \u0440\u043e", 5884);
    freq.put("\u0435\u043b\u044f", 2163);
    freq.put("\u043a\u044a", 5642);
    freq.put("\u044a\u0432 ", 2817);
    freq.put("\u043a\u0446", 1433);
    freq.put("us ", 4874);
    freq.put("\u043a\u0440", 18141);
    freq.put("\u043a\u0441", 6288);
    freq.put("\u043a\u0442", 11901);
    freq.put("\u043a\u0443", 5862);
    freq.put("\u043a\u0442\u0435", 804);
    freq.put("\u0438\u0306\u0432\u043e", 1025);
    freq.put("\u043a\u0442\u043e", 3328);
    freq.put("\u043a\u0442\u0438", 2426);
    freq.put("\u0440\u0442", 9867);
    freq.put("\u0440\u0443", 13758);
    freq.put("\u0440\u0441", 15501);
    freq.put("\u0440\u0446", 2298);
    freq.put("\u0440\u0445", 2778);
    freq.put("\u0440\u044a", 16028);
    freq.put("\u043e\u0434 ", 4250);
    freq.put("\u0440\u0448", 1570);
    freq.put("\u0440\u044f", 3303);
    freq.put("\u0413", 11598);
    freq.put("\u0438\u0433\u0430", 2136);
    freq.put(" \u0415\u043b", 962);
    freq.put(" \u0415\u0434", 825);
    freq.put("\u0449\u0435 ", 3484);
    freq.put("\u0438\u0433\u0438", 1169);
    freq.put("\u0438\u0433\u043e", 824);
    freq.put(" \u0415\u0432", 1550);
    freq.put("\u0412\u044a\u0442", 1318);
    freq.put("\u043f\u0442\u0435", 935);
    freq.put("\u0431\u0430 ", 1349);
    freq.put("\u0440\u0438 ", 13979);
    freq.put("\u0447\u0435\u0441", 8800);
    freq.put("\u0438\u0433\u0440", 2806);
    freq.put("\u0447\u0435\u0440", 977);
    freq.put("\u0442\u0440\u0435", 4236);
    freq.put("\u044a\u043b\u043d", 1684);
    freq.put("\u0440\u0432", 7403);
    freq.put("\u0440\u0433", 7600);
    freq.put("\u0440\u0430", 98873);
    freq.put("\u0440\u0431", 2434);
    freq.put("\u0440\u0436", 3084);
    freq.put("\u0440\u0437", 1336);
    freq.put("\u0440\u0434", 5085);
    freq.put("\u0440\u0435", 68474);
    freq.put("\u0440\u043a", 5043);
    freq.put("\u0440\u043b", 2965);
    freq.put("\u0440\u0438", 74729);
    freq.put("\u0440\u043e", 46663);
    freq.put("\u0440\u043f", 941);
    freq.put("\u0440\u043c", 7553);
    freq.put("\u0440\u043d", 12220);
    freq.put("\u0436 ", 1730);
    freq.put("\u0435\u0440\u0435", 1937);
    freq.put("\u0431\u0443\u043a", 823);
    freq.put("\u0431\u0443\u043c", 1554);
    freq.put("\u0432\u0435\u043a", 3636);
    freq.put("\u0432\u0435\u043b", 1221);
    freq.put("\u0435\u0440\u0430", 7049);
    freq.put("\u0434\u0443\u0448", 3708);
    freq.put("\u0432\u0435\u043d", 9985);
    freq.put("\u0432\u0435\u0436", 1619);
    freq.put("\u0432\u0435\u0434", 2219);
    freq.put("\u0436\u043d\u043e", 1097);
    freq.put("\u043e\u043a ", 2212);
    freq.put("\u0436\u043d\u0438", 1433);
    freq.put("\u0434\u0430", 30493);
    freq.put("\u0443 ", 10195);
    freq.put("\u0436\u043d\u0430", 1550);
    freq.put("\u043e\u0449\u0435", 1644);
    freq.put("\u0418\u0306\u043e", 1544);
    freq.put("\u043e", 637033);
    freq.put("\u043e\u0448\u0435", 916);
    freq.put("\u043f\u043b\u0430", 2637);
    freq.put("\u0442\u043e ", 53757);
    freq.put("\u0448\u0438", 6517);
    freq.put("\u043e\u0449\u0442", 2295);
    freq.put("\u0440\u043a\u0430", 815);
    freq.put("\u043d\u0435 ", 9731);
    freq.put("f", 3146);
    freq.put("\u0432\u0435\u0442", 7499);
    freq.put("\u0432\u0435\u0440", 5871);
    freq.put("\u0432\u0435\u0441", 4369);
    freq.put("\u0432\u0435\u0447", 1347);
    freq.put("\u0447\u0438\u0442", 1626);
    freq.put("\u0440", 442208);
    freq.put("\u043c\u0443\u0437", 1721);
    freq.put("\u043c\u0443\u043d", 847);
    freq.put("\u0435\u0441\u0442", 15331);
    freq.put("\u0429", 2903);
    freq.put("\u043c\u0430 ", 9888);
    freq.put("\u043e\u0438\u0437", 4705);
    freq.put("\u043f\u044a", 7097);
    freq.put("\u043f\u0443", 5784);
    freq.put("\u03bc", 1054);
    freq.put("\u043f\u0441", 2576);
    freq.put("\u043f\u0440", 53247);
    freq.put("\u043f\u043e", 49161);
    freq.put("\u043f\u043b", 7108);
    freq.put("\u043f\u0438", 12418);
    freq.put("\u043f\u0435", 14376);
    freq.put("es ", 1352);
    freq.put("\u043f\u0430", 18259);
    freq.put("\u043a\u0438 ", 42277);
    freq.put("\u0435\u0441\u043a", 7153);
    freq.put("\u0435\u0441\u043d", 1000);
    freq.put("\u0435\u0441\u0430", 875);
    freq.put("\u0435\u0441\u0435", 2292);
    freq.put("\u043d\u0433\u043b", 4272);
    freq.put("\u0447\u0438\u043d", 1845);
    freq.put("\u0443\u0441 ", 1180);
    freq.put("\u043d\u0433\u0430", 993);
    freq.put("\u0421\u0421", 822);
    freq.put("\u0441\u043f\u0435", 2031);
    freq.put("\u0441\u043f\u0430", 1513);
    freq.put("\u0441\u043f\u043e", 2745);
    freq.put("\u0441\u043f\u0438", 822);
    freq.put("\u0414", 15403);
    freq.put("\u0435\u043c\u0435", 6592);
    freq.put("\u0430\u0438\u0306 ", 7880);
    freq.put("\u043d\u0441\u043a", 22095);
    freq.put("\u0432\u0434", 1142);
    freq.put("\u0432\u0435", 44922);
    freq.put("le", 2314);
    freq.put("\u0432\u0430", 58204);
    freq.put("\u0432\u044a\u0432", 2376);
    freq.put("la", 2281);
    freq.put("lo", 1036);
    freq.put("ll", 2061);
    freq.put("\u0432\u0438", 31125);
    freq.put("\u0435\u043a\u0441", 3530);
    freq.put("\u0432\u043a", 2396);
    freq.put("li", 2736);
    freq.put("\u0437\u043f\u043e", 5089);
    freq.put("\u044f\u043a\u043e", 2322);
    freq.put("\u0437\u043f\u044a", 815);
    freq.put("\u0437\u043f\u0440", 1401);
    freq.put("\u043c\u0432\u0440", 3060);
    freq.put("\u0435\u043a\u043e", 1156);
    freq.put("\u0432\u0440", 11007);
    freq.put("\u0432\u0441", 5682);
    freq.put("\u0432\u0442", 3431);
    freq.put("\u0432\u0443", 1966);
    freq.put("\u0435\u043a\u0435", 826);
    freq.put("\u0432\u044f", 3485);
    freq.put("\u0432\u0448", 985);
    freq.put("\u0432\u044a", 12004);
    freq.put("\u043d\u0441\u0442", 3816);
    freq.put("l ", 2342);
    freq.put("\u0438\u0432 ", 1131);
    freq.put("\u043f\u0442", 2156);
    freq.put("\u0435 ", 164103);
    freq.put("\u0430\u043b\u0441", 906);
    freq.put("\u043f\u0430 ", 3482);
    freq.put(" \u0441\u0430", 8475);
    freq.put(" \u0441\u0432", 5747);
    freq.put(" \u0441\u0435", 28117);
    freq.put("\u041e\u0440", 1247);
    freq.put("\u041e\u0441", 2133);
    freq.put("\u041e\u0442", 1087);
    freq.put(" \u0441\u043b", 4935);
    freq.put(" \u0441\u043c", 1742);
    freq.put(" \u0441\u043e", 1964);
    freq.put(" \u0441\u043f", 4517);
    freq.put("\u044a\u0433 ", 7573);
    freq.put("\u043e\u0438\u0442", 3156);
    freq.put("\u0438\u0447 ", 1609);
    freq.put("\u0411\u0440", 1925);
    freq.put("\u0411\u0443", 1134);
    freq.put("\u041f\u0435\u0442", 1186);
    freq.put("\u0411\u044a", 3741);
    freq.put("\u0435\u043c ", 1311);
    freq.put("\u043f", 177542);
    freq.put("\u043a\u0443\u043b", 1639);
    freq.put("\u0411\u0430", 2769);
    freq.put("\u0411\u0435", 2785);
    freq.put("\u043a\u0443\u0441", 995);
    freq.put("\u0411\u0438", 1506);
    freq.put("\u0411\u043e", 2717);
    freq.put("\u043b ", 25621);
    freq.put("\u0440\u0443\u0433", 2898);
    freq.put(" \u0441\u0440", 3911);
    freq.put("\u041e\u043a", 2446);
    freq.put(" \u0441\u0443", 971);
    freq.put("\u0415\u0432\u0440", 1146);
    freq.put(" \u0441\u0446", 1244);
    freq.put("\u041e\u043f", 1050);
    freq.put("\u041e\u0431", 2207);
    freq.put(" \u0441\u044a", 15734);
    freq.put("\u0438\u0434\u0438", 1105);
    freq.put("\u0430\u043b\u0430", 2998);
    freq.put("\u0421\u0435\u0432", 1817);
    freq.put("\u0435\u0447\u0435", 2969);
    freq.put("\u0430\u043b\u0435", 5565);
    freq.put("\u0430\u043b\u043a", 1807);
    freq.put("\u0430\u043b\u0438", 10040);
    freq.put("\u0430\u043b\u043e", 2628);
    freq.put("\u0430\u043b\u043d", 8729);
    freq.put("\u044a\u043f\u0440", 1168);
    freq.put(" \u0438 ", 47012);
    freq.put("\u03bb", 1144);
    freq.put("\u043d\u0438\u0442", 11345);
    freq.put("\u0435\u0441\u0438", 1554);
    freq.put("R", 2316);
    freq.put("\u043e\u043b ", 1852);
    freq.put("\u0440\u043b\u0430", 1189);
    freq.put("\u0431\u0435\u0434", 1013);
    freq.put("\u0431\u0435\u0437", 1026);
    freq.put("\u0436\u0430\u0432", 2301);
    freq.put("\u043e\u0438\u0306\u0442", 3479);
    freq.put("\u0431\u0435\u043b", 1391);
    freq.put("\u043e\u0438\u0306\u0441", 1115);
    freq.put("\u0431\u0435\u043d", 998);
    freq.put("\u0444\u0443", 2995);
    freq.put("\u0444\u0440", 3456);
    freq.put("\u0444\u0441", 1030);
    freq.put("\u0415", 7594);
    freq.put("\u0449\u0438\u043d", 2379);
    freq.put("\u043a\u0442\u0440", 1676);
    freq.put("\u0437\u0445", 1144);
    freq.put("\u0437\u0443", 1891);
    freq.put("\u0437\u0442", 3682);
    freq.put("\u0437\u0441", 1637);
    freq.put("\u0437\u0440", 2676);
    freq.put("\u043d\u0434 ", 1174);
    freq.put("\u0437\u044a", 1412);
    freq.put(" \u043a\u043d", 1333);
    freq.put(" \u043a\u043c", 1031);
    freq.put(" \u043a\u043e", 21829);
    freq.put("\u0435\u0442 ", 4265);
    freq.put(" \u043a\u0438", 1971);
    freq.put(" \u043a\u043b", 2272);
    freq.put(" \u0438\u0442", 1193);
    freq.put(" \u043a\u0430", 12665);
    freq.put("\u0430\u0440\u043e", 3343);
    freq.put(" \u043a\u044a", 3355);
    freq.put(" \u043a\u0440", 5742);
    freq.put(" \u043a\u0443", 1841);
    freq.put("\u0437\u0435", 4307);
    freq.put("\u0437\u0434", 6172);
    freq.put("\u0437\u0433", 1227);
    freq.put("\u0437\u0432", 12292);
    freq.put("\u0437\u0431", 1209);
    freq.put("\u0437\u0430", 35424);
    freq.put("\u0437\u043f", 8092);
    freq.put("\u0437\u043e", 4852);
    freq.put("\u0437\u043d", 6991);
    freq.put("\u0437\u043c", 2937);
    freq.put("\u0437\u043b", 3437);
    freq.put("\u0437\u043a", 2737);
    freq.put("\u0437\u0438", 16355);
    freq.put("\u0442\u0435\u0440", 6816);
    freq.put("\u0449\u0438\u0442", 1320);
    freq.put("\u0444\u043e", 5112);
    freq.put("\u0431\u0435\u0440", 1182);
    freq.put("\u0444\u0438", 11161);
    freq.put("\u043e\u0438\u0306\u043d", 2834);
    freq.put("\u043e\u0438\u0306\u0432", 1029);
    freq.put("\u0444\u0435", 4259);
    freq.put("\u043d\u0442 ", 3764);
    freq.put("\u043b\u0438\u0432", 1397);
    freq.put("\u0444\u0430", 3044);
    freq.put("\u0410\u0432", 1300);
    freq.put("\u0410\u043b", 2956);
    freq.put("\u043a ", 21804);
    freq.put("\u0410\u043c", 1040);
    freq.put("\u0410\u043d", 3455);
    freq.put("\u0410", 21177);
    freq.put("\u0410\u0429", 2595);
    freq.put(" \u0442", 27331);
    freq.put(" \u0443", 9960);
    freq.put(" \u0440", 36272);
    freq.put(" \u0441", 111437);
    freq.put(" \u0413\u043e", 1784);
    freq.put(" \u0447", 13239);
    freq.put(" \u0444", 16514);
    freq.put(" \u0445", 6966);
    freq.put("\u0437\u043d\u043e", 822);
    freq.put(" \u0413\u0430", 1572);
    freq.put(" \u0449", 6810);
    freq.put(" \u044e", 3698);
    freq.put(" \u044f", 2381);
    freq.put(" \u0413\u0435", 2574);
    freq.put("\u044a\u0449\u0435", 1730);
    freq.put("\u044a\u0449\u043e", 1266);
    freq.put("\u0435\u0432\u0430", 1249);
    freq.put(" \u0422", 15680);
    freq.put(" \u0423", 4153);
    freq.put(" \u0420", 15097);
    freq.put(" \u0421", 31643);
    freq.put(" \u0426", 2895);
    freq.put(" \u0427", 3246);
    freq.put(" \u0424", 7812);
    freq.put(" \u0425", 7558);
    freq.put(" \u0428", 3096);
    freq.put(" \u042e", 3200);
    freq.put(" \u042f", 1567);
    freq.put(" \u0413\u044a", 1180);
    freq.put(" \u0433", 41568);
    freq.put(" \u0430", 29615);
    freq.put(" \u0431", 25135);
    freq.put(" \u0436", 5999);
    freq.put(" \u0437", 26978);
    freq.put(" \u0434", 46722);
    freq.put(" \u0435", 87884);
    freq.put(" \u043a", 53137);
    freq.put(" \u043b", 8242);
    freq.put(" \u0438", 93394);
    freq.put(" \u043e", 88041);
    freq.put(" \u043f", 102853);
    freq.put(" \u043c", 36472);
    freq.put(" \u043d", 137556);
    freq.put("\u03ba", 1014);
    freq.put("\u043a\u0442 ", 1337);
    freq.put("h", 8702);
    freq.put("\u0410\u0442", 831);
    freq.put(" \u0413", 11364);
    freq.put("\u0410\u0440", 1719);
    freq.put(" \u0411", 18206);
    freq.put(" \u0416", 1503);
    freq.put(" \u0417", 5448);
    freq.put(" \u0414", 15029);
    freq.put(" \u0415", 7181);
    freq.put(" \u041a", 20624);
    freq.put(" \u041b", 9135);
    freq.put(" \u0418", 10217);
    freq.put(" \u0418\u0306", 1919);
    freq.put(" \u041e", 12505);
    freq.put(" \u041f", 21699);
    freq.put(" \u041c", 19107);
    freq.put(" \u041d", 12710);
    freq.put("\u043f\u0443\u043b", 1018);
    freq.put("\u0440\u0432\u043e", 979);
    freq.put("\u043f\u0443\u0431", 3689);
    freq.put("\u0440\u0432\u0438", 2226);
    freq.put("\u0444\u0438\u044f", 1796);
    freq.put("\u043b\u043e\u0436", 4131);
    freq.put("\u043e\u0434\u043d", 3018);
    freq.put("\u0434\u0441\u0442", 4125);
    freq.put("\u043e\u0434\u043e", 2573);
    freq.put("\u043e\u0434\u0430", 3875);
    freq.put("\u043e\u0434\u0435", 5129);
    freq.put("\u0440\u0438\u044f", 9828);
    freq.put("\u0440\u0438\u0442", 6765);
    freq.put("\u0440\u0438\u0441", 4939);
    freq.put("\u0440\u0438\u0440", 851);
    freq.put("\u0440\u0438\u0447", 4087);
    freq.put("\u043b\u043e\u0433", 4324);
    freq.put("\u0449\u0435\u043d", 865);
    freq.put("\u043b", 282008);
    freq.put("\u044e\u0446\u0438", 3278);
    freq.put("\u0432\u044a\u0437", 2174);
    freq.put("\u0449\u0435\u0441", 2508);
    freq.put("\u0440\u0438\u043b", 2477);
    freq.put("\u0440\u0438\u043a", 7682);
    freq.put("S", 5211);
    freq.put("\u0440\u0438\u043e", 1833);
    freq.put("\u0440\u0438\u043d", 4333);
    freq.put("\u0440\u0438\u043c", 2306);
    freq.put("\u0440\u0438\u0433", 1450);
    freq.put("\u0440\u0438\u0432", 950);
    freq.put("\u0440\u0438\u0430", 2344);
    freq.put("\u0440\u0438\u0437", 1180);
    freq.put("\u0440\u0438\u0435", 1786);
    freq.put("\u0440\u0438\u0434", 1515);
    freq.put("\u0440 ", 30654);
    freq.put("\u0444\u0438\u043b", 3622);
    freq.put("\u043e\u0434\u0441", 1049);
    freq.put("\u043e\u0434\u0440", 1677);
    freq.put("\u043e\u0434\u0443", 932);
    freq.put("\u0432\u0433", 1251);
    freq.put("\u0434\u0441\u043a", 2604);
    freq.put(" \u0437\u0435", 1022);
    freq.put(" \u0437\u0432", 852);
    freq.put("\u043e\u043b\u043e", 11644);
    freq.put(" \u0437\u0430", 22793);
    freq.put("\u0432\u043d", 10484);
    freq.put(" \u0437\u043d", 1109);
    freq.put("\u0432\u043e", 35579);
    freq.put("ci", 1241);
    freq.put("ch", 1482);
    freq.put("co", 1092);
    freq.put("\u043d\u0435\u0440", 3755);
    freq.put("\u043d\u0435\u0442", 4998);
    freq.put("ca", 1035);
    freq.put("ce", 1332);
    freq.put("\u0436\u0430", 5863);
    freq.put("\u0436\u0434", 7425);
    freq.put("\u0436\u0435", 11581);
    freq.put("\u0436\u0438", 10091);
    freq.put("\u0436\u043a", 1307);
    freq.put("\u0432\u043b", 5218);
    freq.put("\u0436\u043d", 4179);
    freq.put("\u0436\u043e", 1971);
    freq.put("\u0442\u043e\u044f", 1817);
    freq.put("\u043c\u0441\u043a", 3992);
    freq.put("\u0426", 2988);
    freq.put("\u0442\u043e\u0442", 821);
    freq.put("\u0442\u043e\u0440", 11467);
    freq.put("\u0442\u043e\u0447", 3383);
    freq.put("\u0443\u043b", 6590);
    freq.put("\u0443\u043a", 5239);
    freq.put("\u0443\u0438", 1236);
    freq.put("\u0443\u043f", 6474);
    freq.put("\u0425\u0440\u0438", 815);
    freq.put("\u0443\u043c", 6401);
    freq.put("\u0443\u0433", 3988);
    freq.put("\u0443\u0432", 3514);
    freq.put("\u0443\u0431", 6162);
    freq.put("\u0443\u0430", 3124);
    freq.put("\u0443\u0437", 3299);
    freq.put("\u0443\u0436", 1616);
    freq.put("\u03bf", 2756);
    freq.put("\u0443\u0434", 4037);
    freq.put("\u043e\u043a\u0442", 1051);
    freq.put("\u0443\u0448", 4842);
    freq.put("\u0443\u0442", 4765);
    freq.put("\u0443\u0441", 9980);
    freq.put("\u0443\u0440", 10561);
    freq.put("\u0443\u0447", 6066);
    freq.put("\u0443\u0446", 1227);
    freq.put("\u0443\u0445", 1233);
    freq.put("\u0442\u043e\u043b", 2748);
    freq.put("\u0442\u043e\u043a", 1533);
    freq.put("\u0442\u043e\u0438\u0306", 1268);
    freq.put("\u0442\u043e\u043f", 1014);
    freq.put("\u0442\u043e\u043d", 2179);
    freq.put("\u0442\u043e\u043c", 2089);
    freq.put("\u0442\u043e\u0432", 5201);
    freq.put("\u0436\u0443", 937);
    freq.put("\u0442\u0438\u043a", 4630);
    freq.put("\u0447\u043e\u0432", 1436);
    freq.put("\u043d\u0435\u0433", 1689);
    freq.put("\u043d\u0435\u0432", 1009);
    freq.put("\u043d\u0435\u043d", 7192);
    freq.put("\u043d\u0435\u043c", 1875);
    freq.put("\u0434\u0443 ", 2227);
    freq.put("\u043a\u0438\u0442", 4721);
    freq.put("ve", 1027);
    freq.put("\u043c\u0443 ", 4914);
    freq.put("vi", 1029);
    freq.put("\u043a\u0438\u044f", 7501);
    freq.put("\u0411", 18556);
    freq.put("\u0443\u0441\u0442", 2872);
    freq.put("\u043c\u0438\u043d", 5435);
    freq.put("\u043e\u0438 ", 1291);
    freq.put(" II", 1042);
    freq.put("\u0435\u043b ", 8445);
    freq.put("\u043c\u0438\u043b", 1270);
    freq.put("\u0435\u043c\u0441", 1747);
    freq.put("\u043d\u0443\u0430", 804);
    freq.put("\u043c\u0430\u043d", 6016);
    freq.put("\u0437\u043d\u0438", 1000);
    freq.put("\u043c\u0430\u043b", 2220);
    freq.put("\u043c\u0430\u043a", 2180);
    freq.put("\u043c\u0430\u0438\u0306", 1485);
    freq.put("\u0437\u043d\u0430", 4787);
    freq.put("\u043c\u0430\u0433", 843);
    freq.put("\u043e\u0442\u043b", 842);
    freq.put("\u043c\u0430\u0446", 839);
    freq.put("\u043c\u0430\u0442", 5742);
    freq.put("\u043c\u0430\u0441", 872);
    freq.put("\u043c\u0430\u0440", 1751);
    freq.put("ion", 1052);
    freq.put("\u0435\u043c\u0438", 3799);
    freq.put("\u0435\u043c\u043e", 966);
    freq.put("\u0435\u043c\u0432", 2337);
    freq.put("\u0435\u043c\u0430", 3994);
    freq.put("\u043f ", 2647);
    freq.put("\u0443\u0441\u043a", 2598);
    freq.put("\u043b\u0437\u0432", 2068);
    freq.put("\u0447\u0438 ", 992);
    freq.put("\u0443\u043a\u0430", 1012);
    freq.put("i", 28615);
    freq.put("\u0442\u0441\u043a", 2626);
    freq.put("\u043d\u0433 ", 1106);
    freq.put(" Th", 951);
    freq.put("\u0449\u0442\u0430", 2294);
    freq.put("\u0435\u0441 ", 1992);
    freq.put("\u043a\u0438\u043d", 1233);
    freq.put("\u0441\u044a\u0432", 1667);
    freq.put("\u043d\u0441 ", 993);
    freq.put("\u0430\u0438\u0306\u043a", 1056);
    freq.put("\u0430\u0438\u0306\u043d", 2031);
    freq.put("\u0430\u0438\u0306\u043e", 1501);
    freq.put("\u0441\u044a\u0434", 995);
    freq.put("\u0432\u044a\u0440", 4758);
    freq.put("\u0435\u044f", 1281);
    freq.put("\u0435\u044f ", 816);
    freq.put("\u0435\u0449", 3642);
    freq.put("\u0435\u0448", 4262);
    freq.put("\u0435\u0445", 2366);
    freq.put("\u0435\u0444", 2109);
    freq.put("\u0435\u0447", 4774);
    freq.put("\u0435\u0446", 5302);
    freq.put("\u0435\u0441", 32066);
    freq.put("\u0435\u0440", 49860);
    freq.put(" \u0414\u0440", 1035);
    freq.put("\u0435\u043a\u0430", 2557);
    freq.put("\u0426\u0435\u043d", 1121);
    freq.put("\u0432 ", 63211);
    freq.put("\u043c", 161532);
    freq.put("\u0441\u0438\u0447", 1328);
    freq.put("\u0435\u043a ", 3487);
    freq.put("\u0421\u044a\u0435", 2317);
    freq.put("\u041f\u043b\u043e", 2474);
    freq.put("T", 2986);
    freq.put("\u0435\u043d", 105327);
    freq.put(" \u0414\u043e", 1933);
    freq.put("\u0435\u043f", 8513);
    freq.put("\u0435\u043e", 5548);
    freq.put("\u0435\u0438\u0306", 11615);
    freq.put("\u0435\u0438", 962);
    freq.put("\u0435\u043b", 47225);
    freq.put(" \u0414\u0438", 2315);
    freq.put("\u0435\u0435", 2077);
    freq.put(" \u0414\u0436", 3188);
    freq.put(" \u0414\u0435", 2497);
    freq.put("\u0435\u0436", 9844);
    freq.put("\u0435\u0431", 3744);
    freq.put("\u0435\u0430", 2059);
    freq.put("\u0435\u0433", 6758);
    freq.put(" \u0414\u0430", 1391);
    freq.put("\u0438\u0432\u043d", 2071);
    freq.put("\u044a\u0446\u043a", 1859);
    freq.put("\u0438\u0432\u043e", 2091);
    freq.put("\u0438\u0432\u0438", 1509);
    freq.put("\u0438\u0432\u0435", 2646);
    freq.put("\u0430\u0438\u0306\u0441", 963);
    freq.put("\u0438\u0432\u0430", 2727);
    freq.put(" \u0441 ", 12955);
    freq.put("\u043b\u0438\u043d", 3617);
    freq.put("\u0432\u0442\u043e", 2970);
    freq.put("\u0446\u0435\u043b", 1258);
    freq.put("\u043f\u0430\u0434", 4016);
    freq.put("\u043f\u0430\u043d", 2587);
    freq.put("\u0427", 3270);
    freq.put("\u043e\u0435\u0442", 2833);
    freq.put("\u043b\u0443", 5370);
    freq.put("\u043b\u0442", 3196);
    freq.put("\u043b\u0441", 4866);
    freq.put("\u0438\u0447\u043d", 6798);
    freq.put("\u0438\u0447\u043a", 1339);
    freq.put("\u0438\u0447\u0438", 1220);
    freq.put("\u043b\u044a", 2856);
    freq.put("\u0438\u0447\u0435", 8842);
    freq.put("\u043b\u044f", 9658);
    freq.put("\u043b\u044e", 6411);
    freq.put("\u0438\u0447\u0430", 3197);
    freq.put("\u043b\u0433", 12737);
    freq.put("\u043b\u0432", 914);
    freq.put("\u043b\u0431", 2941);
    freq.put("\u043b\u0430", 34165);
    freq.put("\u043b\u0437", 2343);
    freq.put("\u043b\u0436", 1120);
    freq.put("\u043b\u0435", 40750);
    freq.put("\u043b\u0434", 1625);
    freq.put("\u043b\u043a", 4727);
    freq.put("\u043b\u0438", 64840);
    freq.put("\u043b\u043e", 33848);
    freq.put("\u043b\u043d", 16796);
    freq.put("\u043b\u043c", 3442);
    freq.put("\u043e\u0435\u043c", 891);
    freq.put("\u043e\u0435\u043d", 1806);
    freq.put("\u0438\u0449\u0435", 1958);
    freq.put("\u0437\u0445\u043e", 1090);
    freq.put("\u0448\u043a", 2046);
    freq.put("\u0430\u043b ", 5489);
    freq.put("\u043f\u0430\u0440", 3257);
    freq.put("\u043f\u0430\u0442", 1787);
    freq.put("\u0448\u043d", 3596);
    freq.put("\u0448\u0432", 1228);
    freq.put("\u0448\u0430", 3103);
    freq.put("\u0448\u0435", 4003);
    freq.put("\u044e\u0447\u0432", 950);
    freq.put("\u0438\u0434 ", 2167);
    freq.put("\u0414\u043e", 1935);
    freq.put("\u043e\u043b\u0441", 1164);
    freq.put("\u043e\u043b\u0443", 2069);
    freq.put("\u0414\u0438", 2316);
    freq.put(" \u041d\u0435", 1867);
    freq.put("\u0414\u0436", 3197);
    freq.put("\u0414\u0435", 2501);
    freq.put("\u0414\u0430", 1394);
    freq.put("\u043e\u043b\u044f", 2830);
    freq.put("\u0412", 16284);
    freq.put("\u044f\u0442 ", 9602);
    freq.put("\u0441\u044a\u0441", 4442);
    freq.put("h ", 1014);
    freq.put(" \u0438\u043b", 7883);
    freq.put(" \u0438\u043d", 3652);
    freq.put(" \u0438\u043c", 7956);
    freq.put(" \u0438\u0433", 2469);
    freq.put("\u0435\u043a\u0442", 4178);
    freq.put(" \u0438\u0437", 17689);
    freq.put("\u0430\u0444\u0441", 811);
    freq.put(" \u0438\u0434", 823);
    freq.put(" \u0444\u0438", 5383);
    freq.put("\u0430\u0444\u0438", 915);
    freq.put(" \u041d\u0438", 2110);
    freq.put(" \u0438\u0441", 3053);
    freq.put("\u0436", 46599);
    freq.put("hu", 824);
    freq.put("hi", 896);
    freq.put("ha", 1204);
    freq.put("he", 2112);
    freq.put("nu", 977);
    freq.put("\u043e\u0442\u0435", 1711);
    freq.put("\u043e\u043b\u0430", 2641);
    freq.put("\u043e\u043b\u0435", 5004);
    freq.put("\u043e\u043b\u0437", 2123);
    freq.put("\u043e\u043b\u0438", 8455);
    freq.put("\u043e\u043b\u043a", 1549);
    freq.put("\u043e\u043b\u043d", 1271);
    freq.put("\u0414\u0440", 1035);
    freq.put("\u0449\u0438 ", 1591);
    freq.put(" \u0441\u0438", 8451);
    freq.put("\u0436\u0430 ", 1065);
    freq.put("\u043d\u0442\u044a", 2337);
    freq.put("et", 1200);
    freq.put("\u043d\u0442\u0440", 2358);
    freq.put(" \u0441\u043a", 1388);
    freq.put("\u0435\u0442\u0435", 3470);
    freq.put("\u0441\u044a\u043a", 852);
    freq.put("\u0438\u0440 ", 1662);
    freq.put("\u0435\u0442\u0430", 4044);
    freq.put("\u0441\u044a\u043d", 863);
    freq.put("\u0413\u0435\u0440", 981);
    freq.put("\u0435\u0442\u043d", 1476);
    freq.put("\u0435\u0442\u043e", 20630);
    freq.put("\u0435\u0442\u0438", 4225);
    freq.put("\u043b\u0438\u0437", 3791);
    freq.put("\u0441\u044a\u0437", 2361);
    freq.put("\u0441\u0438\u0442", 2033);
    freq.put("\u043d\u0434\u0438", 2598);
    freq.put("\u0441\u0438\u0441", 1833);
    freq.put("\u043d\u0434\u043e", 877);
    freq.put("\u041f", 22329);
    freq.put("\u0441\u0438\u0445", 1495);
    freq.put("\u0435\u0449\u0435", 814);
    freq.put("\u043d\u0434\u0430", 1986);
    freq.put("er", 5287);
    freq.put("\u043d", 589099);
    freq.put("\u0441\u0438\u044f", 1303);
    freq.put("\u043d\u0434\u0435", 899);
    freq.put("\u0437 ", 12874);
    freq.put("\u0441\u0438\u043b", 2220);
    freq.put("\u043d\u0434\u0440", 1171);
    freq.put("\u043d\u0434\u0441", 1234);
    freq.put("\u0441\u0438\u043c", 1511);
    freq.put("\u0441\u0438\u043d", 1858);
    freq.put("\u0441\u044a\u0449", 2787);
    freq.put("\u0435\u0442\u0440", 1876);
    freq.put("\u0435\u0442\u0441", 1612);
    freq.put("\u0413\u0435\u043e", 1043);
    freq.put("\u043e\u0446\u0438", 1428);
    freq.put("\u0435\u0442\u044a", 1538);
    freq.put("\u043d\u0442\u043e", 1031);
    freq.put("\u043d\u0442\u0438", 4317);
    freq.put("\u043e\u043a\u0430", 2144);
    freq.put("\u043e\u0438\u0306 ", 4351);
    freq.put("\u043d\u0442\u0430", 3339);
    freq.put("\u0444 ", 1914);
    freq.put("\u0437\u043c\u0430", 848);
    freq.put("\u044f\u043b\u043e", 937);
  }
  
}

