package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class AST extends CLangProfile {
  private static final String name = "ast";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public AST() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 1582293;
    n_words[1] = 1899443;
    n_words[2] = 1537988;

    freq.put("ti\u0301p", 45);
    freq.put("ti\u0301s", 63);
    freq.put("ti\u0301t", 74);
    freq.put("ti\u0301u", 286);
    freq.put("IX ", 85);
    freq.put("e\u0301rt", 29);
    freq.put("e\u0301ri", 318);
    freq.put("ti\u0301c", 76);
    freq.put("e\u0301rm", 263);
    freq.put("ti\u0301f", 73);
    freq.put("e\u0301ro", 24);
    freq.put("e\u0301ra", 37);
    freq.put("e\u0301rc", 62);
    freq.put("e\u0301re", 70);
    freq.put("ti\u0301n", 360);
    freq.put("e\u0301rg", 44);
    freq.put("il\u0323l\u0323", 41);
    freq.put(" ya\u0301", 69);
    freq.put(" y ", 9614);
    freq.put("lmu", 23);
    freq.put("xtr", 16);
    freq.put(" yo", 56);
    freq.put(" ya", 273);
    freq.put("k", 2709);
    freq.put(" ye", 8145);
    freq.put("e\u0301rr", 17);
    freq.put("pe\u0301u", 53);
    freq.put("ti\u0301a", 80);
    freq.put("ti\u0301e", 18);
    freq.put("ti\u0301m", 27);
    freq.put("ti\u0301o", 79);
    freq.put("Le", 554);
    freq.put("La", 2522);
    freq.put("Lo", 705);
    freq.put("Ll", 1198);
    freq.put("Li", 336);
    freq.put("Lu", 263);
    freq.put("Ly", 19);
    freq.put("hod", 18);
    freq.put("hob", 248);
    freq.put("hon", 103);
    freq.put("hol", 52);
    freq.put("hom", 184);
    freq.put("\u03b1\u0301", 32);
    freq.put("hou", 33);
    freq.put("hor", 168);
    freq.put("hos", 165);
    freq.put("uco", 20);
    freq.put("A", 5996);
    freq.put("\u0645", 65);
    freq.put("L ", 706);
    freq.put("\u03bf\u03c2 ", 43);
    freq.put("ho ", 145);
    freq.put("u\u0304", 37);
    freq.put(" V ", 28);
    freq.put("zam", 65);
    freq.put("hu ", 272);
    freq.put("Hip", 16);
    freq.put("fis", 25);
    freq.put("His", 63);
    freq.put("fit", 95);
    freq.put("ro\u0301", 498);
    freq.put("fiz", 20);
    freq.put("fix", 43);
    freq.put("ru\u0301", 78);
    freq.put("fib", 27);
    freq.put("fic", 1407);
    freq.put("ra\u0301", 1099);
    freq.put("fie", 162);
    freq.put("ri\u0301", 1725);
    freq.put("fin", 420);
    freq.put("Him", 16);
    freq.put("fil", 220);
    freq.put(" Va", 426);
    freq.put("zae", 31);
    freq.put(" Ve", 274);
    freq.put("upo", 77);
    freq.put(" Vi", 634);
    freq.put(" Vl", 20);
    freq.put(" Vo", 66);
    freq.put(" Vu", 28);
    freq.put("ata\u0301", 69);
    freq.put("ati\u0301", 186);
    freq.put("ate\u0301", 47);
    freq.put("uo ", 19);
    freq.put("ato\u0301", 194);
    freq.put("i\u0301be", 16);
    freq.put("Na\u0301", 26);
    freq.put("rt", 5448);
    freq.put("ru", 4304);
    freq.put("rv", 417);
    freq.put("rw", 23);
    freq.put("rp", 327);
    freq.put("rq", 336);
    freq.put("rr", 3872);
    freq.put("rs", 1354);
    freq.put("smu", 728);
    freq.put("rx", 397);
    freq.put("ry", 227);
    freq.put("rz", 354);
    freq.put("smo", 152);
    freq.put("re", 14065);
    freq.put("rf", 348);
    freq.put("rg", 1336);
    freq.put("ra", 13769);
    freq.put("rb", 593);
    freq.put("rc", 1985);
    freq.put("rl", 550);
    freq.put("rm", 2675);
    freq.put("rn", 1502);
    freq.put("ro", 8937);
    freq.put("rh", 34);
    freq.put("ri", 14987);
    freq.put("sma", 124);
    freq.put("rk", 239);
    freq.put(" Vi\u0301", 34);
    freq.put("ate", 724);
    freq.put("ata", 633);
    freq.put("ato", 461);
    freq.put("atl", 27);
    freq.put("atm", 26);
    freq.put("ath", 60);
    freq.put("ati", 739);
    freq.put("att", 67);
    freq.put("atu", 707);
    freq.put("r ", 10990);
    freq.put("ats", 43);
    freq.put("ei\u0301s", 24);
    freq.put("ds ", 52);
    freq.put("Dub", 24);
    freq.put("xic", 401);
    freq.put("xid", 73);
    freq.put("xig", 16);
    freq.put("Cen", 123);
    freq.put("Cel", 38);
    freq.put("xil", 37);
    freq.put("xim", 111);
    freq.put("xin", 468);
    freq.put("xip", 38);
    freq.put("xiq", 27);
    freq.put("xir", 34);
    freq.put("nz ", 34);
    freq.put("xit", 112);
    freq.put("Cer", 38);
    freq.put("Asi\u0301", 19);
    freq.put(" fr", 620);
    freq.put("xi ", 21);
    freq.put("i\u0301", 10370);
    freq.put("nza", 224);
    freq.put("nzi", 17);
    freq.put("nzo", 44);
    freq.put("oqu", 857);
    freq.put("uyo\u0301", 22);
    freq.put("Oli\u0301", 20);
    freq.put("ma\u0301t", 186);
    freq.put("\u30a2", 70);
    freq.put("Ast", 836);
    freq.put("Asa", 19);
    freq.put("hum", 281);
    freq.put("Sou", 32);
    freq.put("Asi", 170);
    freq.put("Aso", 50);
    freq.put("nzo\u0301", 18);
    freq.put("ae\u0301r", 16);
    freq.put("ae\u0301l", 16);
    freq.put("nza\u0301", 109);
    freq.put("As ", 21);
    freq.put("lph", 22);
    freq.put("lpe", 47);
    freq.put("lpa", 19);
    freq.put("\u1100\u1161 ", 19);
    freq.put("iro\u0301", 28);
    freq.put("iri\u0301", 31);
    freq.put("ira\u0301", 26);
    freq.put("ne\u0301r", 20);
    freq.put("ne\u0301s", 222);
    freq.put("ne\u0301t", 93);
    freq.put("ne\u0301u", 56);
    freq.put("n\u0303u ", 573);
    freq.put("Riv", 22);
    freq.put("Rin", 38);
    freq.put("Rio", 37);
    freq.put("Rie", 23);
    freq.put("Rib", 77);
    freq.put("Ric", 74);
    freq.put("ua ", 658);
    freq.put("e\u0301po", 19);
    freq.put("irx", 30);
    freq.put("irr", 36);
    freq.put("irt", 57);
    freq.put("iru", 103);
    freq.put("irv", 49);
    freq.put("iri", 230);
    freq.put("irl", 52);
    freq.put("irm", 58);
    freq.put("iro", 105);
    freq.put("ira", 298);
    freq.put("irc", 112);
    freq.put("ire", 356);
    freq.put("irg", 21);
    freq.put("cur", 270);
    freq.put("l\u0323en", 35);
    freq.put("ir ", 518);
    freq.put("pre", 1409);
    freq.put("a\u0301lo", 17);
    freq.put("fra", 460);
    freq.put("fre", 191);
    freq.put("fri", 250);
    freq.put("anc", 1326);
    freq.put("fro", 64);
    freq.put("fru", 34);
    freq.put("pro", 2242);
    freq.put("rge", 77);
    freq.put("ano", 622);
    freq.put("a\u0301lb", 64);
    freq.put("a\u0301lc", 16);
    freq.put("cun", 115);
    freq.put("a\u0301la", 32);
    freq.put("pru", 17);
    freq.put("cul", 728);
    freq.put("anq", 165);
    freq.put("bil", 130);
    freq.put("Dio", 46);
    freq.put("Be\u0301l", 25);
    freq.put("lo\u0301x", 170);
    freq.put("bi\u0301", 80);
    freq.put("\u0441", 82);
    freq.put("be\u0301", 114);
    freq.put("tz ", 18);
    freq.put("bia", 250);
    freq.put("upo\u0301", 17);
    freq.put("ola\u0301", 24);
    freq.put("ole\u0301", 37);
    freq.put("oli\u0301", 584);
    freq.put("olo\u0301", 178);
    freq.put("bit", 522);
    freq.put("hai", 185);
    freq.put("hal", 60);
    freq.put("ham", 112);
    freq.put("han", 200);
    freq.put("bir", 51);
    freq.put("hab", 459);
    freq.put("hac", 46);
    freq.put("had", 36);
    freq.put("hae", 49);
    freq.put("hag", 19);
    freq.put("haz", 27);
    freq.put(" a\u0301t", 25);
    freq.put("har", 159);
    freq.put("has", 265);
    freq.put("hat", 64);
    freq.put("ha ", 333);
    freq.put("bn ", 16);
    freq.put("ola", 1728);
    freq.put("olc", 140);
    freq.put("old", 98);
    freq.put("ole", 772);
    freq.put("olf", 79);
    freq.put("olg", 30);
    freq.put("oli", 461);
    freq.put("olk", 37);
    freq.put("oll", 264);
    freq.put("olm", 32);
    freq.put("olo", 1462);
    freq.put("olp", 27);
    freq.put("ols", 32);
    freq.put("olt", 25);
    freq.put("olu", 538);
    freq.put("olv", 56);
    freq.put("fot", 43);
    freq.put("ump", 33);
    freq.put("for", 1231);
    freq.put("fos", 37);
    freq.put("ume", 262);
    freq.put("uma", 323);
    freq.put("umb", 180);
    freq.put("fol", 90);
    freq.put("fon", 225);
    freq.put("umi", 61);
    freq.put("\u03bf\u03c2", 43);
    freq.put("ol ", 1861);
    freq.put(" Xi", 258);
    freq.put(" Xo", 93);
    freq.put(" Xa", 147);
    freq.put(" Xe", 228);
    freq.put(" Xu", 749);
    freq.put("o", 99522);
    freq.put("fo ", 25);
    freq.put("um ", 236);
    freq.put("mbl", 52);
    freq.put("Fed", 83);
    freq.put("mbo", 229);
    freq.put("sod", 20);
    freq.put("sof", 210);
    freq.put("mbe", 565);
    freq.put("Fel", 43);
    freq.put("som", 55);
    freq.put("mba", 179);
    freq.put("son", 1104);
    freq.put("sop", 39);
    freq.put("sos", 778);
    freq.put("sor", 204);
    freq.put("Fer", 163);
    freq.put("Fes", 41);
    freq.put("sov", 42);
    freq.put("mbu", 86);
    freq.put("mbr", 514);
    freq.put("az ", 185);
    freq.put("so ", 1810);
    freq.put("\u03c3", 52);
    freq.put("mb ", 98);
    freq.put("azi", 31);
    freq.put("No\u0301m", 16);
    freq.put("azo", 52);
    freq.put("aza", 222);
    freq.put("aze", 16);
    freq.put("azz", 30);
    freq.put("tie\u0301", 159);
    freq.put("a\u0301xe", 18);
    freq.put("a\u0301xi", 52);
    freq.put("azu", 81);
    freq.put("Sis", 109);
    freq.put("Sir", 30);
    freq.put("n\u0303os", 414);
    freq.put("n\u0303or", 19);
    freq.put("Sit", 19);
    freq.put("Sic", 40);
    freq.put("Sig", 20);
    freq.put("Sie", 113);
    freq.put("Sid", 22);
    freq.put("n\u0303ol", 527);
    freq.put("Sin", 44);
    freq.put("Sim", 30);
    freq.put("Sil", 46);
    freq.put("us", 2362);
    freq.put("\u0641", 16);
    freq.put("E", 5918);
    freq.put("\u30a2\u30a2", 53);
    freq.put("n\u0303o ", 311);
    freq.put("U\u0301", 43);
    freq.put("nxu", 198);
    freq.put("cun\u0303", 31);
    freq.put("nxe", 170);
    freq.put("nxa", 45);
    freq.put("nxo", 23);
    freq.put("azo\u0301", 33);
    freq.put("nxi", 77);
    freq.put("Web", 24);
    freq.put("osp", 32);
    freq.put("oss", 52);
    freq.put("osu", 165);
    freq.put("ost", 627);
    freq.put("osi", 473);
    freq.put("osh", 30);
    freq.put("oso", 188);
    freq.put("osa", 304);
    freq.put("osc", 82);
    freq.put("ose", 382);
    freq.put("osf", 23);
    freq.put("Aqu", 27);
    freq.put("vet", 21);
    freq.put("ver", 884);
    freq.put("ves", 273);
    freq.put("vez", 171);
    freq.put("vex", 31);
    freq.put("vey", 23);
    freq.put("veg", 149);
    freq.put("ved", 47);
    freq.put("Ta ", 207);
    freq.put("vec", 119);
    freq.put("ven", 489);
    freq.put("vel", 352);
    freq.put("un", 16042);
    freq.put("Ma\u0301", 41);
    freq.put("Me\u0301", 138);
    freq.put("lro", 22);
    freq.put("Mo\u0301", 17);
    freq.put("os ", 14303);
    freq.put("Tap", 17);
    freq.put("Tar", 50);
    freq.put("Tab", 18);
    freq.put("Tal", 25);
    freq.put("Tam", 114);
    freq.put("Tan", 43);
    freq.put("Tai", 36);
    freq.put("M ", 57);
    freq.put("oso\u0301", 20);
    freq.put("ose\u0301", 142);
    freq.put("bc", 20);
    freq.put("u\u0301tb", 122);
    freq.put("ge\u0301n", 52);
    freq.put("Me", 533);
    freq.put("Ma", 1638);
    freq.put("Mc", 21);
    freq.put("Mo", 606);
    freq.put("Mi", 504);
    freq.put("Mu", 327);
    freq.put("O", 1361);
    freq.put("oet", 107);
    freq.put("My", 28);
    freq.put("ipc", 38);
    freq.put("ipa", 430);
    freq.put("oem", 31);
    freq.put("ipe", 140);
    freq.put("ipi", 206);
    freq.put("ipo", 85);
    freq.put("ipl", 111);
    freq.put("ipr", 31);
    freq.put("ips", 20);
    freq.put("ipp", 38);
    freq.put("ipt", 37);
    freq.put("ipu", 258);
    freq.put("te\u0301t", 27);
    freq.put("te\u0301u", 55);
    freq.put("te\u0301r", 282);
    freq.put("te\u0301s", 22);
    freq.put("te\u0301l", 36);
    freq.put("te\u0301c", 24);
    freq.put("ip ", 24);
    freq.put("ua", 2925);
    freq.put("su\u0301", 53);
    freq.put("so\u0301", 173);
    freq.put("n\u0303", 3891);
    freq.put("se\u0301", 270);
    freq.put("si\u0301", 372);
    freq.put("sa\u0301", 192);
    freq.put("te\u0301 ", 24);
    freq.put("za\u0301l", 71);
    freq.put("ipa\u0301", 109);
    freq.put("ipo\u0301", 30);
    freq.put("za\u0301u", 177);
    freq.put("s ", 40851);
    freq.put("Ce\u0301s", 18);
    freq.put("uga", 675);
    freq.put("sy", 36);
    freq.put("ss", 430);
    freq.put("sr", 47);
    freq.put("sq", 160);
    freq.put("sp", 2803);
    freq.put("sw", 61);
    freq.put("sv", 28);
    freq.put("su", 3342);
    freq.put("st", 16142);
    freq.put("sk", 193);
    freq.put("si", 7463);
    freq.put("sh", 379);
    freq.put("so", 5597);
    freq.put("sn", 86);
    freq.put("sm", 1113);
    freq.put("sl", 676);
    freq.put("sc", 2600);
    freq.put("sb", 145);
    freq.put("sa", 2946);
    freq.put("sg", 47);
    freq.put("sf", 190);
    freq.put("se", 7778);
    freq.put("sd", 46);
    freq.put("tts", 26);
    freq.put("ttp", 30);
    freq.put("\u044f ", 18);
    freq.put("tti", 47);
    freq.put("tto", 19);
    freq.put("pi\u0301a", 25);
    freq.put("tta", 42);
    freq.put("tte", 83);
    freq.put("bla\u0301", 16);
    freq.put("tt ", 36);
    freq.put("a\u0301ce", 43);
    freq.put("a\u0301ci", 60);
    freq.put("a\u0301cn", 17);
    freq.put("a\u0301cu", 19);
    freq.put("a\u0301ct", 37);
    freq.put("Jos", 170);
    freq.put("blu", 194);
    freq.put("mo\u0301v", 46);
    freq.put("mo\u0301s", 27);
    freq.put("mo\u0301n", 124);
    freq.put("blo", 137);
    freq.put("bli", 736);
    freq.put(" L\u0323l\u0323", 78);
    freq.put("ble", 600);
    freq.put("bla", 671);
    freq.put("mo\u0301 ", 147);
    freq.put("oni", 562);
    freq.put("onn", 37);
    freq.put("ono", 1232);
    freq.put("onm", 16);
    freq.put("onc", 1695);
    freq.put("ona", 2248);
    freq.put("onf", 149);
    freq.put("ong", 264);
    freq.put("ond", 741);
    freq.put("one", 2016);
    freq.put("onz", 81);
    freq.put("onx", 271);
    freq.put("ony", 19);
    freq.put("ons", 1018);
    freq.put("onq", 40);
    freq.put("onv", 143);
    freq.put("ont", 1146);
    freq.put("onu", 165);
    freq.put("uka", 16);
    freq.put(" Zo", 24);
    freq.put(" Zi", 33);
    freq.put(" Zh", 26);
    freq.put("ci\u0301n", 32);
    freq.put(" Ze", 65);
    freq.put("on ", 3818);
    freq.put(" Za", 126);
    freq.put(" Zu", 29);
    freq.put("rza", 41);
    freq.put("rzo", 20);
    freq.put("rzu", 257);
    freq.put("ci\u0301f", 99);
    freq.put("Ald", 18);
    freq.put("uk ", 27);
    freq.put("one\u0301", 183);
    freq.put("sao", 32);
    freq.put("san", 187);
    freq.put("sam", 104);
    freq.put("sal", 238);
    freq.put("sac", 149);
    freq.put("sab", 102);
    freq.put("ona\u0301", 49);
    freq.put("sag", 47);
    freq.put("sae", 34);
    freq.put("sad", 133);
    freq.put("i\u0301ni", 45);
    freq.put("say", 22);
    freq.put("sax", 50);
    freq.put("sas", 105);
    freq.put("ono\u0301", 158);
    freq.put("i\u0301nc", 52);
    freq.put("i\u0301ne", 88);
    freq.put("sau", 32);
    freq.put("sat", 65);
    freq.put("zoi", 18);
    freq.put("zol", 22);
    freq.put("zon", 252);
    freq.put("ax ", 72);
    freq.put("zos", 66);
    freq.put("sa ", 1266);
    freq.put("i\u0301n ", 773);
    freq.put("ci\u0301u", 597);
    freq.put("zo ", 84);
    freq.put("axu", 93);
    freq.put("ci\u0301r", 30);
    freq.put("axa", 121);
    freq.put("axe", 328);
    freq.put("axi", 67);
    freq.put("axo", 171);
    freq.put("XI ", 17);
    freq.put("vid", 385);
    freq.put("ux", 275);
    freq.put(" ba\u0301", 65);
    freq.put("uz", 238);
    freq.put("uq", 55);
    freq.put("up", 1143);
    freq.put("NE ", 209);
    freq.put("ur", 6515);
    freq.put("um", 1214);
    freq.put("ul", 2517);
    freq.put("agu\u0308", 33);
    freq.put("uh", 26);
    freq.put("fir", 54);
    freq.put("uk", 78);
    freq.put("ai\u0301n", 36);
    freq.put("uj", 33);
    freq.put("fiq", 52);
    freq.put("ai\u0301s", 589);
    freq.put(" be", 110);
    freq.put(" ba", 948);
    freq.put(" bl", 136);
    freq.put(" bo", 238);
    freq.put(" bi", 329);
    freq.put(" bu", 94);
    freq.put("s", 94323);
    freq.put(" br", 201);
    freq.put("iva\u0301", 16);
    freq.put("ivi\u0301", 27);
    freq.put("uoc", 26);
    freq.put("u\u0301ri", 20);
    freq.put("fig", 100);
    freq.put("ni\u0301u", 156);
    freq.put("ni\u0301s", 42);
    freq.put("ni\u0301e", 66);
    freq.put("ni\u0301a", 163);
    freq.put("ni\u0301n", 173);
    freq.put("ni\u0301o", 381);
    freq.put("re\u0301", 439);
    freq.put("e\u0301to", 45);
    freq.put("iva", 583);
    freq.put("e\u0301ti", 230);
    freq.put("ivo", 214);
    freq.put("ivi", 548);
    freq.put("ivu", 395);
    freq.put("e\u0301tr", 86);
    freq.put("\u03b4", 32);
    freq.put("XV ", 19);
    freq.put("uic", 49);
    freq.put("I", 2318);
    freq.put(" gu", 251);
    freq.put(" gr", 1347);
    freq.put("ezo\u0301", 34);
    freq.put("\u0628\u0646", 16);
    freq.put("Mah", 23);
    freq.put("aca\u0301", 31);
    freq.put("aci\u0301", 258);
    freq.put("oni\u0301", 81);
    freq.put("ezu", 171);
    freq.put("ezo", 33);
    freq.put("eza", 178);
    freq.put("ac ", 57);
    freq.put("ez ", 753);
    freq.put("acc", 115);
    freq.put("aca", 226);
    freq.put("ace", 438);
    freq.put("ack", 44);
    freq.put("aci", 4313);
    freq.put("ach", 273);
    freq.put("aco", 207);
    freq.put("acr", 73);
    freq.put("acu", 221);
    freq.put("act", 589);
    freq.put("Ni", 195);
    freq.put("No", 439);
    freq.put("ae\u0301", 45);
    freq.put("Na", 772);
    freq.put("ai\u0301", 656);
    freq.put("Ne", 361);
    freq.put("an\u0303", 2538);
    freq.put("Ny", 19);
    freq.put("\u0629 ", 33);
    freq.put("au\u0301", 55);
    freq.put("Nu", 303);
    freq.put("het", 33);
    freq.put("\u043e\u0432\u0438", 18);
    freq.put("her", 228);
    freq.put("hes", 313);
    freq.put("hez", 21);
    freq.put("\u0432", 69);
    freq.put("hea", 29);
    freq.put("heb", 47);
    freq.put("L\u0323", 79);
    freq.put("hel", 72);
    freq.put("hem", 44);
    freq.put("hen", 86);
    freq.put("heo", 26);
    freq.put("hei", 75);
    freq.put("N ", 176);
    freq.put("agm", 16);
    freq.put("rxi\u0301", 89);
    freq.put("he ", 252);
    freq.put("aa", 87);
    freq.put("ac", 6900);
    freq.put("ab", 3403);
    freq.put("ae", 1725);
    freq.put("ad", 5915);
    freq.put("ag", 1628);
    freq.put("af", 651);
    freq.put("Hon", 31);
    freq.put("ah", 219);
    freq.put("Hol", 43);
    freq.put("aj", 78);
    freq.put("am", 5954);
    freq.put("al", 17756);
    freq.put("ao", 1411);
    freq.put("an", 16906);
    freq.put("aq", 317);
    freq.put(" n\u0303a", 125);
    freq.put("Hot", 20);
    freq.put("ar", 14281);
    freq.put("Hor", 49);
    freq.put("at", 4525);
    freq.put("aw", 106);
    freq.put("av", 1502);
    freq.put("ay", 1558);
    freq.put("ax", 886);
    freq.put("az", 683);
    freq.put("uis", 259);
    freq.put("ui\u0301", 345);
    freq.put("rx ", 16);
    freq.put("a ", 66473);
    freq.put("rxi", 68);
    freq.put("at ", 133);
    freq.put("rxa", 28);
    freq.put("rxe", 184);
    freq.put("uit", 193);
    freq.put("scl", 35);
    freq.put("sco", 412);
    freq.put("sci", 99);
    freq.put("sch", 82);
    freq.put("Fit", 17);
    freq.put("sce", 102);
    freq.put("sca", 333);
    freq.put("mnu", 77);
    freq.put("Fig", 20);
    freq.put("Fie", 21);
    freq.put("scu", 831);
    freq.put("mna", 17);
    freq.put("Fin", 36);
    freq.put("Fil", 53);
    freq.put("scr", 640);
    freq.put("rd", 1560);
    freq.put("tz", 63);
    freq.put("ty", 84);
    freq.put("tw", 95);
    freq.put("tt", 330);
    freq.put("tu", 9234);
    freq.put("tr", 6832);
    freq.put("ts", 218);
    freq.put("tp", 31);
    freq.put("tn", 84);
    freq.put("to", 5972);
    freq.put("tl", 210);
    freq.put("tm", 109);
    freq.put("th", 571);
    freq.put("ti", 9885);
    freq.put("tg", 22);
    freq.put("Eas", 18);
    freq.put("te", 17497);
    freq.put("tb", 202);
    freq.put("tc", 82);
    freq.put("ta", 12924);
    freq.put("smi", 66);
    freq.put("sme", 31);
    freq.put("dsc", 21);
    freq.put("t ", 1178);
    freq.put("Smi", 26);
    freq.put("scu\u0301", 17);
    freq.put("sco\u0301", 21);
    freq.put("tu\u0301", 252);
    freq.put("xos", 140);
    freq.put("uen\u0303", 164);
    freq.put("uiz", 171);
    freq.put("to\u0301", 1018);
    freq.put("ti\u0301", 1208);
    freq.put("te\u0301", 487);
    freq.put("xon", 149);
    freq.put("ta\u0301", 1565);
    freq.put("se\u0301u", 50);
    freq.put("xo ", 155);
    freq.put("vic", 148);
    freq.put("via", 373);
    freq.put("Aud", 16);
    freq.put("Aug", 50);
    freq.put("vie", 629);
    freq.put("vin", 700);
    freq.put("vio", 72);
    freq.put("vil", 398);
    freq.put("vim", 221);
    freq.put("vir", 102);
    freq.put("vis", 594);
    freq.put("Aus", 76);
    freq.put("Aur", 35);
    freq.put("viv", 174);
    freq.put("Aut", 113);
    freq.put("vit", 53);
    freq.put("vix", 21);
    freq.put(" S", 4430);
    freq.put(" d ", 6215);
    freq.put("vi ", 22);
    freq.put(" do", 630);
    freq.put("kla", 21);
    freq.put(" di", 2258);
    freq.put(" de", 35763);
    freq.put(" da", 670);
    freq.put(" du", 135);
    freq.put(" dr", 126);
    freq.put("ei\u0301n", 19);
    freq.put("vie\u0301", 397);
    freq.put("vio\u0301", 39);
    freq.put("xug", 59);
    freq.put("atr", 379);
    freq.put("uxi", 17);
    freq.put("xua", 40);
    freq.put("ah\u0323", 18);
    freq.put("xul", 25);
    freq.put("al\u0323", 21);
    freq.put("xun", 874);
    freq.put(" di\u0301", 97);
    freq.put(" de\u0301", 79);
    freq.put(" da\u0301", 16);
    freq.put(" do\u0301", 88);
    freq.put("ito", 910);
    freq.put("itm", 29);
    freq.put("ith", 35);
    freq.put("iti", 852);
    freq.put("ite", 659);
    freq.put("ita", 1871);
    freq.put("itz", 19);
    freq.put("ity", 31);
    freq.put("itt", 52);
    freq.put("itu", 991);
    freq.put("itr", 63);
    freq.put("its", 29);
    freq.put("it ", 78);
    freq.put("tro", 1130);
    freq.put(" My", 27);
    freq.put(" A ", 220);
    freq.put("iti\u0301", 37);
    freq.put("ite\u0301", 24);
    freq.put("ita\u0301", 206);
    freq.put("itu\u0301", 183);
    freq.put("ito\u0301", 22);
    freq.put("ftw", 73);
    freq.put(" Aa", 18);
    freq.put(" Ab", 133);
    freq.put(" Ac", 163);
    freq.put(" Ad", 121);
    freq.put(" Ae", 37);
    freq.put(" Af", 83);
    freq.put(" Ag", 95);
    freq.put(" Ai", 68);
    freq.put(" Ak", 22);
    freq.put(" Al", 968);
    freq.put(" Am", 340);
    freq.put(" An", 718);
    freq.put(" Ap", 88);
    freq.put(" Aq", 27);
    freq.put(" Ar", 674);
    freq.put(" As", 1170);
    freq.put(" At", 261);
    freq.put(" Au", 313);
    freq.put(" Av", 136);
    freq.put(" Ay", 84);
    freq.put(" Az", 40);
    freq.put("tru", 853);
    freq.put("ft ", 35);
    freq.put("w", 1009);
    freq.put("uem", 17);
    freq.put("Fra", 380);
    freq.put("o\u0301xe", 27);
    freq.put("Fre", 84);
    freq.put("o\u0301xi", 194);
    freq.put("\u043e\u0432", 36);
    freq.put("xis", 134);
    freq.put("\u043a", 77);
    freq.put("ueg", 226);
    freq.put("\u3042", 49);
    freq.put("a\u0301go", 20);
    freq.put("exi\u0301", 39);
    freq.put("exe\u0301", 36);
    freq.put("exo\u0301", 280);
    freq.put("\u043e\u0440", 16);
    freq.put("n\u0303vo", 29);
    freq.put("uez", 85);
    freq.put("uet", 87);
    freq.put("ex ", 83);
    freq.put("tp ", 31);
    freq.put("Xur", 37);
    freq.put("Isr", 30);
    freq.put("M", 3997);
    freq.put("Xue", 46);
    freq.put("Xua", 63);
    freq.put("Isl", 207);
    freq.put("Xul", 17);
    freq.put("Isa", 21);
    freq.put("a\u0302", 27);
    freq.put("ema\u0301", 297);
    freq.put("exa", 173);
    freq.put("exo", 116);
    freq.put("exi", 207);
    freq.put("ext", 41);
    freq.put("exu", 139);
    freq.put("exp", 22);
    freq.put("Hai", 19);
    freq.put("ugh", 22);
    freq.put("ugo", 63);
    freq.put("Ham", 28);
    freq.put("Han", 32);
    freq.put("ugl", 18);
    freq.put(" o\u0301r", 60);
    freq.put("Hab", 19);
    freq.put("uge", 29);
    freq.put("Har", 45);
    freq.put("ugu", 221);
    freq.put("rf ", 71);
    freq.put("cru", 73);
    freq.put("rfa", 33);
    freq.put("a\u0301s ", 1340);
    freq.put("rfe", 22);
    freq.put("cre", 425);
    freq.put("rfi", 180);
    freq.put("cri", 790);
    freq.put("rfo", 27);
    freq.put("cro", 165);
    freq.put("seu", 46);
    freq.put("set", 310);
    freq.put("ses", 588);
    freq.put("ser", 1024);
    freq.put("For", 163);
    freq.put("sep", 148);
    freq.put("uga\u0301", 200);
    freq.put("o\u0301gr", 26);
    freq.put("sey", 126);
    freq.put("sex", 73);
    freq.put("seg", 362);
    freq.put("sef", 18);
    freq.put("see", 42);
    freq.put("sed", 84);
    freq.put("sec", 144);
    freq.put("seo", 31);
    freq.put("sen", 849);
    freq.put("Fon", 52);
    freq.put("sel", 216);
    freq.put("Foi", 290);
    freq.put("sei", 86);
    freq.put("u\u0301mb", 452);
    freq.put("ue ", 5100);
    freq.put("se ", 3219);
    freq.put("cro\u0301", 32);
    freq.put("cra\u0301", 64);
    freq.put("cri\u0301", 53);
    freq.put("uil", 164);
    freq.put("lex", 207);
    freq.put("xap", 148);
    freq.put("xar", 66);
    freq.put("xas", 34);
    freq.put("tiv", 1016);
    freq.put("xal", 17);
    freq.put("xam", 25);
    freq.put("xan", 121);
    freq.put("xac", 30);
    freq.put("xad", 16);
    freq.put("tre\u0301", 72);
    freq.put("nri", 119);
    freq.put("nre", 22);
    freq.put("nry", 23);
    freq.put("an\u0303i\u0301", 40);
    freq.put(" fo\u0301", 20);
    freq.put("ctr", 215);
    freq.put("Oli", 23);
    freq.put(" fu\u0301", 101);
    freq.put(" fa\u0301", 42);
    freq.put("xa ", 218);
    freq.put(" fi\u0301", 240);
    freq.put("voc", 107);
    freq.put("vol", 296);
    freq.put("von", 28);
    freq.put("vot", 23);
    freq.put("vor", 37);
    freq.put("vos", 258);
    freq.put("voz", 24);
    freq.put("So ", 27);
    freq.put("an\u0303u", 434);
    freq.put("an\u0303v", 25);
    freq.put("vo ", 182);
    freq.put("an\u0303e", 63);
    freq.put("an\u0303a", 801);
    freq.put("an\u0303o", 1127);
    freq.put("tro\u0301", 149);
    freq.put("lxi", 36);
    freq.put("Soc", 100);
    freq.put("Sob", 43);
    freq.put(" fu", 910);
    freq.put("Sof", 29);
    freq.put("Som", 39);
    freq.put("Sol", 85);
    freq.put("Son", 62);
    freq.put(" fa", 1511);
    freq.put("Sor", 72);
    freq.put(" fe", 673);
    freq.put("Sot", 51);
    freq.put("Sov", 37);
    freq.put(" fi", 812);
    freq.put(" fl", 168);
    freq.put(" fo", 2593);
    freq.put("O ", 157);
    freq.put("ams", 19);
    freq.put(" \u4e4b", 31);
    freq.put("na\u0301n", 59);
    freq.put("na\u0301m", 16);
    freq.put("na\u0301u", 207);
    freq.put("On", 77);
    freq.put("Ol", 72);
    freq.put(" \u4e26", 19);
    freq.put("ba\u0301", 129);
    freq.put("Oh", 17);
    freq.put("Of", 33);
    freq.put("Oe", 36);
    freq.put("Oc", 326);
    freq.put("Ob", 97);
    freq.put("Oz", 26);
    freq.put("bo\u0301", 90);
    freq.put("Ov", 26);
    freq.put("Ou", 40);
    freq.put("Ot", 28);
    freq.put("Os", 62);
    freq.put("Or", 275);
    freq.put("bu\u0301", 40);
    freq.put("Op", 34);
    freq.put(" \u4e01", 25);
    freq.put("d", 74946);
    freq.put(" \u4e09", 31);
    freq.put(" \u4e18", 23);
    freq.put("IV ", 26);
    freq.put("iji", 19);
    freq.put("Vel", 24);
    freq.put("bd", 49);
    freq.put("be", 2349);
    freq.put("bf", 18);
    freq.put("bg", 20);
    freq.put("ba", 2582);
    freq.put("bb", 40);
    freq.put("afi\u0301", 85);
    freq.put("bl", 2379);
    freq.put("bn", 23);
    freq.put("bo", 1303);
    freq.put("bi", 2410);
    freq.put("bt", 46);
    freq.put("bu", 820);
    freq.put("br", 3252);
    freq.put("bs", 132);
    freq.put("bx", 16);
    freq.put("by", 33);
    freq.put("Fu", 162);
    freq.put("DE ", 25);
    freq.put("Osc", 35);
    freq.put("ME ", 25);
    freq.put(" C ", 56);
    freq.put("ci ", 16);
    freq.put("u ", 34455);
    freq.put("Fe", 384);
    freq.put(" Ch", 550);
    freq.put(" Ci", 308);
    freq.put(" Co", 1643);
    freq.put(" Cl", 195);
    freq.put(" Ca", 2126);
    freq.put(" Ce", 265);
    freq.put(" Cy", 23);
    freq.put("Fi", 204);
    freq.put(" Cr", 257);
    freq.put("zan", 101);
    freq.put(" Cu", 396);
    freq.put("cic", 126);
    freq.put("cib", 98);
    freq.put("cia", 3357);
    freq.put("AC ", 16);
    freq.put("uy", 480);
    freq.put("cif", 30);
    freq.put("cie", 1716);
    freq.put("cid", 742);
    freq.put("uu", 115);
    freq.put("ut", 2411);
    freq.put("uv", 238);
    freq.put("cio", 2136);
    freq.put("cin", 365);
    freq.put("cim", 193);
    freq.put("cil", 77);
    freq.put("cis", 205);
    freq.put("cir", 200);
    freq.put("uo", 119);
    freq.put("cip", 752);
    freq.put("ui", 2854);
    freq.put("civ", 55);
    freq.put("ciu", 1086);
    freq.put("cit", 125);
    freq.put("ue", 10521);
    freq.put("ud", 1700);
    freq.put("ug", 1301);
    freq.put("uf", 132);
    freq.put("ago\u0301", 59);
    freq.put("uc", 1521);
    freq.put("ub", 1204);
    freq.put("l\u0323l\u0323e", 16);
    freq.put("l\u0323l\u0323a", 57);
    freq.put("l\u0323l\u0323o", 17);
    freq.put("\u03b8", 22);
    freq.put(" Ce\u0301", 23);
    freq.put(" Ca\u0301", 78);
    freq.put(" Co\u0301", 39);
    freq.put("ago", 481);
    freq.put("agn", 155);
    freq.put("cia\u0301", 67);
    freq.put("agi", 26);
    freq.put("age", 58);
    freq.put("un\u0303", 316);
    freq.put("aga", 263);
    freq.put("cio\u0301", 3771);
    freq.put("ue\u0301", 424);
    freq.put("agu", 314);
    freq.put("ua\u0301", 76);
    freq.put("agr", 146);
    freq.put("odi\u0301", 28);
    freq.put("pul", 280);
    freq.put("b ", 338);
    freq.put("len\u0303", 19);
    freq.put("leo\u0301", 114);
    freq.put("tri", 1075);
    freq.put("evi", 415);
    freq.put("rdo\u0301", 25);
    freq.put("evo", 192);
    freq.put("tra", 2003);
    freq.put("eva", 447);
    freq.put("tre", 1373);
    freq.put("eve", 219);
    freq.put("ctu\u0301", 20);
    freq.put("cta\u0301", 25);
    freq.put("rdi\u0301", 55);
    freq.put("rde\u0301", 27);
    freq.put("evu", 71);
    freq.put("o\u0301di", 173);
    freq.put("le ", 744);
    freq.put("uel", 618);
    freq.put("ueo", 29);
    freq.put("uen", 644);
    freq.put("uei", 50);
    freq.put("ued", 156);
    freq.put("odr", 60);
    freq.put("odu", 533);
    freq.put("uec", 126);
    freq.put("ueb", 280);
    freq.put("odi", 283);
    freq.put("Blo", 24);
    freq.put("uey", 80);
    freq.put("odo", 127);
    freq.put("ueu", 62);
    freq.put("oda", 92);
    freq.put("uev", 377);
    freq.put("Bla", 45);
    freq.put("ode", 318);
    freq.put("ues", 1317);
    freq.put("uer", 1052);
    freq.put("rd ", 161);
    freq.put("lea", 220);
    freq.put("leb", 126);
    freq.put("lec", 375);
    freq.put("led", 49);
    freq.put("lee", 30);
    freq.put("lef", 34);
    freq.put("leg", 388);
    freq.put("lei", 210);
    freq.put("lej", 20);
    freq.put("lel", 37);
    freq.put("lem", 666);
    freq.put("len", 891);
    freq.put("leo", 121);
    freq.put("lep", 22);
    freq.put("ler", 297);
    freq.put("les", 5112);
    freq.put("let", 267);
    freq.put("leu", 145);
    freq.put("lev", 325);
    freq.put("od ", 33);
    freq.put("ley", 109);
    freq.put("lez", 115);
    freq.put("rdu", 91);
    freq.put("ctu", 415);
    freq.put("tri\u0301", 68);
    freq.put("rds", 19);
    freq.put("tra\u0301", 83);
    freq.put("cno", 23);
    freq.put("rde", 504);
    freq.put("cte", 85);
    freq.put("rda", 226);
    freq.put("cta", 143);
    freq.put("rdo", 136);
    freq.put("cto", 436);
    freq.put("rdi", 270);
    freq.put("cti", 288);
    freq.put("sgo", 19);
    freq.put("zia", 21);
    freq.put("zil", 23);
    freq.put("\u043e", 143);
    freq.put("Oni\u0301", 35);
    freq.put("zi ", 25);
    freq.put("ro\u0301 ", 59);
    freq.put("cni", 45);
    freq.put("\u03bc", 58);
    freq.put("o\u0302", 18);
    freq.put("ro\u0301l", 19);
    freq.put("ro\u0301n", 221);
    freq.put("ro\u0301g", 16);
    freq.put("Q", 208);
    freq.put("afo", 65);
    freq.put("ro\u0301x", 33);
    freq.put("Pin\u0303", 30);
    freq.put("ro\u0301p", 50);
    freq.put("ro\u0301s", 57);
    freq.put("aff", 21);
    freq.put("u\u0301l", 114);
    freq.put("u\u0301m", 466);
    freq.put("u\u0301n", 761);
    freq.put("u\u0301i", 105);
    freq.put("Aye", 67);
    freq.put("u\u0301e", 28);
    freq.put("u\u0301g", 67);
    freq.put("u\u0301a", 53);
    freq.put("u\u0301b", 451);
    freq.put("u\u0301c", 56);
    freq.put("X", 1855);
    freq.put("u\u0301t", 137);
    freq.put("L\u0323l\u0323e", 36);
    freq.put("u\u0301p", 19);
    freq.put("L\u0323l\u0323a", 21);
    freq.put("u\u0301r", 48);
    freq.put("u\u0301s", 323);
    freq.put(" h ", 17);
    freq.put("e\u0302\u0309", 41);
    freq.put("u\u0301 ", 319);
    freq.put("lza", 17);
    freq.put("n\u0303o\u0301", 41);
    freq.put("San", 701);
    freq.put("Sam", 134);
    freq.put("Sal", 217);
    freq.put("Sac", 18);
    freq.put("Sab", 33);
    freq.put(" hu", 180);
    freq.put(" ht", 26);
    freq.put("n\u0303a\u0301", 34);
    freq.put(" hi", 352);
    freq.put("Sax", 16);
    freq.put(" ho", 336);
    freq.put("Sar", 41);
    freq.put(" ha", 963);
    freq.put("n\u0303i\u0301", 42);
    freq.put("Sav", 16);
    freq.put("Sau", 30);
    freq.put("Sat", 16);
    freq.put("nc\u0327o", 17);
    freq.put("\u0438\u0447 ", 23);
    freq.put("el\u0323l\u0323", 35);
    freq.put("\u094d", 20);
    freq.put(" hu\u0301", 19);
    freq.put("n\u0303u", 586);
    freq.put("n\u0303v", 29);
    freq.put("\u05ea", 16);
    freq.put("n\u0303a", 1554);
    freq.put("pa\u0301x", 23);
    freq.put("n\u0303e", 252);
    freq.put("n\u0303i", 29);
    freq.put("n\u0303o", 1292);
    freq.put("ta\u0301t", 22);
    freq.put("ta\u0301u", 735);
    freq.put("ta\u0301r", 37);
    freq.put("e\u0301nt", 114);
    freq.put("e\u0301ni", 28);
    freq.put("ta\u0301b", 66);
    freq.put("ta\u0301c", 42);
    freq.put("e\u0301nd", 141);
    freq.put("e\u0301ne", 263);
    freq.put("ta\u0301n", 435);
    freq.put("ta\u0301 ", 163);
    freq.put("e\u0301n ", 885);
    freq.put(" E ", 22);
    freq.put("ck ", 203);
    freq.put(" El", 2296);
    freq.put(" Em", 98);
    freq.put(" En", 476);
    freq.put(" Eo", 32);
    freq.put(" Ei", 40);
    freq.put(" Ed", 145);
    freq.put(" Ea", 30);
    freq.put(" Ec", 65);
    freq.put(" Ex", 95);
    freq.put("Ca\u0301m", 20);
    freq.put(" Et", 46);
    freq.put(" Eu", 374);
    freq.put(" Ev", 36);
    freq.put(" Ep", 27);
    freq.put(" Er", 108);
    freq.put(" Es", 1857);
    freq.put("cke", 26);
    freq.put("Pu\u0301", 19);
    freq.put("VI ", 43);
    freq.put("\u0410", 21);
    freq.put("Pa\u0301", 22);
    freq.put("Pe\u0301", 50);
    freq.put("jar", 22);
    freq.put("jan", 19);
    freq.put("ae ", 297);
    freq.put("jal", 17);
    freq.put("O\u0301", 24);
    freq.put("eto\u0301", 24);
    freq.put("aes", 1074);
    freq.put("aer", 52);
    freq.put("h", 8481);
    freq.put("aez", 42);
    freq.put("aec", 62);
    freq.put("eta\u0301", 100);
    freq.put("aed", 22);
    freq.put("ael", 85);
    freq.put("ja ", 38);
    freq.put("eti\u0301", 20);
    freq.put("Pr", 850);
    freq.put("Ps", 21);
    freq.put("Pu", 224);
    freq.put("C", 6230);
    freq.put("Pa", 1151);
    freq.put("Pe", 650);
    freq.put("Ph", 48);
    freq.put("Pi", 285);
    freq.put("Po", 623);
    freq.put("Pl", 156);
    freq.put("\u0627", 129);
    freq.put("et ", 160);
    freq.put("lf", 261);
    freq.put("tso", 27);
    freq.put("P ", 125);
    freq.put("eun", 48);
    freq.put("etr", 526);
    freq.put("ets", 17);
    freq.put("ett", 71);
    freq.put("etu", 477);
    freq.put("etc", 56);
    freq.put("tla", 53);
    freq.put("eta", 703);
    freq.put("tle", 35);
    freq.put("ete", 546);
    freq.put("eth", 42);
    freq.put("eti", 467);
    freq.put("etn", 56);
    freq.put("eto", 130);
    freq.put("ck", 308);
    freq.put("va\u0301", 55);
    freq.put("ci", 15167);
    freq.put("ren\u0303", 61);
    freq.put("co", 14574);
    freq.put("cn", 68);
    freq.put("Her", 145);
    freq.put("Hes", 42);
    freq.put("cc", 810);
    freq.put("ve\u0301", 44);
    freq.put("ca", 10319);
    freq.put("vi\u0301", 165);
    freq.put("ce", 4935);
    freq.put("cy", 31);
    freq.put("vo\u0301", 19);
    freq.put("ucc", 145);
    freq.put("euc", 35);
    freq.put("uca", 114);
    freq.put("cs", 28);
    freq.put("cr", 1734);
    freq.put("cq", 16);
    freq.put("ucl", 99);
    freq.put("uck", 19);
    freq.put("Hei", 77);
    freq.put("cu", 6334);
    freq.put("ct", 1665);
    freq.put("Ger", 27);
    freq.put("gu\u0308i\u0301", 94);
    freq.put("wto", 18);
    freq.put("Geo", 41);
    freq.put("Gen", 26);
    freq.put("lgo", 48);
    freq.put("lga", 238);
    freq.put("lgu", 145);
    freq.put("tsu", 45);
    freq.put("rbu", 32);
    freq.put("ofi\u0301", 54);
    freq.put("rbo", 153);
    freq.put("lx", 50);
    freq.put("rbi", 150);
    freq.put("rbe", 63);
    freq.put("eur", 170);
    freq.put("rba", 139);
    freq.put("va", 2366);
    freq.put("ce\u0301", 536);
    freq.put("ve", 2879);
    freq.put("ci\u0301", 1173);
    freq.put("vi", 4435);
    freq.put("ca\u0301", 435);
    freq.put("ph ", 41);
    freq.put("vo", 979);
    freq.put("cu\u0301", 62);
    freq.put("vu", 587);
    freq.put("co\u0301", 261);
    freq.put("uci\u0301", 83);
    freq.put("of ", 99);
    freq.put("u\u0301in", 21);
    freq.put("gu\u0308e", 334);
    freq.put("v ", 81);
    freq.put("phi", 49);
    freq.put("pho", 38);
    freq.put("yon", 31);
    freq.put("pha", 40);
    freq.put("lgu\u0301", 27);
    freq.put("ea\u0301u", 69);
    freq.put("phu", 20);
    freq.put("ofe", 178);
    freq.put("ofi", 306);
    freq.put("rbo\u0301", 30);
    freq.put("ofo", 30);
    freq.put("ofr", 20);
    freq.put("oft", 90);
    freq.put("ofu", 44);
    freq.put("dap", 18);
    freq.put("xef", 32);
    freq.put("xeb", 87);
    freq.put("xec", 44);
    freq.put("xel", 95);
    freq.put("xem", 87);
    freq.put("xen", 777);
    freq.put("xeo", 211);
    freq.put("xei", 22);
    freq.put("gun", 353);
    freq.put("xet", 191);
    freq.put("xer", 217);
    freq.put("xes", 204);
    freq.put("web", 33);
    freq.put("dax", 23);
    freq.put("wen", 23);
    freq.put("wel", 41);
    freq.put("nvu", 23);
    freq.put("xe ", 407);
    freq.put("gul", 160);
    freq.put("Sai", 48);
    freq.put("nve", 188);
    freq.put("nva", 32);
    freq.put("nvo", 60);
    freq.put("nvi", 86);
    freq.put("igl", 41);
    freq.put("Uiq", 18);
    freq.put("lle", 1836);
    freq.put("nvi\u0301", 52);
    freq.put("hi\u0301a", 18);
    freq.put("Sco", 27);
    freq.put("Sch", 61);
    freq.put(" ju", 24);
    freq.put("I\u0301nd", 31);
    freq.put(" he", 401);
    freq.put(" ja", 29);
    freq.put("Scr", 21);
    freq.put("ino\u0301", 76);
    freq.put("ini\u0301", 25);
    freq.put("ine\u0301", 32);
    freq.put("ina\u0301", 145);
    freq.put("pu\u0301b", 411);
    freq.put("un\u0303a", 231);
    freq.put("un\u0303e", 25);
    freq.put("un\u0303u", 21);
    freq.put("va\u0301u", 28);
    freq.put("inx", 69);
    freq.put("iny", 54);
    freq.put("int", 1059);
    freq.put("inu", 633);
    freq.put("inv", 138);
    freq.put("inr", 50);
    freq.put("ins", 298);
    freq.put("inl", 40);
    freq.put("inm", 46);
    freq.put("inn", 37);
    freq.put("ino", 436);
    freq.put("inh", 27);
    freq.put("ini", 727);
    freq.put("ink", 21);
    freq.put("ind", 622);
    freq.put("ine", 942);
    freq.put("inf", 339);
    freq.put("ing", 1424);
    freq.put("ina", 1852);
    freq.put("inc", 1433);
    freq.put("eo ", 106);
    freq.put("un\u0303o\u0301", 18);
    freq.put("Xes", 46);
    freq.put("U", 1459);
    freq.put("uos", 40);
    freq.put("in ", 702);
    freq.put("eoc", 31);
    freq.put("eog", 87);
    freq.put("eod", 40);
    freq.put("e\u0302", 17);
    freq.put("eon", 112);
    freq.put("eom", 46);
    freq.put("eol", 200);
    freq.put("eos", 170);
    freq.put("eor", 152);
    freq.put("eop", 30);
    freq.put("eox", 20);
    freq.put("Tur", 79);
    freq.put("ret", 359);
    freq.put(" G ", 22);
    freq.put("le\u0301", 577);
    freq.put("e\u0301l ", 50);
    freq.put("\u03b5\u0301", 19);
    freq.put("a\u0303o ", 34);
    freq.put("ald", 291);
    freq.put("lo\u0301", 552);
    freq.put(" Gu", 362);
    freq.put(" Gr", 549);
    freq.put(" Ge", 129);
    freq.put(" Ga", 503);
    freq.put(" Go", 304);
    freq.put(" Gl", 33);
    freq.put(" Gh", 17);
    freq.put(" Gi", 108);
    freq.put("gle\u0301", 259);
    freq.put("e\u0301le", 21);
    freq.put("e\u0301la", 55);
    freq.put("lu\u0301", 165);
    freq.put("e\u0301li", 91);
    freq.put("e\u0301lu", 33);
    freq.put("e\u0301lx", 24);
    freq.put("a\u0304", 47);
    freq.put("ptu", 45);
    freq.put("teo\u0301", 25);
    freq.put("\u062f", 46);
    freq.put("ak ", 34);
    freq.put("a\u0301i ", 95);
    freq.put("e\u0300r", 20);
    freq.put(" Gu\u0308", 19);
    freq.put("e\u0300n", 16);
    freq.put("sle", 17);
    freq.put("gli", 36);
    freq.put("glo", 127);
    freq.put("gla", 163);
    freq.put("\u30a2\u30a2\u30a2", 37);
    freq.put("aku", 29);
    freq.put("aki", 29);
    freq.put("ako", 31);
    freq.put("aka", 48);
    freq.put("glu", 274);
    freq.put("ake", 46);
    freq.put("nk ", 61);
    freq.put("Jes", 23);
    freq.put("ix", 1136);
    freq.put("uan\u0303", 238);
    freq.put("bru", 194);
    freq.put("bro", 224);
    freq.put("Jea", 39);
    freq.put("bri", 654);
    freq.put("bre", 1454);
    freq.put("bra", 615);
    freq.put("er ", 2353);
    freq.put("io\u0301 ", 500);
    freq.put("nka", 16);
    freq.put("nke", 19);
    freq.put("iu", 3382);
    freq.put("iw", 20);
    freq.put("iv", 2401);
    freq.put("tmo", 31);
    freq.put("ert", 1414);
    freq.put("ii", 49);
    freq.put("erv", 268);
    freq.put("erp", 200);
    freq.put("err", 1371);
    freq.put("ers", 1019);
    freq.put("io\u0301s", 50);
    freq.put("erx", 115);
    freq.put("ery", 22);
    freq.put("erz", 47);
    freq.put("erd", 389);
    freq.put("ere", 1037);
    freq.put("erf", 215);
    freq.put("erg", 196);
    freq.put("tna", 35);
    freq.put("io\u0301n", 4842);
    freq.put("erb", 152);
    freq.put("erc", 664);
    freq.put("erl", 74);
    freq.put("im", 3159);
    freq.put("ern", 1035);
    freq.put("ero", 1415);
    freq.put("tni", 28);
    freq.put("eri", 2122);
    freq.put("erk", 19);
    freq.put("uay", 36);
    freq.put("Aba", 32);
    freq.put("Abd", 19);
    freq.put("io", 5169);
    freq.put("uas", 43);
    freq.put("in", 11286);
    freq.put("bro\u0301", 20);
    freq.put("uat", 154);
    freq.put("Abo", 16);
    freq.put("Abr", 17);
    freq.put("uam", 22);
    freq.put("ual", 644);
    freq.put("bre\u0301", 40);
    freq.put("uan", 493);
    freq.put("uac", 68);
    freq.put("uad", 195);
    freq.put("bra\u0301", 36);
    freq.put("ib", 1506);
    freq.put("i\u0304", 46);
    freq.put("lal", 27);
    freq.put("lam", 472);
    freq.put("lan", 1708);
    freq.put("lao", 80);
    freq.put("lah", 26);
    freq.put("lai", 47);
    freq.put("lak", 20);
    freq.put("lad", 292);
    freq.put("lae", 49);
    freq.put("lag", 169);
    freq.put("lab", 346);
    freq.put("lac", 858);
    freq.put("lax", 35);
    freq.put("lay", 82);
    freq.put("laz", 87);
    freq.put("lat", 593);
    freq.put("lau", 95);
    freq.put("lav", 219);
    freq.put("lap", 18);
    freq.put("lar", 969);
    freq.put("las", 480);
    freq.put("ero\u0301", 89);
    freq.put("eru\u0301", 55);
    freq.put("era\u0301", 172);
    freq.put("eri\u0301", 373);
    freq.put("ere\u0301", 34);
    freq.put("zer", 22);
    freq.put("u\u0301ga", 65);
    freq.put("ze ", 17);
    freq.put("\u0142", 28);
    freq.put("nto\u0301", 241);
    freq.put("nte\u0301", 37);
    freq.put("nti\u0301", 169);
    freq.put("e\u0301an", 166);
    freq.put("nta\u0301", 191);
    freq.put("l", 96745);
    freq.put("\u0301", 21);
    freq.put("ta\u0301l", 35);
    freq.put("nt ", 170);
    freq.put("Pai\u0301", 74);
    freq.put("ntr", 1543);
    freq.put("ntu", 1864);
    freq.put("nti", 1252);
    freq.put("nth", 29);
    freq.put("nto", 1025);
    freq.put("nta", 2566);
    freq.put("nte", 6881);
    freq.put("ba\u0301u", 28);
    freq.put("ba\u0301s", 60);
    freq.put("i\u0301tu", 78);
    freq.put("i\u0301ti", 630);
    freq.put(" l ", 4468);
    freq.put("Eo ", 22);
    freq.put("cu\u0301b", 21);
    freq.put("teo", 106);
    freq.put(" le", 2015);
    freq.put("B", 2871);
    freq.put("uip", 135);
    freq.put(" la", 9405);
    freq.put(" lo", 3369);
    freq.put(" ll", 3737);
    freq.put(" li", 83);
    freq.put(" lu", 75);
    freq.put("nbu", 21);
    freq.put("cu\u0301 ", 17);
    freq.put("teg", 178);
    freq.put("Sev", 22);
    freq.put("Ser", 107);
    freq.put("Seg", 140);
    freq.put("See", 18);
    freq.put("Sec", 18);
    freq.put("Seb", 20);
    freq.put("Sen", 43);
    freq.put("Sel", 60);
    freq.put("teu", 84);
    freq.put("\u03c0", 31);
    freq.put("Qu", 164);
    freq.put(" li\u0301", 58);
    freq.put("Qa", 19);
    freq.put("U\u0301lt", 30);
    freq.put("uda", 185);
    freq.put("d ", 7292);
    freq.put("em ", 51);
    freq.put("do\u0301s", 17);
    freq.put("do\u0301n", 51);
    freq.put("do\u0301l", 40);
    freq.put("do\u0301m", 56);
    freq.put("hri", 80);
    freq.put("do", 4104);
    freq.put("dl", 26);
    freq.put("dm", 25);
    freq.put("dh", 40);
    freq.put("di", 6449);
    freq.put("dg", 41);
    freq.put("dd", 45);
    freq.put("de", 42222);
    freq.put("da", 7569);
    freq.put("dy", 49);
    freq.put("dv", 20);
    freq.put("dw", 55);
    freq.put("dt", 28);
    freq.put("du", 1858);
    freq.put("dr", 1181);
    freq.put("ds", 122);
    freq.put("eme", 716);
    freq.put("ema", 857);
    freq.put("ila\u0301", 23);
    freq.put("emo", 253);
    freq.put("ili\u0301", 37);
    freq.put("emi", 599);
    freq.put("dC", 108);
    freq.put("ile\u0301", 76);
    freq.put("PA ", 28);
    freq.put("emp", 1046);
    freq.put("do\u0301 ", 33);
    freq.put("\u4e07", 23);
    freq.put("w ", 125);
    freq.put(" I ", 93);
    freq.put("il ", 604);
    freq.put("xe\u0301n", 194);
    freq.put("co ", 611);
    freq.put("xe\u0301r", 50);
    freq.put("xe\u0301u", 30);
    freq.put("we", 153);
    freq.put("di\u0301", 429);
    freq.put("wa", 291);
    freq.put("de\u0301", 316);
    freq.put("wo", 59);
    freq.put("wn", 29);
    freq.put(" Ir", 117);
    freq.put(" Is", 312);
    freq.put(" It", 87);
    freq.put("wi", 162);
    freq.put("da\u0301", 2598);
    freq.put("ww", 48);
    freq.put("wt", 19);
    freq.put(" Il", 150);
    freq.put(" Im", 105);
    freq.put(" In", 766);
    freq.put(" Ib", 96);
    freq.put(" Id", 18);
    freq.put("do\u0301", 215);
    freq.put(" Ig", 27);
    freq.put("cop", 62);
    freq.put("ild", 25);
    freq.put("ile", 383);
    freq.put("ilb", 24);
    freq.put("cot", 51);
    freq.put("cov", 30);
    freq.put("coy", 51);
    freq.put("ilo", 292);
    freq.put("ill", 955);
    freq.put("ilm", 29);
    freq.put("eme\u0301", 16);
    freq.put("ilh", 29);
    freq.put("ili", 1019);
    freq.put("ilv", 34);
    freq.put("ilt", 41);
    freq.put("ilu", 121);
    freq.put("ils", 19);
    freq.put("emo\u0301", 31);
    freq.put("coi", 27);
    freq.put("coh", 36);
    freq.put("com", 3328);
    freq.put("col", 2078);
    freq.put("coo", 49);
    freq.put("con", 6546);
    freq.put("o\u0301pt", 22);
    freq.put("o\u0301pi", 25);
    freq.put("o\u0301po", 43);
    freq.put("o\u0301pa", 40);
    freq.put("o\u0301pe", 32);
    freq.put("ai ", 410);
    freq.put("nio\u0301", 183);
    freq.put("epu\u0301", 300);
    freq.put("gnu", 20);
    freq.put("ait", 78);
    freq.put("aiw", 16);
    freq.put("ais", 86);
    freq.put("air", 80);
    freq.put("ail", 76);
    freq.put("gna", 76);
    freq.put("gne", 40);
    freq.put("aid", 43);
    freq.put("aig", 61);
    freq.put("gni", 209);
    freq.put("aia", 25);
    freq.put("gno", 41);
    freq.put("aic", 120);
    freq.put("ni ", 97);
    freq.put("th ", 133);
    freq.put("nik", 17);
    freq.put("nin", 174);
    freq.put("nio", 128);
    freq.put("nil", 46);
    freq.put("nim", 294);
    freq.put("nib", 31);
    freq.put("nic", 1074);
    freq.put("nia", 558);
    freq.put("nif", 238);
    freq.put("nig", 20);
    freq.put("nid", 924);
    freq.put("nie", 213);
    freq.put("niz", 260);
    freq.put("nix", 20);
    freq.put("nir", 23);
    freq.put("nis", 790);
    freq.put("niq", 73);
    freq.put("niv", 320);
    freq.put("nit", 159);
    freq.put("niu", 147);
    freq.put("ept", 90);
    freq.put("epu", 120);
    freq.put("epr", 295);
    freq.put("epp", 16);
    freq.put("tho", 54);
    freq.put("epo", 164);
    freq.put("eph", 51);
    freq.put("epi", 57);
    freq.put("in\u0303e", 42);
    freq.put("the", 134);
    freq.put("epe", 277);
    freq.put("in\u0303a", 114);
    freq.put("epc", 24);
    freq.put("tha", 55);
    freq.put("epa", 248);
    freq.put("rn ", 45);
    freq.put("A\u0301fr", 122);
    freq.put("Gau", 20);
    freq.put("Gas", 23);
    freq.put("Gar", 133);
    freq.put("Gan", 25);
    freq.put("Gam", 23);
    freq.put("Gal", 157);
    freq.put("Gai", 36);
    freq.put("Gab", 31);
    freq.put("Tri", 62);
    freq.put("rni", 125);
    freq.put("lcu", 242);
    freq.put("rno", 78);
    freq.put("Tro", 22);
    freq.put("Tra", 162);
    freq.put("rna", 646);
    freq.put("Tre", 79);
    freq.put("rne", 206);
    freq.put("lce", 45);
    freq.put("pla\u0301", 19);
    freq.put("lca", 113);
    freq.put("lco", 92);
    freq.put("lcl", 18);
    freq.put("Tru", 29);
    freq.put("ple\u0301", 32);
    freq.put("lci", 18);
    freq.put("Tok", 22);
    freq.put("fo\u0301n", 24);
    freq.put("zca", 17);
    freq.put("zco", 31);
    freq.put("u\u0301es", 16);
    freq.put("pl ", 18);
    freq.put("Lei", 16);
    freq.put("Len", 28);
    freq.put("Leo", 31);
    freq.put("Les", 314);
    freq.put("Let", 19);
    freq.put("plu", 116);
    freq.put("Tra\u0301", 32);
    freq.put("rna\u0301", 64);
    freq.put("ple", 375);
    freq.put("pla", 490);
    freq.put("lca\u0301", 47);
    freq.put("rno\u0301", 18);
    freq.put("pli", 218);
    freq.put("Pa ", 23);
    freq.put("obl", 611);
    freq.put("obi", 293);
    freq.put("obe", 234);
    freq.put("oba", 115);
    freq.put("obt", 25);
    freq.put("obu", 21);
    freq.put("obr", 799);
    freq.put("obs", 44);
    freq.put("xu", 1617);
    freq.put("Cur", 32);
    freq.put("Cue", 97);
    freq.put("tu\u0301e", 21);
    freq.put("Cub", 44);
    freq.put("Cua", 87);
    freq.put("tu\u0301i", 33);
    freq.put("Cul", 50);
    freq.put("Cui", 28);
    freq.put("wan", 23);
    freq.put("wal", 16);
    freq.put("wai", 19);
    freq.put("dC ", 104);
    freq.put("war", 124);
    freq.put(" X ", 35);
    freq.put("\u03b7", 43);
    freq.put("I\u0301n", 31);
    freq.put("n\u0303o\u0301n", 33);
    freq.put("tu\u0301 ", 161);
    freq.put(" nu\u0301", 520);
    freq.put(" no\u0301", 38);
    freq.put("wa ", 46);
    freq.put("i\u0301ri", 34);
    freq.put("i\u0301rc", 34);
    freq.put("u\u0308r", 30);
    freq.put(" n ", 1386);
    freq.put("u\u0308e", 351);
    freq.put("u\u0308l", 17);
    freq.put("u\u0308i", 16);
    freq.put(" ni", 209);
    freq.put("umu", 23);
    freq.put(" no", 2868);
    freq.put(" na", 2939);
    freq.put(" ne", 2886);
    freq.put(" nu", 905);
    freq.put("\u1100\u1161\u1100\u1161", 36);
    freq.put("gu ", 861);
    freq.put("ui\u0301a", 62);
    freq.put("ui\u0301m", 171);
    freq.put("o\u0301 ", 1298);
    freq.put("\u043d ", 17);
    freq.put("umo", 43);
    freq.put("gub", 16);
    freq.put("gua", 1049);
    freq.put("o\u0301x", 221);
    freq.put("gue", 646);
    freq.put("o\u0301s", 396);
    freq.put("o\u0301r", 412);
    freq.put("gui", 237);
    freq.put("o\u0301p", 164);
    freq.put("guo", 29);
    freq.put("o\u0301v", 74);
    freq.put("o\u0301u", 34);
    freq.put("o\u0301t", 90);
    freq.put("gus", 82);
    freq.put("p", 33070);
    freq.put("o\u0301n", 7070);
    freq.put("guu", 88);
    freq.put("o\u0301l", 287);
    freq.put("o\u0301c", 50);
    freq.put("o\u0301b", 21);
    freq.put("o\u0301g", 61);
    freq.put("o\u0301f", 36);
    freq.put("o\u0301d", 198);
    freq.put("htt", 30);
    freq.put("ek ", 33);
    freq.put("\u0433", 30);
    freq.put("e\u0300re", 16);
    freq.put("xi\u0301a", 493);
    freq.put("ht ", 80);
    freq.put("gle", 111);
    freq.put("gua\u0301", 25);
    freq.put("gue\u0301", 43);
    freq.put("gui\u0301", 44);
    freq.put("uza", 22);
    freq.put("spa\u0301", 25);
    freq.put(" Ka", 208);
    freq.put(" Ke", 90);
    freq.put("Vla", 20);
    freq.put(" Kh", 25);
    freq.put(" Ki", 116);
    freq.put(" Ko", 87);
    freq.put(" Kl", 20);
    freq.put(" Kr", 32);
    freq.put(" Ku", 80);
    freq.put("ca ", 3783);
    freq.put("Mon", 201);
    freq.put("F", 2460);
    freq.put("\u064a", 82);
    freq.put("uz ", 165);
    freq.put("caz", 23);
    freq.put("cay", 45);
    freq.put("ibl", 192);
    freq.put("ibo", 24);
    freq.put("cas", 666);
    freq.put("car", 915);
    freq.put("cap", 607);
    freq.put("cav", 25);
    freq.put("cau", 87);
    freq.put("cat", 286);
    freq.put("cai", 43);
    freq.put("cao", 51);
    freq.put("can", 1161);
    freq.put("cam", 453);
    freq.put("cal", 943);
    freq.put("cac", 372);
    freq.put("cab", 282);
    freq.put("ibr", 294);
    freq.put("ibu", 232);
    freq.put("cae", 48);
    freq.put("cad", 437);
    freq.put("ao ", 215);
    freq.put("spr", 118);
    freq.put("spu", 195);
    freq.put("spi", 98);
    freq.put("spl", 70);
    freq.put("spo", 237);
    freq.put("spa", 1287);
    freq.put("spe", 745);
    freq.put("gh ", 31);
    freq.put("a\u0301mi", 64);
    freq.put("ilo\u0301", 133);
    freq.put("a\u0301ma", 61);
    freq.put("a\u0301mb", 66);
    freq.put("a\u0301me", 33);
    freq.put("aos", 1120);
    freq.put("aor", 22);
    freq.put("ght", 69);
    freq.put("cau\u0301", 21);
    freq.put("ibi\u0301", 20);
    freq.put("zo\u0301s", 19);
    freq.put("can\u0303", 27);
    freq.put("io\u0301d", 117);
    freq.put("gha", 24);
    freq.put("zo\u0301n", 68);
    freq.put("ei\u0301", 48);
    freq.put("Ru", 238);
    freq.put("Che", 63);
    freq.put("Jav", 23);
    freq.put("Chi", 209);
    freq.put("ea\u0301", 87);
    freq.put("soc", 498);
    freq.put("Cho", 16);
    freq.put("Jan", 25);
    freq.put("Re", 1149);
    freq.put("Chr", 69);
    freq.put("Jam", 28);
    freq.put("Chu", 27);
    freq.put("Ro", 515);
    freq.put("Rh", 40);
    freq.put("Ri", 337);
    freq.put("eo\u0301", 208);
    freq.put("mbi", 352);
    freq.put("\u03b1", 104);
    freq.put("nol", 107);
    freq.put("nom", 1670);
    freq.put("non", 188);
    freq.put("noi", 40);
    freq.put("nod", 20);
    freq.put("nog", 38);
    freq.put("noa", 20);
    freq.put("nob", 35);
    freq.put("noc", 790);
    freq.put("R ", 60);
    freq.put("noz", 122);
    freq.put("not", 93);
    freq.put("nov", 249);
    freq.put("nop", 23);
    freq.put("nor", 1253);
    freq.put("nos", 1307);
    freq.put("o\u0301rb", 32);
    freq.put("o\u0301rg", 25);
    freq.put("o\u0301rd", 41);
    freq.put("o\u0301ri", 178);
    freq.put("o\u0301rm", 79);
    freq.put("sou", 39);
    freq.put("sot", 42);
    freq.put("em", 4542);
    freq.put("el", 17104);
    freq.put("eo", 1033);
    freq.put("en", 26094);
    freq.put("ei", 1603);
    freq.put("eh", 90);
    freq.put("ek", 95);
    freq.put("ej", 77);
    freq.put("ee", 379);
    freq.put("ed", 2868);
    freq.put("eg", 2841);
    freq.put("Afg", 56);
    freq.put("ea", 1959);
    freq.put("rl ", 73);
    freq.put("ec", 3902);
    freq.put("eb", 1175);
    freq.put("ey", 2325);
    freq.put("ex", 1430);
    freq.put("ez", 1214);
    freq.put("lm ", 34);
    freq.put("Ri\u0301", 61);
    freq.put("ew", 126);
    freq.put("ev", 1394);
    freq.put("eq", 445);
    freq.put("ep", 1698);
    freq.put("es", 32773);
    freq.put("er", 20142);
    freq.put("tla\u0301", 94);
    freq.put("\u0633", 29);
    freq.put("usm", 17);
    freq.put("rll", 62);
    freq.put("rlo", 76);
    freq.put("rli", 42);
    freq.put("rle", 68);
    freq.put("rld", 24);
    freq.put("rla", 166);
    freq.put("e ", 59283);
    freq.put("lmi", 180);
    freq.put("lmo", 36);
    freq.put("lma", 202);
    freq.put("lme", 618);
    freq.put("aen", 38);
    freq.put("gu\u0301n", 224);
    freq.put("zao", 52);
    freq.put("zal", 57);
    freq.put("xi", 1539);
    freq.put("xo", 497);
    freq.put("u\u0301cl", 48);
    freq.put("Eug", 16);
    freq.put("xa", 716);
    freq.put("zab", 23);
    freq.put("zac", 265);
    freq.put("xe", 2409);
    freq.put("so\u0301n", 19);
    freq.put("xp", 34);
    freq.put("zar", 154);
    freq.put("zas", 50);
    freq.put("Eus", 31);
    freq.put("Eur", 291);
    freq.put("yid", 47);
    freq.put("yin", 53);
    freq.put("yir", 30);
    freq.put("x ", 390);
    freq.put("za ", 713);
    freq.put("xe\u0301", 295);
    freq.put("xi\u0301", 610);
    freq.put("xa\u0301", 31);
    freq.put("xo\u0301", 551);
    freq.put("Phi", 16);
    freq.put("usu", 259);
    freq.put("Di\u0301a", 34);
    freq.put("bi\u0301a", 20);
    freq.put("Di\u0301e", 30);
    freq.put("Ofi", 18);
    freq.put("i\u0301pi", 56);
    freq.put("i\u0301pt", 16);
    freq.put("Ucr", 20);
    freq.put("\u4e59 ", 17);
    freq.put("\u062f ", 23);
    freq.put("\u1100\u1161", 55);
    freq.put("Wes", 19);
    freq.put(" p ", 79);
    freq.put("\u03b5", 62);
    freq.put(" ps", 24);
    freq.put(" pr", 3824);
    freq.put("\u043d\u0430", 22);
    freq.put(" pu", 1010);
    freq.put(" px", 74);
    freq.put("\u043d\u0438", 19);
    freq.put(" pa", 4334);
    freq.put(" pe", 2549);
    freq.put(" pi", 474);
    freq.put(" po", 5012);
    freq.put(" pl", 504);
    freq.put("vu ", 483);
    freq.put("l\u0323", 292);
    freq.put(" U\u0301l", 30);
    freq.put(" pu\u0301", 119);
    freq.put(" pa\u0301", 52);
    freq.put("vue", 55);
    freq.put("vul", 34);
    freq.put("\u03b1 ", 36);
    freq.put("OE ", 22);
    freq.put("mbe\u0301", 27);
    freq.put(" Ma\u0301", 41);
    freq.put(" Me\u0301", 138);
    freq.put("ei ", 274);
    freq.put(" Mo\u0301", 17);
    freq.put("eis", 133);
    freq.put("eir", 227);
    freq.put("eit", 69);
    freq.put("Ri\u0301u", 28);
    freq.put("eia", 19);
    freq.put("eic", 173);
    freq.put("eid", 60);
    freq.put("eig", 73);
    freq.put("eim", 50);
    freq.put("eil", 24);
    freq.put("ein", 431);
    freq.put("yi", 159);
    freq.put("uxu", 59);
    freq.put("uxe", 48);
    freq.put("uxa", 62);
    freq.put("uxo", 21);
    freq.put("yl", 100);
    freq.put(" Me", 530);
    freq.put("xi\u0301o", 18);
    freq.put(" Ma", 1634);
    freq.put(" Mc", 21);
    freq.put("xi\u0301e", 28);
    freq.put(" Mo", 602);
    freq.put(" Mi", 503);
    freq.put(" Mu", 325);
    freq.put("xi\u0301u", 35);
    freq.put("yc", 39);
    freq.put("ux ", 53);
    freq.put(" M ", 22);
    freq.put("ceu", 77);
    freq.put("Ri\u0301o", 29);
    freq.put("cci", 712);
    freq.put("cce", 37);
    freq.put("u\u0308i\u0301s", 94);
    freq.put("a\u0301c", 187);
    freq.put("a\u0301b", 152);
    freq.put("a\u0301d", 28);
    freq.put("a\u0301g", 33);
    freq.put("a\u0301f", 209);
    freq.put("a\u0301i", 113);
    freq.put("am ", 228);
    freq.put("ps ", 21);
    freq.put("a\u0301m", 227);
    freq.put("a\u0301l", 300);
    freq.put("a\u0301n", 1587);
    freq.put("a\u0301q", 33);
    freq.put("a\u0301p", 61);
    freq.put("a\u0301s", 1611);
    freq.put("a\u0301r", 495);
    freq.put("a\u0301u", 3504);
    freq.put("a\u0301t", 413);
    freq.put("a\u0301x", 84);
    freq.put("\u041c", 18);
    freq.put("ucr", 60);
    freq.put("cm", 16);
    freq.put("cl", 985);
    freq.put("asi\u0301", 79);
    freq.put("ami", 1518);
    freq.put("a\u0301 ", 2751);
    freq.put("psi", 51);
    freq.put("amm", 33);
    freq.put("pso", 18);
    freq.put("amo", 312);
    freq.put("a\u0301st", 53);
    freq.put("ama", 920);
    freq.put("amb", 382);
    freq.put("ame", 1238);
    freq.put("amp", 410);
    freq.put("a\u0301si", 173);
    freq.put("amu", 263);
    freq.put("uce", 66);
    freq.put("t", 70258);
    freq.put("Hel", 38);
    freq.put("Hen", 56);
    freq.put("uci", 485);
    freq.put("uch", 144);
    freq.put("ame\u0301", 47);
    freq.put("nmu", 21);
    freq.put("ami\u0301", 75);
    freq.put("ama\u0301", 325);
    freq.put("\u02c8", 22);
    freq.put("nme", 48);
    freq.put("nma", 24);
    freq.put("amo\u0301", 143);
    freq.put("o\u0301te", 18);
    freq.put("sra", 40);
    freq.put("o\u0301to", 33);
    freq.put("o\u0301ti", 30);
    freq.put("Adr", 42);
    freq.put("Ade", 17);
    freq.put("Ado", 27);
    freq.put("lob", 55);
    freq.put("loc", 302);
    freq.put("log", 245);
    freq.put("loi", 16);
    freq.put("lon", 567);
    freq.put("lol", 23);
    freq.put("lom", 185);
    freq.put("lor", 540);
    freq.put("los", 4271);
    freq.put("lop", 43);
    freq.put("loq", 43);
    freq.put("lov", 40);
    freq.put("lot", 128);
    freq.put("lou", 30);
    freq.put("lox", 445);
    freq.put("\u0646", 63);
    freq.put("J", 934);
    freq.put("lo ", 667);
    freq.put("Enr", 39);
    freq.put("Ens", 25);
    freq.put("Est", 1001);
    freq.put("Esp", 639);
    freq.put("Esc", 138);
    freq.put("Esl", 21);
    freq.put("Esi", 22);
    freq.put("Lam", 24);
    freq.put("Lan", 56);
    freq.put("Mun", 121);
    freq.put("Lad", 19);
    freq.put("lon\u0303", 39);
    freq.put("Lau", 39);
    freq.put("yot", 18);
    freq.put("yos", 228);
    freq.put("yor", 392);
    freq.put("Lar", 26);
    freq.put("Las", 68);
    freq.put("c ", 353);
    freq.put("u\u0301a ", 44);
    freq.put("e\u0301xi", 154);
    freq.put("Bru", 42);
    freq.put("La ", 2195);
    freq.put("yo ", 64);
    freq.put("Bro", 33);
    freq.put("Bri", 71);
    freq.put("Bre", 78);
    freq.put("Bra", 124);
    freq.put("mpe", 428);
    freq.put("mpa", 246);
    freq.put("mpo", 573);
    freq.put("mpl", 572);
    freq.put("mph", 22);
    freq.put("mpi", 153);
    freq.put("mpu", 459);
    freq.put("mpr", 266);
    freq.put("mps", 21);
    freq.put(" ri\u0301", 383);
    freq.put(" re\u0301", 31);
    freq.put("En ", 196);
    freq.put("ya\u0301", 151);
    freq.put(" ru", 183);
    freq.put(" re", 3066);
    freq.put(" ra", 387);
    freq.put(" ro", 490);
    freq.put(" ri", 184);
    freq.put("s\u030c", 20);
    freq.put("e\u0301ya", 16);
    freq.put("ue\u0301n", 66);
    freq.put("ask", 19);
    freq.put("ue\u0301s", 211);
    freq.put("ue\u0301r", 46);
    freq.put("S ", 176);
    freq.put("yo\u0301", 90);
    freq.put("asm", 26);
    freq.put("ue\u0301 ", 45);
    freq.put("Sy", 42);
    freq.put("fo\u0301", 50);
    freq.put("fu\u0301", 105);
    freq.put("Sp", 75);
    freq.put("Su", 497);
    freq.put("St", 198);
    freq.put("Sk", 26);
    freq.put("fa\u0301", 60);
    freq.put("Si", 512);
    freq.put("Sh", 122);
    freq.put("So", 612);
    freq.put("Sm", 32);
    freq.put("Sl", 19);
    freq.put("Sc", 128);
    freq.put("fe\u0301", 39);
    freq.put("Sa", 1345);
    freq.put("fi\u0301", 421);
    freq.put("Se", 529);
    freq.put("egu\u0301", 155);
    freq.put("ego\u0301", 34);
    freq.put("ega\u0301", 44);
    freq.put("f ", 254);
    freq.put("lre", 67);
    freq.put("fr", 1022);
    freq.put("ft", 117);
    freq.put("fu", 1173);
    freq.put("\u03bf\u0301", 23);
    freq.put("fa", 1921);
    freq.put("Se\u0301", 17);
    freq.put("fe", 1860);
    freq.put("ff", 93);
    freq.put("fg", 66);
    freq.put("Sa\u0303", 24);
    freq.put("fi", 2695);
    freq.put("Sa\u0301", 31);
    freq.put("fl", 343);
    freq.put("fo", 3258);
    freq.put("a", 170227);
    freq.put("egr", 181);
    freq.put("egu", 849);
    freq.put("egi", 83);
    freq.put("ego", 268);
    freq.put("egm", 21);
    freq.put("o\u0308", 90);
    freq.put("ega", 789);
    freq.put("egg", 25);
    freq.put("ege", 21);
    freq.put("ce ", 251);
    freq.put("y ", 10325);
    freq.put("uvi", 53);
    freq.put("ffi", 20);
    freq.put("uvo", 108);
    freq.put("uva", 18);
    freq.put("ffe", 22);
    freq.put("uve", 52);
    freq.put(" On", 77);
    freq.put(" Ol", 72);
    freq.put(" Oh", 17);
    freq.put(" Of", 28);
    freq.put(" Oe", 36);
    freq.put(" Ob", 97);
    freq.put(" Oc", 326);
    freq.put(" Oz", 26);
    freq.put(" Ov", 26);
    freq.put(" Ot", 27);
    freq.put(" Ou", 40);
    freq.put(" Or", 275);
    freq.put(" Os", 61);
    freq.put(" Op", 34);
    freq.put("aso\u0301", 33);
    freq.put("ced", 227);
    freq.put("ym", 45);
    freq.put("pue\u0301", 159);
    freq.put("yo", 758);
    freq.put("yn", 75);
    freq.put("ya", 1326);
    freq.put("cen", 998);
    freq.put("cem", 16);
    freq.put("cel", 372);
    freq.put("ye", 8912);
    freq.put("yd", 31);
    freq.put("cei", 31);
    freq.put("asa\u0301", 70);
    freq.put("cet", 37);
    freq.put("ces", 617);
    freq.put("cer", 547);
    freq.put("cep", 57);
    freq.put("yp", 29);
    freq.put("ys", 79);
    freq.put("yr", 55);
    freq.put("yu", 1841);
    freq.put("yt", 43);
    freq.put("cey", 1391);
    freq.put("ff ", 16);
    freq.put("ifu", 40);
    freq.put(" O ", 47);
    freq.put("ife", 127);
    freq.put("iff", 19);
    freq.put("ifa", 22);
    freq.put("e\u0301di", 44);
    freq.put("ifo", 102);
    freq.put("ifi", 520);
    freq.put("Enc", 26);
    freq.put("Eng", 16);
    freq.put("pu ", 913);
    freq.put("\u4e13", 20);
    freq.put("as ", 1408);
    freq.put("Ent", 126);
    freq.put("a\u0301qu", 33);
    freq.put("pun", 247);
    freq.put("asp", 60);
    freq.put("yi\u0301", 136);
    freq.put("ve ", 265);
    freq.put("asu", 165);
    freq.put("ast", 3183);
    freq.put("pud", 18);
    freq.put("pue", 824);
    freq.put("pub", 205);
    freq.put("asc", 207);
    freq.put("asa", 359);
    freq.put("ase", 1380);
    freq.put("put", 97);
    freq.put("asi", 1130);
    freq.put("ash", 64);
    freq.put("aso", 242);
    freq.put("pur", 52);
    freq.put("pus", 21);
    freq.put("ion", 2680);
    freq.put("Cli", 43);
    freq.put("Cle", 25);
    freq.put("Cla", 49);
    freq.put("Imp", 87);
    freq.put("nc ", 19);
    freq.put("Clu", 52);
    freq.put("st ", 114);
    freq.put("dt ", 24);
    freq.put("lio\u0301", 112);
    freq.put("ncr", 53);
    freq.put("ncu", 130);
    freq.put("nch", 304);
    freq.put("nci", 3089);
    freq.put("ncl", 208);
    freq.put("nco", 252);
    freq.put("nca", 283);
    freq.put("nce", 1882);
    freq.put("ste", 3808);
    freq.put("sta", 3515);
    freq.put("o\u0301vi", 49);
    freq.put("sto", 728);
    freq.put("sti", 2066);
    freq.put("stu", 2882);
    freq.put("str", 1986);
    freq.put("Gol", 46);
    freq.put("Gon", 82);
    freq.put("Gob", 66);
    freq.put("Goz", 25);
    freq.put("Gor", 20);
    freq.put("lid", 593);
    freq.put("lie", 132);
    freq.put("lif", 101);
    freq.put("lig", 118);
    freq.put("lia", 950);
    freq.put("lib", 370);
    freq.put("lic", 1149);
    freq.put("lil", 19);
    freq.put("Nic", 60);
    freq.put("lin", 1173);
    freq.put("lio", 169);
    freq.put("Nie", 23);
    freq.put("lit", 551);
    freq.put("liu", 103);
    freq.put("liv", 66);
    freq.put("2 ", 338);
    freq.put("liq", 50);
    freq.put("lir", 28);
    freq.put("lis", 777);
    freq.put("lix", 169);
    freq.put("liz", 416);
    freq.put("u\u0301i ", 74);
    freq.put("Thu", 18);
    freq.put("kan", 31);
    freq.put("kal", 27);
    freq.put("Tho", 16);
    freq.put("nce\u0301", 243);
    freq.put("Thi", 18);
    freq.put("kat", 20);
    freq.put("rha", 19);
    freq.put("The", 135);
    freq.put("Tha", 23);
    freq.put("li ", 92);
    freq.put("sta\u0301", 664);
    freq.put("sti\u0301", 107);
    freq.put("ste\u0301", 18);
    freq.put("sto\u0301", 186);
    freq.put("ox ", 16);
    freq.put(" A\u0301f", 122);
    freq.put(" A\u0301l", 48);
    freq.put(" A\u0301n", 47);
    freq.put(" A\u0301r", 37);
    freq.put("a\u0303", 41);
    freq.put("oxu", 45);
    freq.put("oxi", 67);
    freq.put("x", 8831);
    freq.put("oxa", 44);
    freq.put("lo\u0301g", 19);
    freq.put("o\u0301ve", 19);
    freq.put("wor", 24);
    freq.put("woo", 18);
    freq.put("Pla", 123);
    freq.put("Obe", 18);
    freq.put("el\u0323", 35);
    freq.put("be\u0301u", 16);
    freq.put("be\u0301r", 67);
    freq.put("Obs", 27);
    freq.put("Nue", 203);
    freq.put("oxi\u0301", 429);
    freq.put("oxe\u0301", 30);
    freq.put("Wal", 37);
    freq.put("Wad", 19);
    freq.put("ka ", 107);
    freq.put("Wat", 29);
    freq.put("Was", 23);
    freq.put(" tu", 214);
    freq.put(" tr", 1359);
    freq.put("N", 2379);
    freq.put(" to", 818);
    freq.put(" ti", 1156);
    freq.put(" th", 148);
    freq.put(" te", 1365);
    freq.put(" ta", 1645);
    freq.put("iya", 42);
    freq.put("no\u0301m", 249);
    freq.put("no\u0301n", 70);
    freq.put("dia\u0301", 48);
    freq.put("no\u0301r", 16);
    freq.put("i\u0301xe", 49);
    freq.put("lo\u0301m", 73);
    freq.put("gs ", 16);
    freq.put("no\u0301 ", 79);
    freq.put(" to\u0301", 24);
    freq.put(" ti\u0301", 112);
    freq.put(" te\u0301", 328);
    freq.put(" ta\u0301", 84);
    freq.put("gst", 28);
    freq.put("lim", 144);
    freq.put("dio\u0301", 118);
    freq.put("hu\u0301n", 21);
    freq.put("lik", 21);
    freq.put("\u03b9", 83);
    freq.put("lip", 74);
    freq.put("ee ", 80);
    freq.put("we ", 17);
    freq.put("run\u0303", 20);
    freq.put("ees", 108);
    freq.put("een", 78);
    freq.put("ide\u0301", 35);
    freq.put("eed", 35);
    freq.put("ida\u0301", 1384);
    freq.put("ru ", 2621);
    freq.put(" Qu", 164);
    freq.put(" Qa", 19);
    freq.put("id ", 231);
    freq.put("run", 72);
    freq.put("ruo", 36);
    freq.put("rul", 25);
    freq.put("rum", 143);
    freq.put("rub", 23);
    freq.put("ruc", 188);
    freq.put("rua", 28);
    freq.put("nll", 38);
    freq.put("rug", 42);
    freq.put("rud", 20);
    freq.put("rue", 113);
    freq.put("ruz", 62);
    freq.put("rux", 27);
    freq.put("ruy", 68);
    freq.put("rur", 24);
    freq.put("rus", 212);
    freq.put("rup", 465);
    freq.put("rut", 65);
    freq.put("kar", 33);
    freq.put("idt", 17);
    freq.put("idu", 142);
    freq.put("idr", 81);
    freq.put("ido", 249);
    freq.put("bgr", 19);
    freq.put("idi", 389);
    freq.put("idg", 19);
    freq.put("ide", 1728);
    freq.put("ida", 1327);
    freq.put("Eli", 16);
    freq.put("Tu\u0301", 18);
    freq.put("Ell", 17);
    freq.put("Ele", 33);
    freq.put("Ti\u0301", 16);
    freq.put("aq ", 30);
    freq.put("ut ", 51);
    freq.put("\u4e26", 58);
    freq.put("aqu", 281);
    freq.put("El ", 2204);
    freq.put("utb", 65);
    freq.put("uta", 273);
    freq.put("o\u0308l", 16);
    freq.put("ute", 210);
    freq.put("uth", 73);
    freq.put("uti", 417);
    freq.put("uto", 536);
    freq.put("utr", 55);
    freq.put("uts", 19);
    freq.put("utt", 20);
    freq.put("utu", 365);
    freq.put("Tu", 174);
    freq.put("Tr", 396);
    freq.put("Ts", 20);
    freq.put("To", 362);
    freq.put("Th", 219);
    freq.put("Ti", 507);
    freq.put("Te", 446);
    freq.put("Ta", 602);
    freq.put("nab", 29);
    freq.put("nac", 987);
    freq.put("nag", 29);
    freq.put("nad", 454);
    freq.put("nae", 101);
    freq.put("nan", 292);
    freq.put("nao", 79);
    freq.put("nal", 1643);
    freq.put("nam", 266);
    freq.put("nar", 583);
    freq.put("nas", 192);
    freq.put("nap", 17);
    freq.put("nav", 91);
    freq.put("nat", 361);
    freq.put("ool", 25);
    freq.put("naz", 53);
    freq.put("nax", 96);
    freq.put("ie\u0301u", 251);
    freq.put("ie\u0301t", 52);
    freq.put("ie\u0301s", 98);
    freq.put("ie\u0301r", 47);
    freq.put("i\u0301go", 16);
    freq.put("i\u0301gu", 40);
    freq.put("ie\u0301l", 53);
    freq.put("ie\u0301n", 925);
    freq.put("T ", 82);
    freq.put("Aa", 18);
    freq.put("na ", 10236);
    freq.put("Ab", 136);
    freq.put("e", 191100);
    freq.put("Ad", 123);
    freq.put("Ag", 96);
    freq.put("Af", 85);
    freq.put("Ai", 68);
    freq.put("Ak", 22);
    freq.put("Am", 341);
    freq.put("Al", 971);
    freq.put("An", 720);
    freq.put("Aq", 27);
    freq.put("Ap", 89);
    freq.put("As", 1178);
    freq.put("Ar", 675);
    freq.put("Au", 315);
    freq.put("At", 261);
    freq.put("Av", 136);
    freq.put("Ay", 84);
    freq.put("u\u0301", 2996);
    freq.put("gu", 3881);
    freq.put("gt", 43);
    freq.put("gs", 63);
    freq.put("gr", 2520);
    freq.put("za\u0301", 267);
    freq.put("gy", 18);
    freq.put("gg", 68);
    freq.put("ge", 530);
    freq.put("gd", 16);
    freq.put("ga", 3918);
    freq.put("go", 1726);
    freq.put("gn", 471);
    freq.put("gm", 61);
    freq.put("Gil", 29);
    freq.put("ass", 123);
    freq.put("gi", 308);
    freq.put("zo\u0301", 145);
    freq.put("Nob", 32);
    freq.put("Not", 28);
    freq.put("Nov", 21);
    freq.put("\u03bd", 69);
    freq.put("Nor", 278);
    freq.put("Nos", 21);
    freq.put("ozo\u0301", 26);
    freq.put("g ", 673);
    freq.put("hi ", 94);
    freq.put("adi\u0301", 61);
    freq.put("lk ", 24);
    freq.put("Spo", 26);
    freq.put("ade\u0301", 24);
    freq.put("Spe", 17);
    freq.put("zo", 513);
    freq.put("zh", 26);
    freq.put("zi", 133);
    freq.put("oz ", 147);
    freq.put("ze", 88);
    freq.put("gu\u0308", 458);
    freq.put("za", 1736);
    freq.put("zb", 17);
    freq.put("zc", 62);
    freq.put("ga\u0301", 345);
    freq.put("zu", 625);
    freq.put("gi\u0301", 22);
    freq.put("zq", 94);
    freq.put("ge\u0301", 62);
    freq.put("zs", 62);
    freq.put("\u4e4b", 74);
    freq.put("ull", 69);
    freq.put("oza", 91);
    freq.put("ozo", 40);
    freq.put("z ", 1519);
    freq.put("ozi", 22);
    freq.put("ozu", 23);
    freq.put("ozs", 33);
    freq.put("ce\u0301a", 165);
    freq.put("A\u0301ng", 28);
    freq.put("ce\u0301n", 25);
    freq.put("ce\u0301l", 55);
    freq.put("ce\u0301s", 257);
    freq.put("\u0440\u043e", 16);
    freq.put("wic", 24);
    freq.put("wil", 69);
    freq.put("i\u0301z ", 19);
    freq.put(" ve\u0301", 17);
    freq.put(" vi\u0301", 45);
    freq.put("Ji", 26);
    freq.put("i\u0301za", 29);
    freq.put("ied", 359);
    freq.put(" va", 572);
    freq.put(" ve", 782);
    freq.put(" vi", 927);
    freq.put(" vo", 221);
    freq.put(" vu", 55);
    freq.put("hic", 42);
    freq.put("hil", 111);
    freq.put("eca\u0301", 62);
    freq.put("eci\u0301", 121);
    freq.put("c\u0327", 55);
    freq.put("ayo\u0301", 31);
    freq.put("ec ", 29);
    freq.put("mar", 1405);
    freq.put("hle", 24);
    freq.put("mat", 468);
    freq.put("sna", 21);
    freq.put("i\u0301os", 664);
    freq.put("\u043f", 16);
    freq.put("ece", 305);
    freq.put("ecc", 79);
    freq.put("eca", 117);
    freq.put("eco", 370);
    freq.put("ecn", 23);
    freq.put("ecl", 83);
    freq.put("eck", 30);
    freq.put("eci", 1196);
    freq.put("ech", 570);
    freq.put("\u4e26 ", 27);
    freq.put("ecu", 326);
    freq.put("ect", 514);
    freq.put("ecr", 67);
    freq.put("oxe", 174);
    freq.put("rs ", 177);
    freq.put("art", 2055);
    freq.put(" Sy", 42);
    freq.put(" Sp", 74);
    freq.put(" St", 186);
    freq.put(" Su", 496);
    freq.put("arx", 120);
    freq.put(" Sh", 121);
    freq.put(" Si", 512);
    freq.put(" So", 611);
    freq.put(" Sl", 19);
    freq.put(" Sm", 30);
    freq.put(" Sc", 128);
    freq.put(" Sa", 1343);
    freq.put(" Se", 524);
    freq.put("rso", 445);
    freq.put("rsi", 274);
    freq.put("big", 18);
    freq.put("rse", 149);
    freq.put("rsa", 118);
    freq.put("rsb", 17);
    freq.put("R", 2701);
    freq.put("rst", 23);
    freq.put("rsu", 89);
    freq.put("NU ", 46);
    freq.put("bei", 17);
    freq.put("ben", 175);
    freq.put("beo", 16);
    freq.put("bel", 121);
    freq.put("bec", 54);
    freq.put("bed", 18);
    freq.put("bez", 71);
    freq.put("a\u0301pi", 16);
    freq.put("uro\u0301", 51);
    freq.put("ber", 1232);
    freq.put("bes", 150);
    freq.put(" S ", 48);
    freq.put("bet", 115);
    freq.put("are", 898);
    freq.put("a\u0303o", 34);
    freq.put("lu\u0301 ", 18);
    freq.put("aw ", 16);
    freq.put("ur ", 794);
    freq.put("uu ", 107);
    freq.put("Dep", 73);
    freq.put(" Se\u0301", 17);
    freq.put("a\u0301ut", 60);
    freq.put(" Sa\u0303", 24);
    freq.put(" Sa\u0301", 31);
    freq.put("Des", 65);
    freq.put("uli\u0301", 16);
    freq.put("lu\u0301i", 60);
    freq.put("Dev", 18);
    freq.put("lu\u0301g", 64);
    freq.put("urd", 108);
    freq.put("a\u0301u ", 3417);
    freq.put("urg", 169);
    freq.put("Sa\u0301n", 20);
    freq.put("urb", 59);
    freq.put("urc", 89);
    freq.put("url", 25);
    freq.put("urn", 47);
    freq.put("uro", 651);
    freq.put("uri", 2235);
    freq.put("urk", 24);
    freq.put("urt", 100);
    freq.put("uru", 109);
    freq.put("urv", 24);
    freq.put("urq", 36);
    freq.put("urr", 118);
    freq.put("urs", 108);
    freq.put("Del", 51);
    freq.put("urx", 17);
    freq.put("ury", 21);
    freq.put("Den", 120);
    freq.put("ibe", 376);
    freq.put("nge", 180);
    freq.put("nga", 328);
    freq.put("ngl", 476);
    freq.put("ngo", 177);
    freq.put("ngh", 27);
    freq.put("ngi", 17);
    freq.put("Pse", 16);
    freq.put("ngt", 35);
    freq.put("ngu", 963);
    freq.put("Def", 31);
    freq.put("ngr", 138);
    freq.put("ngs", 31);
    freq.put("i\u0301en", 75);
    freq.put("i\u0301es", 321);
    freq.put("ng ", 384);
    freq.put("sha", 40);
    freq.put("she", 29);
    freq.put("shi", 136);
    freq.put("m2 ", 332);
    freq.put("sho", 26);
    freq.put("u\u0308er", 20);
    freq.put("u\u0308es", 184);
    freq.put("u\u0308ey", 25);
    freq.put("ke ", 46);
    freq.put("u\u0308ed", 31);
    freq.put("u\u0308ei", 36);
    freq.put("u\u0308el", 27);
    freq.put("lur", 50);
    freq.put("lus", 166);
    freq.put("lut", 62);
    freq.put("luv", 17);
    freq.put("lux", 36);
    freq.put("luy", 150);
    freq.put("luz", 71);
    freq.put("lub", 115);
    freq.put("luc", 324);
    freq.put("lue", 108);
    freq.put("lug", 766);
    freq.put("ngu\u0308", 238);
    freq.put("lui", 37);
    freq.put("\u043b", 67);
    freq.put("lul", 69);
    freq.put("lum", 136);
    freq.put("lun", 116);
    freq.put("ken", 47);
    freq.put("kel", 33);
    freq.put("ker", 57);
    freq.put("lu ", 1463);
    freq.put("ot ", 48);
    freq.put("Lon", 76);
    freq.put("Lor", 43);
    freq.put("Los", 426);
    freq.put("Lou", 51);
    freq.put("eo\u0301r", 18);
    freq.put("Obr", 35);
    freq.put("yas", 44);
    freq.put("yar", 248);
    freq.put("yam", 17);
    freq.put("yal", 39);
    freq.put("yao", 24);
    freq.put("yan", 109);
    freq.put("yae", 21);
    freq.put("eo\u0301n", 147);
    freq.put(" au", 622);
    freq.put("oth", 30);
    freq.put("oti", 131);
    freq.put("oto", 250);
    freq.put("ota", 327);
    freq.put("ote", 316);
    freq.put("otr", 486);
    freq.put("ots", 30);
    freq.put("ott", 53);
    freq.put("otu", 103);
    freq.put("And", 179);
    freq.put("Ang", 126);
    freq.put("Ana", 44);
    freq.put("Anc", 16);
    freq.put("Ann", 49);
    freq.put("Ani", 19);
    freq.put("Ant", 224);
    freq.put("Anq", 27);
    freq.put("A\u0301lv", 43);
    freq.put("ya ", 668);
    freq.put("You", 19);
    freq.put("Yor", 91);
    freq.put("PP ", 17);
    freq.put("ota\u0301", 46);
    freq.put("biq", 32);
    freq.put("oto\u0301", 31);
    freq.put("i", 106393);
    freq.put("\u3042\u3042", 28);
    freq.put("Be", 395);
    freq.put(" xi", 303);
    freq.put(" xo", 25);
    freq.put("Ba", 826);
    freq.put("Bl", 92);
    freq.put(" xa", 200);
    freq.put("Bo", 400);
    freq.put("Bi", 231);
    freq.put(" xe", 729);
    freq.put("Bu", 303);
    freq.put("Br", 356);
    freq.put("Sho", 17);
    freq.put(" xu", 1038);
    freq.put("foi", 1547);
    freq.put("B ", 70);
    freq.put("ji ", 20);
    freq.put("oaz", 17);
    freq.put("e\u0301si", 54);
    freq.put("ho\u0304", 25);
    freq.put("e\u0301sa", 29);
    freq.put("U ", 94);
    freq.put(" xe\u0301", 177);
    freq.put("Ba\u0301", 39);
    freq.put("Be\u0301", 34);
    freq.put("uyi", 65);
    freq.put("swi", 41);
    freq.put("Ut", 24);
    freq.put("Uv", 246);
    freq.put("Us", 23);
    freq.put("Ur", 94);
    freq.put("Un", 787);
    freq.put("Ui", 21);
    freq.put("Uc", 24);
    freq.put("pt", 316);
    freq.put("duo", 16);
    freq.put("duc", 414);
    freq.put("ea ", 794);
    freq.put("due", 24);
    freq.put("h ", 753);
    freq.put("zor", 18);
    freq.put("hy", 62);
    freq.put("eam", 57);
    freq.put("eal", 255);
    freq.put("ean", 167);
    freq.put("hr", 141);
    freq.put("eac", 85);
    freq.put("eae", 116);
    freq.put("ead", 115);
    freq.put("ht", 144);
    freq.put("hu", 795);
    freq.put("hi", 1298);
    freq.put("hn", 80);
    freq.put("ho", 1238);
    freq.put("hl", 57);
    freq.put("hm", 46);
    freq.put("eas", 52);
    freq.put("ear", 129);
    freq.put("eau", 39);
    freq.put("ph", 225);
    freq.put("he", 1354);
    freq.put("dus", 75);
    freq.put("hn ", 40);
    freq.put(" Ut", 23);
    freq.put(" Uv", 246);
    freq.put(" Ur", 94);
    freq.put(" Us", 23);
    freq.put(" Un", 784);
    freq.put(" Ui", 21);
    freq.put(" Uc", 24);
    freq.put("hu\u0301", 30);
    freq.put("rqu", 336);
    freq.put("ho\u0301", 27);
    freq.put("he\u0301", 33);
    freq.put("hi\u0301", 59);
    freq.put("ha\u0301", 38);
    freq.put("auc", 21);
    freq.put("aud", 123);
    freq.put("aug", 53);
    freq.put("Joa", 31);
    freq.put("aum", 22);
    freq.put("aul", 87);
    freq.put("up ", 24);
    freq.put("aun", 118);
    freq.put("aus", 139);
    freq.put("aur", 126);
    freq.put("aut", 692);
    freq.put("aux", 27);
    freq.put("nen\u0303", 35);
    freq.put("Joh", 110);
    freq.put("au ", 386);
    freq.put("Sa\u0303o", 24);
    freq.put("dro\u0301", 27);
    freq.put("upe", 326);
    freq.put("upa", 237);
    freq.put("dre\u0301", 37);
    freq.put("dri\u0301", 85);
    freq.put("dra\u0301", 50);
    freq.put("upu", 386);
    freq.put("me ", 1029);
    freq.put("nen", 447);
    freq.put("neo", 63);
    freq.put("nel", 2400);
    freq.put("nem", 49);
    freq.put("G", 2213);
    freq.put("nei", 23);
    freq.put("Pue", 128);
    freq.put("ned", 77);
    freq.put("nee", 16);
    freq.put("neb", 16);
    freq.put("nec", 398);
    freq.put("Pub", 23);
    freq.put("nea", 158);
    freq.put("nez", 243);
    freq.put("nex", 27);
    freq.put("ney", 19);
    freq.put("net", 406);
    freq.put("neu", 108);
    freq.put("ner", 1354);
    freq.put("nes", 3073);
    freq.put("i\u0301co", 18);
    freq.put("med", 403);
    freq.put("\u0443", 22);
    freq.put("mec", 68);
    freq.put("mem", 43);
    freq.put("mel", 115);
    freq.put("men", 2802);
    freq.put("mei", 27);
    freq.put("i\u0301ca", 20);
    freq.put("met", 561);
    freq.put("mes", 1083);
    freq.put("mer", 1096);
    freq.put("i\u0301cu", 177);
    freq.put("i\u0301ct", 21);
    freq.put("mey", 244);
    freq.put("mex", 66);
    freq.put("mez", 38);
    freq.put("so\u0301l", 48);
    freq.put("o\u0301lu", 23);
    freq.put("dru", 62);
    freq.put("ne ", 393);
    freq.put("dri", 332);
    freq.put("Uvi", 246);
    freq.put("o\u0301lo", 86);
    freq.put("o\u0301li", 113);
    freq.put("dro", 130);
    freq.put("dra", 220);
    freq.put("dre", 231);
    freq.put("o\u0301la", 40);
    freq.put("so\u0301f", 16);
    freq.put("Tit", 20);
    freq.put("en\u0303a\u0301", 17);
    freq.put("A\u0301", 293);
    freq.put("Ste", 38);
    freq.put("Sta", 94);
    freq.put("V", 1593);
    freq.put("rio", 938);
    freq.put("Tin", 35);
    freq.put("Lie", 51);
    freq.put("Lib", 49);
    freq.put("Lim", 32);
    freq.put("Lin", 59);
    freq.put("Lit", 30);
    freq.put("ov ", 46);
    freq.put("Lis", 23);
    freq.put("en\u0303u", 112);
    freq.put("Kan", 30);
    freq.put("Al ", 50);
    freq.put("Kal", 23);
    freq.put("Kar", 72);
    freq.put("en\u0303o", 116);
    freq.put("en\u0303a", 235);
    freq.put("en\u0303e", 73);
    freq.put("Apo", 32);
    freq.put("ova", 135);
    freq.put("ove", 296);
    freq.put("ovi", 1071);
    freq.put("ovo", 45);
    freq.put("ci\u0301o", 83);
    freq.put("Alo", 22);
    freq.put("All", 92);
    freq.put("Alm", 61);
    freq.put("Ali", 55);
    freq.put("Alf", 73);
    freq.put("Alg", 23);
    freq.put("ci\u0301e", 70);
    freq.put("Ale", 179);
    freq.put("Alb", 86);
    freq.put("Alc", 70);
    freq.put("ci\u0301a", 229);
    freq.put("Ala", 56);
    freq.put("A\u0301ra", 20);
    freq.put("Alt", 81);
    freq.put("Als", 31);
    freq.put("Alp", 34);
    freq.put("ra\u0301f", 190);
    freq.put("ra\u0301b", 17);
    freq.put("ra\u0301c", 46);
    freq.put("ra\u0301n", 125);
    freq.put("ra\u0301m", 19);
    freq.put("ra\u0301t", 112);
    freq.put("ra\u0301u", 426);
    freq.put("ra\u0301r", 19);
    freq.put("ra\u0301s", 58);
    freq.put("ra\u0301p", 16);
    freq.put("mue\u0301", 55);
    freq.put("\u03c1", 71);
    freq.put("ra\u0301 ", 45);
    freq.put("N\u0303a", 32);
    freq.put("bo\u0301n", 41);
    freq.put("U\u0301l", 30);
    freq.put("iso\u0301", 43);
    freq.put("ri\u0301a", 654);
    freq.put("isa\u0301", 16);
    freq.put("Wor", 35);
    freq.put("Ile", 79);
    freq.put("SS ", 19);
    freq.put(" zo", 192);
    freq.put(" za", 54);
    freq.put("xu ", 252);
    freq.put(" zu", 29);
    freq.put("is ", 756);
    freq.put("xuv", 16);
    freq.put("xur", 75);
    freq.put("xus", 30);
    freq.put("iss", 72);
    freq.put("isp", 199);
    freq.put("isu", 105);
    freq.put("ist", 3219);
    freq.put("xud", 65);
    freq.put("xue", 157);
    freq.put("isi", 589);
    freq.put("ish", 51);
    freq.put("iso", 108);
    freq.put("isn", 23);
    freq.put("ism", 542);
    freq.put("isl", 332);
    freq.put("isc", 299);
    freq.put("isb", 35);
    freq.put("isa", 161);
    freq.put("isf", 41);
    freq.put("ise", 288);
    freq.put("isd", 16);
    freq.put("ua\u0301r", 22);
    freq.put("la\u0301 ", 22);
    freq.put("ua\u0301i", 22);
    freq.put("ua\u0301n", 17);
    freq.put("ri ", 143);
    freq.put("la\u0301m", 58);
    freq.put("la\u0301n", 193);
    freq.put("la\u0301u", 120);
    freq.put("la\u0301s", 102);
    freq.put("ty ", 54);
    freq.put("Izq", 34);
    freq.put("do ", 1344);
    freq.put("tyl", 20);
    freq.put("don", 143);
    freq.put("dol", 210);
    freq.put("dom", 126);
    freq.put("dob", 50);
    freq.put("doc", 94);
    freq.put("m", 39570);
    freq.put("doe", 71);
    freq.put("dox", 20);
    freq.put("dor", 1137);
    freq.put("dos", 641);
    freq.put("dop", 55);
    freq.put("dow", 26);
    freq.put("dot", 47);
    freq.put("dou", 84);
    freq.put(" We", 88);
    freq.put(" Wa", 148);
    freq.put(" Wo", 64);
    freq.put(" Wh", 19);
    freq.put(" Wi", 192);
    freq.put(" Wu", 21);
    freq.put(" Wr", 18);
    freq.put("Co\u0301r", 30);
    freq.put("\u062c", 17);
    freq.put("ba ", 428);
    freq.put("oma\u0301", 205);
    freq.put("\u03c5", 30);
    freq.put("ome\u0301", 57);
    freq.put("omi\u0301", 137);
    freq.put("omo\u0301", 120);
    freq.put("omu\u0301", 87);
    freq.put("bat", 144);
    freq.put("bar", 284);
    freq.put("bas", 292);
    freq.put("bax", 180);
    freq.put("bay", 195);
    freq.put("bad", 80);
    freq.put("bab", 41);
    freq.put("bac", 102);
    freq.put("ban", 471);
    freq.put("bao", 24);
    freq.put("bal", 191);
    freq.put("bam", 16);
    freq.put("uni\u0301", 435);
    freq.put("bai", 45);
    freq.put("om ", 37);
    freq.put("Rum", 30);
    freq.put("Rub", 28);
    freq.put("un ", 5668);
    freq.put("Rus", 84);
    freq.put("Rut", 18);
    freq.put("omb", 243);
    freq.put("oma", 1183);
    freq.put("ome", 1217);
    freq.put("omi", 379);
    freq.put("omo", 1714);
    freq.put("omm", 54);
    freq.put("omp", 712);
    freq.put("omu", 1010);
    freq.put("unq", 16);
    freq.put("uns", 26);
    freq.put("unt", 819);
    freq.put("unu", 367);
    freq.put("unv", 24);
    freq.put("ban\u0303", 21);
    freq.put("unx", 19);
    freq.put("elo\u0301", 22);
    freq.put("una", 5039);
    freq.put("unc", 346);
    freq.put("und", 1136);
    freq.put("une", 392);
    freq.put("unf", 27);
    freq.put("ung", 120);
    freq.put("uni", 1266);
    freq.put("unk", 44);
    freq.put("unn", 21);
    freq.put("uno", 236);
    freq.put("o\u0301n ", 6497);
    freq.put("in\u0303", 182);
    freq.put("io\u0301", 5570);
    freq.put("ie\u0301", 1438);
    freq.put("i\u0301a ", 2317);
    freq.put("ia\u0301", 485);
    freq.put("C ", 263);
    freq.put("i\u0301as", 87);
    freq.put("i\u0301ns", 113);
    freq.put("o\u0301no", 245);
    freq.put("i\u0301az", 26);
    freq.put("o\u0301ni", 269);
    freq.put("i\u0301ac", 19);
    freq.put("di\u0301e", 57);
    freq.put("Ci", 308);
    freq.put("Ch", 551);
    freq.put("Co", 1648);
    freq.put("Cl", 197);
    freq.put("Ca", 2136);
    freq.put("Vi\u0301", 35);
    freq.put("Ce", 266);
    freq.put("Ma\u0301l", 20);
    freq.put("sll", 351);
    freq.put("Cy", 23);
    freq.put("slo", 32);
    freq.put("Cr", 259);
    freq.put("sla", 239);
    freq.put("Cu", 399);
    freq.put("iy", 108);
    freq.put("Nac", 209);
    freq.put("iz", 1365);
    freq.put("o\u0304 ", 29);
    freq.put("iq", 729);
    freq.put("ip", 1585);
    freq.put("is", 6977);
    freq.put("ir", 2164);
    freq.put("Nan", 23);
    freq.put("it", 6130);
    freq.put("Nal", 40);
    freq.put("Nam", 37);
    freq.put("Nar", 115);
    freq.put("ih", 34);
    freq.put("ik", 223);
    freq.put("ij", 62);
    freq.put("Nav", 138);
    freq.put("il", 4138);
    freq.put("Nat", 51);
    freq.put("Nau", 21);
    freq.put("ia", 11667);
    freq.put("ic", 11284);
    freq.put("ki ", 78);
    freq.put("ie", 11230);
    freq.put("id", 5678);
    freq.put("ig", 1824);
    freq.put("if", 877);
    freq.put("V ", 114);
    freq.put("sap", 32);
    freq.put("lqu", 50);
    freq.put("o\u0301cr", 26);
    freq.put("Na ", 70);
    freq.put("kis", 18);
    freq.put("o\u0304n", 19);
    freq.put("\u0438\u0438\u0306 ", 18);
    freq.put("kin", 52);
    freq.put("kil", 29);
    freq.put("i ", 4386);
    freq.put("Va", 427);
    freq.put("Ce\u0301", 23);
    freq.put("Ve", 275);
    freq.put("Vi", 634);
    freq.put("Ca\u0301", 78);
    freq.put("Vl", 20);
    freq.put("Vo", 66);
    freq.put("Vu", 28);
    freq.put("Co\u0301", 39);
    freq.put("sla\u0301", 26);
    freq.put("yel", 16);
    freq.put("yen", 184);
    freq.put("yec", 34);
    freq.put("op ", 45);
    freq.put("yes", 109);
    freq.put("yer", 580);
    freq.put("yeu", 58);
    freq.put("Ecu", 34);
    freq.put("opt", 67);
    freq.put("opu", 267);
    freq.put("opr", 19);
    freq.put("ye ", 7881);
    freq.put("ope", 314);
    freq.put(" L\u0323", 79);
    freq.put("opa", 364);
    freq.put("opl", 18);
    freq.put("opo", 252);
    freq.put("oph", 72);
    freq.put("opi", 240);
    freq.put("Arr", 45);
    freq.put("Art", 73);
    freq.put("Arx", 71);
    freq.put("i\u0308", 19);
    freq.put("Ara", 113);
    freq.put("Arb", 49);
    freq.put("Arc", 25);
    freq.put("Are", 47);
    freq.put("Arg", 40);
    freq.put("Ari", 67);
    freq.put("Arl", 23);
    freq.put("Arm", 53);
    freq.put("www", 23);
    freq.put("Fu\u0301t", 24);
    freq.put("Ozc", 21);
    freq.put("\u03b7\u0301", 17);
    freq.put("zu ", 478);
    freq.put("idi\u0301", 32);
    freq.put("opo\u0301", 34);
    freq.put("ww ", 24);
    freq.put("opi\u0301", 21);
    freq.put("ope\u0301", 60);
    freq.put("zue", 46);
    freq.put("zul", 47);
    freq.put("zad", 148);
    freq.put("DN ", 22);
    freq.put("xt", 65);
    freq.put("Z", 344);
    freq.put("iqu", 723);
    freq.put("\u0627\u0644", 57);
    freq.put("nki", 18);
    freq.put("\u0441\u043a", 23);
    freq.put("Win", 35);
    freq.put("Wil", 86);
    freq.put("Wik", 18);
    freq.put("Wis", 20);
    freq.put("Me\u0301x", 109);
    freq.put("di ", 84);
    freq.put("eru", 1571);
    freq.put("dil", 38);
    freq.put("dim", 103);
    freq.put("din", 233);
    freq.put("dio", 562);
    freq.put("did", 139);
    freq.put("die", 552);
    freq.put("dif", 210);
    freq.put("dig", 77);
    freq.put("dia", 853);
    freq.put("dib", 85);
    freq.put("dic", 1025);
    freq.put("dix", 94);
    freq.put("diz", 65);
    freq.put("dit", 197);
    freq.put("diu", 428);
    freq.put("div", 255);
    freq.put("dip", 39);
    freq.put("diq", 18);
    freq.put("dir", 306);
    freq.put("dis", 892);
    freq.put("Gru", 31);
    freq.put(" Yo", 128);
    freq.put(" Ya", 43);
    freq.put(" Ye", 596);
    freq.put("Gre", 88);
    freq.put("Gra", 321);
    freq.put("Gro", 59);
    freq.put(" Yu", 23);
    freq.put("Gri", 44);
    freq.put("bo ", 70);
    freq.put("era", 3120);
    freq.put("io\u0301l", 30);
    freq.put("erm", 561);
    freq.put("tno", 16);
    freq.put("box", 29);
    freq.put("boy", 25);
    freq.put("bor", 241);
    freq.put("bos", 61);
    freq.put("bot", 50);
    freq.put("bou", 20);
    freq.put("bol", 473);
    freq.put("bom", 16);
    freq.put("bon", 165);
    freq.put("boa", 22);
    freq.put("boc", 46);
    freq.put("bog", 28);
    freq.put("oo ", 63);
    freq.put("uax", 50);
    freq.put("ayo", 375);
    freq.put("ayi", 17);
    freq.put("aye", 125);
    freq.put("aya", 468);
    freq.put("Wu", 21);
    freq.put("ayu", 355);
    freq.put("ul ", 123);
    freq.put("man\u0303", 166);
    freq.put("ood", 25);
    freq.put("uar", 256);
    freq.put("Ben", 67);
    freq.put("Bel", 71);
    freq.put("la ", 12741);
    freq.put("Bea", 24);
    freq.put("ook", 29);
    freq.put("oos", 32);
    freq.put("oor", 66);
    freq.put("Ber", 143);
    freq.put("Eda\u0301", 35);
    freq.put("uls", 46);
    freq.put("flu", 158);
    freq.put("ay ", 77);
    freq.put("ult", 520);
    freq.put("ulu", 211);
    freq.put("fli", 22);
    freq.put("uli", 154);
    freq.put("ulo", 152);
    freq.put("flo", 99);
    freq.put("ulm", 39);
    freq.put("fla", 32);
    freq.put("ulc", 17);
    freq.put("ula", 877);
    freq.put("fle", 26);
    freq.put("ulg", 57);
    freq.put("ule", 153);
    freq.put("ma ", 1948);
    freq.put("i\u0301o ", 117);
    freq.put("ia\u0301n", 61);
    freq.put("h\u0323", 48);
    freq.put("Lli", 389);
    freq.put("al\u0323l\u0323", 21);
    freq.put("nyi", 50);
    freq.put("ia\u0301u", 308);
    freq.put("ia\u0301t", 34);
    freq.put("nya", 28);
    freq.put("ia\u0301s", 33);
    freq.put("map", 21);
    freq.put("mas", 367);
    freq.put("sne", 19);
    freq.put("mau", 25);
    freq.put("Ura", 20);
    freq.put("Urb", 17);
    freq.put("mav", 20);
    freq.put("may", 532);
    freq.put("max", 67);
    freq.put("maz", 22);
    freq.put("sni", 17);
    freq.put("Uru", 19);
    freq.put("mac", 286);
    freq.put("mab", 48);
    freq.put("mae", 118);
    freq.put("mad", 506);
    freq.put("mag", 209);
    freq.put("mai", 37);
    freq.put("mam", 57);
    freq.put("mal", 310);
    freq.put("mao", 124);
    freq.put("i\u0301od", 39);
    freq.put("Edi", 36);
    freq.put("q", 9189);
    freq.put("Edw", 21);
    freq.put("Edu", 26);
    freq.put("ny ", 55);
    freq.put("ula\u0301", 21);
    freq.put("lse", 20);
    freq.put("lsa", 65);
    freq.put("lso", 29);
    freq.put("lsi", 32);
    freq.put("lst", 30);
    freq.put(" ab", 564);
    freq.put(" ac", 847);
    freq.put(" ad", 212);
    freq.put(" ae", 36);
    freq.put(" af", 269);
    freq.put(" ag", 469);
    freq.put(" ai", 111);
    freq.put(" al", 4840);
    freq.put(" am", 425);
    freq.put(" an", 1241);
    freq.put(" ap", 490);
    freq.put(" aq", 93);
    freq.put(" ar", 991);
    freq.put(" as", 2830);
    freq.put(" at", 348);
    freq.put("\u0434", 33);
    freq.put(" av", 357);
    freq.put(" ax", 79);
    freq.put(" ay", 44);
    freq.put(" az", 62);
    freq.put("gel", 58);
    freq.put("Shu", 17);
    freq.put("ls ", 41);
    freq.put("Sha", 48);
    freq.put("ori\u0301", 197);
    freq.put("ora\u0301", 93);
    freq.put(" a ", 3328);
    freq.put("Lut", 31);
    freq.put("Luc", 32);
    freq.put("Lug", 22);
    freq.put("Lui", 71);
    freq.put("so\u0301 ", 37);
    freq.put("or ", 4324);
    freq.put("Ken", 29);
    freq.put(" ae\u0301", 16);
    freq.put(" an\u0303", 721);
    freq.put("orx", 23);
    freq.put("ory", 55);
    freq.put("orv", 35);
    freq.put("so\u0301t", 32);
    freq.put("ort", 1641);
    freq.put("oru", 145);
    freq.put("orr", 553);
    freq.put("ors", 62);
    freq.put("orp", 70);
    freq.put("orq", 63);
    freq.put("orn", 284);
    freq.put("oro", 418);
    freq.put("orl", 38);
    freq.put("orm", 1367);
    freq.put("ork", 120);
    freq.put("ori", 1711);
    freq.put("orf", 104);
    freq.put("org", 416);
    freq.put("ord", 534);
    freq.put("ore", 1041);
    freq.put("orb", 73);
    freq.put("orc", 129);
    freq.put("ora", 844);
    freq.put("ca\u0301r", 20);
    freq.put("ca\u0301u", 227);
    freq.put("ca\u0301n", 106);
    freq.put("ca\u0301m", 24);
    freq.put("ca\u0301l", 19);
    freq.put("Apa", 18);
    freq.put("ri\u0301s", 185);
    freq.put("ri\u0301t", 63);
    freq.put("ri\u0301u", 328);
    freq.put("ri\u0301x", 18);
    freq.put("ri\u0301c", 26);
    freq.put("Yan", 18);
    freq.put("ri\u0301g", 37);
    freq.put("ri\u0301d", 34);
    freq.put("ri\u0301e", 56);
    freq.put("ri\u0301n", 137);
    freq.put("ri\u0301o", 117);
    freq.put("Di\u0301", 64);
    freq.put("ch", 2663);
    freq.put(" ot", 485);
    freq.put("zse", 61);
    freq.put("ixu", 29);
    freq.put("e\u0301u ", 675);
    freq.put("Do", 239);
    freq.put("Di", 401);
    freq.put("De", 580);
    freq.put("Da", 253);
    freq.put("2", 338);
    freq.put("Du", 112);
    freq.put("Dr", 63);
    freq.put("e\u0301un", 51);
    freq.put("D ", 104);
    freq.put("ge ", 125);
    freq.put("li\u0301 ", 31);
    freq.put("a\u0301ba", 44);
    freq.put("We", 90);
    freq.put("Wa", 149);
    freq.put("Wo", 66);
    freq.put("a\u0301bi", 20);
    freq.put("Wi", 195);
    freq.put("Wh", 19);
    freq.put("\u0430", 131);
    freq.put("a\u0301br", 70);
    freq.put("Wr", 18);
    freq.put("ges", 32);
    freq.put("ger", 70);
    freq.put("li\u0301p", 19);
    freq.put("li\u0301q", 36);
    freq.put("li\u0301s", 34);
    freq.put("li\u0301t", 508);
    freq.put("jo\u0301", 17);
    freq.put("li\u0301m", 55);
    freq.put("li\u0301n", 134);
    freq.put("li\u0301a", 36);
    freq.put("li\u0301c", 95);
    freq.put("li\u0301d", 46);
    freq.put("gen", 194);
    freq.put("li\u0301g", 17);
    freq.put("W ", 37);
    freq.put("on\u0303e", 19);
    freq.put("o\u0301", 11033);
    freq.put("tu ", 4633);
    freq.put("j ", 29);
    freq.put("tuy", 80);
    freq.put("\u0647", 21);
    freq.put("ju", 47);
    freq.put("tur", 3051);
    freq.put("tus", 74);
    freq.put("tut", 84);
    freq.put("tuv", 113);
    freq.put("jo", 83);
    freq.put("tul", 120);
    freq.put("ji", 60);
    freq.put("tun", 21);
    freq.put("je", 42);
    freq.put("tub", 22);
    freq.put("tuc", 144);
    freq.put("tud", 266);
    freq.put("ja", 162);
    freq.put("cli", 101);
    freq.put("Pe\u0301r", 45);
    freq.put("tum", 35);
    freq.put("tua", 351);
    freq.put("pan\u0303", 1100);
    freq.put("tue", 35);
    freq.put("tug", 146);
    freq.put("pai\u0301", 500);
    freq.put("E\u0301", 65);
    freq.put("oi ", 1865);
    freq.put("pap", 49);
    freq.put("paq", 17);
    freq.put("par", 2397);
    freq.put("pas", 278);
    freq.put("pat", 144);
    freq.put("pay", 209);
    freq.put("paz", 31);
    freq.put("pac", 256);
    freq.put("pad", 57);
    freq.put("pae", 100);
    freq.put("pag", 46);
    freq.put("pai", 29);
    freq.put("pal", 721);
    freq.put("pan", 184);
    freq.put("oin", 36);
    freq.put("A ", 429);
    freq.put("oid", 422);
    freq.put("oic", 29);
    freq.put("oit", 17);
    freq.put("ois", 79);
    freq.put("oir", 30);
    freq.put("pa ", 1442);
    freq.put("mo ", 1668);
    freq.put("u\u0301n ", 552);
    freq.put(" ci\u0301", 44);
    freq.put(" ca\u0301", 76);
    freq.put(" cu\u0301", 30);
    freq.put(" co\u0301", 148);
    freq.put("moz", 32);
    freq.put("\u03c9", 19);
    freq.put("mor", 407);
    freq.put("nau", 64);
    freq.put("i\u0301mp", 31);
    freq.put("mou", 46);
    freq.put("mot", 106);
    freq.put("i\u0301mi", 192);
    freq.put("mon", 476);
    freq.put("mom", 42);
    freq.put("gro", 65);
    freq.put("moc", 159);
    freq.put("mod", 158);
    freq.put("u\u0301ng", 24);
    freq.put("u\u0301ni", 128);
    freq.put("u\u0301nm", 16);
    freq.put("km2", 330);
    freq.put("Nel", 108);
    freq.put("Nem", 16);
    freq.put("Neg", 25);
    freq.put("Nev", 22);
    freq.put("New", 56);
    freq.put("Nes", 38);
    freq.put("Med", 152);
    freq.put(" ch", 241);
    freq.put(" ci", 1440);
    freq.put("Mea", 16);
    freq.put(" co", 11939);
    freq.put(" cl", 324);
    freq.put("Mel", 46);
    freq.put("Men", 63);
    freq.put(" ce", 939);
    freq.put("Met", 34);
    freq.put("Mes", 85);
    freq.put("Mer", 58);
    freq.put(" cr", 559);
    freq.put(" cu", 1361);
    freq.put("\u0447", 31);
    freq.put("Dra", 16);
    freq.put("Dre", 28);
    freq.put("km ", 195);
    freq.put(" I\u0301n", 31);
    freq.put("Ac", 163);
    freq.put("uta\u0301", 63);
    freq.put("Ae", 37);
    freq.put("Avi", 80);
    freq.put("Ave", 35);
    freq.put("po\u0301 ", 34);
    freq.put("n\u0303a\u0301u", 29);
    freq.put("uto\u0301", 240);
    freq.put("u\u0301s ", 39);
    freq.put("Ovi", 16);
    freq.put("po\u0301n", 110);
    freq.put("cli\u0301", 25);
    freq.put("po\u0301s", 38);
    freq.put("Az", 40);
    freq.put("zqu", 94);
    freq.put("u", 91721);
    freq.put("u\u0301sa", 23);
    freq.put("u\u0301sc", 22);
    freq.put("u\u0301si", 222);
    freq.put("Van", 24);
    freq.put("Val", 259);
    freq.put("iu ", 2457);
    freq.put("Var", 28);
    freq.put("Vas", 51);
    freq.put("hy ", 16);
    freq.put("aba\u0301", 24);
    freq.put("abo\u0301", 38);
    freq.put("\u0438", 150);
    freq.put("ium", 56);
    freq.put("\u03c5\u0301", 20);
    freq.put("iud", 721);
    freq.put("TA ", 21);
    freq.put("got", 23);
    freq.put("ius", 100);
    freq.put("SI ", 22);
    freq.put("aba", 622);
    freq.put("gl", 987);
    freq.put("abe", 598);
    freq.put("abi", 549);
    freq.put("abl", 405);
    freq.put("abo", 250);
    freq.put("\u0430 ", 31);
    freq.put("abs", 37);
    freq.put("abu", 117);
    freq.put("gh", 164);
    freq.put("BL ", 43);
    freq.put("K", 782);
    freq.put("ggi", 23);
    freq.put("ab ", 34);
    freq.put("a\u0300", 48);
    freq.put("ive", 607);
    freq.put("eya", 316);
    freq.put("twa", 73);
    freq.put("eye", 150);
    freq.put("eyo", 225);
    freq.put("eyu", 1414);
    freq.put("de ", 27799);
    freq.put("dex", 75);
    freq.put("ey ", 104);
    freq.put("dez", 86);
    freq.put("dep", 485);
    freq.put("der", 1214);
    freq.put("des", 1739);
    freq.put("det", 138);
    freq.put("deu", 20);
    freq.put("dev", 28);
    freq.put("dei", 63);
    freq.put("del", 7014);
    freq.put("dem", 357);
    freq.put("den", 2354);
    freq.put("deo", 123);
    freq.put("dea", 108);
    freq.put("deb", 61);
    freq.put("dec", 190);
    freq.put("ded", 88);
    freq.put("dee", 31);
    freq.put("def", 193);
    freq.put("deg", 22);
    freq.put("eya\u0301", 53);
    freq.put("rye", 29);
    freq.put("Don", 42);
    freq.put("Dol", 17);
    freq.put("Dom", 56);
    freq.put("pri", 1008);
    freq.put("Dor", 36);
    freq.put("Dou", 19);
    freq.put("cs ", 26);
    freq.put("ry ", 136);
    freq.put("ok ", 39);
    freq.put("pci", 73);
    freq.put("Bat", 46);
    freq.put("oku", 21);
    freq.put("Bas", 101);
    freq.put("Bax", 65);
    freq.put("Bad", 39);
    freq.put("Bab", 18);
    freq.put("Bac", 16);
    freq.put("oki", 18);
    freq.put("Bal", 105);
    freq.put("Uni\u0301", 41);
    freq.put("oko", 16);
    freq.put("Un ", 261);
    freq.put("mm ", 16);
    freq.put("E ", 376);
    freq.put("sbu", 45);
    freq.put("\u044f", 22);
    freq.put("Una", 127);
    freq.put("mmo", 23);
    freq.put("sbe", 24);
    freq.put("mme", 31);
    freq.put("Uni", 330);
    freq.put("mma", 49);
    freq.put("sbo", 41);
    freq.put("Em", 99);
    freq.put("El", 2308);
    freq.put("Eo", 32);
    freq.put("En", 482);
    freq.put("Ei", 40);
    freq.put("Ed", 146);
    freq.put("Ea", 30);
    freq.put("Ec", 65);
    freq.put("u\u0301lt", 86);
    freq.put("Ex", 95);
    freq.put("Eu", 376);
    freq.put("Et", 47);
    freq.put("Ev", 36);
    freq.put("Ep", 27);
    freq.put("Es", 1862);
    freq.put("Er", 108);
    freq.put("tov", 20);
    freq.put("go\u0301", 130);
    freq.put(" el", 2636);
    freq.put(" em", 659);
    freq.put(" en", 6218);
    freq.put("kon", 21);
    freq.put(" ed", 347);
    freq.put("X ", 215);
    freq.put(" ec", 202);
    freq.put(" ex", 331);
    freq.put(" et", 148);
    freq.put(" eu", 126);
    freq.put(" ev", 88);
    freq.put(" ep", 35);
    freq.put(" eq", 228);
    freq.put(" er", 72);
    freq.put(" es", 5692);
    freq.put("zg", 16);
    freq.put("I\u0301", 44);
    freq.put("gu\u0301", 228);
    freq.put("Ato\u0301", 23);
    freq.put("vi\u0301a", 37);
    freq.put("b", 16342);
    freq.put("Xo", 93);
    freq.put("ko ", 38);
    freq.put("Xa", 147);
    freq.put(" e ", 31);
    freq.put("Xe", 228);
    freq.put("Xu", 749);
    freq.put("zz", 45);
    freq.put("k ", 659);
    freq.put("Kir", 17);
    freq.put("Kie", 17);
    freq.put("Ate", 33);
    freq.put("Ato", 66);
    freq.put("Atl", 105);
    freq.put("ka", 300);
    freq.put("ke", 236);
    freq.put("kk", 28);
    freq.put("ki", 250);
    freq.put("kh", 62);
    freq.put("ko", 185);
    freq.put("km", 543);
    freq.put("kl", 60);
    freq.put("ks", 90);
    freq.put("kr", 23);
    freq.put("ku", 83);
    freq.put("kt", 30);
    freq.put("ky", 43);
    freq.put("Xib", 16);
    freq.put("\u1100\u1161\u1100\u1161\u1100\u1161", 21);
    freq.put(" Ba\u0301", 39);
    freq.put("re\u0301x", 27);
    freq.put("re\u0301u", 161);
    freq.put(" Be\u0301", 34);
    freq.put("re\u0301s", 114);
    freq.put("re\u0301n", 37);
    freq.put("re\u0301i", 18);
    freq.put("Xix", 193);
    freq.put("Ope", 25);
    freq.put("i\u0301na", 37);
    freq.put("re\u0301 ", 31);
    freq.put(" Be", 395);
    freq.put(" Ba", 826);
    freq.put(" Bl", 92);
    freq.put(" Bo", 398);
    freq.put(" Bi", 230);
    freq.put(" Bu", 303);
    freq.put("ik ", 42);
    freq.put(" Br", 356);
    freq.put("Ye ", 522);
    freq.put("\u0430\u043d", 17);
    freq.put("\u03ba", 39);
    freq.put(" B ", 27);
    freq.put("ika", 28);
    freq.put(" ce\u0301", 62);
    freq.put("ike", 29);
    freq.put("iki", 34);
    freq.put("iko", 46);
    freq.put("Yer", 45);
    freq.put("lbu", 85);
    freq.put("ga ", 844);
    freq.put("le\u0301g", 36);
    freq.put("a\u0301fi", 191);
    freq.put("le\u0301c", 44);
    freq.put("le\u0301n", 22);
    freq.put("le\u0301t", 51);
    freq.put("ran", 1993);
    freq.put("fu ", 128);
    freq.put("le\u0301s", 351);
    freq.put("gau", 26);
    freq.put("gat", 69);
    freq.put("gas", 371);
    freq.put("gar", 624);
    freq.put("gao", 45);
    freq.put("gan", 689);
    freq.put("gam", 197);
    freq.put("gal", 282);
    freq.put("gai", 57);
    freq.put("gae", 105);
    freq.put("gad", 370);
    freq.put("gac", 106);
    freq.put("gab", 21);
    freq.put("lba", 89);
    freq.put("fut", 80);
    freq.put("fur", 46);
    freq.put("fus", 78);
    freq.put("fue", 313);
    freq.put("fun", 482);
    freq.put("rar", 318);
    freq.put("Mo\u0301n", 16);
    freq.put("Irl", 54);
    freq.put("Ira", 24);
    freq.put("\u0421", 20);
    freq.put("yi\u0301u", 76);
    freq.put("ewa", 17);
    freq.put("ceb", 24);
    freq.put("yi\u0301a", 23);
    freq.put("mos", 473);
    freq.put("yi\u0301e", 17);

    init2();
  }
  private static void init2() {
    
    freq.put("lbo", 29);
    freq.put("yi\u0301o", 18);
    freq.put("ewt", 17);
    freq.put("dge", 23);
    freq.put("cea", 219);
    freq.put("gan\u0303", 29);
    freq.put("mov", 217);
    freq.put("A\u0301nx", 16);
    freq.put("ew ", 37);
    freq.put("y", 24372);
    freq.put("lda", 49);
    freq.put("lde", 218);
    freq.put("ldi", 28);
    freq.put("mol", 131);
    freq.put("ldo", 47);
    freq.put("bi ", 25);
    freq.put("lds", 26);
    freq.put("i\u0301me", 34);
    freq.put("ldu", 19);
    freq.put("rgr", 20);
    freq.put("cut", 92);
    freq.put("cus", 67);
    freq.put("rgu", 206);
    freq.put("cup", 241);
    freq.put("pen\u0303", 17);
    freq.put("cuy", 40);
    freq.put("rga", 575);
    freq.put("cue", 595);
    freq.put("cud", 83);
    freq.put("cuc", 28);
    freq.put("cub", 402);
    freq.put("cua", 678);
    freq.put("rgi", 50);
    freq.put("cum", 104);
    freq.put("i\u0301mb", 125);
    freq.put("cui", 49);
    freq.put("rgo", 165);
    freq.put("bin", 125);
    freq.put("bio", 125);
    freq.put("Din", 49);
    freq.put("ld ", 90);
    freq.put("Die", 34);
    freq.put("bid", 32);
    freq.put("bie", 696);
    freq.put("bic", 56);
    freq.put("Dic", 27);
    freq.put("Dix", 21);
    freq.put("Div", 52);
    freq.put("biu", 87);
    freq.put("Dip", 20);
    freq.put("bis", 87);
    freq.put("Dis", 65);
    freq.put("A\u0301f", 122);
    freq.put("A\u0301l", 49);
    freq.put("A\u0301n", 47);
    freq.put("rg ", 125);
    freq.put("A\u0301r", 37);
    freq.put("cu ", 2717);
    freq.put("lda\u0301", 19);
    freq.put("lde\u0301", 31);
    freq.put("c\u0327a", 22);
    freq.put("c\u0327o", 23);
    freq.put("oe ", 28);
    freq.put("pex", 28);
    freq.put("pez", 52);
    freq.put("pet", 117);
    freq.put("peu", 83);
    freq.put("rgu\u0308", 18);
    freq.put("peq", 143);
    freq.put("per", 2638);
    freq.put("pes", 166);
    freq.put("pel", 341);
    freq.put("rga\u0301", 55);
    freq.put("pen", 495);
    freq.put("peo", 49);
    freq.put("cua\u0301", 18);
    freq.put("ped", 99);
    freq.put("pee", 18);
    freq.put("peg", 17);
    freq.put("pea", 117);
    freq.put("cue\u0301", 64);
    freq.put("pec", 563);
    freq.put("ufi", 20);
    freq.put("bie\u0301", 83);
    freq.put("oes", 686);
    freq.put("Bor", 65);
    freq.put("Bos", 24);
    freq.put("Bot", 38);
    freq.put("Bou", 21);
    freq.put("oeu", 49);
    freq.put("Bow", 18);
    freq.put("Boi", 18);
    freq.put("Bol", 54);
    freq.put("oen", 67);
    freq.put("Bon", 40);
    freq.put("oel", 20);
    freq.put("usc", 78);
    freq.put("ufr", 46);
    freq.put("Bod", 16);
    freq.put("bio\u0301", 37);
    freq.put("\u03c2 ", 88);
    freq.put("a\u0308", 33);
    freq.put("uso", 39);
    freq.put("pe ", 155);
    freq.put("Hun", 21);
    freq.put("nsh", 24);
    freq.put("nsi", 871);
    freq.put("nsk", 21);
    freq.put("nso", 139);
    freq.put("nsa", 253);
    freq.put("nsc", 32);
    freq.put("nse", 670);
    freq.put("nsp", 25);
    freq.put("nst", 592);
    freq.put("nsu", 245);
    freq.put("rig", 153);
    freq.put(" gu\u0308", 82);
    freq.put("fet", 24);
    freq.put("go\u0301 ", 44);
    freq.put("ust", 501);
    freq.put("uss", 68);
    freq.put(" ge\u0301", 51);
    freq.put("ns ", 160);
    freq.put("Flo", 57);
    freq.put("o\u0301fi", 19);
    freq.put("Fla", 29);
    freq.put("sdo", 17);
    freq.put("go\u0301n", 70);
    freq.put("Map", 17);
    freq.put("Mas", 52);
    freq.put("Mar", 656);
    freq.put("Mau", 37);
    freq.put("Mat", 73);
    freq.put("May", 42);
    freq.put("Max", 26);
    freq.put("Maz", 16);
    freq.put("Mac", 60);
    freq.put(" ge", 17);
    freq.put("Mad", 200);
    freq.put("Mag", 63);
    freq.put(" ga", 428);
    freq.put("Mai", 22);
    freq.put(" go", 272);
    freq.put(" gl", 39);
    freq.put("o", 37);
    freq.put("Mal", 98);
    freq.put("Man", 189);
    freq.put("ly ", 63);
    freq.put("Mec", 17);
    freq.put(" cc", 16);
    freq.put(" b", 2190);
    freq.put(" c", 20715);
    freq.put(" a", 19027);
    freq.put(" f", 7716);
    freq.put(" g", 2525);
    freq.put(" d", 46129);
    freq.put(" e", 16924);
    freq.put(" j", 77);
    freq.put(" k", 702);
    freq.put(" h", 2338);
    freq.put(" i", 3817);
    freq.put(" n", 11804);
    freq.put(" o", 6140);
    freq.put(" l", 23253);
    freq.put(" m", 9040);
    freq.put(" r", 4756);
    freq.put(" s", 11692);
    freq.put(" p", 18092);
    freq.put(" q", 5676);
    freq.put(" v", 2629);
    freq.put(" w", 106);
    freq.put(" t", 7293);
    freq.put(" u", 11203);
    freq.put(" z", 295);
    freq.put(" x", 2510);
    freq.put(" y", 18192);
    freq.put(" B", 2864);
    freq.put(" C", 6094);
    freq.put(" A", 5969);
    freq.put(" F", 2448);
    freq.put(" G", 2207);
    freq.put(" D", 1850);
    freq.put(" E", 5891);
    freq.put(" J", 930);
    freq.put(" K", 778);
    freq.put(" H", 1351);
    freq.put(" I", 2314);
    freq.put(" N", 2370);
    freq.put(" O", 1346);
    freq.put(" L", 6293);
    freq.put(" M", 3983);
    freq.put(" R", 2699);
    freq.put(" N\u0303a", 32);
    freq.put(" P", 4277);
    freq.put(" Q", 208);
    freq.put(" V", 1588);
    freq.put(" W", 595);
    freq.put(" T", 2891);
    freq.put(" U", 1452);
    freq.put(" Z", 342);
    freq.put(" X", 1854);
    freq.put(" Y", 850);
    freq.put("Pen\u0303", 79);
    freq.put("se\u0301 ", 157);
    freq.put(" a\u0301", 535);
    freq.put(" e\u0301", 208);
    freq.put(" i\u0301", 25);
    freq.put(" o\u0301", 107);
    freq.put(" n\u0303", 154);
    freq.put(" u\u0301", 415);
    freq.put(" A\u0301", 292);
    freq.put("Ort", 25);
    freq.put(" E\u0301", 63);
    freq.put(" I\u0301", 44);
    freq.put(" O\u0301", 24);
    freq.put(" N\u0303", 39);
    freq.put("Ori", 91);
    freq.put(" U\u0301", 43);
    freq.put("Org", 53);
    freq.put("Ord", 31);
    freq.put("Ore", 17);
    freq.put("och", 360);
    freq.put("ock", 143);
    freq.put(" o", 31);
    freq.put(" Do", 233);
    freq.put("Ver", 46);
    freq.put(" Di", 400);
    freq.put("oce", 410);
    freq.put(" De", 575);
    freq.put(" Da", 253);
    freq.put("Veg", 43);
    freq.put("ii ", 21);
    freq.put("Ven", 81);
    freq.put(" Du", 112);
    freq.put(" Dr", 63);
    freq.put("Vei", 55);
    freq.put("cha", 467);
    freq.put("Fr", 572);
    freq.put("che", 415);
    freq.put("chi", 367);
    freq.put("chl", 20);
    freq.put("chm", 21);
    freq.put("chn", 18);
    freq.put("cho", 541);
    freq.put("Fa", 190);
    freq.put("cht", 28);
    freq.put("chu", 324);
    freq.put("chw", 26);
    freq.put("chy", 17);
    freq.put("Fl", 108);
    freq.put("Fo", 574);
    freq.put(" D ", 45);
    freq.put("N\u0303", 39);
    freq.put("ch ", 336);
    freq.put("f", 13542);
    freq.put("ocu", 230);
    freq.put("F ", 56);
    freq.put(" Di\u0301", 64);
    freq.put("afl", 31);
    freq.put("Fo\u0301", 67);
    freq.put("afi", 101);
    freq.put("Yo", 129);
    freq.put("Ya", 43);
    freq.put("afe", 77);
    freq.put("Fu\u0301", 24);
    freq.put("Ye", 596);
    freq.put("afa", 87);
    freq.put("cho\u0301", 21);
    freq.put("afu", 49);
    freq.put("Yu", 23);
    freq.put("Fi\u0301", 30);
    freq.put("afr", 88);
    freq.put("a\u0301di", 17);
    freq.put("usa\u0301", 58);
    freq.put("Y ", 19);
    freq.put("da ", 4811);
    freq.put("eum", 20);
    freq.put("lg", 493);
    freq.put("ld", 549);
    freq.put("le", 10684);
    freq.put("lb", 291);
    freq.put("lc", 626);
    freq.put("la", 19472);
    freq.put("ln", 49);
    freq.put("eud", 47);
    freq.put("ll", 8884);
    freq.put("lm", 1118);
    freq.put("\u0432\u0438", 30);
    freq.put("lk", 61);
    freq.put("lh", 86);
    freq.put("li", 7423);
    freq.put("lv", 285);
    freq.put("lt", 1524);
    freq.put("lu", 3790);
    freq.put("lr", 98);
    freq.put("ls", 261);
    freq.put("lp", 107);
    freq.put("lq", 50);
    freq.put("eut", 545);
    freq.put("rea\u0301", 61);
    freq.put("lz", 32);
    freq.put("eus", 64);
    freq.put("ly", 137);
    freq.put("dad", 302);
    freq.put("dae", 548);
    freq.put("daf", 42);
    freq.put("dag", 35);
    freq.put("dab", 30);
    freq.put("dac", 111);
    freq.put("dal", 304);
    freq.put("dam", 245);
    freq.put("dan", 229);
    freq.put("dao", 57);
    freq.put("dai", 16);
    freq.put("dat", 124);
    freq.put("dau", 68);
    freq.put("dav", 109);
    freq.put("\u05d5", 22);
    freq.put("daq", 25);
    freq.put("dar", 315);
    freq.put("das", 91);
    freq.put("que\u0301", 54);
    freq.put("qui\u0301", 261);
    freq.put("day", 19);
    freq.put("l ", 29722);
    freq.put("emb", 555);
    freq.put("eu ", 243);
    freq.put("ts ", 74);
    freq.put("lfa", 88);
    freq.put("lfo", 62);
    freq.put("lfi", 20);
    freq.put("lfu", 37);
    freq.put("qu ", 816);
    freq.put("lfr", 17);
    freq.put("rez", 171);
    freq.put("emu", 81);
    freq.put("rex", 365);
    freq.put("rey", 119);
    freq.put("la\u0301", 539);
    freq.put("rer", 492);
    freq.put("res", 4685);
    freq.put("rep", 415);
    freq.put("li\u0301", 1076);
    freq.put("rev", 251);
    freq.put("Tuv", 23);
    freq.put("reu", 146);
    freq.put("reh", 18);
    freq.put("rei", 297);
    freq.put("ren", 1024);
    freq.put("reo", 54);
    freq.put("rel", 542);
    freq.put("rem", 615);
    freq.put("reb", 62);
    freq.put("rec", 906);
    freq.put("rea", 608);
    freq.put("ref", 354);
    freq.put("reg", 285);
    freq.put("red", 307);
    freq.put("ree", 114);
    freq.put("lf ", 21);
    freq.put("qua", 36);
    freq.put("que", 6063);
    freq.put("qui", 1856);
    freq.put("re ", 1676);
    freq.put("ud ", 39);
    freq.put("og ", 21);
    freq.put("mie\u0301", 656);
    freq.put("udu", 102);
    freq.put("ogu", 113);
    freq.put("nur", 23);
    freq.put("hec", 44);
    freq.put("ogr", 528);
    freq.put("ogl", 32);
    freq.put("ogo", 56);
    freq.put("ogn", 18);
    freq.put("ude", 99);
    freq.put("oge", 21);
    freq.put("udi", 427);
    freq.put("oga", 61);
    freq.put("udo", 71);
    freq.put("Pel", 32);
    freq.put("Pen", 123);
    freq.put("Pap", 33);
    freq.put("Par", 403);
    freq.put("Pas", 56);
    freq.put("Pat", 42);
    freq.put("Pau", 56);
    freq.put("nqu", 282);
    freq.put("Pab", 26);
    freq.put("Pac", 77);
    freq.put("Pad", 16);
    freq.put("Pal", 176);
    freq.put("Pan", 73);
    freq.put("mil", 888);
    freq.put("mio", 73);
    freq.put("min", 1131);
    freq.put("\u0629", 33);
    freq.put("mic", 620);
    freq.put("mib", 17);
    freq.put("mie", 1057);
    freq.put("mid", 168);
    freq.put("mig", 50);
    freq.put("miq", 40);
    freq.put("mis", 272);
    freq.put("mir", 80);
    freq.put("miu", 137);
    freq.put("mit", 369);
    freq.put("udo\u0301", 24);
    freq.put(" \u03a0", 16);
    freq.put("il\u0323", 41);
    freq.put("ogi\u0301", 16);
    freq.put("sfo", 48);
    freq.put("uda\u0301", 675);
    freq.put("sfe", 100);
    freq.put("oga\u0301", 26);
    freq.put("udi\u0301", 36);
    freq.put("mi ", 43);
    freq.put("oca\u0301", 24);
    freq.put("kst", 18);
    freq.put(" iz", 53);
    freq.put("Mos", 39);
    freq.put("Mor", 121);
    freq.put(" ir", 73);
    freq.put(" is", 341);
    freq.put(" it", 127);
    freq.put("Mov", 42);
    freq.put("Mot", 20);
    freq.put(" il", 78);
    freq.put(" im", 368);
    freq.put(" in", 2323);
    freq.put("Mol", 41);
    freq.put(" ib", 34);
    freq.put(" id", 238);
    freq.put(" ig", 81);
    freq.put(" \u0421", 20);
    freq.put(" \u0410", 21);
    freq.put("ks ", 27);
    freq.put(" i ", 49);
    freq.put(" \u041c", 18);
    freq.put(" Iz", 37);
    freq.put("S", 4455);
    freq.put("e\u0300", 53);
    freq.put("\u0628", 57);
    freq.put("du\u0301", 25);
    freq.put("uia", 712);
    freq.put(" Fo\u0301", 67);
    freq.put(" Fu\u0301", 24);
    freq.put("ohn", 44);
    freq.put("oho", 28);
    freq.put("uie", 423);
    freq.put(" Fi\u0301", 30);
    freq.put("uid", 100);
    freq.put("ys ", 17);
    freq.put("ai", 1224);
    freq.put("ohe", 28);
    freq.put("ak", 265);
    freq.put("Hom", 28);
    freq.put("cos", 857);
    freq.put("oha", 77);
    freq.put("cor", 535);
    freq.put("uio", 37);
    freq.put("cou", 18);
    freq.put("uin", 242);
    freq.put("mi\u0301n", 82);
    freq.put("ap", 1853);
    freq.put("ila", 250);
    freq.put("as", 8608);
    freq.put("uir", 77);
    freq.put("au", 1861);
    freq.put("yst", 32);
    freq.put(" Fr", 571);
    freq.put(" Fu", 162);
    freq.put("uiv", 101);
    freq.put(" Fa", 190);
    freq.put(" Fe", 384);
    freq.put(" Fi", 203);
    freq.put(" Fl", 108);
    freq.put(" Fo", 566);
    freq.put("io ", 599);
    freq.put("coa", 45);
    freq.put("No\u0301", 21);
    freq.put("e\u0301mi", 45);
    freq.put("coc", 95);
    freq.put("cob", 62);
    freq.put("cod", 27);
    freq.put("SO ", 62);
    freq.put("cog", 27);
    freq.put("iox", 22);
    freq.put("iov", 27);
    freq.put("iot", 63);
    freq.put("ios", 784);
    freq.put("ior", 332);
    freq.put("ioq", 17);
    freq.put("iop", 28);
    freq.put(" F ", 28);
    freq.put("iom", 101);
    freq.put("iol", 155);
    freq.put("iog", 28);
    freq.put("iod", 211);
    freq.put("ioc", 40);
    freq.put("ioa", 16);
    freq.put("tix", 20);
    freq.put("\u0435\u0440", 16);
    freq.put("adu", 176);
    freq.put("adr", 334);
    freq.put("ads", 20);
    freq.put(" \u0645", 16);
    freq.put("gma", 22);
    freq.put("esu\u0301", 33);
    freq.put("gme", 24);
    freq.put("ade", 392);
    freq.put("\u0432 ", 16);
    freq.put("ada", 3004);
    freq.put("ado", 1087);
    freq.put("esi\u0301", 43);
    freq.put("\u043c", 36);
    freq.put("ese\u0301", 32);
    freq.put("adi", 574);
    freq.put(" \u0627", 57);
    freq.put(" \u0628", 25);
    freq.put("\u0435\u0432", 18);
    freq.put("ad ", 117);
    freq.put("ui ", 109);
    freq.put("esu", 366);
    freq.put("est", 5451);
    freq.put("ess", 77);
    freq.put("tmu", 25);
    freq.put("esq", 106);
    freq.put("esp", 1789);
    freq.put("ya\u0301u", 62);
    freq.put("lta\u0301", 55);
    freq.put("esg", 22);
    freq.put("esf", 97);
    freq.put("ese", 1102);
    freq.put("esc", 1607);
    freq.put("esb", 39);
    freq.put("esa", 794);
    freq.put("ada\u0301", 42);
    freq.put("eso", 271);
    freq.put("esn", 31);
    freq.put("esm", 461);
    freq.put("esl", 77);
    freq.put("esi", 1121);
    freq.put("esh", 42);
    freq.put("es ", 19125);
    freq.put("\u4e09 ", 50);
    freq.put("ya\u0301 ", 77);
    freq.put("pie\u0301", 58);
    freq.put("De ", 32);
    freq.put("pin\u0303", 46);
    freq.put("bu ", 154);
    freq.put("rcu", 304);
    freq.put("rco", 111);
    freq.put("rch", 113);
    freq.put("rci", 507);
    freq.put("rce", 358);
    freq.put("rca", 415);
    freq.put("bux", 74);
    freq.put("buy", 30);
    freq.put("mu\u0301s", 219);
    freq.put("bur", 154);
    freq.put("bus", 73);
    freq.put("Der", 35);
    freq.put("buq", 20);
    freq.put("but", 23);
    freq.put("bun", 42);
    freq.put("Dem", 67);
    freq.put("bul", 54);
    freq.put("bum", 70);
    freq.put("mu\u0301l", 20);
    freq.put("buc", 50);
    freq.put("mu\u0301n", 88);
    freq.put("Dec", 22);
    freq.put("bud", 22);
    freq.put("bue", 28);
    freq.put("j", 524);
    freq.put("pil", 85);
    freq.put("pin", 171);
    freq.put("pio", 102);
    freq.put("pia", 114);
    freq.put("pic", 163);
    freq.put("pid", 65);
    freq.put("pie", 263);
    freq.put("ub ", 108);
    freq.put("su\u0301s", 33);
    freq.put("pir", 74);
    freq.put("pis", 103);
    freq.put("pit", 556);
    freq.put("piu", 106);
    freq.put("oac", 28);
    freq.put("oan", 20);
    freq.put("oam", 37);
    freq.put("oal", 36);
    freq.put("rci\u0301", 102);
    freq.put("xo\u0301 ", 19);
    freq.put("oat", 20);
    freq.put("oaq", 22);
    freq.put("rca\u0301", 36);
    freq.put("ubu", 25);
    freq.put("Aca", 63);
    freq.put("ubr", 90);
    freq.put("Ach", 21);
    freq.put("ube", 103);
    freq.put("ubf", 17);
    freq.put("ubg", 20);
    freq.put("uba", 76);
    freq.put("ubc", 17);
    freq.put("ubl", 254);
    freq.put("ubo", 19);
    freq.put("ubi", 385);
    freq.put("oa ", 90);
    freq.put("xo\u0301n", 516);
    freq.put("Cro", 26);
    freq.put("G ", 53);
    freq.put("\u0644", 104);
    freq.put("\u05d9", 25);
    freq.put("Gu", 363);
    freq.put("Gr", 550);
    freq.put("Ge", 130);
    freq.put("i\u0301u ", 1715);
    freq.put("Ga", 503);
    freq.put("Go", 304);
    freq.put("Gl", 33);
    freq.put("Gi", 109);
    freq.put("Gh", 17);
    freq.put(" ka", 31);
    freq.put(" ke", 20);
    freq.put(" ki", 40);
    freq.put(" ko", 16);
    freq.put(" km", 529);
    freq.put("fe\u0301r", 22);
    freq.put("ain", 145);
    freq.put("\u03c2", 88);
    freq.put("ws ", 21);
    freq.put("tiu", 81);
    freq.put("di\u0301a", 187);
    freq.put("Zo", 24);
    freq.put("Zh", 26);
    freq.put("Zi", 35);
    freq.put("Ze", 65);
    freq.put("Gu\u0308", 19);
    freq.put("Za", 126);
    freq.put("di\u0301n", 17);
    freq.put("di\u0301o", 28);
    freq.put("di\u0301s", 25);
    freq.put("di\u0301u", 78);
    freq.put("Zu", 29);
    freq.put("ku ", 25);
    freq.put("Kom", 18);
    freq.put("ena\u0301", 22);
    freq.put("m ", 1024);
    freq.put("ene\u0301", 75);
    freq.put("si\u0301t", 44);
    freq.put("eni\u0301", 297);
    freq.put("si\u0301n", 34);
    freq.put("si\u0301m", 124);
    freq.put("eno\u0301", 105);
    freq.put("si\u0301a", 43);
    freq.put("me", 7632);
    freq.put("ma", 8216);
    freq.put("g", 16789);
    freq.put("mb", 2125);
    freq.put("mm", 143);
    freq.put("ml", 22);
    freq.put("mo", 3979);
    freq.put("mn", 124);
    freq.put("mi", 5793);
    freq.put("mu", 3551);
    freq.put("mt", 16);
    freq.put("mp", 2781);
    freq.put("ms", 60);
    freq.put("my", 40);
    freq.put("si\u0301 ", 87);
    freq.put("Xov", 26);
    freq.put("l\u0323e", 52);
    freq.put("Xos", 46);
    freq.put("l\u0323a", 78);
    freq.put("l\u0323o", 19);
    freq.put("l\u0323u", 24);
    freq.put("ena", 778);
    freq.put("enb", 40);
    freq.put("enc", 1521);
    freq.put("end", 2502);
    freq.put("ene", 1538);
    freq.put("enf", 111);
    freq.put("eng", 132);
    freq.put("enh", 27);
    freq.put("eni", 391);
    freq.put("enl", 125);
    freq.put("enn", 67);
    freq.put("eno", 533);
    freq.put("enr", 88);
    freq.put("ens", 1312);
    freq.put("ent", 8699);
    freq.put("enu", 205);
    freq.put("env", 116);
    freq.put("m2", 332);
    freq.put("enx", 24);
    freq.put("enz", 88);
    freq.put("h\u0323a", 19);
    freq.put("II ", 206);
    freq.put("en ", 7221);
    freq.put("ma\u0301", 2258);
    freq.put("mi\u0301", 278);
    freq.put("me\u0301", 390);
    freq.put("nu\u0301c", 46);
    freq.put("mo\u0301", 387);
    freq.put("nu\u0301n", 24);
    freq.put("nu\u0301m", 450);
    freq.put("mu\u0301", 331);
    freq.put(" Hy", 28);
    freq.put(" Hu", 144);
    freq.put(" Hi", 165);
    freq.put(" Ho", 253);
    freq.put("on\u0303a", 37);
    freq.put("on\u0303o", 20);
    freq.put(" Ha", 238);
    freq.put(" He", 416);
    freq.put("ima", 551);
    freq.put("e\u0301ci", 17);
    freq.put("clo", 43);
    freq.put("ime", 897);
    freq.put("e\u0301cn", 25);
    freq.put("imi", 537);
    freq.put("cle", 189);
    freq.put("e\u0301ca", 57);
    freq.put("imm", 19);
    freq.put("cla", 286);
    freq.put("imo", 240);
    freq.put("imn", 85);
    freq.put("imp", 398);
    freq.put("imu", 192);
    freq.put("clu", 202);
    freq.put("sob", 374);
    freq.put("e\u0301cu", 21);
    freq.put("e\u0301ct", 28);
    freq.put("SA ", 20);
    freq.put(" H ", 25);
    freq.put("im ", 82);
    freq.put("\u064a ", 22);
    freq.put(" He\u0301", 16);
    freq.put("\u03c4", 50);
    freq.put("ima\u0301", 35);
    freq.put("gol", 162);
    freq.put("gon", 180);
    freq.put("ime\u0301", 20);
    freq.put("cla\u0301", 65);
    freq.put("goc", 33);
    freq.put("gob", 181);
    freq.put("clu\u0301", 60);
    freq.put("goz", 19);
    freq.put("aja", 27);
    freq.put("gov", 37);
    freq.put("gos", 479);
    freq.put("gor", 144);
    freq.put("W", 603);
    freq.put("Vic", 71);
    freq.put("Vie", 101);
    freq.put("go ", 402);
    freq.put("Vil", 213);
    freq.put("Vir", 52);
    freq.put("Vis", 20);
    freq.put("Viv", 19);
    freq.put("be ", 295);
    freq.put("nhe", 19);
    freq.put("nha", 46);
    freq.put("rai\u0301", 47);
    freq.put("Y", 851);
    freq.put("ran\u0303", 42);
    freq.put("tox", 16);
    freq.put(" Sk", 26);
    freq.put("tor", 2063);
    freq.put("tos", 1182);
    freq.put("top", 237);
    freq.put("equ", 432);
    freq.put("tot", 82);
    freq.put("tou", 55);
    freq.put("tok", 21);
    freq.put("toi", 21);
    freq.put("ton", 504);
    freq.put("too", 72);
    freq.put("tol", 431);
    freq.put("tom", 231);
    freq.put("toc", 109);
    freq.put("toa", 32);
    freq.put("tog", 75);
    freq.put("tod", 104);
    freq.put("toe", 19);
    freq.put("nh ", 23);
    freq.put("Fue", 58);
    freq.put("Fun", 63);
    freq.put("to ", 643);
    freq.put("thu", 114);
    freq.put("raf", 159);
    freq.put("rag", 216);
    freq.put("rad", 932);
    freq.put("rae", 111);
    freq.put("rab", 475);
    freq.put("rac", 757);
    freq.put("\u4e09", 112);
    freq.put("rao", 123);
    freq.put("ral", 1367);
    freq.put("ram", 599);
    freq.put("rak", 23);
    freq.put("rah", 27);
    freq.put("rai", 98);
    freq.put("rav", 244);
    freq.put("rat", 679);
    freq.put("rau", 234);
    freq.put("lbe", 58);
    freq.put("ras", 481);
    freq.put("rap", 76);
    freq.put("raq", 33);
    freq.put("lbi", 17);
    freq.put("raz", 108);
    freq.put("rax", 42);
    freq.put("ray", 68);
    freq.put("Sys", 17);
    freq.put("thi", 23);
    freq.put("ra ", 4485);
    freq.put("bso", 28);
    freq.put("bse", 64);
    freq.put("gne\u0301", 52);
    freq.put("Ita", 69);
    freq.put("AS ", 33);
    freq.put("e\u0301y", 32);
    freq.put("e\u0301x", 158);
    freq.put("e\u0301p", 50);
    freq.put("e\u0301s", 1582);
    freq.put("e\u0301r", 899);
    freq.put("e\u0301u", 740);
    freq.put("e\u0301t", 380);
    freq.put("e\u0301v", 26);
    freq.put("e\u0301i", 42);
    freq.put("e\u0301m", 73);
    freq.put("e\u0301l", 309);
    freq.put("e\u0301n", 1459);
    freq.put("e\u0301a", 170);
    freq.put("e\u0301c", 158);
    freq.put("e\u0301b", 38);
    freq.put("e\u0301e", 19);
    freq.put("e\u0301d", 70);
    freq.put("e\u0301g", 51);
    freq.put("e\u0301f", 17);
    freq.put("oci", 878);
    freq.put("Bio", 23);
    freq.put("Bil", 53);
    freq.put(" u\u0301n", 315);
    freq.put("mun\u0303", 170);
    freq.put("ocl", 37);
    freq.put("oco", 142);
    freq.put("oca", 521);
    freq.put("occ", 285);
    freq.put("Bie", 36);
    freq.put("Bib", 22);
    freq.put("abr", 675);
    freq.put("ocr", 117);
    freq.put("Bir", 20);
    freq.put("oct", 67);
    freq.put(" u\u0301s", 29);
    freq.put("\u0440", 94);
    freq.put("Exe\u0301", 20);
    freq.put("e\u0301 ", 349);
    freq.put("ura\u0301", 56);
    freq.put("uri\u0301", 53);
    freq.put("nux", 27);
    freq.put("Pet", 88);
    freq.put("nut", 29);
    freq.put("Pep", 22);
    freq.put("nus", 49);
    freq.put("Per", 191);
    freq.put("nun", 649);
    freq.put("nul", 17);
    freq.put("num", 77);
    freq.put("Ped", 66);
    freq.put("nue", 249);
    freq.put("nub", 23);
    freq.put("nuc", 92);
    freq.put("nua", 35);
    freq.put("oce\u0301", 70);
    freq.put("mut", 21);
    freq.put("oci\u0301", 522);
    freq.put("mus", 182);
    freq.put("mur", 49);
    freq.put("Oes", 31);
    freq.put("i\u0301st", 316);
    freq.put("muy", 57);
    freq.put("mue", 167);
    freq.put("mud", 56);
    freq.put("i\u0301sm", 26);
    freq.put("bey", 24);
    freq.put("i\u0301si", 139);
    freq.put("mul", 182);
    freq.put("i\u0301se", 137);
    freq.put("mun", 1166);
    freq.put("mui", 74);
    freq.put("Exi", 31);
    freq.put("nu ", 3834);
    freq.put("ell", 2041);
    freq.put("mu ", 1351);
    freq.put("i\u0301s ", 660);
    freq.put(" me", 1730);
    freq.put("\u4e4b ", 28);
    freq.put(" ma", 2436);
    freq.put(" mo", 1062);
    freq.put(" mi", 1111);
    freq.put(" mu", 1033);
    freq.put("\u03b9\u0301", 24);
    freq.put("Leo\u0301", 17);
    freq.put(" m ", 89);
    freq.put("Cru", 42);
    freq.put("Cra", 46);
    freq.put("Cre", 52);
    freq.put("Cri", 75);
    freq.put("TV ", 20);
    freq.put("n", 116539);
    freq.put(" ma\u0301", 1170);
    freq.put(" mi\u0301", 29);
    freq.put(" me\u0301", 85);
    freq.put(" mo\u0301", 20);
    freq.put(" mu\u0301", 238);
    freq.put("au\u0301 ", 19);
    freq.put("\u062d", 24);
    freq.put("i\u0304 ", 16);
    freq.put("au\u0301n", 23);
    freq.put("Xap", 76);
    freq.put("Xam", 16);
    freq.put("pli\u0301", 16);
    freq.put("elh", 33);
    freq.put("eli", 427);
    freq.put("elo", 294);
    freq.put("ici\u0301", 22);
    freq.put("elm", 116);
    freq.put("elb", 24);
    freq.put("elc", 21);
    freq.put("ica\u0301", 140);
    freq.put("ela", 586);
    freq.put("elf", 16);
    freq.put("elg", 65);
    freq.put("eld", 67);
    freq.put("ele", 1112);
    freq.put("He\u0301", 16);
    freq.put("rnu", 250);
    freq.put("ico\u0301", 38);
    freq.put("els", 51);
    freq.put("elv", 47);
    freq.put("elt", 131);
    freq.put("elu", 173);
    freq.put("D", 1867);
    freq.put("el ", 11644);
    freq.put("viq", 16);
    freq.put("to\u0301p", 47);
    freq.put(" Ju", 179);
    freq.put(" Jo", 371);
    freq.put(" Ji", 26);
    freq.put(" Je", 101);
    freq.put(" Ja", 191);
    freq.put("ick", 48);
    freq.put("ici", 2242);
    freq.put("ele\u0301", 56);
    freq.put("ico", 863);
    freq.put("eli\u0301", 100);
    freq.put("icc", 91);
    freq.put("ica", 4484);
    freq.put("ela\u0301", 26);
    freq.put("ice", 236);
    freq.put("Hu", 145);
    freq.put("Hi", 166);
    freq.put("Ho", 254);
    freq.put("ics", 17);
    freq.put("icr", 78);
    freq.put("Ha", 239);
    freq.put("icu", 2289);
    freq.put("He", 416);
    freq.put(" J ", 26);
    freq.put("ic ", 127);
    freq.put("H ", 42);
    freq.put("a\u0301nd", 183);
    freq.put("a\u0301ne", 48);
    freq.put("a\u0301ng", 68);
    freq.put("ppe", 50);
    freq.put("a\u0301nc", 33);
    freq.put("a\u0301ni", 346);
    freq.put("a\u0301nt", 131);
    freq.put("Na\u0301p", 22);
    freq.put("ahu", 20);
    freq.put("ne\u0301", 437);
    freq.put("ni\u0301", 1029);
    freq.put("na\u0301", 348);
    freq.put("nc\u0327", 30);
    freq.put("nu\u0301", 547);
    freq.put("gic", 31);
    freq.put("awa", 46);
    freq.put("gia", 20);
    freq.put("gio", 44);
    freq.put("gin", 66);
    freq.put("no\u0301", 450);
    freq.put("tia\u0301", 213);
    freq.put("ah ", 54);
    freq.put("a\u0301n ", 738);
    freq.put("ure", 398);
    freq.put("ura", 1192);
    freq.put("Vol", 28);
    freq.put("gi ", 18);
    freq.put("nno", 31);
    freq.put("nni", 50);
    freq.put("nne", 92);
    freq.put("nna", 40);
    freq.put("ahi\u0301", 17);
    freq.put("to\u0301 ", 83);
    freq.put("o\u0301s ", 74);
    freq.put("nh", 112);
    freq.put("ni", 5826);
    freq.put("nj", 46);
    freq.put("nk", 160);
    freq.put("nl", 191);
    freq.put("nm", 114);
    freq.put("nn", 401);
    freq.put("no", 6459);
    freq.put("tit", 426);
    freq.put("na", 15680);
    freq.put("nb", 57);
    freq.put("nc", 6526);
    freq.put("nd", 7966);
    freq.put("ne", 9430);
    freq.put("nf", 727);
    freq.put("ng", 3085);
    freq.put("nx", 523);
    freq.put("ny", 165);
    freq.put("nz", 469);
    freq.put("tio", 252);
    freq.put("tid", 242);
    freq.put("nq", 283);
    freq.put("nr", 190);
    freq.put("ns", 3097);
    freq.put("nt", 16042);
    freq.put("nu", 5141);
    freq.put("nv", 444);
    freq.put("nw", 26);
    freq.put("o\u0301st", 22);
    freq.put("squ", 158);
    freq.put("nn ", 143);
    freq.put("o\u0301so", 46);
    freq.put("Hy", 28);
    freq.put("o\u0301si", 49);
    freq.put("o\u0301se", 174);
    freq.put("o\u0301sf", 19);
    freq.put("n ", 30468);
    freq.put("icl", 90);
    freq.put("ti ", 411);
    freq.put("roi", 407);
    freq.put("lly", 52);
    freq.put("rol", 199);
    freq.put("rom", 390);
    freq.put("ron", 805);
    freq.put("roo", 25);
    freq.put("lls", 17);
    freq.put("roa", 80);
    freq.put("rob", 125);
    freq.put("roc", 430);
    freq.put("rod", 448);
    freq.put("roe", 285);
    freq.put("rof", 196);
    freq.put("rog", 241);
    freq.put("rox", 64);
    freq.put("roy", 99);
    freq.put("roz", 19);
    freq.put("llo", 918);
    freq.put("rop", 836);
    freq.put("roq", 750);
    freq.put("lla", 2774);
    freq.put("ros", 1144);
    freq.put("rot", 279);
    freq.put("rou", 53);
    freq.put("rov", 729);
    freq.put("Dac", 16);
    freq.put("Dal", 24);
    freq.put("Dam", 16);
    freq.put("Dan", 45);
    freq.put("Dak", 19);
    freq.put("Dav", 38);
    freq.put("Dar", 41);
    freq.put("Cie", 43);
    freq.put("ro ", 1177);
    freq.put("Cin", 20);
    freq.put("Cim", 24);
    freq.put("Cir", 38);
    freq.put("Civ", 32);
    freq.put("Ciu", 64);
    freq.put("Cit", 27);
    freq.put("ll ", 152);
    freq.put("ict", 128);
    freq.put("llu\u0301", 66);
    freq.put("Rex", 57);
    freq.put("llo\u0301", 101);
    freq.put("Res", 36);
    freq.put("Rep", 338);
    freq.put("Rev", 74);
    freq.put("rne\u0301", 27);
    freq.put("lle\u0301", 52);
    freq.put("Rei", 254);
    freq.put("Ren", 58);
    freq.put("lli\u0301", 107);
    freq.put("Rem", 27);
    freq.put("Rec", 34);
    freq.put("lla\u0301", 81);
    freq.put("Rea", 104);
    freq.put("Reg", 68);
    freq.put("Red", 19);
    freq.put("Qua", 17);
    freq.put("Que", 58);
    freq.put("Qui", 66);
    freq.put("lun\u0303", 45);
    freq.put("Aga", 16);
    freq.put("Agu", 34);
    freq.put("Agr", 16);
    freq.put("plo", 103);
    freq.put("via\u0301", 17);
    freq.put("i\u0301qu", 53);
    freq.put("sh ", 55);
    freq.put("obo", 49);
    freq.put("Eva", 19);
    freq.put("u\u0301bl", 427);
    freq.put("u\u0301bi", 22);
    freq.put("ms ", 32);
    freq.put(" on", 206);
    freq.put(" ol", 31);
    freq.put("Mil", 44);
    freq.put("Min", 94);
    freq.put(" of", 332);
    freq.put("Mic", 77);
    freq.put(" oe", 410);
    freq.put("o ", 35);
    freq.put("Mid", 17);
    freq.put("Mig", 31);
    freq.put(" ox", 147);
    freq.put(" ov", 16);
    freq.put("Mis", 38);
    freq.put("Mir", 37);
    freq.put(" or", 1057);
    freq.put("Mit", 27);
    freq.put(" op", 125);
    freq.put("ru\u0301 ", 39);
    freq.put("fi\u0301u", 65);
    freq.put("fi\u0301s", 122);
    freq.put("fi\u0301n", 27);
    freq.put("Mie", 85);
    freq.put("fi\u0301a", 161);
    freq.put("ky ", 29);
    freq.put(" o ", 2220);
    freq.put("neg", 84);
    freq.put("de\u0301m", 37);
    freq.put("ru\u0301n", 16);
    freq.put("de\u0301c", 66);
    freq.put("de\u0301r", 31);
    freq.put("de\u0301s", 137);
    freq.put("tbo", 190);
    freq.put("sa\u0301b", 17);
    freq.put("aha", 39);
    freq.put("\u4e18", 35);
    freq.put("sa\u0301u", 141);
    freq.put("gto", 34);
    freq.put("\u0648", 49);
    freq.put("aho", 37);
    freq.put("iel\u0323", 34);
    freq.put(" ca", 3504);
    freq.put("\u0438\u0438\u0306", 19);
    freq.put("n\u0303i\u0301a", 34);
    freq.put("u\u0308i\u0301", 94);
    freq.put("eja", 24);
    freq.put("yu ", 1761);
    freq.put("yur", 18);
    freq.put("\u0438\u0447", 24);
    freq.put("yun", 16);
    freq.put("yud", 24);
    freq.put("Pu\u0301b", 16);
    freq.put("anc\u0327", 24);
    freq.put("pra\u0301", 40);
    freq.put("ana\u0301", 42);
    freq.put("ani\u0301", 85);
    freq.put("ane\u0301", 47);
    freq.put("ma\u0301 ", 26);
    freq.put("pro\u0301", 22);
    freq.put("ano\u0301", 40);
    freq.put("tio\u0301", 91);
    freq.put("iam", 104);
    freq.put("ial", 1467);
    freq.put("iao", 65);
    freq.put("ian", 2243);
    freq.put("iae", 38);
    freq.put("iad", 497);
    freq.put("iag", 71);
    freq.put("iac", 223);
    freq.put("iab", 43);
    freq.put("iax", 37);
    freq.put("e\u0301ga", 32);
    freq.put("iau", 25);
    freq.put("iat", 93);
    freq.put("ias", 265);
    freq.put("iar", 235);
    freq.put("ma\u0301q", 29);
    freq.put("ma\u0301s", 1269);
    freq.put("ma\u0301u", 310);
    freq.put("hua", 59);
    freq.put("hul", 32);
    freq.put("ma\u0301x", 50);
    freq.put("hun", 17);
    freq.put("hur", 35);
    freq.put("hus", 41);
    freq.put("ma\u0301i", 57);
    freq.put("uyi\u0301", 98);
    freq.put("ma\u0301n", 295);
    freq.put("ia ", 6192);
    freq.put("\u0646 ", 35);
    freq.put("r", 94573);
    freq.put("and", 2207);
    freq.put("ane", 768);
    freq.put("anf", 32);
    freq.put("ang", 699);
    freq.put("pra", 60);
    freq.put("ana", 1687);
    freq.put("a\u0301li", 50);
    freq.put("lo\u0301n", 139);
    freq.put("ann", 174);
    freq.put("a\u0301le", 79);
    freq.put("anh", 32);
    freq.put("ani", 960);
    freq.put("anj", 18);
    freq.put("ank", 71);
    freq.put("ant", 3397);
    freq.put("anu", 2480);
    freq.put("\u0442", 51);
    freq.put("lo\u0301s", 56);
    freq.put("ans", 182);
    freq.put("a\u0301lt", 26);
    freq.put("anx", 87);
    freq.put("any", 26);
    freq.put("anz", 279);
    freq.put(" a\u0301c", 19);
    freq.put(" L ", 598);
    freq.put(" a\u0301l", 65);
    freq.put(" a\u0301m", 61);
    freq.put(" a\u0301n", 62);
    freq.put(" a\u0301r", 273);
    freq.put("\u0435", 113);
    freq.put("ian\u0303", 17);
    freq.put("an ", 1413);
    freq.put("lo\u0301 ", 55);
    freq.put("uya", 60);
    freq.put("uye", 193);
    freq.put("\u4e59", 33);
    freq.put(" Le", 552);
    freq.put(" La", 2518);
    freq.put(" Lo", 705);
    freq.put(" Ll", 1198);
    freq.put(" Li", 329);
    freq.put(" Lu", 263);
    freq.put(" Ly", 19);
    freq.put("rmo\u0301", 39);
    freq.put("nlu", 18);
    freq.put("nla", 115);
    freq.put("rma\u0301", 162);
    freq.put("dy ", 38);
    freq.put("ss ", 55);
    freq.put("\u0447 ", 23);
    freq.put("H", 1357);
    freq.put("sso", 57);
    freq.put("ssi", 80);
    freq.put("sse", 107);
    freq.put("ssa", 98);
    freq.put("o\u0301u ", 26);
    freq.put("ngu\u0301", 18);
    freq.put("rmu", 112);
    freq.put("rma", 1246);
    freq.put("rme", 488);
    freq.put("lne", 17);
    freq.put("rmi", 533);
    freq.put("rmo", 61);
    freq.put("pot", 61);
    freq.put("por", 2591);
    freq.put("pos", 650);
    freq.put("pop", 135);
    freq.put("pon", 382);
    freq.put("pol", 2082);
    freq.put("pod", 208);
    freq.put("poe", 143);
    freq.put("pob", 503);
    freq.put("poc", 86);
    freq.put("Bur", 66);
    freq.put("Bus", 39);
    freq.put("Bul", 25);
    freq.put("Bua", 57);
    freq.put("Bud", 16);
    freq.put("Bue", 31);
    freq.put("Aer", 16);
    freq.put("po ", 60);
    freq.put("Bar", 232);
    freq.put("\u0431", 19);
    freq.put("I ", 426);
    freq.put("XX ", 77);
    freq.put("gio\u0301", 47);
    freq.put("Eti", 20);
    freq.put("Iz", 37);
    freq.put("tiz", 53);
    freq.put("Is", 314);
    freq.put("Ir", 117);
    freq.put("It", 87);
    freq.put("Im", 105);
    freq.put("Il", 151);
    freq.put("In", 766);
    freq.put("Ib", 96);
    freq.put("Id", 18);
    freq.put("Ig", 27);
    freq.put(" qu", 5665);
    freq.put("tip", 209);
    freq.put("tiq", 186);
    freq.put("Ban", 64);
    freq.put("tir", 164);
    freq.put("tis", 234);
    freq.put("til", 396);
    freq.put("tim", 237);
    freq.put("tin", 650);
    freq.put("Bah", 25);
    freq.put("ich", 382);
    freq.put("tie", 1513);
    freq.put("tif", 109);
    freq.put("tig", 408);
    freq.put("Pil", 46);
    freq.put("Pin", 46);
    freq.put("Pic", 40);
    freq.put("Pie", 44);
    freq.put("tia", 712);
    freq.put("tib", 63);
    freq.put("Pir", 20);
    freq.put("tic", 2005);
    freq.put("Pit", 16);
    freq.put("on\u0303", 88);
    freq.put("alt", 561);
    freq.put("Gu\u0308e", 17);
    freq.put("o ", 13449);
    freq.put("oo", 306);
    freq.put("on", 16182);
    freq.put("om", 7192);
    freq.put("ol", 8517);
    freq.put("ok", 163);
    freq.put("oj", 26);
    freq.put("oi", 2517);
    freq.put("oh", 213);
    freq.put("og", 936);
    freq.put("of", 869);
    freq.put("oe", 1036);
    freq.put("od", 1545);
    freq.put("oc", 3842);
    freq.put("ob", 2233);
    freq.put("oa", 333);
    freq.put("oz", 407);
    freq.put("oy", 307);
    freq.put("ox", 829);
    freq.put("ow", 167);
    freq.put("ov", 1634);
    freq.put("ou", 779);
    freq.put("ot", 1892);
    freq.put("os", 16911);
    freq.put("or", 14381);
    freq.put("oq", 867);
    freq.put("op", 1816);
    freq.put(" u\u0301l", 61);
    freq.put("pa\u0301r", 16);
    freq.put("pa\u0301u", 120);
    freq.put("alq", 40);
    freq.put("igu\u0308", 67);
    freq.put("igu\u0301", 19);
    freq.put("\u03b3", 32);
    freq.put("pa\u0301n", 24);
    freq.put("ehi", 16);
    freq.put("yad", 99);
    freq.put("yab", 16);
    freq.put("\u4e01", 67);
    freq.put("rva", 154);
    freq.put("rve", 103);
    freq.put("rvi", 139);
    freq.put("ve\u0301r", 16);
    freq.put("igu", 708);
    freq.put("igr", 59);
    freq.put("\u0631", 55);
    freq.put("ige", 41);
    freq.put("iga", 302);
    freq.put("igo", 105);
    freq.put("ign", 257);
    freq.put("igm", 19);
    freq.put("ehi\u0301", 20);
    freq.put("igi", 44);
    freq.put("igh", 82);
    freq.put("hwa", 18);
    freq.put("Xef", 17);
    freq.put("Xen", 90);
    freq.put("Xeo", 32);
    freq.put("Xer", 29);
    freq.put("ig ", 53);
    freq.put("pto", 35);
    freq.put("alo", 268);
    freq.put("all", 1182);
    freq.put("alm", 824);
    freq.put("a\u0301rt", 30);
    freq.put("tei\u0301", 34);
    freq.put("pti", 79);
    freq.put("ali", 1699);
    freq.put("alf", 71);
    freq.put("alg", 292);
    freq.put("pte", 71);
    freq.put("ale", 2061);
    freq.put("alb", 72);
    freq.put("alc", 343);
    freq.put("pta", 50);
    freq.put("ala", 786);
    freq.put("a\u0301ra", 142);
    freq.put("a\u0301rb", 50);
    freq.put("alz", 22);
    freq.put("a\u0301re", 155);
    freq.put("aly", 18);
    freq.put("alv", 67);
    freq.put("fa ", 46);
    freq.put("alu", 269);
    freq.put("alr", 85);
    freq.put("als", 30);
    freq.put("alp", 29);
    freq.put("a\u0301ro", 31);
    freq.put(" N ", 106);
    freq.put("lch", 18);
    freq.put("faz", 29);
    freq.put("fay", 27);
    freq.put("far", 74);
    freq.put("fas", 285);
    freq.put("fav", 23);
    freq.put("fat", 22);
    freq.put("fai", 134);
    freq.put("fan", 103);
    freq.put("llu", 1177);
    freq.put("fal", 302);
    freq.put("fam", 463);
    freq.put("fab", 125);
    freq.put("fac", 180);
    freq.put("fae", 61);
    freq.put(" Ni", 193);
    freq.put(" No", 438);
    freq.put(" Na", 771);
    freq.put(" Ne", 358);
    freq.put("lli", 1517);
    freq.put(" Ny", 19);
    freq.put("e\u0301", 6642);
    freq.put(" Nu", 302);
    freq.put("tei", 74);
    freq.put("ali\u0301", 70);
    freq.put("tel", 628);
    freq.put("tem", 770);
    freq.put("ten", 1730);
    freq.put("ale\u0301", 31);
    freq.put("tea", 120);
    freq.put("teb", 32);
    freq.put("tec", 117);
    freq.put("ted", 43);
    freq.put("pta\u0301", 20);
    freq.put("ala\u0301", 104);
    freq.put("tex", 74);
    freq.put("tey", 22);
    freq.put("tep", 27);
    freq.put("ter", 3386);
    freq.put("tes", 2375);
    freq.put("tet", 38);
    freq.put("alo\u0301", 70);
    freq.put("tev", 28);
    freq.put("suf", 31);
    freq.put("sue", 149);
    freq.put("sud", 56);
    freq.put("suc", 36);
    freq.put("sub", 147);
    freq.put("sua", 132);
    freq.put("sun", 58);
    freq.put("sum", 58);
    freq.put("sul", 280);
    freq.put("sui", 148);
    freq.put("sus", 114);
    freq.put("sur", 861);
    freq.put("sup", 304);
    freq.put("sux", 19);
    freq.put("te ", 7553);
    freq.put("o\u0304", 76);
    freq.put("\u4e01 ", 23);
    freq.put("su ", 916);
    freq.put(" Na\u0301", 26);
    freq.put("lo", 7706);
    freq.put(" No\u0301", 21);
    freq.put("rks", 24);
    freq.put("Tor", 120);
    freq.put("Tou", 27);
    freq.put("rke", 18);
    freq.put("Ton", 21);
    freq.put("Tol", 61);
    freq.put("Tom", 42);
    freq.put("rki", 23);
    freq.put("n\u0303at", 28);
    freq.put("n\u0303as", 17);
    freq.put("n\u0303ar", 17);
    freq.put("n\u0303az", 20);
    freq.put("n\u0303ad", 49);
    freq.put("oyi\u0301", 22);
    freq.put("n\u0303ac", 76);
    freq.put("n\u0303am", 46);
    freq.put("n\u0303al", 54);
    freq.put("n\u0303an", 54);
    freq.put("rk ", 144);
    freq.put("a\u0301", 11885);
    freq.put("ui\u0301n", 45);
    freq.put("Int", 282);
    freq.put("Ins", 49);
    freq.put("n\u0303a ", 1157);
    freq.put("v", 11684);
    freq.put("Ind", 157);
    freq.put("Inf", 56);
    freq.put("Ing", 112);
    freq.put("Inc", 35);
    freq.put("oyo", 36);
    freq.put("\u0438\u0306", 38);
    freq.put("oye", 126);
    freq.put("oya", 59);
    freq.put("Gla", 16);
    freq.put("\u03bd ", 24);
    freq.put("apo\u0301", 86);
    freq.put("lhe", 25);
    freq.put("lho", 40);
    freq.put("oy ", 24);
    freq.put(" su\u0301", 16);
    freq.put("Mun\u0303", 19);
    freq.put(" so\u0301", 56);
    freq.put("Occ", 62);
    freq.put("Oce", 21);
    freq.put(" se\u0301", 39);
    freq.put(" si\u0301", 196);
    freq.put(" sa\u0301", 22);
    freq.put("Ocu", 94);
    freq.put("iza\u0301", 125);
    freq.put("izo\u0301", 29);
    freq.put("Fri", 73);
    freq.put("L", 6310);
    freq.put("\u0432\u0438\u0447", 22);
    freq.put("Era", 16);
    freq.put("Ern", 22);
    freq.put("Eri", 27);
    freq.put("Raf", 18);
    freq.put("Rad", 56);
    freq.put("Ran", 20);
    freq.put("yne", 16);
    freq.put("Ram", 51);
    freq.put("man", 1431);
    freq.put("Oce\u0301", 123);
    freq.put("Mus", 50);
    freq.put("Mur", 61);
    freq.put(" sp", 16);
    freq.put(" st", 25);
    freq.put(" su", 1841);
    freq.put(" sh", 46);
    freq.put(" si", 1637);
    freq.put(" so", 3861);
    freq.put(" sa", 406);
    freq.put(" se", 3003);
    freq.put("iza", 808);
    freq.put("izc", 16);
    freq.put("gur", 200);
    freq.put("izo", 94);
    freq.put("izq", 54);
    freq.put("izu", 34);
    freq.put("o\u0301m", 591);
    freq.put(" s ", 474);
    freq.put("iz ", 157);
    freq.put(" ef", 56);
    freq.put("co\u0301m", 81);
    freq.put("co\u0301n", 41);
    freq.put("co\u0301d", 49);
    freq.put("imb", 72);
    freq.put("efi\u0301", 27);
    freq.put("\u3042\u3042\u3042", 17);
    freq.put("co\u0301 ", 40);
    freq.put("kot", 30);
    freq.put("Nun", 61);
    freq.put("kov", 17);
    freq.put("\u03a0", 16);
    freq.put("efr", 17);
    freq.put("efu", 20);
    freq.put("efi", 208);
    freq.put("efo", 46);
    freq.put("\u0639", 21);
    freq.put("efa", 39);
    freq.put("efe", 410);
    freq.put("Ba\u0301l", 17);
    freq.put("Zel", 22);
    freq.put("rte", 2342);
    freq.put("aro\u0301", 25);
    freq.put("rta", 609);
    freq.put("rto", 174);
    freq.put("rti", 734);
    freq.put("rth", 75);
    freq.put("rtu", 690);
    freq.put("ara\u0301", 99);
    freq.put("rts", 20);
    freq.put("are\u0301", 19);
    freq.put("ari\u0301", 302);
    freq.put("iey", 50);
    freq.put("bfa", 16);
    freq.put("iez", 59);
    freq.put("Ju", 180);
    freq.put("ies", 1643);
    freq.put("ier", 1728);
    freq.put("ieu", 17);
    freq.put("iet", 226);
    freq.put("iev", 61);
    freq.put("Jo", 371);
    freq.put("iem", 614);
    freq.put("iel", 539);
    freq.put("ien", 4185);
    freq.put("Je", 102);
    freq.put("iec", 35);
    freq.put("ieb", 20);
    freq.put("Ja", 193);
    freq.put("ieg", 740);
    freq.put("hip", 108);
    freq.put("hir", 68);
    freq.put("his", 233);
    freq.put("hit", 21);
    freq.put("rt ", 149);
    freq.put("mi\u0301t", 16);
    freq.put("hia", 35);
    freq.put("Xi", 259);
    freq.put("hid", 67);
    freq.put("hie", 28);
    freq.put("hig", 22);
    freq.put("mi\u0301f", 25);
    freq.put("mi\u0301a", 132);
    freq.put("him", 87);
    freq.put("hin", 312);
    freq.put(" \u1100\u1161", 19);
    freq.put(" Pu\u0301", 19);
    freq.put(" Pa\u0301", 22);
    freq.put("ie ", 873);
    freq.put(" Pe\u0301", 50);
    freq.put("J ", 37);
    freq.put("arp", 32);
    freq.put("arq", 197);
    freq.put("arr", 1706);
    freq.put("ars", 119);
    freq.put("rta\u0301", 39);
    freq.put("aru", 117);
    freq.put("arv", 26);
    freq.put("rti\u0301", 549);
    freq.put("ary", 43);
    freq.put("arz", 266);
    freq.put("ara", 857);
    freq.put("arb", 141);
    freq.put("arc", 833);
    freq.put("ard", 422);
    freq.put("a\u0301po", 33);
    freq.put("arf", 16);
    freq.put("arg", 359);
    freq.put("ari", 1735);
    freq.put("ark", 48);
    freq.put("arl", 271);
    freq.put("arm", 259);
    freq.put("arn", 76);
    freq.put("aro", 283);
    freq.put("al ", 8408);
    freq.put(" P ", 21);
    freq.put("use", 136);
    freq.put("ar ", 2930);
    freq.put("fga", 65);
    freq.put(" Ps", 20);
    freq.put(" Pr", 849);
    freq.put("c", 62536);
    freq.put(" Pu", 224);
    freq.put(" Pa", 1148);
    freq.put(" Pe", 648);
    freq.put(" Pi", 285);
    freq.put(" Ph", 47);
    freq.put(" Po", 622);
    freq.put(" Pl", 156);
    freq.put("rio\u0301", 240);
    freq.put("rin\u0303", 55);
    freq.put("ria\u0301", 59);
    freq.put("pr", 4818);
    freq.put("ps", 128);
    freq.put("pp", 103);
    freq.put("dul", 59);
    freq.put("dun", 20);
    freq.put("pu", 2875);
    freq.put("dua", 41);
    freq.put("px", 75);
    freq.put("py", 21);
    freq.put(" o ", 29);
    freq.put("pc", 78);
    freq.put("duz", 54);
    freq.put("pa", 7620);
    freq.put("pe", 5146);
    freq.put("dur", 192);
    freq.put("pi", 1999);
    freq.put("po", 6983);
    freq.put("pl", 1392);
    freq.put("Fal", 28);
    freq.put("\u0438\u0306 ", 28);
    freq.put("Emi", 43);
    freq.put("Emp", 36);
    freq.put("o\u0301me", 155);
    freq.put("e\u0301s ", 1389);
    freq.put("du ", 895);
    freq.put("p ", 251);
    freq.put("riz", 214);
    freq.put("rix", 441);
    freq.put("riy", 26);
    freq.put("riv", 116);
    freq.put("rit", 1269);
    freq.put("riu", 1041);
    freq.put("rir", 37);
    freq.put("ris", 592);
    freq.put("rip", 80);
    freq.put("riq", 109);
    freq.put("rin", 783);
    freq.put("Tim", 29);
    freq.put("ril", 361);
    freq.put("rim", 755);
    freq.put("rik", 27);
    freq.put("rif", 61);
    freq.put("Tie", 344);
    freq.put("rid", 491);
    freq.put("rie", 2283);
    freq.put("rib", 408);
    freq.put("ric", 1346);
    freq.put("ria", 2933);
    freq.put("po\u0301", 199);
    freq.put("pu\u0301", 438);
    freq.put("fu\u0301t", 98);
    freq.put("pa\u0301", 215);
    freq.put("pe\u0301", 82);
    freq.put("pi\u0301", 66);
    freq.put("Cop", 54);
    freq.put("Cos", 29);
    freq.put("Cor", 297);
    freq.put("Cou", 48);
    freq.put("Cot", 19);
    freq.put("Ill", 32);
    freq.put("Coa", 17);
    freq.put("Coc", 18);
    freq.put("Com", 360);
    freq.put("Col", 207);
    freq.put("Coo", 24);
    freq.put("Con", 511);
    freq.put("\u044c", 20);
    freq.put("Air", 46);
    freq.put("ror", 98);
    freq.put("mia", 120);
    freq.put("e\u0301st", 100);
    freq.put("zz ", 16);
    freq.put("ga\u0301u", 300);
    freq.put("ga\u0301n", 28);
    freq.put("Epi", 17);
    freq.put("\u062a", 18);
    freq.put("Rom", 141);
    freq.put("Ron", 27);
    freq.put("Rob", 81);
    freq.put("Roc", 36);
    freq.put("Rod", 68);
    freq.put("Llu", 99);
    freq.put("Roy", 18);
    freq.put("Roz", 17);
    freq.put("Llo", 49);
    freq.put("yla", 17);
    freq.put("ylo", 28);
    freq.put("Lla", 265);
    freq.put("Ros", 49);
    freq.put("Lle", 374);
    freq.put("wn ", 20);
    freq.put(" ut", 142);
    freq.put(" ur", 64);
    freq.put(" us", 310);
    freq.put(" ul", 27);
    freq.put(" un", 10516);
    freq.put(" uf", 23);
    freq.put("Xun", 533);
    freq.put("ixi", 244);
    freq.put("ixo", 110);
    freq.put("ixa", 29);
    freq.put("ixe", 362);
    freq.put("gra\u0301", 245);
    freq.put("gri\u0301", 37);
    freq.put("gre\u0301", 34);
    freq.put("Fo\u0301r", 67);
    freq.put("exe", 267);
    freq.put(" u ", 49);
    freq.put("ix ", 47);
    freq.put("z", 5459);
    freq.put("gru", 473);
    freq.put("reo\u0301", 22);
    freq.put("ixi\u0301", 40);
    freq.put("gre", 215);
    freq.put("gra", 1074);
    freq.put("ixo\u0301", 242);
    freq.put("gri", 345);
    freq.put("rri\u0301", 31);
    freq.put("eda", 318);
    freq.put("rre\u0301", 115);
    freq.put("ede", 555);
    freq.put("edi", 882);
    freq.put("edo", 282);
    freq.put("rra\u0301", 42);
    freq.put("edr", 257);
    freq.put("\u043a\u043e", 17);
    freq.put("edu", 77);
    freq.put("edC", 101);
    freq.put("sen\u0303", 145);
    freq.put(" o\u0301p", 23);
    freq.put("ed ", 100);
    freq.put("ibi", 167);
    freq.put("sar", 287);
    freq.put("P", 4287);
    freq.put("iba", 143);
    freq.put("rro", 1036);
    freq.put("eda\u0301", 225);
    freq.put("rri", 709);
    freq.put("egl", 340);
    freq.put("rre", 836);
    freq.put("rra", 916);
    freq.put("edi\u0301", 20);
    freq.put("rry", 20);
    freq.put("rru", 132);
    freq.put("vi\u0301s", 53);
    freq.put("bdi", 19);
    freq.put("tan\u0303", 113);
    freq.put("apr", 172);
    freq.put("apt", 43);
    freq.put("apu", 59);
    freq.put("api", 576);
    freq.put("apo", 290);
    freq.put("apl", 82);
    freq.put("L\u0323l\u0323", 78);
    freq.put("apa", 342);
    freq.put("ape", 125);
    freq.put("sio\u0301", 886);
    freq.put("Hue", 36);
    freq.put("fed", 63);
    freq.put("Hug", 16);
    freq.put("feb", 220);
    freq.put("fec", 240);
    freq.put("usa", 234);
    freq.put("fen", 152);
    freq.put("Hum", 27);
    freq.put("fel", 43);
    freq.put("fem", 75);
    freq.put("usk", 47);
    freq.put("usi", 320);
    freq.put("ush", 36);
    freq.put("sia\u0301", 35);
    freq.put("feu", 83);
    freq.put("fer", 619);
    freq.put("fes", 211);
    freq.put("Gua", 66);
    freq.put("Gue", 129);
    freq.put(" ob", 277);
    freq.put("Gui", 93);
    freq.put(" oc", 720);
    freq.put("Gut", 20);
    freq.put("Guy", 16);
    freq.put("px ", 74);
    freq.put(" Ru", 238);
    freq.put("fe ", 94);
    freq.put("us ", 491);
    freq.put(" Re", 1148);
    freq.put(" Ra", 250);
    freq.put(" Ro", 514);
    freq.put(" Ri", 337);
    freq.put(" Rh", 40);
    freq.put("tat", 193);
    freq.put("tau", 171);
    freq.put("tav", 55);
    freq.put("tap", 43);
    freq.put("i\u0301fe", 34);
    freq.put("tar", 889);
    freq.put("tas", 279);
    freq.put("i\u0301fi", 190);
    freq.put("tax", 38);
    freq.put("tay", 76);
    freq.put("tad", 383);
    freq.put("tae", 72);
    freq.put("taf", 64);
    freq.put("tag", 79);
    freq.put("tab", 362);
    freq.put("tac", 385);
    freq.put("tal", 2058);
    freq.put("tam", 1241);
    freq.put("tan", 1417);
    freq.put("tao", 527);
    freq.put("tah", 17);
    freq.put("tai", 52);
    freq.put("tak", 21);
    freq.put("sis", 622);
    freq.put("sir", 59);
    freq.put("siq", 60);
    freq.put(" ou", 52);
    freq.put("siv", 99);
    freq.put("siu", 31);
    freq.put("sit", 935);
    freq.put("use\u0301", 30);
    freq.put(" os", 20);
    freq.put("sic", 830);
    freq.put("sib", 102);
    freq.put("sia", 429);
    freq.put("dwa", 30);
    freq.put("sig", 398);
    freq.put("sif", 77);
    freq.put("sie", 560);
    freq.put("sid", 689);
    freq.put("dwi", 21);
    freq.put("sio", 322);
    freq.put("sin", 589);
    freq.put("sim", 300);
    freq.put("sil", 198);
    freq.put("ta ", 4329);
    freq.put("si ", 200);
    freq.put(" Ri\u0301", 61);
    freq.put("ws", 28);
    freq.put("n\u0303es", 124);
    freq.put("n\u0303er", 39);
    freq.put("n\u0303ez", 18);
    freq.put("zo\u0301 ", 53);
    freq.put("Ibi", 22);
    freq.put("Cas", 405);
    freq.put("Car", 410);
    freq.put("Cap", 35);
    freq.put("Cau", 22);
    freq.put("Cat", 125);
    freq.put("Cai", 19);
    freq.put("Can", 440);
    freq.put("Cam", 227);
    freq.put("Cal", 168);
    freq.put("Cab", 174);
    freq.put("Cad", 25);
    freq.put("Pre", 239);
    freq.put("nfe", 185);
    freq.put("Pra", 62);
    freq.put("nfa", 62);
    freq.put("nfo", 208);
    freq.put("Pro", 213);
    freq.put("nfl", 115);
    freq.put("Pri", 255);
    freq.put("nfi", 67);
    freq.put("Pru", 19);
    freq.put("nfu", 34);
    freq.put("nfr", 42);
    freq.put("oui", 42);
    freq.put("oun", 94);
    freq.put("oul", 31);
    freq.put("ouc", 19);
    freq.put("oug", 30);
    freq.put("ous", 66);
    freq.put("our", 125);
    freq.put("ouv", 16);
    freq.put("out", 118);
    freq.put("lt ", 35);
    freq.put("Ibe\u0301", 46);
    freq.put("Moz", 56);
    freq.put("ou ", 180);
    freq.put("Gha", 17);
    freq.put("ltr", 47);
    freq.put("ltu", 364);
    freq.put("Pri\u0301", 42);
    freq.put("lta", 267);
    freq.put("lte", 206);
    freq.put("lti", 347);
    freq.put("lth", 19);
    freq.put("lto", 147);
    freq.put("u\u0308", 570);
    freq.put("K ", 47);
    freq.put("\u03bb", 57);
    freq.put("Ka", 208);
    freq.put("Ke", 90);
    freq.put("Ki", 117);
    freq.put("Kh", 25);
    freq.put("Ko", 89);
    freq.put("Kl", 20);
    freq.put("Kr", 32);
    freq.put("Ku", 80);
    freq.put("o\u0301gi", 16);
    freq.put("da\u0301 ", 2341);
    freq.put("Fol", 20);
    freq.put("sem", 217);
    freq.put("to\u0301n", 460);
    freq.put("to\u0301l", 71);
    freq.put("to\u0301m", 95);
    freq.put("to\u0301r", 153);
    freq.put("to\u0301s", 52);
    freq.put("Dia", 36);
    freq.put("sol", 329);
    freq.put("da\u0301n", 25);
    freq.put("hw", 36);
    freq.put("da\u0301u", 177);
    freq.put("Por", 158);
    freq.put("Pos", 25);
    freq.put("Pop", 64);
    freq.put("Pon", 50);
    freq.put("Pol", 213);
    freq.put("vi\u0301d", 24);
    freq.put("Pod", 19);
    freq.put("Cha", 143);
    freq.put("ebi\u0301", 17);
    freq.put("sa\u0301n", 23);
    freq.put("ha", 2114);
    freq.put("eat", 90);
    freq.put("q ", 53);
    freq.put("no ", 441);
    freq.put(" we", 37);
    freq.put("qu", 9098);
    freq.put(" ww", 23);
    freq.put("Ra", 250);
    freq.put("ebe", 94);
    freq.put("eba", 96);
    freq.put("ebl", 265);
    freq.put("ebo", 37);
    freq.put("ebi", 45);
    freq.put("jo ", 42);
    freq.put("ebu", 19);
    freq.put("ebr", 512);
    freq.put("Tex", 31);
    freq.put("en\u0303", 570);
    freq.put("Jac", 51);
    freq.put("Vil\u0323", 38);
    freq.put("eb ", 57);
    freq.put(" \u0627\u0644", 54);
    freq.put("Zam", 62);
    freq.put("Zar", 29);
    freq.put("rpr", 58);
    freq.put("rpu", 89);
    freq.put("avi\u0301", 17);
    freq.put("rpe", 32);
    freq.put("rpi", 24);
    freq.put("rpo", 95);
    freq.put("Jua", 76);
    freq.put("me\u0301n", 20);
    freq.put("Jun", 21);
    freq.put("me\u0301d", 30);
    freq.put("Jul", 45);
    freq.put("me\u0301r", 188);
    freq.put("me\u0301t", 89);
    freq.put("\u03bf", 125);
    freq.put(" Tu\u0301", 18);
    freq.put("taq", 31);
    freq.put("me\u0301 ", 20);
    freq.put(" Ti\u0301", 16);
    freq.put("rli\u0301", 17);
    freq.put("avu", 23);
    freq.put("e\u0304", 20);
    freq.put("avo", 65);
    freq.put("avi", 677);
    freq.put("ave", 460);
    freq.put("ava", 211);
    freq.put(" e\u0301p", 29);
    freq.put(" e\u0301s", 89);
    freq.put(" e\u0301t", 18);
    freq.put(" e\u0301l", 39);
    freq.put(" e\u0301n", 21);
    freq.put("uqu", 52);
    freq.put(" T ", 16);
    freq.put("Vue", 16);
    freq.put(" Tu", 172);
    freq.put(" Ts", 20);
    freq.put(" Tr", 396);
    freq.put(" To", 357);
    freq.put(" Ti", 507);
    freq.put(" Th", 219);
    freq.put(" Te", 444);
    freq.put(" Ta", 602);
    freq.put("i\u0301di", 37);
    freq.put("Sua\u0301", 20);
    freq.put("i\u0301de", 82);
    freq.put("tch", 19);
    freq.put("cra", 121);
    freq.put("Far", 36);
    freq.put("Fas", 21);
    freq.put("ske", 20);
    freq.put("ska", 61);
    freq.put("o\u0301mi", 345);
    freq.put("Fab", 18);
    freq.put("sko", 21);
    freq.put("ski", 32);
    freq.put("o\u0301ma", 75);
    freq.put("T", 2910);
    freq.put("tc ", 53);
    freq.put("nde\u0301", 98);
    freq.put("ndi\u0301", 93);
    freq.put("a\u0301ta", 44);
    freq.put("nda\u0301", 171);
    freq.put("a\u0301to", 26);
    freq.put("a\u0301ti", 328);
    freq.put("sk ", 27);
    freq.put("ndo\u0301", 39);
    freq.put("Sue", 56);
    freq.put("Sud", 40);
    freq.put("Sua", 16);
    freq.put("Sun", 24);
    freq.put("Sui", 30);
    freq.put("Sur", 186);
    freq.put("Sup", 44);
    freq.put("nd ", 263);
    freq.put("yo\u0301 ", 40);
    freq.put("ndi", 946);
    freq.put("yo\u0301n", 36);
    freq.put("ndo", 1389);
    freq.put("nda", 1626);
    freq.put("nde", 2476);
    freq.put("nds", 31);
    freq.put("ndr", 238);
    freq.put("ndu", 539);
    freq.put("own", 25);
    freq.put("owe", 43);
    freq.put("owa", 19);
    freq.put("o\u0308r", 16);
    freq.put("N\u0303ac", 22);
    freq.put("ows", 16);
    freq.put("Ami", 25);
    freq.put("van", 182);
    freq.put("vao", 22);
    freq.put("val", 420);
    freq.put("vam", 59);
    freq.put("Ama", 48);
    freq.put("vac", 93);
    freq.put("ucu", 29);
    freq.put("Amb", 27);
    freq.put("Ame", 31);
    freq.put("vad", 139);
    freq.put("var", 358);
    freq.put("vas", 93);
    freq.put("vap", 20);
    freq.put("vat", 60);
    freq.put("ef", 821);
    freq.put("uct", 244);
    freq.put("ow ", 33);
    freq.put("Tel", 93);
    freq.put("Tem", 42);
    freq.put("Ten", 45);
    freq.put("Teo", 30);
    freq.put("va ", 829);
    freq.put("lve", 47);
    freq.put("lva", 138);
    freq.put("Ter", 91);
    freq.put("Tes", 22);
    freq.put("lvi", 76);
    freq.put("eu", 1209);
    freq.put("et", 3456);
    freq.put("Ame\u0301", 145);
    freq.put("i\u0301 ", 191);
    freq.put("Ama\u0301", 18);
    freq.put("gi\u0301a", 19);
    freq.put("\u043d", 103);
    freq.put("l\u0323l\u0323", 107);
    freq.put("ejo", 22);
    freq.put("my ", 17);
    freq.put("i\u0301e", 400);
    freq.put("i\u0301d", 138);
    freq.put("i\u0301g", 74);
    freq.put("i\u0301f", 226);
    freq.put("i\u0301a", 2476);
    freq.put("i\u0301c", 267);
    freq.put("i\u0301b", 48);
    freq.put("i\u0301m", 395);
    freq.put("i\u0301l", 29);
    freq.put("i\u0301o", 824);
    freq.put("i\u0301n", 1166);
    freq.put("i\u0301u", 1720);
    freq.put("i\u0301t", 741);
    freq.put("i\u0301v", 16);
    freq.put("i\u0301q", 53);
    freq.put("i\u0301p", 86);
    freq.put("i\u0301s", 1293);
    freq.put("i\u0301r", 90);
    freq.put("i\u0301x", 61);
    freq.put("i\u0301z", 57);
  }
  
}

