package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class AN extends CLangProfile {
  private static final String name = "an";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public AN() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 3992558;
    n_words[1] = 4845689;
    n_words[2] = 3895070;

    freq.put("req", 52);
    freq.put("gai", 80);
    freq.put("alo", 709);
    freq.put("nun", 319);
    freq.put("gha", 41);
    freq.put("sco", 1662);
    freq.put("\u0438\u0447 ", 54);
    freq.put("ufi", 110);
    freq.put("sci", 365);
    freq.put("reu", 243);
    freq.put("oma\u0301", 496);
    freq.put("auc", 108);
    freq.put("aub", 88);
    freq.put("ti\u0301t", 343);
    freq.put("alh", 70);
    freq.put("aug", 298);
    freq.put("mo\u0301n", 89);
    freq.put("mpe", 1346);
    freq.put("IX ", 132);
    freq.put("ali", 4784);
    freq.put("aum", 84);
    freq.put("blo", 388);
    freq.put("aun", 85);
    freq.put("e\u0301ri", 41);
    freq.put("aus", 598);
    freq.put("aur", 378);
    freq.put("aut", 2694);
    freq.put("auv", 126);
    freq.put("tai", 444);
    freq.put("aux", 83);
    freq.put("e\u0301re", 56);
    freq.put("ti\u0301n", 895);
    freq.put(" Gu", 1594);
    freq.put(" Gr", 1065);
    freq.put("\u0644", 158);
    freq.put("sca", 2190);
    freq.put("ska", 167);
    freq.put("nry", 46);
    freq.put("alc", 339);
    freq.put("ble", 668);
    freq.put(" Ge", 1114);
    freq.put(" Ga", 2446);
    freq.put("\u05d9", 48);
    freq.put(" Go", 465);
    freq.put(" Gl", 100);
    freq.put(" Gi", 352);
    freq.put("au ", 1514);
    freq.put("Gu", 1597);
    freq.put("nfl", 201);
    freq.put("Gr", 1086);
    freq.put("upi", 40);
    freq.put("ref", 461);
    freq.put("e\u0308", 76);
    freq.put("upe", 2913);
    freq.put("e\u0301li", 52);
    freq.put("dre\u0301", 42);
    freq.put("Ge", 1116);
    freq.put("dri\u0301", 82);
    freq.put("red", 815);
    freq.put("Ga", 2449);
    freq.put("Go", 468);
    freq.put("ro\u0301 ", 128);
    freq.put("Gl", 100);
    freq.put("li\u0301n", 186);
    freq.put("Gi", 355);
    freq.put("oga", 220);
    freq.put("a\u0304", 118);
    freq.put("Igu", 42);
    freq.put(" ka", 43);
    freq.put("olk", 73);
    freq.put("me ", 312);
    freq.put("loi", 46);
    freq.put(" ki", 82);
    freq.put(" km", 5375);
    freq.put("uiz", 200);
    freq.put("alv", 228);
    freq.put("ais", 411);
    freq.put("Vas", 237);
    freq.put("orz", 356);
    freq.put("air", 581);
    freq.put("fa ", 651);
    freq.put("nen", 562);
    freq.put("neo", 91);
    freq.put("nel", 171);
    freq.put("nem", 1044);
    freq.put("Pui", 43);
    freq.put("nei", 429);
    freq.put(" y ", 28425);
    freq.put("Pue", 323);
    freq.put("ned", 220);
    freq.put("nee", 129);
    freq.put("neb", 239);
    freq.put("nec", 186);
    freq.put("\u062f", 70);
    freq.put("nea", 100);
    freq.put("orv", 50);
    freq.put("gna", 214);
    freq.put("nez", 217);
    freq.put("alp", 109);
    freq.put("nex", 100);
    freq.put("ecn", 84);
    freq.put("ers", 2076);
    freq.put("ruz", 231);
    freq.put("ak ", 65);
    freq.put("ner", 1944);
    freq.put("nes", 1419);
    freq.put("A\u0300", 43);
    freq.put("\u0443", 58);
    freq.put("\u03c2", 149);
    freq.put("mea", 52);
    freq.put("mec", 61);
    freq.put("e\u0300r", 649);
    freq.put("e\u0300s", 299);
    freq.put("gne", 136);
    freq.put(" Gu\u0301", 51);
    freq.put("e\u0300t", 179);
    freq.put("la\u0300 ", 40);
    freq.put("meu", 62);
    freq.put("fun", 451);
    freq.put("e\u0300i", 57);
    freq.put("urv", 46);
    freq.put("e\u0300l", 161);
    freq.put("e\u0300m", 44);
    freq.put("mey", 594);
    freq.put("mex", 49);
    freq.put("e\u0300d", 50);
    freq.put("aud", 445);
    freq.put("gli", 83);
    freq.put("Zo", 51);
    freq.put("Zi", 59);
    freq.put("glo", 720);
    freq.put("Ze", 94);
    freq.put("k", 9548);
    freq.put("Gu\u0301", 51);
    freq.put("di\u0301n", 52);
    freq.put("sla", 1276);
    freq.put("dri", 604);
    freq.put("aki", 53);
    freq.put("akh", 42);
    freq.put("ako", 58);
    freq.put("aic", 166);
    freq.put("dro", 341);
    freq.put("dra", 531);
    freq.put("Zu", 79);
    freq.put("aka", 66);
    freq.put("dre", 695);
    freq.put("der", 1900);
    freq.put("ake", 58);
    freq.put("Jer", 62);
    freq.put("Jes", 44);
    freq.put("sso", 402);
    freq.put("Nac", 229);
    freq.put("toi", 42);
    freq.put("bru", 86);
    freq.put("lmo", 183);
    freq.put("Le\u0301", 44);
    freq.put("bro", 804);
    freq.put("Jea", 137);
    freq.put("bri", 1569);
    freq.put("org", 706);
    freq.put("bre", 5163);
    freq.put("des", 5613);
    freq.put("bra", 1561);
    freq.put("m ", 1910);
    freq.put("a\u0303o ", 95);
    freq.put("met", 732);
    freq.put("ene\u0301", 47);
    freq.put("eni\u0301", 57);
    freq.put("lme", 4078);
    freq.put("li\u0301d", 41);
    freq.put("vol", 331);
    freq.put("er ", 4019);
    freq.put("po\u0301 ", 91);
    freq.put("io\u0301 ", 5096);
    freq.put("ni ", 358);
    freq.put("si\u0301a", 111);
    freq.put("A\u0301", 131);
    freq.put("Ste", 129);
    freq.put("Nai", 88);
    freq.put("Sta", 135);
    freq.put("ltr", 243);
    freq.put("ngu", 596);
    freq.put("Sto", 48);
    freq.put(" me\u0301", 265);
    freq.put("xto", 93);
    freq.put("osp", 46);
    freq.put("rip", 80);
    freq.put("Str", 75);
    freq.put("V", 6098);
    freq.put("da\u0301 ", 99);
    freq.put("lop", 119);
    freq.put("rry", 81);
    freq.put("me", 16458);
    freq.put("Nar", 43);
    freq.put("erv", 658);
    freq.put("mf", 70);
    freq.put("ma", 22094);
    freq.put("ltu", 284);
    freq.put("err", 3654);
    freq.put("mb", 4820);
    freq.put("mm", 270);
    freq.put("mo", 7848);
    freq.put("mn", 143);
    freq.put("mi", 9268);
    freq.put("ik", 367);
    freq.put("erz", 160);
    freq.put("mu", 18950);
    freq.put("ere", 1282);
    freq.put("erf", 2781);
    freq.put("erg", 428);
    freq.put("tna", 54);
    freq.put("mp", 6474);
    freq.put("ms", 136);
    freq.put("erc", 992);
    freq.put("erl", 400);
    freq.put("im", 5807);
    freq.put("ern", 1404);
    freq.put("ero", 3393);
    freq.put("my", 57);
    freq.put("eri", 3958);
    freq.put("erk", 43);
    freq.put("uay", 40);
    freq.put("Aba", 96);
    freq.put("Le", 3160);
    freq.put("Abe", 43);
    freq.put("Lib", 230);
    freq.put("La", 4114);
    freq.put("Lo", 1960);
    freq.put("Ll", 306);
    freq.put("uar", 331);
    freq.put("la ", 13225);
    freq.put("uat", 5774);
    freq.put("opo\u0301", 65);
    freq.put("Li", 1190);
    freq.put("Lit", 320);
    freq.put("tzi", 52);
    freq.put("Abr", 40);
    freq.put("Lu", 751);
    freq.put("ual", 1415);
    freq.put("Lis", 91);
    freq.put("uac", 71);
    freq.put("uad", 981);
    freq.put("Ly", 43);
    freq.put("ena", 1793);
    freq.put("hod", 105);
    freq.put("ki ", 146);
    freq.put("end", 3462);
    freq.put("ene", 5939);
    freq.put("enf", 65);
    freq.put("eng", 1616);
    freq.put("hon", 397);
    freq.put("eni", 1492);
    freq.put("i\u0304", 53);
    freq.put("hom", 232);
    freq.put("\u03b1\u0301", 43);
    freq.put("Al ", 59);
    freq.put("eno", 895);
    freq.put("hov", 67);
    freq.put("Kar", 100);
    freq.put("enr", 137);
    freq.put("ens", 4894);
    freq.put("hor", 197);
    freq.put("hos", 55);
    freq.put("en\u0303o", 50);
    freq.put("m2", 4897);
    freq.put("en\u0303a", 141);
    freq.put("eny", 1221);
    freq.put("enz", 322);
    freq.put("uco", 62);
    freq.put("A", 24874);
    freq.put("lam", 1159);
    freq.put("lan", 4366);
    freq.put("\u0645", 103);
    freq.put("lai", 286);
    freq.put("L ", 794);
    freq.put("lad", 759);
    freq.put("to\u0301 ", 198);
    freq.put("laf", 116);
    freq.put("lag", 299);
    freq.put("ost", 1452);
    freq.put("lab", 279);
    freq.put("lac", 7068);
    freq.put("ova", 354);
    freq.put("II ", 724);
    freq.put("laz", 237);
    freq.put("ove", 772);
    freq.put("lat", 2045);
    freq.put("occ", 4327);
    freq.put("lav", 397);
    freq.put("ovi", 9219);
    freq.put("lap", 58);
    freq.put("iel", 3483);
    freq.put("\u03bf\u03c2 ", 66);
    freq.put("las", 2771);
    freq.put("en ", 45647);
    freq.put("All", 75);
    freq.put("Alm", 205);
    freq.put("ma\u0301", 2404);
    freq.put("ho ", 186);
    freq.put("Ali", 368);
    freq.put("mi\u0301", 198);
    freq.put("Alg", 48);
    freq.put("u\u0304", 44);
    freq.put("Ale", 590);
    freq.put("me\u0301", 389);
    freq.put("Alc", 398);
    freq.put("ci\u0301a", 153);
    freq.put("Ala", 196);
    freq.put("lou", 71);
    freq.put("mpu", 673);
    freq.put("era\u0301", 64);
    freq.put("mo\u0301", 149);
    freq.put("eri\u0301", 642);
    freq.put("Alt", 2147);
    freq.put("Alp", 176);
    freq.put("mu\u0301", 101);
    freq.put(" V ", 80);
    freq.put("zeg", 44);
    freq.put("lt ", 112);
    freq.put("fam", 559);
    freq.put("zen", 76);
    freq.put("onh", 79);
    freq.put(" Hu", 365);
    freq.put("zer", 95);
    freq.put("fab", 307);
    freq.put(" Hi", 444);
    freq.put("anc\u0327", 88);
    freq.put(" Ho", 591);
    freq.put("zet", 109);
    freq.put("ucl", 167);
    freq.put(" Ha", 781);
    freq.put(" He", 719);
    freq.put("ono", 4250);
    freq.put("ima", 777);
    freq.put("fis", 211);
    freq.put("His", 162);
    freq.put("Hit", 59);
    freq.put("cli", 257);
    freq.put("ro\u0300", 79);
    freq.put("ro\u0301", 536);
    freq.put("imi", 832);
    freq.put("cle", 173);
    freq.put("fix", 143);
    freq.put("onm", 40);
    freq.put("i\u0301a ", 4569);
    freq.put("cla", 931);
    freq.put("ru\u0301", 70);
    freq.put("imn", 76);
    freq.put("fib", 68);
    freq.put("imp", 1430);
    freq.put("ra\u0300", 73);
    freq.put("ra\u0301", 410);
    freq.put("nja", 54);
    freq.put("ani\u0301", 220);
    freq.put("ri\u0301", 2661);
    freq.put("mu\u0301n", 92);
    freq.put("Hil", 81);
    freq.put("re\u0301", 394);
    freq.put("fil", 651);
    freq.put("\u03c1", 123);
    freq.put("ze ", 198);
    freq.put("\u0142", 55);
    freq.put(" Ve", 691);
    freq.put("ra\u0301 ", 52);
    freq.put("gle\u0301", 443);
    freq.put(" Vi", 2397);
    freq.put("rs ", 2827);
    freq.put("nto\u0301", 2943);
    freq.put("zia", 62);
    freq.put("Sa\u0303o", 53);
    freq.put(" Vo", 162);
    freq.put("ong", 765);
    freq.put("bo\u0301n", 87);
    freq.put("nti\u0301", 175);
    freq.put("teu", 43);
    freq.put("one", 1454);
    freq.put("uas", 205);
    freq.put("im ", 145);
    freq.put("Vie\u0300", 41);
    freq.put("ati\u0301", 551);
    freq.put("l", 153654);
    freq.put(" go", 384);
    freq.put("uci", 673);
    freq.put("ri\u0301a", 1416);
    freq.put("do\u0300m", 187);
    freq.put("ato\u0301", 98);
    freq.put("gri", 582);
    freq.put("dep", 3598);
    freq.put("\u0301", 61);
    freq.put("woo", 45);
    freq.put("uch", 247);
    freq.put("tip", 273);
    freq.put("Ile", 92);
    freq.put("ssa", 416);
    freq.put("nt ", 9999);
    freq.put("upa", 191);
    freq.put("zat", 450);
    freq.put("nio", 1015);
    freq.put("rt", 18219);
    freq.put("ru", 3976);
    freq.put("rv", 867);
    freq.put("rw", 51);
    freq.put("rp", 829);
    freq.put("rq", 661);
    freq.put("rr", 10518);
    freq.put("rs", 4137);
    freq.put(" ze", 43);
    freq.put("god", 95);
    freq.put("rx", 65);
    freq.put("ry", 499);
    freq.put("rz", 1385);
    freq.put("gob", 53);
    freq.put("rd", 4758);
    freq.put("re", 36472);
    freq.put("rf", 2952);
    freq.put("rg", 3076);
    freq.put("nic", 8881);
    freq.put("Eus", 72);
    freq.put("rb", 2086);
    freq.put("rc", 8506);
    freq.put("rl", 1733);
    freq.put("rm", 3699);
    freq.put("rn", 3248);
    freq.put("ro", 26141);
    freq.put("rh", 94);
    freq.put("ri", 26132);
    freq.put("gos", 1875);
    freq.put("rk", 850);
    freq.put("mie\u0301", 1515);
    freq.put("ntz", 90);
    freq.put("nts", 4132);
    freq.put("ntr", 3775);
    freq.put("ntu", 217);
    freq.put("nti", 4508);
    freq.put("nth", 93);
    freq.put("cio", 3004);
    freq.put("ome\u0301", 50);
    freq.put("ntl", 40);
    freq.put("W", 1232);
    freq.put("nta", 5325);
    freq.put("ntb", 47);
    freq.put("nte", 2859);
    freq.put("deb", 265);
    freq.put("ntg", 68);
    freq.put("Vic", 256);
    freq.put("ate", 1325);
    freq.put("Vig", 45);
    freq.put("Vid", 63);
    freq.put("Vie", 268);
    freq.put("iss", 346);
    freq.put("ato", 13605);
    freq.put("atl", 127);
    freq.put("isp", 308);
    freq.put("Vin", 160);
    freq.put("i\u0300", 53);
    freq.put("Vil", 1006);
    freq.put("ati", 1701);
    freq.put("Vir", 86);
    freq.put("Vis", 59);
    freq.put("att", 124);
    freq.put("atu", 842);
    freq.put("r ", 21128);
    freq.put("ats", 80);
    freq.put("Vit", 75);
    freq.put("isl", 671);
    freq.put("Viz", 145);
    freq.put("isb", 61);
    freq.put("isa", 284);
    freq.put("med", 417);
    freq.put("atz", 500);
    freq.put(" Sp", 125);
    freq.put("ise", 307);
    freq.put("sup", 2871);
    freq.put("Eur", 458);
    freq.put("zam", 70);
    freq.put("nha", 307);
    freq.put("ra\u0301n", 277);
    freq.put(" l ", 7346);
    freq.put("nho", 77);
    freq.put("Duc", 86);
    freq.put("la\u0301 ", 57);
    freq.put("Due", 176);
    freq.put("pir", 221);
    freq.put("nir", 59);
    freq.put("osa", 1430);
    freq.put("nis", 1543);
    freq.put("Dur", 53);
    freq.put("fin", 464);
    freq.put("toz", 49);
    freq.put("xic", 268);
    freq.put("xid", 80);
    freq.put("xie", 229);
    freq.put("tor", 4909);
    freq.put("Cen", 268);
    freq.put("lm ", 61);
    freq.put("Cel", 82);
    freq.put("equ", 358);
    freq.put("xim", 208);
    freq.put("tot", 518);
    freq.put("tou", 1509);
    freq.put(" Si", 1206);
    freq.put("xit", 4235);
    freq.put("Cer", 1047);
    freq.put("tol", 876);
    freq.put("Se ", 453);
    freq.put("toc", 171);
    freq.put("niu", 41);
    freq.put("tog", 1133);
    freq.put("tod", 133);
    freq.put("tei\u0301", 49);
    freq.put(" le", 1142);
    freq.put("B", 11416);
    freq.put("uip", 268);
    freq.put("nh ", 93);
    freq.put(" la", 7106);
    freq.put("et", 7416);
    freq.put("Soc", 173);
    freq.put(" li", 1110);
    freq.put("oi\u0301s", 51);
    freq.put(" lu", 2504);
    freq.put("Fue", 512);
    freq.put("Fun", 74);
    freq.put("cu\u0301 ", 41);
    freq.put("teg", 218);
    freq.put("Sev", 235);
    freq.put("Seu", 68);
    freq.put("Set", 46);
    freq.put("lla", 7059);
    freq.put("Ser", 298);
    freq.put("Sep", 51);
    freq.put("i\u0301", 10894);
    freq.put("to ", 29963);
    freq.put("Seg", 496);
    freq.put("nza", 531);
    freq.put("Sec", 243);
    freq.put("nze", 53);
    freq.put("Sen", 840);
    freq.put("Sem", 182);
    freq.put("Sel", 119);
    freq.put("nzo", 99);
    freq.put("ept", 204);
    freq.put("Sei", 53);
    freq.put("raf", 1535);
    freq.put("rag", 6073);
    freq.put("rad", 1513);
    freq.put("epu", 741);
    freq.put("rab", 769);
    freq.put("rac", 1579);
    freq.put("\u4e09", 85);
    freq.put("ral", 2056);
    freq.put("ram", 788);
    freq.put("ty ", 139);
    freq.put("ma\u0301s", 1055);
    freq.put("rah", 88);
    freq.put("rai", 190);
    freq.put("rav", 344);
    freq.put("rat", 2401);
    freq.put("rau", 304);
    freq.put("iu ", 332);
    freq.put("ras", 2221);
    freq.put("rap", 218);
    freq.put("dur", 262);
    freq.put("ipi", 7426);
    freq.put("raz", 455);
    freq.put("lbo", 81);
    freq.put("ray", 93);
    freq.put("Asp", 82);
    freq.put("eud", 108);
    freq.put("Ast", 163);
    freq.put("do ", 4312);
    freq.put("sal", 425);
    freq.put("alo\u0301", 105);
    freq.put("hul", 634);
    freq.put("xio\u0301", 155);
    freq.put("tev", 102);
    freq.put("rse", 122);
    freq.put(" fe", 1998);
    freq.put("Asi", 176);
    freq.put("Aso", 50);
    freq.put("hun", 1148);
    freq.put("Qu", 333);
    freq.put("ra ", 13591);
    freq.put("suf", 112);
    freq.put("bst", 107);
    freq.put(" li\u0301", 44);
    freq.put("vez", 50);
    freq.put(" fi", 1256);
    freq.put("bso", 41);
    freq.put("ipo", 232);
    freq.put("bse", 48);
    freq.put("ogr", 1569);
    freq.put("the", 306);
    freq.put("sub", 387);
    freq.put("nzo\u0301", 57);
    freq.put("don", 410);
    freq.put("dol", 760);
    freq.put("dom", 223);
    freq.put("dob", 178);
    freq.put("doc", 435);
    freq.put("m", 96885);
    freq.put("Ita", 545);
    freq.put("As ", 436);
    freq.put("sun", 122);
    freq.put("dor", 1504);
    freq.put("dos", 1016);
    freq.put("dop", 45);
    freq.put("dot", 86);
    freq.put("dou", 58);
    freq.put(" We", 250);
    freq.put(" Wa", 265);
    freq.put(" Wo", 125);
    freq.put("e\u0301s", 12234);
    freq.put("e\u0301r", 268);
    freq.put("e\u0301u", 47);
    freq.put("e\u0301t", 78);
    freq.put("d ", 44350);
    freq.put("e\u0301v", 65);
    freq.put("rst", 64);
    freq.put(" Wu", 48);
    freq.put("e\u0301m", 47);
    freq.put("e\u0301l", 127);
    freq.put("e\u0301n", 2272);
    freq.put("e\u0301a", 65);
    freq.put("e\u0301c", 86);
    freq.put(" Ai\u0301", 54);
    freq.put("e\u0301e", 59);
    freq.put("e\u0301g", 58);
    freq.put("oci", 755);
    freq.put("och", 1133);
    freq.put("Bil", 130);
    freq.put("udi", 2062);
    freq.put("uen", 2417);
    freq.put("em ", 132);
    freq.put("o\u0300r", 179);
    freq.put("o\u0300s", 256);
    freq.put("oca", 1477);
    freq.put("Big", 731);
    freq.put("Bid", 83);
    freq.put("Bie", 159);
    freq.put("oce", 431);
    freq.put("\u062c", 41);
    freq.put("Bia", 400);
    freq.put("do\u0301n", 67);
    freq.put("abs", 89);
    freq.put("Biz", 81);
    freq.put("ba ", 2806);
    freq.put("o\u0300c", 49);
    freq.put("hre", 40);
    freq.put("o\u0300m", 188);
    freq.put("o\u0300n", 43);
    freq.put("ocr", 193);
    freq.put("ocu", 240);
    freq.put("Bis", 62);
    freq.put("sur", 324);
    freq.put("dn", 56);
    freq.put("\u0440", 160);
    freq.put("dl", 77);
    freq.put("dm", 483);
    freq.put("dh", 96);
    freq.put("di", 13701);
    freq.put("Lui", 166);
    freq.put("dg", 113);
    freq.put("dd", 182);
    freq.put("de", 103587);
    freq.put("dc", 59);
    freq.put("omi\u0301", 105);
    freq.put("da", 17903);
    freq.put("ga ", 3535);
    freq.put("nev", 50);
    freq.put("tis", 1361);
    freq.put("dy", 121);
    freq.put("dv", 108);
    freq.put("dw", 105);
    freq.put("dt", 51);
    freq.put("du", 1967);
    freq.put("dr", 2386);
    freq.put("ds", 221);
    freq.put("eme", 667);
    freq.put("bat", 496);
    freq.put("bau", 76);
    freq.put("bar", 826);
    freq.put("bas", 778);
    freq.put("ila\u0301", 43);
    freq.put("Riv", 46);
    freq.put("oc ", 329);
    freq.put("emo", 579);
    freq.put("Riu", 60);
    freq.put("emi", 1471);
    freq.put("Ris", 43);
    freq.put("Rin", 49);
    freq.put("Rio", 251);
    freq.put("bad", 107);
    freq.put("o\u0300 ", 54);
    freq.put("bac", 233);
    freq.put("uri\u0301", 43);
    freq.put("ban", 1137);
    freq.put("op ", 77);
    freq.put("bal", 979);
    freq.put("Rib", 614);
    freq.put("Ric", 155);
    freq.put("do\u0301 ", 56);
    freq.put("bai", 592);
    freq.put("ua ", 575);
    freq.put("om ", 111);
    freq.put("w ", 229);
    freq.put("Pet", 150);
    freq.put("nut", 82);
    freq.put("mbu", 159);
    freq.put("nur", 49);
    freq.put("nus", 137);
    freq.put("Per", 591);
    freq.put("ia ", 20555);
    freq.put("Pel", 40);
    freq.put("Pen", 382);
    freq.put("num", 304);
    freq.put("omu\u0301", 90);
    freq.put("nui", 47);
    freq.put("Ped", 168);
    freq.put("oma", 8598);
    freq.put("nue", 339);
    freq.put("nub", 51);
    freq.put("nuc", 179);
    freq.put("nua", 50);
    freq.put("oce\u0301", 67);
    freq.put("yer", 1805);
    freq.put("zo ", 978);
    freq.put("il ", 1291);
    freq.put("Rum", 113);
    freq.put("Rub", 41);
    freq.put("uso", 426);
    freq.put("irr", 87);
    freq.put("i\u0301st", 73);
    freq.put("iru", 67);
    freq.put("irv", 40);
    freq.put("mue", 2339);
    freq.put("iri", 575);
    freq.put("mug", 267);
    freq.put("irl", 117);
    freq.put("irm", 204);
    freq.put("iro", 527);
    freq.put("Rus", 221);
    freq.put("i\u0301se", 239);
    freq.put("irc", 161);
    freq.put("mui", 583);
    freq.put("ire", 4699);
    freq.put("irg", 44);
    freq.put("so\u0301 ", 81);
    freq.put("omb", 2217);
    freq.put("we", 271);
    freq.put("di\u0301", 2145);
    freq.put("wa", 371);
    freq.put("de\u0301", 369);
    freq.put("wo", 96);
    freq.put("wn", 65);
    freq.put(" Ir", 296);
    freq.put(" Is", 1032);
    freq.put(" It", 588);
    freq.put("Sam", 249);
    freq.put("wi", 289);
    freq.put("da\u0301", 285);
    freq.put("omp", 969);
    freq.put("ws", 51);
    freq.put(" Im", 754);
    freq.put(" In", 704);
    freq.put("nol", 187);
    freq.put(" Ib", 231);
    freq.put("na ", 29914);
    freq.put("do\u0300", 202);
    freq.put("do\u0301", 142);
    freq.put("Lun", 61);
    freq.put(" Ig", 114);
    freq.put("ema", 2624);
    freq.put("ild", 72);
    freq.put("ile", 486);
    freq.put("ilb", 85);
    freq.put("ell", 8850);
    freq.put("ila", 709);
    freq.put("ilo", 709);
    freq.put("ill", 3569);
    freq.put("ilm", 50);
    freq.put("tt ", 108);
    freq.put("ilh", 186);
    freq.put("ili", 1413);
    freq.put("ilv", 161);
    freq.put("una", 19774);
    freq.put("coc", 226);
    freq.put("cob", 54);
    freq.put("und", 1442);
    freq.put("ils", 93);
    freq.put("ueg", 394);
    freq.put("elc", 143);
    freq.put("ir ", 1069);
    freq.put("uni", 12278);
    freq.put("goz", 1189);
    freq.put("unk", 72);
    freq.put("u\u0301da", 51);
    freq.put("hab", 5867);
    freq.put("unn", 65);
    freq.put("con", 9719);
    freq.put(" me", 3304);
    freq.put("hac", 508);
    freq.put(" ma", 4705);
    freq.put("o\u0301n ", 23122);
    freq.put("in\u0303", 101);
    freq.put("had", 57);
    freq.put("io\u0301", 20432);
    freq.put(" mo", 1373);
    freq.put(" mi", 1891);
    freq.put("rti", 4275);
    freq.put("hae", 98);
    freq.put("ie\u0301", 1837);
    freq.put("ie\u0300", 238);
    freq.put("Pas", 141);
    freq.put("ia\u0301", 1740);
    freq.put("ia\u0300", 102);
    freq.put("ele", 1251);
    freq.put(" ro", 846);
    freq.put("san", 614);
    freq.put("fra", 6871);
    freq.put("che", 3543);
    freq.put("fre", 244);
    freq.put("rga", 811);
    freq.put("ggi", 46);
    freq.put("fri", 349);
    freq.put("C ", 328);
    freq.put("fro", 68);
    freq.put("\u03b9\u0301", 50);
    freq.put("sac", 303);
    freq.put("fru", 71);
    freq.put("e\u0301u ", 44);
    freq.put("mez", 72);
    freq.put("ai ", 461);
    freq.put("sis", 499);
    freq.put("rge", 464);
    freq.put("ab ", 2350);
    freq.put("i\u0301as", 665);
    freq.put("i\u0301ns", 58);
    freq.put(" m ", 86);
    freq.put("Cru", 110);
    freq.put("sag", 89);
    freq.put("o\u0301ni", 49);
    freq.put("ico\u0301", 83);
    freq.put("Cra", 64);
    freq.put("anj", 43);
    freq.put("Cre", 79);
    freq.put("nio\u0301", 453);
    freq.put("Cri", 147);
    freq.put("Cro", 121);
    freq.put("oqu", 218);
    freq.put("xo ", 835);
    freq.put("Ci", 1041);
    freq.put("Ch", 3175);
    freq.put("Co", 3422);
    freq.put("aix", 4540);
    freq.put("Cl", 510);
    freq.put("ait", 77);
    freq.put("Ca", 8068);
    freq.put("su ", 157);
    freq.put("Ce", 1517);
    freq.put("n", 332450);
    freq.put("aim", 120);
    freq.put("ail", 226);
    freq.put("Cy", 45);
    freq.put("ain", 870);
    freq.put("sli", 62);
    freq.put("gla", 523);
    freq.put("Cr", 538);
    freq.put("aig", 94);
    freq.put("aif", 44);
    freq.put("aia", 53);
    freq.put("gno", 114);
    freq.put("Cu", 873);
    freq.put("iy", 76);
    freq.put("ix", 7972);
    freq.put("iz", 2558);
    freq.put(" ma\u0301", 765);
    freq.put("rtu", 523);
    freq.put("bio", 344);
    freq.put("iq", 449);
    freq.put("ip", 9686);
    freq.put("is", 13378);
    freq.put("ir", 8944);
    freq.put("iu", 2673);
    freq.put("it", 41046);
    freq.put("iv", 4272);
    freq.put("ii", 54);
    freq.put("ih", 91);
    freq.put("Nap", 52);
    freq.put("ij", 127);
    freq.put("Nav", 689);
    freq.put("il", 9035);
    freq.put("io", 20463);
    freq.put("in", 28928);
    freq.put("ia", 33192);
    freq.put("ic", 35920);
    freq.put("ib", 3636);
    freq.put("ie", 19241);
    freq.put("id", 11407);
    freq.put("ig", 5438);
    freq.put("if", 2242);
    freq.put("V ", 289);
    freq.put("tra", 3520);
    freq.put("opr", 46);
    freq.put("dhi", 40);
    freq.put("lqu", 129);
    freq.put("\u062d", 44);
    freq.put("di\u0301s", 58);
    freq.put("ezo", 65);
    freq.put("sau", 128);
    freq.put("bi\u0301", 66);
    freq.put("th ", 346);
    freq.put("\u0441", 155);
    freq.put("to\u0301n", 3024);
    freq.put("bie", 575);
    freq.put("nin", 419);
    freq.put("\u03c4", 88);
    freq.put("Nat", 109);
    freq.put("nim", 685);
    freq.put("kis", 56);
    freq.put("Oc", 530);
    freq.put("nia", 2959);
    freq.put("nif", 282);
    freq.put("nig", 161);
    freq.put("nid", 2791);
    freq.put("be\u0301", 284);
    freq.put("niz", 323);
    freq.put("tz ", 970);
    freq.put("kin", 118);
    freq.put("kil", 72);
    freq.put("Y", 2048);
    freq.put("i ", 5556);
    freq.put("Dic", 108);
    freq.put("niv", 269);
    freq.put("nit", 2772);
    freq.put("io\u0301n", 15324);
    freq.put("Va", 2416);
    freq.put("Ce\u0301", 64);
    freq.put("Ve", 691);
    freq.put("Vi", 2398);
    freq.put("Ca\u0301", 129);
    freq.put(" L ", 757);
    freq.put("epr", 370);
    freq.put("epp", 42);
    freq.put("Vo", 163);
    freq.put("tho", 92);
    freq.put("epo", 219);
    freq.put("tie", 4123);
    freq.put("igh", 138);
    freq.put("eph", 122);
    freq.put("epi", 88);
    freq.put("uce", 207);
    freq.put("epe", 349);
    freq.put("riu", 101);
    freq.put("epc", 40);
    freq.put("tha", 124);
    freq.put("epa", 3520);
    freq.put("nk ", 109);
    freq.put("yen", 347);
    freq.put("zol", 64);
    freq.put("rn ", 546);
    freq.put("oli\u0301", 46);
    freq.put("olo\u0301", 41);
    freq.put("Xal", 52);
    freq.put("lmu", 74);
    freq.put("tro\u0301", 52);
    freq.put("yes", 179);
    freq.put("Ech", 107);
    freq.put("Ou", 63);
    freq.put("yev", 162);
    freq.put("hai", 129);
    freq.put("elh", 102);
    freq.put("eli", 1398);
    freq.put("hal", 167);
    freq.put("ham", 219);
    freq.put("han", 579);
    freq.put("elm", 81);
    freq.put("elb", 64);
    freq.put("Gav", 41);
    freq.put("Gau", 302);
    freq.put("Kon", 42);
    freq.put("Gas", 177);
    freq.put("Gar", 1065);
    freq.put("eld", 142);
    freq.put("bis", 197);
    freq.put("Gan", 52);
    freq.put("Gal", 553);
    freq.put("uma\u0301", 123);
    freq.put("lch", 255);
    freq.put("hap", 158);
    freq.put("els", 263);
    freq.put("har", 1290);
    freq.put("has", 147);
    freq.put("hat", 40);
    freq.put("Gab", 72);
    freq.put("elt", 264);
    freq.put("elu", 165);
    freq.put("Tri", 127);
    freq.put("opu", 320);
    freq.put("rni", 615);
    freq.put("lcu", 105);
    freq.put("rno", 450);
    freq.put("D", 4007);
    freq.put("Tro", 100);
    freq.put("ops", 40);
    freq.put("Tra", 328);
    freq.put("ye ", 23794);
    freq.put("rna", 910);
    freq.put("Tre", 169);
    freq.put(" E\u0301v", 65);
    freq.put("vio", 76);
    freq.put("ope", 454);
    freq.put("lce", 50);
    freq.put("opa", 516);
    freq.put(" Sa\u0303", 53);
    freq.put("rns", 42);
    freq.put("lco", 195);
    freq.put("ub ", 368);
    freq.put("oeu", 48);
    freq.put("rne", 366);
    freq.put("opi", 489);
    freq.put("rnu", 49);
    freq.put("bpa", 44);
    freq.put("Arq", 53);
    freq.put("Arr", 261);
    freq.put("Ars", 45);
    freq.put("Art", 241);
    freq.put("rke", 44);
    freq.put("ha ", 1929);
    freq.put("lei", 286);
    freq.put("el ", 3419);
    freq.put("sk ", 46);
    freq.put("ue\u0301s", 858);
    freq.put("i\u0308", 110);
    freq.put("Ara", 1956);
    freq.put("Arb", 109);
    freq.put("Arc", 243);
    freq.put("Ard", 75);
    freq.put("Are", 82);
    freq.put("Arg", 208);
    freq.put("Ari", 148);
    freq.put("bn ", 44);
    freq.put("Arl", 72);
    freq.put("Arm", 172);
    freq.put("Arn", 49);
    freq.put("ola", 1622);
    freq.put("hs ", 41);
    freq.put("olc", 47);
    freq.put("old", 202);
    freq.put("ole", 736);
    freq.put("olf", 145);
    freq.put("zag", 449);
    freq.put(" Ju", 421);
    freq.put("oli", 2360);
    freq.put("Tom", 76);
    freq.put("oll", 594);
    freq.put("olm", 67);
    freq.put("Fu\u0301t", 72);
    freq.put("olp", 41);
    freq.put("zcu", 130);
    freq.put(" Jo", 916);
    freq.put("ols", 519);
    freq.put(" Ji", 54);
    freq.put("olu", 385);
    freq.put("olv", 43);
    freq.put(" Je", 310);
    freq.put("noc", 64);
    freq.put("eer", 148);
    freq.put(" Ja", 568);
    freq.put("puz", 122);
    freq.put("ick", 140);
    freq.put("Lea", 60);
    freq.put("ici", 16857);
    freq.put("Lec", 40);
    freq.put("ico", 6536);
    freq.put("ump", 44);
    freq.put("for", 2092);
    freq.put("Leg", 47);
    freq.put("icc", 197);
    freq.put("Lei", 300);
    freq.put("ica", 8644);
    freq.put("tio", 464);
    freq.put("Lem", 47);
    freq.put("Len", 373);
    freq.put("Hu", 367);
    freq.put("rio", 3419);
    freq.put("Ler", 40);
    freq.put("Hi", 448);
    freq.put("Let", 41);
    freq.put("Ho", 594);
    freq.put("umb", 157);
    freq.put("fol", 141);
    freq.put("Ley", 1614);
    freq.put("fon", 296);
    freq.put("Ha", 782);
    freq.put("umi", 95);
    freq.put("\u03bf\u03c2", 66);
    freq.put("icu", 187);
    freq.put("He", 720);
    freq.put("ol ", 1565);
    freq.put("tio\u0301", 3631);
    freq.put(" Xi", 132);
    freq.put("sa ", 3938);
    freq.put("rep", 629);
    freq.put(" Xa", 108);
    freq.put("un ", 14687);
    freq.put("nsf", 49);
    freq.put("ple", 898);
    freq.put("pla", 716);
    freq.put("iga", 1659);
    freq.put("plo", 489);
    freq.put(" J ", 52);
    freq.put("pli", 171);
    freq.put("Le ", 98);
    freq.put("obo", 70);
    freq.put("obl", 6299);
    freq.put("cio\u0301", 9852);
    freq.put("obi", 203);
    freq.put("ic ", 192);
    freq.put("obc", 126);
    freq.put("o", 309189);
    freq.put("oba", 1120);
    freq.put("ome", 737);
    freq.put("utb", 55);
    freq.put("fo ", 248);
    freq.put("oda", 219);
    freq.put("zue", 177);
    freq.put("H ", 44);
    freq.put("obr", 1405);
    freq.put("obs", 51);
    freq.put("zul", 76);
    freq.put("a\u0301nd", 139);
    freq.put("Fed", 103);
    freq.put("aha", 105);
    freq.put("Cur", 50);
    freq.put("ppe", 91);
    freq.put("a\u0301nc", 42);
    freq.put("Fen", 49);
    freq.put("mbe", 233);
    freq.put("Fel", 132);
    freq.put("aho", 59);
    freq.put("son", 2287);
    freq.put("uyi", 284);
    freq.put("Cue", 508);
    freq.put("sor", 319);
    freq.put("Fer", 367);
    freq.put("Cub", 64);
    freq.put("sov", 57);
    freq.put("IV ", 156);
    freq.put("Cul", 58);
    freq.put("opo", 466);
    freq.put("uno", 513);
    freq.put("mbr", 3381);
    freq.put("zca", 158);
    freq.put("ne\u0300", 64);
    freq.put("ne\u0301", 3667);
    freq.put("ni\u0301", 360);
    freq.put("az ", 147);
    freq.put("na\u0301", 154);
    freq.put("nc\u0327", 561);
    freq.put("e\u0301ch", 44);
    freq.put(" Er", 277);
    freq.put("gia", 75);
    freq.put("gio", 83);
    freq.put("gin", 62);
    freq.put("no\u0300", 54);
    freq.put("no\u0301", 211);
    freq.put("de\u0300r", 52);
    freq.put("ten", 3384);
    freq.put("ret", 1001);
    freq.put("so ", 1404);
    freq.put("\u03c3", 63);
    freq.put("\u0442", 77);
    freq.put("a\u0301n ", 10527);
    freq.put("ure", 412);
    freq.put("liu", 92);
    freq.put("aul", 310);
    freq.put("noy", 53);
    freq.put("efa", 54);
    freq.put("gru", 390);
    freq.put("Z", 2105);
    freq.put("teo", 124);
    freq.put("I\u0301x", 93);
    freq.put("ura", 2237);
    freq.put("azi", 123);
    freq.put(" La", 4106);
    freq.put("azo", 174);
    freq.put("Vol", 63);
    freq.put("aza", 531);
    freq.put("Odr", 44);
    freq.put("te\u0300t", 120);
    freq.put("aze", 141);
    freq.put("wa ", 59);
    freq.put("azz", 58);
    freq.put("thn", 65);
    freq.put("tie\u0301", 42);
    freq.put("gi ", 48);
    freq.put("olt", 132);
    freq.put("azt", 42);
    freq.put("azu", 65);
    freq.put("Ues", 1284);
    freq.put("Sis", 99);
    freq.put("Sir", 77);
    freq.put("uro", 825);
    freq.put("u\u0308r", 63);
    freq.put("n\u0303or", 41);
    freq.put("nni", 155);
    freq.put("ue\u0301 ", 86);
    freq.put(" n ", 127);
    freq.put("nne", 666);
    freq.put("nna", 170);
    freq.put("u\u0308e", 263);
    freq.put("Sig", 48);
    freq.put(" Li", 1187);
    freq.put("Sie", 418);
    freq.put(" Va", 2415);
    freq.put("kha", 50);
    freq.put("n\u0303ol", 77);
    freq.put("nns", 57);
    freq.put("Sin", 151);
    freq.put("Sim", 93);
    freq.put("u\u0308i", 139);
    freq.put("nh", 555);
    freq.put("ni", 23728);
    freq.put("nj", 111);
    freq.put("nk", 294);
    freq.put("nl", 294);
    freq.put("nm", 99);
    freq.put("nn", 1413);
    freq.put("no", 15371);
    freq.put("tit", 2499);
    freq.put("na", 42520);
    freq.put("nb", 139);
    freq.put("nc", 27078);
    freq.put("nd", 12460);
    freq.put("ne", 13823);
    freq.put("nf", 817);
    freq.put("ng", 5331);
    freq.put("til", 588);
    freq.put("ny", 8884);
    freq.put("nz", 961);
    freq.put("\u0627\u0644", 87);
    freq.put("nki", 41);
    freq.put("tid", 328);
    freq.put("nq", 367);
    freq.put("nr", 248);
    freq.put("ns", 10765);
    freq.put("nt", 42111);
    freq.put("nu", 1742);
    freq.put("nv", 500);
    freq.put("tic", 4224);
    freq.put(" ni", 192);
    freq.put("ego\u0301", 100);
    freq.put("E", 9481);
    freq.put(" no", 4290);
    freq.put(" na", 4148);
    freq.put("urs", 199);
    freq.put(" ne", 482);
    freq.put("ele\u0300", 120);
    freq.put("squ", 227);
    freq.put("nn ", 180);
    freq.put("mun", 14364);
    freq.put("ich", 1956);
    freq.put("tec", 464);
    freq.put("rei", 1976);
    freq.put("n\u0303o ", 46);
    freq.put("\u0259", 50);
    freq.put("bo ", 313);
    freq.put(" nu", 622);
    freq.put("azi\u0301", 106);
    freq.put("n ", 117507);
    freq.put("Win", 54);
    freq.put("Wil", 218);
    freq.put("mme", 71);
    freq.put("o\u0300m ", 188);
    freq.put("\u0430 ", 67);
    freq.put("ren", 6329);
    freq.put("plu", 67);
    freq.put("rk ", 612);
    freq.put("ti ", 579);
    freq.put("te\u0301 ", 56);
    freq.put("roi", 133);
    freq.put("lly", 119);
    freq.put("rol", 525);
    freq.put("rom", 669);
    freq.put("ron", 3295);
    freq.put("lls", 428);
    freq.put("roa", 141);
    freq.put("rob", 921);
    freq.put("roc", 838);
    freq.put("rod", 803);
    freq.put("roe", 57);
    freq.put("rof", 212);
    freq.put("rog", 138);
    freq.put("osi", 694);
    freq.put("roy", 164);
    freq.put("roz", 64);
    freq.put("llo", 2287);
    freq.put("ice", 399);
    freq.put("oso", 499);
    freq.put("osn", 62);
    freq.put("rop", 1326);
    freq.put("roq", 99);
    freq.put("ror", 130);
    freq.put("Leo", 104);
    freq.put(" Mu\u0301", 79);
    freq.put("rou", 179);
    freq.put("rov", 8451);
    freq.put("row", 58);
    freq.put("Aqu", 797);
    freq.put("ume", 577);
    freq.put("vet", 87);
    freq.put("gu ", 63);
    freq.put("ime", 1567);
    freq.put("ves", 245);
    freq.put("Dac", 115);
    freq.put("Dal", 45);
    freq.put("urt", 257);
    freq.put("Dan", 127);
    freq.put("di ", 271);
    freq.put("zu ", 46);
    freq.put("vey", 52);
    freq.put("veg", 260);
    freq.put("Dav", 113);
    freq.put("Les", 137);
    freq.put("ui\u0301a", 139);
    freq.put("vec", 112);
    freq.put("Dar", 133);
    freq.put("ven", 911);
    freq.put("uma", 425);
    freq.put("vel", 555);
    freq.put("o\u0301 ", 6509);
    freq.put("oid", 74);
    freq.put("cov", 40);
    freq.put(" do", 1088);
    freq.put("eru", 753);
    freq.put("ro ", 6031);
    freq.put("Me\u0301", 58);
    freq.put("Cin", 435);
    freq.put("Cis", 56);
    freq.put("Cir", 43);
    freq.put("ai\u0308s", 55);
    freq.put("Civ", 71);
    freq.put("Ciu", 227);
    freq.put("Cit", 50);
    freq.put("erp", 493);
    freq.put("Pat", 94);
    freq.put("ll ", 601);
    freq.put("umo", 103);
    freq.put("Mu\u0301", 79);
    freq.put("dil", 238);
    freq.put("gub", 134);
    freq.put("gua", 1007);
    freq.put("dio", 972);
    freq.put("nla", 104);
    freq.put("Tar", 597);
    freq.put("sud", 745);
    freq.put("o\u0301s", 186);
    freq.put("o\u0301r", 60);
    freq.put("gui", 929);
    freq.put("o\u0301p", 44);
    freq.put("gun", 881);
    freq.put("dib", 46);
    freq.put("gul", 273);
    freq.put("gus", 162);
    freq.put("p", 79744);
    freq.put("rma\u0301", 65);
    freq.put("o\u0301n", 23204);
    freq.put("o\u0301m", 55);
    freq.put("gut", 43);
    freq.put("Tal", 63);
    freq.put("Tam", 196);
    freq.put("Tan", 48);
    freq.put("ict", 263);
    freq.put("dip", 45);
    freq.put("Tai", 54);
    freq.put("Taj", 45);
    freq.put("dis", 954);
    freq.put("sab", 254);
    freq.put("Gru", 82);
    freq.put("M ", 73);
    freq.put(" Yo", 603);
    freq.put("llo\u0301", 632);
    freq.put("Res", 57);
    freq.put("Rep", 613);
    freq.put("Rev", 100);
    freq.put(" Ye", 1232);
    freq.put("ose\u0301", 216);
    freq.put("nli", 101);
    freq.put("lle\u0301", 182);
    freq.put("Gre", 227);
    freq.put("Ren", 132);
    freq.put("dev", 209);
    freq.put("Rel", 50);
    freq.put("Gra", 645);
    freq.put("Gro", 44);
    freq.put("lla\u0301", 2506);
    freq.put("Rea", 232);
    freq.put("ued", 332);
    freq.put("Reg", 57);
    freq.put("Red", 59);
    freq.put("Gri", 72);
    freq.put("erd", 1295);
    freq.put("rul", 41);
    freq.put("rum", 242);
    freq.put("e\u0300rs", 123);
    freq.put("e\u0300rr", 55);
    freq.put("Qua", 92);
    freq.put("rub", 49);
    freq.put("Que", 100);
    freq.put("tom", 251);
    freq.put("Qui", 124);
    freq.put("e\u0300ra", 204);
    freq.put("bn", 53);
    freq.put("rva", 257);
    freq.put("era", 7654);
    freq.put("Me", 3060);
    freq.put("bo", 2387);
    freq.put("Ma", 5263);
    freq.put("erb", 545);
    freq.put("Mc", 66);
    freq.put("ht ", 118);
    freq.put("Mo", 2562);
    freq.put("deo", 89);
    freq.put("Mi", 1407);
    freq.put("bi", 6912);
    freq.put("Mu", 1274);
    freq.put("gle", 161);
    freq.put("rud", 70);
    freq.put("erm", 1179);
    freq.put("Agu", 108);
    freq.put("oet", 294);
    freq.put("Agr", 41);
    freq.put("or ", 9087);
    freq.put("wer", 45);
    freq.put("Boh", 42);
    freq.put("xma", 49);
    freq.put("tni", 61);
    freq.put("bor", 360);
    freq.put("bos", 126);
    freq.put("bot", 129);
    freq.put("bou", 51);
    freq.put("ngl", 1038);
    freq.put("bol", 805);
    freq.put("bon", 258);
    freq.put("cha", 2607);
    freq.put("bp", 52);
    freq.put("boc", 153);
    freq.put("e\u0300r ", 80);
    freq.put("dio\u0301", 145);
    freq.put("ugh", 63);
    freq.put("ipc", 44);
    freq.put("ipa", 1088);
    freq.put("br", 9258);
    freq.put("ipe", 312);
    freq.put("ott", 123);
    freq.put(" it", 1473);
    freq.put("bs", 272);
    freq.put("e\u0301vi", 40);
    freq.put("ipl", 106);
    freq.put("ngi", 53);
    freq.put("ipr", 52);
    freq.put("ipp", 56);
    freq.put("Lig", 108);
    freq.put("ipt", 82);
    freq.put("ipu", 138);
    freq.put("ugo", 115);
    freq.put("sh ", 334);
    freq.put("ayo", 1230);
    freq.put(" Ka", 309);
    freq.put("ae ", 319);
    freq.put("aye", 245);
    freq.put(" Kh", 65);
    freq.put(" Ki", 173);
    freq.put("aya", 299);
    freq.put(" Ko", 156);
    freq.put(" Kl", 47);
    freq.put("bio\u0301", 291);
    freq.put(" Kr", 75);
    freq.put("Lim", 47);
    freq.put("ul ", 264);
    freq.put("ca ", 14794);
    freq.put("Lin", 136);
    freq.put(" im", 548);
    freq.put("ood", 102);
    freq.put("Ben", 365);
    freq.put("ngr", 238);
    freq.put("Bel", 385);
    freq.put("F", 6264);
    freq.put("ool", 53);
    freq.put("\u064a", 130);
    freq.put("uz ", 427);
    freq.put("ma ", 4262);
    freq.put("ra", 47500);
    freq.put("pia", 402);
    freq.put("mba", 215);
    freq.put("Ber", 553);
    freq.put("Bes", 62);
    freq.put("gni", 197);
    freq.put("Bet", 64);
    freq.put("Rom", 609);
    freq.put("su\u0301", 82);
    freq.put("cay", 268);
    freq.put("ubc", 72);
    freq.put("ibl", 190);
    freq.put("ibn", 40);
    freq.put("ibo", 144);
    freq.put("so\u0301", 139);
    freq.put("so\u0300", 136);
    freq.put("cap", 1502);
    freq.put("flu", 281);
    freq.put("ay ", 211);
    freq.put("cau", 248);
    freq.put("cat", 3216);
    freq.put("n\u0303", 789);
    freq.put("se\u0301", 315);
    freq.put("se\u0300", 69);
    freq.put("can", 4948);
    freq.put("si\u0301", 199);
    freq.put("cal", 1804);
    freq.put("cac", 340);
    freq.put("cab", 314);
    freq.put("sa\u0301", 61);
    freq.put("ula", 1293);
    freq.put("cag", 56);
    freq.put("ibu", 235);
    freq.put("cad", 562);
    freq.put(" on", 583);
    freq.put("ges", 165);
    freq.put(" ol", 51);
    freq.put("idu", 108);
    freq.put("Mil", 244);
    freq.put("Min", 117);
    freq.put(" of", 3427);
    freq.put("idr", 120);
    freq.put("Mic", 206);
    freq.put("uan", 1770);
    freq.put("o ", 75);
    freq.put(" oc", 5124);
    freq.put("Mig", 96);
    freq.put("ipo\u0301", 66);
    freq.put("spl", 78);
    freq.put("spo", 693);
    freq.put("gas", 720);
    freq.put("spa", 3018);
    freq.put("Mis", 69);
    freq.put("Mir", 340);
    freq.put(" or", 1663);
    freq.put(" os", 5952);
    freq.put(" op", 121);
    freq.put("enc\u0327", 430);
    freq.put("Ed ", 70);
    freq.put("ia\u0301n", 1702);
    freq.put("ido", 565);
    freq.put("rvi", 411);
    freq.put("nyi", 95);
    freq.put("gh ", 89);
    freq.put("nyo", 3435);
    freq.put("ayu\u0301", 116);
    freq.put("mel", 507);
    freq.put(" ob", 670);
    freq.put("s ", 90855);
    freq.put("one\u0301", 3235);
    freq.put("eog", 94);
    freq.put("fi\u0301a", 291);
    freq.put("mas", 1463);
    freq.put("mar", 6853);
    freq.put("mau", 44);
    freq.put("din", 616);
    freq.put("Urc", 58);
    freq.put("i\u0301os", 92);
    freq.put("sno", 42);
    freq.put("fed", 134);
    freq.put("enb", 80);
    freq.put(" o ", 28468);
    freq.put("sni", 58);
    freq.put("Uru", 44);
    freq.put("mac", 390);
    freq.put("enc", 4753);
    freq.put("mad", 213);
    freq.put("mag", 134);
    freq.put("rta", 4462);
    freq.put("mai", 134);
    freq.put("neg", 266);
    freq.put("mam", 100);
    freq.put("idd", 66);
    freq.put("man", 3868);
    freq.put("ght", 102);
    freq.put("sz", 61);
    freq.put("sy", 54);
    freq.put("Eda", 108);
    freq.put("ss", 1947);
    freq.put("sr", 79);
    freq.put("sq", 228);
    freq.put("sp", 5348);
    freq.put("sw", 69);
    freq.put("sv", 101);
    freq.put("su", 14097);
    freq.put("st", 36036);
    freq.put("q", 14602);
    freq.put("enh", 83);
    freq.put("si", 17580);
    freq.put("sh", 816);
    freq.put("so", 6479);
    freq.put("sn", 175);
    freq.put("sm", 1643);
    freq.put("Edu", 48);
    freq.put("sc", 6321);
    freq.put("sb", 292);
    freq.put("sa", 8339);
    freq.put("ibo\u0301", 41);
    freq.put("sg", 92);
    freq.put("sf", 297);
    freq.put("se", 12003);
    freq.put("sd", 259);
    freq.put("ei\u0301", 56);
    freq.put("Ru", 549);
    freq.put(" aC", 158);
    freq.put("nno", 92);
    freq.put("Che", 497);
    freq.put("lsa", 112);
    freq.put("tts", 75);
    freq.put("Chi", 767);
    freq.put("Jar", 51);
    freq.put("soc", 286);
    freq.put("Cho", 110);
    freq.put("Jan", 70);
    freq.put("Re", 2929);
    freq.put("Chr", 98);
    freq.put("Jam", 131);
    freq.put("tto", 79);
    freq.put("Ra", 687);
    freq.put("tta", 116);
    freq.put("Ro", 1931);
    freq.put("en\u0303", 206);
    freq.put("Ri", 1399);
    freq.put("eo\u0301", 80);
    freq.put("cof", 52);
    freq.put(" ab", 1016);
    freq.put(" ac", 2837);
    freq.put(" ad", 973);
    freq.put(" ae", 70);
    freq.put(" af", 235);
    freq.put(" ag", 650);
    freq.put(" ai", 177);
    freq.put("sof", 205);
    freq.put(" al", 2449);
    freq.put(" am", 802);
    freq.put(" an", 6430);
    freq.put("gto", 64);
    freq.put("\u03b1", 169);
    freq.put(" aq", 61);
    freq.put(" ar", 5285);
    freq.put(" as", 4436);
    freq.put(" at", 946);
    freq.put("\u0434", 65);
    freq.put(" av", 614);
    freq.put("nsa", 388);
    freq.put("ent", 19699);
    freq.put("Mu\u0301n", 76);
    freq.put("gel", 473);
    freq.put("xem", 129);
    freq.put("coi", 64);
    freq.put("enu", 197);
    freq.put("rli\u0301", 92);
    freq.put("nom", 4566);
    freq.put("non", 142);
    freq.put("env", 137);
    freq.put("reg", 565);
    freq.put("\u0648", 72);
    freq.put("uge", 55);
    freq.put("Kat", 41);
    freq.put("sle", 207);
    freq.put("nob", 131);
    freq.put("sol", 429);
    freq.put("Sha", 58);
    freq.put(" we", 61);
    freq.put("R ", 115);
    freq.put("She", 58);
    freq.put("not", 89);
    freq.put("ng ", 522);
    freq.put("nov", 997);
    freq.put(" us", 125);
    freq.put("nop", 65);
    freq.put("tem", 761);
    freq.put("nor", 1456);
    freq.put("nos", 736);
    freq.put(" a ", 33903);
    freq.put("pes", 448);
    freq.put("rai\u0301", 55);
    freq.put("Na\u0301p", 249);
    freq.put("tti", 104);
    freq.put("did", 81);
    freq.put("sot", 81);
    freq.put("em", 9197);
    freq.put("el", 19178);
    freq.put("eo", 1144);
    freq.put("en", 93499);
    freq.put("ei", 5762);
    freq.put("eh", 152);
    freq.put("ek", 155);
    freq.put("ej", 370);
    freq.put("ee", 482);
    freq.put("ed", 4670);
    freq.put("eg", 5665);
    freq.put("ef", 994);
    freq.put("ea", 2408);
    freq.put("rl ", 72);
    freq.put("ec", 11322);
    freq.put("eb", 3508);
    freq.put("Luc", 146);
    freq.put("ey", 6445);
    freq.put("ex", 1637);
    freq.put("ez", 1432);
    freq.put("eu", 4920);
    freq.put("ft", 72);
    freq.put("ew", 230);
    freq.put("ev", 2707);
    freq.put("eq", 445);
    freq.put("ep", 5798);
    freq.put("es", 36862);
    freq.put("er", 42074);
    freq.put("Ken", 92);
    freq.put("Jor", 54);
    freq.put("Jos", 335);
    freq.put("blu", 41);
    freq.put("eja", 198);
    freq.put("nsu", 361);
    freq.put("Joa", 95);
    freq.put("\u0633", 66);
    freq.put("bli", 1408);
    freq.put("com", 14762);
    freq.put("os ", 25441);
    freq.put("Joh", 274);
    freq.put("bla", 6430);
    freq.put("Jon", 53);
    freq.put("she", 41);
    freq.put("rlo", 224);
    freq.put("sko", 57);
    freq.put("rli", 134);
    freq.put("ide", 1774);
    freq.put("G", 7528);
    freq.put("ory", 64);
    freq.put("rle", 220);
    freq.put("ort", 2810);
    freq.put("oru", 324);
    freq.put("rla", 839);
    freq.put("e ", 149038);
    freq.put("orp", 161);
    freq.put("orq", 101);
    freq.put("orn", 778);
    freq.put("a\u0300s", 90);
    freq.put("orl", 115);
    freq.put("ci ", 68);
    freq.put("rly", 44);
    freq.put("ork", 566);
    freq.put("ori", 3242);
    freq.put("orf", 120);
    freq.put("fem", 90);
    freq.put("ord", 1194);
    freq.put("ore", 783);
    freq.put("orb", 171);
    freq.put("orc", 390);
    freq.put("ora", 2008);
    freq.put("ert", 3943);
    freq.put("mos", 648);
    freq.put("maz", 73);
    freq.put("\u0438\u0447", 60);
    freq.put("ca\u0301n", 112);
    freq.put("usk", 97);
    freq.put("sho", 45);
    freq.put(" ce", 943);
    freq.put("mo\u0301 ", 46);
    freq.put("gu\u0301n", 43);
    freq.put("ri\u0301s", 312);
    freq.put("e\u0300s ", 220);
    freq.put("xi", 5714);
    freq.put("onn", 399);
    freq.put("xo", 1208);
    freq.put("xm", 56);
    freq.put("xc", 69);
    freq.put("zad", 59);
    freq.put("xa", 1261);
    freq.put("onf", 246);
    freq.put("ane\u0301", 98);
    freq.put("ond", 1478);
    freq.put("xe", 1372);
    freq.put("onz", 129);
    freq.put("Dor", 53);
    freq.put("ony", 278);
    freq.put(" Af", 231);
    freq.put("so\u0301n", 50);
    freq.put("Dos", 138);
    freq.put("ons", 3093);
    freq.put("xp", 240);
    freq.put("onq", 106);
    freq.put("onv", 115);
    freq.put("zas", 154);
    freq.put("xt", 359);
    freq.put("xu", 93);
    freq.put("iam", 215);
    freq.put("ial", 6627);
    freq.put("ian", 2111);
    freq.put("iad", 189);
    freq.put("iag", 113);
    freq.put("yin", 59);
    freq.put("iac", 505);
    freq.put("ovo", 42);
    freq.put("yit", 255);
    freq.put("ule", 147);
    freq.put("lar", 1828);
    freq.put("iau", 82);
    freq.put("iat", 539);
    freq.put("Dou", 55);
    freq.put("ias", 1288);
    freq.put("iar", 803);
    freq.put("hud", 1823);
    freq.put("hue", 1138);
    freq.put(" Zo", 51);
    freq.put("hug", 321);
    freq.put(" Zi", 59);
    freq.put("hua", 226);
    freq.put("xil", 66);
    freq.put(" Ze", 94);
    freq.put("hum", 282);
    freq.put("x ", 772);
    freq.put("dic", 4356);
    freq.put(" Za", 1740);
    freq.put("lhe", 92);
    freq.put("za ", 2695);
    freq.put("ebi", 129);
    freq.put("ush", 233);
    freq.put("suc", 192);
    freq.put("hur", 185);
    freq.put("hus", 252);
    freq.put(" Zu", 77);
    freq.put(" ya", 136);
    freq.put("rbo", 341);
    freq.put("ma\u0301n", 1305);
    freq.put("jo ", 179);
    freq.put("rze", 61);
    freq.put("rza", 479);
    freq.put("rzo", 759);
    freq.put("ero\u0301", 42);
    freq.put("Am", 430);
    freq.put(" Le\u0301", 44);
    freq.put("war", 116);
    freq.put("\u0646 ", 61);
    freq.put("Alf", 219);
    freq.put("r", 234141);
    freq.put("nie", 336);
    freq.put("Ald", 69);
    freq.put("and", 4107);
    freq.put("ane", 625);
    freq.put("a\u0301ll", 83);
    freq.put("ang", 1039);
    freq.put("pra", 148);
    freq.put("ana", 6098);
    freq.put("sam", 123);
    freq.put("anc", 10977);
    freq.put("anl", 160);
    freq.put("Alb", 564);
    freq.put("ann", 351);
    freq.put("ano", 1852);
    freq.put("anh", 151);
    freq.put("ani", 3885);
    freq.put("et\u0327", 45);
    freq.put("ank", 148);
    freq.put("ant", 15027);
    freq.put("anu", 472);
    freq.put("anq", 163);
    freq.put("ans", 1324);
    freq.put("sas", 492);
    freq.put("xo\u0301", 86);
    freq.put("sap", 102);
    freq.put("ri\u0301n", 122);
    freq.put("any", 6533);
    freq.put("anz", 412);
    freq.put("sat", 386);
    freq.put("Do", 659);
    freq.put("Phi", 78);
    freq.put("rmi", 794);
    freq.put(" Ke", 199);
    freq.put("Di", 657);
    freq.put("vei", 63);
    freq.put("De", 985);
    freq.put("lti", 157);
    freq.put("zon", 343);
    freq.put("Da", 680);
    freq.put("ndi\u0301", 93);
    freq.put("ax ", 55);
    freq.put("2", 4897);
    freq.put("\u0435", 199);
    freq.put("u\u0308en", 106);
    freq.put("mot", 101);
    freq.put("Du", 470);
    freq.put("Dr", 118);
    freq.put("ts ", 4329);
    freq.put("I\u0301xa", 93);
    freq.put(" Ca", 8053);
    freq.put("an ", 6113);
    freq.put("lo\u0301 ", 140);
    freq.put("unt", 1291);
    freq.put("mb ", 46);
    freq.put("egl", 633);
    freq.put("lur", 85);
    freq.put("uya", 6536);
    freq.put("te\u0301s", 77);
    freq.put(" ye", 24958);
    freq.put("uye", 389);
    freq.put("net", 586);
    freq.put("i\u0301n ", 1619);
    freq.put("ta\u0301n", 2438);
    freq.put("tte", 197);
    freq.put("rar", 802);
    freq.put("uyo", 1635);
    freq.put(" a\u0301 ", 52);
    freq.put(" Le", 3156);
    freq.put("Ucr", 41);
    freq.put("kal", 59);
    freq.put("oxe", 41);
    freq.put(" Lo", 1959);
    freq.put(" Ll", 306);
    freq.put("ti\u0301 ", 44);
    freq.put("D ", 277);
    freq.put(" Lu", 751);
    freq.put("o\u0300", 886);
    freq.put("lli", 819);
    freq.put("neu", 3333);
    freq.put("axi", 147);
    freq.put("axo", 137);
    freq.put(" Ly", 43);
    freq.put("\u1100\u1161", 45);
    freq.put("set", 627);
    freq.put("fes", 224);
    freq.put("Wei", 53);
    freq.put("Wes", 94);
    freq.put(" Cr", 536);
    freq.put("ge ", 357);
    freq.put("nle", 54);
    freq.put("li\u0301 ", 42);
    freq.put("xis", 225);
    freq.put("lay", 70);
    freq.put("dy ", 91);
    freq.put("ss ", 107);
    freq.put("lig", 423);
    freq.put("XI ", 57);
    freq.put("We", 251);
    freq.put("cou", 62);
    freq.put("tia\u0301", 58);
    freq.put("Wa", 266);
    freq.put("Wo", 126);
    freq.put("iti", 1102);
    freq.put("lub", 390);
    freq.put("Wi", 414);
    freq.put("Wh", 41);
    freq.put("sou", 70);
    freq.put("\u0430", 282);
    freq.put("Wu", 48);
    freq.put("\u03b5", 64);
    freq.put("\u0447 ", 61);
    freq.put("det\u0327", 45);
    freq.put("ver", 1295);
    freq.put("zo\u0301n", 80);
    freq.put(" ps", 89);
    freq.put(" pr", 13974);
    freq.put(" pu", 1468);
    freq.put("ssu", 66);
    freq.put("H", 3089);
    freq.put(" px", 42);
    freq.put(" pa", 7968);
    freq.put("uta", 240);
    freq.put("ssi", 161);
    freq.put("xiu", 87);
    freq.put(" pe", 2382);
    freq.put("sse", 691);
    freq.put("dit", 1042);
    freq.put(" pi", 915);
    freq.put(" po", 12254);
    freq.put("gen", 256);
    freq.put(" pl", 740);
    freq.put("cid", 704);
    freq.put("E\u0301t", 123);
    freq.put("E\u0301v", 65);
    freq.put("iqu", 443);
    freq.put("o\u0301", 30243);
    freq.put("lun", 337);
    freq.put("rks", 54);
    freq.put("uth", 76);
    freq.put("upo", 429);
    freq.put("uti", 206);
    freq.put("lle\u0300", 44);
    freq.put("rmu", 56);
    freq.put(" \u0627\u0644", 82);
    freq.put("Ai\u0301", 55);
    freq.put(" si\u0301", 53);
    freq.put("lfr", 59);
    freq.put("cin", 2607);
    freq.put("kel", 50);
    freq.put("cim", 107);
    freq.put("rme", 392);
    freq.put("tu ", 83);
    freq.put("cil", 415);
    freq.put("j ", 55);
    freq.put("ffe", 52);
    freq.put("cis", 357);
    freq.put("ni\u0301a", 237);
    freq.put("be\u0300r", 62);
    freq.put("cir", 339);
    freq.put("mol", 200);
    freq.put("xa ", 634);
    freq.put("ou ", 222);
    freq.put("uve", 116);
    freq.put("pte", 85);
    freq.put("cip", 8439);
    freq.put("civ", 67);
    freq.put("fir", 81);
    freq.put("lio\u0301", 99);
    freq.put("tus", 72);
    freq.put("ciu", 1650);
    freq.put("ai\u0301n", 66);
    freq.put("ju", 130);
    freq.put("tur", 1993);
    freq.put("cit", 4565);
    freq.put("tut", 233);
    freq.put("utz", 40);
    freq.put("ue ", 10127);
    freq.put("jo", 403);
    freq.put("tul", 64);
    freq.put("ji", 76);
    freq.put("tun", 41);
    freq.put("ciz", 58);
    freq.put("je", 160);
    freq.put("ai\u0301s", 1262);
    freq.put("tuc", 165);
    freq.put("tud", 253);
    freq.put("ja", 752);
    freq.put("tug", 422);
    freq.put(" be", 950);
    freq.put("ros", 1359);
    freq.put("z", 13501);
    freq.put(" ba", 1763);
    freq.put("fit", 61);
    freq.put("tui", 52);
    freq.put("ago\u0301", 1389);
    freq.put(" bo", 292);
    freq.put(" bi", 684);
    freq.put("P ", 71);
    freq.put(" bu", 158);
    freq.put("\u03b1 ", 52);
    freq.put("s", 206494);
    freq.put("rki", 43);
    freq.put("odr", 74);
    freq.put(" br", 776);
    freq.put("go\u0301n", 1401);
    freq.put("tum", 52);
    freq.put("ys", 168);
    freq.put("pot", 83);
    freq.put("por", 5544);
    freq.put("dir", 869);
    freq.put("pop", 238);
    freq.put("e\u0300th", 158);
    freq.put("pon", 437);
    freq.put("pol", 1645);
    freq.put("imo", 645);
    freq.put("tua", 6572);
    freq.put("nsk", 43);
    freq.put("n\u0303os", 42);
    freq.put("pod", 154);
    freq.put("poe", 320);
    freq.put("pob", 6027);
    freq.put("poc", 176);
    freq.put("pan\u0303", 78);
    freq.put("fic", 8082);
    freq.put("Bur", 806);
    freq.put("Bus", 74);
    freq.put(" Me\u0301", 58);
    freq.put("ei ", 675);
    freq.put("Bun", 61);
    freq.put("Bul", 86);
    freq.put("AS ", 76);
    freq.put("imu", 52);
    freq.put("ov ", 53);
    freq.put("pai\u0301", 658);
    freq.put("Bud", 62);
    freq.put("Bue", 80);
    freq.put("E\u0301", 262);
    freq.put("fie", 199);
    freq.put("lle", 1785);
    freq.put("odu", 636);
    freq.put("mud", 113);
    freq.put("vue", 107);
    freq.put("clu", 743);
    freq.put("ik ", 59);
    freq.put("fas", 57);
    freq.put("aid", 83);
    freq.put("dwa", 45);
    freq.put("eis", 231);
    freq.put("eir", 354);
    freq.put("eit", 740);
    freq.put("re\u0300", 89);
    freq.put("cq ", 43);
    freq.put("so\u0300s", 122);
    freq.put("eic", 131);
    freq.put("eid", 281);
    freq.put("eig", 91);
    freq.put(" bl", 117);
    freq.put("uny", 294);
    freq.put("i\u0308s", 55);
    freq.put("eil", 138);
    freq.put("ein", 1974);
    freq.put("yi", 439);
    freq.put("uia", 191);
    freq.put("iva", 1324);
    freq.put("e\u0301ti", 41);
    freq.put("ivo", 1136);
    freq.put("ivi", 1220);
    freq.put("oi ", 141);
    freq.put("ced", 326);
    freq.put("Bar", 1038);
    freq.put("Bas", 270);
    freq.put("pap", 112);
    freq.put(" Me", 3058);
    freq.put("par", 10175);
    freq.put("pas", 460);
    freq.put("pat", 307);
    freq.put(" Ma", 5257);
    freq.put(" Mc", 66);
    freq.put("chi", 7691);
    freq.put("uru", 86);
    freq.put(" Mo", 2562);
    freq.put(" Mi", 1402);
    freq.put("o\u0301s ", 153);
    freq.put(" Mu", 1272);
    freq.put("pac", 352);
    freq.put("pad", 63);
    freq.put("pag", 64);
    freq.put("I ", 1360);
    freq.put("Sil", 128);
    freq.put("pal", 1063);
    freq.put("pan", 3073);
    freq.put("oin", 160);
    freq.put("nac", 947);
    freq.put("I", 5567);
    freq.put("ete", 572);
    freq.put("yd", 68);
    freq.put("XX ", 114);
    freq.put("it ", 973);
    freq.put("ux ", 137);
    freq.put("oix", 1425);
    freq.put(" gr", 1637);
    freq.put("oit", 63);
    freq.put("ois", 211);
    freq.put("oir", 170);
    freq.put("nag", 81);
    freq.put("rec", 6366);
    freq.put("ha\u0301n", 48);
    freq.put("Ip", 108);
    freq.put("Is", 1033);
    freq.put("Ir", 296);
    freq.put("It", 588);
    freq.put("eto", 512);
    freq.put("pa ", 846);
    freq.put("Im", 754);
    freq.put("Il", 297);
    freq.put("In", 710);
    freq.put("cce", 203);
    freq.put("uie", 269);
    freq.put("Ib", 231);
    freq.put("cca", 49);
    freq.put("Id", 48);
    freq.put("Ig", 114);
    freq.put("Bac", 68);
    freq.put("Lob", 53);
    freq.put("a\u0301c", 66);
    freq.put("a\u0301b", 47);
    freq.put(" qu", 10550);
    freq.put("am ", 354);
    freq.put("ps ", 76);
    freq.put("vid", 633);
    freq.put("a\u0301l", 141);
    freq.put("a\u0301n", 10781);
    freq.put("a\u0301p", 259);
    freq.put("a\u0301s", 1227);
    freq.put("a\u0301r", 205);
    freq.put("a\u0301t", 58);
    freq.put("mpo", 1935);
    freq.put("uid", 133);
    freq.put("rgo", 1114);
    freq.put("nam", 297);
    freq.put("Bal", 491);
    freq.put("rig", 256);
    freq.put("Log", 143);
    freq.put("u\u0301n ", 198);
    freq.put("tim", 251);
    freq.put("Hes", 57);
    freq.put("flo", 94);
    freq.put("nap", 162);
    freq.put("Eri", 53);
    freq.put("cc", 5812);
    freq.put(" ge", 55);
    freq.put("uel", 1803);
    freq.put("uig", 53);
    freq.put("ff ", 44);
    freq.put("ors", 909);
    freq.put("oa ", 142);
    freq.put("ami", 2709);
    freq.put("a\u0301 ", 406);
    freq.put(" Fu\u0301", 72);
    freq.put("amm", 73);
    freq.put("ndo\u0301", 55);
    freq.put("amo", 865);
    freq.put("ama", 1728);
    freq.put("mor", 989);
    freq.put("amb", 576);
    freq.put("ame", 4595);
    freq.put("oct", 667);
    freq.put("mou", 58);
    freq.put("amf", 47);
    freq.put("naz", 58);
    freq.put("ubl", 925);
    freq.put("mon", 1273);
    freq.put("ixo\u0301", 72);
    freq.put("moc", 196);
    freq.put("amp", 1732);
    freq.put("le\u0301s", 609);
    freq.put("amu", 134);
    freq.put("tif", 310);
    freq.put("mod", 219);
    freq.put("rpa", 54);
    freq.put("oi\u0301", 58);
    freq.put("tig", 1952);
    freq.put("Pil", 51);
    freq.put("Pin", 194);
    freq.put("u\u0301ni", 50);
    freq.put("Pic", 78);
    freq.put("Pie", 204);
    freq.put("uet", 490);
    freq.put("tia", 471);
    freq.put("aco\u0301", 65);
    freq.put("uei", 224);
    freq.put("lau", 337);
    freq.put("t", 216624);
    freq.put("Ebr", 275);
    freq.put("ucc", 373);
    freq.put("Pir", 3266);
    freq.put("Pis", 83);
    freq.put("Pit", 44);
    freq.put("oni\u0301", 41);
    freq.put("Neg", 61);
    freq.put("yu\u0301 ", 114);
    freq.put("cs", 190);
    freq.put(" Ce\u0301", 64);
    freq.put("ezi", 98);
    freq.put("New", 87);
    freq.put("uic", 106);
    freq.put("Neu", 41);
    freq.put("Ner", 42);
    freq.put("cq", 106);
    freq.put("Med", 234);
    freq.put(" ch", 6428);
    freq.put("ac ", 612);
    freq.put("zi\u0301n", 104);
    freq.put(" co", 25285);
    freq.put(" cl", 828);
    freq.put("Mel", 100);
    freq.put("Men", 238);
    freq.put("nfr", 79);
    freq.put("ubo", 95);
    freq.put("o ", 118703);
    freq.put("Met", 54);
    freq.put("Ohi", 45);
    freq.put("rpo", 272);
    freq.put("Mes", 113);
    freq.put("Mer", 200);
    freq.put(" cr", 940);
    freq.put("dda", 65);
    freq.put("um ", 208);
    freq.put("Mey", 1833);
    freq.put("Mex", 142);
    freq.put(" cu", 1036);
    freq.put("ami\u0301", 58);
    freq.put("\u0447", 80);
    freq.put("ama\u0301", 261);
    freq.put("\u02c8", 99);
    freq.put("mpi", 508);
    freq.put("icl", 297);
    freq.put("Za", 1741);
    freq.put("acc", 247);
    freq.put("amo\u0301", 65);
    freq.put("Dre", 57);
    freq.put("oo", 407);
    freq.put("on", 36685);
    freq.put("om", 23722);
    freq.put("ol", 10871);
    freq.put("ok", 161);
    freq.put("oj", 139);
    freq.put("oi", 2459);
    freq.put("oh", 450);
    freq.put("og", 2423);
    freq.put("of", 4127);
    freq.put("oe", 616);
    freq.put("od", 4405);
    freq.put("oc", 10213);
    freq.put("ob", 10136);
    freq.put("oa", 667);
    freq.put("acl", 40);
    freq.put("acs", 115);
    freq.put("acr", 135);
    freq.put("acq", 78);
    freq.put("oz", 1792);
    freq.put("oy", 492);
    freq.put("ox", 224);
    freq.put("ow", 337);
    freq.put("ov", 10545);
    freq.put("ou", 3052);
    freq.put("ot", 2800);
    freq.put("os", 31113);
    freq.put("or", 29437);
    freq.put("oq", 218);
    freq.put("op", 2703);
    freq.put("Ni", 338);
    freq.put("ys ", 57);
    freq.put("Adr", 43);
    freq.put("ac\u0327", 51);
    freq.put("No", 1516);
    freq.put("uil", 266);
    freq.put("Na", 1458);
    freq.put("ai\u0301", 1342);
    freq.put("Ne", 437);
    freq.put("ai\u0308", 66);
    freq.put("ngh", 51);
    freq.put("an\u0303", 291);
    freq.put("uio\u0301", 159);
    freq.put("yas", 560);
    freq.put("orm", 1749);
    freq.put("Ado", 91);
    freq.put("Nu", 796);
    freq.put("per", 6227);
    freq.put("het", 220);
    freq.put("loc", 1507);
    freq.put("igo\u0300", 47);
    freq.put("her", 745);
    freq.put("Jus", 45);
    freq.put("alq", 109);
    freq.put("orr", 1698);
    freq.put("Mur", 389);
    freq.put("lon", 1637);
    freq.put("hez", 41);
    freq.put("lom", 283);
    freq.put("ode", 444);
    freq.put("los", 2434);
    freq.put("\u03b3", 43);
    freq.put("\u0432", 147);
    freq.put("lov", 143);
    freq.put("hea", 69);
    freq.put("heb", 242);
    freq.put("hec", 353);
    freq.put("hel", 358);
    freq.put("hem", 117);
    freq.put("hen", 1459);
    freq.put("heo", 251);
    freq.put(" I\u0301x", 93);
    freq.put("hei", 72);
    freq.put("uin", 360);
    freq.put("\u0646", 111);
    freq.put("N ", 108);
    freq.put("J", 2444);
    freq.put("cia\u0301", 588);
    freq.put("nke", 42);
    freq.put("yac", 58);
    freq.put("yad", 248);
    freq.put(" su", 13017);
    freq.put("yag", 43);
    freq.put("mpr", 198);
    freq.put("Un ", 378);
    freq.put("lo ", 6451);
    freq.put("dif", 510);
    freq.put("lca", 313);
    freq.put("svi", 51);
    freq.put("dve", 42);
    freq.put(" si", 7787);
    freq.put("he ", 928);
    freq.put("Avi", 56);
    freq.put("Ave", 58);
    freq.put("mps", 47);
    freq.put("aa", 113);
    freq.put("ac", 18793);
    freq.put("ab", 11063);
    freq.put("ae", 821);
    freq.put("ad", 8656);
    freq.put("ag", 9213);
    freq.put("af", 2379);
    freq.put("Hon", 180);
    freq.put("ah", 422);
    freq.put("Hol", 97);
    freq.put("aj", 395);
    freq.put("am", 13303);
    freq.put("al", 37899);
    freq.put("ao", 175);
    freq.put("an", 60138);
    freq.put("aq", 326);
    freq.put("Nu\u0300", 59);
    freq.put("as", 32668);
    freq.put("ar", 48825);
    freq.put("Hor", 78);
    freq.put("Hos", 42);
    freq.put("aw", 197);
    freq.put("av", 3185);
    freq.put("ay", 2308);
    freq.put("ax", 419);
    freq.put("afi\u0301", 261);
    freq.put("az", 1496);
    freq.put("uis", 370);
    freq.put("Aq", 804);
    freq.put("aC", 163);
    freq.put(" sa", 1314);
    freq.put("igr", 84);
    freq.put("thu", 114);
    freq.put("Lag", 94);
    freq.put("Lab", 132);
    freq.put("Lac", 69);
    freq.put("\u0631", 91);
    freq.put("noi", 1471);
    freq.put("ige", 58);
    freq.put("u\u0301s ", 123);
    freq.put("Laz", 44);
    freq.put("ota", 773);
    freq.put("Lat", 44);
    freq.put("Au", 1363);
    freq.put("Ovi", 40);
    freq.put("yos", 1713);
    freq.put("yor", 588);
    freq.put("Lar", 146);
    freq.put("At", 949);
    freq.put("a ", 189570);
    freq.put("lga", 211);
    freq.put("sto", 2359);
    freq.put("gol", 195);
    freq.put("\u043e\u0432", 67);
    freq.put(" zo", 210);
    freq.put("ote", 332);
    freq.put("gon", 3334);
    freq.put("uga", 2225);
    freq.put("ton", 3336);
    freq.put("uiu", 45);
    freq.put("sio", 389);
    freq.put("s\u0327", 47);
    freq.put(" ga", 614);
    freq.put("sec", 228);
    freq.put("ldi", 63);
    freq.put("Az", 169);
    freq.put("at ", 8853);
    freq.put("US ", 58);
    freq.put("ica\u0301", 71);
    freq.put("Bru", 135);
    freq.put("zqu", 48);
    freq.put("La ", 2467);
    freq.put("otz", 224);
    freq.put("yo ", 3771);
    freq.put("Bro", 165);
    freq.put("u", 160116);
    freq.put("Bri", 276);
    freq.put("ig ", 130);
    freq.put("uit", 1942);
    freq.put("Bre", 219);
    freq.put(" Jr", 59);
    freq.put("Bra", 269);
    freq.put("on ", 9278);
    freq.put("pto", 155);
    freq.put("Fis", 88);
    freq.put("all", 2888);
    freq.put("alm", 4203);
    freq.put("Van", 48);
    freq.put("sch", 197);
    freq.put("Val", 1946);
    freq.put(" c", 53853);
    freq.put("alf", 222);
    freq.put("alg", 57);
    freq.put("ald", 658);
    freq.put("ale", 2737);
    freq.put("alb", 415);
    freq.put("gu", 5563);
    freq.put("pta", 96);
    freq.put("ala", 3055);
    freq.put("ni\u0301n", 54);
    freq.put("a\u0301rb", 69);
    freq.put("gt", 79);
    freq.put("alz", 65);
    freq.put("Fig", 108);
    freq.put("Fie", 45);
    freq.put("Var", 71);
    freq.put("gs", 124);
    freq.put("alt", 1006);
    freq.put("alu", 654);
    freq.put("Fin", 74);
    freq.put("als", 2354);
    freq.put("Fil", 103);
    freq.put("Gir", 65);
    freq.put("hy ", 54);
    freq.put("smo", 1140);
    freq.put("ree", 87);
    freq.put("tz", 1335);
    freq.put("edd", 40);
    freq.put("tx", 92);
    freq.put("ty", 165);
    freq.put("tw", 45);
    freq.put("tt", 792);
    freq.put("tu", 10787);
    freq.put("tr", 16094);
    freq.put("ts", 4585);
    freq.put("tp", 51);
    freq.put("osl", 56);
    freq.put("tn", 174);
    freq.put("to", 49861);
    freq.put("tl", 1081);
    freq.put("tm", 126);
    freq.put("uiv", 83);
    freq.put("po ", 1377);
    freq.put("th", 1241);
    freq.put("ti", 24986);
    freq.put("tf", 100);
    freq.put("\u0438", 262);
    freq.put("te", 23226);
    freq.put("tb", 466);
    freq.put("tc", 162);
    freq.put("ta", 49236);
    freq.put("edi", 1178);
    freq.put("ium", 78);
    freq.put("smi", 54);
    freq.put("mpa", 409);
    freq.put("far", 136);
    freq.put("LA ", 58);
    freq.put("mpl", 1206);
    freq.put("ajo", 179);
    freq.put("iud", 1817);
    freq.put("al ", 11240);
    freq.put("za\u0301", 80);
    freq.put("yon", 591);
    freq.put("fai", 59);
    freq.put("fan", 320);
    freq.put("llu", 110);
    freq.put("fal", 168);
    freq.put("aja", 109);
    freq.put(" ri\u0301", 719);
    freq.put("fac", 309);
    freq.put("ius", 271);
    freq.put("iur", 45);
    freq.put("sme", 59);
    freq.put("fad", 52);
    freq.put("fae", 49);
    freq.put(" Ni", 336);
    freq.put("gg", 120);
    freq.put("pre", 3562);
    freq.put("is ", 1549);
    freq.put(" No", 1504);
    freq.put(" Na", 1457);
    freq.put(" Ne", 437);
    freq.put("ge", 1559);
    freq.put("aje", 50);
    freq.put("gd", 66);
    freq.put("sma", 361);
    freq.put("eix", 920);
    freq.put("gor", 1373);
    freq.put(" Nu", 796);
    freq.put("rbu", 85);
    freq.put("t ", 23983);
    freq.put("odi\u0301", 1685);
    freq.put("ass", 494);
    freq.put("ali\u0301", 68);
    freq.put("tel", 3865);
    freq.put("ga", 9445);
    freq.put("re\u0301n", 65);
    freq.put("ale\u0301", 48);
    freq.put("tea", 206);
    freq.put("teb", 98);
    freq.put("edu", 87);
    freq.put("ted", 70);
    freq.put(" Ab", 290);
    freq.put("nbu", 46);
    freq.put("ala\u0301", 1638);
    freq.put("tex", 101);
    freq.put("Gio", 49);
    freq.put(" Ac", 390);
    freq.put("oro", 1408);
    freq.put("rui", 184);
    freq.put("tep", 75);
    freq.put("ter", 4859);
    freq.put("tes", 1306);
    freq.put("tet", 109);
    freq.put("gm", 75);
    freq.put("nbe", 48);
    freq.put("c\u0327a ", 138);
    freq.put("aba", 1272);
    freq.put("sue", 210);
    freq.put("Gil", 43);
    freq.put("tu\u0301", 55);
    freq.put("abe", 873);
    freq.put("sua", 62);
    freq.put("abi", 3680);
    freq.put("sum", 63);
    freq.put(" Ag", 239);
    freq.put("abl", 933);
    freq.put("to\u0301", 3270);
    freq.put("sui", 69);
    freq.put("abo", 367);
    freq.put("mbl", 71);
    freq.put("abr", 1214);
    freq.put("ti\u0301", 1477);
    freq.put("sus", 166);
    freq.put("abu", 101);
    freq.put("te\u0300", 189);
    freq.put("te\u0301", 212);
    freq.put("xon", 140);
    freq.put("zo\u0301", 127);
    freq.put("suy", 8064);
    freq.put("ta\u0301", 2483);
    freq.put(" ru", 519);
    freq.put("su\u0301s", 77);
    freq.put("Nom", 360);
    freq.put("te ", 7101);
    freq.put("K", 1244);
    freq.put(" Te\u0300", 61);
    freq.put("u\u0300g", 59);
    freq.put(" re", 9633);
    freq.put(" ra", 569);
    freq.put("pub", 839);
    freq.put("mul", 270);
    freq.put("buy", 48);
    freq.put(" ri", 229);
    freq.put("s\u030c", 45);
    freq.put("a\u0300", 575);
    freq.put(" Aq", 804);
    freq.put(" Na\u0301", 254);
    freq.put("icr", 45);
    freq.put("qu\u0308e", 96);
    freq.put(" Ar", 3860);
    freq.put(" Nu\u0300", 59);
    freq.put(" As", 1091);
    freq.put("tiz", 57);
    freq.put("sig", 443);
    freq.put("ung", 103);
    freq.put("re\u0301s", 144);
    freq.put(" a ", 48);
    freq.put("umu", 43);
    freq.put("eda", 712);
    freq.put("vic", 421);
    freq.put("Nog", 123);
    freq.put(" Av", 152);
    freq.put("Aug", 97);
    freq.put("ive", 525);
    freq.put("Tor", 554);
    freq.put("Tos", 86);
    freq.put("fig", 50);
    freq.put("vin", 8416);
    freq.put("Aul", 197);
    freq.put("vil", 743);
    freq.put("Tou", 103);
    freq.put("vir", 277);
    freq.put("ask", 71);
    freq.put("Aus", 575);
    freq.put("Aur", 142);
    freq.put("viv", 217);
    freq.put("Aut", 173);
    freq.put("Tol", 692);
    freq.put("Uni", 1303);
    freq.put("S ", 375);
    freq.put("vul", 60);
    freq.put("asi", 1104);
    freq.put("Tie", 516);
    freq.put("eya", 1305);
    freq.put("eye", 329);
    freq.put("n\u0303as", 48);
    freq.put("mma", 94);
    freq.put("ull", 355);
    freq.put("ved", 70);
    freq.put("eyo", 2607);
    freq.put(" d ", 41259);
    freq.put("ejo", 101);
    freq.put("pur", 65);
    freq.put("\u03b7", 68);
    freq.put("de ", 80790);
    freq.put("iz ", 822);
    freq.put("Sy", 56);
    freq.put("fu\u0301", 249);
    freq.put("Sp", 125);
    freq.put("Su", 913);
    freq.put("St", 450);
    freq.put("Si", 1208);
    freq.put("Sh", 202);
    freq.put("So", 1654);
    freq.put("Sc", 255);
    freq.put("Sa", 4961);
    freq.put("Loi\u0301", 45);
    freq.put("tru", 524);
    freq.put("fi\u0301", 317);
    freq.put("Se", 3318);
    freq.put("luv", 44);
    freq.put("a\u0301", 13401);
    freq.put("ey ", 440);
    freq.put("dez", 184);
    freq.put("ui\u0301n", 41);
    freq.put(" di", 6008);
    freq.put("ngt", 66);
    freq.put("Int", 142);
    freq.put(" de", 93040);
    freq.put("ata", 7591);
    freq.put("det", 240);
    freq.put("deu", 41);
    freq.put(" da", 436);
    freq.put("Ins", 100);
    freq.put("bur", 411);
    freq.put("dei", 236);
    freq.put("uxe", 40);
    freq.put("del", 1335);
    freq.put("dem", 337);
    freq.put("den", 7502);
    freq.put("v", 28687);
    freq.put("Ind", 230);
    freq.put("dea", 184);
    freq.put("Inf", 101);
    freq.put("dec", 377);
    freq.put("ded", 106);
    freq.put(" dr", 358);
    freq.put("def", 199);
    freq.put("avi", 1192);
    freq.put("vie\u0300", 54);
    freq.put("vie\u0301", 152);
    freq.put("pro", 10201);
    freq.put("go ", 3253);
    freq.put("f ", 486);
    freq.put(" Fi", 496);
    freq.put("pue\u0301", 579);
    freq.put("lal", 104);
    freq.put("ath", 153);
    freq.put("e\u0301 ", 635);
    freq.put("pai", 206);
    freq.put("ist", 6571);
    freq.put("ob ", 41);
    freq.put("lh ", 50);
    freq.put("rgi", 58);
    freq.put("zar", 348);
    freq.put("slo", 145);
    freq.put("isi", 1148);
    freq.put("ava", 1125);
    freq.put("oyo", 79);
    freq.put("eyo\u0301", 1631);
    freq.put("ish", 214);
    freq.put("\u0438\u0306", 58);
    freq.put("Viv", 66);
    freq.put("nye", 371);
    freq.put("oya", 232);
    freq.put("i\u0301to", 354);
    freq.put("fr", 7629);
    freq.put("Don", 139);
    freq.put("fu", 1368);
    freq.put("Dom", 136);
    freq.put("pri", 1181);
    freq.put("uau", 59);
    freq.put("\u03bf\u0301", 42);
    freq.put("rmo", 194);
    freq.put("fa", 2850);
    freq.put("Se\u0301", 45);
    freq.put("fe", 3740);
    freq.put("ff", 208);
    freq.put("fg", 41);
    freq.put("Sa\u0303", 53);
    freq.put("fi", 10107);
    freq.put("xer", 290);
    freq.put("fl", 536);
    freq.put("fo", 3130);
    freq.put("a", 500037);
    freq.put(" di\u0301", 123);
    freq.put("xte", 148);
    freq.put("lha", 188);
    freq.put("lho", 61);
    freq.put("egr", 354);
    freq.put("cs ", 170);
    freq.put("egu", 1397);
    freq.put("ne ", 2575);
    freq.put("egi", 69);
    freq.put("ego", 1470);
    freq.put("ds ", 102);
    freq.put("o\u0308", 123);
    freq.put("ega", 1451);
    freq.put("ege", 41);
    freq.put("oy ", 78);
    freq.put("Oci", 122);
    freq.put("ito", 14065);
    freq.put("uez", 111);
    freq.put("ith", 88);
    freq.put("ce ", 491);
    freq.put("Oca", 40);
    freq.put("y ", 30607);
    freq.put("Occ", 315);
    freq.put("ite", 2513);
    freq.put("lah", 42);
    freq.put("itc", 43);
    freq.put("ita", 13238);
    freq.put("uvi", 103);
    freq.put("itz", 160);
    freq.put("ity", 56);
    freq.put("uva", 115);
    freq.put("itt", 116);
    freq.put("itu", 6260);
    freq.put("itr", 81);
    freq.put("ve ", 292);
    freq.put("pid", 90);
    freq.put(" On", 167);
    freq.put(" Ol", 435);
    freq.put(" Om", 55);
    freq.put(" Oh", 48);
    freq.put("gu\u0308i", 134);
    freq.put(" Od", 84);
    freq.put(" Ob", 95);
    freq.put(" Oc", 530);
    freq.put("nto", 7609);
    freq.put("pci", 102);
    freq.put(" Oz", 48);
    freq.put(" Ov", 54);
    freq.put("oar", 74);
    freq.put(" Ot", 107);
    freq.put(" Ou", 62);
    freq.put(" Or", 1187);
    freq.put(" Os", 1274);
    freq.put(" Op", 71);
    freq.put("Bav", 98);
    freq.put("aso\u0300", 111);
    freq.put("Bat", 90);
    freq.put("Bau", 42);
    freq.put("ym", 83);
    freq.put("yl", 123);
    freq.put("yo", 9039);
    freq.put("yn", 174);
    freq.put("ya", 13178);
    freq.put("cen", 946);
    freq.put("re\u0300s", 47);
    freq.put("cel", 1113);
    freq.put("ye", 26389);
    freq.put("L", 12511);
    freq.put("\u0432\u0438\u0447", 54);
    freq.put("Bay", 89);
    freq.put("Bad", 97);
    freq.put("cet", 349);
    freq.put("ces", 1530);
    freq.put("Era", 60);
    freq.put("dig", 188);
    freq.put("cep", 171);
    freq.put("Ban", 328);
    freq.put("Ern", 54);
    freq.put("yr", 129);
    freq.put("yu", 88);
    freq.put("yt", 84);
    freq.put("Bai", 742);
    freq.put("Raf", 117);
    freq.put("ifu", 46);
    freq.put("Rad", 50);
    freq.put("Rab", 66);
    freq.put("gue", 1452);
    freq.put("nvi", 113);
    freq.put("Ran", 121);
    freq.put("Ram", 97);
    freq.put(" O ", 3000);
    freq.put("ife", 480);
    freq.put("exe", 134);
    freq.put("val", 1231);
    freq.put("ifa", 124);
    freq.put("die", 409);
    freq.put("ifo", 507);
    freq.put("ifi", 975);
    freq.put(" A ", 6341);
    freq.put("usc", 110);
    freq.put("Enc", 143);
    freq.put("Mus", 93);
    freq.put("Eng", 50);
    freq.put("tre", 3631);
    freq.put("ua\u0301n", 43);
    freq.put("ita\u0301", 2129);
    freq.put("Mue", 57);
    freq.put("vam", 114);
    freq.put("Mug", 163);
    freq.put("as ", 19306);
    freq.put("Ent", 56);
    freq.put(" so", 2523);
    freq.put(" sc", 327);
    freq.put("uda", 1999);
    freq.put("Mun", 416);
    freq.put(" se", 5716);
    freq.put("iza", 1143);
    freq.put("uos", 46);
    freq.put("izc", 159);
    freq.put("ize", 43);
    freq.put("gur", 246);
    freq.put("izi", 124);
    freq.put("E ", 158);
    freq.put("izo", 170);
    freq.put("dag", 63);
    freq.put("eor", 324);
    freq.put("bui", 89);
    freq.put("ui\u0301 ", 43);
    freq.put("En ", 645);
    freq.put("asq", 49);
    freq.put("asp", 165);
    freq.put(" Ad", 284);
    freq.put("diz", 245);
    freq.put("asu", 67);
    freq.put("ast", 7538);
    freq.put("ya\u0301", 156);
    freq.put(" Ai", 211);
    freq.put(" Al", 5280);
    freq.put(" Am", 424);
    freq.put(" An", 2142);
    freq.put("ior", 777);
    freq.put("asc", 1409);
    freq.put("Una", 265);
    freq.put("asa", 1087);
    freq.put("yu\u0301", 116);
    freq.put(" At", 949);
    freq.put(" Au", 1361);
    freq.put("ase", 427);
    freq.put("rgu", 256);
    freq.put("bun", 55);
    freq.put("Bai\u0308", 53);
    freq.put("yo\u0301", 1722);
    freq.put("ash", 77);
    freq.put("aso", 509);
    freq.put("div", 679);
    freq.put("asm", 49);
    freq.put("sbo", 69);
    freq.put("Em", 290);
    freq.put("El", 695);
    freq.put("En", 989);
    freq.put("Ei", 68);
    freq.put("Ed", 409);
    freq.put("Ea", 51);
    freq.put("Ec", 152);
    freq.put("Eb", 284);
    freq.put("nfi", 62);
    freq.put("sti\u0301", 156);
    freq.put("pos", 1131);
    freq.put("Ex", 340);
    freq.put("w", 1593);
    freq.put("Ez", 49);
    freq.put("Eu", 622);
    freq.put("Et", 88);
    freq.put("Ev", 68);
    freq.put(" ef", 58);
    freq.put("Es", 4887);
    freq.put("Er", 278);
    freq.put("le ", 1482);
    freq.put("Fra", 1775);
    freq.put("Fre", 184);
    freq.put("go\u0300r", 69);
    freq.put("Cle", 56);
    freq.put("Fri", 136);
    freq.put("Fro", 85);
    freq.put("Cla", 205);
    freq.put("Imp", 731);
    freq.put("ude", 796);
    freq.put("zo", 1662);
    freq.put("bul", 93);
    freq.put("nc ", 42);
    freq.put("Clu", 178);
    freq.put("osc", 233);
    freq.put("zi", 554);
    freq.put(" el", 836);
    freq.put(" em", 791);
    freq.put(" en", 45737);
    freq.put("co\u0301n", 94);
    freq.put("st ", 507);
    freq.put(" ei", 79);
    freq.put(" ed", 270);
    freq.put("X ", 302);
    freq.put("dt ", 44);
    freq.put(" ec", 252);
    freq.put("imb", 156);
    freq.put("nz ", 101);
    freq.put(" ex", 831);
    freq.put(" Ya", 59);
    freq.put(" et", 307);
    freq.put(" eu", 203);
    freq.put(" ev", 123);
    freq.put("\u043a", 142);
    freq.put(" ep", 103);
    freq.put(" eq", 225);
    freq.put(" er", 161);
    freq.put(" es", 12368);
    freq.put("omu", 6923);
    freq.put("ede\u0301", 50);
    freq.put("dal", 1070);
    freq.put("ncr", 95);
    freq.put("ncs", 41);
    freq.put("I\u0301", 100);
    freq.put("za", 5335);
    freq.put("nch", 1989);
    freq.put("nci", 13450);
    freq.put("ofa", 81);
    freq.put("ncl", 579);
    freq.put("rra", 5371);
    freq.put("scu", 413);
    freq.put("nco", 784);
    freq.put("oja", 86);
    freq.put("nca", 2343);
    freq.put("vi\u0301a", 77);
    freq.put("ney", 90);
    freq.put("ste", 7013);
    freq.put("stf", 50);
    freq.put("b", 46837);
    freq.put("sta", 9411);
    freq.put("bag", 336);
    freq.put("ko ", 90);
    freq.put("Xa", 108);
    freq.put(" e ", 354);
    freq.put("co\u0301 ", 168);
    freq.put("stu", 608);
    freq.put("je ", 44);
    freq.put("Rei", 1060);
    freq.put("le\u0300s", 68);
    freq.put("le\u0300r", 124);
    freq.put("str", 6362);
    freq.put("uey", 113);
    freq.put("Nue", 683);
    freq.put("Gol", 63);
    freq.put("Gon", 55);
    freq.put("sce", 133);
    freq.put("zz", 103);
    freq.put("sti", 8938);
    freq.put("God", 44);
    freq.put("Rem", 46);
    freq.put("elo", 1006);
    freq.put("ofo", 167);
    freq.put("lhe\u0301", 44);
    freq.put("Rec", 256);
    freq.put("rti\u0301", 184);
    freq.put("i\u0301na", 74);
    freq.put("Gor", 90);
    freq.put("lid", 1116);
    freq.put("ofr", 53);
    freq.put("lif", 574);
    freq.put("k ", 1459);
    freq.put("lia", 2670);
    freq.put("ex ", 75);
    freq.put("lic", 2196);
    freq.put("lil", 59);
    freq.put("Nic", 135);
    freq.put("lin", 1102);
    freq.put("lio", 1048);
    freq.put("in\u0303a", 49);
    freq.put("efu", 50);
    freq.put(" Yu", 72);
    freq.put("lit", 2372);
    freq.put(" lo", 4749);
    freq.put("liv", 118);
    freq.put("2 ", 4882);
    freq.put("Kin", 58);
    freq.put("lir", 71);
    freq.put("efo", 67);
    freq.put("\u0639", 41);
    freq.put("cci", 5499);
    freq.put("lix", 43);
    freq.put("efe", 402);
    freq.put("liz", 384);
    freq.put("rin", 1137);
    freq.put("Ate", 44);
    freq.put("udo", 192);
    freq.put("pec", 832);
    freq.put("Isr", 43);
    freq.put("Atl", 768);
    freq.put("M", 14032);
    freq.put("kan", 40);
    freq.put("Ath", 42);
    freq.put("Ist", 200);
    freq.put("Tho", 94);
    freq.put("kar", 110);
    freq.put("zos", 77);
    freq.put("Isl", 555);
    freq.put("spu", 61);
    freq.put("esn", 47);
    freq.put("Isa", 135);
    freq.put("dai", 51);
    freq.put("ka", 550);
    freq.put("a\u0302", 100);
    freq.put("li ", 326);
    freq.put("exc", 56);
    freq.put("ke", 399);
    freq.put("exa", 137);
    freq.put("exo", 63);
    freq.put("ki", 580);
    freq.put("kh", 127);
    freq.put("ko", 322);
    freq.put("ste\u0301", 58);
    freq.put("km", 5396);
    freq.put("kl", 108);
    freq.put("ks", 168);
    freq.put("kr", 45);
    freq.put("ext", 325);
    freq.put("uai", 86);
    freq.put("ku", 119);
    freq.put("sto\u0301", 58);
    freq.put("ef ", 40);
    freq.put("ky", 77);
    freq.put("une", 139);
    freq.put("rte", 4811);
    freq.put("xed", 66);
    freq.put("aro\u0301", 66);
    freq.put("re ", 7388);
    freq.put("Ham", 67);
    freq.put("Han", 91);
    freq.put("rto", 2506);
    freq.put("Had", 44);
    freq.put("rth", 164);
    freq.put(" Be\u0301", 72);
    freq.put("hi ", 92);
    freq.put("ara\u0301", 49);
    freq.put("rts", 44);
    freq.put("rtr", 69);
    freq.put("Har", 170);
    freq.put("u\u0301tb", 317);
    freq.put("Hau", 83);
    freq.put("ugu", 646);
    freq.put("rtz", 99);
    freq.put("bfa", 45);
    freq.put("iez", 72);
    freq.put("scr", 1111);
    freq.put("Ju", 422);
    freq.put("ies", 690);
    freq.put("ier", 2261);
    freq.put("ieu", 89);
    freq.put("iet", 455);
    freq.put("Jr", 59);
    freq.put("iev", 42);
    freq.put("Ope", 55);
    freq.put("Jo", 919);
    freq.put("iem", 1602);
    freq.put("Ji", 54);
    freq.put("ien", 5235);
    freq.put("Je", 311);
    freq.put("Ja", 569);
    freq.put("ieg", 1134);
    freq.put("hip", 217);
    freq.put("ela", 1464);
    freq.put("hir", 613);
    freq.put("his", 710);
    freq.put("hit", 396);
    freq.put("rt ", 839);
    freq.put("ose", 613);
    freq.put("uec", 249);
    freq.put(" A\u0301n", 69);
    freq.put("spi", 211);
    freq.put("e\u0300re", 155);
    freq.put("hib", 145);
    freq.put("Xi", 132);
    freq.put("hid", 163);
    freq.put("hie", 94);
    freq.put("hig", 61);
    freq.put("hil", 241);
    freq.put("him", 149);
    freq.put("hin", 1554);
    freq.put("hio", 409);
    freq.put("noa", 44);
    freq.put("a\u0303", 102);
    freq.put("cru", 146);
    freq.put("a\u0301s ", 1198);
    freq.put("oxi", 91);
    freq.put("rfe", 48);
    freq.put("cre", 669);
    freq.put("x", 11341);
    freq.put(" Pe\u0301", 62);
    freq.put("cri", 1318);
    freq.put("J ", 56);
    freq.put("elg", 80);
    freq.put("arp", 123);
    freq.put("arq", 324);
    freq.put("arr", 4340);
    freq.put("ars", 729);
    freq.put("art", 10745);
    freq.put("aru", 81);
    freq.put("For", 357);
    freq.put("sep", 285);
    freq.put("arx", 55);
    freq.put("ary", 98);
    freq.put("arz", 796);
    freq.put(" Bi", 1877);
    freq.put("rte\u0300", 42);
    freq.put("sey", 101);
    freq.put("sex", 85);
    freq.put(" Bu", 1316);
    freq.put("ara", 7157);
    freq.put("arb", 1022);
    freq.put("arc", 6367);
    freq.put("ard", 1884);
    freq.put("a\u0301po", 250);
    freq.put("sea", 92);
    freq.put("arg", 457);
    freq.put("ari", 3225);
    freq.put("Fon", 159);
    freq.put("ark", 146);
    freq.put("arl", 816);
    freq.put("arm", 309);
    freq.put("arn", 763);
    freq.put("aro", 1482);
    freq.put("mo ", 3815);
    freq.put("mia", 389);
    freq.put("Ye ", 991);
    freq.put("oza", 1310);
    freq.put("use", 320);
    freq.put("chu", 4144);
    freq.put("Ple", 45);
    freq.put("atr", 1247);
    freq.put("Pla", 459);
    freq.put("ozo", 77);
    freq.put("ms ", 48);
    freq.put("\u03ba", 64);
    freq.put("yat", 477);
    freq.put("be\u0301n", 225);
    freq.put("hio\u0301", 4220);
    freq.put("oss", 155);
    freq.put("lel", 48);
    freq.put("lem", 1561);
    freq.put("ar ", 6113);
    freq.put("ika", 72);
    freq.put("len", 1629);
    freq.put("ike", 47);
    freq.put("se ", 5048);
    freq.put("tiv", 2043);
    freq.put("adr", 581);
    freq.put("iki", 75);
    freq.put("evo", 337);
    freq.put("iko", 59);
    freq.put("fga", 41);
    freq.put("ot ", 423);
    freq.put(" Pr", 1734);
    freq.put("c", 184692);
    freq.put("ueb", 404);
    freq.put(" Pu", 601);
    freq.put("rna\u0301", 86);
    freq.put("fos", 84);
    freq.put("rma", 2089);
    freq.put("Far", 69);
    freq.put(" Pa", 3520);
    freq.put("mi ", 66);
    freq.put(" Pe", 1600);
    freq.put("igu", 556);
    freq.put("ø", 41);
    freq.put(" Pi", 4008);
    freq.put("Yer", 168);
    freq.put(" Ap", 96);
    freq.put(" Pl", 536);
    freq.put("oph", 55);
    freq.put("Wal", 86);
    freq.put("rpr", 167);
    freq.put("tuy", 78);
    freq.put("rio\u0301", 226);
    freq.put("esu\u0301", 73);
    freq.put("od ", 84);
    freq.put("ka ", 210);
    freq.put("nat", 1290);
    freq.put("ceg", 45);
    freq.put("Ira\u0301", 41);
    freq.put("War", 42);
    freq.put(" t ", 73);
    freq.put("pr", 15141);
    freq.put("ps", 257);
    freq.put("pp", 201);
    freq.put("dul", 73);
    freq.put("pt", 487);
    freq.put("pu", 3631);
    freq.put("dua", 107);
    freq.put("px", 43);
    freq.put("duc", 808);
    freq.put("xat", 41);
    freq.put(" o ", 69);
    freq.put("lde", 545);
    freq.put("pc", 112);
    freq.put("pa", 17607);
    freq.put("nau", 204);
    freq.put("xan", 151);
    freq.put("pe", 9762);
    freq.put("duq", 92);
    freq.put("ph", 314);
    freq.put("pi", 11513);
    freq.put("po", 17316);
    freq.put("pl", 2368);
    freq.put("nri", 113);
    freq.put("Fal", 65);
    freq.put("u\u0300go", 59);
    freq.put("\u0438\u0306 ", 42);
    freq.put(" tu", 267);
    freq.put("gat", 585);
    freq.put("Emi", 77);
    freq.put(" tr", 2669);
    freq.put("nre", 41);
    freq.put("N", 5019);
    freq.put(" to", 940);
    freq.put("gan", 993);
    freq.put("gam", 80);
    freq.put("gal", 634);
    freq.put("o\u0300rr", 49);
    freq.put("Emp", 168);
    freq.put(" ti", 1270);
    freq.put(" th", 178);
    freq.put(" te", 2399);
    freq.put("gad", 214);
    freq.put("gac", 180);
    freq.put("gab", 64);
    freq.put(" ta", 2947);
    freq.put("lba", 848);
    freq.put("fut", 63);
    freq.put("adm", 420);
    freq.put("iya", 43);
    freq.put("fus", 124);
    freq.put("du ", 102);
    freq.put("Oli", 252);
    freq.put(" fu\u0301", 245);
    freq.put("p ", 402);
    freq.put("fue", 546);
    freq.put("mal", 552);
    freq.put(" a\u0301r", 62);
    freq.put("u\u0300", 89);
    freq.put("fuo", 41);
    freq.put("nda", 2934);
    freq.put("gue\u0301", 212);
    freq.put("vog", 50);
    freq.put("riz", 654);
    freq.put("voc", 147);
    freq.put("riv", 286);
    freq.put("rit", 5633);
    freq.put("raq", 58);
    freq.put("rir", 118);
    freq.put("ris", 1199);
    freq.put("Tir", 42);
    freq.put("riq", 78);
    freq.put("ne\u0301s", 3547);
    freq.put("Tim", 56);
    freq.put("ril", 1019);
    freq.put("rim", 1306);
    freq.put("Irl", 118);
    freq.put("rik", 79);
    freq.put("vor", 132);
    freq.put("vos", 269);
    freq.put("rif", 80);
    freq.put("Ira", 43);
    freq.put("rid", 579);
    freq.put("rie", 2036);
    freq.put("rib", 574);
    freq.put("ric", 2717);
    freq.put("sai", 44);
    freq.put("ria", 3749);
    freq.put("\u0421", 41);
    freq.put("po\u0301", 230);
    freq.put("ewi", 52);
    freq.put("tir", 249);
    freq.put("yal", 259);
    freq.put("ceb", 79);
    freq.put("fu\u0301t", 245);
    freq.put("gs ", 50);
    freq.put("ia\u0300 ", 88);
    freq.put(" du", 304);
    freq.put("pe\u0300", 62);
    freq.put("mno", 74);
    freq.put("ohn", 220);
    freq.put("pi\u0301", 43);
    freq.put("Cop", 81);
    freq.put("Cos", 287);
    freq.put("Cor", 738);
    freq.put("Cou", 52);
    freq.put("ti\u0301a", 161);
    freq.put("dge", 81);
    freq.put("no\u0301 ", 165);
    freq.put("Ill", 119);
    freq.put("cea", 126);
    freq.put("mov", 182);
    freq.put(" ti\u0301", 352);
    freq.put("Cob", 41);
    freq.put("an\u0303a", 108);
    freq.put("uto", 2752);
    freq.put("Cof", 46);
    freq.put("an\u0303o", 118);
    freq.put("pse", 75);
    freq.put("Com", 767);
    freq.put("Col", 268);
    freq.put("ri ", 510);
    freq.put("Con", 936);
    freq.put("t\u0327", 70);
    freq.put("Sob", 421);
    freq.put(" fu", 1130);
    freq.put("lib", 283);
    freq.put("si ", 476);
    freq.put("ew ", 79);
    freq.put("Som", 57);
    freq.put("Sol", 223);
    freq.put("Son", 105);
    freq.put(" fa", 1854);
    freq.put("Sor", 351);
    freq.put("Sou", 61);
    freq.put("Sot", 54);
    freq.put("Sov", 80);
    freq.put("y", 82928);
    freq.put(" fl", 166);
    freq.put(" fo", 1674);
    freq.put("tza", 114);
    freq.put("wig", 45);
    freq.put("lda", 117);
    freq.put("Exe", 241);
    freq.put(" Ay", 81);
    freq.put("osf", 51);
    freq.put("ldo", 91);
    freq.put("bi ", 255);
    freq.put("O ", 3098);
    freq.put("ldr", 41);
    freq.put("wic", 75);
    freq.put("tin", 1092);
    freq.put("cut", 113);
    freq.put("cus", 151);
    freq.put("cur", 292);
    freq.put("cup", 186);
    freq.put(" Az", 169);
    freq.put("mog", 40);
    freq.put("na\u0301n", 92);
    freq.put("yod", 1669);
    freq.put("\u043e", 215);
    freq.put("cue", 498);
    freq.put("cuc", 89);
    freq.put("cub", 164);
    freq.put("cua", 224);
    freq.put("\u03b9", 93);
    freq.put("cun", 111);
    freq.put("cum", 166);
    freq.put("cul", 744);
    freq.put("ee ", 110);
    freq.put("cui", 42);
    freq.put("elv", 192);
    freq.put("bin", 181);
    freq.put("On", 170);
    freq.put("Din", 113);
    freq.put("Dio", 78);
    freq.put("ba\u0301n", 64);
    freq.put("ba\u0301", 102);
    freq.put("Oh", 48);
    freq.put("urd", 85);
    freq.put("Die", 65);
    freq.put("bid", 52);
    freq.put("Od", 84);
    freq.put("be\u0300", 98);
    freq.put("Dia", 43);
    freq.put("Air", 59);
    freq.put("Ain", 41);
    freq.put("biz", 69);
    freq.put("Oz", 48);
    freq.put("Diz", 56);
    freq.put("bo\u0301", 122);
    freq.put("Ov", 54);
    freq.put("Div", 60);
    freq.put("Ot", 107);
    freq.put("gr", 4212);
    freq.put("Or", 1187);
    freq.put("Op", 71);
    freq.put("uy ", 68);
    freq.put("d", 198344);
    freq.put("lma", 308);
    freq.put("A\u0301n", 71);
    freq.put("rg ", 290);
    freq.put("een", 85);
    freq.put("Kha", 40);
    freq.put("b ", 2959);
    freq.put("ru ", 71);
    freq.put("rot", 408);
    freq.put("ohe", 67);
    freq.put("ija", 46);
    freq.put("ld ", 212);
    freq.put("c\u0327a", 209);
    freq.put("cif", 135);
    freq.put("c\u0327o", 75);
    freq.put("oe ", 44);
    freq.put(" Du", 469);
    freq.put("zz ", 43);
    freq.put("Rey", 105);
    freq.put(" Qu", 327);
    freq.put("pez", 143);
    freq.put("pet", 128);
    freq.put("peu", 90);
    freq.put("liq", 95);
    freq.put("ak", 399);
    freq.put(" Dr", 118);
    freq.put("pel", 266);
    freq.put("pen", 661);
    freq.put("pei", 72);
    freq.put("ped", 144);
    freq.put("Os ", 984);
    freq.put("pea", 157);
    freq.put("id ", 208);
    freq.put("km2", 4894);
    freq.put("bd", 79);
    freq.put("be", 4754);
    freq.put("bf", 48);
    freq.put("aC ", 158);
    freq.put("run", 160);
    freq.put("ba", 8653);
    freq.put("bb", 79);
    freq.put("bc", 225);
    freq.put("bl", 8980);
    freq.put("ruc", 376);
    freq.put("Bor", 282);
    freq.put("Bos", 103);
    freq.put("Bou", 109);
    freq.put("O", 7507);
    freq.put("rue", 1064);
    freq.put("bt", 83);
    freq.put("bu", 1135);
    freq.put("ruy", 43);
    freq.put("Bol", 188);
    freq.put("Bon", 127);
    freq.put("c\u0327 ", 366);
    freq.put("rur", 59);
    freq.put("rus", 648);
    freq.put("rup", 477);
    freq.put("Boc", 41);
    freq.put("by", 52);
    freq.put("rut", 44);
    freq.put("fec", 203);
    freq.put("Roi", 95);
    freq.put("ndo\u0300", 191);
    freq.put("\u03c2 ", 149);
    freq.put("a\u0308", 54);
    freq.put("Ron", 93);
    freq.put("nce\u0301", 6029);
    freq.put("Rob", 204);
    freq.put("Roc", 80);
    freq.put("Rod", 121);
    freq.put("Roy", 73);
    freq.put("Llo", 122);
    freq.put("Oso", 45);
    freq.put("idi", 602);
    freq.put("idg", 67);
    freq.put("Lla", 76);
    freq.put("Ros", 411);
    freq.put("pe ", 499);
    freq.put("Rou", 41);
    freq.put("ida", 7766);
    freq.put("nsi", 3321);
    freq.put("wn ", 47);
    freq.put("Eli", 66);
    freq.put("nso", 356);
    freq.put("oha", 82);
    freq.put("chl", 46);
    freq.put(" C ", 63);
    freq.put("nsc", 53);
    freq.put("nse", 1949);
    freq.put(" ur", 107);
    freq.put("Ele", 55);
    freq.put(" un", 30714);
    freq.put("Te\u0300", 61);
    freq.put("nsp", 80);
    freq.put(" ue", 407);
    freq.put("cho", 415);
    freq.put("nst", 724);
    freq.put("The", 314);
    freq.put(" ub", 66);
    freq.put("nzi", 60);
    freq.put(" E\u0301t", 123);
    freq.put("ut ", 319);
    freq.put("ixi", 4792);
    freq.put("sad", 68);
    freq.put("ixo", 921);
    freq.put("xpl", 51);
    freq.put("Nob", 162);
    freq.put("u\u0301ne", 45);
    freq.put("ixe", 850);
    freq.put("go\u0301 ", 119);
    freq.put("zie", 76);
    freq.put("equ\u0308", 84);
    freq.put("ezu", 123);
    freq.put("cht", 85);
    freq.put("gri\u0301", 111);
    freq.put("u ", 7771);
    freq.put("hri", 107);
    freq.put("aqu", 292);
    freq.put(" Ch", 3168);
    freq.put(" Ci", 1040);
    freq.put(" Co", 3415);
    freq.put(" Cl", 508);
    freq.put("n\u0303a ", 201);
    freq.put("ns ", 3297);
    freq.put("El ", 405);
    freq.put(" Ku", 88);
    freq.put("Ult", 91);
    freq.put(" Ce", 1515);
    freq.put("sde", 183);
    freq.put(" Cy", 45);
    freq.put("sta\u0301", 292);
    freq.put("Flo", 152);
    freq.put("zio", 145);
    freq.put("Fla", 78);
    freq.put(" u ", 3972);
    freq.put("zan", 466);
    freq.put(" Cu", 873);
    freq.put("cic", 176);
    freq.put("cib", 852);
    freq.put("cia", 18130);
    freq.put("nya\u0301", 130);
    freq.put("uy", 8987);
    freq.put("ux", 238);
    freq.put("cie", 3721);
    freq.put("uz", 858);
    freq.put("exi", 568);
    freq.put("ut", 4110);
    freq.put("ix ", 335);
    freq.put("uv", 360);
    freq.put("uq", 149);
    freq.put("up", 3752);
    freq.put("us", 8828);
    freq.put("ur", 7842);
    freq.put("um", 1883);
    freq.put("ul", 4535);
    freq.put("uo", 167);
    freq.put("un", 51530);
    freq.put("ui", 5582);
    freq.put("uh", 51);
    freq.put("uk", 95);
    freq.put("uj", 105);
    freq.put("ue", 24260);
    freq.put("ud", 6151);
    freq.put("ug", 3258);
    freq.put("uf", 231);
    freq.put("ua", 11407);
    freq.put("la\u0301n", 4159);
    freq.put("uc", 2944);
    freq.put("ub", 3284);
    freq.put("ap", 3319);
    freq.put("exm", 46);
    freq.put("tib", 196);
    freq.put("ste\u0300", 110);
    freq.put("Tu", 387);
    freq.put("Tr", 784);
    freq.put("Gua", 636);
    freq.put("cer", 583);
    freq.put("di\u0301a", 1990);
    freq.put("To", 1748);
    freq.put("sul", 509);
    freq.put("Th", 491);
    freq.put("Ti", 748);
    freq.put("zal", 125);
    freq.put("Te", 1399);
    freq.put("Ta", 1245);
    freq.put("nab", 73);
    freq.put("A ", 6623);
    freq.put("Mas", 242);
    freq.put("Mar", 1797);
    freq.put("Mau", 231);
    freq.put("Mat", 250);
    freq.put("nad", 422);
    freq.put("nae", 55);
    freq.put("May", 164);
    freq.put("Max", 51);
    freq.put("nai", 3351);
    freq.put("nan", 568);
    freq.put("nal", 2141);
    freq.put("eza", 368);
    freq.put("nar", 1025);
    freq.put("nas", 1528);
    freq.put("Mac", 135);
    freq.put("gre", 209);
    freq.put("nav", 217);
    freq.put("Mad", 503);
    freq.put("Mag", 110);
    freq.put("gra", 2556);
    freq.put("Mai", 84);
    freq.put("\u03b8", 57);
    freq.put(" gl", 81);
    freq.put("o", 77);
    freq.put("Mam", 40);
    freq.put("Mal", 289);
    freq.put("Man", 1211);
    freq.put("rds", 65);
    freq.put("Bea", 178);
    freq.put("exp", 204);
    freq.put("ie\u0301s", 139);
    freq.put(" Ca\u0301", 129);
    freq.put("mat", 2795);
    freq.put(" ci", 4380);
    freq.put("ly ", 179);
    freq.put("au", 6954);
    freq.put("ie\u0301n", 1647);
    freq.put("lpe", 216);
    freq.put("T ", 55);
    freq.put("ago", 5671);
    freq.put("agn", 198);
    freq.put("Ac", 412);
    freq.put("Ab", 293);
    freq.put("e", 418034);
    freq.put("Ad", 285);
    freq.put("Ag", 240);
    freq.put("Af", 232);
    freq.put("Ai", 212);
    freq.put("age", 155);
    freq.put("un\u0303", 102);
    freq.put("Al", 5289);
    freq.put("aga", 473);
    freq.put("An", 2149);
    freq.put("ui\u0301", 262);
    freq.put("Ap", 98);
    freq.put("As", 1097);
    freq.put("Ar", 3874);
    freq.put("ue\u0301", 1015);
    freq.put("ue\u0300", 92);
    freq.put("Av", 152);
    freq.put("Ay", 82);
    freq.put("agu", 831);
    freq.put("u\u0301", 1261);
    freq.put("ua\u0301", 93);
    freq.put("agr", 176);
    freq.put(" b", 4777);
    freq.put("zi\u0301", 110);
    freq.put("Giu", 47);
    freq.put(" a", 64432);
    freq.put(" f", 15333);
    freq.put(" g", 3703);
    freq.put(" d", 142714);
    freq.put(" e", 62754);
    freq.put(" j", 137);
    freq.put(" k", 5618);
    freq.put(" h", 9312);
    freq.put(" i", 7953);
    freq.put(" n", 9906);
    freq.put(" o", 46236);
    freq.put(" l", 24121);
    freq.put(" m", 23977);
    freq.put(" r", 12559);
    freq.put(" s", 31762);
    freq.put(" p", 39916);
    freq.put(" q", 10572);
    freq.put(" v", 4587);
    freq.put(" w", 158);
    freq.put(" t", 11133);
    freq.put(" u", 35543);
    freq.put(" z", 803);
    freq.put("gn", 724);
    freq.put(" x", 86);
    freq.put(" y", 53553);
    freq.put("\u043a\u0430", 41);
    freq.put("gi", 469);
    freq.put("gh", 348);
    freq.put(" B", 11404);
    freq.put(" C", 19641);
    freq.put(" A", 24795);
    freq.put(" F", 6210);
    freq.put(" G", 7491);
    freq.put(" D", 3992);
    freq.put(" E", 9455);
    freq.put(" J", 2437);
    freq.put(" K", 1235);
    freq.put(" H", 3071);
    freq.put(" I", 5555);
    freq.put(" N", 5003);
    freq.put(" O", 7480);
    freq.put(" L", 12489);
    freq.put(" M", 14016);
    freq.put(" R", 7849);
    freq.put(" S", 13749);
    freq.put(" P", 13942);
    freq.put(" Q", 385);
    freq.put(" V", 6094);
    freq.put(" W", 1227);
    freq.put(" T", 7101);
    freq.put(" U", 4207);
    freq.put(" Z", 2101);
    freq.put("mil", 953);
    freq.put(" X", 966);
    freq.put(" Y", 2045);
    freq.put("\u03bd", 114);
    freq.put("ne\u0301 ", 50);
    freq.put("Nor", 638);
    freq.put("esb", 43);
    freq.put("ch ", 604);
    freq.put("ed ", 199);
    freq.put("caz", 64);
    freq.put("Xil", 74);
    freq.put("Pen\u0303", 79);
    freq.put("sar", 1166);
    freq.put("P", 13954);
    freq.put(" Wh", 40);
    freq.put("ubf", 47);
    freq.put("g ", 1073);
    freq.put("pun", 204);
    freq.put(" Wi", 413);
    freq.put("Azu", 58);
    freq.put("tri", 4717);
    freq.put("evi", 643);
    freq.put("esl", 255);
    freq.put("mp ", 61);
    freq.put("tro", 3498);
    freq.put("u\u0308is", 117);
    freq.put("opt", 64);
    freq.put("eva", 1219);
    freq.put("us ", 4557);
    freq.put("No ", 53);
    freq.put("eve", 388);
    freq.put("lk ", 57);
    freq.put("cas", 4851);
    freq.put("se\u0301 ", 258);
    freq.put("rda\u0301", 123);
    freq.put("min", 1797);
    freq.put("ibi", 1047);
    freq.put("car", 2739);
    freq.put("rdi\u0301", 75);
    freq.put("ry ", 412);
    freq.put("tmo", 48);
    freq.put("rae", 83);
    freq.put("rde\u0300", 52);
    freq.put("rro", 1014);
    freq.put("zm", 43);
    freq.put(" a\u0301", 138);
    freq.put("go\u0301", 1532);
    freq.put("go\u0300", 79);
    freq.put("rri", 1235);
    freq.put("zk", 61);
    freq.put("ze", 662);
    freq.put("rre", 2401);
    freq.put("gu\u0308", 326);
    freq.put("gu\u0301", 46);
    freq.put("zb", 53);
    freq.put("zc", 370);
    freq.put("odi", 479);
    freq.put("Nov", 50);
    freq.put("doe", 44);
    freq.put("ult", 655);
    freq.put("go", 11703);
    freq.put("odo", 671);
    freq.put("zt", 78);
    freq.put("zu", 406);
    freq.put("rru", 212);
    freq.put("ulu", 41);
    freq.put("Bla", 163);
    freq.put("zq", 48);
    freq.put("ues", 1507);
    freq.put("uer", 4945);
    freq.put("re\u0301 ", 45);
    freq.put(" Re", 2927);
    freq.put(" A\u0300", 43);
    freq.put(" A\u0301", 127);
    freq.put("cqu", 62);
    freq.put("Ort", 62);
    freq.put(" E\u0301", 259);
    freq.put("fat", 64);
    freq.put("cai", 191);
    freq.put(" I\u0301", 100);
    freq.put("Oro", 63);
    freq.put("uli", 893);
    freq.put("rd ", 524);
    freq.put("Ori", 680);
    freq.put("Org", 56);
    freq.put("Ord", 119);
    freq.put("ulo", 359);
    freq.put("lea", 191);
    freq.put("leb", 181);
    freq.put("lec", 686);
    freq.put("led", 346);
    freq.put("cam", 688);
    freq.put("zab", 60);
    freq.put("obe", 460);
    freq.put(" a", 48);
    freq.put("got", 66);
    freq.put("lej", 60);
    freq.put("ulm", 116);
    freq.put("z ", 3529);
    freq.put("ock", 200);
    freq.put("olo", 2074);
    freq.put("leo", 90);
    freq.put("fla", 55);
    freq.put("ler", 899);
    freq.put("les", 1591);
    freq.put("let", 670);
    freq.put("leu", 75);
    freq.put("lev", 257);
    freq.put("ulc", 55);
    freq.put(" o", 71);
    freq.put("ley", 747);
    freq.put("lez", 140);
    freq.put("ibr", 375);
    freq.put("ocl", 96);
    freq.put("rdu", 65);
    freq.put("ctu", 1573);
    freq.put("A\u0301ng", 58);
    freq.put("zac", 289);
    freq.put("nc\u0327o", 60);
    freq.put("ctr", 587);
    freq.put("fle", 62);
    freq.put("rde", 1540);
    freq.put("ulg", 112);
    freq.put("gl", 1957);
    freq.put("cte", 242);
    freq.put("rda", 881);
    freq.put("cta", 350);
    freq.put("rdo", 870);
    freq.put("cto", 2549);
    freq.put("rdi", 439);
    freq.put("cti", 1087);
    freq.put(" Do", 649);
    freq.put("za\u0301n", 49);
    freq.put("iro\u0301", 43);
    freq.put("Ver", 197);
    freq.put("gov", 132);
    freq.put(" Di", 655);
    freq.put("apr", 117);
    freq.put("win", 65);
    freq.put(" De", 984);
    freq.put("apt", 99);
    freq.put("apu", 137);
    freq.put("obe\u0301", 220);
    freq.put("Veg", 102);
    freq.put("ran", 12090);
    freq.put("api", 1469);
    freq.put("wis", 40);
    freq.put("apo", 393);
    freq.put("apl", 89);
    freq.put("Ven", 264);
    freq.put("tfa", 44);
    freq.put("Vel", 47);
    freq.put("apa", 550);
    freq.put("Nu\u0300g", 59);
    freq.put("ape", 296);
    freq.put("sio\u0301", 969);
    freq.put("Hue", 159);
    freq.put("Fr", 2222);
    freq.put("feb", 1076);
    freq.put("Fu", 667);
    freq.put("usa", 376);
    freq.put("fen", 310);
    freq.put("Hum", 43);
    freq.put("fel", 119);
    freq.put("ao ", 68);
    freq.put(" vi\u0301", 46);
    freq.put("usi", 1046);
    freq.put("fei", 204);
    freq.put("Fa", 903);
    freq.put("usu", 133);
    freq.put("iej", 52);
    freq.put("fer", 1148);
    freq.put("Fe", 747);
    freq.put("voz", 67);
    freq.put("apo\u0301", 59);
    freq.put("zin", 46);
    freq.put("Fi", 498);
    freq.put("Fl", 289);
    freq.put("spr", 52);
    freq.put("Fo", 713);
    freq.put("Gub", 94);
    freq.put("zh", 42);
    freq.put("Gue", 449);
    freq.put("Mie", 115);
    freq.put("Gui", 272);
    freq.put("due", 204);
    freq.put("aca", 1187);
    freq.put(" D ", 255);
    freq.put("ria\u0301", 116);
    freq.put("sra", 56);
    freq.put("mbi", 310);
    freq.put("ira\u0301", 76);
    freq.put("px ", 43);
    freq.put("yo\u0301n", 1632);
    freq.put(" Ru", 549);
    freq.put("ace", 581);
    freq.put("fe ", 106);
    freq.put("f", 30904);
    freq.put("km ", 480);
    freq.put("ied", 470);
    freq.put("F ", 41);
    freq.put("ack", 101);
    freq.put(" Ra", 686);
    freq.put("zi ", 55);
    freq.put("enn", 286);
    freq.put(" Ro", 1930);
    freq.put(" Ri", 1399);
    freq.put("aci", 10341);
    freq.put("oz ", 271);
    freq.put("tat", 3988);
    freq.put("tau", 237);
    freq.put("tav", 96);
    freq.put("ach", 1441);
    freq.put("tap", 45);
    freq.put("ie\u0300l", 73);
    freq.put("tar", 2116);
    freq.put("do", 9223);
    freq.put("ie\u0300r", 107);
    freq.put("aco", 595);
    freq.put("tax", 48);
    freq.put("ez ", 631);
    freq.put(" ca", 13929);
    freq.put("tad", 424);
    freq.put("taf", 42);
    freq.put("tag", 121);
    freq.put("tab", 863);
    freq.put("tac", 1213);
    freq.put("tal", 7927);
    freq.put("tam", 5022);
    freq.put("sed", 71);
    freq.put("cni", 55);
    freq.put("afl", 109);
    freq.put("cha\u0301", 42);
    freq.put("siq", 107);

    init2();
  }
  private static void init2() {
    
    freq.put("afo", 146);
    freq.put(" ve", 970);
    freq.put("afi", 1228);
    freq.put("Yo", 603);
    freq.put("sit", 6032);
    freq.put("Ya", 59);
    freq.put("afe", 128);
    freq.put("Fu\u0301", 72);
    freq.put("Ye", 1235);
    freq.put("afa", 137);
    freq.put(" vo", 365);
    freq.put("spe", 1130);
    freq.put("sic", 1265);
    freq.put("sib", 103);
    freq.put("sia", 1021);
    freq.put("cho\u0301", 41);
    freq.put(" vu", 86);
    freq.put("sif", 156);
    freq.put("sie", 897);
    freq.put("sid", 3345);
    freq.put("pul", 337);
    freq.put("dwi", 49);
    freq.put("Yu", 72);
    freq.put("\u03bc", 51);
    freq.put("afr", 204);
    freq.put("o\u0302", 70);
    freq.put(" va", 1856);
    freq.put("ro\u0301n", 372);
    freq.put("acu", 155);
    freq.put("sir", 64);
    freq.put("act", 3007);
    freq.put("ek ", 44);
    freq.put("Q", 391);
    freq.put("ta ", 14271);
    freq.put("men", 10149);
    freq.put("von", 103);
    freq.put("siv", 107);
    freq.put("hia", 201);
    freq.put("ndu", 163);
    freq.put("ru\u0301 ", 40);
    freq.put("tos", 6512);
    freq.put(" vi", 1199);
    freq.put("hic", 622);
    freq.put("xpo", 40);
    freq.put(" Ri\u0301", 105);
    freq.put("Ons", 56);
    freq.put("aff", 59);
    freq.put("u\u0301l", 52);
    freq.put("u\u0301n", 299);
    freq.put("da ", 4544);
    freq.put("lum", 164);
    freq.put("u\u0301d", 56);
    freq.put("top", 212);
    freq.put("chi\u0301", 487);
    freq.put("tze", 111);
    freq.put("X", 966);
    freq.put("u\u0301t", 328);
    freq.put("u\u0301s", 134);
    freq.put("lf", 641);
    freq.put("lg", 344);
    freq.put("ld", 1220);
    freq.put("le", 12141);
    freq.put("lb", 1209);
    freq.put("lc", 1027);
    freq.put("la", 35610);
    freq.put("ln", 95);
    freq.put("\u0628", 113);
    freq.put("ll", 16721);
    freq.put("lm", 4777);
    freq.put("\u0432\u0438", 64);
    freq.put("lk", 130);
    freq.put("lh", 504);
    freq.put("li", 16018);
    freq.put("lv", 726);
    freq.put("lt", 4369);
    freq.put("lu", 5364);
    freq.put("lr", 42);
    freq.put("ls", 3809);
    freq.put("lp", 382);
    freq.put("lq", 133);
    freq.put("eut", 86);
    freq.put("euv", 62);
    freq.put("lz", 119);
    freq.put("eus", 3359);
    freq.put("ly", 296);
    freq.put("dad", 509);
    freq.put("Caz", 55);
    freq.put("daf", 41);
    freq.put(" za", 502);
    freq.put("dac", 110);
    freq.put("Cas", 3464);
    freq.put("Car", 802);
    freq.put("dan", 479);
    freq.put("Cap", 118);
    freq.put("u\u0301 ", 245);
    freq.put("Ibe", 153);
    freq.put("Cau", 98);
    freq.put("Cat", 426);
    freq.put("dat", 9256);
    freq.put("dau", 66);
    freq.put("Cai", 58);
    freq.put("dap", 72);
    freq.put("Can", 590);
    freq.put("Cam", 1021);
    freq.put("Cal", 895);
    freq.put("que\u0301", 50);
    freq.put("Cab", 319);
    freq.put("qui\u0301", 216);
    freq.put("Cad", 58);
    freq.put("Pre", 652);
    freq.put("uev", 956);
    freq.put("Sai", 418);
    freq.put("nya", 4504);
    freq.put("Pra", 244);
    freq.put("San", 2098);
    freq.put("c\u0327", 714);
    freq.put("Sal", 930);
    freq.put("Sac", 112);
    freq.put("Sab", 95);
    freq.put("Pro", 378);
    freq.put("emb", 1646);
    freq.put("Pri", 295);
    freq.put("Saf", 57);
    freq.put(" hu", 1100);
    freq.put("sin", 887);
    freq.put("Pru", 131);
    freq.put(" hi", 763);
    freq.put("Sax", 87);
    freq.put("bil", 199);
    freq.put("sim", 339);
    freq.put("Sas", 117);
    freq.put("Sar", 312);
    freq.put(" ha", 6493);
    freq.put("sil", 374);
    freq.put("Sav", 109);
    freq.put("Sau", 148);
    freq.put("pti", 114);
    freq.put("lie", 227);
    freq.put("oui", 114);
    freq.put("lfa", 274);
    freq.put("oun", 1514);
    freq.put("ec ", 41);
    freq.put("zau", 49);
    freq.put("obt", 71);
    freq.put("lfo", 195);
    freq.put("oug", 65);
    freq.put("oue", 43);
    freq.put("\u0629 ", 63);
    freq.put("sob", 802);
    freq.put("our", 395);
    freq.put("hle", 43);
    freq.put("out", 72);
    freq.put("rez", 147);
    freq.put("rey", 634);
    freq.put("nc\u0327a", 132);
    freq.put("la\u0300", 56);
    freq.put("la\u0301", 4259);
    freq.put("rer", 1624);
    freq.put("res", 4668);
    freq.put(" \u02c8", 61);
    freq.put("li\u0301", 371);
    freq.put("rev", 232);
    freq.put("le\u0300", 221);
    freq.put("le\u0301", 756);
    freq.put("rej", 70);
    freq.put("may", 1010);
    freq.put("cra", 303);
    freq.put("lo\u0300", 43);
    freq.put("lo\u0301", 828);
    freq.put("rel", 727);
    freq.put("rem", 1469);
    freq.put("reb", 488);
    freq.put("bab", 70);
    freq.put("rea", 344);
    freq.put("Tud", 41);
    freq.put("ign", 388);
    freq.put("\u043f", 41);
    freq.put("emp", 1335);
    freq.put("lob", 150);
    freq.put("ece", 250);
    freq.put("ky ", 62);
    freq.put("ecc", 313);
    freq.put("lf ", 51);
    freq.put("eca", 350);
    freq.put("eco", 638);
    freq.put("ixa", 896);
    freq.put("ecl", 113);
    freq.put("eck", 59);
    freq.put("eci", 2528);
    freq.put("ech", 4825);
    freq.put("qua", 2094);
    freq.put("ecu", 265);
    freq.put("ect", 1719);
    freq.put("que", 9584);
    freq.put("ecr", 84);
    freq.put("ie ", 3544);
    freq.put("qui", 2366);
    freq.put("rfi", 2743);
    freq.put("log", 342);
    freq.put("oni", 1854);
    freq.put("rci", 629);
    freq.put("se\u0300r", 48);
    freq.put("Ipa", 95);
    freq.put("nc\u0327 ", 341);
    freq.put("lod", 42);
    freq.put("g", 39756);
    freq.put("via", 506);
    freq.put("baj", 40);
    freq.put("hes", 362);
    freq.put("put", 63);
    freq.put("cro", 284);
    freq.put("n\u0303a", 383);
    freq.put("rct", 43);
    freq.put("lta", 1746);
    freq.put("n\u0303e", 71);
    freq.put("E\u0301vr", 60);
    freq.put("vac", 122);
    freq.put("eru\u0301", 45);
    freq.put("Ess", 225);
    freq.put("fot", 124);
    freq.put("lto", 1581);
    freq.put("u\u0308", 700);
    freq.put("n\u0303o", 229);
    freq.put(" Be", 1778);
    freq.put("igu\u0308", 76);
    freq.put("ari\u0301", 594);
    freq.put("seu", 313);
    freq.put("vag", 42);
    freq.put("ud ", 775);
    freq.put("cy ", 62);
    freq.put("lol", 93);
    freq.put("lph", 49);
    freq.put(" Ba", 3640);
    freq.put("a\u0300s ", 80);
    freq.put("Pai\u0301", 579);
    freq.put("ser", 1152);
    freq.put("mes", 1084);
    freq.put("lor", 1072);
    freq.put(" Sy", 56);
    freq.put("seq", 43);
    freq.put("be ", 906);
    freq.put("hef", 53);
    freq.put(" St", 445);
    freq.put(" Su", 912);
    freq.put("oge", 46);
    freq.put("clo", 250);
    freq.put(" Sh", 196);
    freq.put("heg", 254);
    freq.put(" So", 1654);
    freq.put(" Bl", 233);
    freq.put("lot", 169);
    freq.put(" Sc", 255);
    freq.put("\u03bb", 98);
    freq.put(" Sa", 4961);
    freq.put(" Bo", 1120);
    freq.put("mer", 2230);
    freq.put(" Se", 3315);
    freq.put("Ka", 309);
    freq.put("rso", 324);
    freq.put("rsi", 295);
    freq.put("Ke", 203);
    freq.put("udu", 147);
    freq.put("ogu", 112);
    freq.put("rte\u0301", 55);
    freq.put("Ki", 176);
    freq.put("Kh", 65);
    freq.put("Ko", 157);
    freq.put("rsa", 318);
    freq.put("Kl", 47);
    freq.put("Kr", 75);
    freq.put("ogo", 312);
    freq.put("R", 7862);
    freq.put("Ku", 88);
    freq.put("vas", 972);
    freq.put(" Fl", 289);
    freq.put("re\u0301c", 41);
    freq.put("e\u0301n ", 2163);
    freq.put("hau", 82);
    freq.put("lim", 460);
    freq.put("vie", 1569);
    freq.put("seg", 655);
    freq.put("bei", 51);
    freq.put("ben", 218);
    freq.put("bel", 1025);
    freq.put("sef", 47);
    freq.put("bec", 106);
    freq.put("onc", 1207);
    freq.put("bez", 71);
    freq.put("ses", 640);
    freq.put("bey", 41);
    freq.put("uro\u0301", 53);
    freq.put("ber", 1735);
    freq.put("bes", 144);
    freq.put(" S ", 115);
    freq.put("bet", 294);
    freq.put("are", 871);
    freq.put("Pap", 92);
    freq.put("Par", 783);
    freq.put("Edi", 90);
    freq.put("a\u0303o", 95);
    freq.put("Pau", 504);
    freq.put("nqu", 365);
    freq.put(" Br", 1100);
    freq.put(" I ", 417);
    freq.put("Pab", 49);
    freq.put("Pac", 95);
    freq.put("sen", 1175);
    freq.put("Pal", 487);
    freq.put("Pam", 292);
    freq.put("Pan", 179);
    freq.put("iba", 752);
    freq.put("bib", 60);
    freq.put("sk", 471);
    freq.put("sel", 661);
    freq.put("ur ", 505);
    freq.put("ck ", 381);
    freq.put("mio", 915);
    freq.put("ghe", 49);
    freq.put("\u0629", 63);
    freq.put("mic", 569);
    freq.put("mie", 1796);
    freq.put("mid", 134);
    freq.put("mig", 100);
    freq.put("mif", 80);
    freq.put("ce\u0301s", 6099);
    freq.put("Dep", 124);
    freq.put(" Se\u0301", 45);
    freq.put("sei", 105);
    freq.put("bus", 122);
    freq.put("ER ", 56);
    freq.put("mis", 230);
    freq.put("mir", 128);
    freq.put("mit", 490);
    freq.put("bic", 70);
    freq.put("Edw", 43);
    freq.put(" El", 689);
    freq.put(" Em", 289);
    freq.put(" En", 982);
    freq.put("xor", 48);
    freq.put("ri\u0301o", 740);
    freq.put(" Ei", 68);
    freq.put(" Ed", 408);
    freq.put("da\u0301n", 167);
    freq.put("sl", 1702);
    freq.put(" Ea", 51);
    freq.put(" Eb", 283);
    freq.put(" Ec", 152);
    freq.put("sfo", 54);
    freq.put("ute", 121);
    freq.put(" Ex", 340);
    freq.put("eag", 52);
    freq.put(" Ez", 47);
    freq.put("Ca\u0301l", 77);
    freq.put(" Et", 87);
    freq.put(" Eu", 620);
    freq.put(" Ev", 67);
    freq.put("sfe", 195);
    freq.put("lbe", 146);
    freq.put("ny ", 185);
    freq.put("awa", 67);
    freq.put(" Es", 4884);
    freq.put("cke", 58);
    freq.put("xos", 144);
    freq.put("urg", 1130);
    freq.put("Poz", 58);
    freq.put("mus", 767);
    freq.put("urb", 94);
    freq.put("urc", 256);
    freq.put("url", 50);
    freq.put("lpa", 53);
    freq.put("Pot", 41);
    freq.put("mur", 109);
    freq.put("Por", 454);
    freq.put("uri", 877);
    freq.put("Pop", 70);
    freq.put("Pon", 189);
    freq.put(" is", 1346);
    freq.put("Pol", 283);
    freq.put("Pom", 61);
    freq.put("urq", 156);
    freq.put("urr", 231);
    freq.put("Poi", 57);
    freq.put("hn", 341);
    freq.put("bia", 312);
    freq.put("de\u0301s", 276);
    freq.put("Pob", 65);
    freq.put("ho", 1603);
    freq.put("Den", 147);
    freq.put("ah ", 76);
    freq.put("Cha", 975);
    freq.put("mbo", 389);
    freq.put(" s ", 862);
    freq.put("VI ", 101);
    freq.put("lse", 50);
    freq.put("buc", 81);
    freq.put("Pe\u0301", 62);
    freq.put("eas", 101);
    freq.put("leg", 883);
    freq.put("sa\u0301n", 43);
    freq.put(" ix", 548);
    freq.put("nge", 459);
    freq.put("ear", 257);
    freq.put("urn", 118);
    freq.put("nga", 1589);
    freq.put("nde\u0301", 233);
    freq.put("co ", 7064);
    freq.put("Mos", 99);
    freq.put("Mor", 353);
    freq.put(" ir", 178);
    freq.put("jau", 48);
    freq.put("jar", 113);
    freq.put("jas", 71);
    freq.put("Mot", 51);
    freq.put("jan", 59);
    freq.put("q ", 75);
    freq.put("lte", 171);
    freq.put(" il", 210);
    freq.put("Mon", 1596);
    freq.put(" in", 2520);
    freq.put("Mol", 213);
    freq.put(" ib", 130);
    freq.put("bue", 92);
    freq.put(" id", 377);
    freq.put(" ie", 162);
    freq.put(" ig", 40);
    freq.put("oto", 449);
    freq.put(" \u0421", 41);
    freq.put("no ", 5180);
    freq.put("vim", 180);
    freq.put("tbo", 377);
    freq.put("ira", 1068);
    freq.put("tba", 42);
    freq.put("Kan", 52);
    freq.put("sos", 346);
    freq.put("lsi", 170);
    freq.put("rne\u0301", 74);
    freq.put("eto\u0301", 68);
    freq.put("aes", 53);
    freq.put("aer", 81);
    freq.put("qu", 14376);
    freq.put("uza", 179);
    freq.put("h", 38996);
    freq.put("xpr", 86);
    freq.put("sha", 111);
    freq.put("Om", 55);
    freq.put("ks ", 44);
    freq.put(" i ", 370);
    freq.put("shi", 211);
    freq.put("m2 ", 4882);
    freq.put("ael", 246);
    freq.put("ja ", 289);
    freq.put("Chu", 642);
    freq.put("Pr", 1737);
    freq.put("ebe", 146);
    freq.put("u\u0308es", 75);
    freq.put(" X ", 52);
    freq.put("eba", 1588);
    freq.put("Pu", 602);
    freq.put("ebl", 394);
    freq.put("ebo", 83);
    freq.put("i\u0308sa", 48);
    freq.put("C", 19854);
    freq.put("ke ", 87);
    freq.put("bte", 55);
    freq.put("ebu", 74);
    freq.put("Ol", 435);
    freq.put("Pa", 3522);
    freq.put("yol", 662);
    freq.put("ebr", 993);
    freq.put("Pe", 1603);
    freq.put("ede", 794);
    freq.put("Ph", 120);
    freq.put("Pi", 4009);
    freq.put("Po", 1463);
    freq.put("Pl", 536);
    freq.put("foz", 70);
    freq.put("lve", 168);
    freq.put("efi", 288);
    freq.put("lus", 184);
    freq.put("lut", 90);
    freq.put("de\u0300", 107);
    freq.put("\u0627", 224);
    freq.put("luy", 521);
    freq.put("luz", 282);
    freq.put("Jac", 136);
    freq.put(" Ip", 108);
    freq.put("et ", 1474);
    freq.put("luc", 305);
    freq.put("lia\u0301", 885);
    freq.put("lue", 1296);
    freq.put("lug", 1219);
    freq.put("ngu\u0308", 186);
    freq.put("lui", 166);
    freq.put("\u043b", 143);
    freq.put("lip", 156);
    freq.put("lul", 85);
    freq.put("omi", 687);
    freq.put("rpi", 201);
    freq.put("ken", 42);
    freq.put("jor", 51);
    freq.put("jos", 60);
    freq.put("eb ", 59);
    freq.put("omo", 2541);
    freq.put("vry", 61);
    freq.put("S", 13768);
    freq.put("omm", 82);
    freq.put("vre", 45);
    freq.put("xas", 176);
    freq.put("eui", 40);
    freq.put("vri", 44);
    freq.put("ket", 62);
    freq.put("ker", 97);
    freq.put(" fr", 6946);
    freq.put("ngs", 81);
    freq.put("etr", 713);
    freq.put("ets", 74);
    freq.put("Zam", 440);
    freq.put("ett", 317);
    freq.put("etu", 65);
    freq.put("etz", 165);
    freq.put("e\u0300", 1639);
    freq.put("Gu\u0301d", 51);
    freq.put("Wur", 43);
    freq.put("qu\u0308", 104);
    freq.put("lu ", 50);
    freq.put("etc", 51);
    freq.put("tla", 799);
    freq.put("eta", 1993);
    freq.put("tle", 198);
    freq.put("lo", 14735);
    freq.put(" Il", 295);
    freq.put("eth", 102);
    freq.put("eti", 1075);
    freq.put("Zar", 1183);
    freq.put("Ri\u0301o", 103);
    freq.put("uts", 45);
    freq.put("ck", 597);
    freq.put("va\u0301", 44);
    freq.put("ci", 55866);
    freq.put("ch", 19957);
    freq.put("co", 36494);
    freq.put("cn", 93);
    freq.put("Her", 278);
    freq.put("cl", 2381);
    freq.put("ve\u0300", 48);
    freq.put("ve\u0301", 50);
    freq.put("ca", 36727);
    freq.put("Loi", 111);
    freq.put("Lon", 283);
    freq.put("vi\u0301", 116);
    freq.put("ce", 5873);
    freq.put("Lom", 95);
    freq.put("Lor", 170);
    freq.put("Los", 419);
    freq.put("cy", 72);
    freq.put("Est", 1829);
    freq.put("rpe", 55);
    freq.put("lis", 1111);
    freq.put("uca", 364);
    freq.put("Lou", 130);
    freq.put("Hel", 71);
    freq.put("cr", 2764);
    freq.put("Hen", 171);
    freq.put("o\u0300rt", 45);
    freq.put("uck", 53);
    freq.put("Hei", 41);
    freq.put("cu", 2858);
    freq.put("ct", 6432);
    freq.put("Ges", 43);
    freq.put("Ger", 648);
    freq.put("vit", 110);
    freq.put("Jua", 119);
    freq.put("rve", 120);
    freq.put("Jud", 52);
    freq.put(" Id", 48);
    freq.put("Esp", 2346);
    freq.put("Jul", 90);
    freq.put("yar", 166);
    freq.put("uct", 498);
    freq.put("ai", 7870);
    freq.put("yan", 160);
    freq.put("nu ", 68);
    freq.put("Na\u0301", 254);
    freq.put("eo\u0301n", 60);
    freq.put("me\u0301s", 297);
    freq.put("Geo", 165);
    freq.put("Gen", 180);
    freq.put("\u03bf", 175);
    freq.put(" au", 2876);
    freq.put("oth", 60);
    freq.put("oti", 169);
    freq.put("Lo ", 323);
    freq.put("pic", 437);
    freq.put("bit", 3960);
    freq.put("lgo", 41);
    freq.put("cop", 107);
    freq.put("rvo", 53);
    freq.put("c ", 1440);
    freq.put("edo", 984);
    freq.put("cos", 2167);
    freq.put("pie", 425);
    freq.put("tub", 619);
    freq.put("psi", 41);
    freq.put("cor", 808);
    freq.put("pis", 101);
    freq.put("uio", 269);
    freq.put("uc ", 85);
    freq.put("ema\u0301", 600);
    freq.put("otr", 79);
    freq.put("ots", 45);
    freq.put("a ", 69);
    freq.put(" az", 45);
    freq.put("cot", 281);
    freq.put("And", 336);
    freq.put("mi\u0301n", 65);
    freq.put("Ang", 673);
    freq.put("Ana", 102);
    freq.put("Anc", 46);
    freq.put("e\u0301", 16262);
    freq.put("Ann", 99);
    freq.put("Ano", 61);
    freq.put("Anh", 44);
    freq.put("Ani", 69);
    freq.put("ofi\u0301", 41);
    freq.put("Ant", 494);
    freq.put("uir", 116);
    freq.put("rbi", 229);
    freq.put("Ans", 48);
    freq.put("Esc", 294);
    freq.put("rbe", 641);
    freq.put("eur", 262);
    freq.put("ya ", 11135);
    freq.put("rba", 625);
    freq.put("at", 36951);
    freq.put("bir", 182);
    freq.put("va", 6899);
    freq.put("ce\u0301", 6120);
    freq.put(" Fr", 2182);
    freq.put(" Fu", 665);
    freq.put("ve", 4086);
    freq.put("ci\u0301", 202);
    freq.put("dae", 153);
    freq.put("vi", 14449);
    freq.put("ca\u0301", 136);
    freq.put("ph ", 101);
    freq.put("vl", 53);
    freq.put("tov", 69);
    freq.put("vo", 2258);
    freq.put(" Fa", 900);
    freq.put("cu\u0301", 47);
    freq.put("vr", 185);
    freq.put("avo", 154);
    freq.put(" Fe", 743);
    freq.put("vu", 203);
    freq.put("uix", 148);
    freq.put("co\u0301", 298);
    freq.put("ave", 551);
    freq.put("uci\u0301", 66);
    freq.put("Yor", 546);
    freq.put(" Fo", 711);
    freq.put("io ", 12068);
    freq.put("coa", 55);
    freq.put("of ", 232);
    freq.put("Esl", 79);
    freq.put("tas", 2612);
    freq.put("ls ", 3268);
    freq.put("edr", 427);
    freq.put("Ai\u0301n", 47);
    freq.put("vo ", 1023);
    freq.put("etn", 131);
    freq.put("unc", 549);
    freq.put("sem", 568);
    freq.put("vio\u0301", 41);
    freq.put("dam", 162);
    freq.put("uls", 64);
    freq.put("uqu", 145);
    freq.put("gu\u0308e", 154);
    freq.put("Ob", 102);
    freq.put("cod", 67);
    freq.put("v ", 145);
    freq.put("phi", 59);
    freq.put("fur", 43);
    freq.put("ngo", 337);
    freq.put(" ap", 406);
    freq.put("Lam", 54);
    freq.put("iov", 42);
    freq.put("iot", 81);
    freq.put("ios", 2033);
    freq.put("Lan", 389);
    freq.put("phe", 58);
    freq.put("iop", 54);
    freq.put("ion", 3766);
    freq.put("iom", 261);
    freq.put("iol", 276);
    freq.put("ona", 5291);
    freq.put("iog", 52);
    freq.put("uem", 50);
    freq.put("iod", 531);
    freq.put("ioc", 379);
    freq.put("ont", 2981);
    freq.put(" Ph", 119);
    freq.put("ofe", 194);
    freq.put("i", 297238);
    freq.put(" Po", 1463);
    freq.put(" Tu", 387);
    freq.put("ofi", 3286);
    freq.put(" Tr", 784);
    freq.put("sbu", 127);
    freq.put("col", 848);
    freq.put(" To", 1738);
    freq.put("ori\u0301", 319);
    freq.put(" Ti", 744);
    freq.put(" Th", 489);
    freq.put("eim", 83);
    freq.put(" Te", 1398);
    freq.put("i\u0301s ", 1479);
    freq.put(" Ta", 1241);
    freq.put("hol", 113);
    freq.put("onu", 172);
    freq.put("isu", 85);
    freq.put("oal", 56);
    freq.put("dar", 409);
    freq.put("xeb", 52);
    freq.put("xec", 40);
    freq.put("lso", 93);
    freq.put("mfi", 49);
    freq.put("xen", 186);
    freq.put("das", 725);
    freq.put("tei", 151);
    freq.put("ksh", 40);
    freq.put("i\u0301de", 44);
    freq.put("lza", 60);
    freq.put("un\u0303a", 55);
    freq.put("max", 40);
    freq.put("tch", 72);
    freq.put("nou", 46);
    freq.put("lex", 169);
    freq.put("xey", 127);
    freq.put("adv", 85);
    freq.put("Be", 1779);
    freq.put("adu", 331);
    freq.put("c\u0327oi", 41);
    freq.put("Ba", 3644);
    freq.put("Bl", 233);
    freq.put("Bo", 1120);
    freq.put("oes", 72);
    freq.put("Bi", 1877);
    freq.put("wel", 61);
    freq.put("ske", 47);
    freq.put("Bu", 1318);
    freq.put("ger", 176);
    freq.put("ade", 908);
    freq.put("Fan", 52);
    freq.put("adc", 41);
    freq.put("Br", 1101);
    freq.put("ada", 2435);
    freq.put("Fab", 67);
    freq.put("ado", 2009);
    freq.put("esi\u0301", 70);
    freq.put("e\u0301s ", 12144);
    freq.put("ski", 109);
    freq.put("\u043c", 41);
    freq.put("adh", 47);
    freq.put("adi", 1004);
    freq.put("dvo", 55);
    freq.put("nvu", 57);
    freq.put("xe ", 402);
    freq.put(" \u0627", 100);
    freq.put(" \u0628", 40);
    freq.put("nfe", 159);
    freq.put("igo", 2086);
    freq.put("nve", 230);
    freq.put("T", 7124);
    freq.put("nva", 59);
    freq.put("Lau", 180);
    freq.put("tay", 123);
    freq.put("uzc", 121);
    freq.put("ucr", 81);
    freq.put("tc ", 40);
    freq.put("dey", 218);
    freq.put("igl", 91);
    freq.put("B ", 58);
    freq.put("l ", 26412);
    freq.put(" mu", 11537);
    freq.put("mi\u0301a", 98);
    freq.put("nfo", 139);
    freq.put(" Da", 678);
    freq.put("igi", 46);
    freq.put("ad ", 418);
    freq.put("Fa ", 481);
    freq.put("Las", 229);
    freq.put("i\u0301o ", 786);
    freq.put("Sue", 132);
    freq.put("Sud", 292);
    freq.put("nce", 1594);
    freq.put("ui ", 377);
    freq.put("Sag", 50);
    freq.put("Sui", 113);
    freq.put("eu ", 796);
    freq.put("Sus", 52);
    freq.put("Sur", 84);
    freq.put("Sup", 40);
    freq.put("po\u0301n", 114);
    freq.put("U ", 53);
    freq.put("utr", 63);
    freq.put("esv", 63);
    freq.put("esu", 238);
    freq.put("est", 15719);
    freq.put("ess", 304);
    freq.put("esq", 111);
    freq.put("esp", 2252);
    freq.put("nd ", 533);
    freq.put("yo\u0301 ", 84);
    freq.put("ust", 1133);
    freq.put("Be\u0301", 72);
    freq.put("dia", 1190);
    freq.put("esf", 145);
    freq.put("ese", 1276);
    freq.put("esd", 183);
    freq.put("esc", 3180);
    freq.put("iso", 251);
    freq.put("esa", 2233);
    freq.put("ada\u0301", 67);
    freq.put("eso", 805);
    freq.put(" ho", 443);
    freq.put("esm", 548);
    freq.put("adi\u0301", 134);
    freq.put("esi", 1456);
    freq.put("esh", 54);
    freq.put("swi", 41);
    freq.put("dch", 41);
    freq.put("Uz", 41);
    freq.put("Ut", 63);
    freq.put("\u4e4b", 56);
    freq.put("Us", 67);
    freq.put("Ur", 312);
    freq.put("Ul", 142);
    freq.put("Un", 1997);
    freq.put("Ue", 1325);
    freq.put("uim", 168);
    freq.put("hi\u0301a", 487);
    freq.put("Uc", 50);
    freq.put("ndi", 1523);
    freq.put("Sco", 41);
    freq.put("Sci", 60);
    freq.put("Sch", 126);
    freq.put("ndo", 2567);
    freq.put(" ju", 44);
    freq.put("duo", 46);
    freq.put("nde", 3342);
    freq.put("xar", 156);
    freq.put("ism", 873);
    freq.put(" he", 482);
    freq.put("es ", 7690);
    freq.put("rug", 86);
    freq.put("nds", 75);
    freq.put("ndr", 650);
    freq.put(" ja", 45);
    freq.put("le\u0301n", 62);
    freq.put("pue", 1281);
    freq.put("scl", 134);
    freq.put("own", 58);
    freq.put("owe", 59);
    freq.put("ea ", 612);
    freq.put("hi\u0301", 504);
    freq.put("owa", 53);
    freq.put("a\u0300 ", 342);
    freq.put("ino\u0301", 91);
    freq.put("o\u0300st", 117);
    freq.put("Lus", 44);
    freq.put("ine\u0301", 146);
    freq.put("De ", 52);
    freq.put("h ", 1778);
    freq.put("pio\u0301", 148);
    freq.put("e\u0300la", 91);
    freq.put("nil", 164);
    freq.put("vai", 52);
    freq.put("van", 360);
    freq.put("Amo", 43);
    freq.put("duy", 49);
    freq.put("Ama", 66);
    freq.put("rcu", 194);
    freq.put("ucu", 40);
    freq.put("oul", 124);
    freq.put("Ame", 169);
    freq.put("isc", 524);
    freq.put("vad", 166);
    freq.put("ubi", 467);
    freq.put("rfo", 56);
    freq.put("rco", 266);
    freq.put("rch", 786);
    freq.put("tg", 118);
    freq.put("oub", 45);
    freq.put("var", 1013);
    freq.put("rce", 963);
    freq.put("rca", 5430);
    freq.put("vat", 345);
    freq.put("zor", 59);
    freq.put("uns", 190);
    freq.put("uss", 242);
    freq.put("hy", 121);
    freq.put("eal", 403);
    freq.put("ean", 276);
    freq.put("hr", 216);
    freq.put("hs", 61);
    freq.put("eac", 66);
    freq.put("Des", 142);
    freq.put("eae", 70);
    freq.put("ow ", 78);
    freq.put("ht", 207);
    freq.put("hu", 6167);
    freq.put("hi", 10022);
    freq.put("Del", 71);
    freq.put("Dem", 144);
    freq.put("hl", 125);
    freq.put("hm", 76);
    freq.put("bch", 196);
    freq.put("Deb", 61);
    freq.put("ha", 11432);
    freq.put("eau", 208);
    freq.put("eat", 219);
    freq.put("oro\u0301", 198);
    freq.put("he", 5671);
    freq.put("ya\u0301n", 143);
    freq.put("dus", 68);
    freq.put("Tel", 72);
    freq.put("Ten", 108);
    freq.put("Teo", 41);
    freq.put("dmi", 426);
    freq.put("va ", 2367);
    freq.put("j", 1745);
    freq.put("tiu", 93);
    freq.put("E\u0301ta", 96);
    freq.put("Tex", 48);
    freq.put("gro", 300);
    freq.put("lva", 423);
    freq.put("lo\u0301n", 649);
    freq.put("Ter", 931);
    freq.put("Tes", 47);
    freq.put("lvi", 79);
    freq.put("ibe", 709);
    freq.put("Lue", 59);
    freq.put("Os", 1276);
    freq.put("oco", 258);
    freq.put("e\u0302", 61);
    freq.put("pil", 124);
    freq.put("iny", 434);
    freq.put("pin", 588);
    freq.put("pio", 7267);
    freq.put("int", 2294);
    freq.put("inu", 133);
    freq.put("inv", 192);
    freq.put("Lug", 56);
    freq.put("o\u0300s ", 104);
    freq.put("inq", 49);
    freq.put("ins", 841);
    freq.put("inl", 57);
    freq.put("ous", 206);
    freq.put("inn", 131);
    freq.put("ino", 2528);
    freq.put("inh", 136);
    freq.put("ini", 1221);
    freq.put("Ri\u0301", 105);
    freq.put("ind", 1169);
    freq.put("ine", 3588);
    freq.put("inf", 351);
    freq.put("ing", 916);
    freq.put("pit", 1534);
    freq.put("ina", 3383);
    freq.put("inc", 9264);
    freq.put("hn ", 206);
    freq.put("eo ", 161);
    freq.put("oac", 115);
    freq.put("i\u0301 ", 325);
    freq.put(" Uz", 41);
    freq.put("Jr ", 59);
    freq.put(" Ut", 63);
    freq.put("oan", 85);
    freq.put("a", 69);
    freq.put(" Ur", 312);
    freq.put(" Us", 67);
    freq.put(" Ul", 142);
    freq.put("rci\u0301", 64);
    freq.put(" Un", 1997);
    freq.put("Afr", 187);
    freq.put("dim", 719);
    freq.put(" Ue", 1325);
    freq.put("\u043d", 140);
    freq.put("gau", 48);
    freq.put(" Uc", 50);
    freq.put("Aca", 110);
    freq.put("rqu", 659);
    freq.put("ubp", 52);
    freq.put("ubr", 706);
    freq.put("ubs", 95);
    freq.put("ho\u0301", 68);
    freq.put("nfa", 138);
    freq.put("gar", 2153);
    freq.put("ube", 202);
    freq.put("he\u0300", 52);
    freq.put("he\u0301", 116);
    freq.put("U", 4208);
    freq.put("uba", 115);
    freq.put("Act", 184);
    freq.put("ha\u0302", 41);
    freq.put("ha\u0301", 74);
    freq.put("in ", 1797);
    freq.put(" gu", 873);
    freq.put("tan", 9479);
    freq.put("hna", 61);
    freq.put("i\u0301d", 62);
    freq.put("vis", 844);
    freq.put("i\u0301a", 5276);
    freq.put("i\u0301c", 52);
    freq.put("eod", 44);
    freq.put("i\u0301o", 885);
    freq.put("i\u0301n", 1828);
    freq.put("eon", 126);
    freq.put("eol", 192);
    freq.put("i\u0301t", 375);
    freq.put("eop", 46);
    freq.put("uor", 52);
    freq.put("i\u0301s", 1863);
    freq.put("xo\u0301n", 76);
    freq.put("Tur", 210);
  }
  
}

