package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class AF extends CLangProfile {
  private static final String name = "af";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public AF() {
    init();  
  }

  public  LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 1541130;
    n_words[1] = 1808182;
    n_words[2] = 1328687;

    freq.put("nwo", 542);
    freq.put("sch", 268);
    freq.put("Okt", 256);
    freq.put("aus", 156);
    freq.put("gaa", 266);
    freq.put("pte", 575);
    freq.put(" Gr", 1318);
    freq.put(" Ge", 658);
    freq.put(" Ga", 319);
    freq.put(" Go", 354);
    freq.put("Gr", 1326);
    freq.put("e\u0308", 2903);
    freq.put("fha", 158);
    freq.put("Ge", 659);
    freq.put("Ga", 319);
    freq.put("Go", 356);
    freq.put(" ka", 1533);
    freq.put("me ", 936);
    freq.put(" ke", 481);
    freq.put(" ki", 531);
    freq.put(" ko", 1672);
    freq.put(" kl", 879);
    freq.put(" km", 407);
    freq.put(" kr", 319);
    freq.put(" ku", 387);
    freq.put("nen", 189);
    freq.put("nel", 314);
    freq.put("nem", 225);
    freq.put("nee", 762);
    freq.put("kus", 410);
    freq.put("kun", 548);
    freq.put("kul", 242);
    freq.put("net", 468);
    freq.put("ak ", 856);
    freq.put("ner", 1014);
    freq.put("nes", 533);
    freq.put("mee", 1533);
    freq.put("med", 223);
    freq.put("mel", 330);
    freq.put("men", 1550);
    freq.put("ors", 871);
    freq.put("met", 2981);
    freq.put("mes", 247);
    freq.put("mer", 991);
    freq.put("ee ", 892);
    freq.put("dry", 204);
    freq.put("aks", 261);
    freq.put("k", 45378);
    freq.put("ne ", 1530);
    freq.put("akt", 740);
    freq.put("dri", 421);
    freq.put("orm", 964);
    freq.put("akl", 166);
    freq.put("dra", 423);
    freq.put("ake", 292);
    freq.put("nk ", 274);
    freq.put("Kon", 276);
    freq.put("bru", 1062);
    freq.put("bro", 237);
    freq.put("bri", 159);
    freq.put("bre", 258);
    freq.put("bra", 211);
    freq.put("m ", 5913);
    freq.put("vol", 1592);
    freq.put("er ", 10617);
    freq.put("lwe", 213);
    freq.put("ssi", 922);
    freq.put("Ste", 208);
    freq.put("kgr", 173);
    freq.put("Sta", 443);
    freq.put("nkl", 391);
    freq.put("kst", 257);
    freq.put("nkr", 453);
    freq.put("nks", 179);
    freq.put("V", 2714);
    freq.put("me", 9151);
    freq.put("md", 261);
    freq.put("erv", 860);
    freq.put("erw", 949);
    freq.put("ma", 3853);
    freq.put("err", 349);
    freq.put("mb", 2182);
    freq.put("mm", 802);
    freq.put("mo", 1485);
    freq.put("mi", 2940);
    freq.put("mu", 1085);
    freq.put("mt", 249);
    freq.put("erf", 286);
    freq.put("erg", 1022);
    freq.put("era", 1470);
    freq.put("erb", 529);
    freq.put("erl", 875);
    freq.put("erm", 861);
    freq.put("ern", 1142);
    freq.put("ero", 382);
    freq.put("erh", 416);
    freq.put("eri", 1765);
    freq.put("erk", 2067);
    freq.put("Le", 490);
    freq.put("La", 658);
    freq.put("Lo", 347);
    freq.put("uar", 522);
    freq.put("la ", 334);
    freq.put("Li", 504);
    freq.put("Lit", 162);
    freq.put("Lu", 245);
    freq.put("ena", 610);
    freq.put("Kaa", 543);
    freq.put("hoe", 410);
    freq.put("end", 3112);
    freq.put("ene", 1142);
    freq.put("eng", 314);
    freq.put("enh", 254);
    freq.put("eni", 1151);
    freq.put("hom", 166);
    freq.put("Kan", 220);
    freq.put("enn", 400);
    freq.put("eno", 500);
    freq.put("Kar", 171);
    freq.put("ens", 2864);
    freq.put("ent", 2318);
    freq.put("Kat", 191);
    freq.put("sse", 1275);
    freq.put("A", 6930);
    freq.put("lan", 4154);
    freq.put("lak", 490);
    freq.put("lad", 180);
    freq.put("lag", 434);
    freq.put("laa", 982);
    freq.put("II ", 246);
    freq.put("ove", 370);
    freq.put("lat", 361);
    freq.put("ovi", 678);
    freq.put("lti", 157);
    freq.put("lar", 155);
    freq.put("las", 433);
    freq.put("en ", 13492);
    freq.put(" Hy", 549);
    freq.put(" Hu", 294);
    freq.put(" Hi", 301);
    freq.put(" Ho", 502);
    freq.put(" Ha", 534);
    freq.put(" He", 680);
    freq.put("fis", 177);
    freq.put("imb", 245);
    freq.put("ime", 187);
    freq.put("ssa", 198);
    freq.put("imp", 231);
    freq.put(" ga", 169);
    freq.put("fie", 369);
    freq.put("fin", 174);
    freq.put("fil", 208);
    freq.put(" Va", 313);
    freq.put(" Ve", 669);
    freq.put(" Vi", 371);
    freq.put("SA ", 161);
    freq.put(" Vo", 314);
    freq.put(" Vr", 251);
    freq.put("l", 57433);
    freq.put("mde", 163);
    freq.put("nt ", 1757);
    freq.put("rt", 4139);
    freq.put("ru", 2543);
    freq.put("rv", 1198);
    freq.put("rw", 1199);
    freq.put("rp", 1265);
    freq.put("at ", 6755);
    freq.put("rs", 6262);
    freq.put("god", 193);
    freq.put("dst", 428);
    freq.put("ry", 2450);
    freq.put("rd", 7372);
    freq.put("re", 10923);
    freq.put("rf", 378);
    freq.put("rg", 2653);
    freq.put("ra", 7710);
    freq.put("rb", 955);
    freq.put("rc", 234);
    freq.put("rl", 1734);
    freq.put("rm", 2087);
    freq.put("rn", 1586);
    freq.put("is ", 12546);
    freq.put("rh", 614);
    freq.put("ri", 11752);
    freq.put("sma", 173);
    freq.put("gor", 522);
    freq.put("nts", 300);
    freq.put("ntr", 543);
    freq.put("ntw", 393);
    freq.put("nti", 571);
    freq.put("ntl", 164);
    freq.put("W", 2258);
    freq.put("nta", 457);
    freq.put("nte", 1815);
    freq.put("ate", 1382);
    freq.put("ata", 346);
    freq.put("iss", 374);
    freq.put("ato", 426);
    freq.put("ist", 1582);
    freq.put("isk", 182);
    freq.put("isi", 1018);
    freq.put("atu", 409);
    freq.put("r ", 19504);
    freq.put("ats", 404);
    freq.put("ism", 266);
    freq.put("isa", 220);
    freq.put("ise", 601);
    freq.put("aty", 167);
    freq.put("nhe", 276);
    freq.put("Dui", 918);
    freq.put("Swe", 193);
    freq.put("nis", 1512);
    freq.put("tem", 732);
    freq.put("tor", 808);
    freq.put("tot", 1108);
    freq.put("ton", 586);
    freq.put("too", 280);
    freq.put("tol", 317);
    freq.put("tom", 182);
    freq.put("tob", 268);
    freq.put("tof", 244);
    freq.put("toe", 713);
    freq.put(" le", 910);
    freq.put("B", 3706);
    freq.put(" la", 1290);
    freq.put(" lo", 197);
    freq.put(" li", 598);
    freq.put(" lu", 186);
    freq.put("Sep", 228);
    freq.put("ktu", 210);
    freq.put("ktr", 342);
    freq.put("kto", 369);
    freq.put("kti", 247);
    freq.put("mst", 248);
    freq.put("kte", 822);
    freq.put("to ", 272);
    freq.put("thu", 695);
    freq.put("raf", 284);
    freq.put("rag", 291);
    freq.put("rad", 331);
    freq.put("raa", 1046);
    freq.put("ran", 2011);
    freq.put("ral", 832);
    freq.put("ram", 317);
    freq.put("ty ", 384);
    freq.put("rak", 247);
    freq.put("ose", 346);
    freq.put("rat", 587);
    freq.put("ras", 532);
    freq.put("do ", 172);
    freq.put("on ", 1522);
    freq.put("tyn", 228);
    freq.put("ra ", 424);
    freq.put("tyd", 628);
    freq.put(" le\u0302", 242);
    freq.put("y", 11757);
    freq.put("tse", 746);
    freq.put("Sy ", 252);
    freq.put("don", 160);
    freq.put("doo", 416);
    freq.put("dom", 227);
    freq.put("m", 31352);
    freq.put("Ita", 207);
    freq.put("dor", 875);
    freq.put(" We", 720);
    freq.put("yf ", 380);
    freq.put(" Wa", 412);
    freq.put(" Wo", 179);
    freq.put("ude", 184);
    freq.put("d ", 15502);
    freq.put(" Wi", 530);
    freq.put("ock", 164);
    freq.put("em ", 967);
    freq.put("sto", 805);
    freq.put("hri", 224);
    freq.put("do", 2521);
    freq.put("dm", 299);
    freq.put("dj", 173);
    freq.put("dh", 249);
    freq.put("di", 29432);
    freq.put("dg", 161);
    freq.put("dd", 606);
    freq.put("de", 18394);
    freq.put("db", 222);
    freq.put("we\u0302", 320);
    freq.put("da", 3617);
    freq.put("e\u0301 ", 228);
    freq.put("dt", 211);
    freq.put("du", 998);
    freq.put("dr", 1453);
    freq.put("ds", 2062);
    freq.put("eme", 1266);
    freq.put("bar", 272);
    freq.put("bas", 270);
    freq.put("emb", 839);
    freq.put("emo", 181);
    freq.put("emi", 456);
    freq.put("baa", 372);
    freq.put("ban", 283);
    freq.put("bal", 289);
    freq.put("bai", 191);
    freq.put("om ", 1870);
    freq.put("w ", 232);
    freq.put("nus", 209);
    freq.put("nua", 266);
    freq.put("il ", 459);
    freq.put("un ", 219);
    freq.put("Rus", 560);
    freq.put("mun", 417);
    freq.put("ire", 181);
    freq.put("we", 6959);
    freq.put("wa", 9856);
    freq.put("de\u0301", 160);
    freq.put("wo", 4179);
    freq.put("omi", 324);
    freq.put(" Is", 157);
    freq.put(" It", 218);
    freq.put("wi", 1800);
    freq.put("oms", 595);
    freq.put("omp", 297);
    freq.put(" In", 916);
    freq.put("wy", 994);
    freq.put("ild", 294);
    freq.put("uns", 289);
    freq.put("unt", 325);
    freq.put("han", 779);
    freq.put("ila", 498);
    freq.put("ilo", 514);
    freq.put("ill", 662);
    freq.put("ilj", 228);
    freq.put("ili", 684);
    freq.put(" II", 202);
    freq.put("und", 530);
    freq.put("ir ", 1648);
    freq.put("uni", 820);
    freq.put("kwa", 191);
    freq.put(" me", 4100);
    freq.put("kwe", 204);
    freq.put(" ma", 1329);
    freq.put("had", 164);
    freq.put(" mo", 667);
    freq.put(" mi", 830);
    freq.put(" mu", 691);
    freq.put("ie\u0308", 1437);
    freq.put("san", 408);
    freq.put("rga", 496);
    freq.put("fri", 2089);
    freq.put("C ", 278);
    freq.put("ai ", 311);
    freq.put("nie\u0308", 246);
    freq.put("dsk", 181);
    freq.put("Ch", 621);
    freq.put("Co", 478);
    freq.put("slu", 297);
    freq.put("Ca", 399);
    freq.put("n", 127153);
    freq.put("ain", 204);
    freq.put("sli", 202);
    freq.put("aie", 241);
    freq.put("sle", 205);
    freq.put("sla", 1006);
    freq.put("Oo", 423);
    freq.put("iz", 156);
    freq.put("ip", 899);
    freq.put("is", 17403);
    freq.put("ir", 2359);
    freq.put("iu", 405);
    freq.put("it", 9361);
    freq.put("iw", 219);
    freq.put("iv", 1008);
    freq.put("Nas", 187);
    freq.put("ik", 8953);
    freq.put("ld ", 695);
    freq.put("im", 1386);
    freq.put("il", 3774);
    freq.put("io", 1984);
    freq.put("in", 25004);
    freq.put("ia", 2568);
    freq.put("opp", 449);
    freq.put("ic", 1058);
    freq.put("ib", 451);
    freq.put("ie", 47836);
    freq.put("id", 5034);
    freq.put("ig", 5540);
    freq.put("if", 581);
    freq.put("V ", 280);
    freq.put("ep ", 699);
    freq.put("th ", 270);
    freq.put("\u0441", 306);
    freq.put("nin", 804);
    freq.put("nig", 640);
    freq.put("nie", 1831);
    freq.put("kin", 914);
    freq.put("kil", 644);
    freq.put("Y", 252);
    freq.put("i ", 2513);
    freq.put("niv", 210);
    freq.put("kie", 536);
    freq.put("mil", 465);
    freq.put("Va", 314);
    freq.put("Ve", 689);
    freq.put("Vi", 374);
    freq.put("ept", 277);
    freq.put("epu", 400);
    freq.put("epr", 184);
    freq.put("Vo", 315);
    freq.put("Vr", 251);
    freq.put("the", 380);
    freq.put("epe", 254);
    freq.put("epa", 228);
    freq.put("dse", 527);
    freq.put("op ", 2264);
    freq.put("elj", 427);
    freq.put("elk", 209);
    freq.put("eli", 1906);
    freq.put("hal", 311);
    freq.put("elo", 234);
    freq.put("ell", 778);
    freq.put("haa", 238);
    freq.put("ela", 904);
    freq.put("elf", 322);
    freq.put("elg", 226);
    freq.put("eld", 1199);
    freq.put("ele", 2593);
    freq.put("ely", 255);
    freq.put("els", 1983);
    freq.put("har", 356);
    freq.put("elt", 333);
    freq.put("haw", 164);
    freq.put("rno", 196);
    freq.put("D", 9246);
    freq.put("ye ", 306);
    freq.put("rna", 508);
    freq.put("rne", 469);
    freq.put("ope", 438);
    freq.put("opg", 213);
    freq.put("opa", 195);
    freq.put("opo", 205);
    freq.put("vis", 289);
    freq.put("el ", 3516);
    freq.put("i\u0308", 264);
    freq.put("lja", 430);
    freq.put("ywe", 370);
    freq.put("ola", 171);
    freq.put("ole", 263);
    freq.put("olg", 904);
    freq.put(" Ju", 622);
    freq.put("oli", 772);
    freq.put("olk", 702);
    freq.put("oll", 288);
    freq.put("olo", 636);
    freq.put(" Jo", 563);
    freq.put("ols", 270);
    freq.put(" Ja", 710);
    freq.put("rg ", 777);
    freq.put("Hy", 550);
    freq.put("for", 371);
    freq.put("ica", 209);
    freq.put("Hu", 294);
    freq.put("ume", 172);
    freq.put("Hi", 301);
    freq.put("Ho", 503);
    freq.put("umb", 689);
    freq.put("Ha", 534);
    freq.put("He", 680);
    freq.put("ol ", 554);
    freq.put("ple", 241);
    freq.put("pla", 660);
    freq.put("pli", 169);
    freq.put("yk ", 810);
    freq.put("obe", 382);
    freq.put("o", 86673);
    freq.put("um ", 614);
    freq.put("mbo", 161);
    freq.put("Feb", 207);
    freq.put("mbi", 179);
    freq.put("ppe", 636);
    freq.put("mbe", 814);
    freq.put("sok", 377);
    freq.put("som", 247);
    freq.put("mba", 172);
    freq.put("soo", 954);
    freq.put("son", 545);
    freq.put("sow", 508);
    freq.put("ppy", 184);
    freq.put("wan", 300);
    freq.put("waa", 1031);
    freq.put("ee\u0308 ", 693);
    freq.put("gie", 714);
    freq.put("oep", 714);
    freq.put("gin", 784);
    freq.put("wat", 5174);
    freq.put("was", 2236);
    freq.put("war", 532);
    freq.put("\u0442", 161);
    freq.put("mb ", 655);
    freq.put("Z", 422);
    freq.put("Vol", 161);
    freq.put("ee\u0308r", 158);
    freq.put("nni", 442);
    freq.put(" n ", 10980);
    freq.put("nne", 904);
    freq.put(" Li", 502);
    freq.put("nke", 345);
    freq.put("nh", 460);
    freq.put("ni", 6127);
    freq.put("nj", 300);
    freq.put("nk", 2057);
    freq.put("nl", 616);
    freq.put("nm", 203);
    freq.put("nn", 1621);
    freq.put("no", 2885);
    freq.put("na", 6444);
    freq.put("nb", 510);
    freq.put("nc", 507);
    freq.put("nd", 12581);
    freq.put("ne", 5737);
    freq.put("nf", 203);
    freq.put("ng", 9804);
    freq.put("til", 187);
    freq.put("ny", 191);
    freq.put("tin", 826);
    freq.put("tio", 267);
    freq.put("tik", 334);
    freq.put("tie", 1846);
    freq.put("nr", 212);
    freq.put("ns", 9243);
    freq.put("nt", 6760);
    freq.put("nu", 917);
    freq.put("nv", 455);
    freq.put("nw", 666);
    freq.put(" ni", 722);
    freq.put("E", 2445);
    freq.put(" no", 1205);
    freq.put(" na", 2339);
    freq.put(" ne", 437);
    freq.put("ich", 258);
    freq.put("n ", 58065);
    freq.put("Wil", 165);
    freq.put("fst", 852);
    freq.put("rk ", 1040);
    freq.put("rol", 315);
    freq.put("rom", 305);
    freq.put("ron", 1072);
    freq.put("roo", 1778);
    freq.put("oss", 176);
    freq.put("rod", 199);
    freq.put("roe", 1277);
    freq.put("rog", 195);
    freq.put("osi", 266);
    freq.put("lli", 615);
    freq.put("oso", 190);
    freq.put("rop", 575);
    freq.put("lla", 325);
    freq.put("ros", 273);
    freq.put("rot", 330);
    freq.put("rou", 212);
    freq.put("rov", 708);
    freq.put("ver", 4566);
    freq.put("Daa", 460);
    freq.put("vee", 302);
    freq.put("ven", 170);
    freq.put("vel", 250);
    freq.put("vem", 236);
    freq.put("ert", 1101);
    freq.put("ey ", 181);
    freq.put("mg", 224);
    freq.put("erp", 342);
    freq.put("ll ", 176);
    freq.put("din", 875);
    freq.put("dio", 177);
    freq.put("dik", 198);
    freq.put("die", 24964);
    freq.put("ers", 4583);
    freq.put("dia", 294);
    freq.put("gus", 284);
    freq.put("p", 23331);
    freq.put("dit", 656);
    freq.put("der", 4829);
    freq.put("dis", 425);
    freq.put("ruk", 231);
    freq.put("Rep", 214);
    freq.put("yd ", 230);
    freq.put("deu", 1676);
    freq.put("Gre", 501);
    freq.put("Gra", 158);
    freq.put("Gro", 254);
    freq.put("Gri", 383);
    freq.put("erd", 1514);
    freq.put("ere", 1861);
    freq.put("ek ", 1799);
    freq.put("oes", 295);
    freq.put("mp", 1223);
    freq.put("Me", 800);
    freq.put("rua", 209);
    freq.put("Ma", 1360);
    freq.put("ms", 966);
    freq.put("ht ", 578);
    freq.put("Mo", 627);
    freq.put("yde", 281);
    freq.put("Mi", 548);
    freq.put("rug", 256);
    freq.put("Mu", 186);
    freq.put(" du", 309);
    freq.put("or ", 1152);
    freq.put("eko", 474);
    freq.put("ekk", 206);
    freq.put("ekg", 155);
    freq.put("eke", 2739);
    freq.put("bou", 330);
    freq.put("eka", 220);
    freq.put("dee", 1279);
    freq.put("boo", 276);
    freq.put("ekt", 701);
    freq.put("eks", 950);
    freq.put("boe", 246);
    freq.put("ipa", 265);
    freq.put("oem", 563);
    freq.put(" Ka", 1486);
    freq.put(" Ke", 447);
    freq.put(" Ki", 192);
    freq.put(" Ko", 657);
    freq.put(" Kr", 224);
    freq.put("ul ", 272);
    freq.put("ood", 288);
    freq.put("oog", 389);
    freq.put("oof", 1146);
    freq.put("ngr", 289);
    freq.put("Bel", 171);
    freq.put("F", 2510);
    freq.put("oom", 393);
    freq.put("ool", 561);
    freq.put("oon", 731);
    freq.put("ooi", 288);
    freq.put("ook", 1376);
    freq.put("oot", 1351);
    freq.put("oop", 341);
    freq.put("oos", 958);
    freq.put("oor", 4776);
    freq.put("Ber", 218);
    freq.put("ult", 270);
    freq.put("uli", 358);
    freq.put("ull", 459);
    freq.put("ms ", 488);
    freq.put(" on", 2106);
    freq.put(" oo", 2639);
    freq.put(" om", 1497);
    freq.put("ger", 1248);
    freq.put(" of", 1952);
    freq.put("spr", 756);
    freq.put("Mid", 157);
    freq.put("ma ", 226);
    freq.put("spo", 405);
    freq.put("spa", 260);
    freq.put(" ou", 447);
    freq.put(" or", 325);
    freq.put("spe", 934);
    freq.put(" op", 2809);
    freq.put("s ", 35284);
    freq.put("mas", 207);
    freq.put("mar", 331);
    freq.put("mat", 394);
    freq.put("use", 380);
    freq.put("enb", 269);
    freq.put("maa", 1244);
    freq.put("mag", 221);
    freq.put("mal", 270);
    freq.put("man", 726);
    freq.put("ght", 548);
    freq.put("sy", 1309);
    freq.put("ss", 2799);
    freq.put("sr", 312);
    freq.put("sp", 2566);
    freq.put("sw", 531);
    freq.put("sv", 424);
    freq.put("su", 1177);
    freq.put("st", 17122);
    freq.put("q", 199);
    freq.put("sj", 338);
    freq.put("si", 8436);
    freq.put("sh", 473);
    freq.put("so", 3731);
    freq.put("sn", 242);
    freq.put("sm", 693);
    freq.put("hoo", 1325);
    freq.put("sc", 448);
    freq.put("sb", 577);
    freq.put("sa", 2367);
    freq.put("sg", 396);
    freq.put("sf", 208);
    freq.put("se", 15556);
    freq.put("sd", 385);
    freq.put("Ru", 645);
    freq.put("enk", 275);
    freq.put("gee", 448);
    freq.put("ee\u0308", 1032);
    freq.put("Ry", 194);
    freq.put("Jan", 348);
    freq.put("Re", 621);
    freq.put("Chr", 224);
    freq.put("Ra", 223);
    freq.put("soe", 195);
    freq.put("Ro", 746);
    freq.put("Ri", 222);
    freq.put("tte", 641);
    freq.put(" aa", 2320);
    freq.put("jie", 306);
    freq.put(" ad", 269);
    freq.put("gte", 962);
    freq.put(" af", 820);
    freq.put("jin", 161);
    freq.put("gti", 391);
    freq.put(" ak", 286);
    freq.put(" al", 829);
    freq.put(" am", 322);
    freq.put(" an", 759);
    freq.put(" ar", 263);
    freq.put("hou", 360);
    freq.put(" at", 229);
    freq.put("gel", 1995);
    freq.put("nom", 368);
    freq.put("noo", 659);
    freq.put("ls ", 1008);
    freq.put("noe", 477);
    freq.put("nog", 456);
    freq.put("kki", 178);
    freq.put("kke", 1272);
    freq.put("ng ", 4906);
    freq.put("tti", 226);
    freq.put(" wo", 2888);
    freq.put("em", 4686);
    freq.put("el", 15653);
    freq.put("eo", 692);
    freq.put("en", 27638);
    freq.put("ei", 5726);
    freq.put("eh", 993);
    freq.put("ek", 7920);
    freq.put("ee", 12296);
    freq.put("ed", 5721);
    freq.put("eg", 3187);
    freq.put("ef", 995);
    freq.put("ea", 936);
    freq.put("ec", 406);
    freq.put("eb", 3497);
    freq.put("ey", 309);
    freq.put("eu", 3603);
    freq.put("et", 10282);
    freq.put("ew", 3034);
    freq.put("ev", 2016);
    freq.put("ep", 2393);
    freq.put("es", 15156);
    freq.put("er", 33393);
    freq.put("blo", 205);
    freq.put("bli", 525);
    freq.put("Joh", 290);
    freq.put("bla", 215);
    freq.put("Ker", 270);
    freq.put("rlo", 320);
    freq.put("rli", 409);
    freq.put("G", 3299);
    freq.put("rle", 270);
    freq.put("orw", 195);
    freq.put("ort", 1219);
    freq.put("rla", 508);
    freq.put("e ", 78745);
    freq.put("orp", 858);
    freq.put("orl", 386);
    freq.put("dig", 1168);
    freq.put("ork", 260);
    freq.put("ori", 1212);
    freq.put("org", 587);
    freq.put("ord", 4583);
    freq.put("ore", 773);
    freq.put("orb", 186);
    freq.put("ora", 235);
    freq.put("Apr", 247);
    freq.put("onk", 232);
    freq.put("oni", 1012);
    freq.put("onn", 184);
    freq.put("ono", 391);
    freq.put("onl", 220);
    freq.put("ona", 980);
    freq.put("ong", 620);
    freq.put("ond", 1915);
    freq.put("one", 1178);
    freq.put("ons", 511);
    freq.put("ont", 1339);
    freq.put("Eur", 318);
    freq.put("ial", 357);
    freq.put("ian", 256);
    freq.put("iaa", 736);
    freq.put("hul", 552);
    freq.put("hum", 674);
    freq.put("x ", 845);
    freq.put("hui", 260);
    freq.put("ebi", 752);
    freq.put("ia ", 794);
    freq.put("r", 98861);
    freq.put("uk ", 200);
    freq.put("and", 5528);
    freq.put("ane", 404);
    freq.put("ang", 1856);
    freq.put("pra", 251);
    freq.put("ana", 788);
    freq.put("sam", 303);
    freq.put("anc", 195);
    freq.put("ann", 632);
    freq.put("pri", 484);
    freq.put("ani", 742);
    freq.put("anj", 191);
    freq.put("ank", 961);
    freq.put("ant", 1705);
    freq.put("anu", 467);
    freq.put("ans", 3841);
    freq.put("sas", 204);
    freq.put("Do", 201);
    freq.put("Di", 5828);
    freq.put("De", 763);
    freq.put("Da", 804);
    freq.put("\u0435", 266);
    freq.put("Du", 1025);
    freq.put("an ", 18298);
    freq.put("sa ", 155);
    freq.put(" Le", 488);
    freq.put(" La", 657);
    freq.put(" Lo", 346);
    freq.put("D ", 158);
    freq.put(" Lu", 244);
    freq.put("tkl", 165);
    freq.put("Wes", 439);
    freq.put("ge ", 1916);
    freq.put("nli", 373);
    freq.put("We", 720);
    freq.put("Wa", 412);
    freq.put("Wo", 181);
    freq.put("iti", 469);
    freq.put("lub", 411);
    freq.put("Wi", 534);
    freq.put("\u0430", 481);
    freq.put("itg", 386);
    freq.put("ges", 2014);
    freq.put(" pr", 1589);
    freq.put("gep", 249);
    freq.put("gew", 944);
    freq.put("gev", 788);
    freq.put("get", 297);
    freq.put("H", 3034);
    freq.put(" px", 614);
    freq.put("geb", 2499);
    freq.put(" pa", 556);
    freq.put("geg", 181);
    freq.put(" pe", 402);
    freq.put("ged", 475);
    freq.put("gek", 350);
    freq.put("geh", 356);
    freq.put(" po", 737);
    freq.put("gen", 1564);
    freq.put("gem", 756);
    freq.put(" pl", 641);
    freq.put("o\u0301", 216);
    freq.put("uto", 171);
    freq.put("rma", 539);
    freq.put("rme", 324);
    freq.put("rmi", 175);
    freq.put("itt", 191);
    freq.put("rko", 248);
    freq.put("vry", 194);
    freq.put("tur", 232);
    freq.put("tus", 988);
    freq.put("tuu", 617);
    freq.put("tui", 232);
    freq.put("rm ", 692);
    freq.put("jo", 532);
    freq.put("ji", 572);
    freq.put("je", 609);
    freq.put("tud", 171);
    freq.put("ja", 1960);
    freq.put(" be", 5430);
    freq.put(" ba", 599);
    freq.put(" bl", 263);
    freq.put(" bo", 565);
    freq.put(" bi", 320);
    freq.put(" bu", 213);
    freq.put("s", 102389);
    freq.put("rki", 199);
    freq.put(" br", 340);
    freq.put(" by", 612);
    freq.put("por", 394);
    freq.put("pos", 197);
    freq.put("poo", 160);
    freq.put("pol", 518);
    freq.put("ei ", 821);
    freq.put("eis", 330);
    freq.put("eit", 680);
    freq.put("eie", 633);
    freq.put("eid", 1307);
    freq.put("moe", 196);
    freq.put("eil", 544);
    freq.put("ein", 1010);
    freq.put("ive", 294);
    freq.put("ivi", 590);
    freq.put("oi ", 216);
    freq.put("rwe", 410);
    freq.put(" Me", 799);
    freq.put("par", 608);
    freq.put("pas", 176);
    freq.put(" Ma", 1348);
    freq.put("Vry", 192);
    freq.put(" Mo", 624);
    freq.put(" Mi", 547);
    freq.put(" Mu", 186);
    freq.put("I ", 452);
    freq.put("lyk", 221);
    freq.put("pal", 324);
    freq.put("pan", 428);
    freq.put("I", 2837);
    freq.put("yd", 927);
    freq.put("II", 369);
    freq.put("naa", 1198);
    freq.put("it ", 3772);
    freq.put("naf", 372);
    freq.put("Is", 158);
    freq.put("It", 218);
    freq.put("pa ", 202);
    freq.put("In", 919);
    freq.put("am ", 1182);
    freq.put("gde", 427);
    freq.put("uid", 2285);
    freq.put("nam", 291);
    freq.put("e\u0302 ", 310);
    freq.put("okk", 553);
    freq.put("gre", 401);
    freq.put("lg ", 483);
    freq.put("ami", 512);
    freq.put("amm", 186);
    freq.put("ama", 204);
    freq.put("amb", 236);
    freq.put("ame", 657);
    freq.put("e\u0302r", 697);
    freq.put("mon", 329);
    freq.put("gro", 2150);
    freq.put("amp", 480);
    freq.put("pst", 229);
    freq.put("mod", 233);
    freq.put("tig", 1053);
    freq.put("oe\u0308", 412);
    freq.put("t", 82606);
    freq.put("Ned", 417);
    freq.put(" ch", 185);
    freq.put("Mei", 281);
    freq.put("o ", 2083);
    freq.put("dde", 490);
    freq.put("mpi", 220);
    freq.put("oo", 12667);
    freq.put("on", 10533);
    freq.put("om", 5480);
    freq.put("ol", 5346);
    freq.put("ok", 2525);
    freq.put("oi", 587);
    freq.put("km ", 266);
    freq.put("og", 2271);
    freq.put("of", 3797);
    freq.put("oe", 6026);
    freq.put("ach", 166);
    freq.put("oc", 387);
    freq.put("ob", 729);
    freq.put("oa", 178);
    freq.put("ngo", 161);
    freq.put("ow", 1144);
    freq.put("ov", 1152);
    freq.put("ou", 2993);
    freq.put("ot", 3827);
    freq.put("os", 3306);
    freq.put("or", 14221);
    freq.put("op", 4558);
    freq.put("Ni", 257);
    freq.put("No", 1092);
    freq.put("Na", 666);
    freq.put("Ne", 763);
    freq.put("het", 2911);
    freq.put("log", 655);
    freq.put("her", 350);
    freq.put("loe", 423);
    freq.put("lon", 293);
    freq.put("loo", 382);
    freq.put("lom", 430);
    freq.put("hed", 169);
    freq.put("hee", 465);
    freq.put("ehe", 259);
    freq.put("eha", 370);
    freq.put("hel", 273);
    freq.put("eho", 266);
    freq.put("hei", 994);
    freq.put("J", 2196);
    freq.put("lo ", 169);
    freq.put("as ", 5230);
    freq.put("he ", 399);
    freq.put("aa", 18307);
    freq.put("ac", 615);
    freq.put("ab", 1064);
    freq.put("ae", 907);
    freq.put("ad", 4564);
    freq.put("ag", 2729);
    freq.put("af", 1901);
    freq.put("ai", 1291);
    freq.put("ah", 292);
    freq.put("ak", 2797);
    freq.put("aj", 155);
    freq.put("am", 3989);
    freq.put("al", 9554);
    freq.put("an", 36357);
    freq.put("ap", 2087);
    freq.put("as", 9342);
    freq.put("ar", 11432);
    freq.put("au", 883);
    freq.put("at", 11369);
    freq.put("aw", 597);
    freq.put("av", 407);
    freq.put("ay", 279);
    freq.put("az", 190);
    freq.put("igt", 498);
    freq.put("igs", 156);
    freq.put("igg", 185);
    freq.put("ige", 1604);
    freq.put("igd", 381);
    freq.put("Lat", 181);
    freq.put("igi", 270);
    freq.put("igh", 698);
    freq.put("a ", 7054);
    freq.put("lge", 754);
    freq.put("rr", 652);
    freq.put("u", 35166);
    freq.put("Bri", 282);
    freq.put("ig ", 1346);
    freq.put("uit", 3378);
    freq.put("Bre", 163);
    freq.put("Bra", 191);
    freq.put("all", 667);
    freq.put("alk", 171);
    freq.put("ali", 1276);
    freq.put("alf", 209);
    freq.put("alg", 320);
    freq.put("ald", 217);
    freq.put("ale", 2352);
    freq.put("ala", 367);
    freq.put("gt", 1512);
    freq.put("gs", 1974);
    freq.put("alt", 231);
    freq.put("als", 160);
    freq.put("gr", 3459);
    freq.put("hy ", 302);
    freq.put("ots", 913);
    freq.put("ty", 1434);
    freq.put("tv", 217);
    freq.put("tw", 1177);
    freq.put("tt", 1277);
    freq.put("tu", 2643);
    freq.put("tr", 4026);
    freq.put("ts", 3814);
    freq.put("to", 5433);
    freq.put("tl", 667);
    freq.put("tm", 201);
    freq.put("tj", 177);
    freq.put("tk", 279);
    freq.put("th", 1701);
    freq.put("ti", 5658);
    freq.put("\u0438", 371);
    freq.put("te", 20430);
    freq.put("tb", 213);
    freq.put("ta", 9118);
    freq.put("edi", 638);
    freq.put("ium", 203);
    freq.put("mpo", 176);
    freq.put("al ", 2759);
    freq.put("ost", 637);
    freq.put("mpt", 267);
    freq.put("fam", 176);
    freq.put("ius", 176);
    freq.put("sme", 382);
    freq.put("uwe", 229);
    freq.put(" Ni", 257);
    freq.put("gg", 418);
    freq.put("pre", 726);
    freq.put("ro", 8165);
    freq.put(" No", 1092);
    freq.put("eds", 321);
    freq.put(" Na", 662);
    freq.put(" Ne", 762);
    freq.put("ge", 16432);
    freq.put("rk", 2996);
    freq.put("t ", 22731);
    freq.put("gb", 319);
    freq.put("tei", 844);
    freq.put("tek", 528);
    freq.put("tel", 2135);
    freq.put("ga", 1621);
    freq.put("ten", 1059);
    freq.put("ted", 237);
    freq.put("tee", 779);
    freq.put("teg", 166);
    freq.put("ter", 4231);
    freq.put("tes", 357);
    freq.put("teu", 212);
    freq.put("abe", 229);
    freq.put("abi", 201);
    freq.put("sbu", 231);
    freq.put("sui", 596);
    freq.put("lle", 1578);
    freq.put("aby", 216);
    freq.put(" ru", 233);
    freq.put("te ", 8469);
    freq.put("K", 3663);
    freq.put(" re", 1576);
    freq.put("Noo", 595);
    freq.put(" ra", 237);
    freq.put("pub", 435);
    freq.put(" ro", 614);
    freq.put(" ri", 825);
    freq.put("oma", 425);
    freq.put("lki", 447);
    freq.put("lke", 200);
    freq.put("nto", 201);
    freq.put("Aug", 272);
    freq.put("rks", 184);
    freq.put("vin", 921);
    freq.put("vir", 1570);
    freq.put("rke", 440);
    freq.put("rka", 271);
    freq.put("rkl", 203);
    freq.put("S ", 157);
    freq.put("asi", 1669);
    freq.put("twe", 751);
    freq.put("twi", 269);
    freq.put("de ", 6409);
    freq.put("In ", 319);
    freq.put("Sy", 292);
    freq.put("Sp", 443);
    freq.put("Sw", 402);
    freq.put("Su", 1701);
    freq.put("St", 964);
    freq.put("Sk", 201);
    freq.put("Si", 387);
    freq.put("So", 680);
    freq.put("Sl", 222);
    freq.put("Sc", 197);
    freq.put("Sa", 728);
    freq.put("Se", 814);
    freq.put("a\u0301", 212);
    freq.put("kle", 511);
    freq.put("kla", 387);
    freq.put(" di", 25510);
    freq.put("Int", 180);
    freq.put(" de", 3947);
    freq.put("des", 476);
    freq.put("kli", 749);
    freq.put(" da", 1923);
    freq.put("klu", 430);
    freq.put("dek", 186);
    freq.put("del", 1695);
    freq.put("den", 1206);
    freq.put("v", 32618);
    freq.put("Ind", 251);
    freq.put("SA", 233);
    freq.put(" dr", 523);
    freq.put("pro", 1677);
    freq.put("f ", 4067);
    freq.put("ati", 871);
    freq.put("ryk", 576);
    freq.put("ryf", 393);
    freq.put("ryw", 338);
    freq.put("eg ", 316);
    freq.put("rys", 282);
    freq.put("fr", 2334);
    freq.put("fs", 1224);
    freq.put("ft", 300);
    freq.put("fu", 174);
    freq.put("rmo", 164);
    freq.put("fa", 570);
    freq.put("fd", 469);
    freq.put("fe", 948);
    freq.put("ff", 351);
    freq.put("fg", 323);
    freq.put("fh", 169);
    freq.put("fi", 1111);
    freq.put("fk", 224);
    freq.put("fl", 183);
    freq.put("fo", 725);
    freq.put("a", 128566);
    freq.put("kor", 369);
    freq.put("egs", 217);
    freq.put("egr", 238);
    freq.put("ry ", 383);
    freq.put("egt", 193);
    freq.put("egi", 516);
    freq.put("ego", 497);
    freq.put("ds ", 353);
    freq.put("o\u0308", 184);
    freq.put("ega", 168);
    freq.put("ege", 690);
    freq.put("ito", 170);
    freq.put("ce ", 276);
    freq.put("y ", 4684);
    freq.put("ite", 1331);
    freq.put("ita", 608);
    freq.put("ok ", 1432);
    freq.put("os ", 1171);
    freq.put("ffe", 165);
    freq.put("its", 1623);
    freq.put(" Oo", 422);
    freq.put(" Ol", 205);
    freq.put("e\u0308 ", 1979);
    freq.put(" Ok", 339);
    freq.put("paa", 333);
    freq.put("yn ", 461);
    freq.put(" Or", 191);
    freq.put(" Os", 236);
    freq.put("rwa", 171);
    freq.put("yk", 1145);
    freq.put("yl", 288);
    freq.put("yn", 1041);
    freq.put("ye", 406);
    freq.put("L", 2519);
    freq.put("yg", 162);
    freq.put("yf", 643);
    freq.put("omm", 454);
    freq.put("rwy", 498);
    freq.put("ys", 1141);
    freq.put("yw", 439);
    freq.put("e\u0308l", 325);
    freq.put("e\u0308r", 307);
    freq.put("ifi", 218);
    freq.put("yns", 175);
    freq.put(" sy", 1183);
    freq.put("Eng", 637);
    freq.put(" sp", 887);
    freq.put(" sw", 227);
    freq.put(" st", 4293);
    freq.put(" su", 859);
    freq.put(" sk", 1250);
    freq.put(" si", 590);
    freq.put(" so", 2211);
    freq.put(" sl", 329);
    freq.put(" sa", 888);
    freq.put(" se", 2315);
    freq.put("ass", 518);
    freq.put("pun", 246);
    freq.put(" Af", 2082);
    freq.put("ast", 673);
    freq.put(" Al", 626);
    freq.put(" Am", 563);
    freq.put(" An", 491);
    freq.put(" Ap", 349);
    freq.put(" Ar", 422);
    freq.put(" As", 200);
    freq.put(" At", 187);
    freq.put(" Au", 486);
    freq.put("ase", 210);
    freq.put("mme", 353);
    freq.put("Uni", 236);
    freq.put(" s ", 207);
    freq.put("aso", 169);
    freq.put("kol", 246);
    freq.put("El", 212);
    freq.put("En", 721);
    freq.put("kon", 866);
    freq.put("w", 24930);
    freq.put("Eu", 354);
    freq.put("Fra", 1006);
    freq.put("ie\u0308 ", 1136);
    freq.put(" el", 502);
    freq.put(" en", 9738);
    freq.put("kom", 903);
    freq.put(" ei", 517);
    freq.put("koo", 391);
    freq.put(" ek", 223);
    freq.put(" ee", 1730);
    freq.put("koe", 157);
    freq.put("lie\u0308", 349);
    freq.put("kop", 214);
    freq.put("\u043a", 266);
    freq.put("kou", 249);
    freq.put("odu", 188);
    freq.put("nce", 206);
    freq.put("aad", 172);
    freq.put("aag", 175);
    freq.put("b", 21626);
    freq.put("sta", 5065);
    freq.put("aam", 1083);
    freq.put("aal", 1515);
    freq.put("aan", 6190);
    freq.put("aai", 350);
    freq.put("sti", 1396);
    freq.put("aak", 679);
    freq.put("aat", 1563);
    freq.put("je ", 175);
    freq.put("aap", 567);
    freq.put("aas", 579);
    freq.put("aar", 5293);
    freq.put("sty", 226);
    freq.put("ka ", 1388);
    freq.put("lid", 165);
    freq.put("lie", 1618);
    freq.put("k ", 9212);
    freq.put("lia", 364);
    freq.put("lim", 201);
    freq.put("lin", 1208);
    freq.put("lik", 2917);
    freq.put("lit", 831);
    freq.put("lis", 504);
    freq.put("kaa", 1596);
    freq.put("M", 3951);
    freq.put("kan", 1256);
    freq.put("kal", 611);
    freq.put("kas", 204);
    freq.put("kar", 183);
    freq.put("kap", 818);
    freq.put("kat", 157);
    freq.put("The", 196);
    freq.put("rhe", 301);
    freq.put("ka", 6722);
    freq.put("kg", 239);
    freq.put("ke", 8584);
    freq.put("kk", 1579);
    freq.put("ki", 2683);
    freq.put("kh", 210);
    freq.put("ko", 3908);
    freq.put("km", 469);
    freq.put("kl", 2200);
    freq.put("ks", 2318);
    freq.put("kr", 2375);
    freq.put("kw", 457);
    freq.put("ku", 1443);
    freq.put("kt", 2084);
    freq.put("ef ", 280);
    freq.put("ky", 282);
    freq.put("rte", 620);
    freq.put("rta", 186);
    freq.put("ugb", 161);
    freq.put("rto", 274);
    freq.put("rti", 334);
    freq.put("rtk", 160);
    freq.put("rty", 351);
    freq.put("ugu", 278);
    freq.put("Ju", 623);
    freq.put("ies", 4471);
    freq.put("ier", 2228);
    freq.put("ieu", 180);
    freq.put("iet", 320);
    freq.put("iew", 413);
    freq.put("iek", 2103);
    freq.put("Jo", 565);
    freq.put("iel", 277);
    freq.put("ien", 998);
    freq.put("Je", 157);
    freq.put("ied", 1248);
    freq.put("ief", 177);
    freq.put("his", 173);
    freq.put("rt ", 1413);
    freq.put("ste", 6829);
    freq.put("ug ", 159);
    freq.put("hie", 290);
    freq.put("uim", 162);
    freq.put("ie ", 34696);
    freq.put(" Be", 877);
    freq.put("seu", 239);
    freq.put("ars", 463);
    freq.put(" Ba", 645);
    freq.put("ser", 501);
    freq.put("arv", 249);
    freq.put(" Bl", 161);
    freq.put(" Bo", 479);
    freq.put(" Bi", 179);
    freq.put(" Bu", 243);
    freq.put("ara", 390);
    freq.put("see", 618);
    freq.put("ik ", 2305);
    freq.put("ard", 1124);
    freq.put("are", 965);
    freq.put("sea", 162);
    freq.put("arg", 256);
    freq.put("ari", 1177);
    freq.put("sem", 298);
    freq.put("ark", 397);
    freq.put("arl", 301);
    freq.put("arm", 157);
    freq.put("arn", 185);
    freq.put("aro", 332);
    freq.put("stu", 693);
    freq.put("wor", 2620);
    freq.put("ses", 400);
    freq.put("won", 526);
    freq.put("iks", 287);
    freq.put("str", 1673);
    freq.put("iku", 209);
    freq.put("uur", 863);
    freq.put("ar ", 3216);
    freq.put("ika", 2950);
    freq.put("ike", 1814);
    freq.put("se ", 9840);
    freq.put("ikk", 629);
    freq.put("fge", 290);
    freq.put("Ba", 648);
    freq.put(" Pr", 547);
    freq.put("c", 4896);
    freq.put(" Pa", 725);
    freq.put(" Pe", 309);
    freq.put(" Pi", 229);
    freq.put(" Po", 674);
    freq.put("wen", 427);
    freq.put("tge", 442);
    freq.put("ga ", 157);
    freq.put("pr", 3258);
    freq.put("ps", 659);
    freq.put("pp", 1058);
    freq.put("pt", 765);
    freq.put("pu", 844);
    freq.put("swa", 313);
    freq.put("px", 614);
    freq.put("py", 231);
    freq.put("yds", 165);
    freq.put("pa", 2371);
    freq.put("pg", 229);
    freq.put("pe", 3683);
    freq.put("ph", 223);
    freq.put("pi", 1008);
    freq.put("po", 1932);
    freq.put("pl", 1195);
    freq.put(" ty", 439);
    freq.put(" tw", 582);
    freq.put(" tu", 692);
    freq.put("wet", 305);
    freq.put(" tr", 387);
    freq.put("N", 3334);
    freq.put(" to", 1857);
    freq.put("gan", 539);
    freq.put(" ti", 190);
    freq.put(" th", 729);
    freq.put(" te", 2715);
    freq.put(" ta", 895);
    freq.put("Oli", 158);
    freq.put("p ", 4720);
    freq.put("bor", 587);
    freq.put("voe", 444);
    freq.put("e\u0302re", 674);
    freq.put("sy ", 1199);
    freq.put("riv", 501);
    freq.put("rit", 493);
    freq.put("voo", 1083);
    freq.put("ris", 571);
    freq.put("rin", 1384);
    freq.put("rio", 174);
    freq.put("ril", 278);
    freq.put("rik", 3384);
    freq.put("vor", 625);
    freq.put("rig", 863);
    freq.put("rie", 2029);
    freq.put("ric", 236);
    freq.put("ria", 924);
    freq.put("ewi", 337);
    freq.put("ewo", 449);
    freq.put("ewa", 222);
    freq.put("ewe", 1704);
    freq.put("gs ", 887);
    freq.put("tis", 241);
    freq.put(" do", 1111);
    freq.put("lig", 818);
    freq.put("gst", 406);
    freq.put(" fa", 191);
    freq.put(" fi", 368);
    freq.put(" fo", 227);
    freq.put("lde", 601);
    freq.put("\u043e", 333);
    freq.put("sal", 170);
    freq.put("rge", 595);
    freq.put("win", 417);
    freq.put("rgi", 335);
    freq.put("app", 418);
    freq.put("bin", 400);
    freq.put("Ol", 206);
    freq.put("Ok", 339);
    freq.put("Die", 4537);
    freq.put("bie", 1052);
    freq.put("oee\u0308", 178);
    freq.put("Dit", 1028);
    freq.put("Os", 236);
    freq.put("Or", 191);
    freq.put("d", 77385);
    freq.put("ljo", 223);
    freq.put("eeu", 449);
    freq.put("eet", 195);
    freq.put("ees", 884);
    freq.put("eer", 3295);
    freq.put("eem", 410);
    freq.put("eel", 2072);
    freq.put("een", 2520);
    freq.put("eek", 631);
    freq.put("eed", 587);
    freq.put("b ", 1179);
    freq.put("saa", 540);
    freq.put("oe ", 303);
    freq.put("per", 1379);
    freq.put("pes", 438);
    freq.put("pel", 568);
    freq.put("pen", 295);
    freq.put("pee", 201);
    freq.put("id ", 2425);
    freq.put("be", 8513);
    freq.put("rui", 1143);
    freq.put("ba", 2057);
    freq.put("bb", 156);
    freq.put("rum", 244);
    freq.put("bl", 1117);
    freq.put("oer", 752);
    freq.put("bo", 2123);
    freq.put("oew", 261);
    freq.put("bi", 1966);
    freq.put("O", 2514);
    freq.put("oet", 302);
    freq.put("oek", 499);
    freq.put("bu", 1057);
    freq.put("oei", 336);
    freq.put("oen", 602);
    freq.put("br", 1953);
    freq.put("oel", 276);
    freq.put("rus", 225);
    freq.put("oeg", 231);
    freq.put("by", 1025);
    freq.put("oed", 477);
    freq.put("Rom", 176);
    freq.put("ids", 257);
    freq.put("idi", 291);
    freq.put("idd", 457);
    freq.put("ide", 993);
    freq.put("pe ", 459);
    freq.put("ida", 156);
    freq.put("nsi", 1079);
    freq.put("nsk", 498);
    freq.put("nsl", 207);
    freq.put("nse", 3345);
    freq.put(" ui", 1746);
    freq.put("nst", 787);
    freq.put("ust", 585);
    freq.put("Oos", 361);
    freq.put("uss", 1129);
    freq.put("u ", 1834);
    freq.put(" Ch", 612);
    freq.put(" Co", 473);
    freq.put("ns ", 2476);
    freq.put(" Ca", 384);
    freq.put("fde", 429);
    freq.put("ute", 176);
    freq.put("uu", 992);
    freq.put("ut", 907);
    freq.put("uw", 282);
    freq.put("up", 170);
    freq.put("us", 5098);
    freq.put("ur", 5410);
    freq.put("um", 1711);
    freq.put("ul", 2052);
    freq.put("un", 2596);
    freq.put("ui", 7822);
    freq.put("uk", 678);
    freq.put("ue", 905);
    freq.put("ud", 950);
    freq.put("ug", 1045);
    freq.put("z", 1187);
    freq.put("ua", 728);
    freq.put("uc", 160);
    freq.put("ub", 1182);
    freq.put("Tu", 248);
    freq.put("Tr", 236);
    freq.put("To", 272);
    freq.put("Th", 313);
    freq.put("lyn", 187);
    freq.put("Te", 262);
    freq.put("Ta", 276);
    freq.put("nab", 229);
    freq.put("A ", 345);
    freq.put("Mar", 370);
    freq.put(" gr", 2075);
    freq.put("nad", 316);
    freq.put("le\u0302 ", 268);
    freq.put("nal", 790);
    freq.put("ag ", 1304);
    freq.put("Maa", 286);
    freq.put("nas", 677);
    freq.put(" ge", 8191);
    freq.put("nat", 282);
    freq.put("gra", 537);
    freq.put(" go", 365);
    freq.put("gri", 320);
    freq.put("na ", 1572);
    freq.put("e", 240974);
    freq.put("Af", 2087);
    freq.put("age", 184);
    freq.put("sve", 167);
    freq.put("Am", 566);
    freq.put("Al", 628);
    freq.put("An", 491);
    freq.put("Ap", 353);
    freq.put("As", 201);
    freq.put("Ar", 425);
    freq.put("Au", 486);
    freq.put("At", 187);
    freq.put("agt", 446);
    freq.put(" b", 8379);
    freq.put(" c", 434);
    freq.put("gu", 592);
    freq.put(" a", 8747);
    freq.put(" f", 1200);
    freq.put(" g", 11018);
    freq.put(" d", 33601);
    freq.put(" e", 13358);
    freq.put(" j", 1325);
    freq.put(" k", 6363);
    freq.put(" h", 7358);
    freq.put(" i", 23795);
    freq.put(" n", 16000);
    freq.put(" o", 12065);
    freq.put(" l", 3565);
    freq.put(" m", 7731);
    freq.put(" r", 3617);
    freq.put(" s", 15482);
    freq.put(" p", 4859);
    freq.put("gd", 570);
    freq.put(" v", 24617);
    freq.put(" w", 13128);
    freq.put(" t", 8537);
    freq.put(" u", 1931);
    freq.put("go", 1385);
    freq.put("gn", 360);
    freq.put("gl", 334);
    freq.put("gi", 2135);
    freq.put("gh", 921);
    freq.put(" B", 3554);
    freq.put(" C", 2109);
    freq.put(" A", 6365);
    freq.put(" F", 2371);
    freq.put(" G", 3138);
    freq.put(" D", 8986);
    freq.put(" E", 2271);
    freq.put(" J", 2155);
    freq.put(" K", 3559);
    freq.put(" H", 2961);
    freq.put(" I", 2185);
    freq.put(" N", 3120);
    freq.put(" O", 2318);
    freq.put(" L", 2396);
    freq.put(" M", 3803);
    freq.put(" R", 2881);
    freq.put(" S", 7708);
    freq.put(" P", 2912);
    freq.put(" Q", 162);
    freq.put(" V", 2322);
    freq.put(" W", 2205);
    freq.put(" T", 2130);
    freq.put(" U", 571);
    freq.put(" Z", 368);
    freq.put("Nov", 238);
    freq.put(" Y", 241);
    freq.put("ch ", 316);
    freq.put("ed ", 1090);
    freq.put("vlo", 280);
    freq.put("vla", 709);
    freq.put("lee\u0308", 449);
    freq.put("P", 3097);
    freq.put("g ", 10256);
    freq.put("tri", 607);
    freq.put("evi", 274);
    freq.put("tro", 780);
    freq.put("evo", 907);
    freq.put("tra", 1128);
    freq.put("eva", 262);
    freq.put("us ", 1998);
    freq.put("tre", 1022);
    freq.put("eve", 456);
    freq.put("Spa", 253);
    freq.put("tru", 366);
    freq.put("le ", 3834);
    freq.put("zi", 170);
    freq.put("ze", 169);
    freq.put("rre", 272);
    freq.put("ods", 177);
    freq.put("za", 209);
    freq.put("odi", 176);
    freq.put("doe", 283);
    freq.put("ode", 551);
    freq.put("rd ", 3667);
    freq.put("led", 218);
    freq.put("lee", 477);
    freq.put("leg", 257);
    freq.put("lei", 1010);
    freq.put("lek", 605);
    freq.put("z ", 242);
    freq.put("lem", 358);
    freq.put("len", 1056);
    freq.put("ler", 415);
    freq.put("les", 329);
    freq.put("let", 347);
    freq.put("leu", 193);
    freq.put("lew", 250);
    freq.put("od ", 254);
    freq.put("rde", 1873);
    freq.put("rdo", 215);
    freq.put("rdi", 841);
    freq.put(" Do", 196);
    freq.put("wie", 194);
    freq.put("Ver", 555);
    freq.put(" Di", 5802);
    freq.put("aps", 269);
    freq.put(" De", 761);
    freq.put("wil", 177);
    freq.put("wik", 231);
    freq.put(" Da", 803);
    freq.put("wit", 342);
    freq.put("wis", 166);
    freq.put(" Du", 1024);
    freq.put("apa", 189);
    freq.put("sge", 305);
    freq.put("cha", 160);
    freq.put("Fr", 1217);
    freq.put("che", 490);
    freq.put("fel", 155);
    freq.put("tas", 164);
    freq.put("usi", 606);
    freq.put("rf ", 180);
    freq.put("fer", 157);
    freq.put("Fe", 367);
    freq.put("sie\u0308", 283);
    freq.put("Fi", 216);
    freq.put("Fo", 165);
    freq.put("ue ", 322);
    freq.put("ap ", 635);
    freq.put("px ", 614);
    freq.put(" Ru", 645);
    freq.put("f", 13583);
    freq.put("oh", 382);
    freq.put(" Ry", 194);
    freq.put("Ja", 713);
    freq.put(" Re", 620);
    freq.put(" Ra", 221);
    freq.put(" Ro", 743);
    freq.put(" Ri", 222);
    freq.put("tat", 456);
    freq.put("tau", 165);
    freq.put("od", 1636);
    freq.put("\u0440", 242);
    freq.put("tad", 2323);
    freq.put("taa", 2499);
    freq.put("tal", 1301);
    freq.put("tan", 1021);
    freq.put(" va", 14670);
    freq.put("sip", 279);
    freq.put(" ve", 4043);
    freq.put("sit", 436);
    freq.put("afd", 268);
    freq.put("afg", 266);
    freq.put(" vl", 594);
    freq.put(" vo", 2359);
    freq.put("sia", 299);
    freq.put(" vr", 575);
    freq.put("sig", 289);
    freq.put("sif", 160);
    freq.put("sie", 4039);
    freq.put("dwe", 310);
    freq.put("sik", 231);
    freq.put("sio", 799);
    freq.put("sin", 541);
    freq.put("sim", 173);
    freq.put("sil", 194);
    freq.put("sis", 296);
    freq.put("Q", 182);
    freq.put("ta ", 339);
    freq.put("ndr", 216);
    freq.put("af ", 494);
    freq.put(" vi", 2068);
    freq.put("usl", 180);
    freq.put("da ", 327);
    freq.put("dw", 506);
    freq.put("lf", 717);
    freq.put("lg", 1526);
    freq.put("ld", 1944);
    freq.put("le", 10290);
    freq.put("lb", 446);
    freq.put("tsk", 298);
    freq.put("la", 8341);
    freq.put("lo", 3369);
    freq.put("ll", 2990);
    freq.put("lm", 315);
    freq.put("lj", 705);
    freq.put("lk", 1158);
    freq.put("lh", 279);
    freq.put("li", 9515);
    freq.put("lv", 239);
    freq.put("lw", 311);
    freq.put("lt", 993);
    freq.put("lu", 1548);
    freq.put("ls", 2634);
    freq.put("lp", 392);
    freq.put("e\u0308r ", 180);
    freq.put("eus", 242);
    freq.put("ly", 716);
    freq.put("dae", 480);
    freq.put("dag", 700);
    freq.put("daa", 645);
    freq.put("dam", 165);
    freq.put("dan", 233);
    freq.put("sid", 185);
    freq.put("dat", 659);
    freq.put("ema", 484);
    freq.put("Pre", 186);
    freq.put(" hy", 292);
    freq.put("l ", 8172);
    freq.put("Pro", 177);
    freq.put("eu ", 338);
    freq.put(" hu", 727);
    freq.put(" hi", 477);
    freq.put(" ho", 1750);
    freq.put(" ha", 612);
    freq.put("by ", 693);
    freq.put("oue", 197);
    freq.put("oud", 510);
    freq.put("wes", 799);
    freq.put("ous", 302);
    freq.put("our", 167);
    freq.put("out", 306);
    freq.put("res", 944);
    freq.put("Tur", 159);
    freq.put("le\u0302", 351);
    freq.put("ret", 312);
    freq.put("rek", 765);
    freq.put("rei", 545);
    freq.put("ren", 1300);
    freq.put("wer", 1583);
    freq.put("rel", 674);
    freq.put("rea", 245);
    freq.put("ref", 257);
    freq.put("reg", 1039);
    freq.put("red", 294);
    freq.put("ree", 1091);
    freq.put("lf ", 175);
    freq.put("ou ", 999);
    freq.put("x", 1123);
    freq.put("g", 42805);
    freq.put("lte", 252);
    freq.put("re ", 2607);
    freq.put("u\u0308", 233);
    freq.put("pge", 207);
    freq.put("rs ", 1922);
    freq.put("ud ", 181);
    freq.put("set", 250);
    freq.put("art", 1494);
    freq.put("og ", 895);
    freq.put(" Sy", 292);
    freq.put("los", 274);
    freq.put(" Sp", 441);
    freq.put(" Sw", 400);
    freq.put(" St", 953);
    freq.put(" Su", 1700);
    freq.put(" Sk", 201);
    freq.put(" Si", 385);
    freq.put(" So", 678);
    freq.put(" Sl", 222);
    freq.put("ary", 171);
    freq.put(" Sc", 196);
    freq.put(" Sa", 724);
    freq.put(" Se", 811);
    freq.put("Ka", 1489);
    freq.put("rso", 249);
    freq.put("rsi", 432);
    freq.put("Ke", 447);
    freq.put("rsk", 872);
    freq.put("rse", 478);
    freq.put("Ki", 194);
    freq.put("Ko", 657);
    freq.put("rsa", 225);
    freq.put("ogr", 272);
    freq.put("Kr", 224);
    freq.put("R", 3039);
    freq.put("ogi", 423);
    freq.put("hem", 255);
    freq.put("rst", 1083);
    freq.put("udi", 240);
    freq.put("rsp", 591);
    freq.put("vie", 880);
    freq.put("bek", 1148);
    freq.put("beh", 366);
    freq.put("bel", 540);
    freq.put("beg", 372);
    freq.put("bed", 285);
    freq.put("bee", 325);
    freq.put("sed", 264);
    freq.put("ber", 1916);
    freq.put("bes", 1308);
    freq.put("bev", 630);
    freq.put("bew", 349);
    freq.put("bet", 510);
    freq.put("Par", 313);
    freq.put(" Br", 777);
    freq.put("sen", 1323);
    freq.put("py ", 166);
    freq.put("sk", 5006);
    freq.put("sel", 1093);
    freq.put("ur ", 2547);
    freq.put("ck ", 233);
    freq.put("min", 806);
    freq.put("sek", 186);
    freq.put("mie", 523);
    freq.put("mid", 310);
    freq.put("mig", 184);
    freq.put("hr", 313);
    freq.put("mit", 231);
    freq.put(" El", 212);
    freq.put(" En", 720);
    freq.put("sl", 1811);
    freq.put("awi", 169);
    freq.put("st ", 267);
    freq.put(" Eu", 354);
    freq.put("awe", 308);
    freq.put("ure", 395);
    freq.put("urg", 669);
    freq.put("mus", 488);
    freq.put("uro", 352);
    freq.put("uri", 191);
    freq.put("urk", 167);
    freq.put("urt", 189);
    freq.put("urs", 211);
    freq.put("Cha", 171);
    freq.put("lse", 623);
    freq.put("eda", 161);
    freq.put("nge", 2327);
    freq.put(" is", 11238);
    freq.put("jar", 470);
    freq.put("woo", 760);
    freq.put("kse", 472);
    freq.put("ae ", 624);
    freq.put("Mon", 210);
    freq.put(" in", 12303);
    freq.put("ngs", 1292);
    freq.put("ksi", 463);
    freq.put("jaa", 1087);
    freq.put("mge", 191);
    freq.put(" we", 1395);
    freq.put("qu", 168);
    freq.put(" wa", 7840);
    freq.put("h", 17527);
    freq.put("lst", 643);
    freq.put(" wi", 454);
    freq.put("ks ", 710);
    freq.put("\u0432", 199);
    freq.put(" wy", 201);
    freq.put("Pr", 551);
    freq.put("ebe", 354);
    freq.put("eba", 159);
    freq.put("ebo", 768);
    freq.put("C", 2451);
    freq.put("ke ", 3014);
    freq.put("Pa", 727);
    freq.put("ebr", 1168);
    freq.put("Pe", 310);
    freq.put("ede", 2561);
    freq.put("Pi", 230);
    freq.put("Po", 681);
    freq.put("lus", 194);
    freq.put("ome", 845);
    freq.put("et ", 6083);
    freq.put("lug", 221);
    freq.put("lui", 390);
    freq.put("\u043b", 219);
    freq.put("ken", 2090);
    freq.put("kel", 962);
    freq.put("kei", 339);
    freq.put("kee", 210);
    freq.put("tsl", 425);
    freq.put("S", 8234);
    freq.put("eun", 234);
    freq.put("joe", 306);
    freq.put("vro", 313);
    freq.put("ker", 1342);
    freq.put("kep", 166);
    freq.put("etr", 438);
    freq.put("ets", 217);
    freq.put("ett", 493);
    freq.put(" we\u0302", 298);
    freq.put("tla", 301);
    freq.put("eta", 359);
    freq.put("ete", 1299);
    freq.put("tli", 191);
    freq.put("eti", 372);
    freq.put("eto", 320);
    freq.put("ck", 502);
    freq.put("ci", 340);
    freq.put("ch", 1526);
    freq.put("co", 446);
    freq.put("Her", 157);
    freq.put("ot ", 1528);
    freq.put("ca", 479);
    freq.put("rva", 502);
    freq.put("ce", 547);
    freq.put("ct", 207);
    freq.put("Ger", 200);
    freq.put("ys ", 680);
    freq.put("Jun", 245);
    freq.put("Jul", 297);
    freq.put(" as", 2284);
    freq.put("uik", 850);
    freq.put("oto", 266);
    freq.put("rvo", 192);
    freq.put("c ", 311);
    freq.put("ote", 350);
    freq.put("oha", 228);
    freq.put("rp ", 728);
    freq.put("rvl", 353);
    freq.put("ott", 175);
    freq.put("tst", 993);
    freq.put("e\u0301", 765);
    freq.put("uis", 508);
    freq.put("rbi", 190);
    freq.put("rbe", 287);
    freq.put("eur", 2292);
    freq.put("rba", 160);
    freq.put("yst", 183);
    freq.put("va", 16173);
    freq.put(" Fr", 1217);
    freq.put("ve", 5906);
    freq.put("vi", 4040);
    freq.put("vl", 1196);
    freq.put("vo", 4078);
    freq.put("vr", 662);
    freq.put(" Fe", 367);
    freq.put("vu", 178);
    freq.put(" Fi", 213);
    freq.put("vy", 166);
    freq.put(" Fo", 161);
    freq.put("io ", 196);
    freq.put("of ", 2323);
    freq.put("edr", 340);
    freq.put("ion", 1252);
    freq.put("wys", 531);
    freq.put("i", 140621);
    freq.put(" Tu", 243);
    freq.put(" Tr", 236);
    freq.put(" To", 270);
    freq.put("ofs", 803);
    freq.put(" Th", 307);
    freq.put(" Te", 261);
    freq.put(" Ta", 273);
    freq.put("Hy ", 529);
    freq.put("mpe", 208);
    freq.put("sku", 244);
    freq.put("Be", 880);
    freq.put("weg", 270);
    freq.put("ads", 176);
    freq.put("wee", 1257);
    freq.put("skr", 1152);
    freq.put("Bl", 161);
    freq.put("Bo", 481);
    freq.put("sky", 183);
    freq.put("Bi", 180);
    freq.put("wel", 545);
    freq.put("ske", 665);
    freq.put("Bu", 243);
    freq.put("ade", 539);
    freq.put("ska", 1212);
    freq.put("Br", 778);
    freq.put("ada", 249);
    freq.put("sko", 594);
    freq.put("adm", 206);
    freq.put("ski", 804);
    freq.put("adi", 436);
    freq.put("T", 2336);
    freq.put("we ", 1260);
    freq.put("ad ", 2565);
    freq.put("nje", 156);
    freq.put("Sui", 1515);
    freq.put("ts ", 533);
    freq.put("X", 214);
    freq.put("est", 2951);
    freq.put("ess", 405);
    freq.put("esp", 358);
    freq.put("nd ", 4245);
    freq.put("ese", 3607);
    freq.put("eso", 210);
    freq.put("esl", 228);
    freq.put("esk", 1018);
    freq.put("esi", 976);
    freq.put("dui", 309);
    freq.put("Un", 253);
    freq.put("we\u0302r", 319);
    freq.put("ndi", 878);
    freq.put("kry", 1085);
    freq.put("Sch", 162);
    freq.put("ndo", 326);
    freq.put("nda", 453);
    freq.put("nde", 5081);
    freq.put("kri", 662);
    freq.put(" he", 3438);
    freq.put("es ", 4626);
    freq.put("nds", 657);
    freq.put("kra", 345);
    freq.put(" ja", 1102);
    freq.put("owe", 208);
    freq.put("owa", 484);
    freq.put("h ", 864);
    freq.put("van", 14723);
    freq.put("val", 319);
    freq.put("vaa", 414);
    freq.put("Ame", 464);
    freq.put("tg", 532);
    freq.put("vat", 155);
    freq.put("hy", 348);
    freq.put("bur", 584);
    freq.put("Des", 273);
    freq.put("ht", 702);
    freq.put("hu", 1684);
    freq.put("hi", 1067);
    freq.put("ho", 3048);
    freq.put("ha", 2610);
    freq.put("he", 6229);
    freq.put("dus", 171);
    freq.put("dmi", 211);
    freq.put("j", 4048);
    freq.put("int", 638);
    freq.put("inw", 455);
    freq.put("pie", 480);
    freq.put("ins", 1349);
    freq.put("inn", 302);
    freq.put("ub ", 406);
    freq.put("ini", 615);
    freq.put("ink", 417);
    freq.put("ind", 1030);
    freq.put("ine", 545);
    freq.put("ing", 6095);
    freq.put("ina", 506);
    freq.put(" Un", 253);
    freq.put("Afr", 2048);
    freq.put("\u043d", 199);
    freq.put("U", 687);
    freq.put("ubl", 464);
    freq.put("in ", 12178);
    freq.put("e\u0302", 1053);
    freq.put("eor", 221);
    freq.put("rep", 191);
  }
  
}

