/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encoding;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.util.ResourceLoader;

public abstract class Encoding
implements COSObjectable {
    protected Map codeToName = new HashMap();
    protected Map nameToCode = new HashMap();
    private static final Map NAME_TO_CHARACTER;
    private static final Map CHARACTER_TO_NAME;

    protected void addCharacterEncoding(int code, COSName name) {
        Integer intCode = new Integer(code);
        this.codeToName.put(intCode, name);
        this.nameToCode.put(name, intCode);
    }

    public int getCode(COSName name) throws IOException {
        Integer code = (Integer)this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name.getName() + "'");
        }
        return code;
    }

    public COSName getName(int code) throws IOException {
        COSName name = (COSName)this.codeToName.get(new Integer(code));
        if (name == null) {
            name = COSName.getPDFName("space");
        }
        return name;
    }

    public COSName getNameFromCharacter(char c) throws IOException {
        COSName name = (COSName)CHARACTER_TO_NAME.get("" + c);
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String character = Encoding.getCharacter(this.getName(code));
        return character;
    }

    public static String getCharacter(COSName name) {
        String character = (String)NAME_TO_CHARACTER.get(name);
        if (character == null) {
            character = name.getName();
        }
        return character;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block14: {
            Encoding.NAME_TO_CHARACTER = new HashMap<K, V>();
            Encoding.CHARACTER_TO_NAME = new HashMap<K, V>();
            glyphStream = null;
            try {
                resource = ResourceLoader.loadResource("Resources/glyphlist.txt");
                glyphStream = new BufferedReader(new InputStreamReader(resource));
                line = null;
                while ((line = glyphStream.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || (semicolonIndex = line.indexOf(59)) < 0) continue;
                    try {
                        characterName = line.substring(0, semicolonIndex);
                        unicodeValue = line.substring(semicolonIndex + 1, line.length());
                        tokenizer = new StringTokenizer(unicodeValue, " ", false);
                        value = "";
                        while (tokenizer.hasMoreTokens()) {
                            characterCode = Integer.parseInt(tokenizer.nextToken(), 16);
                            value = value + (char)characterCode;
                        }
                        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName(characterName), value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                var10_12 = null;
                if (glyphStream == null) break block14;
                ** GOTO lbl50
            }
            catch (IOException io) {
                io.printStackTrace();
                var10_12 = null;
                if (glyphStream != null) {
                    try {
                        glyphStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break block14;
            }
            {
                catch (Throwable var9_16) {
                    var10_13 = null;
                    if (glyphStream == null) throw var9_16;
                    ** try [egrp 3[TRYBLOCK] [5 : 225->232)] { 
lbl45:
                    // 1 sources

                    glyphStream.close();
                    throw var9_16;
lbl47:
                    // 1 sources

                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw var9_16;
                }
lbl50:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 225->232)] { 
lbl51:
                // 1 sources

                glyphStream.close();
lbl53:
                // 1 sources

                catch (IOException e) {}
                e.printStackTrace();
            }
        }
        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName(".notdef"), "");
        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName("fi"), "fi");
        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName("fl"), "fl");
        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName("ffi"), "ffi");
        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName("ff"), "ff");
        Encoding.NAME_TO_CHARACTER.put(COSName.getPDFName("pi"), "pi");
        keys = Encoding.NAME_TO_CHARACTER.keySet().iterator();
        while (keys.hasNext() != false) {
            key = keys.next();
            value = Encoding.NAME_TO_CHARACTER.get(key);
            Encoding.CHARACTER_TO_NAME.put(value, key);
        }
    }
}

