/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetDecoderICU;
import com.ibm.icu.charset.CharsetEncoderICU;
import com.ibm.icu.charset.CharsetICU;
import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.UConverterSharedData;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

class CharsetISO2022
extends CharsetICU {
    private UConverterDataISO2022 myConverterData;
    private int variant;
    private static final byte[] SHIFT_IN_STR = new byte[]{15};
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final char HWKANA_START = '\uff61';
    private static final char HWKANA_END = '\uff9f';
    private static final char GR96_START = '\u00a0';
    private static final char GR96_END = '\u00ff';
    private static final byte INVALID_STATE = -1;
    private static final byte ASCII = 0;
    private static final byte SS2_STATE = 16;
    private static final byte SS3_STATE = 17;
    private static final byte ISO8859_1 = 1;
    private static final byte ISO8859_7 = 2;
    private static final byte JISX201 = 3;
    private static final byte JISX208 = 4;
    private static final byte JISX212 = 5;
    private static final byte GB2312 = 6;
    private static final byte KSC5601 = 7;
    private static final byte HWKANA_7BIT = 8;
    private static final byte GB2312_1 = 1;
    private static final byte ISO_IR_165 = 2;
    private static final byte CNS_11643 = 3;
    private static final byte CNS_11643_0 = 32;
    private static final byte CNS_11643_1 = 33;
    private static final byte CNS_11643_2 = 34;
    private static final byte CNS_11643_3 = 35;
    private static final byte CNS_11643_4 = 36;
    private static final byte CNS_11643_5 = 37;
    private static final byte CNS_11643_6 = 38;
    private static final byte CNS_11643_7 = 39;
    private static final short[] jpCharsetMasks = new short[]{(short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5) | CharsetISO2022.CSM((short)6) | CharsetISO2022.CSM((short)7) | CharsetISO2022.CSM((short)1) | CharsetISO2022.CSM((short)2)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5) | CharsetISO2022.CSM((short)6) | CharsetISO2022.CSM((short)7) | CharsetISO2022.CSM((short)1) | CharsetISO2022.CSM((short)2)), (short)(CharsetISO2022.CSM((short)0) | CharsetISO2022.CSM((short)3) | CharsetISO2022.CSM((short)4) | CharsetISO2022.CSM((short)8) | CharsetISO2022.CSM((short)5) | CharsetISO2022.CSM((short)6) | CharsetISO2022.CSM((short)7) | CharsetISO2022.CSM((short)1) | CharsetISO2022.CSM((short)2))};
    private static final byte UCNV_2022_MAX_CONVERTERS = 10;
    private static final byte ESC_2022 = 27;
    private static final byte INVALID_2022 = -1;
    private static final byte VALID_NON_TERMINAL_2022 = 0;
    private static final byte VALID_TERMINAL_2022 = 1;
    private static final byte VALID_MAYBE_TERMINAL_2022 = 2;
    private static final byte[] normalize_esq_chars_2022 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 4, 7, 29, 0, 2, 24, 26, 27, 0, 3, 23, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 28, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final short MAX_STATES_2022 = 74;
    private static final int[] escSeqStateTable_Key_2022 = new int[]{1, 34, 36, 39, 55, 57, 60, 61, 1093, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1109, 1154, 1157, 1160, 1161, 1176, 1178, 1179, 1254, 1257, 1768, 1773, 1957, 35105, 36933, 36936, 36937, 36938, 36939, 36940, 36942, 36943, 36944, 36945, 36946, 36947, 36948, 37640, 37642, 37644, 37646, 37711, 37744, 37745, 37746, 37747, 37748, 40133, 40136, 40138, 40139, 40140, 40141, 1123363, 35947624, 35947625, 35947626, 35947627, 35947629, 35947630, 35947631, 35947635, 35947636, 35947638};
    private static final byte[] escSeqStateTable_Value_2022 = new byte[]{0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final byte ISO_2022_JP = 1;
    private static final byte ISO_2022_KR = 2;
    private static final byte ISO_2022_CN = 3;
    private static final byte[] nextStateToUnicodeJP = new byte[]{-1, -1, -1, -1, -1, 16, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, 3, 8, 3, -1, -1, -1, 4, 6, 4, -1, -1, -1, -1, -1, 1, 2, 4, -1, -1, -1, -1, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] nextStateToUnicodeCN = new byte[]{-1, -1, -1, -1, -1, 16, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, 2, 33, 34, 35, 36, 37, 38, 39, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] jpCharsetPref = new byte[]{0, 3, 1, 2, 4, 5, 6, 7, 8};
    private static final byte[][] escSeqChars = new byte[][]{{27, 40, 66}, {27, 46, 65}, {27, 46, 70}, {27, 40, 74}, {27, 36, 66}, {27, 36, 40, 68}, {27, 36, 65}, {27, 36, 40, 67}, {27, 40, 73}};
    private static final char[] hwkana_fb = new char[]{'\u2123', '\u2156', '\u2157', '\u2122', '\u2126', '\u2572', '\u2521', '\u2523', '\u2525', '\u2527', '\u2529', '\u2563', '\u2565', '\u2567', '\u2543', '\u213c', '\u2522', '\u2524', '\u2526', '\u2528', '\u252a', '\u252b', '\u252d', '\u252f', '\u2531', '\u2533', '\u2535', '\u2537', '\u2539', '\u253b', '\u253d', '\u253f', '\u2541', '\u2544', '\u2546', '\u2548', '\u254a', '\u254b', '\u254c', '\u254d', '\u254e', '\u254f', '\u2552', '\u2555', '\u2558', '\u255b', '\u255e', '\u255f', '\u2560', '\u2561', '\u2562', '\u2564', '\u2566', '\u2568', '\u2569', '\u256a', '\u256b', '\u256c', '\u256d', '\u256f', '\u2573', '\u212b', '\u212c'};
    protected byte[][] fromUSubstitutionChar = new byte[][]{{26}, {47, 126}};
    private static final byte[] GB_2312_80_STR = new byte[]{27, 36, 41, 65};
    private static final byte[] ISO_IR_165_STR = new byte[]{27, 36, 41, 69};
    private static final byte[] CNS_11643_1992_Plane_1_STR = new byte[]{27, 36, 41, 71};
    private static final byte[] CNS_11643_1992_Plane_2_STR = new byte[]{27, 36, 42, 72};
    private static final byte[] CNS_11643_1992_Plane_3_STR = new byte[]{27, 36, 43, 73};
    private static final byte[] CNS_11643_1992_Plane_4_STR = new byte[]{27, 36, 43, 74};
    private static final byte[] CNS_11643_1992_Plane_5_STR = new byte[]{27, 36, 43, 75};
    private static final byte[] CNS_11643_1992_Plane_6_STR = new byte[]{27, 36, 43, 76};
    private static final byte[] CNS_11643_1992_Plane_7_STR = new byte[]{27, 36, 43, 77};
    private static final byte[][] escSeqCharsCN = new byte[][]{SHIFT_IN_STR, GB_2312_80_STR, ISO_IR_165_STR, CNS_11643_1992_Plane_1_STR, CNS_11643_1992_Plane_2_STR, CNS_11643_1992_Plane_3_STR, CNS_11643_1992_Plane_4_STR, CNS_11643_1992_Plane_5_STR, CNS_11643_1992_Plane_6_STR, CNS_11643_1992_Plane_7_STR};

    public CharsetISO2022(String icuCanonicalName, String javaCanonicalName, String[] aliases) {
        super(icuCanonicalName, javaCanonicalName, aliases);
        int version;
        this.myConverterData = new UConverterDataISO2022();
        int versionIndex = icuCanonicalName.indexOf("version=");
        this.myConverterData.version = version = Integer.decode(icuCanonicalName.substring(versionIndex + 8, versionIndex + 9)).intValue();
        if (icuCanonicalName.indexOf("locale=ja") > 0) {
            this.ISO2022InitJP(version);
        } else if (icuCanonicalName.indexOf("locale=zh") > 0) {
            this.ISO2022InitCN(version);
        } else {
            this.ISO2022InitKR(version);
        }
        this.myConverterData.currentEncoder = (CharsetMBCS.CharsetEncoderMBCS)this.myConverterData.currentConverter.newEncoder();
        this.myConverterData.currentDecoder = (CharsetMBCS.CharsetDecoderMBCS)this.myConverterData.currentConverter.newDecoder();
    }

    private void ISO2022InitJP(int version) {
        this.variant = 1;
        this.maxBytesPerChar = 6;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        if ((jpCharsetMasks[version] & CharsetISO2022.CSM((short)2)) != 0) {
            this.myConverterData.myConverterArray[2] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ISO8859_7")).sharedData;
        }
        this.myConverterData.myConverterArray[4] = ((CharsetMBCS)CharsetICU.forNameICU((String)"Shift-JIS")).sharedData;
        if ((jpCharsetMasks[version] & CharsetISO2022.CSM((short)5)) != 0) {
            this.myConverterData.myConverterArray[5] = ((CharsetMBCS)CharsetICU.forNameICU((String)"jisx-212")).sharedData;
        }
        if ((jpCharsetMasks[version] & CharsetISO2022.CSM((short)6)) != 0) {
            this.myConverterData.myConverterArray[6] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ibm-5478")).sharedData;
        }
        if ((jpCharsetMasks[version] & CharsetISO2022.CSM((short)7)) != 0) {
            this.myConverterData.myConverterArray[7] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ksc_5601")).sharedData;
        }
        this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("icu-internal-25546");
    }

    private void ISO2022InitCN(int version) {
        this.variant = 3;
        this.maxBytesPerChar = 8;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        this.myConverterData.myConverterArray[1] = ((CharsetMBCS)CharsetICU.forNameICU((String)"ibm-5478")).sharedData;
        if (version == 1) {
            this.myConverterData.myConverterArray[2] = ((CharsetMBCS)CharsetICU.forNameICU((String)"iso-ir-165")).sharedData;
        }
        this.myConverterData.myConverterArray[3] = ((CharsetMBCS)CharsetICU.forNameICU((String)"cns-11643-1992")).sharedData;
        this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("icu-internal-25546");
    }

    private void ISO2022InitKR(int version) {
        this.variant = 2;
        this.maxBytesPerChar = 3;
        this.minBytesPerChar = 1;
        this.maxCharsPerByte = 1.0f;
        if (version == 1) {
            this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("icu-internal-25546");
            this.myConverterData.currentConverter.subChar1 = this.fromUSubstitutionChar[0][0];
        } else {
            this.myConverterData.currentConverter = (CharsetMBCS)CharsetICU.forNameICU("ibm-949");
        }
        this.myConverterData.currentEncoder = (CharsetMBCS.CharsetEncoderMBCS)this.myConverterData.currentConverter.newEncoder();
        this.myConverterData.currentDecoder = (CharsetMBCS.CharsetDecoderMBCS)this.myConverterData.currentConverter.newDecoder();
    }

    private static boolean IS_2022_CONTROL(int c) {
        return c < 32 && (1 << c & 0x800C000) != 0;
    }

    private static int _2022FromGR94DBCS(int value) {
        if (value <= 65278 && value >= 41377 && (short)(value & 0xFF) <= 254 && (short)(value & 0xFF) >= 161) {
            return value - 32896;
        }
        return 0;
    }

    private static boolean IS_JP_DBCS(byte cs) {
        return 4 <= cs && cs <= 7;
    }

    private static short CSM(short cs) {
        return (short)(1 << cs);
    }

    private static int getEndOfBuffer_2022(ByteBuffer source) {
        int sourceIndex = source.position();
        byte mySource = 0;
        mySource = source.get(sourceIndex);
        while (source.hasRemaining() && mySource != 27 && (mySource = source.get()) != 27) {
            ++sourceIndex;
        }
        return sourceIndex;
    }

    private int MBCSSimpleGetNextUChar(UConverterSharedData sharedData, ByteBuffer source, boolean useFallback) {
        UConverterSharedData tempSharedData = this.myConverterData.currentConverter.sharedData;
        this.myConverterData.currentConverter.sharedData = sharedData;
        int returnValue = this.myConverterData.currentDecoder.simpleGetNextUChar(source, useFallback);
        this.myConverterData.currentConverter.sharedData = tempSharedData;
        return returnValue;
    }

    static int MBCSSingleFromUChar32(UConverterSharedData sharedData, int c, int[] retval, boolean useFallback) {
        if (c >= 65536 && (sharedData.mbcs.unicodeMask & 1) == 0) {
            return 0;
        }
        char[] table = sharedData.mbcs.fromUnicodeTable;
        char value = CharsetMBCS.MBCS_SINGLE_RESULT_FROM_U(table, sharedData.mbcs.fromUnicodeBytes, c);
        retval[0] = value & 0xFF;
        if (value >= '\u0f00') {
            return 1;
        }
        if (useFallback ? value >= '\u0800' : value >= '\u0c00') {
            return -1;
        }
        return 0;
    }

    private CoderResult changeState_2022(CharsetDecoderICU decoder, ByteBuffer source, int var) {
        CoderResult err = CoderResult.UNDERFLOW;
        boolean DONE = false;
        int[] key = new int[]{this.myConverterData.key};
        int[] offset = new int[]{0};
        int initialToULength = decoder.toULength;
        int malformLength = 0;
        int value = 0;
        while (source.hasRemaining()) {
            byte c = source.get();
            ++malformLength;
            decoder.toUBytesArray[decoder.toULength++] = c;
            value = CharsetISO2022.getKey_2022(c, key, offset);
            switch (value) {
                case 0: {
                    break;
                }
                case 1: {
                    key[0] = 0;
                    DONE = true;
                    break;
                }
                case -1: {
                    DONE = true;
                    break;
                }
                case 2: {
                    value = 1;
                    key[0] = 0;
                    DONE = true;
                }
            }
            if (!DONE) continue;
        }
        this.myConverterData.key = key[0];
        if (value == 0) {
            return err;
        }
        if (value == -1) {
            err = CoderResult.malformedForLength(malformLength);
        } else {
            block6 : switch (var) {
                case 1: {
                    byte tempState = nextStateToUnicodeJP[offset[0]];
                    switch (tempState) {
                        case -1: {
                            err = CoderResult.malformedForLength(malformLength);
                            break block6;
                        }
                        case 16: {
                            if (this.myConverterData.toU2022State.cs[2] != 0) {
                                if (this.myConverterData.toU2022State.g < 2) {
                                    this.myConverterData.toU2022State.prevG = this.myConverterData.toU2022State.g;
                                }
                                this.myConverterData.toU2022State.g = (byte)2;
                                break block6;
                            }
                            err = CoderResult.malformedForLength(malformLength);
                            break block6;
                        }
                        case 1: 
                        case 2: {
                            if ((jpCharsetMasks[this.myConverterData.version] & CharsetISO2022.CSM(tempState)) == 0) {
                                err = CoderResult.unmappableForLength(malformLength);
                                break block6;
                            }
                            ((ISO2022State)this.myConverterData.toU2022State).cs[2] = tempState;
                            break block6;
                        }
                    }
                    if ((jpCharsetMasks[this.myConverterData.version] & CharsetISO2022.CSM(tempState)) == 0) {
                        err = CoderResult.unmappableForLength(source.position() - 1);
                        break;
                    }
                    ((ISO2022State)this.myConverterData.toU2022State).cs[0] = tempState;
                    break;
                }
                case 3: {
                    byte tempState = nextStateToUnicodeCN[offset[0]];
                    switch (tempState) {
                        case -1: {
                            err = CoderResult.unmappableForLength(malformLength);
                            break block6;
                        }
                        case 16: {
                            if (this.myConverterData.toU2022State.cs[2] != 0) {
                                if (this.myConverterData.toU2022State.g < 2) {
                                    this.myConverterData.toU2022State.prevG = this.myConverterData.toU2022State.g;
                                }
                                this.myConverterData.toU2022State.g = (byte)2;
                                break block6;
                            }
                            err = CoderResult.malformedForLength(malformLength);
                            break block6;
                        }
                        case 17: {
                            if (this.myConverterData.toU2022State.cs[3] != 0) {
                                if (this.myConverterData.toU2022State.g < 2) {
                                    this.myConverterData.toU2022State.prevG = this.myConverterData.toU2022State.g;
                                }
                                this.myConverterData.toU2022State.g = (byte)3;
                                break block6;
                            }
                            err = CoderResult.malformedForLength(malformLength);
                            break block6;
                        }
                        case 2: {
                            if (this.myConverterData.version == 0) {
                                err = CoderResult.unmappableForLength(malformLength);
                                break block6;
                            }
                        }
                        case 1: 
                        case 33: {
                            ((ISO2022State)this.myConverterData.toU2022State).cs[1] = tempState;
                            break block6;
                        }
                        case 34: {
                            ((ISO2022State)this.myConverterData.toU2022State).cs[2] = tempState;
                            break block6;
                        }
                    }
                    if (this.myConverterData.version == 0) {
                        err = CoderResult.unmappableForLength(source.position() - 1);
                        break;
                    }
                    ((ISO2022State)this.myConverterData.toU2022State).cs[3] = tempState;
                    break;
                }
                case 2: {
                    if (offset[0] == 48) break;
                    err = CoderResult.unmappableForLength(malformLength);
                    break;
                }
                default: {
                    err = CoderResult.malformedForLength(malformLength);
                }
            }
        }
        if (!err.isError()) {
            decoder.toULength = 0;
        } else if (err.isMalformed() && decoder.toULength > 1) {
            int backOutDistance = decoder.toULength - 1;
            int bytesFromThisBuffer = decoder.toULength - initialToULength;
            if (backOutDistance <= bytesFromThisBuffer) {
                source.position(source.position() - backOutDistance);
            } else {
                decoder.preToULength = (byte)(bytesFromThisBuffer - backOutDistance);
                for (int i = 0; i < -decoder.preToULength; ++i) {
                    decoder.preToUArray[i] = decoder.toUBytesArray[i + 1];
                }
                source.position(source.position() - bytesFromThisBuffer);
            }
            decoder.toULength = 1;
        }
        return err;
    }

    private static byte getKey_2022(byte c, int[] key, int[] offset) {
        int mid;
        int low = 0;
        int hi = 74;
        int oldmid = 0;
        int togo = normalize_esq_chars_2022[(short)c & 0xFF];
        if (togo == 0) {
            key[0] = 0;
            offset[0] = 0;
            return -1;
        }
        togo = (key[0] << 5) + togo;
        while (hi != low && (mid = hi + low >> 1) != oldmid) {
            if (escSeqStateTable_Key_2022[mid] > togo) {
                hi = mid;
            } else if (escSeqStateTable_Key_2022[mid] < togo) {
                low = mid;
            } else {
                key[0] = togo;
                offset[0] = mid;
                return escSeqStateTable_Value_2022[mid];
            }
            oldmid = mid;
        }
        return -1;
    }

    private static CoderResult toUnicodeCallback(CharsetDecoderICU cnv, int sourceChar, int targetUniChar) {
        CoderResult err = CoderResult.UNDERFLOW;
        if (sourceChar > 255) {
            cnv.toUBytesArray[0] = (byte)(sourceChar >> 8);
            cnv.toUBytesArray[1] = (byte)sourceChar;
            cnv.toULength = 2;
        } else {
            cnv.toUBytesArray[0] = (byte)sourceChar;
            cnv.toULength = 1;
        }
        err = targetUniChar == 65534 ? CoderResult.unmappableForLength(1) : CoderResult.malformedForLength(1);
        return err;
    }

    public CharsetDecoder newDecoder() {
        switch (this.variant) {
            case 1: {
                return new CharsetDecoderISO2022JP(this);
            }
            case 3: {
                return new CharsetDecoderISO2022CN(this);
            }
            case 2: {
                this.setInitialStateToUnicodeKR();
                return new CharsetDecoderISO2022KR(this);
            }
        }
        return null;
    }

    public CharsetEncoder newEncoder() {
        switch (this.variant) {
            case 1: {
                return new CharsetEncoderISO2022JP(this);
            }
            case 3: {
                return new CharsetEncoderISO2022CN(this);
            }
            case 2: {
                CharsetEncoderISO2022KR cnv = new CharsetEncoderISO2022KR(this);
                this.setInitialStateFromUnicodeKR(cnv);
                return cnv;
            }
        }
        return null;
    }

    private void setInitialStateToUnicodeKR() {
        if (this.myConverterData.version == 1) {
            this.myConverterData.currentDecoder.toUnicodeStatus = 0;
            this.myConverterData.currentDecoder.mode = 0;
            this.myConverterData.currentDecoder.toULength = 0;
        }
    }

    private void setInitialStateFromUnicodeKR(CharsetEncoderICU cnv) {
        if (cnv.errorBufferLength == 0) {
            cnv.errorBufferLength = 4;
            cnv.errorBuffer[0] = 27;
            cnv.errorBuffer[1] = 36;
            cnv.errorBuffer[2] = 41;
            cnv.errorBuffer[3] = 67;
        }
        if (this.myConverterData.version == 1) {
            ((CharsetMBCS)this.myConverterData.currentEncoder.charset()).subChar1 = (byte)26;
            this.myConverterData.currentEncoder.fromUChar32 = 0;
            this.myConverterData.currentEncoder.fromUnicodeStatus = 1;
        }
    }

    void getUnicodeSetImpl(UnicodeSet setFillIn, int which) {
        switch (this.variant) {
            case 1: {
                setFillIn.add(165);
                setFillIn.add(8254);
                if ((jpCharsetMasks[this.myConverterData.version] & CharsetISO2022.CSM((short)1)) != 0) {
                    setFillIn.add(0, 255);
                } else {
                    setFillIn.add(0, 127);
                }
                if (this.myConverterData.version != 3 && this.myConverterData.version != 4 && which != 1) break;
                setFillIn.add(65377, 65439);
                break;
            }
            case 3: {
                setFillIn.add(0, 127);
                break;
            }
            case 2: {
                this.myConverterData.currentConverter.getUnicodeSetImpl(setFillIn, which);
                break;
            }
        }
        for (int i = 0; i < 10; ++i) {
            if (this.myConverterData.myConverterArray[i] == null) continue;
            int filter = this.variant == 3 && this.myConverterData.version == 0 && i == 3 ? 3 : (this.variant == 1 && i == 4 ? 4 : (i == 7 ? 5 : 1));
            this.myConverterData.currentConverter.MBCSGetFilteredUnicodeSetForUnicode(this.myConverterData.myConverterArray[i], setFillIn, which, filter);
        }
        setFillIn.remove(14);
        setFillIn.remove(15);
        setFillIn.remove(27);
        setFillIn.remove(128, 159);
    }

    private class CharsetEncoderISO2022KR
    extends CharsetEncoderICU {
        public CharsetEncoderISO2022KR(CharsetICU cs) {
            super(cs, CharsetISO2022.this.fromUSubstitutionChar[((CharsetISO2022)CharsetISO2022.this).myConverterData.version]);
        }

        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
            CharsetISO2022.this.setInitialStateFromUnicodeKR(this);
        }

        CoderResult cbFromUWriteSub(CharsetEncoderICU encoder, CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] buffer = new byte[8];
            int i = 0;
            byte[] subchar = encoder.replacement();
            int length = subchar.length;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 0) {
                if (length == 1) {
                    if (encoder.fromUnicodeStatus != 0) {
                        encoder.fromUnicodeStatus = 0;
                        buffer[i++] = 15;
                    }
                    buffer[i++] = subchar[0];
                } else {
                    if (encoder.fromUnicodeStatus == 0) {
                        encoder.fromUnicodeStatus = 1;
                        buffer[i++] = 14;
                    }
                    buffer[i++] = subchar[0];
                    buffer[i++] = subchar[1];
                }
                err = CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, i, target, offsets, source.position() - 1);
            } else {
                byte[] currentSubChars = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.replacement();
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.replaceWith(subchar);
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.subChar1 = CharsetISO2022.this.fromUSubstitutionChar[0][0];
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32 = encoder.fromUChar32;
                err = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.cbFromUWriteSub(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder, source, target, offsets);
                encoder.fromUChar32 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32;
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.replaceWith(currentSubChars);
                if (err.isOverflow()) {
                    if (((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength > 0) {
                        encoder.errorBuffer = (byte[])((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBuffer.clone();
                    }
                    encoder.errorBufferLength = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength = 0;
                }
            }
            return err;
        }

        private CoderResult encodeLoopIBM(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32 = this.fromUChar32;
            err = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.cnvMBCSFromUnicodeWithOffsets(source, target, offsets, flush);
            this.fromUChar32 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32;
            if (err.isOverflow()) {
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength > 0) {
                    this.errorBuffer = (byte[])((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBuffer.clone();
                }
                this.errorBufferLength = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength;
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.errorBufferLength = 0;
            }
            return err;
        }

        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            int[] targetByteUnit = new int[]{0};
            int sourceChar = 0;
            int length = 0;
            boolean gotoGetTrail = false;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                return this.encodeLoopIBM(source, target, offsets, flush);
            }
            boolean usingFallback = this.useFallback;
            boolean isTargetByteDBCS = this.fromUnicodeStatus != 0;
            sourceChar = this.fromUChar32;
            if (sourceChar != 0 && target.hasRemaining()) {
                gotoGetTrail = true;
            }
            while (source.hasRemaining() || gotoGetTrail) {
                targetByteUnit[0] = 65535;
                if (target.hasRemaining() || gotoGetTrail) {
                    if (!gotoGetTrail) {
                        sourceChar = source.get();
                        if (CharsetISO2022.IS_2022_CONTROL(sourceChar)) {
                            err = CoderResult.malformedForLength(1);
                            this.fromUChar32 = sourceChar;
                            break;
                        }
                        ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                        length = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(sourceChar, targetByteUnit, usingFallback);
                        if (length < 0) {
                            length = -length;
                        }
                        if (length > 2 || length == 0 || length == 1 && targetByteUnit[0] > 127 || length == 2 && ((char)(targetByteUnit[0] - 41377) > '\u5d5d' || (targetByteUnit[0] - 161 & 0xFF) > 93)) {
                            targetByteUnit[0] = 65535;
                        }
                    }
                    if (!gotoGetTrail && targetByteUnit[0] != 65535) {
                        boolean oldIsTargetByteDBCS = isTargetByteDBCS;
                        boolean bl = isTargetByteDBCS = targetByteUnit[0] > 255;
                        if (oldIsTargetByteDBCS != isTargetByteDBCS) {
                            if (isTargetByteDBCS) {
                                target.put((byte)14);
                            } else {
                                target.put((byte)15);
                            }
                            if (offsets != null) {
                                offsets.put(source.position() - 1);
                            }
                        }
                        if (targetByteUnit[0] <= 255) {
                            if (target.hasRemaining()) {
                                target.put((byte)targetByteUnit[0]);
                                if (offsets == null) continue;
                                offsets.put(source.position() - 1);
                                continue;
                            }
                            this.errorBuffer[this.errorBufferLength++] = (byte)targetByteUnit[0];
                            err = CoderResult.OVERFLOW;
                            continue;
                        }
                        if (target.hasRemaining()) {
                            target.put((byte)(0xFF & (targetByteUnit[0] >> 8) - 128));
                            if (offsets != null) {
                                offsets.put(source.position() - 1);
                            }
                            if (target.hasRemaining()) {
                                target.put((byte)(0xFF & targetByteUnit[0] - 128));
                                if (offsets == null) continue;
                                offsets.put(source.position() - 1);
                                continue;
                            }
                            this.errorBuffer[this.errorBufferLength++] = (byte)(0xFF & targetByteUnit[0] - 128);
                            err = CoderResult.OVERFLOW;
                            continue;
                        }
                        this.errorBuffer[this.errorBufferLength++] = (byte)(0xFF & (targetByteUnit[0] >> 8) - 128);
                        this.errorBuffer[this.errorBufferLength++] = (byte)(0xFF & targetByteUnit[0] - 128);
                        err = CoderResult.OVERFLOW;
                        continue;
                    }
                    if (gotoGetTrail || UTF16.isSurrogate((char)((char)sourceChar))) {
                        if (gotoGetTrail || UTF16.isLeadSurrogate((char)((char)sourceChar))) {
                            gotoGetTrail = false;
                            if (source.hasRemaining()) {
                                char trail = source.get();
                                source.position(source.position() - 1);
                                if (UTF16.isTrailSurrogate((char)trail)) {
                                    source.get();
                                    sourceChar = UCharacter.getCodePoint((char)((char)sourceChar), (char)trail);
                                    err = CoderResult.unmappableForLength(2);
                                } else {
                                    err = CoderResult.malformedForLength(1);
                                }
                            } else {
                                err = CoderResult.UNDERFLOW;
                            }
                        } else {
                            err = CoderResult.malformedForLength(1);
                        }
                    } else {
                        err = CoderResult.unmappableForLength(1);
                    }
                    this.fromUChar32 = sourceChar;
                    break;
                }
                err = CoderResult.OVERFLOW;
                break;
            }
            if (!err.isError() && isTargetByteDBCS && flush && !source.hasRemaining() && this.fromUChar32 == 0) {
                isTargetByteDBCS = false;
                int sourceIndex = source.position();
                if (sourceIndex > 0) {
                    if (UTF16.isTrailSurrogate((char)source.get(--sourceIndex)) && UTF16.isLeadSurrogate((char)source.get(sourceIndex - 1))) {
                        --sourceIndex;
                    }
                } else {
                    sourceIndex = -1;
                }
                CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, target, offsets, sourceIndex);
            }
            this.fromUnicodeStatus = isTargetByteDBCS ? 1 : 0;
            return err;
        }
    }

    private class CharsetEncoderISO2022CN
    extends CharsetEncoderICU {
        public CharsetEncoderISO2022CN(CharsetICU cs) {
            super(cs, CharsetISO2022.this.fromUSubstitutionChar[0]);
        }

        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        CoderResult cbFromUWriteSub(CharsetEncoderICU encoder, CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] buffer = new byte[8];
            int i = 0;
            byte[] subchar = encoder.replacement();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g != 0) {
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                buffer[i++] = 15;
            }
            buffer[i++] = subchar[0];
            err = CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, i, target, offsets, source.position() - 1);
            return err;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            int sourceIndex;
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] buffer = new byte[8];
            byte[] choices = new byte[3];
            int targetValue = 0;
            boolean gotoGetTrail = false;
            int choiceCount = 0;
            int sourceChar = this.fromUChar32;
            if (sourceChar != 0 && target.hasRemaining()) {
                gotoGetTrail = true;
            }
            while (source.hasRemaining() || gotoGetTrail) {
                int len;
                block49: {
                    boolean usingFallback;
                    byte cs;
                    byte g;
                    int oldSourcePos;
                    block50: {
                        block47: {
                            block48: {
                                block46: {
                                    if (!target.hasRemaining() && !gotoGetTrail) break block47;
                                    oldSourcePos = source.position();
                                    if (!gotoGetTrail) {
                                        sourceChar = source.get();
                                    }
                                    if (UTF16.isSurrogate((char)((char)sourceChar)) || gotoGetTrail) {
                                        if (UTF16.isLeadSurrogate((char)((char)sourceChar)) || gotoGetTrail) {
                                            gotoGetTrail = false;
                                            if (source.hasRemaining()) {
                                                char trail = source.get();
                                                source.position(source.position() - 1);
                                                if (UTF16.isTrailSurrogate((char)trail)) {
                                                    source.get();
                                                    sourceChar = UCharacter.getCodePoint((char)((char)sourceChar), (char)trail);
                                                    this.fromUChar32 = 0;
                                                    break block46;
                                                } else {
                                                    err = CoderResult.malformedForLength(1);
                                                    this.fromUChar32 = sourceChar;
                                                    break;
                                                }
                                            }
                                            this.fromUChar32 = sourceChar;
                                            break;
                                        }
                                        err = CoderResult.malformedForLength(1);
                                        this.fromUChar32 = sourceChar;
                                        break;
                                    }
                                }
                                if (sourceChar > 127) break block48;
                                if (CharsetISO2022.IS_2022_CONTROL(sourceChar)) {
                                    err = CoderResult.malformedForLength(1);
                                    this.fromUChar32 = sourceChar;
                                    break;
                                }
                                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 0) {
                                    buffer[0] = (byte)sourceChar;
                                    len = 1;
                                } else {
                                    buffer[0] = 15;
                                    buffer[1] = (byte)sourceChar;
                                    len = 2;
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                                    choiceCount = 0;
                                }
                                if (sourceChar == 13 || sourceChar == 10) {
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.reset();
                                    choiceCount = 0;
                                }
                                break block49;
                            }
                            if (choiceCount == 0) {
                                choices[0] = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[1];
                                if (choices[0] == 0) {
                                    choices[0] = 1;
                                }
                                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 0) {
                                    choices[1] = choices[0] == 1 ? 33 : 1;
                                    choiceCount = 2;
                                } else if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                                    switch (choices[0]) {
                                        case 1: {
                                            choices[1] = 33;
                                            choices[2] = 2;
                                            break;
                                        }
                                        case 2: {
                                            choices[1] = 1;
                                            choices[2] = 33;
                                            break;
                                        }
                                        default: {
                                            choices[1] = 1;
                                            choices[2] = 2;
                                        }
                                    }
                                    choiceCount = 3;
                                } else {
                                    choices[0] = 33;
                                    choices[1] = 1;
                                    choiceCount = 2;
                                }
                            }
                            g = 0;
                            cs = 0;
                            len = 0;
                            usingFallback = this.useFallback;
                            break block50;
                        }
                        err = CoderResult.OVERFLOW;
                        break;
                    }
                    for (int i = 0; i < choiceCount && len <= 0; ++i) {
                        int len2;
                        byte cs0 = choices[i];
                        if (cs0 <= 0) continue;
                        int[] value = new int[1];
                        if (cs0 > 32) {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[3];
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = (short)2;
                            len2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(sourceChar, value, usingFallback);
                            if (len2 != 3 && (len2 != -3 || len != 0)) continue;
                            targetValue = value[0];
                            cs = (byte)(32 + (value[0] >> 16) - 128);
                            if (len2 >= 0) {
                                len = 2;
                            } else {
                                len = -2;
                                usingFallback = false;
                            }
                            if (cs == 33) {
                                g = 1;
                                continue;
                            }
                            if (cs == 34) {
                                g = 2;
                                continue;
                            }
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                                g = 3;
                                continue;
                            }
                            len = 0;
                            continue;
                        }
                        ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[cs0];
                        ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                        len2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(sourceChar, value, usingFallback);
                        if (len2 != 2 && (len2 != -2 || len != 0)) continue;
                        targetValue = value[0];
                        len = len2;
                        cs = cs0;
                        g = 1;
                        usingFallback = false;
                    }
                    if (len == 0) {
                        err = CoderResult.unmappableForLength(source.position() - oldSourcePos);
                        this.fromUChar32 = sourceChar;
                        break;
                    }
                    len = 0;
                    if (cs != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[g]) {
                        int n;
                        if (cs < 3) {
                            for (n = 0; n < escSeqCharsCN[cs].length; ++n) {
                                buffer[n] = escSeqCharsCN[cs][n];
                            }
                        } else {
                            for (n = 0; n < escSeqCharsCN[3 + (cs - 33)].length; ++n) {
                                buffer[n] = escSeqCharsCN[3 + (cs - 33)][n];
                            }
                        }
                        len = 4;
                        ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[g] = cs;
                        if (g == 1) {
                            choiceCount = 0;
                        }
                    }
                    if (g != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g) {
                        switch (g) {
                            case 1: {
                                buffer[len++] = 14;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)1;
                                break;
                            }
                            case 2: {
                                buffer[len++] = 27;
                                buffer[len++] = 78;
                                break;
                            }
                            default: {
                                buffer[len++] = 27;
                                buffer[len++] = 79;
                            }
                        }
                    }
                    buffer[len++] = (byte)(targetValue >> 8);
                    buffer[len++] = (byte)targetValue;
                }
                if (len == 1) {
                    target.put(buffer[0]);
                    if (offsets == null) continue;
                    offsets.put(source.position() - 1);
                    continue;
                }
                if (len == 2 && target.remaining() >= 2) {
                    target.put(buffer[0]);
                    target.put(buffer[1]);
                    if (offsets == null) continue;
                    sourceIndex = source.position();
                    offsets.put(sourceIndex);
                    offsets.put(sourceIndex);
                    continue;
                }
                err = CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, len, target, offsets, source.position() - 1);
                if (!err.isError()) continue;
            }
            if (err.isError()) return err;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 0) return err;
            if (!flush) return err;
            if (source.hasRemaining()) return err;
            if (this.fromUChar32 != 0) return err;
            ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
            sourceIndex = source.position();
            if (sourceIndex > 0) {
                if (!UTF16.isTrailSurrogate((char)source.get(--sourceIndex))) return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, target, offsets, sourceIndex);
                if (sourceIndex != 0) {
                    if (!UTF16.isLeadSurrogate((char)source.get(sourceIndex - 1))) return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, target, offsets, sourceIndex);
                }
                --sourceIndex;
                return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, target, offsets, sourceIndex);
            } else {
                sourceIndex = -1;
            }
            return CharsetEncoderICU.fromUWriteBytes(this, SHIFT_IN_STR, 0, 1, target, offsets, sourceIndex);
        }
    }

    private class CharsetEncoderISO2022JP
    extends CharsetEncoderICU {
        public CharsetEncoderISO2022JP(CharsetICU cs) {
            super(cs, CharsetISO2022.this.fromUSubstitutionChar[0]);
        }

        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        private int jisx201FromU(int value) {
            if (value <= 127) {
                if (value != 92 && value != 126) {
                    return value;
                }
            } else {
                if (value == 165) {
                    return 92;
                }
                if (value == 8254) {
                    return 126;
                }
            }
            return 65534;
        }

        private int _2022FromSJIS(int value) {
            if (value > 61436) {
                return 0;
            }
            short trail = (short)(value & 0xFF);
            value = (value &= 0xFF00) <= 40704 ? (value -= 28672) : (value -= 45056);
            value <<= 1;
            if (trail <= 158) {
                value -= 256;
                value = trail <= 126 ? (value |= trail - 31 & 0xFF) : (value |= trail - 32 & 0xFF);
            } else {
                value |= trail - 126 & 0xFF;
            }
            return value;
        }

        CoderResult cbFromUWriteSub(CharsetEncoderICU encoder, CharBuffer source, ByteBuffer target, IntBuffer offsets) {
            byte cs;
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] buffer = new byte[8];
            int i = 0;
            byte[] subchar = encoder.replacement();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 1) {
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                buffer[i++] = 15;
            }
            if ((cs = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0]) != 0 && cs != 3) {
                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[0] = 0;
                buffer[i++] = 27;
                buffer[i++] = 40;
                buffer[i++] = 66;
            }
            buffer[i++] = subchar[0];
            err = CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, i, target, offsets, source.position() - 1);
            return err;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer target, IntBuffer offsets, boolean flush) {
            int sourceIndex;
            int outLen;
            int i;
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] choices = new byte[10];
            int targetValue = 0;
            byte[] buffer = new byte[8];
            boolean getTrail = false;
            int choiceCount = 0;
            int sourceChar = this.fromUChar32;
            if (sourceChar != 0 && target.hasRemaining()) {
                getTrail = true;
            }
            while (getTrail || source.hasRemaining()) {
                int i2;
                boolean usingFallback;
                int len;
                byte g;
                byte cs;
                int oldSourcePos;
                if (getTrail || target.hasRemaining()) {
                    block50: {
                        oldSourcePos = source.position();
                        if (!getTrail) {
                            sourceChar = source.get();
                        }
                        if (getTrail || UTF16.isSurrogate((char)((char)sourceChar))) {
                            if (getTrail || UTF16.isLeadSurrogate((char)((char)sourceChar))) {
                                if (getTrail) {
                                    getTrail = false;
                                }
                                if (source.hasRemaining()) {
                                    char trail = source.get();
                                    source.position(source.position() - 1);
                                    if (UTF16.isTrailSurrogate((char)trail)) {
                                        source.get();
                                        sourceChar = UCharacter.getCodePoint((char)((char)sourceChar), (char)trail);
                                        this.fromUChar32 = 0;
                                        break block50;
                                    } else {
                                        err = CoderResult.malformedForLength(1);
                                        this.fromUChar32 = sourceChar;
                                        break;
                                    }
                                }
                                this.fromUChar32 = sourceChar;
                                break;
                            }
                            err = CoderResult.malformedForLength(1);
                            this.fromUChar32 = sourceChar;
                            break;
                        }
                    }
                    if (CharsetISO2022.IS_2022_CONTROL(sourceChar)) {
                        err = CoderResult.malformedForLength(1);
                        this.fromUChar32 = sourceChar;
                        break;
                    }
                    if (choiceCount == 0) {
                        char csm = (char)jpCharsetMasks[((CharsetISO2022)CharsetISO2022.this).myConverterData.version];
                        choiceCount = 0;
                        if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3 || ((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 4) {
                            choices[choiceCount++] = 8;
                        }
                        csm = (char)(csm & ~CharsetISO2022.CSM((short)8));
                        choices[choiceCount++] = cs = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0];
                        csm = (char)(csm & ~CharsetISO2022.CSM(cs));
                        cs = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[2];
                        if (cs != 0) {
                            choices[choiceCount++] = cs;
                            csm = (char)(csm & ~CharsetISO2022.CSM(cs));
                        }
                        for (i = 0; i < jpCharsetPref.length; ++i) {
                            cs = jpCharsetPref[i];
                            if ((CharsetISO2022.CSM(cs) & csm) == 0) continue;
                            choices[choiceCount++] = cs;
                            csm = (char)(csm & ~CharsetISO2022.CSM(cs));
                        }
                    }
                    g = 0;
                    cs = 0;
                    len = 0;
                    usingFallback = this.useFallback;
                } else {
                    err = CoderResult.OVERFLOW;
                    break;
                }
                block13: for (i2 = 0; i2 < choiceCount && len <= 0; ++i2) {
                    int[] value = new int[1];
                    byte cs0 = choices[i2];
                    switch (cs0) {
                        case 0: {
                            if (sourceChar > 127) continue block13;
                            targetValue = sourceChar;
                            len = 1;
                            cs = cs0;
                            g = 0;
                            continue block13;
                        }
                        case 1: {
                            if (160 > sourceChar || sourceChar > 255) continue block13;
                            targetValue = sourceChar - 128;
                            len = 1;
                            cs = cs0;
                            g = 2;
                            continue block13;
                        }
                        case 8: {
                            if (sourceChar > 65439 || sourceChar < 65377) continue block13;
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3) {
                                targetValue = (int)(0xFFFFFFFFL & (long)(sourceChar - 65344));
                                len = 1;
                                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[1] = cs = cs0;
                                g = 1;
                                continue block13;
                            }
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version != 4) continue block13;
                            targetValue = (int)(0xFFFFFFFFL & (long)(sourceChar - 65216));
                            len = 1;
                            cs = ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0];
                            if (CharsetISO2022.IS_JP_DBCS(cs)) {
                                cs = 3;
                            }
                            g = 0;
                            continue block13;
                        }
                        case 3: {
                            value[0] = this.jisx201FromU(sourceChar);
                            if (value[0] > 127) continue block13;
                            targetValue = value[0];
                            len = 1;
                            cs = cs0;
                            g = 0;
                            usingFallback = false;
                            continue block13;
                        }
                        case 4: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[cs0];
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                            int len2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(sourceChar, value, usingFallback);
                            if (len2 == 2 || len2 == -2 && len == 0) {
                                value[0] = this._2022FromSJIS(value[0]);
                                if (value[0] == 0) continue block13;
                                targetValue = value[0];
                                len = len2;
                                cs = cs0;
                                g = 0;
                                usingFallback = false;
                                continue block13;
                            }
                            if (len != 0 || !usingFallback || sourceChar > 65439 || sourceChar < 65377) continue block13;
                            targetValue = hwkana_fb[sourceChar - 65377];
                            len = -2;
                            cs = cs0;
                            g = 0;
                            usingFallback = false;
                            continue block13;
                        }
                        case 2: {
                            int len2 = CharsetISO2022.MBCSSingleFromUChar32(((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[cs0], sourceChar, value, usingFallback);
                            if (len2 == 0 || len2 < 0 && len != 0 || 160 > value[0] || value[0] > 255) continue block13;
                            targetValue = value[0] - 128;
                            len = len2;
                            cs = cs0;
                            g = 2;
                            usingFallback = false;
                            continue block13;
                        }
                        default: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[cs0];
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData.mbcs.outputType = 1;
                            int len2 = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentEncoder.fromUChar32(sourceChar, value, usingFallback);
                            if (len2 != 2 && (len2 != -2 || len != 0)) continue block13;
                            if (cs0 == 7) {
                                value[0] = CharsetISO2022._2022FromGR94DBCS(value[0]);
                                if (value[0] == 0) continue block13;
                            }
                            targetValue = value[0];
                            len = len2;
                            cs = cs0;
                            g = 0;
                            usingFallback = false;
                        }
                    }
                }
                if (len == 0) {
                    err = CoderResult.unmappableForLength(source.position() - oldSourcePos);
                    this.fromUChar32 = sourceChar;
                    break;
                }
                if (len < 0) {
                    len = -len;
                }
                outLen = 0;
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 1 && g == 0) {
                    buffer[outLen++] = 15;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
                }
                if (cs != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[g]) {
                    for (i2 = 0; i2 < escSeqChars[cs].length; ++i2) {
                        buffer[outLen++] = escSeqChars[cs][i2];
                    }
                    ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[g] = cs;
                    choiceCount = 0;
                }
                if (g != ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g) {
                    switch (g) {
                        case 1: {
                            buffer[outLen++] = 14;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)1;
                            break;
                        }
                        default: {
                            buffer[outLen++] = 27;
                            buffer[outLen++] = 78;
                        }
                    }
                }
                if (len == 1) {
                    buffer[outLen++] = (byte)targetValue;
                } else {
                    buffer[outLen++] = (byte)(targetValue >> 8);
                    buffer[outLen++] = (byte)targetValue;
                }
                if (sourceChar == 13 || sourceChar == 10) {
                    ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[2] = 0;
                    choiceCount = 0;
                }
                if (outLen == 1) {
                    target.put(buffer[0]);
                    if (offsets == null) continue;
                    offsets.put(source.remaining() - 1);
                    continue;
                }
                if (outLen == 2 && target.position() + 2 <= target.limit()) {
                    target.put(buffer[0]);
                    target.put(buffer[1]);
                    if (offsets == null) continue;
                    sourceIndex = source.position() - 1;
                    offsets.put(sourceIndex);
                    offsets.put(sourceIndex);
                    continue;
                }
                err = CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, outLen, target, offsets, source.position() - 1);
            }
            if (err.isError()) return err;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g == 0) {
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0] == 0) return err;
            }
            if (!flush) return err;
            if (source.hasRemaining()) return err;
            if (this.fromUChar32 != 0) return err;
            outLen = 0;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g != 0) {
                buffer[outLen++] = 15;
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.g = (byte)0;
            }
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State.cs[0] != 0) {
                for (i = 0; i < escSeqChars[0].length; ++i) {
                    buffer[outLen++] = escSeqChars[0][i];
                }
                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.fromU2022State).cs[0] = 0;
            }
            if ((sourceIndex = source.position()) > 0) {
                if (!UTF16.isTrailSurrogate((char)source.get(--sourceIndex))) return CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, outLen, target, offsets, sourceIndex);
                if (sourceIndex != 0) {
                    if (!UTF16.isLeadSurrogate((char)source.get(sourceIndex - 1))) return CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, outLen, target, offsets, sourceIndex);
                }
                --sourceIndex;
                return CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, outLen, target, offsets, sourceIndex);
            } else {
                sourceIndex = -1;
            }
            return CharsetEncoderICU.fromUWriteBytes(this, buffer, 0, outLen, target, offsets, sourceIndex);
        }
    }

    private class CharsetDecoderISO2022KR
    extends CharsetDecoderICU {
        public CharsetDecoderISO2022KR(CharsetICU cs) {
            super(cs);
        }

        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.setInitialStateToUnicodeKR();
            CharsetISO2022.this.myConverterData.reset();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            int mySourceChar = 0;
            int targetUniChar = 0;
            byte[] tempBuf = new byte[2];
            boolean gotoGetTrailByte = false;
            boolean gotoEscape = false;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 1) {
                return this.decodeLoopIBM(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentDecoder, source, target, offsets, flush);
            }
            boolean usingFallback = this.isFallbackUsed();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                gotoEscape = true;
            } else if (this.toULength == 1 && source.hasRemaining() && target.hasRemaining()) {
                mySourceChar = this.toUBytesArray[0] & 0xFF;
                this.toULength = 0;
                gotoGetTrailByte = true;
            }
            while (true) {
                if (!source.hasRemaining() && !gotoGetTrailByte) {
                    if (!gotoEscape) return err;
                }
                if (!target.hasRemaining() && !gotoGetTrailByte) {
                    if (!gotoEscape) return CoderResult.OVERFLOW;
                }
                if (!gotoGetTrailByte && !gotoEscape) {
                    mySourceChar = (char)(source.get() & 0xFF);
                }
                if (!gotoGetTrailByte && !gotoEscape && mySourceChar == 15) {
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                    if (!((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) continue;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                    err = CoderResult.malformedForLength(1);
                    this.toUBytesArray[0] = (byte)mySourceChar;
                    this.toULength = 1;
                    return err;
                }
                if (!gotoGetTrailByte && !gotoEscape && mySourceChar == 14) {
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)1;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = true;
                    continue;
                }
                if (!gotoGetTrailByte && (gotoEscape || mySourceChar == 27)) {
                    if (!gotoEscape) {
                        source.position(source.position() - 1);
                    }
                    gotoEscape = false;
                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                    err = CharsetISO2022.this.changeState_2022(this, source, 2);
                    if (!err.isError()) continue;
                    return err;
                }
                ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g == 1 || gotoGetTrailByte) {
                    boolean trailIsOk;
                    if (!source.hasRemaining() && !gotoGetTrailByte) break;
                    gotoGetTrailByte = false;
                    short trailByte = (short)(source.get(source.position()) & 0xFF);
                    targetUniChar = 65535;
                    boolean leadIsOk = (short)(0xFF & mySourceChar - 33) <= 93;
                    boolean bl = trailIsOk = (short)(0xFF & trailByte - 33) <= 93;
                    if (leadIsOk && trailIsOk) {
                        source.get();
                        tempBuf[0] = (byte)(mySourceChar + 128);
                        tempBuf[1] = (byte)(trailByte + 128);
                        targetUniChar = CharsetISO2022.this.MBCSSimpleGetNextUChar(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData, ByteBuffer.wrap(tempBuf), usingFallback);
                        mySourceChar = (char)(mySourceChar << 8 | trailByte);
                    } else if (!trailIsOk && !CharsetISO2022.IS_2022_CONTROL(trailByte)) {
                        source.get();
                        mySourceChar = (char)(0x10000 | mySourceChar << 8 | trailByte);
                    }
                } else if (mySourceChar <= 127) {
                    int savedSourceLimit = source.limit();
                    int savedSourcePosition = source.position();
                    source.limit(source.position());
                    source.position(source.position() - 1);
                    targetUniChar = CharsetISO2022.this.MBCSSimpleGetNextUChar(((CharsetISO2022)CharsetISO2022.this).myConverterData.currentConverter.sharedData, source, usingFallback);
                    source.limit(savedSourceLimit);
                    source.position(savedSourcePosition);
                } else {
                    targetUniChar = 65535;
                }
                if (targetUniChar >= 65534) return CharsetISO2022.toUnicodeCallback(this, mySourceChar, targetUniChar);
                target.put((char)targetUniChar);
                if (offsets == null) continue;
                offsets.array()[target.position()] = source.position() - (mySourceChar <= 255 ? 1 : 2);
            }
            this.toUBytesArray[0] = (byte)mySourceChar;
            this.toULength = 1;
            return err;
        }

        protected CoderResult decodeLoopIBM(CharsetMBCS.CharsetDecoderMBCS cnv, ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            int argSource;
            CoderResult err = CoderResult.UNDERFLOW;
            boolean gotoEscape = false;
            int sourceStart = argSource = source.position();
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                gotoEscape = true;
            }
            while (gotoEscape || !err.isError() && source.hasRemaining()) {
                if (!gotoEscape) {
                    int oldSourcePos = source.position();
                    int sourceLimit = CharsetISO2022.getEndOfBuffer_2022(source);
                    source.position(oldSourcePos);
                    if (source.position() != sourceLimit) {
                        if (this.toULength > 0) {
                            cnv.toUBytesArray = (byte[])this.toUBytesArray.clone();
                        }
                        cnv.toULength = this.toULength;
                        int argTarget = target.position();
                        int oldSourceLimit = source.limit();
                        source.limit(sourceLimit);
                        err = ((CharsetISO2022)CharsetISO2022.this).myConverterData.currentDecoder.cnvMBCSToUnicodeWithOffsets(source, target, offsets, flush);
                        source.limit(oldSourceLimit);
                        if (offsets != null && sourceStart != argSource) {
                            int delta = argSource - sourceStart;
                            while (argTarget < target.position()) {
                                int currentOffset = offsets.get();
                                offsets.position(offsets.position() - 1);
                                if (currentOffset >= 0) {
                                    offsets.put(currentOffset + delta);
                                    offsets.position(offsets.position() - 1);
                                }
                                offsets.get();
                                target.get();
                            }
                        }
                        argSource = source.position();
                        if (cnv.toULength > 0) {
                            this.toUBytesArray = (byte[])cnv.toUBytesArray.clone();
                        }
                        this.toULength = cnv.toULength;
                        if (err.isOverflow()) {
                            if (cnv.charErrorBufferLength > 0) {
                                this.charErrorBufferArray = (char[])cnv.charErrorBufferArray.clone();
                            }
                            this.charErrorBufferLength = cnv.charErrorBufferLength;
                            cnv.charErrorBufferLength = 0;
                        }
                    }
                    if (err.isError() || err.isOverflow() || source.position() == source.limit()) {
                        return err;
                    }
                }
                gotoEscape = false;
                err = CharsetISO2022.this.changeState_2022(this, source, 2);
            }
            return err;
        }
    }

    private class CharsetDecoderISO2022CN
    extends CharsetDecoderICU {
        public CharsetDecoderISO2022CN(CharsetICU cs) {
            super(cs);
        }

        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] tempBuf = new byte[3];
            int targetUniChar = 0;
            int mySourceChar = 0;
            int mySourceCharTemp = 0;
            boolean gotoEscape = false;
            boolean gotoGetTrailByte = false;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                gotoEscape = true;
            } else if (this.toULength == 1 && source.hasRemaining() && target.hasRemaining()) {
                mySourceChar = this.toUBytesArray[0] & 0xFF;
                this.toULength = 0;
                targetUniChar = 65535;
                gotoGetTrailByte = true;
            }
            block6: while (source.hasRemaining() || gotoGetTrailByte || gotoEscape) {
                targetUniChar = 65535;
                if (target.hasRemaining() || gotoEscape) {
                    mySourceCharTemp = gotoEscape ? (mySourceChar = 27) : (gotoGetTrailByte ? 255 : (mySourceChar = 0xFF & source.get()));
                    switch (mySourceCharTemp) {
                        case 15: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                            if (!((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) continue block6;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            err = CoderResult.malformedForLength(1);
                            this.toUBytesArray[0] = (byte)mySourceChar;
                            this.toULength = 1;
                            return err;
                        }
                        case 14: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[1] != 0) {
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)1;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = true;
                                continue block6;
                            }
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            break;
                        }
                        case 27: {
                            if (!gotoEscape) {
                                source.position(source.position() - 1);
                            }
                            gotoEscape = false;
                            int mySourceBefore = source.position();
                            int toULengthBefore = this.toULength;
                            err = CharsetISO2022.this.changeState_2022(this, source, 3);
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key == 0 && !err.isError() && ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) {
                                err = CoderResult.malformedForLength(source.position() - mySourceBefore);
                                this.toULength = toULengthBefore + (source.position() - mySourceBefore);
                            }
                            if (!err.isError()) continue block6;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            return err;
                        }
                        case 10: 
                        case 13: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.reset();
                        }
                        default: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g != 0 || gotoGetTrailByte) {
                                if (source.hasRemaining() || gotoGetTrailByte) {
                                    boolean trailIsOk;
                                    gotoGetTrailByte = false;
                                    short trailByte = (short)(source.get(source.position()) & 0xFF);
                                    boolean leadIsOk = (short)(0xFF & mySourceChar - 33) <= 93;
                                    boolean bl = trailIsOk = (short)(0xFF & trailByte - 33) <= 93;
                                    if (leadIsOk && trailIsOk) {
                                        int tempBufLen;
                                        UConverterSharedData cnv;
                                        source.get();
                                        byte tempState = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g];
                                        if (tempState > 32) {
                                            cnv = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[3];
                                            tempBuf[0] = (byte)(128 + (tempState - 32));
                                            tempBuf[1] = (byte)mySourceChar;
                                            tempBuf[2] = (byte)trailByte;
                                            tempBufLen = 3;
                                        } else {
                                            cnv = ((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[tempState];
                                            tempBuf[0] = (byte)mySourceChar;
                                            tempBuf[1] = (byte)trailByte;
                                            tempBufLen = 2;
                                        }
                                        ByteBuffer tempBuffer = ByteBuffer.wrap(tempBuf);
                                        tempBuffer.limit(tempBufLen);
                                        targetUniChar = CharsetISO2022.this.MBCSSimpleGetNextUChar(cnv, tempBuffer, false);
                                        mySourceChar = mySourceChar << 8 | trailByte;
                                    } else if (!trailIsOk && !CharsetISO2022.IS_2022_CONTROL(trailByte)) {
                                        source.get();
                                        mySourceChar = 0x10000 | mySourceChar << 8 | trailByte;
                                    }
                                    if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g < 2) break;
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                    break;
                                }
                                this.toUBytesArray[0] = (byte)mySourceChar;
                                this.toULength = 1;
                                return err;
                            }
                            if (mySourceChar > 127) break;
                            targetUniChar = (char)mySourceChar;
                        }
                    }
                    if ((0xFFFFFFFFL & (long)targetUniChar) < 65534L) {
                        if (offsets != null) {
                            offsets.array()[target.position()] = source.remaining() - (mySourceChar <= 255 ? 1 : 2);
                        }
                        target.put((char)targetUniChar);
                        continue;
                    }
                    if ((0xFFFFFFFFL & (long)targetUniChar) > 65535L) {
                        target.put((char)(55296 + (char)((targetUniChar -= 65536) >> 10)));
                        if (offsets != null) {
                            offsets.array()[target.position() - 1] = source.position() - (mySourceChar <= 255 ? 1 : 2);
                        }
                        if (target.hasRemaining()) {
                            target.put((char)(56320 + (char)(targetUniChar & 0x3FF)));
                            if (offsets == null) continue;
                            offsets.array()[target.position() - 1] = source.position() - (mySourceChar <= 255 ? 1 : 2);
                            continue;
                        }
                        this.charErrorBufferArray[this.charErrorBufferLength++] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                        continue;
                    }
                    err = CharsetISO2022.toUnicodeCallback(this, mySourceChar, targetUniChar);
                    break;
                }
                err = CoderResult.OVERFLOW;
                break;
            }
            return err;
        }
    }

    private class CharsetDecoderISO2022JP
    extends CharsetDecoderICU {
        public CharsetDecoderISO2022JP(CharsetICU cs) {
            super(cs);
        }

        protected void implReset() {
            super.implReset();
            CharsetISO2022.this.myConverterData.reset();
        }

        private int jisx201ToU(int value) {
            if (value < 92) {
                return value;
            }
            if (value == 92) {
                return 165;
            }
            if (value == 126) {
                return 8254;
            }
            return value;
        }

        private void _2022ToSJIS(char c1, char c2, byte[] bytes) {
            if ((c1 & '\u0001') > 0) {
                c1 = (char)(c1 + '\u0001');
                c2 = c2 <= '_' ? (char)(c2 + 31) : (c2 <= '~' ? (char)(c2 + 32) : (char)'\u0000');
            } else {
                c2 = c2 >= '!' && c2 <= '~' ? (char)(c2 + 126) : (char)'\u0000';
            }
            c1 = (char)(c1 >> 1);
            c1 = c1 <= '/' ? (char)(c1 + 112) : (c1 <= '?' ? (char)(c1 + 176) : (char)'\u0000');
            bytes[0] = (byte)(0xFF & c1);
            bytes[1] = (byte)(0xFF & c2);
        }

        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target, IntBuffer offsets, boolean flush) {
            byte cs;
            boolean gotoGetTrail = false;
            boolean gotoEscape = false;
            CoderResult err = CoderResult.UNDERFLOW;
            byte[] tempBuf = new byte[2];
            int targetUniChar = 0;
            int mySourceChar = 0;
            int mySourceCharTemp = 0;
            byte csTemp = 0;
            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) {
                gotoEscape = true;
            } else if (this.toULength == 1 && source.hasRemaining() && target.hasRemaining()) {
                mySourceChar = this.toUBytesArray[0] & 0xFF;
                this.toULength = 0;
                cs = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g];
                mySourceCharTemp = 153;
                gotoGetTrail = true;
            }
            block13: while (source.hasRemaining() || gotoEscape || gotoGetTrail) {
                if (gotoEscape) {
                    mySourceCharTemp = 27;
                }
                targetUniChar = 65535;
                if (gotoEscape || gotoGetTrail || target.hasRemaining()) {
                    if (!gotoEscape && !gotoGetTrail) {
                        mySourceCharTemp = mySourceChar = source.get() & 0xFF;
                    }
                    block0 : switch (mySourceCharTemp) {
                        case 15: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3) {
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                                continue block13;
                            }
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            break;
                        }
                        case 14: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 3) {
                                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State).cs[1] = 8;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)1;
                                continue block13;
                            }
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            break;
                        }
                        case 27: {
                            if (!gotoEscape) {
                                source.position(source.position() - 1);
                            } else {
                                gotoEscape = false;
                            }
                            int mySourceBefore = source.position();
                            int toULengthBefore = this.toULength;
                            err = CharsetISO2022.this.changeState_2022(this, source, CharsetISO2022.this.variant);
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 0 && ((CharsetISO2022)CharsetISO2022.this).myConverterData.key == 0 && !err.isError() && ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment) {
                                err = CoderResult.malformedForLength(source.position() - mySourceBefore);
                                this.toULength = toULengthBefore + (source.position() - mySourceBefore);
                            }
                            if (err.isError()) {
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                                return err;
                            }
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.key != 0) continue block13;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = true;
                            continue block13;
                        }
                        case 10: 
                        case 13: {
                            if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[0] != 0 && ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[0] != 3) {
                                ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State).cs[0] = 0;
                            }
                            ((ISO2022State)((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State).cs[2] = 0;
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = (byte)0;
                        }
                        default: {
                            ((CharsetISO2022)CharsetISO2022.this).myConverterData.isEmptySegment = false;
                            csTemp = cs = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.cs[((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g];
                            if (gotoGetTrail) {
                                csTemp = -103;
                            }
                            if (!gotoGetTrail && mySourceChar >= 161 && mySourceChar <= 223 && ((CharsetISO2022)CharsetISO2022.this).myConverterData.version == 4 && !CharsetISO2022.IS_JP_DBCS(cs)) {
                                targetUniChar = mySourceChar + 65216;
                                if (((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g < 2) break;
                                ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                break;
                            }
                            switch (csTemp) {
                                case 0: {
                                    if (mySourceChar > 127) break block0;
                                    targetUniChar = mySourceChar;
                                    break block0;
                                }
                                case 1: {
                                    if (mySourceChar <= 127) {
                                        targetUniChar = mySourceChar + 128;
                                    }
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                    break block0;
                                }
                                case 2: {
                                    if (mySourceChar <= 127) {
                                        targetUniChar = CharsetMBCS.MBCS_SINGLE_SIMPLE_GET_NEXT_BMP(((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[cs].mbcs, mySourceChar + 128);
                                    }
                                    ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.g = ((CharsetISO2022)CharsetISO2022.this).myConverterData.toU2022State.prevG;
                                    break block0;
                                }
                                case 3: {
                                    if (mySourceChar > 127) break block0;
                                    targetUniChar = this.jisx201ToU(mySourceChar);
                                    break block0;
                                }
                                case 8: {
                                    if (mySourceChar >= 33 && mySourceChar <= 95) {
                                        targetUniChar = mySourceChar + 65344;
                                        break block0;
                                    }
                                }
                                default: {
                                    if (gotoGetTrail || source.hasRemaining()) {
                                        boolean trailIsOk;
                                        gotoGetTrail = false;
                                        short trailByte = (short)(source.get(source.position()) & 0xFF);
                                        boolean leadIsOk = (short)(0xFF & mySourceChar - 33) <= 93;
                                        boolean bl = trailIsOk = (short)(0xFF & trailByte - 33) <= 93;
                                        if (leadIsOk && trailIsOk) {
                                            source.get();
                                            int tmpSourceChar = mySourceChar << 8 | trailByte;
                                            if (cs == 4) {
                                                this._2022ToSJIS((char)mySourceChar, (char)trailByte, tempBuf);
                                                mySourceChar = tmpSourceChar;
                                            } else {
                                                mySourceChar = tmpSourceChar;
                                                if (cs == 7) {
                                                    tmpSourceChar += 32896;
                                                }
                                                tempBuf[0] = (byte)(0xFF & tmpSourceChar >> 8);
                                                tempBuf[1] = (byte)(0xFF & tmpSourceChar);
                                            }
                                            targetUniChar = CharsetISO2022.this.MBCSSimpleGetNextUChar(((CharsetISO2022)CharsetISO2022.this).myConverterData.myConverterArray[cs], ByteBuffer.wrap(tempBuf), false);
                                            break block0;
                                        }
                                        if (trailIsOk || CharsetISO2022.IS_2022_CONTROL(trailByte)) break block0;
                                        source.get();
                                        mySourceChar = 0x10000 | mySourceChar << 8 | trailByte;
                                        break block0;
                                    }
                                    this.toUBytesArray[0] = (byte)mySourceChar;
                                    this.toULength = 1;
                                    return err;
                                }
                            }
                        }
                    }
                    if (targetUniChar < 65534) {
                        if (offsets != null) {
                            offsets.put(target.remaining(), source.remaining() - (mySourceChar <= 255 ? 1 : 2));
                        }
                        target.put((char)targetUniChar);
                        continue;
                    }
                    if (targetUniChar > 65535) {
                        target.put((char)(55296 + (char)((targetUniChar -= 65536) >> 10)));
                        target.position(target.position() - 1);
                        if (offsets != null) {
                            offsets.put(target.remaining(), source.remaining() - (mySourceChar <= 255 ? 1 : 2));
                        }
                        target.get();
                        if (target.hasRemaining()) {
                            target.put((char)(56320 + (char)(targetUniChar & 0x3FF)));
                            target.position(target.position() - 1);
                            if (offsets != null) {
                                offsets.put(target.remaining(), source.remaining() - (mySourceChar <= 255 ? 1 : 2));
                            }
                            target.get();
                            continue;
                        }
                        this.charErrorBufferArray[this.charErrorBufferLength++] = (char)(56320 + (char)(targetUniChar & 0x3FF));
                        continue;
                    }
                    err = CharsetISO2022.toUnicodeCallback(this, mySourceChar, targetUniChar);
                    break;
                }
                err = CoderResult.OVERFLOW;
                break;
            }
            return err;
        }
    }

    private static class UConverterDataISO2022 {
        UConverterSharedData[] myConverterArray = new UConverterSharedData[10];
        CharsetMBCS.CharsetEncoderMBCS currentEncoder;
        CharsetMBCS.CharsetDecoderMBCS currentDecoder;
        CharsetMBCS currentConverter;
        int currentType = 0;
        ISO2022State toU2022State = new ISO2022State();
        ISO2022State fromU2022State = new ISO2022State();
        int key = 0;
        int version = 0;
        boolean isEmptySegment = false;

        UConverterDataISO2022() {
        }

        void reset() {
            this.toU2022State.reset();
            this.fromU2022State.reset();
            this.isEmptySegment = false;
        }
    }

    private static class ISO2022State {
        private byte[] cs = new byte[4];
        private byte g;
        private byte prevG;

        ISO2022State() {
        }

        void reset() {
            Arrays.fill(this.cs, (byte)0);
            this.g = 0;
            this.prevG = 0;
        }
    }
}

