/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.impl.file.LeastRecentlyUsedCache;
import edu.smu.tspell.wordnet.impl.file.Morphology;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexReader;
import edu.smu.tspell.wordnet.impl.file.SynsetFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class WordFormLookup {
    private static final int DEFAULT_CACHE_SIZE = 500;
    private static int cacheSize = 500;
    private static WordFormLookup instance;
    private Map wordCategories = new WeakHashMap();
    private LeastRecentlyUsedCache cache = new LeastRecentlyUsedCache(cacheSize);

    public static synchronized WordFormLookup getInstance() {
        if (instance == null) {
            instance = new WordFormLookup();
        }
        return instance;
    }

    private WordFormLookup() {
    }

    public synchronized Synset[] getSynsets(String wordForm, SynsetType[] types, boolean useMorphology) throws WordNetException {
        Synset[] synsetArray;
        ArrayList<Synset> synsetList = new ArrayList<Synset>();
        for (int i = 0; i < types.length; ++i) {
            int j;
            synsetArray = this.getSynsets(wordForm, types[i]);
            for (j = 0; j < synsetArray.length; ++j) {
                if (synsetList.contains(synsetArray[j])) continue;
                synsetList.add(synsetArray[j]);
            }
            if (!useMorphology) continue;
            String[] candidates = this.getBaseFormCandidates(wordForm, types[i]);
            for (j = 0; j < candidates.length; ++j) {
                synsetArray = this.getSynsets(candidates[j], types[i]);
                for (int k = 0; k < synsetArray.length; ++k) {
                    if (synsetList.contains(synsetArray[k])) continue;
                    synsetList.add(synsetArray[k]);
                }
            }
        }
        synsetArray = new Synset[synsetList.size()];
        synsetList.toArray(synsetArray);
        return synsetArray;
    }

    private Synset[] getSynsets(String wordForm, SynsetType type) {
        List typeList;
        ArrayList synsetList = new ArrayList();
        Map subMap = (Map)this.wordCategories.get(wordForm);
        if (subMap == null) {
            subMap = this.loadSynsets(wordForm);
            this.wordCategories.put(wordForm, subMap);
            this.cache.put(wordForm, wordForm);
        }
        if ((typeList = (List)subMap.get(type)) != null) {
            int count = typeList.size();
            for (int j = 0; j < count; ++j) {
                if (synsetList.contains(typeList.get(j))) continue;
                synsetList.add(typeList.get(j));
            }
        }
        Synset[] synsetArray = new Synset[synsetList.size()];
        synsetList.toArray(synsetArray);
        return synsetArray;
    }

    private Map loadSynsets(String wordForm) throws WordNetException {
        TreeMap<SynsetType, ArrayList<Synset>> subMap = new TreeMap<SynsetType, ArrayList<Synset>>();
        SenseIndexReader reader = SenseIndexReader.getInstance();
        Object[] indexEntries = reader.getLemmaEntries(wordForm);
        Arrays.sort(indexEntries);
        SynsetFactory factory = SynsetFactory.getInstance();
        for (int i = 0; i < indexEntries.length; ++i) {
            Synset synset = factory.getSynset(((SenseIndexEntry)indexEntries[i]).getSynsetPointer());
            SynsetType type = synset.getType();
            ArrayList<Synset> categoryList = (ArrayList<Synset>)subMap.get(type);
            if (categoryList == null) {
                categoryList = new ArrayList<Synset>();
                subMap.put(type, categoryList);
            }
            categoryList.add(synset);
        }
        return subMap;
    }

    private String[] getBaseFormCandidates(String inflection, SynsetType type) {
        Morphology morphology = Morphology.getInstance();
        return morphology.getBaseFormCandidates(inflection, type);
    }

    static {
        String propertyName = "wordnet.cache.words";
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                cacheSize = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException nfe) {
                System.err.println("'" + propertyValue + "' is an invalid " + "value for " + propertyName + " and will be ignored.");
            }
        }
    }
}

