/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;

public class SenseKey
implements Comparable {
    public static final String LEMMA_TERMINATOR = "%";
    public static final String FIELD_DELIMITER = ":";
    private String lemma;
    private SynsetType type;
    private int lexicalFileNumber;
    private int lexicalID;
    private SenseKey headWord;

    public SenseKey(String lemma, SynsetType type, int lexicalFileNumber, int lexicalID, SenseKey headWord) {
        this.lemma = lemma;
        this.type = type;
        this.lexicalFileNumber = lexicalFileNumber;
        this.lexicalID = lexicalID;
        this.headWord = headWord;
    }

    public SenseKey(String lemma, SynsetType type, int lexicalFileNumber, int lexicalID) {
        this(lemma, type, lexicalFileNumber, lexicalID, null);
    }

    public String getLemma() {
        return this.lemma;
    }

    public SynsetType getType() {
        return this.type;
    }

    public int getLexicalFileNumber() {
        return this.lexicalFileNumber;
    }

    public int getLexicalID() {
        return this.lexicalID;
    }

    public SenseKey getHeadWord() {
        return this.headWord;
    }

    public int compareTo(Object o) {
        int relativeValue = 1;
        if (o != null) {
            SenseKey target = (SenseKey)o;
            relativeValue = this.getType().compareTo(target.getType());
            if (relativeValue == 0 && (relativeValue = this.getLemma().compareTo(target.getLemma())) == 0 && (relativeValue = this.getLexicalID() - target.getLexicalID()) == 0) {
                relativeValue = this.getLexicalFileNumber() - target.getLexicalFileNumber();
            }
        }
        return relativeValue;
    }

    public int hashCode() {
        return this.lemma.hashCode();
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof SenseKey) {
            SenseKey target = (SenseKey)o;
            isEqual = this.getType().equals(target.getType()) && this.getLemma().equals(target.getLemma()) && this.getLexicalFileNumber() == target.getLexicalFileNumber() && this.getLexicalID() == target.getLexicalID();
        }
        return isEqual;
    }

    public String toString() {
        return this.getFullSenseKeyText();
    }

    public String getPartialSenseKeyText() {
        String fullText = this.getFullSenseKeyText();
        int index = fullText.lastIndexOf(FIELD_DELIMITER);
        index = fullText.lastIndexOf(FIELD_DELIMITER, index - 1);
        return fullText.substring(0, index + 1);
    }

    public String getFullSenseKeyText() {
        return TextTranslator.translateToDatabaseFormat(this.getLemma()) + LEMMA_TERMINATOR + this.getLexicalSense();
    }

    private String getLexicalSense() {
        return this.type.getCode() + FIELD_DELIMITER + this.pad(this.getLexicalFileNumber(), 2) + FIELD_DELIMITER + this.pad(this.getLexicalID(), 2) + FIELD_DELIMITER + (this.headWord != null ? this.headWord.getLemma() : "") + FIELD_DELIMITER + (this.headWord != null ? this.pad(this.headWord.getLexicalID(), 2) : "");
    }

    private String pad(int value, int digits) {
        StringBuffer buffer = new StringBuffer(Integer.toString(value));
        while (buffer.length() < digits) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }
}

