/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl;

import edu.smu.tspell.wordnet.impl.LineLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public abstract class MultipleLineLocator
extends LineLocator {
    public MultipleLineLocator(String parent, String child) throws IOException {
        super(new File(parent, child));
    }

    protected String[] getLines(String prefix) throws IOException {
        return this.getLines(prefix, prefix);
    }

    protected synchronized String[] getLines(String first, String last) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        String line = this.getLine(first);
        if (line != null) {
            lineList.add(line);
            long start = this.getFilePointer() - (long)line.length() - 2L;
            line = this.readToNextEndOfLine();
            while ((line.compareTo(last) <= 0 || line.startsWith(last)) && line.length() > 0) {
                lineList.add(line);
                line = this.readToNextEndOfLine();
            }
            if (start > 0L) {
                line = this.readToPriorEndOfLine(start);
                while (line.compareTo(first) >= 0) {
                    lineList.add(0, line);
                    if ((start -= (long)(line.length() + 1)) < 0L) break;
                    line = this.readToPriorEndOfLine(start);
                }
            }
        }
        String[] lineArray = new String[lineList.size()];
        lineList.toArray(lineArray);
        return lineArray;
    }
}

