/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import net.sf.jlinkgrammar.DictNode;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Disjunct;
import net.sf.jlinkgrammar.Exp;
import net.sf.jlinkgrammar.XNode;

public class Word {
    public String string;
    public XNode x;
    public Disjunct d;
    public boolean firstupper;
    public boolean is_conjunction = false;

    private void special_string(String s, Dictionary dict) {
        if (dict.boolean_dictionary_lookup(s)) {
            XNode e = this.x = Word.build_word_expressions(s, dict);
            while (e != null) {
                e.string = this.string;
                e = e.next;
            }
        } else {
            throw new RuntimeException("Can't build expressions. To process this sentence your dictionary needs the word \"" + s + "\"");
        }
    }

    public static XNode build_word_expressions(String s, Dictionary dict) {
        DictNode dn = dict.dictionary_lookup(s);
        XNode x = null;
        while (dn != null) {
            XNode y = new XNode();
            y.next = x;
            x = y;
            x.exp = Exp.copy_Exp(dn.exp);
            x.string = dn.string;
            dn = dn.right;
        }
        return x;
    }

    public Word(String s, Dictionary dict) {
        this.string = s;
        if (dict.boolean_dictionary_lookup(s)) {
            this.x = Word.build_word_expressions(s, dict);
        } else if (Character.isUpperCase(s.charAt(0)) && Dictionary.is_s_word(s) && dict.pl_capitalized_word_defined) {
            this.special_string("PL-CAPITALIZED-WORDS", dict);
        } else if (Character.isUpperCase(s.charAt(0)) && dict.capitalized_word_defined) {
            this.special_string("CAPITALIZED-WORDS", dict);
        } else if (Dictionary.is_number(s) && dict.number_word_defined) {
            this.special_string("NUMBERS", dict);
        } else if (Dictionary.ishyphenated(s) && dict.hyphenated_word_defined) {
            this.special_string("HYPHENATED-WORDS", dict);
        } else if (Dictionary.is_ing_word(s) && dict.ing_word_defined) {
            this.guessed_string(s, "ING-WORDS", dict);
        } else if (Dictionary.is_s_word(s) && dict.s_word_defined) {
            this.guessed_string(s, "S-WORDS", dict);
        } else if (Dictionary.is_ed_word(s) && dict.ed_word_defined) {
            this.guessed_string(s, "ED-WORDS", dict);
        } else if (Dictionary.is_ly_word(s) && dict.ly_word_defined) {
            this.guessed_string(s, "LY-WORDS", dict);
        } else if (dict.unknown_word_defined && dict.use_unknown_word) {
            this.handle_unknown_word(s, dict);
        } else {
            throw new RuntimeException("I should have found that word.");
        }
    }

    private void guessed_string(String s, String type, Dictionary dict) {
        if (dict.boolean_dictionary_lookup(type)) {
            XNode e = this.x = Word.build_word_expressions(type, dict);
            if (Dictionary.is_s_word(s)) {
                while (e != null) {
                    int t = e.string.indexOf(46);
                    e.string = t >= 0 ? s + "[!]." + s.substring(t + 1) : s + "[!]";
                    e = e.next;
                }
            } else {
                e.string = Dictionary.is_ed_word(s) ? s + "[!].v" : (Dictionary.is_ing_word(s) ? s + "[!].g" : (Dictionary.is_ly_word(s) ? s + "[!].e" : s + "[!]"));
            }
        } else {
            throw new RuntimeException("Can't build expressions. To process this sentence your dictionary needs the word \"" + type + "\"");
        }
    }

    private void handle_unknown_word(String s, Dictionary dict) {
        XNode d = this.x = Word.build_word_expressions("UNKNOWN-WORD", dict);
        while (d != null) {
            int t = d.string.indexOf(46);
            StringBuffer str = new StringBuffer();
            if (t >= 0) {
                str.append(s + "[?]." + d.string.substring(t + 1));
            } else {
                str.append(s + "[?]");
            }
            d.string = str.toString();
            d = d.next;
        }
    }
}

