/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import net.sf.jlinkgrammar.Connector;
import net.sf.jlinkgrammar.GlobalBean;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.Sentence;

public class Disjunct {
    Disjunct next;
    int cost;
    boolean marked;
    String string;
    Connector left;
    Connector right;
    static int dup_table_size;
    static Disjunct[] dup_table;

    Disjunct(Disjunct d) {
        this.next = d.next;
        this.cost = d.cost;
        this.marked = d.marked;
        this.string = d.string;
        this.left = d.left;
        this.right = d.right;
    }

    Disjunct() {
    }

    static Disjunct catenate_disjuncts(Disjunct d1, Disjunct d2) {
        Disjunct dis = d1;
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        while (dis.next != null) {
            dis = dis.next;
        }
        dis.next = d2;
        return d1;
    }

    static Disjunct eliminate_duplicate_disjuncts(ParseOptions opts, Disjunct d) {
        Disjunct dx;
        Disjunct dn;
        int i;
        int count = 0;
        dup_table_size = MyRandom.next_power_of_two_up(2 * Disjunct.count_disjuncts(d));
        dup_table = new Disjunct[dup_table_size];
        for (i = 0; i < dup_table_size; ++i) {
            Disjunct.dup_table[i] = null;
        }
        while (d != null) {
            dn = d.next;
            int h = d.old_hash_disjunct();
            dx = dup_table[h];
            while (dx != null && !dx.disjuncts_equal(d)) {
                dx = dx.next;
            }
            if (dx == null) {
                d.next = dup_table[h];
                Disjunct.dup_table[h] = d;
            } else {
                d.next = null;
                if (d.cost < dx.cost) {
                    dx.cost = d.cost;
                }
                ++count;
            }
            d = dn;
        }
        for (i = 0; i < dup_table_size; ++i) {
            dn = dup_table[i];
            while (dn != null) {
                dx = dn.next;
                dn.next = d;
                d = dn;
                dn = dx;
            }
        }
        if (opts.verbosity > 2 && count != 0) {
            opts.out.println("killed " + count + " duplicates");
        }
        return d;
    }

    static int count_disjuncts(Disjunct d) {
        int count = 0;
        while (d != null) {
            ++count;
            d = d.next;
        }
        return count;
    }

    boolean disjuncts_equal(Disjunct d2) {
        Connector e1 = this.left;
        Connector e2 = d2.left;
        while (e1 != null && e2 != null && e1.connectors_equal_prune(e2)) {
            e1 = e1.next;
            e2 = e2.next;
        }
        if (e1 != null || e2 != null) {
            return false;
        }
        e1 = this.right;
        e2 = d2.right;
        while (e1 != null && e2 != null && e1.connectors_equal_prune(e2)) {
            e1 = e1.next;
            e2 = e2.next;
        }
        if (e1 != null || e2 != null) {
            return false;
        }
        return this.string.equals(d2.string);
    }

    int old_hash_disjunct() {
        int i = 0;
        Connector e = this.left;
        while (e != null) {
            i = Disjunct.string_hash(e.string, i);
            e = e.next;
        }
        e = this.right;
        while (e != null) {
            i = Disjunct.string_hash(e.string, i);
            e = e.next;
        }
        return Disjunct.string_hash(this.string, i);
    }

    static int string_hash(String s, int i) {
        for (int j = 0; j < s.length(); ++j) {
            i = i + (i << 1) + MyRandom.randtable[s.charAt(j) + i & 0xFF];
        }
        return i & dup_table_size - 1;
    }

    boolean disjunct_types_equal(Disjunct d2) {
        Connector e1 = this.left;
        Connector e2 = d2.left;
        while (e1 != null && e2 != null && e1.connector_types_equal(e2)) {
            e1 = e1.next;
            e2 = e2.next;
        }
        if (e1 != null || e2 != null) {
            return false;
        }
        e1 = this.right;
        e2 = d2.right;
        while (e1 != null && e2 != null && e1.connector_types_equal(e2)) {
            e1 = e1.next;
            e2 = e2.next;
        }
        return e1 == null && e2 == null;
    }

    boolean disjuncts_equal_AND(Disjunct d2) {
        ++GlobalBean.STAT_calls_to_equality_test;
        Connector e1 = this.left;
        Connector e2 = d2.left;
        while (e1 != null && e2 != null && e1.connectors_equal_AND(e2)) {
            e1 = e1.next;
            e2 = e2.next;
        }
        if (e1 != null || e2 != null) {
            return false;
        }
        e1 = this.right;
        e2 = d2.right;
        while (e1 != null && e2 != null && e1.connectors_equal_AND(e2)) {
            e1 = e1.next;
            e2 = e2.next;
        }
        return e1 == null && e2 == null;
    }

    Disjunct intersect_disjuncts(Disjunct d2) {
        Disjunct d = Disjunct.copy_disjunct(this);
        Connector c = d.left;
        Connector c1 = this.left;
        Connector c2 = d2.left;
        while (c1 != null) {
            c.string = Sentence.intersect_strings(c1.string, c2.string);
            c.multi = c1.multi && c2.multi;
            c = c.next;
            c1 = c1.next;
            c2 = c2.next;
        }
        c = d.right;
        c1 = this.right;
        c2 = d2.right;
        while (c1 != null) {
            c.string = Sentence.intersect_strings(c1.string, c2.string);
            c.multi = c1.multi && c2.multi;
            c = c.next;
            c1 = c1.next;
            c2 = c2.next;
        }
        return d;
    }

    int and_hash_disjunct() {
        int i = 0;
        Connector e = this.left;
        while (e != null) {
            i = e.and_connector_hash(i);
            e = e.next;
        }
        i = i + (i << 1) + MyRandom.randtable[i & 0xFF];
        e = this.right;
        while (e != null) {
            i = e.and_connector_hash(i);
            e = e.next;
        }
        return i & 0x3FF;
    }

    static Disjunct copy_disjunct(Disjunct d) {
        if (d == null) {
            return null;
        }
        Disjunct d1 = new Disjunct(d);
        d1.next = null;
        d1.left = Connector.copy_connectors(d.left);
        d1.right = Connector.copy_connectors(d.right);
        return d1;
    }
}

