/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml.jdom;

import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.AbstractFilter;

public class ElementsFilter
extends AbstractFilter<Element> {
    private static final long serialVersionUID = 200L;
    private String[] names;
    private Namespace namespace;

    public ElementsFilter() {
    }

    public ElementsFilter(String[] names) {
        this.names = names;
    }

    public ElementsFilter(Namespace namespace) {
        this.namespace = namespace;
    }

    public ElementsFilter(String[] names, Namespace namespace) {
        this.names = names;
        this.namespace = namespace;
    }

    public Element filter(Object content) {
        if (content instanceof Element) {
            Element el = (Element)content;
            if (this.names == null) {
                if (this.namespace == null) {
                    return el;
                }
                return this.namespace.equals((Object)el.getNamespace()) ? el : null;
            }
            boolean found = false;
            String name = el.getName();
            for (int i = 0; i < this.names.length && !(found = name.equals(this.names[i])); ++i) {
            }
            if (!found) {
                return null;
            }
            if (this.namespace == null) {
                return el;
            }
            return this.namespace.equals((Object)el.getNamespace()) ? el : null;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementsFilter)) {
            return false;
        }
        ElementsFilter filter = (ElementsFilter)((Object)obj);
        if (this.names != null ? !this.names.equals(filter.names) : filter.names != null) {
            return false;
        }
        return !(this.namespace != null ? !this.namespace.equals((Object)filter.namespace) : filter.namespace != null);
    }

    public int hashCode() {
        int result = this.names != null ? this.names.hashCode() : 0;
        result = 29 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[ElementFilter: Names " + (this.names == null ? "*any*" : this.names) + " with Namespace " + this.namespace + "]";
    }
}

