/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml;

import edu.northwestern.at.utils.MapFactory;
import java.io.File;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

public class XSLTCache {
    protected static Map<String, MapEntry> cache = MapFactory.createNewMap();

    public static synchronized void flushAll() {
        cache.clear();
    }

    public static synchronized void flush(String xsltFileName) {
        cache.remove(xsltFileName);
    }

    public static synchronized Transformer newTransformer(String xsltFileName) throws TransformerConfigurationException {
        File xsltFile = new File(xsltFileName);
        long xslLastModified = xsltFile.lastModified();
        MapEntry entry = cache.get(xsltFileName);
        if (entry != null && xslLastModified > entry.lastModified) {
            entry = null;
        }
        if (entry == null) {
            StreamSource xslSource = new StreamSource(xsltFile);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Templates templates = transFact.newTemplates(xslSource);
            entry = new MapEntry(xslLastModified, templates);
            cache.put(xsltFileName, entry);
        }
        return entry.templates.newTransformer();
    }

    protected XSLTCache() {
    }

    static class MapEntry {
        long lastModified;
        Templates templates;

        MapEntry(long lastModified, Templates templates) {
            this.lastModified = lastModified;
            this.templates = templates;
        }
    }
}

