/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMUtils {
    public static Document parse(File file) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(file);
    }

    public static Document parse(String path) throws IOException, ParserConfigurationException, SAXException {
        return DOMUtils.parse(new File(path));
    }

    public static Document parse(URL url) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(url.openStream());
    }

    public static Document parseText(String text) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(text)));
    }

    public static Element getChild(Node node, String name) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element findChild(Node parent, String namePat) {
        Element result = null;
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().matches(namePat)) continue;
                result = (Element)child;
                break;
            }
        }
        return result;
    }

    public static Element getLastChild(Node node, String name) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = numChildren - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Element getChild(Node node, String name, String attrName, String attrValue) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Element el;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name) || !attrValue.equals((el = (Element)child).getAttribute(attrName))) continue;
            return el;
        }
        return null;
    }

    public static String getText(Node node) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            return child.getNodeValue().trim();
        }
        return "";
    }

    public static void setText(Node node, String text) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            child.setNodeValue(text);
            return;
        }
        Text child = node.getOwnerDocument().createTextNode(text);
        node.appendChild(child);
    }

    public static String getAllText(Node node) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        String result = "";
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            result = result + child.getNodeValue();
        }
        return result.trim();
    }

    public static List<Node> getChildren(Node node, String name) {
        List<Node> result = ListFactory.createNewList();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result;
    }

    public static List<Node> findChildren(Node node, String name) {
        List<Node> result = ListFactory.createNewList();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().matches(name)) continue;
            result.add(child);
        }
        return result;
    }

    public static List<Element> getChildren(Node node, String name, String attrName, String attrValue) {
        List<Node> children = DOMUtils.getChildren(node, name);
        List<Element> result = ListFactory.createNewList();
        for (Element element : children) {
            if (!element.getAttribute(attrName).equals(attrValue)) continue;
            result.add(element);
        }
        return result;
    }

    public static Element getDescendant(Node node, String path) {
        StringTokenizer tok = new StringTokenizer(path, "/");
        while (tok.hasMoreTokens()) {
            if ((node = DOMUtils.getChild(node, tok.nextToken())) != null) continue;
            return null;
        }
        return (Element)node;
    }

    public static List<Node> getDescendants(Node node, String path) {
        int k = path.indexOf(47);
        String name = k < 0 ? path : path.substring(0, k);
        List<Node> children = DOMUtils.getChildren(node, name);
        if (k < 0) {
            return children;
        }
        List<Node> result = ListFactory.createNewList();
        String remaining = path.substring(k + 1);
        for (Node child : children) {
            result.addAll(DOMUtils.getDescendants(child, remaining));
        }
        return result;
    }

    public static void addDescendants(Node node, List<Node> descendants) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            descendants.add(child);
            DOMUtils.addDescendants(child, descendants);
        }
    }

    public static List<Node> getDescendants(Node node) {
        List<Node> result = ListFactory.createNewList();
        DOMUtils.addDescendants(node, result);
        return result;
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static DocumentFragment parseXML(Document doc, String fragment) {
        fragment = "<fragment>" + fragment + "</fragment>";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(fragment)));
            Node node = doc.importNode(d.getDocumentElement(), true);
            DocumentFragment docfrag = doc.createDocumentFragment();
            while (node.hasChildNodes()) {
                docfrag.appendChild(node.removeChild(node.getFirstChild()));
            }
            return docfrag;
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void save(Document document, String path) throws TransformerException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        PrintWriter pw = new PrintWriter(new FileOutputStream(path));
        StreamResult destination = new StreamResult(pw);
        transformer.transform(source, destination);
        pw.close();
    }

    public static void save(Document document, String dtdName, String path) throws TransformerException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("doctype-system", dtdName);
        PrintWriter pw = new PrintWriter(new FileOutputStream(path));
        StreamResult destination = new StreamResult(pw);
        transformer.transform(source, destination);
        pw.close();
    }

    public static String saveToString(Document document) throws TransformerException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        StringWriter sw = new StringWriter();
        StreamResult destination = new StreamResult(sw);
        transformer.transform(source, destination);
        return sw.toString();
    }

    public static String saveToString(Document document, String dtdName) throws TransformerException, IOException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("doctype-system", dtdName);
        StringWriter sw = new StringWriter();
        StreamResult destination = new StreamResult(sw);
        transformer.transform(source, destination);
        return sw.toString();
    }

    public static boolean nodeHasDescendant(Node node, String[] names1, String[] names2) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            for (int j = 0; j < names1.length; ++j) {
                if (!childName.equals(names1[j])) continue;
                return true;
            }
            boolean isInNames2 = false;
            for (int j = 0; j < names2.length; ++j) {
                if (!childName.equals(names2[j])) continue;
                isInNames2 = true;
                break;
            }
            if (isInNames2 || !DOMUtils.nodeHasDescendant(child, names1, names2)) continue;
            return true;
        }
        return false;
    }

    public static void validateDocument(Document document, Schema schema) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(document);
        validator.validate(source);
    }

    public static Map<String, String> attributesToSortedMap(Attributes attributes) {
        Map<String, String> result = MapFactory.createNewSortedMap();
        if (attributes != null) {
            int l = attributes.getLength();
            for (int i = 0; i < l; ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                result.put(name, value);
            }
        }
        return result;
    }

    public static NodeList getNodesByTagName(Document document, String[] tagNames) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        String matchExpression = "";
        for (int i = 0; i < tagNames.length; ++i) {
            if (i > 0) {
                matchExpression = matchExpression + "|";
            }
            matchExpression = matchExpression + "//" + tagNames[i];
        }
        NodeList wordNodes = null;
        try {
            XPathExpression expr = xPath.compile(matchExpression);
            wordNodes = (NodeList)expr.evaluate(document, XPathConstants.NODESET);
        }
        catch (Exception e) {
            // empty catch block
        }
        return wordNodes;
    }

    private DOMUtils() {
        throw new UnsupportedOperationException();
    }
}

