/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.spellcheck;

import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TernaryTrie;
import edu.northwestern.at.utils.spellcheck.SpellingDictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TernaryTrieSpellingDictionary
implements SpellingDictionary {
    protected TernaryTrie trie;
    protected String wordListFileName;
    protected boolean debug = false;
    protected static final int MAXDIFFS = 2;

    public TernaryTrieSpellingDictionary(Map<String, String> wordsMap) {
        this.wordListFileName = "";
        try {
            this.trie = new TernaryTrie(wordsMap, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TernaryTrieSpellingDictionary(Set<String> wordsSet) {
        this.wordListFileName = "";
        try {
            this.trie = new TernaryTrie(wordsSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TernaryTrieSpellingDictionary(List<String> wordsList) {
        this.wordListFileName = "";
        try {
            this.trie = new TernaryTrie(wordsList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TernaryTrieSpellingDictionary(TaggedStrings wordsList) {
        this.wordListFileName = "";
        try {
            this.trie = new TernaryTrie(wordsList, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TernaryTrieSpellingDictionary(TernaryTrie trie) {
        this.trie = trie;
    }

    @Override
    public boolean lookupWord(String word) {
        if (word == null || word.length() <= 0) {
            return true;
        }
        String lowerCaseWord = word.toLowerCase();
        return this.trie.containsString(lowerCaseWord);
    }

    private boolean addWordPrivate(String word) {
        this.trie.put(word, new Double(0.0));
        return true;
    }

    @Override
    public boolean addWord(String word) {
        return this.addWordPrivate(word);
    }

    @Override
    public boolean addWords(String[] words) {
        boolean result = true;
        for (int i = 0; i < words.length; ++i) {
            boolean added = this.addWord(words[i]);
            result = result && added;
        }
        return result;
    }

    @Override
    public Set<String> getRelatedWords(String word) {
        Set<String> result = null;
        if (word != null && word.length() > 0) {
            result = this.findMostSimilarSet(word);
        }
        return result;
    }

    public Set<String> findMostSimilarSet(String word) {
        String suggestion;
        int j;
        int i;
        Set<String> result = SetFactory.createNewSet();
        int size = word.length();
        if (size == 0) {
            return null;
        }
        int maxSuggestions = 1;
        String savedWord = word;
        for (maxSuggestions = 1; maxSuggestions <= 2 && size >= maxSuggestions * 2; ++maxSuggestions) {
            result.addAll(this.trie.nearSearch(word, maxSuggestions));
        }
        if (result.size() == 0 && size > 2) {
            for (maxSuggestions = 0; maxSuggestions <= 1; ++maxSuggestions) {
                for (i = size - 1; i >= 0; --i) {
                    result.addAll(this.trie.nearSearch(word.substring(0, i) + word.substring(i + 1, size), maxSuggestions));
                    for (j = 97; j < 122; ++j) {
                        result.addAll(this.trie.nearSearch(word.substring(0, i) + (char)j + word.substring(i, size), maxSuggestions));
                    }
                }
            }
        }
        if (result.size() == 0) {
            j = 1;
            for (i = 1; i < size; ++i) {
                if (word.charAt(i) == word.charAt(i - 1)) {
                    suggestion = word.substring(0, j) + word.substring(i + 1, size);
                    if (this.trie.get(suggestion) == null) continue;
                    result.add(suggestion);
                    continue;
                }
                j = i + 1;
            }
        }
        if (result.size() == 0) {
            for (i = 0; i < size - 1; ++i) {
                StringBuffer sugBuf = new StringBuffer(word);
                char ci = sugBuf.charAt(i);
                char ci1 = sugBuf.charAt(i + 1);
                sugBuf.setCharAt(i + 1, ci);
                sugBuf.setCharAt(i, ci1);
                suggestion = sugBuf.toString();
                result.addAll(this.trie.nearSearch(suggestion, 1));
            }
        }
        if (result.size() == 0) {
            result.addAll(this.trie.prefixSearch(word));
        }
        if (result.size() == 0) {
            for (i = 1; i < size - 1; ++i) {
                if (word.charAt(i) != word.charAt(i - 1)) continue;
                suggestion = word.substring(0, i) + word.substring(i + 1, size);
                result.addAll(this.trie.nearSearch(suggestion, 1));
            }
        }
        return result;
    }

    @Override
    public Set<String> getAllWords() {
        return this.trie.getAllStrings();
    }

    @Override
    public int getNumberOfWords() {
        return this.trie.getAllStrings().size();
    }

    @Override
    public void clear() {
    }

    public Set<String> getMoreRelatedWords(String word) {
        Set<String> result = SetFactory.createNewSet();
        if (word != null && word.length() > 0) {
            int l = word.length();
            int k = 0;
            for (int i = 3; i < Math.min(l / 2, 10); ++i) {
                List<String> nearSearches = this.trie.nearSearch(word.toLowerCase(), i);
                if (nearSearches.size() <= 0) continue;
                result.addAll(nearSearches);
                if (++k >= 2) break;
            }
        }
        return result;
    }
}

